// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `AcceptReservedNodeExchange` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AcceptReservedNodeExchangeError {
    /// Kind of error that occurred.
    pub kind: AcceptReservedNodeExchangeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AcceptReservedNodeExchange` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AcceptReservedNodeExchangeErrorKind {
    /// <p>Your request cannot be completed because a dependent internal service is
    /// temporarily unavailable. Wait 30 to 60 seconds and try again.</p>
    DependentServiceUnavailableFault(crate::error::DependentServiceUnavailableFault),
    /// <p>Indicates that the Reserved Node being exchanged is not in an active state.</p>
    InvalidReservedNodeStateFault(crate::error::InvalidReservedNodeStateFault),
    /// <p>User already has a reservation with the given identifier.</p>
    ReservedNodeAlreadyExistsFault(crate::error::ReservedNodeAlreadyExistsFault),
    /// <p>Indicates that the reserved node has already been exchanged.</p>
    ReservedNodeAlreadyMigratedFault(crate::error::ReservedNodeAlreadyMigratedFault),
    /// <p>The specified reserved compute node not found.</p>
    ReservedNodeNotFoundFault(crate::error::ReservedNodeNotFoundFault),
    /// <p>Specified offering does not exist.</p>
    ReservedNodeOfferingNotFoundFault(crate::error::ReservedNodeOfferingNotFoundFault),
    /// <p>The requested operation isn't supported.</p>
    UnsupportedOperationFault(crate::error::UnsupportedOperationFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AcceptReservedNodeExchangeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AcceptReservedNodeExchangeErrorKind::DependentServiceUnavailableFault(_inner) => {
                _inner.fmt(f)
            }
            AcceptReservedNodeExchangeErrorKind::InvalidReservedNodeStateFault(_inner) => {
                _inner.fmt(f)
            }
            AcceptReservedNodeExchangeErrorKind::ReservedNodeAlreadyExistsFault(_inner) => {
                _inner.fmt(f)
            }
            AcceptReservedNodeExchangeErrorKind::ReservedNodeAlreadyMigratedFault(_inner) => {
                _inner.fmt(f)
            }
            AcceptReservedNodeExchangeErrorKind::ReservedNodeNotFoundFault(_inner) => _inner.fmt(f),
            AcceptReservedNodeExchangeErrorKind::ReservedNodeOfferingNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            AcceptReservedNodeExchangeErrorKind::UnsupportedOperationFault(_inner) => _inner.fmt(f),
            AcceptReservedNodeExchangeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AcceptReservedNodeExchangeError {
    fn code(&self) -> Option<&str> {
        AcceptReservedNodeExchangeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AcceptReservedNodeExchangeError {
    /// Creates a new `AcceptReservedNodeExchangeError`.
    pub fn new(kind: AcceptReservedNodeExchangeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AcceptReservedNodeExchangeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AcceptReservedNodeExchangeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AcceptReservedNodeExchangeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AcceptReservedNodeExchangeErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AcceptReservedNodeExchangeErrorKind::DependentServiceUnavailableFault`.
    pub fn is_dependent_service_unavailable_fault(&self) -> bool {
        matches!(
            &self.kind,
            AcceptReservedNodeExchangeErrorKind::DependentServiceUnavailableFault(_)
        )
    }
    /// Returns `true` if the error kind is `AcceptReservedNodeExchangeErrorKind::InvalidReservedNodeStateFault`.
    pub fn is_invalid_reserved_node_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            AcceptReservedNodeExchangeErrorKind::InvalidReservedNodeStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `AcceptReservedNodeExchangeErrorKind::ReservedNodeAlreadyExistsFault`.
    pub fn is_reserved_node_already_exists_fault(&self) -> bool {
        matches!(
            &self.kind,
            AcceptReservedNodeExchangeErrorKind::ReservedNodeAlreadyExistsFault(_)
        )
    }
    /// Returns `true` if the error kind is `AcceptReservedNodeExchangeErrorKind::ReservedNodeAlreadyMigratedFault`.
    pub fn is_reserved_node_already_migrated_fault(&self) -> bool {
        matches!(
            &self.kind,
            AcceptReservedNodeExchangeErrorKind::ReservedNodeAlreadyMigratedFault(_)
        )
    }
    /// Returns `true` if the error kind is `AcceptReservedNodeExchangeErrorKind::ReservedNodeNotFoundFault`.
    pub fn is_reserved_node_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            AcceptReservedNodeExchangeErrorKind::ReservedNodeNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `AcceptReservedNodeExchangeErrorKind::ReservedNodeOfferingNotFoundFault`.
    pub fn is_reserved_node_offering_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            AcceptReservedNodeExchangeErrorKind::ReservedNodeOfferingNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `AcceptReservedNodeExchangeErrorKind::UnsupportedOperationFault`.
    pub fn is_unsupported_operation_fault(&self) -> bool {
        matches!(
            &self.kind,
            AcceptReservedNodeExchangeErrorKind::UnsupportedOperationFault(_)
        )
    }
}
impl std::error::Error for AcceptReservedNodeExchangeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AcceptReservedNodeExchangeErrorKind::DependentServiceUnavailableFault(_inner) => {
                Some(_inner)
            }
            AcceptReservedNodeExchangeErrorKind::InvalidReservedNodeStateFault(_inner) => {
                Some(_inner)
            }
            AcceptReservedNodeExchangeErrorKind::ReservedNodeAlreadyExistsFault(_inner) => {
                Some(_inner)
            }
            AcceptReservedNodeExchangeErrorKind::ReservedNodeAlreadyMigratedFault(_inner) => {
                Some(_inner)
            }
            AcceptReservedNodeExchangeErrorKind::ReservedNodeNotFoundFault(_inner) => Some(_inner),
            AcceptReservedNodeExchangeErrorKind::ReservedNodeOfferingNotFoundFault(_inner) => {
                Some(_inner)
            }
            AcceptReservedNodeExchangeErrorKind::UnsupportedOperationFault(_inner) => Some(_inner),
            AcceptReservedNodeExchangeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AddPartner` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AddPartnerError {
    /// Kind of error that occurred.
    pub kind: AddPartnerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AddPartner` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AddPartnerErrorKind {
    /// <p>The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster.
    /// </p>
    ClusterNotFoundFault(crate::error::ClusterNotFoundFault),
    /// <p>The name of the partner was not found.</p>
    PartnerNotFoundFault(crate::error::PartnerNotFoundFault),
    /// <p>The partner integration is not authorized.</p>
    UnauthorizedPartnerIntegrationFault(crate::error::UnauthorizedPartnerIntegrationFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AddPartnerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AddPartnerErrorKind::ClusterNotFoundFault(_inner) => _inner.fmt(f),
            AddPartnerErrorKind::PartnerNotFoundFault(_inner) => _inner.fmt(f),
            AddPartnerErrorKind::UnauthorizedPartnerIntegrationFault(_inner) => _inner.fmt(f),
            AddPartnerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AddPartnerError {
    fn code(&self) -> Option<&str> {
        AddPartnerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AddPartnerError {
    /// Creates a new `AddPartnerError`.
    pub fn new(kind: AddPartnerErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AddPartnerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AddPartnerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AddPartnerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AddPartnerErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AddPartnerErrorKind::ClusterNotFoundFault`.
    pub fn is_cluster_not_found_fault(&self) -> bool {
        matches!(&self.kind, AddPartnerErrorKind::ClusterNotFoundFault(_))
    }
    /// Returns `true` if the error kind is `AddPartnerErrorKind::PartnerNotFoundFault`.
    pub fn is_partner_not_found_fault(&self) -> bool {
        matches!(&self.kind, AddPartnerErrorKind::PartnerNotFoundFault(_))
    }
    /// Returns `true` if the error kind is `AddPartnerErrorKind::UnauthorizedPartnerIntegrationFault`.
    pub fn is_unauthorized_partner_integration_fault(&self) -> bool {
        matches!(
            &self.kind,
            AddPartnerErrorKind::UnauthorizedPartnerIntegrationFault(_)
        )
    }
}
impl std::error::Error for AddPartnerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AddPartnerErrorKind::ClusterNotFoundFault(_inner) => Some(_inner),
            AddPartnerErrorKind::PartnerNotFoundFault(_inner) => Some(_inner),
            AddPartnerErrorKind::UnauthorizedPartnerIntegrationFault(_inner) => Some(_inner),
            AddPartnerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AssociateDataShareConsumer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AssociateDataShareConsumerError {
    /// Kind of error that occurred.
    pub kind: AssociateDataShareConsumerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AssociateDataShareConsumer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AssociateDataShareConsumerErrorKind {
    /// <p>There is an error with the datashare.</p>
    InvalidDataShareFault(crate::error::InvalidDataShareFault),
    /// <p>The namespace isn't valid because the namespace doesn't exist. Provide a valid namespace.</p>
    InvalidNamespaceFault(crate::error::InvalidNamespaceFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AssociateDataShareConsumerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AssociateDataShareConsumerErrorKind::InvalidDataShareFault(_inner) => _inner.fmt(f),
            AssociateDataShareConsumerErrorKind::InvalidNamespaceFault(_inner) => _inner.fmt(f),
            AssociateDataShareConsumerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AssociateDataShareConsumerError {
    fn code(&self) -> Option<&str> {
        AssociateDataShareConsumerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AssociateDataShareConsumerError {
    /// Creates a new `AssociateDataShareConsumerError`.
    pub fn new(kind: AssociateDataShareConsumerErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AssociateDataShareConsumerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AssociateDataShareConsumerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AssociateDataShareConsumerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AssociateDataShareConsumerErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AssociateDataShareConsumerErrorKind::InvalidDataShareFault`.
    pub fn is_invalid_data_share_fault(&self) -> bool {
        matches!(
            &self.kind,
            AssociateDataShareConsumerErrorKind::InvalidDataShareFault(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateDataShareConsumerErrorKind::InvalidNamespaceFault`.
    pub fn is_invalid_namespace_fault(&self) -> bool {
        matches!(
            &self.kind,
            AssociateDataShareConsumerErrorKind::InvalidNamespaceFault(_)
        )
    }
}
impl std::error::Error for AssociateDataShareConsumerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AssociateDataShareConsumerErrorKind::InvalidDataShareFault(_inner) => Some(_inner),
            AssociateDataShareConsumerErrorKind::InvalidNamespaceFault(_inner) => Some(_inner),
            AssociateDataShareConsumerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AuthorizeClusterSecurityGroupIngress` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AuthorizeClusterSecurityGroupIngressError {
    /// Kind of error that occurred.
    pub kind: AuthorizeClusterSecurityGroupIngressErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AuthorizeClusterSecurityGroupIngress` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AuthorizeClusterSecurityGroupIngressErrorKind {
    /// <p>The specified CIDR block or EC2 security group is already authorized for the
    /// specified cluster security group.</p>
    AuthorizationAlreadyExistsFault(crate::error::AuthorizationAlreadyExistsFault),
    /// <p>The authorization quota for the cluster security group has been reached.</p>
    AuthorizationQuotaExceededFault(crate::error::AuthorizationQuotaExceededFault),
    /// <p>The cluster security group name does not refer to an existing cluster security
    /// group.</p>
    ClusterSecurityGroupNotFoundFault(crate::error::ClusterSecurityGroupNotFoundFault),
    /// <p>The state of the cluster security group is not <code>available</code>. </p>
    InvalidClusterSecurityGroupStateFault(crate::error::InvalidClusterSecurityGroupStateFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AuthorizeClusterSecurityGroupIngressError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AuthorizeClusterSecurityGroupIngressErrorKind::AuthorizationAlreadyExistsFault(_inner) =>
            _inner.fmt(f)
            ,
            AuthorizeClusterSecurityGroupIngressErrorKind::AuthorizationQuotaExceededFault(_inner) =>
            _inner.fmt(f)
            ,
            AuthorizeClusterSecurityGroupIngressErrorKind::ClusterSecurityGroupNotFoundFault(_inner) =>
            _inner.fmt(f)
            ,
            AuthorizeClusterSecurityGroupIngressErrorKind::InvalidClusterSecurityGroupStateFault(_inner) =>
            _inner.fmt(f)
            ,
            AuthorizeClusterSecurityGroupIngressErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AuthorizeClusterSecurityGroupIngressError {
    fn code(&self) -> Option<&str> {
        AuthorizeClusterSecurityGroupIngressError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AuthorizeClusterSecurityGroupIngressError {
    /// Creates a new `AuthorizeClusterSecurityGroupIngressError`.
    pub fn new(
        kind: AuthorizeClusterSecurityGroupIngressErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AuthorizeClusterSecurityGroupIngressError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AuthorizeClusterSecurityGroupIngressErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AuthorizeClusterSecurityGroupIngressError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AuthorizeClusterSecurityGroupIngressErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AuthorizeClusterSecurityGroupIngressErrorKind::AuthorizationAlreadyExistsFault`.
    pub fn is_authorization_already_exists_fault(&self) -> bool {
        matches!(
            &self.kind,
            AuthorizeClusterSecurityGroupIngressErrorKind::AuthorizationAlreadyExistsFault(_)
        )
    }
    /// Returns `true` if the error kind is `AuthorizeClusterSecurityGroupIngressErrorKind::AuthorizationQuotaExceededFault`.
    pub fn is_authorization_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            AuthorizeClusterSecurityGroupIngressErrorKind::AuthorizationQuotaExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `AuthorizeClusterSecurityGroupIngressErrorKind::ClusterSecurityGroupNotFoundFault`.
    pub fn is_cluster_security_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            AuthorizeClusterSecurityGroupIngressErrorKind::ClusterSecurityGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `AuthorizeClusterSecurityGroupIngressErrorKind::InvalidClusterSecurityGroupStateFault`.
    pub fn is_invalid_cluster_security_group_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            AuthorizeClusterSecurityGroupIngressErrorKind::InvalidClusterSecurityGroupStateFault(_)
        )
    }
}
impl std::error::Error for AuthorizeClusterSecurityGroupIngressError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AuthorizeClusterSecurityGroupIngressErrorKind::AuthorizationAlreadyExistsFault(_inner) =>
            Some(_inner)
            ,
            AuthorizeClusterSecurityGroupIngressErrorKind::AuthorizationQuotaExceededFault(_inner) =>
            Some(_inner)
            ,
            AuthorizeClusterSecurityGroupIngressErrorKind::ClusterSecurityGroupNotFoundFault(_inner) =>
            Some(_inner)
            ,
            AuthorizeClusterSecurityGroupIngressErrorKind::InvalidClusterSecurityGroupStateFault(_inner) =>
            Some(_inner)
            ,
            AuthorizeClusterSecurityGroupIngressErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `AuthorizeDataShare` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AuthorizeDataShareError {
    /// Kind of error that occurred.
    pub kind: AuthorizeDataShareErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AuthorizeDataShare` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AuthorizeDataShareErrorKind {
    /// <p>There is an error with the datashare.</p>
    InvalidDataShareFault(crate::error::InvalidDataShareFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AuthorizeDataShareError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AuthorizeDataShareErrorKind::InvalidDataShareFault(_inner) => _inner.fmt(f),
            AuthorizeDataShareErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AuthorizeDataShareError {
    fn code(&self) -> Option<&str> {
        AuthorizeDataShareError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AuthorizeDataShareError {
    /// Creates a new `AuthorizeDataShareError`.
    pub fn new(kind: AuthorizeDataShareErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AuthorizeDataShareError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AuthorizeDataShareErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AuthorizeDataShareError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AuthorizeDataShareErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AuthorizeDataShareErrorKind::InvalidDataShareFault`.
    pub fn is_invalid_data_share_fault(&self) -> bool {
        matches!(
            &self.kind,
            AuthorizeDataShareErrorKind::InvalidDataShareFault(_)
        )
    }
}
impl std::error::Error for AuthorizeDataShareError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AuthorizeDataShareErrorKind::InvalidDataShareFault(_inner) => Some(_inner),
            AuthorizeDataShareErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AuthorizeEndpointAccess` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AuthorizeEndpointAccessError {
    /// Kind of error that occurred.
    pub kind: AuthorizeEndpointAccessErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AuthorizeEndpointAccess` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AuthorizeEndpointAccessErrorKind {
    /// <p>The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster.
    /// </p>
    ClusterNotFoundFault(crate::error::ClusterNotFoundFault),
    /// <p>The authorization already exists for this endpoint.</p>
    EndpointAuthorizationAlreadyExistsFault(crate::error::EndpointAuthorizationAlreadyExistsFault),
    /// <p>The number of endpoint authorizations per cluster has exceeded its limit.</p>
    EndpointAuthorizationsPerClusterLimitExceededFault(
        crate::error::EndpointAuthorizationsPerClusterLimitExceededFault,
    ),
    /// <p>The status of the authorization is not valid.</p>
    InvalidAuthorizationStateFault(crate::error::InvalidAuthorizationStateFault),
    /// <p>The specified cluster is not in the <code>available</code> state. </p>
    InvalidClusterStateFault(crate::error::InvalidClusterStateFault),
    /// <p>The requested operation isn't supported.</p>
    UnsupportedOperationFault(crate::error::UnsupportedOperationFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AuthorizeEndpointAccessError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AuthorizeEndpointAccessErrorKind::ClusterNotFoundFault(_inner) =>
            _inner.fmt(f)
            ,
            AuthorizeEndpointAccessErrorKind::EndpointAuthorizationAlreadyExistsFault(_inner) =>
            _inner.fmt(f)
            ,
            AuthorizeEndpointAccessErrorKind::EndpointAuthorizationsPerClusterLimitExceededFault(_inner) =>
            _inner.fmt(f)
            ,
            AuthorizeEndpointAccessErrorKind::InvalidAuthorizationStateFault(_inner) =>
            _inner.fmt(f)
            ,
            AuthorizeEndpointAccessErrorKind::InvalidClusterStateFault(_inner) =>
            _inner.fmt(f)
            ,
            AuthorizeEndpointAccessErrorKind::UnsupportedOperationFault(_inner) =>
            _inner.fmt(f)
            ,
            AuthorizeEndpointAccessErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AuthorizeEndpointAccessError {
    fn code(&self) -> Option<&str> {
        AuthorizeEndpointAccessError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AuthorizeEndpointAccessError {
    /// Creates a new `AuthorizeEndpointAccessError`.
    pub fn new(kind: AuthorizeEndpointAccessErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AuthorizeEndpointAccessError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AuthorizeEndpointAccessErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AuthorizeEndpointAccessError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AuthorizeEndpointAccessErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AuthorizeEndpointAccessErrorKind::ClusterNotFoundFault`.
    pub fn is_cluster_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            AuthorizeEndpointAccessErrorKind::ClusterNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `AuthorizeEndpointAccessErrorKind::EndpointAuthorizationAlreadyExistsFault`.
    pub fn is_endpoint_authorization_already_exists_fault(&self) -> bool {
        matches!(
            &self.kind,
            AuthorizeEndpointAccessErrorKind::EndpointAuthorizationAlreadyExistsFault(_)
        )
    }
    /// Returns `true` if the error kind is `AuthorizeEndpointAccessErrorKind::EndpointAuthorizationsPerClusterLimitExceededFault`.
    pub fn is_endpoint_authorizations_per_cluster_limit_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            AuthorizeEndpointAccessErrorKind::EndpointAuthorizationsPerClusterLimitExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `AuthorizeEndpointAccessErrorKind::InvalidAuthorizationStateFault`.
    pub fn is_invalid_authorization_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            AuthorizeEndpointAccessErrorKind::InvalidAuthorizationStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `AuthorizeEndpointAccessErrorKind::InvalidClusterStateFault`.
    pub fn is_invalid_cluster_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            AuthorizeEndpointAccessErrorKind::InvalidClusterStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `AuthorizeEndpointAccessErrorKind::UnsupportedOperationFault`.
    pub fn is_unsupported_operation_fault(&self) -> bool {
        matches!(
            &self.kind,
            AuthorizeEndpointAccessErrorKind::UnsupportedOperationFault(_)
        )
    }
}
impl std::error::Error for AuthorizeEndpointAccessError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AuthorizeEndpointAccessErrorKind::ClusterNotFoundFault(_inner) =>
            Some(_inner)
            ,
            AuthorizeEndpointAccessErrorKind::EndpointAuthorizationAlreadyExistsFault(_inner) =>
            Some(_inner)
            ,
            AuthorizeEndpointAccessErrorKind::EndpointAuthorizationsPerClusterLimitExceededFault(_inner) =>
            Some(_inner)
            ,
            AuthorizeEndpointAccessErrorKind::InvalidAuthorizationStateFault(_inner) =>
            Some(_inner)
            ,
            AuthorizeEndpointAccessErrorKind::InvalidClusterStateFault(_inner) =>
            Some(_inner)
            ,
            AuthorizeEndpointAccessErrorKind::UnsupportedOperationFault(_inner) =>
            Some(_inner)
            ,
            AuthorizeEndpointAccessErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `AuthorizeSnapshotAccess` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AuthorizeSnapshotAccessError {
    /// Kind of error that occurred.
    pub kind: AuthorizeSnapshotAccessErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AuthorizeSnapshotAccess` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AuthorizeSnapshotAccessErrorKind {
    /// <p>The specified CIDR block or EC2 security group is already authorized for the
    /// specified cluster security group.</p>
    AuthorizationAlreadyExistsFault(crate::error::AuthorizationAlreadyExistsFault),
    /// <p>The authorization quota for the cluster security group has been reached.</p>
    AuthorizationQuotaExceededFault(crate::error::AuthorizationQuotaExceededFault),
    /// <p>The snapshot identifier does not refer to an existing cluster snapshot.</p>
    ClusterSnapshotNotFoundFault(crate::error::ClusterSnapshotNotFoundFault),
    /// <p>The request cannot be completed because a dependent service is throttling requests
    /// made by Amazon Redshift on your behalf. Wait and retry the request.</p>
    DependentServiceRequestThrottlingFault(crate::error::DependentServiceRequestThrottlingFault),
    /// <p>The specified cluster snapshot is not in the <code>available</code> state, or other
    /// accounts are authorized to access the snapshot. </p>
    InvalidClusterSnapshotStateFault(crate::error::InvalidClusterSnapshotStateFault),
    /// <p>The encryption key has exceeded its grant limit in Amazon Web Services KMS.</p>
    LimitExceededFault(crate::error::LimitExceededFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AuthorizeSnapshotAccessError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AuthorizeSnapshotAccessErrorKind::AuthorizationAlreadyExistsFault(_inner) => {
                _inner.fmt(f)
            }
            AuthorizeSnapshotAccessErrorKind::AuthorizationQuotaExceededFault(_inner) => {
                _inner.fmt(f)
            }
            AuthorizeSnapshotAccessErrorKind::ClusterSnapshotNotFoundFault(_inner) => _inner.fmt(f),
            AuthorizeSnapshotAccessErrorKind::DependentServiceRequestThrottlingFault(_inner) => {
                _inner.fmt(f)
            }
            AuthorizeSnapshotAccessErrorKind::InvalidClusterSnapshotStateFault(_inner) => {
                _inner.fmt(f)
            }
            AuthorizeSnapshotAccessErrorKind::LimitExceededFault(_inner) => _inner.fmt(f),
            AuthorizeSnapshotAccessErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AuthorizeSnapshotAccessError {
    fn code(&self) -> Option<&str> {
        AuthorizeSnapshotAccessError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AuthorizeSnapshotAccessError {
    /// Creates a new `AuthorizeSnapshotAccessError`.
    pub fn new(kind: AuthorizeSnapshotAccessErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AuthorizeSnapshotAccessError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AuthorizeSnapshotAccessErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AuthorizeSnapshotAccessError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AuthorizeSnapshotAccessErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AuthorizeSnapshotAccessErrorKind::AuthorizationAlreadyExistsFault`.
    pub fn is_authorization_already_exists_fault(&self) -> bool {
        matches!(
            &self.kind,
            AuthorizeSnapshotAccessErrorKind::AuthorizationAlreadyExistsFault(_)
        )
    }
    /// Returns `true` if the error kind is `AuthorizeSnapshotAccessErrorKind::AuthorizationQuotaExceededFault`.
    pub fn is_authorization_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            AuthorizeSnapshotAccessErrorKind::AuthorizationQuotaExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `AuthorizeSnapshotAccessErrorKind::ClusterSnapshotNotFoundFault`.
    pub fn is_cluster_snapshot_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            AuthorizeSnapshotAccessErrorKind::ClusterSnapshotNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `AuthorizeSnapshotAccessErrorKind::DependentServiceRequestThrottlingFault`.
    pub fn is_dependent_service_request_throttling_fault(&self) -> bool {
        matches!(
            &self.kind,
            AuthorizeSnapshotAccessErrorKind::DependentServiceRequestThrottlingFault(_)
        )
    }
    /// Returns `true` if the error kind is `AuthorizeSnapshotAccessErrorKind::InvalidClusterSnapshotStateFault`.
    pub fn is_invalid_cluster_snapshot_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            AuthorizeSnapshotAccessErrorKind::InvalidClusterSnapshotStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `AuthorizeSnapshotAccessErrorKind::LimitExceededFault`.
    pub fn is_limit_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            AuthorizeSnapshotAccessErrorKind::LimitExceededFault(_)
        )
    }
}
impl std::error::Error for AuthorizeSnapshotAccessError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AuthorizeSnapshotAccessErrorKind::AuthorizationAlreadyExistsFault(_inner) => {
                Some(_inner)
            }
            AuthorizeSnapshotAccessErrorKind::AuthorizationQuotaExceededFault(_inner) => {
                Some(_inner)
            }
            AuthorizeSnapshotAccessErrorKind::ClusterSnapshotNotFoundFault(_inner) => Some(_inner),
            AuthorizeSnapshotAccessErrorKind::DependentServiceRequestThrottlingFault(_inner) => {
                Some(_inner)
            }
            AuthorizeSnapshotAccessErrorKind::InvalidClusterSnapshotStateFault(_inner) => {
                Some(_inner)
            }
            AuthorizeSnapshotAccessErrorKind::LimitExceededFault(_inner) => Some(_inner),
            AuthorizeSnapshotAccessErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `BatchDeleteClusterSnapshots` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BatchDeleteClusterSnapshotsError {
    /// Kind of error that occurred.
    pub kind: BatchDeleteClusterSnapshotsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BatchDeleteClusterSnapshots` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BatchDeleteClusterSnapshotsErrorKind {
    /// <p>The maximum number for a batch delete of snapshots has been reached. The limit is
    /// 100. </p>
    BatchDeleteRequestSizeExceededFault(crate::error::BatchDeleteRequestSizeExceededFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BatchDeleteClusterSnapshotsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BatchDeleteClusterSnapshotsErrorKind::BatchDeleteRequestSizeExceededFault(_inner) => {
                _inner.fmt(f)
            }
            BatchDeleteClusterSnapshotsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for BatchDeleteClusterSnapshotsError {
    fn code(&self) -> Option<&str> {
        BatchDeleteClusterSnapshotsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl BatchDeleteClusterSnapshotsError {
    /// Creates a new `BatchDeleteClusterSnapshotsError`.
    pub fn new(kind: BatchDeleteClusterSnapshotsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BatchDeleteClusterSnapshotsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BatchDeleteClusterSnapshotsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `BatchDeleteClusterSnapshotsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BatchDeleteClusterSnapshotsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `BatchDeleteClusterSnapshotsErrorKind::BatchDeleteRequestSizeExceededFault`.
    pub fn is_batch_delete_request_size_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            BatchDeleteClusterSnapshotsErrorKind::BatchDeleteRequestSizeExceededFault(_)
        )
    }
}
impl std::error::Error for BatchDeleteClusterSnapshotsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BatchDeleteClusterSnapshotsErrorKind::BatchDeleteRequestSizeExceededFault(_inner) => {
                Some(_inner)
            }
            BatchDeleteClusterSnapshotsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `BatchModifyClusterSnapshots` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BatchModifyClusterSnapshotsError {
    /// Kind of error that occurred.
    pub kind: BatchModifyClusterSnapshotsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BatchModifyClusterSnapshots` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BatchModifyClusterSnapshotsErrorKind {
    /// <p>The maximum number for snapshot identifiers has been reached. The limit is 100.
    /// </p>
    BatchModifyClusterSnapshotsLimitExceededFault(
        crate::error::BatchModifyClusterSnapshotsLimitExceededFault,
    ),
    /// <p>The retention period specified is either in the past or is not a valid value.</p>
    /// <p>The value must be either -1 or an integer between 1 and 3,653.</p>
    InvalidRetentionPeriodFault(crate::error::InvalidRetentionPeriodFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BatchModifyClusterSnapshotsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BatchModifyClusterSnapshotsErrorKind::BatchModifyClusterSnapshotsLimitExceededFault(
                _inner,
            ) => _inner.fmt(f),
            BatchModifyClusterSnapshotsErrorKind::InvalidRetentionPeriodFault(_inner) => {
                _inner.fmt(f)
            }
            BatchModifyClusterSnapshotsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for BatchModifyClusterSnapshotsError {
    fn code(&self) -> Option<&str> {
        BatchModifyClusterSnapshotsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl BatchModifyClusterSnapshotsError {
    /// Creates a new `BatchModifyClusterSnapshotsError`.
    pub fn new(kind: BatchModifyClusterSnapshotsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BatchModifyClusterSnapshotsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BatchModifyClusterSnapshotsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `BatchModifyClusterSnapshotsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BatchModifyClusterSnapshotsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `BatchModifyClusterSnapshotsErrorKind::BatchModifyClusterSnapshotsLimitExceededFault`.
    pub fn is_batch_modify_cluster_snapshots_limit_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            BatchModifyClusterSnapshotsErrorKind::BatchModifyClusterSnapshotsLimitExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `BatchModifyClusterSnapshotsErrorKind::InvalidRetentionPeriodFault`.
    pub fn is_invalid_retention_period_fault(&self) -> bool {
        matches!(
            &self.kind,
            BatchModifyClusterSnapshotsErrorKind::InvalidRetentionPeriodFault(_)
        )
    }
}
impl std::error::Error for BatchModifyClusterSnapshotsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BatchModifyClusterSnapshotsErrorKind::BatchModifyClusterSnapshotsLimitExceededFault(
                _inner,
            ) => Some(_inner),
            BatchModifyClusterSnapshotsErrorKind::InvalidRetentionPeriodFault(_inner) => {
                Some(_inner)
            }
            BatchModifyClusterSnapshotsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CancelResize` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CancelResizeError {
    /// Kind of error that occurred.
    pub kind: CancelResizeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CancelResize` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CancelResizeErrorKind {
    /// <p>The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster.
    /// </p>
    ClusterNotFoundFault(crate::error::ClusterNotFoundFault),
    /// <p>The specified cluster is not in the <code>available</code> state. </p>
    InvalidClusterStateFault(crate::error::InvalidClusterStateFault),
    /// <p>A resize operation for the specified cluster is not found.</p>
    ResizeNotFoundFault(crate::error::ResizeNotFoundFault),
    /// <p>The requested operation isn't supported.</p>
    UnsupportedOperationFault(crate::error::UnsupportedOperationFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CancelResizeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CancelResizeErrorKind::ClusterNotFoundFault(_inner) => _inner.fmt(f),
            CancelResizeErrorKind::InvalidClusterStateFault(_inner) => _inner.fmt(f),
            CancelResizeErrorKind::ResizeNotFoundFault(_inner) => _inner.fmt(f),
            CancelResizeErrorKind::UnsupportedOperationFault(_inner) => _inner.fmt(f),
            CancelResizeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CancelResizeError {
    fn code(&self) -> Option<&str> {
        CancelResizeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CancelResizeError {
    /// Creates a new `CancelResizeError`.
    pub fn new(kind: CancelResizeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CancelResizeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CancelResizeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CancelResizeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CancelResizeErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CancelResizeErrorKind::ClusterNotFoundFault`.
    pub fn is_cluster_not_found_fault(&self) -> bool {
        matches!(&self.kind, CancelResizeErrorKind::ClusterNotFoundFault(_))
    }
    /// Returns `true` if the error kind is `CancelResizeErrorKind::InvalidClusterStateFault`.
    pub fn is_invalid_cluster_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            CancelResizeErrorKind::InvalidClusterStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `CancelResizeErrorKind::ResizeNotFoundFault`.
    pub fn is_resize_not_found_fault(&self) -> bool {
        matches!(&self.kind, CancelResizeErrorKind::ResizeNotFoundFault(_))
    }
    /// Returns `true` if the error kind is `CancelResizeErrorKind::UnsupportedOperationFault`.
    pub fn is_unsupported_operation_fault(&self) -> bool {
        matches!(
            &self.kind,
            CancelResizeErrorKind::UnsupportedOperationFault(_)
        )
    }
}
impl std::error::Error for CancelResizeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CancelResizeErrorKind::ClusterNotFoundFault(_inner) => Some(_inner),
            CancelResizeErrorKind::InvalidClusterStateFault(_inner) => Some(_inner),
            CancelResizeErrorKind::ResizeNotFoundFault(_inner) => Some(_inner),
            CancelResizeErrorKind::UnsupportedOperationFault(_inner) => Some(_inner),
            CancelResizeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CopyClusterSnapshot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CopyClusterSnapshotError {
    /// Kind of error that occurred.
    pub kind: CopyClusterSnapshotErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CopyClusterSnapshot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CopyClusterSnapshotErrorKind {
    /// <p>The value specified as a snapshot identifier is already used by an existing
    /// snapshot.</p>
    ClusterSnapshotAlreadyExistsFault(crate::error::ClusterSnapshotAlreadyExistsFault),
    /// <p>The snapshot identifier does not refer to an existing cluster snapshot.</p>
    ClusterSnapshotNotFoundFault(crate::error::ClusterSnapshotNotFoundFault),
    /// <p>The request would result in the user exceeding the allowed number of cluster
    /// snapshots.</p>
    ClusterSnapshotQuotaExceededFault(crate::error::ClusterSnapshotQuotaExceededFault),
    /// <p>The specified cluster snapshot is not in the <code>available</code> state, or other
    /// accounts are authorized to access the snapshot. </p>
    InvalidClusterSnapshotStateFault(crate::error::InvalidClusterSnapshotStateFault),
    /// <p>The retention period specified is either in the past or is not a valid value.</p>
    /// <p>The value must be either -1 or an integer between 1 and 3,653.</p>
    InvalidRetentionPeriodFault(crate::error::InvalidRetentionPeriodFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CopyClusterSnapshotError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CopyClusterSnapshotErrorKind::ClusterSnapshotAlreadyExistsFault(_inner) => {
                _inner.fmt(f)
            }
            CopyClusterSnapshotErrorKind::ClusterSnapshotNotFoundFault(_inner) => _inner.fmt(f),
            CopyClusterSnapshotErrorKind::ClusterSnapshotQuotaExceededFault(_inner) => {
                _inner.fmt(f)
            }
            CopyClusterSnapshotErrorKind::InvalidClusterSnapshotStateFault(_inner) => _inner.fmt(f),
            CopyClusterSnapshotErrorKind::InvalidRetentionPeriodFault(_inner) => _inner.fmt(f),
            CopyClusterSnapshotErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CopyClusterSnapshotError {
    fn code(&self) -> Option<&str> {
        CopyClusterSnapshotError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CopyClusterSnapshotError {
    /// Creates a new `CopyClusterSnapshotError`.
    pub fn new(kind: CopyClusterSnapshotErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CopyClusterSnapshotError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CopyClusterSnapshotErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CopyClusterSnapshotError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CopyClusterSnapshotErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CopyClusterSnapshotErrorKind::ClusterSnapshotAlreadyExistsFault`.
    pub fn is_cluster_snapshot_already_exists_fault(&self) -> bool {
        matches!(
            &self.kind,
            CopyClusterSnapshotErrorKind::ClusterSnapshotAlreadyExistsFault(_)
        )
    }
    /// Returns `true` if the error kind is `CopyClusterSnapshotErrorKind::ClusterSnapshotNotFoundFault`.
    pub fn is_cluster_snapshot_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            CopyClusterSnapshotErrorKind::ClusterSnapshotNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `CopyClusterSnapshotErrorKind::ClusterSnapshotQuotaExceededFault`.
    pub fn is_cluster_snapshot_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            CopyClusterSnapshotErrorKind::ClusterSnapshotQuotaExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `CopyClusterSnapshotErrorKind::InvalidClusterSnapshotStateFault`.
    pub fn is_invalid_cluster_snapshot_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            CopyClusterSnapshotErrorKind::InvalidClusterSnapshotStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `CopyClusterSnapshotErrorKind::InvalidRetentionPeriodFault`.
    pub fn is_invalid_retention_period_fault(&self) -> bool {
        matches!(
            &self.kind,
            CopyClusterSnapshotErrorKind::InvalidRetentionPeriodFault(_)
        )
    }
}
impl std::error::Error for CopyClusterSnapshotError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CopyClusterSnapshotErrorKind::ClusterSnapshotAlreadyExistsFault(_inner) => Some(_inner),
            CopyClusterSnapshotErrorKind::ClusterSnapshotNotFoundFault(_inner) => Some(_inner),
            CopyClusterSnapshotErrorKind::ClusterSnapshotQuotaExceededFault(_inner) => Some(_inner),
            CopyClusterSnapshotErrorKind::InvalidClusterSnapshotStateFault(_inner) => Some(_inner),
            CopyClusterSnapshotErrorKind::InvalidRetentionPeriodFault(_inner) => Some(_inner),
            CopyClusterSnapshotErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateAuthenticationProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateAuthenticationProfileError {
    /// Kind of error that occurred.
    pub kind: CreateAuthenticationProfileErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateAuthenticationProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateAuthenticationProfileErrorKind {
    /// <p>The authentication profile already exists.</p>
    AuthenticationProfileAlreadyExistsFault(crate::error::AuthenticationProfileAlreadyExistsFault),
    /// <p>The size or number of authentication profiles has exceeded the quota.
    /// The maximum length of the JSON string and maximum number of authentication profiles is determined by a quota for your account.</p>
    AuthenticationProfileQuotaExceededFault(crate::error::AuthenticationProfileQuotaExceededFault),
    /// <p>The authentication profile request is not valid. The profile name can't be null or empty.
    /// The authentication profile API operation must be available in the Amazon Web Services Region.</p>
    InvalidAuthenticationProfileRequestFault(
        crate::error::InvalidAuthenticationProfileRequestFault,
    ),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateAuthenticationProfileError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateAuthenticationProfileErrorKind::AuthenticationProfileAlreadyExistsFault(
                _inner,
            ) => _inner.fmt(f),
            CreateAuthenticationProfileErrorKind::AuthenticationProfileQuotaExceededFault(
                _inner,
            ) => _inner.fmt(f),
            CreateAuthenticationProfileErrorKind::InvalidAuthenticationProfileRequestFault(
                _inner,
            ) => _inner.fmt(f),
            CreateAuthenticationProfileErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateAuthenticationProfileError {
    fn code(&self) -> Option<&str> {
        CreateAuthenticationProfileError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateAuthenticationProfileError {
    /// Creates a new `CreateAuthenticationProfileError`.
    pub fn new(kind: CreateAuthenticationProfileErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateAuthenticationProfileError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateAuthenticationProfileErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateAuthenticationProfileError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateAuthenticationProfileErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateAuthenticationProfileErrorKind::AuthenticationProfileAlreadyExistsFault`.
    pub fn is_authentication_profile_already_exists_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateAuthenticationProfileErrorKind::AuthenticationProfileAlreadyExistsFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAuthenticationProfileErrorKind::AuthenticationProfileQuotaExceededFault`.
    pub fn is_authentication_profile_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateAuthenticationProfileErrorKind::AuthenticationProfileQuotaExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateAuthenticationProfileErrorKind::InvalidAuthenticationProfileRequestFault`.
    pub fn is_invalid_authentication_profile_request_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateAuthenticationProfileErrorKind::InvalidAuthenticationProfileRequestFault(_)
        )
    }
}
impl std::error::Error for CreateAuthenticationProfileError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateAuthenticationProfileErrorKind::AuthenticationProfileAlreadyExistsFault(
                _inner,
            ) => Some(_inner),
            CreateAuthenticationProfileErrorKind::AuthenticationProfileQuotaExceededFault(
                _inner,
            ) => Some(_inner),
            CreateAuthenticationProfileErrorKind::InvalidAuthenticationProfileRequestFault(
                _inner,
            ) => Some(_inner),
            CreateAuthenticationProfileErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateClusterError {
    /// Kind of error that occurred.
    pub kind: CreateClusterErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateClusterErrorKind {
    /// <p>The account already has a cluster with the given identifier.</p>
    ClusterAlreadyExistsFault(crate::error::ClusterAlreadyExistsFault),
    /// <p>The parameter group name does not refer to an existing parameter group.</p>
    ClusterParameterGroupNotFoundFault(crate::error::ClusterParameterGroupNotFoundFault),
    /// <p>The request would exceed the allowed number of cluster instances for this account.
    ///
    /// For information about increasing your quota, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon Redshift</a>
    /// in the <i>Amazon Redshift Cluster Management Guide</i>.
    /// </p>
    ClusterQuotaExceededFault(crate::error::ClusterQuotaExceededFault),
    /// <p>The cluster security group name does not refer to an existing cluster security
    /// group.</p>
    ClusterSecurityGroupNotFoundFault(crate::error::ClusterSecurityGroupNotFoundFault),
    /// <p>The cluster subnet group name does not refer to an existing cluster subnet
    /// group.</p>
    ClusterSubnetGroupNotFoundFault(crate::error::ClusterSubnetGroupNotFoundFault),
    /// <p>The request cannot be completed because a dependent service is throttling requests
    /// made by Amazon Redshift on your behalf. Wait and retry the request.</p>
    DependentServiceRequestThrottlingFault(crate::error::DependentServiceRequestThrottlingFault),
    /// <p>There is no Amazon Redshift HSM client certificate with the specified
    /// identifier.</p>
    HsmClientCertificateNotFoundFault(crate::error::HsmClientCertificateNotFoundFault),
    /// <p>There is no Amazon Redshift HSM configuration with the specified identifier.</p>
    HsmConfigurationNotFoundFault(crate::error::HsmConfigurationNotFoundFault),
    /// <p>The number of nodes specified exceeds the allotted capacity of the
    /// cluster.</p>
    InsufficientClusterCapacityFault(crate::error::InsufficientClusterCapacityFault),
    /// <p>The cluster subnet group cannot be deleted because it is in use.</p>
    InvalidClusterSubnetGroupStateFault(crate::error::InvalidClusterSubnetGroupStateFault),
    /// <p>The provided cluster track name is not valid.</p>
    InvalidClusterTrackFault(crate::error::InvalidClusterTrackFault),
    /// <p>The Elastic IP (EIP) is invalid or cannot be found.</p>
    InvalidElasticIpFault(crate::error::InvalidElasticIpFault),
    /// <p>The retention period specified is either in the past or is not a valid value.</p>
    /// <p>The value must be either -1 or an integer between 1 and 3,653.</p>
    InvalidRetentionPeriodFault(crate::error::InvalidRetentionPeriodFault),
    /// <p>The requested subnet is not valid, or not all of the subnets are in the same
    /// VPC.</p>
    InvalidSubnet(crate::error::InvalidSubnet),
    /// <p>The tag is invalid.</p>
    InvalidTagFault(crate::error::InvalidTagFault),
    /// <p>The cluster subnet group does not cover all Availability Zones.</p>
    InvalidVpcNetworkStateFault(crate::error::InvalidVpcNetworkStateFault),
    /// <p>The encryption key has exceeded its grant limit in Amazon Web Services KMS.</p>
    LimitExceededFault(crate::error::LimitExceededFault),
    /// <p>The operation would exceed the number of nodes allowed for a cluster.</p>
    NumberOfNodesPerClusterLimitExceededFault(
        crate::error::NumberOfNodesPerClusterLimitExceededFault,
    ),
    /// <p>The operation would exceed the number of nodes allotted to the account.
    ///
    /// For information about increasing your quota, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon Redshift</a>
    /// in the <i>Amazon Redshift Cluster Management Guide</i>.
    /// </p>
    NumberOfNodesQuotaExceededFault(crate::error::NumberOfNodesQuotaExceededFault),
    /// <p>We could not find the specified snapshot schedule. </p>
    SnapshotScheduleNotFoundFault(crate::error::SnapshotScheduleNotFoundFault),
    /// <p>You have exceeded the number of tags allowed.</p>
    TagLimitExceededFault(crate::error::TagLimitExceededFault),
    /// <p>Your account is not authorized to perform the requested operation.</p>
    UnauthorizedOperation(crate::error::UnauthorizedOperation),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateClusterError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateClusterErrorKind::ClusterAlreadyExistsFault(_inner) => _inner.fmt(f),
            CreateClusterErrorKind::ClusterParameterGroupNotFoundFault(_inner) => _inner.fmt(f),
            CreateClusterErrorKind::ClusterQuotaExceededFault(_inner) => _inner.fmt(f),
            CreateClusterErrorKind::ClusterSecurityGroupNotFoundFault(_inner) => _inner.fmt(f),
            CreateClusterErrorKind::ClusterSubnetGroupNotFoundFault(_inner) => _inner.fmt(f),
            CreateClusterErrorKind::DependentServiceRequestThrottlingFault(_inner) => _inner.fmt(f),
            CreateClusterErrorKind::HsmClientCertificateNotFoundFault(_inner) => _inner.fmt(f),
            CreateClusterErrorKind::HsmConfigurationNotFoundFault(_inner) => _inner.fmt(f),
            CreateClusterErrorKind::InsufficientClusterCapacityFault(_inner) => _inner.fmt(f),
            CreateClusterErrorKind::InvalidClusterSubnetGroupStateFault(_inner) => _inner.fmt(f),
            CreateClusterErrorKind::InvalidClusterTrackFault(_inner) => _inner.fmt(f),
            CreateClusterErrorKind::InvalidElasticIpFault(_inner) => _inner.fmt(f),
            CreateClusterErrorKind::InvalidRetentionPeriodFault(_inner) => _inner.fmt(f),
            CreateClusterErrorKind::InvalidSubnet(_inner) => _inner.fmt(f),
            CreateClusterErrorKind::InvalidTagFault(_inner) => _inner.fmt(f),
            CreateClusterErrorKind::InvalidVpcNetworkStateFault(_inner) => _inner.fmt(f),
            CreateClusterErrorKind::LimitExceededFault(_inner) => _inner.fmt(f),
            CreateClusterErrorKind::NumberOfNodesPerClusterLimitExceededFault(_inner) => {
                _inner.fmt(f)
            }
            CreateClusterErrorKind::NumberOfNodesQuotaExceededFault(_inner) => _inner.fmt(f),
            CreateClusterErrorKind::SnapshotScheduleNotFoundFault(_inner) => _inner.fmt(f),
            CreateClusterErrorKind::TagLimitExceededFault(_inner) => _inner.fmt(f),
            CreateClusterErrorKind::UnauthorizedOperation(_inner) => _inner.fmt(f),
            CreateClusterErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateClusterError {
    fn code(&self) -> Option<&str> {
        CreateClusterError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateClusterError {
    /// Creates a new `CreateClusterError`.
    pub fn new(kind: CreateClusterErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateClusterError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateClusterErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateClusterError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateClusterErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateClusterErrorKind::ClusterAlreadyExistsFault`.
    pub fn is_cluster_already_exists_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateClusterErrorKind::ClusterAlreadyExistsFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateClusterErrorKind::ClusterParameterGroupNotFoundFault`.
    pub fn is_cluster_parameter_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateClusterErrorKind::ClusterParameterGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateClusterErrorKind::ClusterQuotaExceededFault`.
    pub fn is_cluster_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateClusterErrorKind::ClusterQuotaExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateClusterErrorKind::ClusterSecurityGroupNotFoundFault`.
    pub fn is_cluster_security_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateClusterErrorKind::ClusterSecurityGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateClusterErrorKind::ClusterSubnetGroupNotFoundFault`.
    pub fn is_cluster_subnet_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateClusterErrorKind::ClusterSubnetGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateClusterErrorKind::DependentServiceRequestThrottlingFault`.
    pub fn is_dependent_service_request_throttling_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateClusterErrorKind::DependentServiceRequestThrottlingFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateClusterErrorKind::HsmClientCertificateNotFoundFault`.
    pub fn is_hsm_client_certificate_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateClusterErrorKind::HsmClientCertificateNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateClusterErrorKind::HsmConfigurationNotFoundFault`.
    pub fn is_hsm_configuration_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateClusterErrorKind::HsmConfigurationNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateClusterErrorKind::InsufficientClusterCapacityFault`.
    pub fn is_insufficient_cluster_capacity_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateClusterErrorKind::InsufficientClusterCapacityFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateClusterErrorKind::InvalidClusterSubnetGroupStateFault`.
    pub fn is_invalid_cluster_subnet_group_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateClusterErrorKind::InvalidClusterSubnetGroupStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateClusterErrorKind::InvalidClusterTrackFault`.
    pub fn is_invalid_cluster_track_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateClusterErrorKind::InvalidClusterTrackFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateClusterErrorKind::InvalidElasticIpFault`.
    pub fn is_invalid_elastic_ip_fault(&self) -> bool {
        matches!(&self.kind, CreateClusterErrorKind::InvalidElasticIpFault(_))
    }
    /// Returns `true` if the error kind is `CreateClusterErrorKind::InvalidRetentionPeriodFault`.
    pub fn is_invalid_retention_period_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateClusterErrorKind::InvalidRetentionPeriodFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateClusterErrorKind::InvalidSubnet`.
    pub fn is_invalid_subnet(&self) -> bool {
        matches!(&self.kind, CreateClusterErrorKind::InvalidSubnet(_))
    }
    /// Returns `true` if the error kind is `CreateClusterErrorKind::InvalidTagFault`.
    pub fn is_invalid_tag_fault(&self) -> bool {
        matches!(&self.kind, CreateClusterErrorKind::InvalidTagFault(_))
    }
    /// Returns `true` if the error kind is `CreateClusterErrorKind::InvalidVpcNetworkStateFault`.
    pub fn is_invalid_vpc_network_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateClusterErrorKind::InvalidVpcNetworkStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateClusterErrorKind::LimitExceededFault`.
    pub fn is_limit_exceeded_fault(&self) -> bool {
        matches!(&self.kind, CreateClusterErrorKind::LimitExceededFault(_))
    }
    /// Returns `true` if the error kind is `CreateClusterErrorKind::NumberOfNodesPerClusterLimitExceededFault`.
    pub fn is_number_of_nodes_per_cluster_limit_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateClusterErrorKind::NumberOfNodesPerClusterLimitExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateClusterErrorKind::NumberOfNodesQuotaExceededFault`.
    pub fn is_number_of_nodes_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateClusterErrorKind::NumberOfNodesQuotaExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateClusterErrorKind::SnapshotScheduleNotFoundFault`.
    pub fn is_snapshot_schedule_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateClusterErrorKind::SnapshotScheduleNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateClusterErrorKind::TagLimitExceededFault`.
    pub fn is_tag_limit_exceeded_fault(&self) -> bool {
        matches!(&self.kind, CreateClusterErrorKind::TagLimitExceededFault(_))
    }
    /// Returns `true` if the error kind is `CreateClusterErrorKind::UnauthorizedOperation`.
    pub fn is_unauthorized_operation(&self) -> bool {
        matches!(&self.kind, CreateClusterErrorKind::UnauthorizedOperation(_))
    }
}
impl std::error::Error for CreateClusterError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateClusterErrorKind::ClusterAlreadyExistsFault(_inner) => Some(_inner),
            CreateClusterErrorKind::ClusterParameterGroupNotFoundFault(_inner) => Some(_inner),
            CreateClusterErrorKind::ClusterQuotaExceededFault(_inner) => Some(_inner),
            CreateClusterErrorKind::ClusterSecurityGroupNotFoundFault(_inner) => Some(_inner),
            CreateClusterErrorKind::ClusterSubnetGroupNotFoundFault(_inner) => Some(_inner),
            CreateClusterErrorKind::DependentServiceRequestThrottlingFault(_inner) => Some(_inner),
            CreateClusterErrorKind::HsmClientCertificateNotFoundFault(_inner) => Some(_inner),
            CreateClusterErrorKind::HsmConfigurationNotFoundFault(_inner) => Some(_inner),
            CreateClusterErrorKind::InsufficientClusterCapacityFault(_inner) => Some(_inner),
            CreateClusterErrorKind::InvalidClusterSubnetGroupStateFault(_inner) => Some(_inner),
            CreateClusterErrorKind::InvalidClusterTrackFault(_inner) => Some(_inner),
            CreateClusterErrorKind::InvalidElasticIpFault(_inner) => Some(_inner),
            CreateClusterErrorKind::InvalidRetentionPeriodFault(_inner) => Some(_inner),
            CreateClusterErrorKind::InvalidSubnet(_inner) => Some(_inner),
            CreateClusterErrorKind::InvalidTagFault(_inner) => Some(_inner),
            CreateClusterErrorKind::InvalidVpcNetworkStateFault(_inner) => Some(_inner),
            CreateClusterErrorKind::LimitExceededFault(_inner) => Some(_inner),
            CreateClusterErrorKind::NumberOfNodesPerClusterLimitExceededFault(_inner) => {
                Some(_inner)
            }
            CreateClusterErrorKind::NumberOfNodesQuotaExceededFault(_inner) => Some(_inner),
            CreateClusterErrorKind::SnapshotScheduleNotFoundFault(_inner) => Some(_inner),
            CreateClusterErrorKind::TagLimitExceededFault(_inner) => Some(_inner),
            CreateClusterErrorKind::UnauthorizedOperation(_inner) => Some(_inner),
            CreateClusterErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateClusterParameterGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateClusterParameterGroupError {
    /// Kind of error that occurred.
    pub kind: CreateClusterParameterGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateClusterParameterGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateClusterParameterGroupErrorKind {
    /// <p>A cluster parameter group with the same name already exists.</p>
    ClusterParameterGroupAlreadyExistsFault(crate::error::ClusterParameterGroupAlreadyExistsFault),
    /// <p>The request would result in the user exceeding the allowed number of cluster
    /// parameter groups.
    /// For information about increasing your quota, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon Redshift</a>
    /// in the <i>Amazon Redshift Cluster Management Guide</i>.
    /// </p>
    ClusterParameterGroupQuotaExceededFault(crate::error::ClusterParameterGroupQuotaExceededFault),
    /// <p>The tag is invalid.</p>
    InvalidTagFault(crate::error::InvalidTagFault),
    /// <p>You have exceeded the number of tags allowed.</p>
    TagLimitExceededFault(crate::error::TagLimitExceededFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateClusterParameterGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateClusterParameterGroupErrorKind::ClusterParameterGroupAlreadyExistsFault(
                _inner,
            ) => _inner.fmt(f),
            CreateClusterParameterGroupErrorKind::ClusterParameterGroupQuotaExceededFault(
                _inner,
            ) => _inner.fmt(f),
            CreateClusterParameterGroupErrorKind::InvalidTagFault(_inner) => _inner.fmt(f),
            CreateClusterParameterGroupErrorKind::TagLimitExceededFault(_inner) => _inner.fmt(f),
            CreateClusterParameterGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateClusterParameterGroupError {
    fn code(&self) -> Option<&str> {
        CreateClusterParameterGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateClusterParameterGroupError {
    /// Creates a new `CreateClusterParameterGroupError`.
    pub fn new(kind: CreateClusterParameterGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateClusterParameterGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateClusterParameterGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateClusterParameterGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateClusterParameterGroupErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateClusterParameterGroupErrorKind::ClusterParameterGroupAlreadyExistsFault`.
    pub fn is_cluster_parameter_group_already_exists_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateClusterParameterGroupErrorKind::ClusterParameterGroupAlreadyExistsFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateClusterParameterGroupErrorKind::ClusterParameterGroupQuotaExceededFault`.
    pub fn is_cluster_parameter_group_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateClusterParameterGroupErrorKind::ClusterParameterGroupQuotaExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateClusterParameterGroupErrorKind::InvalidTagFault`.
    pub fn is_invalid_tag_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateClusterParameterGroupErrorKind::InvalidTagFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateClusterParameterGroupErrorKind::TagLimitExceededFault`.
    pub fn is_tag_limit_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateClusterParameterGroupErrorKind::TagLimitExceededFault(_)
        )
    }
}
impl std::error::Error for CreateClusterParameterGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateClusterParameterGroupErrorKind::ClusterParameterGroupAlreadyExistsFault(
                _inner,
            ) => Some(_inner),
            CreateClusterParameterGroupErrorKind::ClusterParameterGroupQuotaExceededFault(
                _inner,
            ) => Some(_inner),
            CreateClusterParameterGroupErrorKind::InvalidTagFault(_inner) => Some(_inner),
            CreateClusterParameterGroupErrorKind::TagLimitExceededFault(_inner) => Some(_inner),
            CreateClusterParameterGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateClusterSecurityGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateClusterSecurityGroupError {
    /// Kind of error that occurred.
    pub kind: CreateClusterSecurityGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateClusterSecurityGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateClusterSecurityGroupErrorKind {
    /// <p>A cluster security group with the same name already exists.</p>
    ClusterSecurityGroupAlreadyExistsFault(crate::error::ClusterSecurityGroupAlreadyExistsFault),
    /// <p>The request would result in the user exceeding the allowed number of cluster
    /// security groups.
    /// For information about increasing your quota, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon Redshift</a>
    /// in the <i>Amazon Redshift Cluster Management Guide</i>.
    /// </p>
    ClusterSecurityGroupQuotaExceededFault(crate::error::ClusterSecurityGroupQuotaExceededFault),
    /// <p>The tag is invalid.</p>
    InvalidTagFault(crate::error::InvalidTagFault),
    /// <p>You have exceeded the number of tags allowed.</p>
    TagLimitExceededFault(crate::error::TagLimitExceededFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateClusterSecurityGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateClusterSecurityGroupErrorKind::ClusterSecurityGroupAlreadyExistsFault(_inner) => {
                _inner.fmt(f)
            }
            CreateClusterSecurityGroupErrorKind::ClusterSecurityGroupQuotaExceededFault(_inner) => {
                _inner.fmt(f)
            }
            CreateClusterSecurityGroupErrorKind::InvalidTagFault(_inner) => _inner.fmt(f),
            CreateClusterSecurityGroupErrorKind::TagLimitExceededFault(_inner) => _inner.fmt(f),
            CreateClusterSecurityGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateClusterSecurityGroupError {
    fn code(&self) -> Option<&str> {
        CreateClusterSecurityGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateClusterSecurityGroupError {
    /// Creates a new `CreateClusterSecurityGroupError`.
    pub fn new(kind: CreateClusterSecurityGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateClusterSecurityGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateClusterSecurityGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateClusterSecurityGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateClusterSecurityGroupErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateClusterSecurityGroupErrorKind::ClusterSecurityGroupAlreadyExistsFault`.
    pub fn is_cluster_security_group_already_exists_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateClusterSecurityGroupErrorKind::ClusterSecurityGroupAlreadyExistsFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateClusterSecurityGroupErrorKind::ClusterSecurityGroupQuotaExceededFault`.
    pub fn is_cluster_security_group_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateClusterSecurityGroupErrorKind::ClusterSecurityGroupQuotaExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateClusterSecurityGroupErrorKind::InvalidTagFault`.
    pub fn is_invalid_tag_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateClusterSecurityGroupErrorKind::InvalidTagFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateClusterSecurityGroupErrorKind::TagLimitExceededFault`.
    pub fn is_tag_limit_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateClusterSecurityGroupErrorKind::TagLimitExceededFault(_)
        )
    }
}
impl std::error::Error for CreateClusterSecurityGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateClusterSecurityGroupErrorKind::ClusterSecurityGroupAlreadyExistsFault(_inner) => {
                Some(_inner)
            }
            CreateClusterSecurityGroupErrorKind::ClusterSecurityGroupQuotaExceededFault(_inner) => {
                Some(_inner)
            }
            CreateClusterSecurityGroupErrorKind::InvalidTagFault(_inner) => Some(_inner),
            CreateClusterSecurityGroupErrorKind::TagLimitExceededFault(_inner) => Some(_inner),
            CreateClusterSecurityGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateClusterSnapshot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateClusterSnapshotError {
    /// Kind of error that occurred.
    pub kind: CreateClusterSnapshotErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateClusterSnapshot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateClusterSnapshotErrorKind {
    /// <p>The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster.
    /// </p>
    ClusterNotFoundFault(crate::error::ClusterNotFoundFault),
    /// <p>The value specified as a snapshot identifier is already used by an existing
    /// snapshot.</p>
    ClusterSnapshotAlreadyExistsFault(crate::error::ClusterSnapshotAlreadyExistsFault),
    /// <p>The request would result in the user exceeding the allowed number of cluster
    /// snapshots.</p>
    ClusterSnapshotQuotaExceededFault(crate::error::ClusterSnapshotQuotaExceededFault),
    /// <p>The specified cluster is not in the <code>available</code> state. </p>
    InvalidClusterStateFault(crate::error::InvalidClusterStateFault),
    /// <p>The retention period specified is either in the past or is not a valid value.</p>
    /// <p>The value must be either -1 or an integer between 1 and 3,653.</p>
    InvalidRetentionPeriodFault(crate::error::InvalidRetentionPeriodFault),
    /// <p>The tag is invalid.</p>
    InvalidTagFault(crate::error::InvalidTagFault),
    /// <p>You have exceeded the number of tags allowed.</p>
    TagLimitExceededFault(crate::error::TagLimitExceededFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateClusterSnapshotError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateClusterSnapshotErrorKind::ClusterNotFoundFault(_inner) => _inner.fmt(f),
            CreateClusterSnapshotErrorKind::ClusterSnapshotAlreadyExistsFault(_inner) => {
                _inner.fmt(f)
            }
            CreateClusterSnapshotErrorKind::ClusterSnapshotQuotaExceededFault(_inner) => {
                _inner.fmt(f)
            }
            CreateClusterSnapshotErrorKind::InvalidClusterStateFault(_inner) => _inner.fmt(f),
            CreateClusterSnapshotErrorKind::InvalidRetentionPeriodFault(_inner) => _inner.fmt(f),
            CreateClusterSnapshotErrorKind::InvalidTagFault(_inner) => _inner.fmt(f),
            CreateClusterSnapshotErrorKind::TagLimitExceededFault(_inner) => _inner.fmt(f),
            CreateClusterSnapshotErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateClusterSnapshotError {
    fn code(&self) -> Option<&str> {
        CreateClusterSnapshotError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateClusterSnapshotError {
    /// Creates a new `CreateClusterSnapshotError`.
    pub fn new(kind: CreateClusterSnapshotErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateClusterSnapshotError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateClusterSnapshotErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateClusterSnapshotError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateClusterSnapshotErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateClusterSnapshotErrorKind::ClusterNotFoundFault`.
    pub fn is_cluster_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateClusterSnapshotErrorKind::ClusterNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateClusterSnapshotErrorKind::ClusterSnapshotAlreadyExistsFault`.
    pub fn is_cluster_snapshot_already_exists_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateClusterSnapshotErrorKind::ClusterSnapshotAlreadyExistsFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateClusterSnapshotErrorKind::ClusterSnapshotQuotaExceededFault`.
    pub fn is_cluster_snapshot_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateClusterSnapshotErrorKind::ClusterSnapshotQuotaExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateClusterSnapshotErrorKind::InvalidClusterStateFault`.
    pub fn is_invalid_cluster_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateClusterSnapshotErrorKind::InvalidClusterStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateClusterSnapshotErrorKind::InvalidRetentionPeriodFault`.
    pub fn is_invalid_retention_period_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateClusterSnapshotErrorKind::InvalidRetentionPeriodFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateClusterSnapshotErrorKind::InvalidTagFault`.
    pub fn is_invalid_tag_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateClusterSnapshotErrorKind::InvalidTagFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateClusterSnapshotErrorKind::TagLimitExceededFault`.
    pub fn is_tag_limit_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateClusterSnapshotErrorKind::TagLimitExceededFault(_)
        )
    }
}
impl std::error::Error for CreateClusterSnapshotError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateClusterSnapshotErrorKind::ClusterNotFoundFault(_inner) => Some(_inner),
            CreateClusterSnapshotErrorKind::ClusterSnapshotAlreadyExistsFault(_inner) => {
                Some(_inner)
            }
            CreateClusterSnapshotErrorKind::ClusterSnapshotQuotaExceededFault(_inner) => {
                Some(_inner)
            }
            CreateClusterSnapshotErrorKind::InvalidClusterStateFault(_inner) => Some(_inner),
            CreateClusterSnapshotErrorKind::InvalidRetentionPeriodFault(_inner) => Some(_inner),
            CreateClusterSnapshotErrorKind::InvalidTagFault(_inner) => Some(_inner),
            CreateClusterSnapshotErrorKind::TagLimitExceededFault(_inner) => Some(_inner),
            CreateClusterSnapshotErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateClusterSubnetGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateClusterSubnetGroupError {
    /// Kind of error that occurred.
    pub kind: CreateClusterSubnetGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateClusterSubnetGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateClusterSubnetGroupErrorKind {
    /// <p>A <i>ClusterSubnetGroupName</i> is already used by an existing
    /// cluster subnet group. </p>
    ClusterSubnetGroupAlreadyExistsFault(crate::error::ClusterSubnetGroupAlreadyExistsFault),
    /// <p>The request would result in user exceeding the allowed number of cluster subnet
    /// groups.
    /// For information about increasing your quota, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon Redshift</a>
    /// in the <i>Amazon Redshift Cluster Management Guide</i>.
    /// </p>
    ClusterSubnetGroupQuotaExceededFault(crate::error::ClusterSubnetGroupQuotaExceededFault),
    /// <p>The request would result in user exceeding the allowed number of subnets in a
    /// cluster subnet groups.
    /// For information about increasing your quota, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon Redshift</a>
    /// in the <i>Amazon Redshift Cluster Management Guide</i>.
    /// </p>
    ClusterSubnetQuotaExceededFault(crate::error::ClusterSubnetQuotaExceededFault),
    /// <p>The request cannot be completed because a dependent service is throttling requests
    /// made by Amazon Redshift on your behalf. Wait and retry the request.</p>
    DependentServiceRequestThrottlingFault(crate::error::DependentServiceRequestThrottlingFault),
    /// <p>The requested subnet is not valid, or not all of the subnets are in the same
    /// VPC.</p>
    InvalidSubnet(crate::error::InvalidSubnet),
    /// <p>The tag is invalid.</p>
    InvalidTagFault(crate::error::InvalidTagFault),
    /// <p>You have exceeded the number of tags allowed.</p>
    TagLimitExceededFault(crate::error::TagLimitExceededFault),
    /// <p>Your account is not authorized to perform the requested operation.</p>
    UnauthorizedOperation(crate::error::UnauthorizedOperation),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateClusterSubnetGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateClusterSubnetGroupErrorKind::ClusterSubnetGroupAlreadyExistsFault(_inner) => {
                _inner.fmt(f)
            }
            CreateClusterSubnetGroupErrorKind::ClusterSubnetGroupQuotaExceededFault(_inner) => {
                _inner.fmt(f)
            }
            CreateClusterSubnetGroupErrorKind::ClusterSubnetQuotaExceededFault(_inner) => {
                _inner.fmt(f)
            }
            CreateClusterSubnetGroupErrorKind::DependentServiceRequestThrottlingFault(_inner) => {
                _inner.fmt(f)
            }
            CreateClusterSubnetGroupErrorKind::InvalidSubnet(_inner) => _inner.fmt(f),
            CreateClusterSubnetGroupErrorKind::InvalidTagFault(_inner) => _inner.fmt(f),
            CreateClusterSubnetGroupErrorKind::TagLimitExceededFault(_inner) => _inner.fmt(f),
            CreateClusterSubnetGroupErrorKind::UnauthorizedOperation(_inner) => _inner.fmt(f),
            CreateClusterSubnetGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateClusterSubnetGroupError {
    fn code(&self) -> Option<&str> {
        CreateClusterSubnetGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateClusterSubnetGroupError {
    /// Creates a new `CreateClusterSubnetGroupError`.
    pub fn new(kind: CreateClusterSubnetGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateClusterSubnetGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateClusterSubnetGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateClusterSubnetGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateClusterSubnetGroupErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateClusterSubnetGroupErrorKind::ClusterSubnetGroupAlreadyExistsFault`.
    pub fn is_cluster_subnet_group_already_exists_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateClusterSubnetGroupErrorKind::ClusterSubnetGroupAlreadyExistsFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateClusterSubnetGroupErrorKind::ClusterSubnetGroupQuotaExceededFault`.
    pub fn is_cluster_subnet_group_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateClusterSubnetGroupErrorKind::ClusterSubnetGroupQuotaExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateClusterSubnetGroupErrorKind::ClusterSubnetQuotaExceededFault`.
    pub fn is_cluster_subnet_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateClusterSubnetGroupErrorKind::ClusterSubnetQuotaExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateClusterSubnetGroupErrorKind::DependentServiceRequestThrottlingFault`.
    pub fn is_dependent_service_request_throttling_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateClusterSubnetGroupErrorKind::DependentServiceRequestThrottlingFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateClusterSubnetGroupErrorKind::InvalidSubnet`.
    pub fn is_invalid_subnet(&self) -> bool {
        matches!(
            &self.kind,
            CreateClusterSubnetGroupErrorKind::InvalidSubnet(_)
        )
    }
    /// Returns `true` if the error kind is `CreateClusterSubnetGroupErrorKind::InvalidTagFault`.
    pub fn is_invalid_tag_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateClusterSubnetGroupErrorKind::InvalidTagFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateClusterSubnetGroupErrorKind::TagLimitExceededFault`.
    pub fn is_tag_limit_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateClusterSubnetGroupErrorKind::TagLimitExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateClusterSubnetGroupErrorKind::UnauthorizedOperation`.
    pub fn is_unauthorized_operation(&self) -> bool {
        matches!(
            &self.kind,
            CreateClusterSubnetGroupErrorKind::UnauthorizedOperation(_)
        )
    }
}
impl std::error::Error for CreateClusterSubnetGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateClusterSubnetGroupErrorKind::ClusterSubnetGroupAlreadyExistsFault(_inner) => {
                Some(_inner)
            }
            CreateClusterSubnetGroupErrorKind::ClusterSubnetGroupQuotaExceededFault(_inner) => {
                Some(_inner)
            }
            CreateClusterSubnetGroupErrorKind::ClusterSubnetQuotaExceededFault(_inner) => {
                Some(_inner)
            }
            CreateClusterSubnetGroupErrorKind::DependentServiceRequestThrottlingFault(_inner) => {
                Some(_inner)
            }
            CreateClusterSubnetGroupErrorKind::InvalidSubnet(_inner) => Some(_inner),
            CreateClusterSubnetGroupErrorKind::InvalidTagFault(_inner) => Some(_inner),
            CreateClusterSubnetGroupErrorKind::TagLimitExceededFault(_inner) => Some(_inner),
            CreateClusterSubnetGroupErrorKind::UnauthorizedOperation(_inner) => Some(_inner),
            CreateClusterSubnetGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateEndpointAccess` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateEndpointAccessError {
    /// Kind of error that occurred.
    pub kind: CreateEndpointAccessErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateEndpointAccess` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateEndpointAccessErrorKind {
    /// <p>You are not authorized to access the cluster.</p>
    AccessToClusterDeniedFault(crate::error::AccessToClusterDeniedFault),
    /// <p>The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster.
    /// </p>
    ClusterNotFoundFault(crate::error::ClusterNotFoundFault),
    /// <p>The cluster subnet group name does not refer to an existing cluster subnet
    /// group.</p>
    ClusterSubnetGroupNotFoundFault(crate::error::ClusterSubnetGroupNotFoundFault),
    /// <p>The account already has a Redshift-managed VPC endpoint with the given identifier.</p>
    EndpointAlreadyExistsFault(crate::error::EndpointAlreadyExistsFault),
    /// <p>The number of Redshift-managed VPC endpoints per authorization has exceeded its limit.</p>
    EndpointsPerAuthorizationLimitExceededFault(
        crate::error::EndpointsPerAuthorizationLimitExceededFault,
    ),
    /// <p>The number of Redshift-managed VPC endpoints per cluster has exceeded its limit.</p>
    EndpointsPerClusterLimitExceededFault(crate::error::EndpointsPerClusterLimitExceededFault),
    /// <p>The state of the cluster security group is not <code>available</code>. </p>
    InvalidClusterSecurityGroupStateFault(crate::error::InvalidClusterSecurityGroupStateFault),
    /// <p>The specified cluster is not in the <code>available</code> state. </p>
    InvalidClusterStateFault(crate::error::InvalidClusterStateFault),
    /// <p>Your account is not authorized to perform the requested operation.</p>
    UnauthorizedOperation(crate::error::UnauthorizedOperation),
    /// <p>The requested operation isn't supported.</p>
    UnsupportedOperationFault(crate::error::UnsupportedOperationFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateEndpointAccessError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateEndpointAccessErrorKind::AccessToClusterDeniedFault(_inner) => _inner.fmt(f),
            CreateEndpointAccessErrorKind::ClusterNotFoundFault(_inner) => _inner.fmt(f),
            CreateEndpointAccessErrorKind::ClusterSubnetGroupNotFoundFault(_inner) => _inner.fmt(f),
            CreateEndpointAccessErrorKind::EndpointAlreadyExistsFault(_inner) => _inner.fmt(f),
            CreateEndpointAccessErrorKind::EndpointsPerAuthorizationLimitExceededFault(_inner) => {
                _inner.fmt(f)
            }
            CreateEndpointAccessErrorKind::EndpointsPerClusterLimitExceededFault(_inner) => {
                _inner.fmt(f)
            }
            CreateEndpointAccessErrorKind::InvalidClusterSecurityGroupStateFault(_inner) => {
                _inner.fmt(f)
            }
            CreateEndpointAccessErrorKind::InvalidClusterStateFault(_inner) => _inner.fmt(f),
            CreateEndpointAccessErrorKind::UnauthorizedOperation(_inner) => _inner.fmt(f),
            CreateEndpointAccessErrorKind::UnsupportedOperationFault(_inner) => _inner.fmt(f),
            CreateEndpointAccessErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateEndpointAccessError {
    fn code(&self) -> Option<&str> {
        CreateEndpointAccessError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateEndpointAccessError {
    /// Creates a new `CreateEndpointAccessError`.
    pub fn new(kind: CreateEndpointAccessErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateEndpointAccessError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateEndpointAccessErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateEndpointAccessError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateEndpointAccessErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateEndpointAccessErrorKind::AccessToClusterDeniedFault`.
    pub fn is_access_to_cluster_denied_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateEndpointAccessErrorKind::AccessToClusterDeniedFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEndpointAccessErrorKind::ClusterNotFoundFault`.
    pub fn is_cluster_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateEndpointAccessErrorKind::ClusterNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEndpointAccessErrorKind::ClusterSubnetGroupNotFoundFault`.
    pub fn is_cluster_subnet_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateEndpointAccessErrorKind::ClusterSubnetGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEndpointAccessErrorKind::EndpointAlreadyExistsFault`.
    pub fn is_endpoint_already_exists_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateEndpointAccessErrorKind::EndpointAlreadyExistsFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEndpointAccessErrorKind::EndpointsPerAuthorizationLimitExceededFault`.
    pub fn is_endpoints_per_authorization_limit_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateEndpointAccessErrorKind::EndpointsPerAuthorizationLimitExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEndpointAccessErrorKind::EndpointsPerClusterLimitExceededFault`.
    pub fn is_endpoints_per_cluster_limit_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateEndpointAccessErrorKind::EndpointsPerClusterLimitExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEndpointAccessErrorKind::InvalidClusterSecurityGroupStateFault`.
    pub fn is_invalid_cluster_security_group_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateEndpointAccessErrorKind::InvalidClusterSecurityGroupStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEndpointAccessErrorKind::InvalidClusterStateFault`.
    pub fn is_invalid_cluster_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateEndpointAccessErrorKind::InvalidClusterStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEndpointAccessErrorKind::UnauthorizedOperation`.
    pub fn is_unauthorized_operation(&self) -> bool {
        matches!(
            &self.kind,
            CreateEndpointAccessErrorKind::UnauthorizedOperation(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEndpointAccessErrorKind::UnsupportedOperationFault`.
    pub fn is_unsupported_operation_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateEndpointAccessErrorKind::UnsupportedOperationFault(_)
        )
    }
}
impl std::error::Error for CreateEndpointAccessError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateEndpointAccessErrorKind::AccessToClusterDeniedFault(_inner) => Some(_inner),
            CreateEndpointAccessErrorKind::ClusterNotFoundFault(_inner) => Some(_inner),
            CreateEndpointAccessErrorKind::ClusterSubnetGroupNotFoundFault(_inner) => Some(_inner),
            CreateEndpointAccessErrorKind::EndpointAlreadyExistsFault(_inner) => Some(_inner),
            CreateEndpointAccessErrorKind::EndpointsPerAuthorizationLimitExceededFault(_inner) => {
                Some(_inner)
            }
            CreateEndpointAccessErrorKind::EndpointsPerClusterLimitExceededFault(_inner) => {
                Some(_inner)
            }
            CreateEndpointAccessErrorKind::InvalidClusterSecurityGroupStateFault(_inner) => {
                Some(_inner)
            }
            CreateEndpointAccessErrorKind::InvalidClusterStateFault(_inner) => Some(_inner),
            CreateEndpointAccessErrorKind::UnauthorizedOperation(_inner) => Some(_inner),
            CreateEndpointAccessErrorKind::UnsupportedOperationFault(_inner) => Some(_inner),
            CreateEndpointAccessErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateEventSubscription` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateEventSubscriptionError {
    /// Kind of error that occurred.
    pub kind: CreateEventSubscriptionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateEventSubscription` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateEventSubscriptionErrorKind {
    /// <p>The request would exceed the allowed number of event subscriptions for this
    /// account.
    /// For information about increasing your quota, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon Redshift</a>
    /// in the <i>Amazon Redshift Cluster Management Guide</i>.
    /// </p>
    EventSubscriptionQuotaExceededFault(crate::error::EventSubscriptionQuotaExceededFault),
    /// <p>The tag is invalid.</p>
    InvalidTagFault(crate::error::InvalidTagFault),
    /// <p>Amazon SNS has responded that there is a problem with the specified Amazon SNS
    /// topic.</p>
    SnsInvalidTopicFault(crate::error::SnsInvalidTopicFault),
    /// <p>You do not have permission to publish to the specified Amazon SNS topic.</p>
    SnsNoAuthorizationFault(crate::error::SnsNoAuthorizationFault),
    /// <p>An Amazon SNS topic with the specified Amazon Resource Name (ARN) does not
    /// exist.</p>
    SnsTopicArnNotFoundFault(crate::error::SnsTopicArnNotFoundFault),
    /// <p>The specified Amazon Redshift event source could not be found.</p>
    SourceNotFoundFault(crate::error::SourceNotFoundFault),
    /// <p>There is already an existing event notification subscription with the specified
    /// name.</p>
    SubscriptionAlreadyExistFault(crate::error::SubscriptionAlreadyExistFault),
    /// <p>The value specified for the event category was not one of the allowed values, or it
    /// specified a category that does not apply to the specified source type. The allowed
    /// values are Configuration, Management, Monitoring, and Security.</p>
    SubscriptionCategoryNotFoundFault(crate::error::SubscriptionCategoryNotFoundFault),
    /// <p>An Amazon Redshift event with the specified event ID does not exist.</p>
    SubscriptionEventIdNotFoundFault(crate::error::SubscriptionEventIdNotFoundFault),
    /// <p>The value specified for the event severity was not one of the allowed values, or it
    /// specified a severity that does not apply to the specified source type. The allowed
    /// values are ERROR and INFO.</p>
    SubscriptionSeverityNotFoundFault(crate::error::SubscriptionSeverityNotFoundFault),
    /// <p>You have exceeded the number of tags allowed.</p>
    TagLimitExceededFault(crate::error::TagLimitExceededFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateEventSubscriptionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateEventSubscriptionErrorKind::EventSubscriptionQuotaExceededFault(_inner) => {
                _inner.fmt(f)
            }
            CreateEventSubscriptionErrorKind::InvalidTagFault(_inner) => _inner.fmt(f),
            CreateEventSubscriptionErrorKind::SnsInvalidTopicFault(_inner) => _inner.fmt(f),
            CreateEventSubscriptionErrorKind::SnsNoAuthorizationFault(_inner) => _inner.fmt(f),
            CreateEventSubscriptionErrorKind::SnsTopicArnNotFoundFault(_inner) => _inner.fmt(f),
            CreateEventSubscriptionErrorKind::SourceNotFoundFault(_inner) => _inner.fmt(f),
            CreateEventSubscriptionErrorKind::SubscriptionAlreadyExistFault(_inner) => {
                _inner.fmt(f)
            }
            CreateEventSubscriptionErrorKind::SubscriptionCategoryNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            CreateEventSubscriptionErrorKind::SubscriptionEventIdNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            CreateEventSubscriptionErrorKind::SubscriptionSeverityNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            CreateEventSubscriptionErrorKind::TagLimitExceededFault(_inner) => _inner.fmt(f),
            CreateEventSubscriptionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateEventSubscriptionError {
    fn code(&self) -> Option<&str> {
        CreateEventSubscriptionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateEventSubscriptionError {
    /// Creates a new `CreateEventSubscriptionError`.
    pub fn new(kind: CreateEventSubscriptionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateEventSubscriptionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateEventSubscriptionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateEventSubscriptionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateEventSubscriptionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateEventSubscriptionErrorKind::EventSubscriptionQuotaExceededFault`.
    pub fn is_event_subscription_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateEventSubscriptionErrorKind::EventSubscriptionQuotaExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEventSubscriptionErrorKind::InvalidTagFault`.
    pub fn is_invalid_tag_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateEventSubscriptionErrorKind::InvalidTagFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEventSubscriptionErrorKind::SnsInvalidTopicFault`.
    pub fn is_sns_invalid_topic_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateEventSubscriptionErrorKind::SnsInvalidTopicFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEventSubscriptionErrorKind::SnsNoAuthorizationFault`.
    pub fn is_sns_no_authorization_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateEventSubscriptionErrorKind::SnsNoAuthorizationFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEventSubscriptionErrorKind::SnsTopicArnNotFoundFault`.
    pub fn is_sns_topic_arn_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateEventSubscriptionErrorKind::SnsTopicArnNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEventSubscriptionErrorKind::SourceNotFoundFault`.
    pub fn is_source_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateEventSubscriptionErrorKind::SourceNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEventSubscriptionErrorKind::SubscriptionAlreadyExistFault`.
    pub fn is_subscription_already_exist_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateEventSubscriptionErrorKind::SubscriptionAlreadyExistFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEventSubscriptionErrorKind::SubscriptionCategoryNotFoundFault`.
    pub fn is_subscription_category_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateEventSubscriptionErrorKind::SubscriptionCategoryNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEventSubscriptionErrorKind::SubscriptionEventIdNotFoundFault`.
    pub fn is_subscription_event_id_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateEventSubscriptionErrorKind::SubscriptionEventIdNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEventSubscriptionErrorKind::SubscriptionSeverityNotFoundFault`.
    pub fn is_subscription_severity_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateEventSubscriptionErrorKind::SubscriptionSeverityNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEventSubscriptionErrorKind::TagLimitExceededFault`.
    pub fn is_tag_limit_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateEventSubscriptionErrorKind::TagLimitExceededFault(_)
        )
    }
}
impl std::error::Error for CreateEventSubscriptionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateEventSubscriptionErrorKind::EventSubscriptionQuotaExceededFault(_inner) => {
                Some(_inner)
            }
            CreateEventSubscriptionErrorKind::InvalidTagFault(_inner) => Some(_inner),
            CreateEventSubscriptionErrorKind::SnsInvalidTopicFault(_inner) => Some(_inner),
            CreateEventSubscriptionErrorKind::SnsNoAuthorizationFault(_inner) => Some(_inner),
            CreateEventSubscriptionErrorKind::SnsTopicArnNotFoundFault(_inner) => Some(_inner),
            CreateEventSubscriptionErrorKind::SourceNotFoundFault(_inner) => Some(_inner),
            CreateEventSubscriptionErrorKind::SubscriptionAlreadyExistFault(_inner) => Some(_inner),
            CreateEventSubscriptionErrorKind::SubscriptionCategoryNotFoundFault(_inner) => {
                Some(_inner)
            }
            CreateEventSubscriptionErrorKind::SubscriptionEventIdNotFoundFault(_inner) => {
                Some(_inner)
            }
            CreateEventSubscriptionErrorKind::SubscriptionSeverityNotFoundFault(_inner) => {
                Some(_inner)
            }
            CreateEventSubscriptionErrorKind::TagLimitExceededFault(_inner) => Some(_inner),
            CreateEventSubscriptionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateHsmClientCertificate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateHsmClientCertificateError {
    /// Kind of error that occurred.
    pub kind: CreateHsmClientCertificateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateHsmClientCertificate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateHsmClientCertificateErrorKind {
    /// <p>There is already an existing Amazon Redshift HSM client certificate with the specified
    /// identifier.</p>
    HsmClientCertificateAlreadyExistsFault(crate::error::HsmClientCertificateAlreadyExistsFault),
    /// <p>The quota for HSM client certificates has been reached.
    /// For information about increasing your quota, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon Redshift</a>
    /// in the <i>Amazon Redshift Cluster Management Guide</i>.
    /// </p>
    HsmClientCertificateQuotaExceededFault(crate::error::HsmClientCertificateQuotaExceededFault),
    /// <p>The tag is invalid.</p>
    InvalidTagFault(crate::error::InvalidTagFault),
    /// <p>You have exceeded the number of tags allowed.</p>
    TagLimitExceededFault(crate::error::TagLimitExceededFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateHsmClientCertificateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateHsmClientCertificateErrorKind::HsmClientCertificateAlreadyExistsFault(_inner) => {
                _inner.fmt(f)
            }
            CreateHsmClientCertificateErrorKind::HsmClientCertificateQuotaExceededFault(_inner) => {
                _inner.fmt(f)
            }
            CreateHsmClientCertificateErrorKind::InvalidTagFault(_inner) => _inner.fmt(f),
            CreateHsmClientCertificateErrorKind::TagLimitExceededFault(_inner) => _inner.fmt(f),
            CreateHsmClientCertificateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateHsmClientCertificateError {
    fn code(&self) -> Option<&str> {
        CreateHsmClientCertificateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateHsmClientCertificateError {
    /// Creates a new `CreateHsmClientCertificateError`.
    pub fn new(kind: CreateHsmClientCertificateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateHsmClientCertificateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateHsmClientCertificateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateHsmClientCertificateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateHsmClientCertificateErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateHsmClientCertificateErrorKind::HsmClientCertificateAlreadyExistsFault`.
    pub fn is_hsm_client_certificate_already_exists_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateHsmClientCertificateErrorKind::HsmClientCertificateAlreadyExistsFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateHsmClientCertificateErrorKind::HsmClientCertificateQuotaExceededFault`.
    pub fn is_hsm_client_certificate_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateHsmClientCertificateErrorKind::HsmClientCertificateQuotaExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateHsmClientCertificateErrorKind::InvalidTagFault`.
    pub fn is_invalid_tag_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateHsmClientCertificateErrorKind::InvalidTagFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateHsmClientCertificateErrorKind::TagLimitExceededFault`.
    pub fn is_tag_limit_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateHsmClientCertificateErrorKind::TagLimitExceededFault(_)
        )
    }
}
impl std::error::Error for CreateHsmClientCertificateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateHsmClientCertificateErrorKind::HsmClientCertificateAlreadyExistsFault(_inner) => {
                Some(_inner)
            }
            CreateHsmClientCertificateErrorKind::HsmClientCertificateQuotaExceededFault(_inner) => {
                Some(_inner)
            }
            CreateHsmClientCertificateErrorKind::InvalidTagFault(_inner) => Some(_inner),
            CreateHsmClientCertificateErrorKind::TagLimitExceededFault(_inner) => Some(_inner),
            CreateHsmClientCertificateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateHsmConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateHsmConfigurationError {
    /// Kind of error that occurred.
    pub kind: CreateHsmConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateHsmConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateHsmConfigurationErrorKind {
    /// <p>There is already an existing Amazon Redshift HSM configuration with the specified
    /// identifier.</p>
    HsmConfigurationAlreadyExistsFault(crate::error::HsmConfigurationAlreadyExistsFault),
    /// <p>The quota for HSM configurations has been reached.
    /// For information about increasing your quota, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon Redshift</a>
    /// in the <i>Amazon Redshift Cluster Management Guide</i>.
    /// </p>
    HsmConfigurationQuotaExceededFault(crate::error::HsmConfigurationQuotaExceededFault),
    /// <p>The tag is invalid.</p>
    InvalidTagFault(crate::error::InvalidTagFault),
    /// <p>You have exceeded the number of tags allowed.</p>
    TagLimitExceededFault(crate::error::TagLimitExceededFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateHsmConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateHsmConfigurationErrorKind::HsmConfigurationAlreadyExistsFault(_inner) => {
                _inner.fmt(f)
            }
            CreateHsmConfigurationErrorKind::HsmConfigurationQuotaExceededFault(_inner) => {
                _inner.fmt(f)
            }
            CreateHsmConfigurationErrorKind::InvalidTagFault(_inner) => _inner.fmt(f),
            CreateHsmConfigurationErrorKind::TagLimitExceededFault(_inner) => _inner.fmt(f),
            CreateHsmConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateHsmConfigurationError {
    fn code(&self) -> Option<&str> {
        CreateHsmConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateHsmConfigurationError {
    /// Creates a new `CreateHsmConfigurationError`.
    pub fn new(kind: CreateHsmConfigurationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateHsmConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateHsmConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateHsmConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateHsmConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateHsmConfigurationErrorKind::HsmConfigurationAlreadyExistsFault`.
    pub fn is_hsm_configuration_already_exists_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateHsmConfigurationErrorKind::HsmConfigurationAlreadyExistsFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateHsmConfigurationErrorKind::HsmConfigurationQuotaExceededFault`.
    pub fn is_hsm_configuration_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateHsmConfigurationErrorKind::HsmConfigurationQuotaExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateHsmConfigurationErrorKind::InvalidTagFault`.
    pub fn is_invalid_tag_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateHsmConfigurationErrorKind::InvalidTagFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateHsmConfigurationErrorKind::TagLimitExceededFault`.
    pub fn is_tag_limit_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateHsmConfigurationErrorKind::TagLimitExceededFault(_)
        )
    }
}
impl std::error::Error for CreateHsmConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateHsmConfigurationErrorKind::HsmConfigurationAlreadyExistsFault(_inner) => {
                Some(_inner)
            }
            CreateHsmConfigurationErrorKind::HsmConfigurationQuotaExceededFault(_inner) => {
                Some(_inner)
            }
            CreateHsmConfigurationErrorKind::InvalidTagFault(_inner) => Some(_inner),
            CreateHsmConfigurationErrorKind::TagLimitExceededFault(_inner) => Some(_inner),
            CreateHsmConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateScheduledAction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateScheduledActionError {
    /// Kind of error that occurred.
    pub kind: CreateScheduledActionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateScheduledAction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateScheduledActionErrorKind {
    /// <p>The scheduled action is not valid. </p>
    InvalidScheduledActionFault(crate::error::InvalidScheduledActionFault),
    /// <p>The schedule you submitted isn't valid.</p>
    InvalidScheduleFault(crate::error::InvalidScheduleFault),
    /// <p>The scheduled action already exists. </p>
    ScheduledActionAlreadyExistsFault(crate::error::ScheduledActionAlreadyExistsFault),
    /// <p>The quota for scheduled actions exceeded. </p>
    ScheduledActionQuotaExceededFault(crate::error::ScheduledActionQuotaExceededFault),
    /// <p>The action type specified for a scheduled action is not supported. </p>
    ScheduledActionTypeUnsupportedFault(crate::error::ScheduledActionTypeUnsupportedFault),
    /// <p>Your account is not authorized to perform the requested operation.</p>
    UnauthorizedOperation(crate::error::UnauthorizedOperation),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateScheduledActionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateScheduledActionErrorKind::InvalidScheduledActionFault(_inner) => _inner.fmt(f),
            CreateScheduledActionErrorKind::InvalidScheduleFault(_inner) => _inner.fmt(f),
            CreateScheduledActionErrorKind::ScheduledActionAlreadyExistsFault(_inner) => {
                _inner.fmt(f)
            }
            CreateScheduledActionErrorKind::ScheduledActionQuotaExceededFault(_inner) => {
                _inner.fmt(f)
            }
            CreateScheduledActionErrorKind::ScheduledActionTypeUnsupportedFault(_inner) => {
                _inner.fmt(f)
            }
            CreateScheduledActionErrorKind::UnauthorizedOperation(_inner) => _inner.fmt(f),
            CreateScheduledActionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateScheduledActionError {
    fn code(&self) -> Option<&str> {
        CreateScheduledActionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateScheduledActionError {
    /// Creates a new `CreateScheduledActionError`.
    pub fn new(kind: CreateScheduledActionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateScheduledActionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateScheduledActionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateScheduledActionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateScheduledActionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateScheduledActionErrorKind::InvalidScheduledActionFault`.
    pub fn is_invalid_scheduled_action_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateScheduledActionErrorKind::InvalidScheduledActionFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateScheduledActionErrorKind::InvalidScheduleFault`.
    pub fn is_invalid_schedule_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateScheduledActionErrorKind::InvalidScheduleFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateScheduledActionErrorKind::ScheduledActionAlreadyExistsFault`.
    pub fn is_scheduled_action_already_exists_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateScheduledActionErrorKind::ScheduledActionAlreadyExistsFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateScheduledActionErrorKind::ScheduledActionQuotaExceededFault`.
    pub fn is_scheduled_action_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateScheduledActionErrorKind::ScheduledActionQuotaExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateScheduledActionErrorKind::ScheduledActionTypeUnsupportedFault`.
    pub fn is_scheduled_action_type_unsupported_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateScheduledActionErrorKind::ScheduledActionTypeUnsupportedFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateScheduledActionErrorKind::UnauthorizedOperation`.
    pub fn is_unauthorized_operation(&self) -> bool {
        matches!(
            &self.kind,
            CreateScheduledActionErrorKind::UnauthorizedOperation(_)
        )
    }
}
impl std::error::Error for CreateScheduledActionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateScheduledActionErrorKind::InvalidScheduledActionFault(_inner) => Some(_inner),
            CreateScheduledActionErrorKind::InvalidScheduleFault(_inner) => Some(_inner),
            CreateScheduledActionErrorKind::ScheduledActionAlreadyExistsFault(_inner) => {
                Some(_inner)
            }
            CreateScheduledActionErrorKind::ScheduledActionQuotaExceededFault(_inner) => {
                Some(_inner)
            }
            CreateScheduledActionErrorKind::ScheduledActionTypeUnsupportedFault(_inner) => {
                Some(_inner)
            }
            CreateScheduledActionErrorKind::UnauthorizedOperation(_inner) => Some(_inner),
            CreateScheduledActionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateSnapshotCopyGrant` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateSnapshotCopyGrantError {
    /// Kind of error that occurred.
    pub kind: CreateSnapshotCopyGrantErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateSnapshotCopyGrant` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateSnapshotCopyGrantErrorKind {
    /// <p>The request cannot be completed because a dependent service is throttling requests
    /// made by Amazon Redshift on your behalf. Wait and retry the request.</p>
    DependentServiceRequestThrottlingFault(crate::error::DependentServiceRequestThrottlingFault),
    /// <p>The tag is invalid.</p>
    InvalidTagFault(crate::error::InvalidTagFault),
    /// <p>The encryption key has exceeded its grant limit in Amazon Web Services KMS.</p>
    LimitExceededFault(crate::error::LimitExceededFault),
    /// <p>The snapshot copy grant can't be created because a grant with the same name already
    /// exists.</p>
    SnapshotCopyGrantAlreadyExistsFault(crate::error::SnapshotCopyGrantAlreadyExistsFault),
    /// <p>The Amazon Web Services account has exceeded the maximum number of snapshot copy grants in this
    /// region.</p>
    SnapshotCopyGrantQuotaExceededFault(crate::error::SnapshotCopyGrantQuotaExceededFault),
    /// <p>You have exceeded the number of tags allowed.</p>
    TagLimitExceededFault(crate::error::TagLimitExceededFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateSnapshotCopyGrantError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateSnapshotCopyGrantErrorKind::DependentServiceRequestThrottlingFault(_inner) => {
                _inner.fmt(f)
            }
            CreateSnapshotCopyGrantErrorKind::InvalidTagFault(_inner) => _inner.fmt(f),
            CreateSnapshotCopyGrantErrorKind::LimitExceededFault(_inner) => _inner.fmt(f),
            CreateSnapshotCopyGrantErrorKind::SnapshotCopyGrantAlreadyExistsFault(_inner) => {
                _inner.fmt(f)
            }
            CreateSnapshotCopyGrantErrorKind::SnapshotCopyGrantQuotaExceededFault(_inner) => {
                _inner.fmt(f)
            }
            CreateSnapshotCopyGrantErrorKind::TagLimitExceededFault(_inner) => _inner.fmt(f),
            CreateSnapshotCopyGrantErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateSnapshotCopyGrantError {
    fn code(&self) -> Option<&str> {
        CreateSnapshotCopyGrantError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateSnapshotCopyGrantError {
    /// Creates a new `CreateSnapshotCopyGrantError`.
    pub fn new(kind: CreateSnapshotCopyGrantErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateSnapshotCopyGrantError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateSnapshotCopyGrantErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateSnapshotCopyGrantError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateSnapshotCopyGrantErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateSnapshotCopyGrantErrorKind::DependentServiceRequestThrottlingFault`.
    pub fn is_dependent_service_request_throttling_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateSnapshotCopyGrantErrorKind::DependentServiceRequestThrottlingFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSnapshotCopyGrantErrorKind::InvalidTagFault`.
    pub fn is_invalid_tag_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateSnapshotCopyGrantErrorKind::InvalidTagFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSnapshotCopyGrantErrorKind::LimitExceededFault`.
    pub fn is_limit_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateSnapshotCopyGrantErrorKind::LimitExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSnapshotCopyGrantErrorKind::SnapshotCopyGrantAlreadyExistsFault`.
    pub fn is_snapshot_copy_grant_already_exists_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateSnapshotCopyGrantErrorKind::SnapshotCopyGrantAlreadyExistsFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSnapshotCopyGrantErrorKind::SnapshotCopyGrantQuotaExceededFault`.
    pub fn is_snapshot_copy_grant_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateSnapshotCopyGrantErrorKind::SnapshotCopyGrantQuotaExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSnapshotCopyGrantErrorKind::TagLimitExceededFault`.
    pub fn is_tag_limit_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateSnapshotCopyGrantErrorKind::TagLimitExceededFault(_)
        )
    }
}
impl std::error::Error for CreateSnapshotCopyGrantError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateSnapshotCopyGrantErrorKind::DependentServiceRequestThrottlingFault(_inner) => {
                Some(_inner)
            }
            CreateSnapshotCopyGrantErrorKind::InvalidTagFault(_inner) => Some(_inner),
            CreateSnapshotCopyGrantErrorKind::LimitExceededFault(_inner) => Some(_inner),
            CreateSnapshotCopyGrantErrorKind::SnapshotCopyGrantAlreadyExistsFault(_inner) => {
                Some(_inner)
            }
            CreateSnapshotCopyGrantErrorKind::SnapshotCopyGrantQuotaExceededFault(_inner) => {
                Some(_inner)
            }
            CreateSnapshotCopyGrantErrorKind::TagLimitExceededFault(_inner) => Some(_inner),
            CreateSnapshotCopyGrantErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateSnapshotSchedule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateSnapshotScheduleError {
    /// Kind of error that occurred.
    pub kind: CreateSnapshotScheduleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateSnapshotSchedule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateSnapshotScheduleErrorKind {
    /// <p>The schedule you submitted isn't valid.</p>
    InvalidScheduleFault(crate::error::InvalidScheduleFault),
    /// <p>The tag is invalid.</p>
    InvalidTagFault(crate::error::InvalidTagFault),
    /// <p>The definition you submitted is not supported.</p>
    ScheduleDefinitionTypeUnsupportedFault(crate::error::ScheduleDefinitionTypeUnsupportedFault),
    /// <p>The specified snapshot schedule already exists. </p>
    SnapshotScheduleAlreadyExistsFault(crate::error::SnapshotScheduleAlreadyExistsFault),
    /// <p>You have exceeded the quota of snapshot schedules. </p>
    SnapshotScheduleQuotaExceededFault(crate::error::SnapshotScheduleQuotaExceededFault),
    /// <p>You have exceeded the number of tags allowed.</p>
    TagLimitExceededFault(crate::error::TagLimitExceededFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateSnapshotScheduleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateSnapshotScheduleErrorKind::InvalidScheduleFault(_inner) => _inner.fmt(f),
            CreateSnapshotScheduleErrorKind::InvalidTagFault(_inner) => _inner.fmt(f),
            CreateSnapshotScheduleErrorKind::ScheduleDefinitionTypeUnsupportedFault(_inner) => {
                _inner.fmt(f)
            }
            CreateSnapshotScheduleErrorKind::SnapshotScheduleAlreadyExistsFault(_inner) => {
                _inner.fmt(f)
            }
            CreateSnapshotScheduleErrorKind::SnapshotScheduleQuotaExceededFault(_inner) => {
                _inner.fmt(f)
            }
            CreateSnapshotScheduleErrorKind::TagLimitExceededFault(_inner) => _inner.fmt(f),
            CreateSnapshotScheduleErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateSnapshotScheduleError {
    fn code(&self) -> Option<&str> {
        CreateSnapshotScheduleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateSnapshotScheduleError {
    /// Creates a new `CreateSnapshotScheduleError`.
    pub fn new(kind: CreateSnapshotScheduleErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateSnapshotScheduleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateSnapshotScheduleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateSnapshotScheduleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateSnapshotScheduleErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateSnapshotScheduleErrorKind::InvalidScheduleFault`.
    pub fn is_invalid_schedule_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateSnapshotScheduleErrorKind::InvalidScheduleFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSnapshotScheduleErrorKind::InvalidTagFault`.
    pub fn is_invalid_tag_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateSnapshotScheduleErrorKind::InvalidTagFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSnapshotScheduleErrorKind::ScheduleDefinitionTypeUnsupportedFault`.
    pub fn is_schedule_definition_type_unsupported_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateSnapshotScheduleErrorKind::ScheduleDefinitionTypeUnsupportedFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSnapshotScheduleErrorKind::SnapshotScheduleAlreadyExistsFault`.
    pub fn is_snapshot_schedule_already_exists_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateSnapshotScheduleErrorKind::SnapshotScheduleAlreadyExistsFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSnapshotScheduleErrorKind::SnapshotScheduleQuotaExceededFault`.
    pub fn is_snapshot_schedule_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateSnapshotScheduleErrorKind::SnapshotScheduleQuotaExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSnapshotScheduleErrorKind::TagLimitExceededFault`.
    pub fn is_tag_limit_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateSnapshotScheduleErrorKind::TagLimitExceededFault(_)
        )
    }
}
impl std::error::Error for CreateSnapshotScheduleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateSnapshotScheduleErrorKind::InvalidScheduleFault(_inner) => Some(_inner),
            CreateSnapshotScheduleErrorKind::InvalidTagFault(_inner) => Some(_inner),
            CreateSnapshotScheduleErrorKind::ScheduleDefinitionTypeUnsupportedFault(_inner) => {
                Some(_inner)
            }
            CreateSnapshotScheduleErrorKind::SnapshotScheduleAlreadyExistsFault(_inner) => {
                Some(_inner)
            }
            CreateSnapshotScheduleErrorKind::SnapshotScheduleQuotaExceededFault(_inner) => {
                Some(_inner)
            }
            CreateSnapshotScheduleErrorKind::TagLimitExceededFault(_inner) => Some(_inner),
            CreateSnapshotScheduleErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateTagsError {
    /// Kind of error that occurred.
    pub kind: CreateTagsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateTagsErrorKind {
    /// <p>The specified cluster is not in the <code>available</code> state. </p>
    InvalidClusterStateFault(crate::error::InvalidClusterStateFault),
    /// <p>The tag is invalid.</p>
    InvalidTagFault(crate::error::InvalidTagFault),
    /// <p>The resource could not be found.</p>
    ResourceNotFoundFault(crate::error::ResourceNotFoundFault),
    /// <p>You have exceeded the number of tags allowed.</p>
    TagLimitExceededFault(crate::error::TagLimitExceededFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateTagsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateTagsErrorKind::InvalidClusterStateFault(_inner) => _inner.fmt(f),
            CreateTagsErrorKind::InvalidTagFault(_inner) => _inner.fmt(f),
            CreateTagsErrorKind::ResourceNotFoundFault(_inner) => _inner.fmt(f),
            CreateTagsErrorKind::TagLimitExceededFault(_inner) => _inner.fmt(f),
            CreateTagsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateTagsError {
    fn code(&self) -> Option<&str> {
        CreateTagsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateTagsError {
    /// Creates a new `CreateTagsError`.
    pub fn new(kind: CreateTagsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateTagsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateTagsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateTagsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateTagsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateTagsErrorKind::InvalidClusterStateFault`.
    pub fn is_invalid_cluster_state_fault(&self) -> bool {
        matches!(&self.kind, CreateTagsErrorKind::InvalidClusterStateFault(_))
    }
    /// Returns `true` if the error kind is `CreateTagsErrorKind::InvalidTagFault`.
    pub fn is_invalid_tag_fault(&self) -> bool {
        matches!(&self.kind, CreateTagsErrorKind::InvalidTagFault(_))
    }
    /// Returns `true` if the error kind is `CreateTagsErrorKind::ResourceNotFoundFault`.
    pub fn is_resource_not_found_fault(&self) -> bool {
        matches!(&self.kind, CreateTagsErrorKind::ResourceNotFoundFault(_))
    }
    /// Returns `true` if the error kind is `CreateTagsErrorKind::TagLimitExceededFault`.
    pub fn is_tag_limit_exceeded_fault(&self) -> bool {
        matches!(&self.kind, CreateTagsErrorKind::TagLimitExceededFault(_))
    }
}
impl std::error::Error for CreateTagsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateTagsErrorKind::InvalidClusterStateFault(_inner) => Some(_inner),
            CreateTagsErrorKind::InvalidTagFault(_inner) => Some(_inner),
            CreateTagsErrorKind::ResourceNotFoundFault(_inner) => Some(_inner),
            CreateTagsErrorKind::TagLimitExceededFault(_inner) => Some(_inner),
            CreateTagsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateUsageLimit` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateUsageLimitError {
    /// Kind of error that occurred.
    pub kind: CreateUsageLimitErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateUsageLimit` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateUsageLimitErrorKind {
    /// <p>The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster.
    /// </p>
    ClusterNotFoundFault(crate::error::ClusterNotFoundFault),
    /// <p>The specified cluster is not in the <code>available</code> state. </p>
    InvalidClusterStateFault(crate::error::InvalidClusterStateFault),
    /// <p>The usage limit is not valid.</p>
    InvalidUsageLimitFault(crate::error::InvalidUsageLimitFault),
    /// <p>The encryption key has exceeded its grant limit in Amazon Web Services KMS.</p>
    LimitExceededFault(crate::error::LimitExceededFault),
    /// <p>You have exceeded the number of tags allowed.</p>
    TagLimitExceededFault(crate::error::TagLimitExceededFault),
    /// <p>The requested operation isn't supported.</p>
    UnsupportedOperationFault(crate::error::UnsupportedOperationFault),
    /// <p>The usage limit already exists. </p>
    UsageLimitAlreadyExistsFault(crate::error::UsageLimitAlreadyExistsFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateUsageLimitError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateUsageLimitErrorKind::ClusterNotFoundFault(_inner) => _inner.fmt(f),
            CreateUsageLimitErrorKind::InvalidClusterStateFault(_inner) => _inner.fmt(f),
            CreateUsageLimitErrorKind::InvalidUsageLimitFault(_inner) => _inner.fmt(f),
            CreateUsageLimitErrorKind::LimitExceededFault(_inner) => _inner.fmt(f),
            CreateUsageLimitErrorKind::TagLimitExceededFault(_inner) => _inner.fmt(f),
            CreateUsageLimitErrorKind::UnsupportedOperationFault(_inner) => _inner.fmt(f),
            CreateUsageLimitErrorKind::UsageLimitAlreadyExistsFault(_inner) => _inner.fmt(f),
            CreateUsageLimitErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateUsageLimitError {
    fn code(&self) -> Option<&str> {
        CreateUsageLimitError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateUsageLimitError {
    /// Creates a new `CreateUsageLimitError`.
    pub fn new(kind: CreateUsageLimitErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateUsageLimitError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateUsageLimitErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateUsageLimitError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateUsageLimitErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateUsageLimitErrorKind::ClusterNotFoundFault`.
    pub fn is_cluster_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateUsageLimitErrorKind::ClusterNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUsageLimitErrorKind::InvalidClusterStateFault`.
    pub fn is_invalid_cluster_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateUsageLimitErrorKind::InvalidClusterStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUsageLimitErrorKind::InvalidUsageLimitFault`.
    pub fn is_invalid_usage_limit_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateUsageLimitErrorKind::InvalidUsageLimitFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUsageLimitErrorKind::LimitExceededFault`.
    pub fn is_limit_exceeded_fault(&self) -> bool {
        matches!(&self.kind, CreateUsageLimitErrorKind::LimitExceededFault(_))
    }
    /// Returns `true` if the error kind is `CreateUsageLimitErrorKind::TagLimitExceededFault`.
    pub fn is_tag_limit_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateUsageLimitErrorKind::TagLimitExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUsageLimitErrorKind::UnsupportedOperationFault`.
    pub fn is_unsupported_operation_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateUsageLimitErrorKind::UnsupportedOperationFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateUsageLimitErrorKind::UsageLimitAlreadyExistsFault`.
    pub fn is_usage_limit_already_exists_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateUsageLimitErrorKind::UsageLimitAlreadyExistsFault(_)
        )
    }
}
impl std::error::Error for CreateUsageLimitError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateUsageLimitErrorKind::ClusterNotFoundFault(_inner) => Some(_inner),
            CreateUsageLimitErrorKind::InvalidClusterStateFault(_inner) => Some(_inner),
            CreateUsageLimitErrorKind::InvalidUsageLimitFault(_inner) => Some(_inner),
            CreateUsageLimitErrorKind::LimitExceededFault(_inner) => Some(_inner),
            CreateUsageLimitErrorKind::TagLimitExceededFault(_inner) => Some(_inner),
            CreateUsageLimitErrorKind::UnsupportedOperationFault(_inner) => Some(_inner),
            CreateUsageLimitErrorKind::UsageLimitAlreadyExistsFault(_inner) => Some(_inner),
            CreateUsageLimitErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeauthorizeDataShare` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeauthorizeDataShareError {
    /// Kind of error that occurred.
    pub kind: DeauthorizeDataShareErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeauthorizeDataShare` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeauthorizeDataShareErrorKind {
    /// <p>There is an error with the datashare.</p>
    InvalidDataShareFault(crate::error::InvalidDataShareFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeauthorizeDataShareError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeauthorizeDataShareErrorKind::InvalidDataShareFault(_inner) => _inner.fmt(f),
            DeauthorizeDataShareErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeauthorizeDataShareError {
    fn code(&self) -> Option<&str> {
        DeauthorizeDataShareError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeauthorizeDataShareError {
    /// Creates a new `DeauthorizeDataShareError`.
    pub fn new(kind: DeauthorizeDataShareErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeauthorizeDataShareError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeauthorizeDataShareErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeauthorizeDataShareError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeauthorizeDataShareErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeauthorizeDataShareErrorKind::InvalidDataShareFault`.
    pub fn is_invalid_data_share_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeauthorizeDataShareErrorKind::InvalidDataShareFault(_)
        )
    }
}
impl std::error::Error for DeauthorizeDataShareError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeauthorizeDataShareErrorKind::InvalidDataShareFault(_inner) => Some(_inner),
            DeauthorizeDataShareErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteAuthenticationProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteAuthenticationProfileError {
    /// Kind of error that occurred.
    pub kind: DeleteAuthenticationProfileErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteAuthenticationProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteAuthenticationProfileErrorKind {
    /// <p>The authentication profile can't be found.</p>
    AuthenticationProfileNotFoundFault(crate::error::AuthenticationProfileNotFoundFault),
    /// <p>The authentication profile request is not valid. The profile name can't be null or empty.
    /// The authentication profile API operation must be available in the Amazon Web Services Region.</p>
    InvalidAuthenticationProfileRequestFault(
        crate::error::InvalidAuthenticationProfileRequestFault,
    ),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteAuthenticationProfileError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteAuthenticationProfileErrorKind::AuthenticationProfileNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            DeleteAuthenticationProfileErrorKind::InvalidAuthenticationProfileRequestFault(
                _inner,
            ) => _inner.fmt(f),
            DeleteAuthenticationProfileErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteAuthenticationProfileError {
    fn code(&self) -> Option<&str> {
        DeleteAuthenticationProfileError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteAuthenticationProfileError {
    /// Creates a new `DeleteAuthenticationProfileError`.
    pub fn new(kind: DeleteAuthenticationProfileErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteAuthenticationProfileError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteAuthenticationProfileErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteAuthenticationProfileError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteAuthenticationProfileErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteAuthenticationProfileErrorKind::AuthenticationProfileNotFoundFault`.
    pub fn is_authentication_profile_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAuthenticationProfileErrorKind::AuthenticationProfileNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteAuthenticationProfileErrorKind::InvalidAuthenticationProfileRequestFault`.
    pub fn is_invalid_authentication_profile_request_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteAuthenticationProfileErrorKind::InvalidAuthenticationProfileRequestFault(_)
        )
    }
}
impl std::error::Error for DeleteAuthenticationProfileError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteAuthenticationProfileErrorKind::AuthenticationProfileNotFoundFault(_inner) => {
                Some(_inner)
            }
            DeleteAuthenticationProfileErrorKind::InvalidAuthenticationProfileRequestFault(
                _inner,
            ) => Some(_inner),
            DeleteAuthenticationProfileErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteClusterError {
    /// Kind of error that occurred.
    pub kind: DeleteClusterErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteClusterErrorKind {
    /// <p>The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster.
    /// </p>
    ClusterNotFoundFault(crate::error::ClusterNotFoundFault),
    /// <p>The value specified as a snapshot identifier is already used by an existing
    /// snapshot.</p>
    ClusterSnapshotAlreadyExistsFault(crate::error::ClusterSnapshotAlreadyExistsFault),
    /// <p>The request would result in the user exceeding the allowed number of cluster
    /// snapshots.</p>
    ClusterSnapshotQuotaExceededFault(crate::error::ClusterSnapshotQuotaExceededFault),
    /// <p>The specified cluster is not in the <code>available</code> state. </p>
    InvalidClusterStateFault(crate::error::InvalidClusterStateFault),
    /// <p>The retention period specified is either in the past or is not a valid value.</p>
    /// <p>The value must be either -1 or an integer between 1 and 3,653.</p>
    InvalidRetentionPeriodFault(crate::error::InvalidRetentionPeriodFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteClusterError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteClusterErrorKind::ClusterNotFoundFault(_inner) => _inner.fmt(f),
            DeleteClusterErrorKind::ClusterSnapshotAlreadyExistsFault(_inner) => _inner.fmt(f),
            DeleteClusterErrorKind::ClusterSnapshotQuotaExceededFault(_inner) => _inner.fmt(f),
            DeleteClusterErrorKind::InvalidClusterStateFault(_inner) => _inner.fmt(f),
            DeleteClusterErrorKind::InvalidRetentionPeriodFault(_inner) => _inner.fmt(f),
            DeleteClusterErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteClusterError {
    fn code(&self) -> Option<&str> {
        DeleteClusterError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteClusterError {
    /// Creates a new `DeleteClusterError`.
    pub fn new(kind: DeleteClusterErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteClusterError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteClusterErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteClusterError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteClusterErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteClusterErrorKind::ClusterNotFoundFault`.
    pub fn is_cluster_not_found_fault(&self) -> bool {
        matches!(&self.kind, DeleteClusterErrorKind::ClusterNotFoundFault(_))
    }
    /// Returns `true` if the error kind is `DeleteClusterErrorKind::ClusterSnapshotAlreadyExistsFault`.
    pub fn is_cluster_snapshot_already_exists_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteClusterErrorKind::ClusterSnapshotAlreadyExistsFault(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteClusterErrorKind::ClusterSnapshotQuotaExceededFault`.
    pub fn is_cluster_snapshot_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteClusterErrorKind::ClusterSnapshotQuotaExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteClusterErrorKind::InvalidClusterStateFault`.
    pub fn is_invalid_cluster_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteClusterErrorKind::InvalidClusterStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteClusterErrorKind::InvalidRetentionPeriodFault`.
    pub fn is_invalid_retention_period_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteClusterErrorKind::InvalidRetentionPeriodFault(_)
        )
    }
}
impl std::error::Error for DeleteClusterError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteClusterErrorKind::ClusterNotFoundFault(_inner) => Some(_inner),
            DeleteClusterErrorKind::ClusterSnapshotAlreadyExistsFault(_inner) => Some(_inner),
            DeleteClusterErrorKind::ClusterSnapshotQuotaExceededFault(_inner) => Some(_inner),
            DeleteClusterErrorKind::InvalidClusterStateFault(_inner) => Some(_inner),
            DeleteClusterErrorKind::InvalidRetentionPeriodFault(_inner) => Some(_inner),
            DeleteClusterErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteClusterParameterGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteClusterParameterGroupError {
    /// Kind of error that occurred.
    pub kind: DeleteClusterParameterGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteClusterParameterGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteClusterParameterGroupErrorKind {
    /// <p>The parameter group name does not refer to an existing parameter group.</p>
    ClusterParameterGroupNotFoundFault(crate::error::ClusterParameterGroupNotFoundFault),
    /// <p>The cluster parameter group action can not be completed because another task is in
    /// progress that involves the parameter group. Wait a few moments and try the operation
    /// again.</p>
    InvalidClusterParameterGroupStateFault(crate::error::InvalidClusterParameterGroupStateFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteClusterParameterGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteClusterParameterGroupErrorKind::ClusterParameterGroupNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            DeleteClusterParameterGroupErrorKind::InvalidClusterParameterGroupStateFault(
                _inner,
            ) => _inner.fmt(f),
            DeleteClusterParameterGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteClusterParameterGroupError {
    fn code(&self) -> Option<&str> {
        DeleteClusterParameterGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteClusterParameterGroupError {
    /// Creates a new `DeleteClusterParameterGroupError`.
    pub fn new(kind: DeleteClusterParameterGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteClusterParameterGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteClusterParameterGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteClusterParameterGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteClusterParameterGroupErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteClusterParameterGroupErrorKind::ClusterParameterGroupNotFoundFault`.
    pub fn is_cluster_parameter_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteClusterParameterGroupErrorKind::ClusterParameterGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteClusterParameterGroupErrorKind::InvalidClusterParameterGroupStateFault`.
    pub fn is_invalid_cluster_parameter_group_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteClusterParameterGroupErrorKind::InvalidClusterParameterGroupStateFault(_)
        )
    }
}
impl std::error::Error for DeleteClusterParameterGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteClusterParameterGroupErrorKind::ClusterParameterGroupNotFoundFault(_inner) => {
                Some(_inner)
            }
            DeleteClusterParameterGroupErrorKind::InvalidClusterParameterGroupStateFault(
                _inner,
            ) => Some(_inner),
            DeleteClusterParameterGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteClusterSecurityGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteClusterSecurityGroupError {
    /// Kind of error that occurred.
    pub kind: DeleteClusterSecurityGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteClusterSecurityGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteClusterSecurityGroupErrorKind {
    /// <p>The cluster security group name does not refer to an existing cluster security
    /// group.</p>
    ClusterSecurityGroupNotFoundFault(crate::error::ClusterSecurityGroupNotFoundFault),
    /// <p>The state of the cluster security group is not <code>available</code>. </p>
    InvalidClusterSecurityGroupStateFault(crate::error::InvalidClusterSecurityGroupStateFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteClusterSecurityGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteClusterSecurityGroupErrorKind::ClusterSecurityGroupNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            DeleteClusterSecurityGroupErrorKind::InvalidClusterSecurityGroupStateFault(_inner) => {
                _inner.fmt(f)
            }
            DeleteClusterSecurityGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteClusterSecurityGroupError {
    fn code(&self) -> Option<&str> {
        DeleteClusterSecurityGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteClusterSecurityGroupError {
    /// Creates a new `DeleteClusterSecurityGroupError`.
    pub fn new(kind: DeleteClusterSecurityGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteClusterSecurityGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteClusterSecurityGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteClusterSecurityGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteClusterSecurityGroupErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteClusterSecurityGroupErrorKind::ClusterSecurityGroupNotFoundFault`.
    pub fn is_cluster_security_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteClusterSecurityGroupErrorKind::ClusterSecurityGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteClusterSecurityGroupErrorKind::InvalidClusterSecurityGroupStateFault`.
    pub fn is_invalid_cluster_security_group_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteClusterSecurityGroupErrorKind::InvalidClusterSecurityGroupStateFault(_)
        )
    }
}
impl std::error::Error for DeleteClusterSecurityGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteClusterSecurityGroupErrorKind::ClusterSecurityGroupNotFoundFault(_inner) => {
                Some(_inner)
            }
            DeleteClusterSecurityGroupErrorKind::InvalidClusterSecurityGroupStateFault(_inner) => {
                Some(_inner)
            }
            DeleteClusterSecurityGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteClusterSnapshot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteClusterSnapshotError {
    /// Kind of error that occurred.
    pub kind: DeleteClusterSnapshotErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteClusterSnapshot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteClusterSnapshotErrorKind {
    /// <p>The snapshot identifier does not refer to an existing cluster snapshot.</p>
    ClusterSnapshotNotFoundFault(crate::error::ClusterSnapshotNotFoundFault),
    /// <p>The specified cluster snapshot is not in the <code>available</code> state, or other
    /// accounts are authorized to access the snapshot. </p>
    InvalidClusterSnapshotStateFault(crate::error::InvalidClusterSnapshotStateFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteClusterSnapshotError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteClusterSnapshotErrorKind::ClusterSnapshotNotFoundFault(_inner) => _inner.fmt(f),
            DeleteClusterSnapshotErrorKind::InvalidClusterSnapshotStateFault(_inner) => {
                _inner.fmt(f)
            }
            DeleteClusterSnapshotErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteClusterSnapshotError {
    fn code(&self) -> Option<&str> {
        DeleteClusterSnapshotError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteClusterSnapshotError {
    /// Creates a new `DeleteClusterSnapshotError`.
    pub fn new(kind: DeleteClusterSnapshotErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteClusterSnapshotError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteClusterSnapshotErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteClusterSnapshotError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteClusterSnapshotErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteClusterSnapshotErrorKind::ClusterSnapshotNotFoundFault`.
    pub fn is_cluster_snapshot_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteClusterSnapshotErrorKind::ClusterSnapshotNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteClusterSnapshotErrorKind::InvalidClusterSnapshotStateFault`.
    pub fn is_invalid_cluster_snapshot_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteClusterSnapshotErrorKind::InvalidClusterSnapshotStateFault(_)
        )
    }
}
impl std::error::Error for DeleteClusterSnapshotError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteClusterSnapshotErrorKind::ClusterSnapshotNotFoundFault(_inner) => Some(_inner),
            DeleteClusterSnapshotErrorKind::InvalidClusterSnapshotStateFault(_inner) => {
                Some(_inner)
            }
            DeleteClusterSnapshotErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteClusterSubnetGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteClusterSubnetGroupError {
    /// Kind of error that occurred.
    pub kind: DeleteClusterSubnetGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteClusterSubnetGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteClusterSubnetGroupErrorKind {
    /// <p>The cluster subnet group name does not refer to an existing cluster subnet
    /// group.</p>
    ClusterSubnetGroupNotFoundFault(crate::error::ClusterSubnetGroupNotFoundFault),
    /// <p>The cluster subnet group cannot be deleted because it is in use.</p>
    InvalidClusterSubnetGroupStateFault(crate::error::InvalidClusterSubnetGroupStateFault),
    /// <p>The state of the subnet is invalid.</p>
    InvalidClusterSubnetStateFault(crate::error::InvalidClusterSubnetStateFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteClusterSubnetGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteClusterSubnetGroupErrorKind::ClusterSubnetGroupNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            DeleteClusterSubnetGroupErrorKind::InvalidClusterSubnetGroupStateFault(_inner) => {
                _inner.fmt(f)
            }
            DeleteClusterSubnetGroupErrorKind::InvalidClusterSubnetStateFault(_inner) => {
                _inner.fmt(f)
            }
            DeleteClusterSubnetGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteClusterSubnetGroupError {
    fn code(&self) -> Option<&str> {
        DeleteClusterSubnetGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteClusterSubnetGroupError {
    /// Creates a new `DeleteClusterSubnetGroupError`.
    pub fn new(kind: DeleteClusterSubnetGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteClusterSubnetGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteClusterSubnetGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteClusterSubnetGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteClusterSubnetGroupErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteClusterSubnetGroupErrorKind::ClusterSubnetGroupNotFoundFault`.
    pub fn is_cluster_subnet_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteClusterSubnetGroupErrorKind::ClusterSubnetGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteClusterSubnetGroupErrorKind::InvalidClusterSubnetGroupStateFault`.
    pub fn is_invalid_cluster_subnet_group_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteClusterSubnetGroupErrorKind::InvalidClusterSubnetGroupStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteClusterSubnetGroupErrorKind::InvalidClusterSubnetStateFault`.
    pub fn is_invalid_cluster_subnet_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteClusterSubnetGroupErrorKind::InvalidClusterSubnetStateFault(_)
        )
    }
}
impl std::error::Error for DeleteClusterSubnetGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteClusterSubnetGroupErrorKind::ClusterSubnetGroupNotFoundFault(_inner) => {
                Some(_inner)
            }
            DeleteClusterSubnetGroupErrorKind::InvalidClusterSubnetGroupStateFault(_inner) => {
                Some(_inner)
            }
            DeleteClusterSubnetGroupErrorKind::InvalidClusterSubnetStateFault(_inner) => {
                Some(_inner)
            }
            DeleteClusterSubnetGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteEndpointAccess` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteEndpointAccessError {
    /// Kind of error that occurred.
    pub kind: DeleteEndpointAccessErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteEndpointAccess` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteEndpointAccessErrorKind {
    /// <p>The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster.
    /// </p>
    ClusterNotFoundFault(crate::error::ClusterNotFoundFault),
    /// <p>The endpoint name doesn't refer to an existing endpoint.</p>
    EndpointNotFoundFault(crate::error::EndpointNotFoundFault),
    /// <p>The state of the cluster security group is not <code>available</code>. </p>
    InvalidClusterSecurityGroupStateFault(crate::error::InvalidClusterSecurityGroupStateFault),
    /// <p>The specified cluster is not in the <code>available</code> state. </p>
    InvalidClusterStateFault(crate::error::InvalidClusterStateFault),
    /// <p>The status of the endpoint is not valid.</p>
    InvalidEndpointStateFault(crate::error::InvalidEndpointStateFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteEndpointAccessError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteEndpointAccessErrorKind::ClusterNotFoundFault(_inner) => _inner.fmt(f),
            DeleteEndpointAccessErrorKind::EndpointNotFoundFault(_inner) => _inner.fmt(f),
            DeleteEndpointAccessErrorKind::InvalidClusterSecurityGroupStateFault(_inner) => {
                _inner.fmt(f)
            }
            DeleteEndpointAccessErrorKind::InvalidClusterStateFault(_inner) => _inner.fmt(f),
            DeleteEndpointAccessErrorKind::InvalidEndpointStateFault(_inner) => _inner.fmt(f),
            DeleteEndpointAccessErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteEndpointAccessError {
    fn code(&self) -> Option<&str> {
        DeleteEndpointAccessError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteEndpointAccessError {
    /// Creates a new `DeleteEndpointAccessError`.
    pub fn new(kind: DeleteEndpointAccessErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteEndpointAccessError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteEndpointAccessErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteEndpointAccessError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteEndpointAccessErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteEndpointAccessErrorKind::ClusterNotFoundFault`.
    pub fn is_cluster_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEndpointAccessErrorKind::ClusterNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEndpointAccessErrorKind::EndpointNotFoundFault`.
    pub fn is_endpoint_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEndpointAccessErrorKind::EndpointNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEndpointAccessErrorKind::InvalidClusterSecurityGroupStateFault`.
    pub fn is_invalid_cluster_security_group_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEndpointAccessErrorKind::InvalidClusterSecurityGroupStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEndpointAccessErrorKind::InvalidClusterStateFault`.
    pub fn is_invalid_cluster_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEndpointAccessErrorKind::InvalidClusterStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEndpointAccessErrorKind::InvalidEndpointStateFault`.
    pub fn is_invalid_endpoint_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEndpointAccessErrorKind::InvalidEndpointStateFault(_)
        )
    }
}
impl std::error::Error for DeleteEndpointAccessError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteEndpointAccessErrorKind::ClusterNotFoundFault(_inner) => Some(_inner),
            DeleteEndpointAccessErrorKind::EndpointNotFoundFault(_inner) => Some(_inner),
            DeleteEndpointAccessErrorKind::InvalidClusterSecurityGroupStateFault(_inner) => {
                Some(_inner)
            }
            DeleteEndpointAccessErrorKind::InvalidClusterStateFault(_inner) => Some(_inner),
            DeleteEndpointAccessErrorKind::InvalidEndpointStateFault(_inner) => Some(_inner),
            DeleteEndpointAccessErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteEventSubscription` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteEventSubscriptionError {
    /// Kind of error that occurred.
    pub kind: DeleteEventSubscriptionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteEventSubscription` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteEventSubscriptionErrorKind {
    /// <p>The subscription request is invalid because it is a duplicate request. This
    /// subscription request is already in progress.</p>
    InvalidSubscriptionStateFault(crate::error::InvalidSubscriptionStateFault),
    /// <p>An Amazon Redshift event notification subscription with the specified name does not
    /// exist.</p>
    SubscriptionNotFoundFault(crate::error::SubscriptionNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteEventSubscriptionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteEventSubscriptionErrorKind::InvalidSubscriptionStateFault(_inner) => {
                _inner.fmt(f)
            }
            DeleteEventSubscriptionErrorKind::SubscriptionNotFoundFault(_inner) => _inner.fmt(f),
            DeleteEventSubscriptionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteEventSubscriptionError {
    fn code(&self) -> Option<&str> {
        DeleteEventSubscriptionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteEventSubscriptionError {
    /// Creates a new `DeleteEventSubscriptionError`.
    pub fn new(kind: DeleteEventSubscriptionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteEventSubscriptionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteEventSubscriptionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteEventSubscriptionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteEventSubscriptionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteEventSubscriptionErrorKind::InvalidSubscriptionStateFault`.
    pub fn is_invalid_subscription_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEventSubscriptionErrorKind::InvalidSubscriptionStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEventSubscriptionErrorKind::SubscriptionNotFoundFault`.
    pub fn is_subscription_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEventSubscriptionErrorKind::SubscriptionNotFoundFault(_)
        )
    }
}
impl std::error::Error for DeleteEventSubscriptionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteEventSubscriptionErrorKind::InvalidSubscriptionStateFault(_inner) => Some(_inner),
            DeleteEventSubscriptionErrorKind::SubscriptionNotFoundFault(_inner) => Some(_inner),
            DeleteEventSubscriptionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteHsmClientCertificate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteHsmClientCertificateError {
    /// Kind of error that occurred.
    pub kind: DeleteHsmClientCertificateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteHsmClientCertificate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteHsmClientCertificateErrorKind {
    /// <p>There is no Amazon Redshift HSM client certificate with the specified
    /// identifier.</p>
    HsmClientCertificateNotFoundFault(crate::error::HsmClientCertificateNotFoundFault),
    /// <p>The specified HSM client certificate is not in the <code>available</code> state, or
    /// it is still in use by one or more Amazon Redshift clusters.</p>
    InvalidHsmClientCertificateStateFault(crate::error::InvalidHsmClientCertificateStateFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteHsmClientCertificateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteHsmClientCertificateErrorKind::HsmClientCertificateNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            DeleteHsmClientCertificateErrorKind::InvalidHsmClientCertificateStateFault(_inner) => {
                _inner.fmt(f)
            }
            DeleteHsmClientCertificateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteHsmClientCertificateError {
    fn code(&self) -> Option<&str> {
        DeleteHsmClientCertificateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteHsmClientCertificateError {
    /// Creates a new `DeleteHsmClientCertificateError`.
    pub fn new(kind: DeleteHsmClientCertificateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteHsmClientCertificateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteHsmClientCertificateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteHsmClientCertificateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteHsmClientCertificateErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteHsmClientCertificateErrorKind::HsmClientCertificateNotFoundFault`.
    pub fn is_hsm_client_certificate_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteHsmClientCertificateErrorKind::HsmClientCertificateNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteHsmClientCertificateErrorKind::InvalidHsmClientCertificateStateFault`.
    pub fn is_invalid_hsm_client_certificate_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteHsmClientCertificateErrorKind::InvalidHsmClientCertificateStateFault(_)
        )
    }
}
impl std::error::Error for DeleteHsmClientCertificateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteHsmClientCertificateErrorKind::HsmClientCertificateNotFoundFault(_inner) => {
                Some(_inner)
            }
            DeleteHsmClientCertificateErrorKind::InvalidHsmClientCertificateStateFault(_inner) => {
                Some(_inner)
            }
            DeleteHsmClientCertificateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteHsmConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteHsmConfigurationError {
    /// Kind of error that occurred.
    pub kind: DeleteHsmConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteHsmConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteHsmConfigurationErrorKind {
    /// <p>There is no Amazon Redshift HSM configuration with the specified identifier.</p>
    HsmConfigurationNotFoundFault(crate::error::HsmConfigurationNotFoundFault),
    /// <p>The specified HSM configuration is not in the <code>available</code> state, or it
    /// is still in use by one or more Amazon Redshift clusters.</p>
    InvalidHsmConfigurationStateFault(crate::error::InvalidHsmConfigurationStateFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteHsmConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteHsmConfigurationErrorKind::HsmConfigurationNotFoundFault(_inner) => _inner.fmt(f),
            DeleteHsmConfigurationErrorKind::InvalidHsmConfigurationStateFault(_inner) => {
                _inner.fmt(f)
            }
            DeleteHsmConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteHsmConfigurationError {
    fn code(&self) -> Option<&str> {
        DeleteHsmConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteHsmConfigurationError {
    /// Creates a new `DeleteHsmConfigurationError`.
    pub fn new(kind: DeleteHsmConfigurationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteHsmConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteHsmConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteHsmConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteHsmConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteHsmConfigurationErrorKind::HsmConfigurationNotFoundFault`.
    pub fn is_hsm_configuration_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteHsmConfigurationErrorKind::HsmConfigurationNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteHsmConfigurationErrorKind::InvalidHsmConfigurationStateFault`.
    pub fn is_invalid_hsm_configuration_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteHsmConfigurationErrorKind::InvalidHsmConfigurationStateFault(_)
        )
    }
}
impl std::error::Error for DeleteHsmConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteHsmConfigurationErrorKind::HsmConfigurationNotFoundFault(_inner) => Some(_inner),
            DeleteHsmConfigurationErrorKind::InvalidHsmConfigurationStateFault(_inner) => {
                Some(_inner)
            }
            DeleteHsmConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeletePartner` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeletePartnerError {
    /// Kind of error that occurred.
    pub kind: DeletePartnerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeletePartner` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeletePartnerErrorKind {
    /// <p>The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster.
    /// </p>
    ClusterNotFoundFault(crate::error::ClusterNotFoundFault),
    /// <p>The name of the partner was not found.</p>
    PartnerNotFoundFault(crate::error::PartnerNotFoundFault),
    /// <p>The partner integration is not authorized.</p>
    UnauthorizedPartnerIntegrationFault(crate::error::UnauthorizedPartnerIntegrationFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeletePartnerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeletePartnerErrorKind::ClusterNotFoundFault(_inner) => _inner.fmt(f),
            DeletePartnerErrorKind::PartnerNotFoundFault(_inner) => _inner.fmt(f),
            DeletePartnerErrorKind::UnauthorizedPartnerIntegrationFault(_inner) => _inner.fmt(f),
            DeletePartnerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeletePartnerError {
    fn code(&self) -> Option<&str> {
        DeletePartnerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeletePartnerError {
    /// Creates a new `DeletePartnerError`.
    pub fn new(kind: DeletePartnerErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeletePartnerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeletePartnerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeletePartnerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeletePartnerErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeletePartnerErrorKind::ClusterNotFoundFault`.
    pub fn is_cluster_not_found_fault(&self) -> bool {
        matches!(&self.kind, DeletePartnerErrorKind::ClusterNotFoundFault(_))
    }
    /// Returns `true` if the error kind is `DeletePartnerErrorKind::PartnerNotFoundFault`.
    pub fn is_partner_not_found_fault(&self) -> bool {
        matches!(&self.kind, DeletePartnerErrorKind::PartnerNotFoundFault(_))
    }
    /// Returns `true` if the error kind is `DeletePartnerErrorKind::UnauthorizedPartnerIntegrationFault`.
    pub fn is_unauthorized_partner_integration_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeletePartnerErrorKind::UnauthorizedPartnerIntegrationFault(_)
        )
    }
}
impl std::error::Error for DeletePartnerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeletePartnerErrorKind::ClusterNotFoundFault(_inner) => Some(_inner),
            DeletePartnerErrorKind::PartnerNotFoundFault(_inner) => Some(_inner),
            DeletePartnerErrorKind::UnauthorizedPartnerIntegrationFault(_inner) => Some(_inner),
            DeletePartnerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteScheduledAction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteScheduledActionError {
    /// Kind of error that occurred.
    pub kind: DeleteScheduledActionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteScheduledAction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteScheduledActionErrorKind {
    /// <p>The scheduled action cannot be found. </p>
    ScheduledActionNotFoundFault(crate::error::ScheduledActionNotFoundFault),
    /// <p>Your account is not authorized to perform the requested operation.</p>
    UnauthorizedOperation(crate::error::UnauthorizedOperation),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteScheduledActionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteScheduledActionErrorKind::ScheduledActionNotFoundFault(_inner) => _inner.fmt(f),
            DeleteScheduledActionErrorKind::UnauthorizedOperation(_inner) => _inner.fmt(f),
            DeleteScheduledActionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteScheduledActionError {
    fn code(&self) -> Option<&str> {
        DeleteScheduledActionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteScheduledActionError {
    /// Creates a new `DeleteScheduledActionError`.
    pub fn new(kind: DeleteScheduledActionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteScheduledActionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteScheduledActionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteScheduledActionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteScheduledActionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteScheduledActionErrorKind::ScheduledActionNotFoundFault`.
    pub fn is_scheduled_action_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteScheduledActionErrorKind::ScheduledActionNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteScheduledActionErrorKind::UnauthorizedOperation`.
    pub fn is_unauthorized_operation(&self) -> bool {
        matches!(
            &self.kind,
            DeleteScheduledActionErrorKind::UnauthorizedOperation(_)
        )
    }
}
impl std::error::Error for DeleteScheduledActionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteScheduledActionErrorKind::ScheduledActionNotFoundFault(_inner) => Some(_inner),
            DeleteScheduledActionErrorKind::UnauthorizedOperation(_inner) => Some(_inner),
            DeleteScheduledActionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteSnapshotCopyGrant` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteSnapshotCopyGrantError {
    /// Kind of error that occurred.
    pub kind: DeleteSnapshotCopyGrantErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteSnapshotCopyGrant` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteSnapshotCopyGrantErrorKind {
    /// <p>The snapshot copy grant can't be deleted because it is used by one or more
    /// clusters.</p>
    InvalidSnapshotCopyGrantStateFault(crate::error::InvalidSnapshotCopyGrantStateFault),
    /// <p>The specified snapshot copy grant can't be found. Make sure that the name is typed
    /// correctly and that the grant exists in the destination region.</p>
    SnapshotCopyGrantNotFoundFault(crate::error::SnapshotCopyGrantNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteSnapshotCopyGrantError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteSnapshotCopyGrantErrorKind::InvalidSnapshotCopyGrantStateFault(_inner) => {
                _inner.fmt(f)
            }
            DeleteSnapshotCopyGrantErrorKind::SnapshotCopyGrantNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            DeleteSnapshotCopyGrantErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteSnapshotCopyGrantError {
    fn code(&self) -> Option<&str> {
        DeleteSnapshotCopyGrantError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteSnapshotCopyGrantError {
    /// Creates a new `DeleteSnapshotCopyGrantError`.
    pub fn new(kind: DeleteSnapshotCopyGrantErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteSnapshotCopyGrantError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteSnapshotCopyGrantErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteSnapshotCopyGrantError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteSnapshotCopyGrantErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteSnapshotCopyGrantErrorKind::InvalidSnapshotCopyGrantStateFault`.
    pub fn is_invalid_snapshot_copy_grant_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSnapshotCopyGrantErrorKind::InvalidSnapshotCopyGrantStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteSnapshotCopyGrantErrorKind::SnapshotCopyGrantNotFoundFault`.
    pub fn is_snapshot_copy_grant_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSnapshotCopyGrantErrorKind::SnapshotCopyGrantNotFoundFault(_)
        )
    }
}
impl std::error::Error for DeleteSnapshotCopyGrantError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteSnapshotCopyGrantErrorKind::InvalidSnapshotCopyGrantStateFault(_inner) => {
                Some(_inner)
            }
            DeleteSnapshotCopyGrantErrorKind::SnapshotCopyGrantNotFoundFault(_inner) => {
                Some(_inner)
            }
            DeleteSnapshotCopyGrantErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteSnapshotSchedule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteSnapshotScheduleError {
    /// Kind of error that occurred.
    pub kind: DeleteSnapshotScheduleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteSnapshotSchedule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteSnapshotScheduleErrorKind {
    /// <p>The cluster snapshot schedule state is not valid.</p>
    InvalidClusterSnapshotScheduleStateFault(
        crate::error::InvalidClusterSnapshotScheduleStateFault,
    ),
    /// <p>We could not find the specified snapshot schedule. </p>
    SnapshotScheduleNotFoundFault(crate::error::SnapshotScheduleNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteSnapshotScheduleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteSnapshotScheduleErrorKind::InvalidClusterSnapshotScheduleStateFault(_inner) => {
                _inner.fmt(f)
            }
            DeleteSnapshotScheduleErrorKind::SnapshotScheduleNotFoundFault(_inner) => _inner.fmt(f),
            DeleteSnapshotScheduleErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteSnapshotScheduleError {
    fn code(&self) -> Option<&str> {
        DeleteSnapshotScheduleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteSnapshotScheduleError {
    /// Creates a new `DeleteSnapshotScheduleError`.
    pub fn new(kind: DeleteSnapshotScheduleErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteSnapshotScheduleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteSnapshotScheduleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteSnapshotScheduleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteSnapshotScheduleErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteSnapshotScheduleErrorKind::InvalidClusterSnapshotScheduleStateFault`.
    pub fn is_invalid_cluster_snapshot_schedule_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSnapshotScheduleErrorKind::InvalidClusterSnapshotScheduleStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteSnapshotScheduleErrorKind::SnapshotScheduleNotFoundFault`.
    pub fn is_snapshot_schedule_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteSnapshotScheduleErrorKind::SnapshotScheduleNotFoundFault(_)
        )
    }
}
impl std::error::Error for DeleteSnapshotScheduleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteSnapshotScheduleErrorKind::InvalidClusterSnapshotScheduleStateFault(_inner) => {
                Some(_inner)
            }
            DeleteSnapshotScheduleErrorKind::SnapshotScheduleNotFoundFault(_inner) => Some(_inner),
            DeleteSnapshotScheduleErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteTagsError {
    /// Kind of error that occurred.
    pub kind: DeleteTagsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteTagsErrorKind {
    /// <p>The tag is invalid.</p>
    InvalidTagFault(crate::error::InvalidTagFault),
    /// <p>The resource could not be found.</p>
    ResourceNotFoundFault(crate::error::ResourceNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteTagsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteTagsErrorKind::InvalidTagFault(_inner) => _inner.fmt(f),
            DeleteTagsErrorKind::ResourceNotFoundFault(_inner) => _inner.fmt(f),
            DeleteTagsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteTagsError {
    fn code(&self) -> Option<&str> {
        DeleteTagsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteTagsError {
    /// Creates a new `DeleteTagsError`.
    pub fn new(kind: DeleteTagsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteTagsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteTagsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteTagsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteTagsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteTagsErrorKind::InvalidTagFault`.
    pub fn is_invalid_tag_fault(&self) -> bool {
        matches!(&self.kind, DeleteTagsErrorKind::InvalidTagFault(_))
    }
    /// Returns `true` if the error kind is `DeleteTagsErrorKind::ResourceNotFoundFault`.
    pub fn is_resource_not_found_fault(&self) -> bool {
        matches!(&self.kind, DeleteTagsErrorKind::ResourceNotFoundFault(_))
    }
}
impl std::error::Error for DeleteTagsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteTagsErrorKind::InvalidTagFault(_inner) => Some(_inner),
            DeleteTagsErrorKind::ResourceNotFoundFault(_inner) => Some(_inner),
            DeleteTagsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteUsageLimit` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteUsageLimitError {
    /// Kind of error that occurred.
    pub kind: DeleteUsageLimitErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteUsageLimit` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteUsageLimitErrorKind {
    /// <p>The requested operation isn't supported.</p>
    UnsupportedOperationFault(crate::error::UnsupportedOperationFault),
    /// <p>The usage limit identifier can't be found.</p>
    UsageLimitNotFoundFault(crate::error::UsageLimitNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteUsageLimitError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteUsageLimitErrorKind::UnsupportedOperationFault(_inner) => _inner.fmt(f),
            DeleteUsageLimitErrorKind::UsageLimitNotFoundFault(_inner) => _inner.fmt(f),
            DeleteUsageLimitErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteUsageLimitError {
    fn code(&self) -> Option<&str> {
        DeleteUsageLimitError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteUsageLimitError {
    /// Creates a new `DeleteUsageLimitError`.
    pub fn new(kind: DeleteUsageLimitErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteUsageLimitError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteUsageLimitErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteUsageLimitError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteUsageLimitErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteUsageLimitErrorKind::UnsupportedOperationFault`.
    pub fn is_unsupported_operation_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteUsageLimitErrorKind::UnsupportedOperationFault(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteUsageLimitErrorKind::UsageLimitNotFoundFault`.
    pub fn is_usage_limit_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteUsageLimitErrorKind::UsageLimitNotFoundFault(_)
        )
    }
}
impl std::error::Error for DeleteUsageLimitError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteUsageLimitErrorKind::UnsupportedOperationFault(_inner) => Some(_inner),
            DeleteUsageLimitErrorKind::UsageLimitNotFoundFault(_inner) => Some(_inner),
            DeleteUsageLimitErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeAccountAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeAccountAttributesError {
    /// Kind of error that occurred.
    pub kind: DescribeAccountAttributesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeAccountAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeAccountAttributesErrorKind {
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeAccountAttributesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeAccountAttributesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeAccountAttributesError {
    fn code(&self) -> Option<&str> {
        DescribeAccountAttributesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeAccountAttributesError {
    /// Creates a new `DescribeAccountAttributesError`.
    pub fn new(kind: DescribeAccountAttributesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeAccountAttributesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeAccountAttributesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeAccountAttributesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeAccountAttributesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for DescribeAccountAttributesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeAccountAttributesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeAuthenticationProfiles` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeAuthenticationProfilesError {
    /// Kind of error that occurred.
    pub kind: DescribeAuthenticationProfilesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeAuthenticationProfiles` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeAuthenticationProfilesErrorKind {
    /// <p>The authentication profile can't be found.</p>
    AuthenticationProfileNotFoundFault(crate::error::AuthenticationProfileNotFoundFault),
    /// <p>The authentication profile request is not valid. The profile name can't be null or empty.
    /// The authentication profile API operation must be available in the Amazon Web Services Region.</p>
    InvalidAuthenticationProfileRequestFault(
        crate::error::InvalidAuthenticationProfileRequestFault,
    ),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeAuthenticationProfilesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeAuthenticationProfilesErrorKind::AuthenticationProfileNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            DescribeAuthenticationProfilesErrorKind::InvalidAuthenticationProfileRequestFault(
                _inner,
            ) => _inner.fmt(f),
            DescribeAuthenticationProfilesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeAuthenticationProfilesError {
    fn code(&self) -> Option<&str> {
        DescribeAuthenticationProfilesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeAuthenticationProfilesError {
    /// Creates a new `DescribeAuthenticationProfilesError`.
    pub fn new(
        kind: DescribeAuthenticationProfilesErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeAuthenticationProfilesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeAuthenticationProfilesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeAuthenticationProfilesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeAuthenticationProfilesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeAuthenticationProfilesErrorKind::AuthenticationProfileNotFoundFault`.
    pub fn is_authentication_profile_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAuthenticationProfilesErrorKind::AuthenticationProfileNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeAuthenticationProfilesErrorKind::InvalidAuthenticationProfileRequestFault`.
    pub fn is_invalid_authentication_profile_request_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeAuthenticationProfilesErrorKind::InvalidAuthenticationProfileRequestFault(_)
        )
    }
}
impl std::error::Error for DescribeAuthenticationProfilesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeAuthenticationProfilesErrorKind::AuthenticationProfileNotFoundFault(_inner) => {
                Some(_inner)
            }
            DescribeAuthenticationProfilesErrorKind::InvalidAuthenticationProfileRequestFault(
                _inner,
            ) => Some(_inner),
            DescribeAuthenticationProfilesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeClusterDbRevisions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeClusterDbRevisionsError {
    /// Kind of error that occurred.
    pub kind: DescribeClusterDbRevisionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeClusterDbRevisions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeClusterDbRevisionsErrorKind {
    /// <p>The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster.
    /// </p>
    ClusterNotFoundFault(crate::error::ClusterNotFoundFault),
    /// <p>The specified cluster is not in the <code>available</code> state. </p>
    InvalidClusterStateFault(crate::error::InvalidClusterStateFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeClusterDbRevisionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeClusterDbRevisionsErrorKind::ClusterNotFoundFault(_inner) => _inner.fmt(f),
            DescribeClusterDbRevisionsErrorKind::InvalidClusterStateFault(_inner) => _inner.fmt(f),
            DescribeClusterDbRevisionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeClusterDbRevisionsError {
    fn code(&self) -> Option<&str> {
        DescribeClusterDbRevisionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeClusterDbRevisionsError {
    /// Creates a new `DescribeClusterDbRevisionsError`.
    pub fn new(kind: DescribeClusterDbRevisionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeClusterDbRevisionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeClusterDbRevisionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeClusterDbRevisionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeClusterDbRevisionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeClusterDbRevisionsErrorKind::ClusterNotFoundFault`.
    pub fn is_cluster_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeClusterDbRevisionsErrorKind::ClusterNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeClusterDbRevisionsErrorKind::InvalidClusterStateFault`.
    pub fn is_invalid_cluster_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeClusterDbRevisionsErrorKind::InvalidClusterStateFault(_)
        )
    }
}
impl std::error::Error for DescribeClusterDbRevisionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeClusterDbRevisionsErrorKind::ClusterNotFoundFault(_inner) => Some(_inner),
            DescribeClusterDbRevisionsErrorKind::InvalidClusterStateFault(_inner) => Some(_inner),
            DescribeClusterDbRevisionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeClusterParameterGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeClusterParameterGroupsError {
    /// Kind of error that occurred.
    pub kind: DescribeClusterParameterGroupsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeClusterParameterGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeClusterParameterGroupsErrorKind {
    /// <p>The parameter group name does not refer to an existing parameter group.</p>
    ClusterParameterGroupNotFoundFault(crate::error::ClusterParameterGroupNotFoundFault),
    /// <p>The tag is invalid.</p>
    InvalidTagFault(crate::error::InvalidTagFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeClusterParameterGroupsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeClusterParameterGroupsErrorKind::ClusterParameterGroupNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            DescribeClusterParameterGroupsErrorKind::InvalidTagFault(_inner) => _inner.fmt(f),
            DescribeClusterParameterGroupsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeClusterParameterGroupsError {
    fn code(&self) -> Option<&str> {
        DescribeClusterParameterGroupsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeClusterParameterGroupsError {
    /// Creates a new `DescribeClusterParameterGroupsError`.
    pub fn new(
        kind: DescribeClusterParameterGroupsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeClusterParameterGroupsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeClusterParameterGroupsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeClusterParameterGroupsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeClusterParameterGroupsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeClusterParameterGroupsErrorKind::ClusterParameterGroupNotFoundFault`.
    pub fn is_cluster_parameter_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeClusterParameterGroupsErrorKind::ClusterParameterGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeClusterParameterGroupsErrorKind::InvalidTagFault`.
    pub fn is_invalid_tag_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeClusterParameterGroupsErrorKind::InvalidTagFault(_)
        )
    }
}
impl std::error::Error for DescribeClusterParameterGroupsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeClusterParameterGroupsErrorKind::ClusterParameterGroupNotFoundFault(_inner) => {
                Some(_inner)
            }
            DescribeClusterParameterGroupsErrorKind::InvalidTagFault(_inner) => Some(_inner),
            DescribeClusterParameterGroupsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeClusterParameters` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeClusterParametersError {
    /// Kind of error that occurred.
    pub kind: DescribeClusterParametersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeClusterParameters` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeClusterParametersErrorKind {
    /// <p>The parameter group name does not refer to an existing parameter group.</p>
    ClusterParameterGroupNotFoundFault(crate::error::ClusterParameterGroupNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeClusterParametersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeClusterParametersErrorKind::ClusterParameterGroupNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            DescribeClusterParametersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeClusterParametersError {
    fn code(&self) -> Option<&str> {
        DescribeClusterParametersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeClusterParametersError {
    /// Creates a new `DescribeClusterParametersError`.
    pub fn new(kind: DescribeClusterParametersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeClusterParametersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeClusterParametersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeClusterParametersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeClusterParametersErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeClusterParametersErrorKind::ClusterParameterGroupNotFoundFault`.
    pub fn is_cluster_parameter_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeClusterParametersErrorKind::ClusterParameterGroupNotFoundFault(_)
        )
    }
}
impl std::error::Error for DescribeClusterParametersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeClusterParametersErrorKind::ClusterParameterGroupNotFoundFault(_inner) => {
                Some(_inner)
            }
            DescribeClusterParametersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeClusters` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeClustersError {
    /// Kind of error that occurred.
    pub kind: DescribeClustersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeClusters` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeClustersErrorKind {
    /// <p>The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster.
    /// </p>
    ClusterNotFoundFault(crate::error::ClusterNotFoundFault),
    /// <p>The tag is invalid.</p>
    InvalidTagFault(crate::error::InvalidTagFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeClustersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeClustersErrorKind::ClusterNotFoundFault(_inner) => _inner.fmt(f),
            DescribeClustersErrorKind::InvalidTagFault(_inner) => _inner.fmt(f),
            DescribeClustersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeClustersError {
    fn code(&self) -> Option<&str> {
        DescribeClustersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeClustersError {
    /// Creates a new `DescribeClustersError`.
    pub fn new(kind: DescribeClustersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeClustersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeClustersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeClustersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeClustersErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeClustersErrorKind::ClusterNotFoundFault`.
    pub fn is_cluster_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeClustersErrorKind::ClusterNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeClustersErrorKind::InvalidTagFault`.
    pub fn is_invalid_tag_fault(&self) -> bool {
        matches!(&self.kind, DescribeClustersErrorKind::InvalidTagFault(_))
    }
}
impl std::error::Error for DescribeClustersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeClustersErrorKind::ClusterNotFoundFault(_inner) => Some(_inner),
            DescribeClustersErrorKind::InvalidTagFault(_inner) => Some(_inner),
            DescribeClustersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeClusterSecurityGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeClusterSecurityGroupsError {
    /// Kind of error that occurred.
    pub kind: DescribeClusterSecurityGroupsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeClusterSecurityGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeClusterSecurityGroupsErrorKind {
    /// <p>The cluster security group name does not refer to an existing cluster security
    /// group.</p>
    ClusterSecurityGroupNotFoundFault(crate::error::ClusterSecurityGroupNotFoundFault),
    /// <p>The tag is invalid.</p>
    InvalidTagFault(crate::error::InvalidTagFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeClusterSecurityGroupsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeClusterSecurityGroupsErrorKind::ClusterSecurityGroupNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            DescribeClusterSecurityGroupsErrorKind::InvalidTagFault(_inner) => _inner.fmt(f),
            DescribeClusterSecurityGroupsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeClusterSecurityGroupsError {
    fn code(&self) -> Option<&str> {
        DescribeClusterSecurityGroupsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeClusterSecurityGroupsError {
    /// Creates a new `DescribeClusterSecurityGroupsError`.
    pub fn new(
        kind: DescribeClusterSecurityGroupsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeClusterSecurityGroupsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeClusterSecurityGroupsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeClusterSecurityGroupsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeClusterSecurityGroupsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeClusterSecurityGroupsErrorKind::ClusterSecurityGroupNotFoundFault`.
    pub fn is_cluster_security_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeClusterSecurityGroupsErrorKind::ClusterSecurityGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeClusterSecurityGroupsErrorKind::InvalidTagFault`.
    pub fn is_invalid_tag_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeClusterSecurityGroupsErrorKind::InvalidTagFault(_)
        )
    }
}
impl std::error::Error for DescribeClusterSecurityGroupsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeClusterSecurityGroupsErrorKind::ClusterSecurityGroupNotFoundFault(_inner) => {
                Some(_inner)
            }
            DescribeClusterSecurityGroupsErrorKind::InvalidTagFault(_inner) => Some(_inner),
            DescribeClusterSecurityGroupsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeClusterSnapshots` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeClusterSnapshotsError {
    /// Kind of error that occurred.
    pub kind: DescribeClusterSnapshotsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeClusterSnapshots` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeClusterSnapshotsErrorKind {
    /// <p>The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster.
    /// </p>
    ClusterNotFoundFault(crate::error::ClusterNotFoundFault),
    /// <p>The snapshot identifier does not refer to an existing cluster snapshot.</p>
    ClusterSnapshotNotFoundFault(crate::error::ClusterSnapshotNotFoundFault),
    /// <p>The tag is invalid.</p>
    InvalidTagFault(crate::error::InvalidTagFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeClusterSnapshotsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeClusterSnapshotsErrorKind::ClusterNotFoundFault(_inner) => _inner.fmt(f),
            DescribeClusterSnapshotsErrorKind::ClusterSnapshotNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            DescribeClusterSnapshotsErrorKind::InvalidTagFault(_inner) => _inner.fmt(f),
            DescribeClusterSnapshotsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeClusterSnapshotsError {
    fn code(&self) -> Option<&str> {
        DescribeClusterSnapshotsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeClusterSnapshotsError {
    /// Creates a new `DescribeClusterSnapshotsError`.
    pub fn new(kind: DescribeClusterSnapshotsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeClusterSnapshotsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeClusterSnapshotsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeClusterSnapshotsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeClusterSnapshotsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeClusterSnapshotsErrorKind::ClusterNotFoundFault`.
    pub fn is_cluster_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeClusterSnapshotsErrorKind::ClusterNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeClusterSnapshotsErrorKind::ClusterSnapshotNotFoundFault`.
    pub fn is_cluster_snapshot_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeClusterSnapshotsErrorKind::ClusterSnapshotNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeClusterSnapshotsErrorKind::InvalidTagFault`.
    pub fn is_invalid_tag_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeClusterSnapshotsErrorKind::InvalidTagFault(_)
        )
    }
}
impl std::error::Error for DescribeClusterSnapshotsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeClusterSnapshotsErrorKind::ClusterNotFoundFault(_inner) => Some(_inner),
            DescribeClusterSnapshotsErrorKind::ClusterSnapshotNotFoundFault(_inner) => Some(_inner),
            DescribeClusterSnapshotsErrorKind::InvalidTagFault(_inner) => Some(_inner),
            DescribeClusterSnapshotsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeClusterSubnetGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeClusterSubnetGroupsError {
    /// Kind of error that occurred.
    pub kind: DescribeClusterSubnetGroupsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeClusterSubnetGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeClusterSubnetGroupsErrorKind {
    /// <p>The cluster subnet group name does not refer to an existing cluster subnet
    /// group.</p>
    ClusterSubnetGroupNotFoundFault(crate::error::ClusterSubnetGroupNotFoundFault),
    /// <p>The tag is invalid.</p>
    InvalidTagFault(crate::error::InvalidTagFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeClusterSubnetGroupsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeClusterSubnetGroupsErrorKind::ClusterSubnetGroupNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            DescribeClusterSubnetGroupsErrorKind::InvalidTagFault(_inner) => _inner.fmt(f),
            DescribeClusterSubnetGroupsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeClusterSubnetGroupsError {
    fn code(&self) -> Option<&str> {
        DescribeClusterSubnetGroupsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeClusterSubnetGroupsError {
    /// Creates a new `DescribeClusterSubnetGroupsError`.
    pub fn new(kind: DescribeClusterSubnetGroupsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeClusterSubnetGroupsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeClusterSubnetGroupsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeClusterSubnetGroupsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeClusterSubnetGroupsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeClusterSubnetGroupsErrorKind::ClusterSubnetGroupNotFoundFault`.
    pub fn is_cluster_subnet_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeClusterSubnetGroupsErrorKind::ClusterSubnetGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeClusterSubnetGroupsErrorKind::InvalidTagFault`.
    pub fn is_invalid_tag_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeClusterSubnetGroupsErrorKind::InvalidTagFault(_)
        )
    }
}
impl std::error::Error for DescribeClusterSubnetGroupsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeClusterSubnetGroupsErrorKind::ClusterSubnetGroupNotFoundFault(_inner) => {
                Some(_inner)
            }
            DescribeClusterSubnetGroupsErrorKind::InvalidTagFault(_inner) => Some(_inner),
            DescribeClusterSubnetGroupsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeClusterTracks` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeClusterTracksError {
    /// Kind of error that occurred.
    pub kind: DescribeClusterTracksErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeClusterTracks` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeClusterTracksErrorKind {
    /// <p>The provided cluster track name is not valid.</p>
    InvalidClusterTrackFault(crate::error::InvalidClusterTrackFault),
    /// <p>Your account is not authorized to perform the requested operation.</p>
    UnauthorizedOperation(crate::error::UnauthorizedOperation),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeClusterTracksError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeClusterTracksErrorKind::InvalidClusterTrackFault(_inner) => _inner.fmt(f),
            DescribeClusterTracksErrorKind::UnauthorizedOperation(_inner) => _inner.fmt(f),
            DescribeClusterTracksErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeClusterTracksError {
    fn code(&self) -> Option<&str> {
        DescribeClusterTracksError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeClusterTracksError {
    /// Creates a new `DescribeClusterTracksError`.
    pub fn new(kind: DescribeClusterTracksErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeClusterTracksError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeClusterTracksErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeClusterTracksError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeClusterTracksErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeClusterTracksErrorKind::InvalidClusterTrackFault`.
    pub fn is_invalid_cluster_track_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeClusterTracksErrorKind::InvalidClusterTrackFault(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeClusterTracksErrorKind::UnauthorizedOperation`.
    pub fn is_unauthorized_operation(&self) -> bool {
        matches!(
            &self.kind,
            DescribeClusterTracksErrorKind::UnauthorizedOperation(_)
        )
    }
}
impl std::error::Error for DescribeClusterTracksError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeClusterTracksErrorKind::InvalidClusterTrackFault(_inner) => Some(_inner),
            DescribeClusterTracksErrorKind::UnauthorizedOperation(_inner) => Some(_inner),
            DescribeClusterTracksErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeClusterVersions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeClusterVersionsError {
    /// Kind of error that occurred.
    pub kind: DescribeClusterVersionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeClusterVersions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeClusterVersionsErrorKind {
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeClusterVersionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeClusterVersionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeClusterVersionsError {
    fn code(&self) -> Option<&str> {
        DescribeClusterVersionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeClusterVersionsError {
    /// Creates a new `DescribeClusterVersionsError`.
    pub fn new(kind: DescribeClusterVersionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeClusterVersionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeClusterVersionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeClusterVersionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeClusterVersionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for DescribeClusterVersionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeClusterVersionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeDataShares` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeDataSharesError {
    /// Kind of error that occurred.
    pub kind: DescribeDataSharesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeDataShares` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeDataSharesErrorKind {
    /// <p>There is an error with the datashare.</p>
    InvalidDataShareFault(crate::error::InvalidDataShareFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeDataSharesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeDataSharesErrorKind::InvalidDataShareFault(_inner) => _inner.fmt(f),
            DescribeDataSharesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeDataSharesError {
    fn code(&self) -> Option<&str> {
        DescribeDataSharesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeDataSharesError {
    /// Creates a new `DescribeDataSharesError`.
    pub fn new(kind: DescribeDataSharesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeDataSharesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeDataSharesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeDataSharesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeDataSharesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeDataSharesErrorKind::InvalidDataShareFault`.
    pub fn is_invalid_data_share_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDataSharesErrorKind::InvalidDataShareFault(_)
        )
    }
}
impl std::error::Error for DescribeDataSharesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeDataSharesErrorKind::InvalidDataShareFault(_inner) => Some(_inner),
            DescribeDataSharesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeDataSharesForConsumer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeDataSharesForConsumerError {
    /// Kind of error that occurred.
    pub kind: DescribeDataSharesForConsumerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeDataSharesForConsumer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeDataSharesForConsumerErrorKind {
    /// <p>The namespace isn't valid because the namespace doesn't exist. Provide a valid namespace.</p>
    InvalidNamespaceFault(crate::error::InvalidNamespaceFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeDataSharesForConsumerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeDataSharesForConsumerErrorKind::InvalidNamespaceFault(_inner) => _inner.fmt(f),
            DescribeDataSharesForConsumerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeDataSharesForConsumerError {
    fn code(&self) -> Option<&str> {
        DescribeDataSharesForConsumerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeDataSharesForConsumerError {
    /// Creates a new `DescribeDataSharesForConsumerError`.
    pub fn new(
        kind: DescribeDataSharesForConsumerErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeDataSharesForConsumerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeDataSharesForConsumerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeDataSharesForConsumerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeDataSharesForConsumerErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeDataSharesForConsumerErrorKind::InvalidNamespaceFault`.
    pub fn is_invalid_namespace_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDataSharesForConsumerErrorKind::InvalidNamespaceFault(_)
        )
    }
}
impl std::error::Error for DescribeDataSharesForConsumerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeDataSharesForConsumerErrorKind::InvalidNamespaceFault(_inner) => Some(_inner),
            DescribeDataSharesForConsumerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeDataSharesForProducer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeDataSharesForProducerError {
    /// Kind of error that occurred.
    pub kind: DescribeDataSharesForProducerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeDataSharesForProducer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeDataSharesForProducerErrorKind {
    /// <p>The namespace isn't valid because the namespace doesn't exist. Provide a valid namespace.</p>
    InvalidNamespaceFault(crate::error::InvalidNamespaceFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeDataSharesForProducerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeDataSharesForProducerErrorKind::InvalidNamespaceFault(_inner) => _inner.fmt(f),
            DescribeDataSharesForProducerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeDataSharesForProducerError {
    fn code(&self) -> Option<&str> {
        DescribeDataSharesForProducerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeDataSharesForProducerError {
    /// Creates a new `DescribeDataSharesForProducerError`.
    pub fn new(
        kind: DescribeDataSharesForProducerErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeDataSharesForProducerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeDataSharesForProducerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeDataSharesForProducerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeDataSharesForProducerErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeDataSharesForProducerErrorKind::InvalidNamespaceFault`.
    pub fn is_invalid_namespace_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDataSharesForProducerErrorKind::InvalidNamespaceFault(_)
        )
    }
}
impl std::error::Error for DescribeDataSharesForProducerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeDataSharesForProducerErrorKind::InvalidNamespaceFault(_inner) => Some(_inner),
            DescribeDataSharesForProducerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeDefaultClusterParameters` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeDefaultClusterParametersError {
    /// Kind of error that occurred.
    pub kind: DescribeDefaultClusterParametersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeDefaultClusterParameters` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeDefaultClusterParametersErrorKind {
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeDefaultClusterParametersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeDefaultClusterParametersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeDefaultClusterParametersError {
    fn code(&self) -> Option<&str> {
        DescribeDefaultClusterParametersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeDefaultClusterParametersError {
    /// Creates a new `DescribeDefaultClusterParametersError`.
    pub fn new(
        kind: DescribeDefaultClusterParametersErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeDefaultClusterParametersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeDefaultClusterParametersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeDefaultClusterParametersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeDefaultClusterParametersErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for DescribeDefaultClusterParametersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeDefaultClusterParametersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeEndpointAccess` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeEndpointAccessError {
    /// Kind of error that occurred.
    pub kind: DescribeEndpointAccessErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeEndpointAccess` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeEndpointAccessErrorKind {
    /// <p>The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster.
    /// </p>
    ClusterNotFoundFault(crate::error::ClusterNotFoundFault),
    /// <p>The endpoint name doesn't refer to an existing endpoint.</p>
    EndpointNotFoundFault(crate::error::EndpointNotFoundFault),
    /// <p>The specified cluster is not in the <code>available</code> state. </p>
    InvalidClusterStateFault(crate::error::InvalidClusterStateFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeEndpointAccessError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeEndpointAccessErrorKind::ClusterNotFoundFault(_inner) => _inner.fmt(f),
            DescribeEndpointAccessErrorKind::EndpointNotFoundFault(_inner) => _inner.fmt(f),
            DescribeEndpointAccessErrorKind::InvalidClusterStateFault(_inner) => _inner.fmt(f),
            DescribeEndpointAccessErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeEndpointAccessError {
    fn code(&self) -> Option<&str> {
        DescribeEndpointAccessError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeEndpointAccessError {
    /// Creates a new `DescribeEndpointAccessError`.
    pub fn new(kind: DescribeEndpointAccessErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeEndpointAccessError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeEndpointAccessErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeEndpointAccessError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeEndpointAccessErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeEndpointAccessErrorKind::ClusterNotFoundFault`.
    pub fn is_cluster_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEndpointAccessErrorKind::ClusterNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeEndpointAccessErrorKind::EndpointNotFoundFault`.
    pub fn is_endpoint_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEndpointAccessErrorKind::EndpointNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeEndpointAccessErrorKind::InvalidClusterStateFault`.
    pub fn is_invalid_cluster_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEndpointAccessErrorKind::InvalidClusterStateFault(_)
        )
    }
}
impl std::error::Error for DescribeEndpointAccessError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeEndpointAccessErrorKind::ClusterNotFoundFault(_inner) => Some(_inner),
            DescribeEndpointAccessErrorKind::EndpointNotFoundFault(_inner) => Some(_inner),
            DescribeEndpointAccessErrorKind::InvalidClusterStateFault(_inner) => Some(_inner),
            DescribeEndpointAccessErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeEndpointAuthorization` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeEndpointAuthorizationError {
    /// Kind of error that occurred.
    pub kind: DescribeEndpointAuthorizationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeEndpointAuthorization` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeEndpointAuthorizationErrorKind {
    /// <p>The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster.
    /// </p>
    ClusterNotFoundFault(crate::error::ClusterNotFoundFault),
    /// <p>The requested operation isn't supported.</p>
    UnsupportedOperationFault(crate::error::UnsupportedOperationFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeEndpointAuthorizationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeEndpointAuthorizationErrorKind::ClusterNotFoundFault(_inner) => _inner.fmt(f),
            DescribeEndpointAuthorizationErrorKind::UnsupportedOperationFault(_inner) => {
                _inner.fmt(f)
            }
            DescribeEndpointAuthorizationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeEndpointAuthorizationError {
    fn code(&self) -> Option<&str> {
        DescribeEndpointAuthorizationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeEndpointAuthorizationError {
    /// Creates a new `DescribeEndpointAuthorizationError`.
    pub fn new(
        kind: DescribeEndpointAuthorizationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeEndpointAuthorizationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeEndpointAuthorizationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeEndpointAuthorizationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeEndpointAuthorizationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeEndpointAuthorizationErrorKind::ClusterNotFoundFault`.
    pub fn is_cluster_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEndpointAuthorizationErrorKind::ClusterNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeEndpointAuthorizationErrorKind::UnsupportedOperationFault`.
    pub fn is_unsupported_operation_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEndpointAuthorizationErrorKind::UnsupportedOperationFault(_)
        )
    }
}
impl std::error::Error for DescribeEndpointAuthorizationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeEndpointAuthorizationErrorKind::ClusterNotFoundFault(_inner) => Some(_inner),
            DescribeEndpointAuthorizationErrorKind::UnsupportedOperationFault(_inner) => {
                Some(_inner)
            }
            DescribeEndpointAuthorizationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeEventCategories` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeEventCategoriesError {
    /// Kind of error that occurred.
    pub kind: DescribeEventCategoriesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeEventCategories` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeEventCategoriesErrorKind {
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeEventCategoriesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeEventCategoriesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeEventCategoriesError {
    fn code(&self) -> Option<&str> {
        DescribeEventCategoriesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeEventCategoriesError {
    /// Creates a new `DescribeEventCategoriesError`.
    pub fn new(kind: DescribeEventCategoriesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeEventCategoriesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeEventCategoriesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeEventCategoriesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeEventCategoriesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for DescribeEventCategoriesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeEventCategoriesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeEvents` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeEventsError {
    /// Kind of error that occurred.
    pub kind: DescribeEventsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeEvents` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeEventsErrorKind {
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeEventsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeEventsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeEventsError {
    fn code(&self) -> Option<&str> {
        DescribeEventsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeEventsError {
    /// Creates a new `DescribeEventsError`.
    pub fn new(kind: DescribeEventsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeEventsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeEventsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeEventsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeEventsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for DescribeEventsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeEventsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeEventSubscriptions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeEventSubscriptionsError {
    /// Kind of error that occurred.
    pub kind: DescribeEventSubscriptionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeEventSubscriptions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeEventSubscriptionsErrorKind {
    /// <p>The tag is invalid.</p>
    InvalidTagFault(crate::error::InvalidTagFault),
    /// <p>An Amazon Redshift event notification subscription with the specified name does not
    /// exist.</p>
    SubscriptionNotFoundFault(crate::error::SubscriptionNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeEventSubscriptionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeEventSubscriptionsErrorKind::InvalidTagFault(_inner) => _inner.fmt(f),
            DescribeEventSubscriptionsErrorKind::SubscriptionNotFoundFault(_inner) => _inner.fmt(f),
            DescribeEventSubscriptionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeEventSubscriptionsError {
    fn code(&self) -> Option<&str> {
        DescribeEventSubscriptionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeEventSubscriptionsError {
    /// Creates a new `DescribeEventSubscriptionsError`.
    pub fn new(kind: DescribeEventSubscriptionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeEventSubscriptionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeEventSubscriptionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeEventSubscriptionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeEventSubscriptionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeEventSubscriptionsErrorKind::InvalidTagFault`.
    pub fn is_invalid_tag_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEventSubscriptionsErrorKind::InvalidTagFault(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeEventSubscriptionsErrorKind::SubscriptionNotFoundFault`.
    pub fn is_subscription_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEventSubscriptionsErrorKind::SubscriptionNotFoundFault(_)
        )
    }
}
impl std::error::Error for DescribeEventSubscriptionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeEventSubscriptionsErrorKind::InvalidTagFault(_inner) => Some(_inner),
            DescribeEventSubscriptionsErrorKind::SubscriptionNotFoundFault(_inner) => Some(_inner),
            DescribeEventSubscriptionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeHsmClientCertificates` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeHsmClientCertificatesError {
    /// Kind of error that occurred.
    pub kind: DescribeHsmClientCertificatesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeHsmClientCertificates` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeHsmClientCertificatesErrorKind {
    /// <p>There is no Amazon Redshift HSM client certificate with the specified
    /// identifier.</p>
    HsmClientCertificateNotFoundFault(crate::error::HsmClientCertificateNotFoundFault),
    /// <p>The tag is invalid.</p>
    InvalidTagFault(crate::error::InvalidTagFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeHsmClientCertificatesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeHsmClientCertificatesErrorKind::HsmClientCertificateNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            DescribeHsmClientCertificatesErrorKind::InvalidTagFault(_inner) => _inner.fmt(f),
            DescribeHsmClientCertificatesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeHsmClientCertificatesError {
    fn code(&self) -> Option<&str> {
        DescribeHsmClientCertificatesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeHsmClientCertificatesError {
    /// Creates a new `DescribeHsmClientCertificatesError`.
    pub fn new(
        kind: DescribeHsmClientCertificatesErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeHsmClientCertificatesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeHsmClientCertificatesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeHsmClientCertificatesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeHsmClientCertificatesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeHsmClientCertificatesErrorKind::HsmClientCertificateNotFoundFault`.
    pub fn is_hsm_client_certificate_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeHsmClientCertificatesErrorKind::HsmClientCertificateNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeHsmClientCertificatesErrorKind::InvalidTagFault`.
    pub fn is_invalid_tag_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeHsmClientCertificatesErrorKind::InvalidTagFault(_)
        )
    }
}
impl std::error::Error for DescribeHsmClientCertificatesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeHsmClientCertificatesErrorKind::HsmClientCertificateNotFoundFault(_inner) => {
                Some(_inner)
            }
            DescribeHsmClientCertificatesErrorKind::InvalidTagFault(_inner) => Some(_inner),
            DescribeHsmClientCertificatesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeHsmConfigurations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeHsmConfigurationsError {
    /// Kind of error that occurred.
    pub kind: DescribeHsmConfigurationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeHsmConfigurations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeHsmConfigurationsErrorKind {
    /// <p>There is no Amazon Redshift HSM configuration with the specified identifier.</p>
    HsmConfigurationNotFoundFault(crate::error::HsmConfigurationNotFoundFault),
    /// <p>The tag is invalid.</p>
    InvalidTagFault(crate::error::InvalidTagFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeHsmConfigurationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeHsmConfigurationsErrorKind::HsmConfigurationNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            DescribeHsmConfigurationsErrorKind::InvalidTagFault(_inner) => _inner.fmt(f),
            DescribeHsmConfigurationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeHsmConfigurationsError {
    fn code(&self) -> Option<&str> {
        DescribeHsmConfigurationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeHsmConfigurationsError {
    /// Creates a new `DescribeHsmConfigurationsError`.
    pub fn new(kind: DescribeHsmConfigurationsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeHsmConfigurationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeHsmConfigurationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeHsmConfigurationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeHsmConfigurationsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeHsmConfigurationsErrorKind::HsmConfigurationNotFoundFault`.
    pub fn is_hsm_configuration_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeHsmConfigurationsErrorKind::HsmConfigurationNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeHsmConfigurationsErrorKind::InvalidTagFault`.
    pub fn is_invalid_tag_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeHsmConfigurationsErrorKind::InvalidTagFault(_)
        )
    }
}
impl std::error::Error for DescribeHsmConfigurationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeHsmConfigurationsErrorKind::HsmConfigurationNotFoundFault(_inner) => {
                Some(_inner)
            }
            DescribeHsmConfigurationsErrorKind::InvalidTagFault(_inner) => Some(_inner),
            DescribeHsmConfigurationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeLoggingStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeLoggingStatusError {
    /// Kind of error that occurred.
    pub kind: DescribeLoggingStatusErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeLoggingStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeLoggingStatusErrorKind {
    /// <p>The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster.
    /// </p>
    ClusterNotFoundFault(crate::error::ClusterNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeLoggingStatusError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeLoggingStatusErrorKind::ClusterNotFoundFault(_inner) => _inner.fmt(f),
            DescribeLoggingStatusErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeLoggingStatusError {
    fn code(&self) -> Option<&str> {
        DescribeLoggingStatusError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeLoggingStatusError {
    /// Creates a new `DescribeLoggingStatusError`.
    pub fn new(kind: DescribeLoggingStatusErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeLoggingStatusError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeLoggingStatusErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeLoggingStatusError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeLoggingStatusErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeLoggingStatusErrorKind::ClusterNotFoundFault`.
    pub fn is_cluster_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeLoggingStatusErrorKind::ClusterNotFoundFault(_)
        )
    }
}
impl std::error::Error for DescribeLoggingStatusError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeLoggingStatusErrorKind::ClusterNotFoundFault(_inner) => Some(_inner),
            DescribeLoggingStatusErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeNodeConfigurationOptions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeNodeConfigurationOptionsError {
    /// Kind of error that occurred.
    pub kind: DescribeNodeConfigurationOptionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeNodeConfigurationOptions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeNodeConfigurationOptionsErrorKind {
    /// <p>The owner of the specified snapshot has not authorized your account to access the
    /// snapshot.</p>
    AccessToSnapshotDeniedFault(crate::error::AccessToSnapshotDeniedFault),
    /// <p>The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster.
    /// </p>
    ClusterNotFoundFault(crate::error::ClusterNotFoundFault),
    /// <p>The snapshot identifier does not refer to an existing cluster snapshot.</p>
    ClusterSnapshotNotFoundFault(crate::error::ClusterSnapshotNotFoundFault),
    /// <p>The specified cluster snapshot is not in the <code>available</code> state, or other
    /// accounts are authorized to access the snapshot. </p>
    InvalidClusterSnapshotStateFault(crate::error::InvalidClusterSnapshotStateFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeNodeConfigurationOptionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeNodeConfigurationOptionsErrorKind::AccessToSnapshotDeniedFault(_inner) => {
                _inner.fmt(f)
            }
            DescribeNodeConfigurationOptionsErrorKind::ClusterNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            DescribeNodeConfigurationOptionsErrorKind::ClusterSnapshotNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            DescribeNodeConfigurationOptionsErrorKind::InvalidClusterSnapshotStateFault(_inner) => {
                _inner.fmt(f)
            }
            DescribeNodeConfigurationOptionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeNodeConfigurationOptionsError {
    fn code(&self) -> Option<&str> {
        DescribeNodeConfigurationOptionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeNodeConfigurationOptionsError {
    /// Creates a new `DescribeNodeConfigurationOptionsError`.
    pub fn new(
        kind: DescribeNodeConfigurationOptionsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeNodeConfigurationOptionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeNodeConfigurationOptionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeNodeConfigurationOptionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeNodeConfigurationOptionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeNodeConfigurationOptionsErrorKind::AccessToSnapshotDeniedFault`.
    pub fn is_access_to_snapshot_denied_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeNodeConfigurationOptionsErrorKind::AccessToSnapshotDeniedFault(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeNodeConfigurationOptionsErrorKind::ClusterNotFoundFault`.
    pub fn is_cluster_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeNodeConfigurationOptionsErrorKind::ClusterNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeNodeConfigurationOptionsErrorKind::ClusterSnapshotNotFoundFault`.
    pub fn is_cluster_snapshot_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeNodeConfigurationOptionsErrorKind::ClusterSnapshotNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeNodeConfigurationOptionsErrorKind::InvalidClusterSnapshotStateFault`.
    pub fn is_invalid_cluster_snapshot_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeNodeConfigurationOptionsErrorKind::InvalidClusterSnapshotStateFault(_)
        )
    }
}
impl std::error::Error for DescribeNodeConfigurationOptionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeNodeConfigurationOptionsErrorKind::AccessToSnapshotDeniedFault(_inner) => {
                Some(_inner)
            }
            DescribeNodeConfigurationOptionsErrorKind::ClusterNotFoundFault(_inner) => Some(_inner),
            DescribeNodeConfigurationOptionsErrorKind::ClusterSnapshotNotFoundFault(_inner) => {
                Some(_inner)
            }
            DescribeNodeConfigurationOptionsErrorKind::InvalidClusterSnapshotStateFault(_inner) => {
                Some(_inner)
            }
            DescribeNodeConfigurationOptionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeOrderableClusterOptions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeOrderableClusterOptionsError {
    /// Kind of error that occurred.
    pub kind: DescribeOrderableClusterOptionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeOrderableClusterOptions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeOrderableClusterOptionsErrorKind {
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeOrderableClusterOptionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeOrderableClusterOptionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeOrderableClusterOptionsError {
    fn code(&self) -> Option<&str> {
        DescribeOrderableClusterOptionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeOrderableClusterOptionsError {
    /// Creates a new `DescribeOrderableClusterOptionsError`.
    pub fn new(
        kind: DescribeOrderableClusterOptionsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeOrderableClusterOptionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeOrderableClusterOptionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeOrderableClusterOptionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeOrderableClusterOptionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for DescribeOrderableClusterOptionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeOrderableClusterOptionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribePartners` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribePartnersError {
    /// Kind of error that occurred.
    pub kind: DescribePartnersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribePartners` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribePartnersErrorKind {
    /// <p>The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster.
    /// </p>
    ClusterNotFoundFault(crate::error::ClusterNotFoundFault),
    /// <p>The partner integration is not authorized.</p>
    UnauthorizedPartnerIntegrationFault(crate::error::UnauthorizedPartnerIntegrationFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribePartnersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribePartnersErrorKind::ClusterNotFoundFault(_inner) => _inner.fmt(f),
            DescribePartnersErrorKind::UnauthorizedPartnerIntegrationFault(_inner) => _inner.fmt(f),
            DescribePartnersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribePartnersError {
    fn code(&self) -> Option<&str> {
        DescribePartnersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribePartnersError {
    /// Creates a new `DescribePartnersError`.
    pub fn new(kind: DescribePartnersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribePartnersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribePartnersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribePartnersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribePartnersErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribePartnersErrorKind::ClusterNotFoundFault`.
    pub fn is_cluster_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribePartnersErrorKind::ClusterNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `DescribePartnersErrorKind::UnauthorizedPartnerIntegrationFault`.
    pub fn is_unauthorized_partner_integration_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribePartnersErrorKind::UnauthorizedPartnerIntegrationFault(_)
        )
    }
}
impl std::error::Error for DescribePartnersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribePartnersErrorKind::ClusterNotFoundFault(_inner) => Some(_inner),
            DescribePartnersErrorKind::UnauthorizedPartnerIntegrationFault(_inner) => Some(_inner),
            DescribePartnersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeReservedNodeOfferings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeReservedNodeOfferingsError {
    /// Kind of error that occurred.
    pub kind: DescribeReservedNodeOfferingsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeReservedNodeOfferings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeReservedNodeOfferingsErrorKind {
    /// <p>Your request cannot be completed because a dependent internal service is
    /// temporarily unavailable. Wait 30 to 60 seconds and try again.</p>
    DependentServiceUnavailableFault(crate::error::DependentServiceUnavailableFault),
    /// <p>Specified offering does not exist.</p>
    ReservedNodeOfferingNotFoundFault(crate::error::ReservedNodeOfferingNotFoundFault),
    /// <p>The requested operation isn't supported.</p>
    UnsupportedOperationFault(crate::error::UnsupportedOperationFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeReservedNodeOfferingsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeReservedNodeOfferingsErrorKind::DependentServiceUnavailableFault(_inner) => {
                _inner.fmt(f)
            }
            DescribeReservedNodeOfferingsErrorKind::ReservedNodeOfferingNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            DescribeReservedNodeOfferingsErrorKind::UnsupportedOperationFault(_inner) => {
                _inner.fmt(f)
            }
            DescribeReservedNodeOfferingsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeReservedNodeOfferingsError {
    fn code(&self) -> Option<&str> {
        DescribeReservedNodeOfferingsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeReservedNodeOfferingsError {
    /// Creates a new `DescribeReservedNodeOfferingsError`.
    pub fn new(
        kind: DescribeReservedNodeOfferingsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeReservedNodeOfferingsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeReservedNodeOfferingsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeReservedNodeOfferingsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeReservedNodeOfferingsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeReservedNodeOfferingsErrorKind::DependentServiceUnavailableFault`.
    pub fn is_dependent_service_unavailable_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeReservedNodeOfferingsErrorKind::DependentServiceUnavailableFault(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeReservedNodeOfferingsErrorKind::ReservedNodeOfferingNotFoundFault`.
    pub fn is_reserved_node_offering_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeReservedNodeOfferingsErrorKind::ReservedNodeOfferingNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeReservedNodeOfferingsErrorKind::UnsupportedOperationFault`.
    pub fn is_unsupported_operation_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeReservedNodeOfferingsErrorKind::UnsupportedOperationFault(_)
        )
    }
}
impl std::error::Error for DescribeReservedNodeOfferingsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeReservedNodeOfferingsErrorKind::DependentServiceUnavailableFault(_inner) => {
                Some(_inner)
            }
            DescribeReservedNodeOfferingsErrorKind::ReservedNodeOfferingNotFoundFault(_inner) => {
                Some(_inner)
            }
            DescribeReservedNodeOfferingsErrorKind::UnsupportedOperationFault(_inner) => {
                Some(_inner)
            }
            DescribeReservedNodeOfferingsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeReservedNodes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeReservedNodesError {
    /// Kind of error that occurred.
    pub kind: DescribeReservedNodesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeReservedNodes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeReservedNodesErrorKind {
    /// <p>Your request cannot be completed because a dependent internal service is
    /// temporarily unavailable. Wait 30 to 60 seconds and try again.</p>
    DependentServiceUnavailableFault(crate::error::DependentServiceUnavailableFault),
    /// <p>The specified reserved compute node not found.</p>
    ReservedNodeNotFoundFault(crate::error::ReservedNodeNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeReservedNodesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeReservedNodesErrorKind::DependentServiceUnavailableFault(_inner) => {
                _inner.fmt(f)
            }
            DescribeReservedNodesErrorKind::ReservedNodeNotFoundFault(_inner) => _inner.fmt(f),
            DescribeReservedNodesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeReservedNodesError {
    fn code(&self) -> Option<&str> {
        DescribeReservedNodesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeReservedNodesError {
    /// Creates a new `DescribeReservedNodesError`.
    pub fn new(kind: DescribeReservedNodesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeReservedNodesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeReservedNodesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeReservedNodesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeReservedNodesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeReservedNodesErrorKind::DependentServiceUnavailableFault`.
    pub fn is_dependent_service_unavailable_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeReservedNodesErrorKind::DependentServiceUnavailableFault(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeReservedNodesErrorKind::ReservedNodeNotFoundFault`.
    pub fn is_reserved_node_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeReservedNodesErrorKind::ReservedNodeNotFoundFault(_)
        )
    }
}
impl std::error::Error for DescribeReservedNodesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeReservedNodesErrorKind::DependentServiceUnavailableFault(_inner) => {
                Some(_inner)
            }
            DescribeReservedNodesErrorKind::ReservedNodeNotFoundFault(_inner) => Some(_inner),
            DescribeReservedNodesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeResize` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeResizeError {
    /// Kind of error that occurred.
    pub kind: DescribeResizeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeResize` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeResizeErrorKind {
    /// <p>The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster.
    /// </p>
    ClusterNotFoundFault(crate::error::ClusterNotFoundFault),
    /// <p>A resize operation for the specified cluster is not found.</p>
    ResizeNotFoundFault(crate::error::ResizeNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeResizeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeResizeErrorKind::ClusterNotFoundFault(_inner) => _inner.fmt(f),
            DescribeResizeErrorKind::ResizeNotFoundFault(_inner) => _inner.fmt(f),
            DescribeResizeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeResizeError {
    fn code(&self) -> Option<&str> {
        DescribeResizeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeResizeError {
    /// Creates a new `DescribeResizeError`.
    pub fn new(kind: DescribeResizeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeResizeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeResizeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeResizeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeResizeErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeResizeErrorKind::ClusterNotFoundFault`.
    pub fn is_cluster_not_found_fault(&self) -> bool {
        matches!(&self.kind, DescribeResizeErrorKind::ClusterNotFoundFault(_))
    }
    /// Returns `true` if the error kind is `DescribeResizeErrorKind::ResizeNotFoundFault`.
    pub fn is_resize_not_found_fault(&self) -> bool {
        matches!(&self.kind, DescribeResizeErrorKind::ResizeNotFoundFault(_))
    }
}
impl std::error::Error for DescribeResizeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeResizeErrorKind::ClusterNotFoundFault(_inner) => Some(_inner),
            DescribeResizeErrorKind::ResizeNotFoundFault(_inner) => Some(_inner),
            DescribeResizeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeScheduledActions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeScheduledActionsError {
    /// Kind of error that occurred.
    pub kind: DescribeScheduledActionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeScheduledActions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeScheduledActionsErrorKind {
    /// <p>The scheduled action cannot be found. </p>
    ScheduledActionNotFoundFault(crate::error::ScheduledActionNotFoundFault),
    /// <p>Your account is not authorized to perform the requested operation.</p>
    UnauthorizedOperation(crate::error::UnauthorizedOperation),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeScheduledActionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeScheduledActionsErrorKind::ScheduledActionNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            DescribeScheduledActionsErrorKind::UnauthorizedOperation(_inner) => _inner.fmt(f),
            DescribeScheduledActionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeScheduledActionsError {
    fn code(&self) -> Option<&str> {
        DescribeScheduledActionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeScheduledActionsError {
    /// Creates a new `DescribeScheduledActionsError`.
    pub fn new(kind: DescribeScheduledActionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeScheduledActionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeScheduledActionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeScheduledActionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeScheduledActionsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeScheduledActionsErrorKind::ScheduledActionNotFoundFault`.
    pub fn is_scheduled_action_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeScheduledActionsErrorKind::ScheduledActionNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeScheduledActionsErrorKind::UnauthorizedOperation`.
    pub fn is_unauthorized_operation(&self) -> bool {
        matches!(
            &self.kind,
            DescribeScheduledActionsErrorKind::UnauthorizedOperation(_)
        )
    }
}
impl std::error::Error for DescribeScheduledActionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeScheduledActionsErrorKind::ScheduledActionNotFoundFault(_inner) => Some(_inner),
            DescribeScheduledActionsErrorKind::UnauthorizedOperation(_inner) => Some(_inner),
            DescribeScheduledActionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeSnapshotCopyGrants` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeSnapshotCopyGrantsError {
    /// Kind of error that occurred.
    pub kind: DescribeSnapshotCopyGrantsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeSnapshotCopyGrants` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeSnapshotCopyGrantsErrorKind {
    /// <p>The tag is invalid.</p>
    InvalidTagFault(crate::error::InvalidTagFault),
    /// <p>The specified snapshot copy grant can't be found. Make sure that the name is typed
    /// correctly and that the grant exists in the destination region.</p>
    SnapshotCopyGrantNotFoundFault(crate::error::SnapshotCopyGrantNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeSnapshotCopyGrantsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeSnapshotCopyGrantsErrorKind::InvalidTagFault(_inner) => _inner.fmt(f),
            DescribeSnapshotCopyGrantsErrorKind::SnapshotCopyGrantNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            DescribeSnapshotCopyGrantsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeSnapshotCopyGrantsError {
    fn code(&self) -> Option<&str> {
        DescribeSnapshotCopyGrantsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeSnapshotCopyGrantsError {
    /// Creates a new `DescribeSnapshotCopyGrantsError`.
    pub fn new(kind: DescribeSnapshotCopyGrantsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeSnapshotCopyGrantsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeSnapshotCopyGrantsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeSnapshotCopyGrantsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeSnapshotCopyGrantsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeSnapshotCopyGrantsErrorKind::InvalidTagFault`.
    pub fn is_invalid_tag_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeSnapshotCopyGrantsErrorKind::InvalidTagFault(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeSnapshotCopyGrantsErrorKind::SnapshotCopyGrantNotFoundFault`.
    pub fn is_snapshot_copy_grant_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeSnapshotCopyGrantsErrorKind::SnapshotCopyGrantNotFoundFault(_)
        )
    }
}
impl std::error::Error for DescribeSnapshotCopyGrantsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeSnapshotCopyGrantsErrorKind::InvalidTagFault(_inner) => Some(_inner),
            DescribeSnapshotCopyGrantsErrorKind::SnapshotCopyGrantNotFoundFault(_inner) => {
                Some(_inner)
            }
            DescribeSnapshotCopyGrantsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeSnapshotSchedules` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeSnapshotSchedulesError {
    /// Kind of error that occurred.
    pub kind: DescribeSnapshotSchedulesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeSnapshotSchedules` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeSnapshotSchedulesErrorKind {
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeSnapshotSchedulesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeSnapshotSchedulesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeSnapshotSchedulesError {
    fn code(&self) -> Option<&str> {
        DescribeSnapshotSchedulesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeSnapshotSchedulesError {
    /// Creates a new `DescribeSnapshotSchedulesError`.
    pub fn new(kind: DescribeSnapshotSchedulesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeSnapshotSchedulesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeSnapshotSchedulesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeSnapshotSchedulesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeSnapshotSchedulesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for DescribeSnapshotSchedulesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeSnapshotSchedulesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeStorage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeStorageError {
    /// Kind of error that occurred.
    pub kind: DescribeStorageErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeStorage` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeStorageErrorKind {
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeStorageError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeStorageErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeStorageError {
    fn code(&self) -> Option<&str> {
        DescribeStorageError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeStorageError {
    /// Creates a new `DescribeStorageError`.
    pub fn new(kind: DescribeStorageErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeStorageError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeStorageErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeStorageError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeStorageErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for DescribeStorageError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeStorageErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeTableRestoreStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeTableRestoreStatusError {
    /// Kind of error that occurred.
    pub kind: DescribeTableRestoreStatusErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeTableRestoreStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeTableRestoreStatusErrorKind {
    /// <p>The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster.
    /// </p>
    ClusterNotFoundFault(crate::error::ClusterNotFoundFault),
    /// <p>The specified <code>TableRestoreRequestId</code> value was not found.</p>
    TableRestoreNotFoundFault(crate::error::TableRestoreNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeTableRestoreStatusError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeTableRestoreStatusErrorKind::ClusterNotFoundFault(_inner) => _inner.fmt(f),
            DescribeTableRestoreStatusErrorKind::TableRestoreNotFoundFault(_inner) => _inner.fmt(f),
            DescribeTableRestoreStatusErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeTableRestoreStatusError {
    fn code(&self) -> Option<&str> {
        DescribeTableRestoreStatusError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeTableRestoreStatusError {
    /// Creates a new `DescribeTableRestoreStatusError`.
    pub fn new(kind: DescribeTableRestoreStatusErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeTableRestoreStatusError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeTableRestoreStatusErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeTableRestoreStatusError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeTableRestoreStatusErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeTableRestoreStatusErrorKind::ClusterNotFoundFault`.
    pub fn is_cluster_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeTableRestoreStatusErrorKind::ClusterNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeTableRestoreStatusErrorKind::TableRestoreNotFoundFault`.
    pub fn is_table_restore_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeTableRestoreStatusErrorKind::TableRestoreNotFoundFault(_)
        )
    }
}
impl std::error::Error for DescribeTableRestoreStatusError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeTableRestoreStatusErrorKind::ClusterNotFoundFault(_inner) => Some(_inner),
            DescribeTableRestoreStatusErrorKind::TableRestoreNotFoundFault(_inner) => Some(_inner),
            DescribeTableRestoreStatusErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeTagsError {
    /// Kind of error that occurred.
    pub kind: DescribeTagsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeTagsErrorKind {
    /// <p>The tag is invalid.</p>
    InvalidTagFault(crate::error::InvalidTagFault),
    /// <p>The resource could not be found.</p>
    ResourceNotFoundFault(crate::error::ResourceNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeTagsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeTagsErrorKind::InvalidTagFault(_inner) => _inner.fmt(f),
            DescribeTagsErrorKind::ResourceNotFoundFault(_inner) => _inner.fmt(f),
            DescribeTagsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeTagsError {
    fn code(&self) -> Option<&str> {
        DescribeTagsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeTagsError {
    /// Creates a new `DescribeTagsError`.
    pub fn new(kind: DescribeTagsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeTagsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeTagsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeTagsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeTagsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeTagsErrorKind::InvalidTagFault`.
    pub fn is_invalid_tag_fault(&self) -> bool {
        matches!(&self.kind, DescribeTagsErrorKind::InvalidTagFault(_))
    }
    /// Returns `true` if the error kind is `DescribeTagsErrorKind::ResourceNotFoundFault`.
    pub fn is_resource_not_found_fault(&self) -> bool {
        matches!(&self.kind, DescribeTagsErrorKind::ResourceNotFoundFault(_))
    }
}
impl std::error::Error for DescribeTagsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeTagsErrorKind::InvalidTagFault(_inner) => Some(_inner),
            DescribeTagsErrorKind::ResourceNotFoundFault(_inner) => Some(_inner),
            DescribeTagsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeUsageLimits` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeUsageLimitsError {
    /// Kind of error that occurred.
    pub kind: DescribeUsageLimitsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeUsageLimits` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeUsageLimitsErrorKind {
    /// <p>The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster.
    /// </p>
    ClusterNotFoundFault(crate::error::ClusterNotFoundFault),
    /// <p>The requested operation isn't supported.</p>
    UnsupportedOperationFault(crate::error::UnsupportedOperationFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeUsageLimitsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeUsageLimitsErrorKind::ClusterNotFoundFault(_inner) => _inner.fmt(f),
            DescribeUsageLimitsErrorKind::UnsupportedOperationFault(_inner) => _inner.fmt(f),
            DescribeUsageLimitsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeUsageLimitsError {
    fn code(&self) -> Option<&str> {
        DescribeUsageLimitsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeUsageLimitsError {
    /// Creates a new `DescribeUsageLimitsError`.
    pub fn new(kind: DescribeUsageLimitsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeUsageLimitsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeUsageLimitsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeUsageLimitsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeUsageLimitsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeUsageLimitsErrorKind::ClusterNotFoundFault`.
    pub fn is_cluster_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeUsageLimitsErrorKind::ClusterNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeUsageLimitsErrorKind::UnsupportedOperationFault`.
    pub fn is_unsupported_operation_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeUsageLimitsErrorKind::UnsupportedOperationFault(_)
        )
    }
}
impl std::error::Error for DescribeUsageLimitsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeUsageLimitsErrorKind::ClusterNotFoundFault(_inner) => Some(_inner),
            DescribeUsageLimitsErrorKind::UnsupportedOperationFault(_inner) => Some(_inner),
            DescribeUsageLimitsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisableLogging` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisableLoggingError {
    /// Kind of error that occurred.
    pub kind: DisableLoggingErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisableLogging` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisableLoggingErrorKind {
    /// <p>The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster.
    /// </p>
    ClusterNotFoundFault(crate::error::ClusterNotFoundFault),
    /// <p>The specified cluster is not in the <code>available</code> state. </p>
    InvalidClusterStateFault(crate::error::InvalidClusterStateFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisableLoggingError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisableLoggingErrorKind::ClusterNotFoundFault(_inner) => _inner.fmt(f),
            DisableLoggingErrorKind::InvalidClusterStateFault(_inner) => _inner.fmt(f),
            DisableLoggingErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisableLoggingError {
    fn code(&self) -> Option<&str> {
        DisableLoggingError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisableLoggingError {
    /// Creates a new `DisableLoggingError`.
    pub fn new(kind: DisableLoggingErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisableLoggingError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisableLoggingErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisableLoggingError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisableLoggingErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DisableLoggingErrorKind::ClusterNotFoundFault`.
    pub fn is_cluster_not_found_fault(&self) -> bool {
        matches!(&self.kind, DisableLoggingErrorKind::ClusterNotFoundFault(_))
    }
    /// Returns `true` if the error kind is `DisableLoggingErrorKind::InvalidClusterStateFault`.
    pub fn is_invalid_cluster_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            DisableLoggingErrorKind::InvalidClusterStateFault(_)
        )
    }
}
impl std::error::Error for DisableLoggingError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisableLoggingErrorKind::ClusterNotFoundFault(_inner) => Some(_inner),
            DisableLoggingErrorKind::InvalidClusterStateFault(_inner) => Some(_inner),
            DisableLoggingErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisableSnapshotCopy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisableSnapshotCopyError {
    /// Kind of error that occurred.
    pub kind: DisableSnapshotCopyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisableSnapshotCopy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisableSnapshotCopyErrorKind {
    /// <p>The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster.
    /// </p>
    ClusterNotFoundFault(crate::error::ClusterNotFoundFault),
    /// <p>The specified cluster is not in the <code>available</code> state. </p>
    InvalidClusterStateFault(crate::error::InvalidClusterStateFault),
    /// <p>The cluster already has cross-region snapshot copy disabled.</p>
    SnapshotCopyAlreadyDisabledFault(crate::error::SnapshotCopyAlreadyDisabledFault),
    /// <p>Your account is not authorized to perform the requested operation.</p>
    UnauthorizedOperation(crate::error::UnauthorizedOperation),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisableSnapshotCopyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisableSnapshotCopyErrorKind::ClusterNotFoundFault(_inner) => _inner.fmt(f),
            DisableSnapshotCopyErrorKind::InvalidClusterStateFault(_inner) => _inner.fmt(f),
            DisableSnapshotCopyErrorKind::SnapshotCopyAlreadyDisabledFault(_inner) => _inner.fmt(f),
            DisableSnapshotCopyErrorKind::UnauthorizedOperation(_inner) => _inner.fmt(f),
            DisableSnapshotCopyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisableSnapshotCopyError {
    fn code(&self) -> Option<&str> {
        DisableSnapshotCopyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisableSnapshotCopyError {
    /// Creates a new `DisableSnapshotCopyError`.
    pub fn new(kind: DisableSnapshotCopyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisableSnapshotCopyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisableSnapshotCopyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisableSnapshotCopyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisableSnapshotCopyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DisableSnapshotCopyErrorKind::ClusterNotFoundFault`.
    pub fn is_cluster_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DisableSnapshotCopyErrorKind::ClusterNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `DisableSnapshotCopyErrorKind::InvalidClusterStateFault`.
    pub fn is_invalid_cluster_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            DisableSnapshotCopyErrorKind::InvalidClusterStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `DisableSnapshotCopyErrorKind::SnapshotCopyAlreadyDisabledFault`.
    pub fn is_snapshot_copy_already_disabled_fault(&self) -> bool {
        matches!(
            &self.kind,
            DisableSnapshotCopyErrorKind::SnapshotCopyAlreadyDisabledFault(_)
        )
    }
    /// Returns `true` if the error kind is `DisableSnapshotCopyErrorKind::UnauthorizedOperation`.
    pub fn is_unauthorized_operation(&self) -> bool {
        matches!(
            &self.kind,
            DisableSnapshotCopyErrorKind::UnauthorizedOperation(_)
        )
    }
}
impl std::error::Error for DisableSnapshotCopyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisableSnapshotCopyErrorKind::ClusterNotFoundFault(_inner) => Some(_inner),
            DisableSnapshotCopyErrorKind::InvalidClusterStateFault(_inner) => Some(_inner),
            DisableSnapshotCopyErrorKind::SnapshotCopyAlreadyDisabledFault(_inner) => Some(_inner),
            DisableSnapshotCopyErrorKind::UnauthorizedOperation(_inner) => Some(_inner),
            DisableSnapshotCopyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisassociateDataShareConsumer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisassociateDataShareConsumerError {
    /// Kind of error that occurred.
    pub kind: DisassociateDataShareConsumerErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisassociateDataShareConsumer` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisassociateDataShareConsumerErrorKind {
    /// <p>There is an error with the datashare.</p>
    InvalidDataShareFault(crate::error::InvalidDataShareFault),
    /// <p>The namespace isn't valid because the namespace doesn't exist. Provide a valid namespace.</p>
    InvalidNamespaceFault(crate::error::InvalidNamespaceFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisassociateDataShareConsumerError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisassociateDataShareConsumerErrorKind::InvalidDataShareFault(_inner) => _inner.fmt(f),
            DisassociateDataShareConsumerErrorKind::InvalidNamespaceFault(_inner) => _inner.fmt(f),
            DisassociateDataShareConsumerErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisassociateDataShareConsumerError {
    fn code(&self) -> Option<&str> {
        DisassociateDataShareConsumerError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisassociateDataShareConsumerError {
    /// Creates a new `DisassociateDataShareConsumerError`.
    pub fn new(
        kind: DisassociateDataShareConsumerErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisassociateDataShareConsumerError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisassociateDataShareConsumerErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisassociateDataShareConsumerError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisassociateDataShareConsumerErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DisassociateDataShareConsumerErrorKind::InvalidDataShareFault`.
    pub fn is_invalid_data_share_fault(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateDataShareConsumerErrorKind::InvalidDataShareFault(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateDataShareConsumerErrorKind::InvalidNamespaceFault`.
    pub fn is_invalid_namespace_fault(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateDataShareConsumerErrorKind::InvalidNamespaceFault(_)
        )
    }
}
impl std::error::Error for DisassociateDataShareConsumerError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisassociateDataShareConsumerErrorKind::InvalidDataShareFault(_inner) => Some(_inner),
            DisassociateDataShareConsumerErrorKind::InvalidNamespaceFault(_inner) => Some(_inner),
            DisassociateDataShareConsumerErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `EnableLogging` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct EnableLoggingError {
    /// Kind of error that occurred.
    pub kind: EnableLoggingErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `EnableLogging` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum EnableLoggingErrorKind {
    /// <p>Could not find the specified S3 bucket.</p>
    BucketNotFoundFault(crate::error::BucketNotFoundFault),
    /// <p>The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster.
    /// </p>
    ClusterNotFoundFault(crate::error::ClusterNotFoundFault),
    /// <p>The cluster does not have read bucket or put object permissions on the S3 bucket
    /// specified when enabling logging.</p>
    InsufficientS3BucketPolicyFault(crate::error::InsufficientS3BucketPolicyFault),
    /// <p>The specified cluster is not in the <code>available</code> state. </p>
    InvalidClusterStateFault(crate::error::InvalidClusterStateFault),
    /// <p>The S3 bucket name is invalid. For more information about naming rules, go to
    /// <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/BucketRestrictions.html">Bucket
    /// Restrictions and Limitations</a> in the Amazon Simple Storage Service (S3)
    /// Developer Guide.</p>
    InvalidS3BucketNameFault(crate::error::InvalidS3BucketNameFault),
    /// <p>The string specified for the logging S3 key prefix does not comply with the
    /// documented constraints.</p>
    InvalidS3KeyPrefixFault(crate::error::InvalidS3KeyPrefixFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for EnableLoggingError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            EnableLoggingErrorKind::BucketNotFoundFault(_inner) => _inner.fmt(f),
            EnableLoggingErrorKind::ClusterNotFoundFault(_inner) => _inner.fmt(f),
            EnableLoggingErrorKind::InsufficientS3BucketPolicyFault(_inner) => _inner.fmt(f),
            EnableLoggingErrorKind::InvalidClusterStateFault(_inner) => _inner.fmt(f),
            EnableLoggingErrorKind::InvalidS3BucketNameFault(_inner) => _inner.fmt(f),
            EnableLoggingErrorKind::InvalidS3KeyPrefixFault(_inner) => _inner.fmt(f),
            EnableLoggingErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for EnableLoggingError {
    fn code(&self) -> Option<&str> {
        EnableLoggingError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl EnableLoggingError {
    /// Creates a new `EnableLoggingError`.
    pub fn new(kind: EnableLoggingErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `EnableLoggingError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: EnableLoggingErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `EnableLoggingError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: EnableLoggingErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `EnableLoggingErrorKind::BucketNotFoundFault`.
    pub fn is_bucket_not_found_fault(&self) -> bool {
        matches!(&self.kind, EnableLoggingErrorKind::BucketNotFoundFault(_))
    }
    /// Returns `true` if the error kind is `EnableLoggingErrorKind::ClusterNotFoundFault`.
    pub fn is_cluster_not_found_fault(&self) -> bool {
        matches!(&self.kind, EnableLoggingErrorKind::ClusterNotFoundFault(_))
    }
    /// Returns `true` if the error kind is `EnableLoggingErrorKind::InsufficientS3BucketPolicyFault`.
    pub fn is_insufficient_s3_bucket_policy_fault(&self) -> bool {
        matches!(
            &self.kind,
            EnableLoggingErrorKind::InsufficientS3BucketPolicyFault(_)
        )
    }
    /// Returns `true` if the error kind is `EnableLoggingErrorKind::InvalidClusterStateFault`.
    pub fn is_invalid_cluster_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            EnableLoggingErrorKind::InvalidClusterStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `EnableLoggingErrorKind::InvalidS3BucketNameFault`.
    pub fn is_invalid_s3_bucket_name_fault(&self) -> bool {
        matches!(
            &self.kind,
            EnableLoggingErrorKind::InvalidS3BucketNameFault(_)
        )
    }
    /// Returns `true` if the error kind is `EnableLoggingErrorKind::InvalidS3KeyPrefixFault`.
    pub fn is_invalid_s3_key_prefix_fault(&self) -> bool {
        matches!(
            &self.kind,
            EnableLoggingErrorKind::InvalidS3KeyPrefixFault(_)
        )
    }
}
impl std::error::Error for EnableLoggingError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            EnableLoggingErrorKind::BucketNotFoundFault(_inner) => Some(_inner),
            EnableLoggingErrorKind::ClusterNotFoundFault(_inner) => Some(_inner),
            EnableLoggingErrorKind::InsufficientS3BucketPolicyFault(_inner) => Some(_inner),
            EnableLoggingErrorKind::InvalidClusterStateFault(_inner) => Some(_inner),
            EnableLoggingErrorKind::InvalidS3BucketNameFault(_inner) => Some(_inner),
            EnableLoggingErrorKind::InvalidS3KeyPrefixFault(_inner) => Some(_inner),
            EnableLoggingErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `EnableSnapshotCopy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct EnableSnapshotCopyError {
    /// Kind of error that occurred.
    pub kind: EnableSnapshotCopyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `EnableSnapshotCopy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum EnableSnapshotCopyErrorKind {
    /// <p>The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster.
    /// </p>
    ClusterNotFoundFault(crate::error::ClusterNotFoundFault),
    /// <p>Cross-region snapshot copy was temporarily disabled. Try your request
    /// again.</p>
    CopyToRegionDisabledFault(crate::error::CopyToRegionDisabledFault),
    /// <p>The request cannot be completed because a dependent service is throttling requests
    /// made by Amazon Redshift on your behalf. Wait and retry the request.</p>
    DependentServiceRequestThrottlingFault(crate::error::DependentServiceRequestThrottlingFault),
    /// <p>The specified options are incompatible.</p>
    IncompatibleOrderableOptions(crate::error::IncompatibleOrderableOptions),
    /// <p>The specified cluster is not in the <code>available</code> state. </p>
    InvalidClusterStateFault(crate::error::InvalidClusterStateFault),
    /// <p>The retention period specified is either in the past or is not a valid value.</p>
    /// <p>The value must be either -1 or an integer between 1 and 3,653.</p>
    InvalidRetentionPeriodFault(crate::error::InvalidRetentionPeriodFault),
    /// <p>The encryption key has exceeded its grant limit in Amazon Web Services KMS.</p>
    LimitExceededFault(crate::error::LimitExceededFault),
    /// <p>The cluster already has cross-region snapshot copy enabled.</p>
    SnapshotCopyAlreadyEnabledFault(crate::error::SnapshotCopyAlreadyEnabledFault),
    /// <p>The specified snapshot copy grant can't be found. Make sure that the name is typed
    /// correctly and that the grant exists in the destination region.</p>
    SnapshotCopyGrantNotFoundFault(crate::error::SnapshotCopyGrantNotFoundFault),
    /// <p>Your account is not authorized to perform the requested operation.</p>
    UnauthorizedOperation(crate::error::UnauthorizedOperation),
    /// <p>The specified region is incorrect or does not exist.</p>
    UnknownSnapshotCopyRegionFault(crate::error::UnknownSnapshotCopyRegionFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for EnableSnapshotCopyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            EnableSnapshotCopyErrorKind::ClusterNotFoundFault(_inner) => _inner.fmt(f),
            EnableSnapshotCopyErrorKind::CopyToRegionDisabledFault(_inner) => _inner.fmt(f),
            EnableSnapshotCopyErrorKind::DependentServiceRequestThrottlingFault(_inner) => {
                _inner.fmt(f)
            }
            EnableSnapshotCopyErrorKind::IncompatibleOrderableOptions(_inner) => _inner.fmt(f),
            EnableSnapshotCopyErrorKind::InvalidClusterStateFault(_inner) => _inner.fmt(f),
            EnableSnapshotCopyErrorKind::InvalidRetentionPeriodFault(_inner) => _inner.fmt(f),
            EnableSnapshotCopyErrorKind::LimitExceededFault(_inner) => _inner.fmt(f),
            EnableSnapshotCopyErrorKind::SnapshotCopyAlreadyEnabledFault(_inner) => _inner.fmt(f),
            EnableSnapshotCopyErrorKind::SnapshotCopyGrantNotFoundFault(_inner) => _inner.fmt(f),
            EnableSnapshotCopyErrorKind::UnauthorizedOperation(_inner) => _inner.fmt(f),
            EnableSnapshotCopyErrorKind::UnknownSnapshotCopyRegionFault(_inner) => _inner.fmt(f),
            EnableSnapshotCopyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for EnableSnapshotCopyError {
    fn code(&self) -> Option<&str> {
        EnableSnapshotCopyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl EnableSnapshotCopyError {
    /// Creates a new `EnableSnapshotCopyError`.
    pub fn new(kind: EnableSnapshotCopyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `EnableSnapshotCopyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: EnableSnapshotCopyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `EnableSnapshotCopyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: EnableSnapshotCopyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `EnableSnapshotCopyErrorKind::ClusterNotFoundFault`.
    pub fn is_cluster_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            EnableSnapshotCopyErrorKind::ClusterNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `EnableSnapshotCopyErrorKind::CopyToRegionDisabledFault`.
    pub fn is_copy_to_region_disabled_fault(&self) -> bool {
        matches!(
            &self.kind,
            EnableSnapshotCopyErrorKind::CopyToRegionDisabledFault(_)
        )
    }
    /// Returns `true` if the error kind is `EnableSnapshotCopyErrorKind::DependentServiceRequestThrottlingFault`.
    pub fn is_dependent_service_request_throttling_fault(&self) -> bool {
        matches!(
            &self.kind,
            EnableSnapshotCopyErrorKind::DependentServiceRequestThrottlingFault(_)
        )
    }
    /// Returns `true` if the error kind is `EnableSnapshotCopyErrorKind::IncompatibleOrderableOptions`.
    pub fn is_incompatible_orderable_options(&self) -> bool {
        matches!(
            &self.kind,
            EnableSnapshotCopyErrorKind::IncompatibleOrderableOptions(_)
        )
    }
    /// Returns `true` if the error kind is `EnableSnapshotCopyErrorKind::InvalidClusterStateFault`.
    pub fn is_invalid_cluster_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            EnableSnapshotCopyErrorKind::InvalidClusterStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `EnableSnapshotCopyErrorKind::InvalidRetentionPeriodFault`.
    pub fn is_invalid_retention_period_fault(&self) -> bool {
        matches!(
            &self.kind,
            EnableSnapshotCopyErrorKind::InvalidRetentionPeriodFault(_)
        )
    }
    /// Returns `true` if the error kind is `EnableSnapshotCopyErrorKind::LimitExceededFault`.
    pub fn is_limit_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            EnableSnapshotCopyErrorKind::LimitExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `EnableSnapshotCopyErrorKind::SnapshotCopyAlreadyEnabledFault`.
    pub fn is_snapshot_copy_already_enabled_fault(&self) -> bool {
        matches!(
            &self.kind,
            EnableSnapshotCopyErrorKind::SnapshotCopyAlreadyEnabledFault(_)
        )
    }
    /// Returns `true` if the error kind is `EnableSnapshotCopyErrorKind::SnapshotCopyGrantNotFoundFault`.
    pub fn is_snapshot_copy_grant_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            EnableSnapshotCopyErrorKind::SnapshotCopyGrantNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `EnableSnapshotCopyErrorKind::UnauthorizedOperation`.
    pub fn is_unauthorized_operation(&self) -> bool {
        matches!(
            &self.kind,
            EnableSnapshotCopyErrorKind::UnauthorizedOperation(_)
        )
    }
    /// Returns `true` if the error kind is `EnableSnapshotCopyErrorKind::UnknownSnapshotCopyRegionFault`.
    pub fn is_unknown_snapshot_copy_region_fault(&self) -> bool {
        matches!(
            &self.kind,
            EnableSnapshotCopyErrorKind::UnknownSnapshotCopyRegionFault(_)
        )
    }
}
impl std::error::Error for EnableSnapshotCopyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            EnableSnapshotCopyErrorKind::ClusterNotFoundFault(_inner) => Some(_inner),
            EnableSnapshotCopyErrorKind::CopyToRegionDisabledFault(_inner) => Some(_inner),
            EnableSnapshotCopyErrorKind::DependentServiceRequestThrottlingFault(_inner) => {
                Some(_inner)
            }
            EnableSnapshotCopyErrorKind::IncompatibleOrderableOptions(_inner) => Some(_inner),
            EnableSnapshotCopyErrorKind::InvalidClusterStateFault(_inner) => Some(_inner),
            EnableSnapshotCopyErrorKind::InvalidRetentionPeriodFault(_inner) => Some(_inner),
            EnableSnapshotCopyErrorKind::LimitExceededFault(_inner) => Some(_inner),
            EnableSnapshotCopyErrorKind::SnapshotCopyAlreadyEnabledFault(_inner) => Some(_inner),
            EnableSnapshotCopyErrorKind::SnapshotCopyGrantNotFoundFault(_inner) => Some(_inner),
            EnableSnapshotCopyErrorKind::UnauthorizedOperation(_inner) => Some(_inner),
            EnableSnapshotCopyErrorKind::UnknownSnapshotCopyRegionFault(_inner) => Some(_inner),
            EnableSnapshotCopyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetClusterCredentials` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetClusterCredentialsError {
    /// Kind of error that occurred.
    pub kind: GetClusterCredentialsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetClusterCredentials` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetClusterCredentialsErrorKind {
    /// <p>The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster.
    /// </p>
    ClusterNotFoundFault(crate::error::ClusterNotFoundFault),
    /// <p>The requested operation isn't supported.</p>
    UnsupportedOperationFault(crate::error::UnsupportedOperationFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetClusterCredentialsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetClusterCredentialsErrorKind::ClusterNotFoundFault(_inner) => _inner.fmt(f),
            GetClusterCredentialsErrorKind::UnsupportedOperationFault(_inner) => _inner.fmt(f),
            GetClusterCredentialsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetClusterCredentialsError {
    fn code(&self) -> Option<&str> {
        GetClusterCredentialsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetClusterCredentialsError {
    /// Creates a new `GetClusterCredentialsError`.
    pub fn new(kind: GetClusterCredentialsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetClusterCredentialsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetClusterCredentialsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetClusterCredentialsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetClusterCredentialsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetClusterCredentialsErrorKind::ClusterNotFoundFault`.
    pub fn is_cluster_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            GetClusterCredentialsErrorKind::ClusterNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `GetClusterCredentialsErrorKind::UnsupportedOperationFault`.
    pub fn is_unsupported_operation_fault(&self) -> bool {
        matches!(
            &self.kind,
            GetClusterCredentialsErrorKind::UnsupportedOperationFault(_)
        )
    }
}
impl std::error::Error for GetClusterCredentialsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetClusterCredentialsErrorKind::ClusterNotFoundFault(_inner) => Some(_inner),
            GetClusterCredentialsErrorKind::UnsupportedOperationFault(_inner) => Some(_inner),
            GetClusterCredentialsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetReservedNodeExchangeOfferings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetReservedNodeExchangeOfferingsError {
    /// Kind of error that occurred.
    pub kind: GetReservedNodeExchangeOfferingsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetReservedNodeExchangeOfferings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetReservedNodeExchangeOfferingsErrorKind {
    /// <p>Your request cannot be completed because a dependent internal service is
    /// temporarily unavailable. Wait 30 to 60 seconds and try again.</p>
    DependentServiceUnavailableFault(crate::error::DependentServiceUnavailableFault),
    /// <p>Indicates that the Reserved Node being exchanged is not in an active state.</p>
    InvalidReservedNodeStateFault(crate::error::InvalidReservedNodeStateFault),
    /// <p>Indicates that the reserved node has already been exchanged.</p>
    ReservedNodeAlreadyMigratedFault(crate::error::ReservedNodeAlreadyMigratedFault),
    /// <p>The specified reserved compute node not found.</p>
    ReservedNodeNotFoundFault(crate::error::ReservedNodeNotFoundFault),
    /// <p>Specified offering does not exist.</p>
    ReservedNodeOfferingNotFoundFault(crate::error::ReservedNodeOfferingNotFoundFault),
    /// <p>The requested operation isn't supported.</p>
    UnsupportedOperationFault(crate::error::UnsupportedOperationFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetReservedNodeExchangeOfferingsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetReservedNodeExchangeOfferingsErrorKind::DependentServiceUnavailableFault(_inner) => {
                _inner.fmt(f)
            }
            GetReservedNodeExchangeOfferingsErrorKind::InvalidReservedNodeStateFault(_inner) => {
                _inner.fmt(f)
            }
            GetReservedNodeExchangeOfferingsErrorKind::ReservedNodeAlreadyMigratedFault(_inner) => {
                _inner.fmt(f)
            }
            GetReservedNodeExchangeOfferingsErrorKind::ReservedNodeNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            GetReservedNodeExchangeOfferingsErrorKind::ReservedNodeOfferingNotFoundFault(
                _inner,
            ) => _inner.fmt(f),
            GetReservedNodeExchangeOfferingsErrorKind::UnsupportedOperationFault(_inner) => {
                _inner.fmt(f)
            }
            GetReservedNodeExchangeOfferingsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetReservedNodeExchangeOfferingsError {
    fn code(&self) -> Option<&str> {
        GetReservedNodeExchangeOfferingsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetReservedNodeExchangeOfferingsError {
    /// Creates a new `GetReservedNodeExchangeOfferingsError`.
    pub fn new(
        kind: GetReservedNodeExchangeOfferingsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetReservedNodeExchangeOfferingsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetReservedNodeExchangeOfferingsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetReservedNodeExchangeOfferingsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetReservedNodeExchangeOfferingsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetReservedNodeExchangeOfferingsErrorKind::DependentServiceUnavailableFault`.
    pub fn is_dependent_service_unavailable_fault(&self) -> bool {
        matches!(
            &self.kind,
            GetReservedNodeExchangeOfferingsErrorKind::DependentServiceUnavailableFault(_)
        )
    }
    /// Returns `true` if the error kind is `GetReservedNodeExchangeOfferingsErrorKind::InvalidReservedNodeStateFault`.
    pub fn is_invalid_reserved_node_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            GetReservedNodeExchangeOfferingsErrorKind::InvalidReservedNodeStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `GetReservedNodeExchangeOfferingsErrorKind::ReservedNodeAlreadyMigratedFault`.
    pub fn is_reserved_node_already_migrated_fault(&self) -> bool {
        matches!(
            &self.kind,
            GetReservedNodeExchangeOfferingsErrorKind::ReservedNodeAlreadyMigratedFault(_)
        )
    }
    /// Returns `true` if the error kind is `GetReservedNodeExchangeOfferingsErrorKind::ReservedNodeNotFoundFault`.
    pub fn is_reserved_node_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            GetReservedNodeExchangeOfferingsErrorKind::ReservedNodeNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `GetReservedNodeExchangeOfferingsErrorKind::ReservedNodeOfferingNotFoundFault`.
    pub fn is_reserved_node_offering_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            GetReservedNodeExchangeOfferingsErrorKind::ReservedNodeOfferingNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `GetReservedNodeExchangeOfferingsErrorKind::UnsupportedOperationFault`.
    pub fn is_unsupported_operation_fault(&self) -> bool {
        matches!(
            &self.kind,
            GetReservedNodeExchangeOfferingsErrorKind::UnsupportedOperationFault(_)
        )
    }
}
impl std::error::Error for GetReservedNodeExchangeOfferingsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetReservedNodeExchangeOfferingsErrorKind::DependentServiceUnavailableFault(_inner) => {
                Some(_inner)
            }
            GetReservedNodeExchangeOfferingsErrorKind::InvalidReservedNodeStateFault(_inner) => {
                Some(_inner)
            }
            GetReservedNodeExchangeOfferingsErrorKind::ReservedNodeAlreadyMigratedFault(_inner) => {
                Some(_inner)
            }
            GetReservedNodeExchangeOfferingsErrorKind::ReservedNodeNotFoundFault(_inner) => {
                Some(_inner)
            }
            GetReservedNodeExchangeOfferingsErrorKind::ReservedNodeOfferingNotFoundFault(
                _inner,
            ) => Some(_inner),
            GetReservedNodeExchangeOfferingsErrorKind::UnsupportedOperationFault(_inner) => {
                Some(_inner)
            }
            GetReservedNodeExchangeOfferingsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ModifyAquaConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ModifyAquaConfigurationError {
    /// Kind of error that occurred.
    pub kind: ModifyAquaConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ModifyAquaConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ModifyAquaConfigurationErrorKind {
    /// <p>The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster.
    /// </p>
    ClusterNotFoundFault(crate::error::ClusterNotFoundFault),
    /// <p>The specified cluster is not in the <code>available</code> state. </p>
    InvalidClusterStateFault(crate::error::InvalidClusterStateFault),
    /// <p>The requested operation isn't supported.</p>
    UnsupportedOperationFault(crate::error::UnsupportedOperationFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ModifyAquaConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ModifyAquaConfigurationErrorKind::ClusterNotFoundFault(_inner) => _inner.fmt(f),
            ModifyAquaConfigurationErrorKind::InvalidClusterStateFault(_inner) => _inner.fmt(f),
            ModifyAquaConfigurationErrorKind::UnsupportedOperationFault(_inner) => _inner.fmt(f),
            ModifyAquaConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ModifyAquaConfigurationError {
    fn code(&self) -> Option<&str> {
        ModifyAquaConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ModifyAquaConfigurationError {
    /// Creates a new `ModifyAquaConfigurationError`.
    pub fn new(kind: ModifyAquaConfigurationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ModifyAquaConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ModifyAquaConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ModifyAquaConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ModifyAquaConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ModifyAquaConfigurationErrorKind::ClusterNotFoundFault`.
    pub fn is_cluster_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyAquaConfigurationErrorKind::ClusterNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyAquaConfigurationErrorKind::InvalidClusterStateFault`.
    pub fn is_invalid_cluster_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyAquaConfigurationErrorKind::InvalidClusterStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyAquaConfigurationErrorKind::UnsupportedOperationFault`.
    pub fn is_unsupported_operation_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyAquaConfigurationErrorKind::UnsupportedOperationFault(_)
        )
    }
}
impl std::error::Error for ModifyAquaConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ModifyAquaConfigurationErrorKind::ClusterNotFoundFault(_inner) => Some(_inner),
            ModifyAquaConfigurationErrorKind::InvalidClusterStateFault(_inner) => Some(_inner),
            ModifyAquaConfigurationErrorKind::UnsupportedOperationFault(_inner) => Some(_inner),
            ModifyAquaConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ModifyAuthenticationProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ModifyAuthenticationProfileError {
    /// Kind of error that occurred.
    pub kind: ModifyAuthenticationProfileErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ModifyAuthenticationProfile` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ModifyAuthenticationProfileErrorKind {
    /// <p>The authentication profile can't be found.</p>
    AuthenticationProfileNotFoundFault(crate::error::AuthenticationProfileNotFoundFault),
    /// <p>The size or number of authentication profiles has exceeded the quota.
    /// The maximum length of the JSON string and maximum number of authentication profiles is determined by a quota for your account.</p>
    AuthenticationProfileQuotaExceededFault(crate::error::AuthenticationProfileQuotaExceededFault),
    /// <p>The authentication profile request is not valid. The profile name can't be null or empty.
    /// The authentication profile API operation must be available in the Amazon Web Services Region.</p>
    InvalidAuthenticationProfileRequestFault(
        crate::error::InvalidAuthenticationProfileRequestFault,
    ),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ModifyAuthenticationProfileError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ModifyAuthenticationProfileErrorKind::AuthenticationProfileNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            ModifyAuthenticationProfileErrorKind::AuthenticationProfileQuotaExceededFault(
                _inner,
            ) => _inner.fmt(f),
            ModifyAuthenticationProfileErrorKind::InvalidAuthenticationProfileRequestFault(
                _inner,
            ) => _inner.fmt(f),
            ModifyAuthenticationProfileErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ModifyAuthenticationProfileError {
    fn code(&self) -> Option<&str> {
        ModifyAuthenticationProfileError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ModifyAuthenticationProfileError {
    /// Creates a new `ModifyAuthenticationProfileError`.
    pub fn new(kind: ModifyAuthenticationProfileErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ModifyAuthenticationProfileError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ModifyAuthenticationProfileErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ModifyAuthenticationProfileError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ModifyAuthenticationProfileErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ModifyAuthenticationProfileErrorKind::AuthenticationProfileNotFoundFault`.
    pub fn is_authentication_profile_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyAuthenticationProfileErrorKind::AuthenticationProfileNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyAuthenticationProfileErrorKind::AuthenticationProfileQuotaExceededFault`.
    pub fn is_authentication_profile_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyAuthenticationProfileErrorKind::AuthenticationProfileQuotaExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyAuthenticationProfileErrorKind::InvalidAuthenticationProfileRequestFault`.
    pub fn is_invalid_authentication_profile_request_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyAuthenticationProfileErrorKind::InvalidAuthenticationProfileRequestFault(_)
        )
    }
}
impl std::error::Error for ModifyAuthenticationProfileError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ModifyAuthenticationProfileErrorKind::AuthenticationProfileNotFoundFault(_inner) => {
                Some(_inner)
            }
            ModifyAuthenticationProfileErrorKind::AuthenticationProfileQuotaExceededFault(
                _inner,
            ) => Some(_inner),
            ModifyAuthenticationProfileErrorKind::InvalidAuthenticationProfileRequestFault(
                _inner,
            ) => Some(_inner),
            ModifyAuthenticationProfileErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ModifyCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ModifyClusterError {
    /// Kind of error that occurred.
    pub kind: ModifyClusterErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ModifyCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ModifyClusterErrorKind {
    /// <p>The account already has a cluster with the given identifier.</p>
    ClusterAlreadyExistsFault(crate::error::ClusterAlreadyExistsFault),
    /// <p>The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster.
    /// </p>
    ClusterNotFoundFault(crate::error::ClusterNotFoundFault),
    /// <p>The parameter group name does not refer to an existing parameter group.</p>
    ClusterParameterGroupNotFoundFault(crate::error::ClusterParameterGroupNotFoundFault),
    /// <p>The cluster security group name does not refer to an existing cluster security
    /// group.</p>
    ClusterSecurityGroupNotFoundFault(crate::error::ClusterSecurityGroupNotFoundFault),
    /// <p>The request cannot be completed because a dependent service is throttling requests
    /// made by Amazon Redshift on your behalf. Wait and retry the request.</p>
    DependentServiceRequestThrottlingFault(crate::error::DependentServiceRequestThrottlingFault),
    /// <p>There is no Amazon Redshift HSM client certificate with the specified
    /// identifier.</p>
    HsmClientCertificateNotFoundFault(crate::error::HsmClientCertificateNotFoundFault),
    /// <p>There is no Amazon Redshift HSM configuration with the specified identifier.</p>
    HsmConfigurationNotFoundFault(crate::error::HsmConfigurationNotFoundFault),
    /// <p>The number of nodes specified exceeds the allotted capacity of the
    /// cluster.</p>
    InsufficientClusterCapacityFault(crate::error::InsufficientClusterCapacityFault),
    /// <p>The state of the cluster security group is not <code>available</code>. </p>
    InvalidClusterSecurityGroupStateFault(crate::error::InvalidClusterSecurityGroupStateFault),
    /// <p>The specified cluster is not in the <code>available</code> state. </p>
    InvalidClusterStateFault(crate::error::InvalidClusterStateFault),
    /// <p>The provided cluster track name is not valid.</p>
    InvalidClusterTrackFault(crate::error::InvalidClusterTrackFault),
    /// <p>The Elastic IP (EIP) is invalid or cannot be found.</p>
    InvalidElasticIpFault(crate::error::InvalidElasticIpFault),
    /// <p>The retention period specified is either in the past or is not a valid value.</p>
    /// <p>The value must be either -1 or an integer between 1 and 3,653.</p>
    InvalidRetentionPeriodFault(crate::error::InvalidRetentionPeriodFault),
    /// <p>The encryption key has exceeded its grant limit in Amazon Web Services KMS.</p>
    LimitExceededFault(crate::error::LimitExceededFault),
    /// <p>The operation would exceed the number of nodes allowed for a cluster.</p>
    NumberOfNodesPerClusterLimitExceededFault(
        crate::error::NumberOfNodesPerClusterLimitExceededFault,
    ),
    /// <p>The operation would exceed the number of nodes allotted to the account.
    ///
    /// For information about increasing your quota, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon Redshift</a>
    /// in the <i>Amazon Redshift Cluster Management Guide</i>.
    /// </p>
    NumberOfNodesQuotaExceededFault(crate::error::NumberOfNodesQuotaExceededFault),
    /// <p>The number of tables in the cluster exceeds the limit for the requested new cluster
    /// node type. </p>
    TableLimitExceededFault(crate::error::TableLimitExceededFault),
    /// <p>Your account is not authorized to perform the requested operation.</p>
    UnauthorizedOperation(crate::error::UnauthorizedOperation),
    /// <p>A request option was specified that is not supported.</p>
    UnsupportedOptionFault(crate::error::UnsupportedOptionFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ModifyClusterError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ModifyClusterErrorKind::ClusterAlreadyExistsFault(_inner) => _inner.fmt(f),
            ModifyClusterErrorKind::ClusterNotFoundFault(_inner) => _inner.fmt(f),
            ModifyClusterErrorKind::ClusterParameterGroupNotFoundFault(_inner) => _inner.fmt(f),
            ModifyClusterErrorKind::ClusterSecurityGroupNotFoundFault(_inner) => _inner.fmt(f),
            ModifyClusterErrorKind::DependentServiceRequestThrottlingFault(_inner) => _inner.fmt(f),
            ModifyClusterErrorKind::HsmClientCertificateNotFoundFault(_inner) => _inner.fmt(f),
            ModifyClusterErrorKind::HsmConfigurationNotFoundFault(_inner) => _inner.fmt(f),
            ModifyClusterErrorKind::InsufficientClusterCapacityFault(_inner) => _inner.fmt(f),
            ModifyClusterErrorKind::InvalidClusterSecurityGroupStateFault(_inner) => _inner.fmt(f),
            ModifyClusterErrorKind::InvalidClusterStateFault(_inner) => _inner.fmt(f),
            ModifyClusterErrorKind::InvalidClusterTrackFault(_inner) => _inner.fmt(f),
            ModifyClusterErrorKind::InvalidElasticIpFault(_inner) => _inner.fmt(f),
            ModifyClusterErrorKind::InvalidRetentionPeriodFault(_inner) => _inner.fmt(f),
            ModifyClusterErrorKind::LimitExceededFault(_inner) => _inner.fmt(f),
            ModifyClusterErrorKind::NumberOfNodesPerClusterLimitExceededFault(_inner) => {
                _inner.fmt(f)
            }
            ModifyClusterErrorKind::NumberOfNodesQuotaExceededFault(_inner) => _inner.fmt(f),
            ModifyClusterErrorKind::TableLimitExceededFault(_inner) => _inner.fmt(f),
            ModifyClusterErrorKind::UnauthorizedOperation(_inner) => _inner.fmt(f),
            ModifyClusterErrorKind::UnsupportedOptionFault(_inner) => _inner.fmt(f),
            ModifyClusterErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ModifyClusterError {
    fn code(&self) -> Option<&str> {
        ModifyClusterError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ModifyClusterError {
    /// Creates a new `ModifyClusterError`.
    pub fn new(kind: ModifyClusterErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ModifyClusterError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ModifyClusterErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ModifyClusterError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ModifyClusterErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ModifyClusterErrorKind::ClusterAlreadyExistsFault`.
    pub fn is_cluster_already_exists_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyClusterErrorKind::ClusterAlreadyExistsFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyClusterErrorKind::ClusterNotFoundFault`.
    pub fn is_cluster_not_found_fault(&self) -> bool {
        matches!(&self.kind, ModifyClusterErrorKind::ClusterNotFoundFault(_))
    }
    /// Returns `true` if the error kind is `ModifyClusterErrorKind::ClusterParameterGroupNotFoundFault`.
    pub fn is_cluster_parameter_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyClusterErrorKind::ClusterParameterGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyClusterErrorKind::ClusterSecurityGroupNotFoundFault`.
    pub fn is_cluster_security_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyClusterErrorKind::ClusterSecurityGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyClusterErrorKind::DependentServiceRequestThrottlingFault`.
    pub fn is_dependent_service_request_throttling_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyClusterErrorKind::DependentServiceRequestThrottlingFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyClusterErrorKind::HsmClientCertificateNotFoundFault`.
    pub fn is_hsm_client_certificate_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyClusterErrorKind::HsmClientCertificateNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyClusterErrorKind::HsmConfigurationNotFoundFault`.
    pub fn is_hsm_configuration_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyClusterErrorKind::HsmConfigurationNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyClusterErrorKind::InsufficientClusterCapacityFault`.
    pub fn is_insufficient_cluster_capacity_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyClusterErrorKind::InsufficientClusterCapacityFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyClusterErrorKind::InvalidClusterSecurityGroupStateFault`.
    pub fn is_invalid_cluster_security_group_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyClusterErrorKind::InvalidClusterSecurityGroupStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyClusterErrorKind::InvalidClusterStateFault`.
    pub fn is_invalid_cluster_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyClusterErrorKind::InvalidClusterStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyClusterErrorKind::InvalidClusterTrackFault`.
    pub fn is_invalid_cluster_track_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyClusterErrorKind::InvalidClusterTrackFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyClusterErrorKind::InvalidElasticIpFault`.
    pub fn is_invalid_elastic_ip_fault(&self) -> bool {
        matches!(&self.kind, ModifyClusterErrorKind::InvalidElasticIpFault(_))
    }
    /// Returns `true` if the error kind is `ModifyClusterErrorKind::InvalidRetentionPeriodFault`.
    pub fn is_invalid_retention_period_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyClusterErrorKind::InvalidRetentionPeriodFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyClusterErrorKind::LimitExceededFault`.
    pub fn is_limit_exceeded_fault(&self) -> bool {
        matches!(&self.kind, ModifyClusterErrorKind::LimitExceededFault(_))
    }
    /// Returns `true` if the error kind is `ModifyClusterErrorKind::NumberOfNodesPerClusterLimitExceededFault`.
    pub fn is_number_of_nodes_per_cluster_limit_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyClusterErrorKind::NumberOfNodesPerClusterLimitExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyClusterErrorKind::NumberOfNodesQuotaExceededFault`.
    pub fn is_number_of_nodes_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyClusterErrorKind::NumberOfNodesQuotaExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyClusterErrorKind::TableLimitExceededFault`.
    pub fn is_table_limit_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyClusterErrorKind::TableLimitExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyClusterErrorKind::UnauthorizedOperation`.
    pub fn is_unauthorized_operation(&self) -> bool {
        matches!(&self.kind, ModifyClusterErrorKind::UnauthorizedOperation(_))
    }
    /// Returns `true` if the error kind is `ModifyClusterErrorKind::UnsupportedOptionFault`.
    pub fn is_unsupported_option_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyClusterErrorKind::UnsupportedOptionFault(_)
        )
    }
}
impl std::error::Error for ModifyClusterError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ModifyClusterErrorKind::ClusterAlreadyExistsFault(_inner) => Some(_inner),
            ModifyClusterErrorKind::ClusterNotFoundFault(_inner) => Some(_inner),
            ModifyClusterErrorKind::ClusterParameterGroupNotFoundFault(_inner) => Some(_inner),
            ModifyClusterErrorKind::ClusterSecurityGroupNotFoundFault(_inner) => Some(_inner),
            ModifyClusterErrorKind::DependentServiceRequestThrottlingFault(_inner) => Some(_inner),
            ModifyClusterErrorKind::HsmClientCertificateNotFoundFault(_inner) => Some(_inner),
            ModifyClusterErrorKind::HsmConfigurationNotFoundFault(_inner) => Some(_inner),
            ModifyClusterErrorKind::InsufficientClusterCapacityFault(_inner) => Some(_inner),
            ModifyClusterErrorKind::InvalidClusterSecurityGroupStateFault(_inner) => Some(_inner),
            ModifyClusterErrorKind::InvalidClusterStateFault(_inner) => Some(_inner),
            ModifyClusterErrorKind::InvalidClusterTrackFault(_inner) => Some(_inner),
            ModifyClusterErrorKind::InvalidElasticIpFault(_inner) => Some(_inner),
            ModifyClusterErrorKind::InvalidRetentionPeriodFault(_inner) => Some(_inner),
            ModifyClusterErrorKind::LimitExceededFault(_inner) => Some(_inner),
            ModifyClusterErrorKind::NumberOfNodesPerClusterLimitExceededFault(_inner) => {
                Some(_inner)
            }
            ModifyClusterErrorKind::NumberOfNodesQuotaExceededFault(_inner) => Some(_inner),
            ModifyClusterErrorKind::TableLimitExceededFault(_inner) => Some(_inner),
            ModifyClusterErrorKind::UnauthorizedOperation(_inner) => Some(_inner),
            ModifyClusterErrorKind::UnsupportedOptionFault(_inner) => Some(_inner),
            ModifyClusterErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ModifyClusterDbRevision` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ModifyClusterDbRevisionError {
    /// Kind of error that occurred.
    pub kind: ModifyClusterDbRevisionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ModifyClusterDbRevision` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ModifyClusterDbRevisionErrorKind {
    /// <p>The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster.
    /// </p>
    ClusterNotFoundFault(crate::error::ClusterNotFoundFault),
    /// <p>Cluster is already on the latest database revision.</p>
    ClusterOnLatestRevisionFault(crate::error::ClusterOnLatestRevisionFault),
    /// <p>The specified cluster is not in the <code>available</code> state. </p>
    InvalidClusterStateFault(crate::error::InvalidClusterStateFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ModifyClusterDbRevisionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ModifyClusterDbRevisionErrorKind::ClusterNotFoundFault(_inner) => _inner.fmt(f),
            ModifyClusterDbRevisionErrorKind::ClusterOnLatestRevisionFault(_inner) => _inner.fmt(f),
            ModifyClusterDbRevisionErrorKind::InvalidClusterStateFault(_inner) => _inner.fmt(f),
            ModifyClusterDbRevisionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ModifyClusterDbRevisionError {
    fn code(&self) -> Option<&str> {
        ModifyClusterDbRevisionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ModifyClusterDbRevisionError {
    /// Creates a new `ModifyClusterDbRevisionError`.
    pub fn new(kind: ModifyClusterDbRevisionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ModifyClusterDbRevisionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ModifyClusterDbRevisionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ModifyClusterDbRevisionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ModifyClusterDbRevisionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ModifyClusterDbRevisionErrorKind::ClusterNotFoundFault`.
    pub fn is_cluster_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyClusterDbRevisionErrorKind::ClusterNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyClusterDbRevisionErrorKind::ClusterOnLatestRevisionFault`.
    pub fn is_cluster_on_latest_revision_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyClusterDbRevisionErrorKind::ClusterOnLatestRevisionFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyClusterDbRevisionErrorKind::InvalidClusterStateFault`.
    pub fn is_invalid_cluster_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyClusterDbRevisionErrorKind::InvalidClusterStateFault(_)
        )
    }
}
impl std::error::Error for ModifyClusterDbRevisionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ModifyClusterDbRevisionErrorKind::ClusterNotFoundFault(_inner) => Some(_inner),
            ModifyClusterDbRevisionErrorKind::ClusterOnLatestRevisionFault(_inner) => Some(_inner),
            ModifyClusterDbRevisionErrorKind::InvalidClusterStateFault(_inner) => Some(_inner),
            ModifyClusterDbRevisionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ModifyClusterIamRoles` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ModifyClusterIamRolesError {
    /// Kind of error that occurred.
    pub kind: ModifyClusterIamRolesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ModifyClusterIamRoles` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ModifyClusterIamRolesErrorKind {
    /// <p>The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster.
    /// </p>
    ClusterNotFoundFault(crate::error::ClusterNotFoundFault),
    /// <p>The specified cluster is not in the <code>available</code> state. </p>
    InvalidClusterStateFault(crate::error::InvalidClusterStateFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ModifyClusterIamRolesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ModifyClusterIamRolesErrorKind::ClusterNotFoundFault(_inner) => _inner.fmt(f),
            ModifyClusterIamRolesErrorKind::InvalidClusterStateFault(_inner) => _inner.fmt(f),
            ModifyClusterIamRolesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ModifyClusterIamRolesError {
    fn code(&self) -> Option<&str> {
        ModifyClusterIamRolesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ModifyClusterIamRolesError {
    /// Creates a new `ModifyClusterIamRolesError`.
    pub fn new(kind: ModifyClusterIamRolesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ModifyClusterIamRolesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ModifyClusterIamRolesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ModifyClusterIamRolesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ModifyClusterIamRolesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ModifyClusterIamRolesErrorKind::ClusterNotFoundFault`.
    pub fn is_cluster_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyClusterIamRolesErrorKind::ClusterNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyClusterIamRolesErrorKind::InvalidClusterStateFault`.
    pub fn is_invalid_cluster_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyClusterIamRolesErrorKind::InvalidClusterStateFault(_)
        )
    }
}
impl std::error::Error for ModifyClusterIamRolesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ModifyClusterIamRolesErrorKind::ClusterNotFoundFault(_inner) => Some(_inner),
            ModifyClusterIamRolesErrorKind::InvalidClusterStateFault(_inner) => Some(_inner),
            ModifyClusterIamRolesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ModifyClusterMaintenance` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ModifyClusterMaintenanceError {
    /// Kind of error that occurred.
    pub kind: ModifyClusterMaintenanceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ModifyClusterMaintenance` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ModifyClusterMaintenanceErrorKind {
    /// <p>The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster.
    /// </p>
    ClusterNotFoundFault(crate::error::ClusterNotFoundFault),
    /// <p>The specified cluster is not in the <code>available</code> state. </p>
    InvalidClusterStateFault(crate::error::InvalidClusterStateFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ModifyClusterMaintenanceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ModifyClusterMaintenanceErrorKind::ClusterNotFoundFault(_inner) => _inner.fmt(f),
            ModifyClusterMaintenanceErrorKind::InvalidClusterStateFault(_inner) => _inner.fmt(f),
            ModifyClusterMaintenanceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ModifyClusterMaintenanceError {
    fn code(&self) -> Option<&str> {
        ModifyClusterMaintenanceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ModifyClusterMaintenanceError {
    /// Creates a new `ModifyClusterMaintenanceError`.
    pub fn new(kind: ModifyClusterMaintenanceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ModifyClusterMaintenanceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ModifyClusterMaintenanceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ModifyClusterMaintenanceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ModifyClusterMaintenanceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ModifyClusterMaintenanceErrorKind::ClusterNotFoundFault`.
    pub fn is_cluster_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyClusterMaintenanceErrorKind::ClusterNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyClusterMaintenanceErrorKind::InvalidClusterStateFault`.
    pub fn is_invalid_cluster_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyClusterMaintenanceErrorKind::InvalidClusterStateFault(_)
        )
    }
}
impl std::error::Error for ModifyClusterMaintenanceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ModifyClusterMaintenanceErrorKind::ClusterNotFoundFault(_inner) => Some(_inner),
            ModifyClusterMaintenanceErrorKind::InvalidClusterStateFault(_inner) => Some(_inner),
            ModifyClusterMaintenanceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ModifyClusterParameterGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ModifyClusterParameterGroupError {
    /// Kind of error that occurred.
    pub kind: ModifyClusterParameterGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ModifyClusterParameterGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ModifyClusterParameterGroupErrorKind {
    /// <p>The parameter group name does not refer to an existing parameter group.</p>
    ClusterParameterGroupNotFoundFault(crate::error::ClusterParameterGroupNotFoundFault),
    /// <p>The cluster parameter group action can not be completed because another task is in
    /// progress that involves the parameter group. Wait a few moments and try the operation
    /// again.</p>
    InvalidClusterParameterGroupStateFault(crate::error::InvalidClusterParameterGroupStateFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ModifyClusterParameterGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ModifyClusterParameterGroupErrorKind::ClusterParameterGroupNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            ModifyClusterParameterGroupErrorKind::InvalidClusterParameterGroupStateFault(
                _inner,
            ) => _inner.fmt(f),
            ModifyClusterParameterGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ModifyClusterParameterGroupError {
    fn code(&self) -> Option<&str> {
        ModifyClusterParameterGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ModifyClusterParameterGroupError {
    /// Creates a new `ModifyClusterParameterGroupError`.
    pub fn new(kind: ModifyClusterParameterGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ModifyClusterParameterGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ModifyClusterParameterGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ModifyClusterParameterGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ModifyClusterParameterGroupErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ModifyClusterParameterGroupErrorKind::ClusterParameterGroupNotFoundFault`.
    pub fn is_cluster_parameter_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyClusterParameterGroupErrorKind::ClusterParameterGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyClusterParameterGroupErrorKind::InvalidClusterParameterGroupStateFault`.
    pub fn is_invalid_cluster_parameter_group_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyClusterParameterGroupErrorKind::InvalidClusterParameterGroupStateFault(_)
        )
    }
}
impl std::error::Error for ModifyClusterParameterGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ModifyClusterParameterGroupErrorKind::ClusterParameterGroupNotFoundFault(_inner) => {
                Some(_inner)
            }
            ModifyClusterParameterGroupErrorKind::InvalidClusterParameterGroupStateFault(
                _inner,
            ) => Some(_inner),
            ModifyClusterParameterGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ModifyClusterSnapshot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ModifyClusterSnapshotError {
    /// Kind of error that occurred.
    pub kind: ModifyClusterSnapshotErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ModifyClusterSnapshot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ModifyClusterSnapshotErrorKind {
    /// <p>The snapshot identifier does not refer to an existing cluster snapshot.</p>
    ClusterSnapshotNotFoundFault(crate::error::ClusterSnapshotNotFoundFault),
    /// <p>The specified cluster snapshot is not in the <code>available</code> state, or other
    /// accounts are authorized to access the snapshot. </p>
    InvalidClusterSnapshotStateFault(crate::error::InvalidClusterSnapshotStateFault),
    /// <p>The retention period specified is either in the past or is not a valid value.</p>
    /// <p>The value must be either -1 or an integer between 1 and 3,653.</p>
    InvalidRetentionPeriodFault(crate::error::InvalidRetentionPeriodFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ModifyClusterSnapshotError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ModifyClusterSnapshotErrorKind::ClusterSnapshotNotFoundFault(_inner) => _inner.fmt(f),
            ModifyClusterSnapshotErrorKind::InvalidClusterSnapshotStateFault(_inner) => {
                _inner.fmt(f)
            }
            ModifyClusterSnapshotErrorKind::InvalidRetentionPeriodFault(_inner) => _inner.fmt(f),
            ModifyClusterSnapshotErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ModifyClusterSnapshotError {
    fn code(&self) -> Option<&str> {
        ModifyClusterSnapshotError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ModifyClusterSnapshotError {
    /// Creates a new `ModifyClusterSnapshotError`.
    pub fn new(kind: ModifyClusterSnapshotErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ModifyClusterSnapshotError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ModifyClusterSnapshotErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ModifyClusterSnapshotError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ModifyClusterSnapshotErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ModifyClusterSnapshotErrorKind::ClusterSnapshotNotFoundFault`.
    pub fn is_cluster_snapshot_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyClusterSnapshotErrorKind::ClusterSnapshotNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyClusterSnapshotErrorKind::InvalidClusterSnapshotStateFault`.
    pub fn is_invalid_cluster_snapshot_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyClusterSnapshotErrorKind::InvalidClusterSnapshotStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyClusterSnapshotErrorKind::InvalidRetentionPeriodFault`.
    pub fn is_invalid_retention_period_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyClusterSnapshotErrorKind::InvalidRetentionPeriodFault(_)
        )
    }
}
impl std::error::Error for ModifyClusterSnapshotError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ModifyClusterSnapshotErrorKind::ClusterSnapshotNotFoundFault(_inner) => Some(_inner),
            ModifyClusterSnapshotErrorKind::InvalidClusterSnapshotStateFault(_inner) => {
                Some(_inner)
            }
            ModifyClusterSnapshotErrorKind::InvalidRetentionPeriodFault(_inner) => Some(_inner),
            ModifyClusterSnapshotErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ModifyClusterSnapshotSchedule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ModifyClusterSnapshotScheduleError {
    /// Kind of error that occurred.
    pub kind: ModifyClusterSnapshotScheduleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ModifyClusterSnapshotSchedule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ModifyClusterSnapshotScheduleErrorKind {
    /// <p>The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster.
    /// </p>
    ClusterNotFoundFault(crate::error::ClusterNotFoundFault),
    /// <p>The cluster snapshot schedule state is not valid.</p>
    InvalidClusterSnapshotScheduleStateFault(
        crate::error::InvalidClusterSnapshotScheduleStateFault,
    ),
    /// <p>We could not find the specified snapshot schedule. </p>
    SnapshotScheduleNotFoundFault(crate::error::SnapshotScheduleNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ModifyClusterSnapshotScheduleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ModifyClusterSnapshotScheduleErrorKind::ClusterNotFoundFault(_inner) => _inner.fmt(f),
            ModifyClusterSnapshotScheduleErrorKind::InvalidClusterSnapshotScheduleStateFault(
                _inner,
            ) => _inner.fmt(f),
            ModifyClusterSnapshotScheduleErrorKind::SnapshotScheduleNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            ModifyClusterSnapshotScheduleErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ModifyClusterSnapshotScheduleError {
    fn code(&self) -> Option<&str> {
        ModifyClusterSnapshotScheduleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ModifyClusterSnapshotScheduleError {
    /// Creates a new `ModifyClusterSnapshotScheduleError`.
    pub fn new(
        kind: ModifyClusterSnapshotScheduleErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ModifyClusterSnapshotScheduleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ModifyClusterSnapshotScheduleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ModifyClusterSnapshotScheduleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ModifyClusterSnapshotScheduleErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ModifyClusterSnapshotScheduleErrorKind::ClusterNotFoundFault`.
    pub fn is_cluster_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyClusterSnapshotScheduleErrorKind::ClusterNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyClusterSnapshotScheduleErrorKind::InvalidClusterSnapshotScheduleStateFault`.
    pub fn is_invalid_cluster_snapshot_schedule_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyClusterSnapshotScheduleErrorKind::InvalidClusterSnapshotScheduleStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyClusterSnapshotScheduleErrorKind::SnapshotScheduleNotFoundFault`.
    pub fn is_snapshot_schedule_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyClusterSnapshotScheduleErrorKind::SnapshotScheduleNotFoundFault(_)
        )
    }
}
impl std::error::Error for ModifyClusterSnapshotScheduleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ModifyClusterSnapshotScheduleErrorKind::ClusterNotFoundFault(_inner) => Some(_inner),
            ModifyClusterSnapshotScheduleErrorKind::InvalidClusterSnapshotScheduleStateFault(
                _inner,
            ) => Some(_inner),
            ModifyClusterSnapshotScheduleErrorKind::SnapshotScheduleNotFoundFault(_inner) => {
                Some(_inner)
            }
            ModifyClusterSnapshotScheduleErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ModifyClusterSubnetGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ModifyClusterSubnetGroupError {
    /// Kind of error that occurred.
    pub kind: ModifyClusterSubnetGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ModifyClusterSubnetGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ModifyClusterSubnetGroupErrorKind {
    /// <p>The cluster subnet group name does not refer to an existing cluster subnet
    /// group.</p>
    ClusterSubnetGroupNotFoundFault(crate::error::ClusterSubnetGroupNotFoundFault),
    /// <p>The request would result in user exceeding the allowed number of subnets in a
    /// cluster subnet groups.
    /// For information about increasing your quota, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon Redshift</a>
    /// in the <i>Amazon Redshift Cluster Management Guide</i>.
    /// </p>
    ClusterSubnetQuotaExceededFault(crate::error::ClusterSubnetQuotaExceededFault),
    /// <p>The request cannot be completed because a dependent service is throttling requests
    /// made by Amazon Redshift on your behalf. Wait and retry the request.</p>
    DependentServiceRequestThrottlingFault(crate::error::DependentServiceRequestThrottlingFault),
    /// <p>The requested subnet is not valid, or not all of the subnets are in the same
    /// VPC.</p>
    InvalidSubnet(crate::error::InvalidSubnet),
    /// <p>A specified subnet is already in use by another cluster.</p>
    SubnetAlreadyInUse(crate::error::SubnetAlreadyInUse),
    /// <p>Your account is not authorized to perform the requested operation.</p>
    UnauthorizedOperation(crate::error::UnauthorizedOperation),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ModifyClusterSubnetGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ModifyClusterSubnetGroupErrorKind::ClusterSubnetGroupNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            ModifyClusterSubnetGroupErrorKind::ClusterSubnetQuotaExceededFault(_inner) => {
                _inner.fmt(f)
            }
            ModifyClusterSubnetGroupErrorKind::DependentServiceRequestThrottlingFault(_inner) => {
                _inner.fmt(f)
            }
            ModifyClusterSubnetGroupErrorKind::InvalidSubnet(_inner) => _inner.fmt(f),
            ModifyClusterSubnetGroupErrorKind::SubnetAlreadyInUse(_inner) => _inner.fmt(f),
            ModifyClusterSubnetGroupErrorKind::UnauthorizedOperation(_inner) => _inner.fmt(f),
            ModifyClusterSubnetGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ModifyClusterSubnetGroupError {
    fn code(&self) -> Option<&str> {
        ModifyClusterSubnetGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ModifyClusterSubnetGroupError {
    /// Creates a new `ModifyClusterSubnetGroupError`.
    pub fn new(kind: ModifyClusterSubnetGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ModifyClusterSubnetGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ModifyClusterSubnetGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ModifyClusterSubnetGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ModifyClusterSubnetGroupErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ModifyClusterSubnetGroupErrorKind::ClusterSubnetGroupNotFoundFault`.
    pub fn is_cluster_subnet_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyClusterSubnetGroupErrorKind::ClusterSubnetGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyClusterSubnetGroupErrorKind::ClusterSubnetQuotaExceededFault`.
    pub fn is_cluster_subnet_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyClusterSubnetGroupErrorKind::ClusterSubnetQuotaExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyClusterSubnetGroupErrorKind::DependentServiceRequestThrottlingFault`.
    pub fn is_dependent_service_request_throttling_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyClusterSubnetGroupErrorKind::DependentServiceRequestThrottlingFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyClusterSubnetGroupErrorKind::InvalidSubnet`.
    pub fn is_invalid_subnet(&self) -> bool {
        matches!(
            &self.kind,
            ModifyClusterSubnetGroupErrorKind::InvalidSubnet(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyClusterSubnetGroupErrorKind::SubnetAlreadyInUse`.
    pub fn is_subnet_already_in_use(&self) -> bool {
        matches!(
            &self.kind,
            ModifyClusterSubnetGroupErrorKind::SubnetAlreadyInUse(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyClusterSubnetGroupErrorKind::UnauthorizedOperation`.
    pub fn is_unauthorized_operation(&self) -> bool {
        matches!(
            &self.kind,
            ModifyClusterSubnetGroupErrorKind::UnauthorizedOperation(_)
        )
    }
}
impl std::error::Error for ModifyClusterSubnetGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ModifyClusterSubnetGroupErrorKind::ClusterSubnetGroupNotFoundFault(_inner) => {
                Some(_inner)
            }
            ModifyClusterSubnetGroupErrorKind::ClusterSubnetQuotaExceededFault(_inner) => {
                Some(_inner)
            }
            ModifyClusterSubnetGroupErrorKind::DependentServiceRequestThrottlingFault(_inner) => {
                Some(_inner)
            }
            ModifyClusterSubnetGroupErrorKind::InvalidSubnet(_inner) => Some(_inner),
            ModifyClusterSubnetGroupErrorKind::SubnetAlreadyInUse(_inner) => Some(_inner),
            ModifyClusterSubnetGroupErrorKind::UnauthorizedOperation(_inner) => Some(_inner),
            ModifyClusterSubnetGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ModifyEndpointAccess` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ModifyEndpointAccessError {
    /// Kind of error that occurred.
    pub kind: ModifyEndpointAccessErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ModifyEndpointAccess` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ModifyEndpointAccessErrorKind {
    /// <p>The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster.
    /// </p>
    ClusterNotFoundFault(crate::error::ClusterNotFoundFault),
    /// <p>The endpoint name doesn't refer to an existing endpoint.</p>
    EndpointNotFoundFault(crate::error::EndpointNotFoundFault),
    /// <p>The state of the cluster security group is not <code>available</code>. </p>
    InvalidClusterSecurityGroupStateFault(crate::error::InvalidClusterSecurityGroupStateFault),
    /// <p>The specified cluster is not in the <code>available</code> state. </p>
    InvalidClusterStateFault(crate::error::InvalidClusterStateFault),
    /// <p>The status of the endpoint is not valid.</p>
    InvalidEndpointStateFault(crate::error::InvalidEndpointStateFault),
    /// <p>Your account is not authorized to perform the requested operation.</p>
    UnauthorizedOperation(crate::error::UnauthorizedOperation),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ModifyEndpointAccessError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ModifyEndpointAccessErrorKind::ClusterNotFoundFault(_inner) => _inner.fmt(f),
            ModifyEndpointAccessErrorKind::EndpointNotFoundFault(_inner) => _inner.fmt(f),
            ModifyEndpointAccessErrorKind::InvalidClusterSecurityGroupStateFault(_inner) => {
                _inner.fmt(f)
            }
            ModifyEndpointAccessErrorKind::InvalidClusterStateFault(_inner) => _inner.fmt(f),
            ModifyEndpointAccessErrorKind::InvalidEndpointStateFault(_inner) => _inner.fmt(f),
            ModifyEndpointAccessErrorKind::UnauthorizedOperation(_inner) => _inner.fmt(f),
            ModifyEndpointAccessErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ModifyEndpointAccessError {
    fn code(&self) -> Option<&str> {
        ModifyEndpointAccessError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ModifyEndpointAccessError {
    /// Creates a new `ModifyEndpointAccessError`.
    pub fn new(kind: ModifyEndpointAccessErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ModifyEndpointAccessError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ModifyEndpointAccessErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ModifyEndpointAccessError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ModifyEndpointAccessErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ModifyEndpointAccessErrorKind::ClusterNotFoundFault`.
    pub fn is_cluster_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyEndpointAccessErrorKind::ClusterNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyEndpointAccessErrorKind::EndpointNotFoundFault`.
    pub fn is_endpoint_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyEndpointAccessErrorKind::EndpointNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyEndpointAccessErrorKind::InvalidClusterSecurityGroupStateFault`.
    pub fn is_invalid_cluster_security_group_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyEndpointAccessErrorKind::InvalidClusterSecurityGroupStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyEndpointAccessErrorKind::InvalidClusterStateFault`.
    pub fn is_invalid_cluster_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyEndpointAccessErrorKind::InvalidClusterStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyEndpointAccessErrorKind::InvalidEndpointStateFault`.
    pub fn is_invalid_endpoint_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyEndpointAccessErrorKind::InvalidEndpointStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyEndpointAccessErrorKind::UnauthorizedOperation`.
    pub fn is_unauthorized_operation(&self) -> bool {
        matches!(
            &self.kind,
            ModifyEndpointAccessErrorKind::UnauthorizedOperation(_)
        )
    }
}
impl std::error::Error for ModifyEndpointAccessError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ModifyEndpointAccessErrorKind::ClusterNotFoundFault(_inner) => Some(_inner),
            ModifyEndpointAccessErrorKind::EndpointNotFoundFault(_inner) => Some(_inner),
            ModifyEndpointAccessErrorKind::InvalidClusterSecurityGroupStateFault(_inner) => {
                Some(_inner)
            }
            ModifyEndpointAccessErrorKind::InvalidClusterStateFault(_inner) => Some(_inner),
            ModifyEndpointAccessErrorKind::InvalidEndpointStateFault(_inner) => Some(_inner),
            ModifyEndpointAccessErrorKind::UnauthorizedOperation(_inner) => Some(_inner),
            ModifyEndpointAccessErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ModifyEventSubscription` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ModifyEventSubscriptionError {
    /// Kind of error that occurred.
    pub kind: ModifyEventSubscriptionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ModifyEventSubscription` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ModifyEventSubscriptionErrorKind {
    /// <p>The subscription request is invalid because it is a duplicate request. This
    /// subscription request is already in progress.</p>
    InvalidSubscriptionStateFault(crate::error::InvalidSubscriptionStateFault),
    /// <p>Amazon SNS has responded that there is a problem with the specified Amazon SNS
    /// topic.</p>
    SnsInvalidTopicFault(crate::error::SnsInvalidTopicFault),
    /// <p>You do not have permission to publish to the specified Amazon SNS topic.</p>
    SnsNoAuthorizationFault(crate::error::SnsNoAuthorizationFault),
    /// <p>An Amazon SNS topic with the specified Amazon Resource Name (ARN) does not
    /// exist.</p>
    SnsTopicArnNotFoundFault(crate::error::SnsTopicArnNotFoundFault),
    /// <p>The specified Amazon Redshift event source could not be found.</p>
    SourceNotFoundFault(crate::error::SourceNotFoundFault),
    /// <p>The value specified for the event category was not one of the allowed values, or it
    /// specified a category that does not apply to the specified source type. The allowed
    /// values are Configuration, Management, Monitoring, and Security.</p>
    SubscriptionCategoryNotFoundFault(crate::error::SubscriptionCategoryNotFoundFault),
    /// <p>An Amazon Redshift event with the specified event ID does not exist.</p>
    SubscriptionEventIdNotFoundFault(crate::error::SubscriptionEventIdNotFoundFault),
    /// <p>An Amazon Redshift event notification subscription with the specified name does not
    /// exist.</p>
    SubscriptionNotFoundFault(crate::error::SubscriptionNotFoundFault),
    /// <p>The value specified for the event severity was not one of the allowed values, or it
    /// specified a severity that does not apply to the specified source type. The allowed
    /// values are ERROR and INFO.</p>
    SubscriptionSeverityNotFoundFault(crate::error::SubscriptionSeverityNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ModifyEventSubscriptionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ModifyEventSubscriptionErrorKind::InvalidSubscriptionStateFault(_inner) => {
                _inner.fmt(f)
            }
            ModifyEventSubscriptionErrorKind::SnsInvalidTopicFault(_inner) => _inner.fmt(f),
            ModifyEventSubscriptionErrorKind::SnsNoAuthorizationFault(_inner) => _inner.fmt(f),
            ModifyEventSubscriptionErrorKind::SnsTopicArnNotFoundFault(_inner) => _inner.fmt(f),
            ModifyEventSubscriptionErrorKind::SourceNotFoundFault(_inner) => _inner.fmt(f),
            ModifyEventSubscriptionErrorKind::SubscriptionCategoryNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            ModifyEventSubscriptionErrorKind::SubscriptionEventIdNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            ModifyEventSubscriptionErrorKind::SubscriptionNotFoundFault(_inner) => _inner.fmt(f),
            ModifyEventSubscriptionErrorKind::SubscriptionSeverityNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            ModifyEventSubscriptionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ModifyEventSubscriptionError {
    fn code(&self) -> Option<&str> {
        ModifyEventSubscriptionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ModifyEventSubscriptionError {
    /// Creates a new `ModifyEventSubscriptionError`.
    pub fn new(kind: ModifyEventSubscriptionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ModifyEventSubscriptionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ModifyEventSubscriptionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ModifyEventSubscriptionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ModifyEventSubscriptionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ModifyEventSubscriptionErrorKind::InvalidSubscriptionStateFault`.
    pub fn is_invalid_subscription_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyEventSubscriptionErrorKind::InvalidSubscriptionStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyEventSubscriptionErrorKind::SnsInvalidTopicFault`.
    pub fn is_sns_invalid_topic_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyEventSubscriptionErrorKind::SnsInvalidTopicFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyEventSubscriptionErrorKind::SnsNoAuthorizationFault`.
    pub fn is_sns_no_authorization_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyEventSubscriptionErrorKind::SnsNoAuthorizationFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyEventSubscriptionErrorKind::SnsTopicArnNotFoundFault`.
    pub fn is_sns_topic_arn_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyEventSubscriptionErrorKind::SnsTopicArnNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyEventSubscriptionErrorKind::SourceNotFoundFault`.
    pub fn is_source_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyEventSubscriptionErrorKind::SourceNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyEventSubscriptionErrorKind::SubscriptionCategoryNotFoundFault`.
    pub fn is_subscription_category_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyEventSubscriptionErrorKind::SubscriptionCategoryNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyEventSubscriptionErrorKind::SubscriptionEventIdNotFoundFault`.
    pub fn is_subscription_event_id_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyEventSubscriptionErrorKind::SubscriptionEventIdNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyEventSubscriptionErrorKind::SubscriptionNotFoundFault`.
    pub fn is_subscription_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyEventSubscriptionErrorKind::SubscriptionNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyEventSubscriptionErrorKind::SubscriptionSeverityNotFoundFault`.
    pub fn is_subscription_severity_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyEventSubscriptionErrorKind::SubscriptionSeverityNotFoundFault(_)
        )
    }
}
impl std::error::Error for ModifyEventSubscriptionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ModifyEventSubscriptionErrorKind::InvalidSubscriptionStateFault(_inner) => Some(_inner),
            ModifyEventSubscriptionErrorKind::SnsInvalidTopicFault(_inner) => Some(_inner),
            ModifyEventSubscriptionErrorKind::SnsNoAuthorizationFault(_inner) => Some(_inner),
            ModifyEventSubscriptionErrorKind::SnsTopicArnNotFoundFault(_inner) => Some(_inner),
            ModifyEventSubscriptionErrorKind::SourceNotFoundFault(_inner) => Some(_inner),
            ModifyEventSubscriptionErrorKind::SubscriptionCategoryNotFoundFault(_inner) => {
                Some(_inner)
            }
            ModifyEventSubscriptionErrorKind::SubscriptionEventIdNotFoundFault(_inner) => {
                Some(_inner)
            }
            ModifyEventSubscriptionErrorKind::SubscriptionNotFoundFault(_inner) => Some(_inner),
            ModifyEventSubscriptionErrorKind::SubscriptionSeverityNotFoundFault(_inner) => {
                Some(_inner)
            }
            ModifyEventSubscriptionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ModifyScheduledAction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ModifyScheduledActionError {
    /// Kind of error that occurred.
    pub kind: ModifyScheduledActionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ModifyScheduledAction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ModifyScheduledActionErrorKind {
    /// <p>The scheduled action is not valid. </p>
    InvalidScheduledActionFault(crate::error::InvalidScheduledActionFault),
    /// <p>The schedule you submitted isn't valid.</p>
    InvalidScheduleFault(crate::error::InvalidScheduleFault),
    /// <p>The scheduled action cannot be found. </p>
    ScheduledActionNotFoundFault(crate::error::ScheduledActionNotFoundFault),
    /// <p>The action type specified for a scheduled action is not supported. </p>
    ScheduledActionTypeUnsupportedFault(crate::error::ScheduledActionTypeUnsupportedFault),
    /// <p>Your account is not authorized to perform the requested operation.</p>
    UnauthorizedOperation(crate::error::UnauthorizedOperation),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ModifyScheduledActionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ModifyScheduledActionErrorKind::InvalidScheduledActionFault(_inner) => _inner.fmt(f),
            ModifyScheduledActionErrorKind::InvalidScheduleFault(_inner) => _inner.fmt(f),
            ModifyScheduledActionErrorKind::ScheduledActionNotFoundFault(_inner) => _inner.fmt(f),
            ModifyScheduledActionErrorKind::ScheduledActionTypeUnsupportedFault(_inner) => {
                _inner.fmt(f)
            }
            ModifyScheduledActionErrorKind::UnauthorizedOperation(_inner) => _inner.fmt(f),
            ModifyScheduledActionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ModifyScheduledActionError {
    fn code(&self) -> Option<&str> {
        ModifyScheduledActionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ModifyScheduledActionError {
    /// Creates a new `ModifyScheduledActionError`.
    pub fn new(kind: ModifyScheduledActionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ModifyScheduledActionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ModifyScheduledActionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ModifyScheduledActionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ModifyScheduledActionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ModifyScheduledActionErrorKind::InvalidScheduledActionFault`.
    pub fn is_invalid_scheduled_action_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyScheduledActionErrorKind::InvalidScheduledActionFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyScheduledActionErrorKind::InvalidScheduleFault`.
    pub fn is_invalid_schedule_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyScheduledActionErrorKind::InvalidScheduleFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyScheduledActionErrorKind::ScheduledActionNotFoundFault`.
    pub fn is_scheduled_action_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyScheduledActionErrorKind::ScheduledActionNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyScheduledActionErrorKind::ScheduledActionTypeUnsupportedFault`.
    pub fn is_scheduled_action_type_unsupported_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyScheduledActionErrorKind::ScheduledActionTypeUnsupportedFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyScheduledActionErrorKind::UnauthorizedOperation`.
    pub fn is_unauthorized_operation(&self) -> bool {
        matches!(
            &self.kind,
            ModifyScheduledActionErrorKind::UnauthorizedOperation(_)
        )
    }
}
impl std::error::Error for ModifyScheduledActionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ModifyScheduledActionErrorKind::InvalidScheduledActionFault(_inner) => Some(_inner),
            ModifyScheduledActionErrorKind::InvalidScheduleFault(_inner) => Some(_inner),
            ModifyScheduledActionErrorKind::ScheduledActionNotFoundFault(_inner) => Some(_inner),
            ModifyScheduledActionErrorKind::ScheduledActionTypeUnsupportedFault(_inner) => {
                Some(_inner)
            }
            ModifyScheduledActionErrorKind::UnauthorizedOperation(_inner) => Some(_inner),
            ModifyScheduledActionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ModifySnapshotCopyRetentionPeriod` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ModifySnapshotCopyRetentionPeriodError {
    /// Kind of error that occurred.
    pub kind: ModifySnapshotCopyRetentionPeriodErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ModifySnapshotCopyRetentionPeriod` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ModifySnapshotCopyRetentionPeriodErrorKind {
    /// <p>The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster.
    /// </p>
    ClusterNotFoundFault(crate::error::ClusterNotFoundFault),
    /// <p>The specified cluster is not in the <code>available</code> state. </p>
    InvalidClusterStateFault(crate::error::InvalidClusterStateFault),
    /// <p>The retention period specified is either in the past or is not a valid value.</p>
    /// <p>The value must be either -1 or an integer between 1 and 3,653.</p>
    InvalidRetentionPeriodFault(crate::error::InvalidRetentionPeriodFault),
    /// <p>Cross-region snapshot copy was temporarily disabled. Try your request
    /// again.</p>
    SnapshotCopyDisabledFault(crate::error::SnapshotCopyDisabledFault),
    /// <p>Your account is not authorized to perform the requested operation.</p>
    UnauthorizedOperation(crate::error::UnauthorizedOperation),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ModifySnapshotCopyRetentionPeriodError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ModifySnapshotCopyRetentionPeriodErrorKind::ClusterNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            ModifySnapshotCopyRetentionPeriodErrorKind::InvalidClusterStateFault(_inner) => {
                _inner.fmt(f)
            }
            ModifySnapshotCopyRetentionPeriodErrorKind::InvalidRetentionPeriodFault(_inner) => {
                _inner.fmt(f)
            }
            ModifySnapshotCopyRetentionPeriodErrorKind::SnapshotCopyDisabledFault(_inner) => {
                _inner.fmt(f)
            }
            ModifySnapshotCopyRetentionPeriodErrorKind::UnauthorizedOperation(_inner) => {
                _inner.fmt(f)
            }
            ModifySnapshotCopyRetentionPeriodErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ModifySnapshotCopyRetentionPeriodError {
    fn code(&self) -> Option<&str> {
        ModifySnapshotCopyRetentionPeriodError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ModifySnapshotCopyRetentionPeriodError {
    /// Creates a new `ModifySnapshotCopyRetentionPeriodError`.
    pub fn new(
        kind: ModifySnapshotCopyRetentionPeriodErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ModifySnapshotCopyRetentionPeriodError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ModifySnapshotCopyRetentionPeriodErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ModifySnapshotCopyRetentionPeriodError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ModifySnapshotCopyRetentionPeriodErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ModifySnapshotCopyRetentionPeriodErrorKind::ClusterNotFoundFault`.
    pub fn is_cluster_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifySnapshotCopyRetentionPeriodErrorKind::ClusterNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifySnapshotCopyRetentionPeriodErrorKind::InvalidClusterStateFault`.
    pub fn is_invalid_cluster_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifySnapshotCopyRetentionPeriodErrorKind::InvalidClusterStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifySnapshotCopyRetentionPeriodErrorKind::InvalidRetentionPeriodFault`.
    pub fn is_invalid_retention_period_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifySnapshotCopyRetentionPeriodErrorKind::InvalidRetentionPeriodFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifySnapshotCopyRetentionPeriodErrorKind::SnapshotCopyDisabledFault`.
    pub fn is_snapshot_copy_disabled_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifySnapshotCopyRetentionPeriodErrorKind::SnapshotCopyDisabledFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifySnapshotCopyRetentionPeriodErrorKind::UnauthorizedOperation`.
    pub fn is_unauthorized_operation(&self) -> bool {
        matches!(
            &self.kind,
            ModifySnapshotCopyRetentionPeriodErrorKind::UnauthorizedOperation(_)
        )
    }
}
impl std::error::Error for ModifySnapshotCopyRetentionPeriodError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ModifySnapshotCopyRetentionPeriodErrorKind::ClusterNotFoundFault(_inner) => {
                Some(_inner)
            }
            ModifySnapshotCopyRetentionPeriodErrorKind::InvalidClusterStateFault(_inner) => {
                Some(_inner)
            }
            ModifySnapshotCopyRetentionPeriodErrorKind::InvalidRetentionPeriodFault(_inner) => {
                Some(_inner)
            }
            ModifySnapshotCopyRetentionPeriodErrorKind::SnapshotCopyDisabledFault(_inner) => {
                Some(_inner)
            }
            ModifySnapshotCopyRetentionPeriodErrorKind::UnauthorizedOperation(_inner) => {
                Some(_inner)
            }
            ModifySnapshotCopyRetentionPeriodErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ModifySnapshotSchedule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ModifySnapshotScheduleError {
    /// Kind of error that occurred.
    pub kind: ModifySnapshotScheduleErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ModifySnapshotSchedule` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ModifySnapshotScheduleErrorKind {
    /// <p>The schedule you submitted isn't valid.</p>
    InvalidScheduleFault(crate::error::InvalidScheduleFault),
    /// <p>We could not find the specified snapshot schedule. </p>
    SnapshotScheduleNotFoundFault(crate::error::SnapshotScheduleNotFoundFault),
    /// <p>The specified snapshot schedule is already being updated.</p>
    SnapshotScheduleUpdateInProgressFault(crate::error::SnapshotScheduleUpdateInProgressFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ModifySnapshotScheduleError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ModifySnapshotScheduleErrorKind::InvalidScheduleFault(_inner) => _inner.fmt(f),
            ModifySnapshotScheduleErrorKind::SnapshotScheduleNotFoundFault(_inner) => _inner.fmt(f),
            ModifySnapshotScheduleErrorKind::SnapshotScheduleUpdateInProgressFault(_inner) => {
                _inner.fmt(f)
            }
            ModifySnapshotScheduleErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ModifySnapshotScheduleError {
    fn code(&self) -> Option<&str> {
        ModifySnapshotScheduleError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ModifySnapshotScheduleError {
    /// Creates a new `ModifySnapshotScheduleError`.
    pub fn new(kind: ModifySnapshotScheduleErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ModifySnapshotScheduleError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ModifySnapshotScheduleErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ModifySnapshotScheduleError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ModifySnapshotScheduleErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ModifySnapshotScheduleErrorKind::InvalidScheduleFault`.
    pub fn is_invalid_schedule_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifySnapshotScheduleErrorKind::InvalidScheduleFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifySnapshotScheduleErrorKind::SnapshotScheduleNotFoundFault`.
    pub fn is_snapshot_schedule_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifySnapshotScheduleErrorKind::SnapshotScheduleNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifySnapshotScheduleErrorKind::SnapshotScheduleUpdateInProgressFault`.
    pub fn is_snapshot_schedule_update_in_progress_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifySnapshotScheduleErrorKind::SnapshotScheduleUpdateInProgressFault(_)
        )
    }
}
impl std::error::Error for ModifySnapshotScheduleError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ModifySnapshotScheduleErrorKind::InvalidScheduleFault(_inner) => Some(_inner),
            ModifySnapshotScheduleErrorKind::SnapshotScheduleNotFoundFault(_inner) => Some(_inner),
            ModifySnapshotScheduleErrorKind::SnapshotScheduleUpdateInProgressFault(_inner) => {
                Some(_inner)
            }
            ModifySnapshotScheduleErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ModifyUsageLimit` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ModifyUsageLimitError {
    /// Kind of error that occurred.
    pub kind: ModifyUsageLimitErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ModifyUsageLimit` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ModifyUsageLimitErrorKind {
    /// <p>The usage limit is not valid.</p>
    InvalidUsageLimitFault(crate::error::InvalidUsageLimitFault),
    /// <p>The requested operation isn't supported.</p>
    UnsupportedOperationFault(crate::error::UnsupportedOperationFault),
    /// <p>The usage limit identifier can't be found.</p>
    UsageLimitNotFoundFault(crate::error::UsageLimitNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ModifyUsageLimitError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ModifyUsageLimitErrorKind::InvalidUsageLimitFault(_inner) => _inner.fmt(f),
            ModifyUsageLimitErrorKind::UnsupportedOperationFault(_inner) => _inner.fmt(f),
            ModifyUsageLimitErrorKind::UsageLimitNotFoundFault(_inner) => _inner.fmt(f),
            ModifyUsageLimitErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ModifyUsageLimitError {
    fn code(&self) -> Option<&str> {
        ModifyUsageLimitError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ModifyUsageLimitError {
    /// Creates a new `ModifyUsageLimitError`.
    pub fn new(kind: ModifyUsageLimitErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ModifyUsageLimitError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ModifyUsageLimitErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ModifyUsageLimitError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ModifyUsageLimitErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ModifyUsageLimitErrorKind::InvalidUsageLimitFault`.
    pub fn is_invalid_usage_limit_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyUsageLimitErrorKind::InvalidUsageLimitFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyUsageLimitErrorKind::UnsupportedOperationFault`.
    pub fn is_unsupported_operation_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyUsageLimitErrorKind::UnsupportedOperationFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyUsageLimitErrorKind::UsageLimitNotFoundFault`.
    pub fn is_usage_limit_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyUsageLimitErrorKind::UsageLimitNotFoundFault(_)
        )
    }
}
impl std::error::Error for ModifyUsageLimitError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ModifyUsageLimitErrorKind::InvalidUsageLimitFault(_inner) => Some(_inner),
            ModifyUsageLimitErrorKind::UnsupportedOperationFault(_inner) => Some(_inner),
            ModifyUsageLimitErrorKind::UsageLimitNotFoundFault(_inner) => Some(_inner),
            ModifyUsageLimitErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PauseCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PauseClusterError {
    /// Kind of error that occurred.
    pub kind: PauseClusterErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PauseCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PauseClusterErrorKind {
    /// <p>The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster.
    /// </p>
    ClusterNotFoundFault(crate::error::ClusterNotFoundFault),
    /// <p>The specified cluster is not in the <code>available</code> state. </p>
    InvalidClusterStateFault(crate::error::InvalidClusterStateFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PauseClusterError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PauseClusterErrorKind::ClusterNotFoundFault(_inner) => _inner.fmt(f),
            PauseClusterErrorKind::InvalidClusterStateFault(_inner) => _inner.fmt(f),
            PauseClusterErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PauseClusterError {
    fn code(&self) -> Option<&str> {
        PauseClusterError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PauseClusterError {
    /// Creates a new `PauseClusterError`.
    pub fn new(kind: PauseClusterErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PauseClusterError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PauseClusterErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PauseClusterError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PauseClusterErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PauseClusterErrorKind::ClusterNotFoundFault`.
    pub fn is_cluster_not_found_fault(&self) -> bool {
        matches!(&self.kind, PauseClusterErrorKind::ClusterNotFoundFault(_))
    }
    /// Returns `true` if the error kind is `PauseClusterErrorKind::InvalidClusterStateFault`.
    pub fn is_invalid_cluster_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            PauseClusterErrorKind::InvalidClusterStateFault(_)
        )
    }
}
impl std::error::Error for PauseClusterError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PauseClusterErrorKind::ClusterNotFoundFault(_inner) => Some(_inner),
            PauseClusterErrorKind::InvalidClusterStateFault(_inner) => Some(_inner),
            PauseClusterErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PurchaseReservedNodeOffering` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PurchaseReservedNodeOfferingError {
    /// Kind of error that occurred.
    pub kind: PurchaseReservedNodeOfferingErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PurchaseReservedNodeOffering` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PurchaseReservedNodeOfferingErrorKind {
    /// <p>User already has a reservation with the given identifier.</p>
    ReservedNodeAlreadyExistsFault(crate::error::ReservedNodeAlreadyExistsFault),
    /// <p>Specified offering does not exist.</p>
    ReservedNodeOfferingNotFoundFault(crate::error::ReservedNodeOfferingNotFoundFault),
    /// <p>Request would exceed the user's compute node quota.
    /// For information about increasing your quota, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon Redshift</a>
    /// in the <i>Amazon Redshift Cluster Management Guide</i>.
    /// </p>
    ReservedNodeQuotaExceededFault(crate::error::ReservedNodeQuotaExceededFault),
    /// <p>The requested operation isn't supported.</p>
    UnsupportedOperationFault(crate::error::UnsupportedOperationFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PurchaseReservedNodeOfferingError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PurchaseReservedNodeOfferingErrorKind::ReservedNodeAlreadyExistsFault(_inner) => {
                _inner.fmt(f)
            }
            PurchaseReservedNodeOfferingErrorKind::ReservedNodeOfferingNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            PurchaseReservedNodeOfferingErrorKind::ReservedNodeQuotaExceededFault(_inner) => {
                _inner.fmt(f)
            }
            PurchaseReservedNodeOfferingErrorKind::UnsupportedOperationFault(_inner) => {
                _inner.fmt(f)
            }
            PurchaseReservedNodeOfferingErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PurchaseReservedNodeOfferingError {
    fn code(&self) -> Option<&str> {
        PurchaseReservedNodeOfferingError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PurchaseReservedNodeOfferingError {
    /// Creates a new `PurchaseReservedNodeOfferingError`.
    pub fn new(kind: PurchaseReservedNodeOfferingErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PurchaseReservedNodeOfferingError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PurchaseReservedNodeOfferingErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PurchaseReservedNodeOfferingError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PurchaseReservedNodeOfferingErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PurchaseReservedNodeOfferingErrorKind::ReservedNodeAlreadyExistsFault`.
    pub fn is_reserved_node_already_exists_fault(&self) -> bool {
        matches!(
            &self.kind,
            PurchaseReservedNodeOfferingErrorKind::ReservedNodeAlreadyExistsFault(_)
        )
    }
    /// Returns `true` if the error kind is `PurchaseReservedNodeOfferingErrorKind::ReservedNodeOfferingNotFoundFault`.
    pub fn is_reserved_node_offering_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            PurchaseReservedNodeOfferingErrorKind::ReservedNodeOfferingNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `PurchaseReservedNodeOfferingErrorKind::ReservedNodeQuotaExceededFault`.
    pub fn is_reserved_node_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            PurchaseReservedNodeOfferingErrorKind::ReservedNodeQuotaExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `PurchaseReservedNodeOfferingErrorKind::UnsupportedOperationFault`.
    pub fn is_unsupported_operation_fault(&self) -> bool {
        matches!(
            &self.kind,
            PurchaseReservedNodeOfferingErrorKind::UnsupportedOperationFault(_)
        )
    }
}
impl std::error::Error for PurchaseReservedNodeOfferingError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PurchaseReservedNodeOfferingErrorKind::ReservedNodeAlreadyExistsFault(_inner) => {
                Some(_inner)
            }
            PurchaseReservedNodeOfferingErrorKind::ReservedNodeOfferingNotFoundFault(_inner) => {
                Some(_inner)
            }
            PurchaseReservedNodeOfferingErrorKind::ReservedNodeQuotaExceededFault(_inner) => {
                Some(_inner)
            }
            PurchaseReservedNodeOfferingErrorKind::UnsupportedOperationFault(_inner) => {
                Some(_inner)
            }
            PurchaseReservedNodeOfferingErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RebootCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RebootClusterError {
    /// Kind of error that occurred.
    pub kind: RebootClusterErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RebootCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RebootClusterErrorKind {
    /// <p>The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster.
    /// </p>
    ClusterNotFoundFault(crate::error::ClusterNotFoundFault),
    /// <p>The specified cluster is not in the <code>available</code> state. </p>
    InvalidClusterStateFault(crate::error::InvalidClusterStateFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RebootClusterError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RebootClusterErrorKind::ClusterNotFoundFault(_inner) => _inner.fmt(f),
            RebootClusterErrorKind::InvalidClusterStateFault(_inner) => _inner.fmt(f),
            RebootClusterErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RebootClusterError {
    fn code(&self) -> Option<&str> {
        RebootClusterError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RebootClusterError {
    /// Creates a new `RebootClusterError`.
    pub fn new(kind: RebootClusterErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RebootClusterError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RebootClusterErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RebootClusterError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RebootClusterErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RebootClusterErrorKind::ClusterNotFoundFault`.
    pub fn is_cluster_not_found_fault(&self) -> bool {
        matches!(&self.kind, RebootClusterErrorKind::ClusterNotFoundFault(_))
    }
    /// Returns `true` if the error kind is `RebootClusterErrorKind::InvalidClusterStateFault`.
    pub fn is_invalid_cluster_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            RebootClusterErrorKind::InvalidClusterStateFault(_)
        )
    }
}
impl std::error::Error for RebootClusterError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RebootClusterErrorKind::ClusterNotFoundFault(_inner) => Some(_inner),
            RebootClusterErrorKind::InvalidClusterStateFault(_inner) => Some(_inner),
            RebootClusterErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RejectDataShare` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RejectDataShareError {
    /// Kind of error that occurred.
    pub kind: RejectDataShareErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RejectDataShare` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RejectDataShareErrorKind {
    /// <p>There is an error with the datashare.</p>
    InvalidDataShareFault(crate::error::InvalidDataShareFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RejectDataShareError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RejectDataShareErrorKind::InvalidDataShareFault(_inner) => _inner.fmt(f),
            RejectDataShareErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RejectDataShareError {
    fn code(&self) -> Option<&str> {
        RejectDataShareError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RejectDataShareError {
    /// Creates a new `RejectDataShareError`.
    pub fn new(kind: RejectDataShareErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RejectDataShareError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RejectDataShareErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RejectDataShareError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RejectDataShareErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RejectDataShareErrorKind::InvalidDataShareFault`.
    pub fn is_invalid_data_share_fault(&self) -> bool {
        matches!(
            &self.kind,
            RejectDataShareErrorKind::InvalidDataShareFault(_)
        )
    }
}
impl std::error::Error for RejectDataShareError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RejectDataShareErrorKind::InvalidDataShareFault(_inner) => Some(_inner),
            RejectDataShareErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ResetClusterParameterGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ResetClusterParameterGroupError {
    /// Kind of error that occurred.
    pub kind: ResetClusterParameterGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ResetClusterParameterGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ResetClusterParameterGroupErrorKind {
    /// <p>The parameter group name does not refer to an existing parameter group.</p>
    ClusterParameterGroupNotFoundFault(crate::error::ClusterParameterGroupNotFoundFault),
    /// <p>The cluster parameter group action can not be completed because another task is in
    /// progress that involves the parameter group. Wait a few moments and try the operation
    /// again.</p>
    InvalidClusterParameterGroupStateFault(crate::error::InvalidClusterParameterGroupStateFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ResetClusterParameterGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ResetClusterParameterGroupErrorKind::ClusterParameterGroupNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            ResetClusterParameterGroupErrorKind::InvalidClusterParameterGroupStateFault(_inner) => {
                _inner.fmt(f)
            }
            ResetClusterParameterGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ResetClusterParameterGroupError {
    fn code(&self) -> Option<&str> {
        ResetClusterParameterGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ResetClusterParameterGroupError {
    /// Creates a new `ResetClusterParameterGroupError`.
    pub fn new(kind: ResetClusterParameterGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ResetClusterParameterGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ResetClusterParameterGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ResetClusterParameterGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ResetClusterParameterGroupErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ResetClusterParameterGroupErrorKind::ClusterParameterGroupNotFoundFault`.
    pub fn is_cluster_parameter_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            ResetClusterParameterGroupErrorKind::ClusterParameterGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `ResetClusterParameterGroupErrorKind::InvalidClusterParameterGroupStateFault`.
    pub fn is_invalid_cluster_parameter_group_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            ResetClusterParameterGroupErrorKind::InvalidClusterParameterGroupStateFault(_)
        )
    }
}
impl std::error::Error for ResetClusterParameterGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ResetClusterParameterGroupErrorKind::ClusterParameterGroupNotFoundFault(_inner) => {
                Some(_inner)
            }
            ResetClusterParameterGroupErrorKind::InvalidClusterParameterGroupStateFault(_inner) => {
                Some(_inner)
            }
            ResetClusterParameterGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ResizeCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ResizeClusterError {
    /// Kind of error that occurred.
    pub kind: ResizeClusterErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ResizeCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ResizeClusterErrorKind {
    /// <p>The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster.
    /// </p>
    ClusterNotFoundFault(crate::error::ClusterNotFoundFault),
    /// <p>The number of nodes specified exceeds the allotted capacity of the
    /// cluster.</p>
    InsufficientClusterCapacityFault(crate::error::InsufficientClusterCapacityFault),
    /// <p>The specified cluster is not in the <code>available</code> state. </p>
    InvalidClusterStateFault(crate::error::InvalidClusterStateFault),
    /// <p>The encryption key has exceeded its grant limit in Amazon Web Services KMS.</p>
    LimitExceededFault(crate::error::LimitExceededFault),
    /// <p>The operation would exceed the number of nodes allowed for a cluster.</p>
    NumberOfNodesPerClusterLimitExceededFault(
        crate::error::NumberOfNodesPerClusterLimitExceededFault,
    ),
    /// <p>The operation would exceed the number of nodes allotted to the account.
    ///
    /// For information about increasing your quota, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon Redshift</a>
    /// in the <i>Amazon Redshift Cluster Management Guide</i>.
    /// </p>
    NumberOfNodesQuotaExceededFault(crate::error::NumberOfNodesQuotaExceededFault),
    /// <p>Your account is not authorized to perform the requested operation.</p>
    UnauthorizedOperation(crate::error::UnauthorizedOperation),
    /// <p>The requested operation isn't supported.</p>
    UnsupportedOperationFault(crate::error::UnsupportedOperationFault),
    /// <p>A request option was specified that is not supported.</p>
    UnsupportedOptionFault(crate::error::UnsupportedOptionFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ResizeClusterError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ResizeClusterErrorKind::ClusterNotFoundFault(_inner) => _inner.fmt(f),
            ResizeClusterErrorKind::InsufficientClusterCapacityFault(_inner) => _inner.fmt(f),
            ResizeClusterErrorKind::InvalidClusterStateFault(_inner) => _inner.fmt(f),
            ResizeClusterErrorKind::LimitExceededFault(_inner) => _inner.fmt(f),
            ResizeClusterErrorKind::NumberOfNodesPerClusterLimitExceededFault(_inner) => {
                _inner.fmt(f)
            }
            ResizeClusterErrorKind::NumberOfNodesQuotaExceededFault(_inner) => _inner.fmt(f),
            ResizeClusterErrorKind::UnauthorizedOperation(_inner) => _inner.fmt(f),
            ResizeClusterErrorKind::UnsupportedOperationFault(_inner) => _inner.fmt(f),
            ResizeClusterErrorKind::UnsupportedOptionFault(_inner) => _inner.fmt(f),
            ResizeClusterErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ResizeClusterError {
    fn code(&self) -> Option<&str> {
        ResizeClusterError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ResizeClusterError {
    /// Creates a new `ResizeClusterError`.
    pub fn new(kind: ResizeClusterErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ResizeClusterError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ResizeClusterErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ResizeClusterError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ResizeClusterErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ResizeClusterErrorKind::ClusterNotFoundFault`.
    pub fn is_cluster_not_found_fault(&self) -> bool {
        matches!(&self.kind, ResizeClusterErrorKind::ClusterNotFoundFault(_))
    }
    /// Returns `true` if the error kind is `ResizeClusterErrorKind::InsufficientClusterCapacityFault`.
    pub fn is_insufficient_cluster_capacity_fault(&self) -> bool {
        matches!(
            &self.kind,
            ResizeClusterErrorKind::InsufficientClusterCapacityFault(_)
        )
    }
    /// Returns `true` if the error kind is `ResizeClusterErrorKind::InvalidClusterStateFault`.
    pub fn is_invalid_cluster_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            ResizeClusterErrorKind::InvalidClusterStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `ResizeClusterErrorKind::LimitExceededFault`.
    pub fn is_limit_exceeded_fault(&self) -> bool {
        matches!(&self.kind, ResizeClusterErrorKind::LimitExceededFault(_))
    }
    /// Returns `true` if the error kind is `ResizeClusterErrorKind::NumberOfNodesPerClusterLimitExceededFault`.
    pub fn is_number_of_nodes_per_cluster_limit_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            ResizeClusterErrorKind::NumberOfNodesPerClusterLimitExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `ResizeClusterErrorKind::NumberOfNodesQuotaExceededFault`.
    pub fn is_number_of_nodes_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            ResizeClusterErrorKind::NumberOfNodesQuotaExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `ResizeClusterErrorKind::UnauthorizedOperation`.
    pub fn is_unauthorized_operation(&self) -> bool {
        matches!(&self.kind, ResizeClusterErrorKind::UnauthorizedOperation(_))
    }
    /// Returns `true` if the error kind is `ResizeClusterErrorKind::UnsupportedOperationFault`.
    pub fn is_unsupported_operation_fault(&self) -> bool {
        matches!(
            &self.kind,
            ResizeClusterErrorKind::UnsupportedOperationFault(_)
        )
    }
    /// Returns `true` if the error kind is `ResizeClusterErrorKind::UnsupportedOptionFault`.
    pub fn is_unsupported_option_fault(&self) -> bool {
        matches!(
            &self.kind,
            ResizeClusterErrorKind::UnsupportedOptionFault(_)
        )
    }
}
impl std::error::Error for ResizeClusterError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ResizeClusterErrorKind::ClusterNotFoundFault(_inner) => Some(_inner),
            ResizeClusterErrorKind::InsufficientClusterCapacityFault(_inner) => Some(_inner),
            ResizeClusterErrorKind::InvalidClusterStateFault(_inner) => Some(_inner),
            ResizeClusterErrorKind::LimitExceededFault(_inner) => Some(_inner),
            ResizeClusterErrorKind::NumberOfNodesPerClusterLimitExceededFault(_inner) => {
                Some(_inner)
            }
            ResizeClusterErrorKind::NumberOfNodesQuotaExceededFault(_inner) => Some(_inner),
            ResizeClusterErrorKind::UnauthorizedOperation(_inner) => Some(_inner),
            ResizeClusterErrorKind::UnsupportedOperationFault(_inner) => Some(_inner),
            ResizeClusterErrorKind::UnsupportedOptionFault(_inner) => Some(_inner),
            ResizeClusterErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RestoreFromClusterSnapshot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RestoreFromClusterSnapshotError {
    /// Kind of error that occurred.
    pub kind: RestoreFromClusterSnapshotErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RestoreFromClusterSnapshot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RestoreFromClusterSnapshotErrorKind {
    /// <p>The owner of the specified snapshot has not authorized your account to access the
    /// snapshot.</p>
    AccessToSnapshotDeniedFault(crate::error::AccessToSnapshotDeniedFault),
    /// <p>The account already has a cluster with the given identifier.</p>
    ClusterAlreadyExistsFault(crate::error::ClusterAlreadyExistsFault),
    /// <p>The parameter group name does not refer to an existing parameter group.</p>
    ClusterParameterGroupNotFoundFault(crate::error::ClusterParameterGroupNotFoundFault),
    /// <p>The request would exceed the allowed number of cluster instances for this account.
    ///
    /// For information about increasing your quota, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon Redshift</a>
    /// in the <i>Amazon Redshift Cluster Management Guide</i>.
    /// </p>
    ClusterQuotaExceededFault(crate::error::ClusterQuotaExceededFault),
    /// <p>The cluster security group name does not refer to an existing cluster security
    /// group.</p>
    ClusterSecurityGroupNotFoundFault(crate::error::ClusterSecurityGroupNotFoundFault),
    /// <p>The snapshot identifier does not refer to an existing cluster snapshot.</p>
    ClusterSnapshotNotFoundFault(crate::error::ClusterSnapshotNotFoundFault),
    /// <p>The cluster subnet group name does not refer to an existing cluster subnet
    /// group.</p>
    ClusterSubnetGroupNotFoundFault(crate::error::ClusterSubnetGroupNotFoundFault),
    /// <p>The request cannot be completed because a dependent service is throttling requests
    /// made by Amazon Redshift on your behalf. Wait and retry the request.</p>
    DependentServiceRequestThrottlingFault(crate::error::DependentServiceRequestThrottlingFault),
    /// <p>There is no Amazon Redshift HSM client certificate with the specified
    /// identifier.</p>
    HsmClientCertificateNotFoundFault(crate::error::HsmClientCertificateNotFoundFault),
    /// <p>There is no Amazon Redshift HSM configuration with the specified identifier.</p>
    HsmConfigurationNotFoundFault(crate::error::HsmConfigurationNotFoundFault),
    /// <p>The number of nodes specified exceeds the allotted capacity of the
    /// cluster.</p>
    InsufficientClusterCapacityFault(crate::error::InsufficientClusterCapacityFault),
    /// <p>The specified cluster snapshot is not in the <code>available</code> state, or other
    /// accounts are authorized to access the snapshot. </p>
    InvalidClusterSnapshotStateFault(crate::error::InvalidClusterSnapshotStateFault),
    /// <p>The cluster subnet group cannot be deleted because it is in use.</p>
    InvalidClusterSubnetGroupStateFault(crate::error::InvalidClusterSubnetGroupStateFault),
    /// <p>The provided cluster track name is not valid.</p>
    InvalidClusterTrackFault(crate::error::InvalidClusterTrackFault),
    /// <p>The Elastic IP (EIP) is invalid or cannot be found.</p>
    InvalidElasticIpFault(crate::error::InvalidElasticIpFault),
    /// <p>The restore is invalid.</p>
    InvalidRestoreFault(crate::error::InvalidRestoreFault),
    /// <p>The requested subnet is not valid, or not all of the subnets are in the same
    /// VPC.</p>
    InvalidSubnet(crate::error::InvalidSubnet),
    /// <p>The tag is invalid.</p>
    InvalidTagFault(crate::error::InvalidTagFault),
    /// <p>The cluster subnet group does not cover all Availability Zones.</p>
    InvalidVpcNetworkStateFault(crate::error::InvalidVpcNetworkStateFault),
    /// <p>The encryption key has exceeded its grant limit in Amazon Web Services KMS.</p>
    LimitExceededFault(crate::error::LimitExceededFault),
    /// <p>The operation would exceed the number of nodes allowed for a cluster.</p>
    NumberOfNodesPerClusterLimitExceededFault(
        crate::error::NumberOfNodesPerClusterLimitExceededFault,
    ),
    /// <p>The operation would exceed the number of nodes allotted to the account.
    ///
    /// For information about increasing your quota, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon Redshift</a>
    /// in the <i>Amazon Redshift Cluster Management Guide</i>.
    /// </p>
    NumberOfNodesQuotaExceededFault(crate::error::NumberOfNodesQuotaExceededFault),
    /// <p>We could not find the specified snapshot schedule. </p>
    SnapshotScheduleNotFoundFault(crate::error::SnapshotScheduleNotFoundFault),
    /// <p>You have exceeded the number of tags allowed.</p>
    TagLimitExceededFault(crate::error::TagLimitExceededFault),
    /// <p>Your account is not authorized to perform the requested operation.</p>
    UnauthorizedOperation(crate::error::UnauthorizedOperation),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RestoreFromClusterSnapshotError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RestoreFromClusterSnapshotErrorKind::AccessToSnapshotDeniedFault(_inner) => {
                _inner.fmt(f)
            }
            RestoreFromClusterSnapshotErrorKind::ClusterAlreadyExistsFault(_inner) => _inner.fmt(f),
            RestoreFromClusterSnapshotErrorKind::ClusterParameterGroupNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            RestoreFromClusterSnapshotErrorKind::ClusterQuotaExceededFault(_inner) => _inner.fmt(f),
            RestoreFromClusterSnapshotErrorKind::ClusterSecurityGroupNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            RestoreFromClusterSnapshotErrorKind::ClusterSnapshotNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            RestoreFromClusterSnapshotErrorKind::ClusterSubnetGroupNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            RestoreFromClusterSnapshotErrorKind::DependentServiceRequestThrottlingFault(_inner) => {
                _inner.fmt(f)
            }
            RestoreFromClusterSnapshotErrorKind::HsmClientCertificateNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            RestoreFromClusterSnapshotErrorKind::HsmConfigurationNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            RestoreFromClusterSnapshotErrorKind::InsufficientClusterCapacityFault(_inner) => {
                _inner.fmt(f)
            }
            RestoreFromClusterSnapshotErrorKind::InvalidClusterSnapshotStateFault(_inner) => {
                _inner.fmt(f)
            }
            RestoreFromClusterSnapshotErrorKind::InvalidClusterSubnetGroupStateFault(_inner) => {
                _inner.fmt(f)
            }
            RestoreFromClusterSnapshotErrorKind::InvalidClusterTrackFault(_inner) => _inner.fmt(f),
            RestoreFromClusterSnapshotErrorKind::InvalidElasticIpFault(_inner) => _inner.fmt(f),
            RestoreFromClusterSnapshotErrorKind::InvalidRestoreFault(_inner) => _inner.fmt(f),
            RestoreFromClusterSnapshotErrorKind::InvalidSubnet(_inner) => _inner.fmt(f),
            RestoreFromClusterSnapshotErrorKind::InvalidTagFault(_inner) => _inner.fmt(f),
            RestoreFromClusterSnapshotErrorKind::InvalidVpcNetworkStateFault(_inner) => {
                _inner.fmt(f)
            }
            RestoreFromClusterSnapshotErrorKind::LimitExceededFault(_inner) => _inner.fmt(f),
            RestoreFromClusterSnapshotErrorKind::NumberOfNodesPerClusterLimitExceededFault(
                _inner,
            ) => _inner.fmt(f),
            RestoreFromClusterSnapshotErrorKind::NumberOfNodesQuotaExceededFault(_inner) => {
                _inner.fmt(f)
            }
            RestoreFromClusterSnapshotErrorKind::SnapshotScheduleNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            RestoreFromClusterSnapshotErrorKind::TagLimitExceededFault(_inner) => _inner.fmt(f),
            RestoreFromClusterSnapshotErrorKind::UnauthorizedOperation(_inner) => _inner.fmt(f),
            RestoreFromClusterSnapshotErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RestoreFromClusterSnapshotError {
    fn code(&self) -> Option<&str> {
        RestoreFromClusterSnapshotError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RestoreFromClusterSnapshotError {
    /// Creates a new `RestoreFromClusterSnapshotError`.
    pub fn new(kind: RestoreFromClusterSnapshotErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RestoreFromClusterSnapshotError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RestoreFromClusterSnapshotErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RestoreFromClusterSnapshotError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RestoreFromClusterSnapshotErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RestoreFromClusterSnapshotErrorKind::AccessToSnapshotDeniedFault`.
    pub fn is_access_to_snapshot_denied_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreFromClusterSnapshotErrorKind::AccessToSnapshotDeniedFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreFromClusterSnapshotErrorKind::ClusterAlreadyExistsFault`.
    pub fn is_cluster_already_exists_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreFromClusterSnapshotErrorKind::ClusterAlreadyExistsFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreFromClusterSnapshotErrorKind::ClusterParameterGroupNotFoundFault`.
    pub fn is_cluster_parameter_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreFromClusterSnapshotErrorKind::ClusterParameterGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreFromClusterSnapshotErrorKind::ClusterQuotaExceededFault`.
    pub fn is_cluster_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreFromClusterSnapshotErrorKind::ClusterQuotaExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreFromClusterSnapshotErrorKind::ClusterSecurityGroupNotFoundFault`.
    pub fn is_cluster_security_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreFromClusterSnapshotErrorKind::ClusterSecurityGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreFromClusterSnapshotErrorKind::ClusterSnapshotNotFoundFault`.
    pub fn is_cluster_snapshot_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreFromClusterSnapshotErrorKind::ClusterSnapshotNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreFromClusterSnapshotErrorKind::ClusterSubnetGroupNotFoundFault`.
    pub fn is_cluster_subnet_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreFromClusterSnapshotErrorKind::ClusterSubnetGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreFromClusterSnapshotErrorKind::DependentServiceRequestThrottlingFault`.
    pub fn is_dependent_service_request_throttling_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreFromClusterSnapshotErrorKind::DependentServiceRequestThrottlingFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreFromClusterSnapshotErrorKind::HsmClientCertificateNotFoundFault`.
    pub fn is_hsm_client_certificate_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreFromClusterSnapshotErrorKind::HsmClientCertificateNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreFromClusterSnapshotErrorKind::HsmConfigurationNotFoundFault`.
    pub fn is_hsm_configuration_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreFromClusterSnapshotErrorKind::HsmConfigurationNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreFromClusterSnapshotErrorKind::InsufficientClusterCapacityFault`.
    pub fn is_insufficient_cluster_capacity_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreFromClusterSnapshotErrorKind::InsufficientClusterCapacityFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreFromClusterSnapshotErrorKind::InvalidClusterSnapshotStateFault`.
    pub fn is_invalid_cluster_snapshot_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreFromClusterSnapshotErrorKind::InvalidClusterSnapshotStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreFromClusterSnapshotErrorKind::InvalidClusterSubnetGroupStateFault`.
    pub fn is_invalid_cluster_subnet_group_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreFromClusterSnapshotErrorKind::InvalidClusterSubnetGroupStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreFromClusterSnapshotErrorKind::InvalidClusterTrackFault`.
    pub fn is_invalid_cluster_track_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreFromClusterSnapshotErrorKind::InvalidClusterTrackFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreFromClusterSnapshotErrorKind::InvalidElasticIpFault`.
    pub fn is_invalid_elastic_ip_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreFromClusterSnapshotErrorKind::InvalidElasticIpFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreFromClusterSnapshotErrorKind::InvalidRestoreFault`.
    pub fn is_invalid_restore_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreFromClusterSnapshotErrorKind::InvalidRestoreFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreFromClusterSnapshotErrorKind::InvalidSubnet`.
    pub fn is_invalid_subnet(&self) -> bool {
        matches!(
            &self.kind,
            RestoreFromClusterSnapshotErrorKind::InvalidSubnet(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreFromClusterSnapshotErrorKind::InvalidTagFault`.
    pub fn is_invalid_tag_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreFromClusterSnapshotErrorKind::InvalidTagFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreFromClusterSnapshotErrorKind::InvalidVpcNetworkStateFault`.
    pub fn is_invalid_vpc_network_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreFromClusterSnapshotErrorKind::InvalidVpcNetworkStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreFromClusterSnapshotErrorKind::LimitExceededFault`.
    pub fn is_limit_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreFromClusterSnapshotErrorKind::LimitExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreFromClusterSnapshotErrorKind::NumberOfNodesPerClusterLimitExceededFault`.
    pub fn is_number_of_nodes_per_cluster_limit_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreFromClusterSnapshotErrorKind::NumberOfNodesPerClusterLimitExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreFromClusterSnapshotErrorKind::NumberOfNodesQuotaExceededFault`.
    pub fn is_number_of_nodes_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreFromClusterSnapshotErrorKind::NumberOfNodesQuotaExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreFromClusterSnapshotErrorKind::SnapshotScheduleNotFoundFault`.
    pub fn is_snapshot_schedule_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreFromClusterSnapshotErrorKind::SnapshotScheduleNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreFromClusterSnapshotErrorKind::TagLimitExceededFault`.
    pub fn is_tag_limit_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreFromClusterSnapshotErrorKind::TagLimitExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreFromClusterSnapshotErrorKind::UnauthorizedOperation`.
    pub fn is_unauthorized_operation(&self) -> bool {
        matches!(
            &self.kind,
            RestoreFromClusterSnapshotErrorKind::UnauthorizedOperation(_)
        )
    }
}
impl std::error::Error for RestoreFromClusterSnapshotError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RestoreFromClusterSnapshotErrorKind::AccessToSnapshotDeniedFault(_inner) => {
                Some(_inner)
            }
            RestoreFromClusterSnapshotErrorKind::ClusterAlreadyExistsFault(_inner) => Some(_inner),
            RestoreFromClusterSnapshotErrorKind::ClusterParameterGroupNotFoundFault(_inner) => {
                Some(_inner)
            }
            RestoreFromClusterSnapshotErrorKind::ClusterQuotaExceededFault(_inner) => Some(_inner),
            RestoreFromClusterSnapshotErrorKind::ClusterSecurityGroupNotFoundFault(_inner) => {
                Some(_inner)
            }
            RestoreFromClusterSnapshotErrorKind::ClusterSnapshotNotFoundFault(_inner) => {
                Some(_inner)
            }
            RestoreFromClusterSnapshotErrorKind::ClusterSubnetGroupNotFoundFault(_inner) => {
                Some(_inner)
            }
            RestoreFromClusterSnapshotErrorKind::DependentServiceRequestThrottlingFault(_inner) => {
                Some(_inner)
            }
            RestoreFromClusterSnapshotErrorKind::HsmClientCertificateNotFoundFault(_inner) => {
                Some(_inner)
            }
            RestoreFromClusterSnapshotErrorKind::HsmConfigurationNotFoundFault(_inner) => {
                Some(_inner)
            }
            RestoreFromClusterSnapshotErrorKind::InsufficientClusterCapacityFault(_inner) => {
                Some(_inner)
            }
            RestoreFromClusterSnapshotErrorKind::InvalidClusterSnapshotStateFault(_inner) => {
                Some(_inner)
            }
            RestoreFromClusterSnapshotErrorKind::InvalidClusterSubnetGroupStateFault(_inner) => {
                Some(_inner)
            }
            RestoreFromClusterSnapshotErrorKind::InvalidClusterTrackFault(_inner) => Some(_inner),
            RestoreFromClusterSnapshotErrorKind::InvalidElasticIpFault(_inner) => Some(_inner),
            RestoreFromClusterSnapshotErrorKind::InvalidRestoreFault(_inner) => Some(_inner),
            RestoreFromClusterSnapshotErrorKind::InvalidSubnet(_inner) => Some(_inner),
            RestoreFromClusterSnapshotErrorKind::InvalidTagFault(_inner) => Some(_inner),
            RestoreFromClusterSnapshotErrorKind::InvalidVpcNetworkStateFault(_inner) => {
                Some(_inner)
            }
            RestoreFromClusterSnapshotErrorKind::LimitExceededFault(_inner) => Some(_inner),
            RestoreFromClusterSnapshotErrorKind::NumberOfNodesPerClusterLimitExceededFault(
                _inner,
            ) => Some(_inner),
            RestoreFromClusterSnapshotErrorKind::NumberOfNodesQuotaExceededFault(_inner) => {
                Some(_inner)
            }
            RestoreFromClusterSnapshotErrorKind::SnapshotScheduleNotFoundFault(_inner) => {
                Some(_inner)
            }
            RestoreFromClusterSnapshotErrorKind::TagLimitExceededFault(_inner) => Some(_inner),
            RestoreFromClusterSnapshotErrorKind::UnauthorizedOperation(_inner) => Some(_inner),
            RestoreFromClusterSnapshotErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RestoreTableFromClusterSnapshot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RestoreTableFromClusterSnapshotError {
    /// Kind of error that occurred.
    pub kind: RestoreTableFromClusterSnapshotErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RestoreTableFromClusterSnapshot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RestoreTableFromClusterSnapshotErrorKind {
    /// <p>The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster.
    /// </p>
    ClusterNotFoundFault(crate::error::ClusterNotFoundFault),
    /// <p>The snapshot identifier does not refer to an existing cluster snapshot.</p>
    ClusterSnapshotNotFoundFault(crate::error::ClusterSnapshotNotFoundFault),
    /// <p>You have exceeded the allowed number of table restore requests. Wait for your
    /// current table restore requests to complete before making a new request.</p>
    InProgressTableRestoreQuotaExceededFault(
        crate::error::InProgressTableRestoreQuotaExceededFault,
    ),
    /// <p>The specified cluster snapshot is not in the <code>available</code> state, or other
    /// accounts are authorized to access the snapshot. </p>
    InvalidClusterSnapshotStateFault(crate::error::InvalidClusterSnapshotStateFault),
    /// <p>The specified cluster is not in the <code>available</code> state. </p>
    InvalidClusterStateFault(crate::error::InvalidClusterStateFault),
    /// <p>The value specified for the <code>sourceDatabaseName</code>,
    /// <code>sourceSchemaName</code>, or <code>sourceTableName</code> parameter, or a
    /// combination of these, doesn't exist in the snapshot.</p>
    InvalidTableRestoreArgumentFault(crate::error::InvalidTableRestoreArgumentFault),
    /// <p>The requested operation isn't supported.</p>
    UnsupportedOperationFault(crate::error::UnsupportedOperationFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RestoreTableFromClusterSnapshotError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RestoreTableFromClusterSnapshotErrorKind::ClusterNotFoundFault(_inner) => _inner.fmt(f),
            RestoreTableFromClusterSnapshotErrorKind::ClusterSnapshotNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            RestoreTableFromClusterSnapshotErrorKind::InProgressTableRestoreQuotaExceededFault(
                _inner,
            ) => _inner.fmt(f),
            RestoreTableFromClusterSnapshotErrorKind::InvalidClusterSnapshotStateFault(_inner) => {
                _inner.fmt(f)
            }
            RestoreTableFromClusterSnapshotErrorKind::InvalidClusterStateFault(_inner) => {
                _inner.fmt(f)
            }
            RestoreTableFromClusterSnapshotErrorKind::InvalidTableRestoreArgumentFault(_inner) => {
                _inner.fmt(f)
            }
            RestoreTableFromClusterSnapshotErrorKind::UnsupportedOperationFault(_inner) => {
                _inner.fmt(f)
            }
            RestoreTableFromClusterSnapshotErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RestoreTableFromClusterSnapshotError {
    fn code(&self) -> Option<&str> {
        RestoreTableFromClusterSnapshotError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RestoreTableFromClusterSnapshotError {
    /// Creates a new `RestoreTableFromClusterSnapshotError`.
    pub fn new(
        kind: RestoreTableFromClusterSnapshotErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RestoreTableFromClusterSnapshotError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RestoreTableFromClusterSnapshotErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RestoreTableFromClusterSnapshotError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RestoreTableFromClusterSnapshotErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RestoreTableFromClusterSnapshotErrorKind::ClusterNotFoundFault`.
    pub fn is_cluster_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreTableFromClusterSnapshotErrorKind::ClusterNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreTableFromClusterSnapshotErrorKind::ClusterSnapshotNotFoundFault`.
    pub fn is_cluster_snapshot_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreTableFromClusterSnapshotErrorKind::ClusterSnapshotNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreTableFromClusterSnapshotErrorKind::InProgressTableRestoreQuotaExceededFault`.
    pub fn is_in_progress_table_restore_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreTableFromClusterSnapshotErrorKind::InProgressTableRestoreQuotaExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreTableFromClusterSnapshotErrorKind::InvalidClusterSnapshotStateFault`.
    pub fn is_invalid_cluster_snapshot_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreTableFromClusterSnapshotErrorKind::InvalidClusterSnapshotStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreTableFromClusterSnapshotErrorKind::InvalidClusterStateFault`.
    pub fn is_invalid_cluster_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreTableFromClusterSnapshotErrorKind::InvalidClusterStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreTableFromClusterSnapshotErrorKind::InvalidTableRestoreArgumentFault`.
    pub fn is_invalid_table_restore_argument_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreTableFromClusterSnapshotErrorKind::InvalidTableRestoreArgumentFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreTableFromClusterSnapshotErrorKind::UnsupportedOperationFault`.
    pub fn is_unsupported_operation_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreTableFromClusterSnapshotErrorKind::UnsupportedOperationFault(_)
        )
    }
}
impl std::error::Error for RestoreTableFromClusterSnapshotError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RestoreTableFromClusterSnapshotErrorKind::ClusterNotFoundFault(_inner) => Some(_inner),
            RestoreTableFromClusterSnapshotErrorKind::ClusterSnapshotNotFoundFault(_inner) => {
                Some(_inner)
            }
            RestoreTableFromClusterSnapshotErrorKind::InProgressTableRestoreQuotaExceededFault(
                _inner,
            ) => Some(_inner),
            RestoreTableFromClusterSnapshotErrorKind::InvalidClusterSnapshotStateFault(_inner) => {
                Some(_inner)
            }
            RestoreTableFromClusterSnapshotErrorKind::InvalidClusterStateFault(_inner) => {
                Some(_inner)
            }
            RestoreTableFromClusterSnapshotErrorKind::InvalidTableRestoreArgumentFault(_inner) => {
                Some(_inner)
            }
            RestoreTableFromClusterSnapshotErrorKind::UnsupportedOperationFault(_inner) => {
                Some(_inner)
            }
            RestoreTableFromClusterSnapshotErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ResumeCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ResumeClusterError {
    /// Kind of error that occurred.
    pub kind: ResumeClusterErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ResumeCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ResumeClusterErrorKind {
    /// <p>The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster.
    /// </p>
    ClusterNotFoundFault(crate::error::ClusterNotFoundFault),
    /// <p>The number of nodes specified exceeds the allotted capacity of the
    /// cluster.</p>
    InsufficientClusterCapacityFault(crate::error::InsufficientClusterCapacityFault),
    /// <p>The specified cluster is not in the <code>available</code> state. </p>
    InvalidClusterStateFault(crate::error::InvalidClusterStateFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ResumeClusterError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ResumeClusterErrorKind::ClusterNotFoundFault(_inner) => _inner.fmt(f),
            ResumeClusterErrorKind::InsufficientClusterCapacityFault(_inner) => _inner.fmt(f),
            ResumeClusterErrorKind::InvalidClusterStateFault(_inner) => _inner.fmt(f),
            ResumeClusterErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ResumeClusterError {
    fn code(&self) -> Option<&str> {
        ResumeClusterError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ResumeClusterError {
    /// Creates a new `ResumeClusterError`.
    pub fn new(kind: ResumeClusterErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ResumeClusterError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ResumeClusterErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ResumeClusterError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ResumeClusterErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ResumeClusterErrorKind::ClusterNotFoundFault`.
    pub fn is_cluster_not_found_fault(&self) -> bool {
        matches!(&self.kind, ResumeClusterErrorKind::ClusterNotFoundFault(_))
    }
    /// Returns `true` if the error kind is `ResumeClusterErrorKind::InsufficientClusterCapacityFault`.
    pub fn is_insufficient_cluster_capacity_fault(&self) -> bool {
        matches!(
            &self.kind,
            ResumeClusterErrorKind::InsufficientClusterCapacityFault(_)
        )
    }
    /// Returns `true` if the error kind is `ResumeClusterErrorKind::InvalidClusterStateFault`.
    pub fn is_invalid_cluster_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            ResumeClusterErrorKind::InvalidClusterStateFault(_)
        )
    }
}
impl std::error::Error for ResumeClusterError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ResumeClusterErrorKind::ClusterNotFoundFault(_inner) => Some(_inner),
            ResumeClusterErrorKind::InsufficientClusterCapacityFault(_inner) => Some(_inner),
            ResumeClusterErrorKind::InvalidClusterStateFault(_inner) => Some(_inner),
            ResumeClusterErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RevokeClusterSecurityGroupIngress` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RevokeClusterSecurityGroupIngressError {
    /// Kind of error that occurred.
    pub kind: RevokeClusterSecurityGroupIngressErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RevokeClusterSecurityGroupIngress` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RevokeClusterSecurityGroupIngressErrorKind {
    /// <p>The specified CIDR IP range or EC2 security group is not authorized for the
    /// specified cluster security group.</p>
    AuthorizationNotFoundFault(crate::error::AuthorizationNotFoundFault),
    /// <p>The cluster security group name does not refer to an existing cluster security
    /// group.</p>
    ClusterSecurityGroupNotFoundFault(crate::error::ClusterSecurityGroupNotFoundFault),
    /// <p>The state of the cluster security group is not <code>available</code>. </p>
    InvalidClusterSecurityGroupStateFault(crate::error::InvalidClusterSecurityGroupStateFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RevokeClusterSecurityGroupIngressError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RevokeClusterSecurityGroupIngressErrorKind::AuthorizationNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            RevokeClusterSecurityGroupIngressErrorKind::ClusterSecurityGroupNotFoundFault(
                _inner,
            ) => _inner.fmt(f),
            RevokeClusterSecurityGroupIngressErrorKind::InvalidClusterSecurityGroupStateFault(
                _inner,
            ) => _inner.fmt(f),
            RevokeClusterSecurityGroupIngressErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RevokeClusterSecurityGroupIngressError {
    fn code(&self) -> Option<&str> {
        RevokeClusterSecurityGroupIngressError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RevokeClusterSecurityGroupIngressError {
    /// Creates a new `RevokeClusterSecurityGroupIngressError`.
    pub fn new(
        kind: RevokeClusterSecurityGroupIngressErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RevokeClusterSecurityGroupIngressError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RevokeClusterSecurityGroupIngressErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RevokeClusterSecurityGroupIngressError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RevokeClusterSecurityGroupIngressErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RevokeClusterSecurityGroupIngressErrorKind::AuthorizationNotFoundFault`.
    pub fn is_authorization_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            RevokeClusterSecurityGroupIngressErrorKind::AuthorizationNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `RevokeClusterSecurityGroupIngressErrorKind::ClusterSecurityGroupNotFoundFault`.
    pub fn is_cluster_security_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            RevokeClusterSecurityGroupIngressErrorKind::ClusterSecurityGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `RevokeClusterSecurityGroupIngressErrorKind::InvalidClusterSecurityGroupStateFault`.
    pub fn is_invalid_cluster_security_group_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            RevokeClusterSecurityGroupIngressErrorKind::InvalidClusterSecurityGroupStateFault(_)
        )
    }
}
impl std::error::Error for RevokeClusterSecurityGroupIngressError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RevokeClusterSecurityGroupIngressErrorKind::AuthorizationNotFoundFault(_inner) => {
                Some(_inner)
            }
            RevokeClusterSecurityGroupIngressErrorKind::ClusterSecurityGroupNotFoundFault(
                _inner,
            ) => Some(_inner),
            RevokeClusterSecurityGroupIngressErrorKind::InvalidClusterSecurityGroupStateFault(
                _inner,
            ) => Some(_inner),
            RevokeClusterSecurityGroupIngressErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RevokeEndpointAccess` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RevokeEndpointAccessError {
    /// Kind of error that occurred.
    pub kind: RevokeEndpointAccessErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RevokeEndpointAccess` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RevokeEndpointAccessErrorKind {
    /// <p>The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster.
    /// </p>
    ClusterNotFoundFault(crate::error::ClusterNotFoundFault),
    /// <p>The authorization for this endpoint can't be found.</p>
    EndpointAuthorizationNotFoundFault(crate::error::EndpointAuthorizationNotFoundFault),
    /// <p>The endpoint name doesn't refer to an existing endpoint.</p>
    EndpointNotFoundFault(crate::error::EndpointNotFoundFault),
    /// <p>The status of the authorization is not valid.</p>
    InvalidAuthorizationStateFault(crate::error::InvalidAuthorizationStateFault),
    /// <p>The state of the cluster security group is not <code>available</code>. </p>
    InvalidClusterSecurityGroupStateFault(crate::error::InvalidClusterSecurityGroupStateFault),
    /// <p>The specified cluster is not in the <code>available</code> state. </p>
    InvalidClusterStateFault(crate::error::InvalidClusterStateFault),
    /// <p>The status of the endpoint is not valid.</p>
    InvalidEndpointStateFault(crate::error::InvalidEndpointStateFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RevokeEndpointAccessError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RevokeEndpointAccessErrorKind::ClusterNotFoundFault(_inner) => _inner.fmt(f),
            RevokeEndpointAccessErrorKind::EndpointAuthorizationNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            RevokeEndpointAccessErrorKind::EndpointNotFoundFault(_inner) => _inner.fmt(f),
            RevokeEndpointAccessErrorKind::InvalidAuthorizationStateFault(_inner) => _inner.fmt(f),
            RevokeEndpointAccessErrorKind::InvalidClusterSecurityGroupStateFault(_inner) => {
                _inner.fmt(f)
            }
            RevokeEndpointAccessErrorKind::InvalidClusterStateFault(_inner) => _inner.fmt(f),
            RevokeEndpointAccessErrorKind::InvalidEndpointStateFault(_inner) => _inner.fmt(f),
            RevokeEndpointAccessErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RevokeEndpointAccessError {
    fn code(&self) -> Option<&str> {
        RevokeEndpointAccessError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RevokeEndpointAccessError {
    /// Creates a new `RevokeEndpointAccessError`.
    pub fn new(kind: RevokeEndpointAccessErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RevokeEndpointAccessError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RevokeEndpointAccessErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RevokeEndpointAccessError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RevokeEndpointAccessErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RevokeEndpointAccessErrorKind::ClusterNotFoundFault`.
    pub fn is_cluster_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            RevokeEndpointAccessErrorKind::ClusterNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `RevokeEndpointAccessErrorKind::EndpointAuthorizationNotFoundFault`.
    pub fn is_endpoint_authorization_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            RevokeEndpointAccessErrorKind::EndpointAuthorizationNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `RevokeEndpointAccessErrorKind::EndpointNotFoundFault`.
    pub fn is_endpoint_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            RevokeEndpointAccessErrorKind::EndpointNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `RevokeEndpointAccessErrorKind::InvalidAuthorizationStateFault`.
    pub fn is_invalid_authorization_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            RevokeEndpointAccessErrorKind::InvalidAuthorizationStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `RevokeEndpointAccessErrorKind::InvalidClusterSecurityGroupStateFault`.
    pub fn is_invalid_cluster_security_group_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            RevokeEndpointAccessErrorKind::InvalidClusterSecurityGroupStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `RevokeEndpointAccessErrorKind::InvalidClusterStateFault`.
    pub fn is_invalid_cluster_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            RevokeEndpointAccessErrorKind::InvalidClusterStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `RevokeEndpointAccessErrorKind::InvalidEndpointStateFault`.
    pub fn is_invalid_endpoint_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            RevokeEndpointAccessErrorKind::InvalidEndpointStateFault(_)
        )
    }
}
impl std::error::Error for RevokeEndpointAccessError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RevokeEndpointAccessErrorKind::ClusterNotFoundFault(_inner) => Some(_inner),
            RevokeEndpointAccessErrorKind::EndpointAuthorizationNotFoundFault(_inner) => {
                Some(_inner)
            }
            RevokeEndpointAccessErrorKind::EndpointNotFoundFault(_inner) => Some(_inner),
            RevokeEndpointAccessErrorKind::InvalidAuthorizationStateFault(_inner) => Some(_inner),
            RevokeEndpointAccessErrorKind::InvalidClusterSecurityGroupStateFault(_inner) => {
                Some(_inner)
            }
            RevokeEndpointAccessErrorKind::InvalidClusterStateFault(_inner) => Some(_inner),
            RevokeEndpointAccessErrorKind::InvalidEndpointStateFault(_inner) => Some(_inner),
            RevokeEndpointAccessErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RevokeSnapshotAccess` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RevokeSnapshotAccessError {
    /// Kind of error that occurred.
    pub kind: RevokeSnapshotAccessErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RevokeSnapshotAccess` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RevokeSnapshotAccessErrorKind {
    /// <p>The owner of the specified snapshot has not authorized your account to access the
    /// snapshot.</p>
    AccessToSnapshotDeniedFault(crate::error::AccessToSnapshotDeniedFault),
    /// <p>The specified CIDR IP range or EC2 security group is not authorized for the
    /// specified cluster security group.</p>
    AuthorizationNotFoundFault(crate::error::AuthorizationNotFoundFault),
    /// <p>The snapshot identifier does not refer to an existing cluster snapshot.</p>
    ClusterSnapshotNotFoundFault(crate::error::ClusterSnapshotNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RevokeSnapshotAccessError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RevokeSnapshotAccessErrorKind::AccessToSnapshotDeniedFault(_inner) => _inner.fmt(f),
            RevokeSnapshotAccessErrorKind::AuthorizationNotFoundFault(_inner) => _inner.fmt(f),
            RevokeSnapshotAccessErrorKind::ClusterSnapshotNotFoundFault(_inner) => _inner.fmt(f),
            RevokeSnapshotAccessErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RevokeSnapshotAccessError {
    fn code(&self) -> Option<&str> {
        RevokeSnapshotAccessError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RevokeSnapshotAccessError {
    /// Creates a new `RevokeSnapshotAccessError`.
    pub fn new(kind: RevokeSnapshotAccessErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RevokeSnapshotAccessError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RevokeSnapshotAccessErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RevokeSnapshotAccessError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RevokeSnapshotAccessErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RevokeSnapshotAccessErrorKind::AccessToSnapshotDeniedFault`.
    pub fn is_access_to_snapshot_denied_fault(&self) -> bool {
        matches!(
            &self.kind,
            RevokeSnapshotAccessErrorKind::AccessToSnapshotDeniedFault(_)
        )
    }
    /// Returns `true` if the error kind is `RevokeSnapshotAccessErrorKind::AuthorizationNotFoundFault`.
    pub fn is_authorization_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            RevokeSnapshotAccessErrorKind::AuthorizationNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `RevokeSnapshotAccessErrorKind::ClusterSnapshotNotFoundFault`.
    pub fn is_cluster_snapshot_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            RevokeSnapshotAccessErrorKind::ClusterSnapshotNotFoundFault(_)
        )
    }
}
impl std::error::Error for RevokeSnapshotAccessError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RevokeSnapshotAccessErrorKind::AccessToSnapshotDeniedFault(_inner) => Some(_inner),
            RevokeSnapshotAccessErrorKind::AuthorizationNotFoundFault(_inner) => Some(_inner),
            RevokeSnapshotAccessErrorKind::ClusterSnapshotNotFoundFault(_inner) => Some(_inner),
            RevokeSnapshotAccessErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RotateEncryptionKey` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RotateEncryptionKeyError {
    /// Kind of error that occurred.
    pub kind: RotateEncryptionKeyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RotateEncryptionKey` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RotateEncryptionKeyErrorKind {
    /// <p>The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster.
    /// </p>
    ClusterNotFoundFault(crate::error::ClusterNotFoundFault),
    /// <p>The request cannot be completed because a dependent service is throttling requests
    /// made by Amazon Redshift on your behalf. Wait and retry the request.</p>
    DependentServiceRequestThrottlingFault(crate::error::DependentServiceRequestThrottlingFault),
    /// <p>The specified cluster is not in the <code>available</code> state. </p>
    InvalidClusterStateFault(crate::error::InvalidClusterStateFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RotateEncryptionKeyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RotateEncryptionKeyErrorKind::ClusterNotFoundFault(_inner) => _inner.fmt(f),
            RotateEncryptionKeyErrorKind::DependentServiceRequestThrottlingFault(_inner) => {
                _inner.fmt(f)
            }
            RotateEncryptionKeyErrorKind::InvalidClusterStateFault(_inner) => _inner.fmt(f),
            RotateEncryptionKeyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RotateEncryptionKeyError {
    fn code(&self) -> Option<&str> {
        RotateEncryptionKeyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RotateEncryptionKeyError {
    /// Creates a new `RotateEncryptionKeyError`.
    pub fn new(kind: RotateEncryptionKeyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RotateEncryptionKeyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RotateEncryptionKeyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RotateEncryptionKeyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RotateEncryptionKeyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RotateEncryptionKeyErrorKind::ClusterNotFoundFault`.
    pub fn is_cluster_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            RotateEncryptionKeyErrorKind::ClusterNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `RotateEncryptionKeyErrorKind::DependentServiceRequestThrottlingFault`.
    pub fn is_dependent_service_request_throttling_fault(&self) -> bool {
        matches!(
            &self.kind,
            RotateEncryptionKeyErrorKind::DependentServiceRequestThrottlingFault(_)
        )
    }
    /// Returns `true` if the error kind is `RotateEncryptionKeyErrorKind::InvalidClusterStateFault`.
    pub fn is_invalid_cluster_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            RotateEncryptionKeyErrorKind::InvalidClusterStateFault(_)
        )
    }
}
impl std::error::Error for RotateEncryptionKeyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RotateEncryptionKeyErrorKind::ClusterNotFoundFault(_inner) => Some(_inner),
            RotateEncryptionKeyErrorKind::DependentServiceRequestThrottlingFault(_inner) => {
                Some(_inner)
            }
            RotateEncryptionKeyErrorKind::InvalidClusterStateFault(_inner) => Some(_inner),
            RotateEncryptionKeyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdatePartnerStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdatePartnerStatusError {
    /// Kind of error that occurred.
    pub kind: UpdatePartnerStatusErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdatePartnerStatus` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdatePartnerStatusErrorKind {
    /// <p>The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster.
    /// </p>
    ClusterNotFoundFault(crate::error::ClusterNotFoundFault),
    /// <p>The name of the partner was not found.</p>
    PartnerNotFoundFault(crate::error::PartnerNotFoundFault),
    /// <p>The partner integration is not authorized.</p>
    UnauthorizedPartnerIntegrationFault(crate::error::UnauthorizedPartnerIntegrationFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdatePartnerStatusError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdatePartnerStatusErrorKind::ClusterNotFoundFault(_inner) => _inner.fmt(f),
            UpdatePartnerStatusErrorKind::PartnerNotFoundFault(_inner) => _inner.fmt(f),
            UpdatePartnerStatusErrorKind::UnauthorizedPartnerIntegrationFault(_inner) => {
                _inner.fmt(f)
            }
            UpdatePartnerStatusErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdatePartnerStatusError {
    fn code(&self) -> Option<&str> {
        UpdatePartnerStatusError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdatePartnerStatusError {
    /// Creates a new `UpdatePartnerStatusError`.
    pub fn new(kind: UpdatePartnerStatusErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdatePartnerStatusError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdatePartnerStatusErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdatePartnerStatusError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdatePartnerStatusErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdatePartnerStatusErrorKind::ClusterNotFoundFault`.
    pub fn is_cluster_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePartnerStatusErrorKind::ClusterNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePartnerStatusErrorKind::PartnerNotFoundFault`.
    pub fn is_partner_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePartnerStatusErrorKind::PartnerNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePartnerStatusErrorKind::UnauthorizedPartnerIntegrationFault`.
    pub fn is_unauthorized_partner_integration_fault(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePartnerStatusErrorKind::UnauthorizedPartnerIntegrationFault(_)
        )
    }
}
impl std::error::Error for UpdatePartnerStatusError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdatePartnerStatusErrorKind::ClusterNotFoundFault(_inner) => Some(_inner),
            UpdatePartnerStatusErrorKind::PartnerNotFoundFault(_inner) => Some(_inner),
            UpdatePartnerStatusErrorKind::UnauthorizedPartnerIntegrationFault(_inner) => {
                Some(_inner)
            }
            UpdatePartnerStatusErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>The partner integration is not authorized.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnauthorizedPartnerIntegrationFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UnauthorizedPartnerIntegrationFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnauthorizedPartnerIntegrationFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl UnauthorizedPartnerIntegrationFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for UnauthorizedPartnerIntegrationFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "UnauthorizedPartnerIntegrationFault")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for UnauthorizedPartnerIntegrationFault {}
/// See [`UnauthorizedPartnerIntegrationFault`](crate::error::UnauthorizedPartnerIntegrationFault)
pub mod unauthorized_partner_integration_fault {
    /// A builder for [`UnauthorizedPartnerIntegrationFault`](crate::error::UnauthorizedPartnerIntegrationFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`UnauthorizedPartnerIntegrationFault`](crate::error::UnauthorizedPartnerIntegrationFault)
        pub fn build(self) -> crate::error::UnauthorizedPartnerIntegrationFault {
            crate::error::UnauthorizedPartnerIntegrationFault {
                message: self.message,
            }
        }
    }
}
impl UnauthorizedPartnerIntegrationFault {
    /// Creates a new builder-style object to manufacture [`UnauthorizedPartnerIntegrationFault`](crate::error::UnauthorizedPartnerIntegrationFault)
    pub fn builder() -> crate::error::unauthorized_partner_integration_fault::Builder {
        crate::error::unauthorized_partner_integration_fault::Builder::default()
    }
}

/// <p>The name of the partner was not found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PartnerNotFoundFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for PartnerNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PartnerNotFoundFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl PartnerNotFoundFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for PartnerNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "PartnerNotFoundFault")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for PartnerNotFoundFault {}
/// See [`PartnerNotFoundFault`](crate::error::PartnerNotFoundFault)
pub mod partner_not_found_fault {
    /// A builder for [`PartnerNotFoundFault`](crate::error::PartnerNotFoundFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`PartnerNotFoundFault`](crate::error::PartnerNotFoundFault)
        pub fn build(self) -> crate::error::PartnerNotFoundFault {
            crate::error::PartnerNotFoundFault {
                message: self.message,
            }
        }
    }
}
impl PartnerNotFoundFault {
    /// Creates a new builder-style object to manufacture [`PartnerNotFoundFault`](crate::error::PartnerNotFoundFault)
    pub fn builder() -> crate::error::partner_not_found_fault::Builder {
        crate::error::partner_not_found_fault::Builder::default()
    }
}

/// <p>The <code>ClusterIdentifier</code> parameter does not refer to an existing cluster.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ClusterNotFoundFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ClusterNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ClusterNotFoundFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ClusterNotFoundFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ClusterNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ClusterNotFoundFault")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for ClusterNotFoundFault {}
/// See [`ClusterNotFoundFault`](crate::error::ClusterNotFoundFault)
pub mod cluster_not_found_fault {
    /// A builder for [`ClusterNotFoundFault`](crate::error::ClusterNotFoundFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ClusterNotFoundFault`](crate::error::ClusterNotFoundFault)
        pub fn build(self) -> crate::error::ClusterNotFoundFault {
            crate::error::ClusterNotFoundFault {
                message: self.message,
            }
        }
    }
}
impl ClusterNotFoundFault {
    /// Creates a new builder-style object to manufacture [`ClusterNotFoundFault`](crate::error::ClusterNotFoundFault)
    pub fn builder() -> crate::error::cluster_not_found_fault::Builder {
        crate::error::cluster_not_found_fault::Builder::default()
    }
}

/// <p>The specified cluster is not in the <code>available</code> state. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidClusterStateFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidClusterStateFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidClusterStateFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidClusterStateFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidClusterStateFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidClusterStateFault")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidClusterStateFault {}
/// See [`InvalidClusterStateFault`](crate::error::InvalidClusterStateFault)
pub mod invalid_cluster_state_fault {
    /// A builder for [`InvalidClusterStateFault`](crate::error::InvalidClusterStateFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidClusterStateFault`](crate::error::InvalidClusterStateFault)
        pub fn build(self) -> crate::error::InvalidClusterStateFault {
            crate::error::InvalidClusterStateFault {
                message: self.message,
            }
        }
    }
}
impl InvalidClusterStateFault {
    /// Creates a new builder-style object to manufacture [`InvalidClusterStateFault`](crate::error::InvalidClusterStateFault)
    pub fn builder() -> crate::error::invalid_cluster_state_fault::Builder {
        crate::error::invalid_cluster_state_fault::Builder::default()
    }
}

/// <p>The request cannot be completed because a dependent service is throttling requests
/// made by Amazon Redshift on your behalf. Wait and retry the request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DependentServiceRequestThrottlingFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DependentServiceRequestThrottlingFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DependentServiceRequestThrottlingFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DependentServiceRequestThrottlingFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DependentServiceRequestThrottlingFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DependentServiceRequestThrottlingFault")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for DependentServiceRequestThrottlingFault {}
/// See [`DependentServiceRequestThrottlingFault`](crate::error::DependentServiceRequestThrottlingFault)
pub mod dependent_service_request_throttling_fault {
    /// A builder for [`DependentServiceRequestThrottlingFault`](crate::error::DependentServiceRequestThrottlingFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DependentServiceRequestThrottlingFault`](crate::error::DependentServiceRequestThrottlingFault)
        pub fn build(self) -> crate::error::DependentServiceRequestThrottlingFault {
            crate::error::DependentServiceRequestThrottlingFault {
                message: self.message,
            }
        }
    }
}
impl DependentServiceRequestThrottlingFault {
    /// Creates a new builder-style object to manufacture [`DependentServiceRequestThrottlingFault`](crate::error::DependentServiceRequestThrottlingFault)
    pub fn builder() -> crate::error::dependent_service_request_throttling_fault::Builder {
        crate::error::dependent_service_request_throttling_fault::Builder::default()
    }
}

/// <p>The snapshot identifier does not refer to an existing cluster snapshot.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ClusterSnapshotNotFoundFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ClusterSnapshotNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ClusterSnapshotNotFoundFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ClusterSnapshotNotFoundFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ClusterSnapshotNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ClusterSnapshotNotFoundFault")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for ClusterSnapshotNotFoundFault {}
/// See [`ClusterSnapshotNotFoundFault`](crate::error::ClusterSnapshotNotFoundFault)
pub mod cluster_snapshot_not_found_fault {
    /// A builder for [`ClusterSnapshotNotFoundFault`](crate::error::ClusterSnapshotNotFoundFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ClusterSnapshotNotFoundFault`](crate::error::ClusterSnapshotNotFoundFault)
        pub fn build(self) -> crate::error::ClusterSnapshotNotFoundFault {
            crate::error::ClusterSnapshotNotFoundFault {
                message: self.message,
            }
        }
    }
}
impl ClusterSnapshotNotFoundFault {
    /// Creates a new builder-style object to manufacture [`ClusterSnapshotNotFoundFault`](crate::error::ClusterSnapshotNotFoundFault)
    pub fn builder() -> crate::error::cluster_snapshot_not_found_fault::Builder {
        crate::error::cluster_snapshot_not_found_fault::Builder::default()
    }
}

/// <p>The specified CIDR IP range or EC2 security group is not authorized for the
/// specified cluster security group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AuthorizationNotFoundFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AuthorizationNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AuthorizationNotFoundFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AuthorizationNotFoundFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AuthorizationNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AuthorizationNotFoundFault")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for AuthorizationNotFoundFault {}
/// See [`AuthorizationNotFoundFault`](crate::error::AuthorizationNotFoundFault)
pub mod authorization_not_found_fault {
    /// A builder for [`AuthorizationNotFoundFault`](crate::error::AuthorizationNotFoundFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AuthorizationNotFoundFault`](crate::error::AuthorizationNotFoundFault)
        pub fn build(self) -> crate::error::AuthorizationNotFoundFault {
            crate::error::AuthorizationNotFoundFault {
                message: self.message,
            }
        }
    }
}
impl AuthorizationNotFoundFault {
    /// Creates a new builder-style object to manufacture [`AuthorizationNotFoundFault`](crate::error::AuthorizationNotFoundFault)
    pub fn builder() -> crate::error::authorization_not_found_fault::Builder {
        crate::error::authorization_not_found_fault::Builder::default()
    }
}

/// <p>The owner of the specified snapshot has not authorized your account to access the
/// snapshot.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessToSnapshotDeniedFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AccessToSnapshotDeniedFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessToSnapshotDeniedFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AccessToSnapshotDeniedFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AccessToSnapshotDeniedFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AccessToSnapshotDeniedFault")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for AccessToSnapshotDeniedFault {}
/// See [`AccessToSnapshotDeniedFault`](crate::error::AccessToSnapshotDeniedFault)
pub mod access_to_snapshot_denied_fault {
    /// A builder for [`AccessToSnapshotDeniedFault`](crate::error::AccessToSnapshotDeniedFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessToSnapshotDeniedFault`](crate::error::AccessToSnapshotDeniedFault)
        pub fn build(self) -> crate::error::AccessToSnapshotDeniedFault {
            crate::error::AccessToSnapshotDeniedFault {
                message: self.message,
            }
        }
    }
}
impl AccessToSnapshotDeniedFault {
    /// Creates a new builder-style object to manufacture [`AccessToSnapshotDeniedFault`](crate::error::AccessToSnapshotDeniedFault)
    pub fn builder() -> crate::error::access_to_snapshot_denied_fault::Builder {
        crate::error::access_to_snapshot_denied_fault::Builder::default()
    }
}

/// <p>The status of the endpoint is not valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidEndpointStateFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidEndpointStateFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidEndpointStateFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidEndpointStateFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidEndpointStateFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidEndpointStateFault")?;
        if let Some(inner_9) = &self.message {
            write!(f, ": {}", inner_9)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidEndpointStateFault {}
/// See [`InvalidEndpointStateFault`](crate::error::InvalidEndpointStateFault)
pub mod invalid_endpoint_state_fault {
    /// A builder for [`InvalidEndpointStateFault`](crate::error::InvalidEndpointStateFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidEndpointStateFault`](crate::error::InvalidEndpointStateFault)
        pub fn build(self) -> crate::error::InvalidEndpointStateFault {
            crate::error::InvalidEndpointStateFault {
                message: self.message,
            }
        }
    }
}
impl InvalidEndpointStateFault {
    /// Creates a new builder-style object to manufacture [`InvalidEndpointStateFault`](crate::error::InvalidEndpointStateFault)
    pub fn builder() -> crate::error::invalid_endpoint_state_fault::Builder {
        crate::error::invalid_endpoint_state_fault::Builder::default()
    }
}

/// <p>The state of the cluster security group is not <code>available</code>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidClusterSecurityGroupStateFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidClusterSecurityGroupStateFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidClusterSecurityGroupStateFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidClusterSecurityGroupStateFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidClusterSecurityGroupStateFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidClusterSecurityGroupStateFault")?;
        if let Some(inner_10) = &self.message {
            write!(f, ": {}", inner_10)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidClusterSecurityGroupStateFault {}
/// See [`InvalidClusterSecurityGroupStateFault`](crate::error::InvalidClusterSecurityGroupStateFault)
pub mod invalid_cluster_security_group_state_fault {
    /// A builder for [`InvalidClusterSecurityGroupStateFault`](crate::error::InvalidClusterSecurityGroupStateFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidClusterSecurityGroupStateFault`](crate::error::InvalidClusterSecurityGroupStateFault)
        pub fn build(self) -> crate::error::InvalidClusterSecurityGroupStateFault {
            crate::error::InvalidClusterSecurityGroupStateFault {
                message: self.message,
            }
        }
    }
}
impl InvalidClusterSecurityGroupStateFault {
    /// Creates a new builder-style object to manufacture [`InvalidClusterSecurityGroupStateFault`](crate::error::InvalidClusterSecurityGroupStateFault)
    pub fn builder() -> crate::error::invalid_cluster_security_group_state_fault::Builder {
        crate::error::invalid_cluster_security_group_state_fault::Builder::default()
    }
}

/// <p>The status of the authorization is not valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidAuthorizationStateFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidAuthorizationStateFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidAuthorizationStateFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidAuthorizationStateFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidAuthorizationStateFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidAuthorizationStateFault")?;
        if let Some(inner_11) = &self.message {
            write!(f, ": {}", inner_11)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidAuthorizationStateFault {}
/// See [`InvalidAuthorizationStateFault`](crate::error::InvalidAuthorizationStateFault)
pub mod invalid_authorization_state_fault {
    /// A builder for [`InvalidAuthorizationStateFault`](crate::error::InvalidAuthorizationStateFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidAuthorizationStateFault`](crate::error::InvalidAuthorizationStateFault)
        pub fn build(self) -> crate::error::InvalidAuthorizationStateFault {
            crate::error::InvalidAuthorizationStateFault {
                message: self.message,
            }
        }
    }
}
impl InvalidAuthorizationStateFault {
    /// Creates a new builder-style object to manufacture [`InvalidAuthorizationStateFault`](crate::error::InvalidAuthorizationStateFault)
    pub fn builder() -> crate::error::invalid_authorization_state_fault::Builder {
        crate::error::invalid_authorization_state_fault::Builder::default()
    }
}

/// <p>The endpoint name doesn't refer to an existing endpoint.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EndpointNotFoundFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for EndpointNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EndpointNotFoundFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl EndpointNotFoundFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for EndpointNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "EndpointNotFoundFault")?;
        if let Some(inner_12) = &self.message {
            write!(f, ": {}", inner_12)?;
        }
        Ok(())
    }
}
impl std::error::Error for EndpointNotFoundFault {}
/// See [`EndpointNotFoundFault`](crate::error::EndpointNotFoundFault)
pub mod endpoint_not_found_fault {
    /// A builder for [`EndpointNotFoundFault`](crate::error::EndpointNotFoundFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`EndpointNotFoundFault`](crate::error::EndpointNotFoundFault)
        pub fn build(self) -> crate::error::EndpointNotFoundFault {
            crate::error::EndpointNotFoundFault {
                message: self.message,
            }
        }
    }
}
impl EndpointNotFoundFault {
    /// Creates a new builder-style object to manufacture [`EndpointNotFoundFault`](crate::error::EndpointNotFoundFault)
    pub fn builder() -> crate::error::endpoint_not_found_fault::Builder {
        crate::error::endpoint_not_found_fault::Builder::default()
    }
}

/// <p>The authorization for this endpoint can't be found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EndpointAuthorizationNotFoundFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for EndpointAuthorizationNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EndpointAuthorizationNotFoundFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl EndpointAuthorizationNotFoundFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for EndpointAuthorizationNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "EndpointAuthorizationNotFoundFault")?;
        if let Some(inner_13) = &self.message {
            write!(f, ": {}", inner_13)?;
        }
        Ok(())
    }
}
impl std::error::Error for EndpointAuthorizationNotFoundFault {}
/// See [`EndpointAuthorizationNotFoundFault`](crate::error::EndpointAuthorizationNotFoundFault)
pub mod endpoint_authorization_not_found_fault {
    /// A builder for [`EndpointAuthorizationNotFoundFault`](crate::error::EndpointAuthorizationNotFoundFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`EndpointAuthorizationNotFoundFault`](crate::error::EndpointAuthorizationNotFoundFault)
        pub fn build(self) -> crate::error::EndpointAuthorizationNotFoundFault {
            crate::error::EndpointAuthorizationNotFoundFault {
                message: self.message,
            }
        }
    }
}
impl EndpointAuthorizationNotFoundFault {
    /// Creates a new builder-style object to manufacture [`EndpointAuthorizationNotFoundFault`](crate::error::EndpointAuthorizationNotFoundFault)
    pub fn builder() -> crate::error::endpoint_authorization_not_found_fault::Builder {
        crate::error::endpoint_authorization_not_found_fault::Builder::default()
    }
}

/// <p>The cluster security group name does not refer to an existing cluster security
/// group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ClusterSecurityGroupNotFoundFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ClusterSecurityGroupNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ClusterSecurityGroupNotFoundFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ClusterSecurityGroupNotFoundFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ClusterSecurityGroupNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ClusterSecurityGroupNotFoundFault")?;
        if let Some(inner_14) = &self.message {
            write!(f, ": {}", inner_14)?;
        }
        Ok(())
    }
}
impl std::error::Error for ClusterSecurityGroupNotFoundFault {}
/// See [`ClusterSecurityGroupNotFoundFault`](crate::error::ClusterSecurityGroupNotFoundFault)
pub mod cluster_security_group_not_found_fault {
    /// A builder for [`ClusterSecurityGroupNotFoundFault`](crate::error::ClusterSecurityGroupNotFoundFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ClusterSecurityGroupNotFoundFault`](crate::error::ClusterSecurityGroupNotFoundFault)
        pub fn build(self) -> crate::error::ClusterSecurityGroupNotFoundFault {
            crate::error::ClusterSecurityGroupNotFoundFault {
                message: self.message,
            }
        }
    }
}
impl ClusterSecurityGroupNotFoundFault {
    /// Creates a new builder-style object to manufacture [`ClusterSecurityGroupNotFoundFault`](crate::error::ClusterSecurityGroupNotFoundFault)
    pub fn builder() -> crate::error::cluster_security_group_not_found_fault::Builder {
        crate::error::cluster_security_group_not_found_fault::Builder::default()
    }
}

/// <p>The number of nodes specified exceeds the allotted capacity of the
/// cluster.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InsufficientClusterCapacityFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InsufficientClusterCapacityFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InsufficientClusterCapacityFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InsufficientClusterCapacityFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InsufficientClusterCapacityFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InsufficientClusterCapacityFault")?;
        if let Some(inner_15) = &self.message {
            write!(f, ": {}", inner_15)?;
        }
        Ok(())
    }
}
impl std::error::Error for InsufficientClusterCapacityFault {}
/// See [`InsufficientClusterCapacityFault`](crate::error::InsufficientClusterCapacityFault)
pub mod insufficient_cluster_capacity_fault {
    /// A builder for [`InsufficientClusterCapacityFault`](crate::error::InsufficientClusterCapacityFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InsufficientClusterCapacityFault`](crate::error::InsufficientClusterCapacityFault)
        pub fn build(self) -> crate::error::InsufficientClusterCapacityFault {
            crate::error::InsufficientClusterCapacityFault {
                message: self.message,
            }
        }
    }
}
impl InsufficientClusterCapacityFault {
    /// Creates a new builder-style object to manufacture [`InsufficientClusterCapacityFault`](crate::error::InsufficientClusterCapacityFault)
    pub fn builder() -> crate::error::insufficient_cluster_capacity_fault::Builder {
        crate::error::insufficient_cluster_capacity_fault::Builder::default()
    }
}

/// <p>The requested operation isn't supported.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnsupportedOperationFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UnsupportedOperationFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnsupportedOperationFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl UnsupportedOperationFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for UnsupportedOperationFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "UnsupportedOperationFault")?;
        if let Some(inner_16) = &self.message {
            write!(f, ": {}", inner_16)?;
        }
        Ok(())
    }
}
impl std::error::Error for UnsupportedOperationFault {}
/// See [`UnsupportedOperationFault`](crate::error::UnsupportedOperationFault)
pub mod unsupported_operation_fault {
    /// A builder for [`UnsupportedOperationFault`](crate::error::UnsupportedOperationFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`UnsupportedOperationFault`](crate::error::UnsupportedOperationFault)
        pub fn build(self) -> crate::error::UnsupportedOperationFault {
            crate::error::UnsupportedOperationFault {
                message: self.message,
            }
        }
    }
}
impl UnsupportedOperationFault {
    /// Creates a new builder-style object to manufacture [`UnsupportedOperationFault`](crate::error::UnsupportedOperationFault)
    pub fn builder() -> crate::error::unsupported_operation_fault::Builder {
        crate::error::unsupported_operation_fault::Builder::default()
    }
}

/// <p>The value specified for the <code>sourceDatabaseName</code>,
/// <code>sourceSchemaName</code>, or <code>sourceTableName</code> parameter, or a
/// combination of these, doesn't exist in the snapshot.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidTableRestoreArgumentFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidTableRestoreArgumentFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidTableRestoreArgumentFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidTableRestoreArgumentFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidTableRestoreArgumentFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidTableRestoreArgumentFault")?;
        if let Some(inner_17) = &self.message {
            write!(f, ": {}", inner_17)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidTableRestoreArgumentFault {}
/// See [`InvalidTableRestoreArgumentFault`](crate::error::InvalidTableRestoreArgumentFault)
pub mod invalid_table_restore_argument_fault {
    /// A builder for [`InvalidTableRestoreArgumentFault`](crate::error::InvalidTableRestoreArgumentFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidTableRestoreArgumentFault`](crate::error::InvalidTableRestoreArgumentFault)
        pub fn build(self) -> crate::error::InvalidTableRestoreArgumentFault {
            crate::error::InvalidTableRestoreArgumentFault {
                message: self.message,
            }
        }
    }
}
impl InvalidTableRestoreArgumentFault {
    /// Creates a new builder-style object to manufacture [`InvalidTableRestoreArgumentFault`](crate::error::InvalidTableRestoreArgumentFault)
    pub fn builder() -> crate::error::invalid_table_restore_argument_fault::Builder {
        crate::error::invalid_table_restore_argument_fault::Builder::default()
    }
}

/// <p>The specified cluster snapshot is not in the <code>available</code> state, or other
/// accounts are authorized to access the snapshot. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidClusterSnapshotStateFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidClusterSnapshotStateFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidClusterSnapshotStateFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidClusterSnapshotStateFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidClusterSnapshotStateFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidClusterSnapshotStateFault")?;
        if let Some(inner_18) = &self.message {
            write!(f, ": {}", inner_18)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidClusterSnapshotStateFault {}
/// See [`InvalidClusterSnapshotStateFault`](crate::error::InvalidClusterSnapshotStateFault)
pub mod invalid_cluster_snapshot_state_fault {
    /// A builder for [`InvalidClusterSnapshotStateFault`](crate::error::InvalidClusterSnapshotStateFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidClusterSnapshotStateFault`](crate::error::InvalidClusterSnapshotStateFault)
        pub fn build(self) -> crate::error::InvalidClusterSnapshotStateFault {
            crate::error::InvalidClusterSnapshotStateFault {
                message: self.message,
            }
        }
    }
}
impl InvalidClusterSnapshotStateFault {
    /// Creates a new builder-style object to manufacture [`InvalidClusterSnapshotStateFault`](crate::error::InvalidClusterSnapshotStateFault)
    pub fn builder() -> crate::error::invalid_cluster_snapshot_state_fault::Builder {
        crate::error::invalid_cluster_snapshot_state_fault::Builder::default()
    }
}

/// <p>You have exceeded the allowed number of table restore requests. Wait for your
/// current table restore requests to complete before making a new request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InProgressTableRestoreQuotaExceededFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InProgressTableRestoreQuotaExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InProgressTableRestoreQuotaExceededFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InProgressTableRestoreQuotaExceededFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InProgressTableRestoreQuotaExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InProgressTableRestoreQuotaExceededFault")?;
        if let Some(inner_19) = &self.message {
            write!(f, ": {}", inner_19)?;
        }
        Ok(())
    }
}
impl std::error::Error for InProgressTableRestoreQuotaExceededFault {}
/// See [`InProgressTableRestoreQuotaExceededFault`](crate::error::InProgressTableRestoreQuotaExceededFault)
pub mod in_progress_table_restore_quota_exceeded_fault {
    /// A builder for [`InProgressTableRestoreQuotaExceededFault`](crate::error::InProgressTableRestoreQuotaExceededFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InProgressTableRestoreQuotaExceededFault`](crate::error::InProgressTableRestoreQuotaExceededFault)
        pub fn build(self) -> crate::error::InProgressTableRestoreQuotaExceededFault {
            crate::error::InProgressTableRestoreQuotaExceededFault {
                message: self.message,
            }
        }
    }
}
impl InProgressTableRestoreQuotaExceededFault {
    /// Creates a new builder-style object to manufacture [`InProgressTableRestoreQuotaExceededFault`](crate::error::InProgressTableRestoreQuotaExceededFault)
    pub fn builder() -> crate::error::in_progress_table_restore_quota_exceeded_fault::Builder {
        crate::error::in_progress_table_restore_quota_exceeded_fault::Builder::default()
    }
}

/// <p>Your account is not authorized to perform the requested operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnauthorizedOperation {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UnauthorizedOperation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnauthorizedOperation");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl UnauthorizedOperation {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for UnauthorizedOperation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "UnauthorizedOperation")?;
        if let Some(inner_20) = &self.message {
            write!(f, ": {}", inner_20)?;
        }
        Ok(())
    }
}
impl std::error::Error for UnauthorizedOperation {}
/// See [`UnauthorizedOperation`](crate::error::UnauthorizedOperation)
pub mod unauthorized_operation {
    /// A builder for [`UnauthorizedOperation`](crate::error::UnauthorizedOperation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`UnauthorizedOperation`](crate::error::UnauthorizedOperation)
        pub fn build(self) -> crate::error::UnauthorizedOperation {
            crate::error::UnauthorizedOperation {
                message: self.message,
            }
        }
    }
}
impl UnauthorizedOperation {
    /// Creates a new builder-style object to manufacture [`UnauthorizedOperation`](crate::error::UnauthorizedOperation)
    pub fn builder() -> crate::error::unauthorized_operation::Builder {
        crate::error::unauthorized_operation::Builder::default()
    }
}

/// <p>You have exceeded the number of tags allowed.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagLimitExceededFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TagLimitExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagLimitExceededFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TagLimitExceededFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TagLimitExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TagLimitExceededFault")?;
        if let Some(inner_21) = &self.message {
            write!(f, ": {}", inner_21)?;
        }
        Ok(())
    }
}
impl std::error::Error for TagLimitExceededFault {}
/// See [`TagLimitExceededFault`](crate::error::TagLimitExceededFault)
pub mod tag_limit_exceeded_fault {
    /// A builder for [`TagLimitExceededFault`](crate::error::TagLimitExceededFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TagLimitExceededFault`](crate::error::TagLimitExceededFault)
        pub fn build(self) -> crate::error::TagLimitExceededFault {
            crate::error::TagLimitExceededFault {
                message: self.message,
            }
        }
    }
}
impl TagLimitExceededFault {
    /// Creates a new builder-style object to manufacture [`TagLimitExceededFault`](crate::error::TagLimitExceededFault)
    pub fn builder() -> crate::error::tag_limit_exceeded_fault::Builder {
        crate::error::tag_limit_exceeded_fault::Builder::default()
    }
}

/// <p>We could not find the specified snapshot schedule. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SnapshotScheduleNotFoundFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SnapshotScheduleNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SnapshotScheduleNotFoundFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl SnapshotScheduleNotFoundFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for SnapshotScheduleNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "SnapshotScheduleNotFoundFault")?;
        if let Some(inner_22) = &self.message {
            write!(f, ": {}", inner_22)?;
        }
        Ok(())
    }
}
impl std::error::Error for SnapshotScheduleNotFoundFault {}
/// See [`SnapshotScheduleNotFoundFault`](crate::error::SnapshotScheduleNotFoundFault)
pub mod snapshot_schedule_not_found_fault {
    /// A builder for [`SnapshotScheduleNotFoundFault`](crate::error::SnapshotScheduleNotFoundFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`SnapshotScheduleNotFoundFault`](crate::error::SnapshotScheduleNotFoundFault)
        pub fn build(self) -> crate::error::SnapshotScheduleNotFoundFault {
            crate::error::SnapshotScheduleNotFoundFault {
                message: self.message,
            }
        }
    }
}
impl SnapshotScheduleNotFoundFault {
    /// Creates a new builder-style object to manufacture [`SnapshotScheduleNotFoundFault`](crate::error::SnapshotScheduleNotFoundFault)
    pub fn builder() -> crate::error::snapshot_schedule_not_found_fault::Builder {
        crate::error::snapshot_schedule_not_found_fault::Builder::default()
    }
}

/// <p>The operation would exceed the number of nodes allotted to the account.
///
/// For information about increasing your quota, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon Redshift</a>
/// in the <i>Amazon Redshift Cluster Management Guide</i>.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NumberOfNodesQuotaExceededFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NumberOfNodesQuotaExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NumberOfNodesQuotaExceededFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl NumberOfNodesQuotaExceededFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NumberOfNodesQuotaExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NumberOfNodesQuotaExceededFault")?;
        if let Some(inner_23) = &self.message {
            write!(f, ": {}", inner_23)?;
        }
        Ok(())
    }
}
impl std::error::Error for NumberOfNodesQuotaExceededFault {}
/// See [`NumberOfNodesQuotaExceededFault`](crate::error::NumberOfNodesQuotaExceededFault)
pub mod number_of_nodes_quota_exceeded_fault {
    /// A builder for [`NumberOfNodesQuotaExceededFault`](crate::error::NumberOfNodesQuotaExceededFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`NumberOfNodesQuotaExceededFault`](crate::error::NumberOfNodesQuotaExceededFault)
        pub fn build(self) -> crate::error::NumberOfNodesQuotaExceededFault {
            crate::error::NumberOfNodesQuotaExceededFault {
                message: self.message,
            }
        }
    }
}
impl NumberOfNodesQuotaExceededFault {
    /// Creates a new builder-style object to manufacture [`NumberOfNodesQuotaExceededFault`](crate::error::NumberOfNodesQuotaExceededFault)
    pub fn builder() -> crate::error::number_of_nodes_quota_exceeded_fault::Builder {
        crate::error::number_of_nodes_quota_exceeded_fault::Builder::default()
    }
}

/// <p>The operation would exceed the number of nodes allowed for a cluster.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NumberOfNodesPerClusterLimitExceededFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NumberOfNodesPerClusterLimitExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NumberOfNodesPerClusterLimitExceededFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl NumberOfNodesPerClusterLimitExceededFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NumberOfNodesPerClusterLimitExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NumberOfNodesPerClusterLimitExceededFault")?;
        if let Some(inner_24) = &self.message {
            write!(f, ": {}", inner_24)?;
        }
        Ok(())
    }
}
impl std::error::Error for NumberOfNodesPerClusterLimitExceededFault {}
/// See [`NumberOfNodesPerClusterLimitExceededFault`](crate::error::NumberOfNodesPerClusterLimitExceededFault)
pub mod number_of_nodes_per_cluster_limit_exceeded_fault {
    /// A builder for [`NumberOfNodesPerClusterLimitExceededFault`](crate::error::NumberOfNodesPerClusterLimitExceededFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`NumberOfNodesPerClusterLimitExceededFault`](crate::error::NumberOfNodesPerClusterLimitExceededFault)
        pub fn build(self) -> crate::error::NumberOfNodesPerClusterLimitExceededFault {
            crate::error::NumberOfNodesPerClusterLimitExceededFault {
                message: self.message,
            }
        }
    }
}
impl NumberOfNodesPerClusterLimitExceededFault {
    /// Creates a new builder-style object to manufacture [`NumberOfNodesPerClusterLimitExceededFault`](crate::error::NumberOfNodesPerClusterLimitExceededFault)
    pub fn builder() -> crate::error::number_of_nodes_per_cluster_limit_exceeded_fault::Builder {
        crate::error::number_of_nodes_per_cluster_limit_exceeded_fault::Builder::default()
    }
}

/// <p>The encryption key has exceeded its grant limit in Amazon Web Services KMS.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LimitExceededFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for LimitExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LimitExceededFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl LimitExceededFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for LimitExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "LimitExceededFault")?;
        if let Some(inner_25) = &self.message {
            write!(f, ": {}", inner_25)?;
        }
        Ok(())
    }
}
impl std::error::Error for LimitExceededFault {}
/// See [`LimitExceededFault`](crate::error::LimitExceededFault)
pub mod limit_exceeded_fault {
    /// A builder for [`LimitExceededFault`](crate::error::LimitExceededFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`LimitExceededFault`](crate::error::LimitExceededFault)
        pub fn build(self) -> crate::error::LimitExceededFault {
            crate::error::LimitExceededFault {
                message: self.message,
            }
        }
    }
}
impl LimitExceededFault {
    /// Creates a new builder-style object to manufacture [`LimitExceededFault`](crate::error::LimitExceededFault)
    pub fn builder() -> crate::error::limit_exceeded_fault::Builder {
        crate::error::limit_exceeded_fault::Builder::default()
    }
}

/// <p>The cluster subnet group does not cover all Availability Zones.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidVpcNetworkStateFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidVpcNetworkStateFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidVpcNetworkStateFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidVpcNetworkStateFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidVpcNetworkStateFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "InvalidVpcNetworkStateFault [InvalidVPCNetworkStateFault]"
        )?;
        if let Some(inner_26) = &self.message {
            write!(f, ": {}", inner_26)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidVpcNetworkStateFault {}
/// See [`InvalidVpcNetworkStateFault`](crate::error::InvalidVpcNetworkStateFault)
pub mod invalid_vpc_network_state_fault {
    /// A builder for [`InvalidVpcNetworkStateFault`](crate::error::InvalidVpcNetworkStateFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidVpcNetworkStateFault`](crate::error::InvalidVpcNetworkStateFault)
        pub fn build(self) -> crate::error::InvalidVpcNetworkStateFault {
            crate::error::InvalidVpcNetworkStateFault {
                message: self.message,
            }
        }
    }
}
impl InvalidVpcNetworkStateFault {
    /// Creates a new builder-style object to manufacture [`InvalidVpcNetworkStateFault`](crate::error::InvalidVpcNetworkStateFault)
    pub fn builder() -> crate::error::invalid_vpc_network_state_fault::Builder {
        crate::error::invalid_vpc_network_state_fault::Builder::default()
    }
}

/// <p>The tag is invalid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidTagFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidTagFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidTagFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidTagFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidTagFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidTagFault")?;
        if let Some(inner_27) = &self.message {
            write!(f, ": {}", inner_27)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidTagFault {}
/// See [`InvalidTagFault`](crate::error::InvalidTagFault)
pub mod invalid_tag_fault {
    /// A builder for [`InvalidTagFault`](crate::error::InvalidTagFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidTagFault`](crate::error::InvalidTagFault)
        pub fn build(self) -> crate::error::InvalidTagFault {
            crate::error::InvalidTagFault {
                message: self.message,
            }
        }
    }
}
impl InvalidTagFault {
    /// Creates a new builder-style object to manufacture [`InvalidTagFault`](crate::error::InvalidTagFault)
    pub fn builder() -> crate::error::invalid_tag_fault::Builder {
        crate::error::invalid_tag_fault::Builder::default()
    }
}

/// <p>The requested subnet is not valid, or not all of the subnets are in the same
/// VPC.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidSubnet {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidSubnet {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidSubnet");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidSubnet {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidSubnet {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidSubnet")?;
        if let Some(inner_28) = &self.message {
            write!(f, ": {}", inner_28)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidSubnet {}
/// See [`InvalidSubnet`](crate::error::InvalidSubnet)
pub mod invalid_subnet {
    /// A builder for [`InvalidSubnet`](crate::error::InvalidSubnet)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidSubnet`](crate::error::InvalidSubnet)
        pub fn build(self) -> crate::error::InvalidSubnet {
            crate::error::InvalidSubnet {
                message: self.message,
            }
        }
    }
}
impl InvalidSubnet {
    /// Creates a new builder-style object to manufacture [`InvalidSubnet`](crate::error::InvalidSubnet)
    pub fn builder() -> crate::error::invalid_subnet::Builder {
        crate::error::invalid_subnet::Builder::default()
    }
}

/// <p>The restore is invalid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidRestoreFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidRestoreFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidRestoreFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidRestoreFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidRestoreFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidRestoreFault")?;
        if let Some(inner_29) = &self.message {
            write!(f, ": {}", inner_29)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidRestoreFault {}
/// See [`InvalidRestoreFault`](crate::error::InvalidRestoreFault)
pub mod invalid_restore_fault {
    /// A builder for [`InvalidRestoreFault`](crate::error::InvalidRestoreFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidRestoreFault`](crate::error::InvalidRestoreFault)
        pub fn build(self) -> crate::error::InvalidRestoreFault {
            crate::error::InvalidRestoreFault {
                message: self.message,
            }
        }
    }
}
impl InvalidRestoreFault {
    /// Creates a new builder-style object to manufacture [`InvalidRestoreFault`](crate::error::InvalidRestoreFault)
    pub fn builder() -> crate::error::invalid_restore_fault::Builder {
        crate::error::invalid_restore_fault::Builder::default()
    }
}

/// <p>The Elastic IP (EIP) is invalid or cannot be found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidElasticIpFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidElasticIpFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidElasticIpFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidElasticIpFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidElasticIpFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidElasticIpFault")?;
        if let Some(inner_30) = &self.message {
            write!(f, ": {}", inner_30)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidElasticIpFault {}
/// See [`InvalidElasticIpFault`](crate::error::InvalidElasticIpFault)
pub mod invalid_elastic_ip_fault {
    /// A builder for [`InvalidElasticIpFault`](crate::error::InvalidElasticIpFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidElasticIpFault`](crate::error::InvalidElasticIpFault)
        pub fn build(self) -> crate::error::InvalidElasticIpFault {
            crate::error::InvalidElasticIpFault {
                message: self.message,
            }
        }
    }
}
impl InvalidElasticIpFault {
    /// Creates a new builder-style object to manufacture [`InvalidElasticIpFault`](crate::error::InvalidElasticIpFault)
    pub fn builder() -> crate::error::invalid_elastic_ip_fault::Builder {
        crate::error::invalid_elastic_ip_fault::Builder::default()
    }
}

/// <p>The provided cluster track name is not valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidClusterTrackFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidClusterTrackFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidClusterTrackFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidClusterTrackFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidClusterTrackFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidClusterTrackFault")?;
        if let Some(inner_31) = &self.message {
            write!(f, ": {}", inner_31)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidClusterTrackFault {}
/// See [`InvalidClusterTrackFault`](crate::error::InvalidClusterTrackFault)
pub mod invalid_cluster_track_fault {
    /// A builder for [`InvalidClusterTrackFault`](crate::error::InvalidClusterTrackFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidClusterTrackFault`](crate::error::InvalidClusterTrackFault)
        pub fn build(self) -> crate::error::InvalidClusterTrackFault {
            crate::error::InvalidClusterTrackFault {
                message: self.message,
            }
        }
    }
}
impl InvalidClusterTrackFault {
    /// Creates a new builder-style object to manufacture [`InvalidClusterTrackFault`](crate::error::InvalidClusterTrackFault)
    pub fn builder() -> crate::error::invalid_cluster_track_fault::Builder {
        crate::error::invalid_cluster_track_fault::Builder::default()
    }
}

/// <p>The cluster subnet group cannot be deleted because it is in use.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidClusterSubnetGroupStateFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidClusterSubnetGroupStateFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidClusterSubnetGroupStateFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidClusterSubnetGroupStateFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidClusterSubnetGroupStateFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidClusterSubnetGroupStateFault")?;
        if let Some(inner_32) = &self.message {
            write!(f, ": {}", inner_32)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidClusterSubnetGroupStateFault {}
/// See [`InvalidClusterSubnetGroupStateFault`](crate::error::InvalidClusterSubnetGroupStateFault)
pub mod invalid_cluster_subnet_group_state_fault {
    /// A builder for [`InvalidClusterSubnetGroupStateFault`](crate::error::InvalidClusterSubnetGroupStateFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidClusterSubnetGroupStateFault`](crate::error::InvalidClusterSubnetGroupStateFault)
        pub fn build(self) -> crate::error::InvalidClusterSubnetGroupStateFault {
            crate::error::InvalidClusterSubnetGroupStateFault {
                message: self.message,
            }
        }
    }
}
impl InvalidClusterSubnetGroupStateFault {
    /// Creates a new builder-style object to manufacture [`InvalidClusterSubnetGroupStateFault`](crate::error::InvalidClusterSubnetGroupStateFault)
    pub fn builder() -> crate::error::invalid_cluster_subnet_group_state_fault::Builder {
        crate::error::invalid_cluster_subnet_group_state_fault::Builder::default()
    }
}

/// <p>There is no Amazon Redshift HSM configuration with the specified identifier.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HsmConfigurationNotFoundFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for HsmConfigurationNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HsmConfigurationNotFoundFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl HsmConfigurationNotFoundFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for HsmConfigurationNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "HsmConfigurationNotFoundFault")?;
        if let Some(inner_33) = &self.message {
            write!(f, ": {}", inner_33)?;
        }
        Ok(())
    }
}
impl std::error::Error for HsmConfigurationNotFoundFault {}
/// See [`HsmConfigurationNotFoundFault`](crate::error::HsmConfigurationNotFoundFault)
pub mod hsm_configuration_not_found_fault {
    /// A builder for [`HsmConfigurationNotFoundFault`](crate::error::HsmConfigurationNotFoundFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`HsmConfigurationNotFoundFault`](crate::error::HsmConfigurationNotFoundFault)
        pub fn build(self) -> crate::error::HsmConfigurationNotFoundFault {
            crate::error::HsmConfigurationNotFoundFault {
                message: self.message,
            }
        }
    }
}
impl HsmConfigurationNotFoundFault {
    /// Creates a new builder-style object to manufacture [`HsmConfigurationNotFoundFault`](crate::error::HsmConfigurationNotFoundFault)
    pub fn builder() -> crate::error::hsm_configuration_not_found_fault::Builder {
        crate::error::hsm_configuration_not_found_fault::Builder::default()
    }
}

/// <p>There is no Amazon Redshift HSM client certificate with the specified
/// identifier.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HsmClientCertificateNotFoundFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for HsmClientCertificateNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HsmClientCertificateNotFoundFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl HsmClientCertificateNotFoundFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for HsmClientCertificateNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "HsmClientCertificateNotFoundFault")?;
        if let Some(inner_34) = &self.message {
            write!(f, ": {}", inner_34)?;
        }
        Ok(())
    }
}
impl std::error::Error for HsmClientCertificateNotFoundFault {}
/// See [`HsmClientCertificateNotFoundFault`](crate::error::HsmClientCertificateNotFoundFault)
pub mod hsm_client_certificate_not_found_fault {
    /// A builder for [`HsmClientCertificateNotFoundFault`](crate::error::HsmClientCertificateNotFoundFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`HsmClientCertificateNotFoundFault`](crate::error::HsmClientCertificateNotFoundFault)
        pub fn build(self) -> crate::error::HsmClientCertificateNotFoundFault {
            crate::error::HsmClientCertificateNotFoundFault {
                message: self.message,
            }
        }
    }
}
impl HsmClientCertificateNotFoundFault {
    /// Creates a new builder-style object to manufacture [`HsmClientCertificateNotFoundFault`](crate::error::HsmClientCertificateNotFoundFault)
    pub fn builder() -> crate::error::hsm_client_certificate_not_found_fault::Builder {
        crate::error::hsm_client_certificate_not_found_fault::Builder::default()
    }
}

/// <p>The cluster subnet group name does not refer to an existing cluster subnet
/// group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ClusterSubnetGroupNotFoundFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ClusterSubnetGroupNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ClusterSubnetGroupNotFoundFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ClusterSubnetGroupNotFoundFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ClusterSubnetGroupNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ClusterSubnetGroupNotFoundFault")?;
        if let Some(inner_35) = &self.message {
            write!(f, ": {}", inner_35)?;
        }
        Ok(())
    }
}
impl std::error::Error for ClusterSubnetGroupNotFoundFault {}
/// See [`ClusterSubnetGroupNotFoundFault`](crate::error::ClusterSubnetGroupNotFoundFault)
pub mod cluster_subnet_group_not_found_fault {
    /// A builder for [`ClusterSubnetGroupNotFoundFault`](crate::error::ClusterSubnetGroupNotFoundFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ClusterSubnetGroupNotFoundFault`](crate::error::ClusterSubnetGroupNotFoundFault)
        pub fn build(self) -> crate::error::ClusterSubnetGroupNotFoundFault {
            crate::error::ClusterSubnetGroupNotFoundFault {
                message: self.message,
            }
        }
    }
}
impl ClusterSubnetGroupNotFoundFault {
    /// Creates a new builder-style object to manufacture [`ClusterSubnetGroupNotFoundFault`](crate::error::ClusterSubnetGroupNotFoundFault)
    pub fn builder() -> crate::error::cluster_subnet_group_not_found_fault::Builder {
        crate::error::cluster_subnet_group_not_found_fault::Builder::default()
    }
}

/// <p>The request would exceed the allowed number of cluster instances for this account.
///
/// For information about increasing your quota, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon Redshift</a>
/// in the <i>Amazon Redshift Cluster Management Guide</i>.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ClusterQuotaExceededFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ClusterQuotaExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ClusterQuotaExceededFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ClusterQuotaExceededFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ClusterQuotaExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ClusterQuotaExceededFault")?;
        if let Some(inner_36) = &self.message {
            write!(f, ": {}", inner_36)?;
        }
        Ok(())
    }
}
impl std::error::Error for ClusterQuotaExceededFault {}
/// See [`ClusterQuotaExceededFault`](crate::error::ClusterQuotaExceededFault)
pub mod cluster_quota_exceeded_fault {
    /// A builder for [`ClusterQuotaExceededFault`](crate::error::ClusterQuotaExceededFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ClusterQuotaExceededFault`](crate::error::ClusterQuotaExceededFault)
        pub fn build(self) -> crate::error::ClusterQuotaExceededFault {
            crate::error::ClusterQuotaExceededFault {
                message: self.message,
            }
        }
    }
}
impl ClusterQuotaExceededFault {
    /// Creates a new builder-style object to manufacture [`ClusterQuotaExceededFault`](crate::error::ClusterQuotaExceededFault)
    pub fn builder() -> crate::error::cluster_quota_exceeded_fault::Builder {
        crate::error::cluster_quota_exceeded_fault::Builder::default()
    }
}

/// <p>The parameter group name does not refer to an existing parameter group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ClusterParameterGroupNotFoundFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ClusterParameterGroupNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ClusterParameterGroupNotFoundFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ClusterParameterGroupNotFoundFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ClusterParameterGroupNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ClusterParameterGroupNotFoundFault")?;
        if let Some(inner_37) = &self.message {
            write!(f, ": {}", inner_37)?;
        }
        Ok(())
    }
}
impl std::error::Error for ClusterParameterGroupNotFoundFault {}
/// See [`ClusterParameterGroupNotFoundFault`](crate::error::ClusterParameterGroupNotFoundFault)
pub mod cluster_parameter_group_not_found_fault {
    /// A builder for [`ClusterParameterGroupNotFoundFault`](crate::error::ClusterParameterGroupNotFoundFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ClusterParameterGroupNotFoundFault`](crate::error::ClusterParameterGroupNotFoundFault)
        pub fn build(self) -> crate::error::ClusterParameterGroupNotFoundFault {
            crate::error::ClusterParameterGroupNotFoundFault {
                message: self.message,
            }
        }
    }
}
impl ClusterParameterGroupNotFoundFault {
    /// Creates a new builder-style object to manufacture [`ClusterParameterGroupNotFoundFault`](crate::error::ClusterParameterGroupNotFoundFault)
    pub fn builder() -> crate::error::cluster_parameter_group_not_found_fault::Builder {
        crate::error::cluster_parameter_group_not_found_fault::Builder::default()
    }
}

/// <p>The account already has a cluster with the given identifier.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ClusterAlreadyExistsFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ClusterAlreadyExistsFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ClusterAlreadyExistsFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ClusterAlreadyExistsFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ClusterAlreadyExistsFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ClusterAlreadyExistsFault")?;
        if let Some(inner_38) = &self.message {
            write!(f, ": {}", inner_38)?;
        }
        Ok(())
    }
}
impl std::error::Error for ClusterAlreadyExistsFault {}
/// See [`ClusterAlreadyExistsFault`](crate::error::ClusterAlreadyExistsFault)
pub mod cluster_already_exists_fault {
    /// A builder for [`ClusterAlreadyExistsFault`](crate::error::ClusterAlreadyExistsFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ClusterAlreadyExistsFault`](crate::error::ClusterAlreadyExistsFault)
        pub fn build(self) -> crate::error::ClusterAlreadyExistsFault {
            crate::error::ClusterAlreadyExistsFault {
                message: self.message,
            }
        }
    }
}
impl ClusterAlreadyExistsFault {
    /// Creates a new builder-style object to manufacture [`ClusterAlreadyExistsFault`](crate::error::ClusterAlreadyExistsFault)
    pub fn builder() -> crate::error::cluster_already_exists_fault::Builder {
        crate::error::cluster_already_exists_fault::Builder::default()
    }
}

/// <p>A request option was specified that is not supported.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnsupportedOptionFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UnsupportedOptionFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnsupportedOptionFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl UnsupportedOptionFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for UnsupportedOptionFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "UnsupportedOptionFault")?;
        if let Some(inner_39) = &self.message {
            write!(f, ": {}", inner_39)?;
        }
        Ok(())
    }
}
impl std::error::Error for UnsupportedOptionFault {}
/// See [`UnsupportedOptionFault`](crate::error::UnsupportedOptionFault)
pub mod unsupported_option_fault {
    /// A builder for [`UnsupportedOptionFault`](crate::error::UnsupportedOptionFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`UnsupportedOptionFault`](crate::error::UnsupportedOptionFault)
        pub fn build(self) -> crate::error::UnsupportedOptionFault {
            crate::error::UnsupportedOptionFault {
                message: self.message,
            }
        }
    }
}
impl UnsupportedOptionFault {
    /// Creates a new builder-style object to manufacture [`UnsupportedOptionFault`](crate::error::UnsupportedOptionFault)
    pub fn builder() -> crate::error::unsupported_option_fault::Builder {
        crate::error::unsupported_option_fault::Builder::default()
    }
}

/// <p>The cluster parameter group action can not be completed because another task is in
/// progress that involves the parameter group. Wait a few moments and try the operation
/// again.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidClusterParameterGroupStateFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidClusterParameterGroupStateFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidClusterParameterGroupStateFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidClusterParameterGroupStateFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidClusterParameterGroupStateFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidClusterParameterGroupStateFault")?;
        if let Some(inner_40) = &self.message {
            write!(f, ": {}", inner_40)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidClusterParameterGroupStateFault {}
/// See [`InvalidClusterParameterGroupStateFault`](crate::error::InvalidClusterParameterGroupStateFault)
pub mod invalid_cluster_parameter_group_state_fault {
    /// A builder for [`InvalidClusterParameterGroupStateFault`](crate::error::InvalidClusterParameterGroupStateFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidClusterParameterGroupStateFault`](crate::error::InvalidClusterParameterGroupStateFault)
        pub fn build(self) -> crate::error::InvalidClusterParameterGroupStateFault {
            crate::error::InvalidClusterParameterGroupStateFault {
                message: self.message,
            }
        }
    }
}
impl InvalidClusterParameterGroupStateFault {
    /// Creates a new builder-style object to manufacture [`InvalidClusterParameterGroupStateFault`](crate::error::InvalidClusterParameterGroupStateFault)
    pub fn builder() -> crate::error::invalid_cluster_parameter_group_state_fault::Builder {
        crate::error::invalid_cluster_parameter_group_state_fault::Builder::default()
    }
}

/// <p>There is an error with the datashare.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidDataShareFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidDataShareFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidDataShareFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidDataShareFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidDataShareFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidDataShareFault")?;
        if let Some(inner_41) = &self.message {
            write!(f, ": {}", inner_41)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidDataShareFault {}
/// See [`InvalidDataShareFault`](crate::error::InvalidDataShareFault)
pub mod invalid_data_share_fault {
    /// A builder for [`InvalidDataShareFault`](crate::error::InvalidDataShareFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidDataShareFault`](crate::error::InvalidDataShareFault)
        pub fn build(self) -> crate::error::InvalidDataShareFault {
            crate::error::InvalidDataShareFault {
                message: self.message,
            }
        }
    }
}
impl InvalidDataShareFault {
    /// Creates a new builder-style object to manufacture [`InvalidDataShareFault`](crate::error::InvalidDataShareFault)
    pub fn builder() -> crate::error::invalid_data_share_fault::Builder {
        crate::error::invalid_data_share_fault::Builder::default()
    }
}

/// <p>Request would exceed the user's compute node quota.
/// For information about increasing your quota, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon Redshift</a>
/// in the <i>Amazon Redshift Cluster Management Guide</i>.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReservedNodeQuotaExceededFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ReservedNodeQuotaExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReservedNodeQuotaExceededFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ReservedNodeQuotaExceededFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ReservedNodeQuotaExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ReservedNodeQuotaExceededFault")?;
        if let Some(inner_42) = &self.message {
            write!(f, ": {}", inner_42)?;
        }
        Ok(())
    }
}
impl std::error::Error for ReservedNodeQuotaExceededFault {}
/// See [`ReservedNodeQuotaExceededFault`](crate::error::ReservedNodeQuotaExceededFault)
pub mod reserved_node_quota_exceeded_fault {
    /// A builder for [`ReservedNodeQuotaExceededFault`](crate::error::ReservedNodeQuotaExceededFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ReservedNodeQuotaExceededFault`](crate::error::ReservedNodeQuotaExceededFault)
        pub fn build(self) -> crate::error::ReservedNodeQuotaExceededFault {
            crate::error::ReservedNodeQuotaExceededFault {
                message: self.message,
            }
        }
    }
}
impl ReservedNodeQuotaExceededFault {
    /// Creates a new builder-style object to manufacture [`ReservedNodeQuotaExceededFault`](crate::error::ReservedNodeQuotaExceededFault)
    pub fn builder() -> crate::error::reserved_node_quota_exceeded_fault::Builder {
        crate::error::reserved_node_quota_exceeded_fault::Builder::default()
    }
}

/// <p>Specified offering does not exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReservedNodeOfferingNotFoundFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ReservedNodeOfferingNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReservedNodeOfferingNotFoundFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ReservedNodeOfferingNotFoundFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ReservedNodeOfferingNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ReservedNodeOfferingNotFoundFault")?;
        if let Some(inner_43) = &self.message {
            write!(f, ": {}", inner_43)?;
        }
        Ok(())
    }
}
impl std::error::Error for ReservedNodeOfferingNotFoundFault {}
/// See [`ReservedNodeOfferingNotFoundFault`](crate::error::ReservedNodeOfferingNotFoundFault)
pub mod reserved_node_offering_not_found_fault {
    /// A builder for [`ReservedNodeOfferingNotFoundFault`](crate::error::ReservedNodeOfferingNotFoundFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ReservedNodeOfferingNotFoundFault`](crate::error::ReservedNodeOfferingNotFoundFault)
        pub fn build(self) -> crate::error::ReservedNodeOfferingNotFoundFault {
            crate::error::ReservedNodeOfferingNotFoundFault {
                message: self.message,
            }
        }
    }
}
impl ReservedNodeOfferingNotFoundFault {
    /// Creates a new builder-style object to manufacture [`ReservedNodeOfferingNotFoundFault`](crate::error::ReservedNodeOfferingNotFoundFault)
    pub fn builder() -> crate::error::reserved_node_offering_not_found_fault::Builder {
        crate::error::reserved_node_offering_not_found_fault::Builder::default()
    }
}

/// <p>User already has a reservation with the given identifier.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReservedNodeAlreadyExistsFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ReservedNodeAlreadyExistsFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReservedNodeAlreadyExistsFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ReservedNodeAlreadyExistsFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ReservedNodeAlreadyExistsFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ReservedNodeAlreadyExistsFault")?;
        if let Some(inner_44) = &self.message {
            write!(f, ": {}", inner_44)?;
        }
        Ok(())
    }
}
impl std::error::Error for ReservedNodeAlreadyExistsFault {}
/// See [`ReservedNodeAlreadyExistsFault`](crate::error::ReservedNodeAlreadyExistsFault)
pub mod reserved_node_already_exists_fault {
    /// A builder for [`ReservedNodeAlreadyExistsFault`](crate::error::ReservedNodeAlreadyExistsFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ReservedNodeAlreadyExistsFault`](crate::error::ReservedNodeAlreadyExistsFault)
        pub fn build(self) -> crate::error::ReservedNodeAlreadyExistsFault {
            crate::error::ReservedNodeAlreadyExistsFault {
                message: self.message,
            }
        }
    }
}
impl ReservedNodeAlreadyExistsFault {
    /// Creates a new builder-style object to manufacture [`ReservedNodeAlreadyExistsFault`](crate::error::ReservedNodeAlreadyExistsFault)
    pub fn builder() -> crate::error::reserved_node_already_exists_fault::Builder {
        crate::error::reserved_node_already_exists_fault::Builder::default()
    }
}

/// <p>The usage limit identifier can't be found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UsageLimitNotFoundFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UsageLimitNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UsageLimitNotFoundFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl UsageLimitNotFoundFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for UsageLimitNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "UsageLimitNotFoundFault")?;
        if let Some(inner_45) = &self.message {
            write!(f, ": {}", inner_45)?;
        }
        Ok(())
    }
}
impl std::error::Error for UsageLimitNotFoundFault {}
/// See [`UsageLimitNotFoundFault`](crate::error::UsageLimitNotFoundFault)
pub mod usage_limit_not_found_fault {
    /// A builder for [`UsageLimitNotFoundFault`](crate::error::UsageLimitNotFoundFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`UsageLimitNotFoundFault`](crate::error::UsageLimitNotFoundFault)
        pub fn build(self) -> crate::error::UsageLimitNotFoundFault {
            crate::error::UsageLimitNotFoundFault {
                message: self.message,
            }
        }
    }
}
impl UsageLimitNotFoundFault {
    /// Creates a new builder-style object to manufacture [`UsageLimitNotFoundFault`](crate::error::UsageLimitNotFoundFault)
    pub fn builder() -> crate::error::usage_limit_not_found_fault::Builder {
        crate::error::usage_limit_not_found_fault::Builder::default()
    }
}

/// <p>The usage limit is not valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidUsageLimitFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidUsageLimitFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidUsageLimitFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidUsageLimitFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidUsageLimitFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidUsageLimitFault")?;
        if let Some(inner_46) = &self.message {
            write!(f, ": {}", inner_46)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidUsageLimitFault {}
/// See [`InvalidUsageLimitFault`](crate::error::InvalidUsageLimitFault)
pub mod invalid_usage_limit_fault {
    /// A builder for [`InvalidUsageLimitFault`](crate::error::InvalidUsageLimitFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidUsageLimitFault`](crate::error::InvalidUsageLimitFault)
        pub fn build(self) -> crate::error::InvalidUsageLimitFault {
            crate::error::InvalidUsageLimitFault {
                message: self.message,
            }
        }
    }
}
impl InvalidUsageLimitFault {
    /// Creates a new builder-style object to manufacture [`InvalidUsageLimitFault`](crate::error::InvalidUsageLimitFault)
    pub fn builder() -> crate::error::invalid_usage_limit_fault::Builder {
        crate::error::invalid_usage_limit_fault::Builder::default()
    }
}

/// <p>The specified snapshot schedule is already being updated.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SnapshotScheduleUpdateInProgressFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SnapshotScheduleUpdateInProgressFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SnapshotScheduleUpdateInProgressFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl SnapshotScheduleUpdateInProgressFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for SnapshotScheduleUpdateInProgressFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "SnapshotScheduleUpdateInProgressFault")?;
        if let Some(inner_47) = &self.message {
            write!(f, ": {}", inner_47)?;
        }
        Ok(())
    }
}
impl std::error::Error for SnapshotScheduleUpdateInProgressFault {}
/// See [`SnapshotScheduleUpdateInProgressFault`](crate::error::SnapshotScheduleUpdateInProgressFault)
pub mod snapshot_schedule_update_in_progress_fault {
    /// A builder for [`SnapshotScheduleUpdateInProgressFault`](crate::error::SnapshotScheduleUpdateInProgressFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`SnapshotScheduleUpdateInProgressFault`](crate::error::SnapshotScheduleUpdateInProgressFault)
        pub fn build(self) -> crate::error::SnapshotScheduleUpdateInProgressFault {
            crate::error::SnapshotScheduleUpdateInProgressFault {
                message: self.message,
            }
        }
    }
}
impl SnapshotScheduleUpdateInProgressFault {
    /// Creates a new builder-style object to manufacture [`SnapshotScheduleUpdateInProgressFault`](crate::error::SnapshotScheduleUpdateInProgressFault)
    pub fn builder() -> crate::error::snapshot_schedule_update_in_progress_fault::Builder {
        crate::error::snapshot_schedule_update_in_progress_fault::Builder::default()
    }
}

/// <p>The schedule you submitted isn't valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidScheduleFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidScheduleFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidScheduleFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidScheduleFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidScheduleFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidScheduleFault")?;
        if let Some(inner_48) = &self.message {
            write!(f, ": {}", inner_48)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidScheduleFault {}
/// See [`InvalidScheduleFault`](crate::error::InvalidScheduleFault)
pub mod invalid_schedule_fault {
    /// A builder for [`InvalidScheduleFault`](crate::error::InvalidScheduleFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidScheduleFault`](crate::error::InvalidScheduleFault)
        pub fn build(self) -> crate::error::InvalidScheduleFault {
            crate::error::InvalidScheduleFault {
                message: self.message,
            }
        }
    }
}
impl InvalidScheduleFault {
    /// Creates a new builder-style object to manufacture [`InvalidScheduleFault`](crate::error::InvalidScheduleFault)
    pub fn builder() -> crate::error::invalid_schedule_fault::Builder {
        crate::error::invalid_schedule_fault::Builder::default()
    }
}

/// <p>Cross-region snapshot copy was temporarily disabled. Try your request
/// again.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SnapshotCopyDisabledFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SnapshotCopyDisabledFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SnapshotCopyDisabledFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl SnapshotCopyDisabledFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for SnapshotCopyDisabledFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "SnapshotCopyDisabledFault")?;
        if let Some(inner_49) = &self.message {
            write!(f, ": {}", inner_49)?;
        }
        Ok(())
    }
}
impl std::error::Error for SnapshotCopyDisabledFault {}
/// See [`SnapshotCopyDisabledFault`](crate::error::SnapshotCopyDisabledFault)
pub mod snapshot_copy_disabled_fault {
    /// A builder for [`SnapshotCopyDisabledFault`](crate::error::SnapshotCopyDisabledFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`SnapshotCopyDisabledFault`](crate::error::SnapshotCopyDisabledFault)
        pub fn build(self) -> crate::error::SnapshotCopyDisabledFault {
            crate::error::SnapshotCopyDisabledFault {
                message: self.message,
            }
        }
    }
}
impl SnapshotCopyDisabledFault {
    /// Creates a new builder-style object to manufacture [`SnapshotCopyDisabledFault`](crate::error::SnapshotCopyDisabledFault)
    pub fn builder() -> crate::error::snapshot_copy_disabled_fault::Builder {
        crate::error::snapshot_copy_disabled_fault::Builder::default()
    }
}

/// <p>The retention period specified is either in the past or is not a valid value.</p>
/// <p>The value must be either -1 or an integer between 1 and 3,653.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidRetentionPeriodFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidRetentionPeriodFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidRetentionPeriodFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidRetentionPeriodFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidRetentionPeriodFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidRetentionPeriodFault")?;
        if let Some(inner_50) = &self.message {
            write!(f, ": {}", inner_50)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidRetentionPeriodFault {}
/// See [`InvalidRetentionPeriodFault`](crate::error::InvalidRetentionPeriodFault)
pub mod invalid_retention_period_fault {
    /// A builder for [`InvalidRetentionPeriodFault`](crate::error::InvalidRetentionPeriodFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidRetentionPeriodFault`](crate::error::InvalidRetentionPeriodFault)
        pub fn build(self) -> crate::error::InvalidRetentionPeriodFault {
            crate::error::InvalidRetentionPeriodFault {
                message: self.message,
            }
        }
    }
}
impl InvalidRetentionPeriodFault {
    /// Creates a new builder-style object to manufacture [`InvalidRetentionPeriodFault`](crate::error::InvalidRetentionPeriodFault)
    pub fn builder() -> crate::error::invalid_retention_period_fault::Builder {
        crate::error::invalid_retention_period_fault::Builder::default()
    }
}

/// <p>The action type specified for a scheduled action is not supported. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ScheduledActionTypeUnsupportedFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ScheduledActionTypeUnsupportedFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ScheduledActionTypeUnsupportedFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ScheduledActionTypeUnsupportedFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ScheduledActionTypeUnsupportedFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ScheduledActionTypeUnsupportedFault")?;
        if let Some(inner_51) = &self.message {
            write!(f, ": {}", inner_51)?;
        }
        Ok(())
    }
}
impl std::error::Error for ScheduledActionTypeUnsupportedFault {}
/// See [`ScheduledActionTypeUnsupportedFault`](crate::error::ScheduledActionTypeUnsupportedFault)
pub mod scheduled_action_type_unsupported_fault {
    /// A builder for [`ScheduledActionTypeUnsupportedFault`](crate::error::ScheduledActionTypeUnsupportedFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ScheduledActionTypeUnsupportedFault`](crate::error::ScheduledActionTypeUnsupportedFault)
        pub fn build(self) -> crate::error::ScheduledActionTypeUnsupportedFault {
            crate::error::ScheduledActionTypeUnsupportedFault {
                message: self.message,
            }
        }
    }
}
impl ScheduledActionTypeUnsupportedFault {
    /// Creates a new builder-style object to manufacture [`ScheduledActionTypeUnsupportedFault`](crate::error::ScheduledActionTypeUnsupportedFault)
    pub fn builder() -> crate::error::scheduled_action_type_unsupported_fault::Builder {
        crate::error::scheduled_action_type_unsupported_fault::Builder::default()
    }
}

/// <p>The scheduled action cannot be found. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ScheduledActionNotFoundFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ScheduledActionNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ScheduledActionNotFoundFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ScheduledActionNotFoundFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ScheduledActionNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ScheduledActionNotFoundFault")?;
        if let Some(inner_52) = &self.message {
            write!(f, ": {}", inner_52)?;
        }
        Ok(())
    }
}
impl std::error::Error for ScheduledActionNotFoundFault {}
/// See [`ScheduledActionNotFoundFault`](crate::error::ScheduledActionNotFoundFault)
pub mod scheduled_action_not_found_fault {
    /// A builder for [`ScheduledActionNotFoundFault`](crate::error::ScheduledActionNotFoundFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ScheduledActionNotFoundFault`](crate::error::ScheduledActionNotFoundFault)
        pub fn build(self) -> crate::error::ScheduledActionNotFoundFault {
            crate::error::ScheduledActionNotFoundFault {
                message: self.message,
            }
        }
    }
}
impl ScheduledActionNotFoundFault {
    /// Creates a new builder-style object to manufacture [`ScheduledActionNotFoundFault`](crate::error::ScheduledActionNotFoundFault)
    pub fn builder() -> crate::error::scheduled_action_not_found_fault::Builder {
        crate::error::scheduled_action_not_found_fault::Builder::default()
    }
}

/// <p>The scheduled action is not valid. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidScheduledActionFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidScheduledActionFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidScheduledActionFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidScheduledActionFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidScheduledActionFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidScheduledActionFault")?;
        if let Some(inner_53) = &self.message {
            write!(f, ": {}", inner_53)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidScheduledActionFault {}
/// See [`InvalidScheduledActionFault`](crate::error::InvalidScheduledActionFault)
pub mod invalid_scheduled_action_fault {
    /// A builder for [`InvalidScheduledActionFault`](crate::error::InvalidScheduledActionFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidScheduledActionFault`](crate::error::InvalidScheduledActionFault)
        pub fn build(self) -> crate::error::InvalidScheduledActionFault {
            crate::error::InvalidScheduledActionFault {
                message: self.message,
            }
        }
    }
}
impl InvalidScheduledActionFault {
    /// Creates a new builder-style object to manufacture [`InvalidScheduledActionFault`](crate::error::InvalidScheduledActionFault)
    pub fn builder() -> crate::error::invalid_scheduled_action_fault::Builder {
        crate::error::invalid_scheduled_action_fault::Builder::default()
    }
}

/// <p>The value specified for the event severity was not one of the allowed values, or it
/// specified a severity that does not apply to the specified source type. The allowed
/// values are ERROR and INFO.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SubscriptionSeverityNotFoundFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SubscriptionSeverityNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SubscriptionSeverityNotFoundFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl SubscriptionSeverityNotFoundFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for SubscriptionSeverityNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "SubscriptionSeverityNotFoundFault")?;
        if let Some(inner_54) = &self.message {
            write!(f, ": {}", inner_54)?;
        }
        Ok(())
    }
}
impl std::error::Error for SubscriptionSeverityNotFoundFault {}
/// See [`SubscriptionSeverityNotFoundFault`](crate::error::SubscriptionSeverityNotFoundFault)
pub mod subscription_severity_not_found_fault {
    /// A builder for [`SubscriptionSeverityNotFoundFault`](crate::error::SubscriptionSeverityNotFoundFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`SubscriptionSeverityNotFoundFault`](crate::error::SubscriptionSeverityNotFoundFault)
        pub fn build(self) -> crate::error::SubscriptionSeverityNotFoundFault {
            crate::error::SubscriptionSeverityNotFoundFault {
                message: self.message,
            }
        }
    }
}
impl SubscriptionSeverityNotFoundFault {
    /// Creates a new builder-style object to manufacture [`SubscriptionSeverityNotFoundFault`](crate::error::SubscriptionSeverityNotFoundFault)
    pub fn builder() -> crate::error::subscription_severity_not_found_fault::Builder {
        crate::error::subscription_severity_not_found_fault::Builder::default()
    }
}

/// <p>An Amazon Redshift event notification subscription with the specified name does not
/// exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SubscriptionNotFoundFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SubscriptionNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SubscriptionNotFoundFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl SubscriptionNotFoundFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for SubscriptionNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "SubscriptionNotFoundFault")?;
        if let Some(inner_55) = &self.message {
            write!(f, ": {}", inner_55)?;
        }
        Ok(())
    }
}
impl std::error::Error for SubscriptionNotFoundFault {}
/// See [`SubscriptionNotFoundFault`](crate::error::SubscriptionNotFoundFault)
pub mod subscription_not_found_fault {
    /// A builder for [`SubscriptionNotFoundFault`](crate::error::SubscriptionNotFoundFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`SubscriptionNotFoundFault`](crate::error::SubscriptionNotFoundFault)
        pub fn build(self) -> crate::error::SubscriptionNotFoundFault {
            crate::error::SubscriptionNotFoundFault {
                message: self.message,
            }
        }
    }
}
impl SubscriptionNotFoundFault {
    /// Creates a new builder-style object to manufacture [`SubscriptionNotFoundFault`](crate::error::SubscriptionNotFoundFault)
    pub fn builder() -> crate::error::subscription_not_found_fault::Builder {
        crate::error::subscription_not_found_fault::Builder::default()
    }
}

/// <p>An Amazon Redshift event with the specified event ID does not exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SubscriptionEventIdNotFoundFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SubscriptionEventIdNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SubscriptionEventIdNotFoundFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl SubscriptionEventIdNotFoundFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for SubscriptionEventIdNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "SubscriptionEventIdNotFoundFault")?;
        if let Some(inner_56) = &self.message {
            write!(f, ": {}", inner_56)?;
        }
        Ok(())
    }
}
impl std::error::Error for SubscriptionEventIdNotFoundFault {}
/// See [`SubscriptionEventIdNotFoundFault`](crate::error::SubscriptionEventIdNotFoundFault)
pub mod subscription_event_id_not_found_fault {
    /// A builder for [`SubscriptionEventIdNotFoundFault`](crate::error::SubscriptionEventIdNotFoundFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`SubscriptionEventIdNotFoundFault`](crate::error::SubscriptionEventIdNotFoundFault)
        pub fn build(self) -> crate::error::SubscriptionEventIdNotFoundFault {
            crate::error::SubscriptionEventIdNotFoundFault {
                message: self.message,
            }
        }
    }
}
impl SubscriptionEventIdNotFoundFault {
    /// Creates a new builder-style object to manufacture [`SubscriptionEventIdNotFoundFault`](crate::error::SubscriptionEventIdNotFoundFault)
    pub fn builder() -> crate::error::subscription_event_id_not_found_fault::Builder {
        crate::error::subscription_event_id_not_found_fault::Builder::default()
    }
}

/// <p>The value specified for the event category was not one of the allowed values, or it
/// specified a category that does not apply to the specified source type. The allowed
/// values are Configuration, Management, Monitoring, and Security.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SubscriptionCategoryNotFoundFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SubscriptionCategoryNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SubscriptionCategoryNotFoundFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl SubscriptionCategoryNotFoundFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for SubscriptionCategoryNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "SubscriptionCategoryNotFoundFault")?;
        if let Some(inner_57) = &self.message {
            write!(f, ": {}", inner_57)?;
        }
        Ok(())
    }
}
impl std::error::Error for SubscriptionCategoryNotFoundFault {}
/// See [`SubscriptionCategoryNotFoundFault`](crate::error::SubscriptionCategoryNotFoundFault)
pub mod subscription_category_not_found_fault {
    /// A builder for [`SubscriptionCategoryNotFoundFault`](crate::error::SubscriptionCategoryNotFoundFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`SubscriptionCategoryNotFoundFault`](crate::error::SubscriptionCategoryNotFoundFault)
        pub fn build(self) -> crate::error::SubscriptionCategoryNotFoundFault {
            crate::error::SubscriptionCategoryNotFoundFault {
                message: self.message,
            }
        }
    }
}
impl SubscriptionCategoryNotFoundFault {
    /// Creates a new builder-style object to manufacture [`SubscriptionCategoryNotFoundFault`](crate::error::SubscriptionCategoryNotFoundFault)
    pub fn builder() -> crate::error::subscription_category_not_found_fault::Builder {
        crate::error::subscription_category_not_found_fault::Builder::default()
    }
}

/// <p>The specified Amazon Redshift event source could not be found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SourceNotFoundFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SourceNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SourceNotFoundFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl SourceNotFoundFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for SourceNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "SourceNotFoundFault")?;
        if let Some(inner_58) = &self.message {
            write!(f, ": {}", inner_58)?;
        }
        Ok(())
    }
}
impl std::error::Error for SourceNotFoundFault {}
/// See [`SourceNotFoundFault`](crate::error::SourceNotFoundFault)
pub mod source_not_found_fault {
    /// A builder for [`SourceNotFoundFault`](crate::error::SourceNotFoundFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`SourceNotFoundFault`](crate::error::SourceNotFoundFault)
        pub fn build(self) -> crate::error::SourceNotFoundFault {
            crate::error::SourceNotFoundFault {
                message: self.message,
            }
        }
    }
}
impl SourceNotFoundFault {
    /// Creates a new builder-style object to manufacture [`SourceNotFoundFault`](crate::error::SourceNotFoundFault)
    pub fn builder() -> crate::error::source_not_found_fault::Builder {
        crate::error::source_not_found_fault::Builder::default()
    }
}

/// <p>An Amazon SNS topic with the specified Amazon Resource Name (ARN) does not
/// exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SnsTopicArnNotFoundFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SnsTopicArnNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SnsTopicArnNotFoundFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl SnsTopicArnNotFoundFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for SnsTopicArnNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "SnsTopicArnNotFoundFault [SNSTopicArnNotFoundFault]")?;
        if let Some(inner_59) = &self.message {
            write!(f, ": {}", inner_59)?;
        }
        Ok(())
    }
}
impl std::error::Error for SnsTopicArnNotFoundFault {}
/// See [`SnsTopicArnNotFoundFault`](crate::error::SnsTopicArnNotFoundFault)
pub mod sns_topic_arn_not_found_fault {
    /// A builder for [`SnsTopicArnNotFoundFault`](crate::error::SnsTopicArnNotFoundFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`SnsTopicArnNotFoundFault`](crate::error::SnsTopicArnNotFoundFault)
        pub fn build(self) -> crate::error::SnsTopicArnNotFoundFault {
            crate::error::SnsTopicArnNotFoundFault {
                message: self.message,
            }
        }
    }
}
impl SnsTopicArnNotFoundFault {
    /// Creates a new builder-style object to manufacture [`SnsTopicArnNotFoundFault`](crate::error::SnsTopicArnNotFoundFault)
    pub fn builder() -> crate::error::sns_topic_arn_not_found_fault::Builder {
        crate::error::sns_topic_arn_not_found_fault::Builder::default()
    }
}

/// <p>You do not have permission to publish to the specified Amazon SNS topic.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SnsNoAuthorizationFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SnsNoAuthorizationFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SnsNoAuthorizationFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl SnsNoAuthorizationFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for SnsNoAuthorizationFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "SnsNoAuthorizationFault [SNSNoAuthorizationFault]")?;
        if let Some(inner_60) = &self.message {
            write!(f, ": {}", inner_60)?;
        }
        Ok(())
    }
}
impl std::error::Error for SnsNoAuthorizationFault {}
/// See [`SnsNoAuthorizationFault`](crate::error::SnsNoAuthorizationFault)
pub mod sns_no_authorization_fault {
    /// A builder for [`SnsNoAuthorizationFault`](crate::error::SnsNoAuthorizationFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`SnsNoAuthorizationFault`](crate::error::SnsNoAuthorizationFault)
        pub fn build(self) -> crate::error::SnsNoAuthorizationFault {
            crate::error::SnsNoAuthorizationFault {
                message: self.message,
            }
        }
    }
}
impl SnsNoAuthorizationFault {
    /// Creates a new builder-style object to manufacture [`SnsNoAuthorizationFault`](crate::error::SnsNoAuthorizationFault)
    pub fn builder() -> crate::error::sns_no_authorization_fault::Builder {
        crate::error::sns_no_authorization_fault::Builder::default()
    }
}

/// <p>Amazon SNS has responded that there is a problem with the specified Amazon SNS
/// topic.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SnsInvalidTopicFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SnsInvalidTopicFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SnsInvalidTopicFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl SnsInvalidTopicFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for SnsInvalidTopicFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "SnsInvalidTopicFault [SNSInvalidTopicFault]")?;
        if let Some(inner_61) = &self.message {
            write!(f, ": {}", inner_61)?;
        }
        Ok(())
    }
}
impl std::error::Error for SnsInvalidTopicFault {}
/// See [`SnsInvalidTopicFault`](crate::error::SnsInvalidTopicFault)
pub mod sns_invalid_topic_fault {
    /// A builder for [`SnsInvalidTopicFault`](crate::error::SnsInvalidTopicFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`SnsInvalidTopicFault`](crate::error::SnsInvalidTopicFault)
        pub fn build(self) -> crate::error::SnsInvalidTopicFault {
            crate::error::SnsInvalidTopicFault {
                message: self.message,
            }
        }
    }
}
impl SnsInvalidTopicFault {
    /// Creates a new builder-style object to manufacture [`SnsInvalidTopicFault`](crate::error::SnsInvalidTopicFault)
    pub fn builder() -> crate::error::sns_invalid_topic_fault::Builder {
        crate::error::sns_invalid_topic_fault::Builder::default()
    }
}

/// <p>The subscription request is invalid because it is a duplicate request. This
/// subscription request is already in progress.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidSubscriptionStateFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidSubscriptionStateFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidSubscriptionStateFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidSubscriptionStateFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidSubscriptionStateFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidSubscriptionStateFault")?;
        if let Some(inner_62) = &self.message {
            write!(f, ": {}", inner_62)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidSubscriptionStateFault {}
/// See [`InvalidSubscriptionStateFault`](crate::error::InvalidSubscriptionStateFault)
pub mod invalid_subscription_state_fault {
    /// A builder for [`InvalidSubscriptionStateFault`](crate::error::InvalidSubscriptionStateFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidSubscriptionStateFault`](crate::error::InvalidSubscriptionStateFault)
        pub fn build(self) -> crate::error::InvalidSubscriptionStateFault {
            crate::error::InvalidSubscriptionStateFault {
                message: self.message,
            }
        }
    }
}
impl InvalidSubscriptionStateFault {
    /// Creates a new builder-style object to manufacture [`InvalidSubscriptionStateFault`](crate::error::InvalidSubscriptionStateFault)
    pub fn builder() -> crate::error::invalid_subscription_state_fault::Builder {
        crate::error::invalid_subscription_state_fault::Builder::default()
    }
}

/// <p>A specified subnet is already in use by another cluster.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SubnetAlreadyInUse {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SubnetAlreadyInUse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SubnetAlreadyInUse");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl SubnetAlreadyInUse {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for SubnetAlreadyInUse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "SubnetAlreadyInUse")?;
        if let Some(inner_63) = &self.message {
            write!(f, ": {}", inner_63)?;
        }
        Ok(())
    }
}
impl std::error::Error for SubnetAlreadyInUse {}
/// See [`SubnetAlreadyInUse`](crate::error::SubnetAlreadyInUse)
pub mod subnet_already_in_use {
    /// A builder for [`SubnetAlreadyInUse`](crate::error::SubnetAlreadyInUse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`SubnetAlreadyInUse`](crate::error::SubnetAlreadyInUse)
        pub fn build(self) -> crate::error::SubnetAlreadyInUse {
            crate::error::SubnetAlreadyInUse {
                message: self.message,
            }
        }
    }
}
impl SubnetAlreadyInUse {
    /// Creates a new builder-style object to manufacture [`SubnetAlreadyInUse`](crate::error::SubnetAlreadyInUse)
    pub fn builder() -> crate::error::subnet_already_in_use::Builder {
        crate::error::subnet_already_in_use::Builder::default()
    }
}

/// <p>The request would result in user exceeding the allowed number of subnets in a
/// cluster subnet groups.
/// For information about increasing your quota, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon Redshift</a>
/// in the <i>Amazon Redshift Cluster Management Guide</i>.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ClusterSubnetQuotaExceededFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ClusterSubnetQuotaExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ClusterSubnetQuotaExceededFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ClusterSubnetQuotaExceededFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ClusterSubnetQuotaExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ClusterSubnetQuotaExceededFault")?;
        if let Some(inner_64) = &self.message {
            write!(f, ": {}", inner_64)?;
        }
        Ok(())
    }
}
impl std::error::Error for ClusterSubnetQuotaExceededFault {}
/// See [`ClusterSubnetQuotaExceededFault`](crate::error::ClusterSubnetQuotaExceededFault)
pub mod cluster_subnet_quota_exceeded_fault {
    /// A builder for [`ClusterSubnetQuotaExceededFault`](crate::error::ClusterSubnetQuotaExceededFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ClusterSubnetQuotaExceededFault`](crate::error::ClusterSubnetQuotaExceededFault)
        pub fn build(self) -> crate::error::ClusterSubnetQuotaExceededFault {
            crate::error::ClusterSubnetQuotaExceededFault {
                message: self.message,
            }
        }
    }
}
impl ClusterSubnetQuotaExceededFault {
    /// Creates a new builder-style object to manufacture [`ClusterSubnetQuotaExceededFault`](crate::error::ClusterSubnetQuotaExceededFault)
    pub fn builder() -> crate::error::cluster_subnet_quota_exceeded_fault::Builder {
        crate::error::cluster_subnet_quota_exceeded_fault::Builder::default()
    }
}

/// <p>The cluster snapshot schedule state is not valid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidClusterSnapshotScheduleStateFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidClusterSnapshotScheduleStateFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidClusterSnapshotScheduleStateFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidClusterSnapshotScheduleStateFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidClusterSnapshotScheduleStateFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidClusterSnapshotScheduleStateFault")?;
        if let Some(inner_65) = &self.message {
            write!(f, ": {}", inner_65)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidClusterSnapshotScheduleStateFault {}
/// See [`InvalidClusterSnapshotScheduleStateFault`](crate::error::InvalidClusterSnapshotScheduleStateFault)
pub mod invalid_cluster_snapshot_schedule_state_fault {
    /// A builder for [`InvalidClusterSnapshotScheduleStateFault`](crate::error::InvalidClusterSnapshotScheduleStateFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidClusterSnapshotScheduleStateFault`](crate::error::InvalidClusterSnapshotScheduleStateFault)
        pub fn build(self) -> crate::error::InvalidClusterSnapshotScheduleStateFault {
            crate::error::InvalidClusterSnapshotScheduleStateFault {
                message: self.message,
            }
        }
    }
}
impl InvalidClusterSnapshotScheduleStateFault {
    /// Creates a new builder-style object to manufacture [`InvalidClusterSnapshotScheduleStateFault`](crate::error::InvalidClusterSnapshotScheduleStateFault)
    pub fn builder() -> crate::error::invalid_cluster_snapshot_schedule_state_fault::Builder {
        crate::error::invalid_cluster_snapshot_schedule_state_fault::Builder::default()
    }
}

/// <p>Cluster is already on the latest database revision.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ClusterOnLatestRevisionFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ClusterOnLatestRevisionFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ClusterOnLatestRevisionFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ClusterOnLatestRevisionFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ClusterOnLatestRevisionFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ClusterOnLatestRevisionFault")?;
        if let Some(inner_66) = &self.message {
            write!(f, ": {}", inner_66)?;
        }
        Ok(())
    }
}
impl std::error::Error for ClusterOnLatestRevisionFault {}
/// See [`ClusterOnLatestRevisionFault`](crate::error::ClusterOnLatestRevisionFault)
pub mod cluster_on_latest_revision_fault {
    /// A builder for [`ClusterOnLatestRevisionFault`](crate::error::ClusterOnLatestRevisionFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ClusterOnLatestRevisionFault`](crate::error::ClusterOnLatestRevisionFault)
        pub fn build(self) -> crate::error::ClusterOnLatestRevisionFault {
            crate::error::ClusterOnLatestRevisionFault {
                message: self.message,
            }
        }
    }
}
impl ClusterOnLatestRevisionFault {
    /// Creates a new builder-style object to manufacture [`ClusterOnLatestRevisionFault`](crate::error::ClusterOnLatestRevisionFault)
    pub fn builder() -> crate::error::cluster_on_latest_revision_fault::Builder {
        crate::error::cluster_on_latest_revision_fault::Builder::default()
    }
}

/// <p>The number of tables in the cluster exceeds the limit for the requested new cluster
/// node type. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TableLimitExceededFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TableLimitExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TableLimitExceededFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TableLimitExceededFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TableLimitExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TableLimitExceededFault")?;
        if let Some(inner_67) = &self.message {
            write!(f, ": {}", inner_67)?;
        }
        Ok(())
    }
}
impl std::error::Error for TableLimitExceededFault {}
/// See [`TableLimitExceededFault`](crate::error::TableLimitExceededFault)
pub mod table_limit_exceeded_fault {
    /// A builder for [`TableLimitExceededFault`](crate::error::TableLimitExceededFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TableLimitExceededFault`](crate::error::TableLimitExceededFault)
        pub fn build(self) -> crate::error::TableLimitExceededFault {
            crate::error::TableLimitExceededFault {
                message: self.message,
            }
        }
    }
}
impl TableLimitExceededFault {
    /// Creates a new builder-style object to manufacture [`TableLimitExceededFault`](crate::error::TableLimitExceededFault)
    pub fn builder() -> crate::error::table_limit_exceeded_fault::Builder {
        crate::error::table_limit_exceeded_fault::Builder::default()
    }
}

/// <p>The authentication profile request is not valid. The profile name can't be null or empty.
/// The authentication profile API operation must be available in the Amazon Web Services Region.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidAuthenticationProfileRequestFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidAuthenticationProfileRequestFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidAuthenticationProfileRequestFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidAuthenticationProfileRequestFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidAuthenticationProfileRequestFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidAuthenticationProfileRequestFault")?;
        if let Some(inner_68) = &self.message {
            write!(f, ": {}", inner_68)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidAuthenticationProfileRequestFault {}
/// See [`InvalidAuthenticationProfileRequestFault`](crate::error::InvalidAuthenticationProfileRequestFault)
pub mod invalid_authentication_profile_request_fault {
    /// A builder for [`InvalidAuthenticationProfileRequestFault`](crate::error::InvalidAuthenticationProfileRequestFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidAuthenticationProfileRequestFault`](crate::error::InvalidAuthenticationProfileRequestFault)
        pub fn build(self) -> crate::error::InvalidAuthenticationProfileRequestFault {
            crate::error::InvalidAuthenticationProfileRequestFault {
                message: self.message,
            }
        }
    }
}
impl InvalidAuthenticationProfileRequestFault {
    /// Creates a new builder-style object to manufacture [`InvalidAuthenticationProfileRequestFault`](crate::error::InvalidAuthenticationProfileRequestFault)
    pub fn builder() -> crate::error::invalid_authentication_profile_request_fault::Builder {
        crate::error::invalid_authentication_profile_request_fault::Builder::default()
    }
}

/// <p>The size or number of authentication profiles has exceeded the quota.
/// The maximum length of the JSON string and maximum number of authentication profiles is determined by a quota for your account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AuthenticationProfileQuotaExceededFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AuthenticationProfileQuotaExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AuthenticationProfileQuotaExceededFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AuthenticationProfileQuotaExceededFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AuthenticationProfileQuotaExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AuthenticationProfileQuotaExceededFault")?;
        if let Some(inner_69) = &self.message {
            write!(f, ": {}", inner_69)?;
        }
        Ok(())
    }
}
impl std::error::Error for AuthenticationProfileQuotaExceededFault {}
/// See [`AuthenticationProfileQuotaExceededFault`](crate::error::AuthenticationProfileQuotaExceededFault)
pub mod authentication_profile_quota_exceeded_fault {
    /// A builder for [`AuthenticationProfileQuotaExceededFault`](crate::error::AuthenticationProfileQuotaExceededFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AuthenticationProfileQuotaExceededFault`](crate::error::AuthenticationProfileQuotaExceededFault)
        pub fn build(self) -> crate::error::AuthenticationProfileQuotaExceededFault {
            crate::error::AuthenticationProfileQuotaExceededFault {
                message: self.message,
            }
        }
    }
}
impl AuthenticationProfileQuotaExceededFault {
    /// Creates a new builder-style object to manufacture [`AuthenticationProfileQuotaExceededFault`](crate::error::AuthenticationProfileQuotaExceededFault)
    pub fn builder() -> crate::error::authentication_profile_quota_exceeded_fault::Builder {
        crate::error::authentication_profile_quota_exceeded_fault::Builder::default()
    }
}

/// <p>The authentication profile can't be found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AuthenticationProfileNotFoundFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AuthenticationProfileNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AuthenticationProfileNotFoundFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AuthenticationProfileNotFoundFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AuthenticationProfileNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AuthenticationProfileNotFoundFault")?;
        if let Some(inner_70) = &self.message {
            write!(f, ": {}", inner_70)?;
        }
        Ok(())
    }
}
impl std::error::Error for AuthenticationProfileNotFoundFault {}
/// See [`AuthenticationProfileNotFoundFault`](crate::error::AuthenticationProfileNotFoundFault)
pub mod authentication_profile_not_found_fault {
    /// A builder for [`AuthenticationProfileNotFoundFault`](crate::error::AuthenticationProfileNotFoundFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AuthenticationProfileNotFoundFault`](crate::error::AuthenticationProfileNotFoundFault)
        pub fn build(self) -> crate::error::AuthenticationProfileNotFoundFault {
            crate::error::AuthenticationProfileNotFoundFault {
                message: self.message,
            }
        }
    }
}
impl AuthenticationProfileNotFoundFault {
    /// Creates a new builder-style object to manufacture [`AuthenticationProfileNotFoundFault`](crate::error::AuthenticationProfileNotFoundFault)
    pub fn builder() -> crate::error::authentication_profile_not_found_fault::Builder {
        crate::error::authentication_profile_not_found_fault::Builder::default()
    }
}

/// <p>The specified reserved compute node not found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReservedNodeNotFoundFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ReservedNodeNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReservedNodeNotFoundFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ReservedNodeNotFoundFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ReservedNodeNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ReservedNodeNotFoundFault")?;
        if let Some(inner_71) = &self.message {
            write!(f, ": {}", inner_71)?;
        }
        Ok(())
    }
}
impl std::error::Error for ReservedNodeNotFoundFault {}
/// See [`ReservedNodeNotFoundFault`](crate::error::ReservedNodeNotFoundFault)
pub mod reserved_node_not_found_fault {
    /// A builder for [`ReservedNodeNotFoundFault`](crate::error::ReservedNodeNotFoundFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ReservedNodeNotFoundFault`](crate::error::ReservedNodeNotFoundFault)
        pub fn build(self) -> crate::error::ReservedNodeNotFoundFault {
            crate::error::ReservedNodeNotFoundFault {
                message: self.message,
            }
        }
    }
}
impl ReservedNodeNotFoundFault {
    /// Creates a new builder-style object to manufacture [`ReservedNodeNotFoundFault`](crate::error::ReservedNodeNotFoundFault)
    pub fn builder() -> crate::error::reserved_node_not_found_fault::Builder {
        crate::error::reserved_node_not_found_fault::Builder::default()
    }
}

/// <p>Indicates that the reserved node has already been exchanged.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReservedNodeAlreadyMigratedFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ReservedNodeAlreadyMigratedFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReservedNodeAlreadyMigratedFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ReservedNodeAlreadyMigratedFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ReservedNodeAlreadyMigratedFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ReservedNodeAlreadyMigratedFault")?;
        if let Some(inner_72) = &self.message {
            write!(f, ": {}", inner_72)?;
        }
        Ok(())
    }
}
impl std::error::Error for ReservedNodeAlreadyMigratedFault {}
/// See [`ReservedNodeAlreadyMigratedFault`](crate::error::ReservedNodeAlreadyMigratedFault)
pub mod reserved_node_already_migrated_fault {
    /// A builder for [`ReservedNodeAlreadyMigratedFault`](crate::error::ReservedNodeAlreadyMigratedFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ReservedNodeAlreadyMigratedFault`](crate::error::ReservedNodeAlreadyMigratedFault)
        pub fn build(self) -> crate::error::ReservedNodeAlreadyMigratedFault {
            crate::error::ReservedNodeAlreadyMigratedFault {
                message: self.message,
            }
        }
    }
}
impl ReservedNodeAlreadyMigratedFault {
    /// Creates a new builder-style object to manufacture [`ReservedNodeAlreadyMigratedFault`](crate::error::ReservedNodeAlreadyMigratedFault)
    pub fn builder() -> crate::error::reserved_node_already_migrated_fault::Builder {
        crate::error::reserved_node_already_migrated_fault::Builder::default()
    }
}

/// <p>Indicates that the Reserved Node being exchanged is not in an active state.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidReservedNodeStateFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidReservedNodeStateFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidReservedNodeStateFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidReservedNodeStateFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidReservedNodeStateFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidReservedNodeStateFault")?;
        if let Some(inner_73) = &self.message {
            write!(f, ": {}", inner_73)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidReservedNodeStateFault {}
/// See [`InvalidReservedNodeStateFault`](crate::error::InvalidReservedNodeStateFault)
pub mod invalid_reserved_node_state_fault {
    /// A builder for [`InvalidReservedNodeStateFault`](crate::error::InvalidReservedNodeStateFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidReservedNodeStateFault`](crate::error::InvalidReservedNodeStateFault)
        pub fn build(self) -> crate::error::InvalidReservedNodeStateFault {
            crate::error::InvalidReservedNodeStateFault {
                message: self.message,
            }
        }
    }
}
impl InvalidReservedNodeStateFault {
    /// Creates a new builder-style object to manufacture [`InvalidReservedNodeStateFault`](crate::error::InvalidReservedNodeStateFault)
    pub fn builder() -> crate::error::invalid_reserved_node_state_fault::Builder {
        crate::error::invalid_reserved_node_state_fault::Builder::default()
    }
}

/// <p>Your request cannot be completed because a dependent internal service is
/// temporarily unavailable. Wait 30 to 60 seconds and try again.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DependentServiceUnavailableFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DependentServiceUnavailableFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DependentServiceUnavailableFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DependentServiceUnavailableFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DependentServiceUnavailableFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DependentServiceUnavailableFault")?;
        if let Some(inner_74) = &self.message {
            write!(f, ": {}", inner_74)?;
        }
        Ok(())
    }
}
impl std::error::Error for DependentServiceUnavailableFault {}
/// See [`DependentServiceUnavailableFault`](crate::error::DependentServiceUnavailableFault)
pub mod dependent_service_unavailable_fault {
    /// A builder for [`DependentServiceUnavailableFault`](crate::error::DependentServiceUnavailableFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DependentServiceUnavailableFault`](crate::error::DependentServiceUnavailableFault)
        pub fn build(self) -> crate::error::DependentServiceUnavailableFault {
            crate::error::DependentServiceUnavailableFault {
                message: self.message,
            }
        }
    }
}
impl DependentServiceUnavailableFault {
    /// Creates a new builder-style object to manufacture [`DependentServiceUnavailableFault`](crate::error::DependentServiceUnavailableFault)
    pub fn builder() -> crate::error::dependent_service_unavailable_fault::Builder {
        crate::error::dependent_service_unavailable_fault::Builder::default()
    }
}

/// <p>The specified region is incorrect or does not exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnknownSnapshotCopyRegionFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UnknownSnapshotCopyRegionFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnknownSnapshotCopyRegionFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl UnknownSnapshotCopyRegionFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for UnknownSnapshotCopyRegionFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "UnknownSnapshotCopyRegionFault")?;
        if let Some(inner_75) = &self.message {
            write!(f, ": {}", inner_75)?;
        }
        Ok(())
    }
}
impl std::error::Error for UnknownSnapshotCopyRegionFault {}
/// See [`UnknownSnapshotCopyRegionFault`](crate::error::UnknownSnapshotCopyRegionFault)
pub mod unknown_snapshot_copy_region_fault {
    /// A builder for [`UnknownSnapshotCopyRegionFault`](crate::error::UnknownSnapshotCopyRegionFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`UnknownSnapshotCopyRegionFault`](crate::error::UnknownSnapshotCopyRegionFault)
        pub fn build(self) -> crate::error::UnknownSnapshotCopyRegionFault {
            crate::error::UnknownSnapshotCopyRegionFault {
                message: self.message,
            }
        }
    }
}
impl UnknownSnapshotCopyRegionFault {
    /// Creates a new builder-style object to manufacture [`UnknownSnapshotCopyRegionFault`](crate::error::UnknownSnapshotCopyRegionFault)
    pub fn builder() -> crate::error::unknown_snapshot_copy_region_fault::Builder {
        crate::error::unknown_snapshot_copy_region_fault::Builder::default()
    }
}

/// <p>The specified snapshot copy grant can't be found. Make sure that the name is typed
/// correctly and that the grant exists in the destination region.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SnapshotCopyGrantNotFoundFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SnapshotCopyGrantNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SnapshotCopyGrantNotFoundFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl SnapshotCopyGrantNotFoundFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for SnapshotCopyGrantNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "SnapshotCopyGrantNotFoundFault")?;
        if let Some(inner_76) = &self.message {
            write!(f, ": {}", inner_76)?;
        }
        Ok(())
    }
}
impl std::error::Error for SnapshotCopyGrantNotFoundFault {}
/// See [`SnapshotCopyGrantNotFoundFault`](crate::error::SnapshotCopyGrantNotFoundFault)
pub mod snapshot_copy_grant_not_found_fault {
    /// A builder for [`SnapshotCopyGrantNotFoundFault`](crate::error::SnapshotCopyGrantNotFoundFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`SnapshotCopyGrantNotFoundFault`](crate::error::SnapshotCopyGrantNotFoundFault)
        pub fn build(self) -> crate::error::SnapshotCopyGrantNotFoundFault {
            crate::error::SnapshotCopyGrantNotFoundFault {
                message: self.message,
            }
        }
    }
}
impl SnapshotCopyGrantNotFoundFault {
    /// Creates a new builder-style object to manufacture [`SnapshotCopyGrantNotFoundFault`](crate::error::SnapshotCopyGrantNotFoundFault)
    pub fn builder() -> crate::error::snapshot_copy_grant_not_found_fault::Builder {
        crate::error::snapshot_copy_grant_not_found_fault::Builder::default()
    }
}

/// <p>The cluster already has cross-region snapshot copy enabled.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SnapshotCopyAlreadyEnabledFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SnapshotCopyAlreadyEnabledFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SnapshotCopyAlreadyEnabledFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl SnapshotCopyAlreadyEnabledFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for SnapshotCopyAlreadyEnabledFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "SnapshotCopyAlreadyEnabledFault")?;
        if let Some(inner_77) = &self.message {
            write!(f, ": {}", inner_77)?;
        }
        Ok(())
    }
}
impl std::error::Error for SnapshotCopyAlreadyEnabledFault {}
/// See [`SnapshotCopyAlreadyEnabledFault`](crate::error::SnapshotCopyAlreadyEnabledFault)
pub mod snapshot_copy_already_enabled_fault {
    /// A builder for [`SnapshotCopyAlreadyEnabledFault`](crate::error::SnapshotCopyAlreadyEnabledFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`SnapshotCopyAlreadyEnabledFault`](crate::error::SnapshotCopyAlreadyEnabledFault)
        pub fn build(self) -> crate::error::SnapshotCopyAlreadyEnabledFault {
            crate::error::SnapshotCopyAlreadyEnabledFault {
                message: self.message,
            }
        }
    }
}
impl SnapshotCopyAlreadyEnabledFault {
    /// Creates a new builder-style object to manufacture [`SnapshotCopyAlreadyEnabledFault`](crate::error::SnapshotCopyAlreadyEnabledFault)
    pub fn builder() -> crate::error::snapshot_copy_already_enabled_fault::Builder {
        crate::error::snapshot_copy_already_enabled_fault::Builder::default()
    }
}

/// <p>The specified options are incompatible.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IncompatibleOrderableOptions {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for IncompatibleOrderableOptions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IncompatibleOrderableOptions");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl IncompatibleOrderableOptions {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for IncompatibleOrderableOptions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "IncompatibleOrderableOptions")?;
        if let Some(inner_78) = &self.message {
            write!(f, ": {}", inner_78)?;
        }
        Ok(())
    }
}
impl std::error::Error for IncompatibleOrderableOptions {}
/// See [`IncompatibleOrderableOptions`](crate::error::IncompatibleOrderableOptions)
pub mod incompatible_orderable_options {
    /// A builder for [`IncompatibleOrderableOptions`](crate::error::IncompatibleOrderableOptions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`IncompatibleOrderableOptions`](crate::error::IncompatibleOrderableOptions)
        pub fn build(self) -> crate::error::IncompatibleOrderableOptions {
            crate::error::IncompatibleOrderableOptions {
                message: self.message,
            }
        }
    }
}
impl IncompatibleOrderableOptions {
    /// Creates a new builder-style object to manufacture [`IncompatibleOrderableOptions`](crate::error::IncompatibleOrderableOptions)
    pub fn builder() -> crate::error::incompatible_orderable_options::Builder {
        crate::error::incompatible_orderable_options::Builder::default()
    }
}

/// <p>Cross-region snapshot copy was temporarily disabled. Try your request
/// again.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CopyToRegionDisabledFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CopyToRegionDisabledFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CopyToRegionDisabledFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl CopyToRegionDisabledFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for CopyToRegionDisabledFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "CopyToRegionDisabledFault")?;
        if let Some(inner_79) = &self.message {
            write!(f, ": {}", inner_79)?;
        }
        Ok(())
    }
}
impl std::error::Error for CopyToRegionDisabledFault {}
/// See [`CopyToRegionDisabledFault`](crate::error::CopyToRegionDisabledFault)
pub mod copy_to_region_disabled_fault {
    /// A builder for [`CopyToRegionDisabledFault`](crate::error::CopyToRegionDisabledFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`CopyToRegionDisabledFault`](crate::error::CopyToRegionDisabledFault)
        pub fn build(self) -> crate::error::CopyToRegionDisabledFault {
            crate::error::CopyToRegionDisabledFault {
                message: self.message,
            }
        }
    }
}
impl CopyToRegionDisabledFault {
    /// Creates a new builder-style object to manufacture [`CopyToRegionDisabledFault`](crate::error::CopyToRegionDisabledFault)
    pub fn builder() -> crate::error::copy_to_region_disabled_fault::Builder {
        crate::error::copy_to_region_disabled_fault::Builder::default()
    }
}

/// <p>The string specified for the logging S3 key prefix does not comply with the
/// documented constraints.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidS3KeyPrefixFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidS3KeyPrefixFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidS3KeyPrefixFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidS3KeyPrefixFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidS3KeyPrefixFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidS3KeyPrefixFault")?;
        if let Some(inner_80) = &self.message {
            write!(f, ": {}", inner_80)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidS3KeyPrefixFault {}
/// See [`InvalidS3KeyPrefixFault`](crate::error::InvalidS3KeyPrefixFault)
pub mod invalid_s3_key_prefix_fault {
    /// A builder for [`InvalidS3KeyPrefixFault`](crate::error::InvalidS3KeyPrefixFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidS3KeyPrefixFault`](crate::error::InvalidS3KeyPrefixFault)
        pub fn build(self) -> crate::error::InvalidS3KeyPrefixFault {
            crate::error::InvalidS3KeyPrefixFault {
                message: self.message,
            }
        }
    }
}
impl InvalidS3KeyPrefixFault {
    /// Creates a new builder-style object to manufacture [`InvalidS3KeyPrefixFault`](crate::error::InvalidS3KeyPrefixFault)
    pub fn builder() -> crate::error::invalid_s3_key_prefix_fault::Builder {
        crate::error::invalid_s3_key_prefix_fault::Builder::default()
    }
}

/// <p>The S3 bucket name is invalid. For more information about naming rules, go to
/// <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/BucketRestrictions.html">Bucket
/// Restrictions and Limitations</a> in the Amazon Simple Storage Service (S3)
/// Developer Guide.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidS3BucketNameFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidS3BucketNameFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidS3BucketNameFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidS3BucketNameFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidS3BucketNameFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidS3BucketNameFault")?;
        if let Some(inner_81) = &self.message {
            write!(f, ": {}", inner_81)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidS3BucketNameFault {}
/// See [`InvalidS3BucketNameFault`](crate::error::InvalidS3BucketNameFault)
pub mod invalid_s3_bucket_name_fault {
    /// A builder for [`InvalidS3BucketNameFault`](crate::error::InvalidS3BucketNameFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidS3BucketNameFault`](crate::error::InvalidS3BucketNameFault)
        pub fn build(self) -> crate::error::InvalidS3BucketNameFault {
            crate::error::InvalidS3BucketNameFault {
                message: self.message,
            }
        }
    }
}
impl InvalidS3BucketNameFault {
    /// Creates a new builder-style object to manufacture [`InvalidS3BucketNameFault`](crate::error::InvalidS3BucketNameFault)
    pub fn builder() -> crate::error::invalid_s3_bucket_name_fault::Builder {
        crate::error::invalid_s3_bucket_name_fault::Builder::default()
    }
}

/// <p>The cluster does not have read bucket or put object permissions on the S3 bucket
/// specified when enabling logging.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InsufficientS3BucketPolicyFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InsufficientS3BucketPolicyFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InsufficientS3BucketPolicyFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InsufficientS3BucketPolicyFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InsufficientS3BucketPolicyFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InsufficientS3BucketPolicyFault")?;
        if let Some(inner_82) = &self.message {
            write!(f, ": {}", inner_82)?;
        }
        Ok(())
    }
}
impl std::error::Error for InsufficientS3BucketPolicyFault {}
/// See [`InsufficientS3BucketPolicyFault`](crate::error::InsufficientS3BucketPolicyFault)
pub mod insufficient_s3_bucket_policy_fault {
    /// A builder for [`InsufficientS3BucketPolicyFault`](crate::error::InsufficientS3BucketPolicyFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InsufficientS3BucketPolicyFault`](crate::error::InsufficientS3BucketPolicyFault)
        pub fn build(self) -> crate::error::InsufficientS3BucketPolicyFault {
            crate::error::InsufficientS3BucketPolicyFault {
                message: self.message,
            }
        }
    }
}
impl InsufficientS3BucketPolicyFault {
    /// Creates a new builder-style object to manufacture [`InsufficientS3BucketPolicyFault`](crate::error::InsufficientS3BucketPolicyFault)
    pub fn builder() -> crate::error::insufficient_s3_bucket_policy_fault::Builder {
        crate::error::insufficient_s3_bucket_policy_fault::Builder::default()
    }
}

/// <p>Could not find the specified S3 bucket.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BucketNotFoundFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for BucketNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BucketNotFoundFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl BucketNotFoundFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for BucketNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "BucketNotFoundFault")?;
        if let Some(inner_83) = &self.message {
            write!(f, ": {}", inner_83)?;
        }
        Ok(())
    }
}
impl std::error::Error for BucketNotFoundFault {}
/// See [`BucketNotFoundFault`](crate::error::BucketNotFoundFault)
pub mod bucket_not_found_fault {
    /// A builder for [`BucketNotFoundFault`](crate::error::BucketNotFoundFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`BucketNotFoundFault`](crate::error::BucketNotFoundFault)
        pub fn build(self) -> crate::error::BucketNotFoundFault {
            crate::error::BucketNotFoundFault {
                message: self.message,
            }
        }
    }
}
impl BucketNotFoundFault {
    /// Creates a new builder-style object to manufacture [`BucketNotFoundFault`](crate::error::BucketNotFoundFault)
    pub fn builder() -> crate::error::bucket_not_found_fault::Builder {
        crate::error::bucket_not_found_fault::Builder::default()
    }
}

/// <p>The namespace isn't valid because the namespace doesn't exist. Provide a valid namespace.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidNamespaceFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidNamespaceFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidNamespaceFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidNamespaceFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidNamespaceFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidNamespaceFault")?;
        if let Some(inner_84) = &self.message {
            write!(f, ": {}", inner_84)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidNamespaceFault {}
/// See [`InvalidNamespaceFault`](crate::error::InvalidNamespaceFault)
pub mod invalid_namespace_fault {
    /// A builder for [`InvalidNamespaceFault`](crate::error::InvalidNamespaceFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidNamespaceFault`](crate::error::InvalidNamespaceFault)
        pub fn build(self) -> crate::error::InvalidNamespaceFault {
            crate::error::InvalidNamespaceFault {
                message: self.message,
            }
        }
    }
}
impl InvalidNamespaceFault {
    /// Creates a new builder-style object to manufacture [`InvalidNamespaceFault`](crate::error::InvalidNamespaceFault)
    pub fn builder() -> crate::error::invalid_namespace_fault::Builder {
        crate::error::invalid_namespace_fault::Builder::default()
    }
}

/// <p>The cluster already has cross-region snapshot copy disabled.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SnapshotCopyAlreadyDisabledFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SnapshotCopyAlreadyDisabledFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SnapshotCopyAlreadyDisabledFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl SnapshotCopyAlreadyDisabledFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for SnapshotCopyAlreadyDisabledFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "SnapshotCopyAlreadyDisabledFault")?;
        if let Some(inner_85) = &self.message {
            write!(f, ": {}", inner_85)?;
        }
        Ok(())
    }
}
impl std::error::Error for SnapshotCopyAlreadyDisabledFault {}
/// See [`SnapshotCopyAlreadyDisabledFault`](crate::error::SnapshotCopyAlreadyDisabledFault)
pub mod snapshot_copy_already_disabled_fault {
    /// A builder for [`SnapshotCopyAlreadyDisabledFault`](crate::error::SnapshotCopyAlreadyDisabledFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`SnapshotCopyAlreadyDisabledFault`](crate::error::SnapshotCopyAlreadyDisabledFault)
        pub fn build(self) -> crate::error::SnapshotCopyAlreadyDisabledFault {
            crate::error::SnapshotCopyAlreadyDisabledFault {
                message: self.message,
            }
        }
    }
}
impl SnapshotCopyAlreadyDisabledFault {
    /// Creates a new builder-style object to manufacture [`SnapshotCopyAlreadyDisabledFault`](crate::error::SnapshotCopyAlreadyDisabledFault)
    pub fn builder() -> crate::error::snapshot_copy_already_disabled_fault::Builder {
        crate::error::snapshot_copy_already_disabled_fault::Builder::default()
    }
}

/// <p>The resource could not be found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceNotFoundFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundFault")?;
        if let Some(inner_86) = &self.message {
            write!(f, ": {}", inner_86)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundFault {}
/// See [`ResourceNotFoundFault`](crate::error::ResourceNotFoundFault)
pub mod resource_not_found_fault {
    /// A builder for [`ResourceNotFoundFault`](crate::error::ResourceNotFoundFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundFault`](crate::error::ResourceNotFoundFault)
        pub fn build(self) -> crate::error::ResourceNotFoundFault {
            crate::error::ResourceNotFoundFault {
                message: self.message,
            }
        }
    }
}
impl ResourceNotFoundFault {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundFault`](crate::error::ResourceNotFoundFault)
    pub fn builder() -> crate::error::resource_not_found_fault::Builder {
        crate::error::resource_not_found_fault::Builder::default()
    }
}

/// <p>The specified <code>TableRestoreRequestId</code> value was not found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TableRestoreNotFoundFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TableRestoreNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TableRestoreNotFoundFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TableRestoreNotFoundFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TableRestoreNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TableRestoreNotFoundFault")?;
        if let Some(inner_87) = &self.message {
            write!(f, ": {}", inner_87)?;
        }
        Ok(())
    }
}
impl std::error::Error for TableRestoreNotFoundFault {}
/// See [`TableRestoreNotFoundFault`](crate::error::TableRestoreNotFoundFault)
pub mod table_restore_not_found_fault {
    /// A builder for [`TableRestoreNotFoundFault`](crate::error::TableRestoreNotFoundFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TableRestoreNotFoundFault`](crate::error::TableRestoreNotFoundFault)
        pub fn build(self) -> crate::error::TableRestoreNotFoundFault {
            crate::error::TableRestoreNotFoundFault {
                message: self.message,
            }
        }
    }
}
impl TableRestoreNotFoundFault {
    /// Creates a new builder-style object to manufacture [`TableRestoreNotFoundFault`](crate::error::TableRestoreNotFoundFault)
    pub fn builder() -> crate::error::table_restore_not_found_fault::Builder {
        crate::error::table_restore_not_found_fault::Builder::default()
    }
}

/// <p>A resize operation for the specified cluster is not found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResizeNotFoundFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResizeNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResizeNotFoundFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResizeNotFoundFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResizeNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResizeNotFoundFault")?;
        if let Some(inner_88) = &self.message {
            write!(f, ": {}", inner_88)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResizeNotFoundFault {}
/// See [`ResizeNotFoundFault`](crate::error::ResizeNotFoundFault)
pub mod resize_not_found_fault {
    /// A builder for [`ResizeNotFoundFault`](crate::error::ResizeNotFoundFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResizeNotFoundFault`](crate::error::ResizeNotFoundFault)
        pub fn build(self) -> crate::error::ResizeNotFoundFault {
            crate::error::ResizeNotFoundFault {
                message: self.message,
            }
        }
    }
}
impl ResizeNotFoundFault {
    /// Creates a new builder-style object to manufacture [`ResizeNotFoundFault`](crate::error::ResizeNotFoundFault)
    pub fn builder() -> crate::error::resize_not_found_fault::Builder {
        crate::error::resize_not_found_fault::Builder::default()
    }
}

/// <p>The snapshot copy grant can't be deleted because it is used by one or more
/// clusters.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidSnapshotCopyGrantStateFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidSnapshotCopyGrantStateFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidSnapshotCopyGrantStateFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidSnapshotCopyGrantStateFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidSnapshotCopyGrantStateFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidSnapshotCopyGrantStateFault")?;
        if let Some(inner_89) = &self.message {
            write!(f, ": {}", inner_89)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidSnapshotCopyGrantStateFault {}
/// See [`InvalidSnapshotCopyGrantStateFault`](crate::error::InvalidSnapshotCopyGrantStateFault)
pub mod invalid_snapshot_copy_grant_state_fault {
    /// A builder for [`InvalidSnapshotCopyGrantStateFault`](crate::error::InvalidSnapshotCopyGrantStateFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidSnapshotCopyGrantStateFault`](crate::error::InvalidSnapshotCopyGrantStateFault)
        pub fn build(self) -> crate::error::InvalidSnapshotCopyGrantStateFault {
            crate::error::InvalidSnapshotCopyGrantStateFault {
                message: self.message,
            }
        }
    }
}
impl InvalidSnapshotCopyGrantStateFault {
    /// Creates a new builder-style object to manufacture [`InvalidSnapshotCopyGrantStateFault`](crate::error::InvalidSnapshotCopyGrantStateFault)
    pub fn builder() -> crate::error::invalid_snapshot_copy_grant_state_fault::Builder {
        crate::error::invalid_snapshot_copy_grant_state_fault::Builder::default()
    }
}

/// <p>The specified HSM configuration is not in the <code>available</code> state, or it
/// is still in use by one or more Amazon Redshift clusters.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidHsmConfigurationStateFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidHsmConfigurationStateFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidHsmConfigurationStateFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidHsmConfigurationStateFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidHsmConfigurationStateFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidHsmConfigurationStateFault")?;
        if let Some(inner_90) = &self.message {
            write!(f, ": {}", inner_90)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidHsmConfigurationStateFault {}
/// See [`InvalidHsmConfigurationStateFault`](crate::error::InvalidHsmConfigurationStateFault)
pub mod invalid_hsm_configuration_state_fault {
    /// A builder for [`InvalidHsmConfigurationStateFault`](crate::error::InvalidHsmConfigurationStateFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidHsmConfigurationStateFault`](crate::error::InvalidHsmConfigurationStateFault)
        pub fn build(self) -> crate::error::InvalidHsmConfigurationStateFault {
            crate::error::InvalidHsmConfigurationStateFault {
                message: self.message,
            }
        }
    }
}
impl InvalidHsmConfigurationStateFault {
    /// Creates a new builder-style object to manufacture [`InvalidHsmConfigurationStateFault`](crate::error::InvalidHsmConfigurationStateFault)
    pub fn builder() -> crate::error::invalid_hsm_configuration_state_fault::Builder {
        crate::error::invalid_hsm_configuration_state_fault::Builder::default()
    }
}

/// <p>The specified HSM client certificate is not in the <code>available</code> state, or
/// it is still in use by one or more Amazon Redshift clusters.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidHsmClientCertificateStateFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidHsmClientCertificateStateFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidHsmClientCertificateStateFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidHsmClientCertificateStateFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidHsmClientCertificateStateFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidHsmClientCertificateStateFault")?;
        if let Some(inner_91) = &self.message {
            write!(f, ": {}", inner_91)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidHsmClientCertificateStateFault {}
/// See [`InvalidHsmClientCertificateStateFault`](crate::error::InvalidHsmClientCertificateStateFault)
pub mod invalid_hsm_client_certificate_state_fault {
    /// A builder for [`InvalidHsmClientCertificateStateFault`](crate::error::InvalidHsmClientCertificateStateFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidHsmClientCertificateStateFault`](crate::error::InvalidHsmClientCertificateStateFault)
        pub fn build(self) -> crate::error::InvalidHsmClientCertificateStateFault {
            crate::error::InvalidHsmClientCertificateStateFault {
                message: self.message,
            }
        }
    }
}
impl InvalidHsmClientCertificateStateFault {
    /// Creates a new builder-style object to manufacture [`InvalidHsmClientCertificateStateFault`](crate::error::InvalidHsmClientCertificateStateFault)
    pub fn builder() -> crate::error::invalid_hsm_client_certificate_state_fault::Builder {
        crate::error::invalid_hsm_client_certificate_state_fault::Builder::default()
    }
}

/// <p>The state of the subnet is invalid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidClusterSubnetStateFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidClusterSubnetStateFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidClusterSubnetStateFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidClusterSubnetStateFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidClusterSubnetStateFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidClusterSubnetStateFault")?;
        if let Some(inner_92) = &self.message {
            write!(f, ": {}", inner_92)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidClusterSubnetStateFault {}
/// See [`InvalidClusterSubnetStateFault`](crate::error::InvalidClusterSubnetStateFault)
pub mod invalid_cluster_subnet_state_fault {
    /// A builder for [`InvalidClusterSubnetStateFault`](crate::error::InvalidClusterSubnetStateFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidClusterSubnetStateFault`](crate::error::InvalidClusterSubnetStateFault)
        pub fn build(self) -> crate::error::InvalidClusterSubnetStateFault {
            crate::error::InvalidClusterSubnetStateFault {
                message: self.message,
            }
        }
    }
}
impl InvalidClusterSubnetStateFault {
    /// Creates a new builder-style object to manufacture [`InvalidClusterSubnetStateFault`](crate::error::InvalidClusterSubnetStateFault)
    pub fn builder() -> crate::error::invalid_cluster_subnet_state_fault::Builder {
        crate::error::invalid_cluster_subnet_state_fault::Builder::default()
    }
}

/// <p>The request would result in the user exceeding the allowed number of cluster
/// snapshots.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ClusterSnapshotQuotaExceededFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ClusterSnapshotQuotaExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ClusterSnapshotQuotaExceededFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ClusterSnapshotQuotaExceededFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ClusterSnapshotQuotaExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ClusterSnapshotQuotaExceededFault")?;
        if let Some(inner_93) = &self.message {
            write!(f, ": {}", inner_93)?;
        }
        Ok(())
    }
}
impl std::error::Error for ClusterSnapshotQuotaExceededFault {}
/// See [`ClusterSnapshotQuotaExceededFault`](crate::error::ClusterSnapshotQuotaExceededFault)
pub mod cluster_snapshot_quota_exceeded_fault {
    /// A builder for [`ClusterSnapshotQuotaExceededFault`](crate::error::ClusterSnapshotQuotaExceededFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ClusterSnapshotQuotaExceededFault`](crate::error::ClusterSnapshotQuotaExceededFault)
        pub fn build(self) -> crate::error::ClusterSnapshotQuotaExceededFault {
            crate::error::ClusterSnapshotQuotaExceededFault {
                message: self.message,
            }
        }
    }
}
impl ClusterSnapshotQuotaExceededFault {
    /// Creates a new builder-style object to manufacture [`ClusterSnapshotQuotaExceededFault`](crate::error::ClusterSnapshotQuotaExceededFault)
    pub fn builder() -> crate::error::cluster_snapshot_quota_exceeded_fault::Builder {
        crate::error::cluster_snapshot_quota_exceeded_fault::Builder::default()
    }
}

/// <p>The value specified as a snapshot identifier is already used by an existing
/// snapshot.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ClusterSnapshotAlreadyExistsFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ClusterSnapshotAlreadyExistsFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ClusterSnapshotAlreadyExistsFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ClusterSnapshotAlreadyExistsFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ClusterSnapshotAlreadyExistsFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ClusterSnapshotAlreadyExistsFault")?;
        if let Some(inner_94) = &self.message {
            write!(f, ": {}", inner_94)?;
        }
        Ok(())
    }
}
impl std::error::Error for ClusterSnapshotAlreadyExistsFault {}
/// See [`ClusterSnapshotAlreadyExistsFault`](crate::error::ClusterSnapshotAlreadyExistsFault)
pub mod cluster_snapshot_already_exists_fault {
    /// A builder for [`ClusterSnapshotAlreadyExistsFault`](crate::error::ClusterSnapshotAlreadyExistsFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ClusterSnapshotAlreadyExistsFault`](crate::error::ClusterSnapshotAlreadyExistsFault)
        pub fn build(self) -> crate::error::ClusterSnapshotAlreadyExistsFault {
            crate::error::ClusterSnapshotAlreadyExistsFault {
                message: self.message,
            }
        }
    }
}
impl ClusterSnapshotAlreadyExistsFault {
    /// Creates a new builder-style object to manufacture [`ClusterSnapshotAlreadyExistsFault`](crate::error::ClusterSnapshotAlreadyExistsFault)
    pub fn builder() -> crate::error::cluster_snapshot_already_exists_fault::Builder {
        crate::error::cluster_snapshot_already_exists_fault::Builder::default()
    }
}

/// <p>The usage limit already exists. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UsageLimitAlreadyExistsFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UsageLimitAlreadyExistsFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UsageLimitAlreadyExistsFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl UsageLimitAlreadyExistsFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for UsageLimitAlreadyExistsFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "UsageLimitAlreadyExistsFault")?;
        if let Some(inner_95) = &self.message {
            write!(f, ": {}", inner_95)?;
        }
        Ok(())
    }
}
impl std::error::Error for UsageLimitAlreadyExistsFault {}
/// See [`UsageLimitAlreadyExistsFault`](crate::error::UsageLimitAlreadyExistsFault)
pub mod usage_limit_already_exists_fault {
    /// A builder for [`UsageLimitAlreadyExistsFault`](crate::error::UsageLimitAlreadyExistsFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`UsageLimitAlreadyExistsFault`](crate::error::UsageLimitAlreadyExistsFault)
        pub fn build(self) -> crate::error::UsageLimitAlreadyExistsFault {
            crate::error::UsageLimitAlreadyExistsFault {
                message: self.message,
            }
        }
    }
}
impl UsageLimitAlreadyExistsFault {
    /// Creates a new builder-style object to manufacture [`UsageLimitAlreadyExistsFault`](crate::error::UsageLimitAlreadyExistsFault)
    pub fn builder() -> crate::error::usage_limit_already_exists_fault::Builder {
        crate::error::usage_limit_already_exists_fault::Builder::default()
    }
}

/// <p>You have exceeded the quota of snapshot schedules. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SnapshotScheduleQuotaExceededFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SnapshotScheduleQuotaExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SnapshotScheduleQuotaExceededFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl SnapshotScheduleQuotaExceededFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for SnapshotScheduleQuotaExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "SnapshotScheduleQuotaExceededFault")?;
        if let Some(inner_96) = &self.message {
            write!(f, ": {}", inner_96)?;
        }
        Ok(())
    }
}
impl std::error::Error for SnapshotScheduleQuotaExceededFault {}
/// See [`SnapshotScheduleQuotaExceededFault`](crate::error::SnapshotScheduleQuotaExceededFault)
pub mod snapshot_schedule_quota_exceeded_fault {
    /// A builder for [`SnapshotScheduleQuotaExceededFault`](crate::error::SnapshotScheduleQuotaExceededFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`SnapshotScheduleQuotaExceededFault`](crate::error::SnapshotScheduleQuotaExceededFault)
        pub fn build(self) -> crate::error::SnapshotScheduleQuotaExceededFault {
            crate::error::SnapshotScheduleQuotaExceededFault {
                message: self.message,
            }
        }
    }
}
impl SnapshotScheduleQuotaExceededFault {
    /// Creates a new builder-style object to manufacture [`SnapshotScheduleQuotaExceededFault`](crate::error::SnapshotScheduleQuotaExceededFault)
    pub fn builder() -> crate::error::snapshot_schedule_quota_exceeded_fault::Builder {
        crate::error::snapshot_schedule_quota_exceeded_fault::Builder::default()
    }
}

/// <p>The specified snapshot schedule already exists. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SnapshotScheduleAlreadyExistsFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SnapshotScheduleAlreadyExistsFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SnapshotScheduleAlreadyExistsFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl SnapshotScheduleAlreadyExistsFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for SnapshotScheduleAlreadyExistsFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "SnapshotScheduleAlreadyExistsFault")?;
        if let Some(inner_97) = &self.message {
            write!(f, ": {}", inner_97)?;
        }
        Ok(())
    }
}
impl std::error::Error for SnapshotScheduleAlreadyExistsFault {}
/// See [`SnapshotScheduleAlreadyExistsFault`](crate::error::SnapshotScheduleAlreadyExistsFault)
pub mod snapshot_schedule_already_exists_fault {
    /// A builder for [`SnapshotScheduleAlreadyExistsFault`](crate::error::SnapshotScheduleAlreadyExistsFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`SnapshotScheduleAlreadyExistsFault`](crate::error::SnapshotScheduleAlreadyExistsFault)
        pub fn build(self) -> crate::error::SnapshotScheduleAlreadyExistsFault {
            crate::error::SnapshotScheduleAlreadyExistsFault {
                message: self.message,
            }
        }
    }
}
impl SnapshotScheduleAlreadyExistsFault {
    /// Creates a new builder-style object to manufacture [`SnapshotScheduleAlreadyExistsFault`](crate::error::SnapshotScheduleAlreadyExistsFault)
    pub fn builder() -> crate::error::snapshot_schedule_already_exists_fault::Builder {
        crate::error::snapshot_schedule_already_exists_fault::Builder::default()
    }
}

/// <p>The definition you submitted is not supported.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ScheduleDefinitionTypeUnsupportedFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ScheduleDefinitionTypeUnsupportedFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ScheduleDefinitionTypeUnsupportedFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ScheduleDefinitionTypeUnsupportedFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ScheduleDefinitionTypeUnsupportedFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ScheduleDefinitionTypeUnsupportedFault")?;
        if let Some(inner_98) = &self.message {
            write!(f, ": {}", inner_98)?;
        }
        Ok(())
    }
}
impl std::error::Error for ScheduleDefinitionTypeUnsupportedFault {}
/// See [`ScheduleDefinitionTypeUnsupportedFault`](crate::error::ScheduleDefinitionTypeUnsupportedFault)
pub mod schedule_definition_type_unsupported_fault {
    /// A builder for [`ScheduleDefinitionTypeUnsupportedFault`](crate::error::ScheduleDefinitionTypeUnsupportedFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ScheduleDefinitionTypeUnsupportedFault`](crate::error::ScheduleDefinitionTypeUnsupportedFault)
        pub fn build(self) -> crate::error::ScheduleDefinitionTypeUnsupportedFault {
            crate::error::ScheduleDefinitionTypeUnsupportedFault {
                message: self.message,
            }
        }
    }
}
impl ScheduleDefinitionTypeUnsupportedFault {
    /// Creates a new builder-style object to manufacture [`ScheduleDefinitionTypeUnsupportedFault`](crate::error::ScheduleDefinitionTypeUnsupportedFault)
    pub fn builder() -> crate::error::schedule_definition_type_unsupported_fault::Builder {
        crate::error::schedule_definition_type_unsupported_fault::Builder::default()
    }
}

/// <p>The Amazon Web Services account has exceeded the maximum number of snapshot copy grants in this
/// region.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SnapshotCopyGrantQuotaExceededFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SnapshotCopyGrantQuotaExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SnapshotCopyGrantQuotaExceededFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl SnapshotCopyGrantQuotaExceededFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for SnapshotCopyGrantQuotaExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "SnapshotCopyGrantQuotaExceededFault")?;
        if let Some(inner_99) = &self.message {
            write!(f, ": {}", inner_99)?;
        }
        Ok(())
    }
}
impl std::error::Error for SnapshotCopyGrantQuotaExceededFault {}
/// See [`SnapshotCopyGrantQuotaExceededFault`](crate::error::SnapshotCopyGrantQuotaExceededFault)
pub mod snapshot_copy_grant_quota_exceeded_fault {
    /// A builder for [`SnapshotCopyGrantQuotaExceededFault`](crate::error::SnapshotCopyGrantQuotaExceededFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`SnapshotCopyGrantQuotaExceededFault`](crate::error::SnapshotCopyGrantQuotaExceededFault)
        pub fn build(self) -> crate::error::SnapshotCopyGrantQuotaExceededFault {
            crate::error::SnapshotCopyGrantQuotaExceededFault {
                message: self.message,
            }
        }
    }
}
impl SnapshotCopyGrantQuotaExceededFault {
    /// Creates a new builder-style object to manufacture [`SnapshotCopyGrantQuotaExceededFault`](crate::error::SnapshotCopyGrantQuotaExceededFault)
    pub fn builder() -> crate::error::snapshot_copy_grant_quota_exceeded_fault::Builder {
        crate::error::snapshot_copy_grant_quota_exceeded_fault::Builder::default()
    }
}

/// <p>The snapshot copy grant can't be created because a grant with the same name already
/// exists.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SnapshotCopyGrantAlreadyExistsFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SnapshotCopyGrantAlreadyExistsFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SnapshotCopyGrantAlreadyExistsFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl SnapshotCopyGrantAlreadyExistsFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for SnapshotCopyGrantAlreadyExistsFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "SnapshotCopyGrantAlreadyExistsFault")?;
        if let Some(inner_100) = &self.message {
            write!(f, ": {}", inner_100)?;
        }
        Ok(())
    }
}
impl std::error::Error for SnapshotCopyGrantAlreadyExistsFault {}
/// See [`SnapshotCopyGrantAlreadyExistsFault`](crate::error::SnapshotCopyGrantAlreadyExistsFault)
pub mod snapshot_copy_grant_already_exists_fault {
    /// A builder for [`SnapshotCopyGrantAlreadyExistsFault`](crate::error::SnapshotCopyGrantAlreadyExistsFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`SnapshotCopyGrantAlreadyExistsFault`](crate::error::SnapshotCopyGrantAlreadyExistsFault)
        pub fn build(self) -> crate::error::SnapshotCopyGrantAlreadyExistsFault {
            crate::error::SnapshotCopyGrantAlreadyExistsFault {
                message: self.message,
            }
        }
    }
}
impl SnapshotCopyGrantAlreadyExistsFault {
    /// Creates a new builder-style object to manufacture [`SnapshotCopyGrantAlreadyExistsFault`](crate::error::SnapshotCopyGrantAlreadyExistsFault)
    pub fn builder() -> crate::error::snapshot_copy_grant_already_exists_fault::Builder {
        crate::error::snapshot_copy_grant_already_exists_fault::Builder::default()
    }
}

/// <p>The quota for scheduled actions exceeded. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ScheduledActionQuotaExceededFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ScheduledActionQuotaExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ScheduledActionQuotaExceededFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ScheduledActionQuotaExceededFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ScheduledActionQuotaExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ScheduledActionQuotaExceededFault")?;
        if let Some(inner_101) = &self.message {
            write!(f, ": {}", inner_101)?;
        }
        Ok(())
    }
}
impl std::error::Error for ScheduledActionQuotaExceededFault {}
/// See [`ScheduledActionQuotaExceededFault`](crate::error::ScheduledActionQuotaExceededFault)
pub mod scheduled_action_quota_exceeded_fault {
    /// A builder for [`ScheduledActionQuotaExceededFault`](crate::error::ScheduledActionQuotaExceededFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ScheduledActionQuotaExceededFault`](crate::error::ScheduledActionQuotaExceededFault)
        pub fn build(self) -> crate::error::ScheduledActionQuotaExceededFault {
            crate::error::ScheduledActionQuotaExceededFault {
                message: self.message,
            }
        }
    }
}
impl ScheduledActionQuotaExceededFault {
    /// Creates a new builder-style object to manufacture [`ScheduledActionQuotaExceededFault`](crate::error::ScheduledActionQuotaExceededFault)
    pub fn builder() -> crate::error::scheduled_action_quota_exceeded_fault::Builder {
        crate::error::scheduled_action_quota_exceeded_fault::Builder::default()
    }
}

/// <p>The scheduled action already exists. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ScheduledActionAlreadyExistsFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ScheduledActionAlreadyExistsFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ScheduledActionAlreadyExistsFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ScheduledActionAlreadyExistsFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ScheduledActionAlreadyExistsFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ScheduledActionAlreadyExistsFault")?;
        if let Some(inner_102) = &self.message {
            write!(f, ": {}", inner_102)?;
        }
        Ok(())
    }
}
impl std::error::Error for ScheduledActionAlreadyExistsFault {}
/// See [`ScheduledActionAlreadyExistsFault`](crate::error::ScheduledActionAlreadyExistsFault)
pub mod scheduled_action_already_exists_fault {
    /// A builder for [`ScheduledActionAlreadyExistsFault`](crate::error::ScheduledActionAlreadyExistsFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ScheduledActionAlreadyExistsFault`](crate::error::ScheduledActionAlreadyExistsFault)
        pub fn build(self) -> crate::error::ScheduledActionAlreadyExistsFault {
            crate::error::ScheduledActionAlreadyExistsFault {
                message: self.message,
            }
        }
    }
}
impl ScheduledActionAlreadyExistsFault {
    /// Creates a new builder-style object to manufacture [`ScheduledActionAlreadyExistsFault`](crate::error::ScheduledActionAlreadyExistsFault)
    pub fn builder() -> crate::error::scheduled_action_already_exists_fault::Builder {
        crate::error::scheduled_action_already_exists_fault::Builder::default()
    }
}

/// <p>The quota for HSM configurations has been reached.
/// For information about increasing your quota, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon Redshift</a>
/// in the <i>Amazon Redshift Cluster Management Guide</i>.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HsmConfigurationQuotaExceededFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for HsmConfigurationQuotaExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HsmConfigurationQuotaExceededFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl HsmConfigurationQuotaExceededFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for HsmConfigurationQuotaExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "HsmConfigurationQuotaExceededFault")?;
        if let Some(inner_103) = &self.message {
            write!(f, ": {}", inner_103)?;
        }
        Ok(())
    }
}
impl std::error::Error for HsmConfigurationQuotaExceededFault {}
/// See [`HsmConfigurationQuotaExceededFault`](crate::error::HsmConfigurationQuotaExceededFault)
pub mod hsm_configuration_quota_exceeded_fault {
    /// A builder for [`HsmConfigurationQuotaExceededFault`](crate::error::HsmConfigurationQuotaExceededFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`HsmConfigurationQuotaExceededFault`](crate::error::HsmConfigurationQuotaExceededFault)
        pub fn build(self) -> crate::error::HsmConfigurationQuotaExceededFault {
            crate::error::HsmConfigurationQuotaExceededFault {
                message: self.message,
            }
        }
    }
}
impl HsmConfigurationQuotaExceededFault {
    /// Creates a new builder-style object to manufacture [`HsmConfigurationQuotaExceededFault`](crate::error::HsmConfigurationQuotaExceededFault)
    pub fn builder() -> crate::error::hsm_configuration_quota_exceeded_fault::Builder {
        crate::error::hsm_configuration_quota_exceeded_fault::Builder::default()
    }
}

/// <p>There is already an existing Amazon Redshift HSM configuration with the specified
/// identifier.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HsmConfigurationAlreadyExistsFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for HsmConfigurationAlreadyExistsFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HsmConfigurationAlreadyExistsFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl HsmConfigurationAlreadyExistsFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for HsmConfigurationAlreadyExistsFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "HsmConfigurationAlreadyExistsFault")?;
        if let Some(inner_104) = &self.message {
            write!(f, ": {}", inner_104)?;
        }
        Ok(())
    }
}
impl std::error::Error for HsmConfigurationAlreadyExistsFault {}
/// See [`HsmConfigurationAlreadyExistsFault`](crate::error::HsmConfigurationAlreadyExistsFault)
pub mod hsm_configuration_already_exists_fault {
    /// A builder for [`HsmConfigurationAlreadyExistsFault`](crate::error::HsmConfigurationAlreadyExistsFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`HsmConfigurationAlreadyExistsFault`](crate::error::HsmConfigurationAlreadyExistsFault)
        pub fn build(self) -> crate::error::HsmConfigurationAlreadyExistsFault {
            crate::error::HsmConfigurationAlreadyExistsFault {
                message: self.message,
            }
        }
    }
}
impl HsmConfigurationAlreadyExistsFault {
    /// Creates a new builder-style object to manufacture [`HsmConfigurationAlreadyExistsFault`](crate::error::HsmConfigurationAlreadyExistsFault)
    pub fn builder() -> crate::error::hsm_configuration_already_exists_fault::Builder {
        crate::error::hsm_configuration_already_exists_fault::Builder::default()
    }
}

/// <p>The quota for HSM client certificates has been reached.
/// For information about increasing your quota, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon Redshift</a>
/// in the <i>Amazon Redshift Cluster Management Guide</i>.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HsmClientCertificateQuotaExceededFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for HsmClientCertificateQuotaExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HsmClientCertificateQuotaExceededFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl HsmClientCertificateQuotaExceededFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for HsmClientCertificateQuotaExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "HsmClientCertificateQuotaExceededFault")?;
        if let Some(inner_105) = &self.message {
            write!(f, ": {}", inner_105)?;
        }
        Ok(())
    }
}
impl std::error::Error for HsmClientCertificateQuotaExceededFault {}
/// See [`HsmClientCertificateQuotaExceededFault`](crate::error::HsmClientCertificateQuotaExceededFault)
pub mod hsm_client_certificate_quota_exceeded_fault {
    /// A builder for [`HsmClientCertificateQuotaExceededFault`](crate::error::HsmClientCertificateQuotaExceededFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`HsmClientCertificateQuotaExceededFault`](crate::error::HsmClientCertificateQuotaExceededFault)
        pub fn build(self) -> crate::error::HsmClientCertificateQuotaExceededFault {
            crate::error::HsmClientCertificateQuotaExceededFault {
                message: self.message,
            }
        }
    }
}
impl HsmClientCertificateQuotaExceededFault {
    /// Creates a new builder-style object to manufacture [`HsmClientCertificateQuotaExceededFault`](crate::error::HsmClientCertificateQuotaExceededFault)
    pub fn builder() -> crate::error::hsm_client_certificate_quota_exceeded_fault::Builder {
        crate::error::hsm_client_certificate_quota_exceeded_fault::Builder::default()
    }
}

/// <p>There is already an existing Amazon Redshift HSM client certificate with the specified
/// identifier.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HsmClientCertificateAlreadyExistsFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for HsmClientCertificateAlreadyExistsFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HsmClientCertificateAlreadyExistsFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl HsmClientCertificateAlreadyExistsFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for HsmClientCertificateAlreadyExistsFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "HsmClientCertificateAlreadyExistsFault")?;
        if let Some(inner_106) = &self.message {
            write!(f, ": {}", inner_106)?;
        }
        Ok(())
    }
}
impl std::error::Error for HsmClientCertificateAlreadyExistsFault {}
/// See [`HsmClientCertificateAlreadyExistsFault`](crate::error::HsmClientCertificateAlreadyExistsFault)
pub mod hsm_client_certificate_already_exists_fault {
    /// A builder for [`HsmClientCertificateAlreadyExistsFault`](crate::error::HsmClientCertificateAlreadyExistsFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`HsmClientCertificateAlreadyExistsFault`](crate::error::HsmClientCertificateAlreadyExistsFault)
        pub fn build(self) -> crate::error::HsmClientCertificateAlreadyExistsFault {
            crate::error::HsmClientCertificateAlreadyExistsFault {
                message: self.message,
            }
        }
    }
}
impl HsmClientCertificateAlreadyExistsFault {
    /// Creates a new builder-style object to manufacture [`HsmClientCertificateAlreadyExistsFault`](crate::error::HsmClientCertificateAlreadyExistsFault)
    pub fn builder() -> crate::error::hsm_client_certificate_already_exists_fault::Builder {
        crate::error::hsm_client_certificate_already_exists_fault::Builder::default()
    }
}

/// <p>There is already an existing event notification subscription with the specified
/// name.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SubscriptionAlreadyExistFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SubscriptionAlreadyExistFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SubscriptionAlreadyExistFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl SubscriptionAlreadyExistFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for SubscriptionAlreadyExistFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "SubscriptionAlreadyExistFault")?;
        if let Some(inner_107) = &self.message {
            write!(f, ": {}", inner_107)?;
        }
        Ok(())
    }
}
impl std::error::Error for SubscriptionAlreadyExistFault {}
/// See [`SubscriptionAlreadyExistFault`](crate::error::SubscriptionAlreadyExistFault)
pub mod subscription_already_exist_fault {
    /// A builder for [`SubscriptionAlreadyExistFault`](crate::error::SubscriptionAlreadyExistFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`SubscriptionAlreadyExistFault`](crate::error::SubscriptionAlreadyExistFault)
        pub fn build(self) -> crate::error::SubscriptionAlreadyExistFault {
            crate::error::SubscriptionAlreadyExistFault {
                message: self.message,
            }
        }
    }
}
impl SubscriptionAlreadyExistFault {
    /// Creates a new builder-style object to manufacture [`SubscriptionAlreadyExistFault`](crate::error::SubscriptionAlreadyExistFault)
    pub fn builder() -> crate::error::subscription_already_exist_fault::Builder {
        crate::error::subscription_already_exist_fault::Builder::default()
    }
}

/// <p>The request would exceed the allowed number of event subscriptions for this
/// account.
/// For information about increasing your quota, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon Redshift</a>
/// in the <i>Amazon Redshift Cluster Management Guide</i>.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EventSubscriptionQuotaExceededFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for EventSubscriptionQuotaExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EventSubscriptionQuotaExceededFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl EventSubscriptionQuotaExceededFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for EventSubscriptionQuotaExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "EventSubscriptionQuotaExceededFault")?;
        if let Some(inner_108) = &self.message {
            write!(f, ": {}", inner_108)?;
        }
        Ok(())
    }
}
impl std::error::Error for EventSubscriptionQuotaExceededFault {}
/// See [`EventSubscriptionQuotaExceededFault`](crate::error::EventSubscriptionQuotaExceededFault)
pub mod event_subscription_quota_exceeded_fault {
    /// A builder for [`EventSubscriptionQuotaExceededFault`](crate::error::EventSubscriptionQuotaExceededFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`EventSubscriptionQuotaExceededFault`](crate::error::EventSubscriptionQuotaExceededFault)
        pub fn build(self) -> crate::error::EventSubscriptionQuotaExceededFault {
            crate::error::EventSubscriptionQuotaExceededFault {
                message: self.message,
            }
        }
    }
}
impl EventSubscriptionQuotaExceededFault {
    /// Creates a new builder-style object to manufacture [`EventSubscriptionQuotaExceededFault`](crate::error::EventSubscriptionQuotaExceededFault)
    pub fn builder() -> crate::error::event_subscription_quota_exceeded_fault::Builder {
        crate::error::event_subscription_quota_exceeded_fault::Builder::default()
    }
}

/// <p>The number of Redshift-managed VPC endpoints per cluster has exceeded its limit.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EndpointsPerClusterLimitExceededFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for EndpointsPerClusterLimitExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EndpointsPerClusterLimitExceededFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl EndpointsPerClusterLimitExceededFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for EndpointsPerClusterLimitExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "EndpointsPerClusterLimitExceededFault")?;
        if let Some(inner_109) = &self.message {
            write!(f, ": {}", inner_109)?;
        }
        Ok(())
    }
}
impl std::error::Error for EndpointsPerClusterLimitExceededFault {}
/// See [`EndpointsPerClusterLimitExceededFault`](crate::error::EndpointsPerClusterLimitExceededFault)
pub mod endpoints_per_cluster_limit_exceeded_fault {
    /// A builder for [`EndpointsPerClusterLimitExceededFault`](crate::error::EndpointsPerClusterLimitExceededFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`EndpointsPerClusterLimitExceededFault`](crate::error::EndpointsPerClusterLimitExceededFault)
        pub fn build(self) -> crate::error::EndpointsPerClusterLimitExceededFault {
            crate::error::EndpointsPerClusterLimitExceededFault {
                message: self.message,
            }
        }
    }
}
impl EndpointsPerClusterLimitExceededFault {
    /// Creates a new builder-style object to manufacture [`EndpointsPerClusterLimitExceededFault`](crate::error::EndpointsPerClusterLimitExceededFault)
    pub fn builder() -> crate::error::endpoints_per_cluster_limit_exceeded_fault::Builder {
        crate::error::endpoints_per_cluster_limit_exceeded_fault::Builder::default()
    }
}

/// <p>The number of Redshift-managed VPC endpoints per authorization has exceeded its limit.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EndpointsPerAuthorizationLimitExceededFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for EndpointsPerAuthorizationLimitExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EndpointsPerAuthorizationLimitExceededFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl EndpointsPerAuthorizationLimitExceededFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for EndpointsPerAuthorizationLimitExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "EndpointsPerAuthorizationLimitExceededFault")?;
        if let Some(inner_110) = &self.message {
            write!(f, ": {}", inner_110)?;
        }
        Ok(())
    }
}
impl std::error::Error for EndpointsPerAuthorizationLimitExceededFault {}
/// See [`EndpointsPerAuthorizationLimitExceededFault`](crate::error::EndpointsPerAuthorizationLimitExceededFault)
pub mod endpoints_per_authorization_limit_exceeded_fault {
    /// A builder for [`EndpointsPerAuthorizationLimitExceededFault`](crate::error::EndpointsPerAuthorizationLimitExceededFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`EndpointsPerAuthorizationLimitExceededFault`](crate::error::EndpointsPerAuthorizationLimitExceededFault)
        pub fn build(self) -> crate::error::EndpointsPerAuthorizationLimitExceededFault {
            crate::error::EndpointsPerAuthorizationLimitExceededFault {
                message: self.message,
            }
        }
    }
}
impl EndpointsPerAuthorizationLimitExceededFault {
    /// Creates a new builder-style object to manufacture [`EndpointsPerAuthorizationLimitExceededFault`](crate::error::EndpointsPerAuthorizationLimitExceededFault)
    pub fn builder() -> crate::error::endpoints_per_authorization_limit_exceeded_fault::Builder {
        crate::error::endpoints_per_authorization_limit_exceeded_fault::Builder::default()
    }
}

/// <p>The account already has a Redshift-managed VPC endpoint with the given identifier.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EndpointAlreadyExistsFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for EndpointAlreadyExistsFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EndpointAlreadyExistsFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl EndpointAlreadyExistsFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for EndpointAlreadyExistsFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "EndpointAlreadyExistsFault")?;
        if let Some(inner_111) = &self.message {
            write!(f, ": {}", inner_111)?;
        }
        Ok(())
    }
}
impl std::error::Error for EndpointAlreadyExistsFault {}
/// See [`EndpointAlreadyExistsFault`](crate::error::EndpointAlreadyExistsFault)
pub mod endpoint_already_exists_fault {
    /// A builder for [`EndpointAlreadyExistsFault`](crate::error::EndpointAlreadyExistsFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`EndpointAlreadyExistsFault`](crate::error::EndpointAlreadyExistsFault)
        pub fn build(self) -> crate::error::EndpointAlreadyExistsFault {
            crate::error::EndpointAlreadyExistsFault {
                message: self.message,
            }
        }
    }
}
impl EndpointAlreadyExistsFault {
    /// Creates a new builder-style object to manufacture [`EndpointAlreadyExistsFault`](crate::error::EndpointAlreadyExistsFault)
    pub fn builder() -> crate::error::endpoint_already_exists_fault::Builder {
        crate::error::endpoint_already_exists_fault::Builder::default()
    }
}

/// <p>You are not authorized to access the cluster.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessToClusterDeniedFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AccessToClusterDeniedFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessToClusterDeniedFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AccessToClusterDeniedFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AccessToClusterDeniedFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AccessToClusterDeniedFault")?;
        if let Some(inner_112) = &self.message {
            write!(f, ": {}", inner_112)?;
        }
        Ok(())
    }
}
impl std::error::Error for AccessToClusterDeniedFault {}
/// See [`AccessToClusterDeniedFault`](crate::error::AccessToClusterDeniedFault)
pub mod access_to_cluster_denied_fault {
    /// A builder for [`AccessToClusterDeniedFault`](crate::error::AccessToClusterDeniedFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessToClusterDeniedFault`](crate::error::AccessToClusterDeniedFault)
        pub fn build(self) -> crate::error::AccessToClusterDeniedFault {
            crate::error::AccessToClusterDeniedFault {
                message: self.message,
            }
        }
    }
}
impl AccessToClusterDeniedFault {
    /// Creates a new builder-style object to manufacture [`AccessToClusterDeniedFault`](crate::error::AccessToClusterDeniedFault)
    pub fn builder() -> crate::error::access_to_cluster_denied_fault::Builder {
        crate::error::access_to_cluster_denied_fault::Builder::default()
    }
}

/// <p>The request would result in user exceeding the allowed number of cluster subnet
/// groups.
/// For information about increasing your quota, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon Redshift</a>
/// in the <i>Amazon Redshift Cluster Management Guide</i>.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ClusterSubnetGroupQuotaExceededFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ClusterSubnetGroupQuotaExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ClusterSubnetGroupQuotaExceededFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ClusterSubnetGroupQuotaExceededFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ClusterSubnetGroupQuotaExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ClusterSubnetGroupQuotaExceededFault")?;
        if let Some(inner_113) = &self.message {
            write!(f, ": {}", inner_113)?;
        }
        Ok(())
    }
}
impl std::error::Error for ClusterSubnetGroupQuotaExceededFault {}
/// See [`ClusterSubnetGroupQuotaExceededFault`](crate::error::ClusterSubnetGroupQuotaExceededFault)
pub mod cluster_subnet_group_quota_exceeded_fault {
    /// A builder for [`ClusterSubnetGroupQuotaExceededFault`](crate::error::ClusterSubnetGroupQuotaExceededFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ClusterSubnetGroupQuotaExceededFault`](crate::error::ClusterSubnetGroupQuotaExceededFault)
        pub fn build(self) -> crate::error::ClusterSubnetGroupQuotaExceededFault {
            crate::error::ClusterSubnetGroupQuotaExceededFault {
                message: self.message,
            }
        }
    }
}
impl ClusterSubnetGroupQuotaExceededFault {
    /// Creates a new builder-style object to manufacture [`ClusterSubnetGroupQuotaExceededFault`](crate::error::ClusterSubnetGroupQuotaExceededFault)
    pub fn builder() -> crate::error::cluster_subnet_group_quota_exceeded_fault::Builder {
        crate::error::cluster_subnet_group_quota_exceeded_fault::Builder::default()
    }
}

/// <p>A <i>ClusterSubnetGroupName</i> is already used by an existing
/// cluster subnet group. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ClusterSubnetGroupAlreadyExistsFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ClusterSubnetGroupAlreadyExistsFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ClusterSubnetGroupAlreadyExistsFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ClusterSubnetGroupAlreadyExistsFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ClusterSubnetGroupAlreadyExistsFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ClusterSubnetGroupAlreadyExistsFault")?;
        if let Some(inner_114) = &self.message {
            write!(f, ": {}", inner_114)?;
        }
        Ok(())
    }
}
impl std::error::Error for ClusterSubnetGroupAlreadyExistsFault {}
/// See [`ClusterSubnetGroupAlreadyExistsFault`](crate::error::ClusterSubnetGroupAlreadyExistsFault)
pub mod cluster_subnet_group_already_exists_fault {
    /// A builder for [`ClusterSubnetGroupAlreadyExistsFault`](crate::error::ClusterSubnetGroupAlreadyExistsFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ClusterSubnetGroupAlreadyExistsFault`](crate::error::ClusterSubnetGroupAlreadyExistsFault)
        pub fn build(self) -> crate::error::ClusterSubnetGroupAlreadyExistsFault {
            crate::error::ClusterSubnetGroupAlreadyExistsFault {
                message: self.message,
            }
        }
    }
}
impl ClusterSubnetGroupAlreadyExistsFault {
    /// Creates a new builder-style object to manufacture [`ClusterSubnetGroupAlreadyExistsFault`](crate::error::ClusterSubnetGroupAlreadyExistsFault)
    pub fn builder() -> crate::error::cluster_subnet_group_already_exists_fault::Builder {
        crate::error::cluster_subnet_group_already_exists_fault::Builder::default()
    }
}

/// <p>The request would result in the user exceeding the allowed number of cluster
/// security groups.
/// For information about increasing your quota, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon Redshift</a>
/// in the <i>Amazon Redshift Cluster Management Guide</i>.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ClusterSecurityGroupQuotaExceededFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ClusterSecurityGroupQuotaExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ClusterSecurityGroupQuotaExceededFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ClusterSecurityGroupQuotaExceededFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ClusterSecurityGroupQuotaExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ClusterSecurityGroupQuotaExceededFault")?;
        if let Some(inner_115) = &self.message {
            write!(f, ": {}", inner_115)?;
        }
        Ok(())
    }
}
impl std::error::Error for ClusterSecurityGroupQuotaExceededFault {}
/// See [`ClusterSecurityGroupQuotaExceededFault`](crate::error::ClusterSecurityGroupQuotaExceededFault)
pub mod cluster_security_group_quota_exceeded_fault {
    /// A builder for [`ClusterSecurityGroupQuotaExceededFault`](crate::error::ClusterSecurityGroupQuotaExceededFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ClusterSecurityGroupQuotaExceededFault`](crate::error::ClusterSecurityGroupQuotaExceededFault)
        pub fn build(self) -> crate::error::ClusterSecurityGroupQuotaExceededFault {
            crate::error::ClusterSecurityGroupQuotaExceededFault {
                message: self.message,
            }
        }
    }
}
impl ClusterSecurityGroupQuotaExceededFault {
    /// Creates a new builder-style object to manufacture [`ClusterSecurityGroupQuotaExceededFault`](crate::error::ClusterSecurityGroupQuotaExceededFault)
    pub fn builder() -> crate::error::cluster_security_group_quota_exceeded_fault::Builder {
        crate::error::cluster_security_group_quota_exceeded_fault::Builder::default()
    }
}

/// <p>A cluster security group with the same name already exists.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ClusterSecurityGroupAlreadyExistsFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ClusterSecurityGroupAlreadyExistsFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ClusterSecurityGroupAlreadyExistsFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ClusterSecurityGroupAlreadyExistsFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ClusterSecurityGroupAlreadyExistsFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ClusterSecurityGroupAlreadyExistsFault")?;
        if let Some(inner_116) = &self.message {
            write!(f, ": {}", inner_116)?;
        }
        Ok(())
    }
}
impl std::error::Error for ClusterSecurityGroupAlreadyExistsFault {}
/// See [`ClusterSecurityGroupAlreadyExistsFault`](crate::error::ClusterSecurityGroupAlreadyExistsFault)
pub mod cluster_security_group_already_exists_fault {
    /// A builder for [`ClusterSecurityGroupAlreadyExistsFault`](crate::error::ClusterSecurityGroupAlreadyExistsFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ClusterSecurityGroupAlreadyExistsFault`](crate::error::ClusterSecurityGroupAlreadyExistsFault)
        pub fn build(self) -> crate::error::ClusterSecurityGroupAlreadyExistsFault {
            crate::error::ClusterSecurityGroupAlreadyExistsFault {
                message: self.message,
            }
        }
    }
}
impl ClusterSecurityGroupAlreadyExistsFault {
    /// Creates a new builder-style object to manufacture [`ClusterSecurityGroupAlreadyExistsFault`](crate::error::ClusterSecurityGroupAlreadyExistsFault)
    pub fn builder() -> crate::error::cluster_security_group_already_exists_fault::Builder {
        crate::error::cluster_security_group_already_exists_fault::Builder::default()
    }
}

/// <p>The request would result in the user exceeding the allowed number of cluster
/// parameter groups.
/// For information about increasing your quota, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Limits in Amazon Redshift</a>
/// in the <i>Amazon Redshift Cluster Management Guide</i>.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ClusterParameterGroupQuotaExceededFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ClusterParameterGroupQuotaExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ClusterParameterGroupQuotaExceededFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ClusterParameterGroupQuotaExceededFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ClusterParameterGroupQuotaExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ClusterParameterGroupQuotaExceededFault")?;
        if let Some(inner_117) = &self.message {
            write!(f, ": {}", inner_117)?;
        }
        Ok(())
    }
}
impl std::error::Error for ClusterParameterGroupQuotaExceededFault {}
/// See [`ClusterParameterGroupQuotaExceededFault`](crate::error::ClusterParameterGroupQuotaExceededFault)
pub mod cluster_parameter_group_quota_exceeded_fault {
    /// A builder for [`ClusterParameterGroupQuotaExceededFault`](crate::error::ClusterParameterGroupQuotaExceededFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ClusterParameterGroupQuotaExceededFault`](crate::error::ClusterParameterGroupQuotaExceededFault)
        pub fn build(self) -> crate::error::ClusterParameterGroupQuotaExceededFault {
            crate::error::ClusterParameterGroupQuotaExceededFault {
                message: self.message,
            }
        }
    }
}
impl ClusterParameterGroupQuotaExceededFault {
    /// Creates a new builder-style object to manufacture [`ClusterParameterGroupQuotaExceededFault`](crate::error::ClusterParameterGroupQuotaExceededFault)
    pub fn builder() -> crate::error::cluster_parameter_group_quota_exceeded_fault::Builder {
        crate::error::cluster_parameter_group_quota_exceeded_fault::Builder::default()
    }
}

/// <p>A cluster parameter group with the same name already exists.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ClusterParameterGroupAlreadyExistsFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ClusterParameterGroupAlreadyExistsFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ClusterParameterGroupAlreadyExistsFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ClusterParameterGroupAlreadyExistsFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ClusterParameterGroupAlreadyExistsFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ClusterParameterGroupAlreadyExistsFault")?;
        if let Some(inner_118) = &self.message {
            write!(f, ": {}", inner_118)?;
        }
        Ok(())
    }
}
impl std::error::Error for ClusterParameterGroupAlreadyExistsFault {}
/// See [`ClusterParameterGroupAlreadyExistsFault`](crate::error::ClusterParameterGroupAlreadyExistsFault)
pub mod cluster_parameter_group_already_exists_fault {
    /// A builder for [`ClusterParameterGroupAlreadyExistsFault`](crate::error::ClusterParameterGroupAlreadyExistsFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ClusterParameterGroupAlreadyExistsFault`](crate::error::ClusterParameterGroupAlreadyExistsFault)
        pub fn build(self) -> crate::error::ClusterParameterGroupAlreadyExistsFault {
            crate::error::ClusterParameterGroupAlreadyExistsFault {
                message: self.message,
            }
        }
    }
}
impl ClusterParameterGroupAlreadyExistsFault {
    /// Creates a new builder-style object to manufacture [`ClusterParameterGroupAlreadyExistsFault`](crate::error::ClusterParameterGroupAlreadyExistsFault)
    pub fn builder() -> crate::error::cluster_parameter_group_already_exists_fault::Builder {
        crate::error::cluster_parameter_group_already_exists_fault::Builder::default()
    }
}

/// <p>The authentication profile already exists.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AuthenticationProfileAlreadyExistsFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AuthenticationProfileAlreadyExistsFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AuthenticationProfileAlreadyExistsFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AuthenticationProfileAlreadyExistsFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AuthenticationProfileAlreadyExistsFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AuthenticationProfileAlreadyExistsFault")?;
        if let Some(inner_119) = &self.message {
            write!(f, ": {}", inner_119)?;
        }
        Ok(())
    }
}
impl std::error::Error for AuthenticationProfileAlreadyExistsFault {}
/// See [`AuthenticationProfileAlreadyExistsFault`](crate::error::AuthenticationProfileAlreadyExistsFault)
pub mod authentication_profile_already_exists_fault {
    /// A builder for [`AuthenticationProfileAlreadyExistsFault`](crate::error::AuthenticationProfileAlreadyExistsFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AuthenticationProfileAlreadyExistsFault`](crate::error::AuthenticationProfileAlreadyExistsFault)
        pub fn build(self) -> crate::error::AuthenticationProfileAlreadyExistsFault {
            crate::error::AuthenticationProfileAlreadyExistsFault {
                message: self.message,
            }
        }
    }
}
impl AuthenticationProfileAlreadyExistsFault {
    /// Creates a new builder-style object to manufacture [`AuthenticationProfileAlreadyExistsFault`](crate::error::AuthenticationProfileAlreadyExistsFault)
    pub fn builder() -> crate::error::authentication_profile_already_exists_fault::Builder {
        crate::error::authentication_profile_already_exists_fault::Builder::default()
    }
}

/// <p>The maximum number for snapshot identifiers has been reached. The limit is 100.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchModifyClusterSnapshotsLimitExceededFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for BatchModifyClusterSnapshotsLimitExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchModifyClusterSnapshotsLimitExceededFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl BatchModifyClusterSnapshotsLimitExceededFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for BatchModifyClusterSnapshotsLimitExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "BatchModifyClusterSnapshotsLimitExceededFault")?;
        if let Some(inner_120) = &self.message {
            write!(f, ": {}", inner_120)?;
        }
        Ok(())
    }
}
impl std::error::Error for BatchModifyClusterSnapshotsLimitExceededFault {}
/// See [`BatchModifyClusterSnapshotsLimitExceededFault`](crate::error::BatchModifyClusterSnapshotsLimitExceededFault)
pub mod batch_modify_cluster_snapshots_limit_exceeded_fault {
    /// A builder for [`BatchModifyClusterSnapshotsLimitExceededFault`](crate::error::BatchModifyClusterSnapshotsLimitExceededFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchModifyClusterSnapshotsLimitExceededFault`](crate::error::BatchModifyClusterSnapshotsLimitExceededFault)
        pub fn build(self) -> crate::error::BatchModifyClusterSnapshotsLimitExceededFault {
            crate::error::BatchModifyClusterSnapshotsLimitExceededFault {
                message: self.message,
            }
        }
    }
}
impl BatchModifyClusterSnapshotsLimitExceededFault {
    /// Creates a new builder-style object to manufacture [`BatchModifyClusterSnapshotsLimitExceededFault`](crate::error::BatchModifyClusterSnapshotsLimitExceededFault)
    pub fn builder() -> crate::error::batch_modify_cluster_snapshots_limit_exceeded_fault::Builder {
        crate::error::batch_modify_cluster_snapshots_limit_exceeded_fault::Builder::default()
    }
}

/// <p>The maximum number for a batch delete of snapshots has been reached. The limit is
/// 100. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchDeleteRequestSizeExceededFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for BatchDeleteRequestSizeExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchDeleteRequestSizeExceededFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl BatchDeleteRequestSizeExceededFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for BatchDeleteRequestSizeExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "BatchDeleteRequestSizeExceededFault")?;
        if let Some(inner_121) = &self.message {
            write!(f, ": {}", inner_121)?;
        }
        Ok(())
    }
}
impl std::error::Error for BatchDeleteRequestSizeExceededFault {}
/// See [`BatchDeleteRequestSizeExceededFault`](crate::error::BatchDeleteRequestSizeExceededFault)
pub mod batch_delete_request_size_exceeded_fault {
    /// A builder for [`BatchDeleteRequestSizeExceededFault`](crate::error::BatchDeleteRequestSizeExceededFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchDeleteRequestSizeExceededFault`](crate::error::BatchDeleteRequestSizeExceededFault)
        pub fn build(self) -> crate::error::BatchDeleteRequestSizeExceededFault {
            crate::error::BatchDeleteRequestSizeExceededFault {
                message: self.message,
            }
        }
    }
}
impl BatchDeleteRequestSizeExceededFault {
    /// Creates a new builder-style object to manufacture [`BatchDeleteRequestSizeExceededFault`](crate::error::BatchDeleteRequestSizeExceededFault)
    pub fn builder() -> crate::error::batch_delete_request_size_exceeded_fault::Builder {
        crate::error::batch_delete_request_size_exceeded_fault::Builder::default()
    }
}

/// <p>The authorization quota for the cluster security group has been reached.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AuthorizationQuotaExceededFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AuthorizationQuotaExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AuthorizationQuotaExceededFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AuthorizationQuotaExceededFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AuthorizationQuotaExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AuthorizationQuotaExceededFault")?;
        if let Some(inner_122) = &self.message {
            write!(f, ": {}", inner_122)?;
        }
        Ok(())
    }
}
impl std::error::Error for AuthorizationQuotaExceededFault {}
/// See [`AuthorizationQuotaExceededFault`](crate::error::AuthorizationQuotaExceededFault)
pub mod authorization_quota_exceeded_fault {
    /// A builder for [`AuthorizationQuotaExceededFault`](crate::error::AuthorizationQuotaExceededFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AuthorizationQuotaExceededFault`](crate::error::AuthorizationQuotaExceededFault)
        pub fn build(self) -> crate::error::AuthorizationQuotaExceededFault {
            crate::error::AuthorizationQuotaExceededFault {
                message: self.message,
            }
        }
    }
}
impl AuthorizationQuotaExceededFault {
    /// Creates a new builder-style object to manufacture [`AuthorizationQuotaExceededFault`](crate::error::AuthorizationQuotaExceededFault)
    pub fn builder() -> crate::error::authorization_quota_exceeded_fault::Builder {
        crate::error::authorization_quota_exceeded_fault::Builder::default()
    }
}

/// <p>The specified CIDR block or EC2 security group is already authorized for the
/// specified cluster security group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AuthorizationAlreadyExistsFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AuthorizationAlreadyExistsFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AuthorizationAlreadyExistsFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AuthorizationAlreadyExistsFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AuthorizationAlrea