// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// Client for Amazon Redshift
///
/// Client for invoking operations on Amazon Redshift. Each operation on Amazon Redshift is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_redshift::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operationname>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_redshift::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_redshift::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `AcceptReservedNodeExchange` operation.
    ///
    /// See [`AcceptReservedNodeExchange`](crate::client::fluent_builders::AcceptReservedNodeExchange) for more information about the
    /// operation and its arguments.
    pub fn accept_reserved_node_exchange(
        &self,
    ) -> fluent_builders::AcceptReservedNodeExchange<C, M, R> {
        fluent_builders::AcceptReservedNodeExchange::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AddPartner` operation.
    ///
    /// See [`AddPartner`](crate::client::fluent_builders::AddPartner) for more information about the
    /// operation and its arguments.
    pub fn add_partner(&self) -> fluent_builders::AddPartner<C, M, R> {
        fluent_builders::AddPartner::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AssociateDataShareConsumer` operation.
    ///
    /// See [`AssociateDataShareConsumer`](crate::client::fluent_builders::AssociateDataShareConsumer) for more information about the
    /// operation and its arguments.
    pub fn associate_data_share_consumer(
        &self,
    ) -> fluent_builders::AssociateDataShareConsumer<C, M, R> {
        fluent_builders::AssociateDataShareConsumer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AuthorizeClusterSecurityGroupIngress` operation.
    ///
    /// See [`AuthorizeClusterSecurityGroupIngress`](crate::client::fluent_builders::AuthorizeClusterSecurityGroupIngress) for more information about the
    /// operation and its arguments.
    pub fn authorize_cluster_security_group_ingress(
        &self,
    ) -> fluent_builders::AuthorizeClusterSecurityGroupIngress<C, M, R> {
        fluent_builders::AuthorizeClusterSecurityGroupIngress::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AuthorizeDataShare` operation.
    ///
    /// See [`AuthorizeDataShare`](crate::client::fluent_builders::AuthorizeDataShare) for more information about the
    /// operation and its arguments.
    pub fn authorize_data_share(&self) -> fluent_builders::AuthorizeDataShare<C, M, R> {
        fluent_builders::AuthorizeDataShare::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AuthorizeEndpointAccess` operation.
    ///
    /// See [`AuthorizeEndpointAccess`](crate::client::fluent_builders::AuthorizeEndpointAccess) for more information about the
    /// operation and its arguments.
    pub fn authorize_endpoint_access(&self) -> fluent_builders::AuthorizeEndpointAccess<C, M, R> {
        fluent_builders::AuthorizeEndpointAccess::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AuthorizeSnapshotAccess` operation.
    ///
    /// See [`AuthorizeSnapshotAccess`](crate::client::fluent_builders::AuthorizeSnapshotAccess) for more information about the
    /// operation and its arguments.
    pub fn authorize_snapshot_access(&self) -> fluent_builders::AuthorizeSnapshotAccess<C, M, R> {
        fluent_builders::AuthorizeSnapshotAccess::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `BatchDeleteClusterSnapshots` operation.
    ///
    /// See [`BatchDeleteClusterSnapshots`](crate::client::fluent_builders::BatchDeleteClusterSnapshots) for more information about the
    /// operation and its arguments.
    pub fn batch_delete_cluster_snapshots(
        &self,
    ) -> fluent_builders::BatchDeleteClusterSnapshots<C, M, R> {
        fluent_builders::BatchDeleteClusterSnapshots::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `BatchModifyClusterSnapshots` operation.
    ///
    /// See [`BatchModifyClusterSnapshots`](crate::client::fluent_builders::BatchModifyClusterSnapshots) for more information about the
    /// operation and its arguments.
    pub fn batch_modify_cluster_snapshots(
        &self,
    ) -> fluent_builders::BatchModifyClusterSnapshots<C, M, R> {
        fluent_builders::BatchModifyClusterSnapshots::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CancelResize` operation.
    ///
    /// See [`CancelResize`](crate::client::fluent_builders::CancelResize) for more information about the
    /// operation and its arguments.
    pub fn cancel_resize(&self) -> fluent_builders::CancelResize<C, M, R> {
        fluent_builders::CancelResize::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CopyClusterSnapshot` operation.
    ///
    /// See [`CopyClusterSnapshot`](crate::client::fluent_builders::CopyClusterSnapshot) for more information about the
    /// operation and its arguments.
    pub fn copy_cluster_snapshot(&self) -> fluent_builders::CopyClusterSnapshot<C, M, R> {
        fluent_builders::CopyClusterSnapshot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateAuthenticationProfile` operation.
    ///
    /// See [`CreateAuthenticationProfile`](crate::client::fluent_builders::CreateAuthenticationProfile) for more information about the
    /// operation and its arguments.
    pub fn create_authentication_profile(
        &self,
    ) -> fluent_builders::CreateAuthenticationProfile<C, M, R> {
        fluent_builders::CreateAuthenticationProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateCluster` operation.
    ///
    /// See [`CreateCluster`](crate::client::fluent_builders::CreateCluster) for more information about the
    /// operation and its arguments.
    pub fn create_cluster(&self) -> fluent_builders::CreateCluster<C, M, R> {
        fluent_builders::CreateCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateClusterParameterGroup` operation.
    ///
    /// See [`CreateClusterParameterGroup`](crate::client::fluent_builders::CreateClusterParameterGroup) for more information about the
    /// operation and its arguments.
    pub fn create_cluster_parameter_group(
        &self,
    ) -> fluent_builders::CreateClusterParameterGroup<C, M, R> {
        fluent_builders::CreateClusterParameterGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateClusterSecurityGroup` operation.
    ///
    /// See [`CreateClusterSecurityGroup`](crate::client::fluent_builders::CreateClusterSecurityGroup) for more information about the
    /// operation and its arguments.
    pub fn create_cluster_security_group(
        &self,
    ) -> fluent_builders::CreateClusterSecurityGroup<C, M, R> {
        fluent_builders::CreateClusterSecurityGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateClusterSnapshot` operation.
    ///
    /// See [`CreateClusterSnapshot`](crate::client::fluent_builders::CreateClusterSnapshot) for more information about the
    /// operation and its arguments.
    pub fn create_cluster_snapshot(&self) -> fluent_builders::CreateClusterSnapshot<C, M, R> {
        fluent_builders::CreateClusterSnapshot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateClusterSubnetGroup` operation.
    ///
    /// See [`CreateClusterSubnetGroup`](crate::client::fluent_builders::CreateClusterSubnetGroup) for more information about the
    /// operation and its arguments.
    pub fn create_cluster_subnet_group(
        &self,
    ) -> fluent_builders::CreateClusterSubnetGroup<C, M, R> {
        fluent_builders::CreateClusterSubnetGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateEndpointAccess` operation.
    ///
    /// See [`CreateEndpointAccess`](crate::client::fluent_builders::CreateEndpointAccess) for more information about the
    /// operation and its arguments.
    pub fn create_endpoint_access(&self) -> fluent_builders::CreateEndpointAccess<C, M, R> {
        fluent_builders::CreateEndpointAccess::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateEventSubscription` operation.
    ///
    /// See [`CreateEventSubscription`](crate::client::fluent_builders::CreateEventSubscription) for more information about the
    /// operation and its arguments.
    pub fn create_event_subscription(&self) -> fluent_builders::CreateEventSubscription<C, M, R> {
        fluent_builders::CreateEventSubscription::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateHsmClientCertificate` operation.
    ///
    /// See [`CreateHsmClientCertificate`](crate::client::fluent_builders::CreateHsmClientCertificate) for more information about the
    /// operation and its arguments.
    pub fn create_hsm_client_certificate(
        &self,
    ) -> fluent_builders::CreateHsmClientCertificate<C, M, R> {
        fluent_builders::CreateHsmClientCertificate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateHsmConfiguration` operation.
    ///
    /// See [`CreateHsmConfiguration`](crate::client::fluent_builders::CreateHsmConfiguration) for more information about the
    /// operation and its arguments.
    pub fn create_hsm_configuration(&self) -> fluent_builders::CreateHsmConfiguration<C, M, R> {
        fluent_builders::CreateHsmConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateScheduledAction` operation.
    ///
    /// See [`CreateScheduledAction`](crate::client::fluent_builders::CreateScheduledAction) for more information about the
    /// operation and its arguments.
    pub fn create_scheduled_action(&self) -> fluent_builders::CreateScheduledAction<C, M, R> {
        fluent_builders::CreateScheduledAction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateSnapshotCopyGrant` operation.
    ///
    /// See [`CreateSnapshotCopyGrant`](crate::client::fluent_builders::CreateSnapshotCopyGrant) for more information about the
    /// operation and its arguments.
    pub fn create_snapshot_copy_grant(&self) -> fluent_builders::CreateSnapshotCopyGrant<C, M, R> {
        fluent_builders::CreateSnapshotCopyGrant::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateSnapshotSchedule` operation.
    ///
    /// See [`CreateSnapshotSchedule`](crate::client::fluent_builders::CreateSnapshotSchedule) for more information about the
    /// operation and its arguments.
    pub fn create_snapshot_schedule(&self) -> fluent_builders::CreateSnapshotSchedule<C, M, R> {
        fluent_builders::CreateSnapshotSchedule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateTags` operation.
    ///
    /// See [`CreateTags`](crate::client::fluent_builders::CreateTags) for more information about the
    /// operation and its arguments.
    pub fn create_tags(&self) -> fluent_builders::CreateTags<C, M, R> {
        fluent_builders::CreateTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateUsageLimit` operation.
    ///
    /// See [`CreateUsageLimit`](crate::client::fluent_builders::CreateUsageLimit) for more information about the
    /// operation and its arguments.
    pub fn create_usage_limit(&self) -> fluent_builders::CreateUsageLimit<C, M, R> {
        fluent_builders::CreateUsageLimit::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeauthorizeDataShare` operation.
    ///
    /// See [`DeauthorizeDataShare`](crate::client::fluent_builders::DeauthorizeDataShare) for more information about the
    /// operation and its arguments.
    pub fn deauthorize_data_share(&self) -> fluent_builders::DeauthorizeDataShare<C, M, R> {
        fluent_builders::DeauthorizeDataShare::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteAuthenticationProfile` operation.
    ///
    /// See [`DeleteAuthenticationProfile`](crate::client::fluent_builders::DeleteAuthenticationProfile) for more information about the
    /// operation and its arguments.
    pub fn delete_authentication_profile(
        &self,
    ) -> fluent_builders::DeleteAuthenticationProfile<C, M, R> {
        fluent_builders::DeleteAuthenticationProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteCluster` operation.
    ///
    /// See [`DeleteCluster`](crate::client::fluent_builders::DeleteCluster) for more information about the
    /// operation and its arguments.
    pub fn delete_cluster(&self) -> fluent_builders::DeleteCluster<C, M, R> {
        fluent_builders::DeleteCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteClusterParameterGroup` operation.
    ///
    /// See [`DeleteClusterParameterGroup`](crate::client::fluent_builders::DeleteClusterParameterGroup) for more information about the
    /// operation and its arguments.
    pub fn delete_cluster_parameter_group(
        &self,
    ) -> fluent_builders::DeleteClusterParameterGroup<C, M, R> {
        fluent_builders::DeleteClusterParameterGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteClusterSecurityGroup` operation.
    ///
    /// See [`DeleteClusterSecurityGroup`](crate::client::fluent_builders::DeleteClusterSecurityGroup) for more information about the
    /// operation and its arguments.
    pub fn delete_cluster_security_group(
        &self,
    ) -> fluent_builders::DeleteClusterSecurityGroup<C, M, R> {
        fluent_builders::DeleteClusterSecurityGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteClusterSnapshot` operation.
    ///
    /// See [`DeleteClusterSnapshot`](crate::client::fluent_builders::DeleteClusterSnapshot) for more information about the
    /// operation and its arguments.
    pub fn delete_cluster_snapshot(&self) -> fluent_builders::DeleteClusterSnapshot<C, M, R> {
        fluent_builders::DeleteClusterSnapshot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteClusterSubnetGroup` operation.
    ///
    /// See [`DeleteClusterSubnetGroup`](crate::client::fluent_builders::DeleteClusterSubnetGroup) for more information about the
    /// operation and its arguments.
    pub fn delete_cluster_subnet_group(
        &self,
    ) -> fluent_builders::DeleteClusterSubnetGroup<C, M, R> {
        fluent_builders::DeleteClusterSubnetGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteEndpointAccess` operation.
    ///
    /// See [`DeleteEndpointAccess`](crate::client::fluent_builders::DeleteEndpointAccess) for more information about the
    /// operation and its arguments.
    pub fn delete_endpoint_access(&self) -> fluent_builders::DeleteEndpointAccess<C, M, R> {
        fluent_builders::DeleteEndpointAccess::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteEventSubscription` operation.
    ///
    /// See [`DeleteEventSubscription`](crate::client::fluent_builders::DeleteEventSubscription) for more information about the
    /// operation and its arguments.
    pub fn delete_event_subscription(&self) -> fluent_builders::DeleteEventSubscription<C, M, R> {
        fluent_builders::DeleteEventSubscription::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteHsmClientCertificate` operation.
    ///
    /// See [`DeleteHsmClientCertificate`](crate::client::fluent_builders::DeleteHsmClientCertificate) for more information about the
    /// operation and its arguments.
    pub fn delete_hsm_client_certificate(
        &self,
    ) -> fluent_builders::DeleteHsmClientCertificate<C, M, R> {
        fluent_builders::DeleteHsmClientCertificate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteHsmConfiguration` operation.
    ///
    /// See [`DeleteHsmConfiguration`](crate::client::fluent_builders::DeleteHsmConfiguration) for more information about the
    /// operation and its arguments.
    pub fn delete_hsm_configuration(&self) -> fluent_builders::DeleteHsmConfiguration<C, M, R> {
        fluent_builders::DeleteHsmConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeletePartner` operation.
    ///
    /// See [`DeletePartner`](crate::client::fluent_builders::DeletePartner) for more information about the
    /// operation and its arguments.
    pub fn delete_partner(&self) -> fluent_builders::DeletePartner<C, M, R> {
        fluent_builders::DeletePartner::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteScheduledAction` operation.
    ///
    /// See [`DeleteScheduledAction`](crate::client::fluent_builders::DeleteScheduledAction) for more information about the
    /// operation and its arguments.
    pub fn delete_scheduled_action(&self) -> fluent_builders::DeleteScheduledAction<C, M, R> {
        fluent_builders::DeleteScheduledAction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteSnapshotCopyGrant` operation.
    ///
    /// See [`DeleteSnapshotCopyGrant`](crate::client::fluent_builders::DeleteSnapshotCopyGrant) for more information about the
    /// operation and its arguments.
    pub fn delete_snapshot_copy_grant(&self) -> fluent_builders::DeleteSnapshotCopyGrant<C, M, R> {
        fluent_builders::DeleteSnapshotCopyGrant::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteSnapshotSchedule` operation.
    ///
    /// See [`DeleteSnapshotSchedule`](crate::client::fluent_builders::DeleteSnapshotSchedule) for more information about the
    /// operation and its arguments.
    pub fn delete_snapshot_schedule(&self) -> fluent_builders::DeleteSnapshotSchedule<C, M, R> {
        fluent_builders::DeleteSnapshotSchedule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteTags` operation.
    ///
    /// See [`DeleteTags`](crate::client::fluent_builders::DeleteTags) for more information about the
    /// operation and its arguments.
    pub fn delete_tags(&self) -> fluent_builders::DeleteTags<C, M, R> {
        fluent_builders::DeleteTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteUsageLimit` operation.
    ///
    /// See [`DeleteUsageLimit`](crate::client::fluent_builders::DeleteUsageLimit) for more information about the
    /// operation and its arguments.
    pub fn delete_usage_limit(&self) -> fluent_builders::DeleteUsageLimit<C, M, R> {
        fluent_builders::DeleteUsageLimit::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeAccountAttributes` operation.
    ///
    /// See [`DescribeAccountAttributes`](crate::client::fluent_builders::DescribeAccountAttributes) for more information about the
    /// operation and its arguments.
    pub fn describe_account_attributes(
        &self,
    ) -> fluent_builders::DescribeAccountAttributes<C, M, R> {
        fluent_builders::DescribeAccountAttributes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeAuthenticationProfiles` operation.
    ///
    /// See [`DescribeAuthenticationProfiles`](crate::client::fluent_builders::DescribeAuthenticationProfiles) for more information about the
    /// operation and its arguments.
    pub fn describe_authentication_profiles(
        &self,
    ) -> fluent_builders::DescribeAuthenticationProfiles<C, M, R> {
        fluent_builders::DescribeAuthenticationProfiles::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeClusterDbRevisions` operation.
    ///
    /// See [`DescribeClusterDbRevisions`](crate::client::fluent_builders::DescribeClusterDbRevisions) for more information about the
    /// operation and its arguments.
    pub fn describe_cluster_db_revisions(
        &self,
    ) -> fluent_builders::DescribeClusterDbRevisions<C, M, R> {
        fluent_builders::DescribeClusterDbRevisions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeClusterParameterGroups` operation.
    ///
    /// See [`DescribeClusterParameterGroups`](crate::client::fluent_builders::DescribeClusterParameterGroups) for more information about the
    /// operation and its arguments.
    pub fn describe_cluster_parameter_groups(
        &self,
    ) -> fluent_builders::DescribeClusterParameterGroups<C, M, R> {
        fluent_builders::DescribeClusterParameterGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeClusterParameters` operation.
    ///
    /// See [`DescribeClusterParameters`](crate::client::fluent_builders::DescribeClusterParameters) for more information about the
    /// operation and its arguments.
    pub fn describe_cluster_parameters(
        &self,
    ) -> fluent_builders::DescribeClusterParameters<C, M, R> {
        fluent_builders::DescribeClusterParameters::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeClusters` operation.
    ///
    /// See [`DescribeClusters`](crate::client::fluent_builders::DescribeClusters) for more information about the
    /// operation and its arguments.
    pub fn describe_clusters(&self) -> fluent_builders::DescribeClusters<C, M, R> {
        fluent_builders::DescribeClusters::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeClusterSecurityGroups` operation.
    ///
    /// See [`DescribeClusterSecurityGroups`](crate::client::fluent_builders::DescribeClusterSecurityGroups) for more information about the
    /// operation and its arguments.
    pub fn describe_cluster_security_groups(
        &self,
    ) -> fluent_builders::DescribeClusterSecurityGroups<C, M, R> {
        fluent_builders::DescribeClusterSecurityGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeClusterSnapshots` operation.
    ///
    /// See [`DescribeClusterSnapshots`](crate::client::fluent_builders::DescribeClusterSnapshots) for more information about the
    /// operation and its arguments.
    pub fn describe_cluster_snapshots(&self) -> fluent_builders::DescribeClusterSnapshots<C, M, R> {
        fluent_builders::DescribeClusterSnapshots::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeClusterSubnetGroups` operation.
    ///
    /// See [`DescribeClusterSubnetGroups`](crate::client::fluent_builders::DescribeClusterSubnetGroups) for more information about the
    /// operation and its arguments.
    pub fn describe_cluster_subnet_groups(
        &self,
    ) -> fluent_builders::DescribeClusterSubnetGroups<C, M, R> {
        fluent_builders::DescribeClusterSubnetGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeClusterTracks` operation.
    ///
    /// See [`DescribeClusterTracks`](crate::client::fluent_builders::DescribeClusterTracks) for more information about the
    /// operation and its arguments.
    pub fn describe_cluster_tracks(&self) -> fluent_builders::DescribeClusterTracks<C, M, R> {
        fluent_builders::DescribeClusterTracks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeClusterVersions` operation.
    ///
    /// See [`DescribeClusterVersions`](crate::client::fluent_builders::DescribeClusterVersions) for more information about the
    /// operation and its arguments.
    pub fn describe_cluster_versions(&self) -> fluent_builders::DescribeClusterVersions<C, M, R> {
        fluent_builders::DescribeClusterVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeDataShares` operation.
    ///
    /// See [`DescribeDataShares`](crate::client::fluent_builders::DescribeDataShares) for more information about the
    /// operation and its arguments.
    pub fn describe_data_shares(&self) -> fluent_builders::DescribeDataShares<C, M, R> {
        fluent_builders::DescribeDataShares::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeDataSharesForConsumer` operation.
    ///
    /// See [`DescribeDataSharesForConsumer`](crate::client::fluent_builders::DescribeDataSharesForConsumer) for more information about the
    /// operation and its arguments.
    pub fn describe_data_shares_for_consumer(
        &self,
    ) -> fluent_builders::DescribeDataSharesForConsumer<C, M, R> {
        fluent_builders::DescribeDataSharesForConsumer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeDataSharesForProducer` operation.
    ///
    /// See [`DescribeDataSharesForProducer`](crate::client::fluent_builders::DescribeDataSharesForProducer) for more information about the
    /// operation and its arguments.
    pub fn describe_data_shares_for_producer(
        &self,
    ) -> fluent_builders::DescribeDataSharesForProducer<C, M, R> {
        fluent_builders::DescribeDataSharesForProducer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeDefaultClusterParameters` operation.
    ///
    /// See [`DescribeDefaultClusterParameters`](crate::client::fluent_builders::DescribeDefaultClusterParameters) for more information about the
    /// operation and its arguments.
    pub fn describe_default_cluster_parameters(
        &self,
    ) -> fluent_builders::DescribeDefaultClusterParameters<C, M, R> {
        fluent_builders::DescribeDefaultClusterParameters::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeEndpointAccess` operation.
    ///
    /// See [`DescribeEndpointAccess`](crate::client::fluent_builders::DescribeEndpointAccess) for more information about the
    /// operation and its arguments.
    pub fn describe_endpoint_access(&self) -> fluent_builders::DescribeEndpointAccess<C, M, R> {
        fluent_builders::DescribeEndpointAccess::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeEndpointAuthorization` operation.
    ///
    /// See [`DescribeEndpointAuthorization`](crate::client::fluent_builders::DescribeEndpointAuthorization) for more information about the
    /// operation and its arguments.
    pub fn describe_endpoint_authorization(
        &self,
    ) -> fluent_builders::DescribeEndpointAuthorization<C, M, R> {
        fluent_builders::DescribeEndpointAuthorization::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeEventCategories` operation.
    ///
    /// See [`DescribeEventCategories`](crate::client::fluent_builders::DescribeEventCategories) for more information about the
    /// operation and its arguments.
    pub fn describe_event_categories(&self) -> fluent_builders::DescribeEventCategories<C, M, R> {
        fluent_builders::DescribeEventCategories::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeEvents` operation.
    ///
    /// See [`DescribeEvents`](crate::client::fluent_builders::DescribeEvents) for more information about the
    /// operation and its arguments.
    pub fn describe_events(&self) -> fluent_builders::DescribeEvents<C, M, R> {
        fluent_builders::DescribeEvents::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeEventSubscriptions` operation.
    ///
    /// See [`DescribeEventSubscriptions`](crate::client::fluent_builders::DescribeEventSubscriptions) for more information about the
    /// operation and its arguments.
    pub fn describe_event_subscriptions(
        &self,
    ) -> fluent_builders::DescribeEventSubscriptions<C, M, R> {
        fluent_builders::DescribeEventSubscriptions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeHsmClientCertificates` operation.
    ///
    /// See [`DescribeHsmClientCertificates`](crate::client::fluent_builders::DescribeHsmClientCertificates) for more information about the
    /// operation and its arguments.
    pub fn describe_hsm_client_certificates(
        &self,
    ) -> fluent_builders::DescribeHsmClientCertificates<C, M, R> {
        fluent_builders::DescribeHsmClientCertificates::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeHsmConfigurations` operation.
    ///
    /// See [`DescribeHsmConfigurations`](crate::client::fluent_builders::DescribeHsmConfigurations) for more information about the
    /// operation and its arguments.
    pub fn describe_hsm_configurations(
        &self,
    ) -> fluent_builders::DescribeHsmConfigurations<C, M, R> {
        fluent_builders::DescribeHsmConfigurations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeLoggingStatus` operation.
    ///
    /// See [`DescribeLoggingStatus`](crate::client::fluent_builders::DescribeLoggingStatus) for more information about the
    /// operation and its arguments.
    pub fn describe_logging_status(&self) -> fluent_builders::DescribeLoggingStatus<C, M, R> {
        fluent_builders::DescribeLoggingStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeNodeConfigurationOptions` operation.
    ///
    /// See [`DescribeNodeConfigurationOptions`](crate::client::fluent_builders::DescribeNodeConfigurationOptions) for more information about the
    /// operation and its arguments.
    pub fn describe_node_configuration_options(
        &self,
    ) -> fluent_builders::DescribeNodeConfigurationOptions<C, M, R> {
        fluent_builders::DescribeNodeConfigurationOptions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeOrderableClusterOptions` operation.
    ///
    /// See [`DescribeOrderableClusterOptions`](crate::client::fluent_builders::DescribeOrderableClusterOptions) for more information about the
    /// operation and its arguments.
    pub fn describe_orderable_cluster_options(
        &self,
    ) -> fluent_builders::DescribeOrderableClusterOptions<C, M, R> {
        fluent_builders::DescribeOrderableClusterOptions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribePartners` operation.
    ///
    /// See [`DescribePartners`](crate::client::fluent_builders::DescribePartners) for more information about the
    /// operation and its arguments.
    pub fn describe_partners(&self) -> fluent_builders::DescribePartners<C, M, R> {
        fluent_builders::DescribePartners::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeReservedNodeOfferings` operation.
    ///
    /// See [`DescribeReservedNodeOfferings`](crate::client::fluent_builders::DescribeReservedNodeOfferings) for more information about the
    /// operation and its arguments.
    pub fn describe_reserved_node_offerings(
        &self,
    ) -> fluent_builders::DescribeReservedNodeOfferings<C, M, R> {
        fluent_builders::DescribeReservedNodeOfferings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeReservedNodes` operation.
    ///
    /// See [`DescribeReservedNodes`](crate::client::fluent_builders::DescribeReservedNodes) for more information about the
    /// operation and its arguments.
    pub fn describe_reserved_nodes(&self) -> fluent_builders::DescribeReservedNodes<C, M, R> {
        fluent_builders::DescribeReservedNodes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeResize` operation.
    ///
    /// See [`DescribeResize`](crate::client::fluent_builders::DescribeResize) for more information about the
    /// operation and its arguments.
    pub fn describe_resize(&self) -> fluent_builders::DescribeResize<C, M, R> {
        fluent_builders::DescribeResize::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeScheduledActions` operation.
    ///
    /// See [`DescribeScheduledActions`](crate::client::fluent_builders::DescribeScheduledActions) for more information about the
    /// operation and its arguments.
    pub fn describe_scheduled_actions(&self) -> fluent_builders::DescribeScheduledActions<C, M, R> {
        fluent_builders::DescribeScheduledActions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeSnapshotCopyGrants` operation.
    ///
    /// See [`DescribeSnapshotCopyGrants`](crate::client::fluent_builders::DescribeSnapshotCopyGrants) for more information about the
    /// operation and its arguments.
    pub fn describe_snapshot_copy_grants(
        &self,
    ) -> fluent_builders::DescribeSnapshotCopyGrants<C, M, R> {
        fluent_builders::DescribeSnapshotCopyGrants::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeSnapshotSchedules` operation.
    ///
    /// See [`DescribeSnapshotSchedules`](crate::client::fluent_builders::DescribeSnapshotSchedules) for more information about the
    /// operation and its arguments.
    pub fn describe_snapshot_schedules(
        &self,
    ) -> fluent_builders::DescribeSnapshotSchedules<C, M, R> {
        fluent_builders::DescribeSnapshotSchedules::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeStorage` operation.
    ///
    /// See [`DescribeStorage`](crate::client::fluent_builders::DescribeStorage) for more information about the
    /// operation and its arguments.
    pub fn describe_storage(&self) -> fluent_builders::DescribeStorage<C, M, R> {
        fluent_builders::DescribeStorage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeTableRestoreStatus` operation.
    ///
    /// See [`DescribeTableRestoreStatus`](crate::client::fluent_builders::DescribeTableRestoreStatus) for more information about the
    /// operation and its arguments.
    pub fn describe_table_restore_status(
        &self,
    ) -> fluent_builders::DescribeTableRestoreStatus<C, M, R> {
        fluent_builders::DescribeTableRestoreStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeTags` operation.
    ///
    /// See [`DescribeTags`](crate::client::fluent_builders::DescribeTags) for more information about the
    /// operation and its arguments.
    pub fn describe_tags(&self) -> fluent_builders::DescribeTags<C, M, R> {
        fluent_builders::DescribeTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeUsageLimits` operation.
    ///
    /// See [`DescribeUsageLimits`](crate::client::fluent_builders::DescribeUsageLimits) for more information about the
    /// operation and its arguments.
    pub fn describe_usage_limits(&self) -> fluent_builders::DescribeUsageLimits<C, M, R> {
        fluent_builders::DescribeUsageLimits::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisableLogging` operation.
    ///
    /// See [`DisableLogging`](crate::client::fluent_builders::DisableLogging) for more information about the
    /// operation and its arguments.
    pub fn disable_logging(&self) -> fluent_builders::DisableLogging<C, M, R> {
        fluent_builders::DisableLogging::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisableSnapshotCopy` operation.
    ///
    /// See [`DisableSnapshotCopy`](crate::client::fluent_builders::DisableSnapshotCopy) for more information about the
    /// operation and its arguments.
    pub fn disable_snapshot_copy(&self) -> fluent_builders::DisableSnapshotCopy<C, M, R> {
        fluent_builders::DisableSnapshotCopy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisassociateDataShareConsumer` operation.
    ///
    /// See [`DisassociateDataShareConsumer`](crate::client::fluent_builders::DisassociateDataShareConsumer) for more information about the
    /// operation and its arguments.
    pub fn disassociate_data_share_consumer(
        &self,
    ) -> fluent_builders::DisassociateDataShareConsumer<C, M, R> {
        fluent_builders::DisassociateDataShareConsumer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `EnableLogging` operation.
    ///
    /// See [`EnableLogging`](crate::client::fluent_builders::EnableLogging) for more information about the
    /// operation and its arguments.
    pub fn enable_logging(&self) -> fluent_builders::EnableLogging<C, M, R> {
        fluent_builders::EnableLogging::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `EnableSnapshotCopy` operation.
    ///
    /// See [`EnableSnapshotCopy`](crate::client::fluent_builders::EnableSnapshotCopy) for more information about the
    /// operation and its arguments.
    pub fn enable_snapshot_copy(&self) -> fluent_builders::EnableSnapshotCopy<C, M, R> {
        fluent_builders::EnableSnapshotCopy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetClusterCredentials` operation.
    ///
    /// See [`GetClusterCredentials`](crate::client::fluent_builders::GetClusterCredentials) for more information about the
    /// operation and its arguments.
    pub fn get_cluster_credentials(&self) -> fluent_builders::GetClusterCredentials<C, M, R> {
        fluent_builders::GetClusterCredentials::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetReservedNodeExchangeOfferings` operation.
    ///
    /// See [`GetReservedNodeExchangeOfferings`](crate::client::fluent_builders::GetReservedNodeExchangeOfferings) for more information about the
    /// operation and its arguments.
    pub fn get_reserved_node_exchange_offerings(
        &self,
    ) -> fluent_builders::GetReservedNodeExchangeOfferings<C, M, R> {
        fluent_builders::GetReservedNodeExchangeOfferings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyAquaConfiguration` operation.
    ///
    /// See [`ModifyAquaConfiguration`](crate::client::fluent_builders::ModifyAquaConfiguration) for more information about the
    /// operation and its arguments.
    pub fn modify_aqua_configuration(&self) -> fluent_builders::ModifyAquaConfiguration<C, M, R> {
        fluent_builders::ModifyAquaConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyAuthenticationProfile` operation.
    ///
    /// See [`ModifyAuthenticationProfile`](crate::client::fluent_builders::ModifyAuthenticationProfile) for more information about the
    /// operation and its arguments.
    pub fn modify_authentication_profile(
        &self,
    ) -> fluent_builders::ModifyAuthenticationProfile<C, M, R> {
        fluent_builders::ModifyAuthenticationProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyCluster` operation.
    ///
    /// See [`ModifyCluster`](crate::client::fluent_builders::ModifyCluster) for more information about the
    /// operation and its arguments.
    pub fn modify_cluster(&self) -> fluent_builders::ModifyCluster<C, M, R> {
        fluent_builders::ModifyCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyClusterDbRevision` operation.
    ///
    /// See [`ModifyClusterDbRevision`](crate::client::fluent_builders::ModifyClusterDbRevision) for more information about the
    /// operation and its arguments.
    pub fn modify_cluster_db_revision(&self) -> fluent_builders::ModifyClusterDbRevision<C, M, R> {
        fluent_builders::ModifyClusterDbRevision::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyClusterIamRoles` operation.
    ///
    /// See [`ModifyClusterIamRoles`](crate::client::fluent_builders::ModifyClusterIamRoles) for more information about the
    /// operation and its arguments.
    pub fn modify_cluster_iam_roles(&self) -> fluent_builders::ModifyClusterIamRoles<C, M, R> {
        fluent_builders::ModifyClusterIamRoles::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyClusterMaintenance` operation.
    ///
    /// See [`ModifyClusterMaintenance`](crate::client::fluent_builders::ModifyClusterMaintenance) for more information about the
    /// operation and its arguments.
    pub fn modify_cluster_maintenance(&self) -> fluent_builders::ModifyClusterMaintenance<C, M, R> {
        fluent_builders::ModifyClusterMaintenance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyClusterParameterGroup` operation.
    ///
    /// See [`ModifyClusterParameterGroup`](crate::client::fluent_builders::ModifyClusterParameterGroup) for more information about the
    /// operation and its arguments.
    pub fn modify_cluster_parameter_group(
        &self,
    ) -> fluent_builders::ModifyClusterParameterGroup<C, M, R> {
        fluent_builders::ModifyClusterParameterGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyClusterSnapshot` operation.
    ///
    /// See [`ModifyClusterSnapshot`](crate::client::fluent_builders::ModifyClusterSnapshot) for more information about the
    /// operation and its arguments.
    pub fn modify_cluster_snapshot(&self) -> fluent_builders::ModifyClusterSnapshot<C, M, R> {
        fluent_builders::ModifyClusterSnapshot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyClusterSnapshotSchedule` operation.
    ///
    /// See [`ModifyClusterSnapshotSchedule`](crate::client::fluent_builders::ModifyClusterSnapshotSchedule) for more information about the
    /// operation and its arguments.
    pub fn modify_cluster_snapshot_schedule(
        &self,
    ) -> fluent_builders::ModifyClusterSnapshotSchedule<C, M, R> {
        fluent_builders::ModifyClusterSnapshotSchedule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyClusterSubnetGroup` operation.
    ///
    /// See [`ModifyClusterSubnetGroup`](crate::client::fluent_builders::ModifyClusterSubnetGroup) for more information about the
    /// operation and its arguments.
    pub fn modify_cluster_subnet_group(
        &self,
    ) -> fluent_builders::ModifyClusterSubnetGroup<C, M, R> {
        fluent_builders::ModifyClusterSubnetGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyEndpointAccess` operation.
    ///
    /// See [`ModifyEndpointAccess`](crate::client::fluent_builders::ModifyEndpointAccess) for more information about the
    /// operation and its arguments.
    pub fn modify_endpoint_access(&self) -> fluent_builders::ModifyEndpointAccess<C, M, R> {
        fluent_builders::ModifyEndpointAccess::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyEventSubscription` operation.
    ///
    /// See [`ModifyEventSubscription`](crate::client::fluent_builders::ModifyEventSubscription) for more information about the
    /// operation and its arguments.
    pub fn modify_event_subscription(&self) -> fluent_builders::ModifyEventSubscription<C, M, R> {
        fluent_builders::ModifyEventSubscription::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyScheduledAction` operation.
    ///
    /// See [`ModifyScheduledAction`](crate::client::fluent_builders::ModifyScheduledAction) for more information about the
    /// operation and its arguments.
    pub fn modify_scheduled_action(&self) -> fluent_builders::ModifyScheduledAction<C, M, R> {
        fluent_builders::ModifyScheduledAction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifySnapshotCopyRetentionPeriod` operation.
    ///
    /// See [`ModifySnapshotCopyRetentionPeriod`](crate::client::fluent_builders::ModifySnapshotCopyRetentionPeriod) for more information about the
    /// operation and its arguments.
    pub fn modify_snapshot_copy_retention_period(
        &self,
    ) -> fluent_builders::ModifySnapshotCopyRetentionPeriod<C, M, R> {
        fluent_builders::ModifySnapshotCopyRetentionPeriod::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifySnapshotSchedule` operation.
    ///
    /// See [`ModifySnapshotSchedule`](crate::client::fluent_builders::ModifySnapshotSchedule) for more information about the
    /// operation and its arguments.
    pub fn modify_snapshot_schedule(&self) -> fluent_builders::ModifySnapshotSchedule<C, M, R> {
        fluent_builders::ModifySnapshotSchedule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ModifyUsageLimit` operation.
    ///
    /// See [`ModifyUsageLimit`](crate::client::fluent_builders::ModifyUsageLimit) for more information about the
    /// operation and its arguments.
    pub fn modify_usage_limit(&self) -> fluent_builders::ModifyUsageLimit<C, M, R> {
        fluent_builders::ModifyUsageLimit::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PauseCluster` operation.
    ///
    /// See [`PauseCluster`](crate::client::fluent_builders::PauseCluster) for more information about the
    /// operation and its arguments.
    pub fn pause_cluster(&self) -> fluent_builders::PauseCluster<C, M, R> {
        fluent_builders::PauseCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PurchaseReservedNodeOffering` operation.
    ///
    /// See [`PurchaseReservedNodeOffering`](crate::client::fluent_builders::PurchaseReservedNodeOffering) for more information about the
    /// operation and its arguments.
    pub fn purchase_reserved_node_offering(
        &self,
    ) -> fluent_builders::PurchaseReservedNodeOffering<C, M, R> {
        fluent_builders::PurchaseReservedNodeOffering::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RebootCluster` operation.
    ///
    /// See [`RebootCluster`](crate::client::fluent_builders::RebootCluster) for more information about the
    /// operation and its arguments.
    pub fn reboot_cluster(&self) -> fluent_builders::RebootCluster<C, M, R> {
        fluent_builders::RebootCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RejectDataShare` operation.
    ///
    /// See [`RejectDataShare`](crate::client::fluent_builders::RejectDataShare) for more information about the
    /// operation and its arguments.
    pub fn reject_data_share(&self) -> fluent_builders::RejectDataShare<C, M, R> {
        fluent_builders::RejectDataShare::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ResetClusterParameterGroup` operation.
    ///
    /// See [`ResetClusterParameterGroup`](crate::client::fluent_builders::ResetClusterParameterGroup) for more information about the
    /// operation and its arguments.
    pub fn reset_cluster_parameter_group(
        &self,
    ) -> fluent_builders::ResetClusterParameterGroup<C, M, R> {
        fluent_builders::ResetClusterParameterGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ResizeCluster` operation.
    ///
    /// See [`ResizeCluster`](crate::client::fluent_builders::ResizeCluster) for more information about the
    /// operation and its arguments.
    pub fn resize_cluster(&self) -> fluent_builders::ResizeCluster<C, M, R> {
        fluent_builders::ResizeCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RestoreFromClusterSnapshot` operation.
    ///
    /// See [`RestoreFromClusterSnapshot`](crate::client::fluent_builders::RestoreFromClusterSnapshot) for more information about the
    /// operation and its arguments.
    pub fn restore_from_cluster_snapshot(
        &self,
    ) -> fluent_builders::RestoreFromClusterSnapshot<C, M, R> {
        fluent_builders::RestoreFromClusterSnapshot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RestoreTableFromClusterSnapshot` operation.
    ///
    /// See [`RestoreTableFromClusterSnapshot`](crate::client::fluent_builders::RestoreTableFromClusterSnapshot) for more information about the
    /// operation and its arguments.
    pub fn restore_table_from_cluster_snapshot(
        &self,
    ) -> fluent_builders::RestoreTableFromClusterSnapshot<C, M, R> {
        fluent_builders::RestoreTableFromClusterSnapshot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ResumeCluster` operation.
    ///
    /// See [`ResumeCluster`](crate::client::fluent_builders::ResumeCluster) for more information about the
    /// operation and its arguments.
    pub fn resume_cluster(&self) -> fluent_builders::ResumeCluster<C, M, R> {
        fluent_builders::ResumeCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RevokeClusterSecurityGroupIngress` operation.
    ///
    /// See [`RevokeClusterSecurityGroupIngress`](crate::client::fluent_builders::RevokeClusterSecurityGroupIngress) for more information about the
    /// operation and its arguments.
    pub fn revoke_cluster_security_group_ingress(
        &self,
    ) -> fluent_builders::RevokeClusterSecurityGroupIngress<C, M, R> {
        fluent_builders::RevokeClusterSecurityGroupIngress::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RevokeEndpointAccess` operation.
    ///
    /// See [`RevokeEndpointAccess`](crate::client::fluent_builders::RevokeEndpointAccess) for more information about the
    /// operation and its arguments.
    pub fn revoke_endpoint_access(&self) -> fluent_builders::RevokeEndpointAccess<C, M, R> {
        fluent_builders::RevokeEndpointAccess::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RevokeSnapshotAccess` operation.
    ///
    /// See [`RevokeSnapshotAccess`](crate::client::fluent_builders::RevokeSnapshotAccess) for more information about the
    /// operation and its arguments.
    pub fn revoke_snapshot_access(&self) -> fluent_builders::RevokeSnapshotAccess<C, M, R> {
        fluent_builders::RevokeSnapshotAccess::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RotateEncryptionKey` operation.
    ///
    /// See [`RotateEncryptionKey`](crate::client::fluent_builders::RotateEncryptionKey) for more information about the
    /// operation and its arguments.
    pub fn rotate_encryption_key(&self) -> fluent_builders::RotateEncryptionKey<C, M, R> {
        fluent_builders::RotateEncryptionKey::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdatePartnerStatus` operation.
    ///
    /// See [`UpdatePartnerStatus`](crate::client::fluent_builders::UpdatePartnerStatus) for more information about the
    /// operation and its arguments.
    pub fn update_partner_status(&self) -> fluent_builders::UpdatePartnerStatus<C, M, R> {
        fluent_builders::UpdatePartnerStatus::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AcceptReservedNodeExchange`.
    ///
    /// <p>Exchanges a DC1 Reserved Node for a DC2 Reserved Node with no changes to the
    /// configuration (term, payment type, or number of nodes) and no additional costs.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct AcceptReservedNodeExchange<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::accept_reserved_node_exchange_input::Builder,
    }
    impl<C, M, R> AcceptReservedNodeExchange<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AcceptReservedNodeExchange`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AcceptReservedNodeExchangeOutput,
            aws_smithy_http::result::SdkError<crate::error::AcceptReservedNodeExchangeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AcceptReservedNodeExchangeInputOperationOutputAlias,
                crate::output::AcceptReservedNodeExchangeOutput,
                crate::error::AcceptReservedNodeExchangeError,
                crate::input::AcceptReservedNodeExchangeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A string representing the node identifier of the DC1 Reserved Node to be
        /// exchanged.</p>
        pub fn reserved_node_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.reserved_node_id(inp);
            self
        }
        /// <p>A string representing the node identifier of the DC1 Reserved Node to be
        /// exchanged.</p>
        pub fn set_reserved_node_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_reserved_node_id(input);
            self
        }
        /// <p>The unique identifier of the DC2 Reserved Node offering to be used for the exchange.
        /// You can obtain the value for the parameter by calling <a>GetReservedNodeExchangeOfferings</a>
        /// </p>
        pub fn target_reserved_node_offering_id(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.target_reserved_node_offering_id(inp);
            self
        }
        /// <p>The unique identifier of the DC2 Reserved Node offering to be used for the exchange.
        /// You can obtain the value for the parameter by calling <a>GetReservedNodeExchangeOfferings</a>
        /// </p>
        pub fn set_target_reserved_node_offering_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_target_reserved_node_offering_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AddPartner`.
    ///
    /// <p>Adds a partner integration to a cluster.
    /// This operation authorizes a partner to push status updates for the specified database.
    /// To complete the integration, you also set up the integration on the partner website.</p>
    #[derive(std::fmt::Debug)]
    pub struct AddPartner<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::add_partner_input::Builder,
    }
    impl<C, M, R> AddPartner<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AddPartner`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AddPartnerOutput,
            aws_smithy_http::result::SdkError<crate::error::AddPartnerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AddPartnerInputOperationOutputAlias,
                crate::output::AddPartnerOutput,
                crate::error::AddPartnerError,
                crate::input::AddPartnerInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID that owns the cluster.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The Amazon Web Services account ID that owns the cluster.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The cluster identifier of the cluster that receives data from the partner.</p>
        pub fn cluster_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_identifier(inp);
            self
        }
        /// <p>The cluster identifier of the cluster that receives data from the partner.</p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_identifier(input);
            self
        }
        /// <p>The name of the database that receives data from the partner.</p>
        pub fn database_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.database_name(inp);
            self
        }
        /// <p>The name of the database that receives data from the partner.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_database_name(input);
            self
        }
        /// <p>The name of the partner that is authorized to send data.</p>
        pub fn partner_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.partner_name(inp);
            self
        }
        /// <p>The name of the partner that is authorized to send data.</p>
        pub fn set_partner_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_partner_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateDataShareConsumer`.
    ///
    /// <p>From a datashare consumer account, associates a datashare with the
    /// account (AssociateEntireAccount) or the specified namespace (ConsumerArn). If you make this association, the consumer
    /// can consume the datashare.</p>
    #[derive(std::fmt::Debug)]
    pub struct AssociateDataShareConsumer<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_data_share_consumer_input::Builder,
    }
    impl<C, M, R> AssociateDataShareConsumer<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateDataShareConsumer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateDataShareConsumerOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateDataShareConsumerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateDataShareConsumerInputOperationOutputAlias,
                crate::output::AssociateDataShareConsumerOutput,
                crate::error::AssociateDataShareConsumerError,
                crate::input::AssociateDataShareConsumerInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the datashare that the consumer is to use with the account or the namespace.</p>
        pub fn data_share_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_share_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the datashare that the consumer is to use with the account or the namespace.</p>
        pub fn set_data_share_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_data_share_arn(input);
            self
        }
        /// <p>A value that specifies whether the datashare is associated with the entire account.</p>
        pub fn associate_entire_account(mut self, inp: bool) -> Self {
            self.inner = self.inner.associate_entire_account(inp);
            self
        }
        /// <p>A value that specifies whether the datashare is associated with the entire account.</p>
        pub fn set_associate_entire_account(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_associate_entire_account(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the consumer that is associated with the
        /// datashare.</p>
        pub fn consumer_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.consumer_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the consumer that is associated with the
        /// datashare.</p>
        pub fn set_consumer_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_consumer_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AuthorizeClusterSecurityGroupIngress`.
    ///
    /// <p>Adds an inbound (ingress) rule to an Amazon Redshift security group. Depending on whether
    /// the application accessing your cluster is running on the Internet or an Amazon EC2
    /// instance, you can authorize inbound access to either a Classless Interdomain Routing
    /// (CIDR)/Internet Protocol (IP) range or to an Amazon EC2 security group. You can add as
    /// many as 20 ingress rules to an Amazon Redshift security group.</p>
    /// <p>If you authorize access to an Amazon EC2 security group, specify
    /// <i>EC2SecurityGroupName</i> and
    /// <i>EC2SecurityGroupOwnerId</i>. The Amazon EC2 security group and
    /// Amazon Redshift cluster must be in the same Amazon Web Services Region. </p>
    /// <p>If you authorize access to a CIDR/IP address range, specify
    /// <i>CIDRIP</i>. For an overview of CIDR blocks, see the Wikipedia
    /// article on <a href="http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Classless Inter-Domain Routing</a>. </p>
    /// <p>You must also associate the security group with a cluster so that clients running
    /// on these IP addresses or the EC2 instance are authorized to connect to the cluster. For
    /// information about managing security groups, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-security-groups.html">Working with Security
    /// Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct AuthorizeClusterSecurityGroupIngress<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::authorize_cluster_security_group_ingress_input::Builder,
    }
    impl<C, M, R> AuthorizeClusterSecurityGroupIngress<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AuthorizeClusterSecurityGroupIngress`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AuthorizeClusterSecurityGroupIngressOutput,
            aws_smithy_http::result::SdkError<
                crate::error::AuthorizeClusterSecurityGroupIngressError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AuthorizeClusterSecurityGroupIngressInputOperationOutputAlias,
                crate::output::AuthorizeClusterSecurityGroupIngressOutput,
                crate::error::AuthorizeClusterSecurityGroupIngressError,
                crate::input::AuthorizeClusterSecurityGroupIngressInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the security group to which the ingress rule is added.</p>
        pub fn cluster_security_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_security_group_name(inp);
            self
        }
        /// <p>The name of the security group to which the ingress rule is added.</p>
        pub fn set_cluster_security_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_security_group_name(input);
            self
        }
        /// <p>The IP range to be added the Amazon Redshift security group.</p>
        pub fn cidrip(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cidrip(inp);
            self
        }
        /// <p>The IP range to be added the Amazon Redshift security group.</p>
        pub fn set_cidrip(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cidrip(input);
            self
        }
        /// <p>The EC2 security group to be added the Amazon Redshift security group.</p>
        pub fn ec2_security_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ec2_security_group_name(inp);
            self
        }
        /// <p>The EC2 security group to be added the Amazon Redshift security group.</p>
        pub fn set_ec2_security_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_ec2_security_group_name(input);
            self
        }
        /// <p>The Amazon Web Services account number of the owner of the security group specified by the
        /// <i>EC2SecurityGroupName</i> parameter. The Amazon Web Services Access Key ID is not an
        /// acceptable value. </p>
        /// <p>Example: <code>111122223333</code>
        /// </p>
        pub fn ec2_security_group_owner_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ec2_security_group_owner_id(inp);
            self
        }
        /// <p>The Amazon Web Services account number of the owner of the security group specified by the
        /// <i>EC2SecurityGroupName</i> parameter. The Amazon Web Services Access Key ID is not an
        /// acceptable value. </p>
        /// <p>Example: <code>111122223333</code>
        /// </p>
        pub fn set_ec2_security_group_owner_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_ec2_security_group_owner_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AuthorizeDataShare`.
    ///
    /// <p>From a data producer account, authorizes the sharing of a datashare with one or more
    /// consumer accounts. To authorize a datashare for a data consumer, the producer account
    /// must have the correct access privileges.</p>
    #[derive(std::fmt::Debug)]
    pub struct AuthorizeDataShare<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::authorize_data_share_input::Builder,
    }
    impl<C, M, R> AuthorizeDataShare<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AuthorizeDataShare`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AuthorizeDataShareOutput,
            aws_smithy_http::result::SdkError<crate::error::AuthorizeDataShareError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AuthorizeDataShareInputOperationOutputAlias,
                crate::output::AuthorizeDataShareOutput,
                crate::error::AuthorizeDataShareError,
                crate::input::AuthorizeDataShareInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the datashare that producers are to authorize
        /// sharing for.</p>
        pub fn data_share_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_share_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the datashare that producers are to authorize
        /// sharing for.</p>
        pub fn set_data_share_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_data_share_arn(input);
            self
        }
        /// <p>The identifier of the data consumer that is authorized to access the datashare. This identifier is an AWS account ID.</p>
        pub fn consumer_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.consumer_identifier(inp);
            self
        }
        /// <p>The identifier of the data consumer that is authorized to access the datashare. This identifier is an AWS account ID.</p>
        pub fn set_consumer_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_consumer_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AuthorizeEndpointAccess`.
    ///
    /// <p>Grants access to a cluster.</p>
    #[derive(std::fmt::Debug)]
    pub struct AuthorizeEndpointAccess<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::authorize_endpoint_access_input::Builder,
    }
    impl<C, M, R> AuthorizeEndpointAccess<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AuthorizeEndpointAccess`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AuthorizeEndpointAccessOutput,
            aws_smithy_http::result::SdkError<crate::error::AuthorizeEndpointAccessError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AuthorizeEndpointAccessInputOperationOutputAlias,
                crate::output::AuthorizeEndpointAccessOutput,
                crate::error::AuthorizeEndpointAccessError,
                crate::input::AuthorizeEndpointAccessInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The cluster identifier of the cluster to grant access to.</p>
        pub fn cluster_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_identifier(inp);
            self
        }
        /// <p>The cluster identifier of the cluster to grant access to.</p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_identifier(input);
            self
        }
        /// <p>The Amazon Web Services account ID to grant access to.</p>
        pub fn account(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account(inp);
            self
        }
        /// <p>The Amazon Web Services account ID to grant access to.</p>
        pub fn set_account(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account(input);
            self
        }
        /// Appends an item to `VpcIds`.
        ///
        /// To override the contents of this collection use [`set_vpc_ids`](Self::set_vpc_ids).
        ///
        /// <p>The virtual private cloud (VPC) identifiers to grant access to.</p>
        pub fn vpc_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc_ids(inp);
            self
        }
        /// <p>The virtual private cloud (VPC) identifiers to grant access to.</p>
        pub fn set_vpc_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_vpc_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AuthorizeSnapshotAccess`.
    ///
    /// <p>Authorizes the specified Amazon Web Services account to restore the specified
    /// snapshot.</p>
    /// <p>
    /// For more information about working with snapshots, go to
    /// <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-snapshots.html">Amazon Redshift Snapshots</a>
    /// in the <i>Amazon Redshift Cluster Management Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct AuthorizeSnapshotAccess<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::authorize_snapshot_access_input::Builder,
    }
    impl<C, M, R> AuthorizeSnapshotAccess<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AuthorizeSnapshotAccess`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AuthorizeSnapshotAccessOutput,
            aws_smithy_http::result::SdkError<crate::error::AuthorizeSnapshotAccessError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AuthorizeSnapshotAccessInputOperationOutputAlias,
                crate::output::AuthorizeSnapshotAccessOutput,
                crate::error::AuthorizeSnapshotAccessError,
                crate::input::AuthorizeSnapshotAccessInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the snapshot the account is authorized to restore.</p>
        pub fn snapshot_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.snapshot_identifier(inp);
            self
        }
        /// <p>The identifier of the snapshot the account is authorized to restore.</p>
        pub fn set_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_snapshot_identifier(input);
            self
        }
        /// <p>The identifier of the cluster the snapshot was created from. This parameter is
        /// required if your IAM user has a policy containing a snapshot resource element that
        /// specifies anything other than * for the cluster name.</p>
        pub fn snapshot_cluster_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.snapshot_cluster_identifier(inp);
            self
        }
        /// <p>The identifier of the cluster the snapshot was created from. This parameter is
        /// required if your IAM user has a policy containing a snapshot resource element that
        /// specifies anything other than * for the cluster name.</p>
        pub fn set_snapshot_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_snapshot_cluster_identifier(input);
            self
        }
        /// <p>The identifier of the Amazon Web Services account authorized to restore the specified
        /// snapshot.</p>
        /// <p>To share a snapshot with Amazon Web Services Support, specify amazon-redshift-support.</p>
        pub fn account_with_restore_access(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_with_restore_access(inp);
            self
        }
        /// <p>The identifier of the Amazon Web Services account authorized to restore the specified
        /// snapshot.</p>
        /// <p>To share a snapshot with Amazon Web Services Support, specify amazon-redshift-support.</p>
        pub fn set_account_with_restore_access(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_account_with_restore_access(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchDeleteClusterSnapshots`.
    ///
    /// <p>Deletes a set of cluster snapshots.</p>
    #[derive(std::fmt::Debug)]
    pub struct BatchDeleteClusterSnapshots<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_delete_cluster_snapshots_input::Builder,
    }
    impl<C, M, R> BatchDeleteClusterSnapshots<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchDeleteClusterSnapshots`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchDeleteClusterSnapshotsOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchDeleteClusterSnapshotsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchDeleteClusterSnapshotsInputOperationOutputAlias,
                crate::output::BatchDeleteClusterSnapshotsOutput,
                crate::error::BatchDeleteClusterSnapshotsError,
                crate::input::BatchDeleteClusterSnapshotsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `Identifiers`.
        ///
        /// To override the contents of this collection use [`set_identifiers`](Self::set_identifiers).
        ///
        /// <p>A list of identifiers for the snapshots that you want to delete.</p>
        pub fn identifiers(
            mut self,
            inp: impl Into<crate::model::DeleteClusterSnapshotMessage>,
        ) -> Self {
            self.inner = self.inner.identifiers(inp);
            self
        }
        /// <p>A list of identifiers for the snapshots that you want to delete.</p>
        pub fn set_identifiers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DeleteClusterSnapshotMessage>>,
        ) -> Self {
            self.inner = self.inner.set_identifiers(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchModifyClusterSnapshots`.
    ///
    /// <p>Modifies the settings for a set of cluster snapshots.</p>
    #[derive(std::fmt::Debug)]
    pub struct BatchModifyClusterSnapshots<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_modify_cluster_snapshots_input::Builder,
    }
    impl<C, M, R> BatchModifyClusterSnapshots<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchModifyClusterSnapshots`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchModifyClusterSnapshotsOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchModifyClusterSnapshotsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchModifyClusterSnapshotsInputOperationOutputAlias,
                crate::output::BatchModifyClusterSnapshotsOutput,
                crate::error::BatchModifyClusterSnapshotsError,
                crate::input::BatchModifyClusterSnapshotsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `SnapshotIdentifierList`.
        ///
        /// To override the contents of this collection use [`set_snapshot_identifier_list`](Self::set_snapshot_identifier_list).
        ///
        /// <p>A list of snapshot identifiers you want to modify.</p>
        pub fn snapshot_identifier_list(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.snapshot_identifier_list(inp);
            self
        }
        /// <p>A list of snapshot identifiers you want to modify.</p>
        pub fn set_snapshot_identifier_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_snapshot_identifier_list(input);
            self
        }
        /// <p>The number of days that a manual snapshot is retained. If you specify the value -1,
        /// the manual snapshot is retained indefinitely.</p>
        /// <p>The number must be either -1 or an integer between 1 and 3,653.</p>
        /// <p>If you decrease the manual snapshot retention period from its current value, existing
        /// manual snapshots that fall outside of the new retention period will return an error. If
        /// you want to suppress the errors and delete the snapshots, use the force option. </p>
        pub fn manual_snapshot_retention_period(mut self, inp: i32) -> Self {
            self.inner = self.inner.manual_snapshot_retention_period(inp);
            self
        }
        /// <p>The number of days that a manual snapshot is retained. If you specify the value -1,
        /// the manual snapshot is retained indefinitely.</p>
        /// <p>The number must be either -1 or an integer between 1 and 3,653.</p>
        /// <p>If you decrease the manual snapshot retention period from its current value, existing
        /// manual snapshots that fall outside of the new retention period will return an error. If
        /// you want to suppress the errors and delete the snapshots, use the force option. </p>
        pub fn set_manual_snapshot_retention_period(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.inner = self.inner.set_manual_snapshot_retention_period(input);
            self
        }
        /// <p>A boolean value indicating whether to override an exception if the retention period
        /// has passed. </p>
        pub fn force(mut self, inp: bool) -> Self {
            self.inner = self.inner.force(inp);
            self
        }
        /// <p>A boolean value indicating whether to override an exception if the retention period
        /// has passed. </p>
        pub fn set_force(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_force(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CancelResize`.
    ///
    /// <p>Cancels a resize operation for a cluster.</p>
    #[derive(std::fmt::Debug)]
    pub struct CancelResize<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::cancel_resize_input::Builder,
    }
    impl<C, M, R> CancelResize<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CancelResize`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CancelResizeOutput,
            aws_smithy_http::result::SdkError<crate::error::CancelResizeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CancelResizeInputOperationOutputAlias,
                crate::output::CancelResizeOutput,
                crate::error::CancelResizeError,
                crate::input::CancelResizeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the cluster that you want to cancel a resize operation
        /// for.</p>
        pub fn cluster_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_identifier(inp);
            self
        }
        /// <p>The unique identifier for the cluster that you want to cancel a resize operation
        /// for.</p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CopyClusterSnapshot`.
    ///
    /// <p>Copies the specified automated cluster snapshot to a new manual cluster snapshot.
    /// The source must be an automated snapshot and it must be in the available
    /// state.</p>
    /// <p>When you delete a cluster, Amazon Redshift deletes any automated snapshots of the
    /// cluster. Also, when the retention period of the snapshot expires, Amazon Redshift
    /// automatically deletes it. If you want to keep an automated snapshot for a longer period,
    /// you can make a manual copy of the snapshot. Manual snapshots are retained until you
    /// delete them.</p>
    /// <p>
    /// For more information about working with snapshots, go to
    /// <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-snapshots.html">Amazon Redshift Snapshots</a>
    /// in the <i>Amazon Redshift Cluster Management Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CopyClusterSnapshot<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::copy_cluster_snapshot_input::Builder,
    }
    impl<C, M, R> CopyClusterSnapshot<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CopyClusterSnapshot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CopyClusterSnapshotOutput,
            aws_smithy_http::result::SdkError<crate::error::CopyClusterSnapshotError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CopyClusterSnapshotInputOperationOutputAlias,
                crate::output::CopyClusterSnapshotOutput,
                crate::error::CopyClusterSnapshotError,
                crate::input::CopyClusterSnapshotInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier for the source snapshot.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be the identifier for a valid automated snapshot whose state is
        /// <code>available</code>.</p>
        /// </li>
        /// </ul>
        pub fn source_snapshot_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_snapshot_identifier(inp);
            self
        }
        /// <p>The identifier for the source snapshot.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be the identifier for a valid automated snapshot whose state is
        /// <code>available</code>.</p>
        /// </li>
        /// </ul>
        pub fn set_source_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_snapshot_identifier(input);
            self
        }
        /// <p>The identifier of the cluster the source snapshot was created from. This parameter
        /// is required if your IAM user has a policy containing a snapshot resource element that
        /// specifies anything other than * for the cluster name.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be the identifier for a valid cluster.</p>
        /// </li>
        /// </ul>
        pub fn source_snapshot_cluster_identifier(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.source_snapshot_cluster_identifier(inp);
            self
        }
        /// <p>The identifier of the cluster the source snapshot was created from. This parameter
        /// is required if your IAM user has a policy containing a snapshot resource element that
        /// specifies anything other than * for the cluster name.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be the identifier for a valid cluster.</p>
        /// </li>
        /// </ul>
        pub fn set_source_snapshot_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_snapshot_cluster_identifier(input);
            self
        }
        /// <p>The identifier given to the new manual snapshot.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Cannot be null, empty, or blank.</p>
        /// </li>
        /// <li>
        /// <p>Must contain from 1 to 255 alphanumeric characters or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// <li>
        /// <p>Must be unique for the Amazon Web Services account that is making the request.</p>
        /// </li>
        /// </ul>
        pub fn target_snapshot_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_snapshot_identifier(inp);
            self
        }
        /// <p>The identifier given to the new manual snapshot.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Cannot be null, empty, or blank.</p>
        /// </li>
        /// <li>
        /// <p>Must contain from 1 to 255 alphanumeric characters or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// <li>
        /// <p>Must be unique for the Amazon Web Services account that is making the request.</p>
        /// </li>
        /// </ul>
        pub fn set_target_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_target_snapshot_identifier(input);
            self
        }
        /// <p>The number of days that a manual snapshot is retained. If the value is -1, the manual
        /// snapshot is retained indefinitely. </p>
        /// <p>The value must be either -1 or an integer between 1 and 3,653.</p>
        /// <p>The default value is -1.</p>
        pub fn manual_snapshot_retention_period(mut self, inp: i32) -> Self {
            self.inner = self.inner.manual_snapshot_retention_period(inp);
            self
        }
        /// <p>The number of days that a manual snapshot is retained. If the value is -1, the manual
        /// snapshot is retained indefinitely. </p>
        /// <p>The value must be either -1 or an integer between 1 and 3,653.</p>
        /// <p>The default value is -1.</p>
        pub fn set_manual_snapshot_retention_period(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.inner = self.inner.set_manual_snapshot_retention_period(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateAuthenticationProfile`.
    ///
    /// <p>Creates an authentication profile with the specified parameters.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateAuthenticationProfile<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_authentication_profile_input::Builder,
    }
    impl<C, M, R> CreateAuthenticationProfile<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateAuthenticationProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAuthenticationProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAuthenticationProfileError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateAuthenticationProfileInputOperationOutputAlias,
                crate::output::CreateAuthenticationProfileOutput,
                crate::error::CreateAuthenticationProfileError,
                crate::input::CreateAuthenticationProfileInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the authentication profile to be created.</p>
        pub fn authentication_profile_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.authentication_profile_name(inp);
            self
        }
        /// <p>The name of the authentication profile to be created.</p>
        pub fn set_authentication_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_authentication_profile_name(input);
            self
        }
        /// <p>The content of the authentication profile in JSON format.
        /// The maximum length of the JSON string is determined by a quota for your account.</p>
        pub fn authentication_profile_content(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.authentication_profile_content(inp);
            self
        }
        /// <p>The content of the authentication profile in JSON format.
        /// The maximum length of the JSON string is determined by a quota for your account.</p>
        pub fn set_authentication_profile_content(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_authentication_profile_content(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateCluster`.
    ///
    /// <p>Creates a new cluster with the specified parameters.</p>
    /// <p>To create a cluster in Virtual Private Cloud (VPC), you must provide a cluster
    /// subnet group name. The cluster subnet group identifies the subnets of your VPC that
    /// Amazon Redshift uses when creating the cluster.
    /// For more information about managing clusters, go to
    /// <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html">Amazon Redshift Clusters</a>
    /// in the <i>Amazon Redshift Cluster Management Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateCluster<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_cluster_input::Builder,
    }
    impl<C, M, R> CreateCluster<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateCluster`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateClusterOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateClusterError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateClusterInputOperationOutputAlias,
                crate::output::CreateClusterOutput,
                crate::error::CreateClusterError,
                crate::input::CreateClusterInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the first database to be created when the cluster is created.</p>
        /// <p>To create additional databases after the cluster is created, connect to the cluster
        /// with a SQL client and use SQL commands to create a database. For more information, go to
        /// <a href="https://docs.aws.amazon.com/redshift/latest/dg/t_creating_database.html">Create
        /// a Database</a> in the Amazon Redshift Database Developer Guide. </p>
        /// <p>Default: <code>dev</code>
        /// </p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain 1 to 64 alphanumeric characters.</p>
        /// </li>
        /// <li>
        /// <p>Must contain only lowercase letters.</p>
        /// </li>
        /// <li>
        /// <p>Cannot be a word that is reserved by the service. A list of reserved words
        /// can be found in <a href="https://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html">Reserved Words</a> in the
        /// Amazon Redshift Database Developer Guide. </p>
        /// </li>
        /// </ul>
        pub fn db_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_name(inp);
            self
        }
        /// <p>The name of the first database to be created when the cluster is created.</p>
        /// <p>To create additional databases after the cluster is created, connect to the cluster
        /// with a SQL client and use SQL commands to create a database. For more information, go to
        /// <a href="https://docs.aws.amazon.com/redshift/latest/dg/t_creating_database.html">Create
        /// a Database</a> in the Amazon Redshift Database Developer Guide. </p>
        /// <p>Default: <code>dev</code>
        /// </p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain 1 to 64 alphanumeric characters.</p>
        /// </li>
        /// <li>
        /// <p>Must contain only lowercase letters.</p>
        /// </li>
        /// <li>
        /// <p>Cannot be a word that is reserved by the service. A list of reserved words
        /// can be found in <a href="https://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html">Reserved Words</a> in the
        /// Amazon Redshift Database Developer Guide. </p>
        /// </li>
        /// </ul>
        pub fn set_db_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_db_name(input);
            self
        }
        /// <p>A unique identifier for the cluster. You use this identifier to refer to the
        /// cluster for any subsequent cluster operations such as deleting or modifying. The
        /// identifier also appears in the Amazon Redshift console.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain from 1 to 63 alphanumeric characters or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>Alphabetic characters must be lowercase.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// <li>
        /// <p>Must be unique for all clusters within an Amazon Web Services account.</p>
        /// </li>
        /// </ul>
        ///
        /// <p>Example: <code>myexamplecluster</code>
        /// </p>
        pub fn cluster_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_identifier(inp);
            self
        }
        /// <p>A unique identifier for the cluster. You use this identifier to refer to the
        /// cluster for any subsequent cluster operations such as deleting or modifying. The
        /// identifier also appears in the Amazon Redshift console.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain from 1 to 63 alphanumeric characters or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>Alphabetic characters must be lowercase.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// <li>
        /// <p>Must be unique for all clusters within an Amazon Web Services account.</p>
        /// </li>
        /// </ul>
        ///
        /// <p>Example: <code>myexamplecluster</code>
        /// </p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_identifier(input);
            self
        }
        /// <p>The type of the cluster. When cluster type is specified as</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>single-node</code>, the <b>NumberOfNodes</b>
        /// parameter is not required.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>multi-node</code>, the <b>NumberOfNodes</b>
        /// parameter is required.</p>
        /// </li>
        /// </ul>
        /// <p>Valid Values: <code>multi-node</code> | <code>single-node</code>
        /// </p>
        /// <p>Default: <code>multi-node</code>
        /// </p>
        pub fn cluster_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_type(inp);
            self
        }
        /// <p>The type of the cluster. When cluster type is specified as</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>single-node</code>, the <b>NumberOfNodes</b>
        /// parameter is not required.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>multi-node</code>, the <b>NumberOfNodes</b>
        /// parameter is required.</p>
        /// </li>
        /// </ul>
        /// <p>Valid Values: <code>multi-node</code> | <code>single-node</code>
        /// </p>
        /// <p>Default: <code>multi-node</code>
        /// </p>
        pub fn set_cluster_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster_type(input);
            self
        }
        /// <p>The node type to be provisioned for the cluster. For information about node types,
        /// go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#how-many-nodes"> Working with
        /// Clusters</a> in the <i>Amazon Redshift Cluster Management Guide</i>. </p>
        /// <p>Valid Values: <code>ds2.xlarge</code> | <code>ds2.8xlarge</code> |
        /// <code>dc1.large</code> | <code>dc1.8xlarge</code> |
        /// <code>dc2.large</code> | <code>dc2.8xlarge</code> |
        /// <code>ra3.xlplus</code> |  <code>ra3.4xlarge</code> | <code>ra3.16xlarge</code>
        /// </p>
        pub fn node_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.node_type(inp);
            self
        }
        /// <p>The node type to be provisioned for the cluster. For information about node types,
        /// go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#how-many-nodes"> Working with
        /// Clusters</a> in the <i>Amazon Redshift Cluster Management Guide</i>. </p>
        /// <p>Valid Values: <code>ds2.xlarge</code> | <code>ds2.8xlarge</code> |
        /// <code>dc1.large</code> | <code>dc1.8xlarge</code> |
        /// <code>dc2.large</code> | <code>dc2.8xlarge</code> |
        /// <code>ra3.xlplus</code> |  <code>ra3.4xlarge</code> | <code>ra3.16xlarge</code>
        /// </p>
        pub fn set_node_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_node_type(input);
            self
        }
        /// <p>The user name associated with the admin user account for the cluster that is being
        /// created.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be 1 - 128 alphanumeric characters. The user name can't be
        /// <code>PUBLIC</code>.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        ///
        /// <p>Cannot be a reserved word. A list of reserved words can be found in <a href="https://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html">Reserved
        /// Words</a> in the Amazon Redshift Database Developer Guide. </p>
        /// </li>
        /// </ul>
        pub fn master_username(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.master_username(inp);
            self
        }
        /// <p>The user name associated with the admin user account for the cluster that is being
        /// created.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be 1 - 128 alphanumeric characters. The user name can't be
        /// <code>PUBLIC</code>.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        ///
        /// <p>Cannot be a reserved word. A list of reserved words can be found in <a href="https://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html">Reserved
        /// Words</a> in the Amazon Redshift Database Developer Guide. </p>
        /// </li>
        /// </ul>
        pub fn set_master_username(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_master_username(input);
            self
        }
        /// <p>The password associated with the admin user account for the cluster that is being
        /// created.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be between 8 and 64 characters in length.</p>
        /// </li>
        /// <li>
        /// <p>Must contain at least one uppercase letter.</p>
        /// </li>
        /// <li>
        /// <p>Must contain at least one lowercase letter.</p>
        /// </li>
        /// <li>
        /// <p>Must contain one number.</p>
        /// </li>
        /// <li>
        /// <p>Can be any printable ASCII character (ASCII code 33 to 126) except '
        /// (single quote), " (double quote), \, /, @, or space.</p>
        /// </li>
        /// </ul>
        pub fn master_user_password(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.master_user_password(inp);
            self
        }
        /// <p>The password associated with the admin user account for the cluster that is being
        /// created.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be between 8 and 64 characters in length.</p>
        /// </li>
        /// <li>
        /// <p>Must contain at least one uppercase letter.</p>
        /// </li>
        /// <li>
        /// <p>Must contain at least one lowercase letter.</p>
        /// </li>
        /// <li>
        /// <p>Must contain one number.</p>
        /// </li>
        /// <li>
        /// <p>Can be any printable ASCII character (ASCII code 33 to 126) except '
        /// (single quote), " (double quote), \, /, @, or space.</p>
        /// </li>
        /// </ul>
        pub fn set_master_user_password(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_master_user_password(input);
            self
        }
        /// Appends an item to `ClusterSecurityGroups`.
        ///
        /// To override the contents of this collection use [`set_cluster_security_groups`](Self::set_cluster_security_groups).
        ///
        /// <p>A list of security groups to be associated with this cluster.</p>
        /// <p>Default: The default cluster security group for Amazon Redshift.</p>
        pub fn cluster_security_groups(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_security_groups(inp);
            self
        }
        /// <p>A list of security groups to be associated with this cluster.</p>
        /// <p>Default: The default cluster security group for Amazon Redshift.</p>
        pub fn set_cluster_security_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_cluster_security_groups(input);
            self
        }
        /// Appends an item to `VpcSecurityGroupIds`.
        ///
        /// To override the contents of this collection use [`set_vpc_security_group_ids`](Self::set_vpc_security_group_ids).
        ///
        /// <p>A list of Virtual Private Cloud (VPC) security groups to be associated with the
        /// cluster.</p>
        /// <p>Default: The default VPC security group is associated with the cluster.</p>
        pub fn vpc_security_group_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc_security_group_ids(inp);
            self
        }
        /// <p>A list of Virtual Private Cloud (VPC) security groups to be associated with the
        /// cluster.</p>
        /// <p>Default: The default VPC security group is associated with the cluster.</p>
        pub fn set_vpc_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_vpc_security_group_ids(input);
            self
        }
        /// <p>The name of a cluster subnet group to be associated with this cluster.</p>
        /// <p>If this parameter is not provided the resulting cluster will be deployed outside
        /// virtual private cloud (VPC).</p>
        pub fn cluster_subnet_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_subnet_group_name(inp);
            self
        }
        /// <p>The name of a cluster subnet group to be associated with this cluster.</p>
        /// <p>If this parameter is not provided the resulting cluster will be deployed outside
        /// virtual private cloud (VPC).</p>
        pub fn set_cluster_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_subnet_group_name(input);
            self
        }
        /// <p>The EC2 Availability Zone (AZ) in which you want Amazon Redshift to provision the
        /// cluster. For example, if you have several EC2 instances running in a specific
        /// Availability Zone, then you might want the cluster to be provisioned in the same zone in
        /// order to decrease network latency.</p>
        /// <p>Default: A random, system-chosen Availability Zone in the region that is specified
        /// by the endpoint.</p>
        /// <p>Example: <code>us-east-2d</code>
        /// </p>
        /// <p>Constraint: The specified Availability Zone must be in the same region as the
        /// current endpoint.</p>
        pub fn availability_zone(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.availability_zone(inp);
            self
        }
        /// <p>The EC2 Availability Zone (AZ) in which you want Amazon Redshift to provision the
        /// cluster. For example, if you have several EC2 instances running in a specific
        /// Availability Zone, then you might want the cluster to be provisioned in the same zone in
        /// order to decrease network latency.</p>
        /// <p>Default: A random, system-chosen Availability Zone in the region that is specified
        /// by the endpoint.</p>
        /// <p>Example: <code>us-east-2d</code>
        /// </p>
        /// <p>Constraint: The specified Availability Zone must be in the same region as the
        /// current endpoint.</p>
        pub fn set_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_availability_zone(input);
            self
        }
        /// <p>The weekly time range (in UTC) during which automated cluster maintenance can
        /// occur.</p>
        /// <p> Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
        /// </p>
        /// <p> Default: A 30-minute window selected at random from an 8-hour block of time per
        /// region, occurring on a random day of the week. For more information about the time
        /// blocks for each region, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#rs-maintenance-windows">Maintenance Windows</a> in Amazon Redshift Cluster Management Guide.</p>
        /// <p>Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun</p>
        /// <p>Constraints: Minimum 30-minute window.</p>
        pub fn preferred_maintenance_window(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.preferred_maintenance_window(inp);
            self
        }
        /// <p>The weekly time range (in UTC) during which automated cluster maintenance can
        /// occur.</p>
        /// <p> Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
        /// </p>
        /// <p> Default: A 30-minute window selected at random from an 8-hour block of time per
        /// region, occurring on a random day of the week. For more information about the time
        /// blocks for each region, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#rs-maintenance-windows">Maintenance Windows</a> in Amazon Redshift Cluster Management Guide.</p>
        /// <p>Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun</p>
        /// <p>Constraints: Minimum 30-minute window.</p>
        pub fn set_preferred_maintenance_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_preferred_maintenance_window(input);
            self
        }
        /// <p>The name of the parameter group to be associated with this cluster.</p>
        /// <p>Default: The default Amazon Redshift cluster parameter group. For information about the
        /// default parameter group, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Working with Amazon
        /// Redshift Parameter Groups</a>
        /// </p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be 1 to 255 alphanumeric characters or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// </ul>
        pub fn cluster_parameter_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_parameter_group_name(inp);
            self
        }
        /// <p>The name of the parameter group to be associated with this cluster.</p>
        /// <p>Default: The default Amazon Redshift cluster parameter group. For information about the
        /// default parameter group, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Working with Amazon
        /// Redshift Parameter Groups</a>
        /// </p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be 1 to 255 alphanumeric characters or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// </ul>
        pub fn set_cluster_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_parameter_group_name(input);
            self
        }
        /// <p>The number of days that automated snapshots are retained. If the value is 0,
        /// automated snapshots are disabled. Even if automated snapshots are disabled, you can
        /// still create manual snapshots when you want with <a>CreateClusterSnapshot</a>. </p>
        ///
        /// <p>You can't disable automated snapshots for RA3 node types. Set the automated retention period from 1-35 days.</p>
        /// <p>Default: <code>1</code>
        /// </p>
        /// <p>Constraints: Must be a value from 0 to 35.</p>
        pub fn automated_snapshot_retention_period(mut self, inp: i32) -> Self {
            self.inner = self.inner.automated_snapshot_retention_period(inp);
            self
        }
        /// <p>The number of days that automated snapshots are retained. If the value is 0,
        /// automated snapshots are disabled. Even if automated snapshots are disabled, you can
        /// still create manual snapshots when you want with <a>CreateClusterSnapshot</a>. </p>
        ///
        /// <p>You can't disable automated snapshots for RA3 node types. Set the automated retention period from 1-35 days.</p>
        /// <p>Default: <code>1</code>
        /// </p>
        /// <p>Constraints: Must be a value from 0 to 35.</p>
        pub fn set_automated_snapshot_retention_period(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.inner = self.inner.set_automated_snapshot_retention_period(input);
            self
        }
        /// <p>The default number of days to retain a manual snapshot. If the value is -1, the
        /// snapshot is retained indefinitely. This setting doesn't change the retention period
        /// of existing snapshots.</p>
        /// <p>The value must be either -1 or an integer between 1 and 3,653.</p>
        pub fn manual_snapshot_retention_period(mut self, inp: i32) -> Self {
            self.inner = self.inner.manual_snapshot_retention_period(inp);
            self
        }
        /// <p>The default number of days to retain a manual snapshot. If the value is -1, the
        /// snapshot is retained indefinitely. This setting doesn't change the retention period
        /// of existing snapshots.</p>
        /// <p>The value must be either -1 or an integer between 1 and 3,653.</p>
        pub fn set_manual_snapshot_retention_period(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.inner = self.inner.set_manual_snapshot_retention_period(input);
            self
        }
        /// <p>The port number on which the cluster accepts incoming connections.</p>
        /// <p>The cluster is accessible only via the JDBC and ODBC connection strings. Part of
        /// the connection string requires the port on which the cluster will listen for incoming
        /// connections.</p>
        /// <p>Default: <code>5439</code>
        /// </p>
        /// <p>Valid Values: <code>1150-65535</code>
        /// </p>
        pub fn port(mut self, inp: i32) -> Self {
            self.inner = self.inner.port(inp);
            self
        }
        /// <p>The port number on which the cluster accepts incoming connections.</p>
        /// <p>The cluster is accessible only via the JDBC and ODBC connection strings. Part of
        /// the connection string requires the port on which the cluster will listen for incoming
        /// connections.</p>
        /// <p>Default: <code>5439</code>
        /// </p>
        /// <p>Valid Values: <code>1150-65535</code>
        /// </p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_port(input);
            self
        }
        /// <p>The version of the Amazon Redshift engine software that you want to deploy on the
        /// cluster.</p>
        /// <p>The version selected runs on all the nodes in the cluster.</p>
        /// <p>Constraints: Only version 1.0 is currently available.</p>
        /// <p>Example: <code>1.0</code>
        /// </p>
        pub fn cluster_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_version(inp);
            self
        }
        /// <p>The version of the Amazon Redshift engine software that you want to deploy on the
        /// cluster.</p>
        /// <p>The version selected runs on all the nodes in the cluster.</p>
        /// <p>Constraints: Only version 1.0 is currently available.</p>
        /// <p>Example: <code>1.0</code>
        /// </p>
        pub fn set_cluster_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_version(input);
            self
        }
        /// <p>If <code>true</code>, major version upgrades can be applied during the maintenance
        /// window to the Amazon Redshift engine that is running on the cluster.</p>
        /// <p>When a new major version of the Amazon Redshift engine is released, you can request that
        /// the service automatically apply upgrades during the maintenance window to the Amazon Redshift
        /// engine that is running on your cluster.</p>
        /// <p>Default: <code>true</code>
        /// </p>
        pub fn allow_version_upgrade(mut self, inp: bool) -> Self {
            self.inner = self.inner.allow_version_upgrade(inp);
            self
        }
        /// <p>If <code>true</code>, major version upgrades can be applied during the maintenance
        /// window to the Amazon Redshift engine that is running on the cluster.</p>
        /// <p>When a new major version of the Amazon Redshift engine is released, you can request that
        /// the service automatically apply upgrades during the maintenance window to the Amazon Redshift
        /// engine that is running on your cluster.</p>
        /// <p>Default: <code>true</code>
        /// </p>
        pub fn set_allow_version_upgrade(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_allow_version_upgrade(input);
            self
        }
        /// <p>The number of compute nodes in the cluster. This parameter is required when the
        /// <b>ClusterType</b> parameter is specified as
        /// <code>multi-node</code>. </p>
        /// <p>For information about determining how many nodes you need, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#how-many-nodes"> Working with
        /// Clusters</a> in the <i>Amazon Redshift Cluster Management Guide</i>. </p>
        /// <p>If you don't specify this parameter, you get a single-node cluster. When requesting
        /// a multi-node cluster, you must specify the number of nodes that you want in the
        /// cluster.</p>
        /// <p>Default: <code>1</code>
        /// </p>
        /// <p>Constraints: Value must be at least 1 and no more than 100.</p>
        pub fn number_of_nodes(mut self, inp: i32) -> Self {
            self.inner = self.inner.number_of_nodes(inp);
            self
        }
        /// <p>The number of compute nodes in the cluster. This parameter is required when the
        /// <b>ClusterType</b> parameter is specified as
        /// <code>multi-node</code>. </p>
        /// <p>For information about determining how many nodes you need, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#how-many-nodes"> Working with
        /// Clusters</a> in the <i>Amazon Redshift Cluster Management Guide</i>. </p>
        /// <p>If you don't specify this parameter, you get a single-node cluster. When requesting
        /// a multi-node cluster, you must specify the number of nodes that you want in the
        /// cluster.</p>
        /// <p>Default: <code>1</code>
        /// </p>
        /// <p>Constraints: Value must be at least 1 and no more than 100.</p>
        pub fn set_number_of_nodes(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_number_of_nodes(input);
            self
        }
        /// <p>If <code>true</code>, the cluster can be accessed from a public network. </p>
        pub fn publicly_accessible(mut self, inp: bool) -> Self {
            self.inner = self.inner.publicly_accessible(inp);
            self
        }
        /// <p>If <code>true</code>, the cluster can be accessed from a public network. </p>
        pub fn set_publicly_accessible(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_publicly_accessible(input);
            self
        }
        /// <p>If <code>true</code>, the data in the cluster is encrypted at rest. </p>
        /// <p>Default: false</p>
        pub fn encrypted(mut self, inp: bool) -> Self {
            self.inner = self.inner.encrypted(inp);
            self
        }
        /// <p>If <code>true</code>, the data in the cluster is encrypted at rest. </p>
        /// <p>Default: false</p>
        pub fn set_encrypted(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_encrypted(input);
            self
        }
        /// <p>Specifies the name of the HSM client certificate the Amazon Redshift cluster uses to
        /// retrieve the data encryption keys stored in an HSM.</p>
        pub fn hsm_client_certificate_identifier(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.hsm_client_certificate_identifier(inp);
            self
        }
        /// <p>Specifies the name of the HSM client certificate the Amazon Redshift cluster uses to
        /// retrieve the data encryption keys stored in an HSM.</p>
        pub fn set_hsm_client_certificate_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_hsm_client_certificate_identifier(input);
            self
        }
        /// <p>Specifies the name of the HSM configuration that contains the information the
        /// Amazon Redshift cluster can use to retrieve and store keys in an HSM.</p>
        pub fn hsm_configuration_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hsm_configuration_identifier(inp);
            self
        }
        /// <p>Specifies the name of the HSM configuration that contains the information the
        /// Amazon Redshift cluster can use to retrieve and store keys in an HSM.</p>
        pub fn set_hsm_configuration_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_hsm_configuration_identifier(input);
            self
        }
        /// <p>The Elastic IP (EIP) address for the cluster.</p>
        /// <p>Constraints: The cluster must be provisioned in EC2-VPC and publicly-accessible
        /// through an Internet gateway. For more information about provisioning clusters in
        /// EC2-VPC, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#cluster-platforms">Supported
        /// Platforms to Launch Your Cluster</a> in the Amazon Redshift Cluster Management Guide.</p>
        pub fn elastic_ip(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.elastic_ip(inp);
            self
        }
        /// <p>The Elastic IP (EIP) address for the cluster.</p>
        /// <p>Constraints: The cluster must be provisioned in EC2-VPC and publicly-accessible
        /// through an Internet gateway. For more information about provisioning clusters in
        /// EC2-VPC, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#cluster-platforms">Supported
        /// Platforms to Launch Your Cluster</a> in the Amazon Redshift Cluster Management Guide.</p>
        pub fn set_elastic_ip(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_elastic_ip(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tag instances.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>A list of tag instances.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The Key Management Service (KMS) key ID of the encryption key that you want to
        /// use to encrypt data in the cluster.</p>
        pub fn kms_key_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key_id(inp);
            self
        }
        /// <p>The Key Management Service (KMS) key ID of the encryption key that you want to
        /// use to encrypt data in the cluster.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key_id(input);
            self
        }
        /// <p>An option that specifies whether to create the cluster with enhanced VPC routing
        /// enabled. To create a cluster that uses enhanced VPC routing, the cluster must be in a
        /// VPC. For more information, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html">Enhanced VPC Routing</a> in
        /// the Amazon Redshift Cluster Management Guide.</p>
        /// <p>If this option is <code>true</code>, enhanced VPC routing is enabled. </p>
        /// <p>Default: false</p>
        pub fn enhanced_vpc_routing(mut self, inp: bool) -> Self {
            self.inner = self.inner.enhanced_vpc_routing(inp);
            self
        }
        /// <p>An option that specifies whether to create the cluster with enhanced VPC routing
        /// enabled. To create a cluster that uses enhanced VPC routing, the cluster must be in a
        /// VPC. For more information, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html">Enhanced VPC Routing</a> in
        /// the Amazon Redshift Cluster Management Guide.</p>
        /// <p>If this option is <code>true</code>, enhanced VPC routing is enabled. </p>
        /// <p>Default: false</p>
        pub fn set_enhanced_vpc_routing(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enhanced_vpc_routing(input);
            self
        }
        /// <p>Reserved.</p>
        pub fn additional_info(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.additional_info(inp);
            self
        }
        /// <p>Reserved.</p>
        pub fn set_additional_info(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_additional_info(input);
            self
        }
        /// Appends an item to `IamRoles`.
        ///
        /// To override the contents of this collection use [`set_iam_roles`](Self::set_iam_roles).
        ///
        /// <p>A list of Identity and Access Management (IAM) roles that can be used by the
        /// cluster to access other Amazon Web Services services. You must supply the IAM roles in their Amazon
        /// Resource Name (ARN) format. You can supply up to 10 IAM roles in a single
        /// request.</p>
        /// <p>A cluster can have up to 10 IAM roles associated with it at any time.</p>
        pub fn iam_roles(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.iam_roles(inp);
            self
        }
        /// <p>A list of Identity and Access Management (IAM) roles that can be used by the
        /// cluster to access other Amazon Web Services services. You must supply the IAM roles in their Amazon
        /// Resource Name (ARN) format. You can supply up to 10 IAM roles in a single
        /// request.</p>
        /// <p>A cluster can have up to 10 IAM roles associated with it at any time.</p>
        pub fn set_iam_roles(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_iam_roles(input);
            self
        }
        /// <p>An optional parameter for the name of the maintenance track for the cluster. If you
        /// don't provide a maintenance track name, the cluster is assigned to the
        /// <code>current</code> track.</p>
        pub fn maintenance_track_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.maintenance_track_name(inp);
            self
        }
        /// <p>An optional parameter for the name of the maintenance track for the cluster. If you
        /// don't provide a maintenance track name, the cluster is assigned to the
        /// <code>current</code> track.</p>
        pub fn set_maintenance_track_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_maintenance_track_name(input);
            self
        }
        /// <p>A unique identifier for the snapshot schedule.</p>
        pub fn snapshot_schedule_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.snapshot_schedule_identifier(inp);
            self
        }
        /// <p>A unique identifier for the snapshot schedule.</p>
        pub fn set_snapshot_schedule_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_snapshot_schedule_identifier(input);
            self
        }
        /// <p>The option to enable relocation for an Amazon Redshift cluster between Availability Zones after the cluster is created.</p>
        pub fn availability_zone_relocation(mut self, inp: bool) -> Self {
            self.inner = self.inner.availability_zone_relocation(inp);
            self
        }
        /// <p>The option to enable relocation for an Amazon Redshift cluster between Availability Zones after the cluster is created.</p>
        pub fn set_availability_zone_relocation(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_availability_zone_relocation(input);
            self
        }
        /// <p>The value represents how the cluster is configured to use AQUA (Advanced Query Accelerator) when it is created. Possible values include the following.</p>
        /// <ul>
        /// <li>
        /// <p>enabled - Use AQUA if it is available for the current Amazon Web Services Region and Amazon Redshift node type.</p>
        /// </li>
        /// <li>
        /// <p>disabled - Don't use AQUA. </p>
        /// </li>
        /// <li>
        /// <p>auto - Amazon Redshift determines whether to use AQUA.</p>
        /// </li>
        /// </ul>
        pub fn aqua_configuration_status(
            mut self,
            inp: crate::model::AquaConfigurationStatus,
        ) -> Self {
            self.inner = self.inner.aqua_configuration_status(inp);
            self
        }
        /// <p>The value represents how the cluster is configured to use AQUA (Advanced Query Accelerator) when it is created. Possible values include the following.</p>
        /// <ul>
        /// <li>
        /// <p>enabled - Use AQUA if it is available for the current Amazon Web Services Region and Amazon Redshift node type.</p>
        /// </li>
        /// <li>
        /// <p>disabled - Don't use AQUA. </p>
        /// </li>
        /// <li>
        /// <p>auto - Amazon Redshift determines whether to use AQUA.</p>
        /// </li>
        /// </ul>
        pub fn set_aqua_configuration_status(
            mut self,
            input: std::option::Option<crate::model::AquaConfigurationStatus>,
        ) -> Self {
            self.inner = self.inner.set_aqua_configuration_status(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateClusterParameterGroup`.
    ///
    /// <p>Creates an Amazon Redshift parameter group.</p>
    /// <p>Creating parameter groups is independent of creating clusters. You can associate a
    /// cluster with a parameter group when you create the cluster. You can also associate an
    /// existing cluster with a parameter group after the cluster is created by using <a>ModifyCluster</a>. </p>
    /// <p>Parameters in the parameter group define specific behavior that applies to the
    /// databases you create on the cluster.
    /// For more information about parameters and parameter groups, go to
    /// <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Amazon Redshift Parameter Groups</a>
    /// in the <i>Amazon Redshift Cluster Management Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateClusterParameterGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_cluster_parameter_group_input::Builder,
    }
    impl<C, M, R> CreateClusterParameterGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateClusterParameterGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateClusterParameterGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateClusterParameterGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateClusterParameterGroupInputOperationOutputAlias,
                crate::output::CreateClusterParameterGroupOutput,
                crate::error::CreateClusterParameterGroupError,
                crate::input::CreateClusterParameterGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the cluster parameter group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be 1 to 255 alphanumeric characters or hyphens</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// <li>
        /// <p>Must be unique withing your Amazon Web Services account.</p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>This value is stored as a lower-case string.</p>
        /// </note>
        pub fn parameter_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.parameter_group_name(inp);
            self
        }
        /// <p>The name of the cluster parameter group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be 1 to 255 alphanumeric characters or hyphens</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// <li>
        /// <p>Must be unique withing your Amazon Web Services account.</p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>This value is stored as a lower-case string.</p>
        /// </note>
        pub fn set_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_parameter_group_name(input);
            self
        }
        /// <p>The Amazon Redshift engine version to which the cluster parameter group applies. The
        /// cluster engine version determines the set of parameters.</p>
        /// <p>To get a list of valid parameter group family names, you can call <a>DescribeClusterParameterGroups</a>. By default, Amazon Redshift returns a list of
        /// all the parameter groups that are owned by your Amazon Web Services account, including the default
        /// parameter groups for each Amazon Redshift engine version. The parameter group family names
        /// associated with the default parameter groups provide you the valid values. For example,
        /// a valid family name is "redshift-1.0". </p>
        pub fn parameter_group_family(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.parameter_group_family(inp);
            self
        }
        /// <p>The Amazon Redshift engine version to which the cluster parameter group applies. The
        /// cluster engine version determines the set of parameters.</p>
        /// <p>To get a list of valid parameter group family names, you can call <a>DescribeClusterParameterGroups</a>. By default, Amazon Redshift returns a list of
        /// all the parameter groups that are owned by your Amazon Web Services account, including the default
        /// parameter groups for each Amazon Redshift engine version. The parameter group family names
        /// associated with the default parameter groups provide you the valid values. For example,
        /// a valid family name is "redshift-1.0". </p>
        pub fn set_parameter_group_family(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_parameter_group_family(input);
            self
        }
        /// <p>A description of the parameter group.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>A description of the parameter group.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tag instances.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>A list of tag instances.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateClusterSecurityGroup`.
    ///
    /// <p>Creates a new Amazon Redshift security group. You use security groups to control access
    /// to non-VPC clusters.</p>
    /// <p>
    /// For information about managing security groups, go to
    /// <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-security-groups.html">Amazon Redshift Cluster Security Groups</a> in the
    /// <i>Amazon Redshift Cluster Management Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateClusterSecurityGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_cluster_security_group_input::Builder,
    }
    impl<C, M, R> CreateClusterSecurityGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateClusterSecurityGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateClusterSecurityGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateClusterSecurityGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateClusterSecurityGroupInputOperationOutputAlias,
                crate::output::CreateClusterSecurityGroupOutput,
                crate::error::CreateClusterSecurityGroupError,
                crate::input::CreateClusterSecurityGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name for the security group. Amazon Redshift stores the value as a lowercase
        /// string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain no more than 255 alphanumeric characters or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>Must not be "Default".</p>
        /// </li>
        /// <li>
        /// <p>Must be unique for all security groups that are created by your Amazon Web Services account.</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>examplesecuritygroup</code>
        /// </p>
        pub fn cluster_security_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_security_group_name(inp);
            self
        }
        /// <p>The name for the security group. Amazon Redshift stores the value as a lowercase
        /// string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain no more than 255 alphanumeric characters or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>Must not be "Default".</p>
        /// </li>
        /// <li>
        /// <p>Must be unique for all security groups that are created by your Amazon Web Services account.</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>examplesecuritygroup</code>
        /// </p>
        pub fn set_cluster_security_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_security_group_name(input);
            self
        }
        /// <p>A description for the security group.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>A description for the security group.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tag instances.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>A list of tag instances.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateClusterSnapshot`.
    ///
    /// <p>Creates a manual snapshot of the specified cluster. The cluster must be in the
    /// <code>available</code> state. </p>
    /// <p>
    /// For more information about working with snapshots, go to
    /// <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-snapshots.html">Amazon Redshift Snapshots</a>
    /// in the <i>Amazon Redshift Cluster Management Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateClusterSnapshot<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_cluster_snapshot_input::Builder,
    }
    impl<C, M, R> CreateClusterSnapshot<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateClusterSnapshot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateClusterSnapshotOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateClusterSnapshotError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateClusterSnapshotInputOperationOutputAlias,
                crate::output::CreateClusterSnapshotOutput,
                crate::error::CreateClusterSnapshotError,
                crate::input::CreateClusterSnapshotInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique identifier for the snapshot that you are requesting. This identifier must
        /// be unique for all snapshots within the Amazon Web Services account.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Cannot be null, empty, or blank</p>
        /// </li>
        /// <li>
        /// <p>Must contain from 1 to 255 alphanumeric characters or hyphens</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>my-snapshot-id</code>
        /// </p>
        pub fn snapshot_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.snapshot_identifier(inp);
            self
        }
        /// <p>A unique identifier for the snapshot that you are requesting. This identifier must
        /// be unique for all snapshots within the Amazon Web Services account.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Cannot be null, empty, or blank</p>
        /// </li>
        /// <li>
        /// <p>Must contain from 1 to 255 alphanumeric characters or hyphens</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>my-snapshot-id</code>
        /// </p>
        pub fn set_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_snapshot_identifier(input);
            self
        }
        /// <p>The cluster identifier for which you want a snapshot.</p>
        pub fn cluster_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_identifier(inp);
            self
        }
        /// <p>The cluster identifier for which you want a snapshot.</p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_identifier(input);
            self
        }
        /// <p>The number of days that a manual snapshot is retained. If the value is -1, the manual
        /// snapshot is retained indefinitely. </p>
        ///
        /// <p>The value must be either -1 or an integer between 1 and 3,653.</p>
        ///
        /// <p>The default value is -1.</p>
        pub fn manual_snapshot_retention_period(mut self, inp: i32) -> Self {
            self.inner = self.inner.manual_snapshot_retention_period(inp);
            self
        }
        /// <p>The number of days that a manual snapshot is retained. If the value is -1, the manual
        /// snapshot is retained indefinitely. </p>
        ///
        /// <p>The value must be either -1 or an integer between 1 and 3,653.</p>
        ///
        /// <p>The default value is -1.</p>
        pub fn set_manual_snapshot_retention_period(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.inner = self.inner.set_manual_snapshot_retention_period(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tag instances.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>A list of tag instances.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateClusterSubnetGroup`.
    ///
    /// <p>Creates a new Amazon Redshift subnet group. You must provide a list of one or more
    /// subnets in your existing Amazon Virtual Private Cloud (Amazon VPC) when creating
    /// Amazon Redshift subnet group.</p>
    /// <p>
    /// For information about subnet groups, go to
    /// <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-cluster-subnet-groups.html">Amazon Redshift Cluster Subnet Groups</a> in the
    /// <i>Amazon Redshift Cluster Management Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateClusterSubnetGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_cluster_subnet_group_input::Builder,
    }
    impl<C, M, R> CreateClusterSubnetGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateClusterSubnetGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateClusterSubnetGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateClusterSubnetGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateClusterSubnetGroupInputOperationOutputAlias,
                crate::output::CreateClusterSubnetGroupOutput,
                crate::error::CreateClusterSubnetGroupError,
                crate::input::CreateClusterSubnetGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name for the subnet group. Amazon Redshift stores the value as a lowercase
        /// string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain no more than 255 alphanumeric characters or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>Must not be "Default".</p>
        /// </li>
        /// <li>
        /// <p>Must be unique for all subnet groups that are created by your Amazon Web Services account.</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>examplesubnetgroup</code>
        /// </p>
        pub fn cluster_subnet_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_subnet_group_name(inp);
            self
        }
        /// <p>The name for the subnet group. Amazon Redshift stores the value as a lowercase
        /// string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain no more than 255 alphanumeric characters or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>Must not be "Default".</p>
        /// </li>
        /// <li>
        /// <p>Must be unique for all subnet groups that are created by your Amazon Web Services account.</p>
        /// </li>
        /// </ul>
        /// <p>Example: <code>examplesubnetgroup</code>
        /// </p>
        pub fn set_cluster_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_subnet_group_name(input);
            self
        }
        /// <p>A description for the subnet group.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>A description for the subnet group.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `SubnetIds`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// <p>An array of VPC subnet IDs. A maximum of 20 subnets can be modified in a single
        /// request.</p>
        pub fn subnet_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subnet_ids(inp);
            self
        }
        /// <p>An array of VPC subnet IDs. A maximum of 20 subnets can be modified in a single
        /// request.</p>
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_subnet_ids(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tag instances.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>A list of tag instances.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateEndpointAccess`.
    ///
    /// <p>Creates a Redshift-managed VPC endpoint.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateEndpointAccess<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_endpoint_access_input::Builder,
    }
    impl<C, M, R> CreateEndpointAccess<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateEndpointAccess`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateEndpointAccessOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateEndpointAccessError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateEndpointAccessInputOperationOutputAlias,
                crate::output::CreateEndpointAccessOutput,
                crate::error::CreateEndpointAccessError,
                crate::input::CreateEndpointAccessInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The cluster identifier of the cluster to access.</p>
        pub fn cluster_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_identifier(inp);
            self
        }
        /// <p>The cluster identifier of the cluster to access.</p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_identifier(input);
            self
        }
        /// <p>The Amazon Web Services account ID of the owner of the cluster. This is only required if the cluster is in another Amazon Web Services account.</p>
        pub fn resource_owner(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_owner(inp);
            self
        }
        /// <p>The Amazon Web Services account ID of the owner of the cluster. This is only required if the cluster is in another Amazon Web Services account.</p>
        pub fn set_resource_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_owner(input);
            self
        }
        /// <p>The Redshift-managed VPC endpoint name.</p>
        /// <p>An endpoint name must contain 1-30 characters.
        /// Valid characters are A-Z, a-z, 0-9, and hyphen(-).
        /// The first character must be a letter.
        /// The name can't contain two consecutive hyphens or end with a hyphen.</p>
        pub fn endpoint_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.endpoint_name(inp);
            self
        }
        /// <p>The Redshift-managed VPC endpoint name.</p>
        /// <p>An endpoint name must contain 1-30 characters.
        /// Valid characters are A-Z, a-z, 0-9, and hyphen(-).
        /// The first character must be a letter.
        /// The name can't contain two consecutive hyphens or end with a hyphen.</p>
        pub fn set_endpoint_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_endpoint_name(input);
            self
        }
        /// <p>The subnet group from which Amazon Redshift chooses the subnet to deploy the endpoint.</p>
        pub fn subnet_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subnet_group_name(inp);
            self
        }
        /// <p>The subnet group from which Amazon Redshift chooses the subnet to deploy the endpoint.</p>
        pub fn set_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_subnet_group_name(input);
            self
        }
        /// Appends an item to `VpcSecurityGroupIds`.
        ///
        /// To override the contents of this collection use [`set_vpc_security_group_ids`](Self::set_vpc_security_group_ids).
        ///
        /// <p>The security group that defines the ports, protocols, and sources for inbound traffic that you are authorizing into your endpoint.</p>
        pub fn vpc_security_group_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc_security_group_ids(inp);
            self
        }
        /// <p>The security group that defines the ports, protocols, and sources for inbound traffic that you are authorizing into your endpoint.</p>
        pub fn set_vpc_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_vpc_security_group_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateEventSubscription`.
    ///
    /// <p>Creates an Amazon Redshift event notification subscription. This action requires an ARN
    /// (Amazon Resource Name) of an Amazon SNS topic created by either the Amazon Redshift console,
    /// the Amazon SNS console, or the Amazon SNS API. To obtain an ARN with Amazon SNS, you
    /// must create a topic in Amazon SNS and subscribe to the topic. The ARN is displayed in
    /// the SNS console.</p>
    /// <p>You can specify the source type, and lists of Amazon Redshift source IDs, event
    /// categories, and event severities. Notifications will be sent for all events you want
    /// that match those criteria. For example, you can specify source type = cluster, source ID
    /// = my-cluster-1 and mycluster2, event categories = Availability, Backup, and severity =
    /// ERROR. The subscription will only send notifications for those ERROR events in the
    /// Availability and Backup categories for the specified clusters.</p>
    /// <p>If you specify both the source type and source IDs, such as source type = cluster
    /// and source identifier = my-cluster-1, notifications will be sent for all the cluster
    /// events for my-cluster-1. If you specify a source type but do not specify a source
    /// identifier, you will receive notice of the events for the objects of that type in your
    /// Amazon Web Services account. If you do not specify either the SourceType nor the SourceIdentifier, you
    /// will be notified of events generated from all Amazon Redshift sources belonging to your Amazon Web Services account. You must specify a source type if you specify a source ID.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateEventSubscription<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_event_subscription_input::Builder,
    }
    impl<C, M, R> CreateEventSubscription<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateEventSubscription`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateEventSubscriptionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateEventSubscriptionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateEventSubscriptionInputOperationOutputAlias,
                crate::output::CreateEventSubscriptionOutput,
                crate::error::CreateEventSubscriptionError,
                crate::input::CreateEventSubscriptionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the event subscription to be created.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Cannot be null, empty, or blank.</p>
        /// </li>
        /// <li>
        /// <p>Must contain from 1 to 255 alphanumeric characters or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// </ul>
        pub fn subscription_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subscription_name(inp);
            self
        }
        /// <p>The name of the event subscription to be created.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Cannot be null, empty, or blank.</p>
        /// </li>
        /// <li>
        /// <p>Must contain from 1 to 255 alphanumeric characters or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// </ul>
        pub fn set_subscription_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_subscription_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon SNS topic used to transmit the event
        /// notifications. The ARN is created by Amazon SNS when you create a topic and subscribe to
        /// it.</p>
        pub fn sns_topic_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sns_topic_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon SNS topic used to transmit the event
        /// notifications. The ARN is created by Amazon SNS when you create a topic and subscribe to
        /// it.</p>
        pub fn set_sns_topic_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_sns_topic_arn(input);
            self
        }
        /// <p>The type of source that will be generating the events. For example, if you want to
        /// be notified of events generated by a cluster, you would set this parameter to cluster.
        /// If this value is not specified, events are returned for all Amazon Redshift objects in your
        /// Amazon Web Services account. You must specify a source type in order to specify source IDs.</p>
        /// <p>Valid values: cluster, cluster-parameter-group, cluster-security-group, cluster-snapshot, and scheduled-action.</p>
        pub fn source_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_type(inp);
            self
        }
        /// <p>The type of source that will be generating the events. For example, if you want to
        /// be notified of events generated by a cluster, you would set this parameter to cluster.
        /// If this value is not specified, events are returned for all Amazon Redshift objects in your
        /// Amazon Web Services account. You must specify a source type in order to specify source IDs.</p>
        /// <p>Valid values: cluster, cluster-parameter-group, cluster-security-group, cluster-snapshot, and scheduled-action.</p>
        pub fn set_source_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_source_type(input);
            self
        }
        /// Appends an item to `SourceIds`.
        ///
        /// To override the contents of this collection use [`set_source_ids`](Self::set_source_ids).
        ///
        /// <p>A list of one or more identifiers of Amazon Redshift source objects. All of the objects
        /// must be of the same type as was specified in the source type parameter. The event
        /// subscription will return only events generated by the specified objects. If not
        /// specified, then events are returned for all objects within the source type
        /// specified.</p>
        /// <p>Example: my-cluster-1, my-cluster-2</p>
        /// <p>Example: my-snapshot-20131010</p>
        pub fn source_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_ids(inp);
            self
        }
        /// <p>A list of one or more identifiers of Amazon Redshift source objects. All of the objects
        /// must be of the same type as was specified in the source type parameter. The event
        /// subscription will return only events generated by the specified objects. If not
        /// specified, then events are returned for all objects within the source type
        /// specified.</p>
        /// <p>Example: my-cluster-1, my-cluster-2</p>
        /// <p>Example: my-snapshot-20131010</p>
        pub fn set_source_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_source_ids(input);
            self
        }
        /// Appends an item to `EventCategories`.
        ///
        /// To override the contents of this collection use [`set_event_categories`](Self::set_event_categories).
        ///
        /// <p>Specifies the Amazon Redshift event categories to be published by the event notification
        /// subscription.</p>
        /// <p>Values: configuration, management, monitoring, security, pending</p>
        pub fn event_categories(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_categories(inp);
            self
        }
        /// <p>Specifies the Amazon Redshift event categories to be published by the event notification
        /// subscription.</p>
        /// <p>Values: configuration, management, monitoring, security, pending</p>
        pub fn set_event_categories(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_event_categories(input);
            self
        }
        /// <p>Specifies the Amazon Redshift event severity to be published by the event notification
        /// subscription.</p>
        /// <p>Values: ERROR, INFO</p>
        pub fn severity(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.severity(inp);
            self
        }
        /// <p>Specifies the Amazon Redshift event severity to be published by the event notification
        /// subscription.</p>
        /// <p>Values: ERROR, INFO</p>
        pub fn set_severity(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_severity(input);
            self
        }
        /// <p>A boolean value; set to <code>true</code> to activate the subscription, and set to
        /// <code>false</code> to create the subscription but not activate it. </p>
        pub fn enabled(mut self, inp: bool) -> Self {
            self.inner = self.inner.enabled(inp);
            self
        }
        /// <p>A boolean value; set to <code>true</code> to activate the subscription, and set to
        /// <code>false</code> to create the subscription but not activate it. </p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enabled(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tag instances.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>A list of tag instances.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateHsmClientCertificate`.
    ///
    /// <p>Creates an HSM client certificate that an Amazon Redshift cluster will use to connect to
    /// the client's HSM in order to store and retrieve the keys used to encrypt the cluster
    /// databases.</p>
    /// <p>The command returns a public key, which you must store in the HSM. In addition to
    /// creating the HSM certificate, you must create an Amazon Redshift HSM configuration that
    /// provides a cluster the information needed to store and use encryption keys in the HSM.
    /// For more information, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-db-encryption.html#working-with-HSM">Hardware Security Modules</a>
    /// in the <i>Amazon Redshift Cluster Management Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateHsmClientCertificate<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_hsm_client_certificate_input::Builder,
    }
    impl<C, M, R> CreateHsmClientCertificate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateHsmClientCertificate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateHsmClientCertificateOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateHsmClientCertificateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateHsmClientCertificateInputOperationOutputAlias,
                crate::output::CreateHsmClientCertificateOutput,
                crate::error::CreateHsmClientCertificateError,
                crate::input::CreateHsmClientCertificateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier to be assigned to the new HSM client certificate that the cluster
        /// will use to connect to the HSM to use the database encryption keys.</p>
        pub fn hsm_client_certificate_identifier(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.hsm_client_certificate_identifier(inp);
            self
        }
        /// <p>The identifier to be assigned to the new HSM client certificate that the cluster
        /// will use to connect to the HSM to use the database encryption keys.</p>
        pub fn set_hsm_client_certificate_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_hsm_client_certificate_identifier(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tag instances.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>A list of tag instances.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateHsmConfiguration`.
    ///
    /// <p>Creates an HSM configuration that contains the information required by an Amazon Redshift
    /// cluster to store and use database encryption keys in a Hardware Security Module (HSM).
    /// After creating the HSM configuration, you can specify it as a parameter when creating a
    /// cluster. The cluster will then store its encryption keys in the HSM.</p>
    /// <p>In addition to creating an HSM configuration, you must also create an HSM client
    /// certificate. For more information, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-HSM.html">Hardware Security Modules</a>
    /// in the Amazon Redshift Cluster Management Guide.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateHsmConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_hsm_configuration_input::Builder,
    }
    impl<C, M, R> CreateHsmConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateHsmConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateHsmConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateHsmConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateHsmConfigurationInputOperationOutputAlias,
                crate::output::CreateHsmConfigurationOutput,
                crate::error::CreateHsmConfigurationError,
                crate::input::CreateHsmConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier to be assigned to the new Amazon Redshift HSM configuration.</p>
        pub fn hsm_configuration_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hsm_configuration_identifier(inp);
            self
        }
        /// <p>The identifier to be assigned to the new Amazon Redshift HSM configuration.</p>
        pub fn set_hsm_configuration_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_hsm_configuration_identifier(input);
            self
        }
        /// <p>A text description of the HSM configuration to be created.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>A text description of the HSM configuration to be created.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The IP address that the Amazon Redshift cluster must use to access the HSM.</p>
        pub fn hsm_ip_address(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hsm_ip_address(inp);
            self
        }
        /// <p>The IP address that the Amazon Redshift cluster must use to access the HSM.</p>
        pub fn set_hsm_ip_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_hsm_ip_address(input);
            self
        }
        /// <p>The name of the partition in the HSM where the Amazon Redshift clusters will store their
        /// database encryption keys.</p>
        pub fn hsm_partition_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hsm_partition_name(inp);
            self
        }
        /// <p>The name of the partition in the HSM where the Amazon Redshift clusters will store their
        /// database encryption keys.</p>
        pub fn set_hsm_partition_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_hsm_partition_name(input);
            self
        }
        /// <p>The password required to access the HSM partition.</p>
        pub fn hsm_partition_password(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hsm_partition_password(inp);
            self
        }
        /// <p>The password required to access the HSM partition.</p>
        pub fn set_hsm_partition_password(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_hsm_partition_password(input);
            self
        }
        /// <p>The HSMs public certificate file. When using Cloud HSM, the file name is
        /// server.pem.</p>
        pub fn hsm_server_public_certificate(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.hsm_server_public_certificate(inp);
            self
        }
        /// <p>The HSMs public certificate file. When using Cloud HSM, the file name is
        /// server.pem.</p>
        pub fn set_hsm_server_public_certificate(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_hsm_server_public_certificate(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tag instances.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>A list of tag instances.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateScheduledAction`.
    ///
    /// <p>Creates a scheduled action. A scheduled action contains a schedule and an Amazon Redshift API action.
    /// For example, you can create a schedule of when to run the <code>ResizeCluster</code> API operation.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct CreateScheduledAction<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_scheduled_action_input::Builder,
    }
    impl<C, M, R> CreateScheduledAction<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateScheduledAction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateScheduledActionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateScheduledActionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateScheduledActionInputOperationOutputAlias,
                crate::output::CreateScheduledActionOutput,
                crate::error::CreateScheduledActionError,
                crate::input::CreateScheduledActionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the scheduled action. The name must be unique within an account.
        /// For more information about this parameter, see <a>ScheduledAction</a>. </p>
        pub fn scheduled_action_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.scheduled_action_name(inp);
            self
        }
        /// <p>The name of the scheduled action. The name must be unique within an account.
        /// For more information about this parameter, see <a>ScheduledAction</a>. </p>
        pub fn set_scheduled_action_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_scheduled_action_name(input);
            self
        }
        /// <p>A JSON format string of the Amazon Redshift API operation with input parameters.
        /// For more information about this parameter, see <a>ScheduledAction</a>. </p>
        pub fn target_action(mut self, inp: crate::model::ScheduledActionType) -> Self {
            self.inner = self.inner.target_action(inp);
            self
        }
        /// <p>A JSON format string of the Amazon Redshift API operation with input parameters.
        /// For more information about this parameter, see <a>ScheduledAction</a>. </p>
        pub fn set_target_action(
            mut self,
            input: std::option::Option<crate::model::ScheduledActionType>,
        ) -> Self {
            self.inner = self.inner.set_target_action(input);
            self
        }
        /// <p>The schedule in <code>at( )</code> or <code>cron( )</code> format.
        /// For more information about this parameter, see <a>ScheduledAction</a>.</p>
        pub fn schedule(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schedule(inp);
            self
        }
        /// <p>The schedule in <code>at( )</code> or <code>cron( )</code> format.
        /// For more information about this parameter, see <a>ScheduledAction</a>.</p>
        pub fn set_schedule(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_schedule(input);
            self
        }
        /// <p>The IAM role to assume to run the target action.
        /// For more information about this parameter, see <a>ScheduledAction</a>. </p>
        pub fn iam_role(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.iam_role(inp);
            self
        }
        /// <p>The IAM role to assume to run the target action.
        /// For more information about this parameter, see <a>ScheduledAction</a>. </p>
        pub fn set_iam_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_iam_role(input);
            self
        }
        /// <p>The description of the scheduled action.
        /// </p>
        pub fn scheduled_action_description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.scheduled_action_description(inp);
            self
        }
        /// <p>The description of the scheduled action.
        /// </p>
        pub fn set_scheduled_action_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_scheduled_action_description(input);
            self
        }
        /// <p>The start time in UTC of the scheduled action.
        /// Before this time, the scheduled action does not trigger.
        /// For more information about this parameter, see <a>ScheduledAction</a>.</p>
        pub fn start_time(mut self, inp: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.start_time(inp);
            self
        }
        /// <p>The start time in UTC of the scheduled action.
        /// Before this time, the scheduled action does not trigger.
        /// For more information about this parameter, see <a>ScheduledAction</a>.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_start_time(input);
            self
        }
        /// <p>The end time in UTC of the scheduled action. After this time, the scheduled action does not trigger.
        /// For more information about this parameter, see <a>ScheduledAction</a>. </p>
        pub fn end_time(mut self, inp: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.end_time(inp);
            self
        }
        /// <p>The end time in UTC of the scheduled action. After this time, the scheduled action does not trigger.
        /// For more information about this parameter, see <a>ScheduledAction</a>. </p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_end_time(input);
            self
        }
        /// <p>If true, the schedule is enabled. If false, the scheduled action does not trigger.
        /// For more information about <code>state</code> of the scheduled action, see <a>ScheduledAction</a>. </p>
        pub fn enable(mut self, inp: bool) -> Self {
            self.inner = self.inner.enable(inp);
            self
        }
        /// <p>If true, the schedule is enabled. If false, the scheduled action does not trigger.
        /// For more information about <code>state</code> of the scheduled action, see <a>ScheduledAction</a>. </p>
        pub fn set_enable(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enable(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateSnapshotCopyGrant`.
    ///
    /// <p>Creates a snapshot copy grant that permits Amazon Redshift to use a customer master key
    /// (CMK) from Key Management Service (KMS) to encrypt copied snapshots in a
    /// destination region.</p>
    /// <p>
    /// For more information about managing snapshot copy grants, go to
    /// <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-db-encryption.html">Amazon Redshift Database Encryption</a>
    /// in the <i>Amazon Redshift Cluster Management Guide</i>.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct CreateSnapshotCopyGrant<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_snapshot_copy_grant_input::Builder,
    }
    impl<C, M, R> CreateSnapshotCopyGrant<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateSnapshotCopyGrant`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateSnapshotCopyGrantOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateSnapshotCopyGrantError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateSnapshotCopyGrantInputOperationOutputAlias,
                crate::output::CreateSnapshotCopyGrantOutput,
                crate::error::CreateSnapshotCopyGrantError,
                crate::input::CreateSnapshotCopyGrantInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the snapshot copy grant. This name must be unique in the region for the
        /// Amazon Web Services account.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain from 1 to 63 alphanumeric characters or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>Alphabetic characters must be lowercase.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// <li>
        /// <p>Must be unique for all clusters within an Amazon Web Services account.</p>
        /// </li>
        /// </ul>
        pub fn snapshot_copy_grant_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.snapshot_copy_grant_name(inp);
            self
        }
        /// <p>The name of the snapshot copy grant. This name must be unique in the region for the
        /// Amazon Web Services account.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain from 1 to 63 alphanumeric characters or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>Alphabetic characters must be lowercase.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// <li>
        /// <p>Must be unique for all clusters within an Amazon Web Services account.</p>
        /// </li>
        /// </ul>
        pub fn set_snapshot_copy_grant_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_snapshot_copy_grant_name(input);
            self
        }
        /// <p>The unique identifier of the customer master key (CMK) to which to grant Amazon Redshift
        /// permission. If no key is specified, the default key is used.</p>
        pub fn kms_key_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key_id(inp);
            self
        }
        /// <p>The unique identifier of the customer master key (CMK) to which to grant Amazon Redshift
        /// permission. If no key is specified, the default key is used.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key_id(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tag instances.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>A list of tag instances.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateSnapshotSchedule`.
    ///
    /// <p>Create a snapshot schedule that can be associated to a cluster and which overrides the default system backup schedule. </p>
    #[derive(std::fmt::Debug)]
    pub struct CreateSnapshotSchedule<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_snapshot_schedule_input::Builder,
    }
    impl<C, M, R> CreateSnapshotSchedule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateSnapshotSchedule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateSnapshotScheduleOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateSnapshotScheduleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateSnapshotScheduleInputOperationOutputAlias,
                crate::output::CreateSnapshotScheduleOutput,
                crate::error::CreateSnapshotScheduleError,
                crate::input::CreateSnapshotScheduleInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `ScheduleDefinitions`.
        ///
        /// To override the contents of this collection use [`set_schedule_definitions`](Self::set_schedule_definitions).
        ///
        /// <p>The definition of the snapshot schedule. The definition is made up of schedule
        /// expressions, for example "cron(30 12 *)" or "rate(12 hours)". </p>
        pub fn schedule_definitions(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schedule_definitions(inp);
            self
        }
        /// <p>The definition of the snapshot schedule. The definition is made up of schedule
        /// expressions, for example "cron(30 12 *)" or "rate(12 hours)". </p>
        pub fn set_schedule_definitions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_schedule_definitions(input);
            self
        }
        /// <p>A unique identifier for a snapshot schedule. Only alphanumeric characters are allowed
        /// for the identifier.</p>
        pub fn schedule_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schedule_identifier(inp);
            self
        }
        /// <p>A unique identifier for a snapshot schedule. Only alphanumeric characters are allowed
        /// for the identifier.</p>
        pub fn set_schedule_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_schedule_identifier(input);
            self
        }
        /// <p>The description of the snapshot schedule.</p>
        pub fn schedule_description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schedule_description(inp);
            self
        }
        /// <p>The description of the snapshot schedule.</p>
        pub fn set_schedule_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_schedule_description(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An optional set of tags you can use to search for the schedule.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>An optional set of tags you can use to search for the schedule.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p></p>
        pub fn dry_run(mut self, inp: bool) -> Self {
            self.inner = self.inner.dry_run(inp);
            self
        }
        /// <p></p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
        /// <p></p>
        pub fn next_invocations(mut self, inp: i32) -> Self {
            self.inner = self.inner.next_invocations(inp);
            self
        }
        /// <p></p>
        pub fn set_next_invocations(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_next_invocations(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateTags`.
    ///
    /// <p>Adds tags to a cluster.</p>
    /// <p>A resource can have up to 50 tags. If you try to create more than 50 tags for a
    /// resource, you will receive an error and the attempt will fail.</p>
    /// <p>If you specify a key that already exists for the resource, the value for that key
    /// will be updated with the new value.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateTags<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_tags_input::Builder,
    }
    impl<C, M, R> CreateTags<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateTagsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateTagsInputOperationOutputAlias,
                crate::output::CreateTagsOutput,
                crate::error::CreateTagsError,
                crate::input::CreateTagsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) to which you want to add the tag or tags. For
        /// example, <code>arn:aws:redshift:us-east-2:123456789:cluster:t1</code>. </p>
        pub fn resource_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_name(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) to which you want to add the tag or tags. For
        /// example, <code>arn:aws:redshift:us-east-2:123456789:cluster:t1</code>. </p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_name(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>One or more name/value pairs to add as tags to the specified resource. Each tag
        /// name is passed in with the parameter <code>Key</code> and the corresponding value is
        /// passed in with the parameter <code>Value</code>. The <code>Key</code> and
        /// <code>Value</code> parameters are separated by a comma (,). Separate multiple tags
        /// with a space. For example, <code>--tags "Key"="owner","Value"="admin"
        /// "Key"="environment","Value"="test" "Key"="version","Value"="1.0"</code>. </p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>One or more name/value pairs to add as tags to the specified resource. Each tag
        /// name is passed in with the parameter <code>Key</code> and the corresponding value is
        /// passed in with the parameter <code>Value</code>. The <code>Key</code> and
        /// <code>Value</code> parameters are separated by a comma (,). Separate multiple tags
        /// with a space. For example, <code>--tags "Key"="owner","Value"="admin"
        /// "Key"="environment","Value"="test" "Key"="version","Value"="1.0"</code>. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateUsageLimit`.
    ///
    /// <p>Creates a usage limit for a specified Amazon Redshift feature on a cluster.
    /// The usage limit is identified by the returned usage limit identifier.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateUsageLimit<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_usage_limit_input::Builder,
    }
    impl<C, M, R> CreateUsageLimit<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateUsageLimit`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateUsageLimitOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateUsageLimitError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateUsageLimitInputOperationOutputAlias,
                crate::output::CreateUsageLimitOutput,
                crate::error::CreateUsageLimitError,
                crate::input::CreateUsageLimitInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the cluster that you want to limit usage.</p>
        pub fn cluster_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_identifier(inp);
            self
        }
        /// <p>The identifier of the cluster that you want to limit usage.</p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_identifier(input);
            self
        }
        /// <p>The Amazon Redshift feature that you want to limit.</p>
        pub fn feature_type(mut self, inp: crate::model::UsageLimitFeatureType) -> Self {
            self.inner = self.inner.feature_type(inp);
            self
        }
        /// <p>The Amazon Redshift feature that you want to limit.</p>
        pub fn set_feature_type(
            mut self,
            input: std::option::Option<crate::model::UsageLimitFeatureType>,
        ) -> Self {
            self.inner = self.inner.set_feature_type(input);
            self
        }
        /// <p>The type of limit. Depending on the feature type, this can be based on a time duration or data size.
        /// If <code>FeatureType</code> is <code>spectrum</code>, then <code>LimitType</code> must be <code>data-scanned</code>.
        /// If <code>FeatureType</code> is <code>concurrency-scaling</code>, then <code>LimitType</code> must be <code>time</code>.
        /// </p>
        pub fn limit_type(mut self, inp: crate::model::UsageLimitLimitType) -> Self {
            self.inner = self.inner.limit_type(inp);
            self
        }
        /// <p>The type of limit. Depending on the feature type, this can be based on a time duration or data size.
        /// If <code>FeatureType</code> is <code>spectrum</code>, then <code>LimitType</code> must be <code>data-scanned</code>.
        /// If <code>FeatureType</code> is <code>concurrency-scaling</code>, then <code>LimitType</code> must be <code>time</code>.
        /// </p>
        pub fn set_limit_type(
            mut self,
            input: std::option::Option<crate::model::UsageLimitLimitType>,
        ) -> Self {
            self.inner = self.inner.set_limit_type(input);
            self
        }
        /// <p>The limit amount. If time-based, this amount is in minutes. If data-based, this amount is in terabytes (TB).
        /// The value must be a positive number.
        /// </p>
        pub fn amount(mut self, inp: i64) -> Self {
            self.inner = self.inner.amount(inp);
            self
        }
        /// <p>The limit amount. If time-based, this amount is in minutes. If data-based, this amount is in terabytes (TB).
        /// The value must be a positive number.
        /// </p>
        pub fn set_amount(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_amount(input);
            self
        }
        /// <p>The time period that the amount applies to. A <code>weekly</code> period begins on Sunday. The default is <code>monthly</code>.
        /// </p>
        pub fn period(mut self, inp: crate::model::UsageLimitPeriod) -> Self {
            self.inner = self.inner.period(inp);
            self
        }
        /// <p>The time period that the amount applies to. A <code>weekly</code> period begins on Sunday. The default is <code>monthly</code>.
        /// </p>
        pub fn set_period(
            mut self,
            input: std::option::Option<crate::model::UsageLimitPeriod>,
        ) -> Self {
            self.inner = self.inner.set_period(input);
            self
        }
        /// <p>The action that Amazon Redshift takes when the limit is reached. The default is log.
        /// For more information about this parameter, see <a>UsageLimit</a>.</p>
        pub fn breach_action(mut self, inp: crate::model::UsageLimitBreachAction) -> Self {
            self.inner = self.inner.breach_action(inp);
            self
        }
        /// <p>The action that Amazon Redshift takes when the limit is reached. The default is log.
        /// For more information about this parameter, see <a>UsageLimit</a>.</p>
        pub fn set_breach_action(
            mut self,
            input: std::option::Option<crate::model::UsageLimitBreachAction>,
        ) -> Self {
            self.inner = self.inner.set_breach_action(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tag instances.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>A list of tag instances.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeauthorizeDataShare`.
    ///
    /// <p>From the producer account, removes authorization from the specified datashare. </p>
    #[derive(std::fmt::Debug)]
    pub struct DeauthorizeDataShare<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::deauthorize_data_share_input::Builder,
    }
    impl<C, M, R> DeauthorizeDataShare<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeauthorizeDataShare`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeauthorizeDataShareOutput,
            aws_smithy_http::result::SdkError<crate::error::DeauthorizeDataShareError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeauthorizeDataShareInputOperationOutputAlias,
                crate::output::DeauthorizeDataShareOutput,
                crate::error::DeauthorizeDataShareError,
                crate::input::DeauthorizeDataShareInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the datashare to remove authorization from.</p>
        pub fn data_share_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_share_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the datashare to remove authorization from.</p>
        pub fn set_data_share_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_data_share_arn(input);
            self
        }
        /// <p>The identifier of the data consumer that is to have authorization removed from the datashare.
        /// This identifier is an AWS account ID.</p>
        pub fn consumer_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.consumer_identifier(inp);
            self
        }
        /// <p>The identifier of the data consumer that is to have authorization removed from the datashare.
        /// This identifier is an AWS account ID.</p>
        pub fn set_consumer_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_consumer_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAuthenticationProfile`.
    ///
    /// <p>Deletes an authentication profile.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteAuthenticationProfile<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_authentication_profile_input::Builder,
    }
    impl<C, M, R> DeleteAuthenticationProfile<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteAuthenticationProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAuthenticationProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAuthenticationProfileError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteAuthenticationProfileInputOperationOutputAlias,
                crate::output::DeleteAuthenticationProfileOutput,
                crate::error::DeleteAuthenticationProfileError,
                crate::input::DeleteAuthenticationProfileInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the authentication profile to delete.</p>
        pub fn authentication_profile_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.authentication_profile_name(inp);
            self
        }
        /// <p>The name of the authentication profile to delete.</p>
        pub fn set_authentication_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_authentication_profile_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteCluster`.
    ///
    /// <p>Deletes a previously provisioned cluster without its final snapshot being created. A successful response from the web
    /// service indicates that the request was received correctly. Use <a>DescribeClusters</a> to monitor the status of the deletion. The delete
    /// operation cannot be canceled or reverted once submitted.
    /// For more information about managing clusters, go to
    /// <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html">Amazon Redshift Clusters</a>
    /// in the <i>Amazon Redshift Cluster Management Guide</i>.</p>
    /// <p>If you want to shut down the cluster and retain it for future use, set
    /// <i>SkipFinalClusterSnapshot</i> to <code>false</code> and specify a
    /// name for <i>FinalClusterSnapshotIdentifier</i>. You can later restore this
    /// snapshot to resume using the cluster. If a final cluster snapshot is requested, the
    /// status of the cluster will be "final-snapshot" while the snapshot is being taken, then
    /// it's "deleting" once Amazon Redshift begins deleting the cluster. </p>
    /// <p>
    /// For more information about managing clusters, go to
    /// <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html">Amazon Redshift Clusters</a>
    /// in the <i>Amazon Redshift Cluster Management Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteCluster<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_cluster_input::Builder,
    }
    impl<C, M, R> DeleteCluster<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteCluster`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteClusterOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteClusterError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteClusterInputOperationOutputAlias,
                crate::output::DeleteClusterOutput,
                crate::error::DeleteClusterError,
                crate::input::DeleteClusterInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the cluster to be deleted.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain lowercase characters.</p>
        /// </li>
        /// <li>
        /// <p>Must contain from 1 to 63 alphanumeric characters or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// </ul>
        pub fn cluster_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_identifier(inp);
            self
        }
        /// <p>The identifier of the cluster to be deleted.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain lowercase characters.</p>
        /// </li>
        /// <li>
        /// <p>Must contain from 1 to 63 alphanumeric characters or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// </ul>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_identifier(input);
            self
        }
        /// <p>Determines whether a final snapshot of the cluster is created before Amazon Redshift
        /// deletes the cluster. If <code>true</code>, a final cluster snapshot is not created. If
        /// <code>false</code>, a final cluster snapshot is created before the cluster is
        /// deleted. </p>
        /// <note>
        /// <p>The <i>FinalClusterSnapshotIdentifier</i> parameter must be
        /// specified if <i>SkipFinalClusterSnapshot</i> is
        /// <code>false</code>.</p>
        /// </note>
        /// <p>Default: <code>false</code>
        /// </p>
        pub fn skip_final_cluster_snapshot(mut self, inp: bool) -> Self {
            self.inner = self.inner.skip_final_cluster_snapshot(inp);
            self
        }
        /// <p>Determines whether a final snapshot of the cluster is created before Amazon Redshift
        /// deletes the cluster. If <code>true</code>, a final cluster snapshot is not created. If
        /// <code>false</code>, a final cluster snapshot is created before the cluster is
        /// deleted. </p>
        /// <note>
        /// <p>The <i>FinalClusterSnapshotIdentifier</i> parameter must be
        /// specified if <i>SkipFinalClusterSnapshot</i> is
        /// <code>false</code>.</p>
        /// </note>
        /// <p>Default: <code>false</code>
        /// </p>
        pub fn set_skip_final_cluster_snapshot(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_skip_final_cluster_snapshot(input);
            self
        }
        /// <p>The identifier of the final snapshot that is to be created immediately before
        /// deleting the cluster. If this parameter is provided,
        /// <i>SkipFinalClusterSnapshot</i> must be <code>false</code>. </p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be 1 to 255 alphanumeric characters.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// </ul>
        pub fn final_cluster_snapshot_identifier(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.final_cluster_snapshot_identifier(inp);
            self
        }
        /// <p>The identifier of the final snapshot that is to be created immediately before
        /// deleting the cluster. If this parameter is provided,
        /// <i>SkipFinalClusterSnapshot</i> must be <code>false</code>. </p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be 1 to 255 alphanumeric characters.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// </ul>
        pub fn set_final_cluster_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_final_cluster_snapshot_identifier(input);
            self
        }
        /// <p>The number of days that a manual snapshot is retained. If the value is -1, the manual
        /// snapshot is retained indefinitely.</p>
        /// <p>The value must be either -1 or an integer between 1 and 3,653.</p>
        /// <p>The default value is -1.</p>
        pub fn final_cluster_snapshot_retention_period(mut self, inp: i32) -> Self {
            self.inner = self.inner.final_cluster_snapshot_retention_period(inp);
            self
        }
        /// <p>The number of days that a manual snapshot is retained. If the value is -1, the manual
        /// snapshot is retained indefinitely.</p>
        /// <p>The value must be either -1 or an integer between 1 and 3,653.</p>
        /// <p>The default value is -1.</p>
        pub fn set_final_cluster_snapshot_retention_period(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.inner = self
                .inner
                .set_final_cluster_snapshot_retention_period(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteClusterParameterGroup`.
    ///
    /// <p>Deletes a specified Amazon Redshift parameter group.</p>
    /// <note>
    /// <p>You cannot delete a parameter group if it is associated with a
    /// cluster.</p>
    /// </note>
    #[derive(std::fmt::Debug)]
    pub struct DeleteClusterParameterGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_cluster_parameter_group_input::Builder,
    }
    impl<C, M, R> DeleteClusterParameterGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteClusterParameterGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteClusterParameterGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteClusterParameterGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteClusterParameterGroupInputOperationOutputAlias,
                crate::output::DeleteClusterParameterGroupOutput,
                crate::error::DeleteClusterParameterGroupError,
                crate::input::DeleteClusterParameterGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the parameter group to be deleted.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be the name of an existing cluster parameter group.</p>
        /// </li>
        /// <li>
        /// <p>Cannot delete a default cluster parameter group.</p>
        /// </li>
        /// </ul>
        pub fn parameter_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.parameter_group_name(inp);
            self
        }
        /// <p>The name of the parameter group to be deleted.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be the name of an existing cluster parameter group.</p>
        /// </li>
        /// <li>
        /// <p>Cannot delete a default cluster parameter group.</p>
        /// </li>
        /// </ul>
        pub fn set_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_parameter_group_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteClusterSecurityGroup`.
    ///
    /// <p>Deletes an Amazon Redshift security group.</p>
    /// <note>
    /// <p>You cannot delete a security group that is associated with any clusters. You
    /// cannot delete the default security group.</p>
    /// </note>
    /// <p>
    /// For information about managing security groups, go to
    /// <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-security-groups.html">Amazon Redshift Cluster Security Groups</a> in the
    /// <i>Amazon Redshift Cluster Management Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteClusterSecurityGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_cluster_security_group_input::Builder,
    }
    impl<C, M, R> DeleteClusterSecurityGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteClusterSecurityGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteClusterSecurityGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteClusterSecurityGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteClusterSecurityGroupInputOperationOutputAlias,
                crate::output::DeleteClusterSecurityGroupOutput,
                crate::error::DeleteClusterSecurityGroupError,
                crate::input::DeleteClusterSecurityGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the cluster security group to be deleted.</p>
        pub fn cluster_security_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_security_group_name(inp);
            self
        }
        /// <p>The name of the cluster security group to be deleted.</p>
        pub fn set_cluster_security_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_security_group_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteClusterSnapshot`.
    ///
    /// <p>Deletes the specified manual snapshot. The snapshot must be in the
    /// <code>available</code> state, with no other users authorized to access the snapshot. </p>
    /// <p>Unlike automated snapshots, manual snapshots are retained even after you delete
    /// your cluster. Amazon Redshift does not delete your manual snapshots. You must delete manual
    /// snapshot explicitly to avoid getting charged. If other accounts are authorized to access
    /// the snapshot, you must revoke all of the authorizations before you can delete the
    /// snapshot.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteClusterSnapshot<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_cluster_snapshot_input::Builder,
    }
    impl<C, M, R> DeleteClusterSnapshot<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteClusterSnapshot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteClusterSnapshotOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteClusterSnapshotError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteClusterSnapshotInputOperationOutputAlias,
                crate::output::DeleteClusterSnapshotOutput,
                crate::error::DeleteClusterSnapshotError,
                crate::input::DeleteClusterSnapshotInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the manual snapshot to be deleted.</p>
        /// <p>Constraints: Must be the name of an existing snapshot that is in the
        /// <code>available</code>, <code>failed</code>, or <code>cancelled</code>
        /// state.</p>
        pub fn snapshot_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.snapshot_identifier(inp);
            self
        }
        /// <p>The unique identifier of the manual snapshot to be deleted.</p>
        /// <p>Constraints: Must be the name of an existing snapshot that is in the
        /// <code>available</code>, <code>failed</code>, or <code>cancelled</code>
        /// state.</p>
        pub fn set_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_snapshot_identifier(input);
            self
        }
        /// <p>The unique identifier of the cluster the snapshot was created from. This parameter
        /// is required if your IAM user has a policy containing a snapshot resource element that
        /// specifies anything other than * for the cluster name.</p>
        /// <p>Constraints: Must be the name of valid cluster.</p>
        pub fn snapshot_cluster_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.snapshot_cluster_identifier(inp);
            self
        }
        /// <p>The unique identifier of the cluster the snapshot was created from. This parameter
        /// is required if your IAM user has a policy containing a snapshot resource element that
        /// specifies anything other than * for the cluster name.</p>
        /// <p>Constraints: Must be the name of valid cluster.</p>
        pub fn set_snapshot_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_snapshot_cluster_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteClusterSubnetGroup`.
    ///
    /// <p>Deletes the specified cluster subnet group.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteClusterSubnetGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_cluster_subnet_group_input::Builder,
    }
    impl<C, M, R> DeleteClusterSubnetGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteClusterSubnetGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteClusterSubnetGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteClusterSubnetGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteClusterSubnetGroupInputOperationOutputAlias,
                crate::output::DeleteClusterSubnetGroupOutput,
                crate::error::DeleteClusterSubnetGroupError,
                crate::input::DeleteClusterSubnetGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the cluster subnet group name to be deleted.</p>
        pub fn cluster_subnet_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_subnet_group_name(inp);
            self
        }
        /// <p>The name of the cluster subnet group name to be deleted.</p>
        pub fn set_cluster_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_subnet_group_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteEndpointAccess`.
    ///
    /// <p>Deletes a Redshift-managed VPC endpoint.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteEndpointAccess<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_endpoint_access_input::Builder,
    }
    impl<C, M, R> DeleteEndpointAccess<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteEndpointAccess`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteEndpointAccessOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteEndpointAccessError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteEndpointAccessInputOperationOutputAlias,
                crate::output::DeleteEndpointAccessOutput,
                crate::error::DeleteEndpointAccessError,
                crate::input::DeleteEndpointAccessInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Redshift-managed VPC endpoint to delete.</p>
        pub fn endpoint_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.endpoint_name(inp);
            self
        }
        /// <p>The Redshift-managed VPC endpoint to delete.</p>
        pub fn set_endpoint_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_endpoint_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteEventSubscription`.
    ///
    /// <p>Deletes an Amazon Redshift event notification subscription.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteEventSubscription<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_event_subscription_input::Builder,
    }
    impl<C, M, R> DeleteEventSubscription<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteEventSubscription`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteEventSubscriptionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteEventSubscriptionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteEventSubscriptionInputOperationOutputAlias,
                crate::output::DeleteEventSubscriptionOutput,
                crate::error::DeleteEventSubscriptionError,
                crate::input::DeleteEventSubscriptionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Amazon Redshift event notification subscription to be deleted.</p>
        pub fn subscription_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subscription_name(inp);
            self
        }
        /// <p>The name of the Amazon Redshift event notification subscription to be deleted.</p>
        pub fn set_subscription_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_subscription_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteHsmClientCertificate`.
    ///
    /// <p>Deletes the specified HSM client certificate.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteHsmClientCertificate<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_hsm_client_certificate_input::Builder,
    }
    impl<C, M, R> DeleteHsmClientCertificate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteHsmClientCertificate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteHsmClientCertificateOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteHsmClientCertificateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteHsmClientCertificateInputOperationOutputAlias,
                crate::output::DeleteHsmClientCertificateOutput,
                crate::error::DeleteHsmClientCertificateError,
                crate::input::DeleteHsmClientCertificateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the HSM client certificate to be deleted.</p>
        pub fn hsm_client_certificate_identifier(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.hsm_client_certificate_identifier(inp);
            self
        }
        /// <p>The identifier of the HSM client certificate to be deleted.</p>
        pub fn set_hsm_client_certificate_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_hsm_client_certificate_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteHsmConfiguration`.
    ///
    /// <p>Deletes the specified Amazon Redshift HSM configuration.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteHsmConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_hsm_configuration_input::Builder,
    }
    impl<C, M, R> DeleteHsmConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteHsmConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteHsmConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteHsmConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteHsmConfigurationInputOperationOutputAlias,
                crate::output::DeleteHsmConfigurationOutput,
                crate::error::DeleteHsmConfigurationError,
                crate::input::DeleteHsmConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Redshift HSM configuration to be deleted.</p>
        pub fn hsm_configuration_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hsm_configuration_identifier(inp);
            self
        }
        /// <p>The identifier of the Amazon Redshift HSM configuration to be deleted.</p>
        pub fn set_hsm_configuration_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_hsm_configuration_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeletePartner`.
    ///
    /// <p>Deletes a partner integration from a cluster. Data can still flow to the cluster until the integration is deleted at the partner's website.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeletePartner<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_partner_input::Builder,
    }
    impl<C, M, R> DeletePartner<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeletePartner`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeletePartnerOutput,
            aws_smithy_http::result::SdkError<crate::error::DeletePartnerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeletePartnerInputOperationOutputAlias,
                crate::output::DeletePartnerOutput,
                crate::error::DeletePartnerError,
                crate::input::DeletePartnerInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID that owns the cluster.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The Amazon Web Services account ID that owns the cluster.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The cluster identifier of the cluster that receives data from the partner.</p>
        pub fn cluster_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_identifier(inp);
            self
        }
        /// <p>The cluster identifier of the cluster that receives data from the partner.</p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_identifier(input);
            self
        }
        /// <p>The name of the database that receives data from the partner.</p>
        pub fn database_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.database_name(inp);
            self
        }
        /// <p>The name of the database that receives data from the partner.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_database_name(input);
            self
        }
        /// <p>The name of the partner that is authorized to send data.</p>
        pub fn partner_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.partner_name(inp);
            self
        }
        /// <p>The name of the partner that is authorized to send data.</p>
        pub fn set_partner_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_partner_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteScheduledAction`.
    ///
    /// <p>Deletes a scheduled action.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteScheduledAction<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_scheduled_action_input::Builder,
    }
    impl<C, M, R> DeleteScheduledAction<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteScheduledAction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteScheduledActionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteScheduledActionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteScheduledActionInputOperationOutputAlias,
                crate::output::DeleteScheduledActionOutput,
                crate::error::DeleteScheduledActionError,
                crate::input::DeleteScheduledActionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the scheduled action to delete. </p>
        pub fn scheduled_action_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.scheduled_action_name(inp);
            self
        }
        /// <p>The name of the scheduled action to delete. </p>
        pub fn set_scheduled_action_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_scheduled_action_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteSnapshotCopyGrant`.
    ///
    /// <p>Deletes the specified snapshot copy grant.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteSnapshotCopyGrant<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_snapshot_copy_grant_input::Builder,
    }
    impl<C, M, R> DeleteSnapshotCopyGrant<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteSnapshotCopyGrant`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteSnapshotCopyGrantOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteSnapshotCopyGrantError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteSnapshotCopyGrantInputOperationOutputAlias,
                crate::output::DeleteSnapshotCopyGrantOutput,
                crate::error::DeleteSnapshotCopyGrantError,
                crate::input::DeleteSnapshotCopyGrantInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the snapshot copy grant to delete.</p>
        pub fn snapshot_copy_grant_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.snapshot_copy_grant_name(inp);
            self
        }
        /// <p>The name of the snapshot copy grant to delete.</p>
        pub fn set_snapshot_copy_grant_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_snapshot_copy_grant_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteSnapshotSchedule`.
    ///
    /// <p>Deletes a snapshot schedule.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteSnapshotSchedule<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_snapshot_schedule_input::Builder,
    }
    impl<C, M, R> DeleteSnapshotSchedule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteSnapshotSchedule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteSnapshotScheduleOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteSnapshotScheduleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteSnapshotScheduleInputOperationOutputAlias,
                crate::output::DeleteSnapshotScheduleOutput,
                crate::error::DeleteSnapshotScheduleError,
                crate::input::DeleteSnapshotScheduleInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique identifier of the snapshot schedule to delete.</p>
        pub fn schedule_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schedule_identifier(inp);
            self
        }
        /// <p>A unique identifier of the snapshot schedule to delete.</p>
        pub fn set_schedule_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_schedule_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteTags`.
    ///
    /// <p>Deletes tags from a resource. You must provide the ARN of the resource
    /// from which you want to delete the tag or tags.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteTags<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_tags_input::Builder,
    }
    impl<C, M, R> DeleteTags<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteTagsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteTagsInputOperationOutputAlias,
                crate::output::DeleteTagsOutput,
                crate::error::DeleteTagsError,
                crate::input::DeleteTagsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) from which you want to remove the tag or tags. For
        /// example, <code>arn:aws:redshift:us-east-2:123456789:cluster:t1</code>. </p>
        pub fn resource_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_name(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) from which you want to remove the tag or tags. For
        /// example, <code>arn:aws:redshift:us-east-2:123456789:cluster:t1</code>. </p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_name(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The tag key that you want to delete.</p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>The tag key that you want to delete.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteUsageLimit`.
    ///
    /// <p>Deletes a usage limit from a cluster.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteUsageLimit<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_usage_limit_input::Builder,
    }
    impl<C, M, R> DeleteUsageLimit<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteUsageLimit`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteUsageLimitOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteUsageLimitError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteUsageLimitInputOperationOutputAlias,
                crate::output::DeleteUsageLimitOutput,
                crate::error::DeleteUsageLimitError,
                crate::input::DeleteUsageLimitInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the usage limit to delete.</p>
        pub fn usage_limit_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.usage_limit_id(inp);
            self
        }
        /// <p>The identifier of the usage limit to delete.</p>
        pub fn set_usage_limit_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_usage_limit_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAccountAttributes`.
    ///
    /// <p>Returns a list of attributes attached to an account</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeAccountAttributes<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_account_attributes_input::Builder,
    }
    impl<C, M, R> DescribeAccountAttributes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeAccountAttributes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAccountAttributesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAccountAttributesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeAccountAttributesInputOperationOutputAlias,
                crate::output::DescribeAccountAttributesOutput,
                crate::error::DescribeAccountAttributesError,
                crate::input::DescribeAccountAttributesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `AttributeNames`.
        ///
        /// To override the contents of this collection use [`set_attribute_names`](Self::set_attribute_names).
        ///
        /// <p>A list of attribute names.</p>
        pub fn attribute_names(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.attribute_names(inp);
            self
        }
        /// <p>A list of attribute names.</p>
        pub fn set_attribute_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_attribute_names(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAuthenticationProfiles`.
    ///
    /// <p>Describes an authentication profile.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeAuthenticationProfiles<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_authentication_profiles_input::Builder,
    }
    impl<C, M, R> DescribeAuthenticationProfiles<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeAuthenticationProfiles`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAuthenticationProfilesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAuthenticationProfilesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeAuthenticationProfilesInputOperationOutputAlias,
                crate::output::DescribeAuthenticationProfilesOutput,
                crate::error::DescribeAuthenticationProfilesError,
                crate::input::DescribeAuthenticationProfilesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the authentication profile to describe. If not specified then all authentication profiles owned by the account are listed.</p>
        pub fn authentication_profile_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.authentication_profile_name(inp);
            self
        }
        /// <p>The name of the authentication profile to describe. If not specified then all authentication profiles owned by the account are listed.</p>
        pub fn set_authentication_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_authentication_profile_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeClusterDbRevisions`.
    ///
    /// <p>Returns an array of <code>ClusterDbRevision</code> objects.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeClusterDbRevisions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_cluster_db_revisions_input::Builder,
    }
    impl<C, M, R> DescribeClusterDbRevisions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeClusterDbRevisions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeClusterDbRevisionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeClusterDbRevisionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeClusterDbRevisionsInputOperationOutputAlias,
                crate::output::DescribeClusterDbRevisionsOutput,
                crate::error::DescribeClusterDbRevisionsError,
                crate::input::DescribeClusterDbRevisionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique identifier for a cluster whose <code>ClusterDbRevisions</code> you are
        /// requesting. This parameter is case sensitive. All clusters defined for an account are
        /// returned by default.</p>
        pub fn cluster_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_identifier(inp);
            self
        }
        /// <p>A unique identifier for a cluster whose <code>ClusterDbRevisions</code> you are
        /// requesting. This parameter is case sensitive. All clusters defined for an account are
        /// returned by default.</p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_identifier(input);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of
        /// remaining response records exceeds the specified MaxRecords value, a value is returned
        /// in the <code>marker</code> field of the response. You can retrieve the next set of
        /// response records by providing the returned <code>marker</code> value in the
        /// <code>marker</code> parameter and retrying the request. </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of
        /// remaining response records exceeds the specified MaxRecords value, a value is returned
        /// in the <code>marker</code> field of the response. You can retrieve the next set of
        /// response records by providing the returned <code>marker</code> value in the
        /// <code>marker</code> parameter and retrying the request. </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>An optional parameter that specifies the starting point for returning a set of
        /// response records. When the results of a <code>DescribeClusterDbRevisions</code> request
        /// exceed the value specified in <code>MaxRecords</code>, Amazon Redshift returns a value
        /// in the <code>marker</code> field of the response. You can retrieve the next set of
        /// response records by providing the returned <code>marker</code> value in the
        /// <code>marker</code> parameter and retrying the request. </p>
        /// <p>Constraints: You can specify either the <code>ClusterIdentifier</code> parameter, or
        /// the <code>marker</code> parameter, but not both.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>An optional parameter that specifies the starting point for returning a set of
        /// response records. When the results of a <code>DescribeClusterDbRevisions</code> request
        /// exceed the value specified in <code>MaxRecords</code>, Amazon Redshift returns a value
        /// in the <code>marker</code> field of the response. You can retrieve the next set of
        /// response records by providing the returned <code>marker</code> value in the
        /// <code>marker</code> parameter and retrying the request. </p>
        /// <p>Constraints: You can specify either the <code>ClusterIdentifier</code> parameter, or
        /// the <code>marker</code> parameter, but not both.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeClusterParameterGroups`.
    ///
    /// <p>Returns a list of Amazon Redshift parameter groups, including parameter groups you
    /// created and the default parameter group. For each parameter group, the response includes
    /// the parameter group name, description, and parameter group family name. You can
    /// optionally specify a name to retrieve the description of a specific parameter
    /// group.</p>
    /// <p>
    /// For more information about parameters and parameter groups, go to
    /// <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Amazon Redshift Parameter Groups</a>
    /// in the <i>Amazon Redshift Cluster Management Guide</i>.</p>
    /// <p>If you specify both tag keys and tag values in the same request, Amazon Redshift returns
    /// all parameter groups that match any combination of the specified keys and values. For
    /// example, if you have <code>owner</code> and <code>environment</code> for tag keys, and
    /// <code>admin</code> and <code>test</code> for tag values, all parameter groups that
    /// have any combination of those values are returned.</p>
    /// <p>If both tag keys and values are omitted from the request, parameter groups are
    /// returned regardless of whether they have tag keys or values associated with
    /// them.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeClusterParameterGroups<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_cluster_parameter_groups_input::Builder,
    }
    impl<C, M, R> DescribeClusterParameterGroups<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeClusterParameterGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeClusterParameterGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeClusterParameterGroupsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeClusterParameterGroupsInputOperationOutputAlias,
                crate::output::DescribeClusterParameterGroupsOutput,
                crate::error::DescribeClusterParameterGroupsError,
                crate::input::DescribeClusterParameterGroupsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of a specific parameter group for which to return details. By default,
        /// details about all parameter groups and the default parameter group are
        /// returned.</p>
        pub fn parameter_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.parameter_group_name(inp);
            self
        }
        /// <p>The name of a specific parameter group for which to return details. By default,
        /// details about all parameter groups and the default parameter group are
        /// returned.</p>
        pub fn set_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_parameter_group_name(input);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of
        /// remaining response records exceeds the specified <code>MaxRecords</code> value, a value
        /// is returned in a <code>marker</code> field of the response. You can retrieve the next
        /// set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>100</code>
        /// </p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of
        /// remaining response records exceeds the specified <code>MaxRecords</code> value, a value
        /// is returned in a <code>marker</code> field of the response. You can retrieve the next
        /// set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>100</code>
        /// </p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response
        /// records. When the results of a <a>DescribeClusterParameterGroups</a> request
        /// exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the
        /// <code>Marker</code> field of the response. You can retrieve the next set of response
        /// records by providing the returned marker value in the <code>Marker</code> parameter and
        /// retrying the request. </p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response
        /// records. When the results of a <a>DescribeClusterParameterGroups</a> request
        /// exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the
        /// <code>Marker</code> field of the response. You can retrieve the next set of response
        /// records by providing the returned marker value in the <code>Marker</code> parameter and
        /// retrying the request. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A tag key or keys for which you want to return all matching cluster parameter
        /// groups that are associated with the specified key or keys. For example, suppose that you
        /// have parameter groups that are tagged with keys called <code>owner</code> and
        /// <code>environment</code>. If you specify both of these tag keys in the request,
        /// Amazon Redshift returns a response with the parameter groups that have either or both of these
        /// tag keys associated with them.</p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>A tag key or keys for which you want to return all matching cluster parameter
        /// groups that are associated with the specified key or keys. For example, suppose that you
        /// have parameter groups that are tagged with keys called <code>owner</code> and
        /// <code>environment</code>. If you specify both of these tag keys in the request,
        /// Amazon Redshift returns a response with the parameter groups that have either or both of these
        /// tag keys associated with them.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
        /// Appends an item to `TagValues`.
        ///
        /// To override the contents of this collection use [`set_tag_values`](Self::set_tag_values).
        ///
        /// <p>A tag value or values for which you want to return all matching cluster parameter
        /// groups that are associated with the specified tag value or values. For example, suppose
        /// that you have parameter groups that are tagged with values called <code>admin</code> and
        /// <code>test</code>. If you specify both of these tag values in the request, Amazon Redshift
        /// returns a response with the parameter groups that have either or both of these tag
        /// values associated with them.</p>
        pub fn tag_values(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_values(inp);
            self
        }
        /// <p>A tag value or values for which you want to return all matching cluster parameter
        /// groups that are associated with the specified tag value or values. For example, suppose
        /// that you have parameter groups that are tagged with values called <code>admin</code> and
        /// <code>test</code>. If you specify both of these tag values in the request, Amazon Redshift
        /// returns a response with the parameter groups that have either or both of these tag
        /// values associated with them.</p>
        pub fn set_tag_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_values(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeClusterParameters`.
    ///
    /// <p>Returns a detailed list of parameters contained within the specified Amazon Redshift
    /// parameter group. For each parameter the response includes information such as parameter
    /// name, description, data type, value, whether the parameter value is modifiable, and so
    /// on.</p>
    /// <p>You can specify <i>source</i> filter to retrieve parameters of only
    /// specific type. For example, to retrieve parameters that were modified by a user action
    /// such as from <a>ModifyClusterParameterGroup</a>, you can specify
    /// <i>source</i> equal to <i>user</i>.</p>
    /// <p>
    /// For more information about parameters and parameter groups, go to
    /// <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Amazon Redshift Parameter Groups</a>
    /// in the <i>Amazon Redshift Cluster Management Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeClusterParameters<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_cluster_parameters_input::Builder,
    }
    impl<C, M, R> DescribeClusterParameters<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeClusterParameters`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeClusterParametersOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeClusterParametersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeClusterParametersInputOperationOutputAlias,
                crate::output::DescribeClusterParametersOutput,
                crate::error::DescribeClusterParametersError,
                crate::input::DescribeClusterParametersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of a cluster parameter group for which to return details.</p>
        pub fn parameter_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.parameter_group_name(inp);
            self
        }
        /// <p>The name of a cluster parameter group for which to return details.</p>
        pub fn set_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_parameter_group_name(input);
            self
        }
        /// <p>The parameter types to return. Specify <code>user</code> to show parameters that
        /// are different form the default. Similarly, specify <code>engine-default</code> to show
        /// parameters that are the same as the default parameter group. </p>
        /// <p>Default: All parameter types returned.</p>
        /// <p>Valid Values: <code>user</code> | <code>engine-default</code>
        /// </p>
        pub fn source(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source(inp);
            self
        }
        /// <p>The parameter types to return. Specify <code>user</code> to show parameters that
        /// are different form the default. Similarly, specify <code>engine-default</code> to show
        /// parameters that are the same as the default parameter group. </p>
        /// <p>Default: All parameter types returned.</p>
        /// <p>Valid Values: <code>user</code> | <code>engine-default</code>
        /// </p>
        pub fn set_source(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_source(input);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of
        /// remaining response records exceeds the specified <code>MaxRecords</code> value, a value
        /// is returned in a <code>marker</code> field of the response. You can retrieve the next
        /// set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>100</code>
        /// </p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of
        /// remaining response records exceeds the specified <code>MaxRecords</code> value, a value
        /// is returned in a <code>marker</code> field of the response. You can retrieve the next
        /// set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>100</code>
        /// </p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response
        /// records. When the results of a <a>DescribeClusterParameters</a> request
        /// exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the
        /// <code>Marker</code> field of the response. You can retrieve the next set of response
        /// records by providing the returned marker value in the <code>Marker</code> parameter and
        /// retrying the request. </p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response
        /// records. When the results of a <a>DescribeClusterParameters</a> request
        /// exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the
        /// <code>Marker</code> field of the response. You can retrieve the next set of response
        /// records by providing the returned marker value in the <code>Marker</code> parameter and
        /// retrying the request. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeClusters`.
    ///
    /// <p>Returns properties of provisioned clusters including general cluster properties,
    /// cluster database properties, maintenance and backup properties, and security and access
    /// properties. This operation supports pagination.
    /// For more information about managing clusters, go to
    /// <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html">Amazon Redshift Clusters</a>
    /// in the <i>Amazon Redshift Cluster Management Guide</i>.</p>
    /// <p>If you specify both tag keys and tag values in the same request, Amazon Redshift returns
    /// all clusters that match any combination of the specified keys and values. For example,
    /// if you have <code>owner</code> and <code>environment</code> for tag keys, and
    /// <code>admin</code> and <code>test</code> for tag values, all clusters that have any
    /// combination of those values are returned.</p>
    /// <p>If both tag keys and values are omitted from the request, clusters are returned
    /// regardless of whether they have tag keys or values associated with them.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeClusters<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_clusters_input::Builder,
    }
    impl<C, M, R> DescribeClusters<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeClusters`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeClustersOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeClustersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeClustersInputOperationOutputAlias,
                crate::output::DescribeClustersOutput,
                crate::error::DescribeClustersError,
                crate::input::DescribeClustersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of a cluster whose properties you are requesting. This
        /// parameter is case sensitive.</p>
        /// <p>The default is that all clusters defined for an account are returned.</p>
        pub fn cluster_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_identifier(inp);
            self
        }
        /// <p>The unique identifier of a cluster whose properties you are requesting. This
        /// parameter is case sensitive.</p>
        /// <p>The default is that all clusters defined for an account are returned.</p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_identifier(input);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of
        /// remaining response records exceeds the specified <code>MaxRecords</code> value, a value
        /// is returned in a <code>marker</code> field of the response. You can retrieve the next
        /// set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>100</code>
        /// </p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of
        /// remaining response records exceeds the specified <code>MaxRecords</code> value, a value
        /// is returned in a <code>marker</code> field of the response. You can retrieve the next
        /// set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>100</code>
        /// </p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response
        /// records. When the results of a <a>DescribeClusters</a> request exceed the
        /// value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the
        /// <code>Marker</code> field of the response. You can retrieve the next set of response
        /// records by providing the returned marker value in the <code>Marker</code> parameter and
        /// retrying the request. </p>
        /// <p>Constraints: You can specify either the <b>ClusterIdentifier</b> parameter or the <b>Marker</b> parameter, but not both. </p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response
        /// records. When the results of a <a>DescribeClusters</a> request exceed the
        /// value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the
        /// <code>Marker</code> field of the response. You can retrieve the next set of response
        /// records by providing the returned marker value in the <code>Marker</code> parameter and
        /// retrying the request. </p>
        /// <p>Constraints: You can specify either the <b>ClusterIdentifier</b> parameter or the <b>Marker</b> parameter, but not both. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A tag key or keys for which you want to return all matching clusters that are
        /// associated with the specified key or keys. For example, suppose that you have clusters
        /// that are tagged with keys called <code>owner</code> and <code>environment</code>. If you
        /// specify both of these tag keys in the request, Amazon Redshift returns a response with the
        /// clusters that have either or both of these tag keys associated with them.</p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>A tag key or keys for which you want to return all matching clusters that are
        /// associated with the specified key or keys. For example, suppose that you have clusters
        /// that are tagged with keys called <code>owner</code> and <code>environment</code>. If you
        /// specify both of these tag keys in the request, Amazon Redshift returns a response with the
        /// clusters that have either or both of these tag keys associated with them.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
        /// Appends an item to `TagValues`.
        ///
        /// To override the contents of this collection use [`set_tag_values`](Self::set_tag_values).
        ///
        /// <p>A tag value or values for which you want to return all matching clusters that are
        /// associated with the specified tag value or values. For example, suppose that you have
        /// clusters that are tagged with values called <code>admin</code> and <code>test</code>. If
        /// you specify both of these tag values in the request, Amazon Redshift returns a response with
        /// the clusters that have either or both of these tag values associated with
        /// them.</p>
        pub fn tag_values(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_values(inp);
            self
        }
        /// <p>A tag value or values for which you want to return all matching clusters that are
        /// associated with the specified tag value or values. For example, suppose that you have
        /// clusters that are tagged with values called <code>admin</code> and <code>test</code>. If
        /// you specify both of these tag values in the request, Amazon Redshift returns a response with
        /// the clusters that have either or both of these tag values associated with
        /// them.</p>
        pub fn set_tag_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_values(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeClusterSecurityGroups`.
    ///
    /// <p>Returns information about Amazon Redshift security groups. If the name of a security
    /// group is specified, the response will contain only information about only that security
    /// group.</p>
    /// <p>
    /// For information about managing security groups, go to
    /// <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-security-groups.html">Amazon Redshift Cluster Security Groups</a> in the
    /// <i>Amazon Redshift Cluster Management Guide</i>.</p>
    /// <p>If you specify both tag keys and tag values in the same request, Amazon Redshift returns
    /// all security groups that match any combination of the specified keys and values. For
    /// example, if you have <code>owner</code> and <code>environment</code> for tag keys, and
    /// <code>admin</code> and <code>test</code> for tag values, all security groups that
    /// have any combination of those values are returned.</p>
    /// <p>If both tag keys and values are omitted from the request, security groups are
    /// returned regardless of whether they have tag keys or values associated with
    /// them.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeClusterSecurityGroups<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_cluster_security_groups_input::Builder,
    }
    impl<C, M, R> DescribeClusterSecurityGroups<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeClusterSecurityGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeClusterSecurityGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeClusterSecurityGroupsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeClusterSecurityGroupsInputOperationOutputAlias,
                crate::output::DescribeClusterSecurityGroupsOutput,
                crate::error::DescribeClusterSecurityGroupsError,
                crate::input::DescribeClusterSecurityGroupsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of a cluster security group for which you are requesting details. You can
        /// specify either the <b>Marker</b> parameter or a <b>ClusterSecurityGroupName</b> parameter, but not both. </p>
        /// <p> Example: <code>securitygroup1</code>
        /// </p>
        pub fn cluster_security_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_security_group_name(inp);
            self
        }
        /// <p>The name of a cluster security group for which you are requesting details. You can
        /// specify either the <b>Marker</b> parameter or a <b>ClusterSecurityGroupName</b> parameter, but not both. </p>
        /// <p> Example: <code>securitygroup1</code>
        /// </p>
        pub fn set_cluster_security_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_security_group_name(input);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of
        /// remaining response records exceeds the specified <code>MaxRecords</code> value, a value
        /// is returned in a <code>marker</code> field of the response. You can retrieve the next
        /// set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>100</code>
        /// </p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of
        /// remaining response records exceeds the specified <code>MaxRecords</code> value, a value
        /// is returned in a <code>marker</code> field of the response. You can retrieve the next
        /// set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>100</code>
        /// </p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response
        /// records. When the results of a <a>DescribeClusterSecurityGroups</a> request
        /// exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the
        /// <code>Marker</code> field of the response. You can retrieve the next set of response
        /// records by providing the returned marker value in the <code>Marker</code> parameter and
        /// retrying the request. </p>
        /// <p>Constraints: You can specify either the <b>ClusterSecurityGroupName</b> parameter or the <b>Marker</b> parameter, but not both. </p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response
        /// records. When the results of a <a>DescribeClusterSecurityGroups</a> request
        /// exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the
        /// <code>Marker</code> field of the response. You can retrieve the next set of response
        /// records by providing the returned marker value in the <code>Marker</code> parameter and
        /// retrying the request. </p>
        /// <p>Constraints: You can specify either the <b>ClusterSecurityGroupName</b> parameter or the <b>Marker</b> parameter, but not both. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A tag key or keys for which you want to return all matching cluster security groups
        /// that are associated with the specified key or keys. For example, suppose that you have
        /// security groups that are tagged with keys called <code>owner</code> and
        /// <code>environment</code>. If you specify both of these tag keys in the request,
        /// Amazon Redshift returns a response with the security groups that have either or both of these
        /// tag keys associated with them.</p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>A tag key or keys for which you want to return all matching cluster security groups
        /// that are associated with the specified key or keys. For example, suppose that you have
        /// security groups that are tagged with keys called <code>owner</code> and
        /// <code>environment</code>. If you specify both of these tag keys in the request,
        /// Amazon Redshift returns a response with the security groups that have either or both of these
        /// tag keys associated with them.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
        /// Appends an item to `TagValues`.
        ///
        /// To override the contents of this collection use [`set_tag_values`](Self::set_tag_values).
        ///
        /// <p>A tag value or values for which you want to return all matching cluster security
        /// groups that are associated with the specified tag value or values. For example, suppose
        /// that you have security groups that are tagged with values called <code>admin</code> and
        /// <code>test</code>. If you specify both of these tag values in the request, Amazon Redshift
        /// returns a response with the security groups that have either or both of these tag values
        /// associated with them.</p>
        pub fn tag_values(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_values(inp);
            self
        }
        /// <p>A tag value or values for which you want to return all matching cluster security
        /// groups that are associated with the specified tag value or values. For example, suppose
        /// that you have security groups that are tagged with values called <code>admin</code> and
        /// <code>test</code>. If you specify both of these tag values in the request, Amazon Redshift
        /// returns a response with the security groups that have either or both of these tag values
        /// associated with them.</p>
        pub fn set_tag_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_values(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeClusterSnapshots`.
    ///
    /// <p>Returns one or more snapshot objects, which contain metadata about your cluster
    /// snapshots. By default, this operation returns information about all snapshots of all
    /// clusters that are owned by your Amazon Web Services account. No information is returned for
    /// snapshots owned by inactive Amazon Web Services accounts.</p>
    /// <p>If you specify both tag keys and tag values in the same request, Amazon Redshift returns
    /// all snapshots that match any combination of the specified keys and values. For example,
    /// if you have <code>owner</code> and <code>environment</code> for tag keys, and
    /// <code>admin</code> and <code>test</code> for tag values, all snapshots that have any
    /// combination of those values are returned. Only snapshots that you own are returned in
    /// the response; shared snapshots are not returned with the tag key and tag value request
    /// parameters.</p>
    /// <p>If both tag keys and values are omitted from the request, snapshots are returned
    /// regardless of whether they have tag keys or values associated with them.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeClusterSnapshots<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_cluster_snapshots_input::Builder,
    }
    impl<C, M, R> DescribeClusterSnapshots<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeClusterSnapshots`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeClusterSnapshotsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeClusterSnapshotsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeClusterSnapshotsInputOperationOutputAlias,
                crate::output::DescribeClusterSnapshotsOutput,
                crate::error::DescribeClusterSnapshotsError,
                crate::input::DescribeClusterSnapshotsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the cluster which generated the requested snapshots.</p>
        pub fn cluster_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_identifier(inp);
            self
        }
        /// <p>The identifier of the cluster which generated the requested snapshots.</p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_identifier(input);
            self
        }
        /// <p>The snapshot identifier of the snapshot about which to return
        /// information.</p>
        pub fn snapshot_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.snapshot_identifier(inp);
            self
        }
        /// <p>The snapshot identifier of the snapshot about which to return
        /// information.</p>
        pub fn set_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_snapshot_identifier(input);
            self
        }
        /// <p>The type of snapshots for which you are requesting information. By default,
        /// snapshots of all types are returned.</p>
        /// <p>Valid Values: <code>automated</code> | <code>manual</code>
        /// </p>
        pub fn snapshot_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.snapshot_type(inp);
            self
        }
        /// <p>The type of snapshots for which you are requesting information. By default,
        /// snapshots of all types are returned.</p>
        /// <p>Valid Values: <code>automated</code> | <code>manual</code>
        /// </p>
        pub fn set_snapshot_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_snapshot_type(input);
            self
        }
        /// <p>A value that requests only snapshots created at or after the specified time. The
        /// time value is specified in ISO 8601 format. For more information about ISO 8601, go to
        /// the <a href="http://en.wikipedia.org/wiki/ISO_8601">ISO8601 Wikipedia page.</a>
        /// </p>
        /// <p>Example: <code>2012-07-16T18:00:00Z</code>
        /// </p>
        pub fn start_time(mut self, inp: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.start_time(inp);
            self
        }
        /// <p>A value that requests only snapshots created at or after the specified time. The
        /// time value is specified in ISO 8601 format. For more information about ISO 8601, go to
        /// the <a href="http://en.wikipedia.org/wiki/ISO_8601">ISO8601 Wikipedia page.</a>
        /// </p>
        /// <p>Example: <code>2012-07-16T18:00:00Z</code>
        /// </p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_start_time(input);
            self
        }
        /// <p>A time value that requests only snapshots created at or before the specified time.
        /// The time value is specified in ISO 8601 format. For more information about ISO 8601, go
        /// to the <a href="http://en.wikipedia.org/wiki/ISO_8601">ISO8601 Wikipedia
        /// page.</a>
        /// </p>
        /// <p>Example: <code>2012-07-16T18:00:00Z</code>
        /// </p>
        pub fn end_time(mut self, inp: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.end_time(inp);
            self
        }
        /// <p>A time value that requests only snapshots created at or before the specified time.
        /// The time value is specified in ISO 8601 format. For more information about ISO 8601, go
        /// to the <a href="http://en.wikipedia.org/wiki/ISO_8601">ISO8601 Wikipedia
        /// page.</a>
        /// </p>
        /// <p>Example: <code>2012-07-16T18:00:00Z</code>
        /// </p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_end_time(input);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of
        /// remaining response records exceeds the specified <code>MaxRecords</code> value, a value
        /// is returned in a <code>marker</code> field of the response. You can retrieve the next
        /// set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>100</code>
        /// </p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of
        /// remaining response records exceeds the specified <code>MaxRecords</code> value, a value
        /// is returned in a <code>marker</code> field of the response. You can retrieve the next
        /// set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>100</code>
        /// </p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response
        /// records. When the results of a <a>DescribeClusterSnapshots</a> request exceed
        /// the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the
        /// <code>Marker</code> field of the response. You can retrieve the next set of response
        /// records by providing the returned marker value in the <code>Marker</code> parameter and
        /// retrying the request. </p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response
        /// records. When the results of a <a>DescribeClusterSnapshots</a> request exceed
        /// the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the
        /// <code>Marker</code> field of the response. You can retrieve the next set of response
        /// records by providing the returned marker value in the <code>Marker</code> parameter and
        /// retrying the request. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>The Amazon Web Services account used to create or copy the snapshot. Use this field to
        /// filter the results to snapshots owned by a particular account. To describe snapshots you
        /// own, either specify your Amazon Web Services account, or do not specify the
        /// parameter.</p>
        pub fn owner_account(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.owner_account(inp);
            self
        }
        /// <p>The Amazon Web Services account used to create or copy the snapshot. Use this field to
        /// filter the results to snapshots owned by a particular account. To describe snapshots you
        /// own, either specify your Amazon Web Services account, or do not specify the
        /// parameter.</p>
        pub fn set_owner_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_owner_account(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A tag key or keys for which you want to return all matching cluster snapshots that
        /// are associated with the specified key or keys. For example, suppose that you have
        /// snapshots that are tagged with keys called <code>owner</code> and
        /// <code>environment</code>. If you specify both of these tag keys in the request,
        /// Amazon Redshift returns a response with the snapshots that have either or both of these tag
        /// keys associated with them.</p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>A tag key or keys for which you want to return all matching cluster snapshots that
        /// are associated with the specified key or keys. For example, suppose that you have
        /// snapshots that are tagged with keys called <code>owner</code> and
        /// <code>environment</code>. If you specify both of these tag keys in the request,
        /// Amazon Redshift returns a response with the snapshots that have either or both of these tag
        /// keys associated with them.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
        /// Appends an item to `TagValues`.
        ///
        /// To override the contents of this collection use [`set_tag_values`](Self::set_tag_values).
        ///
        /// <p>A tag value or values for which you want to return all matching cluster snapshots
        /// that are associated with the specified tag value or values. For example, suppose that
        /// you have snapshots that are tagged with values called <code>admin</code> and
        /// <code>test</code>. If you specify both of these tag values in the request, Amazon Redshift
        /// returns a response with the snapshots that have either or both of these tag values
        /// associated with them.</p>
        pub fn tag_values(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_values(inp);
            self
        }
        /// <p>A tag value or values for which you want to return all matching cluster snapshots
        /// that are associated with the specified tag value or values. For example, suppose that
        /// you have snapshots that are tagged with values called <code>admin</code> and
        /// <code>test</code>. If you specify both of these tag values in the request, Amazon Redshift
        /// returns a response with the snapshots that have either or both of these tag values
        /// associated with them.</p>
        pub fn set_tag_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_values(input);
            self
        }
        /// <p>A value that indicates whether to return snapshots only for an existing cluster.
        /// You can perform table-level restore only by using a snapshot of an existing cluster,
        /// that is, a cluster that has not been deleted. Values for this parameter work as follows: </p>
        /// <ul>
        /// <li>
        /// <p>If <code>ClusterExists</code> is set to <code>true</code>,
        /// <code>ClusterIdentifier</code> is required.</p>
        /// </li>
        /// <li>
        /// <p>If <code>ClusterExists</code> is set to <code>false</code> and
        /// <code>ClusterIdentifier</code> isn't specified, all snapshots
        /// associated with deleted clusters (orphaned snapshots) are returned. </p>
        /// </li>
        /// <li>
        /// <p>If <code>ClusterExists</code> is set to <code>false</code> and
        /// <code>ClusterIdentifier</code> is specified for a deleted cluster, snapshots
        /// associated with that cluster are returned.</p>
        /// </li>
        /// <li>
        /// <p>If <code>ClusterExists</code> is set to <code>false</code> and
        /// <code>ClusterIdentifier</code> is specified for an existing cluster, no
        /// snapshots are returned. </p>
        /// </li>
        /// </ul>
        pub fn cluster_exists(mut self, inp: bool) -> Self {
            self.inner = self.inner.cluster_exists(inp);
            self
        }
        /// <p>A value that indicates whether to return snapshots only for an existing cluster.
        /// You can perform table-level restore only by using a snapshot of an existing cluster,
        /// that is, a cluster that has not been deleted. Values for this parameter work as follows: </p>
        /// <ul>
        /// <li>
        /// <p>If <code>ClusterExists</code> is set to <code>true</code>,
        /// <code>ClusterIdentifier</code> is required.</p>
        /// </li>
        /// <li>
        /// <p>If <code>ClusterExists</code> is set to <code>false</code> and
        /// <code>ClusterIdentifier</code> isn't specified, all snapshots
        /// associated with deleted clusters (orphaned snapshots) are returned. </p>
        /// </li>
        /// <li>
        /// <p>If <code>ClusterExists</code> is set to <code>false</code> and
        /// <code>ClusterIdentifier</code> is specified for a deleted cluster, snapshots
        /// associated with that cluster are returned.</p>
        /// </li>
        /// <li>
        /// <p>If <code>ClusterExists</code> is set to <code>false</code> and
        /// <code>ClusterIdentifier</code> is specified for an existing cluster, no
        /// snapshots are returned. </p>
        /// </li>
        /// </ul>
        pub fn set_cluster_exists(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_cluster_exists(input);
            self
        }
        /// Appends an item to `SortingEntities`.
        ///
        /// To override the contents of this collection use [`set_sorting_entities`](Self::set_sorting_entities).
        ///
        /// <p></p>
        pub fn sorting_entities(
            mut self,
            inp: impl Into<crate::model::SnapshotSortingEntity>,
        ) -> Self {
            self.inner = self.inner.sorting_entities(inp);
            self
        }
        /// <p></p>
        pub fn set_sorting_entities(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SnapshotSortingEntity>>,
        ) -> Self {
            self.inner = self.inner.set_sorting_entities(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeClusterSubnetGroups`.
    ///
    /// <p>Returns one or more cluster subnet group objects, which contain metadata about your
    /// cluster subnet groups. By default, this operation returns information about all cluster
    /// subnet groups that are defined in your Amazon Web Services account.</p>
    /// <p>If you specify both tag keys and tag values in the same request, Amazon Redshift returns
    /// all subnet groups that match any combination of the specified keys and values. For
    /// example, if you have <code>owner</code> and <code>environment</code> for tag keys, and
    /// <code>admin</code> and <code>test</code> for tag values, all subnet groups that have
    /// any combination of those values are returned.</p>
    /// <p>If both tag keys and values are omitted from the request, subnet groups are
    /// returned regardless of whether they have tag keys or values associated with
    /// them.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeClusterSubnetGroups<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_cluster_subnet_groups_input::Builder,
    }
    impl<C, M, R> DescribeClusterSubnetGroups<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeClusterSubnetGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeClusterSubnetGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeClusterSubnetGroupsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeClusterSubnetGroupsInputOperationOutputAlias,
                crate::output::DescribeClusterSubnetGroupsOutput,
                crate::error::DescribeClusterSubnetGroupsError,
                crate::input::DescribeClusterSubnetGroupsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the cluster subnet group for which information is requested.</p>
        pub fn cluster_subnet_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_subnet_group_name(inp);
            self
        }
        /// <p>The name of the cluster subnet group for which information is requested.</p>
        pub fn set_cluster_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_subnet_group_name(input);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of
        /// remaining response records exceeds the specified <code>MaxRecords</code> value, a value
        /// is returned in a <code>marker</code> field of the response. You can retrieve the next
        /// set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>100</code>
        /// </p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of
        /// remaining response records exceeds the specified <code>MaxRecords</code> value, a value
        /// is returned in a <code>marker</code> field of the response. You can retrieve the next
        /// set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>100</code>
        /// </p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response
        /// records. When the results of a <a>DescribeClusterSubnetGroups</a> request
        /// exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the
        /// <code>Marker</code> field of the response. You can retrieve the next set of response
        /// records by providing the returned marker value in the <code>Marker</code> parameter and
        /// retrying the request. </p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response
        /// records. When the results of a <a>DescribeClusterSubnetGroups</a> request
        /// exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the
        /// <code>Marker</code> field of the response. You can retrieve the next set of response
        /// records by providing the returned marker value in the <code>Marker</code> parameter and
        /// retrying the request. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A tag key or keys for which you want to return all matching cluster subnet groups
        /// that are associated with the specified key or keys. For example, suppose that you have
        /// subnet groups that are tagged with keys called <code>owner</code> and
        /// <code>environment</code>. If you specify both of these tag keys in the request,
        /// Amazon Redshift returns a response with the subnet groups that have either or both of these
        /// tag keys associated with them.</p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>A tag key or keys for which you want to return all matching cluster subnet groups
        /// that are associated with the specified key or keys. For example, suppose that you have
        /// subnet groups that are tagged with keys called <code>owner</code> and
        /// <code>environment</code>. If you specify both of these tag keys in the request,
        /// Amazon Redshift returns a response with the subnet groups that have either or both of these
        /// tag keys associated with them.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
        /// Appends an item to `TagValues`.
        ///
        /// To override the contents of this collection use [`set_tag_values`](Self::set_tag_values).
        ///
        /// <p>A tag value or values for which you want to return all matching cluster subnet
        /// groups that are associated with the specified tag value or values. For example, suppose
        /// that you have subnet groups that are tagged with values called <code>admin</code> and
        /// <code>test</code>. If you specify both of these tag values in the request, Amazon Redshift
        /// returns a response with the subnet groups that have either or both of these tag values
        /// associated with them.</p>
        pub fn tag_values(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_values(inp);
            self
        }
        /// <p>A tag value or values for which you want to return all matching cluster subnet
        /// groups that are associated with the specified tag value or values. For example, suppose
        /// that you have subnet groups that are tagged with values called <code>admin</code> and
        /// <code>test</code>. If you specify both of these tag values in the request, Amazon Redshift
        /// returns a response with the subnet groups that have either or both of these tag values
        /// associated with them.</p>
        pub fn set_tag_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_values(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeClusterTracks`.
    ///
    /// <p>Returns a list of all the available maintenance tracks.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeClusterTracks<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_cluster_tracks_input::Builder,
    }
    impl<C, M, R> DescribeClusterTracks<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeClusterTracks`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeClusterTracksOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeClusterTracksError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeClusterTracksInputOperationOutputAlias,
                crate::output::DescribeClusterTracksOutput,
                crate::error::DescribeClusterTracksError,
                crate::input::DescribeClusterTracksInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the maintenance track. </p>
        pub fn maintenance_track_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.maintenance_track_name(inp);
            self
        }
        /// <p>The name of the maintenance track. </p>
        pub fn set_maintenance_track_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_maintenance_track_name(input);
            self
        }
        /// <p>An integer value for the maximum number of maintenance tracks to return.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p>An integer value for the maximum number of maintenance tracks to return.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response
        /// records. When the results of a <code>DescribeClusterTracks</code> request exceed the
        /// value specified in <code>MaxRecords</code>, Amazon Redshift returns a value in the
        /// <code>Marker</code> field of the response. You can retrieve the next set of response
        /// records by providing the returned marker value in the <code>Marker</code> parameter and
        /// retrying the request. </p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response
        /// records. When the results of a <code>DescribeClusterTracks</code> request exceed the
        /// value specified in <code>MaxRecords</code>, Amazon Redshift returns a value in the
        /// <code>Marker</code> field of the response. You can retrieve the next set of response
        /// records by providing the returned marker value in the <code>Marker</code> parameter and
        /// retrying the request. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeClusterVersions`.
    ///
    /// <p>Returns descriptions of the available Amazon Redshift cluster versions. You can call this
    /// operation even before creating any clusters to learn more about the Amazon Redshift versions.
    ///
    /// For more information about managing clusters, go to
    /// <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html">Amazon Redshift Clusters</a>
    /// in the <i>Amazon Redshift Cluster Management Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeClusterVersions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_cluster_versions_input::Builder,
    }
    impl<C, M, R> DescribeClusterVersions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeClusterVersions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeClusterVersionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeClusterVersionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeClusterVersionsInputOperationOutputAlias,
                crate::output::DescribeClusterVersionsOutput,
                crate::error::DescribeClusterVersionsError,
                crate::input::DescribeClusterVersionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The specific cluster version to return.</p>
        /// <p>Example: <code>1.0</code>
        /// </p>
        pub fn cluster_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_version(inp);
            self
        }
        /// <p>The specific cluster version to return.</p>
        /// <p>Example: <code>1.0</code>
        /// </p>
        pub fn set_cluster_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_version(input);
            self
        }
        /// <p>The name of a specific cluster parameter group family to return details
        /// for.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be 1 to 255 alphanumeric characters</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens</p>
        /// </li>
        /// </ul>
        pub fn cluster_parameter_group_family(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.cluster_parameter_group_family(inp);
            self
        }
        /// <p>The name of a specific cluster parameter group family to return details
        /// for.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be 1 to 255 alphanumeric characters</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens</p>
        /// </li>
        /// </ul>
        pub fn set_cluster_parameter_group_family(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_parameter_group_family(input);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of
        /// remaining response records exceeds the specified <code>MaxRecords</code> value, a value
        /// is returned in a <code>marker</code> field of the response. You can retrieve the next
        /// set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>100</code>
        /// </p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of
        /// remaining response records exceeds the specified <code>MaxRecords</code> value, a value
        /// is returned in a <code>marker</code> field of the response. You can retrieve the next
        /// set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>100</code>
        /// </p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response
        /// records. When the results of a <a>DescribeClusterVersions</a> request exceed
        /// the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the
        /// <code>Marker</code> field of the response. You can retrieve the next set of response
        /// records by providing the returned marker value in the <code>Marker</code> parameter and
        /// retrying the request. </p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response
        /// records. When the results of a <a>DescribeClusterVersions</a> request exceed
        /// the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the
        /// <code>Marker</code> field of the response. You can retrieve the next set of response
        /// records by providing the returned marker value in the <code>Marker</code> parameter and
        /// retrying the request. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDataShares`.
    ///
    /// <p>Shows the status of any inbound or outbound datashares available in the specified
    /// account.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeDataShares<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_data_shares_input::Builder,
    }
    impl<C, M, R> DescribeDataShares<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDataShares`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDataSharesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDataSharesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDataSharesInputOperationOutputAlias,
                crate::output::DescribeDataSharesOutput,
                crate::error::DescribeDataSharesError,
                crate::input::DescribeDataSharesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the datashare to describe details of.</p>
        pub fn data_share_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_share_arn(inp);
            self
        }
        /// <p>The identifier of the datashare to describe details of.</p>
        pub fn set_data_share_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_data_share_arn(input);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of
        /// remaining response records exceeds the specified <code>MaxRecords</code> value, a value
        /// is returned in a <code>marker</code> field of the response. You can retrieve the next
        /// set of records by retrying the command with the returned marker value. </p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of
        /// remaining response records exceeds the specified <code>MaxRecords</code> value, a value
        /// is returned in a <code>marker</code> field of the response. You can retrieve the next
        /// set of records by retrying the command with the returned marker value. </p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <a>DescribeDataShares</a> request exceed the value specified in <code>MaxRecords</code>, AWS returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <a>DescribeDataShares</a> request exceed the value specified in <code>MaxRecords</code>, AWS returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDataSharesForConsumer`.
    ///
    /// <p>Returns a list of datashares where the account identifier being called is a consumer account identifier.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeDataSharesForConsumer<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_data_shares_for_consumer_input::Builder,
    }
    impl<C, M, R> DescribeDataSharesForConsumer<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDataSharesForConsumer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDataSharesForConsumerOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDataSharesForConsumerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDataSharesForConsumerInputOperationOutputAlias,
                crate::output::DescribeDataSharesForConsumerOutput,
                crate::error::DescribeDataSharesForConsumerError,
                crate::input::DescribeDataSharesForConsumerInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the consumer that returns in the list of datashares.</p>
        pub fn consumer_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.consumer_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the consumer that returns in the list of datashares.</p>
        pub fn set_consumer_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_consumer_arn(input);
            self
        }
        /// <p>An identifier giving the status of a datashare in the consumer cluster. If this field is specified, Amazon
        /// Redshift returns the list of datashares that have the specified status.</p>
        pub fn status(mut self, inp: crate::model::DataShareStatusForConsumer) -> Self {
            self.inner = self.inner.status(inp);
            self
        }
        /// <p>An identifier giving the status of a datashare in the consumer cluster. If this field is specified, Amazon
        /// Redshift returns the list of datashares that have the specified status.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::DataShareStatusForConsumer>,
        ) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of
        /// remaining response records exceeds the specified <code>MaxRecords</code> value, a value
        /// is returned in a <code>marker</code> field of the response. You can retrieve the next
        /// set of records by retrying the command with the returned marker value. </p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of
        /// remaining response records exceeds the specified <code>MaxRecords</code> value, a value
        /// is returned in a <code>marker</code> field of the response. You can retrieve the next
        /// set of records by retrying the command with the returned marker value. </p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response
        /// records. When the results of a <a>DescribeDataSharesForConsumer</a> request
        /// exceed the value specified in <code>MaxRecords</code>, AWS returns a value in the
        /// <code>Marker</code> field of the response. You can retrieve the next set of response
        /// records by providing the returned marker value in the <code>Marker</code> parameter and
        /// retrying the request. </p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response
        /// records. When the results of a <a>DescribeDataSharesForConsumer</a> request
        /// exceed the value specified in <code>MaxRecords</code>, AWS returns a value in the
        /// <code>Marker</code> field of the response. You can retrieve the next set of response
        /// records by providing the returned marker value in the <code>Marker</code> parameter and
        /// retrying the request. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDataSharesForProducer`.
    ///
    /// <p>Returns a list of datashares when the account identifier being called is a producer account identifier.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeDataSharesForProducer<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_data_shares_for_producer_input::Builder,
    }
    impl<C, M, R> DescribeDataSharesForProducer<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDataSharesForProducer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDataSharesForProducerOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDataSharesForProducerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDataSharesForProducerInputOperationOutputAlias,
                crate::output::DescribeDataSharesForProducerOutput,
                crate::error::DescribeDataSharesForProducerError,
                crate::input::DescribeDataSharesForProducerInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the producer that returns in the list of datashares.</p>
        pub fn producer_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.producer_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the producer that returns in the list of datashares.</p>
        pub fn set_producer_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_producer_arn(input);
            self
        }
        /// <p>An identifier giving the status of a datashare in the producer. If this field is specified, Amazon
        /// Redshift returns the list of datashares that have the specified status.</p>
        pub fn status(mut self, inp: crate::model::DataShareStatusForProducer) -> Self {
            self.inner = self.inner.status(inp);
            self
        }
        /// <p>An identifier giving the status of a datashare in the producer. If this field is specified, Amazon
        /// Redshift returns the list of datashares that have the specified status.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::DataShareStatusForProducer>,
        ) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of
        /// remaining response records exceeds the specified <code>MaxRecords</code> value, a value
        /// is returned in a <code>marker</code> field of the response. You can retrieve the next
        /// set of records by retrying the command with the returned marker value. </p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of
        /// remaining response records exceeds the specified <code>MaxRecords</code> value, a value
        /// is returned in a <code>marker</code> field of the response. You can retrieve the next
        /// set of records by retrying the command with the returned marker value. </p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response
        /// records. When the results of a <a>DescribeDataSharesForProducer</a> request
        /// exceed the value specified in <code>MaxRecords</code>, AWS returns a value in the
        /// <code>Marker</code> field of the response. You can retrieve the next set of response
        /// records by providing the returned marker value in the <code>Marker</code> parameter and
        /// retrying the request. </p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response
        /// records. When the results of a <a>DescribeDataSharesForProducer</a> request
        /// exceed the value specified in <code>MaxRecords</code>, AWS returns a value in the
        /// <code>Marker</code> field of the response. You can retrieve the next set of response
        /// records by providing the returned marker value in the <code>Marker</code> parameter and
        /// retrying the request. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDefaultClusterParameters`.
    ///
    /// <p>Returns a list of parameter settings for the specified parameter group
    /// family.</p>
    /// <p>
    /// For more information about parameters and parameter groups, go to
    /// <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Amazon Redshift Parameter Groups</a>
    /// in the <i>Amazon Redshift Cluster Management Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeDefaultClusterParameters<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_default_cluster_parameters_input::Builder,
    }
    impl<C, M, R> DescribeDefaultClusterParameters<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDefaultClusterParameters`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDefaultClusterParametersOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDefaultClusterParametersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDefaultClusterParametersInputOperationOutputAlias,
                crate::output::DescribeDefaultClusterParametersOutput,
                crate::error::DescribeDefaultClusterParametersError,
                crate::input::DescribeDefaultClusterParametersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the cluster parameter group family.</p>
        pub fn parameter_group_family(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.parameter_group_family(inp);
            self
        }
        /// <p>The name of the cluster parameter group family.</p>
        pub fn set_parameter_group_family(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_parameter_group_family(input);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of
        /// remaining response records exceeds the specified <code>MaxRecords</code> value, a value
        /// is returned in a <code>marker</code> field of the response. You can retrieve the next
        /// set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>100</code>
        /// </p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of
        /// remaining response records exceeds the specified <code>MaxRecords</code> value, a value
        /// is returned in a <code>marker</code> field of the response. You can retrieve the next
        /// set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>100</code>
        /// </p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response
        /// records. When the results of a <a>DescribeDefaultClusterParameters</a>
        /// request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in
        /// the <code>Marker</code> field of the response. You can retrieve the next set of response
        /// records by providing the returned marker value in the <code>Marker</code> parameter and
        /// retrying the request. </p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response
        /// records. When the results of a <a>DescribeDefaultClusterParameters</a>
        /// request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in
        /// the <code>Marker</code> field of the response. You can retrieve the next set of response
        /// records by providing the returned marker value in the <code>Marker</code> parameter and
        /// retrying the request. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEndpointAccess`.
    ///
    /// <p>Describes a Redshift-managed VPC endpoint.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeEndpointAccess<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_endpoint_access_input::Builder,
    }
    impl<C, M, R> DescribeEndpointAccess<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeEndpointAccess`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEndpointAccessOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeEndpointAccessError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeEndpointAccessInputOperationOutputAlias,
                crate::output::DescribeEndpointAccessOutput,
                crate::error::DescribeEndpointAccessError,
                crate::input::DescribeEndpointAccessInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The cluster identifier associated with the described endpoint.</p>
        pub fn cluster_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_identifier(inp);
            self
        }
        /// <p>The cluster identifier associated with the described endpoint.</p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_identifier(input);
            self
        }
        /// <p>The Amazon Web Services account ID of the owner of the cluster.</p>
        pub fn resource_owner(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_owner(inp);
            self
        }
        /// <p>The Amazon Web Services account ID of the owner of the cluster.</p>
        pub fn set_resource_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_owner(input);
            self
        }
        /// <p>The name of the endpoint to be described.</p>
        pub fn endpoint_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.endpoint_name(inp);
            self
        }
        /// <p>The name of the endpoint to be described.</p>
        pub fn set_endpoint_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_endpoint_name(input);
            self
        }
        /// <p>The virtual private cloud (VPC) identifier with access to the cluster.</p>
        pub fn vpc_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc_id(inp);
            self
        }
        /// <p>The virtual private cloud (VPC) identifier with access to the cluster.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_vpc_id(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist
        /// than the specified <code>MaxRecords</code> value, a pagination token called a <code>Marker</code> is
        /// included in the response so that the remaining results can be retrieved.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist
        /// than the specified <code>MaxRecords</code> value, a pagination token called a <code>Marker</code> is
        /// included in the response so that the remaining results can be retrieved.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>An optional pagination token provided by a previous
        /// <code>DescribeEndpointAccess</code> request. If this parameter is specified, the
        /// response includes only records beyond the marker, up to the value specified by the
        /// <code>MaxRecords</code> parameter.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>An optional pagination token provided by a previous
        /// <code>DescribeEndpointAccess</code> request. If this parameter is specified, the
        /// response includes only records beyond the marker, up to the value specified by the
        /// <code>MaxRecords</code> parameter.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEndpointAuthorization`.
    ///
    /// <p>Describes an endpoint authorization.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeEndpointAuthorization<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_endpoint_authorization_input::Builder,
    }
    impl<C, M, R> DescribeEndpointAuthorization<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeEndpointAuthorization`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEndpointAuthorizationOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeEndpointAuthorizationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeEndpointAuthorizationInputOperationOutputAlias,
                crate::output::DescribeEndpointAuthorizationOutput,
                crate::error::DescribeEndpointAuthorizationError,
                crate::input::DescribeEndpointAuthorizationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The cluster identifier of the cluster to access.</p>
        pub fn cluster_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_identifier(inp);
            self
        }
        /// <p>The cluster identifier of the cluster to access.</p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_identifier(input);
            self
        }
        /// <p>The AAmazon Web Services account ID of either the cluster owner (grantor) or grantee.
        /// If <code>Grantee</code> parameter is true, then the <code>Account</code> value is of the grantor.</p>
        pub fn account(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account(inp);
            self
        }
        /// <p>The AAmazon Web Services account ID of either the cluster owner (grantor) or grantee.
        /// If <code>Grantee</code> parameter is true, then the <code>Account</code> value is of the grantor.</p>
        pub fn set_account(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account(input);
            self
        }
        /// <p>Indicates whether to check authorization from a grantor or grantee point of view.
        /// If true, Amazon Redshift returns endpoint authorizations that you've been granted.
        /// If false (default), checks authorization from a grantor point of view.</p>
        pub fn grantee(mut self, inp: bool) -> Self {
            self.inner = self.inner.grantee(inp);
            self
        }
        /// <p>Indicates whether to check authorization from a grantor or grantee point of view.
        /// If true, Amazon Redshift returns endpoint authorizations that you've been granted.
        /// If false (default), checks authorization from a grantor point of view.</p>
        pub fn set_grantee(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_grantee(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist
        /// than the specified <code>MaxRecords</code> value, a pagination token called a <code>Marker</code> is
        /// included in the response so that the remaining results can be retrieved.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist
        /// than the specified <code>MaxRecords</code> value, a pagination token called a <code>Marker</code> is
        /// included in the response so that the remaining results can be retrieved.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>An optional pagination token provided by a previous
        /// <code>DescribeEndpointAuthorization</code> request. If this parameter is specified, the
        /// response includes only records beyond the marker, up to the value specified by the
        /// <code>MaxRecords</code> parameter.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>An optional pagination token provided by a previous
        /// <code>DescribeEndpointAuthorization</code> request. If this parameter is specified, the
        /// response includes only records beyond the marker, up to the value specified by the
        /// <code>MaxRecords</code> parameter.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEventCategories`.
    ///
    /// <p>Displays a list of event categories for all event source types, or for a specified
    /// source type. For a list of the event categories and source types, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-event-notifications.html">Amazon Redshift Event
    /// Notifications</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeEventCategories<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_event_categories_input::Builder,
    }
    impl<C, M, R> DescribeEventCategories<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeEventCategories`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEventCategoriesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeEventCategoriesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeEventCategoriesInputOperationOutputAlias,
                crate::output::DescribeEventCategoriesOutput,
                crate::error::DescribeEventCategoriesError,
                crate::input::DescribeEventCategoriesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The source type, such as cluster or parameter group, to which the described event
        /// categories apply.</p>
        /// <p>Valid values: cluster, cluster-snapshot, cluster-parameter-group, cluster-security-group, and scheduled-action.</p>
        pub fn source_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_type(inp);
            self
        }
        /// <p>The source type, such as cluster or parameter group, to which the described event
        /// categories apply.</p>
        /// <p>Valid values: cluster, cluster-snapshot, cluster-parameter-group, cluster-security-group, and scheduled-action.</p>
        pub fn set_source_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_source_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEvents`.
    ///
    /// <p>Returns events related to clusters, security groups, snapshots, and parameter
    /// groups for the past 14 days. Events specific to a particular cluster, security group,
    /// snapshot or parameter group can be obtained by providing the name as a parameter. By
    /// default, the past hour of events are returned.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeEvents<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_events_input::Builder,
    }
    impl<C, M, R> DescribeEvents<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeEvents`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEventsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeEventsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeEventsInputOperationOutputAlias,
                crate::output::DescribeEventsOutput,
                crate::error::DescribeEventsError,
                crate::input::DescribeEventsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the event source for which events will be returned. If this
        /// parameter is not specified, then all sources are included in the response.</p>
        /// <p>Constraints:</p>
        /// <p>If <i>SourceIdentifier</i> is supplied,
        /// <i>SourceType</i> must also be provided.</p>
        /// <ul>
        /// <li>
        /// <p>Specify a cluster identifier when <i>SourceType</i> is
        /// <code>cluster</code>.</p>
        /// </li>
        /// <li>
        /// <p>Specify a cluster security group name when <i>SourceType</i>
        /// is <code>cluster-security-group</code>.</p>
        /// </li>
        /// <li>
        /// <p>Specify a cluster parameter group name when <i>SourceType</i>
        /// is <code>cluster-parameter-group</code>.</p>
        /// </li>
        /// <li>
        /// <p>Specify a cluster snapshot identifier when <i>SourceType</i>
        /// is <code>cluster-snapshot</code>.</p>
        /// </li>
        /// </ul>
        pub fn source_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_identifier(inp);
            self
        }
        /// <p>The identifier of the event source for which events will be returned. If this
        /// parameter is not specified, then all sources are included in the response.</p>
        /// <p>Constraints:</p>
        /// <p>If <i>SourceIdentifier</i> is supplied,
        /// <i>SourceType</i> must also be provided.</p>
        /// <ul>
        /// <li>
        /// <p>Specify a cluster identifier when <i>SourceType</i> is
        /// <code>cluster</code>.</p>
        /// </li>
        /// <li>
        /// <p>Specify a cluster security group name when <i>SourceType</i>
        /// is <code>cluster-security-group</code>.</p>
        /// </li>
        /// <li>
        /// <p>Specify a cluster parameter group name when <i>SourceType</i>
        /// is <code>cluster-parameter-group</code>.</p>
        /// </li>
        /// <li>
        /// <p>Specify a cluster snapshot identifier when <i>SourceType</i>
        /// is <code>cluster-snapshot</code>.</p>
        /// </li>
        /// </ul>
        pub fn set_source_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_identifier(input);
            self
        }
        /// <p>The event source to retrieve events for. If no value is specified, all events are
        /// returned.</p>
        /// <p>Constraints:</p>
        /// <p>If <i>SourceType</i> is supplied,
        /// <i>SourceIdentifier</i> must also be provided.</p>
        /// <ul>
        /// <li>
        /// <p>Specify <code>cluster</code> when <i>SourceIdentifier</i> is
        /// a cluster identifier.</p>
        /// </li>
        /// <li>
        /// <p>Specify <code>cluster-security-group</code> when
        /// <i>SourceIdentifier</i> is a cluster security group
        /// name.</p>
        /// </li>
        /// <li>
        /// <p>Specify <code>cluster-parameter-group</code> when
        /// <i>SourceIdentifier</i> is a cluster parameter group
        /// name.</p>
        /// </li>
        /// <li>
        /// <p>Specify <code>cluster-snapshot</code> when
        /// <i>SourceIdentifier</i> is a cluster snapshot
        /// identifier.</p>
        /// </li>
        /// </ul>
        pub fn source_type(mut self, inp: crate::model::SourceType) -> Self {
            self.inner = self.inner.source_type(inp);
            self
        }
        /// <p>The event source to retrieve events for. If no value is specified, all events are
        /// returned.</p>
        /// <p>Constraints:</p>
        /// <p>If <i>SourceType</i> is supplied,
        /// <i>SourceIdentifier</i> must also be provided.</p>
        /// <ul>
        /// <li>
        /// <p>Specify <code>cluster</code> when <i>SourceIdentifier</i> is
        /// a cluster identifier.</p>
        /// </li>
        /// <li>
        /// <p>Specify <code>cluster-security-group</code> when
        /// <i>SourceIdentifier</i> is a cluster security group
        /// name.</p>
        /// </li>
        /// <li>
        /// <p>Specify <code>cluster-parameter-group</code> when
        /// <i>SourceIdentifier</i> is a cluster parameter group
        /// name.</p>
        /// </li>
        /// <li>
        /// <p>Specify <code>cluster-snapshot</code> when
        /// <i>SourceIdentifier</i> is a cluster snapshot
        /// identifier.</p>
        /// </li>
        /// </ul>
        pub fn set_source_type(
            mut self,
            input: std::option::Option<crate::model::SourceType>,
        ) -> Self {
            self.inner = self.inner.set_source_type(input);
            self
        }
        /// <p>The beginning of the time interval to retrieve events for, specified in ISO 8601
        /// format. For more information about ISO 8601, go to the <a href="http://en.wikipedia.org/wiki/ISO_8601">ISO8601 Wikipedia page.</a>
        /// </p>
        /// <p>Example: <code>2009-07-08T18:00Z</code>
        /// </p>
        pub fn start_time(mut self, inp: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.start_time(inp);
            self
        }
        /// <p>The beginning of the time interval to retrieve events for, specified in ISO 8601
        /// format. For more information about ISO 8601, go to the <a href="http://en.wikipedia.org/wiki/ISO_8601">ISO8601 Wikipedia page.</a>
        /// </p>
        /// <p>Example: <code>2009-07-08T18:00Z</code>
        /// </p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_start_time(input);
            self
        }
        /// <p>The end of the time interval for which to retrieve events, specified in ISO 8601
        /// format. For more information about ISO 8601, go to the <a href="http://en.wikipedia.org/wiki/ISO_8601">ISO8601 Wikipedia page.</a>
        /// </p>
        /// <p>Example: <code>2009-07-08T18:00Z</code>
        /// </p>
        pub fn end_time(mut self, inp: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.end_time(inp);
            self
        }
        /// <p>The end of the time interval for which to retrieve events, specified in ISO 8601
        /// format. For more information about ISO 8601, go to the <a href="http://en.wikipedia.org/wiki/ISO_8601">ISO8601 Wikipedia page.</a>
        /// </p>
        /// <p>Example: <code>2009-07-08T18:00Z</code>
        /// </p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_end_time(input);
            self
        }
        /// <p>The number of minutes prior to the time of the request for which to retrieve
        /// events. For example, if the request is sent at 18:00 and you specify a duration of 60,
        /// then only events which have occurred after 17:00 will be returned.</p>
        /// <p>Default: <code>60</code>
        /// </p>
        pub fn duration(mut self, inp: i32) -> Self {
            self.inner = self.inner.duration(inp);
            self
        }
        /// <p>The number of minutes prior to the time of the request for which to retrieve
        /// events. For example, if the request is sent at 18:00 and you specify a duration of 60,
        /// then only events which have occurred after 17:00 will be returned.</p>
        /// <p>Default: <code>60</code>
        /// </p>
        pub fn set_duration(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_duration(input);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of
        /// remaining response records exceeds the specified <code>MaxRecords</code> value, a value
        /// is returned in a <code>marker</code> field of the response. You can retrieve the next
        /// set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>100</code>
        /// </p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of
        /// remaining response records exceeds the specified <code>MaxRecords</code> value, a value
        /// is returned in a <code>marker</code> field of the response. You can retrieve the next
        /// set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>100</code>
        /// </p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response
        /// records. When the results of a <a>DescribeEvents</a> request exceed the value
        /// specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code>
        /// field of the response. You can retrieve the next set of response records by providing
        /// the returned marker value in the <code>Marker</code> parameter and retrying the request.
        /// </p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response
        /// records. When the results of a <a>DescribeEvents</a> request exceed the value
        /// specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code>
        /// field of the response. You can retrieve the next set of response records by providing
        /// the returned marker value in the <code>Marker</code> parameter and retrying the request.
        /// </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEventSubscriptions`.
    ///
    /// <p>Lists descriptions of all the Amazon Redshift event notification subscriptions for a
    /// customer account. If you specify a subscription name, lists the description for that
    /// subscription.</p>
    /// <p>If you specify both tag keys and tag values in the same request, Amazon Redshift returns
    /// all event notification subscriptions that match any combination of the specified keys
    /// and values. For example, if you have <code>owner</code> and <code>environment</code> for
    /// tag keys, and <code>admin</code> and <code>test</code> for tag values, all subscriptions
    /// that have any combination of those values are returned.</p>
    /// <p>If both tag keys and values are omitted from the request, subscriptions are
    /// returned regardless of whether they have tag keys or values associated with
    /// them.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeEventSubscriptions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_event_subscriptions_input::Builder,
    }
    impl<C, M, R> DescribeEventSubscriptions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeEventSubscriptions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEventSubscriptionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeEventSubscriptionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeEventSubscriptionsInputOperationOutputAlias,
                crate::output::DescribeEventSubscriptionsOutput,
                crate::error::DescribeEventSubscriptionsError,
                crate::input::DescribeEventSubscriptionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Amazon Redshift event notification subscription to be
        /// described.</p>
        pub fn subscription_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subscription_name(inp);
            self
        }
        /// <p>The name of the Amazon Redshift event notification subscription to be
        /// described.</p>
        pub fn set_subscription_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_subscription_name(input);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of
        /// remaining response records exceeds the specified <code>MaxRecords</code> value, a value
        /// is returned in a <code>marker</code> field of the response. You can retrieve the next
        /// set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>100</code>
        /// </p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of
        /// remaining response records exceeds the specified <code>MaxRecords</code> value, a value
        /// is returned in a <code>marker</code> field of the response. You can retrieve the next
        /// set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>100</code>
        /// </p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response
        /// records. When the results of a DescribeEventSubscriptions request exceed the value
        /// specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code>
        /// field of the response. You can retrieve the next set of response records by providing
        /// the returned marker value in the <code>Marker</code> parameter and retrying the request.
        /// </p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response
        /// records. When the results of a DescribeEventSubscriptions request exceed the value
        /// specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code>
        /// field of the response. You can retrieve the next set of response records by providing
        /// the returned marker value in the <code>Marker</code> parameter and retrying the request.
        /// </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A tag key or keys for which you want to return all matching event notification
        /// subscriptions that are associated with the specified key or keys. For example, suppose
        /// that you have subscriptions that are tagged with keys called <code>owner</code> and
        /// <code>environment</code>. If you specify both of these tag keys in the request,
        /// Amazon Redshift returns a response with the subscriptions that have either or both of these
        /// tag keys associated with them.</p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>A tag key or keys for which you want to return all matching event notification
        /// subscriptions that are associated with the specified key or keys. For example, suppose
        /// that you have subscriptions that are tagged with keys called <code>owner</code> and
        /// <code>environment</code>. If you specify both of these tag keys in the request,
        /// Amazon Redshift returns a response with the subscriptions that have either or both of these
        /// tag keys associated with them.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
        /// Appends an item to `TagValues`.
        ///
        /// To override the contents of this collection use [`set_tag_values`](Self::set_tag_values).
        ///
        /// <p>A tag value or values for which you want to return all matching event notification
        /// subscriptions that are associated with the specified tag value or values. For example,
        /// suppose that you have subscriptions that are tagged with values called
        /// <code>admin</code> and <code>test</code>. If you specify both of these tag values in
        /// the request, Amazon Redshift returns a response with the subscriptions that have either or
        /// both of these tag values associated with them.</p>
        pub fn tag_values(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_values(inp);
            self
        }
        /// <p>A tag value or values for which you want to return all matching event notification
        /// subscriptions that are associated with the specified tag value or values. For example,
        /// suppose that you have subscriptions that are tagged with values called
        /// <code>admin</code> and <code>test</code>. If you specify both of these tag values in
        /// the request, Amazon Redshift returns a response with the subscriptions that have either or
        /// both of these tag values associated with them.</p>
        pub fn set_tag_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_values(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeHsmClientCertificates`.
    ///
    /// <p>Returns information about the specified HSM client certificate. If no certificate
    /// ID is specified, returns information about all the HSM certificates owned by your Amazon Web Services account.</p>
    /// <p>If you specify both tag keys and tag values in the same request, Amazon Redshift returns
    /// all HSM client certificates that match any combination of the specified keys and values.
    /// For example, if you have <code>owner</code> and <code>environment</code> for tag keys,
    /// and <code>admin</code> and <code>test</code> for tag values, all HSM client certificates
    /// that have any combination of those values are returned.</p>
    /// <p>If both tag keys and values are omitted from the request, HSM client certificates
    /// are returned regardless of whether they have tag keys or values associated with
    /// them.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeHsmClientCertificates<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_hsm_client_certificates_input::Builder,
    }
    impl<C, M, R> DescribeHsmClientCertificates<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeHsmClientCertificates`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeHsmClientCertificatesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeHsmClientCertificatesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeHsmClientCertificatesInputOperationOutputAlias,
                crate::output::DescribeHsmClientCertificatesOutput,
                crate::error::DescribeHsmClientCertificatesError,
                crate::input::DescribeHsmClientCertificatesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of a specific HSM client certificate for which you want information.
        /// If no identifier is specified, information is returned for all HSM client certificates
        /// owned by your Amazon Web Services account.</p>
        pub fn hsm_client_certificate_identifier(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.hsm_client_certificate_identifier(inp);
            self
        }
        /// <p>The identifier of a specific HSM client certificate for which you want information.
        /// If no identifier is specified, information is returned for all HSM client certificates
        /// owned by your Amazon Web Services account.</p>
        pub fn set_hsm_client_certificate_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_hsm_client_certificate_identifier(input);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of
        /// remaining response records exceeds the specified <code>MaxRecords</code> value, a value
        /// is returned in a <code>marker</code> field of the response. You can retrieve the next
        /// set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>100</code>
        /// </p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of
        /// remaining response records exceeds the specified <code>MaxRecords</code> value, a value
        /// is returned in a <code>marker</code> field of the response. You can retrieve the next
        /// set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>100</code>
        /// </p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response
        /// records. When the results of a <a>DescribeHsmClientCertificates</a> request
        /// exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the
        /// <code>Marker</code> field of the response. You can retrieve the next set of response
        /// records by providing the returned marker value in the <code>Marker</code> parameter and
        /// retrying the request. </p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response
        /// records. When the results of a <a>DescribeHsmClientCertificates</a> request
        /// exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the
        /// <code>Marker</code> field of the response. You can retrieve the next set of response
        /// records by providing the returned marker value in the <code>Marker</code> parameter and
        /// retrying the request. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A tag key or keys for which you want to return all matching HSM client certificates
        /// that are associated with the specified key or keys. For example, suppose that you have
        /// HSM client certificates that are tagged with keys called <code>owner</code> and
        /// <code>environment</code>. If you specify both of these tag keys in the request,
        /// Amazon Redshift returns a response with the HSM client certificates that have either or both
        /// of these tag keys associated with them.</p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>A tag key or keys for which you want to return all matching HSM client certificates
        /// that are associated with the specified key or keys. For example, suppose that you have
        /// HSM client certificates that are tagged with keys called <code>owner</code> and
        /// <code>environment</code>. If you specify both of these tag keys in the request,
        /// Amazon Redshift returns a response with the HSM client certificates that have either or both
        /// of these tag keys associated with them.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
        /// Appends an item to `TagValues`.
        ///
        /// To override the contents of this collection use [`set_tag_values`](Self::set_tag_values).
        ///
        /// <p>A tag value or values for which you want to return all matching HSM client
        /// certificates that are associated with the specified tag value or values. For example,
        /// suppose that you have HSM client certificates that are tagged with values called
        /// <code>admin</code> and <code>test</code>. If you specify both of these tag values in
        /// the request, Amazon Redshift returns a response with the HSM client certificates that have
        /// either or both of these tag values associated with them.</p>
        pub fn tag_values(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_values(inp);
            self
        }
        /// <p>A tag value or values for which you want to return all matching HSM client
        /// certificates that are associated with the specified tag value or values. For example,
        /// suppose that you have HSM client certificates that are tagged with values called
        /// <code>admin</code> and <code>test</code>. If you specify both of these tag values in
        /// the request, Amazon Redshift returns a response with the HSM client certificates that have
        /// either or both of these tag values associated with them.</p>
        pub fn set_tag_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_values(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeHsmConfigurations`.
    ///
    /// <p>Returns information about the specified Amazon Redshift HSM configuration. If no
    /// configuration ID is specified, returns information about all the HSM configurations
    /// owned by your Amazon Web Services account.</p>
    /// <p>If you specify both tag keys and tag values in the same request, Amazon Redshift returns
    /// all HSM connections that match any combination of the specified keys and values. For
    /// example, if you have <code>owner</code> and <code>environment</code> for tag keys, and
    /// <code>admin</code> and <code>test</code> for tag values, all HSM connections that
    /// have any combination of those values are returned.</p>
    /// <p>If both tag keys and values are omitted from the request, HSM connections are
    /// returned regardless of whether they have tag keys or values associated with
    /// them.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeHsmConfigurations<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_hsm_configurations_input::Builder,
    }
    impl<C, M, R> DescribeHsmConfigurations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeHsmConfigurations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeHsmConfigurationsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeHsmConfigurationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeHsmConfigurationsInputOperationOutputAlias,
                crate::output::DescribeHsmConfigurationsOutput,
                crate::error::DescribeHsmConfigurationsError,
                crate::input::DescribeHsmConfigurationsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of a specific Amazon Redshift HSM configuration to be described. If no
        /// identifier is specified, information is returned for all HSM configurations owned by
        /// your Amazon Web Services account.</p>
        pub fn hsm_configuration_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hsm_configuration_identifier(inp);
            self
        }
        /// <p>The identifier of a specific Amazon Redshift HSM configuration to be described. If no
        /// identifier is specified, information is returned for all HSM configurations owned by
        /// your Amazon Web Services account.</p>
        pub fn set_hsm_configuration_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_hsm_configuration_identifier(input);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of
        /// remaining response records exceeds the specified <code>MaxRecords</code> value, a value
        /// is returned in a <code>marker</code> field of the response. You can retrieve the next
        /// set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>100</code>
        /// </p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of
        /// remaining response records exceeds the specified <code>MaxRecords</code> value, a value
        /// is returned in a <code>marker</code> field of the response. You can retrieve the next
        /// set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>100</code>
        /// </p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response
        /// records. When the results of a <a>DescribeHsmConfigurations</a> request
        /// exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the
        /// <code>Marker</code> field of the response. You can retrieve the next set of response
        /// records by providing the returned marker value in the <code>Marker</code> parameter and
        /// retrying the request. </p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response
        /// records. When the results of a <a>DescribeHsmConfigurations</a> request
        /// exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the
        /// <code>Marker</code> field of the response. You can retrieve the next set of response
        /// records by providing the returned marker value in the <code>Marker</code> parameter and
        /// retrying the request. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A tag key or keys for which you want to return all matching HSM configurations that
        /// are associated with the specified key or keys. For example, suppose that you have HSM
        /// configurations that are tagged with keys called <code>owner</code> and
        /// <code>environment</code>. If you specify both of these tag keys in the request,
        /// Amazon Redshift returns a response with the HSM configurations that have either or both of
        /// these tag keys associated with them.</p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>A tag key or keys for which you want to return all matching HSM configurations that
        /// are associated with the specified key or keys. For example, suppose that you have HSM
        /// configurations that are tagged with keys called <code>owner</code> and
        /// <code>environment</code>. If you specify both of these tag keys in the request,
        /// Amazon Redshift returns a response with the HSM configurations that have either or both of
        /// these tag keys associated with them.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
        /// Appends an item to `TagValues`.
        ///
        /// To override the contents of this collection use [`set_tag_values`](Self::set_tag_values).
        ///
        /// <p>A tag value or values for which you want to return all matching HSM configurations
        /// that are associated with the specified tag value or values. For example, suppose that
        /// you have HSM configurations that are tagged with values called <code>admin</code> and
        /// <code>test</code>. If you specify both of these tag values in the request, Amazon Redshift
        /// returns a response with the HSM configurations that have either or both of these tag
        /// values associated with them.</p>
        pub fn tag_values(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_values(inp);
            self
        }
        /// <p>A tag value or values for which you want to return all matching HSM configurations
        /// that are associated with the specified tag value or values. For example, suppose that
        /// you have HSM configurations that are tagged with values called <code>admin</code> and
        /// <code>test</code>. If you specify both of these tag values in the request, Amazon Redshift
        /// returns a response with the HSM configurations that have either or both of these tag
        /// values associated with them.</p>
        pub fn set_tag_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_values(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeLoggingStatus`.
    ///
    /// <p>Describes whether information, such as queries and connection attempts, is being
    /// logged for the specified Amazon Redshift cluster.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeLoggingStatus<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_logging_status_input::Builder,
    }
    impl<C, M, R> DescribeLoggingStatus<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeLoggingStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeLoggingStatusOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeLoggingStatusError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeLoggingStatusInputOperationOutputAlias,
                crate::output::DescribeLoggingStatusOutput,
                crate::error::DescribeLoggingStatusError,
                crate::input::DescribeLoggingStatusInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the cluster from which to get the logging status.</p>
        /// <p>Example: <code>examplecluster</code>
        /// </p>
        pub fn cluster_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_identifier(inp);
            self
        }
        /// <p>The identifier of the cluster from which to get the logging status.</p>
        /// <p>Example: <code>examplecluster</code>
        /// </p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeNodeConfigurationOptions`.
    ///
    /// <p>Returns properties of possible node configurations such as node type, number of nodes, and
    /// disk usage for the specified action type.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeNodeConfigurationOptions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_node_configuration_options_input::Builder,
    }
    impl<C, M, R> DescribeNodeConfigurationOptions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeNodeConfigurationOptions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeNodeConfigurationOptionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeNodeConfigurationOptionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeNodeConfigurationOptionsInputOperationOutputAlias,
                crate::output::DescribeNodeConfigurationOptionsOutput,
                crate::error::DescribeNodeConfigurationOptionsError,
                crate::input::DescribeNodeConfigurationOptionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The action type to evaluate for possible node configurations.
        /// Specify "restore-cluster" to get configuration combinations based on an existing snapshot.
        /// Specify "recommend-node-config" to get configuration recommendations based on an existing cluster or snapshot.
        /// Specify "resize-cluster" to get configuration combinations for elastic resize based on an existing cluster.
        /// </p>
        pub fn action_type(mut self, inp: crate::model::ActionType) -> Self {
            self.inner = self.inner.action_type(inp);
            self
        }
        /// <p>The action type to evaluate for possible node configurations.
        /// Specify "restore-cluster" to get configuration combinations based on an existing snapshot.
        /// Specify "recommend-node-config" to get configuration recommendations based on an existing cluster or snapshot.
        /// Specify "resize-cluster" to get configuration combinations for elastic resize based on an existing cluster.
        /// </p>
        pub fn set_action_type(
            mut self,
            input: std::option::Option<crate::model::ActionType>,
        ) -> Self {
            self.inner = self.inner.set_action_type(input);
            self
        }
        /// <p>The identifier of the cluster to evaluate for possible node configurations.</p>
        pub fn cluster_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_identifier(inp);
            self
        }
        /// <p>The identifier of the cluster to evaluate for possible node configurations.</p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_identifier(input);
            self
        }
        /// <p>The identifier of the snapshot to evaluate for possible node configurations.</p>
        pub fn snapshot_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.snapshot_identifier(inp);
            self
        }
        /// <p>The identifier of the snapshot to evaluate for possible node configurations.</p>
        pub fn set_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_snapshot_identifier(input);
            self
        }
        /// <p>The Amazon Web Services account used to create or copy the snapshot.
        /// Required if you are restoring a snapshot you do not own,
        /// optional if you own the snapshot.</p>
        pub fn owner_account(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.owner_account(inp);
            self
        }
        /// <p>The Amazon Web Services account used to create or copy the snapshot.
        /// Required if you are restoring a snapshot you do not own,
        /// optional if you own the snapshot.</p>
        pub fn set_owner_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_owner_account(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>A set of name, operator, and value items to filter the results.</p>
        pub fn filters(
            mut self,
            inp: impl Into<crate::model::NodeConfigurationOptionsFilter>,
        ) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>A set of name, operator, and value items to filter the results.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::NodeConfigurationOptionsFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response
        /// records. When the results of a <a>DescribeNodeConfigurationOptions</a> request
        /// exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the
        /// <code>Marker</code> field of the response. You can retrieve the next set of response
        /// records by providing the returned marker value in the <code>Marker</code> parameter and
        /// retrying the request. </p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response
        /// records. When the results of a <a>DescribeNodeConfigurationOptions</a> request
        /// exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the
        /// <code>Marker</code> field of the response. You can retrieve the next set of response
        /// records by providing the returned marker value in the <code>Marker</code> parameter and
        /// retrying the request. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of
        /// remaining response records exceeds the specified <code>MaxRecords</code> value, a value
        /// is returned in a <code>marker</code> field of the response. You can retrieve the next
        /// set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>500</code>
        /// </p>
        /// <p>Constraints: minimum 100, maximum 500.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of
        /// remaining response records exceeds the specified <code>MaxRecords</code> value, a value
        /// is returned in a <code>marker</code> field of the response. You can retrieve the next
        /// set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>500</code>
        /// </p>
        /// <p>Constraints: minimum 100, maximum 500.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeOrderableClusterOptions`.
    ///
    /// <p>Returns a list of orderable cluster options. Before you create a new cluster you
    /// can use this operation to find what options are available, such as the EC2 Availability
    /// Zones (AZ) in the specific Amazon Web Services Region that you can specify, and the node types you can
    /// request. The node types differ by available storage, memory, CPU and price. With the
    /// cost involved you might want to obtain a list of cluster options in the specific region
    /// and specify values when creating a cluster.
    /// For more information about managing clusters, go to
    /// <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html">Amazon Redshift Clusters</a>
    /// in the <i>Amazon Redshift Cluster Management Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeOrderableClusterOptions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_orderable_cluster_options_input::Builder,
    }
    impl<C, M, R> DescribeOrderableClusterOptions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeOrderableClusterOptions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeOrderableClusterOptionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeOrderableClusterOptionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeOrderableClusterOptionsInputOperationOutputAlias,
                crate::output::DescribeOrderableClusterOptionsOutput,
                crate::error::DescribeOrderableClusterOptionsError,
                crate::input::DescribeOrderableClusterOptionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The version filter value. Specify this parameter to show only the available
        /// offerings matching the specified version.</p>
        /// <p>Default: All versions.</p>
        /// <p>Constraints: Must be one of the version returned from <a>DescribeClusterVersions</a>.</p>
        pub fn cluster_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_version(inp);
            self
        }
        /// <p>The version filter value. Specify this parameter to show only the available
        /// offerings matching the specified version.</p>
        /// <p>Default: All versions.</p>
        /// <p>Constraints: Must be one of the version returned from <a>DescribeClusterVersions</a>.</p>
        pub fn set_cluster_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_version(input);
            self
        }
        /// <p>The node type filter value. Specify this parameter to show only the available
        /// offerings matching the specified node type.</p>
        pub fn node_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.node_type(inp);
            self
        }
        /// <p>The node type filter value. Specify this parameter to show only the available
        /// offerings matching the specified node type.</p>
        pub fn set_node_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_node_type(input);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of
        /// remaining response records exceeds the specified <code>MaxRecords</code> value, a value
        /// is returned in a <code>marker</code> field of the response. You can retrieve the next
        /// set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>100</code>
        /// </p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of
        /// remaining response records exceeds the specified <code>MaxRecords</code> value, a value
        /// is returned in a <code>marker</code> field of the response. You can retrieve the next
        /// set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>100</code>
        /// </p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response
        /// records. When the results of a <a>DescribeOrderableClusterOptions</a> request
        /// exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the
        /// <code>Marker</code> field of the response. You can retrieve the next set of response
        /// records by providing the returned marker value in the <code>Marker</code> parameter and
        /// retrying the request. </p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response
        /// records. When the results of a <a>DescribeOrderableClusterOptions</a> request
        /// exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the
        /// <code>Marker</code> field of the response. You can retrieve the next set of response
        /// records by providing the returned marker value in the <code>Marker</code> parameter and
        /// retrying the request. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribePartners`.
    ///
    /// <p>Returns information about the partner integrations defined for a cluster.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribePartners<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_partners_input::Builder,
    }
    impl<C, M, R> DescribePartners<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribePartners`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribePartnersOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribePartnersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribePartnersInputOperationOutputAlias,
                crate::output::DescribePartnersOutput,
                crate::error::DescribePartnersError,
                crate::input::DescribePartnersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID that owns the cluster.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The Amazon Web Services account ID that owns the cluster.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The cluster identifier of the cluster whose partner integration is being described.</p>
        pub fn cluster_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_identifier(inp);
            self
        }
        /// <p>The cluster identifier of the cluster whose partner integration is being described.</p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_identifier(input);
            self
        }
        /// <p>The name of the database whose partner integration is being described. If database name is not specified, then all databases in the cluster are described.</p>
        pub fn database_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.database_name(inp);
            self
        }
        /// <p>The name of the database whose partner integration is being described. If database name is not specified, then all databases in the cluster are described.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_database_name(input);
            self
        }
        /// <p>The name of the partner that is being described. If partner name is not specified, then all partner integrations are described.</p>
        pub fn partner_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.partner_name(inp);
            self
        }
        /// <p>The name of the partner that is being described. If partner name is not specified, then all partner integrations are described.</p>
        pub fn set_partner_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_partner_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeReservedNodeOfferings`.
    ///
    /// <p>Returns a list of the available reserved node offerings by Amazon Redshift with their
    /// descriptions including the node type, the fixed and recurring costs of reserving the
    /// node and duration the node will be reserved for you. These descriptions help you
    /// determine which reserve node offering you want to purchase. You then use the unique
    /// offering ID in you call to <a>PurchaseReservedNodeOffering</a> to reserve one
    /// or more nodes for your Amazon Redshift cluster. </p>
    /// <p>
    /// For more information about reserved node offerings, go to
    /// <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/purchase-reserved-node-instance.html">Purchasing Reserved Nodes</a>
    /// in the <i>Amazon Redshift Cluster Management Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeReservedNodeOfferings<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_reserved_node_offerings_input::Builder,
    }
    impl<C, M, R> DescribeReservedNodeOfferings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeReservedNodeOfferings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeReservedNodeOfferingsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeReservedNodeOfferingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeReservedNodeOfferingsInputOperationOutputAlias,
                crate::output::DescribeReservedNodeOfferingsOutput,
                crate::error::DescribeReservedNodeOfferingsError,
                crate::input::DescribeReservedNodeOfferingsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the offering.</p>
        pub fn reserved_node_offering_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.reserved_node_offering_id(inp);
            self
        }
        /// <p>The unique identifier for the offering.</p>
        pub fn set_reserved_node_offering_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_reserved_node_offering_id(input);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of
        /// remaining response records exceeds the specified <code>MaxRecords</code> value, a value
        /// is returned in a <code>marker</code> field of the response. You can retrieve the next
        /// set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>100</code>
        /// </p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of
        /// remaining response records exceeds the specified <code>MaxRecords</code> value, a value
        /// is returned in a <code>marker</code> field of the response. You can retrieve the next
        /// set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>100</code>
        /// </p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response
        /// records. When the results of a <a>DescribeReservedNodeOfferings</a> request
        /// exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the
        /// <code>Marker</code> field of the response. You can retrieve the next set of response
        /// records by providing the returned marker value in the <code>Marker</code> parameter and
        /// retrying the request. </p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response
        /// records. When the results of a <a>DescribeReservedNodeOfferings</a> request
        /// exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the
        /// <code>Marker</code> field of the response. You can retrieve the next set of response
        /// records by providing the returned marker value in the <code>Marker</code> parameter and
        /// retrying the request. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeReservedNodes`.
    ///
    /// <p>Returns the descriptions of the reserved nodes.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeReservedNodes<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_reserved_nodes_input::Builder,
    }
    impl<C, M, R> DescribeReservedNodes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeReservedNodes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeReservedNodesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeReservedNodesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeReservedNodesInputOperationOutputAlias,
                crate::output::DescribeReservedNodesOutput,
                crate::error::DescribeReservedNodesError,
                crate::input::DescribeReservedNodesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Identifier for the node reservation.</p>
        pub fn reserved_node_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.reserved_node_id(inp);
            self
        }
        /// <p>Identifier for the node reservation.</p>
        pub fn set_reserved_node_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_reserved_node_id(input);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of
        /// remaining response records exceeds the specified <code>MaxRecords</code> value, a value
        /// is returned in a <code>marker</code> field of the response. You can retrieve the next
        /// set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>100</code>
        /// </p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of
        /// remaining response records exceeds the specified <code>MaxRecords</code> value, a value
        /// is returned in a <code>marker</code> field of the response. You can retrieve the next
        /// set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>100</code>
        /// </p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response
        /// records. When the results of a <a>DescribeReservedNodes</a> request exceed
        /// the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the
        /// <code>Marker</code> field of the response. You can retrieve the next set of response
        /// records by providing the returned marker value in the <code>Marker</code> parameter and
        /// retrying the request. </p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response
        /// records. When the results of a <a>DescribeReservedNodes</a> request exceed
        /// the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the
        /// <code>Marker</code> field of the response. You can retrieve the next set of response
        /// records by providing the returned marker value in the <code>Marker</code> parameter and
        /// retrying the request. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeResize`.
    ///
    /// <p>Returns information about the last resize operation for the specified cluster. If
    /// no resize operation has ever been initiated for the specified cluster, a <code>HTTP
    /// 404</code> error is returned. If a resize operation was initiated and completed, the
    /// status of the resize remains as <code>SUCCEEDED</code> until the next resize. </p>
    /// <p>A resize operation can be requested using <a>ModifyCluster</a> and
    /// specifying a different number or type of nodes for the cluster. </p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeResize<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_resize_input::Builder,
    }
    impl<C, M, R> DescribeResize<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeResize`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeResizeOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeResizeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeResizeInputOperationOutputAlias,
                crate::output::DescribeResizeOutput,
                crate::error::DescribeResizeError,
                crate::input::DescribeResizeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of a cluster whose resize progress you are requesting. This
        /// parameter is case-sensitive.</p>
        /// <p>By default, resize operations for all clusters defined for an Amazon Web Services account are
        /// returned.</p>
        pub fn cluster_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_identifier(inp);
            self
        }
        /// <p>The unique identifier of a cluster whose resize progress you are requesting. This
        /// parameter is case-sensitive.</p>
        /// <p>By default, resize operations for all clusters defined for an Amazon Web Services account are
        /// returned.</p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeScheduledActions`.
    ///
    /// <p>Describes properties of scheduled actions.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeScheduledActions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_scheduled_actions_input::Builder,
    }
    impl<C, M, R> DescribeScheduledActions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeScheduledActions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeScheduledActionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeScheduledActionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeScheduledActionsInputOperationOutputAlias,
                crate::output::DescribeScheduledActionsOutput,
                crate::error::DescribeScheduledActionsError,
                crate::input::DescribeScheduledActionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the scheduled action to retrieve. </p>
        pub fn scheduled_action_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.scheduled_action_name(inp);
            self
        }
        /// <p>The name of the scheduled action to retrieve. </p>
        pub fn set_scheduled_action_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_scheduled_action_name(input);
            self
        }
        /// <p>The type of the scheduled actions to retrieve. </p>
        pub fn target_action_type(mut self, inp: crate::model::ScheduledActionTypeValues) -> Self {
            self.inner = self.inner.target_action_type(inp);
            self
        }
        /// <p>The type of the scheduled actions to retrieve. </p>
        pub fn set_target_action_type(
            mut self,
            input: std::option::Option<crate::model::ScheduledActionTypeValues>,
        ) -> Self {
            self.inner = self.inner.set_target_action_type(input);
            self
        }
        /// <p>The start time in UTC of the scheduled actions to retrieve.
        /// Only active scheduled actions that have invocations after this time are retrieved.</p>
        pub fn start_time(mut self, inp: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.start_time(inp);
            self
        }
        /// <p>The start time in UTC of the scheduled actions to retrieve.
        /// Only active scheduled actions that have invocations after this time are retrieved.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_start_time(input);
            self
        }
        /// <p>The end time in UTC of the scheduled action to retrieve.
        /// Only active scheduled actions that have invocations before this time are retrieved.</p>
        pub fn end_time(mut self, inp: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.end_time(inp);
            self
        }
        /// <p>The end time in UTC of the scheduled action to retrieve.
        /// Only active scheduled actions that have invocations before this time are retrieved.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_end_time(input);
            self
        }
        /// <p>If true, retrieve only active scheduled actions.
        /// If false, retrieve only disabled scheduled actions. </p>
        pub fn active(mut self, inp: bool) -> Self {
            self.inner = self.inner.active(inp);
            self
        }
        /// <p>If true, retrieve only active scheduled actions.
        /// If false, retrieve only disabled scheduled actions. </p>
        pub fn set_active(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_active(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>List of scheduled action filters. </p>
        pub fn filters(mut self, inp: impl Into<crate::model::ScheduledActionFilter>) -> Self {
            self.inner = self.inner.filters(inp);
            self
        }
        /// <p>List of scheduled action filters. </p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ScheduledActionFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response
        /// records. When the results of a <a>DescribeScheduledActions</a> request
        /// exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the
        /// <code>Marker</code> field of the response. You can retrieve the next set of response
        /// records by providing the returned marker value in the <code>Marker</code> parameter and
        /// retrying the request. </p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response
        /// records. When the results of a <a>DescribeScheduledActions</a> request
        /// exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the
        /// <code>Marker</code> field of the response. You can retrieve the next set of response
        /// records by providing the returned marker value in the <code>Marker</code> parameter and
        /// retrying the request. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of
        /// remaining response records exceeds the specified <code>MaxRecords</code> value, a value
        /// is returned in a <code>marker</code> field of the response. You can retrieve the next
        /// set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>100</code>
        /// </p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of
        /// remaining response records exceeds the specified <code>MaxRecords</code> value, a value
        /// is returned in a <code>marker</code> field of the response. You can retrieve the next
        /// set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>100</code>
        /// </p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeSnapshotCopyGrants`.
    ///
    /// <p>Returns a list of snapshot copy grants owned by the Amazon Web Services account in the destination
    /// region.</p>
    /// <p>
    /// For more information about managing snapshot copy grants, go to
    /// <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-db-encryption.html">Amazon Redshift Database Encryption</a>
    /// in the <i>Amazon Redshift Cluster Management Guide</i>.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeSnapshotCopyGrants<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_snapshot_copy_grants_input::Builder,
    }
    impl<C, M, R> DescribeSnapshotCopyGrants<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeSnapshotCopyGrants`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeSnapshotCopyGrantsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeSnapshotCopyGrantsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeSnapshotCopyGrantsInputOperationOutputAlias,
                crate::output::DescribeSnapshotCopyGrantsOutput,
                crate::error::DescribeSnapshotCopyGrantsError,
                crate::input::DescribeSnapshotCopyGrantsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the snapshot copy grant.</p>
        pub fn snapshot_copy_grant_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.snapshot_copy_grant_name(inp);
            self
        }
        /// <p>The name of the snapshot copy grant.</p>
        pub fn set_snapshot_copy_grant_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_snapshot_copy_grant_name(input);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of
        /// remaining response records exceeds the specified <code>MaxRecords</code> value, a value
        /// is returned in a <code>marker</code> field of the response. You can retrieve the next
        /// set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>100</code>
        /// </p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of
        /// remaining response records exceeds the specified <code>MaxRecords</code> value, a value
        /// is returned in a <code>marker</code> field of the response. You can retrieve the next
        /// set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>100</code>
        /// </p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response
        /// records. When the results of a <code>DescribeSnapshotCopyGrant</code> request exceed the
        /// value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the
        /// <code>Marker</code> field of the response. You can retrieve the next set of response
        /// records by providing the returned marker value in the <code>Marker</code> parameter and
        /// retrying the request. </p>
        /// <p>Constraints: You can specify either the <b>SnapshotCopyGrantName</b> parameter or the <b>Marker</b> parameter, but not both. </p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response
        /// records. When the results of a <code>DescribeSnapshotCopyGrant</code> request exceed the
        /// value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the
        /// <code>Marker</code> field of the response. You can retrieve the next set of response
        /// records by providing the returned marker value in the <code>Marker</code> parameter and
        /// retrying the request. </p>
        /// <p>Constraints: You can specify either the <b>SnapshotCopyGrantName</b> parameter or the <b>Marker</b> parameter, but not both. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A tag key or keys for which you want to return all matching resources that are
        /// associated with the specified key or keys. For example, suppose that you have resources
        /// tagged with keys called <code>owner</code> and <code>environment</code>. If you specify
        /// both of these tag keys in the request, Amazon Redshift returns a response with all resources
        /// that have either or both of these tag keys associated with them.</p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>A tag key or keys for which you want to return all matching resources that are
        /// associated with the specified key or keys. For example, suppose that you have resources
        /// tagged with keys called <code>owner</code> and <code>environment</code>. If you specify
        /// both of these tag keys in the request, Amazon Redshift returns a response with all resources
        /// that have either or both of these tag keys associated with them.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
        /// Appends an item to `TagValues`.
        ///
        /// To override the contents of this collection use [`set_tag_values`](Self::set_tag_values).
        ///
        /// <p>A tag value or values for which you want to return all matching resources that are
        /// associated with the specified value or values. For example, suppose that you have
        /// resources tagged with values called <code>admin</code> and <code>test</code>. If you
        /// specify both of these tag values in the request, Amazon Redshift returns a response with all
        /// resources that have either or both of these tag values associated with them.</p>
        pub fn tag_values(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_values(inp);
            self
        }
        /// <p>A tag value or values for which you want to return all matching resources that are
        /// associated with the specified value or values. For example, suppose that you have
        /// resources tagged with values called <code>admin</code> and <code>test</code>. If you
        /// specify both of these tag values in the request, Amazon Redshift returns a response with all
        /// resources that have either or both of these tag values associated with them.</p>
        pub fn set_tag_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_values(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeSnapshotSchedules`.
    ///
    /// <p>Returns a list of snapshot schedules. </p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeSnapshotSchedules<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_snapshot_schedules_input::Builder,
    }
    impl<C, M, R> DescribeSnapshotSchedules<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeSnapshotSchedules`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeSnapshotSchedulesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeSnapshotSchedulesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeSnapshotSchedulesInputOperationOutputAlias,
                crate::output::DescribeSnapshotSchedulesOutput,
                crate::error::DescribeSnapshotSchedulesError,
                crate::input::DescribeSnapshotSchedulesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the cluster whose snapshot schedules you want to
        /// view.</p>
        pub fn cluster_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_identifier(inp);
            self
        }
        /// <p>The unique identifier for the cluster whose snapshot schedules you want to
        /// view.</p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_identifier(input);
            self
        }
        /// <p>A unique identifier for a snapshot schedule.</p>
        pub fn schedule_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schedule_identifier(inp);
            self
        }
        /// <p>A unique identifier for a snapshot schedule.</p>
        pub fn set_schedule_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_schedule_identifier(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The key value for a snapshot schedule tag.</p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>The key value for a snapshot schedule tag.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
        /// Appends an item to `TagValues`.
        ///
        /// To override the contents of this collection use [`set_tag_values`](Self::set_tag_values).
        ///
        /// <p>The value corresponding to the key of the snapshot schedule tag.</p>
        pub fn tag_values(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_values(inp);
            self
        }
        /// <p>The value corresponding to the key of the snapshot schedule tag.</p>
        pub fn set_tag_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_values(input);
            self
        }
        /// <p>A value that indicates the starting point for the next set of response records in a
        /// subsequent request. If a value is returned in a response, you can retrieve the next set
        /// of records by providing this returned marker value in the <code>marker</code> parameter
        /// and retrying the command. If the <code>marker</code> field is empty, all response
        /// records have been retrieved for the request.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>A value that indicates the starting point for the next set of response records in a
        /// subsequent request. If a value is returned in a response, you can retrieve the next set
        /// of records by providing this returned marker value in the <code>marker</code> parameter
        /// and retrying the command. If the <code>marker</code> field is empty, all response
        /// records have been retrieved for the request.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>The maximum number or response records to return in each call. If the number of
        /// remaining response records exceeds the specified <code>MaxRecords</code> value, a value
        /// is returned in a <code>marker</code> field of the response. You can retrieve the next
        /// set of records by retrying the command with the returned <code>marker</code>
        /// value.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p>The maximum number or response records to return in each call. If the number of
        /// remaining response records exceeds the specified <code>MaxRecords</code> value, a value
        /// is returned in a <code>marker</code> field of the response. You can retrieve the next
        /// set of records by retrying the command with the returned <code>marker</code>
        /// value.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeStorage`.
    ///
    /// <p>Returns account level backups storage size and provisional storage.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeStorage<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_storage_input::Builder,
    }
    impl<C, M, R> DescribeStorage<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeStorage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeStorageOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeStorageError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeStorageInputOperationOutputAlias,
                crate::output::DescribeStorageOutput,
                crate::error::DescribeStorageError,
                crate::input::DescribeStorageInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `DescribeTableRestoreStatus`.
    ///
    /// <p>Lists the status of one or more table restore requests made using the <a>RestoreTableFromClusterSnapshot</a> API action. If you don't specify a value
    /// for the <code>TableRestoreRequestId</code> parameter, then
    /// <code>DescribeTableRestoreStatus</code> returns the status of all table restore
    /// requests ordered by the date and time of the request in ascending order. Otherwise
    /// <code>DescribeTableRestoreStatus</code> returns the status of the table specified by
    /// <code>TableRestoreRequestId</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeTableRestoreStatus<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_table_restore_status_input::Builder,
    }
    impl<C, M, R> DescribeTableRestoreStatus<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeTableRestoreStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeTableRestoreStatusOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeTableRestoreStatusError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeTableRestoreStatusInputOperationOutputAlias,
                crate::output::DescribeTableRestoreStatusOutput,
                crate::error::DescribeTableRestoreStatusError,
                crate::input::DescribeTableRestoreStatusInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Redshift cluster that the table is being restored to.</p>
        pub fn cluster_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_identifier(inp);
            self
        }
        /// <p>The Amazon Redshift cluster that the table is being restored to.</p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_identifier(input);
            self
        }
        /// <p>The identifier of the table restore request to return status for. If you don't
        /// specify a <code>TableRestoreRequestId</code> value, then
        /// <code>DescribeTableRestoreStatus</code> returns the status of all in-progress table
        /// restore requests.</p>
        pub fn table_restore_request_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.table_restore_request_id(inp);
            self
        }
        /// <p>The identifier of the table restore request to return status for. If you don't
        /// specify a <code>TableRestoreRequestId</code> value, then
        /// <code>DescribeTableRestoreStatus</code> returns the status of all in-progress table
        /// restore requests.</p>
        pub fn set_table_restore_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_table_restore_request_id(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist
        /// than the specified <code>MaxRecords</code> value, a pagination token called a marker is
        /// included in the response so that the remaining results can be retrieved.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist
        /// than the specified <code>MaxRecords</code> value, a pagination token called a marker is
        /// included in the response so that the remaining results can be retrieved.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>An optional pagination token provided by a previous
        /// <code>DescribeTableRestoreStatus</code> request. If this parameter is specified, the
        /// response includes only records beyond the marker, up to the value specified by the
        /// <code>MaxRecords</code> parameter.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>An optional pagination token provided by a previous
        /// <code>DescribeTableRestoreStatus</code> request. If this parameter is specified, the
        /// response includes only records beyond the marker, up to the value specified by the
        /// <code>MaxRecords</code> parameter.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeTags`.
    ///
    /// <p>Returns a list of tags. You can return tags from a specific resource by specifying
    /// an ARN, or you can return all tags for a given type of resource, such as clusters,
    /// snapshots, and so on.</p>
    /// <p>The following are limitations for <code>DescribeTags</code>: </p>
    /// <ul>
    /// <li>
    /// <p>You cannot specify an ARN and a resource-type value together in the same
    /// request.</p>
    /// </li>
    /// <li>
    /// <p>You cannot use the <code>MaxRecords</code> and <code>Marker</code>
    /// parameters together with the ARN parameter.</p>
    /// </li>
    /// <li>
    /// <p>The <code>MaxRecords</code> parameter can be a range from 10 to 50 results
    /// to return in a request.</p>
    /// </li>
    /// </ul>
    /// <p>If you specify both tag keys and tag values in the same request, Amazon Redshift returns
    /// all resources that match any combination of the specified keys and values. For example,
    /// if you have <code>owner</code> and <code>environment</code> for tag keys, and
    /// <code>admin</code> and <code>test</code> for tag values, all resources that have any
    /// combination of those values are returned.</p>
    /// <p>If both tag keys and values are omitted from the request, resources are returned
    /// regardless of whether they have tag keys or values associated with them.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeTags<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_tags_input::Builder,
    }
    impl<C, M, R> DescribeTags<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeTagsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeTagsInputOperationOutputAlias,
                crate::output::DescribeTagsOutput,
                crate::error::DescribeTagsError,
                crate::input::DescribeTagsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) for which you want to describe the tag or tags. For
        /// example, <code>arn:aws:redshift:us-east-2:123456789:cluster:t1</code>. </p>
        pub fn resource_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_name(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) for which you want to describe the tag or tags. For
        /// example, <code>arn:aws:redshift:us-east-2:123456789:cluster:t1</code>. </p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_name(input);
            self
        }
        /// <p>The type of resource with which you want to view tags. Valid resource types are: </p>
        /// <ul>
        /// <li>
        /// <p>Cluster</p>
        /// </li>
        /// <li>
        /// <p>CIDR/IP</p>
        /// </li>
        /// <li>
        /// <p>EC2 security group</p>
        /// </li>
        /// <li>
        /// <p>Snapshot</p>
        /// </li>
        /// <li>
        /// <p>Cluster security group</p>
        /// </li>
        /// <li>
        /// <p>Subnet group</p>
        /// </li>
        /// <li>
        /// <p>HSM connection</p>
        /// </li>
        /// <li>
        /// <p>HSM certificate</p>
        /// </li>
        /// <li>
        /// <p>Parameter group</p>
        /// </li>
        /// <li>
        /// <p>Snapshot copy grant</p>
        /// </li>
        /// </ul>
        /// <p>For more information about Amazon Redshift resource types and constructing ARNs, go to
        /// <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-overview.html#redshift-iam-access-control-specify-actions">Specifying Policy Elements: Actions, Effects, Resources, and Principals</a> in
        /// the Amazon Redshift Cluster Management Guide. </p>
        pub fn resource_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_type(inp);
            self
        }
        /// <p>The type of resource with which you want to view tags. Valid resource types are: </p>
        /// <ul>
        /// <li>
        /// <p>Cluster</p>
        /// </li>
        /// <li>
        /// <p>CIDR/IP</p>
        /// </li>
        /// <li>
        /// <p>EC2 security group</p>
        /// </li>
        /// <li>
        /// <p>Snapshot</p>
        /// </li>
        /// <li>
        /// <p>Cluster security group</p>
        /// </li>
        /// <li>
        /// <p>Subnet group</p>
        /// </li>
        /// <li>
        /// <p>HSM connection</p>
        /// </li>
        /// <li>
        /// <p>HSM certificate</p>
        /// </li>
        /// <li>
        /// <p>Parameter group</p>
        /// </li>
        /// <li>
        /// <p>Snapshot copy grant</p>
        /// </li>
        /// </ul>
        /// <p>For more information about Amazon Redshift resource types and constructing ARNs, go to
        /// <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-overview.html#redshift-iam-access-control-specify-actions">Specifying Policy Elements: Actions, Effects, Resources, and Principals</a> in
        /// the Amazon Redshift Cluster Management Guide. </p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_type(input);
            self
        }
        /// <p>The maximum number or response records to return in each call. If the number of
        /// remaining response records exceeds the specified <code>MaxRecords</code> value, a value
        /// is returned in a <code>marker</code> field of the response. You can retrieve the next
        /// set of records by retrying the command with the returned <code>marker</code> value.
        /// </p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p>The maximum number or response records to return in each call. If the number of
        /// remaining response records exceeds the specified <code>MaxRecords</code> value, a value
        /// is returned in a <code>marker</code> field of the response. You can retrieve the next
        /// set of records by retrying the command with the returned <code>marker</code> value.
        /// </p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>A value that indicates the starting point for the next set of response records in a
        /// subsequent request. If a value is returned in a response, you can retrieve the next set
        /// of records by providing this returned marker value in the <code>marker</code> parameter
        /// and retrying the command. If the <code>marker</code> field is empty, all response
        /// records have been retrieved for the request. </p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>A value that indicates the starting point for the next set of response records in a
        /// subsequent request. If a value is returned in a response, you can retrieve the next set
        /// of records by providing this returned marker value in the <code>marker</code> parameter
        /// and retrying the command. If the <code>marker</code> field is empty, all response
        /// records have been retrieved for the request. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A tag key or keys for which you want to return all matching resources that are
        /// associated with the specified key or keys. For example, suppose that you have resources
        /// tagged with keys called <code>owner</code> and <code>environment</code>. If you specify
        /// both of these tag keys in the request, Amazon Redshift returns a response with all resources
        /// that have either or both of these tag keys associated with them.</p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>A tag key or keys for which you want to return all matching resources that are
        /// associated with the specified key or keys. For example, suppose that you have resources
        /// tagged with keys called <code>owner</code> and <code>environment</code>. If you specify
        /// both of these tag keys in the request, Amazon Redshift returns a response with all resources
        /// that have either or both of these tag keys associated with them.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
        /// Appends an item to `TagValues`.
        ///
        /// To override the contents of this collection use [`set_tag_values`](Self::set_tag_values).
        ///
        /// <p>A tag value or values for which you want to return all matching resources that are
        /// associated with the specified value or values. For example, suppose that you have
        /// resources tagged with values called <code>admin</code> and <code>test</code>. If you
        /// specify both of these tag values in the request, Amazon Redshift returns a response with all
        /// resources that have either or both of these tag values associated with them.</p>
        pub fn tag_values(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_values(inp);
            self
        }
        /// <p>A tag value or values for which you want to return all matching resources that are
        /// associated with the specified value or values. For example, suppose that you have
        /// resources tagged with values called <code>admin</code> and <code>test</code>. If you
        /// specify both of these tag values in the request, Amazon Redshift returns a response with all
        /// resources that have either or both of these tag values associated with them.</p>
        pub fn set_tag_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_values(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeUsageLimits`.
    ///
    /// <p>Shows usage limits on a cluster.
    /// Results are filtered based on the combination of input usage limit identifier, cluster identifier, and feature type parameters:</p>
    /// <ul>
    /// <li>
    /// <p>If usage limit identifier, cluster identifier, and feature type are not provided,
    /// then all usage limit objects for the current account in the current region are returned.</p>
    /// </li>
    /// <li>
    /// <p>If usage limit identifier is provided,
    /// then the corresponding usage limit object is returned.</p>
    /// </li>
    /// <li>
    /// <p>If cluster identifier is provided,
    /// then all usage limit objects for the specified cluster are returned.</p>
    /// </li>
    /// <li>
    /// <p>If cluster identifier and feature type are provided,
    /// then all usage limit objects for the combination of cluster and feature are returned.</p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct DescribeUsageLimits<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_usage_limits_input::Builder,
    }
    impl<C, M, R> DescribeUsageLimits<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeUsageLimits`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeUsageLimitsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeUsageLimitsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeUsageLimitsInputOperationOutputAlias,
                crate::output::DescribeUsageLimitsOutput,
                crate::error::DescribeUsageLimitsError,
                crate::input::DescribeUsageLimitsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the usage limit to describe.</p>
        pub fn usage_limit_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.usage_limit_id(inp);
            self
        }
        /// <p>The identifier of the usage limit to describe.</p>
        pub fn set_usage_limit_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_usage_limit_id(input);
            self
        }
        /// <p>The identifier of the cluster for which you want to describe usage limits.</p>
        pub fn cluster_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_identifier(inp);
            self
        }
        /// <p>The identifier of the cluster for which you want to describe usage limits.</p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_identifier(input);
            self
        }
        /// <p>The feature type for which you want to describe usage limits.</p>
        pub fn feature_type(mut self, inp: crate::model::UsageLimitFeatureType) -> Self {
            self.inner = self.inner.feature_type(inp);
            self
        }
        /// <p>The feature type for which you want to describe usage limits.</p>
        pub fn set_feature_type(
            mut self,
            input: std::option::Option<crate::model::UsageLimitFeatureType>,
        ) -> Self {
            self.inner = self.inner.set_feature_type(input);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of
        /// remaining response records exceeds the specified <code>MaxRecords</code> value, a value
        /// is returned in a <code>marker</code> field of the response. You can retrieve the next
        /// set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>100</code>
        /// </p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of
        /// remaining response records exceeds the specified <code>MaxRecords</code> value, a value
        /// is returned in a <code>marker</code> field of the response. You can retrieve the next
        /// set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>100</code>
        /// </p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response
        /// records. When the results of a <a>DescribeUsageLimits</a> request
        /// exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the
        /// <code>Marker</code> field of the response. You can retrieve the next set of response
        /// records by providing the returned marker value in the <code>Marker</code> parameter and
        /// retrying the request. </p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response
        /// records. When the results of a <a>DescribeUsageLimits</a> request
        /// exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the
        /// <code>Marker</code> field of the response. You can retrieve the next set of response
        /// records by providing the returned marker value in the <code>Marker</code> parameter and
        /// retrying the request. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A tag key or keys for which you want to return all matching usage limit objects
        /// that are associated with the specified key or keys. For example, suppose that you
        /// have parameter groups that are tagged with keys called <code>owner</code> and
        /// <code>environment</code>. If you specify both of these tag keys in the request,
        /// Amazon Redshift returns a response with the usage limit objects have either or both of these
        /// tag keys associated with them.</p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>A tag key or keys for which you want to return all matching usage limit objects
        /// that are associated with the specified key or keys. For example, suppose that you
        /// have parameter groups that are tagged with keys called <code>owner</code> and
        /// <code>environment</code>. If you specify both of these tag keys in the request,
        /// Amazon Redshift returns a response with the usage limit objects have either or both of these
        /// tag keys associated with them.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
        /// Appends an item to `TagValues`.
        ///
        /// To override the contents of this collection use [`set_tag_values`](Self::set_tag_values).
        ///
        /// <p>A tag value or values for which you want to return all matching usage limit objects
        /// that are associated with the specified tag value or values. For example, suppose
        /// that you have parameter groups that are tagged with values called <code>admin</code> and
        /// <code>test</code>. If you specify both of these tag values in the request, Amazon Redshift
        /// returns a response with the usage limit objects that have either or both of these tag
        /// values associated with them.</p>
        pub fn tag_values(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_values(inp);
            self
        }
        /// <p>A tag value or values for which you want to return all matching usage limit objects
        /// that are associated with the specified tag value or values. For example, suppose
        /// that you have parameter groups that are tagged with values called <code>admin</code> and
        /// <code>test</code>. If you specify both of these tag values in the request, Amazon Redshift
        /// returns a response with the usage limit objects that have either or both of these tag
        /// values associated with them.</p>
        pub fn set_tag_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_values(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisableLogging`.
    ///
    /// <p>Stops logging information, such as queries and connection attempts, for the
    /// specified Amazon Redshift cluster.</p>
    #[derive(std::fmt::Debug)]
    pub struct DisableLogging<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disable_logging_input::Builder,
    }
    impl<C, M, R> DisableLogging<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisableLogging`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisableLoggingOutput,
            aws_smithy_http::result::SdkError<crate::error::DisableLoggingError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisableLoggingInputOperationOutputAlias,
                crate::output::DisableLoggingOutput,
                crate::error::DisableLoggingError,
                crate::input::DisableLoggingInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the cluster on which logging is to be stopped.</p>
        /// <p>Example: <code>examplecluster</code>
        /// </p>
        pub fn cluster_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_identifier(inp);
            self
        }
        /// <p>The identifier of the cluster on which logging is to be stopped.</p>
        /// <p>Example: <code>examplecluster</code>
        /// </p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisableSnapshotCopy`.
    ///
    /// <p>Disables the automatic copying of snapshots from one region to another region for a
    /// specified cluster.</p>
    /// <p>If your cluster and its snapshots are encrypted using a customer master key (CMK)
    /// from Key Management Service, use <a>DeleteSnapshotCopyGrant</a> to delete the grant that
    /// grants Amazon Redshift permission to the CMK in the destination region. </p>
    #[derive(std::fmt::Debug)]
    pub struct DisableSnapshotCopy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disable_snapshot_copy_input::Builder,
    }
    impl<C, M, R> DisableSnapshotCopy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisableSnapshotCopy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisableSnapshotCopyOutput,
            aws_smithy_http::result::SdkError<crate::error::DisableSnapshotCopyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisableSnapshotCopyInputOperationOutputAlias,
                crate::output::DisableSnapshotCopyOutput,
                crate::error::DisableSnapshotCopyError,
                crate::input::DisableSnapshotCopyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the source cluster that you want to disable copying of
        /// snapshots to a destination region.</p>
        /// <p>Constraints: Must be the valid name of an existing cluster that has cross-region
        /// snapshot copy enabled.</p>
        pub fn cluster_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_identifier(inp);
            self
        }
        /// <p>The unique identifier of the source cluster that you want to disable copying of
        /// snapshots to a destination region.</p>
        /// <p>Constraints: Must be the valid name of an existing cluster that has cross-region
        /// snapshot copy enabled.</p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateDataShareConsumer`.
    ///
    /// <p>From a consumer account, remove association for the specified datashare.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct DisassociateDataShareConsumer<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_data_share_consumer_input::Builder,
    }
    impl<C, M, R> DisassociateDataShareConsumer<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateDataShareConsumer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateDataShareConsumerOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateDataShareConsumerError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateDataShareConsumerInputOperationOutputAlias,
                crate::output::DisassociateDataShareConsumerOutput,
                crate::error::DisassociateDataShareConsumerError,
                crate::input::DisassociateDataShareConsumerInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the datashare to remove association for. </p>
        pub fn data_share_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_share_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the datashare to remove association for. </p>
        pub fn set_data_share_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_data_share_arn(input);
            self
        }
        /// <p>A value that specifies whether association for the datashare is removed from the
        /// entire account.</p>
        pub fn disassociate_entire_account(mut self, inp: bool) -> Self {
            self.inner = self.inner.disassociate_entire_account(inp);
            self
        }
        /// <p>A value that specifies whether association for the datashare is removed from the
        /// entire account.</p>
        pub fn set_disassociate_entire_account(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_disassociate_entire_account(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the consumer that association for
        /// the datashare is removed from.</p>
        pub fn consumer_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.consumer_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the consumer that association for
        /// the datashare is removed from.</p>
        pub fn set_consumer_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_consumer_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `EnableLogging`.
    ///
    /// <p>Starts logging information, such as queries and connection attempts, for the
    /// specified Amazon Redshift cluster.</p>
    #[derive(std::fmt::Debug)]
    pub struct EnableLogging<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::enable_logging_input::Builder,
    }
    impl<C, M, R> EnableLogging<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `EnableLogging`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::EnableLoggingOutput,
            aws_smithy_http::result::SdkError<crate::error::EnableLoggingError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::EnableLoggingInputOperationOutputAlias,
                crate::output::EnableLoggingOutput,
                crate::error::EnableLoggingError,
                crate::input::EnableLoggingInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the cluster on which logging is to be started.</p>
        /// <p>Example: <code>examplecluster</code>
        /// </p>
        pub fn cluster_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_identifier(inp);
            self
        }
        /// <p>The identifier of the cluster on which logging is to be started.</p>
        /// <p>Example: <code>examplecluster</code>
        /// </p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_identifier(input);
            self
        }
        /// <p>The name of an existing S3 bucket where the log files are to be stored.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be in the same region as the cluster</p>
        /// </li>
        /// <li>
        /// <p>The cluster must have read bucket and put object permissions</p>
        /// </li>
        /// </ul>
        pub fn bucket_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket_name(inp);
            self
        }
        /// <p>The name of an existing S3 bucket where the log files are to be stored.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be in the same region as the cluster</p>
        /// </li>
        /// <li>
        /// <p>The cluster must have read bucket and put object permissions</p>
        /// </li>
        /// </ul>
        pub fn set_bucket_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket_name(input);
            self
        }
        /// <p>The prefix applied to the log file names.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Cannot exceed 512 characters</p>
        /// </li>
        /// <li>
        /// <p>Cannot contain spaces( ), double quotes ("), single quotes ('), a backslash
        /// (\), or control characters. The hexadecimal codes for invalid characters are: </p>
        /// <ul>
        /// <li>
        /// <p>x00 to x20</p>
        /// </li>
        /// <li>
        /// <p>x22</p>
        /// </li>
        /// <li>
        /// <p>x27</p>
        /// </li>
        /// <li>
        /// <p>x5c</p>
        /// </li>
        /// <li>
        /// <p>x7f or larger</p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        pub fn s3_key_prefix(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.s3_key_prefix(inp);
            self
        }
        /// <p>The prefix applied to the log file names.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Cannot exceed 512 characters</p>
        /// </li>
        /// <li>
        /// <p>Cannot contain spaces( ), double quotes ("), single quotes ('), a backslash
        /// (\), or control characters. The hexadecimal codes for invalid characters are: </p>
        /// <ul>
        /// <li>
        /// <p>x00 to x20</p>
        /// </li>
        /// <li>
        /// <p>x22</p>
        /// </li>
        /// <li>
        /// <p>x27</p>
        /// </li>
        /// <li>
        /// <p>x5c</p>
        /// </li>
        /// <li>
        /// <p>x7f or larger</p>
        /// </li>
        /// </ul>
        /// </li>
        /// </ul>
        pub fn set_s3_key_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_s3_key_prefix(input);
            self
        }
    }
    /// Fluent builder constructing a request to `EnableSnapshotCopy`.
    ///
    /// <p>Enables the automatic copy of snapshots from one region to another region for a
    /// specified cluster.</p>
    #[derive(std::fmt::Debug)]
    pub struct EnableSnapshotCopy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::enable_snapshot_copy_input::Builder,
    }
    impl<C, M, R> EnableSnapshotCopy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `EnableSnapshotCopy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::EnableSnapshotCopyOutput,
            aws_smithy_http::result::SdkError<crate::error::EnableSnapshotCopyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::EnableSnapshotCopyInputOperationOutputAlias,
                crate::output::EnableSnapshotCopyOutput,
                crate::error::EnableSnapshotCopyError,
                crate::input::EnableSnapshotCopyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the source cluster to copy snapshots from.</p>
        /// <p>Constraints: Must be the valid name of an existing cluster that does not already
        /// have cross-region snapshot copy enabled.</p>
        pub fn cluster_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_identifier(inp);
            self
        }
        /// <p>The unique identifier of the source cluster to copy snapshots from.</p>
        /// <p>Constraints: Must be the valid name of an existing cluster that does not already
        /// have cross-region snapshot copy enabled.</p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_identifier(input);
            self
        }
        /// <p>The destination Amazon Web Services Region that you want to copy snapshots to.</p>
        /// <p>Constraints: Must be the name of a valid Amazon Web Services Region. For more information, see
        /// <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#redshift_region">Regions and Endpoints</a> in the Amazon Web Services General Reference.
        /// </p>
        pub fn destination_region(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.destination_region(inp);
            self
        }
        /// <p>The destination Amazon Web Services Region that you want to copy snapshots to.</p>
        /// <p>Constraints: Must be the name of a valid Amazon Web Services Region. For more information, see
        /// <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#redshift_region">Regions and Endpoints</a> in the Amazon Web Services General Reference.
        /// </p>
        pub fn set_destination_region(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_destination_region(input);
            self
        }
        /// <p>The number of days to retain automated snapshots in the destination region after
        /// they are copied from the source region.</p>
        /// <p>Default: 7.</p>
        /// <p>Constraints: Must be at least 1 and no more than 35.</p>
        pub fn retention_period(mut self, inp: i32) -> Self {
            self.inner = self.inner.retention_period(inp);
            self
        }
        /// <p>The number of days to retain automated snapshots in the destination region after
        /// they are copied from the source region.</p>
        /// <p>Default: 7.</p>
        /// <p>Constraints: Must be at least 1 and no more than 35.</p>
        pub fn set_retention_period(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_retention_period(input);
            self
        }
        /// <p>The name of the snapshot copy grant to use when snapshots of an Amazon Web Services KMS-encrypted
        /// cluster are copied to the destination region.</p>
        pub fn snapshot_copy_grant_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.snapshot_copy_grant_name(inp);
            self
        }
        /// <p>The name of the snapshot copy grant to use when snapshots of an Amazon Web Services KMS-encrypted
        /// cluster are copied to the destination region.</p>
        pub fn set_snapshot_copy_grant_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_snapshot_copy_grant_name(input);
            self
        }
        /// <p>The number of days to retain newly copied snapshots in the destination Amazon Web Services Region
        /// after they are copied from the source Amazon Web Services Region. If the value is -1, the manual
        /// snapshot is retained indefinitely. </p>
        /// <p>The value must be either -1 or an integer between 1 and 3,653.</p>
        pub fn manual_snapshot_retention_period(mut self, inp: i32) -> Self {
            self.inner = self.inner.manual_snapshot_retention_period(inp);
            self
        }
        /// <p>The number of days to retain newly copied snapshots in the destination Amazon Web Services Region
        /// after they are copied from the source Amazon Web Services Region. If the value is -1, the manual
        /// snapshot is retained indefinitely. </p>
        /// <p>The value must be either -1 or an integer between 1 and 3,653.</p>
        pub fn set_manual_snapshot_retention_period(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.inner = self.inner.set_manual_snapshot_retention_period(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetClusterCredentials`.
    ///
    /// <p>Returns a database user name and temporary password with temporary authorization to
    /// log on to an Amazon Redshift database. The action returns the database user name
    /// prefixed with <code>IAM:</code> if <code>AutoCreate</code> is <code>False</code> or
    /// <code>IAMA:</code> if <code>AutoCreate</code> is <code>True</code>. You can
    /// optionally specify one or more database user groups that the user will join at log on.
    /// By default, the temporary credentials expire in 900 seconds. You can optionally specify
    /// a duration between 900 seconds (15 minutes) and 3600 seconds (60 minutes). For more
    /// information, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/generating-user-credentials.html">Using IAM Authentication
    /// to Generate Database User Credentials</a> in the Amazon Redshift Cluster Management Guide.</p>
    /// <p>The Identity and Access Management (IAM) user or role that runs
    /// GetClusterCredentials must have an IAM policy attached that allows access to all
    /// necessary actions and resources. For more information about permissions, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-identity-based.html#redshift-policy-resources.getclustercredentials-resources">Resource Policies for GetClusterCredentials</a> in the
    /// Amazon Redshift Cluster Management Guide.</p>
    /// <p>If the <code>DbGroups</code> parameter is specified, the IAM policy must allow the
    /// <code>redshift:JoinGroup</code> action with access to the listed
    /// <code>dbgroups</code>. </p>
    /// <p>In addition, if the <code>AutoCreate</code> parameter is set to <code>True</code>,
    /// then the policy must include the <code>redshift:CreateClusterUser</code>
    /// privilege.</p>
    /// <p>If the <code>DbName</code> parameter is specified, the IAM policy must allow access
    /// to the resource <code>dbname</code> for the specified database name. </p>
    #[derive(std::fmt::Debug)]
    pub struct GetClusterCredentials<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_cluster_credentials_input::Builder,
    }
    impl<C, M, R> GetClusterCredentials<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetClusterCredentials`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetClusterCredentialsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetClusterCredentialsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetClusterCredentialsInputOperationOutputAlias,
                crate::output::GetClusterCredentialsOutput,
                crate::error::GetClusterCredentialsError,
                crate::input::GetClusterCredentialsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of a database user. If a user name matching <code>DbUser</code> exists in
        /// the database, the temporary user credentials have the same permissions as the existing
        /// user. If <code>DbUser</code> doesn't exist in the database and <code>Autocreate</code>
        /// is <code>True</code>, a new user is created using the value for <code>DbUser</code> with
        /// PUBLIC permissions. If a database user matching the value for <code>DbUser</code>
        /// doesn't exist and <code>Autocreate</code> is <code>False</code>, then the command
        /// succeeds but the connection attempt will fail because the user doesn't exist in the
        /// database.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/redshift/latest/dg/r_CREATE_USER.html">CREATE USER</a> in the Amazon
        /// Redshift Database Developer Guide. </p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be 1 to 64 alphanumeric characters or hyphens. The user name can't be
        /// <code>PUBLIC</code>.</p>
        /// </li>
        /// <li>
        /// <p>Must contain only lowercase letters, numbers, underscore, plus sign, period
        /// (dot), at symbol (@), or hyphen.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Must not contain a colon ( : ) or slash ( / ). </p>
        /// </li>
        /// <li>
        /// <p>Cannot be a reserved word. A list of reserved words can be found in <a href="http://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html">Reserved Words</a> in the Amazon
        /// Redshift Database Developer Guide.</p>
        /// </li>
        /// </ul>
        pub fn db_user(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_user(inp);
            self
        }
        /// <p>The name of a database user. If a user name matching <code>DbUser</code> exists in
        /// the database, the temporary user credentials have the same permissions as the existing
        /// user. If <code>DbUser</code> doesn't exist in the database and <code>Autocreate</code>
        /// is <code>True</code>, a new user is created using the value for <code>DbUser</code> with
        /// PUBLIC permissions. If a database user matching the value for <code>DbUser</code>
        /// doesn't exist and <code>Autocreate</code> is <code>False</code>, then the command
        /// succeeds but the connection attempt will fail because the user doesn't exist in the
        /// database.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/redshift/latest/dg/r_CREATE_USER.html">CREATE USER</a> in the Amazon
        /// Redshift Database Developer Guide. </p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be 1 to 64 alphanumeric characters or hyphens. The user name can't be
        /// <code>PUBLIC</code>.</p>
        /// </li>
        /// <li>
        /// <p>Must contain only lowercase letters, numbers, underscore, plus sign, period
        /// (dot), at symbol (@), or hyphen.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Must not contain a colon ( : ) or slash ( / ). </p>
        /// </li>
        /// <li>
        /// <p>Cannot be a reserved word. A list of reserved words can be found in <a href="http://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html">Reserved Words</a> in the Amazon
        /// Redshift Database Developer Guide.</p>
        /// </li>
        /// </ul>
        pub fn set_db_user(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_db_user(input);
            self
        }
        /// <p>The name of a database that <code>DbUser</code> is authorized to log on to. If
        /// <code>DbName</code> is not specified, <code>DbUser</code> can log on to any existing
        /// database.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be 1 to 64 alphanumeric characters or hyphens</p>
        /// </li>
        /// <li>
        /// <p>Must contain only lowercase letters, numbers, underscore, plus sign, period
        /// (dot), at symbol (@), or hyphen.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Must not contain a colon ( : ) or slash ( / ). </p>
        /// </li>
        /// <li>
        /// <p>Cannot be a reserved word. A list of reserved words can be found in <a href="http://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html">Reserved Words</a> in the Amazon
        /// Redshift Database Developer Guide.</p>
        /// </li>
        /// </ul>
        pub fn db_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_name(inp);
            self
        }
        /// <p>The name of a database that <code>DbUser</code> is authorized to log on to. If
        /// <code>DbName</code> is not specified, <code>DbUser</code> can log on to any existing
        /// database.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be 1 to 64 alphanumeric characters or hyphens</p>
        /// </li>
        /// <li>
        /// <p>Must contain only lowercase letters, numbers, underscore, plus sign, period
        /// (dot), at symbol (@), or hyphen.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Must not contain a colon ( : ) or slash ( / ). </p>
        /// </li>
        /// <li>
        /// <p>Cannot be a reserved word. A list of reserved words can be found in <a href="http://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html">Reserved Words</a> in the Amazon
        /// Redshift Database Developer Guide.</p>
        /// </li>
        /// </ul>
        pub fn set_db_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_db_name(input);
            self
        }
        /// <p>The unique identifier of the cluster that contains the database for which your are
        /// requesting credentials. This parameter is case sensitive.</p>
        pub fn cluster_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_identifier(inp);
            self
        }
        /// <p>The unique identifier of the cluster that contains the database for which your are
        /// requesting credentials. This parameter is case sensitive.</p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_identifier(input);
            self
        }
        /// <p>The number of seconds until the returned temporary password expires.</p>
        /// <p>Constraint: minimum 900, maximum 3600.</p>
        /// <p>Default: 900</p>
        pub fn duration_seconds(mut self, inp: i32) -> Self {
            self.inner = self.inner.duration_seconds(inp);
            self
        }
        /// <p>The number of seconds until the returned temporary password expires.</p>
        /// <p>Constraint: minimum 900, maximum 3600.</p>
        /// <p>Default: 900</p>
        pub fn set_duration_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_duration_seconds(input);
            self
        }
        /// <p>Create a database user with the name specified for the user named in
        /// <code>DbUser</code> if one does not exist.</p>
        pub fn auto_create(mut self, inp: bool) -> Self {
            self.inner = self.inner.auto_create(inp);
            self
        }
        /// <p>Create a database user with the name specified for the user named in
        /// <code>DbUser</code> if one does not exist.</p>
        pub fn set_auto_create(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_auto_create(input);
            self
        }
        /// Appends an item to `DbGroups`.
        ///
        /// To override the contents of this collection use [`set_db_groups`](Self::set_db_groups).
        ///
        /// <p>A list of the names of existing database groups that the user named in
        /// <code>DbUser</code> will join for the current session, in addition to any group
        /// memberships for an existing user. If not specified, a new user is added only to
        /// PUBLIC.</p>
        /// <p>Database group name constraints</p>
        /// <ul>
        /// <li>
        /// <p>Must be 1 to 64 alphanumeric characters or hyphens</p>
        /// </li>
        /// <li>
        /// <p>Must contain only lowercase letters, numbers, underscore, plus sign, period
        /// (dot), at symbol (@), or hyphen.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Must not contain a colon ( : ) or slash ( / ). </p>
        /// </li>
        /// <li>
        /// <p>Cannot be a reserved word. A list of reserved words can be found in <a href="http://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html">Reserved Words</a> in the Amazon
        /// Redshift Database Developer Guide.</p>
        /// </li>
        /// </ul>
        pub fn db_groups(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_groups(inp);
            self
        }
        /// <p>A list of the names of existing database groups that the user named in
        /// <code>DbUser</code> will join for the current session, in addition to any group
        /// memberships for an existing user. If not specified, a new user is added only to
        /// PUBLIC.</p>
        /// <p>Database group name constraints</p>
        /// <ul>
        /// <li>
        /// <p>Must be 1 to 64 alphanumeric characters or hyphens</p>
        /// </li>
        /// <li>
        /// <p>Must contain only lowercase letters, numbers, underscore, plus sign, period
        /// (dot), at symbol (@), or hyphen.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Must not contain a colon ( : ) or slash ( / ). </p>
        /// </li>
        /// <li>
        /// <p>Cannot be a reserved word. A list of reserved words can be found in <a href="http://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html">Reserved Words</a> in the Amazon
        /// Redshift Database Developer Guide.</p>
        /// </li>
        /// </ul>
        pub fn set_db_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_db_groups(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetReservedNodeExchangeOfferings`.
    ///
    /// <p>Returns an array of DC2 ReservedNodeOfferings that matches the payment type, term,
    /// and usage price of the given DC1 reserved node.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetReservedNodeExchangeOfferings<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_reserved_node_exchange_offerings_input::Builder,
    }
    impl<C, M, R> GetReservedNodeExchangeOfferings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetReservedNodeExchangeOfferings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetReservedNodeExchangeOfferingsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetReservedNodeExchangeOfferingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetReservedNodeExchangeOfferingsInputOperationOutputAlias,
                crate::output::GetReservedNodeExchangeOfferingsOutput,
                crate::error::GetReservedNodeExchangeOfferingsError,
                crate::input::GetReservedNodeExchangeOfferingsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A string representing the node identifier for the DC1 Reserved Node to be
        /// exchanged.</p>
        pub fn reserved_node_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.reserved_node_id(inp);
            self
        }
        /// <p>A string representing the node identifier for the DC1 Reserved Node to be
        /// exchanged.</p>
        pub fn set_reserved_node_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_reserved_node_id(input);
            self
        }
        /// <p>An integer setting the maximum number of ReservedNodeOfferings to
        /// retrieve.</p>
        pub fn max_records(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_records(inp);
            self
        }
        /// <p>An integer setting the maximum number of ReservedNodeOfferings to
        /// retrieve.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>A value that indicates the starting point for the next set of
        /// ReservedNodeOfferings.</p>
        pub fn marker(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(inp);
            self
        }
        /// <p>A value that indicates the starting point for the next set of
        /// ReservedNodeOfferings.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyAquaConfiguration`.
    ///
    /// <p>Modifies whether a cluster can use AQUA (Advanced Query Accelerator). </p>
    #[derive(std::fmt::Debug)]
    pub struct ModifyAquaConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::modify_aqua_configuration_input::Builder,
    }
    impl<C, M, R> ModifyAquaConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ModifyAquaConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyAquaConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifyAquaConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ModifyAquaConfigurationInputOperationOutputAlias,
                crate::output::ModifyAquaConfigurationOutput,
                crate::error::ModifyAquaConfigurationError,
                crate::input::ModifyAquaConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the cluster to be modified.</p>
        pub fn cluster_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_identifier(inp);
            self
        }
        /// <p>The identifier of the cluster to be modified.</p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_identifier(input);
            self
        }
        /// <p>The new value of AQUA configuration status. Possible values include the following.</p>
        /// <ul>
        /// <li>
        /// <p>enabled - Use AQUA if it is available for the current Amazon Web Services Region and Amazon Redshift node type.</p>
        /// </li>
        /// <li>
        /// <p>disabled - Don't use AQUA. </p>
        /// </li>
        /// <li>
        /// <p>auto - Amazon Redshift determines whether to use AQUA.</p>
        /// </li>
        /// </ul>
        pub fn aqua_configuration_status(
            mut self,
            inp: crate::model::AquaConfigurationStatus,
        ) -> Self {
            self.inner = self.inner.aqua_configuration_status(inp);
            self
        }
        /// <p>The new value of AQUA configuration status. Possible values include the following.</p>
        /// <ul>
        /// <li>
        /// <p>enabled - Use AQUA if it is available for the current Amazon Web Services Region and Amazon Redshift node type.</p>
        /// </li>
        /// <li>
        /// <p>disabled - Don't use AQUA. </p>
        /// </li>
        /// <li>
        /// <p>auto - Amazon Redshift determines whether to use AQUA.</p>
        /// </li>
        /// </ul>
        pub fn set_aqua_configuration_status(
            mut self,
            input: std::option::Option<crate::model::AquaConfigurationStatus>,
        ) -> Self {
            self.inner = self.inner.set_aqua_configuration_status(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyAuthenticationProfile`.
    ///
    /// <p>Modifies an authentication profile.</p>
    #[derive(std::fmt::Debug)]
    pub struct ModifyAuthenticationProfile<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::modify_authentication_profile_input::Builder,
    }
    impl<C, M, R> ModifyAuthenticationProfile<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ModifyAuthenticationProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyAuthenticationProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifyAuthenticationProfileError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ModifyAuthenticationProfileInputOperationOutputAlias,
                crate::output::ModifyAuthenticationProfileOutput,
                crate::error::ModifyAuthenticationProfileError,
                crate::input::ModifyAuthenticationProfileInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the authentication profile to replace.</p>
        pub fn authentication_profile_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.authentication_profile_name(inp);
            self
        }
        /// <p>The name of the authentication profile to replace.</p>
        pub fn set_authentication_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_authentication_profile_name(input);
            self
        }
        /// <p>The new content of the authentication profile in JSON format.
        /// The maximum length of the JSON string is determined by a quota for your account.</p>
        pub fn authentication_profile_content(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.authentication_profile_content(inp);
            self
        }
        /// <p>The new content of the authentication profile in JSON format.
        /// The maximum length of the JSON string is determined by a quota for your account.</p>
        pub fn set_authentication_profile_content(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_authentication_profile_content(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyCluster`.
    ///
    /// <p>Modifies the settings for a cluster.</p>       
    /// <p>You can also change node type and the number of nodes to scale up or down the
    /// cluster. When resizing a cluster, you must specify both the number of nodes and the node
    /// type even if one of the parameters does not change.</p>
    /// <p>You can add another security or
    /// parameter group, or change the admin user password. Resetting a cluster password or modifying the security groups associated with a cluster do not need a reboot. However, modifying a parameter group requires a reboot for parameters to take effect.
    /// For more information about managing clusters, go to
    /// <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html">Amazon Redshift Clusters</a>
    /// in the <i>Amazon Redshift Cluster Management Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct ModifyCluster<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::modify_cluster_input::Builder,
    }
    impl<C, M, R> ModifyCluster<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ModifyCluster`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyClusterOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifyClusterError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ModifyClusterInputOperationOutputAlias,
                crate::output::ModifyClusterOutput,
                crate::error::ModifyClusterError,
                crate::input::ModifyClusterInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the cluster to be modified.</p>
        /// <p>Example: <code>examplecluster</code>
        /// </p>
        pub fn cluster_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_identifier(inp);
            self
        }
        /// <p>The unique identifier of the cluster to be modified.</p>
        /// <p>Example: <code>examplecluster</code>
        /// </p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_identifier(input);
            self
        }
        /// <p>The new cluster type.</p>
        /// <p>When you submit your cluster resize request, your existing cluster goes into a
        /// read-only mode. After Amazon Redshift provisions a new cluster based on your resize
        /// requirements, there will be outage for a period while the old cluster is deleted and
        /// your connection is switched to the new cluster. You can use <a>DescribeResize</a> to track the progress of the resize request. </p>
        /// <p>Valid Values: <code> multi-node | single-node </code>
        /// </p>
        pub fn cluster_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_type(inp);
            self
        }
        /// <p>The new cluster type.</p>
        /// <p>When you submit your cluster resize request, your existing cluster goes into a
        /// read-only mode. After Amazon Redshift provisions a new cluster based on your resize
        /// requirements, there will be outage for a period while the old cluster is deleted and
        /// your connection is switched to the new cluster. You can use <a>DescribeResize</a> to track the progress of the resize request. </p>
        /// <p>Valid Values: <code> multi-node | single-node </code>
        /// </p>
        pub fn set_cluster_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster_type(input);
            self
        }
        /// <p>The new node type of the cluster. If you specify a new node type, you must also
        /// specify the number of nodes parameter.</p>
        /// <p>
        /// For more information about resizing clusters, go to
        /// <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/rs-resize-tutorial.html">Resizing Clusters in Amazon Redshift</a>
        /// in the <i>Amazon Redshift Cluster Management Guide</i>.</p>
        ///
        /// <p>Valid Values: <code>ds2.xlarge</code> | <code>ds2.8xlarge</code> |
        /// <code>dc1.large</code> | <code>dc1.8xlarge</code> |
        /// <code>dc2.large</code> | <code>dc2.8xlarge</code> |
        /// <code>ra3.xlplus</code> |  <code>ra3.4xlarge</code> | <code>ra3.16xlarge</code>
        /// </p>
        pub fn node_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.node_type(inp);
            self
        }
        /// <p>The new node type of the cluster. If you specify a new node type, you must also
        /// specify the number of nodes parameter.</p>
        /// <p>
        /// For more information about resizing clusters, go to
        /// <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/rs-resize-tutorial.html">Resizing Clusters in Amazon Redshift</a>
        /// in the <i>Amazon Redshift Cluster Management Guide</i>.</p>
        ///
        /// <p>Valid Values: <code>ds2.xlarge</code> | <code>ds2.8xlarge</code> |
        /// <code>dc1.large</code> | <code>dc1.8xlarge</code> |
        /// <code>dc2.large</code> | <code>dc2.8xlarge</code> |
        /// <code>ra3.xlplus</code> |  <code>ra3.4xlarge</code> | <code>ra3.16xlarge</code>
        /// </p>
        pub fn set_node_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_node_type(input);
            self
        }
        /// <p>The new number of nodes of the cluster. If you specify a new number of nodes, you
        /// must also specify the node type parameter.</p>
        /// <p>
        /// For more information about resizing clusters, go to
        /// <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/rs-resize-tutorial.html">Resizing Clusters in Amazon Redshift</a>
        /// in the <i>Amazon Redshift Cluster Management Guide</i>.</p>
        ///
        /// <p>Valid Values: Integer greater than <code>0</code>.</p>
        pub fn number_of_nodes(mut self, inp: i32) -> Self {
            self.inner = self.inner.number_of_nodes(inp);
            self
        }
        /// <p>The new number of nodes of the cluster. If you specify a new number of nodes, you
        /// must also specify the node type parameter.</p>
        /// <p>
        /// For more information about resizing clusters, go to
        /// <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/rs-resize-tutorial.html">Resizing Clusters in Amazon Redshift</a>
        /// in the <i>Amazon Redshift Cluster Management Guide</i>.</p>
        ///
        /// <p>Valid Values: Integer greater than <code>0</code>.</p>
        pub fn set_number_of_nodes(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_number_of_nodes(input);
            self
        }
        /// Appends an item to `ClusterSecurityGroups`.
        ///
        /// To override the contents of this collection use [`set_cluster_security_groups`](Self::set_cluster_security_groups).
        ///
        /// <p>A list of cluster security groups to be authorized on this cluster. This change is
        /// asynchronously applied as soon as possible.</p>
        /// <p>Security groups currently associated with the cluster, and not in the list of
        /// groups to apply, will be revoked from the cluster.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be 1 to 255 alphanumeric characters or hyphens</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens</p>
        /// </li>
        /// </ul>
        pub fn cluster_security_groups(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_security_groups(inp);
            self
        }
        /// <p>A list of cluster security groups to be authorized on this cluster. This change is
        /// asynchronously applied as soon as possible.</p>
        /// <p>Security groups currently associated with the cluster, and not in the list of
        /// groups to apply, will be revoked from the cluster.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be 1 to 255 alphanumeric characters or hyphens</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens</p>
        /// </li>
        /// </ul>
        pub fn set_cluster_security_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_cluster_security_groups(input);
            self
        }
        /// Appends an item to `VpcSecurityGroupIds`.
        ///
        /// To override the contents of this collection use [`set_vpc_security_group_ids`](Self::set_vpc_security_group_ids).
        ///
        /// <p>A list of virtual private cloud (VPC) security groups to be associated with the
        /// cluster. This change is asynchronously applied as soon as possible.</p>
        pub fn vpc_security_group_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc_security_group_ids(inp);
            self
        }
        /// <p>A list of virtual private cloud (VPC) security groups to be associated with the
        /// cluster. This change is asynchronously applied as soon as possible.</p>
        pub fn set_vpc_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_vpc_security_group_ids(input);
            self
        }
        /// <p>The new password for the cluster admin user. This change is asynchronously applied
        /// as soon as possible. Between the time of the request and the completion of the request,
        /// the <code>MasterUserPassword</code> element exists in the
        /// <code>PendingModifiedValues</code> element of the operation response. </p>
        /// <note>
        /// <p>Operations never return the password, so this operation provides a way to
        /// regain access to the admin user account for a cluster if the password is
        /// lost.</p>
        /// </note>
        /// <p>Default: Uses existing setting.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be between 8 and 64 characters in length.</p>
        /// </li>
        /// <li>
        /// <p>Must contain at least one uppercase letter.</p>
        /// </li>
        /// <li>
        /// <p>Must contain at least one lowercase letter.</p>
        /// </li>
        /// <li>
        /// <p>Must contain one number.</p>
        /// </li>
        /// <li>
        /// <p>Can be any printable ASCII character (ASCII code 33 to 126) except '
        /// (single quote), " (double quote), \, /, @, or space.</p>
        /// </li>
        /// </ul>
        pub fn master_user_password(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.master_user_password(inp);
            self
        }
        /// <p>The new password for the cluster admin user. This change is asynchronously applied
        /// as soon as possible. Between the time of the request and the completion of the request,
        /// the <code>MasterUserPassword</code> element exists in the
        /// <code>PendingModifiedValues</code> element of the operation response. </p>
        /// <note>
        /// <p>Operations never return the password, so this operation provides a way to
        /// regain access to the admin user account for a cluster if the password is
        /// lost.</p>
        /// </note>
        /// <p>Default: Uses existing setting.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be between 8 and 64 characters in length.</p>
        /// </li>
        /// <li>
        /// <p>Must contain at least one uppercase letter.</p>
        /// </li>
        /// <li>
        /// <p>Must contain at least one lowercase letter.</p>
        /// </li>
        /// <li>
        /// <p>Must contain one number.</p>
        /// </li>
        /// <li>
        /// <p>Can be any printable ASCII character (ASCII code 33 to 126) except '
        /// (single quote), " (double quote), \, /, @, or space.</p>
        /// </li>
        /// </ul>
        pub fn set_master_user_password(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_master_user_password(input);
            self
        }
        /// <p>The name of the cluster parameter group to apply to this cluster. This change is
        /// applied only after the cluster is rebooted. To reboot a cluster use <a>RebootCluster</a>. </p>
        /// <p>Default: Uses existing setting.</p>
        /// <p>Constraints: The cluster parameter group must be in the same parameter group family
        /// that matches the cluster version.</p>
        pub fn cluster_parameter_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_parameter_group_name(inp);
            self
        }
        /// <p>The name of the cluster parameter group to apply to this cluster. This change is
        /// applied only after the cluster is rebooted. To reboot a cluster use <a>RebootCluster</a>. </p>
        /// <p>Default: Uses existing setting.</p>
        /// <p>Constraints: The cluster parameter group must be in the same parameter group family
        /// that matches the cluster version.</p>
        pub fn set_cluster_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_parameter_group_name(input);
            self
        }
        /// <p>The number of days that automated snapshots are retained. If the value is 0,
        /// automated snapshots are disabled. Even if automated snapshots are disabled, you can
        /// still create manual snapshots when you want with <a>CreateClusterSnapshot</a>. </p>
        /// <p>If you decrease the automated snapshot retention period from its current value,
        /// existing automated snapshots that fall outside of the new retention period will be
        /// immediately deleted.</p>
        ///
        /// <p>You can't disable automated snapshots for RA3 node types. Set the automated retention period from 1-35 days.</p>
        /// <p>Default: Uses existing setting.</p>
        /// <p>Constraints: Must be a value from 0 to 35.</p>
        pub fn automated_snapshot_retention_period(mut self, inp: i32) -> Self {
            self.inner = self.inner.automated_snapshot_retention_period(inp);
            self
        }
        /// <p>The number of days that automated snapshots are retained. If the value is 0,
        /// automated snapshots are disabled. Even if automated snapshots are disabled, you can
        /// still create manual snapshots when you want with <a>CreateClusterSnapshot</a>. </p>
        /// <p>If you decrease the automated snapshot retention period from its current value,
        /// existing automated snapshots that fall outside of the new retention period will be
        /// immediately deleted.</p>
        ///
        /// <p>You can't disable automated snapshots for RA3 node types. Set the automated retention period from 1-35 days.</p>
        /// <p>Default: Uses existing setting.</p>
        /// <p>Constraints: Must be a value from 0 to 35.</p>
        pub fn set_automated_snapshot_retention_period(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.inner = self.inner.set_automated_snapshot_retention_period(input);
            self
        }
        /// <p>The default for number of days that a newly created manual snapshot is retained. If
        /// the value is -1, the manual snapshot is retained indefinitely. This value doesn't
        /// retroactively change the retention periods of existing manual snapshots.</p>
        /// <p>The value must be either -1 or an integer between 1 and 3,653.</p>
        /// <p>The default value is -1.</p>
        pub fn manual_snapshot_retention_period(mut self, inp: i32) -> Self {
            self.inner = self.inner.manual_snapshot_retention_period(inp);
            self
        }
        /// <p>The default for number of days that a newly created manual snapshot is retained. If
        /// the value is -1, the manual snapshot is retained indefinitely. This value doesn't
        /// retroactively change the retention periods of existing manual snapshots.</p>
        /// <p>The value must be either -1 or an integer between 1 and 3,653.</p>
        /// <p>The default value is -1.</p>
        pub fn set_manual_snapshot_retention_period(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.inner = self.inner.set_manual_snapshot_retention_period(input);
            self
        }
        /// <p>The weekly time range (in UTC) during which system maintenance can occur, if
        /// necessary. If system maintenance is necessary during the window, it may result in an
        /// outage.</p>
        /// <p>This maintenance window change is made immediately. If the new maintenance window
        /// indicates the current time, there must be at least 120 minutes between the current time
        /// and end of the window in order to ensure that pending changes are applied.</p>
        /// <p>Default: Uses existing setting.</p>
        /// <p>Format: ddd:hh24:mi-ddd:hh24:mi, for example
        /// <code>wed:07:30-wed:08:00</code>.</p>
        /// <p>Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun</p>
        /// <p>Constraints: Must be at least 30 minutes.</p>
        pub fn preferred_maintenance_window(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.preferred_maintenance_window(inp);
            self
        }
        /// <p>The weekly time range (in UTC) during which system maintenance can occur, if
        /// necessary. If system maintenance is necessary during the window, it may result in an
        /// outage.</p>
        /// <p>This maintenance window change is made immediately. If the new maintenance window
        /// indicates the current time, there must be at least 120 minutes between the current time
        /// and end of the window in order to ensure that pending changes are applied.</p>
        /// <p>Default: Uses existing setting.</p>
        /// <p>Format: ddd:hh24:mi-ddd:hh24:mi, for example
        /// <code>wed:07:30-wed:08:00</code>.</p>
        /// <p>Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun</p>
        /// <p>Constraints: Must be at least 30 minutes.</p>
        pub fn set_preferred_maintenance_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_preferred_maintenance_window(input);
            self
        }
        /// <p>The new version number of the Amazon Redshift engine to upgrade to.</p>
        /// <p>For major version upgrades, if a non-default cluster parameter group is currently
        /// in use, a new cluster parameter group in the cluster parameter group family for the new
        /// version must be specified. The new cluster parameter group can be the default for that
        /// cluster parameter group family.
        /// For more information about parameters and parameter groups, go to
        /// <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Amazon Redshift Parameter Groups</a>
        /// in the <i>Amazon Redshift Cluster Management Guide</i>.</p>
        /// <p>Example: <code>1.0</code>
        /// </p>
        pub fn cluster_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_version(inp);
            self
        }
        /// <p>The new version number of the Amazon Redshift engine to upgrade to.</p>
        /// <p>For major version upgrades, if a non-default cluster parameter group is currently
        /// in use, a new cluster parameter group in the cluster parameter group family for the new
        /// version must be specified. The new cluster parameter group can be the default for that
        /// cluster parameter group family.
        /// For more information about parameters and parameter groups, go to
        /// <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Amazon Redshift Parameter Groups</a>
        /// in the <i>Amazon Redshift Cluster Management Guide</i>.</p>
        /// <p>Example: <code>1.0</code>
        /// </p>
        pub fn set_cluster_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_version(input);
            self
        }
        /// <p>If <code>true</code>, major version upgrades will be applied automatically to the
        /// cluster during the maintenance window. </p>
        /// <p>Default: <code>false</code>
        /// </p>
        pub fn allow_version_upgrade(mut self, inp: bool) -> Self {
            self.inner = self.inner.allow_version_upgrade(inp);
            self
        }
        /// <p>If <code>true</code>, major version upgrades will be applied automatically to the
        /// cluster during the maintenance window. </p>
        /// <p>Default: <code>false</code>
        /// </p>
        pub fn set_allow_version_upgrade(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_allow_version_upgrade(input);
            self
        }
        /// <p>Specifies the name of the HSM client certificate the Amazon Redshift cluster uses to
        /// retrieve the data encryption keys stored in an HSM.</p>
        pub fn hsm_client_certificate_identifier(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.hsm_client_certificate_identifier(inp);
            self
        }
        /// <p>Specifies the name of the HSM client certificate the Amazon Redshift cluster uses to
        /// retrieve the data encryption keys stored in an HSM.</p>
        pub fn set_hsm_client_certificate_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_hsm_client_certificate_identifier(input);
            self
        }
        /// <p>Specifies the name of the HSM configuration that contains the information the
        /// Amazon Redshift cluster can use to retrieve and store keys in an HSM.</p>
        pub fn hsm_configuration_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hsm_configuration_identifier(inp);
            self
        }
        /// <p>Specifies the name of the HSM configuration that contains the information the
        /// Amazon Redshift cluster can use to retrieve and store keys in an HSM.</p>
        pub fn set_hsm_configuration_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_hsm_configuration_identifier(input);
            self
        }
        /// <p>The new identifier for the cluster.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain from 1 to 63 alphanumeric characters or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>Alphabetic characters must be lowercase.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// <li>
        /// <p>Must be unique for all clusters within an Amazon Web Services account.</p>
        /// </li>
        /// </ul>
        ///
        /// <p>Example: <code>examplecluster</code>
        /// </p>
        pub fn new_cluster_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.new_cluster_identifier(inp);
            self
        }
        /// <p>The new identifier for the cluster.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain from 1 to 63 alphanumeric characters or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>Alphabetic characters must be lowercase.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// <li>
        /// <p>Must be unique for all clusters within an Amazon Web Services account.</p>
        /// </li>
        /// </ul>
        ///
        /// <p>Example: <code>examplecluster</code>
        /// </p>
        pub fn set_new_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_new_cluster_identifier(input);
            self
        }
        /// <p>If <code>true</code>, the cluster can be accessed from a public network. Only
        /// clusters in VPCs can be set to be publicly available.</p>
        pub fn publicly_accessible(mut self, inp: bool) -> Self {
            self.inner = self.inner.publicly_accessible(inp);
            self
        }
        /// <p>If <code>true</code>, the cluster can be accessed from a public network. Only
        /// clusters in VPCs can be set to be publicly available.</p>
        pub fn set_publicly_accessible(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_publicly_accessible(input);
            self
        }
        /// <p>The Elastic IP (EIP) address for the cluster.</p>
        /// <p>Constraints: The cluster must be provisioned in EC2-VPC and publicly-accessible
        /// through an Internet gateway. For more information about provisioning clusters in
        /// EC2-VPC, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#cluster-platforms">Supported
        /// Platforms to Launch Your Cluster</a> in the Amazon Redshift Cluster Management Guide.</p>
        pub fn elastic_ip(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.elastic_ip(inp);
            self
        }
        /// <p>The Elastic IP (EIP) address for the cluster.</p>
        /// <p>Constraints: The cluster must be provisioned in EC2-VPC and publicly-accessible
        /// through an Internet gateway. For more information about provisioning clusters in
        /// EC2-VPC, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#cluster-platforms">Supported
        /// Platforms to Launch Your Cluster</a> in the Amazon Redshift Cluster Management Guide.</p>
        pub fn set_elastic_ip(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_elastic_ip(input);
            self
        }
        /// <p>An option that specifies whether to create the cluster with enhanced VPC routing
        /// enabled. To create a cluster that uses enhanced VPC routing, the cluster must be in a
        /// VPC. For more information, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html">Enhanced VPC Routing</a> in
        /// the Amazon Redshift Cluster Management Guide.</p>
        /// <p>If this option is <code>true</code>, enhanced VPC routing is enabled. </p>
        /// <p>Default: false</p>
        pub fn enhanced_vpc_routing(mut self, inp: bool) -> Self {
            self.inner = self.inner.enhanced_vpc_routing(inp);
            self
        }
        /// <p>An option that specifies whether to create the cluster with enhanced VPC routing
        /// enabled. To create a cluster that uses enhanced VPC routing, the cluster must be in a
        /// VPC. For more information, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html">Enhanced VPC Routing</a> in
        /// the Amazon Redshift Cluster Management Guide.</p>
        /// <p>If this option is <code>true</code>, enhanced VPC routing is enabled. </p>
        /// <p>Default: false</p>
        pub fn set_enhanced_vpc_routing(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enhanced_vpc_routing(input);
            self
        }
        /// <p>The name for the maintenance track that you want to assign for the cluster. This name
        /// change is asynchronous. The new track name stays in the
        /// <code>PendingModifiedValues</code> for the cluster until the next maintenance
        /// window. When the maintenance track changes, the cluster is switched to the latest
        /// cluster release available for the maintenance track. At this point, the maintenance
        /// track name is applied.</p>
        pub fn maintenance_track_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.maintenance_track_name(inp);
            self
        }
        /// <p>The name for the maintenance track that you want to assign for the cluster. This name
        /// change is asynchronous. The new track name stays in the
        /// <code>PendingModifiedValues</code> for the cluster until the next maintenance
        /// window. When the maintenance track changes, the cluster is switched to the latest
        /// cluster release available for the maintenance track. At this point, the maintenance
        /// track name is applied.</p>
        pub fn set_maintenance_track_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_maintenance_track_name(input);
            self
        }
        /// <p>Indicates whether the cluster is encrypted. If the value is encrypted (true) and you
        /// provide a value for the <code>KmsKeyId</code> parameter, we encrypt the cluster
        /// with the provided <code>KmsKeyId</code>. If you don't provide a <code>KmsKeyId</code>,
        /// we encrypt with the default key. </p>
        /// <p>If the value is not encrypted (false), then the cluster is decrypted. </p>
        pub fn encrypted(mut self, inp: bool) -> Self {
            self.inner = self.inner.encrypted(inp);
            self
        }
        /// <p>Indicates whether the cluster is encrypted. If the value is encrypted (true) and you
        /// provide a value for the <code>KmsKeyId</code> parameter, we encrypt the cluster
        /// with the provided <code>KmsKeyId</code>. If you don't provide a <code>KmsKeyId</code>,
        /// we encrypt with the default key. </p>
        /// <p>If the value is not encrypted (false), then the cluster is decrypted. </p>
        pub fn set_encrypted(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_encrypted(input);
            self
        }
        /// <p>The Key Management Service (KMS) key ID of the encryption key that you want to use
        /// to encrypt data in the cluster.</p>
        pub fn kms_key_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key_id(inp);
            self
        }
        /// <p>The Key Management Service (KMS) key ID of the encryption key that you want to use
        /// to encrypt data in the cluster.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key_id(input);
            self
        }
        /// <p>The option to enable relocation for an Amazon Redshift cluster between Availability Zones after the cluster modification is complete.</p>
        pub fn availability_zone_relocation(mut self, inp: bool) -> Self {
            self.inner = self.inner.availability_zone_relocation(inp);
            self
        }
        /// <p>The option to enable relocation for an Amazon Redshift cluster between Availability Zones after the cluster modification is complete.</p>
        pub fn set_availability_zone_relocation(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_availability_zone_relocation(input);
            self
        }
        /// <p>The option to initiate relocation for an Amazon Redshift cluster to the target Availability Zone.</p>
        pub fn availability_zone(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.availability_zone(inp);
            self
        }
        /// <p>The option to initiate relocation for an Amazon Redshift cluster to the target Availability Zone.</p>
        pub fn set_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_availability_zone(input);
            self
        }
        /// <p>The option to change the port of an Amazon Redshift cluster.</p>
        pub fn port(mut self, inp: i32) -> Self {
            self.inner = self.inner.port(inp);
            self
        }
        /// <p>The option to change the port of an Amazon Redshift cluster.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_port(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyClusterDbRevision`.
    ///
    /// <p>Modifies the database revision of a cluster. The database revision is a unique
    /// revision of the database running in a cluster.</p>
    #[derive(std::fmt::Debug)]
    pub struct ModifyClusterDbRevision<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::modify_cluster_db_revision_input::Builder,
    }
    impl<C, M, R> ModifyClusterDbRevision<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ModifyClusterDbRevision`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyClusterDbRevisionOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifyClusterDbRevisionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ModifyClusterDbRevisionInputOperationOutputAlias,
                crate::output::ModifyClusterDbRevisionOutput,
                crate::error::ModifyClusterDbRevisionError,
                crate::input::ModifyClusterDbRevisionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of a cluster whose database revision you want to modify. </p>
        /// <p>Example: <code>examplecluster</code>
        /// </p>
        pub fn cluster_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_identifier(inp);
            self
        }
        /// <p>The unique identifier of a cluster whose database revision you want to modify. </p>
        /// <p>Example: <code>examplecluster</code>
        /// </p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_identifier(input);
            self
        }
        /// <p>The identifier of the database revision. You can retrieve this value from the
        /// response to the <a>DescribeClusterDbRevisions</a> request.</p>
        pub fn revision_target(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.revision_target(inp);
            self
        }
        /// <p>The identifier of the database revision. You can retrieve this value from the
        /// response to the <a>DescribeClusterDbRevisions</a> request.</p>
        pub fn set_revision_target(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_revision_target(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyClusterIamRoles`.
    ///
    /// <p>Modifies the list of Identity and Access Management (IAM) roles that can be
    /// used by the cluster to access other Amazon Web Services services.</p>
    /// <p>A cluster can have up to 10 IAM roles associated at any time.</p>
    #[derive(std::fmt::Debug)]
    pub struct ModifyClusterIamRoles<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::modify_cluster_iam_roles_input::Builder,
    }
    impl<C, M, R> ModifyClusterIamRoles<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ModifyClusterIamRoles`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyClusterIamRolesOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifyClusterIamRolesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ModifyClusterIamRolesInputOperationOutputAlias,
                crate::output::ModifyClusterIamRolesOutput,
                crate::error::ModifyClusterIamRolesError,
                crate::input::ModifyClusterIamRolesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the cluster for which you want to associate or
        /// disassociate IAM roles.</p>
        pub fn cluster_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_identifier(inp);
            self
        }
        /// <p>The unique identifier of the cluster for which you want to associate or
        /// disassociate IAM roles.</p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_identifier(input);
            self
        }
        /// Appends an item to `AddIamRoles`.
        ///
        /// To override the contents of this collection use [`set_add_iam_roles`](Self::set_add_iam_roles).
        ///
        /// <p>Zero or more IAM roles to associate with the cluster. The roles must be in their
        /// Amazon Resource Name (ARN) format. You can associate up to 10 IAM roles with a single
        /// cluster in a single request.</p>
        pub fn add_iam_roles(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.add_iam_roles(inp);
            self
        }
        /// <p>Zero or more IAM roles to associate with the cluster. The roles must be in their
        /// Amazon Resource Name (ARN) format. You can associate up to 10 IAM roles with a single
        /// cluster in a single request.</p>
        pub fn set_add_iam_roles(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_add_iam_roles(input);
            self
        }
        /// Appends an item to `RemoveIamRoles`.
        ///
        /// To override the contents of this collection use [`set_remove_iam_roles`](Self::set_remove_iam_roles).
        ///
        /// <p>Zero or more IAM roles in ARN format to disassociate from the cluster. You can
        /// disassociate up to 10 IAM roles from a single cluster in a single request.</p>
        pub fn remove_iam_roles(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.remove_iam_roles(inp);
            self
        }
        /// <p>Zero or more IAM roles in ARN format to disassociate from the cluster. You can
        /// disassociate up to 10 IAM roles from a single cluster in a single request.</p>
        pub fn set_remove_iam_roles(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_remove_iam_roles(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyClusterMaintenance`.
    ///
    /// <p>Modifies the maintenance settings of a cluster.</p>
    #[derive(std::fmt::Debug)]
    pub struct ModifyClusterMaintenance<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::modify_cluster_maintenance_input::Builder,
    }
    impl<C, M, R> ModifyClusterMaintenance<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ModifyClusterMaintenance`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyClusterMaintenanceOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifyClusterMaintenanceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ModifyClusterMaintenanceInputOperationOutputAlias,
                crate::output::ModifyClusterMaintenanceOutput,
                crate::error::ModifyClusterMaintenanceError,
                crate::input::ModifyClusterMaintenanceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique identifier for the cluster.</p>
        pub fn cluster_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_identifier(inp);
            self
        }
        /// <p>A unique identifier for the cluster.</p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_identifier(input);
            self
        }
        /// <p>A boolean indicating whether to enable the deferred maintenance window. </p>
        pub fn defer_maintenance(mut self, inp: bool) -> Self {
            self.inner = self.inner.defer_maintenance(inp);
            self
        }
        /// <p>A boolean indicating whether to enable the deferred maintenance window. </p>
        pub fn set_defer_maintenance(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_defer_maintenance(input);
            self
        }
        /// <p>A unique identifier for the deferred maintenance window.</p>
        pub fn defer_maintenance_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.defer_maintenance_identifier(inp);
            self
        }
        /// <p>A unique identifier for the deferred maintenance window.</p>
        pub fn set_defer_maintenance_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_defer_maintenance_identifier(input);
            self
        }
        /// <p>A timestamp indicating the start time for the deferred maintenance window.</p>
        pub fn defer_maintenance_start_time(mut self, inp: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.defer_maintenance_start_time(inp);
            self
        }
        /// <p>A timestamp indicating the start time for the deferred maintenance window.</p>
        pub fn set_defer_maintenance_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_defer_maintenance_start_time(input);
            self
        }
        /// <p>A timestamp indicating end time for the deferred maintenance window. If you specify an
        /// end time, you can't specify a duration.</p>
        pub fn defer_maintenance_end_time(mut self, inp: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.defer_maintenance_end_time(inp);
            self
        }
        /// <p>A timestamp indicating end time for the deferred maintenance window. If you specify an
        /// end time, you can't specify a duration.</p>
        pub fn set_defer_maintenance_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_defer_maintenance_end_time(input);
            self
        }
        /// <p>An integer indicating the duration of the maintenance window in days. If you specify a
        /// duration, you can't specify an end time. The duration must be 45 days or less.</p>
        pub fn defer_maintenance_duration(mut self, inp: i32) -> Self {
            self.inner = self.inner.defer_maintenance_duration(inp);
            self
        }
        /// <p>An integer indicating the duration of the maintenance window in days. If you specify a
        /// duration, you can't specify an end time. The duration must be 45 days or less.</p>
        pub fn set_defer_maintenance_duration(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_defer_maintenance_duration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyClusterParameterGroup`.
    ///
    /// <p>Modifies the parameters of a parameter group. For the parameters parameter, it can't contain ASCII characters.</p>
    /// <p>
    /// For more information about parameters and parameter groups, go to
    /// <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Amazon Redshift Parameter Groups</a>
    /// in the <i>Amazon Redshift Cluster Management Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct ModifyClusterParameterGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::modify_cluster_parameter_group_input::Builder,
    }
    impl<C, M, R> ModifyClusterParameterGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ModifyClusterParameterGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyClusterParameterGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifyClusterParameterGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ModifyClusterParameterGroupInputOperationOutputAlias,
                crate::output::ModifyClusterParameterGroupOutput,
                crate::error::ModifyClusterParameterGroupError,
                crate::input::ModifyClusterParameterGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the parameter group to be modified.</p>
        pub fn parameter_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.parameter_group_name(inp);
            self
        }
        /// <p>The name of the parameter group to be modified.</p>
        pub fn set_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_parameter_group_name(input);
            self
        }
        /// Appends an item to `Parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>An array of parameters to be modified. A maximum of 20 parameters can be modified
        /// in a single request.</p>
        /// <p>For each parameter to be modified, you must supply at least the parameter name and
        /// parameter value; other name-value pairs of the parameter are optional.</p>
        /// <p>For the workload management (WLM) configuration, you must supply all the name-value
        /// pairs in the wlm_json_configuration parameter.</p>
        pub fn parameters(mut self, inp: impl Into<crate::model::Parameter>) -> Self {
            self.inner = self.inner.parameters(inp);
            self
        }
        /// <p>An array of parameters to be modified. A maximum of 20 parameters can be modified
        /// in a single request.</p>
        /// <p>For each parameter to be modified, you must supply at least the parameter name and
        /// parameter value; other name-value pairs of the parameter are optional.</p>
        /// <p>For the workload management (WLM) configuration, you must supply all the name-value
        /// pairs in the wlm_json_configuration parameter.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
        ) -> Self {
            self.inner = self.inner.set_parameters(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyClusterSnapshot`.
    ///
    /// <p>Modifies the settings for a snapshot.</p>
    /// <p>This exanmple modifies the manual retention period setting for a cluster snapshot.</p>
    #[derive(std::fmt::Debug)]
    pub struct ModifyClusterSnapshot<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::modify_cluster_snapshot_input::Builder,
    }
    impl<C, M, R> ModifyClusterSnapshot<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ModifyClusterSnapshot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyClusterSnapshotOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifyClusterSnapshotError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ModifyClusterSnapshotInputOperationOutputAlias,
                crate::output::ModifyClusterSnapshotOutput,
                crate::error::ModifyClusterSnapshotError,
                crate::input::ModifyClusterSnapshotInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the snapshot whose setting you want to modify.</p>
        pub fn snapshot_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.snapshot_identifier(inp);
            self
        }
        /// <p>The identifier of the snapshot whose setting you want to modify.</p>
        pub fn set_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_snapshot_identifier(input);
            self
        }
        /// <p>The number of days that a manual snapshot is retained. If the value is -1, the manual
        /// snapshot is retained indefinitely.</p>
        /// <p>If the manual snapshot falls outside of the new retention period, you can specify the
        /// force option to immediately delete the snapshot.</p>
        /// <p>The value must be either -1 or an integer between 1 and 3,653.</p>
        pub fn manual_snapshot_retention_period(mut self, inp: i32) -> Self {
            self.inner = self.inner.manual_snapshot_retention_period(inp);
            self
        }
        /// <p>The number of days that a manual snapshot is retained. If the value is -1, the manual
        /// snapshot is retained indefinitely.</p>
        /// <p>If the manual snapshot falls outside of the new retention period, you can specify the
        /// force option to immediately delete the snapshot.</p>
        /// <p>The value must be either -1 or an integer between 1 and 3,653.</p>
        pub fn set_manual_snapshot_retention_period(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.inner = self.inner.set_manual_snapshot_retention_period(input);
            self
        }
        /// <p>A Boolean option to override an exception if the retention period has already
        /// passed.</p>
        pub fn force(mut self, inp: bool) -> Self {
            self.inner = self.inner.force(inp);
            self
        }
        /// <p>A Boolean option to override an exception if the retention period has already
        /// passed.</p>
        pub fn set_force(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_force(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyClusterSnapshotSchedule`.
    ///
    /// <p>Modifies a snapshot schedule for a cluster.</p>
    #[derive(std::fmt::Debug)]
    pub struct ModifyClusterSnapshotSchedule<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::modify_cluster_snapshot_schedule_input::Builder,
    }
    impl<C, M, R> ModifyClusterSnapshotSchedule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ModifyClusterSnapshotSchedule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyClusterSnapshotScheduleOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifyClusterSnapshotScheduleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ModifyClusterSnapshotScheduleInputOperationOutputAlias,
                crate::output::ModifyClusterSnapshotScheduleOutput,
                crate::error::ModifyClusterSnapshotScheduleError,
                crate::input::ModifyClusterSnapshotScheduleInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique identifier for the cluster whose snapshot schedule you want to modify.
        /// </p>
        pub fn cluster_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_identifier(inp);
            self
        }
        /// <p>A unique identifier for the cluster whose snapshot schedule you want to modify.
        /// </p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_identifier(input);
            self
        }
        /// <p>A unique alphanumeric identifier for the schedule that you want to associate with the
        /// cluster.</p>
        pub fn schedule_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schedule_identifier(inp);
            self
        }
        /// <p>A unique alphanumeric identifier for the schedule that you want to associate with the
        /// cluster.</p>
        pub fn set_schedule_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_schedule_identifier(input);
            self
        }
        /// <p>A boolean to indicate whether to remove the assoiciation between the cluster and the
        /// schedule.</p>
        pub fn disassociate_schedule(mut self, inp: bool) -> Self {
            self.inner = self.inner.disassociate_schedule(inp);
            self
        }
        /// <p>A boolean to indicate whether to remove the assoiciation between the cluster and the
        /// schedule.</p>
        pub fn set_disassociate_schedule(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_disassociate_schedule(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyClusterSubnetGroup`.
    ///
    /// <p>Modifies a cluster subnet group to include the specified list of VPC subnets. The
    /// operation replaces the existing list of subnets with the new list of subnets.</p>
    #[derive(std::fmt::Debug)]
    pub struct ModifyClusterSubnetGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::modify_cluster_subnet_group_input::Builder,
    }
    impl<C, M, R> ModifyClusterSubnetGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ModifyClusterSubnetGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyClusterSubnetGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifyClusterSubnetGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ModifyClusterSubnetGroupInputOperationOutputAlias,
                crate::output::ModifyClusterSubnetGroupOutput,
                crate::error::ModifyClusterSubnetGroupError,
                crate::input::ModifyClusterSubnetGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the subnet group to be modified.</p>
        pub fn cluster_subnet_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_subnet_group_name(inp);
            self
        }
        /// <p>The name of the subnet group to be modified.</p>
        pub fn set_cluster_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_subnet_group_name(input);
            self
        }
        /// <p>A text description of the subnet group to be modified.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>A text description of the subnet group to be modified.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `SubnetIds`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// <p>An array of VPC subnet IDs. A maximum of 20 subnets can be modified in a single
        /// request.</p>
        pub fn subnet_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subnet_ids(inp);
            self
        }
        /// <p>An array of VPC subnet IDs. A maximum of 20 subnets can be modified in a single
        /// request.</p>
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_subnet_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyEndpointAccess`.
    ///
    /// <p>Modifies a Redshift-managed VPC endpoint.</p>
    #[derive(std::fmt::Debug)]
    pub struct ModifyEndpointAccess<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::modify_endpoint_access_input::Builder,
    }
    impl<C, M, R> ModifyEndpointAccess<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ModifyEndpointAccess`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyEndpointAccessOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifyEndpointAccessError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ModifyEndpointAccessInputOperationOutputAlias,
                crate::output::ModifyEndpointAccessOutput,
                crate::error::ModifyEndpointAccessError,
                crate::input::ModifyEndpointAccessInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The endpoint to be modified.</p>
        pub fn endpoint_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.endpoint_name(inp);
            self
        }
        /// <p>The endpoint to be modified.</p>
        pub fn set_endpoint_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_endpoint_name(input);
            self
        }
        /// Appends an item to `VpcSecurityGroupIds`.
        ///
        /// To override the contents of this collection use [`set_vpc_security_group_ids`](Self::set_vpc_security_group_ids).
        ///
        /// <p>The complete list of VPC security groups associated with the endpoint after the endpoint is modified.</p>
        pub fn vpc_security_group_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc_security_group_ids(inp);
            self
        }
        /// <p>The complete list of VPC security groups associated with the endpoint after the endpoint is modified.</p>
        pub fn set_vpc_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_vpc_security_group_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyEventSubscription`.
    ///
    /// <p>Modifies an existing Amazon Redshift event notification subscription.</p>
    #[derive(std::fmt::Debug)]
    pub struct ModifyEventSubscription<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::modify_event_subscription_input::Builder,
    }
    impl<C, M, R> ModifyEventSubscription<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ModifyEventSubscription`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyEventSubscriptionOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifyEventSubscriptionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ModifyEventSubscriptionInputOperationOutputAlias,
                crate::output::ModifyEventSubscriptionOutput,
                crate::error::ModifyEventSubscriptionError,
                crate::input::ModifyEventSubscriptionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the modified Amazon Redshift event notification subscription.</p>
        pub fn subscription_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subscription_name(inp);
            self
        }
        /// <p>The name of the modified Amazon Redshift event notification subscription.</p>
        pub fn set_subscription_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_subscription_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the SNS topic to be used by the event
        /// notification subscription.</p>
        pub fn sns_topic_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sns_topic_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the SNS topic to be used by the event
        /// notification subscription.</p>
        pub fn set_sns_topic_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_sns_topic_arn(input);
            self
        }
        /// <p>The type of source that will be generating the events. For example, if you want to
        /// be notified of events generated by a cluster, you would set this parameter to cluster.
        /// If this value is not specified, events are returned for all Amazon Redshift objects in your
        /// Amazon Web Services account. You must specify a source type in order to specify source IDs.</p>
        /// <p>Valid values: cluster, cluster-parameter-group, cluster-security-group, cluster-snapshot, and scheduled-action.</p>
        pub fn source_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_type(inp);
            self
        }
        /// <p>The type of source that will be generating the events. For example, if you want to
        /// be notified of events generated by a cluster, you would set this parameter to cluster.
        /// If this value is not specified, events are returned for all Amazon Redshift objects in your
        /// Amazon Web Services account. You must specify a source type in order to specify source IDs.</p>
        /// <p>Valid values: cluster, cluster-parameter-group, cluster-security-group, cluster-snapshot, and scheduled-action.</p>
        pub fn set_source_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_source_type(input);
            self
        }
        /// Appends an item to `SourceIds`.
        ///
        /// To override the contents of this collection use [`set_source_ids`](Self::set_source_ids).
        ///
        /// <p>A list of one or more identifiers of Amazon Redshift source objects. All of the objects
        /// must be of the same type as was specified in the source type parameter. The event
        /// subscription will return only events generated by the specified objects. If not
        /// specified, then events are returned for all objects within the source type
        /// specified.</p>
        /// <p>Example: my-cluster-1, my-cluster-2</p>
        /// <p>Example: my-snapshot-20131010</p>
        pub fn source_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_ids(inp);
            self
        }
        /// <p>A list of one or more identifiers of Amazon Redshift source objects. All of the objects
        /// must be of the same type as was specified in the source type parameter. The event
        /// subscription will return only events generated by the specified objects. If not
        /// specified, then events are returned for all objects within the source type
        /// specified.</p>
        /// <p>Example: my-cluster-1, my-cluster-2</p>
        /// <p>Example: my-snapshot-20131010</p>
        pub fn set_source_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_source_ids(input);
            self
        }
        /// Appends an item to `EventCategories`.
        ///
        /// To override the contents of this collection use [`set_event_categories`](Self::set_event_categories).
        ///
        /// <p>Specifies the Amazon Redshift event categories to be published by the event notification
        /// subscription.</p>
        /// <p>Values: configuration, management, monitoring, security, pending</p>
        pub fn event_categories(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_categories(inp);
            self
        }
        /// <p>Specifies the Amazon Redshift event categories to be published by the event notification
        /// subscription.</p>
        /// <p>Values: configuration, management, monitoring, security, pending</p>
        pub fn set_event_categories(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_event_categories(input);
            self
        }
        /// <p>Specifies the Amazon Redshift event severity to be published by the event notification
        /// subscription.</p>
        /// <p>Values: ERROR, INFO</p>
        pub fn severity(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.severity(inp);
            self
        }
        /// <p>Specifies the Amazon Redshift event severity to be published by the event notification
        /// subscription.</p>
        /// <p>Values: ERROR, INFO</p>
        pub fn set_severity(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_severity(input);
            self
        }
        /// <p>A Boolean value indicating if the subscription is enabled. <code>true</code>
        /// indicates the subscription is enabled </p>
        pub fn enabled(mut self, inp: bool) -> Self {
            self.inner = self.inner.enabled(inp);
            self
        }
        /// <p>A Boolean value indicating if the subscription is enabled. <code>true</code>
        /// indicates the subscription is enabled </p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enabled(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyScheduledAction`.
    ///
    /// <p>Modifies a scheduled action.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct ModifyScheduledAction<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::modify_scheduled_action_input::Builder,
    }
    impl<C, M, R> ModifyScheduledAction<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ModifyScheduledAction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyScheduledActionOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifyScheduledActionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ModifyScheduledActionInputOperationOutputAlias,
                crate::output::ModifyScheduledActionOutput,
                crate::error::ModifyScheduledActionError,
                crate::input::ModifyScheduledActionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the scheduled action to modify. </p>
        pub fn scheduled_action_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.scheduled_action_name(inp);
            self
        }
        /// <p>The name of the scheduled action to modify. </p>
        pub fn set_scheduled_action_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_scheduled_action_name(input);
            self
        }
        /// <p>A modified JSON format of the scheduled action.
        /// For more information about this parameter, see <a>ScheduledAction</a>. </p>
        pub fn target_action(mut self, inp: crate::model::ScheduledActionType) -> Self {
            self.inner = self.inner.target_action(inp);
            self
        }
        /// <p>A modified JSON format of the scheduled action.
        /// For more information about this parameter, see <a>ScheduledAction</a>. </p>
        pub fn set_target_action(
            mut self,
            input: std::option::Option<crate::model::ScheduledActionType>,
        ) -> Self {
            self.inner = self.inner.set_target_action(input);
            self
        }
        /// <p>A modified schedule in either <code>at( )</code> or <code>cron( )</code> format.
        /// For more information about this parameter, see <a>ScheduledAction</a>.</p>
        pub fn schedule(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schedule(inp);
            self
        }
        /// <p>A modified schedule in either <code>at( )</code> or <code>cron( )</code> format.
        /// For more information about this parameter, see <a>ScheduledAction</a>.</p>
        pub fn set_schedule(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_schedule(input);
            self
        }
        /// <p>A different IAM role to assume to run the target action.
        /// For more information about this parameter, see <a>ScheduledAction</a>.</p>
        pub fn iam_role(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.iam_role(inp);
            self
        }
        /// <p>A different IAM role to assume to run the target action.
        /// For more information about this parameter, see <a>ScheduledAction</a>.</p>
        pub fn set_iam_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_iam_role(input);
            self
        }
        /// <p>A modified description of the scheduled action. </p>
        pub fn scheduled_action_description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.scheduled_action_description(inp);
            self
        }
        /// <p>A modified description of the scheduled action. </p>
        pub fn set_scheduled_action_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_scheduled_action_description(input);
            self
        }
        /// <p>A modified start time of the scheduled action.
        /// For more information about this parameter, see <a>ScheduledAction</a>. </p>
        pub fn start_time(mut self, inp: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.start_time(inp);
            self
        }
        /// <p>A modified start time of the scheduled action.
        /// For more information about this parameter, see <a>ScheduledAction</a>. </p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_start_time(input);
            self
        }
        /// <p>A modified end time of the scheduled action.
        /// For more information about this parameter, see <a>ScheduledAction</a>. </p>
        pub fn end_time(mut self, inp: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.end_time(inp);
            self
        }
        /// <p>A modified end time of the scheduled action.
        /// For more information about this parameter, see <a>ScheduledAction</a>. </p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_end_time(input);
            self
        }
        /// <p>A modified enable flag of the scheduled action. If true, the scheduled action is active. If false, the scheduled action is disabled. </p>
        pub fn enable(mut self, inp: bool) -> Self {
            self.inner = self.inner.enable(inp);
            self
        }
        /// <p>A modified enable flag of the scheduled action. If true, the scheduled action is active. If false, the scheduled action is disabled. </p>
        pub fn set_enable(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enable(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifySnapshotCopyRetentionPeriod`.
    ///
    /// <p>Modifies the number of days to retain snapshots in the destination Amazon Web Services Region after
    /// they are copied from the source Amazon Web Services Region. By default, this operation only changes the
    /// retention period of copied automated snapshots. The retention periods for both new and
    /// existing copied automated snapshots are updated with the new retention period. You can
    /// set the manual option to change only the retention periods of copied manual snapshots.
    /// If you set this option, only newly copied manual snapshots have the new retention
    /// period. </p>
    #[derive(std::fmt::Debug)]
    pub struct ModifySnapshotCopyRetentionPeriod<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::modify_snapshot_copy_retention_period_input::Builder,
    }
    impl<C, M, R> ModifySnapshotCopyRetentionPeriod<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ModifySnapshotCopyRetentionPeriod`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifySnapshotCopyRetentionPeriodOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifySnapshotCopyRetentionPeriodError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ModifySnapshotCopyRetentionPeriodInputOperationOutputAlias,
                crate::output::ModifySnapshotCopyRetentionPeriodOutput,
                crate::error::ModifySnapshotCopyRetentionPeriodError,
                crate::input::ModifySnapshotCopyRetentionPeriodInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the cluster for which you want to change the retention
        /// period for either automated or manual snapshots that are copied to a destination Amazon Web Services Region.</p>
        /// <p>Constraints: Must be the valid name of an existing cluster that has cross-region
        /// snapshot copy enabled.</p>
        pub fn cluster_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_identifier(inp);
            self
        }
        /// <p>The unique identifier of the cluster for which you want to change the retention
        /// period for either automated or manual snapshots that are copied to a destination Amazon Web Services Region.</p>
        /// <p>Constraints: Must be the valid name of an existing cluster that has cross-region
        /// snapshot copy enabled.</p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_identifier(input);
            self
        }
        /// <p>The number of days to retain automated snapshots in the destination Amazon Web Services Region
        /// after they are copied from the source Amazon Web Services Region.</p>
        /// <p>By default, this only changes the retention period of copied automated snapshots. </p>
        /// <p>If you decrease the retention period for automated snapshots that are copied to a
        /// destination Amazon Web Services Region, Amazon Redshift deletes any existing automated snapshots that were
        /// copied to the destination Amazon Web Services Region and that fall outside of the new retention
        /// period.</p>
        /// <p>Constraints: Must be at least 1 and no more than 35 for automated snapshots. </p>
        /// <p>If you specify the <code>manual</code> option, only newly copied manual snapshots will
        /// have the new retention period. </p>
        /// <p>If you specify the value of -1 newly copied manual snapshots are retained
        /// indefinitely.</p>
        /// <p>Constraints: The number of days must be either -1 or an integer between 1 and 3,653
        /// for manual snapshots.</p>
        pub fn retention_period(mut self, inp: i32) -> Self {
            self.inner = self.inner.retention_period(inp);
            self
        }
        /// <p>The number of days to retain automated snapshots in the destination Amazon Web Services Region
        /// after they are copied from the source Amazon Web Services Region.</p>
        /// <p>By default, this only changes the retention period of copied automated snapshots. </p>
        /// <p>If you decrease the retention period for automated snapshots that are copied to a
        /// destination Amazon Web Services Region, Amazon Redshift deletes any existing automated snapshots that were
        /// copied to the destination Amazon Web Services Region and that fall outside of the new retention
        /// period.</p>
        /// <p>Constraints: Must be at least 1 and no more than 35 for automated snapshots. </p>
        /// <p>If you specify the <code>manual</code> option, only newly copied manual snapshots will
        /// have the new retention period. </p>
        /// <p>If you specify the value of -1 newly copied manual snapshots are retained
        /// indefinitely.</p>
        /// <p>Constraints: The number of days must be either -1 or an integer between 1 and 3,653
        /// for manual snapshots.</p>
        pub fn set_retention_period(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_retention_period(input);
            self
        }
        /// <p>Indicates whether to apply the snapshot retention period to newly copied manual
        /// snapshots instead of automated snapshots.</p>
        pub fn manual(mut self, inp: bool) -> Self {
            self.inner = self.inner.manual(inp);
            self
        }
        /// <p>Indicates whether to apply the snapshot retention period to newly copied manual
        /// snapshots instead of automated snapshots.</p>
        pub fn set_manual(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_manual(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifySnapshotSchedule`.
    ///
    /// <p>Modifies a snapshot schedule. Any schedule associated with a cluster is modified
    /// asynchronously.</p>
    #[derive(std::fmt::Debug)]
    pub struct ModifySnapshotSchedule<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::modify_snapshot_schedule_input::Builder,
    }
    impl<C, M, R> ModifySnapshotSchedule<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ModifySnapshotSchedule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifySnapshotScheduleOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifySnapshotScheduleError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ModifySnapshotScheduleInputOperationOutputAlias,
                crate::output::ModifySnapshotScheduleOutput,
                crate::error::ModifySnapshotScheduleError,
                crate::input::ModifySnapshotScheduleInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique alphanumeric identifier of the schedule to modify.</p>
        pub fn schedule_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schedule_identifier(inp);
            self
        }
        /// <p>A unique alphanumeric identifier of the schedule to modify.</p>
        pub fn set_schedule_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_schedule_identifier(input);
            self
        }
        /// Appends an item to `ScheduleDefinitions`.
        ///
        /// To override the contents of this collection use [`set_schedule_definitions`](Self::set_schedule_definitions).
        ///
        /// <p>An updated list of schedule definitions. A schedule definition is made up of schedule
        /// expressions, for example, "cron(30 12 *)" or "rate(12 hours)".</p>
        pub fn schedule_definitions(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schedule_definitions(inp);
            self
        }
        /// <p>An updated list of schedule definitions. A schedule definition is made up of schedule
        /// expressions, for example, "cron(30 12 *)" or "rate(12 hours)".</p>
        pub fn set_schedule_definitions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_schedule_definitions(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyUsageLimit`.
    ///
    /// <p>Modifies a usage limit in a cluster.
    /// You can't modify the feature type or period of a usage limit.</p>
    #[derive(std::fmt::Debug)]
    pub struct ModifyUsageLimit<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::modify_usage_limit_input::Builder,
    }
    impl<C, M, R> ModifyUsageLimit<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ModifyUsageLimit`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyUsageLimitOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifyUsageLimitError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ModifyUsageLimitInputOperationOutputAlias,
                crate::output::ModifyUsageLimitOutput,
                crate::error::ModifyUsageLimitError,
                crate::input::ModifyUsageLimitInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the usage limit to modify.</p>
        pub fn usage_limit_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.usage_limit_id(inp);
            self
        }
        /// <p>The identifier of the usage limit to modify.</p>
        pub fn set_usage_limit_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_usage_limit_id(input);
            self
        }
        /// <p>The new limit amount.
        /// For more information about this parameter, see <a>UsageLimit</a>. </p>
        pub fn amount(mut self, inp: i64) -> Self {
            self.inner = self.inner.amount(inp);
            self
        }
        /// <p>The new limit amount.
        /// For more information about this parameter, see <a>UsageLimit</a>. </p>
        pub fn set_amount(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_amount(input);
            self
        }
        /// <p>The new action that Amazon Redshift takes when the limit is reached.
        /// For more information about this parameter, see <a>UsageLimit</a>. </p>
        pub fn breach_action(mut self, inp: crate::model::UsageLimitBreachAction) -> Self {
            self.inner = self.inner.breach_action(inp);
            self
        }
        /// <p>The new action that Amazon Redshift takes when the limit is reached.
        /// For more information about this parameter, see <a>UsageLimit</a>. </p>
        pub fn set_breach_action(
            mut self,
            input: std::option::Option<crate::model::UsageLimitBreachAction>,
        ) -> Self {
            self.inner = self.inner.set_breach_action(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PauseCluster`.
    ///
    /// <p>Pauses a cluster.</p>
    #[derive(std::fmt::Debug)]
    pub struct PauseCluster<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::pause_cluster_input::Builder,
    }
    impl<C, M, R> PauseCluster<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PauseCluster`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PauseClusterOutput,
            aws_smithy_http::result::SdkError<crate::error::PauseClusterError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PauseClusterInputOperationOutputAlias,
                crate::output::PauseClusterOutput,
                crate::error::PauseClusterError,
                crate::input::PauseClusterInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the cluster to be paused.</p>
        pub fn cluster_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_identifier(inp);
            self
        }
        /// <p>The identifier of the cluster to be paused.</p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PurchaseReservedNodeOffering`.
    ///
    /// <p>Allows you to purchase reserved nodes. Amazon Redshift offers a predefined set of
    /// reserved node offerings. You can purchase one or more of the offerings. You can call the
    /// <a>DescribeReservedNodeOfferings</a> API to obtain the available reserved
    /// node offerings. You can call this API by providing a specific reserved node offering and
    /// the number of nodes you want to reserve. </p>
    /// <p>
    /// For more information about reserved node offerings, go to
    /// <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/purchase-reserved-node-instance.html">Purchasing Reserved Nodes</a>
    /// in the <i>Amazon Redshift Cluster Management Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct PurchaseReservedNodeOffering<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::purchase_reserved_node_offering_input::Builder,
    }
    impl<C, M, R> PurchaseReservedNodeOffering<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PurchaseReservedNodeOffering`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PurchaseReservedNodeOfferingOutput,
            aws_smithy_http::result::SdkError<crate::error::PurchaseReservedNodeOfferingError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PurchaseReservedNodeOfferingInputOperationOutputAlias,
                crate::output::PurchaseReservedNodeOfferingOutput,
                crate::error::PurchaseReservedNodeOfferingError,
                crate::input::PurchaseReservedNodeOfferingInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the reserved node offering you want to purchase.</p>
        pub fn reserved_node_offering_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.reserved_node_offering_id(inp);
            self
        }
        /// <p>The unique identifier of the reserved node offering you want to purchase.</p>
        pub fn set_reserved_node_offering_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_reserved_node_offering_id(input);
            self
        }
        /// <p>The number of reserved nodes that you want to purchase.</p>
        /// <p>Default: <code>1</code>
        /// </p>
        pub fn node_count(mut self, inp: i32) -> Self {
            self.inner = self.inner.node_count(inp);
            self
        }
        /// <p>The number of reserved nodes that you want to purchase.</p>
        /// <p>Default: <code>1</code>
        /// </p>
        pub fn set_node_count(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_node_count(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RebootCluster`.
    ///
    /// <p>Reboots a cluster. This action is taken as soon as possible. It results in a
    /// momentary outage to the cluster, during which the cluster status is set to
    /// <code>rebooting</code>. A cluster event is created when the reboot is completed. Any
    /// pending cluster modifications (see <a>ModifyCluster</a>) are applied at this
    /// reboot.
    /// For more information about managing clusters, go to
    /// <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html">Amazon Redshift Clusters</a>
    /// in the <i>Amazon Redshift Cluster Management Guide</i>. </p>
    #[derive(std::fmt::Debug)]
    pub struct RebootCluster<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::reboot_cluster_input::Builder,
    }
    impl<C, M, R> RebootCluster<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RebootCluster`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RebootClusterOutput,
            aws_smithy_http::result::SdkError<crate::error::RebootClusterError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RebootClusterInputOperationOutputAlias,
                crate::output::RebootClusterOutput,
                crate::error::RebootClusterError,
                crate::input::RebootClusterInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The cluster identifier.</p>
        pub fn cluster_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_identifier(inp);
            self
        }
        /// <p>The cluster identifier.</p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RejectDataShare`.
    ///
    /// <p>From the consumer account, rejects the specified datashare.</p>
    #[derive(std::fmt::Debug)]
    pub struct RejectDataShare<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::reject_data_share_input::Builder,
    }
    impl<C, M, R> RejectDataShare<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RejectDataShare`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RejectDataShareOutput,
            aws_smithy_http::result::SdkError<crate::error::RejectDataShareError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RejectDataShareInputOperationOutputAlias,
                crate::output::RejectDataShareOutput,
                crate::error::RejectDataShareError,
                crate::input::RejectDataShareInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the datashare to reject.</p>
        pub fn data_share_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_share_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the datashare to reject.</p>
        pub fn set_data_share_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_data_share_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ResetClusterParameterGroup`.
    ///
    /// <p>Sets one or more parameters of the specified parameter group to their default
    /// values and sets the source values of the parameters to "engine-default". To reset the
    /// entire parameter group specify the <i>ResetAllParameters</i> parameter.
    /// For parameter changes to take effect you must reboot any associated clusters. </p>
    #[derive(std::fmt::Debug)]
    pub struct ResetClusterParameterGroup<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::reset_cluster_parameter_group_input::Builder,
    }
    impl<C, M, R> ResetClusterParameterGroup<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ResetClusterParameterGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ResetClusterParameterGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::ResetClusterParameterGroupError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ResetClusterParameterGroupInputOperationOutputAlias,
                crate::output::ResetClusterParameterGroupOutput,
                crate::error::ResetClusterParameterGroupError,
                crate::input::ResetClusterParameterGroupInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the cluster parameter group to be reset.</p>
        pub fn parameter_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.parameter_group_name(inp);
            self
        }
        /// <p>The name of the cluster parameter group to be reset.</p>
        pub fn set_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_parameter_group_name(input);
            self
        }
        /// <p>If <code>true</code>, all parameters in the specified parameter group will be reset
        /// to their default values. </p>
        /// <p>Default: <code>true</code>
        /// </p>
        pub fn reset_all_parameters(mut self, inp: bool) -> Self {
            self.inner = self.inner.reset_all_parameters(inp);
            self
        }
        /// <p>If <code>true</code>, all parameters in the specified parameter group will be reset
        /// to their default values. </p>
        /// <p>Default: <code>true</code>
        /// </p>
        pub fn set_reset_all_parameters(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_reset_all_parameters(input);
            self
        }
        /// Appends an item to `Parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>An array of names of parameters to be reset. If
        /// <i>ResetAllParameters</i> option is not used, then at least one
        /// parameter name must be supplied. </p>
        /// <p>Constraints: A maximum of 20 parameters can be reset in a single request.</p>
        pub fn parameters(mut self, inp: impl Into<crate::model::Parameter>) -> Self {
            self.inner = self.inner.parameters(inp);
            self
        }
        /// <p>An array of names of parameters to be reset. If
        /// <i>ResetAllParameters</i> option is not used, then at least one
        /// parameter name must be supplied. </p>
        /// <p>Constraints: A maximum of 20 parameters can be reset in a single request.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
        ) -> Self {
            self.inner = self.inner.set_parameters(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ResizeCluster`.
    ///
    /// <p>Changes the size of the cluster. You can change the cluster's type, or change the
    /// number or type of nodes. The default behavior is to use the elastic resize method. With
    /// an elastic resize, your cluster is available for read and write operations more quickly
    /// than with the classic resize method. </p>
    /// <p>Elastic resize operations have the following restrictions:</p>
    /// <ul>
    /// <li>
    /// <p>You can only resize clusters of the following types:</p>
    /// <ul>
    /// <li>
    /// <p>dc1.large (if your cluster is in a VPC)</p>
    /// </li>
    /// <li>
    /// <p>dc1.8xlarge (if your cluster is in a VPC)</p>
    /// </li>
    /// <li>
    /// <p>dc2.large</p>
    /// </li>
    /// <li>
    /// <p>dc2.8xlarge</p>
    /// </li>
    /// <li>
    /// <p>ds2.xlarge</p>
    /// </li>
    /// <li>
    /// <p>ds2.8xlarge</p>
    /// </li>
    /// <li>
    /// <p>ra3.xlplus</p>
    /// </li>
    /// <li>
    /// <p>ra3.4xlarge</p>
    /// </li>
    /// <li>
    /// <p>ra3.16xlarge</p>
    /// </li>
    /// </ul>
    /// </li>
    /// <li>
    /// <p>The type of nodes that you add must match the node type for the
    /// cluster.</p>
    /// </li>
    /// </ul>
    #[derive(std::fmt::Debug)]
    pub struct ResizeCluster<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::resize_cluster_input::Builder,
    }
    impl<C, M, R> ResizeCluster<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ResizeCluster`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ResizeClusterOutput,
            aws_smithy_http::result::SdkError<crate::error::ResizeClusterError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ResizeClusterInputOperationOutputAlias,
                crate::output::ResizeClusterOutput,
                crate::error::ResizeClusterError,
                crate::input::ResizeClusterInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the cluster to resize.</p>
        pub fn cluster_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_identifier(inp);
            self
        }
        /// <p>The unique identifier for the cluster to resize.</p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_identifier(input);
            self
        }
        /// <p>The new cluster type for the specified cluster.</p>
        pub fn cluster_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_type(inp);
            self
        }
        /// <p>The new cluster type for the specified cluster.</p>
        pub fn set_cluster_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster_type(input);
            self
        }
        /// <p>The new node type for the nodes you are adding. If not specified, the cluster's current node type is used.</p>
        pub fn node_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.node_type(inp);
            self
        }
        /// <p>The new node type for the nodes you are adding. If not specified, the cluster's current node type is used.</p>
        pub fn set_node_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_node_type(input);
            self
        }
        /// <p>The new number of nodes for the cluster. If not specified, the cluster's current number of nodes is used.</p>
        pub fn number_of_nodes(mut self, inp: i32) -> Self {
            self.inner = self.inner.number_of_nodes(inp);
            self
        }
        /// <p>The new number of nodes for the cluster. If not specified, the cluster's current number of nodes is used.</p>
        pub fn set_number_of_nodes(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_number_of_nodes(input);
            self
        }
        /// <p>A boolean value indicating whether the resize operation is using the classic resize
        /// process. If you don't provide this parameter or set the value to
        /// <code>false</code>, the resize type is elastic. </p>
        pub fn classic(mut self, inp: bool) -> Self {
            self.inner = self.inner.classic(inp);
            self
        }
        /// <p>A boolean value indicating whether the resize operation is using the classic resize
        /// process. If you don't provide this parameter or set the value to
        /// <code>false</code>, the resize type is elastic. </p>
        pub fn set_classic(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_classic(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RestoreFromClusterSnapshot`.
    ///
    /// <p>Creates a new cluster from a snapshot. By default, Amazon Redshift creates the resulting
    /// cluster with the same configuration as the original cluster from which the snapshot was
    /// created, except that the new cluster is created with the default cluster security and
    /// parameter groups. After Amazon Redshift creates the cluster, you can use the <a>ModifyCluster</a> API to associate a different security group and different
    /// parameter group with the restored cluster. If you are using a DS node type, you can also
    /// choose to change to another DS node type of the same size during restore.</p>
    /// <p>If you restore a cluster into a VPC, you must provide a cluster subnet group where
    /// you want the cluster restored.</p>
    /// <p>
    /// For more information about working with snapshots, go to
    /// <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-snapshots.html">Amazon Redshift Snapshots</a>
    /// in the <i>Amazon Redshift Cluster Management Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct RestoreFromClusterSnapshot<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::restore_from_cluster_snapshot_input::Builder,
    }
    impl<C, M, R> RestoreFromClusterSnapshot<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RestoreFromClusterSnapshot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RestoreFromClusterSnapshotOutput,
            aws_smithy_http::result::SdkError<crate::error::RestoreFromClusterSnapshotError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RestoreFromClusterSnapshotInputOperationOutputAlias,
                crate::output::RestoreFromClusterSnapshotOutput,
                crate::error::RestoreFromClusterSnapshotError,
                crate::input::RestoreFromClusterSnapshotInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the cluster that will be created from restoring the
        /// snapshot.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain from 1 to 63 alphanumeric characters or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>Alphabetic characters must be lowercase.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// <li>
        /// <p>Must be unique for all clusters within an Amazon Web Services account.</p>
        /// </li>
        /// </ul>
        pub fn cluster_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_identifier(inp);
            self
        }
        /// <p>The identifier of the cluster that will be created from restoring the
        /// snapshot.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must contain from 1 to 63 alphanumeric characters or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>Alphabetic characters must be lowercase.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// <li>
        /// <p>Must be unique for all clusters within an Amazon Web Services account.</p>
        /// </li>
        /// </ul>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_identifier(input);
            self
        }
        /// <p>The name of the snapshot from which to create the new cluster. This parameter isn't
        /// case sensitive.</p>
        /// <p>Example: <code>my-snapshot-id</code>
        /// </p>
        pub fn snapshot_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.snapshot_identifier(inp);
            self
        }
        /// <p>The name of the snapshot from which to create the new cluster. This parameter isn't
        /// case sensitive.</p>
        /// <p>Example: <code>my-snapshot-id</code>
        /// </p>
        pub fn set_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_snapshot_identifier(input);
            self
        }
        /// <p>The name of the cluster the source snapshot was created from. This parameter is
        /// required if your IAM user has a policy containing a snapshot resource element that
        /// specifies anything other than * for the cluster name.</p>
        pub fn snapshot_cluster_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.snapshot_cluster_identifier(inp);
            self
        }
        /// <p>The name of the cluster the source snapshot was created from. This parameter is
        /// required if your IAM user has a policy containing a snapshot resource element that
        /// specifies anything other than * for the cluster name.</p>
        pub fn set_snapshot_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_snapshot_cluster_identifier(input);
            self
        }
        /// <p>The port number on which the cluster accepts connections.</p>
        /// <p>Default: The same port as the original cluster.</p>
        /// <p>Constraints: Must be between <code>1115</code> and <code>65535</code>.</p>
        pub fn port(mut self, inp: i32) -> Self {
            self.inner = self.inner.port(inp);
            self
        }
        /// <p>The port number on which the cluster accepts connections.</p>
        /// <p>Default: The same port as the original cluster.</p>
        /// <p>Constraints: Must be between <code>1115</code> and <code>65535</code>.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_port(input);
            self
        }
        /// <p>The Amazon EC2 Availability Zone in which to restore the cluster.</p>
        /// <p>Default: A random, system-chosen Availability Zone.</p>
        /// <p>Example: <code>us-east-2a</code>
        /// </p>
        pub fn availability_zone(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.availability_zone(inp);
            self
        }
        /// <p>The Amazon EC2 Availability Zone in which to restore the cluster.</p>
        /// <p>Default: A random, system-chosen Availability Zone.</p>
        /// <p>Example: <code>us-east-2a</code>
        /// </p>
        pub fn set_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_availability_zone(input);
            self
        }
        /// <p>If <code>true</code>, major version upgrades can be applied during the maintenance
        /// window to the Amazon Redshift engine that is running on the cluster. </p>
        /// <p>Default: <code>true</code>
        /// </p>
        pub fn allow_version_upgrade(mut self, inp: bool) -> Self {
            self.inner = self.inner.allow_version_upgrade(inp);
            self
        }
        /// <p>If <code>true</code>, major version upgrades can be applied during the maintenance
        /// window to the Amazon Redshift engine that is running on the cluster. </p>
        /// <p>Default: <code>true</code>
        /// </p>
        pub fn set_allow_version_upgrade(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_allow_version_upgrade(input);
            self
        }
        /// <p>The name of the subnet group where you want to cluster restored.</p>
        /// <p>A snapshot of cluster in VPC can be restored only in VPC. Therefore, you must
        /// provide subnet group name where you want the cluster restored.</p>
        pub fn cluster_subnet_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_subnet_group_name(inp);
            self
        }
        /// <p>The name of the subnet group where you want to cluster restored.</p>
        /// <p>A snapshot of cluster in VPC can be restored only in VPC. Therefore, you must
        /// provide subnet group name where you want the cluster restored.</p>
        pub fn set_cluster_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_subnet_group_name(input);
            self
        }
        /// <p>If <code>true</code>, the cluster can be accessed from a public network. </p>
        pub fn publicly_accessible(mut self, inp: bool) -> Self {
            self.inner = self.inner.publicly_accessible(inp);
            self
        }
        /// <p>If <code>true</code>, the cluster can be accessed from a public network. </p>
        pub fn set_publicly_accessible(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_publicly_accessible(input);
            self
        }
        /// <p>The Amazon Web Services account used to create or copy the snapshot. Required if you are
        /// restoring a snapshot you do not own, optional if you own the snapshot.</p>
        pub fn owner_account(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.owner_account(inp);
            self
        }
        /// <p>The Amazon Web Services account used to create or copy the snapshot. Required if you are
        /// restoring a snapshot you do not own, optional if you own the snapshot.</p>
        pub fn set_owner_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_owner_account(input);
            self
        }
        /// <p>Specifies the name of the HSM client certificate the Amazon Redshift cluster uses to
        /// retrieve the data encryption keys stored in an HSM.</p>
        pub fn hsm_client_certificate_identifier(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.hsm_client_certificate_identifier(inp);
            self
        }
        /// <p>Specifies the name of the HSM client certificate the Amazon Redshift cluster uses to
        /// retrieve the data encryption keys stored in an HSM.</p>
        pub fn set_hsm_client_certificate_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_hsm_client_certificate_identifier(input);
            self
        }
        /// <p>Specifies the name of the HSM configuration that contains the information the
        /// Amazon Redshift cluster can use to retrieve and store keys in an HSM.</p>
        pub fn hsm_configuration_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hsm_configuration_identifier(inp);
            self
        }
        /// <p>Specifies the name of the HSM configuration that contains the information the
        /// Amazon Redshift cluster can use to retrieve and store keys in an HSM.</p>
        pub fn set_hsm_configuration_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_hsm_configuration_identifier(input);
            self
        }
        /// <p>The elastic IP (EIP) address for the cluster.</p>
        pub fn elastic_ip(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.elastic_ip(inp);
            self
        }
        /// <p>The elastic IP (EIP) address for the cluster.</p>
        pub fn set_elastic_ip(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_elastic_ip(input);
            self
        }
        /// <p>The name of the parameter group to be associated with this cluster.</p>
        /// <p>Default: The default Amazon Redshift cluster parameter group. For information about the
        /// default parameter group, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Working with Amazon
        /// Redshift Parameter Groups</a>.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be 1 to 255 alphanumeric characters or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// </ul>
        pub fn cluster_parameter_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_parameter_group_name(inp);
            self
        }
        /// <p>The name of the parameter group to be associated with this cluster.</p>
        /// <p>Default: The default Amazon Redshift cluster parameter group. For information about the
        /// default parameter group, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Working with Amazon
        /// Redshift Parameter Groups</a>.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be 1 to 255 alphanumeric characters or hyphens.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter.</p>
        /// </li>
        /// <li>
        /// <p>Cannot end with a hyphen or contain two consecutive hyphens.</p>
        /// </li>
        /// </ul>
        pub fn set_cluster_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_parameter_group_name(input);
            self
        }
        /// Appends an item to `ClusterSecurityGroups`.
        ///
        /// To override the contents of this collection use [`set_cluster_security_groups`](Self::set_cluster_security_groups).
        ///
        /// <p>A list of security groups to be associated with this cluster.</p>
        /// <p>Default: The default cluster security group for Amazon Redshift.</p>
        /// <p>Cluster security groups only apply to clusters outside of VPCs.</p>
        pub fn cluster_security_groups(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_security_groups(inp);
            self
        }
        /// <p>A list of security groups to be associated with this cluster.</p>
        /// <p>Default: The default cluster security group for Amazon Redshift.</p>
        /// <p>Cluster security groups only apply to clusters outside of VPCs.</p>
        pub fn set_cluster_security_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_cluster_security_groups(input);
            self
        }
        /// Appends an item to `VpcSecurityGroupIds`.
        ///
        /// To override the contents of this collection use [`set_vpc_security_group_ids`](Self::set_vpc_security_group_ids).
        ///
        /// <p>A list of Virtual Private Cloud (VPC) security groups to be associated with the
        /// cluster.</p>
        /// <p>Default: The default VPC security group is associated with the cluster.</p>
        /// <p>VPC security groups only apply to clusters in VPCs.</p>
        pub fn vpc_security_group_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc_security_group_ids(inp);
            self
        }
        /// <p>A list of Virtual Private Cloud (VPC) security groups to be associated with the
        /// cluster.</p>
        /// <p>Default: The default VPC security group is associated with the cluster.</p>
        /// <p>VPC security groups only apply to clusters in VPCs.</p>
        pub fn set_vpc_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_vpc_security_group_ids(input);
            self
        }
        /// <p>The weekly time range (in UTC) during which automated cluster maintenance can
        /// occur.</p>
        /// <p> Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
        /// </p>
        /// <p> Default: The value selected for the cluster from which the snapshot was taken. For
        /// more information about the time blocks for each region, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#rs-maintenance-windows">Maintenance Windows</a> in Amazon Redshift Cluster Management Guide. </p>
        /// <p>Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun</p>
        /// <p>Constraints: Minimum 30-minute window.</p>
        pub fn preferred_maintenance_window(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.preferred_maintenance_window(inp);
            self
        }
        /// <p>The weekly time range (in UTC) during which automated cluster maintenance can
        /// occur.</p>
        /// <p> Format: <code>ddd:hh24:mi-ddd:hh24:mi</code>
        /// </p>
        /// <p> Default: The value selected for the cluster from which the snapshot was taken. For
        /// more information about the time blocks for each region, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#rs-maintenance-windows">Maintenance Windows</a> in Amazon Redshift Cluster Management Guide. </p>
        /// <p>Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun</p>
        /// <p>Constraints: Minimum 30-minute window.</p>
        pub fn set_preferred_maintenance_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_preferred_maintenance_window(input);
            self
        }
        /// <p>The number of days that automated snapshots are retained. If the value is 0,
        /// automated snapshots are disabled. Even if automated snapshots are disabled, you can
        /// still create manual snapshots when you want with <a>CreateClusterSnapshot</a>. </p>
        ///
        /// <p>You can't disable automated snapshots for RA3 node types. Set the automated retention period from 1-35 days.</p>
        /// <p>Default: The value selected for the cluster from which the snapshot was
        /// taken.</p>
        /// <p>Constraints: Must be a value from 0 to 35.</p>
        pub fn automated_snapshot_retention_period(mut self, inp: i32) -> Self {
            self.inner = self.inner.automated_snapshot_retention_period(inp);
            self
        }
        /// <p>The number of days that automated snapshots are retained. If the value is 0,
        /// automated snapshots are disabled. Even if automated snapshots are disabled, you can
        /// still create manual snapshots when you want with <a>CreateClusterSnapshot</a>. </p>
        ///
        /// <p>You can't disable automated snapshots for RA3 node types. Set the automated retention period from 1-35 days.</p>
        /// <p>Default: The value selected for the cluster from which the snapshot was
        /// taken.</p>
        /// <p>Constraints: Must be a value from 0 to 35.</p>
        pub fn set_automated_snapshot_retention_period(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.inner = self.inner.set_automated_snapshot_retention_period(input);
            self
        }
        /// <p>The default number of days to retain a manual snapshot. If the value is -1, the
        /// snapshot is retained indefinitely. This setting doesn't change the retention period
        /// of existing snapshots.</p>
        /// <p>The value must be either -1 or an integer between 1 and 3,653.</p>
        pub fn manual_snapshot_retention_period(mut self, inp: i32) -> Self {
            self.inner = self.inner.manual_snapshot_retention_period(inp);
            self
        }
        /// <p>The default number of days to retain a manual snapshot. If the value is -1, the
        /// snapshot is retained indefinitely. This setting doesn't change the retention period
        /// of existing snapshots.</p>
        /// <p>The value must be either -1 or an integer between 1 and 3,653.</p>
        pub fn set_manual_snapshot_retention_period(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.inner = self.inner.set_manual_snapshot_retention_period(input);
            self
        }
        /// <p>The Key Management Service (KMS) key ID of the encryption key that you want to
        /// use to encrypt data in the cluster that you restore from a shared snapshot.</p>
        pub fn kms_key_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key_id(inp);
            self
        }
        /// <p>The Key Management Service (KMS) key ID of the encryption key that you want to
        /// use to encrypt data in the cluster that you restore from a shared snapshot.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key_id(input);
            self
        }
        /// <p>The node type that the restored cluster will be provisioned with.</p>
        /// <p>Default: The node type of the cluster from which the snapshot was taken. You can
        /// modify this if you are using any DS node type. In that case, you can choose to restore
        /// into another DS node type of the same size. For example, you can restore ds1.8xlarge
        /// into ds2.8xlarge, or ds1.xlarge into ds2.xlarge. If you have a DC instance type, you
        /// must restore into that same instance type and size. In other words, you can only restore
        /// a dc1.large instance type into another dc1.large instance type or dc2.large instance
        /// type. You can't restore dc1.8xlarge to dc2.8xlarge. First restore to a dc1.8xlarge
        /// cluster, then resize to a dc2.8large cluster. For more information about node types, see
        /// <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#rs-about-clusters-and-nodes">
        /// About Clusters and Nodes</a> in the <i>Amazon Redshift Cluster Management Guide</i>. </p>
        pub fn node_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.node_type(inp);
            self
        }
        /// <p>The node type that the restored cluster will be provisioned with.</p>
        /// <p>Default: The node type of the cluster from which the snapshot was taken. You can
        /// modify this if you are using any DS node type. In that case, you can choose to restore
        /// into another DS node type of the same size. For example, you can restore ds1.8xlarge
        /// into ds2.8xlarge, or ds1.xlarge into ds2.xlarge. If you have a DC instance type, you
        /// must restore into that same instance type and size. In other words, you can only restore
        /// a dc1.large instance type into another dc1.large instance type or dc2.large instance
        /// type. You can't restore dc1.8xlarge to dc2.8xlarge. First restore to a dc1.8xlarge
        /// cluster, then resize to a dc2.8large cluster. For more information about node types, see
        /// <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#rs-about-clusters-and-nodes">
        /// About Clusters and Nodes</a> in the <i>Amazon Redshift Cluster Management Guide</i>. </p>
        pub fn set_node_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_node_type(input);
            self
        }
        /// <p>An option that specifies whether to create the cluster with enhanced VPC routing
        /// enabled. To create a cluster that uses enhanced VPC routing, the cluster must be in a
        /// VPC. For more information, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html">Enhanced VPC Routing</a> in
        /// the Amazon Redshift Cluster Management Guide.</p>
        /// <p>If this option is <code>true</code>, enhanced VPC routing is enabled. </p>
        /// <p>Default: false</p>
        pub fn enhanced_vpc_routing(mut self, inp: bool) -> Self {
            self.inner = self.inner.enhanced_vpc_routing(inp);
            self
        }
        /// <p>An option that specifies whether to create the cluster with enhanced VPC routing
        /// enabled. To create a cluster that uses enhanced VPC routing, the cluster must be in a
        /// VPC. For more information, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html">Enhanced VPC Routing</a> in
        /// the Amazon Redshift Cluster Management Guide.</p>
        /// <p>If this option is <code>true</code>, enhanced VPC routing is enabled. </p>
        /// <p>Default: false</p>
        pub fn set_enhanced_vpc_routing(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enhanced_vpc_routing(input);
            self
        }
        /// <p>Reserved.</p>
        pub fn additional_info(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.additional_info(inp);
            self
        }
        /// <p>Reserved.</p>
        pub fn set_additional_info(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_additional_info(input);
            self
        }
        /// Appends an item to `IamRoles`.
        ///
        /// To override the contents of this collection use [`set_iam_roles`](Self::set_iam_roles).
        ///
        /// <p>A list of Identity and Access Management (IAM) roles that can be used by the
        /// cluster to access other Amazon Web Services services. You must supply the IAM roles in their Amazon
        /// Resource Name (ARN) format. You can supply up to 10 IAM roles in a single
        /// request.</p>
        /// <p>A cluster can have up to 10 IAM roles associated at any time.</p>
        pub fn iam_roles(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.iam_roles(inp);
            self
        }
        /// <p>A list of Identity and Access Management (IAM) roles that can be used by the
        /// cluster to access other Amazon Web Services services. You must supply the IAM roles in their Amazon
        /// Resource Name (ARN) format. You can supply up to 10 IAM roles in a single
        /// request.</p>
        /// <p>A cluster can have up to 10 IAM roles associated at any time.</p>
        pub fn set_iam_roles(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_iam_roles(input);
            self
        }
        /// <p>The name of the maintenance track for the restored cluster. When you take a snapshot,
        /// the snapshot inherits the <code>MaintenanceTrack</code> value from the cluster. The
        /// snapshot might be on a different track than the cluster that was the source for the
        /// snapshot. For example, suppose that you take a snapshot of a cluster that is on the
        /// current track and then change the cluster to be on the trailing track. In this case, the
        /// snapshot and the source cluster are on different tracks.</p>
        pub fn maintenance_track_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.maintenance_track_name(inp);
            self
        }
        /// <p>The name of the maintenance track for the restored cluster. When you take a snapshot,
        /// the snapshot inherits the <code>MaintenanceTrack</code> value from the cluster. The
        /// snapshot might be on a different track than the cluster that was the source for the
        /// snapshot. For example, suppose that you take a snapshot of a cluster that is on the
        /// current track and then change the cluster to be on the trailing track. In this case, the
        /// snapshot and the source cluster are on different tracks.</p>
        pub fn set_maintenance_track_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_maintenance_track_name(input);
            self
        }
        /// <p>A unique identifier for the snapshot schedule.</p>
        pub fn snapshot_schedule_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.snapshot_schedule_identifier(inp);
            self
        }
        /// <p>A unique identifier for the snapshot schedule.</p>
        pub fn set_snapshot_schedule_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_snapshot_schedule_identifier(input);
            self
        }
        /// <p>The number of nodes specified when provisioning the restored cluster.</p>
        pub fn number_of_nodes(mut self, inp: i32) -> Self {
            self.inner = self.inner.number_of_nodes(inp);
            self
        }
        /// <p>The number of nodes specified when provisioning the restored cluster.</p>
        pub fn set_number_of_nodes(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_number_of_nodes(input);
            self
        }
        /// <p>The option to enable relocation for an Amazon Redshift cluster between Availability Zones after the cluster is restored.</p>
        pub fn availability_zone_relocation(mut self, inp: bool) -> Self {
            self.inner = self.inner.availability_zone_relocation(inp);
            self
        }
        /// <p>The option to enable relocation for an Amazon Redshift cluster between Availability Zones after the cluster is restored.</p>
        pub fn set_availability_zone_relocation(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_availability_zone_relocation(input);
            self
        }
        /// <p>The value represents how the cluster is configured to use AQUA (Advanced Query Accelerator) after the cluster is restored. Possible values include the following.</p>
        /// <ul>
        /// <li>
        /// <p>enabled - Use AQUA if it is available for the current Amazon Web Services Region and Amazon Redshift node type.</p>
        /// </li>
        /// <li>
        /// <p>disabled - Don't use AQUA. </p>
        /// </li>
        /// <li>
        /// <p>auto - Amazon Redshift determines whether to use AQUA.</p>
        /// </li>
        /// </ul>
        pub fn aqua_configuration_status(
            mut self,
            inp: crate::model::AquaConfigurationStatus,
        ) -> Self {
            self.inner = self.inner.aqua_configuration_status(inp);
            self
        }
        /// <p>The value represents how the cluster is configured to use AQUA (Advanced Query Accelerator) after the cluster is restored. Possible values include the following.</p>
        /// <ul>
        /// <li>
        /// <p>enabled - Use AQUA if it is available for the current Amazon Web Services Region and Amazon Redshift node type.</p>
        /// </li>
        /// <li>
        /// <p>disabled - Don't use AQUA. </p>
        /// </li>
        /// <li>
        /// <p>auto - Amazon Redshift determines whether to use AQUA.</p>
        /// </li>
        /// </ul>
        pub fn set_aqua_configuration_status(
            mut self,
            input: std::option::Option<crate::model::AquaConfigurationStatus>,
        ) -> Self {
            self.inner = self.inner.set_aqua_configuration_status(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RestoreTableFromClusterSnapshot`.
    ///
    /// <p>Creates a new table from a table in an Amazon Redshift cluster snapshot. You must
    /// create the new table within the Amazon Redshift cluster that the snapshot was taken
    /// from.</p>
    /// <p>You cannot use <code>RestoreTableFromClusterSnapshot</code> to restore a table with
    /// the same name as an existing table in an Amazon Redshift cluster. That is, you cannot
    /// overwrite an existing table in a cluster with a restored table. If you want to replace
    /// your original table with a new, restored table, then rename or drop your original table
    /// before you call <code>RestoreTableFromClusterSnapshot</code>. When you have renamed your
    /// original table, then you can pass the original name of the table as the
    /// <code>NewTableName</code> parameter value in the call to
    /// <code>RestoreTableFromClusterSnapshot</code>. This way, you can replace the original
    /// table with the table created from the snapshot.</p>
    #[derive(std::fmt::Debug)]
    pub struct RestoreTableFromClusterSnapshot<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::restore_table_from_cluster_snapshot_input::Builder,
    }
    impl<C, M, R> RestoreTableFromClusterSnapshot<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RestoreTableFromClusterSnapshot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RestoreTableFromClusterSnapshotOutput,
            aws_smithy_http::result::SdkError<crate::error::RestoreTableFromClusterSnapshotError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RestoreTableFromClusterSnapshotInputOperationOutputAlias,
                crate::output::RestoreTableFromClusterSnapshotOutput,
                crate::error::RestoreTableFromClusterSnapshotError,
                crate::input::RestoreTableFromClusterSnapshotInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Redshift cluster to restore the table to.</p>
        pub fn cluster_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_identifier(inp);
            self
        }
        /// <p>The identifier of the Amazon Redshift cluster to restore the table to.</p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_identifier(input);
            self
        }
        /// <p>The identifier of the snapshot to restore the table from. This snapshot must have
        /// been created from the Amazon Redshift cluster specified by the
        /// <code>ClusterIdentifier</code> parameter.</p>
        pub fn snapshot_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.snapshot_identifier(inp);
            self
        }
        /// <p>The identifier of the snapshot to restore the table from. This snapshot must have
        /// been created from the Amazon Redshift cluster specified by the
        /// <code>ClusterIdentifier</code> parameter.</p>
        pub fn set_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_snapshot_identifier(input);
            self
        }
        /// <p>The name of the source database that contains the table to restore from.</p>
        pub fn source_database_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_database_name(inp);
            self
        }
        /// <p>The name of the source database that contains the table to restore from.</p>
        pub fn set_source_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_database_name(input);
            self
        }
        /// <p>The name of the source schema that contains the table to restore from. If you do
        /// not specify a <code>SourceSchemaName</code> value, the default is
        /// <code>public</code>.</p>
        pub fn source_schema_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_schema_name(inp);
            self
        }
        /// <p>The name of the source schema that contains the table to restore from. If you do
        /// not specify a <code>SourceSchemaName</code> value, the default is
        /// <code>public</code>.</p>
        pub fn set_source_schema_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_schema_name(input);
            self
        }
        /// <p>The name of the source table to restore from.</p>
        pub fn source_table_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_table_name(inp);
            self
        }
        /// <p>The name of the source table to restore from.</p>
        pub fn set_source_table_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_table_name(input);
            self
        }
        /// <p>The name of the database to restore the table to.</p>
        pub fn target_database_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_database_name(inp);
            self
        }
        /// <p>The name of the database to restore the table to.</p>
        pub fn set_target_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_target_database_name(input);
            self
        }
        /// <p>The name of the schema to restore the table to.</p>
        pub fn target_schema_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_schema_name(inp);
            self
        }
        /// <p>The name of the schema to restore the table to.</p>
        pub fn set_target_schema_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_target_schema_name(input);
            self
        }
        /// <p>The name of the table to create as a result of the current request.</p>
        pub fn new_table_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.new_table_name(inp);
            self
        }
        /// <p>The name of the table to create as a result of the current request.</p>
        pub fn set_new_table_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_new_table_name(input);
            self
        }
        /// <p>Indicates whether name identifiers for database, schema, and table are case sensitive.
        /// If <code>true</code>, the names are case sensitive.
        /// If <code>false</code> (default), the names are not case sensitive.</p>
        pub fn enable_case_sensitive_identifier(mut self, inp: bool) -> Self {
            self.inner = self.inner.enable_case_sensitive_identifier(inp);
            self
        }
        /// <p>Indicates whether name identifiers for database, schema, and table are case sensitive.
        /// If <code>true</code>, the names are case sensitive.
        /// If <code>false</code> (default), the names are not case sensitive.</p>
        pub fn set_enable_case_sensitive_identifier(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_enable_case_sensitive_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ResumeCluster`.
    ///
    /// <p>Resumes a paused cluster.</p>
    #[derive(std::fmt::Debug)]
    pub struct ResumeCluster<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::resume_cluster_input::Builder,
    }
    impl<C, M, R> ResumeCluster<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ResumeCluster`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ResumeClusterOutput,
            aws_smithy_http::result::SdkError<crate::error::ResumeClusterError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ResumeClusterInputOperationOutputAlias,
                crate::output::ResumeClusterOutput,
                crate::error::ResumeClusterError,
                crate::input::ResumeClusterInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the cluster to be resumed.</p>
        pub fn cluster_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_identifier(inp);
            self
        }
        /// <p>The identifier of the cluster to be resumed.</p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RevokeClusterSecurityGroupIngress`.
    ///
    /// <p>Revokes an ingress rule in an Amazon Redshift security group for a previously authorized
    /// IP range or Amazon EC2 security group. To add an ingress rule, see <a>AuthorizeClusterSecurityGroupIngress</a>.
    /// For information about managing security groups, go to
    /// <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-security-groups.html">Amazon Redshift Cluster Security Groups</a> in the
    /// <i>Amazon Redshift Cluster Management Guide</i>. </p>
    #[derive(std::fmt::Debug)]
    pub struct RevokeClusterSecurityGroupIngress<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::revoke_cluster_security_group_ingress_input::Builder,
    }
    impl<C, M, R> RevokeClusterSecurityGroupIngress<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RevokeClusterSecurityGroupIngress`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RevokeClusterSecurityGroupIngressOutput,
            aws_smithy_http::result::SdkError<crate::error::RevokeClusterSecurityGroupIngressError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RevokeClusterSecurityGroupIngressInputOperationOutputAlias,
                crate::output::RevokeClusterSecurityGroupIngressOutput,
                crate::error::RevokeClusterSecurityGroupIngressError,
                crate::input::RevokeClusterSecurityGroupIngressInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the security Group from which to revoke the ingress rule.</p>
        pub fn cluster_security_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_security_group_name(inp);
            self
        }
        /// <p>The name of the security Group from which to revoke the ingress rule.</p>
        pub fn set_cluster_security_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_security_group_name(input);
            self
        }
        /// <p>The IP range for which to revoke access. This range must be a valid Classless
        /// Inter-Domain Routing (CIDR) block of IP addresses. If <code>CIDRIP</code> is specified,
        /// <code>EC2SecurityGroupName</code> and <code>EC2SecurityGroupOwnerId</code> cannot be
        /// provided. </p>
        pub fn cidrip(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cidrip(inp);
            self
        }
        /// <p>The IP range for which to revoke access. This range must be a valid Classless
        /// Inter-Domain Routing (CIDR) block of IP addresses. If <code>CIDRIP</code> is specified,
        /// <code>EC2SecurityGroupName</code> and <code>EC2SecurityGroupOwnerId</code> cannot be
        /// provided. </p>
        pub fn set_cidrip(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cidrip(input);
            self
        }
        /// <p>The name of the EC2 Security Group whose access is to be revoked. If
        /// <code>EC2SecurityGroupName</code> is specified, <code>EC2SecurityGroupOwnerId</code>
        /// must also be provided and <code>CIDRIP</code> cannot be provided. </p>
        pub fn ec2_security_group_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ec2_security_group_name(inp);
            self
        }
        /// <p>The name of the EC2 Security Group whose access is to be revoked. If
        /// <code>EC2SecurityGroupName</code> is specified, <code>EC2SecurityGroupOwnerId</code>
        /// must also be provided and <code>CIDRIP</code> cannot be provided. </p>
        pub fn set_ec2_security_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_ec2_security_group_name(input);
            self
        }
        /// <p>The Amazon Web Services account number of the owner of the security group specified in the
        /// <code>EC2SecurityGroupName</code> parameter. The Amazon Web Services access key ID is not an
        /// acceptable value. If <code>EC2SecurityGroupOwnerId</code> is specified,
        /// <code>EC2SecurityGroupName</code> must also be provided. and <code>CIDRIP</code>
        /// cannot be provided. </p>
        /// <p>Example: <code>111122223333</code>
        /// </p>
        pub fn ec2_security_group_owner_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ec2_security_group_owner_id(inp);
            self
        }
        /// <p>The Amazon Web Services account number of the owner of the security group specified in the
        /// <code>EC2SecurityGroupName</code> parameter. The Amazon Web Services access key ID is not an
        /// acceptable value. If <code>EC2SecurityGroupOwnerId</code> is specified,
        /// <code>EC2SecurityGroupName</code> must also be provided. and <code>CIDRIP</code>
        /// cannot be provided. </p>
        /// <p>Example: <code>111122223333</code>
        /// </p>
        pub fn set_ec2_security_group_owner_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_ec2_security_group_owner_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RevokeEndpointAccess`.
    ///
    /// <p>Revokes access to a cluster.</p>
    #[derive(std::fmt::Debug)]
    pub struct RevokeEndpointAccess<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::revoke_endpoint_access_input::Builder,
    }
    impl<C, M, R> RevokeEndpointAccess<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RevokeEndpointAccess`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RevokeEndpointAccessOutput,
            aws_smithy_http::result::SdkError<crate::error::RevokeEndpointAccessError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RevokeEndpointAccessInputOperationOutputAlias,
                crate::output::RevokeEndpointAccessOutput,
                crate::error::RevokeEndpointAccessError,
                crate::input::RevokeEndpointAccessInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The cluster to revoke access from.</p>
        pub fn cluster_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_identifier(inp);
            self
        }
        /// <p>The cluster to revoke access from.</p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_identifier(input);
            self
        }
        /// <p>The Amazon Web Services account ID whose access is to be revoked.</p>
        pub fn account(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account(inp);
            self
        }
        /// <p>The Amazon Web Services account ID whose access is to be revoked.</p>
        pub fn set_account(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account(input);
            self
        }
        /// Appends an item to `VpcIds`.
        ///
        /// To override the contents of this collection use [`set_vpc_ids`](Self::set_vpc_ids).
        ///
        /// <p>The virtual private cloud (VPC) identifiers for which access is to be revoked.</p>
        pub fn vpc_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc_ids(inp);
            self
        }
        /// <p>The virtual private cloud (VPC) identifiers for which access is to be revoked.</p>
        pub fn set_vpc_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_vpc_ids(input);
            self
        }
        /// <p>Indicates whether to force the revoke action.
        /// If true, the Redshift-managed VPC endpoints associated with the endpoint authorization are also deleted.</p>
        pub fn force(mut self, inp: bool) -> Self {
            self.inner = self.inner.force(inp);
            self
        }
        /// <p>Indicates whether to force the revoke action.
        /// If true, the Redshift-managed VPC endpoints associated with the endpoint authorization are also deleted.</p>
        pub fn set_force(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_force(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RevokeSnapshotAccess`.
    ///
    /// <p>Removes the ability of the specified  Amazon Web Services account to restore the specified
    /// snapshot. If the account is currently restoring the snapshot, the restore will run to
    /// completion.</p>
    /// <p>
    /// For more information about working with snapshots, go to
    /// <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-snapshots.html">Amazon Redshift Snapshots</a>
    /// in the <i>Amazon Redshift Cluster Management Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct RevokeSnapshotAccess<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::revoke_snapshot_access_input::Builder,
    }
    impl<C, M, R> RevokeSnapshotAccess<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RevokeSnapshotAccess`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RevokeSnapshotAccessOutput,
            aws_smithy_http::result::SdkError<crate::error::RevokeSnapshotAccessError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RevokeSnapshotAccessInputOperationOutputAlias,
                crate::output::RevokeSnapshotAccessOutput,
                crate::error::RevokeSnapshotAccessError,
                crate::input::RevokeSnapshotAccessInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the snapshot that the account can no longer access.</p>
        pub fn snapshot_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.snapshot_identifier(inp);
            self
        }
        /// <p>The identifier of the snapshot that the account can no longer access.</p>
        pub fn set_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_snapshot_identifier(input);
            self
        }
        /// <p>The identifier of the cluster the snapshot was created from. This parameter is
        /// required if your IAM user has a policy containing a snapshot resource element that
        /// specifies anything other than * for the cluster name.</p>
        pub fn snapshot_cluster_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.snapshot_cluster_identifier(inp);
            self
        }
        /// <p>The identifier of the cluster the snapshot was created from. This parameter is
        /// required if your IAM user has a policy containing a snapshot resource element that
        /// specifies anything other than * for the cluster name.</p>
        pub fn set_snapshot_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_snapshot_cluster_identifier(input);
            self
        }
        /// <p>The identifier of the Amazon Web Services account that can no longer restore the specified
        /// snapshot.</p>
        pub fn account_with_restore_access(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_with_restore_access(inp);
            self
        }
        /// <p>The identifier of the Amazon Web Services account that can no longer restore the specified
        /// snapshot.</p>
        pub fn set_account_with_restore_access(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_account_with_restore_access(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RotateEncryptionKey`.
    ///
    /// <p>Rotates the encryption keys for a cluster.</p>
    #[derive(std::fmt::Debug)]
    pub struct RotateEncryptionKey<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::rotate_encryption_key_input::Builder,
    }
    impl<C, M, R> RotateEncryptionKey<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RotateEncryptionKey`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RotateEncryptionKeyOutput,
            aws_smithy_http::result::SdkError<crate::error::RotateEncryptionKeyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RotateEncryptionKeyInputOperationOutputAlias,
                crate::output::RotateEncryptionKeyOutput,
                crate::error::RotateEncryptionKeyError,
                crate::input::RotateEncryptionKeyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the cluster that you want to rotate the encryption keys
        /// for.</p>
        /// <p>Constraints: Must be the name of valid cluster that has encryption
        /// enabled.</p>
        pub fn cluster_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_identifier(inp);
            self
        }
        /// <p>The unique identifier of the cluster that you want to rotate the encryption keys
        /// for.</p>
        /// <p>Constraints: Must be the name of valid cluster that has encryption
        /// enabled.</p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdatePartnerStatus`.
    ///
    /// <p>Updates the status of a partner integration.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdatePartnerStatus<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_partner_status_input::Builder,
    }
    impl<C, M, R> UpdatePartnerStatus<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdatePartnerStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdatePartnerStatusOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdatePartnerStatusError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdatePartnerStatusInputOperationOutputAlias,
                crate::output::UpdatePartnerStatusOutput,
                crate::error::UpdatePartnerStatusError,
                crate::input::UpdatePartnerStatusInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID that owns the cluster.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The Amazon Web Services account ID that owns the cluster.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The cluster identifier of the cluster whose partner integration status is being updated.</p>
        pub fn cluster_identifier(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_identifier(inp);
            self
        }
        /// <p>The cluster identifier of the cluster whose partner integration status is being updated.</p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_identifier(input);
            self
        }
        /// <p>The name of the database whose partner integration status is being updated.</p>
        pub fn database_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.database_name(inp);
            self
        }
        /// <p>The name of the database whose partner integration status is being updated.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_database_name(input);
            self
        }
        /// <p>The name of the partner whose integration status is being updated.</p>
        pub fn partner_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.partner_name(inp);
            self
        }
        /// <p>The name of the partner whose integration status is being updated.</p>
        pub fn set_partner_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_partner_name(input);
            self
        }
        /// <p>The value of the updated status.</p>
        pub fn status(mut self, inp: crate::model::PartnerIntegrationStatus) -> Self {
            self.inner = self.inner.status(inp);
            self
        }
        /// <p>The value of the updated status.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::PartnerIntegrationStatus>,
        ) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
        /// <p>The status message provided by the partner.</p>
        pub fn status_message(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.status_message(inp);
            self
        }
        /// <p>The status message provided by the partner.</p>
        pub fn set_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_status_message(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut client = aws_hyper::Client::new(conn)
            .with_retry_config(retry_config.into())
            .with_timeout_config(timeout_config);

        client.set_sleep_impl(sleep_impl);
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut client = aws_hyper::Client::https()
            .with_retry_config(retry_config.into())
            .with_timeout_config(timeout_config);

        client.set_sleep_impl(sleep_impl);
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
