// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PartnerIntegrationStatus {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    ConnectionFailure,
    #[allow(missing_docs)] // documentation missing in model
    Inactive,
    #[allow(missing_docs)] // documentation missing in model
    RuntimeFailure,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PartnerIntegrationStatus {
    fn from(s: &str) -> Self {
        match s {
            "Active" => PartnerIntegrationStatus::Active,
            "ConnectionFailure" => PartnerIntegrationStatus::ConnectionFailure,
            "Inactive" => PartnerIntegrationStatus::Inactive,
            "RuntimeFailure" => PartnerIntegrationStatus::RuntimeFailure,
            other => PartnerIntegrationStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PartnerIntegrationStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PartnerIntegrationStatus::from(s))
    }
}
impl PartnerIntegrationStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PartnerIntegrationStatus::Active => "Active",
            PartnerIntegrationStatus::ConnectionFailure => "ConnectionFailure",
            PartnerIntegrationStatus::Inactive => "Inactive",
            PartnerIntegrationStatus::RuntimeFailure => "RuntimeFailure",
            PartnerIntegrationStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Active", "ConnectionFailure", "Inactive", "RuntimeFailure"]
    }
}
impl AsRef<str> for PartnerIntegrationStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes a cluster.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Cluster {
    /// <p>The unique identifier of the cluster.</p>
    pub cluster_identifier: std::option::Option<std::string::String>,
    /// <p>The node type for the nodes in the cluster.</p>
    pub node_type: std::option::Option<std::string::String>,
    /// <p> The current state of the cluster. Possible values are the following:</p>
    /// <ul>
    /// <li> <p> <code>available</code> </p> </li>
    /// <li> <p> <code>available, prep-for-resize</code> </p> </li>
    /// <li> <p> <code>available, resize-cleanup</code> </p> </li>
    /// <li> <p> <code>cancelling-resize</code> </p> </li>
    /// <li> <p> <code>creating</code> </p> </li>
    /// <li> <p> <code>deleting</code> </p> </li>
    /// <li> <p> <code>final-snapshot</code> </p> </li>
    /// <li> <p> <code>hardware-failure</code> </p> </li>
    /// <li> <p> <code>incompatible-hsm</code> </p> </li>
    /// <li> <p> <code>incompatible-network</code> </p> </li>
    /// <li> <p> <code>incompatible-parameters</code> </p> </li>
    /// <li> <p> <code>incompatible-restore</code> </p> </li>
    /// <li> <p> <code>modifying</code> </p> </li>
    /// <li> <p> <code>paused</code> </p> </li>
    /// <li> <p> <code>rebooting</code> </p> </li>
    /// <li> <p> <code>renaming</code> </p> </li>
    /// <li> <p> <code>resizing</code> </p> </li>
    /// <li> <p> <code>rotating-keys</code> </p> </li>
    /// <li> <p> <code>storage-full</code> </p> </li>
    /// <li> <p> <code>updating-hsm</code> </p> </li>
    /// </ul>
    pub cluster_status: std::option::Option<std::string::String>,
    /// <p>The availability status of the cluster for queries. Possible values are the following:</p>
    /// <ul>
    /// <li> <p>Available - The cluster is available for queries. </p> </li>
    /// <li> <p>Unavailable - The cluster is not available for queries.</p> </li>
    /// <li> <p>Maintenance - The cluster is intermittently available for queries due to maintenance activities.</p> </li>
    /// <li> <p>Modifying - The cluster is intermittently available for queries due to changes that modify the cluster.</p> </li>
    /// <li> <p>Failed - The cluster failed and is not available for queries.</p> </li>
    /// </ul>
    pub cluster_availability_status: std::option::Option<std::string::String>,
    /// <p>The status of a modify operation, if any, initiated for the cluster.</p>
    pub modify_status: std::option::Option<std::string::String>,
    /// <p>The admin user name for the cluster. This name is used to connect to the database that is specified in the <b>DBName</b> parameter. </p>
    pub master_username: std::option::Option<std::string::String>,
    /// <p>The name of the initial database that was created when the cluster was created. This same name is returned for the life of the cluster. If an initial database was not specified, a database named <code>dev</code>dev was created by default. </p>
    pub db_name: std::option::Option<std::string::String>,
    /// <p>The connection endpoint.</p>
    pub endpoint: std::option::Option<crate::model::Endpoint>,
    /// <p>The date and time that the cluster was created.</p>
    pub cluster_create_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The number of days that automatic cluster snapshots are retained.</p>
    pub automated_snapshot_retention_period: i32,
    /// <p>The default number of days to retain a manual snapshot. If the value is -1, the snapshot is retained indefinitely. This setting doesn't change the retention period of existing snapshots.</p>
    /// <p>The value must be either -1 or an integer between 1 and 3,653.</p>
    pub manual_snapshot_retention_period: i32,
    /// <p>A list of cluster security group that are associated with the cluster. Each security group is represented by an element that contains <code>ClusterSecurityGroup.Name</code> and <code>ClusterSecurityGroup.Status</code> subelements. </p>
    /// <p>Cluster security groups are used when the cluster is not created in an Amazon Virtual Private Cloud (VPC). Clusters that are created in a VPC use VPC security groups, which are listed by the <b>VpcSecurityGroups</b> parameter. </p>
    pub cluster_security_groups:
        std::option::Option<std::vec::Vec<crate::model::ClusterSecurityGroupMembership>>,
    /// <p>A list of Amazon Virtual Private Cloud (Amazon VPC) security groups that are associated with the cluster. This parameter is returned only if the cluster is in a VPC.</p>
    pub vpc_security_groups:
        std::option::Option<std::vec::Vec<crate::model::VpcSecurityGroupMembership>>,
    /// <p>The list of cluster parameter groups that are associated with this cluster. Each parameter group in the list is returned with its status.</p>
    pub cluster_parameter_groups:
        std::option::Option<std::vec::Vec<crate::model::ClusterParameterGroupStatus>>,
    /// <p>The name of the subnet group that is associated with the cluster. This parameter is valid only when the cluster is in a VPC.</p>
    pub cluster_subnet_group_name: std::option::Option<std::string::String>,
    /// <p>The identifier of the VPC the cluster is in, if the cluster is in a VPC.</p>
    pub vpc_id: std::option::Option<std::string::String>,
    /// <p>The name of the Availability Zone in which the cluster is located.</p>
    pub availability_zone: std::option::Option<std::string::String>,
    /// <p>The weekly time range, in Universal Coordinated Time (UTC), during which system maintenance can occur.</p>
    pub preferred_maintenance_window: std::option::Option<std::string::String>,
    /// <p>A value that, if present, indicates that changes to the cluster are pending. Specific pending changes are identified by subelements.</p>
    pub pending_modified_values: std::option::Option<crate::model::PendingModifiedValues>,
    /// <p>The version ID of the Amazon Redshift engine that is running on the cluster.</p>
    pub cluster_version: std::option::Option<std::string::String>,
    /// <p>A boolean value that, if <code>true</code>, indicates that major version upgrades will be applied automatically to the cluster during the maintenance window. </p>
    pub allow_version_upgrade: bool,
    /// <p>The number of compute nodes in the cluster.</p>
    pub number_of_nodes: i32,
    /// <p>A boolean value that, if <code>true</code>, indicates that the cluster can be accessed from a public network.</p>
    pub publicly_accessible: bool,
    /// <p>A boolean value that, if <code>true</code>, indicates that data in the cluster is encrypted at rest.</p>
    pub encrypted: bool,
    /// <p>A value that describes the status of a cluster restore action. This parameter returns null if the cluster was not created by restoring a snapshot.</p>
    pub restore_status: std::option::Option<crate::model::RestoreStatus>,
    /// <p></p>
    pub data_transfer_progress: std::option::Option<crate::model::DataTransferProgress>,
    /// <p>A value that reports whether the Amazon Redshift cluster has finished applying any hardware security module (HSM) settings changes specified in a modify cluster command.</p>
    /// <p>Values: active, applying</p>
    pub hsm_status: std::option::Option<crate::model::HsmStatus>,
    /// <p>A value that returns the destination region and retention period that are configured for cross-region snapshot copy.</p>
    pub cluster_snapshot_copy_status: std::option::Option<crate::model::ClusterSnapshotCopyStatus>,
    /// <p>The public key for the cluster.</p>
    pub cluster_public_key: std::option::Option<std::string::String>,
    /// <p>The nodes in the cluster.</p>
    pub cluster_nodes: std::option::Option<std::vec::Vec<crate::model::ClusterNode>>,
    /// <p>The status of the elastic IP (EIP) address.</p>
    pub elastic_ip_status: std::option::Option<crate::model::ElasticIpStatus>,
    /// <p>The specific revision number of the database in the cluster.</p>
    pub cluster_revision_number: std::option::Option<std::string::String>,
    /// <p>The list of tags for the cluster.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The Key Management Service (KMS) key ID of the encryption key used to encrypt data in the cluster.</p>
    pub kms_key_id: std::option::Option<std::string::String>,
    /// <p>An option that specifies whether to create the cluster with enhanced VPC routing enabled. To create a cluster that uses enhanced VPC routing, the cluster must be in a VPC. For more information, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html">Enhanced VPC Routing</a> in the Amazon Redshift Cluster Management Guide.</p>
    /// <p>If this option is <code>true</code>, enhanced VPC routing is enabled. </p>
    /// <p>Default: false</p>
    pub enhanced_vpc_routing: bool,
    /// <p>A list of Identity and Access Management (IAM) roles that can be used by the cluster to access other Amazon Web Services services.</p>
    pub iam_roles: std::option::Option<std::vec::Vec<crate::model::ClusterIamRole>>,
    /// <p>Cluster operations that are waiting to be started.</p>
    pub pending_actions: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The name of the maintenance track for the cluster.</p>
    pub maintenance_track_name: std::option::Option<std::string::String>,
    /// <p>The number of nodes that you can resize the cluster to with the elastic resize method. </p>
    pub elastic_resize_number_of_node_options: std::option::Option<std::string::String>,
    /// <p>Describes a group of <code>DeferredMaintenanceWindow</code> objects.</p>
    pub deferred_maintenance_windows:
        std::option::Option<std::vec::Vec<crate::model::DeferredMaintenanceWindow>>,
    /// <p>A unique identifier for the cluster snapshot schedule.</p>
    pub snapshot_schedule_identifier: std::option::Option<std::string::String>,
    /// <p>The current state of the cluster snapshot schedule.</p>
    pub snapshot_schedule_state: std::option::Option<crate::model::ScheduleState>,
    /// <p>The date and time when the next snapshot is expected to be taken for clusters with a valid snapshot schedule and backups enabled. </p>
    pub expected_next_snapshot_schedule_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p> The status of next expected snapshot for clusters having a valid snapshot schedule and backups enabled. Possible values are the following:</p>
    /// <ul>
    /// <li> <p>OnTrack - The next snapshot is expected to be taken on time. </p> </li>
    /// <li> <p>Pending - The next snapshot is pending to be taken. </p> </li>
    /// </ul>
    pub expected_next_snapshot_schedule_time_status: std::option::Option<std::string::String>,
    /// <p>The date and time in UTC when system maintenance can begin.</p>
    pub next_maintenance_window_start_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Returns the following:</p>
    /// <ul>
    /// <li> <p>AllowCancelResize: a boolean value indicating if the resize operation can be cancelled.</p> </li>
    /// <li> <p>ResizeType: Returns ClassicResize</p> </li>
    /// </ul>
    pub resize_info: std::option::Option<crate::model::ResizeInfo>,
    /// <p>Describes the status of the Availability Zone relocation operation.</p>
    pub availability_zone_relocation_status: std::option::Option<std::string::String>,
    /// <p>The namespace Amazon Resource Name (ARN) of the cluster.</p>
    pub cluster_namespace_arn: std::option::Option<std::string::String>,
    /// <p>The total storage capacity of the cluster in megabytes. </p>
    pub total_storage_capacity_in_mega_bytes: std::option::Option<i64>,
    /// <p>The AQUA (Advanced Query Accelerator) configuration of the cluster.</p>
    pub aqua_configuration: std::option::Option<crate::model::AquaConfiguration>,
    /// <p>The Amazon Resource Name (ARN) for the IAM role set as default for the cluster.</p>
    pub default_iam_role_arn: std::option::Option<std::string::String>,
    /// <p>The status of the reserved-node exchange request. Statuses include in-progress and requested.</p>
    pub reserved_node_exchange_status:
        std::option::Option<crate::model::ReservedNodeExchangeStatus>,
}
impl Cluster {
    /// <p>The unique identifier of the cluster.</p>
    pub fn cluster_identifier(&self) -> std::option::Option<&str> {
        self.cluster_identifier.as_deref()
    }
    /// <p>The node type for the nodes in the cluster.</p>
    pub fn node_type(&self) -> std::option::Option<&str> {
        self.node_type.as_deref()
    }
    /// <p> The current state of the cluster. Possible values are the following:</p>
    /// <ul>
    /// <li> <p> <code>available</code> </p> </li>
    /// <li> <p> <code>available, prep-for-resize</code> </p> </li>
    /// <li> <p> <code>available, resize-cleanup</code> </p> </li>
    /// <li> <p> <code>cancelling-resize</code> </p> </li>
    /// <li> <p> <code>creating</code> </p> </li>
    /// <li> <p> <code>deleting</code> </p> </li>
    /// <li> <p> <code>final-snapshot</code> </p> </li>
    /// <li> <p> <code>hardware-failure</code> </p> </li>
    /// <li> <p> <code>incompatible-hsm</code> </p> </li>
    /// <li> <p> <code>incompatible-network</code> </p> </li>
    /// <li> <p> <code>incompatible-parameters</code> </p> </li>
    /// <li> <p> <code>incompatible-restore</code> </p> </li>
    /// <li> <p> <code>modifying</code> </p> </li>
    /// <li> <p> <code>paused</code> </p> </li>
    /// <li> <p> <code>rebooting</code> </p> </li>
    /// <li> <p> <code>renaming</code> </p> </li>
    /// <li> <p> <code>resizing</code> </p> </li>
    /// <li> <p> <code>rotating-keys</code> </p> </li>
    /// <li> <p> <code>storage-full</code> </p> </li>
    /// <li> <p> <code>updating-hsm</code> </p> </li>
    /// </ul>
    pub fn cluster_status(&self) -> std::option::Option<&str> {
        self.cluster_status.as_deref()
    }
    /// <p>The availability status of the cluster for queries. Possible values are the following:</p>
    /// <ul>
    /// <li> <p>Available - The cluster is available for queries. </p> </li>
    /// <li> <p>Unavailable - The cluster is not available for queries.</p> </li>
    /// <li> <p>Maintenance - The cluster is intermittently available for queries due to maintenance activities.</p> </li>
    /// <li> <p>Modifying - The cluster is intermittently available for queries due to changes that modify the cluster.</p> </li>
    /// <li> <p>Failed - The cluster failed and is not available for queries.</p> </li>
    /// </ul>
    pub fn cluster_availability_status(&self) -> std::option::Option<&str> {
        self.cluster_availability_status.as_deref()
    }
    /// <p>The status of a modify operation, if any, initiated for the cluster.</p>
    pub fn modify_status(&self) -> std::option::Option<&str> {
        self.modify_status.as_deref()
    }
    /// <p>The admin user name for the cluster. This name is used to connect to the database that is specified in the <b>DBName</b> parameter. </p>
    pub fn master_username(&self) -> std::option::Option<&str> {
        self.master_username.as_deref()
    }
    /// <p>The name of the initial database that was created when the cluster was created. This same name is returned for the life of the cluster. If an initial database was not specified, a database named <code>dev</code>dev was created by default. </p>
    pub fn db_name(&self) -> std::option::Option<&str> {
        self.db_name.as_deref()
    }
    /// <p>The connection endpoint.</p>
    pub fn endpoint(&self) -> std::option::Option<&crate::model::Endpoint> {
        self.endpoint.as_ref()
    }
    /// <p>The date and time that the cluster was created.</p>
    pub fn cluster_create_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.cluster_create_time.as_ref()
    }
    /// <p>The number of days that automatic cluster snapshots are retained.</p>
    pub fn automated_snapshot_retention_period(&self) -> i32 {
        self.automated_snapshot_retention_period
    }
    /// <p>The default number of days to retain a manual snapshot. If the value is -1, the snapshot is retained indefinitely. This setting doesn't change the retention period of existing snapshots.</p>
    /// <p>The value must be either -1 or an integer between 1 and 3,653.</p>
    pub fn manual_snapshot_retention_period(&self) -> i32 {
        self.manual_snapshot_retention_period
    }
    /// <p>A list of cluster security group that are associated with the cluster. Each security group is represented by an element that contains <code>ClusterSecurityGroup.Name</code> and <code>ClusterSecurityGroup.Status</code> subelements. </p>
    /// <p>Cluster security groups are used when the cluster is not created in an Amazon Virtual Private Cloud (VPC). Clusters that are created in a VPC use VPC security groups, which are listed by the <b>VpcSecurityGroups</b> parameter. </p>
    pub fn cluster_security_groups(
        &self,
    ) -> std::option::Option<&[crate::model::ClusterSecurityGroupMembership]> {
        self.cluster_security_groups.as_deref()
    }
    /// <p>A list of Amazon Virtual Private Cloud (Amazon VPC) security groups that are associated with the cluster. This parameter is returned only if the cluster is in a VPC.</p>
    pub fn vpc_security_groups(
        &self,
    ) -> std::option::Option<&[crate::model::VpcSecurityGroupMembership]> {
        self.vpc_security_groups.as_deref()
    }
    /// <p>The list of cluster parameter groups that are associated with this cluster. Each parameter group in the list is returned with its status.</p>
    pub fn cluster_parameter_groups(
        &self,
    ) -> std::option::Option<&[crate::model::ClusterParameterGroupStatus]> {
        self.cluster_parameter_groups.as_deref()
    }
    /// <p>The name of the subnet group that is associated with the cluster. This parameter is valid only when the cluster is in a VPC.</p>
    pub fn cluster_subnet_group_name(&self) -> std::option::Option<&str> {
        self.cluster_subnet_group_name.as_deref()
    }
    /// <p>The identifier of the VPC the cluster is in, if the cluster is in a VPC.</p>
    pub fn vpc_id(&self) -> std::option::Option<&str> {
        self.vpc_id.as_deref()
    }
    /// <p>The name of the Availability Zone in which the cluster is located.</p>
    pub fn availability_zone(&self) -> std::option::Option<&str> {
        self.availability_zone.as_deref()
    }
    /// <p>The weekly time range, in Universal Coordinated Time (UTC), during which system maintenance can occur.</p>
    pub fn preferred_maintenance_window(&self) -> std::option::Option<&str> {
        self.preferred_maintenance_window.as_deref()
    }
    /// <p>A value that, if present, indicates that changes to the cluster are pending. Specific pending changes are identified by subelements.</p>
    pub fn pending_modified_values(
        &self,
    ) -> std::option::Option<&crate::model::PendingModifiedValues> {
        self.pending_modified_values.as_ref()
    }
    /// <p>The version ID of the Amazon Redshift engine that is running on the cluster.</p>
    pub fn cluster_version(&self) -> std::option::Option<&str> {
        self.cluster_version.as_deref()
    }
    /// <p>A boolean value that, if <code>true</code>, indicates that major version upgrades will be applied automatically to the cluster during the maintenance window. </p>
    pub fn allow_version_upgrade(&self) -> bool {
        self.allow_version_upgrade
    }
    /// <p>The number of compute nodes in the cluster.</p>
    pub fn number_of_nodes(&self) -> i32 {
        self.number_of_nodes
    }
    /// <p>A boolean value that, if <code>true</code>, indicates that the cluster can be accessed from a public network.</p>
    pub fn publicly_accessible(&self) -> bool {
        self.publicly_accessible
    }
    /// <p>A boolean value that, if <code>true</code>, indicates that data in the cluster is encrypted at rest.</p>
    pub fn encrypted(&self) -> bool {
        self.encrypted
    }
    /// <p>A value that describes the status of a cluster restore action. This parameter returns null if the cluster was not created by restoring a snapshot.</p>
    pub fn restore_status(&self) -> std::option::Option<&crate::model::RestoreStatus> {
        self.restore_status.as_ref()
    }
    /// <p></p>
    pub fn data_transfer_progress(
        &self,
    ) -> std::option::Option<&crate::model::DataTransferProgress> {
        self.data_transfer_progress.as_ref()
    }
    /// <p>A value that reports whether the Amazon Redshift cluster has finished applying any hardware security module (HSM) settings changes specified in a modify cluster command.</p>
    /// <p>Values: active, applying</p>
    pub fn hsm_status(&self) -> std::option::Option<&crate::model::HsmStatus> {
        self.hsm_status.as_ref()
    }
    /// <p>A value that returns the destination region and retention period that are configured for cross-region snapshot copy.</p>
    pub fn cluster_snapshot_copy_status(
        &self,
    ) -> std::option::Option<&crate::model::ClusterSnapshotCopyStatus> {
        self.cluster_snapshot_copy_status.as_ref()
    }
    /// <p>The public key for the cluster.</p>
    pub fn cluster_public_key(&self) -> std::option::Option<&str> {
        self.cluster_public_key.as_deref()
    }
    /// <p>The nodes in the cluster.</p>
    pub fn cluster_nodes(&self) -> std::option::Option<&[crate::model::ClusterNode]> {
        self.cluster_nodes.as_deref()
    }
    /// <p>The status of the elastic IP (EIP) address.</p>
    pub fn elastic_ip_status(&self) -> std::option::Option<&crate::model::ElasticIpStatus> {
        self.elastic_ip_status.as_ref()
    }
    /// <p>The specific revision number of the database in the cluster.</p>
    pub fn cluster_revision_number(&self) -> std::option::Option<&str> {
        self.cluster_revision_number.as_deref()
    }
    /// <p>The list of tags for the cluster.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>The Key Management Service (KMS) key ID of the encryption key used to encrypt data in the cluster.</p>
    pub fn kms_key_id(&self) -> std::option::Option<&str> {
        self.kms_key_id.as_deref()
    }
    /// <p>An option that specifies whether to create the cluster with enhanced VPC routing enabled. To create a cluster that uses enhanced VPC routing, the cluster must be in a VPC. For more information, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html">Enhanced VPC Routing</a> in the Amazon Redshift Cluster Management Guide.</p>
    /// <p>If this option is <code>true</code>, enhanced VPC routing is enabled. </p>
    /// <p>Default: false</p>
    pub fn enhanced_vpc_routing(&self) -> bool {
        self.enhanced_vpc_routing
    }
    /// <p>A list of Identity and Access Management (IAM) roles that can be used by the cluster to access other Amazon Web Services services.</p>
    pub fn iam_roles(&self) -> std::option::Option<&[crate::model::ClusterIamRole]> {
        self.iam_roles.as_deref()
    }
    /// <p>Cluster operations that are waiting to be started.</p>
    pub fn pending_actions(&self) -> std::option::Option<&[std::string::String]> {
        self.pending_actions.as_deref()
    }
    /// <p>The name of the maintenance track for the cluster.</p>
    pub fn maintenance_track_name(&self) -> std::option::Option<&str> {
        self.maintenance_track_name.as_deref()
    }
    /// <p>The number of nodes that you can resize the cluster to with the elastic resize method. </p>
    pub fn elastic_resize_number_of_node_options(&self) -> std::option::Option<&str> {
        self.elastic_resize_number_of_node_options.as_deref()
    }
    /// <p>Describes a group of <code>DeferredMaintenanceWindow</code> objects.</p>
    pub fn deferred_maintenance_windows(
        &self,
    ) -> std::option::Option<&[crate::model::DeferredMaintenanceWindow]> {
        self.deferred_maintenance_windows.as_deref()
    }
    /// <p>A unique identifier for the cluster snapshot schedule.</p>
    pub fn snapshot_schedule_identifier(&self) -> std::option::Option<&str> {
        self.snapshot_schedule_identifier.as_deref()
    }
    /// <p>The current state of the cluster snapshot schedule.</p>
    pub fn snapshot_schedule_state(&self) -> std::option::Option<&crate::model::ScheduleState> {
        self.snapshot_schedule_state.as_ref()
    }
    /// <p>The date and time when the next snapshot is expected to be taken for clusters with a valid snapshot schedule and backups enabled. </p>
    pub fn expected_next_snapshot_schedule_time(
        &self,
    ) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.expected_next_snapshot_schedule_time.as_ref()
    }
    /// <p> The status of next expected snapshot for clusters having a valid snapshot schedule and backups enabled. Possible values are the following:</p>
    /// <ul>
    /// <li> <p>OnTrack - The next snapshot is expected to be taken on time. </p> </li>
    /// <li> <p>Pending - The next snapshot is pending to be taken. </p> </li>
    /// </ul>
    pub fn expected_next_snapshot_schedule_time_status(&self) -> std::option::Option<&str> {
        self.expected_next_snapshot_schedule_time_status.as_deref()
    }
    /// <p>The date and time in UTC when system maintenance can begin.</p>
    pub fn next_maintenance_window_start_time(
        &self,
    ) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.next_maintenance_window_start_time.as_ref()
    }
    /// <p>Returns the following:</p>
    /// <ul>
    /// <li> <p>AllowCancelResize: a boolean value indicating if the resize operation can be cancelled.</p> </li>
    /// <li> <p>ResizeType: Returns ClassicResize</p> </li>
    /// </ul>
    pub fn resize_info(&self) -> std::option::Option<&crate::model::ResizeInfo> {
        self.resize_info.as_ref()
    }
    /// <p>Describes the status of the Availability Zone relocation operation.</p>
    pub fn availability_zone_relocation_status(&self) -> std::option::Option<&str> {
        self.availability_zone_relocation_status.as_deref()
    }
    /// <p>The namespace Amazon Resource Name (ARN) of the cluster.</p>
    pub fn cluster_namespace_arn(&self) -> std::option::Option<&str> {
        self.cluster_namespace_arn.as_deref()
    }
    /// <p>The total storage capacity of the cluster in megabytes. </p>
    pub fn total_storage_capacity_in_mega_bytes(&self) -> std::option::Option<i64> {
        self.total_storage_capacity_in_mega_bytes
    }
    /// <p>The AQUA (Advanced Query Accelerator) configuration of the cluster.</p>
    pub fn aqua_configuration(&self) -> std::option::Option<&crate::model::AquaConfiguration> {
        self.aqua_configuration.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) for the IAM role set as default for the cluster.</p>
    pub fn default_iam_role_arn(&self) -> std::option::Option<&str> {
        self.default_iam_role_arn.as_deref()
    }
    /// <p>The status of the reserved-node exchange request. Statuses include in-progress and requested.</p>
    pub fn reserved_node_exchange_status(
        &self,
    ) -> std::option::Option<&crate::model::ReservedNodeExchangeStatus> {
        self.reserved_node_exchange_status.as_ref()
    }
}
impl std::fmt::Debug for Cluster {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Cluster");
        formatter.field("cluster_identifier", &self.cluster_identifier);
        formatter.field("node_type", &self.node_type);
        formatter.field("cluster_status", &self.cluster_status);
        formatter.field(
            "cluster_availability_status",
            &self.cluster_availability_status,
        );
        formatter.field("modify_status", &self.modify_status);
        formatter.field("master_username", &self.master_username);
        formatter.field("db_name", &self.db_name);
        formatter.field("endpoint", &self.endpoint);
        formatter.field("cluster_create_time", &self.cluster_create_time);
        formatter.field(
            "automated_snapshot_retention_period",
            &self.automated_snapshot_retention_period,
        );
        formatter.field(
            "manual_snapshot_retention_period",
            &self.manual_snapshot_retention_period,
        );
        formatter.field("cluster_security_groups", &self.cluster_security_groups);
        formatter.field("vpc_security_groups", &self.vpc_security_groups);
        formatter.field("cluster_parameter_groups", &self.cluster_parameter_groups);
        formatter.field("cluster_subnet_group_name", &self.cluster_subnet_group_name);
        formatter.field("vpc_id", &self.vpc_id);
        formatter.field("availability_zone", &self.availability_zone);
        formatter.field(
            "preferred_maintenance_window",
            &self.preferred_maintenance_window,
        );
        formatter.field("pending_modified_values", &self.pending_modified_values);
        formatter.field("cluster_version", &self.cluster_version);
        formatter.field("allow_version_upgrade", &self.allow_version_upgrade);
        formatter.field("number_of_nodes", &self.number_of_nodes);
        formatter.field("publicly_accessible", &self.publicly_accessible);
        formatter.field("encrypted", &self.encrypted);
        formatter.field("restore_status", &self.restore_status);
        formatter.field("data_transfer_progress", &self.data_transfer_progress);
        formatter.field("hsm_status", &self.hsm_status);
        formatter.field(
            "cluster_snapshot_copy_status",
            &self.cluster_snapshot_copy_status,
        );
        formatter.field("cluster_public_key", &self.cluster_public_key);
        formatter.field("cluster_nodes", &self.cluster_nodes);
        formatter.field("elastic_ip_status", &self.elastic_ip_status);
        formatter.field("cluster_revision_number", &self.cluster_revision_number);
        formatter.field("tags", &self.tags);
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.field("enhanced_vpc_routing", &self.enhanced_vpc_routing);
        formatter.field("iam_roles", &self.iam_roles);
        formatter.field("pending_actions", &self.pending_actions);
        formatter.field("maintenance_track_name", &self.maintenance_track_name);
        formatter.field(
            "elastic_resize_number_of_node_options",
            &self.elastic_resize_number_of_node_options,
        );
        formatter.field(
            "deferred_maintenance_windows",
            &self.deferred_maintenance_windows,
        );
        formatter.field(
            "snapshot_schedule_identifier",
            &self.snapshot_schedule_identifier,
        );
        formatter.field("snapshot_schedule_state", &self.snapshot_schedule_state);
        formatter.field(
            "expected_next_snapshot_schedule_time",
            &self.expected_next_snapshot_schedule_time,
        );
        formatter.field(
            "expected_next_snapshot_schedule_time_status",
            &self.expected_next_snapshot_schedule_time_status,
        );
        formatter.field(
            "next_maintenance_window_start_time",
            &self.next_maintenance_window_start_time,
        );
        formatter.field("resize_info", &self.resize_info);
        formatter.field(
            "availability_zone_relocation_status",
            &self.availability_zone_relocation_status,
        );
        formatter.field("cluster_namespace_arn", &self.cluster_namespace_arn);
        formatter.field(
            "total_storage_capacity_in_mega_bytes",
            &self.total_storage_capacity_in_mega_bytes,
        );
        formatter.field("aqua_configuration", &self.aqua_configuration);
        formatter.field("default_iam_role_arn", &self.default_iam_role_arn);
        formatter.field(
            "reserved_node_exchange_status",
            &self.reserved_node_exchange_status,
        );
        formatter.finish()
    }
}
/// See [`Cluster`](crate::model::Cluster)
pub mod cluster {
    /// A builder for [`Cluster`](crate::model::Cluster)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) node_type: std::option::Option<std::string::String>,
        pub(crate) cluster_status: std::option::Option<std::string::String>,
        pub(crate) cluster_availability_status: std::option::Option<std::string::String>,
        pub(crate) modify_status: std::option::Option<std::string::String>,
        pub(crate) master_username: std::option::Option<std::string::String>,
        pub(crate) db_name: std::option::Option<std::string::String>,
        pub(crate) endpoint: std::option::Option<crate::model::Endpoint>,
        pub(crate) cluster_create_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) automated_snapshot_retention_period: std::option::Option<i32>,
        pub(crate) manual_snapshot_retention_period: std::option::Option<i32>,
        pub(crate) cluster_security_groups:
            std::option::Option<std::vec::Vec<crate::model::ClusterSecurityGroupMembership>>,
        pub(crate) vpc_security_groups:
            std::option::Option<std::vec::Vec<crate::model::VpcSecurityGroupMembership>>,
        pub(crate) cluster_parameter_groups:
            std::option::Option<std::vec::Vec<crate::model::ClusterParameterGroupStatus>>,
        pub(crate) cluster_subnet_group_name: std::option::Option<std::string::String>,
        pub(crate) vpc_id: std::option::Option<std::string::String>,
        pub(crate) availability_zone: std::option::Option<std::string::String>,
        pub(crate) preferred_maintenance_window: std::option::Option<std::string::String>,
        pub(crate) pending_modified_values:
            std::option::Option<crate::model::PendingModifiedValues>,
        pub(crate) cluster_version: std::option::Option<std::string::String>,
        pub(crate) allow_version_upgrade: std::option::Option<bool>,
        pub(crate) number_of_nodes: std::option::Option<i32>,
        pub(crate) publicly_accessible: std::option::Option<bool>,
        pub(crate) encrypted: std::option::Option<bool>,
        pub(crate) restore_status: std::option::Option<crate::model::RestoreStatus>,
        pub(crate) data_transfer_progress: std::option::Option<crate::model::DataTransferProgress>,
        pub(crate) hsm_status: std::option::Option<crate::model::HsmStatus>,
        pub(crate) cluster_snapshot_copy_status:
            std::option::Option<crate::model::ClusterSnapshotCopyStatus>,
        pub(crate) cluster_public_key: std::option::Option<std::string::String>,
        pub(crate) cluster_nodes: std::option::Option<std::vec::Vec<crate::model::ClusterNode>>,
        pub(crate) elastic_ip_status: std::option::Option<crate::model::ElasticIpStatus>,
        pub(crate) cluster_revision_number: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
        pub(crate) enhanced_vpc_routing: std::option::Option<bool>,
        pub(crate) iam_roles: std::option::Option<std::vec::Vec<crate::model::ClusterIamRole>>,
        pub(crate) pending_actions: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) maintenance_track_name: std::option::Option<std::string::String>,
        pub(crate) elastic_resize_number_of_node_options: std::option::Option<std::string::String>,
        pub(crate) deferred_maintenance_windows:
            std::option::Option<std::vec::Vec<crate::model::DeferredMaintenanceWindow>>,
        pub(crate) snapshot_schedule_identifier: std::option::Option<std::string::String>,
        pub(crate) snapshot_schedule_state: std::option::Option<crate::model::ScheduleState>,
        pub(crate) expected_next_snapshot_schedule_time:
            std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) expected_next_snapshot_schedule_time_status:
            std::option::Option<std::string::String>,
        pub(crate) next_maintenance_window_start_time:
            std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) resize_info: std::option::Option<crate::model::ResizeInfo>,
        pub(crate) availability_zone_relocation_status: std::option::Option<std::string::String>,
        pub(crate) cluster_namespace_arn: std::option::Option<std::string::String>,
        pub(crate) total_storage_capacity_in_mega_bytes: std::option::Option<i64>,
        pub(crate) aqua_configuration: std::option::Option<crate::model::AquaConfiguration>,
        pub(crate) default_iam_role_arn: std::option::Option<std::string::String>,
        pub(crate) reserved_node_exchange_status:
            std::option::Option<crate::model::ReservedNodeExchangeStatus>,
    }
    impl Builder {
        /// <p>The unique identifier of the cluster.</p>
        pub fn cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_identifier = Some(input.into());
            self
        }
        /// <p>The unique identifier of the cluster.</p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cluster_identifier = input;
            self
        }
        /// <p>The node type for the nodes in the cluster.</p>
        pub fn node_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.node_type = Some(input.into());
            self
        }
        /// <p>The node type for the nodes in the cluster.</p>
        pub fn set_node_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.node_type = input;
            self
        }
        /// <p> The current state of the cluster. Possible values are the following:</p>
        /// <ul>
        /// <li> <p> <code>available</code> </p> </li>
        /// <li> <p> <code>available, prep-for-resize</code> </p> </li>
        /// <li> <p> <code>available, resize-cleanup</code> </p> </li>
        /// <li> <p> <code>cancelling-resize</code> </p> </li>
        /// <li> <p> <code>creating</code> </p> </li>
        /// <li> <p> <code>deleting</code> </p> </li>
        /// <li> <p> <code>final-snapshot</code> </p> </li>
        /// <li> <p> <code>hardware-failure</code> </p> </li>
        /// <li> <p> <code>incompatible-hsm</code> </p> </li>
        /// <li> <p> <code>incompatible-network</code> </p> </li>
        /// <li> <p> <code>incompatible-parameters</code> </p> </li>
        /// <li> <p> <code>incompatible-restore</code> </p> </li>
        /// <li> <p> <code>modifying</code> </p> </li>
        /// <li> <p> <code>paused</code> </p> </li>
        /// <li> <p> <code>rebooting</code> </p> </li>
        /// <li> <p> <code>renaming</code> </p> </li>
        /// <li> <p> <code>resizing</code> </p> </li>
        /// <li> <p> <code>rotating-keys</code> </p> </li>
        /// <li> <p> <code>storage-full</code> </p> </li>
        /// <li> <p> <code>updating-hsm</code> </p> </li>
        /// </ul>
        pub fn cluster_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_status = Some(input.into());
            self
        }
        /// <p> The current state of the cluster. Possible values are the following:</p>
        /// <ul>
        /// <li> <p> <code>available</code> </p> </li>
        /// <li> <p> <code>available, prep-for-resize</code> </p> </li>
        /// <li> <p> <code>available, resize-cleanup</code> </p> </li>
        /// <li> <p> <code>cancelling-resize</code> </p> </li>
        /// <li> <p> <code>creating</code> </p> </li>
        /// <li> <p> <code>deleting</code> </p> </li>
        /// <li> <p> <code>final-snapshot</code> </p> </li>
        /// <li> <p> <code>hardware-failure</code> </p> </li>
        /// <li> <p> <code>incompatible-hsm</code> </p> </li>
        /// <li> <p> <code>incompatible-network</code> </p> </li>
        /// <li> <p> <code>incompatible-parameters</code> </p> </li>
        /// <li> <p> <code>incompatible-restore</code> </p> </li>
        /// <li> <p> <code>modifying</code> </p> </li>
        /// <li> <p> <code>paused</code> </p> </li>
        /// <li> <p> <code>rebooting</code> </p> </li>
        /// <li> <p> <code>renaming</code> </p> </li>
        /// <li> <p> <code>resizing</code> </p> </li>
        /// <li> <p> <code>rotating-keys</code> </p> </li>
        /// <li> <p> <code>storage-full</code> </p> </li>
        /// <li> <p> <code>updating-hsm</code> </p> </li>
        /// </ul>
        pub fn set_cluster_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cluster_status = input;
            self
        }
        /// <p>The availability status of the cluster for queries. Possible values are the following:</p>
        /// <ul>
        /// <li> <p>Available - The cluster is available for queries. </p> </li>
        /// <li> <p>Unavailable - The cluster is not available for queries.</p> </li>
        /// <li> <p>Maintenance - The cluster is intermittently available for queries due to maintenance activities.</p> </li>
        /// <li> <p>Modifying - The cluster is intermittently available for queries due to changes that modify the cluster.</p> </li>
        /// <li> <p>Failed - The cluster failed and is not available for queries.</p> </li>
        /// </ul>
        pub fn cluster_availability_status(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.cluster_availability_status = Some(input.into());
            self
        }
        /// <p>The availability status of the cluster for queries. Possible values are the following:</p>
        /// <ul>
        /// <li> <p>Available - The cluster is available for queries. </p> </li>
        /// <li> <p>Unavailable - The cluster is not available for queries.</p> </li>
        /// <li> <p>Maintenance - The cluster is intermittently available for queries due to maintenance activities.</p> </li>
        /// <li> <p>Modifying - The cluster is intermittently available for queries due to changes that modify the cluster.</p> </li>
        /// <li> <p>Failed - The cluster failed and is not available for queries.</p> </li>
        /// </ul>
        pub fn set_cluster_availability_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cluster_availability_status = input;
            self
        }
        /// <p>The status of a modify operation, if any, initiated for the cluster.</p>
        pub fn modify_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.modify_status = Some(input.into());
            self
        }
        /// <p>The status of a modify operation, if any, initiated for the cluster.</p>
        pub fn set_modify_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.modify_status = input;
            self
        }
        /// <p>The admin user name for the cluster. This name is used to connect to the database that is specified in the <b>DBName</b> parameter. </p>
        pub fn master_username(mut self, input: impl Into<std::string::String>) -> Self {
            self.master_username = Some(input.into());
            self
        }
        /// <p>The admin user name for the cluster. This name is used to connect to the database that is specified in the <b>DBName</b> parameter. </p>
        pub fn set_master_username(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.master_username = input;
            self
        }
        /// <p>The name of the initial database that was created when the cluster was created. This same name is returned for the life of the cluster. If an initial database was not specified, a database named <code>dev</code>dev was created by default. </p>
        pub fn db_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_name = Some(input.into());
            self
        }
        /// <p>The name of the initial database that was created when the cluster was created. This same name is returned for the life of the cluster. If an initial database was not specified, a database named <code>dev</code>dev was created by default. </p>
        pub fn set_db_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.db_name = input;
            self
        }
        /// <p>The connection endpoint.</p>
        pub fn endpoint(mut self, input: crate::model::Endpoint) -> Self {
            self.endpoint = Some(input);
            self
        }
        /// <p>The connection endpoint.</p>
        pub fn set_endpoint(mut self, input: std::option::Option<crate::model::Endpoint>) -> Self {
            self.endpoint = input;
            self
        }
        /// <p>The date and time that the cluster was created.</p>
        pub fn cluster_create_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.cluster_create_time = Some(input);
            self
        }
        /// <p>The date and time that the cluster was created.</p>
        pub fn set_cluster_create_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.cluster_create_time = input;
            self
        }
        /// <p>The number of days that automatic cluster snapshots are retained.</p>
        pub fn automated_snapshot_retention_period(mut self, input: i32) -> Self {
            self.automated_snapshot_retention_period = Some(input);
            self
        }
        /// <p>The number of days that automatic cluster snapshots are retained.</p>
        pub fn set_automated_snapshot_retention_period(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.automated_snapshot_retention_period = input;
            self
        }
        /// <p>The default number of days to retain a manual snapshot. If the value is -1, the snapshot is retained indefinitely. This setting doesn't change the retention period of existing snapshots.</p>
        /// <p>The value must be either -1 or an integer between 1 and 3,653.</p>
        pub fn manual_snapshot_retention_period(mut self, input: i32) -> Self {
            self.manual_snapshot_retention_period = Some(input);
            self
        }
        /// <p>The default number of days to retain a manual snapshot. If the value is -1, the snapshot is retained indefinitely. This setting doesn't change the retention period of existing snapshots.</p>
        /// <p>The value must be either -1 or an integer between 1 and 3,653.</p>
        pub fn set_manual_snapshot_retention_period(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.manual_snapshot_retention_period = input;
            self
        }
        /// Appends an item to `cluster_security_groups`.
        ///
        /// To override the contents of this collection use [`set_cluster_security_groups`](Self::set_cluster_security_groups).
        ///
        /// <p>A list of cluster security group that are associated with the cluster. Each security group is represented by an element that contains <code>ClusterSecurityGroup.Name</code> and <code>ClusterSecurityGroup.Status</code> subelements. </p>
        /// <p>Cluster security groups are used when the cluster is not created in an Amazon Virtual Private Cloud (VPC). Clusters that are created in a VPC use VPC security groups, which are listed by the <b>VpcSecurityGroups</b> parameter. </p>
        pub fn cluster_security_groups(
            mut self,
            input: crate::model::ClusterSecurityGroupMembership,
        ) -> Self {
            let mut v = self.cluster_security_groups.unwrap_or_default();
            v.push(input);
            self.cluster_security_groups = Some(v);
            self
        }
        /// <p>A list of cluster security group that are associated with the cluster. Each security group is represented by an element that contains <code>ClusterSecurityGroup.Name</code> and <code>ClusterSecurityGroup.Status</code> subelements. </p>
        /// <p>Cluster security groups are used when the cluster is not created in an Amazon Virtual Private Cloud (VPC). Clusters that are created in a VPC use VPC security groups, which are listed by the <b>VpcSecurityGroups</b> parameter. </p>
        pub fn set_cluster_security_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ClusterSecurityGroupMembership>>,
        ) -> Self {
            self.cluster_security_groups = input;
            self
        }
        /// Appends an item to `vpc_security_groups`.
        ///
        /// To override the contents of this collection use [`set_vpc_security_groups`](Self::set_vpc_security_groups).
        ///
        /// <p>A list of Amazon Virtual Private Cloud (Amazon VPC) security groups that are associated with the cluster. This parameter is returned only if the cluster is in a VPC.</p>
        pub fn vpc_security_groups(
            mut self,
            input: crate::model::VpcSecurityGroupMembership,
        ) -> Self {
            let mut v = self.vpc_security_groups.unwrap_or_default();
            v.push(input);
            self.vpc_security_groups = Some(v);
            self
        }
        /// <p>A list of Amazon Virtual Private Cloud (Amazon VPC) security groups that are associated with the cluster. This parameter is returned only if the cluster is in a VPC.</p>
        pub fn set_vpc_security_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::VpcSecurityGroupMembership>>,
        ) -> Self {
            self.vpc_security_groups = input;
            self
        }
        /// Appends an item to `cluster_parameter_groups`.
        ///
        /// To override the contents of this collection use [`set_cluster_parameter_groups`](Self::set_cluster_parameter_groups).
        ///
        /// <p>The list of cluster parameter groups that are associated with this cluster. Each parameter group in the list is returned with its status.</p>
        pub fn cluster_parameter_groups(
            mut self,
            input: crate::model::ClusterParameterGroupStatus,
        ) -> Self {
            let mut v = self.cluster_parameter_groups.unwrap_or_default();
            v.push(input);
            self.cluster_parameter_groups = Some(v);
            self
        }
        /// <p>The list of cluster parameter groups that are associated with this cluster. Each parameter group in the list is returned with its status.</p>
        pub fn set_cluster_parameter_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ClusterParameterGroupStatus>>,
        ) -> Self {
            self.cluster_parameter_groups = input;
            self
        }
        /// <p>The name of the subnet group that is associated with the cluster. This parameter is valid only when the cluster is in a VPC.</p>
        pub fn cluster_subnet_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_subnet_group_name = Some(input.into());
            self
        }
        /// <p>The name of the subnet group that is associated with the cluster. This parameter is valid only when the cluster is in a VPC.</p>
        pub fn set_cluster_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cluster_subnet_group_name = input;
            self
        }
        /// <p>The identifier of the VPC the cluster is in, if the cluster is in a VPC.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_id = Some(input.into());
            self
        }
        /// <p>The identifier of the VPC the cluster is in, if the cluster is in a VPC.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_id = input;
            self
        }
        /// <p>The name of the Availability Zone in which the cluster is located.</p>
        pub fn availability_zone(mut self, input: impl Into<std::string::String>) -> Self {
            self.availability_zone = Some(input.into());
            self
        }
        /// <p>The name of the Availability Zone in which the cluster is located.</p>
        pub fn set_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.availability_zone = input;
            self
        }
        /// <p>The weekly time range, in Universal Coordinated Time (UTC), during which system maintenance can occur.</p>
        pub fn preferred_maintenance_window(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.preferred_maintenance_window = Some(input.into());
            self
        }
        /// <p>The weekly time range, in Universal Coordinated Time (UTC), during which system maintenance can occur.</p>
        pub fn set_preferred_maintenance_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.preferred_maintenance_window = input;
            self
        }
        /// <p>A value that, if present, indicates that changes to the cluster are pending. Specific pending changes are identified by subelements.</p>
        pub fn pending_modified_values(
            mut self,
            input: crate::model::PendingModifiedValues,
        ) -> Self {
            self.pending_modified_values = Some(input);
            self
        }
        /// <p>A value that, if present, indicates that changes to the cluster are pending. Specific pending changes are identified by subelements.</p>
        pub fn set_pending_modified_values(
            mut self,
            input: std::option::Option<crate::model::PendingModifiedValues>,
        ) -> Self {
            self.pending_modified_values = input;
            self
        }
        /// <p>The version ID of the Amazon Redshift engine that is running on the cluster.</p>
        pub fn cluster_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_version = Some(input.into());
            self
        }
        /// <p>The version ID of the Amazon Redshift engine that is running on the cluster.</p>
        pub fn set_cluster_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cluster_version = input;
            self
        }
        /// <p>A boolean value that, if <code>true</code>, indicates that major version upgrades will be applied automatically to the cluster during the maintenance window. </p>
        pub fn allow_version_upgrade(mut self, input: bool) -> Self {
            self.allow_version_upgrade = Some(input);
            self
        }
        /// <p>A boolean value that, if <code>true</code>, indicates that major version upgrades will be applied automatically to the cluster during the maintenance window. </p>
        pub fn set_allow_version_upgrade(mut self, input: std::option::Option<bool>) -> Self {
            self.allow_version_upgrade = input;
            self
        }
        /// <p>The number of compute nodes in the cluster.</p>
        pub fn number_of_nodes(mut self, input: i32) -> Self {
            self.number_of_nodes = Some(input);
            self
        }
        /// <p>The number of compute nodes in the cluster.</p>
        pub fn set_number_of_nodes(mut self, input: std::option::Option<i32>) -> Self {
            self.number_of_nodes = input;
            self
        }
        /// <p>A boolean value that, if <code>true</code>, indicates that the cluster can be accessed from a public network.</p>
        pub fn publicly_accessible(mut self, input: bool) -> Self {
            self.publicly_accessible = Some(input);
            self
        }
        /// <p>A boolean value that, if <code>true</code>, indicates that the cluster can be accessed from a public network.</p>
        pub fn set_publicly_accessible(mut self, input: std::option::Option<bool>) -> Self {
            self.publicly_accessible = input;
            self
        }
        /// <p>A boolean value that, if <code>true</code>, indicates that data in the cluster is encrypted at rest.</p>
        pub fn encrypted(mut self, input: bool) -> Self {
            self.encrypted = Some(input);
            self
        }
        /// <p>A boolean value that, if <code>true</code>, indicates that data in the cluster is encrypted at rest.</p>
        pub fn set_encrypted(mut self, input: std::option::Option<bool>) -> Self {
            self.encrypted = input;
            self
        }
        /// <p>A value that describes the status of a cluster restore action. This parameter returns null if the cluster was not created by restoring a snapshot.</p>
        pub fn restore_status(mut self, input: crate::model::RestoreStatus) -> Self {
            self.restore_status = Some(input);
            self
        }
        /// <p>A value that describes the status of a cluster restore action. This parameter returns null if the cluster was not created by restoring a snapshot.</p>
        pub fn set_restore_status(
            mut self,
            input: std::option::Option<crate::model::RestoreStatus>,
        ) -> Self {
            self.restore_status = input;
            self
        }
        /// <p></p>
        pub fn data_transfer_progress(mut self, input: crate::model::DataTransferProgress) -> Self {
            self.data_transfer_progress = Some(input);
            self
        }
        /// <p></p>
        pub fn set_data_transfer_progress(
            mut self,
            input: std::option::Option<crate::model::DataTransferProgress>,
        ) -> Self {
            self.data_transfer_progress = input;
            self
        }
        /// <p>A value that reports whether the Amazon Redshift cluster has finished applying any hardware security module (HSM) settings changes specified in a modify cluster command.</p>
        /// <p>Values: active, applying</p>
        pub fn hsm_status(mut self, input: crate::model::HsmStatus) -> Self {
            self.hsm_status = Some(input);
            self
        }
        /// <p>A value that reports whether the Amazon Redshift cluster has finished applying any hardware security module (HSM) settings changes specified in a modify cluster command.</p>
        /// <p>Values: active, applying</p>
        pub fn set_hsm_status(
            mut self,
            input: std::option::Option<crate::model::HsmStatus>,
        ) -> Self {
            self.hsm_status = input;
            self
        }
        /// <p>A value that returns the destination region and retention period that are configured for cross-region snapshot copy.</p>
        pub fn cluster_snapshot_copy_status(
            mut self,
            input: crate::model::ClusterSnapshotCopyStatus,
        ) -> Self {
            self.cluster_snapshot_copy_status = Some(input);
            self
        }
        /// <p>A value that returns the destination region and retention period that are configured for cross-region snapshot copy.</p>
        pub fn set_cluster_snapshot_copy_status(
            mut self,
            input: std::option::Option<crate::model::ClusterSnapshotCopyStatus>,
        ) -> Self {
            self.cluster_snapshot_copy_status = input;
            self
        }
        /// <p>The public key for the cluster.</p>
        pub fn cluster_public_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_public_key = Some(input.into());
            self
        }
        /// <p>The public key for the cluster.</p>
        pub fn set_cluster_public_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cluster_public_key = input;
            self
        }
        /// Appends an item to `cluster_nodes`.
        ///
        /// To override the contents of this collection use [`set_cluster_nodes`](Self::set_cluster_nodes).
        ///
        /// <p>The nodes in the cluster.</p>
        pub fn cluster_nodes(mut self, input: crate::model::ClusterNode) -> Self {
            let mut v = self.cluster_nodes.unwrap_or_default();
            v.push(input);
            self.cluster_nodes = Some(v);
            self
        }
        /// <p>The nodes in the cluster.</p>
        pub fn set_cluster_nodes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ClusterNode>>,
        ) -> Self {
            self.cluster_nodes = input;
            self
        }
        /// <p>The status of the elastic IP (EIP) address.</p>
        pub fn elastic_ip_status(mut self, input: crate::model::ElasticIpStatus) -> Self {
            self.elastic_ip_status = Some(input);
            self
        }
        /// <p>The status of the elastic IP (EIP) address.</p>
        pub fn set_elastic_ip_status(
            mut self,
            input: std::option::Option<crate::model::ElasticIpStatus>,
        ) -> Self {
            self.elastic_ip_status = input;
            self
        }
        /// <p>The specific revision number of the database in the cluster.</p>
        pub fn cluster_revision_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_revision_number = Some(input.into());
            self
        }
        /// <p>The specific revision number of the database in the cluster.</p>
        pub fn set_cluster_revision_number(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cluster_revision_number = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The list of tags for the cluster.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The list of tags for the cluster.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The Key Management Service (KMS) key ID of the encryption key used to encrypt data in the cluster.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>The Key Management Service (KMS) key ID of the encryption key used to encrypt data in the cluster.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// <p>An option that specifies whether to create the cluster with enhanced VPC routing enabled. To create a cluster that uses enhanced VPC routing, the cluster must be in a VPC. For more information, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html">Enhanced VPC Routing</a> in the Amazon Redshift Cluster Management Guide.</p>
        /// <p>If this option is <code>true</code>, enhanced VPC routing is enabled. </p>
        /// <p>Default: false</p>
        pub fn enhanced_vpc_routing(mut self, input: bool) -> Self {
            self.enhanced_vpc_routing = Some(input);
            self
        }
        /// <p>An option that specifies whether to create the cluster with enhanced VPC routing enabled. To create a cluster that uses enhanced VPC routing, the cluster must be in a VPC. For more information, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html">Enhanced VPC Routing</a> in the Amazon Redshift Cluster Management Guide.</p>
        /// <p>If this option is <code>true</code>, enhanced VPC routing is enabled. </p>
        /// <p>Default: false</p>
        pub fn set_enhanced_vpc_routing(mut self, input: std::option::Option<bool>) -> Self {
            self.enhanced_vpc_routing = input;
            self
        }
        /// Appends an item to `iam_roles`.
        ///
        /// To override the contents of this collection use [`set_iam_roles`](Self::set_iam_roles).
        ///
        /// <p>A list of Identity and Access Management (IAM) roles that can be used by the cluster to access other Amazon Web Services services.</p>
        pub fn iam_roles(mut self, input: crate::model::ClusterIamRole) -> Self {
            let mut v = self.iam_roles.unwrap_or_default();
            v.push(input);
            self.iam_roles = Some(v);
            self
        }
        /// <p>A list of Identity and Access Management (IAM) roles that can be used by the cluster to access other Amazon Web Services services.</p>
        pub fn set_iam_roles(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ClusterIamRole>>,
        ) -> Self {
            self.iam_roles = input;
            self
        }
        /// Appends an item to `pending_actions`.
        ///
        /// To override the contents of this collection use [`set_pending_actions`](Self::set_pending_actions).
        ///
        /// <p>Cluster operations that are waiting to be started.</p>
        pub fn pending_actions(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.pending_actions.unwrap_or_default();
            v.push(input.into());
            self.pending_actions = Some(v);
            self
        }
        /// <p>Cluster operations that are waiting to be started.</p>
        pub fn set_pending_actions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.pending_actions = input;
            self
        }
        /// <p>The name of the maintenance track for the cluster.</p>
        pub fn maintenance_track_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.maintenance_track_name = Some(input.into());
            self
        }
        /// <p>The name of the maintenance track for the cluster.</p>
        pub fn set_maintenance_track_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.maintenance_track_name = input;
            self
        }
        /// <p>The number of nodes that you can resize the cluster to with the elastic resize method. </p>
        pub fn elastic_resize_number_of_node_options(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.elastic_resize_number_of_node_options = Some(input.into());
            self
        }
        /// <p>The number of nodes that you can resize the cluster to with the elastic resize method. </p>
        pub fn set_elastic_resize_number_of_node_options(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.elastic_resize_number_of_node_options = input;
            self
        }
        /// Appends an item to `deferred_maintenance_windows`.
        ///
        /// To override the contents of this collection use [`set_deferred_maintenance_windows`](Self::set_deferred_maintenance_windows).
        ///
        /// <p>Describes a group of <code>DeferredMaintenanceWindow</code> objects.</p>
        pub fn deferred_maintenance_windows(
            mut self,
            input: crate::model::DeferredMaintenanceWindow,
        ) -> Self {
            let mut v = self.deferred_maintenance_windows.unwrap_or_default();
            v.push(input);
            self.deferred_maintenance_windows = Some(v);
            self
        }
        /// <p>Describes a group of <code>DeferredMaintenanceWindow</code> objects.</p>
        pub fn set_deferred_maintenance_windows(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DeferredMaintenanceWindow>>,
        ) -> Self {
            self.deferred_maintenance_windows = input;
            self
        }
        /// <p>A unique identifier for the cluster snapshot schedule.</p>
        pub fn snapshot_schedule_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.snapshot_schedule_identifier = Some(input.into());
            self
        }
        /// <p>A unique identifier for the cluster snapshot schedule.</p>
        pub fn set_snapshot_schedule_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.snapshot_schedule_identifier = input;
            self
        }
        /// <p>The current state of the cluster snapshot schedule.</p>
        pub fn snapshot_schedule_state(mut self, input: crate::model::ScheduleState) -> Self {
            self.snapshot_schedule_state = Some(input);
            self
        }
        /// <p>The current state of the cluster snapshot schedule.</p>
        pub fn set_snapshot_schedule_state(
            mut self,
            input: std::option::Option<crate::model::ScheduleState>,
        ) -> Self {
            self.snapshot_schedule_state = input;
            self
        }
        /// <p>The date and time when the next snapshot is expected to be taken for clusters with a valid snapshot schedule and backups enabled. </p>
        pub fn expected_next_snapshot_schedule_time(
            mut self,
            input: aws_smithy_types::DateTime,
        ) -> Self {
            self.expected_next_snapshot_schedule_time = Some(input);
            self
        }
        /// <p>The date and time when the next snapshot is expected to be taken for clusters with a valid snapshot schedule and backups enabled. </p>
        pub fn set_expected_next_snapshot_schedule_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.expected_next_snapshot_schedule_time = input;
            self
        }
        /// <p> The status of next expected snapshot for clusters having a valid snapshot schedule and backups enabled. Possible values are the following:</p>
        /// <ul>
        /// <li> <p>OnTrack - The next snapshot is expected to be taken on time. </p> </li>
        /// <li> <p>Pending - The next snapshot is pending to be taken. </p> </li>
        /// </ul>
        pub fn expected_next_snapshot_schedule_time_status(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.expected_next_snapshot_schedule_time_status = Some(input.into());
            self
        }
        /// <p> The status of next expected snapshot for clusters having a valid snapshot schedule and backups enabled. Possible values are the following:</p>
        /// <ul>
        /// <li> <p>OnTrack - The next snapshot is expected to be taken on time. </p> </li>
        /// <li> <p>Pending - The next snapshot is pending to be taken. </p> </li>
        /// </ul>
        pub fn set_expected_next_snapshot_schedule_time_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.expected_next_snapshot_schedule_time_status = input;
            self
        }
        /// <p>The date and time in UTC when system maintenance can begin.</p>
        pub fn next_maintenance_window_start_time(
            mut self,
            input: aws_smithy_types::DateTime,
        ) -> Self {
            self.next_maintenance_window_start_time = Some(input);
            self
        }
        /// <p>The date and time in UTC when system maintenance can begin.</p>
        pub fn set_next_maintenance_window_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.next_maintenance_window_start_time = input;
            self
        }
        /// <p>Returns the following:</p>
        /// <ul>
        /// <li> <p>AllowCancelResize: a boolean value indicating if the resize operation can be cancelled.</p> </li>
        /// <li> <p>ResizeType: Returns ClassicResize</p> </li>
        /// </ul>
        pub fn resize_info(mut self, input: crate::model::ResizeInfo) -> Self {
            self.resize_info = Some(input);
            self
        }
        /// <p>Returns the following:</p>
        /// <ul>
        /// <li> <p>AllowCancelResize: a boolean value indicating if the resize operation can be cancelled.</p> </li>
        /// <li> <p>ResizeType: Returns ClassicResize</p> </li>
        /// </ul>
        pub fn set_resize_info(
            mut self,
            input: std::option::Option<crate::model::ResizeInfo>,
        ) -> Self {
            self.resize_info = input;
            self
        }
        /// <p>Describes the status of the Availability Zone relocation operation.</p>
        pub fn availability_zone_relocation_status(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.availability_zone_relocation_status = Some(input.into());
            self
        }
        /// <p>Describes the status of the Availability Zone relocation operation.</p>
        pub fn set_availability_zone_relocation_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.availability_zone_relocation_status = input;
            self
        }
        /// <p>The namespace Amazon Resource Name (ARN) of the cluster.</p>
        pub fn cluster_namespace_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_namespace_arn = Some(input.into());
            self
        }
        /// <p>The namespace Amazon Resource Name (ARN) of the cluster.</p>
        pub fn set_cluster_namespace_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cluster_namespace_arn = input;
            self
        }
        /// <p>The total storage capacity of the cluster in megabytes. </p>
        pub fn total_storage_capacity_in_mega_bytes(mut self, input: i64) -> Self {
            self.total_storage_capacity_in_mega_bytes = Some(input);
            self
        }
        /// <p>The total storage capacity of the cluster in megabytes. </p>
        pub fn set_total_storage_capacity_in_mega_bytes(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.total_storage_capacity_in_mega_bytes = input;
            self
        }
        /// <p>The AQUA (Advanced Query Accelerator) configuration of the cluster.</p>
        pub fn aqua_configuration(mut self, input: crate::model::AquaConfiguration) -> Self {
            self.aqua_configuration = Some(input);
            self
        }
        /// <p>The AQUA (Advanced Query Accelerator) configuration of the cluster.</p>
        pub fn set_aqua_configuration(
            mut self,
            input: std::option::Option<crate::model::AquaConfiguration>,
        ) -> Self {
            self.aqua_configuration = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the IAM role set as default for the cluster.</p>
        pub fn default_iam_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_iam_role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the IAM role set as default for the cluster.</p>
        pub fn set_default_iam_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_iam_role_arn = input;
            self
        }
        /// <p>The status of the reserved-node exchange request. Statuses include in-progress and requested.</p>
        pub fn reserved_node_exchange_status(
            mut self,
            input: crate::model::ReservedNodeExchangeStatus,
        ) -> Self {
            self.reserved_node_exchange_status = Some(input);
            self
        }
        /// <p>The status of the reserved-node exchange request. Statuses include in-progress and requested.</p>
        pub fn set_reserved_node_exchange_status(
            mut self,
            input: std::option::Option<crate::model::ReservedNodeExchangeStatus>,
        ) -> Self {
            self.reserved_node_exchange_status = input;
            self
        }
        /// Consumes the builder and constructs a [`Cluster`](crate::model::Cluster)
        pub fn build(self) -> crate::model::Cluster {
            crate::model::Cluster {
                cluster_identifier: self.cluster_identifier,
                node_type: self.node_type,
                cluster_status: self.cluster_status,
                cluster_availability_status: self.cluster_availability_status,
                modify_status: self.modify_status,
                master_username: self.master_username,
                db_name: self.db_name,
                endpoint: self.endpoint,
                cluster_create_time: self.cluster_create_time,
                automated_snapshot_retention_period: self
                    .automated_snapshot_retention_period
                    .unwrap_or_default(),
                manual_snapshot_retention_period: self
                    .manual_snapshot_retention_period
                    .unwrap_or_default(),
                cluster_security_groups: self.cluster_security_groups,
                vpc_security_groups: self.vpc_security_groups,
                cluster_parameter_groups: self.cluster_parameter_groups,
                cluster_subnet_group_name: self.cluster_subnet_group_name,
                vpc_id: self.vpc_id,
                availability_zone: self.availability_zone,
                preferred_maintenance_window: self.preferred_maintenance_window,
                pending_modified_values: self.pending_modified_values,
                cluster_version: self.cluster_version,
                allow_version_upgrade: self.allow_version_upgrade.unwrap_or_default(),
                number_of_nodes: self.number_of_nodes.unwrap_or_default(),
                publicly_accessible: self.publicly_accessible.unwrap_or_default(),
                encrypted: self.encrypted.unwrap_or_default(),
                restore_status: self.restore_status,
                data_transfer_progress: self.data_transfer_progress,
                hsm_status: self.hsm_status,
                cluster_snapshot_copy_status: self.cluster_snapshot_copy_status,
                cluster_public_key: self.cluster_public_key,
                cluster_nodes: self.cluster_nodes,
                elastic_ip_status: self.elastic_ip_status,
                cluster_revision_number: self.cluster_revision_number,
                tags: self.tags,
                kms_key_id: self.kms_key_id,
                enhanced_vpc_routing: self.enhanced_vpc_routing.unwrap_or_default(),
                iam_roles: self.iam_roles,
                pending_actions: self.pending_actions,
                maintenance_track_name: self.maintenance_track_name,
                elastic_resize_number_of_node_options: self.elastic_resize_number_of_node_options,
                deferred_maintenance_windows: self.deferred_maintenance_windows,
                snapshot_schedule_identifier: self.snapshot_schedule_identifier,
                snapshot_schedule_state: self.snapshot_schedule_state,
                expected_next_snapshot_schedule_time: self.expected_next_snapshot_schedule_time,
                expected_next_snapshot_schedule_time_status: self
                    .expected_next_snapshot_schedule_time_status,
                next_maintenance_window_start_time: self.next_maintenance_window_start_time,
                resize_info: self.resize_info,
                availability_zone_relocation_status: self.availability_zone_relocation_status,
                cluster_namespace_arn: self.cluster_namespace_arn,
                total_storage_capacity_in_mega_bytes: self.total_storage_capacity_in_mega_bytes,
                aqua_configuration: self.aqua_configuration,
                default_iam_role_arn: self.default_iam_role_arn,
                reserved_node_exchange_status: self.reserved_node_exchange_status,
            }
        }
    }
}
impl Cluster {
    /// Creates a new builder-style object to manufacture [`Cluster`](crate::model::Cluster)
    pub fn builder() -> crate::model::cluster::Builder {
        crate::model::cluster::Builder::default()
    }
}

/// <p>Reserved-node status details, such as the source reserved-node identifier, the target reserved-node identifier, the node type, the node count, and other details.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReservedNodeExchangeStatus {
    /// <p>The identifier of the reserved-node exchange request.</p>
    pub reserved_node_exchange_request_id: std::option::Option<std::string::String>,
    /// <p>The status of the reserved-node exchange request. Statuses include in-progress and requested.</p>
    pub status: std::option::Option<crate::model::ReservedNodeExchangeStatusType>,
    /// <p>A date and time that indicate when the reserved-node exchange was requested.</p>
    pub request_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The identifier of the source reserved node.</p>
    pub source_reserved_node_id: std::option::Option<std::string::String>,
    /// <p>The source reserved-node type, for example ds2.xlarge.</p>
    pub source_reserved_node_type: std::option::Option<std::string::String>,
    /// <p>The source reserved-node count in the cluster.</p>
    pub source_reserved_node_count: i32,
    /// <p>The identifier of the target reserved node offering.</p>
    pub target_reserved_node_offering_id: std::option::Option<std::string::String>,
    /// <p>The node type of the target reserved node, for example ra3.4xlarge.</p>
    pub target_reserved_node_type: std::option::Option<std::string::String>,
    /// <p>The count of target reserved nodes in the cluster.</p>
    pub target_reserved_node_count: i32,
}
impl ReservedNodeExchangeStatus {
    /// <p>The identifier of the reserved-node exchange request.</p>
    pub fn reserved_node_exchange_request_id(&self) -> std::option::Option<&str> {
        self.reserved_node_exchange_request_id.as_deref()
    }
    /// <p>The status of the reserved-node exchange request. Statuses include in-progress and requested.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::ReservedNodeExchangeStatusType> {
        self.status.as_ref()
    }
    /// <p>A date and time that indicate when the reserved-node exchange was requested.</p>
    pub fn request_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.request_time.as_ref()
    }
    /// <p>The identifier of the source reserved node.</p>
    pub fn source_reserved_node_id(&self) -> std::option::Option<&str> {
        self.source_reserved_node_id.as_deref()
    }
    /// <p>The source reserved-node type, for example ds2.xlarge.</p>
    pub fn source_reserved_node_type(&self) -> std::option::Option<&str> {
        self.source_reserved_node_type.as_deref()
    }
    /// <p>The source reserved-node count in the cluster.</p>
    pub fn source_reserved_node_count(&self) -> i32 {
        self.source_reserved_node_count
    }
    /// <p>The identifier of the target reserved node offering.</p>
    pub fn target_reserved_node_offering_id(&self) -> std::option::Option<&str> {
        self.target_reserved_node_offering_id.as_deref()
    }
    /// <p>The node type of the target reserved node, for example ra3.4xlarge.</p>
    pub fn target_reserved_node_type(&self) -> std::option::Option<&str> {
        self.target_reserved_node_type.as_deref()
    }
    /// <p>The count of target reserved nodes in the cluster.</p>
    pub fn target_reserved_node_count(&self) -> i32 {
        self.target_reserved_node_count
    }
}
impl std::fmt::Debug for ReservedNodeExchangeStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReservedNodeExchangeStatus");
        formatter.field(
            "reserved_node_exchange_request_id",
            &self.reserved_node_exchange_request_id,
        );
        formatter.field("status", &self.status);
        formatter.field("request_time", &self.request_time);
        formatter.field("source_reserved_node_id", &self.source_reserved_node_id);
        formatter.field("source_reserved_node_type", &self.source_reserved_node_type);
        formatter.field(
            "source_reserved_node_count",
            &self.source_reserved_node_count,
        );
        formatter.field(
            "target_reserved_node_offering_id",
            &self.target_reserved_node_offering_id,
        );
        formatter.field("target_reserved_node_type", &self.target_reserved_node_type);
        formatter.field(
            "target_reserved_node_count",
            &self.target_reserved_node_count,
        );
        formatter.finish()
    }
}
/// See [`ReservedNodeExchangeStatus`](crate::model::ReservedNodeExchangeStatus)
pub mod reserved_node_exchange_status {
    /// A builder for [`ReservedNodeExchangeStatus`](crate::model::ReservedNodeExchangeStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) reserved_node_exchange_request_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::ReservedNodeExchangeStatusType>,
        pub(crate) request_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) source_reserved_node_id: std::option::Option<std::string::String>,
        pub(crate) source_reserved_node_type: std::option::Option<std::string::String>,
        pub(crate) source_reserved_node_count: std::option::Option<i32>,
        pub(crate) target_reserved_node_offering_id: std::option::Option<std::string::String>,
        pub(crate) target_reserved_node_type: std::option::Option<std::string::String>,
        pub(crate) target_reserved_node_count: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The identifier of the reserved-node exchange request.</p>
        pub fn reserved_node_exchange_request_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.reserved_node_exchange_request_id = Some(input.into());
            self
        }
        /// <p>The identifier of the reserved-node exchange request.</p>
        pub fn set_reserved_node_exchange_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.reserved_node_exchange_request_id = input;
            self
        }
        /// <p>The status of the reserved-node exchange request. Statuses include in-progress and requested.</p>
        pub fn status(mut self, input: crate::model::ReservedNodeExchangeStatusType) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the reserved-node exchange request. Statuses include in-progress and requested.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ReservedNodeExchangeStatusType>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>A date and time that indicate when the reserved-node exchange was requested.</p>
        pub fn request_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.request_time = Some(input);
            self
        }
        /// <p>A date and time that indicate when the reserved-node exchange was requested.</p>
        pub fn set_request_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.request_time = input;
            self
        }
        /// <p>The identifier of the source reserved node.</p>
        pub fn source_reserved_node_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_reserved_node_id = Some(input.into());
            self
        }
        /// <p>The identifier of the source reserved node.</p>
        pub fn set_source_reserved_node_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_reserved_node_id = input;
            self
        }
        /// <p>The source reserved-node type, for example ds2.xlarge.</p>
        pub fn source_reserved_node_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_reserved_node_type = Some(input.into());
            self
        }
        /// <p>The source reserved-node type, for example ds2.xlarge.</p>
        pub fn set_source_reserved_node_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_reserved_node_type = input;
            self
        }
        /// <p>The source reserved-node count in the cluster.</p>
        pub fn source_reserved_node_count(mut self, input: i32) -> Self {
            self.source_reserved_node_count = Some(input);
            self
        }
        /// <p>The source reserved-node count in the cluster.</p>
        pub fn set_source_reserved_node_count(mut self, input: std::option::Option<i32>) -> Self {
            self.source_reserved_node_count = input;
            self
        }
        /// <p>The identifier of the target reserved node offering.</p>
        pub fn target_reserved_node_offering_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.target_reserved_node_offering_id = Some(input.into());
            self
        }
        /// <p>The identifier of the target reserved node offering.</p>
        pub fn set_target_reserved_node_offering_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_reserved_node_offering_id = input;
            self
        }
        /// <p>The node type of the target reserved node, for example ra3.4xlarge.</p>
        pub fn target_reserved_node_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_reserved_node_type = Some(input.into());
            self
        }
        /// <p>The node type of the target reserved node, for example ra3.4xlarge.</p>
        pub fn set_target_reserved_node_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_reserved_node_type = input;
            self
        }
        /// <p>The count of target reserved nodes in the cluster.</p>
        pub fn target_reserved_node_count(mut self, input: i32) -> Self {
            self.target_reserved_node_count = Some(input);
            self
        }
        /// <p>The count of target reserved nodes in the cluster.</p>
        pub fn set_target_reserved_node_count(mut self, input: std::option::Option<i32>) -> Self {
            self.target_reserved_node_count = input;
            self
        }
        /// Consumes the builder and constructs a [`ReservedNodeExchangeStatus`](crate::model::ReservedNodeExchangeStatus)
        pub fn build(self) -> crate::model::ReservedNodeExchangeStatus {
            crate::model::ReservedNodeExchangeStatus {
                reserved_node_exchange_request_id: self.reserved_node_exchange_request_id,
                status: self.status,
                request_time: self.request_time,
                source_reserved_node_id: self.source_reserved_node_id,
                source_reserved_node_type: self.source_reserved_node_type,
                source_reserved_node_count: self.source_reserved_node_count.unwrap_or_default(),
                target_reserved_node_offering_id: self.target_reserved_node_offering_id,
                target_reserved_node_type: self.target_reserved_node_type,
                target_reserved_node_count: self.target_reserved_node_count.unwrap_or_default(),
            }
        }
    }
}
impl ReservedNodeExchangeStatus {
    /// Creates a new builder-style object to manufacture [`ReservedNodeExchangeStatus`](crate::model::ReservedNodeExchangeStatus)
    pub fn builder() -> crate::model::reserved_node_exchange_status::Builder {
        crate::model::reserved_node_exchange_status::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ReservedNodeExchangeStatusType {
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    Requested,
    #[allow(missing_docs)] // documentation missing in model
    Retrying,
    #[allow(missing_docs)] // documentation missing in model
    Succeeded,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ReservedNodeExchangeStatusType {
    fn from(s: &str) -> Self {
        match s {
            "FAILED" => ReservedNodeExchangeStatusType::Failed,
            "IN_PROGRESS" => ReservedNodeExchangeStatusType::InProgress,
            "PENDING" => ReservedNodeExchangeStatusType::Pending,
            "REQUESTED" => ReservedNodeExchangeStatusType::Requested,
            "RETRYING" => ReservedNodeExchangeStatusType::Retrying,
            "SUCCEEDED" => ReservedNodeExchangeStatusType::Succeeded,
            other => ReservedNodeExchangeStatusType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ReservedNodeExchangeStatusType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ReservedNodeExchangeStatusType::from(s))
    }
}
impl ReservedNodeExchangeStatusType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ReservedNodeExchangeStatusType::Failed => "FAILED",
            ReservedNodeExchangeStatusType::InProgress => "IN_PROGRESS",
            ReservedNodeExchangeStatusType::Pending => "PENDING",
            ReservedNodeExchangeStatusType::Requested => "REQUESTED",
            ReservedNodeExchangeStatusType::Retrying => "RETRYING",
            ReservedNodeExchangeStatusType::Succeeded => "SUCCEEDED",
            ReservedNodeExchangeStatusType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "FAILED",
            "IN_PROGRESS",
            "PENDING",
            "REQUESTED",
            "RETRYING",
            "SUCCEEDED",
        ]
    }
}
impl AsRef<str> for ReservedNodeExchangeStatusType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The AQUA (Advanced Query Accelerator) configuration of the cluster.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AquaConfiguration {
    /// <p>The value indicates the status of AQUA on the cluster. Possible values include the following.</p>
    /// <ul>
    /// <li> <p>enabled - AQUA is enabled.</p> </li>
    /// <li> <p>disabled - AQUA is not enabled. </p> </li>
    /// <li> <p>applying - AQUA status is being applied. </p> </li>
    /// </ul>
    pub aqua_status: std::option::Option<crate::model::AquaStatus>,
    /// <p>The value represents how the cluster is configured to use AQUA. Possible values include the following.</p>
    /// <ul>
    /// <li> <p>enabled - Use AQUA if it is available for the current Amazon Web Services Region and Amazon Redshift node type.</p> </li>
    /// <li> <p>disabled - Don't use AQUA. </p> </li>
    /// <li> <p>auto - Amazon Redshift determines whether to use AQUA.</p> </li>
    /// </ul>
    pub aqua_configuration_status: std::option::Option<crate::model::AquaConfigurationStatus>,
}
impl AquaConfiguration {
    /// <p>The value indicates the status of AQUA on the cluster. Possible values include the following.</p>
    /// <ul>
    /// <li> <p>enabled - AQUA is enabled.</p> </li>
    /// <li> <p>disabled - AQUA is not enabled. </p> </li>
    /// <li> <p>applying - AQUA status is being applied. </p> </li>
    /// </ul>
    pub fn aqua_status(&self) -> std::option::Option<&crate::model::AquaStatus> {
        self.aqua_status.as_ref()
    }
    /// <p>The value represents how the cluster is configured to use AQUA. Possible values include the following.</p>
    /// <ul>
    /// <li> <p>enabled - Use AQUA if it is available for the current Amazon Web Services Region and Amazon Redshift node type.</p> </li>
    /// <li> <p>disabled - Don't use AQUA. </p> </li>
    /// <li> <p>auto - Amazon Redshift determines whether to use AQUA.</p> </li>
    /// </ul>
    pub fn aqua_configuration_status(
        &self,
    ) -> std::option::Option<&crate::model::AquaConfigurationStatus> {
        self.aqua_configuration_status.as_ref()
    }
}
impl std::fmt::Debug for AquaConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AquaConfiguration");
        formatter.field("aqua_status", &self.aqua_status);
        formatter.field("aqua_configuration_status", &self.aqua_configuration_status);
        formatter.finish()
    }
}
/// See [`AquaConfiguration`](crate::model::AquaConfiguration)
pub mod aqua_configuration {
    /// A builder for [`AquaConfiguration`](crate::model::AquaConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aqua_status: std::option::Option<crate::model::AquaStatus>,
        pub(crate) aqua_configuration_status:
            std::option::Option<crate::model::AquaConfigurationStatus>,
    }
    impl Builder {
        /// <p>The value indicates the status of AQUA on the cluster. Possible values include the following.</p>
        /// <ul>
        /// <li> <p>enabled - AQUA is enabled.</p> </li>
        /// <li> <p>disabled - AQUA is not enabled. </p> </li>
        /// <li> <p>applying - AQUA status is being applied. </p> </li>
        /// </ul>
        pub fn aqua_status(mut self, input: crate::model::AquaStatus) -> Self {
            self.aqua_status = Some(input);
            self
        }
        /// <p>The value indicates the status of AQUA on the cluster. Possible values include the following.</p>
        /// <ul>
        /// <li> <p>enabled - AQUA is enabled.</p> </li>
        /// <li> <p>disabled - AQUA is not enabled. </p> </li>
        /// <li> <p>applying - AQUA status is being applied. </p> </li>
        /// </ul>
        pub fn set_aqua_status(
            mut self,
            input: std::option::Option<crate::model::AquaStatus>,
        ) -> Self {
            self.aqua_status = input;
            self
        }
        /// <p>The value represents how the cluster is configured to use AQUA. Possible values include the following.</p>
        /// <ul>
        /// <li> <p>enabled - Use AQUA if it is available for the current Amazon Web Services Region and Amazon Redshift node type.</p> </li>
        /// <li> <p>disabled - Don't use AQUA. </p> </li>
        /// <li> <p>auto - Amazon Redshift determines whether to use AQUA.</p> </li>
        /// </ul>
        pub fn aqua_configuration_status(
            mut self,
            input: crate::model::AquaConfigurationStatus,
        ) -> Self {
            self.aqua_configuration_status = Some(input);
            self
        }
        /// <p>The value represents how the cluster is configured to use AQUA. Possible values include the following.</p>
        /// <ul>
        /// <li> <p>enabled - Use AQUA if it is available for the current Amazon Web Services Region and Amazon Redshift node type.</p> </li>
        /// <li> <p>disabled - Don't use AQUA. </p> </li>
        /// <li> <p>auto - Amazon Redshift determines whether to use AQUA.</p> </li>
        /// </ul>
        pub fn set_aqua_configuration_status(
            mut self,
            input: std::option::Option<crate::model::AquaConfigurationStatus>,
        ) -> Self {
            self.aqua_configuration_status = input;
            self
        }
        /// Consumes the builder and constructs a [`AquaConfiguration`](crate::model::AquaConfiguration)
        pub fn build(self) -> crate::model::AquaConfiguration {
            crate::model::AquaConfiguration {
                aqua_status: self.aqua_status,
                aqua_configuration_status: self.aqua_configuration_status,
            }
        }
    }
}
impl AquaConfiguration {
    /// Creates a new builder-style object to manufacture [`AquaConfiguration`](crate::model::AquaConfiguration)
    pub fn builder() -> crate::model::aqua_configuration::Builder {
        crate::model::aqua_configuration::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AquaConfigurationStatus {
    #[allow(missing_docs)] // documentation missing in model
    Auto,
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AquaConfigurationStatus {
    fn from(s: &str) -> Self {
        match s {
            "auto" => AquaConfigurationStatus::Auto,
            "disabled" => AquaConfigurationStatus::Disabled,
            "enabled" => AquaConfigurationStatus::Enabled,
            other => AquaConfigurationStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AquaConfigurationStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AquaConfigurationStatus::from(s))
    }
}
impl AquaConfigurationStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AquaConfigurationStatus::Auto => "auto",
            AquaConfigurationStatus::Disabled => "disabled",
            AquaConfigurationStatus::Enabled => "enabled",
            AquaConfigurationStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["auto", "disabled", "enabled"]
    }
}
impl AsRef<str> for AquaConfigurationStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AquaStatus {
    #[allow(missing_docs)] // documentation missing in model
    Applying,
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AquaStatus {
    fn from(s: &str) -> Self {
        match s {
            "applying" => AquaStatus::Applying,
            "disabled" => AquaStatus::Disabled,
            "enabled" => AquaStatus::Enabled,
            other => AquaStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AquaStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AquaStatus::from(s))
    }
}
impl AquaStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AquaStatus::Applying => "applying",
            AquaStatus::Disabled => "disabled",
            AquaStatus::Enabled => "enabled",
            AquaStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["applying", "disabled", "enabled"]
    }
}
impl AsRef<str> for AquaStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes a resize operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResizeInfo {
    /// <p>Returns the value <code>ClassicResize</code>.</p>
    pub resize_type: std::option::Option<std::string::String>,
    /// <p>A boolean value indicating if the resize operation can be cancelled.</p>
    pub allow_cancel_resize: bool,
}
impl ResizeInfo {
    /// <p>Returns the value <code>ClassicResize</code>.</p>
    pub fn resize_type(&self) -> std::option::Option<&str> {
        self.resize_type.as_deref()
    }
    /// <p>A boolean value indicating if the resize operation can be cancelled.</p>
    pub fn allow_cancel_resize(&self) -> bool {
        self.allow_cancel_resize
    }
}
impl std::fmt::Debug for ResizeInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResizeInfo");
        formatter.field("resize_type", &self.resize_type);
        formatter.field("allow_cancel_resize", &self.allow_cancel_resize);
        formatter.finish()
    }
}
/// See [`ResizeInfo`](crate::model::ResizeInfo)
pub mod resize_info {
    /// A builder for [`ResizeInfo`](crate::model::ResizeInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resize_type: std::option::Option<std::string::String>,
        pub(crate) allow_cancel_resize: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Returns the value <code>ClassicResize</code>.</p>
        pub fn resize_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resize_type = Some(input.into());
            self
        }
        /// <p>Returns the value <code>ClassicResize</code>.</p>
        pub fn set_resize_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resize_type = input;
            self
        }
        /// <p>A boolean value indicating if the resize operation can be cancelled.</p>
        pub fn allow_cancel_resize(mut self, input: bool) -> Self {
            self.allow_cancel_resize = Some(input);
            self
        }
        /// <p>A boolean value indicating if the resize operation can be cancelled.</p>
        pub fn set_allow_cancel_resize(mut self, input: std::option::Option<bool>) -> Self {
            self.allow_cancel_resize = input;
            self
        }
        /// Consumes the builder and constructs a [`ResizeInfo`](crate::model::ResizeInfo)
        pub fn build(self) -> crate::model::ResizeInfo {
            crate::model::ResizeInfo {
                resize_type: self.resize_type,
                allow_cancel_resize: self.allow_cancel_resize.unwrap_or_default(),
            }
        }
    }
}
impl ResizeInfo {
    /// Creates a new builder-style object to manufacture [`ResizeInfo`](crate::model::ResizeInfo)
    pub fn builder() -> crate::model::resize_info::Builder {
        crate::model::resize_info::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ScheduleState {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Modifying,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ScheduleState {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => ScheduleState::Active,
            "FAILED" => ScheduleState::Failed,
            "MODIFYING" => ScheduleState::Modifying,
            other => ScheduleState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ScheduleState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ScheduleState::from(s))
    }
}
impl ScheduleState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ScheduleState::Active => "ACTIVE",
            ScheduleState::Failed => "FAILED",
            ScheduleState::Modifying => "MODIFYING",
            ScheduleState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVE", "FAILED", "MODIFYING"]
    }
}
impl AsRef<str> for ScheduleState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes a deferred maintenance window</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeferredMaintenanceWindow {
    /// <p>A unique identifier for the maintenance window.</p>
    pub defer_maintenance_identifier: std::option::Option<std::string::String>,
    /// <p> A timestamp for the beginning of the time period when we defer maintenance.</p>
    pub defer_maintenance_start_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p> A timestamp for the end of the time period when we defer maintenance.</p>
    pub defer_maintenance_end_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl DeferredMaintenanceWindow {
    /// <p>A unique identifier for the maintenance window.</p>
    pub fn defer_maintenance_identifier(&self) -> std::option::Option<&str> {
        self.defer_maintenance_identifier.as_deref()
    }
    /// <p> A timestamp for the beginning of the time period when we defer maintenance.</p>
    pub fn defer_maintenance_start_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.defer_maintenance_start_time.as_ref()
    }
    /// <p> A timestamp for the end of the time period when we defer maintenance.</p>
    pub fn defer_maintenance_end_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.defer_maintenance_end_time.as_ref()
    }
}
impl std::fmt::Debug for DeferredMaintenanceWindow {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeferredMaintenanceWindow");
        formatter.field(
            "defer_maintenance_identifier",
            &self.defer_maintenance_identifier,
        );
        formatter.field(
            "defer_maintenance_start_time",
            &self.defer_maintenance_start_time,
        );
        formatter.field(
            "defer_maintenance_end_time",
            &self.defer_maintenance_end_time,
        );
        formatter.finish()
    }
}
/// See [`DeferredMaintenanceWindow`](crate::model::DeferredMaintenanceWindow)
pub mod deferred_maintenance_window {
    /// A builder for [`DeferredMaintenanceWindow`](crate::model::DeferredMaintenanceWindow)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) defer_maintenance_identifier: std::option::Option<std::string::String>,
        pub(crate) defer_maintenance_start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) defer_maintenance_end_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>A unique identifier for the maintenance window.</p>
        pub fn defer_maintenance_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.defer_maintenance_identifier = Some(input.into());
            self
        }
        /// <p>A unique identifier for the maintenance window.</p>
        pub fn set_defer_maintenance_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.defer_maintenance_identifier = input;
            self
        }
        /// <p> A timestamp for the beginning of the time period when we defer maintenance.</p>
        pub fn defer_maintenance_start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.defer_maintenance_start_time = Some(input);
            self
        }
        /// <p> A timestamp for the beginning of the time period when we defer maintenance.</p>
        pub fn set_defer_maintenance_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.defer_maintenance_start_time = input;
            self
        }
        /// <p> A timestamp for the end of the time period when we defer maintenance.</p>
        pub fn defer_maintenance_end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.defer_maintenance_end_time = Some(input);
            self
        }
        /// <p> A timestamp for the end of the time period when we defer maintenance.</p>
        pub fn set_defer_maintenance_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.defer_maintenance_end_time = input;
            self
        }
        /// Consumes the builder and constructs a [`DeferredMaintenanceWindow`](crate::model::DeferredMaintenanceWindow)
        pub fn build(self) -> crate::model::DeferredMaintenanceWindow {
            crate::model::DeferredMaintenanceWindow {
                defer_maintenance_identifier: self.defer_maintenance_identifier,
                defer_maintenance_start_time: self.defer_maintenance_start_time,
                defer_maintenance_end_time: self.defer_maintenance_end_time,
            }
        }
    }
}
impl DeferredMaintenanceWindow {
    /// Creates a new builder-style object to manufacture [`DeferredMaintenanceWindow`](crate::model::DeferredMaintenanceWindow)
    pub fn builder() -> crate::model::deferred_maintenance_window::Builder {
        crate::model::deferred_maintenance_window::Builder::default()
    }
}

/// <p>An Identity and Access Management (IAM) role that can be used by the associated Amazon Redshift cluster to access other Amazon Web Services services.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ClusterIamRole {
    /// <p>The Amazon Resource Name (ARN) of the IAM role, for example, <code>arn:aws:iam::123456789012:role/RedshiftCopyUnload</code>. </p>
    pub iam_role_arn: std::option::Option<std::string::String>,
    /// <p>A value that describes the status of the IAM role's association with an Amazon Redshift cluster.</p>
    /// <p>The following are possible statuses and descriptions.</p>
    /// <ul>
    /// <li> <p> <code>in-sync</code>: The role is available for use by the cluster.</p> </li>
    /// <li> <p> <code>adding</code>: The role is in the process of being associated with the cluster.</p> </li>
    /// <li> <p> <code>removing</code>: The role is in the process of being disassociated with the cluster.</p> </li>
    /// </ul>
    pub apply_status: std::option::Option<std::string::String>,
}
impl ClusterIamRole {
    /// <p>The Amazon Resource Name (ARN) of the IAM role, for example, <code>arn:aws:iam::123456789012:role/RedshiftCopyUnload</code>. </p>
    pub fn iam_role_arn(&self) -> std::option::Option<&str> {
        self.iam_role_arn.as_deref()
    }
    /// <p>A value that describes the status of the IAM role's association with an Amazon Redshift cluster.</p>
    /// <p>The following are possible statuses and descriptions.</p>
    /// <ul>
    /// <li> <p> <code>in-sync</code>: The role is available for use by the cluster.</p> </li>
    /// <li> <p> <code>adding</code>: The role is in the process of being associated with the cluster.</p> </li>
    /// <li> <p> <code>removing</code>: The role is in the process of being disassociated with the cluster.</p> </li>
    /// </ul>
    pub fn apply_status(&self) -> std::option::Option<&str> {
        self.apply_status.as_deref()
    }
}
impl std::fmt::Debug for ClusterIamRole {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ClusterIamRole");
        formatter.field("iam_role_arn", &self.iam_role_arn);
        formatter.field("apply_status", &self.apply_status);
        formatter.finish()
    }
}
/// See [`ClusterIamRole`](crate::model::ClusterIamRole)
pub mod cluster_iam_role {
    /// A builder for [`ClusterIamRole`](crate::model::ClusterIamRole)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) iam_role_arn: std::option::Option<std::string::String>,
        pub(crate) apply_status: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the IAM role, for example, <code>arn:aws:iam::123456789012:role/RedshiftCopyUnload</code>. </p>
        pub fn iam_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.iam_role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role, for example, <code>arn:aws:iam::123456789012:role/RedshiftCopyUnload</code>. </p>
        pub fn set_iam_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.iam_role_arn = input;
            self
        }
        /// <p>A value that describes the status of the IAM role's association with an Amazon Redshift cluster.</p>
        /// <p>The following are possible statuses and descriptions.</p>
        /// <ul>
        /// <li> <p> <code>in-sync</code>: The role is available for use by the cluster.</p> </li>
        /// <li> <p> <code>adding</code>: The role is in the process of being associated with the cluster.</p> </li>
        /// <li> <p> <code>removing</code>: The role is in the process of being disassociated with the cluster.</p> </li>
        /// </ul>
        pub fn apply_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.apply_status = Some(input.into());
            self
        }
        /// <p>A value that describes the status of the IAM role's association with an Amazon Redshift cluster.</p>
        /// <p>The following are possible statuses and descriptions.</p>
        /// <ul>
        /// <li> <p> <code>in-sync</code>: The role is available for use by the cluster.</p> </li>
        /// <li> <p> <code>adding</code>: The role is in the process of being associated with the cluster.</p> </li>
        /// <li> <p> <code>removing</code>: The role is in the process of being disassociated with the cluster.</p> </li>
        /// </ul>
        pub fn set_apply_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.apply_status = input;
            self
        }
        /// Consumes the builder and constructs a [`ClusterIamRole`](crate::model::ClusterIamRole)
        pub fn build(self) -> crate::model::ClusterIamRole {
            crate::model::ClusterIamRole {
                iam_role_arn: self.iam_role_arn,
                apply_status: self.apply_status,
            }
        }
    }
}
impl ClusterIamRole {
    /// Creates a new builder-style object to manufacture [`ClusterIamRole`](crate::model::ClusterIamRole)
    pub fn builder() -> crate::model::cluster_iam_role::Builder {
        crate::model::cluster_iam_role::Builder::default()
    }
}

/// <p>A tag consisting of a name/value pair for a resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tag {
    /// <p>The key, or name, for the resource tag.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The value for the resource tag.</p>
    pub value: std::option::Option<std::string::String>,
}
impl Tag {
    /// <p>The key, or name, for the resource tag.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>The value for the resource tag.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for Tag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tag");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Tag`](crate::model::Tag)
pub mod tag {
    /// A builder for [`Tag`](crate::model::Tag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The key, or name, for the resource tag.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The key, or name, for the resource tag.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The value for the resource tag.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value for the resource tag.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Tag`](crate::model::Tag)
        pub fn build(self) -> crate::model::Tag {
            crate::model::Tag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl Tag {
    /// Creates a new builder-style object to manufacture [`Tag`](crate::model::Tag)
    pub fn builder() -> crate::model::tag::Builder {
        crate::model::tag::Builder::default()
    }
}

/// <p>Describes the status of the elastic IP (EIP) address.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ElasticIpStatus {
    /// <p>The elastic IP (EIP) address for the cluster.</p>
    pub elastic_ip: std::option::Option<std::string::String>,
    /// <p>The status of the elastic IP (EIP) address.</p>
    pub status: std::option::Option<std::string::String>,
}
impl ElasticIpStatus {
    /// <p>The elastic IP (EIP) address for the cluster.</p>
    pub fn elastic_ip(&self) -> std::option::Option<&str> {
        self.elastic_ip.as_deref()
    }
    /// <p>The status of the elastic IP (EIP) address.</p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
}
impl std::fmt::Debug for ElasticIpStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ElasticIpStatus");
        formatter.field("elastic_ip", &self.elastic_ip);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`ElasticIpStatus`](crate::model::ElasticIpStatus)
pub mod elastic_ip_status {
    /// A builder for [`ElasticIpStatus`](crate::model::ElasticIpStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) elastic_ip: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The elastic IP (EIP) address for the cluster.</p>
        pub fn elastic_ip(mut self, input: impl Into<std::string::String>) -> Self {
            self.elastic_ip = Some(input.into());
            self
        }
        /// <p>The elastic IP (EIP) address for the cluster.</p>
        pub fn set_elastic_ip(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.elastic_ip = input;
            self
        }
        /// <p>The status of the elastic IP (EIP) address.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the elastic IP (EIP) address.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`ElasticIpStatus`](crate::model::ElasticIpStatus)
        pub fn build(self) -> crate::model::ElasticIpStatus {
            crate::model::ElasticIpStatus {
                elastic_ip: self.elastic_ip,
                status: self.status,
            }
        }
    }
}
impl ElasticIpStatus {
    /// Creates a new builder-style object to manufacture [`ElasticIpStatus`](crate::model::ElasticIpStatus)
    pub fn builder() -> crate::model::elastic_ip_status::Builder {
        crate::model::elastic_ip_status::Builder::default()
    }
}

/// <p>The identifier of a node in a cluster.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ClusterNode {
    /// <p>Whether the node is a leader node or a compute node.</p>
    pub node_role: std::option::Option<std::string::String>,
    /// <p>The private IP address of a node within a cluster.</p>
    pub private_ip_address: std::option::Option<std::string::String>,
    /// <p>The public IP address of a node within a cluster.</p>
    pub public_ip_address: std::option::Option<std::string::String>,
}
impl ClusterNode {
    /// <p>Whether the node is a leader node or a compute node.</p>
    pub fn node_role(&self) -> std::option::Option<&str> {
        self.node_role.as_deref()
    }
    /// <p>The private IP address of a node within a cluster.</p>
    pub fn private_ip_address(&self) -> std::option::Option<&str> {
        self.private_ip_address.as_deref()
    }
    /// <p>The public IP address of a node within a cluster.</p>
    pub fn public_ip_address(&self) -> std::option::Option<&str> {
        self.public_ip_address.as_deref()
    }
}
impl std::fmt::Debug for ClusterNode {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ClusterNode");
        formatter.field("node_role", &self.node_role);
        formatter.field("private_ip_address", &self.private_ip_address);
        formatter.field("public_ip_address", &self.public_ip_address);
        formatter.finish()
    }
}
/// See [`ClusterNode`](crate::model::ClusterNode)
pub mod cluster_node {
    /// A builder for [`ClusterNode`](crate::model::ClusterNode)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) node_role: std::option::Option<std::string::String>,
        pub(crate) private_ip_address: std::option::Option<std::string::String>,
        pub(crate) public_ip_address: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Whether the node is a leader node or a compute node.</p>
        pub fn node_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.node_role = Some(input.into());
            self
        }
        /// <p>Whether the node is a leader node or a compute node.</p>
        pub fn set_node_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.node_role = input;
            self
        }
        /// <p>The private IP address of a node within a cluster.</p>
        pub fn private_ip_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.private_ip_address = Some(input.into());
            self
        }
        /// <p>The private IP address of a node within a cluster.</p>
        pub fn set_private_ip_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.private_ip_address = input;
            self
        }
        /// <p>The public IP address of a node within a cluster.</p>
        pub fn public_ip_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.public_ip_address = Some(input.into());
            self
        }
        /// <p>The public IP address of a node within a cluster.</p>
        pub fn set_public_ip_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.public_ip_address = input;
            self
        }
        /// Consumes the builder and constructs a [`ClusterNode`](crate::model::ClusterNode)
        pub fn build(self) -> crate::model::ClusterNode {
            crate::model::ClusterNode {
                node_role: self.node_role,
                private_ip_address: self.private_ip_address,
                public_ip_address: self.public_ip_address,
            }
        }
    }
}
impl ClusterNode {
    /// Creates a new builder-style object to manufacture [`ClusterNode`](crate::model::ClusterNode)
    pub fn builder() -> crate::model::cluster_node::Builder {
        crate::model::cluster_node::Builder::default()
    }
}

/// <p>Returns the destination region and retention period that are configured for cross-region snapshot copy.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ClusterSnapshotCopyStatus {
    /// <p>The destination region that snapshots are automatically copied to when cross-region snapshot copy is enabled.</p>
    pub destination_region: std::option::Option<std::string::String>,
    /// <p>The number of days that automated snapshots are retained in the destination region after they are copied from a source region.</p>
    pub retention_period: i64,
    /// <p>The number of days that automated snapshots are retained in the destination region after they are copied from a source region. If the value is -1, the manual snapshot is retained indefinitely. </p>
    /// <p>The value must be either -1 or an integer between 1 and 3,653.</p>
    pub manual_snapshot_retention_period: i32,
    /// <p>The name of the snapshot copy grant.</p>
    pub snapshot_copy_grant_name: std::option::Option<std::string::String>,
}
impl ClusterSnapshotCopyStatus {
    /// <p>The destination region that snapshots are automatically copied to when cross-region snapshot copy is enabled.</p>
    pub fn destination_region(&self) -> std::option::Option<&str> {
        self.destination_region.as_deref()
    }
    /// <p>The number of days that automated snapshots are retained in the destination region after they are copied from a source region.</p>
    pub fn retention_period(&self) -> i64 {
        self.retention_period
    }
    /// <p>The number of days that automated snapshots are retained in the destination region after they are copied from a source region. If the value is -1, the manual snapshot is retained indefinitely. </p>
    /// <p>The value must be either -1 or an integer between 1 and 3,653.</p>
    pub fn manual_snapshot_retention_period(&self) -> i32 {
        self.manual_snapshot_retention_period
    }
    /// <p>The name of the snapshot copy grant.</p>
    pub fn snapshot_copy_grant_name(&self) -> std::option::Option<&str> {
        self.snapshot_copy_grant_name.as_deref()
    }
}
impl std::fmt::Debug for ClusterSnapshotCopyStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ClusterSnapshotCopyStatus");
        formatter.field("destination_region", &self.destination_region);
        formatter.field("retention_period", &self.retention_period);
        formatter.field(
            "manual_snapshot_retention_period",
            &self.manual_snapshot_retention_period,
        );
        formatter.field("snapshot_copy_grant_name", &self.snapshot_copy_grant_name);
        formatter.finish()
    }
}
/// See [`ClusterSnapshotCopyStatus`](crate::model::ClusterSnapshotCopyStatus)
pub mod cluster_snapshot_copy_status {
    /// A builder for [`ClusterSnapshotCopyStatus`](crate::model::ClusterSnapshotCopyStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) destination_region: std::option::Option<std::string::String>,
        pub(crate) retention_period: std::option::Option<i64>,
        pub(crate) manual_snapshot_retention_period: std::option::Option<i32>,
        pub(crate) snapshot_copy_grant_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The destination region that snapshots are automatically copied to when cross-region snapshot copy is enabled.</p>
        pub fn destination_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.destination_region = Some(input.into());
            self
        }
        /// <p>The destination region that snapshots are automatically copied to when cross-region snapshot copy is enabled.</p>
        pub fn set_destination_region(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_region = input;
            self
        }
        /// <p>The number of days that automated snapshots are retained in the destination region after they are copied from a source region.</p>
        pub fn retention_period(mut self, input: i64) -> Self {
            self.retention_period = Some(input);
            self
        }
        /// <p>The number of days that automated snapshots are retained in the destination region after they are copied from a source region.</p>
        pub fn set_retention_period(mut self, input: std::option::Option<i64>) -> Self {
            self.retention_period = input;
            self
        }
        /// <p>The number of days that automated snapshots are retained in the destination region after they are copied from a source region. If the value is -1, the manual snapshot is retained indefinitely. </p>
        /// <p>The value must be either -1 or an integer between 1 and 3,653.</p>
        pub fn manual_snapshot_retention_period(mut self, input: i32) -> Self {
            self.manual_snapshot_retention_period = Some(input);
            self
        }
        /// <p>The number of days that automated snapshots are retained in the destination region after they are copied from a source region. If the value is -1, the manual snapshot is retained indefinitely. </p>
        /// <p>The value must be either -1 or an integer between 1 and 3,653.</p>
        pub fn set_manual_snapshot_retention_period(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.manual_snapshot_retention_period = input;
            self
        }
        /// <p>The name of the snapshot copy grant.</p>
        pub fn snapshot_copy_grant_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.snapshot_copy_grant_name = Some(input.into());
            self
        }
        /// <p>The name of the snapshot copy grant.</p>
        pub fn set_snapshot_copy_grant_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.snapshot_copy_grant_name = input;
            self
        }
        /// Consumes the builder and constructs a [`ClusterSnapshotCopyStatus`](crate::model::ClusterSnapshotCopyStatus)
        pub fn build(self) -> crate::model::ClusterSnapshotCopyStatus {
            crate::model::ClusterSnapshotCopyStatus {
                destination_region: self.destination_region,
                retention_period: self.retention_period.unwrap_or_default(),
                manual_snapshot_retention_period: self
                    .manual_snapshot_retention_period
                    .unwrap_or_default(),
                snapshot_copy_grant_name: self.snapshot_copy_grant_name,
            }
        }
    }
}
impl ClusterSnapshotCopyStatus {
    /// Creates a new builder-style object to manufacture [`ClusterSnapshotCopyStatus`](crate::model::ClusterSnapshotCopyStatus)
    pub fn builder() -> crate::model::cluster_snapshot_copy_status::Builder {
        crate::model::cluster_snapshot_copy_status::Builder::default()
    }
}

/// <p>Describes the status of changes to HSM settings.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HsmStatus {
    /// <p>Specifies the name of the HSM client certificate the Amazon Redshift cluster uses to retrieve the data encryption keys stored in an HSM.</p>
    pub hsm_client_certificate_identifier: std::option::Option<std::string::String>,
    /// <p>Specifies the name of the HSM configuration that contains the information the Amazon Redshift cluster can use to retrieve and store keys in an HSM.</p>
    pub hsm_configuration_identifier: std::option::Option<std::string::String>,
    /// <p>Reports whether the Amazon Redshift cluster has finished applying any HSM settings changes specified in a modify cluster command.</p>
    /// <p>Values: active, applying</p>
    pub status: std::option::Option<std::string::String>,
}
impl HsmStatus {
    /// <p>Specifies the name of the HSM client certificate the Amazon Redshift cluster uses to retrieve the data encryption keys stored in an HSM.</p>
    pub fn hsm_client_certificate_identifier(&self) -> std::option::Option<&str> {
        self.hsm_client_certificate_identifier.as_deref()
    }
    /// <p>Specifies the name of the HSM configuration that contains the information the Amazon Redshift cluster can use to retrieve and store keys in an HSM.</p>
    pub fn hsm_configuration_identifier(&self) -> std::option::Option<&str> {
        self.hsm_configuration_identifier.as_deref()
    }
    /// <p>Reports whether the Amazon Redshift cluster has finished applying any HSM settings changes specified in a modify cluster command.</p>
    /// <p>Values: active, applying</p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
}
impl std::fmt::Debug for HsmStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HsmStatus");
        formatter.field(
            "hsm_client_certificate_identifier",
            &self.hsm_client_certificate_identifier,
        );
        formatter.field(
            "hsm_configuration_identifier",
            &self.hsm_configuration_identifier,
        );
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`HsmStatus`](crate::model::HsmStatus)
pub mod hsm_status {
    /// A builder for [`HsmStatus`](crate::model::HsmStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) hsm_client_certificate_identifier: std::option::Option<std::string::String>,
        pub(crate) hsm_configuration_identifier: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies the name of the HSM client certificate the Amazon Redshift cluster uses to retrieve the data encryption keys stored in an HSM.</p>
        pub fn hsm_client_certificate_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.hsm_client_certificate_identifier = Some(input.into());
            self
        }
        /// <p>Specifies the name of the HSM client certificate the Amazon Redshift cluster uses to retrieve the data encryption keys stored in an HSM.</p>
        pub fn set_hsm_client_certificate_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.hsm_client_certificate_identifier = input;
            self
        }
        /// <p>Specifies the name of the HSM configuration that contains the information the Amazon Redshift cluster can use to retrieve and store keys in an HSM.</p>
        pub fn hsm_configuration_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.hsm_configuration_identifier = Some(input.into());
            self
        }
        /// <p>Specifies the name of the HSM configuration that contains the information the Amazon Redshift cluster can use to retrieve and store keys in an HSM.</p>
        pub fn set_hsm_configuration_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.hsm_configuration_identifier = input;
            self
        }
        /// <p>Reports whether the Amazon Redshift cluster has finished applying any HSM settings changes specified in a modify cluster command.</p>
        /// <p>Values: active, applying</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>Reports whether the Amazon Redshift cluster has finished applying any HSM settings changes specified in a modify cluster command.</p>
        /// <p>Values: active, applying</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`HsmStatus`](crate::model::HsmStatus)
        pub fn build(self) -> crate::model::HsmStatus {
            crate::model::HsmStatus {
                hsm_client_certificate_identifier: self.hsm_client_certificate_identifier,
                hsm_configuration_identifier: self.hsm_configuration_identifier,
                status: self.status,
            }
        }
    }
}
impl HsmStatus {
    /// Creates a new builder-style object to manufacture [`HsmStatus`](crate::model::HsmStatus)
    pub fn builder() -> crate::model::hsm_status::Builder {
        crate::model::hsm_status::Builder::default()
    }
}

/// <p>Describes the status of a cluster while it is in the process of resizing with an incremental resize.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DataTransferProgress {
    /// <p>Describes the status of the cluster. While the transfer is in progress the status is <code>transferringdata</code>.</p>
    pub status: std::option::Option<std::string::String>,
    /// <p>Describes the data transfer rate in MB's per second.</p>
    pub current_rate_in_mega_bytes_per_second: std::option::Option<f64>,
    /// <p>Describes the total amount of data to be transfered in megabytes.</p>
    pub total_data_in_mega_bytes: i64,
    /// <p>Describes the total amount of data that has been transfered in MB's.</p>
    pub data_transferred_in_mega_bytes: i64,
    /// <p>Describes the estimated number of seconds remaining to complete the transfer.</p>
    pub estimated_time_to_completion_in_seconds: std::option::Option<i64>,
    /// <p>Describes the number of seconds that have elapsed during the data transfer.</p>
    pub elapsed_time_in_seconds: std::option::Option<i64>,
}
impl DataTransferProgress {
    /// <p>Describes the status of the cluster. While the transfer is in progress the status is <code>transferringdata</code>.</p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>Describes the data transfer rate in MB's per second.</p>
    pub fn current_rate_in_mega_bytes_per_second(&self) -> std::option::Option<f64> {
        self.current_rate_in_mega_bytes_per_second
    }
    /// <p>Describes the total amount of data to be transfered in megabytes.</p>
    pub fn total_data_in_mega_bytes(&self) -> i64 {
        self.total_data_in_mega_bytes
    }
    /// <p>Describes the total amount of data that has been transfered in MB's.</p>
    pub fn data_transferred_in_mega_bytes(&self) -> i64 {
        self.data_transferred_in_mega_bytes
    }
    /// <p>Describes the estimated number of seconds remaining to complete the transfer.</p>
    pub fn estimated_time_to_completion_in_seconds(&self) -> std::option::Option<i64> {
        self.estimated_time_to_completion_in_seconds
    }
    /// <p>Describes the number of seconds that have elapsed during the data transfer.</p>
    pub fn elapsed_time_in_seconds(&self) -> std::option::Option<i64> {
        self.elapsed_time_in_seconds
    }
}
impl std::fmt::Debug for DataTransferProgress {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DataTransferProgress");
        formatter.field("status", &self.status);
        formatter.field(
            "current_rate_in_mega_bytes_per_second",
            &self.current_rate_in_mega_bytes_per_second,
        );
        formatter.field("total_data_in_mega_bytes", &self.total_data_in_mega_bytes);
        formatter.field(
            "data_transferred_in_mega_bytes",
            &self.data_transferred_in_mega_bytes,
        );
        formatter.field(
            "estimated_time_to_completion_in_seconds",
            &self.estimated_time_to_completion_in_seconds,
        );
        formatter.field("elapsed_time_in_seconds", &self.elapsed_time_in_seconds);
        formatter.finish()
    }
}
/// See [`DataTransferProgress`](crate::model::DataTransferProgress)
pub mod data_transfer_progress {
    /// A builder for [`DataTransferProgress`](crate::model::DataTransferProgress)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) current_rate_in_mega_bytes_per_second: std::option::Option<f64>,
        pub(crate) total_data_in_mega_bytes: std::option::Option<i64>,
        pub(crate) data_transferred_in_mega_bytes: std::option::Option<i64>,
        pub(crate) estimated_time_to_completion_in_seconds: std::option::Option<i64>,
        pub(crate) elapsed_time_in_seconds: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>Describes the status of the cluster. While the transfer is in progress the status is <code>transferringdata</code>.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>Describes the status of the cluster. While the transfer is in progress the status is <code>transferringdata</code>.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>Describes the data transfer rate in MB's per second.</p>
        pub fn current_rate_in_mega_bytes_per_second(mut self, input: f64) -> Self {
            self.current_rate_in_mega_bytes_per_second = Some(input);
            self
        }
        /// <p>Describes the data transfer rate in MB's per second.</p>
        pub fn set_current_rate_in_mega_bytes_per_second(
            mut self,
            input: std::option::Option<f64>,
        ) -> Self {
            self.current_rate_in_mega_bytes_per_second = input;
            self
        }
        /// <p>Describes the total amount of data to be transfered in megabytes.</p>
        pub fn total_data_in_mega_bytes(mut self, input: i64) -> Self {
            self.total_data_in_mega_bytes = Some(input);
            self
        }
        /// <p>Describes the total amount of data to be transfered in megabytes.</p>
        pub fn set_total_data_in_mega_bytes(mut self, input: std::option::Option<i64>) -> Self {
            self.total_data_in_mega_bytes = input;
            self
        }
        /// <p>Describes the total amount of data that has been transfered in MB's.</p>
        pub fn data_transferred_in_mega_bytes(mut self, input: i64) -> Self {
            self.data_transferred_in_mega_bytes = Some(input);
            self
        }
        /// <p>Describes the total amount of data that has been transfered in MB's.</p>
        pub fn set_data_transferred_in_mega_bytes(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.data_transferred_in_mega_bytes = input;
            self
        }
        /// <p>Describes the estimated number of seconds remaining to complete the transfer.</p>
        pub fn estimated_time_to_completion_in_seconds(mut self, input: i64) -> Self {
            self.estimated_time_to_completion_in_seconds = Some(input);
            self
        }
        /// <p>Describes the estimated number of seconds remaining to complete the transfer.</p>
        pub fn set_estimated_time_to_completion_in_seconds(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.estimated_time_to_completion_in_seconds = input;
            self
        }
        /// <p>Describes the number of seconds that have elapsed during the data transfer.</p>
        pub fn elapsed_time_in_seconds(mut self, input: i64) -> Self {
            self.elapsed_time_in_seconds = Some(input);
            self
        }
        /// <p>Describes the number of seconds that have elapsed during the data transfer.</p>
        pub fn set_elapsed_time_in_seconds(mut self, input: std::option::Option<i64>) -> Self {
            self.elapsed_time_in_seconds = input;
            self
        }
        /// Consumes the builder and constructs a [`DataTransferProgress`](crate::model::DataTransferProgress)
        pub fn build(self) -> crate::model::DataTransferProgress {
            crate::model::DataTransferProgress {
                status: self.status,
                current_rate_in_mega_bytes_per_second: self.current_rate_in_mega_bytes_per_second,
                total_data_in_mega_bytes: self.total_data_in_mega_bytes.unwrap_or_default(),
                data_transferred_in_mega_bytes: self
                    .data_transferred_in_mega_bytes
                    .unwrap_or_default(),
                estimated_time_to_completion_in_seconds: self
                    .estimated_time_to_completion_in_seconds,
                elapsed_time_in_seconds: self.elapsed_time_in_seconds,
            }
        }
    }
}
impl DataTransferProgress {
    /// Creates a new builder-style object to manufacture [`DataTransferProgress`](crate::model::DataTransferProgress)
    pub fn builder() -> crate::model::data_transfer_progress::Builder {
        crate::model::data_transfer_progress::Builder::default()
    }
}

/// <p>Describes the status of a cluster restore action. Returns null if the cluster was not created by restoring a snapshot.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RestoreStatus {
    /// <p>The status of the restore action. Returns starting, restoring, completed, or failed.</p>
    pub status: std::option::Option<std::string::String>,
    /// <p>The number of megabytes per second being transferred from the backup storage. Returns the average rate for a completed backup. This field is only updated when you restore to DC2 and DS2 node types. </p>
    pub current_restore_rate_in_mega_bytes_per_second: f64,
    /// <p>The size of the set of snapshot data used to restore the cluster. This field is only updated when you restore to DC2 and DS2 node types. </p>
    pub snapshot_size_in_mega_bytes: i64,
    /// <p>The number of megabytes that have been transferred from snapshot storage. This field is only updated when you restore to DC2 and DS2 node types. </p>
    pub progress_in_mega_bytes: i64,
    /// <p>The amount of time an in-progress restore has been running, or the amount of time it took a completed restore to finish. This field is only updated when you restore to DC2 and DS2 node types. </p>
    pub elapsed_time_in_seconds: i64,
    /// <p>The estimate of the time remaining before the restore will complete. Returns 0 for a completed restore. This field is only updated when you restore to DC2 and DS2 node types. </p>
    pub estimated_time_to_completion_in_seconds: i64,
}
impl RestoreStatus {
    /// <p>The status of the restore action. Returns starting, restoring, completed, or failed.</p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>The number of megabytes per second being transferred from the backup storage. Returns the average rate for a completed backup. This field is only updated when you restore to DC2 and DS2 node types. </p>
    pub fn current_restore_rate_in_mega_bytes_per_second(&self) -> f64 {
        self.current_restore_rate_in_mega_bytes_per_second
    }
    /// <p>The size of the set of snapshot data used to restore the cluster. This field is only updated when you restore to DC2 and DS2 node types. </p>
    pub fn snapshot_size_in_mega_bytes(&self) -> i64 {
        self.snapshot_size_in_mega_bytes
    }
    /// <p>The number of megabytes that have been transferred from snapshot storage. This field is only updated when you restore to DC2 and DS2 node types. </p>
    pub fn progress_in_mega_bytes(&self) -> i64 {
        self.progress_in_mega_bytes
    }
    /// <p>The amount of time an in-progress restore has been running, or the amount of time it took a completed restore to finish. This field is only updated when you restore to DC2 and DS2 node types. </p>
    pub fn elapsed_time_in_seconds(&self) -> i64 {
        self.elapsed_time_in_seconds
    }
    /// <p>The estimate of the time remaining before the restore will complete. Returns 0 for a completed restore. This field is only updated when you restore to DC2 and DS2 node types. </p>
    pub fn estimated_time_to_completion_in_seconds(&self) -> i64 {
        self.estimated_time_to_completion_in_seconds
    }
}
impl std::fmt::Debug for RestoreStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RestoreStatus");
        formatter.field("status", &self.status);
        formatter.field(
            "current_restore_rate_in_mega_bytes_per_second",
            &self.current_restore_rate_in_mega_bytes_per_second,
        );
        formatter.field(
            "snapshot_size_in_mega_bytes",
            &self.snapshot_size_in_mega_bytes,
        );
        formatter.field("progress_in_mega_bytes", &self.progress_in_mega_bytes);
        formatter.field("elapsed_time_in_seconds", &self.elapsed_time_in_seconds);
        formatter.field(
            "estimated_time_to_completion_in_seconds",
            &self.estimated_time_to_completion_in_seconds,
        );
        formatter.finish()
    }
}
/// See [`RestoreStatus`](crate::model::RestoreStatus)
pub mod restore_status {
    /// A builder for [`RestoreStatus`](crate::model::RestoreStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) current_restore_rate_in_mega_bytes_per_second: std::option::Option<f64>,
        pub(crate) snapshot_size_in_mega_bytes: std::option::Option<i64>,
        pub(crate) progress_in_mega_bytes: std::option::Option<i64>,
        pub(crate) elapsed_time_in_seconds: std::option::Option<i64>,
        pub(crate) estimated_time_to_completion_in_seconds: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The status of the restore action. Returns starting, restoring, completed, or failed.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the restore action. Returns starting, restoring, completed, or failed.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>The number of megabytes per second being transferred from the backup storage. Returns the average rate for a completed backup. This field is only updated when you restore to DC2 and DS2 node types. </p>
        pub fn current_restore_rate_in_mega_bytes_per_second(mut self, input: f64) -> Self {
            self.current_restore_rate_in_mega_bytes_per_second = Some(input);
            self
        }
        /// <p>The number of megabytes per second being transferred from the backup storage. Returns the average rate for a completed backup. This field is only updated when you restore to DC2 and DS2 node types. </p>
        pub fn set_current_restore_rate_in_mega_bytes_per_second(
            mut self,
            input: std::option::Option<f64>,
        ) -> Self {
            self.current_restore_rate_in_mega_bytes_per_second = input;
            self
        }
        /// <p>The size of the set of snapshot data used to restore the cluster. This field is only updated when you restore to DC2 and DS2 node types. </p>
        pub fn snapshot_size_in_mega_bytes(mut self, input: i64) -> Self {
            self.snapshot_size_in_mega_bytes = Some(input);
            self
        }
        /// <p>The size of the set of snapshot data used to restore the cluster. This field is only updated when you restore to DC2 and DS2 node types. </p>
        pub fn set_snapshot_size_in_mega_bytes(mut self, input: std::option::Option<i64>) -> Self {
            self.snapshot_size_in_mega_bytes = input;
            self
        }
        /// <p>The number of megabytes that have been transferred from snapshot storage. This field is only updated when you restore to DC2 and DS2 node types. </p>
        pub fn progress_in_mega_bytes(mut self, input: i64) -> Self {
            self.progress_in_mega_bytes = Some(input);
            self
        }
        /// <p>The number of megabytes that have been transferred from snapshot storage. This field is only updated when you restore to DC2 and DS2 node types. </p>
        pub fn set_progress_in_mega_bytes(mut self, input: std::option::Option<i64>) -> Self {
            self.progress_in_mega_bytes = input;
            self
        }
        /// <p>The amount of time an in-progress restore has been running, or the amount of time it took a completed restore to finish. This field is only updated when you restore to DC2 and DS2 node types. </p>
        pub fn elapsed_time_in_seconds(mut self, input: i64) -> Self {
            self.elapsed_time_in_seconds = Some(input);
            self
        }
        /// <p>The amount of time an in-progress restore has been running, or the amount of time it took a completed restore to finish. This field is only updated when you restore to DC2 and DS2 node types. </p>
        pub fn set_elapsed_time_in_seconds(mut self, input: std::option::Option<i64>) -> Self {
            self.elapsed_time_in_seconds = input;
            self
        }
        /// <p>The estimate of the time remaining before the restore will complete. Returns 0 for a completed restore. This field is only updated when you restore to DC2 and DS2 node types. </p>
        pub fn estimated_time_to_completion_in_seconds(mut self, input: i64) -> Self {
            self.estimated_time_to_completion_in_seconds = Some(input);
            self
        }
        /// <p>The estimate of the time remaining before the restore will complete. Returns 0 for a completed restore. This field is only updated when you restore to DC2 and DS2 node types. </p>
        pub fn set_estimated_time_to_completion_in_seconds(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.estimated_time_to_completion_in_seconds = input;
            self
        }
        /// Consumes the builder and constructs a [`RestoreStatus`](crate::model::RestoreStatus)
        pub fn build(self) -> crate::model::RestoreStatus {
            crate::model::RestoreStatus {
                status: self.status,
                current_restore_rate_in_mega_bytes_per_second: self
                    .current_restore_rate_in_mega_bytes_per_second
                    .unwrap_or_default(),
                snapshot_size_in_mega_bytes: self.snapshot_size_in_mega_bytes.unwrap_or_default(),
                progress_in_mega_bytes: self.progress_in_mega_bytes.unwrap_or_default(),
                elapsed_time_in_seconds: self.elapsed_time_in_seconds.unwrap_or_default(),
                estimated_time_to_completion_in_seconds: self
                    .estimated_time_to_completion_in_seconds
                    .unwrap_or_default(),
            }
        }
    }
}
impl RestoreStatus {
    /// Creates a new builder-style object to manufacture [`RestoreStatus`](crate::model::RestoreStatus)
    pub fn builder() -> crate::model::restore_status::Builder {
        crate::model::restore_status::Builder::default()
    }
}

/// <p>Describes cluster attributes that are in a pending state. A change to one or more the attributes was requested and is in progress or will be applied.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PendingModifiedValues {
    /// <p>The pending or in-progress change of the admin user password for the cluster.</p>
    pub master_user_password: std::option::Option<std::string::String>,
    /// <p>The pending or in-progress change of the cluster's node type.</p>
    pub node_type: std::option::Option<std::string::String>,
    /// <p>The pending or in-progress change of the number of nodes in the cluster.</p>
    pub number_of_nodes: std::option::Option<i32>,
    /// <p>The pending or in-progress change of the cluster type.</p>
    pub cluster_type: std::option::Option<std::string::String>,
    /// <p>The pending or in-progress change of the service version.</p>
    pub cluster_version: std::option::Option<std::string::String>,
    /// <p>The pending or in-progress change of the automated snapshot retention period.</p>
    pub automated_snapshot_retention_period: std::option::Option<i32>,
    /// <p>The pending or in-progress change of the new identifier for the cluster.</p>
    pub cluster_identifier: std::option::Option<std::string::String>,
    /// <p>The pending or in-progress change of the ability to connect to the cluster from the public network.</p>
    pub publicly_accessible: std::option::Option<bool>,
    /// <p>An option that specifies whether to create the cluster with enhanced VPC routing enabled. To create a cluster that uses enhanced VPC routing, the cluster must be in a VPC. For more information, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html">Enhanced VPC Routing</a> in the Amazon Redshift Cluster Management Guide.</p>
    /// <p>If this option is <code>true</code>, enhanced VPC routing is enabled. </p>
    /// <p>Default: false</p>
    pub enhanced_vpc_routing: std::option::Option<bool>,
    /// <p>The name of the maintenance track that the cluster will change to during the next maintenance window.</p>
    pub maintenance_track_name: std::option::Option<std::string::String>,
    /// <p>The encryption type for a cluster. Possible values are: KMS and None. </p>
    pub encryption_type: std::option::Option<std::string::String>,
}
impl PendingModifiedValues {
    /// <p>The pending or in-progress change of the admin user password for the cluster.</p>
    pub fn master_user_password(&self) -> std::option::Option<&str> {
        self.master_user_password.as_deref()
    }
    /// <p>The pending or in-progress change of the cluster's node type.</p>
    pub fn node_type(&self) -> std::option::Option<&str> {
        self.node_type.as_deref()
    }
    /// <p>The pending or in-progress change of the number of nodes in the cluster.</p>
    pub fn number_of_nodes(&self) -> std::option::Option<i32> {
        self.number_of_nodes
    }
    /// <p>The pending or in-progress change of the cluster type.</p>
    pub fn cluster_type(&self) -> std::option::Option<&str> {
        self.cluster_type.as_deref()
    }
    /// <p>The pending or in-progress change of the service version.</p>
    pub fn cluster_version(&self) -> std::option::Option<&str> {
        self.cluster_version.as_deref()
    }
    /// <p>The pending or in-progress change of the automated snapshot retention period.</p>
    pub fn automated_snapshot_retention_period(&self) -> std::option::Option<i32> {
        self.automated_snapshot_retention_period
    }
    /// <p>The pending or in-progress change of the new identifier for the cluster.</p>
    pub fn cluster_identifier(&self) -> std::option::Option<&str> {
        self.cluster_identifier.as_deref()
    }
    /// <p>The pending or in-progress change of the ability to connect to the cluster from the public network.</p>
    pub fn publicly_accessible(&self) -> std::option::Option<bool> {
        self.publicly_accessible
    }
    /// <p>An option that specifies whether to create the cluster with enhanced VPC routing enabled. To create a cluster that uses enhanced VPC routing, the cluster must be in a VPC. For more information, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html">Enhanced VPC Routing</a> in the Amazon Redshift Cluster Management Guide.</p>
    /// <p>If this option is <code>true</code>, enhanced VPC routing is enabled. </p>
    /// <p>Default: false</p>
    pub fn enhanced_vpc_routing(&self) -> std::option::Option<bool> {
        self.enhanced_vpc_routing
    }
    /// <p>The name of the maintenance track that the cluster will change to during the next maintenance window.</p>
    pub fn maintenance_track_name(&self) -> std::option::Option<&str> {
        self.maintenance_track_name.as_deref()
    }
    /// <p>The encryption type for a cluster. Possible values are: KMS and None. </p>
    pub fn encryption_type(&self) -> std::option::Option<&str> {
        self.encryption_type.as_deref()
    }
}
impl std::fmt::Debug for PendingModifiedValues {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PendingModifiedValues");
        formatter.field("master_user_password", &self.master_user_password);
        formatter.field("node_type", &self.node_type);
        formatter.field("number_of_nodes", &self.number_of_nodes);
        formatter.field("cluster_type", &self.cluster_type);
        formatter.field("cluster_version", &self.cluster_version);
        formatter.field(
            "automated_snapshot_retention_period",
            &self.automated_snapshot_retention_period,
        );
        formatter.field("cluster_identifier", &self.cluster_identifier);
        formatter.field("publicly_accessible", &self.publicly_accessible);
        formatter.field("enhanced_vpc_routing", &self.enhanced_vpc_routing);
        formatter.field("maintenance_track_name", &self.maintenance_track_name);
        formatter.field("encryption_type", &self.encryption_type);
        formatter.finish()
    }
}
/// See [`PendingModifiedValues`](crate::model::PendingModifiedValues)
pub mod pending_modified_values {
    /// A builder for [`PendingModifiedValues`](crate::model::PendingModifiedValues)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) master_user_password: std::option::Option<std::string::String>,
        pub(crate) node_type: std::option::Option<std::string::String>,
        pub(crate) number_of_nodes: std::option::Option<i32>,
        pub(crate) cluster_type: std::option::Option<std::string::String>,
        pub(crate) cluster_version: std::option::Option<std::string::String>,
        pub(crate) automated_snapshot_retention_period: std::option::Option<i32>,
        pub(crate) cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) publicly_accessible: std::option::Option<bool>,
        pub(crate) enhanced_vpc_routing: std::option::Option<bool>,
        pub(crate) maintenance_track_name: std::option::Option<std::string::String>,
        pub(crate) encryption_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The pending or in-progress change of the admin user password for the cluster.</p>
        pub fn master_user_password(mut self, input: impl Into<std::string::String>) -> Self {
            self.master_user_password = Some(input.into());
            self
        }
        /// <p>The pending or in-progress change of the admin user password for the cluster.</p>
        pub fn set_master_user_password(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.master_user_password = input;
            self
        }
        /// <p>The pending or in-progress change of the cluster's node type.</p>
        pub fn node_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.node_type = Some(input.into());
            self
        }
        /// <p>The pending or in-progress change of the cluster's node type.</p>
        pub fn set_node_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.node_type = input;
            self
        }
        /// <p>The pending or in-progress change of the number of nodes in the cluster.</p>
        pub fn number_of_nodes(mut self, input: i32) -> Self {
            self.number_of_nodes = Some(input);
            self
        }
        /// <p>The pending or in-progress change of the number of nodes in the cluster.</p>
        pub fn set_number_of_nodes(mut self, input: std::option::Option<i32>) -> Self {
            self.number_of_nodes = input;
            self
        }
        /// <p>The pending or in-progress change of the cluster type.</p>
        pub fn cluster_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_type = Some(input.into());
            self
        }
        /// <p>The pending or in-progress change of the cluster type.</p>
        pub fn set_cluster_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster_type = input;
            self
        }
        /// <p>The pending or in-progress change of the service version.</p>
        pub fn cluster_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_version = Some(input.into());
            self
        }
        /// <p>The pending or in-progress change of the service version.</p>
        pub fn set_cluster_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cluster_version = input;
            self
        }
        /// <p>The pending or in-progress change of the automated snapshot retention period.</p>
        pub fn automated_snapshot_retention_period(mut self, input: i32) -> Self {
            self.automated_snapshot_retention_period = Some(input);
            self
        }
        /// <p>The pending or in-progress change of the automated snapshot retention period.</p>
        pub fn set_automated_snapshot_retention_period(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.automated_snapshot_retention_period = input;
            self
        }
        /// <p>The pending or in-progress change of the new identifier for the cluster.</p>
        pub fn cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_identifier = Some(input.into());
            self
        }
        /// <p>The pending or in-progress change of the new identifier for the cluster.</p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cluster_identifier = input;
            self
        }
        /// <p>The pending or in-progress change of the ability to connect to the cluster from the public network.</p>
        pub fn publicly_accessible(mut self, input: bool) -> Self {
            self.publicly_accessible = Some(input);
            self
        }
        /// <p>The pending or in-progress change of the ability to connect to the cluster from the public network.</p>
        pub fn set_publicly_accessible(mut self, input: std::option::Option<bool>) -> Self {
            self.publicly_accessible = input;
            self
        }
        /// <p>An option that specifies whether to create the cluster with enhanced VPC routing enabled. To create a cluster that uses enhanced VPC routing, the cluster must be in a VPC. For more information, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html">Enhanced VPC Routing</a> in the Amazon Redshift Cluster Management Guide.</p>
        /// <p>If this option is <code>true</code>, enhanced VPC routing is enabled. </p>
        /// <p>Default: false</p>
        pub fn enhanced_vpc_routing(mut self, input: bool) -> Self {
            self.enhanced_vpc_routing = Some(input);
            self
        }
        /// <p>An option that specifies whether to create the cluster with enhanced VPC routing enabled. To create a cluster that uses enhanced VPC routing, the cluster must be in a VPC. For more information, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html">Enhanced VPC Routing</a> in the Amazon Redshift Cluster Management Guide.</p>
        /// <p>If this option is <code>true</code>, enhanced VPC routing is enabled. </p>
        /// <p>Default: false</p>
        pub fn set_enhanced_vpc_routing(mut self, input: std::option::Option<bool>) -> Self {
            self.enhanced_vpc_routing = input;
            self
        }
        /// <p>The name of the maintenance track that the cluster will change to during the next maintenance window.</p>
        pub fn maintenance_track_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.maintenance_track_name = Some(input.into());
            self
        }
        /// <p>The name of the maintenance track that the cluster will change to during the next maintenance window.</p>
        pub fn set_maintenance_track_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.maintenance_track_name = input;
            self
        }
        /// <p>The encryption type for a cluster. Possible values are: KMS and None. </p>
        pub fn encryption_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.encryption_type = Some(input.into());
            self
        }
        /// <p>The encryption type for a cluster. Possible values are: KMS and None. </p>
        pub fn set_encryption_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.encryption_type = input;
            self
        }
        /// Consumes the builder and constructs a [`PendingModifiedValues`](crate::model::PendingModifiedValues)
        pub fn build(self) -> crate::model::PendingModifiedValues {
            crate::model::PendingModifiedValues {
                master_user_password: self.master_user_password,
                node_type: self.node_type,
                number_of_nodes: self.number_of_nodes,
                cluster_type: self.cluster_type,
                cluster_version: self.cluster_version,
                automated_snapshot_retention_period: self.automated_snapshot_retention_period,
                cluster_identifier: self.cluster_identifier,
                publicly_accessible: self.publicly_accessible,
                enhanced_vpc_routing: self.enhanced_vpc_routing,
                maintenance_track_name: self.maintenance_track_name,
                encryption_type: self.encryption_type,
            }
        }
    }
}
impl PendingModifiedValues {
    /// Creates a new builder-style object to manufacture [`PendingModifiedValues`](crate::model::PendingModifiedValues)
    pub fn builder() -> crate::model::pending_modified_values::Builder {
        crate::model::pending_modified_values::Builder::default()
    }
}

/// <p>Describes the status of a parameter group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ClusterParameterGroupStatus {
    /// <p>The name of the cluster parameter group.</p>
    pub parameter_group_name: std::option::Option<std::string::String>,
    /// <p>The status of parameter updates.</p>
    pub parameter_apply_status: std::option::Option<std::string::String>,
    /// <p>The list of parameter statuses.</p>
    /// <p> For more information about parameters and parameter groups, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Amazon Redshift Parameter Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</p>
    pub cluster_parameter_status_list:
        std::option::Option<std::vec::Vec<crate::model::ClusterParameterStatus>>,
}
impl ClusterParameterGroupStatus {
    /// <p>The name of the cluster parameter group.</p>
    pub fn parameter_group_name(&self) -> std::option::Option<&str> {
        self.parameter_group_name.as_deref()
    }
    /// <p>The status of parameter updates.</p>
    pub fn parameter_apply_status(&self) -> std::option::Option<&str> {
        self.parameter_apply_status.as_deref()
    }
    /// <p>The list of parameter statuses.</p>
    /// <p> For more information about parameters and parameter groups, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Amazon Redshift Parameter Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</p>
    pub fn cluster_parameter_status_list(
        &self,
    ) -> std::option::Option<&[crate::model::ClusterParameterStatus]> {
        self.cluster_parameter_status_list.as_deref()
    }
}
impl std::fmt::Debug for ClusterParameterGroupStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ClusterParameterGroupStatus");
        formatter.field("parameter_group_name", &self.parameter_group_name);
        formatter.field("parameter_apply_status", &self.parameter_apply_status);
        formatter.field(
            "cluster_parameter_status_list",
            &self.cluster_parameter_status_list,
        );
        formatter.finish()
    }
}
/// See [`ClusterParameterGroupStatus`](crate::model::ClusterParameterGroupStatus)
pub mod cluster_parameter_group_status {
    /// A builder for [`ClusterParameterGroupStatus`](crate::model::ClusterParameterGroupStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) parameter_group_name: std::option::Option<std::string::String>,
        pub(crate) parameter_apply_status: std::option::Option<std::string::String>,
        pub(crate) cluster_parameter_status_list:
            std::option::Option<std::vec::Vec<crate::model::ClusterParameterStatus>>,
    }
    impl Builder {
        /// <p>The name of the cluster parameter group.</p>
        pub fn parameter_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.parameter_group_name = Some(input.into());
            self
        }
        /// <p>The name of the cluster parameter group.</p>
        pub fn set_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parameter_group_name = input;
            self
        }
        /// <p>The status of parameter updates.</p>
        pub fn parameter_apply_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.parameter_apply_status = Some(input.into());
            self
        }
        /// <p>The status of parameter updates.</p>
        pub fn set_parameter_apply_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parameter_apply_status = input;
            self
        }
        /// Appends an item to `cluster_parameter_status_list`.
        ///
        /// To override the contents of this collection use [`set_cluster_parameter_status_list`](Self::set_cluster_parameter_status_list).
        ///
        /// <p>The list of parameter statuses.</p>
        /// <p> For more information about parameters and parameter groups, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Amazon Redshift Parameter Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</p>
        pub fn cluster_parameter_status_list(
            mut self,
            input: crate::model::ClusterParameterStatus,
        ) -> Self {
            let mut v = self.cluster_parameter_status_list.unwrap_or_default();
            v.push(input);
            self.cluster_parameter_status_list = Some(v);
            self
        }
        /// <p>The list of parameter statuses.</p>
        /// <p> For more information about parameters and parameter groups, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Amazon Redshift Parameter Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</p>
        pub fn set_cluster_parameter_status_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ClusterParameterStatus>>,
        ) -> Self {
            self.cluster_parameter_status_list = input;
            self
        }
        /// Consumes the builder and constructs a [`ClusterParameterGroupStatus`](crate::model::ClusterParameterGroupStatus)
        pub fn build(self) -> crate::model::ClusterParameterGroupStatus {
            crate::model::ClusterParameterGroupStatus {
                parameter_group_name: self.parameter_group_name,
                parameter_apply_status: self.parameter_apply_status,
                cluster_parameter_status_list: self.cluster_parameter_status_list,
            }
        }
    }
}
impl ClusterParameterGroupStatus {
    /// Creates a new builder-style object to manufacture [`ClusterParameterGroupStatus`](crate::model::ClusterParameterGroupStatus)
    pub fn builder() -> crate::model::cluster_parameter_group_status::Builder {
        crate::model::cluster_parameter_group_status::Builder::default()
    }
}

/// <p>Describes the status of a parameter group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ClusterParameterStatus {
    /// <p>The name of the parameter.</p>
    pub parameter_name: std::option::Option<std::string::String>,
    /// <p>The status of the parameter that indicates whether the parameter is in sync with the database, waiting for a cluster reboot, or encountered an error when being applied.</p>
    /// <p>The following are possible statuses and descriptions.</p>
    /// <ul>
    /// <li> <p> <code>in-sync</code>: The parameter value is in sync with the database.</p> </li>
    /// <li> <p> <code>pending-reboot</code>: The parameter value will be applied after the cluster reboots.</p> </li>
    /// <li> <p> <code>applying</code>: The parameter value is being applied to the database.</p> </li>
    /// <li> <p> <code>invalid-parameter</code>: Cannot apply the parameter value because it has an invalid value or syntax.</p> </li>
    /// <li> <p> <code>apply-deferred</code>: The parameter contains static property changes. The changes are deferred until the cluster reboots.</p> </li>
    /// <li> <p> <code>apply-error</code>: Cannot connect to the cluster. The parameter change will be applied after the cluster reboots.</p> </li>
    /// <li> <p> <code>unknown-error</code>: Cannot apply the parameter change right now. The change will be applied after the cluster reboots.</p> </li>
    /// </ul>
    pub parameter_apply_status: std::option::Option<std::string::String>,
    /// <p>The error that prevented the parameter from being applied to the database.</p>
    pub parameter_apply_error_description: std::option::Option<std::string::String>,
}
impl ClusterParameterStatus {
    /// <p>The name of the parameter.</p>
    pub fn parameter_name(&self) -> std::option::Option<&str> {
        self.parameter_name.as_deref()
    }
    /// <p>The status of the parameter that indicates whether the parameter is in sync with the database, waiting for a cluster reboot, or encountered an error when being applied.</p>
    /// <p>The following are possible statuses and descriptions.</p>
    /// <ul>
    /// <li> <p> <code>in-sync</code>: The parameter value is in sync with the database.</p> </li>
    /// <li> <p> <code>pending-reboot</code>: The parameter value will be applied after the cluster reboots.</p> </li>
    /// <li> <p> <code>applying</code>: The parameter value is being applied to the database.</p> </li>
    /// <li> <p> <code>invalid-parameter</code>: Cannot apply the parameter value because it has an invalid value or syntax.</p> </li>
    /// <li> <p> <code>apply-deferred</code>: The parameter contains static property changes. The changes are deferred until the cluster reboots.</p> </li>
    /// <li> <p> <code>apply-error</code>: Cannot connect to the cluster. The parameter change will be applied after the cluster reboots.</p> </li>
    /// <li> <p> <code>unknown-error</code>: Cannot apply the parameter change right now. The change will be applied after the cluster reboots.</p> </li>
    /// </ul>
    pub fn parameter_apply_status(&self) -> std::option::Option<&str> {
        self.parameter_apply_status.as_deref()
    }
    /// <p>The error that prevented the parameter from being applied to the database.</p>
    pub fn parameter_apply_error_description(&self) -> std::option::Option<&str> {
        self.parameter_apply_error_description.as_deref()
    }
}
impl std::fmt::Debug for ClusterParameterStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ClusterParameterStatus");
        formatter.field("parameter_name", &self.parameter_name);
        formatter.field("parameter_apply_status", &self.parameter_apply_status);
        formatter.field(
            "parameter_apply_error_description",
            &self.parameter_apply_error_description,
        );
        formatter.finish()
    }
}
/// See [`ClusterParameterStatus`](crate::model::ClusterParameterStatus)
pub mod cluster_parameter_status {
    /// A builder for [`ClusterParameterStatus`](crate::model::ClusterParameterStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) parameter_name: std::option::Option<std::string::String>,
        pub(crate) parameter_apply_status: std::option::Option<std::string::String>,
        pub(crate) parameter_apply_error_description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the parameter.</p>
        pub fn parameter_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.parameter_name = Some(input.into());
            self
        }
        /// <p>The name of the parameter.</p>
        pub fn set_parameter_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parameter_name = input;
            self
        }
        /// <p>The status of the parameter that indicates whether the parameter is in sync with the database, waiting for a cluster reboot, or encountered an error when being applied.</p>
        /// <p>The following are possible statuses and descriptions.</p>
        /// <ul>
        /// <li> <p> <code>in-sync</code>: The parameter value is in sync with the database.</p> </li>
        /// <li> <p> <code>pending-reboot</code>: The parameter value will be applied after the cluster reboots.</p> </li>
        /// <li> <p> <code>applying</code>: The parameter value is being applied to the database.</p> </li>
        /// <li> <p> <code>invalid-parameter</code>: Cannot apply the parameter value because it has an invalid value or syntax.</p> </li>
        /// <li> <p> <code>apply-deferred</code>: The parameter contains static property changes. The changes are deferred until the cluster reboots.</p> </li>
        /// <li> <p> <code>apply-error</code>: Cannot connect to the cluster. The parameter change will be applied after the cluster reboots.</p> </li>
        /// <li> <p> <code>unknown-error</code>: Cannot apply the parameter change right now. The change will be applied after the cluster reboots.</p> </li>
        /// </ul>
        pub fn parameter_apply_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.parameter_apply_status = Some(input.into());
            self
        }
        /// <p>The status of the parameter that indicates whether the parameter is in sync with the database, waiting for a cluster reboot, or encountered an error when being applied.</p>
        /// <p>The following are possible statuses and descriptions.</p>
        /// <ul>
        /// <li> <p> <code>in-sync</code>: The parameter value is in sync with the database.</p> </li>
        /// <li> <p> <code>pending-reboot</code>: The parameter value will be applied after the cluster reboots.</p> </li>
        /// <li> <p> <code>applying</code>: The parameter value is being applied to the database.</p> </li>
        /// <li> <p> <code>invalid-parameter</code>: Cannot apply the parameter value because it has an invalid value or syntax.</p> </li>
        /// <li> <p> <code>apply-deferred</code>: The parameter contains static property changes. The changes are deferred until the cluster reboots.</p> </li>
        /// <li> <p> <code>apply-error</code>: Cannot connect to the cluster. The parameter change will be applied after the cluster reboots.</p> </li>
        /// <li> <p> <code>unknown-error</code>: Cannot apply the parameter change right now. The change will be applied after the cluster reboots.</p> </li>
        /// </ul>
        pub fn set_parameter_apply_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parameter_apply_status = input;
            self
        }
        /// <p>The error that prevented the parameter from being applied to the database.</p>
        pub fn parameter_apply_error_description(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.parameter_apply_error_description = Some(input.into());
            self
        }
        /// <p>The error that prevented the parameter from being applied to the database.</p>
        pub fn set_parameter_apply_error_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parameter_apply_error_description = input;
            self
        }
        /// Consumes the builder and constructs a [`ClusterParameterStatus`](crate::model::ClusterParameterStatus)
        pub fn build(self) -> crate::model::ClusterParameterStatus {
            crate::model::ClusterParameterStatus {
                parameter_name: self.parameter_name,
                parameter_apply_status: self.parameter_apply_status,
                parameter_apply_error_description: self.parameter_apply_error_description,
            }
        }
    }
}
impl ClusterParameterStatus {
    /// Creates a new builder-style object to manufacture [`ClusterParameterStatus`](crate::model::ClusterParameterStatus)
    pub fn builder() -> crate::model::cluster_parameter_status::Builder {
        crate::model::cluster_parameter_status::Builder::default()
    }
}

/// <p>Describes the members of a VPC security group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VpcSecurityGroupMembership {
    /// <p>The identifier of the VPC security group.</p>
    pub vpc_security_group_id: std::option::Option<std::string::String>,
    /// <p>The status of the VPC security group.</p>
    pub status: std::option::Option<std::string::String>,
}
impl VpcSecurityGroupMembership {
    /// <p>The identifier of the VPC security group.</p>
    pub fn vpc_security_group_id(&self) -> std::option::Option<&str> {
        self.vpc_security_group_id.as_deref()
    }
    /// <p>The status of the VPC security group.</p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
}
impl std::fmt::Debug for VpcSecurityGroupMembership {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VpcSecurityGroupMembership");
        formatter.field("vpc_security_group_id", &self.vpc_security_group_id);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`VpcSecurityGroupMembership`](crate::model::VpcSecurityGroupMembership)
pub mod vpc_security_group_membership {
    /// A builder for [`VpcSecurityGroupMembership`](crate::model::VpcSecurityGroupMembership)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) vpc_security_group_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the VPC security group.</p>
        pub fn vpc_security_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_security_group_id = Some(input.into());
            self
        }
        /// <p>The identifier of the VPC security group.</p>
        pub fn set_vpc_security_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.vpc_security_group_id = input;
            self
        }
        /// <p>The status of the VPC security group.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the VPC security group.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`VpcSecurityGroupMembership`](crate::model::VpcSecurityGroupMembership)
        pub fn build(self) -> crate::model::VpcSecurityGroupMembership {
            crate::model::VpcSecurityGroupMembership {
                vpc_security_group_id: self.vpc_security_group_id,
                status: self.status,
            }
        }
    }
}
impl VpcSecurityGroupMembership {
    /// Creates a new builder-style object to manufacture [`VpcSecurityGroupMembership`](crate::model::VpcSecurityGroupMembership)
    pub fn builder() -> crate::model::vpc_security_group_membership::Builder {
        crate::model::vpc_security_group_membership::Builder::default()
    }
}

/// <p>Describes a cluster security group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ClusterSecurityGroupMembership {
    /// <p>The name of the cluster security group.</p>
    pub cluster_security_group_name: std::option::Option<std::string::String>,
    /// <p>The status of the cluster security group.</p>
    pub status: std::option::Option<std::string::String>,
}
impl ClusterSecurityGroupMembership {
    /// <p>The name of the cluster security group.</p>
    pub fn cluster_security_group_name(&self) -> std::option::Option<&str> {
        self.cluster_security_group_name.as_deref()
    }
    /// <p>The status of the cluster security group.</p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
}
impl std::fmt::Debug for ClusterSecurityGroupMembership {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ClusterSecurityGroupMembership");
        formatter.field(
            "cluster_security_group_name",
            &self.cluster_security_group_name,
        );
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`ClusterSecurityGroupMembership`](crate::model::ClusterSecurityGroupMembership)
pub mod cluster_security_group_membership {
    /// A builder for [`ClusterSecurityGroupMembership`](crate::model::ClusterSecurityGroupMembership)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_security_group_name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the cluster security group.</p>
        pub fn cluster_security_group_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.cluster_security_group_name = Some(input.into());
            self
        }
        /// <p>The name of the cluster security group.</p>
        pub fn set_cluster_security_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cluster_security_group_name = input;
            self
        }
        /// <p>The status of the cluster security group.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the cluster security group.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`ClusterSecurityGroupMembership`](crate::model::ClusterSecurityGroupMembership)
        pub fn build(self) -> crate::model::ClusterSecurityGroupMembership {
            crate::model::ClusterSecurityGroupMembership {
                cluster_security_group_name: self.cluster_security_group_name,
                status: self.status,
            }
        }
    }
}
impl ClusterSecurityGroupMembership {
    /// Creates a new builder-style object to manufacture [`ClusterSecurityGroupMembership`](crate::model::ClusterSecurityGroupMembership)
    pub fn builder() -> crate::model::cluster_security_group_membership::Builder {
        crate::model::cluster_security_group_membership::Builder::default()
    }
}

/// <p>Describes a connection endpoint.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Endpoint {
    /// <p>The DNS address of the Cluster.</p>
    pub address: std::option::Option<std::string::String>,
    /// <p>The port that the database engine is listening on.</p>
    pub port: i32,
    /// <p>Describes a connection endpoint.</p>
    pub vpc_endpoints: std::option::Option<std::vec::Vec<crate::model::VpcEndpoint>>,
}
impl Endpoint {
    /// <p>The DNS address of the Cluster.</p>
    pub fn address(&self) -> std::option::Option<&str> {
        self.address.as_deref()
    }
    /// <p>The port that the database engine is listening on.</p>
    pub fn port(&self) -> i32 {
        self.port
    }
    /// <p>Describes a connection endpoint.</p>
    pub fn vpc_endpoints(&self) -> std::option::Option<&[crate::model::VpcEndpoint]> {
        self.vpc_endpoints.as_deref()
    }
}
impl std::fmt::Debug for Endpoint {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Endpoint");
        formatter.field("address", &self.address);
        formatter.field("port", &self.port);
        formatter.field("vpc_endpoints", &self.vpc_endpoints);
        formatter.finish()
    }
}
/// See [`Endpoint`](crate::model::Endpoint)
pub mod endpoint {
    /// A builder for [`Endpoint`](crate::model::Endpoint)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) address: std::option::Option<std::string::String>,
        pub(crate) port: std::option::Option<i32>,
        pub(crate) vpc_endpoints: std::option::Option<std::vec::Vec<crate::model::VpcEndpoint>>,
    }
    impl Builder {
        /// <p>The DNS address of the Cluster.</p>
        pub fn address(mut self, input: impl Into<std::string::String>) -> Self {
            self.address = Some(input.into());
            self
        }
        /// <p>The DNS address of the Cluster.</p>
        pub fn set_address(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.address = input;
            self
        }
        /// <p>The port that the database engine is listening on.</p>
        pub fn port(mut self, input: i32) -> Self {
            self.port = Some(input);
            self
        }
        /// <p>The port that the database engine is listening on.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.port = input;
            self
        }
        /// Appends an item to `vpc_endpoints`.
        ///
        /// To override the contents of this collection use [`set_vpc_endpoints`](Self::set_vpc_endpoints).
        ///
        /// <p>Describes a connection endpoint.</p>
        pub fn vpc_endpoints(mut self, input: crate::model::VpcEndpoint) -> Self {
            let mut v = self.vpc_endpoints.unwrap_or_default();
            v.push(input);
            self.vpc_endpoints = Some(v);
            self
        }
        /// <p>Describes a connection endpoint.</p>
        pub fn set_vpc_endpoints(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::VpcEndpoint>>,
        ) -> Self {
            self.vpc_endpoints = input;
            self
        }
        /// Consumes the builder and constructs a [`Endpoint`](crate::model::Endpoint)
        pub fn build(self) -> crate::model::Endpoint {
            crate::model::Endpoint {
                address: self.address,
                port: self.port.unwrap_or_default(),
                vpc_endpoints: self.vpc_endpoints,
            }
        }
    }
}
impl Endpoint {
    /// Creates a new builder-style object to manufacture [`Endpoint`](crate::model::Endpoint)
    pub fn builder() -> crate::model::endpoint::Builder {
        crate::model::endpoint::Builder::default()
    }
}

/// <p>The connection endpoint for connecting to an Amazon Redshift cluster through the proxy.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VpcEndpoint {
    /// <p>The connection endpoint ID for connecting an Amazon Redshift cluster through the proxy.</p>
    pub vpc_endpoint_id: std::option::Option<std::string::String>,
    /// <p>The VPC identifier that the endpoint is associated. </p>
    pub vpc_id: std::option::Option<std::string::String>,
    /// <p>One or more network interfaces of the endpoint. Also known as an interface endpoint. </p>
    pub network_interfaces: std::option::Option<std::vec::Vec<crate::model::NetworkInterface>>,
}
impl VpcEndpoint {
    /// <p>The connection endpoint ID for connecting an Amazon Redshift cluster through the proxy.</p>
    pub fn vpc_endpoint_id(&self) -> std::option::Option<&str> {
        self.vpc_endpoint_id.as_deref()
    }
    /// <p>The VPC identifier that the endpoint is associated. </p>
    pub fn vpc_id(&self) -> std::option::Option<&str> {
        self.vpc_id.as_deref()
    }
    /// <p>One or more network interfaces of the endpoint. Also known as an interface endpoint. </p>
    pub fn network_interfaces(&self) -> std::option::Option<&[crate::model::NetworkInterface]> {
        self.network_interfaces.as_deref()
    }
}
impl std::fmt::Debug for VpcEndpoint {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VpcEndpoint");
        formatter.field("vpc_endpoint_id", &self.vpc_endpoint_id);
        formatter.field("vpc_id", &self.vpc_id);
        formatter.field("network_interfaces", &self.network_interfaces);
        formatter.finish()
    }
}
/// See [`VpcEndpoint`](crate::model::VpcEndpoint)
pub mod vpc_endpoint {
    /// A builder for [`VpcEndpoint`](crate::model::VpcEndpoint)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) vpc_endpoint_id: std::option::Option<std::string::String>,
        pub(crate) vpc_id: std::option::Option<std::string::String>,
        pub(crate) network_interfaces:
            std::option::Option<std::vec::Vec<crate::model::NetworkInterface>>,
    }
    impl Builder {
        /// <p>The connection endpoint ID for connecting an Amazon Redshift cluster through the proxy.</p>
        pub fn vpc_endpoint_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_endpoint_id = Some(input.into());
            self
        }
        /// <p>The connection endpoint ID for connecting an Amazon Redshift cluster through the proxy.</p>
        pub fn set_vpc_endpoint_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.vpc_endpoint_id = input;
            self
        }
        /// <p>The VPC identifier that the endpoint is associated. </p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_id = Some(input.into());
            self
        }
        /// <p>The VPC identifier that the endpoint is associated. </p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_id = input;
            self
        }
        /// Appends an item to `network_interfaces`.
        ///
        /// To override the contents of this collection use [`set_network_interfaces`](Self::set_network_interfaces).
        ///
        /// <p>One or more network interfaces of the endpoint. Also known as an interface endpoint. </p>
        pub fn network_interfaces(mut self, input: crate::model::NetworkInterface) -> Self {
            let mut v = self.network_interfaces.unwrap_or_default();
            v.push(input);
            self.network_interfaces = Some(v);
            self
        }
        /// <p>One or more network interfaces of the endpoint. Also known as an interface endpoint. </p>
        pub fn set_network_interfaces(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::NetworkInterface>>,
        ) -> Self {
            self.network_interfaces = input;
            self
        }
        /// Consumes the builder and constructs a [`VpcEndpoint`](crate::model::VpcEndpoint)
        pub fn build(self) -> crate::model::VpcEndpoint {
            crate::model::VpcEndpoint {
                vpc_endpoint_id: self.vpc_endpoint_id,
                vpc_id: self.vpc_id,
                network_interfaces: self.network_interfaces,
            }
        }
    }
}
impl VpcEndpoint {
    /// Creates a new builder-style object to manufacture [`VpcEndpoint`](crate::model::VpcEndpoint)
    pub fn builder() -> crate::model::vpc_endpoint::Builder {
        crate::model::vpc_endpoint::Builder::default()
    }
}

/// <p>Describes a network interface. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NetworkInterface {
    /// <p>The network interface identifier. </p>
    pub network_interface_id: std::option::Option<std::string::String>,
    /// <p>The subnet identifier. </p>
    pub subnet_id: std::option::Option<std::string::String>,
    /// <p>The IPv4 address of the network interface within the subnet. </p>
    pub private_ip_address: std::option::Option<std::string::String>,
    /// <p>The Availability Zone. </p>
    pub availability_zone: std::option::Option<std::string::String>,
}
impl NetworkInterface {
    /// <p>The network interface identifier. </p>
    pub fn network_interface_id(&self) -> std::option::Option<&str> {
        self.network_interface_id.as_deref()
    }
    /// <p>The subnet identifier. </p>
    pub fn subnet_id(&self) -> std::option::Option<&str> {
        self.subnet_id.as_deref()
    }
    /// <p>The IPv4 address of the network interface within the subnet. </p>
    pub fn private_ip_address(&self) -> std::option::Option<&str> {
        self.private_ip_address.as_deref()
    }
    /// <p>The Availability Zone. </p>
    pub fn availability_zone(&self) -> std::option::Option<&str> {
        self.availability_zone.as_deref()
    }
}
impl std::fmt::Debug for NetworkInterface {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NetworkInterface");
        formatter.field("network_interface_id", &self.network_interface_id);
        formatter.field("subnet_id", &self.subnet_id);
        formatter.field("private_ip_address", &self.private_ip_address);
        formatter.field("availability_zone", &self.availability_zone);
        formatter.finish()
    }
}
/// See [`NetworkInterface`](crate::model::NetworkInterface)
pub mod network_interface {
    /// A builder for [`NetworkInterface`](crate::model::NetworkInterface)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) network_interface_id: std::option::Option<std::string::String>,
        pub(crate) subnet_id: std::option::Option<std::string::String>,
        pub(crate) private_ip_address: std::option::Option<std::string::String>,
        pub(crate) availability_zone: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The network interface identifier. </p>
        pub fn network_interface_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.network_interface_id = Some(input.into());
            self
        }
        /// <p>The network interface identifier. </p>
        pub fn set_network_interface_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.network_interface_id = input;
            self
        }
        /// <p>The subnet identifier. </p>
        pub fn subnet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.subnet_id = Some(input.into());
            self
        }
        /// <p>The subnet identifier. </p>
        pub fn set_subnet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.subnet_id = input;
            self
        }
        /// <p>The IPv4 address of the network interface within the subnet. </p>
        pub fn private_ip_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.private_ip_address = Some(input.into());
            self
        }
        /// <p>The IPv4 address of the network interface within the subnet. </p>
        pub fn set_private_ip_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.private_ip_address = input;
            self
        }
        /// <p>The Availability Zone. </p>
        pub fn availability_zone(mut self, input: impl Into<std::string::String>) -> Self {
            self.availability_zone = Some(input.into());
            self
        }
        /// <p>The Availability Zone. </p>
        pub fn set_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.availability_zone = input;
            self
        }
        /// Consumes the builder and constructs a [`NetworkInterface`](crate::model::NetworkInterface)
        pub fn build(self) -> crate::model::NetworkInterface {
            crate::model::NetworkInterface {
                network_interface_id: self.network_interface_id,
                subnet_id: self.subnet_id,
                private_ip_address: self.private_ip_address,
                availability_zone: self.availability_zone,
            }
        }
    }
}
impl NetworkInterface {
    /// Creates a new builder-style object to manufacture [`NetworkInterface`](crate::model::NetworkInterface)
    pub fn builder() -> crate::model::network_interface::Builder {
        crate::model::network_interface::Builder::default()
    }
}

/// <p>Describes a snapshot.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Snapshot {
    /// <p>The snapshot identifier that is provided in the request.</p>
    pub snapshot_identifier: std::option::Option<std::string::String>,
    /// <p>The identifier of the cluster for which the snapshot was taken.</p>
    pub cluster_identifier: std::option::Option<std::string::String>,
    /// <p>The time (in UTC format) when Amazon Redshift began the snapshot. A snapshot contains a copy of the cluster data as of this exact time.</p>
    pub snapshot_create_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The snapshot status. The value of the status depends on the API operation used: </p>
    /// <ul>
    /// <li> <p> <code>CreateClusterSnapshot</code> and <code>CopyClusterSnapshot</code> returns status as "creating". </p> </li>
    /// <li> <p> <code>DescribeClusterSnapshots</code> returns status as "creating", "available", "final snapshot", or "failed".</p> </li>
    /// <li> <p> <code>DeleteClusterSnapshot</code> returns status as "deleted".</p> </li>
    /// </ul>
    pub status: std::option::Option<std::string::String>,
    /// <p>The port that the cluster is listening on.</p>
    pub port: i32,
    /// <p>The Availability Zone in which the cluster was created.</p>
    pub availability_zone: std::option::Option<std::string::String>,
    /// <p>The time (UTC) when the cluster was originally created.</p>
    pub cluster_create_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The admin user name for the cluster.</p>
    pub master_username: std::option::Option<std::string::String>,
    /// <p>The version ID of the Amazon Redshift engine that is running on the cluster.</p>
    pub cluster_version: std::option::Option<std::string::String>,
    /// <p>The cluster version of the cluster used to create the snapshot. For example, 1.0.15503. </p>
    pub engine_full_version: std::option::Option<std::string::String>,
    /// <p>The snapshot type. Snapshots created using <code>CreateClusterSnapshot</code> and <code>CopyClusterSnapshot</code> are of type "manual". </p>
    pub snapshot_type: std::option::Option<std::string::String>,
    /// <p>The node type of the nodes in the cluster.</p>
    pub node_type: std::option::Option<std::string::String>,
    /// <p>The number of nodes in the cluster.</p>
    pub number_of_nodes: i32,
    /// <p>The name of the database that was created when the cluster was created.</p>
    pub db_name: std::option::Option<std::string::String>,
    /// <p>The VPC identifier of the cluster if the snapshot is from a cluster in a VPC. Otherwise, this field is not in the output.</p>
    pub vpc_id: std::option::Option<std::string::String>,
    /// <p>If <code>true</code>, the data in the snapshot is encrypted at rest.</p>
    pub encrypted: bool,
    /// <p>The Key Management Service (KMS) key ID of the encryption key that was used to encrypt data in the cluster from which the snapshot was taken.</p>
    pub kms_key_id: std::option::Option<std::string::String>,
    /// <p>A boolean that indicates whether the snapshot data is encrypted using the HSM keys of the source cluster. <code>true</code> indicates that the data is encrypted using HSM keys.</p>
    pub encrypted_with_hsm: bool,
    /// <p>A list of the Amazon Web Services accounts authorized to restore the snapshot. Returns <code>null</code> if no accounts are authorized. Visible only to the snapshot owner. </p>
    pub accounts_with_restore_access:
        std::option::Option<std::vec::Vec<crate::model::AccountWithRestoreAccess>>,
    /// <p>For manual snapshots, the Amazon Web Services account used to create or copy the snapshot. For automatic snapshots, the owner of the cluster. The owner can perform all snapshot actions, such as sharing a manual snapshot.</p>
    pub owner_account: std::option::Option<std::string::String>,
    /// <p>The size of the complete set of backup data that would be used to restore the cluster.</p>
    pub total_backup_size_in_mega_bytes: f64,
    /// <p>The size of the incremental backup.</p>
    pub actual_incremental_backup_size_in_mega_bytes: f64,
    /// <p>The number of megabytes that have been transferred to the snapshot backup.</p>
    pub backup_progress_in_mega_bytes: f64,
    /// <p>The number of megabytes per second being transferred to the snapshot backup. Returns <code>0</code> for a completed backup. </p>
    pub current_backup_rate_in_mega_bytes_per_second: f64,
    /// <p>The estimate of the time remaining before the snapshot backup will complete. Returns <code>0</code> for a completed backup. </p>
    pub estimated_seconds_to_completion: i64,
    /// <p>The amount of time an in-progress snapshot backup has been running, or the amount of time it took a completed backup to finish.</p>
    pub elapsed_time_in_seconds: i64,
    /// <p>The source region from which the snapshot was copied.</p>
    pub source_region: std::option::Option<std::string::String>,
    /// <p>The list of tags for the cluster snapshot.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The list of node types that this cluster snapshot is able to restore into.</p>
    pub restorable_node_types: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>An option that specifies whether to create the cluster with enhanced VPC routing enabled. To create a cluster that uses enhanced VPC routing, the cluster must be in a VPC. For more information, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html">Enhanced VPC Routing</a> in the Amazon Redshift Cluster Management Guide.</p>
    /// <p>If this option is <code>true</code>, enhanced VPC routing is enabled. </p>
    /// <p>Default: false</p>
    pub enhanced_vpc_routing: bool,
    /// <p>The name of the maintenance track for the snapshot.</p>
    pub maintenance_track_name: std::option::Option<std::string::String>,
    /// <p>The number of days that a manual snapshot is retained. If the value is -1, the manual snapshot is retained indefinitely. </p>
    /// <p>The value must be either -1 or an integer between 1 and 3,653.</p>
    pub manual_snapshot_retention_period: std::option::Option<i32>,
    /// <p>The number of days until a manual snapshot will pass its retention period.</p>
    pub manual_snapshot_remaining_days: std::option::Option<i32>,
    /// <p>A timestamp representing the start of the retention period for the snapshot.</p>
    pub snapshot_retention_start_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl Snapshot {
    /// <p>The snapshot identifier that is provided in the request.</p>
    pub fn snapshot_identifier(&self) -> std::option::Option<&str> {
        self.snapshot_identifier.as_deref()
    }
    /// <p>The identifier of the cluster for which the snapshot was taken.</p>
    pub fn cluster_identifier(&self) -> std::option::Option<&str> {
        self.cluster_identifier.as_deref()
    }
    /// <p>The time (in UTC format) when Amazon Redshift began the snapshot. A snapshot contains a copy of the cluster data as of this exact time.</p>
    pub fn snapshot_create_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.snapshot_create_time.as_ref()
    }
    /// <p>The snapshot status. The value of the status depends on the API operation used: </p>
    /// <ul>
    /// <li> <p> <code>CreateClusterSnapshot</code> and <code>CopyClusterSnapshot</code> returns status as "creating". </p> </li>
    /// <li> <p> <code>DescribeClusterSnapshots</code> returns status as "creating", "available", "final snapshot", or "failed".</p> </li>
    /// <li> <p> <code>DeleteClusterSnapshot</code> returns status as "deleted".</p> </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>The port that the cluster is listening on.</p>
    pub fn port(&self) -> i32 {
        self.port
    }
    /// <p>The Availability Zone in which the cluster was created.</p>
    pub fn availability_zone(&self) -> std::option::Option<&str> {
        self.availability_zone.as_deref()
    }
    /// <p>The time (UTC) when the cluster was originally created.</p>
    pub fn cluster_create_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.cluster_create_time.as_ref()
    }
    /// <p>The admin user name for the cluster.</p>
    pub fn master_username(&self) -> std::option::Option<&str> {
        self.master_username.as_deref()
    }
    /// <p>The version ID of the Amazon Redshift engine that is running on the cluster.</p>
    pub fn cluster_version(&self) -> std::option::Option<&str> {
        self.cluster_version.as_deref()
    }
    /// <p>The cluster version of the cluster used to create the snapshot. For example, 1.0.15503. </p>
    pub fn engine_full_version(&self) -> std::option::Option<&str> {
        self.engine_full_version.as_deref()
    }
    /// <p>The snapshot type. Snapshots created using <code>CreateClusterSnapshot</code> and <code>CopyClusterSnapshot</code> are of type "manual". </p>
    pub fn snapshot_type(&self) -> std::option::Option<&str> {
        self.snapshot_type.as_deref()
    }
    /// <p>The node type of the nodes in the cluster.</p>
    pub fn node_type(&self) -> std::option::Option<&str> {
        self.node_type.as_deref()
    }
    /// <p>The number of nodes in the cluster.</p>
    pub fn number_of_nodes(&self) -> i32 {
        self.number_of_nodes
    }
    /// <p>The name of the database that was created when the cluster was created.</p>
    pub fn db_name(&self) -> std::option::Option<&str> {
        self.db_name.as_deref()
    }
    /// <p>The VPC identifier of the cluster if the snapshot is from a cluster in a VPC. Otherwise, this field is not in the output.</p>
    pub fn vpc_id(&self) -> std::option::Option<&str> {
        self.vpc_id.as_deref()
    }
    /// <p>If <code>true</code>, the data in the snapshot is encrypted at rest.</p>
    pub fn encrypted(&self) -> bool {
        self.encrypted
    }
    /// <p>The Key Management Service (KMS) key ID of the encryption key that was used to encrypt data in the cluster from which the snapshot was taken.</p>
    pub fn kms_key_id(&self) -> std::option::Option<&str> {
        self.kms_key_id.as_deref()
    }
    /// <p>A boolean that indicates whether the snapshot data is encrypted using the HSM keys of the source cluster. <code>true</code> indicates that the data is encrypted using HSM keys.</p>
    pub fn encrypted_with_hsm(&self) -> bool {
        self.encrypted_with_hsm
    }
    /// <p>A list of the Amazon Web Services accounts authorized to restore the snapshot. Returns <code>null</code> if no accounts are authorized. Visible only to the snapshot owner. </p>
    pub fn accounts_with_restore_access(
        &self,
    ) -> std::option::Option<&[crate::model::AccountWithRestoreAccess]> {
        self.accounts_with_restore_access.as_deref()
    }
    /// <p>For manual snapshots, the Amazon Web Services account used to create or copy the snapshot. For automatic snapshots, the owner of the cluster. The owner can perform all snapshot actions, such as sharing a manual snapshot.</p>
    pub fn owner_account(&self) -> std::option::Option<&str> {
        self.owner_account.as_deref()
    }
    /// <p>The size of the complete set of backup data that would be used to restore the cluster.</p>
    pub fn total_backup_size_in_mega_bytes(&self) -> f64 {
        self.total_backup_size_in_mega_bytes
    }
    /// <p>The size of the incremental backup.</p>
    pub fn actual_incremental_backup_size_in_mega_bytes(&self) -> f64 {
        self.actual_incremental_backup_size_in_mega_bytes
    }
    /// <p>The number of megabytes that have been transferred to the snapshot backup.</p>
    pub fn backup_progress_in_mega_bytes(&self) -> f64 {
        self.backup_progress_in_mega_bytes
    }
    /// <p>The number of megabytes per second being transferred to the snapshot backup. Returns <code>0</code> for a completed backup. </p>
    pub fn current_backup_rate_in_mega_bytes_per_second(&self) -> f64 {
        self.current_backup_rate_in_mega_bytes_per_second
    }
    /// <p>The estimate of the time remaining before the snapshot backup will complete. Returns <code>0</code> for a completed backup. </p>
    pub fn estimated_seconds_to_completion(&self) -> i64 {
        self.estimated_seconds_to_completion
    }
    /// <p>The amount of time an in-progress snapshot backup has been running, or the amount of time it took a completed backup to finish.</p>
    pub fn elapsed_time_in_seconds(&self) -> i64 {
        self.elapsed_time_in_seconds
    }
    /// <p>The source region from which the snapshot was copied.</p>
    pub fn source_region(&self) -> std::option::Option<&str> {
        self.source_region.as_deref()
    }
    /// <p>The list of tags for the cluster snapshot.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>The list of node types that this cluster snapshot is able to restore into.</p>
    pub fn restorable_node_types(&self) -> std::option::Option<&[std::string::String]> {
        self.restorable_node_types.as_deref()
    }
    /// <p>An option that specifies whether to create the cluster with enhanced VPC routing enabled. To create a cluster that uses enhanced VPC routing, the cluster must be in a VPC. For more information, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html">Enhanced VPC Routing</a> in the Amazon Redshift Cluster Management Guide.</p>
    /// <p>If this option is <code>true</code>, enhanced VPC routing is enabled. </p>
    /// <p>Default: false</p>
    pub fn enhanced_vpc_routing(&self) -> bool {
        self.enhanced_vpc_routing
    }
    /// <p>The name of the maintenance track for the snapshot.</p>
    pub fn maintenance_track_name(&self) -> std::option::Option<&str> {
        self.maintenance_track_name.as_deref()
    }
    /// <p>The number of days that a manual snapshot is retained. If the value is -1, the manual snapshot is retained indefinitely. </p>
    /// <p>The value must be either -1 or an integer between 1 and 3,653.</p>
    pub fn manual_snapshot_retention_period(&self) -> std::option::Option<i32> {
        self.manual_snapshot_retention_period
    }
    /// <p>The number of days until a manual snapshot will pass its retention period.</p>
    pub fn manual_snapshot_remaining_days(&self) -> std::option::Option<i32> {
        self.manual_snapshot_remaining_days
    }
    /// <p>A timestamp representing the start of the retention period for the snapshot.</p>
    pub fn snapshot_retention_start_time(
        &self,
    ) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.snapshot_retention_start_time.as_ref()
    }
}
impl std::fmt::Debug for Snapshot {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Snapshot");
        formatter.field("snapshot_identifier", &self.snapshot_identifier);
        formatter.field("cluster_identifier", &self.cluster_identifier);
        formatter.field("snapshot_create_time", &self.snapshot_create_time);
        formatter.field("status", &self.status);
        formatter.field("port", &self.port);
        formatter.field("availability_zone", &self.availability_zone);
        formatter.field("cluster_create_time", &self.cluster_create_time);
        formatter.field("master_username", &self.master_username);
        formatter.field("cluster_version", &self.cluster_version);
        formatter.field("engine_full_version", &self.engine_full_version);
        formatter.field("snapshot_type", &self.snapshot_type);
        formatter.field("node_type", &self.node_type);
        formatter.field("number_of_nodes", &self.number_of_nodes);
        formatter.field("db_name", &self.db_name);
        formatter.field("vpc_id", &self.vpc_id);
        formatter.field("encrypted", &self.encrypted);
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.field("encrypted_with_hsm", &self.encrypted_with_hsm);
        formatter.field(
            "accounts_with_restore_access",
            &self.accounts_with_restore_access,
        );
        formatter.field("owner_account", &self.owner_account);
        formatter.field(
            "total_backup_size_in_mega_bytes",
            &self.total_backup_size_in_mega_bytes,
        );
        formatter.field(
            "actual_incremental_backup_size_in_mega_bytes",
            &self.actual_incremental_backup_size_in_mega_bytes,
        );
        formatter.field(
            "backup_progress_in_mega_bytes",
            &self.backup_progress_in_mega_bytes,
        );
        formatter.field(
            "current_backup_rate_in_mega_bytes_per_second",
            &self.current_backup_rate_in_mega_bytes_per_second,
        );
        formatter.field(
            "estimated_seconds_to_completion",
            &self.estimated_seconds_to_completion,
        );
        formatter.field("elapsed_time_in_seconds", &self.elapsed_time_in_seconds);
        formatter.field("source_region", &self.source_region);
        formatter.field("tags", &self.tags);
        formatter.field("restorable_node_types", &self.restorable_node_types);
        formatter.field("enhanced_vpc_routing", &self.enhanced_vpc_routing);
        formatter.field("maintenance_track_name", &self.maintenance_track_name);
        formatter.field(
            "manual_snapshot_retention_period",
            &self.manual_snapshot_retention_period,
        );
        formatter.field(
            "manual_snapshot_remaining_days",
            &self.manual_snapshot_remaining_days,
        );
        formatter.field(
            "snapshot_retention_start_time",
            &self.snapshot_retention_start_time,
        );
        formatter.finish()
    }
}
/// See [`Snapshot`](crate::model::Snapshot)
pub mod snapshot {
    /// A builder for [`Snapshot`](crate::model::Snapshot)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) snapshot_identifier: std::option::Option<std::string::String>,
        pub(crate) cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) snapshot_create_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) port: std::option::Option<i32>,
        pub(crate) availability_zone: std::option::Option<std::string::String>,
        pub(crate) cluster_create_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) master_username: std::option::Option<std::string::String>,
        pub(crate) cluster_version: std::option::Option<std::string::String>,
        pub(crate) engine_full_version: std::option::Option<std::string::String>,
        pub(crate) snapshot_type: std::option::Option<std::string::String>,
        pub(crate) node_type: std::option::Option<std::string::String>,
        pub(crate) number_of_nodes: std::option::Option<i32>,
        pub(crate) db_name: std::option::Option<std::string::String>,
        pub(crate) vpc_id: std::option::Option<std::string::String>,
        pub(crate) encrypted: std::option::Option<bool>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
        pub(crate) encrypted_with_hsm: std::option::Option<bool>,
        pub(crate) accounts_with_restore_access:
            std::option::Option<std::vec::Vec<crate::model::AccountWithRestoreAccess>>,
        pub(crate) owner_account: std::option::Option<std::string::String>,
        pub(crate) total_backup_size_in_mega_bytes: std::option::Option<f64>,
        pub(crate) actual_incremental_backup_size_in_mega_bytes: std::option::Option<f64>,
        pub(crate) backup_progress_in_mega_bytes: std::option::Option<f64>,
        pub(crate) current_backup_rate_in_mega_bytes_per_second: std::option::Option<f64>,
        pub(crate) estimated_seconds_to_completion: std::option::Option<i64>,
        pub(crate) elapsed_time_in_seconds: std::option::Option<i64>,
        pub(crate) source_region: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) restorable_node_types: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) enhanced_vpc_routing: std::option::Option<bool>,
        pub(crate) maintenance_track_name: std::option::Option<std::string::String>,
        pub(crate) manual_snapshot_retention_period: std::option::Option<i32>,
        pub(crate) manual_snapshot_remaining_days: std::option::Option<i32>,
        pub(crate) snapshot_retention_start_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The snapshot identifier that is provided in the request.</p>
        pub fn snapshot_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.snapshot_identifier = Some(input.into());
            self
        }
        /// <p>The snapshot identifier that is provided in the request.</p>
        pub fn set_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.snapshot_identifier = input;
            self
        }
        /// <p>The identifier of the cluster for which the snapshot was taken.</p>
        pub fn cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_identifier = Some(input.into());
            self
        }
        /// <p>The identifier of the cluster for which the snapshot was taken.</p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cluster_identifier = input;
            self
        }
        /// <p>The time (in UTC format) when Amazon Redshift began the snapshot. A snapshot contains a copy of the cluster data as of this exact time.</p>
        pub fn snapshot_create_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.snapshot_create_time = Some(input);
            self
        }
        /// <p>The time (in UTC format) when Amazon Redshift began the snapshot. A snapshot contains a copy of the cluster data as of this exact time.</p>
        pub fn set_snapshot_create_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.snapshot_create_time = input;
            self
        }
        /// <p>The snapshot status. The value of the status depends on the API operation used: </p>
        /// <ul>
        /// <li> <p> <code>CreateClusterSnapshot</code> and <code>CopyClusterSnapshot</code> returns status as "creating". </p> </li>
        /// <li> <p> <code>DescribeClusterSnapshots</code> returns status as "creating", "available", "final snapshot", or "failed".</p> </li>
        /// <li> <p> <code>DeleteClusterSnapshot</code> returns status as "deleted".</p> </li>
        /// </ul>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The snapshot status. The value of the status depends on the API operation used: </p>
        /// <ul>
        /// <li> <p> <code>CreateClusterSnapshot</code> and <code>CopyClusterSnapshot</code> returns status as "creating". </p> </li>
        /// <li> <p> <code>DescribeClusterSnapshots</code> returns status as "creating", "available", "final snapshot", or "failed".</p> </li>
        /// <li> <p> <code>DeleteClusterSnapshot</code> returns status as "deleted".</p> </li>
        /// </ul>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>The port that the cluster is listening on.</p>
        pub fn port(mut self, input: i32) -> Self {
            self.port = Some(input);
            self
        }
        /// <p>The port that the cluster is listening on.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.port = input;
            self
        }
        /// <p>The Availability Zone in which the cluster was created.</p>
        pub fn availability_zone(mut self, input: impl Into<std::string::String>) -> Self {
            self.availability_zone = Some(input.into());
            self
        }
        /// <p>The Availability Zone in which the cluster was created.</p>
        pub fn set_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.availability_zone = input;
            self
        }
        /// <p>The time (UTC) when the cluster was originally created.</p>
        pub fn cluster_create_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.cluster_create_time = Some(input);
            self
        }
        /// <p>The time (UTC) when the cluster was originally created.</p>
        pub fn set_cluster_create_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.cluster_create_time = input;
            self
        }
        /// <p>The admin user name for the cluster.</p>
        pub fn master_username(mut self, input: impl Into<std::string::String>) -> Self {
            self.master_username = Some(input.into());
            self
        }
        /// <p>The admin user name for the cluster.</p>
        pub fn set_master_username(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.master_username = input;
            self
        }
        /// <p>The version ID of the Amazon Redshift engine that is running on the cluster.</p>
        pub fn cluster_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_version = Some(input.into());
            self
        }
        /// <p>The version ID of the Amazon Redshift engine that is running on the cluster.</p>
        pub fn set_cluster_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cluster_version = input;
            self
        }
        /// <p>The cluster version of the cluster used to create the snapshot. For example, 1.0.15503. </p>
        pub fn engine_full_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_full_version = Some(input.into());
            self
        }
        /// <p>The cluster version of the cluster used to create the snapshot. For example, 1.0.15503. </p>
        pub fn set_engine_full_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.engine_full_version = input;
            self
        }
        /// <p>The snapshot type. Snapshots created using <code>CreateClusterSnapshot</code> and <code>CopyClusterSnapshot</code> are of type "manual". </p>
        pub fn snapshot_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.snapshot_type = Some(input.into());
            self
        }
        /// <p>The snapshot type. Snapshots created using <code>CreateClusterSnapshot</code> and <code>CopyClusterSnapshot</code> are of type "manual". </p>
        pub fn set_snapshot_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.snapshot_type = input;
            self
        }
        /// <p>The node type of the nodes in the cluster.</p>
        pub fn node_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.node_type = Some(input.into());
            self
        }
        /// <p>The node type of the nodes in the cluster.</p>
        pub fn set_node_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.node_type = input;
            self
        }
        /// <p>The number of nodes in the cluster.</p>
        pub fn number_of_nodes(mut self, input: i32) -> Self {
            self.number_of_nodes = Some(input);
            self
        }
        /// <p>The number of nodes in the cluster.</p>
        pub fn set_number_of_nodes(mut self, input: std::option::Option<i32>) -> Self {
            self.number_of_nodes = input;
            self
        }
        /// <p>The name of the database that was created when the cluster was created.</p>
        pub fn db_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_name = Some(input.into());
            self
        }
        /// <p>The name of the database that was created when the cluster was created.</p>
        pub fn set_db_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.db_name = input;
            self
        }
        /// <p>The VPC identifier of the cluster if the snapshot is from a cluster in a VPC. Otherwise, this field is not in the output.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_id = Some(input.into());
            self
        }
        /// <p>The VPC identifier of the cluster if the snapshot is from a cluster in a VPC. Otherwise, this field is not in the output.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_id = input;
            self
        }
        /// <p>If <code>true</code>, the data in the snapshot is encrypted at rest.</p>
        pub fn encrypted(mut self, input: bool) -> Self {
            self.encrypted = Some(input);
            self
        }
        /// <p>If <code>true</code>, the data in the snapshot is encrypted at rest.</p>
        pub fn set_encrypted(mut self, input: std::option::Option<bool>) -> Self {
            self.encrypted = input;
            self
        }
        /// <p>The Key Management Service (KMS) key ID of the encryption key that was used to encrypt data in the cluster from which the snapshot was taken.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>The Key Management Service (KMS) key ID of the encryption key that was used to encrypt data in the cluster from which the snapshot was taken.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// <p>A boolean that indicates whether the snapshot data is encrypted using the HSM keys of the source cluster. <code>true</code> indicates that the data is encrypted using HSM keys.</p>
        pub fn encrypted_with_hsm(mut self, input: bool) -> Self {
            self.encrypted_with_hsm = Some(input);
            self
        }
        /// <p>A boolean that indicates whether the snapshot data is encrypted using the HSM keys of the source cluster. <code>true</code> indicates that the data is encrypted using HSM keys.</p>
        pub fn set_encrypted_with_hsm(mut self, input: std::option::Option<bool>) -> Self {
            self.encrypted_with_hsm = input;
            self
        }
        /// Appends an item to `accounts_with_restore_access`.
        ///
        /// To override the contents of this collection use [`set_accounts_with_restore_access`](Self::set_accounts_with_restore_access).
        ///
        /// <p>A list of the Amazon Web Services accounts authorized to restore the snapshot. Returns <code>null</code> if no accounts are authorized. Visible only to the snapshot owner. </p>
        pub fn accounts_with_restore_access(
            mut self,
            input: crate::model::AccountWithRestoreAccess,
        ) -> Self {
            let mut v = self.accounts_with_restore_access.unwrap_or_default();
            v.push(input);
            self.accounts_with_restore_access = Some(v);
            self
        }
        /// <p>A list of the Amazon Web Services accounts authorized to restore the snapshot. Returns <code>null</code> if no accounts are authorized. Visible only to the snapshot owner. </p>
        pub fn set_accounts_with_restore_access(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AccountWithRestoreAccess>>,
        ) -> Self {
            self.accounts_with_restore_access = input;
            self
        }
        /// <p>For manual snapshots, the Amazon Web Services account used to create or copy the snapshot. For automatic snapshots, the owner of the cluster. The owner can perform all snapshot actions, such as sharing a manual snapshot.</p>
        pub fn owner_account(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner_account = Some(input.into());
            self
        }
        /// <p>For manual snapshots, the Amazon Web Services account used to create or copy the snapshot. For automatic snapshots, the owner of the cluster. The owner can perform all snapshot actions, such as sharing a manual snapshot.</p>
        pub fn set_owner_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.owner_account = input;
            self
        }
        /// <p>The size of the complete set of backup data that would be used to restore the cluster.</p>
        pub fn total_backup_size_in_mega_bytes(mut self, input: f64) -> Self {
            self.total_backup_size_in_mega_bytes = Some(input);
            self
        }
        /// <p>The size of the complete set of backup data that would be used to restore the cluster.</p>
        pub fn set_total_backup_size_in_mega_bytes(
            mut self,
            input: std::option::Option<f64>,
        ) -> Self {
            self.total_backup_size_in_mega_bytes = input;
            self
        }
        /// <p>The size of the incremental backup.</p>
        pub fn actual_incremental_backup_size_in_mega_bytes(mut self, input: f64) -> Self {
            self.actual_incremental_backup_size_in_mega_bytes = Some(input);
            self
        }
        /// <p>The size of the incremental backup.</p>
        pub fn set_actual_incremental_backup_size_in_mega_bytes(
            mut self,
            input: std::option::Option<f64>,
        ) -> Self {
            self.actual_incremental_backup_size_in_mega_bytes = input;
            self
        }
        /// <p>The number of megabytes that have been transferred to the snapshot backup.</p>
        pub fn backup_progress_in_mega_bytes(mut self, input: f64) -> Self {
            self.backup_progress_in_mega_bytes = Some(input);
            self
        }
        /// <p>The number of megabytes that have been transferred to the snapshot backup.</p>
        pub fn set_backup_progress_in_mega_bytes(
            mut self,
            input: std::option::Option<f64>,
        ) -> Self {
            self.backup_progress_in_mega_bytes = input;
            self
        }
        /// <p>The number of megabytes per second being transferred to the snapshot backup. Returns <code>0</code> for a completed backup. </p>
        pub fn current_backup_rate_in_mega_bytes_per_second(mut self, input: f64) -> Self {
            self.current_backup_rate_in_mega_bytes_per_second = Some(input);
            self
        }
        /// <p>The number of megabytes per second being transferred to the snapshot backup. Returns <code>0</code> for a completed backup. </p>
        pub fn set_current_backup_rate_in_mega_bytes_per_second(
            mut self,
            input: std::option::Option<f64>,
        ) -> Self {
            self.current_backup_rate_in_mega_bytes_per_second = input;
            self
        }
        /// <p>The estimate of the time remaining before the snapshot backup will complete. Returns <code>0</code> for a completed backup. </p>
        pub fn estimated_seconds_to_completion(mut self, input: i64) -> Self {
            self.estimated_seconds_to_completion = Some(input);
            self
        }
        /// <p>The estimate of the time remaining before the snapshot backup will complete. Returns <code>0</code> for a completed backup. </p>
        pub fn set_estimated_seconds_to_completion(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.estimated_seconds_to_completion = input;
            self
        }
        /// <p>The amount of time an in-progress snapshot backup has been running, or the amount of time it took a completed backup to finish.</p>
        pub fn elapsed_time_in_seconds(mut self, input: i64) -> Self {
            self.elapsed_time_in_seconds = Some(input);
            self
        }
        /// <p>The amount of time an in-progress snapshot backup has been running, or the amount of time it took a completed backup to finish.</p>
        pub fn set_elapsed_time_in_seconds(mut self, input: std::option::Option<i64>) -> Self {
            self.elapsed_time_in_seconds = input;
            self
        }
        /// <p>The source region from which the snapshot was copied.</p>
        pub fn source_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_region = Some(input.into());
            self
        }
        /// <p>The source region from which the snapshot was copied.</p>
        pub fn set_source_region(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_region = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The list of tags for the cluster snapshot.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The list of tags for the cluster snapshot.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Appends an item to `restorable_node_types`.
        ///
        /// To override the contents of this collection use [`set_restorable_node_types`](Self::set_restorable_node_types).
        ///
        /// <p>The list of node types that this cluster snapshot is able to restore into.</p>
        pub fn restorable_node_types(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.restorable_node_types.unwrap_or_default();
            v.push(input.into());
            self.restorable_node_types = Some(v);
            self
        }
        /// <p>The list of node types that this cluster snapshot is able to restore into.</p>
        pub fn set_restorable_node_types(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.restorable_node_types = input;
            self
        }
        /// <p>An option that specifies whether to create the cluster with enhanced VPC routing enabled. To create a cluster that uses enhanced VPC routing, the cluster must be in a VPC. For more information, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html">Enhanced VPC Routing</a> in the Amazon Redshift Cluster Management Guide.</p>
        /// <p>If this option is <code>true</code>, enhanced VPC routing is enabled. </p>
        /// <p>Default: false</p>
        pub fn enhanced_vpc_routing(mut self, input: bool) -> Self {
            self.enhanced_vpc_routing = Some(input);
            self
        }
        /// <p>An option that specifies whether to create the cluster with enhanced VPC routing enabled. To create a cluster that uses enhanced VPC routing, the cluster must be in a VPC. For more information, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html">Enhanced VPC Routing</a> in the Amazon Redshift Cluster Management Guide.</p>
        /// <p>If this option is <code>true</code>, enhanced VPC routing is enabled. </p>
        /// <p>Default: false</p>
        pub fn set_enhanced_vpc_routing(mut self, input: std::option::Option<bool>) -> Self {
            self.enhanced_vpc_routing = input;
            self
        }
        /// <p>The name of the maintenance track for the snapshot.</p>
        pub fn maintenance_track_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.maintenance_track_name = Some(input.into());
            self
        }
        /// <p>The name of the maintenance track for the snapshot.</p>
        pub fn set_maintenance_track_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.maintenance_track_name = input;
            self
        }
        /// <p>The number of days that a manual snapshot is retained. If the value is -1, the manual snapshot is retained indefinitely. </p>
        /// <p>The value must be either -1 or an integer between 1 and 3,653.</p>
        pub fn manual_snapshot_retention_period(mut self, input: i32) -> Self {
            self.manual_snapshot_retention_period = Some(input);
            self
        }
        /// <p>The number of days that a manual snapshot is retained. If the value is -1, the manual snapshot is retained indefinitely. </p>
        /// <p>The value must be either -1 or an integer between 1 and 3,653.</p>
        pub fn set_manual_snapshot_retention_period(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.manual_snapshot_retention_period = input;
            self
        }
        /// <p>The number of days until a manual snapshot will pass its retention period.</p>
        pub fn manual_snapshot_remaining_days(mut self, input: i32) -> Self {
            self.manual_snapshot_remaining_days = Some(input);
            self
        }
        /// <p>The number of days until a manual snapshot will pass its retention period.</p>
        pub fn set_manual_snapshot_remaining_days(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.manual_snapshot_remaining_days = input;
            self
        }
        /// <p>A timestamp representing the start of the retention period for the snapshot.</p>
        pub fn snapshot_retention_start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.snapshot_retention_start_time = Some(input);
            self
        }
        /// <p>A timestamp representing the start of the retention period for the snapshot.</p>
        pub fn set_snapshot_retention_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.snapshot_retention_start_time = input;
            self
        }
        /// Consumes the builder and constructs a [`Snapshot`](crate::model::Snapshot)
        pub fn build(self) -> crate::model::Snapshot {
            crate::model::Snapshot {
                snapshot_identifier: self.snapshot_identifier,
                cluster_identifier: self.cluster_identifier,
                snapshot_create_time: self.snapshot_create_time,
                status: self.status,
                port: self.port.unwrap_or_default(),
                availability_zone: self.availability_zone,
                cluster_create_time: self.cluster_create_time,
                master_username: self.master_username,
                cluster_version: self.cluster_version,
                engine_full_version: self.engine_full_version,
                snapshot_type: self.snapshot_type,
                node_type: self.node_type,
                number_of_nodes: self.number_of_nodes.unwrap_or_default(),
                db_name: self.db_name,
                vpc_id: self.vpc_id,
                encrypted: self.encrypted.unwrap_or_default(),
                kms_key_id: self.kms_key_id,
                encrypted_with_hsm: self.encrypted_with_hsm.unwrap_or_default(),
                accounts_with_restore_access: self.accounts_with_restore_access,
                owner_account: self.owner_account,
                total_backup_size_in_mega_bytes: self
                    .total_backup_size_in_mega_bytes
                    .unwrap_or_default(),
                actual_incremental_backup_size_in_mega_bytes: self
                    .actual_incremental_backup_size_in_mega_bytes
                    .unwrap_or_default(),
                backup_progress_in_mega_bytes: self
                    .backup_progress_in_mega_bytes
                    .unwrap_or_default(),
                current_backup_rate_in_mega_bytes_per_second: self
                    .current_backup_rate_in_mega_bytes_per_second
                    .unwrap_or_default(),
                estimated_seconds_to_completion: self
                    .estimated_seconds_to_completion
                    .unwrap_or_default(),
                elapsed_time_in_seconds: self.elapsed_time_in_seconds.unwrap_or_default(),
                source_region: self.source_region,
                tags: self.tags,
                restorable_node_types: self.restorable_node_types,
                enhanced_vpc_routing: self.enhanced_vpc_routing.unwrap_or_default(),
                maintenance_track_name: self.maintenance_track_name,
                manual_snapshot_retention_period: self.manual_snapshot_retention_period,
                manual_snapshot_remaining_days: self.manual_snapshot_remaining_days,
                snapshot_retention_start_time: self.snapshot_retention_start_time,
            }
        }
    }
}
impl Snapshot {
    /// Creates a new builder-style object to manufacture [`Snapshot`](crate::model::Snapshot)
    pub fn builder() -> crate::model::snapshot::Builder {
        crate::model::snapshot::Builder::default()
    }
}

/// <p>Describes an Amazon Web Services account authorized to restore a snapshot.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccountWithRestoreAccess {
    /// <p>The identifier of an Amazon Web Services account authorized to restore a snapshot.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The identifier of an Amazon Web Services support account authorized to restore a snapshot. For Amazon Web Services Support, the identifier is <code>amazon-redshift-support</code>. </p>
    pub account_alias: std::option::Option<std::string::String>,
}
impl AccountWithRestoreAccess {
    /// <p>The identifier of an Amazon Web Services account authorized to restore a snapshot.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The identifier of an Amazon Web Services support account authorized to restore a snapshot. For Amazon Web Services Support, the identifier is <code>amazon-redshift-support</code>. </p>
    pub fn account_alias(&self) -> std::option::Option<&str> {
        self.account_alias.as_deref()
    }
}
impl std::fmt::Debug for AccountWithRestoreAccess {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccountWithRestoreAccess");
        formatter.field("account_id", &self.account_id);
        formatter.field("account_alias", &self.account_alias);
        formatter.finish()
    }
}
/// See [`AccountWithRestoreAccess`](crate::model::AccountWithRestoreAccess)
pub mod account_with_restore_access {
    /// A builder for [`AccountWithRestoreAccess`](crate::model::AccountWithRestoreAccess)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) account_alias: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of an Amazon Web Services account authorized to restore a snapshot.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The identifier of an Amazon Web Services account authorized to restore a snapshot.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The identifier of an Amazon Web Services support account authorized to restore a snapshot. For Amazon Web Services Support, the identifier is <code>amazon-redshift-support</code>. </p>
        pub fn account_alias(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_alias = Some(input.into());
            self
        }
        /// <p>The identifier of an Amazon Web Services support account authorized to restore a snapshot. For Amazon Web Services Support, the identifier is <code>amazon-redshift-support</code>. </p>
        pub fn set_account_alias(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.account_alias = input;
            self
        }
        /// Consumes the builder and constructs a [`AccountWithRestoreAccess`](crate::model::AccountWithRestoreAccess)
        pub fn build(self) -> crate::model::AccountWithRestoreAccess {
            crate::model::AccountWithRestoreAccess {
                account_id: self.account_id,
                account_alias: self.account_alias,
            }
        }
    }
}
impl AccountWithRestoreAccess {
    /// Creates a new builder-style object to manufacture [`AccountWithRestoreAccess`](crate::model::AccountWithRestoreAccess)
    pub fn builder() -> crate::model::account_with_restore_access::Builder {
        crate::model::account_with_restore_access::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AuthorizationStatus {
    #[allow(missing_docs)] // documentation missing in model
    Authorized,
    #[allow(missing_docs)] // documentation missing in model
    Revoking,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AuthorizationStatus {
    fn from(s: &str) -> Self {
        match s {
            "Authorized" => AuthorizationStatus::Authorized,
            "Revoking" => AuthorizationStatus::Revoking,
            other => AuthorizationStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AuthorizationStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AuthorizationStatus::from(s))
    }
}
impl AuthorizationStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AuthorizationStatus::Authorized => "Authorized",
            AuthorizationStatus::Revoking => "Revoking",
            AuthorizationStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Authorized", "Revoking"]
    }
}
impl AsRef<str> for AuthorizationStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes a security group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ClusterSecurityGroup {
    /// <p>The name of the cluster security group to which the operation was applied.</p>
    pub cluster_security_group_name: std::option::Option<std::string::String>,
    /// <p>A description of the security group.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>A list of EC2 security groups that are permitted to access clusters associated with this cluster security group.</p>
    pub ec2_security_groups: std::option::Option<std::vec::Vec<crate::model::Ec2SecurityGroup>>,
    /// <p>A list of IP ranges (CIDR blocks) that are permitted to access clusters associated with this cluster security group.</p>
    pub ip_ranges: std::option::Option<std::vec::Vec<crate::model::IpRange>>,
    /// <p>The list of tags for the cluster security group.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl ClusterSecurityGroup {
    /// <p>The name of the cluster security group to which the operation was applied.</p>
    pub fn cluster_security_group_name(&self) -> std::option::Option<&str> {
        self.cluster_security_group_name.as_deref()
    }
    /// <p>A description of the security group.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>A list of EC2 security groups that are permitted to access clusters associated with this cluster security group.</p>
    pub fn ec2_security_groups(&self) -> std::option::Option<&[crate::model::Ec2SecurityGroup]> {
        self.ec2_security_groups.as_deref()
    }
    /// <p>A list of IP ranges (CIDR blocks) that are permitted to access clusters associated with this cluster security group.</p>
    pub fn ip_ranges(&self) -> std::option::Option<&[crate::model::IpRange]> {
        self.ip_ranges.as_deref()
    }
    /// <p>The list of tags for the cluster security group.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for ClusterSecurityGroup {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ClusterSecurityGroup");
        formatter.field(
            "cluster_security_group_name",
            &self.cluster_security_group_name,
        );
        formatter.field("description", &self.description);
        formatter.field("ec2_security_groups", &self.ec2_security_groups);
        formatter.field("ip_ranges", &self.ip_ranges);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ClusterSecurityGroup`](crate::model::ClusterSecurityGroup)
pub mod cluster_security_group {
    /// A builder for [`ClusterSecurityGroup`](crate::model::ClusterSecurityGroup)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_security_group_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) ec2_security_groups:
            std::option::Option<std::vec::Vec<crate::model::Ec2SecurityGroup>>,
        pub(crate) ip_ranges: std::option::Option<std::vec::Vec<crate::model::IpRange>>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of the cluster security group to which the operation was applied.</p>
        pub fn cluster_security_group_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.cluster_security_group_name = Some(input.into());
            self
        }
        /// <p>The name of the cluster security group to which the operation was applied.</p>
        pub fn set_cluster_security_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cluster_security_group_name = input;
            self
        }
        /// <p>A description of the security group.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the security group.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `ec2_security_groups`.
        ///
        /// To override the contents of this collection use [`set_ec2_security_groups`](Self::set_ec2_security_groups).
        ///
        /// <p>A list of EC2 security groups that are permitted to access clusters associated with this cluster security group.</p>
        pub fn ec2_security_groups(mut self, input: crate::model::Ec2SecurityGroup) -> Self {
            let mut v = self.ec2_security_groups.unwrap_or_default();
            v.push(input);
            self.ec2_security_groups = Some(v);
            self
        }
        /// <p>A list of EC2 security groups that are permitted to access clusters associated with this cluster security group.</p>
        pub fn set_ec2_security_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Ec2SecurityGroup>>,
        ) -> Self {
            self.ec2_security_groups = input;
            self
        }
        /// Appends an item to `ip_ranges`.
        ///
        /// To override the contents of this collection use [`set_ip_ranges`](Self::set_ip_ranges).
        ///
        /// <p>A list of IP ranges (CIDR blocks) that are permitted to access clusters associated with this cluster security group.</p>
        pub fn ip_ranges(mut self, input: crate::model::IpRange) -> Self {
            let mut v = self.ip_ranges.unwrap_or_default();
            v.push(input);
            self.ip_ranges = Some(v);
            self
        }
        /// <p>A list of IP ranges (CIDR blocks) that are permitted to access clusters associated with this cluster security group.</p>
        pub fn set_ip_ranges(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::IpRange>>,
        ) -> Self {
            self.ip_ranges = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The list of tags for the cluster security group.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The list of tags for the cluster security group.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ClusterSecurityGroup`](crate::model::ClusterSecurityGroup)
        pub fn build(self) -> crate::model::ClusterSecurityGroup {
            crate::model::ClusterSecurityGroup {
                cluster_security_group_name: self.cluster_security_group_name,
                description: self.description,
                ec2_security_groups: self.ec2_security_groups,
                ip_ranges: self.ip_ranges,
                tags: self.tags,
            }
        }
    }
}
impl ClusterSecurityGroup {
    /// Creates a new builder-style object to manufacture [`ClusterSecurityGroup`](crate::model::ClusterSecurityGroup)
    pub fn builder() -> crate::model::cluster_security_group::Builder {
        crate::model::cluster_security_group::Builder::default()
    }
}

/// <p>Describes an IP range used in a security group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IpRange {
    /// <p>The status of the IP range, for example, "authorized".</p>
    pub status: std::option::Option<std::string::String>,
    /// <p>The IP range in Classless Inter-Domain Routing (CIDR) notation.</p>
    pub cidrip: std::option::Option<std::string::String>,
    /// <p>The list of tags for the IP range.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl IpRange {
    /// <p>The status of the IP range, for example, "authorized".</p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>The IP range in Classless Inter-Domain Routing (CIDR) notation.</p>
    pub fn cidrip(&self) -> std::option::Option<&str> {
        self.cidrip.as_deref()
    }
    /// <p>The list of tags for the IP range.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for IpRange {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IpRange");
        formatter.field("status", &self.status);
        formatter.field("cidrip", &self.cidrip);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`IpRange`](crate::model::IpRange)
pub mod ip_range {
    /// A builder for [`IpRange`](crate::model::IpRange)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) cidrip: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The status of the IP range, for example, "authorized".</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the IP range, for example, "authorized".</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>The IP range in Classless Inter-Domain Routing (CIDR) notation.</p>
        pub fn cidrip(mut self, input: impl Into<std::string::String>) -> Self {
            self.cidrip = Some(input.into());
            self
        }
        /// <p>The IP range in Classless Inter-Domain Routing (CIDR) notation.</p>
        pub fn set_cidrip(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cidrip = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The list of tags for the IP range.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The list of tags for the IP range.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`IpRange`](crate::model::IpRange)
        pub fn build(self) -> crate::model::IpRange {
            crate::model::IpRange {
                status: self.status,
                cidrip: self.cidrip,
                tags: self.tags,
            }
        }
    }
}
impl IpRange {
    /// Creates a new builder-style object to manufacture [`IpRange`](crate::model::IpRange)
    pub fn builder() -> crate::model::ip_range::Builder {
        crate::model::ip_range::Builder::default()
    }
}

/// <p>Describes an Amazon EC2 security group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Ec2SecurityGroup {
    /// <p>The status of the EC2 security group.</p>
    pub status: std::option::Option<std::string::String>,
    /// <p>The name of the EC2 Security Group.</p>
    pub ec2_security_group_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services account ID of the owner of the EC2 security group specified in the <code>EC2SecurityGroupName</code> field. </p>
    pub ec2_security_group_owner_id: std::option::Option<std::string::String>,
    /// <p>The list of tags for the EC2 security group.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl Ec2SecurityGroup {
    /// <p>The status of the EC2 security group.</p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>The name of the EC2 Security Group.</p>
    pub fn ec2_security_group_name(&self) -> std::option::Option<&str> {
        self.ec2_security_group_name.as_deref()
    }
    /// <p>The Amazon Web Services account ID of the owner of the EC2 security group specified in the <code>EC2SecurityGroupName</code> field. </p>
    pub fn ec2_security_group_owner_id(&self) -> std::option::Option<&str> {
        self.ec2_security_group_owner_id.as_deref()
    }
    /// <p>The list of tags for the EC2 security group.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for Ec2SecurityGroup {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Ec2SecurityGroup");
        formatter.field("status", &self.status);
        formatter.field("ec2_security_group_name", &self.ec2_security_group_name);
        formatter.field(
            "ec2_security_group_owner_id",
            &self.ec2_security_group_owner_id,
        );
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`Ec2SecurityGroup`](crate::model::Ec2SecurityGroup)
pub mod ec2_security_group {
    /// A builder for [`Ec2SecurityGroup`](crate::model::Ec2SecurityGroup)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) ec2_security_group_name: std::option::Option<std::string::String>,
        pub(crate) ec2_security_group_owner_id: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The status of the EC2 security group.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the EC2 security group.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>The name of the EC2 Security Group.</p>
        pub fn ec2_security_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.ec2_security_group_name = Some(input.into());
            self
        }
        /// <p>The name of the EC2 Security Group.</p>
        pub fn set_ec2_security_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ec2_security_group_name = input;
            self
        }
        /// <p>The Amazon Web Services account ID of the owner of the EC2 security group specified in the <code>EC2SecurityGroupName</code> field. </p>
        pub fn ec2_security_group_owner_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.ec2_security_group_owner_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID of the owner of the EC2 security group specified in the <code>EC2SecurityGroupName</code> field. </p>
        pub fn set_ec2_security_group_owner_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ec2_security_group_owner_id = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The list of tags for the EC2 security group.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The list of tags for the EC2 security group.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`Ec2SecurityGroup`](crate::model::Ec2SecurityGroup)
        pub fn build(self) -> crate::model::Ec2SecurityGroup {
            crate::model::Ec2SecurityGroup {
                status: self.status,
                ec2_security_group_name: self.ec2_security_group_name,
                ec2_security_group_owner_id: self.ec2_security_group_owner_id,
                tags: self.tags,
            }
        }
    }
}
impl Ec2SecurityGroup {
    /// Creates a new builder-style object to manufacture [`Ec2SecurityGroup`](crate::model::Ec2SecurityGroup)
    pub fn builder() -> crate::model::ec2_security_group::Builder {
        crate::model::ec2_security_group::Builder::default()
    }
}

/// <p>Describes the status of a <code>RestoreTableFromClusterSnapshot</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TableRestoreStatus {
    /// <p>The unique identifier for the table restore request.</p>
    pub table_restore_request_id: std::option::Option<std::string::String>,
    /// <p>A value that describes the current state of the table restore request.</p>
    /// <p>Valid Values: <code>SUCCEEDED</code>, <code>FAILED</code>, <code>CANCELED</code>, <code>PENDING</code>, <code>IN_PROGRESS</code> </p>
    pub status: std::option::Option<crate::model::TableRestoreStatusType>,
    /// <p>A description of the status of the table restore request. Status values include <code>SUCCEEDED</code>, <code>FAILED</code>, <code>CANCELED</code>, <code>PENDING</code>, <code>IN_PROGRESS</code>.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The time that the table restore request was made, in Universal Coordinated Time (UTC).</p>
    pub request_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The amount of data restored to the new table so far, in megabytes (MB).</p>
    pub progress_in_mega_bytes: std::option::Option<i64>,
    /// <p>The total amount of data to restore to the new table, in megabytes (MB).</p>
    pub total_data_in_mega_bytes: std::option::Option<i64>,
    /// <p>The identifier of the Amazon Redshift cluster that the table is being restored to.</p>
    pub cluster_identifier: std::option::Option<std::string::String>,
    /// <p>The identifier of the snapshot that the table is being restored from.</p>
    pub snapshot_identifier: std::option::Option<std::string::String>,
    /// <p>The name of the source database that contains the table being restored.</p>
    pub source_database_name: std::option::Option<std::string::String>,
    /// <p>The name of the source schema that contains the table being restored.</p>
    pub source_schema_name: std::option::Option<std::string::String>,
    /// <p>The name of the source table being restored.</p>
    pub source_table_name: std::option::Option<std::string::String>,
    /// <p>The name of the database to restore the table to.</p>
    pub target_database_name: std::option::Option<std::string::String>,
    /// <p>The name of the schema to restore the table to.</p>
    pub target_schema_name: std::option::Option<std::string::String>,
    /// <p>The name of the table to create as a result of the table restore request.</p>
    pub new_table_name: std::option::Option<std::string::String>,
}
impl TableRestoreStatus {
    /// <p>The unique identifier for the table restore request.</p>
    pub fn table_restore_request_id(&self) -> std::option::Option<&str> {
        self.table_restore_request_id.as_deref()
    }
    /// <p>A value that describes the current state of the table restore request.</p>
    /// <p>Valid Values: <code>SUCCEEDED</code>, <code>FAILED</code>, <code>CANCELED</code>, <code>PENDING</code>, <code>IN_PROGRESS</code> </p>
    pub fn status(&self) -> std::option::Option<&crate::model::TableRestoreStatusType> {
        self.status.as_ref()
    }
    /// <p>A description of the status of the table restore request. Status values include <code>SUCCEEDED</code>, <code>FAILED</code>, <code>CANCELED</code>, <code>PENDING</code>, <code>IN_PROGRESS</code>.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
    /// <p>The time that the table restore request was made, in Universal Coordinated Time (UTC).</p>
    pub fn request_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.request_time.as_ref()
    }
    /// <p>The amount of data restored to the new table so far, in megabytes (MB).</p>
    pub fn progress_in_mega_bytes(&self) -> std::option::Option<i64> {
        self.progress_in_mega_bytes
    }
    /// <p>The total amount of data to restore to the new table, in megabytes (MB).</p>
    pub fn total_data_in_mega_bytes(&self) -> std::option::Option<i64> {
        self.total_data_in_mega_bytes
    }
    /// <p>The identifier of the Amazon Redshift cluster that the table is being restored to.</p>
    pub fn cluster_identifier(&self) -> std::option::Option<&str> {
        self.cluster_identifier.as_deref()
    }
    /// <p>The identifier of the snapshot that the table is being restored from.</p>
    pub fn snapshot_identifier(&self) -> std::option::Option<&str> {
        self.snapshot_identifier.as_deref()
    }
    /// <p>The name of the source database that contains the table being restored.</p>
    pub fn source_database_name(&self) -> std::option::Option<&str> {
        self.source_database_name.as_deref()
    }
    /// <p>The name of the source schema that contains the table being restored.</p>
    pub fn source_schema_name(&self) -> std::option::Option<&str> {
        self.source_schema_name.as_deref()
    }
    /// <p>The name of the source table being restored.</p>
    pub fn source_table_name(&self) -> std::option::Option<&str> {
        self.source_table_name.as_deref()
    }
    /// <p>The name of the database to restore the table to.</p>
    pub fn target_database_name(&self) -> std::option::Option<&str> {
        self.target_database_name.as_deref()
    }
    /// <p>The name of the schema to restore the table to.</p>
    pub fn target_schema_name(&self) -> std::option::Option<&str> {
        self.target_schema_name.as_deref()
    }
    /// <p>The name of the table to create as a result of the table restore request.</p>
    pub fn new_table_name(&self) -> std::option::Option<&str> {
        self.new_table_name.as_deref()
    }
}
impl std::fmt::Debug for TableRestoreStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TableRestoreStatus");
        formatter.field("table_restore_request_id", &self.table_restore_request_id);
        formatter.field("status", &self.status);
        formatter.field("message", &self.message);
        formatter.field("request_time", &self.request_time);
        formatter.field("progress_in_mega_bytes", &self.progress_in_mega_bytes);
        formatter.field("total_data_in_mega_bytes", &self.total_data_in_mega_bytes);
        formatter.field("cluster_identifier", &self.cluster_identifier);
        formatter.field("snapshot_identifier", &self.snapshot_identifier);
        formatter.field("source_database_name", &self.source_database_name);
        formatter.field("source_schema_name", &self.source_schema_name);
        formatter.field("source_table_name", &self.source_table_name);
        formatter.field("target_database_name", &self.target_database_name);
        formatter.field("target_schema_name", &self.target_schema_name);
        formatter.field("new_table_name", &self.new_table_name);
        formatter.finish()
    }
}
/// See [`TableRestoreStatus`](crate::model::TableRestoreStatus)
pub mod table_restore_status {
    /// A builder for [`TableRestoreStatus`](crate::model::TableRestoreStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) table_restore_request_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::TableRestoreStatusType>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) request_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) progress_in_mega_bytes: std::option::Option<i64>,
        pub(crate) total_data_in_mega_bytes: std::option::Option<i64>,
        pub(crate) cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) snapshot_identifier: std::option::Option<std::string::String>,
        pub(crate) source_database_name: std::option::Option<std::string::String>,
        pub(crate) source_schema_name: std::option::Option<std::string::String>,
        pub(crate) source_table_name: std::option::Option<std::string::String>,
        pub(crate) target_database_name: std::option::Option<std::string::String>,
        pub(crate) target_schema_name: std::option::Option<std::string::String>,
        pub(crate) new_table_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the table restore request.</p>
        pub fn table_restore_request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_restore_request_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the table restore request.</p>
        pub fn set_table_restore_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.table_restore_request_id = input;
            self
        }
        /// <p>A value that describes the current state of the table restore request.</p>
        /// <p>Valid Values: <code>SUCCEEDED</code>, <code>FAILED</code>, <code>CANCELED</code>, <code>PENDING</code>, <code>IN_PROGRESS</code> </p>
        pub fn status(mut self, input: crate::model::TableRestoreStatusType) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>A value that describes the current state of the table restore request.</p>
        /// <p>Valid Values: <code>SUCCEEDED</code>, <code>FAILED</code>, <code>CANCELED</code>, <code>PENDING</code>, <code>IN_PROGRESS</code> </p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::TableRestoreStatusType>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>A description of the status of the table restore request. Status values include <code>SUCCEEDED</code>, <code>FAILED</code>, <code>CANCELED</code>, <code>PENDING</code>, <code>IN_PROGRESS</code>.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A description of the status of the table restore request. Status values include <code>SUCCEEDED</code>, <code>FAILED</code>, <code>CANCELED</code>, <code>PENDING</code>, <code>IN_PROGRESS</code>.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The time that the table restore request was made, in Universal Coordinated Time (UTC).</p>
        pub fn request_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.request_time = Some(input);
            self
        }
        /// <p>The time that the table restore request was made, in Universal Coordinated Time (UTC).</p>
        pub fn set_request_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.request_time = input;
            self
        }
        /// <p>The amount of data restored to the new table so far, in megabytes (MB).</p>
        pub fn progress_in_mega_bytes(mut self, input: i64) -> Self {
            self.progress_in_mega_bytes = Some(input);
            self
        }
        /// <p>The amount of data restored to the new table so far, in megabytes (MB).</p>
        pub fn set_progress_in_mega_bytes(mut self, input: std::option::Option<i64>) -> Self {
            self.progress_in_mega_bytes = input;
            self
        }
        /// <p>The total amount of data to restore to the new table, in megabytes (MB).</p>
        pub fn total_data_in_mega_bytes(mut self, input: i64) -> Self {
            self.total_data_in_mega_bytes = Some(input);
            self
        }
        /// <p>The total amount of data to restore to the new table, in megabytes (MB).</p>
        pub fn set_total_data_in_mega_bytes(mut self, input: std::option::Option<i64>) -> Self {
            self.total_data_in_mega_bytes = input;
            self
        }
        /// <p>The identifier of the Amazon Redshift cluster that the table is being restored to.</p>
        pub fn cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_identifier = Some(input.into());
            self
        }
        /// <p>The identifier of the Amazon Redshift cluster that the table is being restored to.</p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cluster_identifier = input;
            self
        }
        /// <p>The identifier of the snapshot that the table is being restored from.</p>
        pub fn snapshot_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.snapshot_identifier = Some(input.into());
            self
        }
        /// <p>The identifier of the snapshot that the table is being restored from.</p>
        pub fn set_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.snapshot_identifier = input;
            self
        }
        /// <p>The name of the source database that contains the table being restored.</p>
        pub fn source_database_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_database_name = Some(input.into());
            self
        }
        /// <p>The name of the source database that contains the table being restored.</p>
        pub fn set_source_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_database_name = input;
            self
        }
        /// <p>The name of the source schema that contains the table being restored.</p>
        pub fn source_schema_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_schema_name = Some(input.into());
            self
        }
        /// <p>The name of the source schema that contains the table being restored.</p>
        pub fn set_source_schema_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_schema_name = input;
            self
        }
        /// <p>The name of the source table being restored.</p>
        pub fn source_table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_table_name = Some(input.into());
            self
        }
        /// <p>The name of the source table being restored.</p>
        pub fn set_source_table_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_table_name = input;
            self
        }
        /// <p>The name of the database to restore the table to.</p>
        pub fn target_database_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_database_name = Some(input.into());
            self
        }
        /// <p>The name of the database to restore the table to.</p>
        pub fn set_target_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_database_name = input;
            self
        }
        /// <p>The name of the schema to restore the table to.</p>
        pub fn target_schema_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_schema_name = Some(input.into());
            self
        }
        /// <p>The name of the schema to restore the table to.</p>
        pub fn set_target_schema_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_schema_name = input;
            self
        }
        /// <p>The name of the table to create as a result of the table restore request.</p>
        pub fn new_table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.new_table_name = Some(input.into());
            self
        }
        /// <p>The name of the table to create as a result of the table restore request.</p>
        pub fn set_new_table_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.new_table_name = input;
            self
        }
        /// Consumes the builder and constructs a [`TableRestoreStatus`](crate::model::TableRestoreStatus)
        pub fn build(self) -> crate::model::TableRestoreStatus {
            crate::model::TableRestoreStatus {
                table_restore_request_id: self.table_restore_request_id,
                status: self.status,
                message: self.message,
                request_time: self.request_time,
                progress_in_mega_bytes: self.progress_in_mega_bytes,
                total_data_in_mega_bytes: self.total_data_in_mega_bytes,
                cluster_identifier: self.cluster_identifier,
                snapshot_identifier: self.snapshot_identifier,
                source_database_name: self.source_database_name,
                source_schema_name: self.source_schema_name,
                source_table_name: self.source_table_name,
                target_database_name: self.target_database_name,
                target_schema_name: self.target_schema_name,
                new_table_name: self.new_table_name,
            }
        }
    }
}
impl TableRestoreStatus {
    /// Creates a new builder-style object to manufacture [`TableRestoreStatus`](crate::model::TableRestoreStatus)
    pub fn builder() -> crate::model::table_restore_status::Builder {
        crate::model::table_restore_status::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TableRestoreStatusType {
    #[allow(missing_docs)] // documentation missing in model
    Canceled,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    Succeeded,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TableRestoreStatusType {
    fn from(s: &str) -> Self {
        match s {
            "CANCELED" => TableRestoreStatusType::Canceled,
            "FAILED" => TableRestoreStatusType::Failed,
            "IN_PROGRESS" => TableRestoreStatusType::InProgress,
            "PENDING" => TableRestoreStatusType::Pending,
            "SUCCEEDED" => TableRestoreStatusType::Succeeded,
            other => TableRestoreStatusType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TableRestoreStatusType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TableRestoreStatusType::from(s))
    }
}
impl TableRestoreStatusType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TableRestoreStatusType::Canceled => "CANCELED",
            TableRestoreStatusType::Failed => "FAILED",
            TableRestoreStatusType::InProgress => "IN_PROGRESS",
            TableRestoreStatusType::Pending => "PENDING",
            TableRestoreStatusType::Succeeded => "SUCCEEDED",
            TableRestoreStatusType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CANCELED", "FAILED", "IN_PROGRESS", "PENDING", "SUCCEEDED"]
    }
}
impl AsRef<str> for TableRestoreStatusType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes a parameter in a cluster parameter group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Parameter {
    /// <p>The name of the parameter.</p>
    pub parameter_name: std::option::Option<std::string::String>,
    /// <p>The value of the parameter. If <code>ParameterName</code> is <code>wlm_json_configuration</code>, then the maximum size of <code>ParameterValue</code> is 8000 characters.</p>
    pub parameter_value: std::option::Option<std::string::String>,
    /// <p>A description of the parameter.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The source of the parameter value, such as "engine-default" or "user".</p>
    pub source: std::option::Option<std::string::String>,
    /// <p>The data type of the parameter.</p>
    pub data_type: std::option::Option<std::string::String>,
    /// <p>The valid range of values for the parameter.</p>
    pub allowed_values: std::option::Option<std::string::String>,
    /// <p>Specifies how to apply the WLM configuration parameter. Some properties can be applied dynamically, while other properties require that any associated clusters be rebooted for the configuration changes to be applied. For more information about parameters and parameter groups, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Amazon Redshift Parameter Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</p>
    pub apply_type: std::option::Option<crate::model::ParameterApplyType>,
    /// <p>If <code>true</code>, the parameter can be modified. Some parameters have security or operational implications that prevent them from being changed. </p>
    pub is_modifiable: bool,
    /// <p>The earliest engine version to which the parameter can apply.</p>
    pub minimum_engine_version: std::option::Option<std::string::String>,
}
impl Parameter {
    /// <p>The name of the parameter.</p>
    pub fn parameter_name(&self) -> std::option::Option<&str> {
        self.parameter_name.as_deref()
    }
    /// <p>The value of the parameter. If <code>ParameterName</code> is <code>wlm_json_configuration</code>, then the maximum size of <code>ParameterValue</code> is 8000 characters.</p>
    pub fn parameter_value(&self) -> std::option::Option<&str> {
        self.parameter_value.as_deref()
    }
    /// <p>A description of the parameter.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The source of the parameter value, such as "engine-default" or "user".</p>
    pub fn source(&self) -> std::option::Option<&str> {
        self.source.as_deref()
    }
    /// <p>The data type of the parameter.</p>
    pub fn data_type(&self) -> std::option::Option<&str> {
        self.data_type.as_deref()
    }
    /// <p>The valid range of values for the parameter.</p>
    pub fn allowed_values(&self) -> std::option::Option<&str> {
        self.allowed_values.as_deref()
    }
    /// <p>Specifies how to apply the WLM configuration parameter. Some properties can be applied dynamically, while other properties require that any associated clusters be rebooted for the configuration changes to be applied. For more information about parameters and parameter groups, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Amazon Redshift Parameter Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</p>
    pub fn apply_type(&self) -> std::option::Option<&crate::model::ParameterApplyType> {
        self.apply_type.as_ref()
    }
    /// <p>If <code>true</code>, the parameter can be modified. Some parameters have security or operational implications that prevent them from being changed. </p>
    pub fn is_modifiable(&self) -> bool {
        self.is_modifiable
    }
    /// <p>The earliest engine version to which the parameter can apply.</p>
    pub fn minimum_engine_version(&self) -> std::option::Option<&str> {
        self.minimum_engine_version.as_deref()
    }
}
impl std::fmt::Debug for Parameter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Parameter");
        formatter.field("parameter_name", &self.parameter_name);
        formatter.field("parameter_value", &self.parameter_value);
        formatter.field("description", &self.description);
        formatter.field("source", &self.source);
        formatter.field("data_type", &self.data_type);
        formatter.field("allowed_values", &self.allowed_values);
        formatter.field("apply_type", &self.apply_type);
        formatter.field("is_modifiable", &self.is_modifiable);
        formatter.field("minimum_engine_version", &self.minimum_engine_version);
        formatter.finish()
    }
}
/// See [`Parameter`](crate::model::Parameter)
pub mod parameter {
    /// A builder for [`Parameter`](crate::model::Parameter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) parameter_name: std::option::Option<std::string::String>,
        pub(crate) parameter_value: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) source: std::option::Option<std::string::String>,
        pub(crate) data_type: std::option::Option<std::string::String>,
        pub(crate) allowed_values: std::option::Option<std::string::String>,
        pub(crate) apply_type: std::option::Option<crate::model::ParameterApplyType>,
        pub(crate) is_modifiable: std::option::Option<bool>,
        pub(crate) minimum_engine_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the parameter.</p>
        pub fn parameter_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.parameter_name = Some(input.into());
            self
        }
        /// <p>The name of the parameter.</p>
        pub fn set_parameter_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parameter_name = input;
            self
        }
        /// <p>The value of the parameter. If <code>ParameterName</code> is <code>wlm_json_configuration</code>, then the maximum size of <code>ParameterValue</code> is 8000 characters.</p>
        pub fn parameter_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.parameter_value = Some(input.into());
            self
        }
        /// <p>The value of the parameter. If <code>ParameterName</code> is <code>wlm_json_configuration</code>, then the maximum size of <code>ParameterValue</code> is 8000 characters.</p>
        pub fn set_parameter_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parameter_value = input;
            self
        }
        /// <p>A description of the parameter.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the parameter.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The source of the parameter value, such as "engine-default" or "user".</p>
        pub fn source(mut self, input: impl Into<std::string::String>) -> Self {
            self.source = Some(input.into());
            self
        }
        /// <p>The source of the parameter value, such as "engine-default" or "user".</p>
        pub fn set_source(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source = input;
            self
        }
        /// <p>The data type of the parameter.</p>
        pub fn data_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_type = Some(input.into());
            self
        }
        /// <p>The data type of the parameter.</p>
        pub fn set_data_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data_type = input;
            self
        }
        /// <p>The valid range of values for the parameter.</p>
        pub fn allowed_values(mut self, input: impl Into<std::string::String>) -> Self {
            self.allowed_values = Some(input.into());
            self
        }
        /// <p>The valid range of values for the parameter.</p>
        pub fn set_allowed_values(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.allowed_values = input;
            self
        }
        /// <p>Specifies how to apply the WLM configuration parameter. Some properties can be applied dynamically, while other properties require that any associated clusters be rebooted for the configuration changes to be applied. For more information about parameters and parameter groups, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Amazon Redshift Parameter Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</p>
        pub fn apply_type(mut self, input: crate::model::ParameterApplyType) -> Self {
            self.apply_type = Some(input);
            self
        }
        /// <p>Specifies how to apply the WLM configuration parameter. Some properties can be applied dynamically, while other properties require that any associated clusters be rebooted for the configuration changes to be applied. For more information about parameters and parameter groups, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Amazon Redshift Parameter Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</p>
        pub fn set_apply_type(
            mut self,
            input: std::option::Option<crate::model::ParameterApplyType>,
        ) -> Self {
            self.apply_type = input;
            self
        }
        /// <p>If <code>true</code>, the parameter can be modified. Some parameters have security or operational implications that prevent them from being changed. </p>
        pub fn is_modifiable(mut self, input: bool) -> Self {
            self.is_modifiable = Some(input);
            self
        }
        /// <p>If <code>true</code>, the parameter can be modified. Some parameters have security or operational implications that prevent them from being changed. </p>
        pub fn set_is_modifiable(mut self, input: std::option::Option<bool>) -> Self {
            self.is_modifiable = input;
            self
        }
        /// <p>The earliest engine version to which the parameter can apply.</p>
        pub fn minimum_engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.minimum_engine_version = Some(input.into());
            self
        }
        /// <p>The earliest engine version to which the parameter can apply.</p>
        pub fn set_minimum_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.minimum_engine_version = input;
            self
        }
        /// Consumes the builder and constructs a [`Parameter`](crate::model::Parameter)
        pub fn build(self) -> crate::model::Parameter {
            crate::model::Parameter {
                parameter_name: self.parameter_name,
                parameter_value: self.parameter_value,
                description: self.description,
                source: self.source,
                data_type: self.data_type,
                allowed_values: self.allowed_values,
                apply_type: self.apply_type,
                is_modifiable: self.is_modifiable.unwrap_or_default(),
                minimum_engine_version: self.minimum_engine_version,
            }
        }
    }
}
impl Parameter {
    /// Creates a new builder-style object to manufacture [`Parameter`](crate::model::Parameter)
    pub fn builder() -> crate::model::parameter::Builder {
        crate::model::parameter::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ParameterApplyType {
    #[allow(missing_docs)] // documentation missing in model
    Dynamic,
    #[allow(missing_docs)] // documentation missing in model
    Static,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ParameterApplyType {
    fn from(s: &str) -> Self {
        match s {
            "dynamic" => ParameterApplyType::Dynamic,
            "static" => ParameterApplyType::Static,
            other => ParameterApplyType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ParameterApplyType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ParameterApplyType::from(s))
    }
}
impl ParameterApplyType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ParameterApplyType::Dynamic => "dynamic",
            ParameterApplyType::Static => "static",
            ParameterApplyType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["dynamic", "static"]
    }
}
impl AsRef<str> for ParameterApplyType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The association of a datashare from a producer account with a data consumer. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DataShareAssociation {
    /// <p>The name of the consumer accounts that have an association with a producer datashare.</p>
    pub consumer_identifier: std::option::Option<std::string::String>,
    /// <p>The status of the datashare that is associated.</p>
    pub status: std::option::Option<crate::model::DataShareStatus>,
    /// <p>The Amazon Web Services Region of the consumer accounts that have an association with a producer datashare.</p>
    pub consumer_region: std::option::Option<std::string::String>,
    /// <p>The creation date of the datashare that is associated.</p>
    pub created_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The status change data of the datashare that is associated.</p>
    pub status_change_date: std::option::Option<aws_smithy_types::DateTime>,
}
impl DataShareAssociation {
    /// <p>The name of the consumer accounts that have an association with a producer datashare.</p>
    pub fn consumer_identifier(&self) -> std::option::Option<&str> {
        self.consumer_identifier.as_deref()
    }
    /// <p>The status of the datashare that is associated.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::DataShareStatus> {
        self.status.as_ref()
    }
    /// <p>The Amazon Web Services Region of the consumer accounts that have an association with a producer datashare.</p>
    pub fn consumer_region(&self) -> std::option::Option<&str> {
        self.consumer_region.as_deref()
    }
    /// <p>The creation date of the datashare that is associated.</p>
    pub fn created_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_date.as_ref()
    }
    /// <p>The status change data of the datashare that is associated.</p>
    pub fn status_change_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.status_change_date.as_ref()
    }
}
impl std::fmt::Debug for DataShareAssociation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DataShareAssociation");
        formatter.field("consumer_identifier", &self.consumer_identifier);
        formatter.field("status", &self.status);
        formatter.field("consumer_region", &self.consumer_region);
        formatter.field("created_date", &self.created_date);
        formatter.field("status_change_date", &self.status_change_date);
        formatter.finish()
    }
}
/// See [`DataShareAssociation`](crate::model::DataShareAssociation)
pub mod data_share_association {
    /// A builder for [`DataShareAssociation`](crate::model::DataShareAssociation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) consumer_identifier: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::DataShareStatus>,
        pub(crate) consumer_region: std::option::Option<std::string::String>,
        pub(crate) created_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) status_change_date: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The name of the consumer accounts that have an association with a producer datashare.</p>
        pub fn consumer_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.consumer_identifier = Some(input.into());
            self
        }
        /// <p>The name of the consumer accounts that have an association with a producer datashare.</p>
        pub fn set_consumer_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.consumer_identifier = input;
            self
        }
        /// <p>The status of the datashare that is associated.</p>
        pub fn status(mut self, input: crate::model::DataShareStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the datashare that is associated.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::DataShareStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The Amazon Web Services Region of the consumer accounts that have an association with a producer datashare.</p>
        pub fn consumer_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.consumer_region = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services Region of the consumer accounts that have an association with a producer datashare.</p>
        pub fn set_consumer_region(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.consumer_region = input;
            self
        }
        /// <p>The creation date of the datashare that is associated.</p>
        pub fn created_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_date = Some(input);
            self
        }
        /// <p>The creation date of the datashare that is associated.</p>
        pub fn set_created_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_date = input;
            self
        }
        /// <p>The status change data of the datashare that is associated.</p>
        pub fn status_change_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.status_change_date = Some(input);
            self
        }
        /// <p>The status change data of the datashare that is associated.</p>
        pub fn set_status_change_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.status_change_date = input;
            self
        }
        /// Consumes the builder and constructs a [`DataShareAssociation`](crate::model::DataShareAssociation)
        pub fn build(self) -> crate::model::DataShareAssociation {
            crate::model::DataShareAssociation {
                consumer_identifier: self.consumer_identifier,
                status: self.status,
                consumer_region: self.consumer_region,
                created_date: self.created_date,
                status_change_date: self.status_change_date,
            }
        }
    }
}
impl DataShareAssociation {
    /// Creates a new builder-style object to manufacture [`DataShareAssociation`](crate::model::DataShareAssociation)
    pub fn builder() -> crate::model::data_share_association::Builder {
        crate::model::data_share_association::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DataShareStatus {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Authorized,
    #[allow(missing_docs)] // documentation missing in model
    Available,
    #[allow(missing_docs)] // documentation missing in model
    Deauthorized,
    #[allow(missing_docs)] // documentation missing in model
    PendingAuthorization,
    #[allow(missing_docs)] // documentation missing in model
    Rejected,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DataShareStatus {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => DataShareStatus::Active,
            "AUTHORIZED" => DataShareStatus::Authorized,
            "AVAILABLE" => DataShareStatus::Available,
            "DEAUTHORIZED" => DataShareStatus::Deauthorized,
            "PENDING_AUTHORIZATION" => DataShareStatus::PendingAuthorization,
            "REJECTED" => DataShareStatus::Rejected,
            other => DataShareStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DataShareStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DataShareStatus::from(s))
    }
}
impl DataShareStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DataShareStatus::Active => "ACTIVE",
            DataShareStatus::Authorized => "AUTHORIZED",
            DataShareStatus::Available => "AVAILABLE",
            DataShareStatus::Deauthorized => "DEAUTHORIZED",
            DataShareStatus::PendingAuthorization => "PENDING_AUTHORIZATION",
            DataShareStatus::Rejected => "REJECTED",
            DataShareStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ACTIVE",
            "AUTHORIZED",
            "AVAILABLE",
            "DEAUTHORIZED",
            "PENDING_AUTHORIZATION",
            "REJECTED",
        ]
    }
}
impl AsRef<str> for DataShareStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes a reserved node. You can call the <code>DescribeReservedNodeOfferings</code> API to obtain the available reserved node offerings. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReservedNode {
    /// <p>The unique identifier for the reservation.</p>
    pub reserved_node_id: std::option::Option<std::string::String>,
    /// <p>The identifier for the reserved node offering.</p>
    pub reserved_node_offering_id: std::option::Option<std::string::String>,
    /// <p>The node type of the reserved node.</p>
    pub node_type: std::option::Option<std::string::String>,
    /// <p>The time the reservation started. You purchase a reserved node offering for a duration. This is the start time of that duration.</p>
    pub start_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The duration of the node reservation in seconds.</p>
    pub duration: i32,
    /// <p>The fixed cost Amazon Redshift charges you for this reserved node.</p>
    pub fixed_price: f64,
    /// <p>The hourly rate Amazon Redshift charges you for this reserved node.</p>
    pub usage_price: f64,
    /// <p>The currency code for the reserved cluster.</p>
    pub currency_code: std::option::Option<std::string::String>,
    /// <p>The number of reserved compute nodes.</p>
    pub node_count: i32,
    /// <p>The state of the reserved compute node.</p>
    /// <p>Possible Values:</p>
    /// <ul>
    /// <li> <p>pending-payment-This reserved node has recently been purchased, and the sale has been approved, but payment has not yet been confirmed.</p> </li>
    /// <li> <p>active-This reserved node is owned by the caller and is available for use.</p> </li>
    /// <li> <p>payment-failed-Payment failed for the purchase attempt.</p> </li>
    /// <li> <p>retired-The reserved node is no longer available. </p> </li>
    /// <li> <p>exchanging-The owner is exchanging the reserved node for another reserved node.</p> </li>
    /// </ul>
    pub state: std::option::Option<std::string::String>,
    /// <p>The anticipated utilization of the reserved node, as defined in the reserved node offering.</p>
    pub offering_type: std::option::Option<std::string::String>,
    /// <p>The recurring charges for the reserved node.</p>
    pub recurring_charges: std::option::Option<std::vec::Vec<crate::model::RecurringCharge>>,
    /// <p></p>
    pub reserved_node_offering_type: std::option::Option<crate::model::ReservedNodeOfferingType>,
}
impl ReservedNode {
    /// <p>The unique identifier for the reservation.</p>
    pub fn reserved_node_id(&self) -> std::option::Option<&str> {
        self.reserved_node_id.as_deref()
    }
    /// <p>The identifier for the reserved node offering.</p>
    pub fn reserved_node_offering_id(&self) -> std::option::Option<&str> {
        self.reserved_node_offering_id.as_deref()
    }
    /// <p>The node type of the reserved node.</p>
    pub fn node_type(&self) -> std::option::Option<&str> {
        self.node_type.as_deref()
    }
    /// <p>The time the reservation started. You purchase a reserved node offering for a duration. This is the start time of that duration.</p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start_time.as_ref()
    }
    /// <p>The duration of the node reservation in seconds.</p>
    pub fn duration(&self) -> i32 {
        self.duration
    }
    /// <p>The fixed cost Amazon Redshift charges you for this reserved node.</p>
    pub fn fixed_price(&self) -> f64 {
        self.fixed_price
    }
    /// <p>The hourly rate Amazon Redshift charges you for this reserved node.</p>
    pub fn usage_price(&self) -> f64 {
        self.usage_price
    }
    /// <p>The currency code for the reserved cluster.</p>
    pub fn currency_code(&self) -> std::option::Option<&str> {
        self.currency_code.as_deref()
    }
    /// <p>The number of reserved compute nodes.</p>
    pub fn node_count(&self) -> i32 {
        self.node_count
    }
    /// <p>The state of the reserved compute node.</p>
    /// <p>Possible Values:</p>
    /// <ul>
    /// <li> <p>pending-payment-This reserved node has recently been purchased, and the sale has been approved, but payment has not yet been confirmed.</p> </li>
    /// <li> <p>active-This reserved node is owned by the caller and is available for use.</p> </li>
    /// <li> <p>payment-failed-Payment failed for the purchase attempt.</p> </li>
    /// <li> <p>retired-The reserved node is no longer available. </p> </li>
    /// <li> <p>exchanging-The owner is exchanging the reserved node for another reserved node.</p> </li>
    /// </ul>
    pub fn state(&self) -> std::option::Option<&str> {
        self.state.as_deref()
    }
    /// <p>The anticipated utilization of the reserved node, as defined in the reserved node offering.</p>
    pub fn offering_type(&self) -> std::option::Option<&str> {
        self.offering_type.as_deref()
    }
    /// <p>The recurring charges for the reserved node.</p>
    pub fn recurring_charges(&self) -> std::option::Option<&[crate::model::RecurringCharge]> {
        self.recurring_charges.as_deref()
    }
    /// <p></p>
    pub fn reserved_node_offering_type(
        &self,
    ) -> std::option::Option<&crate::model::ReservedNodeOfferingType> {
        self.reserved_node_offering_type.as_ref()
    }
}
impl std::fmt::Debug for ReservedNode {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReservedNode");
        formatter.field("reserved_node_id", &self.reserved_node_id);
        formatter.field("reserved_node_offering_id", &self.reserved_node_offering_id);
        formatter.field("node_type", &self.node_type);
        formatter.field("start_time", &self.start_time);
        formatter.field("duration", &self.duration);
        formatter.field("fixed_price", &self.fixed_price);
        formatter.field("usage_price", &self.usage_price);
        formatter.field("currency_code", &self.currency_code);
        formatter.field("node_count", &self.node_count);
        formatter.field("state", &self.state);
        formatter.field("offering_type", &self.offering_type);
        formatter.field("recurring_charges", &self.recurring_charges);
        formatter.field(
            "reserved_node_offering_type",
            &self.reserved_node_offering_type,
        );
        formatter.finish()
    }
}
/// See [`ReservedNode`](crate::model::ReservedNode)
pub mod reserved_node {
    /// A builder for [`ReservedNode`](crate::model::ReservedNode)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) reserved_node_id: std::option::Option<std::string::String>,
        pub(crate) reserved_node_offering_id: std::option::Option<std::string::String>,
        pub(crate) node_type: std::option::Option<std::string::String>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) duration: std::option::Option<i32>,
        pub(crate) fixed_price: std::option::Option<f64>,
        pub(crate) usage_price: std::option::Option<f64>,
        pub(crate) currency_code: std::option::Option<std::string::String>,
        pub(crate) node_count: std::option::Option<i32>,
        pub(crate) state: std::option::Option<std::string::String>,
        pub(crate) offering_type: std::option::Option<std::string::String>,
        pub(crate) recurring_charges:
            std::option::Option<std::vec::Vec<crate::model::RecurringCharge>>,
        pub(crate) reserved_node_offering_type:
            std::option::Option<crate::model::ReservedNodeOfferingType>,
    }
    impl Builder {
        /// <p>The unique identifier for the reservation.</p>
        pub fn reserved_node_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.reserved_node_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the reservation.</p>
        pub fn set_reserved_node_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.reserved_node_id = input;
            self
        }
        /// <p>The identifier for the reserved node offering.</p>
        pub fn reserved_node_offering_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.reserved_node_offering_id = Some(input.into());
            self
        }
        /// <p>The identifier for the reserved node offering.</p>
        pub fn set_reserved_node_offering_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.reserved_node_offering_id = input;
            self
        }
        /// <p>The node type of the reserved node.</p>
        pub fn node_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.node_type = Some(input.into());
            self
        }
        /// <p>The node type of the reserved node.</p>
        pub fn set_node_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.node_type = input;
            self
        }
        /// <p>The time the reservation started. You purchase a reserved node offering for a duration. This is the start time of that duration.</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The time the reservation started. You purchase a reserved node offering for a duration. This is the start time of that duration.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The duration of the node reservation in seconds.</p>
        pub fn duration(mut self, input: i32) -> Self {
            self.duration = Some(input);
            self
        }
        /// <p>The duration of the node reservation in seconds.</p>
        pub fn set_duration(mut self, input: std::option::Option<i32>) -> Self {
            self.duration = input;
            self
        }
        /// <p>The fixed cost Amazon Redshift charges you for this reserved node.</p>
        pub fn fixed_price(mut self, input: f64) -> Self {
            self.fixed_price = Some(input);
            self
        }
        /// <p>The fixed cost Amazon Redshift charges you for this reserved node.</p>
        pub fn set_fixed_price(mut self, input: std::option::Option<f64>) -> Self {
            self.fixed_price = input;
            self
        }
        /// <p>The hourly rate Amazon Redshift charges you for this reserved node.</p>
        pub fn usage_price(mut self, input: f64) -> Self {
            self.usage_price = Some(input);
            self
        }
        /// <p>The hourly rate Amazon Redshift charges you for this reserved node.</p>
        pub fn set_usage_price(mut self, input: std::option::Option<f64>) -> Self {
            self.usage_price = input;
            self
        }
        /// <p>The currency code for the reserved cluster.</p>
        pub fn currency_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.currency_code = Some(input.into());
            self
        }
        /// <p>The currency code for the reserved cluster.</p>
        pub fn set_currency_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.currency_code = input;
            self
        }
        /// <p>The number of reserved compute nodes.</p>
        pub fn node_count(mut self, input: i32) -> Self {
            self.node_count = Some(input);
            self
        }
        /// <p>The number of reserved compute nodes.</p>
        pub fn set_node_count(mut self, input: std::option::Option<i32>) -> Self {
            self.node_count = input;
            self
        }
        /// <p>The state of the reserved compute node.</p>
        /// <p>Possible Values:</p>
        /// <ul>
        /// <li> <p>pending-payment-This reserved node has recently been purchased, and the sale has been approved, but payment has not yet been confirmed.</p> </li>
        /// <li> <p>active-This reserved node is owned by the caller and is available for use.</p> </li>
        /// <li> <p>payment-failed-Payment failed for the purchase attempt.</p> </li>
        /// <li> <p>retired-The reserved node is no longer available. </p> </li>
        /// <li> <p>exchanging-The owner is exchanging the reserved node for another reserved node.</p> </li>
        /// </ul>
        pub fn state(mut self, input: impl Into<std::string::String>) -> Self {
            self.state = Some(input.into());
            self
        }
        /// <p>The state of the reserved compute node.</p>
        /// <p>Possible Values:</p>
        /// <ul>
        /// <li> <p>pending-payment-This reserved node has recently been purchased, and the sale has been approved, but payment has not yet been confirmed.</p> </li>
        /// <li> <p>active-This reserved node is owned by the caller and is available for use.</p> </li>
        /// <li> <p>payment-failed-Payment failed for the purchase attempt.</p> </li>
        /// <li> <p>retired-The reserved node is no longer available. </p> </li>
        /// <li> <p>exchanging-The owner is exchanging the reserved node for another reserved node.</p> </li>
        /// </ul>
        pub fn set_state(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.state = input;
            self
        }
        /// <p>The anticipated utilization of the reserved node, as defined in the reserved node offering.</p>
        pub fn offering_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.offering_type = Some(input.into());
            self
        }
        /// <p>The anticipated utilization of the reserved node, as defined in the reserved node offering.</p>
        pub fn set_offering_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.offering_type = input;
            self
        }
        /// Appends an item to `recurring_charges`.
        ///
        /// To override the contents of this collection use [`set_recurring_charges`](Self::set_recurring_charges).
        ///
        /// <p>The recurring charges for the reserved node.</p>
        pub fn recurring_charges(mut self, input: crate::model::RecurringCharge) -> Self {
            let mut v = self.recurring_charges.unwrap_or_default();
            v.push(input);
            self.recurring_charges = Some(v);
            self
        }
        /// <p>The recurring charges for the reserved node.</p>
        pub fn set_recurring_charges(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RecurringCharge>>,
        ) -> Self {
            self.recurring_charges = input;
            self
        }
        /// <p></p>
        pub fn reserved_node_offering_type(
            mut self,
            input: crate::model::ReservedNodeOfferingType,
        ) -> Self {
            self.reserved_node_offering_type = Some(input);
            self
        }
        /// <p></p>
        pub fn set_reserved_node_offering_type(
            mut self,
            input: std::option::Option<crate::model::ReservedNodeOfferingType>,
        ) -> Self {
            self.reserved_node_offering_type = input;
            self
        }
        /// Consumes the builder and constructs a [`ReservedNode`](crate::model::ReservedNode)
        pub fn build(self) -> crate::model::ReservedNode {
            crate::model::ReservedNode {
                reserved_node_id: self.reserved_node_id,
                reserved_node_offering_id: self.reserved_node_offering_id,
                node_type: self.node_type,
                start_time: self.start_time,
                duration: self.duration.unwrap_or_default(),
                fixed_price: self.fixed_price.unwrap_or_default(),
                usage_price: self.usage_price.unwrap_or_default(),
                currency_code: self.currency_code,
                node_count: self.node_count.unwrap_or_default(),
                state: self.state,
                offering_type: self.offering_type,
                recurring_charges: self.recurring_charges,
                reserved_node_offering_type: self.reserved_node_offering_type,
            }
        }
    }
}
impl ReservedNode {
    /// Creates a new builder-style object to manufacture [`ReservedNode`](crate::model::ReservedNode)
    pub fn builder() -> crate::model::reserved_node::Builder {
        crate::model::reserved_node::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ReservedNodeOfferingType {
    #[allow(missing_docs)] // documentation missing in model
    Regular,
    #[allow(missing_docs)] // documentation missing in model
    Upgradable,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ReservedNodeOfferingType {
    fn from(s: &str) -> Self {
        match s {
            "Regular" => ReservedNodeOfferingType::Regular,
            "Upgradable" => ReservedNodeOfferingType::Upgradable,
            other => ReservedNodeOfferingType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ReservedNodeOfferingType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ReservedNodeOfferingType::from(s))
    }
}
impl ReservedNodeOfferingType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ReservedNodeOfferingType::Regular => "Regular",
            ReservedNodeOfferingType::Upgradable => "Upgradable",
            ReservedNodeOfferingType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Regular", "Upgradable"]
    }
}
impl AsRef<str> for ReservedNodeOfferingType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes a recurring charge.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RecurringCharge {
    /// <p>The amount charged per the period of time specified by the recurring charge frequency.</p>
    pub recurring_charge_amount: f64,
    /// <p>The frequency at which the recurring charge amount is applied.</p>
    pub recurring_charge_frequency: std::option::Option<std::string::String>,
}
impl RecurringCharge {
    /// <p>The amount charged per the period of time specified by the recurring charge frequency.</p>
    pub fn recurring_charge_amount(&self) -> f64 {
        self.recurring_charge_amount
    }
    /// <p>The frequency at which the recurring charge amount is applied.</p>
    pub fn recurring_charge_frequency(&self) -> std::option::Option<&str> {
        self.recurring_charge_frequency.as_deref()
    }
}
impl std::fmt::Debug for RecurringCharge {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RecurringCharge");
        formatter.field("recurring_charge_amount", &self.recurring_charge_amount);
        formatter.field(
            "recurring_charge_frequency",
            &self.recurring_charge_frequency,
        );
        formatter.finish()
    }
}
/// See [`RecurringCharge`](crate::model::RecurringCharge)
pub mod recurring_charge {
    /// A builder for [`RecurringCharge`](crate::model::RecurringCharge)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) recurring_charge_amount: std::option::Option<f64>,
        pub(crate) recurring_charge_frequency: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The amount charged per the period of time specified by the recurring charge frequency.</p>
        pub fn recurring_charge_amount(mut self, input: f64) -> Self {
            self.recurring_charge_amount = Some(input);
            self
        }
        /// <p>The amount charged per the period of time specified by the recurring charge frequency.</p>
        pub fn set_recurring_charge_amount(mut self, input: std::option::Option<f64>) -> Self {
            self.recurring_charge_amount = input;
            self
        }
        /// <p>The frequency at which the recurring charge amount is applied.</p>
        pub fn recurring_charge_frequency(mut self, input: impl Into<std::string::String>) -> Self {
            self.recurring_charge_frequency = Some(input.into());
            self
        }
        /// <p>The frequency at which the recurring charge amount is applied.</p>
        pub fn set_recurring_charge_frequency(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recurring_charge_frequency = input;
            self
        }
        /// Consumes the builder and constructs a [`RecurringCharge`](crate::model::RecurringCharge)
        pub fn build(self) -> crate::model::RecurringCharge {
            crate::model::RecurringCharge {
                recurring_charge_amount: self.recurring_charge_amount.unwrap_or_default(),
                recurring_charge_frequency: self.recurring_charge_frequency,
            }
        }
    }
}
impl RecurringCharge {
    /// Creates a new builder-style object to manufacture [`RecurringCharge`](crate::model::RecurringCharge)
    pub fn builder() -> crate::model::recurring_charge::Builder {
        crate::model::recurring_charge::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum UsageLimitBreachAction {
    #[allow(missing_docs)] // documentation missing in model
    Disable,
    #[allow(missing_docs)] // documentation missing in model
    EmitMetric,
    #[allow(missing_docs)] // documentation missing in model
    Log,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for UsageLimitBreachAction {
    fn from(s: &str) -> Self {
        match s {
            "disable" => UsageLimitBreachAction::Disable,
            "emit-metric" => UsageLimitBreachAction::EmitMetric,
            "log" => UsageLimitBreachAction::Log,
            other => UsageLimitBreachAction::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for UsageLimitBreachAction {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(UsageLimitBreachAction::from(s))
    }
}
impl UsageLimitBreachAction {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            UsageLimitBreachAction::Disable => "disable",
            UsageLimitBreachAction::EmitMetric => "emit-metric",
            UsageLimitBreachAction::Log => "log",
            UsageLimitBreachAction::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["disable", "emit-metric", "log"]
    }
}
impl AsRef<str> for UsageLimitBreachAction {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum UsageLimitPeriod {
    #[allow(missing_docs)] // documentation missing in model
    Daily,
    #[allow(missing_docs)] // documentation missing in model
    Monthly,
    #[allow(missing_docs)] // documentation missing in model
    Weekly,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for UsageLimitPeriod {
    fn from(s: &str) -> Self {
        match s {
            "daily" => UsageLimitPeriod::Daily,
            "monthly" => UsageLimitPeriod::Monthly,
            "weekly" => UsageLimitPeriod::Weekly,
            other => UsageLimitPeriod::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for UsageLimitPeriod {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(UsageLimitPeriod::from(s))
    }
}
impl UsageLimitPeriod {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            UsageLimitPeriod::Daily => "daily",
            UsageLimitPeriod::Monthly => "monthly",
            UsageLimitPeriod::Weekly => "weekly",
            UsageLimitPeriod::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["daily", "monthly", "weekly"]
    }
}
impl AsRef<str> for UsageLimitPeriod {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum UsageLimitLimitType {
    #[allow(missing_docs)] // documentation missing in model
    DataScanned,
    #[allow(missing_docs)] // documentation missing in model
    Time,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for UsageLimitLimitType {
    fn from(s: &str) -> Self {
        match s {
            "data-scanned" => UsageLimitLimitType::DataScanned,
            "time" => UsageLimitLimitType::Time,
            other => UsageLimitLimitType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for UsageLimitLimitType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(UsageLimitLimitType::from(s))
    }
}
impl UsageLimitLimitType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            UsageLimitLimitType::DataScanned => "data-scanned",
            UsageLimitLimitType::Time => "time",
            UsageLimitLimitType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["data-scanned", "time"]
    }
}
impl AsRef<str> for UsageLimitLimitType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum UsageLimitFeatureType {
    #[allow(missing_docs)] // documentation missing in model
    ConcurrencyScaling,
    #[allow(missing_docs)] // documentation missing in model
    CrossRegionDatasharing,
    #[allow(missing_docs)] // documentation missing in model
    Spectrum,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for UsageLimitFeatureType {
    fn from(s: &str) -> Self {
        match s {
            "concurrency-scaling" => UsageLimitFeatureType::ConcurrencyScaling,
            "cross-region-datasharing" => UsageLimitFeatureType::CrossRegionDatasharing,
            "spectrum" => UsageLimitFeatureType::Spectrum,
            other => UsageLimitFeatureType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for UsageLimitFeatureType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(UsageLimitFeatureType::from(s))
    }
}
impl UsageLimitFeatureType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            UsageLimitFeatureType::ConcurrencyScaling => "concurrency-scaling",
            UsageLimitFeatureType::CrossRegionDatasharing => "cross-region-datasharing",
            UsageLimitFeatureType::Spectrum => "spectrum",
            UsageLimitFeatureType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "concurrency-scaling",
            "cross-region-datasharing",
            "spectrum",
        ]
    }
}
impl AsRef<str> for UsageLimitFeatureType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ClusterAssociatedToSchedule {
    /// <p></p>
    pub cluster_identifier: std::option::Option<std::string::String>,
    /// <p></p>
    pub schedule_association_state: std::option::Option<crate::model::ScheduleState>,
}
impl ClusterAssociatedToSchedule {
    /// <p></p>
    pub fn cluster_identifier(&self) -> std::option::Option<&str> {
        self.cluster_identifier.as_deref()
    }
    /// <p></p>
    pub fn schedule_association_state(&self) -> std::option::Option<&crate::model::ScheduleState> {
        self.schedule_association_state.as_ref()
    }
}
impl std::fmt::Debug for ClusterAssociatedToSchedule {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ClusterAssociatedToSchedule");
        formatter.field("cluster_identifier", &self.cluster_identifier);
        formatter.field(
            "schedule_association_state",
            &self.schedule_association_state,
        );
        formatter.finish()
    }
}
/// See [`ClusterAssociatedToSchedule`](crate::model::ClusterAssociatedToSchedule)
pub mod cluster_associated_to_schedule {
    /// A builder for [`ClusterAssociatedToSchedule`](crate::model::ClusterAssociatedToSchedule)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) schedule_association_state: std::option::Option<crate::model::ScheduleState>,
    }
    impl Builder {
        /// <p></p>
        pub fn cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_identifier = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cluster_identifier = input;
            self
        }
        /// <p></p>
        pub fn schedule_association_state(mut self, input: crate::model::ScheduleState) -> Self {
            self.schedule_association_state = Some(input);
            self
        }
        /// <p></p>
        pub fn set_schedule_association_state(
            mut self,
            input: std::option::Option<crate::model::ScheduleState>,
        ) -> Self {
            self.schedule_association_state = input;
            self
        }
        /// Consumes the builder and constructs a [`ClusterAssociatedToSchedule`](crate::model::ClusterAssociatedToSchedule)
        pub fn build(self) -> crate::model::ClusterAssociatedToSchedule {
            crate::model::ClusterAssociatedToSchedule {
                cluster_identifier: self.cluster_identifier,
                schedule_association_state: self.schedule_association_state,
            }
        }
    }
}
impl ClusterAssociatedToSchedule {
    /// Creates a new builder-style object to manufacture [`ClusterAssociatedToSchedule`](crate::model::ClusterAssociatedToSchedule)
    pub fn builder() -> crate::model::cluster_associated_to_schedule::Builder {
        crate::model::cluster_associated_to_schedule::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ScheduledActionState {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ScheduledActionState {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => ScheduledActionState::Active,
            "DISABLED" => ScheduledActionState::Disabled,
            other => ScheduledActionState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ScheduledActionState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ScheduledActionState::from(s))
    }
}
impl ScheduledActionState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ScheduledActionState::Active => "ACTIVE",
            ScheduledActionState::Disabled => "DISABLED",
            ScheduledActionState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVE", "DISABLED"]
    }
}
impl AsRef<str> for ScheduledActionState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The action type that specifies an Amazon Redshift API operation that is supported by the Amazon Redshift scheduler. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ScheduledActionType {
    /// <p>An action that runs a <code>ResizeCluster</code> API operation. </p>
    pub resize_cluster: std::option::Option<crate::model::ResizeClusterMessage>,
    /// <p>An action that runs a <code>PauseCluster</code> API operation. </p>
    pub pause_cluster: std::option::Option<crate::model::PauseClusterMessage>,
    /// <p>An action that runs a <code>ResumeCluster</code> API operation. </p>
    pub resume_cluster: std::option::Option<crate::model::ResumeClusterMessage>,
}
impl ScheduledActionType {
    /// <p>An action that runs a <code>ResizeCluster</code> API operation. </p>
    pub fn resize_cluster(&self) -> std::option::Option<&crate::model::ResizeClusterMessage> {
        self.resize_cluster.as_ref()
    }
    /// <p>An action that runs a <code>PauseCluster</code> API operation. </p>
    pub fn pause_cluster(&self) -> std::option::Option<&crate::model::PauseClusterMessage> {
        self.pause_cluster.as_ref()
    }
    /// <p>An action that runs a <code>ResumeCluster</code> API operation. </p>
    pub fn resume_cluster(&self) -> std::option::Option<&crate::model::ResumeClusterMessage> {
        self.resume_cluster.as_ref()
    }
}
impl std::fmt::Debug for ScheduledActionType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ScheduledActionType");
        formatter.field("resize_cluster", &self.resize_cluster);
        formatter.field("pause_cluster", &self.pause_cluster);
        formatter.field("resume_cluster", &self.resume_cluster);
        formatter.finish()
    }
}
/// See [`ScheduledActionType`](crate::model::ScheduledActionType)
pub mod scheduled_action_type {
    /// A builder for [`ScheduledActionType`](crate::model::ScheduledActionType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resize_cluster: std::option::Option<crate::model::ResizeClusterMessage>,
        pub(crate) pause_cluster: std::option::Option<crate::model::PauseClusterMessage>,
        pub(crate) resume_cluster: std::option::Option<crate::model::ResumeClusterMessage>,
    }
    impl Builder {
        /// <p>An action that runs a <code>ResizeCluster</code> API operation. </p>
        pub fn resize_cluster(mut self, input: crate::model::ResizeClusterMessage) -> Self {
            self.resize_cluster = Some(input);
            self
        }
        /// <p>An action that runs a <code>ResizeCluster</code> API operation. </p>
        pub fn set_resize_cluster(
            mut self,
            input: std::option::Option<crate::model::ResizeClusterMessage>,
        ) -> Self {
            self.resize_cluster = input;
            self
        }
        /// <p>An action that runs a <code>PauseCluster</code> API operation. </p>
        pub fn pause_cluster(mut self, input: crate::model::PauseClusterMessage) -> Self {
            self.pause_cluster = Some(input);
            self
        }
        /// <p>An action that runs a <code>PauseCluster</code> API operation. </p>
        pub fn set_pause_cluster(
            mut self,
            input: std::option::Option<crate::model::PauseClusterMessage>,
        ) -> Self {
            self.pause_cluster = input;
            self
        }
        /// <p>An action that runs a <code>ResumeCluster</code> API operation. </p>
        pub fn resume_cluster(mut self, input: crate::model::ResumeClusterMessage) -> Self {
            self.resume_cluster = Some(input);
            self
        }
        /// <p>An action that runs a <code>ResumeCluster</code> API operation. </p>
        pub fn set_resume_cluster(
            mut self,
            input: std::option::Option<crate::model::ResumeClusterMessage>,
        ) -> Self {
            self.resume_cluster = input;
            self
        }
        /// Consumes the builder and constructs a [`ScheduledActionType`](crate::model::ScheduledActionType)
        pub fn build(self) -> crate::model::ScheduledActionType {
            crate::model::ScheduledActionType {
                resize_cluster: self.resize_cluster,
                pause_cluster: self.pause_cluster,
                resume_cluster: self.resume_cluster,
            }
        }
    }
}
impl ScheduledActionType {
    /// Creates a new builder-style object to manufacture [`ScheduledActionType`](crate::model::ScheduledActionType)
    pub fn builder() -> crate::model::scheduled_action_type::Builder {
        crate::model::scheduled_action_type::Builder::default()
    }
}

/// <p>Describes a resume cluster operation. For example, a scheduled action to run the <code>ResumeCluster</code> API operation. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResumeClusterMessage {
    /// <p>The identifier of the cluster to be resumed.</p>
    pub cluster_identifier: std::option::Option<std::string::String>,
}
impl ResumeClusterMessage {
    /// <p>The identifier of the cluster to be resumed.</p>
    pub fn cluster_identifier(&self) -> std::option::Option<&str> {
        self.cluster_identifier.as_deref()
    }
}
impl std::fmt::Debug for ResumeClusterMessage {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResumeClusterMessage");
        formatter.field("cluster_identifier", &self.cluster_identifier);
        formatter.finish()
    }
}
/// See [`ResumeClusterMessage`](crate::model::ResumeClusterMessage)
pub mod resume_cluster_message {
    /// A builder for [`ResumeClusterMessage`](crate::model::ResumeClusterMessage)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_identifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the cluster to be resumed.</p>
        pub fn cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_identifier = Some(input.into());
            self
        }
        /// <p>The identifier of the cluster to be resumed.</p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cluster_identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`ResumeClusterMessage`](crate::model::ResumeClusterMessage)
        pub fn build(self) -> crate::model::ResumeClusterMessage {
            crate::model::ResumeClusterMessage {
                cluster_identifier: self.cluster_identifier,
            }
        }
    }
}
impl ResumeClusterMessage {
    /// Creates a new builder-style object to manufacture [`ResumeClusterMessage`](crate::model::ResumeClusterMessage)
    pub fn builder() -> crate::model::resume_cluster_message::Builder {
        crate::model::resume_cluster_message::Builder::default()
    }
}

/// <p>Describes a pause cluster operation. For example, a scheduled action to run the <code>PauseCluster</code> API operation. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PauseClusterMessage {
    /// <p>The identifier of the cluster to be paused.</p>
    pub cluster_identifier: std::option::Option<std::string::String>,
}
impl PauseClusterMessage {
    /// <p>The identifier of the cluster to be paused.</p>
    pub fn cluster_identifier(&self) -> std::option::Option<&str> {
        self.cluster_identifier.as_deref()
    }
}
impl std::fmt::Debug for PauseClusterMessage {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PauseClusterMessage");
        formatter.field("cluster_identifier", &self.cluster_identifier);
        formatter.finish()
    }
}
/// See [`PauseClusterMessage`](crate::model::PauseClusterMessage)
pub mod pause_cluster_message {
    /// A builder for [`PauseClusterMessage`](crate::model::PauseClusterMessage)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_identifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the cluster to be paused.</p>
        pub fn cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_identifier = Some(input.into());
            self
        }
        /// <p>The identifier of the cluster to be paused.</p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cluster_identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`PauseClusterMessage`](crate::model::PauseClusterMessage)
        pub fn build(self) -> crate::model::PauseClusterMessage {
            crate::model::PauseClusterMessage {
                cluster_identifier: self.cluster_identifier,
            }
        }
    }
}
impl PauseClusterMessage {
    /// Creates a new builder-style object to manufacture [`PauseClusterMessage`](crate::model::PauseClusterMessage)
    pub fn builder() -> crate::model::pause_cluster_message::Builder {
        crate::model::pause_cluster_message::Builder::default()
    }
}

/// <p>Describes a resize cluster operation. For example, a scheduled action to run the <code>ResizeCluster</code> API operation. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResizeClusterMessage {
    /// <p>The unique identifier for the cluster to resize.</p>
    pub cluster_identifier: std::option::Option<std::string::String>,
    /// <p>The new cluster type for the specified cluster.</p>
    pub cluster_type: std::option::Option<std::string::String>,
    /// <p>The new node type for the nodes you are adding. If not specified, the cluster's current node type is used.</p>
    pub node_type: std::option::Option<std::string::String>,
    /// <p>The new number of nodes for the cluster. If not specified, the cluster's current number of nodes is used.</p>
    pub number_of_nodes: std::option::Option<i32>,
    /// <p>A boolean value indicating whether the resize operation is using the classic resize process. If you don't provide this parameter or set the value to <code>false</code>, the resize type is elastic. </p>
    pub classic: std::option::Option<bool>,
    /// <p>The identifier of the reserved node.</p>
    pub reserved_node_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the target reserved node offering.</p>
    pub target_reserved_node_offering_id: std::option::Option<std::string::String>,
}
impl ResizeClusterMessage {
    /// <p>The unique identifier for the cluster to resize.</p>
    pub fn cluster_identifier(&self) -> std::option::Option<&str> {
        self.cluster_identifier.as_deref()
    }
    /// <p>The new cluster type for the specified cluster.</p>
    pub fn cluster_type(&self) -> std::option::Option<&str> {
        self.cluster_type.as_deref()
    }
    /// <p>The new node type for the nodes you are adding. If not specified, the cluster's current node type is used.</p>
    pub fn node_type(&self) -> std::option::Option<&str> {
        self.node_type.as_deref()
    }
    /// <p>The new number of nodes for the cluster. If not specified, the cluster's current number of nodes is used.</p>
    pub fn number_of_nodes(&self) -> std::option::Option<i32> {
        self.number_of_nodes
    }
    /// <p>A boolean value indicating whether the resize operation is using the classic resize process. If you don't provide this parameter or set the value to <code>false</code>, the resize type is elastic. </p>
    pub fn classic(&self) -> std::option::Option<bool> {
        self.classic
    }
    /// <p>The identifier of the reserved node.</p>
    pub fn reserved_node_id(&self) -> std::option::Option<&str> {
        self.reserved_node_id.as_deref()
    }
    /// <p>The identifier of the target reserved node offering.</p>
    pub fn target_reserved_node_offering_id(&self) -> std::option::Option<&str> {
        self.target_reserved_node_offering_id.as_deref()
    }
}
impl std::fmt::Debug for ResizeClusterMessage {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResizeClusterMessage");
        formatter.field("cluster_identifier", &self.cluster_identifier);
        formatter.field("cluster_type", &self.cluster_type);
        formatter.field("node_type", &self.node_type);
        formatter.field("number_of_nodes", &self.number_of_nodes);
        formatter.field("classic", &self.classic);
        formatter.field("reserved_node_id", &self.reserved_node_id);
        formatter.field(
            "target_reserved_node_offering_id",
            &self.target_reserved_node_offering_id,
        );
        formatter.finish()
    }
}
/// See [`ResizeClusterMessage`](crate::model::ResizeClusterMessage)
pub mod resize_cluster_message {
    /// A builder for [`ResizeClusterMessage`](crate::model::ResizeClusterMessage)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) cluster_type: std::option::Option<std::string::String>,
        pub(crate) node_type: std::option::Option<std::string::String>,
        pub(crate) number_of_nodes: std::option::Option<i32>,
        pub(crate) classic: std::option::Option<bool>,
        pub(crate) reserved_node_id: std::option::Option<std::string::String>,
        pub(crate) target_reserved_node_offering_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the cluster to resize.</p>
        pub fn cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_identifier = Some(input.into());
            self
        }
        /// <p>The unique identifier for the cluster to resize.</p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cluster_identifier = input;
            self
        }
        /// <p>The new cluster type for the specified cluster.</p>
        pub fn cluster_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_type = Some(input.into());
            self
        }
        /// <p>The new cluster type for the specified cluster.</p>
        pub fn set_cluster_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster_type = input;
            self
        }
        /// <p>The new node type for the nodes you are adding. If not specified, the cluster's current node type is used.</p>
        pub fn node_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.node_type = Some(input.into());
            self
        }
        /// <p>The new node type for the nodes you are adding. If not specified, the cluster's current node type is used.</p>
        pub fn set_node_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.node_type = input;
            self
        }
        /// <p>The new number of nodes for the cluster. If not specified, the cluster's current number of nodes is used.</p>
        pub fn number_of_nodes(mut self, input: i32) -> Self {
            self.number_of_nodes = Some(input);
            self
        }
        /// <p>The new number of nodes for the cluster. If not specified, the cluster's current number of nodes is used.</p>
        pub fn set_number_of_nodes(mut self, input: std::option::Option<i32>) -> Self {
            self.number_of_nodes = input;
            self
        }
        /// <p>A boolean value indicating whether the resize operation is using the classic resize process. If you don't provide this parameter or set the value to <code>false</code>, the resize type is elastic. </p>
        pub fn classic(mut self, input: bool) -> Self {
            self.classic = Some(input);
            self
        }
        /// <p>A boolean value indicating whether the resize operation is using the classic resize process. If you don't provide this parameter or set the value to <code>false</code>, the resize type is elastic. </p>
        pub fn set_classic(mut self, input: std::option::Option<bool>) -> Self {
            self.classic = input;
            self
        }
        /// <p>The identifier of the reserved node.</p>
        pub fn reserved_node_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.reserved_node_id = Some(input.into());
            self
        }
        /// <p>The identifier of the reserved node.</p>
        pub fn set_reserved_node_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.reserved_node_id = input;
            self
        }
        /// <p>The identifier of the target reserved node offering.</p>
        pub fn target_reserved_node_offering_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.target_reserved_node_offering_id = Some(input.into());
            self
        }
        /// <p>The identifier of the target reserved node offering.</p>
        pub fn set_target_reserved_node_offering_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_reserved_node_offering_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ResizeClusterMessage`](crate::model::ResizeClusterMessage)
        pub fn build(self) -> crate::model::ResizeClusterMessage {
            crate::model::ResizeClusterMessage {
                cluster_identifier: self.cluster_identifier,
                cluster_type: self.cluster_type,
                node_type: self.node_type,
                number_of_nodes: self.number_of_nodes,
                classic: self.classic,
                reserved_node_id: self.reserved_node_id,
                target_reserved_node_offering_id: self.target_reserved_node_offering_id,
            }
        }
    }
}
impl ResizeClusterMessage {
    /// Creates a new builder-style object to manufacture [`ResizeClusterMessage`](crate::model::ResizeClusterMessage)
    pub fn builder() -> crate::model::resize_cluster_message::Builder {
        crate::model::resize_cluster_message::Builder::default()
    }
}

/// <p>Describes event subscriptions.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EventSubscription {
    /// <p>The Amazon Web Services account associated with the Amazon Redshift event notification subscription.</p>
    pub customer_aws_id: std::option::Option<std::string::String>,
    /// <p>The name of the Amazon Redshift event notification subscription.</p>
    pub cust_subscription_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the Amazon SNS topic used by the event notification subscription.</p>
    pub sns_topic_arn: std::option::Option<std::string::String>,
    /// <p>The status of the Amazon Redshift event notification subscription.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li> <p>Can be one of the following: active | no-permission | topic-not-exist</p> </li>
    /// <li> <p>The status "no-permission" indicates that Amazon Redshift no longer has permission to post to the Amazon SNS topic. The status "topic-not-exist" indicates that the topic was deleted after the subscription was created.</p> </li>
    /// </ul>
    pub status: std::option::Option<std::string::String>,
    /// <p>The date and time the Amazon Redshift event notification subscription was created.</p>
    pub subscription_creation_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The source type of the events returned by the Amazon Redshift event notification, such as cluster, cluster-snapshot, cluster-parameter-group, cluster-security-group, or scheduled-action. </p>
    pub source_type: std::option::Option<std::string::String>,
    /// <p>A list of the sources that publish events to the Amazon Redshift event notification subscription.</p>
    pub source_ids_list: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The list of Amazon Redshift event categories specified in the event notification subscription.</p>
    /// <p>Values: Configuration, Management, Monitoring, Security, Pending</p>
    pub event_categories_list: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The event severity specified in the Amazon Redshift event notification subscription.</p>
    /// <p>Values: ERROR, INFO</p>
    pub severity: std::option::Option<std::string::String>,
    /// <p>A boolean value indicating whether the subscription is enabled; <code>true</code> indicates that the subscription is enabled.</p>
    pub enabled: bool,
    /// <p>The list of tags for the event subscription.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl EventSubscription {
    /// <p>The Amazon Web Services account associated with the Amazon Redshift event notification subscription.</p>
    pub fn customer_aws_id(&self) -> std::option::Option<&str> {
        self.customer_aws_id.as_deref()
    }
    /// <p>The name of the Amazon Redshift event notification subscription.</p>
    pub fn cust_subscription_id(&self) -> std::option::Option<&str> {
        self.cust_subscription_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the Amazon SNS topic used by the event notification subscription.</p>
    pub fn sns_topic_arn(&self) -> std::option::Option<&str> {
        self.sns_topic_arn.as_deref()
    }
    /// <p>The status of the Amazon Redshift event notification subscription.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li> <p>Can be one of the following: active | no-permission | topic-not-exist</p> </li>
    /// <li> <p>The status "no-permission" indicates that Amazon Redshift no longer has permission to post to the Amazon SNS topic. The status "topic-not-exist" indicates that the topic was deleted after the subscription was created.</p> </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>The date and time the Amazon Redshift event notification subscription was created.</p>
    pub fn subscription_creation_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.subscription_creation_time.as_ref()
    }
    /// <p>The source type of the events returned by the Amazon Redshift event notification, such as cluster, cluster-snapshot, cluster-parameter-group, cluster-security-group, or scheduled-action. </p>
    pub fn source_type(&self) -> std::option::Option<&str> {
        self.source_type.as_deref()
    }
    /// <p>A list of the sources that publish events to the Amazon Redshift event notification subscription.</p>
    pub fn source_ids_list(&self) -> std::option::Option<&[std::string::String]> {
        self.source_ids_list.as_deref()
    }
    /// <p>The list of Amazon Redshift event categories specified in the event notification subscription.</p>
    /// <p>Values: Configuration, Management, Monitoring, Security, Pending</p>
    pub fn event_categories_list(&self) -> std::option::Option<&[std::string::String]> {
        self.event_categories_list.as_deref()
    }
    /// <p>The event severity specified in the Amazon Redshift event notification subscription.</p>
    /// <p>Values: ERROR, INFO</p>
    pub fn severity(&self) -> std::option::Option<&str> {
        self.severity.as_deref()
    }
    /// <p>A boolean value indicating whether the subscription is enabled; <code>true</code> indicates that the subscription is enabled.</p>
    pub fn enabled(&self) -> bool {
        self.enabled
    }
    /// <p>The list of tags for the event subscription.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for EventSubscription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EventSubscription");
        formatter.field("customer_aws_id", &self.customer_aws_id);
        formatter.field("cust_subscription_id", &self.cust_subscription_id);
        formatter.field("sns_topic_arn", &self.sns_topic_arn);
        formatter.field("status", &self.status);
        formatter.field(
            "subscription_creation_time",
            &self.subscription_creation_time,
        );
        formatter.field("source_type", &self.source_type);
        formatter.field("source_ids_list", &self.source_ids_list);
        formatter.field("event_categories_list", &self.event_categories_list);
        formatter.field("severity", &self.severity);
        formatter.field("enabled", &self.enabled);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`EventSubscription`](crate::model::EventSubscription)
pub mod event_subscription {
    /// A builder for [`EventSubscription`](crate::model::EventSubscription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) customer_aws_id: std::option::Option<std::string::String>,
        pub(crate) cust_subscription_id: std::option::Option<std::string::String>,
        pub(crate) sns_topic_arn: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) subscription_creation_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) source_type: std::option::Option<std::string::String>,
        pub(crate) source_ids_list: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) event_categories_list: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) severity: std::option::Option<std::string::String>,
        pub(crate) enabled: std::option::Option<bool>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The Amazon Web Services account associated with the Amazon Redshift event notification subscription.</p>
        pub fn customer_aws_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.customer_aws_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account associated with the Amazon Redshift event notification subscription.</p>
        pub fn set_customer_aws_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.customer_aws_id = input;
            self
        }
        /// <p>The name of the Amazon Redshift event notification subscription.</p>
        pub fn cust_subscription_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.cust_subscription_id = Some(input.into());
            self
        }
        /// <p>The name of the Amazon Redshift event notification subscription.</p>
        pub fn set_cust_subscription_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cust_subscription_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon SNS topic used by the event notification subscription.</p>
        pub fn sns_topic_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.sns_topic_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon SNS topic used by the event notification subscription.</p>
        pub fn set_sns_topic_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sns_topic_arn = input;
            self
        }
        /// <p>The status of the Amazon Redshift event notification subscription.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Can be one of the following: active | no-permission | topic-not-exist</p> </li>
        /// <li> <p>The status "no-permission" indicates that Amazon Redshift no longer has permission to post to the Amazon SNS topic. The status "topic-not-exist" indicates that the topic was deleted after the subscription was created.</p> </li>
        /// </ul>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the Amazon Redshift event notification subscription.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Can be one of the following: active | no-permission | topic-not-exist</p> </li>
        /// <li> <p>The status "no-permission" indicates that Amazon Redshift no longer has permission to post to the Amazon SNS topic. The status "topic-not-exist" indicates that the topic was deleted after the subscription was created.</p> </li>
        /// </ul>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>The date and time the Amazon Redshift event notification subscription was created.</p>
        pub fn subscription_creation_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.subscription_creation_time = Some(input);
            self
        }
        /// <p>The date and time the Amazon Redshift event notification subscription was created.</p>
        pub fn set_subscription_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.subscription_creation_time = input;
            self
        }
        /// <p>The source type of the events returned by the Amazon Redshift event notification, such as cluster, cluster-snapshot, cluster-parameter-group, cluster-security-group, or scheduled-action. </p>
        pub fn source_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_type = Some(input.into());
            self
        }
        /// <p>The source type of the events returned by the Amazon Redshift event notification, such as cluster, cluster-snapshot, cluster-parameter-group, cluster-security-group, or scheduled-action. </p>
        pub fn set_source_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source_type = input;
            self
        }
        /// Appends an item to `source_ids_list`.
        ///
        /// To override the contents of this collection use [`set_source_ids_list`](Self::set_source_ids_list).
        ///
        /// <p>A list of the sources that publish events to the Amazon Redshift event notification subscription.</p>
        pub fn source_ids_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.source_ids_list.unwrap_or_default();
            v.push(input.into());
            self.source_ids_list = Some(v);
            self
        }
        /// <p>A list of the sources that publish events to the Amazon Redshift event notification subscription.</p>
        pub fn set_source_ids_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.source_ids_list = input;
            self
        }
        /// Appends an item to `event_categories_list`.
        ///
        /// To override the contents of this collection use [`set_event_categories_list`](Self::set_event_categories_list).
        ///
        /// <p>The list of Amazon Redshift event categories specified in the event notification subscription.</p>
        /// <p>Values: Configuration, Management, Monitoring, Security, Pending</p>
        pub fn event_categories_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.event_categories_list.unwrap_or_default();
            v.push(input.into());
            self.event_categories_list = Some(v);
            self
        }
        /// <p>The list of Amazon Redshift event categories specified in the event notification subscription.</p>
        /// <p>Values: Configuration, Management, Monitoring, Security, Pending</p>
        pub fn set_event_categories_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.event_categories_list = input;
            self
        }
        /// <p>The event severity specified in the Amazon Redshift event notification subscription.</p>
        /// <p>Values: ERROR, INFO</p>
        pub fn severity(mut self, input: impl Into<std::string::String>) -> Self {
            self.severity = Some(input.into());
            self
        }
        /// <p>The event severity specified in the Amazon Redshift event notification subscription.</p>
        /// <p>Values: ERROR, INFO</p>
        pub fn set_severity(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.severity = input;
            self
        }
        /// <p>A boolean value indicating whether the subscription is enabled; <code>true</code> indicates that the subscription is enabled.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>A boolean value indicating whether the subscription is enabled; <code>true</code> indicates that the subscription is enabled.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The list of tags for the event subscription.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The list of tags for the event subscription.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`EventSubscription`](crate::model::EventSubscription)
        pub fn build(self) -> crate::model::EventSubscription {
            crate::model::EventSubscription {
                customer_aws_id: self.customer_aws_id,
                cust_subscription_id: self.cust_subscription_id,
                sns_topic_arn: self.sns_topic_arn,
                status: self.status,
                subscription_creation_time: self.subscription_creation_time,
                source_type: self.source_type,
                source_ids_list: self.source_ids_list,
                event_categories_list: self.event_categories_list,
                severity: self.severity,
                enabled: self.enabled.unwrap_or_default(),
                tags: self.tags,
            }
        }
    }
}
impl EventSubscription {
    /// Creates a new builder-style object to manufacture [`EventSubscription`](crate::model::EventSubscription)
    pub fn builder() -> crate::model::event_subscription::Builder {
        crate::model::event_subscription::Builder::default()
    }
}

/// <p>Describes a subnet group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ClusterSubnetGroup {
    /// <p>The name of the cluster subnet group.</p>
    pub cluster_subnet_group_name: std::option::Option<std::string::String>,
    /// <p>The description of the cluster subnet group.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The VPC ID of the cluster subnet group.</p>
    pub vpc_id: std::option::Option<std::string::String>,
    /// <p>The status of the cluster subnet group. Possible values are <code>Complete</code>, <code>Incomplete</code> and <code>Invalid</code>. </p>
    pub subnet_group_status: std::option::Option<std::string::String>,
    /// <p>A list of the VPC <code>Subnet</code> elements. </p>
    pub subnets: std::option::Option<std::vec::Vec<crate::model::Subnet>>,
    /// <p>The list of tags for the cluster subnet group.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl ClusterSubnetGroup {
    /// <p>The name of the cluster subnet group.</p>
    pub fn cluster_subnet_group_name(&self) -> std::option::Option<&str> {
        self.cluster_subnet_group_name.as_deref()
    }
    /// <p>The description of the cluster subnet group.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The VPC ID of the cluster subnet group.</p>
    pub fn vpc_id(&self) -> std::option::Option<&str> {
        self.vpc_id.as_deref()
    }
    /// <p>The status of the cluster subnet group. Possible values are <code>Complete</code>, <code>Incomplete</code> and <code>Invalid</code>. </p>
    pub fn subnet_group_status(&self) -> std::option::Option<&str> {
        self.subnet_group_status.as_deref()
    }
    /// <p>A list of the VPC <code>Subnet</code> elements. </p>
    pub fn subnets(&self) -> std::option::Option<&[crate::model::Subnet]> {
        self.subnets.as_deref()
    }
    /// <p>The list of tags for the cluster subnet group.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for ClusterSubnetGroup {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ClusterSubnetGroup");
        formatter.field("cluster_subnet_group_name", &self.cluster_subnet_group_name);
        formatter.field("description", &self.description);
        formatter.field("vpc_id", &self.vpc_id);
        formatter.field("subnet_group_status", &self.subnet_group_status);
        formatter.field("subnets", &self.subnets);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ClusterSubnetGroup`](crate::model::ClusterSubnetGroup)
pub mod cluster_subnet_group {
    /// A builder for [`ClusterSubnetGroup`](crate::model::ClusterSubnetGroup)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_subnet_group_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) vpc_id: std::option::Option<std::string::String>,
        pub(crate) subnet_group_status: std::option::Option<std::string::String>,
        pub(crate) subnets: std::option::Option<std::vec::Vec<crate::model::Subnet>>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of the cluster subnet group.</p>
        pub fn cluster_subnet_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_subnet_group_name = Some(input.into());
            self
        }
        /// <p>The name of the cluster subnet group.</p>
        pub fn set_cluster_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cluster_subnet_group_name = input;
            self
        }
        /// <p>The description of the cluster subnet group.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the cluster subnet group.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The VPC ID of the cluster subnet group.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_id = Some(input.into());
            self
        }
        /// <p>The VPC ID of the cluster subnet group.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_id = input;
            self
        }
        /// <p>The status of the cluster subnet group. Possible values are <code>Complete</code>, <code>Incomplete</code> and <code>Invalid</code>. </p>
        pub fn subnet_group_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.subnet_group_status = Some(input.into());
            self
        }
        /// <p>The status of the cluster subnet group. Possible values are <code>Complete</code>, <code>Incomplete</code> and <code>Invalid</code>. </p>
        pub fn set_subnet_group_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.subnet_group_status = input;
            self
        }
        /// Appends an item to `subnets`.
        ///
        /// To override the contents of this collection use [`set_subnets`](Self::set_subnets).
        ///
        /// <p>A list of the VPC <code>Subnet</code> elements. </p>
        pub fn subnets(mut self, input: crate::model::Subnet) -> Self {
            let mut v = self.subnets.unwrap_or_default();
            v.push(input);
            self.subnets = Some(v);
            self
        }
        /// <p>A list of the VPC <code>Subnet</code> elements. </p>
        pub fn set_subnets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Subnet>>,
        ) -> Self {
            self.subnets = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The list of tags for the cluster subnet group.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The list of tags for the cluster subnet group.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ClusterSubnetGroup`](crate::model::ClusterSubnetGroup)
        pub fn build(self) -> crate::model::ClusterSubnetGroup {
            crate::model::ClusterSubnetGroup {
                cluster_subnet_group_name: self.cluster_subnet_group_name,
                description: self.description,
                vpc_id: self.vpc_id,
                subnet_group_status: self.subnet_group_status,
                subnets: self.subnets,
                tags: self.tags,
            }
        }
    }
}
impl ClusterSubnetGroup {
    /// Creates a new builder-style object to manufacture [`ClusterSubnetGroup`](crate::model::ClusterSubnetGroup)
    pub fn builder() -> crate::model::cluster_subnet_group::Builder {
        crate::model::cluster_subnet_group::Builder::default()
    }
}

/// <p>Describes a subnet.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Subnet {
    /// <p>The identifier of the subnet.</p>
    pub subnet_identifier: std::option::Option<std::string::String>,
    /// <p></p>
    pub subnet_availability_zone: std::option::Option<crate::model::AvailabilityZone>,
    /// <p>The status of the subnet.</p>
    pub subnet_status: std::option::Option<std::string::String>,
}
impl Subnet {
    /// <p>The identifier of the subnet.</p>
    pub fn subnet_identifier(&self) -> std::option::Option<&str> {
        self.subnet_identifier.as_deref()
    }
    /// <p></p>
    pub fn subnet_availability_zone(&self) -> std::option::Option<&crate::model::AvailabilityZone> {
        self.subnet_availability_zone.as_ref()
    }
    /// <p>The status of the subnet.</p>
    pub fn subnet_status(&self) -> std::option::Option<&str> {
        self.subnet_status.as_deref()
    }
}
impl std::fmt::Debug for Subnet {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Subnet");
        formatter.field("subnet_identifier", &self.subnet_identifier);
        formatter.field("subnet_availability_zone", &self.subnet_availability_zone);
        formatter.field("subnet_status", &self.subnet_status);
        formatter.finish()
    }
}
/// See [`Subnet`](crate::model::Subnet)
pub mod subnet {
    /// A builder for [`Subnet`](crate::model::Subnet)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) subnet_identifier: std::option::Option<std::string::String>,
        pub(crate) subnet_availability_zone: std::option::Option<crate::model::AvailabilityZone>,
        pub(crate) subnet_status: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the subnet.</p>
        pub fn subnet_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.subnet_identifier = Some(input.into());
            self
        }
        /// <p>The identifier of the subnet.</p>
        pub fn set_subnet_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.subnet_identifier = input;
            self
        }
        /// <p></p>
        pub fn subnet_availability_zone(mut self, input: crate::model::AvailabilityZone) -> Self {
            self.subnet_availability_zone = Some(input);
            self
        }
        /// <p></p>
        pub fn set_subnet_availability_zone(
            mut self,
            input: std::option::Option<crate::model::AvailabilityZone>,
        ) -> Self {
            self.subnet_availability_zone = input;
            self
        }
        /// <p>The status of the subnet.</p>
        pub fn subnet_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.subnet_status = Some(input.into());
            self
        }
        /// <p>The status of the subnet.</p>
        pub fn set_subnet_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.subnet_status = input;
            self
        }
        /// Consumes the builder and constructs a [`Subnet`](crate::model::Subnet)
        pub fn build(self) -> crate::model::Subnet {
            crate::model::Subnet {
                subnet_identifier: self.subnet_identifier,
                subnet_availability_zone: self.subnet_availability_zone,
                subnet_status: self.subnet_status,
            }
        }
    }
}
impl Subnet {
    /// Creates a new builder-style object to manufacture [`Subnet`](crate::model::Subnet)
    pub fn builder() -> crate::model::subnet::Builder {
        crate::model::subnet::Builder::default()
    }
}

/// <p>Describes an availability zone.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AvailabilityZone {
    /// <p>The name of the availability zone.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p></p>
    pub supported_platforms: std::option::Option<std::vec::Vec<crate::model::SupportedPlatform>>,
}
impl AvailabilityZone {
    /// <p>The name of the availability zone.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p></p>
    pub fn supported_platforms(&self) -> std::option::Option<&[crate::model::SupportedPlatform]> {
        self.supported_platforms.as_deref()
    }
}
impl std::fmt::Debug for AvailabilityZone {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AvailabilityZone");
        formatter.field("name", &self.name);
        formatter.field("supported_platforms", &self.supported_platforms);
        formatter.finish()
    }
}
/// See [`AvailabilityZone`](crate::model::AvailabilityZone)
pub mod availability_zone {
    /// A builder for [`AvailabilityZone`](crate::model::AvailabilityZone)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) supported_platforms:
            std::option::Option<std::vec::Vec<crate::model::SupportedPlatform>>,
    }
    impl Builder {
        /// <p>The name of the availability zone.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the availability zone.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `supported_platforms`.
        ///
        /// To override the contents of this collection use [`set_supported_platforms`](Self::set_supported_platforms).
        ///
        /// <p></p>
        pub fn supported_platforms(mut self, input: crate::model::SupportedPlatform) -> Self {
            let mut v = self.supported_platforms.unwrap_or_default();
            v.push(input);
            self.supported_platforms = Some(v);
            self
        }
        /// <p></p>
        pub fn set_supported_platforms(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SupportedPlatform>>,
        ) -> Self {
            self.supported_platforms = input;
            self
        }
        /// Consumes the builder and constructs a [`AvailabilityZone`](crate::model::AvailabilityZone)
        pub fn build(self) -> crate::model::AvailabilityZone {
            crate::model::AvailabilityZone {
                name: self.name,
                supported_platforms: self.supported_platforms,
            }
        }
    }
}
impl AvailabilityZone {
    /// Creates a new builder-style object to manufacture [`AvailabilityZone`](crate::model::AvailabilityZone)
    pub fn builder() -> crate::model::availability_zone::Builder {
        crate::model::availability_zone::Builder::default()
    }
}

/// <p>A list of supported platforms for orderable clusters.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SupportedPlatform {
    /// <p></p>
    pub name: std::option::Option<std::string::String>,
}
impl SupportedPlatform {
    /// <p></p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for SupportedPlatform {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SupportedPlatform");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`SupportedPlatform`](crate::model::SupportedPlatform)
pub mod supported_platform {
    /// A builder for [`SupportedPlatform`](crate::model::SupportedPlatform)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p></p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`SupportedPlatform`](crate::model::SupportedPlatform)
        pub fn build(self) -> crate::model::SupportedPlatform {
            crate::model::SupportedPlatform { name: self.name }
        }
    }
}
impl SupportedPlatform {
    /// Creates a new builder-style object to manufacture [`SupportedPlatform`](crate::model::SupportedPlatform)
    pub fn builder() -> crate::model::supported_platform::Builder {
        crate::model::supported_platform::Builder::default()
    }
}

/// <p>Describes a reserved node offering.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReservedNodeOffering {
    /// <p>The offering identifier.</p>
    pub reserved_node_offering_id: std::option::Option<std::string::String>,
    /// <p>The node type offered by the reserved node offering.</p>
    pub node_type: std::option::Option<std::string::String>,
    /// <p>The duration, in seconds, for which the offering will reserve the node.</p>
    pub duration: i32,
    /// <p>The upfront fixed charge you will pay to purchase the specific reserved node offering.</p>
    pub fixed_price: f64,
    /// <p>The rate you are charged for each hour the cluster that is using the offering is running.</p>
    pub usage_price: f64,
    /// <p>The currency code for the compute nodes offering.</p>
    pub currency_code: std::option::Option<std::string::String>,
    /// <p>The anticipated utilization of the reserved node, as defined in the reserved node offering.</p>
    pub offering_type: std::option::Option<std::string::String>,
    /// <p>The charge to your account regardless of whether you are creating any clusters using the node offering. Recurring charges are only in effect for heavy-utilization reserved nodes.</p>
    pub recurring_charges: std::option::Option<std::vec::Vec<crate::model::RecurringCharge>>,
    /// <p></p>
    pub reserved_node_offering_type: std::option::Option<crate::model::ReservedNodeOfferingType>,
}
impl ReservedNodeOffering {
    /// <p>The offering identifier.</p>
    pub fn reserved_node_offering_id(&self) -> std::option::Option<&str> {
        self.reserved_node_offering_id.as_deref()
    }
    /// <p>The node type offered by the reserved node offering.</p>
    pub fn node_type(&self) -> std::option::Option<&str> {
        self.node_type.as_deref()
    }
    /// <p>The duration, in seconds, for which the offering will reserve the node.</p>
    pub fn duration(&self) -> i32 {
        self.duration
    }
    /// <p>The upfront fixed charge you will pay to purchase the specific reserved node offering.</p>
    pub fn fixed_price(&self) -> f64 {
        self.fixed_price
    }
    /// <p>The rate you are charged for each hour the cluster that is using the offering is running.</p>
    pub fn usage_price(&self) -> f64 {
        self.usage_price
    }
    /// <p>The currency code for the compute nodes offering.</p>
    pub fn currency_code(&self) -> std::option::Option<&str> {
        self.currency_code.as_deref()
    }
    /// <p>The anticipated utilization of the reserved node, as defined in the reserved node offering.</p>
    pub fn offering_type(&self) -> std::option::Option<&str> {
        self.offering_type.as_deref()
    }
    /// <p>The charge to your account regardless of whether you are creating any clusters using the node offering. Recurring charges are only in effect for heavy-utilization reserved nodes.</p>
    pub fn recurring_charges(&self) -> std::option::Option<&[crate::model::RecurringCharge]> {
        self.recurring_charges.as_deref()
    }
    /// <p></p>
    pub fn reserved_node_offering_type(
        &self,
    ) -> std::option::Option<&crate::model::ReservedNodeOfferingType> {
        self.reserved_node_offering_type.as_ref()
    }
}
impl std::fmt::Debug for ReservedNodeOffering {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReservedNodeOffering");
        formatter.field("reserved_node_offering_id", &self.reserved_node_offering_id);
        formatter.field("node_type", &self.node_type);
        formatter.field("duration", &self.duration);
        formatter.field("fixed_price", &self.fixed_price);
        formatter.field("usage_price", &self.usage_price);
        formatter.field("currency_code", &self.currency_code);
        formatter.field("offering_type", &self.offering_type);
        formatter.field("recurring_charges", &self.recurring_charges);
        formatter.field(
            "reserved_node_offering_type",
            &self.reserved_node_offering_type,
        );
        formatter.finish()
    }
}
/// See [`ReservedNodeOffering`](crate::model::ReservedNodeOffering)
pub mod reserved_node_offering {
    /// A builder for [`ReservedNodeOffering`](crate::model::ReservedNodeOffering)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) reserved_node_offering_id: std::option::Option<std::string::String>,
        pub(crate) node_type: std::option::Option<std::string::String>,
        pub(crate) duration: std::option::Option<i32>,
        pub(crate) fixed_price: std::option::Option<f64>,
        pub(crate) usage_price: std::option::Option<f64>,
        pub(crate) currency_code: std::option::Option<std::string::String>,
        pub(crate) offering_type: std::option::Option<std::string::String>,
        pub(crate) recurring_charges:
            std::option::Option<std::vec::Vec<crate::model::RecurringCharge>>,
        pub(crate) reserved_node_offering_type:
            std::option::Option<crate::model::ReservedNodeOfferingType>,
    }
    impl Builder {
        /// <p>The offering identifier.</p>
        pub fn reserved_node_offering_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.reserved_node_offering_id = Some(input.into());
            self
        }
        /// <p>The offering identifier.</p>
        pub fn set_reserved_node_offering_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.reserved_node_offering_id = input;
            self
        }
        /// <p>The node type offered by the reserved node offering.</p>
        pub fn node_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.node_type = Some(input.into());
            self
        }
        /// <p>The node type offered by the reserved node offering.</p>
        pub fn set_node_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.node_type = input;
            self
        }
        /// <p>The duration, in seconds, for which the offering will reserve the node.</p>
        pub fn duration(mut self, input: i32) -> Self {
            self.duration = Some(input);
            self
        }
        /// <p>The duration, in seconds, for which the offering will reserve the node.</p>
        pub fn set_duration(mut self, input: std::option::Option<i32>) -> Self {
            self.duration = input;
            self
        }
        /// <p>The upfront fixed charge you will pay to purchase the specific reserved node offering.</p>
        pub fn fixed_price(mut self, input: f64) -> Self {
            self.fixed_price = Some(input);
            self
        }
        /// <p>The upfront fixed charge you will pay to purchase the specific reserved node offering.</p>
        pub fn set_fixed_price(mut self, input: std::option::Option<f64>) -> Self {
            self.fixed_price = input;
            self
        }
        /// <p>The rate you are charged for each hour the cluster that is using the offering is running.</p>
        pub fn usage_price(mut self, input: f64) -> Self {
            self.usage_price = Some(input);
            self
        }
        /// <p>The rate you are charged for each hour the cluster that is using the offering is running.</p>
        pub fn set_usage_price(mut self, input: std::option::Option<f64>) -> Self {
            self.usage_price = input;
            self
        }
        /// <p>The currency code for the compute nodes offering.</p>
        pub fn currency_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.currency_code = Some(input.into());
            self
        }
        /// <p>The currency code for the compute nodes offering.</p>
        pub fn set_currency_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.currency_code = input;
            self
        }
        /// <p>The anticipated utilization of the reserved node, as defined in the reserved node offering.</p>
        pub fn offering_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.offering_type = Some(input.into());
            self
        }
        /// <p>The anticipated utilization of the reserved node, as defined in the reserved node offering.</p>
        pub fn set_offering_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.offering_type = input;
            self
        }
        /// Appends an item to `recurring_charges`.
        ///
        /// To override the contents of this collection use [`set_recurring_charges`](Self::set_recurring_charges).
        ///
        /// <p>The charge to your account regardless of whether you are creating any clusters using the node offering. Recurring charges are only in effect for heavy-utilization reserved nodes.</p>
        pub fn recurring_charges(mut self, input: crate::model::RecurringCharge) -> Self {
            let mut v = self.recurring_charges.unwrap_or_default();
            v.push(input);
            self.recurring_charges = Some(v);
            self
        }
        /// <p>The charge to your account regardless of whether you are creating any clusters using the node offering. Recurring charges are only in effect for heavy-utilization reserved nodes.</p>
        pub fn set_recurring_charges(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RecurringCharge>>,
        ) -> Self {
            self.recurring_charges = input;
            self
        }
        /// <p></p>
        pub fn reserved_node_offering_type(
            mut self,
            input: crate::model::ReservedNodeOfferingType,
        ) -> Self {
            self.reserved_node_offering_type = Some(input);
            self
        }
        /// <p></p>
        pub fn set_reserved_node_offering_type(
            mut self,
            input: std::option::Option<crate::model::ReservedNodeOfferingType>,
        ) -> Self {
            self.reserved_node_offering_type = input;
            self
        }
        /// Consumes the builder and constructs a [`ReservedNodeOffering`](crate::model::ReservedNodeOffering)
        pub fn build(self) -> crate::model::ReservedNodeOffering {
            crate::model::ReservedNodeOffering {
                reserved_node_offering_id: self.reserved_node_offering_id,
                node_type: self.node_type,
                duration: self.duration.unwrap_or_default(),
                fixed_price: self.fixed_price.unwrap_or_default(),
                usage_price: self.usage_price.unwrap_or_default(),
                currency_code: self.currency_code,
                offering_type: self.offering_type,
                recurring_charges: self.recurring_charges,
                reserved_node_offering_type: self.reserved_node_offering_type,
            }
        }
    }
}
impl ReservedNodeOffering {
    /// Creates a new builder-style object to manufacture [`ReservedNodeOffering`](crate::model::ReservedNodeOffering)
    pub fn builder() -> crate::model::reserved_node_offering::Builder {
        crate::model::reserved_node_offering::Builder::default()
    }
}

/// <p>Details for a reserved-node exchange. Examples include the node type for a reserved node, the price for a node, the node's state, and other details.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReservedNodeConfigurationOption {
    /// <p>Describes a reserved node. You can call the <code>DescribeReservedNodeOfferings</code> API to obtain the available reserved node offerings. </p>
    pub source_reserved_node: std::option::Option<crate::model::ReservedNode>,
    /// <p>The target reserved-node count.</p>
    pub target_reserved_node_count: i32,
    /// <p>Describes a reserved node offering.</p>
    pub target_reserved_node_offering: std::option::Option<crate::model::ReservedNodeOffering>,
}
impl ReservedNodeConfigurationOption {
    /// <p>Describes a reserved node. You can call the <code>DescribeReservedNodeOfferings</code> API to obtain the available reserved node offerings. </p>
    pub fn source_reserved_node(&self) -> std::option::Option<&crate::model::ReservedNode> {
        self.source_reserved_node.as_ref()
    }
    /// <p>The target reserved-node count.</p>
    pub fn target_reserved_node_count(&self) -> i32 {
        self.target_reserved_node_count
    }
    /// <p>Describes a reserved node offering.</p>
    pub fn target_reserved_node_offering(
        &self,
    ) -> std::option::Option<&crate::model::ReservedNodeOffering> {
        self.target_reserved_node_offering.as_ref()
    }
}
impl std::fmt::Debug for ReservedNodeConfigurationOption {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReservedNodeConfigurationOption");
        formatter.field("source_reserved_node", &self.source_reserved_node);
        formatter.field(
            "target_reserved_node_count",
            &self.target_reserved_node_count,
        );
        formatter.field(
            "target_reserved_node_offering",
            &self.target_reserved_node_offering,
        );
        formatter.finish()
    }
}
/// See [`ReservedNodeConfigurationOption`](crate::model::ReservedNodeConfigurationOption)
pub mod reserved_node_configuration_option {
    /// A builder for [`ReservedNodeConfigurationOption`](crate::model::ReservedNodeConfigurationOption)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_reserved_node: std::option::Option<crate::model::ReservedNode>,
        pub(crate) target_reserved_node_count: std::option::Option<i32>,
        pub(crate) target_reserved_node_offering:
            std::option::Option<crate::model::ReservedNodeOffering>,
    }
    impl Builder {
        /// <p>Describes a reserved node. You can call the <code>DescribeReservedNodeOfferings</code> API to obtain the available reserved node offerings. </p>
        pub fn source_reserved_node(mut self, input: crate::model::ReservedNode) -> Self {
            self.source_reserved_node = Some(input);
            self
        }
        /// <p>Describes a reserved node. You can call the <code>DescribeReservedNodeOfferings</code> API to obtain the available reserved node offerings. </p>
        pub fn set_source_reserved_node(
            mut self,
            input: std::option::Option<crate::model::ReservedNode>,
        ) -> Self {
            self.source_reserved_node = input;
            self
        }
        /// <p>The target reserved-node count.</p>
        pub fn target_reserved_node_count(mut self, input: i32) -> Self {
            self.target_reserved_node_count = Some(input);
            self
        }
        /// <p>The target reserved-node count.</p>
        pub fn set_target_reserved_node_count(mut self, input: std::option::Option<i32>) -> Self {
            self.target_reserved_node_count = input;
            self
        }
        /// <p>Describes a reserved node offering.</p>
        pub fn target_reserved_node_offering(
            mut self,
            input: crate::model::ReservedNodeOffering,
        ) -> Self {
            self.target_reserved_node_offering = Some(input);
            self
        }
        /// <p>Describes a reserved node offering.</p>
        pub fn set_target_reserved_node_offering(
            mut self,
            input: std::option::Option<crate::model::ReservedNodeOffering>,
        ) -> Self {
            self.target_reserved_node_offering = input;
            self
        }
        /// Consumes the builder and constructs a [`ReservedNodeConfigurationOption`](crate::model::ReservedNodeConfigurationOption)
        pub fn build(self) -> crate::model::ReservedNodeConfigurationOption {
            crate::model::ReservedNodeConfigurationOption {
                source_reserved_node: self.source_reserved_node,
                target_reserved_node_count: self.target_reserved_node_count.unwrap_or_default(),
                target_reserved_node_offering: self.target_reserved_node_offering,
            }
        }
    }
}
impl ReservedNodeConfigurationOption {
    /// Creates a new builder-style object to manufacture [`ReservedNodeConfigurationOption`](crate::model::ReservedNodeConfigurationOption)
    pub fn builder() -> crate::model::reserved_node_configuration_option::Builder {
        crate::model::reserved_node_configuration_option::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ReservedNodeExchangeActionType {
    #[allow(missing_docs)] // documentation missing in model
    ResizeCluster,
    #[allow(missing_docs)] // documentation missing in model
    RestoreCluster,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ReservedNodeExchangeActionType {
    fn from(s: &str) -> Self {
        match s {
            "resize-cluster" => ReservedNodeExchangeActionType::ResizeCluster,
            "restore-cluster" => ReservedNodeExchangeActionType::RestoreCluster,
            other => ReservedNodeExchangeActionType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ReservedNodeExchangeActionType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ReservedNodeExchangeActionType::from(s))
    }
}
impl ReservedNodeExchangeActionType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ReservedNodeExchangeActionType::ResizeCluster => "resize-cluster",
            ReservedNodeExchangeActionType::RestoreCluster => "restore-cluster",
            ReservedNodeExchangeActionType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["resize-cluster", "restore-cluster"]
    }
}
impl AsRef<str> for ReservedNodeExchangeActionType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LogDestinationType {
    #[allow(missing_docs)] // documentation missing in model
    Cloudwatch,
    #[allow(missing_docs)] // documentation missing in model
    S3,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LogDestinationType {
    fn from(s: &str) -> Self {
        match s {
            "cloudwatch" => LogDestinationType::Cloudwatch,
            "s3" => LogDestinationType::S3,
            other => LogDestinationType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LogDestinationType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LogDestinationType::from(s))
    }
}
impl LogDestinationType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LogDestinationType::Cloudwatch => "cloudwatch",
            LogDestinationType::S3 => "s3",
            LogDestinationType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["cloudwatch", "s3"]
    }
}
impl AsRef<str> for LogDestinationType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes a usage limit object for a cluster. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UsageLimit {
    /// <p>The identifier of the usage limit.</p>
    pub usage_limit_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the cluster with a usage limit.</p>
    pub cluster_identifier: std::option::Option<std::string::String>,
    /// <p>The Amazon Redshift feature to which the limit applies.</p>
    pub feature_type: std::option::Option<crate::model::UsageLimitFeatureType>,
    /// <p>The type of limit. Depending on the feature type, this can be based on a time duration or data size.</p>
    pub limit_type: std::option::Option<crate::model::UsageLimitLimitType>,
    /// <p>The limit amount. If time-based, this amount is in minutes. If data-based, this amount is in terabytes (TB).</p>
    pub amount: i64,
    /// <p>The time period that the amount applies to. A <code>weekly</code> period begins on Sunday. The default is <code>monthly</code>. </p>
    pub period: std::option::Option<crate::model::UsageLimitPeriod>,
    /// <p>The action that Amazon Redshift takes when the limit is reached. Possible values are: </p>
    /// <ul>
    /// <li> <p> <b>log</b> - To log an event in a system table. The default is log.</p> </li>
    /// <li> <p> <b>emit-metric</b> - To emit CloudWatch metrics.</p> </li>
    /// <li> <p> <b>disable</b> - To disable the feature until the next usage period begins.</p> </li>
    /// </ul>
    pub breach_action: std::option::Option<crate::model::UsageLimitBreachAction>,
    /// <p>A list of tag instances.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl UsageLimit {
    /// <p>The identifier of the usage limit.</p>
    pub fn usage_limit_id(&self) -> std::option::Option<&str> {
        self.usage_limit_id.as_deref()
    }
    /// <p>The identifier of the cluster with a usage limit.</p>
    pub fn cluster_identifier(&self) -> std::option::Option<&str> {
        self.cluster_identifier.as_deref()
    }
    /// <p>The Amazon Redshift feature to which the limit applies.</p>
    pub fn feature_type(&self) -> std::option::Option<&crate::model::UsageLimitFeatureType> {
        self.feature_type.as_ref()
    }
    /// <p>The type of limit. Depending on the feature type, this can be based on a time duration or data size.</p>
    pub fn limit_type(&self) -> std::option::Option<&crate::model::UsageLimitLimitType> {
        self.limit_type.as_ref()
    }
    /// <p>The limit amount. If time-based, this amount is in minutes. If data-based, this amount is in terabytes (TB).</p>
    pub fn amount(&self) -> i64 {
        self.amount
    }
    /// <p>The time period that the amount applies to. A <code>weekly</code> period begins on Sunday. The default is <code>monthly</code>. </p>
    pub fn period(&self) -> std::option::Option<&crate::model::UsageLimitPeriod> {
        self.period.as_ref()
    }
    /// <p>The action that Amazon Redshift takes when the limit is reached. Possible values are: </p>
    /// <ul>
    /// <li> <p> <b>log</b> - To log an event in a system table. The default is log.</p> </li>
    /// <li> <p> <b>emit-metric</b> - To emit CloudWatch metrics.</p> </li>
    /// <li> <p> <b>disable</b> - To disable the feature until the next usage period begins.</p> </li>
    /// </ul>
    pub fn breach_action(&self) -> std::option::Option<&crate::model::UsageLimitBreachAction> {
        self.breach_action.as_ref()
    }
    /// <p>A list of tag instances.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for UsageLimit {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UsageLimit");
        formatter.field("usage_limit_id", &self.usage_limit_id);
        formatter.field("cluster_identifier", &self.cluster_identifier);
        formatter.field("feature_type", &self.feature_type);
        formatter.field("limit_type", &self.limit_type);
        formatter.field("amount", &self.amount);
        formatter.field("period", &self.period);
        formatter.field("breach_action", &self.breach_action);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`UsageLimit`](crate::model::UsageLimit)
pub mod usage_limit {
    /// A builder for [`UsageLimit`](crate::model::UsageLimit)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) usage_limit_id: std::option::Option<std::string::String>,
        pub(crate) cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) feature_type: std::option::Option<crate::model::UsageLimitFeatureType>,
        pub(crate) limit_type: std::option::Option<crate::model::UsageLimitLimitType>,
        pub(crate) amount: std::option::Option<i64>,
        pub(crate) period: std::option::Option<crate::model::UsageLimitPeriod>,
        pub(crate) breach_action: std::option::Option<crate::model::UsageLimitBreachAction>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The identifier of the usage limit.</p>
        pub fn usage_limit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.usage_limit_id = Some(input.into());
            self
        }
        /// <p>The identifier of the usage limit.</p>
        pub fn set_usage_limit_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.usage_limit_id = input;
            self
        }
        /// <p>The identifier of the cluster with a usage limit.</p>
        pub fn cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_identifier = Some(input.into());
            self
        }
        /// <p>The identifier of the cluster with a usage limit.</p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cluster_identifier = input;
            self
        }
        /// <p>The Amazon Redshift feature to which the limit applies.</p>
        pub fn feature_type(mut self, input: crate::model::UsageLimitFeatureType) -> Self {
            self.feature_type = Some(input);
            self
        }
        /// <p>The Amazon Redshift feature to which the limit applies.</p>
        pub fn set_feature_type(
            mut self,
            input: std::option::Option<crate::model::UsageLimitFeatureType>,
        ) -> Self {
            self.feature_type = input;
            self
        }
        /// <p>The type of limit. Depending on the feature type, this can be based on a time duration or data size.</p>
        pub fn limit_type(mut self, input: crate::model::UsageLimitLimitType) -> Self {
            self.limit_type = Some(input);
            self
        }
        /// <p>The type of limit. Depending on the feature type, this can be based on a time duration or data size.</p>
        pub fn set_limit_type(
            mut self,
            input: std::option::Option<crate::model::UsageLimitLimitType>,
        ) -> Self {
            self.limit_type = input;
            self
        }
        /// <p>The limit amount. If time-based, this amount is in minutes. If data-based, this amount is in terabytes (TB).</p>
        pub fn amount(mut self, input: i64) -> Self {
            self.amount = Some(input);
            self
        }
        /// <p>The limit amount. If time-based, this amount is in minutes. If data-based, this amount is in terabytes (TB).</p>
        pub fn set_amount(mut self, input: std::option::Option<i64>) -> Self {
            self.amount = input;
            self
        }
        /// <p>The time period that the amount applies to. A <code>weekly</code> period begins on Sunday. The default is <code>monthly</code>. </p>
        pub fn period(mut self, input: crate::model::UsageLimitPeriod) -> Self {
            self.period = Some(input);
            self
        }
        /// <p>The time period that the amount applies to. A <code>weekly</code> period begins on Sunday. The default is <code>monthly</code>. </p>
        pub fn set_period(
            mut self,
            input: std::option::Option<crate::model::UsageLimitPeriod>,
        ) -> Self {
            self.period = input;
            self
        }
        /// <p>The action that Amazon Redshift takes when the limit is reached. Possible values are: </p>
        /// <ul>
        /// <li> <p> <b>log</b> - To log an event in a system table. The default is log.</p> </li>
        /// <li> <p> <b>emit-metric</b> - To emit CloudWatch metrics.</p> </li>
        /// <li> <p> <b>disable</b> - To disable the feature until the next usage period begins.</p> </li>
        /// </ul>
        pub fn breach_action(mut self, input: crate::model::UsageLimitBreachAction) -> Self {
            self.breach_action = Some(input);
            self
        }
        /// <p>The action that Amazon Redshift takes when the limit is reached. Possible values are: </p>
        /// <ul>
        /// <li> <p> <b>log</b> - To log an event in a system table. The default is log.</p> </li>
        /// <li> <p> <b>emit-metric</b> - To emit CloudWatch metrics.</p> </li>
        /// <li> <p> <b>disable</b> - To disable the feature until the next usage period begins.</p> </li>
        /// </ul>
        pub fn set_breach_action(
            mut self,
            input: std::option::Option<crate::model::UsageLimitBreachAction>,
        ) -> Self {
            self.breach_action = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tag instances.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>A list of tag instances.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`UsageLimit`](crate::model::UsageLimit)
        pub fn build(self) -> crate::model::UsageLimit {
            crate::model::UsageLimit {
                usage_limit_id: self.usage_limit_id,
                cluster_identifier: self.cluster_identifier,
                feature_type: self.feature_type,
                limit_type: self.limit_type,
                amount: self.amount.unwrap_or_default(),
                period: self.period,
                breach_action: self.breach_action,
                tags: self.tags,
            }
        }
    }
}
impl UsageLimit {
    /// Creates a new builder-style object to manufacture [`UsageLimit`](crate::model::UsageLimit)
    pub fn builder() -> crate::model::usage_limit::Builder {
        crate::model::usage_limit::Builder::default()
    }
}

/// <p>A tag and its associated resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TaggedResource {
    /// <p>The tag for the resource.</p>
    pub tag: std::option::Option<crate::model::Tag>,
    /// <p>The Amazon Resource Name (ARN) with which the tag is associated, for example: <code>arn:aws:redshift:us-east-2:123456789:cluster:t1</code>.</p>
    pub resource_name: std::option::Option<std::string::String>,
    /// <p>The type of resource with which the tag is associated. Valid resource types are: </p>
    /// <ul>
    /// <li> <p>Cluster</p> </li>
    /// <li> <p>CIDR/IP</p> </li>
    /// <li> <p>EC2 security group</p> </li>
    /// <li> <p>Snapshot</p> </li>
    /// <li> <p>Cluster security group</p> </li>
    /// <li> <p>Subnet group</p> </li>
    /// <li> <p>HSM connection</p> </li>
    /// <li> <p>HSM certificate</p> </li>
    /// <li> <p>Parameter group</p> </li>
    /// </ul>
    /// <p>For more information about Amazon Redshift resource types and constructing ARNs, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-overview.html#redshift-iam-access-control-specify-actions">Constructing an Amazon Redshift Amazon Resource Name (ARN)</a> in the Amazon Redshift Cluster Management Guide. </p>
    pub resource_type: std::option::Option<std::string::String>,
}
impl TaggedResource {
    /// <p>The tag for the resource.</p>
    pub fn tag(&self) -> std::option::Option<&crate::model::Tag> {
        self.tag.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) with which the tag is associated, for example: <code>arn:aws:redshift:us-east-2:123456789:cluster:t1</code>.</p>
    pub fn resource_name(&self) -> std::option::Option<&str> {
        self.resource_name.as_deref()
    }
    /// <p>The type of resource with which the tag is associated. Valid resource types are: </p>
    /// <ul>
    /// <li> <p>Cluster</p> </li>
    /// <li> <p>CIDR/IP</p> </li>
    /// <li> <p>EC2 security group</p> </li>
    /// <li> <p>Snapshot</p> </li>
    /// <li> <p>Cluster security group</p> </li>
    /// <li> <p>Subnet group</p> </li>
    /// <li> <p>HSM connection</p> </li>
    /// <li> <p>HSM certificate</p> </li>
    /// <li> <p>Parameter group</p> </li>
    /// </ul>
    /// <p>For more information about Amazon Redshift resource types and constructing ARNs, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-overview.html#redshift-iam-access-control-specify-actions">Constructing an Amazon Redshift Amazon Resource Name (ARN)</a> in the Amazon Redshift Cluster Management Guide. </p>
    pub fn resource_type(&self) -> std::option::Option<&str> {
        self.resource_type.as_deref()
    }
}
impl std::fmt::Debug for TaggedResource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TaggedResource");
        formatter.field("tag", &self.tag);
        formatter.field("resource_name", &self.resource_name);
        formatter.field("resource_type", &self.resource_type);
        formatter.finish()
    }
}
/// See [`TaggedResource`](crate::model::TaggedResource)
pub mod tagged_resource {
    /// A builder for [`TaggedResource`](crate::model::TaggedResource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tag: std::option::Option<crate::model::Tag>,
        pub(crate) resource_name: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The tag for the resource.</p>
        pub fn tag(mut self, input: crate::model::Tag) -> Self {
            self.tag = Some(input);
            self
        }
        /// <p>The tag for the resource.</p>
        pub fn set_tag(mut self, input: std::option::Option<crate::model::Tag>) -> Self {
            self.tag = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) with which the tag is associated, for example: <code>arn:aws:redshift:us-east-2:123456789:cluster:t1</code>.</p>
        pub fn resource_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_name = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) with which the tag is associated, for example: <code>arn:aws:redshift:us-east-2:123456789:cluster:t1</code>.</p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_name = input;
            self
        }
        /// <p>The type of resource with which the tag is associated. Valid resource types are: </p>
        /// <ul>
        /// <li> <p>Cluster</p> </li>
        /// <li> <p>CIDR/IP</p> </li>
        /// <li> <p>EC2 security group</p> </li>
        /// <li> <p>Snapshot</p> </li>
        /// <li> <p>Cluster security group</p> </li>
        /// <li> <p>Subnet group</p> </li>
        /// <li> <p>HSM connection</p> </li>
        /// <li> <p>HSM certificate</p> </li>
        /// <li> <p>Parameter group</p> </li>
        /// </ul>
        /// <p>For more information about Amazon Redshift resource types and constructing ARNs, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-overview.html#redshift-iam-access-control-specify-actions">Constructing an Amazon Redshift Amazon Resource Name (ARN)</a> in the Amazon Redshift Cluster Management Guide. </p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_type = Some(input.into());
            self
        }
        /// <p>The type of resource with which the tag is associated. Valid resource types are: </p>
        /// <ul>
        /// <li> <p>Cluster</p> </li>
        /// <li> <p>CIDR/IP</p> </li>
        /// <li> <p>EC2 security group</p> </li>
        /// <li> <p>Snapshot</p> </li>
        /// <li> <p>Cluster security group</p> </li>
        /// <li> <p>Subnet group</p> </li>
        /// <li> <p>HSM connection</p> </li>
        /// <li> <p>HSM certificate</p> </li>
        /// <li> <p>Parameter group</p> </li>
        /// </ul>
        /// <p>For more information about Amazon Redshift resource types and constructing ARNs, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-overview.html#redshift-iam-access-control-specify-actions">Constructing an Amazon Redshift Amazon Resource Name (ARN)</a> in the Amazon Redshift Cluster Management Guide. </p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Consumes the builder and constructs a [`TaggedResource`](crate::model::TaggedResource)
        pub fn build(self) -> crate::model::TaggedResource {
            crate::model::TaggedResource {
                tag: self.tag,
                resource_name: self.resource_name,
                resource_type: self.resource_type,
            }
        }
    }
}
impl TaggedResource {
    /// Creates a new builder-style object to manufacture [`TaggedResource`](crate::model::TaggedResource)
    pub fn builder() -> crate::model::tagged_resource::Builder {
        crate::model::tagged_resource::Builder::default()
    }
}

/// <p>Describes a snapshot schedule. You can set a regular interval for creating snapshots of a cluster. You can also schedule snapshots for specific dates. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SnapshotSchedule {
    /// <p>A list of ScheduleDefinitions.</p>
    pub schedule_definitions: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A unique identifier for the schedule.</p>
    pub schedule_identifier: std::option::Option<std::string::String>,
    /// <p>The description of the schedule.</p>
    pub schedule_description: std::option::Option<std::string::String>,
    /// <p>An optional set of tags describing the schedule.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p></p>
    pub next_invocations: std::option::Option<std::vec::Vec<aws_smithy_types::DateTime>>,
    /// <p>The number of clusters associated with the schedule.</p>
    pub associated_cluster_count: std::option::Option<i32>,
    /// <p>A list of clusters associated with the schedule. A maximum of 100 clusters is returned.</p>
    pub associated_clusters:
        std::option::Option<std::vec::Vec<crate::model::ClusterAssociatedToSchedule>>,
}
impl SnapshotSchedule {
    /// <p>A list of ScheduleDefinitions.</p>
    pub fn schedule_definitions(&self) -> std::option::Option<&[std::string::String]> {
        self.schedule_definitions.as_deref()
    }
    /// <p>A unique identifier for the schedule.</p>
    pub fn schedule_identifier(&self) -> std::option::Option<&str> {
        self.schedule_identifier.as_deref()
    }
    /// <p>The description of the schedule.</p>
    pub fn schedule_description(&self) -> std::option::Option<&str> {
        self.schedule_description.as_deref()
    }
    /// <p>An optional set of tags describing the schedule.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p></p>
    pub fn next_invocations(&self) -> std::option::Option<&[aws_smithy_types::DateTime]> {
        self.next_invocations.as_deref()
    }
    /// <p>The number of clusters associated with the schedule.</p>
    pub fn associated_cluster_count(&self) -> std::option::Option<i32> {
        self.associated_cluster_count
    }
    /// <p>A list of clusters associated with the schedule. A maximum of 100 clusters is returned.</p>
    pub fn associated_clusters(
        &self,
    ) -> std::option::Option<&[crate::model::ClusterAssociatedToSchedule]> {
        self.associated_clusters.as_deref()
    }
}
impl std::fmt::Debug for SnapshotSchedule {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SnapshotSchedule");
        formatter.field("schedule_definitions", &self.schedule_definitions);
        formatter.field("schedule_identifier", &self.schedule_identifier);
        formatter.field("schedule_description", &self.schedule_description);
        formatter.field("tags", &self.tags);
        formatter.field("next_invocations", &self.next_invocations);
        formatter.field("associated_cluster_count", &self.associated_cluster_count);
        formatter.field("associated_clusters", &self.associated_clusters);
        formatter.finish()
    }
}
/// See [`SnapshotSchedule`](crate::model::SnapshotSchedule)
pub mod snapshot_schedule {
    /// A builder for [`SnapshotSchedule`](crate::model::SnapshotSchedule)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) schedule_definitions: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) schedule_identifier: std::option::Option<std::string::String>,
        pub(crate) schedule_description: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) next_invocations: std::option::Option<std::vec::Vec<aws_smithy_types::DateTime>>,
        pub(crate) associated_cluster_count: std::option::Option<i32>,
        pub(crate) associated_clusters:
            std::option::Option<std::vec::Vec<crate::model::ClusterAssociatedToSchedule>>,
    }
    impl Builder {
        /// Appends an item to `schedule_definitions`.
        ///
        /// To override the contents of this collection use [`set_schedule_definitions`](Self::set_schedule_definitions).
        ///
        /// <p>A list of ScheduleDefinitions.</p>
        pub fn schedule_definitions(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.schedule_definitions.unwrap_or_default();
            v.push(input.into());
            self.schedule_definitions = Some(v);
            self
        }
        /// <p>A list of ScheduleDefinitions.</p>
        pub fn set_schedule_definitions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.schedule_definitions = input;
            self
        }
        /// <p>A unique identifier for the schedule.</p>
        pub fn schedule_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.schedule_identifier = Some(input.into());
            self
        }
        /// <p>A unique identifier for the schedule.</p>
        pub fn set_schedule_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.schedule_identifier = input;
            self
        }
        /// <p>The description of the schedule.</p>
        pub fn schedule_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.schedule_description = Some(input.into());
            self
        }
        /// <p>The description of the schedule.</p>
        pub fn set_schedule_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.schedule_description = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An optional set of tags describing the schedule.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>An optional set of tags describing the schedule.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Appends an item to `next_invocations`.
        ///
        /// To override the contents of this collection use [`set_next_invocations`](Self::set_next_invocations).
        ///
        /// <p></p>
        pub fn next_invocations(mut self, input: aws_smithy_types::DateTime) -> Self {
            let mut v = self.next_invocations.unwrap_or_default();
            v.push(input);
            self.next_invocations = Some(v);
            self
        }
        /// <p></p>
        pub fn set_next_invocations(
            mut self,
            input: std::option::Option<std::vec::Vec<aws_smithy_types::DateTime>>,
        ) -> Self {
            self.next_invocations = input;
            self
        }
        /// <p>The number of clusters associated with the schedule.</p>
        pub fn associated_cluster_count(mut self, input: i32) -> Self {
            self.associated_cluster_count = Some(input);
            self
        }
        /// <p>The number of clusters associated with the schedule.</p>
        pub fn set_associated_cluster_count(mut self, input: std::option::Option<i32>) -> Self {
            self.associated_cluster_count = input;
            self
        }
        /// Appends an item to `associated_clusters`.
        ///
        /// To override the contents of this collection use [`set_associated_clusters`](Self::set_associated_clusters).
        ///
        /// <p>A list of clusters associated with the schedule. A maximum of 100 clusters is returned.</p>
        pub fn associated_clusters(
            mut self,
            input: crate::model::ClusterAssociatedToSchedule,
        ) -> Self {
            let mut v = self.associated_clusters.unwrap_or_default();
            v.push(input);
            self.associated_clusters = Some(v);
            self
        }
        /// <p>A list of clusters associated with the schedule. A maximum of 100 clusters is returned.</p>
        pub fn set_associated_clusters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ClusterAssociatedToSchedule>>,
        ) -> Self {
            self.associated_clusters = input;
            self
        }
        /// Consumes the builder and constructs a [`SnapshotSchedule`](crate::model::SnapshotSchedule)
        pub fn build(self) -> crate::model::SnapshotSchedule {
            crate::model::SnapshotSchedule {
                schedule_definitions: self.schedule_definitions,
                schedule_identifier: self.schedule_identifier,
                schedule_description: self.schedule_description,
                tags: self.tags,
                next_invocations: self.next_invocations,
                associated_cluster_count: self.associated_cluster_count,
                associated_clusters: self.associated_clusters,
            }
        }
    }
}
impl SnapshotSchedule {
    /// Creates a new builder-style object to manufacture [`SnapshotSchedule`](crate::model::SnapshotSchedule)
    pub fn builder() -> crate::model::snapshot_schedule::Builder {
        crate::model::snapshot_schedule::Builder::default()
    }
}

/// <p>The snapshot copy grant that grants Amazon Redshift permission to encrypt copied snapshots with the specified encrypted symmetric key from Amazon Web Services KMS in the destination region.</p>
/// <p> For more information about managing snapshot copy grants, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-db-encryption.html">Amazon Redshift Database Encryption</a> in the <i>Amazon Redshift Cluster Management Guide</i>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SnapshotCopyGrant {
    /// <p>The name of the snapshot copy grant.</p>
    pub snapshot_copy_grant_name: std::option::Option<std::string::String>,
    /// <p>The unique identifier of the encrypted symmetric key in Amazon Web Services KMS to which Amazon Redshift is granted permission.</p>
    pub kms_key_id: std::option::Option<std::string::String>,
    /// <p>A list of tag instances.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl SnapshotCopyGrant {
    /// <p>The name of the snapshot copy grant.</p>
    pub fn snapshot_copy_grant_name(&self) -> std::option::Option<&str> {
        self.snapshot_copy_grant_name.as_deref()
    }
    /// <p>The unique identifier of the encrypted symmetric key in Amazon Web Services KMS to which Amazon Redshift is granted permission.</p>
    pub fn kms_key_id(&self) -> std::option::Option<&str> {
        self.kms_key_id.as_deref()
    }
    /// <p>A list of tag instances.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for SnapshotCopyGrant {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SnapshotCopyGrant");
        formatter.field("snapshot_copy_grant_name", &self.snapshot_copy_grant_name);
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`SnapshotCopyGrant`](crate::model::SnapshotCopyGrant)
pub mod snapshot_copy_grant {
    /// A builder for [`SnapshotCopyGrant`](crate::model::SnapshotCopyGrant)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) snapshot_copy_grant_name: std::option::Option<std::string::String>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of the snapshot copy grant.</p>
        pub fn snapshot_copy_grant_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.snapshot_copy_grant_name = Some(input.into());
            self
        }
        /// <p>The name of the snapshot copy grant.</p>
        pub fn set_snapshot_copy_grant_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.snapshot_copy_grant_name = input;
            self
        }
        /// <p>The unique identifier of the encrypted symmetric key in Amazon Web Services KMS to which Amazon Redshift is granted permission.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the encrypted symmetric key in Amazon Web Services KMS to which Amazon Redshift is granted permission.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tag instances.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>A list of tag instances.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`SnapshotCopyGrant`](crate::model::SnapshotCopyGrant)
        pub fn build(self) -> crate::model::SnapshotCopyGrant {
            crate::model::SnapshotCopyGrant {
                snapshot_copy_grant_name: self.snapshot_copy_grant_name,
                kms_key_id: self.kms_key_id,
                tags: self.tags,
            }
        }
    }
}
impl SnapshotCopyGrant {
    /// Creates a new builder-style object to manufacture [`SnapshotCopyGrant`](crate::model::SnapshotCopyGrant)
    pub fn builder() -> crate::model::snapshot_copy_grant::Builder {
        crate::model::snapshot_copy_grant::Builder::default()
    }
}

/// <p>Describes a scheduled action. You can use a scheduled action to trigger some Amazon Redshift API operations on a schedule. For information about which API operations can be scheduled, see <code>ScheduledActionType</code>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ScheduledAction {
    /// <p>The name of the scheduled action. </p>
    pub scheduled_action_name: std::option::Option<std::string::String>,
    /// <p>A JSON format string of the Amazon Redshift API operation with input parameters. </p>
    /// <p>"<code>{\"ResizeCluster\":{\"NodeType\":\"ds2.8xlarge\",\"ClusterIdentifier\":\"my-test-cluster\",\"NumberOfNodes\":3}}</code>". </p>
    pub target_action: std::option::Option<crate::model::ScheduledActionType>,
    /// <p>The schedule for a one-time (at format) or recurring (cron format) scheduled action. Schedule invocations must be separated by at least one hour.</p>
    /// <p>Format of at expressions is "<code>at(yyyy-mm-ddThh:mm:ss)</code>". For example, "<code>at(2016-03-04T17:27:00)</code>".</p>
    /// <p>Format of cron expressions is "<code>cron(Minutes Hours Day-of-month Month Day-of-week Year)</code>". For example, "<code>cron(0 10 ? * MON *)</code>". For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html#CronExpressions">Cron Expressions</a> in the <i>Amazon CloudWatch Events User Guide</i>.</p>
    pub schedule: std::option::Option<std::string::String>,
    /// <p>The IAM role to assume to run the scheduled action. This IAM role must have permission to run the Amazon Redshift API operation in the scheduled action. This IAM role must allow the Amazon Redshift scheduler (Principal scheduler.redshift.amazonaws.com) to assume permissions on your behalf. For more information about the IAM role to use with the Amazon Redshift scheduler, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-identity-based.html">Using Identity-Based Policies for Amazon Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>. </p>
    pub iam_role: std::option::Option<std::string::String>,
    /// <p>The description of the scheduled action. </p>
    pub scheduled_action_description: std::option::Option<std::string::String>,
    /// <p>The state of the scheduled action. For example, <code>DISABLED</code>. </p>
    pub state: std::option::Option<crate::model::ScheduledActionState>,
    /// <p>List of times when the scheduled action will run. </p>
    pub next_invocations: std::option::Option<std::vec::Vec<aws_smithy_types::DateTime>>,
    /// <p>The start time in UTC when the schedule is active. Before this time, the scheduled action does not trigger. </p>
    pub start_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The end time in UTC when the schedule is no longer active. After this time, the scheduled action does not trigger. </p>
    pub end_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl ScheduledAction {
    /// <p>The name of the scheduled action. </p>
    pub fn scheduled_action_name(&self) -> std::option::Option<&str> {
        self.scheduled_action_name.as_deref()
    }
    /// <p>A JSON format string of the Amazon Redshift API operation with input parameters. </p>
    /// <p>"<code>{\"ResizeCluster\":{\"NodeType\":\"ds2.8xlarge\",\"ClusterIdentifier\":\"my-test-cluster\",\"NumberOfNodes\":3}}</code>". </p>
    pub fn target_action(&self) -> std::option::Option<&crate::model::ScheduledActionType> {
        self.target_action.as_ref()
    }
    /// <p>The schedule for a one-time (at format) or recurring (cron format) scheduled action. Schedule invocations must be separated by at least one hour.</p>
    /// <p>Format of at expressions is "<code>at(yyyy-mm-ddThh:mm:ss)</code>". For example, "<code>at(2016-03-04T17:27:00)</code>".</p>
    /// <p>Format of cron expressions is "<code>cron(Minutes Hours Day-of-month Month Day-of-week Year)</code>". For example, "<code>cron(0 10 ? * MON *)</code>". For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html#CronExpressions">Cron Expressions</a> in the <i>Amazon CloudWatch Events User Guide</i>.</p>
    pub fn schedule(&self) -> std::option::Option<&str> {
        self.schedule.as_deref()
    }
    /// <p>The IAM role to assume to run the scheduled action. This IAM role must have permission to run the Amazon Redshift API operation in the scheduled action. This IAM role must allow the Amazon Redshift scheduler (Principal scheduler.redshift.amazonaws.com) to assume permissions on your behalf. For more information about the IAM role to use with the Amazon Redshift scheduler, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-identity-based.html">Using Identity-Based Policies for Amazon Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>. </p>
    pub fn iam_role(&self) -> std::option::Option<&str> {
        self.iam_role.as_deref()
    }
    /// <p>The description of the scheduled action. </p>
    pub fn scheduled_action_description(&self) -> std::option::Option<&str> {
        self.scheduled_action_description.as_deref()
    }
    /// <p>The state of the scheduled action. For example, <code>DISABLED</code>. </p>
    pub fn state(&self) -> std::option::Option<&crate::model::ScheduledActionState> {
        self.state.as_ref()
    }
    /// <p>List of times when the scheduled action will run. </p>
    pub fn next_invocations(&self) -> std::option::Option<&[aws_smithy_types::DateTime]> {
        self.next_invocations.as_deref()
    }
    /// <p>The start time in UTC when the schedule is active. Before this time, the scheduled action does not trigger. </p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start_time.as_ref()
    }
    /// <p>The end time in UTC when the schedule is no longer active. After this time, the scheduled action does not trigger. </p>
    pub fn end_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.end_time.as_ref()
    }
}
impl std::fmt::Debug for ScheduledAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ScheduledAction");
        formatter.field("scheduled_action_name", &self.scheduled_action_name);
        formatter.field("target_action", &self.target_action);
        formatter.field("schedule", &self.schedule);
        formatter.field("iam_role", &self.iam_role);
        formatter.field(
            "scheduled_action_description",
            &self.scheduled_action_description,
        );
        formatter.field("state", &self.state);
        formatter.field("next_invocations", &self.next_invocations);
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.finish()
    }
}
/// See [`ScheduledAction`](crate::model::ScheduledAction)
pub mod scheduled_action {
    /// A builder for [`ScheduledAction`](crate::model::ScheduledAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) scheduled_action_name: std::option::Option<std::string::String>,
        pub(crate) target_action: std::option::Option<crate::model::ScheduledActionType>,
        pub(crate) schedule: std::option::Option<std::string::String>,
        pub(crate) iam_role: std::option::Option<std::string::String>,
        pub(crate) scheduled_action_description: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::ScheduledActionState>,
        pub(crate) next_invocations: std::option::Option<std::vec::Vec<aws_smithy_types::DateTime>>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The name of the scheduled action. </p>
        pub fn scheduled_action_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.scheduled_action_name = Some(input.into());
            self
        }
        /// <p>The name of the scheduled action. </p>
        pub fn set_scheduled_action_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.scheduled_action_name = input;
            self
        }
        /// <p>A JSON format string of the Amazon Redshift API operation with input parameters. </p>
        /// <p>"<code>{\"ResizeCluster\":{\"NodeType\":\"ds2.8xlarge\",\"ClusterIdentifier\":\"my-test-cluster\",\"NumberOfNodes\":3}}</code>". </p>
        pub fn target_action(mut self, input: crate::model::ScheduledActionType) -> Self {
            self.target_action = Some(input);
            self
        }
        /// <p>A JSON format string of the Amazon Redshift API operation with input parameters. </p>
        /// <p>"<code>{\"ResizeCluster\":{\"NodeType\":\"ds2.8xlarge\",\"ClusterIdentifier\":\"my-test-cluster\",\"NumberOfNodes\":3}}</code>". </p>
        pub fn set_target_action(
            mut self,
            input: std::option::Option<crate::model::ScheduledActionType>,
        ) -> Self {
            self.target_action = input;
            self
        }
        /// <p>The schedule for a one-time (at format) or recurring (cron format) scheduled action. Schedule invocations must be separated by at least one hour.</p>
        /// <p>Format of at expressions is "<code>at(yyyy-mm-ddThh:mm:ss)</code>". For example, "<code>at(2016-03-04T17:27:00)</code>".</p>
        /// <p>Format of cron expressions is "<code>cron(Minutes Hours Day-of-month Month Day-of-week Year)</code>". For example, "<code>cron(0 10 ? * MON *)</code>". For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html#CronExpressions">Cron Expressions</a> in the <i>Amazon CloudWatch Events User Guide</i>.</p>
        pub fn schedule(mut self, input: impl Into<std::string::String>) -> Self {
            self.schedule = Some(input.into());
            self
        }
        /// <p>The schedule for a one-time (at format) or recurring (cron format) scheduled action. Schedule invocations must be separated by at least one hour.</p>
        /// <p>Format of at expressions is "<code>at(yyyy-mm-ddThh:mm:ss)</code>". For example, "<code>at(2016-03-04T17:27:00)</code>".</p>
        /// <p>Format of cron expressions is "<code>cron(Minutes Hours Day-of-month Month Day-of-week Year)</code>". For example, "<code>cron(0 10 ? * MON *)</code>". For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html#CronExpressions">Cron Expressions</a> in the <i>Amazon CloudWatch Events User Guide</i>.</p>
        pub fn set_schedule(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schedule = input;
            self
        }
        /// <p>The IAM role to assume to run the scheduled action. This IAM role must have permission to run the Amazon Redshift API operation in the scheduled action. This IAM role must allow the Amazon Redshift scheduler (Principal scheduler.redshift.amazonaws.com) to assume permissions on your behalf. For more information about the IAM role to use with the Amazon Redshift scheduler, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-identity-based.html">Using Identity-Based Policies for Amazon Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>. </p>
        pub fn iam_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.iam_role = Some(input.into());
            self
        }
        /// <p>The IAM role to assume to run the scheduled action. This IAM role must have permission to run the Amazon Redshift API operation in the scheduled action. This IAM role must allow the Amazon Redshift scheduler (Principal scheduler.redshift.amazonaws.com) to assume permissions on your behalf. For more information about the IAM role to use with the Amazon Redshift scheduler, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-identity-based.html">Using Identity-Based Policies for Amazon Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>. </p>
        pub fn set_iam_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.iam_role = input;
            self
        }
        /// <p>The description of the scheduled action. </p>
        pub fn scheduled_action_description(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.scheduled_action_description = Some(input.into());
            self
        }
        /// <p>The description of the scheduled action. </p>
        pub fn set_scheduled_action_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.scheduled_action_description = input;
            self
        }
        /// <p>The state of the scheduled action. For example, <code>DISABLED</code>. </p>
        pub fn state(mut self, input: crate::model::ScheduledActionState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The state of the scheduled action. For example, <code>DISABLED</code>. </p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::ScheduledActionState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// Appends an item to `next_invocations`.
        ///
        /// To override the contents of this collection use [`set_next_invocations`](Self::set_next_invocations).
        ///
        /// <p>List of times when the scheduled action will run. </p>
        pub fn next_invocations(mut self, input: aws_smithy_types::DateTime) -> Self {
            let mut v = self.next_invocations.unwrap_or_default();
            v.push(input);
            self.next_invocations = Some(v);
            self
        }
        /// <p>List of times when the scheduled action will run. </p>
        pub fn set_next_invocations(
            mut self,
            input: std::option::Option<std::vec::Vec<aws_smithy_types::DateTime>>,
        ) -> Self {
            self.next_invocations = input;
            self
        }
        /// <p>The start time in UTC when the schedule is active. Before this time, the scheduled action does not trigger. </p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The start time in UTC when the schedule is active. Before this time, the scheduled action does not trigger. </p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The end time in UTC when the schedule is no longer active. After this time, the scheduled action does not trigger. </p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>The end time in UTC when the schedule is no longer active. After this time, the scheduled action does not trigger. </p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// Consumes the builder and constructs a [`ScheduledAction`](crate::model::ScheduledAction)
        pub fn build(self) -> crate::model::ScheduledAction {
            crate::model::ScheduledAction {
                scheduled_action_name: self.scheduled_action_name,
                target_action: self.target_action,
                schedule: self.schedule,
                iam_role: self.iam_role,
                scheduled_action_description: self.scheduled_action_description,
                state: self.state,
                next_invocations: self.next_invocations,
                start_time: self.start_time,
                end_time: self.end_time,
            }
        }
    }
}
impl ScheduledAction {
    /// Creates a new builder-style object to manufacture [`ScheduledAction`](crate::model::ScheduledAction)
    pub fn builder() -> crate::model::scheduled_action::Builder {
        crate::model::scheduled_action::Builder::default()
    }
}

/// <p>A set of elements to filter the returned scheduled actions. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ScheduledActionFilter {
    /// <p>The type of element to filter. </p>
    pub name: std::option::Option<crate::model::ScheduledActionFilterName>,
    /// <p>List of values. Compare if the value (of type defined by <code>Name</code>) equals an item in the list of scheduled actions. </p>
    pub values: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl ScheduledActionFilter {
    /// <p>The type of element to filter. </p>
    pub fn name(&self) -> std::option::Option<&crate::model::ScheduledActionFilterName> {
        self.name.as_ref()
    }
    /// <p>List of values. Compare if the value (of type defined by <code>Name</code>) equals an item in the list of scheduled actions. </p>
    pub fn values(&self) -> std::option::Option<&[std::string::String]> {
        self.values.as_deref()
    }
}
impl std::fmt::Debug for ScheduledActionFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ScheduledActionFilter");
        formatter.field("name", &self.name);
        formatter.field("values", &self.values);
        formatter.finish()
    }
}
/// See [`ScheduledActionFilter`](crate::model::ScheduledActionFilter)
pub mod scheduled_action_filter {
    /// A builder for [`ScheduledActionFilter`](crate::model::ScheduledActionFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<crate::model::ScheduledActionFilterName>,
        pub(crate) values: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The type of element to filter. </p>
        pub fn name(mut self, input: crate::model::ScheduledActionFilterName) -> Self {
            self.name = Some(input);
            self
        }
        /// <p>The type of element to filter. </p>
        pub fn set_name(
            mut self,
            input: std::option::Option<crate::model::ScheduledActionFilterName>,
        ) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>List of values. Compare if the value (of type defined by <code>Name</code>) equals an item in the list of scheduled actions. </p>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>List of values. Compare if the value (of type defined by <code>Name</code>) equals an item in the list of scheduled actions. </p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// Consumes the builder and constructs a [`ScheduledActionFilter`](crate::model::ScheduledActionFilter)
        pub fn build(self) -> crate::model::ScheduledActionFilter {
            crate::model::ScheduledActionFilter {
                name: self.name,
                values: self.values,
            }
        }
    }
}
impl ScheduledActionFilter {
    /// Creates a new builder-style object to manufacture [`ScheduledActionFilter`](crate::model::ScheduledActionFilter)
    pub fn builder() -> crate::model::scheduled_action_filter::Builder {
        crate::model::scheduled_action_filter::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ScheduledActionFilterName {
    #[allow(missing_docs)] // documentation missing in model
    ClusterIdentifier,
    #[allow(missing_docs)] // documentation missing in model
    IamRole,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ScheduledActionFilterName {
    fn from(s: &str) -> Self {
        match s {
            "cluster-identifier" => ScheduledActionFilterName::ClusterIdentifier,
            "iam-role" => ScheduledActionFilterName::IamRole,
            other => ScheduledActionFilterName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ScheduledActionFilterName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ScheduledActionFilterName::from(s))
    }
}
impl ScheduledActionFilterName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ScheduledActionFilterName::ClusterIdentifier => "cluster-identifier",
            ScheduledActionFilterName::IamRole => "iam-role",
            ScheduledActionFilterName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["cluster-identifier", "iam-role"]
    }
}
impl AsRef<str> for ScheduledActionFilterName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ScheduledActionTypeValues {
    #[allow(missing_docs)] // documentation missing in model
    PauseCluster,
    #[allow(missing_docs)] // documentation missing in model
    ResizeCluster,
    #[allow(missing_docs)] // documentation missing in model
    ResumeCluster,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ScheduledActionTypeValues {
    fn from(s: &str) -> Self {
        match s {
            "PauseCluster" => ScheduledActionTypeValues::PauseCluster,
            "ResizeCluster" => ScheduledActionTypeValues::ResizeCluster,
            "ResumeCluster" => ScheduledActionTypeValues::ResumeCluster,
            other => ScheduledActionTypeValues::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ScheduledActionTypeValues {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ScheduledActionTypeValues::from(s))
    }
}
impl ScheduledActionTypeValues {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ScheduledActionTypeValues::PauseCluster => "PauseCluster",
            ScheduledActionTypeValues::ResizeCluster => "ResizeCluster",
            ScheduledActionTypeValues::ResumeCluster => "ResumeCluster",
            ScheduledActionTypeValues::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["PauseCluster", "ResizeCluster", "ResumeCluster"]
    }
}
impl AsRef<str> for ScheduledActionTypeValues {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes a partner integration.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PartnerIntegrationInfo {
    /// <p>The name of the database that receives data from a partner.</p>
    pub database_name: std::option::Option<std::string::String>,
    /// <p>The name of the partner.</p>
    pub partner_name: std::option::Option<std::string::String>,
    /// <p>The partner integration status.</p>
    pub status: std::option::Option<crate::model::PartnerIntegrationStatus>,
    /// <p>The status message provided by the partner.</p>
    pub status_message: std::option::Option<std::string::String>,
    /// <p>The date (UTC) that the partner integration was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date (UTC) that the partner integration status was last updated by the partner.</p>
    pub updated_at: std::option::Option<aws_smithy_types::DateTime>,
}
impl PartnerIntegrationInfo {
    /// <p>The name of the database that receives data from a partner.</p>
    pub fn database_name(&self) -> std::option::Option<&str> {
        self.database_name.as_deref()
    }
    /// <p>The name of the partner.</p>
    pub fn partner_name(&self) -> std::option::Option<&str> {
        self.partner_name.as_deref()
    }
    /// <p>The partner integration status.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::PartnerIntegrationStatus> {
        self.status.as_ref()
    }
    /// <p>The status message provided by the partner.</p>
    pub fn status_message(&self) -> std::option::Option<&str> {
        self.status_message.as_deref()
    }
    /// <p>The date (UTC) that the partner integration was created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>The date (UTC) that the partner integration status was last updated by the partner.</p>
    pub fn updated_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.updated_at.as_ref()
    }
}
impl std::fmt::Debug for PartnerIntegrationInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PartnerIntegrationInfo");
        formatter.field("database_name", &self.database_name);
        formatter.field("partner_name", &self.partner_name);
        formatter.field("status", &self.status);
        formatter.field("status_message", &self.status_message);
        formatter.field("created_at", &self.created_at);
        formatter.field("updated_at", &self.updated_at);
        formatter.finish()
    }
}
/// See [`PartnerIntegrationInfo`](crate::model::PartnerIntegrationInfo)
pub mod partner_integration_info {
    /// A builder for [`PartnerIntegrationInfo`](crate::model::PartnerIntegrationInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) database_name: std::option::Option<std::string::String>,
        pub(crate) partner_name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::PartnerIntegrationStatus>,
        pub(crate) status_message: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) updated_at: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The name of the database that receives data from a partner.</p>
        pub fn database_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.database_name = Some(input.into());
            self
        }
        /// <p>The name of the database that receives data from a partner.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.database_name = input;
            self
        }
        /// <p>The name of the partner.</p>
        pub fn partner_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.partner_name = Some(input.into());
            self
        }
        /// <p>The name of the partner.</p>
        pub fn set_partner_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.partner_name = input;
            self
        }
        /// <p>The partner integration status.</p>
        pub fn status(mut self, input: crate::model::PartnerIntegrationStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The partner integration status.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::PartnerIntegrationStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The status message provided by the partner.</p>
        pub fn status_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_message = Some(input.into());
            self
        }
        /// <p>The status message provided by the partner.</p>
        pub fn set_status_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.status_message = input;
            self
        }
        /// <p>The date (UTC) that the partner integration was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The date (UTC) that the partner integration was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The date (UTC) that the partner integration status was last updated by the partner.</p>
        pub fn updated_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.updated_at = Some(input);
            self
        }
        /// <p>The date (UTC) that the partner integration status was last updated by the partner.</p>
        pub fn set_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.updated_at = input;
            self
        }
        /// Consumes the builder and constructs a [`PartnerIntegrationInfo`](crate::model::PartnerIntegrationInfo)
        pub fn build(self) -> crate::model::PartnerIntegrationInfo {
            crate::model::PartnerIntegrationInfo {
                database_name: self.database_name,
                partner_name: self.partner_name,
                status: self.status,
                status_message: self.status_message,
                created_at: self.created_at,
                updated_at: self.updated_at,
            }
        }
    }
}
impl PartnerIntegrationInfo {
    /// Creates a new builder-style object to manufacture [`PartnerIntegrationInfo`](crate::model::PartnerIntegrationInfo)
    pub fn builder() -> crate::model::partner_integration_info::Builder {
        crate::model::partner_integration_info::Builder::default()
    }
}

/// <p>Describes an orderable cluster option.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OrderableClusterOption {
    /// <p>The version of the orderable cluster.</p>
    pub cluster_version: std::option::Option<std::string::String>,
    /// <p>The cluster type, for example <code>multi-node</code>. </p>
    pub cluster_type: std::option::Option<std::string::String>,
    /// <p>The node type for the orderable cluster.</p>
    pub node_type: std::option::Option<std::string::String>,
    /// <p>A list of availability zones for the orderable cluster.</p>
    pub availability_zones: std::option::Option<std::vec::Vec<crate::model::AvailabilityZone>>,
}
impl OrderableClusterOption {
    /// <p>The version of the orderable cluster.</p>
    pub fn cluster_version(&self) -> std::option::Option<&str> {
        self.cluster_version.as_deref()
    }
    /// <p>The cluster type, for example <code>multi-node</code>. </p>
    pub fn cluster_type(&self) -> std::option::Option<&str> {
        self.cluster_type.as_deref()
    }
    /// <p>The node type for the orderable cluster.</p>
    pub fn node_type(&self) -> std::option::Option<&str> {
        self.node_type.as_deref()
    }
    /// <p>A list of availability zones for the orderable cluster.</p>
    pub fn availability_zones(&self) -> std::option::Option<&[crate::model::AvailabilityZone]> {
        self.availability_zones.as_deref()
    }
}
impl std::fmt::Debug for OrderableClusterOption {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OrderableClusterOption");
        formatter.field("cluster_version", &self.cluster_version);
        formatter.field("cluster_type", &self.cluster_type);
        formatter.field("node_type", &self.node_type);
        formatter.field("availability_zones", &self.availability_zones);
        formatter.finish()
    }
}
/// See [`OrderableClusterOption`](crate::model::OrderableClusterOption)
pub mod orderable_cluster_option {
    /// A builder for [`OrderableClusterOption`](crate::model::OrderableClusterOption)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_version: std::option::Option<std::string::String>,
        pub(crate) cluster_type: std::option::Option<std::string::String>,
        pub(crate) node_type: std::option::Option<std::string::String>,
        pub(crate) availability_zones:
            std::option::Option<std::vec::Vec<crate::model::AvailabilityZone>>,
    }
    impl Builder {
        /// <p>The version of the orderable cluster.</p>
        pub fn cluster_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_version = Some(input.into());
            self
        }
        /// <p>The version of the orderable cluster.</p>
        pub fn set_cluster_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cluster_version = input;
            self
        }
        /// <p>The cluster type, for example <code>multi-node</code>. </p>
        pub fn cluster_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_type = Some(input.into());
            self
        }
        /// <p>The cluster type, for example <code>multi-node</code>. </p>
        pub fn set_cluster_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cluster_type = input;
            self
        }
        /// <p>The node type for the orderable cluster.</p>
        pub fn node_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.node_type = Some(input.into());
            self
        }
        /// <p>The node type for the orderable cluster.</p>
        pub fn set_node_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.node_type = input;
            self
        }
        /// Appends an item to `availability_zones`.
        ///
        /// To override the contents of this collection use [`set_availability_zones`](Self::set_availability_zones).
        ///
        /// <p>A list of availability zones for the orderable cluster.</p>
        pub fn availability_zones(mut self, input: crate::model::AvailabilityZone) -> Self {
            let mut v = self.availability_zones.unwrap_or_default();
            v.push(input);
            self.availability_zones = Some(v);
            self
        }
        /// <p>A list of availability zones for the orderable cluster.</p>
        pub fn set_availability_zones(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AvailabilityZone>>,
        ) -> Self {
            self.availability_zones = input;
            self
        }
        /// Consumes the builder and constructs a [`OrderableClusterOption`](crate::model::OrderableClusterOption)
        pub fn build(self) -> crate::model::OrderableClusterOption {
            crate::model::OrderableClusterOption {
                cluster_version: self.cluster_version,
                cluster_type: self.cluster_type,
                node_type: self.node_type,
                availability_zones: self.availability_zones,
            }
        }
    }
}
impl OrderableClusterOption {
    /// Creates a new builder-style object to manufacture [`OrderableClusterOption`](crate::model::OrderableClusterOption)
    pub fn builder() -> crate::model::orderable_cluster_option::Builder {
        crate::model::orderable_cluster_option::Builder::default()
    }
}

/// <p>A list of node configurations.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NodeConfigurationOption {
    /// <p>The node type, such as, "ds2.8xlarge".</p>
    pub node_type: std::option::Option<std::string::String>,
    /// <p>The number of nodes.</p>
    pub number_of_nodes: i32,
    /// <p>The estimated disk utilizaton percentage.</p>
    pub estimated_disk_utilization_percent: std::option::Option<f64>,
    /// <p>The category of the node configuration recommendation.</p>
    pub mode: std::option::Option<crate::model::Mode>,
}
impl NodeConfigurationOption {
    /// <p>The node type, such as, "ds2.8xlarge".</p>
    pub fn node_type(&self) -> std::option::Option<&str> {
        self.node_type.as_deref()
    }
    /// <p>The number of nodes.</p>
    pub fn number_of_nodes(&self) -> i32 {
        self.number_of_nodes
    }
    /// <p>The estimated disk utilizaton percentage.</p>
    pub fn estimated_disk_utilization_percent(&self) -> std::option::Option<f64> {
        self.estimated_disk_utilization_percent
    }
    /// <p>The category of the node configuration recommendation.</p>
    pub fn mode(&self) -> std::option::Option<&crate::model::Mode> {
        self.mode.as_ref()
    }
}
impl std::fmt::Debug for NodeConfigurationOption {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NodeConfigurationOption");
        formatter.field("node_type", &self.node_type);
        formatter.field("number_of_nodes", &self.number_of_nodes);
        formatter.field(
            "estimated_disk_utilization_percent",
            &self.estimated_disk_utilization_percent,
        );
        formatter.field("mode", &self.mode);
        formatter.finish()
    }
}
/// See [`NodeConfigurationOption`](crate::model::NodeConfigurationOption)
pub mod node_configuration_option {
    /// A builder for [`NodeConfigurationOption`](crate::model::NodeConfigurationOption)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) node_type: std::option::Option<std::string::String>,
        pub(crate) number_of_nodes: std::option::Option<i32>,
        pub(crate) estimated_disk_utilization_percent: std::option::Option<f64>,
        pub(crate) mode: std::option::Option<crate::model::Mode>,
    }
    impl Builder {
        /// <p>The node type, such as, "ds2.8xlarge".</p>
        pub fn node_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.node_type = Some(input.into());
            self
        }
        /// <p>The node type, such as, "ds2.8xlarge".</p>
        pub fn set_node_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.node_type = input;
            self
        }
        /// <p>The number of nodes.</p>
        pub fn number_of_nodes(mut self, input: i32) -> Self {
            self.number_of_nodes = Some(input);
            self
        }
        /// <p>The number of nodes.</p>
        pub fn set_number_of_nodes(mut self, input: std::option::Option<i32>) -> Self {
            self.number_of_nodes = input;
            self
        }
        /// <p>The estimated disk utilizaton percentage.</p>
        pub fn estimated_disk_utilization_percent(mut self, input: f64) -> Self {
            self.estimated_disk_utilization_percent = Some(input);
            self
        }
        /// <p>The estimated disk utilizaton percentage.</p>
        pub fn set_estimated_disk_utilization_percent(
            mut self,
            input: std::option::Option<f64>,
        ) -> Self {
            self.estimated_disk_utilization_percent = input;
            self
        }
        /// <p>The category of the node configuration recommendation.</p>
        pub fn mode(mut self, input: crate::model::Mode) -> Self {
            self.mode = Some(input);
            self
        }
        /// <p>The category of the node configuration recommendation.</p>
        pub fn set_mode(mut self, input: std::option::Option<crate::model::Mode>) -> Self {
            self.mode = input;
            self
        }
        /// Consumes the builder and constructs a [`NodeConfigurationOption`](crate::model::NodeConfigurationOption)
        pub fn build(self) -> crate::model::NodeConfigurationOption {
            crate::model::NodeConfigurationOption {
                node_type: self.node_type,
                number_of_nodes: self.number_of_nodes.unwrap_or_default(),
                estimated_disk_utilization_percent: self.estimated_disk_utilization_percent,
                mode: self.mode,
            }
        }
    }
}
impl NodeConfigurationOption {
    /// Creates a new builder-style object to manufacture [`NodeConfigurationOption`](crate::model::NodeConfigurationOption)
    pub fn builder() -> crate::model::node_configuration_option::Builder {
        crate::model::node_configuration_option::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Mode {
    #[allow(missing_docs)] // documentation missing in model
    HighPerformance,
    #[allow(missing_docs)] // documentation missing in model
    Standard,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Mode {
    fn from(s: &str) -> Self {
        match s {
            "high-performance" => Mode::HighPerformance,
            "standard" => Mode::Standard,
            other => Mode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Mode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Mode::from(s))
    }
}
impl Mode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Mode::HighPerformance => "high-performance",
            Mode::Standard => "standard",
            Mode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["high-performance", "standard"]
    }
}
impl AsRef<str> for Mode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A set of elements to filter the returned node configurations.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NodeConfigurationOptionsFilter {
    /// <p>The name of the element to filter.</p>
    pub name: std::option::Option<crate::model::NodeConfigurationOptionsFilterName>,
    /// <p>The filter operator. If filter Name is NodeType only the 'in' operator is supported. Provide one value to evaluate for 'eq', 'lt', 'le', 'gt', and 'ge'. Provide two values to evaluate for 'between'. Provide a list of values for 'in'.</p>
    pub operator: std::option::Option<crate::model::OperatorType>,
    /// <p>List of values. Compare Name using Operator to Values. If filter Name is NumberOfNodes, then values can range from 0 to 200. If filter Name is EstimatedDiskUtilizationPercent, then values can range from 0 to 100. For example, filter NumberOfNodes (name) GT (operator) 3 (values).</p>
    pub values: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl NodeConfigurationOptionsFilter {
    /// <p>The name of the element to filter.</p>
    pub fn name(&self) -> std::option::Option<&crate::model::NodeConfigurationOptionsFilterName> {
        self.name.as_ref()
    }
    /// <p>The filter operator. If filter Name is NodeType only the 'in' operator is supported. Provide one value to evaluate for 'eq', 'lt', 'le', 'gt', and 'ge'. Provide two values to evaluate for 'between'. Provide a list of values for 'in'.</p>
    pub fn operator(&self) -> std::option::Option<&crate::model::OperatorType> {
        self.operator.as_ref()
    }
    /// <p>List of values. Compare Name using Operator to Values. If filter Name is NumberOfNodes, then values can range from 0 to 200. If filter Name is EstimatedDiskUtilizationPercent, then values can range from 0 to 100. For example, filter NumberOfNodes (name) GT (operator) 3 (values).</p>
    pub fn values(&self) -> std::option::Option<&[std::string::String]> {
        self.values.as_deref()
    }
}
impl std::fmt::Debug for NodeConfigurationOptionsFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NodeConfigurationOptionsFilter");
        formatter.field("name", &self.name);
        formatter.field("operator", &self.operator);
        formatter.field("values", &self.values);
        formatter.finish()
    }
}
/// See [`NodeConfigurationOptionsFilter`](crate::model::NodeConfigurationOptionsFilter)
pub mod node_configuration_options_filter {
    /// A builder for [`NodeConfigurationOptionsFilter`](crate::model::NodeConfigurationOptionsFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<crate::model::NodeConfigurationOptionsFilterName>,
        pub(crate) operator: std::option::Option<crate::model::OperatorType>,
        pub(crate) values: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of the element to filter.</p>
        pub fn name(mut self, input: crate::model::NodeConfigurationOptionsFilterName) -> Self {
            self.name = Some(input);
            self
        }
        /// <p>The name of the element to filter.</p>
        pub fn set_name(
            mut self,
            input: std::option::Option<crate::model::NodeConfigurationOptionsFilterName>,
        ) -> Self {
            self.name = input;
            self
        }
        /// <p>The filter operator. If filter Name is NodeType only the 'in' operator is supported. Provide one value to evaluate for 'eq', 'lt', 'le', 'gt', and 'ge'. Provide two values to evaluate for 'between'. Provide a list of values for 'in'.</p>
        pub fn operator(mut self, input: crate::model::OperatorType) -> Self {
            self.operator = Some(input);
            self
        }
        /// <p>The filter operator. If filter Name is NodeType only the 'in' operator is supported. Provide one value to evaluate for 'eq', 'lt', 'le', 'gt', and 'ge'. Provide two values to evaluate for 'between'. Provide a list of values for 'in'.</p>
        pub fn set_operator(
            mut self,
            input: std::option::Option<crate::model::OperatorType>,
        ) -> Self {
            self.operator = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>List of values. Compare Name using Operator to Values. If filter Name is NumberOfNodes, then values can range from 0 to 200. If filter Name is EstimatedDiskUtilizationPercent, then values can range from 0 to 100. For example, filter NumberOfNodes (name) GT (operator) 3 (values).</p>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>List of values. Compare Name using Operator to Values. If filter Name is NumberOfNodes, then values can range from 0 to 200. If filter Name is EstimatedDiskUtilizationPercent, then values can range from 0 to 100. For example, filter NumberOfNodes (name) GT (operator) 3 (values).</p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// Consumes the builder and constructs a [`NodeConfigurationOptionsFilter`](crate::model::NodeConfigurationOptionsFilter)
        pub fn build(self) -> crate::model::NodeConfigurationOptionsFilter {
            crate::model::NodeConfigurationOptionsFilter {
                name: self.name,
                operator: self.operator,
                values: self.values,
            }
        }
    }
}
impl NodeConfigurationOptionsFilter {
    /// Creates a new builder-style object to manufacture [`NodeConfigurationOptionsFilter`](crate::model::NodeConfigurationOptionsFilter)
    pub fn builder() -> crate::model::node_configuration_options_filter::Builder {
        crate::model::node_configuration_options_filter::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum OperatorType {
    #[allow(missing_docs)] // documentation missing in model
    Between,
    #[allow(missing_docs)] // documentation missing in model
    Eq,
    #[allow(missing_docs)] // documentation missing in model
    Ge,
    #[allow(missing_docs)] // documentation missing in model
    Gt,
    #[allow(missing_docs)] // documentation missing in model
    In,
    #[allow(missing_docs)] // documentation missing in model
    Le,
    #[allow(missing_docs)] // documentation missing in model
    Lt,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for OperatorType {
    fn from(s: &str) -> Self {
        match s {
            "between" => OperatorType::Between,
            "eq" => OperatorType::Eq,
            "ge" => OperatorType::Ge,
            "gt" => OperatorType::Gt,
            "in" => OperatorType::In,
            "le" => OperatorType::Le,
            "lt" => OperatorType::Lt,
            other => OperatorType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for OperatorType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(OperatorType::from(s))
    }
}
impl OperatorType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            OperatorType::Between => "between",
            OperatorType::Eq => "eq",
            OperatorType::Ge => "ge",
            OperatorType::Gt => "gt",
            OperatorType::In => "in",
            OperatorType::Le => "le",
            OperatorType::Lt => "lt",
            OperatorType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["between", "eq", "ge", "gt", "in", "le", "lt"]
    }
}
impl AsRef<str> for OperatorType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum NodeConfigurationOptionsFilterName {
    #[allow(missing_docs)] // documentation missing in model
    EstimatedDiskUtilizationPercent,
    #[allow(missing_docs)] // documentation missing in model
    Mode,
    #[allow(missing_docs)] // documentation missing in model
    NodeType,
    #[allow(missing_docs)] // documentation missing in model
    NumNodes,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for NodeConfigurationOptionsFilterName {
    fn from(s: &str) -> Self {
        match s {
            "EstimatedDiskUtilizationPercent" => {
                NodeConfigurationOptionsFilterName::EstimatedDiskUtilizationPercent
            }
            "Mode" => NodeConfigurationOptionsFilterName::Mode,
            "NodeType" => NodeConfigurationOptionsFilterName::NodeType,
            "NumberOfNodes" => NodeConfigurationOptionsFilterName::NumNodes,
            other => NodeConfigurationOptionsFilterName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for NodeConfigurationOptionsFilterName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(NodeConfigurationOptionsFilterName::from(s))
    }
}
impl NodeConfigurationOptionsFilterName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            NodeConfigurationOptionsFilterName::EstimatedDiskUtilizationPercent => {
                "EstimatedDiskUtilizationPercent"
            }
            NodeConfigurationOptionsFilterName::Mode => "Mode",
            NodeConfigurationOptionsFilterName::NodeType => "NodeType",
            NodeConfigurationOptionsFilterName::NumNodes => "NumberOfNodes",
            NodeConfigurationOptionsFilterName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "EstimatedDiskUtilizationPercent",
            "Mode",
            "NodeType",
            "NumberOfNodes",
        ]
    }
}
impl AsRef<str> for NodeConfigurationOptionsFilterName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ActionType {
    #[allow(missing_docs)] // documentation missing in model
    RecommendNodeConfig,
    #[allow(missing_docs)] // documentation missing in model
    ResizeCluster,
    #[allow(missing_docs)] // documentation missing in model
    RestoreCluster,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ActionType {
    fn from(s: &str) -> Self {
        match s {
            "recommend-node-config" => ActionType::RecommendNodeConfig,
            "resize-cluster" => ActionType::ResizeCluster,
            "restore-cluster" => ActionType::RestoreCluster,
            other => ActionType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ActionType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ActionType::from(s))
    }
}
impl ActionType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ActionType::RecommendNodeConfig => "recommend-node-config",
            ActionType::ResizeCluster => "resize-cluster",
            ActionType::RestoreCluster => "restore-cluster",
            ActionType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["recommend-node-config", "resize-cluster", "restore-cluster"]
    }
}
impl AsRef<str> for ActionType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Returns information about an HSM configuration, which is an object that describes to Amazon Redshift clusters the information they require to connect to an HSM where they can store database encryption keys.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HsmConfiguration {
    /// <p>The name of the Amazon Redshift HSM configuration.</p>
    pub hsm_configuration_identifier: std::option::Option<std::string::String>,
    /// <p>A text description of the HSM configuration.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The IP address that the Amazon Redshift cluster must use to access the HSM.</p>
    pub hsm_ip_address: std::option::Option<std::string::String>,
    /// <p>The name of the partition in the HSM where the Amazon Redshift clusters will store their database encryption keys.</p>
    pub hsm_partition_name: std::option::Option<std::string::String>,
    /// <p>The list of tags for the HSM configuration.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl HsmConfiguration {
    /// <p>The name of the Amazon Redshift HSM configuration.</p>
    pub fn hsm_configuration_identifier(&self) -> std::option::Option<&str> {
        self.hsm_configuration_identifier.as_deref()
    }
    /// <p>A text description of the HSM configuration.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The IP address that the Amazon Redshift cluster must use to access the HSM.</p>
    pub fn hsm_ip_address(&self) -> std::option::Option<&str> {
        self.hsm_ip_address.as_deref()
    }
    /// <p>The name of the partition in the HSM where the Amazon Redshift clusters will store their database encryption keys.</p>
    pub fn hsm_partition_name(&self) -> std::option::Option<&str> {
        self.hsm_partition_name.as_deref()
    }
    /// <p>The list of tags for the HSM configuration.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for HsmConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HsmConfiguration");
        formatter.field(
            "hsm_configuration_identifier",
            &self.hsm_configuration_identifier,
        );
        formatter.field("description", &self.description);
        formatter.field("hsm_ip_address", &self.hsm_ip_address);
        formatter.field("hsm_partition_name", &self.hsm_partition_name);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`HsmConfiguration`](crate::model::HsmConfiguration)
pub mod hsm_configuration {
    /// A builder for [`HsmConfiguration`](crate::model::HsmConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) hsm_configuration_identifier: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) hsm_ip_address: std::option::Option<std::string::String>,
        pub(crate) hsm_partition_name: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of the Amazon Redshift HSM configuration.</p>
        pub fn hsm_configuration_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.hsm_configuration_identifier = Some(input.into());
            self
        }
        /// <p>The name of the Amazon Redshift HSM configuration.</p>
        pub fn set_hsm_configuration_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.hsm_configuration_identifier = input;
            self
        }
        /// <p>A text description of the HSM configuration.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A text description of the HSM configuration.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The IP address that the Amazon Redshift cluster must use to access the HSM.</p>
        pub fn hsm_ip_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.hsm_ip_address = Some(input.into());
            self
        }
        /// <p>The IP address that the Amazon Redshift cluster must use to access the HSM.</p>
        pub fn set_hsm_ip_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.hsm_ip_address = input;
            self
        }
        /// <p>The name of the partition in the HSM where the Amazon Redshift clusters will store their database encryption keys.</p>
        pub fn hsm_partition_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.hsm_partition_name = Some(input.into());
            self
        }
        /// <p>The name of the partition in the HSM where the Amazon Redshift clusters will store their database encryption keys.</p>
        pub fn set_hsm_partition_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.hsm_partition_name = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The list of tags for the HSM configuration.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The list of tags for the HSM configuration.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`HsmConfiguration`](crate::model::HsmConfiguration)
        pub fn build(self) -> crate::model::HsmConfiguration {
            crate::model::HsmConfiguration {
                hsm_configuration_identifier: self.hsm_configuration_identifier,
                description: self.description,
                hsm_ip_address: self.hsm_ip_address,
                hsm_partition_name: self.hsm_partition_name,
                tags: self.tags,
            }
        }
    }
}
impl HsmConfiguration {
    /// Creates a new builder-style object to manufacture [`HsmConfiguration`](crate::model::HsmConfiguration)
    pub fn builder() -> crate::model::hsm_configuration::Builder {
        crate::model::hsm_configuration::Builder::default()
    }
}

/// <p>Returns information about an HSM client certificate. The certificate is stored in a secure Hardware Storage Module (HSM), and used by the Amazon Redshift cluster to encrypt data files.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HsmClientCertificate {
    /// <p>The identifier of the HSM client certificate.</p>
    pub hsm_client_certificate_identifier: std::option::Option<std::string::String>,
    /// <p>The public key that the Amazon Redshift cluster will use to connect to the HSM. You must register the public key in the HSM.</p>
    pub hsm_client_certificate_public_key: std::option::Option<std::string::String>,
    /// <p>The list of tags for the HSM client certificate.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl HsmClientCertificate {
    /// <p>The identifier of the HSM client certificate.</p>
    pub fn hsm_client_certificate_identifier(&self) -> std::option::Option<&str> {
        self.hsm_client_certificate_identifier.as_deref()
    }
    /// <p>The public key that the Amazon Redshift cluster will use to connect to the HSM. You must register the public key in the HSM.</p>
    pub fn hsm_client_certificate_public_key(&self) -> std::option::Option<&str> {
        self.hsm_client_certificate_public_key.as_deref()
    }
    /// <p>The list of tags for the HSM client certificate.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for HsmClientCertificate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HsmClientCertificate");
        formatter.field(
            "hsm_client_certificate_identifier",
            &self.hsm_client_certificate_identifier,
        );
        formatter.field(
            "hsm_client_certificate_public_key",
            &self.hsm_client_certificate_public_key,
        );
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`HsmClientCertificate`](crate::model::HsmClientCertificate)
pub mod hsm_client_certificate {
    /// A builder for [`HsmClientCertificate`](crate::model::HsmClientCertificate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) hsm_client_certificate_identifier: std::option::Option<std::string::String>,
        pub(crate) hsm_client_certificate_public_key: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The identifier of the HSM client certificate.</p>
        pub fn hsm_client_certificate_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.hsm_client_certificate_identifier = Some(input.into());
            self
        }
        /// <p>The identifier of the HSM client certificate.</p>
        pub fn set_hsm_client_certificate_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.hsm_client_certificate_identifier = input;
            self
        }
        /// <p>The public key that the Amazon Redshift cluster will use to connect to the HSM. You must register the public key in the HSM.</p>
        pub fn hsm_client_certificate_public_key(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.hsm_client_certificate_public_key = Some(input.into());
            self
        }
        /// <p>The public key that the Amazon Redshift cluster will use to connect to the HSM. You must register the public key in the HSM.</p>
        pub fn set_hsm_client_certificate_public_key(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.hsm_client_certificate_public_key = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The list of tags for the HSM client certificate.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The list of tags for the HSM client certificate.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`HsmClientCertificate`](crate::model::HsmClientCertificate)
        pub fn build(self) -> crate::model::HsmClientCertificate {
            crate::model::HsmClientCertificate {
                hsm_client_certificate_identifier: self.hsm_client_certificate_identifier,
                hsm_client_certificate_public_key: self.hsm_client_certificate_public_key,
                tags: self.tags,
            }
        }
    }
}
impl HsmClientCertificate {
    /// Creates a new builder-style object to manufacture [`HsmClientCertificate`](crate::model::HsmClientCertificate)
    pub fn builder() -> crate::model::hsm_client_certificate::Builder {
        crate::model::hsm_client_certificate::Builder::default()
    }
}

/// <p>Describes an event.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Event {
    /// <p>The identifier for the source of the event.</p>
    pub source_identifier: std::option::Option<std::string::String>,
    /// <p>The source type for this event.</p>
    pub source_type: std::option::Option<crate::model::SourceType>,
    /// <p>The text of this event.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>A list of the event categories.</p>
    /// <p>Values: Configuration, Management, Monitoring, Security, Pending</p>
    pub event_categories: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The severity of the event.</p>
    /// <p>Values: ERROR, INFO</p>
    pub severity: std::option::Option<std::string::String>,
    /// <p>The date and time of the event.</p>
    pub date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The identifier of the event.</p>
    pub event_id: std::option::Option<std::string::String>,
}
impl Event {
    /// <p>The identifier for the source of the event.</p>
    pub fn source_identifier(&self) -> std::option::Option<&str> {
        self.source_identifier.as_deref()
    }
    /// <p>The source type for this event.</p>
    pub fn source_type(&self) -> std::option::Option<&crate::model::SourceType> {
        self.source_type.as_ref()
    }
    /// <p>The text of this event.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
    /// <p>A list of the event categories.</p>
    /// <p>Values: Configuration, Management, Monitoring, Security, Pending</p>
    pub fn event_categories(&self) -> std::option::Option<&[std::string::String]> {
        self.event_categories.as_deref()
    }
    /// <p>The severity of the event.</p>
    /// <p>Values: ERROR, INFO</p>
    pub fn severity(&self) -> std::option::Option<&str> {
        self.severity.as_deref()
    }
    /// <p>The date and time of the event.</p>
    pub fn date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.date.as_ref()
    }
    /// <p>The identifier of the event.</p>
    pub fn event_id(&self) -> std::option::Option<&str> {
        self.event_id.as_deref()
    }
}
impl std::fmt::Debug for Event {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Event");
        formatter.field("source_identifier", &self.source_identifier);
        formatter.field("source_type", &self.source_type);
        formatter.field("message", &self.message);
        formatter.field("event_categories", &self.event_categories);
        formatter.field("severity", &self.severity);
        formatter.field("date", &self.date);
        formatter.field("event_id", &self.event_id);
        formatter.finish()
    }
}
/// See [`Event`](crate::model::Event)
pub mod event {
    /// A builder for [`Event`](crate::model::Event)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_identifier: std::option::Option<std::string::String>,
        pub(crate) source_type: std::option::Option<crate::model::SourceType>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) event_categories: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) severity: std::option::Option<std::string::String>,
        pub(crate) date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) event_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier for the source of the event.</p>
        pub fn source_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_identifier = Some(input.into());
            self
        }
        /// <p>The identifier for the source of the event.</p>
        pub fn set_source_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_identifier = input;
            self
        }
        /// <p>The source type for this event.</p>
        pub fn source_type(mut self, input: crate::model::SourceType) -> Self {
            self.source_type = Some(input);
            self
        }
        /// <p>The source type for this event.</p>
        pub fn set_source_type(
            mut self,
            input: std::option::Option<crate::model::SourceType>,
        ) -> Self {
            self.source_type = input;
            self
        }
        /// <p>The text of this event.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The text of this event.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Appends an item to `event_categories`.
        ///
        /// To override the contents of this collection use [`set_event_categories`](Self::set_event_categories).
        ///
        /// <p>A list of the event categories.</p>
        /// <p>Values: Configuration, Management, Monitoring, Security, Pending</p>
        pub fn event_categories(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.event_categories.unwrap_or_default();
            v.push(input.into());
            self.event_categories = Some(v);
            self
        }
        /// <p>A list of the event categories.</p>
        /// <p>Values: Configuration, Management, Monitoring, Security, Pending</p>
        pub fn set_event_categories(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.event_categories = input;
            self
        }
        /// <p>The severity of the event.</p>
        /// <p>Values: ERROR, INFO</p>
        pub fn severity(mut self, input: impl Into<std::string::String>) -> Self {
            self.severity = Some(input.into());
            self
        }
        /// <p>The severity of the event.</p>
        /// <p>Values: ERROR, INFO</p>
        pub fn set_severity(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.severity = input;
            self
        }
        /// <p>The date and time of the event.</p>
        pub fn date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.date = Some(input);
            self
        }
        /// <p>The date and time of the event.</p>
        pub fn set_date(mut self, input: std::option::Option<aws_smithy_types::DateTime>) -> Self {
            self.date = input;
            self
        }
        /// <p>The identifier of the event.</p>
        pub fn event_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_id = Some(input.into());
            self
        }
        /// <p>The identifier of the event.</p>
        pub fn set_event_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.event_id = input;
            self
        }
        /// Consumes the builder and constructs a [`Event`](crate::model::Event)
        pub fn build(self) -> crate::model::Event {
            crate::model::Event {
                source_identifier: self.source_identifier,
                source_type: self.source_type,
                message: self.message,
                event_categories: self.event_categories,
                severity: self.severity,
                date: self.date,
                event_id: self.event_id,
            }
        }
    }
}
impl Event {
    /// Creates a new builder-style object to manufacture [`Event`](crate::model::Event)
    pub fn builder() -> crate::model::event::Builder {
        crate::model::event::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SourceType {
    #[allow(missing_docs)] // documentation missing in model
    Cluster,
    #[allow(missing_docs)] // documentation missing in model
    ClusterParameterGroup,
    #[allow(missing_docs)] // documentation missing in model
    ClusterSecurityGroup,
    #[allow(missing_docs)] // documentation missing in model
    ClusterSnapshot,
    #[allow(missing_docs)] // documentation missing in model
    ScheduledAction,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SourceType {
    fn from(s: &str) -> Self {
        match s {
            "cluster" => SourceType::Cluster,
            "cluster-parameter-group" => SourceType::ClusterParameterGroup,
            "cluster-security-group" => SourceType::ClusterSecurityGroup,
            "cluster-snapshot" => SourceType::ClusterSnapshot,
            "scheduled-action" => SourceType::ScheduledAction,
            other => SourceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SourceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SourceType::from(s))
    }
}
impl SourceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SourceType::Cluster => "cluster",
            SourceType::ClusterParameterGroup => "cluster-parameter-group",
            SourceType::ClusterSecurityGroup => "cluster-security-group",
            SourceType::ClusterSnapshot => "cluster-snapshot",
            SourceType::ScheduledAction => "scheduled-action",
            SourceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "cluster",
            "cluster-parameter-group",
            "cluster-security-group",
            "cluster-snapshot",
            "scheduled-action",
        ]
    }
}
impl AsRef<str> for SourceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes event categories.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EventCategoriesMap {
    /// <p>The source type, such as cluster or cluster-snapshot, that the returned categories belong to.</p>
    pub source_type: std::option::Option<std::string::String>,
    /// <p>The events in the event category.</p>
    pub events: std::option::Option<std::vec::Vec<crate::model::EventInfoMap>>,
}
impl EventCategoriesMap {
    /// <p>The source type, such as cluster or cluster-snapshot, that the returned categories belong to.</p>
    pub fn source_type(&self) -> std::option::Option<&str> {
        self.source_type.as_deref()
    }
    /// <p>The events in the event category.</p>
    pub fn events(&self) -> std::option::Option<&[crate::model::EventInfoMap]> {
        self.events.as_deref()
    }
}
impl std::fmt::Debug for EventCategoriesMap {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EventCategoriesMap");
        formatter.field("source_type", &self.source_type);
        formatter.field("events", &self.events);
        formatter.finish()
    }
}
/// See [`EventCategoriesMap`](crate::model::EventCategoriesMap)
pub mod event_categories_map {
    /// A builder for [`EventCategoriesMap`](crate::model::EventCategoriesMap)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_type: std::option::Option<std::string::String>,
        pub(crate) events: std::option::Option<std::vec::Vec<crate::model::EventInfoMap>>,
    }
    impl Builder {
        /// <p>The source type, such as cluster or cluster-snapshot, that the returned categories belong to.</p>
        pub fn source_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_type = Some(input.into());
            self
        }
        /// <p>The source type, such as cluster or cluster-snapshot, that the returned categories belong to.</p>
        pub fn set_source_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source_type = input;
            self
        }
        /// Appends an item to `events`.
        ///
        /// To override the contents of this collection use [`set_events`](Self::set_events).
        ///
        /// <p>The events in the event category.</p>
        pub fn events(mut self, input: crate::model::EventInfoMap) -> Self {
            let mut v = self.events.unwrap_or_default();
            v.push(input);
            self.events = Some(v);
            self
        }
        /// <p>The events in the event category.</p>
        pub fn set_events(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EventInfoMap>>,
        ) -> Self {
            self.events = input;
            self
        }
        /// Consumes the builder and constructs a [`EventCategoriesMap`](crate::model::EventCategoriesMap)
        pub fn build(self) -> crate::model::EventCategoriesMap {
            crate::model::EventCategoriesMap {
                source_type: self.source_type,
                events: self.events,
            }
        }
    }
}
impl EventCategoriesMap {
    /// Creates a new builder-style object to manufacture [`EventCategoriesMap`](crate::model::EventCategoriesMap)
    pub fn builder() -> crate::model::event_categories_map::Builder {
        crate::model::event_categories_map::Builder::default()
    }
}

/// <p>Describes event information.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EventInfoMap {
    /// <p>The identifier of an Amazon Redshift event.</p>
    pub event_id: std::option::Option<std::string::String>,
    /// <p>The category of an Amazon Redshift event.</p>
    pub event_categories: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The description of an Amazon Redshift event.</p>
    pub event_description: std::option::Option<std::string::String>,
    /// <p>The severity of the event.</p>
    /// <p>Values: ERROR, INFO</p>
    pub severity: std::option::Option<std::string::String>,
}
impl EventInfoMap {
    /// <p>The identifier of an Amazon Redshift event.</p>
    pub fn event_id(&self) -> std::option::Option<&str> {
        self.event_id.as_deref()
    }
    /// <p>The category of an Amazon Redshift event.</p>
    pub fn event_categories(&self) -> std::option::Option<&[std::string::String]> {
        self.event_categories.as_deref()
    }
    /// <p>The description of an Amazon Redshift event.</p>
    pub fn event_description(&self) -> std::option::Option<&str> {
        self.event_description.as_deref()
    }
    /// <p>The severity of the event.</p>
    /// <p>Values: ERROR, INFO</p>
    pub fn severity(&self) -> std::option::Option<&str> {
        self.severity.as_deref()
    }
}
impl std::fmt::Debug for EventInfoMap {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EventInfoMap");
        formatter.field("event_id", &self.event_id);
        formatter.field("event_categories", &self.event_categories);
        formatter.field("event_description", &self.event_description);
        formatter.field("severity", &self.severity);
        formatter.finish()
    }
}
/// See [`EventInfoMap`](crate::model::EventInfoMap)
pub mod event_info_map {
    /// A builder for [`EventInfoMap`](crate::model::EventInfoMap)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) event_id: std::option::Option<std::string::String>,
        pub(crate) event_categories: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) event_description: std::option::Option<std::string::String>,
        pub(crate) severity: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of an Amazon Redshift event.</p>
        pub fn event_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_id = Some(input.into());
            self
        }
        /// <p>The identifier of an Amazon Redshift event.</p>
        pub fn set_event_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.event_id = input;
            self
        }
        /// Appends an item to `event_categories`.
        ///
        /// To override the contents of this collection use [`set_event_categories`](Self::set_event_categories).
        ///
        /// <p>The category of an Amazon Redshift event.</p>
        pub fn event_categories(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.event_categories.unwrap_or_default();
            v.push(input.into());
            self.event_categories = Some(v);
            self
        }
        /// <p>The category of an Amazon Redshift event.</p>
        pub fn set_event_categories(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.event_categories = input;
            self
        }
        /// <p>The description of an Amazon Redshift event.</p>
        pub fn event_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_description = Some(input.into());
            self
        }
        /// <p>The description of an Amazon Redshift event.</p>
        pub fn set_event_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_description = input;
            self
        }
        /// <p>The severity of the event.</p>
        /// <p>Values: ERROR, INFO</p>
        pub fn severity(mut self, input: impl Into<std::string::String>) -> Self {
            self.severity = Some(input.into());
            self
        }
        /// <p>The severity of the event.</p>
        /// <p>Values: ERROR, INFO</p>
        pub fn set_severity(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.severity = input;
            self
        }
        /// Consumes the builder and constructs a [`EventInfoMap`](crate::model::EventInfoMap)
        pub fn build(self) -> crate::model::EventInfoMap {
            crate::model::EventInfoMap {
                event_id: self.event_id,
                event_categories: self.event_categories,
                event_description: self.event_description,
                severity: self.severity,
            }
        }
    }
}
impl EventInfoMap {
    /// Creates a new builder-style object to manufacture [`EventInfoMap`](crate::model::EventInfoMap)
    pub fn builder() -> crate::model::event_info_map::Builder {
        crate::model::event_info_map::Builder::default()
    }
}

/// <p>Describes an endpoint authorization for authorizing Redshift-managed VPC endpoint access to a cluster across Amazon Web Services accounts.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EndpointAuthorization {
    /// <p>The Amazon Web Services account ID of the cluster owner.</p>
    pub grantor: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services account ID of the grantee of the cluster.</p>
    pub grantee: std::option::Option<std::string::String>,
    /// <p>The cluster identifier.</p>
    pub cluster_identifier: std::option::Option<std::string::String>,
    /// <p>The time (UTC) when the authorization was created.</p>
    pub authorize_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The status of the cluster.</p>
    pub cluster_status: std::option::Option<std::string::String>,
    /// <p>The status of the authorization action.</p>
    pub status: std::option::Option<crate::model::AuthorizationStatus>,
    /// <p>Indicates whether all VPCs in the grantee account are allowed access to the cluster.</p>
    pub allowed_all_vp_cs: bool,
    /// <p>The VPCs allowed access to the cluster.</p>
    pub allowed_vp_cs: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The number of Redshift-managed VPC endpoints created for the authorization.</p>
    pub endpoint_count: i32,
}
impl EndpointAuthorization {
    /// <p>The Amazon Web Services account ID of the cluster owner.</p>
    pub fn grantor(&self) -> std::option::Option<&str> {
        self.grantor.as_deref()
    }
    /// <p>The Amazon Web Services account ID of the grantee of the cluster.</p>
    pub fn grantee(&self) -> std::option::Option<&str> {
        self.grantee.as_deref()
    }
    /// <p>The cluster identifier.</p>
    pub fn cluster_identifier(&self) -> std::option::Option<&str> {
        self.cluster_identifier.as_deref()
    }
    /// <p>The time (UTC) when the authorization was created.</p>
    pub fn authorize_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.authorize_time.as_ref()
    }
    /// <p>The status of the cluster.</p>
    pub fn cluster_status(&self) -> std::option::Option<&str> {
        self.cluster_status.as_deref()
    }
    /// <p>The status of the authorization action.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::AuthorizationStatus> {
        self.status.as_ref()
    }
    /// <p>Indicates whether all VPCs in the grantee account are allowed access to the cluster.</p>
    pub fn allowed_all_vp_cs(&self) -> bool {
        self.allowed_all_vp_cs
    }
    /// <p>The VPCs allowed access to the cluster.</p>
    pub fn allowed_vp_cs(&self) -> std::option::Option<&[std::string::String]> {
        self.allowed_vp_cs.as_deref()
    }
    /// <p>The number of Redshift-managed VPC endpoints created for the authorization.</p>
    pub fn endpoint_count(&self) -> i32 {
        self.endpoint_count
    }
}
impl std::fmt::Debug for EndpointAuthorization {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EndpointAuthorization");
        formatter.field("grantor", &self.grantor);
        formatter.field("grantee", &self.grantee);
        formatter.field("cluster_identifier", &self.cluster_identifier);
        formatter.field("authorize_time", &self.authorize_time);
        formatter.field("cluster_status", &self.cluster_status);
        formatter.field("status", &self.status);
        formatter.field("allowed_all_vp_cs", &self.allowed_all_vp_cs);
        formatter.field("allowed_vp_cs", &self.allowed_vp_cs);
        formatter.field("endpoint_count", &self.endpoint_count);
        formatter.finish()
    }
}
/// See [`EndpointAuthorization`](crate::model::EndpointAuthorization)
pub mod endpoint_authorization {
    /// A builder for [`EndpointAuthorization`](crate::model::EndpointAuthorization)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) grantor: std::option::Option<std::string::String>,
        pub(crate) grantee: std::option::Option<std::string::String>,
        pub(crate) cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) authorize_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) cluster_status: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::AuthorizationStatus>,
        pub(crate) allowed_all_vp_cs: std::option::Option<bool>,
        pub(crate) allowed_vp_cs: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) endpoint_count: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon Web Services account ID of the cluster owner.</p>
        pub fn grantor(mut self, input: impl Into<std::string::String>) -> Self {
            self.grantor = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID of the cluster owner.</p>
        pub fn set_grantor(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.grantor = input;
            self
        }
        /// <p>The Amazon Web Services account ID of the grantee of the cluster.</p>
        pub fn grantee(mut self, input: impl Into<std::string::String>) -> Self {
            self.grantee = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID of the grantee of the cluster.</p>
        pub fn set_grantee(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.grantee = input;
            self
        }
        /// <p>The cluster identifier.</p>
        pub fn cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_identifier = Some(input.into());
            self
        }
        /// <p>The cluster identifier.</p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cluster_identifier = input;
            self
        }
        /// <p>The time (UTC) when the authorization was created.</p>
        pub fn authorize_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.authorize_time = Some(input);
            self
        }
        /// <p>The time (UTC) when the authorization was created.</p>
        pub fn set_authorize_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.authorize_time = input;
            self
        }
        /// <p>The status of the cluster.</p>
        pub fn cluster_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_status = Some(input.into());
            self
        }
        /// <p>The status of the cluster.</p>
        pub fn set_cluster_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cluster_status = input;
            self
        }
        /// <p>The status of the authorization action.</p>
        pub fn status(mut self, input: crate::model::AuthorizationStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the authorization action.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::AuthorizationStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>Indicates whether all VPCs in the grantee account are allowed access to the cluster.</p>
        pub fn allowed_all_vp_cs(mut self, input: bool) -> Self {
            self.allowed_all_vp_cs = Some(input);
            self
        }
        /// <p>Indicates whether all VPCs in the grantee account are allowed access to the cluster.</p>
        pub fn set_allowed_all_vp_cs(mut self, input: std::option::Option<bool>) -> Self {
            self.allowed_all_vp_cs = input;
            self
        }
        /// Appends an item to `allowed_vp_cs`.
        ///
        /// To override the contents of this collection use [`set_allowed_vp_cs`](Self::set_allowed_vp_cs).
        ///
        /// <p>The VPCs allowed access to the cluster.</p>
        pub fn allowed_vp_cs(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.allowed_vp_cs.unwrap_or_default();
            v.push(input.into());
            self.allowed_vp_cs = Some(v);
            self
        }
        /// <p>The VPCs allowed access to the cluster.</p>
        pub fn set_allowed_vp_cs(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.allowed_vp_cs = input;
            self
        }
        /// <p>The number of Redshift-managed VPC endpoints created for the authorization.</p>
        pub fn endpoint_count(mut self, input: i32) -> Self {
            self.endpoint_count = Some(input);
            self
        }
        /// <p>The number of Redshift-managed VPC endpoints created for the authorization.</p>
        pub fn set_endpoint_count(mut self, input: std::option::Option<i32>) -> Self {
            self.endpoint_count = input;
            self
        }
        /// Consumes the builder and constructs a [`EndpointAuthorization`](crate::model::EndpointAuthorization)
        pub fn build(self) -> crate::model::EndpointAuthorization {
            crate::model::EndpointAuthorization {
                grantor: self.grantor,
                grantee: self.grantee,
                cluster_identifier: self.cluster_identifier,
                authorize_time: self.authorize_time,
                cluster_status: self.cluster_status,
                status: self.status,
                allowed_all_vp_cs: self.allowed_all_vp_cs.unwrap_or_default(),
                allowed_vp_cs: self.allowed_vp_cs,
                endpoint_count: self.endpoint_count.unwrap_or_default(),
            }
        }
    }
}
impl EndpointAuthorization {
    /// Creates a new builder-style object to manufacture [`EndpointAuthorization`](crate::model::EndpointAuthorization)
    pub fn builder() -> crate::model::endpoint_authorization::Builder {
        crate::model::endpoint_authorization::Builder::default()
    }
}

/// <p>Describes a Redshift-managed VPC endpoint.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EndpointAccess {
    /// <p>The cluster identifier of the cluster associated with the endpoint.</p>
    pub cluster_identifier: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services account ID of the owner of the cluster.</p>
    pub resource_owner: std::option::Option<std::string::String>,
    /// <p>The subnet group name where Amazon Redshift chooses to deploy the endpoint.</p>
    pub subnet_group_name: std::option::Option<std::string::String>,
    /// <p>The status of the endpoint.</p>
    pub endpoint_status: std::option::Option<std::string::String>,
    /// <p>The name of the endpoint.</p>
    pub endpoint_name: std::option::Option<std::string::String>,
    /// <p>The time (UTC) that the endpoint was created.</p>
    pub endpoint_create_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The port number on which the cluster accepts incoming connections.</p>
    pub port: i32,
    /// <p>The DNS address of the endpoint.</p>
    pub address: std::option::Option<std::string::String>,
    /// <p>The security groups associated with the endpoint.</p>
    pub vpc_security_groups:
        std::option::Option<std::vec::Vec<crate::model::VpcSecurityGroupMembership>>,
    /// <p>The connection endpoint for connecting to an Amazon Redshift cluster through the proxy.</p>
    pub vpc_endpoint: std::option::Option<crate::model::VpcEndpoint>,
}
impl EndpointAccess {
    /// <p>The cluster identifier of the cluster associated with the endpoint.</p>
    pub fn cluster_identifier(&self) -> std::option::Option<&str> {
        self.cluster_identifier.as_deref()
    }
    /// <p>The Amazon Web Services account ID of the owner of the cluster.</p>
    pub fn resource_owner(&self) -> std::option::Option<&str> {
        self.resource_owner.as_deref()
    }
    /// <p>The subnet group name where Amazon Redshift chooses to deploy the endpoint.</p>
    pub fn subnet_group_name(&self) -> std::option::Option<&str> {
        self.subnet_group_name.as_deref()
    }
    /// <p>The status of the endpoint.</p>
    pub fn endpoint_status(&self) -> std::option::Option<&str> {
        self.endpoint_status.as_deref()
    }
    /// <p>The name of the endpoint.</p>
    pub fn endpoint_name(&self) -> std::option::Option<&str> {
        self.endpoint_name.as_deref()
    }
    /// <p>The time (UTC) that the endpoint was created.</p>
    pub fn endpoint_create_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.endpoint_create_time.as_ref()
    }
    /// <p>The port number on which the cluster accepts incoming connections.</p>
    pub fn port(&self) -> i32 {
        self.port
    }
    /// <p>The DNS address of the endpoint.</p>
    pub fn address(&self) -> std::option::Option<&str> {
        self.address.as_deref()
    }
    /// <p>The security groups associated with the endpoint.</p>
    pub fn vpc_security_groups(
        &self,
    ) -> std::option::Option<&[crate::model::VpcSecurityGroupMembership]> {
        self.vpc_security_groups.as_deref()
    }
    /// <p>The connection endpoint for connecting to an Amazon Redshift cluster through the proxy.</p>
    pub fn vpc_endpoint(&self) -> std::option::Option<&crate::model::VpcEndpoint> {
        self.vpc_endpoint.as_ref()
    }
}
impl std::fmt::Debug for EndpointAccess {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EndpointAccess");
        formatter.field("cluster_identifier", &self.cluster_identifier);
        formatter.field("resource_owner", &self.resource_owner);
        formatter.field("subnet_group_name", &self.subnet_group_name);
        formatter.field("endpoint_status", &self.endpoint_status);
        formatter.field("endpoint_name", &self.endpoint_name);
        formatter.field("endpoint_create_time", &self.endpoint_create_time);
        formatter.field("port", &self.port);
        formatter.field("address", &self.address);
        formatter.field("vpc_security_groups", &self.vpc_security_groups);
        formatter.field("vpc_endpoint", &self.vpc_endpoint);
        formatter.finish()
    }
}
/// See [`EndpointAccess`](crate::model::EndpointAccess)
pub mod endpoint_access {
    /// A builder for [`EndpointAccess`](crate::model::EndpointAccess)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) resource_owner: std::option::Option<std::string::String>,
        pub(crate) subnet_group_name: std::option::Option<std::string::String>,
        pub(crate) endpoint_status: std::option::Option<std::string::String>,
        pub(crate) endpoint_name: std::option::Option<std::string::String>,
        pub(crate) endpoint_create_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) port: std::option::Option<i32>,
        pub(crate) address: std::option::Option<std::string::String>,
        pub(crate) vpc_security_groups:
            std::option::Option<std::vec::Vec<crate::model::VpcSecurityGroupMembership>>,
        pub(crate) vpc_endpoint: std::option::Option<crate::model::VpcEndpoint>,
    }
    impl Builder {
        /// <p>The cluster identifier of the cluster associated with the endpoint.</p>
        pub fn cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_identifier = Some(input.into());
            self
        }
        /// <p>The cluster identifier of the cluster associated with the endpoint.</p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cluster_identifier = input;
            self
        }
        /// <p>The Amazon Web Services account ID of the owner of the cluster.</p>
        pub fn resource_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_owner = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID of the owner of the cluster.</p>
        pub fn set_resource_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_owner = input;
            self
        }
        /// <p>The subnet group name where Amazon Redshift chooses to deploy the endpoint.</p>
        pub fn subnet_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.subnet_group_name = Some(input.into());
            self
        }
        /// <p>The subnet group name where Amazon Redshift chooses to deploy the endpoint.</p>
        pub fn set_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.subnet_group_name = input;
            self
        }
        /// <p>The status of the endpoint.</p>
        pub fn endpoint_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_status = Some(input.into());
            self
        }
        /// <p>The status of the endpoint.</p>
        pub fn set_endpoint_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.endpoint_status = input;
            self
        }
        /// <p>The name of the endpoint.</p>
        pub fn endpoint_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_name = Some(input.into());
            self
        }
        /// <p>The name of the endpoint.</p>
        pub fn set_endpoint_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.endpoint_name = input;
            self
        }
        /// <p>The time (UTC) that the endpoint was created.</p>
        pub fn endpoint_create_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.endpoint_create_time = Some(input);
            self
        }
        /// <p>The time (UTC) that the endpoint was created.</p>
        pub fn set_endpoint_create_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.endpoint_create_time = input;
            self
        }
        /// <p>The port number on which the cluster accepts incoming connections.</p>
        pub fn port(mut self, input: i32) -> Self {
            self.port = Some(input);
            self
        }
        /// <p>The port number on which the cluster accepts incoming connections.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.port = input;
            self
        }
        /// <p>The DNS address of the endpoint.</p>
        pub fn address(mut self, input: impl Into<std::string::String>) -> Self {
            self.address = Some(input.into());
            self
        }
        /// <p>The DNS address of the endpoint.</p>
        pub fn set_address(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.address = input;
            self
        }
        /// Appends an item to `vpc_security_groups`.
        ///
        /// To override the contents of this collection use [`set_vpc_security_groups`](Self::set_vpc_security_groups).
        ///
        /// <p>The security groups associated with the endpoint.</p>
        pub fn vpc_security_groups(
            mut self,
            input: crate::model::VpcSecurityGroupMembership,
        ) -> Self {
            let mut v = self.vpc_security_groups.unwrap_or_default();
            v.push(input);
            self.vpc_security_groups = Some(v);
            self
        }
        /// <p>The security groups associated with the endpoint.</p>
        pub fn set_vpc_security_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::VpcSecurityGroupMembership>>,
        ) -> Self {
            self.vpc_security_groups = input;
            self
        }
        /// <p>The connection endpoint for connecting to an Amazon Redshift cluster through the proxy.</p>
        pub fn vpc_endpoint(mut self, input: crate::model::VpcEndpoint) -> Self {
            self.vpc_endpoint = Some(input);
            self
        }
        /// <p>The connection endpoint for connecting to an Amazon Redshift cluster through the proxy.</p>
        pub fn set_vpc_endpoint(
            mut self,
            input: std::option::Option<crate::model::VpcEndpoint>,
        ) -> Self {
            self.vpc_endpoint = input;
            self
        }
        /// Consumes the builder and constructs a [`EndpointAccess`](crate::model::EndpointAccess)
        pub fn build(self) -> crate::model::EndpointAccess {
            crate::model::EndpointAccess {
                cluster_identifier: self.cluster_identifier,
                resource_owner: self.resource_owner,
                subnet_group_name: self.subnet_group_name,
                endpoint_status: self.endpoint_status,
                endpoint_name: self.endpoint_name,
                endpoint_create_time: self.endpoint_create_time,
                port: self.port.unwrap_or_default(),
                address: self.address,
                vpc_security_groups: self.vpc_security_groups,
                vpc_endpoint: self.vpc_endpoint,
            }
        }
    }
}
impl EndpointAccess {
    /// Creates a new builder-style object to manufacture [`EndpointAccess`](crate::model::EndpointAccess)
    pub fn builder() -> crate::model::endpoint_access::Builder {
        crate::model::endpoint_access::Builder::default()
    }
}

/// <p>Describes the default cluster parameters for a parameter group family.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DefaultClusterParameters {
    /// <p>The name of the cluster parameter group family to which the engine default parameters apply.</p>
    pub parameter_group_family: std::option::Option<std::string::String>,
    /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>The list of cluster default parameters.</p>
    pub parameters: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
}
impl DefaultClusterParameters {
    /// <p>The name of the cluster parameter group family to which the engine default parameters apply.</p>
    pub fn parameter_group_family(&self) -> std::option::Option<&str> {
        self.parameter_group_family.as_deref()
    }
    /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>The list of cluster default parameters.</p>
    pub fn parameters(&self) -> std::option::Option<&[crate::model::Parameter]> {
        self.parameters.as_deref()
    }
}
impl std::fmt::Debug for DefaultClusterParameters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DefaultClusterParameters");
        formatter.field("parameter_group_family", &self.parameter_group_family);
        formatter.field("marker", &self.marker);
        formatter.field("parameters", &self.parameters);
        formatter.finish()
    }
}
/// See [`DefaultClusterParameters`](crate::model::DefaultClusterParameters)
pub mod default_cluster_parameters {
    /// A builder for [`DefaultClusterParameters`](crate::model::DefaultClusterParameters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) parameter_group_family: std::option::Option<std::string::String>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) parameters: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
    }
    impl Builder {
        /// <p>The name of the cluster parameter group family to which the engine default parameters apply.</p>
        pub fn parameter_group_family(mut self, input: impl Into<std::string::String>) -> Self {
            self.parameter_group_family = Some(input.into());
            self
        }
        /// <p>The name of the cluster parameter group family to which the engine default parameters apply.</p>
        pub fn set_parameter_group_family(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parameter_group_family = input;
            self
        }
        /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Appends an item to `parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>The list of cluster default parameters.</p>
        pub fn parameters(mut self, input: crate::model::Parameter) -> Self {
            let mut v = self.parameters.unwrap_or_default();
            v.push(input);
            self.parameters = Some(v);
            self
        }
        /// <p>The list of cluster default parameters.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
        ) -> Self {
            self.parameters = input;
            self
        }
        /// Consumes the builder and constructs a [`DefaultClusterParameters`](crate::model::DefaultClusterParameters)
        pub fn build(self) -> crate::model::DefaultClusterParameters {
            crate::model::DefaultClusterParameters {
                parameter_group_family: self.parameter_group_family,
                marker: self.marker,
                parameters: self.parameters,
            }
        }
    }
}
impl DefaultClusterParameters {
    /// Creates a new builder-style object to manufacture [`DefaultClusterParameters`](crate::model::DefaultClusterParameters)
    pub fn builder() -> crate::model::default_cluster_parameters::Builder {
        crate::model::default_cluster_parameters::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DataShare {
    /// <p>An Amazon Resource Name (ARN) that references the datashare that is owned by a specific namespace of the producer cluster. A datashare ARN is in the <code>arn:aws:redshift:{region}:{account-id}:{datashare}:{namespace-guid}/{datashare-name}</code> format.</p>
    pub data_share_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the producer.</p>
    pub producer_arn: std::option::Option<std::string::String>,
    /// <p>A value that specifies whether the datashare can be shared to a publicly accessible cluster.</p>
    pub allow_publicly_accessible_consumers: bool,
    /// <p>A value that specifies when the datashare has an association between a producer and data consumers.</p>
    pub data_share_associations:
        std::option::Option<std::vec::Vec<crate::model::DataShareAssociation>>,
    /// <p>The identifier of a datashare to show its managing entity.</p>
    pub managed_by: std::option::Option<std::string::String>,
}
impl DataShare {
    /// <p>An Amazon Resource Name (ARN) that references the datashare that is owned by a specific namespace of the producer cluster. A datashare ARN is in the <code>arn:aws:redshift:{region}:{account-id}:{datashare}:{namespace-guid}/{datashare-name}</code> format.</p>
    pub fn data_share_arn(&self) -> std::option::Option<&str> {
        self.data_share_arn.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the producer.</p>
    pub fn producer_arn(&self) -> std::option::Option<&str> {
        self.producer_arn.as_deref()
    }
    /// <p>A value that specifies whether the datashare can be shared to a publicly accessible cluster.</p>
    pub fn allow_publicly_accessible_consumers(&self) -> bool {
        self.allow_publicly_accessible_consumers
    }
    /// <p>A value that specifies when the datashare has an association between a producer and data consumers.</p>
    pub fn data_share_associations(
        &self,
    ) -> std::option::Option<&[crate::model::DataShareAssociation]> {
        self.data_share_associations.as_deref()
    }
    /// <p>The identifier of a datashare to show its managing entity.</p>
    pub fn managed_by(&self) -> std::option::Option<&str> {
        self.managed_by.as_deref()
    }
}
impl std::fmt::Debug for DataShare {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DataShare");
        formatter.field("data_share_arn", &self.data_share_arn);
        formatter.field("producer_arn", &self.producer_arn);
        formatter.field(
            "allow_publicly_accessible_consumers",
            &self.allow_publicly_accessible_consumers,
        );
        formatter.field("data_share_associations", &self.data_share_associations);
        formatter.field("managed_by", &self.managed_by);
        formatter.finish()
    }
}
/// See [`DataShare`](crate::model::DataShare)
pub mod data_share {
    /// A builder for [`DataShare`](crate::model::DataShare)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data_share_arn: std::option::Option<std::string::String>,
        pub(crate) producer_arn: std::option::Option<std::string::String>,
        pub(crate) allow_publicly_accessible_consumers: std::option::Option<bool>,
        pub(crate) data_share_associations:
            std::option::Option<std::vec::Vec<crate::model::DataShareAssociation>>,
        pub(crate) managed_by: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>An Amazon Resource Name (ARN) that references the datashare that is owned by a specific namespace of the producer cluster. A datashare ARN is in the <code>arn:aws:redshift:{region}:{account-id}:{datashare}:{namespace-guid}/{datashare-name}</code> format.</p>
        pub fn data_share_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_share_arn = Some(input.into());
            self
        }
        /// <p>An Amazon Resource Name (ARN) that references the datashare that is owned by a specific namespace of the producer cluster. A datashare ARN is in the <code>arn:aws:redshift:{region}:{account-id}:{datashare}:{namespace-guid}/{datashare-name}</code> format.</p>
        pub fn set_data_share_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_share_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the producer.</p>
        pub fn producer_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.producer_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the producer.</p>
        pub fn set_producer_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.producer_arn = input;
            self
        }
        /// <p>A value that specifies whether the datashare can be shared to a publicly accessible cluster.</p>
        pub fn allow_publicly_accessible_consumers(mut self, input: bool) -> Self {
            self.allow_publicly_accessible_consumers = Some(input);
            self
        }
        /// <p>A value that specifies whether the datashare can be shared to a publicly accessible cluster.</p>
        pub fn set_allow_publicly_accessible_consumers(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.allow_publicly_accessible_consumers = input;
            self
        }
        /// Appends an item to `data_share_associations`.
        ///
        /// To override the contents of this collection use [`set_data_share_associations`](Self::set_data_share_associations).
        ///
        /// <p>A value that specifies when the datashare has an association between a producer and data consumers.</p>
        pub fn data_share_associations(
            mut self,
            input: crate::model::DataShareAssociation,
        ) -> Self {
            let mut v = self.data_share_associations.unwrap_or_default();
            v.push(input);
            self.data_share_associations = Some(v);
            self
        }
        /// <p>A value that specifies when the datashare has an association between a producer and data consumers.</p>
        pub fn set_data_share_associations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DataShareAssociation>>,
        ) -> Self {
            self.data_share_associations = input;
            self
        }
        /// <p>The identifier of a datashare to show its managing entity.</p>
        pub fn managed_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.managed_by = Some(input.into());
            self
        }
        /// <p>The identifier of a datashare to show its managing entity.</p>
        pub fn set_managed_by(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.managed_by = input;
            self
        }
        /// Consumes the builder and constructs a [`DataShare`](crate::model::DataShare)
        pub fn build(self) -> crate::model::DataShare {
            crate::model::DataShare {
                data_share_arn: self.data_share_arn,
                producer_arn: self.producer_arn,
                allow_publicly_accessible_consumers: self
                    .allow_publicly_accessible_consumers
                    .unwrap_or_default(),
                data_share_associations: self.data_share_associations,
                managed_by: self.managed_by,
            }
        }
    }
}
impl DataShare {
    /// Creates a new builder-style object to manufacture [`DataShare`](crate::model::DataShare)
    pub fn builder() -> crate::model::data_share::Builder {
        crate::model::data_share::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DataShareStatusForProducer {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Authorized,
    #[allow(missing_docs)] // documentation missing in model
    Deauthorized,
    #[allow(missing_docs)] // documentation missing in model
    PendingAuthorization,
    #[allow(missing_docs)] // documentation missing in model
    Rejected,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DataShareStatusForProducer {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => DataShareStatusForProducer::Active,
            "AUTHORIZED" => DataShareStatusForProducer::Authorized,
            "DEAUTHORIZED" => DataShareStatusForProducer::Deauthorized,
            "PENDING_AUTHORIZATION" => DataShareStatusForProducer::PendingAuthorization,
            "REJECTED" => DataShareStatusForProducer::Rejected,
            other => DataShareStatusForProducer::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DataShareStatusForProducer {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DataShareStatusForProducer::from(s))
    }
}
impl DataShareStatusForProducer {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DataShareStatusForProducer::Active => "ACTIVE",
            DataShareStatusForProducer::Authorized => "AUTHORIZED",
            DataShareStatusForProducer::Deauthorized => "DEAUTHORIZED",
            DataShareStatusForProducer::PendingAuthorization => "PENDING_AUTHORIZATION",
            DataShareStatusForProducer::Rejected => "REJECTED",
            DataShareStatusForProducer::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ACTIVE",
            "AUTHORIZED",
            "DEAUTHORIZED",
            "PENDING_AUTHORIZATION",
            "REJECTED",
        ]
    }
}
impl AsRef<str> for DataShareStatusForProducer {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DataShareStatusForConsumer {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Available,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DataShareStatusForConsumer {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => DataShareStatusForConsumer::Active,
            "AVAILABLE" => DataShareStatusForConsumer::Available,
            other => DataShareStatusForConsumer::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DataShareStatusForConsumer {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DataShareStatusForConsumer::from(s))
    }
}
impl DataShareStatusForConsumer {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DataShareStatusForConsumer::Active => "ACTIVE",
            DataShareStatusForConsumer::Available => "AVAILABLE",
            DataShareStatusForConsumer::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVE", "AVAILABLE"]
    }
}
impl AsRef<str> for DataShareStatusForConsumer {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes a cluster version, including the parameter group family and description of the version.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ClusterVersion {
    /// <p>The version number used by the cluster.</p>
    pub cluster_version: std::option::Option<std::string::String>,
    /// <p>The name of the cluster parameter group family for the cluster.</p>
    pub cluster_parameter_group_family: std::option::Option<std::string::String>,
    /// <p>The description of the cluster version.</p>
    pub description: std::option::Option<std::string::String>,
}
impl ClusterVersion {
    /// <p>The version number used by the cluster.</p>
    pub fn cluster_version(&self) -> std::option::Option<&str> {
        self.cluster_version.as_deref()
    }
    /// <p>The name of the cluster parameter group family for the cluster.</p>
    pub fn cluster_parameter_group_family(&self) -> std::option::Option<&str> {
        self.cluster_parameter_group_family.as_deref()
    }
    /// <p>The description of the cluster version.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
}
impl std::fmt::Debug for ClusterVersion {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ClusterVersion");
        formatter.field("cluster_version", &self.cluster_version);
        formatter.field(
            "cluster_parameter_group_family",
            &self.cluster_parameter_group_family,
        );
        formatter.field("description", &self.description);
        formatter.finish()
    }
}
/// See [`ClusterVersion`](crate::model::ClusterVersion)
pub mod cluster_version {
    /// A builder for [`ClusterVersion`](crate::model::ClusterVersion)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_version: std::option::Option<std::string::String>,
        pub(crate) cluster_parameter_group_family: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The version number used by the cluster.</p>
        pub fn cluster_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_version = Some(input.into());
            self
        }
        /// <p>The version number used by the cluster.</p>
        pub fn set_cluster_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cluster_version = input;
            self
        }
        /// <p>The name of the cluster parameter group family for the cluster.</p>
        pub fn cluster_parameter_group_family(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.cluster_parameter_group_family = Some(input.into());
            self
        }
        /// <p>The name of the cluster parameter group family for the cluster.</p>
        pub fn set_cluster_parameter_group_family(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cluster_parameter_group_family = input;
            self
        }
        /// <p>The description of the cluster version.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the cluster version.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`ClusterVersion`](crate::model::ClusterVersion)
        pub fn build(self) -> crate::model::ClusterVersion {
            crate::model::ClusterVersion {
                cluster_version: self.cluster_version,
                cluster_parameter_group_family: self.cluster_parameter_group_family,
                description: self.description,
            }
        }
    }
}
impl ClusterVersion {
    /// Creates a new builder-style object to manufacture [`ClusterVersion`](crate::model::ClusterVersion)
    pub fn builder() -> crate::model::cluster_version::Builder {
        crate::model::cluster_version::Builder::default()
    }
}

/// <p>Defines a maintenance track that determines which Amazon Redshift version to apply during a maintenance window. If the value for <code>MaintenanceTrack</code> is <code>current</code>, the cluster is updated to the most recently certified maintenance release. If the value is <code>trailing</code>, the cluster is updated to the previously certified maintenance release. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MaintenanceTrack {
    /// <p>The name of the maintenance track. Possible values are <code>current</code> and <code>trailing</code>.</p>
    pub maintenance_track_name: std::option::Option<std::string::String>,
    /// <p>The version number for the cluster release.</p>
    pub database_version: std::option::Option<std::string::String>,
    /// <p>An array of <code>UpdateTarget</code> objects to update with the maintenance track. </p>
    pub update_targets: std::option::Option<std::vec::Vec<crate::model::UpdateTarget>>,
}
impl MaintenanceTrack {
    /// <p>The name of the maintenance track. Possible values are <code>current</code> and <code>trailing</code>.</p>
    pub fn maintenance_track_name(&self) -> std::option::Option<&str> {
        self.maintenance_track_name.as_deref()
    }
    /// <p>The version number for the cluster release.</p>
    pub fn database_version(&self) -> std::option::Option<&str> {
        self.database_version.as_deref()
    }
    /// <p>An array of <code>UpdateTarget</code> objects to update with the maintenance track. </p>
    pub fn update_targets(&self) -> std::option::Option<&[crate::model::UpdateTarget]> {
        self.update_targets.as_deref()
    }
}
impl std::fmt::Debug for MaintenanceTrack {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MaintenanceTrack");
        formatter.field("maintenance_track_name", &self.maintenance_track_name);
        formatter.field("database_version", &self.database_version);
        formatter.field("update_targets", &self.update_targets);
        formatter.finish()
    }
}
/// See [`MaintenanceTrack`](crate::model::MaintenanceTrack)
pub mod maintenance_track {
    /// A builder for [`MaintenanceTrack`](crate::model::MaintenanceTrack)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) maintenance_track_name: std::option::Option<std::string::String>,
        pub(crate) database_version: std::option::Option<std::string::String>,
        pub(crate) update_targets: std::option::Option<std::vec::Vec<crate::model::UpdateTarget>>,
    }
    impl Builder {
        /// <p>The name of the maintenance track. Possible values are <code>current</code> and <code>trailing</code>.</p>
        pub fn maintenance_track_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.maintenance_track_name = Some(input.into());
            self
        }
        /// <p>The name of the maintenance track. Possible values are <code>current</code> and <code>trailing</code>.</p>
        pub fn set_maintenance_track_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.maintenance_track_name = input;
            self
        }
        /// <p>The version number for the cluster release.</p>
        pub fn database_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.database_version = Some(input.into());
            self
        }
        /// <p>The version number for the cluster release.</p>
        pub fn set_database_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.database_version = input;
            self
        }
        /// Appends an item to `update_targets`.
        ///
        /// To override the contents of this collection use [`set_update_targets`](Self::set_update_targets).
        ///
        /// <p>An array of <code>UpdateTarget</code> objects to update with the maintenance track. </p>
        pub fn update_targets(mut self, input: crate::model::UpdateTarget) -> Self {
            let mut v = self.update_targets.unwrap_or_default();
            v.push(input);
            self.update_targets = Some(v);
            self
        }
        /// <p>An array of <code>UpdateTarget</code> objects to update with the maintenance track. </p>
        pub fn set_update_targets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UpdateTarget>>,
        ) -> Self {
            self.update_targets = input;
            self
        }
        /// Consumes the builder and constructs a [`MaintenanceTrack`](crate::model::MaintenanceTrack)
        pub fn build(self) -> crate::model::MaintenanceTrack {
            crate::model::MaintenanceTrack {
                maintenance_track_name: self.maintenance_track_name,
                database_version: self.database_version,
                update_targets: self.update_targets,
            }
        }
    }
}
impl MaintenanceTrack {
    /// Creates a new builder-style object to manufacture [`MaintenanceTrack`](crate::model::MaintenanceTrack)
    pub fn builder() -> crate::model::maintenance_track::Builder {
        crate::model::maintenance_track::Builder::default()
    }
}

/// <p>A maintenance track that you can switch the current track to.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateTarget {
    /// <p>The name of the new maintenance track.</p>
    pub maintenance_track_name: std::option::Option<std::string::String>,
    /// <p>The cluster version for the new maintenance track.</p>
    pub database_version: std::option::Option<std::string::String>,
    /// <p>A list of operations supported by the maintenance track.</p>
    pub supported_operations: std::option::Option<std::vec::Vec<crate::model::SupportedOperation>>,
}
impl UpdateTarget {
    /// <p>The name of the new maintenance track.</p>
    pub fn maintenance_track_name(&self) -> std::option::Option<&str> {
        self.maintenance_track_name.as_deref()
    }
    /// <p>The cluster version for the new maintenance track.</p>
    pub fn database_version(&self) -> std::option::Option<&str> {
        self.database_version.as_deref()
    }
    /// <p>A list of operations supported by the maintenance track.</p>
    pub fn supported_operations(&self) -> std::option::Option<&[crate::model::SupportedOperation]> {
        self.supported_operations.as_deref()
    }
}
impl std::fmt::Debug for UpdateTarget {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateTarget");
        formatter.field("maintenance_track_name", &self.maintenance_track_name);
        formatter.field("database_version", &self.database_version);
        formatter.field("supported_operations", &self.supported_operations);
        formatter.finish()
    }
}
/// See [`UpdateTarget`](crate::model::UpdateTarget)
pub mod update_target {
    /// A builder for [`UpdateTarget`](crate::model::UpdateTarget)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) maintenance_track_name: std::option::Option<std::string::String>,
        pub(crate) database_version: std::option::Option<std::string::String>,
        pub(crate) supported_operations:
            std::option::Option<std::vec::Vec<crate::model::SupportedOperation>>,
    }
    impl Builder {
        /// <p>The name of the new maintenance track.</p>
        pub fn maintenance_track_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.maintenance_track_name = Some(input.into());
            self
        }
        /// <p>The name of the new maintenance track.</p>
        pub fn set_maintenance_track_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.maintenance_track_name = input;
            self
        }
        /// <p>The cluster version for the new maintenance track.</p>
        pub fn database_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.database_version = Some(input.into());
            self
        }
        /// <p>The cluster version for the new maintenance track.</p>
        pub fn set_database_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.database_version = input;
            self
        }
        /// Appends an item to `supported_operations`.
        ///
        /// To override the contents of this collection use [`set_supported_operations`](Self::set_supported_operations).
        ///
        /// <p>A list of operations supported by the maintenance track.</p>
        pub fn supported_operations(mut self, input: crate::model::SupportedOperation) -> Self {
            let mut v = self.supported_operations.unwrap_or_default();
            v.push(input);
            self.supported_operations = Some(v);
            self
        }
        /// <p>A list of operations supported by the maintenance track.</p>
        pub fn set_supported_operations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SupportedOperation>>,
        ) -> Self {
            self.supported_operations = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateTarget`](crate::model::UpdateTarget)
        pub fn build(self) -> crate::model::UpdateTarget {
            crate::model::UpdateTarget {
                maintenance_track_name: self.maintenance_track_name,
                database_version: self.database_version,
                supported_operations: self.supported_operations,
            }
        }
    }
}
impl UpdateTarget {
    /// Creates a new builder-style object to manufacture [`UpdateTarget`](crate::model::UpdateTarget)
    pub fn builder() -> crate::model::update_target::Builder {
        crate::model::update_target::Builder::default()
    }
}

/// <p>Describes the operations that are allowed on a maintenance track.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SupportedOperation {
    /// <p>A list of the supported operations.</p>
    pub operation_name: std::option::Option<std::string::String>,
}
impl SupportedOperation {
    /// <p>A list of the supported operations.</p>
    pub fn operation_name(&self) -> std::option::Option<&str> {
        self.operation_name.as_deref()
    }
}
impl std::fmt::Debug for SupportedOperation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SupportedOperation");
        formatter.field("operation_name", &self.operation_name);
        formatter.finish()
    }
}
/// See [`SupportedOperation`](crate::model::SupportedOperation)
pub mod supported_operation {
    /// A builder for [`SupportedOperation`](crate::model::SupportedOperation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) operation_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A list of the supported operations.</p>
        pub fn operation_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.operation_name = Some(input.into());
            self
        }
        /// <p>A list of the supported operations.</p>
        pub fn set_operation_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.operation_name = input;
            self
        }
        /// Consumes the builder and constructs a [`SupportedOperation`](crate::model::SupportedOperation)
        pub fn build(self) -> crate::model::SupportedOperation {
            crate::model::SupportedOperation {
                operation_name: self.operation_name,
            }
        }
    }
}
impl SupportedOperation {
    /// Creates a new builder-style object to manufacture [`SupportedOperation`](crate::model::SupportedOperation)
    pub fn builder() -> crate::model::supported_operation::Builder {
        crate::model::supported_operation::Builder::default()
    }
}

/// <p>Describes a sorting entity</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SnapshotSortingEntity {
    /// <p>The category for sorting the snapshots.</p>
    pub attribute: std::option::Option<crate::model::SnapshotAttributeToSortBy>,
    /// <p>The order for listing the attributes.</p>
    pub sort_order: std::option::Option<crate::model::SortByOrder>,
}
impl SnapshotSortingEntity {
    /// <p>The category for sorting the snapshots.</p>
    pub fn attribute(&self) -> std::option::Option<&crate::model::SnapshotAttributeToSortBy> {
        self.attribute.as_ref()
    }
    /// <p>The order for listing the attributes.</p>
    pub fn sort_order(&self) -> std::option::Option<&crate::model::SortByOrder> {
        self.sort_order.as_ref()
    }
}
impl std::fmt::Debug for SnapshotSortingEntity {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SnapshotSortingEntity");
        formatter.field("attribute", &self.attribute);
        formatter.field("sort_order", &self.sort_order);
        formatter.finish()
    }
}
/// See [`SnapshotSortingEntity`](crate::model::SnapshotSortingEntity)
pub mod snapshot_sorting_entity {
    /// A builder for [`SnapshotSortingEntity`](crate::model::SnapshotSortingEntity)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attribute: std::option::Option<crate::model::SnapshotAttributeToSortBy>,
        pub(crate) sort_order: std::option::Option<crate::model::SortByOrder>,
    }
    impl Builder {
        /// <p>The category for sorting the snapshots.</p>
        pub fn attribute(mut self, input: crate::model::SnapshotAttributeToSortBy) -> Self {
            self.attribute = Some(input);
            self
        }
        /// <p>The category for sorting the snapshots.</p>
        pub fn set_attribute(
            mut self,
            input: std::option::Option<crate::model::SnapshotAttributeToSortBy>,
        ) -> Self {
            self.attribute = input;
            self
        }
        /// <p>The order for listing the attributes.</p>
        pub fn sort_order(mut self, input: crate::model::SortByOrder) -> Self {
            self.sort_order = Some(input);
            self
        }
        /// <p>The order for listing the attributes.</p>
        pub fn set_sort_order(
            mut self,
            input: std::option::Option<crate::model::SortByOrder>,
        ) -> Self {
            self.sort_order = input;
            self
        }
        /// Consumes the builder and constructs a [`SnapshotSortingEntity`](crate::model::SnapshotSortingEntity)
        pub fn build(self) -> crate::model::SnapshotSortingEntity {
            crate::model::SnapshotSortingEntity {
                attribute: self.attribute,
                sort_order: self.sort_order,
            }
        }
    }
}
impl SnapshotSortingEntity {
    /// Creates a new builder-style object to manufacture [`SnapshotSortingEntity`](crate::model::SnapshotSortingEntity)
    pub fn builder() -> crate::model::snapshot_sorting_entity::Builder {
        crate::model::snapshot_sorting_entity::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SortByOrder {
    #[allow(missing_docs)] // documentation missing in model
    Ascending,
    #[allow(missing_docs)] // documentation missing in model
    Descending,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SortByOrder {
    fn from(s: &str) -> Self {
        match s {
            "ASC" => SortByOrder::Ascending,
            "DESC" => SortByOrder::Descending,
            other => SortByOrder::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SortByOrder {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SortByOrder::from(s))
    }
}
impl SortByOrder {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SortByOrder::Ascending => "ASC",
            SortByOrder::Descending => "DESC",
            SortByOrder::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ASC", "DESC"]
    }
}
impl AsRef<str> for SortByOrder {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SnapshotAttributeToSortBy {
    #[allow(missing_docs)] // documentation missing in model
    CreateTime,
    #[allow(missing_docs)] // documentation missing in model
    SourceType,
    #[allow(missing_docs)] // documentation missing in model
    TotalSize,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SnapshotAttributeToSortBy {
    fn from(s: &str) -> Self {
        match s {
            "CREATE_TIME" => SnapshotAttributeToSortBy::CreateTime,
            "SOURCE_TYPE" => SnapshotAttributeToSortBy::SourceType,
            "TOTAL_SIZE" => SnapshotAttributeToSortBy::TotalSize,
            other => SnapshotAttributeToSortBy::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SnapshotAttributeToSortBy {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SnapshotAttributeToSortBy::from(s))
    }
}
impl SnapshotAttributeToSortBy {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SnapshotAttributeToSortBy::CreateTime => "CREATE_TIME",
            SnapshotAttributeToSortBy::SourceType => "SOURCE_TYPE",
            SnapshotAttributeToSortBy::TotalSize => "TOTAL_SIZE",
            SnapshotAttributeToSortBy::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CREATE_TIME", "SOURCE_TYPE", "TOTAL_SIZE"]
    }
}
impl AsRef<str> for SnapshotAttributeToSortBy {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Describes a parameter group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ClusterParameterGroup {
    /// <p>The name of the cluster parameter group.</p>
    pub parameter_group_name: std::option::Option<std::string::String>,
    /// <p>The name of the cluster parameter group family that this cluster parameter group is compatible with.</p>
    pub parameter_group_family: std::option::Option<std::string::String>,
    /// <p>The description of the parameter group.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The list of tags for the cluster parameter group.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl ClusterParameterGroup {
    /// <p>The name of the cluster parameter group.</p>
    pub fn parameter_group_name(&self) -> std::option::Option<&str> {
        self.parameter_group_name.as_deref()
    }
    /// <p>The name of the cluster parameter group family that this cluster parameter group is compatible with.</p>
    pub fn parameter_group_family(&self) -> std::option::Option<&str> {
        self.parameter_group_family.as_deref()
    }
    /// <p>The description of the parameter group.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The list of tags for the cluster parameter group.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for ClusterParameterGroup {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ClusterParameterGroup");
        formatter.field("parameter_group_name", &self.parameter_group_name);
        formatter.field("parameter_group_family", &self.parameter_group_family);
        formatter.field("description", &self.description);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ClusterParameterGroup`](crate::model::ClusterParameterGroup)
pub mod cluster_parameter_group {
    /// A builder for [`ClusterParameterGroup`](crate::model::ClusterParameterGroup)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) parameter_group_name: std::option::Option<std::string::String>,
        pub(crate) parameter_group_family: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of the cluster parameter group.</p>
        pub fn parameter_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.parameter_group_name = Some(input.into());
            self
        }
        /// <p>The name of the cluster parameter group.</p>
        pub fn set_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parameter_group_name = input;
            self
        }
        /// <p>The name of the cluster parameter group family that this cluster parameter group is compatible with.</p>
        pub fn parameter_group_family(mut self, input: impl Into<std::string::String>) -> Self {
            self.parameter_group_family = Some(input.into());
            self
        }
        /// <p>The name of the cluster parameter group family that this cluster parameter group is compatible with.</p>
        pub fn set_parameter_group_family(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parameter_group_family = input;
            self
        }
        /// <p>The description of the parameter group.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the parameter group.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The list of tags for the cluster parameter group.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The list of tags for the cluster parameter group.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ClusterParameterGroup`](crate::model::ClusterParameterGroup)
        pub fn build(self) -> crate::model::ClusterParameterGroup {
            crate::model::ClusterParameterGroup {
                parameter_group_name: self.parameter_group_name,
                parameter_group_family: self.parameter_group_family,
                description: self.description,
                tags: self.tags,
            }
        }
    }
}
impl ClusterParameterGroup {
    /// Creates a new builder-style object to manufacture [`ClusterParameterGroup`](crate::model::ClusterParameterGroup)
    pub fn builder() -> crate::model::cluster_parameter_group::Builder {
        crate::model::cluster_parameter_group::Builder::default()
    }
}

/// <p>Describes a <code>ClusterDbRevision</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ClusterDbRevision {
    /// <p>The unique identifier of the cluster.</p>
    pub cluster_identifier: std::option::Option<std::string::String>,
    /// <p>A string representing the current cluster version.</p>
    pub current_database_revision: std::option::Option<std::string::String>,
    /// <p>The date on which the database revision was released.</p>
    pub database_revision_release_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>A list of <code>RevisionTarget</code> objects, where each object describes the database revision that a cluster can be updated to.</p>
    pub revision_targets: std::option::Option<std::vec::Vec<crate::model::RevisionTarget>>,
}
impl ClusterDbRevision {
    /// <p>The unique identifier of the cluster.</p>
    pub fn cluster_identifier(&self) -> std::option::Option<&str> {
        self.cluster_identifier.as_deref()
    }
    /// <p>A string representing the current cluster version.</p>
    pub fn current_database_revision(&self) -> std::option::Option<&str> {
        self.current_database_revision.as_deref()
    }
    /// <p>The date on which the database revision was released.</p>
    pub fn database_revision_release_date(
        &self,
    ) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.database_revision_release_date.as_ref()
    }
    /// <p>A list of <code>RevisionTarget</code> objects, where each object describes the database revision that a cluster can be updated to.</p>
    pub fn revision_targets(&self) -> std::option::Option<&[crate::model::RevisionTarget]> {
        self.revision_targets.as_deref()
    }
}
impl std::fmt::Debug for ClusterDbRevision {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ClusterDbRevision");
        formatter.field("cluster_identifier", &self.cluster_identifier);
        formatter.field("current_database_revision", &self.current_database_revision);
        formatter.field(
            "database_revision_release_date",
            &self.database_revision_release_date,
        );
        formatter.field("revision_targets", &self.revision_targets);
        formatter.finish()
    }
}
/// See [`ClusterDbRevision`](crate::model::ClusterDbRevision)
pub mod cluster_db_revision {
    /// A builder for [`ClusterDbRevision`](crate::model::ClusterDbRevision)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) current_database_revision: std::option::Option<std::string::String>,
        pub(crate) database_revision_release_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) revision_targets:
            std::option::Option<std::vec::Vec<crate::model::RevisionTarget>>,
    }
    impl Builder {
        /// <p>The unique identifier of the cluster.</p>
        pub fn cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_identifier = Some(input.into());
            self
        }
        /// <p>The unique identifier of the cluster.</p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cluster_identifier = input;
            self
        }
        /// <p>A string representing the current cluster version.</p>
        pub fn current_database_revision(mut self, input: impl Into<std::string::String>) -> Self {
            self.current_database_revision = Some(input.into());
            self
        }
        /// <p>A string representing the current cluster version.</p>
        pub fn set_current_database_revision(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.current_database_revision = input;
            self
        }
        /// <p>The date on which the database revision was released.</p>
        pub fn database_revision_release_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.database_revision_release_date = Some(input);
            self
        }
        /// <p>The date on which the database revision was released.</p>
        pub fn set_database_revision_release_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.database_revision_release_date = input;
            self
        }
        /// Appends an item to `revision_targets`.
        ///
        /// To override the contents of this collection use [`set_revision_targets`](Self::set_revision_targets).
        ///
        /// <p>A list of <code>RevisionTarget</code> objects, where each object describes the database revision that a cluster can be updated to.</p>
        pub fn revision_targets(mut self, input: crate::model::RevisionTarget) -> Self {
            let mut v = self.revision_targets.unwrap_or_default();
            v.push(input);
            self.revision_targets = Some(v);
            self
        }
        /// <p>A list of <code>RevisionTarget</code> objects, where each object describes the database revision that a cluster can be updated to.</p>
        pub fn set_revision_targets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RevisionTarget>>,
        ) -> Self {
            self.revision_targets = input;
            self
        }
        /// Consumes the builder and constructs a [`ClusterDbRevision`](crate::model::ClusterDbRevision)
        pub fn build(self) -> crate::model::ClusterDbRevision {
            crate::model::ClusterDbRevision {
                cluster_identifier: self.cluster_identifier,
                current_database_revision: self.current_database_revision,
                database_revision_release_date: self.database_revision_release_date,
                revision_targets: self.revision_targets,
            }
        }
    }
}
impl ClusterDbRevision {
    /// Creates a new builder-style object to manufacture [`ClusterDbRevision`](crate::model::ClusterDbRevision)
    pub fn builder() -> crate::model::cluster_db_revision::Builder {
        crate::model::cluster_db_revision::Builder::default()
    }
}

/// <p>Describes a <code>RevisionTarget</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RevisionTarget {
    /// <p>A unique string that identifies the version to update the cluster to. You can use this value in <code>ModifyClusterDbRevision</code>.</p>
    pub database_revision: std::option::Option<std::string::String>,
    /// <p>A string that describes the changes and features that will be applied to the cluster when it is updated to the corresponding <code>ClusterDbRevision</code>.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The date on which the database revision was released.</p>
    pub database_revision_release_date: std::option::Option<aws_smithy_types::DateTime>,
}
impl RevisionTarget {
    /// <p>A unique string that identifies the version to update the cluster to. You can use this value in <code>ModifyClusterDbRevision</code>.</p>
    pub fn database_revision(&self) -> std::option::Option<&str> {
        self.database_revision.as_deref()
    }
    /// <p>A string that describes the changes and features that will be applied to the cluster when it is updated to the corresponding <code>ClusterDbRevision</code>.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The date on which the database revision was released.</p>
    pub fn database_revision_release_date(
        &self,
    ) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.database_revision_release_date.as_ref()
    }
}
impl std::fmt::Debug for RevisionTarget {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RevisionTarget");
        formatter.field("database_revision", &self.database_revision);
        formatter.field("description", &self.description);
        formatter.field(
            "database_revision_release_date",
            &self.database_revision_release_date,
        );
        formatter.finish()
    }
}
/// See [`RevisionTarget`](crate::model::RevisionTarget)
pub mod revision_target {
    /// A builder for [`RevisionTarget`](crate::model::RevisionTarget)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) database_revision: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) database_revision_release_date: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>A unique string that identifies the version to update the cluster to. You can use this value in <code>ModifyClusterDbRevision</code>.</p>
        pub fn database_revision(mut self, input: impl Into<std::string::String>) -> Self {
            self.database_revision = Some(input.into());
            self
        }
        /// <p>A unique string that identifies the version to update the cluster to. You can use this value in <code>ModifyClusterDbRevision</code>.</p>
        pub fn set_database_revision(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.database_revision = input;
            self
        }
        /// <p>A string that describes the changes and features that will be applied to the cluster when it is updated to the corresponding <code>ClusterDbRevision</code>.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A string that describes the changes and features that will be applied to the cluster when it is updated to the corresponding <code>ClusterDbRevision</code>.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The date on which the database revision was released.</p>
        pub fn database_revision_release_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.database_revision_release_date = Some(input);
            self
        }
        /// <p>The date on which the database revision was released.</p>
        pub fn set_database_revision_release_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.database_revision_release_date = input;
            self
        }
        /// Consumes the builder and constructs a [`RevisionTarget`](crate::model::RevisionTarget)
        pub fn build(self) -> crate::model::RevisionTarget {
            crate::model::RevisionTarget {
                database_revision: self.database_revision,
                description: self.description,
                database_revision_release_date: self.database_revision_release_date,
            }
        }
    }
}
impl RevisionTarget {
    /// Creates a new builder-style object to manufacture [`RevisionTarget`](crate::model::RevisionTarget)
    pub fn builder() -> crate::model::revision_target::Builder {
        crate::model::revision_target::Builder::default()
    }
}

/// <p>Describes an authentication profile.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AuthenticationProfile {
    /// <p>The name of the authentication profile.</p>
    pub authentication_profile_name: std::option::Option<std::string::String>,
    /// <p>The content of the authentication profile in JSON format. The maximum length of the JSON string is determined by a quota for your account.</p>
    pub authentication_profile_content: std::option::Option<std::string::String>,
}
impl AuthenticationProfile {
    /// <p>The name of the authentication profile.</p>
    pub fn authentication_profile_name(&self) -> std::option::Option<&str> {
        self.authentication_profile_name.as_deref()
    }
    /// <p>The content of the authentication profile in JSON format. The maximum length of the JSON string is determined by a quota for your account.</p>
    pub fn authentication_profile_content(&self) -> std::option::Option<&str> {
        self.authentication_profile_content.as_deref()
    }
}
impl std::fmt::Debug for AuthenticationProfile {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AuthenticationProfile");
        formatter.field(
            "authentication_profile_name",
            &self.authentication_profile_name,
        );
        formatter.field(
            "authentication_profile_content",
            &self.authentication_profile_content,
        );
        formatter.finish()
    }
}
/// See [`AuthenticationProfile`](crate::model::AuthenticationProfile)
pub mod authentication_profile {
    /// A builder for [`AuthenticationProfile`](crate::model::AuthenticationProfile)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authentication_profile_name: std::option::Option<std::string::String>,
        pub(crate) authentication_profile_content: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the authentication profile.</p>
        pub fn authentication_profile_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.authentication_profile_name = Some(input.into());
            self
        }
        /// <p>The name of the authentication profile.</p>
        pub fn set_authentication_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authentication_profile_name = input;
            self
        }
        /// <p>The content of the authentication profile in JSON format. The maximum length of the JSON string is determined by a quota for your account.</p>
        pub fn authentication_profile_content(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.authentication_profile_content = Some(input.into());
            self
        }
        /// <p>The content of the authentication profile in JSON format. The maximum length of the JSON string is determined by a quota for your account.</p>
        pub fn set_authentication_profile_content(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authentication_profile_content = input;
            self
        }
        /// Consumes the builder and constructs a [`AuthenticationProfile`](crate::model::AuthenticationProfile)
        pub fn build(self) -> crate::model::AuthenticationProfile {
            crate::model::AuthenticationProfile {
                authentication_profile_name: self.authentication_profile_name,
                authentication_profile_content: self.authentication_profile_content,
            }
        }
    }
}
impl AuthenticationProfile {
    /// Creates a new builder-style object to manufacture [`AuthenticationProfile`](crate::model::AuthenticationProfile)
    pub fn builder() -> crate::model::authentication_profile::Builder {
        crate::model::authentication_profile::Builder::default()
    }
}

/// <p>A name value pair that describes an aspect of an account. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccountAttribute {
    /// <p>The name of the attribute.</p>
    pub attribute_name: std::option::Option<std::string::String>,
    /// <p>A list of attribute values.</p>
    pub attribute_values: std::option::Option<std::vec::Vec<crate::model::AttributeValueTarget>>,
}
impl AccountAttribute {
    /// <p>The name of the attribute.</p>
    pub fn attribute_name(&self) -> std::option::Option<&str> {
        self.attribute_name.as_deref()
    }
    /// <p>A list of attribute values.</p>
    pub fn attribute_values(&self) -> std::option::Option<&[crate::model::AttributeValueTarget]> {
        self.attribute_values.as_deref()
    }
}
impl std::fmt::Debug for AccountAttribute {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccountAttribute");
        formatter.field("attribute_name", &self.attribute_name);
        formatter.field("attribute_values", &self.attribute_values);
        formatter.finish()
    }
}
/// See [`AccountAttribute`](crate::model::AccountAttribute)
pub mod account_attribute {
    /// A builder for [`AccountAttribute`](crate::model::AccountAttribute)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attribute_name: std::option::Option<std::string::String>,
        pub(crate) attribute_values:
            std::option::Option<std::vec::Vec<crate::model::AttributeValueTarget>>,
    }
    impl Builder {
        /// <p>The name of the attribute.</p>
        pub fn attribute_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.attribute_name = Some(input.into());
            self
        }
        /// <p>The name of the attribute.</p>
        pub fn set_attribute_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.attribute_name = input;
            self
        }
        /// Appends an item to `attribute_values`.
        ///
        /// To override the contents of this collection use [`set_attribute_values`](Self::set_attribute_values).
        ///
        /// <p>A list of attribute values.</p>
        pub fn attribute_values(mut self, input: crate::model::AttributeValueTarget) -> Self {
            let mut v = self.attribute_values.unwrap_or_default();
            v.push(input);
            self.attribute_values = Some(v);
            self
        }
        /// <p>A list of attribute values.</p>
        pub fn set_attribute_values(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AttributeValueTarget>>,
        ) -> Self {
            self.attribute_values = input;
            self
        }
        /// Consumes the builder and constructs a [`AccountAttribute`](crate::model::AccountAttribute)
        pub fn build(self) -> crate::model::AccountAttribute {
            crate::model::AccountAttribute {
                attribute_name: self.attribute_name,
                attribute_values: self.attribute_values,
            }
        }
    }
}
impl AccountAttribute {
    /// Creates a new builder-style object to manufacture [`AccountAttribute`](crate::model::AccountAttribute)
    pub fn builder() -> crate::model::account_attribute::Builder {
        crate::model::account_attribute::Builder::default()
    }
}

/// <p>Describes an attribute value.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AttributeValueTarget {
    /// <p>The value of the attribute.</p>
    pub attribute_value: std::option::Option<std::string::String>,
}
impl AttributeValueTarget {
    /// <p>The value of the attribute.</p>
    pub fn attribute_value(&self) -> std::option::Option<&str> {
        self.attribute_value.as_deref()
    }
}
impl std::fmt::Debug for AttributeValueTarget {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AttributeValueTarget");
        formatter.field("attribute_value", &self.attribute_value);
        formatter.finish()
    }
}
/// See [`AttributeValueTarget`](crate::model::AttributeValueTarget)
pub mod attribute_value_target {
    /// A builder for [`AttributeValueTarget`](crate::model::AttributeValueTarget)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attribute_value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The value of the attribute.</p>
        pub fn attribute_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.attribute_value = Some(input.into());
            self
        }
        /// <p>The value of the attribute.</p>
        pub fn set_attribute_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.attribute_value = input;
            self
        }
        /// Consumes the builder and constructs a [`AttributeValueTarget`](crate::model::AttributeValueTarget)
        pub fn build(self) -> crate::model::AttributeValueTarget {
            crate::model::AttributeValueTarget {
                attribute_value: self.attribute_value,
            }
        }
    }
}
impl AttributeValueTarget {
    /// Creates a new builder-style object to manufacture [`AttributeValueTarget`](crate::model::AttributeValueTarget)
    pub fn builder() -> crate::model::attribute_value_target::Builder {
        crate::model::attribute_value_target::Builder::default()
    }
}

/// <p>Describes the errors returned by a snapshot.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SnapshotErrorMessage {
    /// <p>A unique identifier for the snapshot returning the error.</p>
    pub snapshot_identifier: std::option::Option<std::string::String>,
    /// <p>A unique identifier for the cluster.</p>
    pub snapshot_cluster_identifier: std::option::Option<std::string::String>,
    /// <p>The failure code for the error.</p>
    pub failure_code: std::option::Option<std::string::String>,
    /// <p>The text message describing the error.</p>
    pub failure_reason: std::option::Option<std::string::String>,
}
impl SnapshotErrorMessage {
    /// <p>A unique identifier for the snapshot returning the error.</p>
    pub fn snapshot_identifier(&self) -> std::option::Option<&str> {
        self.snapshot_identifier.as_deref()
    }
    /// <p>A unique identifier for the cluster.</p>
    pub fn snapshot_cluster_identifier(&self) -> std::option::Option<&str> {
        self.snapshot_cluster_identifier.as_deref()
    }
    /// <p>The failure code for the error.</p>
    pub fn failure_code(&self) -> std::option::Option<&str> {
        self.failure_code.as_deref()
    }
    /// <p>The text message describing the error.</p>
    pub fn failure_reason(&self) -> std::option::Option<&str> {
        self.failure_reason.as_deref()
    }
}
impl std::fmt::Debug for SnapshotErrorMessage {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SnapshotErrorMessage");
        formatter.field("snapshot_identifier", &self.snapshot_identifier);
        formatter.field(
            "snapshot_cluster_identifier",
            &self.snapshot_cluster_identifier,
        );
        formatter.field("failure_code", &self.failure_code);
        formatter.field("failure_reason", &self.failure_reason);
        formatter.finish()
    }
}
/// See [`SnapshotErrorMessage`](crate::model::SnapshotErrorMessage)
pub mod snapshot_error_message {
    /// A builder for [`SnapshotErrorMessage`](crate::model::SnapshotErrorMessage)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) snapshot_identifier: std::option::Option<std::string::String>,
        pub(crate) snapshot_cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) failure_code: std::option::Option<std::string::String>,
        pub(crate) failure_reason: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier for the snapshot returning the error.</p>
        pub fn snapshot_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.snapshot_identifier = Some(input.into());
            self
        }
        /// <p>A unique identifier for the snapshot returning the error.</p>
        pub fn set_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.snapshot_identifier = input;
            self
        }
        /// <p>A unique identifier for the cluster.</p>
        pub fn snapshot_cluster_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.snapshot_cluster_identifier = Some(input.into());
            self
        }
        /// <p>A unique identifier for the cluster.</p>
        pub fn set_snapshot_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.snapshot_cluster_identifier = input;
            self
        }
        /// <p>The failure code for the error.</p>
        pub fn failure_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.failure_code = Some(input.into());
            self
        }
        /// <p>The failure code for the error.</p>
        pub fn set_failure_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.failure_code = input;
            self
        }
        /// <p>The text message describing the error.</p>
        pub fn failure_reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.failure_reason = Some(input.into());
            self
        }
        /// <p>The text message describing the error.</p>
        pub fn set_failure_reason(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.failure_reason = input;
            self
        }
        /// Consumes the builder and constructs a [`SnapshotErrorMessage`](crate::model::SnapshotErrorMessage)
        pub fn build(self) -> crate::model::SnapshotErrorMessage {
            crate::model::SnapshotErrorMessage {
                snapshot_identifier: self.snapshot_identifier,
                snapshot_cluster_identifier: self.snapshot_cluster_identifier,
                failure_code: self.failure_code,
                failure_reason: self.failure_reason,
            }
        }
    }
}
impl SnapshotErrorMessage {
    /// Creates a new builder-style object to manufacture [`SnapshotErrorMessage`](crate::model::SnapshotErrorMessage)
    pub fn builder() -> crate::model::snapshot_error_message::Builder {
        crate::model::snapshot_error_message::Builder::default()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteClusterSnapshotMessage {
    /// <p>The unique identifier of the manual snapshot to be deleted.</p>
    /// <p>Constraints: Must be the name of an existing snapshot that is in the <code>available</code>, <code>failed</code>, or <code>cancelled</code> state.</p>
    pub snapshot_identifier: std::option::Option<std::string::String>,
    /// <p>The unique identifier of the cluster the snapshot was created from. This parameter is required if your IAM user has a policy containing a snapshot resource element that specifies anything other than * for the cluster name.</p>
    /// <p>Constraints: Must be the name of valid cluster.</p>
    pub snapshot_cluster_identifier: std::option::Option<std::string::String>,
}
impl DeleteClusterSnapshotMessage {
    /// <p>The unique identifier of the manual snapshot to be deleted.</p>
    /// <p>Constraints: Must be the name of an existing snapshot that is in the <code>available</code>, <code>failed</code>, or <code>cancelled</code> state.</p>
    pub fn snapshot_identifier(&self) -> std::option::Option<&str> {
        self.snapshot_identifier.as_deref()
    }
    /// <p>The unique identifier of the cluster the snapshot was created from. This parameter is required if your IAM user has a policy containing a snapshot resource element that specifies anything other than * for the cluster name.</p>
    /// <p>Constraints: Must be the name of valid cluster.</p>
    pub fn snapshot_cluster_identifier(&self) -> std::option::Option<&str> {
        self.snapshot_cluster_identifier.as_deref()
    }
}
impl std::fmt::Debug for DeleteClusterSnapshotMessage {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteClusterSnapshotMessage");
        formatter.field("snapshot_identifier", &self.snapshot_identifier);
        formatter.field(
            "snapshot_cluster_identifier",
            &self.snapshot_cluster_identifier,
        );
        formatter.finish()
    }
}
/// See [`DeleteClusterSnapshotMessage`](crate::model::DeleteClusterSnapshotMessage)
pub mod delete_cluster_snapshot_message {
    /// A builder for [`DeleteClusterSnapshotMessage`](crate::model::DeleteClusterSnapshotMessage)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) snapshot_identifier: std::option::Option<std::string::String>,
        pub(crate) snapshot_cluster_identifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier of the manual snapshot to be deleted.</p>
        /// <p>Constraints: Must be the name of an existing snapshot that is in the <code>available</code>, <code>failed</code>, or <code>cancelled</code> state.</p>
        pub fn snapshot_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.snapshot_identifier = Some(input.into());
            self
        }
        /// <p>The unique identifier of the manual snapshot to be deleted.</p>
        /// <p>Constraints: Must be the name of an existing snapshot that is in the <code>available</code>, <code>failed</code>, or <code>cancelled</code> state.</p>
        pub fn set_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.snapshot_identifier = input;
            self
        }
        /// <p>The unique identifier of the cluster the snapshot was created from. This parameter is required if your IAM user has a policy containing a snapshot resource element that specifies anything other than * for the cluster name.</p>
        /// <p>Constraints: Must be the name of valid cluster.</p>
        pub fn snapshot_cluster_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.snapshot_cluster_identifier = Some(input.into());
            self
        }
        /// <p>The unique identifier of the cluster the snapshot was created from. This parameter is required if your IAM user has a policy containing a snapshot resource element that specifies anything other than * for the cluster name.</p>
        /// <p>Constraints: Must be the name of valid cluster.</p>
        pub fn set_snapshot_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.snapshot_cluster_identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteClusterSnapshotMessage`](crate::model::DeleteClusterSnapshotMessage)
        pub fn build(self) -> crate::model::DeleteClusterSnapshotMessage {
            crate::model::DeleteClusterSnapshotMessage {
                snapshot_identifier: self.snapshot_identifier,
                snapshot_cluster_identifier: self.snapshot_cluster_identifier,
            }
        }
    }
}
impl DeleteClusterSnapshotMessage {
    /// Creates a new builder-style object to manufacture [`DeleteClusterSnapshotMessage`](crate::model::DeleteClusterSnapshotMessage)
    pub fn builder() -> crate::model::delete_cluster_snapshot_message::Builder {
        crate::model::delete_cluster_snapshot_message::Builder::default()
    }
}
