// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdatePartnerStatusOutput {
    /// <p>The name of the database that receives data from the partner.</p>
    pub database_name: std::option::Option<std::string::String>,
    /// <p>The name of the partner that is authorized to send data.</p>
    pub partner_name: std::option::Option<std::string::String>,
}
impl UpdatePartnerStatusOutput {
    /// <p>The name of the database that receives data from the partner.</p>
    pub fn database_name(&self) -> std::option::Option<&str> {
        self.database_name.as_deref()
    }
    /// <p>The name of the partner that is authorized to send data.</p>
    pub fn partner_name(&self) -> std::option::Option<&str> {
        self.partner_name.as_deref()
    }
}
impl std::fmt::Debug for UpdatePartnerStatusOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdatePartnerStatusOutput");
        formatter.field("database_name", &self.database_name);
        formatter.field("partner_name", &self.partner_name);
        formatter.finish()
    }
}
/// See [`UpdatePartnerStatusOutput`](crate::output::UpdatePartnerStatusOutput)
pub mod update_partner_status_output {
    /// A builder for [`UpdatePartnerStatusOutput`](crate::output::UpdatePartnerStatusOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) database_name: std::option::Option<std::string::String>,
        pub(crate) partner_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the database that receives data from the partner.</p>
        pub fn database_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.database_name = Some(input.into());
            self
        }
        /// <p>The name of the database that receives data from the partner.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.database_name = input;
            self
        }
        /// <p>The name of the partner that is authorized to send data.</p>
        pub fn partner_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.partner_name = Some(input.into());
            self
        }
        /// <p>The name of the partner that is authorized to send data.</p>
        pub fn set_partner_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.partner_name = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdatePartnerStatusOutput`](crate::output::UpdatePartnerStatusOutput)
        pub fn build(self) -> crate::output::UpdatePartnerStatusOutput {
            crate::output::UpdatePartnerStatusOutput {
                database_name: self.database_name,
                partner_name: self.partner_name,
            }
        }
    }
}
impl UpdatePartnerStatusOutput {
    /// Creates a new builder-style object to manufacture [`UpdatePartnerStatusOutput`](crate::output::UpdatePartnerStatusOutput)
    pub fn builder() -> crate::output::update_partner_status_output::Builder {
        crate::output::update_partner_status_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RotateEncryptionKeyOutput {
    /// <p>Describes a cluster.</p>
    pub cluster: std::option::Option<crate::model::Cluster>,
}
impl RotateEncryptionKeyOutput {
    /// <p>Describes a cluster.</p>
    pub fn cluster(&self) -> std::option::Option<&crate::model::Cluster> {
        self.cluster.as_ref()
    }
}
impl std::fmt::Debug for RotateEncryptionKeyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RotateEncryptionKeyOutput");
        formatter.field("cluster", &self.cluster);
        formatter.finish()
    }
}
/// See [`RotateEncryptionKeyOutput`](crate::output::RotateEncryptionKeyOutput)
pub mod rotate_encryption_key_output {
    /// A builder for [`RotateEncryptionKeyOutput`](crate::output::RotateEncryptionKeyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster: std::option::Option<crate::model::Cluster>,
    }
    impl Builder {
        /// <p>Describes a cluster.</p>
        pub fn cluster(mut self, input: crate::model::Cluster) -> Self {
            self.cluster = Some(input);
            self
        }
        /// <p>Describes a cluster.</p>
        pub fn set_cluster(mut self, input: std::option::Option<crate::model::Cluster>) -> Self {
            self.cluster = input;
            self
        }
        /// Consumes the builder and constructs a [`RotateEncryptionKeyOutput`](crate::output::RotateEncryptionKeyOutput)
        pub fn build(self) -> crate::output::RotateEncryptionKeyOutput {
            crate::output::RotateEncryptionKeyOutput {
                cluster: self.cluster,
            }
        }
    }
}
impl RotateEncryptionKeyOutput {
    /// Creates a new builder-style object to manufacture [`RotateEncryptionKeyOutput`](crate::output::RotateEncryptionKeyOutput)
    pub fn builder() -> crate::output::rotate_encryption_key_output::Builder {
        crate::output::rotate_encryption_key_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RevokeSnapshotAccessOutput {
    /// <p>Describes a snapshot.</p>
    pub snapshot: std::option::Option<crate::model::Snapshot>,
}
impl RevokeSnapshotAccessOutput {
    /// <p>Describes a snapshot.</p>
    pub fn snapshot(&self) -> std::option::Option<&crate::model::Snapshot> {
        self.snapshot.as_ref()
    }
}
impl std::fmt::Debug for RevokeSnapshotAccessOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RevokeSnapshotAccessOutput");
        formatter.field("snapshot", &self.snapshot);
        formatter.finish()
    }
}
/// See [`RevokeSnapshotAccessOutput`](crate::output::RevokeSnapshotAccessOutput)
pub mod revoke_snapshot_access_output {
    /// A builder for [`RevokeSnapshotAccessOutput`](crate::output::RevokeSnapshotAccessOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) snapshot: std::option::Option<crate::model::Snapshot>,
    }
    impl Builder {
        /// <p>Describes a snapshot.</p>
        pub fn snapshot(mut self, input: crate::model::Snapshot) -> Self {
            self.snapshot = Some(input);
            self
        }
        /// <p>Describes a snapshot.</p>
        pub fn set_snapshot(mut self, input: std::option::Option<crate::model::Snapshot>) -> Self {
            self.snapshot = input;
            self
        }
        /// Consumes the builder and constructs a [`RevokeSnapshotAccessOutput`](crate::output::RevokeSnapshotAccessOutput)
        pub fn build(self) -> crate::output::RevokeSnapshotAccessOutput {
            crate::output::RevokeSnapshotAccessOutput {
                snapshot: self.snapshot,
            }
        }
    }
}
impl RevokeSnapshotAccessOutput {
    /// Creates a new builder-style object to manufacture [`RevokeSnapshotAccessOutput`](crate::output::RevokeSnapshotAccessOutput)
    pub fn builder() -> crate::output::revoke_snapshot_access_output::Builder {
        crate::output::revoke_snapshot_access_output::Builder::default()
    }
}

/// <p>Describes an endpoint authorization for authorizing Redshift-managed VPC endpoint access to a cluster across Amazon Web Services accounts.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RevokeEndpointAccessOutput {
    /// <p>The Amazon Web Services account ID of the cluster owner.</p>
    pub grantor: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services account ID of the grantee of the cluster.</p>
    pub grantee: std::option::Option<std::string::String>,
    /// <p>The cluster identifier.</p>
    pub cluster_identifier: std::option::Option<std::string::String>,
    /// <p>The time (UTC) when the authorization was created.</p>
    pub authorize_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The status of the cluster.</p>
    pub cluster_status: std::option::Option<std::string::String>,
    /// <p>The status of the authorization action.</p>
    pub status: std::option::Option<crate::model::AuthorizationStatus>,
    /// <p>Indicates whether all VPCs in the grantee account are allowed access to the cluster.</p>
    pub allowed_all_vp_cs: bool,
    /// <p>The VPCs allowed access to the cluster.</p>
    pub allowed_vp_cs: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The number of Redshift-managed VPC endpoints created for the authorization.</p>
    pub endpoint_count: i32,
}
impl RevokeEndpointAccessOutput {
    /// <p>The Amazon Web Services account ID of the cluster owner.</p>
    pub fn grantor(&self) -> std::option::Option<&str> {
        self.grantor.as_deref()
    }
    /// <p>The Amazon Web Services account ID of the grantee of the cluster.</p>
    pub fn grantee(&self) -> std::option::Option<&str> {
        self.grantee.as_deref()
    }
    /// <p>The cluster identifier.</p>
    pub fn cluster_identifier(&self) -> std::option::Option<&str> {
        self.cluster_identifier.as_deref()
    }
    /// <p>The time (UTC) when the authorization was created.</p>
    pub fn authorize_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.authorize_time.as_ref()
    }
    /// <p>The status of the cluster.</p>
    pub fn cluster_status(&self) -> std::option::Option<&str> {
        self.cluster_status.as_deref()
    }
    /// <p>The status of the authorization action.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::AuthorizationStatus> {
        self.status.as_ref()
    }
    /// <p>Indicates whether all VPCs in the grantee account are allowed access to the cluster.</p>
    pub fn allowed_all_vp_cs(&self) -> bool {
        self.allowed_all_vp_cs
    }
    /// <p>The VPCs allowed access to the cluster.</p>
    pub fn allowed_vp_cs(&self) -> std::option::Option<&[std::string::String]> {
        self.allowed_vp_cs.as_deref()
    }
    /// <p>The number of Redshift-managed VPC endpoints created for the authorization.</p>
    pub fn endpoint_count(&self) -> i32 {
        self.endpoint_count
    }
}
impl std::fmt::Debug for RevokeEndpointAccessOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RevokeEndpointAccessOutput");
        formatter.field("grantor", &self.grantor);
        formatter.field("grantee", &self.grantee);
        formatter.field("cluster_identifier", &self.cluster_identifier);
        formatter.field("authorize_time", &self.authorize_time);
        formatter.field("cluster_status", &self.cluster_status);
        formatter.field("status", &self.status);
        formatter.field("allowed_all_vp_cs", &self.allowed_all_vp_cs);
        formatter.field("allowed_vp_cs", &self.allowed_vp_cs);
        formatter.field("endpoint_count", &self.endpoint_count);
        formatter.finish()
    }
}
/// See [`RevokeEndpointAccessOutput`](crate::output::RevokeEndpointAccessOutput)
pub mod revoke_endpoint_access_output {
    /// A builder for [`RevokeEndpointAccessOutput`](crate::output::RevokeEndpointAccessOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) grantor: std::option::Option<std::string::String>,
        pub(crate) grantee: std::option::Option<std::string::String>,
        pub(crate) cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) authorize_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) cluster_status: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::AuthorizationStatus>,
        pub(crate) allowed_all_vp_cs: std::option::Option<bool>,
        pub(crate) allowed_vp_cs: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) endpoint_count: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon Web Services account ID of the cluster owner.</p>
        pub fn grantor(mut self, input: impl Into<std::string::String>) -> Self {
            self.grantor = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID of the cluster owner.</p>
        pub fn set_grantor(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.grantor = input;
            self
        }
        /// <p>The Amazon Web Services account ID of the grantee of the cluster.</p>
        pub fn grantee(mut self, input: impl Into<std::string::String>) -> Self {
            self.grantee = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID of the grantee of the cluster.</p>
        pub fn set_grantee(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.grantee = input;
            self
        }
        /// <p>The cluster identifier.</p>
        pub fn cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_identifier = Some(input.into());
            self
        }
        /// <p>The cluster identifier.</p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cluster_identifier = input;
            self
        }
        /// <p>The time (UTC) when the authorization was created.</p>
        pub fn authorize_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.authorize_time = Some(input);
            self
        }
        /// <p>The time (UTC) when the authorization was created.</p>
        pub fn set_authorize_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.authorize_time = input;
            self
        }
        /// <p>The status of the cluster.</p>
        pub fn cluster_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_status = Some(input.into());
            self
        }
        /// <p>The status of the cluster.</p>
        pub fn set_cluster_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cluster_status = input;
            self
        }
        /// <p>The status of the authorization action.</p>
        pub fn status(mut self, input: crate::model::AuthorizationStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the authorization action.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::AuthorizationStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>Indicates whether all VPCs in the grantee account are allowed access to the cluster.</p>
        pub fn allowed_all_vp_cs(mut self, input: bool) -> Self {
            self.allowed_all_vp_cs = Some(input);
            self
        }
        /// <p>Indicates whether all VPCs in the grantee account are allowed access to the cluster.</p>
        pub fn set_allowed_all_vp_cs(mut self, input: std::option::Option<bool>) -> Self {
            self.allowed_all_vp_cs = input;
            self
        }
        /// Appends an item to `allowed_vp_cs`.
        ///
        /// To override the contents of this collection use [`set_allowed_vp_cs`](Self::set_allowed_vp_cs).
        ///
        /// <p>The VPCs allowed access to the cluster.</p>
        pub fn allowed_vp_cs(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.allowed_vp_cs.unwrap_or_default();
            v.push(input.into());
            self.allowed_vp_cs = Some(v);
            self
        }
        /// <p>The VPCs allowed access to the cluster.</p>
        pub fn set_allowed_vp_cs(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.allowed_vp_cs = input;
            self
        }
        /// <p>The number of Redshift-managed VPC endpoints created for the authorization.</p>
        pub fn endpoint_count(mut self, input: i32) -> Self {
            self.endpoint_count = Some(input);
            self
        }
        /// <p>The number of Redshift-managed VPC endpoints created for the authorization.</p>
        pub fn set_endpoint_count(mut self, input: std::option::Option<i32>) -> Self {
            self.endpoint_count = input;
            self
        }
        /// Consumes the builder and constructs a [`RevokeEndpointAccessOutput`](crate::output::RevokeEndpointAccessOutput)
        pub fn build(self) -> crate::output::RevokeEndpointAccessOutput {
            crate::output::RevokeEndpointAccessOutput {
                grantor: self.grantor,
                grantee: self.grantee,
                cluster_identifier: self.cluster_identifier,
                authorize_time: self.authorize_time,
                cluster_status: self.cluster_status,
                status: self.status,
                allowed_all_vp_cs: self.allowed_all_vp_cs.unwrap_or_default(),
                allowed_vp_cs: self.allowed_vp_cs,
                endpoint_count: self.endpoint_count.unwrap_or_default(),
            }
        }
    }
}
impl RevokeEndpointAccessOutput {
    /// Creates a new builder-style object to manufacture [`RevokeEndpointAccessOutput`](crate::output::RevokeEndpointAccessOutput)
    pub fn builder() -> crate::output::revoke_endpoint_access_output::Builder {
        crate::output::revoke_endpoint_access_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RevokeClusterSecurityGroupIngressOutput {
    /// <p>Describes a security group.</p>
    pub cluster_security_group: std::option::Option<crate::model::ClusterSecurityGroup>,
}
impl RevokeClusterSecurityGroupIngressOutput {
    /// <p>Describes a security group.</p>
    pub fn cluster_security_group(
        &self,
    ) -> std::option::Option<&crate::model::ClusterSecurityGroup> {
        self.cluster_security_group.as_ref()
    }
}
impl std::fmt::Debug for RevokeClusterSecurityGroupIngressOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RevokeClusterSecurityGroupIngressOutput");
        formatter.field("cluster_security_group", &self.cluster_security_group);
        formatter.finish()
    }
}
/// See [`RevokeClusterSecurityGroupIngressOutput`](crate::output::RevokeClusterSecurityGroupIngressOutput)
pub mod revoke_cluster_security_group_ingress_output {
    /// A builder for [`RevokeClusterSecurityGroupIngressOutput`](crate::output::RevokeClusterSecurityGroupIngressOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_security_group: std::option::Option<crate::model::ClusterSecurityGroup>,
    }
    impl Builder {
        /// <p>Describes a security group.</p>
        pub fn cluster_security_group(mut self, input: crate::model::ClusterSecurityGroup) -> Self {
            self.cluster_security_group = Some(input);
            self
        }
        /// <p>Describes a security group.</p>
        pub fn set_cluster_security_group(
            mut self,
            input: std::option::Option<crate::model::ClusterSecurityGroup>,
        ) -> Self {
            self.cluster_security_group = input;
            self
        }
        /// Consumes the builder and constructs a [`RevokeClusterSecurityGroupIngressOutput`](crate::output::RevokeClusterSecurityGroupIngressOutput)
        pub fn build(self) -> crate::output::RevokeClusterSecurityGroupIngressOutput {
            crate::output::RevokeClusterSecurityGroupIngressOutput {
                cluster_security_group: self.cluster_security_group,
            }
        }
    }
}
impl RevokeClusterSecurityGroupIngressOutput {
    /// Creates a new builder-style object to manufacture [`RevokeClusterSecurityGroupIngressOutput`](crate::output::RevokeClusterSecurityGroupIngressOutput)
    pub fn builder() -> crate::output::revoke_cluster_security_group_ingress_output::Builder {
        crate::output::revoke_cluster_security_group_ingress_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResumeClusterOutput {
    /// <p>Describes a cluster.</p>
    pub cluster: std::option::Option<crate::model::Cluster>,
}
impl ResumeClusterOutput {
    /// <p>Describes a cluster.</p>
    pub fn cluster(&self) -> std::option::Option<&crate::model::Cluster> {
        self.cluster.as_ref()
    }
}
impl std::fmt::Debug for ResumeClusterOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResumeClusterOutput");
        formatter.field("cluster", &self.cluster);
        formatter.finish()
    }
}
/// See [`ResumeClusterOutput`](crate::output::ResumeClusterOutput)
pub mod resume_cluster_output {
    /// A builder for [`ResumeClusterOutput`](crate::output::ResumeClusterOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster: std::option::Option<crate::model::Cluster>,
    }
    impl Builder {
        /// <p>Describes a cluster.</p>
        pub fn cluster(mut self, input: crate::model::Cluster) -> Self {
            self.cluster = Some(input);
            self
        }
        /// <p>Describes a cluster.</p>
        pub fn set_cluster(mut self, input: std::option::Option<crate::model::Cluster>) -> Self {
            self.cluster = input;
            self
        }
        /// Consumes the builder and constructs a [`ResumeClusterOutput`](crate::output::ResumeClusterOutput)
        pub fn build(self) -> crate::output::ResumeClusterOutput {
            crate::output::ResumeClusterOutput {
                cluster: self.cluster,
            }
        }
    }
}
impl ResumeClusterOutput {
    /// Creates a new builder-style object to manufacture [`ResumeClusterOutput`](crate::output::ResumeClusterOutput)
    pub fn builder() -> crate::output::resume_cluster_output::Builder {
        crate::output::resume_cluster_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RestoreTableFromClusterSnapshotOutput {
    /// <p>Describes the status of a <code>RestoreTableFromClusterSnapshot</code> operation.</p>
    pub table_restore_status: std::option::Option<crate::model::TableRestoreStatus>,
}
impl RestoreTableFromClusterSnapshotOutput {
    /// <p>Describes the status of a <code>RestoreTableFromClusterSnapshot</code> operation.</p>
    pub fn table_restore_status(&self) -> std::option::Option<&crate::model::TableRestoreStatus> {
        self.table_restore_status.as_ref()
    }
}
impl std::fmt::Debug for RestoreTableFromClusterSnapshotOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RestoreTableFromClusterSnapshotOutput");
        formatter.field("table_restore_status", &self.table_restore_status);
        formatter.finish()
    }
}
/// See [`RestoreTableFromClusterSnapshotOutput`](crate::output::RestoreTableFromClusterSnapshotOutput)
pub mod restore_table_from_cluster_snapshot_output {
    /// A builder for [`RestoreTableFromClusterSnapshotOutput`](crate::output::RestoreTableFromClusterSnapshotOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) table_restore_status: std::option::Option<crate::model::TableRestoreStatus>,
    }
    impl Builder {
        /// <p>Describes the status of a <code>RestoreTableFromClusterSnapshot</code> operation.</p>
        pub fn table_restore_status(mut self, input: crate::model::TableRestoreStatus) -> Self {
            self.table_restore_status = Some(input);
            self
        }
        /// <p>Describes the status of a <code>RestoreTableFromClusterSnapshot</code> operation.</p>
        pub fn set_table_restore_status(
            mut self,
            input: std::option::Option<crate::model::TableRestoreStatus>,
        ) -> Self {
            self.table_restore_status = input;
            self
        }
        /// Consumes the builder and constructs a [`RestoreTableFromClusterSnapshotOutput`](crate::output::RestoreTableFromClusterSnapshotOutput)
        pub fn build(self) -> crate::output::RestoreTableFromClusterSnapshotOutput {
            crate::output::RestoreTableFromClusterSnapshotOutput {
                table_restore_status: self.table_restore_status,
            }
        }
    }
}
impl RestoreTableFromClusterSnapshotOutput {
    /// Creates a new builder-style object to manufacture [`RestoreTableFromClusterSnapshotOutput`](crate::output::RestoreTableFromClusterSnapshotOutput)
    pub fn builder() -> crate::output::restore_table_from_cluster_snapshot_output::Builder {
        crate::output::restore_table_from_cluster_snapshot_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RestoreFromClusterSnapshotOutput {
    /// <p>Describes a cluster.</p>
    pub cluster: std::option::Option<crate::model::Cluster>,
}
impl RestoreFromClusterSnapshotOutput {
    /// <p>Describes a cluster.</p>
    pub fn cluster(&self) -> std::option::Option<&crate::model::Cluster> {
        self.cluster.as_ref()
    }
}
impl std::fmt::Debug for RestoreFromClusterSnapshotOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RestoreFromClusterSnapshotOutput");
        formatter.field("cluster", &self.cluster);
        formatter.finish()
    }
}
/// See [`RestoreFromClusterSnapshotOutput`](crate::output::RestoreFromClusterSnapshotOutput)
pub mod restore_from_cluster_snapshot_output {
    /// A builder for [`RestoreFromClusterSnapshotOutput`](crate::output::RestoreFromClusterSnapshotOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster: std::option::Option<crate::model::Cluster>,
    }
    impl Builder {
        /// <p>Describes a cluster.</p>
        pub fn cluster(mut self, input: crate::model::Cluster) -> Self {
            self.cluster = Some(input);
            self
        }
        /// <p>Describes a cluster.</p>
        pub fn set_cluster(mut self, input: std::option::Option<crate::model::Cluster>) -> Self {
            self.cluster = input;
            self
        }
        /// Consumes the builder and constructs a [`RestoreFromClusterSnapshotOutput`](crate::output::RestoreFromClusterSnapshotOutput)
        pub fn build(self) -> crate::output::RestoreFromClusterSnapshotOutput {
            crate::output::RestoreFromClusterSnapshotOutput {
                cluster: self.cluster,
            }
        }
    }
}
impl RestoreFromClusterSnapshotOutput {
    /// Creates a new builder-style object to manufacture [`RestoreFromClusterSnapshotOutput`](crate::output::RestoreFromClusterSnapshotOutput)
    pub fn builder() -> crate::output::restore_from_cluster_snapshot_output::Builder {
        crate::output::restore_from_cluster_snapshot_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResizeClusterOutput {
    /// <p>Describes a cluster.</p>
    pub cluster: std::option::Option<crate::model::Cluster>,
}
impl ResizeClusterOutput {
    /// <p>Describes a cluster.</p>
    pub fn cluster(&self) -> std::option::Option<&crate::model::Cluster> {
        self.cluster.as_ref()
    }
}
impl std::fmt::Debug for ResizeClusterOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResizeClusterOutput");
        formatter.field("cluster", &self.cluster);
        formatter.finish()
    }
}
/// See [`ResizeClusterOutput`](crate::output::ResizeClusterOutput)
pub mod resize_cluster_output {
    /// A builder for [`ResizeClusterOutput`](crate::output::ResizeClusterOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster: std::option::Option<crate::model::Cluster>,
    }
    impl Builder {
        /// <p>Describes a cluster.</p>
        pub fn cluster(mut self, input: crate::model::Cluster) -> Self {
            self.cluster = Some(input);
            self
        }
        /// <p>Describes a cluster.</p>
        pub fn set_cluster(mut self, input: std::option::Option<crate::model::Cluster>) -> Self {
            self.cluster = input;
            self
        }
        /// Consumes the builder and constructs a [`ResizeClusterOutput`](crate::output::ResizeClusterOutput)
        pub fn build(self) -> crate::output::ResizeClusterOutput {
            crate::output::ResizeClusterOutput {
                cluster: self.cluster,
            }
        }
    }
}
impl ResizeClusterOutput {
    /// Creates a new builder-style object to manufacture [`ResizeClusterOutput`](crate::output::ResizeClusterOutput)
    pub fn builder() -> crate::output::resize_cluster_output::Builder {
        crate::output::resize_cluster_output::Builder::default()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResetClusterParameterGroupOutput {
    /// <p>The name of the cluster parameter group.</p>
    pub parameter_group_name: std::option::Option<std::string::String>,
    /// <p>The status of the parameter group. For example, if you made a change to a parameter group name-value pair, then the change could be pending a reboot of an associated cluster.</p>
    pub parameter_group_status: std::option::Option<std::string::String>,
}
impl ResetClusterParameterGroupOutput {
    /// <p>The name of the cluster parameter group.</p>
    pub fn parameter_group_name(&self) -> std::option::Option<&str> {
        self.parameter_group_name.as_deref()
    }
    /// <p>The status of the parameter group. For example, if you made a change to a parameter group name-value pair, then the change could be pending a reboot of an associated cluster.</p>
    pub fn parameter_group_status(&self) -> std::option::Option<&str> {
        self.parameter_group_status.as_deref()
    }
}
impl std::fmt::Debug for ResetClusterParameterGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResetClusterParameterGroupOutput");
        formatter.field("parameter_group_name", &self.parameter_group_name);
        formatter.field("parameter_group_status", &self.parameter_group_status);
        formatter.finish()
    }
}
/// See [`ResetClusterParameterGroupOutput`](crate::output::ResetClusterParameterGroupOutput)
pub mod reset_cluster_parameter_group_output {
    /// A builder for [`ResetClusterParameterGroupOutput`](crate::output::ResetClusterParameterGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) parameter_group_name: std::option::Option<std::string::String>,
        pub(crate) parameter_group_status: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the cluster parameter group.</p>
        pub fn parameter_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.parameter_group_name = Some(input.into());
            self
        }
        /// <p>The name of the cluster parameter group.</p>
        pub fn set_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parameter_group_name = input;
            self
        }
        /// <p>The status of the parameter group. For example, if you made a change to a parameter group name-value pair, then the change could be pending a reboot of an associated cluster.</p>
        pub fn parameter_group_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.parameter_group_status = Some(input.into());
            self
        }
        /// <p>The status of the parameter group. For example, if you made a change to a parameter group name-value pair, then the change could be pending a reboot of an associated cluster.</p>
        pub fn set_parameter_group_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parameter_group_status = input;
            self
        }
        /// Consumes the builder and constructs a [`ResetClusterParameterGroupOutput`](crate::output::ResetClusterParameterGroupOutput)
        pub fn build(self) -> crate::output::ResetClusterParameterGroupOutput {
            crate::output::ResetClusterParameterGroupOutput {
                parameter_group_name: self.parameter_group_name,
                parameter_group_status: self.parameter_group_status,
            }
        }
    }
}
impl ResetClusterParameterGroupOutput {
    /// Creates a new builder-style object to manufacture [`ResetClusterParameterGroupOutput`](crate::output::ResetClusterParameterGroupOutput)
    pub fn builder() -> crate::output::reset_cluster_parameter_group_output::Builder {
        crate::output::reset_cluster_parameter_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RejectDataShareOutput {
    /// <p>An Amazon Resource Name (ARN) that references the datashare that is owned by a specific namespace of the producer cluster. A datashare ARN is in the <code>arn:aws:redshift:{region}:{account-id}:{datashare}:{namespace-guid}/{datashare-name}</code> format.</p>
    pub data_share_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the producer.</p>
    pub producer_arn: std::option::Option<std::string::String>,
    /// <p>A value that specifies whether the datashare can be shared to a publicly accessible cluster.</p>
    pub allow_publicly_accessible_consumers: bool,
    /// <p>A value that specifies when the datashare has an association between a producer and data consumers.</p>
    pub data_share_associations:
        std::option::Option<std::vec::Vec<crate::model::DataShareAssociation>>,
    /// <p>The identifier of a datashare to show its managing entity.</p>
    pub managed_by: std::option::Option<std::string::String>,
}
impl RejectDataShareOutput {
    /// <p>An Amazon Resource Name (ARN) that references the datashare that is owned by a specific namespace of the producer cluster. A datashare ARN is in the <code>arn:aws:redshift:{region}:{account-id}:{datashare}:{namespace-guid}/{datashare-name}</code> format.</p>
    pub fn data_share_arn(&self) -> std::option::Option<&str> {
        self.data_share_arn.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the producer.</p>
    pub fn producer_arn(&self) -> std::option::Option<&str> {
        self.producer_arn.as_deref()
    }
    /// <p>A value that specifies whether the datashare can be shared to a publicly accessible cluster.</p>
    pub fn allow_publicly_accessible_consumers(&self) -> bool {
        self.allow_publicly_accessible_consumers
    }
    /// <p>A value that specifies when the datashare has an association between a producer and data consumers.</p>
    pub fn data_share_associations(
        &self,
    ) -> std::option::Option<&[crate::model::DataShareAssociation]> {
        self.data_share_associations.as_deref()
    }
    /// <p>The identifier of a datashare to show its managing entity.</p>
    pub fn managed_by(&self) -> std::option::Option<&str> {
        self.managed_by.as_deref()
    }
}
impl std::fmt::Debug for RejectDataShareOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RejectDataShareOutput");
        formatter.field("data_share_arn", &self.data_share_arn);
        formatter.field("producer_arn", &self.producer_arn);
        formatter.field(
            "allow_publicly_accessible_consumers",
            &self.allow_publicly_accessible_consumers,
        );
        formatter.field("data_share_associations", &self.data_share_associations);
        formatter.field("managed_by", &self.managed_by);
        formatter.finish()
    }
}
/// See [`RejectDataShareOutput`](crate::output::RejectDataShareOutput)
pub mod reject_data_share_output {
    /// A builder for [`RejectDataShareOutput`](crate::output::RejectDataShareOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data_share_arn: std::option::Option<std::string::String>,
        pub(crate) producer_arn: std::option::Option<std::string::String>,
        pub(crate) allow_publicly_accessible_consumers: std::option::Option<bool>,
        pub(crate) data_share_associations:
            std::option::Option<std::vec::Vec<crate::model::DataShareAssociation>>,
        pub(crate) managed_by: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>An Amazon Resource Name (ARN) that references the datashare that is owned by a specific namespace of the producer cluster. A datashare ARN is in the <code>arn:aws:redshift:{region}:{account-id}:{datashare}:{namespace-guid}/{datashare-name}</code> format.</p>
        pub fn data_share_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_share_arn = Some(input.into());
            self
        }
        /// <p>An Amazon Resource Name (ARN) that references the datashare that is owned by a specific namespace of the producer cluster. A datashare ARN is in the <code>arn:aws:redshift:{region}:{account-id}:{datashare}:{namespace-guid}/{datashare-name}</code> format.</p>
        pub fn set_data_share_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_share_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the producer.</p>
        pub fn producer_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.producer_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the producer.</p>
        pub fn set_producer_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.producer_arn = input;
            self
        }
        /// <p>A value that specifies whether the datashare can be shared to a publicly accessible cluster.</p>
        pub fn allow_publicly_accessible_consumers(mut self, input: bool) -> Self {
            self.allow_publicly_accessible_consumers = Some(input);
            self
        }
        /// <p>A value that specifies whether the datashare can be shared to a publicly accessible cluster.</p>
        pub fn set_allow_publicly_accessible_consumers(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.allow_publicly_accessible_consumers = input;
            self
        }
        /// Appends an item to `data_share_associations`.
        ///
        /// To override the contents of this collection use [`set_data_share_associations`](Self::set_data_share_associations).
        ///
        /// <p>A value that specifies when the datashare has an association between a producer and data consumers.</p>
        pub fn data_share_associations(
            mut self,
            input: crate::model::DataShareAssociation,
        ) -> Self {
            let mut v = self.data_share_associations.unwrap_or_default();
            v.push(input);
            self.data_share_associations = Some(v);
            self
        }
        /// <p>A value that specifies when the datashare has an association between a producer and data consumers.</p>
        pub fn set_data_share_associations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DataShareAssociation>>,
        ) -> Self {
            self.data_share_associations = input;
            self
        }
        /// <p>The identifier of a datashare to show its managing entity.</p>
        pub fn managed_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.managed_by = Some(input.into());
            self
        }
        /// <p>The identifier of a datashare to show its managing entity.</p>
        pub fn set_managed_by(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.managed_by = input;
            self
        }
        /// Consumes the builder and constructs a [`RejectDataShareOutput`](crate::output::RejectDataShareOutput)
        pub fn build(self) -> crate::output::RejectDataShareOutput {
            crate::output::RejectDataShareOutput {
                data_share_arn: self.data_share_arn,
                producer_arn: self.producer_arn,
                allow_publicly_accessible_consumers: self
                    .allow_publicly_accessible_consumers
                    .unwrap_or_default(),
                data_share_associations: self.data_share_associations,
                managed_by: self.managed_by,
            }
        }
    }
}
impl RejectDataShareOutput {
    /// Creates a new builder-style object to manufacture [`RejectDataShareOutput`](crate::output::RejectDataShareOutput)
    pub fn builder() -> crate::output::reject_data_share_output::Builder {
        crate::output::reject_data_share_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RebootClusterOutput {
    /// <p>Describes a cluster.</p>
    pub cluster: std::option::Option<crate::model::Cluster>,
}
impl RebootClusterOutput {
    /// <p>Describes a cluster.</p>
    pub fn cluster(&self) -> std::option::Option<&crate::model::Cluster> {
        self.cluster.as_ref()
    }
}
impl std::fmt::Debug for RebootClusterOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RebootClusterOutput");
        formatter.field("cluster", &self.cluster);
        formatter.finish()
    }
}
/// See [`RebootClusterOutput`](crate::output::RebootClusterOutput)
pub mod reboot_cluster_output {
    /// A builder for [`RebootClusterOutput`](crate::output::RebootClusterOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster: std::option::Option<crate::model::Cluster>,
    }
    impl Builder {
        /// <p>Describes a cluster.</p>
        pub fn cluster(mut self, input: crate::model::Cluster) -> Self {
            self.cluster = Some(input);
            self
        }
        /// <p>Describes a cluster.</p>
        pub fn set_cluster(mut self, input: std::option::Option<crate::model::Cluster>) -> Self {
            self.cluster = input;
            self
        }
        /// Consumes the builder and constructs a [`RebootClusterOutput`](crate::output::RebootClusterOutput)
        pub fn build(self) -> crate::output::RebootClusterOutput {
            crate::output::RebootClusterOutput {
                cluster: self.cluster,
            }
        }
    }
}
impl RebootClusterOutput {
    /// Creates a new builder-style object to manufacture [`RebootClusterOutput`](crate::output::RebootClusterOutput)
    pub fn builder() -> crate::output::reboot_cluster_output::Builder {
        crate::output::reboot_cluster_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PurchaseReservedNodeOfferingOutput {
    /// <p>Describes a reserved node. You can call the <code>DescribeReservedNodeOfferings</code> API to obtain the available reserved node offerings. </p>
    pub reserved_node: std::option::Option<crate::model::ReservedNode>,
}
impl PurchaseReservedNodeOfferingOutput {
    /// <p>Describes a reserved node. You can call the <code>DescribeReservedNodeOfferings</code> API to obtain the available reserved node offerings. </p>
    pub fn reserved_node(&self) -> std::option::Option<&crate::model::ReservedNode> {
        self.reserved_node.as_ref()
    }
}
impl std::fmt::Debug for PurchaseReservedNodeOfferingOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PurchaseReservedNodeOfferingOutput");
        formatter.field("reserved_node", &self.reserved_node);
        formatter.finish()
    }
}
/// See [`PurchaseReservedNodeOfferingOutput`](crate::output::PurchaseReservedNodeOfferingOutput)
pub mod purchase_reserved_node_offering_output {
    /// A builder for [`PurchaseReservedNodeOfferingOutput`](crate::output::PurchaseReservedNodeOfferingOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) reserved_node: std::option::Option<crate::model::ReservedNode>,
    }
    impl Builder {
        /// <p>Describes a reserved node. You can call the <code>DescribeReservedNodeOfferings</code> API to obtain the available reserved node offerings. </p>
        pub fn reserved_node(mut self, input: crate::model::ReservedNode) -> Self {
            self.reserved_node = Some(input);
            self
        }
        /// <p>Describes a reserved node. You can call the <code>DescribeReservedNodeOfferings</code> API to obtain the available reserved node offerings. </p>
        pub fn set_reserved_node(
            mut self,
            input: std::option::Option<crate::model::ReservedNode>,
        ) -> Self {
            self.reserved_node = input;
            self
        }
        /// Consumes the builder and constructs a [`PurchaseReservedNodeOfferingOutput`](crate::output::PurchaseReservedNodeOfferingOutput)
        pub fn build(self) -> crate::output::PurchaseReservedNodeOfferingOutput {
            crate::output::PurchaseReservedNodeOfferingOutput {
                reserved_node: self.reserved_node,
            }
        }
    }
}
impl PurchaseReservedNodeOfferingOutput {
    /// Creates a new builder-style object to manufacture [`PurchaseReservedNodeOfferingOutput`](crate::output::PurchaseReservedNodeOfferingOutput)
    pub fn builder() -> crate::output::purchase_reserved_node_offering_output::Builder {
        crate::output::purchase_reserved_node_offering_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PauseClusterOutput {
    /// <p>Describes a cluster.</p>
    pub cluster: std::option::Option<crate::model::Cluster>,
}
impl PauseClusterOutput {
    /// <p>Describes a cluster.</p>
    pub fn cluster(&self) -> std::option::Option<&crate::model::Cluster> {
        self.cluster.as_ref()
    }
}
impl std::fmt::Debug for PauseClusterOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PauseClusterOutput");
        formatter.field("cluster", &self.cluster);
        formatter.finish()
    }
}
/// See [`PauseClusterOutput`](crate::output::PauseClusterOutput)
pub mod pause_cluster_output {
    /// A builder for [`PauseClusterOutput`](crate::output::PauseClusterOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster: std::option::Option<crate::model::Cluster>,
    }
    impl Builder {
        /// <p>Describes a cluster.</p>
        pub fn cluster(mut self, input: crate::model::Cluster) -> Self {
            self.cluster = Some(input);
            self
        }
        /// <p>Describes a cluster.</p>
        pub fn set_cluster(mut self, input: std::option::Option<crate::model::Cluster>) -> Self {
            self.cluster = input;
            self
        }
        /// Consumes the builder and constructs a [`PauseClusterOutput`](crate::output::PauseClusterOutput)
        pub fn build(self) -> crate::output::PauseClusterOutput {
            crate::output::PauseClusterOutput {
                cluster: self.cluster,
            }
        }
    }
}
impl PauseClusterOutput {
    /// Creates a new builder-style object to manufacture [`PauseClusterOutput`](crate::output::PauseClusterOutput)
    pub fn builder() -> crate::output::pause_cluster_output::Builder {
        crate::output::pause_cluster_output::Builder::default()
    }
}

/// <p>Describes a usage limit object for a cluster. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModifyUsageLimitOutput {
    /// <p>The identifier of the usage limit.</p>
    pub usage_limit_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the cluster with a usage limit.</p>
    pub cluster_identifier: std::option::Option<std::string::String>,
    /// <p>The Amazon Redshift feature to which the limit applies.</p>
    pub feature_type: std::option::Option<crate::model::UsageLimitFeatureType>,
    /// <p>The type of limit. Depending on the feature type, this can be based on a time duration or data size.</p>
    pub limit_type: std::option::Option<crate::model::UsageLimitLimitType>,
    /// <p>The limit amount. If time-based, this amount is in minutes. If data-based, this amount is in terabytes (TB).</p>
    pub amount: i64,
    /// <p>The time period that the amount applies to. A <code>weekly</code> period begins on Sunday. The default is <code>monthly</code>. </p>
    pub period: std::option::Option<crate::model::UsageLimitPeriod>,
    /// <p>The action that Amazon Redshift takes when the limit is reached. Possible values are: </p>
    /// <ul>
    /// <li> <p> <b>log</b> - To log an event in a system table. The default is log.</p> </li>
    /// <li> <p> <b>emit-metric</b> - To emit CloudWatch metrics.</p> </li>
    /// <li> <p> <b>disable</b> - To disable the feature until the next usage period begins.</p> </li>
    /// </ul>
    pub breach_action: std::option::Option<crate::model::UsageLimitBreachAction>,
    /// <p>A list of tag instances.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl ModifyUsageLimitOutput {
    /// <p>The identifier of the usage limit.</p>
    pub fn usage_limit_id(&self) -> std::option::Option<&str> {
        self.usage_limit_id.as_deref()
    }
    /// <p>The identifier of the cluster with a usage limit.</p>
    pub fn cluster_identifier(&self) -> std::option::Option<&str> {
        self.cluster_identifier.as_deref()
    }
    /// <p>The Amazon Redshift feature to which the limit applies.</p>
    pub fn feature_type(&self) -> std::option::Option<&crate::model::UsageLimitFeatureType> {
        self.feature_type.as_ref()
    }
    /// <p>The type of limit. Depending on the feature type, this can be based on a time duration or data size.</p>
    pub fn limit_type(&self) -> std::option::Option<&crate::model::UsageLimitLimitType> {
        self.limit_type.as_ref()
    }
    /// <p>The limit amount. If time-based, this amount is in minutes. If data-based, this amount is in terabytes (TB).</p>
    pub fn amount(&self) -> i64 {
        self.amount
    }
    /// <p>The time period that the amount applies to. A <code>weekly</code> period begins on Sunday. The default is <code>monthly</code>. </p>
    pub fn period(&self) -> std::option::Option<&crate::model::UsageLimitPeriod> {
        self.period.as_ref()
    }
    /// <p>The action that Amazon Redshift takes when the limit is reached. Possible values are: </p>
    /// <ul>
    /// <li> <p> <b>log</b> - To log an event in a system table. The default is log.</p> </li>
    /// <li> <p> <b>emit-metric</b> - To emit CloudWatch metrics.</p> </li>
    /// <li> <p> <b>disable</b> - To disable the feature until the next usage period begins.</p> </li>
    /// </ul>
    pub fn breach_action(&self) -> std::option::Option<&crate::model::UsageLimitBreachAction> {
        self.breach_action.as_ref()
    }
    /// <p>A list of tag instances.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for ModifyUsageLimitOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModifyUsageLimitOutput");
        formatter.field("usage_limit_id", &self.usage_limit_id);
        formatter.field("cluster_identifier", &self.cluster_identifier);
        formatter.field("feature_type", &self.feature_type);
        formatter.field("limit_type", &self.limit_type);
        formatter.field("amount", &self.amount);
        formatter.field("period", &self.period);
        formatter.field("breach_action", &self.breach_action);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ModifyUsageLimitOutput`](crate::output::ModifyUsageLimitOutput)
pub mod modify_usage_limit_output {
    /// A builder for [`ModifyUsageLimitOutput`](crate::output::ModifyUsageLimitOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) usage_limit_id: std::option::Option<std::string::String>,
        pub(crate) cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) feature_type: std::option::Option<crate::model::UsageLimitFeatureType>,
        pub(crate) limit_type: std::option::Option<crate::model::UsageLimitLimitType>,
        pub(crate) amount: std::option::Option<i64>,
        pub(crate) period: std::option::Option<crate::model::UsageLimitPeriod>,
        pub(crate) breach_action: std::option::Option<crate::model::UsageLimitBreachAction>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The identifier of the usage limit.</p>
        pub fn usage_limit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.usage_limit_id = Some(input.into());
            self
        }
        /// <p>The identifier of the usage limit.</p>
        pub fn set_usage_limit_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.usage_limit_id = input;
            self
        }
        /// <p>The identifier of the cluster with a usage limit.</p>
        pub fn cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_identifier = Some(input.into());
            self
        }
        /// <p>The identifier of the cluster with a usage limit.</p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cluster_identifier = input;
            self
        }
        /// <p>The Amazon Redshift feature to which the limit applies.</p>
        pub fn feature_type(mut self, input: crate::model::UsageLimitFeatureType) -> Self {
            self.feature_type = Some(input);
            self
        }
        /// <p>The Amazon Redshift feature to which the limit applies.</p>
        pub fn set_feature_type(
            mut self,
            input: std::option::Option<crate::model::UsageLimitFeatureType>,
        ) -> Self {
            self.feature_type = input;
            self
        }
        /// <p>The type of limit. Depending on the feature type, this can be based on a time duration or data size.</p>
        pub fn limit_type(mut self, input: crate::model::UsageLimitLimitType) -> Self {
            self.limit_type = Some(input);
            self
        }
        /// <p>The type of limit. Depending on the feature type, this can be based on a time duration or data size.</p>
        pub fn set_limit_type(
            mut self,
            input: std::option::Option<crate::model::UsageLimitLimitType>,
        ) -> Self {
            self.limit_type = input;
            self
        }
        /// <p>The limit amount. If time-based, this amount is in minutes. If data-based, this amount is in terabytes (TB).</p>
        pub fn amount(mut self, input: i64) -> Self {
            self.amount = Some(input);
            self
        }
        /// <p>The limit amount. If time-based, this amount is in minutes. If data-based, this amount is in terabytes (TB).</p>
        pub fn set_amount(mut self, input: std::option::Option<i64>) -> Self {
            self.amount = input;
            self
        }
        /// <p>The time period that the amount applies to. A <code>weekly</code> period begins on Sunday. The default is <code>monthly</code>. </p>
        pub fn period(mut self, input: crate::model::UsageLimitPeriod) -> Self {
            self.period = Some(input);
            self
        }
        /// <p>The time period that the amount applies to. A <code>weekly</code> period begins on Sunday. The default is <code>monthly</code>. </p>
        pub fn set_period(
            mut self,
            input: std::option::Option<crate::model::UsageLimitPeriod>,
        ) -> Self {
            self.period = input;
            self
        }
        /// <p>The action that Amazon Redshift takes when the limit is reached. Possible values are: </p>
        /// <ul>
        /// <li> <p> <b>log</b> - To log an event in a system table. The default is log.</p> </li>
        /// <li> <p> <b>emit-metric</b> - To emit CloudWatch metrics.</p> </li>
        /// <li> <p> <b>disable</b> - To disable the feature until the next usage period begins.</p> </li>
        /// </ul>
        pub fn breach_action(mut self, input: crate::model::UsageLimitBreachAction) -> Self {
            self.breach_action = Some(input);
            self
        }
        /// <p>The action that Amazon Redshift takes when the limit is reached. Possible values are: </p>
        /// <ul>
        /// <li> <p> <b>log</b> - To log an event in a system table. The default is log.</p> </li>
        /// <li> <p> <b>emit-metric</b> - To emit CloudWatch metrics.</p> </li>
        /// <li> <p> <b>disable</b> - To disable the feature until the next usage period begins.</p> </li>
        /// </ul>
        pub fn set_breach_action(
            mut self,
            input: std::option::Option<crate::model::UsageLimitBreachAction>,
        ) -> Self {
            self.breach_action = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tag instances.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>A list of tag instances.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyUsageLimitOutput`](crate::output::ModifyUsageLimitOutput)
        pub fn build(self) -> crate::output::ModifyUsageLimitOutput {
            crate::output::ModifyUsageLimitOutput {
                usage_limit_id: self.usage_limit_id,
                cluster_identifier: self.cluster_identifier,
                feature_type: self.feature_type,
                limit_type: self.limit_type,
                amount: self.amount.unwrap_or_default(),
                period: self.period,
                breach_action: self.breach_action,
                tags: self.tags,
            }
        }
    }
}
impl ModifyUsageLimitOutput {
    /// Creates a new builder-style object to manufacture [`ModifyUsageLimitOutput`](crate::output::ModifyUsageLimitOutput)
    pub fn builder() -> crate::output::modify_usage_limit_output::Builder {
        crate::output::modify_usage_limit_output::Builder::default()
    }
}

/// <p>Describes a snapshot schedule. You can set a regular interval for creating snapshots of a cluster. You can also schedule snapshots for specific dates. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModifySnapshotScheduleOutput {
    /// <p>A list of ScheduleDefinitions.</p>
    pub schedule_definitions: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A unique identifier for the schedule.</p>
    pub schedule_identifier: std::option::Option<std::string::String>,
    /// <p>The description of the schedule.</p>
    pub schedule_description: std::option::Option<std::string::String>,
    /// <p>An optional set of tags describing the schedule.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p></p>
    pub next_invocations: std::option::Option<std::vec::Vec<aws_smithy_types::DateTime>>,
    /// <p>The number of clusters associated with the schedule.</p>
    pub associated_cluster_count: std::option::Option<i32>,
    /// <p>A list of clusters associated with the schedule. A maximum of 100 clusters is returned.</p>
    pub associated_clusters:
        std::option::Option<std::vec::Vec<crate::model::ClusterAssociatedToSchedule>>,
}
impl ModifySnapshotScheduleOutput {
    /// <p>A list of ScheduleDefinitions.</p>
    pub fn schedule_definitions(&self) -> std::option::Option<&[std::string::String]> {
        self.schedule_definitions.as_deref()
    }
    /// <p>A unique identifier for the schedule.</p>
    pub fn schedule_identifier(&self) -> std::option::Option<&str> {
        self.schedule_identifier.as_deref()
    }
    /// <p>The description of the schedule.</p>
    pub fn schedule_description(&self) -> std::option::Option<&str> {
        self.schedule_description.as_deref()
    }
    /// <p>An optional set of tags describing the schedule.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p></p>
    pub fn next_invocations(&self) -> std::option::Option<&[aws_smithy_types::DateTime]> {
        self.next_invocations.as_deref()
    }
    /// <p>The number of clusters associated with the schedule.</p>
    pub fn associated_cluster_count(&self) -> std::option::Option<i32> {
        self.associated_cluster_count
    }
    /// <p>A list of clusters associated with the schedule. A maximum of 100 clusters is returned.</p>
    pub fn associated_clusters(
        &self,
    ) -> std::option::Option<&[crate::model::ClusterAssociatedToSchedule]> {
        self.associated_clusters.as_deref()
    }
}
impl std::fmt::Debug for ModifySnapshotScheduleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModifySnapshotScheduleOutput");
        formatter.field("schedule_definitions", &self.schedule_definitions);
        formatter.field("schedule_identifier", &self.schedule_identifier);
        formatter.field("schedule_description", &self.schedule_description);
        formatter.field("tags", &self.tags);
        formatter.field("next_invocations", &self.next_invocations);
        formatter.field("associated_cluster_count", &self.associated_cluster_count);
        formatter.field("associated_clusters", &self.associated_clusters);
        formatter.finish()
    }
}
/// See [`ModifySnapshotScheduleOutput`](crate::output::ModifySnapshotScheduleOutput)
pub mod modify_snapshot_schedule_output {
    /// A builder for [`ModifySnapshotScheduleOutput`](crate::output::ModifySnapshotScheduleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) schedule_definitions: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) schedule_identifier: std::option::Option<std::string::String>,
        pub(crate) schedule_description: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) next_invocations: std::option::Option<std::vec::Vec<aws_smithy_types::DateTime>>,
        pub(crate) associated_cluster_count: std::option::Option<i32>,
        pub(crate) associated_clusters:
            std::option::Option<std::vec::Vec<crate::model::ClusterAssociatedToSchedule>>,
    }
    impl Builder {
        /// Appends an item to `schedule_definitions`.
        ///
        /// To override the contents of this collection use [`set_schedule_definitions`](Self::set_schedule_definitions).
        ///
        /// <p>A list of ScheduleDefinitions.</p>
        pub fn schedule_definitions(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.schedule_definitions.unwrap_or_default();
            v.push(input.into());
            self.schedule_definitions = Some(v);
            self
        }
        /// <p>A list of ScheduleDefinitions.</p>
        pub fn set_schedule_definitions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.schedule_definitions = input;
            self
        }
        /// <p>A unique identifier for the schedule.</p>
        pub fn schedule_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.schedule_identifier = Some(input.into());
            self
        }
        /// <p>A unique identifier for the schedule.</p>
        pub fn set_schedule_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.schedule_identifier = input;
            self
        }
        /// <p>The description of the schedule.</p>
        pub fn schedule_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.schedule_description = Some(input.into());
            self
        }
        /// <p>The description of the schedule.</p>
        pub fn set_schedule_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.schedule_description = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An optional set of tags describing the schedule.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>An optional set of tags describing the schedule.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Appends an item to `next_invocations`.
        ///
        /// To override the contents of this collection use [`set_next_invocations`](Self::set_next_invocations).
        ///
        /// <p></p>
        pub fn next_invocations(mut self, input: aws_smithy_types::DateTime) -> Self {
            let mut v = self.next_invocations.unwrap_or_default();
            v.push(input);
            self.next_invocations = Some(v);
            self
        }
        /// <p></p>
        pub fn set_next_invocations(
            mut self,
            input: std::option::Option<std::vec::Vec<aws_smithy_types::DateTime>>,
        ) -> Self {
            self.next_invocations = input;
            self
        }
        /// <p>The number of clusters associated with the schedule.</p>
        pub fn associated_cluster_count(mut self, input: i32) -> Self {
            self.associated_cluster_count = Some(input);
            self
        }
        /// <p>The number of clusters associated with the schedule.</p>
        pub fn set_associated_cluster_count(mut self, input: std::option::Option<i32>) -> Self {
            self.associated_cluster_count = input;
            self
        }
        /// Appends an item to `associated_clusters`.
        ///
        /// To override the contents of this collection use [`set_associated_clusters`](Self::set_associated_clusters).
        ///
        /// <p>A list of clusters associated with the schedule. A maximum of 100 clusters is returned.</p>
        pub fn associated_clusters(
            mut self,
            input: crate::model::ClusterAssociatedToSchedule,
        ) -> Self {
            let mut v = self.associated_clusters.unwrap_or_default();
            v.push(input);
            self.associated_clusters = Some(v);
            self
        }
        /// <p>A list of clusters associated with the schedule. A maximum of 100 clusters is returned.</p>
        pub fn set_associated_clusters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ClusterAssociatedToSchedule>>,
        ) -> Self {
            self.associated_clusters = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifySnapshotScheduleOutput`](crate::output::ModifySnapshotScheduleOutput)
        pub fn build(self) -> crate::output::ModifySnapshotScheduleOutput {
            crate::output::ModifySnapshotScheduleOutput {
                schedule_definitions: self.schedule_definitions,
                schedule_identifier: self.schedule_identifier,
                schedule_description: self.schedule_description,
                tags: self.tags,
                next_invocations: self.next_invocations,
                associated_cluster_count: self.associated_cluster_count,
                associated_clusters: self.associated_clusters,
            }
        }
    }
}
impl ModifySnapshotScheduleOutput {
    /// Creates a new builder-style object to manufacture [`ModifySnapshotScheduleOutput`](crate::output::ModifySnapshotScheduleOutput)
    pub fn builder() -> crate::output::modify_snapshot_schedule_output::Builder {
        crate::output::modify_snapshot_schedule_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModifySnapshotCopyRetentionPeriodOutput {
    /// <p>Describes a cluster.</p>
    pub cluster: std::option::Option<crate::model::Cluster>,
}
impl ModifySnapshotCopyRetentionPeriodOutput {
    /// <p>Describes a cluster.</p>
    pub fn cluster(&self) -> std::option::Option<&crate::model::Cluster> {
        self.cluster.as_ref()
    }
}
impl std::fmt::Debug for ModifySnapshotCopyRetentionPeriodOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModifySnapshotCopyRetentionPeriodOutput");
        formatter.field("cluster", &self.cluster);
        formatter.finish()
    }
}
/// See [`ModifySnapshotCopyRetentionPeriodOutput`](crate::output::ModifySnapshotCopyRetentionPeriodOutput)
pub mod modify_snapshot_copy_retention_period_output {
    /// A builder for [`ModifySnapshotCopyRetentionPeriodOutput`](crate::output::ModifySnapshotCopyRetentionPeriodOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster: std::option::Option<crate::model::Cluster>,
    }
    impl Builder {
        /// <p>Describes a cluster.</p>
        pub fn cluster(mut self, input: crate::model::Cluster) -> Self {
            self.cluster = Some(input);
            self
        }
        /// <p>Describes a cluster.</p>
        pub fn set_cluster(mut self, input: std::option::Option<crate::model::Cluster>) -> Self {
            self.cluster = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifySnapshotCopyRetentionPeriodOutput`](crate::output::ModifySnapshotCopyRetentionPeriodOutput)
        pub fn build(self) -> crate::output::ModifySnapshotCopyRetentionPeriodOutput {
            crate::output::ModifySnapshotCopyRetentionPeriodOutput {
                cluster: self.cluster,
            }
        }
    }
}
impl ModifySnapshotCopyRetentionPeriodOutput {
    /// Creates a new builder-style object to manufacture [`ModifySnapshotCopyRetentionPeriodOutput`](crate::output::ModifySnapshotCopyRetentionPeriodOutput)
    pub fn builder() -> crate::output::modify_snapshot_copy_retention_period_output::Builder {
        crate::output::modify_snapshot_copy_retention_period_output::Builder::default()
    }
}

/// <p>Describes a scheduled action. You can use a scheduled action to trigger some Amazon Redshift API operations on a schedule. For information about which API operations can be scheduled, see <code>ScheduledActionType</code>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModifyScheduledActionOutput {
    /// <p>The name of the scheduled action. </p>
    pub scheduled_action_name: std::option::Option<std::string::String>,
    /// <p>A JSON format string of the Amazon Redshift API operation with input parameters. </p>
    /// <p>"<code>{\"ResizeCluster\":{\"NodeType\":\"ds2.8xlarge\",\"ClusterIdentifier\":\"my-test-cluster\",\"NumberOfNodes\":3}}</code>". </p>
    pub target_action: std::option::Option<crate::model::ScheduledActionType>,
    /// <p>The schedule for a one-time (at format) or recurring (cron format) scheduled action. Schedule invocations must be separated by at least one hour.</p>
    /// <p>Format of at expressions is "<code>at(yyyy-mm-ddThh:mm:ss)</code>". For example, "<code>at(2016-03-04T17:27:00)</code>".</p>
    /// <p>Format of cron expressions is "<code>cron(Minutes Hours Day-of-month Month Day-of-week Year)</code>". For example, "<code>cron(0 10 ? * MON *)</code>". For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html#CronExpressions">Cron Expressions</a> in the <i>Amazon CloudWatch Events User Guide</i>.</p>
    pub schedule: std::option::Option<std::string::String>,
    /// <p>The IAM role to assume to run the scheduled action. This IAM role must have permission to run the Amazon Redshift API operation in the scheduled action. This IAM role must allow the Amazon Redshift scheduler (Principal scheduler.redshift.amazonaws.com) to assume permissions on your behalf. For more information about the IAM role to use with the Amazon Redshift scheduler, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-identity-based.html">Using Identity-Based Policies for Amazon Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>. </p>
    pub iam_role: std::option::Option<std::string::String>,
    /// <p>The description of the scheduled action. </p>
    pub scheduled_action_description: std::option::Option<std::string::String>,
    /// <p>The state of the scheduled action. For example, <code>DISABLED</code>. </p>
    pub state: std::option::Option<crate::model::ScheduledActionState>,
    /// <p>List of times when the scheduled action will run. </p>
    pub next_invocations: std::option::Option<std::vec::Vec<aws_smithy_types::DateTime>>,
    /// <p>The start time in UTC when the schedule is active. Before this time, the scheduled action does not trigger. </p>
    pub start_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The end time in UTC when the schedule is no longer active. After this time, the scheduled action does not trigger. </p>
    pub end_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl ModifyScheduledActionOutput {
    /// <p>The name of the scheduled action. </p>
    pub fn scheduled_action_name(&self) -> std::option::Option<&str> {
        self.scheduled_action_name.as_deref()
    }
    /// <p>A JSON format string of the Amazon Redshift API operation with input parameters. </p>
    /// <p>"<code>{\"ResizeCluster\":{\"NodeType\":\"ds2.8xlarge\",\"ClusterIdentifier\":\"my-test-cluster\",\"NumberOfNodes\":3}}</code>". </p>
    pub fn target_action(&self) -> std::option::Option<&crate::model::ScheduledActionType> {
        self.target_action.as_ref()
    }
    /// <p>The schedule for a one-time (at format) or recurring (cron format) scheduled action. Schedule invocations must be separated by at least one hour.</p>
    /// <p>Format of at expressions is "<code>at(yyyy-mm-ddThh:mm:ss)</code>". For example, "<code>at(2016-03-04T17:27:00)</code>".</p>
    /// <p>Format of cron expressions is "<code>cron(Minutes Hours Day-of-month Month Day-of-week Year)</code>". For example, "<code>cron(0 10 ? * MON *)</code>". For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html#CronExpressions">Cron Expressions</a> in the <i>Amazon CloudWatch Events User Guide</i>.</p>
    pub fn schedule(&self) -> std::option::Option<&str> {
        self.schedule.as_deref()
    }
    /// <p>The IAM role to assume to run the scheduled action. This IAM role must have permission to run the Amazon Redshift API operation in the scheduled action. This IAM role must allow the Amazon Redshift scheduler (Principal scheduler.redshift.amazonaws.com) to assume permissions on your behalf. For more information about the IAM role to use with the Amazon Redshift scheduler, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-identity-based.html">Using Identity-Based Policies for Amazon Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>. </p>
    pub fn iam_role(&self) -> std::option::Option<&str> {
        self.iam_role.as_deref()
    }
    /// <p>The description of the scheduled action. </p>
    pub fn scheduled_action_description(&self) -> std::option::Option<&str> {
        self.scheduled_action_description.as_deref()
    }
    /// <p>The state of the scheduled action. For example, <code>DISABLED</code>. </p>
    pub fn state(&self) -> std::option::Option<&crate::model::ScheduledActionState> {
        self.state.as_ref()
    }
    /// <p>List of times when the scheduled action will run. </p>
    pub fn next_invocations(&self) -> std::option::Option<&[aws_smithy_types::DateTime]> {
        self.next_invocations.as_deref()
    }
    /// <p>The start time in UTC when the schedule is active. Before this time, the scheduled action does not trigger. </p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start_time.as_ref()
    }
    /// <p>The end time in UTC when the schedule is no longer active. After this time, the scheduled action does not trigger. </p>
    pub fn end_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.end_time.as_ref()
    }
}
impl std::fmt::Debug for ModifyScheduledActionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModifyScheduledActionOutput");
        formatter.field("scheduled_action_name", &self.scheduled_action_name);
        formatter.field("target_action", &self.target_action);
        formatter.field("schedule", &self.schedule);
        formatter.field("iam_role", &self.iam_role);
        formatter.field(
            "scheduled_action_description",
            &self.scheduled_action_description,
        );
        formatter.field("state", &self.state);
        formatter.field("next_invocations", &self.next_invocations);
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.finish()
    }
}
/// See [`ModifyScheduledActionOutput`](crate::output::ModifyScheduledActionOutput)
pub mod modify_scheduled_action_output {
    /// A builder for [`ModifyScheduledActionOutput`](crate::output::ModifyScheduledActionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) scheduled_action_name: std::option::Option<std::string::String>,
        pub(crate) target_action: std::option::Option<crate::model::ScheduledActionType>,
        pub(crate) schedule: std::option::Option<std::string::String>,
        pub(crate) iam_role: std::option::Option<std::string::String>,
        pub(crate) scheduled_action_description: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::ScheduledActionState>,
        pub(crate) next_invocations: std::option::Option<std::vec::Vec<aws_smithy_types::DateTime>>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The name of the scheduled action. </p>
        pub fn scheduled_action_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.scheduled_action_name = Some(input.into());
            self
        }
        /// <p>The name of the scheduled action. </p>
        pub fn set_scheduled_action_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.scheduled_action_name = input;
            self
        }
        /// <p>A JSON format string of the Amazon Redshift API operation with input parameters. </p>
        /// <p>"<code>{\"ResizeCluster\":{\"NodeType\":\"ds2.8xlarge\",\"ClusterIdentifier\":\"my-test-cluster\",\"NumberOfNodes\":3}}</code>". </p>
        pub fn target_action(mut self, input: crate::model::ScheduledActionType) -> Self {
            self.target_action = Some(input);
            self
        }
        /// <p>A JSON format string of the Amazon Redshift API operation with input parameters. </p>
        /// <p>"<code>{\"ResizeCluster\":{\"NodeType\":\"ds2.8xlarge\",\"ClusterIdentifier\":\"my-test-cluster\",\"NumberOfNodes\":3}}</code>". </p>
        pub fn set_target_action(
            mut self,
            input: std::option::Option<crate::model::ScheduledActionType>,
        ) -> Self {
            self.target_action = input;
            self
        }
        /// <p>The schedule for a one-time (at format) or recurring (cron format) scheduled action. Schedule invocations must be separated by at least one hour.</p>
        /// <p>Format of at expressions is "<code>at(yyyy-mm-ddThh:mm:ss)</code>". For example, "<code>at(2016-03-04T17:27:00)</code>".</p>
        /// <p>Format of cron expressions is "<code>cron(Minutes Hours Day-of-month Month Day-of-week Year)</code>". For example, "<code>cron(0 10 ? * MON *)</code>". For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html#CronExpressions">Cron Expressions</a> in the <i>Amazon CloudWatch Events User Guide</i>.</p>
        pub fn schedule(mut self, input: impl Into<std::string::String>) -> Self {
            self.schedule = Some(input.into());
            self
        }
        /// <p>The schedule for a one-time (at format) or recurring (cron format) scheduled action. Schedule invocations must be separated by at least one hour.</p>
        /// <p>Format of at expressions is "<code>at(yyyy-mm-ddThh:mm:ss)</code>". For example, "<code>at(2016-03-04T17:27:00)</code>".</p>
        /// <p>Format of cron expressions is "<code>cron(Minutes Hours Day-of-month Month Day-of-week Year)</code>". For example, "<code>cron(0 10 ? * MON *)</code>". For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html#CronExpressions">Cron Expressions</a> in the <i>Amazon CloudWatch Events User Guide</i>.</p>
        pub fn set_schedule(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schedule = input;
            self
        }
        /// <p>The IAM role to assume to run the scheduled action. This IAM role must have permission to run the Amazon Redshift API operation in the scheduled action. This IAM role must allow the Amazon Redshift scheduler (Principal scheduler.redshift.amazonaws.com) to assume permissions on your behalf. For more information about the IAM role to use with the Amazon Redshift scheduler, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-identity-based.html">Using Identity-Based Policies for Amazon Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>. </p>
        pub fn iam_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.iam_role = Some(input.into());
            self
        }
        /// <p>The IAM role to assume to run the scheduled action. This IAM role must have permission to run the Amazon Redshift API operation in the scheduled action. This IAM role must allow the Amazon Redshift scheduler (Principal scheduler.redshift.amazonaws.com) to assume permissions on your behalf. For more information about the IAM role to use with the Amazon Redshift scheduler, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-identity-based.html">Using Identity-Based Policies for Amazon Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>. </p>
        pub fn set_iam_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.iam_role = input;
            self
        }
        /// <p>The description of the scheduled action. </p>
        pub fn scheduled_action_description(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.scheduled_action_description = Some(input.into());
            self
        }
        /// <p>The description of the scheduled action. </p>
        pub fn set_scheduled_action_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.scheduled_action_description = input;
            self
        }
        /// <p>The state of the scheduled action. For example, <code>DISABLED</code>. </p>
        pub fn state(mut self, input: crate::model::ScheduledActionState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The state of the scheduled action. For example, <code>DISABLED</code>. </p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::ScheduledActionState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// Appends an item to `next_invocations`.
        ///
        /// To override the contents of this collection use [`set_next_invocations`](Self::set_next_invocations).
        ///
        /// <p>List of times when the scheduled action will run. </p>
        pub fn next_invocations(mut self, input: aws_smithy_types::DateTime) -> Self {
            let mut v = self.next_invocations.unwrap_or_default();
            v.push(input);
            self.next_invocations = Some(v);
            self
        }
        /// <p>List of times when the scheduled action will run. </p>
        pub fn set_next_invocations(
            mut self,
            input: std::option::Option<std::vec::Vec<aws_smithy_types::DateTime>>,
        ) -> Self {
            self.next_invocations = input;
            self
        }
        /// <p>The start time in UTC when the schedule is active. Before this time, the scheduled action does not trigger. </p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The start time in UTC when the schedule is active. Before this time, the scheduled action does not trigger. </p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The end time in UTC when the schedule is no longer active. After this time, the scheduled action does not trigger. </p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>The end time in UTC when the schedule is no longer active. After this time, the scheduled action does not trigger. </p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyScheduledActionOutput`](crate::output::ModifyScheduledActionOutput)
        pub fn build(self) -> crate::output::ModifyScheduledActionOutput {
            crate::output::ModifyScheduledActionOutput {
                scheduled_action_name: self.scheduled_action_name,
                target_action: self.target_action,
                schedule: self.schedule,
                iam_role: self.iam_role,
                scheduled_action_description: self.scheduled_action_description,
                state: self.state,
                next_invocations: self.next_invocations,
                start_time: self.start_time,
                end_time: self.end_time,
            }
        }
    }
}
impl ModifyScheduledActionOutput {
    /// Creates a new builder-style object to manufacture [`ModifyScheduledActionOutput`](crate::output::ModifyScheduledActionOutput)
    pub fn builder() -> crate::output::modify_scheduled_action_output::Builder {
        crate::output::modify_scheduled_action_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModifyEventSubscriptionOutput {
    /// <p>Describes event subscriptions.</p>
    pub event_subscription: std::option::Option<crate::model::EventSubscription>,
}
impl ModifyEventSubscriptionOutput {
    /// <p>Describes event subscriptions.</p>
    pub fn event_subscription(&self) -> std::option::Option<&crate::model::EventSubscription> {
        self.event_subscription.as_ref()
    }
}
impl std::fmt::Debug for ModifyEventSubscriptionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModifyEventSubscriptionOutput");
        formatter.field("event_subscription", &self.event_subscription);
        formatter.finish()
    }
}
/// See [`ModifyEventSubscriptionOutput`](crate::output::ModifyEventSubscriptionOutput)
pub mod modify_event_subscription_output {
    /// A builder for [`ModifyEventSubscriptionOutput`](crate::output::ModifyEventSubscriptionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) event_subscription: std::option::Option<crate::model::EventSubscription>,
    }
    impl Builder {
        /// <p>Describes event subscriptions.</p>
        pub fn event_subscription(mut self, input: crate::model::EventSubscription) -> Self {
            self.event_subscription = Some(input);
            self
        }
        /// <p>Describes event subscriptions.</p>
        pub fn set_event_subscription(
            mut self,
            input: std::option::Option<crate::model::EventSubscription>,
        ) -> Self {
            self.event_subscription = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyEventSubscriptionOutput`](crate::output::ModifyEventSubscriptionOutput)
        pub fn build(self) -> crate::output::ModifyEventSubscriptionOutput {
            crate::output::ModifyEventSubscriptionOutput {
                event_subscription: self.event_subscription,
            }
        }
    }
}
impl ModifyEventSubscriptionOutput {
    /// Creates a new builder-style object to manufacture [`ModifyEventSubscriptionOutput`](crate::output::ModifyEventSubscriptionOutput)
    pub fn builder() -> crate::output::modify_event_subscription_output::Builder {
        crate::output::modify_event_subscription_output::Builder::default()
    }
}

/// <p>Describes a Redshift-managed VPC endpoint.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModifyEndpointAccessOutput {
    /// <p>The cluster identifier of the cluster associated with the endpoint.</p>
    pub cluster_identifier: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services account ID of the owner of the cluster.</p>
    pub resource_owner: std::option::Option<std::string::String>,
    /// <p>The subnet group name where Amazon Redshift chooses to deploy the endpoint.</p>
    pub subnet_group_name: std::option::Option<std::string::String>,
    /// <p>The status of the endpoint.</p>
    pub endpoint_status: std::option::Option<std::string::String>,
    /// <p>The name of the endpoint.</p>
    pub endpoint_name: std::option::Option<std::string::String>,
    /// <p>The time (UTC) that the endpoint was created.</p>
    pub endpoint_create_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The port number on which the cluster accepts incoming connections.</p>
    pub port: i32,
    /// <p>The DNS address of the endpoint.</p>
    pub address: std::option::Option<std::string::String>,
    /// <p>The security groups associated with the endpoint.</p>
    pub vpc_security_groups:
        std::option::Option<std::vec::Vec<crate::model::VpcSecurityGroupMembership>>,
    /// <p>The connection endpoint for connecting to an Amazon Redshift cluster through the proxy.</p>
    pub vpc_endpoint: std::option::Option<crate::model::VpcEndpoint>,
}
impl ModifyEndpointAccessOutput {
    /// <p>The cluster identifier of the cluster associated with the endpoint.</p>
    pub fn cluster_identifier(&self) -> std::option::Option<&str> {
        self.cluster_identifier.as_deref()
    }
    /// <p>The Amazon Web Services account ID of the owner of the cluster.</p>
    pub fn resource_owner(&self) -> std::option::Option<&str> {
        self.resource_owner.as_deref()
    }
    /// <p>The subnet group name where Amazon Redshift chooses to deploy the endpoint.</p>
    pub fn subnet_group_name(&self) -> std::option::Option<&str> {
        self.subnet_group_name.as_deref()
    }
    /// <p>The status of the endpoint.</p>
    pub fn endpoint_status(&self) -> std::option::Option<&str> {
        self.endpoint_status.as_deref()
    }
    /// <p>The name of the endpoint.</p>
    pub fn endpoint_name(&self) -> std::option::Option<&str> {
        self.endpoint_name.as_deref()
    }
    /// <p>The time (UTC) that the endpoint was created.</p>
    pub fn endpoint_create_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.endpoint_create_time.as_ref()
    }
    /// <p>The port number on which the cluster accepts incoming connections.</p>
    pub fn port(&self) -> i32 {
        self.port
    }
    /// <p>The DNS address of the endpoint.</p>
    pub fn address(&self) -> std::option::Option<&str> {
        self.address.as_deref()
    }
    /// <p>The security groups associated with the endpoint.</p>
    pub fn vpc_security_groups(
        &self,
    ) -> std::option::Option<&[crate::model::VpcSecurityGroupMembership]> {
        self.vpc_security_groups.as_deref()
    }
    /// <p>The connection endpoint for connecting to an Amazon Redshift cluster through the proxy.</p>
    pub fn vpc_endpoint(&self) -> std::option::Option<&crate::model::VpcEndpoint> {
        self.vpc_endpoint.as_ref()
    }
}
impl std::fmt::Debug for ModifyEndpointAccessOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModifyEndpointAccessOutput");
        formatter.field("cluster_identifier", &self.cluster_identifier);
        formatter.field("resource_owner", &self.resource_owner);
        formatter.field("subnet_group_name", &self.subnet_group_name);
        formatter.field("endpoint_status", &self.endpoint_status);
        formatter.field("endpoint_name", &self.endpoint_name);
        formatter.field("endpoint_create_time", &self.endpoint_create_time);
        formatter.field("port", &self.port);
        formatter.field("address", &self.address);
        formatter.field("vpc_security_groups", &self.vpc_security_groups);
        formatter.field("vpc_endpoint", &self.vpc_endpoint);
        formatter.finish()
    }
}
/// See [`ModifyEndpointAccessOutput`](crate::output::ModifyEndpointAccessOutput)
pub mod modify_endpoint_access_output {
    /// A builder for [`ModifyEndpointAccessOutput`](crate::output::ModifyEndpointAccessOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) resource_owner: std::option::Option<std::string::String>,
        pub(crate) subnet_group_name: std::option::Option<std::string::String>,
        pub(crate) endpoint_status: std::option::Option<std::string::String>,
        pub(crate) endpoint_name: std::option::Option<std::string::String>,
        pub(crate) endpoint_create_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) port: std::option::Option<i32>,
        pub(crate) address: std::option::Option<std::string::String>,
        pub(crate) vpc_security_groups:
            std::option::Option<std::vec::Vec<crate::model::VpcSecurityGroupMembership>>,
        pub(crate) vpc_endpoint: std::option::Option<crate::model::VpcEndpoint>,
    }
    impl Builder {
        /// <p>The cluster identifier of the cluster associated with the endpoint.</p>
        pub fn cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_identifier = Some(input.into());
            self
        }
        /// <p>The cluster identifier of the cluster associated with the endpoint.</p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cluster_identifier = input;
            self
        }
        /// <p>The Amazon Web Services account ID of the owner of the cluster.</p>
        pub fn resource_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_owner = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID of the owner of the cluster.</p>
        pub fn set_resource_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_owner = input;
            self
        }
        /// <p>The subnet group name where Amazon Redshift chooses to deploy the endpoint.</p>
        pub fn subnet_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.subnet_group_name = Some(input.into());
            self
        }
        /// <p>The subnet group name where Amazon Redshift chooses to deploy the endpoint.</p>
        pub fn set_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.subnet_group_name = input;
            self
        }
        /// <p>The status of the endpoint.</p>
        pub fn endpoint_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_status = Some(input.into());
            self
        }
        /// <p>The status of the endpoint.</p>
        pub fn set_endpoint_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.endpoint_status = input;
            self
        }
        /// <p>The name of the endpoint.</p>
        pub fn endpoint_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_name = Some(input.into());
            self
        }
        /// <p>The name of the endpoint.</p>
        pub fn set_endpoint_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.endpoint_name = input;
            self
        }
        /// <p>The time (UTC) that the endpoint was created.</p>
        pub fn endpoint_create_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.endpoint_create_time = Some(input);
            self
        }
        /// <p>The time (UTC) that the endpoint was created.</p>
        pub fn set_endpoint_create_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.endpoint_create_time = input;
            self
        }
        /// <p>The port number on which the cluster accepts incoming connections.</p>
        pub fn port(mut self, input: i32) -> Self {
            self.port = Some(input);
            self
        }
        /// <p>The port number on which the cluster accepts incoming connections.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.port = input;
            self
        }
        /// <p>The DNS address of the endpoint.</p>
        pub fn address(mut self, input: impl Into<std::string::String>) -> Self {
            self.address = Some(input.into());
            self
        }
        /// <p>The DNS address of the endpoint.</p>
        pub fn set_address(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.address = input;
            self
        }
        /// Appends an item to `vpc_security_groups`.
        ///
        /// To override the contents of this collection use [`set_vpc_security_groups`](Self::set_vpc_security_groups).
        ///
        /// <p>The security groups associated with the endpoint.</p>
        pub fn vpc_security_groups(
            mut self,
            input: crate::model::VpcSecurityGroupMembership,
        ) -> Self {
            let mut v = self.vpc_security_groups.unwrap_or_default();
            v.push(input);
            self.vpc_security_groups = Some(v);
            self
        }
        /// <p>The security groups associated with the endpoint.</p>
        pub fn set_vpc_security_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::VpcSecurityGroupMembership>>,
        ) -> Self {
            self.vpc_security_groups = input;
            self
        }
        /// <p>The connection endpoint for connecting to an Amazon Redshift cluster through the proxy.</p>
        pub fn vpc_endpoint(mut self, input: crate::model::VpcEndpoint) -> Self {
            self.vpc_endpoint = Some(input);
            self
        }
        /// <p>The connection endpoint for connecting to an Amazon Redshift cluster through the proxy.</p>
        pub fn set_vpc_endpoint(
            mut self,
            input: std::option::Option<crate::model::VpcEndpoint>,
        ) -> Self {
            self.vpc_endpoint = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyEndpointAccessOutput`](crate::output::ModifyEndpointAccessOutput)
        pub fn build(self) -> crate::output::ModifyEndpointAccessOutput {
            crate::output::ModifyEndpointAccessOutput {
                cluster_identifier: self.cluster_identifier,
                resource_owner: self.resource_owner,
                subnet_group_name: self.subnet_group_name,
                endpoint_status: self.endpoint_status,
                endpoint_name: self.endpoint_name,
                endpoint_create_time: self.endpoint_create_time,
                port: self.port.unwrap_or_default(),
                address: self.address,
                vpc_security_groups: self.vpc_security_groups,
                vpc_endpoint: self.vpc_endpoint,
            }
        }
    }
}
impl ModifyEndpointAccessOutput {
    /// Creates a new builder-style object to manufacture [`ModifyEndpointAccessOutput`](crate::output::ModifyEndpointAccessOutput)
    pub fn builder() -> crate::output::modify_endpoint_access_output::Builder {
        crate::output::modify_endpoint_access_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModifyClusterSubnetGroupOutput {
    /// <p>Describes a subnet group.</p>
    pub cluster_subnet_group: std::option::Option<crate::model::ClusterSubnetGroup>,
}
impl ModifyClusterSubnetGroupOutput {
    /// <p>Describes a subnet group.</p>
    pub fn cluster_subnet_group(&self) -> std::option::Option<&crate::model::ClusterSubnetGroup> {
        self.cluster_subnet_group.as_ref()
    }
}
impl std::fmt::Debug for ModifyClusterSubnetGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModifyClusterSubnetGroupOutput");
        formatter.field("cluster_subnet_group", &self.cluster_subnet_group);
        formatter.finish()
    }
}
/// See [`ModifyClusterSubnetGroupOutput`](crate::output::ModifyClusterSubnetGroupOutput)
pub mod modify_cluster_subnet_group_output {
    /// A builder for [`ModifyClusterSubnetGroupOutput`](crate::output::ModifyClusterSubnetGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_subnet_group: std::option::Option<crate::model::ClusterSubnetGroup>,
    }
    impl Builder {
        /// <p>Describes a subnet group.</p>
        pub fn cluster_subnet_group(mut self, input: crate::model::ClusterSubnetGroup) -> Self {
            self.cluster_subnet_group = Some(input);
            self
        }
        /// <p>Describes a subnet group.</p>
        pub fn set_cluster_subnet_group(
            mut self,
            input: std::option::Option<crate::model::ClusterSubnetGroup>,
        ) -> Self {
            self.cluster_subnet_group = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyClusterSubnetGroupOutput`](crate::output::ModifyClusterSubnetGroupOutput)
        pub fn build(self) -> crate::output::ModifyClusterSubnetGroupOutput {
            crate::output::ModifyClusterSubnetGroupOutput {
                cluster_subnet_group: self.cluster_subnet_group,
            }
        }
    }
}
impl ModifyClusterSubnetGroupOutput {
    /// Creates a new builder-style object to manufacture [`ModifyClusterSubnetGroupOutput`](crate::output::ModifyClusterSubnetGroupOutput)
    pub fn builder() -> crate::output::modify_cluster_subnet_group_output::Builder {
        crate::output::modify_cluster_subnet_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModifyClusterSnapshotScheduleOutput {}
impl std::fmt::Debug for ModifyClusterSnapshotScheduleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModifyClusterSnapshotScheduleOutput");
        formatter.finish()
    }
}
/// See [`ModifyClusterSnapshotScheduleOutput`](crate::output::ModifyClusterSnapshotScheduleOutput)
pub mod modify_cluster_snapshot_schedule_output {
    /// A builder for [`ModifyClusterSnapshotScheduleOutput`](crate::output::ModifyClusterSnapshotScheduleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`ModifyClusterSnapshotScheduleOutput`](crate::output::ModifyClusterSnapshotScheduleOutput)
        pub fn build(self) -> crate::output::ModifyClusterSnapshotScheduleOutput {
            crate::output::ModifyClusterSnapshotScheduleOutput {}
        }
    }
}
impl ModifyClusterSnapshotScheduleOutput {
    /// Creates a new builder-style object to manufacture [`ModifyClusterSnapshotScheduleOutput`](crate::output::ModifyClusterSnapshotScheduleOutput)
    pub fn builder() -> crate::output::modify_cluster_snapshot_schedule_output::Builder {
        crate::output::modify_cluster_snapshot_schedule_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModifyClusterSnapshotOutput {
    /// <p>Describes a snapshot.</p>
    pub snapshot: std::option::Option<crate::model::Snapshot>,
}
impl ModifyClusterSnapshotOutput {
    /// <p>Describes a snapshot.</p>
    pub fn snapshot(&self) -> std::option::Option<&crate::model::Snapshot> {
        self.snapshot.as_ref()
    }
}
impl std::fmt::Debug for ModifyClusterSnapshotOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModifyClusterSnapshotOutput");
        formatter.field("snapshot", &self.snapshot);
        formatter.finish()
    }
}
/// See [`ModifyClusterSnapshotOutput`](crate::output::ModifyClusterSnapshotOutput)
pub mod modify_cluster_snapshot_output {
    /// A builder for [`ModifyClusterSnapshotOutput`](crate::output::ModifyClusterSnapshotOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) snapshot: std::option::Option<crate::model::Snapshot>,
    }
    impl Builder {
        /// <p>Describes a snapshot.</p>
        pub fn snapshot(mut self, input: crate::model::Snapshot) -> Self {
            self.snapshot = Some(input);
            self
        }
        /// <p>Describes a snapshot.</p>
        pub fn set_snapshot(mut self, input: std::option::Option<crate::model::Snapshot>) -> Self {
            self.snapshot = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyClusterSnapshotOutput`](crate::output::ModifyClusterSnapshotOutput)
        pub fn build(self) -> crate::output::ModifyClusterSnapshotOutput {
            crate::output::ModifyClusterSnapshotOutput {
                snapshot: self.snapshot,
            }
        }
    }
}
impl ModifyClusterSnapshotOutput {
    /// Creates a new builder-style object to manufacture [`ModifyClusterSnapshotOutput`](crate::output::ModifyClusterSnapshotOutput)
    pub fn builder() -> crate::output::modify_cluster_snapshot_output::Builder {
        crate::output::modify_cluster_snapshot_output::Builder::default()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModifyClusterParameterGroupOutput {
    /// <p>The name of the cluster parameter group.</p>
    pub parameter_group_name: std::option::Option<std::string::String>,
    /// <p>The status of the parameter group. For example, if you made a change to a parameter group name-value pair, then the change could be pending a reboot of an associated cluster.</p>
    pub parameter_group_status: std::option::Option<std::string::String>,
}
impl ModifyClusterParameterGroupOutput {
    /// <p>The name of the cluster parameter group.</p>
    pub fn parameter_group_name(&self) -> std::option::Option<&str> {
        self.parameter_group_name.as_deref()
    }
    /// <p>The status of the parameter group. For example, if you made a change to a parameter group name-value pair, then the change could be pending a reboot of an associated cluster.</p>
    pub fn parameter_group_status(&self) -> std::option::Option<&str> {
        self.parameter_group_status.as_deref()
    }
}
impl std::fmt::Debug for ModifyClusterParameterGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModifyClusterParameterGroupOutput");
        formatter.field("parameter_group_name", &self.parameter_group_name);
        formatter.field("parameter_group_status", &self.parameter_group_status);
        formatter.finish()
    }
}
/// See [`ModifyClusterParameterGroupOutput`](crate::output::ModifyClusterParameterGroupOutput)
pub mod modify_cluster_parameter_group_output {
    /// A builder for [`ModifyClusterParameterGroupOutput`](crate::output::ModifyClusterParameterGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) parameter_group_name: std::option::Option<std::string::String>,
        pub(crate) parameter_group_status: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the cluster parameter group.</p>
        pub fn parameter_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.parameter_group_name = Some(input.into());
            self
        }
        /// <p>The name of the cluster parameter group.</p>
        pub fn set_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parameter_group_name = input;
            self
        }
        /// <p>The status of the parameter group. For example, if you made a change to a parameter group name-value pair, then the change could be pending a reboot of an associated cluster.</p>
        pub fn parameter_group_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.parameter_group_status = Some(input.into());
            self
        }
        /// <p>The status of the parameter group. For example, if you made a change to a parameter group name-value pair, then the change could be pending a reboot of an associated cluster.</p>
        pub fn set_parameter_group_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parameter_group_status = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyClusterParameterGroupOutput`](crate::output::ModifyClusterParameterGroupOutput)
        pub fn build(self) -> crate::output::ModifyClusterParameterGroupOutput {
            crate::output::ModifyClusterParameterGroupOutput {
                parameter_group_name: self.parameter_group_name,
                parameter_group_status: self.parameter_group_status,
            }
        }
    }
}
impl ModifyClusterParameterGroupOutput {
    /// Creates a new builder-style object to manufacture [`ModifyClusterParameterGroupOutput`](crate::output::ModifyClusterParameterGroupOutput)
    pub fn builder() -> crate::output::modify_cluster_parameter_group_output::Builder {
        crate::output::modify_cluster_parameter_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModifyClusterMaintenanceOutput {
    /// <p>Describes a cluster.</p>
    pub cluster: std::option::Option<crate::model::Cluster>,
}
impl ModifyClusterMaintenanceOutput {
    /// <p>Describes a cluster.</p>
    pub fn cluster(&self) -> std::option::Option<&crate::model::Cluster> {
        self.cluster.as_ref()
    }
}
impl std::fmt::Debug for ModifyClusterMaintenanceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModifyClusterMaintenanceOutput");
        formatter.field("cluster", &self.cluster);
        formatter.finish()
    }
}
/// See [`ModifyClusterMaintenanceOutput`](crate::output::ModifyClusterMaintenanceOutput)
pub mod modify_cluster_maintenance_output {
    /// A builder for [`ModifyClusterMaintenanceOutput`](crate::output::ModifyClusterMaintenanceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster: std::option::Option<crate::model::Cluster>,
    }
    impl Builder {
        /// <p>Describes a cluster.</p>
        pub fn cluster(mut self, input: crate::model::Cluster) -> Self {
            self.cluster = Some(input);
            self
        }
        /// <p>Describes a cluster.</p>
        pub fn set_cluster(mut self, input: std::option::Option<crate::model::Cluster>) -> Self {
            self.cluster = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyClusterMaintenanceOutput`](crate::output::ModifyClusterMaintenanceOutput)
        pub fn build(self) -> crate::output::ModifyClusterMaintenanceOutput {
            crate::output::ModifyClusterMaintenanceOutput {
                cluster: self.cluster,
            }
        }
    }
}
impl ModifyClusterMaintenanceOutput {
    /// Creates a new builder-style object to manufacture [`ModifyClusterMaintenanceOutput`](crate::output::ModifyClusterMaintenanceOutput)
    pub fn builder() -> crate::output::modify_cluster_maintenance_output::Builder {
        crate::output::modify_cluster_maintenance_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModifyClusterIamRolesOutput {
    /// <p>Describes a cluster.</p>
    pub cluster: std::option::Option<crate::model::Cluster>,
}
impl ModifyClusterIamRolesOutput {
    /// <p>Describes a cluster.</p>
    pub fn cluster(&self) -> std::option::Option<&crate::model::Cluster> {
        self.cluster.as_ref()
    }
}
impl std::fmt::Debug for ModifyClusterIamRolesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModifyClusterIamRolesOutput");
        formatter.field("cluster", &self.cluster);
        formatter.finish()
    }
}
/// See [`ModifyClusterIamRolesOutput`](crate::output::ModifyClusterIamRolesOutput)
pub mod modify_cluster_iam_roles_output {
    /// A builder for [`ModifyClusterIamRolesOutput`](crate::output::ModifyClusterIamRolesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster: std::option::Option<crate::model::Cluster>,
    }
    impl Builder {
        /// <p>Describes a cluster.</p>
        pub fn cluster(mut self, input: crate::model::Cluster) -> Self {
            self.cluster = Some(input);
            self
        }
        /// <p>Describes a cluster.</p>
        pub fn set_cluster(mut self, input: std::option::Option<crate::model::Cluster>) -> Self {
            self.cluster = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyClusterIamRolesOutput`](crate::output::ModifyClusterIamRolesOutput)
        pub fn build(self) -> crate::output::ModifyClusterIamRolesOutput {
            crate::output::ModifyClusterIamRolesOutput {
                cluster: self.cluster,
            }
        }
    }
}
impl ModifyClusterIamRolesOutput {
    /// Creates a new builder-style object to manufacture [`ModifyClusterIamRolesOutput`](crate::output::ModifyClusterIamRolesOutput)
    pub fn builder() -> crate::output::modify_cluster_iam_roles_output::Builder {
        crate::output::modify_cluster_iam_roles_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModifyClusterDbRevisionOutput {
    /// <p>Describes a cluster.</p>
    pub cluster: std::option::Option<crate::model::Cluster>,
}
impl ModifyClusterDbRevisionOutput {
    /// <p>Describes a cluster.</p>
    pub fn cluster(&self) -> std::option::Option<&crate::model::Cluster> {
        self.cluster.as_ref()
    }
}
impl std::fmt::Debug for ModifyClusterDbRevisionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModifyClusterDbRevisionOutput");
        formatter.field("cluster", &self.cluster);
        formatter.finish()
    }
}
/// See [`ModifyClusterDbRevisionOutput`](crate::output::ModifyClusterDbRevisionOutput)
pub mod modify_cluster_db_revision_output {
    /// A builder for [`ModifyClusterDbRevisionOutput`](crate::output::ModifyClusterDbRevisionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster: std::option::Option<crate::model::Cluster>,
    }
    impl Builder {
        /// <p>Describes a cluster.</p>
        pub fn cluster(mut self, input: crate::model::Cluster) -> Self {
            self.cluster = Some(input);
            self
        }
        /// <p>Describes a cluster.</p>
        pub fn set_cluster(mut self, input: std::option::Option<crate::model::Cluster>) -> Self {
            self.cluster = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyClusterDbRevisionOutput`](crate::output::ModifyClusterDbRevisionOutput)
        pub fn build(self) -> crate::output::ModifyClusterDbRevisionOutput {
            crate::output::ModifyClusterDbRevisionOutput {
                cluster: self.cluster,
            }
        }
    }
}
impl ModifyClusterDbRevisionOutput {
    /// Creates a new builder-style object to manufacture [`ModifyClusterDbRevisionOutput`](crate::output::ModifyClusterDbRevisionOutput)
    pub fn builder() -> crate::output::modify_cluster_db_revision_output::Builder {
        crate::output::modify_cluster_db_revision_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModifyClusterOutput {
    /// <p>Describes a cluster.</p>
    pub cluster: std::option::Option<crate::model::Cluster>,
}
impl ModifyClusterOutput {
    /// <p>Describes a cluster.</p>
    pub fn cluster(&self) -> std::option::Option<&crate::model::Cluster> {
        self.cluster.as_ref()
    }
}
impl std::fmt::Debug for ModifyClusterOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModifyClusterOutput");
        formatter.field("cluster", &self.cluster);
        formatter.finish()
    }
}
/// See [`ModifyClusterOutput`](crate::output::ModifyClusterOutput)
pub mod modify_cluster_output {
    /// A builder for [`ModifyClusterOutput`](crate::output::ModifyClusterOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster: std::option::Option<crate::model::Cluster>,
    }
    impl Builder {
        /// <p>Describes a cluster.</p>
        pub fn cluster(mut self, input: crate::model::Cluster) -> Self {
            self.cluster = Some(input);
            self
        }
        /// <p>Describes a cluster.</p>
        pub fn set_cluster(mut self, input: std::option::Option<crate::model::Cluster>) -> Self {
            self.cluster = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyClusterOutput`](crate::output::ModifyClusterOutput)
        pub fn build(self) -> crate::output::ModifyClusterOutput {
            crate::output::ModifyClusterOutput {
                cluster: self.cluster,
            }
        }
    }
}
impl ModifyClusterOutput {
    /// Creates a new builder-style object to manufacture [`ModifyClusterOutput`](crate::output::ModifyClusterOutput)
    pub fn builder() -> crate::output::modify_cluster_output::Builder {
        crate::output::modify_cluster_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModifyAuthenticationProfileOutput {
    /// <p>The name of the authentication profile that was replaced.</p>
    pub authentication_profile_name: std::option::Option<std::string::String>,
    /// <p>The updated content of the authentication profile in JSON format.</p>
    pub authentication_profile_content: std::option::Option<std::string::String>,
}
impl ModifyAuthenticationProfileOutput {
    /// <p>The name of the authentication profile that was replaced.</p>
    pub fn authentication_profile_name(&self) -> std::option::Option<&str> {
        self.authentication_profile_name.as_deref()
    }
    /// <p>The updated content of the authentication profile in JSON format.</p>
    pub fn authentication_profile_content(&self) -> std::option::Option<&str> {
        self.authentication_profile_content.as_deref()
    }
}
impl std::fmt::Debug for ModifyAuthenticationProfileOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModifyAuthenticationProfileOutput");
        formatter.field(
            "authentication_profile_name",
            &self.authentication_profile_name,
        );
        formatter.field(
            "authentication_profile_content",
            &self.authentication_profile_content,
        );
        formatter.finish()
    }
}
/// See [`ModifyAuthenticationProfileOutput`](crate::output::ModifyAuthenticationProfileOutput)
pub mod modify_authentication_profile_output {
    /// A builder for [`ModifyAuthenticationProfileOutput`](crate::output::ModifyAuthenticationProfileOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authentication_profile_name: std::option::Option<std::string::String>,
        pub(crate) authentication_profile_content: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the authentication profile that was replaced.</p>
        pub fn authentication_profile_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.authentication_profile_name = Some(input.into());
            self
        }
        /// <p>The name of the authentication profile that was replaced.</p>
        pub fn set_authentication_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authentication_profile_name = input;
            self
        }
        /// <p>The updated content of the authentication profile in JSON format.</p>
        pub fn authentication_profile_content(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.authentication_profile_content = Some(input.into());
            self
        }
        /// <p>The updated content of the authentication profile in JSON format.</p>
        pub fn set_authentication_profile_content(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authentication_profile_content = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyAuthenticationProfileOutput`](crate::output::ModifyAuthenticationProfileOutput)
        pub fn build(self) -> crate::output::ModifyAuthenticationProfileOutput {
            crate::output::ModifyAuthenticationProfileOutput {
                authentication_profile_name: self.authentication_profile_name,
                authentication_profile_content: self.authentication_profile_content,
            }
        }
    }
}
impl ModifyAuthenticationProfileOutput {
    /// Creates a new builder-style object to manufacture [`ModifyAuthenticationProfileOutput`](crate::output::ModifyAuthenticationProfileOutput)
    pub fn builder() -> crate::output::modify_authentication_profile_output::Builder {
        crate::output::modify_authentication_profile_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModifyAquaConfigurationOutput {
    /// <p>The updated AQUA configuration of the cluster. </p>
    pub aqua_configuration: std::option::Option<crate::model::AquaConfiguration>,
}
impl ModifyAquaConfigurationOutput {
    /// <p>The updated AQUA configuration of the cluster. </p>
    pub fn aqua_configuration(&self) -> std::option::Option<&crate::model::AquaConfiguration> {
        self.aqua_configuration.as_ref()
    }
}
impl std::fmt::Debug for ModifyAquaConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModifyAquaConfigurationOutput");
        formatter.field("aqua_configuration", &self.aqua_configuration);
        formatter.finish()
    }
}
/// See [`ModifyAquaConfigurationOutput`](crate::output::ModifyAquaConfigurationOutput)
pub mod modify_aqua_configuration_output {
    /// A builder for [`ModifyAquaConfigurationOutput`](crate::output::ModifyAquaConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aqua_configuration: std::option::Option<crate::model::AquaConfiguration>,
    }
    impl Builder {
        /// <p>The updated AQUA configuration of the cluster. </p>
        pub fn aqua_configuration(mut self, input: crate::model::AquaConfiguration) -> Self {
            self.aqua_configuration = Some(input);
            self
        }
        /// <p>The updated AQUA configuration of the cluster. </p>
        pub fn set_aqua_configuration(
            mut self,
            input: std::option::Option<crate::model::AquaConfiguration>,
        ) -> Self {
            self.aqua_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyAquaConfigurationOutput`](crate::output::ModifyAquaConfigurationOutput)
        pub fn build(self) -> crate::output::ModifyAquaConfigurationOutput {
            crate::output::ModifyAquaConfigurationOutput {
                aqua_configuration: self.aqua_configuration,
            }
        }
    }
}
impl ModifyAquaConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`ModifyAquaConfigurationOutput`](crate::output::ModifyAquaConfigurationOutput)
    pub fn builder() -> crate::output::modify_aqua_configuration_output::Builder {
        crate::output::modify_aqua_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetReservedNodeExchangeOfferingsOutput {
    /// <p>An optional parameter that specifies the starting point for returning a set of response records. When the results of a <code>GetReservedNodeExchangeOfferings</code> request exceed the value specified in MaxRecords, Amazon Redshift returns a value in the marker field of the response. You can retrieve the next set of response records by providing the returned marker value in the marker parameter and retrying the request. </p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>Returns an array of <code>ReservedNodeOffering</code> objects.</p>
    pub reserved_node_offerings:
        std::option::Option<std::vec::Vec<crate::model::ReservedNodeOffering>>,
}
impl GetReservedNodeExchangeOfferingsOutput {
    /// <p>An optional parameter that specifies the starting point for returning a set of response records. When the results of a <code>GetReservedNodeExchangeOfferings</code> request exceed the value specified in MaxRecords, Amazon Redshift returns a value in the marker field of the response. You can retrieve the next set of response records by providing the returned marker value in the marker parameter and retrying the request. </p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>Returns an array of <code>ReservedNodeOffering</code> objects.</p>
    pub fn reserved_node_offerings(
        &self,
    ) -> std::option::Option<&[crate::model::ReservedNodeOffering]> {
        self.reserved_node_offerings.as_deref()
    }
}
impl std::fmt::Debug for GetReservedNodeExchangeOfferingsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetReservedNodeExchangeOfferingsOutput");
        formatter.field("marker", &self.marker);
        formatter.field("reserved_node_offerings", &self.reserved_node_offerings);
        formatter.finish()
    }
}
/// See [`GetReservedNodeExchangeOfferingsOutput`](crate::output::GetReservedNodeExchangeOfferingsOutput)
pub mod get_reserved_node_exchange_offerings_output {
    /// A builder for [`GetReservedNodeExchangeOfferingsOutput`](crate::output::GetReservedNodeExchangeOfferingsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) reserved_node_offerings:
            std::option::Option<std::vec::Vec<crate::model::ReservedNodeOffering>>,
    }
    impl Builder {
        /// <p>An optional parameter that specifies the starting point for returning a set of response records. When the results of a <code>GetReservedNodeExchangeOfferings</code> request exceed the value specified in MaxRecords, Amazon Redshift returns a value in the marker field of the response. You can retrieve the next set of response records by providing the returned marker value in the marker parameter and retrying the request. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An optional parameter that specifies the starting point for returning a set of response records. When the results of a <code>GetReservedNodeExchangeOfferings</code> request exceed the value specified in MaxRecords, Amazon Redshift returns a value in the marker field of the response. You can retrieve the next set of response records by providing the returned marker value in the marker parameter and retrying the request. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Appends an item to `reserved_node_offerings`.
        ///
        /// To override the contents of this collection use [`set_reserved_node_offerings`](Self::set_reserved_node_offerings).
        ///
        /// <p>Returns an array of <code>ReservedNodeOffering</code> objects.</p>
        pub fn reserved_node_offerings(
            mut self,
            input: crate::model::ReservedNodeOffering,
        ) -> Self {
            let mut v = self.reserved_node_offerings.unwrap_or_default();
            v.push(input);
            self.reserved_node_offerings = Some(v);
            self
        }
        /// <p>Returns an array of <code>ReservedNodeOffering</code> objects.</p>
        pub fn set_reserved_node_offerings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ReservedNodeOffering>>,
        ) -> Self {
            self.reserved_node_offerings = input;
            self
        }
        /// Consumes the builder and constructs a [`GetReservedNodeExchangeOfferingsOutput`](crate::output::GetReservedNodeExchangeOfferingsOutput)
        pub fn build(self) -> crate::output::GetReservedNodeExchangeOfferingsOutput {
            crate::output::GetReservedNodeExchangeOfferingsOutput {
                marker: self.marker,
                reserved_node_offerings: self.reserved_node_offerings,
            }
        }
    }
}
impl GetReservedNodeExchangeOfferingsOutput {
    /// Creates a new builder-style object to manufacture [`GetReservedNodeExchangeOfferingsOutput`](crate::output::GetReservedNodeExchangeOfferingsOutput)
    pub fn builder() -> crate::output::get_reserved_node_exchange_offerings_output::Builder {
        crate::output::get_reserved_node_exchange_offerings_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetReservedNodeExchangeConfigurationOptionsOutput {
    /// <p>A pagination token provided by a previous <code>GetReservedNodeExchangeConfigurationOptions</code> request.</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>the configuration options for the reserved-node exchange. These options include information about the source reserved node and target reserved node. Details include the node type, the price, the node count, and the offering type.</p>
    pub reserved_node_configuration_option_list:
        std::option::Option<std::vec::Vec<crate::model::ReservedNodeConfigurationOption>>,
}
impl GetReservedNodeExchangeConfigurationOptionsOutput {
    /// <p>A pagination token provided by a previous <code>GetReservedNodeExchangeConfigurationOptions</code> request.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>the configuration options for the reserved-node exchange. These options include information about the source reserved node and target reserved node. Details include the node type, the price, the node count, and the offering type.</p>
    pub fn reserved_node_configuration_option_list(
        &self,
    ) -> std::option::Option<&[crate::model::ReservedNodeConfigurationOption]> {
        self.reserved_node_configuration_option_list.as_deref()
    }
}
impl std::fmt::Debug for GetReservedNodeExchangeConfigurationOptionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetReservedNodeExchangeConfigurationOptionsOutput");
        formatter.field("marker", &self.marker);
        formatter.field(
            "reserved_node_configuration_option_list",
            &self.reserved_node_configuration_option_list,
        );
        formatter.finish()
    }
}
/// See [`GetReservedNodeExchangeConfigurationOptionsOutput`](crate::output::GetReservedNodeExchangeConfigurationOptionsOutput)
pub mod get_reserved_node_exchange_configuration_options_output {
    /// A builder for [`GetReservedNodeExchangeConfigurationOptionsOutput`](crate::output::GetReservedNodeExchangeConfigurationOptionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) reserved_node_configuration_option_list:
            std::option::Option<std::vec::Vec<crate::model::ReservedNodeConfigurationOption>>,
    }
    impl Builder {
        /// <p>A pagination token provided by a previous <code>GetReservedNodeExchangeConfigurationOptions</code> request.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>A pagination token provided by a previous <code>GetReservedNodeExchangeConfigurationOptions</code> request.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Appends an item to `reserved_node_configuration_option_list`.
        ///
        /// To override the contents of this collection use [`set_reserved_node_configuration_option_list`](Self::set_reserved_node_configuration_option_list).
        ///
        /// <p>the configuration options for the reserved-node exchange. These options include information about the source reserved node and target reserved node. Details include the node type, the price, the node count, and the offering type.</p>
        pub fn reserved_node_configuration_option_list(
            mut self,
            input: crate::model::ReservedNodeConfigurationOption,
        ) -> Self {
            let mut v = self
                .reserved_node_configuration_option_list
                .unwrap_or_default();
            v.push(input);
            self.reserved_node_configuration_option_list = Some(v);
            self
        }
        /// <p>the configuration options for the reserved-node exchange. These options include information about the source reserved node and target reserved node. Details include the node type, the price, the node count, and the offering type.</p>
        pub fn set_reserved_node_configuration_option_list(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::ReservedNodeConfigurationOption>,
            >,
        ) -> Self {
            self.reserved_node_configuration_option_list = input;
            self
        }
        /// Consumes the builder and constructs a [`GetReservedNodeExchangeConfigurationOptionsOutput`](crate::output::GetReservedNodeExchangeConfigurationOptionsOutput)
        pub fn build(self) -> crate::output::GetReservedNodeExchangeConfigurationOptionsOutput {
            crate::output::GetReservedNodeExchangeConfigurationOptionsOutput {
                marker: self.marker,
                reserved_node_configuration_option_list: self
                    .reserved_node_configuration_option_list,
            }
        }
    }
}
impl GetReservedNodeExchangeConfigurationOptionsOutput {
    /// Creates a new builder-style object to manufacture [`GetReservedNodeExchangeConfigurationOptionsOutput`](crate::output::GetReservedNodeExchangeConfigurationOptionsOutput)
    pub fn builder(
    ) -> crate::output::get_reserved_node_exchange_configuration_options_output::Builder {
        crate::output::get_reserved_node_exchange_configuration_options_output::Builder::default()
    }
}

/// <p>Temporary credentials with authorization to log on to an Amazon Redshift database. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetClusterCredentialsOutput {
    /// <p>A database user name that is authorized to log on to the database <code>DbName</code> using the password <code>DbPassword</code>. If the specified DbUser exists in the database, the new user name has the same database privileges as the the user named in DbUser. By default, the user is added to PUBLIC. If the <code>DbGroups</code> parameter is specifed, <code>DbUser</code> is added to the listed groups for any sessions created using these credentials.</p>
    pub db_user: std::option::Option<std::string::String>,
    /// <p>A temporary password that authorizes the user name returned by <code>DbUser</code> to log on to the database <code>DbName</code>. </p>
    pub db_password: std::option::Option<std::string::String>,
    /// <p>The date and time the password in <code>DbPassword</code> expires.</p>
    pub expiration: std::option::Option<aws_smithy_types::DateTime>,
}
impl GetClusterCredentialsOutput {
    /// <p>A database user name that is authorized to log on to the database <code>DbName</code> using the password <code>DbPassword</code>. If the specified DbUser exists in the database, the new user name has the same database privileges as the the user named in DbUser. By default, the user is added to PUBLIC. If the <code>DbGroups</code> parameter is specifed, <code>DbUser</code> is added to the listed groups for any sessions created using these credentials.</p>
    pub fn db_user(&self) -> std::option::Option<&str> {
        self.db_user.as_deref()
    }
    /// <p>A temporary password that authorizes the user name returned by <code>DbUser</code> to log on to the database <code>DbName</code>. </p>
    pub fn db_password(&self) -> std::option::Option<&str> {
        self.db_password.as_deref()
    }
    /// <p>The date and time the password in <code>DbPassword</code> expires.</p>
    pub fn expiration(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.expiration.as_ref()
    }
}
impl std::fmt::Debug for GetClusterCredentialsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetClusterCredentialsOutput");
        formatter.field("db_user", &self.db_user);
        formatter.field("db_password", &"*** Sensitive Data Redacted ***");
        formatter.field("expiration", &self.expiration);
        formatter.finish()
    }
}
/// See [`GetClusterCredentialsOutput`](crate::output::GetClusterCredentialsOutput)
pub mod get_cluster_credentials_output {
    /// A builder for [`GetClusterCredentialsOutput`](crate::output::GetClusterCredentialsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_user: std::option::Option<std::string::String>,
        pub(crate) db_password: std::option::Option<std::string::String>,
        pub(crate) expiration: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>A database user name that is authorized to log on to the database <code>DbName</code> using the password <code>DbPassword</code>. If the specified DbUser exists in the database, the new user name has the same database privileges as the the user named in DbUser. By default, the user is added to PUBLIC. If the <code>DbGroups</code> parameter is specifed, <code>DbUser</code> is added to the listed groups for any sessions created using these credentials.</p>
        pub fn db_user(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_user = Some(input.into());
            self
        }
        /// <p>A database user name that is authorized to log on to the database <code>DbName</code> using the password <code>DbPassword</code>. If the specified DbUser exists in the database, the new user name has the same database privileges as the the user named in DbUser. By default, the user is added to PUBLIC. If the <code>DbGroups</code> parameter is specifed, <code>DbUser</code> is added to the listed groups for any sessions created using these credentials.</p>
        pub fn set_db_user(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.db_user = input;
            self
        }
        /// <p>A temporary password that authorizes the user name returned by <code>DbUser</code> to log on to the database <code>DbName</code>. </p>
        pub fn db_password(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_password = Some(input.into());
            self
        }
        /// <p>A temporary password that authorizes the user name returned by <code>DbUser</code> to log on to the database <code>DbName</code>. </p>
        pub fn set_db_password(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.db_password = input;
            self
        }
        /// <p>The date and time the password in <code>DbPassword</code> expires.</p>
        pub fn expiration(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.expiration = Some(input);
            self
        }
        /// <p>The date and time the password in <code>DbPassword</code> expires.</p>
        pub fn set_expiration(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.expiration = input;
            self
        }
        /// Consumes the builder and constructs a [`GetClusterCredentialsOutput`](crate::output::GetClusterCredentialsOutput)
        pub fn build(self) -> crate::output::GetClusterCredentialsOutput {
            crate::output::GetClusterCredentialsOutput {
                db_user: self.db_user,
                db_password: self.db_password,
                expiration: self.expiration,
            }
        }
    }
}
impl GetClusterCredentialsOutput {
    /// Creates a new builder-style object to manufacture [`GetClusterCredentialsOutput`](crate::output::GetClusterCredentialsOutput)
    pub fn builder() -> crate::output::get_cluster_credentials_output::Builder {
        crate::output::get_cluster_credentials_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EnableSnapshotCopyOutput {
    /// <p>Describes a cluster.</p>
    pub cluster: std::option::Option<crate::model::Cluster>,
}
impl EnableSnapshotCopyOutput {
    /// <p>Describes a cluster.</p>
    pub fn cluster(&self) -> std::option::Option<&crate::model::Cluster> {
        self.cluster.as_ref()
    }
}
impl std::fmt::Debug for EnableSnapshotCopyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EnableSnapshotCopyOutput");
        formatter.field("cluster", &self.cluster);
        formatter.finish()
    }
}
/// See [`EnableSnapshotCopyOutput`](crate::output::EnableSnapshotCopyOutput)
pub mod enable_snapshot_copy_output {
    /// A builder for [`EnableSnapshotCopyOutput`](crate::output::EnableSnapshotCopyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster: std::option::Option<crate::model::Cluster>,
    }
    impl Builder {
        /// <p>Describes a cluster.</p>
        pub fn cluster(mut self, input: crate::model::Cluster) -> Self {
            self.cluster = Some(input);
            self
        }
        /// <p>Describes a cluster.</p>
        pub fn set_cluster(mut self, input: std::option::Option<crate::model::Cluster>) -> Self {
            self.cluster = input;
            self
        }
        /// Consumes the builder and constructs a [`EnableSnapshotCopyOutput`](crate::output::EnableSnapshotCopyOutput)
        pub fn build(self) -> crate::output::EnableSnapshotCopyOutput {
            crate::output::EnableSnapshotCopyOutput {
                cluster: self.cluster,
            }
        }
    }
}
impl EnableSnapshotCopyOutput {
    /// Creates a new builder-style object to manufacture [`EnableSnapshotCopyOutput`](crate::output::EnableSnapshotCopyOutput)
    pub fn builder() -> crate::output::enable_snapshot_copy_output::Builder {
        crate::output::enable_snapshot_copy_output::Builder::default()
    }
}

/// <p>Describes the status of logging for a cluster.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EnableLoggingOutput {
    /// <p> <code>true</code> if logging is on, <code>false</code> if logging is off.</p>
    pub logging_enabled: bool,
    /// <p>The name of the S3 bucket where the log files are stored.</p>
    pub bucket_name: std::option::Option<std::string::String>,
    /// <p>The prefix applied to the log file names.</p>
    pub s3_key_prefix: std::option::Option<std::string::String>,
    /// <p>The last time that logs were delivered.</p>
    pub last_successful_delivery_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The last time when logs failed to be delivered.</p>
    pub last_failure_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The message indicating that logs failed to be delivered.</p>
    pub last_failure_message: std::option::Option<std::string::String>,
}
impl EnableLoggingOutput {
    /// <p> <code>true</code> if logging is on, <code>false</code> if logging is off.</p>
    pub fn logging_enabled(&self) -> bool {
        self.logging_enabled
    }
    /// <p>The name of the S3 bucket where the log files are stored.</p>
    pub fn bucket_name(&self) -> std::option::Option<&str> {
        self.bucket_name.as_deref()
    }
    /// <p>The prefix applied to the log file names.</p>
    pub fn s3_key_prefix(&self) -> std::option::Option<&str> {
        self.s3_key_prefix.as_deref()
    }
    /// <p>The last time that logs were delivered.</p>
    pub fn last_successful_delivery_time(
        &self,
    ) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_successful_delivery_time.as_ref()
    }
    /// <p>The last time when logs failed to be delivered.</p>
    pub fn last_failure_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_failure_time.as_ref()
    }
    /// <p>The message indicating that logs failed to be delivered.</p>
    pub fn last_failure_message(&self) -> std::option::Option<&str> {
        self.last_failure_message.as_deref()
    }
}
impl std::fmt::Debug for EnableLoggingOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EnableLoggingOutput");
        formatter.field("logging_enabled", &self.logging_enabled);
        formatter.field("bucket_name", &self.bucket_name);
        formatter.field("s3_key_prefix", &self.s3_key_prefix);
        formatter.field(
            "last_successful_delivery_time",
            &self.last_successful_delivery_time,
        );
        formatter.field("last_failure_time", &self.last_failure_time);
        formatter.field("last_failure_message", &self.last_failure_message);
        formatter.finish()
    }
}
/// See [`EnableLoggingOutput`](crate::output::EnableLoggingOutput)
pub mod enable_logging_output {
    /// A builder for [`EnableLoggingOutput`](crate::output::EnableLoggingOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) logging_enabled: std::option::Option<bool>,
        pub(crate) bucket_name: std::option::Option<std::string::String>,
        pub(crate) s3_key_prefix: std::option::Option<std::string::String>,
        pub(crate) last_successful_delivery_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_failure_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_failure_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> <code>true</code> if logging is on, <code>false</code> if logging is off.</p>
        pub fn logging_enabled(mut self, input: bool) -> Self {
            self.logging_enabled = Some(input);
            self
        }
        /// <p> <code>true</code> if logging is on, <code>false</code> if logging is off.</p>
        pub fn set_logging_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.logging_enabled = input;
            self
        }
        /// <p>The name of the S3 bucket where the log files are stored.</p>
        pub fn bucket_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket_name = Some(input.into());
            self
        }
        /// <p>The name of the S3 bucket where the log files are stored.</p>
        pub fn set_bucket_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket_name = input;
            self
        }
        /// <p>The prefix applied to the log file names.</p>
        pub fn s3_key_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_key_prefix = Some(input.into());
            self
        }
        /// <p>The prefix applied to the log file names.</p>
        pub fn set_s3_key_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.s3_key_prefix = input;
            self
        }
        /// <p>The last time that logs were delivered.</p>
        pub fn last_successful_delivery_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_successful_delivery_time = Some(input);
            self
        }
        /// <p>The last time that logs were delivered.</p>
        pub fn set_last_successful_delivery_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_successful_delivery_time = input;
            self
        }
        /// <p>The last time when logs failed to be delivered.</p>
        pub fn last_failure_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_failure_time = Some(input);
            self
        }
        /// <p>The last time when logs failed to be delivered.</p>
        pub fn set_last_failure_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_failure_time = input;
            self
        }
        /// <p>The message indicating that logs failed to be delivered.</p>
        pub fn last_failure_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_failure_message = Some(input.into());
            self
        }
        /// <p>The message indicating that logs failed to be delivered.</p>
        pub fn set_last_failure_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_failure_message = input;
            self
        }
        /// Consumes the builder and constructs a [`EnableLoggingOutput`](crate::output::EnableLoggingOutput)
        pub fn build(self) -> crate::output::EnableLoggingOutput {
            crate::output::EnableLoggingOutput {
                logging_enabled: self.logging_enabled.unwrap_or_default(),
                bucket_name: self.bucket_name,
                s3_key_prefix: self.s3_key_prefix,
                last_successful_delivery_time: self.last_successful_delivery_time,
                last_failure_time: self.last_failure_time,
                last_failure_message: self.last_failure_message,
            }
        }
    }
}
impl EnableLoggingOutput {
    /// Creates a new builder-style object to manufacture [`EnableLoggingOutput`](crate::output::EnableLoggingOutput)
    pub fn builder() -> crate::output::enable_logging_output::Builder {
        crate::output::enable_logging_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateDataShareConsumerOutput {
    /// <p>An Amazon Resource Name (ARN) that references the datashare that is owned by a specific namespace of the producer cluster. A datashare ARN is in the <code>arn:aws:redshift:{region}:{account-id}:{datashare}:{namespace-guid}/{datashare-name}</code> format.</p>
    pub data_share_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the producer.</p>
    pub producer_arn: std::option::Option<std::string::String>,
    /// <p>A value that specifies whether the datashare can be shared to a publicly accessible cluster.</p>
    pub allow_publicly_accessible_consumers: bool,
    /// <p>A value that specifies when the datashare has an association between a producer and data consumers.</p>
    pub data_share_associations:
        std::option::Option<std::vec::Vec<crate::model::DataShareAssociation>>,
    /// <p>The identifier of a datashare to show its managing entity.</p>
    pub managed_by: std::option::Option<std::string::String>,
}
impl DisassociateDataShareConsumerOutput {
    /// <p>An Amazon Resource Name (ARN) that references the datashare that is owned by a specific namespace of the producer cluster. A datashare ARN is in the <code>arn:aws:redshift:{region}:{account-id}:{datashare}:{namespace-guid}/{datashare-name}</code> format.</p>
    pub fn data_share_arn(&self) -> std::option::Option<&str> {
        self.data_share_arn.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the producer.</p>
    pub fn producer_arn(&self) -> std::option::Option<&str> {
        self.producer_arn.as_deref()
    }
    /// <p>A value that specifies whether the datashare can be shared to a publicly accessible cluster.</p>
    pub fn allow_publicly_accessible_consumers(&self) -> bool {
        self.allow_publicly_accessible_consumers
    }
    /// <p>A value that specifies when the datashare has an association between a producer and data consumers.</p>
    pub fn data_share_associations(
        &self,
    ) -> std::option::Option<&[crate::model::DataShareAssociation]> {
        self.data_share_associations.as_deref()
    }
    /// <p>The identifier of a datashare to show its managing entity.</p>
    pub fn managed_by(&self) -> std::option::Option<&str> {
        self.managed_by.as_deref()
    }
}
impl std::fmt::Debug for DisassociateDataShareConsumerOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateDataShareConsumerOutput");
        formatter.field("data_share_arn", &self.data_share_arn);
        formatter.field("producer_arn", &self.producer_arn);
        formatter.field(
            "allow_publicly_accessible_consumers",
            &self.allow_publicly_accessible_consumers,
        );
        formatter.field("data_share_associations", &self.data_share_associations);
        formatter.field("managed_by", &self.managed_by);
        formatter.finish()
    }
}
/// See [`DisassociateDataShareConsumerOutput`](crate::output::DisassociateDataShareConsumerOutput)
pub mod disassociate_data_share_consumer_output {
    /// A builder for [`DisassociateDataShareConsumerOutput`](crate::output::DisassociateDataShareConsumerOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data_share_arn: std::option::Option<std::string::String>,
        pub(crate) producer_arn: std::option::Option<std::string::String>,
        pub(crate) allow_publicly_accessible_consumers: std::option::Option<bool>,
        pub(crate) data_share_associations:
            std::option::Option<std::vec::Vec<crate::model::DataShareAssociation>>,
        pub(crate) managed_by: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>An Amazon Resource Name (ARN) that references the datashare that is owned by a specific namespace of the producer cluster. A datashare ARN is in the <code>arn:aws:redshift:{region}:{account-id}:{datashare}:{namespace-guid}/{datashare-name}</code> format.</p>
        pub fn data_share_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_share_arn = Some(input.into());
            self
        }
        /// <p>An Amazon Resource Name (ARN) that references the datashare that is owned by a specific namespace of the producer cluster. A datashare ARN is in the <code>arn:aws:redshift:{region}:{account-id}:{datashare}:{namespace-guid}/{datashare-name}</code> format.</p>
        pub fn set_data_share_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_share_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the producer.</p>
        pub fn producer_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.producer_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the producer.</p>
        pub fn set_producer_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.producer_arn = input;
            self
        }
        /// <p>A value that specifies whether the datashare can be shared to a publicly accessible cluster.</p>
        pub fn allow_publicly_accessible_consumers(mut self, input: bool) -> Self {
            self.allow_publicly_accessible_consumers = Some(input);
            self
        }
        /// <p>A value that specifies whether the datashare can be shared to a publicly accessible cluster.</p>
        pub fn set_allow_publicly_accessible_consumers(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.allow_publicly_accessible_consumers = input;
            self
        }
        /// Appends an item to `data_share_associations`.
        ///
        /// To override the contents of this collection use [`set_data_share_associations`](Self::set_data_share_associations).
        ///
        /// <p>A value that specifies when the datashare has an association between a producer and data consumers.</p>
        pub fn data_share_associations(
            mut self,
            input: crate::model::DataShareAssociation,
        ) -> Self {
            let mut v = self.data_share_associations.unwrap_or_default();
            v.push(input);
            self.data_share_associations = Some(v);
            self
        }
        /// <p>A value that specifies when the datashare has an association between a producer and data consumers.</p>
        pub fn set_data_share_associations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DataShareAssociation>>,
        ) -> Self {
            self.data_share_associations = input;
            self
        }
        /// <p>The identifier of a datashare to show its managing entity.</p>
        pub fn managed_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.managed_by = Some(input.into());
            self
        }
        /// <p>The identifier of a datashare to show its managing entity.</p>
        pub fn set_managed_by(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.managed_by = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateDataShareConsumerOutput`](crate::output::DisassociateDataShareConsumerOutput)
        pub fn build(self) -> crate::output::DisassociateDataShareConsumerOutput {
            crate::output::DisassociateDataShareConsumerOutput {
                data_share_arn: self.data_share_arn,
                producer_arn: self.producer_arn,
                allow_publicly_accessible_consumers: self
                    .allow_publicly_accessible_consumers
                    .unwrap_or_default(),
                data_share_associations: self.data_share_associations,
                managed_by: self.managed_by,
            }
        }
    }
}
impl DisassociateDataShareConsumerOutput {
    /// Creates a new builder-style object to manufacture [`DisassociateDataShareConsumerOutput`](crate::output::DisassociateDataShareConsumerOutput)
    pub fn builder() -> crate::output::disassociate_data_share_consumer_output::Builder {
        crate::output::disassociate_data_share_consumer_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisableSnapshotCopyOutput {
    /// <p>Describes a cluster.</p>
    pub cluster: std::option::Option<crate::model::Cluster>,
}
impl DisableSnapshotCopyOutput {
    /// <p>Describes a cluster.</p>
    pub fn cluster(&self) -> std::option::Option<&crate::model::Cluster> {
        self.cluster.as_ref()
    }
}
impl std::fmt::Debug for DisableSnapshotCopyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisableSnapshotCopyOutput");
        formatter.field("cluster", &self.cluster);
        formatter.finish()
    }
}
/// See [`DisableSnapshotCopyOutput`](crate::output::DisableSnapshotCopyOutput)
pub mod disable_snapshot_copy_output {
    /// A builder for [`DisableSnapshotCopyOutput`](crate::output::DisableSnapshotCopyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster: std::option::Option<crate::model::Cluster>,
    }
    impl Builder {
        /// <p>Describes a cluster.</p>
        pub fn cluster(mut self, input: crate::model::Cluster) -> Self {
            self.cluster = Some(input);
            self
        }
        /// <p>Describes a cluster.</p>
        pub fn set_cluster(mut self, input: std::option::Option<crate::model::Cluster>) -> Self {
            self.cluster = input;
            self
        }
        /// Consumes the builder and constructs a [`DisableSnapshotCopyOutput`](crate::output::DisableSnapshotCopyOutput)
        pub fn build(self) -> crate::output::DisableSnapshotCopyOutput {
            crate::output::DisableSnapshotCopyOutput {
                cluster: self.cluster,
            }
        }
    }
}
impl DisableSnapshotCopyOutput {
    /// Creates a new builder-style object to manufacture [`DisableSnapshotCopyOutput`](crate::output::DisableSnapshotCopyOutput)
    pub fn builder() -> crate::output::disable_snapshot_copy_output::Builder {
        crate::output::disable_snapshot_copy_output::Builder::default()
    }
}

/// <p>Describes the status of logging for a cluster.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisableLoggingOutput {
    /// <p> <code>true</code> if logging is on, <code>false</code> if logging is off.</p>
    pub logging_enabled: bool,
    /// <p>The name of the S3 bucket where the log files are stored.</p>
    pub bucket_name: std::option::Option<std::string::String>,
    /// <p>The prefix applied to the log file names.</p>
    pub s3_key_prefix: std::option::Option<std::string::String>,
    /// <p>The last time that logs were delivered.</p>
    pub last_successful_delivery_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The last time when logs failed to be delivered.</p>
    pub last_failure_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The message indicating that logs failed to be delivered.</p>
    pub last_failure_message: std::option::Option<std::string::String>,
}
impl DisableLoggingOutput {
    /// <p> <code>true</code> if logging is on, <code>false</code> if logging is off.</p>
    pub fn logging_enabled(&self) -> bool {
        self.logging_enabled
    }
    /// <p>The name of the S3 bucket where the log files are stored.</p>
    pub fn bucket_name(&self) -> std::option::Option<&str> {
        self.bucket_name.as_deref()
    }
    /// <p>The prefix applied to the log file names.</p>
    pub fn s3_key_prefix(&self) -> std::option::Option<&str> {
        self.s3_key_prefix.as_deref()
    }
    /// <p>The last time that logs were delivered.</p>
    pub fn last_successful_delivery_time(
        &self,
    ) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_successful_delivery_time.as_ref()
    }
    /// <p>The last time when logs failed to be delivered.</p>
    pub fn last_failure_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_failure_time.as_ref()
    }
    /// <p>The message indicating that logs failed to be delivered.</p>
    pub fn last_failure_message(&self) -> std::option::Option<&str> {
        self.last_failure_message.as_deref()
    }
}
impl std::fmt::Debug for DisableLoggingOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisableLoggingOutput");
        formatter.field("logging_enabled", &self.logging_enabled);
        formatter.field("bucket_name", &self.bucket_name);
        formatter.field("s3_key_prefix", &self.s3_key_prefix);
        formatter.field(
            "last_successful_delivery_time",
            &self.last_successful_delivery_time,
        );
        formatter.field("last_failure_time", &self.last_failure_time);
        formatter.field("last_failure_message", &self.last_failure_message);
        formatter.finish()
    }
}
/// See [`DisableLoggingOutput`](crate::output::DisableLoggingOutput)
pub mod disable_logging_output {
    /// A builder for [`DisableLoggingOutput`](crate::output::DisableLoggingOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) logging_enabled: std::option::Option<bool>,
        pub(crate) bucket_name: std::option::Option<std::string::String>,
        pub(crate) s3_key_prefix: std::option::Option<std::string::String>,
        pub(crate) last_successful_delivery_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_failure_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_failure_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> <code>true</code> if logging is on, <code>false</code> if logging is off.</p>
        pub fn logging_enabled(mut self, input: bool) -> Self {
            self.logging_enabled = Some(input);
            self
        }
        /// <p> <code>true</code> if logging is on, <code>false</code> if logging is off.</p>
        pub fn set_logging_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.logging_enabled = input;
            self
        }
        /// <p>The name of the S3 bucket where the log files are stored.</p>
        pub fn bucket_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket_name = Some(input.into());
            self
        }
        /// <p>The name of the S3 bucket where the log files are stored.</p>
        pub fn set_bucket_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket_name = input;
            self
        }
        /// <p>The prefix applied to the log file names.</p>
        pub fn s3_key_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_key_prefix = Some(input.into());
            self
        }
        /// <p>The prefix applied to the log file names.</p>
        pub fn set_s3_key_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.s3_key_prefix = input;
            self
        }
        /// <p>The last time that logs were delivered.</p>
        pub fn last_successful_delivery_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_successful_delivery_time = Some(input);
            self
        }
        /// <p>The last time that logs were delivered.</p>
        pub fn set_last_successful_delivery_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_successful_delivery_time = input;
            self
        }
        /// <p>The last time when logs failed to be delivered.</p>
        pub fn last_failure_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_failure_time = Some(input);
            self
        }
        /// <p>The last time when logs failed to be delivered.</p>
        pub fn set_last_failure_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_failure_time = input;
            self
        }
        /// <p>The message indicating that logs failed to be delivered.</p>
        pub fn last_failure_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_failure_message = Some(input.into());
            self
        }
        /// <p>The message indicating that logs failed to be delivered.</p>
        pub fn set_last_failure_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_failure_message = input;
            self
        }
        /// Consumes the builder and constructs a [`DisableLoggingOutput`](crate::output::DisableLoggingOutput)
        pub fn build(self) -> crate::output::DisableLoggingOutput {
            crate::output::DisableLoggingOutput {
                logging_enabled: self.logging_enabled.unwrap_or_default(),
                bucket_name: self.bucket_name,
                s3_key_prefix: self.s3_key_prefix,
                last_successful_delivery_time: self.last_successful_delivery_time,
                last_failure_time: self.last_failure_time,
                last_failure_message: self.last_failure_message,
            }
        }
    }
}
impl DisableLoggingOutput {
    /// Creates a new builder-style object to manufacture [`DisableLoggingOutput`](crate::output::DisableLoggingOutput)
    pub fn builder() -> crate::output::disable_logging_output::Builder {
        crate::output::disable_logging_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeUsageLimitsOutput {
    /// <p>Contains the output from the <code>DescribeUsageLimits</code> action. </p>
    pub usage_limits: std::option::Option<std::vec::Vec<crate::model::UsageLimit>>,
    /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>
    pub marker: std::option::Option<std::string::String>,
}
impl DescribeUsageLimitsOutput {
    /// <p>Contains the output from the <code>DescribeUsageLimits</code> action. </p>
    pub fn usage_limits(&self) -> std::option::Option<&[crate::model::UsageLimit]> {
        self.usage_limits.as_deref()
    }
    /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for DescribeUsageLimitsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeUsageLimitsOutput");
        formatter.field("usage_limits", &self.usage_limits);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}
/// See [`DescribeUsageLimitsOutput`](crate::output::DescribeUsageLimitsOutput)
pub mod describe_usage_limits_output {
    /// A builder for [`DescribeUsageLimitsOutput`](crate::output::DescribeUsageLimitsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) usage_limits: std::option::Option<std::vec::Vec<crate::model::UsageLimit>>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `usage_limits`.
        ///
        /// To override the contents of this collection use [`set_usage_limits`](Self::set_usage_limits).
        ///
        /// <p>Contains the output from the <code>DescribeUsageLimits</code> action. </p>
        pub fn usage_limits(mut self, input: crate::model::UsageLimit) -> Self {
            let mut v = self.usage_limits.unwrap_or_default();
            v.push(input);
            self.usage_limits = Some(v);
            self
        }
        /// <p>Contains the output from the <code>DescribeUsageLimits</code> action. </p>
        pub fn set_usage_limits(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UsageLimit>>,
        ) -> Self {
            self.usage_limits = input;
            self
        }
        /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeUsageLimitsOutput`](crate::output::DescribeUsageLimitsOutput)
        pub fn build(self) -> crate::output::DescribeUsageLimitsOutput {
            crate::output::DescribeUsageLimitsOutput {
                usage_limits: self.usage_limits,
                marker: self.marker,
            }
        }
    }
}
impl DescribeUsageLimitsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeUsageLimitsOutput`](crate::output::DescribeUsageLimitsOutput)
    pub fn builder() -> crate::output::describe_usage_limits_output::Builder {
        crate::output::describe_usage_limits_output::Builder::default()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeTagsOutput {
    /// <p>A list of tags with their associated resources.</p>
    pub tagged_resources: std::option::Option<std::vec::Vec<crate::model::TaggedResource>>,
    /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>
    pub marker: std::option::Option<std::string::String>,
}
impl DescribeTagsOutput {
    /// <p>A list of tags with their associated resources.</p>
    pub fn tagged_resources(&self) -> std::option::Option<&[crate::model::TaggedResource]> {
        self.tagged_resources.as_deref()
    }
    /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for DescribeTagsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeTagsOutput");
        formatter.field("tagged_resources", &self.tagged_resources);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}
/// See [`DescribeTagsOutput`](crate::output::DescribeTagsOutput)
pub mod describe_tags_output {
    /// A builder for [`DescribeTagsOutput`](crate::output::DescribeTagsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tagged_resources:
            std::option::Option<std::vec::Vec<crate::model::TaggedResource>>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `tagged_resources`.
        ///
        /// To override the contents of this collection use [`set_tagged_resources`](Self::set_tagged_resources).
        ///
        /// <p>A list of tags with their associated resources.</p>
        pub fn tagged_resources(mut self, input: crate::model::TaggedResource) -> Self {
            let mut v = self.tagged_resources.unwrap_or_default();
            v.push(input);
            self.tagged_resources = Some(v);
            self
        }
        /// <p>A list of tags with their associated resources.</p>
        pub fn set_tagged_resources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TaggedResource>>,
        ) -> Self {
            self.tagged_resources = input;
            self
        }
        /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeTagsOutput`](crate::output::DescribeTagsOutput)
        pub fn build(self) -> crate::output::DescribeTagsOutput {
            crate::output::DescribeTagsOutput {
                tagged_resources: self.tagged_resources,
                marker: self.marker,
            }
        }
    }
}
impl DescribeTagsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeTagsOutput`](crate::output::DescribeTagsOutput)
    pub fn builder() -> crate::output::describe_tags_output::Builder {
        crate::output::describe_tags_output::Builder::default()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeTableRestoreStatusOutput {
    /// <p>A list of status details for one or more table restore requests.</p>
    pub table_restore_status_details:
        std::option::Option<std::vec::Vec<crate::model::TableRestoreStatus>>,
    /// <p>A pagination token that can be used in a subsequent <code>DescribeTableRestoreStatus</code> request.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl DescribeTableRestoreStatusOutput {
    /// <p>A list of status details for one or more table restore requests.</p>
    pub fn table_restore_status_details(
        &self,
    ) -> std::option::Option<&[crate::model::TableRestoreStatus]> {
        self.table_restore_status_details.as_deref()
    }
    /// <p>A pagination token that can be used in a subsequent <code>DescribeTableRestoreStatus</code> request.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for DescribeTableRestoreStatusOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeTableRestoreStatusOutput");
        formatter.field(
            "table_restore_status_details",
            &self.table_restore_status_details,
        );
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}
/// See [`DescribeTableRestoreStatusOutput`](crate::output::DescribeTableRestoreStatusOutput)
pub mod describe_table_restore_status_output {
    /// A builder for [`DescribeTableRestoreStatusOutput`](crate::output::DescribeTableRestoreStatusOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) table_restore_status_details:
            std::option::Option<std::vec::Vec<crate::model::TableRestoreStatus>>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `table_restore_status_details`.
        ///
        /// To override the contents of this collection use [`set_table_restore_status_details`](Self::set_table_restore_status_details).
        ///
        /// <p>A list of status details for one or more table restore requests.</p>
        pub fn table_restore_status_details(
            mut self,
            input: crate::model::TableRestoreStatus,
        ) -> Self {
            let mut v = self.table_restore_status_details.unwrap_or_default();
            v.push(input);
            self.table_restore_status_details = Some(v);
            self
        }
        /// <p>A list of status details for one or more table restore requests.</p>
        pub fn set_table_restore_status_details(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TableRestoreStatus>>,
        ) -> Self {
            self.table_restore_status_details = input;
            self
        }
        /// <p>A pagination token that can be used in a subsequent <code>DescribeTableRestoreStatus</code> request.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>A pagination token that can be used in a subsequent <code>DescribeTableRestoreStatus</code> request.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeTableRestoreStatusOutput`](crate::output::DescribeTableRestoreStatusOutput)
        pub fn build(self) -> crate::output::DescribeTableRestoreStatusOutput {
            crate::output::DescribeTableRestoreStatusOutput {
                table_restore_status_details: self.table_restore_status_details,
                marker: self.marker,
            }
        }
    }
}
impl DescribeTableRestoreStatusOutput {
    /// Creates a new builder-style object to manufacture [`DescribeTableRestoreStatusOutput`](crate::output::DescribeTableRestoreStatusOutput)
    pub fn builder() -> crate::output::describe_table_restore_status_output::Builder {
        crate::output::describe_table_restore_status_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeStorageOutput {
    /// <p>The total amount of storage currently used for snapshots.</p>
    pub total_backup_size_in_mega_bytes: f64,
    /// <p>The total amount of storage currently provisioned.</p>
    pub total_provisioned_storage_in_mega_bytes: f64,
}
impl DescribeStorageOutput {
    /// <p>The total amount of storage currently used for snapshots.</p>
    pub fn total_backup_size_in_mega_bytes(&self) -> f64 {
        self.total_backup_size_in_mega_bytes
    }
    /// <p>The total amount of storage currently provisioned.</p>
    pub fn total_provisioned_storage_in_mega_bytes(&self) -> f64 {
        self.total_provisioned_storage_in_mega_bytes
    }
}
impl std::fmt::Debug for DescribeStorageOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeStorageOutput");
        formatter.field(
            "total_backup_size_in_mega_bytes",
            &self.total_backup_size_in_mega_bytes,
        );
        formatter.field(
            "total_provisioned_storage_in_mega_bytes",
            &self.total_provisioned_storage_in_mega_bytes,
        );
        formatter.finish()
    }
}
/// See [`DescribeStorageOutput`](crate::output::DescribeStorageOutput)
pub mod describe_storage_output {
    /// A builder for [`DescribeStorageOutput`](crate::output::DescribeStorageOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) total_backup_size_in_mega_bytes: std::option::Option<f64>,
        pub(crate) total_provisioned_storage_in_mega_bytes: std::option::Option<f64>,
    }
    impl Builder {
        /// <p>The total amount of storage currently used for snapshots.</p>
        pub fn total_backup_size_in_mega_bytes(mut self, input: f64) -> Self {
            self.total_backup_size_in_mega_bytes = Some(input);
            self
        }
        /// <p>The total amount of storage currently used for snapshots.</p>
        pub fn set_total_backup_size_in_mega_bytes(
            mut self,
            input: std::option::Option<f64>,
        ) -> Self {
            self.total_backup_size_in_mega_bytes = input;
            self
        }
        /// <p>The total amount of storage currently provisioned.</p>
        pub fn total_provisioned_storage_in_mega_bytes(mut self, input: f64) -> Self {
            self.total_provisioned_storage_in_mega_bytes = Some(input);
            self
        }
        /// <p>The total amount of storage currently provisioned.</p>
        pub fn set_total_provisioned_storage_in_mega_bytes(
            mut self,
            input: std::option::Option<f64>,
        ) -> Self {
            self.total_provisioned_storage_in_mega_bytes = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeStorageOutput`](crate::output::DescribeStorageOutput)
        pub fn build(self) -> crate::output::DescribeStorageOutput {
            crate::output::DescribeStorageOutput {
                total_backup_size_in_mega_bytes: self
                    .total_backup_size_in_mega_bytes
                    .unwrap_or_default(),
                total_provisioned_storage_in_mega_bytes: self
                    .total_provisioned_storage_in_mega_bytes
                    .unwrap_or_default(),
            }
        }
    }
}
impl DescribeStorageOutput {
    /// Creates a new builder-style object to manufacture [`DescribeStorageOutput`](crate::output::DescribeStorageOutput)
    pub fn builder() -> crate::output::describe_storage_output::Builder {
        crate::output::describe_storage_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeSnapshotSchedulesOutput {
    /// <p>A list of SnapshotSchedules.</p>
    pub snapshot_schedules: std::option::Option<std::vec::Vec<crate::model::SnapshotSchedule>>,
    /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>marker</code> parameter and retrying the command. If the <code>marker</code> field is empty, all response records have been retrieved for the request.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl DescribeSnapshotSchedulesOutput {
    /// <p>A list of SnapshotSchedules.</p>
    pub fn snapshot_schedules(&self) -> std::option::Option<&[crate::model::SnapshotSchedule]> {
        self.snapshot_schedules.as_deref()
    }
    /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>marker</code> parameter and retrying the command. If the <code>marker</code> field is empty, all response records have been retrieved for the request.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for DescribeSnapshotSchedulesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeSnapshotSchedulesOutput");
        formatter.field("snapshot_schedules", &self.snapshot_schedules);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}
/// See [`DescribeSnapshotSchedulesOutput`](crate::output::DescribeSnapshotSchedulesOutput)
pub mod describe_snapshot_schedules_output {
    /// A builder for [`DescribeSnapshotSchedulesOutput`](crate::output::DescribeSnapshotSchedulesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) snapshot_schedules:
            std::option::Option<std::vec::Vec<crate::model::SnapshotSchedule>>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `snapshot_schedules`.
        ///
        /// To override the contents of this collection use [`set_snapshot_schedules`](Self::set_snapshot_schedules).
        ///
        /// <p>A list of SnapshotSchedules.</p>
        pub fn snapshot_schedules(mut self, input: crate::model::SnapshotSchedule) -> Self {
            let mut v = self.snapshot_schedules.unwrap_or_default();
            v.push(input);
            self.snapshot_schedules = Some(v);
            self
        }
        /// <p>A list of SnapshotSchedules.</p>
        pub fn set_snapshot_schedules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SnapshotSchedule>>,
        ) -> Self {
            self.snapshot_schedules = input;
            self
        }
        /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>marker</code> parameter and retrying the command. If the <code>marker</code> field is empty, all response records have been retrieved for the request.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>marker</code> parameter and retrying the command. If the <code>marker</code> field is empty, all response records have been retrieved for the request.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeSnapshotSchedulesOutput`](crate::output::DescribeSnapshotSchedulesOutput)
        pub fn build(self) -> crate::output::DescribeSnapshotSchedulesOutput {
            crate::output::DescribeSnapshotSchedulesOutput {
                snapshot_schedules: self.snapshot_schedules,
                marker: self.marker,
            }
        }
    }
}
impl DescribeSnapshotSchedulesOutput {
    /// Creates a new builder-style object to manufacture [`DescribeSnapshotSchedulesOutput`](crate::output::DescribeSnapshotSchedulesOutput)
    pub fn builder() -> crate::output::describe_snapshot_schedules_output::Builder {
        crate::output::describe_snapshot_schedules_output::Builder::default()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeSnapshotCopyGrantsOutput {
    /// <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <code>DescribeSnapshotCopyGrant</code> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
    /// <p>Constraints: You can specify either the <b>SnapshotCopyGrantName</b> parameter or the <b>Marker</b> parameter, but not both. </p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>The list of <code>SnapshotCopyGrant</code> objects.</p>
    pub snapshot_copy_grants: std::option::Option<std::vec::Vec<crate::model::SnapshotCopyGrant>>,
}
impl DescribeSnapshotCopyGrantsOutput {
    /// <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <code>DescribeSnapshotCopyGrant</code> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
    /// <p>Constraints: You can specify either the <b>SnapshotCopyGrantName</b> parameter or the <b>Marker</b> parameter, but not both. </p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>The list of <code>SnapshotCopyGrant</code> objects.</p>
    pub fn snapshot_copy_grants(&self) -> std::option::Option<&[crate::model::SnapshotCopyGrant]> {
        self.snapshot_copy_grants.as_deref()
    }
}
impl std::fmt::Debug for DescribeSnapshotCopyGrantsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeSnapshotCopyGrantsOutput");
        formatter.field("marker", &self.marker);
        formatter.field("snapshot_copy_grants", &self.snapshot_copy_grants);
        formatter.finish()
    }
}
/// See [`DescribeSnapshotCopyGrantsOutput`](crate::output::DescribeSnapshotCopyGrantsOutput)
pub mod describe_snapshot_copy_grants_output {
    /// A builder for [`DescribeSnapshotCopyGrantsOutput`](crate::output::DescribeSnapshotCopyGrantsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) snapshot_copy_grants:
            std::option::Option<std::vec::Vec<crate::model::SnapshotCopyGrant>>,
    }
    impl Builder {
        /// <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <code>DescribeSnapshotCopyGrant</code> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
        /// <p>Constraints: You can specify either the <b>SnapshotCopyGrantName</b> parameter or the <b>Marker</b> parameter, but not both. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <code>DescribeSnapshotCopyGrant</code> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
        /// <p>Constraints: You can specify either the <b>SnapshotCopyGrantName</b> parameter or the <b>Marker</b> parameter, but not both. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Appends an item to `snapshot_copy_grants`.
        ///
        /// To override the contents of this collection use [`set_snapshot_copy_grants`](Self::set_snapshot_copy_grants).
        ///
        /// <p>The list of <code>SnapshotCopyGrant</code> objects.</p>
        pub fn snapshot_copy_grants(mut self, input: crate::model::SnapshotCopyGrant) -> Self {
            let mut v = self.snapshot_copy_grants.unwrap_or_default();
            v.push(input);
            self.snapshot_copy_grants = Some(v);
            self
        }
        /// <p>The list of <code>SnapshotCopyGrant</code> objects.</p>
        pub fn set_snapshot_copy_grants(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SnapshotCopyGrant>>,
        ) -> Self {
            self.snapshot_copy_grants = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeSnapshotCopyGrantsOutput`](crate::output::DescribeSnapshotCopyGrantsOutput)
        pub fn build(self) -> crate::output::DescribeSnapshotCopyGrantsOutput {
            crate::output::DescribeSnapshotCopyGrantsOutput {
                marker: self.marker,
                snapshot_copy_grants: self.snapshot_copy_grants,
            }
        }
    }
}
impl DescribeSnapshotCopyGrantsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeSnapshotCopyGrantsOutput`](crate::output::DescribeSnapshotCopyGrantsOutput)
    pub fn builder() -> crate::output::describe_snapshot_copy_grants_output::Builder {
        crate::output::describe_snapshot_copy_grants_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeScheduledActionsOutput {
    /// <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <code>DescribeScheduledActions</code> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>List of retrieved scheduled actions. </p>
    pub scheduled_actions: std::option::Option<std::vec::Vec<crate::model::ScheduledAction>>,
}
impl DescribeScheduledActionsOutput {
    /// <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <code>DescribeScheduledActions</code> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>List of retrieved scheduled actions. </p>
    pub fn scheduled_actions(&self) -> std::option::Option<&[crate::model::ScheduledAction]> {
        self.scheduled_actions.as_deref()
    }
}
impl std::fmt::Debug for DescribeScheduledActionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeScheduledActionsOutput");
        formatter.field("marker", &self.marker);
        formatter.field("scheduled_actions", &self.scheduled_actions);
        formatter.finish()
    }
}
/// See [`DescribeScheduledActionsOutput`](crate::output::DescribeScheduledActionsOutput)
pub mod describe_scheduled_actions_output {
    /// A builder for [`DescribeScheduledActionsOutput`](crate::output::DescribeScheduledActionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) scheduled_actions:
            std::option::Option<std::vec::Vec<crate::model::ScheduledAction>>,
    }
    impl Builder {
        /// <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <code>DescribeScheduledActions</code> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <code>DescribeScheduledActions</code> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Appends an item to `scheduled_actions`.
        ///
        /// To override the contents of this collection use [`set_scheduled_actions`](Self::set_scheduled_actions).
        ///
        /// <p>List of retrieved scheduled actions. </p>
        pub fn scheduled_actions(mut self, input: crate::model::ScheduledAction) -> Self {
            let mut v = self.scheduled_actions.unwrap_or_default();
            v.push(input);
            self.scheduled_actions = Some(v);
            self
        }
        /// <p>List of retrieved scheduled actions. </p>
        pub fn set_scheduled_actions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ScheduledAction>>,
        ) -> Self {
            self.scheduled_actions = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeScheduledActionsOutput`](crate::output::DescribeScheduledActionsOutput)
        pub fn build(self) -> crate::output::DescribeScheduledActionsOutput {
            crate::output::DescribeScheduledActionsOutput {
                marker: self.marker,
                scheduled_actions: self.scheduled_actions,
            }
        }
    }
}
impl DescribeScheduledActionsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeScheduledActionsOutput`](crate::output::DescribeScheduledActionsOutput)
    pub fn builder() -> crate::output::describe_scheduled_actions_output::Builder {
        crate::output::describe_scheduled_actions_output::Builder::default()
    }
}

/// <p>Describes the result of a cluster resize operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeResizeOutput {
    /// <p>The node type that the cluster will have after the resize operation is complete.</p>
    pub target_node_type: std::option::Option<std::string::String>,
    /// <p>The number of nodes that the cluster will have after the resize operation is complete.</p>
    pub target_number_of_nodes: std::option::Option<i32>,
    /// <p>The cluster type after the resize operation is complete.</p>
    /// <p>Valid Values: <code>multi-node</code> | <code>single-node</code> </p>
    pub target_cluster_type: std::option::Option<std::string::String>,
    /// <p>The status of the resize operation.</p>
    /// <p>Valid Values: <code>NONE</code> | <code>IN_PROGRESS</code> | <code>FAILED</code> | <code>SUCCEEDED</code> | <code>CANCELLING</code> </p>
    pub status: std::option::Option<std::string::String>,
    /// <p>The names of tables that have been completely imported .</p>
    /// <p>Valid Values: List of table names.</p>
    pub import_tables_completed: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The names of tables that are being currently imported.</p>
    /// <p>Valid Values: List of table names.</p>
    pub import_tables_in_progress: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The names of tables that have not been yet imported.</p>
    /// <p>Valid Values: List of table names</p>
    pub import_tables_not_started: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The average rate of the resize operation over the last few minutes, measured in megabytes per second. After the resize operation completes, this value shows the average rate of the entire resize operation.</p>
    pub avg_resize_rate_in_mega_bytes_per_second: std::option::Option<f64>,
    /// <p>The estimated total amount of data, in megabytes, on the cluster before the resize operation began.</p>
    pub total_resize_data_in_mega_bytes: std::option::Option<i64>,
    /// <p>While the resize operation is in progress, this value shows the current amount of data, in megabytes, that has been processed so far. When the resize operation is complete, this value shows the total amount of data, in megabytes, on the cluster, which may be more or less than TotalResizeDataInMegaBytes (the estimated total amount of data before resize).</p>
    pub progress_in_mega_bytes: std::option::Option<i64>,
    /// <p>The amount of seconds that have elapsed since the resize operation began. After the resize operation completes, this value shows the total actual time, in seconds, for the resize operation.</p>
    pub elapsed_time_in_seconds: std::option::Option<i64>,
    /// <p>The estimated time remaining, in seconds, until the resize operation is complete. This value is calculated based on the average resize rate and the estimated amount of data remaining to be processed. Once the resize operation is complete, this value will be 0.</p>
    pub estimated_time_to_completion_in_seconds: std::option::Option<i64>,
    /// <p>An enum with possible values of <code>ClassicResize</code> and <code>ElasticResize</code>. These values describe the type of resize operation being performed. </p>
    pub resize_type: std::option::Option<std::string::String>,
    /// <p>An optional string to provide additional details about the resize action.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The type of encryption for the cluster after the resize is complete.</p>
    /// <p>Possible values are <code>KMS</code> and <code>None</code>. </p>
    pub target_encryption_type: std::option::Option<std::string::String>,
    /// <p>The percent of data transferred from source cluster to target cluster.</p>
    pub data_transfer_progress_percent: std::option::Option<f64>,
}
impl DescribeResizeOutput {
    /// <p>The node type that the cluster will have after the resize operation is complete.</p>
    pub fn target_node_type(&self) -> std::option::Option<&str> {
        self.target_node_type.as_deref()
    }
    /// <p>The number of nodes that the cluster will have after the resize operation is complete.</p>
    pub fn target_number_of_nodes(&self) -> std::option::Option<i32> {
        self.target_number_of_nodes
    }
    /// <p>The cluster type after the resize operation is complete.</p>
    /// <p>Valid Values: <code>multi-node</code> | <code>single-node</code> </p>
    pub fn target_cluster_type(&self) -> std::option::Option<&str> {
        self.target_cluster_type.as_deref()
    }
    /// <p>The status of the resize operation.</p>
    /// <p>Valid Values: <code>NONE</code> | <code>IN_PROGRESS</code> | <code>FAILED</code> | <code>SUCCEEDED</code> | <code>CANCELLING</code> </p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>The names of tables that have been completely imported .</p>
    /// <p>Valid Values: List of table names.</p>
    pub fn import_tables_completed(&self) -> std::option::Option<&[std::string::String]> {
        self.import_tables_completed.as_deref()
    }
    /// <p>The names of tables that are being currently imported.</p>
    /// <p>Valid Values: List of table names.</p>
    pub fn import_tables_in_progress(&self) -> std::option::Option<&[std::string::String]> {
        self.import_tables_in_progress.as_deref()
    }
    /// <p>The names of tables that have not been yet imported.</p>
    /// <p>Valid Values: List of table names</p>
    pub fn import_tables_not_started(&self) -> std::option::Option<&[std::string::String]> {
        self.import_tables_not_started.as_deref()
    }
    /// <p>The average rate of the resize operation over the last few minutes, measured in megabytes per second. After the resize operation completes, this value shows the average rate of the entire resize operation.</p>
    pub fn avg_resize_rate_in_mega_bytes_per_second(&self) -> std::option::Option<f64> {
        self.avg_resize_rate_in_mega_bytes_per_second
    }
    /// <p>The estimated total amount of data, in megabytes, on the cluster before the resize operation began.</p>
    pub fn total_resize_data_in_mega_bytes(&self) -> std::option::Option<i64> {
        self.total_resize_data_in_mega_bytes
    }
    /// <p>While the resize operation is in progress, this value shows the current amount of data, in megabytes, that has been processed so far. When the resize operation is complete, this value shows the total amount of data, in megabytes, on the cluster, which may be more or less than TotalResizeDataInMegaBytes (the estimated total amount of data before resize).</p>
    pub fn progress_in_mega_bytes(&self) -> std::option::Option<i64> {
        self.progress_in_mega_bytes
    }
    /// <p>The amount of seconds that have elapsed since the resize operation began. After the resize operation completes, this value shows the total actual time, in seconds, for the resize operation.</p>
    pub fn elapsed_time_in_seconds(&self) -> std::option::Option<i64> {
        self.elapsed_time_in_seconds
    }
    /// <p>The estimated time remaining, in seconds, until the resize operation is complete. This value is calculated based on the average resize rate and the estimated amount of data remaining to be processed. Once the resize operation is complete, this value will be 0.</p>
    pub fn estimated_time_to_completion_in_seconds(&self) -> std::option::Option<i64> {
        self.estimated_time_to_completion_in_seconds
    }
    /// <p>An enum with possible values of <code>ClassicResize</code> and <code>ElasticResize</code>. These values describe the type of resize operation being performed. </p>
    pub fn resize_type(&self) -> std::option::Option<&str> {
        self.resize_type.as_deref()
    }
    /// <p>An optional string to provide additional details about the resize action.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
    /// <p>The type of encryption for the cluster after the resize is complete.</p>
    /// <p>Possible values are <code>KMS</code> and <code>None</code>. </p>
    pub fn target_encryption_type(&self) -> std::option::Option<&str> {
        self.target_encryption_type.as_deref()
    }
    /// <p>The percent of data transferred from source cluster to target cluster.</p>
    pub fn data_transfer_progress_percent(&self) -> std::option::Option<f64> {
        self.data_transfer_progress_percent
    }
}
impl std::fmt::Debug for DescribeResizeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeResizeOutput");
        formatter.field("target_node_type", &self.target_node_type);
        formatter.field("target_number_of_nodes", &self.target_number_of_nodes);
        formatter.field("target_cluster_type", &self.target_cluster_type);
        formatter.field("status", &self.status);
        formatter.field("import_tables_completed", &self.import_tables_completed);
        formatter.field("import_tables_in_progress", &self.import_tables_in_progress);
        formatter.field("import_tables_not_started", &self.import_tables_not_started);
        formatter.field(
            "avg_resize_rate_in_mega_bytes_per_second",
            &self.avg_resize_rate_in_mega_bytes_per_second,
        );
        formatter.field(
            "total_resize_data_in_mega_bytes",
            &self.total_resize_data_in_mega_bytes,
        );
        formatter.field("progress_in_mega_bytes", &self.progress_in_mega_bytes);
        formatter.field("elapsed_time_in_seconds", &self.elapsed_time_in_seconds);
        formatter.field(
            "estimated_time_to_completion_in_seconds",
            &self.estimated_time_to_completion_in_seconds,
        );
        formatter.field("resize_type", &self.resize_type);
        formatter.field("message", &self.message);
        formatter.field("target_encryption_type", &self.target_encryption_type);
        formatter.field(
            "data_transfer_progress_percent",
            &self.data_transfer_progress_percent,
        );
        formatter.finish()
    }
}
/// See [`DescribeResizeOutput`](crate::output::DescribeResizeOutput)
pub mod describe_resize_output {
    /// A builder for [`DescribeResizeOutput`](crate::output::DescribeResizeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) target_node_type: std::option::Option<std::string::String>,
        pub(crate) target_number_of_nodes: std::option::Option<i32>,
        pub(crate) target_cluster_type: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) import_tables_completed: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) import_tables_in_progress:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) import_tables_not_started:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) avg_resize_rate_in_mega_bytes_per_second: std::option::Option<f64>,
        pub(crate) total_resize_data_in_mega_bytes: std::option::Option<i64>,
        pub(crate) progress_in_mega_bytes: std::option::Option<i64>,
        pub(crate) elapsed_time_in_seconds: std::option::Option<i64>,
        pub(crate) estimated_time_to_completion_in_seconds: std::option::Option<i64>,
        pub(crate) resize_type: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) target_encryption_type: std::option::Option<std::string::String>,
        pub(crate) data_transfer_progress_percent: std::option::Option<f64>,
    }
    impl Builder {
        /// <p>The node type that the cluster will have after the resize operation is complete.</p>
        pub fn target_node_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_node_type = Some(input.into());
            self
        }
        /// <p>The node type that the cluster will have after the resize operation is complete.</p>
        pub fn set_target_node_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_node_type = input;
            self
        }
        /// <p>The number of nodes that the cluster will have after the resize operation is complete.</p>
        pub fn target_number_of_nodes(mut self, input: i32) -> Self {
            self.target_number_of_nodes = Some(input);
            self
        }
        /// <p>The number of nodes that the cluster will have after the resize operation is complete.</p>
        pub fn set_target_number_of_nodes(mut self, input: std::option::Option<i32>) -> Self {
            self.target_number_of_nodes = input;
            self
        }
        /// <p>The cluster type after the resize operation is complete.</p>
        /// <p>Valid Values: <code>multi-node</code> | <code>single-node</code> </p>
        pub fn target_cluster_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_cluster_type = Some(input.into());
            self
        }
        /// <p>The cluster type after the resize operation is complete.</p>
        /// <p>Valid Values: <code>multi-node</code> | <code>single-node</code> </p>
        pub fn set_target_cluster_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_cluster_type = input;
            self
        }
        /// <p>The status of the resize operation.</p>
        /// <p>Valid Values: <code>NONE</code> | <code>IN_PROGRESS</code> | <code>FAILED</code> | <code>SUCCEEDED</code> | <code>CANCELLING</code> </p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the resize operation.</p>
        /// <p>Valid Values: <code>NONE</code> | <code>IN_PROGRESS</code> | <code>FAILED</code> | <code>SUCCEEDED</code> | <code>CANCELLING</code> </p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// Appends an item to `import_tables_completed`.
        ///
        /// To override the contents of this collection use [`set_import_tables_completed`](Self::set_import_tables_completed).
        ///
        /// <p>The names of tables that have been completely imported .</p>
        /// <p>Valid Values: List of table names.</p>
        pub fn import_tables_completed(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.import_tables_completed.unwrap_or_default();
            v.push(input.into());
            self.import_tables_completed = Some(v);
            self
        }
        /// <p>The names of tables that have been completely imported .</p>
        /// <p>Valid Values: List of table names.</p>
        pub fn set_import_tables_completed(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.import_tables_completed = input;
            self
        }
        /// Appends an item to `import_tables_in_progress`.
        ///
        /// To override the contents of this collection use [`set_import_tables_in_progress`](Self::set_import_tables_in_progress).
        ///
        /// <p>The names of tables that are being currently imported.</p>
        /// <p>Valid Values: List of table names.</p>
        pub fn import_tables_in_progress(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.import_tables_in_progress.unwrap_or_default();
            v.push(input.into());
            self.import_tables_in_progress = Some(v);
            self
        }
        /// <p>The names of tables that are being currently imported.</p>
        /// <p>Valid Values: List of table names.</p>
        pub fn set_import_tables_in_progress(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.import_tables_in_progress = input;
            self
        }
        /// Appends an item to `import_tables_not_started`.
        ///
        /// To override the contents of this collection use [`set_import_tables_not_started`](Self::set_import_tables_not_started).
        ///
        /// <p>The names of tables that have not been yet imported.</p>
        /// <p>Valid Values: List of table names</p>
        pub fn import_tables_not_started(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.import_tables_not_started.unwrap_or_default();
            v.push(input.into());
            self.import_tables_not_started = Some(v);
            self
        }
        /// <p>The names of tables that have not been yet imported.</p>
        /// <p>Valid Values: List of table names</p>
        pub fn set_import_tables_not_started(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.import_tables_not_started = input;
            self
        }
        /// <p>The average rate of the resize operation over the last few minutes, measured in megabytes per second. After the resize operation completes, this value shows the average rate of the entire resize operation.</p>
        pub fn avg_resize_rate_in_mega_bytes_per_second(mut self, input: f64) -> Self {
            self.avg_resize_rate_in_mega_bytes_per_second = Some(input);
            self
        }
        /// <p>The average rate of the resize operation over the last few minutes, measured in megabytes per second. After the resize operation completes, this value shows the average rate of the entire resize operation.</p>
        pub fn set_avg_resize_rate_in_mega_bytes_per_second(
            mut self,
            input: std::option::Option<f64>,
        ) -> Self {
            self.avg_resize_rate_in_mega_bytes_per_second = input;
            self
        }
        /// <p>The estimated total amount of data, in megabytes, on the cluster before the resize operation began.</p>
        pub fn total_resize_data_in_mega_bytes(mut self, input: i64) -> Self {
            self.total_resize_data_in_mega_bytes = Some(input);
            self
        }
        /// <p>The estimated total amount of data, in megabytes, on the cluster before the resize operation began.</p>
        pub fn set_total_resize_data_in_mega_bytes(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.total_resize_data_in_mega_bytes = input;
            self
        }
        /// <p>While the resize operation is in progress, this value shows the current amount of data, in megabytes, that has been processed so far. When the resize operation is complete, this value shows the total amount of data, in megabytes, on the cluster, which may be more or less than TotalResizeDataInMegaBytes (the estimated total amount of data before resize).</p>
        pub fn progress_in_mega_bytes(mut self, input: i64) -> Self {
            self.progress_in_mega_bytes = Some(input);
            self
        }
        /// <p>While the resize operation is in progress, this value shows the current amount of data, in megabytes, that has been processed so far. When the resize operation is complete, this value shows the total amount of data, in megabytes, on the cluster, which may be more or less than TotalResizeDataInMegaBytes (the estimated total amount of data before resize).</p>
        pub fn set_progress_in_mega_bytes(mut self, input: std::option::Option<i64>) -> Self {
            self.progress_in_mega_bytes = input;
            self
        }
        /// <p>The amount of seconds that have elapsed since the resize operation began. After the resize operation completes, this value shows the total actual time, in seconds, for the resize operation.</p>
        pub fn elapsed_time_in_seconds(mut self, input: i64) -> Self {
            self.elapsed_time_in_seconds = Some(input);
            self
        }
        /// <p>The amount of seconds that have elapsed since the resize operation began. After the resize operation completes, this value shows the total actual time, in seconds, for the resize operation.</p>
        pub fn set_elapsed_time_in_seconds(mut self, input: std::option::Option<i64>) -> Self {
            self.elapsed_time_in_seconds = input;
            self
        }
        /// <p>The estimated time remaining, in seconds, until the resize operation is complete. This value is calculated based on the average resize rate and the estimated amount of data remaining to be processed. Once the resize operation is complete, this value will be 0.</p>
        pub fn estimated_time_to_completion_in_seconds(mut self, input: i64) -> Self {
            self.estimated_time_to_completion_in_seconds = Some(input);
            self
        }
        /// <p>The estimated time remaining, in seconds, until the resize operation is complete. This value is calculated based on the average resize rate and the estimated amount of data remaining to be processed. Once the resize operation is complete, this value will be 0.</p>
        pub fn set_estimated_time_to_completion_in_seconds(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.estimated_time_to_completion_in_seconds = input;
            self
        }
        /// <p>An enum with possible values of <code>ClassicResize</code> and <code>ElasticResize</code>. These values describe the type of resize operation being performed. </p>
        pub fn resize_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resize_type = Some(input.into());
            self
        }
        /// <p>An enum with possible values of <code>ClassicResize</code> and <code>ElasticResize</code>. These values describe the type of resize operation being performed. </p>
        pub fn set_resize_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resize_type = input;
            self
        }
        /// <p>An optional string to provide additional details about the resize action.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>An optional string to provide additional details about the resize action.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The type of encryption for the cluster after the resize is complete.</p>
        /// <p>Possible values are <code>KMS</code> and <code>None</code>. </p>
        pub fn target_encryption_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_encryption_type = Some(input.into());
            self
        }
        /// <p>The type of encryption for the cluster after the resize is complete.</p>
        /// <p>Possible values are <code>KMS</code> and <code>None</code>. </p>
        pub fn set_target_encryption_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_encryption_type = input;
            self
        }
        /// <p>The percent of data transferred from source cluster to target cluster.</p>
        pub fn data_transfer_progress_percent(mut self, input: f64) -> Self {
            self.data_transfer_progress_percent = Some(input);
            self
        }
        /// <p>The percent of data transferred from source cluster to target cluster.</p>
        pub fn set_data_transfer_progress_percent(
            mut self,
            input: std::option::Option<f64>,
        ) -> Self {
            self.data_transfer_progress_percent = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeResizeOutput`](crate::output::DescribeResizeOutput)
        pub fn build(self) -> crate::output::DescribeResizeOutput {
            crate::output::DescribeResizeOutput {
                target_node_type: self.target_node_type,
                target_number_of_nodes: self.target_number_of_nodes,
                target_cluster_type: self.target_cluster_type,
                status: self.status,
                import_tables_completed: self.import_tables_completed,
                import_tables_in_progress: self.import_tables_in_progress,
                import_tables_not_started: self.import_tables_not_started,
                avg_resize_rate_in_mega_bytes_per_second: self
                    .avg_resize_rate_in_mega_bytes_per_second,
                total_resize_data_in_mega_bytes: self.total_resize_data_in_mega_bytes,
                progress_in_mega_bytes: self.progress_in_mega_bytes,
                elapsed_time_in_seconds: self.elapsed_time_in_seconds,
                estimated_time_to_completion_in_seconds: self
                    .estimated_time_to_completion_in_seconds,
                resize_type: self.resize_type,
                message: self.message,
                target_encryption_type: self.target_encryption_type,
                data_transfer_progress_percent: self.data_transfer_progress_percent,
            }
        }
    }
}
impl DescribeResizeOutput {
    /// Creates a new builder-style object to manufacture [`DescribeResizeOutput`](crate::output::DescribeResizeOutput)
    pub fn builder() -> crate::output::describe_resize_output::Builder {
        crate::output::describe_resize_output::Builder::default()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeReservedNodesOutput {
    /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>The list of <code>ReservedNode</code> objects.</p>
    pub reserved_nodes: std::option::Option<std::vec::Vec<crate::model::ReservedNode>>,
}
impl DescribeReservedNodesOutput {
    /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>The list of <code>ReservedNode</code> objects.</p>
    pub fn reserved_nodes(&self) -> std::option::Option<&[crate::model::ReservedNode]> {
        self.reserved_nodes.as_deref()
    }
}
impl std::fmt::Debug for DescribeReservedNodesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeReservedNodesOutput");
        formatter.field("marker", &self.marker);
        formatter.field("reserved_nodes", &self.reserved_nodes);
        formatter.finish()
    }
}
/// See [`DescribeReservedNodesOutput`](crate::output::DescribeReservedNodesOutput)
pub mod describe_reserved_nodes_output {
    /// A builder for [`DescribeReservedNodesOutput`](crate::output::DescribeReservedNodesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) reserved_nodes: std::option::Option<std::vec::Vec<crate::model::ReservedNode>>,
    }
    impl Builder {
        /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Appends an item to `reserved_nodes`.
        ///
        /// To override the contents of this collection use [`set_reserved_nodes`](Self::set_reserved_nodes).
        ///
        /// <p>The list of <code>ReservedNode</code> objects.</p>
        pub fn reserved_nodes(mut self, input: crate::model::ReservedNode) -> Self {
            let mut v = self.reserved_nodes.unwrap_or_default();
            v.push(input);
            self.reserved_nodes = Some(v);
            self
        }
        /// <p>The list of <code>ReservedNode</code> objects.</p>
        pub fn set_reserved_nodes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ReservedNode>>,
        ) -> Self {
            self.reserved_nodes = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeReservedNodesOutput`](crate::output::DescribeReservedNodesOutput)
        pub fn build(self) -> crate::output::DescribeReservedNodesOutput {
            crate::output::DescribeReservedNodesOutput {
                marker: self.marker,
                reserved_nodes: self.reserved_nodes,
            }
        }
    }
}
impl DescribeReservedNodesOutput {
    /// Creates a new builder-style object to manufacture [`DescribeReservedNodesOutput`](crate::output::DescribeReservedNodesOutput)
    pub fn builder() -> crate::output::describe_reserved_nodes_output::Builder {
        crate::output::describe_reserved_nodes_output::Builder::default()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeReservedNodeOfferingsOutput {
    /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>A list of <code>ReservedNodeOffering</code> objects.</p>
    pub reserved_node_offerings:
        std::option::Option<std::vec::Vec<crate::model::ReservedNodeOffering>>,
}
impl DescribeReservedNodeOfferingsOutput {
    /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>A list of <code>ReservedNodeOffering</code> objects.</p>
    pub fn reserved_node_offerings(
        &self,
    ) -> std::option::Option<&[crate::model::ReservedNodeOffering]> {
        self.reserved_node_offerings.as_deref()
    }
}
impl std::fmt::Debug for DescribeReservedNodeOfferingsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeReservedNodeOfferingsOutput");
        formatter.field("marker", &self.marker);
        formatter.field("reserved_node_offerings", &self.reserved_node_offerings);
        formatter.finish()
    }
}
/// See [`DescribeReservedNodeOfferingsOutput`](crate::output::DescribeReservedNodeOfferingsOutput)
pub mod describe_reserved_node_offerings_output {
    /// A builder for [`DescribeReservedNodeOfferingsOutput`](crate::output::DescribeReservedNodeOfferingsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) reserved_node_offerings:
            std::option::Option<std::vec::Vec<crate::model::ReservedNodeOffering>>,
    }
    impl Builder {
        /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Appends an item to `reserved_node_offerings`.
        ///
        /// To override the contents of this collection use [`set_reserved_node_offerings`](Self::set_reserved_node_offerings).
        ///
        /// <p>A list of <code>ReservedNodeOffering</code> objects.</p>
        pub fn reserved_node_offerings(
            mut self,
            input: crate::model::ReservedNodeOffering,
        ) -> Self {
            let mut v = self.reserved_node_offerings.unwrap_or_default();
            v.push(input);
            self.reserved_node_offerings = Some(v);
            self
        }
        /// <p>A list of <code>ReservedNodeOffering</code> objects.</p>
        pub fn set_reserved_node_offerings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ReservedNodeOffering>>,
        ) -> Self {
            self.reserved_node_offerings = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeReservedNodeOfferingsOutput`](crate::output::DescribeReservedNodeOfferingsOutput)
        pub fn build(self) -> crate::output::DescribeReservedNodeOfferingsOutput {
            crate::output::DescribeReservedNodeOfferingsOutput {
                marker: self.marker,
                reserved_node_offerings: self.reserved_node_offerings,
            }
        }
    }
}
impl DescribeReservedNodeOfferingsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeReservedNodeOfferingsOutput`](crate::output::DescribeReservedNodeOfferingsOutput)
    pub fn builder() -> crate::output::describe_reserved_node_offerings_output::Builder {
        crate::output::describe_reserved_node_offerings_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeReservedNodeExchangeStatusOutput {
    /// <p>The details of the reserved-node exchange request, including the status, request time, source reserved-node identifier, and additional details.</p>
    pub reserved_node_exchange_status_details:
        std::option::Option<std::vec::Vec<crate::model::ReservedNodeExchangeStatus>>,
    /// <p>A pagination token provided by a previous <code>DescribeReservedNodeExchangeStatus</code> request.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl DescribeReservedNodeExchangeStatusOutput {
    /// <p>The details of the reserved-node exchange request, including the status, request time, source reserved-node identifier, and additional details.</p>
    pub fn reserved_node_exchange_status_details(
        &self,
    ) -> std::option::Option<&[crate::model::ReservedNodeExchangeStatus]> {
        self.reserved_node_exchange_status_details.as_deref()
    }
    /// <p>A pagination token provided by a previous <code>DescribeReservedNodeExchangeStatus</code> request.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for DescribeReservedNodeExchangeStatusOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeReservedNodeExchangeStatusOutput");
        formatter.field(
            "reserved_node_exchange_status_details",
            &self.reserved_node_exchange_status_details,
        );
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}
/// See [`DescribeReservedNodeExchangeStatusOutput`](crate::output::DescribeReservedNodeExchangeStatusOutput)
pub mod describe_reserved_node_exchange_status_output {
    /// A builder for [`DescribeReservedNodeExchangeStatusOutput`](crate::output::DescribeReservedNodeExchangeStatusOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) reserved_node_exchange_status_details:
            std::option::Option<std::vec::Vec<crate::model::ReservedNodeExchangeStatus>>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `reserved_node_exchange_status_details`.
        ///
        /// To override the contents of this collection use [`set_reserved_node_exchange_status_details`](Self::set_reserved_node_exchange_status_details).
        ///
        /// <p>The details of the reserved-node exchange request, including the status, request time, source reserved-node identifier, and additional details.</p>
        pub fn reserved_node_exchange_status_details(
            mut self,
            input: crate::model::ReservedNodeExchangeStatus,
        ) -> Self {
            let mut v = self
                .reserved_node_exchange_status_details
                .unwrap_or_default();
            v.push(input);
            self.reserved_node_exchange_status_details = Some(v);
            self
        }
        /// <p>The details of the reserved-node exchange request, including the status, request time, source reserved-node identifier, and additional details.</p>
        pub fn set_reserved_node_exchange_status_details(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ReservedNodeExchangeStatus>>,
        ) -> Self {
            self.reserved_node_exchange_status_details = input;
            self
        }
        /// <p>A pagination token provided by a previous <code>DescribeReservedNodeExchangeStatus</code> request.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>A pagination token provided by a previous <code>DescribeReservedNodeExchangeStatus</code> request.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeReservedNodeExchangeStatusOutput`](crate::output::DescribeReservedNodeExchangeStatusOutput)
        pub fn build(self) -> crate::output::DescribeReservedNodeExchangeStatusOutput {
            crate::output::DescribeReservedNodeExchangeStatusOutput {
                reserved_node_exchange_status_details: self.reserved_node_exchange_status_details,
                marker: self.marker,
            }
        }
    }
}
impl DescribeReservedNodeExchangeStatusOutput {
    /// Creates a new builder-style object to manufacture [`DescribeReservedNodeExchangeStatusOutput`](crate::output::DescribeReservedNodeExchangeStatusOutput)
    pub fn builder() -> crate::output::describe_reserved_node_exchange_status_output::Builder {
        crate::output::describe_reserved_node_exchange_status_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribePartnersOutput {
    /// <p>A list of partner integrations.</p>
    pub partner_integration_info_list:
        std::option::Option<std::vec::Vec<crate::model::PartnerIntegrationInfo>>,
}
impl DescribePartnersOutput {
    /// <p>A list of partner integrations.</p>
    pub fn partner_integration_info_list(
        &self,
    ) -> std::option::Option<&[crate::model::PartnerIntegrationInfo]> {
        self.partner_integration_info_list.as_deref()
    }
}
impl std::fmt::Debug for DescribePartnersOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribePartnersOutput");
        formatter.field(
            "partner_integration_info_list",
            &self.partner_integration_info_list,
        );
        formatter.finish()
    }
}
/// See [`DescribePartnersOutput`](crate::output::DescribePartnersOutput)
pub mod describe_partners_output {
    /// A builder for [`DescribePartnersOutput`](crate::output::DescribePartnersOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) partner_integration_info_list:
            std::option::Option<std::vec::Vec<crate::model::PartnerIntegrationInfo>>,
    }
    impl Builder {
        /// Appends an item to `partner_integration_info_list`.
        ///
        /// To override the contents of this collection use [`set_partner_integration_info_list`](Self::set_partner_integration_info_list).
        ///
        /// <p>A list of partner integrations.</p>
        pub fn partner_integration_info_list(
            mut self,
            input: crate::model::PartnerIntegrationInfo,
        ) -> Self {
            let mut v = self.partner_integration_info_list.unwrap_or_default();
            v.push(input);
            self.partner_integration_info_list = Some(v);
            self
        }
        /// <p>A list of partner integrations.</p>
        pub fn set_partner_integration_info_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PartnerIntegrationInfo>>,
        ) -> Self {
            self.partner_integration_info_list = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribePartnersOutput`](crate::output::DescribePartnersOutput)
        pub fn build(self) -> crate::output::DescribePartnersOutput {
            crate::output::DescribePartnersOutput {
                partner_integration_info_list: self.partner_integration_info_list,
            }
        }
    }
}
impl DescribePartnersOutput {
    /// Creates a new builder-style object to manufacture [`DescribePartnersOutput`](crate::output::DescribePartnersOutput)
    pub fn builder() -> crate::output::describe_partners_output::Builder {
        crate::output::describe_partners_output::Builder::default()
    }
}

/// <p>Contains the output from the <code>DescribeOrderableClusterOptions</code> action. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeOrderableClusterOptionsOutput {
    /// <p>An <code>OrderableClusterOption</code> structure containing information about orderable options for the cluster.</p>
    pub orderable_cluster_options:
        std::option::Option<std::vec::Vec<crate::model::OrderableClusterOption>>,
    /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>
    pub marker: std::option::Option<std::string::String>,
}
impl DescribeOrderableClusterOptionsOutput {
    /// <p>An <code>OrderableClusterOption</code> structure containing information about orderable options for the cluster.</p>
    pub fn orderable_cluster_options(
        &self,
    ) -> std::option::Option<&[crate::model::OrderableClusterOption]> {
        self.orderable_cluster_options.as_deref()
    }
    /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for DescribeOrderableClusterOptionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeOrderableClusterOptionsOutput");
        formatter.field("orderable_cluster_options", &self.orderable_cluster_options);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}
/// See [`DescribeOrderableClusterOptionsOutput`](crate::output::DescribeOrderableClusterOptionsOutput)
pub mod describe_orderable_cluster_options_output {
    /// A builder for [`DescribeOrderableClusterOptionsOutput`](crate::output::DescribeOrderableClusterOptionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) orderable_cluster_options:
            std::option::Option<std::vec::Vec<crate::model::OrderableClusterOption>>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `orderable_cluster_options`.
        ///
        /// To override the contents of this collection use [`set_orderable_cluster_options`](Self::set_orderable_cluster_options).
        ///
        /// <p>An <code>OrderableClusterOption</code> structure containing information about orderable options for the cluster.</p>
        pub fn orderable_cluster_options(
            mut self,
            input: crate::model::OrderableClusterOption,
        ) -> Self {
            let mut v = self.orderable_cluster_options.unwrap_or_default();
            v.push(input);
            self.orderable_cluster_options = Some(v);
            self
        }
        /// <p>An <code>OrderableClusterOption</code> structure containing information about orderable options for the cluster.</p>
        pub fn set_orderable_cluster_options(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OrderableClusterOption>>,
        ) -> Self {
            self.orderable_cluster_options = input;
            self
        }
        /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeOrderableClusterOptionsOutput`](crate::output::DescribeOrderableClusterOptionsOutput)
        pub fn build(self) -> crate::output::DescribeOrderableClusterOptionsOutput {
            crate::output::DescribeOrderableClusterOptionsOutput {
                orderable_cluster_options: self.orderable_cluster_options,
                marker: self.marker,
            }
        }
    }
}
impl DescribeOrderableClusterOptionsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeOrderableClusterOptionsOutput`](crate::output::DescribeOrderableClusterOptionsOutput)
    pub fn builder() -> crate::output::describe_orderable_cluster_options_output::Builder {
        crate::output::describe_orderable_cluster_options_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeNodeConfigurationOptionsOutput {
    /// <p>A list of valid node configurations.</p>
    pub node_configuration_option_list:
        std::option::Option<std::vec::Vec<crate::model::NodeConfigurationOption>>,
    /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>
    pub marker: std::option::Option<std::string::String>,
}
impl DescribeNodeConfigurationOptionsOutput {
    /// <p>A list of valid node configurations.</p>
    pub fn node_configuration_option_list(
        &self,
    ) -> std::option::Option<&[crate::model::NodeConfigurationOption]> {
        self.node_configuration_option_list.as_deref()
    }
    /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for DescribeNodeConfigurationOptionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeNodeConfigurationOptionsOutput");
        formatter.field(
            "node_configuration_option_list",
            &self.node_configuration_option_list,
        );
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}
/// See [`DescribeNodeConfigurationOptionsOutput`](crate::output::DescribeNodeConfigurationOptionsOutput)
pub mod describe_node_configuration_options_output {
    /// A builder for [`DescribeNodeConfigurationOptionsOutput`](crate::output::DescribeNodeConfigurationOptionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) node_configuration_option_list:
            std::option::Option<std::vec::Vec<crate::model::NodeConfigurationOption>>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `node_configuration_option_list`.
        ///
        /// To override the contents of this collection use [`set_node_configuration_option_list`](Self::set_node_configuration_option_list).
        ///
        /// <p>A list of valid node configurations.</p>
        pub fn node_configuration_option_list(
            mut self,
            input: crate::model::NodeConfigurationOption,
        ) -> Self {
            let mut v = self.node_configuration_option_list.unwrap_or_default();
            v.push(input);
            self.node_configuration_option_list = Some(v);
            self
        }
        /// <p>A list of valid node configurations.</p>
        pub fn set_node_configuration_option_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::NodeConfigurationOption>>,
        ) -> Self {
            self.node_configuration_option_list = input;
            self
        }
        /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeNodeConfigurationOptionsOutput`](crate::output::DescribeNodeConfigurationOptionsOutput)
        pub fn build(self) -> crate::output::DescribeNodeConfigurationOptionsOutput {
            crate::output::DescribeNodeConfigurationOptionsOutput {
                node_configuration_option_list: self.node_configuration_option_list,
                marker: self.marker,
            }
        }
    }
}
impl DescribeNodeConfigurationOptionsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeNodeConfigurationOptionsOutput`](crate::output::DescribeNodeConfigurationOptionsOutput)
    pub fn builder() -> crate::output::describe_node_configuration_options_output::Builder {
        crate::output::describe_node_configuration_options_output::Builder::default()
    }
}

/// <p>Describes the status of logging for a cluster.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeLoggingStatusOutput {
    /// <p> <code>true</code> if logging is on, <code>false</code> if logging is off.</p>
    pub logging_enabled: bool,
    /// <p>The name of the S3 bucket where the log files are stored.</p>
    pub bucket_name: std::option::Option<std::string::String>,
    /// <p>The prefix applied to the log file names.</p>
    pub s3_key_prefix: std::option::Option<std::string::String>,
    /// <p>The last time that logs were delivered.</p>
    pub last_successful_delivery_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The last time when logs failed to be delivered.</p>
    pub last_failure_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The message indicating that logs failed to be delivered.</p>
    pub last_failure_message: std::option::Option<std::string::String>,
}
impl DescribeLoggingStatusOutput {
    /// <p> <code>true</code> if logging is on, <code>false</code> if logging is off.</p>
    pub fn logging_enabled(&self) -> bool {
        self.logging_enabled
    }
    /// <p>The name of the S3 bucket where the log files are stored.</p>
    pub fn bucket_name(&self) -> std::option::Option<&str> {
        self.bucket_name.as_deref()
    }
    /// <p>The prefix applied to the log file names.</p>
    pub fn s3_key_prefix(&self) -> std::option::Option<&str> {
        self.s3_key_prefix.as_deref()
    }
    /// <p>The last time that logs were delivered.</p>
    pub fn last_successful_delivery_time(
        &self,
    ) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_successful_delivery_time.as_ref()
    }
    /// <p>The last time when logs failed to be delivered.</p>
    pub fn last_failure_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_failure_time.as_ref()
    }
    /// <p>The message indicating that logs failed to be delivered.</p>
    pub fn last_failure_message(&self) -> std::option::Option<&str> {
        self.last_failure_message.as_deref()
    }
}
impl std::fmt::Debug for DescribeLoggingStatusOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeLoggingStatusOutput");
        formatter.field("logging_enabled", &self.logging_enabled);
        formatter.field("bucket_name", &self.bucket_name);
        formatter.field("s3_key_prefix", &self.s3_key_prefix);
        formatter.field(
            "last_successful_delivery_time",
            &self.last_successful_delivery_time,
        );
        formatter.field("last_failure_time", &self.last_failure_time);
        formatter.field("last_failure_message", &self.last_failure_message);
        formatter.finish()
    }
}
/// See [`DescribeLoggingStatusOutput`](crate::output::DescribeLoggingStatusOutput)
pub mod describe_logging_status_output {
    /// A builder for [`DescribeLoggingStatusOutput`](crate::output::DescribeLoggingStatusOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) logging_enabled: std::option::Option<bool>,
        pub(crate) bucket_name: std::option::Option<std::string::String>,
        pub(crate) s3_key_prefix: std::option::Option<std::string::String>,
        pub(crate) last_successful_delivery_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_failure_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_failure_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> <code>true</code> if logging is on, <code>false</code> if logging is off.</p>
        pub fn logging_enabled(mut self, input: bool) -> Self {
            self.logging_enabled = Some(input);
            self
        }
        /// <p> <code>true</code> if logging is on, <code>false</code> if logging is off.</p>
        pub fn set_logging_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.logging_enabled = input;
            self
        }
        /// <p>The name of the S3 bucket where the log files are stored.</p>
        pub fn bucket_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket_name = Some(input.into());
            self
        }
        /// <p>The name of the S3 bucket where the log files are stored.</p>
        pub fn set_bucket_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket_name = input;
            self
        }
        /// <p>The prefix applied to the log file names.</p>
        pub fn s3_key_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_key_prefix = Some(input.into());
            self
        }
        /// <p>The prefix applied to the log file names.</p>
        pub fn set_s3_key_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.s3_key_prefix = input;
            self
        }
        /// <p>The last time that logs were delivered.</p>
        pub fn last_successful_delivery_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_successful_delivery_time = Some(input);
            self
        }
        /// <p>The last time that logs were delivered.</p>
        pub fn set_last_successful_delivery_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_successful_delivery_time = input;
            self
        }
        /// <p>The last time when logs failed to be delivered.</p>
        pub fn last_failure_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_failure_time = Some(input);
            self
        }
        /// <p>The last time when logs failed to be delivered.</p>
        pub fn set_last_failure_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_failure_time = input;
            self
        }
        /// <p>The message indicating that logs failed to be delivered.</p>
        pub fn last_failure_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_failure_message = Some(input.into());
            self
        }
        /// <p>The message indicating that logs failed to be delivered.</p>
        pub fn set_last_failure_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_failure_message = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeLoggingStatusOutput`](crate::output::DescribeLoggingStatusOutput)
        pub fn build(self) -> crate::output::DescribeLoggingStatusOutput {
            crate::output::DescribeLoggingStatusOutput {
                logging_enabled: self.logging_enabled.unwrap_or_default(),
                bucket_name: self.bucket_name,
                s3_key_prefix: self.s3_key_prefix,
                last_successful_delivery_time: self.last_successful_delivery_time,
                last_failure_time: self.last_failure_time,
                last_failure_message: self.last_failure_message,
            }
        }
    }
}
impl DescribeLoggingStatusOutput {
    /// Creates a new builder-style object to manufacture [`DescribeLoggingStatusOutput`](crate::output::DescribeLoggingStatusOutput)
    pub fn builder() -> crate::output::describe_logging_status_output::Builder {
        crate::output::describe_logging_status_output::Builder::default()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeHsmConfigurationsOutput {
    /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>A list of <code>HsmConfiguration</code> objects.</p>
    pub hsm_configurations: std::option::Option<std::vec::Vec<crate::model::HsmConfiguration>>,
}
impl DescribeHsmConfigurationsOutput {
    /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>A list of <code>HsmConfiguration</code> objects.</p>
    pub fn hsm_configurations(&self) -> std::option::Option<&[crate::model::HsmConfiguration]> {
        self.hsm_configurations.as_deref()
    }
}
impl std::fmt::Debug for DescribeHsmConfigurationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeHsmConfigurationsOutput");
        formatter.field("marker", &self.marker);
        formatter.field("hsm_configurations", &self.hsm_configurations);
        formatter.finish()
    }
}
/// See [`DescribeHsmConfigurationsOutput`](crate::output::DescribeHsmConfigurationsOutput)
pub mod describe_hsm_configurations_output {
    /// A builder for [`DescribeHsmConfigurationsOutput`](crate::output::DescribeHsmConfigurationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) hsm_configurations:
            std::option::Option<std::vec::Vec<crate::model::HsmConfiguration>>,
    }
    impl Builder {
        /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Appends an item to `hsm_configurations`.
        ///
        /// To override the contents of this collection use [`set_hsm_configurations`](Self::set_hsm_configurations).
        ///
        /// <p>A list of <code>HsmConfiguration</code> objects.</p>
        pub fn hsm_configurations(mut self, input: crate::model::HsmConfiguration) -> Self {
            let mut v = self.hsm_configurations.unwrap_or_default();
            v.push(input);
            self.hsm_configurations = Some(v);
            self
        }
        /// <p>A list of <code>HsmConfiguration</code> objects.</p>
        pub fn set_hsm_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::HsmConfiguration>>,
        ) -> Self {
            self.hsm_configurations = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeHsmConfigurationsOutput`](crate::output::DescribeHsmConfigurationsOutput)
        pub fn build(self) -> crate::output::DescribeHsmConfigurationsOutput {
            crate::output::DescribeHsmConfigurationsOutput {
                marker: self.marker,
                hsm_configurations: self.hsm_configurations,
            }
        }
    }
}
impl DescribeHsmConfigurationsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeHsmConfigurationsOutput`](crate::output::DescribeHsmConfigurationsOutput)
    pub fn builder() -> crate::output::describe_hsm_configurations_output::Builder {
        crate::output::describe_hsm_configurations_output::Builder::default()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeHsmClientCertificatesOutput {
    /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>A list of the identifiers for one or more HSM client certificates used by Amazon Redshift clusters to store and retrieve database encryption keys in an HSM.</p>
    pub hsm_client_certificates:
        std::option::Option<std::vec::Vec<crate::model::HsmClientCertificate>>,
}
impl DescribeHsmClientCertificatesOutput {
    /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>A list of the identifiers for one or more HSM client certificates used by Amazon Redshift clusters to store and retrieve database encryption keys in an HSM.</p>
    pub fn hsm_client_certificates(
        &self,
    ) -> std::option::Option<&[crate::model::HsmClientCertificate]> {
        self.hsm_client_certificates.as_deref()
    }
}
impl std::fmt::Debug for DescribeHsmClientCertificatesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeHsmClientCertificatesOutput");
        formatter.field("marker", &self.marker);
        formatter.field("hsm_client_certificates", &self.hsm_client_certificates);
        formatter.finish()
    }
}
/// See [`DescribeHsmClientCertificatesOutput`](crate::output::DescribeHsmClientCertificatesOutput)
pub mod describe_hsm_client_certificates_output {
    /// A builder for [`DescribeHsmClientCertificatesOutput`](crate::output::DescribeHsmClientCertificatesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) hsm_client_certificates:
            std::option::Option<std::vec::Vec<crate::model::HsmClientCertificate>>,
    }
    impl Builder {
        /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Appends an item to `hsm_client_certificates`.
        ///
        /// To override the contents of this collection use [`set_hsm_client_certificates`](Self::set_hsm_client_certificates).
        ///
        /// <p>A list of the identifiers for one or more HSM client certificates used by Amazon Redshift clusters to store and retrieve database encryption keys in an HSM.</p>
        pub fn hsm_client_certificates(
            mut self,
            input: crate::model::HsmClientCertificate,
        ) -> Self {
            let mut v = self.hsm_client_certificates.unwrap_or_default();
            v.push(input);
            self.hsm_client_certificates = Some(v);
            self
        }
        /// <p>A list of the identifiers for one or more HSM client certificates used by Amazon Redshift clusters to store and retrieve database encryption keys in an HSM.</p>
        pub fn set_hsm_client_certificates(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::HsmClientCertificate>>,
        ) -> Self {
            self.hsm_client_certificates = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeHsmClientCertificatesOutput`](crate::output::DescribeHsmClientCertificatesOutput)
        pub fn build(self) -> crate::output::DescribeHsmClientCertificatesOutput {
            crate::output::DescribeHsmClientCertificatesOutput {
                marker: self.marker,
                hsm_client_certificates: self.hsm_client_certificates,
            }
        }
    }
}
impl DescribeHsmClientCertificatesOutput {
    /// Creates a new builder-style object to manufacture [`DescribeHsmClientCertificatesOutput`](crate::output::DescribeHsmClientCertificatesOutput)
    pub fn builder() -> crate::output::describe_hsm_client_certificates_output::Builder {
        crate::output::describe_hsm_client_certificates_output::Builder::default()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeEventSubscriptionsOutput {
    /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>A list of event subscriptions.</p>
    pub event_subscriptions_list:
        std::option::Option<std::vec::Vec<crate::model::EventSubscription>>,
}
impl DescribeEventSubscriptionsOutput {
    /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>A list of event subscriptions.</p>
    pub fn event_subscriptions_list(
        &self,
    ) -> std::option::Option<&[crate::model::EventSubscription]> {
        self.event_subscriptions_list.as_deref()
    }
}
impl std::fmt::Debug for DescribeEventSubscriptionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeEventSubscriptionsOutput");
        formatter.field("marker", &self.marker);
        formatter.field("event_subscriptions_list", &self.event_subscriptions_list);
        formatter.finish()
    }
}
/// See [`DescribeEventSubscriptionsOutput`](crate::output::DescribeEventSubscriptionsOutput)
pub mod describe_event_subscriptions_output {
    /// A builder for [`DescribeEventSubscriptionsOutput`](crate::output::DescribeEventSubscriptionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) event_subscriptions_list:
            std::option::Option<std::vec::Vec<crate::model::EventSubscription>>,
    }
    impl Builder {
        /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Appends an item to `event_subscriptions_list`.
        ///
        /// To override the contents of this collection use [`set_event_subscriptions_list`](Self::set_event_subscriptions_list).
        ///
        /// <p>A list of event subscriptions.</p>
        pub fn event_subscriptions_list(mut self, input: crate::model::EventSubscription) -> Self {
            let mut v = self.event_subscriptions_list.unwrap_or_default();
            v.push(input);
            self.event_subscriptions_list = Some(v);
            self
        }
        /// <p>A list of event subscriptions.</p>
        pub fn set_event_subscriptions_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EventSubscription>>,
        ) -> Self {
            self.event_subscriptions_list = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeEventSubscriptionsOutput`](crate::output::DescribeEventSubscriptionsOutput)
        pub fn build(self) -> crate::output::DescribeEventSubscriptionsOutput {
            crate::output::DescribeEventSubscriptionsOutput {
                marker: self.marker,
                event_subscriptions_list: self.event_subscriptions_list,
            }
        }
    }
}
impl DescribeEventSubscriptionsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeEventSubscriptionsOutput`](crate::output::DescribeEventSubscriptionsOutput)
    pub fn builder() -> crate::output::describe_event_subscriptions_output::Builder {
        crate::output::describe_event_subscriptions_output::Builder::default()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeEventsOutput {
    /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>A list of <code>Event</code> instances. </p>
    pub events: std::option::Option<std::vec::Vec<crate::model::Event>>,
}
impl DescribeEventsOutput {
    /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>A list of <code>Event</code> instances. </p>
    pub fn events(&self) -> std::option::Option<&[crate::model::Event]> {
        self.events.as_deref()
    }
}
impl std::fmt::Debug for DescribeEventsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeEventsOutput");
        formatter.field("marker", &self.marker);
        formatter.field("events", &self.events);
        formatter.finish()
    }
}
/// See [`DescribeEventsOutput`](crate::output::DescribeEventsOutput)
pub mod describe_events_output {
    /// A builder for [`DescribeEventsOutput`](crate::output::DescribeEventsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) events: std::option::Option<std::vec::Vec<crate::model::Event>>,
    }
    impl Builder {
        /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Appends an item to `events`.
        ///
        /// To override the contents of this collection use [`set_events`](Self::set_events).
        ///
        /// <p>A list of <code>Event</code> instances. </p>
        pub fn events(mut self, input: crate::model::Event) -> Self {
            let mut v = self.events.unwrap_or_default();
            v.push(input);
            self.events = Some(v);
            self
        }
        /// <p>A list of <code>Event</code> instances. </p>
        pub fn set_events(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Event>>,
        ) -> Self {
            self.events = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeEventsOutput`](crate::output::DescribeEventsOutput)
        pub fn build(self) -> crate::output::DescribeEventsOutput {
            crate::output::DescribeEventsOutput {
                marker: self.marker,
                events: self.events,
            }
        }
    }
}
impl DescribeEventsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeEventsOutput`](crate::output::DescribeEventsOutput)
    pub fn builder() -> crate::output::describe_events_output::Builder {
        crate::output::describe_events_output::Builder::default()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeEventCategoriesOutput {
    /// <p>A list of event categories descriptions.</p>
    pub event_categories_map_list:
        std::option::Option<std::vec::Vec<crate::model::EventCategoriesMap>>,
}
impl DescribeEventCategoriesOutput {
    /// <p>A list of event categories descriptions.</p>
    pub fn event_categories_map_list(
        &self,
    ) -> std::option::Option<&[crate::model::EventCategoriesMap]> {
        self.event_categories_map_list.as_deref()
    }
}
impl std::fmt::Debug for DescribeEventCategoriesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeEventCategoriesOutput");
        formatter.field("event_categories_map_list", &self.event_categories_map_list);
        formatter.finish()
    }
}
/// See [`DescribeEventCategoriesOutput`](crate::output::DescribeEventCategoriesOutput)
pub mod describe_event_categories_output {
    /// A builder for [`DescribeEventCategoriesOutput`](crate::output::DescribeEventCategoriesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) event_categories_map_list:
            std::option::Option<std::vec::Vec<crate::model::EventCategoriesMap>>,
    }
    impl Builder {
        /// Appends an item to `event_categories_map_list`.
        ///
        /// To override the contents of this collection use [`set_event_categories_map_list`](Self::set_event_categories_map_list).
        ///
        /// <p>A list of event categories descriptions.</p>
        pub fn event_categories_map_list(
            mut self,
            input: crate::model::EventCategoriesMap,
        ) -> Self {
            let mut v = self.event_categories_map_list.unwrap_or_default();
            v.push(input);
            self.event_categories_map_list = Some(v);
            self
        }
        /// <p>A list of event categories descriptions.</p>
        pub fn set_event_categories_map_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EventCategoriesMap>>,
        ) -> Self {
            self.event_categories_map_list = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeEventCategoriesOutput`](crate::output::DescribeEventCategoriesOutput)
        pub fn build(self) -> crate::output::DescribeEventCategoriesOutput {
            crate::output::DescribeEventCategoriesOutput {
                event_categories_map_list: self.event_categories_map_list,
            }
        }
    }
}
impl DescribeEventCategoriesOutput {
    /// Creates a new builder-style object to manufacture [`DescribeEventCategoriesOutput`](crate::output::DescribeEventCategoriesOutput)
    pub fn builder() -> crate::output::describe_event_categories_output::Builder {
        crate::output::describe_event_categories_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeEndpointAuthorizationOutput {
    /// <p>The authorizations to an endpoint.</p>
    pub endpoint_authorization_list:
        std::option::Option<std::vec::Vec<crate::model::EndpointAuthorization>>,
    /// <p>An optional pagination token provided by a previous <code>DescribeEndpointAuthorization</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by the <code>MaxRecords</code> parameter.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl DescribeEndpointAuthorizationOutput {
    /// <p>The authorizations to an endpoint.</p>
    pub fn endpoint_authorization_list(
        &self,
    ) -> std::option::Option<&[crate::model::EndpointAuthorization]> {
        self.endpoint_authorization_list.as_deref()
    }
    /// <p>An optional pagination token provided by a previous <code>DescribeEndpointAuthorization</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by the <code>MaxRecords</code> parameter.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for DescribeEndpointAuthorizationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeEndpointAuthorizationOutput");
        formatter.field(
            "endpoint_authorization_list",
            &self.endpoint_authorization_list,
        );
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}
/// See [`DescribeEndpointAuthorizationOutput`](crate::output::DescribeEndpointAuthorizationOutput)
pub mod describe_endpoint_authorization_output {
    /// A builder for [`DescribeEndpointAuthorizationOutput`](crate::output::DescribeEndpointAuthorizationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) endpoint_authorization_list:
            std::option::Option<std::vec::Vec<crate::model::EndpointAuthorization>>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `endpoint_authorization_list`.
        ///
        /// To override the contents of this collection use [`set_endpoint_authorization_list`](Self::set_endpoint_authorization_list).
        ///
        /// <p>The authorizations to an endpoint.</p>
        pub fn endpoint_authorization_list(
            mut self,
            input: crate::model::EndpointAuthorization,
        ) -> Self {
            let mut v = self.endpoint_authorization_list.unwrap_or_default();
            v.push(input);
            self.endpoint_authorization_list = Some(v);
            self
        }
        /// <p>The authorizations to an endpoint.</p>
        pub fn set_endpoint_authorization_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EndpointAuthorization>>,
        ) -> Self {
            self.endpoint_authorization_list = input;
            self
        }
        /// <p>An optional pagination token provided by a previous <code>DescribeEndpointAuthorization</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by the <code>MaxRecords</code> parameter.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An optional pagination token provided by a previous <code>DescribeEndpointAuthorization</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by the <code>MaxRecords</code> parameter.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeEndpointAuthorizationOutput`](crate::output::DescribeEndpointAuthorizationOutput)
        pub fn build(self) -> crate::output::DescribeEndpointAuthorizationOutput {
            crate::output::DescribeEndpointAuthorizationOutput {
                endpoint_authorization_list: self.endpoint_authorization_list,
                marker: self.marker,
            }
        }
    }
}
impl DescribeEndpointAuthorizationOutput {
    /// Creates a new builder-style object to manufacture [`DescribeEndpointAuthorizationOutput`](crate::output::DescribeEndpointAuthorizationOutput)
    pub fn builder() -> crate::output::describe_endpoint_authorization_output::Builder {
        crate::output::describe_endpoint_authorization_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeEndpointAccessOutput {
    /// <p>The list of endpoints with access to the cluster.</p>
    pub endpoint_access_list: std::option::Option<std::vec::Vec<crate::model::EndpointAccess>>,
    /// <p>An optional pagination token provided by a previous <code>DescribeEndpointAccess</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by the <code>MaxRecords</code> parameter.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl DescribeEndpointAccessOutput {
    /// <p>The list of endpoints with access to the cluster.</p>
    pub fn endpoint_access_list(&self) -> std::option::Option<&[crate::model::EndpointAccess]> {
        self.endpoint_access_list.as_deref()
    }
    /// <p>An optional pagination token provided by a previous <code>DescribeEndpointAccess</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by the <code>MaxRecords</code> parameter.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for DescribeEndpointAccessOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeEndpointAccessOutput");
        formatter.field("endpoint_access_list", &self.endpoint_access_list);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}
/// See [`DescribeEndpointAccessOutput`](crate::output::DescribeEndpointAccessOutput)
pub mod describe_endpoint_access_output {
    /// A builder for [`DescribeEndpointAccessOutput`](crate::output::DescribeEndpointAccessOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) endpoint_access_list:
            std::option::Option<std::vec::Vec<crate::model::EndpointAccess>>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `endpoint_access_list`.
        ///
        /// To override the contents of this collection use [`set_endpoint_access_list`](Self::set_endpoint_access_list).
        ///
        /// <p>The list of endpoints with access to the cluster.</p>
        pub fn endpoint_access_list(mut self, input: crate::model::EndpointAccess) -> Self {
            let mut v = self.endpoint_access_list.unwrap_or_default();
            v.push(input);
            self.endpoint_access_list = Some(v);
            self
        }
        /// <p>The list of endpoints with access to the cluster.</p>
        pub fn set_endpoint_access_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EndpointAccess>>,
        ) -> Self {
            self.endpoint_access_list = input;
            self
        }
        /// <p>An optional pagination token provided by a previous <code>DescribeEndpointAccess</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by the <code>MaxRecords</code> parameter.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An optional pagination token provided by a previous <code>DescribeEndpointAccess</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by the <code>MaxRecords</code> parameter.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeEndpointAccessOutput`](crate::output::DescribeEndpointAccessOutput)
        pub fn build(self) -> crate::output::DescribeEndpointAccessOutput {
            crate::output::DescribeEndpointAccessOutput {
                endpoint_access_list: self.endpoint_access_list,
                marker: self.marker,
            }
        }
    }
}
impl DescribeEndpointAccessOutput {
    /// Creates a new builder-style object to manufacture [`DescribeEndpointAccessOutput`](crate::output::DescribeEndpointAccessOutput)
    pub fn builder() -> crate::output::describe_endpoint_access_output::Builder {
        crate::output::describe_endpoint_access_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDefaultClusterParametersOutput {
    /// <p>Describes the default cluster parameters for a parameter group family.</p>
    pub default_cluster_parameters: std::option::Option<crate::model::DefaultClusterParameters>,
}
impl DescribeDefaultClusterParametersOutput {
    /// <p>Describes the default cluster parameters for a parameter group family.</p>
    pub fn default_cluster_parameters(
        &self,
    ) -> std::option::Option<&crate::model::DefaultClusterParameters> {
        self.default_cluster_parameters.as_ref()
    }
}
impl std::fmt::Debug for DescribeDefaultClusterParametersOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDefaultClusterParametersOutput");
        formatter.field(
            "default_cluster_parameters",
            &self.default_cluster_parameters,
        );
        formatter.finish()
    }
}
/// See [`DescribeDefaultClusterParametersOutput`](crate::output::DescribeDefaultClusterParametersOutput)
pub mod describe_default_cluster_parameters_output {
    /// A builder for [`DescribeDefaultClusterParametersOutput`](crate::output::DescribeDefaultClusterParametersOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) default_cluster_parameters:
            std::option::Option<crate::model::DefaultClusterParameters>,
    }
    impl Builder {
        /// <p>Describes the default cluster parameters for a parameter group family.</p>
        pub fn default_cluster_parameters(
            mut self,
            input: crate::model::DefaultClusterParameters,
        ) -> Self {
            self.default_cluster_parameters = Some(input);
            self
        }
        /// <p>Describes the default cluster parameters for a parameter group family.</p>
        pub fn set_default_cluster_parameters(
            mut self,
            input: std::option::Option<crate::model::DefaultClusterParameters>,
        ) -> Self {
            self.default_cluster_parameters = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDefaultClusterParametersOutput`](crate::output::DescribeDefaultClusterParametersOutput)
        pub fn build(self) -> crate::output::DescribeDefaultClusterParametersOutput {
            crate::output::DescribeDefaultClusterParametersOutput {
                default_cluster_parameters: self.default_cluster_parameters,
            }
        }
    }
}
impl DescribeDefaultClusterParametersOutput {
    /// Creates a new builder-style object to manufacture [`DescribeDefaultClusterParametersOutput`](crate::output::DescribeDefaultClusterParametersOutput)
    pub fn builder() -> crate::output::describe_default_cluster_parameters_output::Builder {
        crate::output::describe_default_cluster_parameters_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDataSharesForProducerOutput {
    /// <p>Shows the results of datashares available for producers.</p>
    pub data_shares: std::option::Option<std::vec::Vec<crate::model::DataShare>>,
    /// <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <code>DescribeDataSharesForProducer</code> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
    pub marker: std::option::Option<std::string::String>,
}
impl DescribeDataSharesForProducerOutput {
    /// <p>Shows the results of datashares available for producers.</p>
    pub fn data_shares(&self) -> std::option::Option<&[crate::model::DataShare]> {
        self.data_shares.as_deref()
    }
    /// <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <code>DescribeDataSharesForProducer</code> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for DescribeDataSharesForProducerOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDataSharesForProducerOutput");
        formatter.field("data_shares", &self.data_shares);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}
/// See [`DescribeDataSharesForProducerOutput`](crate::output::DescribeDataSharesForProducerOutput)
pub mod describe_data_shares_for_producer_output {
    /// A builder for [`DescribeDataSharesForProducerOutput`](crate::output::DescribeDataSharesForProducerOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data_shares: std::option::Option<std::vec::Vec<crate::model::DataShare>>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `data_shares`.
        ///
        /// To override the contents of this collection use [`set_data_shares`](Self::set_data_shares).
        ///
        /// <p>Shows the results of datashares available for producers.</p>
        pub fn data_shares(mut self, input: crate::model::DataShare) -> Self {
            let mut v = self.data_shares.unwrap_or_default();
            v.push(input);
            self.data_shares = Some(v);
            self
        }
        /// <p>Shows the results of datashares available for producers.</p>
        pub fn set_data_shares(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DataShare>>,
        ) -> Self {
            self.data_shares = input;
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <code>DescribeDataSharesForProducer</code> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <code>DescribeDataSharesForProducer</code> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDataSharesForProducerOutput`](crate::output::DescribeDataSharesForProducerOutput)
        pub fn build(self) -> crate::output::DescribeDataSharesForProducerOutput {
            crate::output::DescribeDataSharesForProducerOutput {
                data_shares: self.data_shares,
                marker: self.marker,
            }
        }
    }
}
impl DescribeDataSharesForProducerOutput {
    /// Creates a new builder-style object to manufacture [`DescribeDataSharesForProducerOutput`](crate::output::DescribeDataSharesForProducerOutput)
    pub fn builder() -> crate::output::describe_data_shares_for_producer_output::Builder {
        crate::output::describe_data_shares_for_producer_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDataSharesForConsumerOutput {
    /// <p>Shows the results of datashares available for consumers.</p>
    pub data_shares: std::option::Option<std::vec::Vec<crate::model::DataShare>>,
    /// <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <code>DescribeDataSharesForConsumer</code> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
    pub marker: std::option::Option<std::string::String>,
}
impl DescribeDataSharesForConsumerOutput {
    /// <p>Shows the results of datashares available for consumers.</p>
    pub fn data_shares(&self) -> std::option::Option<&[crate::model::DataShare]> {
        self.data_shares.as_deref()
    }
    /// <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <code>DescribeDataSharesForConsumer</code> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for DescribeDataSharesForConsumerOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDataSharesForConsumerOutput");
        formatter.field("data_shares", &self.data_shares);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}
/// See [`DescribeDataSharesForConsumerOutput`](crate::output::DescribeDataSharesForConsumerOutput)
pub mod describe_data_shares_for_consumer_output {
    /// A builder for [`DescribeDataSharesForConsumerOutput`](crate::output::DescribeDataSharesForConsumerOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data_shares: std::option::Option<std::vec::Vec<crate::model::DataShare>>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `data_shares`.
        ///
        /// To override the contents of this collection use [`set_data_shares`](Self::set_data_shares).
        ///
        /// <p>Shows the results of datashares available for consumers.</p>
        pub fn data_shares(mut self, input: crate::model::DataShare) -> Self {
            let mut v = self.data_shares.unwrap_or_default();
            v.push(input);
            self.data_shares = Some(v);
            self
        }
        /// <p>Shows the results of datashares available for consumers.</p>
        pub fn set_data_shares(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DataShare>>,
        ) -> Self {
            self.data_shares = input;
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <code>DescribeDataSharesForConsumer</code> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <code>DescribeDataSharesForConsumer</code> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDataSharesForConsumerOutput`](crate::output::DescribeDataSharesForConsumerOutput)
        pub fn build(self) -> crate::output::DescribeDataSharesForConsumerOutput {
            crate::output::DescribeDataSharesForConsumerOutput {
                data_shares: self.data_shares,
                marker: self.marker,
            }
        }
    }
}
impl DescribeDataSharesForConsumerOutput {
    /// Creates a new builder-style object to manufacture [`DescribeDataSharesForConsumerOutput`](crate::output::DescribeDataSharesForConsumerOutput)
    pub fn builder() -> crate::output::describe_data_shares_for_consumer_output::Builder {
        crate::output::describe_data_shares_for_consumer_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDataSharesOutput {
    /// <p>The results returned from describing datashares.</p>
    pub data_shares: std::option::Option<std::vec::Vec<crate::model::DataShare>>,
    /// <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <code>DescribeDataShares</code> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
    pub marker: std::option::Option<std::string::String>,
}
impl DescribeDataSharesOutput {
    /// <p>The results returned from describing datashares.</p>
    pub fn data_shares(&self) -> std::option::Option<&[crate::model::DataShare]> {
        self.data_shares.as_deref()
    }
    /// <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <code>DescribeDataShares</code> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for DescribeDataSharesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDataSharesOutput");
        formatter.field("data_shares", &self.data_shares);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}
/// See [`DescribeDataSharesOutput`](crate::output::DescribeDataSharesOutput)
pub mod describe_data_shares_output {
    /// A builder for [`DescribeDataSharesOutput`](crate::output::DescribeDataSharesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data_shares: std::option::Option<std::vec::Vec<crate::model::DataShare>>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `data_shares`.
        ///
        /// To override the contents of this collection use [`set_data_shares`](Self::set_data_shares).
        ///
        /// <p>The results returned from describing datashares.</p>
        pub fn data_shares(mut self, input: crate::model::DataShare) -> Self {
            let mut v = self.data_shares.unwrap_or_default();
            v.push(input);
            self.data_shares = Some(v);
            self
        }
        /// <p>The results returned from describing datashares.</p>
        pub fn set_data_shares(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DataShare>>,
        ) -> Self {
            self.data_shares = input;
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <code>DescribeDataShares</code> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <code>DescribeDataShares</code> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDataSharesOutput`](crate::output::DescribeDataSharesOutput)
        pub fn build(self) -> crate::output::DescribeDataSharesOutput {
            crate::output::DescribeDataSharesOutput {
                data_shares: self.data_shares,
                marker: self.marker,
            }
        }
    }
}
impl DescribeDataSharesOutput {
    /// Creates a new builder-style object to manufacture [`DescribeDataSharesOutput`](crate::output::DescribeDataSharesOutput)
    pub fn builder() -> crate::output::describe_data_shares_output::Builder {
        crate::output::describe_data_shares_output::Builder::default()
    }
}

/// <p>Contains the output from the <code>DescribeClusterVersions</code> action. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeClusterVersionsOutput {
    /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>A list of <code>Version</code> elements. </p>
    pub cluster_versions: std::option::Option<std::vec::Vec<crate::model::ClusterVersion>>,
}
impl DescribeClusterVersionsOutput {
    /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>A list of <code>Version</code> elements. </p>
    pub fn cluster_versions(&self) -> std::option::Option<&[crate::model::ClusterVersion]> {
        self.cluster_versions.as_deref()
    }
}
impl std::fmt::Debug for DescribeClusterVersionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeClusterVersionsOutput");
        formatter.field("marker", &self.marker);
        formatter.field("cluster_versions", &self.cluster_versions);
        formatter.finish()
    }
}
/// See [`DescribeClusterVersionsOutput`](crate::output::DescribeClusterVersionsOutput)
pub mod describe_cluster_versions_output {
    /// A builder for [`DescribeClusterVersionsOutput`](crate::output::DescribeClusterVersionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) cluster_versions:
            std::option::Option<std::vec::Vec<crate::model::ClusterVersion>>,
    }
    impl Builder {
        /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Appends an item to `cluster_versions`.
        ///
        /// To override the contents of this collection use [`set_cluster_versions`](Self::set_cluster_versions).
        ///
        /// <p>A list of <code>Version</code> elements. </p>
        pub fn cluster_versions(mut self, input: crate::model::ClusterVersion) -> Self {
            let mut v = self.cluster_versions.unwrap_or_default();
            v.push(input);
            self.cluster_versions = Some(v);
            self
        }
        /// <p>A list of <code>Version</code> elements. </p>
        pub fn set_cluster_versions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ClusterVersion>>,
        ) -> Self {
            self.cluster_versions = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeClusterVersionsOutput`](crate::output::DescribeClusterVersionsOutput)
        pub fn build(self) -> crate::output::DescribeClusterVersionsOutput {
            crate::output::DescribeClusterVersionsOutput {
                marker: self.marker,
                cluster_versions: self.cluster_versions,
            }
        }
    }
}
impl DescribeClusterVersionsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeClusterVersionsOutput`](crate::output::DescribeClusterVersionsOutput)
    pub fn builder() -> crate::output::describe_cluster_versions_output::Builder {
        crate::output::describe_cluster_versions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeClusterTracksOutput {
    /// <p>A list of maintenance tracks output by the <code>DescribeClusterTracks</code> operation. </p>
    pub maintenance_tracks: std::option::Option<std::vec::Vec<crate::model::MaintenanceTrack>>,
    /// <p>The starting point to return a set of response tracklist records. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl DescribeClusterTracksOutput {
    /// <p>A list of maintenance tracks output by the <code>DescribeClusterTracks</code> operation. </p>
    pub fn maintenance_tracks(&self) -> std::option::Option<&[crate::model::MaintenanceTrack]> {
        self.maintenance_tracks.as_deref()
    }
    /// <p>The starting point to return a set of response tracklist records. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for DescribeClusterTracksOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeClusterTracksOutput");
        formatter.field("maintenance_tracks", &self.maintenance_tracks);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}
/// See [`DescribeClusterTracksOutput`](crate::output::DescribeClusterTracksOutput)
pub mod describe_cluster_tracks_output {
    /// A builder for [`DescribeClusterTracksOutput`](crate::output::DescribeClusterTracksOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) maintenance_tracks:
            std::option::Option<std::vec::Vec<crate::model::MaintenanceTrack>>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `maintenance_tracks`.
        ///
        /// To override the contents of this collection use [`set_maintenance_tracks`](Self::set_maintenance_tracks).
        ///
        /// <p>A list of maintenance tracks output by the <code>DescribeClusterTracks</code> operation. </p>
        pub fn maintenance_tracks(mut self, input: crate::model::MaintenanceTrack) -> Self {
            let mut v = self.maintenance_tracks.unwrap_or_default();
            v.push(input);
            self.maintenance_tracks = Some(v);
            self
        }
        /// <p>A list of maintenance tracks output by the <code>DescribeClusterTracks</code> operation. </p>
        pub fn set_maintenance_tracks(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MaintenanceTrack>>,
        ) -> Self {
            self.maintenance_tracks = input;
            self
        }
        /// <p>The starting point to return a set of response tracklist records. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>The starting point to return a set of response tracklist records. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeClusterTracksOutput`](crate::output::DescribeClusterTracksOutput)
        pub fn build(self) -> crate::output::DescribeClusterTracksOutput {
            crate::output::DescribeClusterTracksOutput {
                maintenance_tracks: self.maintenance_tracks,
                marker: self.marker,
            }
        }
    }
}
impl DescribeClusterTracksOutput {
    /// Creates a new builder-style object to manufacture [`DescribeClusterTracksOutput`](crate::output::DescribeClusterTracksOutput)
    pub fn builder() -> crate::output::describe_cluster_tracks_output::Builder {
        crate::output::describe_cluster_tracks_output::Builder::default()
    }
}

/// <p>Contains the output from the <code>DescribeClusterSubnetGroups</code> action. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeClusterSubnetGroupsOutput {
    /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>A list of <code>ClusterSubnetGroup</code> instances. </p>
    pub cluster_subnet_groups: std::option::Option<std::vec::Vec<crate::model::ClusterSubnetGroup>>,
}
impl DescribeClusterSubnetGroupsOutput {
    /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>A list of <code>ClusterSubnetGroup</code> instances. </p>
    pub fn cluster_subnet_groups(
        &self,
    ) -> std::option::Option<&[crate::model::ClusterSubnetGroup]> {
        self.cluster_subnet_groups.as_deref()
    }
}
impl std::fmt::Debug for DescribeClusterSubnetGroupsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeClusterSubnetGroupsOutput");
        formatter.field("marker", &self.marker);
        formatter.field("cluster_subnet_groups", &self.cluster_subnet_groups);
        formatter.finish()
    }
}
/// See [`DescribeClusterSubnetGroupsOutput`](crate::output::DescribeClusterSubnetGroupsOutput)
pub mod describe_cluster_subnet_groups_output {
    /// A builder for [`DescribeClusterSubnetGroupsOutput`](crate::output::DescribeClusterSubnetGroupsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) cluster_subnet_groups:
            std::option::Option<std::vec::Vec<crate::model::ClusterSubnetGroup>>,
    }
    impl Builder {
        /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Appends an item to `cluster_subnet_groups`.
        ///
        /// To override the contents of this collection use [`set_cluster_subnet_groups`](Self::set_cluster_subnet_groups).
        ///
        /// <p>A list of <code>ClusterSubnetGroup</code> instances. </p>
        pub fn cluster_subnet_groups(mut self, input: crate::model::ClusterSubnetGroup) -> Self {
            let mut v = self.cluster_subnet_groups.unwrap_or_default();
            v.push(input);
            self.cluster_subnet_groups = Some(v);
            self
        }
        /// <p>A list of <code>ClusterSubnetGroup</code> instances. </p>
        pub fn set_cluster_subnet_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ClusterSubnetGroup>>,
        ) -> Self {
            self.cluster_subnet_groups = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeClusterSubnetGroupsOutput`](crate::output::DescribeClusterSubnetGroupsOutput)
        pub fn build(self) -> crate::output::DescribeClusterSubnetGroupsOutput {
            crate::output::DescribeClusterSubnetGroupsOutput {
                marker: self.marker,
                cluster_subnet_groups: self.cluster_subnet_groups,
            }
        }
    }
}
impl DescribeClusterSubnetGroupsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeClusterSubnetGroupsOutput`](crate::output::DescribeClusterSubnetGroupsOutput)
    pub fn builder() -> crate::output::describe_cluster_subnet_groups_output::Builder {
        crate::output::describe_cluster_subnet_groups_output::Builder::default()
    }
}

/// <p>Contains the output from the <code>DescribeClusterSnapshots</code> action. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeClusterSnapshotsOutput {
    /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>A list of <code>Snapshot</code> instances. </p>
    pub snapshots: std::option::Option<std::vec::Vec<crate::model::Snapshot>>,
}
impl DescribeClusterSnapshotsOutput {
    /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>A list of <code>Snapshot</code> instances. </p>
    pub fn snapshots(&self) -> std::option::Option<&[crate::model::Snapshot]> {
        self.snapshots.as_deref()
    }
}
impl std::fmt::Debug for DescribeClusterSnapshotsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeClusterSnapshotsOutput");
        formatter.field("marker", &self.marker);
        formatter.field("snapshots", &self.snapshots);
        formatter.finish()
    }
}
/// See [`DescribeClusterSnapshotsOutput`](crate::output::DescribeClusterSnapshotsOutput)
pub mod describe_cluster_snapshots_output {
    /// A builder for [`DescribeClusterSnapshotsOutput`](crate::output::DescribeClusterSnapshotsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) snapshots: std::option::Option<std::vec::Vec<crate::model::Snapshot>>,
    }
    impl Builder {
        /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Appends an item to `snapshots`.
        ///
        /// To override the contents of this collection use [`set_snapshots`](Self::set_snapshots).
        ///
        /// <p>A list of <code>Snapshot</code> instances. </p>
        pub fn snapshots(mut self, input: crate::model::Snapshot) -> Self {
            let mut v = self.snapshots.unwrap_or_default();
            v.push(input);
            self.snapshots = Some(v);
            self
        }
        /// <p>A list of <code>Snapshot</code> instances. </p>
        pub fn set_snapshots(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Snapshot>>,
        ) -> Self {
            self.snapshots = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeClusterSnapshotsOutput`](crate::output::DescribeClusterSnapshotsOutput)
        pub fn build(self) -> crate::output::DescribeClusterSnapshotsOutput {
            crate::output::DescribeClusterSnapshotsOutput {
                marker: self.marker,
                snapshots: self.snapshots,
            }
        }
    }
}
impl DescribeClusterSnapshotsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeClusterSnapshotsOutput`](crate::output::DescribeClusterSnapshotsOutput)
    pub fn builder() -> crate::output::describe_cluster_snapshots_output::Builder {
        crate::output::describe_cluster_snapshots_output::Builder::default()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeClusterSecurityGroupsOutput {
    /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>A list of <code>ClusterSecurityGroup</code> instances. </p>
    pub cluster_security_groups:
        std::option::Option<std::vec::Vec<crate::model::ClusterSecurityGroup>>,
}
impl DescribeClusterSecurityGroupsOutput {
    /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>A list of <code>ClusterSecurityGroup</code> instances. </p>
    pub fn cluster_security_groups(
        &self,
    ) -> std::option::Option<&[crate::model::ClusterSecurityGroup]> {
        self.cluster_security_groups.as_deref()
    }
}
impl std::fmt::Debug for DescribeClusterSecurityGroupsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeClusterSecurityGroupsOutput");
        formatter.field("marker", &self.marker);
        formatter.field("cluster_security_groups", &self.cluster_security_groups);
        formatter.finish()
    }
}
/// See [`DescribeClusterSecurityGroupsOutput`](crate::output::DescribeClusterSecurityGroupsOutput)
pub mod describe_cluster_security_groups_output {
    /// A builder for [`DescribeClusterSecurityGroupsOutput`](crate::output::DescribeClusterSecurityGroupsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) cluster_security_groups:
            std::option::Option<std::vec::Vec<crate::model::ClusterSecurityGroup>>,
    }
    impl Builder {
        /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Appends an item to `cluster_security_groups`.
        ///
        /// To override the contents of this collection use [`set_cluster_security_groups`](Self::set_cluster_security_groups).
        ///
        /// <p>A list of <code>ClusterSecurityGroup</code> instances. </p>
        pub fn cluster_security_groups(
            mut self,
            input: crate::model::ClusterSecurityGroup,
        ) -> Self {
            let mut v = self.cluster_security_groups.unwrap_or_default();
            v.push(input);
            self.cluster_security_groups = Some(v);
            self
        }
        /// <p>A list of <code>ClusterSecurityGroup</code> instances. </p>
        pub fn set_cluster_security_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ClusterSecurityGroup>>,
        ) -> Self {
            self.cluster_security_groups = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeClusterSecurityGroupsOutput`](crate::output::DescribeClusterSecurityGroupsOutput)
        pub fn build(self) -> crate::output::DescribeClusterSecurityGroupsOutput {
            crate::output::DescribeClusterSecurityGroupsOutput {
                marker: self.marker,
                cluster_security_groups: self.cluster_security_groups,
            }
        }
    }
}
impl DescribeClusterSecurityGroupsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeClusterSecurityGroupsOutput`](crate::output::DescribeClusterSecurityGroupsOutput)
    pub fn builder() -> crate::output::describe_cluster_security_groups_output::Builder {
        crate::output::describe_cluster_security_groups_output::Builder::default()
    }
}

/// <p>Contains the output from the <code>DescribeClusters</code> action. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeClustersOutput {
    /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>A list of <code>Cluster</code> objects, where each object describes one cluster. </p>
    pub clusters: std::option::Option<std::vec::Vec<crate::model::Cluster>>,
}
impl DescribeClustersOutput {
    /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>A list of <code>Cluster</code> objects, where each object describes one cluster. </p>
    pub fn clusters(&self) -> std::option::Option<&[crate::model::Cluster]> {
        self.clusters.as_deref()
    }
}
impl std::fmt::Debug for DescribeClustersOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeClustersOutput");
        formatter.field("marker", &self.marker);
        formatter.field("clusters", &self.clusters);
        formatter.finish()
    }
}
/// See [`DescribeClustersOutput`](crate::output::DescribeClustersOutput)
pub mod describe_clusters_output {
    /// A builder for [`DescribeClustersOutput`](crate::output::DescribeClustersOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) clusters: std::option::Option<std::vec::Vec<crate::model::Cluster>>,
    }
    impl Builder {
        /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Appends an item to `clusters`.
        ///
        /// To override the contents of this collection use [`set_clusters`](Self::set_clusters).
        ///
        /// <p>A list of <code>Cluster</code> objects, where each object describes one cluster. </p>
        pub fn clusters(mut self, input: crate::model::Cluster) -> Self {
            let mut v = self.clusters.unwrap_or_default();
            v.push(input);
            self.clusters = Some(v);
            self
        }
        /// <p>A list of <code>Cluster</code> objects, where each object describes one cluster. </p>
        pub fn set_clusters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Cluster>>,
        ) -> Self {
            self.clusters = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeClustersOutput`](crate::output::DescribeClustersOutput)
        pub fn build(self) -> crate::output::DescribeClustersOutput {
            crate::output::DescribeClustersOutput {
                marker: self.marker,
                clusters: self.clusters,
            }
        }
    }
}
impl DescribeClustersOutput {
    /// Creates a new builder-style object to manufacture [`DescribeClustersOutput`](crate::output::DescribeClustersOutput)
    pub fn builder() -> crate::output::describe_clusters_output::Builder {
        crate::output::describe_clusters_output::Builder::default()
    }
}

/// <p>Contains the output from the <code>DescribeClusterParameters</code> action. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeClusterParametersOutput {
    /// <p>A list of <code>Parameter</code> instances. Each instance lists the parameters of one cluster parameter group. </p>
    pub parameters: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
    /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>
    pub marker: std::option::Option<std::string::String>,
}
impl DescribeClusterParametersOutput {
    /// <p>A list of <code>Parameter</code> instances. Each instance lists the parameters of one cluster parameter group. </p>
    pub fn parameters(&self) -> std::option::Option<&[crate::model::Parameter]> {
        self.parameters.as_deref()
    }
    /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for DescribeClusterParametersOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeClusterParametersOutput");
        formatter.field("parameters", &self.parameters);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}
/// See [`DescribeClusterParametersOutput`](crate::output::DescribeClusterParametersOutput)
pub mod describe_cluster_parameters_output {
    /// A builder for [`DescribeClusterParametersOutput`](crate::output::DescribeClusterParametersOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) parameters: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>A list of <code>Parameter</code> instances. Each instance lists the parameters of one cluster parameter group. </p>
        pub fn parameters(mut self, input: crate::model::Parameter) -> Self {
            let mut v = self.parameters.unwrap_or_default();
            v.push(input);
            self.parameters = Some(v);
            self
        }
        /// <p>A list of <code>Parameter</code> instances. Each instance lists the parameters of one cluster parameter group. </p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
        ) -> Self {
            self.parameters = input;
            self
        }
        /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeClusterParametersOutput`](crate::output::DescribeClusterParametersOutput)
        pub fn build(self) -> crate::output::DescribeClusterParametersOutput {
            crate::output::DescribeClusterParametersOutput {
                parameters: self.parameters,
                marker: self.marker,
            }
        }
    }
}
impl DescribeClusterParametersOutput {
    /// Creates a new builder-style object to manufacture [`DescribeClusterParametersOutput`](crate::output::DescribeClusterParametersOutput)
    pub fn builder() -> crate::output::describe_cluster_parameters_output::Builder {
        crate::output::describe_cluster_parameters_output::Builder::default()
    }
}

/// <p>Contains the output from the <code>DescribeClusterParameterGroups</code> action. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeClusterParameterGroupsOutput {
    /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>A list of <code>ClusterParameterGroup</code> instances. Each instance describes one cluster parameter group. </p>
    pub parameter_groups: std::option::Option<std::vec::Vec<crate::model::ClusterParameterGroup>>,
}
impl DescribeClusterParameterGroupsOutput {
    /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>A list of <code>ClusterParameterGroup</code> instances. Each instance describes one cluster parameter group. </p>
    pub fn parameter_groups(&self) -> std::option::Option<&[crate::model::ClusterParameterGroup]> {
        self.parameter_groups.as_deref()
    }
}
impl std::fmt::Debug for DescribeClusterParameterGroupsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeClusterParameterGroupsOutput");
        formatter.field("marker", &self.marker);
        formatter.field("parameter_groups", &self.parameter_groups);
        formatter.finish()
    }
}
/// See [`DescribeClusterParameterGroupsOutput`](crate::output::DescribeClusterParameterGroupsOutput)
pub mod describe_cluster_parameter_groups_output {
    /// A builder for [`DescribeClusterParameterGroupsOutput`](crate::output::DescribeClusterParameterGroupsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) parameter_groups:
            std::option::Option<std::vec::Vec<crate::model::ClusterParameterGroup>>,
    }
    impl Builder {
        /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Appends an item to `parameter_groups`.
        ///
        /// To override the contents of this collection use [`set_parameter_groups`](Self::set_parameter_groups).
        ///
        /// <p>A list of <code>ClusterParameterGroup</code> instances. Each instance describes one cluster parameter group. </p>
        pub fn parameter_groups(mut self, input: crate::model::ClusterParameterGroup) -> Self {
            let mut v = self.parameter_groups.unwrap_or_default();
            v.push(input);
            self.parameter_groups = Some(v);
            self
        }
        /// <p>A list of <code>ClusterParameterGroup</code> instances. Each instance describes one cluster parameter group. </p>
        pub fn set_parameter_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ClusterParameterGroup>>,
        ) -> Self {
            self.parameter_groups = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeClusterParameterGroupsOutput`](crate::output::DescribeClusterParameterGroupsOutput)
        pub fn build(self) -> crate::output::DescribeClusterParameterGroupsOutput {
            crate::output::DescribeClusterParameterGroupsOutput {
                marker: self.marker,
                parameter_groups: self.parameter_groups,
            }
        }
    }
}
impl DescribeClusterParameterGroupsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeClusterParameterGroupsOutput`](crate::output::DescribeClusterParameterGroupsOutput)
    pub fn builder() -> crate::output::describe_cluster_parameter_groups_output::Builder {
        crate::output::describe_cluster_parameter_groups_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeClusterDbRevisionsOutput {
    /// <p>A string representing the starting point for the next set of revisions. If a value is returned in a response, you can retrieve the next set of revisions by providing the value in the <code>marker</code> parameter and retrying the command. If the <code>marker</code> field is empty, all revisions have already been returned.</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>A list of revisions.</p>
    pub cluster_db_revisions: std::option::Option<std::vec::Vec<crate::model::ClusterDbRevision>>,
}
impl DescribeClusterDbRevisionsOutput {
    /// <p>A string representing the starting point for the next set of revisions. If a value is returned in a response, you can retrieve the next set of revisions by providing the value in the <code>marker</code> parameter and retrying the command. If the <code>marker</code> field is empty, all revisions have already been returned.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>A list of revisions.</p>
    pub fn cluster_db_revisions(&self) -> std::option::Option<&[crate::model::ClusterDbRevision]> {
        self.cluster_db_revisions.as_deref()
    }
}
impl std::fmt::Debug for DescribeClusterDbRevisionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeClusterDbRevisionsOutput");
        formatter.field("marker", &self.marker);
        formatter.field("cluster_db_revisions", &self.cluster_db_revisions);
        formatter.finish()
    }
}
/// See [`DescribeClusterDbRevisionsOutput`](crate::output::DescribeClusterDbRevisionsOutput)
pub mod describe_cluster_db_revisions_output {
    /// A builder for [`DescribeClusterDbRevisionsOutput`](crate::output::DescribeClusterDbRevisionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) cluster_db_revisions:
            std::option::Option<std::vec::Vec<crate::model::ClusterDbRevision>>,
    }
    impl Builder {
        /// <p>A string representing the starting point for the next set of revisions. If a value is returned in a response, you can retrieve the next set of revisions by providing the value in the <code>marker</code> parameter and retrying the command. If the <code>marker</code> field is empty, all revisions have already been returned.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>A string representing the starting point for the next set of revisions. If a value is returned in a response, you can retrieve the next set of revisions by providing the value in the <code>marker</code> parameter and retrying the command. If the <code>marker</code> field is empty, all revisions have already been returned.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Appends an item to `cluster_db_revisions`.
        ///
        /// To override the contents of this collection use [`set_cluster_db_revisions`](Self::set_cluster_db_revisions).
        ///
        /// <p>A list of revisions.</p>
        pub fn cluster_db_revisions(mut self, input: crate::model::ClusterDbRevision) -> Self {
            let mut v = self.cluster_db_revisions.unwrap_or_default();
            v.push(input);
            self.cluster_db_revisions = Some(v);
            self
        }
        /// <p>A list of revisions.</p>
        pub fn set_cluster_db_revisions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ClusterDbRevision>>,
        ) -> Self {
            self.cluster_db_revisions = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeClusterDbRevisionsOutput`](crate::output::DescribeClusterDbRevisionsOutput)
        pub fn build(self) -> crate::output::DescribeClusterDbRevisionsOutput {
            crate::output::DescribeClusterDbRevisionsOutput {
                marker: self.marker,
                cluster_db_revisions: self.cluster_db_revisions,
            }
        }
    }
}
impl DescribeClusterDbRevisionsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeClusterDbRevisionsOutput`](crate::output::DescribeClusterDbRevisionsOutput)
    pub fn builder() -> crate::output::describe_cluster_db_revisions_output::Builder {
        crate::output::describe_cluster_db_revisions_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAuthenticationProfilesOutput {
    /// <p>The list of authentication profiles.</p>
    pub authentication_profiles:
        std::option::Option<std::vec::Vec<crate::model::AuthenticationProfile>>,
}
impl DescribeAuthenticationProfilesOutput {
    /// <p>The list of authentication profiles.</p>
    pub fn authentication_profiles(
        &self,
    ) -> std::option::Option<&[crate::model::AuthenticationProfile]> {
        self.authentication_profiles.as_deref()
    }
}
impl std::fmt::Debug for DescribeAuthenticationProfilesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAuthenticationProfilesOutput");
        formatter.field("authentication_profiles", &self.authentication_profiles);
        formatter.finish()
    }
}
/// See [`DescribeAuthenticationProfilesOutput`](crate::output::DescribeAuthenticationProfilesOutput)
pub mod describe_authentication_profiles_output {
    /// A builder for [`DescribeAuthenticationProfilesOutput`](crate::output::DescribeAuthenticationProfilesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authentication_profiles:
            std::option::Option<std::vec::Vec<crate::model::AuthenticationProfile>>,
    }
    impl Builder {
        /// Appends an item to `authentication_profiles`.
        ///
        /// To override the contents of this collection use [`set_authentication_profiles`](Self::set_authentication_profiles).
        ///
        /// <p>The list of authentication profiles.</p>
        pub fn authentication_profiles(
            mut self,
            input: crate::model::AuthenticationProfile,
        ) -> Self {
            let mut v = self.authentication_profiles.unwrap_or_default();
            v.push(input);
            self.authentication_profiles = Some(v);
            self
        }
        /// <p>The list of authentication profiles.</p>
        pub fn set_authentication_profiles(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AuthenticationProfile>>,
        ) -> Self {
            self.authentication_profiles = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAuthenticationProfilesOutput`](crate::output::DescribeAuthenticationProfilesOutput)
        pub fn build(self) -> crate::output::DescribeAuthenticationProfilesOutput {
            crate::output::DescribeAuthenticationProfilesOutput {
                authentication_profiles: self.authentication_profiles,
            }
        }
    }
}
impl DescribeAuthenticationProfilesOutput {
    /// Creates a new builder-style object to manufacture [`DescribeAuthenticationProfilesOutput`](crate::output::DescribeAuthenticationProfilesOutput)
    pub fn builder() -> crate::output::describe_authentication_profiles_output::Builder {
        crate::output::describe_authentication_profiles_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAccountAttributesOutput {
    /// <p>A list of attributes assigned to an account.</p>
    pub account_attributes: std::option::Option<std::vec::Vec<crate::model::AccountAttribute>>,
}
impl DescribeAccountAttributesOutput {
    /// <p>A list of attributes assigned to an account.</p>
    pub fn account_attributes(&self) -> std::option::Option<&[crate::model::AccountAttribute]> {
        self.account_attributes.as_deref()
    }
}
impl std::fmt::Debug for DescribeAccountAttributesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAccountAttributesOutput");
        formatter.field("account_attributes", &self.account_attributes);
        formatter.finish()
    }
}
/// See [`DescribeAccountAttributesOutput`](crate::output::DescribeAccountAttributesOutput)
pub mod describe_account_attributes_output {
    /// A builder for [`DescribeAccountAttributesOutput`](crate::output::DescribeAccountAttributesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_attributes:
            std::option::Option<std::vec::Vec<crate::model::AccountAttribute>>,
    }
    impl Builder {
        /// Appends an item to `account_attributes`.
        ///
        /// To override the contents of this collection use [`set_account_attributes`](Self::set_account_attributes).
        ///
        /// <p>A list of attributes assigned to an account.</p>
        pub fn account_attributes(mut self, input: crate::model::AccountAttribute) -> Self {
            let mut v = self.account_attributes.unwrap_or_default();
            v.push(input);
            self.account_attributes = Some(v);
            self
        }
        /// <p>A list of attributes assigned to an account.</p>
        pub fn set_account_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AccountAttribute>>,
        ) -> Self {
            self.account_attributes = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAccountAttributesOutput`](crate::output::DescribeAccountAttributesOutput)
        pub fn build(self) -> crate::output::DescribeAccountAttributesOutput {
            crate::output::DescribeAccountAttributesOutput {
                account_attributes: self.account_attributes,
            }
        }
    }
}
impl DescribeAccountAttributesOutput {
    /// Creates a new builder-style object to manufacture [`DescribeAccountAttributesOutput`](crate::output::DescribeAccountAttributesOutput)
    pub fn builder() -> crate::output::describe_account_attributes_output::Builder {
        crate::output::describe_account_attributes_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteUsageLimitOutput {}
impl std::fmt::Debug for DeleteUsageLimitOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteUsageLimitOutput");
        formatter.finish()
    }
}
/// See [`DeleteUsageLimitOutput`](crate::output::DeleteUsageLimitOutput)
pub mod delete_usage_limit_output {
    /// A builder for [`DeleteUsageLimitOutput`](crate::output::DeleteUsageLimitOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteUsageLimitOutput`](crate::output::DeleteUsageLimitOutput)
        pub fn build(self) -> crate::output::DeleteUsageLimitOutput {
            crate::output::DeleteUsageLimitOutput {}
        }
    }
}
impl DeleteUsageLimitOutput {
    /// Creates a new builder-style object to manufacture [`DeleteUsageLimitOutput`](crate::output::DeleteUsageLimitOutput)
    pub fn builder() -> crate::output::delete_usage_limit_output::Builder {
        crate::output::delete_usage_limit_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteTagsOutput {}
impl std::fmt::Debug for DeleteTagsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteTagsOutput");
        formatter.finish()
    }
}
/// See [`DeleteTagsOutput`](crate::output::DeleteTagsOutput)
pub mod delete_tags_output {
    /// A builder for [`DeleteTagsOutput`](crate::output::DeleteTagsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteTagsOutput`](crate::output::DeleteTagsOutput)
        pub fn build(self) -> crate::output::DeleteTagsOutput {
            crate::output::DeleteTagsOutput {}
        }
    }
}
impl DeleteTagsOutput {
    /// Creates a new builder-style object to manufacture [`DeleteTagsOutput`](crate::output::DeleteTagsOutput)
    pub fn builder() -> crate::output::delete_tags_output::Builder {
        crate::output::delete_tags_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteSnapshotScheduleOutput {}
impl std::fmt::Debug for DeleteSnapshotScheduleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteSnapshotScheduleOutput");
        formatter.finish()
    }
}
/// See [`DeleteSnapshotScheduleOutput`](crate::output::DeleteSnapshotScheduleOutput)
pub mod delete_snapshot_schedule_output {
    /// A builder for [`DeleteSnapshotScheduleOutput`](crate::output::DeleteSnapshotScheduleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteSnapshotScheduleOutput`](crate::output::DeleteSnapshotScheduleOutput)
        pub fn build(self) -> crate::output::DeleteSnapshotScheduleOutput {
            crate::output::DeleteSnapshotScheduleOutput {}
        }
    }
}
impl DeleteSnapshotScheduleOutput {
    /// Creates a new builder-style object to manufacture [`DeleteSnapshotScheduleOutput`](crate::output::DeleteSnapshotScheduleOutput)
    pub fn builder() -> crate::output::delete_snapshot_schedule_output::Builder {
        crate::output::delete_snapshot_schedule_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteSnapshotCopyGrantOutput {}
impl std::fmt::Debug for DeleteSnapshotCopyGrantOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteSnapshotCopyGrantOutput");
        formatter.finish()
    }
}
/// See [`DeleteSnapshotCopyGrantOutput`](crate::output::DeleteSnapshotCopyGrantOutput)
pub mod delete_snapshot_copy_grant_output {
    /// A builder for [`DeleteSnapshotCopyGrantOutput`](crate::output::DeleteSnapshotCopyGrantOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteSnapshotCopyGrantOutput`](crate::output::DeleteSnapshotCopyGrantOutput)
        pub fn build(self) -> crate::output::DeleteSnapshotCopyGrantOutput {
            crate::output::DeleteSnapshotCopyGrantOutput {}
        }
    }
}
impl DeleteSnapshotCopyGrantOutput {
    /// Creates a new builder-style object to manufacture [`DeleteSnapshotCopyGrantOutput`](crate::output::DeleteSnapshotCopyGrantOutput)
    pub fn builder() -> crate::output::delete_snapshot_copy_grant_output::Builder {
        crate::output::delete_snapshot_copy_grant_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteScheduledActionOutput {}
impl std::fmt::Debug for DeleteScheduledActionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteScheduledActionOutput");
        formatter.finish()
    }
}
/// See [`DeleteScheduledActionOutput`](crate::output::DeleteScheduledActionOutput)
pub mod delete_scheduled_action_output {
    /// A builder for [`DeleteScheduledActionOutput`](crate::output::DeleteScheduledActionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteScheduledActionOutput`](crate::output::DeleteScheduledActionOutput)
        pub fn build(self) -> crate::output::DeleteScheduledActionOutput {
            crate::output::DeleteScheduledActionOutput {}
        }
    }
}
impl DeleteScheduledActionOutput {
    /// Creates a new builder-style object to manufacture [`DeleteScheduledActionOutput`](crate::output::DeleteScheduledActionOutput)
    pub fn builder() -> crate::output::delete_scheduled_action_output::Builder {
        crate::output::delete_scheduled_action_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeletePartnerOutput {
    /// <p>The name of the database that receives data from the partner.</p>
    pub database_name: std::option::Option<std::string::String>,
    /// <p>The name of the partner that is authorized to send data.</p>
    pub partner_name: std::option::Option<std::string::String>,
}
impl DeletePartnerOutput {
    /// <p>The name of the database that receives data from the partner.</p>
    pub fn database_name(&self) -> std::option::Option<&str> {
        self.database_name.as_deref()
    }
    /// <p>The name of the partner that is authorized to send data.</p>
    pub fn partner_name(&self) -> std::option::Option<&str> {
        self.partner_name.as_deref()
    }
}
impl std::fmt::Debug for DeletePartnerOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeletePartnerOutput");
        formatter.field("database_name", &self.database_name);
        formatter.field("partner_name", &self.partner_name);
        formatter.finish()
    }
}
/// See [`DeletePartnerOutput`](crate::output::DeletePartnerOutput)
pub mod delete_partner_output {
    /// A builder for [`DeletePartnerOutput`](crate::output::DeletePartnerOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) database_name: std::option::Option<std::string::String>,
        pub(crate) partner_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the database that receives data from the partner.</p>
        pub fn database_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.database_name = Some(input.into());
            self
        }
        /// <p>The name of the database that receives data from the partner.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.database_name = input;
            self
        }
        /// <p>The name of the partner that is authorized to send data.</p>
        pub fn partner_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.partner_name = Some(input.into());
            self
        }
        /// <p>The name of the partner that is authorized to send data.</p>
        pub fn set_partner_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.partner_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeletePartnerOutput`](crate::output::DeletePartnerOutput)
        pub fn build(self) -> crate::output::DeletePartnerOutput {
            crate::output::DeletePartnerOutput {
                database_name: self.database_name,
                partner_name: self.partner_name,
            }
        }
    }
}
impl DeletePartnerOutput {
    /// Creates a new builder-style object to manufacture [`DeletePartnerOutput`](crate::output::DeletePartnerOutput)
    pub fn builder() -> crate::output::delete_partner_output::Builder {
        crate::output::delete_partner_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteHsmConfigurationOutput {}
impl std::fmt::Debug for DeleteHsmConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteHsmConfigurationOutput");
        formatter.finish()
    }
}
/// See [`DeleteHsmConfigurationOutput`](crate::output::DeleteHsmConfigurationOutput)
pub mod delete_hsm_configuration_output {
    /// A builder for [`DeleteHsmConfigurationOutput`](crate::output::DeleteHsmConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteHsmConfigurationOutput`](crate::output::DeleteHsmConfigurationOutput)
        pub fn build(self) -> crate::output::DeleteHsmConfigurationOutput {
            crate::output::DeleteHsmConfigurationOutput {}
        }
    }
}
impl DeleteHsmConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`DeleteHsmConfigurationOutput`](crate::output::DeleteHsmConfigurationOutput)
    pub fn builder() -> crate::output::delete_hsm_configuration_output::Builder {
        crate::output::delete_hsm_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteHsmClientCertificateOutput {}
impl std::fmt::Debug for DeleteHsmClientCertificateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteHsmClientCertificateOutput");
        formatter.finish()
    }
}
/// See [`DeleteHsmClientCertificateOutput`](crate::output::DeleteHsmClientCertificateOutput)
pub mod delete_hsm_client_certificate_output {
    /// A builder for [`DeleteHsmClientCertificateOutput`](crate::output::DeleteHsmClientCertificateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteHsmClientCertificateOutput`](crate::output::DeleteHsmClientCertificateOutput)
        pub fn build(self) -> crate::output::DeleteHsmClientCertificateOutput {
            crate::output::DeleteHsmClientCertificateOutput {}
        }
    }
}
impl DeleteHsmClientCertificateOutput {
    /// Creates a new builder-style object to manufacture [`DeleteHsmClientCertificateOutput`](crate::output::DeleteHsmClientCertificateOutput)
    pub fn builder() -> crate::output::delete_hsm_client_certificate_output::Builder {
        crate::output::delete_hsm_client_certificate_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteEventSubscriptionOutput {}
impl std::fmt::Debug for DeleteEventSubscriptionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteEventSubscriptionOutput");
        formatter.finish()
    }
}
/// See [`DeleteEventSubscriptionOutput`](crate::output::DeleteEventSubscriptionOutput)
pub mod delete_event_subscription_output {
    /// A builder for [`DeleteEventSubscriptionOutput`](crate::output::DeleteEventSubscriptionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteEventSubscriptionOutput`](crate::output::DeleteEventSubscriptionOutput)
        pub fn build(self) -> crate::output::DeleteEventSubscriptionOutput {
            crate::output::DeleteEventSubscriptionOutput {}
        }
    }
}
impl DeleteEventSubscriptionOutput {
    /// Creates a new builder-style object to manufacture [`DeleteEventSubscriptionOutput`](crate::output::DeleteEventSubscriptionOutput)
    pub fn builder() -> crate::output::delete_event_subscription_output::Builder {
        crate::output::delete_event_subscription_output::Builder::default()
    }
}

/// <p>Describes a Redshift-managed VPC endpoint.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteEndpointAccessOutput {
    /// <p>The cluster identifier of the cluster associated with the endpoint.</p>
    pub cluster_identifier: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services account ID of the owner of the cluster.</p>
    pub resource_owner: std::option::Option<std::string::String>,
    /// <p>The subnet group name where Amazon Redshift chooses to deploy the endpoint.</p>
    pub subnet_group_name: std::option::Option<std::string::String>,
    /// <p>The status of the endpoint.</p>
    pub endpoint_status: std::option::Option<std::string::String>,
    /// <p>The name of the endpoint.</p>
    pub endpoint_name: std::option::Option<std::string::String>,
    /// <p>The time (UTC) that the endpoint was created.</p>
    pub endpoint_create_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The port number on which the cluster accepts incoming connections.</p>
    pub port: i32,
    /// <p>The DNS address of the endpoint.</p>
    pub address: std::option::Option<std::string::String>,
    /// <p>The security groups associated with the endpoint.</p>
    pub vpc_security_groups:
        std::option::Option<std::vec::Vec<crate::model::VpcSecurityGroupMembership>>,
    /// <p>The connection endpoint for connecting to an Amazon Redshift cluster through the proxy.</p>
    pub vpc_endpoint: std::option::Option<crate::model::VpcEndpoint>,
}
impl DeleteEndpointAccessOutput {
    /// <p>The cluster identifier of the cluster associated with the endpoint.</p>
    pub fn cluster_identifier(&self) -> std::option::Option<&str> {
        self.cluster_identifier.as_deref()
    }
    /// <p>The Amazon Web Services account ID of the owner of the cluster.</p>
    pub fn resource_owner(&self) -> std::option::Option<&str> {
        self.resource_owner.as_deref()
    }
    /// <p>The subnet group name where Amazon Redshift chooses to deploy the endpoint.</p>
    pub fn subnet_group_name(&self) -> std::option::Option<&str> {
        self.subnet_group_name.as_deref()
    }
    /// <p>The status of the endpoint.</p>
    pub fn endpoint_status(&self) -> std::option::Option<&str> {
        self.endpoint_status.as_deref()
    }
    /// <p>The name of the endpoint.</p>
    pub fn endpoint_name(&self) -> std::option::Option<&str> {
        self.endpoint_name.as_deref()
    }
    /// <p>The time (UTC) that the endpoint was created.</p>
    pub fn endpoint_create_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.endpoint_create_time.as_ref()
    }
    /// <p>The port number on which the cluster accepts incoming connections.</p>
    pub fn port(&self) -> i32 {
        self.port
    }
    /// <p>The DNS address of the endpoint.</p>
    pub fn address(&self) -> std::option::Option<&str> {
        self.address.as_deref()
    }
    /// <p>The security groups associated with the endpoint.</p>
    pub fn vpc_security_groups(
        &self,
    ) -> std::option::Option<&[crate::model::VpcSecurityGroupMembership]> {
        self.vpc_security_groups.as_deref()
    }
    /// <p>The connection endpoint for connecting to an Amazon Redshift cluster through the proxy.</p>
    pub fn vpc_endpoint(&self) -> std::option::Option<&crate::model::VpcEndpoint> {
        self.vpc_endpoint.as_ref()
    }
}
impl std::fmt::Debug for DeleteEndpointAccessOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteEndpointAccessOutput");
        formatter.field("cluster_identifier", &self.cluster_identifier);
        formatter.field("resource_owner", &self.resource_owner);
        formatter.field("subnet_group_name", &self.subnet_group_name);
        formatter.field("endpoint_status", &self.endpoint_status);
        formatter.field("endpoint_name", &self.endpoint_name);
        formatter.field("endpoint_create_time", &self.endpoint_create_time);
        formatter.field("port", &self.port);
        formatter.field("address", &self.address);
        formatter.field("vpc_security_groups", &self.vpc_security_groups);
        formatter.field("vpc_endpoint", &self.vpc_endpoint);
        formatter.finish()
    }
}
/// See [`DeleteEndpointAccessOutput`](crate::output::DeleteEndpointAccessOutput)
pub mod delete_endpoint_access_output {
    /// A builder for [`DeleteEndpointAccessOutput`](crate::output::DeleteEndpointAccessOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) resource_owner: std::option::Option<std::string::String>,
        pub(crate) subnet_group_name: std::option::Option<std::string::String>,
        pub(crate) endpoint_status: std::option::Option<std::string::String>,
        pub(crate) endpoint_name: std::option::Option<std::string::String>,
        pub(crate) endpoint_create_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) port: std::option::Option<i32>,
        pub(crate) address: std::option::Option<std::string::String>,
        pub(crate) vpc_security_groups:
            std::option::Option<std::vec::Vec<crate::model::VpcSecurityGroupMembership>>,
        pub(crate) vpc_endpoint: std::option::Option<crate::model::VpcEndpoint>,
    }
    impl Builder {
        /// <p>The cluster identifier of the cluster associated with the endpoint.</p>
        pub fn cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_identifier = Some(input.into());
            self
        }
        /// <p>The cluster identifier of the cluster associated with the endpoint.</p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cluster_identifier = input;
            self
        }
        /// <p>The Amazon Web Services account ID of the owner of the cluster.</p>
        pub fn resource_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_owner = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID of the owner of the cluster.</p>
        pub fn set_resource_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_owner = input;
            self
        }
        /// <p>The subnet group name where Amazon Redshift chooses to deploy the endpoint.</p>
        pub fn subnet_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.subnet_group_name = Some(input.into());
            self
        }
        /// <p>The subnet group name where Amazon Redshift chooses to deploy the endpoint.</p>
        pub fn set_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.subnet_group_name = input;
            self
        }
        /// <p>The status of the endpoint.</p>
        pub fn endpoint_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_status = Some(input.into());
            self
        }
        /// <p>The status of the endpoint.</p>
        pub fn set_endpoint_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.endpoint_status = input;
            self
        }
        /// <p>The name of the endpoint.</p>
        pub fn endpoint_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_name = Some(input.into());
            self
        }
        /// <p>The name of the endpoint.</p>
        pub fn set_endpoint_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.endpoint_name = input;
            self
        }
        /// <p>The time (UTC) that the endpoint was created.</p>
        pub fn endpoint_create_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.endpoint_create_time = Some(input);
            self
        }
        /// <p>The time (UTC) that the endpoint was created.</p>
        pub fn set_endpoint_create_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.endpoint_create_time = input;
            self
        }
        /// <p>The port number on which the cluster accepts incoming connections.</p>
        pub fn port(mut self, input: i32) -> Self {
            self.port = Some(input);
            self
        }
        /// <p>The port number on which the cluster accepts incoming connections.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.port = input;
            self
        }
        /// <p>The DNS address of the endpoint.</p>
        pub fn address(mut self, input: impl Into<std::string::String>) -> Self {
            self.address = Some(input.into());
            self
        }
        /// <p>The DNS address of the endpoint.</p>
        pub fn set_address(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.address = input;
            self
        }
        /// Appends an item to `vpc_security_groups`.
        ///
        /// To override the contents of this collection use [`set_vpc_security_groups`](Self::set_vpc_security_groups).
        ///
        /// <p>The security groups associated with the endpoint.</p>
        pub fn vpc_security_groups(
            mut self,
            input: crate::model::VpcSecurityGroupMembership,
        ) -> Self {
            let mut v = self.vpc_security_groups.unwrap_or_default();
            v.push(input);
            self.vpc_security_groups = Some(v);
            self
        }
        /// <p>The security groups associated with the endpoint.</p>
        pub fn set_vpc_security_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::VpcSecurityGroupMembership>>,
        ) -> Self {
            self.vpc_security_groups = input;
            self
        }
        /// <p>The connection endpoint for connecting to an Amazon Redshift cluster through the proxy.</p>
        pub fn vpc_endpoint(mut self, input: crate::model::VpcEndpoint) -> Self {
            self.vpc_endpoint = Some(input);
            self
        }
        /// <p>The connection endpoint for connecting to an Amazon Redshift cluster through the proxy.</p>
        pub fn set_vpc_endpoint(
            mut self,
            input: std::option::Option<crate::model::VpcEndpoint>,
        ) -> Self {
            self.vpc_endpoint = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteEndpointAccessOutput`](crate::output::DeleteEndpointAccessOutput)
        pub fn build(self) -> crate::output::DeleteEndpointAccessOutput {
            crate::output::DeleteEndpointAccessOutput {
                cluster_identifier: self.cluster_identifier,
                resource_owner: self.resource_owner,
                subnet_group_name: self.subnet_group_name,
                endpoint_status: self.endpoint_status,
                endpoint_name: self.endpoint_name,
                endpoint_create_time: self.endpoint_create_time,
                port: self.port.unwrap_or_default(),
                address: self.address,
                vpc_security_groups: self.vpc_security_groups,
                vpc_endpoint: self.vpc_endpoint,
            }
        }
    }
}
impl DeleteEndpointAccessOutput {
    /// Creates a new builder-style object to manufacture [`DeleteEndpointAccessOutput`](crate::output::DeleteEndpointAccessOutput)
    pub fn builder() -> crate::output::delete_endpoint_access_output::Builder {
        crate::output::delete_endpoint_access_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteClusterSubnetGroupOutput {}
impl std::fmt::Debug for DeleteClusterSubnetGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteClusterSubnetGroupOutput");
        formatter.finish()
    }
}
/// See [`DeleteClusterSubnetGroupOutput`](crate::output::DeleteClusterSubnetGroupOutput)
pub mod delete_cluster_subnet_group_output {
    /// A builder for [`DeleteClusterSubnetGroupOutput`](crate::output::DeleteClusterSubnetGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteClusterSubnetGroupOutput`](crate::output::DeleteClusterSubnetGroupOutput)
        pub fn build(self) -> crate::output::DeleteClusterSubnetGroupOutput {
            crate::output::DeleteClusterSubnetGroupOutput {}
        }
    }
}
impl DeleteClusterSubnetGroupOutput {
    /// Creates a new builder-style object to manufacture [`DeleteClusterSubnetGroupOutput`](crate::output::DeleteClusterSubnetGroupOutput)
    pub fn builder() -> crate::output::delete_cluster_subnet_group_output::Builder {
        crate::output::delete_cluster_subnet_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteClusterSnapshotOutput {
    /// <p>Describes a snapshot.</p>
    pub snapshot: std::option::Option<crate::model::Snapshot>,
}
impl DeleteClusterSnapshotOutput {
    /// <p>Describes a snapshot.</p>
    pub fn snapshot(&self) -> std::option::Option<&crate::model::Snapshot> {
        self.snapshot.as_ref()
    }
}
impl std::fmt::Debug for DeleteClusterSnapshotOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteClusterSnapshotOutput");
        formatter.field("snapshot", &self.snapshot);
        formatter.finish()
    }
}
/// See [`DeleteClusterSnapshotOutput`](crate::output::DeleteClusterSnapshotOutput)
pub mod delete_cluster_snapshot_output {
    /// A builder for [`DeleteClusterSnapshotOutput`](crate::output::DeleteClusterSnapshotOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) snapshot: std::option::Option<crate::model::Snapshot>,
    }
    impl Builder {
        /// <p>Describes a snapshot.</p>
        pub fn snapshot(mut self, input: crate::model::Snapshot) -> Self {
            self.snapshot = Some(input);
            self
        }
        /// <p>Describes a snapshot.</p>
        pub fn set_snapshot(mut self, input: std::option::Option<crate::model::Snapshot>) -> Self {
            self.snapshot = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteClusterSnapshotOutput`](crate::output::DeleteClusterSnapshotOutput)
        pub fn build(self) -> crate::output::DeleteClusterSnapshotOutput {
            crate::output::DeleteClusterSnapshotOutput {
                snapshot: self.snapshot,
            }
        }
    }
}
impl DeleteClusterSnapshotOutput {
    /// Creates a new builder-style object to manufacture [`DeleteClusterSnapshotOutput`](crate::output::DeleteClusterSnapshotOutput)
    pub fn builder() -> crate::output::delete_cluster_snapshot_output::Builder {
        crate::output::delete_cluster_snapshot_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteClusterSecurityGroupOutput {}
impl std::fmt::Debug for DeleteClusterSecurityGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteClusterSecurityGroupOutput");
        formatter.finish()
    }
}
/// See [`DeleteClusterSecurityGroupOutput`](crate::output::DeleteClusterSecurityGroupOutput)
pub mod delete_cluster_security_group_output {
    /// A builder for [`DeleteClusterSecurityGroupOutput`](crate::output::DeleteClusterSecurityGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteClusterSecurityGroupOutput`](crate::output::DeleteClusterSecurityGroupOutput)
        pub fn build(self) -> crate::output::DeleteClusterSecurityGroupOutput {
            crate::output::DeleteClusterSecurityGroupOutput {}
        }
    }
}
impl DeleteClusterSecurityGroupOutput {
    /// Creates a new builder-style object to manufacture [`DeleteClusterSecurityGroupOutput`](crate::output::DeleteClusterSecurityGroupOutput)
    pub fn builder() -> crate::output::delete_cluster_security_group_output::Builder {
        crate::output::delete_cluster_security_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteClusterParameterGroupOutput {}
impl std::fmt::Debug for DeleteClusterParameterGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteClusterParameterGroupOutput");
        formatter.finish()
    }
}
/// See [`DeleteClusterParameterGroupOutput`](crate::output::DeleteClusterParameterGroupOutput)
pub mod delete_cluster_parameter_group_output {
    /// A builder for [`DeleteClusterParameterGroupOutput`](crate::output::DeleteClusterParameterGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteClusterParameterGroupOutput`](crate::output::DeleteClusterParameterGroupOutput)
        pub fn build(self) -> crate::output::DeleteClusterParameterGroupOutput {
            crate::output::DeleteClusterParameterGroupOutput {}
        }
    }
}
impl DeleteClusterParameterGroupOutput {
    /// Creates a new builder-style object to manufacture [`DeleteClusterParameterGroupOutput`](crate::output::DeleteClusterParameterGroupOutput)
    pub fn builder() -> crate::output::delete_cluster_parameter_group_output::Builder {
        crate::output::delete_cluster_parameter_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteClusterOutput {
    /// <p>Describes a cluster.</p>
    pub cluster: std::option::Option<crate::model::Cluster>,
}
impl DeleteClusterOutput {
    /// <p>Describes a cluster.</p>
    pub fn cluster(&self) -> std::option::Option<&crate::model::Cluster> {
        self.cluster.as_ref()
    }
}
impl std::fmt::Debug for DeleteClusterOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteClusterOutput");
        formatter.field("cluster", &self.cluster);
        formatter.finish()
    }
}
/// See [`DeleteClusterOutput`](crate::output::DeleteClusterOutput)
pub mod delete_cluster_output {
    /// A builder for [`DeleteClusterOutput`](crate::output::DeleteClusterOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster: std::option::Option<crate::model::Cluster>,
    }
    impl Builder {
        /// <p>Describes a cluster.</p>
        pub fn cluster(mut self, input: crate::model::Cluster) -> Self {
            self.cluster = Some(input);
            self
        }
        /// <p>Describes a cluster.</p>
        pub fn set_cluster(mut self, input: std::option::Option<crate::model::Cluster>) -> Self {
            self.cluster = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteClusterOutput`](crate::output::DeleteClusterOutput)
        pub fn build(self) -> crate::output::DeleteClusterOutput {
            crate::output::DeleteClusterOutput {
                cluster: self.cluster,
            }
        }
    }
}
impl DeleteClusterOutput {
    /// Creates a new builder-style object to manufacture [`DeleteClusterOutput`](crate::output::DeleteClusterOutput)
    pub fn builder() -> crate::output::delete_cluster_output::Builder {
        crate::output::delete_cluster_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteAuthenticationProfileOutput {
    /// <p>The name of the authentication profile that was deleted.</p>
    pub authentication_profile_name: std::option::Option<std::string::String>,
}
impl DeleteAuthenticationProfileOutput {
    /// <p>The name of the authentication profile that was deleted.</p>
    pub fn authentication_profile_name(&self) -> std::option::Option<&str> {
        self.authentication_profile_name.as_deref()
    }
}
impl std::fmt::Debug for DeleteAuthenticationProfileOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteAuthenticationProfileOutput");
        formatter.field(
            "authentication_profile_name",
            &self.authentication_profile_name,
        );
        formatter.finish()
    }
}
/// See [`DeleteAuthenticationProfileOutput`](crate::output::DeleteAuthenticationProfileOutput)
pub mod delete_authentication_profile_output {
    /// A builder for [`DeleteAuthenticationProfileOutput`](crate::output::DeleteAuthenticationProfileOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authentication_profile_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the authentication profile that was deleted.</p>
        pub fn authentication_profile_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.authentication_profile_name = Some(input.into());
            self
        }
        /// <p>The name of the authentication profile that was deleted.</p>
        pub fn set_authentication_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authentication_profile_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteAuthenticationProfileOutput`](crate::output::DeleteAuthenticationProfileOutput)
        pub fn build(self) -> crate::output::DeleteAuthenticationProfileOutput {
            crate::output::DeleteAuthenticationProfileOutput {
                authentication_profile_name: self.authentication_profile_name,
            }
        }
    }
}
impl DeleteAuthenticationProfileOutput {
    /// Creates a new builder-style object to manufacture [`DeleteAuthenticationProfileOutput`](crate::output::DeleteAuthenticationProfileOutput)
    pub fn builder() -> crate::output::delete_authentication_profile_output::Builder {
        crate::output::delete_authentication_profile_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeauthorizeDataShareOutput {
    /// <p>An Amazon Resource Name (ARN) that references the datashare that is owned by a specific namespace of the producer cluster. A datashare ARN is in the <code>arn:aws:redshift:{region}:{account-id}:{datashare}:{namespace-guid}/{datashare-name}</code> format.</p>
    pub data_share_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the producer.</p>
    pub producer_arn: std::option::Option<std::string::String>,
    /// <p>A value that specifies whether the datashare can be shared to a publicly accessible cluster.</p>
    pub allow_publicly_accessible_consumers: bool,
    /// <p>A value that specifies when the datashare has an association between a producer and data consumers.</p>
    pub data_share_associations:
        std::option::Option<std::vec::Vec<crate::model::DataShareAssociation>>,
    /// <p>The identifier of a datashare to show its managing entity.</p>
    pub managed_by: std::option::Option<std::string::String>,
}
impl DeauthorizeDataShareOutput {
    /// <p>An Amazon Resource Name (ARN) that references the datashare that is owned by a specific namespace of the producer cluster. A datashare ARN is in the <code>arn:aws:redshift:{region}:{account-id}:{datashare}:{namespace-guid}/{datashare-name}</code> format.</p>
    pub fn data_share_arn(&self) -> std::option::Option<&str> {
        self.data_share_arn.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the producer.</p>
    pub fn producer_arn(&self) -> std::option::Option<&str> {
        self.producer_arn.as_deref()
    }
    /// <p>A value that specifies whether the datashare can be shared to a publicly accessible cluster.</p>
    pub fn allow_publicly_accessible_consumers(&self) -> bool {
        self.allow_publicly_accessible_consumers
    }
    /// <p>A value that specifies when the datashare has an association between a producer and data consumers.</p>
    pub fn data_share_associations(
        &self,
    ) -> std::option::Option<&[crate::model::DataShareAssociation]> {
        self.data_share_associations.as_deref()
    }
    /// <p>The identifier of a datashare to show its managing entity.</p>
    pub fn managed_by(&self) -> std::option::Option<&str> {
        self.managed_by.as_deref()
    }
}
impl std::fmt::Debug for DeauthorizeDataShareOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeauthorizeDataShareOutput");
        formatter.field("data_share_arn", &self.data_share_arn);
        formatter.field("producer_arn", &self.producer_arn);
        formatter.field(
            "allow_publicly_accessible_consumers",
            &self.allow_publicly_accessible_consumers,
        );
        formatter.field("data_share_associations", &self.data_share_associations);
        formatter.field("managed_by", &self.managed_by);
        formatter.finish()
    }
}
/// See [`DeauthorizeDataShareOutput`](crate::output::DeauthorizeDataShareOutput)
pub mod deauthorize_data_share_output {
    /// A builder for [`DeauthorizeDataShareOutput`](crate::output::DeauthorizeDataShareOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data_share_arn: std::option::Option<std::string::String>,
        pub(crate) producer_arn: std::option::Option<std::string::String>,
        pub(crate) allow_publicly_accessible_consumers: std::option::Option<bool>,
        pub(crate) data_share_associations:
            std::option::Option<std::vec::Vec<crate::model::DataShareAssociation>>,
        pub(crate) managed_by: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>An Amazon Resource Name (ARN) that references the datashare that is owned by a specific namespace of the producer cluster. A datashare ARN is in the <code>arn:aws:redshift:{region}:{account-id}:{datashare}:{namespace-guid}/{datashare-name}</code> format.</p>
        pub fn data_share_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_share_arn = Some(input.into());
            self
        }
        /// <p>An Amazon Resource Name (ARN) that references the datashare that is owned by a specific namespace of the producer cluster. A datashare ARN is in the <code>arn:aws:redshift:{region}:{account-id}:{datashare}:{namespace-guid}/{datashare-name}</code> format.</p>
        pub fn set_data_share_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_share_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the producer.</p>
        pub fn producer_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.producer_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the producer.</p>
        pub fn set_producer_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.producer_arn = input;
            self
        }
        /// <p>A value that specifies whether the datashare can be shared to a publicly accessible cluster.</p>
        pub fn allow_publicly_accessible_consumers(mut self, input: bool) -> Self {
            self.allow_publicly_accessible_consumers = Some(input);
            self
        }
        /// <p>A value that specifies whether the datashare can be shared to a publicly accessible cluster.</p>
        pub fn set_allow_publicly_accessible_consumers(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.allow_publicly_accessible_consumers = input;
            self
        }
        /// Appends an item to `data_share_associations`.
        ///
        /// To override the contents of this collection use [`set_data_share_associations`](Self::set_data_share_associations).
        ///
        /// <p>A value that specifies when the datashare has an association between a producer and data consumers.</p>
        pub fn data_share_associations(
            mut self,
            input: crate::model::DataShareAssociation,
        ) -> Self {
            let mut v = self.data_share_associations.unwrap_or_default();
            v.push(input);
            self.data_share_associations = Some(v);
            self
        }
        /// <p>A value that specifies when the datashare has an association between a producer and data consumers.</p>
        pub fn set_data_share_associations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DataShareAssociation>>,
        ) -> Self {
            self.data_share_associations = input;
            self
        }
        /// <p>The identifier of a datashare to show its managing entity.</p>
        pub fn managed_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.managed_by = Some(input.into());
            self
        }
        /// <p>The identifier of a datashare to show its managing entity.</p>
        pub fn set_managed_by(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.managed_by = input;
            self
        }
        /// Consumes the builder and constructs a [`DeauthorizeDataShareOutput`](crate::output::DeauthorizeDataShareOutput)
        pub fn build(self) -> crate::output::DeauthorizeDataShareOutput {
            crate::output::DeauthorizeDataShareOutput {
                data_share_arn: self.data_share_arn,
                producer_arn: self.producer_arn,
                allow_publicly_accessible_consumers: self
                    .allow_publicly_accessible_consumers
                    .unwrap_or_default(),
                data_share_associations: self.data_share_associations,
                managed_by: self.managed_by,
            }
        }
    }
}
impl DeauthorizeDataShareOutput {
    /// Creates a new builder-style object to manufacture [`DeauthorizeDataShareOutput`](crate::output::DeauthorizeDataShareOutput)
    pub fn builder() -> crate::output::deauthorize_data_share_output::Builder {
        crate::output::deauthorize_data_share_output::Builder::default()
    }
}

/// <p>Describes a usage limit object for a cluster. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateUsageLimitOutput {
    /// <p>The identifier of the usage limit.</p>
    pub usage_limit_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the cluster with a usage limit.</p>
    pub cluster_identifier: std::option::Option<std::string::String>,
    /// <p>The Amazon Redshift feature to which the limit applies.</p>
    pub feature_type: std::option::Option<crate::model::UsageLimitFeatureType>,
    /// <p>The type of limit. Depending on the feature type, this can be based on a time duration or data size.</p>
    pub limit_type: std::option::Option<crate::model::UsageLimitLimitType>,
    /// <p>The limit amount. If time-based, this amount is in minutes. If data-based, this amount is in terabytes (TB).</p>
    pub amount: i64,
    /// <p>The time period that the amount applies to. A <code>weekly</code> period begins on Sunday. The default is <code>monthly</code>. </p>
    pub period: std::option::Option<crate::model::UsageLimitPeriod>,
    /// <p>The action that Amazon Redshift takes when the limit is reached. Possible values are: </p>
    /// <ul>
    /// <li> <p> <b>log</b> - To log an event in a system table. The default is log.</p> </li>
    /// <li> <p> <b>emit-metric</b> - To emit CloudWatch metrics.</p> </li>
    /// <li> <p> <b>disable</b> - To disable the feature until the next usage period begins.</p> </li>
    /// </ul>
    pub breach_action: std::option::Option<crate::model::UsageLimitBreachAction>,
    /// <p>A list of tag instances.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl CreateUsageLimitOutput {
    /// <p>The identifier of the usage limit.</p>
    pub fn usage_limit_id(&self) -> std::option::Option<&str> {
        self.usage_limit_id.as_deref()
    }
    /// <p>The identifier of the cluster with a usage limit.</p>
    pub fn cluster_identifier(&self) -> std::option::Option<&str> {
        self.cluster_identifier.as_deref()
    }
    /// <p>The Amazon Redshift feature to which the limit applies.</p>
    pub fn feature_type(&self) -> std::option::Option<&crate::model::UsageLimitFeatureType> {
        self.feature_type.as_ref()
    }
    /// <p>The type of limit. Depending on the feature type, this can be based on a time duration or data size.</p>
    pub fn limit_type(&self) -> std::option::Option<&crate::model::UsageLimitLimitType> {
        self.limit_type.as_ref()
    }
    /// <p>The limit amount. If time-based, this amount is in minutes. If data-based, this amount is in terabytes (TB).</p>
    pub fn amount(&self) -> i64 {
        self.amount
    }
    /// <p>The time period that the amount applies to. A <code>weekly</code> period begins on Sunday. The default is <code>monthly</code>. </p>
    pub fn period(&self) -> std::option::Option<&crate::model::UsageLimitPeriod> {
        self.period.as_ref()
    }
    /// <p>The action that Amazon Redshift takes when the limit is reached. Possible values are: </p>
    /// <ul>
    /// <li> <p> <b>log</b> - To log an event in a system table. The default is log.</p> </li>
    /// <li> <p> <b>emit-metric</b> - To emit CloudWatch metrics.</p> </li>
    /// <li> <p> <b>disable</b> - To disable the feature until the next usage period begins.</p> </li>
    /// </ul>
    pub fn breach_action(&self) -> std::option::Option<&crate::model::UsageLimitBreachAction> {
        self.breach_action.as_ref()
    }
    /// <p>A list of tag instances.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for CreateUsageLimitOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateUsageLimitOutput");
        formatter.field("usage_limit_id", &self.usage_limit_id);
        formatter.field("cluster_identifier", &self.cluster_identifier);
        formatter.field("feature_type", &self.feature_type);
        formatter.field("limit_type", &self.limit_type);
        formatter.field("amount", &self.amount);
        formatter.field("period", &self.period);
        formatter.field("breach_action", &self.breach_action);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`CreateUsageLimitOutput`](crate::output::CreateUsageLimitOutput)
pub mod create_usage_limit_output {
    /// A builder for [`CreateUsageLimitOutput`](crate::output::CreateUsageLimitOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) usage_limit_id: std::option::Option<std::string::String>,
        pub(crate) cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) feature_type: std::option::Option<crate::model::UsageLimitFeatureType>,
        pub(crate) limit_type: std::option::Option<crate::model::UsageLimitLimitType>,
        pub(crate) amount: std::option::Option<i64>,
        pub(crate) period: std::option::Option<crate::model::UsageLimitPeriod>,
        pub(crate) breach_action: std::option::Option<crate::model::UsageLimitBreachAction>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The identifier of the usage limit.</p>
        pub fn usage_limit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.usage_limit_id = Some(input.into());
            self
        }
        /// <p>The identifier of the usage limit.</p>
        pub fn set_usage_limit_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.usage_limit_id = input;
            self
        }
        /// <p>The identifier of the cluster with a usage limit.</p>
        pub fn cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_identifier = Some(input.into());
            self
        }
        /// <p>The identifier of the cluster with a usage limit.</p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cluster_identifier = input;
            self
        }
        /// <p>The Amazon Redshift feature to which the limit applies.</p>
        pub fn feature_type(mut self, input: crate::model::UsageLimitFeatureType) -> Self {
            self.feature_type = Some(input);
            self
        }
        /// <p>The Amazon Redshift feature to which the limit applies.</p>
        pub fn set_feature_type(
            mut self,
            input: std::option::Option<crate::model::UsageLimitFeatureType>,
        ) -> Self {
            self.feature_type = input;
            self
        }
        /// <p>The type of limit. Depending on the feature type, this can be based on a time duration or data size.</p>
        pub fn limit_type(mut self, input: crate::model::UsageLimitLimitType) -> Self {
            self.limit_type = Some(input);
            self
        }
        /// <p>The type of limit. Depending on the feature type, this can be based on a time duration or data size.</p>
        pub fn set_limit_type(
            mut self,
            input: std::option::Option<crate::model::UsageLimitLimitType>,
        ) -> Self {
            self.limit_type = input;
            self
        }
        /// <p>The limit amount. If time-based, this amount is in minutes. If data-based, this amount is in terabytes (TB).</p>
        pub fn amount(mut self, input: i64) -> Self {
            self.amount = Some(input);
            self
        }
        /// <p>The limit amount. If time-based, this amount is in minutes. If data-based, this amount is in terabytes (TB).</p>
        pub fn set_amount(mut self, input: std::option::Option<i64>) -> Self {
            self.amount = input;
            self
        }
        /// <p>The time period that the amount applies to. A <code>weekly</code> period begins on Sunday. The default is <code>monthly</code>. </p>
        pub fn period(mut self, input: crate::model::UsageLimitPeriod) -> Self {
            self.period = Some(input);
            self
        }
        /// <p>The time period that the amount applies to. A <code>weekly</code> period begins on Sunday. The default is <code>monthly</code>. </p>
        pub fn set_period(
            mut self,
            input: std::option::Option<crate::model::UsageLimitPeriod>,
        ) -> Self {
            self.period = input;
            self
        }
        /// <p>The action that Amazon Redshift takes when the limit is reached. Possible values are: </p>
        /// <ul>
        /// <li> <p> <b>log</b> - To log an event in a system table. The default is log.</p> </li>
        /// <li> <p> <b>emit-metric</b> - To emit CloudWatch metrics.</p> </li>
        /// <li> <p> <b>disable</b> - To disable the feature until the next usage period begins.</p> </li>
        /// </ul>
        pub fn breach_action(mut self, input: crate::model::UsageLimitBreachAction) -> Self {
            self.breach_action = Some(input);
            self
        }
        /// <p>The action that Amazon Redshift takes when the limit is reached. Possible values are: </p>
        /// <ul>
        /// <li> <p> <b>log</b> - To log an event in a system table. The default is log.</p> </li>
        /// <li> <p> <b>emit-metric</b> - To emit CloudWatch metrics.</p> </li>
        /// <li> <p> <b>disable</b> - To disable the feature until the next usage period begins.</p> </li>
        /// </ul>
        pub fn set_breach_action(
            mut self,
            input: std::option::Option<crate::model::UsageLimitBreachAction>,
        ) -> Self {
            self.breach_action = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tag instances.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>A list of tag instances.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateUsageLimitOutput`](crate::output::CreateUsageLimitOutput)
        pub fn build(self) -> crate::output::CreateUsageLimitOutput {
            crate::output::CreateUsageLimitOutput {
                usage_limit_id: self.usage_limit_id,
                cluster_identifier: self.cluster_identifier,
                feature_type: self.feature_type,
                limit_type: self.limit_type,
                amount: self.amount.unwrap_or_default(),
                period: self.period,
                breach_action: self.breach_action,
                tags: self.tags,
            }
        }
    }
}
impl CreateUsageLimitOutput {
    /// Creates a new builder-style object to manufacture [`CreateUsageLimitOutput`](crate::output::CreateUsageLimitOutput)
    pub fn builder() -> crate::output::create_usage_limit_output::Builder {
        crate::output::create_usage_limit_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateTagsOutput {}
impl std::fmt::Debug for CreateTagsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateTagsOutput");
        formatter.finish()
    }
}
/// See [`CreateTagsOutput`](crate::output::CreateTagsOutput)
pub mod create_tags_output {
    /// A builder for [`CreateTagsOutput`](crate::output::CreateTagsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`CreateTagsOutput`](crate::output::CreateTagsOutput)
        pub fn build(self) -> crate::output::CreateTagsOutput {
            crate::output::CreateTagsOutput {}
        }
    }
}
impl CreateTagsOutput {
    /// Creates a new builder-style object to manufacture [`CreateTagsOutput`](crate::output::CreateTagsOutput)
    pub fn builder() -> crate::output::create_tags_output::Builder {
        crate::output::create_tags_output::Builder::default()
    }
}

/// <p>Describes a snapshot schedule. You can set a regular interval for creating snapshots of a cluster. You can also schedule snapshots for specific dates. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateSnapshotScheduleOutput {
    /// <p>A list of ScheduleDefinitions.</p>
    pub schedule_definitions: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A unique identifier for the schedule.</p>
    pub schedule_identifier: std::option::Option<std::string::String>,
    /// <p>The description of the schedule.</p>
    pub schedule_description: std::option::Option<std::string::String>,
    /// <p>An optional set of tags describing the schedule.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p></p>
    pub next_invocations: std::option::Option<std::vec::Vec<aws_smithy_types::DateTime>>,
    /// <p>The number of clusters associated with the schedule.</p>
    pub associated_cluster_count: std::option::Option<i32>,
    /// <p>A list of clusters associated with the schedule. A maximum of 100 clusters is returned.</p>
    pub associated_clusters:
        std::option::Option<std::vec::Vec<crate::model::ClusterAssociatedToSchedule>>,
}
impl CreateSnapshotScheduleOutput {
    /// <p>A list of ScheduleDefinitions.</p>
    pub fn schedule_definitions(&self) -> std::option::Option<&[std::string::String]> {
        self.schedule_definitions.as_deref()
    }
    /// <p>A unique identifier for the schedule.</p>
    pub fn schedule_identifier(&self) -> std::option::Option<&str> {
        self.schedule_identifier.as_deref()
    }
    /// <p>The description of the schedule.</p>
    pub fn schedule_description(&self) -> std::option::Option<&str> {
        self.schedule_description.as_deref()
    }
    /// <p>An optional set of tags describing the schedule.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p></p>
    pub fn next_invocations(&self) -> std::option::Option<&[aws_smithy_types::DateTime]> {
        self.next_invocations.as_deref()
    }
    /// <p>The number of clusters associated with the schedule.</p>
    pub fn associated_cluster_count(&self) -> std::option::Option<i32> {
        self.associated_cluster_count
    }
    /// <p>A list of clusters associated with the schedule. A maximum of 100 clusters is returned.</p>
    pub fn associated_clusters(
        &self,
    ) -> std::option::Option<&[crate::model::ClusterAssociatedToSchedule]> {
        self.associated_clusters.as_deref()
    }
}
impl std::fmt::Debug for CreateSnapshotScheduleOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateSnapshotScheduleOutput");
        formatter.field("schedule_definitions", &self.schedule_definitions);
        formatter.field("schedule_identifier", &self.schedule_identifier);
        formatter.field("schedule_description", &self.schedule_description);
        formatter.field("tags", &self.tags);
        formatter.field("next_invocations", &self.next_invocations);
        formatter.field("associated_cluster_count", &self.associated_cluster_count);
        formatter.field("associated_clusters", &self.associated_clusters);
        formatter.finish()
    }
}
/// See [`CreateSnapshotScheduleOutput`](crate::output::CreateSnapshotScheduleOutput)
pub mod create_snapshot_schedule_output {
    /// A builder for [`CreateSnapshotScheduleOutput`](crate::output::CreateSnapshotScheduleOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) schedule_definitions: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) schedule_identifier: std::option::Option<std::string::String>,
        pub(crate) schedule_description: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) next_invocations: std::option::Option<std::vec::Vec<aws_smithy_types::DateTime>>,
        pub(crate) associated_cluster_count: std::option::Option<i32>,
        pub(crate) associated_clusters:
            std::option::Option<std::vec::Vec<crate::model::ClusterAssociatedToSchedule>>,
    }
    impl Builder {
        /// Appends an item to `schedule_definitions`.
        ///
        /// To override the contents of this collection use [`set_schedule_definitions`](Self::set_schedule_definitions).
        ///
        /// <p>A list of ScheduleDefinitions.</p>
        pub fn schedule_definitions(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.schedule_definitions.unwrap_or_default();
            v.push(input.into());
            self.schedule_definitions = Some(v);
            self
        }
        /// <p>A list of ScheduleDefinitions.</p>
        pub fn set_schedule_definitions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.schedule_definitions = input;
            self
        }
        /// <p>A unique identifier for the schedule.</p>
        pub fn schedule_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.schedule_identifier = Some(input.into());
            self
        }
        /// <p>A unique identifier for the schedule.</p>
        pub fn set_schedule_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.schedule_identifier = input;
            self
        }
        /// <p>The description of the schedule.</p>
        pub fn schedule_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.schedule_description = Some(input.into());
            self
        }
        /// <p>The description of the schedule.</p>
        pub fn set_schedule_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.schedule_description = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An optional set of tags describing the schedule.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>An optional set of tags describing the schedule.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Appends an item to `next_invocations`.
        ///
        /// To override the contents of this collection use [`set_next_invocations`](Self::set_next_invocations).
        ///
        /// <p></p>
        pub fn next_invocations(mut self, input: aws_smithy_types::DateTime) -> Self {
            let mut v = self.next_invocations.unwrap_or_default();
            v.push(input);
            self.next_invocations = Some(v);
            self
        }
        /// <p></p>
        pub fn set_next_invocations(
            mut self,
            input: std::option::Option<std::vec::Vec<aws_smithy_types::DateTime>>,
        ) -> Self {
            self.next_invocations = input;
            self
        }
        /// <p>The number of clusters associated with the schedule.</p>
        pub fn associated_cluster_count(mut self, input: i32) -> Self {
            self.associated_cluster_count = Some(input);
            self
        }
        /// <p>The number of clusters associated with the schedule.</p>
        pub fn set_associated_cluster_count(mut self, input: std::option::Option<i32>) -> Self {
            self.associated_cluster_count = input;
            self
        }
        /// Appends an item to `associated_clusters`.
        ///
        /// To override the contents of this collection use [`set_associated_clusters`](Self::set_associated_clusters).
        ///
        /// <p>A list of clusters associated with the schedule. A maximum of 100 clusters is returned.</p>
        pub fn associated_clusters(
            mut self,
            input: crate::model::ClusterAssociatedToSchedule,
        ) -> Self {
            let mut v = self.associated_clusters.unwrap_or_default();
            v.push(input);
            self.associated_clusters = Some(v);
            self
        }
        /// <p>A list of clusters associated with the schedule. A maximum of 100 clusters is returned.</p>
        pub fn set_associated_clusters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ClusterAssociatedToSchedule>>,
        ) -> Self {
            self.associated_clusters = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateSnapshotScheduleOutput`](crate::output::CreateSnapshotScheduleOutput)
        pub fn build(self) -> crate::output::CreateSnapshotScheduleOutput {
            crate::output::CreateSnapshotScheduleOutput {
                schedule_definitions: self.schedule_definitions,
                schedule_identifier: self.schedule_identifier,
                schedule_description: self.schedule_description,
                tags: self.tags,
                next_invocations: self.next_invocations,
                associated_cluster_count: self.associated_cluster_count,
                associated_clusters: self.associated_clusters,
            }
        }
    }
}
impl CreateSnapshotScheduleOutput {
    /// Creates a new builder-style object to manufacture [`CreateSnapshotScheduleOutput`](crate::output::CreateSnapshotScheduleOutput)
    pub fn builder() -> crate::output::create_snapshot_schedule_output::Builder {
        crate::output::create_snapshot_schedule_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateSnapshotCopyGrantOutput {
    /// <p>The snapshot copy grant that grants Amazon Redshift permission to encrypt copied snapshots with the specified encrypted symmetric key from Amazon Web Services KMS in the destination region.</p>
    /// <p> For more information about managing snapshot copy grants, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-db-encryption.html">Amazon Redshift Database Encryption</a> in the <i>Amazon Redshift Cluster Management Guide</i>. </p>
    pub snapshot_copy_grant: std::option::Option<crate::model::SnapshotCopyGrant>,
}
impl CreateSnapshotCopyGrantOutput {
    /// <p>The snapshot copy grant that grants Amazon Redshift permission to encrypt copied snapshots with the specified encrypted symmetric key from Amazon Web Services KMS in the destination region.</p>
    /// <p> For more information about managing snapshot copy grants, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-db-encryption.html">Amazon Redshift Database Encryption</a> in the <i>Amazon Redshift Cluster Management Guide</i>. </p>
    pub fn snapshot_copy_grant(&self) -> std::option::Option<&crate::model::SnapshotCopyGrant> {
        self.snapshot_copy_grant.as_ref()
    }
}
impl std::fmt::Debug for CreateSnapshotCopyGrantOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateSnapshotCopyGrantOutput");
        formatter.field("snapshot_copy_grant", &self.snapshot_copy_grant);
        formatter.finish()
    }
}
/// See [`CreateSnapshotCopyGrantOutput`](crate::output::CreateSnapshotCopyGrantOutput)
pub mod create_snapshot_copy_grant_output {
    /// A builder for [`CreateSnapshotCopyGrantOutput`](crate::output::CreateSnapshotCopyGrantOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) snapshot_copy_grant: std::option::Option<crate::model::SnapshotCopyGrant>,
    }
    impl Builder {
        /// <p>The snapshot copy grant that grants Amazon Redshift permission to encrypt copied snapshots with the specified encrypted symmetric key from Amazon Web Services KMS in the destination region.</p>
        /// <p> For more information about managing snapshot copy grants, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-db-encryption.html">Amazon Redshift Database Encryption</a> in the <i>Amazon Redshift Cluster Management Guide</i>. </p>
        pub fn snapshot_copy_grant(mut self, input: crate::model::SnapshotCopyGrant) -> Self {
            self.snapshot_copy_grant = Some(input);
            self
        }
        /// <p>The snapshot copy grant that grants Amazon Redshift permission to encrypt copied snapshots with the specified encrypted symmetric key from Amazon Web Services KMS in the destination region.</p>
        /// <p> For more information about managing snapshot copy grants, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-db-encryption.html">Amazon Redshift Database Encryption</a> in the <i>Amazon Redshift Cluster Management Guide</i>. </p>
        pub fn set_snapshot_copy_grant(
            mut self,
            input: std::option::Option<crate::model::SnapshotCopyGrant>,
        ) -> Self {
            self.snapshot_copy_grant = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateSnapshotCopyGrantOutput`](crate::output::CreateSnapshotCopyGrantOutput)
        pub fn build(self) -> crate::output::CreateSnapshotCopyGrantOutput {
            crate::output::CreateSnapshotCopyGrantOutput {
                snapshot_copy_grant: self.snapshot_copy_grant,
            }
        }
    }
}
impl CreateSnapshotCopyGrantOutput {
    /// Creates a new builder-style object to manufacture [`CreateSnapshotCopyGrantOutput`](crate::output::CreateSnapshotCopyGrantOutput)
    pub fn builder() -> crate::output::create_snapshot_copy_grant_output::Builder {
        crate::output::create_snapshot_copy_grant_output::Builder::default()
    }
}

/// <p>Describes a scheduled action. You can use a scheduled action to trigger some Amazon Redshift API operations on a schedule. For information about which API operations can be scheduled, see <code>ScheduledActionType</code>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateScheduledActionOutput {
    /// <p>The name of the scheduled action. </p>
    pub scheduled_action_name: std::option::Option<std::string::String>,
    /// <p>A JSON format string of the Amazon Redshift API operation with input parameters. </p>
    /// <p>"<code>{\"ResizeCluster\":{\"NodeType\":\"ds2.8xlarge\",\"ClusterIdentifier\":\"my-test-cluster\",\"NumberOfNodes\":3}}</code>". </p>
    pub target_action: std::option::Option<crate::model::ScheduledActionType>,
    /// <p>The schedule for a one-time (at format) or recurring (cron format) scheduled action. Schedule invocations must be separated by at least one hour.</p>
    /// <p>Format of at expressions is "<code>at(yyyy-mm-ddThh:mm:ss)</code>". For example, "<code>at(2016-03-04T17:27:00)</code>".</p>
    /// <p>Format of cron expressions is "<code>cron(Minutes Hours Day-of-month Month Day-of-week Year)</code>". For example, "<code>cron(0 10 ? * MON *)</code>". For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html#CronExpressions">Cron Expressions</a> in the <i>Amazon CloudWatch Events User Guide</i>.</p>
    pub schedule: std::option::Option<std::string::String>,
    /// <p>The IAM role to assume to run the scheduled action. This IAM role must have permission to run the Amazon Redshift API operation in the scheduled action. This IAM role must allow the Amazon Redshift scheduler (Principal scheduler.redshift.amazonaws.com) to assume permissions on your behalf. For more information about the IAM role to use with the Amazon Redshift scheduler, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-identity-based.html">Using Identity-Based Policies for Amazon Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>. </p>
    pub iam_role: std::option::Option<std::string::String>,
    /// <p>The description of the scheduled action. </p>
    pub scheduled_action_description: std::option::Option<std::string::String>,
    /// <p>The state of the scheduled action. For example, <code>DISABLED</code>. </p>
    pub state: std::option::Option<crate::model::ScheduledActionState>,
    /// <p>List of times when the scheduled action will run. </p>
    pub next_invocations: std::option::Option<std::vec::Vec<aws_smithy_types::DateTime>>,
    /// <p>The start time in UTC when the schedule is active. Before this time, the scheduled action does not trigger. </p>
    pub start_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The end time in UTC when the schedule is no longer active. After this time, the scheduled action does not trigger. </p>
    pub end_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl CreateScheduledActionOutput {
    /// <p>The name of the scheduled action. </p>
    pub fn scheduled_action_name(&self) -> std::option::Option<&str> {
        self.scheduled_action_name.as_deref()
    }
    /// <p>A JSON format string of the Amazon Redshift API operation with input parameters. </p>
    /// <p>"<code>{\"ResizeCluster\":{\"NodeType\":\"ds2.8xlarge\",\"ClusterIdentifier\":\"my-test-cluster\",\"NumberOfNodes\":3}}</code>". </p>
    pub fn target_action(&self) -> std::option::Option<&crate::model::ScheduledActionType> {
        self.target_action.as_ref()
    }
    /// <p>The schedule for a one-time (at format) or recurring (cron format) scheduled action. Schedule invocations must be separated by at least one hour.</p>
    /// <p>Format of at expressions is "<code>at(yyyy-mm-ddThh:mm:ss)</code>". For example, "<code>at(2016-03-04T17:27:00)</code>".</p>
    /// <p>Format of cron expressions is "<code>cron(Minutes Hours Day-of-month Month Day-of-week Year)</code>". For example, "<code>cron(0 10 ? * MON *)</code>". For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html#CronExpressions">Cron Expressions</a> in the <i>Amazon CloudWatch Events User Guide</i>.</p>
    pub fn schedule(&self) -> std::option::Option<&str> {
        self.schedule.as_deref()
    }
    /// <p>The IAM role to assume to run the scheduled action. This IAM role must have permission to run the Amazon Redshift API operation in the scheduled action. This IAM role must allow the Amazon Redshift scheduler (Principal scheduler.redshift.amazonaws.com) to assume permissions on your behalf. For more information about the IAM role to use with the Amazon Redshift scheduler, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-identity-based.html">Using Identity-Based Policies for Amazon Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>. </p>
    pub fn iam_role(&self) -> std::option::Option<&str> {
        self.iam_role.as_deref()
    }
    /// <p>The description of the scheduled action. </p>
    pub fn scheduled_action_description(&self) -> std::option::Option<&str> {
        self.scheduled_action_description.as_deref()
    }
    /// <p>The state of the scheduled action. For example, <code>DISABLED</code>. </p>
    pub fn state(&self) -> std::option::Option<&crate::model::ScheduledActionState> {
        self.state.as_ref()
    }
    /// <p>List of times when the scheduled action will run. </p>
    pub fn next_invocations(&self) -> std::option::Option<&[aws_smithy_types::DateTime]> {
        self.next_invocations.as_deref()
    }
    /// <p>The start time in UTC when the schedule is active. Before this time, the scheduled action does not trigger. </p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start_time.as_ref()
    }
    /// <p>The end time in UTC when the schedule is no longer active. After this time, the scheduled action does not trigger. </p>
    pub fn end_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.end_time.as_ref()
    }
}
impl std::fmt::Debug for CreateScheduledActionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateScheduledActionOutput");
        formatter.field("scheduled_action_name", &self.scheduled_action_name);
        formatter.field("target_action", &self.target_action);
        formatter.field("schedule", &self.schedule);
        formatter.field("iam_role", &self.iam_role);
        formatter.field(
            "scheduled_action_description",
            &self.scheduled_action_description,
        );
        formatter.field("state", &self.state);
        formatter.field("next_invocations", &self.next_invocations);
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.finish()
    }
}
/// See [`CreateScheduledActionOutput`](crate::output::CreateScheduledActionOutput)
pub mod create_scheduled_action_output {
    /// A builder for [`CreateScheduledActionOutput`](crate::output::CreateScheduledActionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) scheduled_action_name: std::option::Option<std::string::String>,
        pub(crate) target_action: std::option::Option<crate::model::ScheduledActionType>,
        pub(crate) schedule: std::option::Option<std::string::String>,
        pub(crate) iam_role: std::option::Option<std::string::String>,
        pub(crate) scheduled_action_description: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::ScheduledActionState>,
        pub(crate) next_invocations: std::option::Option<std::vec::Vec<aws_smithy_types::DateTime>>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The name of the scheduled action. </p>
        pub fn scheduled_action_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.scheduled_action_name = Some(input.into());
            self
        }
        /// <p>The name of the scheduled action. </p>
        pub fn set_scheduled_action_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.scheduled_action_name = input;
            self
        }
        /// <p>A JSON format string of the Amazon Redshift API operation with input parameters. </p>
        /// <p>"<code>{\"ResizeCluster\":{\"NodeType\":\"ds2.8xlarge\",\"ClusterIdentifier\":\"my-test-cluster\",\"NumberOfNodes\":3}}</code>". </p>
        pub fn target_action(mut self, input: crate::model::ScheduledActionType) -> Self {
            self.target_action = Some(input);
            self
        }
        /// <p>A JSON format string of the Amazon Redshift API operation with input parameters. </p>
        /// <p>"<code>{\"ResizeCluster\":{\"NodeType\":\"ds2.8xlarge\",\"ClusterIdentifier\":\"my-test-cluster\",\"NumberOfNodes\":3}}</code>". </p>
        pub fn set_target_action(
            mut self,
            input: std::option::Option<crate::model::ScheduledActionType>,
        ) -> Self {
            self.target_action = input;
            self
        }
        /// <p>The schedule for a one-time (at format) or recurring (cron format) scheduled action. Schedule invocations must be separated by at least one hour.</p>
        /// <p>Format of at expressions is "<code>at(yyyy-mm-ddThh:mm:ss)</code>". For example, "<code>at(2016-03-04T17:27:00)</code>".</p>
        /// <p>Format of cron expressions is "<code>cron(Minutes Hours Day-of-month Month Day-of-week Year)</code>". For example, "<code>cron(0 10 ? * MON *)</code>". For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html#CronExpressions">Cron Expressions</a> in the <i>Amazon CloudWatch Events User Guide</i>.</p>
        pub fn schedule(mut self, input: impl Into<std::string::String>) -> Self {
            self.schedule = Some(input.into());
            self
        }
        /// <p>The schedule for a one-time (at format) or recurring (cron format) scheduled action. Schedule invocations must be separated by at least one hour.</p>
        /// <p>Format of at expressions is "<code>at(yyyy-mm-ddThh:mm:ss)</code>". For example, "<code>at(2016-03-04T17:27:00)</code>".</p>
        /// <p>Format of cron expressions is "<code>cron(Minutes Hours Day-of-month Month Day-of-week Year)</code>". For example, "<code>cron(0 10 ? * MON *)</code>". For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html#CronExpressions">Cron Expressions</a> in the <i>Amazon CloudWatch Events User Guide</i>.</p>
        pub fn set_schedule(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schedule = input;
            self
        }
        /// <p>The IAM role to assume to run the scheduled action. This IAM role must have permission to run the Amazon Redshift API operation in the scheduled action. This IAM role must allow the Amazon Redshift scheduler (Principal scheduler.redshift.amazonaws.com) to assume permissions on your behalf. For more information about the IAM role to use with the Amazon Redshift scheduler, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-identity-based.html">Using Identity-Based Policies for Amazon Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>. </p>
        pub fn iam_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.iam_role = Some(input.into());
            self
        }
        /// <p>The IAM role to assume to run the scheduled action. This IAM role must have permission to run the Amazon Redshift API operation in the scheduled action. This IAM role must allow the Amazon Redshift scheduler (Principal scheduler.redshift.amazonaws.com) to assume permissions on your behalf. For more information about the IAM role to use with the Amazon Redshift scheduler, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-identity-based.html">Using Identity-Based Policies for Amazon Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>. </p>
        pub fn set_iam_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.iam_role = input;
            self
        }
        /// <p>The description of the scheduled action. </p>
        pub fn scheduled_action_description(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.scheduled_action_description = Some(input.into());
            self
        }
        /// <p>The description of the scheduled action. </p>
        pub fn set_scheduled_action_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.scheduled_action_description = input;
            self
        }
        /// <p>The state of the scheduled action. For example, <code>DISABLED</code>. </p>
        pub fn state(mut self, input: crate::model::ScheduledActionState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The state of the scheduled action. For example, <code>DISABLED</code>. </p>
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::ScheduledActionState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// Appends an item to `next_invocations`.
        ///
        /// To override the contents of this collection use [`set_next_invocations`](Self::set_next_invocations).
        ///
        /// <p>List of times when the scheduled action will run. </p>
        pub fn next_invocations(mut self, input: aws_smithy_types::DateTime) -> Self {
            let mut v = self.next_invocations.unwrap_or_default();
            v.push(input);
            self.next_invocations = Some(v);
            self
        }
        /// <p>List of times when the scheduled action will run. </p>
        pub fn set_next_invocations(
            mut self,
            input: std::option::Option<std::vec::Vec<aws_smithy_types::DateTime>>,
        ) -> Self {
            self.next_invocations = input;
            self
        }
        /// <p>The start time in UTC when the schedule is active. Before this time, the scheduled action does not trigger. </p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The start time in UTC when the schedule is active. Before this time, the scheduled action does not trigger. </p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The end time in UTC when the schedule is no longer active. After this time, the scheduled action does not trigger. </p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>The end time in UTC when the schedule is no longer active. After this time, the scheduled action does not trigger. </p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateScheduledActionOutput`](crate::output::CreateScheduledActionOutput)
        pub fn build(self) -> crate::output::CreateScheduledActionOutput {
            crate::output::CreateScheduledActionOutput {
                scheduled_action_name: self.scheduled_action_name,
                target_action: self.target_action,
                schedule: self.schedule,
                iam_role: self.iam_role,
                scheduled_action_description: self.scheduled_action_description,
                state: self.state,
                next_invocations: self.next_invocations,
                start_time: self.start_time,
                end_time: self.end_time,
            }
        }
    }
}
impl CreateScheduledActionOutput {
    /// Creates a new builder-style object to manufacture [`CreateScheduledActionOutput`](crate::output::CreateScheduledActionOutput)
    pub fn builder() -> crate::output::create_scheduled_action_output::Builder {
        crate::output::create_scheduled_action_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateHsmConfigurationOutput {
    /// <p>Returns information about an HSM configuration, which is an object that describes to Amazon Redshift clusters the information they require to connect to an HSM where they can store database encryption keys.</p>
    pub hsm_configuration: std::option::Option<crate::model::HsmConfiguration>,
}
impl CreateHsmConfigurationOutput {
    /// <p>Returns information about an HSM configuration, which is an object that describes to Amazon Redshift clusters the information they require to connect to an HSM where they can store database encryption keys.</p>
    pub fn hsm_configuration(&self) -> std::option::Option<&crate::model::HsmConfiguration> {
        self.hsm_configuration.as_ref()
    }
}
impl std::fmt::Debug for CreateHsmConfigurationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateHsmConfigurationOutput");
        formatter.field("hsm_configuration", &self.hsm_configuration);
        formatter.finish()
    }
}
/// See [`CreateHsmConfigurationOutput`](crate::output::CreateHsmConfigurationOutput)
pub mod create_hsm_configuration_output {
    /// A builder for [`CreateHsmConfigurationOutput`](crate::output::CreateHsmConfigurationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) hsm_configuration: std::option::Option<crate::model::HsmConfiguration>,
    }
    impl Builder {
        /// <p>Returns information about an HSM configuration, which is an object that describes to Amazon Redshift clusters the information they require to connect to an HSM where they can store database encryption keys.</p>
        pub fn hsm_configuration(mut self, input: crate::model::HsmConfiguration) -> Self {
            self.hsm_configuration = Some(input);
            self
        }
        /// <p>Returns information about an HSM configuration, which is an object that describes to Amazon Redshift clusters the information they require to connect to an HSM where they can store database encryption keys.</p>
        pub fn set_hsm_configuration(
            mut self,
            input: std::option::Option<crate::model::HsmConfiguration>,
        ) -> Self {
            self.hsm_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateHsmConfigurationOutput`](crate::output::CreateHsmConfigurationOutput)
        pub fn build(self) -> crate::output::CreateHsmConfigurationOutput {
            crate::output::CreateHsmConfigurationOutput {
                hsm_configuration: self.hsm_configuration,
            }
        }
    }
}
impl CreateHsmConfigurationOutput {
    /// Creates a new builder-style object to manufacture [`CreateHsmConfigurationOutput`](crate::output::CreateHsmConfigurationOutput)
    pub fn builder() -> crate::output::create_hsm_configuration_output::Builder {
        crate::output::create_hsm_configuration_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateHsmClientCertificateOutput {
    /// <p>Returns information about an HSM client certificate. The certificate is stored in a secure Hardware Storage Module (HSM), and used by the Amazon Redshift cluster to encrypt data files.</p>
    pub hsm_client_certificate: std::option::Option<crate::model::HsmClientCertificate>,
}
impl CreateHsmClientCertificateOutput {
    /// <p>Returns information about an HSM client certificate. The certificate is stored in a secure Hardware Storage Module (HSM), and used by the Amazon Redshift cluster to encrypt data files.</p>
    pub fn hsm_client_certificate(
        &self,
    ) -> std::option::Option<&crate::model::HsmClientCertificate> {
        self.hsm_client_certificate.as_ref()
    }
}
impl std::fmt::Debug for CreateHsmClientCertificateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateHsmClientCertificateOutput");
        formatter.field("hsm_client_certificate", &self.hsm_client_certificate);
        formatter.finish()
    }
}
/// See [`CreateHsmClientCertificateOutput`](crate::output::CreateHsmClientCertificateOutput)
pub mod create_hsm_client_certificate_output {
    /// A builder for [`CreateHsmClientCertificateOutput`](crate::output::CreateHsmClientCertificateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) hsm_client_certificate: std::option::Option<crate::model::HsmClientCertificate>,
    }
    impl Builder {
        /// <p>Returns information about an HSM client certificate. The certificate is stored in a secure Hardware Storage Module (HSM), and used by the Amazon Redshift cluster to encrypt data files.</p>
        pub fn hsm_client_certificate(mut self, input: crate::model::HsmClientCertificate) -> Self {
            self.hsm_client_certificate = Some(input);
            self
        }
        /// <p>Returns information about an HSM client certificate. The certificate is stored in a secure Hardware Storage Module (HSM), and used by the Amazon Redshift cluster to encrypt data files.</p>
        pub fn set_hsm_client_certificate(
            mut self,
            input: std::option::Option<crate::model::HsmClientCertificate>,
        ) -> Self {
            self.hsm_client_certificate = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateHsmClientCertificateOutput`](crate::output::CreateHsmClientCertificateOutput)
        pub fn build(self) -> crate::output::CreateHsmClientCertificateOutput {
            crate::output::CreateHsmClientCertificateOutput {
                hsm_client_certificate: self.hsm_client_certificate,
            }
        }
    }
}
impl CreateHsmClientCertificateOutput {
    /// Creates a new builder-style object to manufacture [`CreateHsmClientCertificateOutput`](crate::output::CreateHsmClientCertificateOutput)
    pub fn builder() -> crate::output::create_hsm_client_certificate_output::Builder {
        crate::output::create_hsm_client_certificate_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateEventSubscriptionOutput {
    /// <p>Describes event subscriptions.</p>
    pub event_subscription: std::option::Option<crate::model::EventSubscription>,
}
impl CreateEventSubscriptionOutput {
    /// <p>Describes event subscriptions.</p>
    pub fn event_subscription(&self) -> std::option::Option<&crate::model::EventSubscription> {
        self.event_subscription.as_ref()
    }
}
impl std::fmt::Debug for CreateEventSubscriptionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateEventSubscriptionOutput");
        formatter.field("event_subscription", &self.event_subscription);
        formatter.finish()
    }
}
/// See [`CreateEventSubscriptionOutput`](crate::output::CreateEventSubscriptionOutput)
pub mod create_event_subscription_output {
    /// A builder for [`CreateEventSubscriptionOutput`](crate::output::CreateEventSubscriptionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) event_subscription: std::option::Option<crate::model::EventSubscription>,
    }
    impl Builder {
        /// <p>Describes event subscriptions.</p>
        pub fn event_subscription(mut self, input: crate::model::EventSubscription) -> Self {
            self.event_subscription = Some(input);
            self
        }
        /// <p>Describes event subscriptions.</p>
        pub fn set_event_subscription(
            mut self,
            input: std::option::Option<crate::model::EventSubscription>,
        ) -> Self {
            self.event_subscription = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateEventSubscriptionOutput`](crate::output::CreateEventSubscriptionOutput)
        pub fn build(self) -> crate::output::CreateEventSubscriptionOutput {
            crate::output::CreateEventSubscriptionOutput {
                event_subscription: self.event_subscription,
            }
        }
    }
}
impl CreateEventSubscriptionOutput {
    /// Creates a new builder-style object to manufacture [`CreateEventSubscriptionOutput`](crate::output::CreateEventSubscriptionOutput)
    pub fn builder() -> crate::output::create_event_subscription_output::Builder {
        crate::output::create_event_subscription_output::Builder::default()
    }
}

/// <p>Describes a Redshift-managed VPC endpoint.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateEndpointAccessOutput {
    /// <p>The cluster identifier of the cluster associated with the endpoint.</p>
    pub cluster_identifier: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services account ID of the owner of the cluster.</p>
    pub resource_owner: std::option::Option<std::string::String>,
    /// <p>The subnet group name where Amazon Redshift chooses to deploy the endpoint.</p>
    pub subnet_group_name: std::option::Option<std::string::String>,
    /// <p>The status of the endpoint.</p>
    pub endpoint_status: std::option::Option<std::string::String>,
    /// <p>The name of the endpoint.</p>
    pub endpoint_name: std::option::Option<std::string::String>,
    /// <p>The time (UTC) that the endpoint was created.</p>
    pub endpoint_create_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The port number on which the cluster accepts incoming connections.</p>
    pub port: i32,
    /// <p>The DNS address of the endpoint.</p>
    pub address: std::option::Option<std::string::String>,
    /// <p>The security groups associated with the endpoint.</p>
    pub vpc_security_groups:
        std::option::Option<std::vec::Vec<crate::model::VpcSecurityGroupMembership>>,
    /// <p>The connection endpoint for connecting to an Amazon Redshift cluster through the proxy.</p>
    pub vpc_endpoint: std::option::Option<crate::model::VpcEndpoint>,
}
impl CreateEndpointAccessOutput {
    /// <p>The cluster identifier of the cluster associated with the endpoint.</p>
    pub fn cluster_identifier(&self) -> std::option::Option<&str> {
        self.cluster_identifier.as_deref()
    }
    /// <p>The Amazon Web Services account ID of the owner of the cluster.</p>
    pub fn resource_owner(&self) -> std::option::Option<&str> {
        self.resource_owner.as_deref()
    }
    /// <p>The subnet group name where Amazon Redshift chooses to deploy the endpoint.</p>
    pub fn subnet_group_name(&self) -> std::option::Option<&str> {
        self.subnet_group_name.as_deref()
    }
    /// <p>The status of the endpoint.</p>
    pub fn endpoint_status(&self) -> std::option::Option<&str> {
        self.endpoint_status.as_deref()
    }
    /// <p>The name of the endpoint.</p>
    pub fn endpoint_name(&self) -> std::option::Option<&str> {
        self.endpoint_name.as_deref()
    }
    /// <p>The time (UTC) that the endpoint was created.</p>
    pub fn endpoint_create_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.endpoint_create_time.as_ref()
    }
    /// <p>The port number on which the cluster accepts incoming connections.</p>
    pub fn port(&self) -> i32 {
        self.port
    }
    /// <p>The DNS address of the endpoint.</p>
    pub fn address(&self) -> std::option::Option<&str> {
        self.address.as_deref()
    }
    /// <p>The security groups associated with the endpoint.</p>
    pub fn vpc_security_groups(
        &self,
    ) -> std::option::Option<&[crate::model::VpcSecurityGroupMembership]> {
        self.vpc_security_groups.as_deref()
    }
    /// <p>The connection endpoint for connecting to an Amazon Redshift cluster through the proxy.</p>
    pub fn vpc_endpoint(&self) -> std::option::Option<&crate::model::VpcEndpoint> {
        self.vpc_endpoint.as_ref()
    }
}
impl std::fmt::Debug for CreateEndpointAccessOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateEndpointAccessOutput");
        formatter.field("cluster_identifier", &self.cluster_identifier);
        formatter.field("resource_owner", &self.resource_owner);
        formatter.field("subnet_group_name", &self.subnet_group_name);
        formatter.field("endpoint_status", &self.endpoint_status);
        formatter.field("endpoint_name", &self.endpoint_name);
        formatter.field("endpoint_create_time", &self.endpoint_create_time);
        formatter.field("port", &self.port);
        formatter.field("address", &self.address);
        formatter.field("vpc_security_groups", &self.vpc_security_groups);
        formatter.field("vpc_endpoint", &self.vpc_endpoint);
        formatter.finish()
    }
}
/// See [`CreateEndpointAccessOutput`](crate::output::CreateEndpointAccessOutput)
pub mod create_endpoint_access_output {
    /// A builder for [`CreateEndpointAccessOutput`](crate::output::CreateEndpointAccessOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) resource_owner: std::option::Option<std::string::String>,
        pub(crate) subnet_group_name: std::option::Option<std::string::String>,
        pub(crate) endpoint_status: std::option::Option<std::string::String>,
        pub(crate) endpoint_name: std::option::Option<std::string::String>,
        pub(crate) endpoint_create_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) port: std::option::Option<i32>,
        pub(crate) address: std::option::Option<std::string::String>,
        pub(crate) vpc_security_groups:
            std::option::Option<std::vec::Vec<crate::model::VpcSecurityGroupMembership>>,
        pub(crate) vpc_endpoint: std::option::Option<crate::model::VpcEndpoint>,
    }
    impl Builder {
        /// <p>The cluster identifier of the cluster associated with the endpoint.</p>
        pub fn cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_identifier = Some(input.into());
            self
        }
        /// <p>The cluster identifier of the cluster associated with the endpoint.</p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cluster_identifier = input;
            self
        }
        /// <p>The Amazon Web Services account ID of the owner of the cluster.</p>
        pub fn resource_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_owner = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID of the owner of the cluster.</p>
        pub fn set_resource_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_owner = input;
            self
        }
        /// <p>The subnet group name where Amazon Redshift chooses to deploy the endpoint.</p>
        pub fn subnet_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.subnet_group_name = Some(input.into());
            self
        }
        /// <p>The subnet group name where Amazon Redshift chooses to deploy the endpoint.</p>
        pub fn set_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.subnet_group_name = input;
            self
        }
        /// <p>The status of the endpoint.</p>
        pub fn endpoint_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_status = Some(input.into());
            self
        }
        /// <p>The status of the endpoint.</p>
        pub fn set_endpoint_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.endpoint_status = input;
            self
        }
        /// <p>The name of the endpoint.</p>
        pub fn endpoint_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_name = Some(input.into());
            self
        }
        /// <p>The name of the endpoint.</p>
        pub fn set_endpoint_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.endpoint_name = input;
            self
        }
        /// <p>The time (UTC) that the endpoint was created.</p>
        pub fn endpoint_create_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.endpoint_create_time = Some(input);
            self
        }
        /// <p>The time (UTC) that the endpoint was created.</p>
        pub fn set_endpoint_create_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.endpoint_create_time = input;
            self
        }
        /// <p>The port number on which the cluster accepts incoming connections.</p>
        pub fn port(mut self, input: i32) -> Self {
            self.port = Some(input);
            self
        }
        /// <p>The port number on which the cluster accepts incoming connections.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.port = input;
            self
        }
        /// <p>The DNS address of the endpoint.</p>
        pub fn address(mut self, input: impl Into<std::string::String>) -> Self {
            self.address = Some(input.into());
            self
        }
        /// <p>The DNS address of the endpoint.</p>
        pub fn set_address(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.address = input;
            self
        }
        /// Appends an item to `vpc_security_groups`.
        ///
        /// To override the contents of this collection use [`set_vpc_security_groups`](Self::set_vpc_security_groups).
        ///
        /// <p>The security groups associated with the endpoint.</p>
        pub fn vpc_security_groups(
            mut self,
            input: crate::model::VpcSecurityGroupMembership,
        ) -> Self {
            let mut v = self.vpc_security_groups.unwrap_or_default();
            v.push(input);
            self.vpc_security_groups = Some(v);
            self
        }
        /// <p>The security groups associated with the endpoint.</p>
        pub fn set_vpc_security_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::VpcSecurityGroupMembership>>,
        ) -> Self {
            self.vpc_security_groups = input;
            self
        }
        /// <p>The connection endpoint for connecting to an Amazon Redshift cluster through the proxy.</p>
        pub fn vpc_endpoint(mut self, input: crate::model::VpcEndpoint) -> Self {
            self.vpc_endpoint = Some(input);
            self
        }
        /// <p>The connection endpoint for connecting to an Amazon Redshift cluster through the proxy.</p>
        pub fn set_vpc_endpoint(
            mut self,
            input: std::option::Option<crate::model::VpcEndpoint>,
        ) -> Self {
            self.vpc_endpoint = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateEndpointAccessOutput`](crate::output::CreateEndpointAccessOutput)
        pub fn build(self) -> crate::output::CreateEndpointAccessOutput {
            crate::output::CreateEndpointAccessOutput {
                cluster_identifier: self.cluster_identifier,
                resource_owner: self.resource_owner,
                subnet_group_name: self.subnet_group_name,
                endpoint_status: self.endpoint_status,
                endpoint_name: self.endpoint_name,
                endpoint_create_time: self.endpoint_create_time,
                port: self.port.unwrap_or_default(),
                address: self.address,
                vpc_security_groups: self.vpc_security_groups,
                vpc_endpoint: self.vpc_endpoint,
            }
        }
    }
}
impl CreateEndpointAccessOutput {
    /// Creates a new builder-style object to manufacture [`CreateEndpointAccessOutput`](crate::output::CreateEndpointAccessOutput)
    pub fn builder() -> crate::output::create_endpoint_access_output::Builder {
        crate::output::create_endpoint_access_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateClusterSubnetGroupOutput {
    /// <p>Describes a subnet group.</p>
    pub cluster_subnet_group: std::option::Option<crate::model::ClusterSubnetGroup>,
}
impl CreateClusterSubnetGroupOutput {
    /// <p>Describes a subnet group.</p>
    pub fn cluster_subnet_group(&self) -> std::option::Option<&crate::model::ClusterSubnetGroup> {
        self.cluster_subnet_group.as_ref()
    }
}
impl std::fmt::Debug for CreateClusterSubnetGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateClusterSubnetGroupOutput");
        formatter.field("cluster_subnet_group", &self.cluster_subnet_group);
        formatter.finish()
    }
}
/// See [`CreateClusterSubnetGroupOutput`](crate::output::CreateClusterSubnetGroupOutput)
pub mod create_cluster_subnet_group_output {
    /// A builder for [`CreateClusterSubnetGroupOutput`](crate::output::CreateClusterSubnetGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_subnet_group: std::option::Option<crate::model::ClusterSubnetGroup>,
    }
    impl Builder {
        /// <p>Describes a subnet group.</p>
        pub fn cluster_subnet_group(mut self, input: crate::model::ClusterSubnetGroup) -> Self {
            self.cluster_subnet_group = Some(input);
            self
        }
        /// <p>Describes a subnet group.</p>
        pub fn set_cluster_subnet_group(
            mut self,
            input: std::option::Option<crate::model::ClusterSubnetGroup>,
        ) -> Self {
            self.cluster_subnet_group = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateClusterSubnetGroupOutput`](crate::output::CreateClusterSubnetGroupOutput)
        pub fn build(self) -> crate::output::CreateClusterSubnetGroupOutput {
            crate::output::CreateClusterSubnetGroupOutput {
                cluster_subnet_group: self.cluster_subnet_group,
            }
        }
    }
}
impl CreateClusterSubnetGroupOutput {
    /// Creates a new builder-style object to manufacture [`CreateClusterSubnetGroupOutput`](crate::output::CreateClusterSubnetGroupOutput)
    pub fn builder() -> crate::output::create_cluster_subnet_group_output::Builder {
        crate::output::create_cluster_subnet_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateClusterSnapshotOutput {
    /// <p>Describes a snapshot.</p>
    pub snapshot: std::option::Option<crate::model::Snapshot>,
}
impl CreateClusterSnapshotOutput {
    /// <p>Describes a snapshot.</p>
    pub fn snapshot(&self) -> std::option::Option<&crate::model::Snapshot> {
        self.snapshot.as_ref()
    }
}
impl std::fmt::Debug for CreateClusterSnapshotOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateClusterSnapshotOutput");
        formatter.field("snapshot", &self.snapshot);
        formatter.finish()
    }
}
/// See [`CreateClusterSnapshotOutput`](crate::output::CreateClusterSnapshotOutput)
pub mod create_cluster_snapshot_output {
    /// A builder for [`CreateClusterSnapshotOutput`](crate::output::CreateClusterSnapshotOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) snapshot: std::option::Option<crate::model::Snapshot>,
    }
    impl Builder {
        /// <p>Describes a snapshot.</p>
        pub fn snapshot(mut self, input: crate::model::Snapshot) -> Self {
            self.snapshot = Some(input);
            self
        }
        /// <p>Describes a snapshot.</p>
        pub fn set_snapshot(mut self, input: std::option::Option<crate::model::Snapshot>) -> Self {
            self.snapshot = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateClusterSnapshotOutput`](crate::output::CreateClusterSnapshotOutput)
        pub fn build(self) -> crate::output::CreateClusterSnapshotOutput {
            crate::output::CreateClusterSnapshotOutput {
                snapshot: self.snapshot,
            }
        }
    }
}
impl CreateClusterSnapshotOutput {
    /// Creates a new builder-style object to manufacture [`CreateClusterSnapshotOutput`](crate::output::CreateClusterSnapshotOutput)
    pub fn builder() -> crate::output::create_cluster_snapshot_output::Builder {
        crate::output::create_cluster_snapshot_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateClusterSecurityGroupOutput {
    /// <p>Describes a security group.</p>
    pub cluster_security_group: std::option::Option<crate::model::ClusterSecurityGroup>,
}
impl CreateClusterSecurityGroupOutput {
    /// <p>Describes a security group.</p>
    pub fn cluster_security_group(
        &self,
    ) -> std::option::Option<&crate::model::ClusterSecurityGroup> {
        self.cluster_security_group.as_ref()
    }
}
impl std::fmt::Debug for CreateClusterSecurityGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateClusterSecurityGroupOutput");
        formatter.field("cluster_security_group", &self.cluster_security_group);
        formatter.finish()
    }
}
/// See [`CreateClusterSecurityGroupOutput`](crate::output::CreateClusterSecurityGroupOutput)
pub mod create_cluster_security_group_output {
    /// A builder for [`CreateClusterSecurityGroupOutput`](crate::output::CreateClusterSecurityGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_security_group: std::option::Option<crate::model::ClusterSecurityGroup>,
    }
    impl Builder {
        /// <p>Describes a security group.</p>
        pub fn cluster_security_group(mut self, input: crate::model::ClusterSecurityGroup) -> Self {
            self.cluster_security_group = Some(input);
            self
        }
        /// <p>Describes a security group.</p>
        pub fn set_cluster_security_group(
            mut self,
            input: std::option::Option<crate::model::ClusterSecurityGroup>,
        ) -> Self {
            self.cluster_security_group = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateClusterSecurityGroupOutput`](crate::output::CreateClusterSecurityGroupOutput)
        pub fn build(self) -> crate::output::CreateClusterSecurityGroupOutput {
            crate::output::CreateClusterSecurityGroupOutput {
                cluster_security_group: self.cluster_security_group,
            }
        }
    }
}
impl CreateClusterSecurityGroupOutput {
    /// Creates a new builder-style object to manufacture [`CreateClusterSecurityGroupOutput`](crate::output::CreateClusterSecurityGroupOutput)
    pub fn builder() -> crate::output::create_cluster_security_group_output::Builder {
        crate::output::create_cluster_security_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateClusterParameterGroupOutput {
    /// <p>Describes a parameter group.</p>
    pub cluster_parameter_group: std::option::Option<crate::model::ClusterParameterGroup>,
}
impl CreateClusterParameterGroupOutput {
    /// <p>Describes a parameter group.</p>
    pub fn cluster_parameter_group(
        &self,
    ) -> std::option::Option<&crate::model::ClusterParameterGroup> {
        self.cluster_parameter_group.as_ref()
    }
}
impl std::fmt::Debug for CreateClusterParameterGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateClusterParameterGroupOutput");
        formatter.field("cluster_parameter_group", &self.cluster_parameter_group);
        formatter.finish()
    }
}
/// See [`CreateClusterParameterGroupOutput`](crate::output::CreateClusterParameterGroupOutput)
pub mod create_cluster_parameter_group_output {
    /// A builder for [`CreateClusterParameterGroupOutput`](crate::output::CreateClusterParameterGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_parameter_group:
            std::option::Option<crate::model::ClusterParameterGroup>,
    }
    impl Builder {
        /// <p>Describes a parameter group.</p>
        pub fn cluster_parameter_group(
            mut self,
            input: crate::model::ClusterParameterGroup,
        ) -> Self {
            self.cluster_parameter_group = Some(input);
            self
        }
        /// <p>Describes a parameter group.</p>
        pub fn set_cluster_parameter_group(
            mut self,
            input: std::option::Option<crate::model::ClusterParameterGroup>,
        ) -> Self {
            self.cluster_parameter_group = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateClusterParameterGroupOutput`](crate::output::CreateClusterParameterGroupOutput)
        pub fn build(self) -> crate::output::CreateClusterParameterGroupOutput {
            crate::output::CreateClusterParameterGroupOutput {
                cluster_parameter_group: self.cluster_parameter_group,
            }
        }
    }
}
impl CreateClusterParameterGroupOutput {
    /// Creates a new builder-style object to manufacture [`CreateClusterParameterGroupOutput`](crate::output::CreateClusterParameterGroupOutput)
    pub fn builder() -> crate::output::create_cluster_parameter_group_output::Builder {
        crate::output::create_cluster_parameter_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateClusterOutput {
    /// <p>Describes a cluster.</p>
    pub cluster: std::option::Option<crate::model::Cluster>,
}
impl CreateClusterOutput {
    /// <p>Describes a cluster.</p>
    pub fn cluster(&self) -> std::option::Option<&crate::model::Cluster> {
        self.cluster.as_ref()
    }
}
impl std::fmt::Debug for CreateClusterOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateClusterOutput");
        formatter.field("cluster", &self.cluster);
        formatter.finish()
    }
}
/// See [`CreateClusterOutput`](crate::output::CreateClusterOutput)
pub mod create_cluster_output {
    /// A builder for [`CreateClusterOutput`](crate::output::CreateClusterOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster: std::option::Option<crate::model::Cluster>,
    }
    impl Builder {
        /// <p>Describes a cluster.</p>
        pub fn cluster(mut self, input: crate::model::Cluster) -> Self {
            self.cluster = Some(input);
            self
        }
        /// <p>Describes a cluster.</p>
        pub fn set_cluster(mut self, input: std::option::Option<crate::model::Cluster>) -> Self {
            self.cluster = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateClusterOutput`](crate::output::CreateClusterOutput)
        pub fn build(self) -> crate::output::CreateClusterOutput {
            crate::output::CreateClusterOutput {
                cluster: self.cluster,
            }
        }
    }
}
impl CreateClusterOutput {
    /// Creates a new builder-style object to manufacture [`CreateClusterOutput`](crate::output::CreateClusterOutput)
    pub fn builder() -> crate::output::create_cluster_output::Builder {
        crate::output::create_cluster_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateAuthenticationProfileOutput {
    /// <p>The name of the authentication profile that was created.</p>
    pub authentication_profile_name: std::option::Option<std::string::String>,
    /// <p>The content of the authentication profile in JSON format.</p>
    pub authentication_profile_content: std::option::Option<std::string::String>,
}
impl CreateAuthenticationProfileOutput {
    /// <p>The name of the authentication profile that was created.</p>
    pub fn authentication_profile_name(&self) -> std::option::Option<&str> {
        self.authentication_profile_name.as_deref()
    }
    /// <p>The content of the authentication profile in JSON format.</p>
    pub fn authentication_profile_content(&self) -> std::option::Option<&str> {
        self.authentication_profile_content.as_deref()
    }
}
impl std::fmt::Debug for CreateAuthenticationProfileOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateAuthenticationProfileOutput");
        formatter.field(
            "authentication_profile_name",
            &self.authentication_profile_name,
        );
        formatter.field(
            "authentication_profile_content",
            &self.authentication_profile_content,
        );
        formatter.finish()
    }
}
/// See [`CreateAuthenticationProfileOutput`](crate::output::CreateAuthenticationProfileOutput)
pub mod create_authentication_profile_output {
    /// A builder for [`CreateAuthenticationProfileOutput`](crate::output::CreateAuthenticationProfileOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) authentication_profile_name: std::option::Option<std::string::String>,
        pub(crate) authentication_profile_content: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the authentication profile that was created.</p>
        pub fn authentication_profile_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.authentication_profile_name = Some(input.into());
            self
        }
        /// <p>The name of the authentication profile that was created.</p>
        pub fn set_authentication_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authentication_profile_name = input;
            self
        }
        /// <p>The content of the authentication profile in JSON format.</p>
        pub fn authentication_profile_content(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.authentication_profile_content = Some(input.into());
            self
        }
        /// <p>The content of the authentication profile in JSON format.</p>
        pub fn set_authentication_profile_content(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.authentication_profile_content = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateAuthenticationProfileOutput`](crate::output::CreateAuthenticationProfileOutput)
        pub fn build(self) -> crate::output::CreateAuthenticationProfileOutput {
            crate::output::CreateAuthenticationProfileOutput {
                authentication_profile_name: self.authentication_profile_name,
                authentication_profile_content: self.authentication_profile_content,
            }
        }
    }
}
impl CreateAuthenticationProfileOutput {
    /// Creates a new builder-style object to manufacture [`CreateAuthenticationProfileOutput`](crate::output::CreateAuthenticationProfileOutput)
    pub fn builder() -> crate::output::create_authentication_profile_output::Builder {
        crate::output::create_authentication_profile_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CopyClusterSnapshotOutput {
    /// <p>Describes a snapshot.</p>
    pub snapshot: std::option::Option<crate::model::Snapshot>,
}
impl CopyClusterSnapshotOutput {
    /// <p>Describes a snapshot.</p>
    pub fn snapshot(&self) -> std::option::Option<&crate::model::Snapshot> {
        self.snapshot.as_ref()
    }
}
impl std::fmt::Debug for CopyClusterSnapshotOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CopyClusterSnapshotOutput");
        formatter.field("snapshot", &self.snapshot);
        formatter.finish()
    }
}
/// See [`CopyClusterSnapshotOutput`](crate::output::CopyClusterSnapshotOutput)
pub mod copy_cluster_snapshot_output {
    /// A builder for [`CopyClusterSnapshotOutput`](crate::output::CopyClusterSnapshotOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) snapshot: std::option::Option<crate::model::Snapshot>,
    }
    impl Builder {
        /// <p>Describes a snapshot.</p>
        pub fn snapshot(mut self, input: crate::model::Snapshot) -> Self {
            self.snapshot = Some(input);
            self
        }
        /// <p>Describes a snapshot.</p>
        pub fn set_snapshot(mut self, input: std::option::Option<crate::model::Snapshot>) -> Self {
            self.snapshot = input;
            self
        }
        /// Consumes the builder and constructs a [`CopyClusterSnapshotOutput`](crate::output::CopyClusterSnapshotOutput)
        pub fn build(self) -> crate::output::CopyClusterSnapshotOutput {
            crate::output::CopyClusterSnapshotOutput {
                snapshot: self.snapshot,
            }
        }
    }
}
impl CopyClusterSnapshotOutput {
    /// Creates a new builder-style object to manufacture [`CopyClusterSnapshotOutput`](crate::output::CopyClusterSnapshotOutput)
    pub fn builder() -> crate::output::copy_cluster_snapshot_output::Builder {
        crate::output::copy_cluster_snapshot_output::Builder::default()
    }
}

/// <p>Describes the result of a cluster resize operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CancelResizeOutput {
    /// <p>The node type that the cluster will have after the resize operation is complete.</p>
    pub target_node_type: std::option::Option<std::string::String>,
    /// <p>The number of nodes that the cluster will have after the resize operation is complete.</p>
    pub target_number_of_nodes: std::option::Option<i32>,
    /// <p>The cluster type after the resize operation is complete.</p>
    /// <p>Valid Values: <code>multi-node</code> | <code>single-node</code> </p>
    pub target_cluster_type: std::option::Option<std::string::String>,
    /// <p>The status of the resize operation.</p>
    /// <p>Valid Values: <code>NONE</code> | <code>IN_PROGRESS</code> | <code>FAILED</code> | <code>SUCCEEDED</code> | <code>CANCELLING</code> </p>
    pub status: std::option::Option<std::string::String>,
    /// <p>The names of tables that have been completely imported .</p>
    /// <p>Valid Values: List of table names.</p>
    pub import_tables_completed: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The names of tables that are being currently imported.</p>
    /// <p>Valid Values: List of table names.</p>
    pub import_tables_in_progress: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The names of tables that have not been yet imported.</p>
    /// <p>Valid Values: List of table names</p>
    pub import_tables_not_started: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The average rate of the resize operation over the last few minutes, measured in megabytes per second. After the resize operation completes, this value shows the average rate of the entire resize operation.</p>
    pub avg_resize_rate_in_mega_bytes_per_second: std::option::Option<f64>,
    /// <p>The estimated total amount of data, in megabytes, on the cluster before the resize operation began.</p>
    pub total_resize_data_in_mega_bytes: std::option::Option<i64>,
    /// <p>While the resize operation is in progress, this value shows the current amount of data, in megabytes, that has been processed so far. When the resize operation is complete, this value shows the total amount of data, in megabytes, on the cluster, which may be more or less than TotalResizeDataInMegaBytes (the estimated total amount of data before resize).</p>
    pub progress_in_mega_bytes: std::option::Option<i64>,
    /// <p>The amount of seconds that have elapsed since the resize operation began. After the resize operation completes, this value shows the total actual time, in seconds, for the resize operation.</p>
    pub elapsed_time_in_seconds: std::option::Option<i64>,
    /// <p>The estimated time remaining, in seconds, until the resize operation is complete. This value is calculated based on the average resize rate and the estimated amount of data remaining to be processed. Once the resize operation is complete, this value will be 0.</p>
    pub estimated_time_to_completion_in_seconds: std::option::Option<i64>,
    /// <p>An enum with possible values of <code>ClassicResize</code> and <code>ElasticResize</code>. These values describe the type of resize operation being performed. </p>
    pub resize_type: std::option::Option<std::string::String>,
    /// <p>An optional string to provide additional details about the resize action.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The type of encryption for the cluster after the resize is complete.</p>
    /// <p>Possible values are <code>KMS</code> and <code>None</code>. </p>
    pub target_encryption_type: std::option::Option<std::string::String>,
    /// <p>The percent of data transferred from source cluster to target cluster.</p>
    pub data_transfer_progress_percent: std::option::Option<f64>,
}
impl CancelResizeOutput {
    /// <p>The node type that the cluster will have after the resize operation is complete.</p>
    pub fn target_node_type(&self) -> std::option::Option<&str> {
        self.target_node_type.as_deref()
    }
    /// <p>The number of nodes that the cluster will have after the resize operation is complete.</p>
    pub fn target_number_of_nodes(&self) -> std::option::Option<i32> {
        self.target_number_of_nodes
    }
    /// <p>The cluster type after the resize operation is complete.</p>
    /// <p>Valid Values: <code>multi-node</code> | <code>single-node</code> </p>
    pub fn target_cluster_type(&self) -> std::option::Option<&str> {
        self.target_cluster_type.as_deref()
    }
    /// <p>The status of the resize operation.</p>
    /// <p>Valid Values: <code>NONE</code> | <code>IN_PROGRESS</code> | <code>FAILED</code> | <code>SUCCEEDED</code> | <code>CANCELLING</code> </p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>The names of tables that have been completely imported .</p>
    /// <p>Valid Values: List of table names.</p>
    pub fn import_tables_completed(&self) -> std::option::Option<&[std::string::String]> {
        self.import_tables_completed.as_deref()
    }
    /// <p>The names of tables that are being currently imported.</p>
    /// <p>Valid Values: List of table names.</p>
    pub fn import_tables_in_progress(&self) -> std::option::Option<&[std::string::String]> {
        self.import_tables_in_progress.as_deref()
    }
    /// <p>The names of tables that have not been yet imported.</p>
    /// <p>Valid Values: List of table names</p>
    pub fn import_tables_not_started(&self) -> std::option::Option<&[std::string::String]> {
        self.import_tables_not_started.as_deref()
    }
    /// <p>The average rate of the resize operation over the last few minutes, measured in megabytes per second. After the resize operation completes, this value shows the average rate of the entire resize operation.</p>
    pub fn avg_resize_rate_in_mega_bytes_per_second(&self) -> std::option::Option<f64> {
        self.avg_resize_rate_in_mega_bytes_per_second
    }
    /// <p>The estimated total amount of data, in megabytes, on the cluster before the resize operation began.</p>
    pub fn total_resize_data_in_mega_bytes(&self) -> std::option::Option<i64> {
        self.total_resize_data_in_mega_bytes
    }
    /// <p>While the resize operation is in progress, this value shows the current amount of data, in megabytes, that has been processed so far. When the resize operation is complete, this value shows the total amount of data, in megabytes, on the cluster, which may be more or less than TotalResizeDataInMegaBytes (the estimated total amount of data before resize).</p>
    pub fn progress_in_mega_bytes(&self) -> std::option::Option<i64> {
        self.progress_in_mega_bytes
    }
    /// <p>The amount of seconds that have elapsed since the resize operation began. After the resize operation completes, this value shows the total actual time, in seconds, for the resize operation.</p>
    pub fn elapsed_time_in_seconds(&self) -> std::option::Option<i64> {
        self.elapsed_time_in_seconds
    }
    /// <p>The estimated time remaining, in seconds, until the resize operation is complete. This value is calculated based on the average resize rate and the estimated amount of data remaining to be processed. Once the resize operation is complete, this value will be 0.</p>
    pub fn estimated_time_to_completion_in_seconds(&self) -> std::option::Option<i64> {
        self.estimated_time_to_completion_in_seconds
    }
    /// <p>An enum with possible values of <code>ClassicResize</code> and <code>ElasticResize</code>. These values describe the type of resize operation being performed. </p>
    pub fn resize_type(&self) -> std::option::Option<&str> {
        self.resize_type.as_deref()
    }
    /// <p>An optional string to provide additional details about the resize action.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
    /// <p>The type of encryption for the cluster after the resize is complete.</p>
    /// <p>Possible values are <code>KMS</code> and <code>None</code>. </p>
    pub fn target_encryption_type(&self) -> std::option::Option<&str> {
        self.target_encryption_type.as_deref()
    }
    /// <p>The percent of data transferred from source cluster to target cluster.</p>
    pub fn data_transfer_progress_percent(&self) -> std::option::Option<f64> {
        self.data_transfer_progress_percent
    }
}
impl std::fmt::Debug for CancelResizeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CancelResizeOutput");
        formatter.field("target_node_type", &self.target_node_type);
        formatter.field("target_number_of_nodes", &self.target_number_of_nodes);
        formatter.field("target_cluster_type", &self.target_cluster_type);
        formatter.field("status", &self.status);
        formatter.field("import_tables_completed", &self.import_tables_completed);
        formatter.field("import_tables_in_progress", &self.import_tables_in_progress);
        formatter.field("import_tables_not_started", &self.import_tables_not_started);
        formatter.field(
            "avg_resize_rate_in_mega_bytes_per_second",
            &self.avg_resize_rate_in_mega_bytes_per_second,
        );
        formatter.field(
            "total_resize_data_in_mega_bytes",
            &self.total_resize_data_in_mega_bytes,
        );
        formatter.field("progress_in_mega_bytes", &self.progress_in_mega_bytes);
        formatter.field("elapsed_time_in_seconds", &self.elapsed_time_in_seconds);
        formatter.field(
            "estimated_time_to_completion_in_seconds",
            &self.estimated_time_to_completion_in_seconds,
        );
        formatter.field("resize_type", &self.resize_type);
        formatter.field("message", &self.message);
        formatter.field("target_encryption_type", &self.target_encryption_type);
        formatter.field(
            "data_transfer_progress_percent",
            &self.data_transfer_progress_percent,
        );
        formatter.finish()
    }
}
/// See [`CancelResizeOutput`](crate::output::CancelResizeOutput)
pub mod cancel_resize_output {
    /// A builder for [`CancelResizeOutput`](crate::output::CancelResizeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) target_node_type: std::option::Option<std::string::String>,
        pub(crate) target_number_of_nodes: std::option::Option<i32>,
        pub(crate) target_cluster_type: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) import_tables_completed: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) import_tables_in_progress:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) import_tables_not_started:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) avg_resize_rate_in_mega_bytes_per_second: std::option::Option<f64>,
        pub(crate) total_resize_data_in_mega_bytes: std::option::Option<i64>,
        pub(crate) progress_in_mega_bytes: std::option::Option<i64>,
        pub(crate) elapsed_time_in_seconds: std::option::Option<i64>,
        pub(crate) estimated_time_to_completion_in_seconds: std::option::Option<i64>,
        pub(crate) resize_type: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) target_encryption_type: std::option::Option<std::string::String>,
        pub(crate) data_transfer_progress_percent: std::option::Option<f64>,
    }
    impl Builder {
        /// <p>The node type that the cluster will have after the resize operation is complete.</p>
        pub fn target_node_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_node_type = Some(input.into());
            self
        }
        /// <p>The node type that the cluster will have after the resize operation is complete.</p>
        pub fn set_target_node_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_node_type = input;
            self
        }
        /// <p>The number of nodes that the cluster will have after the resize operation is complete.</p>
        pub fn target_number_of_nodes(mut self, input: i32) -> Self {
            self.target_number_of_nodes = Some(input);
            self
        }
        /// <p>The number of nodes that the cluster will have after the resize operation is complete.</p>
        pub fn set_target_number_of_nodes(mut self, input: std::option::Option<i32>) -> Self {
            self.target_number_of_nodes = input;
            self
        }
        /// <p>The cluster type after the resize operation is complete.</p>
        /// <p>Valid Values: <code>multi-node</code> | <code>single-node</code> </p>
        pub fn target_cluster_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_cluster_type = Some(input.into());
            self
        }
        /// <p>The cluster type after the resize operation is complete.</p>
        /// <p>Valid Values: <code>multi-node</code> | <code>single-node</code> </p>
        pub fn set_target_cluster_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_cluster_type = input;
            self
        }
        /// <p>The status of the resize operation.</p>
        /// <p>Valid Values: <code>NONE</code> | <code>IN_PROGRESS</code> | <code>FAILED</code> | <code>SUCCEEDED</code> | <code>CANCELLING</code> </p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the resize operation.</p>
        /// <p>Valid Values: <code>NONE</code> | <code>IN_PROGRESS</code> | <code>FAILED</code> | <code>SUCCEEDED</code> | <code>CANCELLING</code> </p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// Appends an item to `import_tables_completed`.
        ///
        /// To override the contents of this collection use [`set_import_tables_completed`](Self::set_import_tables_completed).
        ///
        /// <p>The names of tables that have been completely imported .</p>
        /// <p>Valid Values: List of table names.</p>
        pub fn import_tables_completed(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.import_tables_completed.unwrap_or_default();
            v.push(input.into());
            self.import_tables_completed = Some(v);
            self
        }
        /// <p>The names of tables that have been completely imported .</p>
        /// <p>Valid Values: List of table names.</p>
        pub fn set_import_tables_completed(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.import_tables_completed = input;
            self
        }
        /// Appends an item to `import_tables_in_progress`.
        ///
        /// To override the contents of this collection use [`set_import_tables_in_progress`](Self::set_import_tables_in_progress).
        ///
        /// <p>The names of tables that are being currently imported.</p>
        /// <p>Valid Values: List of table names.</p>
        pub fn import_tables_in_progress(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.import_tables_in_progress.unwrap_or_default();
            v.push(input.into());
            self.import_tables_in_progress = Some(v);
            self
        }
        /// <p>The names of tables that are being currently imported.</p>
        /// <p>Valid Values: List of table names.</p>
        pub fn set_import_tables_in_progress(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.import_tables_in_progress = input;
            self
        }
        /// Appends an item to `import_tables_not_started`.
        ///
        /// To override the contents of this collection use [`set_import_tables_not_started`](Self::set_import_tables_not_started).
        ///
        /// <p>The names of tables that have not been yet imported.</p>
        /// <p>Valid Values: List of table names</p>
        pub fn import_tables_not_started(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.import_tables_not_started.unwrap_or_default();
            v.push(input.into());
            self.import_tables_not_started = Some(v);
            self
        }
        /// <p>The names of tables that have not been yet imported.</p>
        /// <p>Valid Values: List of table names</p>
        pub fn set_import_tables_not_started(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.import_tables_not_started = input;
            self
        }
        /// <p>The average rate of the resize operation over the last few minutes, measured in megabytes per second. After the resize operation completes, this value shows the average rate of the entire resize operation.</p>
        pub fn avg_resize_rate_in_mega_bytes_per_second(mut self, input: f64) -> Self {
            self.avg_resize_rate_in_mega_bytes_per_second = Some(input);
            self
        }
        /// <p>The average rate of the resize operation over the last few minutes, measured in megabytes per second. After the resize operation completes, this value shows the average rate of the entire resize operation.</p>
        pub fn set_avg_resize_rate_in_mega_bytes_per_second(
            mut self,
            input: std::option::Option<f64>,
        ) -> Self {
            self.avg_resize_rate_in_mega_bytes_per_second = input;
            self
        }
        /// <p>The estimated total amount of data, in megabytes, on the cluster before the resize operation began.</p>
        pub fn total_resize_data_in_mega_bytes(mut self, input: i64) -> Self {
            self.total_resize_data_in_mega_bytes = Some(input);
            self
        }
        /// <p>The estimated total amount of data, in megabytes, on the cluster before the resize operation began.</p>
        pub fn set_total_resize_data_in_mega_bytes(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.total_resize_data_in_mega_bytes = input;
            self
        }
        /// <p>While the resize operation is in progress, this value shows the current amount of data, in megabytes, that has been processed so far. When the resize operation is complete, this value shows the total amount of data, in megabytes, on the cluster, which may be more or less than TotalResizeDataInMegaBytes (the estimated total amount of data before resize).</p>
        pub fn progress_in_mega_bytes(mut self, input: i64) -> Self {
            self.progress_in_mega_bytes = Some(input);
            self
        }
        /// <p>While the resize operation is in progress, this value shows the current amount of data, in megabytes, that has been processed so far. When the resize operation is complete, this value shows the total amount of data, in megabytes, on the cluster, which may be more or less than TotalResizeDataInMegaBytes (the estimated total amount of data before resize).</p>
        pub fn set_progress_in_mega_bytes(mut self, input: std::option::Option<i64>) -> Self {
            self.progress_in_mega_bytes = input;
            self
        }
        /// <p>The amount of seconds that have elapsed since the resize operation began. After the resize operation completes, this value shows the total actual time, in seconds, for the resize operation.</p>
        pub fn elapsed_time_in_seconds(mut self, input: i64) -> Self {
            self.elapsed_time_in_seconds = Some(input);
            self
        }
        /// <p>The amount of seconds that have elapsed since the resize operation began. After the resize operation completes, this value shows the total actual time, in seconds, for the resize operation.</p>
        pub fn set_elapsed_time_in_seconds(mut self, input: std::option::Option<i64>) -> Self {
            self.elapsed_time_in_seconds = input;
            self
        }
        /// <p>The estimated time remaining, in seconds, until the resize operation is complete. This value is calculated based on the average resize rate and the estimated amount of data remaining to be processed. Once the resize operation is complete, this value will be 0.</p>
        pub fn estimated_time_to_completion_in_seconds(mut self, input: i64) -> Self {
            self.estimated_time_to_completion_in_seconds = Some(input);
            self
        }
        /// <p>The estimated time remaining, in seconds, until the resize operation is complete. This value is calculated based on the average resize rate and the estimated amount of data remaining to be processed. Once the resize operation is complete, this value will be 0.</p>
        pub fn set_estimated_time_to_completion_in_seconds(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.estimated_time_to_completion_in_seconds = input;
            self
        }
        /// <p>An enum with possible values of <code>ClassicResize</code> and <code>ElasticResize</code>. These values describe the type of resize operation being performed. </p>
        pub fn resize_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.resize_type = Some(input.into());
            self
        }
        /// <p>An enum with possible values of <code>ClassicResize</code> and <code>ElasticResize</code>. These values describe the type of resize operation being performed. </p>
        pub fn set_resize_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resize_type = input;
            self
        }
        /// <p>An optional string to provide additional details about the resize action.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>An optional string to provide additional details about the resize action.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The type of encryption for the cluster after the resize is complete.</p>
        /// <p>Possible values are <code>KMS</code> and <code>None</code>. </p>
        pub fn target_encryption_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_encryption_type = Some(input.into());
            self
        }
        /// <p>The type of encryption for the cluster after the resize is complete.</p>
        /// <p>Possible values are <code>KMS</code> and <code>None</code>. </p>
        pub fn set_target_encryption_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_encryption_type = input;
            self
        }
        /// <p>The percent of data transferred from source cluster to target cluster.</p>
        pub fn data_transfer_progress_percent(mut self, input: f64) -> Self {
            self.data_transfer_progress_percent = Some(input);
            self
        }
        /// <p>The percent of data transferred from source cluster to target cluster.</p>
        pub fn set_data_transfer_progress_percent(
            mut self,
            input: std::option::Option<f64>,
        ) -> Self {
            self.data_transfer_progress_percent = input;
            self
        }
        /// Consumes the builder and constructs a [`CancelResizeOutput`](crate::output::CancelResizeOutput)
        pub fn build(self) -> crate::output::CancelResizeOutput {
            crate::output::CancelResizeOutput {
                target_node_type: self.target_node_type,
                target_number_of_nodes: self.target_number_of_nodes,
                target_cluster_type: self.target_cluster_type,
                status: self.status,
                import_tables_completed: self.import_tables_completed,
                import_tables_in_progress: self.import_tables_in_progress,
                import_tables_not_started: self.import_tables_not_started,
                avg_resize_rate_in_mega_bytes_per_second: self
                    .avg_resize_rate_in_mega_bytes_per_second,
                total_resize_data_in_mega_bytes: self.total_resize_data_in_mega_bytes,
                progress_in_mega_bytes: self.progress_in_mega_bytes,
                elapsed_time_in_seconds: self.elapsed_time_in_seconds,
                estimated_time_to_completion_in_seconds: self
                    .estimated_time_to_completion_in_seconds,
                resize_type: self.resize_type,
                message: self.message,
                target_encryption_type: self.target_encryption_type,
                data_transfer_progress_percent: self.data_transfer_progress_percent,
            }
        }
    }
}
impl CancelResizeOutput {
    /// Creates a new builder-style object to manufacture [`CancelResizeOutput`](crate::output::CancelResizeOutput)
    pub fn builder() -> crate::output::cancel_resize_output::Builder {
        crate::output::cancel_resize_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchModifyClusterSnapshotsOutput {
    /// <p>A list of the snapshots that were modified.</p>
    pub resources: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of any errors returned.</p>
    pub errors: std::option::Option<std::vec::Vec<crate::model::SnapshotErrorMessage>>,
}
impl BatchModifyClusterSnapshotsOutput {
    /// <p>A list of the snapshots that were modified.</p>
    pub fn resources(&self) -> std::option::Option<&[std::string::String]> {
        self.resources.as_deref()
    }
    /// <p>A list of any errors returned.</p>
    pub fn errors(&self) -> std::option::Option<&[crate::model::SnapshotErrorMessage]> {
        self.errors.as_deref()
    }
}
impl std::fmt::Debug for BatchModifyClusterSnapshotsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchModifyClusterSnapshotsOutput");
        formatter.field("resources", &self.resources);
        formatter.field("errors", &self.errors);
        formatter.finish()
    }
}
/// See [`BatchModifyClusterSnapshotsOutput`](crate::output::BatchModifyClusterSnapshotsOutput)
pub mod batch_modify_cluster_snapshots_output {
    /// A builder for [`BatchModifyClusterSnapshotsOutput`](crate::output::BatchModifyClusterSnapshotsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resources: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) errors: std::option::Option<std::vec::Vec<crate::model::SnapshotErrorMessage>>,
    }
    impl Builder {
        /// Appends an item to `resources`.
        ///
        /// To override the contents of this collection use [`set_resources`](Self::set_resources).
        ///
        /// <p>A list of the snapshots that were modified.</p>
        pub fn resources(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.resources.unwrap_or_default();
            v.push(input.into());
            self.resources = Some(v);
            self
        }
        /// <p>A list of the snapshots that were modified.</p>
        pub fn set_resources(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.resources = input;
            self
        }
        /// Appends an item to `errors`.
        ///
        /// To override the contents of this collection use [`set_errors`](Self::set_errors).
        ///
        /// <p>A list of any errors returned.</p>
        pub fn errors(mut self, input: crate::model::SnapshotErrorMessage) -> Self {
            let mut v = self.errors.unwrap_or_default();
            v.push(input);
            self.errors = Some(v);
            self
        }
        /// <p>A list of any errors returned.</p>
        pub fn set_errors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SnapshotErrorMessage>>,
        ) -> Self {
            self.errors = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchModifyClusterSnapshotsOutput`](crate::output::BatchModifyClusterSnapshotsOutput)
        pub fn build(self) -> crate::output::BatchModifyClusterSnapshotsOutput {
            crate::output::BatchModifyClusterSnapshotsOutput {
                resources: self.resources,
                errors: self.errors,
            }
        }
    }
}
impl BatchModifyClusterSnapshotsOutput {
    /// Creates a new builder-style object to manufacture [`BatchModifyClusterSnapshotsOutput`](crate::output::BatchModifyClusterSnapshotsOutput)
    pub fn builder() -> crate::output::batch_modify_cluster_snapshots_output::Builder {
        crate::output::batch_modify_cluster_snapshots_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchDeleteClusterSnapshotsOutput {
    /// <p>A list of the snapshot identifiers that were deleted. </p>
    pub resources: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of any errors returned.</p>
    pub errors: std::option::Option<std::vec::Vec<crate::model::SnapshotErrorMessage>>,
}
impl BatchDeleteClusterSnapshotsOutput {
    /// <p>A list of the snapshot identifiers that were deleted. </p>
    pub fn resources(&self) -> std::option::Option<&[std::string::String]> {
        self.resources.as_deref()
    }
    /// <p>A list of any errors returned.</p>
    pub fn errors(&self) -> std::option::Option<&[crate::model::SnapshotErrorMessage]> {
        self.errors.as_deref()
    }
}
impl std::fmt::Debug for BatchDeleteClusterSnapshotsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchDeleteClusterSnapshotsOutput");
        formatter.field("resources", &self.resources);
        formatter.field("errors", &self.errors);
        formatter.finish()
    }
}
/// See [`BatchDeleteClusterSnapshotsOutput`](crate::output::BatchDeleteClusterSnapshotsOutput)
pub mod batch_delete_cluster_snapshots_output {
    /// A builder for [`BatchDeleteClusterSnapshotsOutput`](crate::output::BatchDeleteClusterSnapshotsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resources: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) errors: std::option::Option<std::vec::Vec<crate::model::SnapshotErrorMessage>>,
    }
    impl Builder {
        /// Appends an item to `resources`.
        ///
        /// To override the contents of this collection use [`set_resources`](Self::set_resources).
        ///
        /// <p>A list of the snapshot identifiers that were deleted. </p>
        pub fn resources(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.resources.unwrap_or_default();
            v.push(input.into());
            self.resources = Some(v);
            self
        }
        /// <p>A list of the snapshot identifiers that were deleted. </p>
        pub fn set_resources(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.resources = input;
            self
        }
        /// Appends an item to `errors`.
        ///
        /// To override the contents of this collection use [`set_errors`](Self::set_errors).
        ///
        /// <p>A list of any errors returned.</p>
        pub fn errors(mut self, input: crate::model::SnapshotErrorMessage) -> Self {
            let mut v = self.errors.unwrap_or_default();
            v.push(input);
            self.errors = Some(v);
            self
        }
        /// <p>A list of any errors returned.</p>
        pub fn set_errors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SnapshotErrorMessage>>,
        ) -> Self {
            self.errors = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchDeleteClusterSnapshotsOutput`](crate::output::BatchDeleteClusterSnapshotsOutput)
        pub fn build(self) -> crate::output::BatchDeleteClusterSnapshotsOutput {
            crate::output::BatchDeleteClusterSnapshotsOutput {
                resources: self.resources,
                errors: self.errors,
            }
        }
    }
}
impl BatchDeleteClusterSnapshotsOutput {
    /// Creates a new builder-style object to manufacture [`BatchDeleteClusterSnapshotsOutput`](crate::output::BatchDeleteClusterSnapshotsOutput)
    pub fn builder() -> crate::output::batch_delete_cluster_snapshots_output::Builder {
        crate::output::batch_delete_cluster_snapshots_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AuthorizeSnapshotAccessOutput {
    /// <p>Describes a snapshot.</p>
    pub snapshot: std::option::Option<crate::model::Snapshot>,
}
impl AuthorizeSnapshotAccessOutput {
    /// <p>Describes a snapshot.</p>
    pub fn snapshot(&self) -> std::option::Option<&crate::model::Snapshot> {
        self.snapshot.as_ref()
    }
}
impl std::fmt::Debug for AuthorizeSnapshotAccessOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AuthorizeSnapshotAccessOutput");
        formatter.field("snapshot", &self.snapshot);
        formatter.finish()
    }
}
/// See [`AuthorizeSnapshotAccessOutput`](crate::output::AuthorizeSnapshotAccessOutput)
pub mod authorize_snapshot_access_output {
    /// A builder for [`AuthorizeSnapshotAccessOutput`](crate::output::AuthorizeSnapshotAccessOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) snapshot: std::option::Option<crate::model::Snapshot>,
    }
    impl Builder {
        /// <p>Describes a snapshot.</p>
        pub fn snapshot(mut self, input: crate::model::Snapshot) -> Self {
            self.snapshot = Some(input);
            self
        }
        /// <p>Describes a snapshot.</p>
        pub fn set_snapshot(mut self, input: std::option::Option<crate::model::Snapshot>) -> Self {
            self.snapshot = input;
            self
        }
        /// Consumes the builder and constructs a [`AuthorizeSnapshotAccessOutput`](crate::output::AuthorizeSnapshotAccessOutput)
        pub fn build(self) -> crate::output::AuthorizeSnapshotAccessOutput {
            crate::output::AuthorizeSnapshotAccessOutput {
                snapshot: self.snapshot,
            }
        }
    }
}
impl AuthorizeSnapshotAccessOutput {
    /// Creates a new builder-style object to manufacture [`AuthorizeSnapshotAccessOutput`](crate::output::AuthorizeSnapshotAccessOutput)
    pub fn builder() -> crate::output::authorize_snapshot_access_output::Builder {
        crate::output::authorize_snapshot_access_output::Builder::default()
    }
}

/// <p>Describes an endpoint authorization for authorizing Redshift-managed VPC endpoint access to a cluster across Amazon Web Services accounts.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AuthorizeEndpointAccessOutput {
    /// <p>The Amazon Web Services account ID of the cluster owner.</p>
    pub grantor: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services account ID of the grantee of the cluster.</p>
    pub grantee: std::option::Option<std::string::String>,
    /// <p>The cluster identifier.</p>
    pub cluster_identifier: std::option::Option<std::string::String>,
    /// <p>The time (UTC) when the authorization was created.</p>
    pub authorize_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The status of the cluster.</p>
    pub cluster_status: std::option::Option<std::string::String>,
    /// <p>The status of the authorization action.</p>
    pub status: std::option::Option<crate::model::AuthorizationStatus>,
    /// <p>Indicates whether all VPCs in the grantee account are allowed access to the cluster.</p>
    pub allowed_all_vp_cs: bool,
    /// <p>The VPCs allowed access to the cluster.</p>
    pub allowed_vp_cs: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The number of Redshift-managed VPC endpoints created for the authorization.</p>
    pub endpoint_count: i32,
}
impl AuthorizeEndpointAccessOutput {
    /// <p>The Amazon Web Services account ID of the cluster owner.</p>
    pub fn grantor(&self) -> std::option::Option<&str> {
        self.grantor.as_deref()
    }
    /// <p>The Amazon Web Services account ID of the grantee of the cluster.</p>
    pub fn grantee(&self) -> std::option::Option<&str> {
        self.grantee.as_deref()
    }
    /// <p>The cluster identifier.</p>
    pub fn cluster_identifier(&self) -> std::option::Option<&str> {
        self.cluster_identifier.as_deref()
    }
    /// <p>The time (UTC) when the authorization was created.</p>
    pub fn authorize_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.authorize_time.as_ref()
    }
    /// <p>The status of the cluster.</p>
    pub fn cluster_status(&self) -> std::option::Option<&str> {
        self.cluster_status.as_deref()
    }
    /// <p>The status of the authorization action.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::AuthorizationStatus> {
        self.status.as_ref()
    }
    /// <p>Indicates whether all VPCs in the grantee account are allowed access to the cluster.</p>
    pub fn allowed_all_vp_cs(&self) -> bool {
        self.allowed_all_vp_cs
    }
    /// <p>The VPCs allowed access to the cluster.</p>
    pub fn allowed_vp_cs(&self) -> std::option::Option<&[std::string::String]> {
        self.allowed_vp_cs.as_deref()
    }
    /// <p>The number of Redshift-managed VPC endpoints created for the authorization.</p>
    pub fn endpoint_count(&self) -> i32 {
        self.endpoint_count
    }
}
impl std::fmt::Debug for AuthorizeEndpointAccessOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AuthorizeEndpointAccessOutput");
        formatter.field("grantor", &self.grantor);
        formatter.field("grantee", &self.grantee);
        formatter.field("cluster_identifier", &self.cluster_identifier);
        formatter.field("authorize_time", &self.authorize_time);
        formatter.field("cluster_status", &self.cluster_status);
        formatter.field("status", &self.status);
        formatter.field("allowed_all_vp_cs", &self.allowed_all_vp_cs);
        formatter.field("allowed_vp_cs", &self.allowed_vp_cs);
        formatter.field("endpoint_count", &self.endpoint_count);
        formatter.finish()
    }
}
/// See [`AuthorizeEndpointAccessOutput`](crate::output::AuthorizeEndpointAccessOutput)
pub mod authorize_endpoint_access_output {
    /// A builder for [`AuthorizeEndpointAccessOutput`](crate::output::AuthorizeEndpointAccessOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) grantor: std::option::Option<std::string::String>,
        pub(crate) grantee: std::option::Option<std::string::String>,
        pub(crate) cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) authorize_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) cluster_status: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::AuthorizationStatus>,
        pub(crate) allowed_all_vp_cs: std::option::Option<bool>,
        pub(crate) allowed_vp_cs: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) endpoint_count: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The Amazon Web Services account ID of the cluster owner.</p>
        pub fn grantor(mut self, input: impl Into<std::string::String>) -> Self {
            self.grantor = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID of the cluster owner.</p>
        pub fn set_grantor(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.grantor = input;
            self
        }
        /// <p>The Amazon Web Services account ID of the grantee of the cluster.</p>
        pub fn grantee(mut self, input: impl Into<std::string::String>) -> Self {
            self.grantee = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID of the grantee of the cluster.</p>
        pub fn set_grantee(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.grantee = input;
            self
        }
        /// <p>The cluster identifier.</p>
        pub fn cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_identifier = Some(input.into());
            self
        }
        /// <p>The cluster identifier.</p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cluster_identifier = input;
            self
        }
        /// <p>The time (UTC) when the authorization was created.</p>
        pub fn authorize_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.authorize_time = Some(input);
            self
        }
        /// <p>The time (UTC) when the authorization was created.</p>
        pub fn set_authorize_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.authorize_time = input;
            self
        }
        /// <p>The status of the cluster.</p>
        pub fn cluster_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.cluster_status = Some(input.into());
            self
        }
        /// <p>The status of the cluster.</p>
        pub fn set_cluster_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cluster_status = input;
            self
        }
        /// <p>The status of the authorization action.</p>
        pub fn status(mut self, input: crate::model::AuthorizationStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the authorization action.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::AuthorizationStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>Indicates whether all VPCs in the grantee account are allowed access to the cluster.</p>
        pub fn allowed_all_vp_cs(mut self, input: bool) -> Self {
            self.allowed_all_vp_cs = Some(input);
            self
        }
        /// <p>Indicates whether all VPCs in the grantee account are allowed access to the cluster.</p>
        pub fn set_allowed_all_vp_cs(mut self, input: std::option::Option<bool>) -> Self {
            self.allowed_all_vp_cs = input;
            self
        }
        /// Appends an item to `allowed_vp_cs`.
        ///
        /// To override the contents of this collection use [`set_allowed_vp_cs`](Self::set_allowed_vp_cs).
        ///
        /// <p>The VPCs allowed access to the cluster.</p>
        pub fn allowed_vp_cs(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.allowed_vp_cs.unwrap_or_default();
            v.push(input.into());
            self.allowed_vp_cs = Some(v);
            self
        }
        /// <p>The VPCs allowed access to the cluster.</p>
        pub fn set_allowed_vp_cs(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.allowed_vp_cs = input;
            self
        }
        /// <p>The number of Redshift-managed VPC endpoints created for the authorization.</p>
        pub fn endpoint_count(mut self, input: i32) -> Self {
            self.endpoint_count = Some(input);
            self
        }
        /// <p>The number of Redshift-managed VPC endpoints created for the authorization.</p>
        pub fn set_endpoint_count(mut self, input: std::option::Option<i32>) -> Self {
            self.endpoint_count = input;
            self
        }
        /// Consumes the builder and constructs a [`AuthorizeEndpointAccessOutput`](crate::output::AuthorizeEndpointAccessOutput)
        pub fn build(self) -> crate::output::AuthorizeEndpointAccessOutput {
            crate::output::AuthorizeEndpointAccessOutput {
                grantor: self.grantor,
                grantee: self.grantee,
                cluster_identifier: self.cluster_identifier,
                authorize_time: self.authorize_time,
                cluster_status: self.cluster_status,
                status: self.status,
                allowed_all_vp_cs: self.allowed_all_vp_cs.unwrap_or_default(),
                allowed_vp_cs: self.allowed_vp_cs,
                endpoint_count: self.endpoint_count.unwrap_or_default(),
            }
        }
    }
}
impl AuthorizeEndpointAccessOutput {
    /// Creates a new builder-style object to manufacture [`AuthorizeEndpointAccessOutput`](crate::output::AuthorizeEndpointAccessOutput)
    pub fn builder() -> crate::output::authorize_endpoint_access_output::Builder {
        crate::output::authorize_endpoint_access_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AuthorizeDataShareOutput {
    /// <p>An Amazon Resource Name (ARN) that references the datashare that is owned by a specific namespace of the producer cluster. A datashare ARN is in the <code>arn:aws:redshift:{region}:{account-id}:{datashare}:{namespace-guid}/{datashare-name}</code> format.</p>
    pub data_share_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the producer.</p>
    pub producer_arn: std::option::Option<std::string::String>,
    /// <p>A value that specifies whether the datashare can be shared to a publicly accessible cluster.</p>
    pub allow_publicly_accessible_consumers: bool,
    /// <p>A value that specifies when the datashare has an association between a producer and data consumers.</p>
    pub data_share_associations:
        std::option::Option<std::vec::Vec<crate::model::DataShareAssociation>>,
    /// <p>The identifier of a datashare to show its managing entity.</p>
    pub managed_by: std::option::Option<std::string::String>,
}
impl AuthorizeDataShareOutput {
    /// <p>An Amazon Resource Name (ARN) that references the datashare that is owned by a specific namespace of the producer cluster. A datashare ARN is in the <code>arn:aws:redshift:{region}:{account-id}:{datashare}:{namespace-guid}/{datashare-name}</code> format.</p>
    pub fn data_share_arn(&self) -> std::option::Option<&str> {
        self.data_share_arn.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the producer.</p>
    pub fn producer_arn(&self) -> std::option::Option<&str> {
        self.producer_arn.as_deref()
    }
    /// <p>A value that specifies whether the datashare can be shared to a publicly accessible cluster.</p>
    pub fn allow_publicly_accessible_consumers(&self) -> bool {
        self.allow_publicly_accessible_consumers
    }
    /// <p>A value that specifies when the datashare has an association between a producer and data consumers.</p>
    pub fn data_share_associations(
        &self,
    ) -> std::option::Option<&[crate::model::DataShareAssociation]> {
        self.data_share_associations.as_deref()
    }
    /// <p>The identifier of a datashare to show its managing entity.</p>
    pub fn managed_by(&self) -> std::option::Option<&str> {
        self.managed_by.as_deref()
    }
}
impl std::fmt::Debug for AuthorizeDataShareOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AuthorizeDataShareOutput");
        formatter.field("data_share_arn", &self.data_share_arn);
        formatter.field("producer_arn", &self.producer_arn);
        formatter.field(
            "allow_publicly_accessible_consumers",
            &self.allow_publicly_accessible_consumers,
        );
        formatter.field("data_share_associations", &self.data_share_associations);
        formatter.field("managed_by", &self.managed_by);
        formatter.finish()
    }
}
/// See [`AuthorizeDataShareOutput`](crate::output::AuthorizeDataShareOutput)
pub mod authorize_data_share_output {
    /// A builder for [`AuthorizeDataShareOutput`](crate::output::AuthorizeDataShareOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data_share_arn: std::option::Option<std::string::String>,
        pub(crate) producer_arn: std::option::Option<std::string::String>,
        pub(crate) allow_publicly_accessible_consumers: std::option::Option<bool>,
        pub(crate) data_share_associations:
            std::option::Option<std::vec::Vec<crate::model::DataShareAssociation>>,
        pub(crate) managed_by: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>An Amazon Resource Name (ARN) that references the datashare that is owned by a specific namespace of the producer cluster. A datashare ARN is in the <code>arn:aws:redshift:{region}:{account-id}:{datashare}:{namespace-guid}/{datashare-name}</code> format.</p>
        pub fn data_share_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_share_arn = Some(input.into());
            self
        }
        /// <p>An Amazon Resource Name (ARN) that references the datashare that is owned by a specific namespace of the producer cluster. A datashare ARN is in the <code>arn:aws:redshift:{region}:{account-id}:{datashare}:{namespace-guid}/{datashare-name}</code> format.</p>
        pub fn set_data_share_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_share_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the producer.</p>
        pub fn producer_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.producer_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the producer.</p>
        pub fn set_producer_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.producer_arn = input;
            self
        }
        /// <p>A value that specifies whether the datashare can be shared to a publicly accessible cluster.</p>
        pub fn allow_publicly_accessible_consumers(mut self, input: bool) -> Self {
            self.allow_publicly_accessible_consumers = Some(input);
            self
        }
        /// <p>A value that specifies whether the datashare can be shared to a publicly accessible cluster.</p>
        pub fn set_allow_publicly_accessible_consumers(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.allow_publicly_accessible_consumers = input;
            self
        }
        /// Appends an item to `data_share_associations`.
        ///
        /// To override the contents of this collection use [`set_data_share_associations`](Self::set_data_share_associations).
        ///
        /// <p>A value that specifies when the datashare has an association between a producer and data consumers.</p>
        pub fn data_share_associations(
            mut self,
            input: crate::model::DataShareAssociation,
        ) -> Self {
            let mut v = self.data_share_associations.unwrap_or_default();
            v.push(input);
            self.data_share_associations = Some(v);
            self
        }
        /// <p>A value that specifies when the datashare has an association between a producer and data consumers.</p>
        pub fn set_data_share_associations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DataShareAssociation>>,
        ) -> Self {
            self.data_share_associations = input;
            self
        }
        /// <p>The identifier of a datashare to show its managing entity.</p>
        pub fn managed_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.managed_by = Some(input.into());
            self
        }
        /// <p>The identifier of a datashare to show its managing entity.</p>
        pub fn set_managed_by(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.managed_by = input;
            self
        }
        /// Consumes the builder and constructs a [`AuthorizeDataShareOutput`](crate::output::AuthorizeDataShareOutput)
        pub fn build(self) -> crate::output::AuthorizeDataShareOutput {
            crate::output::AuthorizeDataShareOutput {
                data_share_arn: self.data_share_arn,
                producer_arn: self.producer_arn,
                allow_publicly_accessible_consumers: self
                    .allow_publicly_accessible_consumers
                    .unwrap_or_default(),
                data_share_associations: self.data_share_associations,
                managed_by: self.managed_by,
            }
        }
    }
}
impl AuthorizeDataShareOutput {
    /// Creates a new builder-style object to manufacture [`AuthorizeDataShareOutput`](crate::output::AuthorizeDataShareOutput)
    pub fn builder() -> crate::output::authorize_data_share_output::Builder {
        crate::output::authorize_data_share_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AuthorizeClusterSecurityGroupIngressOutput {
    /// <p>Describes a security group.</p>
    pub cluster_security_group: std::option::Option<crate::model::ClusterSecurityGroup>,
}
impl AuthorizeClusterSecurityGroupIngressOutput {
    /// <p>Describes a security group.</p>
    pub fn cluster_security_group(
        &self,
    ) -> std::option::Option<&crate::model::ClusterSecurityGroup> {
        self.cluster_security_group.as_ref()
    }
}
impl std::fmt::Debug for AuthorizeClusterSecurityGroupIngressOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AuthorizeClusterSecurityGroupIngressOutput");
        formatter.field("cluster_security_group", &self.cluster_security_group);
        formatter.finish()
    }
}
/// See [`AuthorizeClusterSecurityGroupIngressOutput`](crate::output::AuthorizeClusterSecurityGroupIngressOutput)
pub mod authorize_cluster_security_group_ingress_output {
    /// A builder for [`AuthorizeClusterSecurityGroupIngressOutput`](crate::output::AuthorizeClusterSecurityGroupIngressOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cluster_security_group: std::option::Option<crate::model::ClusterSecurityGroup>,
    }
    impl Builder {
        /// <p>Describes a security group.</p>
        pub fn cluster_security_group(mut self, input: crate::model::ClusterSecurityGroup) -> Self {
            self.cluster_security_group = Some(input);
            self
        }
        /// <p>Describes a security group.</p>
        pub fn set_cluster_security_group(
            mut self,
            input: std::option::Option<crate::model::ClusterSecurityGroup>,
        ) -> Self {
            self.cluster_security_group = input;
            self
        }
        /// Consumes the builder and constructs a [`AuthorizeClusterSecurityGroupIngressOutput`](crate::output::AuthorizeClusterSecurityGroupIngressOutput)
        pub fn build(self) -> crate::output::AuthorizeClusterSecurityGroupIngressOutput {
            crate::output::AuthorizeClusterSecurityGroupIngressOutput {
                cluster_security_group: self.cluster_security_group,
            }
        }
    }
}
impl AuthorizeClusterSecurityGroupIngressOutput {
    /// Creates a new builder-style object to manufacture [`AuthorizeClusterSecurityGroupIngressOutput`](crate::output::AuthorizeClusterSecurityGroupIngressOutput)
    pub fn builder() -> crate::output::authorize_cluster_security_group_ingress_output::Builder {
        crate::output::authorize_cluster_security_group_ingress_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateDataShareConsumerOutput {
    /// <p>An Amazon Resource Name (ARN) that references the datashare that is owned by a specific namespace of the producer cluster. A datashare ARN is in the <code>arn:aws:redshift:{region}:{account-id}:{datashare}:{namespace-guid}/{datashare-name}</code> format.</p>
    pub data_share_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the producer.</p>
    pub producer_arn: std::option::Option<std::string::String>,
    /// <p>A value that specifies whether the datashare can be shared to a publicly accessible cluster.</p>
    pub allow_publicly_accessible_consumers: bool,
    /// <p>A value that specifies when the datashare has an association between a producer and data consumers.</p>
    pub data_share_associations:
        std::option::Option<std::vec::Vec<crate::model::DataShareAssociation>>,
    /// <p>The identifier of a datashare to show its managing entity.</p>
    pub managed_by: std::option::Option<std::string::String>,
}
impl AssociateDataShareConsumerOutput {
    /// <p>An Amazon Resource Name (ARN) that references the datashare that is owned by a specific namespace of the producer cluster. A datashare ARN is in the <code>arn:aws:redshift:{region}:{account-id}:{datashare}:{namespace-guid}/{datashare-name}</code> format.</p>
    pub fn data_share_arn(&self) -> std::option::Option<&str> {
        self.data_share_arn.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the producer.</p>
    pub fn producer_arn(&self) -> std::option::Option<&str> {
        self.producer_arn.as_deref()
    }
    /// <p>A value that specifies whether the datashare can be shared to a publicly accessible cluster.</p>
    pub fn allow_publicly_accessible_consumers(&self) -> bool {
        self.allow_publicly_accessible_consumers
    }
    /// <p>A value that specifies when the datashare has an association between a producer and data consumers.</p>
    pub fn data_share_associations(
        &self,
    ) -> std::option::Option<&[crate::model::DataShareAssociation]> {
        self.data_share_associations.as_deref()
    }
    /// <p>The identifier of a datashare to show its managing entity.</p>
    pub fn managed_by(&self) -> std::option::Option<&str> {
        self.managed_by.as_deref()
    }
}
impl std::fmt::Debug for AssociateDataShareConsumerOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateDataShareConsumerOutput");
        formatter.field("data_share_arn", &self.data_share_arn);
        formatter.field("producer_arn", &self.producer_arn);
        formatter.field(
            "allow_publicly_accessible_consumers",
            &self.allow_publicly_accessible_consumers,
        );
        formatter.field("data_share_associations", &self.data_share_associations);
        formatter.field("managed_by", &self.managed_by);
        formatter.finish()
    }
}
/// See [`AssociateDataShareConsumerOutput`](crate::output::AssociateDataShareConsumerOutput)
pub mod associate_data_share_consumer_output {
    /// A builder for [`AssociateDataShareConsumerOutput`](crate::output::AssociateDataShareConsumerOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data_share_arn: std::option::Option<std::string::String>,
        pub(crate) producer_arn: std::option::Option<std::string::String>,
        pub(crate) allow_publicly_accessible_consumers: std::option::Option<bool>,
        pub(crate) data_share_associations:
            std::option::Option<std::vec::Vec<crate::model::DataShareAssociation>>,
        pub(crate) managed_by: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>An Amazon Resource Name (ARN) that references the datashare that is owned by a specific namespace of the producer cluster. A datashare ARN is in the <code>arn:aws:redshift:{region}:{account-id}:{datashare}:{namespace-guid}/{datashare-name}</code> format.</p>
        pub fn data_share_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_share_arn = Some(input.into());
            self
        }
        /// <p>An Amazon Resource Name (ARN) that references the datashare that is owned by a specific namespace of the producer cluster. A datashare ARN is in the <code>arn:aws:redshift:{region}:{account-id}:{datashare}:{namespace-guid}/{datashare-name}</code> format.</p>
        pub fn set_data_share_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_share_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the producer.</p>
        pub fn producer_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.producer_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the producer.</p>
        pub fn set_producer_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.producer_arn = input;
            self
        }
        /// <p>A value that specifies whether the datashare can be shared to a publicly accessible cluster.</p>
        pub fn allow_publicly_accessible_consumers(mut self, input: bool) -> Self {
            self.allow_publicly_accessible_consumers = Some(input);
            self
        }
        /// <p>A value that specifies whether the datashare can be shared to a publicly accessible cluster.</p>
        pub fn set_allow_publicly_accessible_consumers(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.allow_publicly_accessible_consumers = input;
            self
        }
        /// Appends an item to `data_share_associations`.
        ///
        /// To override the contents of this collection use [`set_data_share_associations`](Self::set_data_share_associations).
        ///
        /// <p>A value that specifies when the datashare has an association between a producer and data consumers.</p>
        pub fn data_share_associations(
            mut self,
            input: crate::model::DataShareAssociation,
        ) -> Self {
            let mut v = self.data_share_associations.unwrap_or_default();
            v.push(input);
            self.data_share_associations = Some(v);
            self
        }
        /// <p>A value that specifies when the datashare has an association between a producer and data consumers.</p>
        pub fn set_data_share_associations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DataShareAssociation>>,
        ) -> Self {
            self.data_share_associations = input;
            self
        }
        /// <p>The identifier of a datashare to show its managing entity.</p>
        pub fn managed_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.managed_by = Some(input.into());
            self
        }
        /// <p>The identifier of a datashare to show its managing entity.</p>
        pub fn set_managed_by(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.managed_by = input;
            self
        }
        /// Consumes the builder and constructs a [`AssociateDataShareConsumerOutput`](crate::output::AssociateDataShareConsumerOutput)
        pub fn build(self) -> crate::output::AssociateDataShareConsumerOutput {
            crate::output::AssociateDataShareConsumerOutput {
                data_share_arn: self.data_share_arn,
                producer_arn: self.producer_arn,
                allow_publicly_accessible_consumers: self
                    .allow_publicly_accessible_consumers
                    .unwrap_or_default(),
                data_share_associations: self.data_share_associations,
                managed_by: self.managed_by,
            }
        }
    }
}
impl AssociateDataShareConsumerOutput {
    /// Creates a new builder-style object to manufacture [`AssociateDataShareConsumerOutput`](crate::output::AssociateDataShareConsumerOutput)
    pub fn builder() -> crate::output::associate_data_share_consumer_output::Builder {
        crate::output::associate_data_share_consumer_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddPartnerOutput {
    /// <p>The name of the database that receives data from the partner.</p>
    pub database_name: std::option::Option<std::string::String>,
    /// <p>The name of the partner that is authorized to send data.</p>
    pub partner_name: std::option::Option<std::string::String>,
}
impl AddPartnerOutput {
    /// <p>The name of the database that receives data from the partner.</p>
    pub fn database_name(&self) -> std::option::Option<&str> {
        self.database_name.as_deref()
    }
    /// <p>The name of the partner that is authorized to send data.</p>
    pub fn partner_name(&self) -> std::option::Option<&str> {
        self.partner_name.as_deref()
    }
}
impl std::fmt::Debug for AddPartnerOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddPartnerOutput");
        formatter.field("database_name", &self.database_name);
        formatter.field("partner_name", &self.partner_name);
        formatter.finish()
    }
}
/// See [`AddPartnerOutput`](crate::output::AddPartnerOutput)
pub mod add_partner_output {
    /// A builder for [`AddPartnerOutput`](crate::output::AddPartnerOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) database_name: std::option::Option<std::string::String>,
        pub(crate) partner_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the database that receives data from the partner.</p>
        pub fn database_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.database_name = Some(input.into());
            self
        }
        /// <p>The name of the database that receives data from the partner.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.database_name = input;
            self
        }
        /// <p>The name of the partner that is authorized to send data.</p>
        pub fn partner_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.partner_name = Some(input.into());
            self
        }
        /// <p>The name of the partner that is authorized to send data.</p>
        pub fn set_partner_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.partner_name = input;
            self
        }
        /// Consumes the builder and constructs a [`AddPartnerOutput`](crate::output::AddPartnerOutput)
        pub fn build(self) -> crate::output::AddPartnerOutput {
            crate::output::AddPartnerOutput {
                database_name: self.database_name,
                partner_name: self.partner_name,
            }
        }
    }
}
impl AddPartnerOutput {
    /// Creates a new builder-style object to manufacture [`AddPartnerOutput`](crate::output::AddPartnerOutput)
    pub fn builder() -> crate::output::add_partner_output::Builder {
        crate::output::add_partner_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AcceptReservedNodeExchangeOutput {
    /// <p></p>
    pub exchanged_reserved_node: std::option::Option<crate::model::ReservedNode>,
}
impl AcceptReservedNodeExchangeOutput {
    /// <p></p>
    pub fn exchanged_reserved_node(&self) -> std::option::Option<&crate::model::ReservedNode> {
        self.exchanged_reserved_node.as_ref()
    }
}
impl std::fmt::Debug for AcceptReservedNodeExchangeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AcceptReservedNodeExchangeOutput");
        formatter.field("exchanged_reserved_node", &self.exchanged_reserved_node);
        formatter.finish()
    }
}
/// See [`AcceptReservedNodeExchangeOutput`](crate::output::AcceptReservedNodeExchangeOutput)
pub mod accept_reserved_node_exchange_output {
    /// A builder for [`AcceptReservedNodeExchangeOutput`](crate::output::AcceptReservedNodeExchangeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) exchanged_reserved_node: std::option::Option<crate::model::ReservedNode>,
    }
    impl Builder {
        /// <p></p>
        pub fn exchanged_reserved_node(mut self, input: crate::model::ReservedNode) -> Self {
            self.exchanged_reserved_node = Some(input);
            self
        }
        /// <p></p>
        pub fn set_exchanged_reserved_node(
            mut self,
            input: std::option::Option<crate::model::ReservedNode>,
        ) -> Self {
            self.exchanged_reserved_node = input;
            self
        }
        /// Consumes the builder and constructs a [`AcceptReservedNodeExchangeOutput`](crate::output::AcceptReservedNodeExchangeOutput)
        pub fn build(self) -> crate::output::AcceptReservedNodeExchangeOutput {
            crate::output::AcceptReservedNodeExchangeOutput {
                exchanged_reserved_node: self.exchanged_reserved_node,
            }
        }
    }
}
impl AcceptReservedNodeExchangeOutput {
    /// Creates a new builder-style object to manufacture [`AcceptReservedNodeExchangeOutput`](crate::output::AcceptReservedNodeExchangeOutput)
    pub fn builder() -> crate::output::accept_reserved_node_exchange_output::Builder {
        crate::output::accept_reserved_node_exchange_output::Builder::default()
    }
}
