// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for Amazon Redshift
///
/// Client for invoking operations on Amazon Redshift. Each operation on Amazon Redshift is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_redshift::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
/// let shared_config = aws_config::load_from_env().await;
/// let config = aws_sdk_redshift::config::Builder::from(&shared_config)
///   .retry_config(RetryConfig::disabled())
///   .build();
/// let client = aws_sdk_redshift::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`AcceptReservedNodeExchange`](crate::client::fluent_builders::AcceptReservedNodeExchange) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`reserved_node_id(impl Into<String>)`](crate::client::fluent_builders::AcceptReservedNodeExchange::reserved_node_id) / [`set_reserved_node_id(Option<String>)`](crate::client::fluent_builders::AcceptReservedNodeExchange::set_reserved_node_id): <p>A string representing the node identifier of the DC1 Reserved Node to be exchanged.</p>
    ///   - [`target_reserved_node_offering_id(impl Into<String>)`](crate::client::fluent_builders::AcceptReservedNodeExchange::target_reserved_node_offering_id) / [`set_target_reserved_node_offering_id(Option<String>)`](crate::client::fluent_builders::AcceptReservedNodeExchange::set_target_reserved_node_offering_id): <p>The unique identifier of the DC2 Reserved Node offering to be used for the exchange. You can obtain the value for the parameter by calling <code>GetReservedNodeExchangeOfferings</code> </p>
    /// - On success, responds with [`AcceptReservedNodeExchangeOutput`](crate::output::AcceptReservedNodeExchangeOutput) with field(s):
    ///   - [`exchanged_reserved_node(Option<ReservedNode>)`](crate::output::AcceptReservedNodeExchangeOutput::exchanged_reserved_node): <p></p>
    /// - On failure, responds with [`SdkError<AcceptReservedNodeExchangeError>`](crate::error::AcceptReservedNodeExchangeError)
    pub fn accept_reserved_node_exchange(&self) -> fluent_builders::AcceptReservedNodeExchange {
        fluent_builders::AcceptReservedNodeExchange::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AddPartner`](crate::client::fluent_builders::AddPartner) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::AddPartner::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::AddPartner::set_account_id): <p>The Amazon Web Services account ID that owns the cluster.</p>
    ///   - [`cluster_identifier(impl Into<String>)`](crate::client::fluent_builders::AddPartner::cluster_identifier) / [`set_cluster_identifier(Option<String>)`](crate::client::fluent_builders::AddPartner::set_cluster_identifier): <p>The cluster identifier of the cluster that receives data from the partner.</p>
    ///   - [`database_name(impl Into<String>)`](crate::client::fluent_builders::AddPartner::database_name) / [`set_database_name(Option<String>)`](crate::client::fluent_builders::AddPartner::set_database_name): <p>The name of the database that receives data from the partner.</p>
    ///   - [`partner_name(impl Into<String>)`](crate::client::fluent_builders::AddPartner::partner_name) / [`set_partner_name(Option<String>)`](crate::client::fluent_builders::AddPartner::set_partner_name): <p>The name of the partner that is authorized to send data.</p>
    /// - On success, responds with [`AddPartnerOutput`](crate::output::AddPartnerOutput) with field(s):
    ///   - [`database_name(Option<String>)`](crate::output::AddPartnerOutput::database_name): <p>The name of the database that receives data from the partner.</p>
    ///   - [`partner_name(Option<String>)`](crate::output::AddPartnerOutput::partner_name): <p>The name of the partner that is authorized to send data.</p>
    /// - On failure, responds with [`SdkError<AddPartnerError>`](crate::error::AddPartnerError)
    pub fn add_partner(&self) -> fluent_builders::AddPartner {
        fluent_builders::AddPartner::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AssociateDataShareConsumer`](crate::client::fluent_builders::AssociateDataShareConsumer) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`data_share_arn(impl Into<String>)`](crate::client::fluent_builders::AssociateDataShareConsumer::data_share_arn) / [`set_data_share_arn(Option<String>)`](crate::client::fluent_builders::AssociateDataShareConsumer::set_data_share_arn): <p>The Amazon Resource Name (ARN) of the datashare that the consumer is to use with the account or the namespace.</p>
    ///   - [`associate_entire_account(bool)`](crate::client::fluent_builders::AssociateDataShareConsumer::associate_entire_account) / [`set_associate_entire_account(Option<bool>)`](crate::client::fluent_builders::AssociateDataShareConsumer::set_associate_entire_account): <p>A value that specifies whether the datashare is associated with the entire account.</p>
    ///   - [`consumer_arn(impl Into<String>)`](crate::client::fluent_builders::AssociateDataShareConsumer::consumer_arn) / [`set_consumer_arn(Option<String>)`](crate::client::fluent_builders::AssociateDataShareConsumer::set_consumer_arn): <p>The Amazon Resource Name (ARN) of the consumer that is associated with the datashare.</p>
    ///   - [`consumer_region(impl Into<String>)`](crate::client::fluent_builders::AssociateDataShareConsumer::consumer_region) / [`set_consumer_region(Option<String>)`](crate::client::fluent_builders::AssociateDataShareConsumer::set_consumer_region): <p>From a datashare consumer account, associates a datashare with all existing and future namespaces in the specified Amazon Web Services Region.</p>
    /// - On success, responds with [`AssociateDataShareConsumerOutput`](crate::output::AssociateDataShareConsumerOutput) with field(s):
    ///   - [`data_share_arn(Option<String>)`](crate::output::AssociateDataShareConsumerOutput::data_share_arn): <p>An Amazon Resource Name (ARN) that references the datashare that is owned by a specific namespace of the producer cluster. A datashare ARN is in the <code>arn:aws:redshift:{region}:{account-id}:{datashare}:{namespace-guid}/{datashare-name}</code> format.</p>
    ///   - [`producer_arn(Option<String>)`](crate::output::AssociateDataShareConsumerOutput::producer_arn): <p>The Amazon Resource Name (ARN) of the producer.</p>
    ///   - [`allow_publicly_accessible_consumers(bool)`](crate::output::AssociateDataShareConsumerOutput::allow_publicly_accessible_consumers): <p>A value that specifies whether the datashare can be shared to a publicly accessible cluster.</p>
    ///   - [`data_share_associations(Option<Vec<DataShareAssociation>>)`](crate::output::AssociateDataShareConsumerOutput::data_share_associations): <p>A value that specifies when the datashare has an association between a producer and data consumers.</p>
    ///   - [`managed_by(Option<String>)`](crate::output::AssociateDataShareConsumerOutput::managed_by): <p>The identifier of a datashare to show its managing entity.</p>
    /// - On failure, responds with [`SdkError<AssociateDataShareConsumerError>`](crate::error::AssociateDataShareConsumerError)
    pub fn associate_data_share_consumer(&self) -> fluent_builders::AssociateDataShareConsumer {
        fluent_builders::AssociateDataShareConsumer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AuthorizeClusterSecurityGroupIngress`](crate::client::fluent_builders::AuthorizeClusterSecurityGroupIngress) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster_security_group_name(impl Into<String>)`](crate::client::fluent_builders::AuthorizeClusterSecurityGroupIngress::cluster_security_group_name) / [`set_cluster_security_group_name(Option<String>)`](crate::client::fluent_builders::AuthorizeClusterSecurityGroupIngress::set_cluster_security_group_name): <p>The name of the security group to which the ingress rule is added.</p>
    ///   - [`cidrip(impl Into<String>)`](crate::client::fluent_builders::AuthorizeClusterSecurityGroupIngress::cidrip) / [`set_cidrip(Option<String>)`](crate::client::fluent_builders::AuthorizeClusterSecurityGroupIngress::set_cidrip): <p>The IP range to be added the Amazon Redshift security group.</p>
    ///   - [`ec2_security_group_name(impl Into<String>)`](crate::client::fluent_builders::AuthorizeClusterSecurityGroupIngress::ec2_security_group_name) / [`set_ec2_security_group_name(Option<String>)`](crate::client::fluent_builders::AuthorizeClusterSecurityGroupIngress::set_ec2_security_group_name): <p>The EC2 security group to be added the Amazon Redshift security group.</p>
    ///   - [`ec2_security_group_owner_id(impl Into<String>)`](crate::client::fluent_builders::AuthorizeClusterSecurityGroupIngress::ec2_security_group_owner_id) / [`set_ec2_security_group_owner_id(Option<String>)`](crate::client::fluent_builders::AuthorizeClusterSecurityGroupIngress::set_ec2_security_group_owner_id): <p>The Amazon Web Services account number of the owner of the security group specified by the <i>EC2SecurityGroupName</i> parameter. The Amazon Web Services Access Key ID is not an acceptable value. </p>  <p>Example: <code>111122223333</code> </p>
    /// - On success, responds with [`AuthorizeClusterSecurityGroupIngressOutput`](crate::output::AuthorizeClusterSecurityGroupIngressOutput) with field(s):
    ///   - [`cluster_security_group(Option<ClusterSecurityGroup>)`](crate::output::AuthorizeClusterSecurityGroupIngressOutput::cluster_security_group): <p>Describes a security group.</p>
    /// - On failure, responds with [`SdkError<AuthorizeClusterSecurityGroupIngressError>`](crate::error::AuthorizeClusterSecurityGroupIngressError)
    pub fn authorize_cluster_security_group_ingress(
        &self,
    ) -> fluent_builders::AuthorizeClusterSecurityGroupIngress {
        fluent_builders::AuthorizeClusterSecurityGroupIngress::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AuthorizeDataShare`](crate::client::fluent_builders::AuthorizeDataShare) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`data_share_arn(impl Into<String>)`](crate::client::fluent_builders::AuthorizeDataShare::data_share_arn) / [`set_data_share_arn(Option<String>)`](crate::client::fluent_builders::AuthorizeDataShare::set_data_share_arn): <p>The Amazon Resource Name (ARN) of the datashare that producers are to authorize sharing for.</p>
    ///   - [`consumer_identifier(impl Into<String>)`](crate::client::fluent_builders::AuthorizeDataShare::consumer_identifier) / [`set_consumer_identifier(Option<String>)`](crate::client::fluent_builders::AuthorizeDataShare::set_consumer_identifier): <p>The identifier of the data consumer that is authorized to access the datashare. This identifier is an Amazon Web Services account ID or a keyword, such as ADX.</p>
    /// - On success, responds with [`AuthorizeDataShareOutput`](crate::output::AuthorizeDataShareOutput) with field(s):
    ///   - [`data_share_arn(Option<String>)`](crate::output::AuthorizeDataShareOutput::data_share_arn): <p>An Amazon Resource Name (ARN) that references the datashare that is owned by a specific namespace of the producer cluster. A datashare ARN is in the <code>arn:aws:redshift:{region}:{account-id}:{datashare}:{namespace-guid}/{datashare-name}</code> format.</p>
    ///   - [`producer_arn(Option<String>)`](crate::output::AuthorizeDataShareOutput::producer_arn): <p>The Amazon Resource Name (ARN) of the producer.</p>
    ///   - [`allow_publicly_accessible_consumers(bool)`](crate::output::AuthorizeDataShareOutput::allow_publicly_accessible_consumers): <p>A value that specifies whether the datashare can be shared to a publicly accessible cluster.</p>
    ///   - [`data_share_associations(Option<Vec<DataShareAssociation>>)`](crate::output::AuthorizeDataShareOutput::data_share_associations): <p>A value that specifies when the datashare has an association between a producer and data consumers.</p>
    ///   - [`managed_by(Option<String>)`](crate::output::AuthorizeDataShareOutput::managed_by): <p>The identifier of a datashare to show its managing entity.</p>
    /// - On failure, responds with [`SdkError<AuthorizeDataShareError>`](crate::error::AuthorizeDataShareError)
    pub fn authorize_data_share(&self) -> fluent_builders::AuthorizeDataShare {
        fluent_builders::AuthorizeDataShare::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AuthorizeEndpointAccess`](crate::client::fluent_builders::AuthorizeEndpointAccess) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster_identifier(impl Into<String>)`](crate::client::fluent_builders::AuthorizeEndpointAccess::cluster_identifier) / [`set_cluster_identifier(Option<String>)`](crate::client::fluent_builders::AuthorizeEndpointAccess::set_cluster_identifier): <p>The cluster identifier of the cluster to grant access to.</p>
    ///   - [`account(impl Into<String>)`](crate::client::fluent_builders::AuthorizeEndpointAccess::account) / [`set_account(Option<String>)`](crate::client::fluent_builders::AuthorizeEndpointAccess::set_account): <p>The Amazon Web Services account ID to grant access to.</p>
    ///   - [`vpc_ids(Vec<String>)`](crate::client::fluent_builders::AuthorizeEndpointAccess::vpc_ids) / [`set_vpc_ids(Option<Vec<String>>)`](crate::client::fluent_builders::AuthorizeEndpointAccess::set_vpc_ids): <p>The virtual private cloud (VPC) identifiers to grant access to.</p>
    /// - On success, responds with [`AuthorizeEndpointAccessOutput`](crate::output::AuthorizeEndpointAccessOutput) with field(s):
    ///   - [`grantor(Option<String>)`](crate::output::AuthorizeEndpointAccessOutput::grantor): <p>The Amazon Web Services account ID of the cluster owner.</p>
    ///   - [`grantee(Option<String>)`](crate::output::AuthorizeEndpointAccessOutput::grantee): <p>The Amazon Web Services account ID of the grantee of the cluster.</p>
    ///   - [`cluster_identifier(Option<String>)`](crate::output::AuthorizeEndpointAccessOutput::cluster_identifier): <p>The cluster identifier.</p>
    ///   - [`authorize_time(Option<DateTime>)`](crate::output::AuthorizeEndpointAccessOutput::authorize_time): <p>The time (UTC) when the authorization was created.</p>
    ///   - [`cluster_status(Option<String>)`](crate::output::AuthorizeEndpointAccessOutput::cluster_status): <p>The status of the cluster.</p>
    ///   - [`status(Option<AuthorizationStatus>)`](crate::output::AuthorizeEndpointAccessOutput::status): <p>The status of the authorization action.</p>
    ///   - [`allowed_all_vp_cs(bool)`](crate::output::AuthorizeEndpointAccessOutput::allowed_all_vp_cs): <p>Indicates whether all VPCs in the grantee account are allowed access to the cluster.</p>
    ///   - [`allowed_vp_cs(Option<Vec<String>>)`](crate::output::AuthorizeEndpointAccessOutput::allowed_vp_cs): <p>The VPCs allowed access to the cluster.</p>
    ///   - [`endpoint_count(i32)`](crate::output::AuthorizeEndpointAccessOutput::endpoint_count): <p>The number of Redshift-managed VPC endpoints created for the authorization.</p>
    /// - On failure, responds with [`SdkError<AuthorizeEndpointAccessError>`](crate::error::AuthorizeEndpointAccessError)
    pub fn authorize_endpoint_access(&self) -> fluent_builders::AuthorizeEndpointAccess {
        fluent_builders::AuthorizeEndpointAccess::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AuthorizeSnapshotAccess`](crate::client::fluent_builders::AuthorizeSnapshotAccess) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`snapshot_identifier(impl Into<String>)`](crate::client::fluent_builders::AuthorizeSnapshotAccess::snapshot_identifier) / [`set_snapshot_identifier(Option<String>)`](crate::client::fluent_builders::AuthorizeSnapshotAccess::set_snapshot_identifier): <p>The identifier of the snapshot the account is authorized to restore.</p>
    ///   - [`snapshot_cluster_identifier(impl Into<String>)`](crate::client::fluent_builders::AuthorizeSnapshotAccess::snapshot_cluster_identifier) / [`set_snapshot_cluster_identifier(Option<String>)`](crate::client::fluent_builders::AuthorizeSnapshotAccess::set_snapshot_cluster_identifier): <p>The identifier of the cluster the snapshot was created from. This parameter is required if your IAM user has a policy containing a snapshot resource element that specifies anything other than * for the cluster name.</p>
    ///   - [`account_with_restore_access(impl Into<String>)`](crate::client::fluent_builders::AuthorizeSnapshotAccess::account_with_restore_access) / [`set_account_with_restore_access(Option<String>)`](crate::client::fluent_builders::AuthorizeSnapshotAccess::set_account_with_restore_access): <p>The identifier of the Amazon Web Services account authorized to restore the specified snapshot.</p>  <p>To share a snapshot with Amazon Web Services Support, specify amazon-redshift-support.</p>
    /// - On success, responds with [`AuthorizeSnapshotAccessOutput`](crate::output::AuthorizeSnapshotAccessOutput) with field(s):
    ///   - [`snapshot(Option<Snapshot>)`](crate::output::AuthorizeSnapshotAccessOutput::snapshot): <p>Describes a snapshot.</p>
    /// - On failure, responds with [`SdkError<AuthorizeSnapshotAccessError>`](crate::error::AuthorizeSnapshotAccessError)
    pub fn authorize_snapshot_access(&self) -> fluent_builders::AuthorizeSnapshotAccess {
        fluent_builders::AuthorizeSnapshotAccess::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`BatchDeleteClusterSnapshots`](crate::client::fluent_builders::BatchDeleteClusterSnapshots) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`identifiers(Vec<DeleteClusterSnapshotMessage>)`](crate::client::fluent_builders::BatchDeleteClusterSnapshots::identifiers) / [`set_identifiers(Option<Vec<DeleteClusterSnapshotMessage>>)`](crate::client::fluent_builders::BatchDeleteClusterSnapshots::set_identifiers): <p>A list of identifiers for the snapshots that you want to delete.</p>
    /// - On success, responds with [`BatchDeleteClusterSnapshotsOutput`](crate::output::BatchDeleteClusterSnapshotsOutput) with field(s):
    ///   - [`resources(Option<Vec<String>>)`](crate::output::BatchDeleteClusterSnapshotsOutput::resources): <p>A list of the snapshot identifiers that were deleted. </p>
    ///   - [`errors(Option<Vec<SnapshotErrorMessage>>)`](crate::output::BatchDeleteClusterSnapshotsOutput::errors): <p>A list of any errors returned.</p>
    /// - On failure, responds with [`SdkError<BatchDeleteClusterSnapshotsError>`](crate::error::BatchDeleteClusterSnapshotsError)
    pub fn batch_delete_cluster_snapshots(&self) -> fluent_builders::BatchDeleteClusterSnapshots {
        fluent_builders::BatchDeleteClusterSnapshots::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`BatchModifyClusterSnapshots`](crate::client::fluent_builders::BatchModifyClusterSnapshots) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`snapshot_identifier_list(Vec<String>)`](crate::client::fluent_builders::BatchModifyClusterSnapshots::snapshot_identifier_list) / [`set_snapshot_identifier_list(Option<Vec<String>>)`](crate::client::fluent_builders::BatchModifyClusterSnapshots::set_snapshot_identifier_list): <p>A list of snapshot identifiers you want to modify.</p>
    ///   - [`manual_snapshot_retention_period(i32)`](crate::client::fluent_builders::BatchModifyClusterSnapshots::manual_snapshot_retention_period) / [`set_manual_snapshot_retention_period(Option<i32>)`](crate::client::fluent_builders::BatchModifyClusterSnapshots::set_manual_snapshot_retention_period): <p>The number of days that a manual snapshot is retained. If you specify the value -1, the manual snapshot is retained indefinitely.</p>  <p>The number must be either -1 or an integer between 1 and 3,653.</p>  <p>If you decrease the manual snapshot retention period from its current value, existing manual snapshots that fall outside of the new retention period will return an error. If you want to suppress the errors and delete the snapshots, use the force option. </p>
    ///   - [`force(bool)`](crate::client::fluent_builders::BatchModifyClusterSnapshots::force) / [`set_force(bool)`](crate::client::fluent_builders::BatchModifyClusterSnapshots::set_force): <p>A boolean value indicating whether to override an exception if the retention period has passed. </p>
    /// - On success, responds with [`BatchModifyClusterSnapshotsOutput`](crate::output::BatchModifyClusterSnapshotsOutput) with field(s):
    ///   - [`resources(Option<Vec<String>>)`](crate::output::BatchModifyClusterSnapshotsOutput::resources): <p>A list of the snapshots that were modified.</p>
    ///   - [`errors(Option<Vec<SnapshotErrorMessage>>)`](crate::output::BatchModifyClusterSnapshotsOutput::errors): <p>A list of any errors returned.</p>
    /// - On failure, responds with [`SdkError<BatchModifyClusterSnapshotsError>`](crate::error::BatchModifyClusterSnapshotsError)
    pub fn batch_modify_cluster_snapshots(&self) -> fluent_builders::BatchModifyClusterSnapshots {
        fluent_builders::BatchModifyClusterSnapshots::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CancelResize`](crate::client::fluent_builders::CancelResize) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster_identifier(impl Into<String>)`](crate::client::fluent_builders::CancelResize::cluster_identifier) / [`set_cluster_identifier(Option<String>)`](crate::client::fluent_builders::CancelResize::set_cluster_identifier): <p>The unique identifier for the cluster that you want to cancel a resize operation for.</p>
    /// - On success, responds with [`CancelResizeOutput`](crate::output::CancelResizeOutput) with field(s):
    ///   - [`target_node_type(Option<String>)`](crate::output::CancelResizeOutput::target_node_type): <p>The node type that the cluster will have after the resize operation is complete.</p>
    ///   - [`target_number_of_nodes(Option<i32>)`](crate::output::CancelResizeOutput::target_number_of_nodes): <p>The number of nodes that the cluster will have after the resize operation is complete.</p>
    ///   - [`target_cluster_type(Option<String>)`](crate::output::CancelResizeOutput::target_cluster_type): <p>The cluster type after the resize operation is complete.</p>  <p>Valid Values: <code>multi-node</code> | <code>single-node</code> </p>
    ///   - [`status(Option<String>)`](crate::output::CancelResizeOutput::status): <p>The status of the resize operation.</p>  <p>Valid Values: <code>NONE</code> | <code>IN_PROGRESS</code> | <code>FAILED</code> | <code>SUCCEEDED</code> | <code>CANCELLING</code> </p>
    ///   - [`import_tables_completed(Option<Vec<String>>)`](crate::output::CancelResizeOutput::import_tables_completed): <p>The names of tables that have been completely imported .</p>  <p>Valid Values: List of table names.</p>
    ///   - [`import_tables_in_progress(Option<Vec<String>>)`](crate::output::CancelResizeOutput::import_tables_in_progress): <p>The names of tables that are being currently imported.</p>  <p>Valid Values: List of table names.</p>
    ///   - [`import_tables_not_started(Option<Vec<String>>)`](crate::output::CancelResizeOutput::import_tables_not_started): <p>The names of tables that have not been yet imported.</p>  <p>Valid Values: List of table names</p>
    ///   - [`avg_resize_rate_in_mega_bytes_per_second(Option<f64>)`](crate::output::CancelResizeOutput::avg_resize_rate_in_mega_bytes_per_second): <p>The average rate of the resize operation over the last few minutes, measured in megabytes per second. After the resize operation completes, this value shows the average rate of the entire resize operation.</p>
    ///   - [`total_resize_data_in_mega_bytes(Option<i64>)`](crate::output::CancelResizeOutput::total_resize_data_in_mega_bytes): <p>The estimated total amount of data, in megabytes, on the cluster before the resize operation began.</p>
    ///   - [`progress_in_mega_bytes(Option<i64>)`](crate::output::CancelResizeOutput::progress_in_mega_bytes): <p>While the resize operation is in progress, this value shows the current amount of data, in megabytes, that has been processed so far. When the resize operation is complete, this value shows the total amount of data, in megabytes, on the cluster, which may be more or less than TotalResizeDataInMegaBytes (the estimated total amount of data before resize).</p>
    ///   - [`elapsed_time_in_seconds(Option<i64>)`](crate::output::CancelResizeOutput::elapsed_time_in_seconds): <p>The amount of seconds that have elapsed since the resize operation began. After the resize operation completes, this value shows the total actual time, in seconds, for the resize operation.</p>
    ///   - [`estimated_time_to_completion_in_seconds(Option<i64>)`](crate::output::CancelResizeOutput::estimated_time_to_completion_in_seconds): <p>The estimated time remaining, in seconds, until the resize operation is complete. This value is calculated based on the average resize rate and the estimated amount of data remaining to be processed. Once the resize operation is complete, this value will be 0.</p>
    ///   - [`resize_type(Option<String>)`](crate::output::CancelResizeOutput::resize_type): <p>An enum with possible values of <code>ClassicResize</code> and <code>ElasticResize</code>. These values describe the type of resize operation being performed. </p>
    ///   - [`message(Option<String>)`](crate::output::CancelResizeOutput::message): <p>An optional string to provide additional details about the resize action.</p>
    ///   - [`target_encryption_type(Option<String>)`](crate::output::CancelResizeOutput::target_encryption_type): <p>The type of encryption for the cluster after the resize is complete.</p>  <p>Possible values are <code>KMS</code> and <code>None</code>. </p>
    ///   - [`data_transfer_progress_percent(Option<f64>)`](crate::output::CancelResizeOutput::data_transfer_progress_percent): <p>The percent of data transferred from source cluster to target cluster.</p>
    /// - On failure, responds with [`SdkError<CancelResizeError>`](crate::error::CancelResizeError)
    pub fn cancel_resize(&self) -> fluent_builders::CancelResize {
        fluent_builders::CancelResize::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CopyClusterSnapshot`](crate::client::fluent_builders::CopyClusterSnapshot) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`source_snapshot_identifier(impl Into<String>)`](crate::client::fluent_builders::CopyClusterSnapshot::source_snapshot_identifier) / [`set_source_snapshot_identifier(Option<String>)`](crate::client::fluent_builders::CopyClusterSnapshot::set_source_snapshot_identifier): <p>The identifier for the source snapshot.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must be the identifier for a valid automated snapshot whose state is <code>available</code>.</p> </li>  </ul>
    ///   - [`source_snapshot_cluster_identifier(impl Into<String>)`](crate::client::fluent_builders::CopyClusterSnapshot::source_snapshot_cluster_identifier) / [`set_source_snapshot_cluster_identifier(Option<String>)`](crate::client::fluent_builders::CopyClusterSnapshot::set_source_snapshot_cluster_identifier): <p>The identifier of the cluster the source snapshot was created from. This parameter is required if your IAM user has a policy containing a snapshot resource element that specifies anything other than * for the cluster name.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must be the identifier for a valid cluster.</p> </li>  </ul>
    ///   - [`target_snapshot_identifier(impl Into<String>)`](crate::client::fluent_builders::CopyClusterSnapshot::target_snapshot_identifier) / [`set_target_snapshot_identifier(Option<String>)`](crate::client::fluent_builders::CopyClusterSnapshot::set_target_snapshot_identifier): <p>The identifier given to the new manual snapshot.</p>  <p>Constraints:</p>  <ul>   <li> <p>Cannot be null, empty, or blank.</p> </li>   <li> <p>Must contain from 1 to 255 alphanumeric characters or hyphens.</p> </li>   <li> <p>First character must be a letter.</p> </li>   <li> <p>Cannot end with a hyphen or contain two consecutive hyphens.</p> </li>   <li> <p>Must be unique for the Amazon Web Services account that is making the request.</p> </li>  </ul>
    ///   - [`manual_snapshot_retention_period(i32)`](crate::client::fluent_builders::CopyClusterSnapshot::manual_snapshot_retention_period) / [`set_manual_snapshot_retention_period(Option<i32>)`](crate::client::fluent_builders::CopyClusterSnapshot::set_manual_snapshot_retention_period): <p>The number of days that a manual snapshot is retained. If the value is -1, the manual snapshot is retained indefinitely. </p>  <p>The value must be either -1 or an integer between 1 and 3,653.</p>  <p>The default value is -1.</p>
    /// - On success, responds with [`CopyClusterSnapshotOutput`](crate::output::CopyClusterSnapshotOutput) with field(s):
    ///   - [`snapshot(Option<Snapshot>)`](crate::output::CopyClusterSnapshotOutput::snapshot): <p>Describes a snapshot.</p>
    /// - On failure, responds with [`SdkError<CopyClusterSnapshotError>`](crate::error::CopyClusterSnapshotError)
    pub fn copy_cluster_snapshot(&self) -> fluent_builders::CopyClusterSnapshot {
        fluent_builders::CopyClusterSnapshot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateAuthenticationProfile`](crate::client::fluent_builders::CreateAuthenticationProfile) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`authentication_profile_name(impl Into<String>)`](crate::client::fluent_builders::CreateAuthenticationProfile::authentication_profile_name) / [`set_authentication_profile_name(Option<String>)`](crate::client::fluent_builders::CreateAuthenticationProfile::set_authentication_profile_name): <p>The name of the authentication profile to be created.</p>
    ///   - [`authentication_profile_content(impl Into<String>)`](crate::client::fluent_builders::CreateAuthenticationProfile::authentication_profile_content) / [`set_authentication_profile_content(Option<String>)`](crate::client::fluent_builders::CreateAuthenticationProfile::set_authentication_profile_content): <p>The content of the authentication profile in JSON format. The maximum length of the JSON string is determined by a quota for your account.</p>
    /// - On success, responds with [`CreateAuthenticationProfileOutput`](crate::output::CreateAuthenticationProfileOutput) with field(s):
    ///   - [`authentication_profile_name(Option<String>)`](crate::output::CreateAuthenticationProfileOutput::authentication_profile_name): <p>The name of the authentication profile that was created.</p>
    ///   - [`authentication_profile_content(Option<String>)`](crate::output::CreateAuthenticationProfileOutput::authentication_profile_content): <p>The content of the authentication profile in JSON format.</p>
    /// - On failure, responds with [`SdkError<CreateAuthenticationProfileError>`](crate::error::CreateAuthenticationProfileError)
    pub fn create_authentication_profile(&self) -> fluent_builders::CreateAuthenticationProfile {
        fluent_builders::CreateAuthenticationProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateCluster`](crate::client::fluent_builders::CreateCluster) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_name(impl Into<String>)`](crate::client::fluent_builders::CreateCluster::db_name) / [`set_db_name(Option<String>)`](crate::client::fluent_builders::CreateCluster::set_db_name): <p>The name of the first database to be created when the cluster is created.</p>  <p>To create additional databases after the cluster is created, connect to the cluster with a SQL client and use SQL commands to create a database. For more information, go to <a href="https://docs.aws.amazon.com/redshift/latest/dg/t_creating_database.html">Create a Database</a> in the Amazon Redshift Database Developer Guide. </p>  <p>Default: <code>dev</code> </p>  <p>Constraints:</p>  <ul>   <li> <p>Must contain 1 to 64 alphanumeric characters.</p> </li>   <li> <p>Must contain only lowercase letters.</p> </li>   <li> <p>Cannot be a word that is reserved by the service. A list of reserved words can be found in <a href="https://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html">Reserved Words</a> in the Amazon Redshift Database Developer Guide. </p> </li>  </ul>
    ///   - [`cluster_identifier(impl Into<String>)`](crate::client::fluent_builders::CreateCluster::cluster_identifier) / [`set_cluster_identifier(Option<String>)`](crate::client::fluent_builders::CreateCluster::set_cluster_identifier): <p>A unique identifier for the cluster. You use this identifier to refer to the cluster for any subsequent cluster operations such as deleting or modifying. The identifier also appears in the Amazon Redshift console.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must contain from 1 to 63 alphanumeric characters or hyphens.</p> </li>   <li> <p>Alphabetic characters must be lowercase.</p> </li>   <li> <p>First character must be a letter.</p> </li>   <li> <p>Cannot end with a hyphen or contain two consecutive hyphens.</p> </li>   <li> <p>Must be unique for all clusters within an Amazon Web Services account.</p> </li>  </ul>  <p>Example: <code>myexamplecluster</code> </p>
    ///   - [`cluster_type(impl Into<String>)`](crate::client::fluent_builders::CreateCluster::cluster_type) / [`set_cluster_type(Option<String>)`](crate::client::fluent_builders::CreateCluster::set_cluster_type): <p>The type of the cluster. When cluster type is specified as</p>  <ul>   <li> <p> <code>single-node</code>, the <b>NumberOfNodes</b> parameter is not required.</p> </li>   <li> <p> <code>multi-node</code>, the <b>NumberOfNodes</b> parameter is required.</p> </li>  </ul>  <p>Valid Values: <code>multi-node</code> | <code>single-node</code> </p>  <p>Default: <code>multi-node</code> </p>
    ///   - [`node_type(impl Into<String>)`](crate::client::fluent_builders::CreateCluster::node_type) / [`set_node_type(Option<String>)`](crate::client::fluent_builders::CreateCluster::set_node_type): <p>The node type to be provisioned for the cluster. For information about node types, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#how-many-nodes"> Working with Clusters</a> in the <i>Amazon Redshift Cluster Management Guide</i>. </p>  <p>Valid Values: <code>ds2.xlarge</code> | <code>ds2.8xlarge</code> | <code>dc1.large</code> | <code>dc1.8xlarge</code> | <code>dc2.large</code> | <code>dc2.8xlarge</code> | <code>ra3.xlplus</code> | <code>ra3.4xlarge</code> | <code>ra3.16xlarge</code> </p>
    ///   - [`master_username(impl Into<String>)`](crate::client::fluent_builders::CreateCluster::master_username) / [`set_master_username(Option<String>)`](crate::client::fluent_builders::CreateCluster::set_master_username): <p>The user name associated with the admin user account for the cluster that is being created.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must be 1 - 128 alphanumeric characters. The user name can't be <code>PUBLIC</code>.</p> </li>   <li> <p>First character must be a letter.</p> </li>   <li> <p>Cannot be a reserved word. A list of reserved words can be found in <a href="https://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html">Reserved Words</a> in the Amazon Redshift Database Developer Guide. </p> </li>  </ul>
    ///   - [`master_user_password(impl Into<String>)`](crate::client::fluent_builders::CreateCluster::master_user_password) / [`set_master_user_password(Option<String>)`](crate::client::fluent_builders::CreateCluster::set_master_user_password): <p>The password associated with the admin user account for the cluster that is being created.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must be between 8 and 64 characters in length.</p> </li>   <li> <p>Must contain at least one uppercase letter.</p> </li>   <li> <p>Must contain at least one lowercase letter.</p> </li>   <li> <p>Must contain one number.</p> </li>   <li> <p>Can be any printable ASCII character (ASCII code 33-126) except ' (single quote), " (double quote), \, /, or @.</p> </li>  </ul>
    ///   - [`cluster_security_groups(Vec<String>)`](crate::client::fluent_builders::CreateCluster::cluster_security_groups) / [`set_cluster_security_groups(Option<Vec<String>>)`](crate::client::fluent_builders::CreateCluster::set_cluster_security_groups): <p>A list of security groups to be associated with this cluster.</p>  <p>Default: The default cluster security group for Amazon Redshift.</p>
    ///   - [`vpc_security_group_ids(Vec<String>)`](crate::client::fluent_builders::CreateCluster::vpc_security_group_ids) / [`set_vpc_security_group_ids(Option<Vec<String>>)`](crate::client::fluent_builders::CreateCluster::set_vpc_security_group_ids): <p>A list of Virtual Private Cloud (VPC) security groups to be associated with the cluster.</p>  <p>Default: The default VPC security group is associated with the cluster.</p>
    ///   - [`cluster_subnet_group_name(impl Into<String>)`](crate::client::fluent_builders::CreateCluster::cluster_subnet_group_name) / [`set_cluster_subnet_group_name(Option<String>)`](crate::client::fluent_builders::CreateCluster::set_cluster_subnet_group_name): <p>The name of a cluster subnet group to be associated with this cluster.</p>  <p>If this parameter is not provided the resulting cluster will be deployed outside virtual private cloud (VPC).</p>
    ///   - [`availability_zone(impl Into<String>)`](crate::client::fluent_builders::CreateCluster::availability_zone) / [`set_availability_zone(Option<String>)`](crate::client::fluent_builders::CreateCluster::set_availability_zone): <p>The EC2 Availability Zone (AZ) in which you want Amazon Redshift to provision the cluster. For example, if you have several EC2 instances running in a specific Availability Zone, then you might want the cluster to be provisioned in the same zone in order to decrease network latency.</p>  <p>Default: A random, system-chosen Availability Zone in the region that is specified by the endpoint.</p>  <p>Example: <code>us-east-2d</code> </p>  <p>Constraint: The specified Availability Zone must be in the same region as the current endpoint.</p>
    ///   - [`preferred_maintenance_window(impl Into<String>)`](crate::client::fluent_builders::CreateCluster::preferred_maintenance_window) / [`set_preferred_maintenance_window(Option<String>)`](crate::client::fluent_builders::CreateCluster::set_preferred_maintenance_window): <p>The weekly time range (in UTC) during which automated cluster maintenance can occur.</p>  <p> Format: <code>ddd:hh24:mi-ddd:hh24:mi</code> </p>  <p> Default: A 30-minute window selected at random from an 8-hour block of time per region, occurring on a random day of the week. For more information about the time blocks for each region, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#rs-maintenance-windows">Maintenance Windows</a> in Amazon Redshift Cluster Management Guide.</p>  <p>Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun</p>  <p>Constraints: Minimum 30-minute window.</p>
    ///   - [`cluster_parameter_group_name(impl Into<String>)`](crate::client::fluent_builders::CreateCluster::cluster_parameter_group_name) / [`set_cluster_parameter_group_name(Option<String>)`](crate::client::fluent_builders::CreateCluster::set_cluster_parameter_group_name): <p>The name of the parameter group to be associated with this cluster.</p>  <p>Default: The default Amazon Redshift cluster parameter group. For information about the default parameter group, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Working with Amazon Redshift Parameter Groups</a> </p>  <p>Constraints:</p>  <ul>   <li> <p>Must be 1 to 255 alphanumeric characters or hyphens.</p> </li>   <li> <p>First character must be a letter.</p> </li>   <li> <p>Cannot end with a hyphen or contain two consecutive hyphens.</p> </li>  </ul>
    ///   - [`automated_snapshot_retention_period(i32)`](crate::client::fluent_builders::CreateCluster::automated_snapshot_retention_period) / [`set_automated_snapshot_retention_period(Option<i32>)`](crate::client::fluent_builders::CreateCluster::set_automated_snapshot_retention_period): <p>The number of days that automated snapshots are retained. If the value is 0, automated snapshots are disabled. Even if automated snapshots are disabled, you can still create manual snapshots when you want with <code>CreateClusterSnapshot</code>. </p>  <p>You can't disable automated snapshots for RA3 node types. Set the automated retention period from 1-35 days.</p>  <p>Default: <code>1</code> </p>  <p>Constraints: Must be a value from 0 to 35.</p>
    ///   - [`manual_snapshot_retention_period(i32)`](crate::client::fluent_builders::CreateCluster::manual_snapshot_retention_period) / [`set_manual_snapshot_retention_period(Option<i32>)`](crate::client::fluent_builders::CreateCluster::set_manual_snapshot_retention_period): <p>The default number of days to retain a manual snapshot. If the value is -1, the snapshot is retained indefinitely. This setting doesn't change the retention period of existing snapshots.</p>  <p>The value must be either -1 or an integer between 1 and 3,653.</p>
    ///   - [`port(i32)`](crate::client::fluent_builders::CreateCluster::port) / [`set_port(Option<i32>)`](crate::client::fluent_builders::CreateCluster::set_port): <p>The port number on which the cluster accepts incoming connections.</p>  <p>The cluster is accessible only via the JDBC and ODBC connection strings. Part of the connection string requires the port on which the cluster will listen for incoming connections.</p>  <p>Default: <code>5439</code> </p>  <p>Valid Values: <code>1150-65535</code> </p>
    ///   - [`cluster_version(impl Into<String>)`](crate::client::fluent_builders::CreateCluster::cluster_version) / [`set_cluster_version(Option<String>)`](crate::client::fluent_builders::CreateCluster::set_cluster_version): <p>The version of the Amazon Redshift engine software that you want to deploy on the cluster.</p>  <p>The version selected runs on all the nodes in the cluster.</p>  <p>Constraints: Only version 1.0 is currently available.</p>  <p>Example: <code>1.0</code> </p>
    ///   - [`allow_version_upgrade(bool)`](crate::client::fluent_builders::CreateCluster::allow_version_upgrade) / [`set_allow_version_upgrade(Option<bool>)`](crate::client::fluent_builders::CreateCluster::set_allow_version_upgrade): <p>If <code>true</code>, major version upgrades can be applied during the maintenance window to the Amazon Redshift engine that is running on the cluster.</p>  <p>When a new major version of the Amazon Redshift engine is released, you can request that the service automatically apply upgrades during the maintenance window to the Amazon Redshift engine that is running on your cluster.</p>  <p>Default: <code>true</code> </p>
    ///   - [`number_of_nodes(i32)`](crate::client::fluent_builders::CreateCluster::number_of_nodes) / [`set_number_of_nodes(Option<i32>)`](crate::client::fluent_builders::CreateCluster::set_number_of_nodes): <p>The number of compute nodes in the cluster. This parameter is required when the <b>ClusterType</b> parameter is specified as <code>multi-node</code>. </p>  <p>For information about determining how many nodes you need, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#how-many-nodes"> Working with Clusters</a> in the <i>Amazon Redshift Cluster Management Guide</i>. </p>  <p>If you don't specify this parameter, you get a single-node cluster. When requesting a multi-node cluster, you must specify the number of nodes that you want in the cluster.</p>  <p>Default: <code>1</code> </p>  <p>Constraints: Value must be at least 1 and no more than 100.</p>
    ///   - [`publicly_accessible(bool)`](crate::client::fluent_builders::CreateCluster::publicly_accessible) / [`set_publicly_accessible(Option<bool>)`](crate::client::fluent_builders::CreateCluster::set_publicly_accessible): <p>If <code>true</code>, the cluster can be accessed from a public network. </p>
    ///   - [`encrypted(bool)`](crate::client::fluent_builders::CreateCluster::encrypted) / [`set_encrypted(Option<bool>)`](crate::client::fluent_builders::CreateCluster::set_encrypted): <p>If <code>true</code>, the data in the cluster is encrypted at rest. </p>  <p>Default: false</p>
    ///   - [`hsm_client_certificate_identifier(impl Into<String>)`](crate::client::fluent_builders::CreateCluster::hsm_client_certificate_identifier) / [`set_hsm_client_certificate_identifier(Option<String>)`](crate::client::fluent_builders::CreateCluster::set_hsm_client_certificate_identifier): <p>Specifies the name of the HSM client certificate the Amazon Redshift cluster uses to retrieve the data encryption keys stored in an HSM.</p>
    ///   - [`hsm_configuration_identifier(impl Into<String>)`](crate::client::fluent_builders::CreateCluster::hsm_configuration_identifier) / [`set_hsm_configuration_identifier(Option<String>)`](crate::client::fluent_builders::CreateCluster::set_hsm_configuration_identifier): <p>Specifies the name of the HSM configuration that contains the information the Amazon Redshift cluster can use to retrieve and store keys in an HSM.</p>
    ///   - [`elastic_ip(impl Into<String>)`](crate::client::fluent_builders::CreateCluster::elastic_ip) / [`set_elastic_ip(Option<String>)`](crate::client::fluent_builders::CreateCluster::set_elastic_ip): <p>The Elastic IP (EIP) address for the cluster.</p>  <p>Constraints: The cluster must be provisioned in EC2-VPC and publicly-accessible through an Internet gateway. For more information about provisioning clusters in EC2-VPC, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#cluster-platforms">Supported Platforms to Launch Your Cluster</a> in the Amazon Redshift Cluster Management Guide.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateCluster::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateCluster::set_tags): <p>A list of tag instances.</p>
    ///   - [`kms_key_id(impl Into<String>)`](crate::client::fluent_builders::CreateCluster::kms_key_id) / [`set_kms_key_id(Option<String>)`](crate::client::fluent_builders::CreateCluster::set_kms_key_id): <p>The Key Management Service (KMS) key ID of the encryption key that you want to use to encrypt data in the cluster.</p>
    ///   - [`enhanced_vpc_routing(bool)`](crate::client::fluent_builders::CreateCluster::enhanced_vpc_routing) / [`set_enhanced_vpc_routing(Option<bool>)`](crate::client::fluent_builders::CreateCluster::set_enhanced_vpc_routing): <p>An option that specifies whether to create the cluster with enhanced VPC routing enabled. To create a cluster that uses enhanced VPC routing, the cluster must be in a VPC. For more information, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html">Enhanced VPC Routing</a> in the Amazon Redshift Cluster Management Guide.</p>  <p>If this option is <code>true</code>, enhanced VPC routing is enabled. </p>  <p>Default: false</p>
    ///   - [`additional_info(impl Into<String>)`](crate::client::fluent_builders::CreateCluster::additional_info) / [`set_additional_info(Option<String>)`](crate::client::fluent_builders::CreateCluster::set_additional_info): <p>Reserved.</p>
    ///   - [`iam_roles(Vec<String>)`](crate::client::fluent_builders::CreateCluster::iam_roles) / [`set_iam_roles(Option<Vec<String>>)`](crate::client::fluent_builders::CreateCluster::set_iam_roles): <p>A list of Identity and Access Management (IAM) roles that can be used by the cluster to access other Amazon Web Services services. You must supply the IAM roles in their Amazon Resource Name (ARN) format. </p>  <p>The maximum number of IAM roles that you can associate is subject to a quota. For more information, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Quotas and limits</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</p>
    ///   - [`maintenance_track_name(impl Into<String>)`](crate::client::fluent_builders::CreateCluster::maintenance_track_name) / [`set_maintenance_track_name(Option<String>)`](crate::client::fluent_builders::CreateCluster::set_maintenance_track_name): <p>An optional parameter for the name of the maintenance track for the cluster. If you don't provide a maintenance track name, the cluster is assigned to the <code>current</code> track.</p>
    ///   - [`snapshot_schedule_identifier(impl Into<String>)`](crate::client::fluent_builders::CreateCluster::snapshot_schedule_identifier) / [`set_snapshot_schedule_identifier(Option<String>)`](crate::client::fluent_builders::CreateCluster::set_snapshot_schedule_identifier): <p>A unique identifier for the snapshot schedule.</p>
    ///   - [`availability_zone_relocation(bool)`](crate::client::fluent_builders::CreateCluster::availability_zone_relocation) / [`set_availability_zone_relocation(Option<bool>)`](crate::client::fluent_builders::CreateCluster::set_availability_zone_relocation): <p>The option to enable relocation for an Amazon Redshift cluster between Availability Zones after the cluster is created.</p>
    ///   - [`aqua_configuration_status(AquaConfigurationStatus)`](crate::client::fluent_builders::CreateCluster::aqua_configuration_status) / [`set_aqua_configuration_status(Option<AquaConfigurationStatus>)`](crate::client::fluent_builders::CreateCluster::set_aqua_configuration_status): <p>The value represents how the cluster is configured to use AQUA (Advanced Query Accelerator) when it is created. Possible values include the following.</p>  <ul>   <li> <p>enabled - Use AQUA if it is available for the current Amazon Web Services Region and Amazon Redshift node type.</p> </li>   <li> <p>disabled - Don't use AQUA. </p> </li>   <li> <p>auto - Amazon Redshift determines whether to use AQUA.</p> </li>  </ul>
    ///   - [`default_iam_role_arn(impl Into<String>)`](crate::client::fluent_builders::CreateCluster::default_iam_role_arn) / [`set_default_iam_role_arn(Option<String>)`](crate::client::fluent_builders::CreateCluster::set_default_iam_role_arn): <p>The Amazon Resource Name (ARN) for the IAM role that was set as default for the cluster when the cluster was created. </p>
    /// - On success, responds with [`CreateClusterOutput`](crate::output::CreateClusterOutput) with field(s):
    ///   - [`cluster(Option<Cluster>)`](crate::output::CreateClusterOutput::cluster): <p>Describes a cluster.</p>
    /// - On failure, responds with [`SdkError<CreateClusterError>`](crate::error::CreateClusterError)
    pub fn create_cluster(&self) -> fluent_builders::CreateCluster {
        fluent_builders::CreateCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateClusterParameterGroup`](crate::client::fluent_builders::CreateClusterParameterGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`parameter_group_name(impl Into<String>)`](crate::client::fluent_builders::CreateClusterParameterGroup::parameter_group_name) / [`set_parameter_group_name(Option<String>)`](crate::client::fluent_builders::CreateClusterParameterGroup::set_parameter_group_name): <p>The name of the cluster parameter group.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must be 1 to 255 alphanumeric characters or hyphens</p> </li>   <li> <p>First character must be a letter.</p> </li>   <li> <p>Cannot end with a hyphen or contain two consecutive hyphens.</p> </li>   <li> <p>Must be unique withing your Amazon Web Services account.</p> </li>  </ul> <note>   <p>This value is stored as a lower-case string.</p>  </note>
    ///   - [`parameter_group_family(impl Into<String>)`](crate::client::fluent_builders::CreateClusterParameterGroup::parameter_group_family) / [`set_parameter_group_family(Option<String>)`](crate::client::fluent_builders::CreateClusterParameterGroup::set_parameter_group_family): <p>The Amazon Redshift engine version to which the cluster parameter group applies. The cluster engine version determines the set of parameters.</p>  <p>To get a list of valid parameter group family names, you can call <code>DescribeClusterParameterGroups</code>. By default, Amazon Redshift returns a list of all the parameter groups that are owned by your Amazon Web Services account, including the default parameter groups for each Amazon Redshift engine version. The parameter group family names associated with the default parameter groups provide you the valid values. For example, a valid family name is "redshift-1.0". </p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateClusterParameterGroup::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateClusterParameterGroup::set_description): <p>A description of the parameter group.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateClusterParameterGroup::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateClusterParameterGroup::set_tags): <p>A list of tag instances.</p>
    /// - On success, responds with [`CreateClusterParameterGroupOutput`](crate::output::CreateClusterParameterGroupOutput) with field(s):
    ///   - [`cluster_parameter_group(Option<ClusterParameterGroup>)`](crate::output::CreateClusterParameterGroupOutput::cluster_parameter_group): <p>Describes a parameter group.</p>
    /// - On failure, responds with [`SdkError<CreateClusterParameterGroupError>`](crate::error::CreateClusterParameterGroupError)
    pub fn create_cluster_parameter_group(&self) -> fluent_builders::CreateClusterParameterGroup {
        fluent_builders::CreateClusterParameterGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateClusterSecurityGroup`](crate::client::fluent_builders::CreateClusterSecurityGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster_security_group_name(impl Into<String>)`](crate::client::fluent_builders::CreateClusterSecurityGroup::cluster_security_group_name) / [`set_cluster_security_group_name(Option<String>)`](crate::client::fluent_builders::CreateClusterSecurityGroup::set_cluster_security_group_name): <p>The name for the security group. Amazon Redshift stores the value as a lowercase string.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must contain no more than 255 alphanumeric characters or hyphens.</p> </li>   <li> <p>Must not be "Default".</p> </li>   <li> <p>Must be unique for all security groups that are created by your Amazon Web Services account.</p> </li>  </ul>  <p>Example: <code>examplesecuritygroup</code> </p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateClusterSecurityGroup::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateClusterSecurityGroup::set_description): <p>A description for the security group.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateClusterSecurityGroup::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateClusterSecurityGroup::set_tags): <p>A list of tag instances.</p>
    /// - On success, responds with [`CreateClusterSecurityGroupOutput`](crate::output::CreateClusterSecurityGroupOutput) with field(s):
    ///   - [`cluster_security_group(Option<ClusterSecurityGroup>)`](crate::output::CreateClusterSecurityGroupOutput::cluster_security_group): <p>Describes a security group.</p>
    /// - On failure, responds with [`SdkError<CreateClusterSecurityGroupError>`](crate::error::CreateClusterSecurityGroupError)
    pub fn create_cluster_security_group(&self) -> fluent_builders::CreateClusterSecurityGroup {
        fluent_builders::CreateClusterSecurityGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateClusterSnapshot`](crate::client::fluent_builders::CreateClusterSnapshot) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`snapshot_identifier(impl Into<String>)`](crate::client::fluent_builders::CreateClusterSnapshot::snapshot_identifier) / [`set_snapshot_identifier(Option<String>)`](crate::client::fluent_builders::CreateClusterSnapshot::set_snapshot_identifier): <p>A unique identifier for the snapshot that you are requesting. This identifier must be unique for all snapshots within the Amazon Web Services account.</p>  <p>Constraints:</p>  <ul>   <li> <p>Cannot be null, empty, or blank</p> </li>   <li> <p>Must contain from 1 to 255 alphanumeric characters or hyphens</p> </li>   <li> <p>First character must be a letter</p> </li>   <li> <p>Cannot end with a hyphen or contain two consecutive hyphens</p> </li>  </ul>  <p>Example: <code>my-snapshot-id</code> </p>
    ///   - [`cluster_identifier(impl Into<String>)`](crate::client::fluent_builders::CreateClusterSnapshot::cluster_identifier) / [`set_cluster_identifier(Option<String>)`](crate::client::fluent_builders::CreateClusterSnapshot::set_cluster_identifier): <p>The cluster identifier for which you want a snapshot.</p>
    ///   - [`manual_snapshot_retention_period(i32)`](crate::client::fluent_builders::CreateClusterSnapshot::manual_snapshot_retention_period) / [`set_manual_snapshot_retention_period(Option<i32>)`](crate::client::fluent_builders::CreateClusterSnapshot::set_manual_snapshot_retention_period): <p>The number of days that a manual snapshot is retained. If the value is -1, the manual snapshot is retained indefinitely. </p>  <p>The value must be either -1 or an integer between 1 and 3,653.</p>  <p>The default value is -1.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateClusterSnapshot::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateClusterSnapshot::set_tags): <p>A list of tag instances.</p>
    /// - On success, responds with [`CreateClusterSnapshotOutput`](crate::output::CreateClusterSnapshotOutput) with field(s):
    ///   - [`snapshot(Option<Snapshot>)`](crate::output::CreateClusterSnapshotOutput::snapshot): <p>Describes a snapshot.</p>
    /// - On failure, responds with [`SdkError<CreateClusterSnapshotError>`](crate::error::CreateClusterSnapshotError)
    pub fn create_cluster_snapshot(&self) -> fluent_builders::CreateClusterSnapshot {
        fluent_builders::CreateClusterSnapshot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateClusterSubnetGroup`](crate::client::fluent_builders::CreateClusterSubnetGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster_subnet_group_name(impl Into<String>)`](crate::client::fluent_builders::CreateClusterSubnetGroup::cluster_subnet_group_name) / [`set_cluster_subnet_group_name(Option<String>)`](crate::client::fluent_builders::CreateClusterSubnetGroup::set_cluster_subnet_group_name): <p>The name for the subnet group. Amazon Redshift stores the value as a lowercase string.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must contain no more than 255 alphanumeric characters or hyphens.</p> </li>   <li> <p>Must not be "Default".</p> </li>   <li> <p>Must be unique for all subnet groups that are created by your Amazon Web Services account.</p> </li>  </ul>  <p>Example: <code>examplesubnetgroup</code> </p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateClusterSubnetGroup::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateClusterSubnetGroup::set_description): <p>A description for the subnet group.</p>
    ///   - [`subnet_ids(Vec<String>)`](crate::client::fluent_builders::CreateClusterSubnetGroup::subnet_ids) / [`set_subnet_ids(Option<Vec<String>>)`](crate::client::fluent_builders::CreateClusterSubnetGroup::set_subnet_ids): <p>An array of VPC subnet IDs. A maximum of 20 subnets can be modified in a single request.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateClusterSubnetGroup::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateClusterSubnetGroup::set_tags): <p>A list of tag instances.</p>
    /// - On success, responds with [`CreateClusterSubnetGroupOutput`](crate::output::CreateClusterSubnetGroupOutput) with field(s):
    ///   - [`cluster_subnet_group(Option<ClusterSubnetGroup>)`](crate::output::CreateClusterSubnetGroupOutput::cluster_subnet_group): <p>Describes a subnet group.</p>
    /// - On failure, responds with [`SdkError<CreateClusterSubnetGroupError>`](crate::error::CreateClusterSubnetGroupError)
    pub fn create_cluster_subnet_group(&self) -> fluent_builders::CreateClusterSubnetGroup {
        fluent_builders::CreateClusterSubnetGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateEndpointAccess`](crate::client::fluent_builders::CreateEndpointAccess) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster_identifier(impl Into<String>)`](crate::client::fluent_builders::CreateEndpointAccess::cluster_identifier) / [`set_cluster_identifier(Option<String>)`](crate::client::fluent_builders::CreateEndpointAccess::set_cluster_identifier): <p>The cluster identifier of the cluster to access.</p>
    ///   - [`resource_owner(impl Into<String>)`](crate::client::fluent_builders::CreateEndpointAccess::resource_owner) / [`set_resource_owner(Option<String>)`](crate::client::fluent_builders::CreateEndpointAccess::set_resource_owner): <p>The Amazon Web Services account ID of the owner of the cluster. This is only required if the cluster is in another Amazon Web Services account.</p>
    ///   - [`endpoint_name(impl Into<String>)`](crate::client::fluent_builders::CreateEndpointAccess::endpoint_name) / [`set_endpoint_name(Option<String>)`](crate::client::fluent_builders::CreateEndpointAccess::set_endpoint_name): <p>The Redshift-managed VPC endpoint name.</p>  <p>An endpoint name must contain 1-30 characters. Valid characters are A-Z, a-z, 0-9, and hyphen(-). The first character must be a letter. The name can't contain two consecutive hyphens or end with a hyphen.</p>
    ///   - [`subnet_group_name(impl Into<String>)`](crate::client::fluent_builders::CreateEndpointAccess::subnet_group_name) / [`set_subnet_group_name(Option<String>)`](crate::client::fluent_builders::CreateEndpointAccess::set_subnet_group_name): <p>The subnet group from which Amazon Redshift chooses the subnet to deploy the endpoint.</p>
    ///   - [`vpc_security_group_ids(Vec<String>)`](crate::client::fluent_builders::CreateEndpointAccess::vpc_security_group_ids) / [`set_vpc_security_group_ids(Option<Vec<String>>)`](crate::client::fluent_builders::CreateEndpointAccess::set_vpc_security_group_ids): <p>The security group that defines the ports, protocols, and sources for inbound traffic that you are authorizing into your endpoint.</p>
    /// - On success, responds with [`CreateEndpointAccessOutput`](crate::output::CreateEndpointAccessOutput) with field(s):
    ///   - [`cluster_identifier(Option<String>)`](crate::output::CreateEndpointAccessOutput::cluster_identifier): <p>The cluster identifier of the cluster associated with the endpoint.</p>
    ///   - [`resource_owner(Option<String>)`](crate::output::CreateEndpointAccessOutput::resource_owner): <p>The Amazon Web Services account ID of the owner of the cluster.</p>
    ///   - [`subnet_group_name(Option<String>)`](crate::output::CreateEndpointAccessOutput::subnet_group_name): <p>The subnet group name where Amazon Redshift chooses to deploy the endpoint.</p>
    ///   - [`endpoint_status(Option<String>)`](crate::output::CreateEndpointAccessOutput::endpoint_status): <p>The status of the endpoint.</p>
    ///   - [`endpoint_name(Option<String>)`](crate::output::CreateEndpointAccessOutput::endpoint_name): <p>The name of the endpoint.</p>
    ///   - [`endpoint_create_time(Option<DateTime>)`](crate::output::CreateEndpointAccessOutput::endpoint_create_time): <p>The time (UTC) that the endpoint was created.</p>
    ///   - [`port(i32)`](crate::output::CreateEndpointAccessOutput::port): <p>The port number on which the cluster accepts incoming connections.</p>
    ///   - [`address(Option<String>)`](crate::output::CreateEndpointAccessOutput::address): <p>The DNS address of the endpoint.</p>
    ///   - [`vpc_security_groups(Option<Vec<VpcSecurityGroupMembership>>)`](crate::output::CreateEndpointAccessOutput::vpc_security_groups): <p>The security groups associated with the endpoint.</p>
    ///   - [`vpc_endpoint(Option<VpcEndpoint>)`](crate::output::CreateEndpointAccessOutput::vpc_endpoint): <p>The connection endpoint for connecting to an Amazon Redshift cluster through the proxy.</p>
    /// - On failure, responds with [`SdkError<CreateEndpointAccessError>`](crate::error::CreateEndpointAccessError)
    pub fn create_endpoint_access(&self) -> fluent_builders::CreateEndpointAccess {
        fluent_builders::CreateEndpointAccess::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateEventSubscription`](crate::client::fluent_builders::CreateEventSubscription) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`subscription_name(impl Into<String>)`](crate::client::fluent_builders::CreateEventSubscription::subscription_name) / [`set_subscription_name(Option<String>)`](crate::client::fluent_builders::CreateEventSubscription::set_subscription_name): <p>The name of the event subscription to be created.</p>  <p>Constraints:</p>  <ul>   <li> <p>Cannot be null, empty, or blank.</p> </li>   <li> <p>Must contain from 1 to 255 alphanumeric characters or hyphens.</p> </li>   <li> <p>First character must be a letter.</p> </li>   <li> <p>Cannot end with a hyphen or contain two consecutive hyphens.</p> </li>  </ul>
    ///   - [`sns_topic_arn(impl Into<String>)`](crate::client::fluent_builders::CreateEventSubscription::sns_topic_arn) / [`set_sns_topic_arn(Option<String>)`](crate::client::fluent_builders::CreateEventSubscription::set_sns_topic_arn): <p>The Amazon Resource Name (ARN) of the Amazon SNS topic used to transmit the event notifications. The ARN is created by Amazon SNS when you create a topic and subscribe to it.</p>
    ///   - [`source_type(impl Into<String>)`](crate::client::fluent_builders::CreateEventSubscription::source_type) / [`set_source_type(Option<String>)`](crate::client::fluent_builders::CreateEventSubscription::set_source_type): <p>The type of source that will be generating the events. For example, if you want to be notified of events generated by a cluster, you would set this parameter to cluster. If this value is not specified, events are returned for all Amazon Redshift objects in your Amazon Web Services account. You must specify a source type in order to specify source IDs.</p>  <p>Valid values: cluster, cluster-parameter-group, cluster-security-group, cluster-snapshot, and scheduled-action.</p>
    ///   - [`source_ids(Vec<String>)`](crate::client::fluent_builders::CreateEventSubscription::source_ids) / [`set_source_ids(Option<Vec<String>>)`](crate::client::fluent_builders::CreateEventSubscription::set_source_ids): <p>A list of one or more identifiers of Amazon Redshift source objects. All of the objects must be of the same type as was specified in the source type parameter. The event subscription will return only events generated by the specified objects. If not specified, then events are returned for all objects within the source type specified.</p>  <p>Example: my-cluster-1, my-cluster-2</p>  <p>Example: my-snapshot-20131010</p>
    ///   - [`event_categories(Vec<String>)`](crate::client::fluent_builders::CreateEventSubscription::event_categories) / [`set_event_categories(Option<Vec<String>>)`](crate::client::fluent_builders::CreateEventSubscription::set_event_categories): <p>Specifies the Amazon Redshift event categories to be published by the event notification subscription.</p>  <p>Values: configuration, management, monitoring, security, pending</p>
    ///   - [`severity(impl Into<String>)`](crate::client::fluent_builders::CreateEventSubscription::severity) / [`set_severity(Option<String>)`](crate::client::fluent_builders::CreateEventSubscription::set_severity): <p>Specifies the Amazon Redshift event severity to be published by the event notification subscription.</p>  <p>Values: ERROR, INFO</p>
    ///   - [`enabled(bool)`](crate::client::fluent_builders::CreateEventSubscription::enabled) / [`set_enabled(Option<bool>)`](crate::client::fluent_builders::CreateEventSubscription::set_enabled): <p>A boolean value; set to <code>true</code> to activate the subscription, and set to <code>false</code> to create the subscription but not activate it. </p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateEventSubscription::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateEventSubscription::set_tags): <p>A list of tag instances.</p>
    /// - On success, responds with [`CreateEventSubscriptionOutput`](crate::output::CreateEventSubscriptionOutput) with field(s):
    ///   - [`event_subscription(Option<EventSubscription>)`](crate::output::CreateEventSubscriptionOutput::event_subscription): <p>Describes event subscriptions.</p>
    /// - On failure, responds with [`SdkError<CreateEventSubscriptionError>`](crate::error::CreateEventSubscriptionError)
    pub fn create_event_subscription(&self) -> fluent_builders::CreateEventSubscription {
        fluent_builders::CreateEventSubscription::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateHsmClientCertificate`](crate::client::fluent_builders::CreateHsmClientCertificate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`hsm_client_certificate_identifier(impl Into<String>)`](crate::client::fluent_builders::CreateHsmClientCertificate::hsm_client_certificate_identifier) / [`set_hsm_client_certificate_identifier(Option<String>)`](crate::client::fluent_builders::CreateHsmClientCertificate::set_hsm_client_certificate_identifier): <p>The identifier to be assigned to the new HSM client certificate that the cluster will use to connect to the HSM to use the database encryption keys.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateHsmClientCertificate::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateHsmClientCertificate::set_tags): <p>A list of tag instances.</p>
    /// - On success, responds with [`CreateHsmClientCertificateOutput`](crate::output::CreateHsmClientCertificateOutput) with field(s):
    ///   - [`hsm_client_certificate(Option<HsmClientCertificate>)`](crate::output::CreateHsmClientCertificateOutput::hsm_client_certificate): <p>Returns information about an HSM client certificate. The certificate is stored in a secure Hardware Storage Module (HSM), and used by the Amazon Redshift cluster to encrypt data files.</p>
    /// - On failure, responds with [`SdkError<CreateHsmClientCertificateError>`](crate::error::CreateHsmClientCertificateError)
    pub fn create_hsm_client_certificate(&self) -> fluent_builders::CreateHsmClientCertificate {
        fluent_builders::CreateHsmClientCertificate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateHsmConfiguration`](crate::client::fluent_builders::CreateHsmConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`hsm_configuration_identifier(impl Into<String>)`](crate::client::fluent_builders::CreateHsmConfiguration::hsm_configuration_identifier) / [`set_hsm_configuration_identifier(Option<String>)`](crate::client::fluent_builders::CreateHsmConfiguration::set_hsm_configuration_identifier): <p>The identifier to be assigned to the new Amazon Redshift HSM configuration.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateHsmConfiguration::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateHsmConfiguration::set_description): <p>A text description of the HSM configuration to be created.</p>
    ///   - [`hsm_ip_address(impl Into<String>)`](crate::client::fluent_builders::CreateHsmConfiguration::hsm_ip_address) / [`set_hsm_ip_address(Option<String>)`](crate::client::fluent_builders::CreateHsmConfiguration::set_hsm_ip_address): <p>The IP address that the Amazon Redshift cluster must use to access the HSM.</p>
    ///   - [`hsm_partition_name(impl Into<String>)`](crate::client::fluent_builders::CreateHsmConfiguration::hsm_partition_name) / [`set_hsm_partition_name(Option<String>)`](crate::client::fluent_builders::CreateHsmConfiguration::set_hsm_partition_name): <p>The name of the partition in the HSM where the Amazon Redshift clusters will store their database encryption keys.</p>
    ///   - [`hsm_partition_password(impl Into<String>)`](crate::client::fluent_builders::CreateHsmConfiguration::hsm_partition_password) / [`set_hsm_partition_password(Option<String>)`](crate::client::fluent_builders::CreateHsmConfiguration::set_hsm_partition_password): <p>The password required to access the HSM partition.</p>
    ///   - [`hsm_server_public_certificate(impl Into<String>)`](crate::client::fluent_builders::CreateHsmConfiguration::hsm_server_public_certificate) / [`set_hsm_server_public_certificate(Option<String>)`](crate::client::fluent_builders::CreateHsmConfiguration::set_hsm_server_public_certificate): <p>The HSMs public certificate file. When using Cloud HSM, the file name is server.pem.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateHsmConfiguration::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateHsmConfiguration::set_tags): <p>A list of tag instances.</p>
    /// - On success, responds with [`CreateHsmConfigurationOutput`](crate::output::CreateHsmConfigurationOutput) with field(s):
    ///   - [`hsm_configuration(Option<HsmConfiguration>)`](crate::output::CreateHsmConfigurationOutput::hsm_configuration): <p>Returns information about an HSM configuration, which is an object that describes to Amazon Redshift clusters the information they require to connect to an HSM where they can store database encryption keys.</p>
    /// - On failure, responds with [`SdkError<CreateHsmConfigurationError>`](crate::error::CreateHsmConfigurationError)
    pub fn create_hsm_configuration(&self) -> fluent_builders::CreateHsmConfiguration {
        fluent_builders::CreateHsmConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateScheduledAction`](crate::client::fluent_builders::CreateScheduledAction) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`scheduled_action_name(impl Into<String>)`](crate::client::fluent_builders::CreateScheduledAction::scheduled_action_name) / [`set_scheduled_action_name(Option<String>)`](crate::client::fluent_builders::CreateScheduledAction::set_scheduled_action_name): <p>The name of the scheduled action. The name must be unique within an account. For more information about this parameter, see <code>ScheduledAction</code>. </p>
    ///   - [`target_action(ScheduledActionType)`](crate::client::fluent_builders::CreateScheduledAction::target_action) / [`set_target_action(Option<ScheduledActionType>)`](crate::client::fluent_builders::CreateScheduledAction::set_target_action): <p>A JSON format string of the Amazon Redshift API operation with input parameters. For more information about this parameter, see <code>ScheduledAction</code>. </p>
    ///   - [`schedule(impl Into<String>)`](crate::client::fluent_builders::CreateScheduledAction::schedule) / [`set_schedule(Option<String>)`](crate::client::fluent_builders::CreateScheduledAction::set_schedule): <p>The schedule in <code>at( )</code> or <code>cron( )</code> format. For more information about this parameter, see <code>ScheduledAction</code>.</p>
    ///   - [`iam_role(impl Into<String>)`](crate::client::fluent_builders::CreateScheduledAction::iam_role) / [`set_iam_role(Option<String>)`](crate::client::fluent_builders::CreateScheduledAction::set_iam_role): <p>The IAM role to assume to run the target action. For more information about this parameter, see <code>ScheduledAction</code>. </p>
    ///   - [`scheduled_action_description(impl Into<String>)`](crate::client::fluent_builders::CreateScheduledAction::scheduled_action_description) / [`set_scheduled_action_description(Option<String>)`](crate::client::fluent_builders::CreateScheduledAction::set_scheduled_action_description): <p>The description of the scheduled action. </p>
    ///   - [`start_time(DateTime)`](crate::client::fluent_builders::CreateScheduledAction::start_time) / [`set_start_time(Option<DateTime>)`](crate::client::fluent_builders::CreateScheduledAction::set_start_time): <p>The start time in UTC of the scheduled action. Before this time, the scheduled action does not trigger. For more information about this parameter, see <code>ScheduledAction</code>.</p>
    ///   - [`end_time(DateTime)`](crate::client::fluent_builders::CreateScheduledAction::end_time) / [`set_end_time(Option<DateTime>)`](crate::client::fluent_builders::CreateScheduledAction::set_end_time): <p>The end time in UTC of the scheduled action. After this time, the scheduled action does not trigger. For more information about this parameter, see <code>ScheduledAction</code>. </p>
    ///   - [`enable(bool)`](crate::client::fluent_builders::CreateScheduledAction::enable) / [`set_enable(Option<bool>)`](crate::client::fluent_builders::CreateScheduledAction::set_enable): <p>If true, the schedule is enabled. If false, the scheduled action does not trigger. For more information about <code>state</code> of the scheduled action, see <code>ScheduledAction</code>. </p>
    /// - On success, responds with [`CreateScheduledActionOutput`](crate::output::CreateScheduledActionOutput) with field(s):
    ///   - [`scheduled_action_name(Option<String>)`](crate::output::CreateScheduledActionOutput::scheduled_action_name): <p>The name of the scheduled action. </p>
    ///   - [`target_action(Option<ScheduledActionType>)`](crate::output::CreateScheduledActionOutput::target_action): <p>A JSON format string of the Amazon Redshift API operation with input parameters. </p>  <p>"<code>{\"ResizeCluster\":{\"NodeType\":\"ds2.8xlarge\",\"ClusterIdentifier\":\"my-test-cluster\",\"NumberOfNodes\":3}}</code>". </p>
    ///   - [`schedule(Option<String>)`](crate::output::CreateScheduledActionOutput::schedule): <p>The schedule for a one-time (at format) or recurring (cron format) scheduled action. Schedule invocations must be separated by at least one hour.</p>  <p>Format of at expressions is "<code>at(yyyy-mm-ddThh:mm:ss)</code>". For example, "<code>at(2016-03-04T17:27:00)</code>".</p>  <p>Format of cron expressions is "<code>cron(Minutes Hours Day-of-month Month Day-of-week Year)</code>". For example, "<code>cron(0 10 ? * MON *)</code>". For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html#CronExpressions">Cron Expressions</a> in the <i>Amazon CloudWatch Events User Guide</i>.</p>
    ///   - [`iam_role(Option<String>)`](crate::output::CreateScheduledActionOutput::iam_role): <p>The IAM role to assume to run the scheduled action. This IAM role must have permission to run the Amazon Redshift API operation in the scheduled action. This IAM role must allow the Amazon Redshift scheduler (Principal scheduler.redshift.amazonaws.com) to assume permissions on your behalf. For more information about the IAM role to use with the Amazon Redshift scheduler, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-identity-based.html">Using Identity-Based Policies for Amazon Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>. </p>
    ///   - [`scheduled_action_description(Option<String>)`](crate::output::CreateScheduledActionOutput::scheduled_action_description): <p>The description of the scheduled action. </p>
    ///   - [`state(Option<ScheduledActionState>)`](crate::output::CreateScheduledActionOutput::state): <p>The state of the scheduled action. For example, <code>DISABLED</code>. </p>
    ///   - [`next_invocations(Option<Vec<DateTime>>)`](crate::output::CreateScheduledActionOutput::next_invocations): <p>List of times when the scheduled action will run. </p>
    ///   - [`start_time(Option<DateTime>)`](crate::output::CreateScheduledActionOutput::start_time): <p>The start time in UTC when the schedule is active. Before this time, the scheduled action does not trigger. </p>
    ///   - [`end_time(Option<DateTime>)`](crate::output::CreateScheduledActionOutput::end_time): <p>The end time in UTC when the schedule is no longer active. After this time, the scheduled action does not trigger. </p>
    /// - On failure, responds with [`SdkError<CreateScheduledActionError>`](crate::error::CreateScheduledActionError)
    pub fn create_scheduled_action(&self) -> fluent_builders::CreateScheduledAction {
        fluent_builders::CreateScheduledAction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateSnapshotCopyGrant`](crate::client::fluent_builders::CreateSnapshotCopyGrant) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`snapshot_copy_grant_name(impl Into<String>)`](crate::client::fluent_builders::CreateSnapshotCopyGrant::snapshot_copy_grant_name) / [`set_snapshot_copy_grant_name(Option<String>)`](crate::client::fluent_builders::CreateSnapshotCopyGrant::set_snapshot_copy_grant_name): <p>The name of the snapshot copy grant. This name must be unique in the region for the Amazon Web Services account.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must contain from 1 to 63 alphanumeric characters or hyphens.</p> </li>   <li> <p>Alphabetic characters must be lowercase.</p> </li>   <li> <p>First character must be a letter.</p> </li>   <li> <p>Cannot end with a hyphen or contain two consecutive hyphens.</p> </li>   <li> <p>Must be unique for all clusters within an Amazon Web Services account.</p> </li>  </ul>
    ///   - [`kms_key_id(impl Into<String>)`](crate::client::fluent_builders::CreateSnapshotCopyGrant::kms_key_id) / [`set_kms_key_id(Option<String>)`](crate::client::fluent_builders::CreateSnapshotCopyGrant::set_kms_key_id): <p>The unique identifier of the encrypted symmetric key to which to grant Amazon Redshift permission. If no key is specified, the default key is used.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateSnapshotCopyGrant::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateSnapshotCopyGrant::set_tags): <p>A list of tag instances.</p>
    /// - On success, responds with [`CreateSnapshotCopyGrantOutput`](crate::output::CreateSnapshotCopyGrantOutput) with field(s):
    ///   - [`snapshot_copy_grant(Option<SnapshotCopyGrant>)`](crate::output::CreateSnapshotCopyGrantOutput::snapshot_copy_grant): <p>The snapshot copy grant that grants Amazon Redshift permission to encrypt copied snapshots with the specified encrypted symmetric key from Amazon Web Services KMS in the destination region.</p>  <p> For more information about managing snapshot copy grants, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-db-encryption.html">Amazon Redshift Database Encryption</a> in the <i>Amazon Redshift Cluster Management Guide</i>. </p>
    /// - On failure, responds with [`SdkError<CreateSnapshotCopyGrantError>`](crate::error::CreateSnapshotCopyGrantError)
    pub fn create_snapshot_copy_grant(&self) -> fluent_builders::CreateSnapshotCopyGrant {
        fluent_builders::CreateSnapshotCopyGrant::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateSnapshotSchedule`](crate::client::fluent_builders::CreateSnapshotSchedule) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`schedule_definitions(Vec<String>)`](crate::client::fluent_builders::CreateSnapshotSchedule::schedule_definitions) / [`set_schedule_definitions(Option<Vec<String>>)`](crate::client::fluent_builders::CreateSnapshotSchedule::set_schedule_definitions): <p>The definition of the snapshot schedule. The definition is made up of schedule expressions, for example "cron(30 12 *)" or "rate(12 hours)". </p>
    ///   - [`schedule_identifier(impl Into<String>)`](crate::client::fluent_builders::CreateSnapshotSchedule::schedule_identifier) / [`set_schedule_identifier(Option<String>)`](crate::client::fluent_builders::CreateSnapshotSchedule::set_schedule_identifier): <p>A unique identifier for a snapshot schedule. Only alphanumeric characters are allowed for the identifier.</p>
    ///   - [`schedule_description(impl Into<String>)`](crate::client::fluent_builders::CreateSnapshotSchedule::schedule_description) / [`set_schedule_description(Option<String>)`](crate::client::fluent_builders::CreateSnapshotSchedule::set_schedule_description): <p>The description of the snapshot schedule.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateSnapshotSchedule::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateSnapshotSchedule::set_tags): <p>An optional set of tags you can use to search for the schedule.</p>
    ///   - [`dry_run(bool)`](crate::client::fluent_builders::CreateSnapshotSchedule::dry_run) / [`set_dry_run(Option<bool>)`](crate::client::fluent_builders::CreateSnapshotSchedule::set_dry_run): <p></p>
    ///   - [`next_invocations(i32)`](crate::client::fluent_builders::CreateSnapshotSchedule::next_invocations) / [`set_next_invocations(Option<i32>)`](crate::client::fluent_builders::CreateSnapshotSchedule::set_next_invocations): <p></p>
    /// - On success, responds with [`CreateSnapshotScheduleOutput`](crate::output::CreateSnapshotScheduleOutput) with field(s):
    ///   - [`schedule_definitions(Option<Vec<String>>)`](crate::output::CreateSnapshotScheduleOutput::schedule_definitions): <p>A list of ScheduleDefinitions.</p>
    ///   - [`schedule_identifier(Option<String>)`](crate::output::CreateSnapshotScheduleOutput::schedule_identifier): <p>A unique identifier for the schedule.</p>
    ///   - [`schedule_description(Option<String>)`](crate::output::CreateSnapshotScheduleOutput::schedule_description): <p>The description of the schedule.</p>
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::CreateSnapshotScheduleOutput::tags): <p>An optional set of tags describing the schedule.</p>
    ///   - [`next_invocations(Option<Vec<DateTime>>)`](crate::output::CreateSnapshotScheduleOutput::next_invocations): <p></p>
    ///   - [`associated_cluster_count(Option<i32>)`](crate::output::CreateSnapshotScheduleOutput::associated_cluster_count): <p>The number of clusters associated with the schedule.</p>
    ///   - [`associated_clusters(Option<Vec<ClusterAssociatedToSchedule>>)`](crate::output::CreateSnapshotScheduleOutput::associated_clusters): <p>A list of clusters associated with the schedule. A maximum of 100 clusters is returned.</p>
    /// - On failure, responds with [`SdkError<CreateSnapshotScheduleError>`](crate::error::CreateSnapshotScheduleError)
    pub fn create_snapshot_schedule(&self) -> fluent_builders::CreateSnapshotSchedule {
        fluent_builders::CreateSnapshotSchedule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateTags`](crate::client::fluent_builders::CreateTags) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_name(impl Into<String>)`](crate::client::fluent_builders::CreateTags::resource_name) / [`set_resource_name(Option<String>)`](crate::client::fluent_builders::CreateTags::set_resource_name): <p>The Amazon Resource Name (ARN) to which you want to add the tag or tags. For example, <code>arn:aws:redshift:us-east-2:123456789:cluster:t1</code>. </p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateTags::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateTags::set_tags): <p>One or more name/value pairs to add as tags to the specified resource. Each tag name is passed in with the parameter <code>Key</code> and the corresponding value is passed in with the parameter <code>Value</code>. The <code>Key</code> and <code>Value</code> parameters are separated by a comma (,). Separate multiple tags with a space. For example, <code>--tags "Key"="owner","Value"="admin" "Key"="environment","Value"="test" "Key"="version","Value"="1.0"</code>. </p>
    /// - On success, responds with [`CreateTagsOutput`](crate::output::CreateTagsOutput)

    /// - On failure, responds with [`SdkError<CreateTagsError>`](crate::error::CreateTagsError)
    pub fn create_tags(&self) -> fluent_builders::CreateTags {
        fluent_builders::CreateTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateUsageLimit`](crate::client::fluent_builders::CreateUsageLimit) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster_identifier(impl Into<String>)`](crate::client::fluent_builders::CreateUsageLimit::cluster_identifier) / [`set_cluster_identifier(Option<String>)`](crate::client::fluent_builders::CreateUsageLimit::set_cluster_identifier): <p>The identifier of the cluster that you want to limit usage.</p>
    ///   - [`feature_type(UsageLimitFeatureType)`](crate::client::fluent_builders::CreateUsageLimit::feature_type) / [`set_feature_type(Option<UsageLimitFeatureType>)`](crate::client::fluent_builders::CreateUsageLimit::set_feature_type): <p>The Amazon Redshift feature that you want to limit.</p>
    ///   - [`limit_type(UsageLimitLimitType)`](crate::client::fluent_builders::CreateUsageLimit::limit_type) / [`set_limit_type(Option<UsageLimitLimitType>)`](crate::client::fluent_builders::CreateUsageLimit::set_limit_type): <p>The type of limit. Depending on the feature type, this can be based on a time duration or data size. If <code>FeatureType</code> is <code>spectrum</code>, then <code>LimitType</code> must be <code>data-scanned</code>. If <code>FeatureType</code> is <code>concurrency-scaling</code>, then <code>LimitType</code> must be <code>time</code>. If <code>FeatureType</code> is <code>cross-region-datasharing</code>, then <code>LimitType</code> must be <code>data-scanned</code>. </p>
    ///   - [`amount(i64)`](crate::client::fluent_builders::CreateUsageLimit::amount) / [`set_amount(i64)`](crate::client::fluent_builders::CreateUsageLimit::set_amount): <p>The limit amount. If time-based, this amount is in minutes. If data-based, this amount is in terabytes (TB). The value must be a positive number. </p>
    ///   - [`period(UsageLimitPeriod)`](crate::client::fluent_builders::CreateUsageLimit::period) / [`set_period(Option<UsageLimitPeriod>)`](crate::client::fluent_builders::CreateUsageLimit::set_period): <p>The time period that the amount applies to. A <code>weekly</code> period begins on Sunday. The default is <code>monthly</code>. </p>
    ///   - [`breach_action(UsageLimitBreachAction)`](crate::client::fluent_builders::CreateUsageLimit::breach_action) / [`set_breach_action(Option<UsageLimitBreachAction>)`](crate::client::fluent_builders::CreateUsageLimit::set_breach_action): <p>The action that Amazon Redshift takes when the limit is reached. The default is log. For more information about this parameter, see <code>UsageLimit</code>.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateUsageLimit::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateUsageLimit::set_tags): <p>A list of tag instances.</p>
    /// - On success, responds with [`CreateUsageLimitOutput`](crate::output::CreateUsageLimitOutput) with field(s):
    ///   - [`usage_limit_id(Option<String>)`](crate::output::CreateUsageLimitOutput::usage_limit_id): <p>The identifier of the usage limit.</p>
    ///   - [`cluster_identifier(Option<String>)`](crate::output::CreateUsageLimitOutput::cluster_identifier): <p>The identifier of the cluster with a usage limit.</p>
    ///   - [`feature_type(Option<UsageLimitFeatureType>)`](crate::output::CreateUsageLimitOutput::feature_type): <p>The Amazon Redshift feature to which the limit applies.</p>
    ///   - [`limit_type(Option<UsageLimitLimitType>)`](crate::output::CreateUsageLimitOutput::limit_type): <p>The type of limit. Depending on the feature type, this can be based on a time duration or data size.</p>
    ///   - [`amount(i64)`](crate::output::CreateUsageLimitOutput::amount): <p>The limit amount. If time-based, this amount is in minutes. If data-based, this amount is in terabytes (TB).</p>
    ///   - [`period(Option<UsageLimitPeriod>)`](crate::output::CreateUsageLimitOutput::period): <p>The time period that the amount applies to. A <code>weekly</code> period begins on Sunday. The default is <code>monthly</code>. </p>
    ///   - [`breach_action(Option<UsageLimitBreachAction>)`](crate::output::CreateUsageLimitOutput::breach_action): <p>The action that Amazon Redshift takes when the limit is reached. Possible values are: </p>  <ul>   <li> <p> <b>log</b> - To log an event in a system table. The default is log.</p> </li>   <li> <p> <b>emit-metric</b> - To emit CloudWatch metrics.</p> </li>   <li> <p> <b>disable</b> - To disable the feature until the next usage period begins.</p> </li>  </ul>
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::CreateUsageLimitOutput::tags): <p>A list of tag instances.</p>
    /// - On failure, responds with [`SdkError<CreateUsageLimitError>`](crate::error::CreateUsageLimitError)
    pub fn create_usage_limit(&self) -> fluent_builders::CreateUsageLimit {
        fluent_builders::CreateUsageLimit::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeauthorizeDataShare`](crate::client::fluent_builders::DeauthorizeDataShare) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`data_share_arn(impl Into<String>)`](crate::client::fluent_builders::DeauthorizeDataShare::data_share_arn) / [`set_data_share_arn(Option<String>)`](crate::client::fluent_builders::DeauthorizeDataShare::set_data_share_arn): <p>The Amazon Resource Name (ARN) of the datashare to remove authorization from.</p>
    ///   - [`consumer_identifier(impl Into<String>)`](crate::client::fluent_builders::DeauthorizeDataShare::consumer_identifier) / [`set_consumer_identifier(Option<String>)`](crate::client::fluent_builders::DeauthorizeDataShare::set_consumer_identifier): <p>The identifier of the data consumer that is to have authorization removed from the datashare. This identifier is an Amazon Web Services account ID or a keyword, such as ADX.</p>
    /// - On success, responds with [`DeauthorizeDataShareOutput`](crate::output::DeauthorizeDataShareOutput) with field(s):
    ///   - [`data_share_arn(Option<String>)`](crate::output::DeauthorizeDataShareOutput::data_share_arn): <p>An Amazon Resource Name (ARN) that references the datashare that is owned by a specific namespace of the producer cluster. A datashare ARN is in the <code>arn:aws:redshift:{region}:{account-id}:{datashare}:{namespace-guid}/{datashare-name}</code> format.</p>
    ///   - [`producer_arn(Option<String>)`](crate::output::DeauthorizeDataShareOutput::producer_arn): <p>The Amazon Resource Name (ARN) of the producer.</p>
    ///   - [`allow_publicly_accessible_consumers(bool)`](crate::output::DeauthorizeDataShareOutput::allow_publicly_accessible_consumers): <p>A value that specifies whether the datashare can be shared to a publicly accessible cluster.</p>
    ///   - [`data_share_associations(Option<Vec<DataShareAssociation>>)`](crate::output::DeauthorizeDataShareOutput::data_share_associations): <p>A value that specifies when the datashare has an association between a producer and data consumers.</p>
    ///   - [`managed_by(Option<String>)`](crate::output::DeauthorizeDataShareOutput::managed_by): <p>The identifier of a datashare to show its managing entity.</p>
    /// - On failure, responds with [`SdkError<DeauthorizeDataShareError>`](crate::error::DeauthorizeDataShareError)
    pub fn deauthorize_data_share(&self) -> fluent_builders::DeauthorizeDataShare {
        fluent_builders::DeauthorizeDataShare::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteAuthenticationProfile`](crate::client::fluent_builders::DeleteAuthenticationProfile) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`authentication_profile_name(impl Into<String>)`](crate::client::fluent_builders::DeleteAuthenticationProfile::authentication_profile_name) / [`set_authentication_profile_name(Option<String>)`](crate::client::fluent_builders::DeleteAuthenticationProfile::set_authentication_profile_name): <p>The name of the authentication profile to delete.</p>
    /// - On success, responds with [`DeleteAuthenticationProfileOutput`](crate::output::DeleteAuthenticationProfileOutput) with field(s):
    ///   - [`authentication_profile_name(Option<String>)`](crate::output::DeleteAuthenticationProfileOutput::authentication_profile_name): <p>The name of the authentication profile that was deleted.</p>
    /// - On failure, responds with [`SdkError<DeleteAuthenticationProfileError>`](crate::error::DeleteAuthenticationProfileError)
    pub fn delete_authentication_profile(&self) -> fluent_builders::DeleteAuthenticationProfile {
        fluent_builders::DeleteAuthenticationProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteCluster`](crate::client::fluent_builders::DeleteCluster) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster_identifier(impl Into<String>)`](crate::client::fluent_builders::DeleteCluster::cluster_identifier) / [`set_cluster_identifier(Option<String>)`](crate::client::fluent_builders::DeleteCluster::set_cluster_identifier): <p>The identifier of the cluster to be deleted.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must contain lowercase characters.</p> </li>   <li> <p>Must contain from 1 to 63 alphanumeric characters or hyphens.</p> </li>   <li> <p>First character must be a letter.</p> </li>   <li> <p>Cannot end with a hyphen or contain two consecutive hyphens.</p> </li>  </ul>
    ///   - [`skip_final_cluster_snapshot(bool)`](crate::client::fluent_builders::DeleteCluster::skip_final_cluster_snapshot) / [`set_skip_final_cluster_snapshot(bool)`](crate::client::fluent_builders::DeleteCluster::set_skip_final_cluster_snapshot): <p>Determines whether a final snapshot of the cluster is created before Amazon Redshift deletes the cluster. If <code>true</code>, a final cluster snapshot is not created. If <code>false</code>, a final cluster snapshot is created before the cluster is deleted. </p> <note>   <p>The <i>FinalClusterSnapshotIdentifier</i> parameter must be specified if <i>SkipFinalClusterSnapshot</i> is <code>false</code>.</p>  </note>  <p>Default: <code>false</code> </p>
    ///   - [`final_cluster_snapshot_identifier(impl Into<String>)`](crate::client::fluent_builders::DeleteCluster::final_cluster_snapshot_identifier) / [`set_final_cluster_snapshot_identifier(Option<String>)`](crate::client::fluent_builders::DeleteCluster::set_final_cluster_snapshot_identifier): <p>The identifier of the final snapshot that is to be created immediately before deleting the cluster. If this parameter is provided, <i>SkipFinalClusterSnapshot</i> must be <code>false</code>. </p>  <p>Constraints:</p>  <ul>   <li> <p>Must be 1 to 255 alphanumeric characters.</p> </li>   <li> <p>First character must be a letter.</p> </li>   <li> <p>Cannot end with a hyphen or contain two consecutive hyphens.</p> </li>  </ul>
    ///   - [`final_cluster_snapshot_retention_period(i32)`](crate::client::fluent_builders::DeleteCluster::final_cluster_snapshot_retention_period) / [`set_final_cluster_snapshot_retention_period(Option<i32>)`](crate::client::fluent_builders::DeleteCluster::set_final_cluster_snapshot_retention_period): <p>The number of days that a manual snapshot is retained. If the value is -1, the manual snapshot is retained indefinitely.</p>  <p>The value must be either -1 or an integer between 1 and 3,653.</p>  <p>The default value is -1.</p>
    /// - On success, responds with [`DeleteClusterOutput`](crate::output::DeleteClusterOutput) with field(s):
    ///   - [`cluster(Option<Cluster>)`](crate::output::DeleteClusterOutput::cluster): <p>Describes a cluster.</p>
    /// - On failure, responds with [`SdkError<DeleteClusterError>`](crate::error::DeleteClusterError)
    pub fn delete_cluster(&self) -> fluent_builders::DeleteCluster {
        fluent_builders::DeleteCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteClusterParameterGroup`](crate::client::fluent_builders::DeleteClusterParameterGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`parameter_group_name(impl Into<String>)`](crate::client::fluent_builders::DeleteClusterParameterGroup::parameter_group_name) / [`set_parameter_group_name(Option<String>)`](crate::client::fluent_builders::DeleteClusterParameterGroup::set_parameter_group_name): <p>The name of the parameter group to be deleted.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must be the name of an existing cluster parameter group.</p> </li>   <li> <p>Cannot delete a default cluster parameter group.</p> </li>  </ul>
    /// - On success, responds with [`DeleteClusterParameterGroupOutput`](crate::output::DeleteClusterParameterGroupOutput)

    /// - On failure, responds with [`SdkError<DeleteClusterParameterGroupError>`](crate::error::DeleteClusterParameterGroupError)
    pub fn delete_cluster_parameter_group(&self) -> fluent_builders::DeleteClusterParameterGroup {
        fluent_builders::DeleteClusterParameterGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteClusterSecurityGroup`](crate::client::fluent_builders::DeleteClusterSecurityGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster_security_group_name(impl Into<String>)`](crate::client::fluent_builders::DeleteClusterSecurityGroup::cluster_security_group_name) / [`set_cluster_security_group_name(Option<String>)`](crate::client::fluent_builders::DeleteClusterSecurityGroup::set_cluster_security_group_name): <p>The name of the cluster security group to be deleted.</p>
    /// - On success, responds with [`DeleteClusterSecurityGroupOutput`](crate::output::DeleteClusterSecurityGroupOutput)

    /// - On failure, responds with [`SdkError<DeleteClusterSecurityGroupError>`](crate::error::DeleteClusterSecurityGroupError)
    pub fn delete_cluster_security_group(&self) -> fluent_builders::DeleteClusterSecurityGroup {
        fluent_builders::DeleteClusterSecurityGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteClusterSnapshot`](crate::client::fluent_builders::DeleteClusterSnapshot) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`snapshot_identifier(impl Into<String>)`](crate::client::fluent_builders::DeleteClusterSnapshot::snapshot_identifier) / [`set_snapshot_identifier(Option<String>)`](crate::client::fluent_builders::DeleteClusterSnapshot::set_snapshot_identifier): <p>The unique identifier of the manual snapshot to be deleted.</p>  <p>Constraints: Must be the name of an existing snapshot that is in the <code>available</code>, <code>failed</code>, or <code>cancelled</code> state.</p>
    ///   - [`snapshot_cluster_identifier(impl Into<String>)`](crate::client::fluent_builders::DeleteClusterSnapshot::snapshot_cluster_identifier) / [`set_snapshot_cluster_identifier(Option<String>)`](crate::client::fluent_builders::DeleteClusterSnapshot::set_snapshot_cluster_identifier): <p>The unique identifier of the cluster the snapshot was created from. This parameter is required if your IAM user has a policy containing a snapshot resource element that specifies anything other than * for the cluster name.</p>  <p>Constraints: Must be the name of valid cluster.</p>
    /// - On success, responds with [`DeleteClusterSnapshotOutput`](crate::output::DeleteClusterSnapshotOutput) with field(s):
    ///   - [`snapshot(Option<Snapshot>)`](crate::output::DeleteClusterSnapshotOutput::snapshot): <p>Describes a snapshot.</p>
    /// - On failure, responds with [`SdkError<DeleteClusterSnapshotError>`](crate::error::DeleteClusterSnapshotError)
    pub fn delete_cluster_snapshot(&self) -> fluent_builders::DeleteClusterSnapshot {
        fluent_builders::DeleteClusterSnapshot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteClusterSubnetGroup`](crate::client::fluent_builders::DeleteClusterSubnetGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster_subnet_group_name(impl Into<String>)`](crate::client::fluent_builders::DeleteClusterSubnetGroup::cluster_subnet_group_name) / [`set_cluster_subnet_group_name(Option<String>)`](crate::client::fluent_builders::DeleteClusterSubnetGroup::set_cluster_subnet_group_name): <p>The name of the cluster subnet group name to be deleted.</p>
    /// - On success, responds with [`DeleteClusterSubnetGroupOutput`](crate::output::DeleteClusterSubnetGroupOutput)

    /// - On failure, responds with [`SdkError<DeleteClusterSubnetGroupError>`](crate::error::DeleteClusterSubnetGroupError)
    pub fn delete_cluster_subnet_group(&self) -> fluent_builders::DeleteClusterSubnetGroup {
        fluent_builders::DeleteClusterSubnetGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteEndpointAccess`](crate::client::fluent_builders::DeleteEndpointAccess) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`endpoint_name(impl Into<String>)`](crate::client::fluent_builders::DeleteEndpointAccess::endpoint_name) / [`set_endpoint_name(Option<String>)`](crate::client::fluent_builders::DeleteEndpointAccess::set_endpoint_name): <p>The Redshift-managed VPC endpoint to delete.</p>
    /// - On success, responds with [`DeleteEndpointAccessOutput`](crate::output::DeleteEndpointAccessOutput) with field(s):
    ///   - [`cluster_identifier(Option<String>)`](crate::output::DeleteEndpointAccessOutput::cluster_identifier): <p>The cluster identifier of the cluster associated with the endpoint.</p>
    ///   - [`resource_owner(Option<String>)`](crate::output::DeleteEndpointAccessOutput::resource_owner): <p>The Amazon Web Services account ID of the owner of the cluster.</p>
    ///   - [`subnet_group_name(Option<String>)`](crate::output::DeleteEndpointAccessOutput::subnet_group_name): <p>The subnet group name where Amazon Redshift chooses to deploy the endpoint.</p>
    ///   - [`endpoint_status(Option<String>)`](crate::output::DeleteEndpointAccessOutput::endpoint_status): <p>The status of the endpoint.</p>
    ///   - [`endpoint_name(Option<String>)`](crate::output::DeleteEndpointAccessOutput::endpoint_name): <p>The name of the endpoint.</p>
    ///   - [`endpoint_create_time(Option<DateTime>)`](crate::output::DeleteEndpointAccessOutput::endpoint_create_time): <p>The time (UTC) that the endpoint was created.</p>
    ///   - [`port(i32)`](crate::output::DeleteEndpointAccessOutput::port): <p>The port number on which the cluster accepts incoming connections.</p>
    ///   - [`address(Option<String>)`](crate::output::DeleteEndpointAccessOutput::address): <p>The DNS address of the endpoint.</p>
    ///   - [`vpc_security_groups(Option<Vec<VpcSecurityGroupMembership>>)`](crate::output::DeleteEndpointAccessOutput::vpc_security_groups): <p>The security groups associated with the endpoint.</p>
    ///   - [`vpc_endpoint(Option<VpcEndpoint>)`](crate::output::DeleteEndpointAccessOutput::vpc_endpoint): <p>The connection endpoint for connecting to an Amazon Redshift cluster through the proxy.</p>
    /// - On failure, responds with [`SdkError<DeleteEndpointAccessError>`](crate::error::DeleteEndpointAccessError)
    pub fn delete_endpoint_access(&self) -> fluent_builders::DeleteEndpointAccess {
        fluent_builders::DeleteEndpointAccess::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteEventSubscription`](crate::client::fluent_builders::DeleteEventSubscription) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`subscription_name(impl Into<String>)`](crate::client::fluent_builders::DeleteEventSubscription::subscription_name) / [`set_subscription_name(Option<String>)`](crate::client::fluent_builders::DeleteEventSubscription::set_subscription_name): <p>The name of the Amazon Redshift event notification subscription to be deleted.</p>
    /// - On success, responds with [`DeleteEventSubscriptionOutput`](crate::output::DeleteEventSubscriptionOutput)

    /// - On failure, responds with [`SdkError<DeleteEventSubscriptionError>`](crate::error::DeleteEventSubscriptionError)
    pub fn delete_event_subscription(&self) -> fluent_builders::DeleteEventSubscription {
        fluent_builders::DeleteEventSubscription::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteHsmClientCertificate`](crate::client::fluent_builders::DeleteHsmClientCertificate) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`hsm_client_certificate_identifier(impl Into<String>)`](crate::client::fluent_builders::DeleteHsmClientCertificate::hsm_client_certificate_identifier) / [`set_hsm_client_certificate_identifier(Option<String>)`](crate::client::fluent_builders::DeleteHsmClientCertificate::set_hsm_client_certificate_identifier): <p>The identifier of the HSM client certificate to be deleted.</p>
    /// - On success, responds with [`DeleteHsmClientCertificateOutput`](crate::output::DeleteHsmClientCertificateOutput)

    /// - On failure, responds with [`SdkError<DeleteHsmClientCertificateError>`](crate::error::DeleteHsmClientCertificateError)
    pub fn delete_hsm_client_certificate(&self) -> fluent_builders::DeleteHsmClientCertificate {
        fluent_builders::DeleteHsmClientCertificate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteHsmConfiguration`](crate::client::fluent_builders::DeleteHsmConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`hsm_configuration_identifier(impl Into<String>)`](crate::client::fluent_builders::DeleteHsmConfiguration::hsm_configuration_identifier) / [`set_hsm_configuration_identifier(Option<String>)`](crate::client::fluent_builders::DeleteHsmConfiguration::set_hsm_configuration_identifier): <p>The identifier of the Amazon Redshift HSM configuration to be deleted.</p>
    /// - On success, responds with [`DeleteHsmConfigurationOutput`](crate::output::DeleteHsmConfigurationOutput)

    /// - On failure, responds with [`SdkError<DeleteHsmConfigurationError>`](crate::error::DeleteHsmConfigurationError)
    pub fn delete_hsm_configuration(&self) -> fluent_builders::DeleteHsmConfiguration {
        fluent_builders::DeleteHsmConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeletePartner`](crate::client::fluent_builders::DeletePartner) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::DeletePartner::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::DeletePartner::set_account_id): <p>The Amazon Web Services account ID that owns the cluster.</p>
    ///   - [`cluster_identifier(impl Into<String>)`](crate::client::fluent_builders::DeletePartner::cluster_identifier) / [`set_cluster_identifier(Option<String>)`](crate::client::fluent_builders::DeletePartner::set_cluster_identifier): <p>The cluster identifier of the cluster that receives data from the partner.</p>
    ///   - [`database_name(impl Into<String>)`](crate::client::fluent_builders::DeletePartner::database_name) / [`set_database_name(Option<String>)`](crate::client::fluent_builders::DeletePartner::set_database_name): <p>The name of the database that receives data from the partner.</p>
    ///   - [`partner_name(impl Into<String>)`](crate::client::fluent_builders::DeletePartner::partner_name) / [`set_partner_name(Option<String>)`](crate::client::fluent_builders::DeletePartner::set_partner_name): <p>The name of the partner that is authorized to send data.</p>
    /// - On success, responds with [`DeletePartnerOutput`](crate::output::DeletePartnerOutput) with field(s):
    ///   - [`database_name(Option<String>)`](crate::output::DeletePartnerOutput::database_name): <p>The name of the database that receives data from the partner.</p>
    ///   - [`partner_name(Option<String>)`](crate::output::DeletePartnerOutput::partner_name): <p>The name of the partner that is authorized to send data.</p>
    /// - On failure, responds with [`SdkError<DeletePartnerError>`](crate::error::DeletePartnerError)
    pub fn delete_partner(&self) -> fluent_builders::DeletePartner {
        fluent_builders::DeletePartner::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteScheduledAction`](crate::client::fluent_builders::DeleteScheduledAction) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`scheduled_action_name(impl Into<String>)`](crate::client::fluent_builders::DeleteScheduledAction::scheduled_action_name) / [`set_scheduled_action_name(Option<String>)`](crate::client::fluent_builders::DeleteScheduledAction::set_scheduled_action_name): <p>The name of the scheduled action to delete. </p>
    /// - On success, responds with [`DeleteScheduledActionOutput`](crate::output::DeleteScheduledActionOutput)

    /// - On failure, responds with [`SdkError<DeleteScheduledActionError>`](crate::error::DeleteScheduledActionError)
    pub fn delete_scheduled_action(&self) -> fluent_builders::DeleteScheduledAction {
        fluent_builders::DeleteScheduledAction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteSnapshotCopyGrant`](crate::client::fluent_builders::DeleteSnapshotCopyGrant) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`snapshot_copy_grant_name(impl Into<String>)`](crate::client::fluent_builders::DeleteSnapshotCopyGrant::snapshot_copy_grant_name) / [`set_snapshot_copy_grant_name(Option<String>)`](crate::client::fluent_builders::DeleteSnapshotCopyGrant::set_snapshot_copy_grant_name): <p>The name of the snapshot copy grant to delete.</p>
    /// - On success, responds with [`DeleteSnapshotCopyGrantOutput`](crate::output::DeleteSnapshotCopyGrantOutput)

    /// - On failure, responds with [`SdkError<DeleteSnapshotCopyGrantError>`](crate::error::DeleteSnapshotCopyGrantError)
    pub fn delete_snapshot_copy_grant(&self) -> fluent_builders::DeleteSnapshotCopyGrant {
        fluent_builders::DeleteSnapshotCopyGrant::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteSnapshotSchedule`](crate::client::fluent_builders::DeleteSnapshotSchedule) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`schedule_identifier(impl Into<String>)`](crate::client::fluent_builders::DeleteSnapshotSchedule::schedule_identifier) / [`set_schedule_identifier(Option<String>)`](crate::client::fluent_builders::DeleteSnapshotSchedule::set_schedule_identifier): <p>A unique identifier of the snapshot schedule to delete.</p>
    /// - On success, responds with [`DeleteSnapshotScheduleOutput`](crate::output::DeleteSnapshotScheduleOutput)

    /// - On failure, responds with [`SdkError<DeleteSnapshotScheduleError>`](crate::error::DeleteSnapshotScheduleError)
    pub fn delete_snapshot_schedule(&self) -> fluent_builders::DeleteSnapshotSchedule {
        fluent_builders::DeleteSnapshotSchedule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteTags`](crate::client::fluent_builders::DeleteTags) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_name(impl Into<String>)`](crate::client::fluent_builders::DeleteTags::resource_name) / [`set_resource_name(Option<String>)`](crate::client::fluent_builders::DeleteTags::set_resource_name): <p>The Amazon Resource Name (ARN) from which you want to remove the tag or tags. For example, <code>arn:aws:redshift:us-east-2:123456789:cluster:t1</code>. </p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::DeleteTags::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::DeleteTags::set_tag_keys): <p>The tag key that you want to delete.</p>
    /// - On success, responds with [`DeleteTagsOutput`](crate::output::DeleteTagsOutput)

    /// - On failure, responds with [`SdkError<DeleteTagsError>`](crate::error::DeleteTagsError)
    pub fn delete_tags(&self) -> fluent_builders::DeleteTags {
        fluent_builders::DeleteTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteUsageLimit`](crate::client::fluent_builders::DeleteUsageLimit) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`usage_limit_id(impl Into<String>)`](crate::client::fluent_builders::DeleteUsageLimit::usage_limit_id) / [`set_usage_limit_id(Option<String>)`](crate::client::fluent_builders::DeleteUsageLimit::set_usage_limit_id): <p>The identifier of the usage limit to delete.</p>
    /// - On success, responds with [`DeleteUsageLimitOutput`](crate::output::DeleteUsageLimitOutput)

    /// - On failure, responds with [`SdkError<DeleteUsageLimitError>`](crate::error::DeleteUsageLimitError)
    pub fn delete_usage_limit(&self) -> fluent_builders::DeleteUsageLimit {
        fluent_builders::DeleteUsageLimit::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeAccountAttributes`](crate::client::fluent_builders::DescribeAccountAttributes) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`attribute_names(Vec<String>)`](crate::client::fluent_builders::DescribeAccountAttributes::attribute_names) / [`set_attribute_names(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeAccountAttributes::set_attribute_names): <p>A list of attribute names.</p>
    /// - On success, responds with [`DescribeAccountAttributesOutput`](crate::output::DescribeAccountAttributesOutput) with field(s):
    ///   - [`account_attributes(Option<Vec<AccountAttribute>>)`](crate::output::DescribeAccountAttributesOutput::account_attributes): <p>A list of attributes assigned to an account.</p>
    /// - On failure, responds with [`SdkError<DescribeAccountAttributesError>`](crate::error::DescribeAccountAttributesError)
    pub fn describe_account_attributes(&self) -> fluent_builders::DescribeAccountAttributes {
        fluent_builders::DescribeAccountAttributes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeAuthenticationProfiles`](crate::client::fluent_builders::DescribeAuthenticationProfiles) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`authentication_profile_name(impl Into<String>)`](crate::client::fluent_builders::DescribeAuthenticationProfiles::authentication_profile_name) / [`set_authentication_profile_name(Option<String>)`](crate::client::fluent_builders::DescribeAuthenticationProfiles::set_authentication_profile_name): <p>The name of the authentication profile to describe. If not specified then all authentication profiles owned by the account are listed.</p>
    /// - On success, responds with [`DescribeAuthenticationProfilesOutput`](crate::output::DescribeAuthenticationProfilesOutput) with field(s):
    ///   - [`authentication_profiles(Option<Vec<AuthenticationProfile>>)`](crate::output::DescribeAuthenticationProfilesOutput::authentication_profiles): <p>The list of authentication profiles.</p>
    /// - On failure, responds with [`SdkError<DescribeAuthenticationProfilesError>`](crate::error::DescribeAuthenticationProfilesError)
    pub fn describe_authentication_profiles(
        &self,
    ) -> fluent_builders::DescribeAuthenticationProfiles {
        fluent_builders::DescribeAuthenticationProfiles::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeClusterDbRevisions`](crate::client::fluent_builders::DescribeClusterDbRevisions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeClusterDbRevisions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster_identifier(impl Into<String>)`](crate::client::fluent_builders::DescribeClusterDbRevisions::cluster_identifier) / [`set_cluster_identifier(Option<String>)`](crate::client::fluent_builders::DescribeClusterDbRevisions::set_cluster_identifier): <p>A unique identifier for a cluster whose <code>ClusterDbRevisions</code> you are requesting. This parameter is case sensitive. All clusters defined for an account are returned by default.</p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeClusterDbRevisions::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeClusterDbRevisions::set_max_records): <p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified MaxRecords value, a value is returned in the <code>marker</code> field of the response. You can retrieve the next set of response records by providing the returned <code>marker</code> value in the <code>marker</code> parameter and retrying the request. </p>  <p>Default: 100</p>  <p>Constraints: minimum 20, maximum 100.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeClusterDbRevisions::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeClusterDbRevisions::set_marker): <p>An optional parameter that specifies the starting point for returning a set of response records. When the results of a <code>DescribeClusterDbRevisions</code> request exceed the value specified in <code>MaxRecords</code>, Amazon Redshift returns a value in the <code>marker</code> field of the response. You can retrieve the next set of response records by providing the returned <code>marker</code> value in the <code>marker</code> parameter and retrying the request. </p>  <p>Constraints: You can specify either the <code>ClusterIdentifier</code> parameter, or the <code>marker</code> parameter, but not both.</p>
    /// - On success, responds with [`DescribeClusterDbRevisionsOutput`](crate::output::DescribeClusterDbRevisionsOutput) with field(s):
    ///   - [`marker(Option<String>)`](crate::output::DescribeClusterDbRevisionsOutput::marker): <p>A string representing the starting point for the next set of revisions. If a value is returned in a response, you can retrieve the next set of revisions by providing the value in the <code>marker</code> parameter and retrying the command. If the <code>marker</code> field is empty, all revisions have already been returned.</p>
    ///   - [`cluster_db_revisions(Option<Vec<ClusterDbRevision>>)`](crate::output::DescribeClusterDbRevisionsOutput::cluster_db_revisions): <p>A list of revisions.</p>
    /// - On failure, responds with [`SdkError<DescribeClusterDbRevisionsError>`](crate::error::DescribeClusterDbRevisionsError)
    pub fn describe_cluster_db_revisions(&self) -> fluent_builders::DescribeClusterDbRevisions {
        fluent_builders::DescribeClusterDbRevisions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeClusterParameterGroups`](crate::client::fluent_builders::DescribeClusterParameterGroups) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeClusterParameterGroups::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`parameter_group_name(impl Into<String>)`](crate::client::fluent_builders::DescribeClusterParameterGroups::parameter_group_name) / [`set_parameter_group_name(Option<String>)`](crate::client::fluent_builders::DescribeClusterParameterGroups::set_parameter_group_name): <p>The name of a specific parameter group for which to return details. By default, details about all parameter groups and the default parameter group are returned.</p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeClusterParameterGroups::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeClusterParameterGroups::set_max_records): <p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. </p>  <p>Default: <code>100</code> </p>  <p>Constraints: minimum 20, maximum 100.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeClusterParameterGroups::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeClusterParameterGroups::set_marker): <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <code>DescribeClusterParameterGroups</code> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::DescribeClusterParameterGroups::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeClusterParameterGroups::set_tag_keys): <p>A tag key or keys for which you want to return all matching cluster parameter groups that are associated with the specified key or keys. For example, suppose that you have parameter groups that are tagged with keys called <code>owner</code> and <code>environment</code>. If you specify both of these tag keys in the request, Amazon Redshift returns a response with the parameter groups that have either or both of these tag keys associated with them.</p>
    ///   - [`tag_values(Vec<String>)`](crate::client::fluent_builders::DescribeClusterParameterGroups::tag_values) / [`set_tag_values(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeClusterParameterGroups::set_tag_values): <p>A tag value or values for which you want to return all matching cluster parameter groups that are associated with the specified tag value or values. For example, suppose that you have parameter groups that are tagged with values called <code>admin</code> and <code>test</code>. If you specify both of these tag values in the request, Amazon Redshift returns a response with the parameter groups that have either or both of these tag values associated with them.</p>
    /// - On success, responds with [`DescribeClusterParameterGroupsOutput`](crate::output::DescribeClusterParameterGroupsOutput) with field(s):
    ///   - [`marker(Option<String>)`](crate::output::DescribeClusterParameterGroupsOutput::marker): <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>
    ///   - [`parameter_groups(Option<Vec<ClusterParameterGroup>>)`](crate::output::DescribeClusterParameterGroupsOutput::parameter_groups): <p>A list of <code>ClusterParameterGroup</code> instances. Each instance describes one cluster parameter group. </p>
    /// - On failure, responds with [`SdkError<DescribeClusterParameterGroupsError>`](crate::error::DescribeClusterParameterGroupsError)
    pub fn describe_cluster_parameter_groups(
        &self,
    ) -> fluent_builders::DescribeClusterParameterGroups {
        fluent_builders::DescribeClusterParameterGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeClusterParameters`](crate::client::fluent_builders::DescribeClusterParameters) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeClusterParameters::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`parameter_group_name(impl Into<String>)`](crate::client::fluent_builders::DescribeClusterParameters::parameter_group_name) / [`set_parameter_group_name(Option<String>)`](crate::client::fluent_builders::DescribeClusterParameters::set_parameter_group_name): <p>The name of a cluster parameter group for which to return details.</p>
    ///   - [`source(impl Into<String>)`](crate::client::fluent_builders::DescribeClusterParameters::source) / [`set_source(Option<String>)`](crate::client::fluent_builders::DescribeClusterParameters::set_source): <p>The parameter types to return. Specify <code>user</code> to show parameters that are different form the default. Similarly, specify <code>engine-default</code> to show parameters that are the same as the default parameter group. </p>  <p>Default: All parameter types returned.</p>  <p>Valid Values: <code>user</code> | <code>engine-default</code> </p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeClusterParameters::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeClusterParameters::set_max_records): <p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. </p>  <p>Default: <code>100</code> </p>  <p>Constraints: minimum 20, maximum 100.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeClusterParameters::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeClusterParameters::set_marker): <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <code>DescribeClusterParameters</code> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
    /// - On success, responds with [`DescribeClusterParametersOutput`](crate::output::DescribeClusterParametersOutput) with field(s):
    ///   - [`parameters(Option<Vec<Parameter>>)`](crate::output::DescribeClusterParametersOutput::parameters): <p>A list of <code>Parameter</code> instances. Each instance lists the parameters of one cluster parameter group. </p>
    ///   - [`marker(Option<String>)`](crate::output::DescribeClusterParametersOutput::marker): <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>
    /// - On failure, responds with [`SdkError<DescribeClusterParametersError>`](crate::error::DescribeClusterParametersError)
    pub fn describe_cluster_parameters(&self) -> fluent_builders::DescribeClusterParameters {
        fluent_builders::DescribeClusterParameters::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeClusters`](crate::client::fluent_builders::DescribeClusters) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeClusters::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster_identifier(impl Into<String>)`](crate::client::fluent_builders::DescribeClusters::cluster_identifier) / [`set_cluster_identifier(Option<String>)`](crate::client::fluent_builders::DescribeClusters::set_cluster_identifier): <p>The unique identifier of a cluster whose properties you are requesting. This parameter is case sensitive.</p>  <p>The default is that all clusters defined for an account are returned.</p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeClusters::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeClusters::set_max_records): <p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. </p>  <p>Default: <code>100</code> </p>  <p>Constraints: minimum 20, maximum 100.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeClusters::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeClusters::set_marker): <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <code>DescribeClusters</code> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>  <p>Constraints: You can specify either the <b>ClusterIdentifier</b> parameter or the <b>Marker</b> parameter, but not both. </p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::DescribeClusters::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeClusters::set_tag_keys): <p>A tag key or keys for which you want to return all matching clusters that are associated with the specified key or keys. For example, suppose that you have clusters that are tagged with keys called <code>owner</code> and <code>environment</code>. If you specify both of these tag keys in the request, Amazon Redshift returns a response with the clusters that have either or both of these tag keys associated with them.</p>
    ///   - [`tag_values(Vec<String>)`](crate::client::fluent_builders::DescribeClusters::tag_values) / [`set_tag_values(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeClusters::set_tag_values): <p>A tag value or values for which you want to return all matching clusters that are associated with the specified tag value or values. For example, suppose that you have clusters that are tagged with values called <code>admin</code> and <code>test</code>. If you specify both of these tag values in the request, Amazon Redshift returns a response with the clusters that have either or both of these tag values associated with them.</p>
    /// - On success, responds with [`DescribeClustersOutput`](crate::output::DescribeClustersOutput) with field(s):
    ///   - [`marker(Option<String>)`](crate::output::DescribeClustersOutput::marker): <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>
    ///   - [`clusters(Option<Vec<Cluster>>)`](crate::output::DescribeClustersOutput::clusters): <p>A list of <code>Cluster</code> objects, where each object describes one cluster. </p>
    /// - On failure, responds with [`SdkError<DescribeClustersError>`](crate::error::DescribeClustersError)
    pub fn describe_clusters(&self) -> fluent_builders::DescribeClusters {
        fluent_builders::DescribeClusters::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeClusterSecurityGroups`](crate::client::fluent_builders::DescribeClusterSecurityGroups) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeClusterSecurityGroups::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster_security_group_name(impl Into<String>)`](crate::client::fluent_builders::DescribeClusterSecurityGroups::cluster_security_group_name) / [`set_cluster_security_group_name(Option<String>)`](crate::client::fluent_builders::DescribeClusterSecurityGroups::set_cluster_security_group_name): <p>The name of a cluster security group for which you are requesting details. You can specify either the <b>Marker</b> parameter or a <b>ClusterSecurityGroupName</b> parameter, but not both. </p>  <p> Example: <code>securitygroup1</code> </p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeClusterSecurityGroups::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeClusterSecurityGroups::set_max_records): <p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. </p>  <p>Default: <code>100</code> </p>  <p>Constraints: minimum 20, maximum 100.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeClusterSecurityGroups::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeClusterSecurityGroups::set_marker): <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <code>DescribeClusterSecurityGroups</code> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>  <p>Constraints: You can specify either the <b>ClusterSecurityGroupName</b> parameter or the <b>Marker</b> parameter, but not both. </p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::DescribeClusterSecurityGroups::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeClusterSecurityGroups::set_tag_keys): <p>A tag key or keys for which you want to return all matching cluster security groups that are associated with the specified key or keys. For example, suppose that you have security groups that are tagged with keys called <code>owner</code> and <code>environment</code>. If you specify both of these tag keys in the request, Amazon Redshift returns a response with the security groups that have either or both of these tag keys associated with them.</p>
    ///   - [`tag_values(Vec<String>)`](crate::client::fluent_builders::DescribeClusterSecurityGroups::tag_values) / [`set_tag_values(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeClusterSecurityGroups::set_tag_values): <p>A tag value or values for which you want to return all matching cluster security groups that are associated with the specified tag value or values. For example, suppose that you have security groups that are tagged with values called <code>admin</code> and <code>test</code>. If you specify both of these tag values in the request, Amazon Redshift returns a response with the security groups that have either or both of these tag values associated with them.</p>
    /// - On success, responds with [`DescribeClusterSecurityGroupsOutput`](crate::output::DescribeClusterSecurityGroupsOutput) with field(s):
    ///   - [`marker(Option<String>)`](crate::output::DescribeClusterSecurityGroupsOutput::marker): <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>
    ///   - [`cluster_security_groups(Option<Vec<ClusterSecurityGroup>>)`](crate::output::DescribeClusterSecurityGroupsOutput::cluster_security_groups): <p>A list of <code>ClusterSecurityGroup</code> instances. </p>
    /// - On failure, responds with [`SdkError<DescribeClusterSecurityGroupsError>`](crate::error::DescribeClusterSecurityGroupsError)
    pub fn describe_cluster_security_groups(
        &self,
    ) -> fluent_builders::DescribeClusterSecurityGroups {
        fluent_builders::DescribeClusterSecurityGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeClusterSnapshots`](crate::client::fluent_builders::DescribeClusterSnapshots) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeClusterSnapshots::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster_identifier(impl Into<String>)`](crate::client::fluent_builders::DescribeClusterSnapshots::cluster_identifier) / [`set_cluster_identifier(Option<String>)`](crate::client::fluent_builders::DescribeClusterSnapshots::set_cluster_identifier): <p>The identifier of the cluster which generated the requested snapshots.</p>
    ///   - [`snapshot_identifier(impl Into<String>)`](crate::client::fluent_builders::DescribeClusterSnapshots::snapshot_identifier) / [`set_snapshot_identifier(Option<String>)`](crate::client::fluent_builders::DescribeClusterSnapshots::set_snapshot_identifier): <p>The snapshot identifier of the snapshot about which to return information.</p>
    ///   - [`snapshot_type(impl Into<String>)`](crate::client::fluent_builders::DescribeClusterSnapshots::snapshot_type) / [`set_snapshot_type(Option<String>)`](crate::client::fluent_builders::DescribeClusterSnapshots::set_snapshot_type): <p>The type of snapshots for which you are requesting information. By default, snapshots of all types are returned.</p>  <p>Valid Values: <code>automated</code> | <code>manual</code> </p>
    ///   - [`start_time(DateTime)`](crate::client::fluent_builders::DescribeClusterSnapshots::start_time) / [`set_start_time(Option<DateTime>)`](crate::client::fluent_builders::DescribeClusterSnapshots::set_start_time): <p>A value that requests only snapshots created at or after the specified time. The time value is specified in ISO 8601 format. For more information about ISO 8601, go to the <a href="http://en.wikipedia.org/wiki/ISO_8601">ISO8601 Wikipedia page.</a> </p>  <p>Example: <code>2012-07-16T18:00:00Z</code> </p>
    ///   - [`end_time(DateTime)`](crate::client::fluent_builders::DescribeClusterSnapshots::end_time) / [`set_end_time(Option<DateTime>)`](crate::client::fluent_builders::DescribeClusterSnapshots::set_end_time): <p>A time value that requests only snapshots created at or before the specified time. The time value is specified in ISO 8601 format. For more information about ISO 8601, go to the <a href="http://en.wikipedia.org/wiki/ISO_8601">ISO8601 Wikipedia page.</a> </p>  <p>Example: <code>2012-07-16T18:00:00Z</code> </p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeClusterSnapshots::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeClusterSnapshots::set_max_records): <p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. </p>  <p>Default: <code>100</code> </p>  <p>Constraints: minimum 20, maximum 100.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeClusterSnapshots::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeClusterSnapshots::set_marker): <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <code>DescribeClusterSnapshots</code> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
    ///   - [`owner_account(impl Into<String>)`](crate::client::fluent_builders::DescribeClusterSnapshots::owner_account) / [`set_owner_account(Option<String>)`](crate::client::fluent_builders::DescribeClusterSnapshots::set_owner_account): <p>The Amazon Web Services account used to create or copy the snapshot. Use this field to filter the results to snapshots owned by a particular account. To describe snapshots you own, either specify your Amazon Web Services account, or do not specify the parameter.</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::DescribeClusterSnapshots::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeClusterSnapshots::set_tag_keys): <p>A tag key or keys for which you want to return all matching cluster snapshots that are associated with the specified key or keys. For example, suppose that you have snapshots that are tagged with keys called <code>owner</code> and <code>environment</code>. If you specify both of these tag keys in the request, Amazon Redshift returns a response with the snapshots that have either or both of these tag keys associated with them.</p>
    ///   - [`tag_values(Vec<String>)`](crate::client::fluent_builders::DescribeClusterSnapshots::tag_values) / [`set_tag_values(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeClusterSnapshots::set_tag_values): <p>A tag value or values for which you want to return all matching cluster snapshots that are associated with the specified tag value or values. For example, suppose that you have snapshots that are tagged with values called <code>admin</code> and <code>test</code>. If you specify both of these tag values in the request, Amazon Redshift returns a response with the snapshots that have either or both of these tag values associated with them.</p>
    ///   - [`cluster_exists(bool)`](crate::client::fluent_builders::DescribeClusterSnapshots::cluster_exists) / [`set_cluster_exists(Option<bool>)`](crate::client::fluent_builders::DescribeClusterSnapshots::set_cluster_exists): <p>A value that indicates whether to return snapshots only for an existing cluster. You can perform table-level restore only by using a snapshot of an existing cluster, that is, a cluster that has not been deleted. Values for this parameter work as follows: </p>  <ul>   <li> <p>If <code>ClusterExists</code> is set to <code>true</code>, <code>ClusterIdentifier</code> is required.</p> </li>   <li> <p>If <code>ClusterExists</code> is set to <code>false</code> and <code>ClusterIdentifier</code> isn't specified, all snapshots associated with deleted clusters (orphaned snapshots) are returned. </p> </li>   <li> <p>If <code>ClusterExists</code> is set to <code>false</code> and <code>ClusterIdentifier</code> is specified for a deleted cluster, snapshots associated with that cluster are returned.</p> </li>   <li> <p>If <code>ClusterExists</code> is set to <code>false</code> and <code>ClusterIdentifier</code> is specified for an existing cluster, no snapshots are returned. </p> </li>  </ul>
    ///   - [`sorting_entities(Vec<SnapshotSortingEntity>)`](crate::client::fluent_builders::DescribeClusterSnapshots::sorting_entities) / [`set_sorting_entities(Option<Vec<SnapshotSortingEntity>>)`](crate::client::fluent_builders::DescribeClusterSnapshots::set_sorting_entities): <p></p>
    /// - On success, responds with [`DescribeClusterSnapshotsOutput`](crate::output::DescribeClusterSnapshotsOutput) with field(s):
    ///   - [`marker(Option<String>)`](crate::output::DescribeClusterSnapshotsOutput::marker): <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>
    ///   - [`snapshots(Option<Vec<Snapshot>>)`](crate::output::DescribeClusterSnapshotsOutput::snapshots): <p>A list of <code>Snapshot</code> instances. </p>
    /// - On failure, responds with [`SdkError<DescribeClusterSnapshotsError>`](crate::error::DescribeClusterSnapshotsError)
    pub fn describe_cluster_snapshots(&self) -> fluent_builders::DescribeClusterSnapshots {
        fluent_builders::DescribeClusterSnapshots::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeClusterSubnetGroups`](crate::client::fluent_builders::DescribeClusterSubnetGroups) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeClusterSubnetGroups::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster_subnet_group_name(impl Into<String>)`](crate::client::fluent_builders::DescribeClusterSubnetGroups::cluster_subnet_group_name) / [`set_cluster_subnet_group_name(Option<String>)`](crate::client::fluent_builders::DescribeClusterSubnetGroups::set_cluster_subnet_group_name): <p>The name of the cluster subnet group for which information is requested.</p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeClusterSubnetGroups::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeClusterSubnetGroups::set_max_records): <p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. </p>  <p>Default: <code>100</code> </p>  <p>Constraints: minimum 20, maximum 100.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeClusterSubnetGroups::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeClusterSubnetGroups::set_marker): <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <code>DescribeClusterSubnetGroups</code> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::DescribeClusterSubnetGroups::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeClusterSubnetGroups::set_tag_keys): <p>A tag key or keys for which you want to return all matching cluster subnet groups that are associated with the specified key or keys. For example, suppose that you have subnet groups that are tagged with keys called <code>owner</code> and <code>environment</code>. If you specify both of these tag keys in the request, Amazon Redshift returns a response with the subnet groups that have either or both of these tag keys associated with them.</p>
    ///   - [`tag_values(Vec<String>)`](crate::client::fluent_builders::DescribeClusterSubnetGroups::tag_values) / [`set_tag_values(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeClusterSubnetGroups::set_tag_values): <p>A tag value or values for which you want to return all matching cluster subnet groups that are associated with the specified tag value or values. For example, suppose that you have subnet groups that are tagged with values called <code>admin</code> and <code>test</code>. If you specify both of these tag values in the request, Amazon Redshift returns a response with the subnet groups that have either or both of these tag values associated with them.</p>
    /// - On success, responds with [`DescribeClusterSubnetGroupsOutput`](crate::output::DescribeClusterSubnetGroupsOutput) with field(s):
    ///   - [`marker(Option<String>)`](crate::output::DescribeClusterSubnetGroupsOutput::marker): <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>
    ///   - [`cluster_subnet_groups(Option<Vec<ClusterSubnetGroup>>)`](crate::output::DescribeClusterSubnetGroupsOutput::cluster_subnet_groups): <p>A list of <code>ClusterSubnetGroup</code> instances. </p>
    /// - On failure, responds with [`SdkError<DescribeClusterSubnetGroupsError>`](crate::error::DescribeClusterSubnetGroupsError)
    pub fn describe_cluster_subnet_groups(&self) -> fluent_builders::DescribeClusterSubnetGroups {
        fluent_builders::DescribeClusterSubnetGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeClusterTracks`](crate::client::fluent_builders::DescribeClusterTracks) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeClusterTracks::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`maintenance_track_name(impl Into<String>)`](crate::client::fluent_builders::DescribeClusterTracks::maintenance_track_name) / [`set_maintenance_track_name(Option<String>)`](crate::client::fluent_builders::DescribeClusterTracks::set_maintenance_track_name): <p>The name of the maintenance track. </p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeClusterTracks::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeClusterTracks::set_max_records): <p>An integer value for the maximum number of maintenance tracks to return.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeClusterTracks::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeClusterTracks::set_marker): <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <code>DescribeClusterTracks</code> request exceed the value specified in <code>MaxRecords</code>, Amazon Redshift returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
    /// - On success, responds with [`DescribeClusterTracksOutput`](crate::output::DescribeClusterTracksOutput) with field(s):
    ///   - [`maintenance_tracks(Option<Vec<MaintenanceTrack>>)`](crate::output::DescribeClusterTracksOutput::maintenance_tracks): <p>A list of maintenance tracks output by the <code>DescribeClusterTracks</code> operation. </p>
    ///   - [`marker(Option<String>)`](crate::output::DescribeClusterTracksOutput::marker): <p>The starting point to return a set of response tracklist records. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request.</p>
    /// - On failure, responds with [`SdkError<DescribeClusterTracksError>`](crate::error::DescribeClusterTracksError)
    pub fn describe_cluster_tracks(&self) -> fluent_builders::DescribeClusterTracks {
        fluent_builders::DescribeClusterTracks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeClusterVersions`](crate::client::fluent_builders::DescribeClusterVersions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeClusterVersions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster_version(impl Into<String>)`](crate::client::fluent_builders::DescribeClusterVersions::cluster_version) / [`set_cluster_version(Option<String>)`](crate::client::fluent_builders::DescribeClusterVersions::set_cluster_version): <p>The specific cluster version to return.</p>  <p>Example: <code>1.0</code> </p>
    ///   - [`cluster_parameter_group_family(impl Into<String>)`](crate::client::fluent_builders::DescribeClusterVersions::cluster_parameter_group_family) / [`set_cluster_parameter_group_family(Option<String>)`](crate::client::fluent_builders::DescribeClusterVersions::set_cluster_parameter_group_family): <p>The name of a specific cluster parameter group family to return details for.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must be 1 to 255 alphanumeric characters</p> </li>   <li> <p>First character must be a letter</p> </li>   <li> <p>Cannot end with a hyphen or contain two consecutive hyphens</p> </li>  </ul>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeClusterVersions::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeClusterVersions::set_max_records): <p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. </p>  <p>Default: <code>100</code> </p>  <p>Constraints: minimum 20, maximum 100.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeClusterVersions::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeClusterVersions::set_marker): <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <code>DescribeClusterVersions</code> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
    /// - On success, responds with [`DescribeClusterVersionsOutput`](crate::output::DescribeClusterVersionsOutput) with field(s):
    ///   - [`marker(Option<String>)`](crate::output::DescribeClusterVersionsOutput::marker): <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>
    ///   - [`cluster_versions(Option<Vec<ClusterVersion>>)`](crate::output::DescribeClusterVersionsOutput::cluster_versions): <p>A list of <code>Version</code> elements. </p>
    /// - On failure, responds with [`SdkError<DescribeClusterVersionsError>`](crate::error::DescribeClusterVersionsError)
    pub fn describe_cluster_versions(&self) -> fluent_builders::DescribeClusterVersions {
        fluent_builders::DescribeClusterVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeDataShares`](crate::client::fluent_builders::DescribeDataShares) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeDataShares::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`data_share_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeDataShares::data_share_arn) / [`set_data_share_arn(Option<String>)`](crate::client::fluent_builders::DescribeDataShares::set_data_share_arn): <p>The identifier of the datashare to describe details of.</p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeDataShares::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeDataShares::set_max_records): <p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. </p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeDataShares::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeDataShares::set_marker): <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <code>DescribeDataShares</code> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
    /// - On success, responds with [`DescribeDataSharesOutput`](crate::output::DescribeDataSharesOutput) with field(s):
    ///   - [`data_shares(Option<Vec<DataShare>>)`](crate::output::DescribeDataSharesOutput::data_shares): <p>The results returned from describing datashares.</p>
    ///   - [`marker(Option<String>)`](crate::output::DescribeDataSharesOutput::marker): <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <code>DescribeDataShares</code> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
    /// - On failure, responds with [`SdkError<DescribeDataSharesError>`](crate::error::DescribeDataSharesError)
    pub fn describe_data_shares(&self) -> fluent_builders::DescribeDataShares {
        fluent_builders::DescribeDataShares::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeDataSharesForConsumer`](crate::client::fluent_builders::DescribeDataSharesForConsumer) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeDataSharesForConsumer::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`consumer_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeDataSharesForConsumer::consumer_arn) / [`set_consumer_arn(Option<String>)`](crate::client::fluent_builders::DescribeDataSharesForConsumer::set_consumer_arn): <p>The Amazon Resource Name (ARN) of the consumer that returns in the list of datashares.</p>
    ///   - [`status(DataShareStatusForConsumer)`](crate::client::fluent_builders::DescribeDataSharesForConsumer::status) / [`set_status(Option<DataShareStatusForConsumer>)`](crate::client::fluent_builders::DescribeDataSharesForConsumer::set_status): <p>An identifier giving the status of a datashare in the consumer cluster. If this field is specified, Amazon Redshift returns the list of datashares that have the specified status.</p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeDataSharesForConsumer::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeDataSharesForConsumer::set_max_records): <p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. </p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeDataSharesForConsumer::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeDataSharesForConsumer::set_marker): <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <code>DescribeDataSharesForConsumer</code> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
    /// - On success, responds with [`DescribeDataSharesForConsumerOutput`](crate::output::DescribeDataSharesForConsumerOutput) with field(s):
    ///   - [`data_shares(Option<Vec<DataShare>>)`](crate::output::DescribeDataSharesForConsumerOutput::data_shares): <p>Shows the results of datashares available for consumers.</p>
    ///   - [`marker(Option<String>)`](crate::output::DescribeDataSharesForConsumerOutput::marker): <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <code>DescribeDataSharesForConsumer</code> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
    /// - On failure, responds with [`SdkError<DescribeDataSharesForConsumerError>`](crate::error::DescribeDataSharesForConsumerError)
    pub fn describe_data_shares_for_consumer(
        &self,
    ) -> fluent_builders::DescribeDataSharesForConsumer {
        fluent_builders::DescribeDataSharesForConsumer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeDataSharesForProducer`](crate::client::fluent_builders::DescribeDataSharesForProducer) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeDataSharesForProducer::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`producer_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeDataSharesForProducer::producer_arn) / [`set_producer_arn(Option<String>)`](crate::client::fluent_builders::DescribeDataSharesForProducer::set_producer_arn): <p>The Amazon Resource Name (ARN) of the producer that returns in the list of datashares.</p>
    ///   - [`status(DataShareStatusForProducer)`](crate::client::fluent_builders::DescribeDataSharesForProducer::status) / [`set_status(Option<DataShareStatusForProducer>)`](crate::client::fluent_builders::DescribeDataSharesForProducer::set_status): <p>An identifier giving the status of a datashare in the producer. If this field is specified, Amazon Redshift returns the list of datashares that have the specified status.</p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeDataSharesForProducer::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeDataSharesForProducer::set_max_records): <p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. </p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeDataSharesForProducer::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeDataSharesForProducer::set_marker): <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <code>DescribeDataSharesForProducer</code> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
    /// - On success, responds with [`DescribeDataSharesForProducerOutput`](crate::output::DescribeDataSharesForProducerOutput) with field(s):
    ///   - [`data_shares(Option<Vec<DataShare>>)`](crate::output::DescribeDataSharesForProducerOutput::data_shares): <p>Shows the results of datashares available for producers.</p>
    ///   - [`marker(Option<String>)`](crate::output::DescribeDataSharesForProducerOutput::marker): <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <code>DescribeDataSharesForProducer</code> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
    /// - On failure, responds with [`SdkError<DescribeDataSharesForProducerError>`](crate::error::DescribeDataSharesForProducerError)
    pub fn describe_data_shares_for_producer(
        &self,
    ) -> fluent_builders::DescribeDataSharesForProducer {
        fluent_builders::DescribeDataSharesForProducer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeDefaultClusterParameters`](crate::client::fluent_builders::DescribeDefaultClusterParameters) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeDefaultClusterParameters::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`parameter_group_family(impl Into<String>)`](crate::client::fluent_builders::DescribeDefaultClusterParameters::parameter_group_family) / [`set_parameter_group_family(Option<String>)`](crate::client::fluent_builders::DescribeDefaultClusterParameters::set_parameter_group_family): <p>The name of the cluster parameter group family.</p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeDefaultClusterParameters::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeDefaultClusterParameters::set_max_records): <p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. </p>  <p>Default: <code>100</code> </p>  <p>Constraints: minimum 20, maximum 100.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeDefaultClusterParameters::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeDefaultClusterParameters::set_marker): <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <code>DescribeDefaultClusterParameters</code> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
    /// - On success, responds with [`DescribeDefaultClusterParametersOutput`](crate::output::DescribeDefaultClusterParametersOutput) with field(s):
    ///   - [`default_cluster_parameters(Option<DefaultClusterParameters>)`](crate::output::DescribeDefaultClusterParametersOutput::default_cluster_parameters): <p>Describes the default cluster parameters for a parameter group family.</p>
    /// - On failure, responds with [`SdkError<DescribeDefaultClusterParametersError>`](crate::error::DescribeDefaultClusterParametersError)
    pub fn describe_default_cluster_parameters(
        &self,
    ) -> fluent_builders::DescribeDefaultClusterParameters {
        fluent_builders::DescribeDefaultClusterParameters::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeEndpointAccess`](crate::client::fluent_builders::DescribeEndpointAccess) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeEndpointAccess::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster_identifier(impl Into<String>)`](crate::client::fluent_builders::DescribeEndpointAccess::cluster_identifier) / [`set_cluster_identifier(Option<String>)`](crate::client::fluent_builders::DescribeEndpointAccess::set_cluster_identifier): <p>The cluster identifier associated with the described endpoint.</p>
    ///   - [`resource_owner(impl Into<String>)`](crate::client::fluent_builders::DescribeEndpointAccess::resource_owner) / [`set_resource_owner(Option<String>)`](crate::client::fluent_builders::DescribeEndpointAccess::set_resource_owner): <p>The Amazon Web Services account ID of the owner of the cluster.</p>
    ///   - [`endpoint_name(impl Into<String>)`](crate::client::fluent_builders::DescribeEndpointAccess::endpoint_name) / [`set_endpoint_name(Option<String>)`](crate::client::fluent_builders::DescribeEndpointAccess::set_endpoint_name): <p>The name of the endpoint to be described.</p>
    ///   - [`vpc_id(impl Into<String>)`](crate::client::fluent_builders::DescribeEndpointAccess::vpc_id) / [`set_vpc_id(Option<String>)`](crate::client::fluent_builders::DescribeEndpointAccess::set_vpc_id): <p>The virtual private cloud (VPC) identifier with access to the cluster.</p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeEndpointAccess::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeEndpointAccess::set_max_records): <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a <code>Marker</code> is included in the response so that the remaining results can be retrieved.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeEndpointAccess::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeEndpointAccess::set_marker): <p>An optional pagination token provided by a previous <code>DescribeEndpointAccess</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by the <code>MaxRecords</code> parameter.</p>
    /// - On success, responds with [`DescribeEndpointAccessOutput`](crate::output::DescribeEndpointAccessOutput) with field(s):
    ///   - [`endpoint_access_list(Option<Vec<EndpointAccess>>)`](crate::output::DescribeEndpointAccessOutput::endpoint_access_list): <p>The list of endpoints with access to the cluster.</p>
    ///   - [`marker(Option<String>)`](crate::output::DescribeEndpointAccessOutput::marker): <p>An optional pagination token provided by a previous <code>DescribeEndpointAccess</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by the <code>MaxRecords</code> parameter.</p>
    /// - On failure, responds with [`SdkError<DescribeEndpointAccessError>`](crate::error::DescribeEndpointAccessError)
    pub fn describe_endpoint_access(&self) -> fluent_builders::DescribeEndpointAccess {
        fluent_builders::DescribeEndpointAccess::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeEndpointAuthorization`](crate::client::fluent_builders::DescribeEndpointAuthorization) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeEndpointAuthorization::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster_identifier(impl Into<String>)`](crate::client::fluent_builders::DescribeEndpointAuthorization::cluster_identifier) / [`set_cluster_identifier(Option<String>)`](crate::client::fluent_builders::DescribeEndpointAuthorization::set_cluster_identifier): <p>The cluster identifier of the cluster to access.</p>
    ///   - [`account(impl Into<String>)`](crate::client::fluent_builders::DescribeEndpointAuthorization::account) / [`set_account(Option<String>)`](crate::client::fluent_builders::DescribeEndpointAuthorization::set_account): <p>The AAmazon Web Services account ID of either the cluster owner (grantor) or grantee. If <code>Grantee</code> parameter is true, then the <code>Account</code> value is of the grantor.</p>
    ///   - [`grantee(bool)`](crate::client::fluent_builders::DescribeEndpointAuthorization::grantee) / [`set_grantee(Option<bool>)`](crate::client::fluent_builders::DescribeEndpointAuthorization::set_grantee): <p>Indicates whether to check authorization from a grantor or grantee point of view. If true, Amazon Redshift returns endpoint authorizations that you've been granted. If false (default), checks authorization from a grantor point of view.</p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeEndpointAuthorization::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeEndpointAuthorization::set_max_records): <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a <code>Marker</code> is included in the response so that the remaining results can be retrieved.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeEndpointAuthorization::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeEndpointAuthorization::set_marker): <p>An optional pagination token provided by a previous <code>DescribeEndpointAuthorization</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by the <code>MaxRecords</code> parameter.</p>
    /// - On success, responds with [`DescribeEndpointAuthorizationOutput`](crate::output::DescribeEndpointAuthorizationOutput) with field(s):
    ///   - [`endpoint_authorization_list(Option<Vec<EndpointAuthorization>>)`](crate::output::DescribeEndpointAuthorizationOutput::endpoint_authorization_list): <p>The authorizations to an endpoint.</p>
    ///   - [`marker(Option<String>)`](crate::output::DescribeEndpointAuthorizationOutput::marker): <p>An optional pagination token provided by a previous <code>DescribeEndpointAuthorization</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by the <code>MaxRecords</code> parameter.</p>
    /// - On failure, responds with [`SdkError<DescribeEndpointAuthorizationError>`](crate::error::DescribeEndpointAuthorizationError)
    pub fn describe_endpoint_authorization(
        &self,
    ) -> fluent_builders::DescribeEndpointAuthorization {
        fluent_builders::DescribeEndpointAuthorization::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeEventCategories`](crate::client::fluent_builders::DescribeEventCategories) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`source_type(impl Into<String>)`](crate::client::fluent_builders::DescribeEventCategories::source_type) / [`set_source_type(Option<String>)`](crate::client::fluent_builders::DescribeEventCategories::set_source_type): <p>The source type, such as cluster or parameter group, to which the described event categories apply.</p>  <p>Valid values: cluster, cluster-snapshot, cluster-parameter-group, cluster-security-group, and scheduled-action.</p>
    /// - On success, responds with [`DescribeEventCategoriesOutput`](crate::output::DescribeEventCategoriesOutput) with field(s):
    ///   - [`event_categories_map_list(Option<Vec<EventCategoriesMap>>)`](crate::output::DescribeEventCategoriesOutput::event_categories_map_list): <p>A list of event categories descriptions.</p>
    /// - On failure, responds with [`SdkError<DescribeEventCategoriesError>`](crate::error::DescribeEventCategoriesError)
    pub fn describe_event_categories(&self) -> fluent_builders::DescribeEventCategories {
        fluent_builders::DescribeEventCategories::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeEvents`](crate::client::fluent_builders::DescribeEvents) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeEvents::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`source_identifier(impl Into<String>)`](crate::client::fluent_builders::DescribeEvents::source_identifier) / [`set_source_identifier(Option<String>)`](crate::client::fluent_builders::DescribeEvents::set_source_identifier): <p>The identifier of the event source for which events will be returned. If this parameter is not specified, then all sources are included in the response.</p>  <p>Constraints:</p>  <p>If <i>SourceIdentifier</i> is supplied, <i>SourceType</i> must also be provided.</p>  <ul>   <li> <p>Specify a cluster identifier when <i>SourceType</i> is <code>cluster</code>.</p> </li>   <li> <p>Specify a cluster security group name when <i>SourceType</i> is <code>cluster-security-group</code>.</p> </li>   <li> <p>Specify a cluster parameter group name when <i>SourceType</i> is <code>cluster-parameter-group</code>.</p> </li>   <li> <p>Specify a cluster snapshot identifier when <i>SourceType</i> is <code>cluster-snapshot</code>.</p> </li>  </ul>
    ///   - [`source_type(SourceType)`](crate::client::fluent_builders::DescribeEvents::source_type) / [`set_source_type(Option<SourceType>)`](crate::client::fluent_builders::DescribeEvents::set_source_type): <p>The event source to retrieve events for. If no value is specified, all events are returned.</p>  <p>Constraints:</p>  <p>If <i>SourceType</i> is supplied, <i>SourceIdentifier</i> must also be provided.</p>  <ul>   <li> <p>Specify <code>cluster</code> when <i>SourceIdentifier</i> is a cluster identifier.</p> </li>   <li> <p>Specify <code>cluster-security-group</code> when <i>SourceIdentifier</i> is a cluster security group name.</p> </li>   <li> <p>Specify <code>cluster-parameter-group</code> when <i>SourceIdentifier</i> is a cluster parameter group name.</p> </li>   <li> <p>Specify <code>cluster-snapshot</code> when <i>SourceIdentifier</i> is a cluster snapshot identifier.</p> </li>  </ul>
    ///   - [`start_time(DateTime)`](crate::client::fluent_builders::DescribeEvents::start_time) / [`set_start_time(Option<DateTime>)`](crate::client::fluent_builders::DescribeEvents::set_start_time): <p>The beginning of the time interval to retrieve events for, specified in ISO 8601 format. For more information about ISO 8601, go to the <a href="http://en.wikipedia.org/wiki/ISO_8601">ISO8601 Wikipedia page.</a> </p>  <p>Example: <code>2009-07-08T18:00Z</code> </p>
    ///   - [`end_time(DateTime)`](crate::client::fluent_builders::DescribeEvents::end_time) / [`set_end_time(Option<DateTime>)`](crate::client::fluent_builders::DescribeEvents::set_end_time): <p>The end of the time interval for which to retrieve events, specified in ISO 8601 format. For more information about ISO 8601, go to the <a href="http://en.wikipedia.org/wiki/ISO_8601">ISO8601 Wikipedia page.</a> </p>  <p>Example: <code>2009-07-08T18:00Z</code> </p>
    ///   - [`duration(i32)`](crate::client::fluent_builders::DescribeEvents::duration) / [`set_duration(Option<i32>)`](crate::client::fluent_builders::DescribeEvents::set_duration): <p>The number of minutes prior to the time of the request for which to retrieve events. For example, if the request is sent at 18:00 and you specify a duration of 60, then only events which have occurred after 17:00 will be returned.</p>  <p>Default: <code>60</code> </p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeEvents::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeEvents::set_max_records): <p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. </p>  <p>Default: <code>100</code> </p>  <p>Constraints: minimum 20, maximum 100.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeEvents::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeEvents::set_marker): <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <code>DescribeEvents</code> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
    /// - On success, responds with [`DescribeEventsOutput`](crate::output::DescribeEventsOutput) with field(s):
    ///   - [`marker(Option<String>)`](crate::output::DescribeEventsOutput::marker): <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>
    ///   - [`events(Option<Vec<Event>>)`](crate::output::DescribeEventsOutput::events): <p>A list of <code>Event</code> instances. </p>
    /// - On failure, responds with [`SdkError<DescribeEventsError>`](crate::error::DescribeEventsError)
    pub fn describe_events(&self) -> fluent_builders::DescribeEvents {
        fluent_builders::DescribeEvents::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeEventSubscriptions`](crate::client::fluent_builders::DescribeEventSubscriptions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeEventSubscriptions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`subscription_name(impl Into<String>)`](crate::client::fluent_builders::DescribeEventSubscriptions::subscription_name) / [`set_subscription_name(Option<String>)`](crate::client::fluent_builders::DescribeEventSubscriptions::set_subscription_name): <p>The name of the Amazon Redshift event notification subscription to be described.</p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeEventSubscriptions::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeEventSubscriptions::set_max_records): <p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. </p>  <p>Default: <code>100</code> </p>  <p>Constraints: minimum 20, maximum 100.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeEventSubscriptions::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeEventSubscriptions::set_marker): <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a DescribeEventSubscriptions request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::DescribeEventSubscriptions::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeEventSubscriptions::set_tag_keys): <p>A tag key or keys for which you want to return all matching event notification subscriptions that are associated with the specified key or keys. For example, suppose that you have subscriptions that are tagged with keys called <code>owner</code> and <code>environment</code>. If you specify both of these tag keys in the request, Amazon Redshift returns a response with the subscriptions that have either or both of these tag keys associated with them.</p>
    ///   - [`tag_values(Vec<String>)`](crate::client::fluent_builders::DescribeEventSubscriptions::tag_values) / [`set_tag_values(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeEventSubscriptions::set_tag_values): <p>A tag value or values for which you want to return all matching event notification subscriptions that are associated with the specified tag value or values. For example, suppose that you have subscriptions that are tagged with values called <code>admin</code> and <code>test</code>. If you specify both of these tag values in the request, Amazon Redshift returns a response with the subscriptions that have either or both of these tag values associated with them.</p>
    /// - On success, responds with [`DescribeEventSubscriptionsOutput`](crate::output::DescribeEventSubscriptionsOutput) with field(s):
    ///   - [`marker(Option<String>)`](crate::output::DescribeEventSubscriptionsOutput::marker): <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>
    ///   - [`event_subscriptions_list(Option<Vec<EventSubscription>>)`](crate::output::DescribeEventSubscriptionsOutput::event_subscriptions_list): <p>A list of event subscriptions.</p>
    /// - On failure, responds with [`SdkError<DescribeEventSubscriptionsError>`](crate::error::DescribeEventSubscriptionsError)
    pub fn describe_event_subscriptions(&self) -> fluent_builders::DescribeEventSubscriptions {
        fluent_builders::DescribeEventSubscriptions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeHsmClientCertificates`](crate::client::fluent_builders::DescribeHsmClientCertificates) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeHsmClientCertificates::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`hsm_client_certificate_identifier(impl Into<String>)`](crate::client::fluent_builders::DescribeHsmClientCertificates::hsm_client_certificate_identifier) / [`set_hsm_client_certificate_identifier(Option<String>)`](crate::client::fluent_builders::DescribeHsmClientCertificates::set_hsm_client_certificate_identifier): <p>The identifier of a specific HSM client certificate for which you want information. If no identifier is specified, information is returned for all HSM client certificates owned by your Amazon Web Services account.</p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeHsmClientCertificates::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeHsmClientCertificates::set_max_records): <p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. </p>  <p>Default: <code>100</code> </p>  <p>Constraints: minimum 20, maximum 100.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeHsmClientCertificates::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeHsmClientCertificates::set_marker): <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <code>DescribeHsmClientCertificates</code> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::DescribeHsmClientCertificates::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeHsmClientCertificates::set_tag_keys): <p>A tag key or keys for which you want to return all matching HSM client certificates that are associated with the specified key or keys. For example, suppose that you have HSM client certificates that are tagged with keys called <code>owner</code> and <code>environment</code>. If you specify both of these tag keys in the request, Amazon Redshift returns a response with the HSM client certificates that have either or both of these tag keys associated with them.</p>
    ///   - [`tag_values(Vec<String>)`](crate::client::fluent_builders::DescribeHsmClientCertificates::tag_values) / [`set_tag_values(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeHsmClientCertificates::set_tag_values): <p>A tag value or values for which you want to return all matching HSM client certificates that are associated with the specified tag value or values. For example, suppose that you have HSM client certificates that are tagged with values called <code>admin</code> and <code>test</code>. If you specify both of these tag values in the request, Amazon Redshift returns a response with the HSM client certificates that have either or both of these tag values associated with them.</p>
    /// - On success, responds with [`DescribeHsmClientCertificatesOutput`](crate::output::DescribeHsmClientCertificatesOutput) with field(s):
    ///   - [`marker(Option<String>)`](crate::output::DescribeHsmClientCertificatesOutput::marker): <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>
    ///   - [`hsm_client_certificates(Option<Vec<HsmClientCertificate>>)`](crate::output::DescribeHsmClientCertificatesOutput::hsm_client_certificates): <p>A list of the identifiers for one or more HSM client certificates used by Amazon Redshift clusters to store and retrieve database encryption keys in an HSM.</p>
    /// - On failure, responds with [`SdkError<DescribeHsmClientCertificatesError>`](crate::error::DescribeHsmClientCertificatesError)
    pub fn describe_hsm_client_certificates(
        &self,
    ) -> fluent_builders::DescribeHsmClientCertificates {
        fluent_builders::DescribeHsmClientCertificates::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeHsmConfigurations`](crate::client::fluent_builders::DescribeHsmConfigurations) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeHsmConfigurations::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`hsm_configuration_identifier(impl Into<String>)`](crate::client::fluent_builders::DescribeHsmConfigurations::hsm_configuration_identifier) / [`set_hsm_configuration_identifier(Option<String>)`](crate::client::fluent_builders::DescribeHsmConfigurations::set_hsm_configuration_identifier): <p>The identifier of a specific Amazon Redshift HSM configuration to be described. If no identifier is specified, information is returned for all HSM configurations owned by your Amazon Web Services account.</p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeHsmConfigurations::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeHsmConfigurations::set_max_records): <p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. </p>  <p>Default: <code>100</code> </p>  <p>Constraints: minimum 20, maximum 100.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeHsmConfigurations::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeHsmConfigurations::set_marker): <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <code>DescribeHsmConfigurations</code> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::DescribeHsmConfigurations::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeHsmConfigurations::set_tag_keys): <p>A tag key or keys for which you want to return all matching HSM configurations that are associated with the specified key or keys. For example, suppose that you have HSM configurations that are tagged with keys called <code>owner</code> and <code>environment</code>. If you specify both of these tag keys in the request, Amazon Redshift returns a response with the HSM configurations that have either or both of these tag keys associated with them.</p>
    ///   - [`tag_values(Vec<String>)`](crate::client::fluent_builders::DescribeHsmConfigurations::tag_values) / [`set_tag_values(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeHsmConfigurations::set_tag_values): <p>A tag value or values for which you want to return all matching HSM configurations that are associated with the specified tag value or values. For example, suppose that you have HSM configurations that are tagged with values called <code>admin</code> and <code>test</code>. If you specify both of these tag values in the request, Amazon Redshift returns a response with the HSM configurations that have either or both of these tag values associated with them.</p>
    /// - On success, responds with [`DescribeHsmConfigurationsOutput`](crate::output::DescribeHsmConfigurationsOutput) with field(s):
    ///   - [`marker(Option<String>)`](crate::output::DescribeHsmConfigurationsOutput::marker): <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>
    ///   - [`hsm_configurations(Option<Vec<HsmConfiguration>>)`](crate::output::DescribeHsmConfigurationsOutput::hsm_configurations): <p>A list of <code>HsmConfiguration</code> objects.</p>
    /// - On failure, responds with [`SdkError<DescribeHsmConfigurationsError>`](crate::error::DescribeHsmConfigurationsError)
    pub fn describe_hsm_configurations(&self) -> fluent_builders::DescribeHsmConfigurations {
        fluent_builders::DescribeHsmConfigurations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeLoggingStatus`](crate::client::fluent_builders::DescribeLoggingStatus) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster_identifier(impl Into<String>)`](crate::client::fluent_builders::DescribeLoggingStatus::cluster_identifier) / [`set_cluster_identifier(Option<String>)`](crate::client::fluent_builders::DescribeLoggingStatus::set_cluster_identifier): <p>The identifier of the cluster from which to get the logging status.</p>  <p>Example: <code>examplecluster</code> </p>
    /// - On success, responds with [`DescribeLoggingStatusOutput`](crate::output::DescribeLoggingStatusOutput) with field(s):
    ///   - [`logging_enabled(bool)`](crate::output::DescribeLoggingStatusOutput::logging_enabled): <p> <code>true</code> if logging is on, <code>false</code> if logging is off.</p>
    ///   - [`bucket_name(Option<String>)`](crate::output::DescribeLoggingStatusOutput::bucket_name): <p>The name of the S3 bucket where the log files are stored.</p>
    ///   - [`s3_key_prefix(Option<String>)`](crate::output::DescribeLoggingStatusOutput::s3_key_prefix): <p>The prefix applied to the log file names.</p>
    ///   - [`last_successful_delivery_time(Option<DateTime>)`](crate::output::DescribeLoggingStatusOutput::last_successful_delivery_time): <p>The last time that logs were delivered.</p>
    ///   - [`last_failure_time(Option<DateTime>)`](crate::output::DescribeLoggingStatusOutput::last_failure_time): <p>The last time when logs failed to be delivered.</p>
    ///   - [`last_failure_message(Option<String>)`](crate::output::DescribeLoggingStatusOutput::last_failure_message): <p>The message indicating that logs failed to be delivered.</p>
    /// - On failure, responds with [`SdkError<DescribeLoggingStatusError>`](crate::error::DescribeLoggingStatusError)
    pub fn describe_logging_status(&self) -> fluent_builders::DescribeLoggingStatus {
        fluent_builders::DescribeLoggingStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeNodeConfigurationOptions`](crate::client::fluent_builders::DescribeNodeConfigurationOptions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeNodeConfigurationOptions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`action_type(ActionType)`](crate::client::fluent_builders::DescribeNodeConfigurationOptions::action_type) / [`set_action_type(Option<ActionType>)`](crate::client::fluent_builders::DescribeNodeConfigurationOptions::set_action_type): <p>The action type to evaluate for possible node configurations. Specify "restore-cluster" to get configuration combinations based on an existing snapshot. Specify "recommend-node-config" to get configuration recommendations based on an existing cluster or snapshot. Specify "resize-cluster" to get configuration combinations for elastic resize based on an existing cluster. </p>
    ///   - [`cluster_identifier(impl Into<String>)`](crate::client::fluent_builders::DescribeNodeConfigurationOptions::cluster_identifier) / [`set_cluster_identifier(Option<String>)`](crate::client::fluent_builders::DescribeNodeConfigurationOptions::set_cluster_identifier): <p>The identifier of the cluster to evaluate for possible node configurations.</p>
    ///   - [`snapshot_identifier(impl Into<String>)`](crate::client::fluent_builders::DescribeNodeConfigurationOptions::snapshot_identifier) / [`set_snapshot_identifier(Option<String>)`](crate::client::fluent_builders::DescribeNodeConfigurationOptions::set_snapshot_identifier): <p>The identifier of the snapshot to evaluate for possible node configurations.</p>
    ///   - [`owner_account(impl Into<String>)`](crate::client::fluent_builders::DescribeNodeConfigurationOptions::owner_account) / [`set_owner_account(Option<String>)`](crate::client::fluent_builders::DescribeNodeConfigurationOptions::set_owner_account): <p>The Amazon Web Services account used to create or copy the snapshot. Required if you are restoring a snapshot you do not own, optional if you own the snapshot.</p>
    ///   - [`filters(Vec<NodeConfigurationOptionsFilter>)`](crate::client::fluent_builders::DescribeNodeConfigurationOptions::filters) / [`set_filters(Option<Vec<NodeConfigurationOptionsFilter>>)`](crate::client::fluent_builders::DescribeNodeConfigurationOptions::set_filters): <p>A set of name, operator, and value items to filter the results.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeNodeConfigurationOptions::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeNodeConfigurationOptions::set_marker): <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <code>DescribeNodeConfigurationOptions</code> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeNodeConfigurationOptions::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeNodeConfigurationOptions::set_max_records): <p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. </p>  <p>Default: <code>500</code> </p>  <p>Constraints: minimum 100, maximum 500.</p>
    /// - On success, responds with [`DescribeNodeConfigurationOptionsOutput`](crate::output::DescribeNodeConfigurationOptionsOutput) with field(s):
    ///   - [`node_configuration_option_list(Option<Vec<NodeConfigurationOption>>)`](crate::output::DescribeNodeConfigurationOptionsOutput::node_configuration_option_list): <p>A list of valid node configurations.</p>
    ///   - [`marker(Option<String>)`](crate::output::DescribeNodeConfigurationOptionsOutput::marker): <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>
    /// - On failure, responds with [`SdkError<DescribeNodeConfigurationOptionsError>`](crate::error::DescribeNodeConfigurationOptionsError)
    pub fn describe_node_configuration_options(
        &self,
    ) -> fluent_builders::DescribeNodeConfigurationOptions {
        fluent_builders::DescribeNodeConfigurationOptions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeOrderableClusterOptions`](crate::client::fluent_builders::DescribeOrderableClusterOptions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeOrderableClusterOptions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster_version(impl Into<String>)`](crate::client::fluent_builders::DescribeOrderableClusterOptions::cluster_version) / [`set_cluster_version(Option<String>)`](crate::client::fluent_builders::DescribeOrderableClusterOptions::set_cluster_version): <p>The version filter value. Specify this parameter to show only the available offerings matching the specified version.</p>  <p>Default: All versions.</p>  <p>Constraints: Must be one of the version returned from <code>DescribeClusterVersions</code>.</p>
    ///   - [`node_type(impl Into<String>)`](crate::client::fluent_builders::DescribeOrderableClusterOptions::node_type) / [`set_node_type(Option<String>)`](crate::client::fluent_builders::DescribeOrderableClusterOptions::set_node_type): <p>The node type filter value. Specify this parameter to show only the available offerings matching the specified node type.</p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeOrderableClusterOptions::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeOrderableClusterOptions::set_max_records): <p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. </p>  <p>Default: <code>100</code> </p>  <p>Constraints: minimum 20, maximum 100.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeOrderableClusterOptions::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeOrderableClusterOptions::set_marker): <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <code>DescribeOrderableClusterOptions</code> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
    /// - On success, responds with [`DescribeOrderableClusterOptionsOutput`](crate::output::DescribeOrderableClusterOptionsOutput) with field(s):
    ///   - [`orderable_cluster_options(Option<Vec<OrderableClusterOption>>)`](crate::output::DescribeOrderableClusterOptionsOutput::orderable_cluster_options): <p>An <code>OrderableClusterOption</code> structure containing information about orderable options for the cluster.</p>
    ///   - [`marker(Option<String>)`](crate::output::DescribeOrderableClusterOptionsOutput::marker): <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>
    /// - On failure, responds with [`SdkError<DescribeOrderableClusterOptionsError>`](crate::error::DescribeOrderableClusterOptionsError)
    pub fn describe_orderable_cluster_options(
        &self,
    ) -> fluent_builders::DescribeOrderableClusterOptions {
        fluent_builders::DescribeOrderableClusterOptions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribePartners`](crate::client::fluent_builders::DescribePartners) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::DescribePartners::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::DescribePartners::set_account_id): <p>The Amazon Web Services account ID that owns the cluster.</p>
    ///   - [`cluster_identifier(impl Into<String>)`](crate::client::fluent_builders::DescribePartners::cluster_identifier) / [`set_cluster_identifier(Option<String>)`](crate::client::fluent_builders::DescribePartners::set_cluster_identifier): <p>The cluster identifier of the cluster whose partner integration is being described.</p>
    ///   - [`database_name(impl Into<String>)`](crate::client::fluent_builders::DescribePartners::database_name) / [`set_database_name(Option<String>)`](crate::client::fluent_builders::DescribePartners::set_database_name): <p>The name of the database whose partner integration is being described. If database name is not specified, then all databases in the cluster are described.</p>
    ///   - [`partner_name(impl Into<String>)`](crate::client::fluent_builders::DescribePartners::partner_name) / [`set_partner_name(Option<String>)`](crate::client::fluent_builders::DescribePartners::set_partner_name): <p>The name of the partner that is being described. If partner name is not specified, then all partner integrations are described.</p>
    /// - On success, responds with [`DescribePartnersOutput`](crate::output::DescribePartnersOutput) with field(s):
    ///   - [`partner_integration_info_list(Option<Vec<PartnerIntegrationInfo>>)`](crate::output::DescribePartnersOutput::partner_integration_info_list): <p>A list of partner integrations.</p>
    /// - On failure, responds with [`SdkError<DescribePartnersError>`](crate::error::DescribePartnersError)
    pub fn describe_partners(&self) -> fluent_builders::DescribePartners {
        fluent_builders::DescribePartners::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeReservedNodeExchangeStatus`](crate::client::fluent_builders::DescribeReservedNodeExchangeStatus) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeReservedNodeExchangeStatus::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`reserved_node_id(impl Into<String>)`](crate::client::fluent_builders::DescribeReservedNodeExchangeStatus::reserved_node_id) / [`set_reserved_node_id(Option<String>)`](crate::client::fluent_builders::DescribeReservedNodeExchangeStatus::set_reserved_node_id): <p>The identifier of the source reserved node in a reserved-node exchange request.</p>
    ///   - [`reserved_node_exchange_request_id(impl Into<String>)`](crate::client::fluent_builders::DescribeReservedNodeExchangeStatus::reserved_node_exchange_request_id) / [`set_reserved_node_exchange_request_id(Option<String>)`](crate::client::fluent_builders::DescribeReservedNodeExchangeStatus::set_reserved_node_exchange_request_id): <p>The identifier of the reserved-node exchange request.</p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeReservedNodeExchangeStatus::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeReservedNodeExchangeStatus::set_max_records): <p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>Marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeReservedNodeExchangeStatus::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeReservedNodeExchangeStatus::set_marker): <p>An optional pagination token provided by a previous <code>DescribeReservedNodeExchangeStatus</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by the <code>MaxRecords</code> parameter. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request.</p>
    /// - On success, responds with [`DescribeReservedNodeExchangeStatusOutput`](crate::output::DescribeReservedNodeExchangeStatusOutput) with field(s):
    ///   - [`reserved_node_exchange_status_details(Option<Vec<ReservedNodeExchangeStatus>>)`](crate::output::DescribeReservedNodeExchangeStatusOutput::reserved_node_exchange_status_details): <p>The details of the reserved-node exchange request, including the status, request time, source reserved-node identifier, and additional details.</p>
    ///   - [`marker(Option<String>)`](crate::output::DescribeReservedNodeExchangeStatusOutput::marker): <p>A pagination token provided by a previous <code>DescribeReservedNodeExchangeStatus</code> request.</p>
    /// - On failure, responds with [`SdkError<DescribeReservedNodeExchangeStatusError>`](crate::error::DescribeReservedNodeExchangeStatusError)
    pub fn describe_reserved_node_exchange_status(
        &self,
    ) -> fluent_builders::DescribeReservedNodeExchangeStatus {
        fluent_builders::DescribeReservedNodeExchangeStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeReservedNodeOfferings`](crate::client::fluent_builders::DescribeReservedNodeOfferings) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeReservedNodeOfferings::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`reserved_node_offering_id(impl Into<String>)`](crate::client::fluent_builders::DescribeReservedNodeOfferings::reserved_node_offering_id) / [`set_reserved_node_offering_id(Option<String>)`](crate::client::fluent_builders::DescribeReservedNodeOfferings::set_reserved_node_offering_id): <p>The unique identifier for the offering.</p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeReservedNodeOfferings::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeReservedNodeOfferings::set_max_records): <p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. </p>  <p>Default: <code>100</code> </p>  <p>Constraints: minimum 20, maximum 100.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeReservedNodeOfferings::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeReservedNodeOfferings::set_marker): <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <code>DescribeReservedNodeOfferings</code> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
    /// - On success, responds with [`DescribeReservedNodeOfferingsOutput`](crate::output::DescribeReservedNodeOfferingsOutput) with field(s):
    ///   - [`marker(Option<String>)`](crate::output::DescribeReservedNodeOfferingsOutput::marker): <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>
    ///   - [`reserved_node_offerings(Option<Vec<ReservedNodeOffering>>)`](crate::output::DescribeReservedNodeOfferingsOutput::reserved_node_offerings): <p>A list of <code>ReservedNodeOffering</code> objects.</p>
    /// - On failure, responds with [`SdkError<DescribeReservedNodeOfferingsError>`](crate::error::DescribeReservedNodeOfferingsError)
    pub fn describe_reserved_node_offerings(
        &self,
    ) -> fluent_builders::DescribeReservedNodeOfferings {
        fluent_builders::DescribeReservedNodeOfferings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeReservedNodes`](crate::client::fluent_builders::DescribeReservedNodes) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeReservedNodes::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`reserved_node_id(impl Into<String>)`](crate::client::fluent_builders::DescribeReservedNodes::reserved_node_id) / [`set_reserved_node_id(Option<String>)`](crate::client::fluent_builders::DescribeReservedNodes::set_reserved_node_id): <p>Identifier for the node reservation.</p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeReservedNodes::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeReservedNodes::set_max_records): <p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. </p>  <p>Default: <code>100</code> </p>  <p>Constraints: minimum 20, maximum 100.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeReservedNodes::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeReservedNodes::set_marker): <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <code>DescribeReservedNodes</code> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
    /// - On success, responds with [`DescribeReservedNodesOutput`](crate::output::DescribeReservedNodesOutput) with field(s):
    ///   - [`marker(Option<String>)`](crate::output::DescribeReservedNodesOutput::marker): <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>
    ///   - [`reserved_nodes(Option<Vec<ReservedNode>>)`](crate::output::DescribeReservedNodesOutput::reserved_nodes): <p>The list of <code>ReservedNode</code> objects.</p>
    /// - On failure, responds with [`SdkError<DescribeReservedNodesError>`](crate::error::DescribeReservedNodesError)
    pub fn describe_reserved_nodes(&self) -> fluent_builders::DescribeReservedNodes {
        fluent_builders::DescribeReservedNodes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeResize`](crate::client::fluent_builders::DescribeResize) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster_identifier(impl Into<String>)`](crate::client::fluent_builders::DescribeResize::cluster_identifier) / [`set_cluster_identifier(Option<String>)`](crate::client::fluent_builders::DescribeResize::set_cluster_identifier): <p>The unique identifier of a cluster whose resize progress you are requesting. This parameter is case-sensitive.</p>  <p>By default, resize operations for all clusters defined for an Amazon Web Services account are returned.</p>
    /// - On success, responds with [`DescribeResizeOutput`](crate::output::DescribeResizeOutput) with field(s):
    ///   - [`target_node_type(Option<String>)`](crate::output::DescribeResizeOutput::target_node_type): <p>The node type that the cluster will have after the resize operation is complete.</p>
    ///   - [`target_number_of_nodes(Option<i32>)`](crate::output::DescribeResizeOutput::target_number_of_nodes): <p>The number of nodes that the cluster will have after the resize operation is complete.</p>
    ///   - [`target_cluster_type(Option<String>)`](crate::output::DescribeResizeOutput::target_cluster_type): <p>The cluster type after the resize operation is complete.</p>  <p>Valid Values: <code>multi-node</code> | <code>single-node</code> </p>
    ///   - [`status(Option<String>)`](crate::output::DescribeResizeOutput::status): <p>The status of the resize operation.</p>  <p>Valid Values: <code>NONE</code> | <code>IN_PROGRESS</code> | <code>FAILED</code> | <code>SUCCEEDED</code> | <code>CANCELLING</code> </p>
    ///   - [`import_tables_completed(Option<Vec<String>>)`](crate::output::DescribeResizeOutput::import_tables_completed): <p>The names of tables that have been completely imported .</p>  <p>Valid Values: List of table names.</p>
    ///   - [`import_tables_in_progress(Option<Vec<String>>)`](crate::output::DescribeResizeOutput::import_tables_in_progress): <p>The names of tables that are being currently imported.</p>  <p>Valid Values: List of table names.</p>
    ///   - [`import_tables_not_started(Option<Vec<String>>)`](crate::output::DescribeResizeOutput::import_tables_not_started): <p>The names of tables that have not been yet imported.</p>  <p>Valid Values: List of table names</p>
    ///   - [`avg_resize_rate_in_mega_bytes_per_second(Option<f64>)`](crate::output::DescribeResizeOutput::avg_resize_rate_in_mega_bytes_per_second): <p>The average rate of the resize operation over the last few minutes, measured in megabytes per second. After the resize operation completes, this value shows the average rate of the entire resize operation.</p>
    ///   - [`total_resize_data_in_mega_bytes(Option<i64>)`](crate::output::DescribeResizeOutput::total_resize_data_in_mega_bytes): <p>The estimated total amount of data, in megabytes, on the cluster before the resize operation began.</p>
    ///   - [`progress_in_mega_bytes(Option<i64>)`](crate::output::DescribeResizeOutput::progress_in_mega_bytes): <p>While the resize operation is in progress, this value shows the current amount of data, in megabytes, that has been processed so far. When the resize operation is complete, this value shows the total amount of data, in megabytes, on the cluster, which may be more or less than TotalResizeDataInMegaBytes (the estimated total amount of data before resize).</p>
    ///   - [`elapsed_time_in_seconds(Option<i64>)`](crate::output::DescribeResizeOutput::elapsed_time_in_seconds): <p>The amount of seconds that have elapsed since the resize operation began. After the resize operation completes, this value shows the total actual time, in seconds, for the resize operation.</p>
    ///   - [`estimated_time_to_completion_in_seconds(Option<i64>)`](crate::output::DescribeResizeOutput::estimated_time_to_completion_in_seconds): <p>The estimated time remaining, in seconds, until the resize operation is complete. This value is calculated based on the average resize rate and the estimated amount of data remaining to be processed. Once the resize operation is complete, this value will be 0.</p>
    ///   - [`resize_type(Option<String>)`](crate::output::DescribeResizeOutput::resize_type): <p>An enum with possible values of <code>ClassicResize</code> and <code>ElasticResize</code>. These values describe the type of resize operation being performed. </p>
    ///   - [`message(Option<String>)`](crate::output::DescribeResizeOutput::message): <p>An optional string to provide additional details about the resize action.</p>
    ///   - [`target_encryption_type(Option<String>)`](crate::output::DescribeResizeOutput::target_encryption_type): <p>The type of encryption for the cluster after the resize is complete.</p>  <p>Possible values are <code>KMS</code> and <code>None</code>. </p>
    ///   - [`data_transfer_progress_percent(Option<f64>)`](crate::output::DescribeResizeOutput::data_transfer_progress_percent): <p>The percent of data transferred from source cluster to target cluster.</p>
    /// - On failure, responds with [`SdkError<DescribeResizeError>`](crate::error::DescribeResizeError)
    pub fn describe_resize(&self) -> fluent_builders::DescribeResize {
        fluent_builders::DescribeResize::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeScheduledActions`](crate::client::fluent_builders::DescribeScheduledActions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeScheduledActions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`scheduled_action_name(impl Into<String>)`](crate::client::fluent_builders::DescribeScheduledActions::scheduled_action_name) / [`set_scheduled_action_name(Option<String>)`](crate::client::fluent_builders::DescribeScheduledActions::set_scheduled_action_name): <p>The name of the scheduled action to retrieve. </p>
    ///   - [`target_action_type(ScheduledActionTypeValues)`](crate::client::fluent_builders::DescribeScheduledActions::target_action_type) / [`set_target_action_type(Option<ScheduledActionTypeValues>)`](crate::client::fluent_builders::DescribeScheduledActions::set_target_action_type): <p>The type of the scheduled actions to retrieve. </p>
    ///   - [`start_time(DateTime)`](crate::client::fluent_builders::DescribeScheduledActions::start_time) / [`set_start_time(Option<DateTime>)`](crate::client::fluent_builders::DescribeScheduledActions::set_start_time): <p>The start time in UTC of the scheduled actions to retrieve. Only active scheduled actions that have invocations after this time are retrieved.</p>
    ///   - [`end_time(DateTime)`](crate::client::fluent_builders::DescribeScheduledActions::end_time) / [`set_end_time(Option<DateTime>)`](crate::client::fluent_builders::DescribeScheduledActions::set_end_time): <p>The end time in UTC of the scheduled action to retrieve. Only active scheduled actions that have invocations before this time are retrieved.</p>
    ///   - [`active(bool)`](crate::client::fluent_builders::DescribeScheduledActions::active) / [`set_active(Option<bool>)`](crate::client::fluent_builders::DescribeScheduledActions::set_active): <p>If true, retrieve only active scheduled actions. If false, retrieve only disabled scheduled actions. </p>
    ///   - [`filters(Vec<ScheduledActionFilter>)`](crate::client::fluent_builders::DescribeScheduledActions::filters) / [`set_filters(Option<Vec<ScheduledActionFilter>>)`](crate::client::fluent_builders::DescribeScheduledActions::set_filters): <p>List of scheduled action filters. </p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeScheduledActions::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeScheduledActions::set_marker): <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <code>DescribeScheduledActions</code> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeScheduledActions::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeScheduledActions::set_max_records): <p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. </p>  <p>Default: <code>100</code> </p>  <p>Constraints: minimum 20, maximum 100.</p>
    /// - On success, responds with [`DescribeScheduledActionsOutput`](crate::output::DescribeScheduledActionsOutput) with field(s):
    ///   - [`marker(Option<String>)`](crate::output::DescribeScheduledActionsOutput::marker): <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <code>DescribeScheduledActions</code> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
    ///   - [`scheduled_actions(Option<Vec<ScheduledAction>>)`](crate::output::DescribeScheduledActionsOutput::scheduled_actions): <p>List of retrieved scheduled actions. </p>
    /// - On failure, responds with [`SdkError<DescribeScheduledActionsError>`](crate::error::DescribeScheduledActionsError)
    pub fn describe_scheduled_actions(&self) -> fluent_builders::DescribeScheduledActions {
        fluent_builders::DescribeScheduledActions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeSnapshotCopyGrants`](crate::client::fluent_builders::DescribeSnapshotCopyGrants) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeSnapshotCopyGrants::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`snapshot_copy_grant_name(impl Into<String>)`](crate::client::fluent_builders::DescribeSnapshotCopyGrants::snapshot_copy_grant_name) / [`set_snapshot_copy_grant_name(Option<String>)`](crate::client::fluent_builders::DescribeSnapshotCopyGrants::set_snapshot_copy_grant_name): <p>The name of the snapshot copy grant.</p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeSnapshotCopyGrants::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeSnapshotCopyGrants::set_max_records): <p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. </p>  <p>Default: <code>100</code> </p>  <p>Constraints: minimum 20, maximum 100.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeSnapshotCopyGrants::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeSnapshotCopyGrants::set_marker): <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <code>DescribeSnapshotCopyGrant</code> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>  <p>Constraints: You can specify either the <b>SnapshotCopyGrantName</b> parameter or the <b>Marker</b> parameter, but not both. </p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::DescribeSnapshotCopyGrants::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeSnapshotCopyGrants::set_tag_keys): <p>A tag key or keys for which you want to return all matching resources that are associated with the specified key or keys. For example, suppose that you have resources tagged with keys called <code>owner</code> and <code>environment</code>. If you specify both of these tag keys in the request, Amazon Redshift returns a response with all resources that have either or both of these tag keys associated with them.</p>
    ///   - [`tag_values(Vec<String>)`](crate::client::fluent_builders::DescribeSnapshotCopyGrants::tag_values) / [`set_tag_values(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeSnapshotCopyGrants::set_tag_values): <p>A tag value or values for which you want to return all matching resources that are associated with the specified value or values. For example, suppose that you have resources tagged with values called <code>admin</code> and <code>test</code>. If you specify both of these tag values in the request, Amazon Redshift returns a response with all resources that have either or both of these tag values associated with them.</p>
    /// - On success, responds with [`DescribeSnapshotCopyGrantsOutput`](crate::output::DescribeSnapshotCopyGrantsOutput) with field(s):
    ///   - [`marker(Option<String>)`](crate::output::DescribeSnapshotCopyGrantsOutput::marker): <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <code>DescribeSnapshotCopyGrant</code> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>  <p>Constraints: You can specify either the <b>SnapshotCopyGrantName</b> parameter or the <b>Marker</b> parameter, but not both. </p>
    ///   - [`snapshot_copy_grants(Option<Vec<SnapshotCopyGrant>>)`](crate::output::DescribeSnapshotCopyGrantsOutput::snapshot_copy_grants): <p>The list of <code>SnapshotCopyGrant</code> objects.</p>
    /// - On failure, responds with [`SdkError<DescribeSnapshotCopyGrantsError>`](crate::error::DescribeSnapshotCopyGrantsError)
    pub fn describe_snapshot_copy_grants(&self) -> fluent_builders::DescribeSnapshotCopyGrants {
        fluent_builders::DescribeSnapshotCopyGrants::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeSnapshotSchedules`](crate::client::fluent_builders::DescribeSnapshotSchedules) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeSnapshotSchedules::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster_identifier(impl Into<String>)`](crate::client::fluent_builders::DescribeSnapshotSchedules::cluster_identifier) / [`set_cluster_identifier(Option<String>)`](crate::client::fluent_builders::DescribeSnapshotSchedules::set_cluster_identifier): <p>The unique identifier for the cluster whose snapshot schedules you want to view.</p>
    ///   - [`schedule_identifier(impl Into<String>)`](crate::client::fluent_builders::DescribeSnapshotSchedules::schedule_identifier) / [`set_schedule_identifier(Option<String>)`](crate::client::fluent_builders::DescribeSnapshotSchedules::set_schedule_identifier): <p>A unique identifier for a snapshot schedule.</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::DescribeSnapshotSchedules::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeSnapshotSchedules::set_tag_keys): <p>The key value for a snapshot schedule tag.</p>
    ///   - [`tag_values(Vec<String>)`](crate::client::fluent_builders::DescribeSnapshotSchedules::tag_values) / [`set_tag_values(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeSnapshotSchedules::set_tag_values): <p>The value corresponding to the key of the snapshot schedule tag.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeSnapshotSchedules::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeSnapshotSchedules::set_marker): <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>marker</code> parameter and retrying the command. If the <code>marker</code> field is empty, all response records have been retrieved for the request.</p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeSnapshotSchedules::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeSnapshotSchedules::set_max_records): <p>The maximum number or response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned <code>marker</code> value.</p>
    /// - On success, responds with [`DescribeSnapshotSchedulesOutput`](crate::output::DescribeSnapshotSchedulesOutput) with field(s):
    ///   - [`snapshot_schedules(Option<Vec<SnapshotSchedule>>)`](crate::output::DescribeSnapshotSchedulesOutput::snapshot_schedules): <p>A list of SnapshotSchedules.</p>
    ///   - [`marker(Option<String>)`](crate::output::DescribeSnapshotSchedulesOutput::marker): <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>marker</code> parameter and retrying the command. If the <code>marker</code> field is empty, all response records have been retrieved for the request.</p>
    /// - On failure, responds with [`SdkError<DescribeSnapshotSchedulesError>`](crate::error::DescribeSnapshotSchedulesError)
    pub fn describe_snapshot_schedules(&self) -> fluent_builders::DescribeSnapshotSchedules {
        fluent_builders::DescribeSnapshotSchedules::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeStorage`](crate::client::fluent_builders::DescribeStorage) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::DescribeStorage::send) it.

    /// - On success, responds with [`DescribeStorageOutput`](crate::output::DescribeStorageOutput) with field(s):
    ///   - [`total_backup_size_in_mega_bytes(f64)`](crate::output::DescribeStorageOutput::total_backup_size_in_mega_bytes): <p>The total amount of storage currently used for snapshots.</p>
    ///   - [`total_provisioned_storage_in_mega_bytes(f64)`](crate::output::DescribeStorageOutput::total_provisioned_storage_in_mega_bytes): <p>The total amount of storage currently provisioned.</p>
    /// - On failure, responds with [`SdkError<DescribeStorageError>`](crate::error::DescribeStorageError)
    pub fn describe_storage(&self) -> fluent_builders::DescribeStorage {
        fluent_builders::DescribeStorage::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeTableRestoreStatus`](crate::client::fluent_builders::DescribeTableRestoreStatus) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeTableRestoreStatus::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster_identifier(impl Into<String>)`](crate::client::fluent_builders::DescribeTableRestoreStatus::cluster_identifier) / [`set_cluster_identifier(Option<String>)`](crate::client::fluent_builders::DescribeTableRestoreStatus::set_cluster_identifier): <p>The Amazon Redshift cluster that the table is being restored to.</p>
    ///   - [`table_restore_request_id(impl Into<String>)`](crate::client::fluent_builders::DescribeTableRestoreStatus::table_restore_request_id) / [`set_table_restore_request_id(Option<String>)`](crate::client::fluent_builders::DescribeTableRestoreStatus::set_table_restore_request_id): <p>The identifier of the table restore request to return status for. If you don't specify a <code>TableRestoreRequestId</code> value, then <code>DescribeTableRestoreStatus</code> returns the status of all in-progress table restore requests.</p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeTableRestoreStatus::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeTableRestoreStatus::set_max_records): <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeTableRestoreStatus::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeTableRestoreStatus::set_marker): <p>An optional pagination token provided by a previous <code>DescribeTableRestoreStatus</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by the <code>MaxRecords</code> parameter.</p>
    /// - On success, responds with [`DescribeTableRestoreStatusOutput`](crate::output::DescribeTableRestoreStatusOutput) with field(s):
    ///   - [`table_restore_status_details(Option<Vec<TableRestoreStatus>>)`](crate::output::DescribeTableRestoreStatusOutput::table_restore_status_details): <p>A list of status details for one or more table restore requests.</p>
    ///   - [`marker(Option<String>)`](crate::output::DescribeTableRestoreStatusOutput::marker): <p>A pagination token that can be used in a subsequent <code>DescribeTableRestoreStatus</code> request.</p>
    /// - On failure, responds with [`SdkError<DescribeTableRestoreStatusError>`](crate::error::DescribeTableRestoreStatusError)
    pub fn describe_table_restore_status(&self) -> fluent_builders::DescribeTableRestoreStatus {
        fluent_builders::DescribeTableRestoreStatus::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeTags`](crate::client::fluent_builders::DescribeTags) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeTags::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_name(impl Into<String>)`](crate::client::fluent_builders::DescribeTags::resource_name) / [`set_resource_name(Option<String>)`](crate::client::fluent_builders::DescribeTags::set_resource_name): <p>The Amazon Resource Name (ARN) for which you want to describe the tag or tags. For example, <code>arn:aws:redshift:us-east-2:123456789:cluster:t1</code>. </p>
    ///   - [`resource_type(impl Into<String>)`](crate::client::fluent_builders::DescribeTags::resource_type) / [`set_resource_type(Option<String>)`](crate::client::fluent_builders::DescribeTags::set_resource_type): <p>The type of resource with which you want to view tags. Valid resource types are: </p>  <ul>   <li> <p>Cluster</p> </li>   <li> <p>CIDR/IP</p> </li>   <li> <p>EC2 security group</p> </li>   <li> <p>Snapshot</p> </li>   <li> <p>Cluster security group</p> </li>   <li> <p>Subnet group</p> </li>   <li> <p>HSM connection</p> </li>   <li> <p>HSM certificate</p> </li>   <li> <p>Parameter group</p> </li>   <li> <p>Snapshot copy grant</p> </li>  </ul>  <p>For more information about Amazon Redshift resource types and constructing ARNs, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-overview.html#redshift-iam-access-control-specify-actions">Specifying Policy Elements: Actions, Effects, Resources, and Principals</a> in the Amazon Redshift Cluster Management Guide. </p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeTags::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeTags::set_max_records): <p>The maximum number or response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned <code>marker</code> value. </p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeTags::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeTags::set_marker): <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>marker</code> parameter and retrying the command. If the <code>marker</code> field is empty, all response records have been retrieved for the request. </p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::DescribeTags::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeTags::set_tag_keys): <p>A tag key or keys for which you want to return all matching resources that are associated with the specified key or keys. For example, suppose that you have resources tagged with keys called <code>owner</code> and <code>environment</code>. If you specify both of these tag keys in the request, Amazon Redshift returns a response with all resources that have either or both of these tag keys associated with them.</p>
    ///   - [`tag_values(Vec<String>)`](crate::client::fluent_builders::DescribeTags::tag_values) / [`set_tag_values(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeTags::set_tag_values): <p>A tag value or values for which you want to return all matching resources that are associated with the specified value or values. For example, suppose that you have resources tagged with values called <code>admin</code> and <code>test</code>. If you specify both of these tag values in the request, Amazon Redshift returns a response with all resources that have either or both of these tag values associated with them.</p>
    /// - On success, responds with [`DescribeTagsOutput`](crate::output::DescribeTagsOutput) with field(s):
    ///   - [`tagged_resources(Option<Vec<TaggedResource>>)`](crate::output::DescribeTagsOutput::tagged_resources): <p>A list of tags with their associated resources.</p>
    ///   - [`marker(Option<String>)`](crate::output::DescribeTagsOutput::marker): <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>
    /// - On failure, responds with [`SdkError<DescribeTagsError>`](crate::error::DescribeTagsError)
    pub fn describe_tags(&self) -> fluent_builders::DescribeTags {
        fluent_builders::DescribeTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeUsageLimits`](crate::client::fluent_builders::DescribeUsageLimits) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeUsageLimits::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`usage_limit_id(impl Into<String>)`](crate::client::fluent_builders::DescribeUsageLimits::usage_limit_id) / [`set_usage_limit_id(Option<String>)`](crate::client::fluent_builders::DescribeUsageLimits::set_usage_limit_id): <p>The identifier of the usage limit to describe.</p>
    ///   - [`cluster_identifier(impl Into<String>)`](crate::client::fluent_builders::DescribeUsageLimits::cluster_identifier) / [`set_cluster_identifier(Option<String>)`](crate::client::fluent_builders::DescribeUsageLimits::set_cluster_identifier): <p>The identifier of the cluster for which you want to describe usage limits.</p>
    ///   - [`feature_type(UsageLimitFeatureType)`](crate::client::fluent_builders::DescribeUsageLimits::feature_type) / [`set_feature_type(Option<UsageLimitFeatureType>)`](crate::client::fluent_builders::DescribeUsageLimits::set_feature_type): <p>The feature type for which you want to describe usage limits.</p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeUsageLimits::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeUsageLimits::set_max_records): <p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. </p>  <p>Default: <code>100</code> </p>  <p>Constraints: minimum 20, maximum 100.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeUsageLimits::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeUsageLimits::set_marker): <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <code>DescribeUsageLimits</code> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::DescribeUsageLimits::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeUsageLimits::set_tag_keys): <p>A tag key or keys for which you want to return all matching usage limit objects that are associated with the specified key or keys. For example, suppose that you have parameter groups that are tagged with keys called <code>owner</code> and <code>environment</code>. If you specify both of these tag keys in the request, Amazon Redshift returns a response with the usage limit objects have either or both of these tag keys associated with them.</p>
    ///   - [`tag_values(Vec<String>)`](crate::client::fluent_builders::DescribeUsageLimits::tag_values) / [`set_tag_values(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeUsageLimits::set_tag_values): <p>A tag value or values for which you want to return all matching usage limit objects that are associated with the specified tag value or values. For example, suppose that you have parameter groups that are tagged with values called <code>admin</code> and <code>test</code>. If you specify both of these tag values in the request, Amazon Redshift returns a response with the usage limit objects that have either or both of these tag values associated with them.</p>
    /// - On success, responds with [`DescribeUsageLimitsOutput`](crate::output::DescribeUsageLimitsOutput) with field(s):
    ///   - [`usage_limits(Option<Vec<UsageLimit>>)`](crate::output::DescribeUsageLimitsOutput::usage_limits): <p>Contains the output from the <code>DescribeUsageLimits</code> action. </p>
    ///   - [`marker(Option<String>)`](crate::output::DescribeUsageLimitsOutput::marker): <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all response records have been retrieved for the request. </p>
    /// - On failure, responds with [`SdkError<DescribeUsageLimitsError>`](crate::error::DescribeUsageLimitsError)
    pub fn describe_usage_limits(&self) -> fluent_builders::DescribeUsageLimits {
        fluent_builders::DescribeUsageLimits::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisableLogging`](crate::client::fluent_builders::DisableLogging) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster_identifier(impl Into<String>)`](crate::client::fluent_builders::DisableLogging::cluster_identifier) / [`set_cluster_identifier(Option<String>)`](crate::client::fluent_builders::DisableLogging::set_cluster_identifier): <p>The identifier of the cluster on which logging is to be stopped.</p>  <p>Example: <code>examplecluster</code> </p>
    /// - On success, responds with [`DisableLoggingOutput`](crate::output::DisableLoggingOutput) with field(s):
    ///   - [`logging_enabled(bool)`](crate::output::DisableLoggingOutput::logging_enabled): <p> <code>true</code> if logging is on, <code>false</code> if logging is off.</p>
    ///   - [`bucket_name(Option<String>)`](crate::output::DisableLoggingOutput::bucket_name): <p>The name of the S3 bucket where the log files are stored.</p>
    ///   - [`s3_key_prefix(Option<String>)`](crate::output::DisableLoggingOutput::s3_key_prefix): <p>The prefix applied to the log file names.</p>
    ///   - [`last_successful_delivery_time(Option<DateTime>)`](crate::output::DisableLoggingOutput::last_successful_delivery_time): <p>The last time that logs were delivered.</p>
    ///   - [`last_failure_time(Option<DateTime>)`](crate::output::DisableLoggingOutput::last_failure_time): <p>The last time when logs failed to be delivered.</p>
    ///   - [`last_failure_message(Option<String>)`](crate::output::DisableLoggingOutput::last_failure_message): <p>The message indicating that logs failed to be delivered.</p>
    /// - On failure, responds with [`SdkError<DisableLoggingError>`](crate::error::DisableLoggingError)
    pub fn disable_logging(&self) -> fluent_builders::DisableLogging {
        fluent_builders::DisableLogging::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisableSnapshotCopy`](crate::client::fluent_builders::DisableSnapshotCopy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster_identifier(impl Into<String>)`](crate::client::fluent_builders::DisableSnapshotCopy::cluster_identifier) / [`set_cluster_identifier(Option<String>)`](crate::client::fluent_builders::DisableSnapshotCopy::set_cluster_identifier): <p>The unique identifier of the source cluster that you want to disable copying of snapshots to a destination region.</p>  <p>Constraints: Must be the valid name of an existing cluster that has cross-region snapshot copy enabled.</p>
    /// - On success, responds with [`DisableSnapshotCopyOutput`](crate::output::DisableSnapshotCopyOutput) with field(s):
    ///   - [`cluster(Option<Cluster>)`](crate::output::DisableSnapshotCopyOutput::cluster): <p>Describes a cluster.</p>
    /// - On failure, responds with [`SdkError<DisableSnapshotCopyError>`](crate::error::DisableSnapshotCopyError)
    pub fn disable_snapshot_copy(&self) -> fluent_builders::DisableSnapshotCopy {
        fluent_builders::DisableSnapshotCopy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisassociateDataShareConsumer`](crate::client::fluent_builders::DisassociateDataShareConsumer) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`data_share_arn(impl Into<String>)`](crate::client::fluent_builders::DisassociateDataShareConsumer::data_share_arn) / [`set_data_share_arn(Option<String>)`](crate::client::fluent_builders::DisassociateDataShareConsumer::set_data_share_arn): <p>The Amazon Resource Name (ARN) of the datashare to remove association for. </p>
    ///   - [`disassociate_entire_account(bool)`](crate::client::fluent_builders::DisassociateDataShareConsumer::disassociate_entire_account) / [`set_disassociate_entire_account(Option<bool>)`](crate::client::fluent_builders::DisassociateDataShareConsumer::set_disassociate_entire_account): <p>A value that specifies whether association for the datashare is removed from the entire account.</p>
    ///   - [`consumer_arn(impl Into<String>)`](crate::client::fluent_builders::DisassociateDataShareConsumer::consumer_arn) / [`set_consumer_arn(Option<String>)`](crate::client::fluent_builders::DisassociateDataShareConsumer::set_consumer_arn): <p>The Amazon Resource Name (ARN) of the consumer that association for the datashare is removed from.</p>
    ///   - [`consumer_region(impl Into<String>)`](crate::client::fluent_builders::DisassociateDataShareConsumer::consumer_region) / [`set_consumer_region(Option<String>)`](crate::client::fluent_builders::DisassociateDataShareConsumer::set_consumer_region): <p>From a datashare consumer account, removes association of a datashare from all the existing and future namespaces in the specified Amazon Web Services Region.</p>
    /// - On success, responds with [`DisassociateDataShareConsumerOutput`](crate::output::DisassociateDataShareConsumerOutput) with field(s):
    ///   - [`data_share_arn(Option<String>)`](crate::output::DisassociateDataShareConsumerOutput::data_share_arn): <p>An Amazon Resource Name (ARN) that references the datashare that is owned by a specific namespace of the producer cluster. A datashare ARN is in the <code>arn:aws:redshift:{region}:{account-id}:{datashare}:{namespace-guid}/{datashare-name}</code> format.</p>
    ///   - [`producer_arn(Option<String>)`](crate::output::DisassociateDataShareConsumerOutput::producer_arn): <p>The Amazon Resource Name (ARN) of the producer.</p>
    ///   - [`allow_publicly_accessible_consumers(bool)`](crate::output::DisassociateDataShareConsumerOutput::allow_publicly_accessible_consumers): <p>A value that specifies whether the datashare can be shared to a publicly accessible cluster.</p>
    ///   - [`data_share_associations(Option<Vec<DataShareAssociation>>)`](crate::output::DisassociateDataShareConsumerOutput::data_share_associations): <p>A value that specifies when the datashare has an association between a producer and data consumers.</p>
    ///   - [`managed_by(Option<String>)`](crate::output::DisassociateDataShareConsumerOutput::managed_by): <p>The identifier of a datashare to show its managing entity.</p>
    /// - On failure, responds with [`SdkError<DisassociateDataShareConsumerError>`](crate::error::DisassociateDataShareConsumerError)
    pub fn disassociate_data_share_consumer(
        &self,
    ) -> fluent_builders::DisassociateDataShareConsumer {
        fluent_builders::DisassociateDataShareConsumer::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`EnableLogging`](crate::client::fluent_builders::EnableLogging) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster_identifier(impl Into<String>)`](crate::client::fluent_builders::EnableLogging::cluster_identifier) / [`set_cluster_identifier(Option<String>)`](crate::client::fluent_builders::EnableLogging::set_cluster_identifier): <p>The identifier of the cluster on which logging is to be started.</p>  <p>Example: <code>examplecluster</code> </p>
    ///   - [`bucket_name(impl Into<String>)`](crate::client::fluent_builders::EnableLogging::bucket_name) / [`set_bucket_name(Option<String>)`](crate::client::fluent_builders::EnableLogging::set_bucket_name): <p>The name of an existing S3 bucket where the log files are to be stored.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must be in the same region as the cluster</p> </li>   <li> <p>The cluster must have read bucket and put object permissions</p> </li>  </ul>
    ///   - [`s3_key_prefix(impl Into<String>)`](crate::client::fluent_builders::EnableLogging::s3_key_prefix) / [`set_s3_key_prefix(Option<String>)`](crate::client::fluent_builders::EnableLogging::set_s3_key_prefix): <p>The prefix applied to the log file names.</p>  <p>Constraints:</p>  <ul>   <li> <p>Cannot exceed 512 characters</p> </li>   <li> <p>Cannot contain spaces( ), double quotes ("), single quotes ('), a backslash (\), or control characters. The hexadecimal codes for invalid characters are: </p>    <ul>     <li> <p>x00 to x20</p> </li>     <li> <p>x22</p> </li>     <li> <p>x27</p> </li>     <li> <p>x5c</p> </li>     <li> <p>x7f or larger</p> </li>    </ul> </li>  </ul>
    /// - On success, responds with [`EnableLoggingOutput`](crate::output::EnableLoggingOutput) with field(s):
    ///   - [`logging_enabled(bool)`](crate::output::EnableLoggingOutput::logging_enabled): <p> <code>true</code> if logging is on, <code>false</code> if logging is off.</p>
    ///   - [`bucket_name(Option<String>)`](crate::output::EnableLoggingOutput::bucket_name): <p>The name of the S3 bucket where the log files are stored.</p>
    ///   - [`s3_key_prefix(Option<String>)`](crate::output::EnableLoggingOutput::s3_key_prefix): <p>The prefix applied to the log file names.</p>
    ///   - [`last_successful_delivery_time(Option<DateTime>)`](crate::output::EnableLoggingOutput::last_successful_delivery_time): <p>The last time that logs were delivered.</p>
    ///   - [`last_failure_time(Option<DateTime>)`](crate::output::EnableLoggingOutput::last_failure_time): <p>The last time when logs failed to be delivered.</p>
    ///   - [`last_failure_message(Option<String>)`](crate::output::EnableLoggingOutput::last_failure_message): <p>The message indicating that logs failed to be delivered.</p>
    /// - On failure, responds with [`SdkError<EnableLoggingError>`](crate::error::EnableLoggingError)
    pub fn enable_logging(&self) -> fluent_builders::EnableLogging {
        fluent_builders::EnableLogging::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`EnableSnapshotCopy`](crate::client::fluent_builders::EnableSnapshotCopy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster_identifier(impl Into<String>)`](crate::client::fluent_builders::EnableSnapshotCopy::cluster_identifier) / [`set_cluster_identifier(Option<String>)`](crate::client::fluent_builders::EnableSnapshotCopy::set_cluster_identifier): <p>The unique identifier of the source cluster to copy snapshots from.</p>  <p>Constraints: Must be the valid name of an existing cluster that does not already have cross-region snapshot copy enabled.</p>
    ///   - [`destination_region(impl Into<String>)`](crate::client::fluent_builders::EnableSnapshotCopy::destination_region) / [`set_destination_region(Option<String>)`](crate::client::fluent_builders::EnableSnapshotCopy::set_destination_region): <p>The destination Amazon Web Services Region that you want to copy snapshots to.</p>  <p>Constraints: Must be the name of a valid Amazon Web Services Region. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#redshift_region">Regions and Endpoints</a> in the Amazon Web Services General Reference. </p>
    ///   - [`retention_period(i32)`](crate::client::fluent_builders::EnableSnapshotCopy::retention_period) / [`set_retention_period(Option<i32>)`](crate::client::fluent_builders::EnableSnapshotCopy::set_retention_period): <p>The number of days to retain automated snapshots in the destination region after they are copied from the source region.</p>  <p>Default: 7.</p>  <p>Constraints: Must be at least 1 and no more than 35.</p>
    ///   - [`snapshot_copy_grant_name(impl Into<String>)`](crate::client::fluent_builders::EnableSnapshotCopy::snapshot_copy_grant_name) / [`set_snapshot_copy_grant_name(Option<String>)`](crate::client::fluent_builders::EnableSnapshotCopy::set_snapshot_copy_grant_name): <p>The name of the snapshot copy grant to use when snapshots of an Amazon Web Services KMS-encrypted cluster are copied to the destination region.</p>
    ///   - [`manual_snapshot_retention_period(i32)`](crate::client::fluent_builders::EnableSnapshotCopy::manual_snapshot_retention_period) / [`set_manual_snapshot_retention_period(Option<i32>)`](crate::client::fluent_builders::EnableSnapshotCopy::set_manual_snapshot_retention_period): <p>The number of days to retain newly copied snapshots in the destination Amazon Web Services Region after they are copied from the source Amazon Web Services Region. If the value is -1, the manual snapshot is retained indefinitely. </p>  <p>The value must be either -1 or an integer between 1 and 3,653.</p>
    /// - On success, responds with [`EnableSnapshotCopyOutput`](crate::output::EnableSnapshotCopyOutput) with field(s):
    ///   - [`cluster(Option<Cluster>)`](crate::output::EnableSnapshotCopyOutput::cluster): <p>Describes a cluster.</p>
    /// - On failure, responds with [`SdkError<EnableSnapshotCopyError>`](crate::error::EnableSnapshotCopyError)
    pub fn enable_snapshot_copy(&self) -> fluent_builders::EnableSnapshotCopy {
        fluent_builders::EnableSnapshotCopy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetClusterCredentials`](crate::client::fluent_builders::GetClusterCredentials) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_user(impl Into<String>)`](crate::client::fluent_builders::GetClusterCredentials::db_user) / [`set_db_user(Option<String>)`](crate::client::fluent_builders::GetClusterCredentials::set_db_user): <p>The name of a database user. If a user name matching <code>DbUser</code> exists in the database, the temporary user credentials have the same permissions as the existing user. If <code>DbUser</code> doesn't exist in the database and <code>Autocreate</code> is <code>True</code>, a new user is created using the value for <code>DbUser</code> with PUBLIC permissions. If a database user matching the value for <code>DbUser</code> doesn't exist and <code>Autocreate</code> is <code>False</code>, then the command succeeds but the connection attempt will fail because the user doesn't exist in the database.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/redshift/latest/dg/r_CREATE_USER.html">CREATE USER</a> in the Amazon Redshift Database Developer Guide. </p>  <p>Constraints:</p>  <ul>   <li> <p>Must be 1 to 64 alphanumeric characters or hyphens. The user name can't be <code>PUBLIC</code>.</p> </li>   <li> <p>Must contain only lowercase letters, numbers, underscore, plus sign, period (dot), at symbol (@), or hyphen.</p> </li>   <li> <p>First character must be a letter.</p> </li>   <li> <p>Must not contain a colon ( : ) or slash ( / ). </p> </li>   <li> <p>Cannot be a reserved word. A list of reserved words can be found in <a href="http://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html">Reserved Words</a> in the Amazon Redshift Database Developer Guide.</p> </li>  </ul>
    ///   - [`db_name(impl Into<String>)`](crate::client::fluent_builders::GetClusterCredentials::db_name) / [`set_db_name(Option<String>)`](crate::client::fluent_builders::GetClusterCredentials::set_db_name): <p>The name of a database that <code>DbUser</code> is authorized to log on to. If <code>DbName</code> is not specified, <code>DbUser</code> can log on to any existing database.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must be 1 to 64 alphanumeric characters or hyphens</p> </li>   <li> <p>Must contain only lowercase letters, numbers, underscore, plus sign, period (dot), at symbol (@), or hyphen.</p> </li>   <li> <p>First character must be a letter.</p> </li>   <li> <p>Must not contain a colon ( : ) or slash ( / ). </p> </li>   <li> <p>Cannot be a reserved word. A list of reserved words can be found in <a href="http://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html">Reserved Words</a> in the Amazon Redshift Database Developer Guide.</p> </li>  </ul>
    ///   - [`cluster_identifier(impl Into<String>)`](crate::client::fluent_builders::GetClusterCredentials::cluster_identifier) / [`set_cluster_identifier(Option<String>)`](crate::client::fluent_builders::GetClusterCredentials::set_cluster_identifier): <p>The unique identifier of the cluster that contains the database for which your are requesting credentials. This parameter is case sensitive.</p>
    ///   - [`duration_seconds(i32)`](crate::client::fluent_builders::GetClusterCredentials::duration_seconds) / [`set_duration_seconds(Option<i32>)`](crate::client::fluent_builders::GetClusterCredentials::set_duration_seconds): <p>The number of seconds until the returned temporary password expires.</p>  <p>Constraint: minimum 900, maximum 3600.</p>  <p>Default: 900</p>
    ///   - [`auto_create(bool)`](crate::client::fluent_builders::GetClusterCredentials::auto_create) / [`set_auto_create(Option<bool>)`](crate::client::fluent_builders::GetClusterCredentials::set_auto_create): <p>Create a database user with the name specified for the user named in <code>DbUser</code> if one does not exist.</p>
    ///   - [`db_groups(Vec<String>)`](crate::client::fluent_builders::GetClusterCredentials::db_groups) / [`set_db_groups(Option<Vec<String>>)`](crate::client::fluent_builders::GetClusterCredentials::set_db_groups): <p>A list of the names of existing database groups that the user named in <code>DbUser</code> will join for the current session, in addition to any group memberships for an existing user. If not specified, a new user is added only to PUBLIC.</p>  <p>Database group name constraints</p>  <ul>   <li> <p>Must be 1 to 64 alphanumeric characters or hyphens</p> </li>   <li> <p>Must contain only lowercase letters, numbers, underscore, plus sign, period (dot), at symbol (@), or hyphen.</p> </li>   <li> <p>First character must be a letter.</p> </li>   <li> <p>Must not contain a colon ( : ) or slash ( / ). </p> </li>   <li> <p>Cannot be a reserved word. A list of reserved words can be found in <a href="http://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html">Reserved Words</a> in the Amazon Redshift Database Developer Guide.</p> </li>  </ul>
    /// - On success, responds with [`GetClusterCredentialsOutput`](crate::output::GetClusterCredentialsOutput) with field(s):
    ///   - [`db_user(Option<String>)`](crate::output::GetClusterCredentialsOutput::db_user): <p>A database user name that is authorized to log on to the database <code>DbName</code> using the password <code>DbPassword</code>. If the specified DbUser exists in the database, the new user name has the same database privileges as the the user named in DbUser. By default, the user is added to PUBLIC. If the <code>DbGroups</code> parameter is specifed, <code>DbUser</code> is added to the listed groups for any sessions created using these credentials.</p>
    ///   - [`db_password(Option<String>)`](crate::output::GetClusterCredentialsOutput::db_password): <p>A temporary password that authorizes the user name returned by <code>DbUser</code> to log on to the database <code>DbName</code>. </p>
    ///   - [`expiration(Option<DateTime>)`](crate::output::GetClusterCredentialsOutput::expiration): <p>The date and time the password in <code>DbPassword</code> expires.</p>
    /// - On failure, responds with [`SdkError<GetClusterCredentialsError>`](crate::error::GetClusterCredentialsError)
    pub fn get_cluster_credentials(&self) -> fluent_builders::GetClusterCredentials {
        fluent_builders::GetClusterCredentials::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetReservedNodeExchangeConfigurationOptions`](crate::client::fluent_builders::GetReservedNodeExchangeConfigurationOptions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetReservedNodeExchangeConfigurationOptions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`action_type(ReservedNodeExchangeActionType)`](crate::client::fluent_builders::GetReservedNodeExchangeConfigurationOptions::action_type) / [`set_action_type(Option<ReservedNodeExchangeActionType>)`](crate::client::fluent_builders::GetReservedNodeExchangeConfigurationOptions::set_action_type): <p>The action type of the reserved-node configuration. The action type can be an exchange initiated from either a snapshot or a resize.</p>
    ///   - [`cluster_identifier(impl Into<String>)`](crate::client::fluent_builders::GetReservedNodeExchangeConfigurationOptions::cluster_identifier) / [`set_cluster_identifier(Option<String>)`](crate::client::fluent_builders::GetReservedNodeExchangeConfigurationOptions::set_cluster_identifier): <p>The identifier for the cluster that is the source for a reserved-node exchange.</p>
    ///   - [`snapshot_identifier(impl Into<String>)`](crate::client::fluent_builders::GetReservedNodeExchangeConfigurationOptions::snapshot_identifier) / [`set_snapshot_identifier(Option<String>)`](crate::client::fluent_builders::GetReservedNodeExchangeConfigurationOptions::set_snapshot_identifier): <p>The identifier for the snapshot that is the source for the reserved-node exchange.</p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::GetReservedNodeExchangeConfigurationOptions::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::GetReservedNodeExchangeConfigurationOptions::set_max_records): <p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>Marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::GetReservedNodeExchangeConfigurationOptions::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::GetReservedNodeExchangeConfigurationOptions::set_marker): <p>An optional pagination token provided by a previous <code>GetReservedNodeExchangeConfigurationOptions</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by the <code>MaxRecords</code> parameter. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request.</p>
    /// - On success, responds with [`GetReservedNodeExchangeConfigurationOptionsOutput`](crate::output::GetReservedNodeExchangeConfigurationOptionsOutput) with field(s):
    ///   - [`marker(Option<String>)`](crate::output::GetReservedNodeExchangeConfigurationOptionsOutput::marker): <p>A pagination token provided by a previous <code>GetReservedNodeExchangeConfigurationOptions</code> request.</p>
    ///   - [`reserved_node_configuration_option_list(Option<Vec<ReservedNodeConfigurationOption>>)`](crate::output::GetReservedNodeExchangeConfigurationOptionsOutput::reserved_node_configuration_option_list): <p>the configuration options for the reserved-node exchange. These options include information about the source reserved node and target reserved node. Details include the node type, the price, the node count, and the offering type.</p>
    /// - On failure, responds with [`SdkError<GetReservedNodeExchangeConfigurationOptionsError>`](crate::error::GetReservedNodeExchangeConfigurationOptionsError)
    pub fn get_reserved_node_exchange_configuration_options(
        &self,
    ) -> fluent_builders::GetReservedNodeExchangeConfigurationOptions {
        fluent_builders::GetReservedNodeExchangeConfigurationOptions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetReservedNodeExchangeOfferings`](crate::client::fluent_builders::GetReservedNodeExchangeOfferings) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetReservedNodeExchangeOfferings::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`reserved_node_id(impl Into<String>)`](crate::client::fluent_builders::GetReservedNodeExchangeOfferings::reserved_node_id) / [`set_reserved_node_id(Option<String>)`](crate::client::fluent_builders::GetReservedNodeExchangeOfferings::set_reserved_node_id): <p>A string representing the node identifier for the DC1 Reserved Node to be exchanged.</p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::GetReservedNodeExchangeOfferings::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::GetReservedNodeExchangeOfferings::set_max_records): <p>An integer setting the maximum number of ReservedNodeOfferings to retrieve.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::GetReservedNodeExchangeOfferings::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::GetReservedNodeExchangeOfferings::set_marker): <p>A value that indicates the starting point for the next set of ReservedNodeOfferings.</p>
    /// - On success, responds with [`GetReservedNodeExchangeOfferingsOutput`](crate::output::GetReservedNodeExchangeOfferingsOutput) with field(s):
    ///   - [`marker(Option<String>)`](crate::output::GetReservedNodeExchangeOfferingsOutput::marker): <p>An optional parameter that specifies the starting point for returning a set of response records. When the results of a <code>GetReservedNodeExchangeOfferings</code> request exceed the value specified in MaxRecords, Amazon Redshift returns a value in the marker field of the response. You can retrieve the next set of response records by providing the returned marker value in the marker parameter and retrying the request. </p>
    ///   - [`reserved_node_offerings(Option<Vec<ReservedNodeOffering>>)`](crate::output::GetReservedNodeExchangeOfferingsOutput::reserved_node_offerings): <p>Returns an array of <code>ReservedNodeOffering</code> objects.</p>
    /// - On failure, responds with [`SdkError<GetReservedNodeExchangeOfferingsError>`](crate::error::GetReservedNodeExchangeOfferingsError)
    pub fn get_reserved_node_exchange_offerings(
        &self,
    ) -> fluent_builders::GetReservedNodeExchangeOfferings {
        fluent_builders::GetReservedNodeExchangeOfferings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ModifyAquaConfiguration`](crate::client::fluent_builders::ModifyAquaConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster_identifier(impl Into<String>)`](crate::client::fluent_builders::ModifyAquaConfiguration::cluster_identifier) / [`set_cluster_identifier(Option<String>)`](crate::client::fluent_builders::ModifyAquaConfiguration::set_cluster_identifier): <p>The identifier of the cluster to be modified.</p>
    ///   - [`aqua_configuration_status(AquaConfigurationStatus)`](crate::client::fluent_builders::ModifyAquaConfiguration::aqua_configuration_status) / [`set_aqua_configuration_status(Option<AquaConfigurationStatus>)`](crate::client::fluent_builders::ModifyAquaConfiguration::set_aqua_configuration_status): <p>The new value of AQUA configuration status. Possible values include the following.</p>  <ul>   <li> <p>enabled - Use AQUA if it is available for the current Amazon Web Services Region and Amazon Redshift node type.</p> </li>   <li> <p>disabled - Don't use AQUA. </p> </li>   <li> <p>auto - Amazon Redshift determines whether to use AQUA.</p> </li>  </ul>
    /// - On success, responds with [`ModifyAquaConfigurationOutput`](crate::output::ModifyAquaConfigurationOutput) with field(s):
    ///   - [`aqua_configuration(Option<AquaConfiguration>)`](crate::output::ModifyAquaConfigurationOutput::aqua_configuration): <p>The updated AQUA configuration of the cluster. </p>
    /// - On failure, responds with [`SdkError<ModifyAquaConfigurationError>`](crate::error::ModifyAquaConfigurationError)
    pub fn modify_aqua_configuration(&self) -> fluent_builders::ModifyAquaConfiguration {
        fluent_builders::ModifyAquaConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ModifyAuthenticationProfile`](crate::client::fluent_builders::ModifyAuthenticationProfile) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`authentication_profile_name(impl Into<String>)`](crate::client::fluent_builders::ModifyAuthenticationProfile::authentication_profile_name) / [`set_authentication_profile_name(Option<String>)`](crate::client::fluent_builders::ModifyAuthenticationProfile::set_authentication_profile_name): <p>The name of the authentication profile to replace.</p>
    ///   - [`authentication_profile_content(impl Into<String>)`](crate::client::fluent_builders::ModifyAuthenticationProfile::authentication_profile_content) / [`set_authentication_profile_content(Option<String>)`](crate::client::fluent_builders::ModifyAuthenticationProfile::set_authentication_profile_content): <p>The new content of the authentication profile in JSON format. The maximum length of the JSON string is determined by a quota for your account.</p>
    /// - On success, responds with [`ModifyAuthenticationProfileOutput`](crate::output::ModifyAuthenticationProfileOutput) with field(s):
    ///   - [`authentication_profile_name(Option<String>)`](crate::output::ModifyAuthenticationProfileOutput::authentication_profile_name): <p>The name of the authentication profile that was replaced.</p>
    ///   - [`authentication_profile_content(Option<String>)`](crate::output::ModifyAuthenticationProfileOutput::authentication_profile_content): <p>The updated content of the authentication profile in JSON format.</p>
    /// - On failure, responds with [`SdkError<ModifyAuthenticationProfileError>`](crate::error::ModifyAuthenticationProfileError)
    pub fn modify_authentication_profile(&self) -> fluent_builders::ModifyAuthenticationProfile {
        fluent_builders::ModifyAuthenticationProfile::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ModifyCluster`](crate::client::fluent_builders::ModifyCluster) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster_identifier(impl Into<String>)`](crate::client::fluent_builders::ModifyCluster::cluster_identifier) / [`set_cluster_identifier(Option<String>)`](crate::client::fluent_builders::ModifyCluster::set_cluster_identifier): <p>The unique identifier of the cluster to be modified.</p>  <p>Example: <code>examplecluster</code> </p>
    ///   - [`cluster_type(impl Into<String>)`](crate::client::fluent_builders::ModifyCluster::cluster_type) / [`set_cluster_type(Option<String>)`](crate::client::fluent_builders::ModifyCluster::set_cluster_type): <p>The new cluster type.</p>  <p>When you submit your cluster resize request, your existing cluster goes into a read-only mode. After Amazon Redshift provisions a new cluster based on your resize requirements, there will be outage for a period while the old cluster is deleted and your connection is switched to the new cluster. You can use <code>DescribeResize</code> to track the progress of the resize request. </p>  <p>Valid Values: <code> multi-node | single-node </code> </p>
    ///   - [`node_type(impl Into<String>)`](crate::client::fluent_builders::ModifyCluster::node_type) / [`set_node_type(Option<String>)`](crate::client::fluent_builders::ModifyCluster::set_node_type): <p>The new node type of the cluster. If you specify a new node type, you must also specify the number of nodes parameter.</p>  <p> For more information about resizing clusters, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/rs-resize-tutorial.html">Resizing Clusters in Amazon Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</p>  <p>Valid Values: <code>ds2.xlarge</code> | <code>ds2.8xlarge</code> | <code>dc1.large</code> | <code>dc1.8xlarge</code> | <code>dc2.large</code> | <code>dc2.8xlarge</code> | <code>ra3.xlplus</code> | <code>ra3.4xlarge</code> | <code>ra3.16xlarge</code> </p>
    ///   - [`number_of_nodes(i32)`](crate::client::fluent_builders::ModifyCluster::number_of_nodes) / [`set_number_of_nodes(Option<i32>)`](crate::client::fluent_builders::ModifyCluster::set_number_of_nodes): <p>The new number of nodes of the cluster. If you specify a new number of nodes, you must also specify the node type parameter.</p>  <p> For more information about resizing clusters, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/rs-resize-tutorial.html">Resizing Clusters in Amazon Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</p>  <p>Valid Values: Integer greater than <code>0</code>.</p>
    ///   - [`cluster_security_groups(Vec<String>)`](crate::client::fluent_builders::ModifyCluster::cluster_security_groups) / [`set_cluster_security_groups(Option<Vec<String>>)`](crate::client::fluent_builders::ModifyCluster::set_cluster_security_groups): <p>A list of cluster security groups to be authorized on this cluster. This change is asynchronously applied as soon as possible.</p>  <p>Security groups currently associated with the cluster, and not in the list of groups to apply, will be revoked from the cluster.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must be 1 to 255 alphanumeric characters or hyphens</p> </li>   <li> <p>First character must be a letter</p> </li>   <li> <p>Cannot end with a hyphen or contain two consecutive hyphens</p> </li>  </ul>
    ///   - [`vpc_security_group_ids(Vec<String>)`](crate::client::fluent_builders::ModifyCluster::vpc_security_group_ids) / [`set_vpc_security_group_ids(Option<Vec<String>>)`](crate::client::fluent_builders::ModifyCluster::set_vpc_security_group_ids): <p>A list of virtual private cloud (VPC) security groups to be associated with the cluster. This change is asynchronously applied as soon as possible.</p>
    ///   - [`master_user_password(impl Into<String>)`](crate::client::fluent_builders::ModifyCluster::master_user_password) / [`set_master_user_password(Option<String>)`](crate::client::fluent_builders::ModifyCluster::set_master_user_password): <p>The new password for the cluster admin user. This change is asynchronously applied as soon as possible. Between the time of the request and the completion of the request, the <code>MasterUserPassword</code> element exists in the <code>PendingModifiedValues</code> element of the operation response. </p> <note>   <p>Operations never return the password, so this operation provides a way to regain access to the admin user account for a cluster if the password is lost.</p>  </note>  <p>Default: Uses existing setting.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must be between 8 and 64 characters in length.</p> </li>   <li> <p>Must contain at least one uppercase letter.</p> </li>   <li> <p>Must contain at least one lowercase letter.</p> </li>   <li> <p>Must contain one number.</p> </li>   <li> <p>Can be any printable ASCII character (ASCII code 33-126) except ' (single quote), " (double quote), \, /, or @.</p> </li>  </ul>
    ///   - [`cluster_parameter_group_name(impl Into<String>)`](crate::client::fluent_builders::ModifyCluster::cluster_parameter_group_name) / [`set_cluster_parameter_group_name(Option<String>)`](crate::client::fluent_builders::ModifyCluster::set_cluster_parameter_group_name): <p>The name of the cluster parameter group to apply to this cluster. This change is applied only after the cluster is rebooted. To reboot a cluster use <code>RebootCluster</code>. </p>  <p>Default: Uses existing setting.</p>  <p>Constraints: The cluster parameter group must be in the same parameter group family that matches the cluster version.</p>
    ///   - [`automated_snapshot_retention_period(i32)`](crate::client::fluent_builders::ModifyCluster::automated_snapshot_retention_period) / [`set_automated_snapshot_retention_period(Option<i32>)`](crate::client::fluent_builders::ModifyCluster::set_automated_snapshot_retention_period): <p>The number of days that automated snapshots are retained. If the value is 0, automated snapshots are disabled. Even if automated snapshots are disabled, you can still create manual snapshots when you want with <code>CreateClusterSnapshot</code>. </p>  <p>If you decrease the automated snapshot retention period from its current value, existing automated snapshots that fall outside of the new retention period will be immediately deleted.</p>  <p>You can't disable automated snapshots for RA3 node types. Set the automated retention period from 1-35 days.</p>  <p>Default: Uses existing setting.</p>  <p>Constraints: Must be a value from 0 to 35.</p>
    ///   - [`manual_snapshot_retention_period(i32)`](crate::client::fluent_builders::ModifyCluster::manual_snapshot_retention_period) / [`set_manual_snapshot_retention_period(Option<i32>)`](crate::client::fluent_builders::ModifyCluster::set_manual_snapshot_retention_period): <p>The default for number of days that a newly created manual snapshot is retained. If the value is -1, the manual snapshot is retained indefinitely. This value doesn't retroactively change the retention periods of existing manual snapshots.</p>  <p>The value must be either -1 or an integer between 1 and 3,653.</p>  <p>The default value is -1.</p>
    ///   - [`preferred_maintenance_window(impl Into<String>)`](crate::client::fluent_builders::ModifyCluster::preferred_maintenance_window) / [`set_preferred_maintenance_window(Option<String>)`](crate::client::fluent_builders::ModifyCluster::set_preferred_maintenance_window): <p>The weekly time range (in UTC) during which system maintenance can occur, if necessary. If system maintenance is necessary during the window, it may result in an outage.</p>  <p>This maintenance window change is made immediately. If the new maintenance window indicates the current time, there must be at least 120 minutes between the current time and end of the window in order to ensure that pending changes are applied.</p>  <p>Default: Uses existing setting.</p>  <p>Format: ddd:hh24:mi-ddd:hh24:mi, for example <code>wed:07:30-wed:08:00</code>.</p>  <p>Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun</p>  <p>Constraints: Must be at least 30 minutes.</p>
    ///   - [`cluster_version(impl Into<String>)`](crate::client::fluent_builders::ModifyCluster::cluster_version) / [`set_cluster_version(Option<String>)`](crate::client::fluent_builders::ModifyCluster::set_cluster_version): <p>The new version number of the Amazon Redshift engine to upgrade to.</p>  <p>For major version upgrades, if a non-default cluster parameter group is currently in use, a new cluster parameter group in the cluster parameter group family for the new version must be specified. The new cluster parameter group can be the default for that cluster parameter group family. For more information about parameters and parameter groups, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Amazon Redshift Parameter Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</p>  <p>Example: <code>1.0</code> </p>
    ///   - [`allow_version_upgrade(bool)`](crate::client::fluent_builders::ModifyCluster::allow_version_upgrade) / [`set_allow_version_upgrade(Option<bool>)`](crate::client::fluent_builders::ModifyCluster::set_allow_version_upgrade): <p>If <code>true</code>, major version upgrades will be applied automatically to the cluster during the maintenance window. </p>  <p>Default: <code>false</code> </p>
    ///   - [`hsm_client_certificate_identifier(impl Into<String>)`](crate::client::fluent_builders::ModifyCluster::hsm_client_certificate_identifier) / [`set_hsm_client_certificate_identifier(Option<String>)`](crate::client::fluent_builders::ModifyCluster::set_hsm_client_certificate_identifier): <p>Specifies the name of the HSM client certificate the Amazon Redshift cluster uses to retrieve the data encryption keys stored in an HSM.</p>
    ///   - [`hsm_configuration_identifier(impl Into<String>)`](crate::client::fluent_builders::ModifyCluster::hsm_configuration_identifier) / [`set_hsm_configuration_identifier(Option<String>)`](crate::client::fluent_builders::ModifyCluster::set_hsm_configuration_identifier): <p>Specifies the name of the HSM configuration that contains the information the Amazon Redshift cluster can use to retrieve and store keys in an HSM.</p>
    ///   - [`new_cluster_identifier(impl Into<String>)`](crate::client::fluent_builders::ModifyCluster::new_cluster_identifier) / [`set_new_cluster_identifier(Option<String>)`](crate::client::fluent_builders::ModifyCluster::set_new_cluster_identifier): <p>The new identifier for the cluster.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must contain from 1 to 63 alphanumeric characters or hyphens.</p> </li>   <li> <p>Alphabetic characters must be lowercase.</p> </li>   <li> <p>First character must be a letter.</p> </li>   <li> <p>Cannot end with a hyphen or contain two consecutive hyphens.</p> </li>   <li> <p>Must be unique for all clusters within an Amazon Web Services account.</p> </li>  </ul>  <p>Example: <code>examplecluster</code> </p>
    ///   - [`publicly_accessible(bool)`](crate::client::fluent_builders::ModifyCluster::publicly_accessible) / [`set_publicly_accessible(Option<bool>)`](crate::client::fluent_builders::ModifyCluster::set_publicly_accessible): <p>If <code>true</code>, the cluster can be accessed from a public network. Only clusters in VPCs can be set to be publicly available.</p>
    ///   - [`elastic_ip(impl Into<String>)`](crate::client::fluent_builders::ModifyCluster::elastic_ip) / [`set_elastic_ip(Option<String>)`](crate::client::fluent_builders::ModifyCluster::set_elastic_ip): <p>The Elastic IP (EIP) address for the cluster.</p>  <p>Constraints: The cluster must be provisioned in EC2-VPC and publicly-accessible through an Internet gateway. For more information about provisioning clusters in EC2-VPC, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#cluster-platforms">Supported Platforms to Launch Your Cluster</a> in the Amazon Redshift Cluster Management Guide.</p>
    ///   - [`enhanced_vpc_routing(bool)`](crate::client::fluent_builders::ModifyCluster::enhanced_vpc_routing) / [`set_enhanced_vpc_routing(Option<bool>)`](crate::client::fluent_builders::ModifyCluster::set_enhanced_vpc_routing): <p>An option that specifies whether to create the cluster with enhanced VPC routing enabled. To create a cluster that uses enhanced VPC routing, the cluster must be in a VPC. For more information, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html">Enhanced VPC Routing</a> in the Amazon Redshift Cluster Management Guide.</p>  <p>If this option is <code>true</code>, enhanced VPC routing is enabled. </p>  <p>Default: false</p>
    ///   - [`maintenance_track_name(impl Into<String>)`](crate::client::fluent_builders::ModifyCluster::maintenance_track_name) / [`set_maintenance_track_name(Option<String>)`](crate::client::fluent_builders::ModifyCluster::set_maintenance_track_name): <p>The name for the maintenance track that you want to assign for the cluster. This name change is asynchronous. The new track name stays in the <code>PendingModifiedValues</code> for the cluster until the next maintenance window. When the maintenance track changes, the cluster is switched to the latest cluster release available for the maintenance track. At this point, the maintenance track name is applied.</p>
    ///   - [`encrypted(bool)`](crate::client::fluent_builders::ModifyCluster::encrypted) / [`set_encrypted(Option<bool>)`](crate::client::fluent_builders::ModifyCluster::set_encrypted): <p>Indicates whether the cluster is encrypted. If the value is encrypted (true) and you provide a value for the <code>KmsKeyId</code> parameter, we encrypt the cluster with the provided <code>KmsKeyId</code>. If you don't provide a <code>KmsKeyId</code>, we encrypt with the default key. </p>  <p>If the value is not encrypted (false), then the cluster is decrypted. </p>
    ///   - [`kms_key_id(impl Into<String>)`](crate::client::fluent_builders::ModifyCluster::kms_key_id) / [`set_kms_key_id(Option<String>)`](crate::client::fluent_builders::ModifyCluster::set_kms_key_id): <p>The Key Management Service (KMS) key ID of the encryption key that you want to use to encrypt data in the cluster.</p>
    ///   - [`availability_zone_relocation(bool)`](crate::client::fluent_builders::ModifyCluster::availability_zone_relocation) / [`set_availability_zone_relocation(Option<bool>)`](crate::client::fluent_builders::ModifyCluster::set_availability_zone_relocation): <p>The option to enable relocation for an Amazon Redshift cluster between Availability Zones after the cluster modification is complete.</p>
    ///   - [`availability_zone(impl Into<String>)`](crate::client::fluent_builders::ModifyCluster::availability_zone) / [`set_availability_zone(Option<String>)`](crate::client::fluent_builders::ModifyCluster::set_availability_zone): <p>The option to initiate relocation for an Amazon Redshift cluster to the target Availability Zone.</p>
    ///   - [`port(i32)`](crate::client::fluent_builders::ModifyCluster::port) / [`set_port(Option<i32>)`](crate::client::fluent_builders::ModifyCluster::set_port): <p>The option to change the port of an Amazon Redshift cluster.</p>
    /// - On success, responds with [`ModifyClusterOutput`](crate::output::ModifyClusterOutput) with field(s):
    ///   - [`cluster(Option<Cluster>)`](crate::output::ModifyClusterOutput::cluster): <p>Describes a cluster.</p>
    /// - On failure, responds with [`SdkError<ModifyClusterError>`](crate::error::ModifyClusterError)
    pub fn modify_cluster(&self) -> fluent_builders::ModifyCluster {
        fluent_builders::ModifyCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ModifyClusterDbRevision`](crate::client::fluent_builders::ModifyClusterDbRevision) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster_identifier(impl Into<String>)`](crate::client::fluent_builders::ModifyClusterDbRevision::cluster_identifier) / [`set_cluster_identifier(Option<String>)`](crate::client::fluent_builders::ModifyClusterDbRevision::set_cluster_identifier): <p>The unique identifier of a cluster whose database revision you want to modify. </p>  <p>Example: <code>examplecluster</code> </p>
    ///   - [`revision_target(impl Into<String>)`](crate::client::fluent_builders::ModifyClusterDbRevision::revision_target) / [`set_revision_target(Option<String>)`](crate::client::fluent_builders::ModifyClusterDbRevision::set_revision_target): <p>The identifier of the database revision. You can retrieve this value from the response to the <code>DescribeClusterDbRevisions</code> request.</p>
    /// - On success, responds with [`ModifyClusterDbRevisionOutput`](crate::output::ModifyClusterDbRevisionOutput) with field(s):
    ///   - [`cluster(Option<Cluster>)`](crate::output::ModifyClusterDbRevisionOutput::cluster): <p>Describes a cluster.</p>
    /// - On failure, responds with [`SdkError<ModifyClusterDbRevisionError>`](crate::error::ModifyClusterDbRevisionError)
    pub fn modify_cluster_db_revision(&self) -> fluent_builders::ModifyClusterDbRevision {
        fluent_builders::ModifyClusterDbRevision::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ModifyClusterIamRoles`](crate::client::fluent_builders::ModifyClusterIamRoles) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster_identifier(impl Into<String>)`](crate::client::fluent_builders::ModifyClusterIamRoles::cluster_identifier) / [`set_cluster_identifier(Option<String>)`](crate::client::fluent_builders::ModifyClusterIamRoles::set_cluster_identifier): <p>The unique identifier of the cluster for which you want to associate or disassociate IAM roles.</p>
    ///   - [`add_iam_roles(Vec<String>)`](crate::client::fluent_builders::ModifyClusterIamRoles::add_iam_roles) / [`set_add_iam_roles(Option<Vec<String>>)`](crate::client::fluent_builders::ModifyClusterIamRoles::set_add_iam_roles): <p>Zero or more IAM roles to associate with the cluster. The roles must be in their Amazon Resource Name (ARN) format. </p>
    ///   - [`remove_iam_roles(Vec<String>)`](crate::client::fluent_builders::ModifyClusterIamRoles::remove_iam_roles) / [`set_remove_iam_roles(Option<Vec<String>>)`](crate::client::fluent_builders::ModifyClusterIamRoles::set_remove_iam_roles): <p>Zero or more IAM roles in ARN format to disassociate from the cluster. </p>
    ///   - [`default_iam_role_arn(impl Into<String>)`](crate::client::fluent_builders::ModifyClusterIamRoles::default_iam_role_arn) / [`set_default_iam_role_arn(Option<String>)`](crate::client::fluent_builders::ModifyClusterIamRoles::set_default_iam_role_arn): <p>The Amazon Resource Name (ARN) for the IAM role that was set as default for the cluster when the cluster was last modified.</p>
    /// - On success, responds with [`ModifyClusterIamRolesOutput`](crate::output::ModifyClusterIamRolesOutput) with field(s):
    ///   - [`cluster(Option<Cluster>)`](crate::output::ModifyClusterIamRolesOutput::cluster): <p>Describes a cluster.</p>
    /// - On failure, responds with [`SdkError<ModifyClusterIamRolesError>`](crate::error::ModifyClusterIamRolesError)
    pub fn modify_cluster_iam_roles(&self) -> fluent_builders::ModifyClusterIamRoles {
        fluent_builders::ModifyClusterIamRoles::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ModifyClusterMaintenance`](crate::client::fluent_builders::ModifyClusterMaintenance) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster_identifier(impl Into<String>)`](crate::client::fluent_builders::ModifyClusterMaintenance::cluster_identifier) / [`set_cluster_identifier(Option<String>)`](crate::client::fluent_builders::ModifyClusterMaintenance::set_cluster_identifier): <p>A unique identifier for the cluster.</p>
    ///   - [`defer_maintenance(bool)`](crate::client::fluent_builders::ModifyClusterMaintenance::defer_maintenance) / [`set_defer_maintenance(Option<bool>)`](crate::client::fluent_builders::ModifyClusterMaintenance::set_defer_maintenance): <p>A boolean indicating whether to enable the deferred maintenance window. </p>
    ///   - [`defer_maintenance_identifier(impl Into<String>)`](crate::client::fluent_builders::ModifyClusterMaintenance::defer_maintenance_identifier) / [`set_defer_maintenance_identifier(Option<String>)`](crate::client::fluent_builders::ModifyClusterMaintenance::set_defer_maintenance_identifier): <p>A unique identifier for the deferred maintenance window.</p>
    ///   - [`defer_maintenance_start_time(DateTime)`](crate::client::fluent_builders::ModifyClusterMaintenance::defer_maintenance_start_time) / [`set_defer_maintenance_start_time(Option<DateTime>)`](crate::client::fluent_builders::ModifyClusterMaintenance::set_defer_maintenance_start_time): <p>A timestamp indicating the start time for the deferred maintenance window.</p>
    ///   - [`defer_maintenance_end_time(DateTime)`](crate::client::fluent_builders::ModifyClusterMaintenance::defer_maintenance_end_time) / [`set_defer_maintenance_end_time(Option<DateTime>)`](crate::client::fluent_builders::ModifyClusterMaintenance::set_defer_maintenance_end_time): <p>A timestamp indicating end time for the deferred maintenance window. If you specify an end time, you can't specify a duration.</p>
    ///   - [`defer_maintenance_duration(i32)`](crate::client::fluent_builders::ModifyClusterMaintenance::defer_maintenance_duration) / [`set_defer_maintenance_duration(Option<i32>)`](crate::client::fluent_builders::ModifyClusterMaintenance::set_defer_maintenance_duration): <p>An integer indicating the duration of the maintenance window in days. If you specify a duration, you can't specify an end time. The duration must be 45 days or less.</p>
    /// - On success, responds with [`ModifyClusterMaintenanceOutput`](crate::output::ModifyClusterMaintenanceOutput) with field(s):
    ///   - [`cluster(Option<Cluster>)`](crate::output::ModifyClusterMaintenanceOutput::cluster): <p>Describes a cluster.</p>
    /// - On failure, responds with [`SdkError<ModifyClusterMaintenanceError>`](crate::error::ModifyClusterMaintenanceError)
    pub fn modify_cluster_maintenance(&self) -> fluent_builders::ModifyClusterMaintenance {
        fluent_builders::ModifyClusterMaintenance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ModifyClusterParameterGroup`](crate::client::fluent_builders::ModifyClusterParameterGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`parameter_group_name(impl Into<String>)`](crate::client::fluent_builders::ModifyClusterParameterGroup::parameter_group_name) / [`set_parameter_group_name(Option<String>)`](crate::client::fluent_builders::ModifyClusterParameterGroup::set_parameter_group_name): <p>The name of the parameter group to be modified.</p>
    ///   - [`parameters(Vec<Parameter>)`](crate::client::fluent_builders::ModifyClusterParameterGroup::parameters) / [`set_parameters(Option<Vec<Parameter>>)`](crate::client::fluent_builders::ModifyClusterParameterGroup::set_parameters): <p>An array of parameters to be modified. A maximum of 20 parameters can be modified in a single request.</p>  <p>For each parameter to be modified, you must supply at least the parameter name and parameter value; other name-value pairs of the parameter are optional.</p>  <p>For the workload management (WLM) configuration, you must supply all the name-value pairs in the wlm_json_configuration parameter.</p>
    /// - On success, responds with [`ModifyClusterParameterGroupOutput`](crate::output::ModifyClusterParameterGroupOutput) with field(s):
    ///   - [`parameter_group_name(Option<String>)`](crate::output::ModifyClusterParameterGroupOutput::parameter_group_name): <p>The name of the cluster parameter group.</p>
    ///   - [`parameter_group_status(Option<String>)`](crate::output::ModifyClusterParameterGroupOutput::parameter_group_status): <p>The status of the parameter group. For example, if you made a change to a parameter group name-value pair, then the change could be pending a reboot of an associated cluster.</p>
    /// - On failure, responds with [`SdkError<ModifyClusterParameterGroupError>`](crate::error::ModifyClusterParameterGroupError)
    pub fn modify_cluster_parameter_group(&self) -> fluent_builders::ModifyClusterParameterGroup {
        fluent_builders::ModifyClusterParameterGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ModifyClusterSnapshot`](crate::client::fluent_builders::ModifyClusterSnapshot) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`snapshot_identifier(impl Into<String>)`](crate::client::fluent_builders::ModifyClusterSnapshot::snapshot_identifier) / [`set_snapshot_identifier(Option<String>)`](crate::client::fluent_builders::ModifyClusterSnapshot::set_snapshot_identifier): <p>The identifier of the snapshot whose setting you want to modify.</p>
    ///   - [`manual_snapshot_retention_period(i32)`](crate::client::fluent_builders::ModifyClusterSnapshot::manual_snapshot_retention_period) / [`set_manual_snapshot_retention_period(Option<i32>)`](crate::client::fluent_builders::ModifyClusterSnapshot::set_manual_snapshot_retention_period): <p>The number of days that a manual snapshot is retained. If the value is -1, the manual snapshot is retained indefinitely.</p>  <p>If the manual snapshot falls outside of the new retention period, you can specify the force option to immediately delete the snapshot.</p>  <p>The value must be either -1 or an integer between 1 and 3,653.</p>
    ///   - [`force(bool)`](crate::client::fluent_builders::ModifyClusterSnapshot::force) / [`set_force(bool)`](crate::client::fluent_builders::ModifyClusterSnapshot::set_force): <p>A Boolean option to override an exception if the retention period has already passed.</p>
    /// - On success, responds with [`ModifyClusterSnapshotOutput`](crate::output::ModifyClusterSnapshotOutput) with field(s):
    ///   - [`snapshot(Option<Snapshot>)`](crate::output::ModifyClusterSnapshotOutput::snapshot): <p>Describes a snapshot.</p>
    /// - On failure, responds with [`SdkError<ModifyClusterSnapshotError>`](crate::error::ModifyClusterSnapshotError)
    pub fn modify_cluster_snapshot(&self) -> fluent_builders::ModifyClusterSnapshot {
        fluent_builders::ModifyClusterSnapshot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ModifyClusterSnapshotSchedule`](crate::client::fluent_builders::ModifyClusterSnapshotSchedule) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster_identifier(impl Into<String>)`](crate::client::fluent_builders::ModifyClusterSnapshotSchedule::cluster_identifier) / [`set_cluster_identifier(Option<String>)`](crate::client::fluent_builders::ModifyClusterSnapshotSchedule::set_cluster_identifier): <p>A unique identifier for the cluster whose snapshot schedule you want to modify. </p>
    ///   - [`schedule_identifier(impl Into<String>)`](crate::client::fluent_builders::ModifyClusterSnapshotSchedule::schedule_identifier) / [`set_schedule_identifier(Option<String>)`](crate::client::fluent_builders::ModifyClusterSnapshotSchedule::set_schedule_identifier): <p>A unique alphanumeric identifier for the schedule that you want to associate with the cluster.</p>
    ///   - [`disassociate_schedule(bool)`](crate::client::fluent_builders::ModifyClusterSnapshotSchedule::disassociate_schedule) / [`set_disassociate_schedule(Option<bool>)`](crate::client::fluent_builders::ModifyClusterSnapshotSchedule::set_disassociate_schedule): <p>A boolean to indicate whether to remove the assoiciation between the cluster and the schedule.</p>
    /// - On success, responds with [`ModifyClusterSnapshotScheduleOutput`](crate::output::ModifyClusterSnapshotScheduleOutput)

    /// - On failure, responds with [`SdkError<ModifyClusterSnapshotScheduleError>`](crate::error::ModifyClusterSnapshotScheduleError)
    pub fn modify_cluster_snapshot_schedule(
        &self,
    ) -> fluent_builders::ModifyClusterSnapshotSchedule {
        fluent_builders::ModifyClusterSnapshotSchedule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ModifyClusterSubnetGroup`](crate::client::fluent_builders::ModifyClusterSubnetGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster_subnet_group_name(impl Into<String>)`](crate::client::fluent_builders::ModifyClusterSubnetGroup::cluster_subnet_group_name) / [`set_cluster_subnet_group_name(Option<String>)`](crate::client::fluent_builders::ModifyClusterSubnetGroup::set_cluster_subnet_group_name): <p>The name of the subnet group to be modified.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::ModifyClusterSubnetGroup::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::ModifyClusterSubnetGroup::set_description): <p>A text description of the subnet group to be modified.</p>
    ///   - [`subnet_ids(Vec<String>)`](crate::client::fluent_builders::ModifyClusterSubnetGroup::subnet_ids) / [`set_subnet_ids(Option<Vec<String>>)`](crate::client::fluent_builders::ModifyClusterSubnetGroup::set_subnet_ids): <p>An array of VPC subnet IDs. A maximum of 20 subnets can be modified in a single request.</p>
    /// - On success, responds with [`ModifyClusterSubnetGroupOutput`](crate::output::ModifyClusterSubnetGroupOutput) with field(s):
    ///   - [`cluster_subnet_group(Option<ClusterSubnetGroup>)`](crate::output::ModifyClusterSubnetGroupOutput::cluster_subnet_group): <p>Describes a subnet group.</p>
    /// - On failure, responds with [`SdkError<ModifyClusterSubnetGroupError>`](crate::error::ModifyClusterSubnetGroupError)
    pub fn modify_cluster_subnet_group(&self) -> fluent_builders::ModifyClusterSubnetGroup {
        fluent_builders::ModifyClusterSubnetGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ModifyEndpointAccess`](crate::client::fluent_builders::ModifyEndpointAccess) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`endpoint_name(impl Into<String>)`](crate::client::fluent_builders::ModifyEndpointAccess::endpoint_name) / [`set_endpoint_name(Option<String>)`](crate::client::fluent_builders::ModifyEndpointAccess::set_endpoint_name): <p>The endpoint to be modified.</p>
    ///   - [`vpc_security_group_ids(Vec<String>)`](crate::client::fluent_builders::ModifyEndpointAccess::vpc_security_group_ids) / [`set_vpc_security_group_ids(Option<Vec<String>>)`](crate::client::fluent_builders::ModifyEndpointAccess::set_vpc_security_group_ids): <p>The complete list of VPC security groups associated with the endpoint after the endpoint is modified.</p>
    /// - On success, responds with [`ModifyEndpointAccessOutput`](crate::output::ModifyEndpointAccessOutput) with field(s):
    ///   - [`cluster_identifier(Option<String>)`](crate::output::ModifyEndpointAccessOutput::cluster_identifier): <p>The cluster identifier of the cluster associated with the endpoint.</p>
    ///   - [`resource_owner(Option<String>)`](crate::output::ModifyEndpointAccessOutput::resource_owner): <p>The Amazon Web Services account ID of the owner of the cluster.</p>
    ///   - [`subnet_group_name(Option<String>)`](crate::output::ModifyEndpointAccessOutput::subnet_group_name): <p>The subnet group name where Amazon Redshift chooses to deploy the endpoint.</p>
    ///   - [`endpoint_status(Option<String>)`](crate::output::ModifyEndpointAccessOutput::endpoint_status): <p>The status of the endpoint.</p>
    ///   - [`endpoint_name(Option<String>)`](crate::output::ModifyEndpointAccessOutput::endpoint_name): <p>The name of the endpoint.</p>
    ///   - [`endpoint_create_time(Option<DateTime>)`](crate::output::ModifyEndpointAccessOutput::endpoint_create_time): <p>The time (UTC) that the endpoint was created.</p>
    ///   - [`port(i32)`](crate::output::ModifyEndpointAccessOutput::port): <p>The port number on which the cluster accepts incoming connections.</p>
    ///   - [`address(Option<String>)`](crate::output::ModifyEndpointAccessOutput::address): <p>The DNS address of the endpoint.</p>
    ///   - [`vpc_security_groups(Option<Vec<VpcSecurityGroupMembership>>)`](crate::output::ModifyEndpointAccessOutput::vpc_security_groups): <p>The security groups associated with the endpoint.</p>
    ///   - [`vpc_endpoint(Option<VpcEndpoint>)`](crate::output::ModifyEndpointAccessOutput::vpc_endpoint): <p>The connection endpoint for connecting to an Amazon Redshift cluster through the proxy.</p>
    /// - On failure, responds with [`SdkError<ModifyEndpointAccessError>`](crate::error::ModifyEndpointAccessError)
    pub fn modify_endpoint_access(&self) -> fluent_builders::ModifyEndpointAccess {
        fluent_builders::ModifyEndpointAccess::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ModifyEventSubscription`](crate::client::fluent_builders::ModifyEventSubscription) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`subscription_name(impl Into<String>)`](crate::client::fluent_builders::ModifyEventSubscription::subscription_name) / [`set_subscription_name(Option<String>)`](crate::client::fluent_builders::ModifyEventSubscription::set_subscription_name): <p>The name of the modified Amazon Redshift event notification subscription.</p>
    ///   - [`sns_topic_arn(impl Into<String>)`](crate::client::fluent_builders::ModifyEventSubscription::sns_topic_arn) / [`set_sns_topic_arn(Option<String>)`](crate::client::fluent_builders::ModifyEventSubscription::set_sns_topic_arn): <p>The Amazon Resource Name (ARN) of the SNS topic to be used by the event notification subscription.</p>
    ///   - [`source_type(impl Into<String>)`](crate::client::fluent_builders::ModifyEventSubscription::source_type) / [`set_source_type(Option<String>)`](crate::client::fluent_builders::ModifyEventSubscription::set_source_type): <p>The type of source that will be generating the events. For example, if you want to be notified of events generated by a cluster, you would set this parameter to cluster. If this value is not specified, events are returned for all Amazon Redshift objects in your Amazon Web Services account. You must specify a source type in order to specify source IDs.</p>  <p>Valid values: cluster, cluster-parameter-group, cluster-security-group, cluster-snapshot, and scheduled-action.</p>
    ///   - [`source_ids(Vec<String>)`](crate::client::fluent_builders::ModifyEventSubscription::source_ids) / [`set_source_ids(Option<Vec<String>>)`](crate::client::fluent_builders::ModifyEventSubscription::set_source_ids): <p>A list of one or more identifiers of Amazon Redshift source objects. All of the objects must be of the same type as was specified in the source type parameter. The event subscription will return only events generated by the specified objects. If not specified, then events are returned for all objects within the source type specified.</p>  <p>Example: my-cluster-1, my-cluster-2</p>  <p>Example: my-snapshot-20131010</p>
    ///   - [`event_categories(Vec<String>)`](crate::client::fluent_builders::ModifyEventSubscription::event_categories) / [`set_event_categories(Option<Vec<String>>)`](crate::client::fluent_builders::ModifyEventSubscription::set_event_categories): <p>Specifies the Amazon Redshift event categories to be published by the event notification subscription.</p>  <p>Values: configuration, management, monitoring, security, pending</p>
    ///   - [`severity(impl Into<String>)`](crate::client::fluent_builders::ModifyEventSubscription::severity) / [`set_severity(Option<String>)`](crate::client::fluent_builders::ModifyEventSubscription::set_severity): <p>Specifies the Amazon Redshift event severity to be published by the event notification subscription.</p>  <p>Values: ERROR, INFO</p>
    ///   - [`enabled(bool)`](crate::client::fluent_builders::ModifyEventSubscription::enabled) / [`set_enabled(Option<bool>)`](crate::client::fluent_builders::ModifyEventSubscription::set_enabled): <p>A Boolean value indicating if the subscription is enabled. <code>true</code> indicates the subscription is enabled </p>
    /// - On success, responds with [`ModifyEventSubscriptionOutput`](crate::output::ModifyEventSubscriptionOutput) with field(s):
    ///   - [`event_subscription(Option<EventSubscription>)`](crate::output::ModifyEventSubscriptionOutput::event_subscription): <p>Describes event subscriptions.</p>
    /// - On failure, responds with [`SdkError<ModifyEventSubscriptionError>`](crate::error::ModifyEventSubscriptionError)
    pub fn modify_event_subscription(&self) -> fluent_builders::ModifyEventSubscription {
        fluent_builders::ModifyEventSubscription::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ModifyScheduledAction`](crate::client::fluent_builders::ModifyScheduledAction) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`scheduled_action_name(impl Into<String>)`](crate::client::fluent_builders::ModifyScheduledAction::scheduled_action_name) / [`set_scheduled_action_name(Option<String>)`](crate::client::fluent_builders::ModifyScheduledAction::set_scheduled_action_name): <p>The name of the scheduled action to modify. </p>
    ///   - [`target_action(ScheduledActionType)`](crate::client::fluent_builders::ModifyScheduledAction::target_action) / [`set_target_action(Option<ScheduledActionType>)`](crate::client::fluent_builders::ModifyScheduledAction::set_target_action): <p>A modified JSON format of the scheduled action. For more information about this parameter, see <code>ScheduledAction</code>. </p>
    ///   - [`schedule(impl Into<String>)`](crate::client::fluent_builders::ModifyScheduledAction::schedule) / [`set_schedule(Option<String>)`](crate::client::fluent_builders::ModifyScheduledAction::set_schedule): <p>A modified schedule in either <code>at( )</code> or <code>cron( )</code> format. For more information about this parameter, see <code>ScheduledAction</code>.</p>
    ///   - [`iam_role(impl Into<String>)`](crate::client::fluent_builders::ModifyScheduledAction::iam_role) / [`set_iam_role(Option<String>)`](crate::client::fluent_builders::ModifyScheduledAction::set_iam_role): <p>A different IAM role to assume to run the target action. For more information about this parameter, see <code>ScheduledAction</code>.</p>
    ///   - [`scheduled_action_description(impl Into<String>)`](crate::client::fluent_builders::ModifyScheduledAction::scheduled_action_description) / [`set_scheduled_action_description(Option<String>)`](crate::client::fluent_builders::ModifyScheduledAction::set_scheduled_action_description): <p>A modified description of the scheduled action. </p>
    ///   - [`start_time(DateTime)`](crate::client::fluent_builders::ModifyScheduledAction::start_time) / [`set_start_time(Option<DateTime>)`](crate::client::fluent_builders::ModifyScheduledAction::set_start_time): <p>A modified start time of the scheduled action. For more information about this parameter, see <code>ScheduledAction</code>. </p>
    ///   - [`end_time(DateTime)`](crate::client::fluent_builders::ModifyScheduledAction::end_time) / [`set_end_time(Option<DateTime>)`](crate::client::fluent_builders::ModifyScheduledAction::set_end_time): <p>A modified end time of the scheduled action. For more information about this parameter, see <code>ScheduledAction</code>. </p>
    ///   - [`enable(bool)`](crate::client::fluent_builders::ModifyScheduledAction::enable) / [`set_enable(Option<bool>)`](crate::client::fluent_builders::ModifyScheduledAction::set_enable): <p>A modified enable flag of the scheduled action. If true, the scheduled action is active. If false, the scheduled action is disabled. </p>
    /// - On success, responds with [`ModifyScheduledActionOutput`](crate::output::ModifyScheduledActionOutput) with field(s):
    ///   - [`scheduled_action_name(Option<String>)`](crate::output::ModifyScheduledActionOutput::scheduled_action_name): <p>The name of the scheduled action. </p>
    ///   - [`target_action(Option<ScheduledActionType>)`](crate::output::ModifyScheduledActionOutput::target_action): <p>A JSON format string of the Amazon Redshift API operation with input parameters. </p>  <p>"<code>{\"ResizeCluster\":{\"NodeType\":\"ds2.8xlarge\",\"ClusterIdentifier\":\"my-test-cluster\",\"NumberOfNodes\":3}}</code>". </p>
    ///   - [`schedule(Option<String>)`](crate::output::ModifyScheduledActionOutput::schedule): <p>The schedule for a one-time (at format) or recurring (cron format) scheduled action. Schedule invocations must be separated by at least one hour.</p>  <p>Format of at expressions is "<code>at(yyyy-mm-ddThh:mm:ss)</code>". For example, "<code>at(2016-03-04T17:27:00)</code>".</p>  <p>Format of cron expressions is "<code>cron(Minutes Hours Day-of-month Month Day-of-week Year)</code>". For example, "<code>cron(0 10 ? * MON *)</code>". For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html#CronExpressions">Cron Expressions</a> in the <i>Amazon CloudWatch Events User Guide</i>.</p>
    ///   - [`iam_role(Option<String>)`](crate::output::ModifyScheduledActionOutput::iam_role): <p>The IAM role to assume to run the scheduled action. This IAM role must have permission to run the Amazon Redshift API operation in the scheduled action. This IAM role must allow the Amazon Redshift scheduler (Principal scheduler.redshift.amazonaws.com) to assume permissions on your behalf. For more information about the IAM role to use with the Amazon Redshift scheduler, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-identity-based.html">Using Identity-Based Policies for Amazon Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>. </p>
    ///   - [`scheduled_action_description(Option<String>)`](crate::output::ModifyScheduledActionOutput::scheduled_action_description): <p>The description of the scheduled action. </p>
    ///   - [`state(Option<ScheduledActionState>)`](crate::output::ModifyScheduledActionOutput::state): <p>The state of the scheduled action. For example, <code>DISABLED</code>. </p>
    ///   - [`next_invocations(Option<Vec<DateTime>>)`](crate::output::ModifyScheduledActionOutput::next_invocations): <p>List of times when the scheduled action will run. </p>
    ///   - [`start_time(Option<DateTime>)`](crate::output::ModifyScheduledActionOutput::start_time): <p>The start time in UTC when the schedule is active. Before this time, the scheduled action does not trigger. </p>
    ///   - [`end_time(Option<DateTime>)`](crate::output::ModifyScheduledActionOutput::end_time): <p>The end time in UTC when the schedule is no longer active. After this time, the scheduled action does not trigger. </p>
    /// - On failure, responds with [`SdkError<ModifyScheduledActionError>`](crate::error::ModifyScheduledActionError)
    pub fn modify_scheduled_action(&self) -> fluent_builders::ModifyScheduledAction {
        fluent_builders::ModifyScheduledAction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ModifySnapshotCopyRetentionPeriod`](crate::client::fluent_builders::ModifySnapshotCopyRetentionPeriod) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster_identifier(impl Into<String>)`](crate::client::fluent_builders::ModifySnapshotCopyRetentionPeriod::cluster_identifier) / [`set_cluster_identifier(Option<String>)`](crate::client::fluent_builders::ModifySnapshotCopyRetentionPeriod::set_cluster_identifier): <p>The unique identifier of the cluster for which you want to change the retention period for either automated or manual snapshots that are copied to a destination Amazon Web Services Region.</p>  <p>Constraints: Must be the valid name of an existing cluster that has cross-region snapshot copy enabled.</p>
    ///   - [`retention_period(i32)`](crate::client::fluent_builders::ModifySnapshotCopyRetentionPeriod::retention_period) / [`set_retention_period(i32)`](crate::client::fluent_builders::ModifySnapshotCopyRetentionPeriod::set_retention_period): <p>The number of days to retain automated snapshots in the destination Amazon Web Services Region after they are copied from the source Amazon Web Services Region.</p>  <p>By default, this only changes the retention period of copied automated snapshots. </p>  <p>If you decrease the retention period for automated snapshots that are copied to a destination Amazon Web Services Region, Amazon Redshift deletes any existing automated snapshots that were copied to the destination Amazon Web Services Region and that fall outside of the new retention period.</p>  <p>Constraints: Must be at least 1 and no more than 35 for automated snapshots. </p>  <p>If you specify the <code>manual</code> option, only newly copied manual snapshots will have the new retention period. </p>  <p>If you specify the value of -1 newly copied manual snapshots are retained indefinitely.</p>  <p>Constraints: The number of days must be either -1 or an integer between 1 and 3,653 for manual snapshots.</p>
    ///   - [`manual(bool)`](crate::client::fluent_builders::ModifySnapshotCopyRetentionPeriod::manual) / [`set_manual(bool)`](crate::client::fluent_builders::ModifySnapshotCopyRetentionPeriod::set_manual): <p>Indicates whether to apply the snapshot retention period to newly copied manual snapshots instead of automated snapshots.</p>
    /// - On success, responds with [`ModifySnapshotCopyRetentionPeriodOutput`](crate::output::ModifySnapshotCopyRetentionPeriodOutput) with field(s):
    ///   - [`cluster(Option<Cluster>)`](crate::output::ModifySnapshotCopyRetentionPeriodOutput::cluster): <p>Describes a cluster.</p>
    /// - On failure, responds with [`SdkError<ModifySnapshotCopyRetentionPeriodError>`](crate::error::ModifySnapshotCopyRetentionPeriodError)
    pub fn modify_snapshot_copy_retention_period(
        &self,
    ) -> fluent_builders::ModifySnapshotCopyRetentionPeriod {
        fluent_builders::ModifySnapshotCopyRetentionPeriod::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ModifySnapshotSchedule`](crate::client::fluent_builders::ModifySnapshotSchedule) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`schedule_identifier(impl Into<String>)`](crate::client::fluent_builders::ModifySnapshotSchedule::schedule_identifier) / [`set_schedule_identifier(Option<String>)`](crate::client::fluent_builders::ModifySnapshotSchedule::set_schedule_identifier): <p>A unique alphanumeric identifier of the schedule to modify.</p>
    ///   - [`schedule_definitions(Vec<String>)`](crate::client::fluent_builders::ModifySnapshotSchedule::schedule_definitions) / [`set_schedule_definitions(Option<Vec<String>>)`](crate::client::fluent_builders::ModifySnapshotSchedule::set_schedule_definitions): <p>An updated list of schedule definitions. A schedule definition is made up of schedule expressions, for example, "cron(30 12 *)" or "rate(12 hours)".</p>
    /// - On success, responds with [`ModifySnapshotScheduleOutput`](crate::output::ModifySnapshotScheduleOutput) with field(s):
    ///   - [`schedule_definitions(Option<Vec<String>>)`](crate::output::ModifySnapshotScheduleOutput::schedule_definitions): <p>A list of ScheduleDefinitions.</p>
    ///   - [`schedule_identifier(Option<String>)`](crate::output::ModifySnapshotScheduleOutput::schedule_identifier): <p>A unique identifier for the schedule.</p>
    ///   - [`schedule_description(Option<String>)`](crate::output::ModifySnapshotScheduleOutput::schedule_description): <p>The description of the schedule.</p>
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::ModifySnapshotScheduleOutput::tags): <p>An optional set of tags describing the schedule.</p>
    ///   - [`next_invocations(Option<Vec<DateTime>>)`](crate::output::ModifySnapshotScheduleOutput::next_invocations): <p></p>
    ///   - [`associated_cluster_count(Option<i32>)`](crate::output::ModifySnapshotScheduleOutput::associated_cluster_count): <p>The number of clusters associated with the schedule.</p>
    ///   - [`associated_clusters(Option<Vec<ClusterAssociatedToSchedule>>)`](crate::output::ModifySnapshotScheduleOutput::associated_clusters): <p>A list of clusters associated with the schedule. A maximum of 100 clusters is returned.</p>
    /// - On failure, responds with [`SdkError<ModifySnapshotScheduleError>`](crate::error::ModifySnapshotScheduleError)
    pub fn modify_snapshot_schedule(&self) -> fluent_builders::ModifySnapshotSchedule {
        fluent_builders::ModifySnapshotSchedule::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ModifyUsageLimit`](crate::client::fluent_builders::ModifyUsageLimit) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`usage_limit_id(impl Into<String>)`](crate::client::fluent_builders::ModifyUsageLimit::usage_limit_id) / [`set_usage_limit_id(Option<String>)`](crate::client::fluent_builders::ModifyUsageLimit::set_usage_limit_id): <p>The identifier of the usage limit to modify.</p>
    ///   - [`amount(i64)`](crate::client::fluent_builders::ModifyUsageLimit::amount) / [`set_amount(Option<i64>)`](crate::client::fluent_builders::ModifyUsageLimit::set_amount): <p>The new limit amount. For more information about this parameter, see <code>UsageLimit</code>. </p>
    ///   - [`breach_action(UsageLimitBreachAction)`](crate::client::fluent_builders::ModifyUsageLimit::breach_action) / [`set_breach_action(Option<UsageLimitBreachAction>)`](crate::client::fluent_builders::ModifyUsageLimit::set_breach_action): <p>The new action that Amazon Redshift takes when the limit is reached. For more information about this parameter, see <code>UsageLimit</code>. </p>
    /// - On success, responds with [`ModifyUsageLimitOutput`](crate::output::ModifyUsageLimitOutput) with field(s):
    ///   - [`usage_limit_id(Option<String>)`](crate::output::ModifyUsageLimitOutput::usage_limit_id): <p>The identifier of the usage limit.</p>
    ///   - [`cluster_identifier(Option<String>)`](crate::output::ModifyUsageLimitOutput::cluster_identifier): <p>The identifier of the cluster with a usage limit.</p>
    ///   - [`feature_type(Option<UsageLimitFeatureType>)`](crate::output::ModifyUsageLimitOutput::feature_type): <p>The Amazon Redshift feature to which the limit applies.</p>
    ///   - [`limit_type(Option<UsageLimitLimitType>)`](crate::output::ModifyUsageLimitOutput::limit_type): <p>The type of limit. Depending on the feature type, this can be based on a time duration or data size.</p>
    ///   - [`amount(i64)`](crate::output::ModifyUsageLimitOutput::amount): <p>The limit amount. If time-based, this amount is in minutes. If data-based, this amount is in terabytes (TB).</p>
    ///   - [`period(Option<UsageLimitPeriod>)`](crate::output::ModifyUsageLimitOutput::period): <p>The time period that the amount applies to. A <code>weekly</code> period begins on Sunday. The default is <code>monthly</code>. </p>
    ///   - [`breach_action(Option<UsageLimitBreachAction>)`](crate::output::ModifyUsageLimitOutput::breach_action): <p>The action that Amazon Redshift takes when the limit is reached. Possible values are: </p>  <ul>   <li> <p> <b>log</b> - To log an event in a system table. The default is log.</p> </li>   <li> <p> <b>emit-metric</b> - To emit CloudWatch metrics.</p> </li>   <li> <p> <b>disable</b> - To disable the feature until the next usage period begins.</p> </li>  </ul>
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::ModifyUsageLimitOutput::tags): <p>A list of tag instances.</p>
    /// - On failure, responds with [`SdkError<ModifyUsageLimitError>`](crate::error::ModifyUsageLimitError)
    pub fn modify_usage_limit(&self) -> fluent_builders::ModifyUsageLimit {
        fluent_builders::ModifyUsageLimit::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PauseCluster`](crate::client::fluent_builders::PauseCluster) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster_identifier(impl Into<String>)`](crate::client::fluent_builders::PauseCluster::cluster_identifier) / [`set_cluster_identifier(Option<String>)`](crate::client::fluent_builders::PauseCluster::set_cluster_identifier): <p>The identifier of the cluster to be paused.</p>
    /// - On success, responds with [`PauseClusterOutput`](crate::output::PauseClusterOutput) with field(s):
    ///   - [`cluster(Option<Cluster>)`](crate::output::PauseClusterOutput::cluster): <p>Describes a cluster.</p>
    /// - On failure, responds with [`SdkError<PauseClusterError>`](crate::error::PauseClusterError)
    pub fn pause_cluster(&self) -> fluent_builders::PauseCluster {
        fluent_builders::PauseCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PurchaseReservedNodeOffering`](crate::client::fluent_builders::PurchaseReservedNodeOffering) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`reserved_node_offering_id(impl Into<String>)`](crate::client::fluent_builders::PurchaseReservedNodeOffering::reserved_node_offering_id) / [`set_reserved_node_offering_id(Option<String>)`](crate::client::fluent_builders::PurchaseReservedNodeOffering::set_reserved_node_offering_id): <p>The unique identifier of the reserved node offering you want to purchase.</p>
    ///   - [`node_count(i32)`](crate::client::fluent_builders::PurchaseReservedNodeOffering::node_count) / [`set_node_count(Option<i32>)`](crate::client::fluent_builders::PurchaseReservedNodeOffering::set_node_count): <p>The number of reserved nodes that you want to purchase.</p>  <p>Default: <code>1</code> </p>
    /// - On success, responds with [`PurchaseReservedNodeOfferingOutput`](crate::output::PurchaseReservedNodeOfferingOutput) with field(s):
    ///   - [`reserved_node(Option<ReservedNode>)`](crate::output::PurchaseReservedNodeOfferingOutput::reserved_node): <p>Describes a reserved node. You can call the <code>DescribeReservedNodeOfferings</code> API to obtain the available reserved node offerings. </p>
    /// - On failure, responds with [`SdkError<PurchaseReservedNodeOfferingError>`](crate::error::PurchaseReservedNodeOfferingError)
    pub fn purchase_reserved_node_offering(&self) -> fluent_builders::PurchaseReservedNodeOffering {
        fluent_builders::PurchaseReservedNodeOffering::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RebootCluster`](crate::client::fluent_builders::RebootCluster) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster_identifier(impl Into<String>)`](crate::client::fluent_builders::RebootCluster::cluster_identifier) / [`set_cluster_identifier(Option<String>)`](crate::client::fluent_builders::RebootCluster::set_cluster_identifier): <p>The cluster identifier.</p>
    /// - On success, responds with [`RebootClusterOutput`](crate::output::RebootClusterOutput) with field(s):
    ///   - [`cluster(Option<Cluster>)`](crate::output::RebootClusterOutput::cluster): <p>Describes a cluster.</p>
    /// - On failure, responds with [`SdkError<RebootClusterError>`](crate::error::RebootClusterError)
    pub fn reboot_cluster(&self) -> fluent_builders::RebootCluster {
        fluent_builders::RebootCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RejectDataShare`](crate::client::fluent_builders::RejectDataShare) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`data_share_arn(impl Into<String>)`](crate::client::fluent_builders::RejectDataShare::data_share_arn) / [`set_data_share_arn(Option<String>)`](crate::client::fluent_builders::RejectDataShare::set_data_share_arn): <p>The Amazon Resource Name (ARN) of the datashare to reject.</p>
    /// - On success, responds with [`RejectDataShareOutput`](crate::output::RejectDataShareOutput) with field(s):
    ///   - [`data_share_arn(Option<String>)`](crate::output::RejectDataShareOutput::data_share_arn): <p>An Amazon Resource Name (ARN) that references the datashare that is owned by a specific namespace of the producer cluster. A datashare ARN is in the <code>arn:aws:redshift:{region}:{account-id}:{datashare}:{namespace-guid}/{datashare-name}</code> format.</p>
    ///   - [`producer_arn(Option<String>)`](crate::output::RejectDataShareOutput::producer_arn): <p>The Amazon Resource Name (ARN) of the producer.</p>
    ///   - [`allow_publicly_accessible_consumers(bool)`](crate::output::RejectDataShareOutput::allow_publicly_accessible_consumers): <p>A value that specifies whether the datashare can be shared to a publicly accessible cluster.</p>
    ///   - [`data_share_associations(Option<Vec<DataShareAssociation>>)`](crate::output::RejectDataShareOutput::data_share_associations): <p>A value that specifies when the datashare has an association between a producer and data consumers.</p>
    ///   - [`managed_by(Option<String>)`](crate::output::RejectDataShareOutput::managed_by): <p>The identifier of a datashare to show its managing entity.</p>
    /// - On failure, responds with [`SdkError<RejectDataShareError>`](crate::error::RejectDataShareError)
    pub fn reject_data_share(&self) -> fluent_builders::RejectDataShare {
        fluent_builders::RejectDataShare::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ResetClusterParameterGroup`](crate::client::fluent_builders::ResetClusterParameterGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`parameter_group_name(impl Into<String>)`](crate::client::fluent_builders::ResetClusterParameterGroup::parameter_group_name) / [`set_parameter_group_name(Option<String>)`](crate::client::fluent_builders::ResetClusterParameterGroup::set_parameter_group_name): <p>The name of the cluster parameter group to be reset.</p>
    ///   - [`reset_all_parameters(bool)`](crate::client::fluent_builders::ResetClusterParameterGroup::reset_all_parameters) / [`set_reset_all_parameters(bool)`](crate::client::fluent_builders::ResetClusterParameterGroup::set_reset_all_parameters): <p>If <code>true</code>, all parameters in the specified parameter group will be reset to their default values. </p>  <p>Default: <code>true</code> </p>
    ///   - [`parameters(Vec<Parameter>)`](crate::client::fluent_builders::ResetClusterParameterGroup::parameters) / [`set_parameters(Option<Vec<Parameter>>)`](crate::client::fluent_builders::ResetClusterParameterGroup::set_parameters): <p>An array of names of parameters to be reset. If <i>ResetAllParameters</i> option is not used, then at least one parameter name must be supplied. </p>  <p>Constraints: A maximum of 20 parameters can be reset in a single request.</p>
    /// - On success, responds with [`ResetClusterParameterGroupOutput`](crate::output::ResetClusterParameterGroupOutput) with field(s):
    ///   - [`parameter_group_name(Option<String>)`](crate::output::ResetClusterParameterGroupOutput::parameter_group_name): <p>The name of the cluster parameter group.</p>
    ///   - [`parameter_group_status(Option<String>)`](crate::output::ResetClusterParameterGroupOutput::parameter_group_status): <p>The status of the parameter group. For example, if you made a change to a parameter group name-value pair, then the change could be pending a reboot of an associated cluster.</p>
    /// - On failure, responds with [`SdkError<ResetClusterParameterGroupError>`](crate::error::ResetClusterParameterGroupError)
    pub fn reset_cluster_parameter_group(&self) -> fluent_builders::ResetClusterParameterGroup {
        fluent_builders::ResetClusterParameterGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ResizeCluster`](crate::client::fluent_builders::ResizeCluster) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster_identifier(impl Into<String>)`](crate::client::fluent_builders::ResizeCluster::cluster_identifier) / [`set_cluster_identifier(Option<String>)`](crate::client::fluent_builders::ResizeCluster::set_cluster_identifier): <p>The unique identifier for the cluster to resize.</p>
    ///   - [`cluster_type(impl Into<String>)`](crate::client::fluent_builders::ResizeCluster::cluster_type) / [`set_cluster_type(Option<String>)`](crate::client::fluent_builders::ResizeCluster::set_cluster_type): <p>The new cluster type for the specified cluster.</p>
    ///   - [`node_type(impl Into<String>)`](crate::client::fluent_builders::ResizeCluster::node_type) / [`set_node_type(Option<String>)`](crate::client::fluent_builders::ResizeCluster::set_node_type): <p>The new node type for the nodes you are adding. If not specified, the cluster's current node type is used.</p>
    ///   - [`number_of_nodes(i32)`](crate::client::fluent_builders::ResizeCluster::number_of_nodes) / [`set_number_of_nodes(Option<i32>)`](crate::client::fluent_builders::ResizeCluster::set_number_of_nodes): <p>The new number of nodes for the cluster. If not specified, the cluster's current number of nodes is used.</p>
    ///   - [`classic(bool)`](crate::client::fluent_builders::ResizeCluster::classic) / [`set_classic(Option<bool>)`](crate::client::fluent_builders::ResizeCluster::set_classic): <p>A boolean value indicating whether the resize operation is using the classic resize process. If you don't provide this parameter or set the value to <code>false</code>, the resize type is elastic. </p>
    ///   - [`reserved_node_id(impl Into<String>)`](crate::client::fluent_builders::ResizeCluster::reserved_node_id) / [`set_reserved_node_id(Option<String>)`](crate::client::fluent_builders::ResizeCluster::set_reserved_node_id): <p>The identifier of the reserved node.</p>
    ///   - [`target_reserved_node_offering_id(impl Into<String>)`](crate::client::fluent_builders::ResizeCluster::target_reserved_node_offering_id) / [`set_target_reserved_node_offering_id(Option<String>)`](crate::client::fluent_builders::ResizeCluster::set_target_reserved_node_offering_id): <p>The identifier of the target reserved node offering.</p>
    /// - On success, responds with [`ResizeClusterOutput`](crate::output::ResizeClusterOutput) with field(s):
    ///   - [`cluster(Option<Cluster>)`](crate::output::ResizeClusterOutput::cluster): <p>Describes a cluster.</p>
    /// - On failure, responds with [`SdkError<ResizeClusterError>`](crate::error::ResizeClusterError)
    pub fn resize_cluster(&self) -> fluent_builders::ResizeCluster {
        fluent_builders::ResizeCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RestoreFromClusterSnapshot`](crate::client::fluent_builders::RestoreFromClusterSnapshot) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster_identifier(impl Into<String>)`](crate::client::fluent_builders::RestoreFromClusterSnapshot::cluster_identifier) / [`set_cluster_identifier(Option<String>)`](crate::client::fluent_builders::RestoreFromClusterSnapshot::set_cluster_identifier): <p>The identifier of the cluster that will be created from restoring the snapshot.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must contain from 1 to 63 alphanumeric characters or hyphens.</p> </li>   <li> <p>Alphabetic characters must be lowercase.</p> </li>   <li> <p>First character must be a letter.</p> </li>   <li> <p>Cannot end with a hyphen or contain two consecutive hyphens.</p> </li>   <li> <p>Must be unique for all clusters within an Amazon Web Services account.</p> </li>  </ul>
    ///   - [`snapshot_identifier(impl Into<String>)`](crate::client::fluent_builders::RestoreFromClusterSnapshot::snapshot_identifier) / [`set_snapshot_identifier(Option<String>)`](crate::client::fluent_builders::RestoreFromClusterSnapshot::set_snapshot_identifier): <p>The name of the snapshot from which to create the new cluster. This parameter isn't case sensitive.</p>  <p>Example: <code>my-snapshot-id</code> </p>
    ///   - [`snapshot_cluster_identifier(impl Into<String>)`](crate::client::fluent_builders::RestoreFromClusterSnapshot::snapshot_cluster_identifier) / [`set_snapshot_cluster_identifier(Option<String>)`](crate::client::fluent_builders::RestoreFromClusterSnapshot::set_snapshot_cluster_identifier): <p>The name of the cluster the source snapshot was created from. This parameter is required if your IAM user has a policy containing a snapshot resource element that specifies anything other than * for the cluster name.</p>
    ///   - [`port(i32)`](crate::client::fluent_builders::RestoreFromClusterSnapshot::port) / [`set_port(Option<i32>)`](crate::client::fluent_builders::RestoreFromClusterSnapshot::set_port): <p>The port number on which the cluster accepts connections.</p>  <p>Default: The same port as the original cluster.</p>  <p>Constraints: Must be between <code>1115</code> and <code>65535</code>.</p>
    ///   - [`availability_zone(impl Into<String>)`](crate::client::fluent_builders::RestoreFromClusterSnapshot::availability_zone) / [`set_availability_zone(Option<String>)`](crate::client::fluent_builders::RestoreFromClusterSnapshot::set_availability_zone): <p>The Amazon EC2 Availability Zone in which to restore the cluster.</p>  <p>Default: A random, system-chosen Availability Zone.</p>  <p>Example: <code>us-east-2a</code> </p>
    ///   - [`allow_version_upgrade(bool)`](crate::client::fluent_builders::RestoreFromClusterSnapshot::allow_version_upgrade) / [`set_allow_version_upgrade(Option<bool>)`](crate::client::fluent_builders::RestoreFromClusterSnapshot::set_allow_version_upgrade): <p>If <code>true</code>, major version upgrades can be applied during the maintenance window to the Amazon Redshift engine that is running on the cluster. </p>  <p>Default: <code>true</code> </p>
    ///   - [`cluster_subnet_group_name(impl Into<String>)`](crate::client::fluent_builders::RestoreFromClusterSnapshot::cluster_subnet_group_name) / [`set_cluster_subnet_group_name(Option<String>)`](crate::client::fluent_builders::RestoreFromClusterSnapshot::set_cluster_subnet_group_name): <p>The name of the subnet group where you want to cluster restored.</p>  <p>A snapshot of cluster in VPC can be restored only in VPC. Therefore, you must provide subnet group name where you want the cluster restored.</p>
    ///   - [`publicly_accessible(bool)`](crate::client::fluent_builders::RestoreFromClusterSnapshot::publicly_accessible) / [`set_publicly_accessible(Option<bool>)`](crate::client::fluent_builders::RestoreFromClusterSnapshot::set_publicly_accessible): <p>If <code>true</code>, the cluster can be accessed from a public network. </p>
    ///   - [`owner_account(impl Into<String>)`](crate::client::fluent_builders::RestoreFromClusterSnapshot::owner_account) / [`set_owner_account(Option<String>)`](crate::client::fluent_builders::RestoreFromClusterSnapshot::set_owner_account): <p>The Amazon Web Services account used to create or copy the snapshot. Required if you are restoring a snapshot you do not own, optional if you own the snapshot.</p>
    ///   - [`hsm_client_certificate_identifier(impl Into<String>)`](crate::client::fluent_builders::RestoreFromClusterSnapshot::hsm_client_certificate_identifier) / [`set_hsm_client_certificate_identifier(Option<String>)`](crate::client::fluent_builders::RestoreFromClusterSnapshot::set_hsm_client_certificate_identifier): <p>Specifies the name of the HSM client certificate the Amazon Redshift cluster uses to retrieve the data encryption keys stored in an HSM.</p>
    ///   - [`hsm_configuration_identifier(impl Into<String>)`](crate::client::fluent_builders::RestoreFromClusterSnapshot::hsm_configuration_identifier) / [`set_hsm_configuration_identifier(Option<String>)`](crate::client::fluent_builders::RestoreFromClusterSnapshot::set_hsm_configuration_identifier): <p>Specifies the name of the HSM configuration that contains the information the Amazon Redshift cluster can use to retrieve and store keys in an HSM.</p>
    ///   - [`elastic_ip(impl Into<String>)`](crate::client::fluent_builders::RestoreFromClusterSnapshot::elastic_ip) / [`set_elastic_ip(Option<String>)`](crate::client::fluent_builders::RestoreFromClusterSnapshot::set_elastic_ip): <p>The elastic IP (EIP) address for the cluster.</p>
    ///   - [`cluster_parameter_group_name(impl Into<String>)`](crate::client::fluent_builders::RestoreFromClusterSnapshot::cluster_parameter_group_name) / [`set_cluster_parameter_group_name(Option<String>)`](crate::client::fluent_builders::RestoreFromClusterSnapshot::set_cluster_parameter_group_name): <p>The name of the parameter group to be associated with this cluster.</p>  <p>Default: The default Amazon Redshift cluster parameter group. For information about the default parameter group, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Working with Amazon Redshift Parameter Groups</a>.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must be 1 to 255 alphanumeric characters or hyphens.</p> </li>   <li> <p>First character must be a letter.</p> </li>   <li> <p>Cannot end with a hyphen or contain two consecutive hyphens.</p> </li>  </ul>
    ///   - [`cluster_security_groups(Vec<String>)`](crate::client::fluent_builders::RestoreFromClusterSnapshot::cluster_security_groups) / [`set_cluster_security_groups(Option<Vec<String>>)`](crate::client::fluent_builders::RestoreFromClusterSnapshot::set_cluster_security_groups): <p>A list of security groups to be associated with this cluster.</p>  <p>Default: The default cluster security group for Amazon Redshift.</p>  <p>Cluster security groups only apply to clusters outside of VPCs.</p>
    ///   - [`vpc_security_group_ids(Vec<String>)`](crate::client::fluent_builders::RestoreFromClusterSnapshot::vpc_security_group_ids) / [`set_vpc_security_group_ids(Option<Vec<String>>)`](crate::client::fluent_builders::RestoreFromClusterSnapshot::set_vpc_security_group_ids): <p>A list of Virtual Private Cloud (VPC) security groups to be associated with the cluster.</p>  <p>Default: The default VPC security group is associated with the cluster.</p>  <p>VPC security groups only apply to clusters in VPCs.</p>
    ///   - [`preferred_maintenance_window(impl Into<String>)`](crate::client::fluent_builders::RestoreFromClusterSnapshot::preferred_maintenance_window) / [`set_preferred_maintenance_window(Option<String>)`](crate::client::fluent_builders::RestoreFromClusterSnapshot::set_preferred_maintenance_window): <p>The weekly time range (in UTC) during which automated cluster maintenance can occur.</p>  <p> Format: <code>ddd:hh24:mi-ddd:hh24:mi</code> </p>  <p> Default: The value selected for the cluster from which the snapshot was taken. For more information about the time blocks for each region, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#rs-maintenance-windows">Maintenance Windows</a> in Amazon Redshift Cluster Management Guide. </p>  <p>Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun</p>  <p>Constraints: Minimum 30-minute window.</p>
    ///   - [`automated_snapshot_retention_period(i32)`](crate::client::fluent_builders::RestoreFromClusterSnapshot::automated_snapshot_retention_period) / [`set_automated_snapshot_retention_period(Option<i32>)`](crate::client::fluent_builders::RestoreFromClusterSnapshot::set_automated_snapshot_retention_period): <p>The number of days that automated snapshots are retained. If the value is 0, automated snapshots are disabled. Even if automated snapshots are disabled, you can still create manual snapshots when you want with <code>CreateClusterSnapshot</code>. </p>  <p>You can't disable automated snapshots for RA3 node types. Set the automated retention period from 1-35 days.</p>  <p>Default: The value selected for the cluster from which the snapshot was taken.</p>  <p>Constraints: Must be a value from 0 to 35.</p>
    ///   - [`manual_snapshot_retention_period(i32)`](crate::client::fluent_builders::RestoreFromClusterSnapshot::manual_snapshot_retention_period) / [`set_manual_snapshot_retention_period(Option<i32>)`](crate::client::fluent_builders::RestoreFromClusterSnapshot::set_manual_snapshot_retention_period): <p>The default number of days to retain a manual snapshot. If the value is -1, the snapshot is retained indefinitely. This setting doesn't change the retention period of existing snapshots.</p>  <p>The value must be either -1 or an integer between 1 and 3,653.</p>
    ///   - [`kms_key_id(impl Into<String>)`](crate::client::fluent_builders::RestoreFromClusterSnapshot::kms_key_id) / [`set_kms_key_id(Option<String>)`](crate::client::fluent_builders::RestoreFromClusterSnapshot::set_kms_key_id): <p>The Key Management Service (KMS) key ID of the encryption key to encrypt data in the cluster restored from a shared snapshot. You can also provide the key ID when you restore from an unencrypted snapshot to an encrypted cluster in the same account. Additionally, you can specify a new KMS key ID when you restore from an encrypted snapshot in the same account in order to change it. In that case, the restored cluster is encrypted with the new KMS key ID.</p>
    ///   - [`node_type(impl Into<String>)`](crate::client::fluent_builders::RestoreFromClusterSnapshot::node_type) / [`set_node_type(Option<String>)`](crate::client::fluent_builders::RestoreFromClusterSnapshot::set_node_type): <p>The node type that the restored cluster will be provisioned with.</p>  <p>Default: The node type of the cluster from which the snapshot was taken. You can modify this if you are using any DS node type. In that case, you can choose to restore into another DS node type of the same size. For example, you can restore ds1.8xlarge into ds2.8xlarge, or ds1.xlarge into ds2.xlarge. If you have a DC instance type, you must restore into that same instance type and size. In other words, you can only restore a dc1.large instance type into another dc1.large instance type or dc2.large instance type. You can't restore dc1.8xlarge to dc2.8xlarge. First restore to a dc1.8xlarge cluster, then resize to a dc2.8large cluster. For more information about node types, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#rs-about-clusters-and-nodes"> About Clusters and Nodes</a> in the <i>Amazon Redshift Cluster Management Guide</i>. </p>
    ///   - [`enhanced_vpc_routing(bool)`](crate::client::fluent_builders::RestoreFromClusterSnapshot::enhanced_vpc_routing) / [`set_enhanced_vpc_routing(Option<bool>)`](crate::client::fluent_builders::RestoreFromClusterSnapshot::set_enhanced_vpc_routing): <p>An option that specifies whether to create the cluster with enhanced VPC routing enabled. To create a cluster that uses enhanced VPC routing, the cluster must be in a VPC. For more information, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html">Enhanced VPC Routing</a> in the Amazon Redshift Cluster Management Guide.</p>  <p>If this option is <code>true</code>, enhanced VPC routing is enabled. </p>  <p>Default: false</p>
    ///   - [`additional_info(impl Into<String>)`](crate::client::fluent_builders::RestoreFromClusterSnapshot::additional_info) / [`set_additional_info(Option<String>)`](crate::client::fluent_builders::RestoreFromClusterSnapshot::set_additional_info): <p>Reserved.</p>
    ///   - [`iam_roles(Vec<String>)`](crate::client::fluent_builders::RestoreFromClusterSnapshot::iam_roles) / [`set_iam_roles(Option<Vec<String>>)`](crate::client::fluent_builders::RestoreFromClusterSnapshot::set_iam_roles): <p>A list of Identity and Access Management (IAM) roles that can be used by the cluster to access other Amazon Web Services services. You must supply the IAM roles in their Amazon Resource Name (ARN) format. </p>  <p>The maximum number of IAM roles that you can associate is subject to a quota. For more information, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Quotas and limits</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</p>
    ///   - [`maintenance_track_name(impl Into<String>)`](crate::client::fluent_builders::RestoreFromClusterSnapshot::maintenance_track_name) / [`set_maintenance_track_name(Option<String>)`](crate::client::fluent_builders::RestoreFromClusterSnapshot::set_maintenance_track_name): <p>The name of the maintenance track for the restored cluster. When you take a snapshot, the snapshot inherits the <code>MaintenanceTrack</code> value from the cluster. The snapshot might be on a different track than the cluster that was the source for the snapshot. For example, suppose that you take a snapshot of a cluster that is on the current track and then change the cluster to be on the trailing track. In this case, the snapshot and the source cluster are on different tracks.</p>
    ///   - [`snapshot_schedule_identifier(impl Into<String>)`](crate::client::fluent_builders::RestoreFromClusterSnapshot::snapshot_schedule_identifier) / [`set_snapshot_schedule_identifier(Option<String>)`](crate::client::fluent_builders::RestoreFromClusterSnapshot::set_snapshot_schedule_identifier): <p>A unique identifier for the snapshot schedule.</p>
    ///   - [`number_of_nodes(i32)`](crate::client::fluent_builders::RestoreFromClusterSnapshot::number_of_nodes) / [`set_number_of_nodes(Option<i32>)`](crate::client::fluent_builders::RestoreFromClusterSnapshot::set_number_of_nodes): <p>The number of nodes specified when provisioning the restored cluster.</p>
    ///   - [`availability_zone_relocation(bool)`](crate::client::fluent_builders::RestoreFromClusterSnapshot::availability_zone_relocation) / [`set_availability_zone_relocation(Option<bool>)`](crate::client::fluent_builders::RestoreFromClusterSnapshot::set_availability_zone_relocation): <p>The option to enable relocation for an Amazon Redshift cluster between Availability Zones after the cluster is restored.</p>
    ///   - [`aqua_configuration_status(AquaConfigurationStatus)`](crate::client::fluent_builders::RestoreFromClusterSnapshot::aqua_configuration_status) / [`set_aqua_configuration_status(Option<AquaConfigurationStatus>)`](crate::client::fluent_builders::RestoreFromClusterSnapshot::set_aqua_configuration_status): <p>The value represents how the cluster is configured to use AQUA (Advanced Query Accelerator) after the cluster is restored. Possible values include the following.</p>  <ul>   <li> <p>enabled - Use AQUA if it is available for the current Amazon Web Services Region and Amazon Redshift node type.</p> </li>   <li> <p>disabled - Don't use AQUA. </p> </li>   <li> <p>auto - Amazon Redshift determines whether to use AQUA.</p> </li>  </ul>
    ///   - [`default_iam_role_arn(impl Into<String>)`](crate::client::fluent_builders::RestoreFromClusterSnapshot::default_iam_role_arn) / [`set_default_iam_role_arn(Option<String>)`](crate::client::fluent_builders::RestoreFromClusterSnapshot::set_default_iam_role_arn): <p>The Amazon Resource Name (ARN) for the IAM role that was set as default for the cluster when the cluster was last modified while it was restored from a snapshot.</p>
    ///   - [`reserved_node_id(impl Into<String>)`](crate::client::fluent_builders::RestoreFromClusterSnapshot::reserved_node_id) / [`set_reserved_node_id(Option<String>)`](crate::client::fluent_builders::RestoreFromClusterSnapshot::set_reserved_node_id): <p>The identifier of the target reserved node offering.</p>
    ///   - [`target_reserved_node_offering_id(impl Into<String>)`](crate::client::fluent_builders::RestoreFromClusterSnapshot::target_reserved_node_offering_id) / [`set_target_reserved_node_offering_id(Option<String>)`](crate::client::fluent_builders::RestoreFromClusterSnapshot::set_target_reserved_node_offering_id): <p>The identifier of the target reserved node offering.</p>
    ///   - [`encrypted(bool)`](crate::client::fluent_builders::RestoreFromClusterSnapshot::encrypted) / [`set_encrypted(Option<bool>)`](crate::client::fluent_builders::RestoreFromClusterSnapshot::set_encrypted): <p>Enables support for restoring an unencrypted snapshot to a cluster encrypted with Key Management Service (KMS) and a CMK.</p>
    /// - On success, responds with [`RestoreFromClusterSnapshotOutput`](crate::output::RestoreFromClusterSnapshotOutput) with field(s):
    ///   - [`cluster(Option<Cluster>)`](crate::output::RestoreFromClusterSnapshotOutput::cluster): <p>Describes a cluster.</p>
    /// - On failure, responds with [`SdkError<RestoreFromClusterSnapshotError>`](crate::error::RestoreFromClusterSnapshotError)
    pub fn restore_from_cluster_snapshot(&self) -> fluent_builders::RestoreFromClusterSnapshot {
        fluent_builders::RestoreFromClusterSnapshot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RestoreTableFromClusterSnapshot`](crate::client::fluent_builders::RestoreTableFromClusterSnapshot) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster_identifier(impl Into<String>)`](crate::client::fluent_builders::RestoreTableFromClusterSnapshot::cluster_identifier) / [`set_cluster_identifier(Option<String>)`](crate::client::fluent_builders::RestoreTableFromClusterSnapshot::set_cluster_identifier): <p>The identifier of the Amazon Redshift cluster to restore the table to.</p>
    ///   - [`snapshot_identifier(impl Into<String>)`](crate::client::fluent_builders::RestoreTableFromClusterSnapshot::snapshot_identifier) / [`set_snapshot_identifier(Option<String>)`](crate::client::fluent_builders::RestoreTableFromClusterSnapshot::set_snapshot_identifier): <p>The identifier of the snapshot to restore the table from. This snapshot must have been created from the Amazon Redshift cluster specified by the <code>ClusterIdentifier</code> parameter.</p>
    ///   - [`source_database_name(impl Into<String>)`](crate::client::fluent_builders::RestoreTableFromClusterSnapshot::source_database_name) / [`set_source_database_name(Option<String>)`](crate::client::fluent_builders::RestoreTableFromClusterSnapshot::set_source_database_name): <p>The name of the source database that contains the table to restore from.</p>
    ///   - [`source_schema_name(impl Into<String>)`](crate::client::fluent_builders::RestoreTableFromClusterSnapshot::source_schema_name) / [`set_source_schema_name(Option<String>)`](crate::client::fluent_builders::RestoreTableFromClusterSnapshot::set_source_schema_name): <p>The name of the source schema that contains the table to restore from. If you do not specify a <code>SourceSchemaName</code> value, the default is <code>public</code>.</p>
    ///   - [`source_table_name(impl Into<String>)`](crate::client::fluent_builders::RestoreTableFromClusterSnapshot::source_table_name) / [`set_source_table_name(Option<String>)`](crate::client::fluent_builders::RestoreTableFromClusterSnapshot::set_source_table_name): <p>The name of the source table to restore from.</p>
    ///   - [`target_database_name(impl Into<String>)`](crate::client::fluent_builders::RestoreTableFromClusterSnapshot::target_database_name) / [`set_target_database_name(Option<String>)`](crate::client::fluent_builders::RestoreTableFromClusterSnapshot::set_target_database_name): <p>The name of the database to restore the table to.</p>
    ///   - [`target_schema_name(impl Into<String>)`](crate::client::fluent_builders::RestoreTableFromClusterSnapshot::target_schema_name) / [`set_target_schema_name(Option<String>)`](crate::client::fluent_builders::RestoreTableFromClusterSnapshot::set_target_schema_name): <p>The name of the schema to restore the table to.</p>
    ///   - [`new_table_name(impl Into<String>)`](crate::client::fluent_builders::RestoreTableFromClusterSnapshot::new_table_name) / [`set_new_table_name(Option<String>)`](crate::client::fluent_builders::RestoreTableFromClusterSnapshot::set_new_table_name): <p>The name of the table to create as a result of the current request.</p>
    ///   - [`enable_case_sensitive_identifier(bool)`](crate::client::fluent_builders::RestoreTableFromClusterSnapshot::enable_case_sensitive_identifier) / [`set_enable_case_sensitive_identifier(Option<bool>)`](crate::client::fluent_builders::RestoreTableFromClusterSnapshot::set_enable_case_sensitive_identifier): <p>Indicates whether name identifiers for database, schema, and table are case sensitive. If <code>true</code>, the names are case sensitive. If <code>false</code> (default), the names are not case sensitive.</p>
    /// - On success, responds with [`RestoreTableFromClusterSnapshotOutput`](crate::output::RestoreTableFromClusterSnapshotOutput) with field(s):
    ///   - [`table_restore_status(Option<TableRestoreStatus>)`](crate::output::RestoreTableFromClusterSnapshotOutput::table_restore_status): <p>Describes the status of a <code>RestoreTableFromClusterSnapshot</code> operation.</p>
    /// - On failure, responds with [`SdkError<RestoreTableFromClusterSnapshotError>`](crate::error::RestoreTableFromClusterSnapshotError)
    pub fn restore_table_from_cluster_snapshot(
        &self,
    ) -> fluent_builders::RestoreTableFromClusterSnapshot {
        fluent_builders::RestoreTableFromClusterSnapshot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ResumeCluster`](crate::client::fluent_builders::ResumeCluster) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster_identifier(impl Into<String>)`](crate::client::fluent_builders::ResumeCluster::cluster_identifier) / [`set_cluster_identifier(Option<String>)`](crate::client::fluent_builders::ResumeCluster::set_cluster_identifier): <p>The identifier of the cluster to be resumed.</p>
    /// - On success, responds with [`ResumeClusterOutput`](crate::output::ResumeClusterOutput) with field(s):
    ///   - [`cluster(Option<Cluster>)`](crate::output::ResumeClusterOutput::cluster): <p>Describes a cluster.</p>
    /// - On failure, responds with [`SdkError<ResumeClusterError>`](crate::error::ResumeClusterError)
    pub fn resume_cluster(&self) -> fluent_builders::ResumeCluster {
        fluent_builders::ResumeCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RevokeClusterSecurityGroupIngress`](crate::client::fluent_builders::RevokeClusterSecurityGroupIngress) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster_security_group_name(impl Into<String>)`](crate::client::fluent_builders::RevokeClusterSecurityGroupIngress::cluster_security_group_name) / [`set_cluster_security_group_name(Option<String>)`](crate::client::fluent_builders::RevokeClusterSecurityGroupIngress::set_cluster_security_group_name): <p>The name of the security Group from which to revoke the ingress rule.</p>
    ///   - [`cidrip(impl Into<String>)`](crate::client::fluent_builders::RevokeClusterSecurityGroupIngress::cidrip) / [`set_cidrip(Option<String>)`](crate::client::fluent_builders::RevokeClusterSecurityGroupIngress::set_cidrip): <p>The IP range for which to revoke access. This range must be a valid Classless Inter-Domain Routing (CIDR) block of IP addresses. If <code>CIDRIP</code> is specified, <code>EC2SecurityGroupName</code> and <code>EC2SecurityGroupOwnerId</code> cannot be provided. </p>
    ///   - [`ec2_security_group_name(impl Into<String>)`](crate::client::fluent_builders::RevokeClusterSecurityGroupIngress::ec2_security_group_name) / [`set_ec2_security_group_name(Option<String>)`](crate::client::fluent_builders::RevokeClusterSecurityGroupIngress::set_ec2_security_group_name): <p>The name of the EC2 Security Group whose access is to be revoked. If <code>EC2SecurityGroupName</code> is specified, <code>EC2SecurityGroupOwnerId</code> must also be provided and <code>CIDRIP</code> cannot be provided. </p>
    ///   - [`ec2_security_group_owner_id(impl Into<String>)`](crate::client::fluent_builders::RevokeClusterSecurityGroupIngress::ec2_security_group_owner_id) / [`set_ec2_security_group_owner_id(Option<String>)`](crate::client::fluent_builders::RevokeClusterSecurityGroupIngress::set_ec2_security_group_owner_id): <p>The Amazon Web Services account number of the owner of the security group specified in the <code>EC2SecurityGroupName</code> parameter. The Amazon Web Services access key ID is not an acceptable value. If <code>EC2SecurityGroupOwnerId</code> is specified, <code>EC2SecurityGroupName</code> must also be provided. and <code>CIDRIP</code> cannot be provided. </p>  <p>Example: <code>111122223333</code> </p>
    /// - On success, responds with [`RevokeClusterSecurityGroupIngressOutput`](crate::output::RevokeClusterSecurityGroupIngressOutput) with field(s):
    ///   - [`cluster_security_group(Option<ClusterSecurityGroup>)`](crate::output::RevokeClusterSecurityGroupIngressOutput::cluster_security_group): <p>Describes a security group.</p>
    /// - On failure, responds with [`SdkError<RevokeClusterSecurityGroupIngressError>`](crate::error::RevokeClusterSecurityGroupIngressError)
    pub fn revoke_cluster_security_group_ingress(
        &self,
    ) -> fluent_builders::RevokeClusterSecurityGroupIngress {
        fluent_builders::RevokeClusterSecurityGroupIngress::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RevokeEndpointAccess`](crate::client::fluent_builders::RevokeEndpointAccess) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster_identifier(impl Into<String>)`](crate::client::fluent_builders::RevokeEndpointAccess::cluster_identifier) / [`set_cluster_identifier(Option<String>)`](crate::client::fluent_builders::RevokeEndpointAccess::set_cluster_identifier): <p>The cluster to revoke access from.</p>
    ///   - [`account(impl Into<String>)`](crate::client::fluent_builders::RevokeEndpointAccess::account) / [`set_account(Option<String>)`](crate::client::fluent_builders::RevokeEndpointAccess::set_account): <p>The Amazon Web Services account ID whose access is to be revoked.</p>
    ///   - [`vpc_ids(Vec<String>)`](crate::client::fluent_builders::RevokeEndpointAccess::vpc_ids) / [`set_vpc_ids(Option<Vec<String>>)`](crate::client::fluent_builders::RevokeEndpointAccess::set_vpc_ids): <p>The virtual private cloud (VPC) identifiers for which access is to be revoked.</p>
    ///   - [`force(bool)`](crate::client::fluent_builders::RevokeEndpointAccess::force) / [`set_force(bool)`](crate::client::fluent_builders::RevokeEndpointAccess::set_force): <p>Indicates whether to force the revoke action. If true, the Redshift-managed VPC endpoints associated with the endpoint authorization are also deleted.</p>
    /// - On success, responds with [`RevokeEndpointAccessOutput`](crate::output::RevokeEndpointAccessOutput) with field(s):
    ///   - [`grantor(Option<String>)`](crate::output::RevokeEndpointAccessOutput::grantor): <p>The Amazon Web Services account ID of the cluster owner.</p>
    ///   - [`grantee(Option<String>)`](crate::output::RevokeEndpointAccessOutput::grantee): <p>The Amazon Web Services account ID of the grantee of the cluster.</p>
    ///   - [`cluster_identifier(Option<String>)`](crate::output::RevokeEndpointAccessOutput::cluster_identifier): <p>The cluster identifier.</p>
    ///   - [`authorize_time(Option<DateTime>)`](crate::output::RevokeEndpointAccessOutput::authorize_time): <p>The time (UTC) when the authorization was created.</p>
    ///   - [`cluster_status(Option<String>)`](crate::output::RevokeEndpointAccessOutput::cluster_status): <p>The status of the cluster.</p>
    ///   - [`status(Option<AuthorizationStatus>)`](crate::output::RevokeEndpointAccessOutput::status): <p>The status of the authorization action.</p>
    ///   - [`allowed_all_vp_cs(bool)`](crate::output::RevokeEndpointAccessOutput::allowed_all_vp_cs): <p>Indicates whether all VPCs in the grantee account are allowed access to the cluster.</p>
    ///   - [`allowed_vp_cs(Option<Vec<String>>)`](crate::output::RevokeEndpointAccessOutput::allowed_vp_cs): <p>The VPCs allowed access to the cluster.</p>
    ///   - [`endpoint_count(i32)`](crate::output::RevokeEndpointAccessOutput::endpoint_count): <p>The number of Redshift-managed VPC endpoints created for the authorization.</p>
    /// - On failure, responds with [`SdkError<RevokeEndpointAccessError>`](crate::error::RevokeEndpointAccessError)
    pub fn revoke_endpoint_access(&self) -> fluent_builders::RevokeEndpointAccess {
        fluent_builders::RevokeEndpointAccess::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RevokeSnapshotAccess`](crate::client::fluent_builders::RevokeSnapshotAccess) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`snapshot_identifier(impl Into<String>)`](crate::client::fluent_builders::RevokeSnapshotAccess::snapshot_identifier) / [`set_snapshot_identifier(Option<String>)`](crate::client::fluent_builders::RevokeSnapshotAccess::set_snapshot_identifier): <p>The identifier of the snapshot that the account can no longer access.</p>
    ///   - [`snapshot_cluster_identifier(impl Into<String>)`](crate::client::fluent_builders::RevokeSnapshotAccess::snapshot_cluster_identifier) / [`set_snapshot_cluster_identifier(Option<String>)`](crate::client::fluent_builders::RevokeSnapshotAccess::set_snapshot_cluster_identifier): <p>The identifier of the cluster the snapshot was created from. This parameter is required if your IAM user has a policy containing a snapshot resource element that specifies anything other than * for the cluster name.</p>
    ///   - [`account_with_restore_access(impl Into<String>)`](crate::client::fluent_builders::RevokeSnapshotAccess::account_with_restore_access) / [`set_account_with_restore_access(Option<String>)`](crate::client::fluent_builders::RevokeSnapshotAccess::set_account_with_restore_access): <p>The identifier of the Amazon Web Services account that can no longer restore the specified snapshot.</p>
    /// - On success, responds with [`RevokeSnapshotAccessOutput`](crate::output::RevokeSnapshotAccessOutput) with field(s):
    ///   - [`snapshot(Option<Snapshot>)`](crate::output::RevokeSnapshotAccessOutput::snapshot): <p>Describes a snapshot.</p>
    /// - On failure, responds with [`SdkError<RevokeSnapshotAccessError>`](crate::error::RevokeSnapshotAccessError)
    pub fn revoke_snapshot_access(&self) -> fluent_builders::RevokeSnapshotAccess {
        fluent_builders::RevokeSnapshotAccess::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RotateEncryptionKey`](crate::client::fluent_builders::RotateEncryptionKey) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cluster_identifier(impl Into<String>)`](crate::client::fluent_builders::RotateEncryptionKey::cluster_identifier) / [`set_cluster_identifier(Option<String>)`](crate::client::fluent_builders::RotateEncryptionKey::set_cluster_identifier): <p>The unique identifier of the cluster that you want to rotate the encryption keys for.</p>  <p>Constraints: Must be the name of valid cluster that has encryption enabled.</p>
    /// - On success, responds with [`RotateEncryptionKeyOutput`](crate::output::RotateEncryptionKeyOutput) with field(s):
    ///   - [`cluster(Option<Cluster>)`](crate::output::RotateEncryptionKeyOutput::cluster): <p>Describes a cluster.</p>
    /// - On failure, responds with [`SdkError<RotateEncryptionKeyError>`](crate::error::RotateEncryptionKeyError)
    pub fn rotate_encryption_key(&self) -> fluent_builders::RotateEncryptionKey {
        fluent_builders::RotateEncryptionKey::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdatePartnerStatus`](crate::client::fluent_builders::UpdatePartnerStatus) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::UpdatePartnerStatus::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::UpdatePartnerStatus::set_account_id): <p>The Amazon Web Services account ID that owns the cluster.</p>
    ///   - [`cluster_identifier(impl Into<String>)`](crate::client::fluent_builders::UpdatePartnerStatus::cluster_identifier) / [`set_cluster_identifier(Option<String>)`](crate::client::fluent_builders::UpdatePartnerStatus::set_cluster_identifier): <p>The cluster identifier of the cluster whose partner integration status is being updated.</p>
    ///   - [`database_name(impl Into<String>)`](crate::client::fluent_builders::UpdatePartnerStatus::database_name) / [`set_database_name(Option<String>)`](crate::client::fluent_builders::UpdatePartnerStatus::set_database_name): <p>The name of the database whose partner integration status is being updated.</p>
    ///   - [`partner_name(impl Into<String>)`](crate::client::fluent_builders::UpdatePartnerStatus::partner_name) / [`set_partner_name(Option<String>)`](crate::client::fluent_builders::UpdatePartnerStatus::set_partner_name): <p>The name of the partner whose integration status is being updated.</p>
    ///   - [`status(PartnerIntegrationStatus)`](crate::client::fluent_builders::UpdatePartnerStatus::status) / [`set_status(Option<PartnerIntegrationStatus>)`](crate::client::fluent_builders::UpdatePartnerStatus::set_status): <p>The value of the updated status.</p>
    ///   - [`status_message(impl Into<String>)`](crate::client::fluent_builders::UpdatePartnerStatus::status_message) / [`set_status_message(Option<String>)`](crate::client::fluent_builders::UpdatePartnerStatus::set_status_message): <p>The status message provided by the partner.</p>
    /// - On success, responds with [`UpdatePartnerStatusOutput`](crate::output::UpdatePartnerStatusOutput) with field(s):
    ///   - [`database_name(Option<String>)`](crate::output::UpdatePartnerStatusOutput::database_name): <p>The name of the database that receives data from the partner.</p>
    ///   - [`partner_name(Option<String>)`](crate::output::UpdatePartnerStatusOutput::partner_name): <p>The name of the partner that is authorized to send data.</p>
    /// - On failure, responds with [`SdkError<UpdatePartnerStatusError>`](crate::error::UpdatePartnerStatusError)
    pub fn update_partner_status(&self) -> fluent_builders::UpdatePartnerStatus {
        fluent_builders::UpdatePartnerStatus::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AcceptReservedNodeExchange`.
    ///
    /// <p>Exchanges a DC1 Reserved Node for a DC2 Reserved Node with no changes to the configuration (term, payment type, or number of nodes) and no additional costs. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AcceptReservedNodeExchange {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::accept_reserved_node_exchange_input::Builder,
    }
    impl AcceptReservedNodeExchange {
        /// Creates a new `AcceptReservedNodeExchange`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AcceptReservedNodeExchangeOutput,
            aws_smithy_http::result::SdkError<crate::error::AcceptReservedNodeExchangeError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A string representing the node identifier of the DC1 Reserved Node to be exchanged.</p>
        pub fn reserved_node_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.reserved_node_id(input.into());
            self
        }
        /// <p>A string representing the node identifier of the DC1 Reserved Node to be exchanged.</p>
        pub fn set_reserved_node_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_reserved_node_id(input);
            self
        }
        /// <p>The unique identifier of the DC2 Reserved Node offering to be used for the exchange. You can obtain the value for the parameter by calling <code>GetReservedNodeExchangeOfferings</code> </p>
        pub fn target_reserved_node_offering_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.target_reserved_node_offering_id(input.into());
            self
        }
        /// <p>The unique identifier of the DC2 Reserved Node offering to be used for the exchange. You can obtain the value for the parameter by calling <code>GetReservedNodeExchangeOfferings</code> </p>
        pub fn set_target_reserved_node_offering_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_target_reserved_node_offering_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AddPartner`.
    ///
    /// <p>Adds a partner integration to a cluster. This operation authorizes a partner to push status updates for the specified database. To complete the integration, you also set up the integration on the partner website.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AddPartner {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::add_partner_input::Builder,
    }
    impl AddPartner {
        /// Creates a new `AddPartner`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AddPartnerOutput,
            aws_smithy_http::result::SdkError<crate::error::AddPartnerError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID that owns the cluster.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID that owns the cluster.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The cluster identifier of the cluster that receives data from the partner.</p>
        pub fn cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_identifier(input.into());
            self
        }
        /// <p>The cluster identifier of the cluster that receives data from the partner.</p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_identifier(input);
            self
        }
        /// <p>The name of the database that receives data from the partner.</p>
        pub fn database_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.database_name(input.into());
            self
        }
        /// <p>The name of the database that receives data from the partner.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_database_name(input);
            self
        }
        /// <p>The name of the partner that is authorized to send data.</p>
        pub fn partner_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.partner_name(input.into());
            self
        }
        /// <p>The name of the partner that is authorized to send data.</p>
        pub fn set_partner_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_partner_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateDataShareConsumer`.
    ///
    /// <p>From a datashare consumer account, associates a datashare with the account (AssociateEntireAccount) or the specified namespace (ConsumerArn). If you make this association, the consumer can consume the datashare.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateDataShareConsumer {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::associate_data_share_consumer_input::Builder,
    }
    impl AssociateDataShareConsumer {
        /// Creates a new `AssociateDataShareConsumer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateDataShareConsumerOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateDataShareConsumerError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the datashare that the consumer is to use with the account or the namespace.</p>
        pub fn data_share_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_share_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the datashare that the consumer is to use with the account or the namespace.</p>
        pub fn set_data_share_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_data_share_arn(input);
            self
        }
        /// <p>A value that specifies whether the datashare is associated with the entire account.</p>
        pub fn associate_entire_account(mut self, input: bool) -> Self {
            self.inner = self.inner.associate_entire_account(input);
            self
        }
        /// <p>A value that specifies whether the datashare is associated with the entire account.</p>
        pub fn set_associate_entire_account(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_associate_entire_account(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the consumer that is associated with the datashare.</p>
        pub fn consumer_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.consumer_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the consumer that is associated with the datashare.</p>
        pub fn set_consumer_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_consumer_arn(input);
            self
        }
        /// <p>From a datashare consumer account, associates a datashare with all existing and future namespaces in the specified Amazon Web Services Region.</p>
        pub fn consumer_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.consumer_region(input.into());
            self
        }
        /// <p>From a datashare consumer account, associates a datashare with all existing and future namespaces in the specified Amazon Web Services Region.</p>
        pub fn set_consumer_region(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_consumer_region(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AuthorizeClusterSecurityGroupIngress`.
    ///
    /// <p>Adds an inbound (ingress) rule to an Amazon Redshift security group. Depending on whether the application accessing your cluster is running on the Internet or an Amazon EC2 instance, you can authorize inbound access to either a Classless Interdomain Routing (CIDR)/Internet Protocol (IP) range or to an Amazon EC2 security group. You can add as many as 20 ingress rules to an Amazon Redshift security group.</p>
    /// <p>If you authorize access to an Amazon EC2 security group, specify <i>EC2SecurityGroupName</i> and <i>EC2SecurityGroupOwnerId</i>. The Amazon EC2 security group and Amazon Redshift cluster must be in the same Amazon Web Services Region. </p>
    /// <p>If you authorize access to a CIDR/IP address range, specify <i>CIDRIP</i>. For an overview of CIDR blocks, see the Wikipedia article on <a href="http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Classless Inter-Domain Routing</a>. </p>
    /// <p>You must also associate the security group with a cluster so that clients running on these IP addresses or the EC2 instance are authorized to connect to the cluster. For information about managing security groups, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-security-groups.html">Working with Security Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AuthorizeClusterSecurityGroupIngress {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::authorize_cluster_security_group_ingress_input::Builder,
    }
    impl AuthorizeClusterSecurityGroupIngress {
        /// Creates a new `AuthorizeClusterSecurityGroupIngress`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AuthorizeClusterSecurityGroupIngressOutput,
            aws_smithy_http::result::SdkError<
                crate::error::AuthorizeClusterSecurityGroupIngressError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the security group to which the ingress rule is added.</p>
        pub fn cluster_security_group_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.cluster_security_group_name(input.into());
            self
        }
        /// <p>The name of the security group to which the ingress rule is added.</p>
        pub fn set_cluster_security_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_security_group_name(input);
            self
        }
        /// <p>The IP range to be added the Amazon Redshift security group.</p>
        pub fn cidrip(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cidrip(input.into());
            self
        }
        /// <p>The IP range to be added the Amazon Redshift security group.</p>
        pub fn set_cidrip(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cidrip(input);
            self
        }
        /// <p>The EC2 security group to be added the Amazon Redshift security group.</p>
        pub fn ec2_security_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ec2_security_group_name(input.into());
            self
        }
        /// <p>The EC2 security group to be added the Amazon Redshift security group.</p>
        pub fn set_ec2_security_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_ec2_security_group_name(input);
            self
        }
        /// <p>The Amazon Web Services account number of the owner of the security group specified by the <i>EC2SecurityGroupName</i> parameter. The Amazon Web Services Access Key ID is not an acceptable value. </p>
        /// <p>Example: <code>111122223333</code> </p>
        pub fn ec2_security_group_owner_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.ec2_security_group_owner_id(input.into());
            self
        }
        /// <p>The Amazon Web Services account number of the owner of the security group specified by the <i>EC2SecurityGroupName</i> parameter. The Amazon Web Services Access Key ID is not an acceptable value. </p>
        /// <p>Example: <code>111122223333</code> </p>
        pub fn set_ec2_security_group_owner_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_ec2_security_group_owner_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AuthorizeDataShare`.
    ///
    /// <p>From a data producer account, authorizes the sharing of a datashare with one or more consumer accounts or managing entities. To authorize a datashare for a data consumer, the producer account must have the correct access privileges.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AuthorizeDataShare {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::authorize_data_share_input::Builder,
    }
    impl AuthorizeDataShare {
        /// Creates a new `AuthorizeDataShare`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AuthorizeDataShareOutput,
            aws_smithy_http::result::SdkError<crate::error::AuthorizeDataShareError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the datashare that producers are to authorize sharing for.</p>
        pub fn data_share_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_share_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the datashare that producers are to authorize sharing for.</p>
        pub fn set_data_share_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_data_share_arn(input);
            self
        }
        /// <p>The identifier of the data consumer that is authorized to access the datashare. This identifier is an Amazon Web Services account ID or a keyword, such as ADX.</p>
        pub fn consumer_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.consumer_identifier(input.into());
            self
        }
        /// <p>The identifier of the data consumer that is authorized to access the datashare. This identifier is an Amazon Web Services account ID or a keyword, such as ADX.</p>
        pub fn set_consumer_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_consumer_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AuthorizeEndpointAccess`.
    ///
    /// <p>Grants access to a cluster.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AuthorizeEndpointAccess {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::authorize_endpoint_access_input::Builder,
    }
    impl AuthorizeEndpointAccess {
        /// Creates a new `AuthorizeEndpointAccess`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AuthorizeEndpointAccessOutput,
            aws_smithy_http::result::SdkError<crate::error::AuthorizeEndpointAccessError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The cluster identifier of the cluster to grant access to.</p>
        pub fn cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_identifier(input.into());
            self
        }
        /// <p>The cluster identifier of the cluster to grant access to.</p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_identifier(input);
            self
        }
        /// <p>The Amazon Web Services account ID to grant access to.</p>
        pub fn account(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID to grant access to.</p>
        pub fn set_account(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account(input);
            self
        }
        /// Appends an item to `VpcIds`.
        ///
        /// To override the contents of this collection use [`set_vpc_ids`](Self::set_vpc_ids).
        ///
        /// <p>The virtual private cloud (VPC) identifiers to grant access to.</p>
        pub fn vpc_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc_ids(input.into());
            self
        }
        /// <p>The virtual private cloud (VPC) identifiers to grant access to.</p>
        pub fn set_vpc_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_vpc_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AuthorizeSnapshotAccess`.
    ///
    /// <p>Authorizes the specified Amazon Web Services account to restore the specified snapshot.</p>
    /// <p> For more information about working with snapshots, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-snapshots.html">Amazon Redshift Snapshots</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AuthorizeSnapshotAccess {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::authorize_snapshot_access_input::Builder,
    }
    impl AuthorizeSnapshotAccess {
        /// Creates a new `AuthorizeSnapshotAccess`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AuthorizeSnapshotAccessOutput,
            aws_smithy_http::result::SdkError<crate::error::AuthorizeSnapshotAccessError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the snapshot the account is authorized to restore.</p>
        pub fn snapshot_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.snapshot_identifier(input.into());
            self
        }
        /// <p>The identifier of the snapshot the account is authorized to restore.</p>
        pub fn set_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_snapshot_identifier(input);
            self
        }
        /// <p>The identifier of the cluster the snapshot was created from. This parameter is required if your IAM user has a policy containing a snapshot resource element that specifies anything other than * for the cluster name.</p>
        pub fn snapshot_cluster_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.snapshot_cluster_identifier(input.into());
            self
        }
        /// <p>The identifier of the cluster the snapshot was created from. This parameter is required if your IAM user has a policy containing a snapshot resource element that specifies anything other than * for the cluster name.</p>
        pub fn set_snapshot_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_snapshot_cluster_identifier(input);
            self
        }
        /// <p>The identifier of the Amazon Web Services account authorized to restore the specified snapshot.</p>
        /// <p>To share a snapshot with Amazon Web Services Support, specify amazon-redshift-support.</p>
        pub fn account_with_restore_access(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.account_with_restore_access(input.into());
            self
        }
        /// <p>The identifier of the Amazon Web Services account authorized to restore the specified snapshot.</p>
        /// <p>To share a snapshot with Amazon Web Services Support, specify amazon-redshift-support.</p>
        pub fn set_account_with_restore_access(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_account_with_restore_access(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchDeleteClusterSnapshots`.
    ///
    /// <p>Deletes a set of cluster snapshots.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct BatchDeleteClusterSnapshots {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::batch_delete_cluster_snapshots_input::Builder,
    }
    impl BatchDeleteClusterSnapshots {
        /// Creates a new `BatchDeleteClusterSnapshots`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchDeleteClusterSnapshotsOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchDeleteClusterSnapshotsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `Identifiers`.
        ///
        /// To override the contents of this collection use [`set_identifiers`](Self::set_identifiers).
        ///
        /// <p>A list of identifiers for the snapshots that you want to delete.</p>
        pub fn identifiers(mut self, input: crate::model::DeleteClusterSnapshotMessage) -> Self {
            self.inner = self.inner.identifiers(input);
            self
        }
        /// <p>A list of identifiers for the snapshots that you want to delete.</p>
        pub fn set_identifiers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DeleteClusterSnapshotMessage>>,
        ) -> Self {
            self.inner = self.inner.set_identifiers(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchModifyClusterSnapshots`.
    ///
    /// <p>Modifies the settings for a set of cluster snapshots.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct BatchModifyClusterSnapshots {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::batch_modify_cluster_snapshots_input::Builder,
    }
    impl BatchModifyClusterSnapshots {
        /// Creates a new `BatchModifyClusterSnapshots`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchModifyClusterSnapshotsOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchModifyClusterSnapshotsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `SnapshotIdentifierList`.
        ///
        /// To override the contents of this collection use [`set_snapshot_identifier_list`](Self::set_snapshot_identifier_list).
        ///
        /// <p>A list of snapshot identifiers you want to modify.</p>
        pub fn snapshot_identifier_list(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.snapshot_identifier_list(input.into());
            self
        }
        /// <p>A list of snapshot identifiers you want to modify.</p>
        pub fn set_snapshot_identifier_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_snapshot_identifier_list(input);
            self
        }
        /// <p>The number of days that a manual snapshot is retained. If you specify the value -1, the manual snapshot is retained indefinitely.</p>
        /// <p>The number must be either -1 or an integer between 1 and 3,653.</p>
        /// <p>If you decrease the manual snapshot retention period from its current value, existing manual snapshots that fall outside of the new retention period will return an error. If you want to suppress the errors and delete the snapshots, use the force option. </p>
        pub fn manual_snapshot_retention_period(mut self, input: i32) -> Self {
            self.inner = self.inner.manual_snapshot_retention_period(input);
            self
        }
        /// <p>The number of days that a manual snapshot is retained. If you specify the value -1, the manual snapshot is retained indefinitely.</p>
        /// <p>The number must be either -1 or an integer between 1 and 3,653.</p>
        /// <p>If you decrease the manual snapshot retention period from its current value, existing manual snapshots that fall outside of the new retention period will return an error. If you want to suppress the errors and delete the snapshots, use the force option. </p>
        pub fn set_manual_snapshot_retention_period(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.inner = self.inner.set_manual_snapshot_retention_period(input);
            self
        }
        /// <p>A boolean value indicating whether to override an exception if the retention period has passed. </p>
        pub fn force(mut self, input: bool) -> Self {
            self.inner = self.inner.force(input);
            self
        }
        /// <p>A boolean value indicating whether to override an exception if the retention period has passed. </p>
        pub fn set_force(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_force(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CancelResize`.
    ///
    /// <p>Cancels a resize operation for a cluster.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CancelResize {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::cancel_resize_input::Builder,
    }
    impl CancelResize {
        /// Creates a new `CancelResize`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CancelResizeOutput,
            aws_smithy_http::result::SdkError<crate::error::CancelResizeError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the cluster that you want to cancel a resize operation for.</p>
        pub fn cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_identifier(input.into());
            self
        }
        /// <p>The unique identifier for the cluster that you want to cancel a resize operation for.</p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CopyClusterSnapshot`.
    ///
    /// <p>Copies the specified automated cluster snapshot to a new manual cluster snapshot. The source must be an automated snapshot and it must be in the available state.</p>
    /// <p>When you delete a cluster, Amazon Redshift deletes any automated snapshots of the cluster. Also, when the retention period of the snapshot expires, Amazon Redshift automatically deletes it. If you want to keep an automated snapshot for a longer period, you can make a manual copy of the snapshot. Manual snapshots are retained until you delete them.</p>
    /// <p> For more information about working with snapshots, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-snapshots.html">Amazon Redshift Snapshots</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CopyClusterSnapshot {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::copy_cluster_snapshot_input::Builder,
    }
    impl CopyClusterSnapshot {
        /// Creates a new `CopyClusterSnapshot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CopyClusterSnapshotOutput,
            aws_smithy_http::result::SdkError<crate::error::CopyClusterSnapshotError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier for the source snapshot.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be the identifier for a valid automated snapshot whose state is <code>available</code>.</p> </li>
        /// </ul>
        pub fn source_snapshot_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_snapshot_identifier(input.into());
            self
        }
        /// <p>The identifier for the source snapshot.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be the identifier for a valid automated snapshot whose state is <code>available</code>.</p> </li>
        /// </ul>
        pub fn set_source_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_snapshot_identifier(input);
            self
        }
        /// <p>The identifier of the cluster the source snapshot was created from. This parameter is required if your IAM user has a policy containing a snapshot resource element that specifies anything other than * for the cluster name.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be the identifier for a valid cluster.</p> </li>
        /// </ul>
        pub fn source_snapshot_cluster_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.source_snapshot_cluster_identifier(input.into());
            self
        }
        /// <p>The identifier of the cluster the source snapshot was created from. This parameter is required if your IAM user has a policy containing a snapshot resource element that specifies anything other than * for the cluster name.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be the identifier for a valid cluster.</p> </li>
        /// </ul>
        pub fn set_source_snapshot_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_snapshot_cluster_identifier(input);
            self
        }
        /// <p>The identifier given to the new manual snapshot.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Cannot be null, empty, or blank.</p> </li>
        /// <li> <p>Must contain from 1 to 255 alphanumeric characters or hyphens.</p> </li>
        /// <li> <p>First character must be a letter.</p> </li>
        /// <li> <p>Cannot end with a hyphen or contain two consecutive hyphens.</p> </li>
        /// <li> <p>Must be unique for the Amazon Web Services account that is making the request.</p> </li>
        /// </ul>
        pub fn target_snapshot_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.target_snapshot_identifier(input.into());
            self
        }
        /// <p>The identifier given to the new manual snapshot.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Cannot be null, empty, or blank.</p> </li>
        /// <li> <p>Must contain from 1 to 255 alphanumeric characters or hyphens.</p> </li>
        /// <li> <p>First character must be a letter.</p> </li>
        /// <li> <p>Cannot end with a hyphen or contain two consecutive hyphens.</p> </li>
        /// <li> <p>Must be unique for the Amazon Web Services account that is making the request.</p> </li>
        /// </ul>
        pub fn set_target_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_target_snapshot_identifier(input);
            self
        }
        /// <p>The number of days that a manual snapshot is retained. If the value is -1, the manual snapshot is retained indefinitely. </p>
        /// <p>The value must be either -1 or an integer between 1 and 3,653.</p>
        /// <p>The default value is -1.</p>
        pub fn manual_snapshot_retention_period(mut self, input: i32) -> Self {
            self.inner = self.inner.manual_snapshot_retention_period(input);
            self
        }
        /// <p>The number of days that a manual snapshot is retained. If the value is -1, the manual snapshot is retained indefinitely. </p>
        /// <p>The value must be either -1 or an integer between 1 and 3,653.</p>
        /// <p>The default value is -1.</p>
        pub fn set_manual_snapshot_retention_period(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.inner = self.inner.set_manual_snapshot_retention_period(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateAuthenticationProfile`.
    ///
    /// <p>Creates an authentication profile with the specified parameters.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateAuthenticationProfile {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_authentication_profile_input::Builder,
    }
    impl CreateAuthenticationProfile {
        /// Creates a new `CreateAuthenticationProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateAuthenticationProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateAuthenticationProfileError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the authentication profile to be created.</p>
        pub fn authentication_profile_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.authentication_profile_name(input.into());
            self
        }
        /// <p>The name of the authentication profile to be created.</p>
        pub fn set_authentication_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_authentication_profile_name(input);
            self
        }
        /// <p>The content of the authentication profile in JSON format. The maximum length of the JSON string is determined by a quota for your account.</p>
        pub fn authentication_profile_content(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.authentication_profile_content(input.into());
            self
        }
        /// <p>The content of the authentication profile in JSON format. The maximum length of the JSON string is determined by a quota for your account.</p>
        pub fn set_authentication_profile_content(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_authentication_profile_content(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateCluster`.
    ///
    /// <p>Creates a new cluster with the specified parameters.</p>
    /// <p>To create a cluster in Virtual Private Cloud (VPC), you must provide a cluster subnet group name. The cluster subnet group identifies the subnets of your VPC that Amazon Redshift uses when creating the cluster. For more information about managing clusters, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html">Amazon Redshift Clusters</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateCluster {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_cluster_input::Builder,
    }
    impl CreateCluster {
        /// Creates a new `CreateCluster`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateClusterOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateClusterError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the first database to be created when the cluster is created.</p>
        /// <p>To create additional databases after the cluster is created, connect to the cluster with a SQL client and use SQL commands to create a database. For more information, go to <a href="https://docs.aws.amazon.com/redshift/latest/dg/t_creating_database.html">Create a Database</a> in the Amazon Redshift Database Developer Guide. </p>
        /// <p>Default: <code>dev</code> </p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must contain 1 to 64 alphanumeric characters.</p> </li>
        /// <li> <p>Must contain only lowercase letters.</p> </li>
        /// <li> <p>Cannot be a word that is reserved by the service. A list of reserved words can be found in <a href="https://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html">Reserved Words</a> in the Amazon Redshift Database Developer Guide. </p> </li>
        /// </ul>
        pub fn db_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_name(input.into());
            self
        }
        /// <p>The name of the first database to be created when the cluster is created.</p>
        /// <p>To create additional databases after the cluster is created, connect to the cluster with a SQL client and use SQL commands to create a database. For more information, go to <a href="https://docs.aws.amazon.com/redshift/latest/dg/t_creating_database.html">Create a Database</a> in the Amazon Redshift Database Developer Guide. </p>
        /// <p>Default: <code>dev</code> </p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must contain 1 to 64 alphanumeric characters.</p> </li>
        /// <li> <p>Must contain only lowercase letters.</p> </li>
        /// <li> <p>Cannot be a word that is reserved by the service. A list of reserved words can be found in <a href="https://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html">Reserved Words</a> in the Amazon Redshift Database Developer Guide. </p> </li>
        /// </ul>
        pub fn set_db_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_db_name(input);
            self
        }
        /// <p>A unique identifier for the cluster. You use this identifier to refer to the cluster for any subsequent cluster operations such as deleting or modifying. The identifier also appears in the Amazon Redshift console.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must contain from 1 to 63 alphanumeric characters or hyphens.</p> </li>
        /// <li> <p>Alphabetic characters must be lowercase.</p> </li>
        /// <li> <p>First character must be a letter.</p> </li>
        /// <li> <p>Cannot end with a hyphen or contain two consecutive hyphens.</p> </li>
        /// <li> <p>Must be unique for all clusters within an Amazon Web Services account.</p> </li>
        /// </ul>
        /// <p>Example: <code>myexamplecluster</code> </p>
        pub fn cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_identifier(input.into());
            self
        }
        /// <p>A unique identifier for the cluster. You use this identifier to refer to the cluster for any subsequent cluster operations such as deleting or modifying. The identifier also appears in the Amazon Redshift console.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must contain from 1 to 63 alphanumeric characters or hyphens.</p> </li>
        /// <li> <p>Alphabetic characters must be lowercase.</p> </li>
        /// <li> <p>First character must be a letter.</p> </li>
        /// <li> <p>Cannot end with a hyphen or contain two consecutive hyphens.</p> </li>
        /// <li> <p>Must be unique for all clusters within an Amazon Web Services account.</p> </li>
        /// </ul>
        /// <p>Example: <code>myexamplecluster</code> </p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_identifier(input);
            self
        }
        /// <p>The type of the cluster. When cluster type is specified as</p>
        /// <ul>
        /// <li> <p> <code>single-node</code>, the <b>NumberOfNodes</b> parameter is not required.</p> </li>
        /// <li> <p> <code>multi-node</code>, the <b>NumberOfNodes</b> parameter is required.</p> </li>
        /// </ul>
        /// <p>Valid Values: <code>multi-node</code> | <code>single-node</code> </p>
        /// <p>Default: <code>multi-node</code> </p>
        pub fn cluster_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_type(input.into());
            self
        }
        /// <p>The type of the cluster. When cluster type is specified as</p>
        /// <ul>
        /// <li> <p> <code>single-node</code>, the <b>NumberOfNodes</b> parameter is not required.</p> </li>
        /// <li> <p> <code>multi-node</code>, the <b>NumberOfNodes</b> parameter is required.</p> </li>
        /// </ul>
        /// <p>Valid Values: <code>multi-node</code> | <code>single-node</code> </p>
        /// <p>Default: <code>multi-node</code> </p>
        pub fn set_cluster_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster_type(input);
            self
        }
        /// <p>The node type to be provisioned for the cluster. For information about node types, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#how-many-nodes"> Working with Clusters</a> in the <i>Amazon Redshift Cluster Management Guide</i>. </p>
        /// <p>Valid Values: <code>ds2.xlarge</code> | <code>ds2.8xlarge</code> | <code>dc1.large</code> | <code>dc1.8xlarge</code> | <code>dc2.large</code> | <code>dc2.8xlarge</code> | <code>ra3.xlplus</code> | <code>ra3.4xlarge</code> | <code>ra3.16xlarge</code> </p>
        pub fn node_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.node_type(input.into());
            self
        }
        /// <p>The node type to be provisioned for the cluster. For information about node types, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#how-many-nodes"> Working with Clusters</a> in the <i>Amazon Redshift Cluster Management Guide</i>. </p>
        /// <p>Valid Values: <code>ds2.xlarge</code> | <code>ds2.8xlarge</code> | <code>dc1.large</code> | <code>dc1.8xlarge</code> | <code>dc2.large</code> | <code>dc2.8xlarge</code> | <code>ra3.xlplus</code> | <code>ra3.4xlarge</code> | <code>ra3.16xlarge</code> </p>
        pub fn set_node_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_node_type(input);
            self
        }
        /// <p>The user name associated with the admin user account for the cluster that is being created.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be 1 - 128 alphanumeric characters. The user name can't be <code>PUBLIC</code>.</p> </li>
        /// <li> <p>First character must be a letter.</p> </li>
        /// <li> <p>Cannot be a reserved word. A list of reserved words can be found in <a href="https://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html">Reserved Words</a> in the Amazon Redshift Database Developer Guide. </p> </li>
        /// </ul>
        pub fn master_username(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.master_username(input.into());
            self
        }
        /// <p>The user name associated with the admin user account for the cluster that is being created.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be 1 - 128 alphanumeric characters. The user name can't be <code>PUBLIC</code>.</p> </li>
        /// <li> <p>First character must be a letter.</p> </li>
        /// <li> <p>Cannot be a reserved word. A list of reserved words can be found in <a href="https://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html">Reserved Words</a> in the Amazon Redshift Database Developer Guide. </p> </li>
        /// </ul>
        pub fn set_master_username(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_master_username(input);
            self
        }
        /// <p>The password associated with the admin user account for the cluster that is being created.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be between 8 and 64 characters in length.</p> </li>
        /// <li> <p>Must contain at least one uppercase letter.</p> </li>
        /// <li> <p>Must contain at least one lowercase letter.</p> </li>
        /// <li> <p>Must contain one number.</p> </li>
        /// <li> <p>Can be any printable ASCII character (ASCII code 33-126) except ' (single quote), " (double quote), \, /, or @.</p> </li>
        /// </ul>
        pub fn master_user_password(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.master_user_password(input.into());
            self
        }
        /// <p>The password associated with the admin user account for the cluster that is being created.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be between 8 and 64 characters in length.</p> </li>
        /// <li> <p>Must contain at least one uppercase letter.</p> </li>
        /// <li> <p>Must contain at least one lowercase letter.</p> </li>
        /// <li> <p>Must contain one number.</p> </li>
        /// <li> <p>Can be any printable ASCII character (ASCII code 33-126) except ' (single quote), " (double quote), \, /, or @.</p> </li>
        /// </ul>
        pub fn set_master_user_password(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_master_user_password(input);
            self
        }
        /// Appends an item to `ClusterSecurityGroups`.
        ///
        /// To override the contents of this collection use [`set_cluster_security_groups`](Self::set_cluster_security_groups).
        ///
        /// <p>A list of security groups to be associated with this cluster.</p>
        /// <p>Default: The default cluster security group for Amazon Redshift.</p>
        pub fn cluster_security_groups(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_security_groups(input.into());
            self
        }
        /// <p>A list of security groups to be associated with this cluster.</p>
        /// <p>Default: The default cluster security group for Amazon Redshift.</p>
        pub fn set_cluster_security_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_cluster_security_groups(input);
            self
        }
        /// Appends an item to `VpcSecurityGroupIds`.
        ///
        /// To override the contents of this collection use [`set_vpc_security_group_ids`](Self::set_vpc_security_group_ids).
        ///
        /// <p>A list of Virtual Private Cloud (VPC) security groups to be associated with the cluster.</p>
        /// <p>Default: The default VPC security group is associated with the cluster.</p>
        pub fn vpc_security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc_security_group_ids(input.into());
            self
        }
        /// <p>A list of Virtual Private Cloud (VPC) security groups to be associated with the cluster.</p>
        /// <p>Default: The default VPC security group is associated with the cluster.</p>
        pub fn set_vpc_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_vpc_security_group_ids(input);
            self
        }
        /// <p>The name of a cluster subnet group to be associated with this cluster.</p>
        /// <p>If this parameter is not provided the resulting cluster will be deployed outside virtual private cloud (VPC).</p>
        pub fn cluster_subnet_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_subnet_group_name(input.into());
            self
        }
        /// <p>The name of a cluster subnet group to be associated with this cluster.</p>
        /// <p>If this parameter is not provided the resulting cluster will be deployed outside virtual private cloud (VPC).</p>
        pub fn set_cluster_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_subnet_group_name(input);
            self
        }
        /// <p>The EC2 Availability Zone (AZ) in which you want Amazon Redshift to provision the cluster. For example, if you have several EC2 instances running in a specific Availability Zone, then you might want the cluster to be provisioned in the same zone in order to decrease network latency.</p>
        /// <p>Default: A random, system-chosen Availability Zone in the region that is specified by the endpoint.</p>
        /// <p>Example: <code>us-east-2d</code> </p>
        /// <p>Constraint: The specified Availability Zone must be in the same region as the current endpoint.</p>
        pub fn availability_zone(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.availability_zone(input.into());
            self
        }
        /// <p>The EC2 Availability Zone (AZ) in which you want Amazon Redshift to provision the cluster. For example, if you have several EC2 instances running in a specific Availability Zone, then you might want the cluster to be provisioned in the same zone in order to decrease network latency.</p>
        /// <p>Default: A random, system-chosen Availability Zone in the region that is specified by the endpoint.</p>
        /// <p>Example: <code>us-east-2d</code> </p>
        /// <p>Constraint: The specified Availability Zone must be in the same region as the current endpoint.</p>
        pub fn set_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_availability_zone(input);
            self
        }
        /// <p>The weekly time range (in UTC) during which automated cluster maintenance can occur.</p>
        /// <p> Format: <code>ddd:hh24:mi-ddd:hh24:mi</code> </p>
        /// <p> Default: A 30-minute window selected at random from an 8-hour block of time per region, occurring on a random day of the week. For more information about the time blocks for each region, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#rs-maintenance-windows">Maintenance Windows</a> in Amazon Redshift Cluster Management Guide.</p>
        /// <p>Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun</p>
        /// <p>Constraints: Minimum 30-minute window.</p>
        pub fn preferred_maintenance_window(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.preferred_maintenance_window(input.into());
            self
        }
        /// <p>The weekly time range (in UTC) during which automated cluster maintenance can occur.</p>
        /// <p> Format: <code>ddd:hh24:mi-ddd:hh24:mi</code> </p>
        /// <p> Default: A 30-minute window selected at random from an 8-hour block of time per region, occurring on a random day of the week. For more information about the time blocks for each region, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#rs-maintenance-windows">Maintenance Windows</a> in Amazon Redshift Cluster Management Guide.</p>
        /// <p>Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun</p>
        /// <p>Constraints: Minimum 30-minute window.</p>
        pub fn set_preferred_maintenance_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_preferred_maintenance_window(input);
            self
        }
        /// <p>The name of the parameter group to be associated with this cluster.</p>
        /// <p>Default: The default Amazon Redshift cluster parameter group. For information about the default parameter group, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Working with Amazon Redshift Parameter Groups</a> </p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be 1 to 255 alphanumeric characters or hyphens.</p> </li>
        /// <li> <p>First character must be a letter.</p> </li>
        /// <li> <p>Cannot end with a hyphen or contain two consecutive hyphens.</p> </li>
        /// </ul>
        pub fn cluster_parameter_group_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.cluster_parameter_group_name(input.into());
            self
        }
        /// <p>The name of the parameter group to be associated with this cluster.</p>
        /// <p>Default: The default Amazon Redshift cluster parameter group. For information about the default parameter group, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Working with Amazon Redshift Parameter Groups</a> </p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be 1 to 255 alphanumeric characters or hyphens.</p> </li>
        /// <li> <p>First character must be a letter.</p> </li>
        /// <li> <p>Cannot end with a hyphen or contain two consecutive hyphens.</p> </li>
        /// </ul>
        pub fn set_cluster_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_parameter_group_name(input);
            self
        }
        /// <p>The number of days that automated snapshots are retained. If the value is 0, automated snapshots are disabled. Even if automated snapshots are disabled, you can still create manual snapshots when you want with <code>CreateClusterSnapshot</code>. </p>
        /// <p>You can't disable automated snapshots for RA3 node types. Set the automated retention period from 1-35 days.</p>
        /// <p>Default: <code>1</code> </p>
        /// <p>Constraints: Must be a value from 0 to 35.</p>
        pub fn automated_snapshot_retention_period(mut self, input: i32) -> Self {
            self.inner = self.inner.automated_snapshot_retention_period(input);
            self
        }
        /// <p>The number of days that automated snapshots are retained. If the value is 0, automated snapshots are disabled. Even if automated snapshots are disabled, you can still create manual snapshots when you want with <code>CreateClusterSnapshot</code>. </p>
        /// <p>You can't disable automated snapshots for RA3 node types. Set the automated retention period from 1-35 days.</p>
        /// <p>Default: <code>1</code> </p>
        /// <p>Constraints: Must be a value from 0 to 35.</p>
        pub fn set_automated_snapshot_retention_period(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.inner = self.inner.set_automated_snapshot_retention_period(input);
            self
        }
        /// <p>The default number of days to retain a manual snapshot. If the value is -1, the snapshot is retained indefinitely. This setting doesn't change the retention period of existing snapshots.</p>
        /// <p>The value must be either -1 or an integer between 1 and 3,653.</p>
        pub fn manual_snapshot_retention_period(mut self, input: i32) -> Self {
            self.inner = self.inner.manual_snapshot_retention_period(input);
            self
        }
        /// <p>The default number of days to retain a manual snapshot. If the value is -1, the snapshot is retained indefinitely. This setting doesn't change the retention period of existing snapshots.</p>
        /// <p>The value must be either -1 or an integer between 1 and 3,653.</p>
        pub fn set_manual_snapshot_retention_period(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.inner = self.inner.set_manual_snapshot_retention_period(input);
            self
        }
        /// <p>The port number on which the cluster accepts incoming connections.</p>
        /// <p>The cluster is accessible only via the JDBC and ODBC connection strings. Part of the connection string requires the port on which the cluster will listen for incoming connections.</p>
        /// <p>Default: <code>5439</code> </p>
        /// <p>Valid Values: <code>1150-65535</code> </p>
        pub fn port(mut self, input: i32) -> Self {
            self.inner = self.inner.port(input);
            self
        }
        /// <p>The port number on which the cluster accepts incoming connections.</p>
        /// <p>The cluster is accessible only via the JDBC and ODBC connection strings. Part of the connection string requires the port on which the cluster will listen for incoming connections.</p>
        /// <p>Default: <code>5439</code> </p>
        /// <p>Valid Values: <code>1150-65535</code> </p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_port(input);
            self
        }
        /// <p>The version of the Amazon Redshift engine software that you want to deploy on the cluster.</p>
        /// <p>The version selected runs on all the nodes in the cluster.</p>
        /// <p>Constraints: Only version 1.0 is currently available.</p>
        /// <p>Example: <code>1.0</code> </p>
        pub fn cluster_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_version(input.into());
            self
        }
        /// <p>The version of the Amazon Redshift engine software that you want to deploy on the cluster.</p>
        /// <p>The version selected runs on all the nodes in the cluster.</p>
        /// <p>Constraints: Only version 1.0 is currently available.</p>
        /// <p>Example: <code>1.0</code> </p>
        pub fn set_cluster_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_version(input);
            self
        }
        /// <p>If <code>true</code>, major version upgrades can be applied during the maintenance window to the Amazon Redshift engine that is running on the cluster.</p>
        /// <p>When a new major version of the Amazon Redshift engine is released, you can request that the service automatically apply upgrades during the maintenance window to the Amazon Redshift engine that is running on your cluster.</p>
        /// <p>Default: <code>true</code> </p>
        pub fn allow_version_upgrade(mut self, input: bool) -> Self {
            self.inner = self.inner.allow_version_upgrade(input);
            self
        }
        /// <p>If <code>true</code>, major version upgrades can be applied during the maintenance window to the Amazon Redshift engine that is running on the cluster.</p>
        /// <p>When a new major version of the Amazon Redshift engine is released, you can request that the service automatically apply upgrades during the maintenance window to the Amazon Redshift engine that is running on your cluster.</p>
        /// <p>Default: <code>true</code> </p>
        pub fn set_allow_version_upgrade(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_allow_version_upgrade(input);
            self
        }
        /// <p>The number of compute nodes in the cluster. This parameter is required when the <b>ClusterType</b> parameter is specified as <code>multi-node</code>. </p>
        /// <p>For information about determining how many nodes you need, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#how-many-nodes"> Working with Clusters</a> in the <i>Amazon Redshift Cluster Management Guide</i>. </p>
        /// <p>If you don't specify this parameter, you get a single-node cluster. When requesting a multi-node cluster, you must specify the number of nodes that you want in the cluster.</p>
        /// <p>Default: <code>1</code> </p>
        /// <p>Constraints: Value must be at least 1 and no more than 100.</p>
        pub fn number_of_nodes(mut self, input: i32) -> Self {
            self.inner = self.inner.number_of_nodes(input);
            self
        }
        /// <p>The number of compute nodes in the cluster. This parameter is required when the <b>ClusterType</b> parameter is specified as <code>multi-node</code>. </p>
        /// <p>For information about determining how many nodes you need, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#how-many-nodes"> Working with Clusters</a> in the <i>Amazon Redshift Cluster Management Guide</i>. </p>
        /// <p>If you don't specify this parameter, you get a single-node cluster. When requesting a multi-node cluster, you must specify the number of nodes that you want in the cluster.</p>
        /// <p>Default: <code>1</code> </p>
        /// <p>Constraints: Value must be at least 1 and no more than 100.</p>
        pub fn set_number_of_nodes(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_number_of_nodes(input);
            self
        }
        /// <p>If <code>true</code>, the cluster can be accessed from a public network. </p>
        pub fn publicly_accessible(mut self, input: bool) -> Self {
            self.inner = self.inner.publicly_accessible(input);
            self
        }
        /// <p>If <code>true</code>, the cluster can be accessed from a public network. </p>
        pub fn set_publicly_accessible(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_publicly_accessible(input);
            self
        }
        /// <p>If <code>true</code>, the data in the cluster is encrypted at rest. </p>
        /// <p>Default: false</p>
        pub fn encrypted(mut self, input: bool) -> Self {
            self.inner = self.inner.encrypted(input);
            self
        }
        /// <p>If <code>true</code>, the data in the cluster is encrypted at rest. </p>
        /// <p>Default: false</p>
        pub fn set_encrypted(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_encrypted(input);
            self
        }
        /// <p>Specifies the name of the HSM client certificate the Amazon Redshift cluster uses to retrieve the data encryption keys stored in an HSM.</p>
        pub fn hsm_client_certificate_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.hsm_client_certificate_identifier(input.into());
            self
        }
        /// <p>Specifies the name of the HSM client certificate the Amazon Redshift cluster uses to retrieve the data encryption keys stored in an HSM.</p>
        pub fn set_hsm_client_certificate_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_hsm_client_certificate_identifier(input);
            self
        }
        /// <p>Specifies the name of the HSM configuration that contains the information the Amazon Redshift cluster can use to retrieve and store keys in an HSM.</p>
        pub fn hsm_configuration_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.hsm_configuration_identifier(input.into());
            self
        }
        /// <p>Specifies the name of the HSM configuration that contains the information the Amazon Redshift cluster can use to retrieve and store keys in an HSM.</p>
        pub fn set_hsm_configuration_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_hsm_configuration_identifier(input);
            self
        }
        /// <p>The Elastic IP (EIP) address for the cluster.</p>
        /// <p>Constraints: The cluster must be provisioned in EC2-VPC and publicly-accessible through an Internet gateway. For more information about provisioning clusters in EC2-VPC, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#cluster-platforms">Supported Platforms to Launch Your Cluster</a> in the Amazon Redshift Cluster Management Guide.</p>
        pub fn elastic_ip(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.elastic_ip(input.into());
            self
        }
        /// <p>The Elastic IP (EIP) address for the cluster.</p>
        /// <p>Constraints: The cluster must be provisioned in EC2-VPC and publicly-accessible through an Internet gateway. For more information about provisioning clusters in EC2-VPC, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#cluster-platforms">Supported Platforms to Launch Your Cluster</a> in the Amazon Redshift Cluster Management Guide.</p>
        pub fn set_elastic_ip(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_elastic_ip(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tag instances.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of tag instances.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The Key Management Service (KMS) key ID of the encryption key that you want to use to encrypt data in the cluster.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key_id(input.into());
            self
        }
        /// <p>The Key Management Service (KMS) key ID of the encryption key that you want to use to encrypt data in the cluster.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key_id(input);
            self
        }
        /// <p>An option that specifies whether to create the cluster with enhanced VPC routing enabled. To create a cluster that uses enhanced VPC routing, the cluster must be in a VPC. For more information, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html">Enhanced VPC Routing</a> in the Amazon Redshift Cluster Management Guide.</p>
        /// <p>If this option is <code>true</code>, enhanced VPC routing is enabled. </p>
        /// <p>Default: false</p>
        pub fn enhanced_vpc_routing(mut self, input: bool) -> Self {
            self.inner = self.inner.enhanced_vpc_routing(input);
            self
        }
        /// <p>An option that specifies whether to create the cluster with enhanced VPC routing enabled. To create a cluster that uses enhanced VPC routing, the cluster must be in a VPC. For more information, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html">Enhanced VPC Routing</a> in the Amazon Redshift Cluster Management Guide.</p>
        /// <p>If this option is <code>true</code>, enhanced VPC routing is enabled. </p>
        /// <p>Default: false</p>
        pub fn set_enhanced_vpc_routing(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enhanced_vpc_routing(input);
            self
        }
        /// <p>Reserved.</p>
        pub fn additional_info(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.additional_info(input.into());
            self
        }
        /// <p>Reserved.</p>
        pub fn set_additional_info(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_additional_info(input);
            self
        }
        /// Appends an item to `IamRoles`.
        ///
        /// To override the contents of this collection use [`set_iam_roles`](Self::set_iam_roles).
        ///
        /// <p>A list of Identity and Access Management (IAM) roles that can be used by the cluster to access other Amazon Web Services services. You must supply the IAM roles in their Amazon Resource Name (ARN) format. </p>
        /// <p>The maximum number of IAM roles that you can associate is subject to a quota. For more information, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Quotas and limits</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</p>
        pub fn iam_roles(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.iam_roles(input.into());
            self
        }
        /// <p>A list of Identity and Access Management (IAM) roles that can be used by the cluster to access other Amazon Web Services services. You must supply the IAM roles in their Amazon Resource Name (ARN) format. </p>
        /// <p>The maximum number of IAM roles that you can associate is subject to a quota. For more information, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Quotas and limits</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</p>
        pub fn set_iam_roles(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_iam_roles(input);
            self
        }
        /// <p>An optional parameter for the name of the maintenance track for the cluster. If you don't provide a maintenance track name, the cluster is assigned to the <code>current</code> track.</p>
        pub fn maintenance_track_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.maintenance_track_name(input.into());
            self
        }
        /// <p>An optional parameter for the name of the maintenance track for the cluster. If you don't provide a maintenance track name, the cluster is assigned to the <code>current</code> track.</p>
        pub fn set_maintenance_track_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_maintenance_track_name(input);
            self
        }
        /// <p>A unique identifier for the snapshot schedule.</p>
        pub fn snapshot_schedule_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.snapshot_schedule_identifier(input.into());
            self
        }
        /// <p>A unique identifier for the snapshot schedule.</p>
        pub fn set_snapshot_schedule_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_snapshot_schedule_identifier(input);
            self
        }
        /// <p>The option to enable relocation for an Amazon Redshift cluster between Availability Zones after the cluster is created.</p>
        pub fn availability_zone_relocation(mut self, input: bool) -> Self {
            self.inner = self.inner.availability_zone_relocation(input);
            self
        }
        /// <p>The option to enable relocation for an Amazon Redshift cluster between Availability Zones after the cluster is created.</p>
        pub fn set_availability_zone_relocation(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_availability_zone_relocation(input);
            self
        }
        /// <p>The value represents how the cluster is configured to use AQUA (Advanced Query Accelerator) when it is created. Possible values include the following.</p>
        /// <ul>
        /// <li> <p>enabled - Use AQUA if it is available for the current Amazon Web Services Region and Amazon Redshift node type.</p> </li>
        /// <li> <p>disabled - Don't use AQUA. </p> </li>
        /// <li> <p>auto - Amazon Redshift determines whether to use AQUA.</p> </li>
        /// </ul>
        pub fn aqua_configuration_status(
            mut self,
            input: crate::model::AquaConfigurationStatus,
        ) -> Self {
            self.inner = self.inner.aqua_configuration_status(input);
            self
        }
        /// <p>The value represents how the cluster is configured to use AQUA (Advanced Query Accelerator) when it is created. Possible values include the following.</p>
        /// <ul>
        /// <li> <p>enabled - Use AQUA if it is available for the current Amazon Web Services Region and Amazon Redshift node type.</p> </li>
        /// <li> <p>disabled - Don't use AQUA. </p> </li>
        /// <li> <p>auto - Amazon Redshift determines whether to use AQUA.</p> </li>
        /// </ul>
        pub fn set_aqua_configuration_status(
            mut self,
            input: std::option::Option<crate::model::AquaConfigurationStatus>,
        ) -> Self {
            self.inner = self.inner.set_aqua_configuration_status(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the IAM role that was set as default for the cluster when the cluster was created. </p>
        pub fn default_iam_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.default_iam_role_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the IAM role that was set as default for the cluster when the cluster was created. </p>
        pub fn set_default_iam_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_default_iam_role_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateClusterParameterGroup`.
    ///
    /// <p>Creates an Amazon Redshift parameter group.</p>
    /// <p>Creating parameter groups is independent of creating clusters. You can associate a cluster with a parameter group when you create the cluster. You can also associate an existing cluster with a parameter group after the cluster is created by using <code>ModifyCluster</code>. </p>
    /// <p>Parameters in the parameter group define specific behavior that applies to the databases you create on the cluster. For more information about parameters and parameter groups, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Amazon Redshift Parameter Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateClusterParameterGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_cluster_parameter_group_input::Builder,
    }
    impl CreateClusterParameterGroup {
        /// Creates a new `CreateClusterParameterGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateClusterParameterGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateClusterParameterGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the cluster parameter group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be 1 to 255 alphanumeric characters or hyphens</p> </li>
        /// <li> <p>First character must be a letter.</p> </li>
        /// <li> <p>Cannot end with a hyphen or contain two consecutive hyphens.</p> </li>
        /// <li> <p>Must be unique withing your Amazon Web Services account.</p> </li>
        /// </ul> <note>
        /// <p>This value is stored as a lower-case string.</p>
        /// </note>
        pub fn parameter_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.parameter_group_name(input.into());
            self
        }
        /// <p>The name of the cluster parameter group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be 1 to 255 alphanumeric characters or hyphens</p> </li>
        /// <li> <p>First character must be a letter.</p> </li>
        /// <li> <p>Cannot end with a hyphen or contain two consecutive hyphens.</p> </li>
        /// <li> <p>Must be unique withing your Amazon Web Services account.</p> </li>
        /// </ul> <note>
        /// <p>This value is stored as a lower-case string.</p>
        /// </note>
        pub fn set_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_parameter_group_name(input);
            self
        }
        /// <p>The Amazon Redshift engine version to which the cluster parameter group applies. The cluster engine version determines the set of parameters.</p>
        /// <p>To get a list of valid parameter group family names, you can call <code>DescribeClusterParameterGroups</code>. By default, Amazon Redshift returns a list of all the parameter groups that are owned by your Amazon Web Services account, including the default parameter groups for each Amazon Redshift engine version. The parameter group family names associated with the default parameter groups provide you the valid values. For example, a valid family name is "redshift-1.0". </p>
        pub fn parameter_group_family(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.parameter_group_family(input.into());
            self
        }
        /// <p>The Amazon Redshift engine version to which the cluster parameter group applies. The cluster engine version determines the set of parameters.</p>
        /// <p>To get a list of valid parameter group family names, you can call <code>DescribeClusterParameterGroups</code>. By default, Amazon Redshift returns a list of all the parameter groups that are owned by your Amazon Web Services account, including the default parameter groups for each Amazon Redshift engine version. The parameter group family names associated with the default parameter groups provide you the valid values. For example, a valid family name is "redshift-1.0". </p>
        pub fn set_parameter_group_family(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_parameter_group_family(input);
            self
        }
        /// <p>A description of the parameter group.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description of the parameter group.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tag instances.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of tag instances.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateClusterSecurityGroup`.
    ///
    /// <p>Creates a new Amazon Redshift security group. You use security groups to control access to non-VPC clusters.</p>
    /// <p> For information about managing security groups, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-security-groups.html">Amazon Redshift Cluster Security Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateClusterSecurityGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_cluster_security_group_input::Builder,
    }
    impl CreateClusterSecurityGroup {
        /// Creates a new `CreateClusterSecurityGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateClusterSecurityGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateClusterSecurityGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name for the security group. Amazon Redshift stores the value as a lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must contain no more than 255 alphanumeric characters or hyphens.</p> </li>
        /// <li> <p>Must not be "Default".</p> </li>
        /// <li> <p>Must be unique for all security groups that are created by your Amazon Web Services account.</p> </li>
        /// </ul>
        /// <p>Example: <code>examplesecuritygroup</code> </p>
        pub fn cluster_security_group_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.cluster_security_group_name(input.into());
            self
        }
        /// <p>The name for the security group. Amazon Redshift stores the value as a lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must contain no more than 255 alphanumeric characters or hyphens.</p> </li>
        /// <li> <p>Must not be "Default".</p> </li>
        /// <li> <p>Must be unique for all security groups that are created by your Amazon Web Services account.</p> </li>
        /// </ul>
        /// <p>Example: <code>examplesecuritygroup</code> </p>
        pub fn set_cluster_security_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_security_group_name(input);
            self
        }
        /// <p>A description for the security group.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description for the security group.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tag instances.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of tag instances.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateClusterSnapshot`.
    ///
    /// <p>Creates a manual snapshot of the specified cluster. The cluster must be in the <code>available</code> state. </p>
    /// <p> For more information about working with snapshots, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-snapshots.html">Amazon Redshift Snapshots</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateClusterSnapshot {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_cluster_snapshot_input::Builder,
    }
    impl CreateClusterSnapshot {
        /// Creates a new `CreateClusterSnapshot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateClusterSnapshotOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateClusterSnapshotError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique identifier for the snapshot that you are requesting. This identifier must be unique for all snapshots within the Amazon Web Services account.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Cannot be null, empty, or blank</p> </li>
        /// <li> <p>Must contain from 1 to 255 alphanumeric characters or hyphens</p> </li>
        /// <li> <p>First character must be a letter</p> </li>
        /// <li> <p>Cannot end with a hyphen or contain two consecutive hyphens</p> </li>
        /// </ul>
        /// <p>Example: <code>my-snapshot-id</code> </p>
        pub fn snapshot_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.snapshot_identifier(input.into());
            self
        }
        /// <p>A unique identifier for the snapshot that you are requesting. This identifier must be unique for all snapshots within the Amazon Web Services account.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Cannot be null, empty, or blank</p> </li>
        /// <li> <p>Must contain from 1 to 255 alphanumeric characters or hyphens</p> </li>
        /// <li> <p>First character must be a letter</p> </li>
        /// <li> <p>Cannot end with a hyphen or contain two consecutive hyphens</p> </li>
        /// </ul>
        /// <p>Example: <code>my-snapshot-id</code> </p>
        pub fn set_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_snapshot_identifier(input);
            self
        }
        /// <p>The cluster identifier for which you want a snapshot.</p>
        pub fn cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_identifier(input.into());
            self
        }
        /// <p>The cluster identifier for which you want a snapshot.</p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_identifier(input);
            self
        }
        /// <p>The number of days that a manual snapshot is retained. If the value is -1, the manual snapshot is retained indefinitely. </p>
        /// <p>The value must be either -1 or an integer between 1 and 3,653.</p>
        /// <p>The default value is -1.</p>
        pub fn manual_snapshot_retention_period(mut self, input: i32) -> Self {
            self.inner = self.inner.manual_snapshot_retention_period(input);
            self
        }
        /// <p>The number of days that a manual snapshot is retained. If the value is -1, the manual snapshot is retained indefinitely. </p>
        /// <p>The value must be either -1 or an integer between 1 and 3,653.</p>
        /// <p>The default value is -1.</p>
        pub fn set_manual_snapshot_retention_period(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.inner = self.inner.set_manual_snapshot_retention_period(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tag instances.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of tag instances.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateClusterSubnetGroup`.
    ///
    /// <p>Creates a new Amazon Redshift subnet group. You must provide a list of one or more subnets in your existing Amazon Virtual Private Cloud (Amazon VPC) when creating Amazon Redshift subnet group.</p>
    /// <p> For information about subnet groups, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-cluster-subnet-groups.html">Amazon Redshift Cluster Subnet Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateClusterSubnetGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_cluster_subnet_group_input::Builder,
    }
    impl CreateClusterSubnetGroup {
        /// Creates a new `CreateClusterSubnetGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateClusterSubnetGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateClusterSubnetGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name for the subnet group. Amazon Redshift stores the value as a lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must contain no more than 255 alphanumeric characters or hyphens.</p> </li>
        /// <li> <p>Must not be "Default".</p> </li>
        /// <li> <p>Must be unique for all subnet groups that are created by your Amazon Web Services account.</p> </li>
        /// </ul>
        /// <p>Example: <code>examplesubnetgroup</code> </p>
        pub fn cluster_subnet_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_subnet_group_name(input.into());
            self
        }
        /// <p>The name for the subnet group. Amazon Redshift stores the value as a lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must contain no more than 255 alphanumeric characters or hyphens.</p> </li>
        /// <li> <p>Must not be "Default".</p> </li>
        /// <li> <p>Must be unique for all subnet groups that are created by your Amazon Web Services account.</p> </li>
        /// </ul>
        /// <p>Example: <code>examplesubnetgroup</code> </p>
        pub fn set_cluster_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_subnet_group_name(input);
            self
        }
        /// <p>A description for the subnet group.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description for the subnet group.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `SubnetIds`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// <p>An array of VPC subnet IDs. A maximum of 20 subnets can be modified in a single request.</p>
        pub fn subnet_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subnet_ids(input.into());
            self
        }
        /// <p>An array of VPC subnet IDs. A maximum of 20 subnets can be modified in a single request.</p>
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_subnet_ids(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tag instances.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of tag instances.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateEndpointAccess`.
    ///
    /// <p>Creates a Redshift-managed VPC endpoint.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateEndpointAccess {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_endpoint_access_input::Builder,
    }
    impl CreateEndpointAccess {
        /// Creates a new `CreateEndpointAccess`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateEndpointAccessOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateEndpointAccessError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The cluster identifier of the cluster to access.</p>
        pub fn cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_identifier(input.into());
            self
        }
        /// <p>The cluster identifier of the cluster to access.</p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_identifier(input);
            self
        }
        /// <p>The Amazon Web Services account ID of the owner of the cluster. This is only required if the cluster is in another Amazon Web Services account.</p>
        pub fn resource_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_owner(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID of the owner of the cluster. This is only required if the cluster is in another Amazon Web Services account.</p>
        pub fn set_resource_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_owner(input);
            self
        }
        /// <p>The Redshift-managed VPC endpoint name.</p>
        /// <p>An endpoint name must contain 1-30 characters. Valid characters are A-Z, a-z, 0-9, and hyphen(-). The first character must be a letter. The name can't contain two consecutive hyphens or end with a hyphen.</p>
        pub fn endpoint_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.endpoint_name(input.into());
            self
        }
        /// <p>The Redshift-managed VPC endpoint name.</p>
        /// <p>An endpoint name must contain 1-30 characters. Valid characters are A-Z, a-z, 0-9, and hyphen(-). The first character must be a letter. The name can't contain two consecutive hyphens or end with a hyphen.</p>
        pub fn set_endpoint_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_endpoint_name(input);
            self
        }
        /// <p>The subnet group from which Amazon Redshift chooses the subnet to deploy the endpoint.</p>
        pub fn subnet_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subnet_group_name(input.into());
            self
        }
        /// <p>The subnet group from which Amazon Redshift chooses the subnet to deploy the endpoint.</p>
        pub fn set_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_subnet_group_name(input);
            self
        }
        /// Appends an item to `VpcSecurityGroupIds`.
        ///
        /// To override the contents of this collection use [`set_vpc_security_group_ids`](Self::set_vpc_security_group_ids).
        ///
        /// <p>The security group that defines the ports, protocols, and sources for inbound traffic that you are authorizing into your endpoint.</p>
        pub fn vpc_security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc_security_group_ids(input.into());
            self
        }
        /// <p>The security group that defines the ports, protocols, and sources for inbound traffic that you are authorizing into your endpoint.</p>
        pub fn set_vpc_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_vpc_security_group_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateEventSubscription`.
    ///
    /// <p>Creates an Amazon Redshift event notification subscription. This action requires an ARN (Amazon Resource Name) of an Amazon SNS topic created by either the Amazon Redshift console, the Amazon SNS console, or the Amazon SNS API. To obtain an ARN with Amazon SNS, you must create a topic in Amazon SNS and subscribe to the topic. The ARN is displayed in the SNS console.</p>
    /// <p>You can specify the source type, and lists of Amazon Redshift source IDs, event categories, and event severities. Notifications will be sent for all events you want that match those criteria. For example, you can specify source type = cluster, source ID = my-cluster-1 and mycluster2, event categories = Availability, Backup, and severity = ERROR. The subscription will only send notifications for those ERROR events in the Availability and Backup categories for the specified clusters.</p>
    /// <p>If you specify both the source type and source IDs, such as source type = cluster and source identifier = my-cluster-1, notifications will be sent for all the cluster events for my-cluster-1. If you specify a source type but do not specify a source identifier, you will receive notice of the events for the objects of that type in your Amazon Web Services account. If you do not specify either the SourceType nor the SourceIdentifier, you will be notified of events generated from all Amazon Redshift sources belonging to your Amazon Web Services account. You must specify a source type if you specify a source ID.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateEventSubscription {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_event_subscription_input::Builder,
    }
    impl CreateEventSubscription {
        /// Creates a new `CreateEventSubscription`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateEventSubscriptionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateEventSubscriptionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the event subscription to be created.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Cannot be null, empty, or blank.</p> </li>
        /// <li> <p>Must contain from 1 to 255 alphanumeric characters or hyphens.</p> </li>
        /// <li> <p>First character must be a letter.</p> </li>
        /// <li> <p>Cannot end with a hyphen or contain two consecutive hyphens.</p> </li>
        /// </ul>
        pub fn subscription_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subscription_name(input.into());
            self
        }
        /// <p>The name of the event subscription to be created.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Cannot be null, empty, or blank.</p> </li>
        /// <li> <p>Must contain from 1 to 255 alphanumeric characters or hyphens.</p> </li>
        /// <li> <p>First character must be a letter.</p> </li>
        /// <li> <p>Cannot end with a hyphen or contain two consecutive hyphens.</p> </li>
        /// </ul>
        pub fn set_subscription_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_subscription_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon SNS topic used to transmit the event notifications. The ARN is created by Amazon SNS when you create a topic and subscribe to it.</p>
        pub fn sns_topic_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sns_topic_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon SNS topic used to transmit the event notifications. The ARN is created by Amazon SNS when you create a topic and subscribe to it.</p>
        pub fn set_sns_topic_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_sns_topic_arn(input);
            self
        }
        /// <p>The type of source that will be generating the events. For example, if you want to be notified of events generated by a cluster, you would set this parameter to cluster. If this value is not specified, events are returned for all Amazon Redshift objects in your Amazon Web Services account. You must specify a source type in order to specify source IDs.</p>
        /// <p>Valid values: cluster, cluster-parameter-group, cluster-security-group, cluster-snapshot, and scheduled-action.</p>
        pub fn source_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_type(input.into());
            self
        }
        /// <p>The type of source that will be generating the events. For example, if you want to be notified of events generated by a cluster, you would set this parameter to cluster. If this value is not specified, events are returned for all Amazon Redshift objects in your Amazon Web Services account. You must specify a source type in order to specify source IDs.</p>
        /// <p>Valid values: cluster, cluster-parameter-group, cluster-security-group, cluster-snapshot, and scheduled-action.</p>
        pub fn set_source_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_source_type(input);
            self
        }
        /// Appends an item to `SourceIds`.
        ///
        /// To override the contents of this collection use [`set_source_ids`](Self::set_source_ids).
        ///
        /// <p>A list of one or more identifiers of Amazon Redshift source objects. All of the objects must be of the same type as was specified in the source type parameter. The event subscription will return only events generated by the specified objects. If not specified, then events are returned for all objects within the source type specified.</p>
        /// <p>Example: my-cluster-1, my-cluster-2</p>
        /// <p>Example: my-snapshot-20131010</p>
        pub fn source_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_ids(input.into());
            self
        }
        /// <p>A list of one or more identifiers of Amazon Redshift source objects. All of the objects must be of the same type as was specified in the source type parameter. The event subscription will return only events generated by the specified objects. If not specified, then events are returned for all objects within the source type specified.</p>
        /// <p>Example: my-cluster-1, my-cluster-2</p>
        /// <p>Example: my-snapshot-20131010</p>
        pub fn set_source_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_source_ids(input);
            self
        }
        /// Appends an item to `EventCategories`.
        ///
        /// To override the contents of this collection use [`set_event_categories`](Self::set_event_categories).
        ///
        /// <p>Specifies the Amazon Redshift event categories to be published by the event notification subscription.</p>
        /// <p>Values: configuration, management, monitoring, security, pending</p>
        pub fn event_categories(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_categories(input.into());
            self
        }
        /// <p>Specifies the Amazon Redshift event categories to be published by the event notification subscription.</p>
        /// <p>Values: configuration, management, monitoring, security, pending</p>
        pub fn set_event_categories(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_event_categories(input);
            self
        }
        /// <p>Specifies the Amazon Redshift event severity to be published by the event notification subscription.</p>
        /// <p>Values: ERROR, INFO</p>
        pub fn severity(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.severity(input.into());
            self
        }
        /// <p>Specifies the Amazon Redshift event severity to be published by the event notification subscription.</p>
        /// <p>Values: ERROR, INFO</p>
        pub fn set_severity(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_severity(input);
            self
        }
        /// <p>A boolean value; set to <code>true</code> to activate the subscription, and set to <code>false</code> to create the subscription but not activate it. </p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.inner = self.inner.enabled(input);
            self
        }
        /// <p>A boolean value; set to <code>true</code> to activate the subscription, and set to <code>false</code> to create the subscription but not activate it. </p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enabled(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tag instances.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of tag instances.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateHsmClientCertificate`.
    ///
    /// <p>Creates an HSM client certificate that an Amazon Redshift cluster will use to connect to the client's HSM in order to store and retrieve the keys used to encrypt the cluster databases.</p>
    /// <p>The command returns a public key, which you must store in the HSM. In addition to creating the HSM certificate, you must create an Amazon Redshift HSM configuration that provides a cluster the information needed to store and use encryption keys in the HSM. For more information, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-db-encryption.html#working-with-HSM">Hardware Security Modules</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateHsmClientCertificate {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_hsm_client_certificate_input::Builder,
    }
    impl CreateHsmClientCertificate {
        /// Creates a new `CreateHsmClientCertificate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateHsmClientCertificateOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateHsmClientCertificateError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier to be assigned to the new HSM client certificate that the cluster will use to connect to the HSM to use the database encryption keys.</p>
        pub fn hsm_client_certificate_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.hsm_client_certificate_identifier(input.into());
            self
        }
        /// <p>The identifier to be assigned to the new HSM client certificate that the cluster will use to connect to the HSM to use the database encryption keys.</p>
        pub fn set_hsm_client_certificate_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_hsm_client_certificate_identifier(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tag instances.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of tag instances.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateHsmConfiguration`.
    ///
    /// <p>Creates an HSM configuration that contains the information required by an Amazon Redshift cluster to store and use database encryption keys in a Hardware Security Module (HSM). After creating the HSM configuration, you can specify it as a parameter when creating a cluster. The cluster will then store its encryption keys in the HSM.</p>
    /// <p>In addition to creating an HSM configuration, you must also create an HSM client certificate. For more information, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-HSM.html">Hardware Security Modules</a> in the Amazon Redshift Cluster Management Guide.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateHsmConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_hsm_configuration_input::Builder,
    }
    impl CreateHsmConfiguration {
        /// Creates a new `CreateHsmConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateHsmConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateHsmConfigurationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier to be assigned to the new Amazon Redshift HSM configuration.</p>
        pub fn hsm_configuration_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.hsm_configuration_identifier(input.into());
            self
        }
        /// <p>The identifier to be assigned to the new Amazon Redshift HSM configuration.</p>
        pub fn set_hsm_configuration_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_hsm_configuration_identifier(input);
            self
        }
        /// <p>A text description of the HSM configuration to be created.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A text description of the HSM configuration to be created.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The IP address that the Amazon Redshift cluster must use to access the HSM.</p>
        pub fn hsm_ip_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hsm_ip_address(input.into());
            self
        }
        /// <p>The IP address that the Amazon Redshift cluster must use to access the HSM.</p>
        pub fn set_hsm_ip_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_hsm_ip_address(input);
            self
        }
        /// <p>The name of the partition in the HSM where the Amazon Redshift clusters will store their database encryption keys.</p>
        pub fn hsm_partition_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hsm_partition_name(input.into());
            self
        }
        /// <p>The name of the partition in the HSM where the Amazon Redshift clusters will store their database encryption keys.</p>
        pub fn set_hsm_partition_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_hsm_partition_name(input);
            self
        }
        /// <p>The password required to access the HSM partition.</p>
        pub fn hsm_partition_password(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.hsm_partition_password(input.into());
            self
        }
        /// <p>The password required to access the HSM partition.</p>
        pub fn set_hsm_partition_password(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_hsm_partition_password(input);
            self
        }
        /// <p>The HSMs public certificate file. When using Cloud HSM, the file name is server.pem.</p>
        pub fn hsm_server_public_certificate(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.hsm_server_public_certificate(input.into());
            self
        }
        /// <p>The HSMs public certificate file. When using Cloud HSM, the file name is server.pem.</p>
        pub fn set_hsm_server_public_certificate(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_hsm_server_public_certificate(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tag instances.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of tag instances.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateScheduledAction`.
    ///
    /// <p>Creates a scheduled action. A scheduled action contains a schedule and an Amazon Redshift API action. For example, you can create a schedule of when to run the <code>ResizeCluster</code> API operation. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateScheduledAction {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_scheduled_action_input::Builder,
    }
    impl CreateScheduledAction {
        /// Creates a new `CreateScheduledAction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateScheduledActionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateScheduledActionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the scheduled action. The name must be unique within an account. For more information about this parameter, see <code>ScheduledAction</code>. </p>
        pub fn scheduled_action_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.scheduled_action_name(input.into());
            self
        }
        /// <p>The name of the scheduled action. The name must be unique within an account. For more information about this parameter, see <code>ScheduledAction</code>. </p>
        pub fn set_scheduled_action_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_scheduled_action_name(input);
            self
        }
        /// <p>A JSON format string of the Amazon Redshift API operation with input parameters. For more information about this parameter, see <code>ScheduledAction</code>. </p>
        pub fn target_action(mut self, input: crate::model::ScheduledActionType) -> Self {
            self.inner = self.inner.target_action(input);
            self
        }
        /// <p>A JSON format string of the Amazon Redshift API operation with input parameters. For more information about this parameter, see <code>ScheduledAction</code>. </p>
        pub fn set_target_action(
            mut self,
            input: std::option::Option<crate::model::ScheduledActionType>,
        ) -> Self {
            self.inner = self.inner.set_target_action(input);
            self
        }
        /// <p>The schedule in <code>at( )</code> or <code>cron( )</code> format. For more information about this parameter, see <code>ScheduledAction</code>.</p>
        pub fn schedule(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schedule(input.into());
            self
        }
        /// <p>The schedule in <code>at( )</code> or <code>cron( )</code> format. For more information about this parameter, see <code>ScheduledAction</code>.</p>
        pub fn set_schedule(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_schedule(input);
            self
        }
        /// <p>The IAM role to assume to run the target action. For more information about this parameter, see <code>ScheduledAction</code>. </p>
        pub fn iam_role(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.iam_role(input.into());
            self
        }
        /// <p>The IAM role to assume to run the target action. For more information about this parameter, see <code>ScheduledAction</code>. </p>
        pub fn set_iam_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_iam_role(input);
            self
        }
        /// <p>The description of the scheduled action. </p>
        pub fn scheduled_action_description(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.scheduled_action_description(input.into());
            self
        }
        /// <p>The description of the scheduled action. </p>
        pub fn set_scheduled_action_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_scheduled_action_description(input);
            self
        }
        /// <p>The start time in UTC of the scheduled action. Before this time, the scheduled action does not trigger. For more information about this parameter, see <code>ScheduledAction</code>.</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.start_time(input);
            self
        }
        /// <p>The start time in UTC of the scheduled action. Before this time, the scheduled action does not trigger. For more information about this parameter, see <code>ScheduledAction</code>.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_start_time(input);
            self
        }
        /// <p>The end time in UTC of the scheduled action. After this time, the scheduled action does not trigger. For more information about this parameter, see <code>ScheduledAction</code>. </p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.end_time(input);
            self
        }
        /// <p>The end time in UTC of the scheduled action. After this time, the scheduled action does not trigger. For more information about this parameter, see <code>ScheduledAction</code>. </p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_end_time(input);
            self
        }
        /// <p>If true, the schedule is enabled. If false, the scheduled action does not trigger. For more information about <code>state</code> of the scheduled action, see <code>ScheduledAction</code>. </p>
        pub fn enable(mut self, input: bool) -> Self {
            self.inner = self.inner.enable(input);
            self
        }
        /// <p>If true, the schedule is enabled. If false, the scheduled action does not trigger. For more information about <code>state</code> of the scheduled action, see <code>ScheduledAction</code>. </p>
        pub fn set_enable(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enable(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateSnapshotCopyGrant`.
    ///
    /// <p>Creates a snapshot copy grant that permits Amazon Redshift to use an encrypted symmetric key from Key Management Service (KMS) to encrypt copied snapshots in a destination region.</p>
    /// <p> For more information about managing snapshot copy grants, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-db-encryption.html">Amazon Redshift Database Encryption</a> in the <i>Amazon Redshift Cluster Management Guide</i>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateSnapshotCopyGrant {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_snapshot_copy_grant_input::Builder,
    }
    impl CreateSnapshotCopyGrant {
        /// Creates a new `CreateSnapshotCopyGrant`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateSnapshotCopyGrantOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateSnapshotCopyGrantError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the snapshot copy grant. This name must be unique in the region for the Amazon Web Services account.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must contain from 1 to 63 alphanumeric characters or hyphens.</p> </li>
        /// <li> <p>Alphabetic characters must be lowercase.</p> </li>
        /// <li> <p>First character must be a letter.</p> </li>
        /// <li> <p>Cannot end with a hyphen or contain two consecutive hyphens.</p> </li>
        /// <li> <p>Must be unique for all clusters within an Amazon Web Services account.</p> </li>
        /// </ul>
        pub fn snapshot_copy_grant_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.snapshot_copy_grant_name(input.into());
            self
        }
        /// <p>The name of the snapshot copy grant. This name must be unique in the region for the Amazon Web Services account.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must contain from 1 to 63 alphanumeric characters or hyphens.</p> </li>
        /// <li> <p>Alphabetic characters must be lowercase.</p> </li>
        /// <li> <p>First character must be a letter.</p> </li>
        /// <li> <p>Cannot end with a hyphen or contain two consecutive hyphens.</p> </li>
        /// <li> <p>Must be unique for all clusters within an Amazon Web Services account.</p> </li>
        /// </ul>
        pub fn set_snapshot_copy_grant_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_snapshot_copy_grant_name(input);
            self
        }
        /// <p>The unique identifier of the encrypted symmetric key to which to grant Amazon Redshift permission. If no key is specified, the default key is used.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key_id(input.into());
            self
        }
        /// <p>The unique identifier of the encrypted symmetric key to which to grant Amazon Redshift permission. If no key is specified, the default key is used.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key_id(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tag instances.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of tag instances.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateSnapshotSchedule`.
    ///
    /// <p>Create a snapshot schedule that can be associated to a cluster and which overrides the default system backup schedule. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateSnapshotSchedule {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_snapshot_schedule_input::Builder,
    }
    impl CreateSnapshotSchedule {
        /// Creates a new `CreateSnapshotSchedule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateSnapshotScheduleOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateSnapshotScheduleError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `ScheduleDefinitions`.
        ///
        /// To override the contents of this collection use [`set_schedule_definitions`](Self::set_schedule_definitions).
        ///
        /// <p>The definition of the snapshot schedule. The definition is made up of schedule expressions, for example "cron(30 12 *)" or "rate(12 hours)". </p>
        pub fn schedule_definitions(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schedule_definitions(input.into());
            self
        }
        /// <p>The definition of the snapshot schedule. The definition is made up of schedule expressions, for example "cron(30 12 *)" or "rate(12 hours)". </p>
        pub fn set_schedule_definitions(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_schedule_definitions(input);
            self
        }
        /// <p>A unique identifier for a snapshot schedule. Only alphanumeric characters are allowed for the identifier.</p>
        pub fn schedule_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schedule_identifier(input.into());
            self
        }
        /// <p>A unique identifier for a snapshot schedule. Only alphanumeric characters are allowed for the identifier.</p>
        pub fn set_schedule_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_schedule_identifier(input);
            self
        }
        /// <p>The description of the snapshot schedule.</p>
        pub fn schedule_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schedule_description(input.into());
            self
        }
        /// <p>The description of the snapshot schedule.</p>
        pub fn set_schedule_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_schedule_description(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An optional set of tags you can use to search for the schedule.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>An optional set of tags you can use to search for the schedule.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p></p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.inner = self.inner.dry_run(input);
            self
        }
        /// <p></p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_dry_run(input);
            self
        }
        /// <p></p>
        pub fn next_invocations(mut self, input: i32) -> Self {
            self.inner = self.inner.next_invocations(input);
            self
        }
        /// <p></p>
        pub fn set_next_invocations(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_next_invocations(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateTags`.
    ///
    /// <p>Adds tags to a cluster.</p>
    /// <p>A resource can have up to 50 tags. If you try to create more than 50 tags for a resource, you will receive an error and the attempt will fail.</p>
    /// <p>If you specify a key that already exists for the resource, the value for that key will be updated with the new value.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateTags {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_tags_input::Builder,
    }
    impl CreateTags {
        /// Creates a new `CreateTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateTagsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) to which you want to add the tag or tags. For example, <code>arn:aws:redshift:us-east-2:123456789:cluster:t1</code>. </p>
        pub fn resource_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_name(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) to which you want to add the tag or tags. For example, <code>arn:aws:redshift:us-east-2:123456789:cluster:t1</code>. </p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_name(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>One or more name/value pairs to add as tags to the specified resource. Each tag name is passed in with the parameter <code>Key</code> and the corresponding value is passed in with the parameter <code>Value</code>. The <code>Key</code> and <code>Value</code> parameters are separated by a comma (,). Separate multiple tags with a space. For example, <code>--tags "Key"="owner","Value"="admin" "Key"="environment","Value"="test" "Key"="version","Value"="1.0"</code>. </p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>One or more name/value pairs to add as tags to the specified resource. Each tag name is passed in with the parameter <code>Key</code> and the corresponding value is passed in with the parameter <code>Value</code>. The <code>Key</code> and <code>Value</code> parameters are separated by a comma (,). Separate multiple tags with a space. For example, <code>--tags "Key"="owner","Value"="admin" "Key"="environment","Value"="test" "Key"="version","Value"="1.0"</code>. </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateUsageLimit`.
    ///
    /// <p>Creates a usage limit for a specified Amazon Redshift feature on a cluster. The usage limit is identified by the returned usage limit identifier.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateUsageLimit {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_usage_limit_input::Builder,
    }
    impl CreateUsageLimit {
        /// Creates a new `CreateUsageLimit`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateUsageLimitOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateUsageLimitError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the cluster that you want to limit usage.</p>
        pub fn cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_identifier(input.into());
            self
        }
        /// <p>The identifier of the cluster that you want to limit usage.</p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_identifier(input);
            self
        }
        /// <p>The Amazon Redshift feature that you want to limit.</p>
        pub fn feature_type(mut self, input: crate::model::UsageLimitFeatureType) -> Self {
            self.inner = self.inner.feature_type(input);
            self
        }
        /// <p>The Amazon Redshift feature that you want to limit.</p>
        pub fn set_feature_type(
            mut self,
            input: std::option::Option<crate::model::UsageLimitFeatureType>,
        ) -> Self {
            self.inner = self.inner.set_feature_type(input);
            self
        }
        /// <p>The type of limit. Depending on the feature type, this can be based on a time duration or data size. If <code>FeatureType</code> is <code>spectrum</code>, then <code>LimitType</code> must be <code>data-scanned</code>. If <code>FeatureType</code> is <code>concurrency-scaling</code>, then <code>LimitType</code> must be <code>time</code>. If <code>FeatureType</code> is <code>cross-region-datasharing</code>, then <code>LimitType</code> must be <code>data-scanned</code>. </p>
        pub fn limit_type(mut self, input: crate::model::UsageLimitLimitType) -> Self {
            self.inner = self.inner.limit_type(input);
            self
        }
        /// <p>The type of limit. Depending on the feature type, this can be based on a time duration or data size. If <code>FeatureType</code> is <code>spectrum</code>, then <code>LimitType</code> must be <code>data-scanned</code>. If <code>FeatureType</code> is <code>concurrency-scaling</code>, then <code>LimitType</code> must be <code>time</code>. If <code>FeatureType</code> is <code>cross-region-datasharing</code>, then <code>LimitType</code> must be <code>data-scanned</code>. </p>
        pub fn set_limit_type(
            mut self,
            input: std::option::Option<crate::model::UsageLimitLimitType>,
        ) -> Self {
            self.inner = self.inner.set_limit_type(input);
            self
        }
        /// <p>The limit amount. If time-based, this amount is in minutes. If data-based, this amount is in terabytes (TB). The value must be a positive number. </p>
        pub fn amount(mut self, input: i64) -> Self {
            self.inner = self.inner.amount(input);
            self
        }
        /// <p>The limit amount. If time-based, this amount is in minutes. If data-based, this amount is in terabytes (TB). The value must be a positive number. </p>
        pub fn set_amount(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_amount(input);
            self
        }
        /// <p>The time period that the amount applies to. A <code>weekly</code> period begins on Sunday. The default is <code>monthly</code>. </p>
        pub fn period(mut self, input: crate::model::UsageLimitPeriod) -> Self {
            self.inner = self.inner.period(input);
            self
        }
        /// <p>The time period that the amount applies to. A <code>weekly</code> period begins on Sunday. The default is <code>monthly</code>. </p>
        pub fn set_period(
            mut self,
            input: std::option::Option<crate::model::UsageLimitPeriod>,
        ) -> Self {
            self.inner = self.inner.set_period(input);
            self
        }
        /// <p>The action that Amazon Redshift takes when the limit is reached. The default is log. For more information about this parameter, see <code>UsageLimit</code>.</p>
        pub fn breach_action(mut self, input: crate::model::UsageLimitBreachAction) -> Self {
            self.inner = self.inner.breach_action(input);
            self
        }
        /// <p>The action that Amazon Redshift takes when the limit is reached. The default is log. For more information about this parameter, see <code>UsageLimit</code>.</p>
        pub fn set_breach_action(
            mut self,
            input: std::option::Option<crate::model::UsageLimitBreachAction>,
        ) -> Self {
            self.inner = self.inner.set_breach_action(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tag instances.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of tag instances.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeauthorizeDataShare`.
    ///
    /// <p>From the producer account, removes authorization from the specified datashare. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeauthorizeDataShare {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::deauthorize_data_share_input::Builder,
    }
    impl DeauthorizeDataShare {
        /// Creates a new `DeauthorizeDataShare`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeauthorizeDataShareOutput,
            aws_smithy_http::result::SdkError<crate::error::DeauthorizeDataShareError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the datashare to remove authorization from.</p>
        pub fn data_share_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_share_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the datashare to remove authorization from.</p>
        pub fn set_data_share_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_data_share_arn(input);
            self
        }
        /// <p>The identifier of the data consumer that is to have authorization removed from the datashare. This identifier is an Amazon Web Services account ID or a keyword, such as ADX.</p>
        pub fn consumer_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.consumer_identifier(input.into());
            self
        }
        /// <p>The identifier of the data consumer that is to have authorization removed from the datashare. This identifier is an Amazon Web Services account ID or a keyword, such as ADX.</p>
        pub fn set_consumer_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_consumer_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteAuthenticationProfile`.
    ///
    /// <p>Deletes an authentication profile.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteAuthenticationProfile {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_authentication_profile_input::Builder,
    }
    impl DeleteAuthenticationProfile {
        /// Creates a new `DeleteAuthenticationProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteAuthenticationProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteAuthenticationProfileError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the authentication profile to delete.</p>
        pub fn authentication_profile_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.authentication_profile_name(input.into());
            self
        }
        /// <p>The name of the authentication profile to delete.</p>
        pub fn set_authentication_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_authentication_profile_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteCluster`.
    ///
    /// <p>Deletes a previously provisioned cluster without its final snapshot being created. A successful response from the web service indicates that the request was received correctly. Use <code>DescribeClusters</code> to monitor the status of the deletion. The delete operation cannot be canceled or reverted once submitted. For more information about managing clusters, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html">Amazon Redshift Clusters</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</p>
    /// <p>If you want to shut down the cluster and retain it for future use, set <i>SkipFinalClusterSnapshot</i> to <code>false</code> and specify a name for <i>FinalClusterSnapshotIdentifier</i>. You can later restore this snapshot to resume using the cluster. If a final cluster snapshot is requested, the status of the cluster will be "final-snapshot" while the snapshot is being taken, then it's "deleting" once Amazon Redshift begins deleting the cluster. </p>
    /// <p> For more information about managing clusters, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html">Amazon Redshift Clusters</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteCluster {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_cluster_input::Builder,
    }
    impl DeleteCluster {
        /// Creates a new `DeleteCluster`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteClusterOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteClusterError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the cluster to be deleted.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must contain lowercase characters.</p> </li>
        /// <li> <p>Must contain from 1 to 63 alphanumeric characters or hyphens.</p> </li>
        /// <li> <p>First character must be a letter.</p> </li>
        /// <li> <p>Cannot end with a hyphen or contain two consecutive hyphens.</p> </li>
        /// </ul>
        pub fn cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_identifier(input.into());
            self
        }
        /// <p>The identifier of the cluster to be deleted.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must contain lowercase characters.</p> </li>
        /// <li> <p>Must contain from 1 to 63 alphanumeric characters or hyphens.</p> </li>
        /// <li> <p>First character must be a letter.</p> </li>
        /// <li> <p>Cannot end with a hyphen or contain two consecutive hyphens.</p> </li>
        /// </ul>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_identifier(input);
            self
        }
        /// <p>Determines whether a final snapshot of the cluster is created before Amazon Redshift deletes the cluster. If <code>true</code>, a final cluster snapshot is not created. If <code>false</code>, a final cluster snapshot is created before the cluster is deleted. </p> <note>
        /// <p>The <i>FinalClusterSnapshotIdentifier</i> parameter must be specified if <i>SkipFinalClusterSnapshot</i> is <code>false</code>.</p>
        /// </note>
        /// <p>Default: <code>false</code> </p>
        pub fn skip_final_cluster_snapshot(mut self, input: bool) -> Self {
            self.inner = self.inner.skip_final_cluster_snapshot(input);
            self
        }
        /// <p>Determines whether a final snapshot of the cluster is created before Amazon Redshift deletes the cluster. If <code>true</code>, a final cluster snapshot is not created. If <code>false</code>, a final cluster snapshot is created before the cluster is deleted. </p> <note>
        /// <p>The <i>FinalClusterSnapshotIdentifier</i> parameter must be specified if <i>SkipFinalClusterSnapshot</i> is <code>false</code>.</p>
        /// </note>
        /// <p>Default: <code>false</code> </p>
        pub fn set_skip_final_cluster_snapshot(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_skip_final_cluster_snapshot(input);
            self
        }
        /// <p>The identifier of the final snapshot that is to be created immediately before deleting the cluster. If this parameter is provided, <i>SkipFinalClusterSnapshot</i> must be <code>false</code>. </p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be 1 to 255 alphanumeric characters.</p> </li>
        /// <li> <p>First character must be a letter.</p> </li>
        /// <li> <p>Cannot end with a hyphen or contain two consecutive hyphens.</p> </li>
        /// </ul>
        pub fn final_cluster_snapshot_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.final_cluster_snapshot_identifier(input.into());
            self
        }
        /// <p>The identifier of the final snapshot that is to be created immediately before deleting the cluster. If this parameter is provided, <i>SkipFinalClusterSnapshot</i> must be <code>false</code>. </p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be 1 to 255 alphanumeric characters.</p> </li>
        /// <li> <p>First character must be a letter.</p> </li>
        /// <li> <p>Cannot end with a hyphen or contain two consecutive hyphens.</p> </li>
        /// </ul>
        pub fn set_final_cluster_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_final_cluster_snapshot_identifier(input);
            self
        }
        /// <p>The number of days that a manual snapshot is retained. If the value is -1, the manual snapshot is retained indefinitely.</p>
        /// <p>The value must be either -1 or an integer between 1 and 3,653.</p>
        /// <p>The default value is -1.</p>
        pub fn final_cluster_snapshot_retention_period(mut self, input: i32) -> Self {
            self.inner = self.inner.final_cluster_snapshot_retention_period(input);
            self
        }
        /// <p>The number of days that a manual snapshot is retained. If the value is -1, the manual snapshot is retained indefinitely.</p>
        /// <p>The value must be either -1 or an integer between 1 and 3,653.</p>
        /// <p>The default value is -1.</p>
        pub fn set_final_cluster_snapshot_retention_period(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.inner = self
                .inner
                .set_final_cluster_snapshot_retention_period(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteClusterParameterGroup`.
    ///
    /// <p>Deletes a specified Amazon Redshift parameter group.</p> <note>
    /// <p>You cannot delete a parameter group if it is associated with a cluster.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteClusterParameterGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_cluster_parameter_group_input::Builder,
    }
    impl DeleteClusterParameterGroup {
        /// Creates a new `DeleteClusterParameterGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteClusterParameterGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteClusterParameterGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the parameter group to be deleted.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be the name of an existing cluster parameter group.</p> </li>
        /// <li> <p>Cannot delete a default cluster parameter group.</p> </li>
        /// </ul>
        pub fn parameter_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.parameter_group_name(input.into());
            self
        }
        /// <p>The name of the parameter group to be deleted.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be the name of an existing cluster parameter group.</p> </li>
        /// <li> <p>Cannot delete a default cluster parameter group.</p> </li>
        /// </ul>
        pub fn set_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_parameter_group_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteClusterSecurityGroup`.
    ///
    /// <p>Deletes an Amazon Redshift security group.</p> <note>
    /// <p>You cannot delete a security group that is associated with any clusters. You cannot delete the default security group.</p>
    /// </note>
    /// <p> For information about managing security groups, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-security-groups.html">Amazon Redshift Cluster Security Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteClusterSecurityGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_cluster_security_group_input::Builder,
    }
    impl DeleteClusterSecurityGroup {
        /// Creates a new `DeleteClusterSecurityGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteClusterSecurityGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteClusterSecurityGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the cluster security group to be deleted.</p>
        pub fn cluster_security_group_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.cluster_security_group_name(input.into());
            self
        }
        /// <p>The name of the cluster security group to be deleted.</p>
        pub fn set_cluster_security_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_security_group_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteClusterSnapshot`.
    ///
    /// <p>Deletes the specified manual snapshot. The snapshot must be in the <code>available</code> state, with no other users authorized to access the snapshot. </p>
    /// <p>Unlike automated snapshots, manual snapshots are retained even after you delete your cluster. Amazon Redshift does not delete your manual snapshots. You must delete manual snapshot explicitly to avoid getting charged. If other accounts are authorized to access the snapshot, you must revoke all of the authorizations before you can delete the snapshot.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteClusterSnapshot {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_cluster_snapshot_input::Builder,
    }
    impl DeleteClusterSnapshot {
        /// Creates a new `DeleteClusterSnapshot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteClusterSnapshotOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteClusterSnapshotError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the manual snapshot to be deleted.</p>
        /// <p>Constraints: Must be the name of an existing snapshot that is in the <code>available</code>, <code>failed</code>, or <code>cancelled</code> state.</p>
        pub fn snapshot_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.snapshot_identifier(input.into());
            self
        }
        /// <p>The unique identifier of the manual snapshot to be deleted.</p>
        /// <p>Constraints: Must be the name of an existing snapshot that is in the <code>available</code>, <code>failed</code>, or <code>cancelled</code> state.</p>
        pub fn set_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_snapshot_identifier(input);
            self
        }
        /// <p>The unique identifier of the cluster the snapshot was created from. This parameter is required if your IAM user has a policy containing a snapshot resource element that specifies anything other than * for the cluster name.</p>
        /// <p>Constraints: Must be the name of valid cluster.</p>
        pub fn snapshot_cluster_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.snapshot_cluster_identifier(input.into());
            self
        }
        /// <p>The unique identifier of the cluster the snapshot was created from. This parameter is required if your IAM user has a policy containing a snapshot resource element that specifies anything other than * for the cluster name.</p>
        /// <p>Constraints: Must be the name of valid cluster.</p>
        pub fn set_snapshot_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_snapshot_cluster_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteClusterSubnetGroup`.
    ///
    /// <p>Deletes the specified cluster subnet group.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteClusterSubnetGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_cluster_subnet_group_input::Builder,
    }
    impl DeleteClusterSubnetGroup {
        /// Creates a new `DeleteClusterSubnetGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteClusterSubnetGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteClusterSubnetGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the cluster subnet group name to be deleted.</p>
        pub fn cluster_subnet_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_subnet_group_name(input.into());
            self
        }
        /// <p>The name of the cluster subnet group name to be deleted.</p>
        pub fn set_cluster_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_subnet_group_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteEndpointAccess`.
    ///
    /// <p>Deletes a Redshift-managed VPC endpoint.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteEndpointAccess {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_endpoint_access_input::Builder,
    }
    impl DeleteEndpointAccess {
        /// Creates a new `DeleteEndpointAccess`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteEndpointAccessOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteEndpointAccessError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Redshift-managed VPC endpoint to delete.</p>
        pub fn endpoint_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.endpoint_name(input.into());
            self
        }
        /// <p>The Redshift-managed VPC endpoint to delete.</p>
        pub fn set_endpoint_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_endpoint_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteEventSubscription`.
    ///
    /// <p>Deletes an Amazon Redshift event notification subscription.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteEventSubscription {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_event_subscription_input::Builder,
    }
    impl DeleteEventSubscription {
        /// Creates a new `DeleteEventSubscription`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteEventSubscriptionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteEventSubscriptionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the Amazon Redshift event notification subscription to be deleted.</p>
        pub fn subscription_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subscription_name(input.into());
            self
        }
        /// <p>The name of the Amazon Redshift event notification subscription to be deleted.</p>
        pub fn set_subscription_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_subscription_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteHsmClientCertificate`.
    ///
    /// <p>Deletes the specified HSM client certificate.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteHsmClientCertificate {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_hsm_client_certificate_input::Builder,
    }
    impl DeleteHsmClientCertificate {
        /// Creates a new `DeleteHsmClientCertificate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteHsmClientCertificateOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteHsmClientCertificateError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the HSM client certificate to be deleted.</p>
        pub fn hsm_client_certificate_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.hsm_client_certificate_identifier(input.into());
            self
        }
        /// <p>The identifier of the HSM client certificate to be deleted.</p>
        pub fn set_hsm_client_certificate_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_hsm_client_certificate_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteHsmConfiguration`.
    ///
    /// <p>Deletes the specified Amazon Redshift HSM configuration.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteHsmConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_hsm_configuration_input::Builder,
    }
    impl DeleteHsmConfiguration {
        /// Creates a new `DeleteHsmConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteHsmConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteHsmConfigurationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the Amazon Redshift HSM configuration to be deleted.</p>
        pub fn hsm_configuration_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.hsm_configuration_identifier(input.into());
            self
        }
        /// <p>The identifier of the Amazon Redshift HSM configuration to be deleted.</p>
        pub fn set_hsm_configuration_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_hsm_configuration_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeletePartner`.
    ///
    /// <p>Deletes a partner integration from a cluster. Data can still flow to the cluster until the integration is deleted at the partner's website.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeletePartner {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_partner_input::Builder,
    }
    impl DeletePartner {
        /// Creates a new `DeletePartner`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeletePartnerOutput,
            aws_smithy_http::result::SdkError<crate::error::DeletePartnerError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID that owns the cluster.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID that owns the cluster.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The cluster identifier of the cluster that receives data from the partner.</p>
        pub fn cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_identifier(input.into());
            self
        }
        /// <p>The cluster identifier of the cluster that receives data from the partner.</p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_identifier(input);
            self
        }
        /// <p>The name of the database that receives data from the partner.</p>
        pub fn database_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.database_name(input.into());
            self
        }
        /// <p>The name of the database that receives data from the partner.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_database_name(input);
            self
        }
        /// <p>The name of the partner that is authorized to send data.</p>
        pub fn partner_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.partner_name(input.into());
            self
        }
        /// <p>The name of the partner that is authorized to send data.</p>
        pub fn set_partner_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_partner_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteScheduledAction`.
    ///
    /// <p>Deletes a scheduled action. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteScheduledAction {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_scheduled_action_input::Builder,
    }
    impl DeleteScheduledAction {
        /// Creates a new `DeleteScheduledAction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteScheduledActionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteScheduledActionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the scheduled action to delete. </p>
        pub fn scheduled_action_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.scheduled_action_name(input.into());
            self
        }
        /// <p>The name of the scheduled action to delete. </p>
        pub fn set_scheduled_action_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_scheduled_action_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteSnapshotCopyGrant`.
    ///
    /// <p>Deletes the specified snapshot copy grant.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteSnapshotCopyGrant {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_snapshot_copy_grant_input::Builder,
    }
    impl DeleteSnapshotCopyGrant {
        /// Creates a new `DeleteSnapshotCopyGrant`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteSnapshotCopyGrantOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteSnapshotCopyGrantError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the snapshot copy grant to delete.</p>
        pub fn snapshot_copy_grant_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.snapshot_copy_grant_name(input.into());
            self
        }
        /// <p>The name of the snapshot copy grant to delete.</p>
        pub fn set_snapshot_copy_grant_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_snapshot_copy_grant_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteSnapshotSchedule`.
    ///
    /// <p>Deletes a snapshot schedule.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteSnapshotSchedule {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_snapshot_schedule_input::Builder,
    }
    impl DeleteSnapshotSchedule {
        /// Creates a new `DeleteSnapshotSchedule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteSnapshotScheduleOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteSnapshotScheduleError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique identifier of the snapshot schedule to delete.</p>
        pub fn schedule_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schedule_identifier(input.into());
            self
        }
        /// <p>A unique identifier of the snapshot schedule to delete.</p>
        pub fn set_schedule_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_schedule_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteTags`.
    ///
    /// <p>Deletes tags from a resource. You must provide the ARN of the resource from which you want to delete the tag or tags.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteTags {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_tags_input::Builder,
    }
    impl DeleteTags {
        /// Creates a new `DeleteTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteTagsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) from which you want to remove the tag or tags. For example, <code>arn:aws:redshift:us-east-2:123456789:cluster:t1</code>. </p>
        pub fn resource_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_name(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) from which you want to remove the tag or tags. For example, <code>arn:aws:redshift:us-east-2:123456789:cluster:t1</code>. </p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_name(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The tag key that you want to delete.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>The tag key that you want to delete.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteUsageLimit`.
    ///
    /// <p>Deletes a usage limit from a cluster.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteUsageLimit {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_usage_limit_input::Builder,
    }
    impl DeleteUsageLimit {
        /// Creates a new `DeleteUsageLimit`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteUsageLimitOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteUsageLimitError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the usage limit to delete.</p>
        pub fn usage_limit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.usage_limit_id(input.into());
            self
        }
        /// <p>The identifier of the usage limit to delete.</p>
        pub fn set_usage_limit_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_usage_limit_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAccountAttributes`.
    ///
    /// <p>Returns a list of attributes attached to an account</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeAccountAttributes {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_account_attributes_input::Builder,
    }
    impl DescribeAccountAttributes {
        /// Creates a new `DescribeAccountAttributes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAccountAttributesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAccountAttributesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `AttributeNames`.
        ///
        /// To override the contents of this collection use [`set_attribute_names`](Self::set_attribute_names).
        ///
        /// <p>A list of attribute names.</p>
        pub fn attribute_names(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.attribute_names(input.into());
            self
        }
        /// <p>A list of attribute names.</p>
        pub fn set_attribute_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_attribute_names(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeAuthenticationProfiles`.
    ///
    /// <p>Describes an authentication profile.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeAuthenticationProfiles {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_authentication_profiles_input::Builder,
    }
    impl DescribeAuthenticationProfiles {
        /// Creates a new `DescribeAuthenticationProfiles`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeAuthenticationProfilesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeAuthenticationProfilesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the authentication profile to describe. If not specified then all authentication profiles owned by the account are listed.</p>
        pub fn authentication_profile_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.authentication_profile_name(input.into());
            self
        }
        /// <p>The name of the authentication profile to describe. If not specified then all authentication profiles owned by the account are listed.</p>
        pub fn set_authentication_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_authentication_profile_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeClusterDbRevisions`.
    ///
    /// <p>Returns an array of <code>ClusterDbRevision</code> objects.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeClusterDbRevisions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_cluster_db_revisions_input::Builder,
    }
    impl DescribeClusterDbRevisions {
        /// Creates a new `DescribeClusterDbRevisions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeClusterDbRevisionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeClusterDbRevisionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeClusterDbRevisionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeClusterDbRevisionsPaginator {
            crate::paginator::DescribeClusterDbRevisionsPaginator::new(self.handle, self.inner)
        }
        /// <p>A unique identifier for a cluster whose <code>ClusterDbRevisions</code> you are requesting. This parameter is case sensitive. All clusters defined for an account are returned by default.</p>
        pub fn cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_identifier(input.into());
            self
        }
        /// <p>A unique identifier for a cluster whose <code>ClusterDbRevisions</code> you are requesting. This parameter is case sensitive. All clusters defined for an account are returned by default.</p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_identifier(input);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified MaxRecords value, a value is returned in the <code>marker</code> field of the response. You can retrieve the next set of response records by providing the returned <code>marker</code> value in the <code>marker</code> parameter and retrying the request. </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.inner = self.inner.max_records(input);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified MaxRecords value, a value is returned in the <code>marker</code> field of the response. You can retrieve the next set of response records by providing the returned <code>marker</code> value in the <code>marker</code> parameter and retrying the request. </p>
        /// <p>Default: 100</p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>An optional parameter that specifies the starting point for returning a set of response records. When the results of a <code>DescribeClusterDbRevisions</code> request exceed the value specified in <code>MaxRecords</code>, Amazon Redshift returns a value in the <code>marker</code> field of the response. You can retrieve the next set of response records by providing the returned <code>marker</code> value in the <code>marker</code> parameter and retrying the request. </p>
        /// <p>Constraints: You can specify either the <code>ClusterIdentifier</code> parameter, or the <code>marker</code> parameter, but not both.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>An optional parameter that specifies the starting point for returning a set of response records. When the results of a <code>DescribeClusterDbRevisions</code> request exceed the value specified in <code>MaxRecords</code>, Amazon Redshift returns a value in the <code>marker</code> field of the response. You can retrieve the next set of response records by providing the returned <code>marker</code> value in the <code>marker</code> parameter and retrying the request. </p>
        /// <p>Constraints: You can specify either the <code>ClusterIdentifier</code> parameter, or the <code>marker</code> parameter, but not both.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeClusterParameterGroups`.
    ///
    /// <p>Returns a list of Amazon Redshift parameter groups, including parameter groups you created and the default parameter group. For each parameter group, the response includes the parameter group name, description, and parameter group family name. You can optionally specify a name to retrieve the description of a specific parameter group.</p>
    /// <p> For more information about parameters and parameter groups, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Amazon Redshift Parameter Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</p>
    /// <p>If you specify both tag keys and tag values in the same request, Amazon Redshift returns all parameter groups that match any combination of the specified keys and values. For example, if you have <code>owner</code> and <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all parameter groups that have any combination of those values are returned.</p>
    /// <p>If both tag keys and values are omitted from the request, parameter groups are returned regardless of whether they have tag keys or values associated with them.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeClusterParameterGroups {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_cluster_parameter_groups_input::Builder,
    }
    impl DescribeClusterParameterGroups {
        /// Creates a new `DescribeClusterParameterGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeClusterParameterGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeClusterParameterGroupsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeClusterParameterGroupsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeClusterParameterGroupsPaginator {
            crate::paginator::DescribeClusterParameterGroupsPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of a specific parameter group for which to return details. By default, details about all parameter groups and the default parameter group are returned.</p>
        pub fn parameter_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.parameter_group_name(input.into());
            self
        }
        /// <p>The name of a specific parameter group for which to return details. By default, details about all parameter groups and the default parameter group are returned.</p>
        pub fn set_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_parameter_group_name(input);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>100</code> </p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.inner = self.inner.max_records(input);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>100</code> </p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <code>DescribeClusterParameterGroups</code> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <code>DescribeClusterParameterGroups</code> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A tag key or keys for which you want to return all matching cluster parameter groups that are associated with the specified key or keys. For example, suppose that you have parameter groups that are tagged with keys called <code>owner</code> and <code>environment</code>. If you specify both of these tag keys in the request, Amazon Redshift returns a response with the parameter groups that have either or both of these tag keys associated with them.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>A tag key or keys for which you want to return all matching cluster parameter groups that are associated with the specified key or keys. For example, suppose that you have parameter groups that are tagged with keys called <code>owner</code> and <code>environment</code>. If you specify both of these tag keys in the request, Amazon Redshift returns a response with the parameter groups that have either or both of these tag keys associated with them.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
        /// Appends an item to `TagValues`.
        ///
        /// To override the contents of this collection use [`set_tag_values`](Self::set_tag_values).
        ///
        /// <p>A tag value or values for which you want to return all matching cluster parameter groups that are associated with the specified tag value or values. For example, suppose that you have parameter groups that are tagged with values called <code>admin</code> and <code>test</code>. If you specify both of these tag values in the request, Amazon Redshift returns a response with the parameter groups that have either or both of these tag values associated with them.</p>
        pub fn tag_values(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_values(input.into());
            self
        }
        /// <p>A tag value or values for which you want to return all matching cluster parameter groups that are associated with the specified tag value or values. For example, suppose that you have parameter groups that are tagged with values called <code>admin</code> and <code>test</code>. If you specify both of these tag values in the request, Amazon Redshift returns a response with the parameter groups that have either or both of these tag values associated with them.</p>
        pub fn set_tag_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_values(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeClusterParameters`.
    ///
    /// <p>Returns a detailed list of parameters contained within the specified Amazon Redshift parameter group. For each parameter the response includes information such as parameter name, description, data type, value, whether the parameter value is modifiable, and so on.</p>
    /// <p>You can specify <i>source</i> filter to retrieve parameters of only specific type. For example, to retrieve parameters that were modified by a user action such as from <code>ModifyClusterParameterGroup</code>, you can specify <i>source</i> equal to <i>user</i>.</p>
    /// <p> For more information about parameters and parameter groups, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Amazon Redshift Parameter Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeClusterParameters {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_cluster_parameters_input::Builder,
    }
    impl DescribeClusterParameters {
        /// Creates a new `DescribeClusterParameters`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeClusterParametersOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeClusterParametersError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeClusterParametersPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeClusterParametersPaginator {
            crate::paginator::DescribeClusterParametersPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of a cluster parameter group for which to return details.</p>
        pub fn parameter_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.parameter_group_name(input.into());
            self
        }
        /// <p>The name of a cluster parameter group for which to return details.</p>
        pub fn set_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_parameter_group_name(input);
            self
        }
        /// <p>The parameter types to return. Specify <code>user</code> to show parameters that are different form the default. Similarly, specify <code>engine-default</code> to show parameters that are the same as the default parameter group. </p>
        /// <p>Default: All parameter types returned.</p>
        /// <p>Valid Values: <code>user</code> | <code>engine-default</code> </p>
        pub fn source(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source(input.into());
            self
        }
        /// <p>The parameter types to return. Specify <code>user</code> to show parameters that are different form the default. Similarly, specify <code>engine-default</code> to show parameters that are the same as the default parameter group. </p>
        /// <p>Default: All parameter types returned.</p>
        /// <p>Valid Values: <code>user</code> | <code>engine-default</code> </p>
        pub fn set_source(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_source(input);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>100</code> </p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.inner = self.inner.max_records(input);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>100</code> </p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <code>DescribeClusterParameters</code> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <code>DescribeClusterParameters</code> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeClusters`.
    ///
    /// <p>Returns properties of provisioned clusters including general cluster properties, cluster database properties, maintenance and backup properties, and security and access properties. This operation supports pagination. For more information about managing clusters, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html">Amazon Redshift Clusters</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</p>
    /// <p>If you specify both tag keys and tag values in the same request, Amazon Redshift returns all clusters that match any combination of the specified keys and values. For example, if you have <code>owner</code> and <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all clusters that have any combination of those values are returned.</p>
    /// <p>If both tag keys and values are omitted from the request, clusters are returned regardless of whether they have tag keys or values associated with them.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeClusters {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_clusters_input::Builder,
    }
    impl DescribeClusters {
        /// Creates a new `DescribeClusters`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeClustersOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeClustersError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeClustersPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeClustersPaginator {
            crate::paginator::DescribeClustersPaginator::new(self.handle, self.inner)
        }
        /// <p>The unique identifier of a cluster whose properties you are requesting. This parameter is case sensitive.</p>
        /// <p>The default is that all clusters defined for an account are returned.</p>
        pub fn cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_identifier(input.into());
            self
        }
        /// <p>The unique identifier of a cluster whose properties you are requesting. This parameter is case sensitive.</p>
        /// <p>The default is that all clusters defined for an account are returned.</p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_identifier(input);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>100</code> </p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.inner = self.inner.max_records(input);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>100</code> </p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <code>DescribeClusters</code> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
        /// <p>Constraints: You can specify either the <b>ClusterIdentifier</b> parameter or the <b>Marker</b> parameter, but not both. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <code>DescribeClusters</code> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
        /// <p>Constraints: You can specify either the <b>ClusterIdentifier</b> parameter or the <b>Marker</b> parameter, but not both. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A tag key or keys for which you want to return all matching clusters that are associated with the specified key or keys. For example, suppose that you have clusters that are tagged with keys called <code>owner</code> and <code>environment</code>. If you specify both of these tag keys in the request, Amazon Redshift returns a response with the clusters that have either or both of these tag keys associated with them.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>A tag key or keys for which you want to return all matching clusters that are associated with the specified key or keys. For example, suppose that you have clusters that are tagged with keys called <code>owner</code> and <code>environment</code>. If you specify both of these tag keys in the request, Amazon Redshift returns a response with the clusters that have either or both of these tag keys associated with them.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
        /// Appends an item to `TagValues`.
        ///
        /// To override the contents of this collection use [`set_tag_values`](Self::set_tag_values).
        ///
        /// <p>A tag value or values for which you want to return all matching clusters that are associated with the specified tag value or values. For example, suppose that you have clusters that are tagged with values called <code>admin</code> and <code>test</code>. If you specify both of these tag values in the request, Amazon Redshift returns a response with the clusters that have either or both of these tag values associated with them.</p>
        pub fn tag_values(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_values(input.into());
            self
        }
        /// <p>A tag value or values for which you want to return all matching clusters that are associated with the specified tag value or values. For example, suppose that you have clusters that are tagged with values called <code>admin</code> and <code>test</code>. If you specify both of these tag values in the request, Amazon Redshift returns a response with the clusters that have either or both of these tag values associated with them.</p>
        pub fn set_tag_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_values(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeClusterSecurityGroups`.
    ///
    /// <p>Returns information about Amazon Redshift security groups. If the name of a security group is specified, the response will contain only information about only that security group.</p>
    /// <p> For information about managing security groups, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-security-groups.html">Amazon Redshift Cluster Security Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</p>
    /// <p>If you specify both tag keys and tag values in the same request, Amazon Redshift returns all security groups that match any combination of the specified keys and values. For example, if you have <code>owner</code> and <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all security groups that have any combination of those values are returned.</p>
    /// <p>If both tag keys and values are omitted from the request, security groups are returned regardless of whether they have tag keys or values associated with them.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeClusterSecurityGroups {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_cluster_security_groups_input::Builder,
    }
    impl DescribeClusterSecurityGroups {
        /// Creates a new `DescribeClusterSecurityGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeClusterSecurityGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeClusterSecurityGroupsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeClusterSecurityGroupsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeClusterSecurityGroupsPaginator {
            crate::paginator::DescribeClusterSecurityGroupsPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of a cluster security group for which you are requesting details. You can specify either the <b>Marker</b> parameter or a <b>ClusterSecurityGroupName</b> parameter, but not both. </p>
        /// <p> Example: <code>securitygroup1</code> </p>
        pub fn cluster_security_group_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.cluster_security_group_name(input.into());
            self
        }
        /// <p>The name of a cluster security group for which you are requesting details. You can specify either the <b>Marker</b> parameter or a <b>ClusterSecurityGroupName</b> parameter, but not both. </p>
        /// <p> Example: <code>securitygroup1</code> </p>
        pub fn set_cluster_security_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_security_group_name(input);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>100</code> </p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.inner = self.inner.max_records(input);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>100</code> </p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <code>DescribeClusterSecurityGroups</code> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
        /// <p>Constraints: You can specify either the <b>ClusterSecurityGroupName</b> parameter or the <b>Marker</b> parameter, but not both. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <code>DescribeClusterSecurityGroups</code> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
        /// <p>Constraints: You can specify either the <b>ClusterSecurityGroupName</b> parameter or the <b>Marker</b> parameter, but not both. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A tag key or keys for which you want to return all matching cluster security groups that are associated with the specified key or keys. For example, suppose that you have security groups that are tagged with keys called <code>owner</code> and <code>environment</code>. If you specify both of these tag keys in the request, Amazon Redshift returns a response with the security groups that have either or both of these tag keys associated with them.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>A tag key or keys for which you want to return all matching cluster security groups that are associated with the specified key or keys. For example, suppose that you have security groups that are tagged with keys called <code>owner</code> and <code>environment</code>. If you specify both of these tag keys in the request, Amazon Redshift returns a response with the security groups that have either or both of these tag keys associated with them.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
        /// Appends an item to `TagValues`.
        ///
        /// To override the contents of this collection use [`set_tag_values`](Self::set_tag_values).
        ///
        /// <p>A tag value or values for which you want to return all matching cluster security groups that are associated with the specified tag value or values. For example, suppose that you have security groups that are tagged with values called <code>admin</code> and <code>test</code>. If you specify both of these tag values in the request, Amazon Redshift returns a response with the security groups that have either or both of these tag values associated with them.</p>
        pub fn tag_values(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_values(input.into());
            self
        }
        /// <p>A tag value or values for which you want to return all matching cluster security groups that are associated with the specified tag value or values. For example, suppose that you have security groups that are tagged with values called <code>admin</code> and <code>test</code>. If you specify both of these tag values in the request, Amazon Redshift returns a response with the security groups that have either or both of these tag values associated with them.</p>
        pub fn set_tag_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_values(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeClusterSnapshots`.
    ///
    /// <p>Returns one or more snapshot objects, which contain metadata about your cluster snapshots. By default, this operation returns information about all snapshots of all clusters that are owned by your Amazon Web Services account. No information is returned for snapshots owned by inactive Amazon Web Services accounts.</p>
    /// <p>If you specify both tag keys and tag values in the same request, Amazon Redshift returns all snapshots that match any combination of the specified keys and values. For example, if you have <code>owner</code> and <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all snapshots that have any combination of those values are returned. Only snapshots that you own are returned in the response; shared snapshots are not returned with the tag key and tag value request parameters.</p>
    /// <p>If both tag keys and values are omitted from the request, snapshots are returned regardless of whether they have tag keys or values associated with them.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeClusterSnapshots {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_cluster_snapshots_input::Builder,
    }
    impl DescribeClusterSnapshots {
        /// Creates a new `DescribeClusterSnapshots`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeClusterSnapshotsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeClusterSnapshotsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeClusterSnapshotsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeClusterSnapshotsPaginator {
            crate::paginator::DescribeClusterSnapshotsPaginator::new(self.handle, self.inner)
        }
        /// <p>The identifier of the cluster which generated the requested snapshots.</p>
        pub fn cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_identifier(input.into());
            self
        }
        /// <p>The identifier of the cluster which generated the requested snapshots.</p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_identifier(input);
            self
        }
        /// <p>The snapshot identifier of the snapshot about which to return information.</p>
        pub fn snapshot_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.snapshot_identifier(input.into());
            self
        }
        /// <p>The snapshot identifier of the snapshot about which to return information.</p>
        pub fn set_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_snapshot_identifier(input);
            self
        }
        /// <p>The type of snapshots for which you are requesting information. By default, snapshots of all types are returned.</p>
        /// <p>Valid Values: <code>automated</code> | <code>manual</code> </p>
        pub fn snapshot_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.snapshot_type(input.into());
            self
        }
        /// <p>The type of snapshots for which you are requesting information. By default, snapshots of all types are returned.</p>
        /// <p>Valid Values: <code>automated</code> | <code>manual</code> </p>
        pub fn set_snapshot_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_snapshot_type(input);
            self
        }
        /// <p>A value that requests only snapshots created at or after the specified time. The time value is specified in ISO 8601 format. For more information about ISO 8601, go to the <a href="http://en.wikipedia.org/wiki/ISO_8601">ISO8601 Wikipedia page.</a> </p>
        /// <p>Example: <code>2012-07-16T18:00:00Z</code> </p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.start_time(input);
            self
        }
        /// <p>A value that requests only snapshots created at or after the specified time. The time value is specified in ISO 8601 format. For more information about ISO 8601, go to the <a href="http://en.wikipedia.org/wiki/ISO_8601">ISO8601 Wikipedia page.</a> </p>
        /// <p>Example: <code>2012-07-16T18:00:00Z</code> </p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_start_time(input);
            self
        }
        /// <p>A time value that requests only snapshots created at or before the specified time. The time value is specified in ISO 8601 format. For more information about ISO 8601, go to the <a href="http://en.wikipedia.org/wiki/ISO_8601">ISO8601 Wikipedia page.</a> </p>
        /// <p>Example: <code>2012-07-16T18:00:00Z</code> </p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.end_time(input);
            self
        }
        /// <p>A time value that requests only snapshots created at or before the specified time. The time value is specified in ISO 8601 format. For more information about ISO 8601, go to the <a href="http://en.wikipedia.org/wiki/ISO_8601">ISO8601 Wikipedia page.</a> </p>
        /// <p>Example: <code>2012-07-16T18:00:00Z</code> </p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_end_time(input);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>100</code> </p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.inner = self.inner.max_records(input);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>100</code> </p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <code>DescribeClusterSnapshots</code> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <code>DescribeClusterSnapshots</code> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>The Amazon Web Services account used to create or copy the snapshot. Use this field to filter the results to snapshots owned by a particular account. To describe snapshots you own, either specify your Amazon Web Services account, or do not specify the parameter.</p>
        pub fn owner_account(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.owner_account(input.into());
            self
        }
        /// <p>The Amazon Web Services account used to create or copy the snapshot. Use this field to filter the results to snapshots owned by a particular account. To describe snapshots you own, either specify your Amazon Web Services account, or do not specify the parameter.</p>
        pub fn set_owner_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_owner_account(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A tag key or keys for which you want to return all matching cluster snapshots that are associated with the specified key or keys. For example, suppose that you have snapshots that are tagged with keys called <code>owner</code> and <code>environment</code>. If you specify both of these tag keys in the request, Amazon Redshift returns a response with the snapshots that have either or both of these tag keys associated with them.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>A tag key or keys for which you want to return all matching cluster snapshots that are associated with the specified key or keys. For example, suppose that you have snapshots that are tagged with keys called <code>owner</code> and <code>environment</code>. If you specify both of these tag keys in the request, Amazon Redshift returns a response with the snapshots that have either or both of these tag keys associated with them.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
        /// Appends an item to `TagValues`.
        ///
        /// To override the contents of this collection use [`set_tag_values`](Self::set_tag_values).
        ///
        /// <p>A tag value or values for which you want to return all matching cluster snapshots that are associated with the specified tag value or values. For example, suppose that you have snapshots that are tagged with values called <code>admin</code> and <code>test</code>. If you specify both of these tag values in the request, Amazon Redshift returns a response with the snapshots that have either or both of these tag values associated with them.</p>
        pub fn tag_values(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_values(input.into());
            self
        }
        /// <p>A tag value or values for which you want to return all matching cluster snapshots that are associated with the specified tag value or values. For example, suppose that you have snapshots that are tagged with values called <code>admin</code> and <code>test</code>. If you specify both of these tag values in the request, Amazon Redshift returns a response with the snapshots that have either or both of these tag values associated with them.</p>
        pub fn set_tag_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_values(input);
            self
        }
        /// <p>A value that indicates whether to return snapshots only for an existing cluster. You can perform table-level restore only by using a snapshot of an existing cluster, that is, a cluster that has not been deleted. Values for this parameter work as follows: </p>
        /// <ul>
        /// <li> <p>If <code>ClusterExists</code> is set to <code>true</code>, <code>ClusterIdentifier</code> is required.</p> </li>
        /// <li> <p>If <code>ClusterExists</code> is set to <code>false</code> and <code>ClusterIdentifier</code> isn't specified, all snapshots associated with deleted clusters (orphaned snapshots) are returned. </p> </li>
        /// <li> <p>If <code>ClusterExists</code> is set to <code>false</code> and <code>ClusterIdentifier</code> is specified for a deleted cluster, snapshots associated with that cluster are returned.</p> </li>
        /// <li> <p>If <code>ClusterExists</code> is set to <code>false</code> and <code>ClusterIdentifier</code> is specified for an existing cluster, no snapshots are returned. </p> </li>
        /// </ul>
        pub fn cluster_exists(mut self, input: bool) -> Self {
            self.inner = self.inner.cluster_exists(input);
            self
        }
        /// <p>A value that indicates whether to return snapshots only for an existing cluster. You can perform table-level restore only by using a snapshot of an existing cluster, that is, a cluster that has not been deleted. Values for this parameter work as follows: </p>
        /// <ul>
        /// <li> <p>If <code>ClusterExists</code> is set to <code>true</code>, <code>ClusterIdentifier</code> is required.</p> </li>
        /// <li> <p>If <code>ClusterExists</code> is set to <code>false</code> and <code>ClusterIdentifier</code> isn't specified, all snapshots associated with deleted clusters (orphaned snapshots) are returned. </p> </li>
        /// <li> <p>If <code>ClusterExists</code> is set to <code>false</code> and <code>ClusterIdentifier</code> is specified for a deleted cluster, snapshots associated with that cluster are returned.</p> </li>
        /// <li> <p>If <code>ClusterExists</code> is set to <code>false</code> and <code>ClusterIdentifier</code> is specified for an existing cluster, no snapshots are returned. </p> </li>
        /// </ul>
        pub fn set_cluster_exists(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_cluster_exists(input);
            self
        }
        /// Appends an item to `SortingEntities`.
        ///
        /// To override the contents of this collection use [`set_sorting_entities`](Self::set_sorting_entities).
        ///
        /// <p></p>
        pub fn sorting_entities(mut self, input: crate::model::SnapshotSortingEntity) -> Self {
            self.inner = self.inner.sorting_entities(input);
            self
        }
        /// <p></p>
        pub fn set_sorting_entities(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SnapshotSortingEntity>>,
        ) -> Self {
            self.inner = self.inner.set_sorting_entities(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeClusterSubnetGroups`.
    ///
    /// <p>Returns one or more cluster subnet group objects, which contain metadata about your cluster subnet groups. By default, this operation returns information about all cluster subnet groups that are defined in your Amazon Web Services account.</p>
    /// <p>If you specify both tag keys and tag values in the same request, Amazon Redshift returns all subnet groups that match any combination of the specified keys and values. For example, if you have <code>owner</code> and <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all subnet groups that have any combination of those values are returned.</p>
    /// <p>If both tag keys and values are omitted from the request, subnet groups are returned regardless of whether they have tag keys or values associated with them.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeClusterSubnetGroups {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_cluster_subnet_groups_input::Builder,
    }
    impl DescribeClusterSubnetGroups {
        /// Creates a new `DescribeClusterSubnetGroups`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeClusterSubnetGroupsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeClusterSubnetGroupsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeClusterSubnetGroupsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeClusterSubnetGroupsPaginator {
            crate::paginator::DescribeClusterSubnetGroupsPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of the cluster subnet group for which information is requested.</p>
        pub fn cluster_subnet_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_subnet_group_name(input.into());
            self
        }
        /// <p>The name of the cluster subnet group for which information is requested.</p>
        pub fn set_cluster_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_subnet_group_name(input);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>100</code> </p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.inner = self.inner.max_records(input);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>100</code> </p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <code>DescribeClusterSubnetGroups</code> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <code>DescribeClusterSubnetGroups</code> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A tag key or keys for which you want to return all matching cluster subnet groups that are associated with the specified key or keys. For example, suppose that you have subnet groups that are tagged with keys called <code>owner</code> and <code>environment</code>. If you specify both of these tag keys in the request, Amazon Redshift returns a response with the subnet groups that have either or both of these tag keys associated with them.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>A tag key or keys for which you want to return all matching cluster subnet groups that are associated with the specified key or keys. For example, suppose that you have subnet groups that are tagged with keys called <code>owner</code> and <code>environment</code>. If you specify both of these tag keys in the request, Amazon Redshift returns a response with the subnet groups that have either or both of these tag keys associated with them.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
        /// Appends an item to `TagValues`.
        ///
        /// To override the contents of this collection use [`set_tag_values`](Self::set_tag_values).
        ///
        /// <p>A tag value or values for which you want to return all matching cluster subnet groups that are associated with the specified tag value or values. For example, suppose that you have subnet groups that are tagged with values called <code>admin</code> and <code>test</code>. If you specify both of these tag values in the request, Amazon Redshift returns a response with the subnet groups that have either or both of these tag values associated with them.</p>
        pub fn tag_values(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_values(input.into());
            self
        }
        /// <p>A tag value or values for which you want to return all matching cluster subnet groups that are associated with the specified tag value or values. For example, suppose that you have subnet groups that are tagged with values called <code>admin</code> and <code>test</code>. If you specify both of these tag values in the request, Amazon Redshift returns a response with the subnet groups that have either or both of these tag values associated with them.</p>
        pub fn set_tag_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_values(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeClusterTracks`.
    ///
    /// <p>Returns a list of all the available maintenance tracks.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeClusterTracks {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_cluster_tracks_input::Builder,
    }
    impl DescribeClusterTracks {
        /// Creates a new `DescribeClusterTracks`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeClusterTracksOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeClusterTracksError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeClusterTracksPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeClusterTracksPaginator {
            crate::paginator::DescribeClusterTracksPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of the maintenance track. </p>
        pub fn maintenance_track_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.maintenance_track_name(input.into());
            self
        }
        /// <p>The name of the maintenance track. </p>
        pub fn set_maintenance_track_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_maintenance_track_name(input);
            self
        }
        /// <p>An integer value for the maximum number of maintenance tracks to return.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.inner = self.inner.max_records(input);
            self
        }
        /// <p>An integer value for the maximum number of maintenance tracks to return.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <code>DescribeClusterTracks</code> request exceed the value specified in <code>MaxRecords</code>, Amazon Redshift returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <code>DescribeClusterTracks</code> request exceed the value specified in <code>MaxRecords</code>, Amazon Redshift returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeClusterVersions`.
    ///
    /// <p>Returns descriptions of the available Amazon Redshift cluster versions. You can call this operation even before creating any clusters to learn more about the Amazon Redshift versions. For more information about managing clusters, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html">Amazon Redshift Clusters</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeClusterVersions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_cluster_versions_input::Builder,
    }
    impl DescribeClusterVersions {
        /// Creates a new `DescribeClusterVersions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeClusterVersionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeClusterVersionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeClusterVersionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeClusterVersionsPaginator {
            crate::paginator::DescribeClusterVersionsPaginator::new(self.handle, self.inner)
        }
        /// <p>The specific cluster version to return.</p>
        /// <p>Example: <code>1.0</code> </p>
        pub fn cluster_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_version(input.into());
            self
        }
        /// <p>The specific cluster version to return.</p>
        /// <p>Example: <code>1.0</code> </p>
        pub fn set_cluster_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_version(input);
            self
        }
        /// <p>The name of a specific cluster parameter group family to return details for.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be 1 to 255 alphanumeric characters</p> </li>
        /// <li> <p>First character must be a letter</p> </li>
        /// <li> <p>Cannot end with a hyphen or contain two consecutive hyphens</p> </li>
        /// </ul>
        pub fn cluster_parameter_group_family(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.cluster_parameter_group_family(input.into());
            self
        }
        /// <p>The name of a specific cluster parameter group family to return details for.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be 1 to 255 alphanumeric characters</p> </li>
        /// <li> <p>First character must be a letter</p> </li>
        /// <li> <p>Cannot end with a hyphen or contain two consecutive hyphens</p> </li>
        /// </ul>
        pub fn set_cluster_parameter_group_family(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_parameter_group_family(input);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>100</code> </p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.inner = self.inner.max_records(input);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>100</code> </p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <code>DescribeClusterVersions</code> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <code>DescribeClusterVersions</code> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDataShares`.
    ///
    /// <p>Shows the status of any inbound or outbound datashares available in the specified account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeDataShares {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_data_shares_input::Builder,
    }
    impl DescribeDataShares {
        /// Creates a new `DescribeDataShares`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDataSharesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDataSharesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeDataSharesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeDataSharesPaginator {
            crate::paginator::DescribeDataSharesPaginator::new(self.handle, self.inner)
        }
        /// <p>The identifier of the datashare to describe details of.</p>
        pub fn data_share_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_share_arn(input.into());
            self
        }
        /// <p>The identifier of the datashare to describe details of.</p>
        pub fn set_data_share_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_data_share_arn(input);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. </p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.inner = self.inner.max_records(input);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. </p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <code>DescribeDataShares</code> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <code>DescribeDataShares</code> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDataSharesForConsumer`.
    ///
    /// <p>Returns a list of datashares where the account identifier being called is a consumer account identifier.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeDataSharesForConsumer {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_data_shares_for_consumer_input::Builder,
    }
    impl DescribeDataSharesForConsumer {
        /// Creates a new `DescribeDataSharesForConsumer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDataSharesForConsumerOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDataSharesForConsumerError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeDataSharesForConsumerPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeDataSharesForConsumerPaginator {
            crate::paginator::DescribeDataSharesForConsumerPaginator::new(self.handle, self.inner)
        }
        /// <p>The Amazon Resource Name (ARN) of the consumer that returns in the list of datashares.</p>
        pub fn consumer_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.consumer_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the consumer that returns in the list of datashares.</p>
        pub fn set_consumer_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_consumer_arn(input);
            self
        }
        /// <p>An identifier giving the status of a datashare in the consumer cluster. If this field is specified, Amazon Redshift returns the list of datashares that have the specified status.</p>
        pub fn status(mut self, input: crate::model::DataShareStatusForConsumer) -> Self {
            self.inner = self.inner.status(input);
            self
        }
        /// <p>An identifier giving the status of a datashare in the consumer cluster. If this field is specified, Amazon Redshift returns the list of datashares that have the specified status.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::DataShareStatusForConsumer>,
        ) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. </p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.inner = self.inner.max_records(input);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. </p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <code>DescribeDataSharesForConsumer</code> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <code>DescribeDataSharesForConsumer</code> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDataSharesForProducer`.
    ///
    /// <p>Returns a list of datashares when the account identifier being called is a producer account identifier.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeDataSharesForProducer {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_data_shares_for_producer_input::Builder,
    }
    impl DescribeDataSharesForProducer {
        /// Creates a new `DescribeDataSharesForProducer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDataSharesForProducerOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDataSharesForProducerError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeDataSharesForProducerPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeDataSharesForProducerPaginator {
            crate::paginator::DescribeDataSharesForProducerPaginator::new(self.handle, self.inner)
        }
        /// <p>The Amazon Resource Name (ARN) of the producer that returns in the list of datashares.</p>
        pub fn producer_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.producer_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the producer that returns in the list of datashares.</p>
        pub fn set_producer_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_producer_arn(input);
            self
        }
        /// <p>An identifier giving the status of a datashare in the producer. If this field is specified, Amazon Redshift returns the list of datashares that have the specified status.</p>
        pub fn status(mut self, input: crate::model::DataShareStatusForProducer) -> Self {
            self.inner = self.inner.status(input);
            self
        }
        /// <p>An identifier giving the status of a datashare in the producer. If this field is specified, Amazon Redshift returns the list of datashares that have the specified status.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::DataShareStatusForProducer>,
        ) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. </p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.inner = self.inner.max_records(input);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. </p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <code>DescribeDataSharesForProducer</code> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <code>DescribeDataSharesForProducer</code> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDefaultClusterParameters`.
    ///
    /// <p>Returns a list of parameter settings for the specified parameter group family.</p>
    /// <p> For more information about parameters and parameter groups, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Amazon Redshift Parameter Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeDefaultClusterParameters {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_default_cluster_parameters_input::Builder,
    }
    impl DescribeDefaultClusterParameters {
        /// Creates a new `DescribeDefaultClusterParameters`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDefaultClusterParametersOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDefaultClusterParametersError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeDefaultClusterParametersPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeDefaultClusterParametersPaginator {
            crate::paginator::DescribeDefaultClusterParametersPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p>The name of the cluster parameter group family.</p>
        pub fn parameter_group_family(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.parameter_group_family(input.into());
            self
        }
        /// <p>The name of the cluster parameter group family.</p>
        pub fn set_parameter_group_family(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_parameter_group_family(input);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>100</code> </p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.inner = self.inner.max_records(input);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>100</code> </p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <code>DescribeDefaultClusterParameters</code> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <code>DescribeDefaultClusterParameters</code> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEndpointAccess`.
    ///
    /// <p>Describes a Redshift-managed VPC endpoint.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeEndpointAccess {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_endpoint_access_input::Builder,
    }
    impl DescribeEndpointAccess {
        /// Creates a new `DescribeEndpointAccess`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEndpointAccessOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeEndpointAccessError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeEndpointAccessPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeEndpointAccessPaginator {
            crate::paginator::DescribeEndpointAccessPaginator::new(self.handle, self.inner)
        }
        /// <p>The cluster identifier associated with the described endpoint.</p>
        pub fn cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_identifier(input.into());
            self
        }
        /// <p>The cluster identifier associated with the described endpoint.</p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_identifier(input);
            self
        }
        /// <p>The Amazon Web Services account ID of the owner of the cluster.</p>
        pub fn resource_owner(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_owner(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID of the owner of the cluster.</p>
        pub fn set_resource_owner(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_owner(input);
            self
        }
        /// <p>The name of the endpoint to be described.</p>
        pub fn endpoint_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.endpoint_name(input.into());
            self
        }
        /// <p>The name of the endpoint to be described.</p>
        pub fn set_endpoint_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_endpoint_name(input);
            self
        }
        /// <p>The virtual private cloud (VPC) identifier with access to the cluster.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc_id(input.into());
            self
        }
        /// <p>The virtual private cloud (VPC) identifier with access to the cluster.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_vpc_id(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a <code>Marker</code> is included in the response so that the remaining results can be retrieved.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.inner = self.inner.max_records(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a <code>Marker</code> is included in the response so that the remaining results can be retrieved.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>An optional pagination token provided by a previous <code>DescribeEndpointAccess</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by the <code>MaxRecords</code> parameter.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>An optional pagination token provided by a previous <code>DescribeEndpointAccess</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by the <code>MaxRecords</code> parameter.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEndpointAuthorization`.
    ///
    /// <p>Describes an endpoint authorization.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeEndpointAuthorization {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_endpoint_authorization_input::Builder,
    }
    impl DescribeEndpointAuthorization {
        /// Creates a new `DescribeEndpointAuthorization`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEndpointAuthorizationOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeEndpointAuthorizationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeEndpointAuthorizationPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeEndpointAuthorizationPaginator {
            crate::paginator::DescribeEndpointAuthorizationPaginator::new(self.handle, self.inner)
        }
        /// <p>The cluster identifier of the cluster to access.</p>
        pub fn cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_identifier(input.into());
            self
        }
        /// <p>The cluster identifier of the cluster to access.</p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_identifier(input);
            self
        }
        /// <p>The AAmazon Web Services account ID of either the cluster owner (grantor) or grantee. If <code>Grantee</code> parameter is true, then the <code>Account</code> value is of the grantor.</p>
        pub fn account(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account(input.into());
            self
        }
        /// <p>The AAmazon Web Services account ID of either the cluster owner (grantor) or grantee. If <code>Grantee</code> parameter is true, then the <code>Account</code> value is of the grantor.</p>
        pub fn set_account(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account(input);
            self
        }
        /// <p>Indicates whether to check authorization from a grantor or grantee point of view. If true, Amazon Redshift returns endpoint authorizations that you've been granted. If false (default), checks authorization from a grantor point of view.</p>
        pub fn grantee(mut self, input: bool) -> Self {
            self.inner = self.inner.grantee(input);
            self
        }
        /// <p>Indicates whether to check authorization from a grantor or grantee point of view. If true, Amazon Redshift returns endpoint authorizations that you've been granted. If false (default), checks authorization from a grantor point of view.</p>
        pub fn set_grantee(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_grantee(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a <code>Marker</code> is included in the response so that the remaining results can be retrieved.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.inner = self.inner.max_records(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a <code>Marker</code> is included in the response so that the remaining results can be retrieved.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>An optional pagination token provided by a previous <code>DescribeEndpointAuthorization</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by the <code>MaxRecords</code> parameter.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>An optional pagination token provided by a previous <code>DescribeEndpointAuthorization</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by the <code>MaxRecords</code> parameter.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEventCategories`.
    ///
    /// <p>Displays a list of event categories for all event source types, or for a specified source type. For a list of the event categories and source types, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-event-notifications.html">Amazon Redshift Event Notifications</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeEventCategories {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_event_categories_input::Builder,
    }
    impl DescribeEventCategories {
        /// Creates a new `DescribeEventCategories`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEventCategoriesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeEventCategoriesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The source type, such as cluster or parameter group, to which the described event categories apply.</p>
        /// <p>Valid values: cluster, cluster-snapshot, cluster-parameter-group, cluster-security-group, and scheduled-action.</p>
        pub fn source_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_type(input.into());
            self
        }
        /// <p>The source type, such as cluster or parameter group, to which the described event categories apply.</p>
        /// <p>Valid values: cluster, cluster-snapshot, cluster-parameter-group, cluster-security-group, and scheduled-action.</p>
        pub fn set_source_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_source_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEvents`.
    ///
    /// <p>Returns events related to clusters, security groups, snapshots, and parameter groups for the past 14 days. Events specific to a particular cluster, security group, snapshot or parameter group can be obtained by providing the name as a parameter. By default, the past hour of events are returned.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeEvents {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_events_input::Builder,
    }
    impl DescribeEvents {
        /// Creates a new `DescribeEvents`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEventsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeEventsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeEventsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeEventsPaginator {
            crate::paginator::DescribeEventsPaginator::new(self.handle, self.inner)
        }
        /// <p>The identifier of the event source for which events will be returned. If this parameter is not specified, then all sources are included in the response.</p>
        /// <p>Constraints:</p>
        /// <p>If <i>SourceIdentifier</i> is supplied, <i>SourceType</i> must also be provided.</p>
        /// <ul>
        /// <li> <p>Specify a cluster identifier when <i>SourceType</i> is <code>cluster</code>.</p> </li>
        /// <li> <p>Specify a cluster security group name when <i>SourceType</i> is <code>cluster-security-group</code>.</p> </li>
        /// <li> <p>Specify a cluster parameter group name when <i>SourceType</i> is <code>cluster-parameter-group</code>.</p> </li>
        /// <li> <p>Specify a cluster snapshot identifier when <i>SourceType</i> is <code>cluster-snapshot</code>.</p> </li>
        /// </ul>
        pub fn source_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_identifier(input.into());
            self
        }
        /// <p>The identifier of the event source for which events will be returned. If this parameter is not specified, then all sources are included in the response.</p>
        /// <p>Constraints:</p>
        /// <p>If <i>SourceIdentifier</i> is supplied, <i>SourceType</i> must also be provided.</p>
        /// <ul>
        /// <li> <p>Specify a cluster identifier when <i>SourceType</i> is <code>cluster</code>.</p> </li>
        /// <li> <p>Specify a cluster security group name when <i>SourceType</i> is <code>cluster-security-group</code>.</p> </li>
        /// <li> <p>Specify a cluster parameter group name when <i>SourceType</i> is <code>cluster-parameter-group</code>.</p> </li>
        /// <li> <p>Specify a cluster snapshot identifier when <i>SourceType</i> is <code>cluster-snapshot</code>.</p> </li>
        /// </ul>
        pub fn set_source_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_identifier(input);
            self
        }
        /// <p>The event source to retrieve events for. If no value is specified, all events are returned.</p>
        /// <p>Constraints:</p>
        /// <p>If <i>SourceType</i> is supplied, <i>SourceIdentifier</i> must also be provided.</p>
        /// <ul>
        /// <li> <p>Specify <code>cluster</code> when <i>SourceIdentifier</i> is a cluster identifier.</p> </li>
        /// <li> <p>Specify <code>cluster-security-group</code> when <i>SourceIdentifier</i> is a cluster security group name.</p> </li>
        /// <li> <p>Specify <code>cluster-parameter-group</code> when <i>SourceIdentifier</i> is a cluster parameter group name.</p> </li>
        /// <li> <p>Specify <code>cluster-snapshot</code> when <i>SourceIdentifier</i> is a cluster snapshot identifier.</p> </li>
        /// </ul>
        pub fn source_type(mut self, input: crate::model::SourceType) -> Self {
            self.inner = self.inner.source_type(input);
            self
        }
        /// <p>The event source to retrieve events for. If no value is specified, all events are returned.</p>
        /// <p>Constraints:</p>
        /// <p>If <i>SourceType</i> is supplied, <i>SourceIdentifier</i> must also be provided.</p>
        /// <ul>
        /// <li> <p>Specify <code>cluster</code> when <i>SourceIdentifier</i> is a cluster identifier.</p> </li>
        /// <li> <p>Specify <code>cluster-security-group</code> when <i>SourceIdentifier</i> is a cluster security group name.</p> </li>
        /// <li> <p>Specify <code>cluster-parameter-group</code> when <i>SourceIdentifier</i> is a cluster parameter group name.</p> </li>
        /// <li> <p>Specify <code>cluster-snapshot</code> when <i>SourceIdentifier</i> is a cluster snapshot identifier.</p> </li>
        /// </ul>
        pub fn set_source_type(
            mut self,
            input: std::option::Option<crate::model::SourceType>,
        ) -> Self {
            self.inner = self.inner.set_source_type(input);
            self
        }
        /// <p>The beginning of the time interval to retrieve events for, specified in ISO 8601 format. For more information about ISO 8601, go to the <a href="http://en.wikipedia.org/wiki/ISO_8601">ISO8601 Wikipedia page.</a> </p>
        /// <p>Example: <code>2009-07-08T18:00Z</code> </p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.start_time(input);
            self
        }
        /// <p>The beginning of the time interval to retrieve events for, specified in ISO 8601 format. For more information about ISO 8601, go to the <a href="http://en.wikipedia.org/wiki/ISO_8601">ISO8601 Wikipedia page.</a> </p>
        /// <p>Example: <code>2009-07-08T18:00Z</code> </p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_start_time(input);
            self
        }
        /// <p>The end of the time interval for which to retrieve events, specified in ISO 8601 format. For more information about ISO 8601, go to the <a href="http://en.wikipedia.org/wiki/ISO_8601">ISO8601 Wikipedia page.</a> </p>
        /// <p>Example: <code>2009-07-08T18:00Z</code> </p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.end_time(input);
            self
        }
        /// <p>The end of the time interval for which to retrieve events, specified in ISO 8601 format. For more information about ISO 8601, go to the <a href="http://en.wikipedia.org/wiki/ISO_8601">ISO8601 Wikipedia page.</a> </p>
        /// <p>Example: <code>2009-07-08T18:00Z</code> </p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_end_time(input);
            self
        }
        /// <p>The number of minutes prior to the time of the request for which to retrieve events. For example, if the request is sent at 18:00 and you specify a duration of 60, then only events which have occurred after 17:00 will be returned.</p>
        /// <p>Default: <code>60</code> </p>
        pub fn duration(mut self, input: i32) -> Self {
            self.inner = self.inner.duration(input);
            self
        }
        /// <p>The number of minutes prior to the time of the request for which to retrieve events. For example, if the request is sent at 18:00 and you specify a duration of 60, then only events which have occurred after 17:00 will be returned.</p>
        /// <p>Default: <code>60</code> </p>
        pub fn set_duration(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_duration(input);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>100</code> </p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.inner = self.inner.max_records(input);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>100</code> </p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <code>DescribeEvents</code> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <code>DescribeEvents</code> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEventSubscriptions`.
    ///
    /// <p>Lists descriptions of all the Amazon Redshift event notification subscriptions for a customer account. If you specify a subscription name, lists the description for that subscription.</p>
    /// <p>If you specify both tag keys and tag values in the same request, Amazon Redshift returns all event notification subscriptions that match any combination of the specified keys and values. For example, if you have <code>owner</code> and <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all subscriptions that have any combination of those values are returned.</p>
    /// <p>If both tag keys and values are omitted from the request, subscriptions are returned regardless of whether they have tag keys or values associated with them.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeEventSubscriptions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_event_subscriptions_input::Builder,
    }
    impl DescribeEventSubscriptions {
        /// Creates a new `DescribeEventSubscriptions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEventSubscriptionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeEventSubscriptionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeEventSubscriptionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeEventSubscriptionsPaginator {
            crate::paginator::DescribeEventSubscriptionsPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of the Amazon Redshift event notification subscription to be described.</p>
        pub fn subscription_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subscription_name(input.into());
            self
        }
        /// <p>The name of the Amazon Redshift event notification subscription to be described.</p>
        pub fn set_subscription_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_subscription_name(input);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>100</code> </p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.inner = self.inner.max_records(input);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>100</code> </p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a DescribeEventSubscriptions request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a DescribeEventSubscriptions request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A tag key or keys for which you want to return all matching event notification subscriptions that are associated with the specified key or keys. For example, suppose that you have subscriptions that are tagged with keys called <code>owner</code> and <code>environment</code>. If you specify both of these tag keys in the request, Amazon Redshift returns a response with the subscriptions that have either or both of these tag keys associated with them.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>A tag key or keys for which you want to return all matching event notification subscriptions that are associated with the specified key or keys. For example, suppose that you have subscriptions that are tagged with keys called <code>owner</code> and <code>environment</code>. If you specify both of these tag keys in the request, Amazon Redshift returns a response with the subscriptions that have either or both of these tag keys associated with them.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
        /// Appends an item to `TagValues`.
        ///
        /// To override the contents of this collection use [`set_tag_values`](Self::set_tag_values).
        ///
        /// <p>A tag value or values for which you want to return all matching event notification subscriptions that are associated with the specified tag value or values. For example, suppose that you have subscriptions that are tagged with values called <code>admin</code> and <code>test</code>. If you specify both of these tag values in the request, Amazon Redshift returns a response with the subscriptions that have either or both of these tag values associated with them.</p>
        pub fn tag_values(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_values(input.into());
            self
        }
        /// <p>A tag value or values for which you want to return all matching event notification subscriptions that are associated with the specified tag value or values. For example, suppose that you have subscriptions that are tagged with values called <code>admin</code> and <code>test</code>. If you specify both of these tag values in the request, Amazon Redshift returns a response with the subscriptions that have either or both of these tag values associated with them.</p>
        pub fn set_tag_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_values(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeHsmClientCertificates`.
    ///
    /// <p>Returns information about the specified HSM client certificate. If no certificate ID is specified, returns information about all the HSM certificates owned by your Amazon Web Services account.</p>
    /// <p>If you specify both tag keys and tag values in the same request, Amazon Redshift returns all HSM client certificates that match any combination of the specified keys and values. For example, if you have <code>owner</code> and <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all HSM client certificates that have any combination of those values are returned.</p>
    /// <p>If both tag keys and values are omitted from the request, HSM client certificates are returned regardless of whether they have tag keys or values associated with them.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeHsmClientCertificates {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_hsm_client_certificates_input::Builder,
    }
    impl DescribeHsmClientCertificates {
        /// Creates a new `DescribeHsmClientCertificates`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeHsmClientCertificatesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeHsmClientCertificatesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeHsmClientCertificatesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeHsmClientCertificatesPaginator {
            crate::paginator::DescribeHsmClientCertificatesPaginator::new(self.handle, self.inner)
        }
        /// <p>The identifier of a specific HSM client certificate for which you want information. If no identifier is specified, information is returned for all HSM client certificates owned by your Amazon Web Services account.</p>
        pub fn hsm_client_certificate_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.hsm_client_certificate_identifier(input.into());
            self
        }
        /// <p>The identifier of a specific HSM client certificate for which you want information. If no identifier is specified, information is returned for all HSM client certificates owned by your Amazon Web Services account.</p>
        pub fn set_hsm_client_certificate_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_hsm_client_certificate_identifier(input);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>100</code> </p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.inner = self.inner.max_records(input);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>100</code> </p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <code>DescribeHsmClientCertificates</code> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <code>DescribeHsmClientCertificates</code> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A tag key or keys for which you want to return all matching HSM client certificates that are associated with the specified key or keys. For example, suppose that you have HSM client certificates that are tagged with keys called <code>owner</code> and <code>environment</code>. If you specify both of these tag keys in the request, Amazon Redshift returns a response with the HSM client certificates that have either or both of these tag keys associated with them.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>A tag key or keys for which you want to return all matching HSM client certificates that are associated with the specified key or keys. For example, suppose that you have HSM client certificates that are tagged with keys called <code>owner</code> and <code>environment</code>. If you specify both of these tag keys in the request, Amazon Redshift returns a response with the HSM client certificates that have either or both of these tag keys associated with them.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
        /// Appends an item to `TagValues`.
        ///
        /// To override the contents of this collection use [`set_tag_values`](Self::set_tag_values).
        ///
        /// <p>A tag value or values for which you want to return all matching HSM client certificates that are associated with the specified tag value or values. For example, suppose that you have HSM client certificates that are tagged with values called <code>admin</code> and <code>test</code>. If you specify both of these tag values in the request, Amazon Redshift returns a response with the HSM client certificates that have either or both of these tag values associated with them.</p>
        pub fn tag_values(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_values(input.into());
            self
        }
        /// <p>A tag value or values for which you want to return all matching HSM client certificates that are associated with the specified tag value or values. For example, suppose that you have HSM client certificates that are tagged with values called <code>admin</code> and <code>test</code>. If you specify both of these tag values in the request, Amazon Redshift returns a response with the HSM client certificates that have either or both of these tag values associated with them.</p>
        pub fn set_tag_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_values(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeHsmConfigurations`.
    ///
    /// <p>Returns information about the specified Amazon Redshift HSM configuration. If no configuration ID is specified, returns information about all the HSM configurations owned by your Amazon Web Services account.</p>
    /// <p>If you specify both tag keys and tag values in the same request, Amazon Redshift returns all HSM connections that match any combination of the specified keys and values. For example, if you have <code>owner</code> and <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all HSM connections that have any combination of those values are returned.</p>
    /// <p>If both tag keys and values are omitted from the request, HSM connections are returned regardless of whether they have tag keys or values associated with them.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeHsmConfigurations {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_hsm_configurations_input::Builder,
    }
    impl DescribeHsmConfigurations {
        /// Creates a new `DescribeHsmConfigurations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeHsmConfigurationsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeHsmConfigurationsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeHsmConfigurationsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeHsmConfigurationsPaginator {
            crate::paginator::DescribeHsmConfigurationsPaginator::new(self.handle, self.inner)
        }
        /// <p>The identifier of a specific Amazon Redshift HSM configuration to be described. If no identifier is specified, information is returned for all HSM configurations owned by your Amazon Web Services account.</p>
        pub fn hsm_configuration_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.hsm_configuration_identifier(input.into());
            self
        }
        /// <p>The identifier of a specific Amazon Redshift HSM configuration to be described. If no identifier is specified, information is returned for all HSM configurations owned by your Amazon Web Services account.</p>
        pub fn set_hsm_configuration_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_hsm_configuration_identifier(input);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>100</code> </p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.inner = self.inner.max_records(input);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>100</code> </p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <code>DescribeHsmConfigurations</code> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <code>DescribeHsmConfigurations</code> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A tag key or keys for which you want to return all matching HSM configurations that are associated with the specified key or keys. For example, suppose that you have HSM configurations that are tagged with keys called <code>owner</code> and <code>environment</code>. If you specify both of these tag keys in the request, Amazon Redshift returns a response with the HSM configurations that have either or both of these tag keys associated with them.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>A tag key or keys for which you want to return all matching HSM configurations that are associated with the specified key or keys. For example, suppose that you have HSM configurations that are tagged with keys called <code>owner</code> and <code>environment</code>. If you specify both of these tag keys in the request, Amazon Redshift returns a response with the HSM configurations that have either or both of these tag keys associated with them.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
        /// Appends an item to `TagValues`.
        ///
        /// To override the contents of this collection use [`set_tag_values`](Self::set_tag_values).
        ///
        /// <p>A tag value or values for which you want to return all matching HSM configurations that are associated with the specified tag value or values. For example, suppose that you have HSM configurations that are tagged with values called <code>admin</code> and <code>test</code>. If you specify both of these tag values in the request, Amazon Redshift returns a response with the HSM configurations that have either or both of these tag values associated with them.</p>
        pub fn tag_values(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_values(input.into());
            self
        }
        /// <p>A tag value or values for which you want to return all matching HSM configurations that are associated with the specified tag value or values. For example, suppose that you have HSM configurations that are tagged with values called <code>admin</code> and <code>test</code>. If you specify both of these tag values in the request, Amazon Redshift returns a response with the HSM configurations that have either or both of these tag values associated with them.</p>
        pub fn set_tag_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_values(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeLoggingStatus`.
    ///
    /// <p>Describes whether information, such as queries and connection attempts, is being logged for the specified Amazon Redshift cluster.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeLoggingStatus {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_logging_status_input::Builder,
    }
    impl DescribeLoggingStatus {
        /// Creates a new `DescribeLoggingStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeLoggingStatusOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeLoggingStatusError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the cluster from which to get the logging status.</p>
        /// <p>Example: <code>examplecluster</code> </p>
        pub fn cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_identifier(input.into());
            self
        }
        /// <p>The identifier of the cluster from which to get the logging status.</p>
        /// <p>Example: <code>examplecluster</code> </p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeNodeConfigurationOptions`.
    ///
    /// <p>Returns properties of possible node configurations such as node type, number of nodes, and disk usage for the specified action type.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeNodeConfigurationOptions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_node_configuration_options_input::Builder,
    }
    impl DescribeNodeConfigurationOptions {
        /// Creates a new `DescribeNodeConfigurationOptions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeNodeConfigurationOptionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeNodeConfigurationOptionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeNodeConfigurationOptionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeNodeConfigurationOptionsPaginator {
            crate::paginator::DescribeNodeConfigurationOptionsPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p>The action type to evaluate for possible node configurations. Specify "restore-cluster" to get configuration combinations based on an existing snapshot. Specify "recommend-node-config" to get configuration recommendations based on an existing cluster or snapshot. Specify "resize-cluster" to get configuration combinations for elastic resize based on an existing cluster. </p>
        pub fn action_type(mut self, input: crate::model::ActionType) -> Self {
            self.inner = self.inner.action_type(input);
            self
        }
        /// <p>The action type to evaluate for possible node configurations. Specify "restore-cluster" to get configuration combinations based on an existing snapshot. Specify "recommend-node-config" to get configuration recommendations based on an existing cluster or snapshot. Specify "resize-cluster" to get configuration combinations for elastic resize based on an existing cluster. </p>
        pub fn set_action_type(
            mut self,
            input: std::option::Option<crate::model::ActionType>,
        ) -> Self {
            self.inner = self.inner.set_action_type(input);
            self
        }
        /// <p>The identifier of the cluster to evaluate for possible node configurations.</p>
        pub fn cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_identifier(input.into());
            self
        }
        /// <p>The identifier of the cluster to evaluate for possible node configurations.</p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_identifier(input);
            self
        }
        /// <p>The identifier of the snapshot to evaluate for possible node configurations.</p>
        pub fn snapshot_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.snapshot_identifier(input.into());
            self
        }
        /// <p>The identifier of the snapshot to evaluate for possible node configurations.</p>
        pub fn set_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_snapshot_identifier(input);
            self
        }
        /// <p>The Amazon Web Services account used to create or copy the snapshot. Required if you are restoring a snapshot you do not own, optional if you own the snapshot.</p>
        pub fn owner_account(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.owner_account(input.into());
            self
        }
        /// <p>The Amazon Web Services account used to create or copy the snapshot. Required if you are restoring a snapshot you do not own, optional if you own the snapshot.</p>
        pub fn set_owner_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_owner_account(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>A set of name, operator, and value items to filter the results.</p>
        pub fn filters(mut self, input: crate::model::NodeConfigurationOptionsFilter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>A set of name, operator, and value items to filter the results.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::NodeConfigurationOptionsFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <code>DescribeNodeConfigurationOptions</code> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <code>DescribeNodeConfigurationOptions</code> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>500</code> </p>
        /// <p>Constraints: minimum 100, maximum 500.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.inner = self.inner.max_records(input);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>500</code> </p>
        /// <p>Constraints: minimum 100, maximum 500.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeOrderableClusterOptions`.
    ///
    /// <p>Returns a list of orderable cluster options. Before you create a new cluster you can use this operation to find what options are available, such as the EC2 Availability Zones (AZ) in the specific Amazon Web Services Region that you can specify, and the node types you can request. The node types differ by available storage, memory, CPU and price. With the cost involved you might want to obtain a list of cluster options in the specific region and specify values when creating a cluster. For more information about managing clusters, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html">Amazon Redshift Clusters</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeOrderableClusterOptions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_orderable_cluster_options_input::Builder,
    }
    impl DescribeOrderableClusterOptions {
        /// Creates a new `DescribeOrderableClusterOptions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeOrderableClusterOptionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeOrderableClusterOptionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeOrderableClusterOptionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeOrderableClusterOptionsPaginator {
            crate::paginator::DescribeOrderableClusterOptionsPaginator::new(self.handle, self.inner)
        }
        /// <p>The version filter value. Specify this parameter to show only the available offerings matching the specified version.</p>
        /// <p>Default: All versions.</p>
        /// <p>Constraints: Must be one of the version returned from <code>DescribeClusterVersions</code>.</p>
        pub fn cluster_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_version(input.into());
            self
        }
        /// <p>The version filter value. Specify this parameter to show only the available offerings matching the specified version.</p>
        /// <p>Default: All versions.</p>
        /// <p>Constraints: Must be one of the version returned from <code>DescribeClusterVersions</code>.</p>
        pub fn set_cluster_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_version(input);
            self
        }
        /// <p>The node type filter value. Specify this parameter to show only the available offerings matching the specified node type.</p>
        pub fn node_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.node_type(input.into());
            self
        }
        /// <p>The node type filter value. Specify this parameter to show only the available offerings matching the specified node type.</p>
        pub fn set_node_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_node_type(input);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>100</code> </p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.inner = self.inner.max_records(input);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>100</code> </p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <code>DescribeOrderableClusterOptions</code> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <code>DescribeOrderableClusterOptions</code> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribePartners`.
    ///
    /// <p>Returns information about the partner integrations defined for a cluster.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribePartners {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_partners_input::Builder,
    }
    impl DescribePartners {
        /// Creates a new `DescribePartners`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribePartnersOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribePartnersError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID that owns the cluster.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID that owns the cluster.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
        /// <p>The cluster identifier of the cluster whose partner integration is being described.</p>
        pub fn cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_identifier(input.into());
            self
        }
        /// <p>The cluster identifier of the cluster whose partner integration is being described.</p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_identifier(input);
            self
        }
        /// <p>The name of the database whose partner integration is being described. If database name is not specified, then all databases in the cluster are described.</p>
        pub fn database_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.database_name(input.into());
            self
        }
        /// <p>The name of the database whose partner integration is being described. If database name is not specified, then all databases in the cluster are described.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_database_name(input);
            self
        }
        /// <p>The name of the partner that is being described. If partner name is not specified, then all partner integrations are described.</p>
        pub fn partner_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.partner_name(input.into());
            self
        }
        /// <p>The name of the partner that is being described. If partner name is not specified, then all partner integrations are described.</p>
        pub fn set_partner_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_partner_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeReservedNodeExchangeStatus`.
    ///
    /// <p>Returns exchange status details and associated metadata for a reserved-node exchange. Statuses include such values as in progress and requested.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeReservedNodeExchangeStatus {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_reserved_node_exchange_status_input::Builder,
    }
    impl DescribeReservedNodeExchangeStatus {
        /// Creates a new `DescribeReservedNodeExchangeStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeReservedNodeExchangeStatusOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DescribeReservedNodeExchangeStatusError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeReservedNodeExchangeStatusPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::DescribeReservedNodeExchangeStatusPaginator {
            crate::paginator::DescribeReservedNodeExchangeStatusPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p>The identifier of the source reserved node in a reserved-node exchange request.</p>
        pub fn reserved_node_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.reserved_node_id(input.into());
            self
        }
        /// <p>The identifier of the source reserved node in a reserved-node exchange request.</p>
        pub fn set_reserved_node_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_reserved_node_id(input);
            self
        }
        /// <p>The identifier of the reserved-node exchange request.</p>
        pub fn reserved_node_exchange_request_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.reserved_node_exchange_request_id(input.into());
            self
        }
        /// <p>The identifier of the reserved-node exchange request.</p>
        pub fn set_reserved_node_exchange_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_reserved_node_exchange_request_id(input);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>Marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.inner = self.inner.max_records(input);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>Marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>An optional pagination token provided by a previous <code>DescribeReservedNodeExchangeStatus</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by the <code>MaxRecords</code> parameter. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>An optional pagination token provided by a previous <code>DescribeReservedNodeExchangeStatus</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by the <code>MaxRecords</code> parameter. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeReservedNodeOfferings`.
    ///
    /// <p>Returns a list of the available reserved node offerings by Amazon Redshift with their descriptions including the node type, the fixed and recurring costs of reserving the node and duration the node will be reserved for you. These descriptions help you determine which reserve node offering you want to purchase. You then use the unique offering ID in you call to <code>PurchaseReservedNodeOffering</code> to reserve one or more nodes for your Amazon Redshift cluster. </p>
    /// <p> For more information about reserved node offerings, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/purchase-reserved-node-instance.html">Purchasing Reserved Nodes</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeReservedNodeOfferings {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_reserved_node_offerings_input::Builder,
    }
    impl DescribeReservedNodeOfferings {
        /// Creates a new `DescribeReservedNodeOfferings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeReservedNodeOfferingsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeReservedNodeOfferingsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeReservedNodeOfferingsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeReservedNodeOfferingsPaginator {
            crate::paginator::DescribeReservedNodeOfferingsPaginator::new(self.handle, self.inner)
        }
        /// <p>The unique identifier for the offering.</p>
        pub fn reserved_node_offering_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.reserved_node_offering_id(input.into());
            self
        }
        /// <p>The unique identifier for the offering.</p>
        pub fn set_reserved_node_offering_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_reserved_node_offering_id(input);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>100</code> </p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.inner = self.inner.max_records(input);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>100</code> </p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <code>DescribeReservedNodeOfferings</code> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <code>DescribeReservedNodeOfferings</code> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeReservedNodes`.
    ///
    /// <p>Returns the descriptions of the reserved nodes.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeReservedNodes {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_reserved_nodes_input::Builder,
    }
    impl DescribeReservedNodes {
        /// Creates a new `DescribeReservedNodes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeReservedNodesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeReservedNodesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeReservedNodesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeReservedNodesPaginator {
            crate::paginator::DescribeReservedNodesPaginator::new(self.handle, self.inner)
        }
        /// <p>Identifier for the node reservation.</p>
        pub fn reserved_node_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.reserved_node_id(input.into());
            self
        }
        /// <p>Identifier for the node reservation.</p>
        pub fn set_reserved_node_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_reserved_node_id(input);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>100</code> </p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.inner = self.inner.max_records(input);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>100</code> </p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <code>DescribeReservedNodes</code> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <code>DescribeReservedNodes</code> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeResize`.
    ///
    /// <p>Returns information about the last resize operation for the specified cluster. If no resize operation has ever been initiated for the specified cluster, a <code>HTTP 404</code> error is returned. If a resize operation was initiated and completed, the status of the resize remains as <code>SUCCEEDED</code> until the next resize. </p>
    /// <p>A resize operation can be requested using <code>ModifyCluster</code> and specifying a different number or type of nodes for the cluster. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeResize {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_resize_input::Builder,
    }
    impl DescribeResize {
        /// Creates a new `DescribeResize`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeResizeOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeResizeError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of a cluster whose resize progress you are requesting. This parameter is case-sensitive.</p>
        /// <p>By default, resize operations for all clusters defined for an Amazon Web Services account are returned.</p>
        pub fn cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_identifier(input.into());
            self
        }
        /// <p>The unique identifier of a cluster whose resize progress you are requesting. This parameter is case-sensitive.</p>
        /// <p>By default, resize operations for all clusters defined for an Amazon Web Services account are returned.</p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeScheduledActions`.
    ///
    /// <p>Describes properties of scheduled actions. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeScheduledActions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_scheduled_actions_input::Builder,
    }
    impl DescribeScheduledActions {
        /// Creates a new `DescribeScheduledActions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeScheduledActionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeScheduledActionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeScheduledActionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeScheduledActionsPaginator {
            crate::paginator::DescribeScheduledActionsPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of the scheduled action to retrieve. </p>
        pub fn scheduled_action_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.scheduled_action_name(input.into());
            self
        }
        /// <p>The name of the scheduled action to retrieve. </p>
        pub fn set_scheduled_action_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_scheduled_action_name(input);
            self
        }
        /// <p>The type of the scheduled actions to retrieve. </p>
        pub fn target_action_type(
            mut self,
            input: crate::model::ScheduledActionTypeValues,
        ) -> Self {
            self.inner = self.inner.target_action_type(input);
            self
        }
        /// <p>The type of the scheduled actions to retrieve. </p>
        pub fn set_target_action_type(
            mut self,
            input: std::option::Option<crate::model::ScheduledActionTypeValues>,
        ) -> Self {
            self.inner = self.inner.set_target_action_type(input);
            self
        }
        /// <p>The start time in UTC of the scheduled actions to retrieve. Only active scheduled actions that have invocations after this time are retrieved.</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.start_time(input);
            self
        }
        /// <p>The start time in UTC of the scheduled actions to retrieve. Only active scheduled actions that have invocations after this time are retrieved.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_start_time(input);
            self
        }
        /// <p>The end time in UTC of the scheduled action to retrieve. Only active scheduled actions that have invocations before this time are retrieved.</p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.end_time(input);
            self
        }
        /// <p>The end time in UTC of the scheduled action to retrieve. Only active scheduled actions that have invocations before this time are retrieved.</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_end_time(input);
            self
        }
        /// <p>If true, retrieve only active scheduled actions. If false, retrieve only disabled scheduled actions. </p>
        pub fn active(mut self, input: bool) -> Self {
            self.inner = self.inner.active(input);
            self
        }
        /// <p>If true, retrieve only active scheduled actions. If false, retrieve only disabled scheduled actions. </p>
        pub fn set_active(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_active(input);
            self
        }
        /// Appends an item to `Filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>List of scheduled action filters. </p>
        pub fn filters(mut self, input: crate::model::ScheduledActionFilter) -> Self {
            self.inner = self.inner.filters(input);
            self
        }
        /// <p>List of scheduled action filters. </p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ScheduledActionFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filters(input);
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <code>DescribeScheduledActions</code> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <code>DescribeScheduledActions</code> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>100</code> </p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.inner = self.inner.max_records(input);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>100</code> </p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeSnapshotCopyGrants`.
    ///
    /// <p>Returns a list of snapshot copy grants owned by the Amazon Web Services account in the destination region.</p>
    /// <p> For more information about managing snapshot copy grants, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-db-encryption.html">Amazon Redshift Database Encryption</a> in the <i>Amazon Redshift Cluster Management Guide</i>. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeSnapshotCopyGrants {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_snapshot_copy_grants_input::Builder,
    }
    impl DescribeSnapshotCopyGrants {
        /// Creates a new `DescribeSnapshotCopyGrants`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeSnapshotCopyGrantsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeSnapshotCopyGrantsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeSnapshotCopyGrantsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeSnapshotCopyGrantsPaginator {
            crate::paginator::DescribeSnapshotCopyGrantsPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of the snapshot copy grant.</p>
        pub fn snapshot_copy_grant_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.snapshot_copy_grant_name(input.into());
            self
        }
        /// <p>The name of the snapshot copy grant.</p>
        pub fn set_snapshot_copy_grant_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_snapshot_copy_grant_name(input);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>100</code> </p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.inner = self.inner.max_records(input);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>100</code> </p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <code>DescribeSnapshotCopyGrant</code> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
        /// <p>Constraints: You can specify either the <b>SnapshotCopyGrantName</b> parameter or the <b>Marker</b> parameter, but not both. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <code>DescribeSnapshotCopyGrant</code> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
        /// <p>Constraints: You can specify either the <b>SnapshotCopyGrantName</b> parameter or the <b>Marker</b> parameter, but not both. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A tag key or keys for which you want to return all matching resources that are associated with the specified key or keys. For example, suppose that you have resources tagged with keys called <code>owner</code> and <code>environment</code>. If you specify both of these tag keys in the request, Amazon Redshift returns a response with all resources that have either or both of these tag keys associated with them.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>A tag key or keys for which you want to return all matching resources that are associated with the specified key or keys. For example, suppose that you have resources tagged with keys called <code>owner</code> and <code>environment</code>. If you specify both of these tag keys in the request, Amazon Redshift returns a response with all resources that have either or both of these tag keys associated with them.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
        /// Appends an item to `TagValues`.
        ///
        /// To override the contents of this collection use [`set_tag_values`](Self::set_tag_values).
        ///
        /// <p>A tag value or values for which you want to return all matching resources that are associated with the specified value or values. For example, suppose that you have resources tagged with values called <code>admin</code> and <code>test</code>. If you specify both of these tag values in the request, Amazon Redshift returns a response with all resources that have either or both of these tag values associated with them.</p>
        pub fn tag_values(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_values(input.into());
            self
        }
        /// <p>A tag value or values for which you want to return all matching resources that are associated with the specified value or values. For example, suppose that you have resources tagged with values called <code>admin</code> and <code>test</code>. If you specify both of these tag values in the request, Amazon Redshift returns a response with all resources that have either or both of these tag values associated with them.</p>
        pub fn set_tag_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_values(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeSnapshotSchedules`.
    ///
    /// <p>Returns a list of snapshot schedules. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeSnapshotSchedules {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_snapshot_schedules_input::Builder,
    }
    impl DescribeSnapshotSchedules {
        /// Creates a new `DescribeSnapshotSchedules`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeSnapshotSchedulesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeSnapshotSchedulesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeSnapshotSchedulesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeSnapshotSchedulesPaginator {
            crate::paginator::DescribeSnapshotSchedulesPaginator::new(self.handle, self.inner)
        }
        /// <p>The unique identifier for the cluster whose snapshot schedules you want to view.</p>
        pub fn cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_identifier(input.into());
            self
        }
        /// <p>The unique identifier for the cluster whose snapshot schedules you want to view.</p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_identifier(input);
            self
        }
        /// <p>A unique identifier for a snapshot schedule.</p>
        pub fn schedule_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schedule_identifier(input.into());
            self
        }
        /// <p>A unique identifier for a snapshot schedule.</p>
        pub fn set_schedule_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_schedule_identifier(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The key value for a snapshot schedule tag.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>The key value for a snapshot schedule tag.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
        /// Appends an item to `TagValues`.
        ///
        /// To override the contents of this collection use [`set_tag_values`](Self::set_tag_values).
        ///
        /// <p>The value corresponding to the key of the snapshot schedule tag.</p>
        pub fn tag_values(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_values(input.into());
            self
        }
        /// <p>The value corresponding to the key of the snapshot schedule tag.</p>
        pub fn set_tag_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_values(input);
            self
        }
        /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>marker</code> parameter and retrying the command. If the <code>marker</code> field is empty, all response records have been retrieved for the request.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>marker</code> parameter and retrying the command. If the <code>marker</code> field is empty, all response records have been retrieved for the request.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// <p>The maximum number or response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned <code>marker</code> value.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.inner = self.inner.max_records(input);
            self
        }
        /// <p>The maximum number or response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned <code>marker</code> value.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeStorage`.
    ///
    /// <p>Returns account level backups storage size and provisional storage.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeStorage {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_storage_input::Builder,
    }
    impl DescribeStorage {
        /// Creates a new `DescribeStorage`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeStorageOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeStorageError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `DescribeTableRestoreStatus`.
    ///
    /// <p>Lists the status of one or more table restore requests made using the <code>RestoreTableFromClusterSnapshot</code> API action. If you don't specify a value for the <code>TableRestoreRequestId</code> parameter, then <code>DescribeTableRestoreStatus</code> returns the status of all table restore requests ordered by the date and time of the request in ascending order. Otherwise <code>DescribeTableRestoreStatus</code> returns the status of the table specified by <code>TableRestoreRequestId</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeTableRestoreStatus {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_table_restore_status_input::Builder,
    }
    impl DescribeTableRestoreStatus {
        /// Creates a new `DescribeTableRestoreStatus`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeTableRestoreStatusOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeTableRestoreStatusError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeTableRestoreStatusPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeTableRestoreStatusPaginator {
            crate::paginator::DescribeTableRestoreStatusPaginator::new(self.handle, self.inner)
        }
        /// <p>The Amazon Redshift cluster that the table is being restored to.</p>
        pub fn cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_identifier(input.into());
            self
        }
        /// <p>The Amazon Redshift cluster that the table is being restored to.</p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_identifier(input);
            self
        }
        /// <p>The identifier of the table restore request to return status for. If you don't specify a <code>TableRestoreRequestId</code> value, then <code>DescribeTableRestoreStatus</code> returns the status of all in-progress table restore requests.</p>
        pub fn table_restore_request_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.table_restore_request_id(input.into());
            self
        }
        /// <p>The identifier of the table restore request to return status for. If you don't specify a <code>TableRestoreRequestId</code> value, then <code>DescribeTableRestoreStatus</code> returns the status of all in-progress table restore requests.</p>
        pub fn set_table_restore_request_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_table_restore_request_id(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.inner = self.inner.max_records(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>An optional pagination token provided by a previous <code>DescribeTableRestoreStatus</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by the <code>MaxRecords</code> parameter.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>An optional pagination token provided by a previous <code>DescribeTableRestoreStatus</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by the <code>MaxRecords</code> parameter.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeTags`.
    ///
    /// <p>Returns a list of tags. You can return tags from a specific resource by specifying an ARN, or you can return all tags for a given type of resource, such as clusters, snapshots, and so on.</p>
    /// <p>The following are limitations for <code>DescribeTags</code>: </p>
    /// <ul>
    /// <li> <p>You cannot specify an ARN and a resource-type value together in the same request.</p> </li>
    /// <li> <p>You cannot use the <code>MaxRecords</code> and <code>Marker</code> parameters together with the ARN parameter.</p> </li>
    /// <li> <p>The <code>MaxRecords</code> parameter can be a range from 10 to 50 results to return in a request.</p> </li>
    /// </ul>
    /// <p>If you specify both tag keys and tag values in the same request, Amazon Redshift returns all resources that match any combination of the specified keys and values. For example, if you have <code>owner</code> and <code>environment</code> for tag keys, and <code>admin</code> and <code>test</code> for tag values, all resources that have any combination of those values are returned.</p>
    /// <p>If both tag keys and values are omitted from the request, resources are returned regardless of whether they have tag keys or values associated with them.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeTags {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_tags_input::Builder,
    }
    impl DescribeTags {
        /// Creates a new `DescribeTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeTagsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeTagsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeTagsPaginator {
            crate::paginator::DescribeTagsPaginator::new(self.handle, self.inner)
        }
        /// <p>The Amazon Resource Name (ARN) for which you want to describe the tag or tags. For example, <code>arn:aws:redshift:us-east-2:123456789:cluster:t1</code>. </p>
        pub fn resource_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_name(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for which you want to describe the tag or tags. For example, <code>arn:aws:redshift:us-east-2:123456789:cluster:t1</code>. </p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_name(input);
            self
        }
        /// <p>The type of resource with which you want to view tags. Valid resource types are: </p>
        /// <ul>
        /// <li> <p>Cluster</p> </li>
        /// <li> <p>CIDR/IP</p> </li>
        /// <li> <p>EC2 security group</p> </li>
        /// <li> <p>Snapshot</p> </li>
        /// <li> <p>Cluster security group</p> </li>
        /// <li> <p>Subnet group</p> </li>
        /// <li> <p>HSM connection</p> </li>
        /// <li> <p>HSM certificate</p> </li>
        /// <li> <p>Parameter group</p> </li>
        /// <li> <p>Snapshot copy grant</p> </li>
        /// </ul>
        /// <p>For more information about Amazon Redshift resource types and constructing ARNs, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-overview.html#redshift-iam-access-control-specify-actions">Specifying Policy Elements: Actions, Effects, Resources, and Principals</a> in the Amazon Redshift Cluster Management Guide. </p>
        pub fn resource_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_type(input.into());
            self
        }
        /// <p>The type of resource with which you want to view tags. Valid resource types are: </p>
        /// <ul>
        /// <li> <p>Cluster</p> </li>
        /// <li> <p>CIDR/IP</p> </li>
        /// <li> <p>EC2 security group</p> </li>
        /// <li> <p>Snapshot</p> </li>
        /// <li> <p>Cluster security group</p> </li>
        /// <li> <p>Subnet group</p> </li>
        /// <li> <p>HSM connection</p> </li>
        /// <li> <p>HSM certificate</p> </li>
        /// <li> <p>Parameter group</p> </li>
        /// <li> <p>Snapshot copy grant</p> </li>
        /// </ul>
        /// <p>For more information about Amazon Redshift resource types and constructing ARNs, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-overview.html#redshift-iam-access-control-specify-actions">Specifying Policy Elements: Actions, Effects, Resources, and Principals</a> in the Amazon Redshift Cluster Management Guide. </p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_type(input);
            self
        }
        /// <p>The maximum number or response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned <code>marker</code> value. </p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.inner = self.inner.max_records(input);
            self
        }
        /// <p>The maximum number or response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned <code>marker</code> value. </p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>marker</code> parameter and retrying the command. If the <code>marker</code> field is empty, all response records have been retrieved for the request. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>A value that indicates the starting point for the next set of response records in a subsequent request. If a value is returned in a response, you can retrieve the next set of records by providing this returned marker value in the <code>marker</code> parameter and retrying the command. If the <code>marker</code> field is empty, all response records have been retrieved for the request. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A tag key or keys for which you want to return all matching resources that are associated with the specified key or keys. For example, suppose that you have resources tagged with keys called <code>owner</code> and <code>environment</code>. If you specify both of these tag keys in the request, Amazon Redshift returns a response with all resources that have either or both of these tag keys associated with them.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>A tag key or keys for which you want to return all matching resources that are associated with the specified key or keys. For example, suppose that you have resources tagged with keys called <code>owner</code> and <code>environment</code>. If you specify both of these tag keys in the request, Amazon Redshift returns a response with all resources that have either or both of these tag keys associated with them.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
        /// Appends an item to `TagValues`.
        ///
        /// To override the contents of this collection use [`set_tag_values`](Self::set_tag_values).
        ///
        /// <p>A tag value or values for which you want to return all matching resources that are associated with the specified value or values. For example, suppose that you have resources tagged with values called <code>admin</code> and <code>test</code>. If you specify both of these tag values in the request, Amazon Redshift returns a response with all resources that have either or both of these tag values associated with them.</p>
        pub fn tag_values(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_values(input.into());
            self
        }
        /// <p>A tag value or values for which you want to return all matching resources that are associated with the specified value or values. For example, suppose that you have resources tagged with values called <code>admin</code> and <code>test</code>. If you specify both of these tag values in the request, Amazon Redshift returns a response with all resources that have either or both of these tag values associated with them.</p>
        pub fn set_tag_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_values(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeUsageLimits`.
    ///
    /// <p>Shows usage limits on a cluster. Results are filtered based on the combination of input usage limit identifier, cluster identifier, and feature type parameters:</p>
    /// <ul>
    /// <li> <p>If usage limit identifier, cluster identifier, and feature type are not provided, then all usage limit objects for the current account in the current region are returned.</p> </li>
    /// <li> <p>If usage limit identifier is provided, then the corresponding usage limit object is returned.</p> </li>
    /// <li> <p>If cluster identifier is provided, then all usage limit objects for the specified cluster are returned.</p> </li>
    /// <li> <p>If cluster identifier and feature type are provided, then all usage limit objects for the combination of cluster and feature are returned.</p> </li>
    /// </ul>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeUsageLimits {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_usage_limits_input::Builder,
    }
    impl DescribeUsageLimits {
        /// Creates a new `DescribeUsageLimits`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeUsageLimitsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeUsageLimitsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeUsageLimitsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeUsageLimitsPaginator {
            crate::paginator::DescribeUsageLimitsPaginator::new(self.handle, self.inner)
        }
        /// <p>The identifier of the usage limit to describe.</p>
        pub fn usage_limit_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.usage_limit_id(input.into());
            self
        }
        /// <p>The identifier of the usage limit to describe.</p>
        pub fn set_usage_limit_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_usage_limit_id(input);
            self
        }
        /// <p>The identifier of the cluster for which you want to describe usage limits.</p>
        pub fn cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_identifier(input.into());
            self
        }
        /// <p>The identifier of the cluster for which you want to describe usage limits.</p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_identifier(input);
            self
        }
        /// <p>The feature type for which you want to describe usage limits.</p>
        pub fn feature_type(mut self, input: crate::model::UsageLimitFeatureType) -> Self {
            self.inner = self.inner.feature_type(input);
            self
        }
        /// <p>The feature type for which you want to describe usage limits.</p>
        pub fn set_feature_type(
            mut self,
            input: std::option::Option<crate::model::UsageLimitFeatureType>,
        ) -> Self {
            self.inner = self.inner.set_feature_type(input);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>100</code> </p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.inner = self.inner.max_records(input);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value. </p>
        /// <p>Default: <code>100</code> </p>
        /// <p>Constraints: minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <code>DescribeUsageLimits</code> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>An optional parameter that specifies the starting point to return a set of response records. When the results of a <code>DescribeUsageLimits</code> request exceed the value specified in <code>MaxRecords</code>, Amazon Web Services returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request. </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A tag key or keys for which you want to return all matching usage limit objects that are associated with the specified key or keys. For example, suppose that you have parameter groups that are tagged with keys called <code>owner</code> and <code>environment</code>. If you specify both of these tag keys in the request, Amazon Redshift returns a response with the usage limit objects have either or both of these tag keys associated with them.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>A tag key or keys for which you want to return all matching usage limit objects that are associated with the specified key or keys. For example, suppose that you have parameter groups that are tagged with keys called <code>owner</code> and <code>environment</code>. If you specify both of these tag keys in the request, Amazon Redshift returns a response with the usage limit objects have either or both of these tag keys associated with them.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
        /// Appends an item to `TagValues`.
        ///
        /// To override the contents of this collection use [`set_tag_values`](Self::set_tag_values).
        ///
        /// <p>A tag value or values for which you want to return all matching usage limit objects that are associated with the specified tag value or values. For example, suppose that you have parameter groups that are tagged with values called <code>admin</code> and <code>test</code>. If you specify both of these tag values in the request, Amazon Redshift returns a response with the usage limit objects that have either or both of these tag values associated with them.</p>
        pub fn tag_values(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_values(input.into());
            self
        }
        /// <p>A tag value or values for which you want to return all matching usage limit objects that are associated with the specified tag value or values. For example, suppose that you have parameter groups that are tagged with values called <code>admin</code> and <code>test</code>. If you specify both of these tag values in the request, Amazon Redshift returns a response with the usage limit objects that have either or both of these tag values associated with them.</p>
        pub fn set_tag_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_values(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisableLogging`.
    ///
    /// <p>Stops logging information, such as queries and connection attempts, for the specified Amazon Redshift cluster.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisableLogging {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::disable_logging_input::Builder,
    }
    impl DisableLogging {
        /// Creates a new `DisableLogging`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisableLoggingOutput,
            aws_smithy_http::result::SdkError<crate::error::DisableLoggingError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the cluster on which logging is to be stopped.</p>
        /// <p>Example: <code>examplecluster</code> </p>
        pub fn cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_identifier(input.into());
            self
        }
        /// <p>The identifier of the cluster on which logging is to be stopped.</p>
        /// <p>Example: <code>examplecluster</code> </p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisableSnapshotCopy`.
    ///
    /// <p>Disables the automatic copying of snapshots from one region to another region for a specified cluster.</p>
    /// <p>If your cluster and its snapshots are encrypted using an encrypted symmetric key from Key Management Service, use <code>DeleteSnapshotCopyGrant</code> to delete the grant that grants Amazon Redshift permission to the key in the destination region. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisableSnapshotCopy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::disable_snapshot_copy_input::Builder,
    }
    impl DisableSnapshotCopy {
        /// Creates a new `DisableSnapshotCopy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisableSnapshotCopyOutput,
            aws_smithy_http::result::SdkError<crate::error::DisableSnapshotCopyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the source cluster that you want to disable copying of snapshots to a destination region.</p>
        /// <p>Constraints: Must be the valid name of an existing cluster that has cross-region snapshot copy enabled.</p>
        pub fn cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_identifier(input.into());
            self
        }
        /// <p>The unique identifier of the source cluster that you want to disable copying of snapshots to a destination region.</p>
        /// <p>Constraints: Must be the valid name of an existing cluster that has cross-region snapshot copy enabled.</p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateDataShareConsumer`.
    ///
    /// <p>From a consumer account, remove association for the specified datashare. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociateDataShareConsumer {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::disassociate_data_share_consumer_input::Builder,
    }
    impl DisassociateDataShareConsumer {
        /// Creates a new `DisassociateDataShareConsumer`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateDataShareConsumerOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateDataShareConsumerError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the datashare to remove association for. </p>
        pub fn data_share_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_share_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the datashare to remove association for. </p>
        pub fn set_data_share_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_data_share_arn(input);
            self
        }
        /// <p>A value that specifies whether association for the datashare is removed from the entire account.</p>
        pub fn disassociate_entire_account(mut self, input: bool) -> Self {
            self.inner = self.inner.disassociate_entire_account(input);
            self
        }
        /// <p>A value that specifies whether association for the datashare is removed from the entire account.</p>
        pub fn set_disassociate_entire_account(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_disassociate_entire_account(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the consumer that association for the datashare is removed from.</p>
        pub fn consumer_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.consumer_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the consumer that association for the datashare is removed from.</p>
        pub fn set_consumer_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_consumer_arn(input);
            self
        }
        /// <p>From a datashare consumer account, removes association of a datashare from all the existing and future namespaces in the specified Amazon Web Services Region.</p>
        pub fn consumer_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.consumer_region(input.into());
            self
        }
        /// <p>From a datashare consumer account, removes association of a datashare from all the existing and future namespaces in the specified Amazon Web Services Region.</p>
        pub fn set_consumer_region(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_consumer_region(input);
            self
        }
    }
    /// Fluent builder constructing a request to `EnableLogging`.
    ///
    /// <p>Starts logging information, such as queries and connection attempts, for the specified Amazon Redshift cluster.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct EnableLogging {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::enable_logging_input::Builder,
    }
    impl EnableLogging {
        /// Creates a new `EnableLogging`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::EnableLoggingOutput,
            aws_smithy_http::result::SdkError<crate::error::EnableLoggingError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the cluster on which logging is to be started.</p>
        /// <p>Example: <code>examplecluster</code> </p>
        pub fn cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_identifier(input.into());
            self
        }
        /// <p>The identifier of the cluster on which logging is to be started.</p>
        /// <p>Example: <code>examplecluster</code> </p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_identifier(input);
            self
        }
        /// <p>The name of an existing S3 bucket where the log files are to be stored.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be in the same region as the cluster</p> </li>
        /// <li> <p>The cluster must have read bucket and put object permissions</p> </li>
        /// </ul>
        pub fn bucket_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.bucket_name(input.into());
            self
        }
        /// <p>The name of an existing S3 bucket where the log files are to be stored.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be in the same region as the cluster</p> </li>
        /// <li> <p>The cluster must have read bucket and put object permissions</p> </li>
        /// </ul>
        pub fn set_bucket_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_bucket_name(input);
            self
        }
        /// <p>The prefix applied to the log file names.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Cannot exceed 512 characters</p> </li>
        /// <li> <p>Cannot contain spaces( ), double quotes ("), single quotes ('), a backslash (\), or control characters. The hexadecimal codes for invalid characters are: </p>
        /// <ul>
        /// <li> <p>x00 to x20</p> </li>
        /// <li> <p>x22</p> </li>
        /// <li> <p>x27</p> </li>
        /// <li> <p>x5c</p> </li>
        /// <li> <p>x7f or larger</p> </li>
        /// </ul> </li>
        /// </ul>
        pub fn s3_key_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.s3_key_prefix(input.into());
            self
        }
        /// <p>The prefix applied to the log file names.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Cannot exceed 512 characters</p> </li>
        /// <li> <p>Cannot contain spaces( ), double quotes ("), single quotes ('), a backslash (\), or control characters. The hexadecimal codes for invalid characters are: </p>
        /// <ul>
        /// <li> <p>x00 to x20</p> </li>
        /// <li> <p>x22</p> </li>
        /// <li> <p>x27</p> </li>
        /// <li> <p>x5c</p> </li>
        /// <li> <p>x7f or larger</p> </li>
        /// </ul> </li>
        /// </ul>
        pub fn set_s3_key_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_s3_key_prefix(input);
            self
        }
    }
    /// Fluent builder constructing a request to `EnableSnapshotCopy`.
    ///
    /// <p>Enables the automatic copy of snapshots from one region to another region for a specified cluster.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct EnableSnapshotCopy {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::enable_snapshot_copy_input::Builder,
    }
    impl EnableSnapshotCopy {
        /// Creates a new `EnableSnapshotCopy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::EnableSnapshotCopyOutput,
            aws_smithy_http::result::SdkError<crate::error::EnableSnapshotCopyError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the source cluster to copy snapshots from.</p>
        /// <p>Constraints: Must be the valid name of an existing cluster that does not already have cross-region snapshot copy enabled.</p>
        pub fn cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_identifier(input.into());
            self
        }
        /// <p>The unique identifier of the source cluster to copy snapshots from.</p>
        /// <p>Constraints: Must be the valid name of an existing cluster that does not already have cross-region snapshot copy enabled.</p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_identifier(input);
            self
        }
        /// <p>The destination Amazon Web Services Region that you want to copy snapshots to.</p>
        /// <p>Constraints: Must be the name of a valid Amazon Web Services Region. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#redshift_region">Regions and Endpoints</a> in the Amazon Web Services General Reference. </p>
        pub fn destination_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.destination_region(input.into());
            self
        }
        /// <p>The destination Amazon Web Services Region that you want to copy snapshots to.</p>
        /// <p>Constraints: Must be the name of a valid Amazon Web Services Region. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#redshift_region">Regions and Endpoints</a> in the Amazon Web Services General Reference. </p>
        pub fn set_destination_region(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_destination_region(input);
            self
        }
        /// <p>The number of days to retain automated snapshots in the destination region after they are copied from the source region.</p>
        /// <p>Default: 7.</p>
        /// <p>Constraints: Must be at least 1 and no more than 35.</p>
        pub fn retention_period(mut self, input: i32) -> Self {
            self.inner = self.inner.retention_period(input);
            self
        }
        /// <p>The number of days to retain automated snapshots in the destination region after they are copied from the source region.</p>
        /// <p>Default: 7.</p>
        /// <p>Constraints: Must be at least 1 and no more than 35.</p>
        pub fn set_retention_period(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_retention_period(input);
            self
        }
        /// <p>The name of the snapshot copy grant to use when snapshots of an Amazon Web Services KMS-encrypted cluster are copied to the destination region.</p>
        pub fn snapshot_copy_grant_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.snapshot_copy_grant_name(input.into());
            self
        }
        /// <p>The name of the snapshot copy grant to use when snapshots of an Amazon Web Services KMS-encrypted cluster are copied to the destination region.</p>
        pub fn set_snapshot_copy_grant_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_snapshot_copy_grant_name(input);
            self
        }
        /// <p>The number of days to retain newly copied snapshots in the destination Amazon Web Services Region after they are copied from the source Amazon Web Services Region. If the value is -1, the manual snapshot is retained indefinitely. </p>
        /// <p>The value must be either -1 or an integer between 1 and 3,653.</p>
        pub fn manual_snapshot_retention_period(mut self, input: i32) -> Self {
            self.inner = self.inner.manual_snapshot_retention_period(input);
            self
        }
        /// <p>The number of days to retain newly copied snapshots in the destination Amazon Web Services Region after they are copied from the source Amazon Web Services Region. If the value is -1, the manual snapshot is retained indefinitely. </p>
        /// <p>The value must be either -1 or an integer between 1 and 3,653.</p>
        pub fn set_manual_snapshot_retention_period(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.inner = self.inner.set_manual_snapshot_retention_period(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetClusterCredentials`.
    ///
    /// <p>Returns a database user name and temporary password with temporary authorization to log on to an Amazon Redshift database. The action returns the database user name prefixed with <code>IAM:</code> if <code>AutoCreate</code> is <code>False</code> or <code>IAMA:</code> if <code>AutoCreate</code> is <code>True</code>. You can optionally specify one or more database user groups that the user will join at log on. By default, the temporary credentials expire in 900 seconds. You can optionally specify a duration between 900 seconds (15 minutes) and 3600 seconds (60 minutes). For more information, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/generating-user-credentials.html">Using IAM Authentication to Generate Database User Credentials</a> in the Amazon Redshift Cluster Management Guide.</p>
    /// <p>The Identity and Access Management (IAM) user or role that runs GetClusterCredentials must have an IAM policy attached that allows access to all necessary actions and resources. For more information about permissions, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-identity-based.html#redshift-policy-resources.getclustercredentials-resources">Resource Policies for GetClusterCredentials</a> in the Amazon Redshift Cluster Management Guide.</p>
    /// <p>If the <code>DbGroups</code> parameter is specified, the IAM policy must allow the <code>redshift:JoinGroup</code> action with access to the listed <code>dbgroups</code>. </p>
    /// <p>In addition, if the <code>AutoCreate</code> parameter is set to <code>True</code>, then the policy must include the <code>redshift:CreateClusterUser</code> privilege.</p>
    /// <p>If the <code>DbName</code> parameter is specified, the IAM policy must allow access to the resource <code>dbname</code> for the specified database name. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetClusterCredentials {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_cluster_credentials_input::Builder,
    }
    impl GetClusterCredentials {
        /// Creates a new `GetClusterCredentials`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetClusterCredentialsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetClusterCredentialsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of a database user. If a user name matching <code>DbUser</code> exists in the database, the temporary user credentials have the same permissions as the existing user. If <code>DbUser</code> doesn't exist in the database and <code>Autocreate</code> is <code>True</code>, a new user is created using the value for <code>DbUser</code> with PUBLIC permissions. If a database user matching the value for <code>DbUser</code> doesn't exist and <code>Autocreate</code> is <code>False</code>, then the command succeeds but the connection attempt will fail because the user doesn't exist in the database.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/redshift/latest/dg/r_CREATE_USER.html">CREATE USER</a> in the Amazon Redshift Database Developer Guide. </p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be 1 to 64 alphanumeric characters or hyphens. The user name can't be <code>PUBLIC</code>.</p> </li>
        /// <li> <p>Must contain only lowercase letters, numbers, underscore, plus sign, period (dot), at symbol (@), or hyphen.</p> </li>
        /// <li> <p>First character must be a letter.</p> </li>
        /// <li> <p>Must not contain a colon ( : ) or slash ( / ). </p> </li>
        /// <li> <p>Cannot be a reserved word. A list of reserved words can be found in <a href="http://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html">Reserved Words</a> in the Amazon Redshift Database Developer Guide.</p> </li>
        /// </ul>
        pub fn db_user(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_user(input.into());
            self
        }
        /// <p>The name of a database user. If a user name matching <code>DbUser</code> exists in the database, the temporary user credentials have the same permissions as the existing user. If <code>DbUser</code> doesn't exist in the database and <code>Autocreate</code> is <code>True</code>, a new user is created using the value for <code>DbUser</code> with PUBLIC permissions. If a database user matching the value for <code>DbUser</code> doesn't exist and <code>Autocreate</code> is <code>False</code>, then the command succeeds but the connection attempt will fail because the user doesn't exist in the database.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/redshift/latest/dg/r_CREATE_USER.html">CREATE USER</a> in the Amazon Redshift Database Developer Guide. </p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be 1 to 64 alphanumeric characters or hyphens. The user name can't be <code>PUBLIC</code>.</p> </li>
        /// <li> <p>Must contain only lowercase letters, numbers, underscore, plus sign, period (dot), at symbol (@), or hyphen.</p> </li>
        /// <li> <p>First character must be a letter.</p> </li>
        /// <li> <p>Must not contain a colon ( : ) or slash ( / ). </p> </li>
        /// <li> <p>Cannot be a reserved word. A list of reserved words can be found in <a href="http://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html">Reserved Words</a> in the Amazon Redshift Database Developer Guide.</p> </li>
        /// </ul>
        pub fn set_db_user(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_db_user(input);
            self
        }
        /// <p>The name of a database that <code>DbUser</code> is authorized to log on to. If <code>DbName</code> is not specified, <code>DbUser</code> can log on to any existing database.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be 1 to 64 alphanumeric characters or hyphens</p> </li>
        /// <li> <p>Must contain only lowercase letters, numbers, underscore, plus sign, period (dot), at symbol (@), or hyphen.</p> </li>
        /// <li> <p>First character must be a letter.</p> </li>
        /// <li> <p>Must not contain a colon ( : ) or slash ( / ). </p> </li>
        /// <li> <p>Cannot be a reserved word. A list of reserved words can be found in <a href="http://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html">Reserved Words</a> in the Amazon Redshift Database Developer Guide.</p> </li>
        /// </ul>
        pub fn db_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_name(input.into());
            self
        }
        /// <p>The name of a database that <code>DbUser</code> is authorized to log on to. If <code>DbName</code> is not specified, <code>DbUser</code> can log on to any existing database.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be 1 to 64 alphanumeric characters or hyphens</p> </li>
        /// <li> <p>Must contain only lowercase letters, numbers, underscore, plus sign, period (dot), at symbol (@), or hyphen.</p> </li>
        /// <li> <p>First character must be a letter.</p> </li>
        /// <li> <p>Must not contain a colon ( : ) or slash ( / ). </p> </li>
        /// <li> <p>Cannot be a reserved word. A list of reserved words can be found in <a href="http://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html">Reserved Words</a> in the Amazon Redshift Database Developer Guide.</p> </li>
        /// </ul>
        pub fn set_db_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_db_name(input);
            self
        }
        /// <p>The unique identifier of the cluster that contains the database for which your are requesting credentials. This parameter is case sensitive.</p>
        pub fn cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_identifier(input.into());
            self
        }
        /// <p>The unique identifier of the cluster that contains the database for which your are requesting credentials. This parameter is case sensitive.</p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_identifier(input);
            self
        }
        /// <p>The number of seconds until the returned temporary password expires.</p>
        /// <p>Constraint: minimum 900, maximum 3600.</p>
        /// <p>Default: 900</p>
        pub fn duration_seconds(mut self, input: i32) -> Self {
            self.inner = self.inner.duration_seconds(input);
            self
        }
        /// <p>The number of seconds until the returned temporary password expires.</p>
        /// <p>Constraint: minimum 900, maximum 3600.</p>
        /// <p>Default: 900</p>
        pub fn set_duration_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_duration_seconds(input);
            self
        }
        /// <p>Create a database user with the name specified for the user named in <code>DbUser</code> if one does not exist.</p>
        pub fn auto_create(mut self, input: bool) -> Self {
            self.inner = self.inner.auto_create(input);
            self
        }
        /// <p>Create a database user with the name specified for the user named in <code>DbUser</code> if one does not exist.</p>
        pub fn set_auto_create(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_auto_create(input);
            self
        }
        /// Appends an item to `DbGroups`.
        ///
        /// To override the contents of this collection use [`set_db_groups`](Self::set_db_groups).
        ///
        /// <p>A list of the names of existing database groups that the user named in <code>DbUser</code> will join for the current session, in addition to any group memberships for an existing user. If not specified, a new user is added only to PUBLIC.</p>
        /// <p>Database group name constraints</p>
        /// <ul>
        /// <li> <p>Must be 1 to 64 alphanumeric characters or hyphens</p> </li>
        /// <li> <p>Must contain only lowercase letters, numbers, underscore, plus sign, period (dot), at symbol (@), or hyphen.</p> </li>
        /// <li> <p>First character must be a letter.</p> </li>
        /// <li> <p>Must not contain a colon ( : ) or slash ( / ). </p> </li>
        /// <li> <p>Cannot be a reserved word. A list of reserved words can be found in <a href="http://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html">Reserved Words</a> in the Amazon Redshift Database Developer Guide.</p> </li>
        /// </ul>
        pub fn db_groups(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_groups(input.into());
            self
        }
        /// <p>A list of the names of existing database groups that the user named in <code>DbUser</code> will join for the current session, in addition to any group memberships for an existing user. If not specified, a new user is added only to PUBLIC.</p>
        /// <p>Database group name constraints</p>
        /// <ul>
        /// <li> <p>Must be 1 to 64 alphanumeric characters or hyphens</p> </li>
        /// <li> <p>Must contain only lowercase letters, numbers, underscore, plus sign, period (dot), at symbol (@), or hyphen.</p> </li>
        /// <li> <p>First character must be a letter.</p> </li>
        /// <li> <p>Must not contain a colon ( : ) or slash ( / ). </p> </li>
        /// <li> <p>Cannot be a reserved word. A list of reserved words can be found in <a href="http://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html">Reserved Words</a> in the Amazon Redshift Database Developer Guide.</p> </li>
        /// </ul>
        pub fn set_db_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_db_groups(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetReservedNodeExchangeConfigurationOptions`.
    ///
    /// <p>Gets the configuration options for the reserved-node exchange. These options include information about the source reserved node and target reserved node offering. Details include the node type, the price, the node count, and the offering type.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetReservedNodeExchangeConfigurationOptions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_reserved_node_exchange_configuration_options_input::Builder,
    }
    impl GetReservedNodeExchangeConfigurationOptions {
        /// Creates a new `GetReservedNodeExchangeConfigurationOptions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetReservedNodeExchangeConfigurationOptionsOutput,
            aws_smithy_http::result::SdkError<
                crate::error::GetReservedNodeExchangeConfigurationOptionsError,
            >,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetReservedNodeExchangeConfigurationOptionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::GetReservedNodeExchangeConfigurationOptionsPaginator {
            crate::paginator::GetReservedNodeExchangeConfigurationOptionsPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p>The action type of the reserved-node configuration. The action type can be an exchange initiated from either a snapshot or a resize.</p>
        pub fn action_type(mut self, input: crate::model::ReservedNodeExchangeActionType) -> Self {
            self.inner = self.inner.action_type(input);
            self
        }
        /// <p>The action type of the reserved-node configuration. The action type can be an exchange initiated from either a snapshot or a resize.</p>
        pub fn set_action_type(
            mut self,
            input: std::option::Option<crate::model::ReservedNodeExchangeActionType>,
        ) -> Self {
            self.inner = self.inner.set_action_type(input);
            self
        }
        /// <p>The identifier for the cluster that is the source for a reserved-node exchange.</p>
        pub fn cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_identifier(input.into());
            self
        }
        /// <p>The identifier for the cluster that is the source for a reserved-node exchange.</p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_identifier(input);
            self
        }
        /// <p>The identifier for the snapshot that is the source for the reserved-node exchange.</p>
        pub fn snapshot_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.snapshot_identifier(input.into());
            self
        }
        /// <p>The identifier for the snapshot that is the source for the reserved-node exchange.</p>
        pub fn set_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_snapshot_identifier(input);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>Marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.inner = self.inner.max_records(input);
            self
        }
        /// <p>The maximum number of response records to return in each call. If the number of remaining response records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>Marker</code> field of the response. You can retrieve the next set of records by retrying the command with the returned marker value.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>An optional pagination token provided by a previous <code>GetReservedNodeExchangeConfigurationOptions</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by the <code>MaxRecords</code> parameter. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>An optional pagination token provided by a previous <code>GetReservedNodeExchangeConfigurationOptions</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by the <code>MaxRecords</code> parameter. You can retrieve the next set of response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetReservedNodeExchangeOfferings`.
    ///
    /// <p>Returns an array of DC2 ReservedNodeOfferings that matches the payment type, term, and usage price of the given DC1 reserved node.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetReservedNodeExchangeOfferings {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_reserved_node_exchange_offerings_input::Builder,
    }
    impl GetReservedNodeExchangeOfferings {
        /// Creates a new `GetReservedNodeExchangeOfferings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetReservedNodeExchangeOfferingsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetReservedNodeExchangeOfferingsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetReservedNodeExchangeOfferingsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetReservedNodeExchangeOfferingsPaginator {
            crate::paginator::GetReservedNodeExchangeOfferingsPaginator::new(
                self.handle,
                self.inner,
            )
        }
        /// <p>A string representing the node identifier for the DC1 Reserved Node to be exchanged.</p>
        pub fn reserved_node_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.reserved_node_id(input.into());
            self
        }
        /// <p>A string representing the node identifier for the DC1 Reserved Node to be exchanged.</p>
        pub fn set_reserved_node_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_reserved_node_id(input);
            self
        }
        /// <p>An integer setting the maximum number of ReservedNodeOfferings to retrieve.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.inner = self.inner.max_records(input);
            self
        }
        /// <p>An integer setting the maximum number of ReservedNodeOfferings to retrieve.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_records(input);
            self
        }
        /// <p>A value that indicates the starting point for the next set of ReservedNodeOfferings.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.marker(input.into());
            self
        }
        /// <p>A value that indicates the starting point for the next set of ReservedNodeOfferings.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_marker(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyAquaConfiguration`.
    ///
    /// <p>Modifies whether a cluster can use AQUA (Advanced Query Accelerator). </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ModifyAquaConfiguration {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::modify_aqua_configuration_input::Builder,
    }
    impl ModifyAquaConfiguration {
        /// Creates a new `ModifyAquaConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyAquaConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifyAquaConfigurationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the cluster to be modified.</p>
        pub fn cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_identifier(input.into());
            self
        }
        /// <p>The identifier of the cluster to be modified.</p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_identifier(input);
            self
        }
        /// <p>The new value of AQUA configuration status. Possible values include the following.</p>
        /// <ul>
        /// <li> <p>enabled - Use AQUA if it is available for the current Amazon Web Services Region and Amazon Redshift node type.</p> </li>
        /// <li> <p>disabled - Don't use AQUA. </p> </li>
        /// <li> <p>auto - Amazon Redshift determines whether to use AQUA.</p> </li>
        /// </ul>
        pub fn aqua_configuration_status(
            mut self,
            input: crate::model::AquaConfigurationStatus,
        ) -> Self {
            self.inner = self.inner.aqua_configuration_status(input);
            self
        }
        /// <p>The new value of AQUA configuration status. Possible values include the following.</p>
        /// <ul>
        /// <li> <p>enabled - Use AQUA if it is available for the current Amazon Web Services Region and Amazon Redshift node type.</p> </li>
        /// <li> <p>disabled - Don't use AQUA. </p> </li>
        /// <li> <p>auto - Amazon Redshift determines whether to use AQUA.</p> </li>
        /// </ul>
        pub fn set_aqua_configuration_status(
            mut self,
            input: std::option::Option<crate::model::AquaConfigurationStatus>,
        ) -> Self {
            self.inner = self.inner.set_aqua_configuration_status(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyAuthenticationProfile`.
    ///
    /// <p>Modifies an authentication profile.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ModifyAuthenticationProfile {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::modify_authentication_profile_input::Builder,
    }
    impl ModifyAuthenticationProfile {
        /// Creates a new `ModifyAuthenticationProfile`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyAuthenticationProfileOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifyAuthenticationProfileError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the authentication profile to replace.</p>
        pub fn authentication_profile_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.authentication_profile_name(input.into());
            self
        }
        /// <p>The name of the authentication profile to replace.</p>
        pub fn set_authentication_profile_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_authentication_profile_name(input);
            self
        }
        /// <p>The new content of the authentication profile in JSON format. The maximum length of the JSON string is determined by a quota for your account.</p>
        pub fn authentication_profile_content(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.authentication_profile_content(input.into());
            self
        }
        /// <p>The new content of the authentication profile in JSON format. The maximum length of the JSON string is determined by a quota for your account.</p>
        pub fn set_authentication_profile_content(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_authentication_profile_content(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyCluster`.
    ///
    /// <p>Modifies the settings for a cluster.</p>
    /// <p>You can also change node type and the number of nodes to scale up or down the cluster. When resizing a cluster, you must specify both the number of nodes and the node type even if one of the parameters does not change.</p>
    /// <p>You can add another security or parameter group, or change the admin user password. Resetting a cluster password or modifying the security groups associated with a cluster do not need a reboot. However, modifying a parameter group requires a reboot for parameters to take effect. For more information about managing clusters, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html">Amazon Redshift Clusters</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ModifyCluster {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::modify_cluster_input::Builder,
    }
    impl ModifyCluster {
        /// Creates a new `ModifyCluster`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyClusterOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifyClusterError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the cluster to be modified.</p>
        /// <p>Example: <code>examplecluster</code> </p>
        pub fn cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_identifier(input.into());
            self
        }
        /// <p>The unique identifier of the cluster to be modified.</p>
        /// <p>Example: <code>examplecluster</code> </p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_identifier(input);
            self
        }
        /// <p>The new cluster type.</p>
        /// <p>When you submit your cluster resize request, your existing cluster goes into a read-only mode. After Amazon Redshift provisions a new cluster based on your resize requirements, there will be outage for a period while the old cluster is deleted and your connection is switched to the new cluster. You can use <code>DescribeResize</code> to track the progress of the resize request. </p>
        /// <p>Valid Values: <code> multi-node | single-node </code> </p>
        pub fn cluster_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_type(input.into());
            self
        }
        /// <p>The new cluster type.</p>
        /// <p>When you submit your cluster resize request, your existing cluster goes into a read-only mode. After Amazon Redshift provisions a new cluster based on your resize requirements, there will be outage for a period while the old cluster is deleted and your connection is switched to the new cluster. You can use <code>DescribeResize</code> to track the progress of the resize request. </p>
        /// <p>Valid Values: <code> multi-node | single-node </code> </p>
        pub fn set_cluster_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cluster_type(input);
            self
        }
        /// <p>The new node type of the cluster. If you specify a new node type, you must also specify the number of nodes parameter.</p>
        /// <p> For more information about resizing clusters, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/rs-resize-tutorial.html">Resizing Clusters in Amazon Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</p>
        /// <p>Valid Values: <code>ds2.xlarge</code> | <code>ds2.8xlarge</code> | <code>dc1.large</code> | <code>dc1.8xlarge</code> | <code>dc2.large</code> | <code>dc2.8xlarge</code> | <code>ra3.xlplus</code> | <code>ra3.4xlarge</code> | <code>ra3.16xlarge</code> </p>
        pub fn node_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.node_type(input.into());
            self
        }
        /// <p>The new node type of the cluster. If you specify a new node type, you must also specify the number of nodes parameter.</p>
        /// <p> For more information about resizing clusters, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/rs-resize-tutorial.html">Resizing Clusters in Amazon Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</p>
        /// <p>Valid Values: <code>ds2.xlarge</code> | <code>ds2.8xlarge</code> | <code>dc1.large</code> | <code>dc1.8xlarge</code> | <code>dc2.large</code> | <code>dc2.8xlarge</code> | <code>ra3.xlplus</code> | <code>ra3.4xlarge</code> | <code>ra3.16xlarge</code> </p>
        pub fn set_node_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_node_type(input);
            self
        }
        /// <p>The new number of nodes of the cluster. If you specify a new number of nodes, you must also specify the node type parameter.</p>
        /// <p> For more information about resizing clusters, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/rs-resize-tutorial.html">Resizing Clusters in Amazon Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</p>
        /// <p>Valid Values: Integer greater than <code>0</code>.</p>
        pub fn number_of_nodes(mut self, input: i32) -> Self {
            self.inner = self.inner.number_of_nodes(input);
            self
        }
        /// <p>The new number of nodes of the cluster. If you specify a new number of nodes, you must also specify the node type parameter.</p>
        /// <p> For more information about resizing clusters, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/rs-resize-tutorial.html">Resizing Clusters in Amazon Redshift</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</p>
        /// <p>Valid Values: Integer greater than <code>0</code>.</p>
        pub fn set_number_of_nodes(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_number_of_nodes(input);
            self
        }
        /// Appends an item to `ClusterSecurityGroups`.
        ///
        /// To override the contents of this collection use [`set_cluster_security_groups`](Self::set_cluster_security_groups).
        ///
        /// <p>A list of cluster security groups to be authorized on this cluster. This change is asynchronously applied as soon as possible.</p>
        /// <p>Security groups currently associated with the cluster, and not in the list of groups to apply, will be revoked from the cluster.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be 1 to 255 alphanumeric characters or hyphens</p> </li>
        /// <li> <p>First character must be a letter</p> </li>
        /// <li> <p>Cannot end with a hyphen or contain two consecutive hyphens</p> </li>
        /// </ul>
        pub fn cluster_security_groups(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_security_groups(input.into());
            self
        }
        /// <p>A list of cluster security groups to be authorized on this cluster. This change is asynchronously applied as soon as possible.</p>
        /// <p>Security groups currently associated with the cluster, and not in the list of groups to apply, will be revoked from the cluster.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be 1 to 255 alphanumeric characters or hyphens</p> </li>
        /// <li> <p>First character must be a letter</p> </li>
        /// <li> <p>Cannot end with a hyphen or contain two consecutive hyphens</p> </li>
        /// </ul>
        pub fn set_cluster_security_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_cluster_security_groups(input);
            self
        }
        /// Appends an item to `VpcSecurityGroupIds`.
        ///
        /// To override the contents of this collection use [`set_vpc_security_group_ids`](Self::set_vpc_security_group_ids).
        ///
        /// <p>A list of virtual private cloud (VPC) security groups to be associated with the cluster. This change is asynchronously applied as soon as possible.</p>
        pub fn vpc_security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc_security_group_ids(input.into());
            self
        }
        /// <p>A list of virtual private cloud (VPC) security groups to be associated with the cluster. This change is asynchronously applied as soon as possible.</p>
        pub fn set_vpc_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_vpc_security_group_ids(input);
            self
        }
        /// <p>The new password for the cluster admin user. This change is asynchronously applied as soon as possible. Between the time of the request and the completion of the request, the <code>MasterUserPassword</code> element exists in the <code>PendingModifiedValues</code> element of the operation response. </p> <note>
        /// <p>Operations never return the password, so this operation provides a way to regain access to the admin user account for a cluster if the password is lost.</p>
        /// </note>
        /// <p>Default: Uses existing setting.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be between 8 and 64 characters in length.</p> </li>
        /// <li> <p>Must contain at least one uppercase letter.</p> </li>
        /// <li> <p>Must contain at least one lowercase letter.</p> </li>
        /// <li> <p>Must contain one number.</p> </li>
        /// <li> <p>Can be any printable ASCII character (ASCII code 33-126) except ' (single quote), " (double quote), \, /, or @.</p> </li>
        /// </ul>
        pub fn master_user_password(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.master_user_password(input.into());
            self
        }
        /// <p>The new password for the cluster admin user. This change is asynchronously applied as soon as possible. Between the time of the request and the completion of the request, the <code>MasterUserPassword</code> element exists in the <code>PendingModifiedValues</code> element of the operation response. </p> <note>
        /// <p>Operations never return the password, so this operation provides a way to regain access to the admin user account for a cluster if the password is lost.</p>
        /// </note>
        /// <p>Default: Uses existing setting.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be between 8 and 64 characters in length.</p> </li>
        /// <li> <p>Must contain at least one uppercase letter.</p> </li>
        /// <li> <p>Must contain at least one lowercase letter.</p> </li>
        /// <li> <p>Must contain one number.</p> </li>
        /// <li> <p>Can be any printable ASCII character (ASCII code 33-126) except ' (single quote), " (double quote), \, /, or @.</p> </li>
        /// </ul>
        pub fn set_master_user_password(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_master_user_password(input);
            self
        }
        /// <p>The name of the cluster parameter group to apply to this cluster. This change is applied only after the cluster is rebooted. To reboot a cluster use <code>RebootCluster</code>. </p>
        /// <p>Default: Uses existing setting.</p>
        /// <p>Constraints: The cluster parameter group must be in the same parameter group family that matches the cluster version.</p>
        pub fn cluster_parameter_group_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.cluster_parameter_group_name(input.into());
            self
        }
        /// <p>The name of the cluster parameter group to apply to this cluster. This change is applied only after the cluster is rebooted. To reboot a cluster use <code>RebootCluster</code>. </p>
        /// <p>Default: Uses existing setting.</p>
        /// <p>Constraints: The cluster parameter group must be in the same parameter group family that matches the cluster version.</p>
        pub fn set_cluster_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_parameter_group_name(input);
            self
        }
        /// <p>The number of days that automated snapshots are retained. If the value is 0, automated snapshots are disabled. Even if automated snapshots are disabled, you can still create manual snapshots when you want with <code>CreateClusterSnapshot</code>. </p>
        /// <p>If you decrease the automated snapshot retention period from its current value, existing automated snapshots that fall outside of the new retention period will be immediately deleted.</p>
        /// <p>You can't disable automated snapshots for RA3 node types. Set the automated retention period from 1-35 days.</p>
        /// <p>Default: Uses existing setting.</p>
        /// <p>Constraints: Must be a value from 0 to 35.</p>
        pub fn automated_snapshot_retention_period(mut self, input: i32) -> Self {
            self.inner = self.inner.automated_snapshot_retention_period(input);
            self
        }
        /// <p>The number of days that automated snapshots are retained. If the value is 0, automated snapshots are disabled. Even if automated snapshots are disabled, you can still create manual snapshots when you want with <code>CreateClusterSnapshot</code>. </p>
        /// <p>If you decrease the automated snapshot retention period from its current value, existing automated snapshots that fall outside of the new retention period will be immediately deleted.</p>
        /// <p>You can't disable automated snapshots for RA3 node types. Set the automated retention period from 1-35 days.</p>
        /// <p>Default: Uses existing setting.</p>
        /// <p>Constraints: Must be a value from 0 to 35.</p>
        pub fn set_automated_snapshot_retention_period(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.inner = self.inner.set_automated_snapshot_retention_period(input);
            self
        }
        /// <p>The default for number of days that a newly created manual snapshot is retained. If the value is -1, the manual snapshot is retained indefinitely. This value doesn't retroactively change the retention periods of existing manual snapshots.</p>
        /// <p>The value must be either -1 or an integer between 1 and 3,653.</p>
        /// <p>The default value is -1.</p>
        pub fn manual_snapshot_retention_period(mut self, input: i32) -> Self {
            self.inner = self.inner.manual_snapshot_retention_period(input);
            self
        }
        /// <p>The default for number of days that a newly created manual snapshot is retained. If the value is -1, the manual snapshot is retained indefinitely. This value doesn't retroactively change the retention periods of existing manual snapshots.</p>
        /// <p>The value must be either -1 or an integer between 1 and 3,653.</p>
        /// <p>The default value is -1.</p>
        pub fn set_manual_snapshot_retention_period(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.inner = self.inner.set_manual_snapshot_retention_period(input);
            self
        }
        /// <p>The weekly time range (in UTC) during which system maintenance can occur, if necessary. If system maintenance is necessary during the window, it may result in an outage.</p>
        /// <p>This maintenance window change is made immediately. If the new maintenance window indicates the current time, there must be at least 120 minutes between the current time and end of the window in order to ensure that pending changes are applied.</p>
        /// <p>Default: Uses existing setting.</p>
        /// <p>Format: ddd:hh24:mi-ddd:hh24:mi, for example <code>wed:07:30-wed:08:00</code>.</p>
        /// <p>Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun</p>
        /// <p>Constraints: Must be at least 30 minutes.</p>
        pub fn preferred_maintenance_window(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.preferred_maintenance_window(input.into());
            self
        }
        /// <p>The weekly time range (in UTC) during which system maintenance can occur, if necessary. If system maintenance is necessary during the window, it may result in an outage.</p>
        /// <p>This maintenance window change is made immediately. If the new maintenance window indicates the current time, there must be at least 120 minutes between the current time and end of the window in order to ensure that pending changes are applied.</p>
        /// <p>Default: Uses existing setting.</p>
        /// <p>Format: ddd:hh24:mi-ddd:hh24:mi, for example <code>wed:07:30-wed:08:00</code>.</p>
        /// <p>Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun</p>
        /// <p>Constraints: Must be at least 30 minutes.</p>
        pub fn set_preferred_maintenance_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_preferred_maintenance_window(input);
            self
        }
        /// <p>The new version number of the Amazon Redshift engine to upgrade to.</p>
        /// <p>For major version upgrades, if a non-default cluster parameter group is currently in use, a new cluster parameter group in the cluster parameter group family for the new version must be specified. The new cluster parameter group can be the default for that cluster parameter group family. For more information about parameters and parameter groups, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Amazon Redshift Parameter Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</p>
        /// <p>Example: <code>1.0</code> </p>
        pub fn cluster_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_version(input.into());
            self
        }
        /// <p>The new version number of the Amazon Redshift engine to upgrade to.</p>
        /// <p>For major version upgrades, if a non-default cluster parameter group is currently in use, a new cluster parameter group in the cluster parameter group family for the new version must be specified. The new cluster parameter group can be the default for that cluster parameter group family. For more information about parameters and parameter groups, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Amazon Redshift Parameter Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</p>
        /// <p>Example: <code>1.0</code> </p>
        pub fn set_cluster_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_version(input);
            self
        }
        /// <p>If <code>true</code>, major version upgrades will be applied automatically to the cluster during the maintenance window. </p>
        /// <p>Default: <code>false</code> </p>
        pub fn allow_version_upgrade(mut self, input: bool) -> Self {
            self.inner = self.inner.allow_version_upgrade(input);
            self
        }
        /// <p>If <code>true</code>, major version upgrades will be applied automatically to the cluster during the maintenance window. </p>
        /// <p>Default: <code>false</code> </p>
        pub fn set_allow_version_upgrade(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_allow_version_upgrade(input);
            self
        }
        /// <p>Specifies the name of the HSM client certificate the Amazon Redshift cluster uses to retrieve the data encryption keys stored in an HSM.</p>
        pub fn hsm_client_certificate_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.hsm_client_certificate_identifier(input.into());
            self
        }
        /// <p>Specifies the name of the HSM client certificate the Amazon Redshift cluster uses to retrieve the data encryption keys stored in an HSM.</p>
        pub fn set_hsm_client_certificate_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_hsm_client_certificate_identifier(input);
            self
        }
        /// <p>Specifies the name of the HSM configuration that contains the information the Amazon Redshift cluster can use to retrieve and store keys in an HSM.</p>
        pub fn hsm_configuration_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.hsm_configuration_identifier(input.into());
            self
        }
        /// <p>Specifies the name of the HSM configuration that contains the information the Amazon Redshift cluster can use to retrieve and store keys in an HSM.</p>
        pub fn set_hsm_configuration_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_hsm_configuration_identifier(input);
            self
        }
        /// <p>The new identifier for the cluster.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must contain from 1 to 63 alphanumeric characters or hyphens.</p> </li>
        /// <li> <p>Alphabetic characters must be lowercase.</p> </li>
        /// <li> <p>First character must be a letter.</p> </li>
        /// <li> <p>Cannot end with a hyphen or contain two consecutive hyphens.</p> </li>
        /// <li> <p>Must be unique for all clusters within an Amazon Web Services account.</p> </li>
        /// </ul>
        /// <p>Example: <code>examplecluster</code> </p>
        pub fn new_cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.new_cluster_identifier(input.into());
            self
        }
        /// <p>The new identifier for the cluster.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must contain from 1 to 63 alphanumeric characters or hyphens.</p> </li>
        /// <li> <p>Alphabetic characters must be lowercase.</p> </li>
        /// <li> <p>First character must be a letter.</p> </li>
        /// <li> <p>Cannot end with a hyphen or contain two consecutive hyphens.</p> </li>
        /// <li> <p>Must be unique for all clusters within an Amazon Web Services account.</p> </li>
        /// </ul>
        /// <p>Example: <code>examplecluster</code> </p>
        pub fn set_new_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_new_cluster_identifier(input);
            self
        }
        /// <p>If <code>true</code>, the cluster can be accessed from a public network. Only clusters in VPCs can be set to be publicly available.</p>
        pub fn publicly_accessible(mut self, input: bool) -> Self {
            self.inner = self.inner.publicly_accessible(input);
            self
        }
        /// <p>If <code>true</code>, the cluster can be accessed from a public network. Only clusters in VPCs can be set to be publicly available.</p>
        pub fn set_publicly_accessible(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_publicly_accessible(input);
            self
        }
        /// <p>The Elastic IP (EIP) address for the cluster.</p>
        /// <p>Constraints: The cluster must be provisioned in EC2-VPC and publicly-accessible through an Internet gateway. For more information about provisioning clusters in EC2-VPC, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#cluster-platforms">Supported Platforms to Launch Your Cluster</a> in the Amazon Redshift Cluster Management Guide.</p>
        pub fn elastic_ip(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.elastic_ip(input.into());
            self
        }
        /// <p>The Elastic IP (EIP) address for the cluster.</p>
        /// <p>Constraints: The cluster must be provisioned in EC2-VPC and publicly-accessible through an Internet gateway. For more information about provisioning clusters in EC2-VPC, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#cluster-platforms">Supported Platforms to Launch Your Cluster</a> in the Amazon Redshift Cluster Management Guide.</p>
        pub fn set_elastic_ip(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_elastic_ip(input);
            self
        }
        /// <p>An option that specifies whether to create the cluster with enhanced VPC routing enabled. To create a cluster that uses enhanced VPC routing, the cluster must be in a VPC. For more information, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html">Enhanced VPC Routing</a> in the Amazon Redshift Cluster Management Guide.</p>
        /// <p>If this option is <code>true</code>, enhanced VPC routing is enabled. </p>
        /// <p>Default: false</p>
        pub fn enhanced_vpc_routing(mut self, input: bool) -> Self {
            self.inner = self.inner.enhanced_vpc_routing(input);
            self
        }
        /// <p>An option that specifies whether to create the cluster with enhanced VPC routing enabled. To create a cluster that uses enhanced VPC routing, the cluster must be in a VPC. For more information, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html">Enhanced VPC Routing</a> in the Amazon Redshift Cluster Management Guide.</p>
        /// <p>If this option is <code>true</code>, enhanced VPC routing is enabled. </p>
        /// <p>Default: false</p>
        pub fn set_enhanced_vpc_routing(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enhanced_vpc_routing(input);
            self
        }
        /// <p>The name for the maintenance track that you want to assign for the cluster. This name change is asynchronous. The new track name stays in the <code>PendingModifiedValues</code> for the cluster until the next maintenance window. When the maintenance track changes, the cluster is switched to the latest cluster release available for the maintenance track. At this point, the maintenance track name is applied.</p>
        pub fn maintenance_track_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.maintenance_track_name(input.into());
            self
        }
        /// <p>The name for the maintenance track that you want to assign for the cluster. This name change is asynchronous. The new track name stays in the <code>PendingModifiedValues</code> for the cluster until the next maintenance window. When the maintenance track changes, the cluster is switched to the latest cluster release available for the maintenance track. At this point, the maintenance track name is applied.</p>
        pub fn set_maintenance_track_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_maintenance_track_name(input);
            self
        }
        /// <p>Indicates whether the cluster is encrypted. If the value is encrypted (true) and you provide a value for the <code>KmsKeyId</code> parameter, we encrypt the cluster with the provided <code>KmsKeyId</code>. If you don't provide a <code>KmsKeyId</code>, we encrypt with the default key. </p>
        /// <p>If the value is not encrypted (false), then the cluster is decrypted. </p>
        pub fn encrypted(mut self, input: bool) -> Self {
            self.inner = self.inner.encrypted(input);
            self
        }
        /// <p>Indicates whether the cluster is encrypted. If the value is encrypted (true) and you provide a value for the <code>KmsKeyId</code> parameter, we encrypt the cluster with the provided <code>KmsKeyId</code>. If you don't provide a <code>KmsKeyId</code>, we encrypt with the default key. </p>
        /// <p>If the value is not encrypted (false), then the cluster is decrypted. </p>
        pub fn set_encrypted(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_encrypted(input);
            self
        }
        /// <p>The Key Management Service (KMS) key ID of the encryption key that you want to use to encrypt data in the cluster.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key_id(input.into());
            self
        }
        /// <p>The Key Management Service (KMS) key ID of the encryption key that you want to use to encrypt data in the cluster.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key_id(input);
            self
        }
        /// <p>The option to enable relocation for an Amazon Redshift cluster between Availability Zones after the cluster modification is complete.</p>
        pub fn availability_zone_relocation(mut self, input: bool) -> Self {
            self.inner = self.inner.availability_zone_relocation(input);
            self
        }
        /// <p>The option to enable relocation for an Amazon Redshift cluster between Availability Zones after the cluster modification is complete.</p>
        pub fn set_availability_zone_relocation(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_availability_zone_relocation(input);
            self
        }
        /// <p>The option to initiate relocation for an Amazon Redshift cluster to the target Availability Zone.</p>
        pub fn availability_zone(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.availability_zone(input.into());
            self
        }
        /// <p>The option to initiate relocation for an Amazon Redshift cluster to the target Availability Zone.</p>
        pub fn set_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_availability_zone(input);
            self
        }
        /// <p>The option to change the port of an Amazon Redshift cluster.</p>
        pub fn port(mut self, input: i32) -> Self {
            self.inner = self.inner.port(input);
            self
        }
        /// <p>The option to change the port of an Amazon Redshift cluster.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_port(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyClusterDbRevision`.
    ///
    /// <p>Modifies the database revision of a cluster. The database revision is a unique revision of the database running in a cluster.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ModifyClusterDbRevision {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::modify_cluster_db_revision_input::Builder,
    }
    impl ModifyClusterDbRevision {
        /// Creates a new `ModifyClusterDbRevision`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyClusterDbRevisionOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifyClusterDbRevisionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of a cluster whose database revision you want to modify. </p>
        /// <p>Example: <code>examplecluster</code> </p>
        pub fn cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_identifier(input.into());
            self
        }
        /// <p>The unique identifier of a cluster whose database revision you want to modify. </p>
        /// <p>Example: <code>examplecluster</code> </p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_identifier(input);
            self
        }
        /// <p>The identifier of the database revision. You can retrieve this value from the response to the <code>DescribeClusterDbRevisions</code> request.</p>
        pub fn revision_target(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.revision_target(input.into());
            self
        }
        /// <p>The identifier of the database revision. You can retrieve this value from the response to the <code>DescribeClusterDbRevisions</code> request.</p>
        pub fn set_revision_target(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_revision_target(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyClusterIamRoles`.
    ///
    /// <p>Modifies the list of Identity and Access Management (IAM) roles that can be used by the cluster to access other Amazon Web Services services.</p>
    /// <p>The maximum number of IAM roles that you can associate is subject to a quota. For more information, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/amazon-redshift-limits.html">Quotas and limits</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ModifyClusterIamRoles {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::modify_cluster_iam_roles_input::Builder,
    }
    impl ModifyClusterIamRoles {
        /// Creates a new `ModifyClusterIamRoles`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyClusterIamRolesOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifyClusterIamRolesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the cluster for which you want to associate or disassociate IAM roles.</p>
        pub fn cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_identifier(input.into());
            self
        }
        /// <p>The unique identifier of the cluster for which you want to associate or disassociate IAM roles.</p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_identifier(input);
            self
        }
        /// Appends an item to `AddIamRoles`.
        ///
        /// To override the contents of this collection use [`set_add_iam_roles`](Self::set_add_iam_roles).
        ///
        /// <p>Zero or more IAM roles to associate with the cluster. The roles must be in their Amazon Resource Name (ARN) format. </p>
        pub fn add_iam_roles(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.add_iam_roles(input.into());
            self
        }
        /// <p>Zero or more IAM roles to associate with the cluster. The roles must be in their Amazon Resource Name (ARN) format. </p>
        pub fn set_add_iam_roles(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_add_iam_roles(input);
            self
        }
        /// Appends an item to `RemoveIamRoles`.
        ///
        /// To override the contents of this collection use [`set_remove_iam_roles`](Self::set_remove_iam_roles).
        ///
        /// <p>Zero or more IAM roles in ARN format to disassociate from the cluster. </p>
        pub fn remove_iam_roles(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.remove_iam_roles(input.into());
            self
        }
        /// <p>Zero or more IAM roles in ARN format to disassociate from the cluster. </p>
        pub fn set_remove_iam_roles(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_remove_iam_roles(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the IAM role that was set as default for the cluster when the cluster was last modified.</p>
        pub fn default_iam_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.default_iam_role_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the IAM role that was set as default for the cluster when the cluster was last modified.</p>
        pub fn set_default_iam_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_default_iam_role_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyClusterMaintenance`.
    ///
    /// <p>Modifies the maintenance settings of a cluster.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ModifyClusterMaintenance {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::modify_cluster_maintenance_input::Builder,
    }
    impl ModifyClusterMaintenance {
        /// Creates a new `ModifyClusterMaintenance`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyClusterMaintenanceOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifyClusterMaintenanceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique identifier for the cluster.</p>
        pub fn cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_identifier(input.into());
            self
        }
        /// <p>A unique identifier for the cluster.</p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_identifier(input);
            self
        }
        /// <p>A boolean indicating whether to enable the deferred maintenance window. </p>
        pub fn defer_maintenance(mut self, input: bool) -> Self {
            self.inner = self.inner.defer_maintenance(input);
            self
        }
        /// <p>A boolean indicating whether to enable the deferred maintenance window. </p>
        pub fn set_defer_maintenance(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_defer_maintenance(input);
            self
        }
        /// <p>A unique identifier for the deferred maintenance window.</p>
        pub fn defer_maintenance_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.defer_maintenance_identifier(input.into());
            self
        }
        /// <p>A unique identifier for the deferred maintenance window.</p>
        pub fn set_defer_maintenance_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_defer_maintenance_identifier(input);
            self
        }
        /// <p>A timestamp indicating the start time for the deferred maintenance window.</p>
        pub fn defer_maintenance_start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.defer_maintenance_start_time(input);
            self
        }
        /// <p>A timestamp indicating the start time for the deferred maintenance window.</p>
        pub fn set_defer_maintenance_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_defer_maintenance_start_time(input);
            self
        }
        /// <p>A timestamp indicating end time for the deferred maintenance window. If you specify an end time, you can't specify a duration.</p>
        pub fn defer_maintenance_end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.defer_maintenance_end_time(input);
            self
        }
        /// <p>A timestamp indicating end time for the deferred maintenance window. If you specify an end time, you can't specify a duration.</p>
        pub fn set_defer_maintenance_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_defer_maintenance_end_time(input);
            self
        }
        /// <p>An integer indicating the duration of the maintenance window in days. If you specify a duration, you can't specify an end time. The duration must be 45 days or less.</p>
        pub fn defer_maintenance_duration(mut self, input: i32) -> Self {
            self.inner = self.inner.defer_maintenance_duration(input);
            self
        }
        /// <p>An integer indicating the duration of the maintenance window in days. If you specify a duration, you can't specify an end time. The duration must be 45 days or less.</p>
        pub fn set_defer_maintenance_duration(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_defer_maintenance_duration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyClusterParameterGroup`.
    ///
    /// <p>Modifies the parameters of a parameter group. For the parameters parameter, it can't contain ASCII characters.</p>
    /// <p> For more information about parameters and parameter groups, go to <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Amazon Redshift Parameter Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ModifyClusterParameterGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::modify_cluster_parameter_group_input::Builder,
    }
    impl ModifyClusterParameterGroup {
        /// Creates a new `ModifyClusterParameterGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyClusterParameterGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifyClusterParameterGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the parameter group to be modified.</p>
        pub fn parameter_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.parameter_group_name(input.into());
            self
        }
        /// <p>The name of the parameter group to be modified.</p>
        pub fn set_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_parameter_group_name(input);
            self
        }
        /// Appends an item to `Parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>An array of parameters to be modified. A maximum of 20 parameters can be modified in a single request.</p>
        /// <p>For each parameter to be modified, you must supply at least the parameter name and parameter value; other name-value pairs of the parameter are optional.</p>
        /// <p>For the workload management (WLM) configuration, you must supply all the name-value pairs in the wlm_json_configuration parameter.</p>
        pub fn parameters(mut self, input: crate::model::Parameter) -> Self {
            self.inner = self.inner.parameters(input);
            self
        }
        /// <p>An array of parameters to be modified. A maximum of 20 parameters can be modified in a single request.</p>
        /// <p>For each parameter to be modified, you must supply at least the parameter name and parameter value; other name-value pairs of the parameter are optional.</p>
        /// <p>For the workload management (WLM) configuration, you must supply all the name-value pairs in the wlm_json_configuration parameter.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
        ) -> Self {
            self.inner = self.inner.set_parameters(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyClusterSnapshot`.
    ///
    /// <p>Modifies the settings for a snapshot.</p>
    /// <p>This exanmple modifies the manual retention period setting for a cluster snapshot.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ModifyClusterSnapshot {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::modify_cluster_snapshot_input::Builder,
    }
    impl ModifyClusterSnapshot {
        /// Creates a new `ModifyClusterSnapshot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyClusterSnapshotOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifyClusterSnapshotError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the snapshot whose setting you want to modify.</p>
        pub fn snapshot_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.snapshot_identifier(input.into());
            self
        }
        /// <p>The identifier of the snapshot whose setting you want to modify.</p>
        pub fn set_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_snapshot_identifier(input);
            self
        }
        /// <p>The number of days that a manual snapshot is retained. If the value is -1, the manual snapshot is retained indefinitely.</p>
        /// <p>If the manual snapshot falls outside of the new retention period, you can specify the force option to immediately delete the snapshot.</p>
        /// <p>The value must be either -1 or an integer between 1 and 3,653.</p>
        pub fn manual_snapshot_retention_period(mut self, input: i32) -> Self {
            self.inner = self.inner.manual_snapshot_retention_period(input);
            self
        }
        /// <p>The number of days that a manual snapshot is retained. If the value is -1, the manual snapshot is retained indefinitely.</p>
        /// <p>If the manual snapshot falls outside of the new retention period, you can specify the force option to immediately delete the snapshot.</p>
        /// <p>The value must be either -1 or an integer between 1 and 3,653.</p>
        pub fn set_manual_snapshot_retention_period(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.inner = self.inner.set_manual_snapshot_retention_period(input);
            self
        }
        /// <p>A Boolean option to override an exception if the retention period has already passed.</p>
        pub fn force(mut self, input: bool) -> Self {
            self.inner = self.inner.force(input);
            self
        }
        /// <p>A Boolean option to override an exception if the retention period has already passed.</p>
        pub fn set_force(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_force(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyClusterSnapshotSchedule`.
    ///
    /// <p>Modifies a snapshot schedule for a cluster.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ModifyClusterSnapshotSchedule {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::modify_cluster_snapshot_schedule_input::Builder,
    }
    impl ModifyClusterSnapshotSchedule {
        /// Creates a new `ModifyClusterSnapshotSchedule`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyClusterSnapshotScheduleOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifyClusterSnapshotScheduleError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique identifier for the cluster whose snapshot schedule you want to modify. </p>
        pub fn cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_identifier(input.into());
            self
        }
        /// <p>A unique identifier for the cluster whose snapshot schedule you want to modify. </p>
        pub fn set_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_identifier(input);
            self
        }
        /// <p>A unique alphanumeric identifier for the schedule that you want to associate with the cluster.</p>
        pub fn schedule_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schedule_identifier(input.into());
            self
        }
        /// <p>A unique alphanumeric identifier for the schedule that you want to associate with the cluster.</p>
        pub fn set_schedule_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_schedule_identifier(input);
            self
        }
        /// <p>A boolean to indicate whether to remove the assoiciation between the cluster and the schedule.</p>
        pub fn disassociate_schedule(mut self, input: bool) -> Self {
            self.inner = self.inner.disassociate_schedule(input);
            self
        }
        /// <p>A boolean to indicate whether to remove the assoiciation between the cluster and the schedule.</p>
        pub fn set_disassociate_schedule(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_disassociate_schedule(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyClusterSubnetGroup`.
    ///
    /// <p>Modifies a cluster subnet group to include the specified list of VPC subnets. The operation replaces the existing list of subnets with the new list of subnets.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ModifyClusterSubnetGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::modify_cluster_subnet_group_input::Builder,
    }
    impl ModifyClusterSubnetGroup {
        /// Creates a new `ModifyClusterSubnetGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyClusterSubnetGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifyClusterSubnetGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the subnet group to be modified.</p>
        pub fn cluster_subnet_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cluster_subnet_group_name(input.into());
            self
        }
        /// <p>The name of the subnet group to be modified.</p>
        pub fn set_cluster_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_cluster_subnet_group_name(input);
            self
        }
        /// <p>A text description of the subnet group to be modified.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A text description of the subnet group to be modified.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `SubnetIds`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// <p>An array of VPC subnet IDs. A maximum of 20 subnets can be modified in a single request.</p>
        pub fn subnet_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subnet_ids(input.into());
            self
        }
        /// <p>An array of VPC subnet IDs. A maximum of 20 subnets can be modified in a single request.</p>
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_subnet_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyEndpointAccess`.
    ///
    /// <p>Modifies a Redshift-managed VPC endpoint.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ModifyEndpointAccess {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::modify_endpoint_access_input::Builder,
    }
    impl ModifyEndpointAccess {
        /// Creates a new `ModifyEndpointAccess`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyEndpointAccessOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifyEndpointAccessError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The endpoint to be modified.</p>
        pub fn endpoint_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.endpoint_name(input.into());
            self
        }
        /// <p>The endpoint to be modified.</p>
        pub fn set_endpoint_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_endpoint_name(input);
            self
        }
        /// Appends an item to `VpcSecurityGroupIds`.
        ///
        /// To override the contents of this collection use [`set_vpc_security_group_ids`](Self::set_vpc_security_group_ids).
        ///
        /// <p>The complete list of VPC security groups associated with the endpoint after the endpoint is modified.</p>
        pub fn vpc_security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc_security_group_ids(input.into());
            self
        }
        /// <p>The complete list of VPC security groups associated with the endpoint after the endpoint is modified.</p>
        pub fn set_vpc_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_vpc_security_group_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyEventSubscription`.
    ///
    /// <p>Modifies an existing Amazon Redshift event notification subscription.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ModifyEventSubscription {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::modify_event_subscription_input::Builder,
    }
    impl ModifyEventSubscription {
        /// Creates a new `ModifyEventSubscription`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyEventSubscriptionOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifyEventSubscriptionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the modified Amazon Redshift event notification subscription.</p>
        pub fn subscription_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subscription_name(input.into());
            self
        }
        /// <p>The name of the modified Amazon Redshift event notification subscription.</p>
        pub fn set_subscription_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_subscription_name(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the SNS topic to be used by the event notification subscription.</p>
        pub fn sns_topic_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sns_topic_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the SNS topic to be used by the event notification subscription.</p>
        pub fn set_sns_topic_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_sns_topic_arn(input);
            self
        }
        /// <p>The type of source that will be generating the events. For example, if you want to be notified of events generated by a cluster, you would set this parameter to cluster. If this value is not specified, events are returned for all Amazon Redshift objects in your Amazon Web Services account. You must specify a source type in order to specify source IDs.</p>
        /// <p>Valid values: cluster, cluster-parameter-group, cluster-security-group, cluster-snapshot, and scheduled-action.</p>
        pub fn source_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_type(input.into());
            self
        }
        /// <p>The type of source that will be generating the events. For example, if you want to be notified of events generated by a cluster, you would set this parameter to cluster. If this value is not specified, events are returned for all Amazon Redshift objects in your Amazon Web Services account. You must specify a source type in order to specify source IDs.</p>
        /// <p>Valid values: cluster, cluster-parameter-group, cluster-security-group, cluster-snapshot, and scheduled-action.</p>
        pub fn set_source_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_source_type(input);
            self
        }
        /// Appends an item to `SourceIds`.
        ///
        /// To override the contents of this collection use [`set_source_ids`](Self::set_source_ids).
        ///
        /// <p>A list of one or more identifiers of Amazon Redshift source objects. All of the objects must be of the same type as was specified in the source type parameter. The event subscription will return only events generated by the specified objects. If not specified, then events are returned for all objects within the source type specified.</p>
        /// <p>Example: my-cluster-1, my-cluster-2</p>
        /// <p>Example: my-snapshot-20131010</p>
        pub fn source_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_ids(input.into());
            self
        }
        /// <p>A list of one or more identifiers of Amazon Redshift source objects. All of the objects must be of the same type as was specified in the source type parameter. The event subscription will return only events generated by the specified objects. If not specified, then events are returned for all objects within the source type specified.</p>
        /// <p>Example: my-cluster-1, my-cluster-2</p>
        /// <p>Example: my-snapshot-20131010</p>
        pub fn set_source_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_source_ids(input);
            self
        }
        /// Appends an item to `EventCategories`.
        ///
        /// To override the contents of this collection use [`set_event_categories`](Self::set_event_categories).
        ///
        /// <p>Specifies the Amazon Redshift event categories to be published by the event notification subscription.</p>
        /// <p>Values: configuration, management, monitoring, security, pending</p>
        pub fn event_categories(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.event_categories(input.into());
            self
        }
        /// <p>Specifies the Amazon Redshift event categories to be published by the event notification subscription.</p>
        /// <p>Values: configuration, management, monitoring, security, pending</p>
        pub fn set_event_categories(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_event_categories(input);
            self
        }
        /// <p>Specifies the Amazon Redshift event severity to be published by the event notification subscription.</p>
        /// <p>Values: ERROR, INFO</p>
        pub fn severity(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.severity(input.into());
            self
        }
        /// <p>Specifies the Amazon Redshift event severity to be published by the event notification subscription.</p>
        /// <p>Values: ERROR, INFO</p>
        pub fn set_severity(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_severity(input);
            self
        }
        /// <p>A Boolean value indicating if the subscription is enabled. <code>true</code> indicates the subscription is enabled </p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.inner = self.inner.enabled(input);
            self
        }
        /// <p>A Boolean value indicating if the subscription is enabled. <code>true</code> indicates the subscription is enabled </p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enabled(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ModifyScheduledAction`.
    ///
    /// <p>Modifies a scheduled action. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ModifyScheduledAction {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::modify_scheduled_action_input::Builder,
    }
    impl ModifyScheduledAction {
        /// Creates a new `ModifyScheduledAction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ModifyScheduledActionOutput,
            aws_smithy_http::result::SdkError<crate::error::ModifyScheduledActionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the scheduled action to modify. </p>
        pub fn scheduled_action_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.scheduled_action_name(input.into());
            self
        }
        /// <p>The name of the scheduled action to modify. </p>
        pub fn set_scheduled_action_name(
            mut self,
        