// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `BatchExecuteStatement` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BatchExecuteStatementError {
    /// Kind of error that occurred.
    pub kind: BatchExecuteStatementErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BatchExecuteStatement` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BatchExecuteStatementErrorKind {
    /// <p>There is an error in the call or in a SQL statement.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>There are insufficient privileges to make the call.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>An internal error occurred.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>The service specified by the <code>resourceArn</code> parameter is not
    /// available.</p>
    ServiceUnavailableError(crate::error::ServiceUnavailableError),
    /// <p>The execution of the SQL statement timed out.</p>
    StatementTimeoutException(crate::error::StatementTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BatchExecuteStatementError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BatchExecuteStatementErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            BatchExecuteStatementErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            BatchExecuteStatementErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            BatchExecuteStatementErrorKind::ServiceUnavailableError(_inner) => _inner.fmt(f),
            BatchExecuteStatementErrorKind::StatementTimeoutException(_inner) => _inner.fmt(f),
            BatchExecuteStatementErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for BatchExecuteStatementError {
    fn code(&self) -> Option<&str> {
        BatchExecuteStatementError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl BatchExecuteStatementError {
    /// Creates a new `BatchExecuteStatementError`.
    pub fn new(kind: BatchExecuteStatementErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BatchExecuteStatementError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BatchExecuteStatementErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `BatchExecuteStatementError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BatchExecuteStatementErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `BatchExecuteStatementErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchExecuteStatementErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchExecuteStatementErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchExecuteStatementErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchExecuteStatementErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchExecuteStatementErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchExecuteStatementErrorKind::ServiceUnavailableError`.
    pub fn is_service_unavailable_error(&self) -> bool {
        matches!(
            &self.kind,
            BatchExecuteStatementErrorKind::ServiceUnavailableError(_)
        )
    }
    /// Returns `true` if the error kind is `BatchExecuteStatementErrorKind::StatementTimeoutException`.
    pub fn is_statement_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchExecuteStatementErrorKind::StatementTimeoutException(_)
        )
    }
}
impl std::error::Error for BatchExecuteStatementError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BatchExecuteStatementErrorKind::BadRequestException(_inner) => Some(_inner),
            BatchExecuteStatementErrorKind::ForbiddenException(_inner) => Some(_inner),
            BatchExecuteStatementErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            BatchExecuteStatementErrorKind::ServiceUnavailableError(_inner) => Some(_inner),
            BatchExecuteStatementErrorKind::StatementTimeoutException(_inner) => Some(_inner),
            BatchExecuteStatementErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `BeginTransaction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BeginTransactionError {
    /// Kind of error that occurred.
    pub kind: BeginTransactionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BeginTransaction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BeginTransactionErrorKind {
    /// <p>There is an error in the call or in a SQL statement.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>There are insufficient privileges to make the call.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>An internal error occurred.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>The service specified by the <code>resourceArn</code> parameter is not
    /// available.</p>
    ServiceUnavailableError(crate::error::ServiceUnavailableError),
    /// <p>The execution of the SQL statement timed out.</p>
    StatementTimeoutException(crate::error::StatementTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BeginTransactionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BeginTransactionErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            BeginTransactionErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            BeginTransactionErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            BeginTransactionErrorKind::ServiceUnavailableError(_inner) => _inner.fmt(f),
            BeginTransactionErrorKind::StatementTimeoutException(_inner) => _inner.fmt(f),
            BeginTransactionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for BeginTransactionError {
    fn code(&self) -> Option<&str> {
        BeginTransactionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl BeginTransactionError {
    /// Creates a new `BeginTransactionError`.
    pub fn new(kind: BeginTransactionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BeginTransactionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BeginTransactionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `BeginTransactionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BeginTransactionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `BeginTransactionErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            BeginTransactionErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `BeginTransactionErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, BeginTransactionErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `BeginTransactionErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            BeginTransactionErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `BeginTransactionErrorKind::ServiceUnavailableError`.
    pub fn is_service_unavailable_error(&self) -> bool {
        matches!(
            &self.kind,
            BeginTransactionErrorKind::ServiceUnavailableError(_)
        )
    }
    /// Returns `true` if the error kind is `BeginTransactionErrorKind::StatementTimeoutException`.
    pub fn is_statement_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            BeginTransactionErrorKind::StatementTimeoutException(_)
        )
    }
}
impl std::error::Error for BeginTransactionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BeginTransactionErrorKind::BadRequestException(_inner) => Some(_inner),
            BeginTransactionErrorKind::ForbiddenException(_inner) => Some(_inner),
            BeginTransactionErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            BeginTransactionErrorKind::ServiceUnavailableError(_inner) => Some(_inner),
            BeginTransactionErrorKind::StatementTimeoutException(_inner) => Some(_inner),
            BeginTransactionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CommitTransaction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CommitTransactionError {
    /// Kind of error that occurred.
    pub kind: CommitTransactionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CommitTransaction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CommitTransactionErrorKind {
    /// <p>There is an error in the call or in a SQL statement.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>There are insufficient privileges to make the call.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>An internal error occurred.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>The <code>resourceArn</code>, <code>secretArn</code>, or <code>transactionId</code> value can't be found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The service specified by the <code>resourceArn</code> parameter is not
    /// available.</p>
    ServiceUnavailableError(crate::error::ServiceUnavailableError),
    /// <p>The execution of the SQL statement timed out.</p>
    StatementTimeoutException(crate::error::StatementTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CommitTransactionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CommitTransactionErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CommitTransactionErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            CommitTransactionErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            CommitTransactionErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CommitTransactionErrorKind::ServiceUnavailableError(_inner) => _inner.fmt(f),
            CommitTransactionErrorKind::StatementTimeoutException(_inner) => _inner.fmt(f),
            CommitTransactionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CommitTransactionError {
    fn code(&self) -> Option<&str> {
        CommitTransactionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CommitTransactionError {
    /// Creates a new `CommitTransactionError`.
    pub fn new(kind: CommitTransactionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CommitTransactionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CommitTransactionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CommitTransactionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CommitTransactionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CommitTransactionErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CommitTransactionErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CommitTransactionErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            CommitTransactionErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `CommitTransactionErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CommitTransactionErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `CommitTransactionErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, CommitTransactionErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `CommitTransactionErrorKind::ServiceUnavailableError`.
    pub fn is_service_unavailable_error(&self) -> bool {
        matches!(
            &self.kind,
            CommitTransactionErrorKind::ServiceUnavailableError(_)
        )
    }
    /// Returns `true` if the error kind is `CommitTransactionErrorKind::StatementTimeoutException`.
    pub fn is_statement_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            CommitTransactionErrorKind::StatementTimeoutException(_)
        )
    }
}
impl std::error::Error for CommitTransactionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CommitTransactionErrorKind::BadRequestException(_inner) => Some(_inner),
            CommitTransactionErrorKind::ForbiddenException(_inner) => Some(_inner),
            CommitTransactionErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            CommitTransactionErrorKind::NotFoundException(_inner) => Some(_inner),
            CommitTransactionErrorKind::ServiceUnavailableError(_inner) => Some(_inner),
            CommitTransactionErrorKind::StatementTimeoutException(_inner) => Some(_inner),
            CommitTransactionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ExecuteSql` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ExecuteSqlError {
    /// Kind of error that occurred.
    pub kind: ExecuteSqlErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ExecuteSql` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ExecuteSqlErrorKind {
    /// <p>There is an error in the call or in a SQL statement.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>There are insufficient privileges to make the call.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>An internal error occurred.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>The service specified by the <code>resourceArn</code> parameter is not
    /// available.</p>
    ServiceUnavailableError(crate::error::ServiceUnavailableError),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ExecuteSqlError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ExecuteSqlErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ExecuteSqlErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            ExecuteSqlErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            ExecuteSqlErrorKind::ServiceUnavailableError(_inner) => _inner.fmt(f),
            ExecuteSqlErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ExecuteSqlError {
    fn code(&self) -> Option<&str> {
        ExecuteSqlError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ExecuteSqlError {
    /// Creates a new `ExecuteSqlError`.
    pub fn new(kind: ExecuteSqlErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ExecuteSqlError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ExecuteSqlErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ExecuteSqlError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ExecuteSqlErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ExecuteSqlErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, ExecuteSqlErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `ExecuteSqlErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, ExecuteSqlErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `ExecuteSqlErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ExecuteSqlErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ExecuteSqlErrorKind::ServiceUnavailableError`.
    pub fn is_service_unavailable_error(&self) -> bool {
        matches!(&self.kind, ExecuteSqlErrorKind::ServiceUnavailableError(_))
    }
}
impl std::error::Error for ExecuteSqlError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ExecuteSqlErrorKind::BadRequestException(_inner) => Some(_inner),
            ExecuteSqlErrorKind::ForbiddenException(_inner) => Some(_inner),
            ExecuteSqlErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            ExecuteSqlErrorKind::ServiceUnavailableError(_inner) => Some(_inner),
            ExecuteSqlErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ExecuteStatement` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ExecuteStatementError {
    /// Kind of error that occurred.
    pub kind: ExecuteStatementErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ExecuteStatement` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ExecuteStatementErrorKind {
    /// <p>There is an error in the call or in a SQL statement.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>There are insufficient privileges to make the call.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>An internal error occurred.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>The service specified by the <code>resourceArn</code> parameter is not
    /// available.</p>
    ServiceUnavailableError(crate::error::ServiceUnavailableError),
    /// <p>The execution of the SQL statement timed out.</p>
    StatementTimeoutException(crate::error::StatementTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ExecuteStatementError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ExecuteStatementErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ExecuteStatementErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            ExecuteStatementErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            ExecuteStatementErrorKind::ServiceUnavailableError(_inner) => _inner.fmt(f),
            ExecuteStatementErrorKind::StatementTimeoutException(_inner) => _inner.fmt(f),
            ExecuteStatementErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ExecuteStatementError {
    fn code(&self) -> Option<&str> {
        ExecuteStatementError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ExecuteStatementError {
    /// Creates a new `ExecuteStatementError`.
    pub fn new(kind: ExecuteStatementErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ExecuteStatementError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ExecuteStatementErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ExecuteStatementError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ExecuteStatementErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ExecuteStatementErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ExecuteStatementErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ExecuteStatementErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, ExecuteStatementErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `ExecuteStatementErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ExecuteStatementErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ExecuteStatementErrorKind::ServiceUnavailableError`.
    pub fn is_service_unavailable_error(&self) -> bool {
        matches!(
            &self.kind,
            ExecuteStatementErrorKind::ServiceUnavailableError(_)
        )
    }
    /// Returns `true` if the error kind is `ExecuteStatementErrorKind::StatementTimeoutException`.
    pub fn is_statement_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            ExecuteStatementErrorKind::StatementTimeoutException(_)
        )
    }
}
impl std::error::Error for ExecuteStatementError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ExecuteStatementErrorKind::BadRequestException(_inner) => Some(_inner),
            ExecuteStatementErrorKind::ForbiddenException(_inner) => Some(_inner),
            ExecuteStatementErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            ExecuteStatementErrorKind::ServiceUnavailableError(_inner) => Some(_inner),
            ExecuteStatementErrorKind::StatementTimeoutException(_inner) => Some(_inner),
            ExecuteStatementErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RollbackTransaction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RollbackTransactionError {
    /// Kind of error that occurred.
    pub kind: RollbackTransactionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RollbackTransaction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RollbackTransactionErrorKind {
    /// <p>There is an error in the call or in a SQL statement.</p>
    BadRequestException(crate::error::BadRequestException),
    /// <p>There are insufficient privileges to make the call.</p>
    ForbiddenException(crate::error::ForbiddenException),
    /// <p>An internal error occurred.</p>
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// <p>The <code>resourceArn</code>, <code>secretArn</code>, or <code>transactionId</code> value can't be found.</p>
    NotFoundException(crate::error::NotFoundException),
    /// <p>The service specified by the <code>resourceArn</code> parameter is not
    /// available.</p>
    ServiceUnavailableError(crate::error::ServiceUnavailableError),
    /// <p>The execution of the SQL statement timed out.</p>
    StatementTimeoutException(crate::error::StatementTimeoutException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RollbackTransactionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RollbackTransactionErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            RollbackTransactionErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            RollbackTransactionErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            RollbackTransactionErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            RollbackTransactionErrorKind::ServiceUnavailableError(_inner) => _inner.fmt(f),
            RollbackTransactionErrorKind::StatementTimeoutException(_inner) => _inner.fmt(f),
            RollbackTransactionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RollbackTransactionError {
    fn code(&self) -> Option<&str> {
        RollbackTransactionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RollbackTransactionError {
    /// Creates a new `RollbackTransactionError`.
    pub fn new(kind: RollbackTransactionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RollbackTransactionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RollbackTransactionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RollbackTransactionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RollbackTransactionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RollbackTransactionErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            RollbackTransactionErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `RollbackTransactionErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            RollbackTransactionErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `RollbackTransactionErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            RollbackTransactionErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `RollbackTransactionErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            RollbackTransactionErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `RollbackTransactionErrorKind::ServiceUnavailableError`.
    pub fn is_service_unavailable_error(&self) -> bool {
        matches!(
            &self.kind,
            RollbackTransactionErrorKind::ServiceUnavailableError(_)
        )
    }
    /// Returns `true` if the error kind is `RollbackTransactionErrorKind::StatementTimeoutException`.
    pub fn is_statement_timeout_exception(&self) -> bool {
        matches!(
            &self.kind,
            RollbackTransactionErrorKind::StatementTimeoutException(_)
        )
    }
}
impl std::error::Error for RollbackTransactionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RollbackTransactionErrorKind::BadRequestException(_inner) => Some(_inner),
            RollbackTransactionErrorKind::ForbiddenException(_inner) => Some(_inner),
            RollbackTransactionErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            RollbackTransactionErrorKind::NotFoundException(_inner) => Some(_inner),
            RollbackTransactionErrorKind::ServiceUnavailableError(_inner) => Some(_inner),
            RollbackTransactionErrorKind::StatementTimeoutException(_inner) => Some(_inner),
            RollbackTransactionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>The execution of the SQL statement timed out.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StatementTimeoutException {
    /// <p>The error message returned by this <code>StatementTimeoutException</code> error.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The database connection ID that executed the SQL statement.</p>
    pub db_connection_id: i64,
}
impl StatementTimeoutException {
    /// <p>The database connection ID that executed the SQL statement.</p>
    pub fn db_connection_id(&self) -> i64 {
        self.db_connection_id
    }
}
impl std::fmt::Debug for StatementTimeoutException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StatementTimeoutException");
        formatter.field("message", &self.message);
        formatter.field("db_connection_id", &self.db_connection_id);
        formatter.finish()
    }
}
impl StatementTimeoutException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for StatementTimeoutException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "StatementTimeoutException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for StatementTimeoutException {}
/// See [`StatementTimeoutException`](crate::error::StatementTimeoutException)
pub mod statement_timeout_exception {
    /// A builder for [`StatementTimeoutException`](crate::error::StatementTimeoutException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) db_connection_id: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The error message returned by this <code>StatementTimeoutException</code> error.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The error message returned by this <code>StatementTimeoutException</code> error.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The database connection ID that executed the SQL statement.</p>
        pub fn db_connection_id(mut self, input: i64) -> Self {
            self.db_connection_id = Some(input);
            self
        }
        /// <p>The database connection ID that executed the SQL statement.</p>
        pub fn set_db_connection_id(mut self, input: std::option::Option<i64>) -> Self {
            self.db_connection_id = input;
            self
        }
        /// Consumes the builder and constructs a [`StatementTimeoutException`](crate::error::StatementTimeoutException)
        pub fn build(self) -> crate::error::StatementTimeoutException {
            crate::error::StatementTimeoutException {
                message: self.message,
                db_connection_id: self.db_connection_id.unwrap_or_default(),
            }
        }
    }
}
impl StatementTimeoutException {
    /// Creates a new builder-style object to manufacture [`StatementTimeoutException`](crate::error::StatementTimeoutException)
    pub fn builder() -> crate::error::statement_timeout_exception::Builder {
        crate::error::statement_timeout_exception::Builder::default()
    }
}

/// <p>The service specified by the <code>resourceArn</code> parameter is not
/// available.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceUnavailableError {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ServiceUnavailableError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceUnavailableError");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ServiceUnavailableError {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ServiceUnavailableError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ServiceUnavailableError")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for ServiceUnavailableError {}
/// See [`ServiceUnavailableError`](crate::error::ServiceUnavailableError)
pub mod service_unavailable_error {
    /// A builder for [`ServiceUnavailableError`](crate::error::ServiceUnavailableError)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceUnavailableError`](crate::error::ServiceUnavailableError)
        pub fn build(self) -> crate::error::ServiceUnavailableError {
            crate::error::ServiceUnavailableError {
                message: self.message,
            }
        }
    }
}
impl ServiceUnavailableError {
    /// Creates a new builder-style object to manufacture [`ServiceUnavailableError`](crate::error::ServiceUnavailableError)
    pub fn builder() -> crate::error::service_unavailable_error::Builder {
        crate::error::service_unavailable_error::Builder::default()
    }
}

/// <p>The <code>resourceArn</code>, <code>secretArn</code>, or <code>transactionId</code> value can't be found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NotFoundException {
    /// <p>The error message returned by this <code>NotFoundException</code> error.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl NotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NotFoundException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for NotFoundException {}
/// See [`NotFoundException`](crate::error::NotFoundException)
pub mod not_found_exception {
    /// A builder for [`NotFoundException`](crate::error::NotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error message returned by this <code>NotFoundException</code> error.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The error message returned by this <code>NotFoundException</code> error.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`NotFoundException`](crate::error::NotFoundException)
        pub fn build(self) -> crate::error::NotFoundException {
            crate::error::NotFoundException {
                message: self.message,
            }
        }
    }
}
impl NotFoundException {
    /// Creates a new builder-style object to manufacture [`NotFoundException`](crate::error::NotFoundException)
    pub fn builder() -> crate::error::not_found_exception::Builder {
        crate::error::not_found_exception::Builder::default()
    }
}

/// <p>An internal error occurred.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalServerErrorException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InternalServerErrorException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalServerErrorException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InternalServerErrorException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalServerErrorException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalServerErrorException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalServerErrorException {}
/// See [`InternalServerErrorException`](crate::error::InternalServerErrorException)
pub mod internal_server_error_exception {
    /// A builder for [`InternalServerErrorException`](crate::error::InternalServerErrorException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalServerErrorException`](crate::error::InternalServerErrorException)
        pub fn build(self) -> crate::error::InternalServerErrorException {
            crate::error::InternalServerErrorException {
                message: self.message,
            }
        }
    }
}
impl InternalServerErrorException {
    /// Creates a new builder-style object to manufacture [`InternalServerErrorException`](crate::error::InternalServerErrorException)
    pub fn builder() -> crate::error::internal_server_error_exception::Builder {
        crate::error::internal_server_error_exception::Builder::default()
    }
}

/// <p>There are insufficient privileges to make the call.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ForbiddenException {
    /// <p>The error message returned by this <code>ForbiddenException</code> error.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ForbiddenException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ForbiddenException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ForbiddenException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ForbiddenException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ForbiddenException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for ForbiddenException {}
/// See [`ForbiddenException`](crate::error::ForbiddenException)
pub mod forbidden_exception {
    /// A builder for [`ForbiddenException`](crate::error::ForbiddenException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error message returned by this <code>ForbiddenException</code> error.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The error message returned by this <code>ForbiddenException</code> error.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ForbiddenException`](crate::error::ForbiddenException)
        pub fn build(self) -> crate::error::ForbiddenException {
            crate::error::ForbiddenException {
                message: self.message,
            }
        }
    }
}
impl ForbiddenException {
    /// Creates a new builder-style object to manufacture [`ForbiddenException`](crate::error::ForbiddenException)
    pub fn builder() -> crate::error::forbidden_exception::Builder {
        crate::error::forbidden_exception::Builder::default()
    }
}

/// <p>There is an error in the call or in a SQL statement.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BadRequestException {
    /// <p>The error message returned by this <code>BadRequestException</code> error.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for BadRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BadRequestException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl BadRequestException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for BadRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "BadRequestException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for BadRequestException {}
/// See [`BadRequestException`](crate::error::BadRequestException)
pub mod bad_request_exception {
    /// A builder for [`BadRequestException`](crate::error::BadRequestException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error message returned by this <code>BadRequestException</code> error.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The error message returned by this <code>BadRequestException</code> error.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`BadRequestException`](crate::error::BadRequestException)
        pub fn build(self) -> crate::error::BadRequestException {
            crate::error::BadRequestException {
                message: self.message,
            }
        }
    }
}
impl BadRequestException {
    /// Creates a new builder-style object to manufacture [`BadRequestException`](crate::error::BadRequestException)
    pub fn builder() -> crate::error::bad_request_exception::Builder {
        crate::error::bad_request_exception::Builder::default()
    }
}
