// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// Client for AWS RDS DataService
///
/// Client for invoking operations on AWS RDS DataService. Each operation on AWS RDS DataService is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_rdsdata::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_rdsdata::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_rdsdata::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `BatchExecuteStatement` operation.
    ///
    /// See [`BatchExecuteStatement`](crate::client::fluent_builders::BatchExecuteStatement) for more information about the
    /// operation and its arguments.
    pub fn batch_execute_statement(&self) -> fluent_builders::BatchExecuteStatement<C, M, R> {
        fluent_builders::BatchExecuteStatement::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `BeginTransaction` operation.
    ///
    /// See [`BeginTransaction`](crate::client::fluent_builders::BeginTransaction) for more information about the
    /// operation and its arguments.
    pub fn begin_transaction(&self) -> fluent_builders::BeginTransaction<C, M, R> {
        fluent_builders::BeginTransaction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CommitTransaction` operation.
    ///
    /// See [`CommitTransaction`](crate::client::fluent_builders::CommitTransaction) for more information about the
    /// operation and its arguments.
    pub fn commit_transaction(&self) -> fluent_builders::CommitTransaction<C, M, R> {
        fluent_builders::CommitTransaction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ExecuteSql` operation.
    ///
    /// See [`ExecuteSql`](crate::client::fluent_builders::ExecuteSql) for more information about the
    /// operation and its arguments.
    pub fn execute_sql(&self) -> fluent_builders::ExecuteSql<C, M, R> {
        fluent_builders::ExecuteSql::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ExecuteStatement` operation.
    ///
    /// See [`ExecuteStatement`](crate::client::fluent_builders::ExecuteStatement) for more information about the
    /// operation and its arguments.
    pub fn execute_statement(&self) -> fluent_builders::ExecuteStatement<C, M, R> {
        fluent_builders::ExecuteStatement::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RollbackTransaction` operation.
    ///
    /// See [`RollbackTransaction`](crate::client::fluent_builders::RollbackTransaction) for more information about the
    /// operation and its arguments.
    pub fn rollback_transaction(&self) -> fluent_builders::RollbackTransaction<C, M, R> {
        fluent_builders::RollbackTransaction::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `BatchExecuteStatement`.
    ///
    /// <p>Runs a batch SQL statement over an array of data.</p>
    /// <p>You can run bulk update and insert operations for multiple records using a DML
    /// statement with different parameter sets. Bulk operations can provide a significant
    /// performance improvement over individual insert and update operations.</p>
    /// <important>    
    /// <p>If a call isn't part of a transaction because it doesn't include the
    /// <code>transactionID</code> parameter, changes that result from the call are
    /// committed automatically.</p>    
    /// </important>
    #[derive(std::fmt::Debug)]
    pub struct BatchExecuteStatement<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_execute_statement_input::Builder,
    }
    impl<C, M, R> BatchExecuteStatement<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchExecuteStatement`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchExecuteStatementOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchExecuteStatementError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchExecuteStatementInputOperationOutputAlias,
                crate::output::BatchExecuteStatementOutput,
                crate::error::BatchExecuteStatementError,
                crate::input::BatchExecuteStatementInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the Aurora Serverless DB cluster.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Aurora Serverless DB cluster.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// <p>The name or ARN of the secret that enables access to the DB cluster.</p>
        pub fn secret_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.secret_arn(inp);
            self
        }
        /// <p>The name or ARN of the secret that enables access to the DB cluster.</p>
        pub fn set_secret_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_secret_arn(input);
            self
        }
        /// <p>The SQL statement to run.</p>
        pub fn sql(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sql(inp);
            self
        }
        /// <p>The SQL statement to run.</p>
        pub fn set_sql(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_sql(input);
            self
        }
        /// <p>The name of the database.</p>
        pub fn database(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.database(inp);
            self
        }
        /// <p>The name of the database.</p>
        pub fn set_database(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_database(input);
            self
        }
        /// <p>The name of the database schema.</p>
        pub fn schema(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schema(inp);
            self
        }
        /// <p>The name of the database schema.</p>
        pub fn set_schema(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_schema(input);
            self
        }
        /// Appends an item to `parameterSets`.
        ///
        /// To override the contents of this collection use [`set_parameter_sets`](Self::set_parameter_sets).
        ///
        /// <p>The parameter set for the batch operation.</p>
        /// <p>The SQL statement is executed as many times as the number of parameter sets provided.
        /// To execute a SQL statement with no parameters, use one of the following options:</p>
        /// <ul>
        /// <li>
        /// <p>Specify one or more empty parameter sets.</p>
        /// </li>
        /// <li>
        /// <p>Use the <code>ExecuteStatement</code> operation instead of the <code>BatchExecuteStatement</code> operation.</p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>Array parameters are not supported.</p>
        /// </note>
        pub fn parameter_sets(
            mut self,
            inp: impl Into<std::vec::Vec<crate::model::SqlParameter>>,
        ) -> Self {
            self.inner = self.inner.parameter_sets(inp);
            self
        }
        /// <p>The parameter set for the batch operation.</p>
        /// <p>The SQL statement is executed as many times as the number of parameter sets provided.
        /// To execute a SQL statement with no parameters, use one of the following options:</p>
        /// <ul>
        /// <li>
        /// <p>Specify one or more empty parameter sets.</p>
        /// </li>
        /// <li>
        /// <p>Use the <code>ExecuteStatement</code> operation instead of the <code>BatchExecuteStatement</code> operation.</p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>Array parameters are not supported.</p>
        /// </note>
        pub fn set_parameter_sets(
            mut self,
            input: std::option::Option<std::vec::Vec<std::vec::Vec<crate::model::SqlParameter>>>,
        ) -> Self {
            self.inner = self.inner.set_parameter_sets(input);
            self
        }
        /// <p>The identifier of a transaction that was started by using the
        /// <code>BeginTransaction</code> operation. Specify the transaction ID of the
        /// transaction that you want to include the SQL statement in.</p>
        /// <p>If the SQL statement is not part of a transaction, don't set this
        /// parameter.</p>
        pub fn transaction_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.transaction_id(inp);
            self
        }
        /// <p>The identifier of a transaction that was started by using the
        /// <code>BeginTransaction</code> operation. Specify the transaction ID of the
        /// transaction that you want to include the SQL statement in.</p>
        /// <p>If the SQL statement is not part of a transaction, don't set this
        /// parameter.</p>
        pub fn set_transaction_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_transaction_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BeginTransaction`.
    ///
    /// <p>Starts a SQL transaction.</p>
    ///
    /// <important>
    /// <p>A transaction can run for a maximum of 24 hours. A transaction is terminated and
    /// rolled back automatically after 24 hours.</p>
    /// <p>A transaction times out if no calls use its transaction ID in three minutes.
    /// If a transaction times out before it's committed, it's rolled back
    /// automatically.</p>
    /// <p>DDL statements inside a transaction cause an implicit commit. We recommend
    /// that you run each DDL statement in a separate <code>ExecuteStatement</code> call with
    /// <code>continueAfterTimeout</code> enabled.</p>
    /// </important>
    #[derive(std::fmt::Debug)]
    pub struct BeginTransaction<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::begin_transaction_input::Builder,
    }
    impl<C, M, R> BeginTransaction<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BeginTransaction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BeginTransactionOutput,
            aws_smithy_http::result::SdkError<crate::error::BeginTransactionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BeginTransactionInputOperationOutputAlias,
                crate::output::BeginTransactionOutput,
                crate::error::BeginTransactionError,
                crate::input::BeginTransactionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the Aurora Serverless DB cluster.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Aurora Serverless DB cluster.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// <p>The name or ARN of the secret that enables access to the DB cluster.</p>
        pub fn secret_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.secret_arn(inp);
            self
        }
        /// <p>The name or ARN of the secret that enables access to the DB cluster.</p>
        pub fn set_secret_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_secret_arn(input);
            self
        }
        /// <p>The name of the database.</p>
        pub fn database(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.database(inp);
            self
        }
        /// <p>The name of the database.</p>
        pub fn set_database(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_database(input);
            self
        }
        /// <p>The name of the database schema.</p>
        pub fn schema(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schema(inp);
            self
        }
        /// <p>The name of the database schema.</p>
        pub fn set_schema(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_schema(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CommitTransaction`.
    ///
    /// <p>Ends a SQL transaction started with the <code>BeginTransaction</code> operation and
    /// commits the changes.</p>
    #[derive(std::fmt::Debug)]
    pub struct CommitTransaction<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::commit_transaction_input::Builder,
    }
    impl<C, M, R> CommitTransaction<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CommitTransaction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CommitTransactionOutput,
            aws_smithy_http::result::SdkError<crate::error::CommitTransactionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CommitTransactionInputOperationOutputAlias,
                crate::output::CommitTransactionOutput,
                crate::error::CommitTransactionError,
                crate::input::CommitTransactionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the Aurora Serverless DB cluster.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Aurora Serverless DB cluster.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// <p>The name or ARN of the secret that enables access to the DB cluster.</p>
        pub fn secret_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.secret_arn(inp);
            self
        }
        /// <p>The name or ARN of the secret that enables access to the DB cluster.</p>
        pub fn set_secret_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_secret_arn(input);
            self
        }
        /// <p>The identifier of the transaction to end and commit.</p>
        pub fn transaction_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.transaction_id(inp);
            self
        }
        /// <p>The identifier of the transaction to end and commit.</p>
        pub fn set_transaction_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_transaction_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ExecuteSql`.
    ///
    /// <p>Runs one or more SQL statements.</p>
    /// <important>
    /// <p>This operation is deprecated. Use the <code>BatchExecuteStatement</code> or
    /// <code>ExecuteStatement</code> operation.</p>
    /// </important>
    #[derive(std::fmt::Debug)]
    pub struct ExecuteSql<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::execute_sql_input::Builder,
    }
    impl<C, M, R> ExecuteSql<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ExecuteSql`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ExecuteSqlOutput,
            aws_smithy_http::result::SdkError<crate::error::ExecuteSqlError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ExecuteSqlInputOperationOutputAlias,
                crate::output::ExecuteSqlOutput,
                crate::error::ExecuteSqlError,
                crate::input::ExecuteSqlInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the Aurora Serverless DB cluster.</p>
        pub fn db_cluster_or_instance_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_cluster_or_instance_arn(inp);
            self
        }
        /// <p>The ARN of the Aurora Serverless DB cluster.</p>
        pub fn set_db_cluster_or_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_or_instance_arn(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the secret that enables access to the DB cluster.</p>
        pub fn aws_secret_store_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_secret_store_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the secret that enables access to the DB cluster.</p>
        pub fn set_aws_secret_store_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_secret_store_arn(input);
            self
        }
        /// <p>One or more SQL statements to run on the DB cluster.</p>
        /// <p>You can separate SQL statements from each other with a semicolon (;). Any valid SQL
        /// statement is permitted, including data definition, data manipulation, and commit
        /// statements. </p>
        pub fn sql_statements(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sql_statements(inp);
            self
        }
        /// <p>One or more SQL statements to run on the DB cluster.</p>
        /// <p>You can separate SQL statements from each other with a semicolon (;). Any valid SQL
        /// statement is permitted, including data definition, data manipulation, and commit
        /// statements. </p>
        pub fn set_sql_statements(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_sql_statements(input);
            self
        }
        /// <p>The name of the database.</p>
        pub fn database(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.database(inp);
            self
        }
        /// <p>The name of the database.</p>
        pub fn set_database(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_database(input);
            self
        }
        /// <p>The name of the database schema.</p>
        pub fn schema(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schema(inp);
            self
        }
        /// <p>The name of the database schema.</p>
        pub fn set_schema(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_schema(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ExecuteStatement`.
    ///
    /// <p>Runs a SQL statement against a database.</p>
    /// <important>    
    /// <p>If a call isn't part of a transaction because it doesn't include the
    /// <code>transactionID</code> parameter, changes that result from the call are
    /// committed automatically.</p>    
    /// </important>
    /// <p>The response size limit is 1 MB. If the call returns more than 1 MB of response data, the call is terminated.</p>
    #[derive(std::fmt::Debug)]
    pub struct ExecuteStatement<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::execute_statement_input::Builder,
    }
    impl<C, M, R> ExecuteStatement<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ExecuteStatement`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ExecuteStatementOutput,
            aws_smithy_http::result::SdkError<crate::error::ExecuteStatementError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ExecuteStatementInputOperationOutputAlias,
                crate::output::ExecuteStatementOutput,
                crate::error::ExecuteStatementError,
                crate::input::ExecuteStatementInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the Aurora Serverless DB cluster.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Aurora Serverless DB cluster.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// <p>The name or ARN of the secret that enables access to the DB cluster.</p>
        pub fn secret_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.secret_arn(inp);
            self
        }
        /// <p>The name or ARN of the secret that enables access to the DB cluster.</p>
        pub fn set_secret_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_secret_arn(input);
            self
        }
        /// <p>The SQL statement to run.</p>
        pub fn sql(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sql(inp);
            self
        }
        /// <p>The SQL statement to run.</p>
        pub fn set_sql(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_sql(input);
            self
        }
        /// <p>The name of the database.</p>
        pub fn database(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.database(inp);
            self
        }
        /// <p>The name of the database.</p>
        pub fn set_database(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_database(input);
            self
        }
        /// <p>The name of the database schema.</p>
        /// <note>
        /// <p>Currently, the <code>schema</code> parameter isn't supported.</p>
        /// </note>
        pub fn schema(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schema(inp);
            self
        }
        /// <p>The name of the database schema.</p>
        /// <note>
        /// <p>Currently, the <code>schema</code> parameter isn't supported.</p>
        /// </note>
        pub fn set_schema(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_schema(input);
            self
        }
        /// Appends an item to `parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>The parameters for the SQL statement.</p>
        /// <note>
        /// <p>Array parameters are not supported.</p>
        /// </note>
        pub fn parameters(mut self, inp: impl Into<crate::model::SqlParameter>) -> Self {
            self.inner = self.inner.parameters(inp);
            self
        }
        /// <p>The parameters for the SQL statement.</p>
        /// <note>
        /// <p>Array parameters are not supported.</p>
        /// </note>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SqlParameter>>,
        ) -> Self {
            self.inner = self.inner.set_parameters(input);
            self
        }
        /// <p>The identifier of a transaction that was started by using the
        /// <code>BeginTransaction</code> operation. Specify the transaction ID of the
        /// transaction that you want to include the SQL statement in.</p>
        /// <p>If the SQL statement is not part of a transaction, don't set this parameter.</p>
        pub fn transaction_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.transaction_id(inp);
            self
        }
        /// <p>The identifier of a transaction that was started by using the
        /// <code>BeginTransaction</code> operation. Specify the transaction ID of the
        /// transaction that you want to include the SQL statement in.</p>
        /// <p>If the SQL statement is not part of a transaction, don't set this parameter.</p>
        pub fn set_transaction_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_transaction_id(input);
            self
        }
        /// <p>A value that indicates whether to include metadata in the results.</p>
        pub fn include_result_metadata(mut self, inp: bool) -> Self {
            self.inner = self.inner.include_result_metadata(inp);
            self
        }
        /// <p>A value that indicates whether to include metadata in the results.</p>
        pub fn set_include_result_metadata(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_include_result_metadata(input);
            self
        }
        /// <p>A value that indicates whether to continue running the statement after
        /// the call times out. By default, the statement stops running when the call
        /// times out.</p>
        /// <important>
        /// <p>For DDL statements, we recommend continuing to run the statement after
        /// the call times out. When a DDL statement terminates before it is finished
        /// running, it can result in errors and possibly corrupted data structures.</p>
        /// </important>
        pub fn continue_after_timeout(mut self, inp: bool) -> Self {
            self.inner = self.inner.continue_after_timeout(inp);
            self
        }
        /// <p>A value that indicates whether to continue running the statement after
        /// the call times out. By default, the statement stops running when the call
        /// times out.</p>
        /// <important>
        /// <p>For DDL statements, we recommend continuing to run the statement after
        /// the call times out. When a DDL statement terminates before it is finished
        /// running, it can result in errors and possibly corrupted data structures.</p>
        /// </important>
        pub fn set_continue_after_timeout(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_continue_after_timeout(input);
            self
        }
        /// <p>Options that control how the result set is returned.</p>
        pub fn result_set_options(mut self, inp: crate::model::ResultSetOptions) -> Self {
            self.inner = self.inner.result_set_options(inp);
            self
        }
        /// <p>Options that control how the result set is returned.</p>
        pub fn set_result_set_options(
            mut self,
            input: std::option::Option<crate::model::ResultSetOptions>,
        ) -> Self {
            self.inner = self.inner.set_result_set_options(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RollbackTransaction`.
    ///
    /// <p>Performs a rollback of a transaction. Rolling back a transaction cancels its changes.</p>
    #[derive(std::fmt::Debug)]
    pub struct RollbackTransaction<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::rollback_transaction_input::Builder,
    }
    impl<C, M, R> RollbackTransaction<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RollbackTransaction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RollbackTransactionOutput,
            aws_smithy_http::result::SdkError<crate::error::RollbackTransactionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RollbackTransactionInputOperationOutputAlias,
                crate::output::RollbackTransactionOutput,
                crate::error::RollbackTransactionError,
                crate::input::RollbackTransactionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the Aurora Serverless DB cluster.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Aurora Serverless DB cluster.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// <p>The name or ARN of the secret that enables access to the DB cluster.</p>
        pub fn secret_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.secret_arn(inp);
            self
        }
        /// <p>The name or ARN of the secret that enables access to the DB cluster.</p>
        pub fn set_secret_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_secret_arn(input);
            self
        }
        /// <p>The identifier of the transaction to roll back.</p>
        pub fn transaction_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.transaction_id(inp);
            self
        }
        /// <p>The identifier of the transaction to roll back.</p>
        pub fn set_transaction_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_transaction_id(input);
            self
        }
    }
}
impl<C> Client<C, crate::middleware::DefaultMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(conn)
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        crate::middleware::DefaultMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https()
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
