// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`BatchExecuteStatementInput`](crate::input::BatchExecuteStatementInput)
pub mod batch_execute_statement_input {
    /// A builder for [`BatchExecuteStatementInput`](crate::input::BatchExecuteStatementInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) secret_arn: std::option::Option<std::string::String>,
        pub(crate) sql: std::option::Option<std::string::String>,
        pub(crate) database: std::option::Option<std::string::String>,
        pub(crate) schema: std::option::Option<std::string::String>,
        pub(crate) parameter_sets:
            std::option::Option<std::vec::Vec<std::vec::Vec<crate::model::SqlParameter>>>,
        pub(crate) transaction_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the Aurora Serverless DB cluster.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Aurora Serverless DB cluster.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>The name or ARN of the secret that enables access to the DB cluster.</p>
        pub fn secret_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.secret_arn = Some(input.into());
            self
        }
        /// <p>The name or ARN of the secret that enables access to the DB cluster.</p>
        pub fn set_secret_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.secret_arn = input;
            self
        }
        /// <p>The SQL statement to run.</p>
        pub fn sql(mut self, input: impl Into<std::string::String>) -> Self {
            self.sql = Some(input.into());
            self
        }
        /// <p>The SQL statement to run.</p>
        pub fn set_sql(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.sql = input;
            self
        }
        /// <p>The name of the database.</p>
        pub fn database(mut self, input: impl Into<std::string::String>) -> Self {
            self.database = Some(input.into());
            self
        }
        /// <p>The name of the database.</p>
        pub fn set_database(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.database = input;
            self
        }
        /// <p>The name of the database schema.</p>
        pub fn schema(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema = Some(input.into());
            self
        }
        /// <p>The name of the database schema.</p>
        pub fn set_schema(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schema = input;
            self
        }
        /// Appends an item to `parameter_sets`.
        ///
        /// To override the contents of this collection use [`set_parameter_sets`](Self::set_parameter_sets).
        ///
        /// <p>The parameter set for the batch operation.</p>
        /// <p>The SQL statement is executed as many times as the number of parameter sets provided.
        /// To execute a SQL statement with no parameters, use one of the following options:</p>
        /// <ul>
        /// <li>
        /// <p>Specify one or more empty parameter sets.</p>
        /// </li>
        /// <li>
        /// <p>Use the <code>ExecuteStatement</code> operation instead of the <code>BatchExecuteStatement</code> operation.</p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>Array parameters are not supported.</p>
        /// </note>
        pub fn parameter_sets(
            mut self,
            input: impl Into<std::vec::Vec<crate::model::SqlParameter>>,
        ) -> Self {
            let mut v = self.parameter_sets.unwrap_or_default();
            v.push(input.into());
            self.parameter_sets = Some(v);
            self
        }
        /// <p>The parameter set for the batch operation.</p>
        /// <p>The SQL statement is executed as many times as the number of parameter sets provided.
        /// To execute a SQL statement with no parameters, use one of the following options:</p>
        /// <ul>
        /// <li>
        /// <p>Specify one or more empty parameter sets.</p>
        /// </li>
        /// <li>
        /// <p>Use the <code>ExecuteStatement</code> operation instead of the <code>BatchExecuteStatement</code> operation.</p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>Array parameters are not supported.</p>
        /// </note>
        pub fn set_parameter_sets(
            mut self,
            input: std::option::Option<std::vec::Vec<std::vec::Vec<crate::model::SqlParameter>>>,
        ) -> Self {
            self.parameter_sets = input;
            self
        }
        /// <p>The identifier of a transaction that was started by using the
        /// <code>BeginTransaction</code> operation. Specify the transaction ID of the
        /// transaction that you want to include the SQL statement in.</p>
        /// <p>If the SQL statement is not part of a transaction, don't set this
        /// parameter.</p>
        pub fn transaction_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.transaction_id = Some(input.into());
            self
        }
        /// <p>The identifier of a transaction that was started by using the
        /// <code>BeginTransaction</code> operation. Specify the transaction ID of the
        /// transaction that you want to include the SQL statement in.</p>
        /// <p>If the SQL statement is not part of a transaction, don't set this
        /// parameter.</p>
        pub fn set_transaction_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.transaction_id = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchExecuteStatementInput`](crate::input::BatchExecuteStatementInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BatchExecuteStatementInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::BatchExecuteStatementInput {
                resource_arn: self.resource_arn,
                secret_arn: self.secret_arn,
                sql: self.sql,
                database: self.database,
                schema: self.schema,
                parameter_sets: self.parameter_sets,
                transaction_id: self.transaction_id,
            })
        }
    }
}
#[doc(hidden)]
pub type BatchExecuteStatementInputOperationOutputAlias = crate::operation::BatchExecuteStatement;
#[doc(hidden)]
pub type BatchExecuteStatementInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl BatchExecuteStatementInput {
    /// Consumes the builder and constructs an Operation<[`BatchExecuteStatement`](crate::operation::BatchExecuteStatement)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BatchExecuteStatement,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::BatchExecuteStatementInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/BatchExecute").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::BatchExecuteStatementInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::BatchExecuteStatementInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_batch_execute_statement(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BatchExecuteStatement::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BatchExecuteStatement",
            "rdsdata",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`BatchExecuteStatementInput`](crate::input::BatchExecuteStatementInput)
    pub fn builder() -> crate::input::batch_execute_statement_input::Builder {
        crate::input::batch_execute_statement_input::Builder::default()
    }
}

/// See [`BeginTransactionInput`](crate::input::BeginTransactionInput)
pub mod begin_transaction_input {
    /// A builder for [`BeginTransactionInput`](crate::input::BeginTransactionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) secret_arn: std::option::Option<std::string::String>,
        pub(crate) database: std::option::Option<std::string::String>,
        pub(crate) schema: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the Aurora Serverless DB cluster.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Aurora Serverless DB cluster.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>The name or ARN of the secret that enables access to the DB cluster.</p>
        pub fn secret_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.secret_arn = Some(input.into());
            self
        }
        /// <p>The name or ARN of the secret that enables access to the DB cluster.</p>
        pub fn set_secret_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.secret_arn = input;
            self
        }
        /// <p>The name of the database.</p>
        pub fn database(mut self, input: impl Into<std::string::String>) -> Self {
            self.database = Some(input.into());
            self
        }
        /// <p>The name of the database.</p>
        pub fn set_database(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.database = input;
            self
        }
        /// <p>The name of the database schema.</p>
        pub fn schema(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema = Some(input.into());
            self
        }
        /// <p>The name of the database schema.</p>
        pub fn set_schema(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schema = input;
            self
        }
        /// Consumes the builder and constructs a [`BeginTransactionInput`](crate::input::BeginTransactionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BeginTransactionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::BeginTransactionInput {
                resource_arn: self.resource_arn,
                secret_arn: self.secret_arn,
                database: self.database,
                schema: self.schema,
            })
        }
    }
}
#[doc(hidden)]
pub type BeginTransactionInputOperationOutputAlias = crate::operation::BeginTransaction;
#[doc(hidden)]
pub type BeginTransactionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl BeginTransactionInput {
    /// Consumes the builder and constructs an Operation<[`BeginTransaction`](crate::operation::BeginTransaction)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BeginTransaction,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::BeginTransactionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/BeginTransaction").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::BeginTransactionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::BeginTransactionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_begin_transaction(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BeginTransaction::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BeginTransaction",
            "rdsdata",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`BeginTransactionInput`](crate::input::BeginTransactionInput)
    pub fn builder() -> crate::input::begin_transaction_input::Builder {
        crate::input::begin_transaction_input::Builder::default()
    }
}

/// See [`CommitTransactionInput`](crate::input::CommitTransactionInput)
pub mod commit_transaction_input {
    /// A builder for [`CommitTransactionInput`](crate::input::CommitTransactionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) secret_arn: std::option::Option<std::string::String>,
        pub(crate) transaction_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the Aurora Serverless DB cluster.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Aurora Serverless DB cluster.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>The name or ARN of the secret that enables access to the DB cluster.</p>
        pub fn secret_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.secret_arn = Some(input.into());
            self
        }
        /// <p>The name or ARN of the secret that enables access to the DB cluster.</p>
        pub fn set_secret_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.secret_arn = input;
            self
        }
        /// <p>The identifier of the transaction to end and commit.</p>
        pub fn transaction_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.transaction_id = Some(input.into());
            self
        }
        /// <p>The identifier of the transaction to end and commit.</p>
        pub fn set_transaction_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.transaction_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CommitTransactionInput`](crate::input::CommitTransactionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CommitTransactionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CommitTransactionInput {
                resource_arn: self.resource_arn,
                secret_arn: self.secret_arn,
                transaction_id: self.transaction_id,
            })
        }
    }
}
#[doc(hidden)]
pub type CommitTransactionInputOperationOutputAlias = crate::operation::CommitTransaction;
#[doc(hidden)]
pub type CommitTransactionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CommitTransactionInput {
    /// Consumes the builder and constructs an Operation<[`CommitTransaction`](crate::operation::CommitTransaction)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CommitTransaction,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CommitTransactionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/CommitTransaction").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CommitTransactionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CommitTransactionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_commit_transaction(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CommitTransaction::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CommitTransaction",
            "rdsdata",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CommitTransactionInput`](crate::input::CommitTransactionInput)
    pub fn builder() -> crate::input::commit_transaction_input::Builder {
        crate::input::commit_transaction_input::Builder::default()
    }
}

/// See [`ExecuteSqlInput`](crate::input::ExecuteSqlInput)
pub mod execute_sql_input {
    /// A builder for [`ExecuteSqlInput`](crate::input::ExecuteSqlInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster_or_instance_arn: std::option::Option<std::string::String>,
        pub(crate) aws_secret_store_arn: std::option::Option<std::string::String>,
        pub(crate) sql_statements: std::option::Option<std::string::String>,
        pub(crate) database: std::option::Option<std::string::String>,
        pub(crate) schema: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ARN of the Aurora Serverless DB cluster.</p>
        pub fn db_cluster_or_instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_cluster_or_instance_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the Aurora Serverless DB cluster.</p>
        pub fn set_db_cluster_or_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_or_instance_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the secret that enables access to the DB cluster.</p>
        pub fn aws_secret_store_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.aws_secret_store_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the secret that enables access to the DB cluster.</p>
        pub fn set_aws_secret_store_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_secret_store_arn = input;
            self
        }
        /// <p>One or more SQL statements to run on the DB cluster.</p>
        /// <p>You can separate SQL statements from each other with a semicolon (;). Any valid SQL
        /// statement is permitted, including data definition, data manipulation, and commit
        /// statements. </p>
        pub fn sql_statements(mut self, input: impl Into<std::string::String>) -> Self {
            self.sql_statements = Some(input.into());
            self
        }
        /// <p>One or more SQL statements to run on the DB cluster.</p>
        /// <p>You can separate SQL statements from each other with a semicolon (;). Any valid SQL
        /// statement is permitted, including data definition, data manipulation, and commit
        /// statements. </p>
        pub fn set_sql_statements(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sql_statements = input;
            self
        }
        /// <p>The name of the database.</p>
        pub fn database(mut self, input: impl Into<std::string::String>) -> Self {
            self.database = Some(input.into());
            self
        }
        /// <p>The name of the database.</p>
        pub fn set_database(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.database = input;
            self
        }
        /// <p>The name of the database schema.</p>
        pub fn schema(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema = Some(input.into());
            self
        }
        /// <p>The name of the database schema.</p>
        pub fn set_schema(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schema = input;
            self
        }
        /// Consumes the builder and constructs a [`ExecuteSqlInput`](crate::input::ExecuteSqlInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ExecuteSqlInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ExecuteSqlInput {
                db_cluster_or_instance_arn: self.db_cluster_or_instance_arn,
                aws_secret_store_arn: self.aws_secret_store_arn,
                sql_statements: self.sql_statements,
                database: self.database,
                schema: self.schema,
            })
        }
    }
}
#[doc(hidden)]
pub type ExecuteSqlInputOperationOutputAlias = crate::operation::ExecuteSql;
#[doc(hidden)]
pub type ExecuteSqlInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ExecuteSqlInput {
    /// Consumes the builder and constructs an Operation<[`ExecuteSql`](crate::operation::ExecuteSql)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ExecuteSql,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ExecuteSqlInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/ExecuteSql").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ExecuteSqlInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ExecuteSqlInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_execute_sql(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ExecuteSql::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ExecuteSql",
            "rdsdata",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ExecuteSqlInput`](crate::input::ExecuteSqlInput)
    pub fn builder() -> crate::input::execute_sql_input::Builder {
        crate::input::execute_sql_input::Builder::default()
    }
}

/// See [`ExecuteStatementInput`](crate::input::ExecuteStatementInput)
pub mod execute_statement_input {
    /// A builder for [`ExecuteStatementInput`](crate::input::ExecuteStatementInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) secret_arn: std::option::Option<std::string::String>,
        pub(crate) sql: std::option::Option<std::string::String>,
        pub(crate) database: std::option::Option<std::string::String>,
        pub(crate) schema: std::option::Option<std::string::String>,
        pub(crate) parameters: std::option::Option<std::vec::Vec<crate::model::SqlParameter>>,
        pub(crate) transaction_id: std::option::Option<std::string::String>,
        pub(crate) include_result_metadata: std::option::Option<bool>,
        pub(crate) continue_after_timeout: std::option::Option<bool>,
        pub(crate) result_set_options: std::option::Option<crate::model::ResultSetOptions>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the Aurora Serverless DB cluster.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Aurora Serverless DB cluster.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>The name or ARN of the secret that enables access to the DB cluster.</p>
        pub fn secret_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.secret_arn = Some(input.into());
            self
        }
        /// <p>The name or ARN of the secret that enables access to the DB cluster.</p>
        pub fn set_secret_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.secret_arn = input;
            self
        }
        /// <p>The SQL statement to run.</p>
        pub fn sql(mut self, input: impl Into<std::string::String>) -> Self {
            self.sql = Some(input.into());
            self
        }
        /// <p>The SQL statement to run.</p>
        pub fn set_sql(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.sql = input;
            self
        }
        /// <p>The name of the database.</p>
        pub fn database(mut self, input: impl Into<std::string::String>) -> Self {
            self.database = Some(input.into());
            self
        }
        /// <p>The name of the database.</p>
        pub fn set_database(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.database = input;
            self
        }
        /// <p>The name of the database schema.</p>
        /// <note>
        /// <p>Currently, the <code>schema</code> parameter isn't supported.</p>
        /// </note>
        pub fn schema(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema = Some(input.into());
            self
        }
        /// <p>The name of the database schema.</p>
        /// <note>
        /// <p>Currently, the <code>schema</code> parameter isn't supported.</p>
        /// </note>
        pub fn set_schema(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schema = input;
            self
        }
        /// Appends an item to `parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>The parameters for the SQL statement.</p>
        /// <note>
        /// <p>Array parameters are not supported.</p>
        /// </note>
        pub fn parameters(mut self, input: impl Into<crate::model::SqlParameter>) -> Self {
            let mut v = self.parameters.unwrap_or_default();
            v.push(input.into());
            self.parameters = Some(v);
            self
        }
        /// <p>The parameters for the SQL statement.</p>
        /// <note>
        /// <p>Array parameters are not supported.</p>
        /// </note>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SqlParameter>>,
        ) -> Self {
            self.parameters = input;
            self
        }
        /// <p>The identifier of a transaction that was started by using the
        /// <code>BeginTransaction</code> operation. Specify the transaction ID of the
        /// transaction that you want to include the SQL statement in.</p>
        /// <p>If the SQL statement is not part of a transaction, don't set this parameter.</p>
        pub fn transaction_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.transaction_id = Some(input.into());
            self
        }
        /// <p>The identifier of a transaction that was started by using the
        /// <code>BeginTransaction</code> operation. Specify the transaction ID of the
        /// transaction that you want to include the SQL statement in.</p>
        /// <p>If the SQL statement is not part of a transaction, don't set this parameter.</p>
        pub fn set_transaction_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.transaction_id = input;
            self
        }
        /// <p>A value that indicates whether to include metadata in the results.</p>
        pub fn include_result_metadata(mut self, input: bool) -> Self {
            self.include_result_metadata = Some(input);
            self
        }
        /// <p>A value that indicates whether to include metadata in the results.</p>
        pub fn set_include_result_metadata(mut self, input: std::option::Option<bool>) -> Self {
            self.include_result_metadata = input;
            self
        }
        /// <p>A value that indicates whether to continue running the statement after
        /// the call times out. By default, the statement stops running when the call
        /// times out.</p>
        /// <important>
        /// <p>For DDL statements, we recommend continuing to run the statement after
        /// the call times out. When a DDL statement terminates before it is finished
        /// running, it can result in errors and possibly corrupted data structures.</p>
        /// </important>
        pub fn continue_after_timeout(mut self, input: bool) -> Self {
            self.continue_after_timeout = Some(input);
            self
        }
        /// <p>A value that indicates whether to continue running the statement after
        /// the call times out. By default, the statement stops running when the call
        /// times out.</p>
        /// <important>
        /// <p>For DDL statements, we recommend continuing to run the statement after
        /// the call times out. When a DDL statement terminates before it is finished
        /// running, it can result in errors and possibly corrupted data structures.</p>
        /// </important>
        pub fn set_continue_after_timeout(mut self, input: std::option::Option<bool>) -> Self {
            self.continue_after_timeout = input;
            self
        }
        /// <p>Options that control how the result set is returned.</p>
        pub fn result_set_options(mut self, input: crate::model::ResultSetOptions) -> Self {
            self.result_set_options = Some(input);
            self
        }
        /// <p>Options that control how the result set is returned.</p>
        pub fn set_result_set_options(
            mut self,
            input: std::option::Option<crate::model::ResultSetOptions>,
        ) -> Self {
            self.result_set_options = input;
            self
        }
        /// Consumes the builder and constructs a [`ExecuteStatementInput`](crate::input::ExecuteStatementInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ExecuteStatementInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ExecuteStatementInput {
                resource_arn: self.resource_arn,
                secret_arn: self.secret_arn,
                sql: self.sql,
                database: self.database,
                schema: self.schema,
                parameters: self.parameters,
                transaction_id: self.transaction_id,
                include_result_metadata: self.include_result_metadata.unwrap_or_default(),
                continue_after_timeout: self.continue_after_timeout.unwrap_or_default(),
                result_set_options: self.result_set_options,
            })
        }
    }
}
#[doc(hidden)]
pub type ExecuteStatementInputOperationOutputAlias = crate::operation::ExecuteStatement;
#[doc(hidden)]
pub type ExecuteStatementInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ExecuteStatementInput {
    /// Consumes the builder and constructs an Operation<[`ExecuteStatement`](crate::operation::ExecuteStatement)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ExecuteStatement,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ExecuteStatementInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/Execute").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ExecuteStatementInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ExecuteStatementInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_execute_statement(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ExecuteStatement::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ExecuteStatement",
            "rdsdata",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ExecuteStatementInput`](crate::input::ExecuteStatementInput)
    pub fn builder() -> crate::input::execute_statement_input::Builder {
        crate::input::execute_statement_input::Builder::default()
    }
}

/// See [`RollbackTransactionInput`](crate::input::RollbackTransactionInput)
pub mod rollback_transaction_input {
    /// A builder for [`RollbackTransactionInput`](crate::input::RollbackTransactionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) secret_arn: std::option::Option<std::string::String>,
        pub(crate) transaction_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the Aurora Serverless DB cluster.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Aurora Serverless DB cluster.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// <p>The name or ARN of the secret that enables access to the DB cluster.</p>
        pub fn secret_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.secret_arn = Some(input.into());
            self
        }
        /// <p>The name or ARN of the secret that enables access to the DB cluster.</p>
        pub fn set_secret_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.secret_arn = input;
            self
        }
        /// <p>The identifier of the transaction to roll back.</p>
        pub fn transaction_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.transaction_id = Some(input.into());
            self
        }
        /// <p>The identifier of the transaction to roll back.</p>
        pub fn set_transaction_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.transaction_id = input;
            self
        }
        /// Consumes the builder and constructs a [`RollbackTransactionInput`](crate::input::RollbackTransactionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RollbackTransactionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RollbackTransactionInput {
                resource_arn: self.resource_arn,
                secret_arn: self.secret_arn,
                transaction_id: self.transaction_id,
            })
        }
    }
}
#[doc(hidden)]
pub type RollbackTransactionInputOperationOutputAlias = crate::operation::RollbackTransaction;
#[doc(hidden)]
pub type RollbackTransactionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl RollbackTransactionInput {
    /// Consumes the builder and constructs an Operation<[`RollbackTransaction`](crate::operation::RollbackTransaction)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RollbackTransaction,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RollbackTransactionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/RollbackTransaction").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RollbackTransactionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RollbackTransactionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_rollback_transaction(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RollbackTransaction::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RollbackTransaction",
            "rdsdata",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RollbackTransactionInput`](crate::input::RollbackTransactionInput)
    pub fn builder() -> crate::input::rollback_transaction_input::Builder {
        crate::input::rollback_transaction_input::Builder::default()
    }
}

/// <p>The request parameters represent the input of a request to perform a rollback of a
/// transaction.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RollbackTransactionInput {
    /// <p>The Amazon Resource Name (ARN) of the Aurora Serverless DB cluster.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The name or ARN of the secret that enables access to the DB cluster.</p>
    pub secret_arn: std::option::Option<std::string::String>,
    /// <p>The identifier of the transaction to roll back.</p>
    pub transaction_id: std::option::Option<std::string::String>,
}
impl RollbackTransactionInput {
    /// <p>The Amazon Resource Name (ARN) of the Aurora Serverless DB cluster.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The name or ARN of the secret that enables access to the DB cluster.</p>
    pub fn secret_arn(&self) -> std::option::Option<&str> {
        self.secret_arn.as_deref()
    }
    /// <p>The identifier of the transaction to roll back.</p>
    pub fn transaction_id(&self) -> std::option::Option<&str> {
        self.transaction_id.as_deref()
    }
}
impl std::fmt::Debug for RollbackTransactionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RollbackTransactionInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("secret_arn", &self.secret_arn);
        formatter.field("transaction_id", &self.transaction_id);
        formatter.finish()
    }
}

/// <p>The request parameters represent the input of a request to run a SQL statement against
/// a database.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExecuteStatementInput {
    /// <p>The Amazon Resource Name (ARN) of the Aurora Serverless DB cluster.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The name or ARN of the secret that enables access to the DB cluster.</p>
    pub secret_arn: std::option::Option<std::string::String>,
    /// <p>The SQL statement to run.</p>
    pub sql: std::option::Option<std::string::String>,
    /// <p>The name of the database.</p>
    pub database: std::option::Option<std::string::String>,
    /// <p>The name of the database schema.</p>
    /// <note>
    /// <p>Currently, the <code>schema</code> parameter isn't supported.</p>
    /// </note>
    pub schema: std::option::Option<std::string::String>,
    /// <p>The parameters for the SQL statement.</p>
    /// <note>
    /// <p>Array parameters are not supported.</p>
    /// </note>
    pub parameters: std::option::Option<std::vec::Vec<crate::model::SqlParameter>>,
    /// <p>The identifier of a transaction that was started by using the
    /// <code>BeginTransaction</code> operation. Specify the transaction ID of the
    /// transaction that you want to include the SQL statement in.</p>
    /// <p>If the SQL statement is not part of a transaction, don't set this parameter.</p>
    pub transaction_id: std::option::Option<std::string::String>,
    /// <p>A value that indicates whether to include metadata in the results.</p>
    pub include_result_metadata: bool,
    /// <p>A value that indicates whether to continue running the statement after
    /// the call times out. By default, the statement stops running when the call
    /// times out.</p>
    /// <important>
    /// <p>For DDL statements, we recommend continuing to run the statement after
    /// the call times out. When a DDL statement terminates before it is finished
    /// running, it can result in errors and possibly corrupted data structures.</p>
    /// </important>
    pub continue_after_timeout: bool,
    /// <p>Options that control how the result set is returned.</p>
    pub result_set_options: std::option::Option<crate::model::ResultSetOptions>,
}
impl ExecuteStatementInput {
    /// <p>The Amazon Resource Name (ARN) of the Aurora Serverless DB cluster.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The name or ARN of the secret that enables access to the DB cluster.</p>
    pub fn secret_arn(&self) -> std::option::Option<&str> {
        self.secret_arn.as_deref()
    }
    /// <p>The SQL statement to run.</p>
    pub fn sql(&self) -> std::option::Option<&str> {
        self.sql.as_deref()
    }
    /// <p>The name of the database.</p>
    pub fn database(&self) -> std::option::Option<&str> {
        self.database.as_deref()
    }
    /// <p>The name of the database schema.</p>
    /// <note>
    /// <p>Currently, the <code>schema</code> parameter isn't supported.</p>
    /// </note>
    pub fn schema(&self) -> std::option::Option<&str> {
        self.schema.as_deref()
    }
    /// <p>The parameters for the SQL statement.</p>
    /// <note>
    /// <p>Array parameters are not supported.</p>
    /// </note>
    pub fn parameters(&self) -> std::option::Option<&[crate::model::SqlParameter]> {
        self.parameters.as_deref()
    }
    /// <p>The identifier of a transaction that was started by using the
    /// <code>BeginTransaction</code> operation. Specify the transaction ID of the
    /// transaction that you want to include the SQL statement in.</p>
    /// <p>If the SQL statement is not part of a transaction, don't set this parameter.</p>
    pub fn transaction_id(&self) -> std::option::Option<&str> {
        self.transaction_id.as_deref()
    }
    /// <p>A value that indicates whether to include metadata in the results.</p>
    pub fn include_result_metadata(&self) -> bool {
        self.include_result_metadata
    }
    /// <p>A value that indicates whether to continue running the statement after
    /// the call times out. By default, the statement stops running when the call
    /// times out.</p>
    /// <important>
    /// <p>For DDL statements, we recommend continuing to run the statement after
    /// the call times out. When a DDL statement terminates before it is finished
    /// running, it can result in errors and possibly corrupted data structures.</p>
    /// </important>
    pub fn continue_after_timeout(&self) -> bool {
        self.continue_after_timeout
    }
    /// <p>Options that control how the result set is returned.</p>
    pub fn result_set_options(&self) -> std::option::Option<&crate::model::ResultSetOptions> {
        self.result_set_options.as_ref()
    }
}
impl std::fmt::Debug for ExecuteStatementInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExecuteStatementInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("secret_arn", &self.secret_arn);
        formatter.field("sql", &self.sql);
        formatter.field("database", &self.database);
        formatter.field("schema", &self.schema);
        formatter.field("parameters", &self.parameters);
        formatter.field("transaction_id", &self.transaction_id);
        formatter.field("include_result_metadata", &self.include_result_metadata);
        formatter.field("continue_after_timeout", &self.continue_after_timeout);
        formatter.field("result_set_options", &self.result_set_options);
        formatter.finish()
    }
}

/// <p>The request parameters represent the input of a request to run one or more SQL
/// statements.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExecuteSqlInput {
    /// <p>The ARN of the Aurora Serverless DB cluster.</p>
    pub db_cluster_or_instance_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the secret that enables access to the DB cluster.</p>
    pub aws_secret_store_arn: std::option::Option<std::string::String>,
    /// <p>One or more SQL statements to run on the DB cluster.</p>
    /// <p>You can separate SQL statements from each other with a semicolon (;). Any valid SQL
    /// statement is permitted, including data definition, data manipulation, and commit
    /// statements. </p>
    pub sql_statements: std::option::Option<std::string::String>,
    /// <p>The name of the database.</p>
    pub database: std::option::Option<std::string::String>,
    /// <p>The name of the database schema.</p>
    pub schema: std::option::Option<std::string::String>,
}
impl ExecuteSqlInput {
    /// <p>The ARN of the Aurora Serverless DB cluster.</p>
    pub fn db_cluster_or_instance_arn(&self) -> std::option::Option<&str> {
        self.db_cluster_or_instance_arn.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the secret that enables access to the DB cluster.</p>
    pub fn aws_secret_store_arn(&self) -> std::option::Option<&str> {
        self.aws_secret_store_arn.as_deref()
    }
    /// <p>One or more SQL statements to run on the DB cluster.</p>
    /// <p>You can separate SQL statements from each other with a semicolon (;). Any valid SQL
    /// statement is permitted, including data definition, data manipulation, and commit
    /// statements. </p>
    pub fn sql_statements(&self) -> std::option::Option<&str> {
        self.sql_statements.as_deref()
    }
    /// <p>The name of the database.</p>
    pub fn database(&self) -> std::option::Option<&str> {
        self.database.as_deref()
    }
    /// <p>The name of the database schema.</p>
    pub fn schema(&self) -> std::option::Option<&str> {
        self.schema.as_deref()
    }
}
impl std::fmt::Debug for ExecuteSqlInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExecuteSqlInput");
        formatter.field(
            "db_cluster_or_instance_arn",
            &self.db_cluster_or_instance_arn,
        );
        formatter.field("aws_secret_store_arn", &self.aws_secret_store_arn);
        formatter.field("sql_statements", &self.sql_statements);
        formatter.field("database", &self.database);
        formatter.field("schema", &self.schema);
        formatter.finish()
    }
}

/// <p>The request parameters represent the input of a commit transaction request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CommitTransactionInput {
    /// <p>The Amazon Resource Name (ARN) of the Aurora Serverless DB cluster.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The name or ARN of the secret that enables access to the DB cluster.</p>
    pub secret_arn: std::option::Option<std::string::String>,
    /// <p>The identifier of the transaction to end and commit.</p>
    pub transaction_id: std::option::Option<std::string::String>,
}
impl CommitTransactionInput {
    /// <p>The Amazon Resource Name (ARN) of the Aurora Serverless DB cluster.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The name or ARN of the secret that enables access to the DB cluster.</p>
    pub fn secret_arn(&self) -> std::option::Option<&str> {
        self.secret_arn.as_deref()
    }
    /// <p>The identifier of the transaction to end and commit.</p>
    pub fn transaction_id(&self) -> std::option::Option<&str> {
        self.transaction_id.as_deref()
    }
}
impl std::fmt::Debug for CommitTransactionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CommitTransactionInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("secret_arn", &self.secret_arn);
        formatter.field("transaction_id", &self.transaction_id);
        formatter.finish()
    }
}

/// <p>The request parameters represent the input of a request to start a SQL
/// transaction.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BeginTransactionInput {
    /// <p>The Amazon Resource Name (ARN) of the Aurora Serverless DB cluster.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The name or ARN of the secret that enables access to the DB cluster.</p>
    pub secret_arn: std::option::Option<std::string::String>,
    /// <p>The name of the database.</p>
    pub database: std::option::Option<std::string::String>,
    /// <p>The name of the database schema.</p>
    pub schema: std::option::Option<std::string::String>,
}
impl BeginTransactionInput {
    /// <p>The Amazon Resource Name (ARN) of the Aurora Serverless DB cluster.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The name or ARN of the secret that enables access to the DB cluster.</p>
    pub fn secret_arn(&self) -> std::option::Option<&str> {
        self.secret_arn.as_deref()
    }
    /// <p>The name of the database.</p>
    pub fn database(&self) -> std::option::Option<&str> {
        self.database.as_deref()
    }
    /// <p>The name of the database schema.</p>
    pub fn schema(&self) -> std::option::Option<&str> {
        self.schema.as_deref()
    }
}
impl std::fmt::Debug for BeginTransactionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BeginTransactionInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("secret_arn", &self.secret_arn);
        formatter.field("database", &self.database);
        formatter.field("schema", &self.schema);
        formatter.finish()
    }
}

/// <p>The request parameters represent the input of a SQL statement over an array of
/// data.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchExecuteStatementInput {
    /// <p>The Amazon Resource Name (ARN) of the Aurora Serverless DB cluster.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The name or ARN of the secret that enables access to the DB cluster.</p>
    pub secret_arn: std::option::Option<std::string::String>,
    /// <p>The SQL statement to run.</p>
    pub sql: std::option::Option<std::string::String>,
    /// <p>The name of the database.</p>
    pub database: std::option::Option<std::string::String>,
    /// <p>The name of the database schema.</p>
    pub schema: std::option::Option<std::string::String>,
    /// <p>The parameter set for the batch operation.</p>
    /// <p>The SQL statement is executed as many times as the number of parameter sets provided.
    /// To execute a SQL statement with no parameters, use one of the following options:</p>
    /// <ul>
    /// <li>
    /// <p>Specify one or more empty parameter sets.</p>
    /// </li>
    /// <li>
    /// <p>Use the <code>ExecuteStatement</code> operation instead of the <code>BatchExecuteStatement</code> operation.</p>
    /// </li>
    /// </ul>
    /// <note>
    /// <p>Array parameters are not supported.</p>
    /// </note>
    pub parameter_sets:
        std::option::Option<std::vec::Vec<std::vec::Vec<crate::model::SqlParameter>>>,
    /// <p>The identifier of a transaction that was started by using the
    /// <code>BeginTransaction</code> operation. Specify the transaction ID of the
    /// transaction that you want to include the SQL statement in.</p>
    /// <p>If the SQL statement is not part of a transaction, don't set this
    /// parameter.</p>
    pub transaction_id: std::option::Option<std::string::String>,
}
impl BatchExecuteStatementInput {
    /// <p>The Amazon Resource Name (ARN) of the Aurora Serverless DB cluster.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The name or ARN of the secret that enables access to the DB cluster.</p>
    pub fn secret_arn(&self) -> std::option::Option<&str> {
        self.secret_arn.as_deref()
    }
    /// <p>The SQL statement to run.</p>
    pub fn sql(&self) -> std::option::Option<&str> {
        self.sql.as_deref()
    }
    /// <p>The name of the database.</p>
    pub fn database(&self) -> std::option::Option<&str> {
        self.database.as_deref()
    }
    /// <p>The name of the database schema.</p>
    pub fn schema(&self) -> std::option::Option<&str> {
        self.schema.as_deref()
    }
    /// <p>The parameter set for the batch operation.</p>
    /// <p>The SQL statement is executed as many times as the number of parameter sets provided.
    /// To execute a SQL statement with no parameters, use one of the following options:</p>
    /// <ul>
    /// <li>
    /// <p>Specify one or more empty parameter sets.</p>
    /// </li>
    /// <li>
    /// <p>Use the <code>ExecuteStatement</code> operation instead of the <code>BatchExecuteStatement</code> operation.</p>
    /// </li>
    /// </ul>
    /// <note>
    /// <p>Array parameters are not supported.</p>
    /// </note>
    pub fn parameter_sets(
        &self,
    ) -> std::option::Option<&[std::vec::Vec<crate::model::SqlParameter>]> {
        self.parameter_sets.as_deref()
    }
    /// <p>The identifier of a transaction that was started by using the
    /// <code>BeginTransaction</code> operation. Specify the transaction ID of the
    /// transaction that you want to include the SQL statement in.</p>
    /// <p>If the SQL statement is not part of a transaction, don't set this
    /// parameter.</p>
    pub fn transaction_id(&self) -> std::option::Option<&str> {
        self.transaction_id.as_deref()
    }
}
impl std::fmt::Debug for BatchExecuteStatementInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchExecuteStatementInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("secret_arn", &self.secret_arn);
        formatter.field("sql", &self.sql);
        formatter.field("database", &self.database);
        formatter.field("schema", &self.schema);
        formatter.field("parameter_sets", &self.parameter_sets);
        formatter.field("transaction_id", &self.transaction_id);
        formatter.finish()
    }
}
