// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for AWS RDS DataService
///
/// Client for invoking operations on AWS RDS DataService. Each operation on AWS RDS DataService is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_rdsdata::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
/// let shared_config = aws_config::load_from_env().await;
/// let config = aws_sdk_rdsdata::config::Builder::from(&shared_config)
///   .retry_config(RetryConfig::disabled())
///   .build();
/// let client = aws_sdk_rdsdata::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`BatchExecuteStatement`](crate::client::fluent_builders::BatchExecuteStatement) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::BatchExecuteStatement::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::BatchExecuteStatement::set_resource_arn): <p>The Amazon Resource Name (ARN) of the Aurora Serverless DB cluster.</p>
    ///   - [`secret_arn(impl Into<String>)`](crate::client::fluent_builders::BatchExecuteStatement::secret_arn) / [`set_secret_arn(Option<String>)`](crate::client::fluent_builders::BatchExecuteStatement::set_secret_arn): <p>The name or ARN of the secret that enables access to the DB cluster.</p>
    ///   - [`sql(impl Into<String>)`](crate::client::fluent_builders::BatchExecuteStatement::sql) / [`set_sql(Option<String>)`](crate::client::fluent_builders::BatchExecuteStatement::set_sql): <p>The SQL statement to run.</p>
    ///   - [`database(impl Into<String>)`](crate::client::fluent_builders::BatchExecuteStatement::database) / [`set_database(Option<String>)`](crate::client::fluent_builders::BatchExecuteStatement::set_database): <p>The name of the database.</p>
    ///   - [`schema(impl Into<String>)`](crate::client::fluent_builders::BatchExecuteStatement::schema) / [`set_schema(Option<String>)`](crate::client::fluent_builders::BatchExecuteStatement::set_schema): <p>The name of the database schema.</p>
    ///   - [`parameter_sets(Vec<Vec<SqlParameter>>)`](crate::client::fluent_builders::BatchExecuteStatement::parameter_sets) / [`set_parameter_sets(Option<Vec<Vec<SqlParameter>>>)`](crate::client::fluent_builders::BatchExecuteStatement::set_parameter_sets): <p>The parameter set for the batch operation.</p>  <p>The SQL statement is executed as many times as the number of parameter sets provided. To execute a SQL statement with no parameters, use one of the following options:</p>  <ul>   <li> <p>Specify one or more empty parameter sets.</p> </li>   <li> <p>Use the <code>ExecuteStatement</code> operation instead of the <code>BatchExecuteStatement</code> operation.</p> </li>  </ul> <note>   <p>Array parameters are not supported.</p>  </note>
    ///   - [`transaction_id(impl Into<String>)`](crate::client::fluent_builders::BatchExecuteStatement::transaction_id) / [`set_transaction_id(Option<String>)`](crate::client::fluent_builders::BatchExecuteStatement::set_transaction_id): <p>The identifier of a transaction that was started by using the <code>BeginTransaction</code> operation. Specify the transaction ID of the transaction that you want to include the SQL statement in.</p>  <p>If the SQL statement is not part of a transaction, don't set this parameter.</p>
    /// - On success, responds with [`BatchExecuteStatementOutput`](crate::output::BatchExecuteStatementOutput) with field(s):
    ///   - [`update_results(Option<Vec<UpdateResult>>)`](crate::output::BatchExecuteStatementOutput::update_results): <p>The execution results of each batch entry.</p>
    /// - On failure, responds with [`SdkError<BatchExecuteStatementError>`](crate::error::BatchExecuteStatementError)
    pub fn batch_execute_statement(&self) -> fluent_builders::BatchExecuteStatement {
        fluent_builders::BatchExecuteStatement::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`BeginTransaction`](crate::client::fluent_builders::BeginTransaction) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::BeginTransaction::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::BeginTransaction::set_resource_arn): <p>The Amazon Resource Name (ARN) of the Aurora Serverless DB cluster.</p>
    ///   - [`secret_arn(impl Into<String>)`](crate::client::fluent_builders::BeginTransaction::secret_arn) / [`set_secret_arn(Option<String>)`](crate::client::fluent_builders::BeginTransaction::set_secret_arn): <p>The name or ARN of the secret that enables access to the DB cluster.</p>
    ///   - [`database(impl Into<String>)`](crate::client::fluent_builders::BeginTransaction::database) / [`set_database(Option<String>)`](crate::client::fluent_builders::BeginTransaction::set_database): <p>The name of the database.</p>
    ///   - [`schema(impl Into<String>)`](crate::client::fluent_builders::BeginTransaction::schema) / [`set_schema(Option<String>)`](crate::client::fluent_builders::BeginTransaction::set_schema): <p>The name of the database schema.</p>
    /// - On success, responds with [`BeginTransactionOutput`](crate::output::BeginTransactionOutput) with field(s):
    ///   - [`transaction_id(Option<String>)`](crate::output::BeginTransactionOutput::transaction_id): <p>The transaction ID of the transaction started by the call.</p>
    /// - On failure, responds with [`SdkError<BeginTransactionError>`](crate::error::BeginTransactionError)
    pub fn begin_transaction(&self) -> fluent_builders::BeginTransaction {
        fluent_builders::BeginTransaction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CommitTransaction`](crate::client::fluent_builders::CommitTransaction) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::CommitTransaction::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::CommitTransaction::set_resource_arn): <p>The Amazon Resource Name (ARN) of the Aurora Serverless DB cluster.</p>
    ///   - [`secret_arn(impl Into<String>)`](crate::client::fluent_builders::CommitTransaction::secret_arn) / [`set_secret_arn(Option<String>)`](crate::client::fluent_builders::CommitTransaction::set_secret_arn): <p>The name or ARN of the secret that enables access to the DB cluster.</p>
    ///   - [`transaction_id(impl Into<String>)`](crate::client::fluent_builders::CommitTransaction::transaction_id) / [`set_transaction_id(Option<String>)`](crate::client::fluent_builders::CommitTransaction::set_transaction_id): <p>The identifier of the transaction to end and commit.</p>
    /// - On success, responds with [`CommitTransactionOutput`](crate::output::CommitTransactionOutput) with field(s):
    ///   - [`transaction_status(Option<String>)`](crate::output::CommitTransactionOutput::transaction_status): <p>The status of the commit operation.</p>
    /// - On failure, responds with [`SdkError<CommitTransactionError>`](crate::error::CommitTransactionError)
    pub fn commit_transaction(&self) -> fluent_builders::CommitTransaction {
        fluent_builders::CommitTransaction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ExecuteSql`](crate::client::fluent_builders::ExecuteSql) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_cluster_or_instance_arn(impl Into<String>)`](crate::client::fluent_builders::ExecuteSql::db_cluster_or_instance_arn) / [`set_db_cluster_or_instance_arn(Option<String>)`](crate::client::fluent_builders::ExecuteSql::set_db_cluster_or_instance_arn): <p>The ARN of the Aurora Serverless DB cluster.</p>
    ///   - [`aws_secret_store_arn(impl Into<String>)`](crate::client::fluent_builders::ExecuteSql::aws_secret_store_arn) / [`set_aws_secret_store_arn(Option<String>)`](crate::client::fluent_builders::ExecuteSql::set_aws_secret_store_arn): <p>The Amazon Resource Name (ARN) of the secret that enables access to the DB cluster.</p>
    ///   - [`sql_statements(impl Into<String>)`](crate::client::fluent_builders::ExecuteSql::sql_statements) / [`set_sql_statements(Option<String>)`](crate::client::fluent_builders::ExecuteSql::set_sql_statements): <p>One or more SQL statements to run on the DB cluster.</p>  <p>You can separate SQL statements from each other with a semicolon (;). Any valid SQL statement is permitted, including data definition, data manipulation, and commit statements. </p>
    ///   - [`database(impl Into<String>)`](crate::client::fluent_builders::ExecuteSql::database) / [`set_database(Option<String>)`](crate::client::fluent_builders::ExecuteSql::set_database): <p>The name of the database.</p>
    ///   - [`schema(impl Into<String>)`](crate::client::fluent_builders::ExecuteSql::schema) / [`set_schema(Option<String>)`](crate::client::fluent_builders::ExecuteSql::set_schema): <p>The name of the database schema.</p>
    /// - On success, responds with [`ExecuteSqlOutput`](crate::output::ExecuteSqlOutput) with field(s):
    ///   - [`sql_statement_results(Option<Vec<SqlStatementResult>>)`](crate::output::ExecuteSqlOutput::sql_statement_results): <p>The results of the SQL statement or statements.</p>
    /// - On failure, responds with [`SdkError<ExecuteSqlError>`](crate::error::ExecuteSqlError)
    pub fn execute_sql(&self) -> fluent_builders::ExecuteSql {
        fluent_builders::ExecuteSql::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ExecuteStatement`](crate::client::fluent_builders::ExecuteStatement) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ExecuteStatement::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ExecuteStatement::set_resource_arn): <p>The Amazon Resource Name (ARN) of the Aurora Serverless DB cluster.</p>
    ///   - [`secret_arn(impl Into<String>)`](crate::client::fluent_builders::ExecuteStatement::secret_arn) / [`set_secret_arn(Option<String>)`](crate::client::fluent_builders::ExecuteStatement::set_secret_arn): <p>The name or ARN of the secret that enables access to the DB cluster.</p>
    ///   - [`sql(impl Into<String>)`](crate::client::fluent_builders::ExecuteStatement::sql) / [`set_sql(Option<String>)`](crate::client::fluent_builders::ExecuteStatement::set_sql): <p>The SQL statement to run.</p>
    ///   - [`database(impl Into<String>)`](crate::client::fluent_builders::ExecuteStatement::database) / [`set_database(Option<String>)`](crate::client::fluent_builders::ExecuteStatement::set_database): <p>The name of the database.</p>
    ///   - [`schema(impl Into<String>)`](crate::client::fluent_builders::ExecuteStatement::schema) / [`set_schema(Option<String>)`](crate::client::fluent_builders::ExecuteStatement::set_schema): <p>The name of the database schema.</p> <note>   <p>Currently, the <code>schema</code> parameter isn't supported.</p>  </note>
    ///   - [`parameters(Vec<SqlParameter>)`](crate::client::fluent_builders::ExecuteStatement::parameters) / [`set_parameters(Option<Vec<SqlParameter>>)`](crate::client::fluent_builders::ExecuteStatement::set_parameters): <p>The parameters for the SQL statement.</p> <note>   <p>Array parameters are not supported.</p>  </note>
    ///   - [`transaction_id(impl Into<String>)`](crate::client::fluent_builders::ExecuteStatement::transaction_id) / [`set_transaction_id(Option<String>)`](crate::client::fluent_builders::ExecuteStatement::set_transaction_id): <p>The identifier of a transaction that was started by using the <code>BeginTransaction</code> operation. Specify the transaction ID of the transaction that you want to include the SQL statement in.</p>  <p>If the SQL statement is not part of a transaction, don't set this parameter.</p>
    ///   - [`include_result_metadata(bool)`](crate::client::fluent_builders::ExecuteStatement::include_result_metadata) / [`set_include_result_metadata(bool)`](crate::client::fluent_builders::ExecuteStatement::set_include_result_metadata): <p>A value that indicates whether to include metadata in the results.</p>
    ///   - [`continue_after_timeout(bool)`](crate::client::fluent_builders::ExecuteStatement::continue_after_timeout) / [`set_continue_after_timeout(bool)`](crate::client::fluent_builders::ExecuteStatement::set_continue_after_timeout): <p>A value that indicates whether to continue running the statement after the call times out. By default, the statement stops running when the call times out.</p> <important>   <p>For DDL statements, we recommend continuing to run the statement after the call times out. When a DDL statement terminates before it is finished running, it can result in errors and possibly corrupted data structures.</p>  </important>
    ///   - [`result_set_options(ResultSetOptions)`](crate::client::fluent_builders::ExecuteStatement::result_set_options) / [`set_result_set_options(Option<ResultSetOptions>)`](crate::client::fluent_builders::ExecuteStatement::set_result_set_options): <p>Options that control how the result set is returned.</p>
    ///   - [`format_records_as(RecordsFormatType)`](crate::client::fluent_builders::ExecuteStatement::format_records_as) / [`set_format_records_as(Option<RecordsFormatType>)`](crate::client::fluent_builders::ExecuteStatement::set_format_records_as): <p>A value that indicates whether to format the result set as a single JSON string. This parameter only applies to <code>SELECT</code> statements and is ignored for other types of statements. Allowed values are <code>NONE</code> and <code>JSON</code>. The default value is <code>NONE</code>. The result is returned in the <code>formattedRecords</code> field.</p>  <p>For usage information about the JSON format for result sets, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/data-api.html">Using the Data API</a> in the <i>Amazon Aurora User Guide</i>.</p>
    /// - On success, responds with [`ExecuteStatementOutput`](crate::output::ExecuteStatementOutput) with field(s):
    ///   - [`records(Option<Vec<Vec<Field>>>)`](crate::output::ExecuteStatementOutput::records): <p>The records returned by the SQL statement. This field is blank if the <code>formatRecordsAs</code> parameter is set to <code>JSON</code>.</p>
    ///   - [`column_metadata(Option<Vec<ColumnMetadata>>)`](crate::output::ExecuteStatementOutput::column_metadata): <p>Metadata for the columns included in the results. This field is blank if the <code>formatRecordsAs</code> parameter is set to <code>JSON</code>.</p>
    ///   - [`number_of_records_updated(i64)`](crate::output::ExecuteStatementOutput::number_of_records_updated): <p>The number of records updated by the request.</p>
    ///   - [`generated_fields(Option<Vec<Field>>)`](crate::output::ExecuteStatementOutput::generated_fields): <p>Values for fields generated during a DML request.</p> <note>   <p>The <code>generatedFields</code> data isn't supported by Aurora PostgreSQL. To get the values of generated fields, use the <code>RETURNING</code> clause. For more information, see <a href="https://www.postgresql.org/docs/10/dml-returning.html">Returning Data From Modified Rows</a> in the PostgreSQL documentation.</p>  </note>
    ///   - [`formatted_records(Option<String>)`](crate::output::ExecuteStatementOutput::formatted_records): <p>A string value that represents the result set of a <code>SELECT</code> statement in JSON format. This value is only present when the <code>formatRecordsAs</code> parameter is set to <code>JSON</code>.</p>  <p>The size limit for this field is currently 10 MB. If the JSON-formatted string representing the result set requires more than 10 MB, the call returns an error.</p>
    /// - On failure, responds with [`SdkError<ExecuteStatementError>`](crate::error::ExecuteStatementError)
    pub fn execute_statement(&self) -> fluent_builders::ExecuteStatement {
        fluent_builders::ExecuteStatement::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RollbackTransaction`](crate::client::fluent_builders::RollbackTransaction) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::RollbackTransaction::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::RollbackTransaction::set_resource_arn): <p>The Amazon Resource Name (ARN) of the Aurora Serverless DB cluster.</p>
    ///   - [`secret_arn(impl Into<String>)`](crate::client::fluent_builders::RollbackTransaction::secret_arn) / [`set_secret_arn(Option<String>)`](crate::client::fluent_builders::RollbackTransaction::set_secret_arn): <p>The name or ARN of the secret that enables access to the DB cluster.</p>
    ///   - [`transaction_id(impl Into<String>)`](crate::client::fluent_builders::RollbackTransaction::transaction_id) / [`set_transaction_id(Option<String>)`](crate::client::fluent_builders::RollbackTransaction::set_transaction_id): <p>The identifier of the transaction to roll back.</p>
    /// - On success, responds with [`RollbackTransactionOutput`](crate::output::RollbackTransactionOutput) with field(s):
    ///   - [`transaction_status(Option<String>)`](crate::output::RollbackTransactionOutput::transaction_status): <p>The status of the rollback operation.</p>
    /// - On failure, responds with [`SdkError<RollbackTransactionError>`](crate::error::RollbackTransactionError)
    pub fn rollback_transaction(&self) -> fluent_builders::RollbackTransaction {
        fluent_builders::RollbackTransaction::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `BatchExecuteStatement`.
    ///
    /// <p>Runs a batch SQL statement over an array of data.</p>
    /// <p>You can run bulk update and insert operations for multiple records using a DML statement with different parameter sets. Bulk operations can provide a significant performance improvement over individual insert and update operations.</p> <important>
    /// <p>If a call isn't part of a transaction because it doesn't include the <code>transactionID</code> parameter, changes that result from the call are committed automatically.</p>
    /// </important>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct BatchExecuteStatement {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::batch_execute_statement_input::Builder,
    }
    impl BatchExecuteStatement {
        /// Creates a new `BatchExecuteStatement`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchExecuteStatementOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchExecuteStatementError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the Aurora Serverless DB cluster.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Aurora Serverless DB cluster.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// <p>The name or ARN of the secret that enables access to the DB cluster.</p>
        pub fn secret_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.secret_arn(input.into());
            self
        }
        /// <p>The name or ARN of the secret that enables access to the DB cluster.</p>
        pub fn set_secret_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_secret_arn(input);
            self
        }
        /// <p>The SQL statement to run.</p>
        pub fn sql(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sql(input.into());
            self
        }
        /// <p>The SQL statement to run.</p>
        pub fn set_sql(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_sql(input);
            self
        }
        /// <p>The name of the database.</p>
        pub fn database(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.database(input.into());
            self
        }
        /// <p>The name of the database.</p>
        pub fn set_database(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_database(input);
            self
        }
        /// <p>The name of the database schema.</p>
        pub fn schema(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schema(input.into());
            self
        }
        /// <p>The name of the database schema.</p>
        pub fn set_schema(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_schema(input);
            self
        }
        /// Appends an item to `parameterSets`.
        ///
        /// To override the contents of this collection use [`set_parameter_sets`](Self::set_parameter_sets).
        ///
        /// <p>The parameter set for the batch operation.</p>
        /// <p>The SQL statement is executed as many times as the number of parameter sets provided. To execute a SQL statement with no parameters, use one of the following options:</p>
        /// <ul>
        /// <li> <p>Specify one or more empty parameter sets.</p> </li>
        /// <li> <p>Use the <code>ExecuteStatement</code> operation instead of the <code>BatchExecuteStatement</code> operation.</p> </li>
        /// </ul> <note>
        /// <p>Array parameters are not supported.</p>
        /// </note>
        pub fn parameter_sets(mut self, input: std::vec::Vec<crate::model::SqlParameter>) -> Self {
            self.inner = self.inner.parameter_sets(input);
            self
        }
        /// <p>The parameter set for the batch operation.</p>
        /// <p>The SQL statement is executed as many times as the number of parameter sets provided. To execute a SQL statement with no parameters, use one of the following options:</p>
        /// <ul>
        /// <li> <p>Specify one or more empty parameter sets.</p> </li>
        /// <li> <p>Use the <code>ExecuteStatement</code> operation instead of the <code>BatchExecuteStatement</code> operation.</p> </li>
        /// </ul> <note>
        /// <p>Array parameters are not supported.</p>
        /// </note>
        pub fn set_parameter_sets(
            mut self,
            input: std::option::Option<std::vec::Vec<std::vec::Vec<crate::model::SqlParameter>>>,
        ) -> Self {
            self.inner = self.inner.set_parameter_sets(input);
            self
        }
        /// <p>The identifier of a transaction that was started by using the <code>BeginTransaction</code> operation. Specify the transaction ID of the transaction that you want to include the SQL statement in.</p>
        /// <p>If the SQL statement is not part of a transaction, don't set this parameter.</p>
        pub fn transaction_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.transaction_id(input.into());
            self
        }
        /// <p>The identifier of a transaction that was started by using the <code>BeginTransaction</code> operation. Specify the transaction ID of the transaction that you want to include the SQL statement in.</p>
        /// <p>If the SQL statement is not part of a transaction, don't set this parameter.</p>
        pub fn set_transaction_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_transaction_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BeginTransaction`.
    ///
    /// <p>Starts a SQL transaction.</p> <important>
    /// <p>A transaction can run for a maximum of 24 hours. A transaction is terminated and rolled back automatically after 24 hours.</p>
    /// <p>A transaction times out if no calls use its transaction ID in three minutes. If a transaction times out before it's committed, it's rolled back automatically.</p>
    /// <p>DDL statements inside a transaction cause an implicit commit. We recommend that you run each DDL statement in a separate <code>ExecuteStatement</code> call with <code>continueAfterTimeout</code> enabled.</p>
    /// </important>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct BeginTransaction {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::begin_transaction_input::Builder,
    }
    impl BeginTransaction {
        /// Creates a new `BeginTransaction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BeginTransactionOutput,
            aws_smithy_http::result::SdkError<crate::error::BeginTransactionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the Aurora Serverless DB cluster.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Aurora Serverless DB cluster.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// <p>The name or ARN of the secret that enables access to the DB cluster.</p>
        pub fn secret_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.secret_arn(input.into());
            self
        }
        /// <p>The name or ARN of the secret that enables access to the DB cluster.</p>
        pub fn set_secret_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_secret_arn(input);
            self
        }
        /// <p>The name of the database.</p>
        pub fn database(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.database(input.into());
            self
        }
        /// <p>The name of the database.</p>
        pub fn set_database(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_database(input);
            self
        }
        /// <p>The name of the database schema.</p>
        pub fn schema(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schema(input.into());
            self
        }
        /// <p>The name of the database schema.</p>
        pub fn set_schema(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_schema(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CommitTransaction`.
    ///
    /// <p>Ends a SQL transaction started with the <code>BeginTransaction</code> operation and commits the changes.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CommitTransaction {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::commit_transaction_input::Builder,
    }
    impl CommitTransaction {
        /// Creates a new `CommitTransaction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CommitTransactionOutput,
            aws_smithy_http::result::SdkError<crate::error::CommitTransactionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the Aurora Serverless DB cluster.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Aurora Serverless DB cluster.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// <p>The name or ARN of the secret that enables access to the DB cluster.</p>
        pub fn secret_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.secret_arn(input.into());
            self
        }
        /// <p>The name or ARN of the secret that enables access to the DB cluster.</p>
        pub fn set_secret_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_secret_arn(input);
            self
        }
        /// <p>The identifier of the transaction to end and commit.</p>
        pub fn transaction_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.transaction_id(input.into());
            self
        }
        /// <p>The identifier of the transaction to end and commit.</p>
        pub fn set_transaction_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_transaction_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ExecuteSql`.
    ///
    /// <p>Runs one or more SQL statements.</p> <important>
    /// <p>This operation is deprecated. Use the <code>BatchExecuteStatement</code> or <code>ExecuteStatement</code> operation.</p>
    /// </important>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ExecuteSql {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::execute_sql_input::Builder,
    }
    impl ExecuteSql {
        /// Creates a new `ExecuteSql`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ExecuteSqlOutput,
            aws_smithy_http::result::SdkError<crate::error::ExecuteSqlError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ARN of the Aurora Serverless DB cluster.</p>
        pub fn db_cluster_or_instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_cluster_or_instance_arn(input.into());
            self
        }
        /// <p>The ARN of the Aurora Serverless DB cluster.</p>
        pub fn set_db_cluster_or_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_or_instance_arn(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the secret that enables access to the DB cluster.</p>
        pub fn aws_secret_store_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.aws_secret_store_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the secret that enables access to the DB cluster.</p>
        pub fn set_aws_secret_store_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_aws_secret_store_arn(input);
            self
        }
        /// <p>One or more SQL statements to run on the DB cluster.</p>
        /// <p>You can separate SQL statements from each other with a semicolon (;). Any valid SQL statement is permitted, including data definition, data manipulation, and commit statements. </p>
        pub fn sql_statements(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sql_statements(input.into());
            self
        }
        /// <p>One or more SQL statements to run on the DB cluster.</p>
        /// <p>You can separate SQL statements from each other with a semicolon (;). Any valid SQL statement is permitted, including data definition, data manipulation, and commit statements. </p>
        pub fn set_sql_statements(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_sql_statements(input);
            self
        }
        /// <p>The name of the database.</p>
        pub fn database(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.database(input.into());
            self
        }
        /// <p>The name of the database.</p>
        pub fn set_database(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_database(input);
            self
        }
        /// <p>The name of the database schema.</p>
        pub fn schema(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schema(input.into());
            self
        }
        /// <p>The name of the database schema.</p>
        pub fn set_schema(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_schema(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ExecuteStatement`.
    ///
    /// <p>Runs a SQL statement against a database.</p> <important>
    /// <p>If a call isn't part of a transaction because it doesn't include the <code>transactionID</code> parameter, changes that result from the call are committed automatically.</p>
    /// </important>
    /// <p>If the binary response data from the database is more than 1 MB, the call is terminated.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ExecuteStatement {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::execute_statement_input::Builder,
    }
    impl ExecuteStatement {
        /// Creates a new `ExecuteStatement`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ExecuteStatementOutput,
            aws_smithy_http::result::SdkError<crate::error::ExecuteStatementError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the Aurora Serverless DB cluster.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Aurora Serverless DB cluster.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// <p>The name or ARN of the secret that enables access to the DB cluster.</p>
        pub fn secret_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.secret_arn(input.into());
            self
        }
        /// <p>The name or ARN of the secret that enables access to the DB cluster.</p>
        pub fn set_secret_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_secret_arn(input);
            self
        }
        /// <p>The SQL statement to run.</p>
        pub fn sql(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sql(input.into());
            self
        }
        /// <p>The SQL statement to run.</p>
        pub fn set_sql(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_sql(input);
            self
        }
        /// <p>The name of the database.</p>
        pub fn database(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.database(input.into());
            self
        }
        /// <p>The name of the database.</p>
        pub fn set_database(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_database(input);
            self
        }
        /// <p>The name of the database schema.</p> <note>
        /// <p>Currently, the <code>schema</code> parameter isn't supported.</p>
        /// </note>
        pub fn schema(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.schema(input.into());
            self
        }
        /// <p>The name of the database schema.</p> <note>
        /// <p>Currently, the <code>schema</code> parameter isn't supported.</p>
        /// </note>
        pub fn set_schema(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_schema(input);
            self
        }
        /// Appends an item to `parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>The parameters for the SQL statement.</p> <note>
        /// <p>Array parameters are not supported.</p>
        /// </note>
        pub fn parameters(mut self, input: crate::model::SqlParameter) -> Self {
            self.inner = self.inner.parameters(input);
            self
        }
        /// <p>The parameters for the SQL statement.</p> <note>
        /// <p>Array parameters are not supported.</p>
        /// </note>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SqlParameter>>,
        ) -> Self {
            self.inner = self.inner.set_parameters(input);
            self
        }
        /// <p>The identifier of a transaction that was started by using the <code>BeginTransaction</code> operation. Specify the transaction ID of the transaction that you want to include the SQL statement in.</p>
        /// <p>If the SQL statement is not part of a transaction, don't set this parameter.</p>
        pub fn transaction_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.transaction_id(input.into());
            self
        }
        /// <p>The identifier of a transaction that was started by using the <code>BeginTransaction</code> operation. Specify the transaction ID of the transaction that you want to include the SQL statement in.</p>
        /// <p>If the SQL statement is not part of a transaction, don't set this parameter.</p>
        pub fn set_transaction_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_transaction_id(input);
            self
        }
        /// <p>A value that indicates whether to include metadata in the results.</p>
        pub fn include_result_metadata(mut self, input: bool) -> Self {
            self.inner = self.inner.include_result_metadata(input);
            self
        }
        /// <p>A value that indicates whether to include metadata in the results.</p>
        pub fn set_include_result_metadata(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_include_result_metadata(input);
            self
        }
        /// <p>A value that indicates whether to continue running the statement after the call times out. By default, the statement stops running when the call times out.</p> <important>
        /// <p>For DDL statements, we recommend continuing to run the statement after the call times out. When a DDL statement terminates before it is finished running, it can result in errors and possibly corrupted data structures.</p>
        /// </important>
        pub fn continue_after_timeout(mut self, input: bool) -> Self {
            self.inner = self.inner.continue_after_timeout(input);
            self
        }
        /// <p>A value that indicates whether to continue running the statement after the call times out. By default, the statement stops running when the call times out.</p> <important>
        /// <p>For DDL statements, we recommend continuing to run the statement after the call times out. When a DDL statement terminates before it is finished running, it can result in errors and possibly corrupted data structures.</p>
        /// </important>
        pub fn set_continue_after_timeout(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_continue_after_timeout(input);
            self
        }
        /// <p>Options that control how the result set is returned.</p>
        pub fn result_set_options(mut self, input: crate::model::ResultSetOptions) -> Self {
            self.inner = self.inner.result_set_options(input);
            self
        }
        /// <p>Options that control how the result set is returned.</p>
        pub fn set_result_set_options(
            mut self,
            input: std::option::Option<crate::model::ResultSetOptions>,
        ) -> Self {
            self.inner = self.inner.set_result_set_options(input);
            self
        }
        /// <p>A value that indicates whether to format the result set as a single JSON string. This parameter only applies to <code>SELECT</code> statements and is ignored for other types of statements. Allowed values are <code>NONE</code> and <code>JSON</code>. The default value is <code>NONE</code>. The result is returned in the <code>formattedRecords</code> field.</p>
        /// <p>For usage information about the JSON format for result sets, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/data-api.html">Using the Data API</a> in the <i>Amazon Aurora User Guide</i>.</p>
        pub fn format_records_as(mut self, input: crate::model::RecordsFormatType) -> Self {
            self.inner = self.inner.format_records_as(input);
            self
        }
        /// <p>A value that indicates whether to format the result set as a single JSON string. This parameter only applies to <code>SELECT</code> statements and is ignored for other types of statements. Allowed values are <code>NONE</code> and <code>JSON</code>. The default value is <code>NONE</code>. The result is returned in the <code>formattedRecords</code> field.</p>
        /// <p>For usage information about the JSON format for result sets, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/data-api.html">Using the Data API</a> in the <i>Amazon Aurora User Guide</i>.</p>
        pub fn set_format_records_as(
            mut self,
            input: std::option::Option<crate::model::RecordsFormatType>,
        ) -> Self {
            self.inner = self.inner.set_format_records_as(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RollbackTransaction`.
    ///
    /// <p>Performs a rollback of a transaction. Rolling back a transaction cancels its changes.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RollbackTransaction {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::rollback_transaction_input::Builder,
    }
    impl RollbackTransaction {
        /// Creates a new `RollbackTransaction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RollbackTransactionOutput,
            aws_smithy_http::result::SdkError<crate::error::RollbackTransactionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the Aurora Serverless DB cluster.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Aurora Serverless DB cluster.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// <p>The name or ARN of the secret that enables access to the DB cluster.</p>
        pub fn secret_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.secret_arn(input.into());
            self
        }
        /// <p>The name or ARN of the secret that enables access to the DB cluster.</p>
        pub fn set_secret_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_secret_arn(input);
            self
        }
        /// <p>The identifier of the transaction to roll back.</p>
        pub fn transaction_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.transaction_id(input.into());
            self
        }
        /// <p>The identifier of the transaction to roll back.</p>
        pub fn set_transaction_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_transaction_id(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(sdk_config: &aws_types::sdk_config::SdkConfig) -> Self {
        Self::from_conf(sdk_config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
