// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Contains a value.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
pub enum Field {
    /// <p>An array of values.</p>
    ArrayValue(crate::model::ArrayValue),
    /// <p>A value of BLOB data type.</p>
    BlobValue(aws_smithy_types::Blob),
    /// <p>A value of Boolean data type.</p>
    BooleanValue(bool),
    /// <p>A value of double data type.</p>
    DoubleValue(f64),
    /// <p>A NULL value.</p>
    IsNull(bool),
    /// <p>A value of long data type.</p>
    LongValue(i64),
    /// <p>A value of string data type.</p>
    StringValue(std::string::String),
    /// The `Unknown` variant represents cases where new union variant was received. Consider upgrading the SDK to the latest available version.
    /// An unknown enum variant
    ///
    /// _Note: If you encounter this error, consider upgrading your SDK to the latest version._
    /// The `Unknown` variant represents cases where the server sent a value that wasn't recognized
    /// by the client. This can happen when the server adds new functionality, but the client has not been updated.
    /// To investigate this, consider turning on debug logging to print the raw HTTP response.
    #[non_exhaustive]
    Unknown,
}
impl Field {
    /// Tries to convert the enum instance into [`ArrayValue`](crate::model::Field::ArrayValue), extracting the inner [`ArrayValue`](crate::model::ArrayValue).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_array_value(&self) -> std::result::Result<&crate::model::ArrayValue, &Self> {
        if let Field::ArrayValue(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if this is a [`ArrayValue`](crate::model::Field::ArrayValue).
    pub fn is_array_value(&self) -> bool {
        self.as_array_value().is_ok()
    }
    /// Tries to convert the enum instance into [`BlobValue`](crate::model::Field::BlobValue), extracting the inner [`Blob`](aws_smithy_types::Blob).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_blob_value(&self) -> std::result::Result<&aws_smithy_types::Blob, &Self> {
        if let Field::BlobValue(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if this is a [`BlobValue`](crate::model::Field::BlobValue).
    pub fn is_blob_value(&self) -> bool {
        self.as_blob_value().is_ok()
    }
    /// Tries to convert the enum instance into [`BooleanValue`](crate::model::Field::BooleanValue), extracting the inner [`bool`](bool).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_boolean_value(&self) -> std::result::Result<&bool, &Self> {
        if let Field::BooleanValue(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if this is a [`BooleanValue`](crate::model::Field::BooleanValue).
    pub fn is_boolean_value(&self) -> bool {
        self.as_boolean_value().is_ok()
    }
    /// Tries to convert the enum instance into [`DoubleValue`](crate::model::Field::DoubleValue), extracting the inner [`f64`](f64).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_double_value(&self) -> std::result::Result<&f64, &Self> {
        if let Field::DoubleValue(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if this is a [`DoubleValue`](crate::model::Field::DoubleValue).
    pub fn is_double_value(&self) -> bool {
        self.as_double_value().is_ok()
    }
    /// Tries to convert the enum instance into [`IsNull`](crate::model::Field::IsNull), extracting the inner [`bool`](bool).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_is_null(&self) -> std::result::Result<&bool, &Self> {
        if let Field::IsNull(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if this is a [`IsNull`](crate::model::Field::IsNull).
    pub fn is_is_null(&self) -> bool {
        self.as_is_null().is_ok()
    }
    /// Tries to convert the enum instance into [`LongValue`](crate::model::Field::LongValue), extracting the inner [`i64`](i64).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_long_value(&self) -> std::result::Result<&i64, &Self> {
        if let Field::LongValue(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if this is a [`LongValue`](crate::model::Field::LongValue).
    pub fn is_long_value(&self) -> bool {
        self.as_long_value().is_ok()
    }
    /// Tries to convert the enum instance into [`StringValue`](crate::model::Field::StringValue), extracting the inner [`String`](std::string::String).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_string_value(&self) -> std::result::Result<&std::string::String, &Self> {
        if let Field::StringValue(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if this is a [`StringValue`](crate::model::Field::StringValue).
    pub fn is_string_value(&self) -> bool {
        self.as_string_value().is_ok()
    }
    /// Returns true if the enum instance is the `Unknown` variant.
    pub fn is_unknown(&self) -> bool {
        matches!(self, Self::Unknown)
    }
}

/// <p>Contains an array.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
pub enum ArrayValue {
    /// <p>An array of arrays.</p>
    ArrayValues(std::vec::Vec<crate::model::ArrayValue>),
    /// <p>An array of Boolean values.</p>
    BooleanValues(std::vec::Vec<bool>),
    /// <p>An array of integers.</p>
    DoubleValues(std::vec::Vec<f64>),
    /// <p>An array of floating point numbers.</p>
    LongValues(std::vec::Vec<i64>),
    /// <p>An array of strings.</p>
    StringValues(std::vec::Vec<std::string::String>),
    /// The `Unknown` variant represents cases where new union variant was received. Consider upgrading the SDK to the latest available version.
    /// An unknown enum variant
    ///
    /// _Note: If you encounter this error, consider upgrading your SDK to the latest version._
    /// The `Unknown` variant represents cases where the server sent a value that wasn't recognized
    /// by the client. This can happen when the server adds new functionality, but the client has not been updated.
    /// To investigate this, consider turning on debug logging to print the raw HTTP response.
    #[non_exhaustive]
    Unknown,
}
impl ArrayValue {
    /// Tries to convert the enum instance into [`ArrayValues`](crate::model::ArrayValue::ArrayValues), extracting the inner [`Vec`](std::vec::Vec).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_array_values(
        &self,
    ) -> std::result::Result<&std::vec::Vec<crate::model::ArrayValue>, &Self> {
        if let ArrayValue::ArrayValues(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if this is a [`ArrayValues`](crate::model::ArrayValue::ArrayValues).
    pub fn is_array_values(&self) -> bool {
        self.as_array_values().is_ok()
    }
    /// Tries to convert the enum instance into [`BooleanValues`](crate::model::ArrayValue::BooleanValues), extracting the inner [`Vec`](std::vec::Vec).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_boolean_values(&self) -> std::result::Result<&std::vec::Vec<bool>, &Self> {
        if let ArrayValue::BooleanValues(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if this is a [`BooleanValues`](crate::model::ArrayValue::BooleanValues).
    pub fn is_boolean_values(&self) -> bool {
        self.as_boolean_values().is_ok()
    }
    /// Tries to convert the enum instance into [`DoubleValues`](crate::model::ArrayValue::DoubleValues), extracting the inner [`Vec`](std::vec::Vec).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_double_values(&self) -> std::result::Result<&std::vec::Vec<f64>, &Self> {
        if let ArrayValue::DoubleValues(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if this is a [`DoubleValues`](crate::model::ArrayValue::DoubleValues).
    pub fn is_double_values(&self) -> bool {
        self.as_double_values().is_ok()
    }
    /// Tries to convert the enum instance into [`LongValues`](crate::model::ArrayValue::LongValues), extracting the inner [`Vec`](std::vec::Vec).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_long_values(&self) -> std::result::Result<&std::vec::Vec<i64>, &Self> {
        if let ArrayValue::LongValues(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if this is a [`LongValues`](crate::model::ArrayValue::LongValues).
    pub fn is_long_values(&self) -> bool {
        self.as_long_values().is_ok()
    }
    /// Tries to convert the enum instance into [`StringValues`](crate::model::ArrayValue::StringValues), extracting the inner [`Vec`](std::vec::Vec).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_string_values(
        &self,
    ) -> std::result::Result<&std::vec::Vec<std::string::String>, &Self> {
        if let ArrayValue::StringValues(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if this is a [`StringValues`](crate::model::ArrayValue::StringValues).
    pub fn is_string_values(&self) -> bool {
        self.as_string_values().is_ok()
    }
    /// Returns true if the enum instance is the `Unknown` variant.
    pub fn is_unknown(&self) -> bool {
        matches!(self, Self::Unknown)
    }
}

/// <p>Contains the metadata for a column.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ColumnMetadata {
    /// <p>The name of the column.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The type of the column.</p>
    pub r#type: i32,
    /// <p>The database-specific data type of the column.</p>
    pub type_name: std::option::Option<std::string::String>,
    /// <p>The label for the column.</p>
    pub label: std::option::Option<std::string::String>,
    /// <p>The name of the schema that owns the table that includes the column.</p>
    pub schema_name: std::option::Option<std::string::String>,
    /// <p>The name of the table that includes the column.</p>
    pub table_name: std::option::Option<std::string::String>,
    /// <p>A value that indicates whether the column increments automatically.</p>
    pub is_auto_increment: bool,
    /// <p>A value that indicates whether an integer column is signed.</p>
    pub is_signed: bool,
    /// <p>A value that indicates whether the column contains currency values.</p>
    pub is_currency: bool,
    /// <p>A value that indicates whether the column is case-sensitive.</p>
    pub is_case_sensitive: bool,
    /// <p>A value that indicates whether the column is nullable.</p>
    pub nullable: i32,
    /// <p>The precision value of a decimal number column.</p>
    pub precision: i32,
    /// <p>The scale value of a decimal number column.</p>
    pub scale: i32,
    /// <p>The type of the column.</p>
    pub array_base_column_type: i32,
}
impl ColumnMetadata {
    /// <p>The name of the column.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The type of the column.</p>
    pub fn r#type(&self) -> i32 {
        self.r#type
    }
    /// <p>The database-specific data type of the column.</p>
    pub fn type_name(&self) -> std::option::Option<&str> {
        self.type_name.as_deref()
    }
    /// <p>The label for the column.</p>
    pub fn label(&self) -> std::option::Option<&str> {
        self.label.as_deref()
    }
    /// <p>The name of the schema that owns the table that includes the column.</p>
    pub fn schema_name(&self) -> std::option::Option<&str> {
        self.schema_name.as_deref()
    }
    /// <p>The name of the table that includes the column.</p>
    pub fn table_name(&self) -> std::option::Option<&str> {
        self.table_name.as_deref()
    }
    /// <p>A value that indicates whether the column increments automatically.</p>
    pub fn is_auto_increment(&self) -> bool {
        self.is_auto_increment
    }
    /// <p>A value that indicates whether an integer column is signed.</p>
    pub fn is_signed(&self) -> bool {
        self.is_signed
    }
    /// <p>A value that indicates whether the column contains currency values.</p>
    pub fn is_currency(&self) -> bool {
        self.is_currency
    }
    /// <p>A value that indicates whether the column is case-sensitive.</p>
    pub fn is_case_sensitive(&self) -> bool {
        self.is_case_sensitive
    }
    /// <p>A value that indicates whether the column is nullable.</p>
    pub fn nullable(&self) -> i32 {
        self.nullable
    }
    /// <p>The precision value of a decimal number column.</p>
    pub fn precision(&self) -> i32 {
        self.precision
    }
    /// <p>The scale value of a decimal number column.</p>
    pub fn scale(&self) -> i32 {
        self.scale
    }
    /// <p>The type of the column.</p>
    pub fn array_base_column_type(&self) -> i32 {
        self.array_base_column_type
    }
}
impl std::fmt::Debug for ColumnMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ColumnMetadata");
        formatter.field("name", &self.name);
        formatter.field("r#type", &self.r#type);
        formatter.field("type_name", &self.type_name);
        formatter.field("label", &self.label);
        formatter.field("schema_name", &self.schema_name);
        formatter.field("table_name", &self.table_name);
        formatter.field("is_auto_increment", &self.is_auto_increment);
        formatter.field("is_signed", &self.is_signed);
        formatter.field("is_currency", &self.is_currency);
        formatter.field("is_case_sensitive", &self.is_case_sensitive);
        formatter.field("nullable", &self.nullable);
        formatter.field("precision", &self.precision);
        formatter.field("scale", &self.scale);
        formatter.field("array_base_column_type", &self.array_base_column_type);
        formatter.finish()
    }
}
/// See [`ColumnMetadata`](crate::model::ColumnMetadata)
pub mod column_metadata {
    /// A builder for [`ColumnMetadata`](crate::model::ColumnMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<i32>,
        pub(crate) type_name: std::option::Option<std::string::String>,
        pub(crate) label: std::option::Option<std::string::String>,
        pub(crate) schema_name: std::option::Option<std::string::String>,
        pub(crate) table_name: std::option::Option<std::string::String>,
        pub(crate) is_auto_increment: std::option::Option<bool>,
        pub(crate) is_signed: std::option::Option<bool>,
        pub(crate) is_currency: std::option::Option<bool>,
        pub(crate) is_case_sensitive: std::option::Option<bool>,
        pub(crate) nullable: std::option::Option<i32>,
        pub(crate) precision: std::option::Option<i32>,
        pub(crate) scale: std::option::Option<i32>,
        pub(crate) array_base_column_type: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the column.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the column.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The type of the column.</p>
        pub fn r#type(mut self, input: i32) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of the column.</p>
        pub fn set_type(mut self, input: std::option::Option<i32>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The database-specific data type of the column.</p>
        pub fn type_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.type_name = Some(input.into());
            self
        }
        /// <p>The database-specific data type of the column.</p>
        pub fn set_type_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.type_name = input;
            self
        }
        /// <p>The label for the column.</p>
        pub fn label(mut self, input: impl Into<std::string::String>) -> Self {
            self.label = Some(input.into());
            self
        }
        /// <p>The label for the column.</p>
        pub fn set_label(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.label = input;
            self
        }
        /// <p>The name of the schema that owns the table that includes the column.</p>
        pub fn schema_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_name = Some(input.into());
            self
        }
        /// <p>The name of the schema that owns the table that includes the column.</p>
        pub fn set_schema_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schema_name = input;
            self
        }
        /// <p>The name of the table that includes the column.</p>
        pub fn table_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.table_name = Some(input.into());
            self
        }
        /// <p>The name of the table that includes the column.</p>
        pub fn set_table_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.table_name = input;
            self
        }
        /// <p>A value that indicates whether the column increments automatically.</p>
        pub fn is_auto_increment(mut self, input: bool) -> Self {
            self.is_auto_increment = Some(input);
            self
        }
        /// <p>A value that indicates whether the column increments automatically.</p>
        pub fn set_is_auto_increment(mut self, input: std::option::Option<bool>) -> Self {
            self.is_auto_increment = input;
            self
        }
        /// <p>A value that indicates whether an integer column is signed.</p>
        pub fn is_signed(mut self, input: bool) -> Self {
            self.is_signed = Some(input);
            self
        }
        /// <p>A value that indicates whether an integer column is signed.</p>
        pub fn set_is_signed(mut self, input: std::option::Option<bool>) -> Self {
            self.is_signed = input;
            self
        }
        /// <p>A value that indicates whether the column contains currency values.</p>
        pub fn is_currency(mut self, input: bool) -> Self {
            self.is_currency = Some(input);
            self
        }
        /// <p>A value that indicates whether the column contains currency values.</p>
        pub fn set_is_currency(mut self, input: std::option::Option<bool>) -> Self {
            self.is_currency = input;
            self
        }
        /// <p>A value that indicates whether the column is case-sensitive.</p>
        pub fn is_case_sensitive(mut self, input: bool) -> Self {
            self.is_case_sensitive = Some(input);
            self
        }
        /// <p>A value that indicates whether the column is case-sensitive.</p>
        pub fn set_is_case_sensitive(mut self, input: std::option::Option<bool>) -> Self {
            self.is_case_sensitive = input;
            self
        }
        /// <p>A value that indicates whether the column is nullable.</p>
        pub fn nullable(mut self, input: i32) -> Self {
            self.nullable = Some(input);
            self
        }
        /// <p>A value that indicates whether the column is nullable.</p>
        pub fn set_nullable(mut self, input: std::option::Option<i32>) -> Self {
            self.nullable = input;
            self
        }
        /// <p>The precision value of a decimal number column.</p>
        pub fn precision(mut self, input: i32) -> Self {
            self.precision = Some(input);
            self
        }
        /// <p>The precision value of a decimal number column.</p>
        pub fn set_precision(mut self, input: std::option::Option<i32>) -> Self {
            self.precision = input;
            self
        }
        /// <p>The scale value of a decimal number column.</p>
        pub fn scale(mut self, input: i32) -> Self {
            self.scale = Some(input);
            self
        }
        /// <p>The scale value of a decimal number column.</p>
        pub fn set_scale(mut self, input: std::option::Option<i32>) -> Self {
            self.scale = input;
            self
        }
        /// <p>The type of the column.</p>
        pub fn array_base_column_type(mut self, input: i32) -> Self {
            self.array_base_column_type = Some(input);
            self
        }
        /// <p>The type of the column.</p>
        pub fn set_array_base_column_type(mut self, input: std::option::Option<i32>) -> Self {
            self.array_base_column_type = input;
            self
        }
        /// Consumes the builder and constructs a [`ColumnMetadata`](crate::model::ColumnMetadata)
        pub fn build(self) -> crate::model::ColumnMetadata {
            crate::model::ColumnMetadata {
                name: self.name,
                r#type: self.r#type.unwrap_or_default(),
                type_name: self.type_name,
                label: self.label,
                schema_name: self.schema_name,
                table_name: self.table_name,
                is_auto_increment: self.is_auto_increment.unwrap_or_default(),
                is_signed: self.is_signed.unwrap_or_default(),
                is_currency: self.is_currency.unwrap_or_default(),
                is_case_sensitive: self.is_case_sensitive.unwrap_or_default(),
                nullable: self.nullable.unwrap_or_default(),
                precision: self.precision.unwrap_or_default(),
                scale: self.scale.unwrap_or_default(),
                array_base_column_type: self.array_base_column_type.unwrap_or_default(),
            }
        }
    }
}
impl ColumnMetadata {
    /// Creates a new builder-style object to manufacture [`ColumnMetadata`](crate::model::ColumnMetadata)
    pub fn builder() -> crate::model::column_metadata::Builder {
        crate::model::column_metadata::Builder::default()
    }
}

/// <p>Options that control how the result set is returned.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResultSetOptions {
    /// <p>A value that indicates how a field of <code>DECIMAL</code> type is represented
    /// in the response. The value of <code>STRING</code>, the default, specifies that
    /// it is converted to a String value. The value of <code>DOUBLE_OR_LONG</code>
    /// specifies that it is converted to a Long value if its scale is 0, or to a Double
    /// value otherwise.</p>
    /// <important>
    /// <p>Conversion to Double or Long can result in roundoff errors due to precision loss.
    /// We recommend converting to String, especially when working with currency values.</p>
    /// </important>
    pub decimal_return_type: std::option::Option<crate::model::DecimalReturnType>,
}
impl ResultSetOptions {
    /// <p>A value that indicates how a field of <code>DECIMAL</code> type is represented
    /// in the response. The value of <code>STRING</code>, the default, specifies that
    /// it is converted to a String value. The value of <code>DOUBLE_OR_LONG</code>
    /// specifies that it is converted to a Long value if its scale is 0, or to a Double
    /// value otherwise.</p>
    /// <important>
    /// <p>Conversion to Double or Long can result in roundoff errors due to precision loss.
    /// We recommend converting to String, especially when working with currency values.</p>
    /// </important>
    pub fn decimal_return_type(&self) -> std::option::Option<&crate::model::DecimalReturnType> {
        self.decimal_return_type.as_ref()
    }
}
impl std::fmt::Debug for ResultSetOptions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResultSetOptions");
        formatter.field("decimal_return_type", &self.decimal_return_type);
        formatter.finish()
    }
}
/// See [`ResultSetOptions`](crate::model::ResultSetOptions)
pub mod result_set_options {
    /// A builder for [`ResultSetOptions`](crate::model::ResultSetOptions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) decimal_return_type: std::option::Option<crate::model::DecimalReturnType>,
    }
    impl Builder {
        /// <p>A value that indicates how a field of <code>DECIMAL</code> type is represented
        /// in the response. The value of <code>STRING</code>, the default, specifies that
        /// it is converted to a String value. The value of <code>DOUBLE_OR_LONG</code>
        /// specifies that it is converted to a Long value if its scale is 0, or to a Double
        /// value otherwise.</p>
        /// <important>
        /// <p>Conversion to Double or Long can result in roundoff errors due to precision loss.
        /// We recommend converting to String, especially when working with currency values.</p>
        /// </important>
        pub fn decimal_return_type(mut self, input: crate::model::DecimalReturnType) -> Self {
            self.decimal_return_type = Some(input);
            self
        }
        /// <p>A value that indicates how a field of <code>DECIMAL</code> type is represented
        /// in the response. The value of <code>STRING</code>, the default, specifies that
        /// it is converted to a String value. The value of <code>DOUBLE_OR_LONG</code>
        /// specifies that it is converted to a Long value if its scale is 0, or to a Double
        /// value otherwise.</p>
        /// <important>
        /// <p>Conversion to Double or Long can result in roundoff errors due to precision loss.
        /// We recommend converting to String, especially when working with currency values.</p>
        /// </important>
        pub fn set_decimal_return_type(
            mut self,
            input: std::option::Option<crate::model::DecimalReturnType>,
        ) -> Self {
            self.decimal_return_type = input;
            self
        }
        /// Consumes the builder and constructs a [`ResultSetOptions`](crate::model::ResultSetOptions)
        pub fn build(self) -> crate::model::ResultSetOptions {
            crate::model::ResultSetOptions {
                decimal_return_type: self.decimal_return_type,
            }
        }
    }
}
impl ResultSetOptions {
    /// Creates a new builder-style object to manufacture [`ResultSetOptions`](crate::model::ResultSetOptions)
    pub fn builder() -> crate::model::result_set_options::Builder {
        crate::model::result_set_options::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DecimalReturnType {
    #[allow(missing_docs)] // documentation missing in model
    DoubleOrLong,
    #[allow(missing_docs)] // documentation missing in model
    String,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DecimalReturnType {
    fn from(s: &str) -> Self {
        match s {
            "DOUBLE_OR_LONG" => DecimalReturnType::DoubleOrLong,
            "STRING" => DecimalReturnType::String,
            other => DecimalReturnType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DecimalReturnType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DecimalReturnType::from(s))
    }
}
impl DecimalReturnType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DecimalReturnType::DoubleOrLong => "DOUBLE_OR_LONG",
            DecimalReturnType::String => "STRING",
            DecimalReturnType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DOUBLE_OR_LONG", "STRING"]
    }
}
impl AsRef<str> for DecimalReturnType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A parameter used in a SQL statement.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SqlParameter {
    /// <p>The name of the parameter.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The value of the parameter.</p>
    pub value: std::option::Option<crate::model::Field>,
    /// <p>A hint that specifies the correct object type for data type mapping. Possible values
    /// are as follows:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>DATE</code> - The corresponding <code>String</code> parameter value is sent as an object
    /// of <code>DATE</code> type to the database. The accepted format is <code>YYYY-MM-DD</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DECIMAL</code> - The corresponding <code>String</code> parameter value is sent as an object
    /// of <code>DECIMAL</code> type to the database.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>JSON</code> - The corresponding <code>String</code> parameter value is sent as an
    /// object of <code>JSON</code> type to the database.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>TIME</code> - The corresponding <code>String</code> parameter value is sent as an object
    /// of <code>TIME</code> type to the database. The accepted format is <code>HH:MM:SS[.FFF]</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>TIMESTAMP</code> - The corresponding <code>String</code> parameter value is sent as an object
    /// of <code>TIMESTAMP</code> type to the database. The accepted format is <code>YYYY-MM-DD HH:MM:SS[.FFF]</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>UUID</code> - The corresponding <code>String</code> parameter value is sent as an object of
    /// <code>UUID</code> type to the database.
    /// </p>
    /// </li>
    /// </ul>
    pub type_hint: std::option::Option<crate::model::TypeHint>,
}
impl SqlParameter {
    /// <p>The name of the parameter.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The value of the parameter.</p>
    pub fn value(&self) -> std::option::Option<&crate::model::Field> {
        self.value.as_ref()
    }
    /// <p>A hint that specifies the correct object type for data type mapping. Possible values
    /// are as follows:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>DATE</code> - The corresponding <code>String</code> parameter value is sent as an object
    /// of <code>DATE</code> type to the database. The accepted format is <code>YYYY-MM-DD</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DECIMAL</code> - The corresponding <code>String</code> parameter value is sent as an object
    /// of <code>DECIMAL</code> type to the database.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>JSON</code> - The corresponding <code>String</code> parameter value is sent as an
    /// object of <code>JSON</code> type to the database.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>TIME</code> - The corresponding <code>String</code> parameter value is sent as an object
    /// of <code>TIME</code> type to the database. The accepted format is <code>HH:MM:SS[.FFF]</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>TIMESTAMP</code> - The corresponding <code>String</code> parameter value is sent as an object
    /// of <code>TIMESTAMP</code> type to the database. The accepted format is <code>YYYY-MM-DD HH:MM:SS[.FFF]</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>UUID</code> - The corresponding <code>String</code> parameter value is sent as an object of
    /// <code>UUID</code> type to the database.
    /// </p>
    /// </li>
    /// </ul>
    pub fn type_hint(&self) -> std::option::Option<&crate::model::TypeHint> {
        self.type_hint.as_ref()
    }
}
impl std::fmt::Debug for SqlParameter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SqlParameter");
        formatter.field("name", &self.name);
        formatter.field("value", &self.value);
        formatter.field("type_hint", &self.type_hint);
        formatter.finish()
    }
}
/// See [`SqlParameter`](crate::model::SqlParameter)
pub mod sql_parameter {
    /// A builder for [`SqlParameter`](crate::model::SqlParameter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<crate::model::Field>,
        pub(crate) type_hint: std::option::Option<crate::model::TypeHint>,
    }
    impl Builder {
        /// <p>The name of the parameter.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the parameter.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The value of the parameter.</p>
        pub fn value(mut self, input: crate::model::Field) -> Self {
            self.value = Some(input);
            self
        }
        /// <p>The value of the parameter.</p>
        pub fn set_value(mut self, input: std::option::Option<crate::model::Field>) -> Self {
            self.value = input;
            self
        }
        /// <p>A hint that specifies the correct object type for data type mapping. Possible values
        /// are as follows:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>DATE</code> - The corresponding <code>String</code> parameter value is sent as an object
        /// of <code>DATE</code> type to the database. The accepted format is <code>YYYY-MM-DD</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DECIMAL</code> - The corresponding <code>String</code> parameter value is sent as an object
        /// of <code>DECIMAL</code> type to the database.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>JSON</code> - The corresponding <code>String</code> parameter value is sent as an
        /// object of <code>JSON</code> type to the database.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TIME</code> - The corresponding <code>String</code> parameter value is sent as an object
        /// of <code>TIME</code> type to the database. The accepted format is <code>HH:MM:SS[.FFF]</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TIMESTAMP</code> - The corresponding <code>String</code> parameter value is sent as an object
        /// of <code>TIMESTAMP</code> type to the database. The accepted format is <code>YYYY-MM-DD HH:MM:SS[.FFF]</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>UUID</code> - The corresponding <code>String</code> parameter value is sent as an object of
        /// <code>UUID</code> type to the database.
        /// </p>
        /// </li>
        /// </ul>
        pub fn type_hint(mut self, input: crate::model::TypeHint) -> Self {
            self.type_hint = Some(input);
            self
        }
        /// <p>A hint that specifies the correct object type for data type mapping. Possible values
        /// are as follows:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>DATE</code> - The corresponding <code>String</code> parameter value is sent as an object
        /// of <code>DATE</code> type to the database. The accepted format is <code>YYYY-MM-DD</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DECIMAL</code> - The corresponding <code>String</code> parameter value is sent as an object
        /// of <code>DECIMAL</code> type to the database.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>JSON</code> - The corresponding <code>String</code> parameter value is sent as an
        /// object of <code>JSON</code> type to the database.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TIME</code> - The corresponding <code>String</code> parameter value is sent as an object
        /// of <code>TIME</code> type to the database. The accepted format is <code>HH:MM:SS[.FFF]</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TIMESTAMP</code> - The corresponding <code>String</code> parameter value is sent as an object
        /// of <code>TIMESTAMP</code> type to the database. The accepted format is <code>YYYY-MM-DD HH:MM:SS[.FFF]</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>UUID</code> - The corresponding <code>String</code> parameter value is sent as an object of
        /// <code>UUID</code> type to the database.
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_type_hint(mut self, input: std::option::Option<crate::model::TypeHint>) -> Self {
            self.type_hint = input;
            self
        }
        /// Consumes the builder and constructs a [`SqlParameter`](crate::model::SqlParameter)
        pub fn build(self) -> crate::model::SqlParameter {
            crate::model::SqlParameter {
                name: self.name,
                value: self.value,
                type_hint: self.type_hint,
            }
        }
    }
}
impl SqlParameter {
    /// Creates a new builder-style object to manufacture [`SqlParameter`](crate::model::SqlParameter)
    pub fn builder() -> crate::model::sql_parameter::Builder {
        crate::model::sql_parameter::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TypeHint {
    #[allow(missing_docs)] // documentation missing in model
    Date,
    #[allow(missing_docs)] // documentation missing in model
    Decimal,
    #[allow(missing_docs)] // documentation missing in model
    Json,
    #[allow(missing_docs)] // documentation missing in model
    Time,
    #[allow(missing_docs)] // documentation missing in model
    Timestamp,
    #[allow(missing_docs)] // documentation missing in model
    Uuid,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TypeHint {
    fn from(s: &str) -> Self {
        match s {
            "DATE" => TypeHint::Date,
            "DECIMAL" => TypeHint::Decimal,
            "JSON" => TypeHint::Json,
            "TIME" => TypeHint::Time,
            "TIMESTAMP" => TypeHint::Timestamp,
            "UUID" => TypeHint::Uuid,
            other => TypeHint::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TypeHint {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TypeHint::from(s))
    }
}
impl TypeHint {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TypeHint::Date => "DATE",
            TypeHint::Decimal => "DECIMAL",
            TypeHint::Json => "JSON",
            TypeHint::Time => "TIME",
            TypeHint::Timestamp => "TIMESTAMP",
            TypeHint::Uuid => "UUID",
            TypeHint::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DATE", "DECIMAL", "JSON", "TIME", "TIMESTAMP", "UUID"]
    }
}
impl AsRef<str> for TypeHint {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The result of a SQL statement.</p>
///
/// <important>
/// <p>This data type is deprecated.</p>
/// </important>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SqlStatementResult {
    /// <p>The result set of the SQL statement.</p>
    pub result_frame: std::option::Option<crate::model::ResultFrame>,
    /// <p>The number of records updated by a SQL statement.</p>
    pub number_of_records_updated: i64,
}
impl SqlStatementResult {
    /// <p>The result set of the SQL statement.</p>
    pub fn result_frame(&self) -> std::option::Option<&crate::model::ResultFrame> {
        self.result_frame.as_ref()
    }
    /// <p>The number of records updated by a SQL statement.</p>
    pub fn number_of_records_updated(&self) -> i64 {
        self.number_of_records_updated
    }
}
impl std::fmt::Debug for SqlStatementResult {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SqlStatementResult");
        formatter.field("result_frame", &self.result_frame);
        formatter.field("number_of_records_updated", &self.number_of_records_updated);
        formatter.finish()
    }
}
/// See [`SqlStatementResult`](crate::model::SqlStatementResult)
pub mod sql_statement_result {
    /// A builder for [`SqlStatementResult`](crate::model::SqlStatementResult)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) result_frame: std::option::Option<crate::model::ResultFrame>,
        pub(crate) number_of_records_updated: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The result set of the SQL statement.</p>
        pub fn result_frame(mut self, input: crate::model::ResultFrame) -> Self {
            self.result_frame = Some(input);
            self
        }
        /// <p>The result set of the SQL statement.</p>
        pub fn set_result_frame(
            mut self,
            input: std::option::Option<crate::model::ResultFrame>,
        ) -> Self {
            self.result_frame = input;
            self
        }
        /// <p>The number of records updated by a SQL statement.</p>
        pub fn number_of_records_updated(mut self, input: i64) -> Self {
            self.number_of_records_updated = Some(input);
            self
        }
        /// <p>The number of records updated by a SQL statement.</p>
        pub fn set_number_of_records_updated(mut self, input: std::option::Option<i64>) -> Self {
            self.number_of_records_updated = input;
            self
        }
        /// Consumes the builder and constructs a [`SqlStatementResult`](crate::model::SqlStatementResult)
        pub fn build(self) -> crate::model::SqlStatementResult {
            crate::model::SqlStatementResult {
                result_frame: self.result_frame,
                number_of_records_updated: self.number_of_records_updated.unwrap_or_default(),
            }
        }
    }
}
impl SqlStatementResult {
    /// Creates a new builder-style object to manufacture [`SqlStatementResult`](crate::model::SqlStatementResult)
    pub fn builder() -> crate::model::sql_statement_result::Builder {
        crate::model::sql_statement_result::Builder::default()
    }
}

/// <p>The result set returned by a SQL statement.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResultFrame {
    /// <p>The result-set metadata in the result set.</p>
    pub result_set_metadata: std::option::Option<crate::model::ResultSetMetadata>,
    /// <p>The records in the result set.</p>
    pub records: std::option::Option<std::vec::Vec<crate::model::Record>>,
}
impl ResultFrame {
    /// <p>The result-set metadata in the result set.</p>
    pub fn result_set_metadata(&self) -> std::option::Option<&crate::model::ResultSetMetadata> {
        self.result_set_metadata.as_ref()
    }
    /// <p>The records in the result set.</p>
    pub fn records(&self) -> std::option::Option<&[crate::model::Record]> {
        self.records.as_deref()
    }
}
impl std::fmt::Debug for ResultFrame {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResultFrame");
        formatter.field("result_set_metadata", &self.result_set_metadata);
        formatter.field("records", &self.records);
        formatter.finish()
    }
}
/// See [`ResultFrame`](crate::model::ResultFrame)
pub mod result_frame {
    /// A builder for [`ResultFrame`](crate::model::ResultFrame)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) result_set_metadata: std::option::Option<crate::model::ResultSetMetadata>,
        pub(crate) records: std::option::Option<std::vec::Vec<crate::model::Record>>,
    }
    impl Builder {
        /// <p>The result-set metadata in the result set.</p>
        pub fn result_set_metadata(mut self, input: crate::model::ResultSetMetadata) -> Self {
            self.result_set_metadata = Some(input);
            self
        }
        /// <p>The result-set metadata in the result set.</p>
        pub fn set_result_set_metadata(
            mut self,
            input: std::option::Option<crate::model::ResultSetMetadata>,
        ) -> Self {
            self.result_set_metadata = input;
            self
        }
        /// Appends an item to `records`.
        ///
        /// To override the contents of this collection use [`set_records`](Self::set_records).
        ///
        /// <p>The records in the result set.</p>
        pub fn records(mut self, input: impl Into<crate::model::Record>) -> Self {
            let mut v = self.records.unwrap_or_default();
            v.push(input.into());
            self.records = Some(v);
            self
        }
        /// <p>The records in the result set.</p>
        pub fn set_records(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Record>>,
        ) -> Self {
            self.records = input;
            self
        }
        /// Consumes the builder and constructs a [`ResultFrame`](crate::model::ResultFrame)
        pub fn build(self) -> crate::model::ResultFrame {
            crate::model::ResultFrame {
                result_set_metadata: self.result_set_metadata,
                records: self.records,
            }
        }
    }
}
impl ResultFrame {
    /// Creates a new builder-style object to manufacture [`ResultFrame`](crate::model::ResultFrame)
    pub fn builder() -> crate::model::result_frame::Builder {
        crate::model::result_frame::Builder::default()
    }
}

/// <p>A record returned by a call.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Record {
    /// <p>The values returned in the record.</p>
    pub values: std::option::Option<std::vec::Vec<crate::model::Value>>,
}
impl Record {
    /// <p>The values returned in the record.</p>
    pub fn values(&self) -> std::option::Option<&[crate::model::Value]> {
        self.values.as_deref()
    }
}
impl std::fmt::Debug for Record {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Record");
        formatter.field("values", &self.values);
        formatter.finish()
    }
}
/// See [`Record`](crate::model::Record)
pub mod record {
    /// A builder for [`Record`](crate::model::Record)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) values: std::option::Option<std::vec::Vec<crate::model::Value>>,
    }
    impl Builder {
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>The values returned in the record.</p>
        pub fn values(mut self, input: impl Into<crate::model::Value>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>The values returned in the record.</p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Value>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// Consumes the builder and constructs a [`Record`](crate::model::Record)
        pub fn build(self) -> crate::model::Record {
            crate::model::Record {
                values: self.values,
            }
        }
    }
}
impl Record {
    /// Creates a new builder-style object to manufacture [`Record`](crate::model::Record)
    pub fn builder() -> crate::model::record::Builder {
        crate::model::record::Builder::default()
    }
}

/// <p>Contains the value of a column.</p>
///
/// <important>
/// <p>This data type is deprecated.</p>
/// </important>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
pub enum Value {
    /// <p>An array of column values.</p>
    ArrayValues(std::vec::Vec<crate::model::Value>),
    /// <p>A value for a column of big integer data type.</p>
    BigIntValue(i64),
    /// <p>A value for a column of BIT data type.</p>
    BitValue(bool),
    /// <p>A value for a column of BLOB data type.</p>
    BlobValue(aws_smithy_types::Blob),
    /// <p>A value for a column of double data type.</p>
    DoubleValue(f64),
    /// <p>A value for a column of integer data type.</p>
    IntValue(i32),
    /// <p>A NULL value.</p>
    IsNull(bool),
    /// <p>A value for a column of real data type.</p>
    RealValue(f32),
    /// <p>A value for a column of string data type.</p>
    StringValue(std::string::String),
    /// <p>A value for a column of STRUCT data type.</p>
    StructValue(crate::model::StructValue),
    /// The `Unknown` variant represents cases where new union variant was received. Consider upgrading the SDK to the latest available version.
    /// An unknown enum variant
    ///
    /// _Note: If you encounter this error, consider upgrading your SDK to the latest version._
    /// The `Unknown` variant represents cases where the server sent a value that wasn't recognized
    /// by the client. This can happen when the server adds new functionality, but the client has not been updated.
    /// To investigate this, consider turning on debug logging to print the raw HTTP response.
    #[non_exhaustive]
    Unknown,
}
impl Value {
    /// Tries to convert the enum instance into [`ArrayValues`](crate::model::Value::ArrayValues), extracting the inner [`Vec`](std::vec::Vec).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_array_values(
        &self,
    ) -> std::result::Result<&std::vec::Vec<crate::model::Value>, &Self> {
        if let Value::ArrayValues(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if this is a [`ArrayValues`](crate::model::Value::ArrayValues).
    pub fn is_array_values(&self) -> bool {
        self.as_array_values().is_ok()
    }
    /// Tries to convert the enum instance into [`BigIntValue`](crate::model::Value::BigIntValue), extracting the inner [`i64`](i64).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_big_int_value(&self) -> std::result::Result<&i64, &Self> {
        if let Value::BigIntValue(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if this is a [`BigIntValue`](crate::model::Value::BigIntValue).
    pub fn is_big_int_value(&self) -> bool {
        self.as_big_int_value().is_ok()
    }
    /// Tries to convert the enum instance into [`BitValue`](crate::model::Value::BitValue), extracting the inner [`bool`](bool).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_bit_value(&self) -> std::result::Result<&bool, &Self> {
        if let Value::BitValue(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if this is a [`BitValue`](crate::model::Value::BitValue).
    pub fn is_bit_value(&self) -> bool {
        self.as_bit_value().is_ok()
    }
    /// Tries to convert the enum instance into [`BlobValue`](crate::model::Value::BlobValue), extracting the inner [`Blob`](aws_smithy_types::Blob).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_blob_value(&self) -> std::result::Result<&aws_smithy_types::Blob, &Self> {
        if let Value::BlobValue(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if this is a [`BlobValue`](crate::model::Value::BlobValue).
    pub fn is_blob_value(&self) -> bool {
        self.as_blob_value().is_ok()
    }
    /// Tries to convert the enum instance into [`DoubleValue`](crate::model::Value::DoubleValue), extracting the inner [`f64`](f64).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_double_value(&self) -> std::result::Result<&f64, &Self> {
        if let Value::DoubleValue(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if this is a [`DoubleValue`](crate::model::Value::DoubleValue).
    pub fn is_double_value(&self) -> bool {
        self.as_double_value().is_ok()
    }
    /// Tries to convert the enum instance into [`IntValue`](crate::model::Value::IntValue), extracting the inner [`i32`](i32).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_int_value(&self) -> std::result::Result<&i32, &Self> {
        if let Value::IntValue(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if this is a [`IntValue`](crate::model::Value::IntValue).
    pub fn is_int_value(&self) -> bool {
        self.as_int_value().is_ok()
    }
    /// Tries to convert the enum instance into [`IsNull`](crate::model::Value::IsNull), extracting the inner [`bool`](bool).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_is_null(&self) -> std::result::Result<&bool, &Self> {
        if let Value::IsNull(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if this is a [`IsNull`](crate::model::Value::IsNull).
    pub fn is_is_null(&self) -> bool {
        self.as_is_null().is_ok()
    }
    /// Tries to convert the enum instance into [`RealValue`](crate::model::Value::RealValue), extracting the inner [`f32`](f32).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_real_value(&self) -> std::result::Result<&f32, &Self> {
        if let Value::RealValue(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if this is a [`RealValue`](crate::model::Value::RealValue).
    pub fn is_real_value(&self) -> bool {
        self.as_real_value().is_ok()
    }
    /// Tries to convert the enum instance into [`StringValue`](crate::model::Value::StringValue), extracting the inner [`String`](std::string::String).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_string_value(&self) -> std::result::Result<&std::string::String, &Self> {
        if let Value::StringValue(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if this is a [`StringValue`](crate::model::Value::StringValue).
    pub fn is_string_value(&self) -> bool {
        self.as_string_value().is_ok()
    }
    /// Tries to convert the enum instance into [`StructValue`](crate::model::Value::StructValue), extracting the inner [`StructValue`](crate::model::StructValue).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_struct_value(&self) -> std::result::Result<&crate::model::StructValue, &Self> {
        if let Value::StructValue(val) = &self {
            Ok(&val)
        } else {
            Err(&self)
        }
    }
    /// Returns true if this is a [`StructValue`](crate::model::Value::StructValue).
    pub fn is_struct_value(&self) -> bool {
        self.as_struct_value().is_ok()
    }
    /// Returns true if the enum instance is the `Unknown` variant.
    pub fn is_unknown(&self) -> bool {
        matches!(self, Self::Unknown)
    }
}

/// <p>A structure value returned by a call.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StructValue {
    /// <p>The attributes returned in the record.</p>
    pub attributes: std::option::Option<std::vec::Vec<crate::model::Value>>,
}
impl StructValue {
    /// <p>The attributes returned in the record.</p>
    pub fn attributes(&self) -> std::option::Option<&[crate::model::Value]> {
        self.attributes.as_deref()
    }
}
impl std::fmt::Debug for StructValue {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StructValue");
        formatter.field("attributes", &self.attributes);
        formatter.finish()
    }
}
/// See [`StructValue`](crate::model::StructValue)
pub mod struct_value {
    /// A builder for [`StructValue`](crate::model::StructValue)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attributes: std::option::Option<std::vec::Vec<crate::model::Value>>,
    }
    impl Builder {
        /// Appends an item to `attributes`.
        ///
        /// To override the contents of this collection use [`set_attributes`](Self::set_attributes).
        ///
        /// <p>The attributes returned in the record.</p>
        pub fn attributes(mut self, input: impl Into<crate::model::Value>) -> Self {
            let mut v = self.attributes.unwrap_or_default();
            v.push(input.into());
            self.attributes = Some(v);
            self
        }
        /// <p>The attributes returned in the record.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Value>>,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// Consumes the builder and constructs a [`StructValue`](crate::model::StructValue)
        pub fn build(self) -> crate::model::StructValue {
            crate::model::StructValue {
                attributes: self.attributes,
            }
        }
    }
}
impl StructValue {
    /// Creates a new builder-style object to manufacture [`StructValue`](crate::model::StructValue)
    pub fn builder() -> crate::model::struct_value::Builder {
        crate::model::struct_value::Builder::default()
    }
}

/// <p>The metadata of the result set returned by a SQL statement.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResultSetMetadata {
    /// <p>The number of columns in the result set.</p>
    pub column_count: i64,
    /// <p>The metadata of the columns in the result set.</p>
    pub column_metadata: std::option::Option<std::vec::Vec<crate::model::ColumnMetadata>>,
}
impl ResultSetMetadata {
    /// <p>The number of columns in the result set.</p>
    pub fn column_count(&self) -> i64 {
        self.column_count
    }
    /// <p>The metadata of the columns in the result set.</p>
    pub fn column_metadata(&self) -> std::option::Option<&[crate::model::ColumnMetadata]> {
        self.column_metadata.as_deref()
    }
}
impl std::fmt::Debug for ResultSetMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResultSetMetadata");
        formatter.field("column_count", &self.column_count);
        formatter.field("column_metadata", &self.column_metadata);
        formatter.finish()
    }
}
/// See [`ResultSetMetadata`](crate::model::ResultSetMetadata)
pub mod result_set_metadata {
    /// A builder for [`ResultSetMetadata`](crate::model::ResultSetMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) column_count: std::option::Option<i64>,
        pub(crate) column_metadata:
            std::option::Option<std::vec::Vec<crate::model::ColumnMetadata>>,
    }
    impl Builder {
        /// <p>The number of columns in the result set.</p>
        pub fn column_count(mut self, input: i64) -> Self {
            self.column_count = Some(input);
            self
        }
        /// <p>The number of columns in the result set.</p>
        pub fn set_column_count(mut self, input: std::option::Option<i64>) -> Self {
            self.column_count = input;
            self
        }
        /// Appends an item to `column_metadata`.
        ///
        /// To override the contents of this collection use [`set_column_metadata`](Self::set_column_metadata).
        ///
        /// <p>The metadata of the columns in the result set.</p>
        pub fn column_metadata(mut self, input: impl Into<crate::model::ColumnMetadata>) -> Self {
            let mut v = self.column_metadata.unwrap_or_default();
            v.push(input.into());
            self.column_metadata = Some(v);
            self
        }
        /// <p>The metadata of the columns in the result set.</p>
        pub fn set_column_metadata(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ColumnMetadata>>,
        ) -> Self {
            self.column_metadata = input;
            self
        }
        /// Consumes the builder and constructs a [`ResultSetMetadata`](crate::model::ResultSetMetadata)
        pub fn build(self) -> crate::model::ResultSetMetadata {
            crate::model::ResultSetMetadata {
                column_count: self.column_count.unwrap_or_default(),
                column_metadata: self.column_metadata,
            }
        }
    }
}
impl ResultSetMetadata {
    /// Creates a new builder-style object to manufacture [`ResultSetMetadata`](crate::model::ResultSetMetadata)
    pub fn builder() -> crate::model::result_set_metadata::Builder {
        crate::model::result_set_metadata::Builder::default()
    }
}

/// <p>The response elements represent the results of an update.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateResult {
    /// <p>Values for fields generated during the request.</p>
    pub generated_fields: std::option::Option<std::vec::Vec<crate::model::Field>>,
}
impl UpdateResult {
    /// <p>Values for fields generated during the request.</p>
    pub fn generated_fields(&self) -> std::option::Option<&[crate::model::Field]> {
        self.generated_fields.as_deref()
    }
}
impl std::fmt::Debug for UpdateResult {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateResult");
        formatter.field("generated_fields", &self.generated_fields);
        formatter.finish()
    }
}
/// See [`UpdateResult`](crate::model::UpdateResult)
pub mod update_result {
    /// A builder for [`UpdateResult`](crate::model::UpdateResult)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) generated_fields: std::option::Option<std::vec::Vec<crate::model::Field>>,
    }
    impl Builder {
        /// Appends an item to `generated_fields`.
        ///
        /// To override the contents of this collection use [`set_generated_fields`](Self::set_generated_fields).
        ///
        /// <p>Values for fields generated during the request.</p>
        pub fn generated_fields(mut self, input: impl Into<crate::model::Field>) -> Self {
            let mut v = self.generated_fields.unwrap_or_default();
            v.push(input.into());
            self.generated_fields = Some(v);
            self
        }
        /// <p>Values for fields generated during the request.</p>
        pub fn set_generated_fields(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Field>>,
        ) -> Self {
            self.generated_fields = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateResult`](crate::model::UpdateResult)
        pub fn build(self) -> crate::model::UpdateResult {
            crate::model::UpdateResult {
                generated_fields: self.generated_fields,
            }
        }
    }
}
impl UpdateResult {
    /// Creates a new builder-style object to manufacture [`UpdateResult`](crate::model::UpdateResult)
    pub fn builder() -> crate::model::update_result::Builder {
        crate::model::update_result::Builder::default()
    }
}
