// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>An automated backup of a DB instance. It consists of system backups, transaction logs, and the database instance properties that existed at the time you deleted the source instance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DbInstanceAutomatedBackup {
    /// <p>The Amazon Resource Name (ARN) for the automated backups.</p>
    pub db_instance_arn: std::option::Option<std::string::String>,
    /// <p>The identifier for the source DB instance, which can't be changed and which is unique to an Amazon Web Services Region.</p>
    pub dbi_resource_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services Region associated with the automated backup.</p>
    pub region: std::option::Option<std::string::String>,
    /// <p>The customer id of the instance that is/was associated with the automated backup. </p>
    pub db_instance_identifier: std::option::Option<std::string::String>,
    /// <p>Earliest and latest time an instance can be restored to.</p>
    pub restore_window: std::option::Option<crate::model::RestoreWindow>,
    /// <p>Specifies the allocated storage size in gibibytes (GiB).</p>
    pub allocated_storage: i32,
    /// <p>Provides a list of status information for an automated backup:</p>
    /// <ul>
    /// <li> <p> <code>active</code> - automated backups for current instances</p> </li>
    /// <li> <p> <code>retained</code> - automated backups for deleted instances</p> </li>
    /// <li> <p> <code>creating</code> - automated backups that are waiting for the first automated snapshot to be available.</p> </li>
    /// </ul>
    pub status: std::option::Option<std::string::String>,
    /// <p>The port number that the automated backup used for connections.</p>
    /// <p>Default: Inherits from the source DB instance</p>
    /// <p>Valid Values: <code>1150-65535</code> </p>
    pub port: i32,
    /// <p>The Availability Zone that the automated backup was created in. For information on Amazon Web Services Regions and Availability Zones, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.RegionsAndAvailabilityZones.html">Regions and Availability Zones</a>.</p>
    pub availability_zone: std::option::Option<std::string::String>,
    /// <p>Provides the VPC ID associated with the DB instance</p>
    pub vpc_id: std::option::Option<std::string::String>,
    /// <p>Provides the date and time that the DB instance was created. </p>
    pub instance_create_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The license model of an automated backup.</p>
    pub master_username: std::option::Option<std::string::String>,
    /// <p>The name of the database engine for this automated backup.</p>
    pub engine: std::option::Option<std::string::String>,
    /// <p>The version of the database engine for the automated backup.</p>
    pub engine_version: std::option::Option<std::string::String>,
    /// <p>License model information for the automated backup.</p>
    pub license_model: std::option::Option<std::string::String>,
    /// <p>The IOPS (I/O operations per second) value for the automated backup. </p>
    pub iops: std::option::Option<i32>,
    /// <p>The option group the automated backup is associated with. If omitted, the default option group for the engine specified is used.</p>
    pub option_group_name: std::option::Option<std::string::String>,
    /// <p>The ARN from the key store with which the automated backup is associated for TDE encryption.</p>
    pub tde_credential_arn: std::option::Option<std::string::String>,
    /// <p>Specifies whether the automated backup is encrypted.</p>
    pub encrypted: bool,
    /// <p>Specifies the storage type associated with the automated backup.</p>
    pub storage_type: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services KMS key ID for an automated backup.</p>
    /// <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.</p>
    pub kms_key_id: std::option::Option<std::string::String>,
    /// <p>The time zone of the automated backup. In most cases, the <code>Timezone</code> element is empty. <code>Timezone</code> content appears only for Microsoft SQL Server DB instances that were created with a time zone specified.</p>
    pub timezone: std::option::Option<std::string::String>,
    /// <p>True if mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts is enabled, and otherwise false.</p>
    pub iam_database_authentication_enabled: bool,
    /// <p>The retention period for the automated backups.</p>
    pub backup_retention_period: std::option::Option<i32>,
    /// <p>The Amazon Resource Name (ARN) for the replicated automated backups.</p>
    pub db_instance_automated_backups_arn: std::option::Option<std::string::String>,
    /// <p>The list of replications to different Amazon Web Services Regions associated with the automated backup.</p>
    pub db_instance_automated_backups_replications:
        std::option::Option<std::vec::Vec<crate::model::DbInstanceAutomatedBackupsReplication>>,
    /// <p>Specifies where automated backups are stored: Amazon Web Services Outposts or the Amazon Web Services Region.</p>
    pub backup_target: std::option::Option<std::string::String>,
}
impl DbInstanceAutomatedBackup {
    /// <p>The Amazon Resource Name (ARN) for the automated backups.</p>
    pub fn db_instance_arn(&self) -> std::option::Option<&str> {
        self.db_instance_arn.as_deref()
    }
    /// <p>The identifier for the source DB instance, which can't be changed and which is unique to an Amazon Web Services Region.</p>
    pub fn dbi_resource_id(&self) -> std::option::Option<&str> {
        self.dbi_resource_id.as_deref()
    }
    /// <p>The Amazon Web Services Region associated with the automated backup.</p>
    pub fn region(&self) -> std::option::Option<&str> {
        self.region.as_deref()
    }
    /// <p>The customer id of the instance that is/was associated with the automated backup. </p>
    pub fn db_instance_identifier(&self) -> std::option::Option<&str> {
        self.db_instance_identifier.as_deref()
    }
    /// <p>Earliest and latest time an instance can be restored to.</p>
    pub fn restore_window(&self) -> std::option::Option<&crate::model::RestoreWindow> {
        self.restore_window.as_ref()
    }
    /// <p>Specifies the allocated storage size in gibibytes (GiB).</p>
    pub fn allocated_storage(&self) -> i32 {
        self.allocated_storage
    }
    /// <p>Provides a list of status information for an automated backup:</p>
    /// <ul>
    /// <li> <p> <code>active</code> - automated backups for current instances</p> </li>
    /// <li> <p> <code>retained</code> - automated backups for deleted instances</p> </li>
    /// <li> <p> <code>creating</code> - automated backups that are waiting for the first automated snapshot to be available.</p> </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>The port number that the automated backup used for connections.</p>
    /// <p>Default: Inherits from the source DB instance</p>
    /// <p>Valid Values: <code>1150-65535</code> </p>
    pub fn port(&self) -> i32 {
        self.port
    }
    /// <p>The Availability Zone that the automated backup was created in. For information on Amazon Web Services Regions and Availability Zones, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.RegionsAndAvailabilityZones.html">Regions and Availability Zones</a>.</p>
    pub fn availability_zone(&self) -> std::option::Option<&str> {
        self.availability_zone.as_deref()
    }
    /// <p>Provides the VPC ID associated with the DB instance</p>
    pub fn vpc_id(&self) -> std::option::Option<&str> {
        self.vpc_id.as_deref()
    }
    /// <p>Provides the date and time that the DB instance was created. </p>
    pub fn instance_create_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.instance_create_time.as_ref()
    }
    /// <p>The license model of an automated backup.</p>
    pub fn master_username(&self) -> std::option::Option<&str> {
        self.master_username.as_deref()
    }
    /// <p>The name of the database engine for this automated backup.</p>
    pub fn engine(&self) -> std::option::Option<&str> {
        self.engine.as_deref()
    }
    /// <p>The version of the database engine for the automated backup.</p>
    pub fn engine_version(&self) -> std::option::Option<&str> {
        self.engine_version.as_deref()
    }
    /// <p>License model information for the automated backup.</p>
    pub fn license_model(&self) -> std::option::Option<&str> {
        self.license_model.as_deref()
    }
    /// <p>The IOPS (I/O operations per second) value for the automated backup. </p>
    pub fn iops(&self) -> std::option::Option<i32> {
        self.iops
    }
    /// <p>The option group the automated backup is associated with. If omitted, the default option group for the engine specified is used.</p>
    pub fn option_group_name(&self) -> std::option::Option<&str> {
        self.option_group_name.as_deref()
    }
    /// <p>The ARN from the key store with which the automated backup is associated for TDE encryption.</p>
    pub fn tde_credential_arn(&self) -> std::option::Option<&str> {
        self.tde_credential_arn.as_deref()
    }
    /// <p>Specifies whether the automated backup is encrypted.</p>
    pub fn encrypted(&self) -> bool {
        self.encrypted
    }
    /// <p>Specifies the storage type associated with the automated backup.</p>
    pub fn storage_type(&self) -> std::option::Option<&str> {
        self.storage_type.as_deref()
    }
    /// <p>The Amazon Web Services KMS key ID for an automated backup.</p>
    /// <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.</p>
    pub fn kms_key_id(&self) -> std::option::Option<&str> {
        self.kms_key_id.as_deref()
    }
    /// <p>The time zone of the automated backup. In most cases, the <code>Timezone</code> element is empty. <code>Timezone</code> content appears only for Microsoft SQL Server DB instances that were created with a time zone specified.</p>
    pub fn timezone(&self) -> std::option::Option<&str> {
        self.timezone.as_deref()
    }
    /// <p>True if mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts is enabled, and otherwise false.</p>
    pub fn iam_database_authentication_enabled(&self) -> bool {
        self.iam_database_authentication_enabled
    }
    /// <p>The retention period for the automated backups.</p>
    pub fn backup_retention_period(&self) -> std::option::Option<i32> {
        self.backup_retention_period
    }
    /// <p>The Amazon Resource Name (ARN) for the replicated automated backups.</p>
    pub fn db_instance_automated_backups_arn(&self) -> std::option::Option<&str> {
        self.db_instance_automated_backups_arn.as_deref()
    }
    /// <p>The list of replications to different Amazon Web Services Regions associated with the automated backup.</p>
    pub fn db_instance_automated_backups_replications(
        &self,
    ) -> std::option::Option<&[crate::model::DbInstanceAutomatedBackupsReplication]> {
        self.db_instance_automated_backups_replications.as_deref()
    }
    /// <p>Specifies where automated backups are stored: Amazon Web Services Outposts or the Amazon Web Services Region.</p>
    pub fn backup_target(&self) -> std::option::Option<&str> {
        self.backup_target.as_deref()
    }
}
impl std::fmt::Debug for DbInstanceAutomatedBackup {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DbInstanceAutomatedBackup");
        formatter.field("db_instance_arn", &self.db_instance_arn);
        formatter.field("dbi_resource_id", &self.dbi_resource_id);
        formatter.field("region", &self.region);
        formatter.field("db_instance_identifier", &self.db_instance_identifier);
        formatter.field("restore_window", &self.restore_window);
        formatter.field("allocated_storage", &self.allocated_storage);
        formatter.field("status", &self.status);
        formatter.field("port", &self.port);
        formatter.field("availability_zone", &self.availability_zone);
        formatter.field("vpc_id", &self.vpc_id);
        formatter.field("instance_create_time", &self.instance_create_time);
        formatter.field("master_username", &self.master_username);
        formatter.field("engine", &self.engine);
        formatter.field("engine_version", &self.engine_version);
        formatter.field("license_model", &self.license_model);
        formatter.field("iops", &self.iops);
        formatter.field("option_group_name", &self.option_group_name);
        formatter.field("tde_credential_arn", &self.tde_credential_arn);
        formatter.field("encrypted", &self.encrypted);
        formatter.field("storage_type", &self.storage_type);
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.field("timezone", &self.timezone);
        formatter.field(
            "iam_database_authentication_enabled",
            &self.iam_database_authentication_enabled,
        );
        formatter.field("backup_retention_period", &self.backup_retention_period);
        formatter.field(
            "db_instance_automated_backups_arn",
            &self.db_instance_automated_backups_arn,
        );
        formatter.field(
            "db_instance_automated_backups_replications",
            &self.db_instance_automated_backups_replications,
        );
        formatter.field("backup_target", &self.backup_target);
        formatter.finish()
    }
}
/// See [`DbInstanceAutomatedBackup`](crate::model::DbInstanceAutomatedBackup)
pub mod db_instance_automated_backup {
    /// A builder for [`DbInstanceAutomatedBackup`](crate::model::DbInstanceAutomatedBackup)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_instance_arn: std::option::Option<std::string::String>,
        pub(crate) dbi_resource_id: std::option::Option<std::string::String>,
        pub(crate) region: std::option::Option<std::string::String>,
        pub(crate) db_instance_identifier: std::option::Option<std::string::String>,
        pub(crate) restore_window: std::option::Option<crate::model::RestoreWindow>,
        pub(crate) allocated_storage: std::option::Option<i32>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) port: std::option::Option<i32>,
        pub(crate) availability_zone: std::option::Option<std::string::String>,
        pub(crate) vpc_id: std::option::Option<std::string::String>,
        pub(crate) instance_create_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) master_username: std::option::Option<std::string::String>,
        pub(crate) engine: std::option::Option<std::string::String>,
        pub(crate) engine_version: std::option::Option<std::string::String>,
        pub(crate) license_model: std::option::Option<std::string::String>,
        pub(crate) iops: std::option::Option<i32>,
        pub(crate) option_group_name: std::option::Option<std::string::String>,
        pub(crate) tde_credential_arn: std::option::Option<std::string::String>,
        pub(crate) encrypted: std::option::Option<bool>,
        pub(crate) storage_type: std::option::Option<std::string::String>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
        pub(crate) timezone: std::option::Option<std::string::String>,
        pub(crate) iam_database_authentication_enabled: std::option::Option<bool>,
        pub(crate) backup_retention_period: std::option::Option<i32>,
        pub(crate) db_instance_automated_backups_arn: std::option::Option<std::string::String>,
        pub(crate) db_instance_automated_backups_replications:
            std::option::Option<std::vec::Vec<crate::model::DbInstanceAutomatedBackupsReplication>>,
        pub(crate) backup_target: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) for the automated backups.</p>
        pub fn db_instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_instance_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the automated backups.</p>
        pub fn set_db_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_instance_arn = input;
            self
        }
        /// <p>The identifier for the source DB instance, which can't be changed and which is unique to an Amazon Web Services Region.</p>
        pub fn dbi_resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.dbi_resource_id = Some(input.into());
            self
        }
        /// <p>The identifier for the source DB instance, which can't be changed and which is unique to an Amazon Web Services Region.</p>
        pub fn set_dbi_resource_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dbi_resource_id = input;
            self
        }
        /// <p>The Amazon Web Services Region associated with the automated backup.</p>
        pub fn region(mut self, input: impl Into<std::string::String>) -> Self {
            self.region = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services Region associated with the automated backup.</p>
        pub fn set_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.region = input;
            self
        }
        /// <p>The customer id of the instance that is/was associated with the automated backup. </p>
        pub fn db_instance_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_instance_identifier = Some(input.into());
            self
        }
        /// <p>The customer id of the instance that is/was associated with the automated backup. </p>
        pub fn set_db_instance_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_instance_identifier = input;
            self
        }
        /// <p>Earliest and latest time an instance can be restored to.</p>
        pub fn restore_window(mut self, input: crate::model::RestoreWindow) -> Self {
            self.restore_window = Some(input);
            self
        }
        /// <p>Earliest and latest time an instance can be restored to.</p>
        pub fn set_restore_window(
            mut self,
            input: std::option::Option<crate::model::RestoreWindow>,
        ) -> Self {
            self.restore_window = input;
            self
        }
        /// <p>Specifies the allocated storage size in gibibytes (GiB).</p>
        pub fn allocated_storage(mut self, input: i32) -> Self {
            self.allocated_storage = Some(input);
            self
        }
        /// <p>Specifies the allocated storage size in gibibytes (GiB).</p>
        pub fn set_allocated_storage(mut self, input: std::option::Option<i32>) -> Self {
            self.allocated_storage = input;
            self
        }
        /// <p>Provides a list of status information for an automated backup:</p>
        /// <ul>
        /// <li> <p> <code>active</code> - automated backups for current instances</p> </li>
        /// <li> <p> <code>retained</code> - automated backups for deleted instances</p> </li>
        /// <li> <p> <code>creating</code> - automated backups that are waiting for the first automated snapshot to be available.</p> </li>
        /// </ul>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>Provides a list of status information for an automated backup:</p>
        /// <ul>
        /// <li> <p> <code>active</code> - automated backups for current instances</p> </li>
        /// <li> <p> <code>retained</code> - automated backups for deleted instances</p> </li>
        /// <li> <p> <code>creating</code> - automated backups that are waiting for the first automated snapshot to be available.</p> </li>
        /// </ul>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>The port number that the automated backup used for connections.</p>
        /// <p>Default: Inherits from the source DB instance</p>
        /// <p>Valid Values: <code>1150-65535</code> </p>
        pub fn port(mut self, input: i32) -> Self {
            self.port = Some(input);
            self
        }
        /// <p>The port number that the automated backup used for connections.</p>
        /// <p>Default: Inherits from the source DB instance</p>
        /// <p>Valid Values: <code>1150-65535</code> </p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.port = input;
            self
        }
        /// <p>The Availability Zone that the automated backup was created in. For information on Amazon Web Services Regions and Availability Zones, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.RegionsAndAvailabilityZones.html">Regions and Availability Zones</a>.</p>
        pub fn availability_zone(mut self, input: impl Into<std::string::String>) -> Self {
            self.availability_zone = Some(input.into());
            self
        }
        /// <p>The Availability Zone that the automated backup was created in. For information on Amazon Web Services Regions and Availability Zones, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.RegionsAndAvailabilityZones.html">Regions and Availability Zones</a>.</p>
        pub fn set_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.availability_zone = input;
            self
        }
        /// <p>Provides the VPC ID associated with the DB instance</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_id = Some(input.into());
            self
        }
        /// <p>Provides the VPC ID associated with the DB instance</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_id = input;
            self
        }
        /// <p>Provides the date and time that the DB instance was created. </p>
        pub fn instance_create_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.instance_create_time = Some(input);
            self
        }
        /// <p>Provides the date and time that the DB instance was created. </p>
        pub fn set_instance_create_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.instance_create_time = input;
            self
        }
        /// <p>The license model of an automated backup.</p>
        pub fn master_username(mut self, input: impl Into<std::string::String>) -> Self {
            self.master_username = Some(input.into());
            self
        }
        /// <p>The license model of an automated backup.</p>
        pub fn set_master_username(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.master_username = input;
            self
        }
        /// <p>The name of the database engine for this automated backup.</p>
        pub fn engine(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine = Some(input.into());
            self
        }
        /// <p>The name of the database engine for this automated backup.</p>
        pub fn set_engine(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.engine = input;
            self
        }
        /// <p>The version of the database engine for the automated backup.</p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_version = Some(input.into());
            self
        }
        /// <p>The version of the database engine for the automated backup.</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.engine_version = input;
            self
        }
        /// <p>License model information for the automated backup.</p>
        pub fn license_model(mut self, input: impl Into<std::string::String>) -> Self {
            self.license_model = Some(input.into());
            self
        }
        /// <p>License model information for the automated backup.</p>
        pub fn set_license_model(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.license_model = input;
            self
        }
        /// <p>The IOPS (I/O operations per second) value for the automated backup. </p>
        pub fn iops(mut self, input: i32) -> Self {
            self.iops = Some(input);
            self
        }
        /// <p>The IOPS (I/O operations per second) value for the automated backup. </p>
        pub fn set_iops(mut self, input: std::option::Option<i32>) -> Self {
            self.iops = input;
            self
        }
        /// <p>The option group the automated backup is associated with. If omitted, the default option group for the engine specified is used.</p>
        pub fn option_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.option_group_name = Some(input.into());
            self
        }
        /// <p>The option group the automated backup is associated with. If omitted, the default option group for the engine specified is used.</p>
        pub fn set_option_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.option_group_name = input;
            self
        }
        /// <p>The ARN from the key store with which the automated backup is associated for TDE encryption.</p>
        pub fn tde_credential_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.tde_credential_arn = Some(input.into());
            self
        }
        /// <p>The ARN from the key store with which the automated backup is associated for TDE encryption.</p>
        pub fn set_tde_credential_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.tde_credential_arn = input;
            self
        }
        /// <p>Specifies whether the automated backup is encrypted.</p>
        pub fn encrypted(mut self, input: bool) -> Self {
            self.encrypted = Some(input);
            self
        }
        /// <p>Specifies whether the automated backup is encrypted.</p>
        pub fn set_encrypted(mut self, input: std::option::Option<bool>) -> Self {
            self.encrypted = input;
            self
        }
        /// <p>Specifies the storage type associated with the automated backup.</p>
        pub fn storage_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.storage_type = Some(input.into());
            self
        }
        /// <p>Specifies the storage type associated with the automated backup.</p>
        pub fn set_storage_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.storage_type = input;
            self
        }
        /// <p>The Amazon Web Services KMS key ID for an automated backup.</p>
        /// <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services KMS key ID for an automated backup.</p>
        /// <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// <p>The time zone of the automated backup. In most cases, the <code>Timezone</code> element is empty. <code>Timezone</code> content appears only for Microsoft SQL Server DB instances that were created with a time zone specified.</p>
        pub fn timezone(mut self, input: impl Into<std::string::String>) -> Self {
            self.timezone = Some(input.into());
            self
        }
        /// <p>The time zone of the automated backup. In most cases, the <code>Timezone</code> element is empty. <code>Timezone</code> content appears only for Microsoft SQL Server DB instances that were created with a time zone specified.</p>
        pub fn set_timezone(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.timezone = input;
            self
        }
        /// <p>True if mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts is enabled, and otherwise false.</p>
        pub fn iam_database_authentication_enabled(mut self, input: bool) -> Self {
            self.iam_database_authentication_enabled = Some(input);
            self
        }
        /// <p>True if mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts is enabled, and otherwise false.</p>
        pub fn set_iam_database_authentication_enabled(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.iam_database_authentication_enabled = input;
            self
        }
        /// <p>The retention period for the automated backups.</p>
        pub fn backup_retention_period(mut self, input: i32) -> Self {
            self.backup_retention_period = Some(input);
            self
        }
        /// <p>The retention period for the automated backups.</p>
        pub fn set_backup_retention_period(mut self, input: std::option::Option<i32>) -> Self {
            self.backup_retention_period = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the replicated automated backups.</p>
        pub fn db_instance_automated_backups_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.db_instance_automated_backups_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the replicated automated backups.</p>
        pub fn set_db_instance_automated_backups_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_instance_automated_backups_arn = input;
            self
        }
        /// Appends an item to `db_instance_automated_backups_replications`.
        ///
        /// To override the contents of this collection use [`set_db_instance_automated_backups_replications`](Self::set_db_instance_automated_backups_replications).
        ///
        /// <p>The list of replications to different Amazon Web Services Regions associated with the automated backup.</p>
        pub fn db_instance_automated_backups_replications(
            mut self,
            input: crate::model::DbInstanceAutomatedBackupsReplication,
        ) -> Self {
            let mut v = self
                .db_instance_automated_backups_replications
                .unwrap_or_default();
            v.push(input);
            self.db_instance_automated_backups_replications = Some(v);
            self
        }
        /// <p>The list of replications to different Amazon Web Services Regions associated with the automated backup.</p>
        pub fn set_db_instance_automated_backups_replications(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::DbInstanceAutomatedBackupsReplication>,
            >,
        ) -> Self {
            self.db_instance_automated_backups_replications = input;
            self
        }
        /// <p>Specifies where automated backups are stored: Amazon Web Services Outposts or the Amazon Web Services Region.</p>
        pub fn backup_target(mut self, input: impl Into<std::string::String>) -> Self {
            self.backup_target = Some(input.into());
            self
        }
        /// <p>Specifies where automated backups are stored: Amazon Web Services Outposts or the Amazon Web Services Region.</p>
        pub fn set_backup_target(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backup_target = input;
            self
        }
        /// Consumes the builder and constructs a [`DbInstanceAutomatedBackup`](crate::model::DbInstanceAutomatedBackup)
        pub fn build(self) -> crate::model::DbInstanceAutomatedBackup {
            crate::model::DbInstanceAutomatedBackup {
                db_instance_arn: self.db_instance_arn,
                dbi_resource_id: self.dbi_resource_id,
                region: self.region,
                db_instance_identifier: self.db_instance_identifier,
                restore_window: self.restore_window,
                allocated_storage: self.allocated_storage.unwrap_or_default(),
                status: self.status,
                port: self.port.unwrap_or_default(),
                availability_zone: self.availability_zone,
                vpc_id: self.vpc_id,
                instance_create_time: self.instance_create_time,
                master_username: self.master_username,
                engine: self.engine,
                engine_version: self.engine_version,
                license_model: self.license_model,
                iops: self.iops,
                option_group_name: self.option_group_name,
                tde_credential_arn: self.tde_credential_arn,
                encrypted: self.encrypted.unwrap_or_default(),
                storage_type: self.storage_type,
                kms_key_id: self.kms_key_id,
                timezone: self.timezone,
                iam_database_authentication_enabled: self
                    .iam_database_authentication_enabled
                    .unwrap_or_default(),
                backup_retention_period: self.backup_retention_period,
                db_instance_automated_backups_arn: self.db_instance_automated_backups_arn,
                db_instance_automated_backups_replications: self
                    .db_instance_automated_backups_replications,
                backup_target: self.backup_target,
            }
        }
    }
}
impl DbInstanceAutomatedBackup {
    /// Creates a new builder-style object to manufacture [`DbInstanceAutomatedBackup`](crate::model::DbInstanceAutomatedBackup)
    pub fn builder() -> crate::model::db_instance_automated_backup::Builder {
        crate::model::db_instance_automated_backup::Builder::default()
    }
}

/// <p>Automated backups of a DB instance replicated to another Amazon Web Services Region. They consist of system backups, transaction logs, and database instance properties.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DbInstanceAutomatedBackupsReplication {
    /// <p>The Amazon Resource Name (ARN) of the replicated automated backups.</p>
    pub db_instance_automated_backups_arn: std::option::Option<std::string::String>,
}
impl DbInstanceAutomatedBackupsReplication {
    /// <p>The Amazon Resource Name (ARN) of the replicated automated backups.</p>
    pub fn db_instance_automated_backups_arn(&self) -> std::option::Option<&str> {
        self.db_instance_automated_backups_arn.as_deref()
    }
}
impl std::fmt::Debug for DbInstanceAutomatedBackupsReplication {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DbInstanceAutomatedBackupsReplication");
        formatter.field(
            "db_instance_automated_backups_arn",
            &self.db_instance_automated_backups_arn,
        );
        formatter.finish()
    }
}
/// See [`DbInstanceAutomatedBackupsReplication`](crate::model::DbInstanceAutomatedBackupsReplication)
pub mod db_instance_automated_backups_replication {
    /// A builder for [`DbInstanceAutomatedBackupsReplication`](crate::model::DbInstanceAutomatedBackupsReplication)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_instance_automated_backups_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the replicated automated backups.</p>
        pub fn db_instance_automated_backups_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.db_instance_automated_backups_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the replicated automated backups.</p>
        pub fn set_db_instance_automated_backups_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_instance_automated_backups_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DbInstanceAutomatedBackupsReplication`](crate::model::DbInstanceAutomatedBackupsReplication)
        pub fn build(self) -> crate::model::DbInstanceAutomatedBackupsReplication {
            crate::model::DbInstanceAutomatedBackupsReplication {
                db_instance_automated_backups_arn: self.db_instance_automated_backups_arn,
            }
        }
    }
}
impl DbInstanceAutomatedBackupsReplication {
    /// Creates a new builder-style object to manufacture [`DbInstanceAutomatedBackupsReplication`](crate::model::DbInstanceAutomatedBackupsReplication)
    pub fn builder() -> crate::model::db_instance_automated_backups_replication::Builder {
        crate::model::db_instance_automated_backups_replication::Builder::default()
    }
}

/// <p>Earliest and latest time an instance can be restored to:</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RestoreWindow {
    /// <p>The earliest time you can restore an instance to.</p>
    pub earliest_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The latest time you can restore an instance to.</p>
    pub latest_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl RestoreWindow {
    /// <p>The earliest time you can restore an instance to.</p>
    pub fn earliest_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.earliest_time.as_ref()
    }
    /// <p>The latest time you can restore an instance to.</p>
    pub fn latest_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.latest_time.as_ref()
    }
}
impl std::fmt::Debug for RestoreWindow {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RestoreWindow");
        formatter.field("earliest_time", &self.earliest_time);
        formatter.field("latest_time", &self.latest_time);
        formatter.finish()
    }
}
/// See [`RestoreWindow`](crate::model::RestoreWindow)
pub mod restore_window {
    /// A builder for [`RestoreWindow`](crate::model::RestoreWindow)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) earliest_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) latest_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The earliest time you can restore an instance to.</p>
        pub fn earliest_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.earliest_time = Some(input);
            self
        }
        /// <p>The earliest time you can restore an instance to.</p>
        pub fn set_earliest_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.earliest_time = input;
            self
        }
        /// <p>The latest time you can restore an instance to.</p>
        pub fn latest_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.latest_time = Some(input);
            self
        }
        /// <p>The latest time you can restore an instance to.</p>
        pub fn set_latest_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.latest_time = input;
            self
        }
        /// Consumes the builder and constructs a [`RestoreWindow`](crate::model::RestoreWindow)
        pub fn build(self) -> crate::model::RestoreWindow {
            crate::model::RestoreWindow {
                earliest_time: self.earliest_time,
                latest_time: self.latest_time,
            }
        }
    }
}
impl RestoreWindow {
    /// Creates a new builder-style object to manufacture [`RestoreWindow`](crate::model::RestoreWindow)
    pub fn builder() -> crate::model::restore_window::Builder {
        crate::model::restore_window::Builder::default()
    }
}

/// <p>Contains the details of an Amazon RDS DB instance. </p>
/// <p>This data type is used as a response element in the operations <code>CreateDBInstance</code>, <code>CreateDBInstanceReadReplica</code>, <code>DeleteDBInstance</code>, <code>DescribeDBInstances</code>, <code>ModifyDBInstance</code>, <code>PromoteReadReplica</code>, <code>RebootDBInstance</code>, <code>RestoreDBInstanceFromDBSnapshot</code>, <code>RestoreDBInstanceFromS3</code>, <code>RestoreDBInstanceToPointInTime</code>, <code>StartDBInstance</code>, and <code>StopDBInstance</code>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DbInstance {
    /// <p>Contains a user-supplied database identifier. This identifier is the unique key that identifies a DB instance.</p>
    pub db_instance_identifier: std::option::Option<std::string::String>,
    /// <p>Contains the name of the compute and memory capacity class of the DB instance.</p>
    pub db_instance_class: std::option::Option<std::string::String>,
    /// <p>The name of the database engine to be used for this DB instance.</p>
    pub engine: std::option::Option<std::string::String>,
    /// <p>Specifies the current state of this database.</p>
    /// <p>For information about DB instance statuses, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/accessing-monitoring.html#Overview.DBInstance.Status">Viewing DB instance status</a> in the <i>Amazon RDS User Guide.</i> </p>
    pub db_instance_status: std::option::Option<std::string::String>,
    /// <p>The time when a stopped DB instance is restarted automatically.</p>
    pub automatic_restart_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Contains the master username for the DB instance.</p>
    pub master_username: std::option::Option<std::string::String>,
    /// <p>The meaning of this parameter differs according to the database engine you use.</p>
    /// <p> <b>MySQL, MariaDB, SQL Server, PostgreSQL</b> </p>
    /// <p>Contains the name of the initial database of this instance that was provided at create time, if one was specified when the DB instance was created. This same name is returned for the life of the DB instance.</p>
    /// <p>Type: String</p>
    /// <p> <b>Oracle</b> </p>
    /// <p>Contains the Oracle System ID (SID) of the created DB instance. Not shown when the returned parameters do not apply to an Oracle DB instance.</p>
    pub db_name: std::option::Option<std::string::String>,
    /// <p>Specifies the connection endpoint.</p> <note>
    /// <p>The endpoint might not be shown for instances whose status is <code>creating</code>.</p>
    /// </note>
    pub endpoint: std::option::Option<crate::model::Endpoint>,
    /// <p>Specifies the allocated storage size specified in gibibytes (GiB).</p>
    pub allocated_storage: i32,
    /// <p>Provides the date and time the DB instance was created.</p>
    pub instance_create_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p> Specifies the daily time range during which automated backups are created if automated backups are enabled, as determined by the <code>BackupRetentionPeriod</code>. </p>
    pub preferred_backup_window: std::option::Option<std::string::String>,
    /// <p>Specifies the number of days for which automatic DB snapshots are retained.</p>
    pub backup_retention_period: i32,
    /// <p> A list of DB security group elements containing <code>DBSecurityGroup.Name</code> and <code>DBSecurityGroup.Status</code> subelements. </p>
    pub db_security_groups:
        std::option::Option<std::vec::Vec<crate::model::DbSecurityGroupMembership>>,
    /// <p>Provides a list of VPC security group elements that the DB instance belongs to.</p>
    pub vpc_security_groups:
        std::option::Option<std::vec::Vec<crate::model::VpcSecurityGroupMembership>>,
    /// <p>Provides the list of DB parameter groups applied to this DB instance.</p>
    pub db_parameter_groups:
        std::option::Option<std::vec::Vec<crate::model::DbParameterGroupStatus>>,
    /// <p>Specifies the name of the Availability Zone the DB instance is located in.</p>
    pub availability_zone: std::option::Option<std::string::String>,
    /// <p>Specifies information on the subnet group associated with the DB instance, including the name, description, and subnets in the subnet group.</p>
    pub db_subnet_group: std::option::Option<crate::model::DbSubnetGroup>,
    /// <p>Specifies the weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).</p>
    pub preferred_maintenance_window: std::option::Option<std::string::String>,
    /// <p>A value that specifies that changes to the DB instance are pending. This element is only included when changes are pending. Specific changes are identified by subelements.</p>
    pub pending_modified_values: std::option::Option<crate::model::PendingModifiedValues>,
    /// <p>Specifies the latest time to which a database can be restored with point-in-time restore.</p>
    pub latest_restorable_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Specifies if the DB instance is a Multi-AZ deployment. This setting doesn't apply to RDS Custom.</p>
    pub multi_az: bool,
    /// <p>Indicates the database engine version.</p>
    pub engine_version: std::option::Option<std::string::String>,
    /// <p>A value that indicates that minor version patches are applied automatically.</p>
    pub auto_minor_version_upgrade: bool,
    /// <p>Contains the identifier of the source DB instance if this DB instance is a read replica.</p>
    pub read_replica_source_db_instance_identifier: std::option::Option<std::string::String>,
    /// <p>Contains one or more identifiers of the read replicas associated with this DB instance.</p>
    pub read_replica_db_instance_identifiers:
        std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Contains one or more identifiers of Aurora DB clusters to which the RDS DB instance is replicated as a read replica. For example, when you create an Aurora read replica of an RDS for MySQL DB instance, the Aurora MySQL DB cluster for the Aurora read replica is shown. This output doesn't contain information about cross-Region Aurora read replicas.</p> <note>
    /// <p>Currently, each RDS DB instance can have only one Aurora read replica.</p>
    /// </note>
    pub read_replica_db_cluster_identifiers:
        std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The open mode of an Oracle read replica. The default is <code>open-read-only</code>. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/oracle-read-replicas.html">Working with Oracle Read Replicas for Amazon RDS</a> in the <i>Amazon RDS User Guide</i>.</p> <note>
    /// <p>This attribute is only supported in RDS for Oracle.</p>
    /// </note>
    pub replica_mode: std::option::Option<crate::model::ReplicaMode>,
    /// <p>License model information for this DB instance. This setting doesn't apply to RDS Custom.</p>
    pub license_model: std::option::Option<std::string::String>,
    /// <p>Specifies the Provisioned IOPS (I/O operations per second) value.</p>
    pub iops: std::option::Option<i32>,
    /// <p>Provides the list of option group memberships for this DB instance.</p>
    pub option_group_memberships:
        std::option::Option<std::vec::Vec<crate::model::OptionGroupMembership>>,
    /// <p>If present, specifies the name of the character set that this instance is associated with.</p>
    pub character_set_name: std::option::Option<std::string::String>,
    /// <p>The name of the NCHAR character set for the Oracle DB instance. This character set specifies the Unicode encoding for data stored in table columns of type NCHAR, NCLOB, or NVARCHAR2. </p>
    pub nchar_character_set_name: std::option::Option<std::string::String>,
    /// <p>If present, specifies the name of the secondary Availability Zone for a DB instance with multi-AZ support.</p>
    pub secondary_availability_zone: std::option::Option<std::string::String>,
    /// <p>Specifies the accessibility options for the DB instance.</p>
    /// <p>When the DB cluster is publicly accessible, its Domain Name System (DNS) endpoint resolves to the private IP address from within the DB cluster's virtual private cloud (VPC). It resolves to the public IP address from outside of the DB cluster's VPC. Access to the DB cluster is ultimately controlled by the security group it uses. That public access isn't permitted if the security group assigned to the DB cluster doesn't permit it.</p>
    /// <p>When the DB instance isn't publicly accessible, it is an internal DB instance with a DNS name that resolves to a private IP address.</p>
    /// <p>For more information, see <code>CreateDBInstance</code>.</p>
    pub publicly_accessible: bool,
    /// <p>The status of a read replica. If the instance isn't a read replica, this is blank.</p>
    pub status_infos: std::option::Option<std::vec::Vec<crate::model::DbInstanceStatusInfo>>,
    /// <p>Specifies the storage type associated with DB instance.</p>
    pub storage_type: std::option::Option<std::string::String>,
    /// <p>The ARN from the key store with which the instance is associated for TDE encryption.</p>
    pub tde_credential_arn: std::option::Option<std::string::String>,
    /// <p>Specifies the port that the DB instance listens on. If the DB instance is part of a DB cluster, this can be a different port than the DB cluster port.</p>
    pub db_instance_port: i32,
    /// <p>If the DB instance is a member of a DB cluster, contains the name of the DB cluster that the DB instance is a member of.</p>
    pub db_cluster_identifier: std::option::Option<std::string::String>,
    /// <p>Specifies whether the DB instance is encrypted.</p>
    pub storage_encrypted: bool,
    /// <p> If <code>StorageEncrypted</code> is true, the Amazon Web Services KMS key identifier for the encrypted DB instance. </p>
    /// <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.</p>
    pub kms_key_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services Region-unique, immutable identifier for the DB instance. This identifier is found in Amazon Web Services CloudTrail log entries whenever the Amazon Web Services KMS key for the DB instance is accessed.</p>
    pub dbi_resource_id: std::option::Option<std::string::String>,
    /// <p>The identifier of the CA certificate for this DB instance.</p>
    pub ca_certificate_identifier: std::option::Option<std::string::String>,
    /// <p>The Active Directory Domain membership records associated with the DB instance.</p>
    pub domain_memberships: std::option::Option<std::vec::Vec<crate::model::DomainMembership>>,
    /// <p>Specifies whether tags are copied from the DB instance to snapshots of the DB instance.</p>
    /// <p> <b>Amazon Aurora</b> </p>
    /// <p>Not applicable. Copying tags to snapshots is managed by the DB cluster. Setting this value for an Aurora DB instance has no effect on the DB cluster setting. For more information, see <code>DBCluster</code>.</p>
    pub copy_tags_to_snapshot: bool,
    /// <p>The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB instance.</p>
    pub monitoring_interval: std::option::Option<i32>,
    /// <p>The Amazon Resource Name (ARN) of the Amazon CloudWatch Logs log stream that receives the Enhanced Monitoring metrics data for the DB instance.</p>
    pub enhanced_monitoring_resource_arn: std::option::Option<std::string::String>,
    /// <p>The ARN for the IAM role that permits RDS to send Enhanced Monitoring metrics to Amazon CloudWatch Logs.</p>
    pub monitoring_role_arn: std::option::Option<std::string::String>,
    /// <p>A value that specifies the order in which an Aurora Replica is promoted to the primary instance after a failure of the existing primary instance. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.FaultTolerance"> Fault Tolerance for an Aurora DB Cluster</a> in the <i>Amazon Aurora User Guide</i>. </p>
    pub promotion_tier: std::option::Option<i32>,
    /// <p>The Amazon Resource Name (ARN) for the DB instance.</p>
    pub db_instance_arn: std::option::Option<std::string::String>,
    /// <p>The time zone of the DB instance. In most cases, the <code>Timezone</code> element is empty. <code>Timezone</code> content appears only for Microsoft SQL Server DB instances that were created with a time zone specified. </p>
    pub timezone: std::option::Option<std::string::String>,
    /// <p>True if mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts is enabled, and otherwise false.</p>
    /// <p>IAM database authentication can be enabled for the following database engines</p>
    /// <ul>
    /// <li> <p>For MySQL 5.6, minor version 5.6.34 or higher</p> </li>
    /// <li> <p>For MySQL 5.7, minor version 5.7.16 or higher</p> </li>
    /// <li> <p>Aurora 5.6 or higher. To enable IAM database authentication for Aurora, see DBCluster Type.</p> </li>
    /// </ul>
    pub iam_database_authentication_enabled: bool,
    /// <p>True if Performance Insights is enabled for the DB instance, and otherwise false.</p>
    pub performance_insights_enabled: std::option::Option<bool>,
    /// <p>The Amazon Web Services KMS key identifier for encryption of Performance Insights data.</p>
    /// <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.</p>
    pub performance_insights_kms_key_id: std::option::Option<std::string::String>,
    /// <p>The amount of time, in days, to retain Performance Insights data. Valid values are 7 or 731 (2 years). </p>
    pub performance_insights_retention_period: std::option::Option<i32>,
    /// <p>A list of log types that this DB instance is configured to export to CloudWatch Logs.</p>
    /// <p>Log types vary by DB engine. For information about the log types for each DB engine, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html">Amazon RDS Database Log Files</a> in the <i>Amazon RDS User Guide.</i> </p>
    pub enabled_cloudwatch_logs_exports: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.</p>
    pub processor_features: std::option::Option<std::vec::Vec<crate::model::ProcessorFeature>>,
    /// <p>Indicates if the DB instance has deletion protection enabled. The database can't be deleted when deletion protection is enabled. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html"> Deleting a DB Instance</a>. </p>
    pub deletion_protection: bool,
    /// <p> The Amazon Web Services Identity and Access Management (IAM) roles associated with the DB instance. </p>
    pub associated_roles: std::option::Option<std::vec::Vec<crate::model::DbInstanceRole>>,
    /// <p>Specifies the listener connection endpoint for SQL Server Always On.</p>
    pub listener_endpoint: std::option::Option<crate::model::Endpoint>,
    /// <p>The upper limit in gibibytes (GiB) to which Amazon RDS can automatically scale the storage of the DB instance.</p>
    pub max_allocated_storage: std::option::Option<i32>,
    /// <p>A list of tags. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources</a> in the <i>Amazon RDS User Guide.</i> </p>
    pub tag_list: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The list of replicated automated backups associated with the DB instance.</p>
    pub db_instance_automated_backups_replications:
        std::option::Option<std::vec::Vec<crate::model::DbInstanceAutomatedBackupsReplication>>,
    /// <p>Specifies whether a customer-owned IP address (CoIP) is enabled for an RDS on Outposts DB instance.</p>
    /// <p>A <i>CoIP </i>provides local or external connectivity to resources in your Outpost subnets through your on-premises network. For some use cases, a CoIP can provide lower latency for connections to the DB instance from outside of its virtual private cloud (VPC) on your local network.</p>
    /// <p>For more information about RDS on Outposts, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html">Working with Amazon RDS on Amazon Web Services Outposts</a> in the <i>Amazon RDS User Guide</i>.</p>
    /// <p>For more information about CoIPs, see <a href="https://docs.aws.amazon.com/outposts/latest/userguide/outposts-networking-components.html#ip-addressing">Customer-owned IP addresses</a> in the <i>Amazon Web Services Outposts User Guide</i>.</p>
    pub customer_owned_ip_enabled: std::option::Option<bool>,
    /// <p>The Amazon Resource Name (ARN) of the recovery point in Amazon Web Services Backup.</p>
    pub aws_backup_recovery_point_arn: std::option::Option<std::string::String>,
    /// <p>The status of the database activity stream.</p>
    pub activity_stream_status: std::option::Option<crate::model::ActivityStreamStatus>,
    /// <p>The Amazon Web Services KMS key identifier used for encrypting messages in the database activity stream. The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.</p>
    pub activity_stream_kms_key_id: std::option::Option<std::string::String>,
    /// <p>The name of the Amazon Kinesis data stream used for the database activity stream.</p>
    pub activity_stream_kinesis_stream_name: std::option::Option<std::string::String>,
    /// <p>The mode of the database activity stream. Database events such as a change or access generate an activity stream event. RDS for Oracle always handles these events asynchronously.</p>
    pub activity_stream_mode: std::option::Option<crate::model::ActivityStreamMode>,
    /// <p>Indicates whether engine-native audit fields are included in the database activity stream.</p>
    pub activity_stream_engine_native_audit_fields_included: std::option::Option<bool>,
    /// <p>The automation mode of the RDS Custom DB instance: <code>full</code> or <code>all paused</code>. If <code>full</code>, the DB instance automates monitoring and instance recovery. If <code>all paused</code>, the instance pauses automation for the duration set by <code>--resume-full-automation-mode-minutes</code>.</p>
    pub automation_mode: std::option::Option<crate::model::AutomationMode>,
    /// <p>The number of minutes to pause the automation. When the time period ends, RDS Custom resumes full automation. The minimum value is 60 (default). The maximum value is 1,440. </p>
    pub resume_full_automation_mode_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The instance profile associated with the underlying Amazon EC2 instance of an RDS Custom DB instance. The instance profile must meet the following requirements:</p>
    /// <ul>
    /// <li> <p>The profile must exist in your account.</p> </li>
    /// <li> <p>The profile must have an IAM role that Amazon EC2 has permissions to assume.</p> </li>
    /// <li> <p>The instance profile name and the associated IAM role name must start with the prefix <code>AWSRDSCustom</code>.</p> </li>
    /// </ul>
    /// <p>For the list of permissions required for the IAM role, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-setup-orcl.html#custom-setup-orcl.iam-vpc"> Configure IAM and your VPC</a> in the <i>Amazon Relational Database Service User Guide</i>.</p>
    pub custom_iam_instance_profile: std::option::Option<std::string::String>,
    /// <p>Specifies where automated backups and manual snapshots are stored: Amazon Web Services Outposts or the Amazon Web Services Region.</p>
    pub backup_target: std::option::Option<std::string::String>,
}
impl DbInstance {
    /// <p>Contains a user-supplied database identifier. This identifier is the unique key that identifies a DB instance.</p>
    pub fn db_instance_identifier(&self) -> std::option::Option<&str> {
        self.db_instance_identifier.as_deref()
    }
    /// <p>Contains the name of the compute and memory capacity class of the DB instance.</p>
    pub fn db_instance_class(&self) -> std::option::Option<&str> {
        self.db_instance_class.as_deref()
    }
    /// <p>The name of the database engine to be used for this DB instance.</p>
    pub fn engine(&self) -> std::option::Option<&str> {
        self.engine.as_deref()
    }
    /// <p>Specifies the current state of this database.</p>
    /// <p>For information about DB instance statuses, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/accessing-monitoring.html#Overview.DBInstance.Status">Viewing DB instance status</a> in the <i>Amazon RDS User Guide.</i> </p>
    pub fn db_instance_status(&self) -> std::option::Option<&str> {
        self.db_instance_status.as_deref()
    }
    /// <p>The time when a stopped DB instance is restarted automatically.</p>
    pub fn automatic_restart_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.automatic_restart_time.as_ref()
    }
    /// <p>Contains the master username for the DB instance.</p>
    pub fn master_username(&self) -> std::option::Option<&str> {
        self.master_username.as_deref()
    }
    /// <p>The meaning of this parameter differs according to the database engine you use.</p>
    /// <p> <b>MySQL, MariaDB, SQL Server, PostgreSQL</b> </p>
    /// <p>Contains the name of the initial database of this instance that was provided at create time, if one was specified when the DB instance was created. This same name is returned for the life of the DB instance.</p>
    /// <p>Type: String</p>
    /// <p> <b>Oracle</b> </p>
    /// <p>Contains the Oracle System ID (SID) of the created DB instance. Not shown when the returned parameters do not apply to an Oracle DB instance.</p>
    pub fn db_name(&self) -> std::option::Option<&str> {
        self.db_name.as_deref()
    }
    /// <p>Specifies the connection endpoint.</p> <note>
    /// <p>The endpoint might not be shown for instances whose status is <code>creating</code>.</p>
    /// </note>
    pub fn endpoint(&self) -> std::option::Option<&crate::model::Endpoint> {
        self.endpoint.as_ref()
    }
    /// <p>Specifies the allocated storage size specified in gibibytes (GiB).</p>
    pub fn allocated_storage(&self) -> i32 {
        self.allocated_storage
    }
    /// <p>Provides the date and time the DB instance was created.</p>
    pub fn instance_create_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.instance_create_time.as_ref()
    }
    /// <p> Specifies the daily time range during which automated backups are created if automated backups are enabled, as determined by the <code>BackupRetentionPeriod</code>. </p>
    pub fn preferred_backup_window(&self) -> std::option::Option<&str> {
        self.preferred_backup_window.as_deref()
    }
    /// <p>Specifies the number of days for which automatic DB snapshots are retained.</p>
    pub fn backup_retention_period(&self) -> i32 {
        self.backup_retention_period
    }
    /// <p> A list of DB security group elements containing <code>DBSecurityGroup.Name</code> and <code>DBSecurityGroup.Status</code> subelements. </p>
    pub fn db_security_groups(
        &self,
    ) -> std::option::Option<&[crate::model::DbSecurityGroupMembership]> {
        self.db_security_groups.as_deref()
    }
    /// <p>Provides a list of VPC security group elements that the DB instance belongs to.</p>
    pub fn vpc_security_groups(
        &self,
    ) -> std::option::Option<&[crate::model::VpcSecurityGroupMembership]> {
        self.vpc_security_groups.as_deref()
    }
    /// <p>Provides the list of DB parameter groups applied to this DB instance.</p>
    pub fn db_parameter_groups(
        &self,
    ) -> std::option::Option<&[crate::model::DbParameterGroupStatus]> {
        self.db_parameter_groups.as_deref()
    }
    /// <p>Specifies the name of the Availability Zone the DB instance is located in.</p>
    pub fn availability_zone(&self) -> std::option::Option<&str> {
        self.availability_zone.as_deref()
    }
    /// <p>Specifies information on the subnet group associated with the DB instance, including the name, description, and subnets in the subnet group.</p>
    pub fn db_subnet_group(&self) -> std::option::Option<&crate::model::DbSubnetGroup> {
        self.db_subnet_group.as_ref()
    }
    /// <p>Specifies the weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).</p>
    pub fn preferred_maintenance_window(&self) -> std::option::Option<&str> {
        self.preferred_maintenance_window.as_deref()
    }
    /// <p>A value that specifies that changes to the DB instance are pending. This element is only included when changes are pending. Specific changes are identified by subelements.</p>
    pub fn pending_modified_values(
        &self,
    ) -> std::option::Option<&crate::model::PendingModifiedValues> {
        self.pending_modified_values.as_ref()
    }
    /// <p>Specifies the latest time to which a database can be restored with point-in-time restore.</p>
    pub fn latest_restorable_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.latest_restorable_time.as_ref()
    }
    /// <p>Specifies if the DB instance is a Multi-AZ deployment. This setting doesn't apply to RDS Custom.</p>
    pub fn multi_az(&self) -> bool {
        self.multi_az
    }
    /// <p>Indicates the database engine version.</p>
    pub fn engine_version(&self) -> std::option::Option<&str> {
        self.engine_version.as_deref()
    }
    /// <p>A value that indicates that minor version patches are applied automatically.</p>
    pub fn auto_minor_version_upgrade(&self) -> bool {
        self.auto_minor_version_upgrade
    }
    /// <p>Contains the identifier of the source DB instance if this DB instance is a read replica.</p>
    pub fn read_replica_source_db_instance_identifier(&self) -> std::option::Option<&str> {
        self.read_replica_source_db_instance_identifier.as_deref()
    }
    /// <p>Contains one or more identifiers of the read replicas associated with this DB instance.</p>
    pub fn read_replica_db_instance_identifiers(
        &self,
    ) -> std::option::Option<&[std::string::String]> {
        self.read_replica_db_instance_identifiers.as_deref()
    }
    /// <p>Contains one or more identifiers of Aurora DB clusters to which the RDS DB instance is replicated as a read replica. For example, when you create an Aurora read replica of an RDS for MySQL DB instance, the Aurora MySQL DB cluster for the Aurora read replica is shown. This output doesn't contain information about cross-Region Aurora read replicas.</p> <note>
    /// <p>Currently, each RDS DB instance can have only one Aurora read replica.</p>
    /// </note>
    pub fn read_replica_db_cluster_identifiers(
        &self,
    ) -> std::option::Option<&[std::string::String]> {
        self.read_replica_db_cluster_identifiers.as_deref()
    }
    /// <p>The open mode of an Oracle read replica. The default is <code>open-read-only</code>. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/oracle-read-replicas.html">Working with Oracle Read Replicas for Amazon RDS</a> in the <i>Amazon RDS User Guide</i>.</p> <note>
    /// <p>This attribute is only supported in RDS for Oracle.</p>
    /// </note>
    pub fn replica_mode(&self) -> std::option::Option<&crate::model::ReplicaMode> {
        self.replica_mode.as_ref()
    }
    /// <p>License model information for this DB instance. This setting doesn't apply to RDS Custom.</p>
    pub fn license_model(&self) -> std::option::Option<&str> {
        self.license_model.as_deref()
    }
    /// <p>Specifies the Provisioned IOPS (I/O operations per second) value.</p>
    pub fn iops(&self) -> std::option::Option<i32> {
        self.iops
    }
    /// <p>Provides the list of option group memberships for this DB instance.</p>
    pub fn option_group_memberships(
        &self,
    ) -> std::option::Option<&[crate::model::OptionGroupMembership]> {
        self.option_group_memberships.as_deref()
    }
    /// <p>If present, specifies the name of the character set that this instance is associated with.</p>
    pub fn character_set_name(&self) -> std::option::Option<&str> {
        self.character_set_name.as_deref()
    }
    /// <p>The name of the NCHAR character set for the Oracle DB instance. This character set specifies the Unicode encoding for data stored in table columns of type NCHAR, NCLOB, or NVARCHAR2. </p>
    pub fn nchar_character_set_name(&self) -> std::option::Option<&str> {
        self.nchar_character_set_name.as_deref()
    }
    /// <p>If present, specifies the name of the secondary Availability Zone for a DB instance with multi-AZ support.</p>
    pub fn secondary_availability_zone(&self) -> std::option::Option<&str> {
        self.secondary_availability_zone.as_deref()
    }
    /// <p>Specifies the accessibility options for the DB instance.</p>
    /// <p>When the DB cluster is publicly accessible, its Domain Name System (DNS) endpoint resolves to the private IP address from within the DB cluster's virtual private cloud (VPC). It resolves to the public IP address from outside of the DB cluster's VPC. Access to the DB cluster is ultimately controlled by the security group it uses. That public access isn't permitted if the security group assigned to the DB cluster doesn't permit it.</p>
    /// <p>When the DB instance isn't publicly accessible, it is an internal DB instance with a DNS name that resolves to a private IP address.</p>
    /// <p>For more information, see <code>CreateDBInstance</code>.</p>
    pub fn publicly_accessible(&self) -> bool {
        self.publicly_accessible
    }
    /// <p>The status of a read replica. If the instance isn't a read replica, this is blank.</p>
    pub fn status_infos(&self) -> std::option::Option<&[crate::model::DbInstanceStatusInfo]> {
        self.status_infos.as_deref()
    }
    /// <p>Specifies the storage type associated with DB instance.</p>
    pub fn storage_type(&self) -> std::option::Option<&str> {
        self.storage_type.as_deref()
    }
    /// <p>The ARN from the key store with which the instance is associated for TDE encryption.</p>
    pub fn tde_credential_arn(&self) -> std::option::Option<&str> {
        self.tde_credential_arn.as_deref()
    }
    /// <p>Specifies the port that the DB instance listens on. If the DB instance is part of a DB cluster, this can be a different port than the DB cluster port.</p>
    pub fn db_instance_port(&self) -> i32 {
        self.db_instance_port
    }
    /// <p>If the DB instance is a member of a DB cluster, contains the name of the DB cluster that the DB instance is a member of.</p>
    pub fn db_cluster_identifier(&self) -> std::option::Option<&str> {
        self.db_cluster_identifier.as_deref()
    }
    /// <p>Specifies whether the DB instance is encrypted.</p>
    pub fn storage_encrypted(&self) -> bool {
        self.storage_encrypted
    }
    /// <p> If <code>StorageEncrypted</code> is true, the Amazon Web Services KMS key identifier for the encrypted DB instance. </p>
    /// <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.</p>
    pub fn kms_key_id(&self) -> std::option::Option<&str> {
        self.kms_key_id.as_deref()
    }
    /// <p>The Amazon Web Services Region-unique, immutable identifier for the DB instance. This identifier is found in Amazon Web Services CloudTrail log entries whenever the Amazon Web Services KMS key for the DB instance is accessed.</p>
    pub fn dbi_resource_id(&self) -> std::option::Option<&str> {
        self.dbi_resource_id.as_deref()
    }
    /// <p>The identifier of the CA certificate for this DB instance.</p>
    pub fn ca_certificate_identifier(&self) -> std::option::Option<&str> {
        self.ca_certificate_identifier.as_deref()
    }
    /// <p>The Active Directory Domain membership records associated with the DB instance.</p>
    pub fn domain_memberships(&self) -> std::option::Option<&[crate::model::DomainMembership]> {
        self.domain_memberships.as_deref()
    }
    /// <p>Specifies whether tags are copied from the DB instance to snapshots of the DB instance.</p>
    /// <p> <b>Amazon Aurora</b> </p>
    /// <p>Not applicable. Copying tags to snapshots is managed by the DB cluster. Setting this value for an Aurora DB instance has no effect on the DB cluster setting. For more information, see <code>DBCluster</code>.</p>
    pub fn copy_tags_to_snapshot(&self) -> bool {
        self.copy_tags_to_snapshot
    }
    /// <p>The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB instance.</p>
    pub fn monitoring_interval(&self) -> std::option::Option<i32> {
        self.monitoring_interval
    }
    /// <p>The Amazon Resource Name (ARN) of the Amazon CloudWatch Logs log stream that receives the Enhanced Monitoring metrics data for the DB instance.</p>
    pub fn enhanced_monitoring_resource_arn(&self) -> std::option::Option<&str> {
        self.enhanced_monitoring_resource_arn.as_deref()
    }
    /// <p>The ARN for the IAM role that permits RDS to send Enhanced Monitoring metrics to Amazon CloudWatch Logs.</p>
    pub fn monitoring_role_arn(&self) -> std::option::Option<&str> {
        self.monitoring_role_arn.as_deref()
    }
    /// <p>A value that specifies the order in which an Aurora Replica is promoted to the primary instance after a failure of the existing primary instance. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.FaultTolerance"> Fault Tolerance for an Aurora DB Cluster</a> in the <i>Amazon Aurora User Guide</i>. </p>
    pub fn promotion_tier(&self) -> std::option::Option<i32> {
        self.promotion_tier
    }
    /// <p>The Amazon Resource Name (ARN) for the DB instance.</p>
    pub fn db_instance_arn(&self) -> std::option::Option<&str> {
        self.db_instance_arn.as_deref()
    }
    /// <p>The time zone of the DB instance. In most cases, the <code>Timezone</code> element is empty. <code>Timezone</code> content appears only for Microsoft SQL Server DB instances that were created with a time zone specified. </p>
    pub fn timezone(&self) -> std::option::Option<&str> {
        self.timezone.as_deref()
    }
    /// <p>True if mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts is enabled, and otherwise false.</p>
    /// <p>IAM database authentication can be enabled for the following database engines</p>
    /// <ul>
    /// <li> <p>For MySQL 5.6, minor version 5.6.34 or higher</p> </li>
    /// <li> <p>For MySQL 5.7, minor version 5.7.16 or higher</p> </li>
    /// <li> <p>Aurora 5.6 or higher. To enable IAM database authentication for Aurora, see DBCluster Type.</p> </li>
    /// </ul>
    pub fn iam_database_authentication_enabled(&self) -> bool {
        self.iam_database_authentication_enabled
    }
    /// <p>True if Performance Insights is enabled for the DB instance, and otherwise false.</p>
    pub fn performance_insights_enabled(&self) -> std::option::Option<bool> {
        self.performance_insights_enabled
    }
    /// <p>The Amazon Web Services KMS key identifier for encryption of Performance Insights data.</p>
    /// <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.</p>
    pub fn performance_insights_kms_key_id(&self) -> std::option::Option<&str> {
        self.performance_insights_kms_key_id.as_deref()
    }
    /// <p>The amount of time, in days, to retain Performance Insights data. Valid values are 7 or 731 (2 years). </p>
    pub fn performance_insights_retention_period(&self) -> std::option::Option<i32> {
        self.performance_insights_retention_period
    }
    /// <p>A list of log types that this DB instance is configured to export to CloudWatch Logs.</p>
    /// <p>Log types vary by DB engine. For information about the log types for each DB engine, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html">Amazon RDS Database Log Files</a> in the <i>Amazon RDS User Guide.</i> </p>
    pub fn enabled_cloudwatch_logs_exports(&self) -> std::option::Option<&[std::string::String]> {
        self.enabled_cloudwatch_logs_exports.as_deref()
    }
    /// <p>The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.</p>
    pub fn processor_features(&self) -> std::option::Option<&[crate::model::ProcessorFeature]> {
        self.processor_features.as_deref()
    }
    /// <p>Indicates if the DB instance has deletion protection enabled. The database can't be deleted when deletion protection is enabled. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html"> Deleting a DB Instance</a>. </p>
    pub fn deletion_protection(&self) -> bool {
        self.deletion_protection
    }
    /// <p> The Amazon Web Services Identity and Access Management (IAM) roles associated with the DB instance. </p>
    pub fn associated_roles(&self) -> std::option::Option<&[crate::model::DbInstanceRole]> {
        self.associated_roles.as_deref()
    }
    /// <p>Specifies the listener connection endpoint for SQL Server Always On.</p>
    pub fn listener_endpoint(&self) -> std::option::Option<&crate::model::Endpoint> {
        self.listener_endpoint.as_ref()
    }
    /// <p>The upper limit in gibibytes (GiB) to which Amazon RDS can automatically scale the storage of the DB instance.</p>
    pub fn max_allocated_storage(&self) -> std::option::Option<i32> {
        self.max_allocated_storage
    }
    /// <p>A list of tags. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources</a> in the <i>Amazon RDS User Guide.</i> </p>
    pub fn tag_list(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tag_list.as_deref()
    }
    /// <p>The list of replicated automated backups associated with the DB instance.</p>
    pub fn db_instance_automated_backups_replications(
        &self,
    ) -> std::option::Option<&[crate::model::DbInstanceAutomatedBackupsReplication]> {
        self.db_instance_automated_backups_replications.as_deref()
    }
    /// <p>Specifies whether a customer-owned IP address (CoIP) is enabled for an RDS on Outposts DB instance.</p>
    /// <p>A <i>CoIP </i>provides local or external connectivity to resources in your Outpost subnets through your on-premises network. For some use cases, a CoIP can provide lower latency for connections to the DB instance from outside of its virtual private cloud (VPC) on your local network.</p>
    /// <p>For more information about RDS on Outposts, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html">Working with Amazon RDS on Amazon Web Services Outposts</a> in the <i>Amazon RDS User Guide</i>.</p>
    /// <p>For more information about CoIPs, see <a href="https://docs.aws.amazon.com/outposts/latest/userguide/outposts-networking-components.html#ip-addressing">Customer-owned IP addresses</a> in the <i>Amazon Web Services Outposts User Guide</i>.</p>
    pub fn customer_owned_ip_enabled(&self) -> std::option::Option<bool> {
        self.customer_owned_ip_enabled
    }
    /// <p>The Amazon Resource Name (ARN) of the recovery point in Amazon Web Services Backup.</p>
    pub fn aws_backup_recovery_point_arn(&self) -> std::option::Option<&str> {
        self.aws_backup_recovery_point_arn.as_deref()
    }
    /// <p>The status of the database activity stream.</p>
    pub fn activity_stream_status(
        &self,
    ) -> std::option::Option<&crate::model::ActivityStreamStatus> {
        self.activity_stream_status.as_ref()
    }
    /// <p>The Amazon Web Services KMS key identifier used for encrypting messages in the database activity stream. The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.</p>
    pub fn activity_stream_kms_key_id(&self) -> std::option::Option<&str> {
        self.activity_stream_kms_key_id.as_deref()
    }
    /// <p>The name of the Amazon Kinesis data stream used for the database activity stream.</p>
    pub fn activity_stream_kinesis_stream_name(&self) -> std::option::Option<&str> {
        self.activity_stream_kinesis_stream_name.as_deref()
    }
    /// <p>The mode of the database activity stream. Database events such as a change or access generate an activity stream event. RDS for Oracle always handles these events asynchronously.</p>
    pub fn activity_stream_mode(&self) -> std::option::Option<&crate::model::ActivityStreamMode> {
        self.activity_stream_mode.as_ref()
    }
    /// <p>Indicates whether engine-native audit fields are included in the database activity stream.</p>
    pub fn activity_stream_engine_native_audit_fields_included(&self) -> std::option::Option<bool> {
        self.activity_stream_engine_native_audit_fields_included
    }
    /// <p>The automation mode of the RDS Custom DB instance: <code>full</code> or <code>all paused</code>. If <code>full</code>, the DB instance automates monitoring and instance recovery. If <code>all paused</code>, the instance pauses automation for the duration set by <code>--resume-full-automation-mode-minutes</code>.</p>
    pub fn automation_mode(&self) -> std::option::Option<&crate::model::AutomationMode> {
        self.automation_mode.as_ref()
    }
    /// <p>The number of minutes to pause the automation. When the time period ends, RDS Custom resumes full automation. The minimum value is 60 (default). The maximum value is 1,440. </p>
    pub fn resume_full_automation_mode_time(
        &self,
    ) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.resume_full_automation_mode_time.as_ref()
    }
    /// <p>The instance profile associated with the underlying Amazon EC2 instance of an RDS Custom DB instance. The instance profile must meet the following requirements:</p>
    /// <ul>
    /// <li> <p>The profile must exist in your account.</p> </li>
    /// <li> <p>The profile must have an IAM role that Amazon EC2 has permissions to assume.</p> </li>
    /// <li> <p>The instance profile name and the associated IAM role name must start with the prefix <code>AWSRDSCustom</code>.</p> </li>
    /// </ul>
    /// <p>For the list of permissions required for the IAM role, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-setup-orcl.html#custom-setup-orcl.iam-vpc"> Configure IAM and your VPC</a> in the <i>Amazon Relational Database Service User Guide</i>.</p>
    pub fn custom_iam_instance_profile(&self) -> std::option::Option<&str> {
        self.custom_iam_instance_profile.as_deref()
    }
    /// <p>Specifies where automated backups and manual snapshots are stored: Amazon Web Services Outposts or the Amazon Web Services Region.</p>
    pub fn backup_target(&self) -> std::option::Option<&str> {
        self.backup_target.as_deref()
    }
}
impl std::fmt::Debug for DbInstance {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DbInstance");
        formatter.field("db_instance_identifier", &self.db_instance_identifier);
        formatter.field("db_instance_class", &self.db_instance_class);
        formatter.field("engine", &self.engine);
        formatter.field("db_instance_status", &self.db_instance_status);
        formatter.field("automatic_restart_time", &self.automatic_restart_time);
        formatter.field("master_username", &self.master_username);
        formatter.field("db_name", &self.db_name);
        formatter.field("endpoint", &self.endpoint);
        formatter.field("allocated_storage", &self.allocated_storage);
        formatter.field("instance_create_time", &self.instance_create_time);
        formatter.field("preferred_backup_window", &self.preferred_backup_window);
        formatter.field("backup_retention_period", &self.backup_retention_period);
        formatter.field("db_security_groups", &self.db_security_groups);
        formatter.field("vpc_security_groups", &self.vpc_security_groups);
        formatter.field("db_parameter_groups", &self.db_parameter_groups);
        formatter.field("availability_zone", &self.availability_zone);
        formatter.field("db_subnet_group", &self.db_subnet_group);
        formatter.field(
            "preferred_maintenance_window",
            &self.preferred_maintenance_window,
        );
        formatter.field("pending_modified_values", &self.pending_modified_values);
        formatter.field("latest_restorable_time", &self.latest_restorable_time);
        formatter.field("multi_az", &self.multi_az);
        formatter.field("engine_version", &self.engine_version);
        formatter.field(
            "auto_minor_version_upgrade",
            &self.auto_minor_version_upgrade,
        );
        formatter.field(
            "read_replica_source_db_instance_identifier",
            &self.read_replica_source_db_instance_identifier,
        );
        formatter.field(
            "read_replica_db_instance_identifiers",
            &self.read_replica_db_instance_identifiers,
        );
        formatter.field(
            "read_replica_db_cluster_identifiers",
            &self.read_replica_db_cluster_identifiers,
        );
        formatter.field("replica_mode", &self.replica_mode);
        formatter.field("license_model", &self.license_model);
        formatter.field("iops", &self.iops);
        formatter.field("option_group_memberships", &self.option_group_memberships);
        formatter.field("character_set_name", &self.character_set_name);
        formatter.field("nchar_character_set_name", &self.nchar_character_set_name);
        formatter.field(
            "secondary_availability_zone",
            &self.secondary_availability_zone,
        );
        formatter.field("publicly_accessible", &self.publicly_accessible);
        formatter.field("status_infos", &self.status_infos);
        formatter.field("storage_type", &self.storage_type);
        formatter.field("tde_credential_arn", &self.tde_credential_arn);
        formatter.field("db_instance_port", &self.db_instance_port);
        formatter.field("db_cluster_identifier", &self.db_cluster_identifier);
        formatter.field("storage_encrypted", &self.storage_encrypted);
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.field("dbi_resource_id", &self.dbi_resource_id);
        formatter.field("ca_certificate_identifier", &self.ca_certificate_identifier);
        formatter.field("domain_memberships", &self.domain_memberships);
        formatter.field("copy_tags_to_snapshot", &self.copy_tags_to_snapshot);
        formatter.field("monitoring_interval", &self.monitoring_interval);
        formatter.field(
            "enhanced_monitoring_resource_arn",
            &self.enhanced_monitoring_resource_arn,
        );
        formatter.field("monitoring_role_arn", &self.monitoring_role_arn);
        formatter.field("promotion_tier", &self.promotion_tier);
        formatter.field("db_instance_arn", &self.db_instance_arn);
        formatter.field("timezone", &self.timezone);
        formatter.field(
            "iam_database_authentication_enabled",
            &self.iam_database_authentication_enabled,
        );
        formatter.field(
            "performance_insights_enabled",
            &self.performance_insights_enabled,
        );
        formatter.field(
            "performance_insights_kms_key_id",
            &self.performance_insights_kms_key_id,
        );
        formatter.field(
            "performance_insights_retention_period",
            &self.performance_insights_retention_period,
        );
        formatter.field(
            "enabled_cloudwatch_logs_exports",
            &self.enabled_cloudwatch_logs_exports,
        );
        formatter.field("processor_features", &self.processor_features);
        formatter.field("deletion_protection", &self.deletion_protection);
        formatter.field("associated_roles", &self.associated_roles);
        formatter.field("listener_endpoint", &self.listener_endpoint);
        formatter.field("max_allocated_storage", &self.max_allocated_storage);
        formatter.field("tag_list", &self.tag_list);
        formatter.field(
            "db_instance_automated_backups_replications",
            &self.db_instance_automated_backups_replications,
        );
        formatter.field("customer_owned_ip_enabled", &self.customer_owned_ip_enabled);
        formatter.field(
            "aws_backup_recovery_point_arn",
            &self.aws_backup_recovery_point_arn,
        );
        formatter.field("activity_stream_status", &self.activity_stream_status);
        formatter.field(
            "activity_stream_kms_key_id",
            &self.activity_stream_kms_key_id,
        );
        formatter.field(
            "activity_stream_kinesis_stream_name",
            &self.activity_stream_kinesis_stream_name,
        );
        formatter.field("activity_stream_mode", &self.activity_stream_mode);
        formatter.field(
            "activity_stream_engine_native_audit_fields_included",
            &self.activity_stream_engine_native_audit_fields_included,
        );
        formatter.field("automation_mode", &self.automation_mode);
        formatter.field(
            "resume_full_automation_mode_time",
            &self.resume_full_automation_mode_time,
        );
        formatter.field(
            "custom_iam_instance_profile",
            &self.custom_iam_instance_profile,
        );
        formatter.field("backup_target", &self.backup_target);
        formatter.finish()
    }
}
/// See [`DbInstance`](crate::model::DbInstance)
pub mod db_instance {
    /// A builder for [`DbInstance`](crate::model::DbInstance)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_instance_identifier: std::option::Option<std::string::String>,
        pub(crate) db_instance_class: std::option::Option<std::string::String>,
        pub(crate) engine: std::option::Option<std::string::String>,
        pub(crate) db_instance_status: std::option::Option<std::string::String>,
        pub(crate) automatic_restart_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) master_username: std::option::Option<std::string::String>,
        pub(crate) db_name: std::option::Option<std::string::String>,
        pub(crate) endpoint: std::option::Option<crate::model::Endpoint>,
        pub(crate) allocated_storage: std::option::Option<i32>,
        pub(crate) instance_create_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) preferred_backup_window: std::option::Option<std::string::String>,
        pub(crate) backup_retention_period: std::option::Option<i32>,
        pub(crate) db_security_groups:
            std::option::Option<std::vec::Vec<crate::model::DbSecurityGroupMembership>>,
        pub(crate) vpc_security_groups:
            std::option::Option<std::vec::Vec<crate::model::VpcSecurityGroupMembership>>,
        pub(crate) db_parameter_groups:
            std::option::Option<std::vec::Vec<crate::model::DbParameterGroupStatus>>,
        pub(crate) availability_zone: std::option::Option<std::string::String>,
        pub(crate) db_subnet_group: std::option::Option<crate::model::DbSubnetGroup>,
        pub(crate) preferred_maintenance_window: std::option::Option<std::string::String>,
        pub(crate) pending_modified_values:
            std::option::Option<crate::model::PendingModifiedValues>,
        pub(crate) latest_restorable_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) multi_az: std::option::Option<bool>,
        pub(crate) engine_version: std::option::Option<std::string::String>,
        pub(crate) auto_minor_version_upgrade: std::option::Option<bool>,
        pub(crate) read_replica_source_db_instance_identifier:
            std::option::Option<std::string::String>,
        pub(crate) read_replica_db_instance_identifiers:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) read_replica_db_cluster_identifiers:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) replica_mode: std::option::Option<crate::model::ReplicaMode>,
        pub(crate) license_model: std::option::Option<std::string::String>,
        pub(crate) iops: std::option::Option<i32>,
        pub(crate) option_group_memberships:
            std::option::Option<std::vec::Vec<crate::model::OptionGroupMembership>>,
        pub(crate) character_set_name: std::option::Option<std::string::String>,
        pub(crate) nchar_character_set_name: std::option::Option<std::string::String>,
        pub(crate) secondary_availability_zone: std::option::Option<std::string::String>,
        pub(crate) publicly_accessible: std::option::Option<bool>,
        pub(crate) status_infos:
            std::option::Option<std::vec::Vec<crate::model::DbInstanceStatusInfo>>,
        pub(crate) storage_type: std::option::Option<std::string::String>,
        pub(crate) tde_credential_arn: std::option::Option<std::string::String>,
        pub(crate) db_instance_port: std::option::Option<i32>,
        pub(crate) db_cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) storage_encrypted: std::option::Option<bool>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
        pub(crate) dbi_resource_id: std::option::Option<std::string::String>,
        pub(crate) ca_certificate_identifier: std::option::Option<std::string::String>,
        pub(crate) domain_memberships:
            std::option::Option<std::vec::Vec<crate::model::DomainMembership>>,
        pub(crate) copy_tags_to_snapshot: std::option::Option<bool>,
        pub(crate) monitoring_interval: std::option::Option<i32>,
        pub(crate) enhanced_monitoring_resource_arn: std::option::Option<std::string::String>,
        pub(crate) monitoring_role_arn: std::option::Option<std::string::String>,
        pub(crate) promotion_tier: std::option::Option<i32>,
        pub(crate) db_instance_arn: std::option::Option<std::string::String>,
        pub(crate) timezone: std::option::Option<std::string::String>,
        pub(crate) iam_database_authentication_enabled: std::option::Option<bool>,
        pub(crate) performance_insights_enabled: std::option::Option<bool>,
        pub(crate) performance_insights_kms_key_id: std::option::Option<std::string::String>,
        pub(crate) performance_insights_retention_period: std::option::Option<i32>,
        pub(crate) enabled_cloudwatch_logs_exports:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) processor_features:
            std::option::Option<std::vec::Vec<crate::model::ProcessorFeature>>,
        pub(crate) deletion_protection: std::option::Option<bool>,
        pub(crate) associated_roles:
            std::option::Option<std::vec::Vec<crate::model::DbInstanceRole>>,
        pub(crate) listener_endpoint: std::option::Option<crate::model::Endpoint>,
        pub(crate) max_allocated_storage: std::option::Option<i32>,
        pub(crate) tag_list: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) db_instance_automated_backups_replications:
            std::option::Option<std::vec::Vec<crate::model::DbInstanceAutomatedBackupsReplication>>,
        pub(crate) customer_owned_ip_enabled: std::option::Option<bool>,
        pub(crate) aws_backup_recovery_point_arn: std::option::Option<std::string::String>,
        pub(crate) activity_stream_status: std::option::Option<crate::model::ActivityStreamStatus>,
        pub(crate) activity_stream_kms_key_id: std::option::Option<std::string::String>,
        pub(crate) activity_stream_kinesis_stream_name: std::option::Option<std::string::String>,
        pub(crate) activity_stream_mode: std::option::Option<crate::model::ActivityStreamMode>,
        pub(crate) activity_stream_engine_native_audit_fields_included: std::option::Option<bool>,
        pub(crate) automation_mode: std::option::Option<crate::model::AutomationMode>,
        pub(crate) resume_full_automation_mode_time:
            std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) custom_iam_instance_profile: std::option::Option<std::string::String>,
        pub(crate) backup_target: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Contains a user-supplied database identifier. This identifier is the unique key that identifies a DB instance.</p>
        pub fn db_instance_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_instance_identifier = Some(input.into());
            self
        }
        /// <p>Contains a user-supplied database identifier. This identifier is the unique key that identifies a DB instance.</p>
        pub fn set_db_instance_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_instance_identifier = input;
            self
        }
        /// <p>Contains the name of the compute and memory capacity class of the DB instance.</p>
        pub fn db_instance_class(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_instance_class = Some(input.into());
            self
        }
        /// <p>Contains the name of the compute and memory capacity class of the DB instance.</p>
        pub fn set_db_instance_class(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_instance_class = input;
            self
        }
        /// <p>The name of the database engine to be used for this DB instance.</p>
        pub fn engine(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine = Some(input.into());
            self
        }
        /// <p>The name of the database engine to be used for this DB instance.</p>
        pub fn set_engine(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.engine = input;
            self
        }
        /// <p>Specifies the current state of this database.</p>
        /// <p>For information about DB instance statuses, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/accessing-monitoring.html#Overview.DBInstance.Status">Viewing DB instance status</a> in the <i>Amazon RDS User Guide.</i> </p>
        pub fn db_instance_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_instance_status = Some(input.into());
            self
        }
        /// <p>Specifies the current state of this database.</p>
        /// <p>For information about DB instance statuses, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/accessing-monitoring.html#Overview.DBInstance.Status">Viewing DB instance status</a> in the <i>Amazon RDS User Guide.</i> </p>
        pub fn set_db_instance_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_instance_status = input;
            self
        }
        /// <p>The time when a stopped DB instance is restarted automatically.</p>
        pub fn automatic_restart_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.automatic_restart_time = Some(input);
            self
        }
        /// <p>The time when a stopped DB instance is restarted automatically.</p>
        pub fn set_automatic_restart_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.automatic_restart_time = input;
            self
        }
        /// <p>Contains the master username for the DB instance.</p>
        pub fn master_username(mut self, input: impl Into<std::string::String>) -> Self {
            self.master_username = Some(input.into());
            self
        }
        /// <p>Contains the master username for the DB instance.</p>
        pub fn set_master_username(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.master_username = input;
            self
        }
        /// <p>The meaning of this parameter differs according to the database engine you use.</p>
        /// <p> <b>MySQL, MariaDB, SQL Server, PostgreSQL</b> </p>
        /// <p>Contains the name of the initial database of this instance that was provided at create time, if one was specified when the DB instance was created. This same name is returned for the life of the DB instance.</p>
        /// <p>Type: String</p>
        /// <p> <b>Oracle</b> </p>
        /// <p>Contains the Oracle System ID (SID) of the created DB instance. Not shown when the returned parameters do not apply to an Oracle DB instance.</p>
        pub fn db_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_name = Some(input.into());
            self
        }
        /// <p>The meaning of this parameter differs according to the database engine you use.</p>
        /// <p> <b>MySQL, MariaDB, SQL Server, PostgreSQL</b> </p>
        /// <p>Contains the name of the initial database of this instance that was provided at create time, if one was specified when the DB instance was created. This same name is returned for the life of the DB instance.</p>
        /// <p>Type: String</p>
        /// <p> <b>Oracle</b> </p>
        /// <p>Contains the Oracle System ID (SID) of the created DB instance. Not shown when the returned parameters do not apply to an Oracle DB instance.</p>
        pub fn set_db_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.db_name = input;
            self
        }
        /// <p>Specifies the connection endpoint.</p> <note>
        /// <p>The endpoint might not be shown for instances whose status is <code>creating</code>.</p>
        /// </note>
        pub fn endpoint(mut self, input: crate::model::Endpoint) -> Self {
            self.endpoint = Some(input);
            self
        }
        /// <p>Specifies the connection endpoint.</p> <note>
        /// <p>The endpoint might not be shown for instances whose status is <code>creating</code>.</p>
        /// </note>
        pub fn set_endpoint(mut self, input: std::option::Option<crate::model::Endpoint>) -> Self {
            self.endpoint = input;
            self
        }
        /// <p>Specifies the allocated storage size specified in gibibytes (GiB).</p>
        pub fn allocated_storage(mut self, input: i32) -> Self {
            self.allocated_storage = Some(input);
            self
        }
        /// <p>Specifies the allocated storage size specified in gibibytes (GiB).</p>
        pub fn set_allocated_storage(mut self, input: std::option::Option<i32>) -> Self {
            self.allocated_storage = input;
            self
        }
        /// <p>Provides the date and time the DB instance was created.</p>
        pub fn instance_create_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.instance_create_time = Some(input);
            self
        }
        /// <p>Provides the date and time the DB instance was created.</p>
        pub fn set_instance_create_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.instance_create_time = input;
            self
        }
        /// <p> Specifies the daily time range during which automated backups are created if automated backups are enabled, as determined by the <code>BackupRetentionPeriod</code>. </p>
        pub fn preferred_backup_window(mut self, input: impl Into<std::string::String>) -> Self {
            self.preferred_backup_window = Some(input.into());
            self
        }
        /// <p> Specifies the daily time range during which automated backups are created if automated backups are enabled, as determined by the <code>BackupRetentionPeriod</code>. </p>
        pub fn set_preferred_backup_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.preferred_backup_window = input;
            self
        }
        /// <p>Specifies the number of days for which automatic DB snapshots are retained.</p>
        pub fn backup_retention_period(mut self, input: i32) -> Self {
            self.backup_retention_period = Some(input);
            self
        }
        /// <p>Specifies the number of days for which automatic DB snapshots are retained.</p>
        pub fn set_backup_retention_period(mut self, input: std::option::Option<i32>) -> Self {
            self.backup_retention_period = input;
            self
        }
        /// Appends an item to `db_security_groups`.
        ///
        /// To override the contents of this collection use [`set_db_security_groups`](Self::set_db_security_groups).
        ///
        /// <p> A list of DB security group elements containing <code>DBSecurityGroup.Name</code> and <code>DBSecurityGroup.Status</code> subelements. </p>
        pub fn db_security_groups(
            mut self,
            input: crate::model::DbSecurityGroupMembership,
        ) -> Self {
            let mut v = self.db_security_groups.unwrap_or_default();
            v.push(input);
            self.db_security_groups = Some(v);
            self
        }
        /// <p> A list of DB security group elements containing <code>DBSecurityGroup.Name</code> and <code>DBSecurityGroup.Status</code> subelements. </p>
        pub fn set_db_security_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DbSecurityGroupMembership>>,
        ) -> Self {
            self.db_security_groups = input;
            self
        }
        /// Appends an item to `vpc_security_groups`.
        ///
        /// To override the contents of this collection use [`set_vpc_security_groups`](Self::set_vpc_security_groups).
        ///
        /// <p>Provides a list of VPC security group elements that the DB instance belongs to.</p>
        pub fn vpc_security_groups(
            mut self,
            input: crate::model::VpcSecurityGroupMembership,
        ) -> Self {
            let mut v = self.vpc_security_groups.unwrap_or_default();
            v.push(input);
            self.vpc_security_groups = Some(v);
            self
        }
        /// <p>Provides a list of VPC security group elements that the DB instance belongs to.</p>
        pub fn set_vpc_security_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::VpcSecurityGroupMembership>>,
        ) -> Self {
            self.vpc_security_groups = input;
            self
        }
        /// Appends an item to `db_parameter_groups`.
        ///
        /// To override the contents of this collection use [`set_db_parameter_groups`](Self::set_db_parameter_groups).
        ///
        /// <p>Provides the list of DB parameter groups applied to this DB instance.</p>
        pub fn db_parameter_groups(mut self, input: crate::model::DbParameterGroupStatus) -> Self {
            let mut v = self.db_parameter_groups.unwrap_or_default();
            v.push(input);
            self.db_parameter_groups = Some(v);
            self
        }
        /// <p>Provides the list of DB parameter groups applied to this DB instance.</p>
        pub fn set_db_parameter_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DbParameterGroupStatus>>,
        ) -> Self {
            self.db_parameter_groups = input;
            self
        }
        /// <p>Specifies the name of the Availability Zone the DB instance is located in.</p>
        pub fn availability_zone(mut self, input: impl Into<std::string::String>) -> Self {
            self.availability_zone = Some(input.into());
            self
        }
        /// <p>Specifies the name of the Availability Zone the DB instance is located in.</p>
        pub fn set_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.availability_zone = input;
            self
        }
        /// <p>Specifies information on the subnet group associated with the DB instance, including the name, description, and subnets in the subnet group.</p>
        pub fn db_subnet_group(mut self, input: crate::model::DbSubnetGroup) -> Self {
            self.db_subnet_group = Some(input);
            self
        }
        /// <p>Specifies information on the subnet group associated with the DB instance, including the name, description, and subnets in the subnet group.</p>
        pub fn set_db_subnet_group(
            mut self,
            input: std::option::Option<crate::model::DbSubnetGroup>,
        ) -> Self {
            self.db_subnet_group = input;
            self
        }
        /// <p>Specifies the weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).</p>
        pub fn preferred_maintenance_window(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.preferred_maintenance_window = Some(input.into());
            self
        }
        /// <p>Specifies the weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).</p>
        pub fn set_preferred_maintenance_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.preferred_maintenance_window = input;
            self
        }
        /// <p>A value that specifies that changes to the DB instance are pending. This element is only included when changes are pending. Specific changes are identified by subelements.</p>
        pub fn pending_modified_values(
            mut self,
            input: crate::model::PendingModifiedValues,
        ) -> Self {
            self.pending_modified_values = Some(input);
            self
        }
        /// <p>A value that specifies that changes to the DB instance are pending. This element is only included when changes are pending. Specific changes are identified by subelements.</p>
        pub fn set_pending_modified_values(
            mut self,
            input: std::option::Option<crate::model::PendingModifiedValues>,
        ) -> Self {
            self.pending_modified_values = input;
            self
        }
        /// <p>Specifies the latest time to which a database can be restored with point-in-time restore.</p>
        pub fn latest_restorable_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.latest_restorable_time = Some(input);
            self
        }
        /// <p>Specifies the latest time to which a database can be restored with point-in-time restore.</p>
        pub fn set_latest_restorable_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.latest_restorable_time = input;
            self
        }
        /// <p>Specifies if the DB instance is a Multi-AZ deployment. This setting doesn't apply to RDS Custom.</p>
        pub fn multi_az(mut self, input: bool) -> Self {
            self.multi_az = Some(input);
            self
        }
        /// <p>Specifies if the DB instance is a Multi-AZ deployment. This setting doesn't apply to RDS Custom.</p>
        pub fn set_multi_az(mut self, input: std::option::Option<bool>) -> Self {
            self.multi_az = input;
            self
        }
        /// <p>Indicates the database engine version.</p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_version = Some(input.into());
            self
        }
        /// <p>Indicates the database engine version.</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.engine_version = input;
            self
        }
        /// <p>A value that indicates that minor version patches are applied automatically.</p>
        pub fn auto_minor_version_upgrade(mut self, input: bool) -> Self {
            self.auto_minor_version_upgrade = Some(input);
            self
        }
        /// <p>A value that indicates that minor version patches are applied automatically.</p>
        pub fn set_auto_minor_version_upgrade(mut self, input: std::option::Option<bool>) -> Self {
            self.auto_minor_version_upgrade = input;
            self
        }
        /// <p>Contains the identifier of the source DB instance if this DB instance is a read replica.</p>
        pub fn read_replica_source_db_instance_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.read_replica_source_db_instance_identifier = Some(input.into());
            self
        }
        /// <p>Contains the identifier of the source DB instance if this DB instance is a read replica.</p>
        pub fn set_read_replica_source_db_instance_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.read_replica_source_db_instance_identifier = input;
            self
        }
        /// Appends an item to `read_replica_db_instance_identifiers`.
        ///
        /// To override the contents of this collection use [`set_read_replica_db_instance_identifiers`](Self::set_read_replica_db_instance_identifiers).
        ///
        /// <p>Contains one or more identifiers of the read replicas associated with this DB instance.</p>
        pub fn read_replica_db_instance_identifiers(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self
                .read_replica_db_instance_identifiers
                .unwrap_or_default();
            v.push(input.into());
            self.read_replica_db_instance_identifiers = Some(v);
            self
        }
        /// <p>Contains one or more identifiers of the read replicas associated with this DB instance.</p>
        pub fn set_read_replica_db_instance_identifiers(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.read_replica_db_instance_identifiers = input;
            self
        }
        /// Appends an item to `read_replica_db_cluster_identifiers`.
        ///
        /// To override the contents of this collection use [`set_read_replica_db_cluster_identifiers`](Self::set_read_replica_db_cluster_identifiers).
        ///
        /// <p>Contains one or more identifiers of Aurora DB clusters to which the RDS DB instance is replicated as a read replica. For example, when you create an Aurora read replica of an RDS for MySQL DB instance, the Aurora MySQL DB cluster for the Aurora read replica is shown. This output doesn't contain information about cross-Region Aurora read replicas.</p> <note>
        /// <p>Currently, each RDS DB instance can have only one Aurora read replica.</p>
        /// </note>
        pub fn read_replica_db_cluster_identifiers(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.read_replica_db_cluster_identifiers.unwrap_or_default();
            v.push(input.into());
            self.read_replica_db_cluster_identifiers = Some(v);
            self
        }
        /// <p>Contains one or more identifiers of Aurora DB clusters to which the RDS DB instance is replicated as a read replica. For example, when you create an Aurora read replica of an RDS for MySQL DB instance, the Aurora MySQL DB cluster for the Aurora read replica is shown. This output doesn't contain information about cross-Region Aurora read replicas.</p> <note>
        /// <p>Currently, each RDS DB instance can have only one Aurora read replica.</p>
        /// </note>
        pub fn set_read_replica_db_cluster_identifiers(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.read_replica_db_cluster_identifiers = input;
            self
        }
        /// <p>The open mode of an Oracle read replica. The default is <code>open-read-only</code>. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/oracle-read-replicas.html">Working with Oracle Read Replicas for Amazon RDS</a> in the <i>Amazon RDS User Guide</i>.</p> <note>
        /// <p>This attribute is only supported in RDS for Oracle.</p>
        /// </note>
        pub fn replica_mode(mut self, input: crate::model::ReplicaMode) -> Self {
            self.replica_mode = Some(input);
            self
        }
        /// <p>The open mode of an Oracle read replica. The default is <code>open-read-only</code>. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/oracle-read-replicas.html">Working with Oracle Read Replicas for Amazon RDS</a> in the <i>Amazon RDS User Guide</i>.</p> <note>
        /// <p>This attribute is only supported in RDS for Oracle.</p>
        /// </note>
        pub fn set_replica_mode(
            mut self,
            input: std::option::Option<crate::model::ReplicaMode>,
        ) -> Self {
            self.replica_mode = input;
            self
        }
        /// <p>License model information for this DB instance. This setting doesn't apply to RDS Custom.</p>
        pub fn license_model(mut self, input: impl Into<std::string::String>) -> Self {
            self.license_model = Some(input.into());
            self
        }
        /// <p>License model information for this DB instance. This setting doesn't apply to RDS Custom.</p>
        pub fn set_license_model(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.license_model = input;
            self
        }
        /// <p>Specifies the Provisioned IOPS (I/O operations per second) value.</p>
        pub fn iops(mut self, input: i32) -> Self {
            self.iops = Some(input);
            self
        }
        /// <p>Specifies the Provisioned IOPS (I/O operations per second) value.</p>
        pub fn set_iops(mut self, input: std::option::Option<i32>) -> Self {
            self.iops = input;
            self
        }
        /// Appends an item to `option_group_memberships`.
        ///
        /// To override the contents of this collection use [`set_option_group_memberships`](Self::set_option_group_memberships).
        ///
        /// <p>Provides the list of option group memberships for this DB instance.</p>
        pub fn option_group_memberships(
            mut self,
            input: crate::model::OptionGroupMembership,
        ) -> Self {
            let mut v = self.option_group_memberships.unwrap_or_default();
            v.push(input);
            self.option_group_memberships = Some(v);
            self
        }
        /// <p>Provides the list of option group memberships for this DB instance.</p>
        pub fn set_option_group_memberships(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OptionGroupMembership>>,
        ) -> Self {
            self.option_group_memberships = input;
            self
        }
        /// <p>If present, specifies the name of the character set that this instance is associated with.</p>
        pub fn character_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.character_set_name = Some(input.into());
            self
        }
        /// <p>If present, specifies the name of the character set that this instance is associated with.</p>
        pub fn set_character_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.character_set_name = input;
            self
        }
        /// <p>The name of the NCHAR character set for the Oracle DB instance. This character set specifies the Unicode encoding for data stored in table columns of type NCHAR, NCLOB, or NVARCHAR2. </p>
        pub fn nchar_character_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.nchar_character_set_name = Some(input.into());
            self
        }
        /// <p>The name of the NCHAR character set for the Oracle DB instance. This character set specifies the Unicode encoding for data stored in table columns of type NCHAR, NCLOB, or NVARCHAR2. </p>
        pub fn set_nchar_character_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.nchar_character_set_name = input;
            self
        }
        /// <p>If present, specifies the name of the secondary Availability Zone for a DB instance with multi-AZ support.</p>
        pub fn secondary_availability_zone(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.secondary_availability_zone = Some(input.into());
            self
        }
        /// <p>If present, specifies the name of the secondary Availability Zone for a DB instance with multi-AZ support.</p>
        pub fn set_secondary_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.secondary_availability_zone = input;
            self
        }
        /// <p>Specifies the accessibility options for the DB instance.</p>
        /// <p>When the DB cluster is publicly accessible, its Domain Name System (DNS) endpoint resolves to the private IP address from within the DB cluster's virtual private cloud (VPC). It resolves to the public IP address from outside of the DB cluster's VPC. Access to the DB cluster is ultimately controlled by the security group it uses. That public access isn't permitted if the security group assigned to the DB cluster doesn't permit it.</p>
        /// <p>When the DB instance isn't publicly accessible, it is an internal DB instance with a DNS name that resolves to a private IP address.</p>
        /// <p>For more information, see <code>CreateDBInstance</code>.</p>
        pub fn publicly_accessible(mut self, input: bool) -> Self {
            self.publicly_accessible = Some(input);
            self
        }
        /// <p>Specifies the accessibility options for the DB instance.</p>
        /// <p>When the DB cluster is publicly accessible, its Domain Name System (DNS) endpoint resolves to the private IP address from within the DB cluster's virtual private cloud (VPC). It resolves to the public IP address from outside of the DB cluster's VPC. Access to the DB cluster is ultimately controlled by the security group it uses. That public access isn't permitted if the security group assigned to the DB cluster doesn't permit it.</p>
        /// <p>When the DB instance isn't publicly accessible, it is an internal DB instance with a DNS name that resolves to a private IP address.</p>
        /// <p>For more information, see <code>CreateDBInstance</code>.</p>
        pub fn set_publicly_accessible(mut self, input: std::option::Option<bool>) -> Self {
            self.publicly_accessible = input;
            self
        }
        /// Appends an item to `status_infos`.
        ///
        /// To override the contents of this collection use [`set_status_infos`](Self::set_status_infos).
        ///
        /// <p>The status of a read replica. If the instance isn't a read replica, this is blank.</p>
        pub fn status_infos(mut self, input: crate::model::DbInstanceStatusInfo) -> Self {
            let mut v = self.status_infos.unwrap_or_default();
            v.push(input);
            self.status_infos = Some(v);
            self
        }
        /// <p>The status of a read replica. If the instance isn't a read replica, this is blank.</p>
        pub fn set_status_infos(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DbInstanceStatusInfo>>,
        ) -> Self {
            self.status_infos = input;
            self
        }
        /// <p>Specifies the storage type associated with DB instance.</p>
        pub fn storage_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.storage_type = Some(input.into());
            self
        }
        /// <p>Specifies the storage type associated with DB instance.</p>
        pub fn set_storage_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.storage_type = input;
            self
        }
        /// <p>The ARN from the key store with which the instance is associated for TDE encryption.</p>
        pub fn tde_credential_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.tde_credential_arn = Some(input.into());
            self
        }
        /// <p>The ARN from the key store with which the instance is associated for TDE encryption.</p>
        pub fn set_tde_credential_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.tde_credential_arn = input;
            self
        }
        /// <p>Specifies the port that the DB instance listens on. If the DB instance is part of a DB cluster, this can be a different port than the DB cluster port.</p>
        pub fn db_instance_port(mut self, input: i32) -> Self {
            self.db_instance_port = Some(input);
            self
        }
        /// <p>Specifies the port that the DB instance listens on. If the DB instance is part of a DB cluster, this can be a different port than the DB cluster port.</p>
        pub fn set_db_instance_port(mut self, input: std::option::Option<i32>) -> Self {
            self.db_instance_port = input;
            self
        }
        /// <p>If the DB instance is a member of a DB cluster, contains the name of the DB cluster that the DB instance is a member of.</p>
        pub fn db_cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_cluster_identifier = Some(input.into());
            self
        }
        /// <p>If the DB instance is a member of a DB cluster, contains the name of the DB cluster that the DB instance is a member of.</p>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_identifier = input;
            self
        }
        /// <p>Specifies whether the DB instance is encrypted.</p>
        pub fn storage_encrypted(mut self, input: bool) -> Self {
            self.storage_encrypted = Some(input);
            self
        }
        /// <p>Specifies whether the DB instance is encrypted.</p>
        pub fn set_storage_encrypted(mut self, input: std::option::Option<bool>) -> Self {
            self.storage_encrypted = input;
            self
        }
        /// <p> If <code>StorageEncrypted</code> is true, the Amazon Web Services KMS key identifier for the encrypted DB instance. </p>
        /// <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p> If <code>StorageEncrypted</code> is true, the Amazon Web Services KMS key identifier for the encrypted DB instance. </p>
        /// <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// <p>The Amazon Web Services Region-unique, immutable identifier for the DB instance. This identifier is found in Amazon Web Services CloudTrail log entries whenever the Amazon Web Services KMS key for the DB instance is accessed.</p>
        pub fn dbi_resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.dbi_resource_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services Region-unique, immutable identifier for the DB instance. This identifier is found in Amazon Web Services CloudTrail log entries whenever the Amazon Web Services KMS key for the DB instance is accessed.</p>
        pub fn set_dbi_resource_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dbi_resource_id = input;
            self
        }
        /// <p>The identifier of the CA certificate for this DB instance.</p>
        pub fn ca_certificate_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.ca_certificate_identifier = Some(input.into());
            self
        }
        /// <p>The identifier of the CA certificate for this DB instance.</p>
        pub fn set_ca_certificate_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ca_certificate_identifier = input;
            self
        }
        /// Appends an item to `domain_memberships`.
        ///
        /// To override the contents of this collection use [`set_domain_memberships`](Self::set_domain_memberships).
        ///
        /// <p>The Active Directory Domain membership records associated with the DB instance.</p>
        pub fn domain_memberships(mut self, input: crate::model::DomainMembership) -> Self {
            let mut v = self.domain_memberships.unwrap_or_default();
            v.push(input);
            self.domain_memberships = Some(v);
            self
        }
        /// <p>The Active Directory Domain membership records associated with the DB instance.</p>
        pub fn set_domain_memberships(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DomainMembership>>,
        ) -> Self {
            self.domain_memberships = input;
            self
        }
        /// <p>Specifies whether tags are copied from the DB instance to snapshots of the DB instance.</p>
        /// <p> <b>Amazon Aurora</b> </p>
        /// <p>Not applicable. Copying tags to snapshots is managed by the DB cluster. Setting this value for an Aurora DB instance has no effect on the DB cluster setting. For more information, see <code>DBCluster</code>.</p>
        pub fn copy_tags_to_snapshot(mut self, input: bool) -> Self {
            self.copy_tags_to_snapshot = Some(input);
            self
        }
        /// <p>Specifies whether tags are copied from the DB instance to snapshots of the DB instance.</p>
        /// <p> <b>Amazon Aurora</b> </p>
        /// <p>Not applicable. Copying tags to snapshots is managed by the DB cluster. Setting this value for an Aurora DB instance has no effect on the DB cluster setting. For more information, see <code>DBCluster</code>.</p>
        pub fn set_copy_tags_to_snapshot(mut self, input: std::option::Option<bool>) -> Self {
            self.copy_tags_to_snapshot = input;
            self
        }
        /// <p>The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB instance.</p>
        pub fn monitoring_interval(mut self, input: i32) -> Self {
            self.monitoring_interval = Some(input);
            self
        }
        /// <p>The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB instance.</p>
        pub fn set_monitoring_interval(mut self, input: std::option::Option<i32>) -> Self {
            self.monitoring_interval = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon CloudWatch Logs log stream that receives the Enhanced Monitoring metrics data for the DB instance.</p>
        pub fn enhanced_monitoring_resource_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.enhanced_monitoring_resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Amazon CloudWatch Logs log stream that receives the Enhanced Monitoring metrics data for the DB instance.</p>
        pub fn set_enhanced_monitoring_resource_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.enhanced_monitoring_resource_arn = input;
            self
        }
        /// <p>The ARN for the IAM role that permits RDS to send Enhanced Monitoring metrics to Amazon CloudWatch Logs.</p>
        pub fn monitoring_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.monitoring_role_arn = Some(input.into());
            self
        }
        /// <p>The ARN for the IAM role that permits RDS to send Enhanced Monitoring metrics to Amazon CloudWatch Logs.</p>
        pub fn set_monitoring_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.monitoring_role_arn = input;
            self
        }
        /// <p>A value that specifies the order in which an Aurora Replica is promoted to the primary instance after a failure of the existing primary instance. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.FaultTolerance"> Fault Tolerance for an Aurora DB Cluster</a> in the <i>Amazon Aurora User Guide</i>. </p>
        pub fn promotion_tier(mut self, input: i32) -> Self {
            self.promotion_tier = Some(input);
            self
        }
        /// <p>A value that specifies the order in which an Aurora Replica is promoted to the primary instance after a failure of the existing primary instance. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.FaultTolerance"> Fault Tolerance for an Aurora DB Cluster</a> in the <i>Amazon Aurora User Guide</i>. </p>
        pub fn set_promotion_tier(mut self, input: std::option::Option<i32>) -> Self {
            self.promotion_tier = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the DB instance.</p>
        pub fn db_instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_instance_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the DB instance.</p>
        pub fn set_db_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_instance_arn = input;
            self
        }
        /// <p>The time zone of the DB instance. In most cases, the <code>Timezone</code> element is empty. <code>Timezone</code> content appears only for Microsoft SQL Server DB instances that were created with a time zone specified. </p>
        pub fn timezone(mut self, input: impl Into<std::string::String>) -> Self {
            self.timezone = Some(input.into());
            self
        }
        /// <p>The time zone of the DB instance. In most cases, the <code>Timezone</code> element is empty. <code>Timezone</code> content appears only for Microsoft SQL Server DB instances that were created with a time zone specified. </p>
        pub fn set_timezone(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.timezone = input;
            self
        }
        /// <p>True if mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts is enabled, and otherwise false.</p>
        /// <p>IAM database authentication can be enabled for the following database engines</p>
        /// <ul>
        /// <li> <p>For MySQL 5.6, minor version 5.6.34 or higher</p> </li>
        /// <li> <p>For MySQL 5.7, minor version 5.7.16 or higher</p> </li>
        /// <li> <p>Aurora 5.6 or higher. To enable IAM database authentication for Aurora, see DBCluster Type.</p> </li>
        /// </ul>
        pub fn iam_database_authentication_enabled(mut self, input: bool) -> Self {
            self.iam_database_authentication_enabled = Some(input);
            self
        }
        /// <p>True if mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts is enabled, and otherwise false.</p>
        /// <p>IAM database authentication can be enabled for the following database engines</p>
        /// <ul>
        /// <li> <p>For MySQL 5.6, minor version 5.6.34 or higher</p> </li>
        /// <li> <p>For MySQL 5.7, minor version 5.7.16 or higher</p> </li>
        /// <li> <p>Aurora 5.6 or higher. To enable IAM database authentication for Aurora, see DBCluster Type.</p> </li>
        /// </ul>
        pub fn set_iam_database_authentication_enabled(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.iam_database_authentication_enabled = input;
            self
        }
        /// <p>True if Performance Insights is enabled for the DB instance, and otherwise false.</p>
        pub fn performance_insights_enabled(mut self, input: bool) -> Self {
            self.performance_insights_enabled = Some(input);
            self
        }
        /// <p>True if Performance Insights is enabled for the DB instance, and otherwise false.</p>
        pub fn set_performance_insights_enabled(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.performance_insights_enabled = input;
            self
        }
        /// <p>The Amazon Web Services KMS key identifier for encryption of Performance Insights data.</p>
        /// <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.</p>
        pub fn performance_insights_kms_key_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.performance_insights_kms_key_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services KMS key identifier for encryption of Performance Insights data.</p>
        /// <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.</p>
        pub fn set_performance_insights_kms_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.performance_insights_kms_key_id = input;
            self
        }
        /// <p>The amount of time, in days, to retain Performance Insights data. Valid values are 7 or 731 (2 years). </p>
        pub fn performance_insights_retention_period(mut self, input: i32) -> Self {
            self.performance_insights_retention_period = Some(input);
            self
        }
        /// <p>The amount of time, in days, to retain Performance Insights data. Valid values are 7 or 731 (2 years). </p>
        pub fn set_performance_insights_retention_period(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.performance_insights_retention_period = input;
            self
        }
        /// Appends an item to `enabled_cloudwatch_logs_exports`.
        ///
        /// To override the contents of this collection use [`set_enabled_cloudwatch_logs_exports`](Self::set_enabled_cloudwatch_logs_exports).
        ///
        /// <p>A list of log types that this DB instance is configured to export to CloudWatch Logs.</p>
        /// <p>Log types vary by DB engine. For information about the log types for each DB engine, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html">Amazon RDS Database Log Files</a> in the <i>Amazon RDS User Guide.</i> </p>
        pub fn enabled_cloudwatch_logs_exports(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.enabled_cloudwatch_logs_exports.unwrap_or_default();
            v.push(input.into());
            self.enabled_cloudwatch_logs_exports = Some(v);
            self
        }
        /// <p>A list of log types that this DB instance is configured to export to CloudWatch Logs.</p>
        /// <p>Log types vary by DB engine. For information about the log types for each DB engine, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html">Amazon RDS Database Log Files</a> in the <i>Amazon RDS User Guide.</i> </p>
        pub fn set_enabled_cloudwatch_logs_exports(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.enabled_cloudwatch_logs_exports = input;
            self
        }
        /// Appends an item to `processor_features`.
        ///
        /// To override the contents of this collection use [`set_processor_features`](Self::set_processor_features).
        ///
        /// <p>The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.</p>
        pub fn processor_features(mut self, input: crate::model::ProcessorFeature) -> Self {
            let mut v = self.processor_features.unwrap_or_default();
            v.push(input);
            self.processor_features = Some(v);
            self
        }
        /// <p>The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.</p>
        pub fn set_processor_features(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ProcessorFeature>>,
        ) -> Self {
            self.processor_features = input;
            self
        }
        /// <p>Indicates if the DB instance has deletion protection enabled. The database can't be deleted when deletion protection is enabled. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html"> Deleting a DB Instance</a>. </p>
        pub fn deletion_protection(mut self, input: bool) -> Self {
            self.deletion_protection = Some(input);
            self
        }
        /// <p>Indicates if the DB instance has deletion protection enabled. The database can't be deleted when deletion protection is enabled. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html"> Deleting a DB Instance</a>. </p>
        pub fn set_deletion_protection(mut self, input: std::option::Option<bool>) -> Self {
            self.deletion_protection = input;
            self
        }
        /// Appends an item to `associated_roles`.
        ///
        /// To override the contents of this collection use [`set_associated_roles`](Self::set_associated_roles).
        ///
        /// <p> The Amazon Web Services Identity and Access Management (IAM) roles associated with the DB instance. </p>
        pub fn associated_roles(mut self, input: crate::model::DbInstanceRole) -> Self {
            let mut v = self.associated_roles.unwrap_or_default();
            v.push(input);
            self.associated_roles = Some(v);
            self
        }
        /// <p> The Amazon Web Services Identity and Access Management (IAM) roles associated with the DB instance. </p>
        pub fn set_associated_roles(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DbInstanceRole>>,
        ) -> Self {
            self.associated_roles = input;
            self
        }
        /// <p>Specifies the listener connection endpoint for SQL Server Always On.</p>
        pub fn listener_endpoint(mut self, input: crate::model::Endpoint) -> Self {
            self.listener_endpoint = Some(input);
            self
        }
        /// <p>Specifies the listener connection endpoint for SQL Server Always On.</p>
        pub fn set_listener_endpoint(
            mut self,
            input: std::option::Option<crate::model::Endpoint>,
        ) -> Self {
            self.listener_endpoint = input;
            self
        }
        /// <p>The upper limit in gibibytes (GiB) to which Amazon RDS can automatically scale the storage of the DB instance.</p>
        pub fn max_allocated_storage(mut self, input: i32) -> Self {
            self.max_allocated_storage = Some(input);
            self
        }
        /// <p>The upper limit in gibibytes (GiB) to which Amazon RDS can automatically scale the storage of the DB instance.</p>
        pub fn set_max_allocated_storage(mut self, input: std::option::Option<i32>) -> Self {
            self.max_allocated_storage = input;
            self
        }
        /// Appends an item to `tag_list`.
        ///
        /// To override the contents of this collection use [`set_tag_list`](Self::set_tag_list).
        ///
        /// <p>A list of tags. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources</a> in the <i>Amazon RDS User Guide.</i> </p>
        pub fn tag_list(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tag_list.unwrap_or_default();
            v.push(input);
            self.tag_list = Some(v);
            self
        }
        /// <p>A list of tags. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources</a> in the <i>Amazon RDS User Guide.</i> </p>
        pub fn set_tag_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tag_list = input;
            self
        }
        /// Appends an item to `db_instance_automated_backups_replications`.
        ///
        /// To override the contents of this collection use [`set_db_instance_automated_backups_replications`](Self::set_db_instance_automated_backups_replications).
        ///
        /// <p>The list of replicated automated backups associated with the DB instance.</p>
        pub fn db_instance_automated_backups_replications(
            mut self,
            input: crate::model::DbInstanceAutomatedBackupsReplication,
        ) -> Self {
            let mut v = self
                .db_instance_automated_backups_replications
                .unwrap_or_default();
            v.push(input);
            self.db_instance_automated_backups_replications = Some(v);
            self
        }
        /// <p>The list of replicated automated backups associated with the DB instance.</p>
        pub fn set_db_instance_automated_backups_replications(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::DbInstanceAutomatedBackupsReplication>,
            >,
        ) -> Self {
            self.db_instance_automated_backups_replications = input;
            self
        }
        /// <p>Specifies whether a customer-owned IP address (CoIP) is enabled for an RDS on Outposts DB instance.</p>
        /// <p>A <i>CoIP </i>provides local or external connectivity to resources in your Outpost subnets through your on-premises network. For some use cases, a CoIP can provide lower latency for connections to the DB instance from outside of its virtual private cloud (VPC) on your local network.</p>
        /// <p>For more information about RDS on Outposts, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html">Working with Amazon RDS on Amazon Web Services Outposts</a> in the <i>Amazon RDS User Guide</i>.</p>
        /// <p>For more information about CoIPs, see <a href="https://docs.aws.amazon.com/outposts/latest/userguide/outposts-networking-components.html#ip-addressing">Customer-owned IP addresses</a> in the <i>Amazon Web Services Outposts User Guide</i>.</p>
        pub fn customer_owned_ip_enabled(mut self, input: bool) -> Self {
            self.customer_owned_ip_enabled = Some(input);
            self
        }
        /// <p>Specifies whether a customer-owned IP address (CoIP) is enabled for an RDS on Outposts DB instance.</p>
        /// <p>A <i>CoIP </i>provides local or external connectivity to resources in your Outpost subnets through your on-premises network. For some use cases, a CoIP can provide lower latency for connections to the DB instance from outside of its virtual private cloud (VPC) on your local network.</p>
        /// <p>For more information about RDS on Outposts, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html">Working with Amazon RDS on Amazon Web Services Outposts</a> in the <i>Amazon RDS User Guide</i>.</p>
        /// <p>For more information about CoIPs, see <a href="https://docs.aws.amazon.com/outposts/latest/userguide/outposts-networking-components.html#ip-addressing">Customer-owned IP addresses</a> in the <i>Amazon Web Services Outposts User Guide</i>.</p>
        pub fn set_customer_owned_ip_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.customer_owned_ip_enabled = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the recovery point in Amazon Web Services Backup.</p>
        pub fn aws_backup_recovery_point_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.aws_backup_recovery_point_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the recovery point in Amazon Web Services Backup.</p>
        pub fn set_aws_backup_recovery_point_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.aws_backup_recovery_point_arn = input;
            self
        }
        /// <p>The status of the database activity stream.</p>
        pub fn activity_stream_status(mut self, input: crate::model::ActivityStreamStatus) -> Self {
            self.activity_stream_status = Some(input);
            self
        }
        /// <p>The status of the database activity stream.</p>
        pub fn set_activity_stream_status(
            mut self,
            input: std::option::Option<crate::model::ActivityStreamStatus>,
        ) -> Self {
            self.activity_stream_status = input;
            self
        }
        /// <p>The Amazon Web Services KMS key identifier used for encrypting messages in the database activity stream. The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.</p>
        pub fn activity_stream_kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.activity_stream_kms_key_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services KMS key identifier used for encrypting messages in the database activity stream. The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.</p>
        pub fn set_activity_stream_kms_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.activity_stream_kms_key_id = input;
            self
        }
        /// <p>The name of the Amazon Kinesis data stream used for the database activity stream.</p>
        pub fn activity_stream_kinesis_stream_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.activity_stream_kinesis_stream_name = Some(input.into());
            self
        }
        /// <p>The name of the Amazon Kinesis data stream used for the database activity stream.</p>
        pub fn set_activity_stream_kinesis_stream_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.activity_stream_kinesis_stream_name = input;
            self
        }
        /// <p>The mode of the database activity stream. Database events such as a change or access generate an activity stream event. RDS for Oracle always handles these events asynchronously.</p>
        pub fn activity_stream_mode(mut self, input: crate::model::ActivityStreamMode) -> Self {
            self.activity_stream_mode = Some(input);
            self
        }
        /// <p>The mode of the database activity stream. Database events such as a change or access generate an activity stream event. RDS for Oracle always handles these events asynchronously.</p>
        pub fn set_activity_stream_mode(
            mut self,
            input: std::option::Option<crate::model::ActivityStreamMode>,
        ) -> Self {
            self.activity_stream_mode = input;
            self
        }
        /// <p>Indicates whether engine-native audit fields are included in the database activity stream.</p>
        pub fn activity_stream_engine_native_audit_fields_included(mut self, input: bool) -> Self {
            self.activity_stream_engine_native_audit_fields_included = Some(input);
            self
        }
        /// <p>Indicates whether engine-native audit fields are included in the database activity stream.</p>
        pub fn set_activity_stream_engine_native_audit_fields_included(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.activity_stream_engine_native_audit_fields_included = input;
            self
        }
        /// <p>The automation mode of the RDS Custom DB instance: <code>full</code> or <code>all paused</code>. If <code>full</code>, the DB instance automates monitoring and instance recovery. If <code>all paused</code>, the instance pauses automation for the duration set by <code>--resume-full-automation-mode-minutes</code>.</p>
        pub fn automation_mode(mut self, input: crate::model::AutomationMode) -> Self {
            self.automation_mode = Some(input);
            self
        }
        /// <p>The automation mode of the RDS Custom DB instance: <code>full</code> or <code>all paused</code>. If <code>full</code>, the DB instance automates monitoring and instance recovery. If <code>all paused</code>, the instance pauses automation for the duration set by <code>--resume-full-automation-mode-minutes</code>.</p>
        pub fn set_automation_mode(
            mut self,
            input: std::option::Option<crate::model::AutomationMode>,
        ) -> Self {
            self.automation_mode = input;
            self
        }
        /// <p>The number of minutes to pause the automation. When the time period ends, RDS Custom resumes full automation. The minimum value is 60 (default). The maximum value is 1,440. </p>
        pub fn resume_full_automation_mode_time(
            mut self,
            input: aws_smithy_types::DateTime,
        ) -> Self {
            self.resume_full_automation_mode_time = Some(input);
            self
        }
        /// <p>The number of minutes to pause the automation. When the time period ends, RDS Custom resumes full automation. The minimum value is 60 (default). The maximum value is 1,440. </p>
        pub fn set_resume_full_automation_mode_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.resume_full_automation_mode_time = input;
            self
        }
        /// <p>The instance profile associated with the underlying Amazon EC2 instance of an RDS Custom DB instance. The instance profile must meet the following requirements:</p>
        /// <ul>
        /// <li> <p>The profile must exist in your account.</p> </li>
        /// <li> <p>The profile must have an IAM role that Amazon EC2 has permissions to assume.</p> </li>
        /// <li> <p>The instance profile name and the associated IAM role name must start with the prefix <code>AWSRDSCustom</code>.</p> </li>
        /// </ul>
        /// <p>For the list of permissions required for the IAM role, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-setup-orcl.html#custom-setup-orcl.iam-vpc"> Configure IAM and your VPC</a> in the <i>Amazon Relational Database Service User Guide</i>.</p>
        pub fn custom_iam_instance_profile(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.custom_iam_instance_profile = Some(input.into());
            self
        }
        /// <p>The instance profile associated with the underlying Amazon EC2 instance of an RDS Custom DB instance. The instance profile must meet the following requirements:</p>
        /// <ul>
        /// <li> <p>The profile must exist in your account.</p> </li>
        /// <li> <p>The profile must have an IAM role that Amazon EC2 has permissions to assume.</p> </li>
        /// <li> <p>The instance profile name and the associated IAM role name must start with the prefix <code>AWSRDSCustom</code>.</p> </li>
        /// </ul>
        /// <p>For the list of permissions required for the IAM role, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-setup-orcl.html#custom-setup-orcl.iam-vpc"> Configure IAM and your VPC</a> in the <i>Amazon Relational Database Service User Guide</i>.</p>
        pub fn set_custom_iam_instance_profile(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.custom_iam_instance_profile = input;
            self
        }
        /// <p>Specifies where automated backups and manual snapshots are stored: Amazon Web Services Outposts or the Amazon Web Services Region.</p>
        pub fn backup_target(mut self, input: impl Into<std::string::String>) -> Self {
            self.backup_target = Some(input.into());
            self
        }
        /// <p>Specifies where automated backups and manual snapshots are stored: Amazon Web Services Outposts or the Amazon Web Services Region.</p>
        pub fn set_backup_target(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backup_target = input;
            self
        }
        /// Consumes the builder and constructs a [`DbInstance`](crate::model::DbInstance)
        pub fn build(self) -> crate::model::DbInstance {
            crate::model::DbInstance {
                db_instance_identifier: self.db_instance_identifier,
                db_instance_class: self.db_instance_class,
                engine: self.engine,
                db_instance_status: self.db_instance_status,
                automatic_restart_time: self.automatic_restart_time,
                master_username: self.master_username,
                db_name: self.db_name,
                endpoint: self.endpoint,
                allocated_storage: self.allocated_storage.unwrap_or_default(),
                instance_create_time: self.instance_create_time,
                preferred_backup_window: self.preferred_backup_window,
                backup_retention_period: self.backup_retention_period.unwrap_or_default(),
                db_security_groups: self.db_security_groups,
                vpc_security_groups: self.vpc_security_groups,
                db_parameter_groups: self.db_parameter_groups,
                availability_zone: self.availability_zone,
                db_subnet_group: self.db_subnet_group,
                preferred_maintenance_window: self.preferred_maintenance_window,
                pending_modified_values: self.pending_modified_values,
                latest_restorable_time: self.latest_restorable_time,
                multi_az: self.multi_az.unwrap_or_default(),
                engine_version: self.engine_version,
                auto_minor_version_upgrade: self.auto_minor_version_upgrade.unwrap_or_default(),
                read_replica_source_db_instance_identifier: self
                    .read_replica_source_db_instance_identifier,
                read_replica_db_instance_identifiers: self.read_replica_db_instance_identifiers,
                read_replica_db_cluster_identifiers: self.read_replica_db_cluster_identifiers,
                replica_mode: self.replica_mode,
                license_model: self.license_model,
                iops: self.iops,
                option_group_memberships: self.option_group_memberships,
                character_set_name: self.character_set_name,
                nchar_character_set_name: self.nchar_character_set_name,
                secondary_availability_zone: self.secondary_availability_zone,
                publicly_accessible: self.publicly_accessible.unwrap_or_default(),
                status_infos: self.status_infos,
                storage_type: self.storage_type,
                tde_credential_arn: self.tde_credential_arn,
                db_instance_port: self.db_instance_port.unwrap_or_default(),
                db_cluster_identifier: self.db_cluster_identifier,
                storage_encrypted: self.storage_encrypted.unwrap_or_default(),
                kms_key_id: self.kms_key_id,
                dbi_resource_id: self.dbi_resource_id,
                ca_certificate_identifier: self.ca_certificate_identifier,
                domain_memberships: self.domain_memberships,
                copy_tags_to_snapshot: self.copy_tags_to_snapshot.unwrap_or_default(),
                monitoring_interval: self.monitoring_interval,
                enhanced_monitoring_resource_arn: self.enhanced_monitoring_resource_arn,
                monitoring_role_arn: self.monitoring_role_arn,
                promotion_tier: self.promotion_tier,
                db_instance_arn: self.db_instance_arn,
                timezone: self.timezone,
                iam_database_authentication_enabled: self
                    .iam_database_authentication_enabled
                    .unwrap_or_default(),
                performance_insights_enabled: self.performance_insights_enabled,
                performance_insights_kms_key_id: self.performance_insights_kms_key_id,
                performance_insights_retention_period: self.performance_insights_retention_period,
                enabled_cloudwatch_logs_exports: self.enabled_cloudwatch_logs_exports,
                processor_features: self.processor_features,
                deletion_protection: self.deletion_protection.unwrap_or_default(),
                associated_roles: self.associated_roles,
                listener_endpoint: self.listener_endpoint,
                max_allocated_storage: self.max_allocated_storage,
                tag_list: self.tag_list,
                db_instance_automated_backups_replications: self
                    .db_instance_automated_backups_replications,
                customer_owned_ip_enabled: self.customer_owned_ip_enabled,
                aws_backup_recovery_point_arn: self.aws_backup_recovery_point_arn,
                activity_stream_status: self.activity_stream_status,
                activity_stream_kms_key_id: self.activity_stream_kms_key_id,
                activity_stream_kinesis_stream_name: self.activity_stream_kinesis_stream_name,
                activity_stream_mode: self.activity_stream_mode,
                activity_stream_engine_native_audit_fields_included: self
                    .activity_stream_engine_native_audit_fields_included,
                automation_mode: self.automation_mode,
                resume_full_automation_mode_time: self.resume_full_automation_mode_time,
                custom_iam_instance_profile: self.custom_iam_instance_profile,
                backup_target: self.backup_target,
            }
        }
    }
}
impl DbInstance {
    /// Creates a new builder-style object to manufacture [`DbInstance`](crate::model::DbInstance)
    pub fn builder() -> crate::model::db_instance::Builder {
        crate::model::db_instance::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AutomationMode {
    #[allow(missing_docs)] // documentation missing in model
    AllPaused,
    #[allow(missing_docs)] // documentation missing in model
    Full,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AutomationMode {
    fn from(s: &str) -> Self {
        match s {
            "all-paused" => AutomationMode::AllPaused,
            "full" => AutomationMode::Full,
            other => AutomationMode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AutomationMode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AutomationMode::from(s))
    }
}
impl AutomationMode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AutomationMode::AllPaused => "all-paused",
            AutomationMode::Full => "full",
            AutomationMode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["all-paused", "full"]
    }
}
impl AsRef<str> for AutomationMode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ActivityStreamMode {
    #[allow(missing_docs)] // documentation missing in model
    Async,
    #[allow(missing_docs)] // documentation missing in model
    Sync,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ActivityStreamMode {
    fn from(s: &str) -> Self {
        match s {
            "async" => ActivityStreamMode::Async,
            "sync" => ActivityStreamMode::Sync,
            other => ActivityStreamMode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ActivityStreamMode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ActivityStreamMode::from(s))
    }
}
impl ActivityStreamMode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ActivityStreamMode::Async => "async",
            ActivityStreamMode::Sync => "sync",
            ActivityStreamMode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["async", "sync"]
    }
}
impl AsRef<str> for ActivityStreamMode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ActivityStreamStatus {
    #[allow(missing_docs)] // documentation missing in model
    Started,
    #[allow(missing_docs)] // documentation missing in model
    Starting,
    #[allow(missing_docs)] // documentation missing in model
    Stopped,
    #[allow(missing_docs)] // documentation missing in model
    Stopping,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ActivityStreamStatus {
    fn from(s: &str) -> Self {
        match s {
            "started" => ActivityStreamStatus::Started,
            "starting" => ActivityStreamStatus::Starting,
            "stopped" => ActivityStreamStatus::Stopped,
            "stopping" => ActivityStreamStatus::Stopping,
            other => ActivityStreamStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ActivityStreamStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ActivityStreamStatus::from(s))
    }
}
impl ActivityStreamStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ActivityStreamStatus::Started => "started",
            ActivityStreamStatus::Starting => "starting",
            ActivityStreamStatus::Stopped => "stopped",
            ActivityStreamStatus::Stopping => "stopping",
            ActivityStreamStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["started", "starting", "stopped", "stopping"]
    }
}
impl AsRef<str> for ActivityStreamStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Metadata assigned to an Amazon RDS resource consisting of a key-value pair.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Tag {
    /// <p>A key is the required name of the tag. The string value can be from 1 to 128 Unicode characters in length and can't be prefixed with <code>aws:</code> or <code>rds:</code>. The string can only contain only the set of Unicode letters, digits, white-space, '_', '.', ':', '/', '=', '+', '-', '@' (Java regex: "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-@]*)$").</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>A value is the optional value of the tag. The string value can be from 1 to 256 Unicode characters in length and can't be prefixed with <code>aws:</code> or <code>rds:</code>. The string can only contain only the set of Unicode letters, digits, white-space, '_', '.', ':', '/', '=', '+', '-', '@' (Java regex: "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-@]*)$").</p>
    pub value: std::option::Option<std::string::String>,
}
impl Tag {
    /// <p>A key is the required name of the tag. The string value can be from 1 to 128 Unicode characters in length and can't be prefixed with <code>aws:</code> or <code>rds:</code>. The string can only contain only the set of Unicode letters, digits, white-space, '_', '.', ':', '/', '=', '+', '-', '@' (Java regex: "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-@]*)$").</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>A value is the optional value of the tag. The string value can be from 1 to 256 Unicode characters in length and can't be prefixed with <code>aws:</code> or <code>rds:</code>. The string can only contain only the set of Unicode letters, digits, white-space, '_', '.', ':', '/', '=', '+', '-', '@' (Java regex: "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-@]*)$").</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for Tag {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Tag");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`Tag`](crate::model::Tag)
pub mod tag {
    /// A builder for [`Tag`](crate::model::Tag)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A key is the required name of the tag. The string value can be from 1 to 128 Unicode characters in length and can't be prefixed with <code>aws:</code> or <code>rds:</code>. The string can only contain only the set of Unicode letters, digits, white-space, '_', '.', ':', '/', '=', '+', '-', '@' (Java regex: "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-@]*)$").</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>A key is the required name of the tag. The string value can be from 1 to 128 Unicode characters in length and can't be prefixed with <code>aws:</code> or <code>rds:</code>. The string can only contain only the set of Unicode letters, digits, white-space, '_', '.', ':', '/', '=', '+', '-', '@' (Java regex: "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-@]*)$").</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>A value is the optional value of the tag. The string value can be from 1 to 256 Unicode characters in length and can't be prefixed with <code>aws:</code> or <code>rds:</code>. The string can only contain only the set of Unicode letters, digits, white-space, '_', '.', ':', '/', '=', '+', '-', '@' (Java regex: "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-@]*)$").</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>A value is the optional value of the tag. The string value can be from 1 to 256 Unicode characters in length and can't be prefixed with <code>aws:</code> or <code>rds:</code>. The string can only contain only the set of Unicode letters, digits, white-space, '_', '.', ':', '/', '=', '+', '-', '@' (Java regex: "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-@]*)$").</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`Tag`](crate::model::Tag)
        pub fn build(self) -> crate::model::Tag {
            crate::model::Tag {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl Tag {
    /// Creates a new builder-style object to manufacture [`Tag`](crate::model::Tag)
    pub fn builder() -> crate::model::tag::Builder {
        crate::model::tag::Builder::default()
    }
}

/// <p>This data type represents the information you need to connect to an Amazon RDS DB instance. This data type is used as a response element in the following actions:</p>
/// <ul>
/// <li> <p> <code>CreateDBInstance</code> </p> </li>
/// <li> <p> <code>DescribeDBInstances</code> </p> </li>
/// <li> <p> <code>DeleteDBInstance</code> </p> </li>
/// </ul>
/// <p>For the data structure that represents Amazon Aurora DB cluster endpoints, see <code>DBClusterEndpoint</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Endpoint {
    /// <p>Specifies the DNS address of the DB instance.</p>
    pub address: std::option::Option<std::string::String>,
    /// <p>Specifies the port that the database engine is listening on.</p>
    pub port: i32,
    /// <p>Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.</p>
    pub hosted_zone_id: std::option::Option<std::string::String>,
}
impl Endpoint {
    /// <p>Specifies the DNS address of the DB instance.</p>
    pub fn address(&self) -> std::option::Option<&str> {
        self.address.as_deref()
    }
    /// <p>Specifies the port that the database engine is listening on.</p>
    pub fn port(&self) -> i32 {
        self.port
    }
    /// <p>Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.</p>
    pub fn hosted_zone_id(&self) -> std::option::Option<&str> {
        self.hosted_zone_id.as_deref()
    }
}
impl std::fmt::Debug for Endpoint {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Endpoint");
        formatter.field("address", &self.address);
        formatter.field("port", &self.port);
        formatter.field("hosted_zone_id", &self.hosted_zone_id);
        formatter.finish()
    }
}
/// See [`Endpoint`](crate::model::Endpoint)
pub mod endpoint {
    /// A builder for [`Endpoint`](crate::model::Endpoint)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) address: std::option::Option<std::string::String>,
        pub(crate) port: std::option::Option<i32>,
        pub(crate) hosted_zone_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies the DNS address of the DB instance.</p>
        pub fn address(mut self, input: impl Into<std::string::String>) -> Self {
            self.address = Some(input.into());
            self
        }
        /// <p>Specifies the DNS address of the DB instance.</p>
        pub fn set_address(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.address = input;
            self
        }
        /// <p>Specifies the port that the database engine is listening on.</p>
        pub fn port(mut self, input: i32) -> Self {
            self.port = Some(input);
            self
        }
        /// <p>Specifies the port that the database engine is listening on.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.port = input;
            self
        }
        /// <p>Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.</p>
        pub fn hosted_zone_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.hosted_zone_id = Some(input.into());
            self
        }
        /// <p>Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.</p>
        pub fn set_hosted_zone_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.hosted_zone_id = input;
            self
        }
        /// Consumes the builder and constructs a [`Endpoint`](crate::model::Endpoint)
        pub fn build(self) -> crate::model::Endpoint {
            crate::model::Endpoint {
                address: self.address,
                port: self.port.unwrap_or_default(),
                hosted_zone_id: self.hosted_zone_id,
            }
        }
    }
}
impl Endpoint {
    /// Creates a new builder-style object to manufacture [`Endpoint`](crate::model::Endpoint)
    pub fn builder() -> crate::model::endpoint::Builder {
        crate::model::endpoint::Builder::default()
    }
}

/// <p>Describes an Amazon Web Services Identity and Access Management (IAM) role that is associated with a DB instance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DbInstanceRole {
    /// <p>The Amazon Resource Name (ARN) of the IAM role that is associated with the DB instance.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The name of the feature associated with the Amazon Web Services Identity and Access Management (IAM) role. For information about supported feature names, see <code>DBEngineVersion</code>. </p>
    pub feature_name: std::option::Option<std::string::String>,
    /// <p>Describes the state of association between the IAM role and the DB instance. The Status property returns one of the following values:</p>
    /// <ul>
    /// <li> <p> <code>ACTIVE</code> - the IAM role ARN is associated with the DB instance and can be used to access other Amazon Web Services services on your behalf.</p> </li>
    /// <li> <p> <code>PENDING</code> - the IAM role ARN is being associated with the DB instance.</p> </li>
    /// <li> <p> <code>INVALID</code> - the IAM role ARN is associated with the DB instance, but the DB instance is unable to assume the IAM role in order to access other Amazon Web Services services on your behalf.</p> </li>
    /// </ul>
    pub status: std::option::Option<std::string::String>,
}
impl DbInstanceRole {
    /// <p>The Amazon Resource Name (ARN) of the IAM role that is associated with the DB instance.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>The name of the feature associated with the Amazon Web Services Identity and Access Management (IAM) role. For information about supported feature names, see <code>DBEngineVersion</code>. </p>
    pub fn feature_name(&self) -> std::option::Option<&str> {
        self.feature_name.as_deref()
    }
    /// <p>Describes the state of association between the IAM role and the DB instance. The Status property returns one of the following values:</p>
    /// <ul>
    /// <li> <p> <code>ACTIVE</code> - the IAM role ARN is associated with the DB instance and can be used to access other Amazon Web Services services on your behalf.</p> </li>
    /// <li> <p> <code>PENDING</code> - the IAM role ARN is being associated with the DB instance.</p> </li>
    /// <li> <p> <code>INVALID</code> - the IAM role ARN is associated with the DB instance, but the DB instance is unable to assume the IAM role in order to access other Amazon Web Services services on your behalf.</p> </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
}
impl std::fmt::Debug for DbInstanceRole {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DbInstanceRole");
        formatter.field("role_arn", &self.role_arn);
        formatter.field("feature_name", &self.feature_name);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`DbInstanceRole`](crate::model::DbInstanceRole)
pub mod db_instance_role {
    /// A builder for [`DbInstanceRole`](crate::model::DbInstanceRole)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) feature_name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the IAM role that is associated with the DB instance.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role that is associated with the DB instance.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The name of the feature associated with the Amazon Web Services Identity and Access Management (IAM) role. For information about supported feature names, see <code>DBEngineVersion</code>. </p>
        pub fn feature_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.feature_name = Some(input.into());
            self
        }
        /// <p>The name of the feature associated with the Amazon Web Services Identity and Access Management (IAM) role. For information about supported feature names, see <code>DBEngineVersion</code>. </p>
        pub fn set_feature_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.feature_name = input;
            self
        }
        /// <p>Describes the state of association between the IAM role and the DB instance. The Status property returns one of the following values:</p>
        /// <ul>
        /// <li> <p> <code>ACTIVE</code> - the IAM role ARN is associated with the DB instance and can be used to access other Amazon Web Services services on your behalf.</p> </li>
        /// <li> <p> <code>PENDING</code> - the IAM role ARN is being associated with the DB instance.</p> </li>
        /// <li> <p> <code>INVALID</code> - the IAM role ARN is associated with the DB instance, but the DB instance is unable to assume the IAM role in order to access other Amazon Web Services services on your behalf.</p> </li>
        /// </ul>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>Describes the state of association between the IAM role and the DB instance. The Status property returns one of the following values:</p>
        /// <ul>
        /// <li> <p> <code>ACTIVE</code> - the IAM role ARN is associated with the DB instance and can be used to access other Amazon Web Services services on your behalf.</p> </li>
        /// <li> <p> <code>PENDING</code> - the IAM role ARN is being associated with the DB instance.</p> </li>
        /// <li> <p> <code>INVALID</code> - the IAM role ARN is associated with the DB instance, but the DB instance is unable to assume the IAM role in order to access other Amazon Web Services services on your behalf.</p> </li>
        /// </ul>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`DbInstanceRole`](crate::model::DbInstanceRole)
        pub fn build(self) -> crate::model::DbInstanceRole {
            crate::model::DbInstanceRole {
                role_arn: self.role_arn,
                feature_name: self.feature_name,
                status: self.status,
            }
        }
    }
}
impl DbInstanceRole {
    /// Creates a new builder-style object to manufacture [`DbInstanceRole`](crate::model::DbInstanceRole)
    pub fn builder() -> crate::model::db_instance_role::Builder {
        crate::model::db_instance_role::Builder::default()
    }
}

/// <p>Contains the processor features of a DB instance class.</p>
/// <p>To specify the number of CPU cores, use the <code>coreCount</code> feature name for the <code>Name</code> parameter. To specify the number of threads per core, use the <code>threadsPerCore</code> feature name for the <code>Name</code> parameter.</p>
/// <p>You can set the processor features of the DB instance class for a DB instance when you call one of the following actions:</p>
/// <ul>
/// <li> <p> <code>CreateDBInstance</code> </p> </li>
/// <li> <p> <code>ModifyDBInstance</code> </p> </li>
/// <li> <p> <code>RestoreDBInstanceFromDBSnapshot</code> </p> </li>
/// <li> <p> <code>RestoreDBInstanceFromS3</code> </p> </li>
/// <li> <p> <code>RestoreDBInstanceToPointInTime</code> </p> </li>
/// </ul>
/// <p>You can view the valid processor values for a particular instance class by calling the <code>DescribeOrderableDBInstanceOptions</code> action and specifying the instance class for the <code>DBInstanceClass</code> parameter.</p>
/// <p>In addition, you can use the following actions for DB instance class processor information:</p>
/// <ul>
/// <li> <p> <code>DescribeDBInstances</code> </p> </li>
/// <li> <p> <code>DescribeDBSnapshots</code> </p> </li>
/// <li> <p> <code>DescribeValidDBInstanceModifications</code> </p> </li>
/// </ul>
/// <p>If you call <code>DescribeDBInstances</code>, <code>ProcessorFeature</code> returns non-null values only if the following conditions are met:</p>
/// <ul>
/// <li> <p>You are accessing an Oracle DB instance.</p> </li>
/// <li> <p>Your Oracle DB instance class supports configuring the number of CPU cores and threads per core.</p> </li>
/// <li> <p>The current number CPU cores and threads is set to a non-default value.</p> </li>
/// </ul>
/// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html#USER_ConfigureProcessor">Configuring the Processor of the DB Instance Class</a> in the <i>Amazon RDS User Guide. </i> </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProcessorFeature {
    /// <p>The name of the processor feature. Valid names are <code>coreCount</code> and <code>threadsPerCore</code>.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The value of a processor feature name.</p>
    pub value: std::option::Option<std::string::String>,
}
impl ProcessorFeature {
    /// <p>The name of the processor feature. Valid names are <code>coreCount</code> and <code>threadsPerCore</code>.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The value of a processor feature name.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for ProcessorFeature {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProcessorFeature");
        formatter.field("name", &self.name);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`ProcessorFeature`](crate::model::ProcessorFeature)
pub mod processor_feature {
    /// A builder for [`ProcessorFeature`](crate::model::ProcessorFeature)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the processor feature. Valid names are <code>coreCount</code> and <code>threadsPerCore</code>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the processor feature. Valid names are <code>coreCount</code> and <code>threadsPerCore</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The value of a processor feature name.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The value of a processor feature name.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`ProcessorFeature`](crate::model::ProcessorFeature)
        pub fn build(self) -> crate::model::ProcessorFeature {
            crate::model::ProcessorFeature {
                name: self.name,
                value: self.value,
            }
        }
    }
}
impl ProcessorFeature {
    /// Creates a new builder-style object to manufacture [`ProcessorFeature`](crate::model::ProcessorFeature)
    pub fn builder() -> crate::model::processor_feature::Builder {
        crate::model::processor_feature::Builder::default()
    }
}

/// <p>An Active Directory Domain membership record associated with the DB instance or cluster.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DomainMembership {
    /// <p>The identifier of the Active Directory Domain.</p>
    pub domain: std::option::Option<std::string::String>,
    /// <p>The status of the Active Directory Domain membership for the DB instance or cluster. Values include joined, pending-join, failed, and so on.</p>
    pub status: std::option::Option<std::string::String>,
    /// <p>The fully qualified domain name of the Active Directory Domain.</p>
    pub fqdn: std::option::Option<std::string::String>,
    /// <p>The name of the IAM role to be used when making API calls to the Directory Service.</p>
    pub iam_role_name: std::option::Option<std::string::String>,
}
impl DomainMembership {
    /// <p>The identifier of the Active Directory Domain.</p>
    pub fn domain(&self) -> std::option::Option<&str> {
        self.domain.as_deref()
    }
    /// <p>The status of the Active Directory Domain membership for the DB instance or cluster. Values include joined, pending-join, failed, and so on.</p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>The fully qualified domain name of the Active Directory Domain.</p>
    pub fn fqdn(&self) -> std::option::Option<&str> {
        self.fqdn.as_deref()
    }
    /// <p>The name of the IAM role to be used when making API calls to the Directory Service.</p>
    pub fn iam_role_name(&self) -> std::option::Option<&str> {
        self.iam_role_name.as_deref()
    }
}
impl std::fmt::Debug for DomainMembership {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DomainMembership");
        formatter.field("domain", &self.domain);
        formatter.field("status", &self.status);
        formatter.field("fqdn", &self.fqdn);
        formatter.field("iam_role_name", &self.iam_role_name);
        formatter.finish()
    }
}
/// See [`DomainMembership`](crate::model::DomainMembership)
pub mod domain_membership {
    /// A builder for [`DomainMembership`](crate::model::DomainMembership)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) fqdn: std::option::Option<std::string::String>,
        pub(crate) iam_role_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the Active Directory Domain.</p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain = Some(input.into());
            self
        }
        /// <p>The identifier of the Active Directory Domain.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain = input;
            self
        }
        /// <p>The status of the Active Directory Domain membership for the DB instance or cluster. Values include joined, pending-join, failed, and so on.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the Active Directory Domain membership for the DB instance or cluster. Values include joined, pending-join, failed, and so on.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>The fully qualified domain name of the Active Directory Domain.</p>
        pub fn fqdn(mut self, input: impl Into<std::string::String>) -> Self {
            self.fqdn = Some(input.into());
            self
        }
        /// <p>The fully qualified domain name of the Active Directory Domain.</p>
        pub fn set_fqdn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.fqdn = input;
            self
        }
        /// <p>The name of the IAM role to be used when making API calls to the Directory Service.</p>
        pub fn iam_role_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.iam_role_name = Some(input.into());
            self
        }
        /// <p>The name of the IAM role to be used when making API calls to the Directory Service.</p>
        pub fn set_iam_role_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.iam_role_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DomainMembership`](crate::model::DomainMembership)
        pub fn build(self) -> crate::model::DomainMembership {
            crate::model::DomainMembership {
                domain: self.domain,
                status: self.status,
                fqdn: self.fqdn,
                iam_role_name: self.iam_role_name,
            }
        }
    }
}
impl DomainMembership {
    /// Creates a new builder-style object to manufacture [`DomainMembership`](crate::model::DomainMembership)
    pub fn builder() -> crate::model::domain_membership::Builder {
        crate::model::domain_membership::Builder::default()
    }
}

/// <p>Provides a list of status information for a DB instance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DbInstanceStatusInfo {
    /// <p>This value is currently "read replication."</p>
    pub status_type: std::option::Option<std::string::String>,
    /// <p>Boolean value that is true if the instance is operating normally, or false if the instance is in an error state.</p>
    pub normal: bool,
    /// <p>Status of the DB instance. For a StatusType of read replica, the values can be replicating, replication stop point set, replication stop point reached, error, stopped, or terminated.</p>
    pub status: std::option::Option<std::string::String>,
    /// <p>Details of the error if there is an error for the instance. If the instance isn't in an error state, this value is blank.</p>
    pub message: std::option::Option<std::string::String>,
}
impl DbInstanceStatusInfo {
    /// <p>This value is currently "read replication."</p>
    pub fn status_type(&self) -> std::option::Option<&str> {
        self.status_type.as_deref()
    }
    /// <p>Boolean value that is true if the instance is operating normally, or false if the instance is in an error state.</p>
    pub fn normal(&self) -> bool {
        self.normal
    }
    /// <p>Status of the DB instance. For a StatusType of read replica, the values can be replicating, replication stop point set, replication stop point reached, error, stopped, or terminated.</p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>Details of the error if there is an error for the instance. If the instance isn't in an error state, this value is blank.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Debug for DbInstanceStatusInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DbInstanceStatusInfo");
        formatter.field("status_type", &self.status_type);
        formatter.field("normal", &self.normal);
        formatter.field("status", &self.status);
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`DbInstanceStatusInfo`](crate::model::DbInstanceStatusInfo)
pub mod db_instance_status_info {
    /// A builder for [`DbInstanceStatusInfo`](crate::model::DbInstanceStatusInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status_type: std::option::Option<std::string::String>,
        pub(crate) normal: std::option::Option<bool>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>This value is currently "read replication."</p>
        pub fn status_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.status_type = Some(input.into());
            self
        }
        /// <p>This value is currently "read replication."</p>
        pub fn set_status_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status_type = input;
            self
        }
        /// <p>Boolean value that is true if the instance is operating normally, or false if the instance is in an error state.</p>
        pub fn normal(mut self, input: bool) -> Self {
            self.normal = Some(input);
            self
        }
        /// <p>Boolean value that is true if the instance is operating normally, or false if the instance is in an error state.</p>
        pub fn set_normal(mut self, input: std::option::Option<bool>) -> Self {
            self.normal = input;
            self
        }
        /// <p>Status of the DB instance. For a StatusType of read replica, the values can be replicating, replication stop point set, replication stop point reached, error, stopped, or terminated.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>Status of the DB instance. For a StatusType of read replica, the values can be replicating, replication stop point set, replication stop point reached, error, stopped, or terminated.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>Details of the error if there is an error for the instance. If the instance isn't in an error state, this value is blank.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Details of the error if there is an error for the instance. If the instance isn't in an error state, this value is blank.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DbInstanceStatusInfo`](crate::model::DbInstanceStatusInfo)
        pub fn build(self) -> crate::model::DbInstanceStatusInfo {
            crate::model::DbInstanceStatusInfo {
                status_type: self.status_type,
                normal: self.normal.unwrap_or_default(),
                status: self.status,
                message: self.message,
            }
        }
    }
}
impl DbInstanceStatusInfo {
    /// Creates a new builder-style object to manufacture [`DbInstanceStatusInfo`](crate::model::DbInstanceStatusInfo)
    pub fn builder() -> crate::model::db_instance_status_info::Builder {
        crate::model::db_instance_status_info::Builder::default()
    }
}

/// <p>Provides information on the option groups the DB instance is a member of.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OptionGroupMembership {
    /// <p>The name of the option group that the instance belongs to.</p>
    pub option_group_name: std::option::Option<std::string::String>,
    /// <p>The status of the DB instance's option group membership. Valid values are: <code>in-sync</code>, <code>pending-apply</code>, <code>pending-removal</code>, <code>pending-maintenance-apply</code>, <code>pending-maintenance-removal</code>, <code>applying</code>, <code>removing</code>, and <code>failed</code>. </p>
    pub status: std::option::Option<std::string::String>,
}
impl OptionGroupMembership {
    /// <p>The name of the option group that the instance belongs to.</p>
    pub fn option_group_name(&self) -> std::option::Option<&str> {
        self.option_group_name.as_deref()
    }
    /// <p>The status of the DB instance's option group membership. Valid values are: <code>in-sync</code>, <code>pending-apply</code>, <code>pending-removal</code>, <code>pending-maintenance-apply</code>, <code>pending-maintenance-removal</code>, <code>applying</code>, <code>removing</code>, and <code>failed</code>. </p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
}
impl std::fmt::Debug for OptionGroupMembership {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OptionGroupMembership");
        formatter.field("option_group_name", &self.option_group_name);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`OptionGroupMembership`](crate::model::OptionGroupMembership)
pub mod option_group_membership {
    /// A builder for [`OptionGroupMembership`](crate::model::OptionGroupMembership)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) option_group_name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the option group that the instance belongs to.</p>
        pub fn option_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.option_group_name = Some(input.into());
            self
        }
        /// <p>The name of the option group that the instance belongs to.</p>
        pub fn set_option_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.option_group_name = input;
            self
        }
        /// <p>The status of the DB instance's option group membership. Valid values are: <code>in-sync</code>, <code>pending-apply</code>, <code>pending-removal</code>, <code>pending-maintenance-apply</code>, <code>pending-maintenance-removal</code>, <code>applying</code>, <code>removing</code>, and <code>failed</code>. </p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the DB instance's option group membership. Valid values are: <code>in-sync</code>, <code>pending-apply</code>, <code>pending-removal</code>, <code>pending-maintenance-apply</code>, <code>pending-maintenance-removal</code>, <code>applying</code>, <code>removing</code>, and <code>failed</code>. </p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`OptionGroupMembership`](crate::model::OptionGroupMembership)
        pub fn build(self) -> crate::model::OptionGroupMembership {
            crate::model::OptionGroupMembership {
                option_group_name: self.option_group_name,
                status: self.status,
            }
        }
    }
}
impl OptionGroupMembership {
    /// Creates a new builder-style object to manufacture [`OptionGroupMembership`](crate::model::OptionGroupMembership)
    pub fn builder() -> crate::model::option_group_membership::Builder {
        crate::model::option_group_membership::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ReplicaMode {
    #[allow(missing_docs)] // documentation missing in model
    Mounted,
    #[allow(missing_docs)] // documentation missing in model
    OpenReadOnly,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ReplicaMode {
    fn from(s: &str) -> Self {
        match s {
            "mounted" => ReplicaMode::Mounted,
            "open-read-only" => ReplicaMode::OpenReadOnly,
            other => ReplicaMode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ReplicaMode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ReplicaMode::from(s))
    }
}
impl ReplicaMode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ReplicaMode::Mounted => "mounted",
            ReplicaMode::OpenReadOnly => "open-read-only",
            ReplicaMode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["mounted", "open-read-only"]
    }
}
impl AsRef<str> for ReplicaMode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> This data type is used as a response element in the <code>ModifyDBInstance</code> operation and contains changes that will be applied during the next maintenance window. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PendingModifiedValues {
    /// <p>The name of the compute and memory capacity class for the DB instance.</p>
    pub db_instance_class: std::option::Option<std::string::String>,
    /// <p>The allocated storage size for the DB instance specified in gibibytes (GiB).</p>
    pub allocated_storage: std::option::Option<i32>,
    /// <p>The master credentials for the DB instance.</p>
    pub master_user_password: std::option::Option<std::string::String>,
    /// <p>The port for the DB instance.</p>
    pub port: std::option::Option<i32>,
    /// <p>The number of days for which automated backups are retained.</p>
    pub backup_retention_period: std::option::Option<i32>,
    /// <p>A value that indicates that the Single-AZ DB instance will change to a Multi-AZ deployment.</p>
    pub multi_az: std::option::Option<bool>,
    /// <p>The database engine version.</p>
    pub engine_version: std::option::Option<std::string::String>,
    /// <p>The license model for the DB instance.</p>
    /// <p>Valid values: <code>license-included</code> | <code>bring-your-own-license</code> | <code>general-public-license</code> </p>
    pub license_model: std::option::Option<std::string::String>,
    /// <p>The Provisioned IOPS value for the DB instance.</p>
    pub iops: std::option::Option<i32>,
    /// <p>The database identifier for the DB instance.</p>
    pub db_instance_identifier: std::option::Option<std::string::String>,
    /// <p>The storage type of the DB instance.</p>
    pub storage_type: std::option::Option<std::string::String>,
    /// <p>The identifier of the CA certificate for the DB instance.</p>
    pub ca_certificate_identifier: std::option::Option<std::string::String>,
    /// <p>The DB subnet group for the DB instance.</p>
    pub db_subnet_group_name: std::option::Option<std::string::String>,
    /// <p>A list of the log types whose configuration is still pending. In other words, these log types are in the process of being activated or deactivated.</p>
    pub pending_cloudwatch_logs_exports:
        std::option::Option<crate::model::PendingCloudwatchLogsExports>,
    /// <p>The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.</p>
    pub processor_features: std::option::Option<std::vec::Vec<crate::model::ProcessorFeature>>,
    /// <p>Whether mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts is enabled.</p>
    pub iam_database_authentication_enabled: std::option::Option<bool>,
    /// <p>The automation mode of the RDS Custom DB instance: <code>full</code> or <code>all-paused</code>. If <code>full</code>, the DB instance automates monitoring and instance recovery. If <code>all-paused</code>, the instance pauses automation for the duration set by <code>--resume-full-automation-mode-minutes</code>.</p>
    pub automation_mode: std::option::Option<crate::model::AutomationMode>,
    /// <p>The number of minutes to pause the automation. When the time period ends, RDS Custom resumes full automation. The minimum value is 60 (default). The maximum value is 1,440. </p>
    pub resume_full_automation_mode_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl PendingModifiedValues {
    /// <p>The name of the compute and memory capacity class for the DB instance.</p>
    pub fn db_instance_class(&self) -> std::option::Option<&str> {
        self.db_instance_class.as_deref()
    }
    /// <p>The allocated storage size for the DB instance specified in gibibytes (GiB).</p>
    pub fn allocated_storage(&self) -> std::option::Option<i32> {
        self.allocated_storage
    }
    /// <p>The master credentials for the DB instance.</p>
    pub fn master_user_password(&self) -> std::option::Option<&str> {
        self.master_user_password.as_deref()
    }
    /// <p>The port for the DB instance.</p>
    pub fn port(&self) -> std::option::Option<i32> {
        self.port
    }
    /// <p>The number of days for which automated backups are retained.</p>
    pub fn backup_retention_period(&self) -> std::option::Option<i32> {
        self.backup_retention_period
    }
    /// <p>A value that indicates that the Single-AZ DB instance will change to a Multi-AZ deployment.</p>
    pub fn multi_az(&self) -> std::option::Option<bool> {
        self.multi_az
    }
    /// <p>The database engine version.</p>
    pub fn engine_version(&self) -> std::option::Option<&str> {
        self.engine_version.as_deref()
    }
    /// <p>The license model for the DB instance.</p>
    /// <p>Valid values: <code>license-included</code> | <code>bring-your-own-license</code> | <code>general-public-license</code> </p>
    pub fn license_model(&self) -> std::option::Option<&str> {
        self.license_model.as_deref()
    }
    /// <p>The Provisioned IOPS value for the DB instance.</p>
    pub fn iops(&self) -> std::option::Option<i32> {
        self.iops
    }
    /// <p>The database identifier for the DB instance.</p>
    pub fn db_instance_identifier(&self) -> std::option::Option<&str> {
        self.db_instance_identifier.as_deref()
    }
    /// <p>The storage type of the DB instance.</p>
    pub fn storage_type(&self) -> std::option::Option<&str> {
        self.storage_type.as_deref()
    }
    /// <p>The identifier of the CA certificate for the DB instance.</p>
    pub fn ca_certificate_identifier(&self) -> std::option::Option<&str> {
        self.ca_certificate_identifier.as_deref()
    }
    /// <p>The DB subnet group for the DB instance.</p>
    pub fn db_subnet_group_name(&self) -> std::option::Option<&str> {
        self.db_subnet_group_name.as_deref()
    }
    /// <p>A list of the log types whose configuration is still pending. In other words, these log types are in the process of being activated or deactivated.</p>
    pub fn pending_cloudwatch_logs_exports(
        &self,
    ) -> std::option::Option<&crate::model::PendingCloudwatchLogsExports> {
        self.pending_cloudwatch_logs_exports.as_ref()
    }
    /// <p>The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.</p>
    pub fn processor_features(&self) -> std::option::Option<&[crate::model::ProcessorFeature]> {
        self.processor_features.as_deref()
    }
    /// <p>Whether mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts is enabled.</p>
    pub fn iam_database_authentication_enabled(&self) -> std::option::Option<bool> {
        self.iam_database_authentication_enabled
    }
    /// <p>The automation mode of the RDS Custom DB instance: <code>full</code> or <code>all-paused</code>. If <code>full</code>, the DB instance automates monitoring and instance recovery. If <code>all-paused</code>, the instance pauses automation for the duration set by <code>--resume-full-automation-mode-minutes</code>.</p>
    pub fn automation_mode(&self) -> std::option::Option<&crate::model::AutomationMode> {
        self.automation_mode.as_ref()
    }
    /// <p>The number of minutes to pause the automation. When the time period ends, RDS Custom resumes full automation. The minimum value is 60 (default). The maximum value is 1,440. </p>
    pub fn resume_full_automation_mode_time(
        &self,
    ) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.resume_full_automation_mode_time.as_ref()
    }
}
impl std::fmt::Debug for PendingModifiedValues {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PendingModifiedValues");
        formatter.field("db_instance_class", &self.db_instance_class);
        formatter.field("allocated_storage", &self.allocated_storage);
        formatter.field("master_user_password", &self.master_user_password);
        formatter.field("port", &self.port);
        formatter.field("backup_retention_period", &self.backup_retention_period);
        formatter.field("multi_az", &self.multi_az);
        formatter.field("engine_version", &self.engine_version);
        formatter.field("license_model", &self.license_model);
        formatter.field("iops", &self.iops);
        formatter.field("db_instance_identifier", &self.db_instance_identifier);
        formatter.field("storage_type", &self.storage_type);
        formatter.field("ca_certificate_identifier", &self.ca_certificate_identifier);
        formatter.field("db_subnet_group_name", &self.db_subnet_group_name);
        formatter.field(
            "pending_cloudwatch_logs_exports",
            &self.pending_cloudwatch_logs_exports,
        );
        formatter.field("processor_features", &self.processor_features);
        formatter.field(
            "iam_database_authentication_enabled",
            &self.iam_database_authentication_enabled,
        );
        formatter.field("automation_mode", &self.automation_mode);
        formatter.field(
            "resume_full_automation_mode_time",
            &self.resume_full_automation_mode_time,
        );
        formatter.finish()
    }
}
/// See [`PendingModifiedValues`](crate::model::PendingModifiedValues)
pub mod pending_modified_values {
    /// A builder for [`PendingModifiedValues`](crate::model::PendingModifiedValues)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_instance_class: std::option::Option<std::string::String>,
        pub(crate) allocated_storage: std::option::Option<i32>,
        pub(crate) master_user_password: std::option::Option<std::string::String>,
        pub(crate) port: std::option::Option<i32>,
        pub(crate) backup_retention_period: std::option::Option<i32>,
        pub(crate) multi_az: std::option::Option<bool>,
        pub(crate) engine_version: std::option::Option<std::string::String>,
        pub(crate) license_model: std::option::Option<std::string::String>,
        pub(crate) iops: std::option::Option<i32>,
        pub(crate) db_instance_identifier: std::option::Option<std::string::String>,
        pub(crate) storage_type: std::option::Option<std::string::String>,
        pub(crate) ca_certificate_identifier: std::option::Option<std::string::String>,
        pub(crate) db_subnet_group_name: std::option::Option<std::string::String>,
        pub(crate) pending_cloudwatch_logs_exports:
            std::option::Option<crate::model::PendingCloudwatchLogsExports>,
        pub(crate) processor_features:
            std::option::Option<std::vec::Vec<crate::model::ProcessorFeature>>,
        pub(crate) iam_database_authentication_enabled: std::option::Option<bool>,
        pub(crate) automation_mode: std::option::Option<crate::model::AutomationMode>,
        pub(crate) resume_full_automation_mode_time:
            std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The name of the compute and memory capacity class for the DB instance.</p>
        pub fn db_instance_class(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_instance_class = Some(input.into());
            self
        }
        /// <p>The name of the compute and memory capacity class for the DB instance.</p>
        pub fn set_db_instance_class(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_instance_class = input;
            self
        }
        /// <p>The allocated storage size for the DB instance specified in gibibytes (GiB).</p>
        pub fn allocated_storage(mut self, input: i32) -> Self {
            self.allocated_storage = Some(input);
            self
        }
        /// <p>The allocated storage size for the DB instance specified in gibibytes (GiB).</p>
        pub fn set_allocated_storage(mut self, input: std::option::Option<i32>) -> Self {
            self.allocated_storage = input;
            self
        }
        /// <p>The master credentials for the DB instance.</p>
        pub fn master_user_password(mut self, input: impl Into<std::string::String>) -> Self {
            self.master_user_password = Some(input.into());
            self
        }
        /// <p>The master credentials for the DB instance.</p>
        pub fn set_master_user_password(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.master_user_password = input;
            self
        }
        /// <p>The port for the DB instance.</p>
        pub fn port(mut self, input: i32) -> Self {
            self.port = Some(input);
            self
        }
        /// <p>The port for the DB instance.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.port = input;
            self
        }
        /// <p>The number of days for which automated backups are retained.</p>
        pub fn backup_retention_period(mut self, input: i32) -> Self {
            self.backup_retention_period = Some(input);
            self
        }
        /// <p>The number of days for which automated backups are retained.</p>
        pub fn set_backup_retention_period(mut self, input: std::option::Option<i32>) -> Self {
            self.backup_retention_period = input;
            self
        }
        /// <p>A value that indicates that the Single-AZ DB instance will change to a Multi-AZ deployment.</p>
        pub fn multi_az(mut self, input: bool) -> Self {
            self.multi_az = Some(input);
            self
        }
        /// <p>A value that indicates that the Single-AZ DB instance will change to a Multi-AZ deployment.</p>
        pub fn set_multi_az(mut self, input: std::option::Option<bool>) -> Self {
            self.multi_az = input;
            self
        }
        /// <p>The database engine version.</p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_version = Some(input.into());
            self
        }
        /// <p>The database engine version.</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.engine_version = input;
            self
        }
        /// <p>The license model for the DB instance.</p>
        /// <p>Valid values: <code>license-included</code> | <code>bring-your-own-license</code> | <code>general-public-license</code> </p>
        pub fn license_model(mut self, input: impl Into<std::string::String>) -> Self {
            self.license_model = Some(input.into());
            self
        }
        /// <p>The license model for the DB instance.</p>
        /// <p>Valid values: <code>license-included</code> | <code>bring-your-own-license</code> | <code>general-public-license</code> </p>
        pub fn set_license_model(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.license_model = input;
            self
        }
        /// <p>The Provisioned IOPS value for the DB instance.</p>
        pub fn iops(mut self, input: i32) -> Self {
            self.iops = Some(input);
            self
        }
        /// <p>The Provisioned IOPS value for the DB instance.</p>
        pub fn set_iops(mut self, input: std::option::Option<i32>) -> Self {
            self.iops = input;
            self
        }
        /// <p>The database identifier for the DB instance.</p>
        pub fn db_instance_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_instance_identifier = Some(input.into());
            self
        }
        /// <p>The database identifier for the DB instance.</p>
        pub fn set_db_instance_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_instance_identifier = input;
            self
        }
        /// <p>The storage type of the DB instance.</p>
        pub fn storage_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.storage_type = Some(input.into());
            self
        }
        /// <p>The storage type of the DB instance.</p>
        pub fn set_storage_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.storage_type = input;
            self
        }
        /// <p>The identifier of the CA certificate for the DB instance.</p>
        pub fn ca_certificate_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.ca_certificate_identifier = Some(input.into());
            self
        }
        /// <p>The identifier of the CA certificate for the DB instance.</p>
        pub fn set_ca_certificate_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ca_certificate_identifier = input;
            self
        }
        /// <p>The DB subnet group for the DB instance.</p>
        pub fn db_subnet_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_subnet_group_name = Some(input.into());
            self
        }
        /// <p>The DB subnet group for the DB instance.</p>
        pub fn set_db_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_subnet_group_name = input;
            self
        }
        /// <p>A list of the log types whose configuration is still pending. In other words, these log types are in the process of being activated or deactivated.</p>
        pub fn pending_cloudwatch_logs_exports(
            mut self,
            input: crate::model::PendingCloudwatchLogsExports,
        ) -> Self {
            self.pending_cloudwatch_logs_exports = Some(input);
            self
        }
        /// <p>A list of the log types whose configuration is still pending. In other words, these log types are in the process of being activated or deactivated.</p>
        pub fn set_pending_cloudwatch_logs_exports(
            mut self,
            input: std::option::Option<crate::model::PendingCloudwatchLogsExports>,
        ) -> Self {
            self.pending_cloudwatch_logs_exports = input;
            self
        }
        /// Appends an item to `processor_features`.
        ///
        /// To override the contents of this collection use [`set_processor_features`](Self::set_processor_features).
        ///
        /// <p>The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.</p>
        pub fn processor_features(mut self, input: crate::model::ProcessorFeature) -> Self {
            let mut v = self.processor_features.unwrap_or_default();
            v.push(input);
            self.processor_features = Some(v);
            self
        }
        /// <p>The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.</p>
        pub fn set_processor_features(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ProcessorFeature>>,
        ) -> Self {
            self.processor_features = input;
            self
        }
        /// <p>Whether mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts is enabled.</p>
        pub fn iam_database_authentication_enabled(mut self, input: bool) -> Self {
            self.iam_database_authentication_enabled = Some(input);
            self
        }
        /// <p>Whether mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts is enabled.</p>
        pub fn set_iam_database_authentication_enabled(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.iam_database_authentication_enabled = input;
            self
        }
        /// <p>The automation mode of the RDS Custom DB instance: <code>full</code> or <code>all-paused</code>. If <code>full</code>, the DB instance automates monitoring and instance recovery. If <code>all-paused</code>, the instance pauses automation for the duration set by <code>--resume-full-automation-mode-minutes</code>.</p>
        pub fn automation_mode(mut self, input: crate::model::AutomationMode) -> Self {
            self.automation_mode = Some(input);
            self
        }
        /// <p>The automation mode of the RDS Custom DB instance: <code>full</code> or <code>all-paused</code>. If <code>full</code>, the DB instance automates monitoring and instance recovery. If <code>all-paused</code>, the instance pauses automation for the duration set by <code>--resume-full-automation-mode-minutes</code>.</p>
        pub fn set_automation_mode(
            mut self,
            input: std::option::Option<crate::model::AutomationMode>,
        ) -> Self {
            self.automation_mode = input;
            self
        }
        /// <p>The number of minutes to pause the automation. When the time period ends, RDS Custom resumes full automation. The minimum value is 60 (default). The maximum value is 1,440. </p>
        pub fn resume_full_automation_mode_time(
            mut self,
            input: aws_smithy_types::DateTime,
        ) -> Self {
            self.resume_full_automation_mode_time = Some(input);
            self
        }
        /// <p>The number of minutes to pause the automation. When the time period ends, RDS Custom resumes full automation. The minimum value is 60 (default). The maximum value is 1,440. </p>
        pub fn set_resume_full_automation_mode_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.resume_full_automation_mode_time = input;
            self
        }
        /// Consumes the builder and constructs a [`PendingModifiedValues`](crate::model::PendingModifiedValues)
        pub fn build(self) -> crate::model::PendingModifiedValues {
            crate::model::PendingModifiedValues {
                db_instance_class: self.db_instance_class,
                allocated_storage: self.allocated_storage,
                master_user_password: self.master_user_password,
                port: self.port,
                backup_retention_period: self.backup_retention_period,
                multi_az: self.multi_az,
                engine_version: self.engine_version,
                license_model: self.license_model,
                iops: self.iops,
                db_instance_identifier: self.db_instance_identifier,
                storage_type: self.storage_type,
                ca_certificate_identifier: self.ca_certificate_identifier,
                db_subnet_group_name: self.db_subnet_group_name,
                pending_cloudwatch_logs_exports: self.pending_cloudwatch_logs_exports,
                processor_features: self.processor_features,
                iam_database_authentication_enabled: self.iam_database_authentication_enabled,
                automation_mode: self.automation_mode,
                resume_full_automation_mode_time: self.resume_full_automation_mode_time,
            }
        }
    }
}
impl PendingModifiedValues {
    /// Creates a new builder-style object to manufacture [`PendingModifiedValues`](crate::model::PendingModifiedValues)
    pub fn builder() -> crate::model::pending_modified_values::Builder {
        crate::model::pending_modified_values::Builder::default()
    }
}

/// <p>A list of the log types whose configuration is still pending. In other words, these log types are in the process of being activated or deactivated.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PendingCloudwatchLogsExports {
    /// <p>Log types that are in the process of being deactivated. After they are deactivated, these log types aren't exported to CloudWatch Logs.</p>
    pub log_types_to_enable: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Log types that are in the process of being enabled. After they are enabled, these log types are exported to CloudWatch Logs.</p>
    pub log_types_to_disable: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl PendingCloudwatchLogsExports {
    /// <p>Log types that are in the process of being deactivated. After they are deactivated, these log types aren't exported to CloudWatch Logs.</p>
    pub fn log_types_to_enable(&self) -> std::option::Option<&[std::string::String]> {
        self.log_types_to_enable.as_deref()
    }
    /// <p>Log types that are in the process of being enabled. After they are enabled, these log types are exported to CloudWatch Logs.</p>
    pub fn log_types_to_disable(&self) -> std::option::Option<&[std::string::String]> {
        self.log_types_to_disable.as_deref()
    }
}
impl std::fmt::Debug for PendingCloudwatchLogsExports {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PendingCloudwatchLogsExports");
        formatter.field("log_types_to_enable", &self.log_types_to_enable);
        formatter.field("log_types_to_disable", &self.log_types_to_disable);
        formatter.finish()
    }
}
/// See [`PendingCloudwatchLogsExports`](crate::model::PendingCloudwatchLogsExports)
pub mod pending_cloudwatch_logs_exports {
    /// A builder for [`PendingCloudwatchLogsExports`](crate::model::PendingCloudwatchLogsExports)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) log_types_to_enable: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) log_types_to_disable: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `log_types_to_enable`.
        ///
        /// To override the contents of this collection use [`set_log_types_to_enable`](Self::set_log_types_to_enable).
        ///
        /// <p>Log types that are in the process of being deactivated. After they are deactivated, these log types aren't exported to CloudWatch Logs.</p>
        pub fn log_types_to_enable(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.log_types_to_enable.unwrap_or_default();
            v.push(input.into());
            self.log_types_to_enable = Some(v);
            self
        }
        /// <p>Log types that are in the process of being deactivated. After they are deactivated, these log types aren't exported to CloudWatch Logs.</p>
        pub fn set_log_types_to_enable(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.log_types_to_enable = input;
            self
        }
        /// Appends an item to `log_types_to_disable`.
        ///
        /// To override the contents of this collection use [`set_log_types_to_disable`](Self::set_log_types_to_disable).
        ///
        /// <p>Log types that are in the process of being enabled. After they are enabled, these log types are exported to CloudWatch Logs.</p>
        pub fn log_types_to_disable(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.log_types_to_disable.unwrap_or_default();
            v.push(input.into());
            self.log_types_to_disable = Some(v);
            self
        }
        /// <p>Log types that are in the process of being enabled. After they are enabled, these log types are exported to CloudWatch Logs.</p>
        pub fn set_log_types_to_disable(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.log_types_to_disable = input;
            self
        }
        /// Consumes the builder and constructs a [`PendingCloudwatchLogsExports`](crate::model::PendingCloudwatchLogsExports)
        pub fn build(self) -> crate::model::PendingCloudwatchLogsExports {
            crate::model::PendingCloudwatchLogsExports {
                log_types_to_enable: self.log_types_to_enable,
                log_types_to_disable: self.log_types_to_disable,
            }
        }
    }
}
impl PendingCloudwatchLogsExports {
    /// Creates a new builder-style object to manufacture [`PendingCloudwatchLogsExports`](crate::model::PendingCloudwatchLogsExports)
    pub fn builder() -> crate::model::pending_cloudwatch_logs_exports::Builder {
        crate::model::pending_cloudwatch_logs_exports::Builder::default()
    }
}

/// <p>Contains the details of an Amazon RDS DB subnet group. </p>
/// <p>This data type is used as a response element in the <code>DescribeDBSubnetGroups</code> action. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DbSubnetGroup {
    /// <p>The name of the DB subnet group.</p>
    pub db_subnet_group_name: std::option::Option<std::string::String>,
    /// <p>Provides the description of the DB subnet group.</p>
    pub db_subnet_group_description: std::option::Option<std::string::String>,
    /// <p>Provides the VpcId of the DB subnet group.</p>
    pub vpc_id: std::option::Option<std::string::String>,
    /// <p>Provides the status of the DB subnet group.</p>
    pub subnet_group_status: std::option::Option<std::string::String>,
    /// <p> Contains a list of <code>Subnet</code> elements. </p>
    pub subnets: std::option::Option<std::vec::Vec<crate::model::Subnet>>,
    /// <p>The Amazon Resource Name (ARN) for the DB subnet group.</p>
    pub db_subnet_group_arn: std::option::Option<std::string::String>,
}
impl DbSubnetGroup {
    /// <p>The name of the DB subnet group.</p>
    pub fn db_subnet_group_name(&self) -> std::option::Option<&str> {
        self.db_subnet_group_name.as_deref()
    }
    /// <p>Provides the description of the DB subnet group.</p>
    pub fn db_subnet_group_description(&self) -> std::option::Option<&str> {
        self.db_subnet_group_description.as_deref()
    }
    /// <p>Provides the VpcId of the DB subnet group.</p>
    pub fn vpc_id(&self) -> std::option::Option<&str> {
        self.vpc_id.as_deref()
    }
    /// <p>Provides the status of the DB subnet group.</p>
    pub fn subnet_group_status(&self) -> std::option::Option<&str> {
        self.subnet_group_status.as_deref()
    }
    /// <p> Contains a list of <code>Subnet</code> elements. </p>
    pub fn subnets(&self) -> std::option::Option<&[crate::model::Subnet]> {
        self.subnets.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) for the DB subnet group.</p>
    pub fn db_subnet_group_arn(&self) -> std::option::Option<&str> {
        self.db_subnet_group_arn.as_deref()
    }
}
impl std::fmt::Debug for DbSubnetGroup {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DbSubnetGroup");
        formatter.field("db_subnet_group_name", &self.db_subnet_group_name);
        formatter.field(
            "db_subnet_group_description",
            &self.db_subnet_group_description,
        );
        formatter.field("vpc_id", &self.vpc_id);
        formatter.field("subnet_group_status", &self.subnet_group_status);
        formatter.field("subnets", &self.subnets);
        formatter.field("db_subnet_group_arn", &self.db_subnet_group_arn);
        formatter.finish()
    }
}
/// See [`DbSubnetGroup`](crate::model::DbSubnetGroup)
pub mod db_subnet_group {
    /// A builder for [`DbSubnetGroup`](crate::model::DbSubnetGroup)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_subnet_group_name: std::option::Option<std::string::String>,
        pub(crate) db_subnet_group_description: std::option::Option<std::string::String>,
        pub(crate) vpc_id: std::option::Option<std::string::String>,
        pub(crate) subnet_group_status: std::option::Option<std::string::String>,
        pub(crate) subnets: std::option::Option<std::vec::Vec<crate::model::Subnet>>,
        pub(crate) db_subnet_group_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the DB subnet group.</p>
        pub fn db_subnet_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_subnet_group_name = Some(input.into());
            self
        }
        /// <p>The name of the DB subnet group.</p>
        pub fn set_db_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_subnet_group_name = input;
            self
        }
        /// <p>Provides the description of the DB subnet group.</p>
        pub fn db_subnet_group_description(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.db_subnet_group_description = Some(input.into());
            self
        }
        /// <p>Provides the description of the DB subnet group.</p>
        pub fn set_db_subnet_group_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_subnet_group_description = input;
            self
        }
        /// <p>Provides the VpcId of the DB subnet group.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_id = Some(input.into());
            self
        }
        /// <p>Provides the VpcId of the DB subnet group.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_id = input;
            self
        }
        /// <p>Provides the status of the DB subnet group.</p>
        pub fn subnet_group_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.subnet_group_status = Some(input.into());
            self
        }
        /// <p>Provides the status of the DB subnet group.</p>
        pub fn set_subnet_group_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.subnet_group_status = input;
            self
        }
        /// Appends an item to `subnets`.
        ///
        /// To override the contents of this collection use [`set_subnets`](Self::set_subnets).
        ///
        /// <p> Contains a list of <code>Subnet</code> elements. </p>
        pub fn subnets(mut self, input: crate::model::Subnet) -> Self {
            let mut v = self.subnets.unwrap_or_default();
            v.push(input);
            self.subnets = Some(v);
            self
        }
        /// <p> Contains a list of <code>Subnet</code> elements. </p>
        pub fn set_subnets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Subnet>>,
        ) -> Self {
            self.subnets = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the DB subnet group.</p>
        pub fn db_subnet_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_subnet_group_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the DB subnet group.</p>
        pub fn set_db_subnet_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_subnet_group_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DbSubnetGroup`](crate::model::DbSubnetGroup)
        pub fn build(self) -> crate::model::DbSubnetGroup {
            crate::model::DbSubnetGroup {
                db_subnet_group_name: self.db_subnet_group_name,
                db_subnet_group_description: self.db_subnet_group_description,
                vpc_id: self.vpc_id,
                subnet_group_status: self.subnet_group_status,
                subnets: self.subnets,
                db_subnet_group_arn: self.db_subnet_group_arn,
            }
        }
    }
}
impl DbSubnetGroup {
    /// Creates a new builder-style object to manufacture [`DbSubnetGroup`](crate::model::DbSubnetGroup)
    pub fn builder() -> crate::model::db_subnet_group::Builder {
        crate::model::db_subnet_group::Builder::default()
    }
}

/// <p> This data type is used as a response element for the <code>DescribeDBSubnetGroups</code> operation. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Subnet {
    /// <p>The identifier of the subnet.</p>
    pub subnet_identifier: std::option::Option<std::string::String>,
    /// <p>Contains Availability Zone information.</p>
    /// <p> This data type is used as an element in the <code>OrderableDBInstanceOption</code> data type.</p>
    pub subnet_availability_zone: std::option::Option<crate::model::AvailabilityZone>,
    /// <p>If the subnet is associated with an Outpost, this value specifies the Outpost.</p>
    /// <p>For more information about RDS on Outposts, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html">Amazon RDS on Amazon Web Services Outposts</a> in the <i>Amazon RDS User Guide.</i> </p>
    pub subnet_outpost: std::option::Option<crate::model::Outpost>,
    /// <p>The status of the subnet.</p>
    pub subnet_status: std::option::Option<std::string::String>,
}
impl Subnet {
    /// <p>The identifier of the subnet.</p>
    pub fn subnet_identifier(&self) -> std::option::Option<&str> {
        self.subnet_identifier.as_deref()
    }
    /// <p>Contains Availability Zone information.</p>
    /// <p> This data type is used as an element in the <code>OrderableDBInstanceOption</code> data type.</p>
    pub fn subnet_availability_zone(&self) -> std::option::Option<&crate::model::AvailabilityZone> {
        self.subnet_availability_zone.as_ref()
    }
    /// <p>If the subnet is associated with an Outpost, this value specifies the Outpost.</p>
    /// <p>For more information about RDS on Outposts, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html">Amazon RDS on Amazon Web Services Outposts</a> in the <i>Amazon RDS User Guide.</i> </p>
    pub fn subnet_outpost(&self) -> std::option::Option<&crate::model::Outpost> {
        self.subnet_outpost.as_ref()
    }
    /// <p>The status of the subnet.</p>
    pub fn subnet_status(&self) -> std::option::Option<&str> {
        self.subnet_status.as_deref()
    }
}
impl std::fmt::Debug for Subnet {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Subnet");
        formatter.field("subnet_identifier", &self.subnet_identifier);
        formatter.field("subnet_availability_zone", &self.subnet_availability_zone);
        formatter.field("subnet_outpost", &self.subnet_outpost);
        formatter.field("subnet_status", &self.subnet_status);
        formatter.finish()
    }
}
/// See [`Subnet`](crate::model::Subnet)
pub mod subnet {
    /// A builder for [`Subnet`](crate::model::Subnet)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) subnet_identifier: std::option::Option<std::string::String>,
        pub(crate) subnet_availability_zone: std::option::Option<crate::model::AvailabilityZone>,
        pub(crate) subnet_outpost: std::option::Option<crate::model::Outpost>,
        pub(crate) subnet_status: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the subnet.</p>
        pub fn subnet_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.subnet_identifier = Some(input.into());
            self
        }
        /// <p>The identifier of the subnet.</p>
        pub fn set_subnet_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.subnet_identifier = input;
            self
        }
        /// <p>Contains Availability Zone information.</p>
        /// <p> This data type is used as an element in the <code>OrderableDBInstanceOption</code> data type.</p>
        pub fn subnet_availability_zone(mut self, input: crate::model::AvailabilityZone) -> Self {
            self.subnet_availability_zone = Some(input);
            self
        }
        /// <p>Contains Availability Zone information.</p>
        /// <p> This data type is used as an element in the <code>OrderableDBInstanceOption</code> data type.</p>
        pub fn set_subnet_availability_zone(
            mut self,
            input: std::option::Option<crate::model::AvailabilityZone>,
        ) -> Self {
            self.subnet_availability_zone = input;
            self
        }
        /// <p>If the subnet is associated with an Outpost, this value specifies the Outpost.</p>
        /// <p>For more information about RDS on Outposts, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html">Amazon RDS on Amazon Web Services Outposts</a> in the <i>Amazon RDS User Guide.</i> </p>
        pub fn subnet_outpost(mut self, input: crate::model::Outpost) -> Self {
            self.subnet_outpost = Some(input);
            self
        }
        /// <p>If the subnet is associated with an Outpost, this value specifies the Outpost.</p>
        /// <p>For more information about RDS on Outposts, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html">Amazon RDS on Amazon Web Services Outposts</a> in the <i>Amazon RDS User Guide.</i> </p>
        pub fn set_subnet_outpost(
            mut self,
            input: std::option::Option<crate::model::Outpost>,
        ) -> Self {
            self.subnet_outpost = input;
            self
        }
        /// <p>The status of the subnet.</p>
        pub fn subnet_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.subnet_status = Some(input.into());
            self
        }
        /// <p>The status of the subnet.</p>
        pub fn set_subnet_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.subnet_status = input;
            self
        }
        /// Consumes the builder and constructs a [`Subnet`](crate::model::Subnet)
        pub fn build(self) -> crate::model::Subnet {
            crate::model::Subnet {
                subnet_identifier: self.subnet_identifier,
                subnet_availability_zone: self.subnet_availability_zone,
                subnet_outpost: self.subnet_outpost,
                subnet_status: self.subnet_status,
            }
        }
    }
}
impl Subnet {
    /// Creates a new builder-style object to manufacture [`Subnet`](crate::model::Subnet)
    pub fn builder() -> crate::model::subnet::Builder {
        crate::model::subnet::Builder::default()
    }
}

/// <p>A data type that represents an Outpost.</p>
/// <p>For more information about RDS on Outposts, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html">Amazon RDS on Amazon Web Services Outposts</a> in the <i>Amazon RDS User Guide.</i> </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Outpost {
    /// <p>The Amazon Resource Name (ARN) of the Outpost.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl Outpost {
    /// <p>The Amazon Resource Name (ARN) of the Outpost.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
}
impl std::fmt::Debug for Outpost {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Outpost");
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}
/// See [`Outpost`](crate::model::Outpost)
pub mod outpost {
    /// A builder for [`Outpost`](crate::model::Outpost)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the Outpost.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Outpost.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`Outpost`](crate::model::Outpost)
        pub fn build(self) -> crate::model::Outpost {
            crate::model::Outpost { arn: self.arn }
        }
    }
}
impl Outpost {
    /// Creates a new builder-style object to manufacture [`Outpost`](crate::model::Outpost)
    pub fn builder() -> crate::model::outpost::Builder {
        crate::model::outpost::Builder::default()
    }
}

/// <p>Contains Availability Zone information.</p>
/// <p> This data type is used as an element in the <code>OrderableDBInstanceOption</code> data type.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AvailabilityZone {
    /// <p>The name of the Availability Zone.</p>
    pub name: std::option::Option<std::string::String>,
}
impl AvailabilityZone {
    /// <p>The name of the Availability Zone.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for AvailabilityZone {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AvailabilityZone");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`AvailabilityZone`](crate::model::AvailabilityZone)
pub mod availability_zone {
    /// A builder for [`AvailabilityZone`](crate::model::AvailabilityZone)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the Availability Zone.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the Availability Zone.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`AvailabilityZone`](crate::model::AvailabilityZone)
        pub fn build(self) -> crate::model::AvailabilityZone {
            crate::model::AvailabilityZone { name: self.name }
        }
    }
}
impl AvailabilityZone {
    /// Creates a new builder-style object to manufacture [`AvailabilityZone`](crate::model::AvailabilityZone)
    pub fn builder() -> crate::model::availability_zone::Builder {
        crate::model::availability_zone::Builder::default()
    }
}

/// <p>The status of the DB parameter group.</p>
/// <p>This data type is used as a response element in the following actions:</p>
/// <ul>
/// <li> <p> <code>CreateDBInstance</code> </p> </li>
/// <li> <p> <code>CreateDBInstanceReadReplica</code> </p> </li>
/// <li> <p> <code>DeleteDBInstance</code> </p> </li>
/// <li> <p> <code>ModifyDBInstance</code> </p> </li>
/// <li> <p> <code>RebootDBInstance</code> </p> </li>
/// <li> <p> <code>RestoreDBInstanceFromDBSnapshot</code> </p> </li>
/// </ul>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DbParameterGroupStatus {
    /// <p>The name of the DB parameter group.</p>
    pub db_parameter_group_name: std::option::Option<std::string::String>,
    /// <p>The status of parameter updates.</p>
    pub parameter_apply_status: std::option::Option<std::string::String>,
}
impl DbParameterGroupStatus {
    /// <p>The name of the DB parameter group.</p>
    pub fn db_parameter_group_name(&self) -> std::option::Option<&str> {
        self.db_parameter_group_name.as_deref()
    }
    /// <p>The status of parameter updates.</p>
    pub fn parameter_apply_status(&self) -> std::option::Option<&str> {
        self.parameter_apply_status.as_deref()
    }
}
impl std::fmt::Debug for DbParameterGroupStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DbParameterGroupStatus");
        formatter.field("db_parameter_group_name", &self.db_parameter_group_name);
        formatter.field("parameter_apply_status", &self.parameter_apply_status);
        formatter.finish()
    }
}
/// See [`DbParameterGroupStatus`](crate::model::DbParameterGroupStatus)
pub mod db_parameter_group_status {
    /// A builder for [`DbParameterGroupStatus`](crate::model::DbParameterGroupStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_parameter_group_name: std::option::Option<std::string::String>,
        pub(crate) parameter_apply_status: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the DB parameter group.</p>
        pub fn db_parameter_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_parameter_group_name = Some(input.into());
            self
        }
        /// <p>The name of the DB parameter group.</p>
        pub fn set_db_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_parameter_group_name = input;
            self
        }
        /// <p>The status of parameter updates.</p>
        pub fn parameter_apply_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.parameter_apply_status = Some(input.into());
            self
        }
        /// <p>The status of parameter updates.</p>
        pub fn set_parameter_apply_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parameter_apply_status = input;
            self
        }
        /// Consumes the builder and constructs a [`DbParameterGroupStatus`](crate::model::DbParameterGroupStatus)
        pub fn build(self) -> crate::model::DbParameterGroupStatus {
            crate::model::DbParameterGroupStatus {
                db_parameter_group_name: self.db_parameter_group_name,
                parameter_apply_status: self.parameter_apply_status,
            }
        }
    }
}
impl DbParameterGroupStatus {
    /// Creates a new builder-style object to manufacture [`DbParameterGroupStatus`](crate::model::DbParameterGroupStatus)
    pub fn builder() -> crate::model::db_parameter_group_status::Builder {
        crate::model::db_parameter_group_status::Builder::default()
    }
}

/// <p>This data type is used as a response element for queries on VPC security group membership.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VpcSecurityGroupMembership {
    /// <p>The name of the VPC security group.</p>
    pub vpc_security_group_id: std::option::Option<std::string::String>,
    /// <p>The status of the VPC security group.</p>
    pub status: std::option::Option<std::string::String>,
}
impl VpcSecurityGroupMembership {
    /// <p>The name of the VPC security group.</p>
    pub fn vpc_security_group_id(&self) -> std::option::Option<&str> {
        self.vpc_security_group_id.as_deref()
    }
    /// <p>The status of the VPC security group.</p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
}
impl std::fmt::Debug for VpcSecurityGroupMembership {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VpcSecurityGroupMembership");
        formatter.field("vpc_security_group_id", &self.vpc_security_group_id);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`VpcSecurityGroupMembership`](crate::model::VpcSecurityGroupMembership)
pub mod vpc_security_group_membership {
    /// A builder for [`VpcSecurityGroupMembership`](crate::model::VpcSecurityGroupMembership)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) vpc_security_group_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the VPC security group.</p>
        pub fn vpc_security_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_security_group_id = Some(input.into());
            self
        }
        /// <p>The name of the VPC security group.</p>
        pub fn set_vpc_security_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.vpc_security_group_id = input;
            self
        }
        /// <p>The status of the VPC security group.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the VPC security group.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`VpcSecurityGroupMembership`](crate::model::VpcSecurityGroupMembership)
        pub fn build(self) -> crate::model::VpcSecurityGroupMembership {
            crate::model::VpcSecurityGroupMembership {
                vpc_security_group_id: self.vpc_security_group_id,
                status: self.status,
            }
        }
    }
}
impl VpcSecurityGroupMembership {
    /// Creates a new builder-style object to manufacture [`VpcSecurityGroupMembership`](crate::model::VpcSecurityGroupMembership)
    pub fn builder() -> crate::model::vpc_security_group_membership::Builder {
        crate::model::vpc_security_group_membership::Builder::default()
    }
}

/// <p>This data type is used as a response element in the following actions:</p>
/// <ul>
/// <li> <p> <code>ModifyDBInstance</code> </p> </li>
/// <li> <p> <code>RebootDBInstance</code> </p> </li>
/// <li> <p> <code>RestoreDBInstanceFromDBSnapshot</code> </p> </li>
/// <li> <p> <code>RestoreDBInstanceToPointInTime</code> </p> </li>
/// </ul>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DbSecurityGroupMembership {
    /// <p>The name of the DB security group.</p>
    pub db_security_group_name: std::option::Option<std::string::String>,
    /// <p>The status of the DB security group.</p>
    pub status: std::option::Option<std::string::String>,
}
impl DbSecurityGroupMembership {
    /// <p>The name of the DB security group.</p>
    pub fn db_security_group_name(&self) -> std::option::Option<&str> {
        self.db_security_group_name.as_deref()
    }
    /// <p>The status of the DB security group.</p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
}
impl std::fmt::Debug for DbSecurityGroupMembership {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DbSecurityGroupMembership");
        formatter.field("db_security_group_name", &self.db_security_group_name);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`DbSecurityGroupMembership`](crate::model::DbSecurityGroupMembership)
pub mod db_security_group_membership {
    /// A builder for [`DbSecurityGroupMembership`](crate::model::DbSecurityGroupMembership)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_security_group_name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the DB security group.</p>
        pub fn db_security_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_security_group_name = Some(input.into());
            self
        }
        /// <p>The name of the DB security group.</p>
        pub fn set_db_security_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_security_group_name = input;
            self
        }
        /// <p>The status of the DB security group.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the DB security group.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`DbSecurityGroupMembership`](crate::model::DbSecurityGroupMembership)
        pub fn build(self) -> crate::model::DbSecurityGroupMembership {
            crate::model::DbSecurityGroupMembership {
                db_security_group_name: self.db_security_group_name,
                status: self.status,
            }
        }
    }
}
impl DbSecurityGroupMembership {
    /// Creates a new builder-style object to manufacture [`DbSecurityGroupMembership`](crate::model::DbSecurityGroupMembership)
    pub fn builder() -> crate::model::db_security_group_membership::Builder {
        crate::model::db_security_group_membership::Builder::default()
    }
}

/// <p>Contains the details of an Amazon Aurora DB cluster or Multi-AZ DB cluster. </p>
/// <p>For an Amazon Aurora DB cluster, this data type is used as a response element in the operations <code>CreateDBCluster</code>, <code>DeleteDBCluster</code>, <code>DescribeDBClusters</code>, <code>FailoverDBCluster</code>, <code>ModifyDBCluster</code>, <code>PromoteReadReplicaDBCluster</code>, <code>RestoreDBClusterFromS3</code>, <code>RestoreDBClusterFromSnapshot</code>, <code>RestoreDBClusterToPointInTime</code>, <code>StartDBCluster</code>, and <code>StopDBCluster</code>.</p>
/// <p>For a Multi-AZ DB cluster, this data type is used as a response element in the operations <code>CreateDBCluster</code>, <code>DeleteDBCluster</code>, <code>DescribeDBClusters</code>, <code>FailoverDBCluster</code>, <code>ModifyDBCluster</code>, <code>RebootDBCluster</code>, <code>RestoreDBClusterFromSnapshot</code>, and <code>RestoreDBClusterToPointInTime</code>.</p>
/// <p>For more information on Amazon Aurora DB clusters, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon Aurora?</a> in the <i>Amazon Aurora User Guide.</i> </p>
/// <p>For more information on Multi-AZ DB clusters, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ deployments with two readable standby DB instances</a> in the <i>Amazon RDS User Guide.</i> </p> <note>
/// <p>The Multi-AZ DB clusters feature is in preview and is subject to change.</p>
/// </note>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DbCluster {
    /// <p>For all database engines except Amazon Aurora, <code>AllocatedStorage</code> specifies the allocated storage size in gibibytes (GiB). For Aurora, <code>AllocatedStorage</code> always returns 1, because Aurora DB cluster storage size isn't fixed, but instead automatically adjusts as needed.</p>
    pub allocated_storage: std::option::Option<i32>,
    /// <p>Provides the list of Availability Zones (AZs) where instances in the DB cluster can be created.</p>
    pub availability_zones: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Specifies the number of days for which automatic DB snapshots are retained.</p>
    pub backup_retention_period: std::option::Option<i32>,
    /// <p>If present, specifies the name of the character set that this cluster is associated with.</p>
    pub character_set_name: std::option::Option<std::string::String>,
    /// <p>Contains the name of the initial database of this DB cluster that was provided at create time, if one was specified when the DB cluster was created. This same name is returned for the life of the DB cluster.</p>
    pub database_name: std::option::Option<std::string::String>,
    /// <p>Contains a user-supplied DB cluster identifier. This identifier is the unique key that identifies a DB cluster.</p>
    pub db_cluster_identifier: std::option::Option<std::string::String>,
    /// <p>Specifies the name of the DB cluster parameter group for the DB cluster.</p>
    pub db_cluster_parameter_group: std::option::Option<std::string::String>,
    /// <p>Specifies information on the subnet group associated with the DB cluster, including the name, description, and subnets in the subnet group.</p>
    pub db_subnet_group: std::option::Option<std::string::String>,
    /// <p>Specifies the current state of this DB cluster.</p>
    pub status: std::option::Option<std::string::String>,
    /// <p>The time when a stopped DB cluster is restarted automatically.</p>
    pub automatic_restart_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Specifies the progress of the operation as a percentage.</p>
    pub percent_progress: std::option::Option<std::string::String>,
    /// <p>The earliest time to which a database can be restored with point-in-time restore.</p>
    pub earliest_restorable_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Specifies the connection endpoint for the primary instance of the DB cluster.</p>
    pub endpoint: std::option::Option<std::string::String>,
    /// <p>The reader endpoint for the DB cluster. The reader endpoint for a DB cluster load-balances connections across the Aurora Replicas that are available in a DB cluster. As clients request new connections to the reader endpoint, Aurora distributes the connection requests among the Aurora Replicas in the DB cluster. This functionality can help balance your read workload across multiple Aurora Replicas in your DB cluster. </p>
    /// <p>If a failover occurs, and the Aurora Replica that you are connected to is promoted to be the primary instance, your connection is dropped. To continue sending your read workload to other Aurora Replicas in the cluster, you can then reconnect to the reader endpoint.</p>
    pub reader_endpoint: std::option::Option<std::string::String>,
    /// <p>Identifies all custom endpoints associated with the cluster.</p>
    pub custom_endpoints: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Specifies whether the DB cluster has instances in multiple Availability Zones.</p>
    pub multi_az: std::option::Option<bool>,
    /// <p>The name of the database engine to be used for this DB cluster.</p>
    pub engine: std::option::Option<std::string::String>,
    /// <p>Indicates the database engine version.</p>
    pub engine_version: std::option::Option<std::string::String>,
    /// <p>Specifies the latest time to which a database can be restored with point-in-time restore.</p>
    pub latest_restorable_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Specifies the port that the database engine is listening on.</p>
    pub port: std::option::Option<i32>,
    /// <p>Contains the master username for the DB cluster.</p>
    pub master_username: std::option::Option<std::string::String>,
    /// <p>Provides the list of option group memberships for this DB cluster.</p>
    pub db_cluster_option_group_memberships:
        std::option::Option<std::vec::Vec<crate::model::DbClusterOptionGroupStatus>>,
    /// <p>Specifies the daily time range during which automated backups are created if automated backups are enabled, as determined by the <code>BackupRetentionPeriod</code>. </p>
    pub preferred_backup_window: std::option::Option<std::string::String>,
    /// <p>Specifies the weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).</p>
    pub preferred_maintenance_window: std::option::Option<std::string::String>,
    /// <p>Contains the identifier of the source DB cluster if this DB cluster is a read replica.</p>
    pub replication_source_identifier: std::option::Option<std::string::String>,
    /// <p>Contains one or more identifiers of the read replicas associated with this DB cluster.</p>
    pub read_replica_identifiers: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Provides the list of instances that make up the DB cluster.</p>
    pub db_cluster_members: std::option::Option<std::vec::Vec<crate::model::DbClusterMember>>,
    /// <p>Provides a list of VPC security groups that the DB cluster belongs to.</p>
    pub vpc_security_groups:
        std::option::Option<std::vec::Vec<crate::model::VpcSecurityGroupMembership>>,
    /// <p>Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.</p>
    pub hosted_zone_id: std::option::Option<std::string::String>,
    /// <p>Specifies whether the DB cluster is encrypted.</p>
    pub storage_encrypted: bool,
    /// <p>If <code>StorageEncrypted</code> is enabled, the Amazon Web Services KMS key identifier for the encrypted DB cluster.</p>
    /// <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.</p>
    pub kms_key_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services Region-unique, immutable identifier for the DB cluster. This identifier is found in Amazon Web Services CloudTrail log entries whenever the KMS key for the DB cluster is accessed.</p>
    pub db_cluster_resource_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) for the DB cluster.</p>
    pub db_cluster_arn: std::option::Option<std::string::String>,
    /// <p>Provides a list of the Amazon Web Services Identity and Access Management (IAM) roles that are associated with the DB cluster. IAM roles that are associated with a DB cluster grant permission for the DB cluster to access other Amazon Web Services on your behalf.</p>
    pub associated_roles: std::option::Option<std::vec::Vec<crate::model::DbClusterRole>>,
    /// <p>A value that indicates whether the mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts is enabled.</p>
    pub iam_database_authentication_enabled: std::option::Option<bool>,
    /// <p>Identifies the clone group to which the DB cluster is associated.</p>
    pub clone_group_id: std::option::Option<std::string::String>,
    /// <p>Specifies the time when the DB cluster was created, in Universal Coordinated Time (UTC).</p>
    pub cluster_create_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The earliest time to which a DB cluster can be backtracked.</p>
    pub earliest_backtrack_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The target backtrack window, in seconds. If this value is set to 0, backtracking is disabled for the DB cluster. Otherwise, backtracking is enabled.</p>
    pub backtrack_window: std::option::Option<i64>,
    /// <p>The number of change records stored for Backtrack.</p>
    pub backtrack_consumed_change_records: std::option::Option<i64>,
    /// <p>A list of log types that this DB cluster is configured to export to CloudWatch Logs.</p>
    /// <p>Log types vary by DB engine. For information about the log types for each DB engine, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html">Amazon RDS Database Log Files</a> in the <i>Amazon Aurora User Guide.</i> </p>
    pub enabled_cloudwatch_logs_exports: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The current capacity of an Aurora Serverless DB cluster. The capacity is 0 (zero) when the cluster is paused.</p>
    /// <p>For more information about Aurora Serverless, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.html">Using Amazon Aurora Serverless</a> in the <i>Amazon Aurora User Guide</i>.</p>
    pub capacity: std::option::Option<i32>,
    /// <p>The DB engine mode of the DB cluster, either <code>provisioned</code>, <code>serverless</code>, <code>parallelquery</code>, <code>global</code>, or <code>multimaster</code>.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBCluster.html"> CreateDBCluster</a>.</p>
    pub engine_mode: std::option::Option<std::string::String>,
    /// <p>Shows the scaling configuration for an Aurora DB cluster in <code>serverless</code> DB engine mode.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.html">Using Amazon Aurora Serverless</a> in the <i>Amazon Aurora User Guide</i>.</p>
    pub scaling_configuration_info: std::option::Option<crate::model::ScalingConfigurationInfo>,
    /// <p>Indicates if the DB cluster has deletion protection enabled. The database can't be deleted when deletion protection is enabled. </p>
    pub deletion_protection: std::option::Option<bool>,
    /// <p>A value that indicates whether the HTTP endpoint for an Aurora Serverless DB cluster is enabled.</p>
    /// <p>When enabled, the HTTP endpoint provides a connectionless web service API for running SQL queries on the Aurora Serverless DB cluster. You can also query your database from inside the RDS console with the query editor.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/data-api.html">Using the Data API for Aurora Serverless</a> in the <i>Amazon Aurora User Guide</i>.</p>
    pub http_endpoint_enabled: std::option::Option<bool>,
    /// <p>The mode of the database activity stream. Database events such as a change or access generate an activity stream event. The database session can handle these events either synchronously or asynchronously. </p>
    pub activity_stream_mode: std::option::Option<crate::model::ActivityStreamMode>,
    /// <p>The status of the database activity stream.</p>
    pub activity_stream_status: std::option::Option<crate::model::ActivityStreamStatus>,
    /// <p>The Amazon Web Services KMS key identifier used for encrypting messages in the database activity stream.</p>
    /// <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.</p>
    pub activity_stream_kms_key_id: std::option::Option<std::string::String>,
    /// <p>The name of the Amazon Kinesis data stream used for the database activity stream.</p>
    pub activity_stream_kinesis_stream_name: std::option::Option<std::string::String>,
    /// <p>Specifies whether tags are copied from the DB cluster to snapshots of the DB cluster.</p>
    pub copy_tags_to_snapshot: std::option::Option<bool>,
    /// <p>Specifies whether the DB cluster is a clone of a DB cluster owned by a different Amazon Web Services account.</p>
    pub cross_account_clone: std::option::Option<bool>,
    /// <p>The Active Directory Domain membership records associated with the DB cluster.</p>
    pub domain_memberships: std::option::Option<std::vec::Vec<crate::model::DomainMembership>>,
    /// <p>A list of tags. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources</a> in the <i>Amazon RDS User Guide.</i> </p>
    pub tag_list: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>Specifies whether a secondary cluster in an Aurora global database has write forwarding enabled, not enabled, or is in the process of enabling it.</p>
    pub global_write_forwarding_status: std::option::Option<crate::model::WriteForwardingStatus>,
    /// <p>Specifies whether you have requested to enable write forwarding for a secondary cluster in an Aurora global database. Because write forwarding takes time to enable, check the value of <code>GlobalWriteForwardingStatus</code> to confirm that the request has completed before using the write forwarding feature for this cluster.</p>
    pub global_write_forwarding_requested: std::option::Option<bool>,
    /// <p>A value that specifies that changes to the DB cluster are pending. This element is only included when changes are pending. Specific changes are identified by subelements.</p>
    pub pending_modified_values: std::option::Option<crate::model::ClusterPendingModifiedValues>,
    /// <p>The name of the compute and memory capacity class of the DB instance.</p>
    /// <p>This setting is only for non-Aurora Multi-AZ DB clusters.</p>
    pub db_cluster_instance_class: std::option::Option<std::string::String>,
    /// <p>The storage type associated with the DB cluster.</p>
    /// <p>This setting is only for non-Aurora Multi-AZ DB clusters.</p>
    pub storage_type: std::option::Option<std::string::String>,
    /// <p>The Provisioned IOPS (I/O operations per second) value.</p>
    /// <p>This setting is only for non-Aurora Multi-AZ DB clusters.</p>
    pub iops: std::option::Option<i32>,
    /// <p>Specifies the accessibility options for the DB instance.</p>
    /// <p>When the DB instance is publicly accessible, its Domain Name System (DNS) endpoint resolves to the private IP address from within the DB instance's virtual private cloud (VPC). It resolves to the public IP address from outside of the DB instance's VPC. Access to the DB instance is ultimately controlled by the security group it uses. That public access is not permitted if the security group assigned to the DB instance doesn't permit it.</p>
    /// <p>When the DB instance isn't publicly accessible, it is an internal DB instance with a DNS name that resolves to a private IP address.</p>
    /// <p>For more information, see <code>CreateDBInstance</code>.</p>
    /// <p>This setting is only for non-Aurora Multi-AZ DB clusters.</p>
    pub publicly_accessible: std::option::Option<bool>,
    /// <p>A value that indicates that minor version patches are applied automatically.</p>
    /// <p>This setting is only for non-Aurora Multi-AZ DB clusters.</p>
    pub auto_minor_version_upgrade: bool,
    /// <p>The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB cluster.</p>
    /// <p>This setting is only for non-Aurora Multi-AZ DB clusters.</p>
    pub monitoring_interval: std::option::Option<i32>,
    /// <p>The ARN for the IAM role that permits RDS to send Enhanced Monitoring metrics to Amazon CloudWatch Logs.</p>
    /// <p>This setting is only for non-Aurora Multi-AZ DB clusters.</p>
    pub monitoring_role_arn: std::option::Option<std::string::String>,
    /// <p>True if Performance Insights is enabled for the DB cluster, and otherwise false.</p>
    /// <p>This setting is only for non-Aurora Multi-AZ DB clusters.</p>
    pub performance_insights_enabled: std::option::Option<bool>,
    /// <p>The Amazon Web Services KMS key identifier for encryption of Performance Insights data.</p>
    /// <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.</p>
    /// <p>This setting is only for non-Aurora Multi-AZ DB clusters.</p>
    pub performance_insights_kms_key_id: std::option::Option<std::string::String>,
    /// <p>The amount of time, in days, to retain Performance Insights data. Valid values are 7 or 731 (2 years).</p>
    /// <p>This setting is only for non-Aurora Multi-AZ DB clusters.</p>
    pub performance_insights_retention_period: std::option::Option<i32>,
}
impl DbCluster {
    /// <p>For all database engines except Amazon Aurora, <code>AllocatedStorage</code> specifies the allocated storage size in gibibytes (GiB). For Aurora, <code>AllocatedStorage</code> always returns 1, because Aurora DB cluster storage size isn't fixed, but instead automatically adjusts as needed.</p>
    pub fn allocated_storage(&self) -> std::option::Option<i32> {
        self.allocated_storage
    }
    /// <p>Provides the list of Availability Zones (AZs) where instances in the DB cluster can be created.</p>
    pub fn availability_zones(&self) -> std::option::Option<&[std::string::String]> {
        self.availability_zones.as_deref()
    }
    /// <p>Specifies the number of days for which automatic DB snapshots are retained.</p>
    pub fn backup_retention_period(&self) -> std::option::Option<i32> {
        self.backup_retention_period
    }
    /// <p>If present, specifies the name of the character set that this cluster is associated with.</p>
    pub fn character_set_name(&self) -> std::option::Option<&str> {
        self.character_set_name.as_deref()
    }
    /// <p>Contains the name of the initial database of this DB cluster that was provided at create time, if one was specified when the DB cluster was created. This same name is returned for the life of the DB cluster.</p>
    pub fn database_name(&self) -> std::option::Option<&str> {
        self.database_name.as_deref()
    }
    /// <p>Contains a user-supplied DB cluster identifier. This identifier is the unique key that identifies a DB cluster.</p>
    pub fn db_cluster_identifier(&self) -> std::option::Option<&str> {
        self.db_cluster_identifier.as_deref()
    }
    /// <p>Specifies the name of the DB cluster parameter group for the DB cluster.</p>
    pub fn db_cluster_parameter_group(&self) -> std::option::Option<&str> {
        self.db_cluster_parameter_group.as_deref()
    }
    /// <p>Specifies information on the subnet group associated with the DB cluster, including the name, description, and subnets in the subnet group.</p>
    pub fn db_subnet_group(&self) -> std::option::Option<&str> {
        self.db_subnet_group.as_deref()
    }
    /// <p>Specifies the current state of this DB cluster.</p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>The time when a stopped DB cluster is restarted automatically.</p>
    pub fn automatic_restart_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.automatic_restart_time.as_ref()
    }
    /// <p>Specifies the progress of the operation as a percentage.</p>
    pub fn percent_progress(&self) -> std::option::Option<&str> {
        self.percent_progress.as_deref()
    }
    /// <p>The earliest time to which a database can be restored with point-in-time restore.</p>
    pub fn earliest_restorable_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.earliest_restorable_time.as_ref()
    }
    /// <p>Specifies the connection endpoint for the primary instance of the DB cluster.</p>
    pub fn endpoint(&self) -> std::option::Option<&str> {
        self.endpoint.as_deref()
    }
    /// <p>The reader endpoint for the DB cluster. The reader endpoint for a DB cluster load-balances connections across the Aurora Replicas that are available in a DB cluster. As clients request new connections to the reader endpoint, Aurora distributes the connection requests among the Aurora Replicas in the DB cluster. This functionality can help balance your read workload across multiple Aurora Replicas in your DB cluster. </p>
    /// <p>If a failover occurs, and the Aurora Replica that you are connected to is promoted to be the primary instance, your connection is dropped. To continue sending your read workload to other Aurora Replicas in the cluster, you can then reconnect to the reader endpoint.</p>
    pub fn reader_endpoint(&self) -> std::option::Option<&str> {
        self.reader_endpoint.as_deref()
    }
    /// <p>Identifies all custom endpoints associated with the cluster.</p>
    pub fn custom_endpoints(&self) -> std::option::Option<&[std::string::String]> {
        self.custom_endpoints.as_deref()
    }
    /// <p>Specifies whether the DB cluster has instances in multiple Availability Zones.</p>
    pub fn multi_az(&self) -> std::option::Option<bool> {
        self.multi_az
    }
    /// <p>The name of the database engine to be used for this DB cluster.</p>
    pub fn engine(&self) -> std::option::Option<&str> {
        self.engine.as_deref()
    }
    /// <p>Indicates the database engine version.</p>
    pub fn engine_version(&self) -> std::option::Option<&str> {
        self.engine_version.as_deref()
    }
    /// <p>Specifies the latest time to which a database can be restored with point-in-time restore.</p>
    pub fn latest_restorable_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.latest_restorable_time.as_ref()
    }
    /// <p>Specifies the port that the database engine is listening on.</p>
    pub fn port(&self) -> std::option::Option<i32> {
        self.port
    }
    /// <p>Contains the master username for the DB cluster.</p>
    pub fn master_username(&self) -> std::option::Option<&str> {
        self.master_username.as_deref()
    }
    /// <p>Provides the list of option group memberships for this DB cluster.</p>
    pub fn db_cluster_option_group_memberships(
        &self,
    ) -> std::option::Option<&[crate::model::DbClusterOptionGroupStatus]> {
        self.db_cluster_option_group_memberships.as_deref()
    }
    /// <p>Specifies the daily time range during which automated backups are created if automated backups are enabled, as determined by the <code>BackupRetentionPeriod</code>. </p>
    pub fn preferred_backup_window(&self) -> std::option::Option<&str> {
        self.preferred_backup_window.as_deref()
    }
    /// <p>Specifies the weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).</p>
    pub fn preferred_maintenance_window(&self) -> std::option::Option<&str> {
        self.preferred_maintenance_window.as_deref()
    }
    /// <p>Contains the identifier of the source DB cluster if this DB cluster is a read replica.</p>
    pub fn replication_source_identifier(&self) -> std::option::Option<&str> {
        self.replication_source_identifier.as_deref()
    }
    /// <p>Contains one or more identifiers of the read replicas associated with this DB cluster.</p>
    pub fn read_replica_identifiers(&self) -> std::option::Option<&[std::string::String]> {
        self.read_replica_identifiers.as_deref()
    }
    /// <p>Provides the list of instances that make up the DB cluster.</p>
    pub fn db_cluster_members(&self) -> std::option::Option<&[crate::model::DbClusterMember]> {
        self.db_cluster_members.as_deref()
    }
    /// <p>Provides a list of VPC security groups that the DB cluster belongs to.</p>
    pub fn vpc_security_groups(
        &self,
    ) -> std::option::Option<&[crate::model::VpcSecurityGroupMembership]> {
        self.vpc_security_groups.as_deref()
    }
    /// <p>Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.</p>
    pub fn hosted_zone_id(&self) -> std::option::Option<&str> {
        self.hosted_zone_id.as_deref()
    }
    /// <p>Specifies whether the DB cluster is encrypted.</p>
    pub fn storage_encrypted(&self) -> bool {
        self.storage_encrypted
    }
    /// <p>If <code>StorageEncrypted</code> is enabled, the Amazon Web Services KMS key identifier for the encrypted DB cluster.</p>
    /// <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.</p>
    pub fn kms_key_id(&self) -> std::option::Option<&str> {
        self.kms_key_id.as_deref()
    }
    /// <p>The Amazon Web Services Region-unique, immutable identifier for the DB cluster. This identifier is found in Amazon Web Services CloudTrail log entries whenever the KMS key for the DB cluster is accessed.</p>
    pub fn db_cluster_resource_id(&self) -> std::option::Option<&str> {
        self.db_cluster_resource_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) for the DB cluster.</p>
    pub fn db_cluster_arn(&self) -> std::option::Option<&str> {
        self.db_cluster_arn.as_deref()
    }
    /// <p>Provides a list of the Amazon Web Services Identity and Access Management (IAM) roles that are associated with the DB cluster. IAM roles that are associated with a DB cluster grant permission for the DB cluster to access other Amazon Web Services on your behalf.</p>
    pub fn associated_roles(&self) -> std::option::Option<&[crate::model::DbClusterRole]> {
        self.associated_roles.as_deref()
    }
    /// <p>A value that indicates whether the mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts is enabled.</p>
    pub fn iam_database_authentication_enabled(&self) -> std::option::Option<bool> {
        self.iam_database_authentication_enabled
    }
    /// <p>Identifies the clone group to which the DB cluster is associated.</p>
    pub fn clone_group_id(&self) -> std::option::Option<&str> {
        self.clone_group_id.as_deref()
    }
    /// <p>Specifies the time when the DB cluster was created, in Universal Coordinated Time (UTC).</p>
    pub fn cluster_create_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.cluster_create_time.as_ref()
    }
    /// <p>The earliest time to which a DB cluster can be backtracked.</p>
    pub fn earliest_backtrack_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.earliest_backtrack_time.as_ref()
    }
    /// <p>The target backtrack window, in seconds. If this value is set to 0, backtracking is disabled for the DB cluster. Otherwise, backtracking is enabled.</p>
    pub fn backtrack_window(&self) -> std::option::Option<i64> {
        self.backtrack_window
    }
    /// <p>The number of change records stored for Backtrack.</p>
    pub fn backtrack_consumed_change_records(&self) -> std::option::Option<i64> {
        self.backtrack_consumed_change_records
    }
    /// <p>A list of log types that this DB cluster is configured to export to CloudWatch Logs.</p>
    /// <p>Log types vary by DB engine. For information about the log types for each DB engine, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html">Amazon RDS Database Log Files</a> in the <i>Amazon Aurora User Guide.</i> </p>
    pub fn enabled_cloudwatch_logs_exports(&self) -> std::option::Option<&[std::string::String]> {
        self.enabled_cloudwatch_logs_exports.as_deref()
    }
    /// <p>The current capacity of an Aurora Serverless DB cluster. The capacity is 0 (zero) when the cluster is paused.</p>
    /// <p>For more information about Aurora Serverless, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.html">Using Amazon Aurora Serverless</a> in the <i>Amazon Aurora User Guide</i>.</p>
    pub fn capacity(&self) -> std::option::Option<i32> {
        self.capacity
    }
    /// <p>The DB engine mode of the DB cluster, either <code>provisioned</code>, <code>serverless</code>, <code>parallelquery</code>, <code>global</code>, or <code>multimaster</code>.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBCluster.html"> CreateDBCluster</a>.</p>
    pub fn engine_mode(&self) -> std::option::Option<&str> {
        self.engine_mode.as_deref()
    }
    /// <p>Shows the scaling configuration for an Aurora DB cluster in <code>serverless</code> DB engine mode.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.html">Using Amazon Aurora Serverless</a> in the <i>Amazon Aurora User Guide</i>.</p>
    pub fn scaling_configuration_info(
        &self,
    ) -> std::option::Option<&crate::model::ScalingConfigurationInfo> {
        self.scaling_configuration_info.as_ref()
    }
    /// <p>Indicates if the DB cluster has deletion protection enabled. The database can't be deleted when deletion protection is enabled. </p>
    pub fn deletion_protection(&self) -> std::option::Option<bool> {
        self.deletion_protection
    }
    /// <p>A value that indicates whether the HTTP endpoint for an Aurora Serverless DB cluster is enabled.</p>
    /// <p>When enabled, the HTTP endpoint provides a connectionless web service API for running SQL queries on the Aurora Serverless DB cluster. You can also query your database from inside the RDS console with the query editor.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/data-api.html">Using the Data API for Aurora Serverless</a> in the <i>Amazon Aurora User Guide</i>.</p>
    pub fn http_endpoint_enabled(&self) -> std::option::Option<bool> {
        self.http_endpoint_enabled
    }
    /// <p>The mode of the database activity stream. Database events such as a change or access generate an activity stream event. The database session can handle these events either synchronously or asynchronously. </p>
    pub fn activity_stream_mode(&self) -> std::option::Option<&crate::model::ActivityStreamMode> {
        self.activity_stream_mode.as_ref()
    }
    /// <p>The status of the database activity stream.</p>
    pub fn activity_stream_status(
        &self,
    ) -> std::option::Option<&crate::model::ActivityStreamStatus> {
        self.activity_stream_status.as_ref()
    }
    /// <p>The Amazon Web Services KMS key identifier used for encrypting messages in the database activity stream.</p>
    /// <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.</p>
    pub fn activity_stream_kms_key_id(&self) -> std::option::Option<&str> {
        self.activity_stream_kms_key_id.as_deref()
    }
    /// <p>The name of the Amazon Kinesis data stream used for the database activity stream.</p>
    pub fn activity_stream_kinesis_stream_name(&self) -> std::option::Option<&str> {
        self.activity_stream_kinesis_stream_name.as_deref()
    }
    /// <p>Specifies whether tags are copied from the DB cluster to snapshots of the DB cluster.</p>
    pub fn copy_tags_to_snapshot(&self) -> std::option::Option<bool> {
        self.copy_tags_to_snapshot
    }
    /// <p>Specifies whether the DB cluster is a clone of a DB cluster owned by a different Amazon Web Services account.</p>
    pub fn cross_account_clone(&self) -> std::option::Option<bool> {
        self.cross_account_clone
    }
    /// <p>The Active Directory Domain membership records associated with the DB cluster.</p>
    pub fn domain_memberships(&self) -> std::option::Option<&[crate::model::DomainMembership]> {
        self.domain_memberships.as_deref()
    }
    /// <p>A list of tags. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources</a> in the <i>Amazon RDS User Guide.</i> </p>
    pub fn tag_list(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tag_list.as_deref()
    }
    /// <p>Specifies whether a secondary cluster in an Aurora global database has write forwarding enabled, not enabled, or is in the process of enabling it.</p>
    pub fn global_write_forwarding_status(
        &self,
    ) -> std::option::Option<&crate::model::WriteForwardingStatus> {
        self.global_write_forwarding_status.as_ref()
    }
    /// <p>Specifies whether you have requested to enable write forwarding for a secondary cluster in an Aurora global database. Because write forwarding takes time to enable, check the value of <code>GlobalWriteForwardingStatus</code> to confirm that the request has completed before using the write forwarding feature for this cluster.</p>
    pub fn global_write_forwarding_requested(&self) -> std::option::Option<bool> {
        self.global_write_forwarding_requested
    }
    /// <p>A value that specifies that changes to the DB cluster are pending. This element is only included when changes are pending. Specific changes are identified by subelements.</p>
    pub fn pending_modified_values(
        &self,
    ) -> std::option::Option<&crate::model::ClusterPendingModifiedValues> {
        self.pending_modified_values.as_ref()
    }
    /// <p>The name of the compute and memory capacity class of the DB instance.</p>
    /// <p>This setting is only for non-Aurora Multi-AZ DB clusters.</p>
    pub fn db_cluster_instance_class(&self) -> std::option::Option<&str> {
        self.db_cluster_instance_class.as_deref()
    }
    /// <p>The storage type associated with the DB cluster.</p>
    /// <p>This setting is only for non-Aurora Multi-AZ DB clusters.</p>
    pub fn storage_type(&self) -> std::option::Option<&str> {
        self.storage_type.as_deref()
    }
    /// <p>The Provisioned IOPS (I/O operations per second) value.</p>
    /// <p>This setting is only for non-Aurora Multi-AZ DB clusters.</p>
    pub fn iops(&self) -> std::option::Option<i32> {
        self.iops
    }
    /// <p>Specifies the accessibility options for the DB instance.</p>
    /// <p>When the DB instance is publicly accessible, its Domain Name System (DNS) endpoint resolves to the private IP address from within the DB instance's virtual private cloud (VPC). It resolves to the public IP address from outside of the DB instance's VPC. Access to the DB instance is ultimately controlled by the security group it uses. That public access is not permitted if the security group assigned to the DB instance doesn't permit it.</p>
    /// <p>When the DB instance isn't publicly accessible, it is an internal DB instance with a DNS name that resolves to a private IP address.</p>
    /// <p>For more information, see <code>CreateDBInstance</code>.</p>
    /// <p>This setting is only for non-Aurora Multi-AZ DB clusters.</p>
    pub fn publicly_accessible(&self) -> std::option::Option<bool> {
        self.publicly_accessible
    }
    /// <p>A value that indicates that minor version patches are applied automatically.</p>
    /// <p>This setting is only for non-Aurora Multi-AZ DB clusters.</p>
    pub fn auto_minor_version_upgrade(&self) -> bool {
        self.auto_minor_version_upgrade
    }
    /// <p>The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB cluster.</p>
    /// <p>This setting is only for non-Aurora Multi-AZ DB clusters.</p>
    pub fn monitoring_interval(&self) -> std::option::Option<i32> {
        self.monitoring_interval
    }
    /// <p>The ARN for the IAM role that permits RDS to send Enhanced Monitoring metrics to Amazon CloudWatch Logs.</p>
    /// <p>This setting is only for non-Aurora Multi-AZ DB clusters.</p>
    pub fn monitoring_role_arn(&self) -> std::option::Option<&str> {
        self.monitoring_role_arn.as_deref()
    }
    /// <p>True if Performance Insights is enabled for the DB cluster, and otherwise false.</p>
    /// <p>This setting is only for non-Aurora Multi-AZ DB clusters.</p>
    pub fn performance_insights_enabled(&self) -> std::option::Option<bool> {
        self.performance_insights_enabled
    }
    /// <p>The Amazon Web Services KMS key identifier for encryption of Performance Insights data.</p>
    /// <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.</p>
    /// <p>This setting is only for non-Aurora Multi-AZ DB clusters.</p>
    pub fn performance_insights_kms_key_id(&self) -> std::option::Option<&str> {
        self.performance_insights_kms_key_id.as_deref()
    }
    /// <p>The amount of time, in days, to retain Performance Insights data. Valid values are 7 or 731 (2 years).</p>
    /// <p>This setting is only for non-Aurora Multi-AZ DB clusters.</p>
    pub fn performance_insights_retention_period(&self) -> std::option::Option<i32> {
        self.performance_insights_retention_period
    }
}
impl std::fmt::Debug for DbCluster {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DbCluster");
        formatter.field("allocated_storage", &self.allocated_storage);
        formatter.field("availability_zones", &self.availability_zones);
        formatter.field("backup_retention_period", &self.backup_retention_period);
        formatter.field("character_set_name", &self.character_set_name);
        formatter.field("database_name", &self.database_name);
        formatter.field("db_cluster_identifier", &self.db_cluster_identifier);
        formatter.field(
            "db_cluster_parameter_group",
            &self.db_cluster_parameter_group,
        );
        formatter.field("db_subnet_group", &self.db_subnet_group);
        formatter.field("status", &self.status);
        formatter.field("automatic_restart_time", &self.automatic_restart_time);
        formatter.field("percent_progress", &self.percent_progress);
        formatter.field("earliest_restorable_time", &self.earliest_restorable_time);
        formatter.field("endpoint", &self.endpoint);
        formatter.field("reader_endpoint", &self.reader_endpoint);
        formatter.field("custom_endpoints", &self.custom_endpoints);
        formatter.field("multi_az", &self.multi_az);
        formatter.field("engine", &self.engine);
        formatter.field("engine_version", &self.engine_version);
        formatter.field("latest_restorable_time", &self.latest_restorable_time);
        formatter.field("port", &self.port);
        formatter.field("master_username", &self.master_username);
        formatter.field(
            "db_cluster_option_group_memberships",
            &self.db_cluster_option_group_memberships,
        );
        formatter.field("preferred_backup_window", &self.preferred_backup_window);
        formatter.field(
            "preferred_maintenance_window",
            &self.preferred_maintenance_window,
        );
        formatter.field(
            "replication_source_identifier",
            &self.replication_source_identifier,
        );
        formatter.field("read_replica_identifiers", &self.read_replica_identifiers);
        formatter.field("db_cluster_members", &self.db_cluster_members);
        formatter.field("vpc_security_groups", &self.vpc_security_groups);
        formatter.field("hosted_zone_id", &self.hosted_zone_id);
        formatter.field("storage_encrypted", &self.storage_encrypted);
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.field("db_cluster_resource_id", &self.db_cluster_resource_id);
        formatter.field("db_cluster_arn", &self.db_cluster_arn);
        formatter.field("associated_roles", &self.associated_roles);
        formatter.field(
            "iam_database_authentication_enabled",
            &self.iam_database_authentication_enabled,
        );
        formatter.field("clone_group_id", &self.clone_group_id);
        formatter.field("cluster_create_time", &self.cluster_create_time);
        formatter.field("earliest_backtrack_time", &self.earliest_backtrack_time);
        formatter.field("backtrack_window", &self.backtrack_window);
        formatter.field(
            "backtrack_consumed_change_records",
            &self.backtrack_consumed_change_records,
        );
        formatter.field(
            "enabled_cloudwatch_logs_exports",
            &self.enabled_cloudwatch_logs_exports,
        );
        formatter.field("capacity", &self.capacity);
        formatter.field("engine_mode", &self.engine_mode);
        formatter.field(
            "scaling_configuration_info",
            &self.scaling_configuration_info,
        );
        formatter.field("deletion_protection", &self.deletion_protection);
        formatter.field("http_endpoint_enabled", &self.http_endpoint_enabled);
        formatter.field("activity_stream_mode", &self.activity_stream_mode);
        formatter.field("activity_stream_status", &self.activity_stream_status);
        formatter.field(
            "activity_stream_kms_key_id",
            &self.activity_stream_kms_key_id,
        );
        formatter.field(
            "activity_stream_kinesis_stream_name",
            &self.activity_stream_kinesis_stream_name,
        );
        formatter.field("copy_tags_to_snapshot", &self.copy_tags_to_snapshot);
        formatter.field("cross_account_clone", &self.cross_account_clone);
        formatter.field("domain_memberships", &self.domain_memberships);
        formatter.field("tag_list", &self.tag_list);
        formatter.field(
            "global_write_forwarding_status",
            &self.global_write_forwarding_status,
        );
        formatter.field(
            "global_write_forwarding_requested",
            &self.global_write_forwarding_requested,
        );
        formatter.field("pending_modified_values", &self.pending_modified_values);
        formatter.field("db_cluster_instance_class", &self.db_cluster_instance_class);
        formatter.field("storage_type", &self.storage_type);
        formatter.field("iops", &self.iops);
        formatter.field("publicly_accessible", &self.publicly_accessible);
        formatter.field(
            "auto_minor_version_upgrade",
            &self.auto_minor_version_upgrade,
        );
        formatter.field("monitoring_interval", &self.monitoring_interval);
        formatter.field("monitoring_role_arn", &self.monitoring_role_arn);
        formatter.field(
            "performance_insights_enabled",
            &self.performance_insights_enabled,
        );
        formatter.field(
            "performance_insights_kms_key_id",
            &self.performance_insights_kms_key_id,
        );
        formatter.field(
            "performance_insights_retention_period",
            &self.performance_insights_retention_period,
        );
        formatter.finish()
    }
}
/// See [`DbCluster`](crate::model::DbCluster)
pub mod db_cluster {
    /// A builder for [`DbCluster`](crate::model::DbCluster)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) allocated_storage: std::option::Option<i32>,
        pub(crate) availability_zones: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) backup_retention_period: std::option::Option<i32>,
        pub(crate) character_set_name: std::option::Option<std::string::String>,
        pub(crate) database_name: std::option::Option<std::string::String>,
        pub(crate) db_cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) db_cluster_parameter_group: std::option::Option<std::string::String>,
        pub(crate) db_subnet_group: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) automatic_restart_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) percent_progress: std::option::Option<std::string::String>,
        pub(crate) earliest_restorable_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) endpoint: std::option::Option<std::string::String>,
        pub(crate) reader_endpoint: std::option::Option<std::string::String>,
        pub(crate) custom_endpoints: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) multi_az: std::option::Option<bool>,
        pub(crate) engine: std::option::Option<std::string::String>,
        pub(crate) engine_version: std::option::Option<std::string::String>,
        pub(crate) latest_restorable_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) port: std::option::Option<i32>,
        pub(crate) master_username: std::option::Option<std::string::String>,
        pub(crate) db_cluster_option_group_memberships:
            std::option::Option<std::vec::Vec<crate::model::DbClusterOptionGroupStatus>>,
        pub(crate) preferred_backup_window: std::option::Option<std::string::String>,
        pub(crate) preferred_maintenance_window: std::option::Option<std::string::String>,
        pub(crate) replication_source_identifier: std::option::Option<std::string::String>,
        pub(crate) read_replica_identifiers:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) db_cluster_members:
            std::option::Option<std::vec::Vec<crate::model::DbClusterMember>>,
        pub(crate) vpc_security_groups:
            std::option::Option<std::vec::Vec<crate::model::VpcSecurityGroupMembership>>,
        pub(crate) hosted_zone_id: std::option::Option<std::string::String>,
        pub(crate) storage_encrypted: std::option::Option<bool>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
        pub(crate) db_cluster_resource_id: std::option::Option<std::string::String>,
        pub(crate) db_cluster_arn: std::option::Option<std::string::String>,
        pub(crate) associated_roles:
            std::option::Option<std::vec::Vec<crate::model::DbClusterRole>>,
        pub(crate) iam_database_authentication_enabled: std::option::Option<bool>,
        pub(crate) clone_group_id: std::option::Option<std::string::String>,
        pub(crate) cluster_create_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) earliest_backtrack_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) backtrack_window: std::option::Option<i64>,
        pub(crate) backtrack_consumed_change_records: std::option::Option<i64>,
        pub(crate) enabled_cloudwatch_logs_exports:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) capacity: std::option::Option<i32>,
        pub(crate) engine_mode: std::option::Option<std::string::String>,
        pub(crate) scaling_configuration_info:
            std::option::Option<crate::model::ScalingConfigurationInfo>,
        pub(crate) deletion_protection: std::option::Option<bool>,
        pub(crate) http_endpoint_enabled: std::option::Option<bool>,
        pub(crate) activity_stream_mode: std::option::Option<crate::model::ActivityStreamMode>,
        pub(crate) activity_stream_status: std::option::Option<crate::model::ActivityStreamStatus>,
        pub(crate) activity_stream_kms_key_id: std::option::Option<std::string::String>,
        pub(crate) activity_stream_kinesis_stream_name: std::option::Option<std::string::String>,
        pub(crate) copy_tags_to_snapshot: std::option::Option<bool>,
        pub(crate) cross_account_clone: std::option::Option<bool>,
        pub(crate) domain_memberships:
            std::option::Option<std::vec::Vec<crate::model::DomainMembership>>,
        pub(crate) tag_list: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) global_write_forwarding_status:
            std::option::Option<crate::model::WriteForwardingStatus>,
        pub(crate) global_write_forwarding_requested: std::option::Option<bool>,
        pub(crate) pending_modified_values:
            std::option::Option<crate::model::ClusterPendingModifiedValues>,
        pub(crate) db_cluster_instance_class: std::option::Option<std::string::String>,
        pub(crate) storage_type: std::option::Option<std::string::String>,
        pub(crate) iops: std::option::Option<i32>,
        pub(crate) publicly_accessible: std::option::Option<bool>,
        pub(crate) auto_minor_version_upgrade: std::option::Option<bool>,
        pub(crate) monitoring_interval: std::option::Option<i32>,
        pub(crate) monitoring_role_arn: std::option::Option<std::string::String>,
        pub(crate) performance_insights_enabled: std::option::Option<bool>,
        pub(crate) performance_insights_kms_key_id: std::option::Option<std::string::String>,
        pub(crate) performance_insights_retention_period: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>For all database engines except Amazon Aurora, <code>AllocatedStorage</code> specifies the allocated storage size in gibibytes (GiB). For Aurora, <code>AllocatedStorage</code> always returns 1, because Aurora DB cluster storage size isn't fixed, but instead automatically adjusts as needed.</p>
        pub fn allocated_storage(mut self, input: i32) -> Self {
            self.allocated_storage = Some(input);
            self
        }
        /// <p>For all database engines except Amazon Aurora, <code>AllocatedStorage</code> specifies the allocated storage size in gibibytes (GiB). For Aurora, <code>AllocatedStorage</code> always returns 1, because Aurora DB cluster storage size isn't fixed, but instead automatically adjusts as needed.</p>
        pub fn set_allocated_storage(mut self, input: std::option::Option<i32>) -> Self {
            self.allocated_storage = input;
            self
        }
        /// Appends an item to `availability_zones`.
        ///
        /// To override the contents of this collection use [`set_availability_zones`](Self::set_availability_zones).
        ///
        /// <p>Provides the list of Availability Zones (AZs) where instances in the DB cluster can be created.</p>
        pub fn availability_zones(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.availability_zones.unwrap_or_default();
            v.push(input.into());
            self.availability_zones = Some(v);
            self
        }
        /// <p>Provides the list of Availability Zones (AZs) where instances in the DB cluster can be created.</p>
        pub fn set_availability_zones(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.availability_zones = input;
            self
        }
        /// <p>Specifies the number of days for which automatic DB snapshots are retained.</p>
        pub fn backup_retention_period(mut self, input: i32) -> Self {
            self.backup_retention_period = Some(input);
            self
        }
        /// <p>Specifies the number of days for which automatic DB snapshots are retained.</p>
        pub fn set_backup_retention_period(mut self, input: std::option::Option<i32>) -> Self {
            self.backup_retention_period = input;
            self
        }
        /// <p>If present, specifies the name of the character set that this cluster is associated with.</p>
        pub fn character_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.character_set_name = Some(input.into());
            self
        }
        /// <p>If present, specifies the name of the character set that this cluster is associated with.</p>
        pub fn set_character_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.character_set_name = input;
            self
        }
        /// <p>Contains the name of the initial database of this DB cluster that was provided at create time, if one was specified when the DB cluster was created. This same name is returned for the life of the DB cluster.</p>
        pub fn database_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.database_name = Some(input.into());
            self
        }
        /// <p>Contains the name of the initial database of this DB cluster that was provided at create time, if one was specified when the DB cluster was created. This same name is returned for the life of the DB cluster.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.database_name = input;
            self
        }
        /// <p>Contains a user-supplied DB cluster identifier. This identifier is the unique key that identifies a DB cluster.</p>
        pub fn db_cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_cluster_identifier = Some(input.into());
            self
        }
        /// <p>Contains a user-supplied DB cluster identifier. This identifier is the unique key that identifies a DB cluster.</p>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_identifier = input;
            self
        }
        /// <p>Specifies the name of the DB cluster parameter group for the DB cluster.</p>
        pub fn db_cluster_parameter_group(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_cluster_parameter_group = Some(input.into());
            self
        }
        /// <p>Specifies the name of the DB cluster parameter group for the DB cluster.</p>
        pub fn set_db_cluster_parameter_group(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_parameter_group = input;
            self
        }
        /// <p>Specifies information on the subnet group associated with the DB cluster, including the name, description, and subnets in the subnet group.</p>
        pub fn db_subnet_group(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_subnet_group = Some(input.into());
            self
        }
        /// <p>Specifies information on the subnet group associated with the DB cluster, including the name, description, and subnets in the subnet group.</p>
        pub fn set_db_subnet_group(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_subnet_group = input;
            self
        }
        /// <p>Specifies the current state of this DB cluster.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>Specifies the current state of this DB cluster.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>The time when a stopped DB cluster is restarted automatically.</p>
        pub fn automatic_restart_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.automatic_restart_time = Some(input);
            self
        }
        /// <p>The time when a stopped DB cluster is restarted automatically.</p>
        pub fn set_automatic_restart_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.automatic_restart_time = input;
            self
        }
        /// <p>Specifies the progress of the operation as a percentage.</p>
        pub fn percent_progress(mut self, input: impl Into<std::string::String>) -> Self {
            self.percent_progress = Some(input.into());
            self
        }
        /// <p>Specifies the progress of the operation as a percentage.</p>
        pub fn set_percent_progress(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.percent_progress = input;
            self
        }
        /// <p>The earliest time to which a database can be restored with point-in-time restore.</p>
        pub fn earliest_restorable_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.earliest_restorable_time = Some(input);
            self
        }
        /// <p>The earliest time to which a database can be restored with point-in-time restore.</p>
        pub fn set_earliest_restorable_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.earliest_restorable_time = input;
            self
        }
        /// <p>Specifies the connection endpoint for the primary instance of the DB cluster.</p>
        pub fn endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint = Some(input.into());
            self
        }
        /// <p>Specifies the connection endpoint for the primary instance of the DB cluster.</p>
        pub fn set_endpoint(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.endpoint = input;
            self
        }
        /// <p>The reader endpoint for the DB cluster. The reader endpoint for a DB cluster load-balances connections across the Aurora Replicas that are available in a DB cluster. As clients request new connections to the reader endpoint, Aurora distributes the connection requests among the Aurora Replicas in the DB cluster. This functionality can help balance your read workload across multiple Aurora Replicas in your DB cluster. </p>
        /// <p>If a failover occurs, and the Aurora Replica that you are connected to is promoted to be the primary instance, your connection is dropped. To continue sending your read workload to other Aurora Replicas in the cluster, you can then reconnect to the reader endpoint.</p>
        pub fn reader_endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.reader_endpoint = Some(input.into());
            self
        }
        /// <p>The reader endpoint for the DB cluster. The reader endpoint for a DB cluster load-balances connections across the Aurora Replicas that are available in a DB cluster. As clients request new connections to the reader endpoint, Aurora distributes the connection requests among the Aurora Replicas in the DB cluster. This functionality can help balance your read workload across multiple Aurora Replicas in your DB cluster. </p>
        /// <p>If a failover occurs, and the Aurora Replica that you are connected to is promoted to be the primary instance, your connection is dropped. To continue sending your read workload to other Aurora Replicas in the cluster, you can then reconnect to the reader endpoint.</p>
        pub fn set_reader_endpoint(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.reader_endpoint = input;
            self
        }
        /// Appends an item to `custom_endpoints`.
        ///
        /// To override the contents of this collection use [`set_custom_endpoints`](Self::set_custom_endpoints).
        ///
        /// <p>Identifies all custom endpoints associated with the cluster.</p>
        pub fn custom_endpoints(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.custom_endpoints.unwrap_or_default();
            v.push(input.into());
            self.custom_endpoints = Some(v);
            self
        }
        /// <p>Identifies all custom endpoints associated with the cluster.</p>
        pub fn set_custom_endpoints(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.custom_endpoints = input;
            self
        }
        /// <p>Specifies whether the DB cluster has instances in multiple Availability Zones.</p>
        pub fn multi_az(mut self, input: bool) -> Self {
            self.multi_az = Some(input);
            self
        }
        /// <p>Specifies whether the DB cluster has instances in multiple Availability Zones.</p>
        pub fn set_multi_az(mut self, input: std::option::Option<bool>) -> Self {
            self.multi_az = input;
            self
        }
        /// <p>The name of the database engine to be used for this DB cluster.</p>
        pub fn engine(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine = Some(input.into());
            self
        }
        /// <p>The name of the database engine to be used for this DB cluster.</p>
        pub fn set_engine(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.engine = input;
            self
        }
        /// <p>Indicates the database engine version.</p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_version = Some(input.into());
            self
        }
        /// <p>Indicates the database engine version.</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.engine_version = input;
            self
        }
        /// <p>Specifies the latest time to which a database can be restored with point-in-time restore.</p>
        pub fn latest_restorable_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.latest_restorable_time = Some(input);
            self
        }
        /// <p>Specifies the latest time to which a database can be restored with point-in-time restore.</p>
        pub fn set_latest_restorable_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.latest_restorable_time = input;
            self
        }
        /// <p>Specifies the port that the database engine is listening on.</p>
        pub fn port(mut self, input: i32) -> Self {
            self.port = Some(input);
            self
        }
        /// <p>Specifies the port that the database engine is listening on.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.port = input;
            self
        }
        /// <p>Contains the master username for the DB cluster.</p>
        pub fn master_username(mut self, input: impl Into<std::string::String>) -> Self {
            self.master_username = Some(input.into());
            self
        }
        /// <p>Contains the master username for the DB cluster.</p>
        pub fn set_master_username(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.master_username = input;
            self
        }
        /// Appends an item to `db_cluster_option_group_memberships`.
        ///
        /// To override the contents of this collection use [`set_db_cluster_option_group_memberships`](Self::set_db_cluster_option_group_memberships).
        ///
        /// <p>Provides the list of option group memberships for this DB cluster.</p>
        pub fn db_cluster_option_group_memberships(
            mut self,
            input: crate::model::DbClusterOptionGroupStatus,
        ) -> Self {
            let mut v = self.db_cluster_option_group_memberships.unwrap_or_default();
            v.push(input);
            self.db_cluster_option_group_memberships = Some(v);
            self
        }
        /// <p>Provides the list of option group memberships for this DB cluster.</p>
        pub fn set_db_cluster_option_group_memberships(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DbClusterOptionGroupStatus>>,
        ) -> Self {
            self.db_cluster_option_group_memberships = input;
            self
        }
        /// <p>Specifies the daily time range during which automated backups are created if automated backups are enabled, as determined by the <code>BackupRetentionPeriod</code>. </p>
        pub fn preferred_backup_window(mut self, input: impl Into<std::string::String>) -> Self {
            self.preferred_backup_window = Some(input.into());
            self
        }
        /// <p>Specifies the daily time range during which automated backups are created if automated backups are enabled, as determined by the <code>BackupRetentionPeriod</code>. </p>
        pub fn set_preferred_backup_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.preferred_backup_window = input;
            self
        }
        /// <p>Specifies the weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).</p>
        pub fn preferred_maintenance_window(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.preferred_maintenance_window = Some(input.into());
            self
        }
        /// <p>Specifies the weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).</p>
        pub fn set_preferred_maintenance_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.preferred_maintenance_window = input;
            self
        }
        /// <p>Contains the identifier of the source DB cluster if this DB cluster is a read replica.</p>
        pub fn replication_source_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.replication_source_identifier = Some(input.into());
            self
        }
        /// <p>Contains the identifier of the source DB cluster if this DB cluster is a read replica.</p>
        pub fn set_replication_source_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_source_identifier = input;
            self
        }
        /// Appends an item to `read_replica_identifiers`.
        ///
        /// To override the contents of this collection use [`set_read_replica_identifiers`](Self::set_read_replica_identifiers).
        ///
        /// <p>Contains one or more identifiers of the read replicas associated with this DB cluster.</p>
        pub fn read_replica_identifiers(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.read_replica_identifiers.unwrap_or_default();
            v.push(input.into());
            self.read_replica_identifiers = Some(v);
            self
        }
        /// <p>Contains one or more identifiers of the read replicas associated with this DB cluster.</p>
        pub fn set_read_replica_identifiers(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.read_replica_identifiers = input;
            self
        }
        /// Appends an item to `db_cluster_members`.
        ///
        /// To override the contents of this collection use [`set_db_cluster_members`](Self::set_db_cluster_members).
        ///
        /// <p>Provides the list of instances that make up the DB cluster.</p>
        pub fn db_cluster_members(mut self, input: crate::model::DbClusterMember) -> Self {
            let mut v = self.db_cluster_members.unwrap_or_default();
            v.push(input);
            self.db_cluster_members = Some(v);
            self
        }
        /// <p>Provides the list of instances that make up the DB cluster.</p>
        pub fn set_db_cluster_members(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DbClusterMember>>,
        ) -> Self {
            self.db_cluster_members = input;
            self
        }
        /// Appends an item to `vpc_security_groups`.
        ///
        /// To override the contents of this collection use [`set_vpc_security_groups`](Self::set_vpc_security_groups).
        ///
        /// <p>Provides a list of VPC security groups that the DB cluster belongs to.</p>
        pub fn vpc_security_groups(
            mut self,
            input: crate::model::VpcSecurityGroupMembership,
        ) -> Self {
            let mut v = self.vpc_security_groups.unwrap_or_default();
            v.push(input);
            self.vpc_security_groups = Some(v);
            self
        }
        /// <p>Provides a list of VPC security groups that the DB cluster belongs to.</p>
        pub fn set_vpc_security_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::VpcSecurityGroupMembership>>,
        ) -> Self {
            self.vpc_security_groups = input;
            self
        }
        /// <p>Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.</p>
        pub fn hosted_zone_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.hosted_zone_id = Some(input.into());
            self
        }
        /// <p>Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.</p>
        pub fn set_hosted_zone_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.hosted_zone_id = input;
            self
        }
        /// <p>Specifies whether the DB cluster is encrypted.</p>
        pub fn storage_encrypted(mut self, input: bool) -> Self {
            self.storage_encrypted = Some(input);
            self
        }
        /// <p>Specifies whether the DB cluster is encrypted.</p>
        pub fn set_storage_encrypted(mut self, input: std::option::Option<bool>) -> Self {
            self.storage_encrypted = input;
            self
        }
        /// <p>If <code>StorageEncrypted</code> is enabled, the Amazon Web Services KMS key identifier for the encrypted DB cluster.</p>
        /// <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>If <code>StorageEncrypted</code> is enabled, the Amazon Web Services KMS key identifier for the encrypted DB cluster.</p>
        /// <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// <p>The Amazon Web Services Region-unique, immutable identifier for the DB cluster. This identifier is found in Amazon Web Services CloudTrail log entries whenever the KMS key for the DB cluster is accessed.</p>
        pub fn db_cluster_resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_cluster_resource_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services Region-unique, immutable identifier for the DB cluster. This identifier is found in Amazon Web Services CloudTrail log entries whenever the KMS key for the DB cluster is accessed.</p>
        pub fn set_db_cluster_resource_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_resource_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the DB cluster.</p>
        pub fn db_cluster_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_cluster_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the DB cluster.</p>
        pub fn set_db_cluster_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_arn = input;
            self
        }
        /// Appends an item to `associated_roles`.
        ///
        /// To override the contents of this collection use [`set_associated_roles`](Self::set_associated_roles).
        ///
        /// <p>Provides a list of the Amazon Web Services Identity and Access Management (IAM) roles that are associated with the DB cluster. IAM roles that are associated with a DB cluster grant permission for the DB cluster to access other Amazon Web Services on your behalf.</p>
        pub fn associated_roles(mut self, input: crate::model::DbClusterRole) -> Self {
            let mut v = self.associated_roles.unwrap_or_default();
            v.push(input);
            self.associated_roles = Some(v);
            self
        }
        /// <p>Provides a list of the Amazon Web Services Identity and Access Management (IAM) roles that are associated with the DB cluster. IAM roles that are associated with a DB cluster grant permission for the DB cluster to access other Amazon Web Services on your behalf.</p>
        pub fn set_associated_roles(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DbClusterRole>>,
        ) -> Self {
            self.associated_roles = input;
            self
        }
        /// <p>A value that indicates whether the mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts is enabled.</p>
        pub fn iam_database_authentication_enabled(mut self, input: bool) -> Self {
            self.iam_database_authentication_enabled = Some(input);
            self
        }
        /// <p>A value that indicates whether the mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts is enabled.</p>
        pub fn set_iam_database_authentication_enabled(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.iam_database_authentication_enabled = input;
            self
        }
        /// <p>Identifies the clone group to which the DB cluster is associated.</p>
        pub fn clone_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.clone_group_id = Some(input.into());
            self
        }
        /// <p>Identifies the clone group to which the DB cluster is associated.</p>
        pub fn set_clone_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.clone_group_id = input;
            self
        }
        /// <p>Specifies the time when the DB cluster was created, in Universal Coordinated Time (UTC).</p>
        pub fn cluster_create_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.cluster_create_time = Some(input);
            self
        }
        /// <p>Specifies the time when the DB cluster was created, in Universal Coordinated Time (UTC).</p>
        pub fn set_cluster_create_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.cluster_create_time = input;
            self
        }
        /// <p>The earliest time to which a DB cluster can be backtracked.</p>
        pub fn earliest_backtrack_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.earliest_backtrack_time = Some(input);
            self
        }
        /// <p>The earliest time to which a DB cluster can be backtracked.</p>
        pub fn set_earliest_backtrack_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.earliest_backtrack_time = input;
            self
        }
        /// <p>The target backtrack window, in seconds. If this value is set to 0, backtracking is disabled for the DB cluster. Otherwise, backtracking is enabled.</p>
        pub fn backtrack_window(mut self, input: i64) -> Self {
            self.backtrack_window = Some(input);
            self
        }
        /// <p>The target backtrack window, in seconds. If this value is set to 0, backtracking is disabled for the DB cluster. Otherwise, backtracking is enabled.</p>
        pub fn set_backtrack_window(mut self, input: std::option::Option<i64>) -> Self {
            self.backtrack_window = input;
            self
        }
        /// <p>The number of change records stored for Backtrack.</p>
        pub fn backtrack_consumed_change_records(mut self, input: i64) -> Self {
            self.backtrack_consumed_change_records = Some(input);
            self
        }
        /// <p>The number of change records stored for Backtrack.</p>
        pub fn set_backtrack_consumed_change_records(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.backtrack_consumed_change_records = input;
            self
        }
        /// Appends an item to `enabled_cloudwatch_logs_exports`.
        ///
        /// To override the contents of this collection use [`set_enabled_cloudwatch_logs_exports`](Self::set_enabled_cloudwatch_logs_exports).
        ///
        /// <p>A list of log types that this DB cluster is configured to export to CloudWatch Logs.</p>
        /// <p>Log types vary by DB engine. For information about the log types for each DB engine, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html">Amazon RDS Database Log Files</a> in the <i>Amazon Aurora User Guide.</i> </p>
        pub fn enabled_cloudwatch_logs_exports(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.enabled_cloudwatch_logs_exports.unwrap_or_default();
            v.push(input.into());
            self.enabled_cloudwatch_logs_exports = Some(v);
            self
        }
        /// <p>A list of log types that this DB cluster is configured to export to CloudWatch Logs.</p>
        /// <p>Log types vary by DB engine. For information about the log types for each DB engine, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html">Amazon RDS Database Log Files</a> in the <i>Amazon Aurora User Guide.</i> </p>
        pub fn set_enabled_cloudwatch_logs_exports(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.enabled_cloudwatch_logs_exports = input;
            self
        }
        /// <p>The current capacity of an Aurora Serverless DB cluster. The capacity is 0 (zero) when the cluster is paused.</p>
        /// <p>For more information about Aurora Serverless, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.html">Using Amazon Aurora Serverless</a> in the <i>Amazon Aurora User Guide</i>.</p>
        pub fn capacity(mut self, input: i32) -> Self {
            self.capacity = Some(input);
            self
        }
        /// <p>The current capacity of an Aurora Serverless DB cluster. The capacity is 0 (zero) when the cluster is paused.</p>
        /// <p>For more information about Aurora Serverless, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.html">Using Amazon Aurora Serverless</a> in the <i>Amazon Aurora User Guide</i>.</p>
        pub fn set_capacity(mut self, input: std::option::Option<i32>) -> Self {
            self.capacity = input;
            self
        }
        /// <p>The DB engine mode of the DB cluster, either <code>provisioned</code>, <code>serverless</code>, <code>parallelquery</code>, <code>global</code>, or <code>multimaster</code>.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBCluster.html"> CreateDBCluster</a>.</p>
        pub fn engine_mode(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_mode = Some(input.into());
            self
        }
        /// <p>The DB engine mode of the DB cluster, either <code>provisioned</code>, <code>serverless</code>, <code>parallelquery</code>, <code>global</code>, or <code>multimaster</code>.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBCluster.html"> CreateDBCluster</a>.</p>
        pub fn set_engine_mode(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.engine_mode = input;
            self
        }
        /// <p>Shows the scaling configuration for an Aurora DB cluster in <code>serverless</code> DB engine mode.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.html">Using Amazon Aurora Serverless</a> in the <i>Amazon Aurora User Guide</i>.</p>
        pub fn scaling_configuration_info(
            mut self,
            input: crate::model::ScalingConfigurationInfo,
        ) -> Self {
            self.scaling_configuration_info = Some(input);
            self
        }
        /// <p>Shows the scaling configuration for an Aurora DB cluster in <code>serverless</code> DB engine mode.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.html">Using Amazon Aurora Serverless</a> in the <i>Amazon Aurora User Guide</i>.</p>
        pub fn set_scaling_configuration_info(
            mut self,
            input: std::option::Option<crate::model::ScalingConfigurationInfo>,
        ) -> Self {
            self.scaling_configuration_info = input;
            self
        }
        /// <p>Indicates if the DB cluster has deletion protection enabled. The database can't be deleted when deletion protection is enabled. </p>
        pub fn deletion_protection(mut self, input: bool) -> Self {
            self.deletion_protection = Some(input);
            self
        }
        /// <p>Indicates if the DB cluster has deletion protection enabled. The database can't be deleted when deletion protection is enabled. </p>
        pub fn set_deletion_protection(mut self, input: std::option::Option<bool>) -> Self {
            self.deletion_protection = input;
            self
        }
        /// <p>A value that indicates whether the HTTP endpoint for an Aurora Serverless DB cluster is enabled.</p>
        /// <p>When enabled, the HTTP endpoint provides a connectionless web service API for running SQL queries on the Aurora Serverless DB cluster. You can also query your database from inside the RDS console with the query editor.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/data-api.html">Using the Data API for Aurora Serverless</a> in the <i>Amazon Aurora User Guide</i>.</p>
        pub fn http_endpoint_enabled(mut self, input: bool) -> Self {
            self.http_endpoint_enabled = Some(input);
            self
        }
        /// <p>A value that indicates whether the HTTP endpoint for an Aurora Serverless DB cluster is enabled.</p>
        /// <p>When enabled, the HTTP endpoint provides a connectionless web service API for running SQL queries on the Aurora Serverless DB cluster. You can also query your database from inside the RDS console with the query editor.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/data-api.html">Using the Data API for Aurora Serverless</a> in the <i>Amazon Aurora User Guide</i>.</p>
        pub fn set_http_endpoint_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.http_endpoint_enabled = input;
            self
        }
        /// <p>The mode of the database activity stream. Database events such as a change or access generate an activity stream event. The database session can handle these events either synchronously or asynchronously. </p>
        pub fn activity_stream_mode(mut self, input: crate::model::ActivityStreamMode) -> Self {
            self.activity_stream_mode = Some(input);
            self
        }
        /// <p>The mode of the database activity stream. Database events such as a change or access generate an activity stream event. The database session can handle these events either synchronously or asynchronously. </p>
        pub fn set_activity_stream_mode(
            mut self,
            input: std::option::Option<crate::model::ActivityStreamMode>,
        ) -> Self {
            self.activity_stream_mode = input;
            self
        }
        /// <p>The status of the database activity stream.</p>
        pub fn activity_stream_status(mut self, input: crate::model::ActivityStreamStatus) -> Self {
            self.activity_stream_status = Some(input);
            self
        }
        /// <p>The status of the database activity stream.</p>
        pub fn set_activity_stream_status(
            mut self,
            input: std::option::Option<crate::model::ActivityStreamStatus>,
        ) -> Self {
            self.activity_stream_status = input;
            self
        }
        /// <p>The Amazon Web Services KMS key identifier used for encrypting messages in the database activity stream.</p>
        /// <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.</p>
        pub fn activity_stream_kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.activity_stream_kms_key_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services KMS key identifier used for encrypting messages in the database activity stream.</p>
        /// <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.</p>
        pub fn set_activity_stream_kms_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.activity_stream_kms_key_id = input;
            self
        }
        /// <p>The name of the Amazon Kinesis data stream used for the database activity stream.</p>
        pub fn activity_stream_kinesis_stream_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.activity_stream_kinesis_stream_name = Some(input.into());
            self
        }
        /// <p>The name of the Amazon Kinesis data stream used for the database activity stream.</p>
        pub fn set_activity_stream_kinesis_stream_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.activity_stream_kinesis_stream_name = input;
            self
        }
        /// <p>Specifies whether tags are copied from the DB cluster to snapshots of the DB cluster.</p>
        pub fn copy_tags_to_snapshot(mut self, input: bool) -> Self {
            self.copy_tags_to_snapshot = Some(input);
            self
        }
        /// <p>Specifies whether tags are copied from the DB cluster to snapshots of the DB cluster.</p>
        pub fn set_copy_tags_to_snapshot(mut self, input: std::option::Option<bool>) -> Self {
            self.copy_tags_to_snapshot = input;
            self
        }
        /// <p>Specifies whether the DB cluster is a clone of a DB cluster owned by a different Amazon Web Services account.</p>
        pub fn cross_account_clone(mut self, input: bool) -> Self {
            self.cross_account_clone = Some(input);
            self
        }
        /// <p>Specifies whether the DB cluster is a clone of a DB cluster owned by a different Amazon Web Services account.</p>
        pub fn set_cross_account_clone(mut self, input: std::option::Option<bool>) -> Self {
            self.cross_account_clone = input;
            self
        }
        /// Appends an item to `domain_memberships`.
        ///
        /// To override the contents of this collection use [`set_domain_memberships`](Self::set_domain_memberships).
        ///
        /// <p>The Active Directory Domain membership records associated with the DB cluster.</p>
        pub fn domain_memberships(mut self, input: crate::model::DomainMembership) -> Self {
            let mut v = self.domain_memberships.unwrap_or_default();
            v.push(input);
            self.domain_memberships = Some(v);
            self
        }
        /// <p>The Active Directory Domain membership records associated with the DB cluster.</p>
        pub fn set_domain_memberships(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DomainMembership>>,
        ) -> Self {
            self.domain_memberships = input;
            self
        }
        /// Appends an item to `tag_list`.
        ///
        /// To override the contents of this collection use [`set_tag_list`](Self::set_tag_list).
        ///
        /// <p>A list of tags. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources</a> in the <i>Amazon RDS User Guide.</i> </p>
        pub fn tag_list(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tag_list.unwrap_or_default();
            v.push(input);
            self.tag_list = Some(v);
            self
        }
        /// <p>A list of tags. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources</a> in the <i>Amazon RDS User Guide.</i> </p>
        pub fn set_tag_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tag_list = input;
            self
        }
        /// <p>Specifies whether a secondary cluster in an Aurora global database has write forwarding enabled, not enabled, or is in the process of enabling it.</p>
        pub fn global_write_forwarding_status(
            mut self,
            input: crate::model::WriteForwardingStatus,
        ) -> Self {
            self.global_write_forwarding_status = Some(input);
            self
        }
        /// <p>Specifies whether a secondary cluster in an Aurora global database has write forwarding enabled, not enabled, or is in the process of enabling it.</p>
        pub fn set_global_write_forwarding_status(
            mut self,
            input: std::option::Option<crate::model::WriteForwardingStatus>,
        ) -> Self {
            self.global_write_forwarding_status = input;
            self
        }
        /// <p>Specifies whether you have requested to enable write forwarding for a secondary cluster in an Aurora global database. Because write forwarding takes time to enable, check the value of <code>GlobalWriteForwardingStatus</code> to confirm that the request has completed before using the write forwarding feature for this cluster.</p>
        pub fn global_write_forwarding_requested(mut self, input: bool) -> Self {
            self.global_write_forwarding_requested = Some(input);
            self
        }
        /// <p>Specifies whether you have requested to enable write forwarding for a secondary cluster in an Aurora global database. Because write forwarding takes time to enable, check the value of <code>GlobalWriteForwardingStatus</code> to confirm that the request has completed before using the write forwarding feature for this cluster.</p>
        pub fn set_global_write_forwarding_requested(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.global_write_forwarding_requested = input;
            self
        }
        /// <p>A value that specifies that changes to the DB cluster are pending. This element is only included when changes are pending. Specific changes are identified by subelements.</p>
        pub fn pending_modified_values(
            mut self,
            input: crate::model::ClusterPendingModifiedValues,
        ) -> Self {
            self.pending_modified_values = Some(input);
            self
        }
        /// <p>A value that specifies that changes to the DB cluster are pending. This element is only included when changes are pending. Specific changes are identified by subelements.</p>
        pub fn set_pending_modified_values(
            mut self,
            input: std::option::Option<crate::model::ClusterPendingModifiedValues>,
        ) -> Self {
            self.pending_modified_values = input;
            self
        }
        /// <p>The name of the compute and memory capacity class of the DB instance.</p>
        /// <p>This setting is only for non-Aurora Multi-AZ DB clusters.</p>
        pub fn db_cluster_instance_class(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_cluster_instance_class = Some(input.into());
            self
        }
        /// <p>The name of the compute and memory capacity class of the DB instance.</p>
        /// <p>This setting is only for non-Aurora Multi-AZ DB clusters.</p>
        pub fn set_db_cluster_instance_class(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_instance_class = input;
            self
        }
        /// <p>The storage type associated with the DB cluster.</p>
        /// <p>This setting is only for non-Aurora Multi-AZ DB clusters.</p>
        pub fn storage_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.storage_type = Some(input.into());
            self
        }
        /// <p>The storage type associated with the DB cluster.</p>
        /// <p>This setting is only for non-Aurora Multi-AZ DB clusters.</p>
        pub fn set_storage_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.storage_type = input;
            self
        }
        /// <p>The Provisioned IOPS (I/O operations per second) value.</p>
        /// <p>This setting is only for non-Aurora Multi-AZ DB clusters.</p>
        pub fn iops(mut self, input: i32) -> Self {
            self.iops = Some(input);
            self
        }
        /// <p>The Provisioned IOPS (I/O operations per second) value.</p>
        /// <p>This setting is only for non-Aurora Multi-AZ DB clusters.</p>
        pub fn set_iops(mut self, input: std::option::Option<i32>) -> Self {
            self.iops = input;
            self
        }
        /// <p>Specifies the accessibility options for the DB instance.</p>
        /// <p>When the DB instance is publicly accessible, its Domain Name System (DNS) endpoint resolves to the private IP address from within the DB instance's virtual private cloud (VPC). It resolves to the public IP address from outside of the DB instance's VPC. Access to the DB instance is ultimately controlled by the security group it uses. That public access is not permitted if the security group assigned to the DB instance doesn't permit it.</p>
        /// <p>When the DB instance isn't publicly accessible, it is an internal DB instance with a DNS name that resolves to a private IP address.</p>
        /// <p>For more information, see <code>CreateDBInstance</code>.</p>
        /// <p>This setting is only for non-Aurora Multi-AZ DB clusters.</p>
        pub fn publicly_accessible(mut self, input: bool) -> Self {
            self.publicly_accessible = Some(input);
            self
        }
        /// <p>Specifies the accessibility options for the DB instance.</p>
        /// <p>When the DB instance is publicly accessible, its Domain Name System (DNS) endpoint resolves to the private IP address from within the DB instance's virtual private cloud (VPC). It resolves to the public IP address from outside of the DB instance's VPC. Access to the DB instance is ultimately controlled by the security group it uses. That public access is not permitted if the security group assigned to the DB instance doesn't permit it.</p>
        /// <p>When the DB instance isn't publicly accessible, it is an internal DB instance with a DNS name that resolves to a private IP address.</p>
        /// <p>For more information, see <code>CreateDBInstance</code>.</p>
        /// <p>This setting is only for non-Aurora Multi-AZ DB clusters.</p>
        pub fn set_publicly_accessible(mut self, input: std::option::Option<bool>) -> Self {
            self.publicly_accessible = input;
            self
        }
        /// <p>A value that indicates that minor version patches are applied automatically.</p>
        /// <p>This setting is only for non-Aurora Multi-AZ DB clusters.</p>
        pub fn auto_minor_version_upgrade(mut self, input: bool) -> Self {
            self.auto_minor_version_upgrade = Some(input);
            self
        }
        /// <p>A value that indicates that minor version patches are applied automatically.</p>
        /// <p>This setting is only for non-Aurora Multi-AZ DB clusters.</p>
        pub fn set_auto_minor_version_upgrade(mut self, input: std::option::Option<bool>) -> Self {
            self.auto_minor_version_upgrade = input;
            self
        }
        /// <p>The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB cluster.</p>
        /// <p>This setting is only for non-Aurora Multi-AZ DB clusters.</p>
        pub fn monitoring_interval(mut self, input: i32) -> Self {
            self.monitoring_interval = Some(input);
            self
        }
        /// <p>The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB cluster.</p>
        /// <p>This setting is only for non-Aurora Multi-AZ DB clusters.</p>
        pub fn set_monitoring_interval(mut self, input: std::option::Option<i32>) -> Self {
            self.monitoring_interval = input;
            self
        }
        /// <p>The ARN for the IAM role that permits RDS to send Enhanced Monitoring metrics to Amazon CloudWatch Logs.</p>
        /// <p>This setting is only for non-Aurora Multi-AZ DB clusters.</p>
        pub fn monitoring_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.monitoring_role_arn = Some(input.into());
            self
        }
        /// <p>The ARN for the IAM role that permits RDS to send Enhanced Monitoring metrics to Amazon CloudWatch Logs.</p>
        /// <p>This setting is only for non-Aurora Multi-AZ DB clusters.</p>
        pub fn set_monitoring_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.monitoring_role_arn = input;
            self
        }
        /// <p>True if Performance Insights is enabled for the DB cluster, and otherwise false.</p>
        /// <p>This setting is only for non-Aurora Multi-AZ DB clusters.</p>
        pub fn performance_insights_enabled(mut self, input: bool) -> Self {
            self.performance_insights_enabled = Some(input);
            self
        }
        /// <p>True if Performance Insights is enabled for the DB cluster, and otherwise false.</p>
        /// <p>This setting is only for non-Aurora Multi-AZ DB clusters.</p>
        pub fn set_performance_insights_enabled(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.performance_insights_enabled = input;
            self
        }
        /// <p>The Amazon Web Services KMS key identifier for encryption of Performance Insights data.</p>
        /// <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.</p>
        /// <p>This setting is only for non-Aurora Multi-AZ DB clusters.</p>
        pub fn performance_insights_kms_key_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.performance_insights_kms_key_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services KMS key identifier for encryption of Performance Insights data.</p>
        /// <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.</p>
        /// <p>This setting is only for non-Aurora Multi-AZ DB clusters.</p>
        pub fn set_performance_insights_kms_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.performance_insights_kms_key_id = input;
            self
        }
        /// <p>The amount of time, in days, to retain Performance Insights data. Valid values are 7 or 731 (2 years).</p>
        /// <p>This setting is only for non-Aurora Multi-AZ DB clusters.</p>
        pub fn performance_insights_retention_period(mut self, input: i32) -> Self {
            self.performance_insights_retention_period = Some(input);
            self
        }
        /// <p>The amount of time, in days, to retain Performance Insights data. Valid values are 7 or 731 (2 years).</p>
        /// <p>This setting is only for non-Aurora Multi-AZ DB clusters.</p>
        pub fn set_performance_insights_retention_period(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.performance_insights_retention_period = input;
            self
        }
        /// Consumes the builder and constructs a [`DbCluster`](crate::model::DbCluster)
        pub fn build(self) -> crate::model::DbCluster {
            crate::model::DbCluster {
                allocated_storage: self.allocated_storage,
                availability_zones: self.availability_zones,
                backup_retention_period: self.backup_retention_period,
                character_set_name: self.character_set_name,
                database_name: self.database_name,
                db_cluster_identifier: self.db_cluster_identifier,
                db_cluster_parameter_group: self.db_cluster_parameter_group,
                db_subnet_group: self.db_subnet_group,
                status: self.status,
                automatic_restart_time: self.automatic_restart_time,
                percent_progress: self.percent_progress,
                earliest_restorable_time: self.earliest_restorable_time,
                endpoint: self.endpoint,
                reader_endpoint: self.reader_endpoint,
                custom_endpoints: self.custom_endpoints,
                multi_az: self.multi_az,
                engine: self.engine,
                engine_version: self.engine_version,
                latest_restorable_time: self.latest_restorable_time,
                port: self.port,
                master_username: self.master_username,
                db_cluster_option_group_memberships: self.db_cluster_option_group_memberships,
                preferred_backup_window: self.preferred_backup_window,
                preferred_maintenance_window: self.preferred_maintenance_window,
                replication_source_identifier: self.replication_source_identifier,
                read_replica_identifiers: self.read_replica_identifiers,
                db_cluster_members: self.db_cluster_members,
                vpc_security_groups: self.vpc_security_groups,
                hosted_zone_id: self.hosted_zone_id,
                storage_encrypted: self.storage_encrypted.unwrap_or_default(),
                kms_key_id: self.kms_key_id,
                db_cluster_resource_id: self.db_cluster_resource_id,
                db_cluster_arn: self.db_cluster_arn,
                associated_roles: self.associated_roles,
                iam_database_authentication_enabled: self.iam_database_authentication_enabled,
                clone_group_id: self.clone_group_id,
                cluster_create_time: self.cluster_create_time,
                earliest_backtrack_time: self.earliest_backtrack_time,
                backtrack_window: self.backtrack_window,
                backtrack_consumed_change_records: self.backtrack_consumed_change_records,
                enabled_cloudwatch_logs_exports: self.enabled_cloudwatch_logs_exports,
                capacity: self.capacity,
                engine_mode: self.engine_mode,
                scaling_configuration_info: self.scaling_configuration_info,
                deletion_protection: self.deletion_protection,
                http_endpoint_enabled: self.http_endpoint_enabled,
                activity_stream_mode: self.activity_stream_mode,
                activity_stream_status: self.activity_stream_status,
                activity_stream_kms_key_id: self.activity_stream_kms_key_id,
                activity_stream_kinesis_stream_name: self.activity_stream_kinesis_stream_name,
                copy_tags_to_snapshot: self.copy_tags_to_snapshot,
                cross_account_clone: self.cross_account_clone,
                domain_memberships: self.domain_memberships,
                tag_list: self.tag_list,
                global_write_forwarding_status: self.global_write_forwarding_status,
                global_write_forwarding_requested: self.global_write_forwarding_requested,
                pending_modified_values: self.pending_modified_values,
                db_cluster_instance_class: self.db_cluster_instance_class,
                storage_type: self.storage_type,
                iops: self.iops,
                publicly_accessible: self.publicly_accessible,
                auto_minor_version_upgrade: self.auto_minor_version_upgrade.unwrap_or_default(),
                monitoring_interval: self.monitoring_interval,
                monitoring_role_arn: self.monitoring_role_arn,
                performance_insights_enabled: self.performance_insights_enabled,
                performance_insights_kms_key_id: self.performance_insights_kms_key_id,
                performance_insights_retention_period: self.performance_insights_retention_period,
            }
        }
    }
}
impl DbCluster {
    /// Creates a new builder-style object to manufacture [`DbCluster`](crate::model::DbCluster)
    pub fn builder() -> crate::model::db_cluster::Builder {
        crate::model::db_cluster::Builder::default()
    }
}

/// <p>This data type is used as a response element in the <code>ModifyDBCluster</code> operation and contains changes that will be applied during the next maintenance window.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ClusterPendingModifiedValues {
    /// <p>A list of the log types whose configuration is still pending. In other words, these log types are in the process of being activated or deactivated.</p>
    pub pending_cloudwatch_logs_exports:
        std::option::Option<crate::model::PendingCloudwatchLogsExports>,
    /// <p>The DBClusterIdentifier value for the DB cluster.</p>
    pub db_cluster_identifier: std::option::Option<std::string::String>,
    /// <p>The master credentials for the DB cluster.</p>
    pub master_user_password: std::option::Option<std::string::String>,
    /// <p>A value that indicates whether mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts is enabled.</p>
    pub iam_database_authentication_enabled: std::option::Option<bool>,
    /// <p>The database engine version.</p>
    pub engine_version: std::option::Option<std::string::String>,
}
impl ClusterPendingModifiedValues {
    /// <p>A list of the log types whose configuration is still pending. In other words, these log types are in the process of being activated or deactivated.</p>
    pub fn pending_cloudwatch_logs_exports(
        &self,
    ) -> std::option::Option<&crate::model::PendingCloudwatchLogsExports> {
        self.pending_cloudwatch_logs_exports.as_ref()
    }
    /// <p>The DBClusterIdentifier value for the DB cluster.</p>
    pub fn db_cluster_identifier(&self) -> std::option::Option<&str> {
        self.db_cluster_identifier.as_deref()
    }
    /// <p>The master credentials for the DB cluster.</p>
    pub fn master_user_password(&self) -> std::option::Option<&str> {
        self.master_user_password.as_deref()
    }
    /// <p>A value that indicates whether mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts is enabled.</p>
    pub fn iam_database_authentication_enabled(&self) -> std::option::Option<bool> {
        self.iam_database_authentication_enabled
    }
    /// <p>The database engine version.</p>
    pub fn engine_version(&self) -> std::option::Option<&str> {
        self.engine_version.as_deref()
    }
}
impl std::fmt::Debug for ClusterPendingModifiedValues {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ClusterPendingModifiedValues");
        formatter.field(
            "pending_cloudwatch_logs_exports",
            &self.pending_cloudwatch_logs_exports,
        );
        formatter.field("db_cluster_identifier", &self.db_cluster_identifier);
        formatter.field("master_user_password", &self.master_user_password);
        formatter.field(
            "iam_database_authentication_enabled",
            &self.iam_database_authentication_enabled,
        );
        formatter.field("engine_version", &self.engine_version);
        formatter.finish()
    }
}
/// See [`ClusterPendingModifiedValues`](crate::model::ClusterPendingModifiedValues)
pub mod cluster_pending_modified_values {
    /// A builder for [`ClusterPendingModifiedValues`](crate::model::ClusterPendingModifiedValues)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pending_cloudwatch_logs_exports:
            std::option::Option<crate::model::PendingCloudwatchLogsExports>,
        pub(crate) db_cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) master_user_password: std::option::Option<std::string::String>,
        pub(crate) iam_database_authentication_enabled: std::option::Option<bool>,
        pub(crate) engine_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A list of the log types whose configuration is still pending. In other words, these log types are in the process of being activated or deactivated.</p>
        pub fn pending_cloudwatch_logs_exports(
            mut self,
            input: crate::model::PendingCloudwatchLogsExports,
        ) -> Self {
            self.pending_cloudwatch_logs_exports = Some(input);
            self
        }
        /// <p>A list of the log types whose configuration is still pending. In other words, these log types are in the process of being activated or deactivated.</p>
        pub fn set_pending_cloudwatch_logs_exports(
            mut self,
            input: std::option::Option<crate::model::PendingCloudwatchLogsExports>,
        ) -> Self {
            self.pending_cloudwatch_logs_exports = input;
            self
        }
        /// <p>The DBClusterIdentifier value for the DB cluster.</p>
        pub fn db_cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_cluster_identifier = Some(input.into());
            self
        }
        /// <p>The DBClusterIdentifier value for the DB cluster.</p>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_identifier = input;
            self
        }
        /// <p>The master credentials for the DB cluster.</p>
        pub fn master_user_password(mut self, input: impl Into<std::string::String>) -> Self {
            self.master_user_password = Some(input.into());
            self
        }
        /// <p>The master credentials for the DB cluster.</p>
        pub fn set_master_user_password(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.master_user_password = input;
            self
        }
        /// <p>A value that indicates whether mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts is enabled.</p>
        pub fn iam_database_authentication_enabled(mut self, input: bool) -> Self {
            self.iam_database_authentication_enabled = Some(input);
            self
        }
        /// <p>A value that indicates whether mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts is enabled.</p>
        pub fn set_iam_database_authentication_enabled(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.iam_database_authentication_enabled = input;
            self
        }
        /// <p>The database engine version.</p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_version = Some(input.into());
            self
        }
        /// <p>The database engine version.</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.engine_version = input;
            self
        }
        /// Consumes the builder and constructs a [`ClusterPendingModifiedValues`](crate::model::ClusterPendingModifiedValues)
        pub fn build(self) -> crate::model::ClusterPendingModifiedValues {
            crate::model::ClusterPendingModifiedValues {
                pending_cloudwatch_logs_exports: self.pending_cloudwatch_logs_exports,
                db_cluster_identifier: self.db_cluster_identifier,
                master_user_password: self.master_user_password,
                iam_database_authentication_enabled: self.iam_database_authentication_enabled,
                engine_version: self.engine_version,
            }
        }
    }
}
impl ClusterPendingModifiedValues {
    /// Creates a new builder-style object to manufacture [`ClusterPendingModifiedValues`](crate::model::ClusterPendingModifiedValues)
    pub fn builder() -> crate::model::cluster_pending_modified_values::Builder {
        crate::model::cluster_pending_modified_values::Builder::default()
    }
}

/// _Note: `WriteForwardingStatus::Unknown` has been renamed to `::UnknownValue`._
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum WriteForwardingStatus {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Disabling,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabling,
    /// _Note: `::Unknown` has been renamed to `::UnknownValue`._
    UnknownValue,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for WriteForwardingStatus {
    fn from(s: &str) -> Self {
        match s {
            "disabled" => WriteForwardingStatus::Disabled,
            "disabling" => WriteForwardingStatus::Disabling,
            "enabled" => WriteForwardingStatus::Enabled,
            "enabling" => WriteForwardingStatus::Enabling,
            "unknown" => WriteForwardingStatus::UnknownValue,
            other => WriteForwardingStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for WriteForwardingStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(WriteForwardingStatus::from(s))
    }
}
impl WriteForwardingStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            WriteForwardingStatus::Disabled => "disabled",
            WriteForwardingStatus::Disabling => "disabling",
            WriteForwardingStatus::Enabled => "enabled",
            WriteForwardingStatus::Enabling => "enabling",
            WriteForwardingStatus::UnknownValue => "unknown",
            WriteForwardingStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["disabled", "disabling", "enabled", "enabling", "unknown"]
    }
}
impl AsRef<str> for WriteForwardingStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Shows the scaling configuration for an Aurora DB cluster in <code>serverless</code> DB engine mode.</p>
/// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.html">Using Amazon Aurora Serverless</a> in the <i>Amazon Aurora User Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ScalingConfigurationInfo {
    /// <p>The maximum capacity for the Aurora DB cluster in <code>serverless</code> DB engine mode.</p>
    pub min_capacity: std::option::Option<i32>,
    /// <p>The maximum capacity for an Aurora DB cluster in <code>serverless</code> DB engine mode.</p>
    pub max_capacity: std::option::Option<i32>,
    /// <p>A value that indicates whether automatic pause is allowed for the Aurora DB cluster in <code>serverless</code> DB engine mode.</p>
    /// <p>When the value is set to false for an Aurora Serverless DB cluster, the DB cluster automatically resumes.</p>
    pub auto_pause: std::option::Option<bool>,
    /// <p>The remaining amount of time, in seconds, before the Aurora DB cluster in <code>serverless</code> mode is paused. A DB cluster can be paused only when it's idle (it has no connections).</p>
    pub seconds_until_auto_pause: std::option::Option<i32>,
    /// <p>The action that occurs when Aurora times out while attempting to change the capacity of an Aurora Serverless cluster. The value is either <code>ForceApplyCapacityChange</code> or <code>RollbackCapacityChange</code>.</p>
    /// <p> <code>ForceApplyCapacityChange</code>, the default, sets the capacity to the specified value as soon as possible.</p>
    /// <p> <code>RollbackCapacityChange</code> ignores the capacity change if a scaling point isn't found in the timeout period.</p>
    pub timeout_action: std::option::Option<std::string::String>,
    /// <p>The number of seconds before scaling times out. What happens when an attempted scaling action times out is determined by the <code>TimeoutAction</code> setting.</p>
    pub seconds_before_timeout: std::option::Option<i32>,
}
impl ScalingConfigurationInfo {
    /// <p>The maximum capacity for the Aurora DB cluster in <code>serverless</code> DB engine mode.</p>
    pub fn min_capacity(&self) -> std::option::Option<i32> {
        self.min_capacity
    }
    /// <p>The maximum capacity for an Aurora DB cluster in <code>serverless</code> DB engine mode.</p>
    pub fn max_capacity(&self) -> std::option::Option<i32> {
        self.max_capacity
    }
    /// <p>A value that indicates whether automatic pause is allowed for the Aurora DB cluster in <code>serverless</code> DB engine mode.</p>
    /// <p>When the value is set to false for an Aurora Serverless DB cluster, the DB cluster automatically resumes.</p>
    pub fn auto_pause(&self) -> std::option::Option<bool> {
        self.auto_pause
    }
    /// <p>The remaining amount of time, in seconds, before the Aurora DB cluster in <code>serverless</code> mode is paused. A DB cluster can be paused only when it's idle (it has no connections).</p>
    pub fn seconds_until_auto_pause(&self) -> std::option::Option<i32> {
        self.seconds_until_auto_pause
    }
    /// <p>The action that occurs when Aurora times out while attempting to change the capacity of an Aurora Serverless cluster. The value is either <code>ForceApplyCapacityChange</code> or <code>RollbackCapacityChange</code>.</p>
    /// <p> <code>ForceApplyCapacityChange</code>, the default, sets the capacity to the specified value as soon as possible.</p>
    /// <p> <code>RollbackCapacityChange</code> ignores the capacity change if a scaling point isn't found in the timeout period.</p>
    pub fn timeout_action(&self) -> std::option::Option<&str> {
        self.timeout_action.as_deref()
    }
    /// <p>The number of seconds before scaling times out. What happens when an attempted scaling action times out is determined by the <code>TimeoutAction</code> setting.</p>
    pub fn seconds_before_timeout(&self) -> std::option::Option<i32> {
        self.seconds_before_timeout
    }
}
impl std::fmt::Debug for ScalingConfigurationInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ScalingConfigurationInfo");
        formatter.field("min_capacity", &self.min_capacity);
        formatter.field("max_capacity", &self.max_capacity);
        formatter.field("auto_pause", &self.auto_pause);
        formatter.field("seconds_until_auto_pause", &self.seconds_until_auto_pause);
        formatter.field("timeout_action", &self.timeout_action);
        formatter.field("seconds_before_timeout", &self.seconds_before_timeout);
        formatter.finish()
    }
}
/// See [`ScalingConfigurationInfo`](crate::model::ScalingConfigurationInfo)
pub mod scaling_configuration_info {
    /// A builder for [`ScalingConfigurationInfo`](crate::model::ScalingConfigurationInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) min_capacity: std::option::Option<i32>,
        pub(crate) max_capacity: std::option::Option<i32>,
        pub(crate) auto_pause: std::option::Option<bool>,
        pub(crate) seconds_until_auto_pause: std::option::Option<i32>,
        pub(crate) timeout_action: std::option::Option<std::string::String>,
        pub(crate) seconds_before_timeout: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The maximum capacity for the Aurora DB cluster in <code>serverless</code> DB engine mode.</p>
        pub fn min_capacity(mut self, input: i32) -> Self {
            self.min_capacity = Some(input);
            self
        }
        /// <p>The maximum capacity for the Aurora DB cluster in <code>serverless</code> DB engine mode.</p>
        pub fn set_min_capacity(mut self, input: std::option::Option<i32>) -> Self {
            self.min_capacity = input;
            self
        }
        /// <p>The maximum capacity for an Aurora DB cluster in <code>serverless</code> DB engine mode.</p>
        pub fn max_capacity(mut self, input: i32) -> Self {
            self.max_capacity = Some(input);
            self
        }
        /// <p>The maximum capacity for an Aurora DB cluster in <code>serverless</code> DB engine mode.</p>
        pub fn set_max_capacity(mut self, input: std::option::Option<i32>) -> Self {
            self.max_capacity = input;
            self
        }
        /// <p>A value that indicates whether automatic pause is allowed for the Aurora DB cluster in <code>serverless</code> DB engine mode.</p>
        /// <p>When the value is set to false for an Aurora Serverless DB cluster, the DB cluster automatically resumes.</p>
        pub fn auto_pause(mut self, input: bool) -> Self {
            self.auto_pause = Some(input);
            self
        }
        /// <p>A value that indicates whether automatic pause is allowed for the Aurora DB cluster in <code>serverless</code> DB engine mode.</p>
        /// <p>When the value is set to false for an Aurora Serverless DB cluster, the DB cluster automatically resumes.</p>
        pub fn set_auto_pause(mut self, input: std::option::Option<bool>) -> Self {
            self.auto_pause = input;
            self
        }
        /// <p>The remaining amount of time, in seconds, before the Aurora DB cluster in <code>serverless</code> mode is paused. A DB cluster can be paused only when it's idle (it has no connections).</p>
        pub fn seconds_until_auto_pause(mut self, input: i32) -> Self {
            self.seconds_until_auto_pause = Some(input);
            self
        }
        /// <p>The remaining amount of time, in seconds, before the Aurora DB cluster in <code>serverless</code> mode is paused. A DB cluster can be paused only when it's idle (it has no connections).</p>
        pub fn set_seconds_until_auto_pause(mut self, input: std::option::Option<i32>) -> Self {
            self.seconds_until_auto_pause = input;
            self
        }
        /// <p>The action that occurs when Aurora times out while attempting to change the capacity of an Aurora Serverless cluster. The value is either <code>ForceApplyCapacityChange</code> or <code>RollbackCapacityChange</code>.</p>
        /// <p> <code>ForceApplyCapacityChange</code>, the default, sets the capacity to the specified value as soon as possible.</p>
        /// <p> <code>RollbackCapacityChange</code> ignores the capacity change if a scaling point isn't found in the timeout period.</p>
        pub fn timeout_action(mut self, input: impl Into<std::string::String>) -> Self {
            self.timeout_action = Some(input.into());
            self
        }
        /// <p>The action that occurs when Aurora times out while attempting to change the capacity of an Aurora Serverless cluster. The value is either <code>ForceApplyCapacityChange</code> or <code>RollbackCapacityChange</code>.</p>
        /// <p> <code>ForceApplyCapacityChange</code>, the default, sets the capacity to the specified value as soon as possible.</p>
        /// <p> <code>RollbackCapacityChange</code> ignores the capacity change if a scaling point isn't found in the timeout period.</p>
        pub fn set_timeout_action(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.timeout_action = input;
            self
        }
        /// <p>The number of seconds before scaling times out. What happens when an attempted scaling action times out is determined by the <code>TimeoutAction</code> setting.</p>
        pub fn seconds_before_timeout(mut self, input: i32) -> Self {
            self.seconds_before_timeout = Some(input);
            self
        }
        /// <p>The number of seconds before scaling times out. What happens when an attempted scaling action times out is determined by the <code>TimeoutAction</code> setting.</p>
        pub fn set_seconds_before_timeout(mut self, input: std::option::Option<i32>) -> Self {
            self.seconds_before_timeout = input;
            self
        }
        /// Consumes the builder and constructs a [`ScalingConfigurationInfo`](crate::model::ScalingConfigurationInfo)
        pub fn build(self) -> crate::model::ScalingConfigurationInfo {
            crate::model::ScalingConfigurationInfo {
                min_capacity: self.min_capacity,
                max_capacity: self.max_capacity,
                auto_pause: self.auto_pause,
                seconds_until_auto_pause: self.seconds_until_auto_pause,
                timeout_action: self.timeout_action,
                seconds_before_timeout: self.seconds_before_timeout,
            }
        }
    }
}
impl ScalingConfigurationInfo {
    /// Creates a new builder-style object to manufacture [`ScalingConfigurationInfo`](crate::model::ScalingConfigurationInfo)
    pub fn builder() -> crate::model::scaling_configuration_info::Builder {
        crate::model::scaling_configuration_info::Builder::default()
    }
}

/// <p>Describes an Amazon Web Services Identity and Access Management (IAM) role that is associated with a DB cluster.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DbClusterRole {
    /// <p>The Amazon Resource Name (ARN) of the IAM role that is associated with the DB cluster.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>Describes the state of association between the IAM role and the DB cluster. The Status property returns one of the following values:</p>
    /// <ul>
    /// <li> <p> <code>ACTIVE</code> - the IAM role ARN is associated with the DB cluster and can be used to access other Amazon Web Services on your behalf.</p> </li>
    /// <li> <p> <code>PENDING</code> - the IAM role ARN is being associated with the DB cluster.</p> </li>
    /// <li> <p> <code>INVALID</code> - the IAM role ARN is associated with the DB cluster, but the DB cluster is unable to assume the IAM role in order to access other Amazon Web Services on your behalf.</p> </li>
    /// </ul>
    pub status: std::option::Option<std::string::String>,
    /// <p>The name of the feature associated with the Amazon Web Services Identity and Access Management (IAM) role. For information about supported feature names, see <code>DBEngineVersion</code>. </p>
    pub feature_name: std::option::Option<std::string::String>,
}
impl DbClusterRole {
    /// <p>The Amazon Resource Name (ARN) of the IAM role that is associated with the DB cluster.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>Describes the state of association between the IAM role and the DB cluster. The Status property returns one of the following values:</p>
    /// <ul>
    /// <li> <p> <code>ACTIVE</code> - the IAM role ARN is associated with the DB cluster and can be used to access other Amazon Web Services on your behalf.</p> </li>
    /// <li> <p> <code>PENDING</code> - the IAM role ARN is being associated with the DB cluster.</p> </li>
    /// <li> <p> <code>INVALID</code> - the IAM role ARN is associated with the DB cluster, but the DB cluster is unable to assume the IAM role in order to access other Amazon Web Services on your behalf.</p> </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>The name of the feature associated with the Amazon Web Services Identity and Access Management (IAM) role. For information about supported feature names, see <code>DBEngineVersion</code>. </p>
    pub fn feature_name(&self) -> std::option::Option<&str> {
        self.feature_name.as_deref()
    }
}
impl std::fmt::Debug for DbClusterRole {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DbClusterRole");
        formatter.field("role_arn", &self.role_arn);
        formatter.field("status", &self.status);
        formatter.field("feature_name", &self.feature_name);
        formatter.finish()
    }
}
/// See [`DbClusterRole`](crate::model::DbClusterRole)
pub mod db_cluster_role {
    /// A builder for [`DbClusterRole`](crate::model::DbClusterRole)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) feature_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the IAM role that is associated with the DB cluster.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role that is associated with the DB cluster.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>Describes the state of association between the IAM role and the DB cluster. The Status property returns one of the following values:</p>
        /// <ul>
        /// <li> <p> <code>ACTIVE</code> - the IAM role ARN is associated with the DB cluster and can be used to access other Amazon Web Services on your behalf.</p> </li>
        /// <li> <p> <code>PENDING</code> - the IAM role ARN is being associated with the DB cluster.</p> </li>
        /// <li> <p> <code>INVALID</code> - the IAM role ARN is associated with the DB cluster, but the DB cluster is unable to assume the IAM role in order to access other Amazon Web Services on your behalf.</p> </li>
        /// </ul>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>Describes the state of association between the IAM role and the DB cluster. The Status property returns one of the following values:</p>
        /// <ul>
        /// <li> <p> <code>ACTIVE</code> - the IAM role ARN is associated with the DB cluster and can be used to access other Amazon Web Services on your behalf.</p> </li>
        /// <li> <p> <code>PENDING</code> - the IAM role ARN is being associated with the DB cluster.</p> </li>
        /// <li> <p> <code>INVALID</code> - the IAM role ARN is associated with the DB cluster, but the DB cluster is unable to assume the IAM role in order to access other Amazon Web Services on your behalf.</p> </li>
        /// </ul>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>The name of the feature associated with the Amazon Web Services Identity and Access Management (IAM) role. For information about supported feature names, see <code>DBEngineVersion</code>. </p>
        pub fn feature_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.feature_name = Some(input.into());
            self
        }
        /// <p>The name of the feature associated with the Amazon Web Services Identity and Access Management (IAM) role. For information about supported feature names, see <code>DBEngineVersion</code>. </p>
        pub fn set_feature_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.feature_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DbClusterRole`](crate::model::DbClusterRole)
        pub fn build(self) -> crate::model::DbClusterRole {
            crate::model::DbClusterRole {
                role_arn: self.role_arn,
                status: self.status,
                feature_name: self.feature_name,
            }
        }
    }
}
impl DbClusterRole {
    /// Creates a new builder-style object to manufacture [`DbClusterRole`](crate::model::DbClusterRole)
    pub fn builder() -> crate::model::db_cluster_role::Builder {
        crate::model::db_cluster_role::Builder::default()
    }
}

/// <p>Contains information about an instance that is part of a DB cluster.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DbClusterMember {
    /// <p>Specifies the instance identifier for this member of the DB cluster.</p>
    pub db_instance_identifier: std::option::Option<std::string::String>,
    /// <p>Value that is <code>true</code> if the cluster member is the primary instance for the DB cluster and <code>false</code> otherwise.</p>
    pub is_cluster_writer: bool,
    /// <p>Specifies the status of the DB cluster parameter group for this member of the DB cluster.</p>
    pub db_cluster_parameter_group_status: std::option::Option<std::string::String>,
    /// <p>A value that specifies the order in which an Aurora Replica is promoted to the primary instance after a failure of the existing primary instance. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.FaultTolerance"> Fault Tolerance for an Aurora DB Cluster</a> in the <i>Amazon Aurora User Guide</i>. </p>
    pub promotion_tier: std::option::Option<i32>,
}
impl DbClusterMember {
    /// <p>Specifies the instance identifier for this member of the DB cluster.</p>
    pub fn db_instance_identifier(&self) -> std::option::Option<&str> {
        self.db_instance_identifier.as_deref()
    }
    /// <p>Value that is <code>true</code> if the cluster member is the primary instance for the DB cluster and <code>false</code> otherwise.</p>
    pub fn is_cluster_writer(&self) -> bool {
        self.is_cluster_writer
    }
    /// <p>Specifies the status of the DB cluster parameter group for this member of the DB cluster.</p>
    pub fn db_cluster_parameter_group_status(&self) -> std::option::Option<&str> {
        self.db_cluster_parameter_group_status.as_deref()
    }
    /// <p>A value that specifies the order in which an Aurora Replica is promoted to the primary instance after a failure of the existing primary instance. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.FaultTolerance"> Fault Tolerance for an Aurora DB Cluster</a> in the <i>Amazon Aurora User Guide</i>. </p>
    pub fn promotion_tier(&self) -> std::option::Option<i32> {
        self.promotion_tier
    }
}
impl std::fmt::Debug for DbClusterMember {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DbClusterMember");
        formatter.field("db_instance_identifier", &self.db_instance_identifier);
        formatter.field("is_cluster_writer", &self.is_cluster_writer);
        formatter.field(
            "db_cluster_parameter_group_status",
            &self.db_cluster_parameter_group_status,
        );
        formatter.field("promotion_tier", &self.promotion_tier);
        formatter.finish()
    }
}
/// See [`DbClusterMember`](crate::model::DbClusterMember)
pub mod db_cluster_member {
    /// A builder for [`DbClusterMember`](crate::model::DbClusterMember)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_instance_identifier: std::option::Option<std::string::String>,
        pub(crate) is_cluster_writer: std::option::Option<bool>,
        pub(crate) db_cluster_parameter_group_status: std::option::Option<std::string::String>,
        pub(crate) promotion_tier: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Specifies the instance identifier for this member of the DB cluster.</p>
        pub fn db_instance_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_instance_identifier = Some(input.into());
            self
        }
        /// <p>Specifies the instance identifier for this member of the DB cluster.</p>
        pub fn set_db_instance_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_instance_identifier = input;
            self
        }
        /// <p>Value that is <code>true</code> if the cluster member is the primary instance for the DB cluster and <code>false</code> otherwise.</p>
        pub fn is_cluster_writer(mut self, input: bool) -> Self {
            self.is_cluster_writer = Some(input);
            self
        }
        /// <p>Value that is <code>true</code> if the cluster member is the primary instance for the DB cluster and <code>false</code> otherwise.</p>
        pub fn set_is_cluster_writer(mut self, input: std::option::Option<bool>) -> Self {
            self.is_cluster_writer = input;
            self
        }
        /// <p>Specifies the status of the DB cluster parameter group for this member of the DB cluster.</p>
        pub fn db_cluster_parameter_group_status(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.db_cluster_parameter_group_status = Some(input.into());
            self
        }
        /// <p>Specifies the status of the DB cluster parameter group for this member of the DB cluster.</p>
        pub fn set_db_cluster_parameter_group_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_parameter_group_status = input;
            self
        }
        /// <p>A value that specifies the order in which an Aurora Replica is promoted to the primary instance after a failure of the existing primary instance. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.FaultTolerance"> Fault Tolerance for an Aurora DB Cluster</a> in the <i>Amazon Aurora User Guide</i>. </p>
        pub fn promotion_tier(mut self, input: i32) -> Self {
            self.promotion_tier = Some(input);
            self
        }
        /// <p>A value that specifies the order in which an Aurora Replica is promoted to the primary instance after a failure of the existing primary instance. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.FaultTolerance"> Fault Tolerance for an Aurora DB Cluster</a> in the <i>Amazon Aurora User Guide</i>. </p>
        pub fn set_promotion_tier(mut self, input: std::option::Option<i32>) -> Self {
            self.promotion_tier = input;
            self
        }
        /// Consumes the builder and constructs a [`DbClusterMember`](crate::model::DbClusterMember)
        pub fn build(self) -> crate::model::DbClusterMember {
            crate::model::DbClusterMember {
                db_instance_identifier: self.db_instance_identifier,
                is_cluster_writer: self.is_cluster_writer.unwrap_or_default(),
                db_cluster_parameter_group_status: self.db_cluster_parameter_group_status,
                promotion_tier: self.promotion_tier,
            }
        }
    }
}
impl DbClusterMember {
    /// Creates a new builder-style object to manufacture [`DbClusterMember`](crate::model::DbClusterMember)
    pub fn builder() -> crate::model::db_cluster_member::Builder {
        crate::model::db_cluster_member::Builder::default()
    }
}

/// <p>Contains status information for a DB cluster option group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DbClusterOptionGroupStatus {
    /// <p>Specifies the name of the DB cluster option group.</p>
    pub db_cluster_option_group_name: std::option::Option<std::string::String>,
    /// <p>Specifies the status of the DB cluster option group.</p>
    pub status: std::option::Option<std::string::String>,
}
impl DbClusterOptionGroupStatus {
    /// <p>Specifies the name of the DB cluster option group.</p>
    pub fn db_cluster_option_group_name(&self) -> std::option::Option<&str> {
        self.db_cluster_option_group_name.as_deref()
    }
    /// <p>Specifies the status of the DB cluster option group.</p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
}
impl std::fmt::Debug for DbClusterOptionGroupStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DbClusterOptionGroupStatus");
        formatter.field(
            "db_cluster_option_group_name",
            &self.db_cluster_option_group_name,
        );
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`DbClusterOptionGroupStatus`](crate::model::DbClusterOptionGroupStatus)
pub mod db_cluster_option_group_status {
    /// A builder for [`DbClusterOptionGroupStatus`](crate::model::DbClusterOptionGroupStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster_option_group_name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies the name of the DB cluster option group.</p>
        pub fn db_cluster_option_group_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.db_cluster_option_group_name = Some(input.into());
            self
        }
        /// <p>Specifies the name of the DB cluster option group.</p>
        pub fn set_db_cluster_option_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_option_group_name = input;
            self
        }
        /// <p>Specifies the status of the DB cluster option group.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>Specifies the status of the DB cluster option group.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`DbClusterOptionGroupStatus`](crate::model::DbClusterOptionGroupStatus)
        pub fn build(self) -> crate::model::DbClusterOptionGroupStatus {
            crate::model::DbClusterOptionGroupStatus {
                db_cluster_option_group_name: self.db_cluster_option_group_name,
                status: self.status,
            }
        }
    }
}
impl DbClusterOptionGroupStatus {
    /// Creates a new builder-style object to manufacture [`DbClusterOptionGroupStatus`](crate::model::DbClusterOptionGroupStatus)
    pub fn builder() -> crate::model::db_cluster_option_group_status::Builder {
        crate::model::db_cluster_option_group_status::Builder::default()
    }
}

/// <p>Contains the details for an Amazon RDS DB security group. </p>
/// <p>This data type is used as a response element in the <code>DescribeDBSecurityGroups</code> action. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DbSecurityGroup {
    /// <p>Provides the Amazon Web Services ID of the owner of a specific DB security group.</p>
    pub owner_id: std::option::Option<std::string::String>,
    /// <p>Specifies the name of the DB security group.</p>
    pub db_security_group_name: std::option::Option<std::string::String>,
    /// <p>Provides the description of the DB security group.</p>
    pub db_security_group_description: std::option::Option<std::string::String>,
    /// <p>Provides the VpcId of the DB security group.</p>
    pub vpc_id: std::option::Option<std::string::String>,
    /// <p> Contains a list of <code>EC2SecurityGroup</code> elements. </p>
    pub ec2_security_groups: std::option::Option<std::vec::Vec<crate::model::Ec2SecurityGroup>>,
    /// <p> Contains a list of <code>IPRange</code> elements. </p>
    pub ip_ranges: std::option::Option<std::vec::Vec<crate::model::IpRange>>,
    /// <p>The Amazon Resource Name (ARN) for the DB security group.</p>
    pub db_security_group_arn: std::option::Option<std::string::String>,
}
impl DbSecurityGroup {
    /// <p>Provides the Amazon Web Services ID of the owner of a specific DB security group.</p>
    pub fn owner_id(&self) -> std::option::Option<&str> {
        self.owner_id.as_deref()
    }
    /// <p>Specifies the name of the DB security group.</p>
    pub fn db_security_group_name(&self) -> std::option::Option<&str> {
        self.db_security_group_name.as_deref()
    }
    /// <p>Provides the description of the DB security group.</p>
    pub fn db_security_group_description(&self) -> std::option::Option<&str> {
        self.db_security_group_description.as_deref()
    }
    /// <p>Provides the VpcId of the DB security group.</p>
    pub fn vpc_id(&self) -> std::option::Option<&str> {
        self.vpc_id.as_deref()
    }
    /// <p> Contains a list of <code>EC2SecurityGroup</code> elements. </p>
    pub fn ec2_security_groups(&self) -> std::option::Option<&[crate::model::Ec2SecurityGroup]> {
        self.ec2_security_groups.as_deref()
    }
    /// <p> Contains a list of <code>IPRange</code> elements. </p>
    pub fn ip_ranges(&self) -> std::option::Option<&[crate::model::IpRange]> {
        self.ip_ranges.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) for the DB security group.</p>
    pub fn db_security_group_arn(&self) -> std::option::Option<&str> {
        self.db_security_group_arn.as_deref()
    }
}
impl std::fmt::Debug for DbSecurityGroup {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DbSecurityGroup");
        formatter.field("owner_id", &self.owner_id);
        formatter.field("db_security_group_name", &self.db_security_group_name);
        formatter.field(
            "db_security_group_description",
            &self.db_security_group_description,
        );
        formatter.field("vpc_id", &self.vpc_id);
        formatter.field("ec2_security_groups", &self.ec2_security_groups);
        formatter.field("ip_ranges", &self.ip_ranges);
        formatter.field("db_security_group_arn", &self.db_security_group_arn);
        formatter.finish()
    }
}
/// See [`DbSecurityGroup`](crate::model::DbSecurityGroup)
pub mod db_security_group {
    /// A builder for [`DbSecurityGroup`](crate::model::DbSecurityGroup)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) owner_id: std::option::Option<std::string::String>,
        pub(crate) db_security_group_name: std::option::Option<std::string::String>,
        pub(crate) db_security_group_description: std::option::Option<std::string::String>,
        pub(crate) vpc_id: std::option::Option<std::string::String>,
        pub(crate) ec2_security_groups:
            std::option::Option<std::vec::Vec<crate::model::Ec2SecurityGroup>>,
        pub(crate) ip_ranges: std::option::Option<std::vec::Vec<crate::model::IpRange>>,
        pub(crate) db_security_group_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Provides the Amazon Web Services ID of the owner of a specific DB security group.</p>
        pub fn owner_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.owner_id = Some(input.into());
            self
        }
        /// <p>Provides the Amazon Web Services ID of the owner of a specific DB security group.</p>
        pub fn set_owner_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.owner_id = input;
            self
        }
        /// <p>Specifies the name of the DB security group.</p>
        pub fn db_security_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_security_group_name = Some(input.into());
            self
        }
        /// <p>Specifies the name of the DB security group.</p>
        pub fn set_db_security_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_security_group_name = input;
            self
        }
        /// <p>Provides the description of the DB security group.</p>
        pub fn db_security_group_description(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.db_security_group_description = Some(input.into());
            self
        }
        /// <p>Provides the description of the DB security group.</p>
        pub fn set_db_security_group_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_security_group_description = input;
            self
        }
        /// <p>Provides the VpcId of the DB security group.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_id = Some(input.into());
            self
        }
        /// <p>Provides the VpcId of the DB security group.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_id = input;
            self
        }
        /// Appends an item to `ec2_security_groups`.
        ///
        /// To override the contents of this collection use [`set_ec2_security_groups`](Self::set_ec2_security_groups).
        ///
        /// <p> Contains a list of <code>EC2SecurityGroup</code> elements. </p>
        pub fn ec2_security_groups(mut self, input: crate::model::Ec2SecurityGroup) -> Self {
            let mut v = self.ec2_security_groups.unwrap_or_default();
            v.push(input);
            self.ec2_security_groups = Some(v);
            self
        }
        /// <p> Contains a list of <code>EC2SecurityGroup</code> elements. </p>
        pub fn set_ec2_security_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Ec2SecurityGroup>>,
        ) -> Self {
            self.ec2_security_groups = input;
            self
        }
        /// Appends an item to `ip_ranges`.
        ///
        /// To override the contents of this collection use [`set_ip_ranges`](Self::set_ip_ranges).
        ///
        /// <p> Contains a list of <code>IPRange</code> elements. </p>
        pub fn ip_ranges(mut self, input: crate::model::IpRange) -> Self {
            let mut v = self.ip_ranges.unwrap_or_default();
            v.push(input);
            self.ip_ranges = Some(v);
            self
        }
        /// <p> Contains a list of <code>IPRange</code> elements. </p>
        pub fn set_ip_ranges(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::IpRange>>,
        ) -> Self {
            self.ip_ranges = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the DB security group.</p>
        pub fn db_security_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_security_group_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the DB security group.</p>
        pub fn set_db_security_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_security_group_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DbSecurityGroup`](crate::model::DbSecurityGroup)
        pub fn build(self) -> crate::model::DbSecurityGroup {
            crate::model::DbSecurityGroup {
                owner_id: self.owner_id,
                db_security_group_name: self.db_security_group_name,
                db_security_group_description: self.db_security_group_description,
                vpc_id: self.vpc_id,
                ec2_security_groups: self.ec2_security_groups,
                ip_ranges: self.ip_ranges,
                db_security_group_arn: self.db_security_group_arn,
            }
        }
    }
}
impl DbSecurityGroup {
    /// Creates a new builder-style object to manufacture [`DbSecurityGroup`](crate::model::DbSecurityGroup)
    pub fn builder() -> crate::model::db_security_group::Builder {
        crate::model::db_security_group::Builder::default()
    }
}

/// <p> This data type is used as a response element in the <code>DescribeDBSecurityGroups</code> action. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IpRange {
    /// <p>Specifies the status of the IP range. Status can be "authorizing", "authorized", "revoking", and "revoked".</p>
    pub status: std::option::Option<std::string::String>,
    /// <p>Specifies the IP range.</p>
    pub cidrip: std::option::Option<std::string::String>,
}
impl IpRange {
    /// <p>Specifies the status of the IP range. Status can be "authorizing", "authorized", "revoking", and "revoked".</p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>Specifies the IP range.</p>
    pub fn cidrip(&self) -> std::option::Option<&str> {
        self.cidrip.as_deref()
    }
}
impl std::fmt::Debug for IpRange {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IpRange");
        formatter.field("status", &self.status);
        formatter.field("cidrip", &self.cidrip);
        formatter.finish()
    }
}
/// See [`IpRange`](crate::model::IpRange)
pub mod ip_range {
    /// A builder for [`IpRange`](crate::model::IpRange)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) cidrip: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies the status of the IP range. Status can be "authorizing", "authorized", "revoking", and "revoked".</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>Specifies the status of the IP range. Status can be "authorizing", "authorized", "revoking", and "revoked".</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>Specifies the IP range.</p>
        pub fn cidrip(mut self, input: impl Into<std::string::String>) -> Self {
            self.cidrip = Some(input.into());
            self
        }
        /// <p>Specifies the IP range.</p>
        pub fn set_cidrip(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cidrip = input;
            self
        }
        /// Consumes the builder and constructs a [`IpRange`](crate::model::IpRange)
        pub fn build(self) -> crate::model::IpRange {
            crate::model::IpRange {
                status: self.status,
                cidrip: self.cidrip,
            }
        }
    }
}
impl IpRange {
    /// Creates a new builder-style object to manufacture [`IpRange`](crate::model::IpRange)
    pub fn builder() -> crate::model::ip_range::Builder {
        crate::model::ip_range::Builder::default()
    }
}

/// <p>This data type is used as a response element in the following actions:</p>
/// <ul>
/// <li> <p> <code>AuthorizeDBSecurityGroupIngress</code> </p> </li>
/// <li> <p> <code>DescribeDBSecurityGroups</code> </p> </li>
/// <li> <p> <code>RevokeDBSecurityGroupIngress</code> </p> </li>
/// </ul>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Ec2SecurityGroup {
    /// <p>Provides the status of the EC2 security group. Status can be "authorizing", "authorized", "revoking", and "revoked".</p>
    pub status: std::option::Option<std::string::String>,
    /// <p>Specifies the name of the EC2 security group.</p>
    pub ec2_security_group_name: std::option::Option<std::string::String>,
    /// <p>Specifies the id of the EC2 security group.</p>
    pub ec2_security_group_id: std::option::Option<std::string::String>,
    /// <p> Specifies the Amazon Web Services ID of the owner of the EC2 security group specified in the <code>EC2SecurityGroupName</code> field. </p>
    pub ec2_security_group_owner_id: std::option::Option<std::string::String>,
}
impl Ec2SecurityGroup {
    /// <p>Provides the status of the EC2 security group. Status can be "authorizing", "authorized", "revoking", and "revoked".</p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>Specifies the name of the EC2 security group.</p>
    pub fn ec2_security_group_name(&self) -> std::option::Option<&str> {
        self.ec2_security_group_name.as_deref()
    }
    /// <p>Specifies the id of the EC2 security group.</p>
    pub fn ec2_security_group_id(&self) -> std::option::Option<&str> {
        self.ec2_security_group_id.as_deref()
    }
    /// <p> Specifies the Amazon Web Services ID of the owner of the EC2 security group specified in the <code>EC2SecurityGroupName</code> field. </p>
    pub fn ec2_security_group_owner_id(&self) -> std::option::Option<&str> {
        self.ec2_security_group_owner_id.as_deref()
    }
}
impl std::fmt::Debug for Ec2SecurityGroup {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Ec2SecurityGroup");
        formatter.field("status", &self.status);
        formatter.field("ec2_security_group_name", &self.ec2_security_group_name);
        formatter.field("ec2_security_group_id", &self.ec2_security_group_id);
        formatter.field(
            "ec2_security_group_owner_id",
            &self.ec2_security_group_owner_id,
        );
        formatter.finish()
    }
}
/// See [`Ec2SecurityGroup`](crate::model::Ec2SecurityGroup)
pub mod ec2_security_group {
    /// A builder for [`Ec2SecurityGroup`](crate::model::Ec2SecurityGroup)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) ec2_security_group_name: std::option::Option<std::string::String>,
        pub(crate) ec2_security_group_id: std::option::Option<std::string::String>,
        pub(crate) ec2_security_group_owner_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Provides the status of the EC2 security group. Status can be "authorizing", "authorized", "revoking", and "revoked".</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>Provides the status of the EC2 security group. Status can be "authorizing", "authorized", "revoking", and "revoked".</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>Specifies the name of the EC2 security group.</p>
        pub fn ec2_security_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.ec2_security_group_name = Some(input.into());
            self
        }
        /// <p>Specifies the name of the EC2 security group.</p>
        pub fn set_ec2_security_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ec2_security_group_name = input;
            self
        }
        /// <p>Specifies the id of the EC2 security group.</p>
        pub fn ec2_security_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ec2_security_group_id = Some(input.into());
            self
        }
        /// <p>Specifies the id of the EC2 security group.</p>
        pub fn set_ec2_security_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ec2_security_group_id = input;
            self
        }
        /// <p> Specifies the Amazon Web Services ID of the owner of the EC2 security group specified in the <code>EC2SecurityGroupName</code> field. </p>
        pub fn ec2_security_group_owner_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.ec2_security_group_owner_id = Some(input.into());
            self
        }
        /// <p> Specifies the Amazon Web Services ID of the owner of the EC2 security group specified in the <code>EC2SecurityGroupName</code> field. </p>
        pub fn set_ec2_security_group_owner_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ec2_security_group_owner_id = input;
            self
        }
        /// Consumes the builder and constructs a [`Ec2SecurityGroup`](crate::model::Ec2SecurityGroup)
        pub fn build(self) -> crate::model::Ec2SecurityGroup {
            crate::model::Ec2SecurityGroup {
                status: self.status,
                ec2_security_group_name: self.ec2_security_group_name,
                ec2_security_group_id: self.ec2_security_group_id,
                ec2_security_group_owner_id: self.ec2_security_group_owner_id,
            }
        }
    }
}
impl Ec2SecurityGroup {
    /// Creates a new builder-style object to manufacture [`Ec2SecurityGroup`](crate::model::Ec2SecurityGroup)
    pub fn builder() -> crate::model::ec2_security_group::Builder {
        crate::model::ec2_security_group::Builder::default()
    }
}

/// <p>Contains the scaling configuration of an Aurora Serverless DB cluster.</p>
/// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.html">Using Amazon Aurora Serverless</a> in the <i>Amazon Aurora User Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ScalingConfiguration {
    /// <p>The minimum capacity for an Aurora DB cluster in <code>serverless</code> DB engine mode.</p>
    /// <p>For Aurora MySQL, valid capacity values are <code>1</code>, <code>2</code>, <code>4</code>, <code>8</code>, <code>16</code>, <code>32</code>, <code>64</code>, <code>128</code>, and <code>256</code>.</p>
    /// <p>For Aurora PostgreSQL, valid capacity values are <code>2</code>, <code>4</code>, <code>8</code>, <code>16</code>, <code>32</code>, <code>64</code>, <code>192</code>, and <code>384</code>.</p>
    /// <p>The minimum capacity must be less than or equal to the maximum capacity.</p>
    pub min_capacity: std::option::Option<i32>,
    /// <p>The maximum capacity for an Aurora DB cluster in <code>serverless</code> DB engine mode.</p>
    /// <p>For Aurora MySQL, valid capacity values are <code>1</code>, <code>2</code>, <code>4</code>, <code>8</code>, <code>16</code>, <code>32</code>, <code>64</code>, <code>128</code>, and <code>256</code>.</p>
    /// <p>For Aurora PostgreSQL, valid capacity values are <code>2</code>, <code>4</code>, <code>8</code>, <code>16</code>, <code>32</code>, <code>64</code>, <code>192</code>, and <code>384</code>.</p>
    /// <p>The maximum capacity must be greater than or equal to the minimum capacity.</p>
    pub max_capacity: std::option::Option<i32>,
    /// <p>A value that indicates whether to allow or disallow automatic pause for an Aurora DB cluster in <code>serverless</code> DB engine mode. A DB cluster can be paused only when it's idle (it has no connections).</p> <note>
    /// <p>If a DB cluster is paused for more than seven days, the DB cluster might be backed up with a snapshot. In this case, the DB cluster is restored when there is a request to connect to it. </p>
    /// </note>
    pub auto_pause: std::option::Option<bool>,
    /// <p>The time, in seconds, before an Aurora DB cluster in <code>serverless</code> mode is paused.</p>
    /// <p>Specify a value between 300 and 86,400 seconds.</p>
    pub seconds_until_auto_pause: std::option::Option<i32>,
    /// <p>The action to take when the timeout is reached, either <code>ForceApplyCapacityChange</code> or <code>RollbackCapacityChange</code>.</p>
    /// <p> <code>ForceApplyCapacityChange</code> sets the capacity to the specified value as soon as possible.</p>
    /// <p> <code>RollbackCapacityChange</code>, the default, ignores the capacity change if a scaling point isn't found in the timeout period.</p> <important>
    /// <p>If you specify <code>ForceApplyCapacityChange</code>, connections that prevent Aurora Serverless from finding a scaling point might be dropped.</p>
    /// </important>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.how-it-works.html#aurora-serverless.how-it-works.auto-scaling"> Autoscaling for Aurora Serverless</a> in the <i>Amazon Aurora User Guide</i>.</p>
    pub timeout_action: std::option::Option<std::string::String>,
    /// <p>The amount of time, in seconds, that Aurora Serverless tries to find a scaling point to perform seamless scaling before enforcing the timeout action. The default is 300.</p>
    /// <p>Specify a value between 60 and 600 seconds.</p>
    pub seconds_before_timeout: std::option::Option<i32>,
}
impl ScalingConfiguration {
    /// <p>The minimum capacity for an Aurora DB cluster in <code>serverless</code> DB engine mode.</p>
    /// <p>For Aurora MySQL, valid capacity values are <code>1</code>, <code>2</code>, <code>4</code>, <code>8</code>, <code>16</code>, <code>32</code>, <code>64</code>, <code>128</code>, and <code>256</code>.</p>
    /// <p>For Aurora PostgreSQL, valid capacity values are <code>2</code>, <code>4</code>, <code>8</code>, <code>16</code>, <code>32</code>, <code>64</code>, <code>192</code>, and <code>384</code>.</p>
    /// <p>The minimum capacity must be less than or equal to the maximum capacity.</p>
    pub fn min_capacity(&self) -> std::option::Option<i32> {
        self.min_capacity
    }
    /// <p>The maximum capacity for an Aurora DB cluster in <code>serverless</code> DB engine mode.</p>
    /// <p>For Aurora MySQL, valid capacity values are <code>1</code>, <code>2</code>, <code>4</code>, <code>8</code>, <code>16</code>, <code>32</code>, <code>64</code>, <code>128</code>, and <code>256</code>.</p>
    /// <p>For Aurora PostgreSQL, valid capacity values are <code>2</code>, <code>4</code>, <code>8</code>, <code>16</code>, <code>32</code>, <code>64</code>, <code>192</code>, and <code>384</code>.</p>
    /// <p>The maximum capacity must be greater than or equal to the minimum capacity.</p>
    pub fn max_capacity(&self) -> std::option::Option<i32> {
        self.max_capacity
    }
    /// <p>A value that indicates whether to allow or disallow automatic pause for an Aurora DB cluster in <code>serverless</code> DB engine mode. A DB cluster can be paused only when it's idle (it has no connections).</p> <note>
    /// <p>If a DB cluster is paused for more than seven days, the DB cluster might be backed up with a snapshot. In this case, the DB cluster is restored when there is a request to connect to it. </p>
    /// </note>
    pub fn auto_pause(&self) -> std::option::Option<bool> {
        self.auto_pause
    }
    /// <p>The time, in seconds, before an Aurora DB cluster in <code>serverless</code> mode is paused.</p>
    /// <p>Specify a value between 300 and 86,400 seconds.</p>
    pub fn seconds_until_auto_pause(&self) -> std::option::Option<i32> {
        self.seconds_until_auto_pause
    }
    /// <p>The action to take when the timeout is reached, either <code>ForceApplyCapacityChange</code> or <code>RollbackCapacityChange</code>.</p>
    /// <p> <code>ForceApplyCapacityChange</code> sets the capacity to the specified value as soon as possible.</p>
    /// <p> <code>RollbackCapacityChange</code>, the default, ignores the capacity change if a scaling point isn't found in the timeout period.</p> <important>
    /// <p>If you specify <code>ForceApplyCapacityChange</code>, connections that prevent Aurora Serverless from finding a scaling point might be dropped.</p>
    /// </important>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.how-it-works.html#aurora-serverless.how-it-works.auto-scaling"> Autoscaling for Aurora Serverless</a> in the <i>Amazon Aurora User Guide</i>.</p>
    pub fn timeout_action(&self) -> std::option::Option<&str> {
        self.timeout_action.as_deref()
    }
    /// <p>The amount of time, in seconds, that Aurora Serverless tries to find a scaling point to perform seamless scaling before enforcing the timeout action. The default is 300.</p>
    /// <p>Specify a value between 60 and 600 seconds.</p>
    pub fn seconds_before_timeout(&self) -> std::option::Option<i32> {
        self.seconds_before_timeout
    }
}
impl std::fmt::Debug for ScalingConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ScalingConfiguration");
        formatter.field("min_capacity", &self.min_capacity);
        formatter.field("max_capacity", &self.max_capacity);
        formatter.field("auto_pause", &self.auto_pause);
        formatter.field("seconds_until_auto_pause", &self.seconds_until_auto_pause);
        formatter.field("timeout_action", &self.timeout_action);
        formatter.field("seconds_before_timeout", &self.seconds_before_timeout);
        formatter.finish()
    }
}
/// See [`ScalingConfiguration`](crate::model::ScalingConfiguration)
pub mod scaling_configuration {
    /// A builder for [`ScalingConfiguration`](crate::model::ScalingConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) min_capacity: std::option::Option<i32>,
        pub(crate) max_capacity: std::option::Option<i32>,
        pub(crate) auto_pause: std::option::Option<bool>,
        pub(crate) seconds_until_auto_pause: std::option::Option<i32>,
        pub(crate) timeout_action: std::option::Option<std::string::String>,
        pub(crate) seconds_before_timeout: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The minimum capacity for an Aurora DB cluster in <code>serverless</code> DB engine mode.</p>
        /// <p>For Aurora MySQL, valid capacity values are <code>1</code>, <code>2</code>, <code>4</code>, <code>8</code>, <code>16</code>, <code>32</code>, <code>64</code>, <code>128</code>, and <code>256</code>.</p>
        /// <p>For Aurora PostgreSQL, valid capacity values are <code>2</code>, <code>4</code>, <code>8</code>, <code>16</code>, <code>32</code>, <code>64</code>, <code>192</code>, and <code>384</code>.</p>
        /// <p>The minimum capacity must be less than or equal to the maximum capacity.</p>
        pub fn min_capacity(mut self, input: i32) -> Self {
            self.min_capacity = Some(input);
            self
        }
        /// <p>The minimum capacity for an Aurora DB cluster in <code>serverless</code> DB engine mode.</p>
        /// <p>For Aurora MySQL, valid capacity values are <code>1</code>, <code>2</code>, <code>4</code>, <code>8</code>, <code>16</code>, <code>32</code>, <code>64</code>, <code>128</code>, and <code>256</code>.</p>
        /// <p>For Aurora PostgreSQL, valid capacity values are <code>2</code>, <code>4</code>, <code>8</code>, <code>16</code>, <code>32</code>, <code>64</code>, <code>192</code>, and <code>384</code>.</p>
        /// <p>The minimum capacity must be less than or equal to the maximum capacity.</p>
        pub fn set_min_capacity(mut self, input: std::option::Option<i32>) -> Self {
            self.min_capacity = input;
            self
        }
        /// <p>The maximum capacity for an Aurora DB cluster in <code>serverless</code> DB engine mode.</p>
        /// <p>For Aurora MySQL, valid capacity values are <code>1</code>, <code>2</code>, <code>4</code>, <code>8</code>, <code>16</code>, <code>32</code>, <code>64</code>, <code>128</code>, and <code>256</code>.</p>
        /// <p>For Aurora PostgreSQL, valid capacity values are <code>2</code>, <code>4</code>, <code>8</code>, <code>16</code>, <code>32</code>, <code>64</code>, <code>192</code>, and <code>384</code>.</p>
        /// <p>The maximum capacity must be greater than or equal to the minimum capacity.</p>
        pub fn max_capacity(mut self, input: i32) -> Self {
            self.max_capacity = Some(input);
            self
        }
        /// <p>The maximum capacity for an Aurora DB cluster in <code>serverless</code> DB engine mode.</p>
        /// <p>For Aurora MySQL, valid capacity values are <code>1</code>, <code>2</code>, <code>4</code>, <code>8</code>, <code>16</code>, <code>32</code>, <code>64</code>, <code>128</code>, and <code>256</code>.</p>
        /// <p>For Aurora PostgreSQL, valid capacity values are <code>2</code>, <code>4</code>, <code>8</code>, <code>16</code>, <code>32</code>, <code>64</code>, <code>192</code>, and <code>384</code>.</p>
        /// <p>The maximum capacity must be greater than or equal to the minimum capacity.</p>
        pub fn set_max_capacity(mut self, input: std::option::Option<i32>) -> Self {
            self.max_capacity = input;
            self
        }
        /// <p>A value that indicates whether to allow or disallow automatic pause for an Aurora DB cluster in <code>serverless</code> DB engine mode. A DB cluster can be paused only when it's idle (it has no connections).</p> <note>
        /// <p>If a DB cluster is paused for more than seven days, the DB cluster might be backed up with a snapshot. In this case, the DB cluster is restored when there is a request to connect to it. </p>
        /// </note>
        pub fn auto_pause(mut self, input: bool) -> Self {
            self.auto_pause = Some(input);
            self
        }
        /// <p>A value that indicates whether to allow or disallow automatic pause for an Aurora DB cluster in <code>serverless</code> DB engine mode. A DB cluster can be paused only when it's idle (it has no connections).</p> <note>
        /// <p>If a DB cluster is paused for more than seven days, the DB cluster might be backed up with a snapshot. In this case, the DB cluster is restored when there is a request to connect to it. </p>
        /// </note>
        pub fn set_auto_pause(mut self, input: std::option::Option<bool>) -> Self {
            self.auto_pause = input;
            self
        }
        /// <p>The time, in seconds, before an Aurora DB cluster in <code>serverless</code> mode is paused.</p>
        /// <p>Specify a value between 300 and 86,400 seconds.</p>
        pub fn seconds_until_auto_pause(mut self, input: i32) -> Self {
            self.seconds_until_auto_pause = Some(input);
            self
        }
        /// <p>The time, in seconds, before an Aurora DB cluster in <code>serverless</code> mode is paused.</p>
        /// <p>Specify a value between 300 and 86,400 seconds.</p>
        pub fn set_seconds_until_auto_pause(mut self, input: std::option::Option<i32>) -> Self {
            self.seconds_until_auto_pause = input;
            self
        }
        /// <p>The action to take when the timeout is reached, either <code>ForceApplyCapacityChange</code> or <code>RollbackCapacityChange</code>.</p>
        /// <p> <code>ForceApplyCapacityChange</code> sets the capacity to the specified value as soon as possible.</p>
        /// <p> <code>RollbackCapacityChange</code>, the default, ignores the capacity change if a scaling point isn't found in the timeout period.</p> <important>
        /// <p>If you specify <code>ForceApplyCapacityChange</code>, connections that prevent Aurora Serverless from finding a scaling point might be dropped.</p>
        /// </important>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.how-it-works.html#aurora-serverless.how-it-works.auto-scaling"> Autoscaling for Aurora Serverless</a> in the <i>Amazon Aurora User Guide</i>.</p>
        pub fn timeout_action(mut self, input: impl Into<std::string::String>) -> Self {
            self.timeout_action = Some(input.into());
            self
        }
        /// <p>The action to take when the timeout is reached, either <code>ForceApplyCapacityChange</code> or <code>RollbackCapacityChange</code>.</p>
        /// <p> <code>ForceApplyCapacityChange</code> sets the capacity to the specified value as soon as possible.</p>
        /// <p> <code>RollbackCapacityChange</code>, the default, ignores the capacity change if a scaling point isn't found in the timeout period.</p> <important>
        /// <p>If you specify <code>ForceApplyCapacityChange</code>, connections that prevent Aurora Serverless from finding a scaling point might be dropped.</p>
        /// </important>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.how-it-works.html#aurora-serverless.how-it-works.auto-scaling"> Autoscaling for Aurora Serverless</a> in the <i>Amazon Aurora User Guide</i>.</p>
        pub fn set_timeout_action(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.timeout_action = input;
            self
        }
        /// <p>The amount of time, in seconds, that Aurora Serverless tries to find a scaling point to perform seamless scaling before enforcing the timeout action. The default is 300.</p>
        /// <p>Specify a value between 60 and 600 seconds.</p>
        pub fn seconds_before_timeout(mut self, input: i32) -> Self {
            self.seconds_before_timeout = Some(input);
            self
        }
        /// <p>The amount of time, in seconds, that Aurora Serverless tries to find a scaling point to perform seamless scaling before enforcing the timeout action. The default is 300.</p>
        /// <p>Specify a value between 60 and 600 seconds.</p>
        pub fn set_seconds_before_timeout(mut self, input: std::option::Option<i32>) -> Self {
            self.seconds_before_timeout = input;
            self
        }
        /// Consumes the builder and constructs a [`ScalingConfiguration`](crate::model::ScalingConfiguration)
        pub fn build(self) -> crate::model::ScalingConfiguration {
            crate::model::ScalingConfiguration {
                min_capacity: self.min_capacity,
                max_capacity: self.max_capacity,
                auto_pause: self.auto_pause,
                seconds_until_auto_pause: self.seconds_until_auto_pause,
                timeout_action: self.timeout_action,
                seconds_before_timeout: self.seconds_before_timeout,
            }
        }
    }
}
impl ScalingConfiguration {
    /// Creates a new builder-style object to manufacture [`ScalingConfiguration`](crate::model::ScalingConfiguration)
    pub fn builder() -> crate::model::scaling_configuration::Builder {
        crate::model::scaling_configuration::Builder::default()
    }
}

/// <p> This data type is used as a request parameter in the <code>ModifyDBParameterGroup</code> and <code>ResetDBParameterGroup</code> actions. </p>
/// <p>This data type is used as a response element in the <code>DescribeEngineDefaultParameters</code> and <code>DescribeDBParameters</code> actions.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Parameter {
    /// <p>Specifies the name of the parameter.</p>
    pub parameter_name: std::option::Option<std::string::String>,
    /// <p>Specifies the value of the parameter.</p>
    pub parameter_value: std::option::Option<std::string::String>,
    /// <p>Provides a description of the parameter.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Indicates the source of the parameter value.</p>
    pub source: std::option::Option<std::string::String>,
    /// <p>Specifies the engine specific parameters type.</p>
    pub apply_type: std::option::Option<std::string::String>,
    /// <p>Specifies the valid data type for the parameter.</p>
    pub data_type: std::option::Option<std::string::String>,
    /// <p>Specifies the valid range of values for the parameter.</p>
    pub allowed_values: std::option::Option<std::string::String>,
    /// <p> Indicates whether (<code>true</code>) or not (<code>false</code>) the parameter can be modified. Some parameters have security or operational implications that prevent them from being changed. </p>
    pub is_modifiable: bool,
    /// <p>The earliest engine version to which the parameter can apply.</p>
    pub minimum_engine_version: std::option::Option<std::string::String>,
    /// <p>Indicates when to apply parameter updates.</p>
    pub apply_method: std::option::Option<crate::model::ApplyMethod>,
    /// <p>The valid DB engine modes.</p>
    pub supported_engine_modes: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl Parameter {
    /// <p>Specifies the name of the parameter.</p>
    pub fn parameter_name(&self) -> std::option::Option<&str> {
        self.parameter_name.as_deref()
    }
    /// <p>Specifies the value of the parameter.</p>
    pub fn parameter_value(&self) -> std::option::Option<&str> {
        self.parameter_value.as_deref()
    }
    /// <p>Provides a description of the parameter.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Indicates the source of the parameter value.</p>
    pub fn source(&self) -> std::option::Option<&str> {
        self.source.as_deref()
    }
    /// <p>Specifies the engine specific parameters type.</p>
    pub fn apply_type(&self) -> std::option::Option<&str> {
        self.apply_type.as_deref()
    }
    /// <p>Specifies the valid data type for the parameter.</p>
    pub fn data_type(&self) -> std::option::Option<&str> {
        self.data_type.as_deref()
    }
    /// <p>Specifies the valid range of values for the parameter.</p>
    pub fn allowed_values(&self) -> std::option::Option<&str> {
        self.allowed_values.as_deref()
    }
    /// <p> Indicates whether (<code>true</code>) or not (<code>false</code>) the parameter can be modified. Some parameters have security or operational implications that prevent them from being changed. </p>
    pub fn is_modifiable(&self) -> bool {
        self.is_modifiable
    }
    /// <p>The earliest engine version to which the parameter can apply.</p>
    pub fn minimum_engine_version(&self) -> std::option::Option<&str> {
        self.minimum_engine_version.as_deref()
    }
    /// <p>Indicates when to apply parameter updates.</p>
    pub fn apply_method(&self) -> std::option::Option<&crate::model::ApplyMethod> {
        self.apply_method.as_ref()
    }
    /// <p>The valid DB engine modes.</p>
    pub fn supported_engine_modes(&self) -> std::option::Option<&[std::string::String]> {
        self.supported_engine_modes.as_deref()
    }
}
impl std::fmt::Debug for Parameter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Parameter");
        formatter.field("parameter_name", &self.parameter_name);
        formatter.field("parameter_value", &self.parameter_value);
        formatter.field("description", &self.description);
        formatter.field("source", &self.source);
        formatter.field("apply_type", &self.apply_type);
        formatter.field("data_type", &self.data_type);
        formatter.field("allowed_values", &self.allowed_values);
        formatter.field("is_modifiable", &self.is_modifiable);
        formatter.field("minimum_engine_version", &self.minimum_engine_version);
        formatter.field("apply_method", &self.apply_method);
        formatter.field("supported_engine_modes", &self.supported_engine_modes);
        formatter.finish()
    }
}
/// See [`Parameter`](crate::model::Parameter)
pub mod parameter {
    /// A builder for [`Parameter`](crate::model::Parameter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) parameter_name: std::option::Option<std::string::String>,
        pub(crate) parameter_value: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) source: std::option::Option<std::string::String>,
        pub(crate) apply_type: std::option::Option<std::string::String>,
        pub(crate) data_type: std::option::Option<std::string::String>,
        pub(crate) allowed_values: std::option::Option<std::string::String>,
        pub(crate) is_modifiable: std::option::Option<bool>,
        pub(crate) minimum_engine_version: std::option::Option<std::string::String>,
        pub(crate) apply_method: std::option::Option<crate::model::ApplyMethod>,
        pub(crate) supported_engine_modes: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>Specifies the name of the parameter.</p>
        pub fn parameter_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.parameter_name = Some(input.into());
            self
        }
        /// <p>Specifies the name of the parameter.</p>
        pub fn set_parameter_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parameter_name = input;
            self
        }
        /// <p>Specifies the value of the parameter.</p>
        pub fn parameter_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.parameter_value = Some(input.into());
            self
        }
        /// <p>Specifies the value of the parameter.</p>
        pub fn set_parameter_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.parameter_value = input;
            self
        }
        /// <p>Provides a description of the parameter.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>Provides a description of the parameter.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Indicates the source of the parameter value.</p>
        pub fn source(mut self, input: impl Into<std::string::String>) -> Self {
            self.source = Some(input.into());
            self
        }
        /// <p>Indicates the source of the parameter value.</p>
        pub fn set_source(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source = input;
            self
        }
        /// <p>Specifies the engine specific parameters type.</p>
        pub fn apply_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.apply_type = Some(input.into());
            self
        }
        /// <p>Specifies the engine specific parameters type.</p>
        pub fn set_apply_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.apply_type = input;
            self
        }
        /// <p>Specifies the valid data type for the parameter.</p>
        pub fn data_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_type = Some(input.into());
            self
        }
        /// <p>Specifies the valid data type for the parameter.</p>
        pub fn set_data_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data_type = input;
            self
        }
        /// <p>Specifies the valid range of values for the parameter.</p>
        pub fn allowed_values(mut self, input: impl Into<std::string::String>) -> Self {
            self.allowed_values = Some(input.into());
            self
        }
        /// <p>Specifies the valid range of values for the parameter.</p>
        pub fn set_allowed_values(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.allowed_values = input;
            self
        }
        /// <p> Indicates whether (<code>true</code>) or not (<code>false</code>) the parameter can be modified. Some parameters have security or operational implications that prevent them from being changed. </p>
        pub fn is_modifiable(mut self, input: bool) -> Self {
            self.is_modifiable = Some(input);
            self
        }
        /// <p> Indicates whether (<code>true</code>) or not (<code>false</code>) the parameter can be modified. Some parameters have security or operational implications that prevent them from being changed. </p>
        pub fn set_is_modifiable(mut self, input: std::option::Option<bool>) -> Self {
            self.is_modifiable = input;
            self
        }
        /// <p>The earliest engine version to which the parameter can apply.</p>
        pub fn minimum_engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.minimum_engine_version = Some(input.into());
            self
        }
        /// <p>The earliest engine version to which the parameter can apply.</p>
        pub fn set_minimum_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.minimum_engine_version = input;
            self
        }
        /// <p>Indicates when to apply parameter updates.</p>
        pub fn apply_method(mut self, input: crate::model::ApplyMethod) -> Self {
            self.apply_method = Some(input);
            self
        }
        /// <p>Indicates when to apply parameter updates.</p>
        pub fn set_apply_method(
            mut self,
            input: std::option::Option<crate::model::ApplyMethod>,
        ) -> Self {
            self.apply_method = input;
            self
        }
        /// Appends an item to `supported_engine_modes`.
        ///
        /// To override the contents of this collection use [`set_supported_engine_modes`](Self::set_supported_engine_modes).
        ///
        /// <p>The valid DB engine modes.</p>
        pub fn supported_engine_modes(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.supported_engine_modes.unwrap_or_default();
            v.push(input.into());
            self.supported_engine_modes = Some(v);
            self
        }
        /// <p>The valid DB engine modes.</p>
        pub fn set_supported_engine_modes(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.supported_engine_modes = input;
            self
        }
        /// Consumes the builder and constructs a [`Parameter`](crate::model::Parameter)
        pub fn build(self) -> crate::model::Parameter {
            crate::model::Parameter {
                parameter_name: self.parameter_name,
                parameter_value: self.parameter_value,
                description: self.description,
                source: self.source,
                apply_type: self.apply_type,
                data_type: self.data_type,
                allowed_values: self.allowed_values,
                is_modifiable: self.is_modifiable.unwrap_or_default(),
                minimum_engine_version: self.minimum_engine_version,
                apply_method: self.apply_method,
                supported_engine_modes: self.supported_engine_modes,
            }
        }
    }
}
impl Parameter {
    /// Creates a new builder-style object to manufacture [`Parameter`](crate::model::Parameter)
    pub fn builder() -> crate::model::parameter::Builder {
        crate::model::parameter::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ApplyMethod {
    #[allow(missing_docs)] // documentation missing in model
    Immediate,
    #[allow(missing_docs)] // documentation missing in model
    PendingReboot,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ApplyMethod {
    fn from(s: &str) -> Self {
        match s {
            "immediate" => ApplyMethod::Immediate,
            "pending-reboot" => ApplyMethod::PendingReboot,
            other => ApplyMethod::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ApplyMethod {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ApplyMethod::from(s))
    }
}
impl ApplyMethod {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ApplyMethod::Immediate => "immediate",
            ApplyMethod::PendingReboot => "pending-reboot",
            ApplyMethod::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["immediate", "pending-reboot"]
    }
}
impl AsRef<str> for ApplyMethod {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains the results of a successful invocation of the <code>DescribeEventSubscriptions</code> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EventSubscription {
    /// <p>The Amazon Web Services customer account associated with the RDS event notification subscription.</p>
    pub customer_aws_id: std::option::Option<std::string::String>,
    /// <p>The RDS event notification subscription Id.</p>
    pub cust_subscription_id: std::option::Option<std::string::String>,
    /// <p>The topic ARN of the RDS event notification subscription.</p>
    pub sns_topic_arn: std::option::Option<std::string::String>,
    /// <p>The status of the RDS event notification subscription.</p>
    /// <p>Constraints:</p>
    /// <p>Can be one of the following: creating | modifying | deleting | active | no-permission | topic-not-exist</p>
    /// <p>The status "no-permission" indicates that RDS no longer has permission to post to the SNS topic. The status "topic-not-exist" indicates that the topic was deleted after the subscription was created.</p>
    pub status: std::option::Option<std::string::String>,
    /// <p>The time the RDS event notification subscription was created.</p>
    pub subscription_creation_time: std::option::Option<std::string::String>,
    /// <p>The source type for the RDS event notification subscription.</p>
    pub source_type: std::option::Option<std::string::String>,
    /// <p>A list of source IDs for the RDS event notification subscription.</p>
    pub source_ids_list: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of event categories for the RDS event notification subscription.</p>
    pub event_categories_list: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A Boolean value indicating if the subscription is enabled. True indicates the subscription is enabled.</p>
    pub enabled: bool,
    /// <p>The Amazon Resource Name (ARN) for the event subscription.</p>
    pub event_subscription_arn: std::option::Option<std::string::String>,
}
impl EventSubscription {
    /// <p>The Amazon Web Services customer account associated with the RDS event notification subscription.</p>
    pub fn customer_aws_id(&self) -> std::option::Option<&str> {
        self.customer_aws_id.as_deref()
    }
    /// <p>The RDS event notification subscription Id.</p>
    pub fn cust_subscription_id(&self) -> std::option::Option<&str> {
        self.cust_subscription_id.as_deref()
    }
    /// <p>The topic ARN of the RDS event notification subscription.</p>
    pub fn sns_topic_arn(&self) -> std::option::Option<&str> {
        self.sns_topic_arn.as_deref()
    }
    /// <p>The status of the RDS event notification subscription.</p>
    /// <p>Constraints:</p>
    /// <p>Can be one of the following: creating | modifying | deleting | active | no-permission | topic-not-exist</p>
    /// <p>The status "no-permission" indicates that RDS no longer has permission to post to the SNS topic. The status "topic-not-exist" indicates that the topic was deleted after the subscription was created.</p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>The time the RDS event notification subscription was created.</p>
    pub fn subscription_creation_time(&self) -> std::option::Option<&str> {
        self.subscription_creation_time.as_deref()
    }
    /// <p>The source type for the RDS event notification subscription.</p>
    pub fn source_type(&self) -> std::option::Option<&str> {
        self.source_type.as_deref()
    }
    /// <p>A list of source IDs for the RDS event notification subscription.</p>
    pub fn source_ids_list(&self) -> std::option::Option<&[std::string::String]> {
        self.source_ids_list.as_deref()
    }
    /// <p>A list of event categories for the RDS event notification subscription.</p>
    pub fn event_categories_list(&self) -> std::option::Option<&[std::string::String]> {
        self.event_categories_list.as_deref()
    }
    /// <p>A Boolean value indicating if the subscription is enabled. True indicates the subscription is enabled.</p>
    pub fn enabled(&self) -> bool {
        self.enabled
    }
    /// <p>The Amazon Resource Name (ARN) for the event subscription.</p>
    pub fn event_subscription_arn(&self) -> std::option::Option<&str> {
        self.event_subscription_arn.as_deref()
    }
}
impl std::fmt::Debug for EventSubscription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EventSubscription");
        formatter.field("customer_aws_id", &self.customer_aws_id);
        formatter.field("cust_subscription_id", &self.cust_subscription_id);
        formatter.field("sns_topic_arn", &self.sns_topic_arn);
        formatter.field("status", &self.status);
        formatter.field(
            "subscription_creation_time",
            &self.subscription_creation_time,
        );
        formatter.field("source_type", &self.source_type);
        formatter.field("source_ids_list", &self.source_ids_list);
        formatter.field("event_categories_list", &self.event_categories_list);
        formatter.field("enabled", &self.enabled);
        formatter.field("event_subscription_arn", &self.event_subscription_arn);
        formatter.finish()
    }
}
/// See [`EventSubscription`](crate::model::EventSubscription)
pub mod event_subscription {
    /// A builder for [`EventSubscription`](crate::model::EventSubscription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) customer_aws_id: std::option::Option<std::string::String>,
        pub(crate) cust_subscription_id: std::option::Option<std::string::String>,
        pub(crate) sns_topic_arn: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) subscription_creation_time: std::option::Option<std::string::String>,
        pub(crate) source_type: std::option::Option<std::string::String>,
        pub(crate) source_ids_list: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) event_categories_list: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) enabled: std::option::Option<bool>,
        pub(crate) event_subscription_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Web Services customer account associated with the RDS event notification subscription.</p>
        pub fn customer_aws_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.customer_aws_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services customer account associated with the RDS event notification subscription.</p>
        pub fn set_customer_aws_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.customer_aws_id = input;
            self
        }
        /// <p>The RDS event notification subscription Id.</p>
        pub fn cust_subscription_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.cust_subscription_id = Some(input.into());
            self
        }
        /// <p>The RDS event notification subscription Id.</p>
        pub fn set_cust_subscription_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cust_subscription_id = input;
            self
        }
        /// <p>The topic ARN of the RDS event notification subscription.</p>
        pub fn sns_topic_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.sns_topic_arn = Some(input.into());
            self
        }
        /// <p>The topic ARN of the RDS event notification subscription.</p>
        pub fn set_sns_topic_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sns_topic_arn = input;
            self
        }
        /// <p>The status of the RDS event notification subscription.</p>
        /// <p>Constraints:</p>
        /// <p>Can be one of the following: creating | modifying | deleting | active | no-permission | topic-not-exist</p>
        /// <p>The status "no-permission" indicates that RDS no longer has permission to post to the SNS topic. The status "topic-not-exist" indicates that the topic was deleted after the subscription was created.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the RDS event notification subscription.</p>
        /// <p>Constraints:</p>
        /// <p>Can be one of the following: creating | modifying | deleting | active | no-permission | topic-not-exist</p>
        /// <p>The status "no-permission" indicates that RDS no longer has permission to post to the SNS topic. The status "topic-not-exist" indicates that the topic was deleted after the subscription was created.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>The time the RDS event notification subscription was created.</p>
        pub fn subscription_creation_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.subscription_creation_time = Some(input.into());
            self
        }
        /// <p>The time the RDS event notification subscription was created.</p>
        pub fn set_subscription_creation_time(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.subscription_creation_time = input;
            self
        }
        /// <p>The source type for the RDS event notification subscription.</p>
        pub fn source_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_type = Some(input.into());
            self
        }
        /// <p>The source type for the RDS event notification subscription.</p>
        pub fn set_source_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source_type = input;
            self
        }
        /// Appends an item to `source_ids_list`.
        ///
        /// To override the contents of this collection use [`set_source_ids_list`](Self::set_source_ids_list).
        ///
        /// <p>A list of source IDs for the RDS event notification subscription.</p>
        pub fn source_ids_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.source_ids_list.unwrap_or_default();
            v.push(input.into());
            self.source_ids_list = Some(v);
            self
        }
        /// <p>A list of source IDs for the RDS event notification subscription.</p>
        pub fn set_source_ids_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.source_ids_list = input;
            self
        }
        /// Appends an item to `event_categories_list`.
        ///
        /// To override the contents of this collection use [`set_event_categories_list`](Self::set_event_categories_list).
        ///
        /// <p>A list of event categories for the RDS event notification subscription.</p>
        pub fn event_categories_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.event_categories_list.unwrap_or_default();
            v.push(input.into());
            self.event_categories_list = Some(v);
            self
        }
        /// <p>A list of event categories for the RDS event notification subscription.</p>
        pub fn set_event_categories_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.event_categories_list = input;
            self
        }
        /// <p>A Boolean value indicating if the subscription is enabled. True indicates the subscription is enabled.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>A Boolean value indicating if the subscription is enabled. True indicates the subscription is enabled.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the event subscription.</p>
        pub fn event_subscription_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_subscription_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the event subscription.</p>
        pub fn set_event_subscription_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.event_subscription_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`EventSubscription`](crate::model::EventSubscription)
        pub fn build(self) -> crate::model::EventSubscription {
            crate::model::EventSubscription {
                customer_aws_id: self.customer_aws_id,
                cust_subscription_id: self.cust_subscription_id,
                sns_topic_arn: self.sns_topic_arn,
                status: self.status,
                subscription_creation_time: self.subscription_creation_time,
                source_type: self.source_type,
                source_ids_list: self.source_ids_list,
                event_categories_list: self.event_categories_list,
                enabled: self.enabled.unwrap_or_default(),
                event_subscription_arn: self.event_subscription_arn,
            }
        }
    }
}
impl EventSubscription {
    /// Creates a new builder-style object to manufacture [`EventSubscription`](crate::model::EventSubscription)
    pub fn builder() -> crate::model::event_subscription::Builder {
        crate::model::event_subscription::Builder::default()
    }
}

/// <p>A data type representing an Aurora global database.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GlobalCluster {
    /// <p> Contains a user-supplied global database cluster identifier. This identifier is the unique key that identifies a global database cluster. </p>
    pub global_cluster_identifier: std::option::Option<std::string::String>,
    /// <p> The Amazon Web Services Region-unique, immutable identifier for the global database cluster. This identifier is found in Amazon Web Services CloudTrail log entries whenever the Amazon Web Services KMS key for the DB cluster is accessed. </p>
    pub global_cluster_resource_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) for the global database cluster.</p>
    pub global_cluster_arn: std::option::Option<std::string::String>,
    /// <p>Specifies the current state of this global database cluster.</p>
    pub status: std::option::Option<std::string::String>,
    /// <p> The Aurora database engine used by the global database cluster. </p>
    pub engine: std::option::Option<std::string::String>,
    /// <p>Indicates the database engine version.</p>
    pub engine_version: std::option::Option<std::string::String>,
    /// <p> The default database name within the new global database cluster. </p>
    pub database_name: std::option::Option<std::string::String>,
    /// <p> The storage encryption setting for the global database cluster. </p>
    pub storage_encrypted: std::option::Option<bool>,
    /// <p> The deletion protection setting for the new global database cluster. </p>
    pub deletion_protection: std::option::Option<bool>,
    /// <p> The list of cluster IDs for secondary clusters within the global database cluster. Currently limited to 1 item. </p>
    pub global_cluster_members:
        std::option::Option<std::vec::Vec<crate::model::GlobalClusterMember>>,
    /// <p>A data object containing all properties for the current state of an in-process or pending failover process for this Aurora global database. This object is empty unless the <code>FailoverGlobalCluster</code> API operation has been called on this Aurora global database (<code>GlobalCluster</code>). </p>
    pub failover_state: std::option::Option<crate::model::FailoverState>,
}
impl GlobalCluster {
    /// <p> Contains a user-supplied global database cluster identifier. This identifier is the unique key that identifies a global database cluster. </p>
    pub fn global_cluster_identifier(&self) -> std::option::Option<&str> {
        self.global_cluster_identifier.as_deref()
    }
    /// <p> The Amazon Web Services Region-unique, immutable identifier for the global database cluster. This identifier is found in Amazon Web Services CloudTrail log entries whenever the Amazon Web Services KMS key for the DB cluster is accessed. </p>
    pub fn global_cluster_resource_id(&self) -> std::option::Option<&str> {
        self.global_cluster_resource_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) for the global database cluster.</p>
    pub fn global_cluster_arn(&self) -> std::option::Option<&str> {
        self.global_cluster_arn.as_deref()
    }
    /// <p>Specifies the current state of this global database cluster.</p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p> The Aurora database engine used by the global database cluster. </p>
    pub fn engine(&self) -> std::option::Option<&str> {
        self.engine.as_deref()
    }
    /// <p>Indicates the database engine version.</p>
    pub fn engine_version(&self) -> std::option::Option<&str> {
        self.engine_version.as_deref()
    }
    /// <p> The default database name within the new global database cluster. </p>
    pub fn database_name(&self) -> std::option::Option<&str> {
        self.database_name.as_deref()
    }
    /// <p> The storage encryption setting for the global database cluster. </p>
    pub fn storage_encrypted(&self) -> std::option::Option<bool> {
        self.storage_encrypted
    }
    /// <p> The deletion protection setting for the new global database cluster. </p>
    pub fn deletion_protection(&self) -> std::option::Option<bool> {
        self.deletion_protection
    }
    /// <p> The list of cluster IDs for secondary clusters within the global database cluster. Currently limited to 1 item. </p>
    pub fn global_cluster_members(
        &self,
    ) -> std::option::Option<&[crate::model::GlobalClusterMember]> {
        self.global_cluster_members.as_deref()
    }
    /// <p>A data object containing all properties for the current state of an in-process or pending failover process for this Aurora global database. This object is empty unless the <code>FailoverGlobalCluster</code> API operation has been called on this Aurora global database (<code>GlobalCluster</code>). </p>
    pub fn failover_state(&self) -> std::option::Option<&crate::model::FailoverState> {
        self.failover_state.as_ref()
    }
}
impl std::fmt::Debug for GlobalCluster {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GlobalCluster");
        formatter.field("global_cluster_identifier", &self.global_cluster_identifier);
        formatter.field(
            "global_cluster_resource_id",
            &self.global_cluster_resource_id,
        );
        formatter.field("global_cluster_arn", &self.global_cluster_arn);
        formatter.field("status", &self.status);
        formatter.field("engine", &self.engine);
        formatter.field("engine_version", &self.engine_version);
        formatter.field("database_name", &self.database_name);
        formatter.field("storage_encrypted", &self.storage_encrypted);
        formatter.field("deletion_protection", &self.deletion_protection);
        formatter.field("global_cluster_members", &self.global_cluster_members);
        formatter.field("failover_state", &self.failover_state);
        formatter.finish()
    }
}
/// See [`GlobalCluster`](crate::model::GlobalCluster)
pub mod global_cluster {
    /// A builder for [`GlobalCluster`](crate::model::GlobalCluster)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) global_cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) global_cluster_resource_id: std::option::Option<std::string::String>,
        pub(crate) global_cluster_arn: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) engine: std::option::Option<std::string::String>,
        pub(crate) engine_version: std::option::Option<std::string::String>,
        pub(crate) database_name: std::option::Option<std::string::String>,
        pub(crate) storage_encrypted: std::option::Option<bool>,
        pub(crate) deletion_protection: std::option::Option<bool>,
        pub(crate) global_cluster_members:
            std::option::Option<std::vec::Vec<crate::model::GlobalClusterMember>>,
        pub(crate) failover_state: std::option::Option<crate::model::FailoverState>,
    }
    impl Builder {
        /// <p> Contains a user-supplied global database cluster identifier. This identifier is the unique key that identifies a global database cluster. </p>
        pub fn global_cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.global_cluster_identifier = Some(input.into());
            self
        }
        /// <p> Contains a user-supplied global database cluster identifier. This identifier is the unique key that identifies a global database cluster. </p>
        pub fn set_global_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.global_cluster_identifier = input;
            self
        }
        /// <p> The Amazon Web Services Region-unique, immutable identifier for the global database cluster. This identifier is found in Amazon Web Services CloudTrail log entries whenever the Amazon Web Services KMS key for the DB cluster is accessed. </p>
        pub fn global_cluster_resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.global_cluster_resource_id = Some(input.into());
            self
        }
        /// <p> The Amazon Web Services Region-unique, immutable identifier for the global database cluster. This identifier is found in Amazon Web Services CloudTrail log entries whenever the Amazon Web Services KMS key for the DB cluster is accessed. </p>
        pub fn set_global_cluster_resource_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.global_cluster_resource_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the global database cluster.</p>
        pub fn global_cluster_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.global_cluster_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the global database cluster.</p>
        pub fn set_global_cluster_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.global_cluster_arn = input;
            self
        }
        /// <p>Specifies the current state of this global database cluster.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>Specifies the current state of this global database cluster.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p> The Aurora database engine used by the global database cluster. </p>
        pub fn engine(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine = Some(input.into());
            self
        }
        /// <p> The Aurora database engine used by the global database cluster. </p>
        pub fn set_engine(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.engine = input;
            self
        }
        /// <p>Indicates the database engine version.</p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_version = Some(input.into());
            self
        }
        /// <p>Indicates the database engine version.</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.engine_version = input;
            self
        }
        /// <p> The default database name within the new global database cluster. </p>
        pub fn database_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.database_name = Some(input.into());
            self
        }
        /// <p> The default database name within the new global database cluster. </p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.database_name = input;
            self
        }
        /// <p> The storage encryption setting for the global database cluster. </p>
        pub fn storage_encrypted(mut self, input: bool) -> Self {
            self.storage_encrypted = Some(input);
            self
        }
        /// <p> The storage encryption setting for the global database cluster. </p>
        pub fn set_storage_encrypted(mut self, input: std::option::Option<bool>) -> Self {
            self.storage_encrypted = input;
            self
        }
        /// <p> The deletion protection setting for the new global database cluster. </p>
        pub fn deletion_protection(mut self, input: bool) -> Self {
            self.deletion_protection = Some(input);
            self
        }
        /// <p> The deletion protection setting for the new global database cluster. </p>
        pub fn set_deletion_protection(mut self, input: std::option::Option<bool>) -> Self {
            self.deletion_protection = input;
            self
        }
        /// Appends an item to `global_cluster_members`.
        ///
        /// To override the contents of this collection use [`set_global_cluster_members`](Self::set_global_cluster_members).
        ///
        /// <p> The list of cluster IDs for secondary clusters within the global database cluster. Currently limited to 1 item. </p>
        pub fn global_cluster_members(mut self, input: crate::model::GlobalClusterMember) -> Self {
            let mut v = self.global_cluster_members.unwrap_or_default();
            v.push(input);
            self.global_cluster_members = Some(v);
            self
        }
        /// <p> The list of cluster IDs for secondary clusters within the global database cluster. Currently limited to 1 item. </p>
        pub fn set_global_cluster_members(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GlobalClusterMember>>,
        ) -> Self {
            self.global_cluster_members = input;
            self
        }
        /// <p>A data object containing all properties for the current state of an in-process or pending failover process for this Aurora global database. This object is empty unless the <code>FailoverGlobalCluster</code> API operation has been called on this Aurora global database (<code>GlobalCluster</code>). </p>
        pub fn failover_state(mut self, input: crate::model::FailoverState) -> Self {
            self.failover_state = Some(input);
            self
        }
        /// <p>A data object containing all properties for the current state of an in-process or pending failover process for this Aurora global database. This object is empty unless the <code>FailoverGlobalCluster</code> API operation has been called on this Aurora global database (<code>GlobalCluster</code>). </p>
        pub fn set_failover_state(
            mut self,
            input: std::option::Option<crate::model::FailoverState>,
        ) -> Self {
            self.failover_state = input;
            self
        }
        /// Consumes the builder and constructs a [`GlobalCluster`](crate::model::GlobalCluster)
        pub fn build(self) -> crate::model::GlobalCluster {
            crate::model::GlobalCluster {
                global_cluster_identifier: self.global_cluster_identifier,
                global_cluster_resource_id: self.global_cluster_resource_id,
                global_cluster_arn: self.global_cluster_arn,
                status: self.status,
                engine: self.engine,
                engine_version: self.engine_version,
                database_name: self.database_name,
                storage_encrypted: self.storage_encrypted,
                deletion_protection: self.deletion_protection,
                global_cluster_members: self.global_cluster_members,
                failover_state: self.failover_state,
            }
        }
    }
}
impl GlobalCluster {
    /// Creates a new builder-style object to manufacture [`GlobalCluster`](crate::model::GlobalCluster)
    pub fn builder() -> crate::model::global_cluster::Builder {
        crate::model::global_cluster::Builder::default()
    }
}

/// <p>Contains the state of scheduled or in-process failover operations on an Aurora global database (<code>GlobalCluster</code>). This Data type is empty unless a failover operation is scheduled or is currently underway on the Aurora global database. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FailoverState {
    /// <p>The current status of the Aurora global database (<code>GlobalCluster</code>). Possible values are as follows: </p>
    /// <ul>
    /// <li> <p>pending  A request to fail over the Aurora global database (<code>GlobalCluster</code>) has been received by the service. The <code>GlobalCluster</code>'s primary DB cluster and the specified secondary DB cluster are being verified before the failover process can start.</p> </li>
    /// <li> <p>failing-over  This status covers the range of Aurora internal operations that take place during the failover process, such as demoting the primary Aurora DB cluster, promoting the secondary Aurora DB, and synchronizing replicas. </p> </li>
    /// <li> <p>cancelling  The request to fail over the Aurora global database (<code>GlobalCluster</code>) was cancelled and the primary Aurora DB cluster and the selected secondary Aurora DB cluster are returning to their previous states. </p> </li>
    /// </ul>
    pub status: std::option::Option<crate::model::FailoverStatus>,
    /// <p>The Amazon Resource Name (ARN) of the Aurora DB cluster that is currently being demoted, and which is associated with this state. </p>
    pub from_db_cluster_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the Aurora DB cluster that is currently being promoted, and which is associated with this state.</p>
    pub to_db_cluster_arn: std::option::Option<std::string::String>,
}
impl FailoverState {
    /// <p>The current status of the Aurora global database (<code>GlobalCluster</code>). Possible values are as follows: </p>
    /// <ul>
    /// <li> <p>pending  A request to fail over the Aurora global database (<code>GlobalCluster</code>) has been received by the service. The <code>GlobalCluster</code>'s primary DB cluster and the specified secondary DB cluster are being verified before the failover process can start.</p> </li>
    /// <li> <p>failing-over  This status covers the range of Aurora internal operations that take place during the failover process, such as demoting the primary Aurora DB cluster, promoting the secondary Aurora DB, and synchronizing replicas. </p> </li>
    /// <li> <p>cancelling  The request to fail over the Aurora global database (<code>GlobalCluster</code>) was cancelled and the primary Aurora DB cluster and the selected secondary Aurora DB cluster are returning to their previous states. </p> </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&crate::model::FailoverStatus> {
        self.status.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) of the Aurora DB cluster that is currently being demoted, and which is associated with this state. </p>
    pub fn from_db_cluster_arn(&self) -> std::option::Option<&str> {
        self.from_db_cluster_arn.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the Aurora DB cluster that is currently being promoted, and which is associated with this state.</p>
    pub fn to_db_cluster_arn(&self) -> std::option::Option<&str> {
        self.to_db_cluster_arn.as_deref()
    }
}
impl std::fmt::Debug for FailoverState {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FailoverState");
        formatter.field("status", &self.status);
        formatter.field("from_db_cluster_arn", &self.from_db_cluster_arn);
        formatter.field("to_db_cluster_arn", &self.to_db_cluster_arn);
        formatter.finish()
    }
}
/// See [`FailoverState`](crate::model::FailoverState)
pub mod failover_state {
    /// A builder for [`FailoverState`](crate::model::FailoverState)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<crate::model::FailoverStatus>,
        pub(crate) from_db_cluster_arn: std::option::Option<std::string::String>,
        pub(crate) to_db_cluster_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The current status of the Aurora global database (<code>GlobalCluster</code>). Possible values are as follows: </p>
        /// <ul>
        /// <li> <p>pending  A request to fail over the Aurora global database (<code>GlobalCluster</code>) has been received by the service. The <code>GlobalCluster</code>'s primary DB cluster and the specified secondary DB cluster are being verified before the failover process can start.</p> </li>
        /// <li> <p>failing-over  This status covers the range of Aurora internal operations that take place during the failover process, such as demoting the primary Aurora DB cluster, promoting the secondary Aurora DB, and synchronizing replicas. </p> </li>
        /// <li> <p>cancelling  The request to fail over the Aurora global database (<code>GlobalCluster</code>) was cancelled and the primary Aurora DB cluster and the selected secondary Aurora DB cluster are returning to their previous states. </p> </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::FailoverStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current status of the Aurora global database (<code>GlobalCluster</code>). Possible values are as follows: </p>
        /// <ul>
        /// <li> <p>pending  A request to fail over the Aurora global database (<code>GlobalCluster</code>) has been received by the service. The <code>GlobalCluster</code>'s primary DB cluster and the specified secondary DB cluster are being verified before the failover process can start.</p> </li>
        /// <li> <p>failing-over  This status covers the range of Aurora internal operations that take place during the failover process, such as demoting the primary Aurora DB cluster, promoting the secondary Aurora DB, and synchronizing replicas. </p> </li>
        /// <li> <p>cancelling  The request to fail over the Aurora global database (<code>GlobalCluster</code>) was cancelled and the primary Aurora DB cluster and the selected secondary Aurora DB cluster are returning to their previous states. </p> </li>
        /// </ul>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::FailoverStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Aurora DB cluster that is currently being demoted, and which is associated with this state. </p>
        pub fn from_db_cluster_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.from_db_cluster_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Aurora DB cluster that is currently being demoted, and which is associated with this state. </p>
        pub fn set_from_db_cluster_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.from_db_cluster_arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Aurora DB cluster that is currently being promoted, and which is associated with this state.</p>
        pub fn to_db_cluster_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.to_db_cluster_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Aurora DB cluster that is currently being promoted, and which is associated with this state.</p>
        pub fn set_to_db_cluster_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.to_db_cluster_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`FailoverState`](crate::model::FailoverState)
        pub fn build(self) -> crate::model::FailoverState {
            crate::model::FailoverState {
                status: self.status,
                from_db_cluster_arn: self.from_db_cluster_arn,
                to_db_cluster_arn: self.to_db_cluster_arn,
            }
        }
    }
}
impl FailoverState {
    /// Creates a new builder-style object to manufacture [`FailoverState`](crate::model::FailoverState)
    pub fn builder() -> crate::model::failover_state::Builder {
        crate::model::failover_state::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FailoverStatus {
    #[allow(missing_docs)] // documentation missing in model
    Cancelling,
    #[allow(missing_docs)] // documentation missing in model
    FailingOver,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FailoverStatus {
    fn from(s: &str) -> Self {
        match s {
            "cancelling" => FailoverStatus::Cancelling,
            "failing-over" => FailoverStatus::FailingOver,
            "pending" => FailoverStatus::Pending,
            other => FailoverStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FailoverStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FailoverStatus::from(s))
    }
}
impl FailoverStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FailoverStatus::Cancelling => "cancelling",
            FailoverStatus::FailingOver => "failing-over",
            FailoverStatus::Pending => "pending",
            FailoverStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["cancelling", "failing-over", "pending"]
    }
}
impl AsRef<str> for FailoverStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> A data structure with information about any primary and secondary clusters associated with an Aurora global database. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GlobalClusterMember {
    /// <p> The Amazon Resource Name (ARN) for each Aurora cluster. </p>
    pub db_cluster_arn: std::option::Option<std::string::String>,
    /// <p> The Amazon Resource Name (ARN) for each read-only secondary cluster associated with the Aurora global database. </p>
    pub readers: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p> Specifies whether the Aurora cluster is the primary cluster (that is, has read-write capability) for the Aurora global database with which it is associated. </p>
    pub is_writer: bool,
    /// <p>Specifies whether a secondary cluster in an Aurora global database has write forwarding enabled, not enabled, or is in the process of enabling it.</p>
    pub global_write_forwarding_status: std::option::Option<crate::model::WriteForwardingStatus>,
}
impl GlobalClusterMember {
    /// <p> The Amazon Resource Name (ARN) for each Aurora cluster. </p>
    pub fn db_cluster_arn(&self) -> std::option::Option<&str> {
        self.db_cluster_arn.as_deref()
    }
    /// <p> The Amazon Resource Name (ARN) for each read-only secondary cluster associated with the Aurora global database. </p>
    pub fn readers(&self) -> std::option::Option<&[std::string::String]> {
        self.readers.as_deref()
    }
    /// <p> Specifies whether the Aurora cluster is the primary cluster (that is, has read-write capability) for the Aurora global database with which it is associated. </p>
    pub fn is_writer(&self) -> bool {
        self.is_writer
    }
    /// <p>Specifies whether a secondary cluster in an Aurora global database has write forwarding enabled, not enabled, or is in the process of enabling it.</p>
    pub fn global_write_forwarding_status(
        &self,
    ) -> std::option::Option<&crate::model::WriteForwardingStatus> {
        self.global_write_forwarding_status.as_ref()
    }
}
impl std::fmt::Debug for GlobalClusterMember {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GlobalClusterMember");
        formatter.field("db_cluster_arn", &self.db_cluster_arn);
        formatter.field("readers", &self.readers);
        formatter.field("is_writer", &self.is_writer);
        formatter.field(
            "global_write_forwarding_status",
            &self.global_write_forwarding_status,
        );
        formatter.finish()
    }
}
/// See [`GlobalClusterMember`](crate::model::GlobalClusterMember)
pub mod global_cluster_member {
    /// A builder for [`GlobalClusterMember`](crate::model::GlobalClusterMember)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster_arn: std::option::Option<std::string::String>,
        pub(crate) readers: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) is_writer: std::option::Option<bool>,
        pub(crate) global_write_forwarding_status:
            std::option::Option<crate::model::WriteForwardingStatus>,
    }
    impl Builder {
        /// <p> The Amazon Resource Name (ARN) for each Aurora cluster. </p>
        pub fn db_cluster_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_cluster_arn = Some(input.into());
            self
        }
        /// <p> The Amazon Resource Name (ARN) for each Aurora cluster. </p>
        pub fn set_db_cluster_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_arn = input;
            self
        }
        /// Appends an item to `readers`.
        ///
        /// To override the contents of this collection use [`set_readers`](Self::set_readers).
        ///
        /// <p> The Amazon Resource Name (ARN) for each read-only secondary cluster associated with the Aurora global database. </p>
        pub fn readers(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.readers.unwrap_or_default();
            v.push(input.into());
            self.readers = Some(v);
            self
        }
        /// <p> The Amazon Resource Name (ARN) for each read-only secondary cluster associated with the Aurora global database. </p>
        pub fn set_readers(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.readers = input;
            self
        }
        /// <p> Specifies whether the Aurora cluster is the primary cluster (that is, has read-write capability) for the Aurora global database with which it is associated. </p>
        pub fn is_writer(mut self, input: bool) -> Self {
            self.is_writer = Some(input);
            self
        }
        /// <p> Specifies whether the Aurora cluster is the primary cluster (that is, has read-write capability) for the Aurora global database with which it is associated. </p>
        pub fn set_is_writer(mut self, input: std::option::Option<bool>) -> Self {
            self.is_writer = input;
            self
        }
        /// <p>Specifies whether a secondary cluster in an Aurora global database has write forwarding enabled, not enabled, or is in the process of enabling it.</p>
        pub fn global_write_forwarding_status(
            mut self,
            input: crate::model::WriteForwardingStatus,
        ) -> Self {
            self.global_write_forwarding_status = Some(input);
            self
        }
        /// <p>Specifies whether a secondary cluster in an Aurora global database has write forwarding enabled, not enabled, or is in the process of enabling it.</p>
        pub fn set_global_write_forwarding_status(
            mut self,
            input: std::option::Option<crate::model::WriteForwardingStatus>,
        ) -> Self {
            self.global_write_forwarding_status = input;
            self
        }
        /// Consumes the builder and constructs a [`GlobalClusterMember`](crate::model::GlobalClusterMember)
        pub fn build(self) -> crate::model::GlobalClusterMember {
            crate::model::GlobalClusterMember {
                db_cluster_arn: self.db_cluster_arn,
                readers: self.readers,
                is_writer: self.is_writer.unwrap_or_default(),
                global_write_forwarding_status: self.global_write_forwarding_status,
            }
        }
    }
}
impl GlobalClusterMember {
    /// Creates a new builder-style object to manufacture [`GlobalClusterMember`](crate::model::GlobalClusterMember)
    pub fn builder() -> crate::model::global_cluster_member::Builder {
        crate::model::global_cluster_member::Builder::default()
    }
}

/// <p>Contains the details for an RDS Proxy target. It represents an RDS DB instance or Aurora DB cluster that the proxy can connect to. One or more targets are associated with an RDS Proxy target group.</p>
/// <p>This data type is used as a response element in the <code>DescribeDBProxyTargets</code> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DbProxyTarget {
    /// <p>The Amazon Resource Name (ARN) for the RDS DB instance or Aurora DB cluster.</p>
    pub target_arn: std::option::Option<std::string::String>,
    /// <p>The writer endpoint for the RDS DB instance or Aurora DB cluster.</p>
    pub endpoint: std::option::Option<std::string::String>,
    /// <p>The DB cluster identifier when the target represents an Aurora DB cluster. This field is blank when the target represents an RDS DB instance.</p>
    pub tracked_cluster_id: std::option::Option<std::string::String>,
    /// <p>The identifier representing the target. It can be the instance identifier for an RDS DB instance, or the cluster identifier for an Aurora DB cluster.</p>
    pub rds_resource_id: std::option::Option<std::string::String>,
    /// <p>The port that the RDS Proxy uses to connect to the target RDS DB instance or Aurora DB cluster.</p>
    pub port: i32,
    /// <p>Specifies the kind of database, such as an RDS DB instance or an Aurora DB cluster, that the target represents.</p>
    pub r#type: std::option::Option<crate::model::TargetType>,
    /// <p>A value that indicates whether the target of the proxy can be used for read/write or read-only operations.</p>
    pub role: std::option::Option<crate::model::TargetRole>,
    /// <p>Information about the connection health of the RDS Proxy target.</p>
    pub target_health: std::option::Option<crate::model::TargetHealth>,
}
impl DbProxyTarget {
    /// <p>The Amazon Resource Name (ARN) for the RDS DB instance or Aurora DB cluster.</p>
    pub fn target_arn(&self) -> std::option::Option<&str> {
        self.target_arn.as_deref()
    }
    /// <p>The writer endpoint for the RDS DB instance or Aurora DB cluster.</p>
    pub fn endpoint(&self) -> std::option::Option<&str> {
        self.endpoint.as_deref()
    }
    /// <p>The DB cluster identifier when the target represents an Aurora DB cluster. This field is blank when the target represents an RDS DB instance.</p>
    pub fn tracked_cluster_id(&self) -> std::option::Option<&str> {
        self.tracked_cluster_id.as_deref()
    }
    /// <p>The identifier representing the target. It can be the instance identifier for an RDS DB instance, or the cluster identifier for an Aurora DB cluster.</p>
    pub fn rds_resource_id(&self) -> std::option::Option<&str> {
        self.rds_resource_id.as_deref()
    }
    /// <p>The port that the RDS Proxy uses to connect to the target RDS DB instance or Aurora DB cluster.</p>
    pub fn port(&self) -> i32 {
        self.port
    }
    /// <p>Specifies the kind of database, such as an RDS DB instance or an Aurora DB cluster, that the target represents.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::TargetType> {
        self.r#type.as_ref()
    }
    /// <p>A value that indicates whether the target of the proxy can be used for read/write or read-only operations.</p>
    pub fn role(&self) -> std::option::Option<&crate::model::TargetRole> {
        self.role.as_ref()
    }
    /// <p>Information about the connection health of the RDS Proxy target.</p>
    pub fn target_health(&self) -> std::option::Option<&crate::model::TargetHealth> {
        self.target_health.as_ref()
    }
}
impl std::fmt::Debug for DbProxyTarget {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DbProxyTarget");
        formatter.field("target_arn", &self.target_arn);
        formatter.field("endpoint", &self.endpoint);
        formatter.field("tracked_cluster_id", &self.tracked_cluster_id);
        formatter.field("rds_resource_id", &self.rds_resource_id);
        formatter.field("port", &self.port);
        formatter.field("r#type", &self.r#type);
        formatter.field("role", &self.role);
        formatter.field("target_health", &self.target_health);
        formatter.finish()
    }
}
/// See [`DbProxyTarget`](crate::model::DbProxyTarget)
pub mod db_proxy_target {
    /// A builder for [`DbProxyTarget`](crate::model::DbProxyTarget)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) target_arn: std::option::Option<std::string::String>,
        pub(crate) endpoint: std::option::Option<std::string::String>,
        pub(crate) tracked_cluster_id: std::option::Option<std::string::String>,
        pub(crate) rds_resource_id: std::option::Option<std::string::String>,
        pub(crate) port: std::option::Option<i32>,
        pub(crate) r#type: std::option::Option<crate::model::TargetType>,
        pub(crate) role: std::option::Option<crate::model::TargetRole>,
        pub(crate) target_health: std::option::Option<crate::model::TargetHealth>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) for the RDS DB instance or Aurora DB cluster.</p>
        pub fn target_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the RDS DB instance or Aurora DB cluster.</p>
        pub fn set_target_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.target_arn = input;
            self
        }
        /// <p>The writer endpoint for the RDS DB instance or Aurora DB cluster.</p>
        pub fn endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint = Some(input.into());
            self
        }
        /// <p>The writer endpoint for the RDS DB instance or Aurora DB cluster.</p>
        pub fn set_endpoint(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.endpoint = input;
            self
        }
        /// <p>The DB cluster identifier when the target represents an Aurora DB cluster. This field is blank when the target represents an RDS DB instance.</p>
        pub fn tracked_cluster_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.tracked_cluster_id = Some(input.into());
            self
        }
        /// <p>The DB cluster identifier when the target represents an Aurora DB cluster. This field is blank when the target represents an RDS DB instance.</p>
        pub fn set_tracked_cluster_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.tracked_cluster_id = input;
            self
        }
        /// <p>The identifier representing the target. It can be the instance identifier for an RDS DB instance, or the cluster identifier for an Aurora DB cluster.</p>
        pub fn rds_resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.rds_resource_id = Some(input.into());
            self
        }
        /// <p>The identifier representing the target. It can be the instance identifier for an RDS DB instance, or the cluster identifier for an Aurora DB cluster.</p>
        pub fn set_rds_resource_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.rds_resource_id = input;
            self
        }
        /// <p>The port that the RDS Proxy uses to connect to the target RDS DB instance or Aurora DB cluster.</p>
        pub fn port(mut self, input: i32) -> Self {
            self.port = Some(input);
            self
        }
        /// <p>The port that the RDS Proxy uses to connect to the target RDS DB instance or Aurora DB cluster.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.port = input;
            self
        }
        /// <p>Specifies the kind of database, such as an RDS DB instance or an Aurora DB cluster, that the target represents.</p>
        pub fn r#type(mut self, input: crate::model::TargetType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>Specifies the kind of database, such as an RDS DB instance or an Aurora DB cluster, that the target represents.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::TargetType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>A value that indicates whether the target of the proxy can be used for read/write or read-only operations.</p>
        pub fn role(mut self, input: crate::model::TargetRole) -> Self {
            self.role = Some(input);
            self
        }
        /// <p>A value that indicates whether the target of the proxy can be used for read/write or read-only operations.</p>
        pub fn set_role(mut self, input: std::option::Option<crate::model::TargetRole>) -> Self {
            self.role = input;
            self
        }
        /// <p>Information about the connection health of the RDS Proxy target.</p>
        pub fn target_health(mut self, input: crate::model::TargetHealth) -> Self {
            self.target_health = Some(input);
            self
        }
        /// <p>Information about the connection health of the RDS Proxy target.</p>
        pub fn set_target_health(
            mut self,
            input: std::option::Option<crate::model::TargetHealth>,
        ) -> Self {
            self.target_health = input;
            self
        }
        /// Consumes the builder and constructs a [`DbProxyTarget`](crate::model::DbProxyTarget)
        pub fn build(self) -> crate::model::DbProxyTarget {
            crate::model::DbProxyTarget {
                target_arn: self.target_arn,
                endpoint: self.endpoint,
                tracked_cluster_id: self.tracked_cluster_id,
                rds_resource_id: self.rds_resource_id,
                port: self.port.unwrap_or_default(),
                r#type: self.r#type,
                role: self.role,
                target_health: self.target_health,
            }
        }
    }
}
impl DbProxyTarget {
    /// Creates a new builder-style object to manufacture [`DbProxyTarget`](crate::model::DbProxyTarget)
    pub fn builder() -> crate::model::db_proxy_target::Builder {
        crate::model::db_proxy_target::Builder::default()
    }
}

/// <p>Information about the connection health of an RDS Proxy target.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TargetHealth {
    /// <p>The current state of the connection health lifecycle for the RDS Proxy target. The following is a typical lifecycle example for the states of an RDS Proxy target: </p>
    /// <p> <code>registering</code> &gt; <code>unavailable</code> &gt; <code>available</code> &gt; <code>unavailable</code> &gt; <code>available</code> </p>
    pub state: std::option::Option<crate::model::TargetState>,
    /// <p>The reason for the current health <code>State</code> of the RDS Proxy target.</p>
    pub reason: std::option::Option<crate::model::TargetHealthReason>,
    /// <p>A description of the health of the RDS Proxy target. If the <code>State</code> is <code>AVAILABLE</code>, a description is not included.</p>
    pub description: std::option::Option<std::string::String>,
}
impl TargetHealth {
    /// <p>The current state of the connection health lifecycle for the RDS Proxy target. The following is a typical lifecycle example for the states of an RDS Proxy target: </p>
    /// <p> <code>registering</code> &gt; <code>unavailable</code> &gt; <code>available</code> &gt; <code>unavailable</code> &gt; <code>available</code> </p>
    pub fn state(&self) -> std::option::Option<&crate::model::TargetState> {
        self.state.as_ref()
    }
    /// <p>The reason for the current health <code>State</code> of the RDS Proxy target.</p>
    pub fn reason(&self) -> std::option::Option<&crate::model::TargetHealthReason> {
        self.reason.as_ref()
    }
    /// <p>A description of the health of the RDS Proxy target. If the <code>State</code> is <code>AVAILABLE</code>, a description is not included.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
}
impl std::fmt::Debug for TargetHealth {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TargetHealth");
        formatter.field("state", &self.state);
        formatter.field("reason", &self.reason);
        formatter.field("description", &self.description);
        formatter.finish()
    }
}
/// See [`TargetHealth`](crate::model::TargetHealth)
pub mod target_health {
    /// A builder for [`TargetHealth`](crate::model::TargetHealth)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) state: std::option::Option<crate::model::TargetState>,
        pub(crate) reason: std::option::Option<crate::model::TargetHealthReason>,
        pub(crate) description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The current state of the connection health lifecycle for the RDS Proxy target. The following is a typical lifecycle example for the states of an RDS Proxy target: </p>
        /// <p> <code>registering</code> &gt; <code>unavailable</code> &gt; <code>available</code> &gt; <code>unavailable</code> &gt; <code>available</code> </p>
        pub fn state(mut self, input: crate::model::TargetState) -> Self {
            self.state = Some(input);
            self
        }
        /// <p>The current state of the connection health lifecycle for the RDS Proxy target. The following is a typical lifecycle example for the states of an RDS Proxy target: </p>
        /// <p> <code>registering</code> &gt; <code>unavailable</code> &gt; <code>available</code> &gt; <code>unavailable</code> &gt; <code>available</code> </p>
        pub fn set_state(mut self, input: std::option::Option<crate::model::TargetState>) -> Self {
            self.state = input;
            self
        }
        /// <p>The reason for the current health <code>State</code> of the RDS Proxy target.</p>
        pub fn reason(mut self, input: crate::model::TargetHealthReason) -> Self {
            self.reason = Some(input);
            self
        }
        /// <p>The reason for the current health <code>State</code> of the RDS Proxy target.</p>
        pub fn set_reason(
            mut self,
            input: std::option::Option<crate::model::TargetHealthReason>,
        ) -> Self {
            self.reason = input;
            self
        }
        /// <p>A description of the health of the RDS Proxy target. If the <code>State</code> is <code>AVAILABLE</code>, a description is not included.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description of the health of the RDS Proxy target. If the <code>State</code> is <code>AVAILABLE</code>, a description is not included.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`TargetHealth`](crate::model::TargetHealth)
        pub fn build(self) -> crate::model::TargetHealth {
            crate::model::TargetHealth {
                state: self.state,
                reason: self.reason,
                description: self.description,
            }
        }
    }
}
impl TargetHealth {
    /// Creates a new builder-style object to manufacture [`TargetHealth`](crate::model::TargetHealth)
    pub fn builder() -> crate::model::target_health::Builder {
        crate::model::target_health::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TargetHealthReason {
    #[allow(missing_docs)] // documentation missing in model
    AuthFailure,
    #[allow(missing_docs)] // documentation missing in model
    ConnectionFailed,
    #[allow(missing_docs)] // documentation missing in model
    InvalidReplicationState,
    #[allow(missing_docs)] // documentation missing in model
    PendingProxyCapacity,
    #[allow(missing_docs)] // documentation missing in model
    Unreachable,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TargetHealthReason {
    fn from(s: &str) -> Self {
        match s {
            "AUTH_FAILURE" => TargetHealthReason::AuthFailure,
            "CONNECTION_FAILED" => TargetHealthReason::ConnectionFailed,
            "INVALID_REPLICATION_STATE" => TargetHealthReason::InvalidReplicationState,
            "PENDING_PROXY_CAPACITY" => TargetHealthReason::PendingProxyCapacity,
            "UNREACHABLE" => TargetHealthReason::Unreachable,
            other => TargetHealthReason::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TargetHealthReason {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TargetHealthReason::from(s))
    }
}
impl TargetHealthReason {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TargetHealthReason::AuthFailure => "AUTH_FAILURE",
            TargetHealthReason::ConnectionFailed => "CONNECTION_FAILED",
            TargetHealthReason::InvalidReplicationState => "INVALID_REPLICATION_STATE",
            TargetHealthReason::PendingProxyCapacity => "PENDING_PROXY_CAPACITY",
            TargetHealthReason::Unreachable => "UNREACHABLE",
            TargetHealthReason::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AUTH_FAILURE",
            "CONNECTION_FAILED",
            "INVALID_REPLICATION_STATE",
            "PENDING_PROXY_CAPACITY",
            "UNREACHABLE",
        ]
    }
}
impl AsRef<str> for TargetHealthReason {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TargetState {
    #[allow(missing_docs)] // documentation missing in model
    Available,
    #[allow(missing_docs)] // documentation missing in model
    Registering,
    #[allow(missing_docs)] // documentation missing in model
    Unavailable,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TargetState {
    fn from(s: &str) -> Self {
        match s {
            "AVAILABLE" => TargetState::Available,
            "REGISTERING" => TargetState::Registering,
            "UNAVAILABLE" => TargetState::Unavailable,
            other => TargetState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TargetState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TargetState::from(s))
    }
}
impl TargetState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TargetState::Available => "AVAILABLE",
            TargetState::Registering => "REGISTERING",
            TargetState::Unavailable => "UNAVAILABLE",
            TargetState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AVAILABLE", "REGISTERING", "UNAVAILABLE"]
    }
}
impl AsRef<str> for TargetState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// _Note: `TargetRole::Unknown` has been renamed to `::UnknownValue`._
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TargetRole {
    #[allow(missing_docs)] // documentation missing in model
    ReadOnly,
    #[allow(missing_docs)] // documentation missing in model
    ReadWrite,
    /// _Note: `::Unknown` has been renamed to `::UnknownValue`._
    UnknownValue,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TargetRole {
    fn from(s: &str) -> Self {
        match s {
            "READ_ONLY" => TargetRole::ReadOnly,
            "READ_WRITE" => TargetRole::ReadWrite,
            "UNKNOWN" => TargetRole::UnknownValue,
            other => TargetRole::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TargetRole {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TargetRole::from(s))
    }
}
impl TargetRole {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TargetRole::ReadOnly => "READ_ONLY",
            TargetRole::ReadWrite => "READ_WRITE",
            TargetRole::UnknownValue => "UNKNOWN",
            TargetRole::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["READ_ONLY", "READ_WRITE", "UNKNOWN"]
    }
}
impl AsRef<str> for TargetRole {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TargetType {
    #[allow(missing_docs)] // documentation missing in model
    RdsInstance,
    #[allow(missing_docs)] // documentation missing in model
    RdsServerlessEndpoint,
    #[allow(missing_docs)] // documentation missing in model
    TrackedCluster,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TargetType {
    fn from(s: &str) -> Self {
        match s {
            "RDS_INSTANCE" => TargetType::RdsInstance,
            "RDS_SERVERLESS_ENDPOINT" => TargetType::RdsServerlessEndpoint,
            "TRACKED_CLUSTER" => TargetType::TrackedCluster,
            other => TargetType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TargetType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TargetType::from(s))
    }
}
impl TargetType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TargetType::RdsInstance => "RDS_INSTANCE",
            TargetType::RdsServerlessEndpoint => "RDS_SERVERLESS_ENDPOINT",
            TargetType::TrackedCluster => "TRACKED_CLUSTER",
            TargetType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["RDS_INSTANCE", "RDS_SERVERLESS_ENDPOINT", "TRACKED_CLUSTER"]
    }
}
impl AsRef<str> for TargetType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p> This data type is used as a response element in the <code>DescribeReservedDBInstances</code> and <code>PurchaseReservedDBInstancesOffering</code> actions. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReservedDbInstance {
    /// <p>The unique identifier for the reservation.</p>
    pub reserved_db_instance_id: std::option::Option<std::string::String>,
    /// <p>The offering identifier.</p>
    pub reserved_db_instances_offering_id: std::option::Option<std::string::String>,
    /// <p>The DB instance class for the reserved DB instance.</p>
    pub db_instance_class: std::option::Option<std::string::String>,
    /// <p>The time the reservation started.</p>
    pub start_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The duration of the reservation in seconds.</p>
    pub duration: i32,
    /// <p>The fixed price charged for this reserved DB instance.</p>
    pub fixed_price: f64,
    /// <p>The hourly price charged for this reserved DB instance.</p>
    pub usage_price: f64,
    /// <p>The currency code for the reserved DB instance.</p>
    pub currency_code: std::option::Option<std::string::String>,
    /// <p>The number of reserved DB instances.</p>
    pub db_instance_count: i32,
    /// <p>The description of the reserved DB instance.</p>
    pub product_description: std::option::Option<std::string::String>,
    /// <p>The offering type of this reserved DB instance.</p>
    pub offering_type: std::option::Option<std::string::String>,
    /// <p>Indicates if the reservation applies to Multi-AZ deployments.</p>
    pub multi_az: bool,
    /// <p>The state of the reserved DB instance.</p>
    pub state: std::option::Option<std::string::String>,
    /// <p>The recurring price charged to run this reserved DB instance.</p>
    pub recurring_charges: std::option::Option<std::vec::Vec<crate::model::RecurringCharge>>,
    /// <p>The Amazon Resource Name (ARN) for the reserved DB instance.</p>
    pub reserved_db_instance_arn: std::option::Option<std::string::String>,
    /// <p>The unique identifier for the lease associated with the reserved DB instance.</p> <note>
    /// <p>Amazon Web Services Support might request the lease ID for an issue related to a reserved DB instance.</p>
    /// </note>
    pub lease_id: std::option::Option<std::string::String>,
}
impl ReservedDbInstance {
    /// <p>The unique identifier for the reservation.</p>
    pub fn reserved_db_instance_id(&self) -> std::option::Option<&str> {
        self.reserved_db_instance_id.as_deref()
    }
    /// <p>The offering identifier.</p>
    pub fn reserved_db_instances_offering_id(&self) -> std::option::Option<&str> {
        self.reserved_db_instances_offering_id.as_deref()
    }
    /// <p>The DB instance class for the reserved DB instance.</p>
    pub fn db_instance_class(&self) -> std::option::Option<&str> {
        self.db_instance_class.as_deref()
    }
    /// <p>The time the reservation started.</p>
    pub fn start_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.start_time.as_ref()
    }
    /// <p>The duration of the reservation in seconds.</p>
    pub fn duration(&self) -> i32 {
        self.duration
    }
    /// <p>The fixed price charged for this reserved DB instance.</p>
    pub fn fixed_price(&self) -> f64 {
        self.fixed_price
    }
    /// <p>The hourly price charged for this reserved DB instance.</p>
    pub fn usage_price(&self) -> f64 {
        self.usage_price
    }
    /// <p>The currency code for the reserved DB instance.</p>
    pub fn currency_code(&self) -> std::option::Option<&str> {
        self.currency_code.as_deref()
    }
    /// <p>The number of reserved DB instances.</p>
    pub fn db_instance_count(&self) -> i32 {
        self.db_instance_count
    }
    /// <p>The description of the reserved DB instance.</p>
    pub fn product_description(&self) -> std::option::Option<&str> {
        self.product_description.as_deref()
    }
    /// <p>The offering type of this reserved DB instance.</p>
    pub fn offering_type(&self) -> std::option::Option<&str> {
        self.offering_type.as_deref()
    }
    /// <p>Indicates if the reservation applies to Multi-AZ deployments.</p>
    pub fn multi_az(&self) -> bool {
        self.multi_az
    }
    /// <p>The state of the reserved DB instance.</p>
    pub fn state(&self) -> std::option::Option<&str> {
        self.state.as_deref()
    }
    /// <p>The recurring price charged to run this reserved DB instance.</p>
    pub fn recurring_charges(&self) -> std::option::Option<&[crate::model::RecurringCharge]> {
        self.recurring_charges.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) for the reserved DB instance.</p>
    pub fn reserved_db_instance_arn(&self) -> std::option::Option<&str> {
        self.reserved_db_instance_arn.as_deref()
    }
    /// <p>The unique identifier for the lease associated with the reserved DB instance.</p> <note>
    /// <p>Amazon Web Services Support might request the lease ID for an issue related to a reserved DB instance.</p>
    /// </note>
    pub fn lease_id(&self) -> std::option::Option<&str> {
        self.lease_id.as_deref()
    }
}
impl std::fmt::Debug for ReservedDbInstance {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReservedDbInstance");
        formatter.field("reserved_db_instance_id", &self.reserved_db_instance_id);
        formatter.field(
            "reserved_db_instances_offering_id",
            &self.reserved_db_instances_offering_id,
        );
        formatter.field("db_instance_class", &self.db_instance_class);
        formatter.field("start_time", &self.start_time);
        formatter.field("duration", &self.duration);
        formatter.field("fixed_price", &self.fixed_price);
        formatter.field("usage_price", &self.usage_price);
        formatter.field("currency_code", &self.currency_code);
        formatter.field("db_instance_count", &self.db_instance_count);
        formatter.field("product_description", &self.product_description);
        formatter.field("offering_type", &self.offering_type);
        formatter.field("multi_az", &self.multi_az);
        formatter.field("state", &self.state);
        formatter.field("recurring_charges", &self.recurring_charges);
        formatter.field("reserved_db_instance_arn", &self.reserved_db_instance_arn);
        formatter.field("lease_id", &self.lease_id);
        formatter.finish()
    }
}
/// See [`ReservedDbInstance`](crate::model::ReservedDbInstance)
pub mod reserved_db_instance {
    /// A builder for [`ReservedDbInstance`](crate::model::ReservedDbInstance)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) reserved_db_instance_id: std::option::Option<std::string::String>,
        pub(crate) reserved_db_instances_offering_id: std::option::Option<std::string::String>,
        pub(crate) db_instance_class: std::option::Option<std::string::String>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) duration: std::option::Option<i32>,
        pub(crate) fixed_price: std::option::Option<f64>,
        pub(crate) usage_price: std::option::Option<f64>,
        pub(crate) currency_code: std::option::Option<std::string::String>,
        pub(crate) db_instance_count: std::option::Option<i32>,
        pub(crate) product_description: std::option::Option<std::string::String>,
        pub(crate) offering_type: std::option::Option<std::string::String>,
        pub(crate) multi_az: std::option::Option<bool>,
        pub(crate) state: std::option::Option<std::string::String>,
        pub(crate) recurring_charges:
            std::option::Option<std::vec::Vec<crate::model::RecurringCharge>>,
        pub(crate) reserved_db_instance_arn: std::option::Option<std::string::String>,
        pub(crate) lease_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the reservation.</p>
        pub fn reserved_db_instance_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.reserved_db_instance_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the reservation.</p>
        pub fn set_reserved_db_instance_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.reserved_db_instance_id = input;
            self
        }
        /// <p>The offering identifier.</p>
        pub fn reserved_db_instances_offering_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.reserved_db_instances_offering_id = Some(input.into());
            self
        }
        /// <p>The offering identifier.</p>
        pub fn set_reserved_db_instances_offering_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.reserved_db_instances_offering_id = input;
            self
        }
        /// <p>The DB instance class for the reserved DB instance.</p>
        pub fn db_instance_class(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_instance_class = Some(input.into());
            self
        }
        /// <p>The DB instance class for the reserved DB instance.</p>
        pub fn set_db_instance_class(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_instance_class = input;
            self
        }
        /// <p>The time the reservation started.</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The time the reservation started.</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The duration of the reservation in seconds.</p>
        pub fn duration(mut self, input: i32) -> Self {
            self.duration = Some(input);
            self
        }
        /// <p>The duration of the reservation in seconds.</p>
        pub fn set_duration(mut self, input: std::option::Option<i32>) -> Self {
            self.duration = input;
            self
        }
        /// <p>The fixed price charged for this reserved DB instance.</p>
        pub fn fixed_price(mut self, input: f64) -> Self {
            self.fixed_price = Some(input);
            self
        }
        /// <p>The fixed price charged for this reserved DB instance.</p>
        pub fn set_fixed_price(mut self, input: std::option::Option<f64>) -> Self {
            self.fixed_price = input;
            self
        }
        /// <p>The hourly price charged for this reserved DB instance.</p>
        pub fn usage_price(mut self, input: f64) -> Self {
            self.usage_price = Some(input);
            self
        }
        /// <p>The hourly price charged for this reserved DB instance.</p>
        pub fn set_usage_price(mut self, input: std::option::Option<f64>) -> Self {
            self.usage_price = input;
            self
        }
        /// <p>The currency code for the reserved DB instance.</p>
        pub fn currency_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.currency_code = Some(input.into());
            self
        }
        /// <p>The currency code for the reserved DB instance.</p>
        pub fn set_currency_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.currency_code = input;
            self
        }
        /// <p>The number of reserved DB instances.</p>
        pub fn db_instance_count(mut self, input: i32) -> Self {
            self.db_instance_count = Some(input);
            self
        }
        /// <p>The number of reserved DB instances.</p>
        pub fn set_db_instance_count(mut self, input: std::option::Option<i32>) -> Self {
            self.db_instance_count = input;
            self
        }
        /// <p>The description of the reserved DB instance.</p>
        pub fn product_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.product_description = Some(input.into());
            self
        }
        /// <p>The description of the reserved DB instance.</p>
        pub fn set_product_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.product_description = input;
            self
        }
        /// <p>The offering type of this reserved DB instance.</p>
        pub fn offering_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.offering_type = Some(input.into());
            self
        }
        /// <p>The offering type of this reserved DB instance.</p>
        pub fn set_offering_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.offering_type = input;
            self
        }
        /// <p>Indicates if the reservation applies to Multi-AZ deployments.</p>
        pub fn multi_az(mut self, input: bool) -> Self {
            self.multi_az = Some(input);
            self
        }
        /// <p>Indicates if the reservation applies to Multi-AZ deployments.</p>
        pub fn set_multi_az(mut self, input: std::option::Option<bool>) -> Self {
            self.multi_az = input;
            self
        }
        /// <p>The state of the reserved DB instance.</p>
        pub fn state(mut self, input: impl Into<std::string::String>) -> Self {
            self.state = Some(input.into());
            self
        }
        /// <p>The state of the reserved DB instance.</p>
        pub fn set_state(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.state = input;
            self
        }
        /// Appends an item to `recurring_charges`.
        ///
        /// To override the contents of this collection use [`set_recurring_charges`](Self::set_recurring_charges).
        ///
        /// <p>The recurring price charged to run this reserved DB instance.</p>
        pub fn recurring_charges(mut self, input: crate::model::RecurringCharge) -> Self {
            let mut v = self.recurring_charges.unwrap_or_default();
            v.push(input);
            self.recurring_charges = Some(v);
            self
        }
        /// <p>The recurring price charged to run this reserved DB instance.</p>
        pub fn set_recurring_charges(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RecurringCharge>>,
        ) -> Self {
            self.recurring_charges = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the reserved DB instance.</p>
        pub fn reserved_db_instance_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.reserved_db_instance_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the reserved DB instance.</p>
        pub fn set_reserved_db_instance_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.reserved_db_instance_arn = input;
            self
        }
        /// <p>The unique identifier for the lease associated with the reserved DB instance.</p> <note>
        /// <p>Amazon Web Services Support might request the lease ID for an issue related to a reserved DB instance.</p>
        /// </note>
        pub fn lease_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.lease_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the lease associated with the reserved DB instance.</p> <note>
        /// <p>Amazon Web Services Support might request the lease ID for an issue related to a reserved DB instance.</p>
        /// </note>
        pub fn set_lease_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.lease_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ReservedDbInstance`](crate::model::ReservedDbInstance)
        pub fn build(self) -> crate::model::ReservedDbInstance {
            crate::model::ReservedDbInstance {
                reserved_db_instance_id: self.reserved_db_instance_id,
                reserved_db_instances_offering_id: self.reserved_db_instances_offering_id,
                db_instance_class: self.db_instance_class,
                start_time: self.start_time,
                duration: self.duration.unwrap_or_default(),
                fixed_price: self.fixed_price.unwrap_or_default(),
                usage_price: self.usage_price.unwrap_or_default(),
                currency_code: self.currency_code,
                db_instance_count: self.db_instance_count.unwrap_or_default(),
                product_description: self.product_description,
                offering_type: self.offering_type,
                multi_az: self.multi_az.unwrap_or_default(),
                state: self.state,
                recurring_charges: self.recurring_charges,
                reserved_db_instance_arn: self.reserved_db_instance_arn,
                lease_id: self.lease_id,
            }
        }
    }
}
impl ReservedDbInstance {
    /// Creates a new builder-style object to manufacture [`ReservedDbInstance`](crate::model::ReservedDbInstance)
    pub fn builder() -> crate::model::reserved_db_instance::Builder {
        crate::model::reserved_db_instance::Builder::default()
    }
}

/// <p> This data type is used as a response element in the <code>DescribeReservedDBInstances</code> and <code>DescribeReservedDBInstancesOfferings</code> actions. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RecurringCharge {
    /// <p>The amount of the recurring charge.</p>
    pub recurring_charge_amount: f64,
    /// <p>The frequency of the recurring charge.</p>
    pub recurring_charge_frequency: std::option::Option<std::string::String>,
}
impl RecurringCharge {
    /// <p>The amount of the recurring charge.</p>
    pub fn recurring_charge_amount(&self) -> f64 {
        self.recurring_charge_amount
    }
    /// <p>The frequency of the recurring charge.</p>
    pub fn recurring_charge_frequency(&self) -> std::option::Option<&str> {
        self.recurring_charge_frequency.as_deref()
    }
}
impl std::fmt::Debug for RecurringCharge {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RecurringCharge");
        formatter.field("recurring_charge_amount", &self.recurring_charge_amount);
        formatter.field(
            "recurring_charge_frequency",
            &self.recurring_charge_frequency,
        );
        formatter.finish()
    }
}
/// See [`RecurringCharge`](crate::model::RecurringCharge)
pub mod recurring_charge {
    /// A builder for [`RecurringCharge`](crate::model::RecurringCharge)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) recurring_charge_amount: std::option::Option<f64>,
        pub(crate) recurring_charge_frequency: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The amount of the recurring charge.</p>
        pub fn recurring_charge_amount(mut self, input: f64) -> Self {
            self.recurring_charge_amount = Some(input);
            self
        }
        /// <p>The amount of the recurring charge.</p>
        pub fn set_recurring_charge_amount(mut self, input: std::option::Option<f64>) -> Self {
            self.recurring_charge_amount = input;
            self
        }
        /// <p>The frequency of the recurring charge.</p>
        pub fn recurring_charge_frequency(mut self, input: impl Into<std::string::String>) -> Self {
            self.recurring_charge_frequency = Some(input.into());
            self
        }
        /// <p>The frequency of the recurring charge.</p>
        pub fn set_recurring_charge_frequency(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.recurring_charge_frequency = input;
            self
        }
        /// Consumes the builder and constructs a [`RecurringCharge`](crate::model::RecurringCharge)
        pub fn build(self) -> crate::model::RecurringCharge {
            crate::model::RecurringCharge {
                recurring_charge_amount: self.recurring_charge_amount.unwrap_or_default(),
                recurring_charge_frequency: self.recurring_charge_frequency,
            }
        }
    }
}
impl RecurringCharge {
    /// Creates a new builder-style object to manufacture [`RecurringCharge`](crate::model::RecurringCharge)
    pub fn builder() -> crate::model::recurring_charge::Builder {
        crate::model::recurring_charge::Builder::default()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OptionGroup {
    /// <p>Specifies the name of the option group.</p>
    pub option_group_name: std::option::Option<std::string::String>,
    /// <p>Provides a description of the option group.</p>
    pub option_group_description: std::option::Option<std::string::String>,
    /// <p>Indicates the name of the engine that this option group can be applied to.</p>
    pub engine_name: std::option::Option<std::string::String>,
    /// <p>Indicates the major engine version associated with this option group.</p>
    pub major_engine_version: std::option::Option<std::string::String>,
    /// <p>Indicates what options are available in the option group.</p>
    pub options: std::option::Option<std::vec::Vec<crate::model::Option>>,
    /// <p>Indicates whether this option group can be applied to both VPC and non-VPC instances. The value <code>true</code> indicates the option group can be applied to both VPC and non-VPC instances. </p>
    pub allows_vpc_and_non_vpc_instance_memberships: bool,
    /// <p>If <b>AllowsVpcAndNonVpcInstanceMemberships</b> is <code>false</code>, this field is blank. If <b>AllowsVpcAndNonVpcInstanceMemberships</b> is <code>true</code> and this field is blank, then this option group can be applied to both VPC and non-VPC instances. If this field contains a value, then this option group can only be applied to instances that are in the VPC indicated by this field. </p>
    pub vpc_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) for the option group.</p>
    pub option_group_arn: std::option::Option<std::string::String>,
}
impl OptionGroup {
    /// <p>Specifies the name of the option group.</p>
    pub fn option_group_name(&self) -> std::option::Option<&str> {
        self.option_group_name.as_deref()
    }
    /// <p>Provides a description of the option group.</p>
    pub fn option_group_description(&self) -> std::option::Option<&str> {
        self.option_group_description.as_deref()
    }
    /// <p>Indicates the name of the engine that this option group can be applied to.</p>
    pub fn engine_name(&self) -> std::option::Option<&str> {
        self.engine_name.as_deref()
    }
    /// <p>Indicates the major engine version associated with this option group.</p>
    pub fn major_engine_version(&self) -> std::option::Option<&str> {
        self.major_engine_version.as_deref()
    }
    /// <p>Indicates what options are available in the option group.</p>
    pub fn options(&self) -> std::option::Option<&[crate::model::Option]> {
        self.options.as_deref()
    }
    /// <p>Indicates whether this option group can be applied to both VPC and non-VPC instances. The value <code>true</code> indicates the option group can be applied to both VPC and non-VPC instances. </p>
    pub fn allows_vpc_and_non_vpc_instance_memberships(&self) -> bool {
        self.allows_vpc_and_non_vpc_instance_memberships
    }
    /// <p>If <b>AllowsVpcAndNonVpcInstanceMemberships</b> is <code>false</code>, this field is blank. If <b>AllowsVpcAndNonVpcInstanceMemberships</b> is <code>true</code> and this field is blank, then this option group can be applied to both VPC and non-VPC instances. If this field contains a value, then this option group can only be applied to instances that are in the VPC indicated by this field. </p>
    pub fn vpc_id(&self) -> std::option::Option<&str> {
        self.vpc_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) for the option group.</p>
    pub fn option_group_arn(&self) -> std::option::Option<&str> {
        self.option_group_arn.as_deref()
    }
}
impl std::fmt::Debug for OptionGroup {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OptionGroup");
        formatter.field("option_group_name", &self.option_group_name);
        formatter.field("option_group_description", &self.option_group_description);
        formatter.field("engine_name", &self.engine_name);
        formatter.field("major_engine_version", &self.major_engine_version);
        formatter.field("options", &self.options);
        formatter.field(
            "allows_vpc_and_non_vpc_instance_memberships",
            &self.allows_vpc_and_non_vpc_instance_memberships,
        );
        formatter.field("vpc_id", &self.vpc_id);
        formatter.field("option_group_arn", &self.option_group_arn);
        formatter.finish()
    }
}
/// See [`OptionGroup`](crate::model::OptionGroup)
pub mod option_group {
    /// A builder for [`OptionGroup`](crate::model::OptionGroup)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) option_group_name: std::option::Option<std::string::String>,
        pub(crate) option_group_description: std::option::Option<std::string::String>,
        pub(crate) engine_name: std::option::Option<std::string::String>,
        pub(crate) major_engine_version: std::option::Option<std::string::String>,
        pub(crate) options: std::option::Option<std::vec::Vec<crate::model::Option>>,
        pub(crate) allows_vpc_and_non_vpc_instance_memberships: std::option::Option<bool>,
        pub(crate) vpc_id: std::option::Option<std::string::String>,
        pub(crate) option_group_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies the name of the option group.</p>
        pub fn option_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.option_group_name = Some(input.into());
            self
        }
        /// <p>Specifies the name of the option group.</p>
        pub fn set_option_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.option_group_name = input;
            self
        }
        /// <p>Provides a description of the option group.</p>
        pub fn option_group_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.option_group_description = Some(input.into());
            self
        }
        /// <p>Provides a description of the option group.</p>
        pub fn set_option_group_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.option_group_description = input;
            self
        }
        /// <p>Indicates the name of the engine that this option group can be applied to.</p>
        pub fn engine_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_name = Some(input.into());
            self
        }
        /// <p>Indicates the name of the engine that this option group can be applied to.</p>
        pub fn set_engine_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.engine_name = input;
            self
        }
        /// <p>Indicates the major engine version associated with this option group.</p>
        pub fn major_engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.major_engine_version = Some(input.into());
            self
        }
        /// <p>Indicates the major engine version associated with this option group.</p>
        pub fn set_major_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.major_engine_version = input;
            self
        }
        /// Appends an item to `options`.
        ///
        /// To override the contents of this collection use [`set_options`](Self::set_options).
        ///
        /// <p>Indicates what options are available in the option group.</p>
        pub fn options(mut self, input: crate::model::Option) -> Self {
            let mut v = self.options.unwrap_or_default();
            v.push(input);
            self.options = Some(v);
            self
        }
        /// <p>Indicates what options are available in the option group.</p>
        pub fn set_options(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Option>>,
        ) -> Self {
            self.options = input;
            self
        }
        /// <p>Indicates whether this option group can be applied to both VPC and non-VPC instances. The value <code>true</code> indicates the option group can be applied to both VPC and non-VPC instances. </p>
        pub fn allows_vpc_and_non_vpc_instance_memberships(mut self, input: bool) -> Self {
            self.allows_vpc_and_non_vpc_instance_memberships = Some(input);
            self
        }
        /// <p>Indicates whether this option group can be applied to both VPC and non-VPC instances. The value <code>true</code> indicates the option group can be applied to both VPC and non-VPC instances. </p>
        pub fn set_allows_vpc_and_non_vpc_instance_memberships(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.allows_vpc_and_non_vpc_instance_memberships = input;
            self
        }
        /// <p>If <b>AllowsVpcAndNonVpcInstanceMemberships</b> is <code>false</code>, this field is blank. If <b>AllowsVpcAndNonVpcInstanceMemberships</b> is <code>true</code> and this field is blank, then this option group can be applied to both VPC and non-VPC instances. If this field contains a value, then this option group can only be applied to instances that are in the VPC indicated by this field. </p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_id = Some(input.into());
            self
        }
        /// <p>If <b>AllowsVpcAndNonVpcInstanceMemberships</b> is <code>false</code>, this field is blank. If <b>AllowsVpcAndNonVpcInstanceMemberships</b> is <code>true</code> and this field is blank, then this option group can be applied to both VPC and non-VPC instances. If this field contains a value, then this option group can only be applied to instances that are in the VPC indicated by this field. </p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the option group.</p>
        pub fn option_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.option_group_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the option group.</p>
        pub fn set_option_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.option_group_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`OptionGroup`](crate::model::OptionGroup)
        pub fn build(self) -> crate::model::OptionGroup {
            crate::model::OptionGroup {
                option_group_name: self.option_group_name,
                option_group_description: self.option_group_description,
                engine_name: self.engine_name,
                major_engine_version: self.major_engine_version,
                options: self.options,
                allows_vpc_and_non_vpc_instance_memberships: self
                    .allows_vpc_and_non_vpc_instance_memberships
                    .unwrap_or_default(),
                vpc_id: self.vpc_id,
                option_group_arn: self.option_group_arn,
            }
        }
    }
}
impl OptionGroup {
    /// Creates a new builder-style object to manufacture [`OptionGroup`](crate::model::OptionGroup)
    pub fn builder() -> crate::model::option_group::Builder {
        crate::model::option_group::Builder::default()
    }
}

/// <p>Option details.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Option {
    /// <p>The name of the option.</p>
    pub option_name: std::option::Option<std::string::String>,
    /// <p>The description of the option.</p>
    pub option_description: std::option::Option<std::string::String>,
    /// <p>Indicate if this option is persistent.</p>
    pub persistent: bool,
    /// <p>Indicate if this option is permanent.</p>
    pub permanent: bool,
    /// <p>If required, the port configured for this option to use.</p>
    pub port: std::option::Option<i32>,
    /// <p>The version of the option.</p>
    pub option_version: std::option::Option<std::string::String>,
    /// <p>The option settings for this option.</p>
    pub option_settings: std::option::Option<std::vec::Vec<crate::model::OptionSetting>>,
    /// <p>If the option requires access to a port, then this DB security group allows access to the port.</p>
    pub db_security_group_memberships:
        std::option::Option<std::vec::Vec<crate::model::DbSecurityGroupMembership>>,
    /// <p>If the option requires access to a port, then this VPC security group allows access to the port.</p>
    pub vpc_security_group_memberships:
        std::option::Option<std::vec::Vec<crate::model::VpcSecurityGroupMembership>>,
}
impl Option {
    /// <p>The name of the option.</p>
    pub fn option_name(&self) -> std::option::Option<&str> {
        self.option_name.as_deref()
    }
    /// <p>The description of the option.</p>
    pub fn option_description(&self) -> std::option::Option<&str> {
        self.option_description.as_deref()
    }
    /// <p>Indicate if this option is persistent.</p>
    pub fn persistent(&self) -> bool {
        self.persistent
    }
    /// <p>Indicate if this option is permanent.</p>
    pub fn permanent(&self) -> bool {
        self.permanent
    }
    /// <p>If required, the port configured for this option to use.</p>
    pub fn port(&self) -> std::option::Option<i32> {
        self.port
    }
    /// <p>The version of the option.</p>
    pub fn option_version(&self) -> std::option::Option<&str> {
        self.option_version.as_deref()
    }
    /// <p>The option settings for this option.</p>
    pub fn option_settings(&self) -> std::option::Option<&[crate::model::OptionSetting]> {
        self.option_settings.as_deref()
    }
    /// <p>If the option requires access to a port, then this DB security group allows access to the port.</p>
    pub fn db_security_group_memberships(
        &self,
    ) -> std::option::Option<&[crate::model::DbSecurityGroupMembership]> {
        self.db_security_group_memberships.as_deref()
    }
    /// <p>If the option requires access to a port, then this VPC security group allows access to the port.</p>
    pub fn vpc_security_group_memberships(
        &self,
    ) -> std::option::Option<&[crate::model::VpcSecurityGroupMembership]> {
        self.vpc_security_group_memberships.as_deref()
    }
}
impl std::fmt::Debug for Option {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Option");
        formatter.field("option_name", &self.option_name);
        formatter.field("option_description", &self.option_description);
        formatter.field("persistent", &self.persistent);
        formatter.field("permanent", &self.permanent);
        formatter.field("port", &self.port);
        formatter.field("option_version", &self.option_version);
        formatter.field("option_settings", &self.option_settings);
        formatter.field(
            "db_security_group_memberships",
            &self.db_security_group_memberships,
        );
        formatter.field(
            "vpc_security_group_memberships",
            &self.vpc_security_group_memberships,
        );
        formatter.finish()
    }
}
/// See [`Option`](crate::model::Option)
pub mod option {
    /// A builder for [`Option`](crate::model::Option)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) option_name: std::option::Option<std::string::String>,
        pub(crate) option_description: std::option::Option<std::string::String>,
        pub(crate) persistent: std::option::Option<bool>,
        pub(crate) permanent: std::option::Option<bool>,
        pub(crate) port: std::option::Option<i32>,
        pub(crate) option_version: std::option::Option<std::string::String>,
        pub(crate) option_settings: std::option::Option<std::vec::Vec<crate::model::OptionSetting>>,
        pub(crate) db_security_group_memberships:
            std::option::Option<std::vec::Vec<crate::model::DbSecurityGroupMembership>>,
        pub(crate) vpc_security_group_memberships:
            std::option::Option<std::vec::Vec<crate::model::VpcSecurityGroupMembership>>,
    }
    impl Builder {
        /// <p>The name of the option.</p>
        pub fn option_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.option_name = Some(input.into());
            self
        }
        /// <p>The name of the option.</p>
        pub fn set_option_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.option_name = input;
            self
        }
        /// <p>The description of the option.</p>
        pub fn option_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.option_description = Some(input.into());
            self
        }
        /// <p>The description of the option.</p>
        pub fn set_option_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.option_description = input;
            self
        }
        /// <p>Indicate if this option is persistent.</p>
        pub fn persistent(mut self, input: bool) -> Self {
            self.persistent = Some(input);
            self
        }
        /// <p>Indicate if this option is persistent.</p>
        pub fn set_persistent(mut self, input: std::option::Option<bool>) -> Self {
            self.persistent = input;
            self
        }
        /// <p>Indicate if this option is permanent.</p>
        pub fn permanent(mut self, input: bool) -> Self {
            self.permanent = Some(input);
            self
        }
        /// <p>Indicate if this option is permanent.</p>
        pub fn set_permanent(mut self, input: std::option::Option<bool>) -> Self {
            self.permanent = input;
            self
        }
        /// <p>If required, the port configured for this option to use.</p>
        pub fn port(mut self, input: i32) -> Self {
            self.port = Some(input);
            self
        }
        /// <p>If required, the port configured for this option to use.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.port = input;
            self
        }
        /// <p>The version of the option.</p>
        pub fn option_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.option_version = Some(input.into());
            self
        }
        /// <p>The version of the option.</p>
        pub fn set_option_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.option_version = input;
            self
        }
        /// Appends an item to `option_settings`.
        ///
        /// To override the contents of this collection use [`set_option_settings`](Self::set_option_settings).
        ///
        /// <p>The option settings for this option.</p>
        pub fn option_settings(mut self, input: crate::model::OptionSetting) -> Self {
            let mut v = self.option_settings.unwrap_or_default();
            v.push(input);
            self.option_settings = Some(v);
            self
        }
        /// <p>The option settings for this option.</p>
        pub fn set_option_settings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OptionSetting>>,
        ) -> Self {
            self.option_settings = input;
            self
        }
        /// Appends an item to `db_security_group_memberships`.
        ///
        /// To override the contents of this collection use [`set_db_security_group_memberships`](Self::set_db_security_group_memberships).
        ///
        /// <p>If the option requires access to a port, then this DB security group allows access to the port.</p>
        pub fn db_security_group_memberships(
            mut self,
            input: crate::model::DbSecurityGroupMembership,
        ) -> Self {
            let mut v = self.db_security_group_memberships.unwrap_or_default();
            v.push(input);
            self.db_security_group_memberships = Some(v);
            self
        }
        /// <p>If the option requires access to a port, then this DB security group allows access to the port.</p>
        pub fn set_db_security_group_memberships(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DbSecurityGroupMembership>>,
        ) -> Self {
            self.db_security_group_memberships = input;
            self
        }
        /// Appends an item to `vpc_security_group_memberships`.
        ///
        /// To override the contents of this collection use [`set_vpc_security_group_memberships`](Self::set_vpc_security_group_memberships).
        ///
        /// <p>If the option requires access to a port, then this VPC security group allows access to the port.</p>
        pub fn vpc_security_group_memberships(
            mut self,
            input: crate::model::VpcSecurityGroupMembership,
        ) -> Self {
            let mut v = self.vpc_security_group_memberships.unwrap_or_default();
            v.push(input);
            self.vpc_security_group_memberships = Some(v);
            self
        }
        /// <p>If the option requires access to a port, then this VPC security group allows access to the port.</p>
        pub fn set_vpc_security_group_memberships(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::VpcSecurityGroupMembership>>,
        ) -> Self {
            self.vpc_security_group_memberships = input;
            self
        }
        /// Consumes the builder and constructs a [`Option`](crate::model::Option)
        pub fn build(self) -> crate::model::Option {
            crate::model::Option {
                option_name: self.option_name,
                option_description: self.option_description,
                persistent: self.persistent.unwrap_or_default(),
                permanent: self.permanent.unwrap_or_default(),
                port: self.port,
                option_version: self.option_version,
                option_settings: self.option_settings,
                db_security_group_memberships: self.db_security_group_memberships,
                vpc_security_group_memberships: self.vpc_security_group_memberships,
            }
        }
    }
}
impl Option {
    /// Creates a new builder-style object to manufacture [`Option`](crate::model::Option)
    pub fn builder() -> crate::model::option::Builder {
        crate::model::option::Builder::default()
    }
}

/// <p>Option settings are the actual settings being applied or configured for that option. It is used when you modify an option group or describe option groups. For example, the NATIVE_NETWORK_ENCRYPTION option has a setting called SQLNET.ENCRYPTION_SERVER that can have several different values.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OptionSetting {
    /// <p>The name of the option that has settings that you can set.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The current value of the option setting.</p>
    pub value: std::option::Option<std::string::String>,
    /// <p>The default value of the option setting.</p>
    pub default_value: std::option::Option<std::string::String>,
    /// <p>The description of the option setting.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The DB engine specific parameter type.</p>
    pub apply_type: std::option::Option<std::string::String>,
    /// <p>The data type of the option setting.</p>
    pub data_type: std::option::Option<std::string::String>,
    /// <p>The allowed values of the option setting.</p>
    pub allowed_values: std::option::Option<std::string::String>,
    /// <p>A Boolean value that, when true, indicates the option setting can be modified from the default.</p>
    pub is_modifiable: bool,
    /// <p>Indicates if the option setting is part of a collection.</p>
    pub is_collection: bool,
}
impl OptionSetting {
    /// <p>The name of the option that has settings that you can set.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The current value of the option setting.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
    /// <p>The default value of the option setting.</p>
    pub fn default_value(&self) -> std::option::Option<&str> {
        self.default_value.as_deref()
    }
    /// <p>The description of the option setting.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The DB engine specific parameter type.</p>
    pub fn apply_type(&self) -> std::option::Option<&str> {
        self.apply_type.as_deref()
    }
    /// <p>The data type of the option setting.</p>
    pub fn data_type(&self) -> std::option::Option<&str> {
        self.data_type.as_deref()
    }
    /// <p>The allowed values of the option setting.</p>
    pub fn allowed_values(&self) -> std::option::Option<&str> {
        self.allowed_values.as_deref()
    }
    /// <p>A Boolean value that, when true, indicates the option setting can be modified from the default.</p>
    pub fn is_modifiable(&self) -> bool {
        self.is_modifiable
    }
    /// <p>Indicates if the option setting is part of a collection.</p>
    pub fn is_collection(&self) -> bool {
        self.is_collection
    }
}
impl std::fmt::Debug for OptionSetting {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OptionSetting");
        formatter.field("name", &self.name);
        formatter.field("value", &self.value);
        formatter.field("default_value", &self.default_value);
        formatter.field("description", &self.description);
        formatter.field("apply_type", &self.apply_type);
        formatter.field("data_type", &self.data_type);
        formatter.field("allowed_values", &self.allowed_values);
        formatter.field("is_modifiable", &self.is_modifiable);
        formatter.field("is_collection", &self.is_collection);
        formatter.finish()
    }
}
/// See [`OptionSetting`](crate::model::OptionSetting)
pub mod option_setting {
    /// A builder for [`OptionSetting`](crate::model::OptionSetting)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
        pub(crate) default_value: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) apply_type: std::option::Option<std::string::String>,
        pub(crate) data_type: std::option::Option<std::string::String>,
        pub(crate) allowed_values: std::option::Option<std::string::String>,
        pub(crate) is_modifiable: std::option::Option<bool>,
        pub(crate) is_collection: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of the option that has settings that you can set.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the option that has settings that you can set.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The current value of the option setting.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The current value of the option setting.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// <p>The default value of the option setting.</p>
        pub fn default_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_value = Some(input.into());
            self
        }
        /// <p>The default value of the option setting.</p>
        pub fn set_default_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_value = input;
            self
        }
        /// <p>The description of the option setting.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the option setting.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The DB engine specific parameter type.</p>
        pub fn apply_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.apply_type = Some(input.into());
            self
        }
        /// <p>The DB engine specific parameter type.</p>
        pub fn set_apply_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.apply_type = input;
            self
        }
        /// <p>The data type of the option setting.</p>
        pub fn data_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_type = Some(input.into());
            self
        }
        /// <p>The data type of the option setting.</p>
        pub fn set_data_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.data_type = input;
            self
        }
        /// <p>The allowed values of the option setting.</p>
        pub fn allowed_values(mut self, input: impl Into<std::string::String>) -> Self {
            self.allowed_values = Some(input.into());
            self
        }
        /// <p>The allowed values of the option setting.</p>
        pub fn set_allowed_values(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.allowed_values = input;
            self
        }
        /// <p>A Boolean value that, when true, indicates the option setting can be modified from the default.</p>
        pub fn is_modifiable(mut self, input: bool) -> Self {
            self.is_modifiable = Some(input);
            self
        }
        /// <p>A Boolean value that, when true, indicates the option setting can be modified from the default.</p>
        pub fn set_is_modifiable(mut self, input: std::option::Option<bool>) -> Self {
            self.is_modifiable = input;
            self
        }
        /// <p>Indicates if the option setting is part of a collection.</p>
        pub fn is_collection(mut self, input: bool) -> Self {
            self.is_collection = Some(input);
            self
        }
        /// <p>Indicates if the option setting is part of a collection.</p>
        pub fn set_is_collection(mut self, input: std::option::Option<bool>) -> Self {
            self.is_collection = input;
            self
        }
        /// Consumes the builder and constructs a [`OptionSetting`](crate::model::OptionSetting)
        pub fn build(self) -> crate::model::OptionSetting {
            crate::model::OptionSetting {
                name: self.name,
                value: self.value,
                default_value: self.default_value,
                description: self.description,
                apply_type: self.apply_type,
                data_type: self.data_type,
                allowed_values: self.allowed_values,
                is_modifiable: self.is_modifiable.unwrap_or_default(),
                is_collection: self.is_collection.unwrap_or_default(),
            }
        }
    }
}
impl OptionSetting {
    /// Creates a new builder-style object to manufacture [`OptionSetting`](crate::model::OptionSetting)
    pub fn builder() -> crate::model::option_setting::Builder {
        crate::model::option_setting::Builder::default()
    }
}

/// <p>A list of all available options</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OptionConfiguration {
    /// <p>The configuration of options to include in a group.</p>
    pub option_name: std::option::Option<std::string::String>,
    /// <p>The optional port for the option.</p>
    pub port: std::option::Option<i32>,
    /// <p>The version for the option.</p>
    pub option_version: std::option::Option<std::string::String>,
    /// <p>A list of DBSecurityGroupMembership name strings used for this option.</p>
    pub db_security_group_memberships: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A list of VpcSecurityGroupMembership name strings used for this option.</p>
    pub vpc_security_group_memberships: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The option settings to include in an option group.</p>
    pub option_settings: std::option::Option<std::vec::Vec<crate::model::OptionSetting>>,
}
impl OptionConfiguration {
    /// <p>The configuration of options to include in a group.</p>
    pub fn option_name(&self) -> std::option::Option<&str> {
        self.option_name.as_deref()
    }
    /// <p>The optional port for the option.</p>
    pub fn port(&self) -> std::option::Option<i32> {
        self.port
    }
    /// <p>The version for the option.</p>
    pub fn option_version(&self) -> std::option::Option<&str> {
        self.option_version.as_deref()
    }
    /// <p>A list of DBSecurityGroupMembership name strings used for this option.</p>
    pub fn db_security_group_memberships(&self) -> std::option::Option<&[std::string::String]> {
        self.db_security_group_memberships.as_deref()
    }
    /// <p>A list of VpcSecurityGroupMembership name strings used for this option.</p>
    pub fn vpc_security_group_memberships(&self) -> std::option::Option<&[std::string::String]> {
        self.vpc_security_group_memberships.as_deref()
    }
    /// <p>The option settings to include in an option group.</p>
    pub fn option_settings(&self) -> std::option::Option<&[crate::model::OptionSetting]> {
        self.option_settings.as_deref()
    }
}
impl std::fmt::Debug for OptionConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OptionConfiguration");
        formatter.field("option_name", &self.option_name);
        formatter.field("port", &self.port);
        formatter.field("option_version", &self.option_version);
        formatter.field(
            "db_security_group_memberships",
            &self.db_security_group_memberships,
        );
        formatter.field(
            "vpc_security_group_memberships",
            &self.vpc_security_group_memberships,
        );
        formatter.field("option_settings", &self.option_settings);
        formatter.finish()
    }
}
/// See [`OptionConfiguration`](crate::model::OptionConfiguration)
pub mod option_configuration {
    /// A builder for [`OptionConfiguration`](crate::model::OptionConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) option_name: std::option::Option<std::string::String>,
        pub(crate) port: std::option::Option<i32>,
        pub(crate) option_version: std::option::Option<std::string::String>,
        pub(crate) db_security_group_memberships:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) vpc_security_group_memberships:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) option_settings: std::option::Option<std::vec::Vec<crate::model::OptionSetting>>,
    }
    impl Builder {
        /// <p>The configuration of options to include in a group.</p>
        pub fn option_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.option_name = Some(input.into());
            self
        }
        /// <p>The configuration of options to include in a group.</p>
        pub fn set_option_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.option_name = input;
            self
        }
        /// <p>The optional port for the option.</p>
        pub fn port(mut self, input: i32) -> Self {
            self.port = Some(input);
            self
        }
        /// <p>The optional port for the option.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.port = input;
            self
        }
        /// <p>The version for the option.</p>
        pub fn option_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.option_version = Some(input.into());
            self
        }
        /// <p>The version for the option.</p>
        pub fn set_option_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.option_version = input;
            self
        }
        /// Appends an item to `db_security_group_memberships`.
        ///
        /// To override the contents of this collection use [`set_db_security_group_memberships`](Self::set_db_security_group_memberships).
        ///
        /// <p>A list of DBSecurityGroupMembership name strings used for this option.</p>
        pub fn db_security_group_memberships(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.db_security_group_memberships.unwrap_or_default();
            v.push(input.into());
            self.db_security_group_memberships = Some(v);
            self
        }
        /// <p>A list of DBSecurityGroupMembership name strings used for this option.</p>
        pub fn set_db_security_group_memberships(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.db_security_group_memberships = input;
            self
        }
        /// Appends an item to `vpc_security_group_memberships`.
        ///
        /// To override the contents of this collection use [`set_vpc_security_group_memberships`](Self::set_vpc_security_group_memberships).
        ///
        /// <p>A list of VpcSecurityGroupMembership name strings used for this option.</p>
        pub fn vpc_security_group_memberships(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.vpc_security_group_memberships.unwrap_or_default();
            v.push(input.into());
            self.vpc_security_group_memberships = Some(v);
            self
        }
        /// <p>A list of VpcSecurityGroupMembership name strings used for this option.</p>
        pub fn set_vpc_security_group_memberships(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.vpc_security_group_memberships = input;
            self
        }
        /// Appends an item to `option_settings`.
        ///
        /// To override the contents of this collection use [`set_option_settings`](Self::set_option_settings).
        ///
        /// <p>The option settings to include in an option group.</p>
        pub fn option_settings(mut self, input: crate::model::OptionSetting) -> Self {
            let mut v = self.option_settings.unwrap_or_default();
            v.push(input);
            self.option_settings = Some(v);
            self
        }
        /// <p>The option settings to include in an option group.</p>
        pub fn set_option_settings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OptionSetting>>,
        ) -> Self {
            self.option_settings = input;
            self
        }
        /// Consumes the builder and constructs a [`OptionConfiguration`](crate::model::OptionConfiguration)
        pub fn build(self) -> crate::model::OptionConfiguration {
            crate::model::OptionConfiguration {
                option_name: self.option_name,
                port: self.port,
                option_version: self.option_version,
                db_security_group_memberships: self.db_security_group_memberships,
                vpc_security_group_memberships: self.vpc_security_group_memberships,
                option_settings: self.option_settings,
            }
        }
    }
}
impl OptionConfiguration {
    /// Creates a new builder-style object to manufacture [`OptionConfiguration`](crate::model::OptionConfiguration)
    pub fn builder() -> crate::model::option_configuration::Builder {
        crate::model::option_configuration::Builder::default()
    }
}

/// <p>Contains the results of a successful call to the <code>DescribeDBSnapshotAttributes</code> API action.</p>
/// <p>Manual DB snapshot attributes are used to authorize other Amazon Web Services accounts to copy or restore a manual DB snapshot. For more information, see the <code>ModifyDBSnapshotAttribute</code> API action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DbSnapshotAttributesResult {
    /// <p>The identifier of the manual DB snapshot that the attributes apply to.</p>
    pub db_snapshot_identifier: std::option::Option<std::string::String>,
    /// <p>The list of attributes and values for the manual DB snapshot.</p>
    pub db_snapshot_attributes:
        std::option::Option<std::vec::Vec<crate::model::DbSnapshotAttribute>>,
}
impl DbSnapshotAttributesResult {
    /// <p>The identifier of the manual DB snapshot that the attributes apply to.</p>
    pub fn db_snapshot_identifier(&self) -> std::option::Option<&str> {
        self.db_snapshot_identifier.as_deref()
    }
    /// <p>The list of attributes and values for the manual DB snapshot.</p>
    pub fn db_snapshot_attributes(
        &self,
    ) -> std::option::Option<&[crate::model::DbSnapshotAttribute]> {
        self.db_snapshot_attributes.as_deref()
    }
}
impl std::fmt::Debug for DbSnapshotAttributesResult {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DbSnapshotAttributesResult");
        formatter.field("db_snapshot_identifier", &self.db_snapshot_identifier);
        formatter.field("db_snapshot_attributes", &self.db_snapshot_attributes);
        formatter.finish()
    }
}
/// See [`DbSnapshotAttributesResult`](crate::model::DbSnapshotAttributesResult)
pub mod db_snapshot_attributes_result {
    /// A builder for [`DbSnapshotAttributesResult`](crate::model::DbSnapshotAttributesResult)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_snapshot_identifier: std::option::Option<std::string::String>,
        pub(crate) db_snapshot_attributes:
            std::option::Option<std::vec::Vec<crate::model::DbSnapshotAttribute>>,
    }
    impl Builder {
        /// <p>The identifier of the manual DB snapshot that the attributes apply to.</p>
        pub fn db_snapshot_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_snapshot_identifier = Some(input.into());
            self
        }
        /// <p>The identifier of the manual DB snapshot that the attributes apply to.</p>
        pub fn set_db_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_snapshot_identifier = input;
            self
        }
        /// Appends an item to `db_snapshot_attributes`.
        ///
        /// To override the contents of this collection use [`set_db_snapshot_attributes`](Self::set_db_snapshot_attributes).
        ///
        /// <p>The list of attributes and values for the manual DB snapshot.</p>
        pub fn db_snapshot_attributes(mut self, input: crate::model::DbSnapshotAttribute) -> Self {
            let mut v = self.db_snapshot_attributes.unwrap_or_default();
            v.push(input);
            self.db_snapshot_attributes = Some(v);
            self
        }
        /// <p>The list of attributes and values for the manual DB snapshot.</p>
        pub fn set_db_snapshot_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DbSnapshotAttribute>>,
        ) -> Self {
            self.db_snapshot_attributes = input;
            self
        }
        /// Consumes the builder and constructs a [`DbSnapshotAttributesResult`](crate::model::DbSnapshotAttributesResult)
        pub fn build(self) -> crate::model::DbSnapshotAttributesResult {
            crate::model::DbSnapshotAttributesResult {
                db_snapshot_identifier: self.db_snapshot_identifier,
                db_snapshot_attributes: self.db_snapshot_attributes,
            }
        }
    }
}
impl DbSnapshotAttributesResult {
    /// Creates a new builder-style object to manufacture [`DbSnapshotAttributesResult`](crate::model::DbSnapshotAttributesResult)
    pub fn builder() -> crate::model::db_snapshot_attributes_result::Builder {
        crate::model::db_snapshot_attributes_result::Builder::default()
    }
}

/// <p>Contains the name and values of a manual DB snapshot attribute</p>
/// <p>Manual DB snapshot attributes are used to authorize other Amazon Web Services accounts to restore a manual DB snapshot. For more information, see the <code>ModifyDBSnapshotAttribute</code> API.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DbSnapshotAttribute {
    /// <p>The name of the manual DB snapshot attribute.</p>
    /// <p>The attribute named <code>restore</code> refers to the list of Amazon Web Services accounts that have permission to copy or restore the manual DB cluster snapshot. For more information, see the <code>ModifyDBSnapshotAttribute</code> API action.</p>
    pub attribute_name: std::option::Option<std::string::String>,
    /// <p>The value or values for the manual DB snapshot attribute.</p>
    /// <p>If the <code>AttributeName</code> field is set to <code>restore</code>, then this element returns a list of IDs of the Amazon Web Services accounts that are authorized to copy or restore the manual DB snapshot. If a value of <code>all</code> is in the list, then the manual DB snapshot is public and available for any Amazon Web Services account to copy or restore.</p>
    pub attribute_values: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl DbSnapshotAttribute {
    /// <p>The name of the manual DB snapshot attribute.</p>
    /// <p>The attribute named <code>restore</code> refers to the list of Amazon Web Services accounts that have permission to copy or restore the manual DB cluster snapshot. For more information, see the <code>ModifyDBSnapshotAttribute</code> API action.</p>
    pub fn attribute_name(&self) -> std::option::Option<&str> {
        self.attribute_name.as_deref()
    }
    /// <p>The value or values for the manual DB snapshot attribute.</p>
    /// <p>If the <code>AttributeName</code> field is set to <code>restore</code>, then this element returns a list of IDs of the Amazon Web Services accounts that are authorized to copy or restore the manual DB snapshot. If a value of <code>all</code> is in the list, then the manual DB snapshot is public and available for any Amazon Web Services account to copy or restore.</p>
    pub fn attribute_values(&self) -> std::option::Option<&[std::string::String]> {
        self.attribute_values.as_deref()
    }
}
impl std::fmt::Debug for DbSnapshotAttribute {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DbSnapshotAttribute");
        formatter.field("attribute_name", &self.attribute_name);
        formatter.field("attribute_values", &self.attribute_values);
        formatter.finish()
    }
}
/// See [`DbSnapshotAttribute`](crate::model::DbSnapshotAttribute)
pub mod db_snapshot_attribute {
    /// A builder for [`DbSnapshotAttribute`](crate::model::DbSnapshotAttribute)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attribute_name: std::option::Option<std::string::String>,
        pub(crate) attribute_values: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of the manual DB snapshot attribute.</p>
        /// <p>The attribute named <code>restore</code> refers to the list of Amazon Web Services accounts that have permission to copy or restore the manual DB cluster snapshot. For more information, see the <code>ModifyDBSnapshotAttribute</code> API action.</p>
        pub fn attribute_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.attribute_name = Some(input.into());
            self
        }
        /// <p>The name of the manual DB snapshot attribute.</p>
        /// <p>The attribute named <code>restore</code> refers to the list of Amazon Web Services accounts that have permission to copy or restore the manual DB cluster snapshot. For more information, see the <code>ModifyDBSnapshotAttribute</code> API action.</p>
        pub fn set_attribute_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.attribute_name = input;
            self
        }
        /// Appends an item to `attribute_values`.
        ///
        /// To override the contents of this collection use [`set_attribute_values`](Self::set_attribute_values).
        ///
        /// <p>The value or values for the manual DB snapshot attribute.</p>
        /// <p>If the <code>AttributeName</code> field is set to <code>restore</code>, then this element returns a list of IDs of the Amazon Web Services accounts that are authorized to copy or restore the manual DB snapshot. If a value of <code>all</code> is in the list, then the manual DB snapshot is public and available for any Amazon Web Services account to copy or restore.</p>
        pub fn attribute_values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.attribute_values.unwrap_or_default();
            v.push(input.into());
            self.attribute_values = Some(v);
            self
        }
        /// <p>The value or values for the manual DB snapshot attribute.</p>
        /// <p>If the <code>AttributeName</code> field is set to <code>restore</code>, then this element returns a list of IDs of the Amazon Web Services accounts that are authorized to copy or restore the manual DB snapshot. If a value of <code>all</code> is in the list, then the manual DB snapshot is public and available for any Amazon Web Services account to copy or restore.</p>
        pub fn set_attribute_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.attribute_values = input;
            self
        }
        /// Consumes the builder and constructs a [`DbSnapshotAttribute`](crate::model::DbSnapshotAttribute)
        pub fn build(self) -> crate::model::DbSnapshotAttribute {
            crate::model::DbSnapshotAttribute {
                attribute_name: self.attribute_name,
                attribute_values: self.attribute_values,
            }
        }
    }
}
impl DbSnapshotAttribute {
    /// Creates a new builder-style object to manufacture [`DbSnapshotAttribute`](crate::model::DbSnapshotAttribute)
    pub fn builder() -> crate::model::db_snapshot_attribute::Builder {
        crate::model::db_snapshot_attribute::Builder::default()
    }
}

/// <p>Contains the details of an Amazon RDS DB snapshot. </p>
/// <p>This data type is used as a response element in the <code>DescribeDBSnapshots</code> action. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DbSnapshot {
    /// <p>Specifies the identifier for the DB snapshot.</p>
    pub db_snapshot_identifier: std::option::Option<std::string::String>,
    /// <p>Specifies the DB instance identifier of the DB instance this DB snapshot was created from.</p>
    pub db_instance_identifier: std::option::Option<std::string::String>,
    /// <p>Specifies when the snapshot was taken in Coordinated Universal Time (UTC). Changes for the copy when the snapshot is copied.</p>
    pub snapshot_create_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Specifies the name of the database engine.</p>
    pub engine: std::option::Option<std::string::String>,
    /// <p>Specifies the allocated storage size in gibibytes (GiB).</p>
    pub allocated_storage: i32,
    /// <p>Specifies the status of this DB snapshot.</p>
    pub status: std::option::Option<std::string::String>,
    /// <p>Specifies the port that the database engine was listening on at the time of the snapshot.</p>
    pub port: i32,
    /// <p>Specifies the name of the Availability Zone the DB instance was located in at the time of the DB snapshot.</p>
    pub availability_zone: std::option::Option<std::string::String>,
    /// <p>Provides the VPC ID associated with the DB snapshot.</p>
    pub vpc_id: std::option::Option<std::string::String>,
    /// <p>Specifies the time in Coordinated Universal Time (UTC) when the DB instance, from which the snapshot was taken, was created.</p>
    pub instance_create_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Provides the master username for the DB snapshot.</p>
    pub master_username: std::option::Option<std::string::String>,
    /// <p>Specifies the version of the database engine.</p>
    pub engine_version: std::option::Option<std::string::String>,
    /// <p>License model information for the restored DB instance.</p>
    pub license_model: std::option::Option<std::string::String>,
    /// <p>Provides the type of the DB snapshot.</p>
    pub snapshot_type: std::option::Option<std::string::String>,
    /// <p>Specifies the Provisioned IOPS (I/O operations per second) value of the DB instance at the time of the snapshot.</p>
    pub iops: std::option::Option<i32>,
    /// <p>Provides the option group name for the DB snapshot.</p>
    pub option_group_name: std::option::Option<std::string::String>,
    /// <p>The percentage of the estimated data that has been transferred.</p>
    pub percent_progress: i32,
    /// <p>The Amazon Web Services Region that the DB snapshot was created in or copied from.</p>
    pub source_region: std::option::Option<std::string::String>,
    /// <p>The DB snapshot Amazon Resource Name (ARN) that the DB snapshot was copied from. It only has a value in the case of a cross-account or cross-Region copy.</p>
    pub source_db_snapshot_identifier: std::option::Option<std::string::String>,
    /// <p>Specifies the storage type associated with DB snapshot.</p>
    pub storage_type: std::option::Option<std::string::String>,
    /// <p>The ARN from the key store with which to associate the instance for TDE encryption.</p>
    pub tde_credential_arn: std::option::Option<std::string::String>,
    /// <p>Specifies whether the DB snapshot is encrypted.</p>
    pub encrypted: bool,
    /// <p> If <code>Encrypted</code> is true, the Amazon Web Services KMS key identifier for the encrypted DB snapshot. </p>
    /// <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.</p>
    pub kms_key_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) for the DB snapshot.</p>
    pub db_snapshot_arn: std::option::Option<std::string::String>,
    /// <p>The time zone of the DB snapshot. In most cases, the <code>Timezone</code> element is empty. <code>Timezone</code> content appears only for snapshots taken from Microsoft SQL Server DB instances that were created with a time zone specified. </p>
    pub timezone: std::option::Option<std::string::String>,
    /// <p>True if mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts is enabled, and otherwise false.</p>
    pub iam_database_authentication_enabled: bool,
    /// <p>The number of CPU cores and the number of threads per core for the DB instance class of the DB instance when the DB snapshot was created.</p>
    pub processor_features: std::option::Option<std::vec::Vec<crate::model::ProcessorFeature>>,
    /// <p>The identifier for the source DB instance, which can't be changed and which is unique to an Amazon Web Services Region.</p>
    pub dbi_resource_id: std::option::Option<std::string::String>,
    /// <p>A list of tags. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources</a> in the <i>Amazon RDS User Guide.</i> </p>
    pub tag_list: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>Specifies the time of the CreateDBSnapshot operation in Coordinated Universal Time (UTC). Doesn't change when the snapshot is copied.</p>
    pub original_snapshot_create_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Specifies where manual snapshots are stored: Amazon Web Services Outposts or the Amazon Web Services Region.</p>
    pub snapshot_target: std::option::Option<std::string::String>,
}
impl DbSnapshot {
    /// <p>Specifies the identifier for the DB snapshot.</p>
    pub fn db_snapshot_identifier(&self) -> std::option::Option<&str> {
        self.db_snapshot_identifier.as_deref()
    }
    /// <p>Specifies the DB instance identifier of the DB instance this DB snapshot was created from.</p>
    pub fn db_instance_identifier(&self) -> std::option::Option<&str> {
        self.db_instance_identifier.as_deref()
    }
    /// <p>Specifies when the snapshot was taken in Coordinated Universal Time (UTC). Changes for the copy when the snapshot is copied.</p>
    pub fn snapshot_create_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.snapshot_create_time.as_ref()
    }
    /// <p>Specifies the name of the database engine.</p>
    pub fn engine(&self) -> std::option::Option<&str> {
        self.engine.as_deref()
    }
    /// <p>Specifies the allocated storage size in gibibytes (GiB).</p>
    pub fn allocated_storage(&self) -> i32 {
        self.allocated_storage
    }
    /// <p>Specifies the status of this DB snapshot.</p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>Specifies the port that the database engine was listening on at the time of the snapshot.</p>
    pub fn port(&self) -> i32 {
        self.port
    }
    /// <p>Specifies the name of the Availability Zone the DB instance was located in at the time of the DB snapshot.</p>
    pub fn availability_zone(&self) -> std::option::Option<&str> {
        self.availability_zone.as_deref()
    }
    /// <p>Provides the VPC ID associated with the DB snapshot.</p>
    pub fn vpc_id(&self) -> std::option::Option<&str> {
        self.vpc_id.as_deref()
    }
    /// <p>Specifies the time in Coordinated Universal Time (UTC) when the DB instance, from which the snapshot was taken, was created.</p>
    pub fn instance_create_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.instance_create_time.as_ref()
    }
    /// <p>Provides the master username for the DB snapshot.</p>
    pub fn master_username(&self) -> std::option::Option<&str> {
        self.master_username.as_deref()
    }
    /// <p>Specifies the version of the database engine.</p>
    pub fn engine_version(&self) -> std::option::Option<&str> {
        self.engine_version.as_deref()
    }
    /// <p>License model information for the restored DB instance.</p>
    pub fn license_model(&self) -> std::option::Option<&str> {
        self.license_model.as_deref()
    }
    /// <p>Provides the type of the DB snapshot.</p>
    pub fn snapshot_type(&self) -> std::option::Option<&str> {
        self.snapshot_type.as_deref()
    }
    /// <p>Specifies the Provisioned IOPS (I/O operations per second) value of the DB instance at the time of the snapshot.</p>
    pub fn iops(&self) -> std::option::Option<i32> {
        self.iops
    }
    /// <p>Provides the option group name for the DB snapshot.</p>
    pub fn option_group_name(&self) -> std::option::Option<&str> {
        self.option_group_name.as_deref()
    }
    /// <p>The percentage of the estimated data that has been transferred.</p>
    pub fn percent_progress(&self) -> i32 {
        self.percent_progress
    }
    /// <p>The Amazon Web Services Region that the DB snapshot was created in or copied from.</p>
    pub fn source_region(&self) -> std::option::Option<&str> {
        self.source_region.as_deref()
    }
    /// <p>The DB snapshot Amazon Resource Name (ARN) that the DB snapshot was copied from. It only has a value in the case of a cross-account or cross-Region copy.</p>
    pub fn source_db_snapshot_identifier(&self) -> std::option::Option<&str> {
        self.source_db_snapshot_identifier.as_deref()
    }
    /// <p>Specifies the storage type associated with DB snapshot.</p>
    pub fn storage_type(&self) -> std::option::Option<&str> {
        self.storage_type.as_deref()
    }
    /// <p>The ARN from the key store with which to associate the instance for TDE encryption.</p>
    pub fn tde_credential_arn(&self) -> std::option::Option<&str> {
        self.tde_credential_arn.as_deref()
    }
    /// <p>Specifies whether the DB snapshot is encrypted.</p>
    pub fn encrypted(&self) -> bool {
        self.encrypted
    }
    /// <p> If <code>Encrypted</code> is true, the Amazon Web Services KMS key identifier for the encrypted DB snapshot. </p>
    /// <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.</p>
    pub fn kms_key_id(&self) -> std::option::Option<&str> {
        self.kms_key_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) for the DB snapshot.</p>
    pub fn db_snapshot_arn(&self) -> std::option::Option<&str> {
        self.db_snapshot_arn.as_deref()
    }
    /// <p>The time zone of the DB snapshot. In most cases, the <code>Timezone</code> element is empty. <code>Timezone</code> content appears only for snapshots taken from Microsoft SQL Server DB instances that were created with a time zone specified. </p>
    pub fn timezone(&self) -> std::option::Option<&str> {
        self.timezone.as_deref()
    }
    /// <p>True if mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts is enabled, and otherwise false.</p>
    pub fn iam_database_authentication_enabled(&self) -> bool {
        self.iam_database_authentication_enabled
    }
    /// <p>The number of CPU cores and the number of threads per core for the DB instance class of the DB instance when the DB snapshot was created.</p>
    pub fn processor_features(&self) -> std::option::Option<&[crate::model::ProcessorFeature]> {
        self.processor_features.as_deref()
    }
    /// <p>The identifier for the source DB instance, which can't be changed and which is unique to an Amazon Web Services Region.</p>
    pub fn dbi_resource_id(&self) -> std::option::Option<&str> {
        self.dbi_resource_id.as_deref()
    }
    /// <p>A list of tags. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources</a> in the <i>Amazon RDS User Guide.</i> </p>
    pub fn tag_list(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tag_list.as_deref()
    }
    /// <p>Specifies the time of the CreateDBSnapshot operation in Coordinated Universal Time (UTC). Doesn't change when the snapshot is copied.</p>
    pub fn original_snapshot_create_time(
        &self,
    ) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.original_snapshot_create_time.as_ref()
    }
    /// <p>Specifies where manual snapshots are stored: Amazon Web Services Outposts or the Amazon Web Services Region.</p>
    pub fn snapshot_target(&self) -> std::option::Option<&str> {
        self.snapshot_target.as_deref()
    }
}
impl std::fmt::Debug for DbSnapshot {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DbSnapshot");
        formatter.field("db_snapshot_identifier", &self.db_snapshot_identifier);
        formatter.field("db_instance_identifier", &self.db_instance_identifier);
        formatter.field("snapshot_create_time", &self.snapshot_create_time);
        formatter.field("engine", &self.engine);
        formatter.field("allocated_storage", &self.allocated_storage);
        formatter.field("status", &self.status);
        formatter.field("port", &self.port);
        formatter.field("availability_zone", &self.availability_zone);
        formatter.field("vpc_id", &self.vpc_id);
        formatter.field("instance_create_time", &self.instance_create_time);
        formatter.field("master_username", &self.master_username);
        formatter.field("engine_version", &self.engine_version);
        formatter.field("license_model", &self.license_model);
        formatter.field("snapshot_type", &self.snapshot_type);
        formatter.field("iops", &self.iops);
        formatter.field("option_group_name", &self.option_group_name);
        formatter.field("percent_progress", &self.percent_progress);
        formatter.field("source_region", &self.source_region);
        formatter.field(
            "source_db_snapshot_identifier",
            &self.source_db_snapshot_identifier,
        );
        formatter.field("storage_type", &self.storage_type);
        formatter.field("tde_credential_arn", &self.tde_credential_arn);
        formatter.field("encrypted", &self.encrypted);
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.field("db_snapshot_arn", &self.db_snapshot_arn);
        formatter.field("timezone", &self.timezone);
        formatter.field(
            "iam_database_authentication_enabled",
            &self.iam_database_authentication_enabled,
        );
        formatter.field("processor_features", &self.processor_features);
        formatter.field("dbi_resource_id", &self.dbi_resource_id);
        formatter.field("tag_list", &self.tag_list);
        formatter.field(
            "original_snapshot_create_time",
            &self.original_snapshot_create_time,
        );
        formatter.field("snapshot_target", &self.snapshot_target);
        formatter.finish()
    }
}
/// See [`DbSnapshot`](crate::model::DbSnapshot)
pub mod db_snapshot {
    /// A builder for [`DbSnapshot`](crate::model::DbSnapshot)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_snapshot_identifier: std::option::Option<std::string::String>,
        pub(crate) db_instance_identifier: std::option::Option<std::string::String>,
        pub(crate) snapshot_create_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) engine: std::option::Option<std::string::String>,
        pub(crate) allocated_storage: std::option::Option<i32>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) port: std::option::Option<i32>,
        pub(crate) availability_zone: std::option::Option<std::string::String>,
        pub(crate) vpc_id: std::option::Option<std::string::String>,
        pub(crate) instance_create_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) master_username: std::option::Option<std::string::String>,
        pub(crate) engine_version: std::option::Option<std::string::String>,
        pub(crate) license_model: std::option::Option<std::string::String>,
        pub(crate) snapshot_type: std::option::Option<std::string::String>,
        pub(crate) iops: std::option::Option<i32>,
        pub(crate) option_group_name: std::option::Option<std::string::String>,
        pub(crate) percent_progress: std::option::Option<i32>,
        pub(crate) source_region: std::option::Option<std::string::String>,
        pub(crate) source_db_snapshot_identifier: std::option::Option<std::string::String>,
        pub(crate) storage_type: std::option::Option<std::string::String>,
        pub(crate) tde_credential_arn: std::option::Option<std::string::String>,
        pub(crate) encrypted: std::option::Option<bool>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
        pub(crate) db_snapshot_arn: std::option::Option<std::string::String>,
        pub(crate) timezone: std::option::Option<std::string::String>,
        pub(crate) iam_database_authentication_enabled: std::option::Option<bool>,
        pub(crate) processor_features:
            std::option::Option<std::vec::Vec<crate::model::ProcessorFeature>>,
        pub(crate) dbi_resource_id: std::option::Option<std::string::String>,
        pub(crate) tag_list: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) original_snapshot_create_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) snapshot_target: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Specifies the identifier for the DB snapshot.</p>
        pub fn db_snapshot_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_snapshot_identifier = Some(input.into());
            self
        }
        /// <p>Specifies the identifier for the DB snapshot.</p>
        pub fn set_db_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_snapshot_identifier = input;
            self
        }
        /// <p>Specifies the DB instance identifier of the DB instance this DB snapshot was created from.</p>
        pub fn db_instance_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_instance_identifier = Some(input.into());
            self
        }
        /// <p>Specifies the DB instance identifier of the DB instance this DB snapshot was created from.</p>
        pub fn set_db_instance_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_instance_identifier = input;
            self
        }
        /// <p>Specifies when the snapshot was taken in Coordinated Universal Time (UTC). Changes for the copy when the snapshot is copied.</p>
        pub fn snapshot_create_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.snapshot_create_time = Some(input);
            self
        }
        /// <p>Specifies when the snapshot was taken in Coordinated Universal Time (UTC). Changes for the copy when the snapshot is copied.</p>
        pub fn set_snapshot_create_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.snapshot_create_time = input;
            self
        }
        /// <p>Specifies the name of the database engine.</p>
        pub fn engine(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine = Some(input.into());
            self
        }
        /// <p>Specifies the name of the database engine.</p>
        pub fn set_engine(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.engine = input;
            self
        }
        /// <p>Specifies the allocated storage size in gibibytes (GiB).</p>
        pub fn allocated_storage(mut self, input: i32) -> Self {
            self.allocated_storage = Some(input);
            self
        }
        /// <p>Specifies the allocated storage size in gibibytes (GiB).</p>
        pub fn set_allocated_storage(mut self, input: std::option::Option<i32>) -> Self {
            self.allocated_storage = input;
            self
        }
        /// <p>Specifies the status of this DB snapshot.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>Specifies the status of this DB snapshot.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>Specifies the port that the database engine was listening on at the time of the snapshot.</p>
        pub fn port(mut self, input: i32) -> Self {
            self.port = Some(input);
            self
        }
        /// <p>Specifies the port that the database engine was listening on at the time of the snapshot.</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.port = input;
            self
        }
        /// <p>Specifies the name of the Availability Zone the DB instance was located in at the time of the DB snapshot.</p>
        pub fn availability_zone(mut self, input: impl Into<std::string::String>) -> Self {
            self.availability_zone = Some(input.into());
            self
        }
        /// <p>Specifies the name of the Availability Zone the DB instance was located in at the time of the DB snapshot.</p>
        pub fn set_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.availability_zone = input;
            self
        }
        /// <p>Provides the VPC ID associated with the DB snapshot.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_id = Some(input.into());
            self
        }
        /// <p>Provides the VPC ID associated with the DB snapshot.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_id = input;
            self
        }
        /// <p>Specifies the time in Coordinated Universal Time (UTC) when the DB instance, from which the snapshot was taken, was created.</p>
        pub fn instance_create_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.instance_create_time = Some(input);
            self
        }
        /// <p>Specifies the time in Coordinated Universal Time (UTC) when the DB instance, from which the snapshot was taken, was created.</p>
        pub fn set_instance_create_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.instance_create_time = input;
            self
        }
        /// <p>Provides the master username for the DB snapshot.</p>
        pub fn master_username(mut self, input: impl Into<std::string::String>) -> Self {
            self.master_username = Some(input.into());
            self
        }
        /// <p>Provides the master username for the DB snapshot.</p>
        pub fn set_master_username(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.master_username = input;
            self
        }
        /// <p>Specifies the version of the database engine.</p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_version = Some(input.into());
            self
        }
        /// <p>Specifies the version of the database engine.</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.engine_version = input;
            self
        }
        /// <p>License model information for the restored DB instance.</p>
        pub fn license_model(mut self, input: impl Into<std::string::String>) -> Self {
            self.license_model = Some(input.into());
            self
        }
        /// <p>License model information for the restored DB instance.</p>
        pub fn set_license_model(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.license_model = input;
            self
        }
        /// <p>Provides the type of the DB snapshot.</p>
        pub fn snapshot_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.snapshot_type = Some(input.into());
            self
        }
        /// <p>Provides the type of the DB snapshot.</p>
        pub fn set_snapshot_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.snapshot_type = input;
            self
        }
        /// <p>Specifies the Provisioned IOPS (I/O operations per second) value of the DB instance at the time of the snapshot.</p>
        pub fn iops(mut self, input: i32) -> Self {
            self.iops = Some(input);
            self
        }
        /// <p>Specifies the Provisioned IOPS (I/O operations per second) value of the DB instance at the time of the snapshot.</p>
        pub fn set_iops(mut self, input: std::option::Option<i32>) -> Self {
            self.iops = input;
            self
        }
        /// <p>Provides the option group name for the DB snapshot.</p>
        pub fn option_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.option_group_name = Some(input.into());
            self
        }
        /// <p>Provides the option group name for the DB snapshot.</p>
        pub fn set_option_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.option_group_name = input;
            self
        }
        /// <p>The percentage of the estimated data that has been transferred.</p>
        pub fn percent_progress(mut self, input: i32) -> Self {
            self.percent_progress = Some(input);
            self
        }
        /// <p>The percentage of the estimated data that has been transferred.</p>
        pub fn set_percent_progress(mut self, input: std::option::Option<i32>) -> Self {
            self.percent_progress = input;
            self
        }
        /// <p>The Amazon Web Services Region that the DB snapshot was created in or copied from.</p>
        pub fn source_region(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_region = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services Region that the DB snapshot was created in or copied from.</p>
        pub fn set_source_region(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_region = input;
            self
        }
        /// <p>The DB snapshot Amazon Resource Name (ARN) that the DB snapshot was copied from. It only has a value in the case of a cross-account or cross-Region copy.</p>
        pub fn source_db_snapshot_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.source_db_snapshot_identifier = Some(input.into());
            self
        }
        /// <p>The DB snapshot Amazon Resource Name (ARN) that the DB snapshot was copied from. It only has a value in the case of a cross-account or cross-Region copy.</p>
        pub fn set_source_db_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_db_snapshot_identifier = input;
            self
        }
        /// <p>Specifies the storage type associated with DB snapshot.</p>
        pub fn storage_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.storage_type = Some(input.into());
            self
        }
        /// <p>Specifies the storage type associated with DB snapshot.</p>
        pub fn set_storage_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.storage_type = input;
            self
        }
        /// <p>The ARN from the key store with which to associate the instance for TDE encryption.</p>
        pub fn tde_credential_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.tde_credential_arn = Some(input.into());
            self
        }
        /// <p>The ARN from the key store with which to associate the instance for TDE encryption.</p>
        pub fn set_tde_credential_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.tde_credential_arn = input;
            self
        }
        /// <p>Specifies whether the DB snapshot is encrypted.</p>
        pub fn encrypted(mut self, input: bool) -> Self {
            self.encrypted = Some(input);
            self
        }
        /// <p>Specifies whether the DB snapshot is encrypted.</p>
        pub fn set_encrypted(mut self, input: std::option::Option<bool>) -> Self {
            self.encrypted = input;
            self
        }
        /// <p> If <code>Encrypted</code> is true, the Amazon Web Services KMS key identifier for the encrypted DB snapshot. </p>
        /// <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p> If <code>Encrypted</code> is true, the Amazon Web Services KMS key identifier for the encrypted DB snapshot. </p>
        /// <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the DB snapshot.</p>
        pub fn db_snapshot_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_snapshot_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the DB snapshot.</p>
        pub fn set_db_snapshot_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_snapshot_arn = input;
            self
        }
        /// <p>The time zone of the DB snapshot. In most cases, the <code>Timezone</code> element is empty. <code>Timezone</code> content appears only for snapshots taken from Microsoft SQL Server DB instances that were created with a time zone specified. </p>
        pub fn timezone(mut self, input: impl Into<std::string::String>) -> Self {
            self.timezone = Some(input.into());
            self
        }
        /// <p>The time zone of the DB snapshot. In most cases, the <code>Timezone</code> element is empty. <code>Timezone</code> content appears only for snapshots taken from Microsoft SQL Server DB instances that were created with a time zone specified. </p>
        pub fn set_timezone(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.timezone = input;
            self
        }
        /// <p>True if mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts is enabled, and otherwise false.</p>
        pub fn iam_database_authentication_enabled(mut self, input: bool) -> Self {
            self.iam_database_authentication_enabled = Some(input);
            self
        }
        /// <p>True if mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts is enabled, and otherwise false.</p>
        pub fn set_iam_database_authentication_enabled(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.iam_database_authentication_enabled = input;
            self
        }
        /// Appends an item to `processor_features`.
        ///
        /// To override the contents of this collection use [`set_processor_features`](Self::set_processor_features).
        ///
        /// <p>The number of CPU cores and the number of threads per core for the DB instance class of the DB instance when the DB snapshot was created.</p>
        pub fn processor_features(mut self, input: crate::model::ProcessorFeature) -> Self {
            let mut v = self.processor_features.unwrap_or_default();
            v.push(input);
            self.processor_features = Some(v);
            self
        }
        /// <p>The number of CPU cores and the number of threads per core for the DB instance class of the DB instance when the DB snapshot was created.</p>
        pub fn set_processor_features(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ProcessorFeature>>,
        ) -> Self {
            self.processor_features = input;
            self
        }
        /// <p>The identifier for the source DB instance, which can't be changed and which is unique to an Amazon Web Services Region.</p>
        pub fn dbi_resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.dbi_resource_id = Some(input.into());
            self
        }
        /// <p>The identifier for the source DB instance, which can't be changed and which is unique to an Amazon Web Services Region.</p>
        pub fn set_dbi_resource_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dbi_resource_id = input;
            self
        }
        /// Appends an item to `tag_list`.
        ///
        /// To override the contents of this collection use [`set_tag_list`](Self::set_tag_list).
        ///
        /// <p>A list of tags. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources</a> in the <i>Amazon RDS User Guide.</i> </p>
        pub fn tag_list(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tag_list.unwrap_or_default();
            v.push(input);
            self.tag_list = Some(v);
            self
        }
        /// <p>A list of tags. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources</a> in the <i>Amazon RDS User Guide.</i> </p>
        pub fn set_tag_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tag_list = input;
            self
        }
        /// <p>Specifies the time of the CreateDBSnapshot operation in Coordinated Universal Time (UTC). Doesn't change when the snapshot is copied.</p>
        pub fn original_snapshot_create_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.original_snapshot_create_time = Some(input);
            self
        }
        /// <p>Specifies the time of the CreateDBSnapshot operation in Coordinated Universal Time (UTC). Doesn't change when the snapshot is copied.</p>
        pub fn set_original_snapshot_create_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.original_snapshot_create_time = input;
            self
        }
        /// <p>Specifies where manual snapshots are stored: Amazon Web Services Outposts or the Amazon Web Services Region.</p>
        pub fn snapshot_target(mut self, input: impl Into<std::string::String>) -> Self {
            self.snapshot_target = Some(input.into());
            self
        }
        /// <p>Specifies where manual snapshots are stored: Amazon Web Services Outposts or the Amazon Web Services Region.</p>
        pub fn set_snapshot_target(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.snapshot_target = input;
            self
        }
        /// Consumes the builder and constructs a [`DbSnapshot`](crate::model::DbSnapshot)
        pub fn build(self) -> crate::model::DbSnapshot {
            crate::model::DbSnapshot {
                db_snapshot_identifier: self.db_snapshot_identifier,
                db_instance_identifier: self.db_instance_identifier,
                snapshot_create_time: self.snapshot_create_time,
                engine: self.engine,
                allocated_storage: self.allocated_storage.unwrap_or_default(),
                status: self.status,
                port: self.port.unwrap_or_default(),
                availability_zone: self.availability_zone,
                vpc_id: self.vpc_id,
                instance_create_time: self.instance_create_time,
                master_username: self.master_username,
                engine_version: self.engine_version,
                license_model: self.license_model,
                snapshot_type: self.snapshot_type,
                iops: self.iops,
                option_group_name: self.option_group_name,
                percent_progress: self.percent_progress.unwrap_or_default(),
                source_region: self.source_region,
                source_db_snapshot_identifier: self.source_db_snapshot_identifier,
                storage_type: self.storage_type,
                tde_credential_arn: self.tde_credential_arn,
                encrypted: self.encrypted.unwrap_or_default(),
                kms_key_id: self.kms_key_id,
                db_snapshot_arn: self.db_snapshot_arn,
                timezone: self.timezone,
                iam_database_authentication_enabled: self
                    .iam_database_authentication_enabled
                    .unwrap_or_default(),
                processor_features: self.processor_features,
                dbi_resource_id: self.dbi_resource_id,
                tag_list: self.tag_list,
                original_snapshot_create_time: self.original_snapshot_create_time,
                snapshot_target: self.snapshot_target,
            }
        }
    }
}
impl DbSnapshot {
    /// Creates a new builder-style object to manufacture [`DbSnapshot`](crate::model::DbSnapshot)
    pub fn builder() -> crate::model::db_snapshot::Builder {
        crate::model::db_snapshot::Builder::default()
    }
}

/// <p>Represents a set of RDS DB instances, Aurora DB clusters, or both that a proxy can connect to. Currently, each target group is associated with exactly one RDS DB instance or Aurora DB cluster.</p>
/// <p>This data type is used as a response element in the <code>DescribeDBProxyTargetGroups</code> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DbProxyTargetGroup {
    /// <p>The identifier for the RDS proxy associated with this target group.</p>
    pub db_proxy_name: std::option::Option<std::string::String>,
    /// <p>The identifier for the target group. This name must be unique for all target groups owned by your Amazon Web Services account in the specified Amazon Web Services Region.</p>
    pub target_group_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) representing the target group.</p>
    pub target_group_arn: std::option::Option<std::string::String>,
    /// <p>Whether this target group is the first one used for connection requests by the associated proxy. Because each proxy is currently associated with a single target group, currently this setting is always <code>true</code>.</p>
    pub is_default: bool,
    /// <p>The current status of this target group. A status of <code>available</code> means the target group is correctly associated with a database. Other values indicate that you must wait for the target group to be ready, or take some action to resolve an issue.</p>
    pub status: std::option::Option<std::string::String>,
    /// <p>The settings that determine the size and behavior of the connection pool for the target group.</p>
    pub connection_pool_config: std::option::Option<crate::model::ConnectionPoolConfigurationInfo>,
    /// <p>The date and time when the target group was first created.</p>
    pub created_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time when the target group was last updated.</p>
    pub updated_date: std::option::Option<aws_smithy_types::DateTime>,
}
impl DbProxyTargetGroup {
    /// <p>The identifier for the RDS proxy associated with this target group.</p>
    pub fn db_proxy_name(&self) -> std::option::Option<&str> {
        self.db_proxy_name.as_deref()
    }
    /// <p>The identifier for the target group. This name must be unique for all target groups owned by your Amazon Web Services account in the specified Amazon Web Services Region.</p>
    pub fn target_group_name(&self) -> std::option::Option<&str> {
        self.target_group_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) representing the target group.</p>
    pub fn target_group_arn(&self) -> std::option::Option<&str> {
        self.target_group_arn.as_deref()
    }
    /// <p>Whether this target group is the first one used for connection requests by the associated proxy. Because each proxy is currently associated with a single target group, currently this setting is always <code>true</code>.</p>
    pub fn is_default(&self) -> bool {
        self.is_default
    }
    /// <p>The current status of this target group. A status of <code>available</code> means the target group is correctly associated with a database. Other values indicate that you must wait for the target group to be ready, or take some action to resolve an issue.</p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>The settings that determine the size and behavior of the connection pool for the target group.</p>
    pub fn connection_pool_config(
        &self,
    ) -> std::option::Option<&crate::model::ConnectionPoolConfigurationInfo> {
        self.connection_pool_config.as_ref()
    }
    /// <p>The date and time when the target group was first created.</p>
    pub fn created_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_date.as_ref()
    }
    /// <p>The date and time when the target group was last updated.</p>
    pub fn updated_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.updated_date.as_ref()
    }
}
impl std::fmt::Debug for DbProxyTargetGroup {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DbProxyTargetGroup");
        formatter.field("db_proxy_name", &self.db_proxy_name);
        formatter.field("target_group_name", &self.target_group_name);
        formatter.field("target_group_arn", &self.target_group_arn);
        formatter.field("is_default", &self.is_default);
        formatter.field("status", &self.status);
        formatter.field("connection_pool_config", &self.connection_pool_config);
        formatter.field("created_date", &self.created_date);
        formatter.field("updated_date", &self.updated_date);
        formatter.finish()
    }
}
/// See [`DbProxyTargetGroup`](crate::model::DbProxyTargetGroup)
pub mod db_proxy_target_group {
    /// A builder for [`DbProxyTargetGroup`](crate::model::DbProxyTargetGroup)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_proxy_name: std::option::Option<std::string::String>,
        pub(crate) target_group_name: std::option::Option<std::string::String>,
        pub(crate) target_group_arn: std::option::Option<std::string::String>,
        pub(crate) is_default: std::option::Option<bool>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) connection_pool_config:
            std::option::Option<crate::model::ConnectionPoolConfigurationInfo>,
        pub(crate) created_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) updated_date: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The identifier for the RDS proxy associated with this target group.</p>
        pub fn db_proxy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_proxy_name = Some(input.into());
            self
        }
        /// <p>The identifier for the RDS proxy associated with this target group.</p>
        pub fn set_db_proxy_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_proxy_name = input;
            self
        }
        /// <p>The identifier for the target group. This name must be unique for all target groups owned by your Amazon Web Services account in the specified Amazon Web Services Region.</p>
        pub fn target_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_group_name = Some(input.into());
            self
        }
        /// <p>The identifier for the target group. This name must be unique for all target groups owned by your Amazon Web Services account in the specified Amazon Web Services Region.</p>
        pub fn set_target_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_group_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) representing the target group.</p>
        pub fn target_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_group_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) representing the target group.</p>
        pub fn set_target_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_group_arn = input;
            self
        }
        /// <p>Whether this target group is the first one used for connection requests by the associated proxy. Because each proxy is currently associated with a single target group, currently this setting is always <code>true</code>.</p>
        pub fn is_default(mut self, input: bool) -> Self {
            self.is_default = Some(input);
            self
        }
        /// <p>Whether this target group is the first one used for connection requests by the associated proxy. Because each proxy is currently associated with a single target group, currently this setting is always <code>true</code>.</p>
        pub fn set_is_default(mut self, input: std::option::Option<bool>) -> Self {
            self.is_default = input;
            self
        }
        /// <p>The current status of this target group. A status of <code>available</code> means the target group is correctly associated with a database. Other values indicate that you must wait for the target group to be ready, or take some action to resolve an issue.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The current status of this target group. A status of <code>available</code> means the target group is correctly associated with a database. Other values indicate that you must wait for the target group to be ready, or take some action to resolve an issue.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>The settings that determine the size and behavior of the connection pool for the target group.</p>
        pub fn connection_pool_config(
            mut self,
            input: crate::model::ConnectionPoolConfigurationInfo,
        ) -> Self {
            self.connection_pool_config = Some(input);
            self
        }
        /// <p>The settings that determine the size and behavior of the connection pool for the target group.</p>
        pub fn set_connection_pool_config(
            mut self,
            input: std::option::Option<crate::model::ConnectionPoolConfigurationInfo>,
        ) -> Self {
            self.connection_pool_config = input;
            self
        }
        /// <p>The date and time when the target group was first created.</p>
        pub fn created_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_date = Some(input);
            self
        }
        /// <p>The date and time when the target group was first created.</p>
        pub fn set_created_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_date = input;
            self
        }
        /// <p>The date and time when the target group was last updated.</p>
        pub fn updated_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.updated_date = Some(input);
            self
        }
        /// <p>The date and time when the target group was last updated.</p>
        pub fn set_updated_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.updated_date = input;
            self
        }
        /// Consumes the builder and constructs a [`DbProxyTargetGroup`](crate::model::DbProxyTargetGroup)
        pub fn build(self) -> crate::model::DbProxyTargetGroup {
            crate::model::DbProxyTargetGroup {
                db_proxy_name: self.db_proxy_name,
                target_group_name: self.target_group_name,
                target_group_arn: self.target_group_arn,
                is_default: self.is_default.unwrap_or_default(),
                status: self.status,
                connection_pool_config: self.connection_pool_config,
                created_date: self.created_date,
                updated_date: self.updated_date,
            }
        }
    }
}
impl DbProxyTargetGroup {
    /// Creates a new builder-style object to manufacture [`DbProxyTargetGroup`](crate::model::DbProxyTargetGroup)
    pub fn builder() -> crate::model::db_proxy_target_group::Builder {
        crate::model::db_proxy_target_group::Builder::default()
    }
}

/// <p>Displays the settings that control the size and behavior of the connection pool associated with a <code>DBProxyTarget</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConnectionPoolConfigurationInfo {
    /// <p>The maximum size of the connection pool for each target in a target group. The value is expressed as a percentage of the <code>max_connections</code> setting for the RDS DB instance or Aurora DB cluster used by the target group.</p>
    pub max_connections_percent: i32,
    /// <p> Controls how actively the proxy closes idle database connections in the connection pool. The value is expressed as a percentage of the <code>max_connections</code> setting for the RDS DB instance or Aurora DB cluster used by the target group. With a high value, the proxy leaves a high percentage of idle database connections open. A low value causes the proxy to close more idle connections and return them to the database. </p>
    pub max_idle_connections_percent: i32,
    /// <p>The number of seconds for a proxy to wait for a connection to become available in the connection pool. Only applies when the proxy has opened its maximum number of connections and all connections are busy with client sessions.</p>
    pub connection_borrow_timeout: i32,
    /// <p>Each item in the list represents a class of SQL operations that normally cause all later statements in a session using a proxy to be pinned to the same underlying database connection. Including an item in the list exempts that class of SQL operations from the pinning behavior. Currently, the only allowed value is <code>EXCLUDE_VARIABLE_SETS</code>.</p>
    pub session_pinning_filters: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p> One or more SQL statements for the proxy to run when opening each new database connection. Typically used with <code>SET</code> statements to make sure that each connection has identical settings such as time zone and character set. This setting is empty by default. For multiple statements, use semicolons as the separator. You can also include multiple variables in a single <code>SET</code> statement, such as <code>SET x=1, y=2</code>. </p>
    pub init_query: std::option::Option<std::string::String>,
}
impl ConnectionPoolConfigurationInfo {
    /// <p>The maximum size of the connection pool for each target in a target group. The value is expressed as a percentage of the <code>max_connections</code> setting for the RDS DB instance or Aurora DB cluster used by the target group.</p>
    pub fn max_connections_percent(&self) -> i32 {
        self.max_connections_percent
    }
    /// <p> Controls how actively the proxy closes idle database connections in the connection pool. The value is expressed as a percentage of the <code>max_connections</code> setting for the RDS DB instance or Aurora DB cluster used by the target group. With a high value, the proxy leaves a high percentage of idle database connections open. A low value causes the proxy to close more idle connections and return them to the database. </p>
    pub fn max_idle_connections_percent(&self) -> i32 {
        self.max_idle_connections_percent
    }
    /// <p>The number of seconds for a proxy to wait for a connection to become available in the connection pool. Only applies when the proxy has opened its maximum number of connections and all connections are busy with client sessions.</p>
    pub fn connection_borrow_timeout(&self) -> i32 {
        self.connection_borrow_timeout
    }
    /// <p>Each item in the list represents a class of SQL operations that normally cause all later statements in a session using a proxy to be pinned to the same underlying database connection. Including an item in the list exempts that class of SQL operations from the pinning behavior. Currently, the only allowed value is <code>EXCLUDE_VARIABLE_SETS</code>.</p>
    pub fn session_pinning_filters(&self) -> std::option::Option<&[std::string::String]> {
        self.session_pinning_filters.as_deref()
    }
    /// <p> One or more SQL statements for the proxy to run when opening each new database connection. Typically used with <code>SET</code> statements to make sure that each connection has identical settings such as time zone and character set. This setting is empty by default. For multiple statements, use semicolons as the separator. You can also include multiple variables in a single <code>SET</code> statement, such as <code>SET x=1, y=2</code>. </p>
    pub fn init_query(&self) -> std::option::Option<&str> {
        self.init_query.as_deref()
    }
}
impl std::fmt::Debug for ConnectionPoolConfigurationInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConnectionPoolConfigurationInfo");
        formatter.field("max_connections_percent", &self.max_connections_percent);
        formatter.field(
            "max_idle_connections_percent",
            &self.max_idle_connections_percent,
        );
        formatter.field("connection_borrow_timeout", &self.connection_borrow_timeout);
        formatter.field("session_pinning_filters", &self.session_pinning_filters);
        formatter.field("init_query", &self.init_query);
        formatter.finish()
    }
}
/// See [`ConnectionPoolConfigurationInfo`](crate::model::ConnectionPoolConfigurationInfo)
pub mod connection_pool_configuration_info {
    /// A builder for [`ConnectionPoolConfigurationInfo`](crate::model::ConnectionPoolConfigurationInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_connections_percent: std::option::Option<i32>,
        pub(crate) max_idle_connections_percent: std::option::Option<i32>,
        pub(crate) connection_borrow_timeout: std::option::Option<i32>,
        pub(crate) session_pinning_filters: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) init_query: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The maximum size of the connection pool for each target in a target group. The value is expressed as a percentage of the <code>max_connections</code> setting for the RDS DB instance or Aurora DB cluster used by the target group.</p>
        pub fn max_connections_percent(mut self, input: i32) -> Self {
            self.max_connections_percent = Some(input);
            self
        }
        /// <p>The maximum size of the connection pool for each target in a target group. The value is expressed as a percentage of the <code>max_connections</code> setting for the RDS DB instance or Aurora DB cluster used by the target group.</p>
        pub fn set_max_connections_percent(mut self, input: std::option::Option<i32>) -> Self {
            self.max_connections_percent = input;
            self
        }
        /// <p> Controls how actively the proxy closes idle database connections in the connection pool. The value is expressed as a percentage of the <code>max_connections</code> setting for the RDS DB instance or Aurora DB cluster used by the target group. With a high value, the proxy leaves a high percentage of idle database connections open. A low value causes the proxy to close more idle connections and return them to the database. </p>
        pub fn max_idle_connections_percent(mut self, input: i32) -> Self {
            self.max_idle_connections_percent = Some(input);
            self
        }
        /// <p> Controls how actively the proxy closes idle database connections in the connection pool. The value is expressed as a percentage of the <code>max_connections</code> setting for the RDS DB instance or Aurora DB cluster used by the target group. With a high value, the proxy leaves a high percentage of idle database connections open. A low value causes the proxy to close more idle connections and return them to the database. </p>
        pub fn set_max_idle_connections_percent(mut self, input: std::option::Option<i32>) -> Self {
            self.max_idle_connections_percent = input;
            self
        }
        /// <p>The number of seconds for a proxy to wait for a connection to become available in the connection pool. Only applies when the proxy has opened its maximum number of connections and all connections are busy with client sessions.</p>
        pub fn connection_borrow_timeout(mut self, input: i32) -> Self {
            self.connection_borrow_timeout = Some(input);
            self
        }
        /// <p>The number of seconds for a proxy to wait for a connection to become available in the connection pool. Only applies when the proxy has opened its maximum number of connections and all connections are busy with client sessions.</p>
        pub fn set_connection_borrow_timeout(mut self, input: std::option::Option<i32>) -> Self {
            self.connection_borrow_timeout = input;
            self
        }
        /// Appends an item to `session_pinning_filters`.
        ///
        /// To override the contents of this collection use [`set_session_pinning_filters`](Self::set_session_pinning_filters).
        ///
        /// <p>Each item in the list represents a class of SQL operations that normally cause all later statements in a session using a proxy to be pinned to the same underlying database connection. Including an item in the list exempts that class of SQL operations from the pinning behavior. Currently, the only allowed value is <code>EXCLUDE_VARIABLE_SETS</code>.</p>
        pub fn session_pinning_filters(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.session_pinning_filters.unwrap_or_default();
            v.push(input.into());
            self.session_pinning_filters = Some(v);
            self
        }
        /// <p>Each item in the list represents a class of SQL operations that normally cause all later statements in a session using a proxy to be pinned to the same underlying database connection. Including an item in the list exempts that class of SQL operations from the pinning behavior. Currently, the only allowed value is <code>EXCLUDE_VARIABLE_SETS</code>.</p>
        pub fn set_session_pinning_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.session_pinning_filters = input;
            self
        }
        /// <p> One or more SQL statements for the proxy to run when opening each new database connection. Typically used with <code>SET</code> statements to make sure that each connection has identical settings such as time zone and character set. This setting is empty by default. For multiple statements, use semicolons as the separator. You can also include multiple variables in a single <code>SET</code> statement, such as <code>SET x=1, y=2</code>. </p>
        pub fn init_query(mut self, input: impl Into<std::string::String>) -> Self {
            self.init_query = Some(input.into());
            self
        }
        /// <p> One or more SQL statements for the proxy to run when opening each new database connection. Typically used with <code>SET</code> statements to make sure that each connection has identical settings such as time zone and character set. This setting is empty by default. For multiple statements, use semicolons as the separator. You can also include multiple variables in a single <code>SET</code> statement, such as <code>SET x=1, y=2</code>. </p>
        pub fn set_init_query(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.init_query = input;
            self
        }
        /// Consumes the builder and constructs a [`ConnectionPoolConfigurationInfo`](crate::model::ConnectionPoolConfigurationInfo)
        pub fn build(self) -> crate::model::ConnectionPoolConfigurationInfo {
            crate::model::ConnectionPoolConfigurationInfo {
                max_connections_percent: self.max_connections_percent.unwrap_or_default(),
                max_idle_connections_percent: self.max_idle_connections_percent.unwrap_or_default(),
                connection_borrow_timeout: self.connection_borrow_timeout.unwrap_or_default(),
                session_pinning_filters: self.session_pinning_filters,
                init_query: self.init_query,
            }
        }
    }
}
impl ConnectionPoolConfigurationInfo {
    /// Creates a new builder-style object to manufacture [`ConnectionPoolConfigurationInfo`](crate::model::ConnectionPoolConfigurationInfo)
    pub fn builder() -> crate::model::connection_pool_configuration_info::Builder {
        crate::model::connection_pool_configuration_info::Builder::default()
    }
}

/// <p>Specifies the settings that control the size and behavior of the connection pool associated with a <code>DBProxyTargetGroup</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConnectionPoolConfiguration {
    /// <p>The maximum size of the connection pool for each target in a target group. The value is expressed as a percentage of the <code>max_connections</code> setting for the RDS DB instance or Aurora DB cluster used by the target group.</p>
    /// <p>Default: 100</p>
    /// <p>Constraints: between 1 and 100</p>
    pub max_connections_percent: std::option::Option<i32>,
    /// <p> Controls how actively the proxy closes idle database connections in the connection pool. The value is expressed as a percentage of the <code>max_connections</code> setting for the RDS DB instance or Aurora DB cluster used by the target group. With a high value, the proxy leaves a high percentage of idle database connections open. A low value causes the proxy to close more idle connections and return them to the database. </p>
    /// <p>Default: 50</p>
    /// <p>Constraints: between 0 and <code>MaxConnectionsPercent</code> </p>
    pub max_idle_connections_percent: std::option::Option<i32>,
    /// <p>The number of seconds for a proxy to wait for a connection to become available in the connection pool. Only applies when the proxy has opened its maximum number of connections and all connections are busy with client sessions.</p>
    /// <p>Default: 120</p>
    /// <p>Constraints: between 1 and 3600, or 0 representing unlimited</p>
    pub connection_borrow_timeout: std::option::Option<i32>,
    /// <p>Each item in the list represents a class of SQL operations that normally cause all later statements in a session using a proxy to be pinned to the same underlying database connection. Including an item in the list exempts that class of SQL operations from the pinning behavior.</p>
    /// <p>Default: no session pinning filters</p>
    pub session_pinning_filters: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p> One or more SQL statements for the proxy to run when opening each new database connection. Typically used with <code>SET</code> statements to make sure that each connection has identical settings such as time zone and character set. For multiple statements, use semicolons as the separator. You can also include multiple variables in a single <code>SET</code> statement, such as <code>SET x=1, y=2</code>. </p>
    /// <p>Default: no initialization query</p>
    pub init_query: std::option::Option<std::string::String>,
}
impl ConnectionPoolConfiguration {
    /// <p>The maximum size of the connection pool for each target in a target group. The value is expressed as a percentage of the <code>max_connections</code> setting for the RDS DB instance or Aurora DB cluster used by the target group.</p>
    /// <p>Default: 100</p>
    /// <p>Constraints: between 1 and 100</p>
    pub fn max_connections_percent(&self) -> std::option::Option<i32> {
        self.max_connections_percent
    }
    /// <p> Controls how actively the proxy closes idle database connections in the connection pool. The value is expressed as a percentage of the <code>max_connections</code> setting for the RDS DB instance or Aurora DB cluster used by the target group. With a high value, the proxy leaves a high percentage of idle database connections open. A low value causes the proxy to close more idle connections and return them to the database. </p>
    /// <p>Default: 50</p>
    /// <p>Constraints: between 0 and <code>MaxConnectionsPercent</code> </p>
    pub fn max_idle_connections_percent(&self) -> std::option::Option<i32> {
        self.max_idle_connections_percent
    }
    /// <p>The number of seconds for a proxy to wait for a connection to become available in the connection pool. Only applies when the proxy has opened its maximum number of connections and all connections are busy with client sessions.</p>
    /// <p>Default: 120</p>
    /// <p>Constraints: between 1 and 3600, or 0 representing unlimited</p>
    pub fn connection_borrow_timeout(&self) -> std::option::Option<i32> {
        self.connection_borrow_timeout
    }
    /// <p>Each item in the list represents a class of SQL operations that normally cause all later statements in a session using a proxy to be pinned to the same underlying database connection. Including an item in the list exempts that class of SQL operations from the pinning behavior.</p>
    /// <p>Default: no session pinning filters</p>
    pub fn session_pinning_filters(&self) -> std::option::Option<&[std::string::String]> {
        self.session_pinning_filters.as_deref()
    }
    /// <p> One or more SQL statements for the proxy to run when opening each new database connection. Typically used with <code>SET</code> statements to make sure that each connection has identical settings such as time zone and character set. For multiple statements, use semicolons as the separator. You can also include multiple variables in a single <code>SET</code> statement, such as <code>SET x=1, y=2</code>. </p>
    /// <p>Default: no initialization query</p>
    pub fn init_query(&self) -> std::option::Option<&str> {
        self.init_query.as_deref()
    }
}
impl std::fmt::Debug for ConnectionPoolConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConnectionPoolConfiguration");
        formatter.field("max_connections_percent", &self.max_connections_percent);
        formatter.field(
            "max_idle_connections_percent",
            &self.max_idle_connections_percent,
        );
        formatter.field("connection_borrow_timeout", &self.connection_borrow_timeout);
        formatter.field("session_pinning_filters", &self.session_pinning_filters);
        formatter.field("init_query", &self.init_query);
        formatter.finish()
    }
}
/// See [`ConnectionPoolConfiguration`](crate::model::ConnectionPoolConfiguration)
pub mod connection_pool_configuration {
    /// A builder for [`ConnectionPoolConfiguration`](crate::model::ConnectionPoolConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_connections_percent: std::option::Option<i32>,
        pub(crate) max_idle_connections_percent: std::option::Option<i32>,
        pub(crate) connection_borrow_timeout: std::option::Option<i32>,
        pub(crate) session_pinning_filters: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) init_query: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The maximum size of the connection pool for each target in a target group. The value is expressed as a percentage of the <code>max_connections</code> setting for the RDS DB instance or Aurora DB cluster used by the target group.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: between 1 and 100</p>
        pub fn max_connections_percent(mut self, input: i32) -> Self {
            self.max_connections_percent = Some(input);
            self
        }
        /// <p>The maximum size of the connection pool for each target in a target group. The value is expressed as a percentage of the <code>max_connections</code> setting for the RDS DB instance or Aurora DB cluster used by the target group.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: between 1 and 100</p>
        pub fn set_max_connections_percent(mut self, input: std::option::Option<i32>) -> Self {
            self.max_connections_percent = input;
            self
        }
        /// <p> Controls how actively the proxy closes idle database connections in the connection pool. The value is expressed as a percentage of the <code>max_connections</code> setting for the RDS DB instance or Aurora DB cluster used by the target group. With a high value, the proxy leaves a high percentage of idle database connections open. A low value causes the proxy to close more idle connections and return them to the database. </p>
        /// <p>Default: 50</p>
        /// <p>Constraints: between 0 and <code>MaxConnectionsPercent</code> </p>
        pub fn max_idle_connections_percent(mut self, input: i32) -> Self {
            self.max_idle_connections_percent = Some(input);
            self
        }
        /// <p> Controls how actively the proxy closes idle database connections in the connection pool. The value is expressed as a percentage of the <code>max_connections</code> setting for the RDS DB instance or Aurora DB cluster used by the target group. With a high value, the proxy leaves a high percentage of idle database connections open. A low value causes the proxy to close more idle connections and return them to the database. </p>
        /// <p>Default: 50</p>
        /// <p>Constraints: between 0 and <code>MaxConnectionsPercent</code> </p>
        pub fn set_max_idle_connections_percent(mut self, input: std::option::Option<i32>) -> Self {
            self.max_idle_connections_percent = input;
            self
        }
        /// <p>The number of seconds for a proxy to wait for a connection to become available in the connection pool. Only applies when the proxy has opened its maximum number of connections and all connections are busy with client sessions.</p>
        /// <p>Default: 120</p>
        /// <p>Constraints: between 1 and 3600, or 0 representing unlimited</p>
        pub fn connection_borrow_timeout(mut self, input: i32) -> Self {
            self.connection_borrow_timeout = Some(input);
            self
        }
        /// <p>The number of seconds for a proxy to wait for a connection to become available in the connection pool. Only applies when the proxy has opened its maximum number of connections and all connections are busy with client sessions.</p>
        /// <p>Default: 120</p>
        /// <p>Constraints: between 1 and 3600, or 0 representing unlimited</p>
        pub fn set_connection_borrow_timeout(mut self, input: std::option::Option<i32>) -> Self {
            self.connection_borrow_timeout = input;
            self
        }
        /// Appends an item to `session_pinning_filters`.
        ///
        /// To override the contents of this collection use [`set_session_pinning_filters`](Self::set_session_pinning_filters).
        ///
        /// <p>Each item in the list represents a class of SQL operations that normally cause all later statements in a session using a proxy to be pinned to the same underlying database connection. Including an item in the list exempts that class of SQL operations from the pinning behavior.</p>
        /// <p>Default: no session pinning filters</p>
        pub fn session_pinning_filters(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.session_pinning_filters.unwrap_or_default();
            v.push(input.into());
            self.session_pinning_filters = Some(v);
            self
        }
        /// <p>Each item in the list represents a class of SQL operations that normally cause all later statements in a session using a proxy to be pinned to the same underlying database connection. Including an item in the list exempts that class of SQL operations from the pinning behavior.</p>
        /// <p>Default: no session pinning filters</p>
        pub fn set_session_pinning_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.session_pinning_filters = input;
            self
        }
        /// <p> One or more SQL statements for the proxy to run when opening each new database connection. Typically used with <code>SET</code> statements to make sure that each connection has identical settings such as time zone and character set. For multiple statements, use semicolons as the separator. You can also include multiple variables in a single <code>SET</code> statement, such as <code>SET x=1, y=2</code>. </p>
        /// <p>Default: no initialization query</p>
        pub fn init_query(mut self, input: impl Into<std::string::String>) -> Self {
            self.init_query = Some(input.into());
            self
        }
        /// <p> One or more SQL statements for the proxy to run when opening each new database connection. Typically used with <code>SET</code> statements to make sure that each connection has identical settings such as time zone and character set. For multiple statements, use semicolons as the separator. You can also include multiple variables in a single <code>SET</code> statement, such as <code>SET x=1, y=2</code>. </p>
        /// <p>Default: no initialization query</p>
        pub fn set_init_query(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.init_query = input;
            self
        }
        /// Consumes the builder and constructs a [`ConnectionPoolConfiguration`](crate::model::ConnectionPoolConfiguration)
        pub fn build(self) -> crate::model::ConnectionPoolConfiguration {
            crate::model::ConnectionPoolConfiguration {
                max_connections_percent: self.max_connections_percent,
                max_idle_connections_percent: self.max_idle_connections_percent,
                connection_borrow_timeout: self.connection_borrow_timeout,
                session_pinning_filters: self.session_pinning_filters,
                init_query: self.init_query,
            }
        }
    }
}
impl ConnectionPoolConfiguration {
    /// Creates a new builder-style object to manufacture [`ConnectionPoolConfiguration`](crate::model::ConnectionPoolConfiguration)
    pub fn builder() -> crate::model::connection_pool_configuration::Builder {
        crate::model::connection_pool_configuration::Builder::default()
    }
}

/// <p>The data structure representing an endpoint associated with a DB proxy. RDS automatically creates one endpoint for each DB proxy. For Aurora DB clusters, you can associate additional endpoints with the same DB proxy. These endpoints can be read/write or read-only. They can also reside in different VPCs than the associated DB proxy.</p>
/// <p>This data type is used as a response element in the <code>DescribeDBProxyEndpoints</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DbProxyEndpoint {
    /// <p>The name for the DB proxy endpoint. An identifier must begin with a letter and must contain only ASCII letters, digits, and hyphens; it can't end with a hyphen or contain two consecutive hyphens.</p>
    pub db_proxy_endpoint_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) for the DB proxy endpoint.</p>
    pub db_proxy_endpoint_arn: std::option::Option<std::string::String>,
    /// <p>The identifier for the DB proxy that is associated with this DB proxy endpoint.</p>
    pub db_proxy_name: std::option::Option<std::string::String>,
    /// <p>The current status of this DB proxy endpoint. A status of <code>available</code> means the endpoint is ready to handle requests. Other values indicate that you must wait for the endpoint to be ready, or take some action to resolve an issue.</p>
    pub status: std::option::Option<crate::model::DbProxyEndpointStatus>,
    /// <p>Provides the VPC ID of the DB proxy endpoint.</p>
    pub vpc_id: std::option::Option<std::string::String>,
    /// <p>Provides a list of VPC security groups that the DB proxy endpoint belongs to.</p>
    pub vpc_security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The EC2 subnet IDs for the DB proxy endpoint.</p>
    pub vpc_subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The endpoint that you can use to connect to the DB proxy. You include the endpoint value in the connection string for a database client application.</p>
    pub endpoint: std::option::Option<std::string::String>,
    /// <p>The date and time when the DB proxy endpoint was first created.</p>
    pub created_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>A value that indicates whether the DB proxy endpoint can be used for read/write or read-only operations.</p>
    pub target_role: std::option::Option<crate::model::DbProxyEndpointTargetRole>,
    /// <p>A value that indicates whether this endpoint is the default endpoint for the associated DB proxy. Default DB proxy endpoints always have read/write capability. Other endpoints that you associate with the DB proxy can be either read/write or read-only.</p>
    pub is_default: bool,
}
impl DbProxyEndpoint {
    /// <p>The name for the DB proxy endpoint. An identifier must begin with a letter and must contain only ASCII letters, digits, and hyphens; it can't end with a hyphen or contain two consecutive hyphens.</p>
    pub fn db_proxy_endpoint_name(&self) -> std::option::Option<&str> {
        self.db_proxy_endpoint_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) for the DB proxy endpoint.</p>
    pub fn db_proxy_endpoint_arn(&self) -> std::option::Option<&str> {
        self.db_proxy_endpoint_arn.as_deref()
    }
    /// <p>The identifier for the DB proxy that is associated with this DB proxy endpoint.</p>
    pub fn db_proxy_name(&self) -> std::option::Option<&str> {
        self.db_proxy_name.as_deref()
    }
    /// <p>The current status of this DB proxy endpoint. A status of <code>available</code> means the endpoint is ready to handle requests. Other values indicate that you must wait for the endpoint to be ready, or take some action to resolve an issue.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::DbProxyEndpointStatus> {
        self.status.as_ref()
    }
    /// <p>Provides the VPC ID of the DB proxy endpoint.</p>
    pub fn vpc_id(&self) -> std::option::Option<&str> {
        self.vpc_id.as_deref()
    }
    /// <p>Provides a list of VPC security groups that the DB proxy endpoint belongs to.</p>
    pub fn vpc_security_group_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.vpc_security_group_ids.as_deref()
    }
    /// <p>The EC2 subnet IDs for the DB proxy endpoint.</p>
    pub fn vpc_subnet_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.vpc_subnet_ids.as_deref()
    }
    /// <p>The endpoint that you can use to connect to the DB proxy. You include the endpoint value in the connection string for a database client application.</p>
    pub fn endpoint(&self) -> std::option::Option<&str> {
        self.endpoint.as_deref()
    }
    /// <p>The date and time when the DB proxy endpoint was first created.</p>
    pub fn created_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_date.as_ref()
    }
    /// <p>A value that indicates whether the DB proxy endpoint can be used for read/write or read-only operations.</p>
    pub fn target_role(&self) -> std::option::Option<&crate::model::DbProxyEndpointTargetRole> {
        self.target_role.as_ref()
    }
    /// <p>A value that indicates whether this endpoint is the default endpoint for the associated DB proxy. Default DB proxy endpoints always have read/write capability. Other endpoints that you associate with the DB proxy can be either read/write or read-only.</p>
    pub fn is_default(&self) -> bool {
        self.is_default
    }
}
impl std::fmt::Debug for DbProxyEndpoint {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DbProxyEndpoint");
        formatter.field("db_proxy_endpoint_name", &self.db_proxy_endpoint_name);
        formatter.field("db_proxy_endpoint_arn", &self.db_proxy_endpoint_arn);
        formatter.field("db_proxy_name", &self.db_proxy_name);
        formatter.field("status", &self.status);
        formatter.field("vpc_id", &self.vpc_id);
        formatter.field("vpc_security_group_ids", &self.vpc_security_group_ids);
        formatter.field("vpc_subnet_ids", &self.vpc_subnet_ids);
        formatter.field("endpoint", &self.endpoint);
        formatter.field("created_date", &self.created_date);
        formatter.field("target_role", &self.target_role);
        formatter.field("is_default", &self.is_default);
        formatter.finish()
    }
}
/// See [`DbProxyEndpoint`](crate::model::DbProxyEndpoint)
pub mod db_proxy_endpoint {
    /// A builder for [`DbProxyEndpoint`](crate::model::DbProxyEndpoint)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_proxy_endpoint_name: std::option::Option<std::string::String>,
        pub(crate) db_proxy_endpoint_arn: std::option::Option<std::string::String>,
        pub(crate) db_proxy_name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::DbProxyEndpointStatus>,
        pub(crate) vpc_id: std::option::Option<std::string::String>,
        pub(crate) vpc_security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) vpc_subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) endpoint: std::option::Option<std::string::String>,
        pub(crate) created_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) target_role: std::option::Option<crate::model::DbProxyEndpointTargetRole>,
        pub(crate) is_default: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name for the DB proxy endpoint. An identifier must begin with a letter and must contain only ASCII letters, digits, and hyphens; it can't end with a hyphen or contain two consecutive hyphens.</p>
        pub fn db_proxy_endpoint_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_proxy_endpoint_name = Some(input.into());
            self
        }
        /// <p>The name for the DB proxy endpoint. An identifier must begin with a letter and must contain only ASCII letters, digits, and hyphens; it can't end with a hyphen or contain two consecutive hyphens.</p>
        pub fn set_db_proxy_endpoint_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_proxy_endpoint_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the DB proxy endpoint.</p>
        pub fn db_proxy_endpoint_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_proxy_endpoint_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the DB proxy endpoint.</p>
        pub fn set_db_proxy_endpoint_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_proxy_endpoint_arn = input;
            self
        }
        /// <p>The identifier for the DB proxy that is associated with this DB proxy endpoint.</p>
        pub fn db_proxy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_proxy_name = Some(input.into());
            self
        }
        /// <p>The identifier for the DB proxy that is associated with this DB proxy endpoint.</p>
        pub fn set_db_proxy_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_proxy_name = input;
            self
        }
        /// <p>The current status of this DB proxy endpoint. A status of <code>available</code> means the endpoint is ready to handle requests. Other values indicate that you must wait for the endpoint to be ready, or take some action to resolve an issue.</p>
        pub fn status(mut self, input: crate::model::DbProxyEndpointStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current status of this DB proxy endpoint. A status of <code>available</code> means the endpoint is ready to handle requests. Other values indicate that you must wait for the endpoint to be ready, or take some action to resolve an issue.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::DbProxyEndpointStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>Provides the VPC ID of the DB proxy endpoint.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_id = Some(input.into());
            self
        }
        /// <p>Provides the VPC ID of the DB proxy endpoint.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_id = input;
            self
        }
        /// Appends an item to `vpc_security_group_ids`.
        ///
        /// To override the contents of this collection use [`set_vpc_security_group_ids`](Self::set_vpc_security_group_ids).
        ///
        /// <p>Provides a list of VPC security groups that the DB proxy endpoint belongs to.</p>
        pub fn vpc_security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.vpc_security_group_ids.unwrap_or_default();
            v.push(input.into());
            self.vpc_security_group_ids = Some(v);
            self
        }
        /// <p>Provides a list of VPC security groups that the DB proxy endpoint belongs to.</p>
        pub fn set_vpc_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.vpc_security_group_ids = input;
            self
        }
        /// Appends an item to `vpc_subnet_ids`.
        ///
        /// To override the contents of this collection use [`set_vpc_subnet_ids`](Self::set_vpc_subnet_ids).
        ///
        /// <p>The EC2 subnet IDs for the DB proxy endpoint.</p>
        pub fn vpc_subnet_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.vpc_subnet_ids.unwrap_or_default();
            v.push(input.into());
            self.vpc_subnet_ids = Some(v);
            self
        }
        /// <p>The EC2 subnet IDs for the DB proxy endpoint.</p>
        pub fn set_vpc_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.vpc_subnet_ids = input;
            self
        }
        /// <p>The endpoint that you can use to connect to the DB proxy. You include the endpoint value in the connection string for a database client application.</p>
        pub fn endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint = Some(input.into());
            self
        }
        /// <p>The endpoint that you can use to connect to the DB proxy. You include the endpoint value in the connection string for a database client application.</p>
        pub fn set_endpoint(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.endpoint = input;
            self
        }
        /// <p>The date and time when the DB proxy endpoint was first created.</p>
        pub fn created_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_date = Some(input);
            self
        }
        /// <p>The date and time when the DB proxy endpoint was first created.</p>
        pub fn set_created_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_date = input;
            self
        }
        /// <p>A value that indicates whether the DB proxy endpoint can be used for read/write or read-only operations.</p>
        pub fn target_role(mut self, input: crate::model::DbProxyEndpointTargetRole) -> Self {
            self.target_role = Some(input);
            self
        }
        /// <p>A value that indicates whether the DB proxy endpoint can be used for read/write or read-only operations.</p>
        pub fn set_target_role(
            mut self,
            input: std::option::Option<crate::model::DbProxyEndpointTargetRole>,
        ) -> Self {
            self.target_role = input;
            self
        }
        /// <p>A value that indicates whether this endpoint is the default endpoint for the associated DB proxy. Default DB proxy endpoints always have read/write capability. Other endpoints that you associate with the DB proxy can be either read/write or read-only.</p>
        pub fn is_default(mut self, input: bool) -> Self {
            self.is_default = Some(input);
            self
        }
        /// <p>A value that indicates whether this endpoint is the default endpoint for the associated DB proxy. Default DB proxy endpoints always have read/write capability. Other endpoints that you associate with the DB proxy can be either read/write or read-only.</p>
        pub fn set_is_default(mut self, input: std::option::Option<bool>) -> Self {
            self.is_default = input;
            self
        }
        /// Consumes the builder and constructs a [`DbProxyEndpoint`](crate::model::DbProxyEndpoint)
        pub fn build(self) -> crate::model::DbProxyEndpoint {
            crate::model::DbProxyEndpoint {
                db_proxy_endpoint_name: self.db_proxy_endpoint_name,
                db_proxy_endpoint_arn: self.db_proxy_endpoint_arn,
                db_proxy_name: self.db_proxy_name,
                status: self.status,
                vpc_id: self.vpc_id,
                vpc_security_group_ids: self.vpc_security_group_ids,
                vpc_subnet_ids: self.vpc_subnet_ids,
                endpoint: self.endpoint,
                created_date: self.created_date,
                target_role: self.target_role,
                is_default: self.is_default.unwrap_or_default(),
            }
        }
    }
}
impl DbProxyEndpoint {
    /// Creates a new builder-style object to manufacture [`DbProxyEndpoint`](crate::model::DbProxyEndpoint)
    pub fn builder() -> crate::model::db_proxy_endpoint::Builder {
        crate::model::db_proxy_endpoint::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DbProxyEndpointTargetRole {
    #[allow(missing_docs)] // documentation missing in model
    ReadOnly,
    #[allow(missing_docs)] // documentation missing in model
    ReadWrite,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DbProxyEndpointTargetRole {
    fn from(s: &str) -> Self {
        match s {
            "READ_ONLY" => DbProxyEndpointTargetRole::ReadOnly,
            "READ_WRITE" => DbProxyEndpointTargetRole::ReadWrite,
            other => DbProxyEndpointTargetRole::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DbProxyEndpointTargetRole {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DbProxyEndpointTargetRole::from(s))
    }
}
impl DbProxyEndpointTargetRole {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DbProxyEndpointTargetRole::ReadOnly => "READ_ONLY",
            DbProxyEndpointTargetRole::ReadWrite => "READ_WRITE",
            DbProxyEndpointTargetRole::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["READ_ONLY", "READ_WRITE"]
    }
}
impl AsRef<str> for DbProxyEndpointTargetRole {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DbProxyEndpointStatus {
    #[allow(missing_docs)] // documentation missing in model
    Available,
    #[allow(missing_docs)] // documentation missing in model
    Creating,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    IncompatibleNetwork,
    #[allow(missing_docs)] // documentation missing in model
    InsufficientResourceLimits,
    #[allow(missing_docs)] // documentation missing in model
    Modifying,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DbProxyEndpointStatus {
    fn from(s: &str) -> Self {
        match s {
            "available" => DbProxyEndpointStatus::Available,
            "creating" => DbProxyEndpointStatus::Creating,
            "deleting" => DbProxyEndpointStatus::Deleting,
            "incompatible-network" => DbProxyEndpointStatus::IncompatibleNetwork,
            "insufficient-resource-limits" => DbProxyEndpointStatus::InsufficientResourceLimits,
            "modifying" => DbProxyEndpointStatus::Modifying,
            other => DbProxyEndpointStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DbProxyEndpointStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DbProxyEndpointStatus::from(s))
    }
}
impl DbProxyEndpointStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DbProxyEndpointStatus::Available => "available",
            DbProxyEndpointStatus::Creating => "creating",
            DbProxyEndpointStatus::Deleting => "deleting",
            DbProxyEndpointStatus::IncompatibleNetwork => "incompatible-network",
            DbProxyEndpointStatus::InsufficientResourceLimits => "insufficient-resource-limits",
            DbProxyEndpointStatus::Modifying => "modifying",
            DbProxyEndpointStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "available",
            "creating",
            "deleting",
            "incompatible-network",
            "insufficient-resource-limits",
            "modifying",
        ]
    }
}
impl AsRef<str> for DbProxyEndpointStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The data structure representing a proxy managed by the RDS Proxy.</p>
/// <p>This data type is used as a response element in the <code>DescribeDBProxies</code> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DbProxy {
    /// <p>The identifier for the proxy. This name must be unique for all proxies owned by your Amazon Web Services account in the specified Amazon Web Services Region.</p>
    pub db_proxy_name: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) for the proxy.</p>
    pub db_proxy_arn: std::option::Option<std::string::String>,
    /// <p>The current status of this proxy. A status of <code>available</code> means the proxy is ready to handle requests. Other values indicate that you must wait for the proxy to be ready, or take some action to resolve an issue.</p>
    pub status: std::option::Option<crate::model::DbProxyStatus>,
    /// <p>The engine family applies to MySQL and PostgreSQL for both RDS and Aurora.</p>
    pub engine_family: std::option::Option<std::string::String>,
    /// <p>Provides the VPC ID of the DB proxy.</p>
    pub vpc_id: std::option::Option<std::string::String>,
    /// <p>Provides a list of VPC security groups that the proxy belongs to.</p>
    pub vpc_security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The EC2 subnet IDs for the proxy.</p>
    pub vpc_subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>One or more data structures specifying the authorization mechanism to connect to the associated RDS DB instance or Aurora DB cluster.</p>
    pub auth: std::option::Option<std::vec::Vec<crate::model::UserAuthConfigInfo>>,
    /// <p>The Amazon Resource Name (ARN) for the IAM role that the proxy uses to access Amazon Secrets Manager.</p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The endpoint that you can use to connect to the DB proxy. You include the endpoint value in the connection string for a database client application.</p>
    pub endpoint: std::option::Option<std::string::String>,
    /// <p>Indicates whether Transport Layer Security (TLS) encryption is required for connections to the proxy.</p>
    pub require_tls: bool,
    /// <p>The number of seconds a connection to the proxy can have no activity before the proxy drops the client connection. The proxy keeps the underlying database connection open and puts it back into the connection pool for reuse by later connection requests.</p>
    /// <p>Default: 1800 (30 minutes)</p>
    /// <p>Constraints: 1 to 28,800</p>
    pub idle_client_timeout: i32,
    /// <p>Whether the proxy includes detailed information about SQL statements in its logs. This information helps you to debug issues involving SQL behavior or the performance and scalability of the proxy connections. The debug information includes the text of SQL statements that you submit through the proxy. Thus, only enable this setting when needed for debugging, and only when you have security measures in place to safeguard any sensitive information that appears in the logs.</p>
    pub debug_logging: bool,
    /// <p>The date and time when the proxy was first created.</p>
    pub created_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date and time when the proxy was last updated.</p>
    pub updated_date: std::option::Option<aws_smithy_types::DateTime>,
}
impl DbProxy {
    /// <p>The identifier for the proxy. This name must be unique for all proxies owned by your Amazon Web Services account in the specified Amazon Web Services Region.</p>
    pub fn db_proxy_name(&self) -> std::option::Option<&str> {
        self.db_proxy_name.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) for the proxy.</p>
    pub fn db_proxy_arn(&self) -> std::option::Option<&str> {
        self.db_proxy_arn.as_deref()
    }
    /// <p>The current status of this proxy. A status of <code>available</code> means the proxy is ready to handle requests. Other values indicate that you must wait for the proxy to be ready, or take some action to resolve an issue.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::DbProxyStatus> {
        self.status.as_ref()
    }
    /// <p>The engine family applies to MySQL and PostgreSQL for both RDS and Aurora.</p>
    pub fn engine_family(&self) -> std::option::Option<&str> {
        self.engine_family.as_deref()
    }
    /// <p>Provides the VPC ID of the DB proxy.</p>
    pub fn vpc_id(&self) -> std::option::Option<&str> {
        self.vpc_id.as_deref()
    }
    /// <p>Provides a list of VPC security groups that the proxy belongs to.</p>
    pub fn vpc_security_group_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.vpc_security_group_ids.as_deref()
    }
    /// <p>The EC2 subnet IDs for the proxy.</p>
    pub fn vpc_subnet_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.vpc_subnet_ids.as_deref()
    }
    /// <p>One or more data structures specifying the authorization mechanism to connect to the associated RDS DB instance or Aurora DB cluster.</p>
    pub fn auth(&self) -> std::option::Option<&[crate::model::UserAuthConfigInfo]> {
        self.auth.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) for the IAM role that the proxy uses to access Amazon Secrets Manager.</p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>The endpoint that you can use to connect to the DB proxy. You include the endpoint value in the connection string for a database client application.</p>
    pub fn endpoint(&self) -> std::option::Option<&str> {
        self.endpoint.as_deref()
    }
    /// <p>Indicates whether Transport Layer Security (TLS) encryption is required for connections to the proxy.</p>
    pub fn require_tls(&self) -> bool {
        self.require_tls
    }
    /// <p>The number of seconds a connection to the proxy can have no activity before the proxy drops the client connection. The proxy keeps the underlying database connection open and puts it back into the connection pool for reuse by later connection requests.</p>
    /// <p>Default: 1800 (30 minutes)</p>
    /// <p>Constraints: 1 to 28,800</p>
    pub fn idle_client_timeout(&self) -> i32 {
        self.idle_client_timeout
    }
    /// <p>Whether the proxy includes detailed information about SQL statements in its logs. This information helps you to debug issues involving SQL behavior or the performance and scalability of the proxy connections. The debug information includes the text of SQL statements that you submit through the proxy. Thus, only enable this setting when needed for debugging, and only when you have security measures in place to safeguard any sensitive information that appears in the logs.</p>
    pub fn debug_logging(&self) -> bool {
        self.debug_logging
    }
    /// <p>The date and time when the proxy was first created.</p>
    pub fn created_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_date.as_ref()
    }
    /// <p>The date and time when the proxy was last updated.</p>
    pub fn updated_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.updated_date.as_ref()
    }
}
impl std::fmt::Debug for DbProxy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DbProxy");
        formatter.field("db_proxy_name", &self.db_proxy_name);
        formatter.field("db_proxy_arn", &self.db_proxy_arn);
        formatter.field("status", &self.status);
        formatter.field("engine_family", &self.engine_family);
        formatter.field("vpc_id", &self.vpc_id);
        formatter.field("vpc_security_group_ids", &self.vpc_security_group_ids);
        formatter.field("vpc_subnet_ids", &self.vpc_subnet_ids);
        formatter.field("auth", &self.auth);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("endpoint", &self.endpoint);
        formatter.field("require_tls", &self.require_tls);
        formatter.field("idle_client_timeout", &self.idle_client_timeout);
        formatter.field("debug_logging", &self.debug_logging);
        formatter.field("created_date", &self.created_date);
        formatter.field("updated_date", &self.updated_date);
        formatter.finish()
    }
}
/// See [`DbProxy`](crate::model::DbProxy)
pub mod db_proxy {
    /// A builder for [`DbProxy`](crate::model::DbProxy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_proxy_name: std::option::Option<std::string::String>,
        pub(crate) db_proxy_arn: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::DbProxyStatus>,
        pub(crate) engine_family: std::option::Option<std::string::String>,
        pub(crate) vpc_id: std::option::Option<std::string::String>,
        pub(crate) vpc_security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) vpc_subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) auth: std::option::Option<std::vec::Vec<crate::model::UserAuthConfigInfo>>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) endpoint: std::option::Option<std::string::String>,
        pub(crate) require_tls: std::option::Option<bool>,
        pub(crate) idle_client_timeout: std::option::Option<i32>,
        pub(crate) debug_logging: std::option::Option<bool>,
        pub(crate) created_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) updated_date: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The identifier for the proxy. This name must be unique for all proxies owned by your Amazon Web Services account in the specified Amazon Web Services Region.</p>
        pub fn db_proxy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_proxy_name = Some(input.into());
            self
        }
        /// <p>The identifier for the proxy. This name must be unique for all proxies owned by your Amazon Web Services account in the specified Amazon Web Services Region.</p>
        pub fn set_db_proxy_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_proxy_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the proxy.</p>
        pub fn db_proxy_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_proxy_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the proxy.</p>
        pub fn set_db_proxy_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.db_proxy_arn = input;
            self
        }
        /// <p>The current status of this proxy. A status of <code>available</code> means the proxy is ready to handle requests. Other values indicate that you must wait for the proxy to be ready, or take some action to resolve an issue.</p>
        pub fn status(mut self, input: crate::model::DbProxyStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current status of this proxy. A status of <code>available</code> means the proxy is ready to handle requests. Other values indicate that you must wait for the proxy to be ready, or take some action to resolve an issue.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::DbProxyStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The engine family applies to MySQL and PostgreSQL for both RDS and Aurora.</p>
        pub fn engine_family(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_family = Some(input.into());
            self
        }
        /// <p>The engine family applies to MySQL and PostgreSQL for both RDS and Aurora.</p>
        pub fn set_engine_family(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.engine_family = input;
            self
        }
        /// <p>Provides the VPC ID of the DB proxy.</p>
        pub fn vpc_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_id = Some(input.into());
            self
        }
        /// <p>Provides the VPC ID of the DB proxy.</p>
        pub fn set_vpc_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.vpc_id = input;
            self
        }
        /// Appends an item to `vpc_security_group_ids`.
        ///
        /// To override the contents of this collection use [`set_vpc_security_group_ids`](Self::set_vpc_security_group_ids).
        ///
        /// <p>Provides a list of VPC security groups that the proxy belongs to.</p>
        pub fn vpc_security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.vpc_security_group_ids.unwrap_or_default();
            v.push(input.into());
            self.vpc_security_group_ids = Some(v);
            self
        }
        /// <p>Provides a list of VPC security groups that the proxy belongs to.</p>
        pub fn set_vpc_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.vpc_security_group_ids = input;
            self
        }
        /// Appends an item to `vpc_subnet_ids`.
        ///
        /// To override the contents of this collection use [`set_vpc_subnet_ids`](Self::set_vpc_subnet_ids).
        ///
        /// <p>The EC2 subnet IDs for the proxy.</p>
        pub fn vpc_subnet_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.vpc_subnet_ids.unwrap_or_default();
            v.push(input.into());
            self.vpc_subnet_ids = Some(v);
            self
        }
        /// <p>The EC2 subnet IDs for the proxy.</p>
        pub fn set_vpc_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.vpc_subnet_ids = input;
            self
        }
        /// Appends an item to `auth`.
        ///
        /// To override the contents of this collection use [`set_auth`](Self::set_auth).
        ///
        /// <p>One or more data structures specifying the authorization mechanism to connect to the associated RDS DB instance or Aurora DB cluster.</p>
        pub fn auth(mut self, input: crate::model::UserAuthConfigInfo) -> Self {
            let mut v = self.auth.unwrap_or_default();
            v.push(input);
            self.auth = Some(v);
            self
        }
        /// <p>One or more data structures specifying the authorization mechanism to connect to the associated RDS DB instance or Aurora DB cluster.</p>
        pub fn set_auth(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UserAuthConfigInfo>>,
        ) -> Self {
            self.auth = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the IAM role that the proxy uses to access Amazon Secrets Manager.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the IAM role that the proxy uses to access Amazon Secrets Manager.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The endpoint that you can use to connect to the DB proxy. You include the endpoint value in the connection string for a database client application.</p>
        pub fn endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint = Some(input.into());
            self
        }
        /// <p>The endpoint that you can use to connect to the DB proxy. You include the endpoint value in the connection string for a database client application.</p>
        pub fn set_endpoint(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.endpoint = input;
            self
        }
        /// <p>Indicates whether Transport Layer Security (TLS) encryption is required for connections to the proxy.</p>
        pub fn require_tls(mut self, input: bool) -> Self {
            self.require_tls = Some(input);
            self
        }
        /// <p>Indicates whether Transport Layer Security (TLS) encryption is required for connections to the proxy.</p>
        pub fn set_require_tls(mut self, input: std::option::Option<bool>) -> Self {
            self.require_tls = input;
            self
        }
        /// <p>The number of seconds a connection to the proxy can have no activity before the proxy drops the client connection. The proxy keeps the underlying database connection open and puts it back into the connection pool for reuse by later connection requests.</p>
        /// <p>Default: 1800 (30 minutes)</p>
        /// <p>Constraints: 1 to 28,800</p>
        pub fn idle_client_timeout(mut self, input: i32) -> Self {
            self.idle_client_timeout = Some(input);
            self
        }
        /// <p>The number of seconds a connection to the proxy can have no activity before the proxy drops the client connection. The proxy keeps the underlying database connection open and puts it back into the connection pool for reuse by later connection requests.</p>
        /// <p>Default: 1800 (30 minutes)</p>
        /// <p>Constraints: 1 to 28,800</p>
        pub fn set_idle_client_timeout(mut self, input: std::option::Option<i32>) -> Self {
            self.idle_client_timeout = input;
            self
        }
        /// <p>Whether the proxy includes detailed information about SQL statements in its logs. This information helps you to debug issues involving SQL behavior or the performance and scalability of the proxy connections. The debug information includes the text of SQL statements that you submit through the proxy. Thus, only enable this setting when needed for debugging, and only when you have security measures in place to safeguard any sensitive information that appears in the logs.</p>
        pub fn debug_logging(mut self, input: bool) -> Self {
            self.debug_logging = Some(input);
            self
        }
        /// <p>Whether the proxy includes detailed information about SQL statements in its logs. This information helps you to debug issues involving SQL behavior or the performance and scalability of the proxy connections. The debug information includes the text of SQL statements that you submit through the proxy. Thus, only enable this setting when needed for debugging, and only when you have security measures in place to safeguard any sensitive information that appears in the logs.</p>
        pub fn set_debug_logging(mut self, input: std::option::Option<bool>) -> Self {
            self.debug_logging = input;
            self
        }
        /// <p>The date and time when the proxy was first created.</p>
        pub fn created_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_date = Some(input);
            self
        }
        /// <p>The date and time when the proxy was first created.</p>
        pub fn set_created_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_date = input;
            self
        }
        /// <p>The date and time when the proxy was last updated.</p>
        pub fn updated_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.updated_date = Some(input);
            self
        }
        /// <p>The date and time when the proxy was last updated.</p>
        pub fn set_updated_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.updated_date = input;
            self
        }
        /// Consumes the builder and constructs a [`DbProxy`](crate::model::DbProxy)
        pub fn build(self) -> crate::model::DbProxy {
            crate::model::DbProxy {
                db_proxy_name: self.db_proxy_name,
                db_proxy_arn: self.db_proxy_arn,
                status: self.status,
                engine_family: self.engine_family,
                vpc_id: self.vpc_id,
                vpc_security_group_ids: self.vpc_security_group_ids,
                vpc_subnet_ids: self.vpc_subnet_ids,
                auth: self.auth,
                role_arn: self.role_arn,
                endpoint: self.endpoint,
                require_tls: self.require_tls.unwrap_or_default(),
                idle_client_timeout: self.idle_client_timeout.unwrap_or_default(),
                debug_logging: self.debug_logging.unwrap_or_default(),
                created_date: self.created_date,
                updated_date: self.updated_date,
            }
        }
    }
}
impl DbProxy {
    /// Creates a new builder-style object to manufacture [`DbProxy`](crate::model::DbProxy)
    pub fn builder() -> crate::model::db_proxy::Builder {
        crate::model::db_proxy::Builder::default()
    }
}

/// <p>Returns the details of authentication used by a proxy to log in as a specific database user.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UserAuthConfigInfo {
    /// <p>A user-specified description about the authentication used by a proxy to log in as a specific database user.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The name of the database user to which the proxy connects.</p>
    pub user_name: std::option::Option<std::string::String>,
    /// <p>The type of authentication that the proxy uses for connections from the proxy to the underlying database.</p>
    pub auth_scheme: std::option::Option<crate::model::AuthScheme>,
    /// <p>The Amazon Resource Name (ARN) representing the secret that the proxy uses to authenticate to the RDS DB instance or Aurora DB cluster. These secrets are stored within Amazon Secrets Manager.</p>
    pub secret_arn: std::option::Option<std::string::String>,
    /// <p>Whether to require or disallow Amazon Web Services Identity and Access Management (IAM) authentication for connections to the proxy.</p>
    pub iam_auth: std::option::Option<crate::model::IamAuthMode>,
}
impl UserAuthConfigInfo {
    /// <p>A user-specified description about the authentication used by a proxy to log in as a specific database user.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The name of the database user to which the proxy connects.</p>
    pub fn user_name(&self) -> std::option::Option<&str> {
        self.user_name.as_deref()
    }
    /// <p>The type of authentication that the proxy uses for connections from the proxy to the underlying database.</p>
    pub fn auth_scheme(&self) -> std::option::Option<&crate::model::AuthScheme> {
        self.auth_scheme.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) representing the secret that the proxy uses to authenticate to the RDS DB instance or Aurora DB cluster. These secrets are stored within Amazon Secrets Manager.</p>
    pub fn secret_arn(&self) -> std::option::Option<&str> {
        self.secret_arn.as_deref()
    }
    /// <p>Whether to require or disallow Amazon Web Services Identity and Access Management (IAM) authentication for connections to the proxy.</p>
    pub fn iam_auth(&self) -> std::option::Option<&crate::model::IamAuthMode> {
        self.iam_auth.as_ref()
    }
}
impl std::fmt::Debug for UserAuthConfigInfo {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UserAuthConfigInfo");
        formatter.field("description", &self.description);
        formatter.field("user_name", &self.user_name);
        formatter.field("auth_scheme", &self.auth_scheme);
        formatter.field("secret_arn", &self.secret_arn);
        formatter.field("iam_auth", &self.iam_auth);
        formatter.finish()
    }
}
/// See [`UserAuthConfigInfo`](crate::model::UserAuthConfigInfo)
pub mod user_auth_config_info {
    /// A builder for [`UserAuthConfigInfo`](crate::model::UserAuthConfigInfo)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) user_name: std::option::Option<std::string::String>,
        pub(crate) auth_scheme: std::option::Option<crate::model::AuthScheme>,
        pub(crate) secret_arn: std::option::Option<std::string::String>,
        pub(crate) iam_auth: std::option::Option<crate::model::IamAuthMode>,
    }
    impl Builder {
        /// <p>A user-specified description about the authentication used by a proxy to log in as a specific database user.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A user-specified description about the authentication used by a proxy to log in as a specific database user.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The name of the database user to which the proxy connects.</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_name = Some(input.into());
            self
        }
        /// <p>The name of the database user to which the proxy connects.</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_name = input;
            self
        }
        /// <p>The type of authentication that the proxy uses for connections from the proxy to the underlying database.</p>
        pub fn auth_scheme(mut self, input: crate::model::AuthScheme) -> Self {
            self.auth_scheme = Some(input);
            self
        }
        /// <p>The type of authentication that the proxy uses for connections from the proxy to the underlying database.</p>
        pub fn set_auth_scheme(
            mut self,
            input: std::option::Option<crate::model::AuthScheme>,
        ) -> Self {
            self.auth_scheme = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) representing the secret that the proxy uses to authenticate to the RDS DB instance or Aurora DB cluster. These secrets are stored within Amazon Secrets Manager.</p>
        pub fn secret_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.secret_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) representing the secret that the proxy uses to authenticate to the RDS DB instance or Aurora DB cluster. These secrets are stored within Amazon Secrets Manager.</p>
        pub fn set_secret_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.secret_arn = input;
            self
        }
        /// <p>Whether to require or disallow Amazon Web Services Identity and Access Management (IAM) authentication for connections to the proxy.</p>
        pub fn iam_auth(mut self, input: crate::model::IamAuthMode) -> Self {
            self.iam_auth = Some(input);
            self
        }
        /// <p>Whether to require or disallow Amazon Web Services Identity and Access Management (IAM) authentication for connections to the proxy.</p>
        pub fn set_iam_auth(
            mut self,
            input: std::option::Option<crate::model::IamAuthMode>,
        ) -> Self {
            self.iam_auth = input;
            self
        }
        /// Consumes the builder and constructs a [`UserAuthConfigInfo`](crate::model::UserAuthConfigInfo)
        pub fn build(self) -> crate::model::UserAuthConfigInfo {
            crate::model::UserAuthConfigInfo {
                description: self.description,
                user_name: self.user_name,
                auth_scheme: self.auth_scheme,
                secret_arn: self.secret_arn,
                iam_auth: self.iam_auth,
            }
        }
    }
}
impl UserAuthConfigInfo {
    /// Creates a new builder-style object to manufacture [`UserAuthConfigInfo`](crate::model::UserAuthConfigInfo)
    pub fn builder() -> crate::model::user_auth_config_info::Builder {
        crate::model::user_auth_config_info::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum IamAuthMode {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Required,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for IamAuthMode {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => IamAuthMode::Disabled,
            "REQUIRED" => IamAuthMode::Required,
            other => IamAuthMode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for IamAuthMode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(IamAuthMode::from(s))
    }
}
impl IamAuthMode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            IamAuthMode::Disabled => "DISABLED",
            IamAuthMode::Required => "REQUIRED",
            IamAuthMode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLED", "REQUIRED"]
    }
}
impl AsRef<str> for IamAuthMode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AuthScheme {
    #[allow(missing_docs)] // documentation missing in model
    Secrets,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AuthScheme {
    fn from(s: &str) -> Self {
        match s {
            "SECRETS" => AuthScheme::Secrets,
            other => AuthScheme::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AuthScheme {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AuthScheme::from(s))
    }
}
impl AuthScheme {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AuthScheme::Secrets => "SECRETS",
            AuthScheme::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["SECRETS"]
    }
}
impl AsRef<str> for AuthScheme {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DbProxyStatus {
    #[allow(missing_docs)] // documentation missing in model
    Available,
    #[allow(missing_docs)] // documentation missing in model
    Creating,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    IncompatibleNetwork,
    #[allow(missing_docs)] // documentation missing in model
    InsufficientResourceLimits,
    #[allow(missing_docs)] // documentation missing in model
    Modifying,
    #[allow(missing_docs)] // documentation missing in model
    Reactivating,
    #[allow(missing_docs)] // documentation missing in model
    Suspended,
    #[allow(missing_docs)] // documentation missing in model
    Suspending,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DbProxyStatus {
    fn from(s: &str) -> Self {
        match s {
            "available" => DbProxyStatus::Available,
            "creating" => DbProxyStatus::Creating,
            "deleting" => DbProxyStatus::Deleting,
            "incompatible-network" => DbProxyStatus::IncompatibleNetwork,
            "insufficient-resource-limits" => DbProxyStatus::InsufficientResourceLimits,
            "modifying" => DbProxyStatus::Modifying,
            "reactivating" => DbProxyStatus::Reactivating,
            "suspended" => DbProxyStatus::Suspended,
            "suspending" => DbProxyStatus::Suspending,
            other => DbProxyStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DbProxyStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DbProxyStatus::from(s))
    }
}
impl DbProxyStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DbProxyStatus::Available => "available",
            DbProxyStatus::Creating => "creating",
            DbProxyStatus::Deleting => "deleting",
            DbProxyStatus::IncompatibleNetwork => "incompatible-network",
            DbProxyStatus::InsufficientResourceLimits => "insufficient-resource-limits",
            DbProxyStatus::Modifying => "modifying",
            DbProxyStatus::Reactivating => "reactivating",
            DbProxyStatus::Suspended => "suspended",
            DbProxyStatus::Suspending => "suspending",
            DbProxyStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "available",
            "creating",
            "deleting",
            "incompatible-network",
            "insufficient-resource-limits",
            "modifying",
            "reactivating",
            "suspended",
            "suspending",
        ]
    }
}
impl AsRef<str> for DbProxyStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Specifies the details of authentication used by a proxy to log in as a specific database user.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UserAuthConfig {
    /// <p>A user-specified description about the authentication used by a proxy to log in as a specific database user.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The name of the database user to which the proxy connects.</p>
    pub user_name: std::option::Option<std::string::String>,
    /// <p>The type of authentication that the proxy uses for connections from the proxy to the underlying database.</p>
    pub auth_scheme: std::option::Option<crate::model::AuthScheme>,
    /// <p>The Amazon Resource Name (ARN) representing the secret that the proxy uses to authenticate to the RDS DB instance or Aurora DB cluster. These secrets are stored within Amazon Secrets Manager.</p>
    pub secret_arn: std::option::Option<std::string::String>,
    /// <p>Whether to require or disallow Amazon Web Services Identity and Access Management (IAM) authentication for connections to the proxy.</p>
    pub iam_auth: std::option::Option<crate::model::IamAuthMode>,
}
impl UserAuthConfig {
    /// <p>A user-specified description about the authentication used by a proxy to log in as a specific database user.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The name of the database user to which the proxy connects.</p>
    pub fn user_name(&self) -> std::option::Option<&str> {
        self.user_name.as_deref()
    }
    /// <p>The type of authentication that the proxy uses for connections from the proxy to the underlying database.</p>
    pub fn auth_scheme(&self) -> std::option::Option<&crate::model::AuthScheme> {
        self.auth_scheme.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) representing the secret that the proxy uses to authenticate to the RDS DB instance or Aurora DB cluster. These secrets are stored within Amazon Secrets Manager.</p>
    pub fn secret_arn(&self) -> std::option::Option<&str> {
        self.secret_arn.as_deref()
    }
    /// <p>Whether to require or disallow Amazon Web Services Identity and Access Management (IAM) authentication for connections to the proxy.</p>
    pub fn iam_auth(&self) -> std::option::Option<&crate::model::IamAuthMode> {
        self.iam_auth.as_ref()
    }
}
impl std::fmt::Debug for UserAuthConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UserAuthConfig");
        formatter.field("description", &self.description);
        formatter.field("user_name", &self.user_name);
        formatter.field("auth_scheme", &self.auth_scheme);
        formatter.field("secret_arn", &self.secret_arn);
        formatter.field("iam_auth", &self.iam_auth);
        formatter.finish()
    }
}
/// See [`UserAuthConfig`](crate::model::UserAuthConfig)
pub mod user_auth_config {
    /// A builder for [`UserAuthConfig`](crate::model::UserAuthConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) user_name: std::option::Option<std::string::String>,
        pub(crate) auth_scheme: std::option::Option<crate::model::AuthScheme>,
        pub(crate) secret_arn: std::option::Option<std::string::String>,
        pub(crate) iam_auth: std::option::Option<crate::model::IamAuthMode>,
    }
    impl Builder {
        /// <p>A user-specified description about the authentication used by a proxy to log in as a specific database user.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A user-specified description about the authentication used by a proxy to log in as a specific database user.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The name of the database user to which the proxy connects.</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_name = Some(input.into());
            self
        }
        /// <p>The name of the database user to which the proxy connects.</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_name = input;
            self
        }
        /// <p>The type of authentication that the proxy uses for connections from the proxy to the underlying database.</p>
        pub fn auth_scheme(mut self, input: crate::model::AuthScheme) -> Self {
            self.auth_scheme = Some(input);
            self
        }
        /// <p>The type of authentication that the proxy uses for connections from the proxy to the underlying database.</p>
        pub fn set_auth_scheme(
            mut self,
            input: std::option::Option<crate::model::AuthScheme>,
        ) -> Self {
            self.auth_scheme = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) representing the secret that the proxy uses to authenticate to the RDS DB instance or Aurora DB cluster. These secrets are stored within Amazon Secrets Manager.</p>
        pub fn secret_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.secret_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) representing the secret that the proxy uses to authenticate to the RDS DB instance or Aurora DB cluster. These secrets are stored within Amazon Secrets Manager.</p>
        pub fn set_secret_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.secret_arn = input;
            self
        }
        /// <p>Whether to require or disallow Amazon Web Services Identity and Access Management (IAM) authentication for connections to the proxy.</p>
        pub fn iam_auth(mut self, input: crate::model::IamAuthMode) -> Self {
            self.iam_auth = Some(input);
            self
        }
        /// <p>Whether to require or disallow Amazon Web Services Identity and Access Management (IAM) authentication for connections to the proxy.</p>
        pub fn set_iam_auth(
            mut self,
            input: std::option::Option<crate::model::IamAuthMode>,
        ) -> Self {
            self.iam_auth = input;
            self
        }
        /// Consumes the builder and constructs a [`UserAuthConfig`](crate::model::UserAuthConfig)
        pub fn build(self) -> crate::model::UserAuthConfig {
            crate::model::UserAuthConfig {
                description: self.description,
                user_name: self.user_name,
                auth_scheme: self.auth_scheme,
                secret_arn: self.secret_arn,
                iam_auth: self.iam_auth,
            }
        }
    }
}
impl UserAuthConfig {
    /// Creates a new builder-style object to manufacture [`UserAuthConfig`](crate::model::UserAuthConfig)
    pub fn builder() -> crate::model::user_auth_config::Builder {
        crate::model::user_auth_config::Builder::default()
    }
}

/// <p>The configuration setting for the log types to be enabled for export to CloudWatch Logs for a specific DB instance or DB cluster.</p>
/// <p>The <code>EnableLogTypes</code> and <code>DisableLogTypes</code> arrays determine which logs will be exported (or not exported) to CloudWatch Logs. The values within these arrays depend on the DB engine being used.</p>
/// <p>For more information about exporting CloudWatch Logs for Amazon RDS DB instances, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch">Publishing Database Logs to Amazon CloudWatch Logs </a> in the <i>Amazon RDS User Guide</i>.</p>
/// <p>For more information about exporting CloudWatch Logs for Amazon Aurora DB clusters, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch">Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon Aurora User Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CloudwatchLogsExportConfiguration {
    /// <p>The list of log types to enable.</p>
    pub enable_log_types: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The list of log types to disable.</p>
    pub disable_log_types: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl CloudwatchLogsExportConfiguration {
    /// <p>The list of log types to enable.</p>
    pub fn enable_log_types(&self) -> std::option::Option<&[std::string::String]> {
        self.enable_log_types.as_deref()
    }
    /// <p>The list of log types to disable.</p>
    pub fn disable_log_types(&self) -> std::option::Option<&[std::string::String]> {
        self.disable_log_types.as_deref()
    }
}
impl std::fmt::Debug for CloudwatchLogsExportConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CloudwatchLogsExportConfiguration");
        formatter.field("enable_log_types", &self.enable_log_types);
        formatter.field("disable_log_types", &self.disable_log_types);
        formatter.finish()
    }
}
/// See [`CloudwatchLogsExportConfiguration`](crate::model::CloudwatchLogsExportConfiguration)
pub mod cloudwatch_logs_export_configuration {
    /// A builder for [`CloudwatchLogsExportConfiguration`](crate::model::CloudwatchLogsExportConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) enable_log_types: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) disable_log_types: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `enable_log_types`.
        ///
        /// To override the contents of this collection use [`set_enable_log_types`](Self::set_enable_log_types).
        ///
        /// <p>The list of log types to enable.</p>
        pub fn enable_log_types(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.enable_log_types.unwrap_or_default();
            v.push(input.into());
            self.enable_log_types = Some(v);
            self
        }
        /// <p>The list of log types to enable.</p>
        pub fn set_enable_log_types(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.enable_log_types = input;
            self
        }
        /// Appends an item to `disable_log_types`.
        ///
        /// To override the contents of this collection use [`set_disable_log_types`](Self::set_disable_log_types).
        ///
        /// <p>The list of log types to disable.</p>
        pub fn disable_log_types(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.disable_log_types.unwrap_or_default();
            v.push(input.into());
            self.disable_log_types = Some(v);
            self
        }
        /// <p>The list of log types to disable.</p>
        pub fn set_disable_log_types(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.disable_log_types = input;
            self
        }
        /// Consumes the builder and constructs a [`CloudwatchLogsExportConfiguration`](crate::model::CloudwatchLogsExportConfiguration)
        pub fn build(self) -> crate::model::CloudwatchLogsExportConfiguration {
            crate::model::CloudwatchLogsExportConfiguration {
                enable_log_types: self.enable_log_types,
                disable_log_types: self.disable_log_types,
            }
        }
    }
}
impl CloudwatchLogsExportConfiguration {
    /// Creates a new builder-style object to manufacture [`CloudwatchLogsExportConfiguration`](crate::model::CloudwatchLogsExportConfiguration)
    pub fn builder() -> crate::model::cloudwatch_logs_export_configuration::Builder {
        crate::model::cloudwatch_logs_export_configuration::Builder::default()
    }
}

/// <p>Contains the results of a successful call to the <code>DescribeDBClusterSnapshotAttributes</code> API action.</p>
/// <p>Manual DB cluster snapshot attributes are used to authorize other Amazon Web Services accounts to copy or restore a manual DB cluster snapshot. For more information, see the <code>ModifyDBClusterSnapshotAttribute</code> API action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DbClusterSnapshotAttributesResult {
    /// <p>The identifier of the manual DB cluster snapshot that the attributes apply to.</p>
    pub db_cluster_snapshot_identifier: std::option::Option<std::string::String>,
    /// <p>The list of attributes and values for the manual DB cluster snapshot.</p>
    pub db_cluster_snapshot_attributes:
        std::option::Option<std::vec::Vec<crate::model::DbClusterSnapshotAttribute>>,
}
impl DbClusterSnapshotAttributesResult {
    /// <p>The identifier of the manual DB cluster snapshot that the attributes apply to.</p>
    pub fn db_cluster_snapshot_identifier(&self) -> std::option::Option<&str> {
        self.db_cluster_snapshot_identifier.as_deref()
    }
    /// <p>The list of attributes and values for the manual DB cluster snapshot.</p>
    pub fn db_cluster_snapshot_attributes(
        &self,
    ) -> std::option::Option<&[crate::model::DbClusterSnapshotAttribute]> {
        self.db_cluster_snapshot_attributes.as_deref()
    }
}
impl std::fmt::Debug for DbClusterSnapshotAttributesResult {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DbClusterSnapshotAttributesResult");
        formatter.field(
            "db_cluster_snapshot_identifier",
            &self.db_cluster_snapshot_identifier,
        );
        formatter.field(
            "db_cluster_snapshot_attributes",
            &self.db_cluster_snapshot_attributes,
        );
        formatter.finish()
    }
}
/// See [`DbClusterSnapshotAttributesResult`](crate::model::DbClusterSnapshotAttributesResult)
pub mod db_cluster_snapshot_attributes_result {
    /// A builder for [`DbClusterSnapshotAttributesResult`](crate::model::DbClusterSnapshotAttributesResult)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster_snapshot_identifier: std::option::Option<std::string::String>,
        pub(crate) db_cluster_snapshot_attributes:
            std::option::Option<std::vec::Vec<crate::model::DbClusterSnapshotAttribute>>,
    }
    impl Builder {
        /// <p>The identifier of the manual DB cluster snapshot that the attributes apply to.</p>
        pub fn db_cluster_snapshot_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.db_cluster_snapshot_identifier = Some(input.into());
            self
        }
        /// <p>The identifier of the manual DB cluster snapshot that the attributes apply to.</p>
        pub fn set_db_cluster_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_snapshot_identifier = input;
            self
        }
        /// Appends an item to `db_cluster_snapshot_attributes`.
        ///
        /// To override the contents of this collection use [`set_db_cluster_snapshot_attributes`](Self::set_db_cluster_snapshot_attributes).
        ///
        /// <p>The list of attributes and values for the manual DB cluster snapshot.</p>
        pub fn db_cluster_snapshot_attributes(
            mut self,
            input: crate::model::DbClusterSnapshotAttribute,
        ) -> Self {
            let mut v = self.db_cluster_snapshot_attributes.unwrap_or_default();
            v.push(input);
            self.db_cluster_snapshot_attributes = Some(v);
            self
        }
        /// <p>The list of attributes and values for the manual DB cluster snapshot.</p>
        pub fn set_db_cluster_snapshot_attributes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DbClusterSnapshotAttribute>>,
        ) -> Self {
            self.db_cluster_snapshot_attributes = input;
            self
        }
        /// Consumes the builder and constructs a [`DbClusterSnapshotAttributesResult`](crate::model::DbClusterSnapshotAttributesResult)
        pub fn build(self) -> crate::model::DbClusterSnapshotAttributesResult {
            crate::model::DbClusterSnapshotAttributesResult {
                db_cluster_snapshot_identifier: self.db_cluster_snapshot_identifier,
                db_cluster_snapshot_attributes: self.db_cluster_snapshot_attributes,
            }
        }
    }
}
impl DbClusterSnapshotAttributesResult {
    /// Creates a new builder-style object to manufacture [`DbClusterSnapshotAttributesResult`](crate::model::DbClusterSnapshotAttributesResult)
    pub fn builder() -> crate::model::db_cluster_snapshot_attributes_result::Builder {
        crate::model::db_cluster_snapshot_attributes_result::Builder::default()
    }
}

/// <p>Contains the name and values of a manual DB cluster snapshot attribute.</p>
/// <p>Manual DB cluster snapshot attributes are used to authorize other Amazon Web Services accounts to restore a manual DB cluster snapshot. For more information, see the <code>ModifyDBClusterSnapshotAttribute</code> API action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DbClusterSnapshotAttribute {
    /// <p>The name of the manual DB cluster snapshot attribute.</p>
    /// <p>The attribute named <code>restore</code> refers to the list of Amazon Web Services accounts that have permission to copy or restore the manual DB cluster snapshot. For more information, see the <code>ModifyDBClusterSnapshotAttribute</code> API action.</p>
    pub attribute_name: std::option::Option<std::string::String>,
    /// <p>The value(s) for the manual DB cluster snapshot attribute.</p>
    /// <p>If the <code>AttributeName</code> field is set to <code>restore</code>, then this element returns a list of IDs of the Amazon Web Services accounts that are authorized to copy or restore the manual DB cluster snapshot. If a value of <code>all</code> is in the list, then the manual DB cluster snapshot is public and available for any Amazon Web Services account to copy or restore.</p>
    pub attribute_values: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl DbClusterSnapshotAttribute {
    /// <p>The name of the manual DB cluster snapshot attribute.</p>
    /// <p>The attribute named <code>restore</code> refers to the list of Amazon Web Services accounts that have permission to copy or restore the manual DB cluster snapshot. For more information, see the <code>ModifyDBClusterSnapshotAttribute</code> API action.</p>
    pub fn attribute_name(&self) -> std::option::Option<&str> {
        self.attribute_name.as_deref()
    }
    /// <p>The value(s) for the manual DB cluster snapshot attribute.</p>
    /// <p>If the <code>AttributeName</code> field is set to <code>restore</code>, then this element returns a list of IDs of the Amazon Web Services accounts that are authorized to copy or restore the manual DB cluster snapshot. If a value of <code>all</code> is in the list, then the manual DB cluster snapshot is public and available for any Amazon Web Services account to copy or restore.</p>
    pub fn attribute_values(&self) -> std::option::Option<&[std::string::String]> {
        self.attribute_values.as_deref()
    }
}
impl std::fmt::Debug for DbClusterSnapshotAttribute {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DbClusterSnapshotAttribute");
        formatter.field("attribute_name", &self.attribute_name);
        formatter.field("attribute_values", &self.attribute_values);
        formatter.finish()
    }
}
/// See [`DbClusterSnapshotAttribute`](crate::model::DbClusterSnapshotAttribute)
pub mod db_cluster_snapshot_attribute {
    /// A builder for [`DbClusterSnapshotAttribute`](crate::model::DbClusterSnapshotAttribute)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attribute_name: std::option::Option<std::string::String>,
        pub(crate) attribute_values: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of the manual DB cluster snapshot attribute.</p>
        /// <p>The attribute named <code>restore</code> refers to the list of Amazon Web Services accounts that have permission to copy or restore the manual DB cluster snapshot. For more information, see the <code>ModifyDBClusterSnapshotAttribute</code> API action.</p>
        pub fn attribute_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.attribute_name = Some(input.into());
            self
        }
        /// <p>The name of the manual DB cluster snapshot attribute.</p>
        /// <p>The attribute named <code>restore</code> refers to the list of Amazon Web Services accounts that have permission to copy or restore the manual DB cluster snapshot. For more information, see the <code>ModifyDBClusterSnapshotAttribute</code> API action.</p>
        pub fn set_attribute_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.attribute_name = input;
            self
        }
        /// Appends an item to `attribute_values`.
        ///
        /// To override the contents of this collection use [`set_attribute_values`](Self::set_attribute_values).
        ///
        /// <p>The value(s) for the manual DB cluster snapshot attribute.</p>
        /// <p>If the <code>AttributeName</code> field is set to <code>restore</code>, then this element returns a list of IDs of the Amazon Web Services accounts that are authorized to copy or restore the manual DB cluster snapshot. If a value of <code>all</code> is in the list, then the manual DB cluster snapshot is public and available for any Amazon Web Services account to copy or restore.</p>
        pub fn attribute_values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.attribute_values.unwrap_or_default();
            v.push(input.into());
            self.attribute_values = Some(v);
            self
        }
        /// <p>The value(s) for the manual DB cluster snapshot attribute.</p>
        /// <p>If the <code>AttributeName</code> field is set to <code>restore</code>, then this element returns a list of IDs of the Amazon Web Services accounts that are authorized to copy or restore the manual DB cluster snapshot. If a value of <code>all</code> is in the list, then the manual DB cluster snapshot is public and available for any Amazon Web Services account to copy or restore.</p>
        pub fn set_attribute_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.attribute_values = input;
            self
        }
        /// Consumes the builder and constructs a [`DbClusterSnapshotAttribute`](crate::model::DbClusterSnapshotAttribute)
        pub fn build(self) -> crate::model::DbClusterSnapshotAttribute {
            crate::model::DbClusterSnapshotAttribute {
                attribute_name: self.attribute_name,
                attribute_values: self.attribute_values,
            }
        }
    }
}
impl DbClusterSnapshotAttribute {
    /// Creates a new builder-style object to manufacture [`DbClusterSnapshotAttribute`](crate::model::DbClusterSnapshotAttribute)
    pub fn builder() -> crate::model::db_cluster_snapshot_attribute::Builder {
        crate::model::db_cluster_snapshot_attribute::Builder::default()
    }
}

/// <p>A time zone associated with a <code>DBInstance</code> or a <code>DBSnapshot</code>. This data type is an element in the response to the <code>DescribeDBInstances</code>, the <code>DescribeDBSnapshots</code>, and the <code>DescribeDBEngineVersions</code> actions. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Timezone {
    /// <p>The name of the time zone.</p>
    pub timezone_name: std::option::Option<std::string::String>,
}
impl Timezone {
    /// <p>The name of the time zone.</p>
    pub fn timezone_name(&self) -> std::option::Option<&str> {
        self.timezone_name.as_deref()
    }
}
impl std::fmt::Debug for Timezone {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Timezone");
        formatter.field("timezone_name", &self.timezone_name);
        formatter.finish()
    }
}
/// See [`Timezone`](crate::model::Timezone)
pub mod timezone {
    /// A builder for [`Timezone`](crate::model::Timezone)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) timezone_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the time zone.</p>
        pub fn timezone_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.timezone_name = Some(input.into());
            self
        }
        /// <p>The name of the time zone.</p>
        pub fn set_timezone_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.timezone_name = input;
            self
        }
        /// Consumes the builder and constructs a [`Timezone`](crate::model::Timezone)
        pub fn build(self) -> crate::model::Timezone {
            crate::model::Timezone {
                timezone_name: self.timezone_name,
            }
        }
    }
}
impl Timezone {
    /// Creates a new builder-style object to manufacture [`Timezone`](crate::model::Timezone)
    pub fn builder() -> crate::model::timezone::Builder {
        crate::model::timezone::Builder::default()
    }
}

/// <p>The version of the database engine that a DB instance can be upgraded to.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpgradeTarget {
    /// <p>The name of the upgrade target database engine.</p>
    pub engine: std::option::Option<std::string::String>,
    /// <p>The version number of the upgrade target database engine.</p>
    pub engine_version: std::option::Option<std::string::String>,
    /// <p>The version of the database engine that a DB instance can be upgraded to.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>A value that indicates whether the target version is applied to any source DB instances that have <code>AutoMinorVersionUpgrade</code> set to true.</p>
    pub auto_upgrade: bool,
    /// <p>A value that indicates whether upgrading to the target version requires upgrading the major version of the database engine.</p>
    pub is_major_version_upgrade: bool,
    /// <p>A list of the supported DB engine modes for the target engine version.</p>
    pub supported_engine_modes: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A value that indicates whether you can use Aurora parallel query with the target engine version.</p>
    pub supports_parallel_query: std::option::Option<bool>,
    /// <p>A value that indicates whether you can use Aurora global databases with the target engine version.</p>
    pub supports_global_databases: std::option::Option<bool>,
}
impl UpgradeTarget {
    /// <p>The name of the upgrade target database engine.</p>
    pub fn engine(&self) -> std::option::Option<&str> {
        self.engine.as_deref()
    }
    /// <p>The version number of the upgrade target database engine.</p>
    pub fn engine_version(&self) -> std::option::Option<&str> {
        self.engine_version.as_deref()
    }
    /// <p>The version of the database engine that a DB instance can be upgraded to.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>A value that indicates whether the target version is applied to any source DB instances that have <code>AutoMinorVersionUpgrade</code> set to true.</p>
    pub fn auto_upgrade(&self) -> bool {
        self.auto_upgrade
    }
    /// <p>A value that indicates whether upgrading to the target version requires upgrading the major version of the database engine.</p>
    pub fn is_major_version_upgrade(&self) -> bool {
        self.is_major_version_upgrade
    }
    /// <p>A list of the supported DB engine modes for the target engine version.</p>
    pub fn supported_engine_modes(&self) -> std::option::Option<&[std::string::String]> {
        self.supported_engine_modes.as_deref()
    }
    /// <p>A value that indicates whether you can use Aurora parallel query with the target engine version.</p>
    pub fn supports_parallel_query(&self) -> std::option::Option<bool> {
        self.supports_parallel_query
    }
    /// <p>A value that indicates whether you can use Aurora global databases with the target engine version.</p>
    pub fn supports_global_databases(&self) -> std::option::Option<bool> {
        self.supports_global_databases
    }
}
impl std::fmt::Debug for UpgradeTarget {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpgradeTarget");
        formatter.field("engine", &self.engine);
        formatter.field("engine_version", &self.engine_version);
        formatter.field("description", &self.description);
        formatter.field("auto_upgrade", &self.auto_upgrade);
        formatter.field("is_major_version_upgrade", &self.is_major_version_upgrade);
        formatter.field("supported_engine_modes", &self.supported_engine_modes);
        formatter.field("supports_parallel_query", &self.supports_parallel_query);
        formatter.field("supports_global_databases", &self.supports_global_databases);
        formatter.finish()
    }
}
/// See [`UpgradeTarget`](crate::model::UpgradeTarget)
pub mod upgrade_target {
    /// A builder for [`UpgradeTarget`](crate::model::UpgradeTarget)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) engine: std::option::Option<std::string::String>,
        pub(crate) engine_version: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) auto_upgrade: std::option::Option<bool>,
        pub(crate) is_major_version_upgrade: std::option::Option<bool>,
        pub(crate) supported_engine_modes: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) supports_parallel_query: std::option::Option<bool>,
        pub(crate) supports_global_databases: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of the upgrade target database engine.</p>
        pub fn engine(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine = Some(input.into());
            self
        }
        /// <p>The name of the upgrade target database engine.</p>
        pub fn set_engine(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.engine = input;
            self
        }
        /// <p>The version number of the upgrade target database engine.</p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_version = Some(input.into());
            self
        }
        /// <p>The version number of the upgrade target database engine.</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.engine_version = input;
            self
        }
        /// <p>The version of the database engine that a DB instance can be upgraded to.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The version of the database engine that a DB instance can be upgraded to.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>A value that indicates whether the target version is applied to any source DB instances that have <code>AutoMinorVersionUpgrade</code> set to true.</p>
        pub fn auto_upgrade(mut self, input: bool) -> Self {
            self.auto_upgrade = Some(input);
            self
        }
        /// <p>A value that indicates whether the target version is applied to any source DB instances that have <code>AutoMinorVersionUpgrade</code> set to true.</p>
        pub fn set_auto_upgrade(mut self, input: std::option::Option<bool>) -> Self {
            self.auto_upgrade = input;
            self
        }
        /// <p>A value that indicates whether upgrading to the target version requires upgrading the major version of the database engine.</p>
        pub fn is_major_version_upgrade(mut self, input: bool) -> Self {
            self.is_major_version_upgrade = Some(input);
            self
        }
        /// <p>A value that indicates whether upgrading to the target version requires upgrading the major version of the database engine.</p>
        pub fn set_is_major_version_upgrade(mut self, input: std::option::Option<bool>) -> Self {
            self.is_major_version_upgrade = input;
            self
        }
        /// Appends an item to `supported_engine_modes`.
        ///
        /// To override the contents of this collection use [`set_supported_engine_modes`](Self::set_supported_engine_modes).
        ///
        /// <p>A list of the supported DB engine modes for the target engine version.</p>
        pub fn supported_engine_modes(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.supported_engine_modes.unwrap_or_default();
            v.push(input.into());
            self.supported_engine_modes = Some(v);
            self
        }
        /// <p>A list of the supported DB engine modes for the target engine version.</p>
        pub fn set_supported_engine_modes(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.supported_engine_modes = input;
            self
        }
        /// <p>A value that indicates whether you can use Aurora parallel query with the target engine version.</p>
        pub fn supports_parallel_query(mut self, input: bool) -> Self {
            self.supports_parallel_query = Some(input);
            self
        }
        /// <p>A value that indicates whether you can use Aurora parallel query with the target engine version.</p>
        pub fn set_supports_parallel_query(mut self, input: std::option::Option<bool>) -> Self {
            self.supports_parallel_query = input;
            self
        }
        /// <p>A value that indicates whether you can use Aurora global databases with the target engine version.</p>
        pub fn supports_global_databases(mut self, input: bool) -> Self {
            self.supports_global_databases = Some(input);
            self
        }
        /// <p>A value that indicates whether you can use Aurora global databases with the target engine version.</p>
        pub fn set_supports_global_databases(mut self, input: std::option::Option<bool>) -> Self {
            self.supports_global_databases = input;
            self
        }
        /// Consumes the builder and constructs a [`UpgradeTarget`](crate::model::UpgradeTarget)
        pub fn build(self) -> crate::model::UpgradeTarget {
            crate::model::UpgradeTarget {
                engine: self.engine,
                engine_version: self.engine_version,
                description: self.description,
                auto_upgrade: self.auto_upgrade.unwrap_or_default(),
                is_major_version_upgrade: self.is_major_version_upgrade.unwrap_or_default(),
                supported_engine_modes: self.supported_engine_modes,
                supports_parallel_query: self.supports_parallel_query,
                supports_global_databases: self.supports_global_databases,
            }
        }
    }
}
impl UpgradeTarget {
    /// Creates a new builder-style object to manufacture [`UpgradeTarget`](crate::model::UpgradeTarget)
    pub fn builder() -> crate::model::upgrade_target::Builder {
        crate::model::upgrade_target::Builder::default()
    }
}

/// <p> This data type is used as a response element in the action <code>DescribeDBEngineVersions</code>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CharacterSet {
    /// <p>The name of the character set.</p>
    pub character_set_name: std::option::Option<std::string::String>,
    /// <p>The description of the character set.</p>
    pub character_set_description: std::option::Option<std::string::String>,
}
impl CharacterSet {
    /// <p>The name of the character set.</p>
    pub fn character_set_name(&self) -> std::option::Option<&str> {
        self.character_set_name.as_deref()
    }
    /// <p>The description of the character set.</p>
    pub fn character_set_description(&self) -> std::option::Option<&str> {
        self.character_set_description.as_deref()
    }
}
impl std::fmt::Debug for CharacterSet {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CharacterSet");
        formatter.field("character_set_name", &self.character_set_name);
        formatter.field("character_set_description", &self.character_set_description);
        formatter.finish()
    }
}
/// See [`CharacterSet`](crate::model::CharacterSet)
pub mod character_set {
    /// A builder for [`CharacterSet`](crate::model::CharacterSet)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) character_set_name: std::option::Option<std::string::String>,
        pub(crate) character_set_description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the character set.</p>
        pub fn character_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.character_set_name = Some(input.into());
            self
        }
        /// <p>The name of the character set.</p>
        pub fn set_character_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.character_set_name = input;
            self
        }
        /// <p>The description of the character set.</p>
        pub fn character_set_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.character_set_description = Some(input.into());
            self
        }
        /// <p>The description of the character set.</p>
        pub fn set_character_set_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.character_set_description = input;
            self
        }
        /// Consumes the builder and constructs a [`CharacterSet`](crate::model::CharacterSet)
        pub fn build(self) -> crate::model::CharacterSet {
            crate::model::CharacterSet {
                character_set_name: self.character_set_name,
                character_set_description: self.character_set_description,
            }
        }
    }
}
impl CharacterSet {
    /// Creates a new builder-style object to manufacture [`CharacterSet`](crate::model::CharacterSet)
    pub fn builder() -> crate::model::character_set::Builder {
        crate::model::character_set::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum CustomEngineVersionStatus {
    #[allow(missing_docs)] // documentation missing in model
    Available,
    #[allow(missing_docs)] // documentation missing in model
    Inactive,
    #[allow(missing_docs)] // documentation missing in model
    InactiveExceptRestore,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for CustomEngineVersionStatus {
    fn from(s: &str) -> Self {
        match s {
            "available" => CustomEngineVersionStatus::Available,
            "inactive" => CustomEngineVersionStatus::Inactive,
            "inactive-except-restore" => CustomEngineVersionStatus::InactiveExceptRestore,
            other => CustomEngineVersionStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for CustomEngineVersionStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(CustomEngineVersionStatus::from(s))
    }
}
impl CustomEngineVersionStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            CustomEngineVersionStatus::Available => "available",
            CustomEngineVersionStatus::Inactive => "inactive",
            CustomEngineVersionStatus::InactiveExceptRestore => "inactive-except-restore",
            CustomEngineVersionStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["available", "inactive", "inactive-except-restore"]
    }
}
impl AsRef<str> for CustomEngineVersionStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A CA certificate for an Amazon Web Services account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Certificate {
    /// <p>The unique key that identifies a certificate.</p>
    pub certificate_identifier: std::option::Option<std::string::String>,
    /// <p>The type of the certificate.</p>
    pub certificate_type: std::option::Option<std::string::String>,
    /// <p>The thumbprint of the certificate.</p>
    pub thumbprint: std::option::Option<std::string::String>,
    /// <p>The starting date from which the certificate is valid.</p>
    pub valid_from: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The final date that the certificate continues to be valid.</p>
    pub valid_till: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The Amazon Resource Name (ARN) for the certificate.</p>
    pub certificate_arn: std::option::Option<std::string::String>,
    /// <p>Whether there is an override for the default certificate identifier.</p>
    pub customer_override: std::option::Option<bool>,
    /// <p>If there is an override for the default certificate identifier, when the override expires.</p>
    pub customer_override_valid_till: std::option::Option<aws_smithy_types::DateTime>,
}
impl Certificate {
    /// <p>The unique key that identifies a certificate.</p>
    pub fn certificate_identifier(&self) -> std::option::Option<&str> {
        self.certificate_identifier.as_deref()
    }
    /// <p>The type of the certificate.</p>
    pub fn certificate_type(&self) -> std::option::Option<&str> {
        self.certificate_type.as_deref()
    }
    /// <p>The thumbprint of the certificate.</p>
    pub fn thumbprint(&self) -> std::option::Option<&str> {
        self.thumbprint.as_deref()
    }
    /// <p>The starting date from which the certificate is valid.</p>
    pub fn valid_from(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.valid_from.as_ref()
    }
    /// <p>The final date that the certificate continues to be valid.</p>
    pub fn valid_till(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.valid_till.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) for the certificate.</p>
    pub fn certificate_arn(&self) -> std::option::Option<&str> {
        self.certificate_arn.as_deref()
    }
    /// <p>Whether there is an override for the default certificate identifier.</p>
    pub fn customer_override(&self) -> std::option::Option<bool> {
        self.customer_override
    }
    /// <p>If there is an override for the default certificate identifier, when the override expires.</p>
    pub fn customer_override_valid_till(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.customer_override_valid_till.as_ref()
    }
}
impl std::fmt::Debug for Certificate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Certificate");
        formatter.field("certificate_identifier", &self.certificate_identifier);
        formatter.field("certificate_type", &self.certificate_type);
        formatter.field("thumbprint", &self.thumbprint);
        formatter.field("valid_from", &self.valid_from);
        formatter.field("valid_till", &self.valid_till);
        formatter.field("certificate_arn", &self.certificate_arn);
        formatter.field("customer_override", &self.customer_override);
        formatter.field(
            "customer_override_valid_till",
            &self.customer_override_valid_till,
        );
        formatter.finish()
    }
}
/// See [`Certificate`](crate::model::Certificate)
pub mod certificate {
    /// A builder for [`Certificate`](crate::model::Certificate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) certificate_identifier: std::option::Option<std::string::String>,
        pub(crate) certificate_type: std::option::Option<std::string::String>,
        pub(crate) thumbprint: std::option::Option<std::string::String>,
        pub(crate) valid_from: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) valid_till: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) certificate_arn: std::option::Option<std::string::String>,
        pub(crate) customer_override: std::option::Option<bool>,
        pub(crate) customer_override_valid_till: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The unique key that identifies a certificate.</p>
        pub fn certificate_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_identifier = Some(input.into());
            self
        }
        /// <p>The unique key that identifies a certificate.</p>
        pub fn set_certificate_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_identifier = input;
            self
        }
        /// <p>The type of the certificate.</p>
        pub fn certificate_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_type = Some(input.into());
            self
        }
        /// <p>The type of the certificate.</p>
        pub fn set_certificate_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_type = input;
            self
        }
        /// <p>The thumbprint of the certificate.</p>
        pub fn thumbprint(mut self, input: impl Into<std::string::String>) -> Self {
            self.thumbprint = Some(input.into());
            self
        }
        /// <p>The thumbprint of the certificate.</p>
        pub fn set_thumbprint(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.thumbprint = input;
            self
        }
        /// <p>The starting date from which the certificate is valid.</p>
        pub fn valid_from(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.valid_from = Some(input);
            self
        }
        /// <p>The starting date from which the certificate is valid.</p>
        pub fn set_valid_from(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.valid_from = input;
            self
        }
        /// <p>The final date that the certificate continues to be valid.</p>
        pub fn valid_till(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.valid_till = Some(input);
            self
        }
        /// <p>The final date that the certificate continues to be valid.</p>
        pub fn set_valid_till(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.valid_till = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the certificate.</p>
        pub fn certificate_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the certificate.</p>
        pub fn set_certificate_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_arn = input;
            self
        }
        /// <p>Whether there is an override for the default certificate identifier.</p>
        pub fn customer_override(mut self, input: bool) -> Self {
            self.customer_override = Some(input);
            self
        }
        /// <p>Whether there is an override for the default certificate identifier.</p>
        pub fn set_customer_override(mut self, input: std::option::Option<bool>) -> Self {
            self.customer_override = input;
            self
        }
        /// <p>If there is an override for the default certificate identifier, when the override expires.</p>
        pub fn customer_override_valid_till(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.customer_override_valid_till = Some(input);
            self
        }
        /// <p>If there is an override for the default certificate identifier, when the override expires.</p>
        pub fn set_customer_override_valid_till(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.customer_override_valid_till = input;
            self
        }
        /// Consumes the builder and constructs a [`Certificate`](crate::model::Certificate)
        pub fn build(self) -> crate::model::Certificate {
            crate::model::Certificate {
                certificate_identifier: self.certificate_identifier,
                certificate_type: self.certificate_type,
                thumbprint: self.thumbprint,
                valid_from: self.valid_from,
                valid_till: self.valid_till,
                certificate_arn: self.certificate_arn,
                customer_override: self.customer_override,
                customer_override_valid_till: self.customer_override_valid_till,
            }
        }
    }
}
impl Certificate {
    /// Creates a new builder-style object to manufacture [`Certificate`](crate::model::Certificate)
    pub fn builder() -> crate::model::certificate::Builder {
        crate::model::certificate::Builder::default()
    }
}

/// <p>A filter name and value pair that is used to return a more specific list of results from a describe operation. Filters can be used to match a set of resources by specific criteria, such as IDs. The filters supported by a describe operation are documented with the describe operation.</p> <note>
/// <p>Currently, wildcards are not supported in filters.</p>
/// </note>
/// <p>The following actions can be filtered:</p>
/// <ul>
/// <li> <p> <code>DescribeDBClusterBacktracks</code> </p> </li>
/// <li> <p> <code>DescribeDBClusterEndpoints</code> </p> </li>
/// <li> <p> <code>DescribeDBClusters</code> </p> </li>
/// <li> <p> <code>DescribeDBInstances</code> </p> </li>
/// <li> <p> <code>DescribePendingMaintenanceActions</code> </p> </li>
/// </ul>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Filter {
    /// <p>The name of the filter. Filter names are case-sensitive.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>One or more filter values. Filter values are case-sensitive.</p>
    pub values: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl Filter {
    /// <p>The name of the filter. Filter names are case-sensitive.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>One or more filter values. Filter values are case-sensitive.</p>
    pub fn values(&self) -> std::option::Option<&[std::string::String]> {
        self.values.as_deref()
    }
}
impl std::fmt::Debug for Filter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Filter");
        formatter.field("name", &self.name);
        formatter.field("values", &self.values);
        formatter.finish()
    }
}
/// See [`Filter`](crate::model::Filter)
pub mod filter {
    /// A builder for [`Filter`](crate::model::Filter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) values: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The name of the filter. Filter names are case-sensitive.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the filter. Filter names are case-sensitive.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>One or more filter values. Filter values are case-sensitive.</p>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>One or more filter values. Filter values are case-sensitive.</p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// Consumes the builder and constructs a [`Filter`](crate::model::Filter)
        pub fn build(self) -> crate::model::Filter {
            crate::model::Filter {
                name: self.name,
                values: self.values,
            }
        }
    }
}
impl Filter {
    /// Creates a new builder-style object to manufacture [`Filter`](crate::model::Filter)
    pub fn builder() -> crate::model::filter::Builder {
        crate::model::filter::Builder::default()
    }
}

/// <p>Contains the cause of an installation media failure. Installation media is used for a DB engine that requires an on-premises customer provided license, such as Microsoft SQL Server.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InstallationMediaFailureCause {
    /// <p>The reason that an installation media import failed.</p>
    pub message: std::option::Option<std::string::String>,
}
impl InstallationMediaFailureCause {
    /// <p>The reason that an installation media import failed.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Debug for InstallationMediaFailureCause {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InstallationMediaFailureCause");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
/// See [`InstallationMediaFailureCause`](crate::model::InstallationMediaFailureCause)
pub mod installation_media_failure_cause {
    /// A builder for [`InstallationMediaFailureCause`](crate::model::InstallationMediaFailureCause)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The reason that an installation media import failed.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The reason that an installation media import failed.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InstallationMediaFailureCause`](crate::model::InstallationMediaFailureCause)
        pub fn build(self) -> crate::model::InstallationMediaFailureCause {
            crate::model::InstallationMediaFailureCause {
                message: self.message,
            }
        }
    }
}
impl InstallationMediaFailureCause {
    /// Creates a new builder-style object to manufacture [`InstallationMediaFailureCause`](crate::model::InstallationMediaFailureCause)
    pub fn builder() -> crate::model::installation_media_failure_cause::Builder {
        crate::model::installation_media_failure_cause::Builder::default()
    }
}

/// <p>Information about valid modifications that you can make to your DB instance. Contains the result of a successful call to the <code>DescribeValidDBInstanceModifications</code> action. You can use this information when you call <code>ModifyDBInstance</code>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidDbInstanceModificationsMessage {
    /// <p>Valid storage options for your DB instance. </p>
    pub storage: std::option::Option<std::vec::Vec<crate::model::ValidStorageOptions>>,
    /// <p>Valid processor features for your DB instance. </p>
    pub valid_processor_features:
        std::option::Option<std::vec::Vec<crate::model::AvailableProcessorFeature>>,
}
impl ValidDbInstanceModificationsMessage {
    /// <p>Valid storage options for your DB instance. </p>
    pub fn storage(&self) -> std::option::Option<&[crate::model::ValidStorageOptions]> {
        self.storage.as_deref()
    }
    /// <p>Valid processor features for your DB instance. </p>
    pub fn valid_processor_features(
        &self,
    ) -> std::option::Option<&[crate::model::AvailableProcessorFeature]> {
        self.valid_processor_features.as_deref()
    }
}
impl std::fmt::Debug for ValidDbInstanceModificationsMessage {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidDbInstanceModificationsMessage");
        formatter.field("storage", &self.storage);
        formatter.field("valid_processor_features", &self.valid_processor_features);
        formatter.finish()
    }
}
/// See [`ValidDbInstanceModificationsMessage`](crate::model::ValidDbInstanceModificationsMessage)
pub mod valid_db_instance_modifications_message {
    /// A builder for [`ValidDbInstanceModificationsMessage`](crate::model::ValidDbInstanceModificationsMessage)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) storage: std::option::Option<std::vec::Vec<crate::model::ValidStorageOptions>>,
        pub(crate) valid_processor_features:
            std::option::Option<std::vec::Vec<crate::model::AvailableProcessorFeature>>,
    }
    impl Builder {
        /// Appends an item to `storage`.
        ///
        /// To override the contents of this collection use [`set_storage`](Self::set_storage).
        ///
        /// <p>Valid storage options for your DB instance. </p>
        pub fn storage(mut self, input: crate::model::ValidStorageOptions) -> Self {
            let mut v = self.storage.unwrap_or_default();
            v.push(input);
            self.storage = Some(v);
            self
        }
        /// <p>Valid storage options for your DB instance. </p>
        pub fn set_storage(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ValidStorageOptions>>,
        ) -> Self {
            self.storage = input;
            self
        }
        /// Appends an item to `valid_processor_features`.
        ///
        /// To override the contents of this collection use [`set_valid_processor_features`](Self::set_valid_processor_features).
        ///
        /// <p>Valid processor features for your DB instance. </p>
        pub fn valid_processor_features(
            mut self,
            input: crate::model::AvailableProcessorFeature,
        ) -> Self {
            let mut v = self.valid_processor_features.unwrap_or_default();
            v.push(input);
            self.valid_processor_features = Some(v);
            self
        }
        /// <p>Valid processor features for your DB instance. </p>
        pub fn set_valid_processor_features(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AvailableProcessorFeature>>,
        ) -> Self {
            self.valid_processor_features = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidDbInstanceModificationsMessage`](crate::model::ValidDbInstanceModificationsMessage)
        pub fn build(self) -> crate::model::ValidDbInstanceModificationsMessage {
            crate::model::ValidDbInstanceModificationsMessage {
                storage: self.storage,
                valid_processor_features: self.valid_processor_features,
            }
        }
    }
}
impl ValidDbInstanceModificationsMessage {
    /// Creates a new builder-style object to manufacture [`ValidDbInstanceModificationsMessage`](crate::model::ValidDbInstanceModificationsMessage)
    pub fn builder() -> crate::model::valid_db_instance_modifications_message::Builder {
        crate::model::valid_db_instance_modifications_message::Builder::default()
    }
}

/// <p>Contains the available processor feature information for the DB instance class of a DB instance.</p>
/// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html#USER_ConfigureProcessor">Configuring the Processor of the DB Instance Class</a> in the <i>Amazon RDS User Guide. </i> </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AvailableProcessorFeature {
    /// <p>The name of the processor feature. Valid names are <code>coreCount</code> and <code>threadsPerCore</code>.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The default value for the processor feature of the DB instance class.</p>
    pub default_value: std::option::Option<std::string::String>,
    /// <p>The allowed values for the processor feature of the DB instance class.</p>
    pub allowed_values: std::option::Option<std::string::String>,
}
impl AvailableProcessorFeature {
    /// <p>The name of the processor feature. Valid names are <code>coreCount</code> and <code>threadsPerCore</code>.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The default value for the processor feature of the DB instance class.</p>
    pub fn default_value(&self) -> std::option::Option<&str> {
        self.default_value.as_deref()
    }
    /// <p>The allowed values for the processor feature of the DB instance class.</p>
    pub fn allowed_values(&self) -> std::option::Option<&str> {
        self.allowed_values.as_deref()
    }
}
impl std::fmt::Debug for AvailableProcessorFeature {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AvailableProcessorFeature");
        formatter.field("name", &self.name);
        formatter.field("default_value", &self.default_value);
        formatter.field("allowed_values", &self.allowed_values);
        formatter.finish()
    }
}
/// See [`AvailableProcessorFeature`](crate::model::AvailableProcessorFeature)
pub mod available_processor_feature {
    /// A builder for [`AvailableProcessorFeature`](crate::model::AvailableProcessorFeature)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) default_value: std::option::Option<std::string::String>,
        pub(crate) allowed_values: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the processor feature. Valid names are <code>coreCount</code> and <code>threadsPerCore</code>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the processor feature. Valid names are <code>coreCount</code> and <code>threadsPerCore</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The default value for the processor feature of the DB instance class.</p>
        pub fn default_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_value = Some(input.into());
            self
        }
        /// <p>The default value for the processor feature of the DB instance class.</p>
        pub fn set_default_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_value = input;
            self
        }
        /// <p>The allowed values for the processor feature of the DB instance class.</p>
        pub fn allowed_values(mut self, input: impl Into<std::string::String>) -> Self {
            self.allowed_values = Some(input.into());
            self
        }
        /// <p>The allowed values for the processor feature of the DB instance class.</p>
        pub fn set_allowed_values(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.allowed_values = input;
            self
        }
        /// Consumes the builder and constructs a [`AvailableProcessorFeature`](crate::model::AvailableProcessorFeature)
        pub fn build(self) -> crate::model::AvailableProcessorFeature {
            crate::model::AvailableProcessorFeature {
                name: self.name,
                default_value: self.default_value,
                allowed_values: self.allowed_values,
            }
        }
    }
}
impl AvailableProcessorFeature {
    /// Creates a new builder-style object to manufacture [`AvailableProcessorFeature`](crate::model::AvailableProcessorFeature)
    pub fn builder() -> crate::model::available_processor_feature::Builder {
        crate::model::available_processor_feature::Builder::default()
    }
}

/// <p>Information about valid modifications that you can make to your DB instance. Contains the result of a successful call to the <code>DescribeValidDBInstanceModifications</code> action. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidStorageOptions {
    /// <p>The valid storage types for your DB instance. For example, gp2, io1. </p>
    pub storage_type: std::option::Option<std::string::String>,
    /// <p>The valid range of storage in gibibytes (GiB). For example, 100 to 16384. </p>
    pub storage_size: std::option::Option<std::vec::Vec<crate::model::Range>>,
    /// <p>The valid range of provisioned IOPS. For example, 1000-20000. </p>
    pub provisioned_iops: std::option::Option<std::vec::Vec<crate::model::Range>>,
    /// <p>The valid range of Provisioned IOPS to gibibytes of storage multiplier. For example, 3-10, which means that provisioned IOPS can be between 3 and 10 times storage. </p>
    pub iops_to_storage_ratio: std::option::Option<std::vec::Vec<crate::model::DoubleRange>>,
    /// <p>Whether or not Amazon RDS can automatically scale storage for DB instances that use the new instance class.</p>
    pub supports_storage_autoscaling: bool,
}
impl ValidStorageOptions {
    /// <p>The valid storage types for your DB instance. For example, gp2, io1. </p>
    pub fn storage_type(&self) -> std::option::Option<&str> {
        self.storage_type.as_deref()
    }
    /// <p>The valid range of storage in gibibytes (GiB). For example, 100 to 16384. </p>
    pub fn storage_size(&self) -> std::option::Option<&[crate::model::Range]> {
        self.storage_size.as_deref()
    }
    /// <p>The valid range of provisioned IOPS. For example, 1000-20000. </p>
    pub fn provisioned_iops(&self) -> std::option::Option<&[crate::model::Range]> {
        self.provisioned_iops.as_deref()
    }
    /// <p>The valid range of Provisioned IOPS to gibibytes of storage multiplier. For example, 3-10, which means that provisioned IOPS can be between 3 and 10 times storage. </p>
    pub fn iops_to_storage_ratio(&self) -> std::option::Option<&[crate::model::DoubleRange]> {
        self.iops_to_storage_ratio.as_deref()
    }
    /// <p>Whether or not Amazon RDS can automatically scale storage for DB instances that use the new instance class.</p>
    pub fn supports_storage_autoscaling(&self) -> bool {
        self.supports_storage_autoscaling
    }
}
impl std::fmt::Debug for ValidStorageOptions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidStorageOptions");
        formatter.field("storage_type", &self.storage_type);
        formatter.field("storage_size", &self.storage_size);
        formatter.field("provisioned_iops", &self.provisioned_iops);
        formatter.field("iops_to_storage_ratio", &self.iops_to_storage_ratio);
        formatter.field(
            "supports_storage_autoscaling",
            &self.supports_storage_autoscaling,
        );
        formatter.finish()
    }
}
/// See [`ValidStorageOptions`](crate::model::ValidStorageOptions)
pub mod valid_storage_options {
    /// A builder for [`ValidStorageOptions`](crate::model::ValidStorageOptions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) storage_type: std::option::Option<std::string::String>,
        pub(crate) storage_size: std::option::Option<std::vec::Vec<crate::model::Range>>,
        pub(crate) provisioned_iops: std::option::Option<std::vec::Vec<crate::model::Range>>,
        pub(crate) iops_to_storage_ratio:
            std::option::Option<std::vec::Vec<crate::model::DoubleRange>>,
        pub(crate) supports_storage_autoscaling: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The valid storage types for your DB instance. For example, gp2, io1. </p>
        pub fn storage_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.storage_type = Some(input.into());
            self
        }
        /// <p>The valid storage types for your DB instance. For example, gp2, io1. </p>
        pub fn set_storage_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.storage_type = input;
            self
        }
        /// Appends an item to `storage_size`.
        ///
        /// To override the contents of this collection use [`set_storage_size`](Self::set_storage_size).
        ///
        /// <p>The valid range of storage in gibibytes (GiB). For example, 100 to 16384. </p>
        pub fn storage_size(mut self, input: crate::model::Range) -> Self {
            let mut v = self.storage_size.unwrap_or_default();
            v.push(input);
            self.storage_size = Some(v);
            self
        }
        /// <p>The valid range of storage in gibibytes (GiB). For example, 100 to 16384. </p>
        pub fn set_storage_size(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Range>>,
        ) -> Self {
            self.storage_size = input;
            self
        }
        /// Appends an item to `provisioned_iops`.
        ///
        /// To override the contents of this collection use [`set_provisioned_iops`](Self::set_provisioned_iops).
        ///
        /// <p>The valid range of provisioned IOPS. For example, 1000-20000. </p>
        pub fn provisioned_iops(mut self, input: crate::model::Range) -> Self {
            let mut v = self.provisioned_iops.unwrap_or_default();
            v.push(input);
            self.provisioned_iops = Some(v);
            self
        }
        /// <p>The valid range of provisioned IOPS. For example, 1000-20000. </p>
        pub fn set_provisioned_iops(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Range>>,
        ) -> Self {
            self.provisioned_iops = input;
            self
        }
        /// Appends an item to `iops_to_storage_ratio`.
        ///
        /// To override the contents of this collection use [`set_iops_to_storage_ratio`](Self::set_iops_to_storage_ratio).
        ///
        /// <p>The valid range of Provisioned IOPS to gibibytes of storage multiplier. For example, 3-10, which means that provisioned IOPS can be between 3 and 10 times storage. </p>
        pub fn iops_to_storage_ratio(mut self, input: crate::model::DoubleRange) -> Self {
            let mut v = self.iops_to_storage_ratio.unwrap_or_default();
            v.push(input);
            self.iops_to_storage_ratio = Some(v);
            self
        }
        /// <p>The valid range of Provisioned IOPS to gibibytes of storage multiplier. For example, 3-10, which means that provisioned IOPS can be between 3 and 10 times storage. </p>
        pub fn set_iops_to_storage_ratio(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DoubleRange>>,
        ) -> Self {
            self.iops_to_storage_ratio = input;
            self
        }
        /// <p>Whether or not Amazon RDS can automatically scale storage for DB instances that use the new instance class.</p>
        pub fn supports_storage_autoscaling(mut self, input: bool) -> Self {
            self.supports_storage_autoscaling = Some(input);
            self
        }
        /// <p>Whether or not Amazon RDS can automatically scale storage for DB instances that use the new instance class.</p>
        pub fn set_supports_storage_autoscaling(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.supports_storage_autoscaling = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidStorageOptions`](crate::model::ValidStorageOptions)
        pub fn build(self) -> crate::model::ValidStorageOptions {
            crate::model::ValidStorageOptions {
                storage_type: self.storage_type,
                storage_size: self.storage_size,
                provisioned_iops: self.provisioned_iops,
                iops_to_storage_ratio: self.iops_to_storage_ratio,
                supports_storage_autoscaling: self.supports_storage_autoscaling.unwrap_or_default(),
            }
        }
    }
}
impl ValidStorageOptions {
    /// Creates a new builder-style object to manufacture [`ValidStorageOptions`](crate::model::ValidStorageOptions)
    pub fn builder() -> crate::model::valid_storage_options::Builder {
        crate::model::valid_storage_options::Builder::default()
    }
}

/// <p>A range of double values.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DoubleRange {
    /// <p>The minimum value in the range.</p>
    pub from: f64,
    /// <p>The maximum value in the range.</p>
    pub to: f64,
}
impl DoubleRange {
    /// <p>The minimum value in the range.</p>
    pub fn from(&self) -> f64 {
        self.from
    }
    /// <p>The maximum value in the range.</p>
    pub fn to(&self) -> f64 {
        self.to
    }
}
impl std::fmt::Debug for DoubleRange {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DoubleRange");
        formatter.field("from", &self.from);
        formatter.field("to", &self.to);
        formatter.finish()
    }
}
/// See [`DoubleRange`](crate::model::DoubleRange)
pub mod double_range {
    /// A builder for [`DoubleRange`](crate::model::DoubleRange)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) from: std::option::Option<f64>,
        pub(crate) to: std::option::Option<f64>,
    }
    impl Builder {
        /// <p>The minimum value in the range.</p>
        pub fn from(mut self, input: f64) -> Self {
            self.from = Some(input);
            self
        }
        /// <p>The minimum value in the range.</p>
        pub fn set_from(mut self, input: std::option::Option<f64>) -> Self {
            self.from = input;
            self
        }
        /// <p>The maximum value in the range.</p>
        pub fn to(mut self, input: f64) -> Self {
            self.to = Some(input);
            self
        }
        /// <p>The maximum value in the range.</p>
        pub fn set_to(mut self, input: std::option::Option<f64>) -> Self {
            self.to = input;
            self
        }
        /// Consumes the builder and constructs a [`DoubleRange`](crate::model::DoubleRange)
        pub fn build(self) -> crate::model::DoubleRange {
            crate::model::DoubleRange {
                from: self.from.unwrap_or_default(),
                to: self.to.unwrap_or_default(),
            }
        }
    }
}
impl DoubleRange {
    /// Creates a new builder-style object to manufacture [`DoubleRange`](crate::model::DoubleRange)
    pub fn builder() -> crate::model::double_range::Builder {
        crate::model::double_range::Builder::default()
    }
}

/// <p>A range of integer values.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Range {
    /// <p>The minimum value in the range.</p>
    pub from: i32,
    /// <p>The maximum value in the range.</p>
    pub to: i32,
    /// <p>The step value for the range. For example, if you have a range of 5,000 to 10,000, with a step value of 1,000, the valid values start at 5,000 and step up by 1,000. Even though 7,500 is within the range, it isn't a valid value for the range. The valid values are 5,000, 6,000, 7,000, 8,000... </p>
    pub step: std::option::Option<i32>,
}
impl Range {
    /// <p>The minimum value in the range.</p>
    pub fn from(&self) -> i32 {
        self.from
    }
    /// <p>The maximum value in the range.</p>
    pub fn to(&self) -> i32 {
        self.to
    }
    /// <p>The step value for the range. For example, if you have a range of 5,000 to 10,000, with a step value of 1,000, the valid values start at 5,000 and step up by 1,000. Even though 7,500 is within the range, it isn't a valid value for the range. The valid values are 5,000, 6,000, 7,000, 8,000... </p>
    pub fn step(&self) -> std::option::Option<i32> {
        self.step
    }
}
impl std::fmt::Debug for Range {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Range");
        formatter.field("from", &self.from);
        formatter.field("to", &self.to);
        formatter.field("step", &self.step);
        formatter.finish()
    }
}
/// See [`Range`](crate::model::Range)
pub mod range {
    /// A builder for [`Range`](crate::model::Range)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) from: std::option::Option<i32>,
        pub(crate) to: std::option::Option<i32>,
        pub(crate) step: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The minimum value in the range.</p>
        pub fn from(mut self, input: i32) -> Self {
            self.from = Some(input);
            self
        }
        /// <p>The minimum value in the range.</p>
        pub fn set_from(mut self, input: std::option::Option<i32>) -> Self {
            self.from = input;
            self
        }
        /// <p>The maximum value in the range.</p>
        pub fn to(mut self, input: i32) -> Self {
            self.to = Some(input);
            self
        }
        /// <p>The maximum value in the range.</p>
        pub fn set_to(mut self, input: std::option::Option<i32>) -> Self {
            self.to = input;
            self
        }
        /// <p>The step value for the range. For example, if you have a range of 5,000 to 10,000, with a step value of 1,000, the valid values start at 5,000 and step up by 1,000. Even though 7,500 is within the range, it isn't a valid value for the range. The valid values are 5,000, 6,000, 7,000, 8,000... </p>
        pub fn step(mut self, input: i32) -> Self {
            self.step = Some(input);
            self
        }
        /// <p>The step value for the range. For example, if you have a range of 5,000 to 10,000, with a step value of 1,000, the valid values start at 5,000 and step up by 1,000. Even though 7,500 is within the range, it isn't a valid value for the range. The valid values are 5,000, 6,000, 7,000, 8,000... </p>
        pub fn set_step(mut self, input: std::option::Option<i32>) -> Self {
            self.step = input;
            self
        }
        /// Consumes the builder and constructs a [`Range`](crate::model::Range)
        pub fn build(self) -> crate::model::Range {
            crate::model::Range {
                from: self.from.unwrap_or_default(),
                to: self.to.unwrap_or_default(),
                step: self.step,
            }
        }
    }
}
impl Range {
    /// Creates a new builder-style object to manufacture [`Range`](crate::model::Range)
    pub fn builder() -> crate::model::range::Builder {
        crate::model::range::Builder::default()
    }
}

/// <p>Contains an Amazon Web Services Region name as the result of a successful call to the <code>DescribeSourceRegions</code> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SourceRegion {
    /// <p>The name of the source Amazon Web Services Region.</p>
    pub region_name: std::option::Option<std::string::String>,
    /// <p>The endpoint for the source Amazon Web Services Region endpoint.</p>
    pub endpoint: std::option::Option<std::string::String>,
    /// <p>The status of the source Amazon Web Services Region.</p>
    pub status: std::option::Option<std::string::String>,
    /// <p>Whether the source Amazon Web Services Region supports replicating automated backups to the current Amazon Web Services Region.</p>
    pub supports_db_instance_automated_backups_replication: bool,
}
impl SourceRegion {
    /// <p>The name of the source Amazon Web Services Region.</p>
    pub fn region_name(&self) -> std::option::Option<&str> {
        self.region_name.as_deref()
    }
    /// <p>The endpoint for the source Amazon Web Services Region endpoint.</p>
    pub fn endpoint(&self) -> std::option::Option<&str> {
        self.endpoint.as_deref()
    }
    /// <p>The status of the source Amazon Web Services Region.</p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>Whether the source Amazon Web Services Region supports replicating automated backups to the current Amazon Web Services Region.</p>
    pub fn supports_db_instance_automated_backups_replication(&self) -> bool {
        self.supports_db_instance_automated_backups_replication
    }
}
impl std::fmt::Debug for SourceRegion {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SourceRegion");
        formatter.field("region_name", &self.region_name);
        formatter.field("endpoint", &self.endpoint);
        formatter.field("status", &self.status);
        formatter.field(
            "supports_db_instance_automated_backups_replication",
            &self.supports_db_instance_automated_backups_replication,
        );
        formatter.finish()
    }
}
/// See [`SourceRegion`](crate::model::SourceRegion)
pub mod source_region {
    /// A builder for [`SourceRegion`](crate::model::SourceRegion)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) region_name: std::option::Option<std::string::String>,
        pub(crate) endpoint: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) supports_db_instance_automated_backups_replication: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The name of the source Amazon Web Services Region.</p>
        pub fn region_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.region_name = Some(input.into());
            self
        }
        /// <p>The name of the source Amazon Web Services Region.</p>
        pub fn set_region_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.region_name = input;
            self
        }
        /// <p>The endpoint for the source Amazon Web Services Region endpoint.</p>
        pub fn endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint = Some(input.into());
            self
        }
        /// <p>The endpoint for the source Amazon Web Services Region endpoint.</p>
        pub fn set_endpoint(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.endpoint = input;
            self
        }
        /// <p>The status of the source Amazon Web Services Region.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the source Amazon Web Services Region.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>Whether the source Amazon Web Services Region supports replicating automated backups to the current Amazon Web Services Region.</p>
        pub fn supports_db_instance_automated_backups_replication(mut self, input: bool) -> Self {
            self.supports_db_instance_automated_backups_replication = Some(input);
            self
        }
        /// <p>Whether the source Amazon Web Services Region supports replicating automated backups to the current Amazon Web Services Region.</p>
        pub fn set_supports_db_instance_automated_backups_replication(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.supports_db_instance_automated_backups_replication = input;
            self
        }
        /// Consumes the builder and constructs a [`SourceRegion`](crate::model::SourceRegion)
        pub fn build(self) -> crate::model::SourceRegion {
            crate::model::SourceRegion {
                region_name: self.region_name,
                endpoint: self.endpoint,
                status: self.status,
                supports_db_instance_automated_backups_replication: self
                    .supports_db_instance_automated_backups_replication
                    .unwrap_or_default(),
            }
        }
    }
}
impl SourceRegion {
    /// Creates a new builder-style object to manufacture [`SourceRegion`](crate::model::SourceRegion)
    pub fn builder() -> crate::model::source_region::Builder {
        crate::model::source_region::Builder::default()
    }
}

/// <p> This data type is used as a response element in the <code>DescribeReservedDBInstancesOfferings</code> action. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReservedDbInstancesOffering {
    /// <p>The offering identifier.</p>
    pub reserved_db_instances_offering_id: std::option::Option<std::string::String>,
    /// <p>The DB instance class for the reserved DB instance.</p>
    pub db_instance_class: std::option::Option<std::string::String>,
    /// <p>The duration of the offering in seconds.</p>
    pub duration: i32,
    /// <p>The fixed price charged for this offering.</p>
    pub fixed_price: f64,
    /// <p>The hourly price charged for this offering.</p>
    pub usage_price: f64,
    /// <p>The currency code for the reserved DB instance offering.</p>
    pub currency_code: std::option::Option<std::string::String>,
    /// <p>The database engine used by the offering.</p>
    pub product_description: std::option::Option<std::string::String>,
    /// <p>The offering type.</p>
    pub offering_type: std::option::Option<std::string::String>,
    /// <p>Indicates if the offering applies to Multi-AZ deployments.</p>
    pub multi_az: bool,
    /// <p>The recurring price charged to run this reserved DB instance.</p>
    pub recurring_charges: std::option::Option<std::vec::Vec<crate::model::RecurringCharge>>,
}
impl ReservedDbInstancesOffering {
    /// <p>The offering identifier.</p>
    pub fn reserved_db_instances_offering_id(&self) -> std::option::Option<&str> {
        self.reserved_db_instances_offering_id.as_deref()
    }
    /// <p>The DB instance class for the reserved DB instance.</p>
    pub fn db_instance_class(&self) -> std::option::Option<&str> {
        self.db_instance_class.as_deref()
    }
    /// <p>The duration of the offering in seconds.</p>
    pub fn duration(&self) -> i32 {
        self.duration
    }
    /// <p>The fixed price charged for this offering.</p>
    pub fn fixed_price(&self) -> f64 {
        self.fixed_price
    }
    /// <p>The hourly price charged for this offering.</p>
    pub fn usage_price(&self) -> f64 {
        self.usage_price
    }
    /// <p>The currency code for the reserved DB instance offering.</p>
    pub fn currency_code(&self) -> std::option::Option<&str> {
        self.currency_code.as_deref()
    }
    /// <p>The database engine used by the offering.</p>
    pub fn product_description(&self) -> std::option::Option<&str> {
        self.product_description.as_deref()
    }
    /// <p>The offering type.</p>
    pub fn offering_type(&self) -> std::option::Option<&str> {
        self.offering_type.as_deref()
    }
    /// <p>Indicates if the offering applies to Multi-AZ deployments.</p>
    pub fn multi_az(&self) -> bool {
        self.multi_az
    }
    /// <p>The recurring price charged to run this reserved DB instance.</p>
    pub fn recurring_charges(&self) -> std::option::Option<&[crate::model::RecurringCharge]> {
        self.recurring_charges.as_deref()
    }
}
impl std::fmt::Debug for ReservedDbInstancesOffering {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReservedDbInstancesOffering");
        formatter.field(
            "reserved_db_instances_offering_id",
            &self.reserved_db_instances_offering_id,
        );
        formatter.field("db_instance_class", &self.db_instance_class);
        formatter.field("duration", &self.duration);
        formatter.field("fixed_price", &self.fixed_price);
        formatter.field("usage_price", &self.usage_price);
        formatter.field("currency_code", &self.currency_code);
        formatter.field("product_description", &self.product_description);
        formatter.field("offering_type", &self.offering_type);
        formatter.field("multi_az", &self.multi_az);
        formatter.field("recurring_charges", &self.recurring_charges);
        formatter.finish()
    }
}
/// See [`ReservedDbInstancesOffering`](crate::model::ReservedDbInstancesOffering)
pub mod reserved_db_instances_offering {
    /// A builder for [`ReservedDbInstancesOffering`](crate::model::ReservedDbInstancesOffering)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) reserved_db_instances_offering_id: std::option::Option<std::string::String>,
        pub(crate) db_instance_class: std::option::Option<std::string::String>,
        pub(crate) duration: std::option::Option<i32>,
        pub(crate) fixed_price: std::option::Option<f64>,
        pub(crate) usage_price: std::option::Option<f64>,
        pub(crate) currency_code: std::option::Option<std::string::String>,
        pub(crate) product_description: std::option::Option<std::string::String>,
        pub(crate) offering_type: std::option::Option<std::string::String>,
        pub(crate) multi_az: std::option::Option<bool>,
        pub(crate) recurring_charges:
            std::option::Option<std::vec::Vec<crate::model::RecurringCharge>>,
    }
    impl Builder {
        /// <p>The offering identifier.</p>
        pub fn reserved_db_instances_offering_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.reserved_db_instances_offering_id = Some(input.into());
            self
        }
        /// <p>The offering identifier.</p>
        pub fn set_reserved_db_instances_offering_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.reserved_db_instances_offering_id = input;
            self
        }
        /// <p>The DB instance class for the reserved DB instance.</p>
        pub fn db_instance_class(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_instance_class = Some(input.into());
            self
        }
        /// <p>The DB instance class for the reserved DB instance.</p>
        pub fn set_db_instance_class(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_instance_class = input;
            self
        }
        /// <p>The duration of the offering in seconds.</p>
        pub fn duration(mut self, input: i32) -> Self {
            self.duration = Some(input);
            self
        }
        /// <p>The duration of the offering in seconds.</p>
        pub fn set_duration(mut self, input: std::option::Option<i32>) -> Self {
            self.duration = input;
            self
        }
        /// <p>The fixed price charged for this offering.</p>
        pub fn fixed_price(mut self, input: f64) -> Self {
            self.fixed_price = Some(input);
            self
        }
        /// <p>The fixed price charged for this offering.</p>
        pub fn set_fixed_price(mut self, input: std::option::Option<f64>) -> Self {
            self.fixed_price = input;
            self
        }
        /// <p>The hourly price charged for this offering.</p>
        pub fn usage_price(mut self, input: f64) -> Self {
            self.usage_price = Some(input);
            self
        }
        /// <p>The hourly price charged for this offering.</p>
        pub fn set_usage_price(mut self, input: std::option::Option<f64>) -> Self {
            self.usage_price = input;
            self
        }
        /// <p>The currency code for the reserved DB instance offering.</p>
        pub fn currency_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.currency_code = Some(input.into());
            self
        }
        /// <p>The currency code for the reserved DB instance offering.</p>
        pub fn set_currency_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.currency_code = input;
            self
        }
        /// <p>The database engine used by the offering.</p>
        pub fn product_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.product_description = Some(input.into());
            self
        }
        /// <p>The database engine used by the offering.</p>
        pub fn set_product_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.product_description = input;
            self
        }
        /// <p>The offering type.</p>
        pub fn offering_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.offering_type = Some(input.into());
            self
        }
        /// <p>The offering type.</p>
        pub fn set_offering_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.offering_type = input;
            self
        }
        /// <p>Indicates if the offering applies to Multi-AZ deployments.</p>
        pub fn multi_az(mut self, input: bool) -> Self {
            self.multi_az = Some(input);
            self
        }
        /// <p>Indicates if the offering applies to Multi-AZ deployments.</p>
        pub fn set_multi_az(mut self, input: std::option::Option<bool>) -> Self {
            self.multi_az = input;
            self
        }
        /// Appends an item to `recurring_charges`.
        ///
        /// To override the contents of this collection use [`set_recurring_charges`](Self::set_recurring_charges).
        ///
        /// <p>The recurring price charged to run this reserved DB instance.</p>
        pub fn recurring_charges(mut self, input: crate::model::RecurringCharge) -> Self {
            let mut v = self.recurring_charges.unwrap_or_default();
            v.push(input);
            self.recurring_charges = Some(v);
            self
        }
        /// <p>The recurring price charged to run this reserved DB instance.</p>
        pub fn set_recurring_charges(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RecurringCharge>>,
        ) -> Self {
            self.recurring_charges = input;
            self
        }
        /// Consumes the builder and constructs a [`ReservedDbInstancesOffering`](crate::model::ReservedDbInstancesOffering)
        pub fn build(self) -> crate::model::ReservedDbInstancesOffering {
            crate::model::ReservedDbInstancesOffering {
                reserved_db_instances_offering_id: self.reserved_db_instances_offering_id,
                db_instance_class: self.db_instance_class,
                duration: self.duration.unwrap_or_default(),
                fixed_price: self.fixed_price.unwrap_or_default(),
                usage_price: self.usage_price.unwrap_or_default(),
                currency_code: self.currency_code,
                product_description: self.product_description,
                offering_type: self.offering_type,
                multi_az: self.multi_az.unwrap_or_default(),
                recurring_charges: self.recurring_charges,
            }
        }
    }
}
impl ReservedDbInstancesOffering {
    /// Creates a new builder-style object to manufacture [`ReservedDbInstancesOffering`](crate::model::ReservedDbInstancesOffering)
    pub fn builder() -> crate::model::reserved_db_instances_offering::Builder {
        crate::model::reserved_db_instances_offering::Builder::default()
    }
}

/// <p>Describes the pending maintenance actions for a resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourcePendingMaintenanceActions {
    /// <p>The ARN of the resource that has pending maintenance actions.</p>
    pub resource_identifier: std::option::Option<std::string::String>,
    /// <p>A list that provides details about the pending maintenance actions for the resource.</p>
    pub pending_maintenance_action_details:
        std::option::Option<std::vec::Vec<crate::model::PendingMaintenanceAction>>,
}
impl ResourcePendingMaintenanceActions {
    /// <p>The ARN of the resource that has pending maintenance actions.</p>
    pub fn resource_identifier(&self) -> std::option::Option<&str> {
        self.resource_identifier.as_deref()
    }
    /// <p>A list that provides details about the pending maintenance actions for the resource.</p>
    pub fn pending_maintenance_action_details(
        &self,
    ) -> std::option::Option<&[crate::model::PendingMaintenanceAction]> {
        self.pending_maintenance_action_details.as_deref()
    }
}
impl std::fmt::Debug for ResourcePendingMaintenanceActions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourcePendingMaintenanceActions");
        formatter.field("resource_identifier", &self.resource_identifier);
        formatter.field(
            "pending_maintenance_action_details",
            &self.pending_maintenance_action_details,
        );
        formatter.finish()
    }
}
/// See [`ResourcePendingMaintenanceActions`](crate::model::ResourcePendingMaintenanceActions)
pub mod resource_pending_maintenance_actions {
    /// A builder for [`ResourcePendingMaintenanceActions`](crate::model::ResourcePendingMaintenanceActions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_identifier: std::option::Option<std::string::String>,
        pub(crate) pending_maintenance_action_details:
            std::option::Option<std::vec::Vec<crate::model::PendingMaintenanceAction>>,
    }
    impl Builder {
        /// <p>The ARN of the resource that has pending maintenance actions.</p>
        pub fn resource_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_identifier = Some(input.into());
            self
        }
        /// <p>The ARN of the resource that has pending maintenance actions.</p>
        pub fn set_resource_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_identifier = input;
            self
        }
        /// Appends an item to `pending_maintenance_action_details`.
        ///
        /// To override the contents of this collection use [`set_pending_maintenance_action_details`](Self::set_pending_maintenance_action_details).
        ///
        /// <p>A list that provides details about the pending maintenance actions for the resource.</p>
        pub fn pending_maintenance_action_details(
            mut self,
            input: crate::model::PendingMaintenanceAction,
        ) -> Self {
            let mut v = self.pending_maintenance_action_details.unwrap_or_default();
            v.push(input);
            self.pending_maintenance_action_details = Some(v);
            self
        }
        /// <p>A list that provides details about the pending maintenance actions for the resource.</p>
        pub fn set_pending_maintenance_action_details(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PendingMaintenanceAction>>,
        ) -> Self {
            self.pending_maintenance_action_details = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourcePendingMaintenanceActions`](crate::model::ResourcePendingMaintenanceActions)
        pub fn build(self) -> crate::model::ResourcePendingMaintenanceActions {
            crate::model::ResourcePendingMaintenanceActions {
                resource_identifier: self.resource_identifier,
                pending_maintenance_action_details: self.pending_maintenance_action_details,
            }
        }
    }
}
impl ResourcePendingMaintenanceActions {
    /// Creates a new builder-style object to manufacture [`ResourcePendingMaintenanceActions`](crate::model::ResourcePendingMaintenanceActions)
    pub fn builder() -> crate::model::resource_pending_maintenance_actions::Builder {
        crate::model::resource_pending_maintenance_actions::Builder::default()
    }
}

/// <p>Provides information about a pending maintenance action for a resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PendingMaintenanceAction {
    /// <p>The type of pending maintenance action that is available for the resource. Valid actions are <code>system-update</code>, <code>db-upgrade</code>, <code>hardware-maintenance</code>, and <code>ca-certificate-rotation</code>.</p>
    pub action: std::option::Option<std::string::String>,
    /// <p>The date of the maintenance window when the action is applied. The maintenance action is applied to the resource during its first maintenance window after this date.</p>
    pub auto_applied_after_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The date when the maintenance action is automatically applied.</p>
    /// <p>On this date, the maintenance action is applied to the resource as soon as possible, regardless of the maintenance window for the resource. There might be a delay of one or more days from this date before the maintenance action is applied.</p>
    pub forced_apply_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Indicates the type of opt-in request that has been received for the resource.</p>
    pub opt_in_status: std::option::Option<std::string::String>,
    /// <p>The effective date when the pending maintenance action is applied to the resource. This date takes into account opt-in requests received from the <code>ApplyPendingMaintenanceAction</code> API, the <code>AutoAppliedAfterDate</code>, and the <code>ForcedApplyDate</code>. This value is blank if an opt-in request has not been received and nothing has been specified as <code>AutoAppliedAfterDate</code> or <code>ForcedApplyDate</code>.</p>
    pub current_apply_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>A description providing more detail about the maintenance action.</p>
    pub description: std::option::Option<std::string::String>,
}
impl PendingMaintenanceAction {
    /// <p>The type of pending maintenance action that is available for the resource. Valid actions are <code>system-update</code>, <code>db-upgrade</code>, <code>hardware-maintenance</code>, and <code>ca-certificate-rotation</code>.</p>
    pub fn action(&self) -> std::option::Option<&str> {
        self.action.as_deref()
    }
    /// <p>The date of the maintenance window when the action is applied. The maintenance action is applied to the resource during its first maintenance window after this date.</p>
    pub fn auto_applied_after_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.auto_applied_after_date.as_ref()
    }
    /// <p>The date when the maintenance action is automatically applied.</p>
    /// <p>On this date, the maintenance action is applied to the resource as soon as possible, regardless of the maintenance window for the resource. There might be a delay of one or more days from this date before the maintenance action is applied.</p>
    pub fn forced_apply_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.forced_apply_date.as_ref()
    }
    /// <p>Indicates the type of opt-in request that has been received for the resource.</p>
    pub fn opt_in_status(&self) -> std::option::Option<&str> {
        self.opt_in_status.as_deref()
    }
    /// <p>The effective date when the pending maintenance action is applied to the resource. This date takes into account opt-in requests received from the <code>ApplyPendingMaintenanceAction</code> API, the <code>AutoAppliedAfterDate</code>, and the <code>ForcedApplyDate</code>. This value is blank if an opt-in request has not been received and nothing has been specified as <code>AutoAppliedAfterDate</code> or <code>ForcedApplyDate</code>.</p>
    pub fn current_apply_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.current_apply_date.as_ref()
    }
    /// <p>A description providing more detail about the maintenance action.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
}
impl std::fmt::Debug for PendingMaintenanceAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PendingMaintenanceAction");
        formatter.field("action", &self.action);
        formatter.field("auto_applied_after_date", &self.auto_applied_after_date);
        formatter.field("forced_apply_date", &self.forced_apply_date);
        formatter.field("opt_in_status", &self.opt_in_status);
        formatter.field("current_apply_date", &self.current_apply_date);
        formatter.field("description", &self.description);
        formatter.finish()
    }
}
/// See [`PendingMaintenanceAction`](crate::model::PendingMaintenanceAction)
pub mod pending_maintenance_action {
    /// A builder for [`PendingMaintenanceAction`](crate::model::PendingMaintenanceAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) action: std::option::Option<std::string::String>,
        pub(crate) auto_applied_after_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) forced_apply_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) opt_in_status: std::option::Option<std::string::String>,
        pub(crate) current_apply_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) description: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The type of pending maintenance action that is available for the resource. Valid actions are <code>system-update</code>, <code>db-upgrade</code>, <code>hardware-maintenance</code>, and <code>ca-certificate-rotation</code>.</p>
        pub fn action(mut self, input: impl Into<std::string::String>) -> Self {
            self.action = Some(input.into());
            self
        }
        /// <p>The type of pending maintenance action that is available for the resource. Valid actions are <code>system-update</code>, <code>db-upgrade</code>, <code>hardware-maintenance</code>, and <code>ca-certificate-rotation</code>.</p>
        pub fn set_action(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.action = input;
            self
        }
        /// <p>The date of the maintenance window when the action is applied. The maintenance action is applied to the resource during its first maintenance window after this date.</p>
        pub fn auto_applied_after_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.auto_applied_after_date = Some(input);
            self
        }
        /// <p>The date of the maintenance window when the action is applied. The maintenance action is applied to the resource during its first maintenance window after this date.</p>
        pub fn set_auto_applied_after_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.auto_applied_after_date = input;
            self
        }
        /// <p>The date when the maintenance action is automatically applied.</p>
        /// <p>On this date, the maintenance action is applied to the resource as soon as possible, regardless of the maintenance window for the resource. There might be a delay of one or more days from this date before the maintenance action is applied.</p>
        pub fn forced_apply_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.forced_apply_date = Some(input);
            self
        }
        /// <p>The date when the maintenance action is automatically applied.</p>
        /// <p>On this date, the maintenance action is applied to the resource as soon as possible, regardless of the maintenance window for the resource. There might be a delay of one or more days from this date before the maintenance action is applied.</p>
        pub fn set_forced_apply_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.forced_apply_date = input;
            self
        }
        /// <p>Indicates the type of opt-in request that has been received for the resource.</p>
        pub fn opt_in_status(mut self, input: impl Into<std::string::String>) -> Self {
            self.opt_in_status = Some(input.into());
            self
        }
        /// <p>Indicates the type of opt-in request that has been received for the resource.</p>
        pub fn set_opt_in_status(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.opt_in_status = input;
            self
        }
        /// <p>The effective date when the pending maintenance action is applied to the resource. This date takes into account opt-in requests received from the <code>ApplyPendingMaintenanceAction</code> API, the <code>AutoAppliedAfterDate</code>, and the <code>ForcedApplyDate</code>. This value is blank if an opt-in request has not been received and nothing has been specified as <code>AutoAppliedAfterDate</code> or <code>ForcedApplyDate</code>.</p>
        pub fn current_apply_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.current_apply_date = Some(input);
            self
        }
        /// <p>The effective date when the pending maintenance action is applied to the resource. This date takes into account opt-in requests received from the <code>ApplyPendingMaintenanceAction</code> API, the <code>AutoAppliedAfterDate</code>, and the <code>ForcedApplyDate</code>. This value is blank if an opt-in request has not been received and nothing has been specified as <code>AutoAppliedAfterDate</code> or <code>ForcedApplyDate</code>.</p>
        pub fn set_current_apply_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.current_apply_date = input;
            self
        }
        /// <p>A description providing more detail about the maintenance action.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description providing more detail about the maintenance action.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Consumes the builder and constructs a [`PendingMaintenanceAction`](crate::model::PendingMaintenanceAction)
        pub fn build(self) -> crate::model::PendingMaintenanceAction {
            crate::model::PendingMaintenanceAction {
                action: self.action,
                auto_applied_after_date: self.auto_applied_after_date,
                forced_apply_date: self.forced_apply_date,
                opt_in_status: self.opt_in_status,
                current_apply_date: self.current_apply_date,
                description: self.description,
            }
        }
    }
}
impl PendingMaintenanceAction {
    /// Creates a new builder-style object to manufacture [`PendingMaintenanceAction`](crate::model::PendingMaintenanceAction)
    pub fn builder() -> crate::model::pending_maintenance_action::Builder {
        crate::model::pending_maintenance_action::Builder::default()
    }
}

/// <p>Contains a list of available options for a DB instance.</p>
/// <p> This data type is used as a response element in the <code>DescribeOrderableDBInstanceOptions</code> action. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OrderableDbInstanceOption {
    /// <p>The engine type of a DB instance.</p>
    pub engine: std::option::Option<std::string::String>,
    /// <p>The engine version of a DB instance.</p>
    pub engine_version: std::option::Option<std::string::String>,
    /// <p>The DB instance class for a DB instance.</p>
    pub db_instance_class: std::option::Option<std::string::String>,
    /// <p>The license model for a DB instance.</p>
    pub license_model: std::option::Option<std::string::String>,
    /// <p>The Availability Zone group for a DB instance.</p>
    pub availability_zone_group: std::option::Option<std::string::String>,
    /// <p>A list of Availability Zones for a DB instance.</p>
    pub availability_zones: std::option::Option<std::vec::Vec<crate::model::AvailabilityZone>>,
    /// <p>Indicates whether a DB instance is Multi-AZ capable.</p>
    pub multi_az_capable: bool,
    /// <p>Indicates whether a DB instance can have a read replica.</p>
    pub read_replica_capable: bool,
    /// <p>Indicates whether a DB instance is in a VPC.</p>
    pub vpc: bool,
    /// <p>Indicates whether a DB instance supports encrypted storage.</p>
    pub supports_storage_encryption: bool,
    /// <p>Indicates the storage type for a DB instance.</p>
    pub storage_type: std::option::Option<std::string::String>,
    /// <p>Indicates whether a DB instance supports provisioned IOPS.</p>
    pub supports_iops: bool,
    /// <p>Indicates whether a DB instance supports Enhanced Monitoring at intervals from 1 to 60 seconds.</p>
    pub supports_enhanced_monitoring: bool,
    /// <p>Indicates whether a DB instance supports IAM database authentication.</p>
    pub supports_iam_database_authentication: bool,
    /// <p>True if a DB instance supports Performance Insights, otherwise false.</p>
    pub supports_performance_insights: bool,
    /// <p>Minimum storage size for a DB instance.</p>
    pub min_storage_size: std::option::Option<i32>,
    /// <p>Maximum storage size for a DB instance.</p>
    pub max_storage_size: std::option::Option<i32>,
    /// <p>Minimum total provisioned IOPS for a DB instance.</p>
    pub min_iops_per_db_instance: std::option::Option<i32>,
    /// <p>Maximum total provisioned IOPS for a DB instance.</p>
    pub max_iops_per_db_instance: std::option::Option<i32>,
    /// <p>Minimum provisioned IOPS per GiB for a DB instance.</p>
    pub min_iops_per_gib: std::option::Option<f64>,
    /// <p>Maximum provisioned IOPS per GiB for a DB instance.</p>
    pub max_iops_per_gib: std::option::Option<f64>,
    /// <p>A list of the available processor features for the DB instance class of a DB instance.</p>
    pub available_processor_features:
        std::option::Option<std::vec::Vec<crate::model::AvailableProcessorFeature>>,
    /// <p>A list of the supported DB engine modes.</p>
    pub supported_engine_modes: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Whether Amazon RDS can automatically scale storage for DB instances that use the specified DB instance class.</p>
    pub supports_storage_autoscaling: std::option::Option<bool>,
    /// <p>Whether a DB instance supports Kerberos Authentication.</p>
    pub supports_kerberos_authentication: std::option::Option<bool>,
    /// <p>Whether a DB instance supports RDS on Outposts.</p>
    /// <p>For more information about RDS on Outposts, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html">Amazon RDS on Amazon Web Services Outposts</a> in the <i>Amazon RDS User Guide.</i> </p>
    pub outpost_capable: bool,
    /// <p>The list of supported modes for Database Activity Streams. Aurora PostgreSQL returns the value <code>[sync, async]</code>. Aurora MySQL and RDS for Oracle return <code>[async]</code> only. If Database Activity Streams isn't supported, the return value is an empty list.</p>
    pub supported_activity_stream_modes: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A value that indicates whether you can use Aurora global databases with a specific combination of other DB engine attributes.</p>
    pub supports_global_databases: bool,
    /// <p>Whether DB instances can be configured as a Multi-AZ DB cluster.</p>
    /// <p>The Multi-AZ DB clusters feature is in preview and is subject to change.</p>
    /// <p>For more information on Multi-AZ DB clusters, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ deployments with two readable standby DB instances</a> in the <i>Amazon RDS User Guide.</i> </p>
    pub supports_clusters: bool,
}
impl OrderableDbInstanceOption {
    /// <p>The engine type of a DB instance.</p>
    pub fn engine(&self) -> std::option::Option<&str> {
        self.engine.as_deref()
    }
    /// <p>The engine version of a DB instance.</p>
    pub fn engine_version(&self) -> std::option::Option<&str> {
        self.engine_version.as_deref()
    }
    /// <p>The DB instance class for a DB instance.</p>
    pub fn db_instance_class(&self) -> std::option::Option<&str> {
        self.db_instance_class.as_deref()
    }
    /// <p>The license model for a DB instance.</p>
    pub fn license_model(&self) -> std::option::Option<&str> {
        self.license_model.as_deref()
    }
    /// <p>The Availability Zone group for a DB instance.</p>
    pub fn availability_zone_group(&self) -> std::option::Option<&str> {
        self.availability_zone_group.as_deref()
    }
    /// <p>A list of Availability Zones for a DB instance.</p>
    pub fn availability_zones(&self) -> std::option::Option<&[crate::model::AvailabilityZone]> {
        self.availability_zones.as_deref()
    }
    /// <p>Indicates whether a DB instance is Multi-AZ capable.</p>
    pub fn multi_az_capable(&self) -> bool {
        self.multi_az_capable
    }
    /// <p>Indicates whether a DB instance can have a read replica.</p>
    pub fn read_replica_capable(&self) -> bool {
        self.read_replica_capable
    }
    /// <p>Indicates whether a DB instance is in a VPC.</p>
    pub fn vpc(&self) -> bool {
        self.vpc
    }
    /// <p>Indicates whether a DB instance supports encrypted storage.</p>
    pub fn supports_storage_encryption(&self) -> bool {
        self.supports_storage_encryption
    }
    /// <p>Indicates the storage type for a DB instance.</p>
    pub fn storage_type(&self) -> std::option::Option<&str> {
        self.storage_type.as_deref()
    }
    /// <p>Indicates whether a DB instance supports provisioned IOPS.</p>
    pub fn supports_iops(&self) -> bool {
        self.supports_iops
    }
    /// <p>Indicates whether a DB instance supports Enhanced Monitoring at intervals from 1 to 60 seconds.</p>
    pub fn supports_enhanced_monitoring(&self) -> bool {
        self.supports_enhanced_monitoring
    }
    /// <p>Indicates whether a DB instance supports IAM database authentication.</p>
    pub fn supports_iam_database_authentication(&self) -> bool {
        self.supports_iam_database_authentication
    }
    /// <p>True if a DB instance supports Performance Insights, otherwise false.</p>
    pub fn supports_performance_insights(&self) -> bool {
        self.supports_performance_insights
    }
    /// <p>Minimum storage size for a DB instance.</p>
    pub fn min_storage_size(&self) -> std::option::Option<i32> {
        self.min_storage_size
    }
    /// <p>Maximum storage size for a DB instance.</p>
    pub fn max_storage_size(&self) -> std::option::Option<i32> {
        self.max_storage_size
    }
    /// <p>Minimum total provisioned IOPS for a DB instance.</p>
    pub fn min_iops_per_db_instance(&self) -> std::option::Option<i32> {
        self.min_iops_per_db_instance
    }
    /// <p>Maximum total provisioned IOPS for a DB instance.</p>
    pub fn max_iops_per_db_instance(&self) -> std::option::Option<i32> {
        self.max_iops_per_db_instance
    }
    /// <p>Minimum provisioned IOPS per GiB for a DB instance.</p>
    pub fn min_iops_per_gib(&self) -> std::option::Option<f64> {
        self.min_iops_per_gib
    }
    /// <p>Maximum provisioned IOPS per GiB for a DB instance.</p>
    pub fn max_iops_per_gib(&self) -> std::option::Option<f64> {
        self.max_iops_per_gib
    }
    /// <p>A list of the available processor features for the DB instance class of a DB instance.</p>
    pub fn available_processor_features(
        &self,
    ) -> std::option::Option<&[crate::model::AvailableProcessorFeature]> {
        self.available_processor_features.as_deref()
    }
    /// <p>A list of the supported DB engine modes.</p>
    pub fn supported_engine_modes(&self) -> std::option::Option<&[std::string::String]> {
        self.supported_engine_modes.as_deref()
    }
    /// <p>Whether Amazon RDS can automatically scale storage for DB instances that use the specified DB instance class.</p>
    pub fn supports_storage_autoscaling(&self) -> std::option::Option<bool> {
        self.supports_storage_autoscaling
    }
    /// <p>Whether a DB instance supports Kerberos Authentication.</p>
    pub fn supports_kerberos_authentication(&self) -> std::option::Option<bool> {
        self.supports_kerberos_authentication
    }
    /// <p>Whether a DB instance supports RDS on Outposts.</p>
    /// <p>For more information about RDS on Outposts, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html">Amazon RDS on Amazon Web Services Outposts</a> in the <i>Amazon RDS User Guide.</i> </p>
    pub fn outpost_capable(&self) -> bool {
        self.outpost_capable
    }
    /// <p>The list of supported modes for Database Activity Streams. Aurora PostgreSQL returns the value <code>[sync, async]</code>. Aurora MySQL and RDS for Oracle return <code>[async]</code> only. If Database Activity Streams isn't supported, the return value is an empty list.</p>
    pub fn supported_activity_stream_modes(&self) -> std::option::Option<&[std::string::String]> {
        self.supported_activity_stream_modes.as_deref()
    }
    /// <p>A value that indicates whether you can use Aurora global databases with a specific combination of other DB engine attributes.</p>
    pub fn supports_global_databases(&self) -> bool {
        self.supports_global_databases
    }
    /// <p>Whether DB instances can be configured as a Multi-AZ DB cluster.</p>
    /// <p>The Multi-AZ DB clusters feature is in preview and is subject to change.</p>
    /// <p>For more information on Multi-AZ DB clusters, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ deployments with two readable standby DB instances</a> in the <i>Amazon RDS User Guide.</i> </p>
    pub fn supports_clusters(&self) -> bool {
        self.supports_clusters
    }
}
impl std::fmt::Debug for OrderableDbInstanceOption {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OrderableDbInstanceOption");
        formatter.field("engine", &self.engine);
        formatter.field("engine_version", &self.engine_version);
        formatter.field("db_instance_class", &self.db_instance_class);
        formatter.field("license_model", &self.license_model);
        formatter.field("availability_zone_group", &self.availability_zone_group);
        formatter.field("availability_zones", &self.availability_zones);
        formatter.field("multi_az_capable", &self.multi_az_capable);
        formatter.field("read_replica_capable", &self.read_replica_capable);
        formatter.field("vpc", &self.vpc);
        formatter.field(
            "supports_storage_encryption",
            &self.supports_storage_encryption,
        );
        formatter.field("storage_type", &self.storage_type);
        formatter.field("supports_iops", &self.supports_iops);
        formatter.field(
            "supports_enhanced_monitoring",
            &self.supports_enhanced_monitoring,
        );
        formatter.field(
            "supports_iam_database_authentication",
            &self.supports_iam_database_authentication,
        );
        formatter.field(
            "supports_performance_insights",
            &self.supports_performance_insights,
        );
        formatter.field("min_storage_size", &self.min_storage_size);
        formatter.field("max_storage_size", &self.max_storage_size);
        formatter.field("min_iops_per_db_instance", &self.min_iops_per_db_instance);
        formatter.field("max_iops_per_db_instance", &self.max_iops_per_db_instance);
        formatter.field("min_iops_per_gib", &self.min_iops_per_gib);
        formatter.field("max_iops_per_gib", &self.max_iops_per_gib);
        formatter.field(
            "available_processor_features",
            &self.available_processor_features,
        );
        formatter.field("supported_engine_modes", &self.supported_engine_modes);
        formatter.field(
            "supports_storage_autoscaling",
            &self.supports_storage_autoscaling,
        );
        formatter.field(
            "supports_kerberos_authentication",
            &self.supports_kerberos_authentication,
        );
        formatter.field("outpost_capable", &self.outpost_capable);
        formatter.field(
            "supported_activity_stream_modes",
            &self.supported_activity_stream_modes,
        );
        formatter.field("supports_global_databases", &self.supports_global_databases);
        formatter.field("supports_clusters", &self.supports_clusters);
        formatter.finish()
    }
}
/// See [`OrderableDbInstanceOption`](crate::model::OrderableDbInstanceOption)
pub mod orderable_db_instance_option {
    /// A builder for [`OrderableDbInstanceOption`](crate::model::OrderableDbInstanceOption)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) engine: std::option::Option<std::string::String>,
        pub(crate) engine_version: std::option::Option<std::string::String>,
        pub(crate) db_instance_class: std::option::Option<std::string::String>,
        pub(crate) license_model: std::option::Option<std::string::String>,
        pub(crate) availability_zone_group: std::option::Option<std::string::String>,
        pub(crate) availability_zones:
            std::option::Option<std::vec::Vec<crate::model::AvailabilityZone>>,
        pub(crate) multi_az_capable: std::option::Option<bool>,
        pub(crate) read_replica_capable: std::option::Option<bool>,
        pub(crate) vpc: std::option::Option<bool>,
        pub(crate) supports_storage_encryption: std::option::Option<bool>,
        pub(crate) storage_type: std::option::Option<std::string::String>,
        pub(crate) supports_iops: std::option::Option<bool>,
        pub(crate) supports_enhanced_monitoring: std::option::Option<bool>,
        pub(crate) supports_iam_database_authentication: std::option::Option<bool>,
        pub(crate) supports_performance_insights: std::option::Option<bool>,
        pub(crate) min_storage_size: std::option::Option<i32>,
        pub(crate) max_storage_size: std::option::Option<i32>,
        pub(crate) min_iops_per_db_instance: std::option::Option<i32>,
        pub(crate) max_iops_per_db_instance: std::option::Option<i32>,
        pub(crate) min_iops_per_gib: std::option::Option<f64>,
        pub(crate) max_iops_per_gib: std::option::Option<f64>,
        pub(crate) available_processor_features:
            std::option::Option<std::vec::Vec<crate::model::AvailableProcessorFeature>>,
        pub(crate) supported_engine_modes: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) supports_storage_autoscaling: std::option::Option<bool>,
        pub(crate) supports_kerberos_authentication: std::option::Option<bool>,
        pub(crate) outpost_capable: std::option::Option<bool>,
        pub(crate) supported_activity_stream_modes:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) supports_global_databases: std::option::Option<bool>,
        pub(crate) supports_clusters: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The engine type of a DB instance.</p>
        pub fn engine(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine = Some(input.into());
            self
        }
        /// <p>The engine type of a DB instance.</p>
        pub fn set_engine(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.engine = input;
            self
        }
        /// <p>The engine version of a DB instance.</p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_version = Some(input.into());
            self
        }
        /// <p>The engine version of a DB instance.</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.engine_version = input;
            self
        }
        /// <p>The DB instance class for a DB instance.</p>
        pub fn db_instance_class(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_instance_class = Some(input.into());
            self
        }
        /// <p>The DB instance class for a DB instance.</p>
        pub fn set_db_instance_class(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_instance_class = input;
            self
        }
        /// <p>The license model for a DB instance.</p>
        pub fn license_model(mut self, input: impl Into<std::string::String>) -> Self {
            self.license_model = Some(input.into());
            self
        }
        /// <p>The license model for a DB instance.</p>
        pub fn set_license_model(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.license_model = input;
            self
        }
        /// <p>The Availability Zone group for a DB instance.</p>
        pub fn availability_zone_group(mut self, input: impl Into<std::string::String>) -> Self {
            self.availability_zone_group = Some(input.into());
            self
        }
        /// <p>The Availability Zone group for a DB instance.</p>
        pub fn set_availability_zone_group(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.availability_zone_group = input;
            self
        }
        /// Appends an item to `availability_zones`.
        ///
        /// To override the contents of this collection use [`set_availability_zones`](Self::set_availability_zones).
        ///
        /// <p>A list of Availability Zones for a DB instance.</p>
        pub fn availability_zones(mut self, input: crate::model::AvailabilityZone) -> Self {
            let mut v = self.availability_zones.unwrap_or_default();
            v.push(input);
            self.availability_zones = Some(v);
            self
        }
        /// <p>A list of Availability Zones for a DB instance.</p>
        pub fn set_availability_zones(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AvailabilityZone>>,
        ) -> Self {
            self.availability_zones = input;
            self
        }
        /// <p>Indicates whether a DB instance is Multi-AZ capable.</p>
        pub fn multi_az_capable(mut self, input: bool) -> Self {
            self.multi_az_capable = Some(input);
            self
        }
        /// <p>Indicates whether a DB instance is Multi-AZ capable.</p>
        pub fn set_multi_az_capable(mut self, input: std::option::Option<bool>) -> Self {
            self.multi_az_capable = input;
            self
        }
        /// <p>Indicates whether a DB instance can have a read replica.</p>
        pub fn read_replica_capable(mut self, input: bool) -> Self {
            self.read_replica_capable = Some(input);
            self
        }
        /// <p>Indicates whether a DB instance can have a read replica.</p>
        pub fn set_read_replica_capable(mut self, input: std::option::Option<bool>) -> Self {
            self.read_replica_capable = input;
            self
        }
        /// <p>Indicates whether a DB instance is in a VPC.</p>
        pub fn vpc(mut self, input: bool) -> Self {
            self.vpc = Some(input);
            self
        }
        /// <p>Indicates whether a DB instance is in a VPC.</p>
        pub fn set_vpc(mut self, input: std::option::Option<bool>) -> Self {
            self.vpc = input;
            self
        }
        /// <p>Indicates whether a DB instance supports encrypted storage.</p>
        pub fn supports_storage_encryption(mut self, input: bool) -> Self {
            self.supports_storage_encryption = Some(input);
            self
        }
        /// <p>Indicates whether a DB instance supports encrypted storage.</p>
        pub fn set_supports_storage_encryption(mut self, input: std::option::Option<bool>) -> Self {
            self.supports_storage_encryption = input;
            self
        }
        /// <p>Indicates the storage type for a DB instance.</p>
        pub fn storage_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.storage_type = Some(input.into());
            self
        }
        /// <p>Indicates the storage type for a DB instance.</p>
        pub fn set_storage_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.storage_type = input;
            self
        }
        /// <p>Indicates whether a DB instance supports provisioned IOPS.</p>
        pub fn supports_iops(mut self, input: bool) -> Self {
            self.supports_iops = Some(input);
            self
        }
        /// <p>Indicates whether a DB instance supports provisioned IOPS.</p>
        pub fn set_supports_iops(mut self, input: std::option::Option<bool>) -> Self {
            self.supports_iops = input;
            self
        }
        /// <p>Indicates whether a DB instance supports Enhanced Monitoring at intervals from 1 to 60 seconds.</p>
        pub fn supports_enhanced_monitoring(mut self, input: bool) -> Self {
            self.supports_enhanced_monitoring = Some(input);
            self
        }
        /// <p>Indicates whether a DB instance supports Enhanced Monitoring at intervals from 1 to 60 seconds.</p>
        pub fn set_supports_enhanced_monitoring(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.supports_enhanced_monitoring = input;
            self
        }
        /// <p>Indicates whether a DB instance supports IAM database authentication.</p>
        pub fn supports_iam_database_authentication(mut self, input: bool) -> Self {
            self.supports_iam_database_authentication = Some(input);
            self
        }
        /// <p>Indicates whether a DB instance supports IAM database authentication.</p>
        pub fn set_supports_iam_database_authentication(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.supports_iam_database_authentication = input;
            self
        }
        /// <p>True if a DB instance supports Performance Insights, otherwise false.</p>
        pub fn supports_performance_insights(mut self, input: bool) -> Self {
            self.supports_performance_insights = Some(input);
            self
        }
        /// <p>True if a DB instance supports Performance Insights, otherwise false.</p>
        pub fn set_supports_performance_insights(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.supports_performance_insights = input;
            self
        }
        /// <p>Minimum storage size for a DB instance.</p>
        pub fn min_storage_size(mut self, input: i32) -> Self {
            self.min_storage_size = Some(input);
            self
        }
        /// <p>Minimum storage size for a DB instance.</p>
        pub fn set_min_storage_size(mut self, input: std::option::Option<i32>) -> Self {
            self.min_storage_size = input;
            self
        }
        /// <p>Maximum storage size for a DB instance.</p>
        pub fn max_storage_size(mut self, input: i32) -> Self {
            self.max_storage_size = Some(input);
            self
        }
        /// <p>Maximum storage size for a DB instance.</p>
        pub fn set_max_storage_size(mut self, input: std::option::Option<i32>) -> Self {
            self.max_storage_size = input;
            self
        }
        /// <p>Minimum total provisioned IOPS for a DB instance.</p>
        pub fn min_iops_per_db_instance(mut self, input: i32) -> Self {
            self.min_iops_per_db_instance = Some(input);
            self
        }
        /// <p>Minimum total provisioned IOPS for a DB instance.</p>
        pub fn set_min_iops_per_db_instance(mut self, input: std::option::Option<i32>) -> Self {
            self.min_iops_per_db_instance = input;
            self
        }
        /// <p>Maximum total provisioned IOPS for a DB instance.</p>
        pub fn max_iops_per_db_instance(mut self, input: i32) -> Self {
            self.max_iops_per_db_instance = Some(input);
            self
        }
        /// <p>Maximum total provisioned IOPS for a DB instance.</p>
        pub fn set_max_iops_per_db_instance(mut self, input: std::option::Option<i32>) -> Self {
            self.max_iops_per_db_instance = input;
            self
        }
        /// <p>Minimum provisioned IOPS per GiB for a DB instance.</p>
        pub fn min_iops_per_gib(mut self, input: f64) -> Self {
            self.min_iops_per_gib = Some(input);
            self
        }
        /// <p>Minimum provisioned IOPS per GiB for a DB instance.</p>
        pub fn set_min_iops_per_gib(mut self, input: std::option::Option<f64>) -> Self {
            self.min_iops_per_gib = input;
            self
        }
        /// <p>Maximum provisioned IOPS per GiB for a DB instance.</p>
        pub fn max_iops_per_gib(mut self, input: f64) -> Self {
            self.max_iops_per_gib = Some(input);
            self
        }
        /// <p>Maximum provisioned IOPS per GiB for a DB instance.</p>
        pub fn set_max_iops_per_gib(mut self, input: std::option::Option<f64>) -> Self {
            self.max_iops_per_gib = input;
            self
        }
        /// Appends an item to `available_processor_features`.
        ///
        /// To override the contents of this collection use [`set_available_processor_features`](Self::set_available_processor_features).
        ///
        /// <p>A list of the available processor features for the DB instance class of a DB instance.</p>
        pub fn available_processor_features(
            mut self,
            input: crate::model::AvailableProcessorFeature,
        ) -> Self {
            let mut v = self.available_processor_features.unwrap_or_default();
            v.push(input);
            self.available_processor_features = Some(v);
            self
        }
        /// <p>A list of the available processor features for the DB instance class of a DB instance.</p>
        pub fn set_available_processor_features(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AvailableProcessorFeature>>,
        ) -> Self {
            self.available_processor_features = input;
            self
        }
        /// Appends an item to `supported_engine_modes`.
        ///
        /// To override the contents of this collection use [`set_supported_engine_modes`](Self::set_supported_engine_modes).
        ///
        /// <p>A list of the supported DB engine modes.</p>
        pub fn supported_engine_modes(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.supported_engine_modes.unwrap_or_default();
            v.push(input.into());
            self.supported_engine_modes = Some(v);
            self
        }
        /// <p>A list of the supported DB engine modes.</p>
        pub fn set_supported_engine_modes(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.supported_engine_modes = input;
            self
        }
        /// <p>Whether Amazon RDS can automatically scale storage for DB instances that use the specified DB instance class.</p>
        pub fn supports_storage_autoscaling(mut self, input: bool) -> Self {
            self.supports_storage_autoscaling = Some(input);
            self
        }
        /// <p>Whether Amazon RDS can automatically scale storage for DB instances that use the specified DB instance class.</p>
        pub fn set_supports_storage_autoscaling(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.supports_storage_autoscaling = input;
            self
        }
        /// <p>Whether a DB instance supports Kerberos Authentication.</p>
        pub fn supports_kerberos_authentication(mut self, input: bool) -> Self {
            self.supports_kerberos_authentication = Some(input);
            self
        }
        /// <p>Whether a DB instance supports Kerberos Authentication.</p>
        pub fn set_supports_kerberos_authentication(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.supports_kerberos_authentication = input;
            self
        }
        /// <p>Whether a DB instance supports RDS on Outposts.</p>
        /// <p>For more information about RDS on Outposts, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html">Amazon RDS on Amazon Web Services Outposts</a> in the <i>Amazon RDS User Guide.</i> </p>
        pub fn outpost_capable(mut self, input: bool) -> Self {
            self.outpost_capable = Some(input);
            self
        }
        /// <p>Whether a DB instance supports RDS on Outposts.</p>
        /// <p>For more information about RDS on Outposts, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html">Amazon RDS on Amazon Web Services Outposts</a> in the <i>Amazon RDS User Guide.</i> </p>
        pub fn set_outpost_capable(mut self, input: std::option::Option<bool>) -> Self {
            self.outpost_capable = input;
            self
        }
        /// Appends an item to `supported_activity_stream_modes`.
        ///
        /// To override the contents of this collection use [`set_supported_activity_stream_modes`](Self::set_supported_activity_stream_modes).
        ///
        /// <p>The list of supported modes for Database Activity Streams. Aurora PostgreSQL returns the value <code>[sync, async]</code>. Aurora MySQL and RDS for Oracle return <code>[async]</code> only. If Database Activity Streams isn't supported, the return value is an empty list.</p>
        pub fn supported_activity_stream_modes(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.supported_activity_stream_modes.unwrap_or_default();
            v.push(input.into());
            self.supported_activity_stream_modes = Some(v);
            self
        }
        /// <p>The list of supported modes for Database Activity Streams. Aurora PostgreSQL returns the value <code>[sync, async]</code>. Aurora MySQL and RDS for Oracle return <code>[async]</code> only. If Database Activity Streams isn't supported, the return value is an empty list.</p>
        pub fn set_supported_activity_stream_modes(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.supported_activity_stream_modes = input;
            self
        }
        /// <p>A value that indicates whether you can use Aurora global databases with a specific combination of other DB engine attributes.</p>
        pub fn supports_global_databases(mut self, input: bool) -> Self {
            self.supports_global_databases = Some(input);
            self
        }
        /// <p>A value that indicates whether you can use Aurora global databases with a specific combination of other DB engine attributes.</p>
        pub fn set_supports_global_databases(mut self, input: std::option::Option<bool>) -> Self {
            self.supports_global_databases = input;
            self
        }
        /// <p>Whether DB instances can be configured as a Multi-AZ DB cluster.</p>
        /// <p>The Multi-AZ DB clusters feature is in preview and is subject to change.</p>
        /// <p>For more information on Multi-AZ DB clusters, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ deployments with two readable standby DB instances</a> in the <i>Amazon RDS User Guide.</i> </p>
        pub fn supports_clusters(mut self, input: bool) -> Self {
            self.supports_clusters = Some(input);
            self
        }
        /// <p>Whether DB instances can be configured as a Multi-AZ DB cluster.</p>
        /// <p>The Multi-AZ DB clusters feature is in preview and is subject to change.</p>
        /// <p>For more information on Multi-AZ DB clusters, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ deployments with two readable standby DB instances</a> in the <i>Amazon RDS User Guide.</i> </p>
        pub fn set_supports_clusters(mut self, input: std::option::Option<bool>) -> Self {
            self.supports_clusters = input;
            self
        }
        /// Consumes the builder and constructs a [`OrderableDbInstanceOption`](crate::model::OrderableDbInstanceOption)
        pub fn build(self) -> crate::model::OrderableDbInstanceOption {
            crate::model::OrderableDbInstanceOption {
                engine: self.engine,
                engine_version: self.engine_version,
                db_instance_class: self.db_instance_class,
                license_model: self.license_model,
                availability_zone_group: self.availability_zone_group,
                availability_zones: self.availability_zones,
                multi_az_capable: self.multi_az_capable.unwrap_or_default(),
                read_replica_capable: self.read_replica_capable.unwrap_or_default(),
                vpc: self.vpc.unwrap_or_default(),
                supports_storage_encryption: self.supports_storage_encryption.unwrap_or_default(),
                storage_type: self.storage_type,
                supports_iops: self.supports_iops.unwrap_or_default(),
                supports_enhanced_monitoring: self.supports_enhanced_monitoring.unwrap_or_default(),
                supports_iam_database_authentication: self
                    .supports_iam_database_authentication
                    .unwrap_or_default(),
                supports_performance_insights: self
                    .supports_performance_insights
                    .unwrap_or_default(),
                min_storage_size: self.min_storage_size,
                max_storage_size: self.max_storage_size,
                min_iops_per_db_instance: self.min_iops_per_db_instance,
                max_iops_per_db_instance: self.max_iops_per_db_instance,
                min_iops_per_gib: self.min_iops_per_gib,
                max_iops_per_gib: self.max_iops_per_gib,
                available_processor_features: self.available_processor_features,
                supported_engine_modes: self.supported_engine_modes,
                supports_storage_autoscaling: self.supports_storage_autoscaling,
                supports_kerberos_authentication: self.supports_kerberos_authentication,
                outpost_capable: self.outpost_capable.unwrap_or_default(),
                supported_activity_stream_modes: self.supported_activity_stream_modes,
                supports_global_databases: self.supports_global_databases.unwrap_or_default(),
                supports_clusters: self.supports_clusters.unwrap_or_default(),
            }
        }
    }
}
impl OrderableDbInstanceOption {
    /// Creates a new builder-style object to manufacture [`OrderableDbInstanceOption`](crate::model::OrderableDbInstanceOption)
    pub fn builder() -> crate::model::orderable_db_instance_option::Builder {
        crate::model::orderable_db_instance_option::Builder::default()
    }
}

/// <p>Available option.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OptionGroupOption {
    /// <p>The name of the option.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The description of the option.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The name of the engine that this option can be applied to.</p>
    pub engine_name: std::option::Option<std::string::String>,
    /// <p>Indicates the major engine version that the option is available for.</p>
    pub major_engine_version: std::option::Option<std::string::String>,
    /// <p>The minimum required engine version for the option to be applied.</p>
    pub minimum_required_minor_engine_version: std::option::Option<std::string::String>,
    /// <p>Specifies whether the option requires a port.</p>
    pub port_required: bool,
    /// <p>If the option requires a port, specifies the default port for the option.</p>
    pub default_port: std::option::Option<i32>,
    /// <p>The options that are prerequisites for this option.</p>
    pub options_depended_on: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The options that conflict with this option.</p>
    pub options_conflicts_with: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Persistent options can't be removed from an option group while DB instances are associated with the option group. If you disassociate all DB instances from the option group, your can remove the persistent option from the option group.</p>
    pub persistent: bool,
    /// <p>Permanent options can never be removed from an option group. An option group containing a permanent option can't be removed from a DB instance.</p>
    pub permanent: bool,
    /// <p>If true, you must enable the Auto Minor Version Upgrade setting for your DB instance before you can use this option. You can enable Auto Minor Version Upgrade when you first create your DB instance, or by modifying your DB instance later. </p>
    pub requires_auto_minor_engine_version_upgrade: bool,
    /// <p>If true, you can only use this option with a DB instance that is in a VPC. </p>
    pub vpc_only: bool,
    /// <p>If true, you can change the option to an earlier version of the option. This only applies to options that have different versions available. </p>
    pub supports_option_version_downgrade: std::option::Option<bool>,
    /// <p>The option settings that are available (and the default value) for each option in an option group.</p>
    pub option_group_option_settings:
        std::option::Option<std::vec::Vec<crate::model::OptionGroupOptionSetting>>,
    /// <p>The versions that are available for the option.</p>
    pub option_group_option_versions:
        std::option::Option<std::vec::Vec<crate::model::OptionVersion>>,
}
impl OptionGroupOption {
    /// <p>The name of the option.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The description of the option.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The name of the engine that this option can be applied to.</p>
    pub fn engine_name(&self) -> std::option::Option<&str> {
        self.engine_name.as_deref()
    }
    /// <p>Indicates the major engine version that the option is available for.</p>
    pub fn major_engine_version(&self) -> std::option::Option<&str> {
        self.major_engine_version.as_deref()
    }
    /// <p>The minimum required engine version for the option to be applied.</p>
    pub fn minimum_required_minor_engine_version(&self) -> std::option::Option<&str> {
        self.minimum_required_minor_engine_version.as_deref()
    }
    /// <p>Specifies whether the option requires a port.</p>
    pub fn port_required(&self) -> bool {
        self.port_required
    }
    /// <p>If the option requires a port, specifies the default port for the option.</p>
    pub fn default_port(&self) -> std::option::Option<i32> {
        self.default_port
    }
    /// <p>The options that are prerequisites for this option.</p>
    pub fn options_depended_on(&self) -> std::option::Option<&[std::string::String]> {
        self.options_depended_on.as_deref()
    }
    /// <p>The options that conflict with this option.</p>
    pub fn options_conflicts_with(&self) -> std::option::Option<&[std::string::String]> {
        self.options_conflicts_with.as_deref()
    }
    /// <p>Persistent options can't be removed from an option group while DB instances are associated with the option group. If you disassociate all DB instances from the option group, your can remove the persistent option from the option group.</p>
    pub fn persistent(&self) -> bool {
        self.persistent
    }
    /// <p>Permanent options can never be removed from an option group. An option group containing a permanent option can't be removed from a DB instance.</p>
    pub fn permanent(&self) -> bool {
        self.permanent
    }
    /// <p>If true, you must enable the Auto Minor Version Upgrade setting for your DB instance before you can use this option. You can enable Auto Minor Version Upgrade when you first create your DB instance, or by modifying your DB instance later. </p>
    pub fn requires_auto_minor_engine_version_upgrade(&self) -> bool {
        self.requires_auto_minor_engine_version_upgrade
    }
    /// <p>If true, you can only use this option with a DB instance that is in a VPC. </p>
    pub fn vpc_only(&self) -> bool {
        self.vpc_only
    }
    /// <p>If true, you can change the option to an earlier version of the option. This only applies to options that have different versions available. </p>
    pub fn supports_option_version_downgrade(&self) -> std::option::Option<bool> {
        self.supports_option_version_downgrade
    }
    /// <p>The option settings that are available (and the default value) for each option in an option group.</p>
    pub fn option_group_option_settings(
        &self,
    ) -> std::option::Option<&[crate::model::OptionGroupOptionSetting]> {
        self.option_group_option_settings.as_deref()
    }
    /// <p>The versions that are available for the option.</p>
    pub fn option_group_option_versions(
        &self,
    ) -> std::option::Option<&[crate::model::OptionVersion]> {
        self.option_group_option_versions.as_deref()
    }
}
impl std::fmt::Debug for OptionGroupOption {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OptionGroupOption");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("engine_name", &self.engine_name);
        formatter.field("major_engine_version", &self.major_engine_version);
        formatter.field(
            "minimum_required_minor_engine_version",
            &self.minimum_required_minor_engine_version,
        );
        formatter.field("port_required", &self.port_required);
        formatter.field("default_port", &self.default_port);
        formatter.field("options_depended_on", &self.options_depended_on);
        formatter.field("options_conflicts_with", &self.options_conflicts_with);
        formatter.field("persistent", &self.persistent);
        formatter.field("permanent", &self.permanent);
        formatter.field(
            "requires_auto_minor_engine_version_upgrade",
            &self.requires_auto_minor_engine_version_upgrade,
        );
        formatter.field("vpc_only", &self.vpc_only);
        formatter.field(
            "supports_option_version_downgrade",
            &self.supports_option_version_downgrade,
        );
        formatter.field(
            "option_group_option_settings",
            &self.option_group_option_settings,
        );
        formatter.field(
            "option_group_option_versions",
            &self.option_group_option_versions,
        );
        formatter.finish()
    }
}
/// See [`OptionGroupOption`](crate::model::OptionGroupOption)
pub mod option_group_option {
    /// A builder for [`OptionGroupOption`](crate::model::OptionGroupOption)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) engine_name: std::option::Option<std::string::String>,
        pub(crate) major_engine_version: std::option::Option<std::string::String>,
        pub(crate) minimum_required_minor_engine_version: std::option::Option<std::string::String>,
        pub(crate) port_required: std::option::Option<bool>,
        pub(crate) default_port: std::option::Option<i32>,
        pub(crate) options_depended_on: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) options_conflicts_with: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) persistent: std::option::Option<bool>,
        pub(crate) permanent: std::option::Option<bool>,
        pub(crate) requires_auto_minor_engine_version_upgrade: std::option::Option<bool>,
        pub(crate) vpc_only: std::option::Option<bool>,
        pub(crate) supports_option_version_downgrade: std::option::Option<bool>,
        pub(crate) option_group_option_settings:
            std::option::Option<std::vec::Vec<crate::model::OptionGroupOptionSetting>>,
        pub(crate) option_group_option_versions:
            std::option::Option<std::vec::Vec<crate::model::OptionVersion>>,
    }
    impl Builder {
        /// <p>The name of the option.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the option.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The description of the option.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the option.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The name of the engine that this option can be applied to.</p>
        pub fn engine_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_name = Some(input.into());
            self
        }
        /// <p>The name of the engine that this option can be applied to.</p>
        pub fn set_engine_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.engine_name = input;
            self
        }
        /// <p>Indicates the major engine version that the option is available for.</p>
        pub fn major_engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.major_engine_version = Some(input.into());
            self
        }
        /// <p>Indicates the major engine version that the option is available for.</p>
        pub fn set_major_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.major_engine_version = input;
            self
        }
        /// <p>The minimum required engine version for the option to be applied.</p>
        pub fn minimum_required_minor_engine_version(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.minimum_required_minor_engine_version = Some(input.into());
            self
        }
        /// <p>The minimum required engine version for the option to be applied.</p>
        pub fn set_minimum_required_minor_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.minimum_required_minor_engine_version = input;
            self
        }
        /// <p>Specifies whether the option requires a port.</p>
        pub fn port_required(mut self, input: bool) -> Self {
            self.port_required = Some(input);
            self
        }
        /// <p>Specifies whether the option requires a port.</p>
        pub fn set_port_required(mut self, input: std::option::Option<bool>) -> Self {
            self.port_required = input;
            self
        }
        /// <p>If the option requires a port, specifies the default port for the option.</p>
        pub fn default_port(mut self, input: i32) -> Self {
            self.default_port = Some(input);
            self
        }
        /// <p>If the option requires a port, specifies the default port for the option.</p>
        pub fn set_default_port(mut self, input: std::option::Option<i32>) -> Self {
            self.default_port = input;
            self
        }
        /// Appends an item to `options_depended_on`.
        ///
        /// To override the contents of this collection use [`set_options_depended_on`](Self::set_options_depended_on).
        ///
        /// <p>The options that are prerequisites for this option.</p>
        pub fn options_depended_on(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.options_depended_on.unwrap_or_default();
            v.push(input.into());
            self.options_depended_on = Some(v);
            self
        }
        /// <p>The options that are prerequisites for this option.</p>
        pub fn set_options_depended_on(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.options_depended_on = input;
            self
        }
        /// Appends an item to `options_conflicts_with`.
        ///
        /// To override the contents of this collection use [`set_options_conflicts_with`](Self::set_options_conflicts_with).
        ///
        /// <p>The options that conflict with this option.</p>
        pub fn options_conflicts_with(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.options_conflicts_with.unwrap_or_default();
            v.push(input.into());
            self.options_conflicts_with = Some(v);
            self
        }
        /// <p>The options that conflict with this option.</p>
        pub fn set_options_conflicts_with(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.options_conflicts_with = input;
            self
        }
        /// <p>Persistent options can't be removed from an option group while DB instances are associated with the option group. If you disassociate all DB instances from the option group, your can remove the persistent option from the option group.</p>
        pub fn persistent(mut self, input: bool) -> Self {
            self.persistent = Some(input);
            self
        }
        /// <p>Persistent options can't be removed from an option group while DB instances are associated with the option group. If you disassociate all DB instances from the option group, your can remove the persistent option from the option group.</p>
        pub fn set_persistent(mut self, input: std::option::Option<bool>) -> Self {
            self.persistent = input;
            self
        }
        /// <p>Permanent options can never be removed from an option group. An option group containing a permanent option can't be removed from a DB instance.</p>
        pub fn permanent(mut self, input: bool) -> Self {
            self.permanent = Some(input);
            self
        }
        /// <p>Permanent options can never be removed from an option group. An option group containing a permanent option can't be removed from a DB instance.</p>
        pub fn set_permanent(mut self, input: std::option::Option<bool>) -> Self {
            self.permanent = input;
            self
        }
        /// <p>If true, you must enable the Auto Minor Version Upgrade setting for your DB instance before you can use this option. You can enable Auto Minor Version Upgrade when you first create your DB instance, or by modifying your DB instance later. </p>
        pub fn requires_auto_minor_engine_version_upgrade(mut self, input: bool) -> Self {
            self.requires_auto_minor_engine_version_upgrade = Some(input);
            self
        }
        /// <p>If true, you must enable the Auto Minor Version Upgrade setting for your DB instance before you can use this option. You can enable Auto Minor Version Upgrade when you first create your DB instance, or by modifying your DB instance later. </p>
        pub fn set_requires_auto_minor_engine_version_upgrade(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.requires_auto_minor_engine_version_upgrade = input;
            self
        }
        /// <p>If true, you can only use this option with a DB instance that is in a VPC. </p>
        pub fn vpc_only(mut self, input: bool) -> Self {
            self.vpc_only = Some(input);
            self
        }
        /// <p>If true, you can only use this option with a DB instance that is in a VPC. </p>
        pub fn set_vpc_only(mut self, input: std::option::Option<bool>) -> Self {
            self.vpc_only = input;
            self
        }
        /// <p>If true, you can change the option to an earlier version of the option. This only applies to options that have different versions available. </p>
        pub fn supports_option_version_downgrade(mut self, input: bool) -> Self {
            self.supports_option_version_downgrade = Some(input);
            self
        }
        /// <p>If true, you can change the option to an earlier version of the option. This only applies to options that have different versions available. </p>
        pub fn set_supports_option_version_downgrade(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.supports_option_version_downgrade = input;
            self
        }
        /// Appends an item to `option_group_option_settings`.
        ///
        /// To override the contents of this collection use [`set_option_group_option_settings`](Self::set_option_group_option_settings).
        ///
        /// <p>The option settings that are available (and the default value) for each option in an option group.</p>
        pub fn option_group_option_settings(
            mut self,
            input: crate::model::OptionGroupOptionSetting,
        ) -> Self {
            let mut v = self.option_group_option_settings.unwrap_or_default();
            v.push(input);
            self.option_group_option_settings = Some(v);
            self
        }
        /// <p>The option settings that are available (and the default value) for each option in an option group.</p>
        pub fn set_option_group_option_settings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OptionGroupOptionSetting>>,
        ) -> Self {
            self.option_group_option_settings = input;
            self
        }
        /// Appends an item to `option_group_option_versions`.
        ///
        /// To override the contents of this collection use [`set_option_group_option_versions`](Self::set_option_group_option_versions).
        ///
        /// <p>The versions that are available for the option.</p>
        pub fn option_group_option_versions(mut self, input: crate::model::OptionVersion) -> Self {
            let mut v = self.option_group_option_versions.unwrap_or_default();
            v.push(input);
            self.option_group_option_versions = Some(v);
            self
        }
        /// <p>The versions that are available for the option.</p>
        pub fn set_option_group_option_versions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OptionVersion>>,
        ) -> Self {
            self.option_group_option_versions = input;
            self
        }
        /// Consumes the builder and constructs a [`OptionGroupOption`](crate::model::OptionGroupOption)
        pub fn build(self) -> crate::model::OptionGroupOption {
            crate::model::OptionGroupOption {
                name: self.name,
                description: self.description,
                engine_name: self.engine_name,
                major_engine_version: self.major_engine_version,
                minimum_required_minor_engine_version: self.minimum_required_minor_engine_version,
                port_required: self.port_required.unwrap_or_default(),
                default_port: self.default_port,
                options_depended_on: self.options_depended_on,
                options_conflicts_with: self.options_conflicts_with,
                persistent: self.persistent.unwrap_or_default(),
                permanent: self.permanent.unwrap_or_default(),
                requires_auto_minor_engine_version_upgrade: self
                    .requires_auto_minor_engine_version_upgrade
                    .unwrap_or_default(),
                vpc_only: self.vpc_only.unwrap_or_default(),
                supports_option_version_downgrade: self.supports_option_version_downgrade,
                option_group_option_settings: self.option_group_option_settings,
                option_group_option_versions: self.option_group_option_versions,
            }
        }
    }
}
impl OptionGroupOption {
    /// Creates a new builder-style object to manufacture [`OptionGroupOption`](crate::model::OptionGroupOption)
    pub fn builder() -> crate::model::option_group_option::Builder {
        crate::model::option_group_option::Builder::default()
    }
}

/// <p>The version for an option. Option group option versions are returned by the <code>DescribeOptionGroupOptions</code> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OptionVersion {
    /// <p>The version of the option.</p>
    pub version: std::option::Option<std::string::String>,
    /// <p>True if the version is the default version of the option, and otherwise false.</p>
    pub is_default: bool,
}
impl OptionVersion {
    /// <p>The version of the option.</p>
    pub fn version(&self) -> std::option::Option<&str> {
        self.version.as_deref()
    }
    /// <p>True if the version is the default version of the option, and otherwise false.</p>
    pub fn is_default(&self) -> bool {
        self.is_default
    }
}
impl std::fmt::Debug for OptionVersion {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OptionVersion");
        formatter.field("version", &self.version);
        formatter.field("is_default", &self.is_default);
        formatter.finish()
    }
}
/// See [`OptionVersion`](crate::model::OptionVersion)
pub mod option_version {
    /// A builder for [`OptionVersion`](crate::model::OptionVersion)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) version: std::option::Option<std::string::String>,
        pub(crate) is_default: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The version of the option.</p>
        pub fn version(mut self, input: impl Into<std::string::String>) -> Self {
            self.version = Some(input.into());
            self
        }
        /// <p>The version of the option.</p>
        pub fn set_version(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version = input;
            self
        }
        /// <p>True if the version is the default version of the option, and otherwise false.</p>
        pub fn is_default(mut self, input: bool) -> Self {
            self.is_default = Some(input);
            self
        }
        /// <p>True if the version is the default version of the option, and otherwise false.</p>
        pub fn set_is_default(mut self, input: std::option::Option<bool>) -> Self {
            self.is_default = input;
            self
        }
        /// Consumes the builder and constructs a [`OptionVersion`](crate::model::OptionVersion)
        pub fn build(self) -> crate::model::OptionVersion {
            crate::model::OptionVersion {
                version: self.version,
                is_default: self.is_default.unwrap_or_default(),
            }
        }
    }
}
impl OptionVersion {
    /// Creates a new builder-style object to manufacture [`OptionVersion`](crate::model::OptionVersion)
    pub fn builder() -> crate::model::option_version::Builder {
        crate::model::option_version::Builder::default()
    }
}

/// <p>Option group option settings are used to display settings available for each option with their default values and other information. These values are used with the DescribeOptionGroupOptions action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OptionGroupOptionSetting {
    /// <p>The name of the option group option.</p>
    pub setting_name: std::option::Option<std::string::String>,
    /// <p>The description of the option group option.</p>
    pub setting_description: std::option::Option<std::string::String>,
    /// <p>The default value for the option group option.</p>
    pub default_value: std::option::Option<std::string::String>,
    /// <p>The DB engine specific parameter type for the option group option.</p>
    pub apply_type: std::option::Option<std::string::String>,
    /// <p>Indicates the acceptable values for the option group option.</p>
    pub allowed_values: std::option::Option<std::string::String>,
    /// <p>Boolean value where true indicates that this option group option can be changed from the default value.</p>
    pub is_modifiable: bool,
    /// <p>Boolean value where true indicates that a value must be specified for this option setting of the option group option.</p>
    pub is_required: bool,
    /// <p>The minimum DB engine version required for the corresponding allowed value for this option setting.</p>
    pub minimum_engine_version_per_allowed_value:
        std::option::Option<std::vec::Vec<crate::model::MinimumEngineVersionPerAllowedValue>>,
}
impl OptionGroupOptionSetting {
    /// <p>The name of the option group option.</p>
    pub fn setting_name(&self) -> std::option::Option<&str> {
        self.setting_name.as_deref()
    }
    /// <p>The description of the option group option.</p>
    pub fn setting_description(&self) -> std::option::Option<&str> {
        self.setting_description.as_deref()
    }
    /// <p>The default value for the option group option.</p>
    pub fn default_value(&self) -> std::option::Option<&str> {
        self.default_value.as_deref()
    }
    /// <p>The DB engine specific parameter type for the option group option.</p>
    pub fn apply_type(&self) -> std::option::Option<&str> {
        self.apply_type.as_deref()
    }
    /// <p>Indicates the acceptable values for the option group option.</p>
    pub fn allowed_values(&self) -> std::option::Option<&str> {
        self.allowed_values.as_deref()
    }
    /// <p>Boolean value where true indicates that this option group option can be changed from the default value.</p>
    pub fn is_modifiable(&self) -> bool {
        self.is_modifiable
    }
    /// <p>Boolean value where true indicates that a value must be specified for this option setting of the option group option.</p>
    pub fn is_required(&self) -> bool {
        self.is_required
    }
    /// <p>The minimum DB engine version required for the corresponding allowed value for this option setting.</p>
    pub fn minimum_engine_version_per_allowed_value(
        &self,
    ) -> std::option::Option<&[crate::model::MinimumEngineVersionPerAllowedValue]> {
        self.minimum_engine_version_per_allowed_value.as_deref()
    }
}
impl std::fmt::Debug for OptionGroupOptionSetting {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OptionGroupOptionSetting");
        formatter.field("setting_name", &self.setting_name);
        formatter.field("setting_description", &self.setting_description);
        formatter.field("default_value", &self.default_value);
        formatter.field("apply_type", &self.apply_type);
        formatter.field("allowed_values", &self.allowed_values);
        formatter.field("is_modifiable", &self.is_modifiable);
        formatter.field("is_required", &self.is_required);
        formatter.field(
            "minimum_engine_version_per_allowed_value",
            &self.minimum_engine_version_per_allowed_value,
        );
        formatter.finish()
    }
}
/// See [`OptionGroupOptionSetting`](crate::model::OptionGroupOptionSetting)
pub mod option_group_option_setting {
    /// A builder for [`OptionGroupOptionSetting`](crate::model::OptionGroupOptionSetting)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) setting_name: std::option::Option<std::string::String>,
        pub(crate) setting_description: std::option::Option<std::string::String>,
        pub(crate) default_value: std::option::Option<std::string::String>,
        pub(crate) apply_type: std::option::Option<std::string::String>,
        pub(crate) allowed_values: std::option::Option<std::string::String>,
        pub(crate) is_modifiable: std::option::Option<bool>,
        pub(crate) is_required: std::option::Option<bool>,
        pub(crate) minimum_engine_version_per_allowed_value:
            std::option::Option<std::vec::Vec<crate::model::MinimumEngineVersionPerAllowedValue>>,
    }
    impl Builder {
        /// <p>The name of the option group option.</p>
        pub fn setting_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.setting_name = Some(input.into());
            self
        }
        /// <p>The name of the option group option.</p>
        pub fn set_setting_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.setting_name = input;
            self
        }
        /// <p>The description of the option group option.</p>
        pub fn setting_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.setting_description = Some(input.into());
            self
        }
        /// <p>The description of the option group option.</p>
        pub fn set_setting_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.setting_description = input;
            self
        }
        /// <p>The default value for the option group option.</p>
        pub fn default_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.default_value = Some(input.into());
            self
        }
        /// <p>The default value for the option group option.</p>
        pub fn set_default_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.default_value = input;
            self
        }
        /// <p>The DB engine specific parameter type for the option group option.</p>
        pub fn apply_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.apply_type = Some(input.into());
            self
        }
        /// <p>The DB engine specific parameter type for the option group option.</p>
        pub fn set_apply_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.apply_type = input;
            self
        }
        /// <p>Indicates the acceptable values for the option group option.</p>
        pub fn allowed_values(mut self, input: impl Into<std::string::String>) -> Self {
            self.allowed_values = Some(input.into());
            self
        }
        /// <p>Indicates the acceptable values for the option group option.</p>
        pub fn set_allowed_values(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.allowed_values = input;
            self
        }
        /// <p>Boolean value where true indicates that this option group option can be changed from the default value.</p>
        pub fn is_modifiable(mut self, input: bool) -> Self {
            self.is_modifiable = Some(input);
            self
        }
        /// <p>Boolean value where true indicates that this option group option can be changed from the default value.</p>
        pub fn set_is_modifiable(mut self, input: std::option::Option<bool>) -> Self {
            self.is_modifiable = input;
            self
        }
        /// <p>Boolean value where true indicates that a value must be specified for this option setting of the option group option.</p>
        pub fn is_required(mut self, input: bool) -> Self {
            self.is_required = Some(input);
            self
        }
        /// <p>Boolean value where true indicates that a value must be specified for this option setting of the option group option.</p>
        pub fn set_is_required(mut self, input: std::option::Option<bool>) -> Self {
            self.is_required = input;
            self
        }
        /// Appends an item to `minimum_engine_version_per_allowed_value`.
        ///
        /// To override the contents of this collection use [`set_minimum_engine_version_per_allowed_value`](Self::set_minimum_engine_version_per_allowed_value).
        ///
        /// <p>The minimum DB engine version required for the corresponding allowed value for this option setting.</p>
        pub fn minimum_engine_version_per_allowed_value(
            mut self,
            input: crate::model::MinimumEngineVersionPerAllowedValue,
        ) -> Self {
            let mut v = self
                .minimum_engine_version_per_allowed_value
                .unwrap_or_default();
            v.push(input);
            self.minimum_engine_version_per_allowed_value = Some(v);
            self
        }
        /// <p>The minimum DB engine version required for the corresponding allowed value for this option setting.</p>
        pub fn set_minimum_engine_version_per_allowed_value(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::MinimumEngineVersionPerAllowedValue>,
            >,
        ) -> Self {
            self.minimum_engine_version_per_allowed_value = input;
            self
        }
        /// Consumes the builder and constructs a [`OptionGroupOptionSetting`](crate::model::OptionGroupOptionSetting)
        pub fn build(self) -> crate::model::OptionGroupOptionSetting {
            crate::model::OptionGroupOptionSetting {
                setting_name: self.setting_name,
                setting_description: self.setting_description,
                default_value: self.default_value,
                apply_type: self.apply_type,
                allowed_values: self.allowed_values,
                is_modifiable: self.is_modifiable.unwrap_or_default(),
                is_required: self.is_required.unwrap_or_default(),
                minimum_engine_version_per_allowed_value: self
                    .minimum_engine_version_per_allowed_value,
            }
        }
    }
}
impl OptionGroupOptionSetting {
    /// Creates a new builder-style object to manufacture [`OptionGroupOptionSetting`](crate::model::OptionGroupOptionSetting)
    pub fn builder() -> crate::model::option_group_option_setting::Builder {
        crate::model::option_group_option_setting::Builder::default()
    }
}

/// <p>The minimum DB engine version required for each corresponding allowed value for an option setting.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MinimumEngineVersionPerAllowedValue {
    /// <p>The allowed value for an option setting.</p>
    pub allowed_value: std::option::Option<std::string::String>,
    /// <p>The minimum DB engine version required for the allowed value.</p>
    pub minimum_engine_version: std::option::Option<std::string::String>,
}
impl MinimumEngineVersionPerAllowedValue {
    /// <p>The allowed value for an option setting.</p>
    pub fn allowed_value(&self) -> std::option::Option<&str> {
        self.allowed_value.as_deref()
    }
    /// <p>The minimum DB engine version required for the allowed value.</p>
    pub fn minimum_engine_version(&self) -> std::option::Option<&str> {
        self.minimum_engine_version.as_deref()
    }
}
impl std::fmt::Debug for MinimumEngineVersionPerAllowedValue {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MinimumEngineVersionPerAllowedValue");
        formatter.field("allowed_value", &self.allowed_value);
        formatter.field("minimum_engine_version", &self.minimum_engine_version);
        formatter.finish()
    }
}
/// See [`MinimumEngineVersionPerAllowedValue`](crate::model::MinimumEngineVersionPerAllowedValue)
pub mod minimum_engine_version_per_allowed_value {
    /// A builder for [`MinimumEngineVersionPerAllowedValue`](crate::model::MinimumEngineVersionPerAllowedValue)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) allowed_value: std::option::Option<std::string::String>,
        pub(crate) minimum_engine_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The allowed value for an option setting.</p>
        pub fn allowed_value(mut self, input: impl Into<std::string::String>) -> Self {
            self.allowed_value = Some(input.into());
            self
        }
        /// <p>The allowed value for an option setting.</p>
        pub fn set_allowed_value(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.allowed_value = input;
            self
        }
        /// <p>The minimum DB engine version required for the allowed value.</p>
        pub fn minimum_engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.minimum_engine_version = Some(input.into());
            self
        }
        /// <p>The minimum DB engine version required for the allowed value.</p>
        pub fn set_minimum_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.minimum_engine_version = input;
            self
        }
        /// Consumes the builder and constructs a [`MinimumEngineVersionPerAllowedValue`](crate::model::MinimumEngineVersionPerAllowedValue)
        pub fn build(self) -> crate::model::MinimumEngineVersionPerAllowedValue {
            crate::model::MinimumEngineVersionPerAllowedValue {
                allowed_value: self.allowed_value,
                minimum_engine_version: self.minimum_engine_version,
            }
        }
    }
}
impl MinimumEngineVersionPerAllowedValue {
    /// Creates a new builder-style object to manufacture [`MinimumEngineVersionPerAllowedValue`](crate::model::MinimumEngineVersionPerAllowedValue)
    pub fn builder() -> crate::model::minimum_engine_version_per_allowed_value::Builder {
        crate::model::minimum_engine_version_per_allowed_value::Builder::default()
    }
}

/// <p>Contains the installation media for a DB engine that requires an on-premises customer provided license, such as Microsoft SQL Server.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InstallationMedia {
    /// <p>The installation medium ID.</p>
    pub installation_media_id: std::option::Option<std::string::String>,
    /// <p>The custom Availability Zone (AZ) that contains the installation media.</p>
    pub custom_availability_zone_id: std::option::Option<std::string::String>,
    /// <p>The DB engine.</p>
    pub engine: std::option::Option<std::string::String>,
    /// <p>The engine version of the DB engine.</p>
    pub engine_version: std::option::Option<std::string::String>,
    /// <p>The path to the installation medium for the DB engine.</p>
    pub engine_installation_media_path: std::option::Option<std::string::String>,
    /// <p>The path to the installation medium for the operating system associated with the DB engine.</p>
    pub os_installation_media_path: std::option::Option<std::string::String>,
    /// <p>The status of the installation medium.</p>
    pub status: std::option::Option<std::string::String>,
    /// <p>If an installation media failure occurred, the cause of the failure.</p>
    pub failure_cause: std::option::Option<crate::model::InstallationMediaFailureCause>,
}
impl InstallationMedia {
    /// <p>The installation medium ID.</p>
    pub fn installation_media_id(&self) -> std::option::Option<&str> {
        self.installation_media_id.as_deref()
    }
    /// <p>The custom Availability Zone (AZ) that contains the installation media.</p>
    pub fn custom_availability_zone_id(&self) -> std::option::Option<&str> {
        self.custom_availability_zone_id.as_deref()
    }
    /// <p>The DB engine.</p>
    pub fn engine(&self) -> std::option::Option<&str> {
        self.engine.as_deref()
    }
    /// <p>The engine version of the DB engine.</p>
    pub fn engine_version(&self) -> std::option::Option<&str> {
        self.engine_version.as_deref()
    }
    /// <p>The path to the installation medium for the DB engine.</p>
    pub fn engine_installation_media_path(&self) -> std::option::Option<&str> {
        self.engine_installation_media_path.as_deref()
    }
    /// <p>The path to the installation medium for the operating system associated with the DB engine.</p>
    pub fn os_installation_media_path(&self) -> std::option::Option<&str> {
        self.os_installation_media_path.as_deref()
    }
    /// <p>The status of the installation medium.</p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>If an installation media failure occurred, the cause of the failure.</p>
    pub fn failure_cause(
        &self,
    ) -> std::option::Option<&crate::model::InstallationMediaFailureCause> {
        self.failure_cause.as_ref()
    }
}
impl std::fmt::Debug for InstallationMedia {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InstallationMedia");
        formatter.field("installation_media_id", &self.installation_media_id);
        formatter.field(
            "custom_availability_zone_id",
            &self.custom_availability_zone_id,
        );
        formatter.field("engine", &self.engine);
        formatter.field("engine_version", &self.engine_version);
        formatter.field(
            "engine_installation_media_path",
            &self.engine_installation_media_path,
        );
        formatter.field(
            "os_installation_media_path",
            &self.os_installation_media_path,
        );
        formatter.field("status", &self.status);
        formatter.field("failure_cause", &self.failure_cause);
        formatter.finish()
    }
}
/// See [`InstallationMedia`](crate::model::InstallationMedia)
pub mod installation_media {
    /// A builder for [`InstallationMedia`](crate::model::InstallationMedia)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) installation_media_id: std::option::Option<std::string::String>,
        pub(crate) custom_availability_zone_id: std::option::Option<std::string::String>,
        pub(crate) engine: std::option::Option<std::string::String>,
        pub(crate) engine_version: std::option::Option<std::string::String>,
        pub(crate) engine_installation_media_path: std::option::Option<std::string::String>,
        pub(crate) os_installation_media_path: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) failure_cause: std::option::Option<crate::model::InstallationMediaFailureCause>,
    }
    impl Builder {
        /// <p>The installation medium ID.</p>
        pub fn installation_media_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.installation_media_id = Some(input.into());
            self
        }
        /// <p>The installation medium ID.</p>
        pub fn set_installation_media_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.installation_media_id = input;
            self
        }
        /// <p>The custom Availability Zone (AZ) that contains the installation media.</p>
        pub fn custom_availability_zone_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.custom_availability_zone_id = Some(input.into());
            self
        }
        /// <p>The custom Availability Zone (AZ) that contains the installation media.</p>
        pub fn set_custom_availability_zone_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.custom_availability_zone_id = input;
            self
        }
        /// <p>The DB engine.</p>
        pub fn engine(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine = Some(input.into());
            self
        }
        /// <p>The DB engine.</p>
        pub fn set_engine(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.engine = input;
            self
        }
        /// <p>The engine version of the DB engine.</p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_version = Some(input.into());
            self
        }
        /// <p>The engine version of the DB engine.</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.engine_version = input;
            self
        }
        /// <p>The path to the installation medium for the DB engine.</p>
        pub fn engine_installation_media_path(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.engine_installation_media_path = Some(input.into());
            self
        }
        /// <p>The path to the installation medium for the DB engine.</p>
        pub fn set_engine_installation_media_path(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.engine_installation_media_path = input;
            self
        }
        /// <p>The path to the installation medium for the operating system associated with the DB engine.</p>
        pub fn os_installation_media_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.os_installation_media_path = Some(input.into());
            self
        }
        /// <p>The path to the installation medium for the operating system associated with the DB engine.</p>
        pub fn set_os_installation_media_path(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.os_installation_media_path = input;
            self
        }
        /// <p>The status of the installation medium.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the installation medium.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>If an installation media failure occurred, the cause of the failure.</p>
        pub fn failure_cause(mut self, input: crate::model::InstallationMediaFailureCause) -> Self {
            self.failure_cause = Some(input);
            self
        }
        /// <p>If an installation media failure occurred, the cause of the failure.</p>
        pub fn set_failure_cause(
            mut self,
            input: std::option::Option<crate::model::InstallationMediaFailureCause>,
        ) -> Self {
            self.failure_cause = input;
            self
        }
        /// Consumes the builder and constructs a [`InstallationMedia`](crate::model::InstallationMedia)
        pub fn build(self) -> crate::model::InstallationMedia {
            crate::model::InstallationMedia {
                installation_media_id: self.installation_media_id,
                custom_availability_zone_id: self.custom_availability_zone_id,
                engine: self.engine,
                engine_version: self.engine_version,
                engine_installation_media_path: self.engine_installation_media_path,
                os_installation_media_path: self.os_installation_media_path,
                status: self.status,
                failure_cause: self.failure_cause,
            }
        }
    }
}
impl InstallationMedia {
    /// Creates a new builder-style object to manufacture [`InstallationMedia`](crate::model::InstallationMedia)
    pub fn builder() -> crate::model::installation_media::Builder {
        crate::model::installation_media::Builder::default()
    }
}

/// <p>Contains the details of a snapshot export to Amazon S3. </p>
/// <p>This data type is used as a response element in the <code>DescribeExportTasks</code> action. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExportTask {
    /// <p>A unique identifier for the snapshot export task. This ID isn't an identifier for the Amazon S3 bucket where the snapshot is exported to. </p>
    pub export_task_identifier: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the snapshot exported to Amazon S3.</p>
    pub source_arn: std::option::Option<std::string::String>,
    /// <p>The data exported from the snapshot. Valid values are the following:</p>
    /// <ul>
    /// <li> <p> <code>database</code> - Export all the data from a specified database.</p> </li>
    /// <li> <p> <code>database.table</code> <i>table-name</i> - Export a table of the snapshot. This format is valid only for RDS for MySQL, RDS for MariaDB, and Aurora MySQL.</p> </li>
    /// <li> <p> <code>database.schema</code> <i>schema-name</i> - Export a database schema of the snapshot. This format is valid only for RDS for PostgreSQL and Aurora PostgreSQL.</p> </li>
    /// <li> <p> <code>database.schema.table</code> <i>table-name</i> - Export a table of the database schema. This format is valid only for RDS for PostgreSQL and Aurora PostgreSQL.</p> </li>
    /// </ul>
    pub export_only: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The time that the snapshot was created.</p>
    pub snapshot_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time that the snapshot export task started.</p>
    pub task_start_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The time that the snapshot export task completed.</p>
    pub task_end_time: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The Amazon S3 bucket that the snapshot is exported to.</p>
    pub s3_bucket: std::option::Option<std::string::String>,
    /// <p>The Amazon S3 bucket prefix that is the file name and path of the exported snapshot.</p>
    pub s3_prefix: std::option::Option<std::string::String>,
    /// <p>The name of the IAM role that is used to write to Amazon S3 when exporting a snapshot. </p>
    pub iam_role_arn: std::option::Option<std::string::String>,
    /// <p>The key identifier of the Amazon Web Services KMS key that is used to encrypt the snapshot when it's exported to Amazon S3. The KMS key identifier is its key ARN, key ID, alias ARN, or alias name. The IAM role used for the snapshot export must have encryption and decryption permissions to use this KMS key. </p>
    pub kms_key_id: std::option::Option<std::string::String>,
    /// <p>The progress status of the export task.</p>
    pub status: std::option::Option<std::string::String>,
    /// <p>The progress of the snapshot export task as a percentage.</p>
    pub percent_progress: i32,
    /// <p>The total amount of data exported, in gigabytes.</p>
    pub total_extracted_data_in_gb: i32,
    /// <p>The reason the export failed, if it failed.</p>
    pub failure_cause: std::option::Option<std::string::String>,
    /// <p>A warning about the snapshot export task.</p>
    pub warning_message: std::option::Option<std::string::String>,
}
impl ExportTask {
    /// <p>A unique identifier for the snapshot export task. This ID isn't an identifier for the Amazon S3 bucket where the snapshot is exported to. </p>
    pub fn export_task_identifier(&self) -> std::option::Option<&str> {
        self.export_task_identifier.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the snapshot exported to Amazon S3.</p>
    pub fn source_arn(&self) -> std::option::Option<&str> {
        self.source_arn.as_deref()
    }
    /// <p>The data exported from the snapshot. Valid values are the following:</p>
    /// <ul>
    /// <li> <p> <code>database</code> - Export all the data from a specified database.</p> </li>
    /// <li> <p> <code>database.table</code> <i>table-name</i> - Export a table of the snapshot. This format is valid only for RDS for MySQL, RDS for MariaDB, and Aurora MySQL.</p> </li>
    /// <li> <p> <code>database.schema</code> <i>schema-name</i> - Export a database schema of the snapshot. This format is valid only for RDS for PostgreSQL and Aurora PostgreSQL.</p> </li>
    /// <li> <p> <code>database.schema.table</code> <i>table-name</i> - Export a table of the database schema. This format is valid only for RDS for PostgreSQL and Aurora PostgreSQL.</p> </li>
    /// </ul>
    pub fn export_only(&self) -> std::option::Option<&[std::string::String]> {
        self.export_only.as_deref()
    }
    /// <p>The time that the snapshot was created.</p>
    pub fn snapshot_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.snapshot_time.as_ref()
    }
    /// <p>The time that the snapshot export task started.</p>
    pub fn task_start_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.task_start_time.as_ref()
    }
    /// <p>The time that the snapshot export task completed.</p>
    pub fn task_end_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.task_end_time.as_ref()
    }
    /// <p>The Amazon S3 bucket that the snapshot is exported to.</p>
    pub fn s3_bucket(&self) -> std::option::Option<&str> {
        self.s3_bucket.as_deref()
    }
    /// <p>The Amazon S3 bucket prefix that is the file name and path of the exported snapshot.</p>
    pub fn s3_prefix(&self) -> std::option::Option<&str> {
        self.s3_prefix.as_deref()
    }
    /// <p>The name of the IAM role that is used to write to Amazon S3 when exporting a snapshot. </p>
    pub fn iam_role_arn(&self) -> std::option::Option<&str> {
        self.iam_role_arn.as_deref()
    }
    /// <p>The key identifier of the Amazon Web Services KMS key that is used to encrypt the snapshot when it's exported to Amazon S3. The KMS key identifier is its key ARN, key ID, alias ARN, or alias name. The IAM role used for the snapshot export must have encryption and decryption permissions to use this KMS key. </p>
    pub fn kms_key_id(&self) -> std::option::Option<&str> {
        self.kms_key_id.as_deref()
    }
    /// <p>The progress status of the export task.</p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>The progress of the snapshot export task as a percentage.</p>
    pub fn percent_progress(&self) -> i32 {
        self.percent_progress
    }
    /// <p>The total amount of data exported, in gigabytes.</p>
    pub fn total_extracted_data_in_gb(&self) -> i32 {
        self.total_extracted_data_in_gb
    }
    /// <p>The reason the export failed, if it failed.</p>
    pub fn failure_cause(&self) -> std::option::Option<&str> {
        self.failure_cause.as_deref()
    }
    /// <p>A warning about the snapshot export task.</p>
    pub fn warning_message(&self) -> std::option::Option<&str> {
        self.warning_message.as_deref()
    }
}
impl std::fmt::Debug for ExportTask {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExportTask");
        formatter.field("export_task_identifier", &self.export_task_identifier);
        formatter.field("source_arn", &self.source_arn);
        formatter.field("export_only", &self.export_only);
        formatter.field("snapshot_time", &self.snapshot_time);
        formatter.field("task_start_time", &self.task_start_time);
        formatter.field("task_end_time", &self.task_end_time);
        formatter.field("s3_bucket", &self.s3_bucket);
        formatter.field("s3_prefix", &self.s3_prefix);
        formatter.field("iam_role_arn", &self.iam_role_arn);
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.field("status", &self.status);
        formatter.field("percent_progress", &self.percent_progress);
        formatter.field(
            "total_extracted_data_in_gb",
            &self.total_extracted_data_in_gb,
        );
        formatter.field("failure_cause", &self.failure_cause);
        formatter.field("warning_message", &self.warning_message);
        formatter.finish()
    }
}
/// See [`ExportTask`](crate::model::ExportTask)
pub mod export_task {
    /// A builder for [`ExportTask`](crate::model::ExportTask)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) export_task_identifier: std::option::Option<std::string::String>,
        pub(crate) source_arn: std::option::Option<std::string::String>,
        pub(crate) export_only: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) snapshot_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) task_start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) task_end_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) s3_bucket: std::option::Option<std::string::String>,
        pub(crate) s3_prefix: std::option::Option<std::string::String>,
        pub(crate) iam_role_arn: std::option::Option<std::string::String>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) percent_progress: std::option::Option<i32>,
        pub(crate) total_extracted_data_in_gb: std::option::Option<i32>,
        pub(crate) failure_cause: std::option::Option<std::string::String>,
        pub(crate) warning_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier for the snapshot export task. This ID isn't an identifier for the Amazon S3 bucket where the snapshot is exported to. </p>
        pub fn export_task_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.export_task_identifier = Some(input.into());
            self
        }
        /// <p>A unique identifier for the snapshot export task. This ID isn't an identifier for the Amazon S3 bucket where the snapshot is exported to. </p>
        pub fn set_export_task_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.export_task_identifier = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the snapshot exported to Amazon S3.</p>
        pub fn source_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the snapshot exported to Amazon S3.</p>
        pub fn set_source_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source_arn = input;
            self
        }
        /// Appends an item to `export_only`.
        ///
        /// To override the contents of this collection use [`set_export_only`](Self::set_export_only).
        ///
        /// <p>The data exported from the snapshot. Valid values are the following:</p>
        /// <ul>
        /// <li> <p> <code>database</code> - Export all the data from a specified database.</p> </li>
        /// <li> <p> <code>database.table</code> <i>table-name</i> - Export a table of the snapshot. This format is valid only for RDS for MySQL, RDS for MariaDB, and Aurora MySQL.</p> </li>
        /// <li> <p> <code>database.schema</code> <i>schema-name</i> - Export a database schema of the snapshot. This format is valid only for RDS for PostgreSQL and Aurora PostgreSQL.</p> </li>
        /// <li> <p> <code>database.schema.table</code> <i>table-name</i> - Export a table of the database schema. This format is valid only for RDS for PostgreSQL and Aurora PostgreSQL.</p> </li>
        /// </ul>
        pub fn export_only(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.export_only.unwrap_or_default();
            v.push(input.into());
            self.export_only = Some(v);
            self
        }
        /// <p>The data exported from the snapshot. Valid values are the following:</p>
        /// <ul>
        /// <li> <p> <code>database</code> - Export all the data from a specified database.</p> </li>
        /// <li> <p> <code>database.table</code> <i>table-name</i> - Export a table of the snapshot. This format is valid only for RDS for MySQL, RDS for MariaDB, and Aurora MySQL.</p> </li>
        /// <li> <p> <code>database.schema</code> <i>schema-name</i> - Export a database schema of the snapshot. This format is valid only for RDS for PostgreSQL and Aurora PostgreSQL.</p> </li>
        /// <li> <p> <code>database.schema.table</code> <i>table-name</i> - Export a table of the database schema. This format is valid only for RDS for PostgreSQL and Aurora PostgreSQL.</p> </li>
        /// </ul>
        pub fn set_export_only(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.export_only = input;
            self
        }
        /// <p>The time that the snapshot was created.</p>
        pub fn snapshot_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.snapshot_time = Some(input);
            self
        }
        /// <p>The time that the snapshot was created.</p>
        pub fn set_snapshot_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.snapshot_time = input;
            self
        }
        /// <p>The time that the snapshot export task started.</p>
        pub fn task_start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.task_start_time = Some(input);
            self
        }
        /// <p>The time that the snapshot export task started.</p>
        pub fn set_task_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.task_start_time = input;
            self
        }
        /// <p>The time that the snapshot export task completed.</p>
        pub fn task_end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.task_end_time = Some(input);
            self
        }
        /// <p>The time that the snapshot export task completed.</p>
        pub fn set_task_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.task_end_time = input;
            self
        }
        /// <p>The Amazon S3 bucket that the snapshot is exported to.</p>
        pub fn s3_bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_bucket = Some(input.into());
            self
        }
        /// <p>The Amazon S3 bucket that the snapshot is exported to.</p>
        pub fn set_s3_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.s3_bucket = input;
            self
        }
        /// <p>The Amazon S3 bucket prefix that is the file name and path of the exported snapshot.</p>
        pub fn s3_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_prefix = Some(input.into());
            self
        }
        /// <p>The Amazon S3 bucket prefix that is the file name and path of the exported snapshot.</p>
        pub fn set_s3_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.s3_prefix = input;
            self
        }
        /// <p>The name of the IAM role that is used to write to Amazon S3 when exporting a snapshot. </p>
        pub fn iam_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.iam_role_arn = Some(input.into());
            self
        }
        /// <p>The name of the IAM role that is used to write to Amazon S3 when exporting a snapshot. </p>
        pub fn set_iam_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.iam_role_arn = input;
            self
        }
        /// <p>The key identifier of the Amazon Web Services KMS key that is used to encrypt the snapshot when it's exported to Amazon S3. The KMS key identifier is its key ARN, key ID, alias ARN, or alias name. The IAM role used for the snapshot export must have encryption and decryption permissions to use this KMS key. </p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>The key identifier of the Amazon Web Services KMS key that is used to encrypt the snapshot when it's exported to Amazon S3. The KMS key identifier is its key ARN, key ID, alias ARN, or alias name. The IAM role used for the snapshot export must have encryption and decryption permissions to use this KMS key. </p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// <p>The progress status of the export task.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The progress status of the export task.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>The progress of the snapshot export task as a percentage.</p>
        pub fn percent_progress(mut self, input: i32) -> Self {
            self.percent_progress = Some(input);
            self
        }
        /// <p>The progress of the snapshot export task as a percentage.</p>
        pub fn set_percent_progress(mut self, input: std::option::Option<i32>) -> Self {
            self.percent_progress = input;
            self
        }
        /// <p>The total amount of data exported, in gigabytes.</p>
        pub fn total_extracted_data_in_gb(mut self, input: i32) -> Self {
            self.total_extracted_data_in_gb = Some(input);
            self
        }
        /// <p>The total amount of data exported, in gigabytes.</p>
        pub fn set_total_extracted_data_in_gb(mut self, input: std::option::Option<i32>) -> Self {
            self.total_extracted_data_in_gb = input;
            self
        }
        /// <p>The reason the export failed, if it failed.</p>
        pub fn failure_cause(mut self, input: impl Into<std::string::String>) -> Self {
            self.failure_cause = Some(input.into());
            self
        }
        /// <p>The reason the export failed, if it failed.</p>
        pub fn set_failure_cause(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.failure_cause = input;
            self
        }
        /// <p>A warning about the snapshot export task.</p>
        pub fn warning_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.warning_message = Some(input.into());
            self
        }
        /// <p>A warning about the snapshot export task.</p>
        pub fn set_warning_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.warning_message = input;
            self
        }
        /// Consumes the builder and constructs a [`ExportTask`](crate::model::ExportTask)
        pub fn build(self) -> crate::model::ExportTask {
            crate::model::ExportTask {
                export_task_identifier: self.export_task_identifier,
                source_arn: self.source_arn,
                export_only: self.export_only,
                snapshot_time: self.snapshot_time,
                task_start_time: self.task_start_time,
                task_end_time: self.task_end_time,
                s3_bucket: self.s3_bucket,
                s3_prefix: self.s3_prefix,
                iam_role_arn: self.iam_role_arn,
                kms_key_id: self.kms_key_id,
                status: self.status,
                percent_progress: self.percent_progress.unwrap_or_default(),
                total_extracted_data_in_gb: self.total_extracted_data_in_gb.unwrap_or_default(),
                failure_cause: self.failure_cause,
                warning_message: self.warning_message,
            }
        }
    }
}
impl ExportTask {
    /// Creates a new builder-style object to manufacture [`ExportTask`](crate::model::ExportTask)
    pub fn builder() -> crate::model::export_task::Builder {
        crate::model::export_task::Builder::default()
    }
}

/// <p> This data type is used as a response element in the <code>DescribeEvents</code> action. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Event {
    /// <p>Provides the identifier for the source of the event.</p>
    pub source_identifier: std::option::Option<std::string::String>,
    /// <p>Specifies the source type for this event.</p>
    pub source_type: std::option::Option<crate::model::SourceType>,
    /// <p>Provides the text of this event.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>Specifies the category for the event.</p>
    pub event_categories: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Specifies the date and time of the event.</p>
    pub date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The Amazon Resource Name (ARN) for the event.</p>
    pub source_arn: std::option::Option<std::string::String>,
}
impl Event {
    /// <p>Provides the identifier for the source of the event.</p>
    pub fn source_identifier(&self) -> std::option::Option<&str> {
        self.source_identifier.as_deref()
    }
    /// <p>Specifies the source type for this event.</p>
    pub fn source_type(&self) -> std::option::Option<&crate::model::SourceType> {
        self.source_type.as_ref()
    }
    /// <p>Provides the text of this event.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
    /// <p>Specifies the category for the event.</p>
    pub fn event_categories(&self) -> std::option::Option<&[std::string::String]> {
        self.event_categories.as_deref()
    }
    /// <p>Specifies the date and time of the event.</p>
    pub fn date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.date.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) for the event.</p>
    pub fn source_arn(&self) -> std::option::Option<&str> {
        self.source_arn.as_deref()
    }
}
impl std::fmt::Debug for Event {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Event");
        formatter.field("source_identifier", &self.source_identifier);
        formatter.field("source_type", &self.source_type);
        formatter.field("message", &self.message);
        formatter.field("event_categories", &self.event_categories);
        formatter.field("date", &self.date);
        formatter.field("source_arn", &self.source_arn);
        formatter.finish()
    }
}
/// See [`Event`](crate::model::Event)
pub mod event {
    /// A builder for [`Event`](crate::model::Event)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_identifier: std::option::Option<std::string::String>,
        pub(crate) source_type: std::option::Option<crate::model::SourceType>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) event_categories: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) source_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Provides the identifier for the source of the event.</p>
        pub fn source_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_identifier = Some(input.into());
            self
        }
        /// <p>Provides the identifier for the source of the event.</p>
        pub fn set_source_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_identifier = input;
            self
        }
        /// <p>Specifies the source type for this event.</p>
        pub fn source_type(mut self, input: crate::model::SourceType) -> Self {
            self.source_type = Some(input);
            self
        }
        /// <p>Specifies the source type for this event.</p>
        pub fn set_source_type(
            mut self,
            input: std::option::Option<crate::model::SourceType>,
        ) -> Self {
            self.source_type = input;
            self
        }
        /// <p>Provides the text of this event.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>Provides the text of this event.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Appends an item to `event_categories`.
        ///
        /// To override the contents of this collection use [`set_event_categories`](Self::set_event_categories).
        ///
        /// <p>Specifies the category for the event.</p>
        pub fn event_categories(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.event_categories.unwrap_or_default();
            v.push(input.into());
            self.event_categories = Some(v);
            self
        }
        /// <p>Specifies the category for the event.</p>
        pub fn set_event_categories(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.event_categories = input;
            self
        }
        /// <p>Specifies the date and time of the event.</p>
        pub fn date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.date = Some(input);
            self
        }
        /// <p>Specifies the date and time of the event.</p>
        pub fn set_date(mut self, input: std::option::Option<aws_smithy_types::DateTime>) -> Self {
            self.date = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the event.</p>
        pub fn source_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the event.</p>
        pub fn set_source_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`Event`](crate::model::Event)
        pub fn build(self) -> crate::model::Event {
            crate::model::Event {
                source_identifier: self.source_identifier,
                source_type: self.source_type,
                message: self.message,
                event_categories: self.event_categories,
                date: self.date,
                source_arn: self.source_arn,
            }
        }
    }
}
impl Event {
    /// Creates a new builder-style object to manufacture [`Event`](crate::model::Event)
    pub fn builder() -> crate::model::event::Builder {
        crate::model::event::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SourceType {
    #[allow(missing_docs)] // documentation missing in model
    CustomEngineVersion,
    #[allow(missing_docs)] // documentation missing in model
    DbCluster,
    #[allow(missing_docs)] // documentation missing in model
    DbClusterSnapshot,
    #[allow(missing_docs)] // documentation missing in model
    DbInstance,
    #[allow(missing_docs)] // documentation missing in model
    DbParameterGroup,
    #[allow(missing_docs)] // documentation missing in model
    DbProxy,
    #[allow(missing_docs)] // documentation missing in model
    DbSecurityGroup,
    #[allow(missing_docs)] // documentation missing in model
    DbSnapshot,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SourceType {
    fn from(s: &str) -> Self {
        match s {
            "custom-engine-version" => SourceType::CustomEngineVersion,
            "db-cluster" => SourceType::DbCluster,
            "db-cluster-snapshot" => SourceType::DbClusterSnapshot,
            "db-instance" => SourceType::DbInstance,
            "db-parameter-group" => SourceType::DbParameterGroup,
            "db-proxy" => SourceType::DbProxy,
            "db-security-group" => SourceType::DbSecurityGroup,
            "db-snapshot" => SourceType::DbSnapshot,
            other => SourceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SourceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SourceType::from(s))
    }
}
impl SourceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SourceType::CustomEngineVersion => "custom-engine-version",
            SourceType::DbCluster => "db-cluster",
            SourceType::DbClusterSnapshot => "db-cluster-snapshot",
            SourceType::DbInstance => "db-instance",
            SourceType::DbParameterGroup => "db-parameter-group",
            SourceType::DbProxy => "db-proxy",
            SourceType::DbSecurityGroup => "db-security-group",
            SourceType::DbSnapshot => "db-snapshot",
            SourceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "custom-engine-version",
            "db-cluster",
            "db-cluster-snapshot",
            "db-instance",
            "db-parameter-group",
            "db-proxy",
            "db-security-group",
            "db-snapshot",
        ]
    }
}
impl AsRef<str> for SourceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Contains the results of a successful invocation of the <code>DescribeEventCategories</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EventCategoriesMap {
    /// <p>The source type that the returned categories belong to</p>
    pub source_type: std::option::Option<std::string::String>,
    /// <p>The event categories for the specified source type</p>
    pub event_categories: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl EventCategoriesMap {
    /// <p>The source type that the returned categories belong to</p>
    pub fn source_type(&self) -> std::option::Option<&str> {
        self.source_type.as_deref()
    }
    /// <p>The event categories for the specified source type</p>
    pub fn event_categories(&self) -> std::option::Option<&[std::string::String]> {
        self.event_categories.as_deref()
    }
}
impl std::fmt::Debug for EventCategoriesMap {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EventCategoriesMap");
        formatter.field("source_type", &self.source_type);
        formatter.field("event_categories", &self.event_categories);
        formatter.finish()
    }
}
/// See [`EventCategoriesMap`](crate::model::EventCategoriesMap)
pub mod event_categories_map {
    /// A builder for [`EventCategoriesMap`](crate::model::EventCategoriesMap)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_type: std::option::Option<std::string::String>,
        pub(crate) event_categories: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The source type that the returned categories belong to</p>
        pub fn source_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_type = Some(input.into());
            self
        }
        /// <p>The source type that the returned categories belong to</p>
        pub fn set_source_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source_type = input;
            self
        }
        /// Appends an item to `event_categories`.
        ///
        /// To override the contents of this collection use [`set_event_categories`](Self::set_event_categories).
        ///
        /// <p>The event categories for the specified source type</p>
        pub fn event_categories(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.event_categories.unwrap_or_default();
            v.push(input.into());
            self.event_categories = Some(v);
            self
        }
        /// <p>The event categories for the specified source type</p>
        pub fn set_event_categories(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.event_categories = input;
            self
        }
        /// Consumes the builder and constructs a [`EventCategoriesMap`](crate::model::EventCategoriesMap)
        pub fn build(self) -> crate::model::EventCategoriesMap {
            crate::model::EventCategoriesMap {
                source_type: self.source_type,
                event_categories: self.event_categories,
            }
        }
    }
}
impl EventCategoriesMap {
    /// Creates a new builder-style object to manufacture [`EventCategoriesMap`](crate::model::EventCategoriesMap)
    pub fn builder() -> crate::model::event_categories_map::Builder {
        crate::model::event_categories_map::Builder::default()
    }
}

/// <p> Contains the result of a successful invocation of the <code>DescribeEngineDefaultParameters</code> action. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EngineDefaults {
    /// <p>Specifies the name of the DB parameter group family that the engine default parameters apply to.</p>
    pub db_parameter_group_family: std::option::Option<std::string::String>,
    /// <p> An optional pagination token provided by a previous EngineDefaults request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code> . </p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>Contains a list of engine default parameters.</p>
    pub parameters: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
}
impl EngineDefaults {
    /// <p>Specifies the name of the DB parameter group family that the engine default parameters apply to.</p>
    pub fn db_parameter_group_family(&self) -> std::option::Option<&str> {
        self.db_parameter_group_family.as_deref()
    }
    /// <p> An optional pagination token provided by a previous EngineDefaults request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code> . </p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>Contains a list of engine default parameters.</p>
    pub fn parameters(&self) -> std::option::Option<&[crate::model::Parameter]> {
        self.parameters.as_deref()
    }
}
impl std::fmt::Debug for EngineDefaults {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EngineDefaults");
        formatter.field("db_parameter_group_family", &self.db_parameter_group_family);
        formatter.field("marker", &self.marker);
        formatter.field("parameters", &self.parameters);
        formatter.finish()
    }
}
/// See [`EngineDefaults`](crate::model::EngineDefaults)
pub mod engine_defaults {
    /// A builder for [`EngineDefaults`](crate::model::EngineDefaults)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_parameter_group_family: std::option::Option<std::string::String>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) parameters: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
    }
    impl Builder {
        /// <p>Specifies the name of the DB parameter group family that the engine default parameters apply to.</p>
        pub fn db_parameter_group_family(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_parameter_group_family = Some(input.into());
            self
        }
        /// <p>Specifies the name of the DB parameter group family that the engine default parameters apply to.</p>
        pub fn set_db_parameter_group_family(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_parameter_group_family = input;
            self
        }
        /// <p> An optional pagination token provided by a previous EngineDefaults request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code> . </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p> An optional pagination token provided by a previous EngineDefaults request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code> . </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Appends an item to `parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>Contains a list of engine default parameters.</p>
        pub fn parameters(mut self, input: crate::model::Parameter) -> Self {
            let mut v = self.parameters.unwrap_or_default();
            v.push(input);
            self.parameters = Some(v);
            self
        }
        /// <p>Contains a list of engine default parameters.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
        ) -> Self {
            self.parameters = input;
            self
        }
        /// Consumes the builder and constructs a [`EngineDefaults`](crate::model::EngineDefaults)
        pub fn build(self) -> crate::model::EngineDefaults {
            crate::model::EngineDefaults {
                db_parameter_group_family: self.db_parameter_group_family,
                marker: self.marker,
                parameters: self.parameters,
            }
        }
    }
}
impl EngineDefaults {
    /// Creates a new builder-style object to manufacture [`EngineDefaults`](crate::model::EngineDefaults)
    pub fn builder() -> crate::model::engine_defaults::Builder {
        crate::model::engine_defaults::Builder::default()
    }
}

/// <p>Contains the details of an Amazon RDS DB parameter group. </p>
/// <p>This data type is used as a response element in the <code>DescribeDBParameterGroups</code> action. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DbParameterGroup {
    /// <p>The name of the DB parameter group.</p>
    pub db_parameter_group_name: std::option::Option<std::string::String>,
    /// <p>The name of the DB parameter group family that this DB parameter group is compatible with.</p>
    pub db_parameter_group_family: std::option::Option<std::string::String>,
    /// <p>Provides the customer-specified description for this DB parameter group.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) for the DB parameter group.</p>
    pub db_parameter_group_arn: std::option::Option<std::string::String>,
}
impl DbParameterGroup {
    /// <p>The name of the DB parameter group.</p>
    pub fn db_parameter_group_name(&self) -> std::option::Option<&str> {
        self.db_parameter_group_name.as_deref()
    }
    /// <p>The name of the DB parameter group family that this DB parameter group is compatible with.</p>
    pub fn db_parameter_group_family(&self) -> std::option::Option<&str> {
        self.db_parameter_group_family.as_deref()
    }
    /// <p>Provides the customer-specified description for this DB parameter group.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) for the DB parameter group.</p>
    pub fn db_parameter_group_arn(&self) -> std::option::Option<&str> {
        self.db_parameter_group_arn.as_deref()
    }
}
impl std::fmt::Debug for DbParameterGroup {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DbParameterGroup");
        formatter.field("db_parameter_group_name", &self.db_parameter_group_name);
        formatter.field("db_parameter_group_family", &self.db_parameter_group_family);
        formatter.field("description", &self.description);
        formatter.field("db_parameter_group_arn", &self.db_parameter_group_arn);
        formatter.finish()
    }
}
/// See [`DbParameterGroup`](crate::model::DbParameterGroup)
pub mod db_parameter_group {
    /// A builder for [`DbParameterGroup`](crate::model::DbParameterGroup)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_parameter_group_name: std::option::Option<std::string::String>,
        pub(crate) db_parameter_group_family: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) db_parameter_group_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the DB parameter group.</p>
        pub fn db_parameter_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_parameter_group_name = Some(input.into());
            self
        }
        /// <p>The name of the DB parameter group.</p>
        pub fn set_db_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_parameter_group_name = input;
            self
        }
        /// <p>The name of the DB parameter group family that this DB parameter group is compatible with.</p>
        pub fn db_parameter_group_family(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_parameter_group_family = Some(input.into());
            self
        }
        /// <p>The name of the DB parameter group family that this DB parameter group is compatible with.</p>
        pub fn set_db_parameter_group_family(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_parameter_group_family = input;
            self
        }
        /// <p>Provides the customer-specified description for this DB parameter group.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>Provides the customer-specified description for this DB parameter group.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the DB parameter group.</p>
        pub fn db_parameter_group_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_parameter_group_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the DB parameter group.</p>
        pub fn set_db_parameter_group_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_parameter_group_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DbParameterGroup`](crate::model::DbParameterGroup)
        pub fn build(self) -> crate::model::DbParameterGroup {
            crate::model::DbParameterGroup {
                db_parameter_group_name: self.db_parameter_group_name,
                db_parameter_group_family: self.db_parameter_group_family,
                description: self.description,
                db_parameter_group_arn: self.db_parameter_group_arn,
            }
        }
    }
}
impl DbParameterGroup {
    /// Creates a new builder-style object to manufacture [`DbParameterGroup`](crate::model::DbParameterGroup)
    pub fn builder() -> crate::model::db_parameter_group::Builder {
        crate::model::db_parameter_group::Builder::default()
    }
}

/// <p>This data type is used as a response element to <code>DescribeDBLogFiles</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDbLogFilesDetails {
    /// <p>The name of the log file for the specified DB instance.</p>
    pub log_file_name: std::option::Option<std::string::String>,
    /// <p>A POSIX timestamp when the last log entry was written.</p>
    pub last_written: i64,
    /// <p>The size, in bytes, of the log file for the specified DB instance.</p>
    pub size: i64,
}
impl DescribeDbLogFilesDetails {
    /// <p>The name of the log file for the specified DB instance.</p>
    pub fn log_file_name(&self) -> std::option::Option<&str> {
        self.log_file_name.as_deref()
    }
    /// <p>A POSIX timestamp when the last log entry was written.</p>
    pub fn last_written(&self) -> i64 {
        self.last_written
    }
    /// <p>The size, in bytes, of the log file for the specified DB instance.</p>
    pub fn size(&self) -> i64 {
        self.size
    }
}
impl std::fmt::Debug for DescribeDbLogFilesDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDbLogFilesDetails");
        formatter.field("log_file_name", &self.log_file_name);
        formatter.field("last_written", &self.last_written);
        formatter.field("size", &self.size);
        formatter.finish()
    }
}
/// See [`DescribeDbLogFilesDetails`](crate::model::DescribeDbLogFilesDetails)
pub mod describe_db_log_files_details {
    /// A builder for [`DescribeDbLogFilesDetails`](crate::model::DescribeDbLogFilesDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) log_file_name: std::option::Option<std::string::String>,
        pub(crate) last_written: std::option::Option<i64>,
        pub(crate) size: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The name of the log file for the specified DB instance.</p>
        pub fn log_file_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.log_file_name = Some(input.into());
            self
        }
        /// <p>The name of the log file for the specified DB instance.</p>
        pub fn set_log_file_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.log_file_name = input;
            self
        }
        /// <p>A POSIX timestamp when the last log entry was written.</p>
        pub fn last_written(mut self, input: i64) -> Self {
            self.last_written = Some(input);
            self
        }
        /// <p>A POSIX timestamp when the last log entry was written.</p>
        pub fn set_last_written(mut self, input: std::option::Option<i64>) -> Self {
            self.last_written = input;
            self
        }
        /// <p>The size, in bytes, of the log file for the specified DB instance.</p>
        pub fn size(mut self, input: i64) -> Self {
            self.size = Some(input);
            self
        }
        /// <p>The size, in bytes, of the log file for the specified DB instance.</p>
        pub fn set_size(mut self, 