// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `AddRoleToDBCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AddRoleToDBClusterError {
    /// Kind of error that occurred.
    pub kind: AddRoleToDBClusterErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AddRoleToDBCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AddRoleToDBClusterErrorKind {
    /// <p> <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster. </p>
    DbClusterNotFoundFault(crate::error::DbClusterNotFoundFault),
    /// <p>The specified IAM role Amazon Resource Name (ARN) is already associated with the specified DB cluster.</p>
    DbClusterRoleAlreadyExistsFault(crate::error::DbClusterRoleAlreadyExistsFault),
    /// <p>You have exceeded the maximum number of IAM roles that can be associated with the specified DB cluster.</p>
    DbClusterRoleQuotaExceededFault(crate::error::DbClusterRoleQuotaExceededFault),
    /// <p>The requested operation can't be performed while the cluster is in this state.</p>
    InvalidDbClusterStateFault(crate::error::InvalidDbClusterStateFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AddRoleToDBClusterError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AddRoleToDBClusterErrorKind::DbClusterNotFoundFault(_inner) => _inner.fmt(f),
            AddRoleToDBClusterErrorKind::DbClusterRoleAlreadyExistsFault(_inner) => _inner.fmt(f),
            AddRoleToDBClusterErrorKind::DbClusterRoleQuotaExceededFault(_inner) => _inner.fmt(f),
            AddRoleToDBClusterErrorKind::InvalidDbClusterStateFault(_inner) => _inner.fmt(f),
            AddRoleToDBClusterErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AddRoleToDBClusterError {
    fn code(&self) -> Option<&str> {
        AddRoleToDBClusterError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AddRoleToDBClusterError {
    /// Creates a new `AddRoleToDBClusterError`.
    pub fn new(kind: AddRoleToDBClusterErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AddRoleToDBClusterError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AddRoleToDBClusterErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AddRoleToDBClusterError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AddRoleToDBClusterErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AddRoleToDBClusterErrorKind::DbClusterNotFoundFault`.
    pub fn is_db_cluster_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            AddRoleToDBClusterErrorKind::DbClusterNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `AddRoleToDBClusterErrorKind::DbClusterRoleAlreadyExistsFault`.
    pub fn is_db_cluster_role_already_exists_fault(&self) -> bool {
        matches!(
            &self.kind,
            AddRoleToDBClusterErrorKind::DbClusterRoleAlreadyExistsFault(_)
        )
    }
    /// Returns `true` if the error kind is `AddRoleToDBClusterErrorKind::DbClusterRoleQuotaExceededFault`.
    pub fn is_db_cluster_role_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            AddRoleToDBClusterErrorKind::DbClusterRoleQuotaExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `AddRoleToDBClusterErrorKind::InvalidDbClusterStateFault`.
    pub fn is_invalid_db_cluster_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            AddRoleToDBClusterErrorKind::InvalidDbClusterStateFault(_)
        )
    }
}
impl std::error::Error for AddRoleToDBClusterError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AddRoleToDBClusterErrorKind::DbClusterNotFoundFault(_inner) => Some(_inner),
            AddRoleToDBClusterErrorKind::DbClusterRoleAlreadyExistsFault(_inner) => Some(_inner),
            AddRoleToDBClusterErrorKind::DbClusterRoleQuotaExceededFault(_inner) => Some(_inner),
            AddRoleToDBClusterErrorKind::InvalidDbClusterStateFault(_inner) => Some(_inner),
            AddRoleToDBClusterErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AddRoleToDBInstance` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AddRoleToDBInstanceError {
    /// Kind of error that occurred.
    pub kind: AddRoleToDBInstanceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AddRoleToDBInstance` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AddRoleToDBInstanceErrorKind {
    /// <p> <code>DBInstanceIdentifier</code> doesn't refer to an existing DB instance. </p>
    DbInstanceNotFoundFault(crate::error::DbInstanceNotFoundFault),
    /// <p>The specified <code>RoleArn</code> or <code>FeatureName</code> value is already associated with the DB instance.</p>
    DbInstanceRoleAlreadyExistsFault(crate::error::DbInstanceRoleAlreadyExistsFault),
    /// <p>You can't associate any more Amazon Web Services Identity and Access Management (IAM) roles with the DB instance because the quota has been reached.</p>
    DbInstanceRoleQuotaExceededFault(crate::error::DbInstanceRoleQuotaExceededFault),
    /// <p>The DB instance isn't in a valid state.</p>
    InvalidDbInstanceStateFault(crate::error::InvalidDbInstanceStateFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AddRoleToDBInstanceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AddRoleToDBInstanceErrorKind::DbInstanceNotFoundFault(_inner) => _inner.fmt(f),
            AddRoleToDBInstanceErrorKind::DbInstanceRoleAlreadyExistsFault(_inner) => _inner.fmt(f),
            AddRoleToDBInstanceErrorKind::DbInstanceRoleQuotaExceededFault(_inner) => _inner.fmt(f),
            AddRoleToDBInstanceErrorKind::InvalidDbInstanceStateFault(_inner) => _inner.fmt(f),
            AddRoleToDBInstanceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AddRoleToDBInstanceError {
    fn code(&self) -> Option<&str> {
        AddRoleToDBInstanceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AddRoleToDBInstanceError {
    /// Creates a new `AddRoleToDBInstanceError`.
    pub fn new(kind: AddRoleToDBInstanceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AddRoleToDBInstanceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AddRoleToDBInstanceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AddRoleToDBInstanceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AddRoleToDBInstanceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AddRoleToDBInstanceErrorKind::DbInstanceNotFoundFault`.
    pub fn is_db_instance_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            AddRoleToDBInstanceErrorKind::DbInstanceNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `AddRoleToDBInstanceErrorKind::DbInstanceRoleAlreadyExistsFault`.
    pub fn is_db_instance_role_already_exists_fault(&self) -> bool {
        matches!(
            &self.kind,
            AddRoleToDBInstanceErrorKind::DbInstanceRoleAlreadyExistsFault(_)
        )
    }
    /// Returns `true` if the error kind is `AddRoleToDBInstanceErrorKind::DbInstanceRoleQuotaExceededFault`.
    pub fn is_db_instance_role_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            AddRoleToDBInstanceErrorKind::DbInstanceRoleQuotaExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `AddRoleToDBInstanceErrorKind::InvalidDbInstanceStateFault`.
    pub fn is_invalid_db_instance_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            AddRoleToDBInstanceErrorKind::InvalidDbInstanceStateFault(_)
        )
    }
}
impl std::error::Error for AddRoleToDBInstanceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AddRoleToDBInstanceErrorKind::DbInstanceNotFoundFault(_inner) => Some(_inner),
            AddRoleToDBInstanceErrorKind::DbInstanceRoleAlreadyExistsFault(_inner) => Some(_inner),
            AddRoleToDBInstanceErrorKind::DbInstanceRoleQuotaExceededFault(_inner) => Some(_inner),
            AddRoleToDBInstanceErrorKind::InvalidDbInstanceStateFault(_inner) => Some(_inner),
            AddRoleToDBInstanceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AddSourceIdentifierToSubscription` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AddSourceIdentifierToSubscriptionError {
    /// Kind of error that occurred.
    pub kind: AddSourceIdentifierToSubscriptionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AddSourceIdentifierToSubscription` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AddSourceIdentifierToSubscriptionErrorKind {
    /// <p>The requested source could not be found.</p>
    SourceNotFoundFault(crate::error::SourceNotFoundFault),
    /// <p>The subscription name does not exist.</p>
    SubscriptionNotFoundFault(crate::error::SubscriptionNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AddSourceIdentifierToSubscriptionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AddSourceIdentifierToSubscriptionErrorKind::SourceNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            AddSourceIdentifierToSubscriptionErrorKind::SubscriptionNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            AddSourceIdentifierToSubscriptionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AddSourceIdentifierToSubscriptionError {
    fn code(&self) -> Option<&str> {
        AddSourceIdentifierToSubscriptionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AddSourceIdentifierToSubscriptionError {
    /// Creates a new `AddSourceIdentifierToSubscriptionError`.
    pub fn new(
        kind: AddSourceIdentifierToSubscriptionErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AddSourceIdentifierToSubscriptionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AddSourceIdentifierToSubscriptionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AddSourceIdentifierToSubscriptionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AddSourceIdentifierToSubscriptionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AddSourceIdentifierToSubscriptionErrorKind::SourceNotFoundFault`.
    pub fn is_source_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            AddSourceIdentifierToSubscriptionErrorKind::SourceNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `AddSourceIdentifierToSubscriptionErrorKind::SubscriptionNotFoundFault`.
    pub fn is_subscription_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            AddSourceIdentifierToSubscriptionErrorKind::SubscriptionNotFoundFault(_)
        )
    }
}
impl std::error::Error for AddSourceIdentifierToSubscriptionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AddSourceIdentifierToSubscriptionErrorKind::SourceNotFoundFault(_inner) => Some(_inner),
            AddSourceIdentifierToSubscriptionErrorKind::SubscriptionNotFoundFault(_inner) => {
                Some(_inner)
            }
            AddSourceIdentifierToSubscriptionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AddTagsToResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AddTagsToResourceError {
    /// Kind of error that occurred.
    pub kind: AddTagsToResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AddTagsToResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AddTagsToResourceErrorKind {
    /// <p> <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster. </p>
    DbClusterNotFoundFault(crate::error::DbClusterNotFoundFault),
    /// <p> <code>DBInstanceIdentifier</code> doesn't refer to an existing DB instance. </p>
    DbInstanceNotFoundFault(crate::error::DbInstanceNotFoundFault),
    /// <p>The specified proxy name doesn't correspond to a proxy owned by your Amazon Web Services account in the specified Amazon Web Services Region.</p>
    DbProxyNotFoundFault(crate::error::DbProxyNotFoundFault),
    /// <p>The specified target group isn't available for a proxy owned by your Amazon Web Services account in the specified Amazon Web Services Region.</p>
    DbProxyTargetGroupNotFoundFault(crate::error::DbProxyTargetGroupNotFoundFault),
    /// <p> <code>DBSnapshotIdentifier</code> doesn't refer to an existing DB snapshot. </p>
    DbSnapshotNotFoundFault(crate::error::DbSnapshotNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AddTagsToResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AddTagsToResourceErrorKind::DbClusterNotFoundFault(_inner) => _inner.fmt(f),
            AddTagsToResourceErrorKind::DbInstanceNotFoundFault(_inner) => _inner.fmt(f),
            AddTagsToResourceErrorKind::DbProxyNotFoundFault(_inner) => _inner.fmt(f),
            AddTagsToResourceErrorKind::DbProxyTargetGroupNotFoundFault(_inner) => _inner.fmt(f),
            AddTagsToResourceErrorKind::DbSnapshotNotFoundFault(_inner) => _inner.fmt(f),
            AddTagsToResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AddTagsToResourceError {
    fn code(&self) -> Option<&str> {
        AddTagsToResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AddTagsToResourceError {
    /// Creates a new `AddTagsToResourceError`.
    pub fn new(kind: AddTagsToResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AddTagsToResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AddTagsToResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AddTagsToResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AddTagsToResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AddTagsToResourceErrorKind::DbClusterNotFoundFault`.
    pub fn is_db_cluster_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            AddTagsToResourceErrorKind::DbClusterNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `AddTagsToResourceErrorKind::DbInstanceNotFoundFault`.
    pub fn is_db_instance_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            AddTagsToResourceErrorKind::DbInstanceNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `AddTagsToResourceErrorKind::DbProxyNotFoundFault`.
    pub fn is_db_proxy_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            AddTagsToResourceErrorKind::DbProxyNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `AddTagsToResourceErrorKind::DbProxyTargetGroupNotFoundFault`.
    pub fn is_db_proxy_target_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            AddTagsToResourceErrorKind::DbProxyTargetGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `AddTagsToResourceErrorKind::DbSnapshotNotFoundFault`.
    pub fn is_db_snapshot_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            AddTagsToResourceErrorKind::DbSnapshotNotFoundFault(_)
        )
    }
}
impl std::error::Error for AddTagsToResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AddTagsToResourceErrorKind::DbClusterNotFoundFault(_inner) => Some(_inner),
            AddTagsToResourceErrorKind::DbInstanceNotFoundFault(_inner) => Some(_inner),
            AddTagsToResourceErrorKind::DbProxyNotFoundFault(_inner) => Some(_inner),
            AddTagsToResourceErrorKind::DbProxyTargetGroupNotFoundFault(_inner) => Some(_inner),
            AddTagsToResourceErrorKind::DbSnapshotNotFoundFault(_inner) => Some(_inner),
            AddTagsToResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ApplyPendingMaintenanceAction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ApplyPendingMaintenanceActionError {
    /// Kind of error that occurred.
    pub kind: ApplyPendingMaintenanceActionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ApplyPendingMaintenanceAction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ApplyPendingMaintenanceActionErrorKind {
    /// <p>The requested operation can't be performed while the cluster is in this state.</p>
    InvalidDbClusterStateFault(crate::error::InvalidDbClusterStateFault),
    /// <p>The DB instance isn't in a valid state.</p>
    InvalidDbInstanceStateFault(crate::error::InvalidDbInstanceStateFault),
    /// <p>The specified resource ID was not found.</p>
    ResourceNotFoundFault(crate::error::ResourceNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ApplyPendingMaintenanceActionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ApplyPendingMaintenanceActionErrorKind::InvalidDbClusterStateFault(_inner) => {
                _inner.fmt(f)
            }
            ApplyPendingMaintenanceActionErrorKind::InvalidDbInstanceStateFault(_inner) => {
                _inner.fmt(f)
            }
            ApplyPendingMaintenanceActionErrorKind::ResourceNotFoundFault(_inner) => _inner.fmt(f),
            ApplyPendingMaintenanceActionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ApplyPendingMaintenanceActionError {
    fn code(&self) -> Option<&str> {
        ApplyPendingMaintenanceActionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ApplyPendingMaintenanceActionError {
    /// Creates a new `ApplyPendingMaintenanceActionError`.
    pub fn new(
        kind: ApplyPendingMaintenanceActionErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ApplyPendingMaintenanceActionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ApplyPendingMaintenanceActionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ApplyPendingMaintenanceActionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ApplyPendingMaintenanceActionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ApplyPendingMaintenanceActionErrorKind::InvalidDbClusterStateFault`.
    pub fn is_invalid_db_cluster_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            ApplyPendingMaintenanceActionErrorKind::InvalidDbClusterStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `ApplyPendingMaintenanceActionErrorKind::InvalidDbInstanceStateFault`.
    pub fn is_invalid_db_instance_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            ApplyPendingMaintenanceActionErrorKind::InvalidDbInstanceStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `ApplyPendingMaintenanceActionErrorKind::ResourceNotFoundFault`.
    pub fn is_resource_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            ApplyPendingMaintenanceActionErrorKind::ResourceNotFoundFault(_)
        )
    }
}
impl std::error::Error for ApplyPendingMaintenanceActionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ApplyPendingMaintenanceActionErrorKind::InvalidDbClusterStateFault(_inner) => {
                Some(_inner)
            }
            ApplyPendingMaintenanceActionErrorKind::InvalidDbInstanceStateFault(_inner) => {
                Some(_inner)
            }
            ApplyPendingMaintenanceActionErrorKind::ResourceNotFoundFault(_inner) => Some(_inner),
            ApplyPendingMaintenanceActionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AuthorizeDBSecurityGroupIngress` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AuthorizeDBSecurityGroupIngressError {
    /// Kind of error that occurred.
    pub kind: AuthorizeDBSecurityGroupIngressErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AuthorizeDBSecurityGroupIngress` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AuthorizeDBSecurityGroupIngressErrorKind {
    /// <p>The specified CIDR IP range or Amazon EC2 security group is already authorized for the specified DB security group.</p>
    AuthorizationAlreadyExistsFault(crate::error::AuthorizationAlreadyExistsFault),
    /// <p>The DB security group authorization quota has been reached.</p>
    AuthorizationQuotaExceededFault(crate::error::AuthorizationQuotaExceededFault),
    /// <p> <code>DBSecurityGroupName</code> doesn't refer to an existing DB security group. </p>
    DbSecurityGroupNotFoundFault(crate::error::DbSecurityGroupNotFoundFault),
    /// <p>The state of the DB security group doesn't allow deletion.</p>
    InvalidDbSecurityGroupStateFault(crate::error::InvalidDbSecurityGroupStateFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AuthorizeDBSecurityGroupIngressError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AuthorizeDBSecurityGroupIngressErrorKind::AuthorizationAlreadyExistsFault(_inner) => {
                _inner.fmt(f)
            }
            AuthorizeDBSecurityGroupIngressErrorKind::AuthorizationQuotaExceededFault(_inner) => {
                _inner.fmt(f)
            }
            AuthorizeDBSecurityGroupIngressErrorKind::DbSecurityGroupNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            AuthorizeDBSecurityGroupIngressErrorKind::InvalidDbSecurityGroupStateFault(_inner) => {
                _inner.fmt(f)
            }
            AuthorizeDBSecurityGroupIngressErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AuthorizeDBSecurityGroupIngressError {
    fn code(&self) -> Option<&str> {
        AuthorizeDBSecurityGroupIngressError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AuthorizeDBSecurityGroupIngressError {
    /// Creates a new `AuthorizeDBSecurityGroupIngressError`.
    pub fn new(
        kind: AuthorizeDBSecurityGroupIngressErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AuthorizeDBSecurityGroupIngressError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AuthorizeDBSecurityGroupIngressErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AuthorizeDBSecurityGroupIngressError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AuthorizeDBSecurityGroupIngressErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AuthorizeDBSecurityGroupIngressErrorKind::AuthorizationAlreadyExistsFault`.
    pub fn is_authorization_already_exists_fault(&self) -> bool {
        matches!(
            &self.kind,
            AuthorizeDBSecurityGroupIngressErrorKind::AuthorizationAlreadyExistsFault(_)
        )
    }
    /// Returns `true` if the error kind is `AuthorizeDBSecurityGroupIngressErrorKind::AuthorizationQuotaExceededFault`.
    pub fn is_authorization_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            AuthorizeDBSecurityGroupIngressErrorKind::AuthorizationQuotaExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `AuthorizeDBSecurityGroupIngressErrorKind::DbSecurityGroupNotFoundFault`.
    pub fn is_db_security_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            AuthorizeDBSecurityGroupIngressErrorKind::DbSecurityGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `AuthorizeDBSecurityGroupIngressErrorKind::InvalidDbSecurityGroupStateFault`.
    pub fn is_invalid_db_security_group_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            AuthorizeDBSecurityGroupIngressErrorKind::InvalidDbSecurityGroupStateFault(_)
        )
    }
}
impl std::error::Error for AuthorizeDBSecurityGroupIngressError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AuthorizeDBSecurityGroupIngressErrorKind::AuthorizationAlreadyExistsFault(_inner) => {
                Some(_inner)
            }
            AuthorizeDBSecurityGroupIngressErrorKind::AuthorizationQuotaExceededFault(_inner) => {
                Some(_inner)
            }
            AuthorizeDBSecurityGroupIngressErrorKind::DbSecurityGroupNotFoundFault(_inner) => {
                Some(_inner)
            }
            AuthorizeDBSecurityGroupIngressErrorKind::InvalidDbSecurityGroupStateFault(_inner) => {
                Some(_inner)
            }
            AuthorizeDBSecurityGroupIngressErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `BacktrackDBCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BacktrackDBClusterError {
    /// Kind of error that occurred.
    pub kind: BacktrackDBClusterErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BacktrackDBCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BacktrackDBClusterErrorKind {
    /// <p> <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster. </p>
    DbClusterNotFoundFault(crate::error::DbClusterNotFoundFault),
    /// <p>The requested operation can't be performed while the cluster is in this state.</p>
    InvalidDbClusterStateFault(crate::error::InvalidDbClusterStateFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BacktrackDBClusterError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BacktrackDBClusterErrorKind::DbClusterNotFoundFault(_inner) => _inner.fmt(f),
            BacktrackDBClusterErrorKind::InvalidDbClusterStateFault(_inner) => _inner.fmt(f),
            BacktrackDBClusterErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for BacktrackDBClusterError {
    fn code(&self) -> Option<&str> {
        BacktrackDBClusterError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl BacktrackDBClusterError {
    /// Creates a new `BacktrackDBClusterError`.
    pub fn new(kind: BacktrackDBClusterErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BacktrackDBClusterError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BacktrackDBClusterErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `BacktrackDBClusterError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BacktrackDBClusterErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `BacktrackDBClusterErrorKind::DbClusterNotFoundFault`.
    pub fn is_db_cluster_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            BacktrackDBClusterErrorKind::DbClusterNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `BacktrackDBClusterErrorKind::InvalidDbClusterStateFault`.
    pub fn is_invalid_db_cluster_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            BacktrackDBClusterErrorKind::InvalidDbClusterStateFault(_)
        )
    }
}
impl std::error::Error for BacktrackDBClusterError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BacktrackDBClusterErrorKind::DbClusterNotFoundFault(_inner) => Some(_inner),
            BacktrackDBClusterErrorKind::InvalidDbClusterStateFault(_inner) => Some(_inner),
            BacktrackDBClusterErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CancelExportTask` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CancelExportTaskError {
    /// Kind of error that occurred.
    pub kind: CancelExportTaskErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CancelExportTask` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CancelExportTaskErrorKind {
    /// <p>The export task doesn't exist.</p>
    ExportTaskNotFoundFault(crate::error::ExportTaskNotFoundFault),
    /// <p>You can't cancel an export task that has completed.</p>
    InvalidExportTaskStateFault(crate::error::InvalidExportTaskStateFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CancelExportTaskError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CancelExportTaskErrorKind::ExportTaskNotFoundFault(_inner) => _inner.fmt(f),
            CancelExportTaskErrorKind::InvalidExportTaskStateFault(_inner) => _inner.fmt(f),
            CancelExportTaskErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CancelExportTaskError {
    fn code(&self) -> Option<&str> {
        CancelExportTaskError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CancelExportTaskError {
    /// Creates a new `CancelExportTaskError`.
    pub fn new(kind: CancelExportTaskErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CancelExportTaskError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CancelExportTaskErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CancelExportTaskError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CancelExportTaskErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CancelExportTaskErrorKind::ExportTaskNotFoundFault`.
    pub fn is_export_task_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            CancelExportTaskErrorKind::ExportTaskNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `CancelExportTaskErrorKind::InvalidExportTaskStateFault`.
    pub fn is_invalid_export_task_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            CancelExportTaskErrorKind::InvalidExportTaskStateFault(_)
        )
    }
}
impl std::error::Error for CancelExportTaskError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CancelExportTaskErrorKind::ExportTaskNotFoundFault(_inner) => Some(_inner),
            CancelExportTaskErrorKind::InvalidExportTaskStateFault(_inner) => Some(_inner),
            CancelExportTaskErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CopyDBClusterParameterGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CopyDBClusterParameterGroupError {
    /// Kind of error that occurred.
    pub kind: CopyDBClusterParameterGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CopyDBClusterParameterGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CopyDBClusterParameterGroupErrorKind {
    /// <p>A DB parameter group with the same name exists.</p>
    DbParameterGroupAlreadyExistsFault(crate::error::DbParameterGroupAlreadyExistsFault),
    /// <p> <code>DBParameterGroupName</code> doesn't refer to an existing DB parameter group. </p>
    DbParameterGroupNotFoundFault(crate::error::DbParameterGroupNotFoundFault),
    /// <p>The request would result in the user exceeding the allowed number of DB parameter groups.</p>
    DbParameterGroupQuotaExceededFault(crate::error::DbParameterGroupQuotaExceededFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CopyDBClusterParameterGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CopyDBClusterParameterGroupErrorKind::DbParameterGroupAlreadyExistsFault(_inner) => {
                _inner.fmt(f)
            }
            CopyDBClusterParameterGroupErrorKind::DbParameterGroupNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            CopyDBClusterParameterGroupErrorKind::DbParameterGroupQuotaExceededFault(_inner) => {
                _inner.fmt(f)
            }
            CopyDBClusterParameterGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CopyDBClusterParameterGroupError {
    fn code(&self) -> Option<&str> {
        CopyDBClusterParameterGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CopyDBClusterParameterGroupError {
    /// Creates a new `CopyDBClusterParameterGroupError`.
    pub fn new(kind: CopyDBClusterParameterGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CopyDBClusterParameterGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CopyDBClusterParameterGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CopyDBClusterParameterGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CopyDBClusterParameterGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CopyDBClusterParameterGroupErrorKind::DbParameterGroupAlreadyExistsFault`.
    pub fn is_db_parameter_group_already_exists_fault(&self) -> bool {
        matches!(
            &self.kind,
            CopyDBClusterParameterGroupErrorKind::DbParameterGroupAlreadyExistsFault(_)
        )
    }
    /// Returns `true` if the error kind is `CopyDBClusterParameterGroupErrorKind::DbParameterGroupNotFoundFault`.
    pub fn is_db_parameter_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            CopyDBClusterParameterGroupErrorKind::DbParameterGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `CopyDBClusterParameterGroupErrorKind::DbParameterGroupQuotaExceededFault`.
    pub fn is_db_parameter_group_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            CopyDBClusterParameterGroupErrorKind::DbParameterGroupQuotaExceededFault(_)
        )
    }
}
impl std::error::Error for CopyDBClusterParameterGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CopyDBClusterParameterGroupErrorKind::DbParameterGroupAlreadyExistsFault(_inner) => {
                Some(_inner)
            }
            CopyDBClusterParameterGroupErrorKind::DbParameterGroupNotFoundFault(_inner) => {
                Some(_inner)
            }
            CopyDBClusterParameterGroupErrorKind::DbParameterGroupQuotaExceededFault(_inner) => {
                Some(_inner)
            }
            CopyDBClusterParameterGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CopyDBClusterSnapshot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CopyDBClusterSnapshotError {
    /// Kind of error that occurred.
    pub kind: CopyDBClusterSnapshotErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CopyDBClusterSnapshot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CopyDBClusterSnapshotErrorKind {
    /// <p>The user already has a DB cluster snapshot with the given identifier.</p>
    DbClusterSnapshotAlreadyExistsFault(crate::error::DbClusterSnapshotAlreadyExistsFault),
    /// <p> <code>DBClusterSnapshotIdentifier</code> doesn't refer to an existing DB cluster snapshot. </p>
    DbClusterSnapshotNotFoundFault(crate::error::DbClusterSnapshotNotFoundFault),
    /// <p>The supplied value isn't a valid DB cluster snapshot state.</p>
    InvalidDbClusterSnapshotStateFault(crate::error::InvalidDbClusterSnapshotStateFault),
    /// <p>The requested operation can't be performed while the cluster is in this state.</p>
    InvalidDbClusterStateFault(crate::error::InvalidDbClusterStateFault),
    /// <p>An error occurred accessing an Amazon Web Services KMS key.</p>
    KmsKeyNotAccessibleFault(crate::error::KmsKeyNotAccessibleFault),
    /// <p>The request would result in the user exceeding the allowed number of DB snapshots.</p>
    SnapshotQuotaExceededFault(crate::error::SnapshotQuotaExceededFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CopyDBClusterSnapshotError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CopyDBClusterSnapshotErrorKind::DbClusterSnapshotAlreadyExistsFault(_inner) => {
                _inner.fmt(f)
            }
            CopyDBClusterSnapshotErrorKind::DbClusterSnapshotNotFoundFault(_inner) => _inner.fmt(f),
            CopyDBClusterSnapshotErrorKind::InvalidDbClusterSnapshotStateFault(_inner) => {
                _inner.fmt(f)
            }
            CopyDBClusterSnapshotErrorKind::InvalidDbClusterStateFault(_inner) => _inner.fmt(f),
            CopyDBClusterSnapshotErrorKind::KmsKeyNotAccessibleFault(_inner) => _inner.fmt(f),
            CopyDBClusterSnapshotErrorKind::SnapshotQuotaExceededFault(_inner) => _inner.fmt(f),
            CopyDBClusterSnapshotErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CopyDBClusterSnapshotError {
    fn code(&self) -> Option<&str> {
        CopyDBClusterSnapshotError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CopyDBClusterSnapshotError {
    /// Creates a new `CopyDBClusterSnapshotError`.
    pub fn new(kind: CopyDBClusterSnapshotErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CopyDBClusterSnapshotError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CopyDBClusterSnapshotErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CopyDBClusterSnapshotError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CopyDBClusterSnapshotErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CopyDBClusterSnapshotErrorKind::DbClusterSnapshotAlreadyExistsFault`.
    pub fn is_db_cluster_snapshot_already_exists_fault(&self) -> bool {
        matches!(
            &self.kind,
            CopyDBClusterSnapshotErrorKind::DbClusterSnapshotAlreadyExistsFault(_)
        )
    }
    /// Returns `true` if the error kind is `CopyDBClusterSnapshotErrorKind::DbClusterSnapshotNotFoundFault`.
    pub fn is_db_cluster_snapshot_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            CopyDBClusterSnapshotErrorKind::DbClusterSnapshotNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `CopyDBClusterSnapshotErrorKind::InvalidDbClusterSnapshotStateFault`.
    pub fn is_invalid_db_cluster_snapshot_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            CopyDBClusterSnapshotErrorKind::InvalidDbClusterSnapshotStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `CopyDBClusterSnapshotErrorKind::InvalidDbClusterStateFault`.
    pub fn is_invalid_db_cluster_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            CopyDBClusterSnapshotErrorKind::InvalidDbClusterStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `CopyDBClusterSnapshotErrorKind::KmsKeyNotAccessibleFault`.
    pub fn is_kms_key_not_accessible_fault(&self) -> bool {
        matches!(
            &self.kind,
            CopyDBClusterSnapshotErrorKind::KmsKeyNotAccessibleFault(_)
        )
    }
    /// Returns `true` if the error kind is `CopyDBClusterSnapshotErrorKind::SnapshotQuotaExceededFault`.
    pub fn is_snapshot_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            CopyDBClusterSnapshotErrorKind::SnapshotQuotaExceededFault(_)
        )
    }
}
impl std::error::Error for CopyDBClusterSnapshotError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CopyDBClusterSnapshotErrorKind::DbClusterSnapshotAlreadyExistsFault(_inner) => {
                Some(_inner)
            }
            CopyDBClusterSnapshotErrorKind::DbClusterSnapshotNotFoundFault(_inner) => Some(_inner),
            CopyDBClusterSnapshotErrorKind::InvalidDbClusterSnapshotStateFault(_inner) => {
                Some(_inner)
            }
            CopyDBClusterSnapshotErrorKind::InvalidDbClusterStateFault(_inner) => Some(_inner),
            CopyDBClusterSnapshotErrorKind::KmsKeyNotAccessibleFault(_inner) => Some(_inner),
            CopyDBClusterSnapshotErrorKind::SnapshotQuotaExceededFault(_inner) => Some(_inner),
            CopyDBClusterSnapshotErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CopyDBParameterGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CopyDBParameterGroupError {
    /// Kind of error that occurred.
    pub kind: CopyDBParameterGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CopyDBParameterGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CopyDBParameterGroupErrorKind {
    /// <p>A DB parameter group with the same name exists.</p>
    DbParameterGroupAlreadyExistsFault(crate::error::DbParameterGroupAlreadyExistsFault),
    /// <p> <code>DBParameterGroupName</code> doesn't refer to an existing DB parameter group. </p>
    DbParameterGroupNotFoundFault(crate::error::DbParameterGroupNotFoundFault),
    /// <p>The request would result in the user exceeding the allowed number of DB parameter groups.</p>
    DbParameterGroupQuotaExceededFault(crate::error::DbParameterGroupQuotaExceededFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CopyDBParameterGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CopyDBParameterGroupErrorKind::DbParameterGroupAlreadyExistsFault(_inner) => {
                _inner.fmt(f)
            }
            CopyDBParameterGroupErrorKind::DbParameterGroupNotFoundFault(_inner) => _inner.fmt(f),
            CopyDBParameterGroupErrorKind::DbParameterGroupQuotaExceededFault(_inner) => {
                _inner.fmt(f)
            }
            CopyDBParameterGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CopyDBParameterGroupError {
    fn code(&self) -> Option<&str> {
        CopyDBParameterGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CopyDBParameterGroupError {
    /// Creates a new `CopyDBParameterGroupError`.
    pub fn new(kind: CopyDBParameterGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CopyDBParameterGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CopyDBParameterGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CopyDBParameterGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CopyDBParameterGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CopyDBParameterGroupErrorKind::DbParameterGroupAlreadyExistsFault`.
    pub fn is_db_parameter_group_already_exists_fault(&self) -> bool {
        matches!(
            &self.kind,
            CopyDBParameterGroupErrorKind::DbParameterGroupAlreadyExistsFault(_)
        )
    }
    /// Returns `true` if the error kind is `CopyDBParameterGroupErrorKind::DbParameterGroupNotFoundFault`.
    pub fn is_db_parameter_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            CopyDBParameterGroupErrorKind::DbParameterGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `CopyDBParameterGroupErrorKind::DbParameterGroupQuotaExceededFault`.
    pub fn is_db_parameter_group_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            CopyDBParameterGroupErrorKind::DbParameterGroupQuotaExceededFault(_)
        )
    }
}
impl std::error::Error for CopyDBParameterGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CopyDBParameterGroupErrorKind::DbParameterGroupAlreadyExistsFault(_inner) => {
                Some(_inner)
            }
            CopyDBParameterGroupErrorKind::DbParameterGroupNotFoundFault(_inner) => Some(_inner),
            CopyDBParameterGroupErrorKind::DbParameterGroupQuotaExceededFault(_inner) => {
                Some(_inner)
            }
            CopyDBParameterGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CopyDBSnapshot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CopyDBSnapshotError {
    /// Kind of error that occurred.
    pub kind: CopyDBSnapshotErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CopyDBSnapshot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CopyDBSnapshotErrorKind {
    /// <p> <code>CustomAvailabilityZoneId</code> doesn't refer to an existing custom Availability Zone identifier.</p>
    CustomAvailabilityZoneNotFoundFault(crate::error::CustomAvailabilityZoneNotFoundFault),
    /// <p> <code>DBSnapshotIdentifier</code> is already used by an existing snapshot. </p>
    DbSnapshotAlreadyExistsFault(crate::error::DbSnapshotAlreadyExistsFault),
    /// <p> <code>DBSnapshotIdentifier</code> doesn't refer to an existing DB snapshot. </p>
    DbSnapshotNotFoundFault(crate::error::DbSnapshotNotFoundFault),
    /// <p>The state of the DB snapshot doesn't allow deletion.</p>
    InvalidDbSnapshotStateFault(crate::error::InvalidDbSnapshotStateFault),
    /// <p>An error occurred accessing an Amazon Web Services KMS key.</p>
    KmsKeyNotAccessibleFault(crate::error::KmsKeyNotAccessibleFault),
    /// <p>The request would result in the user exceeding the allowed number of DB snapshots.</p>
    SnapshotQuotaExceededFault(crate::error::SnapshotQuotaExceededFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CopyDBSnapshotError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CopyDBSnapshotErrorKind::CustomAvailabilityZoneNotFoundFault(_inner) => _inner.fmt(f),
            CopyDBSnapshotErrorKind::DbSnapshotAlreadyExistsFault(_inner) => _inner.fmt(f),
            CopyDBSnapshotErrorKind::DbSnapshotNotFoundFault(_inner) => _inner.fmt(f),
            CopyDBSnapshotErrorKind::InvalidDbSnapshotStateFault(_inner) => _inner.fmt(f),
            CopyDBSnapshotErrorKind::KmsKeyNotAccessibleFault(_inner) => _inner.fmt(f),
            CopyDBSnapshotErrorKind::SnapshotQuotaExceededFault(_inner) => _inner.fmt(f),
            CopyDBSnapshotErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CopyDBSnapshotError {
    fn code(&self) -> Option<&str> {
        CopyDBSnapshotError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CopyDBSnapshotError {
    /// Creates a new `CopyDBSnapshotError`.
    pub fn new(kind: CopyDBSnapshotErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CopyDBSnapshotError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CopyDBSnapshotErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CopyDBSnapshotError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CopyDBSnapshotErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CopyDBSnapshotErrorKind::CustomAvailabilityZoneNotFoundFault`.
    pub fn is_custom_availability_zone_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            CopyDBSnapshotErrorKind::CustomAvailabilityZoneNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `CopyDBSnapshotErrorKind::DbSnapshotAlreadyExistsFault`.
    pub fn is_db_snapshot_already_exists_fault(&self) -> bool {
        matches!(
            &self.kind,
            CopyDBSnapshotErrorKind::DbSnapshotAlreadyExistsFault(_)
        )
    }
    /// Returns `true` if the error kind is `CopyDBSnapshotErrorKind::DbSnapshotNotFoundFault`.
    pub fn is_db_snapshot_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            CopyDBSnapshotErrorKind::DbSnapshotNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `CopyDBSnapshotErrorKind::InvalidDbSnapshotStateFault`.
    pub fn is_invalid_db_snapshot_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            CopyDBSnapshotErrorKind::InvalidDbSnapshotStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `CopyDBSnapshotErrorKind::KmsKeyNotAccessibleFault`.
    pub fn is_kms_key_not_accessible_fault(&self) -> bool {
        matches!(
            &self.kind,
            CopyDBSnapshotErrorKind::KmsKeyNotAccessibleFault(_)
        )
    }
    /// Returns `true` if the error kind is `CopyDBSnapshotErrorKind::SnapshotQuotaExceededFault`.
    pub fn is_snapshot_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            CopyDBSnapshotErrorKind::SnapshotQuotaExceededFault(_)
        )
    }
}
impl std::error::Error for CopyDBSnapshotError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CopyDBSnapshotErrorKind::CustomAvailabilityZoneNotFoundFault(_inner) => Some(_inner),
            CopyDBSnapshotErrorKind::DbSnapshotAlreadyExistsFault(_inner) => Some(_inner),
            CopyDBSnapshotErrorKind::DbSnapshotNotFoundFault(_inner) => Some(_inner),
            CopyDBSnapshotErrorKind::InvalidDbSnapshotStateFault(_inner) => Some(_inner),
            CopyDBSnapshotErrorKind::KmsKeyNotAccessibleFault(_inner) => Some(_inner),
            CopyDBSnapshotErrorKind::SnapshotQuotaExceededFault(_inner) => Some(_inner),
            CopyDBSnapshotErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CopyOptionGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CopyOptionGroupError {
    /// Kind of error that occurred.
    pub kind: CopyOptionGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CopyOptionGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CopyOptionGroupErrorKind {
    /// <p>The option group you are trying to create already exists.</p>
    OptionGroupAlreadyExistsFault(crate::error::OptionGroupAlreadyExistsFault),
    /// <p>The specified option group could not be found.</p>
    OptionGroupNotFoundFault(crate::error::OptionGroupNotFoundFault),
    /// <p>The quota of 20 option groups was exceeded for this Amazon Web Services account.</p>
    OptionGroupQuotaExceededFault(crate::error::OptionGroupQuotaExceededFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CopyOptionGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CopyOptionGroupErrorKind::OptionGroupAlreadyExistsFault(_inner) => _inner.fmt(f),
            CopyOptionGroupErrorKind::OptionGroupNotFoundFault(_inner) => _inner.fmt(f),
            CopyOptionGroupErrorKind::OptionGroupQuotaExceededFault(_inner) => _inner.fmt(f),
            CopyOptionGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CopyOptionGroupError {
    fn code(&self) -> Option<&str> {
        CopyOptionGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CopyOptionGroupError {
    /// Creates a new `CopyOptionGroupError`.
    pub fn new(kind: CopyOptionGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CopyOptionGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CopyOptionGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CopyOptionGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CopyOptionGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CopyOptionGroupErrorKind::OptionGroupAlreadyExistsFault`.
    pub fn is_option_group_already_exists_fault(&self) -> bool {
        matches!(
            &self.kind,
            CopyOptionGroupErrorKind::OptionGroupAlreadyExistsFault(_)
        )
    }
    /// Returns `true` if the error kind is `CopyOptionGroupErrorKind::OptionGroupNotFoundFault`.
    pub fn is_option_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            CopyOptionGroupErrorKind::OptionGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `CopyOptionGroupErrorKind::OptionGroupQuotaExceededFault`.
    pub fn is_option_group_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            CopyOptionGroupErrorKind::OptionGroupQuotaExceededFault(_)
        )
    }
}
impl std::error::Error for CopyOptionGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CopyOptionGroupErrorKind::OptionGroupAlreadyExistsFault(_inner) => Some(_inner),
            CopyOptionGroupErrorKind::OptionGroupNotFoundFault(_inner) => Some(_inner),
            CopyOptionGroupErrorKind::OptionGroupQuotaExceededFault(_inner) => Some(_inner),
            CopyOptionGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateCustomAvailabilityZone` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateCustomAvailabilityZoneError {
    /// Kind of error that occurred.
    pub kind: CreateCustomAvailabilityZoneErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateCustomAvailabilityZone` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateCustomAvailabilityZoneErrorKind {
    /// <p> <code>CustomAvailabilityZoneName</code> is already used by an existing custom Availability Zone.</p>
    CustomAvailabilityZoneAlreadyExistsFault(
        crate::error::CustomAvailabilityZoneAlreadyExistsFault,
    ),
    /// <p>You have exceeded the maximum number of custom Availability Zones.</p>
    CustomAvailabilityZoneQuotaExceededFault(
        crate::error::CustomAvailabilityZoneQuotaExceededFault,
    ),
    /// <p>An error occurred accessing an Amazon Web Services KMS key.</p>
    KmsKeyNotAccessibleFault(crate::error::KmsKeyNotAccessibleFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateCustomAvailabilityZoneError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateCustomAvailabilityZoneErrorKind::CustomAvailabilityZoneAlreadyExistsFault(
                _inner,
            ) => _inner.fmt(f),
            CreateCustomAvailabilityZoneErrorKind::CustomAvailabilityZoneQuotaExceededFault(
                _inner,
            ) => _inner.fmt(f),
            CreateCustomAvailabilityZoneErrorKind::KmsKeyNotAccessibleFault(_inner) => {
                _inner.fmt(f)
            }
            CreateCustomAvailabilityZoneErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateCustomAvailabilityZoneError {
    fn code(&self) -> Option<&str> {
        CreateCustomAvailabilityZoneError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateCustomAvailabilityZoneError {
    /// Creates a new `CreateCustomAvailabilityZoneError`.
    pub fn new(kind: CreateCustomAvailabilityZoneErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateCustomAvailabilityZoneError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateCustomAvailabilityZoneErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateCustomAvailabilityZoneError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateCustomAvailabilityZoneErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateCustomAvailabilityZoneErrorKind::CustomAvailabilityZoneAlreadyExistsFault`.
    pub fn is_custom_availability_zone_already_exists_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateCustomAvailabilityZoneErrorKind::CustomAvailabilityZoneAlreadyExistsFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCustomAvailabilityZoneErrorKind::CustomAvailabilityZoneQuotaExceededFault`.
    pub fn is_custom_availability_zone_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateCustomAvailabilityZoneErrorKind::CustomAvailabilityZoneQuotaExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCustomAvailabilityZoneErrorKind::KmsKeyNotAccessibleFault`.
    pub fn is_kms_key_not_accessible_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateCustomAvailabilityZoneErrorKind::KmsKeyNotAccessibleFault(_)
        )
    }
}
impl std::error::Error for CreateCustomAvailabilityZoneError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateCustomAvailabilityZoneErrorKind::CustomAvailabilityZoneAlreadyExistsFault(
                _inner,
            ) => Some(_inner),
            CreateCustomAvailabilityZoneErrorKind::CustomAvailabilityZoneQuotaExceededFault(
                _inner,
            ) => Some(_inner),
            CreateCustomAvailabilityZoneErrorKind::KmsKeyNotAccessibleFault(_inner) => Some(_inner),
            CreateCustomAvailabilityZoneErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateCustomDBEngineVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateCustomDBEngineVersionError {
    /// Kind of error that occurred.
    pub kind: CreateCustomDBEngineVersionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateCustomDBEngineVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateCustomDBEngineVersionErrorKind {
    /// <p>A CEV with the specified name already exists.</p>
    CustomDbEngineVersionAlreadyExistsFault(crate::error::CustomDbEngineVersionAlreadyExistsFault),
    /// <p>You have exceeded your CEV quota.</p>
    CustomDbEngineVersionQuotaExceededFault(crate::error::CustomDbEngineVersionQuotaExceededFault),
    /// <p>An error occurred accessing an Amazon Web Services KMS key.</p>
    KmsKeyNotAccessibleFault(crate::error::KmsKeyNotAccessibleFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateCustomDBEngineVersionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateCustomDBEngineVersionErrorKind::CustomDbEngineVersionAlreadyExistsFault(
                _inner,
            ) => _inner.fmt(f),
            CreateCustomDBEngineVersionErrorKind::CustomDbEngineVersionQuotaExceededFault(
                _inner,
            ) => _inner.fmt(f),
            CreateCustomDBEngineVersionErrorKind::KmsKeyNotAccessibleFault(_inner) => _inner.fmt(f),
            CreateCustomDBEngineVersionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateCustomDBEngineVersionError {
    fn code(&self) -> Option<&str> {
        CreateCustomDBEngineVersionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateCustomDBEngineVersionError {
    /// Creates a new `CreateCustomDBEngineVersionError`.
    pub fn new(kind: CreateCustomDBEngineVersionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateCustomDBEngineVersionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateCustomDBEngineVersionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateCustomDBEngineVersionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateCustomDBEngineVersionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateCustomDBEngineVersionErrorKind::CustomDbEngineVersionAlreadyExistsFault`.
    pub fn is_custom_db_engine_version_already_exists_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateCustomDBEngineVersionErrorKind::CustomDbEngineVersionAlreadyExistsFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCustomDBEngineVersionErrorKind::CustomDbEngineVersionQuotaExceededFault`.
    pub fn is_custom_db_engine_version_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateCustomDBEngineVersionErrorKind::CustomDbEngineVersionQuotaExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCustomDBEngineVersionErrorKind::KmsKeyNotAccessibleFault`.
    pub fn is_kms_key_not_accessible_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateCustomDBEngineVersionErrorKind::KmsKeyNotAccessibleFault(_)
        )
    }
}
impl std::error::Error for CreateCustomDBEngineVersionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateCustomDBEngineVersionErrorKind::CustomDbEngineVersionAlreadyExistsFault(
                _inner,
            ) => Some(_inner),
            CreateCustomDBEngineVersionErrorKind::CustomDbEngineVersionQuotaExceededFault(
                _inner,
            ) => Some(_inner),
            CreateCustomDBEngineVersionErrorKind::KmsKeyNotAccessibleFault(_inner) => Some(_inner),
            CreateCustomDBEngineVersionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateDBCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateDBClusterError {
    /// Kind of error that occurred.
    pub kind: CreateDBClusterErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateDBCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateDBClusterErrorKind {
    /// <p>The user already has a DB cluster with the given identifier.</p>
    DbClusterAlreadyExistsFault(crate::error::DbClusterAlreadyExistsFault),
    /// <p> <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster. </p>
    DbClusterNotFoundFault(crate::error::DbClusterNotFoundFault),
    /// <p> <code>DBClusterParameterGroupName</code> doesn't refer to an existing DB cluster parameter group. </p>
    DbClusterParameterGroupNotFoundFault(crate::error::DbClusterParameterGroupNotFoundFault),
    /// <p>The user attempted to create a new DB cluster and the user has already reached the maximum allowed DB cluster quota.</p>
    DbClusterQuotaExceededFault(crate::error::DbClusterQuotaExceededFault),
    /// <p> <code>DBInstanceIdentifier</code> doesn't refer to an existing DB instance. </p>
    DbInstanceNotFoundFault(crate::error::DbInstanceNotFoundFault),
    /// <p>Subnets in the DB subnet group should cover at least two Availability Zones unless there is only one Availability Zone.</p>
    DbSubnetGroupDoesNotCoverEnoughAZs(crate::error::DbSubnetGroupDoesNotCoverEnoughAZs),
    /// <p> <code>DBSubnetGroupName</code> doesn't refer to an existing DB subnet group. </p>
    DbSubnetGroupNotFoundFault(crate::error::DbSubnetGroupNotFoundFault),
    /// <p> <code>Domain</code> doesn't refer to an existing Active Directory domain. </p>
    DomainNotFoundFault(crate::error::DomainNotFoundFault),
    /// <p>The <code>GlobalClusterIdentifier</code> doesn't refer to an existing global database cluster. </p>
    GlobalClusterNotFoundFault(crate::error::GlobalClusterNotFoundFault),
    /// <p>There is insufficient storage available for the current action. You might be able to resolve this error by updating your subnet group to use different Availability Zones that have more storage available.</p>
    InsufficientStorageClusterCapacityFault(crate::error::InsufficientStorageClusterCapacityFault),
    /// <p>The requested operation can't be performed while the cluster is in this state.</p>
    InvalidDbClusterStateFault(crate::error::InvalidDbClusterStateFault),
    /// <p>The DB instance isn't in a valid state.</p>
    InvalidDbInstanceStateFault(crate::error::InvalidDbInstanceStateFault),
    /// <p>The DB subnet group cannot be deleted because it's in use.</p>
    InvalidDbSubnetGroupStateFault(crate::error::InvalidDbSubnetGroupStateFault),
    /// <p>The global cluster is in an invalid state and can't perform the requested operation. </p>
    InvalidGlobalClusterStateFault(crate::error::InvalidGlobalClusterStateFault),
    /// <p>The requested subnet is invalid, or multiple subnets were requested that are not all in a common VPC.</p>
    InvalidSubnet(crate::error::InvalidSubnet),
    /// <p>The DB subnet group doesn't cover all Availability Zones after it's created because of users' change.</p>
    InvalidVpcNetworkStateFault(crate::error::InvalidVpcNetworkStateFault),
    /// <p>An error occurred accessing an Amazon Web Services KMS key.</p>
    KmsKeyNotAccessibleFault(crate::error::KmsKeyNotAccessibleFault),
    /// <p>The request would result in the user exceeding the allowed amount of storage available across all DB instances.</p>
    StorageQuotaExceededFault(crate::error::StorageQuotaExceededFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateDBClusterError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateDBClusterErrorKind::DbClusterAlreadyExistsFault(_inner) => _inner.fmt(f),
            CreateDBClusterErrorKind::DbClusterNotFoundFault(_inner) => _inner.fmt(f),
            CreateDBClusterErrorKind::DbClusterParameterGroupNotFoundFault(_inner) => _inner.fmt(f),
            CreateDBClusterErrorKind::DbClusterQuotaExceededFault(_inner) => _inner.fmt(f),
            CreateDBClusterErrorKind::DbInstanceNotFoundFault(_inner) => _inner.fmt(f),
            CreateDBClusterErrorKind::DbSubnetGroupDoesNotCoverEnoughAZs(_inner) => _inner.fmt(f),
            CreateDBClusterErrorKind::DbSubnetGroupNotFoundFault(_inner) => _inner.fmt(f),
            CreateDBClusterErrorKind::DomainNotFoundFault(_inner) => _inner.fmt(f),
            CreateDBClusterErrorKind::GlobalClusterNotFoundFault(_inner) => _inner.fmt(f),
            CreateDBClusterErrorKind::InsufficientStorageClusterCapacityFault(_inner) => {
                _inner.fmt(f)
            }
            CreateDBClusterErrorKind::InvalidDbClusterStateFault(_inner) => _inner.fmt(f),
            CreateDBClusterErrorKind::InvalidDbInstanceStateFault(_inner) => _inner.fmt(f),
            CreateDBClusterErrorKind::InvalidDbSubnetGroupStateFault(_inner) => _inner.fmt(f),
            CreateDBClusterErrorKind::InvalidGlobalClusterStateFault(_inner) => _inner.fmt(f),
            CreateDBClusterErrorKind::InvalidSubnet(_inner) => _inner.fmt(f),
            CreateDBClusterErrorKind::InvalidVpcNetworkStateFault(_inner) => _inner.fmt(f),
            CreateDBClusterErrorKind::KmsKeyNotAccessibleFault(_inner) => _inner.fmt(f),
            CreateDBClusterErrorKind::StorageQuotaExceededFault(_inner) => _inner.fmt(f),
            CreateDBClusterErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateDBClusterError {
    fn code(&self) -> Option<&str> {
        CreateDBClusterError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateDBClusterError {
    /// Creates a new `CreateDBClusterError`.
    pub fn new(kind: CreateDBClusterErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateDBClusterError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateDBClusterErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateDBClusterError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateDBClusterErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateDBClusterErrorKind::DbClusterAlreadyExistsFault`.
    pub fn is_db_cluster_already_exists_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBClusterErrorKind::DbClusterAlreadyExistsFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBClusterErrorKind::DbClusterNotFoundFault`.
    pub fn is_db_cluster_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBClusterErrorKind::DbClusterNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBClusterErrorKind::DbClusterParameterGroupNotFoundFault`.
    pub fn is_db_cluster_parameter_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBClusterErrorKind::DbClusterParameterGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBClusterErrorKind::DbClusterQuotaExceededFault`.
    pub fn is_db_cluster_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBClusterErrorKind::DbClusterQuotaExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBClusterErrorKind::DbInstanceNotFoundFault`.
    pub fn is_db_instance_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBClusterErrorKind::DbInstanceNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBClusterErrorKind::DbSubnetGroupDoesNotCoverEnoughAZs`.
    pub fn is_db_subnet_group_does_not_cover_enough_a_zs(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBClusterErrorKind::DbSubnetGroupDoesNotCoverEnoughAZs(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBClusterErrorKind::DbSubnetGroupNotFoundFault`.
    pub fn is_db_subnet_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBClusterErrorKind::DbSubnetGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBClusterErrorKind::DomainNotFoundFault`.
    pub fn is_domain_not_found_fault(&self) -> bool {
        matches!(&self.kind, CreateDBClusterErrorKind::DomainNotFoundFault(_))
    }
    /// Returns `true` if the error kind is `CreateDBClusterErrorKind::GlobalClusterNotFoundFault`.
    pub fn is_global_cluster_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBClusterErrorKind::GlobalClusterNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBClusterErrorKind::InsufficientStorageClusterCapacityFault`.
    pub fn is_insufficient_storage_cluster_capacity_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBClusterErrorKind::InsufficientStorageClusterCapacityFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBClusterErrorKind::InvalidDbClusterStateFault`.
    pub fn is_invalid_db_cluster_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBClusterErrorKind::InvalidDbClusterStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBClusterErrorKind::InvalidDbInstanceStateFault`.
    pub fn is_invalid_db_instance_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBClusterErrorKind::InvalidDbInstanceStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBClusterErrorKind::InvalidDbSubnetGroupStateFault`.
    pub fn is_invalid_db_subnet_group_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBClusterErrorKind::InvalidDbSubnetGroupStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBClusterErrorKind::InvalidGlobalClusterStateFault`.
    pub fn is_invalid_global_cluster_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBClusterErrorKind::InvalidGlobalClusterStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBClusterErrorKind::InvalidSubnet`.
    pub fn is_invalid_subnet(&self) -> bool {
        matches!(&self.kind, CreateDBClusterErrorKind::InvalidSubnet(_))
    }
    /// Returns `true` if the error kind is `CreateDBClusterErrorKind::InvalidVpcNetworkStateFault`.
    pub fn is_invalid_vpc_network_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBClusterErrorKind::InvalidVpcNetworkStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBClusterErrorKind::KmsKeyNotAccessibleFault`.
    pub fn is_kms_key_not_accessible_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBClusterErrorKind::KmsKeyNotAccessibleFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBClusterErrorKind::StorageQuotaExceededFault`.
    pub fn is_storage_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBClusterErrorKind::StorageQuotaExceededFault(_)
        )
    }
}
impl std::error::Error for CreateDBClusterError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateDBClusterErrorKind::DbClusterAlreadyExistsFault(_inner) => Some(_inner),
            CreateDBClusterErrorKind::DbClusterNotFoundFault(_inner) => Some(_inner),
            CreateDBClusterErrorKind::DbClusterParameterGroupNotFoundFault(_inner) => Some(_inner),
            CreateDBClusterErrorKind::DbClusterQuotaExceededFault(_inner) => Some(_inner),
            CreateDBClusterErrorKind::DbInstanceNotFoundFault(_inner) => Some(_inner),
            CreateDBClusterErrorKind::DbSubnetGroupDoesNotCoverEnoughAZs(_inner) => Some(_inner),
            CreateDBClusterErrorKind::DbSubnetGroupNotFoundFault(_inner) => Some(_inner),
            CreateDBClusterErrorKind::DomainNotFoundFault(_inner) => Some(_inner),
            CreateDBClusterErrorKind::GlobalClusterNotFoundFault(_inner) => Some(_inner),
            CreateDBClusterErrorKind::InsufficientStorageClusterCapacityFault(_inner) => {
                Some(_inner)
            }
            CreateDBClusterErrorKind::InvalidDbClusterStateFault(_inner) => Some(_inner),
            CreateDBClusterErrorKind::InvalidDbInstanceStateFault(_inner) => Some(_inner),
            CreateDBClusterErrorKind::InvalidDbSubnetGroupStateFault(_inner) => Some(_inner),
            CreateDBClusterErrorKind::InvalidGlobalClusterStateFault(_inner) => Some(_inner),
            CreateDBClusterErrorKind::InvalidSubnet(_inner) => Some(_inner),
            CreateDBClusterErrorKind::InvalidVpcNetworkStateFault(_inner) => Some(_inner),
            CreateDBClusterErrorKind::KmsKeyNotAccessibleFault(_inner) => Some(_inner),
            CreateDBClusterErrorKind::StorageQuotaExceededFault(_inner) => Some(_inner),
            CreateDBClusterErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateDBClusterEndpoint` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateDBClusterEndpointError {
    /// Kind of error that occurred.
    pub kind: CreateDBClusterEndpointErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateDBClusterEndpoint` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateDBClusterEndpointErrorKind {
    /// <p>The specified custom endpoint can't be created because it already exists.</p>
    DbClusterEndpointAlreadyExistsFault(crate::error::DbClusterEndpointAlreadyExistsFault),
    /// <p>The cluster already has the maximum number of custom endpoints.</p>
    DbClusterEndpointQuotaExceededFault(crate::error::DbClusterEndpointQuotaExceededFault),
    /// <p> <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster. </p>
    DbClusterNotFoundFault(crate::error::DbClusterNotFoundFault),
    /// <p> <code>DBInstanceIdentifier</code> doesn't refer to an existing DB instance. </p>
    DbInstanceNotFoundFault(crate::error::DbInstanceNotFoundFault),
    /// <p>The requested operation can't be performed while the cluster is in this state.</p>
    InvalidDbClusterStateFault(crate::error::InvalidDbClusterStateFault),
    /// <p>The DB instance isn't in a valid state.</p>
    InvalidDbInstanceStateFault(crate::error::InvalidDbInstanceStateFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateDBClusterEndpointError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateDBClusterEndpointErrorKind::DbClusterEndpointAlreadyExistsFault(_inner) => {
                _inner.fmt(f)
            }
            CreateDBClusterEndpointErrorKind::DbClusterEndpointQuotaExceededFault(_inner) => {
                _inner.fmt(f)
            }
            CreateDBClusterEndpointErrorKind::DbClusterNotFoundFault(_inner) => _inner.fmt(f),
            CreateDBClusterEndpointErrorKind::DbInstanceNotFoundFault(_inner) => _inner.fmt(f),
            CreateDBClusterEndpointErrorKind::InvalidDbClusterStateFault(_inner) => _inner.fmt(f),
            CreateDBClusterEndpointErrorKind::InvalidDbInstanceStateFault(_inner) => _inner.fmt(f),
            CreateDBClusterEndpointErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateDBClusterEndpointError {
    fn code(&self) -> Option<&str> {
        CreateDBClusterEndpointError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateDBClusterEndpointError {
    /// Creates a new `CreateDBClusterEndpointError`.
    pub fn new(kind: CreateDBClusterEndpointErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateDBClusterEndpointError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateDBClusterEndpointErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateDBClusterEndpointError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateDBClusterEndpointErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateDBClusterEndpointErrorKind::DbClusterEndpointAlreadyExistsFault`.
    pub fn is_db_cluster_endpoint_already_exists_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBClusterEndpointErrorKind::DbClusterEndpointAlreadyExistsFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBClusterEndpointErrorKind::DbClusterEndpointQuotaExceededFault`.
    pub fn is_db_cluster_endpoint_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBClusterEndpointErrorKind::DbClusterEndpointQuotaExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBClusterEndpointErrorKind::DbClusterNotFoundFault`.
    pub fn is_db_cluster_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBClusterEndpointErrorKind::DbClusterNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBClusterEndpointErrorKind::DbInstanceNotFoundFault`.
    pub fn is_db_instance_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBClusterEndpointErrorKind::DbInstanceNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBClusterEndpointErrorKind::InvalidDbClusterStateFault`.
    pub fn is_invalid_db_cluster_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBClusterEndpointErrorKind::InvalidDbClusterStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBClusterEndpointErrorKind::InvalidDbInstanceStateFault`.
    pub fn is_invalid_db_instance_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBClusterEndpointErrorKind::InvalidDbInstanceStateFault(_)
        )
    }
}
impl std::error::Error for CreateDBClusterEndpointError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateDBClusterEndpointErrorKind::DbClusterEndpointAlreadyExistsFault(_inner) => {
                Some(_inner)
            }
            CreateDBClusterEndpointErrorKind::DbClusterEndpointQuotaExceededFault(_inner) => {
                Some(_inner)
            }
            CreateDBClusterEndpointErrorKind::DbClusterNotFoundFault(_inner) => Some(_inner),
            CreateDBClusterEndpointErrorKind::DbInstanceNotFoundFault(_inner) => Some(_inner),
            CreateDBClusterEndpointErrorKind::InvalidDbClusterStateFault(_inner) => Some(_inner),
            CreateDBClusterEndpointErrorKind::InvalidDbInstanceStateFault(_inner) => Some(_inner),
            CreateDBClusterEndpointErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateDBClusterParameterGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateDBClusterParameterGroupError {
    /// Kind of error that occurred.
    pub kind: CreateDBClusterParameterGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateDBClusterParameterGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateDBClusterParameterGroupErrorKind {
    /// <p>A DB parameter group with the same name exists.</p>
    DbParameterGroupAlreadyExistsFault(crate::error::DbParameterGroupAlreadyExistsFault),
    /// <p>The request would result in the user exceeding the allowed number of DB parameter groups.</p>
    DbParameterGroupQuotaExceededFault(crate::error::DbParameterGroupQuotaExceededFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateDBClusterParameterGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateDBClusterParameterGroupErrorKind::DbParameterGroupAlreadyExistsFault(_inner) => {
                _inner.fmt(f)
            }
            CreateDBClusterParameterGroupErrorKind::DbParameterGroupQuotaExceededFault(_inner) => {
                _inner.fmt(f)
            }
            CreateDBClusterParameterGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateDBClusterParameterGroupError {
    fn code(&self) -> Option<&str> {
        CreateDBClusterParameterGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateDBClusterParameterGroupError {
    /// Creates a new `CreateDBClusterParameterGroupError`.
    pub fn new(
        kind: CreateDBClusterParameterGroupErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateDBClusterParameterGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateDBClusterParameterGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateDBClusterParameterGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateDBClusterParameterGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateDBClusterParameterGroupErrorKind::DbParameterGroupAlreadyExistsFault`.
    pub fn is_db_parameter_group_already_exists_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBClusterParameterGroupErrorKind::DbParameterGroupAlreadyExistsFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBClusterParameterGroupErrorKind::DbParameterGroupQuotaExceededFault`.
    pub fn is_db_parameter_group_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBClusterParameterGroupErrorKind::DbParameterGroupQuotaExceededFault(_)
        )
    }
}
impl std::error::Error for CreateDBClusterParameterGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateDBClusterParameterGroupErrorKind::DbParameterGroupAlreadyExistsFault(_inner) => {
                Some(_inner)
            }
            CreateDBClusterParameterGroupErrorKind::DbParameterGroupQuotaExceededFault(_inner) => {
                Some(_inner)
            }
            CreateDBClusterParameterGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateDBClusterSnapshot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateDBClusterSnapshotError {
    /// Kind of error that occurred.
    pub kind: CreateDBClusterSnapshotErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateDBClusterSnapshot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateDBClusterSnapshotErrorKind {
    /// <p> <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster. </p>
    DbClusterNotFoundFault(crate::error::DbClusterNotFoundFault),
    /// <p>The user already has a DB cluster snapshot with the given identifier.</p>
    DbClusterSnapshotAlreadyExistsFault(crate::error::DbClusterSnapshotAlreadyExistsFault),
    /// <p>The supplied value isn't a valid DB cluster snapshot state.</p>
    InvalidDbClusterSnapshotStateFault(crate::error::InvalidDbClusterSnapshotStateFault),
    /// <p>The requested operation can't be performed while the cluster is in this state.</p>
    InvalidDbClusterStateFault(crate::error::InvalidDbClusterStateFault),
    /// <p>The request would result in the user exceeding the allowed number of DB snapshots.</p>
    SnapshotQuotaExceededFault(crate::error::SnapshotQuotaExceededFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateDBClusterSnapshotError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateDBClusterSnapshotErrorKind::DbClusterNotFoundFault(_inner) => _inner.fmt(f),
            CreateDBClusterSnapshotErrorKind::DbClusterSnapshotAlreadyExistsFault(_inner) => {
                _inner.fmt(f)
            }
            CreateDBClusterSnapshotErrorKind::InvalidDbClusterSnapshotStateFault(_inner) => {
                _inner.fmt(f)
            }
            CreateDBClusterSnapshotErrorKind::InvalidDbClusterStateFault(_inner) => _inner.fmt(f),
            CreateDBClusterSnapshotErrorKind::SnapshotQuotaExceededFault(_inner) => _inner.fmt(f),
            CreateDBClusterSnapshotErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateDBClusterSnapshotError {
    fn code(&self) -> Option<&str> {
        CreateDBClusterSnapshotError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateDBClusterSnapshotError {
    /// Creates a new `CreateDBClusterSnapshotError`.
    pub fn new(kind: CreateDBClusterSnapshotErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateDBClusterSnapshotError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateDBClusterSnapshotErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateDBClusterSnapshotError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateDBClusterSnapshotErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateDBClusterSnapshotErrorKind::DbClusterNotFoundFault`.
    pub fn is_db_cluster_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBClusterSnapshotErrorKind::DbClusterNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBClusterSnapshotErrorKind::DbClusterSnapshotAlreadyExistsFault`.
    pub fn is_db_cluster_snapshot_already_exists_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBClusterSnapshotErrorKind::DbClusterSnapshotAlreadyExistsFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBClusterSnapshotErrorKind::InvalidDbClusterSnapshotStateFault`.
    pub fn is_invalid_db_cluster_snapshot_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBClusterSnapshotErrorKind::InvalidDbClusterSnapshotStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBClusterSnapshotErrorKind::InvalidDbClusterStateFault`.
    pub fn is_invalid_db_cluster_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBClusterSnapshotErrorKind::InvalidDbClusterStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBClusterSnapshotErrorKind::SnapshotQuotaExceededFault`.
    pub fn is_snapshot_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBClusterSnapshotErrorKind::SnapshotQuotaExceededFault(_)
        )
    }
}
impl std::error::Error for CreateDBClusterSnapshotError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateDBClusterSnapshotErrorKind::DbClusterNotFoundFault(_inner) => Some(_inner),
            CreateDBClusterSnapshotErrorKind::DbClusterSnapshotAlreadyExistsFault(_inner) => {
                Some(_inner)
            }
            CreateDBClusterSnapshotErrorKind::InvalidDbClusterSnapshotStateFault(_inner) => {
                Some(_inner)
            }
            CreateDBClusterSnapshotErrorKind::InvalidDbClusterStateFault(_inner) => Some(_inner),
            CreateDBClusterSnapshotErrorKind::SnapshotQuotaExceededFault(_inner) => Some(_inner),
            CreateDBClusterSnapshotErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateDBInstance` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateDBInstanceError {
    /// Kind of error that occurred.
    pub kind: CreateDBInstanceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateDBInstance` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateDBInstanceErrorKind {
    /// <p>The specified CIDR IP range or Amazon EC2 security group might not be authorized for the specified DB security group.</p>
    /// <p>Or, RDS might not be authorized to perform necessary actions using IAM on your behalf.</p>
    AuthorizationNotFoundFault(crate::error::AuthorizationNotFoundFault),
    #[allow(missing_docs)] // documentation missing in model
    BackupPolicyNotFoundFault(crate::error::BackupPolicyNotFoundFault),
    /// <p> <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster. </p>
    DbClusterNotFoundFault(crate::error::DbClusterNotFoundFault),
    /// <p>The user already has a DB instance with the given identifier.</p>
    DbInstanceAlreadyExistsFault(crate::error::DbInstanceAlreadyExistsFault),
    /// <p> <code>DBParameterGroupName</code> doesn't refer to an existing DB parameter group. </p>
    DbParameterGroupNotFoundFault(crate::error::DbParameterGroupNotFoundFault),
    /// <p> <code>DBSecurityGroupName</code> doesn't refer to an existing DB security group. </p>
    DbSecurityGroupNotFoundFault(crate::error::DbSecurityGroupNotFoundFault),
    /// <p>Subnets in the DB subnet group should cover at least two Availability Zones unless there is only one Availability Zone.</p>
    DbSubnetGroupDoesNotCoverEnoughAZs(crate::error::DbSubnetGroupDoesNotCoverEnoughAZs),
    /// <p> <code>DBSubnetGroupName</code> doesn't refer to an existing DB subnet group. </p>
    DbSubnetGroupNotFoundFault(crate::error::DbSubnetGroupNotFoundFault),
    /// <p> <code>Domain</code> doesn't refer to an existing Active Directory domain. </p>
    DomainNotFoundFault(crate::error::DomainNotFoundFault),
    /// <p>The request would result in the user exceeding the allowed number of DB instances.</p>
    InstanceQuotaExceededFault(crate::error::InstanceQuotaExceededFault),
    /// <p>The specified DB instance class isn't available in the specified Availability Zone.</p>
    InsufficientDbInstanceCapacityFault(crate::error::InsufficientDbInstanceCapacityFault),
    /// <p>The requested operation can't be performed while the cluster is in this state.</p>
    InvalidDbClusterStateFault(crate::error::InvalidDbClusterStateFault),
    /// <p>The requested subnet is invalid, or multiple subnets were requested that are not all in a common VPC.</p>
    InvalidSubnet(crate::error::InvalidSubnet),
    /// <p>The DB subnet group doesn't cover all Availability Zones after it's created because of users' change.</p>
    InvalidVpcNetworkStateFault(crate::error::InvalidVpcNetworkStateFault),
    /// <p>An error occurred accessing an Amazon Web Services KMS key.</p>
    KmsKeyNotAccessibleFault(crate::error::KmsKeyNotAccessibleFault),
    /// <p>The specified option group could not be found.</p>
    OptionGroupNotFoundFault(crate::error::OptionGroupNotFoundFault),
    /// <p>Provisioned IOPS not available in the specified Availability Zone.</p>
    ProvisionedIopsNotAvailableInAzFault(crate::error::ProvisionedIopsNotAvailableInAzFault),
    /// <p>The request would result in the user exceeding the allowed amount of storage available across all DB instances.</p>
    StorageQuotaExceededFault(crate::error::StorageQuotaExceededFault),
    /// <p>Storage of the <code>StorageType</code> specified can't be associated with the DB instance. </p>
    StorageTypeNotSupportedFault(crate::error::StorageTypeNotSupportedFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateDBInstanceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateDBInstanceErrorKind::AuthorizationNotFoundFault(_inner) => _inner.fmt(f),
            CreateDBInstanceErrorKind::BackupPolicyNotFoundFault(_inner) => _inner.fmt(f),
            CreateDBInstanceErrorKind::DbClusterNotFoundFault(_inner) => _inner.fmt(f),
            CreateDBInstanceErrorKind::DbInstanceAlreadyExistsFault(_inner) => _inner.fmt(f),
            CreateDBInstanceErrorKind::DbParameterGroupNotFoundFault(_inner) => _inner.fmt(f),
            CreateDBInstanceErrorKind::DbSecurityGroupNotFoundFault(_inner) => _inner.fmt(f),
            CreateDBInstanceErrorKind::DbSubnetGroupDoesNotCoverEnoughAZs(_inner) => _inner.fmt(f),
            CreateDBInstanceErrorKind::DbSubnetGroupNotFoundFault(_inner) => _inner.fmt(f),
            CreateDBInstanceErrorKind::DomainNotFoundFault(_inner) => _inner.fmt(f),
            CreateDBInstanceErrorKind::InstanceQuotaExceededFault(_inner) => _inner.fmt(f),
            CreateDBInstanceErrorKind::InsufficientDbInstanceCapacityFault(_inner) => _inner.fmt(f),
            CreateDBInstanceErrorKind::InvalidDbClusterStateFault(_inner) => _inner.fmt(f),
            CreateDBInstanceErrorKind::InvalidSubnet(_inner) => _inner.fmt(f),
            CreateDBInstanceErrorKind::InvalidVpcNetworkStateFault(_inner) => _inner.fmt(f),
            CreateDBInstanceErrorKind::KmsKeyNotAccessibleFault(_inner) => _inner.fmt(f),
            CreateDBInstanceErrorKind::OptionGroupNotFoundFault(_inner) => _inner.fmt(f),
            CreateDBInstanceErrorKind::ProvisionedIopsNotAvailableInAzFault(_inner) => {
                _inner.fmt(f)
            }
            CreateDBInstanceErrorKind::StorageQuotaExceededFault(_inner) => _inner.fmt(f),
            CreateDBInstanceErrorKind::StorageTypeNotSupportedFault(_inner) => _inner.fmt(f),
            CreateDBInstanceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateDBInstanceError {
    fn code(&self) -> Option<&str> {
        CreateDBInstanceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateDBInstanceError {
    /// Creates a new `CreateDBInstanceError`.
    pub fn new(kind: CreateDBInstanceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateDBInstanceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateDBInstanceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateDBInstanceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateDBInstanceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateDBInstanceErrorKind::AuthorizationNotFoundFault`.
    pub fn is_authorization_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBInstanceErrorKind::AuthorizationNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBInstanceErrorKind::BackupPolicyNotFoundFault`.
    pub fn is_backup_policy_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBInstanceErrorKind::BackupPolicyNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBInstanceErrorKind::DbClusterNotFoundFault`.
    pub fn is_db_cluster_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBInstanceErrorKind::DbClusterNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBInstanceErrorKind::DbInstanceAlreadyExistsFault`.
    pub fn is_db_instance_already_exists_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBInstanceErrorKind::DbInstanceAlreadyExistsFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBInstanceErrorKind::DbParameterGroupNotFoundFault`.
    pub fn is_db_parameter_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBInstanceErrorKind::DbParameterGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBInstanceErrorKind::DbSecurityGroupNotFoundFault`.
    pub fn is_db_security_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBInstanceErrorKind::DbSecurityGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBInstanceErrorKind::DbSubnetGroupDoesNotCoverEnoughAZs`.
    pub fn is_db_subnet_group_does_not_cover_enough_a_zs(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBInstanceErrorKind::DbSubnetGroupDoesNotCoverEnoughAZs(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBInstanceErrorKind::DbSubnetGroupNotFoundFault`.
    pub fn is_db_subnet_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBInstanceErrorKind::DbSubnetGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBInstanceErrorKind::DomainNotFoundFault`.
    pub fn is_domain_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBInstanceErrorKind::DomainNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBInstanceErrorKind::InstanceQuotaExceededFault`.
    pub fn is_instance_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBInstanceErrorKind::InstanceQuotaExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBInstanceErrorKind::InsufficientDbInstanceCapacityFault`.
    pub fn is_insufficient_db_instance_capacity_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBInstanceErrorKind::InsufficientDbInstanceCapacityFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBInstanceErrorKind::InvalidDbClusterStateFault`.
    pub fn is_invalid_db_cluster_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBInstanceErrorKind::InvalidDbClusterStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBInstanceErrorKind::InvalidSubnet`.
    pub fn is_invalid_subnet(&self) -> bool {
        matches!(&self.kind, CreateDBInstanceErrorKind::InvalidSubnet(_))
    }
    /// Returns `true` if the error kind is `CreateDBInstanceErrorKind::InvalidVpcNetworkStateFault`.
    pub fn is_invalid_vpc_network_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBInstanceErrorKind::InvalidVpcNetworkStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBInstanceErrorKind::KmsKeyNotAccessibleFault`.
    pub fn is_kms_key_not_accessible_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBInstanceErrorKind::KmsKeyNotAccessibleFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBInstanceErrorKind::OptionGroupNotFoundFault`.
    pub fn is_option_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBInstanceErrorKind::OptionGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBInstanceErrorKind::ProvisionedIopsNotAvailableInAzFault`.
    pub fn is_provisioned_iops_not_available_in_az_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBInstanceErrorKind::ProvisionedIopsNotAvailableInAzFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBInstanceErrorKind::StorageQuotaExceededFault`.
    pub fn is_storage_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBInstanceErrorKind::StorageQuotaExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBInstanceErrorKind::StorageTypeNotSupportedFault`.
    pub fn is_storage_type_not_supported_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBInstanceErrorKind::StorageTypeNotSupportedFault(_)
        )
    }
}
impl std::error::Error for CreateDBInstanceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateDBInstanceErrorKind::AuthorizationNotFoundFault(_inner) => Some(_inner),
            CreateDBInstanceErrorKind::BackupPolicyNotFoundFault(_inner) => Some(_inner),
            CreateDBInstanceErrorKind::DbClusterNotFoundFault(_inner) => Some(_inner),
            CreateDBInstanceErrorKind::DbInstanceAlreadyExistsFault(_inner) => Some(_inner),
            CreateDBInstanceErrorKind::DbParameterGroupNotFoundFault(_inner) => Some(_inner),
            CreateDBInstanceErrorKind::DbSecurityGroupNotFoundFault(_inner) => Some(_inner),
            CreateDBInstanceErrorKind::DbSubnetGroupDoesNotCoverEnoughAZs(_inner) => Some(_inner),
            CreateDBInstanceErrorKind::DbSubnetGroupNotFoundFault(_inner) => Some(_inner),
            CreateDBInstanceErrorKind::DomainNotFoundFault(_inner) => Some(_inner),
            CreateDBInstanceErrorKind::InstanceQuotaExceededFault(_inner) => Some(_inner),
            CreateDBInstanceErrorKind::InsufficientDbInstanceCapacityFault(_inner) => Some(_inner),
            CreateDBInstanceErrorKind::InvalidDbClusterStateFault(_inner) => Some(_inner),
            CreateDBInstanceErrorKind::InvalidSubnet(_inner) => Some(_inner),
            CreateDBInstanceErrorKind::InvalidVpcNetworkStateFault(_inner) => Some(_inner),
            CreateDBInstanceErrorKind::KmsKeyNotAccessibleFault(_inner) => Some(_inner),
            CreateDBInstanceErrorKind::OptionGroupNotFoundFault(_inner) => Some(_inner),
            CreateDBInstanceErrorKind::ProvisionedIopsNotAvailableInAzFault(_inner) => Some(_inner),
            CreateDBInstanceErrorKind::StorageQuotaExceededFault(_inner) => Some(_inner),
            CreateDBInstanceErrorKind::StorageTypeNotSupportedFault(_inner) => Some(_inner),
            CreateDBInstanceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateDBInstanceReadReplica` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateDBInstanceReadReplicaError {
    /// Kind of error that occurred.
    pub kind: CreateDBInstanceReadReplicaErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateDBInstanceReadReplica` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateDBInstanceReadReplicaErrorKind {
    /// <p>The user already has a DB instance with the given identifier.</p>
    DbInstanceAlreadyExistsFault(crate::error::DbInstanceAlreadyExistsFault),
    /// <p> <code>DBInstanceIdentifier</code> doesn't refer to an existing DB instance. </p>
    DbInstanceNotFoundFault(crate::error::DbInstanceNotFoundFault),
    /// <p> <code>DBParameterGroupName</code> doesn't refer to an existing DB parameter group. </p>
    DbParameterGroupNotFoundFault(crate::error::DbParameterGroupNotFoundFault),
    /// <p> <code>DBSecurityGroupName</code> doesn't refer to an existing DB security group. </p>
    DbSecurityGroupNotFoundFault(crate::error::DbSecurityGroupNotFoundFault),
    /// <p>Subnets in the DB subnet group should cover at least two Availability Zones unless there is only one Availability Zone.</p>
    DbSubnetGroupDoesNotCoverEnoughAZs(crate::error::DbSubnetGroupDoesNotCoverEnoughAZs),
    /// <p>The DBSubnetGroup shouldn't be specified while creating read replicas that lie in the same region as the source instance.</p>
    DbSubnetGroupNotAllowedFault(crate::error::DbSubnetGroupNotAllowedFault),
    /// <p> <code>DBSubnetGroupName</code> doesn't refer to an existing DB subnet group. </p>
    DbSubnetGroupNotFoundFault(crate::error::DbSubnetGroupNotFoundFault),
    /// <p> <code>Domain</code> doesn't refer to an existing Active Directory domain. </p>
    DomainNotFoundFault(crate::error::DomainNotFoundFault),
    /// <p>The request would result in the user exceeding the allowed number of DB instances.</p>
    InstanceQuotaExceededFault(crate::error::InstanceQuotaExceededFault),
    /// <p>The specified DB instance class isn't available in the specified Availability Zone.</p>
    InsufficientDbInstanceCapacityFault(crate::error::InsufficientDbInstanceCapacityFault),
    /// <p>The DB instance isn't in a valid state.</p>
    InvalidDbInstanceStateFault(crate::error::InvalidDbInstanceStateFault),
    /// <p>The DBSubnetGroup doesn't belong to the same VPC as that of an existing cross-region read replica of the same source instance.</p>
    InvalidDbSubnetGroupFault(crate::error::InvalidDbSubnetGroupFault),
    /// <p>The requested subnet is invalid, or multiple subnets were requested that are not all in a common VPC.</p>
    InvalidSubnet(crate::error::InvalidSubnet),
    /// <p>The DB subnet group doesn't cover all Availability Zones after it's created because of users' change.</p>
    InvalidVpcNetworkStateFault(crate::error::InvalidVpcNetworkStateFault),
    /// <p>An error occurred accessing an Amazon Web Services KMS key.</p>
    KmsKeyNotAccessibleFault(crate::error::KmsKeyNotAccessibleFault),
    /// <p>The specified option group could not be found.</p>
    OptionGroupNotFoundFault(crate::error::OptionGroupNotFoundFault),
    /// <p>Provisioned IOPS not available in the specified Availability Zone.</p>
    ProvisionedIopsNotAvailableInAzFault(crate::error::ProvisionedIopsNotAvailableInAzFault),
    /// <p>The request would result in the user exceeding the allowed amount of storage available across all DB instances.</p>
    StorageQuotaExceededFault(crate::error::StorageQuotaExceededFault),
    /// <p>Storage of the <code>StorageType</code> specified can't be associated with the DB instance. </p>
    StorageTypeNotSupportedFault(crate::error::StorageTypeNotSupportedFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateDBInstanceReadReplicaError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateDBInstanceReadReplicaErrorKind::DbInstanceAlreadyExistsFault(_inner) => {
                _inner.fmt(f)
            }
            CreateDBInstanceReadReplicaErrorKind::DbInstanceNotFoundFault(_inner) => _inner.fmt(f),
            CreateDBInstanceReadReplicaErrorKind::DbParameterGroupNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            CreateDBInstanceReadReplicaErrorKind::DbSecurityGroupNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            CreateDBInstanceReadReplicaErrorKind::DbSubnetGroupDoesNotCoverEnoughAZs(_inner) => {
                _inner.fmt(f)
            }
            CreateDBInstanceReadReplicaErrorKind::DbSubnetGroupNotAllowedFault(_inner) => {
                _inner.fmt(f)
            }
            CreateDBInstanceReadReplicaErrorKind::DbSubnetGroupNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            CreateDBInstanceReadReplicaErrorKind::DomainNotFoundFault(_inner) => _inner.fmt(f),
            CreateDBInstanceReadReplicaErrorKind::InstanceQuotaExceededFault(_inner) => {
                _inner.fmt(f)
            }
            CreateDBInstanceReadReplicaErrorKind::InsufficientDbInstanceCapacityFault(_inner) => {
                _inner.fmt(f)
            }
            CreateDBInstanceReadReplicaErrorKind::InvalidDbInstanceStateFault(_inner) => {
                _inner.fmt(f)
            }
            CreateDBInstanceReadReplicaErrorKind::InvalidDbSubnetGroupFault(_inner) => {
                _inner.fmt(f)
            }
            CreateDBInstanceReadReplicaErrorKind::InvalidSubnet(_inner) => _inner.fmt(f),
            CreateDBInstanceReadReplicaErrorKind::InvalidVpcNetworkStateFault(_inner) => {
                _inner.fmt(f)
            }
            CreateDBInstanceReadReplicaErrorKind::KmsKeyNotAccessibleFault(_inner) => _inner.fmt(f),
            CreateDBInstanceReadReplicaErrorKind::OptionGroupNotFoundFault(_inner) => _inner.fmt(f),
            CreateDBInstanceReadReplicaErrorKind::ProvisionedIopsNotAvailableInAzFault(_inner) => {
                _inner.fmt(f)
            }
            CreateDBInstanceReadReplicaErrorKind::StorageQuotaExceededFault(_inner) => {
                _inner.fmt(f)
            }
            CreateDBInstanceReadReplicaErrorKind::StorageTypeNotSupportedFault(_inner) => {
                _inner.fmt(f)
            }
            CreateDBInstanceReadReplicaErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateDBInstanceReadReplicaError {
    fn code(&self) -> Option<&str> {
        CreateDBInstanceReadReplicaError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateDBInstanceReadReplicaError {
    /// Creates a new `CreateDBInstanceReadReplicaError`.
    pub fn new(kind: CreateDBInstanceReadReplicaErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateDBInstanceReadReplicaError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateDBInstanceReadReplicaErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateDBInstanceReadReplicaError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateDBInstanceReadReplicaErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateDBInstanceReadReplicaErrorKind::DbInstanceAlreadyExistsFault`.
    pub fn is_db_instance_already_exists_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBInstanceReadReplicaErrorKind::DbInstanceAlreadyExistsFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBInstanceReadReplicaErrorKind::DbInstanceNotFoundFault`.
    pub fn is_db_instance_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBInstanceReadReplicaErrorKind::DbInstanceNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBInstanceReadReplicaErrorKind::DbParameterGroupNotFoundFault`.
    pub fn is_db_parameter_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBInstanceReadReplicaErrorKind::DbParameterGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBInstanceReadReplicaErrorKind::DbSecurityGroupNotFoundFault`.
    pub fn is_db_security_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBInstanceReadReplicaErrorKind::DbSecurityGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBInstanceReadReplicaErrorKind::DbSubnetGroupDoesNotCoverEnoughAZs`.
    pub fn is_db_subnet_group_does_not_cover_enough_a_zs(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBInstanceReadReplicaErrorKind::DbSubnetGroupDoesNotCoverEnoughAZs(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBInstanceReadReplicaErrorKind::DbSubnetGroupNotAllowedFault`.
    pub fn is_db_subnet_group_not_allowed_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBInstanceReadReplicaErrorKind::DbSubnetGroupNotAllowedFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBInstanceReadReplicaErrorKind::DbSubnetGroupNotFoundFault`.
    pub fn is_db_subnet_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBInstanceReadReplicaErrorKind::DbSubnetGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBInstanceReadReplicaErrorKind::DomainNotFoundFault`.
    pub fn is_domain_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBInstanceReadReplicaErrorKind::DomainNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBInstanceReadReplicaErrorKind::InstanceQuotaExceededFault`.
    pub fn is_instance_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBInstanceReadReplicaErrorKind::InstanceQuotaExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBInstanceReadReplicaErrorKind::InsufficientDbInstanceCapacityFault`.
    pub fn is_insufficient_db_instance_capacity_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBInstanceReadReplicaErrorKind::InsufficientDbInstanceCapacityFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBInstanceReadReplicaErrorKind::InvalidDbInstanceStateFault`.
    pub fn is_invalid_db_instance_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBInstanceReadReplicaErrorKind::InvalidDbInstanceStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBInstanceReadReplicaErrorKind::InvalidDbSubnetGroupFault`.
    pub fn is_invalid_db_subnet_group_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBInstanceReadReplicaErrorKind::InvalidDbSubnetGroupFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBInstanceReadReplicaErrorKind::InvalidSubnet`.
    pub fn is_invalid_subnet(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBInstanceReadReplicaErrorKind::InvalidSubnet(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBInstanceReadReplicaErrorKind::InvalidVpcNetworkStateFault`.
    pub fn is_invalid_vpc_network_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBInstanceReadReplicaErrorKind::InvalidVpcNetworkStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBInstanceReadReplicaErrorKind::KmsKeyNotAccessibleFault`.
    pub fn is_kms_key_not_accessible_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBInstanceReadReplicaErrorKind::KmsKeyNotAccessibleFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBInstanceReadReplicaErrorKind::OptionGroupNotFoundFault`.
    pub fn is_option_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBInstanceReadReplicaErrorKind::OptionGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBInstanceReadReplicaErrorKind::ProvisionedIopsNotAvailableInAzFault`.
    pub fn is_provisioned_iops_not_available_in_az_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBInstanceReadReplicaErrorKind::ProvisionedIopsNotAvailableInAzFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBInstanceReadReplicaErrorKind::StorageQuotaExceededFault`.
    pub fn is_storage_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBInstanceReadReplicaErrorKind::StorageQuotaExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBInstanceReadReplicaErrorKind::StorageTypeNotSupportedFault`.
    pub fn is_storage_type_not_supported_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBInstanceReadReplicaErrorKind::StorageTypeNotSupportedFault(_)
        )
    }
}
impl std::error::Error for CreateDBInstanceReadReplicaError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateDBInstanceReadReplicaErrorKind::DbInstanceAlreadyExistsFault(_inner) => {
                Some(_inner)
            }
            CreateDBInstanceReadReplicaErrorKind::DbInstanceNotFoundFault(_inner) => Some(_inner),
            CreateDBInstanceReadReplicaErrorKind::DbParameterGroupNotFoundFault(_inner) => {
                Some(_inner)
            }
            CreateDBInstanceReadReplicaErrorKind::DbSecurityGroupNotFoundFault(_inner) => {
                Some(_inner)
            }
            CreateDBInstanceReadReplicaErrorKind::DbSubnetGroupDoesNotCoverEnoughAZs(_inner) => {
                Some(_inner)
            }
            CreateDBInstanceReadReplicaErrorKind::DbSubnetGroupNotAllowedFault(_inner) => {
                Some(_inner)
            }
            CreateDBInstanceReadReplicaErrorKind::DbSubnetGroupNotFoundFault(_inner) => {
                Some(_inner)
            }
            CreateDBInstanceReadReplicaErrorKind::DomainNotFoundFault(_inner) => Some(_inner),
            CreateDBInstanceReadReplicaErrorKind::InstanceQuotaExceededFault(_inner) => {
                Some(_inner)
            }
            CreateDBInstanceReadReplicaErrorKind::InsufficientDbInstanceCapacityFault(_inner) => {
                Some(_inner)
            }
            CreateDBInstanceReadReplicaErrorKind::InvalidDbInstanceStateFault(_inner) => {
                Some(_inner)
            }
            CreateDBInstanceReadReplicaErrorKind::InvalidDbSubnetGroupFault(_inner) => Some(_inner),
            CreateDBInstanceReadReplicaErrorKind::InvalidSubnet(_inner) => Some(_inner),
            CreateDBInstanceReadReplicaErrorKind::InvalidVpcNetworkStateFault(_inner) => {
                Some(_inner)
            }
            CreateDBInstanceReadReplicaErrorKind::KmsKeyNotAccessibleFault(_inner) => Some(_inner),
            CreateDBInstanceReadReplicaErrorKind::OptionGroupNotFoundFault(_inner) => Some(_inner),
            CreateDBInstanceReadReplicaErrorKind::ProvisionedIopsNotAvailableInAzFault(_inner) => {
                Some(_inner)
            }
            CreateDBInstanceReadReplicaErrorKind::StorageQuotaExceededFault(_inner) => Some(_inner),
            CreateDBInstanceReadReplicaErrorKind::StorageTypeNotSupportedFault(_inner) => {
                Some(_inner)
            }
            CreateDBInstanceReadReplicaErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateDBParameterGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateDBParameterGroupError {
    /// Kind of error that occurred.
    pub kind: CreateDBParameterGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateDBParameterGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateDBParameterGroupErrorKind {
    /// <p>A DB parameter group with the same name exists.</p>
    DbParameterGroupAlreadyExistsFault(crate::error::DbParameterGroupAlreadyExistsFault),
    /// <p>The request would result in the user exceeding the allowed number of DB parameter groups.</p>
    DbParameterGroupQuotaExceededFault(crate::error::DbParameterGroupQuotaExceededFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateDBParameterGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateDBParameterGroupErrorKind::DbParameterGroupAlreadyExistsFault(_inner) => {
                _inner.fmt(f)
            }
            CreateDBParameterGroupErrorKind::DbParameterGroupQuotaExceededFault(_inner) => {
                _inner.fmt(f)
            }
            CreateDBParameterGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateDBParameterGroupError {
    fn code(&self) -> Option<&str> {
        CreateDBParameterGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateDBParameterGroupError {
    /// Creates a new `CreateDBParameterGroupError`.
    pub fn new(kind: CreateDBParameterGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateDBParameterGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateDBParameterGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateDBParameterGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateDBParameterGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateDBParameterGroupErrorKind::DbParameterGroupAlreadyExistsFault`.
    pub fn is_db_parameter_group_already_exists_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBParameterGroupErrorKind::DbParameterGroupAlreadyExistsFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBParameterGroupErrorKind::DbParameterGroupQuotaExceededFault`.
    pub fn is_db_parameter_group_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBParameterGroupErrorKind::DbParameterGroupQuotaExceededFault(_)
        )
    }
}
impl std::error::Error for CreateDBParameterGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateDBParameterGroupErrorKind::DbParameterGroupAlreadyExistsFault(_inner) => {
                Some(_inner)
            }
            CreateDBParameterGroupErrorKind::DbParameterGroupQuotaExceededFault(_inner) => {
                Some(_inner)
            }
            CreateDBParameterGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateDBProxy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateDBProxyError {
    /// Kind of error that occurred.
    pub kind: CreateDBProxyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateDBProxy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateDBProxyErrorKind {
    /// <p>The specified proxy name must be unique for all proxies owned by your Amazon Web Services account in the specified Amazon Web Services Region.</p>
    DbProxyAlreadyExistsFault(crate::error::DbProxyAlreadyExistsFault),
    /// <p>Your Amazon Web Services account already has the maximum number of proxies in the specified Amazon Web Services Region.</p>
    DbProxyQuotaExceededFault(crate::error::DbProxyQuotaExceededFault),
    /// <p>The requested subnet is invalid, or multiple subnets were requested that are not all in a common VPC.</p>
    InvalidSubnet(crate::error::InvalidSubnet),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateDBProxyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateDBProxyErrorKind::DbProxyAlreadyExistsFault(_inner) => _inner.fmt(f),
            CreateDBProxyErrorKind::DbProxyQuotaExceededFault(_inner) => _inner.fmt(f),
            CreateDBProxyErrorKind::InvalidSubnet(_inner) => _inner.fmt(f),
            CreateDBProxyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateDBProxyError {
    fn code(&self) -> Option<&str> {
        CreateDBProxyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateDBProxyError {
    /// Creates a new `CreateDBProxyError`.
    pub fn new(kind: CreateDBProxyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateDBProxyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateDBProxyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateDBProxyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateDBProxyErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateDBProxyErrorKind::DbProxyAlreadyExistsFault`.
    pub fn is_db_proxy_already_exists_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBProxyErrorKind::DbProxyAlreadyExistsFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBProxyErrorKind::DbProxyQuotaExceededFault`.
    pub fn is_db_proxy_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBProxyErrorKind::DbProxyQuotaExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBProxyErrorKind::InvalidSubnet`.
    pub fn is_invalid_subnet(&self) -> bool {
        matches!(&self.kind, CreateDBProxyErrorKind::InvalidSubnet(_))
    }
}
impl std::error::Error for CreateDBProxyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateDBProxyErrorKind::DbProxyAlreadyExistsFault(_inner) => Some(_inner),
            CreateDBProxyErrorKind::DbProxyQuotaExceededFault(_inner) => Some(_inner),
            CreateDBProxyErrorKind::InvalidSubnet(_inner) => Some(_inner),
            CreateDBProxyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateDBProxyEndpoint` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateDBProxyEndpointError {
    /// Kind of error that occurred.
    pub kind: CreateDBProxyEndpointErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateDBProxyEndpoint` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateDBProxyEndpointErrorKind {
    /// <p>The specified DB proxy endpoint name must be unique for all DB proxy endpoints owned by your Amazon Web Services account in the specified Amazon Web Services Region.</p>
    DbProxyEndpointAlreadyExistsFault(crate::error::DbProxyEndpointAlreadyExistsFault),
    /// <p>The DB proxy already has the maximum number of endpoints.</p>
    DbProxyEndpointQuotaExceededFault(crate::error::DbProxyEndpointQuotaExceededFault),
    /// <p>The specified proxy name doesn't correspond to a proxy owned by your Amazon Web Services account in the specified Amazon Web Services Region.</p>
    DbProxyNotFoundFault(crate::error::DbProxyNotFoundFault),
    /// <p>The requested operation can't be performed while the proxy is in this state.</p>
    InvalidDbProxyStateFault(crate::error::InvalidDbProxyStateFault),
    /// <p>The requested subnet is invalid, or multiple subnets were requested that are not all in a common VPC.</p>
    InvalidSubnet(crate::error::InvalidSubnet),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateDBProxyEndpointError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateDBProxyEndpointErrorKind::DbProxyEndpointAlreadyExistsFault(_inner) => {
                _inner.fmt(f)
            }
            CreateDBProxyEndpointErrorKind::DbProxyEndpointQuotaExceededFault(_inner) => {
                _inner.fmt(f)
            }
            CreateDBProxyEndpointErrorKind::DbProxyNotFoundFault(_inner) => _inner.fmt(f),
            CreateDBProxyEndpointErrorKind::InvalidDbProxyStateFault(_inner) => _inner.fmt(f),
            CreateDBProxyEndpointErrorKind::InvalidSubnet(_inner) => _inner.fmt(f),
            CreateDBProxyEndpointErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateDBProxyEndpointError {
    fn code(&self) -> Option<&str> {
        CreateDBProxyEndpointError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateDBProxyEndpointError {
    /// Creates a new `CreateDBProxyEndpointError`.
    pub fn new(kind: CreateDBProxyEndpointErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateDBProxyEndpointError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateDBProxyEndpointErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateDBProxyEndpointError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateDBProxyEndpointErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateDBProxyEndpointErrorKind::DbProxyEndpointAlreadyExistsFault`.
    pub fn is_db_proxy_endpoint_already_exists_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBProxyEndpointErrorKind::DbProxyEndpointAlreadyExistsFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBProxyEndpointErrorKind::DbProxyEndpointQuotaExceededFault`.
    pub fn is_db_proxy_endpoint_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBProxyEndpointErrorKind::DbProxyEndpointQuotaExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBProxyEndpointErrorKind::DbProxyNotFoundFault`.
    pub fn is_db_proxy_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBProxyEndpointErrorKind::DbProxyNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBProxyEndpointErrorKind::InvalidDbProxyStateFault`.
    pub fn is_invalid_db_proxy_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBProxyEndpointErrorKind::InvalidDbProxyStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBProxyEndpointErrorKind::InvalidSubnet`.
    pub fn is_invalid_subnet(&self) -> bool {
        matches!(&self.kind, CreateDBProxyEndpointErrorKind::InvalidSubnet(_))
    }
}
impl std::error::Error for CreateDBProxyEndpointError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateDBProxyEndpointErrorKind::DbProxyEndpointAlreadyExistsFault(_inner) => {
                Some(_inner)
            }
            CreateDBProxyEndpointErrorKind::DbProxyEndpointQuotaExceededFault(_inner) => {
                Some(_inner)
            }
            CreateDBProxyEndpointErrorKind::DbProxyNotFoundFault(_inner) => Some(_inner),
            CreateDBProxyEndpointErrorKind::InvalidDbProxyStateFault(_inner) => Some(_inner),
            CreateDBProxyEndpointErrorKind::InvalidSubnet(_inner) => Some(_inner),
            CreateDBProxyEndpointErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateDBSecurityGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateDBSecurityGroupError {
    /// Kind of error that occurred.
    pub kind: CreateDBSecurityGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateDBSecurityGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateDBSecurityGroupErrorKind {
    /// <p> A DB security group with the name specified in <code>DBSecurityGroupName</code> already exists. </p>
    DbSecurityGroupAlreadyExistsFault(crate::error::DbSecurityGroupAlreadyExistsFault),
    /// <p>A DB security group isn't allowed for this action.</p>
    DbSecurityGroupNotSupportedFault(crate::error::DbSecurityGroupNotSupportedFault),
    /// <p>The request would result in the user exceeding the allowed number of DB security groups.</p>
    DbSecurityGroupQuotaExceededFault(crate::error::DbSecurityGroupQuotaExceededFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateDBSecurityGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateDBSecurityGroupErrorKind::DbSecurityGroupAlreadyExistsFault(_inner) => {
                _inner.fmt(f)
            }
            CreateDBSecurityGroupErrorKind::DbSecurityGroupNotSupportedFault(_inner) => {
                _inner.fmt(f)
            }
            CreateDBSecurityGroupErrorKind::DbSecurityGroupQuotaExceededFault(_inner) => {
                _inner.fmt(f)
            }
            CreateDBSecurityGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateDBSecurityGroupError {
    fn code(&self) -> Option<&str> {
        CreateDBSecurityGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateDBSecurityGroupError {
    /// Creates a new `CreateDBSecurityGroupError`.
    pub fn new(kind: CreateDBSecurityGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateDBSecurityGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateDBSecurityGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateDBSecurityGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateDBSecurityGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateDBSecurityGroupErrorKind::DbSecurityGroupAlreadyExistsFault`.
    pub fn is_db_security_group_already_exists_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBSecurityGroupErrorKind::DbSecurityGroupAlreadyExistsFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBSecurityGroupErrorKind::DbSecurityGroupNotSupportedFault`.
    pub fn is_db_security_group_not_supported_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBSecurityGroupErrorKind::DbSecurityGroupNotSupportedFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBSecurityGroupErrorKind::DbSecurityGroupQuotaExceededFault`.
    pub fn is_db_security_group_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBSecurityGroupErrorKind::DbSecurityGroupQuotaExceededFault(_)
        )
    }
}
impl std::error::Error for CreateDBSecurityGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateDBSecurityGroupErrorKind::DbSecurityGroupAlreadyExistsFault(_inner) => {
                Some(_inner)
            }
            CreateDBSecurityGroupErrorKind::DbSecurityGroupNotSupportedFault(_inner) => {
                Some(_inner)
            }
            CreateDBSecurityGroupErrorKind::DbSecurityGroupQuotaExceededFault(_inner) => {
                Some(_inner)
            }
            CreateDBSecurityGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateDBSnapshot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateDBSnapshotError {
    /// Kind of error that occurred.
    pub kind: CreateDBSnapshotErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateDBSnapshot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateDBSnapshotErrorKind {
    /// <p> <code>DBInstanceIdentifier</code> doesn't refer to an existing DB instance. </p>
    DbInstanceNotFoundFault(crate::error::DbInstanceNotFoundFault),
    /// <p> <code>DBSnapshotIdentifier</code> is already used by an existing snapshot. </p>
    DbSnapshotAlreadyExistsFault(crate::error::DbSnapshotAlreadyExistsFault),
    /// <p>The DB instance isn't in a valid state.</p>
    InvalidDbInstanceStateFault(crate::error::InvalidDbInstanceStateFault),
    /// <p>The request would result in the user exceeding the allowed number of DB snapshots.</p>
    SnapshotQuotaExceededFault(crate::error::SnapshotQuotaExceededFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateDBSnapshotError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateDBSnapshotErrorKind::DbInstanceNotFoundFault(_inner) => _inner.fmt(f),
            CreateDBSnapshotErrorKind::DbSnapshotAlreadyExistsFault(_inner) => _inner.fmt(f),
            CreateDBSnapshotErrorKind::InvalidDbInstanceStateFault(_inner) => _inner.fmt(f),
            CreateDBSnapshotErrorKind::SnapshotQuotaExceededFault(_inner) => _inner.fmt(f),
            CreateDBSnapshotErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateDBSnapshotError {
    fn code(&self) -> Option<&str> {
        CreateDBSnapshotError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateDBSnapshotError {
    /// Creates a new `CreateDBSnapshotError`.
    pub fn new(kind: CreateDBSnapshotErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateDBSnapshotError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateDBSnapshotErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateDBSnapshotError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateDBSnapshotErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateDBSnapshotErrorKind::DbInstanceNotFoundFault`.
    pub fn is_db_instance_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBSnapshotErrorKind::DbInstanceNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBSnapshotErrorKind::DbSnapshotAlreadyExistsFault`.
    pub fn is_db_snapshot_already_exists_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBSnapshotErrorKind::DbSnapshotAlreadyExistsFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBSnapshotErrorKind::InvalidDbInstanceStateFault`.
    pub fn is_invalid_db_instance_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBSnapshotErrorKind::InvalidDbInstanceStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBSnapshotErrorKind::SnapshotQuotaExceededFault`.
    pub fn is_snapshot_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBSnapshotErrorKind::SnapshotQuotaExceededFault(_)
        )
    }
}
impl std::error::Error for CreateDBSnapshotError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateDBSnapshotErrorKind::DbInstanceNotFoundFault(_inner) => Some(_inner),
            CreateDBSnapshotErrorKind::DbSnapshotAlreadyExistsFault(_inner) => Some(_inner),
            CreateDBSnapshotErrorKind::InvalidDbInstanceStateFault(_inner) => Some(_inner),
            CreateDBSnapshotErrorKind::SnapshotQuotaExceededFault(_inner) => Some(_inner),
            CreateDBSnapshotErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateDBSubnetGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateDBSubnetGroupError {
    /// Kind of error that occurred.
    pub kind: CreateDBSubnetGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateDBSubnetGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateDBSubnetGroupErrorKind {
    /// <p> <code>DBSubnetGroupName</code> is already used by an existing DB subnet group. </p>
    DbSubnetGroupAlreadyExistsFault(crate::error::DbSubnetGroupAlreadyExistsFault),
    /// <p>Subnets in the DB subnet group should cover at least two Availability Zones unless there is only one Availability Zone.</p>
    DbSubnetGroupDoesNotCoverEnoughAZs(crate::error::DbSubnetGroupDoesNotCoverEnoughAZs),
    /// <p>The request would result in the user exceeding the allowed number of DB subnet groups.</p>
    DbSubnetGroupQuotaExceededFault(crate::error::DbSubnetGroupQuotaExceededFault),
    /// <p>The request would result in the user exceeding the allowed number of subnets in a DB subnet groups.</p>
    DbSubnetQuotaExceededFault(crate::error::DbSubnetQuotaExceededFault),
    /// <p>The requested subnet is invalid, or multiple subnets were requested that are not all in a common VPC.</p>
    InvalidSubnet(crate::error::InvalidSubnet),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateDBSubnetGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateDBSubnetGroupErrorKind::DbSubnetGroupAlreadyExistsFault(_inner) => _inner.fmt(f),
            CreateDBSubnetGroupErrorKind::DbSubnetGroupDoesNotCoverEnoughAZs(_inner) => {
                _inner.fmt(f)
            }
            CreateDBSubnetGroupErrorKind::DbSubnetGroupQuotaExceededFault(_inner) => _inner.fmt(f),
            CreateDBSubnetGroupErrorKind::DbSubnetQuotaExceededFault(_inner) => _inner.fmt(f),
            CreateDBSubnetGroupErrorKind::InvalidSubnet(_inner) => _inner.fmt(f),
            CreateDBSubnetGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateDBSubnetGroupError {
    fn code(&self) -> Option<&str> {
        CreateDBSubnetGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateDBSubnetGroupError {
    /// Creates a new `CreateDBSubnetGroupError`.
    pub fn new(kind: CreateDBSubnetGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateDBSubnetGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateDBSubnetGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateDBSubnetGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateDBSubnetGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateDBSubnetGroupErrorKind::DbSubnetGroupAlreadyExistsFault`.
    pub fn is_db_subnet_group_already_exists_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBSubnetGroupErrorKind::DbSubnetGroupAlreadyExistsFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBSubnetGroupErrorKind::DbSubnetGroupDoesNotCoverEnoughAZs`.
    pub fn is_db_subnet_group_does_not_cover_enough_a_zs(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBSubnetGroupErrorKind::DbSubnetGroupDoesNotCoverEnoughAZs(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBSubnetGroupErrorKind::DbSubnetGroupQuotaExceededFault`.
    pub fn is_db_subnet_group_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBSubnetGroupErrorKind::DbSubnetGroupQuotaExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBSubnetGroupErrorKind::DbSubnetQuotaExceededFault`.
    pub fn is_db_subnet_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateDBSubnetGroupErrorKind::DbSubnetQuotaExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDBSubnetGroupErrorKind::InvalidSubnet`.
    pub fn is_invalid_subnet(&self) -> bool {
        matches!(&self.kind, CreateDBSubnetGroupErrorKind::InvalidSubnet(_))
    }
}
impl std::error::Error for CreateDBSubnetGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateDBSubnetGroupErrorKind::DbSubnetGroupAlreadyExistsFault(_inner) => Some(_inner),
            CreateDBSubnetGroupErrorKind::DbSubnetGroupDoesNotCoverEnoughAZs(_inner) => {
                Some(_inner)
            }
            CreateDBSubnetGroupErrorKind::DbSubnetGroupQuotaExceededFault(_inner) => Some(_inner),
            CreateDBSubnetGroupErrorKind::DbSubnetQuotaExceededFault(_inner) => Some(_inner),
            CreateDBSubnetGroupErrorKind::InvalidSubnet(_inner) => Some(_inner),
            CreateDBSubnetGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateEventSubscription` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateEventSubscriptionError {
    /// Kind of error that occurred.
    pub kind: CreateEventSubscriptionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateEventSubscription` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateEventSubscriptionErrorKind {
    /// <p>You have reached the maximum number of event subscriptions.</p>
    EventSubscriptionQuotaExceededFault(crate::error::EventSubscriptionQuotaExceededFault),
    /// <p>SNS has responded that there is a problem with the SND topic specified.</p>
    SnsInvalidTopicFault(crate::error::SnsInvalidTopicFault),
    /// <p>You do not have permission to publish to the SNS topic ARN.</p>
    SnsNoAuthorizationFault(crate::error::SnsNoAuthorizationFault),
    /// <p>The SNS topic ARN does not exist.</p>
    SnsTopicArnNotFoundFault(crate::error::SnsTopicArnNotFoundFault),
    /// <p>The requested source could not be found.</p>
    SourceNotFoundFault(crate::error::SourceNotFoundFault),
    /// <p>The supplied subscription name already exists.</p>
    SubscriptionAlreadyExistFault(crate::error::SubscriptionAlreadyExistFault),
    /// <p>The supplied category does not exist.</p>
    SubscriptionCategoryNotFoundFault(crate::error::SubscriptionCategoryNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateEventSubscriptionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateEventSubscriptionErrorKind::EventSubscriptionQuotaExceededFault(_inner) => {
                _inner.fmt(f)
            }
            CreateEventSubscriptionErrorKind::SnsInvalidTopicFault(_inner) => _inner.fmt(f),
            CreateEventSubscriptionErrorKind::SnsNoAuthorizationFault(_inner) => _inner.fmt(f),
            CreateEventSubscriptionErrorKind::SnsTopicArnNotFoundFault(_inner) => _inner.fmt(f),
            CreateEventSubscriptionErrorKind::SourceNotFoundFault(_inner) => _inner.fmt(f),
            CreateEventSubscriptionErrorKind::SubscriptionAlreadyExistFault(_inner) => {
                _inner.fmt(f)
            }
            CreateEventSubscriptionErrorKind::SubscriptionCategoryNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            CreateEventSubscriptionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateEventSubscriptionError {
    fn code(&self) -> Option<&str> {
        CreateEventSubscriptionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateEventSubscriptionError {
    /// Creates a new `CreateEventSubscriptionError`.
    pub fn new(kind: CreateEventSubscriptionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateEventSubscriptionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateEventSubscriptionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateEventSubscriptionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateEventSubscriptionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateEventSubscriptionErrorKind::EventSubscriptionQuotaExceededFault`.
    pub fn is_event_subscription_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateEventSubscriptionErrorKind::EventSubscriptionQuotaExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEventSubscriptionErrorKind::SnsInvalidTopicFault`.
    pub fn is_sns_invalid_topic_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateEventSubscriptionErrorKind::SnsInvalidTopicFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEventSubscriptionErrorKind::SnsNoAuthorizationFault`.
    pub fn is_sns_no_authorization_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateEventSubscriptionErrorKind::SnsNoAuthorizationFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEventSubscriptionErrorKind::SnsTopicArnNotFoundFault`.
    pub fn is_sns_topic_arn_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateEventSubscriptionErrorKind::SnsTopicArnNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEventSubscriptionErrorKind::SourceNotFoundFault`.
    pub fn is_source_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateEventSubscriptionErrorKind::SourceNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEventSubscriptionErrorKind::SubscriptionAlreadyExistFault`.
    pub fn is_subscription_already_exist_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateEventSubscriptionErrorKind::SubscriptionAlreadyExistFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEventSubscriptionErrorKind::SubscriptionCategoryNotFoundFault`.
    pub fn is_subscription_category_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateEventSubscriptionErrorKind::SubscriptionCategoryNotFoundFault(_)
        )
    }
}
impl std::error::Error for CreateEventSubscriptionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateEventSubscriptionErrorKind::EventSubscriptionQuotaExceededFault(_inner) => {
                Some(_inner)
            }
            CreateEventSubscriptionErrorKind::SnsInvalidTopicFault(_inner) => Some(_inner),
            CreateEventSubscriptionErrorKind::SnsNoAuthorizationFault(_inner) => Some(_inner),
            CreateEventSubscriptionErrorKind::SnsTopicArnNotFoundFault(_inner) => Some(_inner),
            CreateEventSubscriptionErrorKind::SourceNotFoundFault(_inner) => Some(_inner),
            CreateEventSubscriptionErrorKind::SubscriptionAlreadyExistFault(_inner) => Some(_inner),
            CreateEventSubscriptionErrorKind::SubscriptionCategoryNotFoundFault(_inner) => {
                Some(_inner)
            }
            CreateEventSubscriptionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateGlobalCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateGlobalClusterError {
    /// Kind of error that occurred.
    pub kind: CreateGlobalClusterErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateGlobalCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateGlobalClusterErrorKind {
    /// <p> <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster. </p>
    DbClusterNotFoundFault(crate::error::DbClusterNotFoundFault),
    /// <p>The <code>GlobalClusterIdentifier</code> already exists. Choose a new global database identifier (unique name) to create a new global database cluster.</p>
    GlobalClusterAlreadyExistsFault(crate::error::GlobalClusterAlreadyExistsFault),
    /// <p>The number of global database clusters for this account is already at the maximum allowed.</p>
    GlobalClusterQuotaExceededFault(crate::error::GlobalClusterQuotaExceededFault),
    /// <p>The requested operation can't be performed while the cluster is in this state.</p>
    InvalidDbClusterStateFault(crate::error::InvalidDbClusterStateFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateGlobalClusterError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateGlobalClusterErrorKind::DbClusterNotFoundFault(_inner) => _inner.fmt(f),
            CreateGlobalClusterErrorKind::GlobalClusterAlreadyExistsFault(_inner) => _inner.fmt(f),
            CreateGlobalClusterErrorKind::GlobalClusterQuotaExceededFault(_inner) => _inner.fmt(f),
            CreateGlobalClusterErrorKind::InvalidDbClusterStateFault(_inner) => _inner.fmt(f),
            CreateGlobalClusterErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateGlobalClusterError {
    fn code(&self) -> Option<&str> {
        CreateGlobalClusterError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateGlobalClusterError {
    /// Creates a new `CreateGlobalClusterError`.
    pub fn new(kind: CreateGlobalClusterErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateGlobalClusterError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateGlobalClusterErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateGlobalClusterError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateGlobalClusterErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateGlobalClusterErrorKind::DbClusterNotFoundFault`.
    pub fn is_db_cluster_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateGlobalClusterErrorKind::DbClusterNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateGlobalClusterErrorKind::GlobalClusterAlreadyExistsFault`.
    pub fn is_global_cluster_already_exists_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateGlobalClusterErrorKind::GlobalClusterAlreadyExistsFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateGlobalClusterErrorKind::GlobalClusterQuotaExceededFault`.
    pub fn is_global_cluster_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateGlobalClusterErrorKind::GlobalClusterQuotaExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateGlobalClusterErrorKind::InvalidDbClusterStateFault`.
    pub fn is_invalid_db_cluster_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateGlobalClusterErrorKind::InvalidDbClusterStateFault(_)
        )
    }
}
impl std::error::Error for CreateGlobalClusterError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateGlobalClusterErrorKind::DbClusterNotFoundFault(_inner) => Some(_inner),
            CreateGlobalClusterErrorKind::GlobalClusterAlreadyExistsFault(_inner) => Some(_inner),
            CreateGlobalClusterErrorKind::GlobalClusterQuotaExceededFault(_inner) => Some(_inner),
            CreateGlobalClusterErrorKind::InvalidDbClusterStateFault(_inner) => Some(_inner),
            CreateGlobalClusterErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateOptionGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateOptionGroupError {
    /// Kind of error that occurred.
    pub kind: CreateOptionGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateOptionGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateOptionGroupErrorKind {
    /// <p>The option group you are trying to create already exists.</p>
    OptionGroupAlreadyExistsFault(crate::error::OptionGroupAlreadyExistsFault),
    /// <p>The quota of 20 option groups was exceeded for this Amazon Web Services account.</p>
    OptionGroupQuotaExceededFault(crate::error::OptionGroupQuotaExceededFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateOptionGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateOptionGroupErrorKind::OptionGroupAlreadyExistsFault(_inner) => _inner.fmt(f),
            CreateOptionGroupErrorKind::OptionGroupQuotaExceededFault(_inner) => _inner.fmt(f),
            CreateOptionGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateOptionGroupError {
    fn code(&self) -> Option<&str> {
        CreateOptionGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateOptionGroupError {
    /// Creates a new `CreateOptionGroupError`.
    pub fn new(kind: CreateOptionGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateOptionGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateOptionGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateOptionGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateOptionGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateOptionGroupErrorKind::OptionGroupAlreadyExistsFault`.
    pub fn is_option_group_already_exists_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateOptionGroupErrorKind::OptionGroupAlreadyExistsFault(_)
        )
    }
    /// Returns `true` if the error kind is `CreateOptionGroupErrorKind::OptionGroupQuotaExceededFault`.
    pub fn is_option_group_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            CreateOptionGroupErrorKind::OptionGroupQuotaExceededFault(_)
        )
    }
}
impl std::error::Error for CreateOptionGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateOptionGroupErrorKind::OptionGroupAlreadyExistsFault(_inner) => Some(_inner),
            CreateOptionGroupErrorKind::OptionGroupQuotaExceededFault(_inner) => Some(_inner),
            CreateOptionGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteCustomAvailabilityZone` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteCustomAvailabilityZoneError {
    /// Kind of error that occurred.
    pub kind: DeleteCustomAvailabilityZoneErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteCustomAvailabilityZone` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteCustomAvailabilityZoneErrorKind {
    /// <p> <code>CustomAvailabilityZoneId</code> doesn't refer to an existing custom Availability Zone identifier.</p>
    CustomAvailabilityZoneNotFoundFault(crate::error::CustomAvailabilityZoneNotFoundFault),
    /// <p>An error occurred accessing an Amazon Web Services KMS key.</p>
    KmsKeyNotAccessibleFault(crate::error::KmsKeyNotAccessibleFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteCustomAvailabilityZoneError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteCustomAvailabilityZoneErrorKind::CustomAvailabilityZoneNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            DeleteCustomAvailabilityZoneErrorKind::KmsKeyNotAccessibleFault(_inner) => {
                _inner.fmt(f)
            }
            DeleteCustomAvailabilityZoneErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteCustomAvailabilityZoneError {
    fn code(&self) -> Option<&str> {
        DeleteCustomAvailabilityZoneError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteCustomAvailabilityZoneError {
    /// Creates a new `DeleteCustomAvailabilityZoneError`.
    pub fn new(kind: DeleteCustomAvailabilityZoneErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteCustomAvailabilityZoneError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteCustomAvailabilityZoneErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteCustomAvailabilityZoneError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteCustomAvailabilityZoneErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteCustomAvailabilityZoneErrorKind::CustomAvailabilityZoneNotFoundFault`.
    pub fn is_custom_availability_zone_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCustomAvailabilityZoneErrorKind::CustomAvailabilityZoneNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteCustomAvailabilityZoneErrorKind::KmsKeyNotAccessibleFault`.
    pub fn is_kms_key_not_accessible_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCustomAvailabilityZoneErrorKind::KmsKeyNotAccessibleFault(_)
        )
    }
}
impl std::error::Error for DeleteCustomAvailabilityZoneError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteCustomAvailabilityZoneErrorKind::CustomAvailabilityZoneNotFoundFault(_inner) => {
                Some(_inner)
            }
            DeleteCustomAvailabilityZoneErrorKind::KmsKeyNotAccessibleFault(_inner) => Some(_inner),
            DeleteCustomAvailabilityZoneErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteCustomDBEngineVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteCustomDBEngineVersionError {
    /// Kind of error that occurred.
    pub kind: DeleteCustomDBEngineVersionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteCustomDBEngineVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteCustomDBEngineVersionErrorKind {
    /// <p>The specified CEV was not found.</p>
    CustomDbEngineVersionNotFoundFault(crate::error::CustomDbEngineVersionNotFoundFault),
    /// <p>You can't delete the CEV.</p>
    InvalidCustomDbEngineVersionStateFault(crate::error::InvalidCustomDbEngineVersionStateFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteCustomDBEngineVersionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteCustomDBEngineVersionErrorKind::CustomDbEngineVersionNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            DeleteCustomDBEngineVersionErrorKind::InvalidCustomDbEngineVersionStateFault(
                _inner,
            ) => _inner.fmt(f),
            DeleteCustomDBEngineVersionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteCustomDBEngineVersionError {
    fn code(&self) -> Option<&str> {
        DeleteCustomDBEngineVersionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteCustomDBEngineVersionError {
    /// Creates a new `DeleteCustomDBEngineVersionError`.
    pub fn new(kind: DeleteCustomDBEngineVersionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteCustomDBEngineVersionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteCustomDBEngineVersionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteCustomDBEngineVersionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteCustomDBEngineVersionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteCustomDBEngineVersionErrorKind::CustomDbEngineVersionNotFoundFault`.
    pub fn is_custom_db_engine_version_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCustomDBEngineVersionErrorKind::CustomDbEngineVersionNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteCustomDBEngineVersionErrorKind::InvalidCustomDbEngineVersionStateFault`.
    pub fn is_invalid_custom_db_engine_version_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCustomDBEngineVersionErrorKind::InvalidCustomDbEngineVersionStateFault(_)
        )
    }
}
impl std::error::Error for DeleteCustomDBEngineVersionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteCustomDBEngineVersionErrorKind::CustomDbEngineVersionNotFoundFault(_inner) => {
                Some(_inner)
            }
            DeleteCustomDBEngineVersionErrorKind::InvalidCustomDbEngineVersionStateFault(
                _inner,
            ) => Some(_inner),
            DeleteCustomDBEngineVersionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteDBCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteDBClusterError {
    /// Kind of error that occurred.
    pub kind: DeleteDBClusterErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteDBCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteDBClusterErrorKind {
    /// <p> <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster. </p>
    DbClusterNotFoundFault(crate::error::DbClusterNotFoundFault),
    /// <p>The user already has a DB cluster snapshot with the given identifier.</p>
    DbClusterSnapshotAlreadyExistsFault(crate::error::DbClusterSnapshotAlreadyExistsFault),
    /// <p>The supplied value isn't a valid DB cluster snapshot state.</p>
    InvalidDbClusterSnapshotStateFault(crate::error::InvalidDbClusterSnapshotStateFault),
    /// <p>The requested operation can't be performed while the cluster is in this state.</p>
    InvalidDbClusterStateFault(crate::error::InvalidDbClusterStateFault),
    /// <p>The request would result in the user exceeding the allowed number of DB snapshots.</p>
    SnapshotQuotaExceededFault(crate::error::SnapshotQuotaExceededFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteDBClusterError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteDBClusterErrorKind::DbClusterNotFoundFault(_inner) => _inner.fmt(f),
            DeleteDBClusterErrorKind::DbClusterSnapshotAlreadyExistsFault(_inner) => _inner.fmt(f),
            DeleteDBClusterErrorKind::InvalidDbClusterSnapshotStateFault(_inner) => _inner.fmt(f),
            DeleteDBClusterErrorKind::InvalidDbClusterStateFault(_inner) => _inner.fmt(f),
            DeleteDBClusterErrorKind::SnapshotQuotaExceededFault(_inner) => _inner.fmt(f),
            DeleteDBClusterErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteDBClusterError {
    fn code(&self) -> Option<&str> {
        DeleteDBClusterError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteDBClusterError {
    /// Creates a new `DeleteDBClusterError`.
    pub fn new(kind: DeleteDBClusterErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteDBClusterError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteDBClusterErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteDBClusterError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteDBClusterErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteDBClusterErrorKind::DbClusterNotFoundFault`.
    pub fn is_db_cluster_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDBClusterErrorKind::DbClusterNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDBClusterErrorKind::DbClusterSnapshotAlreadyExistsFault`.
    pub fn is_db_cluster_snapshot_already_exists_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDBClusterErrorKind::DbClusterSnapshotAlreadyExistsFault(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDBClusterErrorKind::InvalidDbClusterSnapshotStateFault`.
    pub fn is_invalid_db_cluster_snapshot_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDBClusterErrorKind::InvalidDbClusterSnapshotStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDBClusterErrorKind::InvalidDbClusterStateFault`.
    pub fn is_invalid_db_cluster_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDBClusterErrorKind::InvalidDbClusterStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDBClusterErrorKind::SnapshotQuotaExceededFault`.
    pub fn is_snapshot_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDBClusterErrorKind::SnapshotQuotaExceededFault(_)
        )
    }
}
impl std::error::Error for DeleteDBClusterError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteDBClusterErrorKind::DbClusterNotFoundFault(_inner) => Some(_inner),
            DeleteDBClusterErrorKind::DbClusterSnapshotAlreadyExistsFault(_inner) => Some(_inner),
            DeleteDBClusterErrorKind::InvalidDbClusterSnapshotStateFault(_inner) => Some(_inner),
            DeleteDBClusterErrorKind::InvalidDbClusterStateFault(_inner) => Some(_inner),
            DeleteDBClusterErrorKind::SnapshotQuotaExceededFault(_inner) => Some(_inner),
            DeleteDBClusterErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteDBClusterEndpoint` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteDBClusterEndpointError {
    /// Kind of error that occurred.
    pub kind: DeleteDBClusterEndpointErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteDBClusterEndpoint` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteDBClusterEndpointErrorKind {
    /// <p>The specified custom endpoint doesn't exist.</p>
    DbClusterEndpointNotFoundFault(crate::error::DbClusterEndpointNotFoundFault),
    /// <p>The requested operation can't be performed on the endpoint while the endpoint is in this state.</p>
    InvalidDbClusterEndpointStateFault(crate::error::InvalidDbClusterEndpointStateFault),
    /// <p>The requested operation can't be performed while the cluster is in this state.</p>
    InvalidDbClusterStateFault(crate::error::InvalidDbClusterStateFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteDBClusterEndpointError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteDBClusterEndpointErrorKind::DbClusterEndpointNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            DeleteDBClusterEndpointErrorKind::InvalidDbClusterEndpointStateFault(_inner) => {
                _inner.fmt(f)
            }
            DeleteDBClusterEndpointErrorKind::InvalidDbClusterStateFault(_inner) => _inner.fmt(f),
            DeleteDBClusterEndpointErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteDBClusterEndpointError {
    fn code(&self) -> Option<&str> {
        DeleteDBClusterEndpointError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteDBClusterEndpointError {
    /// Creates a new `DeleteDBClusterEndpointError`.
    pub fn new(kind: DeleteDBClusterEndpointErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteDBClusterEndpointError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteDBClusterEndpointErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteDBClusterEndpointError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteDBClusterEndpointErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteDBClusterEndpointErrorKind::DbClusterEndpointNotFoundFault`.
    pub fn is_db_cluster_endpoint_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDBClusterEndpointErrorKind::DbClusterEndpointNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDBClusterEndpointErrorKind::InvalidDbClusterEndpointStateFault`.
    pub fn is_invalid_db_cluster_endpoint_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDBClusterEndpointErrorKind::InvalidDbClusterEndpointStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDBClusterEndpointErrorKind::InvalidDbClusterStateFault`.
    pub fn is_invalid_db_cluster_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDBClusterEndpointErrorKind::InvalidDbClusterStateFault(_)
        )
    }
}
impl std::error::Error for DeleteDBClusterEndpointError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteDBClusterEndpointErrorKind::DbClusterEndpointNotFoundFault(_inner) => {
                Some(_inner)
            }
            DeleteDBClusterEndpointErrorKind::InvalidDbClusterEndpointStateFault(_inner) => {
                Some(_inner)
            }
            DeleteDBClusterEndpointErrorKind::InvalidDbClusterStateFault(_inner) => Some(_inner),
            DeleteDBClusterEndpointErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteDBClusterParameterGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteDBClusterParameterGroupError {
    /// Kind of error that occurred.
    pub kind: DeleteDBClusterParameterGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteDBClusterParameterGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteDBClusterParameterGroupErrorKind {
    /// <p> <code>DBParameterGroupName</code> doesn't refer to an existing DB parameter group. </p>
    DbParameterGroupNotFoundFault(crate::error::DbParameterGroupNotFoundFault),
    /// <p>The DB parameter group is in use or is in an invalid state. If you are attempting to delete the parameter group, you can't delete it when the parameter group is in this state.</p>
    InvalidDbParameterGroupStateFault(crate::error::InvalidDbParameterGroupStateFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteDBClusterParameterGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteDBClusterParameterGroupErrorKind::DbParameterGroupNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            DeleteDBClusterParameterGroupErrorKind::InvalidDbParameterGroupStateFault(_inner) => {
                _inner.fmt(f)
            }
            DeleteDBClusterParameterGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteDBClusterParameterGroupError {
    fn code(&self) -> Option<&str> {
        DeleteDBClusterParameterGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteDBClusterParameterGroupError {
    /// Creates a new `DeleteDBClusterParameterGroupError`.
    pub fn new(
        kind: DeleteDBClusterParameterGroupErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteDBClusterParameterGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteDBClusterParameterGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteDBClusterParameterGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteDBClusterParameterGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteDBClusterParameterGroupErrorKind::DbParameterGroupNotFoundFault`.
    pub fn is_db_parameter_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDBClusterParameterGroupErrorKind::DbParameterGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDBClusterParameterGroupErrorKind::InvalidDbParameterGroupStateFault`.
    pub fn is_invalid_db_parameter_group_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDBClusterParameterGroupErrorKind::InvalidDbParameterGroupStateFault(_)
        )
    }
}
impl std::error::Error for DeleteDBClusterParameterGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteDBClusterParameterGroupErrorKind::DbParameterGroupNotFoundFault(_inner) => {
                Some(_inner)
            }
            DeleteDBClusterParameterGroupErrorKind::InvalidDbParameterGroupStateFault(_inner) => {
                Some(_inner)
            }
            DeleteDBClusterParameterGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteDBClusterSnapshot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteDBClusterSnapshotError {
    /// Kind of error that occurred.
    pub kind: DeleteDBClusterSnapshotErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteDBClusterSnapshot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteDBClusterSnapshotErrorKind {
    /// <p> <code>DBClusterSnapshotIdentifier</code> doesn't refer to an existing DB cluster snapshot. </p>
    DbClusterSnapshotNotFoundFault(crate::error::DbClusterSnapshotNotFoundFault),
    /// <p>The supplied value isn't a valid DB cluster snapshot state.</p>
    InvalidDbClusterSnapshotStateFault(crate::error::InvalidDbClusterSnapshotStateFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteDBClusterSnapshotError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteDBClusterSnapshotErrorKind::DbClusterSnapshotNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            DeleteDBClusterSnapshotErrorKind::InvalidDbClusterSnapshotStateFault(_inner) => {
                _inner.fmt(f)
            }
            DeleteDBClusterSnapshotErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteDBClusterSnapshotError {
    fn code(&self) -> Option<&str> {
        DeleteDBClusterSnapshotError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteDBClusterSnapshotError {
    /// Creates a new `DeleteDBClusterSnapshotError`.
    pub fn new(kind: DeleteDBClusterSnapshotErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteDBClusterSnapshotError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteDBClusterSnapshotErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteDBClusterSnapshotError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteDBClusterSnapshotErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteDBClusterSnapshotErrorKind::DbClusterSnapshotNotFoundFault`.
    pub fn is_db_cluster_snapshot_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDBClusterSnapshotErrorKind::DbClusterSnapshotNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDBClusterSnapshotErrorKind::InvalidDbClusterSnapshotStateFault`.
    pub fn is_invalid_db_cluster_snapshot_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDBClusterSnapshotErrorKind::InvalidDbClusterSnapshotStateFault(_)
        )
    }
}
impl std::error::Error for DeleteDBClusterSnapshotError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteDBClusterSnapshotErrorKind::DbClusterSnapshotNotFoundFault(_inner) => {
                Some(_inner)
            }
            DeleteDBClusterSnapshotErrorKind::InvalidDbClusterSnapshotStateFault(_inner) => {
                Some(_inner)
            }
            DeleteDBClusterSnapshotErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteDBInstance` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteDBInstanceError {
    /// Kind of error that occurred.
    pub kind: DeleteDBInstanceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteDBInstance` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteDBInstanceErrorKind {
    /// <p>The quota for retained automated backups was exceeded. This prevents you from retaining any additional automated backups. The retained automated backups quota is the same as your DB Instance quota.</p>
    DbInstanceAutomatedBackupQuotaExceededFault(
        crate::error::DbInstanceAutomatedBackupQuotaExceededFault,
    ),
    /// <p> <code>DBInstanceIdentifier</code> doesn't refer to an existing DB instance. </p>
    DbInstanceNotFoundFault(crate::error::DbInstanceNotFoundFault),
    /// <p> <code>DBSnapshotIdentifier</code> is already used by an existing snapshot. </p>
    DbSnapshotAlreadyExistsFault(crate::error::DbSnapshotAlreadyExistsFault),
    /// <p>The requested operation can't be performed while the cluster is in this state.</p>
    InvalidDbClusterStateFault(crate::error::InvalidDbClusterStateFault),
    /// <p>The DB instance isn't in a valid state.</p>
    InvalidDbInstanceStateFault(crate::error::InvalidDbInstanceStateFault),
    /// <p>The request would result in the user exceeding the allowed number of DB snapshots.</p>
    SnapshotQuotaExceededFault(crate::error::SnapshotQuotaExceededFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteDBInstanceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteDBInstanceErrorKind::DbInstanceAutomatedBackupQuotaExceededFault(_inner) => {
                _inner.fmt(f)
            }
            DeleteDBInstanceErrorKind::DbInstanceNotFoundFault(_inner) => _inner.fmt(f),
            DeleteDBInstanceErrorKind::DbSnapshotAlreadyExistsFault(_inner) => _inner.fmt(f),
            DeleteDBInstanceErrorKind::InvalidDbClusterStateFault(_inner) => _inner.fmt(f),
            DeleteDBInstanceErrorKind::InvalidDbInstanceStateFault(_inner) => _inner.fmt(f),
            DeleteDBInstanceErrorKind::SnapshotQuotaExceededFault(_inner) => _inner.fmt(f),
            DeleteDBInstanceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteDBInstanceError {
    fn code(&self) -> Option<&str> {
        DeleteDBInstanceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteDBInstanceError {
    /// Creates a new `DeleteDBInstanceError`.
    pub fn new(kind: DeleteDBInstanceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteDBInstanceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteDBInstanceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteDBInstanceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteDBInstanceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteDBInstanceErrorKind::DbInstanceAutomatedBackupQuotaExceededFault`.
    pub fn is_db_instance_automated_backup_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDBInstanceErrorKind::DbInstanceAutomatedBackupQuotaExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDBInstanceErrorKind::DbInstanceNotFoundFault`.
    pub fn is_db_instance_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDBInstanceErrorKind::DbInstanceNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDBInstanceErrorKind::DbSnapshotAlreadyExistsFault`.
    pub fn is_db_snapshot_already_exists_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDBInstanceErrorKind::DbSnapshotAlreadyExistsFault(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDBInstanceErrorKind::InvalidDbClusterStateFault`.
    pub fn is_invalid_db_cluster_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDBInstanceErrorKind::InvalidDbClusterStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDBInstanceErrorKind::InvalidDbInstanceStateFault`.
    pub fn is_invalid_db_instance_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDBInstanceErrorKind::InvalidDbInstanceStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDBInstanceErrorKind::SnapshotQuotaExceededFault`.
    pub fn is_snapshot_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDBInstanceErrorKind::SnapshotQuotaExceededFault(_)
        )
    }
}
impl std::error::Error for DeleteDBInstanceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteDBInstanceErrorKind::DbInstanceAutomatedBackupQuotaExceededFault(_inner) => {
                Some(_inner)
            }
            DeleteDBInstanceErrorKind::DbInstanceNotFoundFault(_inner) => Some(_inner),
            DeleteDBInstanceErrorKind::DbSnapshotAlreadyExistsFault(_inner) => Some(_inner),
            DeleteDBInstanceErrorKind::InvalidDbClusterStateFault(_inner) => Some(_inner),
            DeleteDBInstanceErrorKind::InvalidDbInstanceStateFault(_inner) => Some(_inner),
            DeleteDBInstanceErrorKind::SnapshotQuotaExceededFault(_inner) => Some(_inner),
            DeleteDBInstanceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteDBInstanceAutomatedBackup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteDBInstanceAutomatedBackupError {
    /// Kind of error that occurred.
    pub kind: DeleteDBInstanceAutomatedBackupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteDBInstanceAutomatedBackup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteDBInstanceAutomatedBackupErrorKind {
    /// <p>No automated backup for this DB instance was found.</p>
    DbInstanceAutomatedBackupNotFoundFault(crate::error::DbInstanceAutomatedBackupNotFoundFault),
    /// <p>The automated backup is in an invalid state. For example, this automated backup is associated with an active instance. </p>
    InvalidDbInstanceAutomatedBackupStateFault(
        crate::error::InvalidDbInstanceAutomatedBackupStateFault,
    ),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteDBInstanceAutomatedBackupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteDBInstanceAutomatedBackupErrorKind::DbInstanceAutomatedBackupNotFoundFault(_inner) =>
            _inner.fmt(f)
            ,
            DeleteDBInstanceAutomatedBackupErrorKind::InvalidDbInstanceAutomatedBackupStateFault(_inner) =>
            _inner.fmt(f)
            ,
            DeleteDBInstanceAutomatedBackupErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteDBInstanceAutomatedBackupError {
    fn code(&self) -> Option<&str> {
        DeleteDBInstanceAutomatedBackupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteDBInstanceAutomatedBackupError {
    /// Creates a new `DeleteDBInstanceAutomatedBackupError`.
    pub fn new(
        kind: DeleteDBInstanceAutomatedBackupErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteDBInstanceAutomatedBackupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteDBInstanceAutomatedBackupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteDBInstanceAutomatedBackupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteDBInstanceAutomatedBackupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteDBInstanceAutomatedBackupErrorKind::DbInstanceAutomatedBackupNotFoundFault`.
    pub fn is_db_instance_automated_backup_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDBInstanceAutomatedBackupErrorKind::DbInstanceAutomatedBackupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDBInstanceAutomatedBackupErrorKind::InvalidDbInstanceAutomatedBackupStateFault`.
    pub fn is_invalid_db_instance_automated_backup_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDBInstanceAutomatedBackupErrorKind::InvalidDbInstanceAutomatedBackupStateFault(_)
        )
    }
}
impl std::error::Error for DeleteDBInstanceAutomatedBackupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteDBInstanceAutomatedBackupErrorKind::DbInstanceAutomatedBackupNotFoundFault(_inner) =>
            Some(_inner)
            ,
            DeleteDBInstanceAutomatedBackupErrorKind::InvalidDbInstanceAutomatedBackupStateFault(_inner) =>
            Some(_inner)
            ,
            DeleteDBInstanceAutomatedBackupErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DeleteDBParameterGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteDBParameterGroupError {
    /// Kind of error that occurred.
    pub kind: DeleteDBParameterGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteDBParameterGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteDBParameterGroupErrorKind {
    /// <p> <code>DBParameterGroupName</code> doesn't refer to an existing DB parameter group. </p>
    DbParameterGroupNotFoundFault(crate::error::DbParameterGroupNotFoundFault),
    /// <p>The DB parameter group is in use or is in an invalid state. If you are attempting to delete the parameter group, you can't delete it when the parameter group is in this state.</p>
    InvalidDbParameterGroupStateFault(crate::error::InvalidDbParameterGroupStateFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteDBParameterGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteDBParameterGroupErrorKind::DbParameterGroupNotFoundFault(_inner) => _inner.fmt(f),
            DeleteDBParameterGroupErrorKind::InvalidDbParameterGroupStateFault(_inner) => {
                _inner.fmt(f)
            }
            DeleteDBParameterGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteDBParameterGroupError {
    fn code(&self) -> Option<&str> {
        DeleteDBParameterGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteDBParameterGroupError {
    /// Creates a new `DeleteDBParameterGroupError`.
    pub fn new(kind: DeleteDBParameterGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteDBParameterGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteDBParameterGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteDBParameterGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteDBParameterGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteDBParameterGroupErrorKind::DbParameterGroupNotFoundFault`.
    pub fn is_db_parameter_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDBParameterGroupErrorKind::DbParameterGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDBParameterGroupErrorKind::InvalidDbParameterGroupStateFault`.
    pub fn is_invalid_db_parameter_group_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDBParameterGroupErrorKind::InvalidDbParameterGroupStateFault(_)
        )
    }
}
impl std::error::Error for DeleteDBParameterGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteDBParameterGroupErrorKind::DbParameterGroupNotFoundFault(_inner) => Some(_inner),
            DeleteDBParameterGroupErrorKind::InvalidDbParameterGroupStateFault(_inner) => {
                Some(_inner)
            }
            DeleteDBParameterGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteDBProxy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteDBProxyError {
    /// Kind of error that occurred.
    pub kind: DeleteDBProxyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteDBProxy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteDBProxyErrorKind {
    /// <p>The specified proxy name doesn't correspond to a proxy owned by your Amazon Web Services account in the specified Amazon Web Services Region.</p>
    DbProxyNotFoundFault(crate::error::DbProxyNotFoundFault),
    /// <p>The requested operation can't be performed while the proxy is in this state.</p>
    InvalidDbProxyStateFault(crate::error::InvalidDbProxyStateFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteDBProxyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteDBProxyErrorKind::DbProxyNotFoundFault(_inner) => _inner.fmt(f),
            DeleteDBProxyErrorKind::InvalidDbProxyStateFault(_inner) => _inner.fmt(f),
            DeleteDBProxyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteDBProxyError {
    fn code(&self) -> Option<&str> {
        DeleteDBProxyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteDBProxyError {
    /// Creates a new `DeleteDBProxyError`.
    pub fn new(kind: DeleteDBProxyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteDBProxyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteDBProxyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteDBProxyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteDBProxyErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteDBProxyErrorKind::DbProxyNotFoundFault`.
    pub fn is_db_proxy_not_found_fault(&self) -> bool {
        matches!(&self.kind, DeleteDBProxyErrorKind::DbProxyNotFoundFault(_))
    }
    /// Returns `true` if the error kind is `DeleteDBProxyErrorKind::InvalidDbProxyStateFault`.
    pub fn is_invalid_db_proxy_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDBProxyErrorKind::InvalidDbProxyStateFault(_)
        )
    }
}
impl std::error::Error for DeleteDBProxyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteDBProxyErrorKind::DbProxyNotFoundFault(_inner) => Some(_inner),
            DeleteDBProxyErrorKind::InvalidDbProxyStateFault(_inner) => Some(_inner),
            DeleteDBProxyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteDBProxyEndpoint` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteDBProxyEndpointError {
    /// Kind of error that occurred.
    pub kind: DeleteDBProxyEndpointErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteDBProxyEndpoint` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteDBProxyEndpointErrorKind {
    /// <p>The DB proxy endpoint doesn't exist.</p>
    DbProxyEndpointNotFoundFault(crate::error::DbProxyEndpointNotFoundFault),
    /// <p>You can't perform this operation while the DB proxy endpoint is in a particular state.</p>
    InvalidDbProxyEndpointStateFault(crate::error::InvalidDbProxyEndpointStateFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteDBProxyEndpointError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteDBProxyEndpointErrorKind::DbProxyEndpointNotFoundFault(_inner) => _inner.fmt(f),
            DeleteDBProxyEndpointErrorKind::InvalidDbProxyEndpointStateFault(_inner) => {
                _inner.fmt(f)
            }
            DeleteDBProxyEndpointErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteDBProxyEndpointError {
    fn code(&self) -> Option<&str> {
        DeleteDBProxyEndpointError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteDBProxyEndpointError {
    /// Creates a new `DeleteDBProxyEndpointError`.
    pub fn new(kind: DeleteDBProxyEndpointErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteDBProxyEndpointError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteDBProxyEndpointErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteDBProxyEndpointError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteDBProxyEndpointErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteDBProxyEndpointErrorKind::DbProxyEndpointNotFoundFault`.
    pub fn is_db_proxy_endpoint_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDBProxyEndpointErrorKind::DbProxyEndpointNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDBProxyEndpointErrorKind::InvalidDbProxyEndpointStateFault`.
    pub fn is_invalid_db_proxy_endpoint_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDBProxyEndpointErrorKind::InvalidDbProxyEndpointStateFault(_)
        )
    }
}
impl std::error::Error for DeleteDBProxyEndpointError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteDBProxyEndpointErrorKind::DbProxyEndpointNotFoundFault(_inner) => Some(_inner),
            DeleteDBProxyEndpointErrorKind::InvalidDbProxyEndpointStateFault(_inner) => {
                Some(_inner)
            }
            DeleteDBProxyEndpointErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteDBSecurityGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteDBSecurityGroupError {
    /// Kind of error that occurred.
    pub kind: DeleteDBSecurityGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteDBSecurityGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteDBSecurityGroupErrorKind {
    /// <p> <code>DBSecurityGroupName</code> doesn't refer to an existing DB security group. </p>
    DbSecurityGroupNotFoundFault(crate::error::DbSecurityGroupNotFoundFault),
    /// <p>The state of the DB security group doesn't allow deletion.</p>
    InvalidDbSecurityGroupStateFault(crate::error::InvalidDbSecurityGroupStateFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteDBSecurityGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteDBSecurityGroupErrorKind::DbSecurityGroupNotFoundFault(_inner) => _inner.fmt(f),
            DeleteDBSecurityGroupErrorKind::InvalidDbSecurityGroupStateFault(_inner) => {
                _inner.fmt(f)
            }
            DeleteDBSecurityGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteDBSecurityGroupError {
    fn code(&self) -> Option<&str> {
        DeleteDBSecurityGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteDBSecurityGroupError {
    /// Creates a new `DeleteDBSecurityGroupError`.
    pub fn new(kind: DeleteDBSecurityGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteDBSecurityGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteDBSecurityGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteDBSecurityGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteDBSecurityGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteDBSecurityGroupErrorKind::DbSecurityGroupNotFoundFault`.
    pub fn is_db_security_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDBSecurityGroupErrorKind::DbSecurityGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDBSecurityGroupErrorKind::InvalidDbSecurityGroupStateFault`.
    pub fn is_invalid_db_security_group_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDBSecurityGroupErrorKind::InvalidDbSecurityGroupStateFault(_)
        )
    }
}
impl std::error::Error for DeleteDBSecurityGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteDBSecurityGroupErrorKind::DbSecurityGroupNotFoundFault(_inner) => Some(_inner),
            DeleteDBSecurityGroupErrorKind::InvalidDbSecurityGroupStateFault(_inner) => {
                Some(_inner)
            }
            DeleteDBSecurityGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteDBSnapshot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteDBSnapshotError {
    /// Kind of error that occurred.
    pub kind: DeleteDBSnapshotErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteDBSnapshot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteDBSnapshotErrorKind {
    /// <p> <code>DBSnapshotIdentifier</code> doesn't refer to an existing DB snapshot. </p>
    DbSnapshotNotFoundFault(crate::error::DbSnapshotNotFoundFault),
    /// <p>The state of the DB snapshot doesn't allow deletion.</p>
    InvalidDbSnapshotStateFault(crate::error::InvalidDbSnapshotStateFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteDBSnapshotError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteDBSnapshotErrorKind::DbSnapshotNotFoundFault(_inner) => _inner.fmt(f),
            DeleteDBSnapshotErrorKind::InvalidDbSnapshotStateFault(_inner) => _inner.fmt(f),
            DeleteDBSnapshotErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteDBSnapshotError {
    fn code(&self) -> Option<&str> {
        DeleteDBSnapshotError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteDBSnapshotError {
    /// Creates a new `DeleteDBSnapshotError`.
    pub fn new(kind: DeleteDBSnapshotErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteDBSnapshotError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteDBSnapshotErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteDBSnapshotError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteDBSnapshotErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteDBSnapshotErrorKind::DbSnapshotNotFoundFault`.
    pub fn is_db_snapshot_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDBSnapshotErrorKind::DbSnapshotNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDBSnapshotErrorKind::InvalidDbSnapshotStateFault`.
    pub fn is_invalid_db_snapshot_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDBSnapshotErrorKind::InvalidDbSnapshotStateFault(_)
        )
    }
}
impl std::error::Error for DeleteDBSnapshotError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteDBSnapshotErrorKind::DbSnapshotNotFoundFault(_inner) => Some(_inner),
            DeleteDBSnapshotErrorKind::InvalidDbSnapshotStateFault(_inner) => Some(_inner),
            DeleteDBSnapshotErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteDBSubnetGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteDBSubnetGroupError {
    /// Kind of error that occurred.
    pub kind: DeleteDBSubnetGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteDBSubnetGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteDBSubnetGroupErrorKind {
    /// <p> <code>DBSubnetGroupName</code> doesn't refer to an existing DB subnet group. </p>
    DbSubnetGroupNotFoundFault(crate::error::DbSubnetGroupNotFoundFault),
    /// <p>The DB subnet group cannot be deleted because it's in use.</p>
    InvalidDbSubnetGroupStateFault(crate::error::InvalidDbSubnetGroupStateFault),
    /// <p> The DB subnet isn't in the <i>available</i> state. </p>
    InvalidDbSubnetStateFault(crate::error::InvalidDbSubnetStateFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteDBSubnetGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteDBSubnetGroupErrorKind::DbSubnetGroupNotFoundFault(_inner) => _inner.fmt(f),
            DeleteDBSubnetGroupErrorKind::InvalidDbSubnetGroupStateFault(_inner) => _inner.fmt(f),
            DeleteDBSubnetGroupErrorKind::InvalidDbSubnetStateFault(_inner) => _inner.fmt(f),
            DeleteDBSubnetGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteDBSubnetGroupError {
    fn code(&self) -> Option<&str> {
        DeleteDBSubnetGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteDBSubnetGroupError {
    /// Creates a new `DeleteDBSubnetGroupError`.
    pub fn new(kind: DeleteDBSubnetGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteDBSubnetGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteDBSubnetGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteDBSubnetGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteDBSubnetGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteDBSubnetGroupErrorKind::DbSubnetGroupNotFoundFault`.
    pub fn is_db_subnet_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDBSubnetGroupErrorKind::DbSubnetGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDBSubnetGroupErrorKind::InvalidDbSubnetGroupStateFault`.
    pub fn is_invalid_db_subnet_group_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDBSubnetGroupErrorKind::InvalidDbSubnetGroupStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDBSubnetGroupErrorKind::InvalidDbSubnetStateFault`.
    pub fn is_invalid_db_subnet_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDBSubnetGroupErrorKind::InvalidDbSubnetStateFault(_)
        )
    }
}
impl std::error::Error for DeleteDBSubnetGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteDBSubnetGroupErrorKind::DbSubnetGroupNotFoundFault(_inner) => Some(_inner),
            DeleteDBSubnetGroupErrorKind::InvalidDbSubnetGroupStateFault(_inner) => Some(_inner),
            DeleteDBSubnetGroupErrorKind::InvalidDbSubnetStateFault(_inner) => Some(_inner),
            DeleteDBSubnetGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteEventSubscription` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteEventSubscriptionError {
    /// Kind of error that occurred.
    pub kind: DeleteEventSubscriptionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteEventSubscription` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteEventSubscriptionErrorKind {
    /// <p>This error can occur if someone else is modifying a subscription. You should retry the action.</p>
    InvalidEventSubscriptionStateFault(crate::error::InvalidEventSubscriptionStateFault),
    /// <p>The subscription name does not exist.</p>
    SubscriptionNotFoundFault(crate::error::SubscriptionNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteEventSubscriptionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteEventSubscriptionErrorKind::InvalidEventSubscriptionStateFault(_inner) => {
                _inner.fmt(f)
            }
            DeleteEventSubscriptionErrorKind::SubscriptionNotFoundFault(_inner) => _inner.fmt(f),
            DeleteEventSubscriptionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteEventSubscriptionError {
    fn code(&self) -> Option<&str> {
        DeleteEventSubscriptionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteEventSubscriptionError {
    /// Creates a new `DeleteEventSubscriptionError`.
    pub fn new(kind: DeleteEventSubscriptionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteEventSubscriptionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteEventSubscriptionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteEventSubscriptionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteEventSubscriptionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteEventSubscriptionErrorKind::InvalidEventSubscriptionStateFault`.
    pub fn is_invalid_event_subscription_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEventSubscriptionErrorKind::InvalidEventSubscriptionStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEventSubscriptionErrorKind::SubscriptionNotFoundFault`.
    pub fn is_subscription_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEventSubscriptionErrorKind::SubscriptionNotFoundFault(_)
        )
    }
}
impl std::error::Error for DeleteEventSubscriptionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteEventSubscriptionErrorKind::InvalidEventSubscriptionStateFault(_inner) => {
                Some(_inner)
            }
            DeleteEventSubscriptionErrorKind::SubscriptionNotFoundFault(_inner) => Some(_inner),
            DeleteEventSubscriptionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteGlobalCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteGlobalClusterError {
    /// Kind of error that occurred.
    pub kind: DeleteGlobalClusterErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteGlobalCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteGlobalClusterErrorKind {
    /// <p>The <code>GlobalClusterIdentifier</code> doesn't refer to an existing global database cluster. </p>
    GlobalClusterNotFoundFault(crate::error::GlobalClusterNotFoundFault),
    /// <p>The global cluster is in an invalid state and can't perform the requested operation. </p>
    InvalidGlobalClusterStateFault(crate::error::InvalidGlobalClusterStateFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteGlobalClusterError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteGlobalClusterErrorKind::GlobalClusterNotFoundFault(_inner) => _inner.fmt(f),
            DeleteGlobalClusterErrorKind::InvalidGlobalClusterStateFault(_inner) => _inner.fmt(f),
            DeleteGlobalClusterErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteGlobalClusterError {
    fn code(&self) -> Option<&str> {
        DeleteGlobalClusterError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteGlobalClusterError {
    /// Creates a new `DeleteGlobalClusterError`.
    pub fn new(kind: DeleteGlobalClusterErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteGlobalClusterError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteGlobalClusterErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteGlobalClusterError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteGlobalClusterErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteGlobalClusterErrorKind::GlobalClusterNotFoundFault`.
    pub fn is_global_cluster_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteGlobalClusterErrorKind::GlobalClusterNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteGlobalClusterErrorKind::InvalidGlobalClusterStateFault`.
    pub fn is_invalid_global_cluster_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteGlobalClusterErrorKind::InvalidGlobalClusterStateFault(_)
        )
    }
}
impl std::error::Error for DeleteGlobalClusterError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteGlobalClusterErrorKind::GlobalClusterNotFoundFault(_inner) => Some(_inner),
            DeleteGlobalClusterErrorKind::InvalidGlobalClusterStateFault(_inner) => Some(_inner),
            DeleteGlobalClusterErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteInstallationMedia` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteInstallationMediaError {
    /// Kind of error that occurred.
    pub kind: DeleteInstallationMediaErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteInstallationMedia` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteInstallationMediaErrorKind {
    /// <p> <code>InstallationMediaID</code> doesn't refer to an existing installation medium.</p>
    InstallationMediaNotFoundFault(crate::error::InstallationMediaNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteInstallationMediaError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteInstallationMediaErrorKind::InstallationMediaNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            DeleteInstallationMediaErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteInstallationMediaError {
    fn code(&self) -> Option<&str> {
        DeleteInstallationMediaError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteInstallationMediaError {
    /// Creates a new `DeleteInstallationMediaError`.
    pub fn new(kind: DeleteInstallationMediaErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteInstallationMediaError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteInstallationMediaErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteInstallationMediaError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteInstallationMediaErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteInstallationMediaErrorKind::InstallationMediaNotFoundFault`.
    pub fn is_installation_media_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteInstallationMediaErrorKind::InstallationMediaNotFoundFault(_)
        )
    }
}
impl std::error::Error for DeleteInstallationMediaError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteInstallationMediaErrorKind::InstallationMediaNotFoundFault(_inner) => {
                Some(_inner)
            }
            DeleteInstallationMediaErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteOptionGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteOptionGroupError {
    /// Kind of error that occurred.
    pub kind: DeleteOptionGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteOptionGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteOptionGroupErrorKind {
    /// <p> The option group isn't in the <i>available</i> state. </p>
    InvalidOptionGroupStateFault(crate::error::InvalidOptionGroupStateFault),
    /// <p>The specified option group could not be found.</p>
    OptionGroupNotFoundFault(crate::error::OptionGroupNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteOptionGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteOptionGroupErrorKind::InvalidOptionGroupStateFault(_inner) => _inner.fmt(f),
            DeleteOptionGroupErrorKind::OptionGroupNotFoundFault(_inner) => _inner.fmt(f),
            DeleteOptionGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteOptionGroupError {
    fn code(&self) -> Option<&str> {
        DeleteOptionGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteOptionGroupError {
    /// Creates a new `DeleteOptionGroupError`.
    pub fn new(kind: DeleteOptionGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteOptionGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteOptionGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteOptionGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteOptionGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteOptionGroupErrorKind::InvalidOptionGroupStateFault`.
    pub fn is_invalid_option_group_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteOptionGroupErrorKind::InvalidOptionGroupStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteOptionGroupErrorKind::OptionGroupNotFoundFault`.
    pub fn is_option_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeleteOptionGroupErrorKind::OptionGroupNotFoundFault(_)
        )
    }
}
impl std::error::Error for DeleteOptionGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteOptionGroupErrorKind::InvalidOptionGroupStateFault(_inner) => Some(_inner),
            DeleteOptionGroupErrorKind::OptionGroupNotFoundFault(_inner) => Some(_inner),
            DeleteOptionGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeregisterDBProxyTargets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeregisterDBProxyTargetsError {
    /// Kind of error that occurred.
    pub kind: DeregisterDBProxyTargetsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeregisterDBProxyTargets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeregisterDBProxyTargetsErrorKind {
    /// <p>The specified proxy name doesn't correspond to a proxy owned by your Amazon Web Services account in the specified Amazon Web Services Region.</p>
    DbProxyNotFoundFault(crate::error::DbProxyNotFoundFault),
    /// <p>The specified target group isn't available for a proxy owned by your Amazon Web Services account in the specified Amazon Web Services Region.</p>
    DbProxyTargetGroupNotFoundFault(crate::error::DbProxyTargetGroupNotFoundFault),
    /// <p>The specified RDS DB instance or Aurora DB cluster isn't available for a proxy owned by your Amazon Web Services account in the specified Amazon Web Services Region.</p>
    DbProxyTargetNotFoundFault(crate::error::DbProxyTargetNotFoundFault),
    /// <p>The requested operation can't be performed while the proxy is in this state.</p>
    InvalidDbProxyStateFault(crate::error::InvalidDbProxyStateFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeregisterDBProxyTargetsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeregisterDBProxyTargetsErrorKind::DbProxyNotFoundFault(_inner) => _inner.fmt(f),
            DeregisterDBProxyTargetsErrorKind::DbProxyTargetGroupNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            DeregisterDBProxyTargetsErrorKind::DbProxyTargetNotFoundFault(_inner) => _inner.fmt(f),
            DeregisterDBProxyTargetsErrorKind::InvalidDbProxyStateFault(_inner) => _inner.fmt(f),
            DeregisterDBProxyTargetsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeregisterDBProxyTargetsError {
    fn code(&self) -> Option<&str> {
        DeregisterDBProxyTargetsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeregisterDBProxyTargetsError {
    /// Creates a new `DeregisterDBProxyTargetsError`.
    pub fn new(kind: DeregisterDBProxyTargetsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeregisterDBProxyTargetsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeregisterDBProxyTargetsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeregisterDBProxyTargetsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeregisterDBProxyTargetsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeregisterDBProxyTargetsErrorKind::DbProxyNotFoundFault`.
    pub fn is_db_proxy_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeregisterDBProxyTargetsErrorKind::DbProxyNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `DeregisterDBProxyTargetsErrorKind::DbProxyTargetGroupNotFoundFault`.
    pub fn is_db_proxy_target_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeregisterDBProxyTargetsErrorKind::DbProxyTargetGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `DeregisterDBProxyTargetsErrorKind::DbProxyTargetNotFoundFault`.
    pub fn is_db_proxy_target_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeregisterDBProxyTargetsErrorKind::DbProxyTargetNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `DeregisterDBProxyTargetsErrorKind::InvalidDbProxyStateFault`.
    pub fn is_invalid_db_proxy_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            DeregisterDBProxyTargetsErrorKind::InvalidDbProxyStateFault(_)
        )
    }
}
impl std::error::Error for DeregisterDBProxyTargetsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeregisterDBProxyTargetsErrorKind::DbProxyNotFoundFault(_inner) => Some(_inner),
            DeregisterDBProxyTargetsErrorKind::DbProxyTargetGroupNotFoundFault(_inner) => {
                Some(_inner)
            }
            DeregisterDBProxyTargetsErrorKind::DbProxyTargetNotFoundFault(_inner) => Some(_inner),
            DeregisterDBProxyTargetsErrorKind::InvalidDbProxyStateFault(_inner) => Some(_inner),
            DeregisterDBProxyTargetsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeAccountAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeAccountAttributesError {
    /// Kind of error that occurred.
    pub kind: DescribeAccountAttributesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeAccountAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeAccountAttributesErrorKind {
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeAccountAttributesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeAccountAttributesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeAccountAttributesError {
    fn code(&self) -> Option<&str> {
        DescribeAccountAttributesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeAccountAttributesError {
    /// Creates a new `DescribeAccountAttributesError`.
    pub fn new(kind: DescribeAccountAttributesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeAccountAttributesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeAccountAttributesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeAccountAttributesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeAccountAttributesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for DescribeAccountAttributesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeAccountAttributesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeCertificates` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeCertificatesError {
    /// Kind of error that occurred.
    pub kind: DescribeCertificatesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeCertificates` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeCertificatesErrorKind {
    /// <p> <code>CertificateIdentifier</code> doesn't refer to an existing certificate. </p>
    CertificateNotFoundFault(crate::error::CertificateNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeCertificatesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeCertificatesErrorKind::CertificateNotFoundFault(_inner) => _inner.fmt(f),
            DescribeCertificatesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeCertificatesError {
    fn code(&self) -> Option<&str> {
        DescribeCertificatesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeCertificatesError {
    /// Creates a new `DescribeCertificatesError`.
    pub fn new(kind: DescribeCertificatesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeCertificatesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeCertificatesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeCertificatesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeCertificatesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeCertificatesErrorKind::CertificateNotFoundFault`.
    pub fn is_certificate_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeCertificatesErrorKind::CertificateNotFoundFault(_)
        )
    }
}
impl std::error::Error for DescribeCertificatesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeCertificatesErrorKind::CertificateNotFoundFault(_inner) => Some(_inner),
            DescribeCertificatesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeCustomAvailabilityZones` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeCustomAvailabilityZonesError {
    /// Kind of error that occurred.
    pub kind: DescribeCustomAvailabilityZonesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeCustomAvailabilityZones` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeCustomAvailabilityZonesErrorKind {
    /// <p> <code>CustomAvailabilityZoneId</code> doesn't refer to an existing custom Availability Zone identifier.</p>
    CustomAvailabilityZoneNotFoundFault(crate::error::CustomAvailabilityZoneNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeCustomAvailabilityZonesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeCustomAvailabilityZonesErrorKind::CustomAvailabilityZoneNotFoundFault(
                _inner,
            ) => _inner.fmt(f),
            DescribeCustomAvailabilityZonesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeCustomAvailabilityZonesError {
    fn code(&self) -> Option<&str> {
        DescribeCustomAvailabilityZonesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeCustomAvailabilityZonesError {
    /// Creates a new `DescribeCustomAvailabilityZonesError`.
    pub fn new(
        kind: DescribeCustomAvailabilityZonesErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeCustomAvailabilityZonesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeCustomAvailabilityZonesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeCustomAvailabilityZonesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeCustomAvailabilityZonesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeCustomAvailabilityZonesErrorKind::CustomAvailabilityZoneNotFoundFault`.
    pub fn is_custom_availability_zone_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeCustomAvailabilityZonesErrorKind::CustomAvailabilityZoneNotFoundFault(_)
        )
    }
}
impl std::error::Error for DescribeCustomAvailabilityZonesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeCustomAvailabilityZonesErrorKind::CustomAvailabilityZoneNotFoundFault(
                _inner,
            ) => Some(_inner),
            DescribeCustomAvailabilityZonesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeDBClusterBacktracks` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeDBClusterBacktracksError {
    /// Kind of error that occurred.
    pub kind: DescribeDBClusterBacktracksErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeDBClusterBacktracks` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeDBClusterBacktracksErrorKind {
    /// <p> <code>BacktrackIdentifier</code> doesn't refer to an existing backtrack. </p>
    DbClusterBacktrackNotFoundFault(crate::error::DbClusterBacktrackNotFoundFault),
    /// <p> <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster. </p>
    DbClusterNotFoundFault(crate::error::DbClusterNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeDBClusterBacktracksError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeDBClusterBacktracksErrorKind::DbClusterBacktrackNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            DescribeDBClusterBacktracksErrorKind::DbClusterNotFoundFault(_inner) => _inner.fmt(f),
            DescribeDBClusterBacktracksErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeDBClusterBacktracksError {
    fn code(&self) -> Option<&str> {
        DescribeDBClusterBacktracksError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeDBClusterBacktracksError {
    /// Creates a new `DescribeDBClusterBacktracksError`.
    pub fn new(kind: DescribeDBClusterBacktracksErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeDBClusterBacktracksError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeDBClusterBacktracksErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeDBClusterBacktracksError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeDBClusterBacktracksErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeDBClusterBacktracksErrorKind::DbClusterBacktrackNotFoundFault`.
    pub fn is_db_cluster_backtrack_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDBClusterBacktracksErrorKind::DbClusterBacktrackNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDBClusterBacktracksErrorKind::DbClusterNotFoundFault`.
    pub fn is_db_cluster_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDBClusterBacktracksErrorKind::DbClusterNotFoundFault(_)
        )
    }
}
impl std::error::Error for DescribeDBClusterBacktracksError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeDBClusterBacktracksErrorKind::DbClusterBacktrackNotFoundFault(_inner) => {
                Some(_inner)
            }
            DescribeDBClusterBacktracksErrorKind::DbClusterNotFoundFault(_inner) => Some(_inner),
            DescribeDBClusterBacktracksErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeDBClusterEndpoints` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeDBClusterEndpointsError {
    /// Kind of error that occurred.
    pub kind: DescribeDBClusterEndpointsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeDBClusterEndpoints` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeDBClusterEndpointsErrorKind {
    /// <p> <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster. </p>
    DbClusterNotFoundFault(crate::error::DbClusterNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeDBClusterEndpointsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeDBClusterEndpointsErrorKind::DbClusterNotFoundFault(_inner) => _inner.fmt(f),
            DescribeDBClusterEndpointsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeDBClusterEndpointsError {
    fn code(&self) -> Option<&str> {
        DescribeDBClusterEndpointsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeDBClusterEndpointsError {
    /// Creates a new `DescribeDBClusterEndpointsError`.
    pub fn new(kind: DescribeDBClusterEndpointsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeDBClusterEndpointsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeDBClusterEndpointsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeDBClusterEndpointsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeDBClusterEndpointsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeDBClusterEndpointsErrorKind::DbClusterNotFoundFault`.
    pub fn is_db_cluster_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDBClusterEndpointsErrorKind::DbClusterNotFoundFault(_)
        )
    }
}
impl std::error::Error for DescribeDBClusterEndpointsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeDBClusterEndpointsErrorKind::DbClusterNotFoundFault(_inner) => Some(_inner),
            DescribeDBClusterEndpointsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeDBClusterParameterGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeDBClusterParameterGroupsError {
    /// Kind of error that occurred.
    pub kind: DescribeDBClusterParameterGroupsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeDBClusterParameterGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeDBClusterParameterGroupsErrorKind {
    /// <p> <code>DBParameterGroupName</code> doesn't refer to an existing DB parameter group. </p>
    DbParameterGroupNotFoundFault(crate::error::DbParameterGroupNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeDBClusterParameterGroupsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeDBClusterParameterGroupsErrorKind::DbParameterGroupNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            DescribeDBClusterParameterGroupsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeDBClusterParameterGroupsError {
    fn code(&self) -> Option<&str> {
        DescribeDBClusterParameterGroupsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeDBClusterParameterGroupsError {
    /// Creates a new `DescribeDBClusterParameterGroupsError`.
    pub fn new(
        kind: DescribeDBClusterParameterGroupsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeDBClusterParameterGroupsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeDBClusterParameterGroupsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeDBClusterParameterGroupsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeDBClusterParameterGroupsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeDBClusterParameterGroupsErrorKind::DbParameterGroupNotFoundFault`.
    pub fn is_db_parameter_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDBClusterParameterGroupsErrorKind::DbParameterGroupNotFoundFault(_)
        )
    }
}
impl std::error::Error for DescribeDBClusterParameterGroupsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeDBClusterParameterGroupsErrorKind::DbParameterGroupNotFoundFault(_inner) => {
                Some(_inner)
            }
            DescribeDBClusterParameterGroupsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeDBClusterParameters` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeDBClusterParametersError {
    /// Kind of error that occurred.
    pub kind: DescribeDBClusterParametersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeDBClusterParameters` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeDBClusterParametersErrorKind {
    /// <p> <code>DBParameterGroupName</code> doesn't refer to an existing DB parameter group. </p>
    DbParameterGroupNotFoundFault(crate::error::DbParameterGroupNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeDBClusterParametersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeDBClusterParametersErrorKind::DbParameterGroupNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            DescribeDBClusterParametersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeDBClusterParametersError {
    fn code(&self) -> Option<&str> {
        DescribeDBClusterParametersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeDBClusterParametersError {
    /// Creates a new `DescribeDBClusterParametersError`.
    pub fn new(kind: DescribeDBClusterParametersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeDBClusterParametersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeDBClusterParametersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeDBClusterParametersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeDBClusterParametersErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeDBClusterParametersErrorKind::DbParameterGroupNotFoundFault`.
    pub fn is_db_parameter_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDBClusterParametersErrorKind::DbParameterGroupNotFoundFault(_)
        )
    }
}
impl std::error::Error for DescribeDBClusterParametersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeDBClusterParametersErrorKind::DbParameterGroupNotFoundFault(_inner) => {
                Some(_inner)
            }
            DescribeDBClusterParametersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeDBClusters` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeDBClustersError {
    /// Kind of error that occurred.
    pub kind: DescribeDBClustersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeDBClusters` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeDBClustersErrorKind {
    /// <p> <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster. </p>
    DbClusterNotFoundFault(crate::error::DbClusterNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeDBClustersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeDBClustersErrorKind::DbClusterNotFoundFault(_inner) => _inner.fmt(f),
            DescribeDBClustersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeDBClustersError {
    fn code(&self) -> Option<&str> {
        DescribeDBClustersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeDBClustersError {
    /// Creates a new `DescribeDBClustersError`.
    pub fn new(kind: DescribeDBClustersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeDBClustersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeDBClustersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeDBClustersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeDBClustersErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeDBClustersErrorKind::DbClusterNotFoundFault`.
    pub fn is_db_cluster_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDBClustersErrorKind::DbClusterNotFoundFault(_)
        )
    }
}
impl std::error::Error for DescribeDBClustersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeDBClustersErrorKind::DbClusterNotFoundFault(_inner) => Some(_inner),
            DescribeDBClustersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeDBClusterSnapshotAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeDBClusterSnapshotAttributesError {
    /// Kind of error that occurred.
    pub kind: DescribeDBClusterSnapshotAttributesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeDBClusterSnapshotAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeDBClusterSnapshotAttributesErrorKind {
    /// <p> <code>DBClusterSnapshotIdentifier</code> doesn't refer to an existing DB cluster snapshot. </p>
    DbClusterSnapshotNotFoundFault(crate::error::DbClusterSnapshotNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeDBClusterSnapshotAttributesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeDBClusterSnapshotAttributesErrorKind::DbClusterSnapshotNotFoundFault(
                _inner,
            ) => _inner.fmt(f),
            DescribeDBClusterSnapshotAttributesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeDBClusterSnapshotAttributesError {
    fn code(&self) -> Option<&str> {
        DescribeDBClusterSnapshotAttributesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeDBClusterSnapshotAttributesError {
    /// Creates a new `DescribeDBClusterSnapshotAttributesError`.
    pub fn new(
        kind: DescribeDBClusterSnapshotAttributesErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeDBClusterSnapshotAttributesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeDBClusterSnapshotAttributesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeDBClusterSnapshotAttributesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeDBClusterSnapshotAttributesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeDBClusterSnapshotAttributesErrorKind::DbClusterSnapshotNotFoundFault`.
    pub fn is_db_cluster_snapshot_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDBClusterSnapshotAttributesErrorKind::DbClusterSnapshotNotFoundFault(_)
        )
    }
}
impl std::error::Error for DescribeDBClusterSnapshotAttributesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeDBClusterSnapshotAttributesErrorKind::DbClusterSnapshotNotFoundFault(
                _inner,
            ) => Some(_inner),
            DescribeDBClusterSnapshotAttributesErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DescribeDBClusterSnapshots` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeDBClusterSnapshotsError {
    /// Kind of error that occurred.
    pub kind: DescribeDBClusterSnapshotsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeDBClusterSnapshots` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeDBClusterSnapshotsErrorKind {
    /// <p> <code>DBClusterSnapshotIdentifier</code> doesn't refer to an existing DB cluster snapshot. </p>
    DbClusterSnapshotNotFoundFault(crate::error::DbClusterSnapshotNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeDBClusterSnapshotsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeDBClusterSnapshotsErrorKind::DbClusterSnapshotNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            DescribeDBClusterSnapshotsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeDBClusterSnapshotsError {
    fn code(&self) -> Option<&str> {
        DescribeDBClusterSnapshotsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeDBClusterSnapshotsError {
    /// Creates a new `DescribeDBClusterSnapshotsError`.
    pub fn new(kind: DescribeDBClusterSnapshotsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeDBClusterSnapshotsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeDBClusterSnapshotsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeDBClusterSnapshotsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeDBClusterSnapshotsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeDBClusterSnapshotsErrorKind::DbClusterSnapshotNotFoundFault`.
    pub fn is_db_cluster_snapshot_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDBClusterSnapshotsErrorKind::DbClusterSnapshotNotFoundFault(_)
        )
    }
}
impl std::error::Error for DescribeDBClusterSnapshotsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeDBClusterSnapshotsErrorKind::DbClusterSnapshotNotFoundFault(_inner) => {
                Some(_inner)
            }
            DescribeDBClusterSnapshotsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeDBEngineVersions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeDBEngineVersionsError {
    /// Kind of error that occurred.
    pub kind: DescribeDBEngineVersionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeDBEngineVersions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeDBEngineVersionsErrorKind {
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeDBEngineVersionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeDBEngineVersionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeDBEngineVersionsError {
    fn code(&self) -> Option<&str> {
        DescribeDBEngineVersionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeDBEngineVersionsError {
    /// Creates a new `DescribeDBEngineVersionsError`.
    pub fn new(kind: DescribeDBEngineVersionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeDBEngineVersionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeDBEngineVersionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeDBEngineVersionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeDBEngineVersionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for DescribeDBEngineVersionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeDBEngineVersionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeDBInstanceAutomatedBackups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeDBInstanceAutomatedBackupsError {
    /// Kind of error that occurred.
    pub kind: DescribeDBInstanceAutomatedBackupsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeDBInstanceAutomatedBackups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeDBInstanceAutomatedBackupsErrorKind {
    /// <p>No automated backup for this DB instance was found.</p>
    DbInstanceAutomatedBackupNotFoundFault(crate::error::DbInstanceAutomatedBackupNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeDBInstanceAutomatedBackupsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeDBInstanceAutomatedBackupsErrorKind::DbInstanceAutomatedBackupNotFoundFault(
                _inner,
            ) => _inner.fmt(f),
            DescribeDBInstanceAutomatedBackupsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeDBInstanceAutomatedBackupsError {
    fn code(&self) -> Option<&str> {
        DescribeDBInstanceAutomatedBackupsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeDBInstanceAutomatedBackupsError {
    /// Creates a new `DescribeDBInstanceAutomatedBackupsError`.
    pub fn new(
        kind: DescribeDBInstanceAutomatedBackupsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeDBInstanceAutomatedBackupsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeDBInstanceAutomatedBackupsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeDBInstanceAutomatedBackupsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeDBInstanceAutomatedBackupsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeDBInstanceAutomatedBackupsErrorKind::DbInstanceAutomatedBackupNotFoundFault`.
    pub fn is_db_instance_automated_backup_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDBInstanceAutomatedBackupsErrorKind::DbInstanceAutomatedBackupNotFoundFault(_)
        )
    }
}
impl std::error::Error for DescribeDBInstanceAutomatedBackupsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeDBInstanceAutomatedBackupsErrorKind::DbInstanceAutomatedBackupNotFoundFault(
                _inner,
            ) => Some(_inner),
            DescribeDBInstanceAutomatedBackupsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeDBInstances` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeDBInstancesError {
    /// Kind of error that occurred.
    pub kind: DescribeDBInstancesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeDBInstances` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeDBInstancesErrorKind {
    /// <p> <code>DBInstanceIdentifier</code> doesn't refer to an existing DB instance. </p>
    DbInstanceNotFoundFault(crate::error::DbInstanceNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeDBInstancesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeDBInstancesErrorKind::DbInstanceNotFoundFault(_inner) => _inner.fmt(f),
            DescribeDBInstancesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeDBInstancesError {
    fn code(&self) -> Option<&str> {
        DescribeDBInstancesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeDBInstancesError {
    /// Creates a new `DescribeDBInstancesError`.
    pub fn new(kind: DescribeDBInstancesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeDBInstancesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeDBInstancesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeDBInstancesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeDBInstancesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeDBInstancesErrorKind::DbInstanceNotFoundFault`.
    pub fn is_db_instance_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDBInstancesErrorKind::DbInstanceNotFoundFault(_)
        )
    }
}
impl std::error::Error for DescribeDBInstancesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeDBInstancesErrorKind::DbInstanceNotFoundFault(_inner) => Some(_inner),
            DescribeDBInstancesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeDBLogFiles` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeDBLogFilesError {
    /// Kind of error that occurred.
    pub kind: DescribeDBLogFilesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeDBLogFiles` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeDBLogFilesErrorKind {
    /// <p> <code>DBInstanceIdentifier</code> doesn't refer to an existing DB instance. </p>
    DbInstanceNotFoundFault(crate::error::DbInstanceNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeDBLogFilesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeDBLogFilesErrorKind::DbInstanceNotFoundFault(_inner) => _inner.fmt(f),
            DescribeDBLogFilesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeDBLogFilesError {
    fn code(&self) -> Option<&str> {
        DescribeDBLogFilesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeDBLogFilesError {
    /// Creates a new `DescribeDBLogFilesError`.
    pub fn new(kind: DescribeDBLogFilesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeDBLogFilesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeDBLogFilesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeDBLogFilesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeDBLogFilesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeDBLogFilesErrorKind::DbInstanceNotFoundFault`.
    pub fn is_db_instance_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDBLogFilesErrorKind::DbInstanceNotFoundFault(_)
        )
    }
}
impl std::error::Error for DescribeDBLogFilesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeDBLogFilesErrorKind::DbInstanceNotFoundFault(_inner) => Some(_inner),
            DescribeDBLogFilesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeDBParameterGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeDBParameterGroupsError {
    /// Kind of error that occurred.
    pub kind: DescribeDBParameterGroupsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeDBParameterGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeDBParameterGroupsErrorKind {
    /// <p> <code>DBParameterGroupName</code> doesn't refer to an existing DB parameter group. </p>
    DbParameterGroupNotFoundFault(crate::error::DbParameterGroupNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeDBParameterGroupsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeDBParameterGroupsErrorKind::DbParameterGroupNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            DescribeDBParameterGroupsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeDBParameterGroupsError {
    fn code(&self) -> Option<&str> {
        DescribeDBParameterGroupsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeDBParameterGroupsError {
    /// Creates a new `DescribeDBParameterGroupsError`.
    pub fn new(kind: DescribeDBParameterGroupsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeDBParameterGroupsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeDBParameterGroupsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeDBParameterGroupsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeDBParameterGroupsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeDBParameterGroupsErrorKind::DbParameterGroupNotFoundFault`.
    pub fn is_db_parameter_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDBParameterGroupsErrorKind::DbParameterGroupNotFoundFault(_)
        )
    }
}
impl std::error::Error for DescribeDBParameterGroupsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeDBParameterGroupsErrorKind::DbParameterGroupNotFoundFault(_inner) => {
                Some(_inner)
            }
            DescribeDBParameterGroupsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeDBParameters` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeDBParametersError {
    /// Kind of error that occurred.
    pub kind: DescribeDBParametersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeDBParameters` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeDBParametersErrorKind {
    /// <p> <code>DBParameterGroupName</code> doesn't refer to an existing DB parameter group. </p>
    DbParameterGroupNotFoundFault(crate::error::DbParameterGroupNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeDBParametersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeDBParametersErrorKind::DbParameterGroupNotFoundFault(_inner) => _inner.fmt(f),
            DescribeDBParametersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeDBParametersError {
    fn code(&self) -> Option<&str> {
        DescribeDBParametersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeDBParametersError {
    /// Creates a new `DescribeDBParametersError`.
    pub fn new(kind: DescribeDBParametersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeDBParametersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeDBParametersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeDBParametersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeDBParametersErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeDBParametersErrorKind::DbParameterGroupNotFoundFault`.
    pub fn is_db_parameter_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDBParametersErrorKind::DbParameterGroupNotFoundFault(_)
        )
    }
}
impl std::error::Error for DescribeDBParametersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeDBParametersErrorKind::DbParameterGroupNotFoundFault(_inner) => Some(_inner),
            DescribeDBParametersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeDBProxies` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeDBProxiesError {
    /// Kind of error that occurred.
    pub kind: DescribeDBProxiesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeDBProxies` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeDBProxiesErrorKind {
    /// <p>The specified proxy name doesn't correspond to a proxy owned by your Amazon Web Services account in the specified Amazon Web Services Region.</p>
    DbProxyNotFoundFault(crate::error::DbProxyNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeDBProxiesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeDBProxiesErrorKind::DbProxyNotFoundFault(_inner) => _inner.fmt(f),
            DescribeDBProxiesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeDBProxiesError {
    fn code(&self) -> Option<&str> {
        DescribeDBProxiesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeDBProxiesError {
    /// Creates a new `DescribeDBProxiesError`.
    pub fn new(kind: DescribeDBProxiesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeDBProxiesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeDBProxiesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeDBProxiesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeDBProxiesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeDBProxiesErrorKind::DbProxyNotFoundFault`.
    pub fn is_db_proxy_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDBProxiesErrorKind::DbProxyNotFoundFault(_)
        )
    }
}
impl std::error::Error for DescribeDBProxiesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeDBProxiesErrorKind::DbProxyNotFoundFault(_inner) => Some(_inner),
            DescribeDBProxiesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeDBProxyEndpoints` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeDBProxyEndpointsError {
    /// Kind of error that occurred.
    pub kind: DescribeDBProxyEndpointsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeDBProxyEndpoints` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeDBProxyEndpointsErrorKind {
    /// <p>The DB proxy endpoint doesn't exist.</p>
    DbProxyEndpointNotFoundFault(crate::error::DbProxyEndpointNotFoundFault),
    /// <p>The specified proxy name doesn't correspond to a proxy owned by your Amazon Web Services account in the specified Amazon Web Services Region.</p>
    DbProxyNotFoundFault(crate::error::DbProxyNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeDBProxyEndpointsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeDBProxyEndpointsErrorKind::DbProxyEndpointNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            DescribeDBProxyEndpointsErrorKind::DbProxyNotFoundFault(_inner) => _inner.fmt(f),
            DescribeDBProxyEndpointsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeDBProxyEndpointsError {
    fn code(&self) -> Option<&str> {
        DescribeDBProxyEndpointsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeDBProxyEndpointsError {
    /// Creates a new `DescribeDBProxyEndpointsError`.
    pub fn new(kind: DescribeDBProxyEndpointsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeDBProxyEndpointsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeDBProxyEndpointsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeDBProxyEndpointsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeDBProxyEndpointsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeDBProxyEndpointsErrorKind::DbProxyEndpointNotFoundFault`.
    pub fn is_db_proxy_endpoint_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDBProxyEndpointsErrorKind::DbProxyEndpointNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDBProxyEndpointsErrorKind::DbProxyNotFoundFault`.
    pub fn is_db_proxy_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDBProxyEndpointsErrorKind::DbProxyNotFoundFault(_)
        )
    }
}
impl std::error::Error for DescribeDBProxyEndpointsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeDBProxyEndpointsErrorKind::DbProxyEndpointNotFoundFault(_inner) => Some(_inner),
            DescribeDBProxyEndpointsErrorKind::DbProxyNotFoundFault(_inner) => Some(_inner),
            DescribeDBProxyEndpointsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeDBProxyTargetGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeDBProxyTargetGroupsError {
    /// Kind of error that occurred.
    pub kind: DescribeDBProxyTargetGroupsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeDBProxyTargetGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeDBProxyTargetGroupsErrorKind {
    /// <p>The specified proxy name doesn't correspond to a proxy owned by your Amazon Web Services account in the specified Amazon Web Services Region.</p>
    DbProxyNotFoundFault(crate::error::DbProxyNotFoundFault),
    /// <p>The specified target group isn't available for a proxy owned by your Amazon Web Services account in the specified Amazon Web Services Region.</p>
    DbProxyTargetGroupNotFoundFault(crate::error::DbProxyTargetGroupNotFoundFault),
    /// <p>The requested operation can't be performed while the proxy is in this state.</p>
    InvalidDbProxyStateFault(crate::error::InvalidDbProxyStateFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeDBProxyTargetGroupsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeDBProxyTargetGroupsErrorKind::DbProxyNotFoundFault(_inner) => _inner.fmt(f),
            DescribeDBProxyTargetGroupsErrorKind::DbProxyTargetGroupNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            DescribeDBProxyTargetGroupsErrorKind::InvalidDbProxyStateFault(_inner) => _inner.fmt(f),
            DescribeDBProxyTargetGroupsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeDBProxyTargetGroupsError {
    fn code(&self) -> Option<&str> {
        DescribeDBProxyTargetGroupsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeDBProxyTargetGroupsError {
    /// Creates a new `DescribeDBProxyTargetGroupsError`.
    pub fn new(kind: DescribeDBProxyTargetGroupsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeDBProxyTargetGroupsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeDBProxyTargetGroupsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeDBProxyTargetGroupsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeDBProxyTargetGroupsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeDBProxyTargetGroupsErrorKind::DbProxyNotFoundFault`.
    pub fn is_db_proxy_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDBProxyTargetGroupsErrorKind::DbProxyNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDBProxyTargetGroupsErrorKind::DbProxyTargetGroupNotFoundFault`.
    pub fn is_db_proxy_target_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDBProxyTargetGroupsErrorKind::DbProxyTargetGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDBProxyTargetGroupsErrorKind::InvalidDbProxyStateFault`.
    pub fn is_invalid_db_proxy_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDBProxyTargetGroupsErrorKind::InvalidDbProxyStateFault(_)
        )
    }
}
impl std::error::Error for DescribeDBProxyTargetGroupsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeDBProxyTargetGroupsErrorKind::DbProxyNotFoundFault(_inner) => Some(_inner),
            DescribeDBProxyTargetGroupsErrorKind::DbProxyTargetGroupNotFoundFault(_inner) => {
                Some(_inner)
            }
            DescribeDBProxyTargetGroupsErrorKind::InvalidDbProxyStateFault(_inner) => Some(_inner),
            DescribeDBProxyTargetGroupsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeDBProxyTargets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeDBProxyTargetsError {
    /// Kind of error that occurred.
    pub kind: DescribeDBProxyTargetsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeDBProxyTargets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeDBProxyTargetsErrorKind {
    /// <p>The specified proxy name doesn't correspond to a proxy owned by your Amazon Web Services account in the specified Amazon Web Services Region.</p>
    DbProxyNotFoundFault(crate::error::DbProxyNotFoundFault),
    /// <p>The specified target group isn't available for a proxy owned by your Amazon Web Services account in the specified Amazon Web Services Region.</p>
    DbProxyTargetGroupNotFoundFault(crate::error::DbProxyTargetGroupNotFoundFault),
    /// <p>The specified RDS DB instance or Aurora DB cluster isn't available for a proxy owned by your Amazon Web Services account in the specified Amazon Web Services Region.</p>
    DbProxyTargetNotFoundFault(crate::error::DbProxyTargetNotFoundFault),
    /// <p>The requested operation can't be performed while the proxy is in this state.</p>
    InvalidDbProxyStateFault(crate::error::InvalidDbProxyStateFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeDBProxyTargetsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeDBProxyTargetsErrorKind::DbProxyNotFoundFault(_inner) => _inner.fmt(f),
            DescribeDBProxyTargetsErrorKind::DbProxyTargetGroupNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            DescribeDBProxyTargetsErrorKind::DbProxyTargetNotFoundFault(_inner) => _inner.fmt(f),
            DescribeDBProxyTargetsErrorKind::InvalidDbProxyStateFault(_inner) => _inner.fmt(f),
            DescribeDBProxyTargetsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeDBProxyTargetsError {
    fn code(&self) -> Option<&str> {
        DescribeDBProxyTargetsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeDBProxyTargetsError {
    /// Creates a new `DescribeDBProxyTargetsError`.
    pub fn new(kind: DescribeDBProxyTargetsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeDBProxyTargetsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeDBProxyTargetsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeDBProxyTargetsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeDBProxyTargetsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeDBProxyTargetsErrorKind::DbProxyNotFoundFault`.
    pub fn is_db_proxy_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDBProxyTargetsErrorKind::DbProxyNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDBProxyTargetsErrorKind::DbProxyTargetGroupNotFoundFault`.
    pub fn is_db_proxy_target_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDBProxyTargetsErrorKind::DbProxyTargetGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDBProxyTargetsErrorKind::DbProxyTargetNotFoundFault`.
    pub fn is_db_proxy_target_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDBProxyTargetsErrorKind::DbProxyTargetNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDBProxyTargetsErrorKind::InvalidDbProxyStateFault`.
    pub fn is_invalid_db_proxy_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDBProxyTargetsErrorKind::InvalidDbProxyStateFault(_)
        )
    }
}
impl std::error::Error for DescribeDBProxyTargetsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeDBProxyTargetsErrorKind::DbProxyNotFoundFault(_inner) => Some(_inner),
            DescribeDBProxyTargetsErrorKind::DbProxyTargetGroupNotFoundFault(_inner) => {
                Some(_inner)
            }
            DescribeDBProxyTargetsErrorKind::DbProxyTargetNotFoundFault(_inner) => Some(_inner),
            DescribeDBProxyTargetsErrorKind::InvalidDbProxyStateFault(_inner) => Some(_inner),
            DescribeDBProxyTargetsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeDBSecurityGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeDBSecurityGroupsError {
    /// Kind of error that occurred.
    pub kind: DescribeDBSecurityGroupsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeDBSecurityGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeDBSecurityGroupsErrorKind {
    /// <p> <code>DBSecurityGroupName</code> doesn't refer to an existing DB security group. </p>
    DbSecurityGroupNotFoundFault(crate::error::DbSecurityGroupNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeDBSecurityGroupsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeDBSecurityGroupsErrorKind::DbSecurityGroupNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            DescribeDBSecurityGroupsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeDBSecurityGroupsError {
    fn code(&self) -> Option<&str> {
        DescribeDBSecurityGroupsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeDBSecurityGroupsError {
    /// Creates a new `DescribeDBSecurityGroupsError`.
    pub fn new(kind: DescribeDBSecurityGroupsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeDBSecurityGroupsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeDBSecurityGroupsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeDBSecurityGroupsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeDBSecurityGroupsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeDBSecurityGroupsErrorKind::DbSecurityGroupNotFoundFault`.
    pub fn is_db_security_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDBSecurityGroupsErrorKind::DbSecurityGroupNotFoundFault(_)
        )
    }
}
impl std::error::Error for DescribeDBSecurityGroupsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeDBSecurityGroupsErrorKind::DbSecurityGroupNotFoundFault(_inner) => Some(_inner),
            DescribeDBSecurityGroupsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeDBSnapshotAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeDBSnapshotAttributesError {
    /// Kind of error that occurred.
    pub kind: DescribeDBSnapshotAttributesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeDBSnapshotAttributes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeDBSnapshotAttributesErrorKind {
    /// <p> <code>DBSnapshotIdentifier</code> doesn't refer to an existing DB snapshot. </p>
    DbSnapshotNotFoundFault(crate::error::DbSnapshotNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeDBSnapshotAttributesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeDBSnapshotAttributesErrorKind::DbSnapshotNotFoundFault(_inner) => _inner.fmt(f),
            DescribeDBSnapshotAttributesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeDBSnapshotAttributesError {
    fn code(&self) -> Option<&str> {
        DescribeDBSnapshotAttributesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeDBSnapshotAttributesError {
    /// Creates a new `DescribeDBSnapshotAttributesError`.
    pub fn new(kind: DescribeDBSnapshotAttributesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeDBSnapshotAttributesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeDBSnapshotAttributesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeDBSnapshotAttributesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeDBSnapshotAttributesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeDBSnapshotAttributesErrorKind::DbSnapshotNotFoundFault`.
    pub fn is_db_snapshot_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDBSnapshotAttributesErrorKind::DbSnapshotNotFoundFault(_)
        )
    }
}
impl std::error::Error for DescribeDBSnapshotAttributesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeDBSnapshotAttributesErrorKind::DbSnapshotNotFoundFault(_inner) => Some(_inner),
            DescribeDBSnapshotAttributesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeDBSnapshots` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeDBSnapshotsError {
    /// Kind of error that occurred.
    pub kind: DescribeDBSnapshotsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeDBSnapshots` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeDBSnapshotsErrorKind {
    /// <p> <code>DBSnapshotIdentifier</code> doesn't refer to an existing DB snapshot. </p>
    DbSnapshotNotFoundFault(crate::error::DbSnapshotNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeDBSnapshotsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeDBSnapshotsErrorKind::DbSnapshotNotFoundFault(_inner) => _inner.fmt(f),
            DescribeDBSnapshotsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeDBSnapshotsError {
    fn code(&self) -> Option<&str> {
        DescribeDBSnapshotsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeDBSnapshotsError {
    /// Creates a new `DescribeDBSnapshotsError`.
    pub fn new(kind: DescribeDBSnapshotsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeDBSnapshotsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeDBSnapshotsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeDBSnapshotsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeDBSnapshotsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeDBSnapshotsErrorKind::DbSnapshotNotFoundFault`.
    pub fn is_db_snapshot_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDBSnapshotsErrorKind::DbSnapshotNotFoundFault(_)
        )
    }
}
impl std::error::Error for DescribeDBSnapshotsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeDBSnapshotsErrorKind::DbSnapshotNotFoundFault(_inner) => Some(_inner),
            DescribeDBSnapshotsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeDBSubnetGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeDBSubnetGroupsError {
    /// Kind of error that occurred.
    pub kind: DescribeDBSubnetGroupsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeDBSubnetGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeDBSubnetGroupsErrorKind {
    /// <p> <code>DBSubnetGroupName</code> doesn't refer to an existing DB subnet group. </p>
    DbSubnetGroupNotFoundFault(crate::error::DbSubnetGroupNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeDBSubnetGroupsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeDBSubnetGroupsErrorKind::DbSubnetGroupNotFoundFault(_inner) => _inner.fmt(f),
            DescribeDBSubnetGroupsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeDBSubnetGroupsError {
    fn code(&self) -> Option<&str> {
        DescribeDBSubnetGroupsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeDBSubnetGroupsError {
    /// Creates a new `DescribeDBSubnetGroupsError`.
    pub fn new(kind: DescribeDBSubnetGroupsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeDBSubnetGroupsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeDBSubnetGroupsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeDBSubnetGroupsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeDBSubnetGroupsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeDBSubnetGroupsErrorKind::DbSubnetGroupNotFoundFault`.
    pub fn is_db_subnet_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDBSubnetGroupsErrorKind::DbSubnetGroupNotFoundFault(_)
        )
    }
}
impl std::error::Error for DescribeDBSubnetGroupsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeDBSubnetGroupsErrorKind::DbSubnetGroupNotFoundFault(_inner) => Some(_inner),
            DescribeDBSubnetGroupsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeEngineDefaultClusterParameters` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeEngineDefaultClusterParametersError {
    /// Kind of error that occurred.
    pub kind: DescribeEngineDefaultClusterParametersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeEngineDefaultClusterParameters` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeEngineDefaultClusterParametersErrorKind {
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeEngineDefaultClusterParametersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeEngineDefaultClusterParametersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeEngineDefaultClusterParametersError {
    fn code(&self) -> Option<&str> {
        DescribeEngineDefaultClusterParametersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeEngineDefaultClusterParametersError {
    /// Creates a new `DescribeEngineDefaultClusterParametersError`.
    pub fn new(
        kind: DescribeEngineDefaultClusterParametersErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeEngineDefaultClusterParametersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeEngineDefaultClusterParametersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeEngineDefaultClusterParametersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeEngineDefaultClusterParametersErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for DescribeEngineDefaultClusterParametersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeEngineDefaultClusterParametersErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DescribeEngineDefaultParameters` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeEngineDefaultParametersError {
    /// Kind of error that occurred.
    pub kind: DescribeEngineDefaultParametersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeEngineDefaultParameters` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeEngineDefaultParametersErrorKind {
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeEngineDefaultParametersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeEngineDefaultParametersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeEngineDefaultParametersError {
    fn code(&self) -> Option<&str> {
        DescribeEngineDefaultParametersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeEngineDefaultParametersError {
    /// Creates a new `DescribeEngineDefaultParametersError`.
    pub fn new(
        kind: DescribeEngineDefaultParametersErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeEngineDefaultParametersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeEngineDefaultParametersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeEngineDefaultParametersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeEngineDefaultParametersErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for DescribeEngineDefaultParametersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeEngineDefaultParametersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeEventCategories` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeEventCategoriesError {
    /// Kind of error that occurred.
    pub kind: DescribeEventCategoriesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeEventCategories` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeEventCategoriesErrorKind {
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeEventCategoriesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeEventCategoriesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeEventCategoriesError {
    fn code(&self) -> Option<&str> {
        DescribeEventCategoriesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeEventCategoriesError {
    /// Creates a new `DescribeEventCategoriesError`.
    pub fn new(kind: DescribeEventCategoriesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeEventCategoriesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeEventCategoriesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeEventCategoriesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeEventCategoriesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for DescribeEventCategoriesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeEventCategoriesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeEvents` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeEventsError {
    /// Kind of error that occurred.
    pub kind: DescribeEventsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeEvents` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeEventsErrorKind {
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeEventsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeEventsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeEventsError {
    fn code(&self) -> Option<&str> {
        DescribeEventsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeEventsError {
    /// Creates a new `DescribeEventsError`.
    pub fn new(kind: DescribeEventsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeEventsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeEventsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeEventsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeEventsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for DescribeEventsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeEventsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeEventSubscriptions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeEventSubscriptionsError {
    /// Kind of error that occurred.
    pub kind: DescribeEventSubscriptionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeEventSubscriptions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeEventSubscriptionsErrorKind {
    /// <p>The subscription name does not exist.</p>
    SubscriptionNotFoundFault(crate::error::SubscriptionNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeEventSubscriptionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeEventSubscriptionsErrorKind::SubscriptionNotFoundFault(_inner) => _inner.fmt(f),
            DescribeEventSubscriptionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeEventSubscriptionsError {
    fn code(&self) -> Option<&str> {
        DescribeEventSubscriptionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeEventSubscriptionsError {
    /// Creates a new `DescribeEventSubscriptionsError`.
    pub fn new(kind: DescribeEventSubscriptionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeEventSubscriptionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeEventSubscriptionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeEventSubscriptionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeEventSubscriptionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeEventSubscriptionsErrorKind::SubscriptionNotFoundFault`.
    pub fn is_subscription_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEventSubscriptionsErrorKind::SubscriptionNotFoundFault(_)
        )
    }
}
impl std::error::Error for DescribeEventSubscriptionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeEventSubscriptionsErrorKind::SubscriptionNotFoundFault(_inner) => Some(_inner),
            DescribeEventSubscriptionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeExportTasks` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeExportTasksError {
    /// Kind of error that occurred.
    pub kind: DescribeExportTasksErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeExportTasks` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeExportTasksErrorKind {
    /// <p>The export task doesn't exist.</p>
    ExportTaskNotFoundFault(crate::error::ExportTaskNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeExportTasksError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeExportTasksErrorKind::ExportTaskNotFoundFault(_inner) => _inner.fmt(f),
            DescribeExportTasksErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeExportTasksError {
    fn code(&self) -> Option<&str> {
        DescribeExportTasksError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeExportTasksError {
    /// Creates a new `DescribeExportTasksError`.
    pub fn new(kind: DescribeExportTasksErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeExportTasksError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeExportTasksErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeExportTasksError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeExportTasksErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeExportTasksErrorKind::ExportTaskNotFoundFault`.
    pub fn is_export_task_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeExportTasksErrorKind::ExportTaskNotFoundFault(_)
        )
    }
}
impl std::error::Error for DescribeExportTasksError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeExportTasksErrorKind::ExportTaskNotFoundFault(_inner) => Some(_inner),
            DescribeExportTasksErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeGlobalClusters` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeGlobalClustersError {
    /// Kind of error that occurred.
    pub kind: DescribeGlobalClustersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeGlobalClusters` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeGlobalClustersErrorKind {
    /// <p>The <code>GlobalClusterIdentifier</code> doesn't refer to an existing global database cluster. </p>
    GlobalClusterNotFoundFault(crate::error::GlobalClusterNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeGlobalClustersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeGlobalClustersErrorKind::GlobalClusterNotFoundFault(_inner) => _inner.fmt(f),
            DescribeGlobalClustersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeGlobalClustersError {
    fn code(&self) -> Option<&str> {
        DescribeGlobalClustersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeGlobalClustersError {
    /// Creates a new `DescribeGlobalClustersError`.
    pub fn new(kind: DescribeGlobalClustersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeGlobalClustersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeGlobalClustersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeGlobalClustersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeGlobalClustersErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeGlobalClustersErrorKind::GlobalClusterNotFoundFault`.
    pub fn is_global_cluster_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeGlobalClustersErrorKind::GlobalClusterNotFoundFault(_)
        )
    }
}
impl std::error::Error for DescribeGlobalClustersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeGlobalClustersErrorKind::GlobalClusterNotFoundFault(_inner) => Some(_inner),
            DescribeGlobalClustersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeInstallationMedia` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeInstallationMediaError {
    /// Kind of error that occurred.
    pub kind: DescribeInstallationMediaErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeInstallationMedia` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeInstallationMediaErrorKind {
    /// <p> <code>InstallationMediaID</code> doesn't refer to an existing installation medium.</p>
    InstallationMediaNotFoundFault(crate::error::InstallationMediaNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeInstallationMediaError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeInstallationMediaErrorKind::InstallationMediaNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            DescribeInstallationMediaErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeInstallationMediaError {
    fn code(&self) -> Option<&str> {
        DescribeInstallationMediaError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeInstallationMediaError {
    /// Creates a new `DescribeInstallationMediaError`.
    pub fn new(kind: DescribeInstallationMediaErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeInstallationMediaError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeInstallationMediaErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeInstallationMediaError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeInstallationMediaErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeInstallationMediaErrorKind::InstallationMediaNotFoundFault`.
    pub fn is_installation_media_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeInstallationMediaErrorKind::InstallationMediaNotFoundFault(_)
        )
    }
}
impl std::error::Error for DescribeInstallationMediaError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeInstallationMediaErrorKind::InstallationMediaNotFoundFault(_inner) => {
                Some(_inner)
            }
            DescribeInstallationMediaErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeOptionGroupOptions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeOptionGroupOptionsError {
    /// Kind of error that occurred.
    pub kind: DescribeOptionGroupOptionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeOptionGroupOptions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeOptionGroupOptionsErrorKind {
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeOptionGroupOptionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeOptionGroupOptionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeOptionGroupOptionsError {
    fn code(&self) -> Option<&str> {
        DescribeOptionGroupOptionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeOptionGroupOptionsError {
    /// Creates a new `DescribeOptionGroupOptionsError`.
    pub fn new(kind: DescribeOptionGroupOptionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeOptionGroupOptionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeOptionGroupOptionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeOptionGroupOptionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeOptionGroupOptionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for DescribeOptionGroupOptionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeOptionGroupOptionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeOptionGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeOptionGroupsError {
    /// Kind of error that occurred.
    pub kind: DescribeOptionGroupsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeOptionGroups` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeOptionGroupsErrorKind {
    /// <p>The specified option group could not be found.</p>
    OptionGroupNotFoundFault(crate::error::OptionGroupNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeOptionGroupsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeOptionGroupsErrorKind::OptionGroupNotFoundFault(_inner) => _inner.fmt(f),
            DescribeOptionGroupsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeOptionGroupsError {
    fn code(&self) -> Option<&str> {
        DescribeOptionGroupsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeOptionGroupsError {
    /// Creates a new `DescribeOptionGroupsError`.
    pub fn new(kind: DescribeOptionGroupsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeOptionGroupsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeOptionGroupsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeOptionGroupsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeOptionGroupsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeOptionGroupsErrorKind::OptionGroupNotFoundFault`.
    pub fn is_option_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeOptionGroupsErrorKind::OptionGroupNotFoundFault(_)
        )
    }
}
impl std::error::Error for DescribeOptionGroupsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeOptionGroupsErrorKind::OptionGroupNotFoundFault(_inner) => Some(_inner),
            DescribeOptionGroupsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeOrderableDBInstanceOptions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeOrderableDBInstanceOptionsError {
    /// Kind of error that occurred.
    pub kind: DescribeOrderableDBInstanceOptionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeOrderableDBInstanceOptions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeOrderableDBInstanceOptionsErrorKind {
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeOrderableDBInstanceOptionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeOrderableDBInstanceOptionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeOrderableDBInstanceOptionsError {
    fn code(&self) -> Option<&str> {
        DescribeOrderableDBInstanceOptionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeOrderableDBInstanceOptionsError {
    /// Creates a new `DescribeOrderableDBInstanceOptionsError`.
    pub fn new(
        kind: DescribeOrderableDBInstanceOptionsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeOrderableDBInstanceOptionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeOrderableDBInstanceOptionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeOrderableDBInstanceOptionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeOrderableDBInstanceOptionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for DescribeOrderableDBInstanceOptionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeOrderableDBInstanceOptionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribePendingMaintenanceActions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribePendingMaintenanceActionsError {
    /// Kind of error that occurred.
    pub kind: DescribePendingMaintenanceActionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribePendingMaintenanceActions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribePendingMaintenanceActionsErrorKind {
    /// <p>The specified resource ID was not found.</p>
    ResourceNotFoundFault(crate::error::ResourceNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribePendingMaintenanceActionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribePendingMaintenanceActionsErrorKind::ResourceNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            DescribePendingMaintenanceActionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribePendingMaintenanceActionsError {
    fn code(&self) -> Option<&str> {
        DescribePendingMaintenanceActionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribePendingMaintenanceActionsError {
    /// Creates a new `DescribePendingMaintenanceActionsError`.
    pub fn new(
        kind: DescribePendingMaintenanceActionsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribePendingMaintenanceActionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribePendingMaintenanceActionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribePendingMaintenanceActionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribePendingMaintenanceActionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribePendingMaintenanceActionsErrorKind::ResourceNotFoundFault`.
    pub fn is_resource_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribePendingMaintenanceActionsErrorKind::ResourceNotFoundFault(_)
        )
    }
}
impl std::error::Error for DescribePendingMaintenanceActionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribePendingMaintenanceActionsErrorKind::ResourceNotFoundFault(_inner) => {
                Some(_inner)
            }
            DescribePendingMaintenanceActionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeReservedDBInstances` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeReservedDBInstancesError {
    /// Kind of error that occurred.
    pub kind: DescribeReservedDBInstancesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeReservedDBInstances` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeReservedDBInstancesErrorKind {
    /// <p>The specified reserved DB Instance not found.</p>
    ReservedDbInstanceNotFoundFault(crate::error::ReservedDbInstanceNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeReservedDBInstancesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeReservedDBInstancesErrorKind::ReservedDbInstanceNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            DescribeReservedDBInstancesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeReservedDBInstancesError {
    fn code(&self) -> Option<&str> {
        DescribeReservedDBInstancesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeReservedDBInstancesError {
    /// Creates a new `DescribeReservedDBInstancesError`.
    pub fn new(kind: DescribeReservedDBInstancesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeReservedDBInstancesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeReservedDBInstancesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeReservedDBInstancesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeReservedDBInstancesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeReservedDBInstancesErrorKind::ReservedDbInstanceNotFoundFault`.
    pub fn is_reserved_db_instance_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeReservedDBInstancesErrorKind::ReservedDbInstanceNotFoundFault(_)
        )
    }
}
impl std::error::Error for DescribeReservedDBInstancesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeReservedDBInstancesErrorKind::ReservedDbInstanceNotFoundFault(_inner) => {
                Some(_inner)
            }
            DescribeReservedDBInstancesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeReservedDBInstancesOfferings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeReservedDBInstancesOfferingsError {
    /// Kind of error that occurred.
    pub kind: DescribeReservedDBInstancesOfferingsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeReservedDBInstancesOfferings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeReservedDBInstancesOfferingsErrorKind {
    /// <p>Specified offering does not exist.</p>
    ReservedDbInstancesOfferingNotFoundFault(
        crate::error::ReservedDbInstancesOfferingNotFoundFault,
    ),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeReservedDBInstancesOfferingsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeReservedDBInstancesOfferingsErrorKind::ReservedDbInstancesOfferingNotFoundFault(_inner) =>
            _inner.fmt(f)
            ,
            DescribeReservedDBInstancesOfferingsErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeReservedDBInstancesOfferingsError {
    fn code(&self) -> Option<&str> {
        DescribeReservedDBInstancesOfferingsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeReservedDBInstancesOfferingsError {
    /// Creates a new `DescribeReservedDBInstancesOfferingsError`.
    pub fn new(
        kind: DescribeReservedDBInstancesOfferingsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeReservedDBInstancesOfferingsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeReservedDBInstancesOfferingsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeReservedDBInstancesOfferingsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeReservedDBInstancesOfferingsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeReservedDBInstancesOfferingsErrorKind::ReservedDbInstancesOfferingNotFoundFault`.
    pub fn is_reserved_db_instances_offering_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeReservedDBInstancesOfferingsErrorKind::ReservedDbInstancesOfferingNotFoundFault(
                _
            )
        )
    }
}
impl std::error::Error for DescribeReservedDBInstancesOfferingsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeReservedDBInstancesOfferingsErrorKind::ReservedDbInstancesOfferingNotFoundFault(_inner) =>
            Some(_inner)
            ,
            DescribeReservedDBInstancesOfferingsErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DescribeSourceRegions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeSourceRegionsError {
    /// Kind of error that occurred.
    pub kind: DescribeSourceRegionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeSourceRegions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeSourceRegionsErrorKind {
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeSourceRegionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeSourceRegionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeSourceRegionsError {
    fn code(&self) -> Option<&str> {
        DescribeSourceRegionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeSourceRegionsError {
    /// Creates a new `DescribeSourceRegionsError`.
    pub fn new(kind: DescribeSourceRegionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeSourceRegionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeSourceRegionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeSourceRegionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeSourceRegionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for DescribeSourceRegionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeSourceRegionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeValidDBInstanceModifications` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeValidDBInstanceModificationsError {
    /// Kind of error that occurred.
    pub kind: DescribeValidDBInstanceModificationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeValidDBInstanceModifications` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeValidDBInstanceModificationsErrorKind {
    /// <p> <code>DBInstanceIdentifier</code> doesn't refer to an existing DB instance. </p>
    DbInstanceNotFoundFault(crate::error::DbInstanceNotFoundFault),
    /// <p>The DB instance isn't in a valid state.</p>
    InvalidDbInstanceStateFault(crate::error::InvalidDbInstanceStateFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeValidDBInstanceModificationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeValidDBInstanceModificationsErrorKind::DbInstanceNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            DescribeValidDBInstanceModificationsErrorKind::InvalidDbInstanceStateFault(_inner) => {
                _inner.fmt(f)
            }
            DescribeValidDBInstanceModificationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeValidDBInstanceModificationsError {
    fn code(&self) -> Option<&str> {
        DescribeValidDBInstanceModificationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeValidDBInstanceModificationsError {
    /// Creates a new `DescribeValidDBInstanceModificationsError`.
    pub fn new(
        kind: DescribeValidDBInstanceModificationsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeValidDBInstanceModificationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeValidDBInstanceModificationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeValidDBInstanceModificationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeValidDBInstanceModificationsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeValidDBInstanceModificationsErrorKind::DbInstanceNotFoundFault`.
    pub fn is_db_instance_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeValidDBInstanceModificationsErrorKind::DbInstanceNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeValidDBInstanceModificationsErrorKind::InvalidDbInstanceStateFault`.
    pub fn is_invalid_db_instance_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            DescribeValidDBInstanceModificationsErrorKind::InvalidDbInstanceStateFault(_)
        )
    }
}
impl std::error::Error for DescribeValidDBInstanceModificationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeValidDBInstanceModificationsErrorKind::DbInstanceNotFoundFault(_inner) => {
                Some(_inner)
            }
            DescribeValidDBInstanceModificationsErrorKind::InvalidDbInstanceStateFault(_inner) => {
                Some(_inner)
            }
            DescribeValidDBInstanceModificationsErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DownloadDBLogFilePortion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DownloadDBLogFilePortionError {
    /// Kind of error that occurred.
    pub kind: DownloadDBLogFilePortionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DownloadDBLogFilePortion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DownloadDBLogFilePortionErrorKind {
    /// <p> <code>DBInstanceIdentifier</code> doesn't refer to an existing DB instance. </p>
    DbInstanceNotFoundFault(crate::error::DbInstanceNotFoundFault),
    /// <p> <code>LogFileName</code> doesn't refer to an existing DB log file.</p>
    DbLogFileNotFoundFault(crate::error::DbLogFileNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DownloadDBLogFilePortionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DownloadDBLogFilePortionErrorKind::DbInstanceNotFoundFault(_inner) => _inner.fmt(f),
            DownloadDBLogFilePortionErrorKind::DbLogFileNotFoundFault(_inner) => _inner.fmt(f),
            DownloadDBLogFilePortionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DownloadDBLogFilePortionError {
    fn code(&self) -> Option<&str> {
        DownloadDBLogFilePortionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DownloadDBLogFilePortionError {
    /// Creates a new `DownloadDBLogFilePortionError`.
    pub fn new(kind: DownloadDBLogFilePortionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DownloadDBLogFilePortionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DownloadDBLogFilePortionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DownloadDBLogFilePortionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DownloadDBLogFilePortionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DownloadDBLogFilePortionErrorKind::DbInstanceNotFoundFault`.
    pub fn is_db_instance_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DownloadDBLogFilePortionErrorKind::DbInstanceNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `DownloadDBLogFilePortionErrorKind::DbLogFileNotFoundFault`.
    pub fn is_db_log_file_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            DownloadDBLogFilePortionErrorKind::DbLogFileNotFoundFault(_)
        )
    }
}
impl std::error::Error for DownloadDBLogFilePortionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DownloadDBLogFilePortionErrorKind::DbInstanceNotFoundFault(_inner) => Some(_inner),
            DownloadDBLogFilePortionErrorKind::DbLogFileNotFoundFault(_inner) => Some(_inner),
            DownloadDBLogFilePortionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `FailoverDBCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct FailoverDBClusterError {
    /// Kind of error that occurred.
    pub kind: FailoverDBClusterErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `FailoverDBCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum FailoverDBClusterErrorKind {
    /// <p> <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster. </p>
    DbClusterNotFoundFault(crate::error::DbClusterNotFoundFault),
    /// <p>The requested operation can't be performed while the cluster is in this state.</p>
    InvalidDbClusterStateFault(crate::error::InvalidDbClusterStateFault),
    /// <p>The DB instance isn't in a valid state.</p>
    InvalidDbInstanceStateFault(crate::error::InvalidDbInstanceStateFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for FailoverDBClusterError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            FailoverDBClusterErrorKind::DbClusterNotFoundFault(_inner) => _inner.fmt(f),
            FailoverDBClusterErrorKind::InvalidDbClusterStateFault(_inner) => _inner.fmt(f),
            FailoverDBClusterErrorKind::InvalidDbInstanceStateFault(_inner) => _inner.fmt(f),
            FailoverDBClusterErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for FailoverDBClusterError {
    fn code(&self) -> Option<&str> {
        FailoverDBClusterError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl FailoverDBClusterError {
    /// Creates a new `FailoverDBClusterError`.
    pub fn new(kind: FailoverDBClusterErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `FailoverDBClusterError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: FailoverDBClusterErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `FailoverDBClusterError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: FailoverDBClusterErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `FailoverDBClusterErrorKind::DbClusterNotFoundFault`.
    pub fn is_db_cluster_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            FailoverDBClusterErrorKind::DbClusterNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `FailoverDBClusterErrorKind::InvalidDbClusterStateFault`.
    pub fn is_invalid_db_cluster_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            FailoverDBClusterErrorKind::InvalidDbClusterStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `FailoverDBClusterErrorKind::InvalidDbInstanceStateFault`.
    pub fn is_invalid_db_instance_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            FailoverDBClusterErrorKind::InvalidDbInstanceStateFault(_)
        )
    }
}
impl std::error::Error for FailoverDBClusterError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            FailoverDBClusterErrorKind::DbClusterNotFoundFault(_inner) => Some(_inner),
            FailoverDBClusterErrorKind::InvalidDbClusterStateFault(_inner) => Some(_inner),
            FailoverDBClusterErrorKind::InvalidDbInstanceStateFault(_inner) => Some(_inner),
            FailoverDBClusterErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `FailoverGlobalCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct FailoverGlobalClusterError {
    /// Kind of error that occurred.
    pub kind: FailoverGlobalClusterErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `FailoverGlobalCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum FailoverGlobalClusterErrorKind {
    /// <p> <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster. </p>
    DbClusterNotFoundFault(crate::error::DbClusterNotFoundFault),
    /// <p>The <code>GlobalClusterIdentifier</code> doesn't refer to an existing global database cluster. </p>
    GlobalClusterNotFoundFault(crate::error::GlobalClusterNotFoundFault),
    /// <p>The requested operation can't be performed while the cluster is in this state.</p>
    InvalidDbClusterStateFault(crate::error::InvalidDbClusterStateFault),
    /// <p>The global cluster is in an invalid state and can't perform the requested operation. </p>
    InvalidGlobalClusterStateFault(crate::error::InvalidGlobalClusterStateFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for FailoverGlobalClusterError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            FailoverGlobalClusterErrorKind::DbClusterNotFoundFault(_inner) => _inner.fmt(f),
            FailoverGlobalClusterErrorKind::GlobalClusterNotFoundFault(_inner) => _inner.fmt(f),
            FailoverGlobalClusterErrorKind::InvalidDbClusterStateFault(_inner) => _inner.fmt(f),
            FailoverGlobalClusterErrorKind::InvalidGlobalClusterStateFault(_inner) => _inner.fmt(f),
            FailoverGlobalClusterErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for FailoverGlobalClusterError {
    fn code(&self) -> Option<&str> {
        FailoverGlobalClusterError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl FailoverGlobalClusterError {
    /// Creates a new `FailoverGlobalClusterError`.
    pub fn new(kind: FailoverGlobalClusterErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `FailoverGlobalClusterError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: FailoverGlobalClusterErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `FailoverGlobalClusterError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: FailoverGlobalClusterErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `FailoverGlobalClusterErrorKind::DbClusterNotFoundFault`.
    pub fn is_db_cluster_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            FailoverGlobalClusterErrorKind::DbClusterNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `FailoverGlobalClusterErrorKind::GlobalClusterNotFoundFault`.
    pub fn is_global_cluster_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            FailoverGlobalClusterErrorKind::GlobalClusterNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `FailoverGlobalClusterErrorKind::InvalidDbClusterStateFault`.
    pub fn is_invalid_db_cluster_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            FailoverGlobalClusterErrorKind::InvalidDbClusterStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `FailoverGlobalClusterErrorKind::InvalidGlobalClusterStateFault`.
    pub fn is_invalid_global_cluster_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            FailoverGlobalClusterErrorKind::InvalidGlobalClusterStateFault(_)
        )
    }
}
impl std::error::Error for FailoverGlobalClusterError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            FailoverGlobalClusterErrorKind::DbClusterNotFoundFault(_inner) => Some(_inner),
            FailoverGlobalClusterErrorKind::GlobalClusterNotFoundFault(_inner) => Some(_inner),
            FailoverGlobalClusterErrorKind::InvalidDbClusterStateFault(_inner) => Some(_inner),
            FailoverGlobalClusterErrorKind::InvalidGlobalClusterStateFault(_inner) => Some(_inner),
            FailoverGlobalClusterErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ImportInstallationMedia` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ImportInstallationMediaError {
    /// Kind of error that occurred.
    pub kind: ImportInstallationMediaErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ImportInstallationMedia` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ImportInstallationMediaErrorKind {
    /// <p> <code>CustomAvailabilityZoneId</code> doesn't refer to an existing custom Availability Zone identifier.</p>
    CustomAvailabilityZoneNotFoundFault(crate::error::CustomAvailabilityZoneNotFoundFault),
    /// <p>The specified installation medium has already been imported.</p>
    InstallationMediaAlreadyExistsFault(crate::error::InstallationMediaAlreadyExistsFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ImportInstallationMediaError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ImportInstallationMediaErrorKind::CustomAvailabilityZoneNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            ImportInstallationMediaErrorKind::InstallationMediaAlreadyExistsFault(_inner) => {
                _inner.fmt(f)
            }
            ImportInstallationMediaErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ImportInstallationMediaError {
    fn code(&self) -> Option<&str> {
        ImportInstallationMediaError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ImportInstallationMediaError {
    /// Creates a new `ImportInstallationMediaError`.
    pub fn new(kind: ImportInstallationMediaErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ImportInstallationMediaError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ImportInstallationMediaErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ImportInstallationMediaError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ImportInstallationMediaErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ImportInstallationMediaErrorKind::CustomAvailabilityZoneNotFoundFault`.
    pub fn is_custom_availability_zone_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            ImportInstallationMediaErrorKind::CustomAvailabilityZoneNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `ImportInstallationMediaErrorKind::InstallationMediaAlreadyExistsFault`.
    pub fn is_installation_media_already_exists_fault(&self) -> bool {
        matches!(
            &self.kind,
            ImportInstallationMediaErrorKind::InstallationMediaAlreadyExistsFault(_)
        )
    }
}
impl std::error::Error for ImportInstallationMediaError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ImportInstallationMediaErrorKind::CustomAvailabilityZoneNotFoundFault(_inner) => {
                Some(_inner)
            }
            ImportInstallationMediaErrorKind::InstallationMediaAlreadyExistsFault(_inner) => {
                Some(_inner)
            }
            ImportInstallationMediaErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// <p> <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster. </p>
    DbClusterNotFoundFault(crate::error::DbClusterNotFoundFault),
    /// <p> <code>DBInstanceIdentifier</code> doesn't refer to an existing DB instance. </p>
    DbInstanceNotFoundFault(crate::error::DbInstanceNotFoundFault),
    /// <p>The specified proxy name doesn't correspond to a proxy owned by your Amazon Web Services account in the specified Amazon Web Services Region.</p>
    DbProxyNotFoundFault(crate::error::DbProxyNotFoundFault),
    /// <p>The specified target group isn't available for a proxy owned by your Amazon Web Services account in the specified Amazon Web Services Region.</p>
    DbProxyTargetGroupNotFoundFault(crate::error::DbProxyTargetGroupNotFoundFault),
    /// <p> <code>DBSnapshotIdentifier</code> doesn't refer to an existing DB snapshot. </p>
    DbSnapshotNotFoundFault(crate::error::DbSnapshotNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::DbClusterNotFoundFault(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::DbInstanceNotFoundFault(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::DbProxyNotFoundFault(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::DbProxyTargetGroupNotFoundFault(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::DbSnapshotNotFoundFault(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::DbClusterNotFoundFault`.
    pub fn is_db_cluster_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::DbClusterNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::DbInstanceNotFoundFault`.
    pub fn is_db_instance_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::DbInstanceNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::DbProxyNotFoundFault`.
    pub fn is_db_proxy_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::DbProxyNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::DbProxyTargetGroupNotFoundFault`.
    pub fn is_db_proxy_target_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::DbProxyTargetGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::DbSnapshotNotFoundFault`.
    pub fn is_db_snapshot_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::DbSnapshotNotFoundFault(_)
        )
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::DbClusterNotFoundFault(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::DbInstanceNotFoundFault(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::DbProxyNotFoundFault(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::DbProxyTargetGroupNotFoundFault(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::DbSnapshotNotFoundFault(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ModifyCertificates` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ModifyCertificatesError {
    /// Kind of error that occurred.
    pub kind: ModifyCertificatesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ModifyCertificates` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ModifyCertificatesErrorKind {
    /// <p> <code>CertificateIdentifier</code> doesn't refer to an existing certificate. </p>
    CertificateNotFoundFault(crate::error::CertificateNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ModifyCertificatesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ModifyCertificatesErrorKind::CertificateNotFoundFault(_inner) => _inner.fmt(f),
            ModifyCertificatesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ModifyCertificatesError {
    fn code(&self) -> Option<&str> {
        ModifyCertificatesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ModifyCertificatesError {
    /// Creates a new `ModifyCertificatesError`.
    pub fn new(kind: ModifyCertificatesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ModifyCertificatesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ModifyCertificatesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ModifyCertificatesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ModifyCertificatesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ModifyCertificatesErrorKind::CertificateNotFoundFault`.
    pub fn is_certificate_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyCertificatesErrorKind::CertificateNotFoundFault(_)
        )
    }
}
impl std::error::Error for ModifyCertificatesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ModifyCertificatesErrorKind::CertificateNotFoundFault(_inner) => Some(_inner),
            ModifyCertificatesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ModifyCurrentDBClusterCapacity` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ModifyCurrentDBClusterCapacityError {
    /// Kind of error that occurred.
    pub kind: ModifyCurrentDBClusterCapacityErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ModifyCurrentDBClusterCapacity` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ModifyCurrentDBClusterCapacityErrorKind {
    /// <p> <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster. </p>
    DbClusterNotFoundFault(crate::error::DbClusterNotFoundFault),
    /// <p> <code>Capacity</code> isn't a valid Aurora Serverless DB cluster capacity. Valid capacity values are <code>2</code>, <code>4</code>, <code>8</code>, <code>16</code>, <code>32</code>, <code>64</code>, <code>128</code>, and <code>256</code>.</p>
    InvalidDbClusterCapacityFault(crate::error::InvalidDbClusterCapacityFault),
    /// <p>The requested operation can't be performed while the cluster is in this state.</p>
    InvalidDbClusterStateFault(crate::error::InvalidDbClusterStateFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ModifyCurrentDBClusterCapacityError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ModifyCurrentDBClusterCapacityErrorKind::DbClusterNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            ModifyCurrentDBClusterCapacityErrorKind::InvalidDbClusterCapacityFault(_inner) => {
                _inner.fmt(f)
            }
            ModifyCurrentDBClusterCapacityErrorKind::InvalidDbClusterStateFault(_inner) => {
                _inner.fmt(f)
            }
            ModifyCurrentDBClusterCapacityErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ModifyCurrentDBClusterCapacityError {
    fn code(&self) -> Option<&str> {
        ModifyCurrentDBClusterCapacityError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ModifyCurrentDBClusterCapacityError {
    /// Creates a new `ModifyCurrentDBClusterCapacityError`.
    pub fn new(
        kind: ModifyCurrentDBClusterCapacityErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ModifyCurrentDBClusterCapacityError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ModifyCurrentDBClusterCapacityErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ModifyCurrentDBClusterCapacityError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ModifyCurrentDBClusterCapacityErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ModifyCurrentDBClusterCapacityErrorKind::DbClusterNotFoundFault`.
    pub fn is_db_cluster_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyCurrentDBClusterCapacityErrorKind::DbClusterNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyCurrentDBClusterCapacityErrorKind::InvalidDbClusterCapacityFault`.
    pub fn is_invalid_db_cluster_capacity_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyCurrentDBClusterCapacityErrorKind::InvalidDbClusterCapacityFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyCurrentDBClusterCapacityErrorKind::InvalidDbClusterStateFault`.
    pub fn is_invalid_db_cluster_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyCurrentDBClusterCapacityErrorKind::InvalidDbClusterStateFault(_)
        )
    }
}
impl std::error::Error for ModifyCurrentDBClusterCapacityError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ModifyCurrentDBClusterCapacityErrorKind::DbClusterNotFoundFault(_inner) => Some(_inner),
            ModifyCurrentDBClusterCapacityErrorKind::InvalidDbClusterCapacityFault(_inner) => {
                Some(_inner)
            }
            ModifyCurrentDBClusterCapacityErrorKind::InvalidDbClusterStateFault(_inner) => {
                Some(_inner)
            }
            ModifyCurrentDBClusterCapacityErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ModifyCustomDBEngineVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ModifyCustomDBEngineVersionError {
    /// Kind of error that occurred.
    pub kind: ModifyCustomDBEngineVersionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ModifyCustomDBEngineVersion` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ModifyCustomDBEngineVersionErrorKind {
    /// <p>The specified CEV was not found.</p>
    CustomDbEngineVersionNotFoundFault(crate::error::CustomDbEngineVersionNotFoundFault),
    /// <p>You can't delete the CEV.</p>
    InvalidCustomDbEngineVersionStateFault(crate::error::InvalidCustomDbEngineVersionStateFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ModifyCustomDBEngineVersionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ModifyCustomDBEngineVersionErrorKind::CustomDbEngineVersionNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            ModifyCustomDBEngineVersionErrorKind::InvalidCustomDbEngineVersionStateFault(
                _inner,
            ) => _inner.fmt(f),
            ModifyCustomDBEngineVersionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ModifyCustomDBEngineVersionError {
    fn code(&self) -> Option<&str> {
        ModifyCustomDBEngineVersionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ModifyCustomDBEngineVersionError {
    /// Creates a new `ModifyCustomDBEngineVersionError`.
    pub fn new(kind: ModifyCustomDBEngineVersionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ModifyCustomDBEngineVersionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ModifyCustomDBEngineVersionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ModifyCustomDBEngineVersionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ModifyCustomDBEngineVersionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ModifyCustomDBEngineVersionErrorKind::CustomDbEngineVersionNotFoundFault`.
    pub fn is_custom_db_engine_version_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyCustomDBEngineVersionErrorKind::CustomDbEngineVersionNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyCustomDBEngineVersionErrorKind::InvalidCustomDbEngineVersionStateFault`.
    pub fn is_invalid_custom_db_engine_version_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyCustomDBEngineVersionErrorKind::InvalidCustomDbEngineVersionStateFault(_)
        )
    }
}
impl std::error::Error for ModifyCustomDBEngineVersionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ModifyCustomDBEngineVersionErrorKind::CustomDbEngineVersionNotFoundFault(_inner) => {
                Some(_inner)
            }
            ModifyCustomDBEngineVersionErrorKind::InvalidCustomDbEngineVersionStateFault(
                _inner,
            ) => Some(_inner),
            ModifyCustomDBEngineVersionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ModifyDBCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ModifyDBClusterError {
    /// Kind of error that occurred.
    pub kind: ModifyDBClusterErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ModifyDBCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ModifyDBClusterErrorKind {
    /// <p>The user already has a DB cluster with the given identifier.</p>
    DbClusterAlreadyExistsFault(crate::error::DbClusterAlreadyExistsFault),
    /// <p> <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster. </p>
    DbClusterNotFoundFault(crate::error::DbClusterNotFoundFault),
    /// <p> <code>DBClusterParameterGroupName</code> doesn't refer to an existing DB cluster parameter group. </p>
    DbClusterParameterGroupNotFoundFault(crate::error::DbClusterParameterGroupNotFoundFault),
    /// <p> <code>DBSubnetGroupName</code> doesn't refer to an existing DB subnet group. </p>
    DbSubnetGroupNotFoundFault(crate::error::DbSubnetGroupNotFoundFault),
    /// <p> <code>Domain</code> doesn't refer to an existing Active Directory domain. </p>
    DomainNotFoundFault(crate::error::DomainNotFoundFault),
    /// <p>The requested operation can't be performed while the cluster is in this state.</p>
    InvalidDbClusterStateFault(crate::error::InvalidDbClusterStateFault),
    /// <p>The DB instance isn't in a valid state.</p>
    InvalidDbInstanceStateFault(crate::error::InvalidDbInstanceStateFault),
    /// <p>The state of the DB security group doesn't allow deletion.</p>
    InvalidDbSecurityGroupStateFault(crate::error::InvalidDbSecurityGroupStateFault),
    /// <p>The DB subnet group cannot be deleted because it's in use.</p>
    InvalidDbSubnetGroupStateFault(crate::error::InvalidDbSubnetGroupStateFault),
    /// <p>The requested subnet is invalid, or multiple subnets were requested that are not all in a common VPC.</p>
    InvalidSubnet(crate::error::InvalidSubnet),
    /// <p>The DB subnet group doesn't cover all Availability Zones after it's created because of users' change.</p>
    InvalidVpcNetworkStateFault(crate::error::InvalidVpcNetworkStateFault),
    /// <p>The request would result in the user exceeding the allowed amount of storage available across all DB instances.</p>
    StorageQuotaExceededFault(crate::error::StorageQuotaExceededFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ModifyDBClusterError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ModifyDBClusterErrorKind::DbClusterAlreadyExistsFault(_inner) => _inner.fmt(f),
            ModifyDBClusterErrorKind::DbClusterNotFoundFault(_inner) => _inner.fmt(f),
            ModifyDBClusterErrorKind::DbClusterParameterGroupNotFoundFault(_inner) => _inner.fmt(f),
            ModifyDBClusterErrorKind::DbSubnetGroupNotFoundFault(_inner) => _inner.fmt(f),
            ModifyDBClusterErrorKind::DomainNotFoundFault(_inner) => _inner.fmt(f),
            ModifyDBClusterErrorKind::InvalidDbClusterStateFault(_inner) => _inner.fmt(f),
            ModifyDBClusterErrorKind::InvalidDbInstanceStateFault(_inner) => _inner.fmt(f),
            ModifyDBClusterErrorKind::InvalidDbSecurityGroupStateFault(_inner) => _inner.fmt(f),
            ModifyDBClusterErrorKind::InvalidDbSubnetGroupStateFault(_inner) => _inner.fmt(f),
            ModifyDBClusterErrorKind::InvalidSubnet(_inner) => _inner.fmt(f),
            ModifyDBClusterErrorKind::InvalidVpcNetworkStateFault(_inner) => _inner.fmt(f),
            ModifyDBClusterErrorKind::StorageQuotaExceededFault(_inner) => _inner.fmt(f),
            ModifyDBClusterErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ModifyDBClusterError {
    fn code(&self) -> Option<&str> {
        ModifyDBClusterError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ModifyDBClusterError {
    /// Creates a new `ModifyDBClusterError`.
    pub fn new(kind: ModifyDBClusterErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ModifyDBClusterError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ModifyDBClusterErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ModifyDBClusterError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ModifyDBClusterErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ModifyDBClusterErrorKind::DbClusterAlreadyExistsFault`.
    pub fn is_db_cluster_already_exists_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyDBClusterErrorKind::DbClusterAlreadyExistsFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyDBClusterErrorKind::DbClusterNotFoundFault`.
    pub fn is_db_cluster_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyDBClusterErrorKind::DbClusterNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyDBClusterErrorKind::DbClusterParameterGroupNotFoundFault`.
    pub fn is_db_cluster_parameter_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyDBClusterErrorKind::DbClusterParameterGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyDBClusterErrorKind::DbSubnetGroupNotFoundFault`.
    pub fn is_db_subnet_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyDBClusterErrorKind::DbSubnetGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyDBClusterErrorKind::DomainNotFoundFault`.
    pub fn is_domain_not_found_fault(&self) -> bool {
        matches!(&self.kind, ModifyDBClusterErrorKind::DomainNotFoundFault(_))
    }
    /// Returns `true` if the error kind is `ModifyDBClusterErrorKind::InvalidDbClusterStateFault`.
    pub fn is_invalid_db_cluster_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyDBClusterErrorKind::InvalidDbClusterStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyDBClusterErrorKind::InvalidDbInstanceStateFault`.
    pub fn is_invalid_db_instance_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyDBClusterErrorKind::InvalidDbInstanceStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyDBClusterErrorKind::InvalidDbSecurityGroupStateFault`.
    pub fn is_invalid_db_security_group_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyDBClusterErrorKind::InvalidDbSecurityGroupStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyDBClusterErrorKind::InvalidDbSubnetGroupStateFault`.
    pub fn is_invalid_db_subnet_group_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyDBClusterErrorKind::InvalidDbSubnetGroupStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyDBClusterErrorKind::InvalidSubnet`.
    pub fn is_invalid_subnet(&self) -> bool {
        matches!(&self.kind, ModifyDBClusterErrorKind::InvalidSubnet(_))
    }
    /// Returns `true` if the error kind is `ModifyDBClusterErrorKind::InvalidVpcNetworkStateFault`.
    pub fn is_invalid_vpc_network_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyDBClusterErrorKind::InvalidVpcNetworkStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyDBClusterErrorKind::StorageQuotaExceededFault`.
    pub fn is_storage_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyDBClusterErrorKind::StorageQuotaExceededFault(_)
        )
    }
}
impl std::error::Error for ModifyDBClusterError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ModifyDBClusterErrorKind::DbClusterAlreadyExistsFault(_inner) => Some(_inner),
            ModifyDBClusterErrorKind::DbClusterNotFoundFault(_inner) => Some(_inner),
            ModifyDBClusterErrorKind::DbClusterParameterGroupNotFoundFault(_inner) => Some(_inner),
            ModifyDBClusterErrorKind::DbSubnetGroupNotFoundFault(_inner) => Some(_inner),
            ModifyDBClusterErrorKind::DomainNotFoundFault(_inner) => Some(_inner),
            ModifyDBClusterErrorKind::InvalidDbClusterStateFault(_inner) => Some(_inner),
            ModifyDBClusterErrorKind::InvalidDbInstanceStateFault(_inner) => Some(_inner),
            ModifyDBClusterErrorKind::InvalidDbSecurityGroupStateFault(_inner) => Some(_inner),
            ModifyDBClusterErrorKind::InvalidDbSubnetGroupStateFault(_inner) => Some(_inner),
            ModifyDBClusterErrorKind::InvalidSubnet(_inner) => Some(_inner),
            ModifyDBClusterErrorKind::InvalidVpcNetworkStateFault(_inner) => Some(_inner),
            ModifyDBClusterErrorKind::StorageQuotaExceededFault(_inner) => Some(_inner),
            ModifyDBClusterErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ModifyDBClusterEndpoint` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ModifyDBClusterEndpointError {
    /// Kind of error that occurred.
    pub kind: ModifyDBClusterEndpointErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ModifyDBClusterEndpoint` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ModifyDBClusterEndpointErrorKind {
    /// <p>The specified custom endpoint doesn't exist.</p>
    DbClusterEndpointNotFoundFault(crate::error::DbClusterEndpointNotFoundFault),
    /// <p> <code>DBInstanceIdentifier</code> doesn't refer to an existing DB instance. </p>
    DbInstanceNotFoundFault(crate::error::DbInstanceNotFoundFault),
    /// <p>The requested operation can't be performed on the endpoint while the endpoint is in this state.</p>
    InvalidDbClusterEndpointStateFault(crate::error::InvalidDbClusterEndpointStateFault),
    /// <p>The requested operation can't be performed while the cluster is in this state.</p>
    InvalidDbClusterStateFault(crate::error::InvalidDbClusterStateFault),
    /// <p>The DB instance isn't in a valid state.</p>
    InvalidDbInstanceStateFault(crate::error::InvalidDbInstanceStateFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ModifyDBClusterEndpointError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ModifyDBClusterEndpointErrorKind::DbClusterEndpointNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            ModifyDBClusterEndpointErrorKind::DbInstanceNotFoundFault(_inner) => _inner.fmt(f),
            ModifyDBClusterEndpointErrorKind::InvalidDbClusterEndpointStateFault(_inner) => {
                _inner.fmt(f)
            }
            ModifyDBClusterEndpointErrorKind::InvalidDbClusterStateFault(_inner) => _inner.fmt(f),
            ModifyDBClusterEndpointErrorKind::InvalidDbInstanceStateFault(_inner) => _inner.fmt(f),
            ModifyDBClusterEndpointErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ModifyDBClusterEndpointError {
    fn code(&self) -> Option<&str> {
        ModifyDBClusterEndpointError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ModifyDBClusterEndpointError {
    /// Creates a new `ModifyDBClusterEndpointError`.
    pub fn new(kind: ModifyDBClusterEndpointErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ModifyDBClusterEndpointError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ModifyDBClusterEndpointErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ModifyDBClusterEndpointError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ModifyDBClusterEndpointErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ModifyDBClusterEndpointErrorKind::DbClusterEndpointNotFoundFault`.
    pub fn is_db_cluster_endpoint_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyDBClusterEndpointErrorKind::DbClusterEndpointNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyDBClusterEndpointErrorKind::DbInstanceNotFoundFault`.
    pub fn is_db_instance_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyDBClusterEndpointErrorKind::DbInstanceNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyDBClusterEndpointErrorKind::InvalidDbClusterEndpointStateFault`.
    pub fn is_invalid_db_cluster_endpoint_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyDBClusterEndpointErrorKind::InvalidDbClusterEndpointStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyDBClusterEndpointErrorKind::InvalidDbClusterStateFault`.
    pub fn is_invalid_db_cluster_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyDBClusterEndpointErrorKind::InvalidDbClusterStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyDBClusterEndpointErrorKind::InvalidDbInstanceStateFault`.
    pub fn is_invalid_db_instance_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyDBClusterEndpointErrorKind::InvalidDbInstanceStateFault(_)
        )
    }
}
impl std::error::Error for ModifyDBClusterEndpointError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ModifyDBClusterEndpointErrorKind::DbClusterEndpointNotFoundFault(_inner) => {
                Some(_inner)
            }
            ModifyDBClusterEndpointErrorKind::DbInstanceNotFoundFault(_inner) => Some(_inner),
            ModifyDBClusterEndpointErrorKind::InvalidDbClusterEndpointStateFault(_inner) => {
                Some(_inner)
            }
            ModifyDBClusterEndpointErrorKind::InvalidDbClusterStateFault(_inner) => Some(_inner),
            ModifyDBClusterEndpointErrorKind::InvalidDbInstanceStateFault(_inner) => Some(_inner),
            ModifyDBClusterEndpointErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ModifyDBClusterParameterGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ModifyDBClusterParameterGroupError {
    /// Kind of error that occurred.
    pub kind: ModifyDBClusterParameterGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ModifyDBClusterParameterGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ModifyDBClusterParameterGroupErrorKind {
    /// <p> <code>DBParameterGroupName</code> doesn't refer to an existing DB parameter group. </p>
    DbParameterGroupNotFoundFault(crate::error::DbParameterGroupNotFoundFault),
    /// <p>The DB parameter group is in use or is in an invalid state. If you are attempting to delete the parameter group, you can't delete it when the parameter group is in this state.</p>
    InvalidDbParameterGroupStateFault(crate::error::InvalidDbParameterGroupStateFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ModifyDBClusterParameterGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ModifyDBClusterParameterGroupErrorKind::DbParameterGroupNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            ModifyDBClusterParameterGroupErrorKind::InvalidDbParameterGroupStateFault(_inner) => {
                _inner.fmt(f)
            }
            ModifyDBClusterParameterGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ModifyDBClusterParameterGroupError {
    fn code(&self) -> Option<&str> {
        ModifyDBClusterParameterGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ModifyDBClusterParameterGroupError {
    /// Creates a new `ModifyDBClusterParameterGroupError`.
    pub fn new(
        kind: ModifyDBClusterParameterGroupErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ModifyDBClusterParameterGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ModifyDBClusterParameterGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ModifyDBClusterParameterGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ModifyDBClusterParameterGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ModifyDBClusterParameterGroupErrorKind::DbParameterGroupNotFoundFault`.
    pub fn is_db_parameter_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyDBClusterParameterGroupErrorKind::DbParameterGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyDBClusterParameterGroupErrorKind::InvalidDbParameterGroupStateFault`.
    pub fn is_invalid_db_parameter_group_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyDBClusterParameterGroupErrorKind::InvalidDbParameterGroupStateFault(_)
        )
    }
}
impl std::error::Error for ModifyDBClusterParameterGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ModifyDBClusterParameterGroupErrorKind::DbParameterGroupNotFoundFault(_inner) => {
                Some(_inner)
            }
            ModifyDBClusterParameterGroupErrorKind::InvalidDbParameterGroupStateFault(_inner) => {
                Some(_inner)
            }
            ModifyDBClusterParameterGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ModifyDBClusterSnapshotAttribute` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ModifyDBClusterSnapshotAttributeError {
    /// Kind of error that occurred.
    pub kind: ModifyDBClusterSnapshotAttributeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ModifyDBClusterSnapshotAttribute` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ModifyDBClusterSnapshotAttributeErrorKind {
    /// <p> <code>DBClusterSnapshotIdentifier</code> doesn't refer to an existing DB cluster snapshot. </p>
    DbClusterSnapshotNotFoundFault(crate::error::DbClusterSnapshotNotFoundFault),
    /// <p>The supplied value isn't a valid DB cluster snapshot state.</p>
    InvalidDbClusterSnapshotStateFault(crate::error::InvalidDbClusterSnapshotStateFault),
    /// <p>You have exceeded the maximum number of accounts that you can share a manual DB snapshot with.</p>
    SharedSnapshotQuotaExceededFault(crate::error::SharedSnapshotQuotaExceededFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ModifyDBClusterSnapshotAttributeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ModifyDBClusterSnapshotAttributeErrorKind::DbClusterSnapshotNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            ModifyDBClusterSnapshotAttributeErrorKind::InvalidDbClusterSnapshotStateFault(
                _inner,
            ) => _inner.fmt(f),
            ModifyDBClusterSnapshotAttributeErrorKind::SharedSnapshotQuotaExceededFault(_inner) => {
                _inner.fmt(f)
            }
            ModifyDBClusterSnapshotAttributeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ModifyDBClusterSnapshotAttributeError {
    fn code(&self) -> Option<&str> {
        ModifyDBClusterSnapshotAttributeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ModifyDBClusterSnapshotAttributeError {
    /// Creates a new `ModifyDBClusterSnapshotAttributeError`.
    pub fn new(
        kind: ModifyDBClusterSnapshotAttributeErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ModifyDBClusterSnapshotAttributeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ModifyDBClusterSnapshotAttributeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ModifyDBClusterSnapshotAttributeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ModifyDBClusterSnapshotAttributeErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ModifyDBClusterSnapshotAttributeErrorKind::DbClusterSnapshotNotFoundFault`.
    pub fn is_db_cluster_snapshot_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyDBClusterSnapshotAttributeErrorKind::DbClusterSnapshotNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyDBClusterSnapshotAttributeErrorKind::InvalidDbClusterSnapshotStateFault`.
    pub fn is_invalid_db_cluster_snapshot_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyDBClusterSnapshotAttributeErrorKind::InvalidDbClusterSnapshotStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyDBClusterSnapshotAttributeErrorKind::SharedSnapshotQuotaExceededFault`.
    pub fn is_shared_snapshot_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyDBClusterSnapshotAttributeErrorKind::SharedSnapshotQuotaExceededFault(_)
        )
    }
}
impl std::error::Error for ModifyDBClusterSnapshotAttributeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ModifyDBClusterSnapshotAttributeErrorKind::DbClusterSnapshotNotFoundFault(_inner) => {
                Some(_inner)
            }
            ModifyDBClusterSnapshotAttributeErrorKind::InvalidDbClusterSnapshotStateFault(
                _inner,
            ) => Some(_inner),
            ModifyDBClusterSnapshotAttributeErrorKind::SharedSnapshotQuotaExceededFault(_inner) => {
                Some(_inner)
            }
            ModifyDBClusterSnapshotAttributeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ModifyDBInstance` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ModifyDBInstanceError {
    /// Kind of error that occurred.
    pub kind: ModifyDBInstanceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ModifyDBInstance` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ModifyDBInstanceErrorKind {
    /// <p>The specified CIDR IP range or Amazon EC2 security group might not be authorized for the specified DB security group.</p>
    /// <p>Or, RDS might not be authorized to perform necessary actions using IAM on your behalf.</p>
    AuthorizationNotFoundFault(crate::error::AuthorizationNotFoundFault),
    #[allow(missing_docs)] // documentation missing in model
    BackupPolicyNotFoundFault(crate::error::BackupPolicyNotFoundFault),
    /// <p> <code>CertificateIdentifier</code> doesn't refer to an existing certificate. </p>
    CertificateNotFoundFault(crate::error::CertificateNotFoundFault),
    /// <p>The user already has a DB instance with the given identifier.</p>
    DbInstanceAlreadyExistsFault(crate::error::DbInstanceAlreadyExistsFault),
    /// <p> <code>DBInstanceIdentifier</code> doesn't refer to an existing DB instance. </p>
    DbInstanceNotFoundFault(crate::error::DbInstanceNotFoundFault),
    /// <p> <code>DBParameterGroupName</code> doesn't refer to an existing DB parameter group. </p>
    DbParameterGroupNotFoundFault(crate::error::DbParameterGroupNotFoundFault),
    /// <p> <code>DBSecurityGroupName</code> doesn't refer to an existing DB security group. </p>
    DbSecurityGroupNotFoundFault(crate::error::DbSecurityGroupNotFoundFault),
    /// <p>The DB upgrade failed because a resource the DB depends on can't be modified.</p>
    DbUpgradeDependencyFailureFault(crate::error::DbUpgradeDependencyFailureFault),
    /// <p> <code>Domain</code> doesn't refer to an existing Active Directory domain. </p>
    DomainNotFoundFault(crate::error::DomainNotFoundFault),
    /// <p>The specified DB instance class isn't available in the specified Availability Zone.</p>
    InsufficientDbInstanceCapacityFault(crate::error::InsufficientDbInstanceCapacityFault),
    /// <p>The requested operation can't be performed while the cluster is in this state.</p>
    InvalidDbClusterStateFault(crate::error::InvalidDbClusterStateFault),
    /// <p>The DB instance isn't in a valid state.</p>
    InvalidDbInstanceStateFault(crate::error::InvalidDbInstanceStateFault),
    /// <p>The state of the DB security group doesn't allow deletion.</p>
    InvalidDbSecurityGroupStateFault(crate::error::InvalidDbSecurityGroupStateFault),
    /// <p>The DB subnet group doesn't cover all Availability Zones after it's created because of users' change.</p>
    InvalidVpcNetworkStateFault(crate::error::InvalidVpcNetworkStateFault),
    /// <p>An error occurred accessing an Amazon Web Services KMS key.</p>
    KmsKeyNotAccessibleFault(crate::error::KmsKeyNotAccessibleFault),
    /// <p>The specified option group could not be found.</p>
    OptionGroupNotFoundFault(crate::error::OptionGroupNotFoundFault),
    /// <p>Provisioned IOPS not available in the specified Availability Zone.</p>
    ProvisionedIopsNotAvailableInAzFault(crate::error::ProvisionedIopsNotAvailableInAzFault),
    /// <p>The request would result in the user exceeding the allowed amount of storage available across all DB instances.</p>
    StorageQuotaExceededFault(crate::error::StorageQuotaExceededFault),
    /// <p>Storage of the <code>StorageType</code> specified can't be associated with the DB instance. </p>
    StorageTypeNotSupportedFault(crate::error::StorageTypeNotSupportedFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ModifyDBInstanceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ModifyDBInstanceErrorKind::AuthorizationNotFoundFault(_inner) => _inner.fmt(f),
            ModifyDBInstanceErrorKind::BackupPolicyNotFoundFault(_inner) => _inner.fmt(f),
            ModifyDBInstanceErrorKind::CertificateNotFoundFault(_inner) => _inner.fmt(f),
            ModifyDBInstanceErrorKind::DbInstanceAlreadyExistsFault(_inner) => _inner.fmt(f),
            ModifyDBInstanceErrorKind::DbInstanceNotFoundFault(_inner) => _inner.fmt(f),
            ModifyDBInstanceErrorKind::DbParameterGroupNotFoundFault(_inner) => _inner.fmt(f),
            ModifyDBInstanceErrorKind::DbSecurityGroupNotFoundFault(_inner) => _inner.fmt(f),
            ModifyDBInstanceErrorKind::DbUpgradeDependencyFailureFault(_inner) => _inner.fmt(f),
            ModifyDBInstanceErrorKind::DomainNotFoundFault(_inner) => _inner.fmt(f),
            ModifyDBInstanceErrorKind::InsufficientDbInstanceCapacityFault(_inner) => _inner.fmt(f),
            ModifyDBInstanceErrorKind::InvalidDbClusterStateFault(_inner) => _inner.fmt(f),
            ModifyDBInstanceErrorKind::InvalidDbInstanceStateFault(_inner) => _inner.fmt(f),
            ModifyDBInstanceErrorKind::InvalidDbSecurityGroupStateFault(_inner) => _inner.fmt(f),
            ModifyDBInstanceErrorKind::InvalidVpcNetworkStateFault(_inner) => _inner.fmt(f),
            ModifyDBInstanceErrorKind::KmsKeyNotAccessibleFault(_inner) => _inner.fmt(f),
            ModifyDBInstanceErrorKind::OptionGroupNotFoundFault(_inner) => _inner.fmt(f),
            ModifyDBInstanceErrorKind::ProvisionedIopsNotAvailableInAzFault(_inner) => {
                _inner.fmt(f)
            }
            ModifyDBInstanceErrorKind::StorageQuotaExceededFault(_inner) => _inner.fmt(f),
            ModifyDBInstanceErrorKind::StorageTypeNotSupportedFault(_inner) => _inner.fmt(f),
            ModifyDBInstanceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ModifyDBInstanceError {
    fn code(&self) -> Option<&str> {
        ModifyDBInstanceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ModifyDBInstanceError {
    /// Creates a new `ModifyDBInstanceError`.
    pub fn new(kind: ModifyDBInstanceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ModifyDBInstanceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ModifyDBInstanceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ModifyDBInstanceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ModifyDBInstanceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ModifyDBInstanceErrorKind::AuthorizationNotFoundFault`.
    pub fn is_authorization_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyDBInstanceErrorKind::AuthorizationNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyDBInstanceErrorKind::BackupPolicyNotFoundFault`.
    pub fn is_backup_policy_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyDBInstanceErrorKind::BackupPolicyNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyDBInstanceErrorKind::CertificateNotFoundFault`.
    pub fn is_certificate_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyDBInstanceErrorKind::CertificateNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyDBInstanceErrorKind::DbInstanceAlreadyExistsFault`.
    pub fn is_db_instance_already_exists_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyDBInstanceErrorKind::DbInstanceAlreadyExistsFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyDBInstanceErrorKind::DbInstanceNotFoundFault`.
    pub fn is_db_instance_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyDBInstanceErrorKind::DbInstanceNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyDBInstanceErrorKind::DbParameterGroupNotFoundFault`.
    pub fn is_db_parameter_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyDBInstanceErrorKind::DbParameterGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyDBInstanceErrorKind::DbSecurityGroupNotFoundFault`.
    pub fn is_db_security_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyDBInstanceErrorKind::DbSecurityGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyDBInstanceErrorKind::DbUpgradeDependencyFailureFault`.
    pub fn is_db_upgrade_dependency_failure_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyDBInstanceErrorKind::DbUpgradeDependencyFailureFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyDBInstanceErrorKind::DomainNotFoundFault`.
    pub fn is_domain_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyDBInstanceErrorKind::DomainNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyDBInstanceErrorKind::InsufficientDbInstanceCapacityFault`.
    pub fn is_insufficient_db_instance_capacity_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyDBInstanceErrorKind::InsufficientDbInstanceCapacityFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyDBInstanceErrorKind::InvalidDbClusterStateFault`.
    pub fn is_invalid_db_cluster_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyDBInstanceErrorKind::InvalidDbClusterStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyDBInstanceErrorKind::InvalidDbInstanceStateFault`.
    pub fn is_invalid_db_instance_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyDBInstanceErrorKind::InvalidDbInstanceStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyDBInstanceErrorKind::InvalidDbSecurityGroupStateFault`.
    pub fn is_invalid_db_security_group_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyDBInstanceErrorKind::InvalidDbSecurityGroupStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyDBInstanceErrorKind::InvalidVpcNetworkStateFault`.
    pub fn is_invalid_vpc_network_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyDBInstanceErrorKind::InvalidVpcNetworkStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyDBInstanceErrorKind::KmsKeyNotAccessibleFault`.
    pub fn is_kms_key_not_accessible_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyDBInstanceErrorKind::KmsKeyNotAccessibleFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyDBInstanceErrorKind::OptionGroupNotFoundFault`.
    pub fn is_option_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyDBInstanceErrorKind::OptionGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyDBInstanceErrorKind::ProvisionedIopsNotAvailableInAzFault`.
    pub fn is_provisioned_iops_not_available_in_az_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyDBInstanceErrorKind::ProvisionedIopsNotAvailableInAzFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyDBInstanceErrorKind::StorageQuotaExceededFault`.
    pub fn is_storage_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyDBInstanceErrorKind::StorageQuotaExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyDBInstanceErrorKind::StorageTypeNotSupportedFault`.
    pub fn is_storage_type_not_supported_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyDBInstanceErrorKind::StorageTypeNotSupportedFault(_)
        )
    }
}
impl std::error::Error for ModifyDBInstanceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ModifyDBInstanceErrorKind::AuthorizationNotFoundFault(_inner) => Some(_inner),
            ModifyDBInstanceErrorKind::BackupPolicyNotFoundFault(_inner) => Some(_inner),
            ModifyDBInstanceErrorKind::CertificateNotFoundFault(_inner) => Some(_inner),
            ModifyDBInstanceErrorKind::DbInstanceAlreadyExistsFault(_inner) => Some(_inner),
            ModifyDBInstanceErrorKind::DbInstanceNotFoundFault(_inner) => Some(_inner),
            ModifyDBInstanceErrorKind::DbParameterGroupNotFoundFault(_inner) => Some(_inner),
            ModifyDBInstanceErrorKind::DbSecurityGroupNotFoundFault(_inner) => Some(_inner),
            ModifyDBInstanceErrorKind::DbUpgradeDependencyFailureFault(_inner) => Some(_inner),
            ModifyDBInstanceErrorKind::DomainNotFoundFault(_inner) => Some(_inner),
            ModifyDBInstanceErrorKind::InsufficientDbInstanceCapacityFault(_inner) => Some(_inner),
            ModifyDBInstanceErrorKind::InvalidDbClusterStateFault(_inner) => Some(_inner),
            ModifyDBInstanceErrorKind::InvalidDbInstanceStateFault(_inner) => Some(_inner),
            ModifyDBInstanceErrorKind::InvalidDbSecurityGroupStateFault(_inner) => Some(_inner),
            ModifyDBInstanceErrorKind::InvalidVpcNetworkStateFault(_inner) => Some(_inner),
            ModifyDBInstanceErrorKind::KmsKeyNotAccessibleFault(_inner) => Some(_inner),
            ModifyDBInstanceErrorKind::OptionGroupNotFoundFault(_inner) => Some(_inner),
            ModifyDBInstanceErrorKind::ProvisionedIopsNotAvailableInAzFault(_inner) => Some(_inner),
            ModifyDBInstanceErrorKind::StorageQuotaExceededFault(_inner) => Some(_inner),
            ModifyDBInstanceErrorKind::StorageTypeNotSupportedFault(_inner) => Some(_inner),
            ModifyDBInstanceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ModifyDBParameterGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ModifyDBParameterGroupError {
    /// Kind of error that occurred.
    pub kind: ModifyDBParameterGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ModifyDBParameterGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ModifyDBParameterGroupErrorKind {
    /// <p> <code>DBParameterGroupName</code> doesn't refer to an existing DB parameter group. </p>
    DbParameterGroupNotFoundFault(crate::error::DbParameterGroupNotFoundFault),
    /// <p>The DB parameter group is in use or is in an invalid state. If you are attempting to delete the parameter group, you can't delete it when the parameter group is in this state.</p>
    InvalidDbParameterGroupStateFault(crate::error::InvalidDbParameterGroupStateFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ModifyDBParameterGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ModifyDBParameterGroupErrorKind::DbParameterGroupNotFoundFault(_inner) => _inner.fmt(f),
            ModifyDBParameterGroupErrorKind::InvalidDbParameterGroupStateFault(_inner) => {
                _inner.fmt(f)
            }
            ModifyDBParameterGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ModifyDBParameterGroupError {
    fn code(&self) -> Option<&str> {
        ModifyDBParameterGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ModifyDBParameterGroupError {
    /// Creates a new `ModifyDBParameterGroupError`.
    pub fn new(kind: ModifyDBParameterGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ModifyDBParameterGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ModifyDBParameterGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ModifyDBParameterGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ModifyDBParameterGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ModifyDBParameterGroupErrorKind::DbParameterGroupNotFoundFault`.
    pub fn is_db_parameter_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyDBParameterGroupErrorKind::DbParameterGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyDBParameterGroupErrorKind::InvalidDbParameterGroupStateFault`.
    pub fn is_invalid_db_parameter_group_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyDBParameterGroupErrorKind::InvalidDbParameterGroupStateFault(_)
        )
    }
}
impl std::error::Error for ModifyDBParameterGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ModifyDBParameterGroupErrorKind::DbParameterGroupNotFoundFault(_inner) => Some(_inner),
            ModifyDBParameterGroupErrorKind::InvalidDbParameterGroupStateFault(_inner) => {
                Some(_inner)
            }
            ModifyDBParameterGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ModifyDBProxy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ModifyDBProxyError {
    /// Kind of error that occurred.
    pub kind: ModifyDBProxyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ModifyDBProxy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ModifyDBProxyErrorKind {
    /// <p>The specified proxy name must be unique for all proxies owned by your Amazon Web Services account in the specified Amazon Web Services Region.</p>
    DbProxyAlreadyExistsFault(crate::error::DbProxyAlreadyExistsFault),
    /// <p>The specified proxy name doesn't correspond to a proxy owned by your Amazon Web Services account in the specified Amazon Web Services Region.</p>
    DbProxyNotFoundFault(crate::error::DbProxyNotFoundFault),
    /// <p>The requested operation can't be performed while the proxy is in this state.</p>
    InvalidDbProxyStateFault(crate::error::InvalidDbProxyStateFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ModifyDBProxyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ModifyDBProxyErrorKind::DbProxyAlreadyExistsFault(_inner) => _inner.fmt(f),
            ModifyDBProxyErrorKind::DbProxyNotFoundFault(_inner) => _inner.fmt(f),
            ModifyDBProxyErrorKind::InvalidDbProxyStateFault(_inner) => _inner.fmt(f),
            ModifyDBProxyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ModifyDBProxyError {
    fn code(&self) -> Option<&str> {
        ModifyDBProxyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ModifyDBProxyError {
    /// Creates a new `ModifyDBProxyError`.
    pub fn new(kind: ModifyDBProxyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ModifyDBProxyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ModifyDBProxyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ModifyDBProxyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ModifyDBProxyErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ModifyDBProxyErrorKind::DbProxyAlreadyExistsFault`.
    pub fn is_db_proxy_already_exists_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyDBProxyErrorKind::DbProxyAlreadyExistsFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyDBProxyErrorKind::DbProxyNotFoundFault`.
    pub fn is_db_proxy_not_found_fault(&self) -> bool {
        matches!(&self.kind, ModifyDBProxyErrorKind::DbProxyNotFoundFault(_))
    }
    /// Returns `true` if the error kind is `ModifyDBProxyErrorKind::InvalidDbProxyStateFault`.
    pub fn is_invalid_db_proxy_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyDBProxyErrorKind::InvalidDbProxyStateFault(_)
        )
    }
}
impl std::error::Error for ModifyDBProxyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ModifyDBProxyErrorKind::DbProxyAlreadyExistsFault(_inner) => Some(_inner),
            ModifyDBProxyErrorKind::DbProxyNotFoundFault(_inner) => Some(_inner),
            ModifyDBProxyErrorKind::InvalidDbProxyStateFault(_inner) => Some(_inner),
            ModifyDBProxyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ModifyDBProxyEndpoint` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ModifyDBProxyEndpointError {
    /// Kind of error that occurred.
    pub kind: ModifyDBProxyEndpointErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ModifyDBProxyEndpoint` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ModifyDBProxyEndpointErrorKind {
    /// <p>The specified DB proxy endpoint name must be unique for all DB proxy endpoints owned by your Amazon Web Services account in the specified Amazon Web Services Region.</p>
    DbProxyEndpointAlreadyExistsFault(crate::error::DbProxyEndpointAlreadyExistsFault),
    /// <p>The DB proxy endpoint doesn't exist.</p>
    DbProxyEndpointNotFoundFault(crate::error::DbProxyEndpointNotFoundFault),
    /// <p>You can't perform this operation while the DB proxy endpoint is in a particular state.</p>
    InvalidDbProxyEndpointStateFault(crate::error::InvalidDbProxyEndpointStateFault),
    /// <p>The requested operation can't be performed while the proxy is in this state.</p>
    InvalidDbProxyStateFault(crate::error::InvalidDbProxyStateFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ModifyDBProxyEndpointError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ModifyDBProxyEndpointErrorKind::DbProxyEndpointAlreadyExistsFault(_inner) => {
                _inner.fmt(f)
            }
            ModifyDBProxyEndpointErrorKind::DbProxyEndpointNotFoundFault(_inner) => _inner.fmt(f),
            ModifyDBProxyEndpointErrorKind::InvalidDbProxyEndpointStateFault(_inner) => {
                _inner.fmt(f)
            }
            ModifyDBProxyEndpointErrorKind::InvalidDbProxyStateFault(_inner) => _inner.fmt(f),
            ModifyDBProxyEndpointErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ModifyDBProxyEndpointError {
    fn code(&self) -> Option<&str> {
        ModifyDBProxyEndpointError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ModifyDBProxyEndpointError {
    /// Creates a new `ModifyDBProxyEndpointError`.
    pub fn new(kind: ModifyDBProxyEndpointErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ModifyDBProxyEndpointError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ModifyDBProxyEndpointErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ModifyDBProxyEndpointError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ModifyDBProxyEndpointErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ModifyDBProxyEndpointErrorKind::DbProxyEndpointAlreadyExistsFault`.
    pub fn is_db_proxy_endpoint_already_exists_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyDBProxyEndpointErrorKind::DbProxyEndpointAlreadyExistsFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyDBProxyEndpointErrorKind::DbProxyEndpointNotFoundFault`.
    pub fn is_db_proxy_endpoint_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyDBProxyEndpointErrorKind::DbProxyEndpointNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyDBProxyEndpointErrorKind::InvalidDbProxyEndpointStateFault`.
    pub fn is_invalid_db_proxy_endpoint_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyDBProxyEndpointErrorKind::InvalidDbProxyEndpointStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyDBProxyEndpointErrorKind::InvalidDbProxyStateFault`.
    pub fn is_invalid_db_proxy_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyDBProxyEndpointErrorKind::InvalidDbProxyStateFault(_)
        )
    }
}
impl std::error::Error for ModifyDBProxyEndpointError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ModifyDBProxyEndpointErrorKind::DbProxyEndpointAlreadyExistsFault(_inner) => {
                Some(_inner)
            }
            ModifyDBProxyEndpointErrorKind::DbProxyEndpointNotFoundFault(_inner) => Some(_inner),
            ModifyDBProxyEndpointErrorKind::InvalidDbProxyEndpointStateFault(_inner) => {
                Some(_inner)
            }
            ModifyDBProxyEndpointErrorKind::InvalidDbProxyStateFault(_inner) => Some(_inner),
            ModifyDBProxyEndpointErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ModifyDBProxyTargetGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ModifyDBProxyTargetGroupError {
    /// Kind of error that occurred.
    pub kind: ModifyDBProxyTargetGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ModifyDBProxyTargetGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ModifyDBProxyTargetGroupErrorKind {
    /// <p>The specified proxy name doesn't correspond to a proxy owned by your Amazon Web Services account in the specified Amazon Web Services Region.</p>
    DbProxyNotFoundFault(crate::error::DbProxyNotFoundFault),
    /// <p>The specified target group isn't available for a proxy owned by your Amazon Web Services account in the specified Amazon Web Services Region.</p>
    DbProxyTargetGroupNotFoundFault(crate::error::DbProxyTargetGroupNotFoundFault),
    /// <p>The requested operation can't be performed while the proxy is in this state.</p>
    InvalidDbProxyStateFault(crate::error::InvalidDbProxyStateFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ModifyDBProxyTargetGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ModifyDBProxyTargetGroupErrorKind::DbProxyNotFoundFault(_inner) => _inner.fmt(f),
            ModifyDBProxyTargetGroupErrorKind::DbProxyTargetGroupNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            ModifyDBProxyTargetGroupErrorKind::InvalidDbProxyStateFault(_inner) => _inner.fmt(f),
            ModifyDBProxyTargetGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ModifyDBProxyTargetGroupError {
    fn code(&self) -> Option<&str> {
        ModifyDBProxyTargetGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ModifyDBProxyTargetGroupError {
    /// Creates a new `ModifyDBProxyTargetGroupError`.
    pub fn new(kind: ModifyDBProxyTargetGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ModifyDBProxyTargetGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ModifyDBProxyTargetGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ModifyDBProxyTargetGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ModifyDBProxyTargetGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ModifyDBProxyTargetGroupErrorKind::DbProxyNotFoundFault`.
    pub fn is_db_proxy_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyDBProxyTargetGroupErrorKind::DbProxyNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyDBProxyTargetGroupErrorKind::DbProxyTargetGroupNotFoundFault`.
    pub fn is_db_proxy_target_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyDBProxyTargetGroupErrorKind::DbProxyTargetGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyDBProxyTargetGroupErrorKind::InvalidDbProxyStateFault`.
    pub fn is_invalid_db_proxy_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyDBProxyTargetGroupErrorKind::InvalidDbProxyStateFault(_)
        )
    }
}
impl std::error::Error for ModifyDBProxyTargetGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ModifyDBProxyTargetGroupErrorKind::DbProxyNotFoundFault(_inner) => Some(_inner),
            ModifyDBProxyTargetGroupErrorKind::DbProxyTargetGroupNotFoundFault(_inner) => {
                Some(_inner)
            }
            ModifyDBProxyTargetGroupErrorKind::InvalidDbProxyStateFault(_inner) => Some(_inner),
            ModifyDBProxyTargetGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ModifyDBSnapshot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ModifyDBSnapshotError {
    /// Kind of error that occurred.
    pub kind: ModifyDBSnapshotErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ModifyDBSnapshot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ModifyDBSnapshotErrorKind {
    /// <p> <code>DBSnapshotIdentifier</code> doesn't refer to an existing DB snapshot. </p>
    DbSnapshotNotFoundFault(crate::error::DbSnapshotNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ModifyDBSnapshotError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ModifyDBSnapshotErrorKind::DbSnapshotNotFoundFault(_inner) => _inner.fmt(f),
            ModifyDBSnapshotErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ModifyDBSnapshotError {
    fn code(&self) -> Option<&str> {
        ModifyDBSnapshotError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ModifyDBSnapshotError {
    /// Creates a new `ModifyDBSnapshotError`.
    pub fn new(kind: ModifyDBSnapshotErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ModifyDBSnapshotError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ModifyDBSnapshotErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ModifyDBSnapshotError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ModifyDBSnapshotErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ModifyDBSnapshotErrorKind::DbSnapshotNotFoundFault`.
    pub fn is_db_snapshot_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyDBSnapshotErrorKind::DbSnapshotNotFoundFault(_)
        )
    }
}
impl std::error::Error for ModifyDBSnapshotError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ModifyDBSnapshotErrorKind::DbSnapshotNotFoundFault(_inner) => Some(_inner),
            ModifyDBSnapshotErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ModifyDBSnapshotAttribute` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ModifyDBSnapshotAttributeError {
    /// Kind of error that occurred.
    pub kind: ModifyDBSnapshotAttributeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ModifyDBSnapshotAttribute` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ModifyDBSnapshotAttributeErrorKind {
    /// <p> <code>DBSnapshotIdentifier</code> doesn't refer to an existing DB snapshot. </p>
    DbSnapshotNotFoundFault(crate::error::DbSnapshotNotFoundFault),
    /// <p>The state of the DB snapshot doesn't allow deletion.</p>
    InvalidDbSnapshotStateFault(crate::error::InvalidDbSnapshotStateFault),
    /// <p>You have exceeded the maximum number of accounts that you can share a manual DB snapshot with.</p>
    SharedSnapshotQuotaExceededFault(crate::error::SharedSnapshotQuotaExceededFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ModifyDBSnapshotAttributeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ModifyDBSnapshotAttributeErrorKind::DbSnapshotNotFoundFault(_inner) => _inner.fmt(f),
            ModifyDBSnapshotAttributeErrorKind::InvalidDbSnapshotStateFault(_inner) => {
                _inner.fmt(f)
            }
            ModifyDBSnapshotAttributeErrorKind::SharedSnapshotQuotaExceededFault(_inner) => {
                _inner.fmt(f)
            }
            ModifyDBSnapshotAttributeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ModifyDBSnapshotAttributeError {
    fn code(&self) -> Option<&str> {
        ModifyDBSnapshotAttributeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ModifyDBSnapshotAttributeError {
    /// Creates a new `ModifyDBSnapshotAttributeError`.
    pub fn new(kind: ModifyDBSnapshotAttributeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ModifyDBSnapshotAttributeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ModifyDBSnapshotAttributeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ModifyDBSnapshotAttributeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ModifyDBSnapshotAttributeErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ModifyDBSnapshotAttributeErrorKind::DbSnapshotNotFoundFault`.
    pub fn is_db_snapshot_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyDBSnapshotAttributeErrorKind::DbSnapshotNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyDBSnapshotAttributeErrorKind::InvalidDbSnapshotStateFault`.
    pub fn is_invalid_db_snapshot_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyDBSnapshotAttributeErrorKind::InvalidDbSnapshotStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyDBSnapshotAttributeErrorKind::SharedSnapshotQuotaExceededFault`.
    pub fn is_shared_snapshot_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyDBSnapshotAttributeErrorKind::SharedSnapshotQuotaExceededFault(_)
        )
    }
}
impl std::error::Error for ModifyDBSnapshotAttributeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ModifyDBSnapshotAttributeErrorKind::DbSnapshotNotFoundFault(_inner) => Some(_inner),
            ModifyDBSnapshotAttributeErrorKind::InvalidDbSnapshotStateFault(_inner) => Some(_inner),
            ModifyDBSnapshotAttributeErrorKind::SharedSnapshotQuotaExceededFault(_inner) => {
                Some(_inner)
            }
            ModifyDBSnapshotAttributeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ModifyDBSubnetGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ModifyDBSubnetGroupError {
    /// Kind of error that occurred.
    pub kind: ModifyDBSubnetGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ModifyDBSubnetGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ModifyDBSubnetGroupErrorKind {
    /// <p>Subnets in the DB subnet group should cover at least two Availability Zones unless there is only one Availability Zone.</p>
    DbSubnetGroupDoesNotCoverEnoughAZs(crate::error::DbSubnetGroupDoesNotCoverEnoughAZs),
    /// <p> <code>DBSubnetGroupName</code> doesn't refer to an existing DB subnet group. </p>
    DbSubnetGroupNotFoundFault(crate::error::DbSubnetGroupNotFoundFault),
    /// <p>The request would result in the user exceeding the allowed number of subnets in a DB subnet groups.</p>
    DbSubnetQuotaExceededFault(crate::error::DbSubnetQuotaExceededFault),
    /// <p>The requested subnet is invalid, or multiple subnets were requested that are not all in a common VPC.</p>
    InvalidSubnet(crate::error::InvalidSubnet),
    /// <p>The DB subnet is already in use in the Availability Zone.</p>
    SubnetAlreadyInUse(crate::error::SubnetAlreadyInUse),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ModifyDBSubnetGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ModifyDBSubnetGroupErrorKind::DbSubnetGroupDoesNotCoverEnoughAZs(_inner) => {
                _inner.fmt(f)
            }
            ModifyDBSubnetGroupErrorKind::DbSubnetGroupNotFoundFault(_inner) => _inner.fmt(f),
            ModifyDBSubnetGroupErrorKind::DbSubnetQuotaExceededFault(_inner) => _inner.fmt(f),
            ModifyDBSubnetGroupErrorKind::InvalidSubnet(_inner) => _inner.fmt(f),
            ModifyDBSubnetGroupErrorKind::SubnetAlreadyInUse(_inner) => _inner.fmt(f),
            ModifyDBSubnetGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ModifyDBSubnetGroupError {
    fn code(&self) -> Option<&str> {
        ModifyDBSubnetGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ModifyDBSubnetGroupError {
    /// Creates a new `ModifyDBSubnetGroupError`.
    pub fn new(kind: ModifyDBSubnetGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ModifyDBSubnetGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ModifyDBSubnetGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ModifyDBSubnetGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ModifyDBSubnetGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ModifyDBSubnetGroupErrorKind::DbSubnetGroupDoesNotCoverEnoughAZs`.
    pub fn is_db_subnet_group_does_not_cover_enough_a_zs(&self) -> bool {
        matches!(
            &self.kind,
            ModifyDBSubnetGroupErrorKind::DbSubnetGroupDoesNotCoverEnoughAZs(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyDBSubnetGroupErrorKind::DbSubnetGroupNotFoundFault`.
    pub fn is_db_subnet_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyDBSubnetGroupErrorKind::DbSubnetGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyDBSubnetGroupErrorKind::DbSubnetQuotaExceededFault`.
    pub fn is_db_subnet_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyDBSubnetGroupErrorKind::DbSubnetQuotaExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyDBSubnetGroupErrorKind::InvalidSubnet`.
    pub fn is_invalid_subnet(&self) -> bool {
        matches!(&self.kind, ModifyDBSubnetGroupErrorKind::InvalidSubnet(_))
    }
    /// Returns `true` if the error kind is `ModifyDBSubnetGroupErrorKind::SubnetAlreadyInUse`.
    pub fn is_subnet_already_in_use(&self) -> bool {
        matches!(
            &self.kind,
            ModifyDBSubnetGroupErrorKind::SubnetAlreadyInUse(_)
        )
    }
}
impl std::error::Error for ModifyDBSubnetGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ModifyDBSubnetGroupErrorKind::DbSubnetGroupDoesNotCoverEnoughAZs(_inner) => {
                Some(_inner)
            }
            ModifyDBSubnetGroupErrorKind::DbSubnetGroupNotFoundFault(_inner) => Some(_inner),
            ModifyDBSubnetGroupErrorKind::DbSubnetQuotaExceededFault(_inner) => Some(_inner),
            ModifyDBSubnetGroupErrorKind::InvalidSubnet(_inner) => Some(_inner),
            ModifyDBSubnetGroupErrorKind::SubnetAlreadyInUse(_inner) => Some(_inner),
            ModifyDBSubnetGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ModifyEventSubscription` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ModifyEventSubscriptionError {
    /// Kind of error that occurred.
    pub kind: ModifyEventSubscriptionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ModifyEventSubscription` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ModifyEventSubscriptionErrorKind {
    /// <p>You have reached the maximum number of event subscriptions.</p>
    EventSubscriptionQuotaExceededFault(crate::error::EventSubscriptionQuotaExceededFault),
    /// <p>SNS has responded that there is a problem with the SND topic specified.</p>
    SnsInvalidTopicFault(crate::error::SnsInvalidTopicFault),
    /// <p>You do not have permission to publish to the SNS topic ARN.</p>
    SnsNoAuthorizationFault(crate::error::SnsNoAuthorizationFault),
    /// <p>The SNS topic ARN does not exist.</p>
    SnsTopicArnNotFoundFault(crate::error::SnsTopicArnNotFoundFault),
    /// <p>The supplied category does not exist.</p>
    SubscriptionCategoryNotFoundFault(crate::error::SubscriptionCategoryNotFoundFault),
    /// <p>The subscription name does not exist.</p>
    SubscriptionNotFoundFault(crate::error::SubscriptionNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ModifyEventSubscriptionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ModifyEventSubscriptionErrorKind::EventSubscriptionQuotaExceededFault(_inner) => {
                _inner.fmt(f)
            }
            ModifyEventSubscriptionErrorKind::SnsInvalidTopicFault(_inner) => _inner.fmt(f),
            ModifyEventSubscriptionErrorKind::SnsNoAuthorizationFault(_inner) => _inner.fmt(f),
            ModifyEventSubscriptionErrorKind::SnsTopicArnNotFoundFault(_inner) => _inner.fmt(f),
            ModifyEventSubscriptionErrorKind::SubscriptionCategoryNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            ModifyEventSubscriptionErrorKind::SubscriptionNotFoundFault(_inner) => _inner.fmt(f),
            ModifyEventSubscriptionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ModifyEventSubscriptionError {
    fn code(&self) -> Option<&str> {
        ModifyEventSubscriptionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ModifyEventSubscriptionError {
    /// Creates a new `ModifyEventSubscriptionError`.
    pub fn new(kind: ModifyEventSubscriptionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ModifyEventSubscriptionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ModifyEventSubscriptionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ModifyEventSubscriptionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ModifyEventSubscriptionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ModifyEventSubscriptionErrorKind::EventSubscriptionQuotaExceededFault`.
    pub fn is_event_subscription_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyEventSubscriptionErrorKind::EventSubscriptionQuotaExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyEventSubscriptionErrorKind::SnsInvalidTopicFault`.
    pub fn is_sns_invalid_topic_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyEventSubscriptionErrorKind::SnsInvalidTopicFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyEventSubscriptionErrorKind::SnsNoAuthorizationFault`.
    pub fn is_sns_no_authorization_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyEventSubscriptionErrorKind::SnsNoAuthorizationFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyEventSubscriptionErrorKind::SnsTopicArnNotFoundFault`.
    pub fn is_sns_topic_arn_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyEventSubscriptionErrorKind::SnsTopicArnNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyEventSubscriptionErrorKind::SubscriptionCategoryNotFoundFault`.
    pub fn is_subscription_category_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyEventSubscriptionErrorKind::SubscriptionCategoryNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyEventSubscriptionErrorKind::SubscriptionNotFoundFault`.
    pub fn is_subscription_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyEventSubscriptionErrorKind::SubscriptionNotFoundFault(_)
        )
    }
}
impl std::error::Error for ModifyEventSubscriptionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ModifyEventSubscriptionErrorKind::EventSubscriptionQuotaExceededFault(_inner) => {
                Some(_inner)
            }
            ModifyEventSubscriptionErrorKind::SnsInvalidTopicFault(_inner) => Some(_inner),
            ModifyEventSubscriptionErrorKind::SnsNoAuthorizationFault(_inner) => Some(_inner),
            ModifyEventSubscriptionErrorKind::SnsTopicArnNotFoundFault(_inner) => Some(_inner),
            ModifyEventSubscriptionErrorKind::SubscriptionCategoryNotFoundFault(_inner) => {
                Some(_inner)
            }
            ModifyEventSubscriptionErrorKind::SubscriptionNotFoundFault(_inner) => Some(_inner),
            ModifyEventSubscriptionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ModifyGlobalCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ModifyGlobalClusterError {
    /// Kind of error that occurred.
    pub kind: ModifyGlobalClusterErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ModifyGlobalCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ModifyGlobalClusterErrorKind {
    /// <p>The <code>GlobalClusterIdentifier</code> doesn't refer to an existing global database cluster. </p>
    GlobalClusterNotFoundFault(crate::error::GlobalClusterNotFoundFault),
    /// <p>The requested operation can't be performed while the cluster is in this state.</p>
    InvalidDbClusterStateFault(crate::error::InvalidDbClusterStateFault),
    /// <p>The DB instance isn't in a valid state.</p>
    InvalidDbInstanceStateFault(crate::error::InvalidDbInstanceStateFault),
    /// <p>The global cluster is in an invalid state and can't perform the requested operation. </p>
    InvalidGlobalClusterStateFault(crate::error::InvalidGlobalClusterStateFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ModifyGlobalClusterError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ModifyGlobalClusterErrorKind::GlobalClusterNotFoundFault(_inner) => _inner.fmt(f),
            ModifyGlobalClusterErrorKind::InvalidDbClusterStateFault(_inner) => _inner.fmt(f),
            ModifyGlobalClusterErrorKind::InvalidDbInstanceStateFault(_inner) => _inner.fmt(f),
            ModifyGlobalClusterErrorKind::InvalidGlobalClusterStateFault(_inner) => _inner.fmt(f),
            ModifyGlobalClusterErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ModifyGlobalClusterError {
    fn code(&self) -> Option<&str> {
        ModifyGlobalClusterError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ModifyGlobalClusterError {
    /// Creates a new `ModifyGlobalClusterError`.
    pub fn new(kind: ModifyGlobalClusterErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ModifyGlobalClusterError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ModifyGlobalClusterErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ModifyGlobalClusterError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ModifyGlobalClusterErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ModifyGlobalClusterErrorKind::GlobalClusterNotFoundFault`.
    pub fn is_global_cluster_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyGlobalClusterErrorKind::GlobalClusterNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyGlobalClusterErrorKind::InvalidDbClusterStateFault`.
    pub fn is_invalid_db_cluster_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyGlobalClusterErrorKind::InvalidDbClusterStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyGlobalClusterErrorKind::InvalidDbInstanceStateFault`.
    pub fn is_invalid_db_instance_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyGlobalClusterErrorKind::InvalidDbInstanceStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyGlobalClusterErrorKind::InvalidGlobalClusterStateFault`.
    pub fn is_invalid_global_cluster_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyGlobalClusterErrorKind::InvalidGlobalClusterStateFault(_)
        )
    }
}
impl std::error::Error for ModifyGlobalClusterError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ModifyGlobalClusterErrorKind::GlobalClusterNotFoundFault(_inner) => Some(_inner),
            ModifyGlobalClusterErrorKind::InvalidDbClusterStateFault(_inner) => Some(_inner),
            ModifyGlobalClusterErrorKind::InvalidDbInstanceStateFault(_inner) => Some(_inner),
            ModifyGlobalClusterErrorKind::InvalidGlobalClusterStateFault(_inner) => Some(_inner),
            ModifyGlobalClusterErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ModifyOptionGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ModifyOptionGroupError {
    /// Kind of error that occurred.
    pub kind: ModifyOptionGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ModifyOptionGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ModifyOptionGroupErrorKind {
    /// <p> The option group isn't in the <i>available</i> state. </p>
    InvalidOptionGroupStateFault(crate::error::InvalidOptionGroupStateFault),
    /// <p>The specified option group could not be found.</p>
    OptionGroupNotFoundFault(crate::error::OptionGroupNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ModifyOptionGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ModifyOptionGroupErrorKind::InvalidOptionGroupStateFault(_inner) => _inner.fmt(f),
            ModifyOptionGroupErrorKind::OptionGroupNotFoundFault(_inner) => _inner.fmt(f),
            ModifyOptionGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ModifyOptionGroupError {
    fn code(&self) -> Option<&str> {
        ModifyOptionGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ModifyOptionGroupError {
    /// Creates a new `ModifyOptionGroupError`.
    pub fn new(kind: ModifyOptionGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ModifyOptionGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ModifyOptionGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ModifyOptionGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ModifyOptionGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ModifyOptionGroupErrorKind::InvalidOptionGroupStateFault`.
    pub fn is_invalid_option_group_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyOptionGroupErrorKind::InvalidOptionGroupStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `ModifyOptionGroupErrorKind::OptionGroupNotFoundFault`.
    pub fn is_option_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            ModifyOptionGroupErrorKind::OptionGroupNotFoundFault(_)
        )
    }
}
impl std::error::Error for ModifyOptionGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ModifyOptionGroupErrorKind::InvalidOptionGroupStateFault(_inner) => Some(_inner),
            ModifyOptionGroupErrorKind::OptionGroupNotFoundFault(_inner) => Some(_inner),
            ModifyOptionGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PromoteReadReplica` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PromoteReadReplicaError {
    /// Kind of error that occurred.
    pub kind: PromoteReadReplicaErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PromoteReadReplica` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PromoteReadReplicaErrorKind {
    /// <p> <code>DBInstanceIdentifier</code> doesn't refer to an existing DB instance. </p>
    DbInstanceNotFoundFault(crate::error::DbInstanceNotFoundFault),
    /// <p>The DB instance isn't in a valid state.</p>
    InvalidDbInstanceStateFault(crate::error::InvalidDbInstanceStateFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PromoteReadReplicaError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PromoteReadReplicaErrorKind::DbInstanceNotFoundFault(_inner) => _inner.fmt(f),
            PromoteReadReplicaErrorKind::InvalidDbInstanceStateFault(_inner) => _inner.fmt(f),
            PromoteReadReplicaErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PromoteReadReplicaError {
    fn code(&self) -> Option<&str> {
        PromoteReadReplicaError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PromoteReadReplicaError {
    /// Creates a new `PromoteReadReplicaError`.
    pub fn new(kind: PromoteReadReplicaErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PromoteReadReplicaError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PromoteReadReplicaErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PromoteReadReplicaError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PromoteReadReplicaErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PromoteReadReplicaErrorKind::DbInstanceNotFoundFault`.
    pub fn is_db_instance_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            PromoteReadReplicaErrorKind::DbInstanceNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `PromoteReadReplicaErrorKind::InvalidDbInstanceStateFault`.
    pub fn is_invalid_db_instance_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            PromoteReadReplicaErrorKind::InvalidDbInstanceStateFault(_)
        )
    }
}
impl std::error::Error for PromoteReadReplicaError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PromoteReadReplicaErrorKind::DbInstanceNotFoundFault(_inner) => Some(_inner),
            PromoteReadReplicaErrorKind::InvalidDbInstanceStateFault(_inner) => Some(_inner),
            PromoteReadReplicaErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PromoteReadReplicaDBCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PromoteReadReplicaDBClusterError {
    /// Kind of error that occurred.
    pub kind: PromoteReadReplicaDBClusterErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PromoteReadReplicaDBCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PromoteReadReplicaDBClusterErrorKind {
    /// <p> <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster. </p>
    DbClusterNotFoundFault(crate::error::DbClusterNotFoundFault),
    /// <p>The requested operation can't be performed while the cluster is in this state.</p>
    InvalidDbClusterStateFault(crate::error::InvalidDbClusterStateFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PromoteReadReplicaDBClusterError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PromoteReadReplicaDBClusterErrorKind::DbClusterNotFoundFault(_inner) => _inner.fmt(f),
            PromoteReadReplicaDBClusterErrorKind::InvalidDbClusterStateFault(_inner) => {
                _inner.fmt(f)
            }
            PromoteReadReplicaDBClusterErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PromoteReadReplicaDBClusterError {
    fn code(&self) -> Option<&str> {
        PromoteReadReplicaDBClusterError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PromoteReadReplicaDBClusterError {
    /// Creates a new `PromoteReadReplicaDBClusterError`.
    pub fn new(kind: PromoteReadReplicaDBClusterErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PromoteReadReplicaDBClusterError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PromoteReadReplicaDBClusterErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PromoteReadReplicaDBClusterError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PromoteReadReplicaDBClusterErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PromoteReadReplicaDBClusterErrorKind::DbClusterNotFoundFault`.
    pub fn is_db_cluster_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            PromoteReadReplicaDBClusterErrorKind::DbClusterNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `PromoteReadReplicaDBClusterErrorKind::InvalidDbClusterStateFault`.
    pub fn is_invalid_db_cluster_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            PromoteReadReplicaDBClusterErrorKind::InvalidDbClusterStateFault(_)
        )
    }
}
impl std::error::Error for PromoteReadReplicaDBClusterError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PromoteReadReplicaDBClusterErrorKind::DbClusterNotFoundFault(_inner) => Some(_inner),
            PromoteReadReplicaDBClusterErrorKind::InvalidDbClusterStateFault(_inner) => {
                Some(_inner)
            }
            PromoteReadReplicaDBClusterErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PurchaseReservedDBInstancesOffering` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PurchaseReservedDBInstancesOfferingError {
    /// Kind of error that occurred.
    pub kind: PurchaseReservedDBInstancesOfferingErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PurchaseReservedDBInstancesOffering` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PurchaseReservedDBInstancesOfferingErrorKind {
    /// <p>User already has a reservation with the given identifier.</p>
    ReservedDbInstanceAlreadyExistsFault(crate::error::ReservedDbInstanceAlreadyExistsFault),
    /// <p>Request would exceed the user's DB Instance quota.</p>
    ReservedDbInstanceQuotaExceededFault(crate::error::ReservedDbInstanceQuotaExceededFault),
    /// <p>Specified offering does not exist.</p>
    ReservedDbInstancesOfferingNotFoundFault(
        crate::error::ReservedDbInstancesOfferingNotFoundFault,
    ),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PurchaseReservedDBInstancesOfferingError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PurchaseReservedDBInstancesOfferingErrorKind::ReservedDbInstanceAlreadyExistsFault(_inner) =>
            _inner.fmt(f)
            ,
            PurchaseReservedDBInstancesOfferingErrorKind::ReservedDbInstanceQuotaExceededFault(_inner) =>
            _inner.fmt(f)
            ,
            PurchaseReservedDBInstancesOfferingErrorKind::ReservedDbInstancesOfferingNotFoundFault(_inner) =>
            _inner.fmt(f)
            ,
            PurchaseReservedDBInstancesOfferingErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PurchaseReservedDBInstancesOfferingError {
    fn code(&self) -> Option<&str> {
        PurchaseReservedDBInstancesOfferingError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PurchaseReservedDBInstancesOfferingError {
    /// Creates a new `PurchaseReservedDBInstancesOfferingError`.
    pub fn new(
        kind: PurchaseReservedDBInstancesOfferingErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PurchaseReservedDBInstancesOfferingError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PurchaseReservedDBInstancesOfferingErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PurchaseReservedDBInstancesOfferingError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PurchaseReservedDBInstancesOfferingErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PurchaseReservedDBInstancesOfferingErrorKind::ReservedDbInstanceAlreadyExistsFault`.
    pub fn is_reserved_db_instance_already_exists_fault(&self) -> bool {
        matches!(
            &self.kind,
            PurchaseReservedDBInstancesOfferingErrorKind::ReservedDbInstanceAlreadyExistsFault(_)
        )
    }
    /// Returns `true` if the error kind is `PurchaseReservedDBInstancesOfferingErrorKind::ReservedDbInstanceQuotaExceededFault`.
    pub fn is_reserved_db_instance_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            PurchaseReservedDBInstancesOfferingErrorKind::ReservedDbInstanceQuotaExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `PurchaseReservedDBInstancesOfferingErrorKind::ReservedDbInstancesOfferingNotFoundFault`.
    pub fn is_reserved_db_instances_offering_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            PurchaseReservedDBInstancesOfferingErrorKind::ReservedDbInstancesOfferingNotFoundFault(
                _
            )
        )
    }
}
impl std::error::Error for PurchaseReservedDBInstancesOfferingError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PurchaseReservedDBInstancesOfferingErrorKind::ReservedDbInstanceAlreadyExistsFault(_inner) =>
            Some(_inner)
            ,
            PurchaseReservedDBInstancesOfferingErrorKind::ReservedDbInstanceQuotaExceededFault(_inner) =>
            Some(_inner)
            ,
            PurchaseReservedDBInstancesOfferingErrorKind::ReservedDbInstancesOfferingNotFoundFault(_inner) =>
            Some(_inner)
            ,
            PurchaseReservedDBInstancesOfferingErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `RebootDBCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RebootDBClusterError {
    /// Kind of error that occurred.
    pub kind: RebootDBClusterErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RebootDBCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RebootDBClusterErrorKind {
    /// <p> <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster. </p>
    DbClusterNotFoundFault(crate::error::DbClusterNotFoundFault),
    /// <p>The requested operation can't be performed while the cluster is in this state.</p>
    InvalidDbClusterStateFault(crate::error::InvalidDbClusterStateFault),
    /// <p>The DB instance isn't in a valid state.</p>
    InvalidDbInstanceStateFault(crate::error::InvalidDbInstanceStateFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RebootDBClusterError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RebootDBClusterErrorKind::DbClusterNotFoundFault(_inner) => _inner.fmt(f),
            RebootDBClusterErrorKind::InvalidDbClusterStateFault(_inner) => _inner.fmt(f),
            RebootDBClusterErrorKind::InvalidDbInstanceStateFault(_inner) => _inner.fmt(f),
            RebootDBClusterErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RebootDBClusterError {
    fn code(&self) -> Option<&str> {
        RebootDBClusterError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RebootDBClusterError {
    /// Creates a new `RebootDBClusterError`.
    pub fn new(kind: RebootDBClusterErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RebootDBClusterError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RebootDBClusterErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RebootDBClusterError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RebootDBClusterErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RebootDBClusterErrorKind::DbClusterNotFoundFault`.
    pub fn is_db_cluster_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            RebootDBClusterErrorKind::DbClusterNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `RebootDBClusterErrorKind::InvalidDbClusterStateFault`.
    pub fn is_invalid_db_cluster_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            RebootDBClusterErrorKind::InvalidDbClusterStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `RebootDBClusterErrorKind::InvalidDbInstanceStateFault`.
    pub fn is_invalid_db_instance_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            RebootDBClusterErrorKind::InvalidDbInstanceStateFault(_)
        )
    }
}
impl std::error::Error for RebootDBClusterError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RebootDBClusterErrorKind::DbClusterNotFoundFault(_inner) => Some(_inner),
            RebootDBClusterErrorKind::InvalidDbClusterStateFault(_inner) => Some(_inner),
            RebootDBClusterErrorKind::InvalidDbInstanceStateFault(_inner) => Some(_inner),
            RebootDBClusterErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RebootDBInstance` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RebootDBInstanceError {
    /// Kind of error that occurred.
    pub kind: RebootDBInstanceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RebootDBInstance` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RebootDBInstanceErrorKind {
    /// <p> <code>DBInstanceIdentifier</code> doesn't refer to an existing DB instance. </p>
    DbInstanceNotFoundFault(crate::error::DbInstanceNotFoundFault),
    /// <p>The DB instance isn't in a valid state.</p>
    InvalidDbInstanceStateFault(crate::error::InvalidDbInstanceStateFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RebootDBInstanceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RebootDBInstanceErrorKind::DbInstanceNotFoundFault(_inner) => _inner.fmt(f),
            RebootDBInstanceErrorKind::InvalidDbInstanceStateFault(_inner) => _inner.fmt(f),
            RebootDBInstanceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RebootDBInstanceError {
    fn code(&self) -> Option<&str> {
        RebootDBInstanceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RebootDBInstanceError {
    /// Creates a new `RebootDBInstanceError`.
    pub fn new(kind: RebootDBInstanceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RebootDBInstanceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RebootDBInstanceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RebootDBInstanceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RebootDBInstanceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RebootDBInstanceErrorKind::DbInstanceNotFoundFault`.
    pub fn is_db_instance_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            RebootDBInstanceErrorKind::DbInstanceNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `RebootDBInstanceErrorKind::InvalidDbInstanceStateFault`.
    pub fn is_invalid_db_instance_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            RebootDBInstanceErrorKind::InvalidDbInstanceStateFault(_)
        )
    }
}
impl std::error::Error for RebootDBInstanceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RebootDBInstanceErrorKind::DbInstanceNotFoundFault(_inner) => Some(_inner),
            RebootDBInstanceErrorKind::InvalidDbInstanceStateFault(_inner) => Some(_inner),
            RebootDBInstanceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RegisterDBProxyTargets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RegisterDBProxyTargetsError {
    /// Kind of error that occurred.
    pub kind: RegisterDBProxyTargetsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RegisterDBProxyTargets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RegisterDBProxyTargetsErrorKind {
    /// <p> <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster. </p>
    DbClusterNotFoundFault(crate::error::DbClusterNotFoundFault),
    /// <p> <code>DBInstanceIdentifier</code> doesn't refer to an existing DB instance. </p>
    DbInstanceNotFoundFault(crate::error::DbInstanceNotFoundFault),
    /// <p>The specified proxy name doesn't correspond to a proxy owned by your Amazon Web Services account in the specified Amazon Web Services Region.</p>
    DbProxyNotFoundFault(crate::error::DbProxyNotFoundFault),
    /// <p>The proxy is already associated with the specified RDS DB instance or Aurora DB cluster.</p>
    DbProxyTargetAlreadyRegisteredFault(crate::error::DbProxyTargetAlreadyRegisteredFault),
    /// <p>The specified target group isn't available for a proxy owned by your Amazon Web Services account in the specified Amazon Web Services Region.</p>
    DbProxyTargetGroupNotFoundFault(crate::error::DbProxyTargetGroupNotFoundFault),
    /// <p>The requested operation can't be performed because there aren't enough available IP addresses in the proxy's subnets. Add more CIDR blocks to the VPC or remove IP address that aren't required from the subnets.</p>
    InsufficientAvailableIPsInSubnetFault(crate::error::InsufficientAvailableIPsInSubnetFault),
    /// <p>The requested operation can't be performed while the cluster is in this state.</p>
    InvalidDbClusterStateFault(crate::error::InvalidDbClusterStateFault),
    /// <p>The DB instance isn't in a valid state.</p>
    InvalidDbInstanceStateFault(crate::error::InvalidDbInstanceStateFault),
    /// <p>The requested operation can't be performed while the proxy is in this state.</p>
    InvalidDbProxyStateFault(crate::error::InvalidDbProxyStateFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RegisterDBProxyTargetsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RegisterDBProxyTargetsErrorKind::DbClusterNotFoundFault(_inner) => _inner.fmt(f),
            RegisterDBProxyTargetsErrorKind::DbInstanceNotFoundFault(_inner) => _inner.fmt(f),
            RegisterDBProxyTargetsErrorKind::DbProxyNotFoundFault(_inner) => _inner.fmt(f),
            RegisterDBProxyTargetsErrorKind::DbProxyTargetAlreadyRegisteredFault(_inner) => {
                _inner.fmt(f)
            }
            RegisterDBProxyTargetsErrorKind::DbProxyTargetGroupNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            RegisterDBProxyTargetsErrorKind::InsufficientAvailableIPsInSubnetFault(_inner) => {
                _inner.fmt(f)
            }
            RegisterDBProxyTargetsErrorKind::InvalidDbClusterStateFault(_inner) => _inner.fmt(f),
            RegisterDBProxyTargetsErrorKind::InvalidDbInstanceStateFault(_inner) => _inner.fmt(f),
            RegisterDBProxyTargetsErrorKind::InvalidDbProxyStateFault(_inner) => _inner.fmt(f),
            RegisterDBProxyTargetsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RegisterDBProxyTargetsError {
    fn code(&self) -> Option<&str> {
        RegisterDBProxyTargetsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RegisterDBProxyTargetsError {
    /// Creates a new `RegisterDBProxyTargetsError`.
    pub fn new(kind: RegisterDBProxyTargetsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RegisterDBProxyTargetsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RegisterDBProxyTargetsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RegisterDBProxyTargetsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RegisterDBProxyTargetsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RegisterDBProxyTargetsErrorKind::DbClusterNotFoundFault`.
    pub fn is_db_cluster_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            RegisterDBProxyTargetsErrorKind::DbClusterNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterDBProxyTargetsErrorKind::DbInstanceNotFoundFault`.
    pub fn is_db_instance_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            RegisterDBProxyTargetsErrorKind::DbInstanceNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterDBProxyTargetsErrorKind::DbProxyNotFoundFault`.
    pub fn is_db_proxy_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            RegisterDBProxyTargetsErrorKind::DbProxyNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterDBProxyTargetsErrorKind::DbProxyTargetAlreadyRegisteredFault`.
    pub fn is_db_proxy_target_already_registered_fault(&self) -> bool {
        matches!(
            &self.kind,
            RegisterDBProxyTargetsErrorKind::DbProxyTargetAlreadyRegisteredFault(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterDBProxyTargetsErrorKind::DbProxyTargetGroupNotFoundFault`.
    pub fn is_db_proxy_target_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            RegisterDBProxyTargetsErrorKind::DbProxyTargetGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterDBProxyTargetsErrorKind::InsufficientAvailableIPsInSubnetFault`.
    pub fn is_insufficient_available_i_ps_in_subnet_fault(&self) -> bool {
        matches!(
            &self.kind,
            RegisterDBProxyTargetsErrorKind::InsufficientAvailableIPsInSubnetFault(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterDBProxyTargetsErrorKind::InvalidDbClusterStateFault`.
    pub fn is_invalid_db_cluster_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            RegisterDBProxyTargetsErrorKind::InvalidDbClusterStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterDBProxyTargetsErrorKind::InvalidDbInstanceStateFault`.
    pub fn is_invalid_db_instance_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            RegisterDBProxyTargetsErrorKind::InvalidDbInstanceStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `RegisterDBProxyTargetsErrorKind::InvalidDbProxyStateFault`.
    pub fn is_invalid_db_proxy_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            RegisterDBProxyTargetsErrorKind::InvalidDbProxyStateFault(_)
        )
    }
}
impl std::error::Error for RegisterDBProxyTargetsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RegisterDBProxyTargetsErrorKind::DbClusterNotFoundFault(_inner) => Some(_inner),
            RegisterDBProxyTargetsErrorKind::DbInstanceNotFoundFault(_inner) => Some(_inner),
            RegisterDBProxyTargetsErrorKind::DbProxyNotFoundFault(_inner) => Some(_inner),
            RegisterDBProxyTargetsErrorKind::DbProxyTargetAlreadyRegisteredFault(_inner) => {
                Some(_inner)
            }
            RegisterDBProxyTargetsErrorKind::DbProxyTargetGroupNotFoundFault(_inner) => {
                Some(_inner)
            }
            RegisterDBProxyTargetsErrorKind::InsufficientAvailableIPsInSubnetFault(_inner) => {
                Some(_inner)
            }
            RegisterDBProxyTargetsErrorKind::InvalidDbClusterStateFault(_inner) => Some(_inner),
            RegisterDBProxyTargetsErrorKind::InvalidDbInstanceStateFault(_inner) => Some(_inner),
            RegisterDBProxyTargetsErrorKind::InvalidDbProxyStateFault(_inner) => Some(_inner),
            RegisterDBProxyTargetsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RemoveFromGlobalCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RemoveFromGlobalClusterError {
    /// Kind of error that occurred.
    pub kind: RemoveFromGlobalClusterErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RemoveFromGlobalCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RemoveFromGlobalClusterErrorKind {
    /// <p> <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster. </p>
    DbClusterNotFoundFault(crate::error::DbClusterNotFoundFault),
    /// <p>The <code>GlobalClusterIdentifier</code> doesn't refer to an existing global database cluster. </p>
    GlobalClusterNotFoundFault(crate::error::GlobalClusterNotFoundFault),
    /// <p>The global cluster is in an invalid state and can't perform the requested operation. </p>
    InvalidGlobalClusterStateFault(crate::error::InvalidGlobalClusterStateFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RemoveFromGlobalClusterError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RemoveFromGlobalClusterErrorKind::DbClusterNotFoundFault(_inner) => _inner.fmt(f),
            RemoveFromGlobalClusterErrorKind::GlobalClusterNotFoundFault(_inner) => _inner.fmt(f),
            RemoveFromGlobalClusterErrorKind::InvalidGlobalClusterStateFault(_inner) => {
                _inner.fmt(f)
            }
            RemoveFromGlobalClusterErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RemoveFromGlobalClusterError {
    fn code(&self) -> Option<&str> {
        RemoveFromGlobalClusterError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RemoveFromGlobalClusterError {
    /// Creates a new `RemoveFromGlobalClusterError`.
    pub fn new(kind: RemoveFromGlobalClusterErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RemoveFromGlobalClusterError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RemoveFromGlobalClusterErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RemoveFromGlobalClusterError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RemoveFromGlobalClusterErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RemoveFromGlobalClusterErrorKind::DbClusterNotFoundFault`.
    pub fn is_db_cluster_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            RemoveFromGlobalClusterErrorKind::DbClusterNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveFromGlobalClusterErrorKind::GlobalClusterNotFoundFault`.
    pub fn is_global_cluster_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            RemoveFromGlobalClusterErrorKind::GlobalClusterNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveFromGlobalClusterErrorKind::InvalidGlobalClusterStateFault`.
    pub fn is_invalid_global_cluster_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            RemoveFromGlobalClusterErrorKind::InvalidGlobalClusterStateFault(_)
        )
    }
}
impl std::error::Error for RemoveFromGlobalClusterError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RemoveFromGlobalClusterErrorKind::DbClusterNotFoundFault(_inner) => Some(_inner),
            RemoveFromGlobalClusterErrorKind::GlobalClusterNotFoundFault(_inner) => Some(_inner),
            RemoveFromGlobalClusterErrorKind::InvalidGlobalClusterStateFault(_inner) => {
                Some(_inner)
            }
            RemoveFromGlobalClusterErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RemoveRoleFromDBCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RemoveRoleFromDBClusterError {
    /// Kind of error that occurred.
    pub kind: RemoveRoleFromDBClusterErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RemoveRoleFromDBCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RemoveRoleFromDBClusterErrorKind {
    /// <p> <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster. </p>
    DbClusterNotFoundFault(crate::error::DbClusterNotFoundFault),
    /// <p>The specified IAM role Amazon Resource Name (ARN) isn't associated with the specified DB cluster.</p>
    DbClusterRoleNotFoundFault(crate::error::DbClusterRoleNotFoundFault),
    /// <p>The requested operation can't be performed while the cluster is in this state.</p>
    InvalidDbClusterStateFault(crate::error::InvalidDbClusterStateFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RemoveRoleFromDBClusterError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RemoveRoleFromDBClusterErrorKind::DbClusterNotFoundFault(_inner) => _inner.fmt(f),
            RemoveRoleFromDBClusterErrorKind::DbClusterRoleNotFoundFault(_inner) => _inner.fmt(f),
            RemoveRoleFromDBClusterErrorKind::InvalidDbClusterStateFault(_inner) => _inner.fmt(f),
            RemoveRoleFromDBClusterErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RemoveRoleFromDBClusterError {
    fn code(&self) -> Option<&str> {
        RemoveRoleFromDBClusterError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RemoveRoleFromDBClusterError {
    /// Creates a new `RemoveRoleFromDBClusterError`.
    pub fn new(kind: RemoveRoleFromDBClusterErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RemoveRoleFromDBClusterError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RemoveRoleFromDBClusterErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RemoveRoleFromDBClusterError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RemoveRoleFromDBClusterErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RemoveRoleFromDBClusterErrorKind::DbClusterNotFoundFault`.
    pub fn is_db_cluster_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            RemoveRoleFromDBClusterErrorKind::DbClusterNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveRoleFromDBClusterErrorKind::DbClusterRoleNotFoundFault`.
    pub fn is_db_cluster_role_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            RemoveRoleFromDBClusterErrorKind::DbClusterRoleNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveRoleFromDBClusterErrorKind::InvalidDbClusterStateFault`.
    pub fn is_invalid_db_cluster_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            RemoveRoleFromDBClusterErrorKind::InvalidDbClusterStateFault(_)
        )
    }
}
impl std::error::Error for RemoveRoleFromDBClusterError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RemoveRoleFromDBClusterErrorKind::DbClusterNotFoundFault(_inner) => Some(_inner),
            RemoveRoleFromDBClusterErrorKind::DbClusterRoleNotFoundFault(_inner) => Some(_inner),
            RemoveRoleFromDBClusterErrorKind::InvalidDbClusterStateFault(_inner) => Some(_inner),
            RemoveRoleFromDBClusterErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RemoveRoleFromDBInstance` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RemoveRoleFromDBInstanceError {
    /// Kind of error that occurred.
    pub kind: RemoveRoleFromDBInstanceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RemoveRoleFromDBInstance` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RemoveRoleFromDBInstanceErrorKind {
    /// <p> <code>DBInstanceIdentifier</code> doesn't refer to an existing DB instance. </p>
    DbInstanceNotFoundFault(crate::error::DbInstanceNotFoundFault),
    /// <p>The specified <code>RoleArn</code> value doesn't match the specified feature for the DB instance.</p>
    DbInstanceRoleNotFoundFault(crate::error::DbInstanceRoleNotFoundFault),
    /// <p>The DB instance isn't in a valid state.</p>
    InvalidDbInstanceStateFault(crate::error::InvalidDbInstanceStateFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RemoveRoleFromDBInstanceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RemoveRoleFromDBInstanceErrorKind::DbInstanceNotFoundFault(_inner) => _inner.fmt(f),
            RemoveRoleFromDBInstanceErrorKind::DbInstanceRoleNotFoundFault(_inner) => _inner.fmt(f),
            RemoveRoleFromDBInstanceErrorKind::InvalidDbInstanceStateFault(_inner) => _inner.fmt(f),
            RemoveRoleFromDBInstanceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RemoveRoleFromDBInstanceError {
    fn code(&self) -> Option<&str> {
        RemoveRoleFromDBInstanceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RemoveRoleFromDBInstanceError {
    /// Creates a new `RemoveRoleFromDBInstanceError`.
    pub fn new(kind: RemoveRoleFromDBInstanceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RemoveRoleFromDBInstanceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RemoveRoleFromDBInstanceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RemoveRoleFromDBInstanceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RemoveRoleFromDBInstanceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RemoveRoleFromDBInstanceErrorKind::DbInstanceNotFoundFault`.
    pub fn is_db_instance_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            RemoveRoleFromDBInstanceErrorKind::DbInstanceNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveRoleFromDBInstanceErrorKind::DbInstanceRoleNotFoundFault`.
    pub fn is_db_instance_role_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            RemoveRoleFromDBInstanceErrorKind::DbInstanceRoleNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveRoleFromDBInstanceErrorKind::InvalidDbInstanceStateFault`.
    pub fn is_invalid_db_instance_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            RemoveRoleFromDBInstanceErrorKind::InvalidDbInstanceStateFault(_)
        )
    }
}
impl std::error::Error for RemoveRoleFromDBInstanceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RemoveRoleFromDBInstanceErrorKind::DbInstanceNotFoundFault(_inner) => Some(_inner),
            RemoveRoleFromDBInstanceErrorKind::DbInstanceRoleNotFoundFault(_inner) => Some(_inner),
            RemoveRoleFromDBInstanceErrorKind::InvalidDbInstanceStateFault(_inner) => Some(_inner),
            RemoveRoleFromDBInstanceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RemoveSourceIdentifierFromSubscription` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RemoveSourceIdentifierFromSubscriptionError {
    /// Kind of error that occurred.
    pub kind: RemoveSourceIdentifierFromSubscriptionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RemoveSourceIdentifierFromSubscription` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RemoveSourceIdentifierFromSubscriptionErrorKind {
    /// <p>The requested source could not be found.</p>
    SourceNotFoundFault(crate::error::SourceNotFoundFault),
    /// <p>The subscription name does not exist.</p>
    SubscriptionNotFoundFault(crate::error::SubscriptionNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RemoveSourceIdentifierFromSubscriptionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RemoveSourceIdentifierFromSubscriptionErrorKind::SourceNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            RemoveSourceIdentifierFromSubscriptionErrorKind::SubscriptionNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            RemoveSourceIdentifierFromSubscriptionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RemoveSourceIdentifierFromSubscriptionError {
    fn code(&self) -> Option<&str> {
        RemoveSourceIdentifierFromSubscriptionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RemoveSourceIdentifierFromSubscriptionError {
    /// Creates a new `RemoveSourceIdentifierFromSubscriptionError`.
    pub fn new(
        kind: RemoveSourceIdentifierFromSubscriptionErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RemoveSourceIdentifierFromSubscriptionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RemoveSourceIdentifierFromSubscriptionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RemoveSourceIdentifierFromSubscriptionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RemoveSourceIdentifierFromSubscriptionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RemoveSourceIdentifierFromSubscriptionErrorKind::SourceNotFoundFault`.
    pub fn is_source_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            RemoveSourceIdentifierFromSubscriptionErrorKind::SourceNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveSourceIdentifierFromSubscriptionErrorKind::SubscriptionNotFoundFault`.
    pub fn is_subscription_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            RemoveSourceIdentifierFromSubscriptionErrorKind::SubscriptionNotFoundFault(_)
        )
    }
}
impl std::error::Error for RemoveSourceIdentifierFromSubscriptionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RemoveSourceIdentifierFromSubscriptionErrorKind::SourceNotFoundFault(_inner) => {
                Some(_inner)
            }
            RemoveSourceIdentifierFromSubscriptionErrorKind::SubscriptionNotFoundFault(_inner) => {
                Some(_inner)
            }
            RemoveSourceIdentifierFromSubscriptionErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `RemoveTagsFromResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RemoveTagsFromResourceError {
    /// Kind of error that occurred.
    pub kind: RemoveTagsFromResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RemoveTagsFromResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RemoveTagsFromResourceErrorKind {
    /// <p> <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster. </p>
    DbClusterNotFoundFault(crate::error::DbClusterNotFoundFault),
    /// <p> <code>DBInstanceIdentifier</code> doesn't refer to an existing DB instance. </p>
    DbInstanceNotFoundFault(crate::error::DbInstanceNotFoundFault),
    /// <p>The specified proxy name doesn't correspond to a proxy owned by your Amazon Web Services account in the specified Amazon Web Services Region.</p>
    DbProxyNotFoundFault(crate::error::DbProxyNotFoundFault),
    /// <p>The specified target group isn't available for a proxy owned by your Amazon Web Services account in the specified Amazon Web Services Region.</p>
    DbProxyTargetGroupNotFoundFault(crate::error::DbProxyTargetGroupNotFoundFault),
    /// <p> <code>DBSnapshotIdentifier</code> doesn't refer to an existing DB snapshot. </p>
    DbSnapshotNotFoundFault(crate::error::DbSnapshotNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RemoveTagsFromResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RemoveTagsFromResourceErrorKind::DbClusterNotFoundFault(_inner) => _inner.fmt(f),
            RemoveTagsFromResourceErrorKind::DbInstanceNotFoundFault(_inner) => _inner.fmt(f),
            RemoveTagsFromResourceErrorKind::DbProxyNotFoundFault(_inner) => _inner.fmt(f),
            RemoveTagsFromResourceErrorKind::DbProxyTargetGroupNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            RemoveTagsFromResourceErrorKind::DbSnapshotNotFoundFault(_inner) => _inner.fmt(f),
            RemoveTagsFromResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RemoveTagsFromResourceError {
    fn code(&self) -> Option<&str> {
        RemoveTagsFromResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RemoveTagsFromResourceError {
    /// Creates a new `RemoveTagsFromResourceError`.
    pub fn new(kind: RemoveTagsFromResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RemoveTagsFromResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RemoveTagsFromResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RemoveTagsFromResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RemoveTagsFromResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RemoveTagsFromResourceErrorKind::DbClusterNotFoundFault`.
    pub fn is_db_cluster_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            RemoveTagsFromResourceErrorKind::DbClusterNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveTagsFromResourceErrorKind::DbInstanceNotFoundFault`.
    pub fn is_db_instance_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            RemoveTagsFromResourceErrorKind::DbInstanceNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveTagsFromResourceErrorKind::DbProxyNotFoundFault`.
    pub fn is_db_proxy_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            RemoveTagsFromResourceErrorKind::DbProxyNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveTagsFromResourceErrorKind::DbProxyTargetGroupNotFoundFault`.
    pub fn is_db_proxy_target_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            RemoveTagsFromResourceErrorKind::DbProxyTargetGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveTagsFromResourceErrorKind::DbSnapshotNotFoundFault`.
    pub fn is_db_snapshot_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            RemoveTagsFromResourceErrorKind::DbSnapshotNotFoundFault(_)
        )
    }
}
impl std::error::Error for RemoveTagsFromResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RemoveTagsFromResourceErrorKind::DbClusterNotFoundFault(_inner) => Some(_inner),
            RemoveTagsFromResourceErrorKind::DbInstanceNotFoundFault(_inner) => Some(_inner),
            RemoveTagsFromResourceErrorKind::DbProxyNotFoundFault(_inner) => Some(_inner),
            RemoveTagsFromResourceErrorKind::DbProxyTargetGroupNotFoundFault(_inner) => {
                Some(_inner)
            }
            RemoveTagsFromResourceErrorKind::DbSnapshotNotFoundFault(_inner) => Some(_inner),
            RemoveTagsFromResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ResetDBClusterParameterGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ResetDBClusterParameterGroupError {
    /// Kind of error that occurred.
    pub kind: ResetDBClusterParameterGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ResetDBClusterParameterGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ResetDBClusterParameterGroupErrorKind {
    /// <p> <code>DBParameterGroupName</code> doesn't refer to an existing DB parameter group. </p>
    DbParameterGroupNotFoundFault(crate::error::DbParameterGroupNotFoundFault),
    /// <p>The DB parameter group is in use or is in an invalid state. If you are attempting to delete the parameter group, you can't delete it when the parameter group is in this state.</p>
    InvalidDbParameterGroupStateFault(crate::error::InvalidDbParameterGroupStateFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ResetDBClusterParameterGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ResetDBClusterParameterGroupErrorKind::DbParameterGroupNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            ResetDBClusterParameterGroupErrorKind::InvalidDbParameterGroupStateFault(_inner) => {
                _inner.fmt(f)
            }
            ResetDBClusterParameterGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ResetDBClusterParameterGroupError {
    fn code(&self) -> Option<&str> {
        ResetDBClusterParameterGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ResetDBClusterParameterGroupError {
    /// Creates a new `ResetDBClusterParameterGroupError`.
    pub fn new(kind: ResetDBClusterParameterGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ResetDBClusterParameterGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ResetDBClusterParameterGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ResetDBClusterParameterGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ResetDBClusterParameterGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ResetDBClusterParameterGroupErrorKind::DbParameterGroupNotFoundFault`.
    pub fn is_db_parameter_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            ResetDBClusterParameterGroupErrorKind::DbParameterGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `ResetDBClusterParameterGroupErrorKind::InvalidDbParameterGroupStateFault`.
    pub fn is_invalid_db_parameter_group_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            ResetDBClusterParameterGroupErrorKind::InvalidDbParameterGroupStateFault(_)
        )
    }
}
impl std::error::Error for ResetDBClusterParameterGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ResetDBClusterParameterGroupErrorKind::DbParameterGroupNotFoundFault(_inner) => {
                Some(_inner)
            }
            ResetDBClusterParameterGroupErrorKind::InvalidDbParameterGroupStateFault(_inner) => {
                Some(_inner)
            }
            ResetDBClusterParameterGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ResetDBParameterGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ResetDBParameterGroupError {
    /// Kind of error that occurred.
    pub kind: ResetDBParameterGroupErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ResetDBParameterGroup` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ResetDBParameterGroupErrorKind {
    /// <p> <code>DBParameterGroupName</code> doesn't refer to an existing DB parameter group. </p>
    DbParameterGroupNotFoundFault(crate::error::DbParameterGroupNotFoundFault),
    /// <p>The DB parameter group is in use or is in an invalid state. If you are attempting to delete the parameter group, you can't delete it when the parameter group is in this state.</p>
    InvalidDbParameterGroupStateFault(crate::error::InvalidDbParameterGroupStateFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ResetDBParameterGroupError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ResetDBParameterGroupErrorKind::DbParameterGroupNotFoundFault(_inner) => _inner.fmt(f),
            ResetDBParameterGroupErrorKind::InvalidDbParameterGroupStateFault(_inner) => {
                _inner.fmt(f)
            }
            ResetDBParameterGroupErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ResetDBParameterGroupError {
    fn code(&self) -> Option<&str> {
        ResetDBParameterGroupError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ResetDBParameterGroupError {
    /// Creates a new `ResetDBParameterGroupError`.
    pub fn new(kind: ResetDBParameterGroupErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ResetDBParameterGroupError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ResetDBParameterGroupErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ResetDBParameterGroupError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ResetDBParameterGroupErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ResetDBParameterGroupErrorKind::DbParameterGroupNotFoundFault`.
    pub fn is_db_parameter_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            ResetDBParameterGroupErrorKind::DbParameterGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `ResetDBParameterGroupErrorKind::InvalidDbParameterGroupStateFault`.
    pub fn is_invalid_db_parameter_group_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            ResetDBParameterGroupErrorKind::InvalidDbParameterGroupStateFault(_)
        )
    }
}
impl std::error::Error for ResetDBParameterGroupError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ResetDBParameterGroupErrorKind::DbParameterGroupNotFoundFault(_inner) => Some(_inner),
            ResetDBParameterGroupErrorKind::InvalidDbParameterGroupStateFault(_inner) => {
                Some(_inner)
            }
            ResetDBParameterGroupErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RestoreDBClusterFromS3` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RestoreDBClusterFromS3Error {
    /// Kind of error that occurred.
    pub kind: RestoreDBClusterFromS3ErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RestoreDBClusterFromS3` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RestoreDBClusterFromS3ErrorKind {
    /// <p>The user already has a DB cluster with the given identifier.</p>
    DbClusterAlreadyExistsFault(crate::error::DbClusterAlreadyExistsFault),
    /// <p> <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster. </p>
    DbClusterNotFoundFault(crate::error::DbClusterNotFoundFault),
    /// <p> <code>DBClusterParameterGroupName</code> doesn't refer to an existing DB cluster parameter group. </p>
    DbClusterParameterGroupNotFoundFault(crate::error::DbClusterParameterGroupNotFoundFault),
    /// <p>The user attempted to create a new DB cluster and the user has already reached the maximum allowed DB cluster quota.</p>
    DbClusterQuotaExceededFault(crate::error::DbClusterQuotaExceededFault),
    /// <p> <code>DBSubnetGroupName</code> doesn't refer to an existing DB subnet group. </p>
    DbSubnetGroupNotFoundFault(crate::error::DbSubnetGroupNotFoundFault),
    /// <p> <code>Domain</code> doesn't refer to an existing Active Directory domain. </p>
    DomainNotFoundFault(crate::error::DomainNotFoundFault),
    /// <p>There is insufficient storage available for the current action. You might be able to resolve this error by updating your subnet group to use different Availability Zones that have more storage available.</p>
    InsufficientStorageClusterCapacityFault(crate::error::InsufficientStorageClusterCapacityFault),
    /// <p>The requested operation can't be performed while the cluster is in this state.</p>
    InvalidDbClusterStateFault(crate::error::InvalidDbClusterStateFault),
    /// <p>The DB subnet group cannot be deleted because it's in use.</p>
    InvalidDbSubnetGroupStateFault(crate::error::InvalidDbSubnetGroupStateFault),
    /// <p>The specified Amazon S3 bucket name can't be found or Amazon RDS isn't authorized to access the specified Amazon S3 bucket. Verify the <b>SourceS3BucketName</b> and <b>S3IngestionRoleArn</b> values and try again.</p>
    InvalidS3BucketFault(crate::error::InvalidS3BucketFault),
    /// <p>The requested subnet is invalid, or multiple subnets were requested that are not all in a common VPC.</p>
    InvalidSubnet(crate::error::InvalidSubnet),
    /// <p>The DB subnet group doesn't cover all Availability Zones after it's created because of users' change.</p>
    InvalidVpcNetworkStateFault(crate::error::InvalidVpcNetworkStateFault),
    /// <p>An error occurred accessing an Amazon Web Services KMS key.</p>
    KmsKeyNotAccessibleFault(crate::error::KmsKeyNotAccessibleFault),
    /// <p>The request would result in the user exceeding the allowed amount of storage available across all DB instances.</p>
    StorageQuotaExceededFault(crate::error::StorageQuotaExceededFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RestoreDBClusterFromS3Error {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RestoreDBClusterFromS3ErrorKind::DbClusterAlreadyExistsFault(_inner) => _inner.fmt(f),
            RestoreDBClusterFromS3ErrorKind::DbClusterNotFoundFault(_inner) => _inner.fmt(f),
            RestoreDBClusterFromS3ErrorKind::DbClusterParameterGroupNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            RestoreDBClusterFromS3ErrorKind::DbClusterQuotaExceededFault(_inner) => _inner.fmt(f),
            RestoreDBClusterFromS3ErrorKind::DbSubnetGroupNotFoundFault(_inner) => _inner.fmt(f),
            RestoreDBClusterFromS3ErrorKind::DomainNotFoundFault(_inner) => _inner.fmt(f),
            RestoreDBClusterFromS3ErrorKind::InsufficientStorageClusterCapacityFault(_inner) => {
                _inner.fmt(f)
            }
            RestoreDBClusterFromS3ErrorKind::InvalidDbClusterStateFault(_inner) => _inner.fmt(f),
            RestoreDBClusterFromS3ErrorKind::InvalidDbSubnetGroupStateFault(_inner) => {
                _inner.fmt(f)
            }
            RestoreDBClusterFromS3ErrorKind::InvalidS3BucketFault(_inner) => _inner.fmt(f),
            RestoreDBClusterFromS3ErrorKind::InvalidSubnet(_inner) => _inner.fmt(f),
            RestoreDBClusterFromS3ErrorKind::InvalidVpcNetworkStateFault(_inner) => _inner.fmt(f),
            RestoreDBClusterFromS3ErrorKind::KmsKeyNotAccessibleFault(_inner) => _inner.fmt(f),
            RestoreDBClusterFromS3ErrorKind::StorageQuotaExceededFault(_inner) => _inner.fmt(f),
            RestoreDBClusterFromS3ErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RestoreDBClusterFromS3Error {
    fn code(&self) -> Option<&str> {
        RestoreDBClusterFromS3Error::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RestoreDBClusterFromS3Error {
    /// Creates a new `RestoreDBClusterFromS3Error`.
    pub fn new(kind: RestoreDBClusterFromS3ErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RestoreDBClusterFromS3Error::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RestoreDBClusterFromS3ErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RestoreDBClusterFromS3Error::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RestoreDBClusterFromS3ErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RestoreDBClusterFromS3ErrorKind::DbClusterAlreadyExistsFault`.
    pub fn is_db_cluster_already_exists_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBClusterFromS3ErrorKind::DbClusterAlreadyExistsFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBClusterFromS3ErrorKind::DbClusterNotFoundFault`.
    pub fn is_db_cluster_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBClusterFromS3ErrorKind::DbClusterNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBClusterFromS3ErrorKind::DbClusterParameterGroupNotFoundFault`.
    pub fn is_db_cluster_parameter_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBClusterFromS3ErrorKind::DbClusterParameterGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBClusterFromS3ErrorKind::DbClusterQuotaExceededFault`.
    pub fn is_db_cluster_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBClusterFromS3ErrorKind::DbClusterQuotaExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBClusterFromS3ErrorKind::DbSubnetGroupNotFoundFault`.
    pub fn is_db_subnet_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBClusterFromS3ErrorKind::DbSubnetGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBClusterFromS3ErrorKind::DomainNotFoundFault`.
    pub fn is_domain_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBClusterFromS3ErrorKind::DomainNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBClusterFromS3ErrorKind::InsufficientStorageClusterCapacityFault`.
    pub fn is_insufficient_storage_cluster_capacity_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBClusterFromS3ErrorKind::InsufficientStorageClusterCapacityFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBClusterFromS3ErrorKind::InvalidDbClusterStateFault`.
    pub fn is_invalid_db_cluster_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBClusterFromS3ErrorKind::InvalidDbClusterStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBClusterFromS3ErrorKind::InvalidDbSubnetGroupStateFault`.
    pub fn is_invalid_db_subnet_group_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBClusterFromS3ErrorKind::InvalidDbSubnetGroupStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBClusterFromS3ErrorKind::InvalidS3BucketFault`.
    pub fn is_invalid_s3_bucket_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBClusterFromS3ErrorKind::InvalidS3BucketFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBClusterFromS3ErrorKind::InvalidSubnet`.
    pub fn is_invalid_subnet(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBClusterFromS3ErrorKind::InvalidSubnet(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBClusterFromS3ErrorKind::InvalidVpcNetworkStateFault`.
    pub fn is_invalid_vpc_network_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBClusterFromS3ErrorKind::InvalidVpcNetworkStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBClusterFromS3ErrorKind::KmsKeyNotAccessibleFault`.
    pub fn is_kms_key_not_accessible_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBClusterFromS3ErrorKind::KmsKeyNotAccessibleFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBClusterFromS3ErrorKind::StorageQuotaExceededFault`.
    pub fn is_storage_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBClusterFromS3ErrorKind::StorageQuotaExceededFault(_)
        )
    }
}
impl std::error::Error for RestoreDBClusterFromS3Error {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RestoreDBClusterFromS3ErrorKind::DbClusterAlreadyExistsFault(_inner) => Some(_inner),
            RestoreDBClusterFromS3ErrorKind::DbClusterNotFoundFault(_inner) => Some(_inner),
            RestoreDBClusterFromS3ErrorKind::DbClusterParameterGroupNotFoundFault(_inner) => {
                Some(_inner)
            }
            RestoreDBClusterFromS3ErrorKind::DbClusterQuotaExceededFault(_inner) => Some(_inner),
            RestoreDBClusterFromS3ErrorKind::DbSubnetGroupNotFoundFault(_inner) => Some(_inner),
            RestoreDBClusterFromS3ErrorKind::DomainNotFoundFault(_inner) => Some(_inner),
            RestoreDBClusterFromS3ErrorKind::InsufficientStorageClusterCapacityFault(_inner) => {
                Some(_inner)
            }
            RestoreDBClusterFromS3ErrorKind::InvalidDbClusterStateFault(_inner) => Some(_inner),
            RestoreDBClusterFromS3ErrorKind::InvalidDbSubnetGroupStateFault(_inner) => Some(_inner),
            RestoreDBClusterFromS3ErrorKind::InvalidS3BucketFault(_inner) => Some(_inner),
            RestoreDBClusterFromS3ErrorKind::InvalidSubnet(_inner) => Some(_inner),
            RestoreDBClusterFromS3ErrorKind::InvalidVpcNetworkStateFault(_inner) => Some(_inner),
            RestoreDBClusterFromS3ErrorKind::KmsKeyNotAccessibleFault(_inner) => Some(_inner),
            RestoreDBClusterFromS3ErrorKind::StorageQuotaExceededFault(_inner) => Some(_inner),
            RestoreDBClusterFromS3ErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RestoreDBClusterFromSnapshot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RestoreDBClusterFromSnapshotError {
    /// Kind of error that occurred.
    pub kind: RestoreDBClusterFromSnapshotErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RestoreDBClusterFromSnapshot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RestoreDBClusterFromSnapshotErrorKind {
    /// <p>The user already has a DB cluster with the given identifier.</p>
    DbClusterAlreadyExistsFault(crate::error::DbClusterAlreadyExistsFault),
    /// <p> <code>DBClusterParameterGroupName</code> doesn't refer to an existing DB cluster parameter group. </p>
    DbClusterParameterGroupNotFoundFault(crate::error::DbClusterParameterGroupNotFoundFault),
    /// <p>The user attempted to create a new DB cluster and the user has already reached the maximum allowed DB cluster quota.</p>
    DbClusterQuotaExceededFault(crate::error::DbClusterQuotaExceededFault),
    /// <p> <code>DBClusterSnapshotIdentifier</code> doesn't refer to an existing DB cluster snapshot. </p>
    DbClusterSnapshotNotFoundFault(crate::error::DbClusterSnapshotNotFoundFault),
    /// <p> <code>DBSnapshotIdentifier</code> doesn't refer to an existing DB snapshot. </p>
    DbSnapshotNotFoundFault(crate::error::DbSnapshotNotFoundFault),
    /// <p> <code>DBSubnetGroupName</code> doesn't refer to an existing DB subnet group. </p>
    DbSubnetGroupNotFoundFault(crate::error::DbSubnetGroupNotFoundFault),
    /// <p> <code>Domain</code> doesn't refer to an existing Active Directory domain. </p>
    DomainNotFoundFault(crate::error::DomainNotFoundFault),
    /// <p>The DB cluster doesn't have enough capacity for the current operation.</p>
    InsufficientDbClusterCapacityFault(crate::error::InsufficientDbClusterCapacityFault),
    /// <p>There is insufficient storage available for the current action. You might be able to resolve this error by updating your subnet group to use different Availability Zones that have more storage available.</p>
    InsufficientStorageClusterCapacityFault(crate::error::InsufficientStorageClusterCapacityFault),
    /// <p>The supplied value isn't a valid DB cluster snapshot state.</p>
    InvalidDbClusterSnapshotStateFault(crate::error::InvalidDbClusterSnapshotStateFault),
    /// <p>The state of the DB snapshot doesn't allow deletion.</p>
    InvalidDbSnapshotStateFault(crate::error::InvalidDbSnapshotStateFault),
    /// <p>Cannot restore from VPC backup to non-VPC DB instance.</p>
    InvalidRestoreFault(crate::error::InvalidRestoreFault),
    /// <p>The requested subnet is invalid, or multiple subnets were requested that are not all in a common VPC.</p>
    InvalidSubnet(crate::error::InvalidSubnet),
    /// <p>The DB subnet group doesn't cover all Availability Zones after it's created because of users' change.</p>
    InvalidVpcNetworkStateFault(crate::error::InvalidVpcNetworkStateFault),
    /// <p>An error occurred accessing an Amazon Web Services KMS key.</p>
    KmsKeyNotAccessibleFault(crate::error::KmsKeyNotAccessibleFault),
    /// <p>The specified option group could not be found.</p>
    OptionGroupNotFoundFault(crate::error::OptionGroupNotFoundFault),
    /// <p>The request would result in the user exceeding the allowed amount of storage available across all DB instances.</p>
    StorageQuotaExceededFault(crate::error::StorageQuotaExceededFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RestoreDBClusterFromSnapshotError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RestoreDBClusterFromSnapshotErrorKind::DbClusterAlreadyExistsFault(_inner) => {
                _inner.fmt(f)
            }
            RestoreDBClusterFromSnapshotErrorKind::DbClusterParameterGroupNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            RestoreDBClusterFromSnapshotErrorKind::DbClusterQuotaExceededFault(_inner) => {
                _inner.fmt(f)
            }
            RestoreDBClusterFromSnapshotErrorKind::DbClusterSnapshotNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            RestoreDBClusterFromSnapshotErrorKind::DbSnapshotNotFoundFault(_inner) => _inner.fmt(f),
            RestoreDBClusterFromSnapshotErrorKind::DbSubnetGroupNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            RestoreDBClusterFromSnapshotErrorKind::DomainNotFoundFault(_inner) => _inner.fmt(f),
            RestoreDBClusterFromSnapshotErrorKind::InsufficientDbClusterCapacityFault(_inner) => {
                _inner.fmt(f)
            }
            RestoreDBClusterFromSnapshotErrorKind::InsufficientStorageClusterCapacityFault(
                _inner,
            ) => _inner.fmt(f),
            RestoreDBClusterFromSnapshotErrorKind::InvalidDbClusterSnapshotStateFault(_inner) => {
                _inner.fmt(f)
            }
            RestoreDBClusterFromSnapshotErrorKind::InvalidDbSnapshotStateFault(_inner) => {
                _inner.fmt(f)
            }
            RestoreDBClusterFromSnapshotErrorKind::InvalidRestoreFault(_inner) => _inner.fmt(f),
            RestoreDBClusterFromSnapshotErrorKind::InvalidSubnet(_inner) => _inner.fmt(f),
            RestoreDBClusterFromSnapshotErrorKind::InvalidVpcNetworkStateFault(_inner) => {
                _inner.fmt(f)
            }
            RestoreDBClusterFromSnapshotErrorKind::KmsKeyNotAccessibleFault(_inner) => {
                _inner.fmt(f)
            }
            RestoreDBClusterFromSnapshotErrorKind::OptionGroupNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            RestoreDBClusterFromSnapshotErrorKind::StorageQuotaExceededFault(_inner) => {
                _inner.fmt(f)
            }
            RestoreDBClusterFromSnapshotErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RestoreDBClusterFromSnapshotError {
    fn code(&self) -> Option<&str> {
        RestoreDBClusterFromSnapshotError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RestoreDBClusterFromSnapshotError {
    /// Creates a new `RestoreDBClusterFromSnapshotError`.
    pub fn new(kind: RestoreDBClusterFromSnapshotErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RestoreDBClusterFromSnapshotError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RestoreDBClusterFromSnapshotErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RestoreDBClusterFromSnapshotError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RestoreDBClusterFromSnapshotErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RestoreDBClusterFromSnapshotErrorKind::DbClusterAlreadyExistsFault`.
    pub fn is_db_cluster_already_exists_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBClusterFromSnapshotErrorKind::DbClusterAlreadyExistsFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBClusterFromSnapshotErrorKind::DbClusterParameterGroupNotFoundFault`.
    pub fn is_db_cluster_parameter_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBClusterFromSnapshotErrorKind::DbClusterParameterGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBClusterFromSnapshotErrorKind::DbClusterQuotaExceededFault`.
    pub fn is_db_cluster_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBClusterFromSnapshotErrorKind::DbClusterQuotaExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBClusterFromSnapshotErrorKind::DbClusterSnapshotNotFoundFault`.
    pub fn is_db_cluster_snapshot_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBClusterFromSnapshotErrorKind::DbClusterSnapshotNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBClusterFromSnapshotErrorKind::DbSnapshotNotFoundFault`.
    pub fn is_db_snapshot_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBClusterFromSnapshotErrorKind::DbSnapshotNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBClusterFromSnapshotErrorKind::DbSubnetGroupNotFoundFault`.
    pub fn is_db_subnet_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBClusterFromSnapshotErrorKind::DbSubnetGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBClusterFromSnapshotErrorKind::DomainNotFoundFault`.
    pub fn is_domain_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBClusterFromSnapshotErrorKind::DomainNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBClusterFromSnapshotErrorKind::InsufficientDbClusterCapacityFault`.
    pub fn is_insufficient_db_cluster_capacity_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBClusterFromSnapshotErrorKind::InsufficientDbClusterCapacityFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBClusterFromSnapshotErrorKind::InsufficientStorageClusterCapacityFault`.
    pub fn is_insufficient_storage_cluster_capacity_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBClusterFromSnapshotErrorKind::InsufficientStorageClusterCapacityFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBClusterFromSnapshotErrorKind::InvalidDbClusterSnapshotStateFault`.
    pub fn is_invalid_db_cluster_snapshot_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBClusterFromSnapshotErrorKind::InvalidDbClusterSnapshotStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBClusterFromSnapshotErrorKind::InvalidDbSnapshotStateFault`.
    pub fn is_invalid_db_snapshot_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBClusterFromSnapshotErrorKind::InvalidDbSnapshotStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBClusterFromSnapshotErrorKind::InvalidRestoreFault`.
    pub fn is_invalid_restore_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBClusterFromSnapshotErrorKind::InvalidRestoreFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBClusterFromSnapshotErrorKind::InvalidSubnet`.
    pub fn is_invalid_subnet(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBClusterFromSnapshotErrorKind::InvalidSubnet(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBClusterFromSnapshotErrorKind::InvalidVpcNetworkStateFault`.
    pub fn is_invalid_vpc_network_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBClusterFromSnapshotErrorKind::InvalidVpcNetworkStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBClusterFromSnapshotErrorKind::KmsKeyNotAccessibleFault`.
    pub fn is_kms_key_not_accessible_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBClusterFromSnapshotErrorKind::KmsKeyNotAccessibleFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBClusterFromSnapshotErrorKind::OptionGroupNotFoundFault`.
    pub fn is_option_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBClusterFromSnapshotErrorKind::OptionGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBClusterFromSnapshotErrorKind::StorageQuotaExceededFault`.
    pub fn is_storage_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBClusterFromSnapshotErrorKind::StorageQuotaExceededFault(_)
        )
    }
}
impl std::error::Error for RestoreDBClusterFromSnapshotError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RestoreDBClusterFromSnapshotErrorKind::DbClusterAlreadyExistsFault(_inner) => {
                Some(_inner)
            }
            RestoreDBClusterFromSnapshotErrorKind::DbClusterParameterGroupNotFoundFault(_inner) => {
                Some(_inner)
            }
            RestoreDBClusterFromSnapshotErrorKind::DbClusterQuotaExceededFault(_inner) => {
                Some(_inner)
            }
            RestoreDBClusterFromSnapshotErrorKind::DbClusterSnapshotNotFoundFault(_inner) => {
                Some(_inner)
            }
            RestoreDBClusterFromSnapshotErrorKind::DbSnapshotNotFoundFault(_inner) => Some(_inner),
            RestoreDBClusterFromSnapshotErrorKind::DbSubnetGroupNotFoundFault(_inner) => {
                Some(_inner)
            }
            RestoreDBClusterFromSnapshotErrorKind::DomainNotFoundFault(_inner) => Some(_inner),
            RestoreDBClusterFromSnapshotErrorKind::InsufficientDbClusterCapacityFault(_inner) => {
                Some(_inner)
            }
            RestoreDBClusterFromSnapshotErrorKind::InsufficientStorageClusterCapacityFault(
                _inner,
            ) => Some(_inner),
            RestoreDBClusterFromSnapshotErrorKind::InvalidDbClusterSnapshotStateFault(_inner) => {
                Some(_inner)
            }
            RestoreDBClusterFromSnapshotErrorKind::InvalidDbSnapshotStateFault(_inner) => {
                Some(_inner)
            }
            RestoreDBClusterFromSnapshotErrorKind::InvalidRestoreFault(_inner) => Some(_inner),
            RestoreDBClusterFromSnapshotErrorKind::InvalidSubnet(_inner) => Some(_inner),
            RestoreDBClusterFromSnapshotErrorKind::InvalidVpcNetworkStateFault(_inner) => {
                Some(_inner)
            }
            RestoreDBClusterFromSnapshotErrorKind::KmsKeyNotAccessibleFault(_inner) => Some(_inner),
            RestoreDBClusterFromSnapshotErrorKind::OptionGroupNotFoundFault(_inner) => Some(_inner),
            RestoreDBClusterFromSnapshotErrorKind::StorageQuotaExceededFault(_inner) => {
                Some(_inner)
            }
            RestoreDBClusterFromSnapshotErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RestoreDBClusterToPointInTime` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RestoreDBClusterToPointInTimeError {
    /// Kind of error that occurred.
    pub kind: RestoreDBClusterToPointInTimeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RestoreDBClusterToPointInTime` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RestoreDBClusterToPointInTimeErrorKind {
    /// <p>The user already has a DB cluster with the given identifier.</p>
    DbClusterAlreadyExistsFault(crate::error::DbClusterAlreadyExistsFault),
    /// <p> <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster. </p>
    DbClusterNotFoundFault(crate::error::DbClusterNotFoundFault),
    /// <p> <code>DBClusterParameterGroupName</code> doesn't refer to an existing DB cluster parameter group. </p>
    DbClusterParameterGroupNotFoundFault(crate::error::DbClusterParameterGroupNotFoundFault),
    /// <p>The user attempted to create a new DB cluster and the user has already reached the maximum allowed DB cluster quota.</p>
    DbClusterQuotaExceededFault(crate::error::DbClusterQuotaExceededFault),
    /// <p> <code>DBClusterSnapshotIdentifier</code> doesn't refer to an existing DB cluster snapshot. </p>
    DbClusterSnapshotNotFoundFault(crate::error::DbClusterSnapshotNotFoundFault),
    /// <p> <code>DBSubnetGroupName</code> doesn't refer to an existing DB subnet group. </p>
    DbSubnetGroupNotFoundFault(crate::error::DbSubnetGroupNotFoundFault),
    /// <p> <code>Domain</code> doesn't refer to an existing Active Directory domain. </p>
    DomainNotFoundFault(crate::error::DomainNotFoundFault),
    /// <p>The DB cluster doesn't have enough capacity for the current operation.</p>
    InsufficientDbClusterCapacityFault(crate::error::InsufficientDbClusterCapacityFault),
    /// <p>There is insufficient storage available for the current action. You might be able to resolve this error by updating your subnet group to use different Availability Zones that have more storage available.</p>
    InsufficientStorageClusterCapacityFault(crate::error::InsufficientStorageClusterCapacityFault),
    /// <p>The supplied value isn't a valid DB cluster snapshot state.</p>
    InvalidDbClusterSnapshotStateFault(crate::error::InvalidDbClusterSnapshotStateFault),
    /// <p>The requested operation can't be performed while the cluster is in this state.</p>
    InvalidDbClusterStateFault(crate::error::InvalidDbClusterStateFault),
    /// <p>The state of the DB snapshot doesn't allow deletion.</p>
    InvalidDbSnapshotStateFault(crate::error::InvalidDbSnapshotStateFault),
    /// <p>Cannot restore from VPC backup to non-VPC DB instance.</p>
    InvalidRestoreFault(crate::error::InvalidRestoreFault),
    /// <p>The requested subnet is invalid, or multiple subnets were requested that are not all in a common VPC.</p>
    InvalidSubnet(crate::error::InvalidSubnet),
    /// <p>The DB subnet group doesn't cover all Availability Zones after it's created because of users' change.</p>
    InvalidVpcNetworkStateFault(crate::error::InvalidVpcNetworkStateFault),
    /// <p>An error occurred accessing an Amazon Web Services KMS key.</p>
    KmsKeyNotAccessibleFault(crate::error::KmsKeyNotAccessibleFault),
    /// <p>The specified option group could not be found.</p>
    OptionGroupNotFoundFault(crate::error::OptionGroupNotFoundFault),
    /// <p>The request would result in the user exceeding the allowed amount of storage available across all DB instances.</p>
    StorageQuotaExceededFault(crate::error::StorageQuotaExceededFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RestoreDBClusterToPointInTimeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RestoreDBClusterToPointInTimeErrorKind::DbClusterAlreadyExistsFault(_inner) => {
                _inner.fmt(f)
            }
            RestoreDBClusterToPointInTimeErrorKind::DbClusterNotFoundFault(_inner) => _inner.fmt(f),
            RestoreDBClusterToPointInTimeErrorKind::DbClusterParameterGroupNotFoundFault(
                _inner,
            ) => _inner.fmt(f),
            RestoreDBClusterToPointInTimeErrorKind::DbClusterQuotaExceededFault(_inner) => {
                _inner.fmt(f)
            }
            RestoreDBClusterToPointInTimeErrorKind::DbClusterSnapshotNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            RestoreDBClusterToPointInTimeErrorKind::DbSubnetGroupNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            RestoreDBClusterToPointInTimeErrorKind::DomainNotFoundFault(_inner) => _inner.fmt(f),
            RestoreDBClusterToPointInTimeErrorKind::InsufficientDbClusterCapacityFault(_inner) => {
                _inner.fmt(f)
            }
            RestoreDBClusterToPointInTimeErrorKind::InsufficientStorageClusterCapacityFault(
                _inner,
            ) => _inner.fmt(f),
            RestoreDBClusterToPointInTimeErrorKind::InvalidDbClusterSnapshotStateFault(_inner) => {
                _inner.fmt(f)
            }
            RestoreDBClusterToPointInTimeErrorKind::InvalidDbClusterStateFault(_inner) => {
                _inner.fmt(f)
            }
            RestoreDBClusterToPointInTimeErrorKind::InvalidDbSnapshotStateFault(_inner) => {
                _inner.fmt(f)
            }
            RestoreDBClusterToPointInTimeErrorKind::InvalidRestoreFault(_inner) => _inner.fmt(f),
            RestoreDBClusterToPointInTimeErrorKind::InvalidSubnet(_inner) => _inner.fmt(f),
            RestoreDBClusterToPointInTimeErrorKind::InvalidVpcNetworkStateFault(_inner) => {
                _inner.fmt(f)
            }
            RestoreDBClusterToPointInTimeErrorKind::KmsKeyNotAccessibleFault(_inner) => {
                _inner.fmt(f)
            }
            RestoreDBClusterToPointInTimeErrorKind::OptionGroupNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            RestoreDBClusterToPointInTimeErrorKind::StorageQuotaExceededFault(_inner) => {
                _inner.fmt(f)
            }
            RestoreDBClusterToPointInTimeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RestoreDBClusterToPointInTimeError {
    fn code(&self) -> Option<&str> {
        RestoreDBClusterToPointInTimeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RestoreDBClusterToPointInTimeError {
    /// Creates a new `RestoreDBClusterToPointInTimeError`.
    pub fn new(
        kind: RestoreDBClusterToPointInTimeErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RestoreDBClusterToPointInTimeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RestoreDBClusterToPointInTimeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RestoreDBClusterToPointInTimeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RestoreDBClusterToPointInTimeErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RestoreDBClusterToPointInTimeErrorKind::DbClusterAlreadyExistsFault`.
    pub fn is_db_cluster_already_exists_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBClusterToPointInTimeErrorKind::DbClusterAlreadyExistsFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBClusterToPointInTimeErrorKind::DbClusterNotFoundFault`.
    pub fn is_db_cluster_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBClusterToPointInTimeErrorKind::DbClusterNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBClusterToPointInTimeErrorKind::DbClusterParameterGroupNotFoundFault`.
    pub fn is_db_cluster_parameter_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBClusterToPointInTimeErrorKind::DbClusterParameterGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBClusterToPointInTimeErrorKind::DbClusterQuotaExceededFault`.
    pub fn is_db_cluster_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBClusterToPointInTimeErrorKind::DbClusterQuotaExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBClusterToPointInTimeErrorKind::DbClusterSnapshotNotFoundFault`.
    pub fn is_db_cluster_snapshot_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBClusterToPointInTimeErrorKind::DbClusterSnapshotNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBClusterToPointInTimeErrorKind::DbSubnetGroupNotFoundFault`.
    pub fn is_db_subnet_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBClusterToPointInTimeErrorKind::DbSubnetGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBClusterToPointInTimeErrorKind::DomainNotFoundFault`.
    pub fn is_domain_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBClusterToPointInTimeErrorKind::DomainNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBClusterToPointInTimeErrorKind::InsufficientDbClusterCapacityFault`.
    pub fn is_insufficient_db_cluster_capacity_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBClusterToPointInTimeErrorKind::InsufficientDbClusterCapacityFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBClusterToPointInTimeErrorKind::InsufficientStorageClusterCapacityFault`.
    pub fn is_insufficient_storage_cluster_capacity_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBClusterToPointInTimeErrorKind::InsufficientStorageClusterCapacityFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBClusterToPointInTimeErrorKind::InvalidDbClusterSnapshotStateFault`.
    pub fn is_invalid_db_cluster_snapshot_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBClusterToPointInTimeErrorKind::InvalidDbClusterSnapshotStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBClusterToPointInTimeErrorKind::InvalidDbClusterStateFault`.
    pub fn is_invalid_db_cluster_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBClusterToPointInTimeErrorKind::InvalidDbClusterStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBClusterToPointInTimeErrorKind::InvalidDbSnapshotStateFault`.
    pub fn is_invalid_db_snapshot_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBClusterToPointInTimeErrorKind::InvalidDbSnapshotStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBClusterToPointInTimeErrorKind::InvalidRestoreFault`.
    pub fn is_invalid_restore_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBClusterToPointInTimeErrorKind::InvalidRestoreFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBClusterToPointInTimeErrorKind::InvalidSubnet`.
    pub fn is_invalid_subnet(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBClusterToPointInTimeErrorKind::InvalidSubnet(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBClusterToPointInTimeErrorKind::InvalidVpcNetworkStateFault`.
    pub fn is_invalid_vpc_network_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBClusterToPointInTimeErrorKind::InvalidVpcNetworkStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBClusterToPointInTimeErrorKind::KmsKeyNotAccessibleFault`.
    pub fn is_kms_key_not_accessible_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBClusterToPointInTimeErrorKind::KmsKeyNotAccessibleFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBClusterToPointInTimeErrorKind::OptionGroupNotFoundFault`.
    pub fn is_option_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBClusterToPointInTimeErrorKind::OptionGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBClusterToPointInTimeErrorKind::StorageQuotaExceededFault`.
    pub fn is_storage_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBClusterToPointInTimeErrorKind::StorageQuotaExceededFault(_)
        )
    }
}
impl std::error::Error for RestoreDBClusterToPointInTimeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RestoreDBClusterToPointInTimeErrorKind::DbClusterAlreadyExistsFault(_inner) => {
                Some(_inner)
            }
            RestoreDBClusterToPointInTimeErrorKind::DbClusterNotFoundFault(_inner) => Some(_inner),
            RestoreDBClusterToPointInTimeErrorKind::DbClusterParameterGroupNotFoundFault(
                _inner,
            ) => Some(_inner),
            RestoreDBClusterToPointInTimeErrorKind::DbClusterQuotaExceededFault(_inner) => {
                Some(_inner)
            }
            RestoreDBClusterToPointInTimeErrorKind::DbClusterSnapshotNotFoundFault(_inner) => {
                Some(_inner)
            }
            RestoreDBClusterToPointInTimeErrorKind::DbSubnetGroupNotFoundFault(_inner) => {
                Some(_inner)
            }
            RestoreDBClusterToPointInTimeErrorKind::DomainNotFoundFault(_inner) => Some(_inner),
            RestoreDBClusterToPointInTimeErrorKind::InsufficientDbClusterCapacityFault(_inner) => {
                Some(_inner)
            }
            RestoreDBClusterToPointInTimeErrorKind::InsufficientStorageClusterCapacityFault(
                _inner,
            ) => Some(_inner),
            RestoreDBClusterToPointInTimeErrorKind::InvalidDbClusterSnapshotStateFault(_inner) => {
                Some(_inner)
            }
            RestoreDBClusterToPointInTimeErrorKind::InvalidDbClusterStateFault(_inner) => {
                Some(_inner)
            }
            RestoreDBClusterToPointInTimeErrorKind::InvalidDbSnapshotStateFault(_inner) => {
                Some(_inner)
            }
            RestoreDBClusterToPointInTimeErrorKind::InvalidRestoreFault(_inner) => Some(_inner),
            RestoreDBClusterToPointInTimeErrorKind::InvalidSubnet(_inner) => Some(_inner),
            RestoreDBClusterToPointInTimeErrorKind::InvalidVpcNetworkStateFault(_inner) => {
                Some(_inner)
            }
            RestoreDBClusterToPointInTimeErrorKind::KmsKeyNotAccessibleFault(_inner) => {
                Some(_inner)
            }
            RestoreDBClusterToPointInTimeErrorKind::OptionGroupNotFoundFault(_inner) => {
                Some(_inner)
            }
            RestoreDBClusterToPointInTimeErrorKind::StorageQuotaExceededFault(_inner) => {
                Some(_inner)
            }
            RestoreDBClusterToPointInTimeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RestoreDBInstanceFromDBSnapshot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RestoreDBInstanceFromDBSnapshotError {
    /// Kind of error that occurred.
    pub kind: RestoreDBInstanceFromDBSnapshotErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RestoreDBInstanceFromDBSnapshot` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RestoreDBInstanceFromDBSnapshotErrorKind {
    /// <p>The specified CIDR IP range or Amazon EC2 security group might not be authorized for the specified DB security group.</p>
    /// <p>Or, RDS might not be authorized to perform necessary actions using IAM on your behalf.</p>
    AuthorizationNotFoundFault(crate::error::AuthorizationNotFoundFault),
    #[allow(missing_docs)] // documentation missing in model
    BackupPolicyNotFoundFault(crate::error::BackupPolicyNotFoundFault),
    /// <p>The user already has a DB instance with the given identifier.</p>
    DbInstanceAlreadyExistsFault(crate::error::DbInstanceAlreadyExistsFault),
    /// <p> <code>DBParameterGroupName</code> doesn't refer to an existing DB parameter group. </p>
    DbParameterGroupNotFoundFault(crate::error::DbParameterGroupNotFoundFault),
    /// <p> <code>DBSecurityGroupName</code> doesn't refer to an existing DB security group. </p>
    DbSecurityGroupNotFoundFault(crate::error::DbSecurityGroupNotFoundFault),
    /// <p> <code>DBSnapshotIdentifier</code> doesn't refer to an existing DB snapshot. </p>
    DbSnapshotNotFoundFault(crate::error::DbSnapshotNotFoundFault),
    /// <p>Subnets in the DB subnet group should cover at least two Availability Zones unless there is only one Availability Zone.</p>
    DbSubnetGroupDoesNotCoverEnoughAZs(crate::error::DbSubnetGroupDoesNotCoverEnoughAZs),
    /// <p> <code>DBSubnetGroupName</code> doesn't refer to an existing DB subnet group. </p>
    DbSubnetGroupNotFoundFault(crate::error::DbSubnetGroupNotFoundFault),
    /// <p> <code>Domain</code> doesn't refer to an existing Active Directory domain. </p>
    DomainNotFoundFault(crate::error::DomainNotFoundFault),
    /// <p>The request would result in the user exceeding the allowed number of DB instances.</p>
    InstanceQuotaExceededFault(crate::error::InstanceQuotaExceededFault),
    /// <p>The specified DB instance class isn't available in the specified Availability Zone.</p>
    InsufficientDbInstanceCapacityFault(crate::error::InsufficientDbInstanceCapacityFault),
    /// <p>The state of the DB snapshot doesn't allow deletion.</p>
    InvalidDbSnapshotStateFault(crate::error::InvalidDbSnapshotStateFault),
    /// <p>Cannot restore from VPC backup to non-VPC DB instance.</p>
    InvalidRestoreFault(crate::error::InvalidRestoreFault),
    /// <p>The requested subnet is invalid, or multiple subnets were requested that are not all in a common VPC.</p>
    InvalidSubnet(crate::error::InvalidSubnet),
    /// <p>The DB subnet group doesn't cover all Availability Zones after it's created because of users' change.</p>
    InvalidVpcNetworkStateFault(crate::error::InvalidVpcNetworkStateFault),
    /// <p>An error occurred accessing an Amazon Web Services KMS key.</p>
    KmsKeyNotAccessibleFault(crate::error::KmsKeyNotAccessibleFault),
    /// <p>The specified option group could not be found.</p>
    OptionGroupNotFoundFault(crate::error::OptionGroupNotFoundFault),
    /// <p>Provisioned IOPS not available in the specified Availability Zone.</p>
    ProvisionedIopsNotAvailableInAzFault(crate::error::ProvisionedIopsNotAvailableInAzFault),
    /// <p>The request would result in the user exceeding the allowed amount of storage available across all DB instances.</p>
    StorageQuotaExceededFault(crate::error::StorageQuotaExceededFault),
    /// <p>Storage of the <code>StorageType</code> specified can't be associated with the DB instance. </p>
    StorageTypeNotSupportedFault(crate::error::StorageTypeNotSupportedFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RestoreDBInstanceFromDBSnapshotError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RestoreDBInstanceFromDBSnapshotErrorKind::AuthorizationNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            RestoreDBInstanceFromDBSnapshotErrorKind::BackupPolicyNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            RestoreDBInstanceFromDBSnapshotErrorKind::DbInstanceAlreadyExistsFault(_inner) => {
                _inner.fmt(f)
            }
            RestoreDBInstanceFromDBSnapshotErrorKind::DbParameterGroupNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            RestoreDBInstanceFromDBSnapshotErrorKind::DbSecurityGroupNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            RestoreDBInstanceFromDBSnapshotErrorKind::DbSnapshotNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            RestoreDBInstanceFromDBSnapshotErrorKind::DbSubnetGroupDoesNotCoverEnoughAZs(
                _inner,
            ) => _inner.fmt(f),
            RestoreDBInstanceFromDBSnapshotErrorKind::DbSubnetGroupNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            RestoreDBInstanceFromDBSnapshotErrorKind::DomainNotFoundFault(_inner) => _inner.fmt(f),
            RestoreDBInstanceFromDBSnapshotErrorKind::InstanceQuotaExceededFault(_inner) => {
                _inner.fmt(f)
            }
            RestoreDBInstanceFromDBSnapshotErrorKind::InsufficientDbInstanceCapacityFault(
                _inner,
            ) => _inner.fmt(f),
            RestoreDBInstanceFromDBSnapshotErrorKind::InvalidDbSnapshotStateFault(_inner) => {
                _inner.fmt(f)
            }
            RestoreDBInstanceFromDBSnapshotErrorKind::InvalidRestoreFault(_inner) => _inner.fmt(f),
            RestoreDBInstanceFromDBSnapshotErrorKind::InvalidSubnet(_inner) => _inner.fmt(f),
            RestoreDBInstanceFromDBSnapshotErrorKind::InvalidVpcNetworkStateFault(_inner) => {
                _inner.fmt(f)
            }
            RestoreDBInstanceFromDBSnapshotErrorKind::KmsKeyNotAccessibleFault(_inner) => {
                _inner.fmt(f)
            }
            RestoreDBInstanceFromDBSnapshotErrorKind::OptionGroupNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            RestoreDBInstanceFromDBSnapshotErrorKind::ProvisionedIopsNotAvailableInAzFault(
                _inner,
            ) => _inner.fmt(f),
            RestoreDBInstanceFromDBSnapshotErrorKind::StorageQuotaExceededFault(_inner) => {
                _inner.fmt(f)
            }
            RestoreDBInstanceFromDBSnapshotErrorKind::StorageTypeNotSupportedFault(_inner) => {
                _inner.fmt(f)
            }
            RestoreDBInstanceFromDBSnapshotErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RestoreDBInstanceFromDBSnapshotError {
    fn code(&self) -> Option<&str> {
        RestoreDBInstanceFromDBSnapshotError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RestoreDBInstanceFromDBSnapshotError {
    /// Creates a new `RestoreDBInstanceFromDBSnapshotError`.
    pub fn new(
        kind: RestoreDBInstanceFromDBSnapshotErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RestoreDBInstanceFromDBSnapshotError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RestoreDBInstanceFromDBSnapshotErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RestoreDBInstanceFromDBSnapshotError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RestoreDBInstanceFromDBSnapshotErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RestoreDBInstanceFromDBSnapshotErrorKind::AuthorizationNotFoundFault`.
    pub fn is_authorization_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBInstanceFromDBSnapshotErrorKind::AuthorizationNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBInstanceFromDBSnapshotErrorKind::BackupPolicyNotFoundFault`.
    pub fn is_backup_policy_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBInstanceFromDBSnapshotErrorKind::BackupPolicyNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBInstanceFromDBSnapshotErrorKind::DbInstanceAlreadyExistsFault`.
    pub fn is_db_instance_already_exists_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBInstanceFromDBSnapshotErrorKind::DbInstanceAlreadyExistsFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBInstanceFromDBSnapshotErrorKind::DbParameterGroupNotFoundFault`.
    pub fn is_db_parameter_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBInstanceFromDBSnapshotErrorKind::DbParameterGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBInstanceFromDBSnapshotErrorKind::DbSecurityGroupNotFoundFault`.
    pub fn is_db_security_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBInstanceFromDBSnapshotErrorKind::DbSecurityGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBInstanceFromDBSnapshotErrorKind::DbSnapshotNotFoundFault`.
    pub fn is_db_snapshot_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBInstanceFromDBSnapshotErrorKind::DbSnapshotNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBInstanceFromDBSnapshotErrorKind::DbSubnetGroupDoesNotCoverEnoughAZs`.
    pub fn is_db_subnet_group_does_not_cover_enough_a_zs(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBInstanceFromDBSnapshotErrorKind::DbSubnetGroupDoesNotCoverEnoughAZs(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBInstanceFromDBSnapshotErrorKind::DbSubnetGroupNotFoundFault`.
    pub fn is_db_subnet_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBInstanceFromDBSnapshotErrorKind::DbSubnetGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBInstanceFromDBSnapshotErrorKind::DomainNotFoundFault`.
    pub fn is_domain_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBInstanceFromDBSnapshotErrorKind::DomainNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBInstanceFromDBSnapshotErrorKind::InstanceQuotaExceededFault`.
    pub fn is_instance_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBInstanceFromDBSnapshotErrorKind::InstanceQuotaExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBInstanceFromDBSnapshotErrorKind::InsufficientDbInstanceCapacityFault`.
    pub fn is_insufficient_db_instance_capacity_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBInstanceFromDBSnapshotErrorKind::InsufficientDbInstanceCapacityFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBInstanceFromDBSnapshotErrorKind::InvalidDbSnapshotStateFault`.
    pub fn is_invalid_db_snapshot_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBInstanceFromDBSnapshotErrorKind::InvalidDbSnapshotStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBInstanceFromDBSnapshotErrorKind::InvalidRestoreFault`.
    pub fn is_invalid_restore_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBInstanceFromDBSnapshotErrorKind::InvalidRestoreFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBInstanceFromDBSnapshotErrorKind::InvalidSubnet`.
    pub fn is_invalid_subnet(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBInstanceFromDBSnapshotErrorKind::InvalidSubnet(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBInstanceFromDBSnapshotErrorKind::InvalidVpcNetworkStateFault`.
    pub fn is_invalid_vpc_network_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBInstanceFromDBSnapshotErrorKind::InvalidVpcNetworkStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBInstanceFromDBSnapshotErrorKind::KmsKeyNotAccessibleFault`.
    pub fn is_kms_key_not_accessible_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBInstanceFromDBSnapshotErrorKind::KmsKeyNotAccessibleFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBInstanceFromDBSnapshotErrorKind::OptionGroupNotFoundFault`.
    pub fn is_option_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBInstanceFromDBSnapshotErrorKind::OptionGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBInstanceFromDBSnapshotErrorKind::ProvisionedIopsNotAvailableInAzFault`.
    pub fn is_provisioned_iops_not_available_in_az_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBInstanceFromDBSnapshotErrorKind::ProvisionedIopsNotAvailableInAzFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBInstanceFromDBSnapshotErrorKind::StorageQuotaExceededFault`.
    pub fn is_storage_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBInstanceFromDBSnapshotErrorKind::StorageQuotaExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBInstanceFromDBSnapshotErrorKind::StorageTypeNotSupportedFault`.
    pub fn is_storage_type_not_supported_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBInstanceFromDBSnapshotErrorKind::StorageTypeNotSupportedFault(_)
        )
    }
}
impl std::error::Error for RestoreDBInstanceFromDBSnapshotError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RestoreDBInstanceFromDBSnapshotErrorKind::AuthorizationNotFoundFault(_inner) => {
                Some(_inner)
            }
            RestoreDBInstanceFromDBSnapshotErrorKind::BackupPolicyNotFoundFault(_inner) => {
                Some(_inner)
            }
            RestoreDBInstanceFromDBSnapshotErrorKind::DbInstanceAlreadyExistsFault(_inner) => {
                Some(_inner)
            }
            RestoreDBInstanceFromDBSnapshotErrorKind::DbParameterGroupNotFoundFault(_inner) => {
                Some(_inner)
            }
            RestoreDBInstanceFromDBSnapshotErrorKind::DbSecurityGroupNotFoundFault(_inner) => {
                Some(_inner)
            }
            RestoreDBInstanceFromDBSnapshotErrorKind::DbSnapshotNotFoundFault(_inner) => {
                Some(_inner)
            }
            RestoreDBInstanceFromDBSnapshotErrorKind::DbSubnetGroupDoesNotCoverEnoughAZs(
                _inner,
            ) => Some(_inner),
            RestoreDBInstanceFromDBSnapshotErrorKind::DbSubnetGroupNotFoundFault(_inner) => {
                Some(_inner)
            }
            RestoreDBInstanceFromDBSnapshotErrorKind::DomainNotFoundFault(_inner) => Some(_inner),
            RestoreDBInstanceFromDBSnapshotErrorKind::InstanceQuotaExceededFault(_inner) => {
                Some(_inner)
            }
            RestoreDBInstanceFromDBSnapshotErrorKind::InsufficientDbInstanceCapacityFault(
                _inner,
            ) => Some(_inner),
            RestoreDBInstanceFromDBSnapshotErrorKind::InvalidDbSnapshotStateFault(_inner) => {
                Some(_inner)
            }
            RestoreDBInstanceFromDBSnapshotErrorKind::InvalidRestoreFault(_inner) => Some(_inner),
            RestoreDBInstanceFromDBSnapshotErrorKind::InvalidSubnet(_inner) => Some(_inner),
            RestoreDBInstanceFromDBSnapshotErrorKind::InvalidVpcNetworkStateFault(_inner) => {
                Some(_inner)
            }
            RestoreDBInstanceFromDBSnapshotErrorKind::KmsKeyNotAccessibleFault(_inner) => {
                Some(_inner)
            }
            RestoreDBInstanceFromDBSnapshotErrorKind::OptionGroupNotFoundFault(_inner) => {
                Some(_inner)
            }
            RestoreDBInstanceFromDBSnapshotErrorKind::ProvisionedIopsNotAvailableInAzFault(
                _inner,
            ) => Some(_inner),
            RestoreDBInstanceFromDBSnapshotErrorKind::StorageQuotaExceededFault(_inner) => {
                Some(_inner)
            }
            RestoreDBInstanceFromDBSnapshotErrorKind::StorageTypeNotSupportedFault(_inner) => {
                Some(_inner)
            }
            RestoreDBInstanceFromDBSnapshotErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RestoreDBInstanceFromS3` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RestoreDBInstanceFromS3Error {
    /// Kind of error that occurred.
    pub kind: RestoreDBInstanceFromS3ErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RestoreDBInstanceFromS3` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RestoreDBInstanceFromS3ErrorKind {
    /// <p>The specified CIDR IP range or Amazon EC2 security group might not be authorized for the specified DB security group.</p>
    /// <p>Or, RDS might not be authorized to perform necessary actions using IAM on your behalf.</p>
    AuthorizationNotFoundFault(crate::error::AuthorizationNotFoundFault),
    #[allow(missing_docs)] // documentation missing in model
    BackupPolicyNotFoundFault(crate::error::BackupPolicyNotFoundFault),
    /// <p>The user already has a DB instance with the given identifier.</p>
    DbInstanceAlreadyExistsFault(crate::error::DbInstanceAlreadyExistsFault),
    /// <p> <code>DBParameterGroupName</code> doesn't refer to an existing DB parameter group. </p>
    DbParameterGroupNotFoundFault(crate::error::DbParameterGroupNotFoundFault),
    /// <p> <code>DBSecurityGroupName</code> doesn't refer to an existing DB security group. </p>
    DbSecurityGroupNotFoundFault(crate::error::DbSecurityGroupNotFoundFault),
    /// <p>Subnets in the DB subnet group should cover at least two Availability Zones unless there is only one Availability Zone.</p>
    DbSubnetGroupDoesNotCoverEnoughAZs(crate::error::DbSubnetGroupDoesNotCoverEnoughAZs),
    /// <p> <code>DBSubnetGroupName</code> doesn't refer to an existing DB subnet group. </p>
    DbSubnetGroupNotFoundFault(crate::error::DbSubnetGroupNotFoundFault),
    /// <p>The request would result in the user exceeding the allowed number of DB instances.</p>
    InstanceQuotaExceededFault(crate::error::InstanceQuotaExceededFault),
    /// <p>The specified DB instance class isn't available in the specified Availability Zone.</p>
    InsufficientDbInstanceCapacityFault(crate::error::InsufficientDbInstanceCapacityFault),
    /// <p>The specified Amazon S3 bucket name can't be found or Amazon RDS isn't authorized to access the specified Amazon S3 bucket. Verify the <b>SourceS3BucketName</b> and <b>S3IngestionRoleArn</b> values and try again.</p>
    InvalidS3BucketFault(crate::error::InvalidS3BucketFault),
    /// <p>The requested subnet is invalid, or multiple subnets were requested that are not all in a common VPC.</p>
    InvalidSubnet(crate::error::InvalidSubnet),
    /// <p>The DB subnet group doesn't cover all Availability Zones after it's created because of users' change.</p>
    InvalidVpcNetworkStateFault(crate::error::InvalidVpcNetworkStateFault),
    /// <p>An error occurred accessing an Amazon Web Services KMS key.</p>
    KmsKeyNotAccessibleFault(crate::error::KmsKeyNotAccessibleFault),
    /// <p>The specified option group could not be found.</p>
    OptionGroupNotFoundFault(crate::error::OptionGroupNotFoundFault),
    /// <p>Provisioned IOPS not available in the specified Availability Zone.</p>
    ProvisionedIopsNotAvailableInAzFault(crate::error::ProvisionedIopsNotAvailableInAzFault),
    /// <p>The request would result in the user exceeding the allowed amount of storage available across all DB instances.</p>
    StorageQuotaExceededFault(crate::error::StorageQuotaExceededFault),
    /// <p>Storage of the <code>StorageType</code> specified can't be associated with the DB instance. </p>
    StorageTypeNotSupportedFault(crate::error::StorageTypeNotSupportedFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RestoreDBInstanceFromS3Error {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RestoreDBInstanceFromS3ErrorKind::AuthorizationNotFoundFault(_inner) => _inner.fmt(f),
            RestoreDBInstanceFromS3ErrorKind::BackupPolicyNotFoundFault(_inner) => _inner.fmt(f),
            RestoreDBInstanceFromS3ErrorKind::DbInstanceAlreadyExistsFault(_inner) => _inner.fmt(f),
            RestoreDBInstanceFromS3ErrorKind::DbParameterGroupNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            RestoreDBInstanceFromS3ErrorKind::DbSecurityGroupNotFoundFault(_inner) => _inner.fmt(f),
            RestoreDBInstanceFromS3ErrorKind::DbSubnetGroupDoesNotCoverEnoughAZs(_inner) => {
                _inner.fmt(f)
            }
            RestoreDBInstanceFromS3ErrorKind::DbSubnetGroupNotFoundFault(_inner) => _inner.fmt(f),
            RestoreDBInstanceFromS3ErrorKind::InstanceQuotaExceededFault(_inner) => _inner.fmt(f),
            RestoreDBInstanceFromS3ErrorKind::InsufficientDbInstanceCapacityFault(_inner) => {
                _inner.fmt(f)
            }
            RestoreDBInstanceFromS3ErrorKind::InvalidS3BucketFault(_inner) => _inner.fmt(f),
            RestoreDBInstanceFromS3ErrorKind::InvalidSubnet(_inner) => _inner.fmt(f),
            RestoreDBInstanceFromS3ErrorKind::InvalidVpcNetworkStateFault(_inner) => _inner.fmt(f),
            RestoreDBInstanceFromS3ErrorKind::KmsKeyNotAccessibleFault(_inner) => _inner.fmt(f),
            RestoreDBInstanceFromS3ErrorKind::OptionGroupNotFoundFault(_inner) => _inner.fmt(f),
            RestoreDBInstanceFromS3ErrorKind::ProvisionedIopsNotAvailableInAzFault(_inner) => {
                _inner.fmt(f)
            }
            RestoreDBInstanceFromS3ErrorKind::StorageQuotaExceededFault(_inner) => _inner.fmt(f),
            RestoreDBInstanceFromS3ErrorKind::StorageTypeNotSupportedFault(_inner) => _inner.fmt(f),
            RestoreDBInstanceFromS3ErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RestoreDBInstanceFromS3Error {
    fn code(&self) -> Option<&str> {
        RestoreDBInstanceFromS3Error::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RestoreDBInstanceFromS3Error {
    /// Creates a new `RestoreDBInstanceFromS3Error`.
    pub fn new(kind: RestoreDBInstanceFromS3ErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RestoreDBInstanceFromS3Error::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RestoreDBInstanceFromS3ErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RestoreDBInstanceFromS3Error::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RestoreDBInstanceFromS3ErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RestoreDBInstanceFromS3ErrorKind::AuthorizationNotFoundFault`.
    pub fn is_authorization_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBInstanceFromS3ErrorKind::AuthorizationNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBInstanceFromS3ErrorKind::BackupPolicyNotFoundFault`.
    pub fn is_backup_policy_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBInstanceFromS3ErrorKind::BackupPolicyNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBInstanceFromS3ErrorKind::DbInstanceAlreadyExistsFault`.
    pub fn is_db_instance_already_exists_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBInstanceFromS3ErrorKind::DbInstanceAlreadyExistsFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBInstanceFromS3ErrorKind::DbParameterGroupNotFoundFault`.
    pub fn is_db_parameter_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBInstanceFromS3ErrorKind::DbParameterGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBInstanceFromS3ErrorKind::DbSecurityGroupNotFoundFault`.
    pub fn is_db_security_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBInstanceFromS3ErrorKind::DbSecurityGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBInstanceFromS3ErrorKind::DbSubnetGroupDoesNotCoverEnoughAZs`.
    pub fn is_db_subnet_group_does_not_cover_enough_a_zs(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBInstanceFromS3ErrorKind::DbSubnetGroupDoesNotCoverEnoughAZs(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBInstanceFromS3ErrorKind::DbSubnetGroupNotFoundFault`.
    pub fn is_db_subnet_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBInstanceFromS3ErrorKind::DbSubnetGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBInstanceFromS3ErrorKind::InstanceQuotaExceededFault`.
    pub fn is_instance_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBInstanceFromS3ErrorKind::InstanceQuotaExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBInstanceFromS3ErrorKind::InsufficientDbInstanceCapacityFault`.
    pub fn is_insufficient_db_instance_capacity_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBInstanceFromS3ErrorKind::InsufficientDbInstanceCapacityFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBInstanceFromS3ErrorKind::InvalidS3BucketFault`.
    pub fn is_invalid_s3_bucket_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBInstanceFromS3ErrorKind::InvalidS3BucketFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBInstanceFromS3ErrorKind::InvalidSubnet`.
    pub fn is_invalid_subnet(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBInstanceFromS3ErrorKind::InvalidSubnet(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBInstanceFromS3ErrorKind::InvalidVpcNetworkStateFault`.
    pub fn is_invalid_vpc_network_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBInstanceFromS3ErrorKind::InvalidVpcNetworkStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBInstanceFromS3ErrorKind::KmsKeyNotAccessibleFault`.
    pub fn is_kms_key_not_accessible_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBInstanceFromS3ErrorKind::KmsKeyNotAccessibleFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBInstanceFromS3ErrorKind::OptionGroupNotFoundFault`.
    pub fn is_option_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBInstanceFromS3ErrorKind::OptionGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBInstanceFromS3ErrorKind::ProvisionedIopsNotAvailableInAzFault`.
    pub fn is_provisioned_iops_not_available_in_az_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBInstanceFromS3ErrorKind::ProvisionedIopsNotAvailableInAzFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBInstanceFromS3ErrorKind::StorageQuotaExceededFault`.
    pub fn is_storage_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBInstanceFromS3ErrorKind::StorageQuotaExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBInstanceFromS3ErrorKind::StorageTypeNotSupportedFault`.
    pub fn is_storage_type_not_supported_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBInstanceFromS3ErrorKind::StorageTypeNotSupportedFault(_)
        )
    }
}
impl std::error::Error for RestoreDBInstanceFromS3Error {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RestoreDBInstanceFromS3ErrorKind::AuthorizationNotFoundFault(_inner) => Some(_inner),
            RestoreDBInstanceFromS3ErrorKind::BackupPolicyNotFoundFault(_inner) => Some(_inner),
            RestoreDBInstanceFromS3ErrorKind::DbInstanceAlreadyExistsFault(_inner) => Some(_inner),
            RestoreDBInstanceFromS3ErrorKind::DbParameterGroupNotFoundFault(_inner) => Some(_inner),
            RestoreDBInstanceFromS3ErrorKind::DbSecurityGroupNotFoundFault(_inner) => Some(_inner),
            RestoreDBInstanceFromS3ErrorKind::DbSubnetGroupDoesNotCoverEnoughAZs(_inner) => {
                Some(_inner)
            }
            RestoreDBInstanceFromS3ErrorKind::DbSubnetGroupNotFoundFault(_inner) => Some(_inner),
            RestoreDBInstanceFromS3ErrorKind::InstanceQuotaExceededFault(_inner) => Some(_inner),
            RestoreDBInstanceFromS3ErrorKind::InsufficientDbInstanceCapacityFault(_inner) => {
                Some(_inner)
            }
            RestoreDBInstanceFromS3ErrorKind::InvalidS3BucketFault(_inner) => Some(_inner),
            RestoreDBInstanceFromS3ErrorKind::InvalidSubnet(_inner) => Some(_inner),
            RestoreDBInstanceFromS3ErrorKind::InvalidVpcNetworkStateFault(_inner) => Some(_inner),
            RestoreDBInstanceFromS3ErrorKind::KmsKeyNotAccessibleFault(_inner) => Some(_inner),
            RestoreDBInstanceFromS3ErrorKind::OptionGroupNotFoundFault(_inner) => Some(_inner),
            RestoreDBInstanceFromS3ErrorKind::ProvisionedIopsNotAvailableInAzFault(_inner) => {
                Some(_inner)
            }
            RestoreDBInstanceFromS3ErrorKind::StorageQuotaExceededFault(_inner) => Some(_inner),
            RestoreDBInstanceFromS3ErrorKind::StorageTypeNotSupportedFault(_inner) => Some(_inner),
            RestoreDBInstanceFromS3ErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RestoreDBInstanceToPointInTime` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RestoreDBInstanceToPointInTimeError {
    /// Kind of error that occurred.
    pub kind: RestoreDBInstanceToPointInTimeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RestoreDBInstanceToPointInTime` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RestoreDBInstanceToPointInTimeErrorKind {
    /// <p>The specified CIDR IP range or Amazon EC2 security group might not be authorized for the specified DB security group.</p>
    /// <p>Or, RDS might not be authorized to perform necessary actions using IAM on your behalf.</p>
    AuthorizationNotFoundFault(crate::error::AuthorizationNotFoundFault),
    #[allow(missing_docs)] // documentation missing in model
    BackupPolicyNotFoundFault(crate::error::BackupPolicyNotFoundFault),
    /// <p>The user already has a DB instance with the given identifier.</p>
    DbInstanceAlreadyExistsFault(crate::error::DbInstanceAlreadyExistsFault),
    /// <p>No automated backup for this DB instance was found.</p>
    DbInstanceAutomatedBackupNotFoundFault(crate::error::DbInstanceAutomatedBackupNotFoundFault),
    /// <p> <code>DBInstanceIdentifier</code> doesn't refer to an existing DB instance. </p>
    DbInstanceNotFoundFault(crate::error::DbInstanceNotFoundFault),
    /// <p> <code>DBParameterGroupName</code> doesn't refer to an existing DB parameter group. </p>
    DbParameterGroupNotFoundFault(crate::error::DbParameterGroupNotFoundFault),
    /// <p> <code>DBSecurityGroupName</code> doesn't refer to an existing DB security group. </p>
    DbSecurityGroupNotFoundFault(crate::error::DbSecurityGroupNotFoundFault),
    /// <p>Subnets in the DB subnet group should cover at least two Availability Zones unless there is only one Availability Zone.</p>
    DbSubnetGroupDoesNotCoverEnoughAZs(crate::error::DbSubnetGroupDoesNotCoverEnoughAZs),
    /// <p> <code>DBSubnetGroupName</code> doesn't refer to an existing DB subnet group. </p>
    DbSubnetGroupNotFoundFault(crate::error::DbSubnetGroupNotFoundFault),
    /// <p> <code>Domain</code> doesn't refer to an existing Active Directory domain. </p>
    DomainNotFoundFault(crate::error::DomainNotFoundFault),
    /// <p>The request would result in the user exceeding the allowed number of DB instances.</p>
    InstanceQuotaExceededFault(crate::error::InstanceQuotaExceededFault),
    /// <p>The specified DB instance class isn't available in the specified Availability Zone.</p>
    InsufficientDbInstanceCapacityFault(crate::error::InsufficientDbInstanceCapacityFault),
    /// <p>The DB instance isn't in a valid state.</p>
    InvalidDbInstanceStateFault(crate::error::InvalidDbInstanceStateFault),
    /// <p>Cannot restore from VPC backup to non-VPC DB instance.</p>
    InvalidRestoreFault(crate::error::InvalidRestoreFault),
    /// <p>The requested subnet is invalid, or multiple subnets were requested that are not all in a common VPC.</p>
    InvalidSubnet(crate::error::InvalidSubnet),
    /// <p>The DB subnet group doesn't cover all Availability Zones after it's created because of users' change.</p>
    InvalidVpcNetworkStateFault(crate::error::InvalidVpcNetworkStateFault),
    /// <p>An error occurred accessing an Amazon Web Services KMS key.</p>
    KmsKeyNotAccessibleFault(crate::error::KmsKeyNotAccessibleFault),
    /// <p>The specified option group could not be found.</p>
    OptionGroupNotFoundFault(crate::error::OptionGroupNotFoundFault),
    /// <p> <code>SourceDBInstanceIdentifier</code> refers to a DB instance with <code>BackupRetentionPeriod</code> equal to 0. </p>
    PointInTimeRestoreNotEnabledFault(crate::error::PointInTimeRestoreNotEnabledFault),
    /// <p>Provisioned IOPS not available in the specified Availability Zone.</p>
    ProvisionedIopsNotAvailableInAzFault(crate::error::ProvisionedIopsNotAvailableInAzFault),
    /// <p>The request would result in the user exceeding the allowed amount of storage available across all DB instances.</p>
    StorageQuotaExceededFault(crate::error::StorageQuotaExceededFault),
    /// <p>Storage of the <code>StorageType</code> specified can't be associated with the DB instance. </p>
    StorageTypeNotSupportedFault(crate::error::StorageTypeNotSupportedFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RestoreDBInstanceToPointInTimeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RestoreDBInstanceToPointInTimeErrorKind::AuthorizationNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            RestoreDBInstanceToPointInTimeErrorKind::BackupPolicyNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            RestoreDBInstanceToPointInTimeErrorKind::DbInstanceAlreadyExistsFault(_inner) => {
                _inner.fmt(f)
            }
            RestoreDBInstanceToPointInTimeErrorKind::DbInstanceAutomatedBackupNotFoundFault(
                _inner,
            ) => _inner.fmt(f),
            RestoreDBInstanceToPointInTimeErrorKind::DbInstanceNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            RestoreDBInstanceToPointInTimeErrorKind::DbParameterGroupNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            RestoreDBInstanceToPointInTimeErrorKind::DbSecurityGroupNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            RestoreDBInstanceToPointInTimeErrorKind::DbSubnetGroupDoesNotCoverEnoughAZs(_inner) => {
                _inner.fmt(f)
            }
            RestoreDBInstanceToPointInTimeErrorKind::DbSubnetGroupNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            RestoreDBInstanceToPointInTimeErrorKind::DomainNotFoundFault(_inner) => _inner.fmt(f),
            RestoreDBInstanceToPointInTimeErrorKind::InstanceQuotaExceededFault(_inner) => {
                _inner.fmt(f)
            }
            RestoreDBInstanceToPointInTimeErrorKind::InsufficientDbInstanceCapacityFault(
                _inner,
            ) => _inner.fmt(f),
            RestoreDBInstanceToPointInTimeErrorKind::InvalidDbInstanceStateFault(_inner) => {
                _inner.fmt(f)
            }
            RestoreDBInstanceToPointInTimeErrorKind::InvalidRestoreFault(_inner) => _inner.fmt(f),
            RestoreDBInstanceToPointInTimeErrorKind::InvalidSubnet(_inner) => _inner.fmt(f),
            RestoreDBInstanceToPointInTimeErrorKind::InvalidVpcNetworkStateFault(_inner) => {
                _inner.fmt(f)
            }
            RestoreDBInstanceToPointInTimeErrorKind::KmsKeyNotAccessibleFault(_inner) => {
                _inner.fmt(f)
            }
            RestoreDBInstanceToPointInTimeErrorKind::OptionGroupNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            RestoreDBInstanceToPointInTimeErrorKind::PointInTimeRestoreNotEnabledFault(_inner) => {
                _inner.fmt(f)
            }
            RestoreDBInstanceToPointInTimeErrorKind::ProvisionedIopsNotAvailableInAzFault(
                _inner,
            ) => _inner.fmt(f),
            RestoreDBInstanceToPointInTimeErrorKind::StorageQuotaExceededFault(_inner) => {
                _inner.fmt(f)
            }
            RestoreDBInstanceToPointInTimeErrorKind::StorageTypeNotSupportedFault(_inner) => {
                _inner.fmt(f)
            }
            RestoreDBInstanceToPointInTimeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RestoreDBInstanceToPointInTimeError {
    fn code(&self) -> Option<&str> {
        RestoreDBInstanceToPointInTimeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RestoreDBInstanceToPointInTimeError {
    /// Creates a new `RestoreDBInstanceToPointInTimeError`.
    pub fn new(
        kind: RestoreDBInstanceToPointInTimeErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RestoreDBInstanceToPointInTimeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RestoreDBInstanceToPointInTimeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RestoreDBInstanceToPointInTimeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RestoreDBInstanceToPointInTimeErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RestoreDBInstanceToPointInTimeErrorKind::AuthorizationNotFoundFault`.
    pub fn is_authorization_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBInstanceToPointInTimeErrorKind::AuthorizationNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBInstanceToPointInTimeErrorKind::BackupPolicyNotFoundFault`.
    pub fn is_backup_policy_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBInstanceToPointInTimeErrorKind::BackupPolicyNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBInstanceToPointInTimeErrorKind::DbInstanceAlreadyExistsFault`.
    pub fn is_db_instance_already_exists_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBInstanceToPointInTimeErrorKind::DbInstanceAlreadyExistsFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBInstanceToPointInTimeErrorKind::DbInstanceAutomatedBackupNotFoundFault`.
    pub fn is_db_instance_automated_backup_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBInstanceToPointInTimeErrorKind::DbInstanceAutomatedBackupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBInstanceToPointInTimeErrorKind::DbInstanceNotFoundFault`.
    pub fn is_db_instance_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBInstanceToPointInTimeErrorKind::DbInstanceNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBInstanceToPointInTimeErrorKind::DbParameterGroupNotFoundFault`.
    pub fn is_db_parameter_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBInstanceToPointInTimeErrorKind::DbParameterGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBInstanceToPointInTimeErrorKind::DbSecurityGroupNotFoundFault`.
    pub fn is_db_security_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBInstanceToPointInTimeErrorKind::DbSecurityGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBInstanceToPointInTimeErrorKind::DbSubnetGroupDoesNotCoverEnoughAZs`.
    pub fn is_db_subnet_group_does_not_cover_enough_a_zs(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBInstanceToPointInTimeErrorKind::DbSubnetGroupDoesNotCoverEnoughAZs(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBInstanceToPointInTimeErrorKind::DbSubnetGroupNotFoundFault`.
    pub fn is_db_subnet_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBInstanceToPointInTimeErrorKind::DbSubnetGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBInstanceToPointInTimeErrorKind::DomainNotFoundFault`.
    pub fn is_domain_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBInstanceToPointInTimeErrorKind::DomainNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBInstanceToPointInTimeErrorKind::InstanceQuotaExceededFault`.
    pub fn is_instance_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBInstanceToPointInTimeErrorKind::InstanceQuotaExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBInstanceToPointInTimeErrorKind::InsufficientDbInstanceCapacityFault`.
    pub fn is_insufficient_db_instance_capacity_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBInstanceToPointInTimeErrorKind::InsufficientDbInstanceCapacityFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBInstanceToPointInTimeErrorKind::InvalidDbInstanceStateFault`.
    pub fn is_invalid_db_instance_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBInstanceToPointInTimeErrorKind::InvalidDbInstanceStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBInstanceToPointInTimeErrorKind::InvalidRestoreFault`.
    pub fn is_invalid_restore_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBInstanceToPointInTimeErrorKind::InvalidRestoreFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBInstanceToPointInTimeErrorKind::InvalidSubnet`.
    pub fn is_invalid_subnet(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBInstanceToPointInTimeErrorKind::InvalidSubnet(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBInstanceToPointInTimeErrorKind::InvalidVpcNetworkStateFault`.
    pub fn is_invalid_vpc_network_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBInstanceToPointInTimeErrorKind::InvalidVpcNetworkStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBInstanceToPointInTimeErrorKind::KmsKeyNotAccessibleFault`.
    pub fn is_kms_key_not_accessible_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBInstanceToPointInTimeErrorKind::KmsKeyNotAccessibleFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBInstanceToPointInTimeErrorKind::OptionGroupNotFoundFault`.
    pub fn is_option_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBInstanceToPointInTimeErrorKind::OptionGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBInstanceToPointInTimeErrorKind::PointInTimeRestoreNotEnabledFault`.
    pub fn is_point_in_time_restore_not_enabled_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBInstanceToPointInTimeErrorKind::PointInTimeRestoreNotEnabledFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBInstanceToPointInTimeErrorKind::ProvisionedIopsNotAvailableInAzFault`.
    pub fn is_provisioned_iops_not_available_in_az_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBInstanceToPointInTimeErrorKind::ProvisionedIopsNotAvailableInAzFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBInstanceToPointInTimeErrorKind::StorageQuotaExceededFault`.
    pub fn is_storage_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBInstanceToPointInTimeErrorKind::StorageQuotaExceededFault(_)
        )
    }
    /// Returns `true` if the error kind is `RestoreDBInstanceToPointInTimeErrorKind::StorageTypeNotSupportedFault`.
    pub fn is_storage_type_not_supported_fault(&self) -> bool {
        matches!(
            &self.kind,
            RestoreDBInstanceToPointInTimeErrorKind::StorageTypeNotSupportedFault(_)
        )
    }
}
impl std::error::Error for RestoreDBInstanceToPointInTimeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RestoreDBInstanceToPointInTimeErrorKind::AuthorizationNotFoundFault(_inner) => {
                Some(_inner)
            }
            RestoreDBInstanceToPointInTimeErrorKind::BackupPolicyNotFoundFault(_inner) => {
                Some(_inner)
            }
            RestoreDBInstanceToPointInTimeErrorKind::DbInstanceAlreadyExistsFault(_inner) => {
                Some(_inner)
            }
            RestoreDBInstanceToPointInTimeErrorKind::DbInstanceAutomatedBackupNotFoundFault(
                _inner,
            ) => Some(_inner),
            RestoreDBInstanceToPointInTimeErrorKind::DbInstanceNotFoundFault(_inner) => {
                Some(_inner)
            }
            RestoreDBInstanceToPointInTimeErrorKind::DbParameterGroupNotFoundFault(_inner) => {
                Some(_inner)
            }
            RestoreDBInstanceToPointInTimeErrorKind::DbSecurityGroupNotFoundFault(_inner) => {
                Some(_inner)
            }
            RestoreDBInstanceToPointInTimeErrorKind::DbSubnetGroupDoesNotCoverEnoughAZs(_inner) => {
                Some(_inner)
            }
            RestoreDBInstanceToPointInTimeErrorKind::DbSubnetGroupNotFoundFault(_inner) => {
                Some(_inner)
            }
            RestoreDBInstanceToPointInTimeErrorKind::DomainNotFoundFault(_inner) => Some(_inner),
            RestoreDBInstanceToPointInTimeErrorKind::InstanceQuotaExceededFault(_inner) => {
                Some(_inner)
            }
            RestoreDBInstanceToPointInTimeErrorKind::InsufficientDbInstanceCapacityFault(
                _inner,
            ) => Some(_inner),
            RestoreDBInstanceToPointInTimeErrorKind::InvalidDbInstanceStateFault(_inner) => {
                Some(_inner)
            }
            RestoreDBInstanceToPointInTimeErrorKind::InvalidRestoreFault(_inner) => Some(_inner),
            RestoreDBInstanceToPointInTimeErrorKind::InvalidSubnet(_inner) => Some(_inner),
            RestoreDBInstanceToPointInTimeErrorKind::InvalidVpcNetworkStateFault(_inner) => {
                Some(_inner)
            }
            RestoreDBInstanceToPointInTimeErrorKind::KmsKeyNotAccessibleFault(_inner) => {
                Some(_inner)
            }
            RestoreDBInstanceToPointInTimeErrorKind::OptionGroupNotFoundFault(_inner) => {
                Some(_inner)
            }
            RestoreDBInstanceToPointInTimeErrorKind::PointInTimeRestoreNotEnabledFault(_inner) => {
                Some(_inner)
            }
            RestoreDBInstanceToPointInTimeErrorKind::ProvisionedIopsNotAvailableInAzFault(
                _inner,
            ) => Some(_inner),
            RestoreDBInstanceToPointInTimeErrorKind::StorageQuotaExceededFault(_inner) => {
                Some(_inner)
            }
            RestoreDBInstanceToPointInTimeErrorKind::StorageTypeNotSupportedFault(_inner) => {
                Some(_inner)
            }
            RestoreDBInstanceToPointInTimeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RevokeDBSecurityGroupIngress` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RevokeDBSecurityGroupIngressError {
    /// Kind of error that occurred.
    pub kind: RevokeDBSecurityGroupIngressErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RevokeDBSecurityGroupIngress` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RevokeDBSecurityGroupIngressErrorKind {
    /// <p>The specified CIDR IP range or Amazon EC2 security group might not be authorized for the specified DB security group.</p>
    /// <p>Or, RDS might not be authorized to perform necessary actions using IAM on your behalf.</p>
    AuthorizationNotFoundFault(crate::error::AuthorizationNotFoundFault),
    /// <p> <code>DBSecurityGroupName</code> doesn't refer to an existing DB security group. </p>
    DbSecurityGroupNotFoundFault(crate::error::DbSecurityGroupNotFoundFault),
    /// <p>The state of the DB security group doesn't allow deletion.</p>
    InvalidDbSecurityGroupStateFault(crate::error::InvalidDbSecurityGroupStateFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RevokeDBSecurityGroupIngressError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RevokeDBSecurityGroupIngressErrorKind::AuthorizationNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            RevokeDBSecurityGroupIngressErrorKind::DbSecurityGroupNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            RevokeDBSecurityGroupIngressErrorKind::InvalidDbSecurityGroupStateFault(_inner) => {
                _inner.fmt(f)
            }
            RevokeDBSecurityGroupIngressErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RevokeDBSecurityGroupIngressError {
    fn code(&self) -> Option<&str> {
        RevokeDBSecurityGroupIngressError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RevokeDBSecurityGroupIngressError {
    /// Creates a new `RevokeDBSecurityGroupIngressError`.
    pub fn new(kind: RevokeDBSecurityGroupIngressErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RevokeDBSecurityGroupIngressError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RevokeDBSecurityGroupIngressErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RevokeDBSecurityGroupIngressError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RevokeDBSecurityGroupIngressErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RevokeDBSecurityGroupIngressErrorKind::AuthorizationNotFoundFault`.
    pub fn is_authorization_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            RevokeDBSecurityGroupIngressErrorKind::AuthorizationNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `RevokeDBSecurityGroupIngressErrorKind::DbSecurityGroupNotFoundFault`.
    pub fn is_db_security_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            RevokeDBSecurityGroupIngressErrorKind::DbSecurityGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `RevokeDBSecurityGroupIngressErrorKind::InvalidDbSecurityGroupStateFault`.
    pub fn is_invalid_db_security_group_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            RevokeDBSecurityGroupIngressErrorKind::InvalidDbSecurityGroupStateFault(_)
        )
    }
}
impl std::error::Error for RevokeDBSecurityGroupIngressError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RevokeDBSecurityGroupIngressErrorKind::AuthorizationNotFoundFault(_inner) => {
                Some(_inner)
            }
            RevokeDBSecurityGroupIngressErrorKind::DbSecurityGroupNotFoundFault(_inner) => {
                Some(_inner)
            }
            RevokeDBSecurityGroupIngressErrorKind::InvalidDbSecurityGroupStateFault(_inner) => {
                Some(_inner)
            }
            RevokeDBSecurityGroupIngressErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartActivityStream` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartActivityStreamError {
    /// Kind of error that occurred.
    pub kind: StartActivityStreamErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartActivityStream` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartActivityStreamErrorKind {
    /// <p> <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster. </p>
    DbClusterNotFoundFault(crate::error::DbClusterNotFoundFault),
    /// <p> <code>DBInstanceIdentifier</code> doesn't refer to an existing DB instance. </p>
    DbInstanceNotFoundFault(crate::error::DbInstanceNotFoundFault),
    /// <p>The requested operation can't be performed while the cluster is in this state.</p>
    InvalidDbClusterStateFault(crate::error::InvalidDbClusterStateFault),
    /// <p>The DB instance isn't in a valid state.</p>
    InvalidDbInstanceStateFault(crate::error::InvalidDbInstanceStateFault),
    /// <p>An error occurred accessing an Amazon Web Services KMS key.</p>
    KmsKeyNotAccessibleFault(crate::error::KmsKeyNotAccessibleFault),
    /// <p>The specified resource ID was not found.</p>
    ResourceNotFoundFault(crate::error::ResourceNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartActivityStreamError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartActivityStreamErrorKind::DbClusterNotFoundFault(_inner) => _inner.fmt(f),
            StartActivityStreamErrorKind::DbInstanceNotFoundFault(_inner) => _inner.fmt(f),
            StartActivityStreamErrorKind::InvalidDbClusterStateFault(_inner) => _inner.fmt(f),
            StartActivityStreamErrorKind::InvalidDbInstanceStateFault(_inner) => _inner.fmt(f),
            StartActivityStreamErrorKind::KmsKeyNotAccessibleFault(_inner) => _inner.fmt(f),
            StartActivityStreamErrorKind::ResourceNotFoundFault(_inner) => _inner.fmt(f),
            StartActivityStreamErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartActivityStreamError {
    fn code(&self) -> Option<&str> {
        StartActivityStreamError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartActivityStreamError {
    /// Creates a new `StartActivityStreamError`.
    pub fn new(kind: StartActivityStreamErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartActivityStreamError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartActivityStreamErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartActivityStreamError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartActivityStreamErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartActivityStreamErrorKind::DbClusterNotFoundFault`.
    pub fn is_db_cluster_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            StartActivityStreamErrorKind::DbClusterNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `StartActivityStreamErrorKind::DbInstanceNotFoundFault`.
    pub fn is_db_instance_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            StartActivityStreamErrorKind::DbInstanceNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `StartActivityStreamErrorKind::InvalidDbClusterStateFault`.
    pub fn is_invalid_db_cluster_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            StartActivityStreamErrorKind::InvalidDbClusterStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `StartActivityStreamErrorKind::InvalidDbInstanceStateFault`.
    pub fn is_invalid_db_instance_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            StartActivityStreamErrorKind::InvalidDbInstanceStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `StartActivityStreamErrorKind::KmsKeyNotAccessibleFault`.
    pub fn is_kms_key_not_accessible_fault(&self) -> bool {
        matches!(
            &self.kind,
            StartActivityStreamErrorKind::KmsKeyNotAccessibleFault(_)
        )
    }
    /// Returns `true` if the error kind is `StartActivityStreamErrorKind::ResourceNotFoundFault`.
    pub fn is_resource_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            StartActivityStreamErrorKind::ResourceNotFoundFault(_)
        )
    }
}
impl std::error::Error for StartActivityStreamError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartActivityStreamErrorKind::DbClusterNotFoundFault(_inner) => Some(_inner),
            StartActivityStreamErrorKind::DbInstanceNotFoundFault(_inner) => Some(_inner),
            StartActivityStreamErrorKind::InvalidDbClusterStateFault(_inner) => Some(_inner),
            StartActivityStreamErrorKind::InvalidDbInstanceStateFault(_inner) => Some(_inner),
            StartActivityStreamErrorKind::KmsKeyNotAccessibleFault(_inner) => Some(_inner),
            StartActivityStreamErrorKind::ResourceNotFoundFault(_inner) => Some(_inner),
            StartActivityStreamErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartDBCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartDBClusterError {
    /// Kind of error that occurred.
    pub kind: StartDBClusterErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartDBCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartDBClusterErrorKind {
    /// <p> <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster. </p>
    DbClusterNotFoundFault(crate::error::DbClusterNotFoundFault),
    /// <p>The requested operation can't be performed while the cluster is in this state.</p>
    InvalidDbClusterStateFault(crate::error::InvalidDbClusterStateFault),
    /// <p>The DB instance isn't in a valid state.</p>
    InvalidDbInstanceStateFault(crate::error::InvalidDbInstanceStateFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartDBClusterError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartDBClusterErrorKind::DbClusterNotFoundFault(_inner) => _inner.fmt(f),
            StartDBClusterErrorKind::InvalidDbClusterStateFault(_inner) => _inner.fmt(f),
            StartDBClusterErrorKind::InvalidDbInstanceStateFault(_inner) => _inner.fmt(f),
            StartDBClusterErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartDBClusterError {
    fn code(&self) -> Option<&str> {
        StartDBClusterError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartDBClusterError {
    /// Creates a new `StartDBClusterError`.
    pub fn new(kind: StartDBClusterErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartDBClusterError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartDBClusterErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartDBClusterError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartDBClusterErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartDBClusterErrorKind::DbClusterNotFoundFault`.
    pub fn is_db_cluster_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            StartDBClusterErrorKind::DbClusterNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `StartDBClusterErrorKind::InvalidDbClusterStateFault`.
    pub fn is_invalid_db_cluster_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            StartDBClusterErrorKind::InvalidDbClusterStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `StartDBClusterErrorKind::InvalidDbInstanceStateFault`.
    pub fn is_invalid_db_instance_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            StartDBClusterErrorKind::InvalidDbInstanceStateFault(_)
        )
    }
}
impl std::error::Error for StartDBClusterError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartDBClusterErrorKind::DbClusterNotFoundFault(_inner) => Some(_inner),
            StartDBClusterErrorKind::InvalidDbClusterStateFault(_inner) => Some(_inner),
            StartDBClusterErrorKind::InvalidDbInstanceStateFault(_inner) => Some(_inner),
            StartDBClusterErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartDBInstance` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartDBInstanceError {
    /// Kind of error that occurred.
    pub kind: StartDBInstanceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartDBInstance` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartDBInstanceErrorKind {
    /// <p>The specified CIDR IP range or Amazon EC2 security group might not be authorized for the specified DB security group.</p>
    /// <p>Or, RDS might not be authorized to perform necessary actions using IAM on your behalf.</p>
    AuthorizationNotFoundFault(crate::error::AuthorizationNotFoundFault),
    /// <p> <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster. </p>
    DbClusterNotFoundFault(crate::error::DbClusterNotFoundFault),
    /// <p> <code>DBInstanceIdentifier</code> doesn't refer to an existing DB instance. </p>
    DbInstanceNotFoundFault(crate::error::DbInstanceNotFoundFault),
    /// <p>Subnets in the DB subnet group should cover at least two Availability Zones unless there is only one Availability Zone.</p>
    DbSubnetGroupDoesNotCoverEnoughAZs(crate::error::DbSubnetGroupDoesNotCoverEnoughAZs),
    /// <p> <code>DBSubnetGroupName</code> doesn't refer to an existing DB subnet group. </p>
    DbSubnetGroupNotFoundFault(crate::error::DbSubnetGroupNotFoundFault),
    /// <p>The specified DB instance class isn't available in the specified Availability Zone.</p>
    InsufficientDbInstanceCapacityFault(crate::error::InsufficientDbInstanceCapacityFault),
    /// <p>The requested operation can't be performed while the cluster is in this state.</p>
    InvalidDbClusterStateFault(crate::error::InvalidDbClusterStateFault),
    /// <p>The DB instance isn't in a valid state.</p>
    InvalidDbInstanceStateFault(crate::error::InvalidDbInstanceStateFault),
    /// <p>The requested subnet is invalid, or multiple subnets were requested that are not all in a common VPC.</p>
    InvalidSubnet(crate::error::InvalidSubnet),
    /// <p>The DB subnet group doesn't cover all Availability Zones after it's created because of users' change.</p>
    InvalidVpcNetworkStateFault(crate::error::InvalidVpcNetworkStateFault),
    /// <p>An error occurred accessing an Amazon Web Services KMS key.</p>
    KmsKeyNotAccessibleFault(crate::error::KmsKeyNotAccessibleFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartDBInstanceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartDBInstanceErrorKind::AuthorizationNotFoundFault(_inner) => _inner.fmt(f),
            StartDBInstanceErrorKind::DbClusterNotFoundFault(_inner) => _inner.fmt(f),
            StartDBInstanceErrorKind::DbInstanceNotFoundFault(_inner) => _inner.fmt(f),
            StartDBInstanceErrorKind::DbSubnetGroupDoesNotCoverEnoughAZs(_inner) => _inner.fmt(f),
            StartDBInstanceErrorKind::DbSubnetGroupNotFoundFault(_inner) => _inner.fmt(f),
            StartDBInstanceErrorKind::InsufficientDbInstanceCapacityFault(_inner) => _inner.fmt(f),
            StartDBInstanceErrorKind::InvalidDbClusterStateFault(_inner) => _inner.fmt(f),
            StartDBInstanceErrorKind::InvalidDbInstanceStateFault(_inner) => _inner.fmt(f),
            StartDBInstanceErrorKind::InvalidSubnet(_inner) => _inner.fmt(f),
            StartDBInstanceErrorKind::InvalidVpcNetworkStateFault(_inner) => _inner.fmt(f),
            StartDBInstanceErrorKind::KmsKeyNotAccessibleFault(_inner) => _inner.fmt(f),
            StartDBInstanceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartDBInstanceError {
    fn code(&self) -> Option<&str> {
        StartDBInstanceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartDBInstanceError {
    /// Creates a new `StartDBInstanceError`.
    pub fn new(kind: StartDBInstanceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartDBInstanceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartDBInstanceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartDBInstanceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartDBInstanceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartDBInstanceErrorKind::AuthorizationNotFoundFault`.
    pub fn is_authorization_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            StartDBInstanceErrorKind::AuthorizationNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `StartDBInstanceErrorKind::DbClusterNotFoundFault`.
    pub fn is_db_cluster_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            StartDBInstanceErrorKind::DbClusterNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `StartDBInstanceErrorKind::DbInstanceNotFoundFault`.
    pub fn is_db_instance_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            StartDBInstanceErrorKind::DbInstanceNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `StartDBInstanceErrorKind::DbSubnetGroupDoesNotCoverEnoughAZs`.
    pub fn is_db_subnet_group_does_not_cover_enough_a_zs(&self) -> bool {
        matches!(
            &self.kind,
            StartDBInstanceErrorKind::DbSubnetGroupDoesNotCoverEnoughAZs(_)
        )
    }
    /// Returns `true` if the error kind is `StartDBInstanceErrorKind::DbSubnetGroupNotFoundFault`.
    pub fn is_db_subnet_group_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            StartDBInstanceErrorKind::DbSubnetGroupNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `StartDBInstanceErrorKind::InsufficientDbInstanceCapacityFault`.
    pub fn is_insufficient_db_instance_capacity_fault(&self) -> bool {
        matches!(
            &self.kind,
            StartDBInstanceErrorKind::InsufficientDbInstanceCapacityFault(_)
        )
    }
    /// Returns `true` if the error kind is `StartDBInstanceErrorKind::InvalidDbClusterStateFault`.
    pub fn is_invalid_db_cluster_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            StartDBInstanceErrorKind::InvalidDbClusterStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `StartDBInstanceErrorKind::InvalidDbInstanceStateFault`.
    pub fn is_invalid_db_instance_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            StartDBInstanceErrorKind::InvalidDbInstanceStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `StartDBInstanceErrorKind::InvalidSubnet`.
    pub fn is_invalid_subnet(&self) -> bool {
        matches!(&self.kind, StartDBInstanceErrorKind::InvalidSubnet(_))
    }
    /// Returns `true` if the error kind is `StartDBInstanceErrorKind::InvalidVpcNetworkStateFault`.
    pub fn is_invalid_vpc_network_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            StartDBInstanceErrorKind::InvalidVpcNetworkStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `StartDBInstanceErrorKind::KmsKeyNotAccessibleFault`.
    pub fn is_kms_key_not_accessible_fault(&self) -> bool {
        matches!(
            &self.kind,
            StartDBInstanceErrorKind::KmsKeyNotAccessibleFault(_)
        )
    }
}
impl std::error::Error for StartDBInstanceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartDBInstanceErrorKind::AuthorizationNotFoundFault(_inner) => Some(_inner),
            StartDBInstanceErrorKind::DbClusterNotFoundFault(_inner) => Some(_inner),
            StartDBInstanceErrorKind::DbInstanceNotFoundFault(_inner) => Some(_inner),
            StartDBInstanceErrorKind::DbSubnetGroupDoesNotCoverEnoughAZs(_inner) => Some(_inner),
            StartDBInstanceErrorKind::DbSubnetGroupNotFoundFault(_inner) => Some(_inner),
            StartDBInstanceErrorKind::InsufficientDbInstanceCapacityFault(_inner) => Some(_inner),
            StartDBInstanceErrorKind::InvalidDbClusterStateFault(_inner) => Some(_inner),
            StartDBInstanceErrorKind::InvalidDbInstanceStateFault(_inner) => Some(_inner),
            StartDBInstanceErrorKind::InvalidSubnet(_inner) => Some(_inner),
            StartDBInstanceErrorKind::InvalidVpcNetworkStateFault(_inner) => Some(_inner),
            StartDBInstanceErrorKind::KmsKeyNotAccessibleFault(_inner) => Some(_inner),
            StartDBInstanceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartDBInstanceAutomatedBackupsReplication` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartDBInstanceAutomatedBackupsReplicationError {
    /// Kind of error that occurred.
    pub kind: StartDBInstanceAutomatedBackupsReplicationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartDBInstanceAutomatedBackupsReplication` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartDBInstanceAutomatedBackupsReplicationErrorKind {
    /// <p>The quota for retained automated backups was exceeded. This prevents you from retaining any additional automated backups. The retained automated backups quota is the same as your DB Instance quota.</p>
    DbInstanceAutomatedBackupQuotaExceededFault(
        crate::error::DbInstanceAutomatedBackupQuotaExceededFault,
    ),
    /// <p> <code>DBInstanceIdentifier</code> doesn't refer to an existing DB instance. </p>
    DbInstanceNotFoundFault(crate::error::DbInstanceNotFoundFault),
    /// <p>The DB instance isn't in a valid state.</p>
    InvalidDbInstanceStateFault(crate::error::InvalidDbInstanceStateFault),
    /// <p>An error occurred accessing an Amazon Web Services KMS key.</p>
    KmsKeyNotAccessibleFault(crate::error::KmsKeyNotAccessibleFault),
    /// <p>Storage of the <code>StorageType</code> specified can't be associated with the DB instance. </p>
    StorageTypeNotSupportedFault(crate::error::StorageTypeNotSupportedFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartDBInstanceAutomatedBackupsReplicationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartDBInstanceAutomatedBackupsReplicationErrorKind::DbInstanceAutomatedBackupQuotaExceededFault(_inner) =>
            _inner.fmt(f)
            ,
            StartDBInstanceAutomatedBackupsReplicationErrorKind::DbInstanceNotFoundFault(_inner) =>
            _inner.fmt(f)
            ,
            StartDBInstanceAutomatedBackupsReplicationErrorKind::InvalidDbInstanceStateFault(_inner) =>
            _inner.fmt(f)
            ,
            StartDBInstanceAutomatedBackupsReplicationErrorKind::KmsKeyNotAccessibleFault(_inner) =>
            _inner.fmt(f)
            ,
            StartDBInstanceAutomatedBackupsReplicationErrorKind::StorageTypeNotSupportedFault(_inner) =>
            _inner.fmt(f)
            ,
            StartDBInstanceAutomatedBackupsReplicationErrorKind::Unhandled(_inner) => {
                _inner.fmt(f)
            }
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartDBInstanceAutomatedBackupsReplicationError {
    fn code(&self) -> Option<&str> {
        StartDBInstanceAutomatedBackupsReplicationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartDBInstanceAutomatedBackupsReplicationError {
    /// Creates a new `StartDBInstanceAutomatedBackupsReplicationError`.
    pub fn new(
        kind: StartDBInstanceAutomatedBackupsReplicationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartDBInstanceAutomatedBackupsReplicationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartDBInstanceAutomatedBackupsReplicationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartDBInstanceAutomatedBackupsReplicationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartDBInstanceAutomatedBackupsReplicationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartDBInstanceAutomatedBackupsReplicationErrorKind::DbInstanceAutomatedBackupQuotaExceededFault`.
    pub fn is_db_instance_automated_backup_quota_exceeded_fault(&self) -> bool {
        matches!(&self.kind, StartDBInstanceAutomatedBackupsReplicationErrorKind::DbInstanceAutomatedBackupQuotaExceededFault(_))
    }
    /// Returns `true` if the error kind is `StartDBInstanceAutomatedBackupsReplicationErrorKind::DbInstanceNotFoundFault`.
    pub fn is_db_instance_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            StartDBInstanceAutomatedBackupsReplicationErrorKind::DbInstanceNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `StartDBInstanceAutomatedBackupsReplicationErrorKind::InvalidDbInstanceStateFault`.
    pub fn is_invalid_db_instance_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            StartDBInstanceAutomatedBackupsReplicationErrorKind::InvalidDbInstanceStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `StartDBInstanceAutomatedBackupsReplicationErrorKind::KmsKeyNotAccessibleFault`.
    pub fn is_kms_key_not_accessible_fault(&self) -> bool {
        matches!(
            &self.kind,
            StartDBInstanceAutomatedBackupsReplicationErrorKind::KmsKeyNotAccessibleFault(_)
        )
    }
    /// Returns `true` if the error kind is `StartDBInstanceAutomatedBackupsReplicationErrorKind::StorageTypeNotSupportedFault`.
    pub fn is_storage_type_not_supported_fault(&self) -> bool {
        matches!(
            &self.kind,
            StartDBInstanceAutomatedBackupsReplicationErrorKind::StorageTypeNotSupportedFault(_)
        )
    }
}
impl std::error::Error for StartDBInstanceAutomatedBackupsReplicationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartDBInstanceAutomatedBackupsReplicationErrorKind::DbInstanceAutomatedBackupQuotaExceededFault(_inner) =>
            Some(_inner)
            ,
            StartDBInstanceAutomatedBackupsReplicationErrorKind::DbInstanceNotFoundFault(_inner) =>
            Some(_inner)
            ,
            StartDBInstanceAutomatedBackupsReplicationErrorKind::InvalidDbInstanceStateFault(_inner) =>
            Some(_inner)
            ,
            StartDBInstanceAutomatedBackupsReplicationErrorKind::KmsKeyNotAccessibleFault(_inner) =>
            Some(_inner)
            ,
            StartDBInstanceAutomatedBackupsReplicationErrorKind::StorageTypeNotSupportedFault(_inner) =>
            Some(_inner)
            ,
            StartDBInstanceAutomatedBackupsReplicationErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `StartExportTask` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartExportTaskError {
    /// Kind of error that occurred.
    pub kind: StartExportTaskErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartExportTask` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartExportTaskErrorKind {
    /// <p> <code>DBClusterSnapshotIdentifier</code> doesn't refer to an existing DB cluster snapshot. </p>
    DbClusterSnapshotNotFoundFault(crate::error::DbClusterSnapshotNotFoundFault),
    /// <p> <code>DBSnapshotIdentifier</code> doesn't refer to an existing DB snapshot. </p>
    DbSnapshotNotFoundFault(crate::error::DbSnapshotNotFoundFault),
    /// <p>You can't start an export task that's already running.</p>
    ExportTaskAlreadyExistsFault(crate::error::ExportTaskAlreadyExistsFault),
    /// <p>The IAM role requires additional permissions to export to an Amazon S3 bucket.</p>
    IamRoleMissingPermissionsFault(crate::error::IamRoleMissingPermissionsFault),
    /// <p>The IAM role is missing for exporting to an Amazon S3 bucket.</p>
    IamRoleNotFoundFault(crate::error::IamRoleNotFoundFault),
    /// <p>The export is invalid for exporting to an Amazon S3 bucket.</p>
    InvalidExportOnlyFault(crate::error::InvalidExportOnlyFault),
    /// <p>The state of the export snapshot is invalid for exporting to an Amazon S3 bucket.</p>
    InvalidExportSourceStateFault(crate::error::InvalidExportSourceStateFault),
    /// <p>The specified Amazon S3 bucket name can't be found or Amazon RDS isn't authorized to access the specified Amazon S3 bucket. Verify the <b>SourceS3BucketName</b> and <b>S3IngestionRoleArn</b> values and try again.</p>
    InvalidS3BucketFault(crate::error::InvalidS3BucketFault),
    /// <p>An error occurred accessing an Amazon Web Services KMS key.</p>
    KmsKeyNotAccessibleFault(crate::error::KmsKeyNotAccessibleFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartExportTaskError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartExportTaskErrorKind::DbClusterSnapshotNotFoundFault(_inner) => _inner.fmt(f),
            StartExportTaskErrorKind::DbSnapshotNotFoundFault(_inner) => _inner.fmt(f),
            StartExportTaskErrorKind::ExportTaskAlreadyExistsFault(_inner) => _inner.fmt(f),
            StartExportTaskErrorKind::IamRoleMissingPermissionsFault(_inner) => _inner.fmt(f),
            StartExportTaskErrorKind::IamRoleNotFoundFault(_inner) => _inner.fmt(f),
            StartExportTaskErrorKind::InvalidExportOnlyFault(_inner) => _inner.fmt(f),
            StartExportTaskErrorKind::InvalidExportSourceStateFault(_inner) => _inner.fmt(f),
            StartExportTaskErrorKind::InvalidS3BucketFault(_inner) => _inner.fmt(f),
            StartExportTaskErrorKind::KmsKeyNotAccessibleFault(_inner) => _inner.fmt(f),
            StartExportTaskErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartExportTaskError {
    fn code(&self) -> Option<&str> {
        StartExportTaskError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartExportTaskError {
    /// Creates a new `StartExportTaskError`.
    pub fn new(kind: StartExportTaskErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartExportTaskError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartExportTaskErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartExportTaskError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartExportTaskErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartExportTaskErrorKind::DbClusterSnapshotNotFoundFault`.
    pub fn is_db_cluster_snapshot_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            StartExportTaskErrorKind::DbClusterSnapshotNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `StartExportTaskErrorKind::DbSnapshotNotFoundFault`.
    pub fn is_db_snapshot_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            StartExportTaskErrorKind::DbSnapshotNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `StartExportTaskErrorKind::ExportTaskAlreadyExistsFault`.
    pub fn is_export_task_already_exists_fault(&self) -> bool {
        matches!(
            &self.kind,
            StartExportTaskErrorKind::ExportTaskAlreadyExistsFault(_)
        )
    }
    /// Returns `true` if the error kind is `StartExportTaskErrorKind::IamRoleMissingPermissionsFault`.
    pub fn is_iam_role_missing_permissions_fault(&self) -> bool {
        matches!(
            &self.kind,
            StartExportTaskErrorKind::IamRoleMissingPermissionsFault(_)
        )
    }
    /// Returns `true` if the error kind is `StartExportTaskErrorKind::IamRoleNotFoundFault`.
    pub fn is_iam_role_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            StartExportTaskErrorKind::IamRoleNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `StartExportTaskErrorKind::InvalidExportOnlyFault`.
    pub fn is_invalid_export_only_fault(&self) -> bool {
        matches!(
            &self.kind,
            StartExportTaskErrorKind::InvalidExportOnlyFault(_)
        )
    }
    /// Returns `true` if the error kind is `StartExportTaskErrorKind::InvalidExportSourceStateFault`.
    pub fn is_invalid_export_source_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            StartExportTaskErrorKind::InvalidExportSourceStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `StartExportTaskErrorKind::InvalidS3BucketFault`.
    pub fn is_invalid_s3_bucket_fault(&self) -> bool {
        matches!(
            &self.kind,
            StartExportTaskErrorKind::InvalidS3BucketFault(_)
        )
    }
    /// Returns `true` if the error kind is `StartExportTaskErrorKind::KmsKeyNotAccessibleFault`.
    pub fn is_kms_key_not_accessible_fault(&self) -> bool {
        matches!(
            &self.kind,
            StartExportTaskErrorKind::KmsKeyNotAccessibleFault(_)
        )
    }
}
impl std::error::Error for StartExportTaskError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartExportTaskErrorKind::DbClusterSnapshotNotFoundFault(_inner) => Some(_inner),
            StartExportTaskErrorKind::DbSnapshotNotFoundFault(_inner) => Some(_inner),
            StartExportTaskErrorKind::ExportTaskAlreadyExistsFault(_inner) => Some(_inner),
            StartExportTaskErrorKind::IamRoleMissingPermissionsFault(_inner) => Some(_inner),
            StartExportTaskErrorKind::IamRoleNotFoundFault(_inner) => Some(_inner),
            StartExportTaskErrorKind::InvalidExportOnlyFault(_inner) => Some(_inner),
            StartExportTaskErrorKind::InvalidExportSourceStateFault(_inner) => Some(_inner),
            StartExportTaskErrorKind::InvalidS3BucketFault(_inner) => Some(_inner),
            StartExportTaskErrorKind::KmsKeyNotAccessibleFault(_inner) => Some(_inner),
            StartExportTaskErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StopActivityStream` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StopActivityStreamError {
    /// Kind of error that occurred.
    pub kind: StopActivityStreamErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StopActivityStream` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StopActivityStreamErrorKind {
    /// <p> <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster. </p>
    DbClusterNotFoundFault(crate::error::DbClusterNotFoundFault),
    /// <p> <code>DBInstanceIdentifier</code> doesn't refer to an existing DB instance. </p>
    DbInstanceNotFoundFault(crate::error::DbInstanceNotFoundFault),
    /// <p>The requested operation can't be performed while the cluster is in this state.</p>
    InvalidDbClusterStateFault(crate::error::InvalidDbClusterStateFault),
    /// <p>The DB instance isn't in a valid state.</p>
    InvalidDbInstanceStateFault(crate::error::InvalidDbInstanceStateFault),
    /// <p>The specified resource ID was not found.</p>
    ResourceNotFoundFault(crate::error::ResourceNotFoundFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StopActivityStreamError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StopActivityStreamErrorKind::DbClusterNotFoundFault(_inner) => _inner.fmt(f),
            StopActivityStreamErrorKind::DbInstanceNotFoundFault(_inner) => _inner.fmt(f),
            StopActivityStreamErrorKind::InvalidDbClusterStateFault(_inner) => _inner.fmt(f),
            StopActivityStreamErrorKind::InvalidDbInstanceStateFault(_inner) => _inner.fmt(f),
            StopActivityStreamErrorKind::ResourceNotFoundFault(_inner) => _inner.fmt(f),
            StopActivityStreamErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StopActivityStreamError {
    fn code(&self) -> Option<&str> {
        StopActivityStreamError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StopActivityStreamError {
    /// Creates a new `StopActivityStreamError`.
    pub fn new(kind: StopActivityStreamErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StopActivityStreamError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StopActivityStreamErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StopActivityStreamError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StopActivityStreamErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StopActivityStreamErrorKind::DbClusterNotFoundFault`.
    pub fn is_db_cluster_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            StopActivityStreamErrorKind::DbClusterNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `StopActivityStreamErrorKind::DbInstanceNotFoundFault`.
    pub fn is_db_instance_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            StopActivityStreamErrorKind::DbInstanceNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `StopActivityStreamErrorKind::InvalidDbClusterStateFault`.
    pub fn is_invalid_db_cluster_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            StopActivityStreamErrorKind::InvalidDbClusterStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `StopActivityStreamErrorKind::InvalidDbInstanceStateFault`.
    pub fn is_invalid_db_instance_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            StopActivityStreamErrorKind::InvalidDbInstanceStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `StopActivityStreamErrorKind::ResourceNotFoundFault`.
    pub fn is_resource_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            StopActivityStreamErrorKind::ResourceNotFoundFault(_)
        )
    }
}
impl std::error::Error for StopActivityStreamError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StopActivityStreamErrorKind::DbClusterNotFoundFault(_inner) => Some(_inner),
            StopActivityStreamErrorKind::DbInstanceNotFoundFault(_inner) => Some(_inner),
            StopActivityStreamErrorKind::InvalidDbClusterStateFault(_inner) => Some(_inner),
            StopActivityStreamErrorKind::InvalidDbInstanceStateFault(_inner) => Some(_inner),
            StopActivityStreamErrorKind::ResourceNotFoundFault(_inner) => Some(_inner),
            StopActivityStreamErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StopDBCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StopDBClusterError {
    /// Kind of error that occurred.
    pub kind: StopDBClusterErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StopDBCluster` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StopDBClusterErrorKind {
    /// <p> <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster. </p>
    DbClusterNotFoundFault(crate::error::DbClusterNotFoundFault),
    /// <p>The requested operation can't be performed while the cluster is in this state.</p>
    InvalidDbClusterStateFault(crate::error::InvalidDbClusterStateFault),
    /// <p>The DB instance isn't in a valid state.</p>
    InvalidDbInstanceStateFault(crate::error::InvalidDbInstanceStateFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StopDBClusterError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StopDBClusterErrorKind::DbClusterNotFoundFault(_inner) => _inner.fmt(f),
            StopDBClusterErrorKind::InvalidDbClusterStateFault(_inner) => _inner.fmt(f),
            StopDBClusterErrorKind::InvalidDbInstanceStateFault(_inner) => _inner.fmt(f),
            StopDBClusterErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StopDBClusterError {
    fn code(&self) -> Option<&str> {
        StopDBClusterError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StopDBClusterError {
    /// Creates a new `StopDBClusterError`.
    pub fn new(kind: StopDBClusterErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StopDBClusterError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StopDBClusterErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StopDBClusterError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StopDBClusterErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StopDBClusterErrorKind::DbClusterNotFoundFault`.
    pub fn is_db_cluster_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            StopDBClusterErrorKind::DbClusterNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `StopDBClusterErrorKind::InvalidDbClusterStateFault`.
    pub fn is_invalid_db_cluster_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            StopDBClusterErrorKind::InvalidDbClusterStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `StopDBClusterErrorKind::InvalidDbInstanceStateFault`.
    pub fn is_invalid_db_instance_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            StopDBClusterErrorKind::InvalidDbInstanceStateFault(_)
        )
    }
}
impl std::error::Error for StopDBClusterError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StopDBClusterErrorKind::DbClusterNotFoundFault(_inner) => Some(_inner),
            StopDBClusterErrorKind::InvalidDbClusterStateFault(_inner) => Some(_inner),
            StopDBClusterErrorKind::InvalidDbInstanceStateFault(_inner) => Some(_inner),
            StopDBClusterErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StopDBInstance` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StopDBInstanceError {
    /// Kind of error that occurred.
    pub kind: StopDBInstanceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StopDBInstance` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StopDBInstanceErrorKind {
    /// <p> <code>DBInstanceIdentifier</code> doesn't refer to an existing DB instance. </p>
    DbInstanceNotFoundFault(crate::error::DbInstanceNotFoundFault),
    /// <p> <code>DBSnapshotIdentifier</code> is already used by an existing snapshot. </p>
    DbSnapshotAlreadyExistsFault(crate::error::DbSnapshotAlreadyExistsFault),
    /// <p>The requested operation can't be performed while the cluster is in this state.</p>
    InvalidDbClusterStateFault(crate::error::InvalidDbClusterStateFault),
    /// <p>The DB instance isn't in a valid state.</p>
    InvalidDbInstanceStateFault(crate::error::InvalidDbInstanceStateFault),
    /// <p>The request would result in the user exceeding the allowed number of DB snapshots.</p>
    SnapshotQuotaExceededFault(crate::error::SnapshotQuotaExceededFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StopDBInstanceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StopDBInstanceErrorKind::DbInstanceNotFoundFault(_inner) => _inner.fmt(f),
            StopDBInstanceErrorKind::DbSnapshotAlreadyExistsFault(_inner) => _inner.fmt(f),
            StopDBInstanceErrorKind::InvalidDbClusterStateFault(_inner) => _inner.fmt(f),
            StopDBInstanceErrorKind::InvalidDbInstanceStateFault(_inner) => _inner.fmt(f),
            StopDBInstanceErrorKind::SnapshotQuotaExceededFault(_inner) => _inner.fmt(f),
            StopDBInstanceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StopDBInstanceError {
    fn code(&self) -> Option<&str> {
        StopDBInstanceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StopDBInstanceError {
    /// Creates a new `StopDBInstanceError`.
    pub fn new(kind: StopDBInstanceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StopDBInstanceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StopDBInstanceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StopDBInstanceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StopDBInstanceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StopDBInstanceErrorKind::DbInstanceNotFoundFault`.
    pub fn is_db_instance_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            StopDBInstanceErrorKind::DbInstanceNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `StopDBInstanceErrorKind::DbSnapshotAlreadyExistsFault`.
    pub fn is_db_snapshot_already_exists_fault(&self) -> bool {
        matches!(
            &self.kind,
            StopDBInstanceErrorKind::DbSnapshotAlreadyExistsFault(_)
        )
    }
    /// Returns `true` if the error kind is `StopDBInstanceErrorKind::InvalidDbClusterStateFault`.
    pub fn is_invalid_db_cluster_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            StopDBInstanceErrorKind::InvalidDbClusterStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `StopDBInstanceErrorKind::InvalidDbInstanceStateFault`.
    pub fn is_invalid_db_instance_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            StopDBInstanceErrorKind::InvalidDbInstanceStateFault(_)
        )
    }
    /// Returns `true` if the error kind is `StopDBInstanceErrorKind::SnapshotQuotaExceededFault`.
    pub fn is_snapshot_quota_exceeded_fault(&self) -> bool {
        matches!(
            &self.kind,
            StopDBInstanceErrorKind::SnapshotQuotaExceededFault(_)
        )
    }
}
impl std::error::Error for StopDBInstanceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StopDBInstanceErrorKind::DbInstanceNotFoundFault(_inner) => Some(_inner),
            StopDBInstanceErrorKind::DbSnapshotAlreadyExistsFault(_inner) => Some(_inner),
            StopDBInstanceErrorKind::InvalidDbClusterStateFault(_inner) => Some(_inner),
            StopDBInstanceErrorKind::InvalidDbInstanceStateFault(_inner) => Some(_inner),
            StopDBInstanceErrorKind::SnapshotQuotaExceededFault(_inner) => Some(_inner),
            StopDBInstanceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StopDBInstanceAutomatedBackupsReplication` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StopDBInstanceAutomatedBackupsReplicationError {
    /// Kind of error that occurred.
    pub kind: StopDBInstanceAutomatedBackupsReplicationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StopDBInstanceAutomatedBackupsReplication` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StopDBInstanceAutomatedBackupsReplicationErrorKind {
    /// <p> <code>DBInstanceIdentifier</code> doesn't refer to an existing DB instance. </p>
    DbInstanceNotFoundFault(crate::error::DbInstanceNotFoundFault),
    /// <p>The DB instance isn't in a valid state.</p>
    InvalidDbInstanceStateFault(crate::error::InvalidDbInstanceStateFault),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StopDBInstanceAutomatedBackupsReplicationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StopDBInstanceAutomatedBackupsReplicationErrorKind::DbInstanceNotFoundFault(_inner) => {
                _inner.fmt(f)
            }
            StopDBInstanceAutomatedBackupsReplicationErrorKind::InvalidDbInstanceStateFault(
                _inner,
            ) => _inner.fmt(f),
            StopDBInstanceAutomatedBackupsReplicationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StopDBInstanceAutomatedBackupsReplicationError {
    fn code(&self) -> Option<&str> {
        StopDBInstanceAutomatedBackupsReplicationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StopDBInstanceAutomatedBackupsReplicationError {
    /// Creates a new `StopDBInstanceAutomatedBackupsReplicationError`.
    pub fn new(
        kind: StopDBInstanceAutomatedBackupsReplicationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StopDBInstanceAutomatedBackupsReplicationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StopDBInstanceAutomatedBackupsReplicationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StopDBInstanceAutomatedBackupsReplicationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StopDBInstanceAutomatedBackupsReplicationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StopDBInstanceAutomatedBackupsReplicationErrorKind::DbInstanceNotFoundFault`.
    pub fn is_db_instance_not_found_fault(&self) -> bool {
        matches!(
            &self.kind,
            StopDBInstanceAutomatedBackupsReplicationErrorKind::DbInstanceNotFoundFault(_)
        )
    }
    /// Returns `true` if the error kind is `StopDBInstanceAutomatedBackupsReplicationErrorKind::InvalidDbInstanceStateFault`.
    pub fn is_invalid_db_instance_state_fault(&self) -> bool {
        matches!(
            &self.kind,
            StopDBInstanceAutomatedBackupsReplicationErrorKind::InvalidDbInstanceStateFault(_)
        )
    }
}
impl std::error::Error for StopDBInstanceAutomatedBackupsReplicationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StopDBInstanceAutomatedBackupsReplicationErrorKind::DbInstanceNotFoundFault(_inner) => {
                Some(_inner)
            }
            StopDBInstanceAutomatedBackupsReplicationErrorKind::InvalidDbInstanceStateFault(
                _inner,
            ) => Some(_inner),
            StopDBInstanceAutomatedBackupsReplicationErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// <p>The DB instance isn't in a valid state.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidDbInstanceStateFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidDbInstanceStateFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidDbInstanceStateFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidDbInstanceStateFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidDbInstanceStateFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "InvalidDbInstanceStateFault [InvalidDBInstanceStateFault]"
        )?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidDbInstanceStateFault {}
/// See [`InvalidDbInstanceStateFault`](crate::error::InvalidDbInstanceStateFault)
pub mod invalid_db_instance_state_fault {
    /// A builder for [`InvalidDbInstanceStateFault`](crate::error::InvalidDbInstanceStateFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidDbInstanceStateFault`](crate::error::InvalidDbInstanceStateFault)
        pub fn build(self) -> crate::error::InvalidDbInstanceStateFault {
            crate::error::InvalidDbInstanceStateFault {
                message: self.message,
            }
        }
    }
}
impl InvalidDbInstanceStateFault {
    /// Creates a new builder-style object to manufacture [`InvalidDbInstanceStateFault`](crate::error::InvalidDbInstanceStateFault)
    pub fn builder() -> crate::error::invalid_db_instance_state_fault::Builder {
        crate::error::invalid_db_instance_state_fault::Builder::default()
    }
}

/// <p> <code>DBInstanceIdentifier</code> doesn't refer to an existing DB instance. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DbInstanceNotFoundFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DbInstanceNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DbInstanceNotFoundFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DbInstanceNotFoundFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DbInstanceNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DbInstanceNotFoundFault [DBInstanceNotFoundFault]")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for DbInstanceNotFoundFault {}
/// See [`DbInstanceNotFoundFault`](crate::error::DbInstanceNotFoundFault)
pub mod db_instance_not_found_fault {
    /// A builder for [`DbInstanceNotFoundFault`](crate::error::DbInstanceNotFoundFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DbInstanceNotFoundFault`](crate::error::DbInstanceNotFoundFault)
        pub fn build(self) -> crate::error::DbInstanceNotFoundFault {
            crate::error::DbInstanceNotFoundFault {
                message: self.message,
            }
        }
    }
}
impl DbInstanceNotFoundFault {
    /// Creates a new builder-style object to manufacture [`DbInstanceNotFoundFault`](crate::error::DbInstanceNotFoundFault)
    pub fn builder() -> crate::error::db_instance_not_found_fault::Builder {
        crate::error::db_instance_not_found_fault::Builder::default()
    }
}

/// <p>The request would result in the user exceeding the allowed number of DB snapshots.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SnapshotQuotaExceededFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SnapshotQuotaExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SnapshotQuotaExceededFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl SnapshotQuotaExceededFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for SnapshotQuotaExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "SnapshotQuotaExceededFault")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for SnapshotQuotaExceededFault {}
/// See [`SnapshotQuotaExceededFault`](crate::error::SnapshotQuotaExceededFault)
pub mod snapshot_quota_exceeded_fault {
    /// A builder for [`SnapshotQuotaExceededFault`](crate::error::SnapshotQuotaExceededFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`SnapshotQuotaExceededFault`](crate::error::SnapshotQuotaExceededFault)
        pub fn build(self) -> crate::error::SnapshotQuotaExceededFault {
            crate::error::SnapshotQuotaExceededFault {
                message: self.message,
            }
        }
    }
}
impl SnapshotQuotaExceededFault {
    /// Creates a new builder-style object to manufacture [`SnapshotQuotaExceededFault`](crate::error::SnapshotQuotaExceededFault)
    pub fn builder() -> crate::error::snapshot_quota_exceeded_fault::Builder {
        crate::error::snapshot_quota_exceeded_fault::Builder::default()
    }
}

/// <p>The requested operation can't be performed while the cluster is in this state.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidDbClusterStateFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidDbClusterStateFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidDbClusterStateFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidDbClusterStateFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidDbClusterStateFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidDbClusterStateFault [InvalidDBClusterStateFault]")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidDbClusterStateFault {}
/// See [`InvalidDbClusterStateFault`](crate::error::InvalidDbClusterStateFault)
pub mod invalid_db_cluster_state_fault {
    /// A builder for [`InvalidDbClusterStateFault`](crate::error::InvalidDbClusterStateFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidDbClusterStateFault`](crate::error::InvalidDbClusterStateFault)
        pub fn build(self) -> crate::error::InvalidDbClusterStateFault {
            crate::error::InvalidDbClusterStateFault {
                message: self.message,
            }
        }
    }
}
impl InvalidDbClusterStateFault {
    /// Creates a new builder-style object to manufacture [`InvalidDbClusterStateFault`](crate::error::InvalidDbClusterStateFault)
    pub fn builder() -> crate::error::invalid_db_cluster_state_fault::Builder {
        crate::error::invalid_db_cluster_state_fault::Builder::default()
    }
}

/// <p> <code>DBSnapshotIdentifier</code> is already used by an existing snapshot. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DbSnapshotAlreadyExistsFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DbSnapshotAlreadyExistsFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DbSnapshotAlreadyExistsFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DbSnapshotAlreadyExistsFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DbSnapshotAlreadyExistsFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "DbSnapshotAlreadyExistsFault [DBSnapshotAlreadyExistsFault]"
        )?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for DbSnapshotAlreadyExistsFault {}
/// See [`DbSnapshotAlreadyExistsFault`](crate::error::DbSnapshotAlreadyExistsFault)
pub mod db_snapshot_already_exists_fault {
    /// A builder for [`DbSnapshotAlreadyExistsFault`](crate::error::DbSnapshotAlreadyExistsFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DbSnapshotAlreadyExistsFault`](crate::error::DbSnapshotAlreadyExistsFault)
        pub fn build(self) -> crate::error::DbSnapshotAlreadyExistsFault {
            crate::error::DbSnapshotAlreadyExistsFault {
                message: self.message,
            }
        }
    }
}
impl DbSnapshotAlreadyExistsFault {
    /// Creates a new builder-style object to manufacture [`DbSnapshotAlreadyExistsFault`](crate::error::DbSnapshotAlreadyExistsFault)
    pub fn builder() -> crate::error::db_snapshot_already_exists_fault::Builder {
        crate::error::db_snapshot_already_exists_fault::Builder::default()
    }
}

/// <p> <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DbClusterNotFoundFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DbClusterNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DbClusterNotFoundFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DbClusterNotFoundFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DbClusterNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DbClusterNotFoundFault [DBClusterNotFoundFault]")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for DbClusterNotFoundFault {}
/// See [`DbClusterNotFoundFault`](crate::error::DbClusterNotFoundFault)
pub mod db_cluster_not_found_fault {
    /// A builder for [`DbClusterNotFoundFault`](crate::error::DbClusterNotFoundFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DbClusterNotFoundFault`](crate::error::DbClusterNotFoundFault)
        pub fn build(self) -> crate::error::DbClusterNotFoundFault {
            crate::error::DbClusterNotFoundFault {
                message: self.message,
            }
        }
    }
}
impl DbClusterNotFoundFault {
    /// Creates a new builder-style object to manufacture [`DbClusterNotFoundFault`](crate::error::DbClusterNotFoundFault)
    pub fn builder() -> crate::error::db_cluster_not_found_fault::Builder {
        crate::error::db_cluster_not_found_fault::Builder::default()
    }
}

/// <p>The specified resource ID was not found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceNotFoundFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundFault")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundFault {}
/// See [`ResourceNotFoundFault`](crate::error::ResourceNotFoundFault)
pub mod resource_not_found_fault {
    /// A builder for [`ResourceNotFoundFault`](crate::error::ResourceNotFoundFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundFault`](crate::error::ResourceNotFoundFault)
        pub fn build(self) -> crate::error::ResourceNotFoundFault {
            crate::error::ResourceNotFoundFault {
                message: self.message,
            }
        }
    }
}
impl ResourceNotFoundFault {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundFault`](crate::error::ResourceNotFoundFault)
    pub fn builder() -> crate::error::resource_not_found_fault::Builder {
        crate::error::resource_not_found_fault::Builder::default()
    }
}

/// <p>An error occurred accessing an Amazon Web Services KMS key.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KmsKeyNotAccessibleFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for KmsKeyNotAccessibleFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KmsKeyNotAccessibleFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl KmsKeyNotAccessibleFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for KmsKeyNotAccessibleFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "KmsKeyNotAccessibleFault [KMSKeyNotAccessibleFault]")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for KmsKeyNotAccessibleFault {}
/// See [`KmsKeyNotAccessibleFault`](crate::error::KmsKeyNotAccessibleFault)
pub mod kms_key_not_accessible_fault {
    /// A builder for [`KmsKeyNotAccessibleFault`](crate::error::KmsKeyNotAccessibleFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`KmsKeyNotAccessibleFault`](crate::error::KmsKeyNotAccessibleFault)
        pub fn build(self) -> crate::error::KmsKeyNotAccessibleFault {
            crate::error::KmsKeyNotAccessibleFault {
                message: self.message,
            }
        }
    }
}
impl KmsKeyNotAccessibleFault {
    /// Creates a new builder-style object to manufacture [`KmsKeyNotAccessibleFault`](crate::error::KmsKeyNotAccessibleFault)
    pub fn builder() -> crate::error::kms_key_not_accessible_fault::Builder {
        crate::error::kms_key_not_accessible_fault::Builder::default()
    }
}

/// <p>The specified Amazon S3 bucket name can't be found or Amazon RDS isn't authorized to access the specified Amazon S3 bucket. Verify the <b>SourceS3BucketName</b> and <b>S3IngestionRoleArn</b> values and try again.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidS3BucketFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidS3BucketFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidS3BucketFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidS3BucketFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidS3BucketFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidS3BucketFault")?;
        if let Some(inner_9) = &self.message {
            write!(f, ": {}", inner_9)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidS3BucketFault {}
/// See [`InvalidS3BucketFault`](crate::error::InvalidS3BucketFault)
pub mod invalid_s3_bucket_fault {
    /// A builder for [`InvalidS3BucketFault`](crate::error::InvalidS3BucketFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidS3BucketFault`](crate::error::InvalidS3BucketFault)
        pub fn build(self) -> crate::error::InvalidS3BucketFault {
            crate::error::InvalidS3BucketFault {
                message: self.message,
            }
        }
    }
}
impl InvalidS3BucketFault {
    /// Creates a new builder-style object to manufacture [`InvalidS3BucketFault`](crate::error::InvalidS3BucketFault)
    pub fn builder() -> crate::error::invalid_s3_bucket_fault::Builder {
        crate::error::invalid_s3_bucket_fault::Builder::default()
    }
}

/// <p>The state of the export snapshot is invalid for exporting to an Amazon S3 bucket.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidExportSourceStateFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidExportSourceStateFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidExportSourceStateFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidExportSourceStateFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidExportSourceStateFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidExportSourceStateFault")?;
        if let Some(inner_10) = &self.message {
            write!(f, ": {}", inner_10)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidExportSourceStateFault {}
/// See [`InvalidExportSourceStateFault`](crate::error::InvalidExportSourceStateFault)
pub mod invalid_export_source_state_fault {
    /// A builder for [`InvalidExportSourceStateFault`](crate::error::InvalidExportSourceStateFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidExportSourceStateFault`](crate::error::InvalidExportSourceStateFault)
        pub fn build(self) -> crate::error::InvalidExportSourceStateFault {
            crate::error::InvalidExportSourceStateFault {
                message: self.message,
            }
        }
    }
}
impl InvalidExportSourceStateFault {
    /// Creates a new builder-style object to manufacture [`InvalidExportSourceStateFault`](crate::error::InvalidExportSourceStateFault)
    pub fn builder() -> crate::error::invalid_export_source_state_fault::Builder {
        crate::error::invalid_export_source_state_fault::Builder::default()
    }
}

/// <p>The export is invalid for exporting to an Amazon S3 bucket.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidExportOnlyFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidExportOnlyFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidExportOnlyFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidExportOnlyFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidExportOnlyFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidExportOnlyFault")?;
        if let Some(inner_11) = &self.message {
            write!(f, ": {}", inner_11)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidExportOnlyFault {}
/// See [`InvalidExportOnlyFault`](crate::error::InvalidExportOnlyFault)
pub mod invalid_export_only_fault {
    /// A builder for [`InvalidExportOnlyFault`](crate::error::InvalidExportOnlyFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidExportOnlyFault`](crate::error::InvalidExportOnlyFault)
        pub fn build(self) -> crate::error::InvalidExportOnlyFault {
            crate::error::InvalidExportOnlyFault {
                message: self.message,
            }
        }
    }
}
impl InvalidExportOnlyFault {
    /// Creates a new builder-style object to manufacture [`InvalidExportOnlyFault`](crate::error::InvalidExportOnlyFault)
    pub fn builder() -> crate::error::invalid_export_only_fault::Builder {
        crate::error::invalid_export_only_fault::Builder::default()
    }
}

/// <p>The IAM role is missing for exporting to an Amazon S3 bucket.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IamRoleNotFoundFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for IamRoleNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IamRoleNotFoundFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl IamRoleNotFoundFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for IamRoleNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "IamRoleNotFoundFault")?;
        if let Some(inner_12) = &self.message {
            write!(f, ": {}", inner_12)?;
        }
        Ok(())
    }
}
impl std::error::Error for IamRoleNotFoundFault {}
/// See [`IamRoleNotFoundFault`](crate::error::IamRoleNotFoundFault)
pub mod iam_role_not_found_fault {
    /// A builder for [`IamRoleNotFoundFault`](crate::error::IamRoleNotFoundFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`IamRoleNotFoundFault`](crate::error::IamRoleNotFoundFault)
        pub fn build(self) -> crate::error::IamRoleNotFoundFault {
            crate::error::IamRoleNotFoundFault {
                message: self.message,
            }
        }
    }
}
impl IamRoleNotFoundFault {
    /// Creates a new builder-style object to manufacture [`IamRoleNotFoundFault`](crate::error::IamRoleNotFoundFault)
    pub fn builder() -> crate::error::iam_role_not_found_fault::Builder {
        crate::error::iam_role_not_found_fault::Builder::default()
    }
}

/// <p>The IAM role requires additional permissions to export to an Amazon S3 bucket.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IamRoleMissingPermissionsFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for IamRoleMissingPermissionsFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IamRoleMissingPermissionsFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl IamRoleMissingPermissionsFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for IamRoleMissingPermissionsFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "IamRoleMissingPermissionsFault")?;
        if let Some(inner_13) = &self.message {
            write!(f, ": {}", inner_13)?;
        }
        Ok(())
    }
}
impl std::error::Error for IamRoleMissingPermissionsFault {}
/// See [`IamRoleMissingPermissionsFault`](crate::error::IamRoleMissingPermissionsFault)
pub mod iam_role_missing_permissions_fault {
    /// A builder for [`IamRoleMissingPermissionsFault`](crate::error::IamRoleMissingPermissionsFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`IamRoleMissingPermissionsFault`](crate::error::IamRoleMissingPermissionsFault)
        pub fn build(self) -> crate::error::IamRoleMissingPermissionsFault {
            crate::error::IamRoleMissingPermissionsFault {
                message: self.message,
            }
        }
    }
}
impl IamRoleMissingPermissionsFault {
    /// Creates a new builder-style object to manufacture [`IamRoleMissingPermissionsFault`](crate::error::IamRoleMissingPermissionsFault)
    pub fn builder() -> crate::error::iam_role_missing_permissions_fault::Builder {
        crate::error::iam_role_missing_permissions_fault::Builder::default()
    }
}

/// <p>You can't start an export task that's already running.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ExportTaskAlreadyExistsFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ExportTaskAlreadyExistsFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ExportTaskAlreadyExistsFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ExportTaskAlreadyExistsFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ExportTaskAlreadyExistsFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ExportTaskAlreadyExistsFault")?;
        if let Some(inner_14) = &self.message {
            write!(f, ": {}", inner_14)?;
        }
        Ok(())
    }
}
impl std::error::Error for ExportTaskAlreadyExistsFault {}
/// See [`ExportTaskAlreadyExistsFault`](crate::error::ExportTaskAlreadyExistsFault)
pub mod export_task_already_exists_fault {
    /// A builder for [`ExportTaskAlreadyExistsFault`](crate::error::ExportTaskAlreadyExistsFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ExportTaskAlreadyExistsFault`](crate::error::ExportTaskAlreadyExistsFault)
        pub fn build(self) -> crate::error::ExportTaskAlreadyExistsFault {
            crate::error::ExportTaskAlreadyExistsFault {
                message: self.message,
            }
        }
    }
}
impl ExportTaskAlreadyExistsFault {
    /// Creates a new builder-style object to manufacture [`ExportTaskAlreadyExistsFault`](crate::error::ExportTaskAlreadyExistsFault)
    pub fn builder() -> crate::error::export_task_already_exists_fault::Builder {
        crate::error::export_task_already_exists_fault::Builder::default()
    }
}

/// <p> <code>DBSnapshotIdentifier</code> doesn't refer to an existing DB snapshot. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DbSnapshotNotFoundFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DbSnapshotNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DbSnapshotNotFoundFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DbSnapshotNotFoundFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DbSnapshotNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DbSnapshotNotFoundFault [DBSnapshotNotFoundFault]")?;
        if let Some(inner_15) = &self.message {
            write!(f, ": {}", inner_15)?;
        }
        Ok(())
    }
}
impl std::error::Error for DbSnapshotNotFoundFault {}
/// See [`DbSnapshotNotFoundFault`](crate::error::DbSnapshotNotFoundFault)
pub mod db_snapshot_not_found_fault {
    /// A builder for [`DbSnapshotNotFoundFault`](crate::error::DbSnapshotNotFoundFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DbSnapshotNotFoundFault`](crate::error::DbSnapshotNotFoundFault)
        pub fn build(self) -> crate::error::DbSnapshotNotFoundFault {
            crate::error::DbSnapshotNotFoundFault {
                message: self.message,
            }
        }
    }
}
impl DbSnapshotNotFoundFault {
    /// Creates a new builder-style object to manufacture [`DbSnapshotNotFoundFault`](crate::error::DbSnapshotNotFoundFault)
    pub fn builder() -> crate::error::db_snapshot_not_found_fault::Builder {
        crate::error::db_snapshot_not_found_fault::Builder::default()
    }
}

/// <p> <code>DBClusterSnapshotIdentifier</code> doesn't refer to an existing DB cluster snapshot. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DbClusterSnapshotNotFoundFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DbClusterSnapshotNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DbClusterSnapshotNotFoundFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DbClusterSnapshotNotFoundFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DbClusterSnapshotNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "DbClusterSnapshotNotFoundFault [DBClusterSnapshotNotFoundFault]"
        )?;
        if let Some(inner_16) = &self.message {
            write!(f, ": {}", inner_16)?;
        }
        Ok(())
    }
}
impl std::error::Error for DbClusterSnapshotNotFoundFault {}
/// See [`DbClusterSnapshotNotFoundFault`](crate::error::DbClusterSnapshotNotFoundFault)
pub mod db_cluster_snapshot_not_found_fault {
    /// A builder for [`DbClusterSnapshotNotFoundFault`](crate::error::DbClusterSnapshotNotFoundFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DbClusterSnapshotNotFoundFault`](crate::error::DbClusterSnapshotNotFoundFault)
        pub fn build(self) -> crate::error::DbClusterSnapshotNotFoundFault {
            crate::error::DbClusterSnapshotNotFoundFault {
                message: self.message,
            }
        }
    }
}
impl DbClusterSnapshotNotFoundFault {
    /// Creates a new builder-style object to manufacture [`DbClusterSnapshotNotFoundFault`](crate::error::DbClusterSnapshotNotFoundFault)
    pub fn builder() -> crate::error::db_cluster_snapshot_not_found_fault::Builder {
        crate::error::db_cluster_snapshot_not_found_fault::Builder::default()
    }
}

/// <p>Storage of the <code>StorageType</code> specified can't be associated with the DB instance. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StorageTypeNotSupportedFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for StorageTypeNotSupportedFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StorageTypeNotSupportedFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl StorageTypeNotSupportedFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for StorageTypeNotSupportedFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "StorageTypeNotSupportedFault")?;
        if let Some(inner_17) = &self.message {
            write!(f, ": {}", inner_17)?;
        }
        Ok(())
    }
}
impl std::error::Error for StorageTypeNotSupportedFault {}
/// See [`StorageTypeNotSupportedFault`](crate::error::StorageTypeNotSupportedFault)
pub mod storage_type_not_supported_fault {
    /// A builder for [`StorageTypeNotSupportedFault`](crate::error::StorageTypeNotSupportedFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`StorageTypeNotSupportedFault`](crate::error::StorageTypeNotSupportedFault)
        pub fn build(self) -> crate::error::StorageTypeNotSupportedFault {
            crate::error::StorageTypeNotSupportedFault {
                message: self.message,
            }
        }
    }
}
impl StorageTypeNotSupportedFault {
    /// Creates a new builder-style object to manufacture [`StorageTypeNotSupportedFault`](crate::error::StorageTypeNotSupportedFault)
    pub fn builder() -> crate::error::storage_type_not_supported_fault::Builder {
        crate::error::storage_type_not_supported_fault::Builder::default()
    }
}

/// <p>The quota for retained automated backups was exceeded. This prevents you from retaining any additional automated backups. The retained automated backups quota is the same as your DB Instance quota.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DbInstanceAutomatedBackupQuotaExceededFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DbInstanceAutomatedBackupQuotaExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DbInstanceAutomatedBackupQuotaExceededFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DbInstanceAutomatedBackupQuotaExceededFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DbInstanceAutomatedBackupQuotaExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DbInstanceAutomatedBackupQuotaExceededFault [DBInstanceAutomatedBackupQuotaExceededFault]")?;
        if let Some(inner_18) = &self.message {
            write!(f, ": {}", inner_18)?;
        }
        Ok(())
    }
}
impl std::error::Error for DbInstanceAutomatedBackupQuotaExceededFault {}
/// See [`DbInstanceAutomatedBackupQuotaExceededFault`](crate::error::DbInstanceAutomatedBackupQuotaExceededFault)
pub mod db_instance_automated_backup_quota_exceeded_fault {
    /// A builder for [`DbInstanceAutomatedBackupQuotaExceededFault`](crate::error::DbInstanceAutomatedBackupQuotaExceededFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DbInstanceAutomatedBackupQuotaExceededFault`](crate::error::DbInstanceAutomatedBackupQuotaExceededFault)
        pub fn build(self) -> crate::error::DbInstanceAutomatedBackupQuotaExceededFault {
            crate::error::DbInstanceAutomatedBackupQuotaExceededFault {
                message: self.message,
            }
        }
    }
}
impl DbInstanceAutomatedBackupQuotaExceededFault {
    /// Creates a new builder-style object to manufacture [`DbInstanceAutomatedBackupQuotaExceededFault`](crate::error::DbInstanceAutomatedBackupQuotaExceededFault)
    pub fn builder() -> crate::error::db_instance_automated_backup_quota_exceeded_fault::Builder {
        crate::error::db_instance_automated_backup_quota_exceeded_fault::Builder::default()
    }
}

/// <p>The DB subnet group doesn't cover all Availability Zones after it's created because of users' change.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidVpcNetworkStateFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidVpcNetworkStateFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidVpcNetworkStateFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidVpcNetworkStateFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidVpcNetworkStateFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "InvalidVpcNetworkStateFault [InvalidVPCNetworkStateFault]"
        )?;
        if let Some(inner_19) = &self.message {
            write!(f, ": {}", inner_19)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidVpcNetworkStateFault {}
/// See [`InvalidVpcNetworkStateFault`](crate::error::InvalidVpcNetworkStateFault)
pub mod invalid_vpc_network_state_fault {
    /// A builder for [`InvalidVpcNetworkStateFault`](crate::error::InvalidVpcNetworkStateFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidVpcNetworkStateFault`](crate::error::InvalidVpcNetworkStateFault)
        pub fn build(self) -> crate::error::InvalidVpcNetworkStateFault {
            crate::error::InvalidVpcNetworkStateFault {
                message: self.message,
            }
        }
    }
}
impl InvalidVpcNetworkStateFault {
    /// Creates a new builder-style object to manufacture [`InvalidVpcNetworkStateFault`](crate::error::InvalidVpcNetworkStateFault)
    pub fn builder() -> crate::error::invalid_vpc_network_state_fault::Builder {
        crate::error::invalid_vpc_network_state_fault::Builder::default()
    }
}

/// <p>The requested subnet is invalid, or multiple subnets were requested that are not all in a common VPC.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidSubnet {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidSubnet {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidSubnet");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidSubnet {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidSubnet {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidSubnet")?;
        if let Some(inner_20) = &self.message {
            write!(f, ": {}", inner_20)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidSubnet {}
/// See [`InvalidSubnet`](crate::error::InvalidSubnet)
pub mod invalid_subnet {
    /// A builder for [`InvalidSubnet`](crate::error::InvalidSubnet)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidSubnet`](crate::error::InvalidSubnet)
        pub fn build(self) -> crate::error::InvalidSubnet {
            crate::error::InvalidSubnet {
                message: self.message,
            }
        }
    }
}
impl InvalidSubnet {
    /// Creates a new builder-style object to manufacture [`InvalidSubnet`](crate::error::InvalidSubnet)
    pub fn builder() -> crate::error::invalid_subnet::Builder {
        crate::error::invalid_subnet::Builder::default()
    }
}

/// <p>The specified DB instance class isn't available in the specified Availability Zone.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InsufficientDbInstanceCapacityFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InsufficientDbInstanceCapacityFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InsufficientDbInstanceCapacityFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InsufficientDbInstanceCapacityFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InsufficientDbInstanceCapacityFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "InsufficientDbInstanceCapacityFault [InsufficientDBInstanceCapacityFault]"
        )?;
        if let Some(inner_21) = &self.message {
            write!(f, ": {}", inner_21)?;
        }
        Ok(())
    }
}
impl std::error::Error for InsufficientDbInstanceCapacityFault {}
/// See [`InsufficientDbInstanceCapacityFault`](crate::error::InsufficientDbInstanceCapacityFault)
pub mod insufficient_db_instance_capacity_fault {
    /// A builder for [`InsufficientDbInstanceCapacityFault`](crate::error::InsufficientDbInstanceCapacityFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InsufficientDbInstanceCapacityFault`](crate::error::InsufficientDbInstanceCapacityFault)
        pub fn build(self) -> crate::error::InsufficientDbInstanceCapacityFault {
            crate::error::InsufficientDbInstanceCapacityFault {
                message: self.message,
            }
        }
    }
}
impl InsufficientDbInstanceCapacityFault {
    /// Creates a new builder-style object to manufacture [`InsufficientDbInstanceCapacityFault`](crate::error::InsufficientDbInstanceCapacityFault)
    pub fn builder() -> crate::error::insufficient_db_instance_capacity_fault::Builder {
        crate::error::insufficient_db_instance_capacity_fault::Builder::default()
    }
}

/// <p> <code>DBSubnetGroupName</code> doesn't refer to an existing DB subnet group. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DbSubnetGroupNotFoundFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DbSubnetGroupNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DbSubnetGroupNotFoundFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DbSubnetGroupNotFoundFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DbSubnetGroupNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DbSubnetGroupNotFoundFault [DBSubnetGroupNotFoundFault]")?;
        if let Some(inner_22) = &self.message {
            write!(f, ": {}", inner_22)?;
        }
        Ok(())
    }
}
impl std::error::Error for DbSubnetGroupNotFoundFault {}
/// See [`DbSubnetGroupNotFoundFault`](crate::error::DbSubnetGroupNotFoundFault)
pub mod db_subnet_group_not_found_fault {
    /// A builder for [`DbSubnetGroupNotFoundFault`](crate::error::DbSubnetGroupNotFoundFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DbSubnetGroupNotFoundFault`](crate::error::DbSubnetGroupNotFoundFault)
        pub fn build(self) -> crate::error::DbSubnetGroupNotFoundFault {
            crate::error::DbSubnetGroupNotFoundFault {
                message: self.message,
            }
        }
    }
}
impl DbSubnetGroupNotFoundFault {
    /// Creates a new builder-style object to manufacture [`DbSubnetGroupNotFoundFault`](crate::error::DbSubnetGroupNotFoundFault)
    pub fn builder() -> crate::error::db_subnet_group_not_found_fault::Builder {
        crate::error::db_subnet_group_not_found_fault::Builder::default()
    }
}

/// <p>Subnets in the DB subnet group should cover at least two Availability Zones unless there is only one Availability Zone.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DbSubnetGroupDoesNotCoverEnoughAZs {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DbSubnetGroupDoesNotCoverEnoughAZs {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DbSubnetGroupDoesNotCoverEnoughAZs");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DbSubnetGroupDoesNotCoverEnoughAZs {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DbSubnetGroupDoesNotCoverEnoughAZs {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "DbSubnetGroupDoesNotCoverEnoughAZs [DBSubnetGroupDoesNotCoverEnoughAZs]"
        )?;
        if let Some(inner_23) = &self.message {
            write!(f, ": {}", inner_23)?;
        }
        Ok(())
    }
}
impl std::error::Error for DbSubnetGroupDoesNotCoverEnoughAZs {}
/// See [`DbSubnetGroupDoesNotCoverEnoughAZs`](crate::error::DbSubnetGroupDoesNotCoverEnoughAZs)
pub mod db_subnet_group_does_not_cover_enough_a_zs {
    /// A builder for [`DbSubnetGroupDoesNotCoverEnoughAZs`](crate::error::DbSubnetGroupDoesNotCoverEnoughAZs)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DbSubnetGroupDoesNotCoverEnoughAZs`](crate::error::DbSubnetGroupDoesNotCoverEnoughAZs)
        pub fn build(self) -> crate::error::DbSubnetGroupDoesNotCoverEnoughAZs {
            crate::error::DbSubnetGroupDoesNotCoverEnoughAZs {
                message: self.message,
            }
        }
    }
}
impl DbSubnetGroupDoesNotCoverEnoughAZs {
    /// Creates a new builder-style object to manufacture [`DbSubnetGroupDoesNotCoverEnoughAZs`](crate::error::DbSubnetGroupDoesNotCoverEnoughAZs)
    pub fn builder() -> crate::error::db_subnet_group_does_not_cover_enough_a_zs::Builder {
        crate::error::db_subnet_group_does_not_cover_enough_a_zs::Builder::default()
    }
}

/// <p>The specified CIDR IP range or Amazon EC2 security group might not be authorized for the specified DB security group.</p>
/// <p>Or, RDS might not be authorized to perform necessary actions using IAM on your behalf.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AuthorizationNotFoundFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AuthorizationNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AuthorizationNotFoundFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AuthorizationNotFoundFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AuthorizationNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AuthorizationNotFoundFault")?;
        if let Some(inner_24) = &self.message {
            write!(f, ": {}", inner_24)?;
        }
        Ok(())
    }
}
impl std::error::Error for AuthorizationNotFoundFault {}
/// See [`AuthorizationNotFoundFault`](crate::error::AuthorizationNotFoundFault)
pub mod authorization_not_found_fault {
    /// A builder for [`AuthorizationNotFoundFault`](crate::error::AuthorizationNotFoundFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AuthorizationNotFoundFault`](crate::error::AuthorizationNotFoundFault)
        pub fn build(self) -> crate::error::AuthorizationNotFoundFault {
            crate::error::AuthorizationNotFoundFault {
                message: self.message,
            }
        }
    }
}
impl AuthorizationNotFoundFault {
    /// Creates a new builder-style object to manufacture [`AuthorizationNotFoundFault`](crate::error::AuthorizationNotFoundFault)
    pub fn builder() -> crate::error::authorization_not_found_fault::Builder {
        crate::error::authorization_not_found_fault::Builder::default()
    }
}

/// <p>The state of the DB security group doesn't allow deletion.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidDbSecurityGroupStateFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidDbSecurityGroupStateFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidDbSecurityGroupStateFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidDbSecurityGroupStateFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidDbSecurityGroupStateFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "InvalidDbSecurityGroupStateFault [InvalidDBSecurityGroupStateFault]"
        )?;
        if let Some(inner_25) = &self.message {
            write!(f, ": {}", inner_25)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidDbSecurityGroupStateFault {}
/// See [`InvalidDbSecurityGroupStateFault`](crate::error::InvalidDbSecurityGroupStateFault)
pub mod invalid_db_security_group_state_fault {
    /// A builder for [`InvalidDbSecurityGroupStateFault`](crate::error::InvalidDbSecurityGroupStateFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidDbSecurityGroupStateFault`](crate::error::InvalidDbSecurityGroupStateFault)
        pub fn build(self) -> crate::error::InvalidDbSecurityGroupStateFault {
            crate::error::InvalidDbSecurityGroupStateFault {
                message: self.message,
            }
        }
    }
}
impl InvalidDbSecurityGroupStateFault {
    /// Creates a new builder-style object to manufacture [`InvalidDbSecurityGroupStateFault`](crate::error::InvalidDbSecurityGroupStateFault)
    pub fn builder() -> crate::error::invalid_db_security_group_state_fault::Builder {
        crate::error::invalid_db_security_group_state_fault::Builder::default()
    }
}

/// <p> <code>DBSecurityGroupName</code> doesn't refer to an existing DB security group. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DbSecurityGroupNotFoundFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DbSecurityGroupNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DbSecurityGroupNotFoundFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DbSecurityGroupNotFoundFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DbSecurityGroupNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "DbSecurityGroupNotFoundFault [DBSecurityGroupNotFoundFault]"
        )?;
        if let Some(inner_26) = &self.message {
            write!(f, ": {}", inner_26)?;
        }
        Ok(())
    }
}
impl std::error::Error for DbSecurityGroupNotFoundFault {}
/// See [`DbSecurityGroupNotFoundFault`](crate::error::DbSecurityGroupNotFoundFault)
pub mod db_security_group_not_found_fault {
    /// A builder for [`DbSecurityGroupNotFoundFault`](crate::error::DbSecurityGroupNotFoundFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DbSecurityGroupNotFoundFault`](crate::error::DbSecurityGroupNotFoundFault)
        pub fn build(self) -> crate::error::DbSecurityGroupNotFoundFault {
            crate::error::DbSecurityGroupNotFoundFault {
                message: self.message,
            }
        }
    }
}
impl DbSecurityGroupNotFoundFault {
    /// Creates a new builder-style object to manufacture [`DbSecurityGroupNotFoundFault`](crate::error::DbSecurityGroupNotFoundFault)
    pub fn builder() -> crate::error::db_security_group_not_found_fault::Builder {
        crate::error::db_security_group_not_found_fault::Builder::default()
    }
}

/// <p>The request would result in the user exceeding the allowed amount of storage available across all DB instances.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StorageQuotaExceededFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for StorageQuotaExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StorageQuotaExceededFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl StorageQuotaExceededFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for StorageQuotaExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "StorageQuotaExceededFault")?;
        if let Some(inner_27) = &self.message {
            write!(f, ": {}", inner_27)?;
        }
        Ok(())
    }
}
impl std::error::Error for StorageQuotaExceededFault {}
/// See [`StorageQuotaExceededFault`](crate::error::StorageQuotaExceededFault)
pub mod storage_quota_exceeded_fault {
    /// A builder for [`StorageQuotaExceededFault`](crate::error::StorageQuotaExceededFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`StorageQuotaExceededFault`](crate::error::StorageQuotaExceededFault)
        pub fn build(self) -> crate::error::StorageQuotaExceededFault {
            crate::error::StorageQuotaExceededFault {
                message: self.message,
            }
        }
    }
}
impl StorageQuotaExceededFault {
    /// Creates a new builder-style object to manufacture [`StorageQuotaExceededFault`](crate::error::StorageQuotaExceededFault)
    pub fn builder() -> crate::error::storage_quota_exceeded_fault::Builder {
        crate::error::storage_quota_exceeded_fault::Builder::default()
    }
}

/// <p>Provisioned IOPS not available in the specified Availability Zone.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProvisionedIopsNotAvailableInAzFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ProvisionedIopsNotAvailableInAzFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProvisionedIopsNotAvailableInAzFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ProvisionedIopsNotAvailableInAzFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ProvisionedIopsNotAvailableInAzFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "ProvisionedIopsNotAvailableInAzFault [ProvisionedIopsNotAvailableInAZFault]"
        )?;
        if let Some(inner_28) = &self.message {
            write!(f, ": {}", inner_28)?;
        }
        Ok(())
    }
}
impl std::error::Error for ProvisionedIopsNotAvailableInAzFault {}
/// See [`ProvisionedIopsNotAvailableInAzFault`](crate::error::ProvisionedIopsNotAvailableInAzFault)
pub mod provisioned_iops_not_available_in_az_fault {
    /// A builder for [`ProvisionedIopsNotAvailableInAzFault`](crate::error::ProvisionedIopsNotAvailableInAzFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ProvisionedIopsNotAvailableInAzFault`](crate::error::ProvisionedIopsNotAvailableInAzFault)
        pub fn build(self) -> crate::error::ProvisionedIopsNotAvailableInAzFault {
            crate::error::ProvisionedIopsNotAvailableInAzFault {
                message: self.message,
            }
        }
    }
}
impl ProvisionedIopsNotAvailableInAzFault {
    /// Creates a new builder-style object to manufacture [`ProvisionedIopsNotAvailableInAzFault`](crate::error::ProvisionedIopsNotAvailableInAzFault)
    pub fn builder() -> crate::error::provisioned_iops_not_available_in_az_fault::Builder {
        crate::error::provisioned_iops_not_available_in_az_fault::Builder::default()
    }
}

/// <p> <code>SourceDBInstanceIdentifier</code> refers to a DB instance with <code>BackupRetentionPeriod</code> equal to 0. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PointInTimeRestoreNotEnabledFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for PointInTimeRestoreNotEnabledFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PointInTimeRestoreNotEnabledFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl PointInTimeRestoreNotEnabledFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for PointInTimeRestoreNotEnabledFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "PointInTimeRestoreNotEnabledFault")?;
        if let Some(inner_29) = &self.message {
            write!(f, ": {}", inner_29)?;
        }
        Ok(())
    }
}
impl std::error::Error for PointInTimeRestoreNotEnabledFault {}
/// See [`PointInTimeRestoreNotEnabledFault`](crate::error::PointInTimeRestoreNotEnabledFault)
pub mod point_in_time_restore_not_enabled_fault {
    /// A builder for [`PointInTimeRestoreNotEnabledFault`](crate::error::PointInTimeRestoreNotEnabledFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`PointInTimeRestoreNotEnabledFault`](crate::error::PointInTimeRestoreNotEnabledFault)
        pub fn build(self) -> crate::error::PointInTimeRestoreNotEnabledFault {
            crate::error::PointInTimeRestoreNotEnabledFault {
                message: self.message,
            }
        }
    }
}
impl PointInTimeRestoreNotEnabledFault {
    /// Creates a new builder-style object to manufacture [`PointInTimeRestoreNotEnabledFault`](crate::error::PointInTimeRestoreNotEnabledFault)
    pub fn builder() -> crate::error::point_in_time_restore_not_enabled_fault::Builder {
        crate::error::point_in_time_restore_not_enabled_fault::Builder::default()
    }
}

/// <p>The specified option group could not be found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OptionGroupNotFoundFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for OptionGroupNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OptionGroupNotFoundFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl OptionGroupNotFoundFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for OptionGroupNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "OptionGroupNotFoundFault")?;
        if let Some(inner_30) = &self.message {
            write!(f, ": {}", inner_30)?;
        }
        Ok(())
    }
}
impl std::error::Error for OptionGroupNotFoundFault {}
/// See [`OptionGroupNotFoundFault`](crate::error::OptionGroupNotFoundFault)
pub mod option_group_not_found_fault {
    /// A builder for [`OptionGroupNotFoundFault`](crate::error::OptionGroupNotFoundFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`OptionGroupNotFoundFault`](crate::error::OptionGroupNotFoundFault)
        pub fn build(self) -> crate::error::OptionGroupNotFoundFault {
            crate::error::OptionGroupNotFoundFault {
                message: self.message,
            }
        }
    }
}
impl OptionGroupNotFoundFault {
    /// Creates a new builder-style object to manufacture [`OptionGroupNotFoundFault`](crate::error::OptionGroupNotFoundFault)
    pub fn builder() -> crate::error::option_group_not_found_fault::Builder {
        crate::error::option_group_not_found_fault::Builder::default()
    }
}

/// <p>Cannot restore from VPC backup to non-VPC DB instance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidRestoreFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidRestoreFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidRestoreFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidRestoreFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidRestoreFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidRestoreFault")?;
        if let Some(inner_31) = &self.message {
            write!(f, ": {}", inner_31)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidRestoreFault {}
/// See [`InvalidRestoreFault`](crate::error::InvalidRestoreFault)
pub mod invalid_restore_fault {
    /// A builder for [`InvalidRestoreFault`](crate::error::InvalidRestoreFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidRestoreFault`](crate::error::InvalidRestoreFault)
        pub fn build(self) -> crate::error::InvalidRestoreFault {
            crate::error::InvalidRestoreFault {
                message: self.message,
            }
        }
    }
}
impl InvalidRestoreFault {
    /// Creates a new builder-style object to manufacture [`InvalidRestoreFault`](crate::error::InvalidRestoreFault)
    pub fn builder() -> crate::error::invalid_restore_fault::Builder {
        crate::error::invalid_restore_fault::Builder::default()
    }
}

/// <p>The request would result in the user exceeding the allowed number of DB instances.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InstanceQuotaExceededFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InstanceQuotaExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InstanceQuotaExceededFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InstanceQuotaExceededFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InstanceQuotaExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InstanceQuotaExceededFault")?;
        if let Some(inner_32) = &self.message {
            write!(f, ": {}", inner_32)?;
        }
        Ok(())
    }
}
impl std::error::Error for InstanceQuotaExceededFault {}
/// See [`InstanceQuotaExceededFault`](crate::error::InstanceQuotaExceededFault)
pub mod instance_quota_exceeded_fault {
    /// A builder for [`InstanceQuotaExceededFault`](crate::error::InstanceQuotaExceededFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InstanceQuotaExceededFault`](crate::error::InstanceQuotaExceededFault)
        pub fn build(self) -> crate::error::InstanceQuotaExceededFault {
            crate::error::InstanceQuotaExceededFault {
                message: self.message,
            }
        }
    }
}
impl InstanceQuotaExceededFault {
    /// Creates a new builder-style object to manufacture [`InstanceQuotaExceededFault`](crate::error::InstanceQuotaExceededFault)
    pub fn builder() -> crate::error::instance_quota_exceeded_fault::Builder {
        crate::error::instance_quota_exceeded_fault::Builder::default()
    }
}

/// <p> <code>Domain</code> doesn't refer to an existing Active Directory domain. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DomainNotFoundFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DomainNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DomainNotFoundFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DomainNotFoundFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DomainNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DomainNotFoundFault")?;
        if let Some(inner_33) = &self.message {
            write!(f, ": {}", inner_33)?;
        }
        Ok(())
    }
}
impl std::error::Error for DomainNotFoundFault {}
/// See [`DomainNotFoundFault`](crate::error::DomainNotFoundFault)
pub mod domain_not_found_fault {
    /// A builder for [`DomainNotFoundFault`](crate::error::DomainNotFoundFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DomainNotFoundFault`](crate::error::DomainNotFoundFault)
        pub fn build(self) -> crate::error::DomainNotFoundFault {
            crate::error::DomainNotFoundFault {
                message: self.message,
            }
        }
    }
}
impl DomainNotFoundFault {
    /// Creates a new builder-style object to manufacture [`DomainNotFoundFault`](crate::error::DomainNotFoundFault)
    pub fn builder() -> crate::error::domain_not_found_fault::Builder {
        crate::error::domain_not_found_fault::Builder::default()
    }
}

/// <p> <code>DBParameterGroupName</code> doesn't refer to an existing DB parameter group. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DbParameterGroupNotFoundFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DbParameterGroupNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DbParameterGroupNotFoundFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DbParameterGroupNotFoundFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DbParameterGroupNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "DbParameterGroupNotFoundFault [DBParameterGroupNotFoundFault]"
        )?;
        if let Some(inner_34) = &self.message {
            write!(f, ": {}", inner_34)?;
        }
        Ok(())
    }
}
impl std::error::Error for DbParameterGroupNotFoundFault {}
/// See [`DbParameterGroupNotFoundFault`](crate::error::DbParameterGroupNotFoundFault)
pub mod db_parameter_group_not_found_fault {
    /// A builder for [`DbParameterGroupNotFoundFault`](crate::error::DbParameterGroupNotFoundFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DbParameterGroupNotFoundFault`](crate::error::DbParameterGroupNotFoundFault)
        pub fn build(self) -> crate::error::DbParameterGroupNotFoundFault {
            crate::error::DbParameterGroupNotFoundFault {
                message: self.message,
            }
        }
    }
}
impl DbParameterGroupNotFoundFault {
    /// Creates a new builder-style object to manufacture [`DbParameterGroupNotFoundFault`](crate::error::DbParameterGroupNotFoundFault)
    pub fn builder() -> crate::error::db_parameter_group_not_found_fault::Builder {
        crate::error::db_parameter_group_not_found_fault::Builder::default()
    }
}

/// <p>No automated backup for this DB instance was found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DbInstanceAutomatedBackupNotFoundFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DbInstanceAutomatedBackupNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DbInstanceAutomatedBackupNotFoundFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DbInstanceAutomatedBackupNotFoundFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DbInstanceAutomatedBackupNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "DbInstanceAutomatedBackupNotFoundFault [DBInstanceAutomatedBackupNotFoundFault]"
        )?;
        if let Some(inner_35) = &self.message {
            write!(f, ": {}", inner_35)?;
        }
        Ok(())
    }
}
impl std::error::Error for DbInstanceAutomatedBackupNotFoundFault {}
/// See [`DbInstanceAutomatedBackupNotFoundFault`](crate::error::DbInstanceAutomatedBackupNotFoundFault)
pub mod db_instance_automated_backup_not_found_fault {
    /// A builder for [`DbInstanceAutomatedBackupNotFoundFault`](crate::error::DbInstanceAutomatedBackupNotFoundFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DbInstanceAutomatedBackupNotFoundFault`](crate::error::DbInstanceAutomatedBackupNotFoundFault)
        pub fn build(self) -> crate::error::DbInstanceAutomatedBackupNotFoundFault {
            crate::error::DbInstanceAutomatedBackupNotFoundFault {
                message: self.message,
            }
        }
    }
}
impl DbInstanceAutomatedBackupNotFoundFault {
    /// Creates a new builder-style object to manufacture [`DbInstanceAutomatedBackupNotFoundFault`](crate::error::DbInstanceAutomatedBackupNotFoundFault)
    pub fn builder() -> crate::error::db_instance_automated_backup_not_found_fault::Builder {
        crate::error::db_instance_automated_backup_not_found_fault::Builder::default()
    }
}

/// <p>The user already has a DB instance with the given identifier.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DbInstanceAlreadyExistsFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DbInstanceAlreadyExistsFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DbInstanceAlreadyExistsFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DbInstanceAlreadyExistsFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DbInstanceAlreadyExistsFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "DbInstanceAlreadyExistsFault [DBInstanceAlreadyExistsFault]"
        )?;
        if let Some(inner_36) = &self.message {
            write!(f, ": {}", inner_36)?;
        }
        Ok(())
    }
}
impl std::error::Error for DbInstanceAlreadyExistsFault {}
/// See [`DbInstanceAlreadyExistsFault`](crate::error::DbInstanceAlreadyExistsFault)
pub mod db_instance_already_exists_fault {
    /// A builder for [`DbInstanceAlreadyExistsFault`](crate::error::DbInstanceAlreadyExistsFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DbInstanceAlreadyExistsFault`](crate::error::DbInstanceAlreadyExistsFault)
        pub fn build(self) -> crate::error::DbInstanceAlreadyExistsFault {
            crate::error::DbInstanceAlreadyExistsFault {
                message: self.message,
            }
        }
    }
}
impl DbInstanceAlreadyExistsFault {
    /// Creates a new builder-style object to manufacture [`DbInstanceAlreadyExistsFault`](crate::error::DbInstanceAlreadyExistsFault)
    pub fn builder() -> crate::error::db_instance_already_exists_fault::Builder {
        crate::error::db_instance_already_exists_fault::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BackupPolicyNotFoundFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for BackupPolicyNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BackupPolicyNotFoundFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl BackupPolicyNotFoundFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for BackupPolicyNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "BackupPolicyNotFoundFault")?;
        if let Some(inner_37) = &self.message {
            write!(f, ": {}", inner_37)?;
        }
        Ok(())
    }
}
impl std::error::Error for BackupPolicyNotFoundFault {}
/// See [`BackupPolicyNotFoundFault`](crate::error::BackupPolicyNotFoundFault)
pub mod backup_policy_not_found_fault {
    /// A builder for [`BackupPolicyNotFoundFault`](crate::error::BackupPolicyNotFoundFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`BackupPolicyNotFoundFault`](crate::error::BackupPolicyNotFoundFault)
        pub fn build(self) -> crate::error::BackupPolicyNotFoundFault {
            crate::error::BackupPolicyNotFoundFault {
                message: self.message,
            }
        }
    }
}
impl BackupPolicyNotFoundFault {
    /// Creates a new builder-style object to manufacture [`BackupPolicyNotFoundFault`](crate::error::BackupPolicyNotFoundFault)
    pub fn builder() -> crate::error::backup_policy_not_found_fault::Builder {
        crate::error::backup_policy_not_found_fault::Builder::default()
    }
}

/// <p>The state of the DB snapshot doesn't allow deletion.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidDbSnapshotStateFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidDbSnapshotStateFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidDbSnapshotStateFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidDbSnapshotStateFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidDbSnapshotStateFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "InvalidDbSnapshotStateFault [InvalidDBSnapshotStateFault]"
        )?;
        if let Some(inner_38) = &self.message {
            write!(f, ": {}", inner_38)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidDbSnapshotStateFault {}
/// See [`InvalidDbSnapshotStateFault`](crate::error::InvalidDbSnapshotStateFault)
pub mod invalid_db_snapshot_state_fault {
    /// A builder for [`InvalidDbSnapshotStateFault`](crate::error::InvalidDbSnapshotStateFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidDbSnapshotStateFault`](crate::error::InvalidDbSnapshotStateFault)
        pub fn build(self) -> crate::error::InvalidDbSnapshotStateFault {
            crate::error::InvalidDbSnapshotStateFault {
                message: self.message,
            }
        }
    }
}
impl InvalidDbSnapshotStateFault {
    /// Creates a new builder-style object to manufacture [`InvalidDbSnapshotStateFault`](crate::error::InvalidDbSnapshotStateFault)
    pub fn builder() -> crate::error::invalid_db_snapshot_state_fault::Builder {
        crate::error::invalid_db_snapshot_state_fault::Builder::default()
    }
}

/// <p>The supplied value isn't a valid DB cluster snapshot state.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidDbClusterSnapshotStateFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidDbClusterSnapshotStateFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidDbClusterSnapshotStateFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidDbClusterSnapshotStateFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidDbClusterSnapshotStateFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "InvalidDbClusterSnapshotStateFault [InvalidDBClusterSnapshotStateFault]"
        )?;
        if let Some(inner_39) = &self.message {
            write!(f, ": {}", inner_39)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidDbClusterSnapshotStateFault {}
/// See [`InvalidDbClusterSnapshotStateFault`](crate::error::InvalidDbClusterSnapshotStateFault)
pub mod invalid_db_cluster_snapshot_state_fault {
    /// A builder for [`InvalidDbClusterSnapshotStateFault`](crate::error::InvalidDbClusterSnapshotStateFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidDbClusterSnapshotStateFault`](crate::error::InvalidDbClusterSnapshotStateFault)
        pub fn build(self) -> crate::error::InvalidDbClusterSnapshotStateFault {
            crate::error::InvalidDbClusterSnapshotStateFault {
                message: self.message,
            }
        }
    }
}
impl InvalidDbClusterSnapshotStateFault {
    /// Creates a new builder-style object to manufacture [`InvalidDbClusterSnapshotStateFault`](crate::error::InvalidDbClusterSnapshotStateFault)
    pub fn builder() -> crate::error::invalid_db_cluster_snapshot_state_fault::Builder {
        crate::error::invalid_db_cluster_snapshot_state_fault::Builder::default()
    }
}

/// <p>There is insufficient storage available for the current action. You might be able to resolve this error by updating your subnet group to use different Availability Zones that have more storage available.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InsufficientStorageClusterCapacityFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InsufficientStorageClusterCapacityFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InsufficientStorageClusterCapacityFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InsufficientStorageClusterCapacityFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InsufficientStorageClusterCapacityFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InsufficientStorageClusterCapacityFault")?;
        if let Some(inner_40) = &self.message {
            write!(f, ": {}", inner_40)?;
        }
        Ok(())
    }
}
impl std::error::Error for InsufficientStorageClusterCapacityFault {}
/// See [`InsufficientStorageClusterCapacityFault`](crate::error::InsufficientStorageClusterCapacityFault)
pub mod insufficient_storage_cluster_capacity_fault {
    /// A builder for [`InsufficientStorageClusterCapacityFault`](crate::error::InsufficientStorageClusterCapacityFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InsufficientStorageClusterCapacityFault`](crate::error::InsufficientStorageClusterCapacityFault)
        pub fn build(self) -> crate::error::InsufficientStorageClusterCapacityFault {
            crate::error::InsufficientStorageClusterCapacityFault {
                message: self.message,
            }
        }
    }
}
impl InsufficientStorageClusterCapacityFault {
    /// Creates a new builder-style object to manufacture [`InsufficientStorageClusterCapacityFault`](crate::error::InsufficientStorageClusterCapacityFault)
    pub fn builder() -> crate::error::insufficient_storage_cluster_capacity_fault::Builder {
        crate::error::insufficient_storage_cluster_capacity_fault::Builder::default()
    }
}

/// <p>The DB cluster doesn't have enough capacity for the current operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InsufficientDbClusterCapacityFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InsufficientDbClusterCapacityFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InsufficientDbClusterCapacityFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InsufficientDbClusterCapacityFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InsufficientDbClusterCapacityFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "InsufficientDbClusterCapacityFault [InsufficientDBClusterCapacityFault]"
        )?;
        if let Some(inner_41) = &self.message {
            write!(f, ": {}", inner_41)?;
        }
        Ok(())
    }
}
impl std::error::Error for InsufficientDbClusterCapacityFault {}
/// See [`InsufficientDbClusterCapacityFault`](crate::error::InsufficientDbClusterCapacityFault)
pub mod insufficient_db_cluster_capacity_fault {
    /// A builder for [`InsufficientDbClusterCapacityFault`](crate::error::InsufficientDbClusterCapacityFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InsufficientDbClusterCapacityFault`](crate::error::InsufficientDbClusterCapacityFault)
        pub fn build(self) -> crate::error::InsufficientDbClusterCapacityFault {
            crate::error::InsufficientDbClusterCapacityFault {
                message: self.message,
            }
        }
    }
}
impl InsufficientDbClusterCapacityFault {
    /// Creates a new builder-style object to manufacture [`InsufficientDbClusterCapacityFault`](crate::error::InsufficientDbClusterCapacityFault)
    pub fn builder() -> crate::error::insufficient_db_cluster_capacity_fault::Builder {
        crate::error::insufficient_db_cluster_capacity_fault::Builder::default()
    }
}

/// <p>The user attempted to create a new DB cluster and the user has already reached the maximum allowed DB cluster quota.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DbClusterQuotaExceededFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DbClusterQuotaExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DbClusterQuotaExceededFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DbClusterQuotaExceededFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DbClusterQuotaExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "DbClusterQuotaExceededFault [DBClusterQuotaExceededFault]"
        )?;
        if let Some(inner_42) = &self.message {
            write!(f, ": {}", inner_42)?;
        }
        Ok(())
    }
}
impl std::error::Error for DbClusterQuotaExceededFault {}
/// See [`DbClusterQuotaExceededFault`](crate::error::DbClusterQuotaExceededFault)
pub mod db_cluster_quota_exceeded_fault {
    /// A builder for [`DbClusterQuotaExceededFault`](crate::error::DbClusterQuotaExceededFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DbClusterQuotaExceededFault`](crate::error::DbClusterQuotaExceededFault)
        pub fn build(self) -> crate::error::DbClusterQuotaExceededFault {
            crate::error::DbClusterQuotaExceededFault {
                message: self.message,
            }
        }
    }
}
impl DbClusterQuotaExceededFault {
    /// Creates a new builder-style object to manufacture [`DbClusterQuotaExceededFault`](crate::error::DbClusterQuotaExceededFault)
    pub fn builder() -> crate::error::db_cluster_quota_exceeded_fault::Builder {
        crate::error::db_cluster_quota_exceeded_fault::Builder::default()
    }
}

/// <p> <code>DBClusterParameterGroupName</code> doesn't refer to an existing DB cluster parameter group. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DbClusterParameterGroupNotFoundFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DbClusterParameterGroupNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DbClusterParameterGroupNotFoundFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DbClusterParameterGroupNotFoundFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DbClusterParameterGroupNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "DbClusterParameterGroupNotFoundFault [DBClusterParameterGroupNotFoundFault]"
        )?;
        if let Some(inner_43) = &self.message {
            write!(f, ": {}", inner_43)?;
        }
        Ok(())
    }
}
impl std::error::Error for DbClusterParameterGroupNotFoundFault {}
/// See [`DbClusterParameterGroupNotFoundFault`](crate::error::DbClusterParameterGroupNotFoundFault)
pub mod db_cluster_parameter_group_not_found_fault {
    /// A builder for [`DbClusterParameterGroupNotFoundFault`](crate::error::DbClusterParameterGroupNotFoundFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DbClusterParameterGroupNotFoundFault`](crate::error::DbClusterParameterGroupNotFoundFault)
        pub fn build(self) -> crate::error::DbClusterParameterGroupNotFoundFault {
            crate::error::DbClusterParameterGroupNotFoundFault {
                message: self.message,
            }
        }
    }
}
impl DbClusterParameterGroupNotFoundFault {
    /// Creates a new builder-style object to manufacture [`DbClusterParameterGroupNotFoundFault`](crate::error::DbClusterParameterGroupNotFoundFault)
    pub fn builder() -> crate::error::db_cluster_parameter_group_not_found_fault::Builder {
        crate::error::db_cluster_parameter_group_not_found_fault::Builder::default()
    }
}

/// <p>The user already has a DB cluster with the given identifier.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DbClusterAlreadyExistsFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DbClusterAlreadyExistsFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DbClusterAlreadyExistsFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DbClusterAlreadyExistsFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DbClusterAlreadyExistsFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "DbClusterAlreadyExistsFault [DBClusterAlreadyExistsFault]"
        )?;
        if let Some(inner_44) = &self.message {
            write!(f, ": {}", inner_44)?;
        }
        Ok(())
    }
}
impl std::error::Error for DbClusterAlreadyExistsFault {}
/// See [`DbClusterAlreadyExistsFault`](crate::error::DbClusterAlreadyExistsFault)
pub mod db_cluster_already_exists_fault {
    /// A builder for [`DbClusterAlreadyExistsFault`](crate::error::DbClusterAlreadyExistsFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DbClusterAlreadyExistsFault`](crate::error::DbClusterAlreadyExistsFault)
        pub fn build(self) -> crate::error::DbClusterAlreadyExistsFault {
            crate::error::DbClusterAlreadyExistsFault {
                message: self.message,
            }
        }
    }
}
impl DbClusterAlreadyExistsFault {
    /// Creates a new builder-style object to manufacture [`DbClusterAlreadyExistsFault`](crate::error::DbClusterAlreadyExistsFault)
    pub fn builder() -> crate::error::db_cluster_already_exists_fault::Builder {
        crate::error::db_cluster_already_exists_fault::Builder::default()
    }
}

/// <p>The DB subnet group cannot be deleted because it's in use.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidDbSubnetGroupStateFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidDbSubnetGroupStateFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidDbSubnetGroupStateFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidDbSubnetGroupStateFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidDbSubnetGroupStateFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "InvalidDbSubnetGroupStateFault [InvalidDBSubnetGroupStateFault]"
        )?;
        if let Some(inner_45) = &self.message {
            write!(f, ": {}", inner_45)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidDbSubnetGroupStateFault {}
/// See [`InvalidDbSubnetGroupStateFault`](crate::error::InvalidDbSubnetGroupStateFault)
pub mod invalid_db_subnet_group_state_fault {
    /// A builder for [`InvalidDbSubnetGroupStateFault`](crate::error::InvalidDbSubnetGroupStateFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidDbSubnetGroupStateFault`](crate::error::InvalidDbSubnetGroupStateFault)
        pub fn build(self) -> crate::error::InvalidDbSubnetGroupStateFault {
            crate::error::InvalidDbSubnetGroupStateFault {
                message: self.message,
            }
        }
    }
}
impl InvalidDbSubnetGroupStateFault {
    /// Creates a new builder-style object to manufacture [`InvalidDbSubnetGroupStateFault`](crate::error::InvalidDbSubnetGroupStateFault)
    pub fn builder() -> crate::error::invalid_db_subnet_group_state_fault::Builder {
        crate::error::invalid_db_subnet_group_state_fault::Builder::default()
    }
}

/// <p>The DB parameter group is in use or is in an invalid state. If you are attempting to delete the parameter group, you can't delete it when the parameter group is in this state.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidDbParameterGroupStateFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidDbParameterGroupStateFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidDbParameterGroupStateFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidDbParameterGroupStateFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidDbParameterGroupStateFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "InvalidDbParameterGroupStateFault [InvalidDBParameterGroupStateFault]"
        )?;
        if let Some(inner_46) = &self.message {
            write!(f, ": {}", inner_46)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidDbParameterGroupStateFault {}
/// See [`InvalidDbParameterGroupStateFault`](crate::error::InvalidDbParameterGroupStateFault)
pub mod invalid_db_parameter_group_state_fault {
    /// A builder for [`InvalidDbParameterGroupStateFault`](crate::error::InvalidDbParameterGroupStateFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidDbParameterGroupStateFault`](crate::error::InvalidDbParameterGroupStateFault)
        pub fn build(self) -> crate::error::InvalidDbParameterGroupStateFault {
            crate::error::InvalidDbParameterGroupStateFault {
                message: self.message,
            }
        }
    }
}
impl InvalidDbParameterGroupStateFault {
    /// Creates a new builder-style object to manufacture [`InvalidDbParameterGroupStateFault`](crate::error::InvalidDbParameterGroupStateFault)
    pub fn builder() -> crate::error::invalid_db_parameter_group_state_fault::Builder {
        crate::error::invalid_db_parameter_group_state_fault::Builder::default()
    }
}

/// <p>The specified target group isn't available for a proxy owned by your Amazon Web Services account in the specified Amazon Web Services Region.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DbProxyTargetGroupNotFoundFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DbProxyTargetGroupNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DbProxyTargetGroupNotFoundFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DbProxyTargetGroupNotFoundFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DbProxyTargetGroupNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "DbProxyTargetGroupNotFoundFault [DBProxyTargetGroupNotFoundFault]"
        )?;
        if let Some(inner_47) = &self.message {
            write!(f, ": {}", inner_47)?;
        }
        Ok(())
    }
}
impl std::error::Error for DbProxyTargetGroupNotFoundFault {}
/// See [`DbProxyTargetGroupNotFoundFault`](crate::error::DbProxyTargetGroupNotFoundFault)
pub mod db_proxy_target_group_not_found_fault {
    /// A builder for [`DbProxyTargetGroupNotFoundFault`](crate::error::DbProxyTargetGroupNotFoundFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DbProxyTargetGroupNotFoundFault`](crate::error::DbProxyTargetGroupNotFoundFault)
        pub fn build(self) -> crate::error::DbProxyTargetGroupNotFoundFault {
            crate::error::DbProxyTargetGroupNotFoundFault {
                message: self.message,
            }
        }
    }
}
impl DbProxyTargetGroupNotFoundFault {
    /// Creates a new builder-style object to manufacture [`DbProxyTargetGroupNotFoundFault`](crate::error::DbProxyTargetGroupNotFoundFault)
    pub fn builder() -> crate::error::db_proxy_target_group_not_found_fault::Builder {
        crate::error::db_proxy_target_group_not_found_fault::Builder::default()
    }
}

/// <p>The specified proxy name doesn't correspond to a proxy owned by your Amazon Web Services account in the specified Amazon Web Services Region.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DbProxyNotFoundFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DbProxyNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DbProxyNotFoundFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DbProxyNotFoundFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DbProxyNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DbProxyNotFoundFault [DBProxyNotFoundFault]")?;
        if let Some(inner_48) = &self.message {
            write!(f, ": {}", inner_48)?;
        }
        Ok(())
    }
}
impl std::error::Error for DbProxyNotFoundFault {}
/// See [`DbProxyNotFoundFault`](crate::error::DbProxyNotFoundFault)
pub mod db_proxy_not_found_fault {
    /// A builder for [`DbProxyNotFoundFault`](crate::error::DbProxyNotFoundFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DbProxyNotFoundFault`](crate::error::DbProxyNotFoundFault)
        pub fn build(self) -> crate::error::DbProxyNotFoundFault {
            crate::error::DbProxyNotFoundFault {
                message: self.message,
            }
        }
    }
}
impl DbProxyNotFoundFault {
    /// Creates a new builder-style object to manufacture [`DbProxyNotFoundFault`](crate::error::DbProxyNotFoundFault)
    pub fn builder() -> crate::error::db_proxy_not_found_fault::Builder {
        crate::error::db_proxy_not_found_fault::Builder::default()
    }
}

/// <p>The subscription name does not exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SubscriptionNotFoundFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SubscriptionNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SubscriptionNotFoundFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl SubscriptionNotFoundFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for SubscriptionNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "SubscriptionNotFoundFault")?;
        if let Some(inner_49) = &self.message {
            write!(f, ": {}", inner_49)?;
        }
        Ok(())
    }
}
impl std::error::Error for SubscriptionNotFoundFault {}
/// See [`SubscriptionNotFoundFault`](crate::error::SubscriptionNotFoundFault)
pub mod subscription_not_found_fault {
    /// A builder for [`SubscriptionNotFoundFault`](crate::error::SubscriptionNotFoundFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`SubscriptionNotFoundFault`](crate::error::SubscriptionNotFoundFault)
        pub fn build(self) -> crate::error::SubscriptionNotFoundFault {
            crate::error::SubscriptionNotFoundFault {
                message: self.message,
            }
        }
    }
}
impl SubscriptionNotFoundFault {
    /// Creates a new builder-style object to manufacture [`SubscriptionNotFoundFault`](crate::error::SubscriptionNotFoundFault)
    pub fn builder() -> crate::error::subscription_not_found_fault::Builder {
        crate::error::subscription_not_found_fault::Builder::default()
    }
}

/// <p>The requested source could not be found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SourceNotFoundFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SourceNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SourceNotFoundFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl SourceNotFoundFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for SourceNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "SourceNotFoundFault")?;
        if let Some(inner_50) = &self.message {
            write!(f, ": {}", inner_50)?;
        }
        Ok(())
    }
}
impl std::error::Error for SourceNotFoundFault {}
/// See [`SourceNotFoundFault`](crate::error::SourceNotFoundFault)
pub mod source_not_found_fault {
    /// A builder for [`SourceNotFoundFault`](crate::error::SourceNotFoundFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`SourceNotFoundFault`](crate::error::SourceNotFoundFault)
        pub fn build(self) -> crate::error::SourceNotFoundFault {
            crate::error::SourceNotFoundFault {
                message: self.message,
            }
        }
    }
}
impl SourceNotFoundFault {
    /// Creates a new builder-style object to manufacture [`SourceNotFoundFault`](crate::error::SourceNotFoundFault)
    pub fn builder() -> crate::error::source_not_found_fault::Builder {
        crate::error::source_not_found_fault::Builder::default()
    }
}

/// <p>The specified <code>RoleArn</code> value doesn't match the specified feature for the DB instance.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DbInstanceRoleNotFoundFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DbInstanceRoleNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DbInstanceRoleNotFoundFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DbInstanceRoleNotFoundFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DbInstanceRoleNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "DbInstanceRoleNotFoundFault [DBInstanceRoleNotFoundFault]"
        )?;
        if let Some(inner_51) = &self.message {
            write!(f, ": {}", inner_51)?;
        }
        Ok(())
    }
}
impl std::error::Error for DbInstanceRoleNotFoundFault {}
/// See [`DbInstanceRoleNotFoundFault`](crate::error::DbInstanceRoleNotFoundFault)
pub mod db_instance_role_not_found_fault {
    /// A builder for [`DbInstanceRoleNotFoundFault`](crate::error::DbInstanceRoleNotFoundFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DbInstanceRoleNotFoundFault`](crate::error::DbInstanceRoleNotFoundFault)
        pub fn build(self) -> crate::error::DbInstanceRoleNotFoundFault {
            crate::error::DbInstanceRoleNotFoundFault {
                message: self.message,
            }
        }
    }
}
impl DbInstanceRoleNotFoundFault {
    /// Creates a new builder-style object to manufacture [`DbInstanceRoleNotFoundFault`](crate::error::DbInstanceRoleNotFoundFault)
    pub fn builder() -> crate::error::db_instance_role_not_found_fault::Builder {
        crate::error::db_instance_role_not_found_fault::Builder::default()
    }
}

/// <p>The specified IAM role Amazon Resource Name (ARN) isn't associated with the specified DB cluster.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DbClusterRoleNotFoundFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DbClusterRoleNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DbClusterRoleNotFoundFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DbClusterRoleNotFoundFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DbClusterRoleNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DbClusterRoleNotFoundFault [DBClusterRoleNotFoundFault]")?;
        if let Some(inner_52) = &self.message {
            write!(f, ": {}", inner_52)?;
        }
        Ok(())
    }
}
impl std::error::Error for DbClusterRoleNotFoundFault {}
/// See [`DbClusterRoleNotFoundFault`](crate::error::DbClusterRoleNotFoundFault)
pub mod db_cluster_role_not_found_fault {
    /// A builder for [`DbClusterRoleNotFoundFault`](crate::error::DbClusterRoleNotFoundFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DbClusterRoleNotFoundFault`](crate::error::DbClusterRoleNotFoundFault)
        pub fn build(self) -> crate::error::DbClusterRoleNotFoundFault {
            crate::error::DbClusterRoleNotFoundFault {
                message: self.message,
            }
        }
    }
}
impl DbClusterRoleNotFoundFault {
    /// Creates a new builder-style object to manufacture [`DbClusterRoleNotFoundFault`](crate::error::DbClusterRoleNotFoundFault)
    pub fn builder() -> crate::error::db_cluster_role_not_found_fault::Builder {
        crate::error::db_cluster_role_not_found_fault::Builder::default()
    }
}

/// <p>The global cluster is in an invalid state and can't perform the requested operation. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidGlobalClusterStateFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidGlobalClusterStateFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidGlobalClusterStateFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidGlobalClusterStateFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidGlobalClusterStateFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidGlobalClusterStateFault")?;
        if let Some(inner_53) = &self.message {
            write!(f, ": {}", inner_53)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidGlobalClusterStateFault {}
/// See [`InvalidGlobalClusterStateFault`](crate::error::InvalidGlobalClusterStateFault)
pub mod invalid_global_cluster_state_fault {
    /// A builder for [`InvalidGlobalClusterStateFault`](crate::error::InvalidGlobalClusterStateFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidGlobalClusterStateFault`](crate::error::InvalidGlobalClusterStateFault)
        pub fn build(self) -> crate::error::InvalidGlobalClusterStateFault {
            crate::error::InvalidGlobalClusterStateFault {
                message: self.message,
            }
        }
    }
}
impl InvalidGlobalClusterStateFault {
    /// Creates a new builder-style object to manufacture [`InvalidGlobalClusterStateFault`](crate::error::InvalidGlobalClusterStateFault)
    pub fn builder() -> crate::error::invalid_global_cluster_state_fault::Builder {
        crate::error::invalid_global_cluster_state_fault::Builder::default()
    }
}

/// <p>The <code>GlobalClusterIdentifier</code> doesn't refer to an existing global database cluster. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GlobalClusterNotFoundFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GlobalClusterNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GlobalClusterNotFoundFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl GlobalClusterNotFoundFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for GlobalClusterNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "GlobalClusterNotFoundFault")?;
        if let Some(inner_54) = &self.message {
            write!(f, ": {}", inner_54)?;
        }
        Ok(())
    }
}
impl std::error::Error for GlobalClusterNotFoundFault {}
/// See [`GlobalClusterNotFoundFault`](crate::error::GlobalClusterNotFoundFault)
pub mod global_cluster_not_found_fault {
    /// A builder for [`GlobalClusterNotFoundFault`](crate::error::GlobalClusterNotFoundFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`GlobalClusterNotFoundFault`](crate::error::GlobalClusterNotFoundFault)
        pub fn build(self) -> crate::error::GlobalClusterNotFoundFault {
            crate::error::GlobalClusterNotFoundFault {
                message: self.message,
            }
        }
    }
}
impl GlobalClusterNotFoundFault {
    /// Creates a new builder-style object to manufacture [`GlobalClusterNotFoundFault`](crate::error::GlobalClusterNotFoundFault)
    pub fn builder() -> crate::error::global_cluster_not_found_fault::Builder {
        crate::error::global_cluster_not_found_fault::Builder::default()
    }
}

/// <p>The requested operation can't be performed while the proxy is in this state.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidDbProxyStateFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidDbProxyStateFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidDbProxyStateFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidDbProxyStateFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidDbProxyStateFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidDbProxyStateFault [InvalidDBProxyStateFault]")?;
        if let Some(inner_55) = &self.message {
            write!(f, ": {}", inner_55)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidDbProxyStateFault {}
/// See [`InvalidDbProxyStateFault`](crate::error::InvalidDbProxyStateFault)
pub mod invalid_db_proxy_state_fault {
    /// A builder for [`InvalidDbProxyStateFault`](crate::error::InvalidDbProxyStateFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidDbProxyStateFault`](crate::error::InvalidDbProxyStateFault)
        pub fn build(self) -> crate::error::InvalidDbProxyStateFault {
            crate::error::InvalidDbProxyStateFault {
                message: self.message,
            }
        }
    }
}
impl InvalidDbProxyStateFault {
    /// Creates a new builder-style object to manufacture [`InvalidDbProxyStateFault`](crate::error::InvalidDbProxyStateFault)
    pub fn builder() -> crate::error::invalid_db_proxy_state_fault::Builder {
        crate::error::invalid_db_proxy_state_fault::Builder::default()
    }
}

/// <p>The requested operation can't be performed because there aren't enough available IP addresses in the proxy's subnets. Add more CIDR blocks to the VPC or remove IP address that aren't required from the subnets.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InsufficientAvailableIPsInSubnetFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InsufficientAvailableIPsInSubnetFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InsufficientAvailableIPsInSubnetFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InsufficientAvailableIPsInSubnetFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InsufficientAvailableIPsInSubnetFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InsufficientAvailableIPsInSubnetFault")?;
        if let Some(inner_56) = &self.message {
            write!(f, ": {}", inner_56)?;
        }
        Ok(())
    }
}
impl std::error::Error for InsufficientAvailableIPsInSubnetFault {}
/// See [`InsufficientAvailableIPsInSubnetFault`](crate::error::InsufficientAvailableIPsInSubnetFault)
pub mod insufficient_available_i_ps_in_subnet_fault {
    /// A builder for [`InsufficientAvailableIPsInSubnetFault`](crate::error::InsufficientAvailableIPsInSubnetFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InsufficientAvailableIPsInSubnetFault`](crate::error::InsufficientAvailableIPsInSubnetFault)
        pub fn build(self) -> crate::error::InsufficientAvailableIPsInSubnetFault {
            crate::error::InsufficientAvailableIPsInSubnetFault {
                message: self.message,
            }
        }
    }
}
impl InsufficientAvailableIPsInSubnetFault {
    /// Creates a new builder-style object to manufacture [`InsufficientAvailableIPsInSubnetFault`](crate::error::InsufficientAvailableIPsInSubnetFault)
    pub fn builder() -> crate::error::insufficient_available_i_ps_in_subnet_fault::Builder {
        crate::error::insufficient_available_i_ps_in_subnet_fault::Builder::default()
    }
}

/// <p>The proxy is already associated with the specified RDS DB instance or Aurora DB cluster.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DbProxyTargetAlreadyRegisteredFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DbProxyTargetAlreadyRegisteredFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DbProxyTargetAlreadyRegisteredFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DbProxyTargetAlreadyRegisteredFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DbProxyTargetAlreadyRegisteredFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "DbProxyTargetAlreadyRegisteredFault [DBProxyTargetAlreadyRegisteredFault]"
        )?;
        if let Some(inner_57) = &self.message {
            write!(f, ": {}", inner_57)?;
        }
        Ok(())
    }
}
impl std::error::Error for DbProxyTargetAlreadyRegisteredFault {}
/// See [`DbProxyTargetAlreadyRegisteredFault`](crate::error::DbProxyTargetAlreadyRegisteredFault)
pub mod db_proxy_target_already_registered_fault {
    /// A builder for [`DbProxyTargetAlreadyRegisteredFault`](crate::error::DbProxyTargetAlreadyRegisteredFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DbProxyTargetAlreadyRegisteredFault`](crate::error::DbProxyTargetAlreadyRegisteredFault)
        pub fn build(self) -> crate::error::DbProxyTargetAlreadyRegisteredFault {
            crate::error::DbProxyTargetAlreadyRegisteredFault {
                message: self.message,
            }
        }
    }
}
impl DbProxyTargetAlreadyRegisteredFault {
    /// Creates a new builder-style object to manufacture [`DbProxyTargetAlreadyRegisteredFault`](crate::error::DbProxyTargetAlreadyRegisteredFault)
    pub fn builder() -> crate::error::db_proxy_target_already_registered_fault::Builder {
        crate::error::db_proxy_target_already_registered_fault::Builder::default()
    }
}

/// <p>Specified offering does not exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReservedDbInstancesOfferingNotFoundFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ReservedDbInstancesOfferingNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReservedDbInstancesOfferingNotFoundFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ReservedDbInstancesOfferingNotFoundFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ReservedDbInstancesOfferingNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "ReservedDbInstancesOfferingNotFoundFault [ReservedDBInstancesOfferingNotFoundFault]"
        )?;
        if let Some(inner_58) = &self.message {
            write!(f, ": {}", inner_58)?;
        }
        Ok(())
    }
}
impl std::error::Error for ReservedDbInstancesOfferingNotFoundFault {}
/// See [`ReservedDbInstancesOfferingNotFoundFault`](crate::error::ReservedDbInstancesOfferingNotFoundFault)
pub mod reserved_db_instances_offering_not_found_fault {
    /// A builder for [`ReservedDbInstancesOfferingNotFoundFault`](crate::error::ReservedDbInstancesOfferingNotFoundFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ReservedDbInstancesOfferingNotFoundFault`](crate::error::ReservedDbInstancesOfferingNotFoundFault)
        pub fn build(self) -> crate::error::ReservedDbInstancesOfferingNotFoundFault {
            crate::error::ReservedDbInstancesOfferingNotFoundFault {
                message: self.message,
            }
        }
    }
}
impl ReservedDbInstancesOfferingNotFoundFault {
    /// Creates a new builder-style object to manufacture [`ReservedDbInstancesOfferingNotFoundFault`](crate::error::ReservedDbInstancesOfferingNotFoundFault)
    pub fn builder() -> crate::error::reserved_db_instances_offering_not_found_fault::Builder {
        crate::error::reserved_db_instances_offering_not_found_fault::Builder::default()
    }
}

/// <p>Request would exceed the user's DB Instance quota.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReservedDbInstanceQuotaExceededFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ReservedDbInstanceQuotaExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReservedDbInstanceQuotaExceededFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ReservedDbInstanceQuotaExceededFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ReservedDbInstanceQuotaExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "ReservedDbInstanceQuotaExceededFault [ReservedDBInstanceQuotaExceededFault]"
        )?;
        if let Some(inner_59) = &self.message {
            write!(f, ": {}", inner_59)?;
        }
        Ok(())
    }
}
impl std::error::Error for ReservedDbInstanceQuotaExceededFault {}
/// See [`ReservedDbInstanceQuotaExceededFault`](crate::error::ReservedDbInstanceQuotaExceededFault)
pub mod reserved_db_instance_quota_exceeded_fault {
    /// A builder for [`ReservedDbInstanceQuotaExceededFault`](crate::error::ReservedDbInstanceQuotaExceededFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ReservedDbInstanceQuotaExceededFault`](crate::error::ReservedDbInstanceQuotaExceededFault)
        pub fn build(self) -> crate::error::ReservedDbInstanceQuotaExceededFault {
            crate::error::ReservedDbInstanceQuotaExceededFault {
                message: self.message,
            }
        }
    }
}
impl ReservedDbInstanceQuotaExceededFault {
    /// Creates a new builder-style object to manufacture [`ReservedDbInstanceQuotaExceededFault`](crate::error::ReservedDbInstanceQuotaExceededFault)
    pub fn builder() -> crate::error::reserved_db_instance_quota_exceeded_fault::Builder {
        crate::error::reserved_db_instance_quota_exceeded_fault::Builder::default()
    }
}

/// <p>User already has a reservation with the given identifier.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReservedDbInstanceAlreadyExistsFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ReservedDbInstanceAlreadyExistsFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReservedDbInstanceAlreadyExistsFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ReservedDbInstanceAlreadyExistsFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ReservedDbInstanceAlreadyExistsFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "ReservedDbInstanceAlreadyExistsFault [ReservedDBInstanceAlreadyExistsFault]"
        )?;
        if let Some(inner_60) = &self.message {
            write!(f, ": {}", inner_60)?;
        }
        Ok(())
    }
}
impl std::error::Error for ReservedDbInstanceAlreadyExistsFault {}
/// See [`ReservedDbInstanceAlreadyExistsFault`](crate::error::ReservedDbInstanceAlreadyExistsFault)
pub mod reserved_db_instance_already_exists_fault {
    /// A builder for [`ReservedDbInstanceAlreadyExistsFault`](crate::error::ReservedDbInstanceAlreadyExistsFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ReservedDbInstanceAlreadyExistsFault`](crate::error::ReservedDbInstanceAlreadyExistsFault)
        pub fn build(self) -> crate::error::ReservedDbInstanceAlreadyExistsFault {
            crate::error::ReservedDbInstanceAlreadyExistsFault {
                message: self.message,
            }
        }
    }
}
impl ReservedDbInstanceAlreadyExistsFault {
    /// Creates a new builder-style object to manufacture [`ReservedDbInstanceAlreadyExistsFault`](crate::error::ReservedDbInstanceAlreadyExistsFault)
    pub fn builder() -> crate::error::reserved_db_instance_already_exists_fault::Builder {
        crate::error::reserved_db_instance_already_exists_fault::Builder::default()
    }
}

/// <p> The option group isn't in the <i>available</i> state. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidOptionGroupStateFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidOptionGroupStateFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidOptionGroupStateFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidOptionGroupStateFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidOptionGroupStateFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidOptionGroupStateFault")?;
        if let Some(inner_61) = &self.message {
            write!(f, ": {}", inner_61)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidOptionGroupStateFault {}
/// See [`InvalidOptionGroupStateFault`](crate::error::InvalidOptionGroupStateFault)
pub mod invalid_option_group_state_fault {
    /// A builder for [`InvalidOptionGroupStateFault`](crate::error::InvalidOptionGroupStateFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidOptionGroupStateFault`](crate::error::InvalidOptionGroupStateFault)
        pub fn build(self) -> crate::error::InvalidOptionGroupStateFault {
            crate::error::InvalidOptionGroupStateFault {
                message: self.message,
            }
        }
    }
}
impl InvalidOptionGroupStateFault {
    /// Creates a new builder-style object to manufacture [`InvalidOptionGroupStateFault`](crate::error::InvalidOptionGroupStateFault)
    pub fn builder() -> crate::error::invalid_option_group_state_fault::Builder {
        crate::error::invalid_option_group_state_fault::Builder::default()
    }
}

/// <p>The supplied category does not exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SubscriptionCategoryNotFoundFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SubscriptionCategoryNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SubscriptionCategoryNotFoundFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl SubscriptionCategoryNotFoundFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for SubscriptionCategoryNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "SubscriptionCategoryNotFoundFault")?;
        if let Some(inner_62) = &self.message {
            write!(f, ": {}", inner_62)?;
        }
        Ok(())
    }
}
impl std::error::Error for SubscriptionCategoryNotFoundFault {}
/// See [`SubscriptionCategoryNotFoundFault`](crate::error::SubscriptionCategoryNotFoundFault)
pub mod subscription_category_not_found_fault {
    /// A builder for [`SubscriptionCategoryNotFoundFault`](crate::error::SubscriptionCategoryNotFoundFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`SubscriptionCategoryNotFoundFault`](crate::error::SubscriptionCategoryNotFoundFault)
        pub fn build(self) -> crate::error::SubscriptionCategoryNotFoundFault {
            crate::error::SubscriptionCategoryNotFoundFault {
                message: self.message,
            }
        }
    }
}
impl SubscriptionCategoryNotFoundFault {
    /// Creates a new builder-style object to manufacture [`SubscriptionCategoryNotFoundFault`](crate::error::SubscriptionCategoryNotFoundFault)
    pub fn builder() -> crate::error::subscription_category_not_found_fault::Builder {
        crate::error::subscription_category_not_found_fault::Builder::default()
    }
}

/// <p>The SNS topic ARN does not exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SnsTopicArnNotFoundFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SnsTopicArnNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SnsTopicArnNotFoundFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl SnsTopicArnNotFoundFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for SnsTopicArnNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "SnsTopicArnNotFoundFault [SNSTopicArnNotFoundFault]")?;
        if let Some(inner_63) = &self.message {
            write!(f, ": {}", inner_63)?;
        }
        Ok(())
    }
}
impl std::error::Error for SnsTopicArnNotFoundFault {}
/// See [`SnsTopicArnNotFoundFault`](crate::error::SnsTopicArnNotFoundFault)
pub mod sns_topic_arn_not_found_fault {
    /// A builder for [`SnsTopicArnNotFoundFault`](crate::error::SnsTopicArnNotFoundFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`SnsTopicArnNotFoundFault`](crate::error::SnsTopicArnNotFoundFault)
        pub fn build(self) -> crate::error::SnsTopicArnNotFoundFault {
            crate::error::SnsTopicArnNotFoundFault {
                message: self.message,
            }
        }
    }
}
impl SnsTopicArnNotFoundFault {
    /// Creates a new builder-style object to manufacture [`SnsTopicArnNotFoundFault`](crate::error::SnsTopicArnNotFoundFault)
    pub fn builder() -> crate::error::sns_topic_arn_not_found_fault::Builder {
        crate::error::sns_topic_arn_not_found_fault::Builder::default()
    }
}

/// <p>You do not have permission to publish to the SNS topic ARN.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SnsNoAuthorizationFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SnsNoAuthorizationFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SnsNoAuthorizationFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl SnsNoAuthorizationFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for SnsNoAuthorizationFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "SnsNoAuthorizationFault [SNSNoAuthorizationFault]")?;
        if let Some(inner_64) = &self.message {
            write!(f, ": {}", inner_64)?;
        }
        Ok(())
    }
}
impl std::error::Error for SnsNoAuthorizationFault {}
/// See [`SnsNoAuthorizationFault`](crate::error::SnsNoAuthorizationFault)
pub mod sns_no_authorization_fault {
    /// A builder for [`SnsNoAuthorizationFault`](crate::error::SnsNoAuthorizationFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`SnsNoAuthorizationFault`](crate::error::SnsNoAuthorizationFault)
        pub fn build(self) -> crate::error::SnsNoAuthorizationFault {
            crate::error::SnsNoAuthorizationFault {
                message: self.message,
            }
        }
    }
}
impl SnsNoAuthorizationFault {
    /// Creates a new builder-style object to manufacture [`SnsNoAuthorizationFault`](crate::error::SnsNoAuthorizationFault)
    pub fn builder() -> crate::error::sns_no_authorization_fault::Builder {
        crate::error::sns_no_authorization_fault::Builder::default()
    }
}

/// <p>SNS has responded that there is a problem with the SND topic specified.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SnsInvalidTopicFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SnsInvalidTopicFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SnsInvalidTopicFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl SnsInvalidTopicFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for SnsInvalidTopicFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "SnsInvalidTopicFault [SNSInvalidTopicFault]")?;
        if let Some(inner_65) = &self.message {
            write!(f, ": {}", inner_65)?;
        }
        Ok(())
    }
}
impl std::error::Error for SnsInvalidTopicFault {}
/// See [`SnsInvalidTopicFault`](crate::error::SnsInvalidTopicFault)
pub mod sns_invalid_topic_fault {
    /// A builder for [`SnsInvalidTopicFault`](crate::error::SnsInvalidTopicFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`SnsInvalidTopicFault`](crate::error::SnsInvalidTopicFault)
        pub fn build(self) -> crate::error::SnsInvalidTopicFault {
            crate::error::SnsInvalidTopicFault {
                message: self.message,
            }
        }
    }
}
impl SnsInvalidTopicFault {
    /// Creates a new builder-style object to manufacture [`SnsInvalidTopicFault`](crate::error::SnsInvalidTopicFault)
    pub fn builder() -> crate::error::sns_invalid_topic_fault::Builder {
        crate::error::sns_invalid_topic_fault::Builder::default()
    }
}

/// <p>You have reached the maximum number of event subscriptions.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EventSubscriptionQuotaExceededFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for EventSubscriptionQuotaExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EventSubscriptionQuotaExceededFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl EventSubscriptionQuotaExceededFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for EventSubscriptionQuotaExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "EventSubscriptionQuotaExceededFault")?;
        if let Some(inner_66) = &self.message {
            write!(f, ": {}", inner_66)?;
        }
        Ok(())
    }
}
impl std::error::Error for EventSubscriptionQuotaExceededFault {}
/// See [`EventSubscriptionQuotaExceededFault`](crate::error::EventSubscriptionQuotaExceededFault)
pub mod event_subscription_quota_exceeded_fault {
    /// A builder for [`EventSubscriptionQuotaExceededFault`](crate::error::EventSubscriptionQuotaExceededFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`EventSubscriptionQuotaExceededFault`](crate::error::EventSubscriptionQuotaExceededFault)
        pub fn build(self) -> crate::error::EventSubscriptionQuotaExceededFault {
            crate::error::EventSubscriptionQuotaExceededFault {
                message: self.message,
            }
        }
    }
}
impl EventSubscriptionQuotaExceededFault {
    /// Creates a new builder-style object to manufacture [`EventSubscriptionQuotaExceededFault`](crate::error::EventSubscriptionQuotaExceededFault)
    pub fn builder() -> crate::error::event_subscription_quota_exceeded_fault::Builder {
        crate::error::event_subscription_quota_exceeded_fault::Builder::default()
    }
}

/// <p>The DB subnet is already in use in the Availability Zone.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SubnetAlreadyInUse {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SubnetAlreadyInUse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SubnetAlreadyInUse");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl SubnetAlreadyInUse {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for SubnetAlreadyInUse {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "SubnetAlreadyInUse")?;
        if let Some(inner_67) = &self.message {
            write!(f, ": {}", inner_67)?;
        }
        Ok(())
    }
}
impl std::error::Error for SubnetAlreadyInUse {}
/// See [`SubnetAlreadyInUse`](crate::error::SubnetAlreadyInUse)
pub mod subnet_already_in_use {
    /// A builder for [`SubnetAlreadyInUse`](crate::error::SubnetAlreadyInUse)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`SubnetAlreadyInUse`](crate::error::SubnetAlreadyInUse)
        pub fn build(self) -> crate::error::SubnetAlreadyInUse {
            crate::error::SubnetAlreadyInUse {
                message: self.message,
            }
        }
    }
}
impl SubnetAlreadyInUse {
    /// Creates a new builder-style object to manufacture [`SubnetAlreadyInUse`](crate::error::SubnetAlreadyInUse)
    pub fn builder() -> crate::error::subnet_already_in_use::Builder {
        crate::error::subnet_already_in_use::Builder::default()
    }
}

/// <p>The request would result in the user exceeding the allowed number of subnets in a DB subnet groups.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DbSubnetQuotaExceededFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DbSubnetQuotaExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DbSubnetQuotaExceededFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DbSubnetQuotaExceededFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DbSubnetQuotaExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DbSubnetQuotaExceededFault [DBSubnetQuotaExceededFault]")?;
        if let Some(inner_68) = &self.message {
            write!(f, ": {}", inner_68)?;
        }
        Ok(())
    }
}
impl std::error::Error for DbSubnetQuotaExceededFault {}
/// See [`DbSubnetQuotaExceededFault`](crate::error::DbSubnetQuotaExceededFault)
pub mod db_subnet_quota_exceeded_fault {
    /// A builder for [`DbSubnetQuotaExceededFault`](crate::error::DbSubnetQuotaExceededFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DbSubnetQuotaExceededFault`](crate::error::DbSubnetQuotaExceededFault)
        pub fn build(self) -> crate::error::DbSubnetQuotaExceededFault {
            crate::error::DbSubnetQuotaExceededFault {
                message: self.message,
            }
        }
    }
}
impl DbSubnetQuotaExceededFault {
    /// Creates a new builder-style object to manufacture [`DbSubnetQuotaExceededFault`](crate::error::DbSubnetQuotaExceededFault)
    pub fn builder() -> crate::error::db_subnet_quota_exceeded_fault::Builder {
        crate::error::db_subnet_quota_exceeded_fault::Builder::default()
    }
}

/// <p>You have exceeded the maximum number of accounts that you can share a manual DB snapshot with.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SharedSnapshotQuotaExceededFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SharedSnapshotQuotaExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SharedSnapshotQuotaExceededFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl SharedSnapshotQuotaExceededFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for SharedSnapshotQuotaExceededFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "SharedSnapshotQuotaExceededFault")?;
        if let Some(inner_69) = &self.message {
            write!(f, ": {}", inner_69)?;
        }
        Ok(())
    }
}
impl std::error::Error for SharedSnapshotQuotaExceededFault {}
/// See [`SharedSnapshotQuotaExceededFault`](crate::error::SharedSnapshotQuotaExceededFault)
pub mod shared_snapshot_quota_exceeded_fault {
    /// A builder for [`SharedSnapshotQuotaExceededFault`](crate::error::SharedSnapshotQuotaExceededFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`SharedSnapshotQuotaExceededFault`](crate::error::SharedSnapshotQuotaExceededFault)
        pub fn build(self) -> crate::error::SharedSnapshotQuotaExceededFault {
            crate::error::SharedSnapshotQuotaExceededFault {
                message: self.message,
            }
        }
    }
}
impl SharedSnapshotQuotaExceededFault {
    /// Creates a new builder-style object to manufacture [`SharedSnapshotQuotaExceededFault`](crate::error::SharedSnapshotQuotaExceededFault)
    pub fn builder() -> crate::error::shared_snapshot_quota_exceeded_fault::Builder {
        crate::error::shared_snapshot_quota_exceeded_fault::Builder::default()
    }
}

/// <p>You can't perform this operation while the DB proxy endpoint is in a particular state.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidDbProxyEndpointStateFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidDbProxyEndpointStateFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidDbProxyEndpointStateFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidDbProxyEndpointStateFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidDbProxyEndpointStateFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "InvalidDbProxyEndpointStateFault [InvalidDBProxyEndpointStateFault]"
        )?;
        if let Some(inner_70) = &self.message {
            write!(f, ": {}", inner_70)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidDbProxyEndpointStateFault {}
/// See [`InvalidDbProxyEndpointStateFault`](crate::error::InvalidDbProxyEndpointStateFault)
pub mod invalid_db_proxy_endpoint_state_fault {
    /// A builder for [`InvalidDbProxyEndpointStateFault`](crate::error::InvalidDbProxyEndpointStateFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidDbProxyEndpointStateFault`](crate::error::InvalidDbProxyEndpointStateFault)
        pub fn build(self) -> crate::error::InvalidDbProxyEndpointStateFault {
            crate::error::InvalidDbProxyEndpointStateFault {
                message: self.message,
            }
        }
    }
}
impl InvalidDbProxyEndpointStateFault {
    /// Creates a new builder-style object to manufacture [`InvalidDbProxyEndpointStateFault`](crate::error::InvalidDbProxyEndpointStateFault)
    pub fn builder() -> crate::error::invalid_db_proxy_endpoint_state_fault::Builder {
        crate::error::invalid_db_proxy_endpoint_state_fault::Builder::default()
    }
}

/// <p>The DB proxy endpoint doesn't exist.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DbProxyEndpointNotFoundFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DbProxyEndpointNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DbProxyEndpointNotFoundFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DbProxyEndpointNotFoundFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DbProxyEndpointNotFoundFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "DbProxyEndpointNotFoundFault [DBProxyEndpointNotFoundFault]"
        )?;
        if let Some(inner_71) = &self.message {
            write!(f, ": {}", inner_71)?;
        }
        Ok(())
    }
}
impl std::error::Error for DbProxyEndpointNotFoundFault {}
/// See [`DbProxyEndpointNotFoundFault`](crate::error::DbProxyEndpointNotFoundFault)
pub mod db_proxy_endpoint_not_found_fault {
    /// A builder for [`DbProxyEndpointNotFoundFault`](crate::error::DbProxyEndpointNotFoundFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DbProxyEndpointNotFoundFault`](crate::error::DbProxyEndpointNotFoundFault)
        pub fn build(self) -> crate::error::DbProxyEndpointNotFoundFault {
            crate::error::DbProxyEndpointNotFoundFault {
                message: self.message,
            }
        }
    }
}
impl DbProxyEndpointNotFoundFault {
    /// Creates a new builder-style object to manufacture [`DbProxyEndpointNotFoundFault`](crate::error::DbProxyEndpointNotFoundFault)
    pub fn builder() -> crate::error::db_proxy_endpoint_not_found_fault::Builder {
        crate::error::db_proxy_endpoint_not_found_fault::Builder::default()
    }
}

/// <p>The specified DB proxy endpoint name must be unique for all DB proxy endpoints owned by your Amazon Web Services account in the specified Amazon Web Services Region.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DbProxyEndpointAlreadyExistsFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DbProxyEndpointAlreadyExistsFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DbProxyEndpointAlreadyExistsFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DbProxyEndpointAlreadyExistsFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DbProxyEndpointAlreadyExistsFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(
            f,
            "DbProxyEndpointAlreadyExistsFault [DBProxyEndpointAlreadyExistsFault]"
        )?;
        if let Some(inner_72) = &self.message {
            write!(f, ": {}", inner_72)?;
        }
        Ok(())
    }
}
impl std::error::Error for DbProxyEndpointAlreadyExistsFault {}
/// See [`DbProxyEndpointAlreadyExistsFault`](crate::error::DbProxyEndpointAlreadyExistsFault)
pub mod db_proxy_endpoint_already_exists_fault {
    /// A builder for [`DbProxyEndpointAlreadyExistsFault`](crate::error::DbProxyEndpointAlreadyExistsFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DbProxyEndpointAlreadyExistsFault`](crate::error::DbProxyEndpointAlreadyExistsFault)
        pub fn build(self) -> crate::error::DbProxyEndpointAlreadyExistsFault {
            crate::error::DbProxyEndpointAlreadyExistsFault {
                message: self.message,
            }
        }
    }
}
impl DbProxyEndpointAlreadyExistsFault {
    /// Creates a new builder-style object to manufacture [`DbProxyEndpointAlreadyExistsFault`](crate::error::DbProxyEndpointAlreadyExistsFault)
    pub fn builder() -> crate::error::db_proxy_endpoint_already_exists_fault::Builder {
        crate::error::db_proxy_endpoint_already_exists_fault::Builder::default()
    }
}

/// <p>The specified proxy name must be unique for all proxies owned by your Amazon Web Services account in the specified Amazon Web Services Region.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DbProxyAlreadyExistsFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DbProxyAlreadyExistsFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DbProxyAlreadyExistsFault");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl DbProxyAlreadyExistsFault {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for DbProxyAlreadyExistsFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "DbProxyAlreadyExistsFault [DBProxyAlreadyExistsFault]")?;
        if let Some(inner_73) = &self.message {
            write!(f, ": {}", inner_73)?;
        }
        Ok(())
    }
}
impl std::error::Error for DbProxyAlreadyExistsFault {}
/// See [`DbProxyAlreadyExistsFault`](crate::error::DbProxyAlreadyExistsFault)
pub mod db_proxy_already_exists_fault {
    /// A builder for [`DbProxyAlreadyExistsFault`](crate::error::DbProxyAlreadyExistsFault)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`DbProxyAlreadyExistsFault`](crate::error::DbProxyAlreadyExistsFault)
        pub fn build(self) -> crate::error::DbProxyAlreadyExistsFault {
            crate::error::DbProxyAlreadyExistsFault {
                message: self.message,
            }
        }
    }
}
impl DbProxyAlreadyExistsFault {
    /// Creates a new builder-style object to manufacture [`DbProxyAlreadyExistsFault`](crate::error::DbProxyAlreadyExistsFault)
    pub fn builder() -> crate::error::db_proxy_already_exists_fault::Builder {
        crate::error::db_proxy_already_exists_fault::Builder::default()
    }
}

/// <p>The DB upgrade failed because a resource the DB depends on can't be modified.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DbUpgradeDependencyFailureFault {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DbUpgradeDependencyFailureFault {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DbUpgradeDependencyFailureFault");
        formatter.field("message", &self.message);
        formatter.finis