// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// All possible error types for this service.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum Error {
    /// <p>The specified CIDR IP range or Amazon EC2 security group is already authorized for
    /// the specified DB security group.</p>
    AuthorizationAlreadyExistsFault(crate::error::AuthorizationAlreadyExistsFault),
    /// <p>The specified CIDR IP range or Amazon EC2 security group might not be authorized
    /// for the specified DB security group.</p>
    /// <p>Or, RDS might not be authorized to perform necessary actions using IAM on your
    /// behalf.</p>
    AuthorizationNotFoundFault(crate::error::AuthorizationNotFoundFault),
    /// <p>The DB security group authorization quota has been reached.</p>
    AuthorizationQuotaExceededFault(crate::error::AuthorizationQuotaExceededFault),
    #[allow(missing_docs)] // documentation missing in model
    BackupPolicyNotFoundFault(crate::error::BackupPolicyNotFoundFault),
    /// <p>
    /// <code>CertificateIdentifier</code> doesn't refer to an
    /// existing certificate.
    /// </p>
    CertificateNotFoundFault(crate::error::CertificateNotFoundFault),
    /// <p>
    /// <code>CustomAvailabilityZoneName</code> is already used by an existing custom
    /// Availability Zone.</p>
    CustomAvailabilityZoneAlreadyExistsFault(
        crate::error::CustomAvailabilityZoneAlreadyExistsFault,
    ),
    /// <p>
    /// <code>CustomAvailabilityZoneId</code> doesn't refer to an existing custom
    /// Availability Zone identifier.</p>
    CustomAvailabilityZoneNotFoundFault(crate::error::CustomAvailabilityZoneNotFoundFault),
    /// <p>You have exceeded the maximum number of custom Availability Zones.</p>
    CustomAvailabilityZoneQuotaExceededFault(
        crate::error::CustomAvailabilityZoneQuotaExceededFault,
    ),
    /// <p>A CEV with the specified name already exists.</p>
    CustomDbEngineVersionAlreadyExistsFault(crate::error::CustomDbEngineVersionAlreadyExistsFault),
    /// <p>The specified CEV was not found.</p>
    CustomDbEngineVersionNotFoundFault(crate::error::CustomDbEngineVersionNotFoundFault),
    /// <p>You have exceeded your CEV quota.</p>
    CustomDbEngineVersionQuotaExceededFault(crate::error::CustomDbEngineVersionQuotaExceededFault),
    /// <p>The user already has a DB cluster with the given identifier.</p>
    DbClusterAlreadyExistsFault(crate::error::DbClusterAlreadyExistsFault),
    /// <p>
    /// <code>BacktrackIdentifier</code> doesn't refer to an existing backtrack. </p>
    DbClusterBacktrackNotFoundFault(crate::error::DbClusterBacktrackNotFoundFault),
    /// <p>The specified custom endpoint can't be created because it already exists.</p>
    DbClusterEndpointAlreadyExistsFault(crate::error::DbClusterEndpointAlreadyExistsFault),
    /// <p>The specified custom endpoint doesn't exist.</p>
    DbClusterEndpointNotFoundFault(crate::error::DbClusterEndpointNotFoundFault),
    /// <p>The cluster already has the maximum number of custom endpoints.</p>
    DbClusterEndpointQuotaExceededFault(crate::error::DbClusterEndpointQuotaExceededFault),
    /// <p>
    /// <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.
    /// </p>
    DbClusterNotFoundFault(crate::error::DbClusterNotFoundFault),
    /// <p>
    /// <code>DBClusterParameterGroupName</code> doesn't refer to an existing DB
    /// cluster parameter group. </p>
    DbClusterParameterGroupNotFoundFault(crate::error::DbClusterParameterGroupNotFoundFault),
    /// <p>The user attempted to create a new DB cluster and the user has already reached the
    /// maximum allowed DB cluster quota.</p>
    DbClusterQuotaExceededFault(crate::error::DbClusterQuotaExceededFault),
    /// <p>The specified IAM role Amazon Resource Name (ARN) is already associated with the specified DB cluster.</p>
    DbClusterRoleAlreadyExistsFault(crate::error::DbClusterRoleAlreadyExistsFault),
    /// <p>The specified IAM role Amazon Resource Name (ARN) isn't associated with the specified DB cluster.</p>
    DbClusterRoleNotFoundFault(crate::error::DbClusterRoleNotFoundFault),
    /// <p>You have exceeded the maximum number of IAM roles that can be associated with the specified DB cluster.</p>
    DbClusterRoleQuotaExceededFault(crate::error::DbClusterRoleQuotaExceededFault),
    /// <p>The user already has a DB cluster snapshot with the given identifier.</p>
    DbClusterSnapshotAlreadyExistsFault(crate::error::DbClusterSnapshotAlreadyExistsFault),
    /// <p>
    /// <code>DBClusterSnapshotIdentifier</code> doesn't refer to an existing DB cluster snapshot.
    /// </p>
    DbClusterSnapshotNotFoundFault(crate::error::DbClusterSnapshotNotFoundFault),
    /// <p>The user already has a DB instance with the given identifier.</p>
    DbInstanceAlreadyExistsFault(crate::error::DbInstanceAlreadyExistsFault),
    /// <p>No automated backup for this DB instance was found.</p>
    DbInstanceAutomatedBackupNotFoundFault(crate::error::DbInstanceAutomatedBackupNotFoundFault),
    /// <p>The quota for retained automated backups was exceeded. This prevents you
    /// from retaining any additional automated backups. The retained automated backups
    /// quota is the same as your DB Instance quota.</p>
    DbInstanceAutomatedBackupQuotaExceededFault(
        crate::error::DbInstanceAutomatedBackupQuotaExceededFault,
    ),
    /// <p>
    /// <code>DBInstanceIdentifier</code> doesn't refer to an existing DB instance.
    /// </p>
    DbInstanceNotFoundFault(crate::error::DbInstanceNotFoundFault),
    /// <p>The specified <code>RoleArn</code> or <code>FeatureName</code> value is already associated with the DB instance.</p>
    DbInstanceRoleAlreadyExistsFault(crate::error::DbInstanceRoleAlreadyExistsFault),
    /// <p>The specified <code>RoleArn</code> value doesn't match the specified feature for
    /// the DB instance.</p>
    DbInstanceRoleNotFoundFault(crate::error::DbInstanceRoleNotFoundFault),
    /// <p>You can't associate any more Amazon Web Services Identity and Access Management (IAM) roles with the DB instance because the quota has been reached.</p>
    DbInstanceRoleQuotaExceededFault(crate::error::DbInstanceRoleQuotaExceededFault),
    /// <p>
    /// <code>LogFileName</code> doesn't refer to an existing DB log file.</p>
    DbLogFileNotFoundFault(crate::error::DbLogFileNotFoundFault),
    /// <p>A DB parameter group with the same name exists.</p>
    DbParameterGroupAlreadyExistsFault(crate::error::DbParameterGroupAlreadyExistsFault),
    /// <p>
    /// <code>DBParameterGroupName</code> doesn't refer to an
    /// existing DB parameter group.
    /// </p>
    DbParameterGroupNotFoundFault(crate::error::DbParameterGroupNotFoundFault),
    /// <p>The request would result in the user exceeding the allowed number of DB parameter
    /// groups.</p>
    DbParameterGroupQuotaExceededFault(crate::error::DbParameterGroupQuotaExceededFault),
    /// <p>The specified proxy name must be unique for all proxies owned by your Amazon Web Services account in the specified Amazon Web Services Region.</p>
    DbProxyAlreadyExistsFault(crate::error::DbProxyAlreadyExistsFault),
    /// <p>The specified DB proxy endpoint name must be unique for all DB proxy endpoints owned by your Amazon Web Services account in the specified Amazon Web Services Region.</p>
    DbProxyEndpointAlreadyExistsFault(crate::error::DbProxyEndpointAlreadyExistsFault),
    /// <p>The DB proxy endpoint doesn't exist.</p>
    DbProxyEndpointNotFoundFault(crate::error::DbProxyEndpointNotFoundFault),
    /// <p>The DB proxy already has the maximum number of endpoints.</p>
    DbProxyEndpointQuotaExceededFault(crate::error::DbProxyEndpointQuotaExceededFault),
    /// <p>The specified proxy name doesn't correspond to a proxy owned by your Amazon Web Services account in the specified Amazon Web Services Region.</p>
    DbProxyNotFoundFault(crate::error::DbProxyNotFoundFault),
    /// <p>Your Amazon Web Services account already has the maximum number of proxies in the specified Amazon Web Services Region.</p>
    DbProxyQuotaExceededFault(crate::error::DbProxyQuotaExceededFault),
    /// <p>The proxy is already associated with the specified RDS DB instance or Aurora DB cluster.</p>
    DbProxyTargetAlreadyRegisteredFault(crate::error::DbProxyTargetAlreadyRegisteredFault),
    /// <p>The specified target group isn't available for a proxy owned by your Amazon Web Services account in the specified Amazon Web Services Region.</p>
    DbProxyTargetGroupNotFoundFault(crate::error::DbProxyTargetGroupNotFoundFault),
    /// <p>The specified RDS DB instance or Aurora DB cluster isn't available for a proxy owned by your Amazon Web Services account in the specified Amazon Web Services Region.</p>
    DbProxyTargetNotFoundFault(crate::error::DbProxyTargetNotFoundFault),
    /// <p>
    /// A DB security group with the name specified in
    /// <code>DBSecurityGroupName</code> already exists.
    /// </p>
    DbSecurityGroupAlreadyExistsFault(crate::error::DbSecurityGroupAlreadyExistsFault),
    /// <p>
    /// <code>DBSecurityGroupName</code> doesn't refer to an existing DB security group.
    /// </p>
    DbSecurityGroupNotFoundFault(crate::error::DbSecurityGroupNotFoundFault),
    /// <p>A DB security group isn't allowed for this action.</p>
    DbSecurityGroupNotSupportedFault(crate::error::DbSecurityGroupNotSupportedFault),
    /// <p>The request would result in the user exceeding the allowed number of DB security
    /// groups.</p>
    DbSecurityGroupQuotaExceededFault(crate::error::DbSecurityGroupQuotaExceededFault),
    /// <p>
    /// <code>DBSnapshotIdentifier</code> is already used by an existing snapshot.
    /// </p>
    DbSnapshotAlreadyExistsFault(crate::error::DbSnapshotAlreadyExistsFault),
    /// <p>
    /// <code>DBSnapshotIdentifier</code> doesn't refer to an existing DB snapshot.
    /// </p>
    DbSnapshotNotFoundFault(crate::error::DbSnapshotNotFoundFault),
    /// <p>
    /// <code>DBSubnetGroupName</code> is already used by an existing DB subnet group.
    /// </p>
    DbSubnetGroupAlreadyExistsFault(crate::error::DbSubnetGroupAlreadyExistsFault),
    /// <p>Subnets in the DB subnet group should cover at least two Availability Zones unless there is only one Availability Zone.</p>
    DbSubnetGroupDoesNotCoverEnoughAZs(crate::error::DbSubnetGroupDoesNotCoverEnoughAZs),
    /// <p>The DBSubnetGroup shouldn't be specified while creating read replicas that lie
    /// in the same region as the source instance.</p>
    DbSubnetGroupNotAllowedFault(crate::error::DbSubnetGroupNotAllowedFault),
    /// <p>
    /// <code>DBSubnetGroupName</code> doesn't refer to an existing DB subnet group.
    /// </p>
    DbSubnetGroupNotFoundFault(crate::error::DbSubnetGroupNotFoundFault),
    /// <p>The request would result in the user exceeding the allowed number of DB subnet
    /// groups.</p>
    DbSubnetGroupQuotaExceededFault(crate::error::DbSubnetGroupQuotaExceededFault),
    /// <p>The request would result in the user exceeding the allowed number of subnets in a
    /// DB subnet groups.</p>
    DbSubnetQuotaExceededFault(crate::error::DbSubnetQuotaExceededFault),
    /// <p>The DB upgrade failed because a resource the DB depends on can't be
    /// modified.</p>
    DbUpgradeDependencyFailureFault(crate::error::DbUpgradeDependencyFailureFault),
    /// <p>
    /// <code>Domain</code> doesn't refer to an existing Active Directory domain.
    /// </p>
    DomainNotFoundFault(crate::error::DomainNotFoundFault),
    /// <p>You have reached the maximum number of event subscriptions.</p>
    EventSubscriptionQuotaExceededFault(crate::error::EventSubscriptionQuotaExceededFault),
    /// <p>You can't start an export task that's already running.</p>
    ExportTaskAlreadyExistsFault(crate::error::ExportTaskAlreadyExistsFault),
    /// <p>The export task doesn't exist.</p>
    ExportTaskNotFoundFault(crate::error::ExportTaskNotFoundFault),
    /// <p>The <code>GlobalClusterIdentifier</code> already exists. Choose a new global database identifier (unique name) to create a new global database cluster.</p>
    GlobalClusterAlreadyExistsFault(crate::error::GlobalClusterAlreadyExistsFault),
    /// <p>The <code>GlobalClusterIdentifier</code> doesn't refer to an existing global database cluster. </p>
    GlobalClusterNotFoundFault(crate::error::GlobalClusterNotFoundFault),
    /// <p>The number of global database clusters for this account is already at the maximum allowed.</p>
    GlobalClusterQuotaExceededFault(crate::error::GlobalClusterQuotaExceededFault),
    /// <p>The IAM role requires additional permissions to export to an Amazon S3 bucket.</p>
    IamRoleMissingPermissionsFault(crate::error::IamRoleMissingPermissionsFault),
    /// <p>The IAM role is missing for exporting to an Amazon S3 bucket.</p>
    IamRoleNotFoundFault(crate::error::IamRoleNotFoundFault),
    /// <p>The specified installation medium has already been imported.</p>
    InstallationMediaAlreadyExistsFault(crate::error::InstallationMediaAlreadyExistsFault),
    /// <p>
    /// <code>InstallationMediaID</code> doesn't refer to an existing installation medium.</p>
    InstallationMediaNotFoundFault(crate::error::InstallationMediaNotFoundFault),
    /// <p>The request would result in the user exceeding the allowed number of DB
    /// instances.</p>
    InstanceQuotaExceededFault(crate::error::InstanceQuotaExceededFault),
    /// <p>The requested operation can't be performed because there aren't enough available IP addresses
    /// in the proxy's subnets. Add more CIDR blocks to the VPC or remove IP address that aren't required
    /// from the subnets.</p>
    InsufficientAvailableIPsInSubnetFault(crate::error::InsufficientAvailableIPsInSubnetFault),
    /// <p>The DB cluster doesn't have enough capacity for the current operation.</p>
    InsufficientDbClusterCapacityFault(crate::error::InsufficientDbClusterCapacityFault),
    /// <p>The specified DB instance class isn't available in the specified Availability
    /// Zone.</p>
    InsufficientDbInstanceCapacityFault(crate::error::InsufficientDbInstanceCapacityFault),
    /// <p>There is insufficient storage available for the current action. You might be able to
    /// resolve this error by updating your subnet group to use different Availability Zones
    /// that have more storage available.</p>
    InsufficientStorageClusterCapacityFault(crate::error::InsufficientStorageClusterCapacityFault),
    /// <p>You can't delete the CEV.</p>
    InvalidCustomDbEngineVersionStateFault(crate::error::InvalidCustomDbEngineVersionStateFault),
    /// <p>
    /// <code>Capacity</code> isn't a valid Aurora Serverless DB cluster
    /// capacity. Valid capacity values are <code>2</code>, <code>4</code>, <code>8</code>, <code>16</code>,
    /// <code>32</code>, <code>64</code>, <code>128</code>, and <code>256</code>.</p>
    InvalidDbClusterCapacityFault(crate::error::InvalidDbClusterCapacityFault),
    /// <p>The requested operation can't be performed on the endpoint while the endpoint is in this state.</p>
    InvalidDbClusterEndpointStateFault(crate::error::InvalidDbClusterEndpointStateFault),
    /// <p>The supplied value isn't a valid DB cluster snapshot state.</p>
    InvalidDbClusterSnapshotStateFault(crate::error::InvalidDbClusterSnapshotStateFault),
    /// <p>The requested operation can't be performed while the cluster is in this state.</p>
    InvalidDbClusterStateFault(crate::error::InvalidDbClusterStateFault),
    /// <p>The automated backup is in an invalid state.
    /// For example, this automated backup is associated with an active instance. </p>
    InvalidDbInstanceAutomatedBackupStateFault(
        crate::error::InvalidDbInstanceAutomatedBackupStateFault,
    ),
    /// <p>The DB instance isn't in a valid state.</p>
    InvalidDbInstanceStateFault(crate::error::InvalidDbInstanceStateFault),
    /// <p>The DB parameter group is in use or is in an invalid state. If you are attempting
    /// to delete the parameter group, you can't delete it when the parameter group is in
    /// this state.</p>
    InvalidDbParameterGroupStateFault(crate::error::InvalidDbParameterGroupStateFault),
    /// <p>You can't perform this operation while the DB proxy endpoint is in a particular state.</p>
    InvalidDbProxyEndpointStateFault(crate::error::InvalidDbProxyEndpointStateFault),
    /// <p>The requested operation can't be performed while the proxy is in this state.</p>
    InvalidDbProxyStateFault(crate::error::InvalidDbProxyStateFault),
    /// <p>The state of the DB security group doesn't allow deletion.</p>
    InvalidDbSecurityGroupStateFault(crate::error::InvalidDbSecurityGroupStateFault),
    /// <p>The state of the DB snapshot doesn't allow deletion.</p>
    InvalidDbSnapshotStateFault(crate::error::InvalidDbSnapshotStateFault),
    /// <p>The DBSubnetGroup doesn't belong to the same VPC as that of an existing
    /// cross-region read replica of the same source instance.</p>
    InvalidDbSubnetGroupFault(crate::error::InvalidDbSubnetGroupFault),
    /// <p>The DB subnet group cannot be deleted because it's in use.</p>
    InvalidDbSubnetGroupStateFault(crate::error::InvalidDbSubnetGroupStateFault),
    /// <p>
    /// The DB subnet isn't in the <i>available</i> state.
    /// </p>
    InvalidDbSubnetStateFault(crate::error::InvalidDbSubnetStateFault),
    /// <p>This error can occur if someone else is modifying a subscription. You should retry the action.</p>
    InvalidEventSubscriptionStateFault(crate::error::InvalidEventSubscriptionStateFault),
    /// <p>The export is invalid for exporting to an Amazon S3 bucket.</p>
    InvalidExportOnlyFault(crate::error::InvalidExportOnlyFault),
    /// <p>The state of the export snapshot is invalid for exporting to an Amazon S3 bucket.</p>
    InvalidExportSourceStateFault(crate::error::InvalidExportSourceStateFault),
    /// <p>You can't cancel an export task that has completed.</p>
    InvalidExportTaskStateFault(crate::error::InvalidExportTaskStateFault),
    /// <p>The global cluster is in an invalid state and can't perform the requested operation. </p>
    InvalidGlobalClusterStateFault(crate::error::InvalidGlobalClusterStateFault),
    /// <p>
    /// The option group isn't in the <i>available</i> state.
    /// </p>
    InvalidOptionGroupStateFault(crate::error::InvalidOptionGroupStateFault),
    /// <p>Cannot restore from VPC backup to non-VPC DB instance.</p>
    InvalidRestoreFault(crate::error::InvalidRestoreFault),
    /// <p>The specified Amazon S3 bucket name can't be found or Amazon RDS isn't
    /// authorized to access the specified Amazon S3 bucket. Verify the <b>SourceS3BucketName</b> and <b>S3IngestionRoleArn</b> values and try again.</p>
    InvalidS3BucketFault(crate::error::InvalidS3BucketFault),
    /// <p>The requested subnet is invalid, or multiple subnets were requested that are not all in a common VPC.</p>
    InvalidSubnet(crate::error::InvalidSubnet),
    /// <p>The DB subnet group doesn't cover all Availability Zones after it's
    /// created because of users' change.</p>
    InvalidVpcNetworkStateFault(crate::error::InvalidVpcNetworkStateFault),
    /// <p>An error occurred accessing an Amazon Web Services KMS key.</p>
    KmsKeyNotAccessibleFault(crate::error::KmsKeyNotAccessibleFault),
    /// <p>The option group you are trying to create already exists.</p>
    OptionGroupAlreadyExistsFault(crate::error::OptionGroupAlreadyExistsFault),
    /// <p>The specified option group could not be found.</p>
    OptionGroupNotFoundFault(crate::error::OptionGroupNotFoundFault),
    /// <p>The quota of 20 option groups was exceeded for this Amazon Web Services account.</p>
    OptionGroupQuotaExceededFault(crate::error::OptionGroupQuotaExceededFault),
    /// <p>
    /// <code>SourceDBInstanceIdentifier</code>
    /// refers to a DB instance with
    /// <code>BackupRetentionPeriod</code> equal to 0.
    /// </p>
    PointInTimeRestoreNotEnabledFault(crate::error::PointInTimeRestoreNotEnabledFault),
    /// <p>Provisioned IOPS not available in the specified Availability Zone.</p>
    ProvisionedIopsNotAvailableInAzFault(crate::error::ProvisionedIopsNotAvailableInAzFault),
    /// <p>User already has a reservation with the given identifier.</p>
    ReservedDbInstanceAlreadyExistsFault(crate::error::ReservedDbInstanceAlreadyExistsFault),
    /// <p>The specified reserved DB Instance not found.</p>
    ReservedDbInstanceNotFoundFault(crate::error::ReservedDbInstanceNotFoundFault),
    /// <p>Request would exceed the user's DB Instance quota.</p>
    ReservedDbInstanceQuotaExceededFault(crate::error::ReservedDbInstanceQuotaExceededFault),
    /// <p>Specified offering does not exist.</p>
    ReservedDbInstancesOfferingNotFoundFault(
        crate::error::ReservedDbInstancesOfferingNotFoundFault,
    ),
    /// <p>The specified resource ID was not found.</p>
    ResourceNotFoundFault(crate::error::ResourceNotFoundFault),
    /// <p>SNS has responded that there is a problem with the SND topic specified.</p>
    SnsInvalidTopicFault(crate::error::SnsInvalidTopicFault),
    /// <p>You do not have permission to publish to the SNS topic ARN.</p>
    SnsNoAuthorizationFault(crate::error::SnsNoAuthorizationFault),
    /// <p>The SNS topic ARN does not exist.</p>
    SnsTopicArnNotFoundFault(crate::error::SnsTopicArnNotFoundFault),
    /// <p>You have exceeded the maximum number of accounts that you can share a manual DB snapshot with.</p>
    SharedSnapshotQuotaExceededFault(crate::error::SharedSnapshotQuotaExceededFault),
    /// <p>The request would result in the user exceeding the allowed number of DB
    /// snapshots.</p>
    SnapshotQuotaExceededFault(crate::error::SnapshotQuotaExceededFault),
    /// <p>The requested source could not be found.</p>
    SourceNotFoundFault(crate::error::SourceNotFoundFault),
    /// <p>The request would result in the user exceeding the allowed amount of storage
    /// available across all DB instances.</p>
    StorageQuotaExceededFault(crate::error::StorageQuotaExceededFault),
    /// <p>Storage of the <code>StorageType</code> specified can't be associated
    /// with the DB instance. </p>
    StorageTypeNotSupportedFault(crate::error::StorageTypeNotSupportedFault),
    /// <p>The DB subnet is already in use in the Availability Zone.</p>
    SubnetAlreadyInUse(crate::error::SubnetAlreadyInUse),
    /// <p>The supplied subscription name already exists.</p>
    SubscriptionAlreadyExistFault(crate::error::SubscriptionAlreadyExistFault),
    /// <p>The supplied category does not exist.</p>
    SubscriptionCategoryNotFoundFault(crate::error::SubscriptionCategoryNotFoundFault),
    /// <p>The subscription name does not exist.</p>
    SubscriptionNotFoundFault(crate::error::SubscriptionNotFoundFault),
    /// An unhandled error occurred.
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for Error {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match self {
            Error::AuthorizationAlreadyExistsFault(inner) => inner.fmt(f),
            Error::AuthorizationNotFoundFault(inner) => inner.fmt(f),
            Error::AuthorizationQuotaExceededFault(inner) => inner.fmt(f),
            Error::BackupPolicyNotFoundFault(inner) => inner.fmt(f),
            Error::CertificateNotFoundFault(inner) => inner.fmt(f),
            Error::CustomAvailabilityZoneAlreadyExistsFault(inner) => inner.fmt(f),
            Error::CustomAvailabilityZoneNotFoundFault(inner) => inner.fmt(f),
            Error::CustomAvailabilityZoneQuotaExceededFault(inner) => inner.fmt(f),
            Error::CustomDbEngineVersionAlreadyExistsFault(inner) => inner.fmt(f),
            Error::CustomDbEngineVersionNotFoundFault(inner) => inner.fmt(f),
            Error::CustomDbEngineVersionQuotaExceededFault(inner) => inner.fmt(f),
            Error::DbClusterAlreadyExistsFault(inner) => inner.fmt(f),
            Error::DbClusterBacktrackNotFoundFault(inner) => inner.fmt(f),
            Error::DbClusterEndpointAlreadyExistsFault(inner) => inner.fmt(f),
            Error::DbClusterEndpointNotFoundFault(inner) => inner.fmt(f),
            Error::DbClusterEndpointQuotaExceededFault(inner) => inner.fmt(f),
            Error::DbClusterNotFoundFault(inner) => inner.fmt(f),
            Error::DbClusterParameterGroupNotFoundFault(inner) => inner.fmt(f),
            Error::DbClusterQuotaExceededFault(inner) => inner.fmt(f),
            Error::DbClusterRoleAlreadyExistsFault(inner) => inner.fmt(f),
            Error::DbClusterRoleNotFoundFault(inner) => inner.fmt(f),
            Error::DbClusterRoleQuotaExceededFault(inner) => inner.fmt(f),
            Error::DbClusterSnapshotAlreadyExistsFault(inner) => inner.fmt(f),
            Error::DbClusterSnapshotNotFoundFault(inner) => inner.fmt(f),
            Error::DbInstanceAlreadyExistsFault(inner) => inner.fmt(f),
            Error::DbInstanceAutomatedBackupNotFoundFault(inner) => inner.fmt(f),
            Error::DbInstanceAutomatedBackupQuotaExceededFault(inner) => inner.fmt(f),
            Error::DbInstanceNotFoundFault(inner) => inner.fmt(f),
            Error::DbInstanceRoleAlreadyExistsFault(inner) => inner.fmt(f),
            Error::DbInstanceRoleNotFoundFault(inner) => inner.fmt(f),
            Error::DbInstanceRoleQuotaExceededFault(inner) => inner.fmt(f),
            Error::DbLogFileNotFoundFault(inner) => inner.fmt(f),
            Error::DbParameterGroupAlreadyExistsFault(inner) => inner.fmt(f),
            Error::DbParameterGroupNotFoundFault(inner) => inner.fmt(f),
            Error::DbParameterGroupQuotaExceededFault(inner) => inner.fmt(f),
            Error::DbProxyAlreadyExistsFault(inner) => inner.fmt(f),
            Error::DbProxyEndpointAlreadyExistsFault(inner) => inner.fmt(f),
            Error::DbProxyEndpointNotFoundFault(inner) => inner.fmt(f),
            Error::DbProxyEndpointQuotaExceededFault(inner) => inner.fmt(f),
            Error::DbProxyNotFoundFault(inner) => inner.fmt(f),
            Error::DbProxyQuotaExceededFault(inner) => inner.fmt(f),
            Error::DbProxyTargetAlreadyRegisteredFault(inner) => inner.fmt(f),
            Error::DbProxyTargetGroupNotFoundFault(inner) => inner.fmt(f),
            Error::DbProxyTargetNotFoundFault(inner) => inner.fmt(f),
            Error::DbSecurityGroupAlreadyExistsFault(inner) => inner.fmt(f),
            Error::DbSecurityGroupNotFoundFault(inner) => inner.fmt(f),
            Error::DbSecurityGroupNotSupportedFault(inner) => inner.fmt(f),
            Error::DbSecurityGroupQuotaExceededFault(inner) => inner.fmt(f),
            Error::DbSnapshotAlreadyExistsFault(inner) => inner.fmt(f),
            Error::DbSnapshotNotFoundFault(inner) => inner.fmt(f),
            Error::DbSubnetGroupAlreadyExistsFault(inner) => inner.fmt(f),
            Error::DbSubnetGroupDoesNotCoverEnoughAZs(inner) => inner.fmt(f),
            Error::DbSubnetGroupNotAllowedFault(inner) => inner.fmt(f),
            Error::DbSubnetGroupNotFoundFault(inner) => inner.fmt(f),
            Error::DbSubnetGroupQuotaExceededFault(inner) => inner.fmt(f),
            Error::DbSubnetQuotaExceededFault(inner) => inner.fmt(f),
            Error::DbUpgradeDependencyFailureFault(inner) => inner.fmt(f),
            Error::DomainNotFoundFault(inner) => inner.fmt(f),
            Error::EventSubscriptionQuotaExceededFault(inner) => inner.fmt(f),
            Error::ExportTaskAlreadyExistsFault(inner) => inner.fmt(f),
            Error::ExportTaskNotFoundFault(inner) => inner.fmt(f),
            Error::GlobalClusterAlreadyExistsFault(inner) => inner.fmt(f),
            Error::GlobalClusterNotFoundFault(inner) => inner.fmt(f),
            Error::GlobalClusterQuotaExceededFault(inner) => inner.fmt(f),
            Error::IamRoleMissingPermissionsFault(inner) => inner.fmt(f),
            Error::IamRoleNotFoundFault(inner) => inner.fmt(f),
            Error::InstallationMediaAlreadyExistsFault(inner) => inner.fmt(f),
            Error::InstallationMediaNotFoundFault(inner) => inner.fmt(f),
            Error::InstanceQuotaExceededFault(inner) => inner.fmt(f),
            Error::InsufficientAvailableIPsInSubnetFault(inner) => inner.fmt(f),
            Error::InsufficientDbClusterCapacityFault(inner) => inner.fmt(f),
            Error::InsufficientDbInstanceCapacityFault(inner) => inner.fmt(f),
            Error::InsufficientStorageClusterCapacityFault(inner) => inner.fmt(f),
            Error::InvalidCustomDbEngineVersionStateFault(inner) => inner.fmt(f),
            Error::InvalidDbClusterCapacityFault(inner) => inner.fmt(f),
            Error::InvalidDbClusterEndpointStateFault(inner) => inner.fmt(f),
            Error::InvalidDbClusterSnapshotStateFault(inner) => inner.fmt(f),
            Error::InvalidDbClusterStateFault(inner) => inner.fmt(f),
            Error::InvalidDbInstanceAutomatedBackupStateFault(inner) => inner.fmt(f),
            Error::InvalidDbInstanceStateFault(inner) => inner.fmt(f),
            Error::InvalidDbParameterGroupStateFault(inner) => inner.fmt(f),
            Error::InvalidDbProxyEndpointStateFault(inner) => inner.fmt(f),
            Error::InvalidDbProxyStateFault(inner) => inner.fmt(f),
            Error::InvalidDbSecurityGroupStateFault(inner) => inner.fmt(f),
            Error::InvalidDbSnapshotStateFault(inner) => inner.fmt(f),
            Error::InvalidDbSubnetGroupFault(inner) => inner.fmt(f),
            Error::InvalidDbSubnetGroupStateFault(inner) => inner.fmt(f),
            Error::InvalidDbSubnetStateFault(inner) => inner.fmt(f),
            Error::InvalidEventSubscriptionStateFault(inner) => inner.fmt(f),
            Error::InvalidExportOnlyFault(inner) => inner.fmt(f),
            Error::InvalidExportSourceStateFault(inner) => inner.fmt(f),
            Error::InvalidExportTaskStateFault(inner) => inner.fmt(f),
            Error::InvalidGlobalClusterStateFault(inner) => inner.fmt(f),
            Error::InvalidOptionGroupStateFault(inner) => inner.fmt(f),
            Error::InvalidRestoreFault(inner) => inner.fmt(f),
            Error::InvalidS3BucketFault(inner) => inner.fmt(f),
            Error::InvalidSubnet(inner) => inner.fmt(f),
            Error::InvalidVpcNetworkStateFault(inner) => inner.fmt(f),
            Error::KmsKeyNotAccessibleFault(inner) => inner.fmt(f),
            Error::OptionGroupAlreadyExistsFault(inner) => inner.fmt(f),
            Error::OptionGroupNotFoundFault(inner) => inner.fmt(f),
            Error::OptionGroupQuotaExceededFault(inner) => inner.fmt(f),
            Error::PointInTimeRestoreNotEnabledFault(inner) => inner.fmt(f),
            Error::ProvisionedIopsNotAvailableInAzFault(inner) => inner.fmt(f),
            Error::ReservedDbInstanceAlreadyExistsFault(inner) => inner.fmt(f),
            Error::ReservedDbInstanceNotFoundFault(inner) => inner.fmt(f),
            Error::ReservedDbInstanceQuotaExceededFault(inner) => inner.fmt(f),
            Error::ReservedDbInstancesOfferingNotFoundFault(inner) => inner.fmt(f),
            Error::ResourceNotFoundFault(inner) => inner.fmt(f),
            Error::SnsInvalidTopicFault(inner) => inner.fmt(f),
            Error::SnsNoAuthorizationFault(inner) => inner.fmt(f),
            Error::SnsTopicArnNotFoundFault(inner) => inner.fmt(f),
            Error::SharedSnapshotQuotaExceededFault(inner) => inner.fmt(f),
            Error::SnapshotQuotaExceededFault(inner) => inner.fmt(f),
            Error::SourceNotFoundFault(inner) => inner.fmt(f),
            Error::StorageQuotaExceededFault(inner) => inner.fmt(f),
            Error::StorageTypeNotSupportedFault(inner) => inner.fmt(f),
            Error::SubnetAlreadyInUse(inner) => inner.fmt(f),
            Error::SubscriptionAlreadyExistFault(inner) => inner.fmt(f),
            Error::SubscriptionCategoryNotFoundFault(inner) => inner.fmt(f),
            Error::SubscriptionNotFoundFault(inner) => inner.fmt(f),
            Error::Unhandled(inner) => inner.fmt(f),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::AddRoleToDBClusterError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::AddRoleToDBClusterError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::AddRoleToDBClusterErrorKind::DbClusterNotFoundFault(inner) => {
                    Error::DbClusterNotFoundFault(inner)
                }
                crate::error::AddRoleToDBClusterErrorKind::DbClusterRoleAlreadyExistsFault(
                    inner,
                ) => Error::DbClusterRoleAlreadyExistsFault(inner),
                crate::error::AddRoleToDBClusterErrorKind::DbClusterRoleQuotaExceededFault(
                    inner,
                ) => Error::DbClusterRoleQuotaExceededFault(inner),
                crate::error::AddRoleToDBClusterErrorKind::InvalidDbClusterStateFault(inner) => {
                    Error::InvalidDbClusterStateFault(inner)
                }
                crate::error::AddRoleToDBClusterErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::AddRoleToDBInstanceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::AddRoleToDBInstanceError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::AddRoleToDBInstanceErrorKind::DbInstanceNotFoundFault(inner) => {
                    Error::DbInstanceNotFoundFault(inner)
                }
                crate::error::AddRoleToDBInstanceErrorKind::DbInstanceRoleAlreadyExistsFault(
                    inner,
                ) => Error::DbInstanceRoleAlreadyExistsFault(inner),
                crate::error::AddRoleToDBInstanceErrorKind::DbInstanceRoleQuotaExceededFault(
                    inner,
                ) => Error::DbInstanceRoleQuotaExceededFault(inner),
                crate::error::AddRoleToDBInstanceErrorKind::InvalidDbInstanceStateFault(inner) => {
                    Error::InvalidDbInstanceStateFault(inner)
                }
                crate::error::AddRoleToDBInstanceErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::AddSourceIdentifierToSubscriptionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::AddSourceIdentifierToSubscriptionError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::AddSourceIdentifierToSubscriptionErrorKind::SourceNotFoundFault(inner) => Error::SourceNotFoundFault(inner),
                crate::error::AddSourceIdentifierToSubscriptionErrorKind::SubscriptionNotFoundFault(inner) => Error::SubscriptionNotFoundFault(inner),
                crate::error::AddSourceIdentifierToSubscriptionErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::AddTagsToResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::AddTagsToResourceError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::AddTagsToResourceErrorKind::DbClusterNotFoundFault(inner) => {
                    Error::DbClusterNotFoundFault(inner)
                }
                crate::error::AddTagsToResourceErrorKind::DbInstanceNotFoundFault(inner) => {
                    Error::DbInstanceNotFoundFault(inner)
                }
                crate::error::AddTagsToResourceErrorKind::DbProxyNotFoundFault(inner) => {
                    Error::DbProxyNotFoundFault(inner)
                }
                crate::error::AddTagsToResourceErrorKind::DbProxyTargetGroupNotFoundFault(
                    inner,
                ) => Error::DbProxyTargetGroupNotFoundFault(inner),
                crate::error::AddTagsToResourceErrorKind::DbSnapshotNotFoundFault(inner) => {
                    Error::DbSnapshotNotFoundFault(inner)
                }
                crate::error::AddTagsToResourceErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ApplyPendingMaintenanceActionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ApplyPendingMaintenanceActionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ApplyPendingMaintenanceActionErrorKind::InvalidDbClusterStateFault(inner) => Error::InvalidDbClusterStateFault(inner),
                crate::error::ApplyPendingMaintenanceActionErrorKind::InvalidDbInstanceStateFault(inner) => Error::InvalidDbInstanceStateFault(inner),
                crate::error::ApplyPendingMaintenanceActionErrorKind::ResourceNotFoundFault(inner) => Error::ResourceNotFoundFault(inner),
                crate::error::ApplyPendingMaintenanceActionErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::AuthorizeDBSecurityGroupIngressError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::AuthorizeDBSecurityGroupIngressError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::AuthorizeDBSecurityGroupIngressErrorKind::AuthorizationAlreadyExistsFault(inner) => Error::AuthorizationAlreadyExistsFault(inner),
                crate::error::AuthorizeDBSecurityGroupIngressErrorKind::AuthorizationQuotaExceededFault(inner) => Error::AuthorizationQuotaExceededFault(inner),
                crate::error::AuthorizeDBSecurityGroupIngressErrorKind::DbSecurityGroupNotFoundFault(inner) => Error::DbSecurityGroupNotFoundFault(inner),
                crate::error::AuthorizeDBSecurityGroupIngressErrorKind::InvalidDbSecurityGroupStateFault(inner) => Error::InvalidDbSecurityGroupStateFault(inner),
                crate::error::AuthorizeDBSecurityGroupIngressErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::BacktrackDBClusterError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::BacktrackDBClusterError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::BacktrackDBClusterErrorKind::DbClusterNotFoundFault(inner) => {
                    Error::DbClusterNotFoundFault(inner)
                }
                crate::error::BacktrackDBClusterErrorKind::InvalidDbClusterStateFault(inner) => {
                    Error::InvalidDbClusterStateFault(inner)
                }
                crate::error::BacktrackDBClusterErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CancelExportTaskError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CancelExportTaskError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CancelExportTaskErrorKind::ExportTaskNotFoundFault(inner) => {
                    Error::ExportTaskNotFoundFault(inner)
                }
                crate::error::CancelExportTaskErrorKind::InvalidExportTaskStateFault(inner) => {
                    Error::InvalidExportTaskStateFault(inner)
                }
                crate::error::CancelExportTaskErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CopyDBClusterParameterGroupError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CopyDBClusterParameterGroupError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CopyDBClusterParameterGroupErrorKind::DbParameterGroupAlreadyExistsFault(inner) => Error::DbParameterGroupAlreadyExistsFault(inner),
                crate::error::CopyDBClusterParameterGroupErrorKind::DbParameterGroupNotFoundFault(inner) => Error::DbParameterGroupNotFoundFault(inner),
                crate::error::CopyDBClusterParameterGroupErrorKind::DbParameterGroupQuotaExceededFault(inner) => Error::DbParameterGroupQuotaExceededFault(inner),
                crate::error::CopyDBClusterParameterGroupErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CopyDBClusterSnapshotError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CopyDBClusterSnapshotError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CopyDBClusterSnapshotErrorKind::DbClusterSnapshotAlreadyExistsFault(inner) => Error::DbClusterSnapshotAlreadyExistsFault(inner),
                crate::error::CopyDBClusterSnapshotErrorKind::DbClusterSnapshotNotFoundFault(inner) => Error::DbClusterSnapshotNotFoundFault(inner),
                crate::error::CopyDBClusterSnapshotErrorKind::InvalidDbClusterSnapshotStateFault(inner) => Error::InvalidDbClusterSnapshotStateFault(inner),
                crate::error::CopyDBClusterSnapshotErrorKind::InvalidDbClusterStateFault(inner) => Error::InvalidDbClusterStateFault(inner),
                crate::error::CopyDBClusterSnapshotErrorKind::KmsKeyNotAccessibleFault(inner) => Error::KmsKeyNotAccessibleFault(inner),
                crate::error::CopyDBClusterSnapshotErrorKind::SnapshotQuotaExceededFault(inner) => Error::SnapshotQuotaExceededFault(inner),
                crate::error::CopyDBClusterSnapshotErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CopyDBParameterGroupError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CopyDBParameterGroupError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CopyDBParameterGroupErrorKind::DbParameterGroupAlreadyExistsFault(
                    inner,
                ) => Error::DbParameterGroupAlreadyExistsFault(inner),
                crate::error::CopyDBParameterGroupErrorKind::DbParameterGroupNotFoundFault(
                    inner,
                ) => Error::DbParameterGroupNotFoundFault(inner),
                crate::error::CopyDBParameterGroupErrorKind::DbParameterGroupQuotaExceededFault(
                    inner,
                ) => Error::DbParameterGroupQuotaExceededFault(inner),
                crate::error::CopyDBParameterGroupErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CopyDBSnapshotError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::CopyDBSnapshotError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CopyDBSnapshotErrorKind::CustomAvailabilityZoneNotFoundFault(
                    inner,
                ) => Error::CustomAvailabilityZoneNotFoundFault(inner),
                crate::error::CopyDBSnapshotErrorKind::DbSnapshotAlreadyExistsFault(inner) => {
                    Error::DbSnapshotAlreadyExistsFault(inner)
                }
                crate::error::CopyDBSnapshotErrorKind::DbSnapshotNotFoundFault(inner) => {
                    Error::DbSnapshotNotFoundFault(inner)
                }
                crate::error::CopyDBSnapshotErrorKind::InvalidDbSnapshotStateFault(inner) => {
                    Error::InvalidDbSnapshotStateFault(inner)
                }
                crate::error::CopyDBSnapshotErrorKind::KmsKeyNotAccessibleFault(inner) => {
                    Error::KmsKeyNotAccessibleFault(inner)
                }
                crate::error::CopyDBSnapshotErrorKind::SnapshotQuotaExceededFault(inner) => {
                    Error::SnapshotQuotaExceededFault(inner)
                }
                crate::error::CopyDBSnapshotErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CopyOptionGroupError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::CopyOptionGroupError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CopyOptionGroupErrorKind::OptionGroupAlreadyExistsFault(inner) => {
                    Error::OptionGroupAlreadyExistsFault(inner)
                }
                crate::error::CopyOptionGroupErrorKind::OptionGroupNotFoundFault(inner) => {
                    Error::OptionGroupNotFoundFault(inner)
                }
                crate::error::CopyOptionGroupErrorKind::OptionGroupQuotaExceededFault(inner) => {
                    Error::OptionGroupQuotaExceededFault(inner)
                }
                crate::error::CopyOptionGroupErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateCustomAvailabilityZoneError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateCustomAvailabilityZoneError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateCustomAvailabilityZoneErrorKind::CustomAvailabilityZoneAlreadyExistsFault(inner) => Error::CustomAvailabilityZoneAlreadyExistsFault(inner),
                crate::error::CreateCustomAvailabilityZoneErrorKind::CustomAvailabilityZoneQuotaExceededFault(inner) => Error::CustomAvailabilityZoneQuotaExceededFault(inner),
                crate::error::CreateCustomAvailabilityZoneErrorKind::KmsKeyNotAccessibleFault(inner) => Error::KmsKeyNotAccessibleFault(inner),
                crate::error::CreateCustomAvailabilityZoneErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateCustomDBEngineVersionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateCustomDBEngineVersionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateCustomDBEngineVersionErrorKind::CustomDbEngineVersionAlreadyExistsFault(inner) => Error::CustomDbEngineVersionAlreadyExistsFault(inner),
                crate::error::CreateCustomDBEngineVersionErrorKind::CustomDbEngineVersionQuotaExceededFault(inner) => Error::CustomDbEngineVersionQuotaExceededFault(inner),
                crate::error::CreateCustomDBEngineVersionErrorKind::KmsKeyNotAccessibleFault(inner) => Error::KmsKeyNotAccessibleFault(inner),
                crate::error::CreateCustomDBEngineVersionErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateDBClusterError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::CreateDBClusterError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateDBClusterErrorKind::DbClusterAlreadyExistsFault(inner) => {
                    Error::DbClusterAlreadyExistsFault(inner)
                }
                crate::error::CreateDBClusterErrorKind::DbClusterNotFoundFault(inner) => {
                    Error::DbClusterNotFoundFault(inner)
                }
                crate::error::CreateDBClusterErrorKind::DbClusterParameterGroupNotFoundFault(
                    inner,
                ) => Error::DbClusterParameterGroupNotFoundFault(inner),
                crate::error::CreateDBClusterErrorKind::DbClusterQuotaExceededFault(inner) => {
                    Error::DbClusterQuotaExceededFault(inner)
                }
                crate::error::CreateDBClusterErrorKind::DbInstanceNotFoundFault(inner) => {
                    Error::DbInstanceNotFoundFault(inner)
                }
                crate::error::CreateDBClusterErrorKind::DbSubnetGroupDoesNotCoverEnoughAZs(
                    inner,
                ) => Error::DbSubnetGroupDoesNotCoverEnoughAZs(inner),
                crate::error::CreateDBClusterErrorKind::DbSubnetGroupNotFoundFault(inner) => {
                    Error::DbSubnetGroupNotFoundFault(inner)
                }
                crate::error::CreateDBClusterErrorKind::DomainNotFoundFault(inner) => {
                    Error::DomainNotFoundFault(inner)
                }
                crate::error::CreateDBClusterErrorKind::GlobalClusterNotFoundFault(inner) => {
                    Error::GlobalClusterNotFoundFault(inner)
                }
                crate::error::CreateDBClusterErrorKind::InsufficientStorageClusterCapacityFault(
                    inner,
                ) => Error::InsufficientStorageClusterCapacityFault(inner),
                crate::error::CreateDBClusterErrorKind::InvalidDbClusterStateFault(inner) => {
                    Error::InvalidDbClusterStateFault(inner)
                }
                crate::error::CreateDBClusterErrorKind::InvalidDbInstanceStateFault(inner) => {
                    Error::InvalidDbInstanceStateFault(inner)
                }
                crate::error::CreateDBClusterErrorKind::InvalidDbSubnetGroupStateFault(inner) => {
                    Error::InvalidDbSubnetGroupStateFault(inner)
                }
                crate::error::CreateDBClusterErrorKind::InvalidGlobalClusterStateFault(inner) => {
                    Error::InvalidGlobalClusterStateFault(inner)
                }
                crate::error::CreateDBClusterErrorKind::InvalidSubnet(inner) => {
                    Error::InvalidSubnet(inner)
                }
                crate::error::CreateDBClusterErrorKind::InvalidVpcNetworkStateFault(inner) => {
                    Error::InvalidVpcNetworkStateFault(inner)
                }
                crate::error::CreateDBClusterErrorKind::KmsKeyNotAccessibleFault(inner) => {
                    Error::KmsKeyNotAccessibleFault(inner)
                }
                crate::error::CreateDBClusterErrorKind::StorageQuotaExceededFault(inner) => {
                    Error::StorageQuotaExceededFault(inner)
                }
                crate::error::CreateDBClusterErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateDBClusterEndpointError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateDBClusterEndpointError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateDBClusterEndpointErrorKind::DbClusterEndpointAlreadyExistsFault(inner) => Error::DbClusterEndpointAlreadyExistsFault(inner),
                crate::error::CreateDBClusterEndpointErrorKind::DbClusterEndpointQuotaExceededFault(inner) => Error::DbClusterEndpointQuotaExceededFault(inner),
                crate::error::CreateDBClusterEndpointErrorKind::DbClusterNotFoundFault(inner) => Error::DbClusterNotFoundFault(inner),
                crate::error::CreateDBClusterEndpointErrorKind::DbInstanceNotFoundFault(inner) => Error::DbInstanceNotFoundFault(inner),
                crate::error::CreateDBClusterEndpointErrorKind::InvalidDbClusterStateFault(inner) => Error::InvalidDbClusterStateFault(inner),
                crate::error::CreateDBClusterEndpointErrorKind::InvalidDbInstanceStateFault(inner) => Error::InvalidDbInstanceStateFault(inner),
                crate::error::CreateDBClusterEndpointErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateDBClusterParameterGroupError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateDBClusterParameterGroupError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateDBClusterParameterGroupErrorKind::DbParameterGroupAlreadyExistsFault(inner) => Error::DbParameterGroupAlreadyExistsFault(inner),
                crate::error::CreateDBClusterParameterGroupErrorKind::DbParameterGroupQuotaExceededFault(inner) => Error::DbParameterGroupQuotaExceededFault(inner),
                crate::error::CreateDBClusterParameterGroupErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateDBClusterSnapshotError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateDBClusterSnapshotError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateDBClusterSnapshotErrorKind::DbClusterNotFoundFault(inner) => Error::DbClusterNotFoundFault(inner),
                crate::error::CreateDBClusterSnapshotErrorKind::DbClusterSnapshotAlreadyExistsFault(inner) => Error::DbClusterSnapshotAlreadyExistsFault(inner),
                crate::error::CreateDBClusterSnapshotErrorKind::InvalidDbClusterSnapshotStateFault(inner) => Error::InvalidDbClusterSnapshotStateFault(inner),
                crate::error::CreateDBClusterSnapshotErrorKind::InvalidDbClusterStateFault(inner) => Error::InvalidDbClusterStateFault(inner),
                crate::error::CreateDBClusterSnapshotErrorKind::SnapshotQuotaExceededFault(inner) => Error::SnapshotQuotaExceededFault(inner),
                crate::error::CreateDBClusterSnapshotErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateDBInstanceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateDBInstanceError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateDBInstanceErrorKind::AuthorizationNotFoundFault(inner) => {
                    Error::AuthorizationNotFoundFault(inner)
                }
                crate::error::CreateDBInstanceErrorKind::BackupPolicyNotFoundFault(inner) => {
                    Error::BackupPolicyNotFoundFault(inner)
                }
                crate::error::CreateDBInstanceErrorKind::DbClusterNotFoundFault(inner) => {
                    Error::DbClusterNotFoundFault(inner)
                }
                crate::error::CreateDBInstanceErrorKind::DbInstanceAlreadyExistsFault(inner) => {
                    Error::DbInstanceAlreadyExistsFault(inner)
                }
                crate::error::CreateDBInstanceErrorKind::DbParameterGroupNotFoundFault(inner) => {
                    Error::DbParameterGroupNotFoundFault(inner)
                }
                crate::error::CreateDBInstanceErrorKind::DbSecurityGroupNotFoundFault(inner) => {
                    Error::DbSecurityGroupNotFoundFault(inner)
                }
                crate::error::CreateDBInstanceErrorKind::DbSubnetGroupDoesNotCoverEnoughAZs(
                    inner,
                ) => Error::DbSubnetGroupDoesNotCoverEnoughAZs(inner),
                crate::error::CreateDBInstanceErrorKind::DbSubnetGroupNotFoundFault(inner) => {
                    Error::DbSubnetGroupNotFoundFault(inner)
                }
                crate::error::CreateDBInstanceErrorKind::DomainNotFoundFault(inner) => {
                    Error::DomainNotFoundFault(inner)
                }
                crate::error::CreateDBInstanceErrorKind::InstanceQuotaExceededFault(inner) => {
                    Error::InstanceQuotaExceededFault(inner)
                }
                crate::error::CreateDBInstanceErrorKind::InsufficientDbInstanceCapacityFault(
                    inner,
                ) => Error::InsufficientDbInstanceCapacityFault(inner),
                crate::error::CreateDBInstanceErrorKind::InvalidDbClusterStateFault(inner) => {
                    Error::InvalidDbClusterStateFault(inner)
                }
                crate::error::CreateDBInstanceErrorKind::InvalidSubnet(inner) => {
                    Error::InvalidSubnet(inner)
                }
                crate::error::CreateDBInstanceErrorKind::InvalidVpcNetworkStateFault(inner) => {
                    Error::InvalidVpcNetworkStateFault(inner)
                }
                crate::error::CreateDBInstanceErrorKind::KmsKeyNotAccessibleFault(inner) => {
                    Error::KmsKeyNotAccessibleFault(inner)
                }
                crate::error::CreateDBInstanceErrorKind::OptionGroupNotFoundFault(inner) => {
                    Error::OptionGroupNotFoundFault(inner)
                }
                crate::error::CreateDBInstanceErrorKind::ProvisionedIopsNotAvailableInAzFault(
                    inner,
                ) => Error::ProvisionedIopsNotAvailableInAzFault(inner),
                crate::error::CreateDBInstanceErrorKind::StorageQuotaExceededFault(inner) => {
                    Error::StorageQuotaExceededFault(inner)
                }
                crate::error::CreateDBInstanceErrorKind::StorageTypeNotSupportedFault(inner) => {
                    Error::StorageTypeNotSupportedFault(inner)
                }
                crate::error::CreateDBInstanceErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateDBInstanceReadReplicaError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateDBInstanceReadReplicaError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateDBInstanceReadReplicaErrorKind::DbInstanceAlreadyExistsFault(inner) => Error::DbInstanceAlreadyExistsFault(inner),
                crate::error::CreateDBInstanceReadReplicaErrorKind::DbInstanceNotFoundFault(inner) => Error::DbInstanceNotFoundFault(inner),
                crate::error::CreateDBInstanceReadReplicaErrorKind::DbParameterGroupNotFoundFault(inner) => Error::DbParameterGroupNotFoundFault(inner),
                crate::error::CreateDBInstanceReadReplicaErrorKind::DbSecurityGroupNotFoundFault(inner) => Error::DbSecurityGroupNotFoundFault(inner),
                crate::error::CreateDBInstanceReadReplicaErrorKind::DbSubnetGroupDoesNotCoverEnoughAZs(inner) => Error::DbSubnetGroupDoesNotCoverEnoughAZs(inner),
                crate::error::CreateDBInstanceReadReplicaErrorKind::DbSubnetGroupNotAllowedFault(inner) => Error::DbSubnetGroupNotAllowedFault(inner),
                crate::error::CreateDBInstanceReadReplicaErrorKind::DbSubnetGroupNotFoundFault(inner) => Error::DbSubnetGroupNotFoundFault(inner),
                crate::error::CreateDBInstanceReadReplicaErrorKind::DomainNotFoundFault(inner) => Error::DomainNotFoundFault(inner),
                crate::error::CreateDBInstanceReadReplicaErrorKind::InstanceQuotaExceededFault(inner) => Error::InstanceQuotaExceededFault(inner),
                crate::error::CreateDBInstanceReadReplicaErrorKind::InsufficientDbInstanceCapacityFault(inner) => Error::InsufficientDbInstanceCapacityFault(inner),
                crate::error::CreateDBInstanceReadReplicaErrorKind::InvalidDbInstanceStateFault(inner) => Error::InvalidDbInstanceStateFault(inner),
                crate::error::CreateDBInstanceReadReplicaErrorKind::InvalidDbSubnetGroupFault(inner) => Error::InvalidDbSubnetGroupFault(inner),
                crate::error::CreateDBInstanceReadReplicaErrorKind::InvalidSubnet(inner) => Error::InvalidSubnet(inner),
                crate::error::CreateDBInstanceReadReplicaErrorKind::InvalidVpcNetworkStateFault(inner) => Error::InvalidVpcNetworkStateFault(inner),
                crate::error::CreateDBInstanceReadReplicaErrorKind::KmsKeyNotAccessibleFault(inner) => Error::KmsKeyNotAccessibleFault(inner),
                crate::error::CreateDBInstanceReadReplicaErrorKind::OptionGroupNotFoundFault(inner) => Error::OptionGroupNotFoundFault(inner),
                crate::error::CreateDBInstanceReadReplicaErrorKind::ProvisionedIopsNotAvailableInAzFault(inner) => Error::ProvisionedIopsNotAvailableInAzFault(inner),
                crate::error::CreateDBInstanceReadReplicaErrorKind::StorageQuotaExceededFault(inner) => Error::StorageQuotaExceededFault(inner),
                crate::error::CreateDBInstanceReadReplicaErrorKind::StorageTypeNotSupportedFault(inner) => Error::StorageTypeNotSupportedFault(inner),
                crate::error::CreateDBInstanceReadReplicaErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateDBParameterGroupError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateDBParameterGroupError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateDBParameterGroupErrorKind::DbParameterGroupAlreadyExistsFault(inner) => Error::DbParameterGroupAlreadyExistsFault(inner),
                crate::error::CreateDBParameterGroupErrorKind::DbParameterGroupQuotaExceededFault(inner) => Error::DbParameterGroupQuotaExceededFault(inner),
                crate::error::CreateDBParameterGroupErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateDBProxyError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::CreateDBProxyError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateDBProxyErrorKind::DbProxyAlreadyExistsFault(inner) => {
                    Error::DbProxyAlreadyExistsFault(inner)
                }
                crate::error::CreateDBProxyErrorKind::DbProxyQuotaExceededFault(inner) => {
                    Error::DbProxyQuotaExceededFault(inner)
                }
                crate::error::CreateDBProxyErrorKind::InvalidSubnet(inner) => {
                    Error::InvalidSubnet(inner)
                }
                crate::error::CreateDBProxyErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateDBProxyEndpointError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateDBProxyEndpointError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateDBProxyEndpointErrorKind::DbProxyEndpointAlreadyExistsFault(
                    inner,
                ) => Error::DbProxyEndpointAlreadyExistsFault(inner),
                crate::error::CreateDBProxyEndpointErrorKind::DbProxyEndpointQuotaExceededFault(
                    inner,
                ) => Error::DbProxyEndpointQuotaExceededFault(inner),
                crate::error::CreateDBProxyEndpointErrorKind::DbProxyNotFoundFault(inner) => {
                    Error::DbProxyNotFoundFault(inner)
                }
                crate::error::CreateDBProxyEndpointErrorKind::InvalidDbProxyStateFault(inner) => {
                    Error::InvalidDbProxyStateFault(inner)
                }
                crate::error::CreateDBProxyEndpointErrorKind::InvalidSubnet(inner) => {
                    Error::InvalidSubnet(inner)
                }
                crate::error::CreateDBProxyEndpointErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateDBSecurityGroupError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateDBSecurityGroupError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateDBSecurityGroupErrorKind::DbSecurityGroupAlreadyExistsFault(
                    inner,
                ) => Error::DbSecurityGroupAlreadyExistsFault(inner),
                crate::error::CreateDBSecurityGroupErrorKind::DbSecurityGroupNotSupportedFault(
                    inner,
                ) => Error::DbSecurityGroupNotSupportedFault(inner),
                crate::error::CreateDBSecurityGroupErrorKind::DbSecurityGroupQuotaExceededFault(
                    inner,
                ) => Error::DbSecurityGroupQuotaExceededFault(inner),
                crate::error::CreateDBSecurityGroupErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateDBSnapshotError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateDBSnapshotError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateDBSnapshotErrorKind::DbInstanceNotFoundFault(inner) => {
                    Error::DbInstanceNotFoundFault(inner)
                }
                crate::error::CreateDBSnapshotErrorKind::DbSnapshotAlreadyExistsFault(inner) => {
                    Error::DbSnapshotAlreadyExistsFault(inner)
                }
                crate::error::CreateDBSnapshotErrorKind::InvalidDbInstanceStateFault(inner) => {
                    Error::InvalidDbInstanceStateFault(inner)
                }
                crate::error::CreateDBSnapshotErrorKind::SnapshotQuotaExceededFault(inner) => {
                    Error::SnapshotQuotaExceededFault(inner)
                }
                crate::error::CreateDBSnapshotErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateDBSubnetGroupError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateDBSubnetGroupError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateDBSubnetGroupErrorKind::DbSubnetGroupAlreadyExistsFault(
                    inner,
                ) => Error::DbSubnetGroupAlreadyExistsFault(inner),
                crate::error::CreateDBSubnetGroupErrorKind::DbSubnetGroupDoesNotCoverEnoughAZs(
                    inner,
                ) => Error::DbSubnetGroupDoesNotCoverEnoughAZs(inner),
                crate::error::CreateDBSubnetGroupErrorKind::DbSubnetGroupQuotaExceededFault(
                    inner,
                ) => Error::DbSubnetGroupQuotaExceededFault(inner),
                crate::error::CreateDBSubnetGroupErrorKind::DbSubnetQuotaExceededFault(inner) => {
                    Error::DbSubnetQuotaExceededFault(inner)
                }
                crate::error::CreateDBSubnetGroupErrorKind::InvalidSubnet(inner) => {
                    Error::InvalidSubnet(inner)
                }
                crate::error::CreateDBSubnetGroupErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateEventSubscriptionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateEventSubscriptionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::CreateEventSubscriptionErrorKind::EventSubscriptionQuotaExceededFault(inner) => Error::EventSubscriptionQuotaExceededFault(inner),
                crate::error::CreateEventSubscriptionErrorKind::SnsInvalidTopicFault(inner) => Error::SnsInvalidTopicFault(inner),
                crate::error::CreateEventSubscriptionErrorKind::SnsNoAuthorizationFault(inner) => Error::SnsNoAuthorizationFault(inner),
                crate::error::CreateEventSubscriptionErrorKind::SnsTopicArnNotFoundFault(inner) => Error::SnsTopicArnNotFoundFault(inner),
                crate::error::CreateEventSubscriptionErrorKind::SourceNotFoundFault(inner) => Error::SourceNotFoundFault(inner),
                crate::error::CreateEventSubscriptionErrorKind::SubscriptionAlreadyExistFault(inner) => Error::SubscriptionAlreadyExistFault(inner),
                crate::error::CreateEventSubscriptionErrorKind::SubscriptionCategoryNotFoundFault(inner) => Error::SubscriptionCategoryNotFoundFault(inner),
                crate::error::CreateEventSubscriptionErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateGlobalClusterError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateGlobalClusterError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateGlobalClusterErrorKind::DbClusterNotFoundFault(inner) => {
                    Error::DbClusterNotFoundFault(inner)
                }
                crate::error::CreateGlobalClusterErrorKind::GlobalClusterAlreadyExistsFault(
                    inner,
                ) => Error::GlobalClusterAlreadyExistsFault(inner),
                crate::error::CreateGlobalClusterErrorKind::GlobalClusterQuotaExceededFault(
                    inner,
                ) => Error::GlobalClusterQuotaExceededFault(inner),
                crate::error::CreateGlobalClusterErrorKind::InvalidDbClusterStateFault(inner) => {
                    Error::InvalidDbClusterStateFault(inner)
                }
                crate::error::CreateGlobalClusterErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::CreateOptionGroupError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::CreateOptionGroupError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::CreateOptionGroupErrorKind::OptionGroupAlreadyExistsFault(inner) => {
                    Error::OptionGroupAlreadyExistsFault(inner)
                }
                crate::error::CreateOptionGroupErrorKind::OptionGroupQuotaExceededFault(inner) => {
                    Error::OptionGroupQuotaExceededFault(inner)
                }
                crate::error::CreateOptionGroupErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteCustomAvailabilityZoneError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteCustomAvailabilityZoneError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DeleteCustomAvailabilityZoneErrorKind::CustomAvailabilityZoneNotFoundFault(inner) => Error::CustomAvailabilityZoneNotFoundFault(inner),
                crate::error::DeleteCustomAvailabilityZoneErrorKind::KmsKeyNotAccessibleFault(inner) => Error::KmsKeyNotAccessibleFault(inner),
                crate::error::DeleteCustomAvailabilityZoneErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteCustomDBEngineVersionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteCustomDBEngineVersionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DeleteCustomDBEngineVersionErrorKind::CustomDbEngineVersionNotFoundFault(inner) => Error::CustomDbEngineVersionNotFoundFault(inner),
                crate::error::DeleteCustomDBEngineVersionErrorKind::InvalidCustomDbEngineVersionStateFault(inner) => Error::InvalidCustomDbEngineVersionStateFault(inner),
                crate::error::DeleteCustomDBEngineVersionErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteDBClusterError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DeleteDBClusterError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteDBClusterErrorKind::DbClusterNotFoundFault(inner) => {
                    Error::DbClusterNotFoundFault(inner)
                }
                crate::error::DeleteDBClusterErrorKind::DbClusterSnapshotAlreadyExistsFault(
                    inner,
                ) => Error::DbClusterSnapshotAlreadyExistsFault(inner),
                crate::error::DeleteDBClusterErrorKind::InvalidDbClusterSnapshotStateFault(
                    inner,
                ) => Error::InvalidDbClusterSnapshotStateFault(inner),
                crate::error::DeleteDBClusterErrorKind::InvalidDbClusterStateFault(inner) => {
                    Error::InvalidDbClusterStateFault(inner)
                }
                crate::error::DeleteDBClusterErrorKind::SnapshotQuotaExceededFault(inner) => {
                    Error::SnapshotQuotaExceededFault(inner)
                }
                crate::error::DeleteDBClusterErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteDBClusterEndpointError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteDBClusterEndpointError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DeleteDBClusterEndpointErrorKind::DbClusterEndpointNotFoundFault(inner) => Error::DbClusterEndpointNotFoundFault(inner),
                crate::error::DeleteDBClusterEndpointErrorKind::InvalidDbClusterEndpointStateFault(inner) => Error::InvalidDbClusterEndpointStateFault(inner),
                crate::error::DeleteDBClusterEndpointErrorKind::InvalidDbClusterStateFault(inner) => Error::InvalidDbClusterStateFault(inner),
                crate::error::DeleteDBClusterEndpointErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteDBClusterParameterGroupError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteDBClusterParameterGroupError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DeleteDBClusterParameterGroupErrorKind::DbParameterGroupNotFoundFault(inner) => Error::DbParameterGroupNotFoundFault(inner),
                crate::error::DeleteDBClusterParameterGroupErrorKind::InvalidDbParameterGroupStateFault(inner) => Error::InvalidDbParameterGroupStateFault(inner),
                crate::error::DeleteDBClusterParameterGroupErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteDBClusterSnapshotError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteDBClusterSnapshotError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DeleteDBClusterSnapshotErrorKind::DbClusterSnapshotNotFoundFault(inner) => Error::DbClusterSnapshotNotFoundFault(inner),
                crate::error::DeleteDBClusterSnapshotErrorKind::InvalidDbClusterSnapshotStateFault(inner) => Error::InvalidDbClusterSnapshotStateFault(inner),
                crate::error::DeleteDBClusterSnapshotErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteDBInstanceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteDBInstanceError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DeleteDBInstanceErrorKind::DbInstanceAutomatedBackupQuotaExceededFault(inner) => Error::DbInstanceAutomatedBackupQuotaExceededFault(inner),
                crate::error::DeleteDBInstanceErrorKind::DbInstanceNotFoundFault(inner) => Error::DbInstanceNotFoundFault(inner),
                crate::error::DeleteDBInstanceErrorKind::DbSnapshotAlreadyExistsFault(inner) => Error::DbSnapshotAlreadyExistsFault(inner),
                crate::error::DeleteDBInstanceErrorKind::InvalidDbClusterStateFault(inner) => Error::InvalidDbClusterStateFault(inner),
                crate::error::DeleteDBInstanceErrorKind::InvalidDbInstanceStateFault(inner) => Error::InvalidDbInstanceStateFault(inner),
                crate::error::DeleteDBInstanceErrorKind::SnapshotQuotaExceededFault(inner) => Error::SnapshotQuotaExceededFault(inner),
                crate::error::DeleteDBInstanceErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::DeleteDBInstanceAutomatedBackupError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DeleteDBInstanceAutomatedBackupError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DeleteDBInstanceAutomatedBackupErrorKind::DbInstanceAutomatedBackupNotFoundFault(inner) => Error::DbInstanceAutomatedBackupNotFoundFault(inner),
                crate::error::DeleteDBInstanceAutomatedBackupErrorKind::InvalidDbInstanceAutomatedBackupStateFault(inner) => Error::InvalidDbInstanceAutomatedBackupStateFault(inner),
                crate::error::DeleteDBInstanceAutomatedBackupErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteDBParameterGroupError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteDBParameterGroupError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DeleteDBParameterGroupErrorKind::DbParameterGroupNotFoundFault(inner) => Error::DbParameterGroupNotFoundFault(inner),
                crate::error::DeleteDBParameterGroupErrorKind::InvalidDbParameterGroupStateFault(inner) => Error::InvalidDbParameterGroupStateFault(inner),
                crate::error::DeleteDBParameterGroupErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteDBProxyError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DeleteDBProxyError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteDBProxyErrorKind::DbProxyNotFoundFault(inner) => {
                    Error::DbProxyNotFoundFault(inner)
                }
                crate::error::DeleteDBProxyErrorKind::InvalidDbProxyStateFault(inner) => {
                    Error::InvalidDbProxyStateFault(inner)
                }
                crate::error::DeleteDBProxyErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteDBProxyEndpointError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteDBProxyEndpointError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteDBProxyEndpointErrorKind::DbProxyEndpointNotFoundFault(
                    inner,
                ) => Error::DbProxyEndpointNotFoundFault(inner),
                crate::error::DeleteDBProxyEndpointErrorKind::InvalidDbProxyEndpointStateFault(
                    inner,
                ) => Error::InvalidDbProxyEndpointStateFault(inner),
                crate::error::DeleteDBProxyEndpointErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteDBSecurityGroupError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteDBSecurityGroupError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteDBSecurityGroupErrorKind::DbSecurityGroupNotFoundFault(
                    inner,
                ) => Error::DbSecurityGroupNotFoundFault(inner),
                crate::error::DeleteDBSecurityGroupErrorKind::InvalidDbSecurityGroupStateFault(
                    inner,
                ) => Error::InvalidDbSecurityGroupStateFault(inner),
                crate::error::DeleteDBSecurityGroupErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteDBSnapshotError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteDBSnapshotError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteDBSnapshotErrorKind::DbSnapshotNotFoundFault(inner) => {
                    Error::DbSnapshotNotFoundFault(inner)
                }
                crate::error::DeleteDBSnapshotErrorKind::InvalidDbSnapshotStateFault(inner) => {
                    Error::InvalidDbSnapshotStateFault(inner)
                }
                crate::error::DeleteDBSnapshotErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteDBSubnetGroupError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteDBSubnetGroupError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteDBSubnetGroupErrorKind::DbSubnetGroupNotFoundFault(inner) => {
                    Error::DbSubnetGroupNotFoundFault(inner)
                }
                crate::error::DeleteDBSubnetGroupErrorKind::InvalidDbSubnetGroupStateFault(
                    inner,
                ) => Error::InvalidDbSubnetGroupStateFault(inner),
                crate::error::DeleteDBSubnetGroupErrorKind::InvalidDbSubnetStateFault(inner) => {
                    Error::InvalidDbSubnetStateFault(inner)
                }
                crate::error::DeleteDBSubnetGroupErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteEventSubscriptionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteEventSubscriptionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DeleteEventSubscriptionErrorKind::InvalidEventSubscriptionStateFault(inner) => Error::InvalidEventSubscriptionStateFault(inner),
                crate::error::DeleteEventSubscriptionErrorKind::SubscriptionNotFoundFault(inner) => Error::SubscriptionNotFoundFault(inner),
                crate::error::DeleteEventSubscriptionErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteGlobalClusterError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteGlobalClusterError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteGlobalClusterErrorKind::GlobalClusterNotFoundFault(inner) => {
                    Error::GlobalClusterNotFoundFault(inner)
                }
                crate::error::DeleteGlobalClusterErrorKind::InvalidGlobalClusterStateFault(
                    inner,
                ) => Error::InvalidGlobalClusterStateFault(inner),
                crate::error::DeleteGlobalClusterErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteInstallationMediaError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteInstallationMediaError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteInstallationMediaErrorKind::InstallationMediaNotFoundFault(
                    inner,
                ) => Error::InstallationMediaNotFoundFault(inner),
                crate::error::DeleteInstallationMediaErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeleteOptionGroupError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeleteOptionGroupError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DeleteOptionGroupErrorKind::InvalidOptionGroupStateFault(inner) => {
                    Error::InvalidOptionGroupStateFault(inner)
                }
                crate::error::DeleteOptionGroupErrorKind::OptionGroupNotFoundFault(inner) => {
                    Error::OptionGroupNotFoundFault(inner)
                }
                crate::error::DeleteOptionGroupErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DeregisterDBProxyTargetsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DeregisterDBProxyTargetsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DeregisterDBProxyTargetsErrorKind::DbProxyNotFoundFault(inner) => Error::DbProxyNotFoundFault(inner),
                crate::error::DeregisterDBProxyTargetsErrorKind::DbProxyTargetGroupNotFoundFault(inner) => Error::DbProxyTargetGroupNotFoundFault(inner),
                crate::error::DeregisterDBProxyTargetsErrorKind::DbProxyTargetNotFoundFault(inner) => Error::DbProxyTargetNotFoundFault(inner),
                crate::error::DeregisterDBProxyTargetsErrorKind::InvalidDbProxyStateFault(inner) => Error::InvalidDbProxyStateFault(inner),
                crate::error::DeregisterDBProxyTargetsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeAccountAttributesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeAccountAttributesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeAccountAttributesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeCertificatesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeCertificatesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeCertificatesErrorKind::CertificateNotFoundFault(inner) => {
                    Error::CertificateNotFoundFault(inner)
                }
                crate::error::DescribeCertificatesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::DescribeCustomAvailabilityZonesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DescribeCustomAvailabilityZonesError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeCustomAvailabilityZonesErrorKind::CustomAvailabilityZoneNotFoundFault(inner) => Error::CustomAvailabilityZoneNotFoundFault(inner),
                crate::error::DescribeCustomAvailabilityZonesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeDBClusterBacktracksError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeDBClusterBacktracksError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeDBClusterBacktracksErrorKind::DbClusterBacktrackNotFoundFault(inner) => Error::DbClusterBacktrackNotFoundFault(inner),
                crate::error::DescribeDBClusterBacktracksErrorKind::DbClusterNotFoundFault(inner) => Error::DbClusterNotFoundFault(inner),
                crate::error::DescribeDBClusterBacktracksErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeDBClusterEndpointsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeDBClusterEndpointsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeDBClusterEndpointsErrorKind::DbClusterNotFoundFault(
                    inner,
                ) => Error::DbClusterNotFoundFault(inner),
                crate::error::DescribeDBClusterEndpointsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::DescribeDBClusterParameterGroupsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DescribeDBClusterParameterGroupsError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeDBClusterParameterGroupsErrorKind::DbParameterGroupNotFoundFault(inner) => Error::DbParameterGroupNotFoundFault(inner),
                crate::error::DescribeDBClusterParameterGroupsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeDBClusterParametersError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeDBClusterParametersError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeDBClusterParametersErrorKind::DbParameterGroupNotFoundFault(inner) => Error::DbParameterGroupNotFoundFault(inner),
                crate::error::DescribeDBClusterParametersErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeDBClustersError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeDBClustersError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeDBClustersErrorKind::DbClusterNotFoundFault(inner) => {
                    Error::DbClusterNotFoundFault(inner)
                }
                crate::error::DescribeDBClustersErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::DescribeDBClusterSnapshotAttributesError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DescribeDBClusterSnapshotAttributesError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeDBClusterSnapshotAttributesErrorKind::DbClusterSnapshotNotFoundFault(inner) => Error::DbClusterSnapshotNotFoundFault(inner),
                crate::error::DescribeDBClusterSnapshotAttributesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeDBClusterSnapshotsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeDBClusterSnapshotsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeDBClusterSnapshotsErrorKind::DbClusterSnapshotNotFoundFault(inner) => Error::DbClusterSnapshotNotFoundFault(inner),
                crate::error::DescribeDBClusterSnapshotsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeDBEngineVersionsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeDBEngineVersionsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeDBEngineVersionsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<crate::error::DescribeDBInstanceAutomatedBackupsError, R>,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DescribeDBInstanceAutomatedBackupsError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeDBInstanceAutomatedBackupsErrorKind::DbInstanceAutomatedBackupNotFoundFault(inner) => Error::DbInstanceAutomatedBackupNotFoundFault(inner),
                crate::error::DescribeDBInstanceAutomatedBackupsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeDBInstancesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeDBInstancesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeDBInstancesErrorKind::DbInstanceNotFoundFault(inner) => {
                    Error::DbInstanceNotFoundFault(inner)
                }
                crate::error::DescribeDBInstancesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeDBLogFilesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeDBLogFilesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeDBLogFilesErrorKind::DbInstanceNotFoundFault(inner) => {
                    Error::DbInstanceNotFoundFault(inner)
                }
                crate::error::DescribeDBLogFilesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeDBParameterGroupsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeDBParameterGroupsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeDBParameterGroupsErrorKind::DbParameterGroupNotFoundFault(
                    inner,
                ) => Error::DbParameterGroupNotFoundFault(inner),
                crate::error::DescribeDBParameterGroupsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeDBParametersError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeDBParametersError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeDBParametersErrorKind::DbParameterGroupNotFoundFault(
                    inner,
                ) => Error::DbParameterGroupNotFoundFault(inner),
                crate::error::DescribeDBParametersErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeDBProxiesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeDBProxiesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeDBProxiesErrorKind::DbProxyNotFoundFault(inner) => {
                    Error::DbProxyNotFoundFault(inner)
                }
                crate::error::DescribeDBProxiesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeDBProxyEndpointsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeDBProxyEndpointsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeDBProxyEndpointsErrorKind::DbProxyEndpointNotFoundFault(
                    inner,
                ) => Error::DbProxyEndpointNotFoundFault(inner),
                crate::error::DescribeDBProxyEndpointsErrorKind::DbProxyNotFoundFault(inner) => {
                    Error::DbProxyNotFoundFault(inner)
                }
                crate::error::DescribeDBProxyEndpointsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeDBProxyTargetGroupsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeDBProxyTargetGroupsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeDBProxyTargetGroupsErrorKind::DbProxyNotFoundFault(inner) => Error::DbProxyNotFoundFault(inner),
                crate::error::DescribeDBProxyTargetGroupsErrorKind::DbProxyTargetGroupNotFoundFault(inner) => Error::DbProxyTargetGroupNotFoundFault(inner),
                crate::error::DescribeDBProxyTargetGroupsErrorKind::InvalidDbProxyStateFault(inner) => Error::InvalidDbProxyStateFault(inner),
                crate::error::DescribeDBProxyTargetGroupsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeDBProxyTargetsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeDBProxyTargetsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeDBProxyTargetsErrorKind::DbProxyNotFoundFault(inner) => {
                    Error::DbProxyNotFoundFault(inner)
                }
                crate::error::DescribeDBProxyTargetsErrorKind::DbProxyTargetGroupNotFoundFault(
                    inner,
                ) => Error::DbProxyTargetGroupNotFoundFault(inner),
                crate::error::DescribeDBProxyTargetsErrorKind::DbProxyTargetNotFoundFault(
                    inner,
                ) => Error::DbProxyTargetNotFoundFault(inner),
                crate::error::DescribeDBProxyTargetsErrorKind::InvalidDbProxyStateFault(inner) => {
                    Error::InvalidDbProxyStateFault(inner)
                }
                crate::error::DescribeDBProxyTargetsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeDBSecurityGroupsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeDBSecurityGroupsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeDBSecurityGroupsErrorKind::DbSecurityGroupNotFoundFault(
                    inner,
                ) => Error::DbSecurityGroupNotFoundFault(inner),
                crate::error::DescribeDBSecurityGroupsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeDBSnapshotAttributesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeDBSnapshotAttributesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeDBSnapshotAttributesErrorKind::DbSnapshotNotFoundFault(
                    inner,
                ) => Error::DbSnapshotNotFoundFault(inner),
                crate::error::DescribeDBSnapshotAttributesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeDBSnapshotsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeDBSnapshotsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeDBSnapshotsErrorKind::DbSnapshotNotFoundFault(inner) => {
                    Error::DbSnapshotNotFoundFault(inner)
                }
                crate::error::DescribeDBSnapshotsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeDBSubnetGroupsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeDBSubnetGroupsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeDBSubnetGroupsErrorKind::DbSubnetGroupNotFoundFault(
                    inner,
                ) => Error::DbSubnetGroupNotFoundFault(inner),
                crate::error::DescribeDBSubnetGroupsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::DescribeEngineDefaultClusterParametersError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DescribeEngineDefaultClusterParametersError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeEngineDefaultClusterParametersErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::DescribeEngineDefaultParametersError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DescribeEngineDefaultParametersError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeEngineDefaultParametersErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeEventCategoriesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeEventCategoriesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeEventCategoriesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeEventsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::DescribeEventsError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeEventsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeEventSubscriptionsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeEventSubscriptionsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeEventSubscriptionsErrorKind::SubscriptionNotFoundFault(
                    inner,
                ) => Error::SubscriptionNotFoundFault(inner),
                crate::error::DescribeEventSubscriptionsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeExportTasksError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeExportTasksError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeExportTasksErrorKind::ExportTaskNotFoundFault(inner) => {
                    Error::ExportTaskNotFoundFault(inner)
                }
                crate::error::DescribeExportTasksErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeGlobalClustersError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeGlobalClustersError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeGlobalClustersErrorKind::GlobalClusterNotFoundFault(
                    inner,
                ) => Error::GlobalClusterNotFoundFault(inner),
                crate::error::DescribeGlobalClustersErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeInstallationMediaError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeInstallationMediaError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeInstallationMediaErrorKind::InstallationMediaNotFoundFault(inner) => Error::InstallationMediaNotFoundFault(inner),
                crate::error::DescribeInstallationMediaErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeOptionGroupOptionsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeOptionGroupOptionsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeOptionGroupOptionsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeOptionGroupsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeOptionGroupsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeOptionGroupsErrorKind::OptionGroupNotFoundFault(inner) => {
                    Error::OptionGroupNotFoundFault(inner)
                }
                crate::error::DescribeOptionGroupsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<crate::error::DescribeOrderableDBInstanceOptionsError, R>,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DescribeOrderableDBInstanceOptionsError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeOrderableDBInstanceOptionsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::DescribePendingMaintenanceActionsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DescribePendingMaintenanceActionsError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribePendingMaintenanceActionsErrorKind::ResourceNotFoundFault(
                    inner,
                ) => Error::ResourceNotFoundFault(inner),
                crate::error::DescribePendingMaintenanceActionsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeReservedDBInstancesError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeReservedDBInstancesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeReservedDBInstancesErrorKind::ReservedDbInstanceNotFoundFault(inner) => Error::ReservedDbInstanceNotFoundFault(inner),
                crate::error::DescribeReservedDBInstancesErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::DescribeReservedDBInstancesOfferingsError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DescribeReservedDBInstancesOfferingsError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeReservedDBInstancesOfferingsErrorKind::ReservedDbInstancesOfferingNotFoundFault(inner) => Error::ReservedDbInstancesOfferingNotFoundFault(inner),
                crate::error::DescribeReservedDBInstancesOfferingsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DescribeSourceRegionsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DescribeSourceRegionsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DescribeSourceRegionsErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::DescribeValidDBInstanceModificationsError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::DescribeValidDBInstanceModificationsError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::DescribeValidDBInstanceModificationsErrorKind::DbInstanceNotFoundFault(inner) => Error::DbInstanceNotFoundFault(inner),
                crate::error::DescribeValidDBInstanceModificationsErrorKind::InvalidDbInstanceStateFault(inner) => Error::InvalidDbInstanceStateFault(inner),
                crate::error::DescribeValidDBInstanceModificationsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::DownloadDBLogFilePortionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::DownloadDBLogFilePortionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::DownloadDBLogFilePortionErrorKind::DbInstanceNotFoundFault(inner) => {
                    Error::DbInstanceNotFoundFault(inner)
                }
                crate::error::DownloadDBLogFilePortionErrorKind::DbLogFileNotFoundFault(inner) => {
                    Error::DbLogFileNotFoundFault(inner)
                }
                crate::error::DownloadDBLogFilePortionErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::FailoverDBClusterError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::FailoverDBClusterError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::FailoverDBClusterErrorKind::DbClusterNotFoundFault(inner) => {
                    Error::DbClusterNotFoundFault(inner)
                }
                crate::error::FailoverDBClusterErrorKind::InvalidDbClusterStateFault(inner) => {
                    Error::InvalidDbClusterStateFault(inner)
                }
                crate::error::FailoverDBClusterErrorKind::InvalidDbInstanceStateFault(inner) => {
                    Error::InvalidDbInstanceStateFault(inner)
                }
                crate::error::FailoverDBClusterErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::FailoverGlobalClusterError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::FailoverGlobalClusterError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::FailoverGlobalClusterErrorKind::DbClusterNotFoundFault(inner) => {
                    Error::DbClusterNotFoundFault(inner)
                }
                crate::error::FailoverGlobalClusterErrorKind::GlobalClusterNotFoundFault(inner) => {
                    Error::GlobalClusterNotFoundFault(inner)
                }
                crate::error::FailoverGlobalClusterErrorKind::InvalidDbClusterStateFault(inner) => {
                    Error::InvalidDbClusterStateFault(inner)
                }
                crate::error::FailoverGlobalClusterErrorKind::InvalidGlobalClusterStateFault(
                    inner,
                ) => Error::InvalidGlobalClusterStateFault(inner),
                crate::error::FailoverGlobalClusterErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ImportInstallationMediaError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ImportInstallationMediaError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ImportInstallationMediaErrorKind::CustomAvailabilityZoneNotFoundFault(inner) => Error::CustomAvailabilityZoneNotFoundFault(inner),
                crate::error::ImportInstallationMediaErrorKind::InstallationMediaAlreadyExistsFault(inner) => Error::InstallationMediaAlreadyExistsFault(inner),
                crate::error::ImportInstallationMediaErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ListTagsForResourceErrorKind::DbClusterNotFoundFault(inner) => {
                    Error::DbClusterNotFoundFault(inner)
                }
                crate::error::ListTagsForResourceErrorKind::DbInstanceNotFoundFault(inner) => {
                    Error::DbInstanceNotFoundFault(inner)
                }
                crate::error::ListTagsForResourceErrorKind::DbProxyNotFoundFault(inner) => {
                    Error::DbProxyNotFoundFault(inner)
                }
                crate::error::ListTagsForResourceErrorKind::DbProxyTargetGroupNotFoundFault(
                    inner,
                ) => Error::DbProxyTargetGroupNotFoundFault(inner),
                crate::error::ListTagsForResourceErrorKind::DbSnapshotNotFoundFault(inner) => {
                    Error::DbSnapshotNotFoundFault(inner)
                }
                crate::error::ListTagsForResourceErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ModifyCertificatesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ModifyCertificatesError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ModifyCertificatesErrorKind::CertificateNotFoundFault(inner) => {
                    Error::CertificateNotFoundFault(inner)
                }
                crate::error::ModifyCertificatesErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::ModifyCurrentDBClusterCapacityError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::ModifyCurrentDBClusterCapacityError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ModifyCurrentDBClusterCapacityErrorKind::DbClusterNotFoundFault(inner) => Error::DbClusterNotFoundFault(inner),
                crate::error::ModifyCurrentDBClusterCapacityErrorKind::InvalidDbClusterCapacityFault(inner) => Error::InvalidDbClusterCapacityFault(inner),
                crate::error::ModifyCurrentDBClusterCapacityErrorKind::InvalidDbClusterStateFault(inner) => Error::InvalidDbClusterStateFault(inner),
                crate::error::ModifyCurrentDBClusterCapacityErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ModifyCustomDBEngineVersionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ModifyCustomDBEngineVersionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ModifyCustomDBEngineVersionErrorKind::CustomDbEngineVersionNotFoundFault(inner) => Error::CustomDbEngineVersionNotFoundFault(inner),
                crate::error::ModifyCustomDBEngineVersionErrorKind::InvalidCustomDbEngineVersionStateFault(inner) => Error::InvalidCustomDbEngineVersionStateFault(inner),
                crate::error::ModifyCustomDBEngineVersionErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ModifyDBClusterError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ModifyDBClusterError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ModifyDBClusterErrorKind::DbClusterAlreadyExistsFault(inner) => {
                    Error::DbClusterAlreadyExistsFault(inner)
                }
                crate::error::ModifyDBClusterErrorKind::DbClusterNotFoundFault(inner) => {
                    Error::DbClusterNotFoundFault(inner)
                }
                crate::error::ModifyDBClusterErrorKind::DbClusterParameterGroupNotFoundFault(
                    inner,
                ) => Error::DbClusterParameterGroupNotFoundFault(inner),
                crate::error::ModifyDBClusterErrorKind::DbSubnetGroupNotFoundFault(inner) => {
                    Error::DbSubnetGroupNotFoundFault(inner)
                }
                crate::error::ModifyDBClusterErrorKind::DomainNotFoundFault(inner) => {
                    Error::DomainNotFoundFault(inner)
                }
                crate::error::ModifyDBClusterErrorKind::InvalidDbClusterStateFault(inner) => {
                    Error::InvalidDbClusterStateFault(inner)
                }
                crate::error::ModifyDBClusterErrorKind::InvalidDbInstanceStateFault(inner) => {
                    Error::InvalidDbInstanceStateFault(inner)
                }
                crate::error::ModifyDBClusterErrorKind::InvalidDbSecurityGroupStateFault(inner) => {
                    Error::InvalidDbSecurityGroupStateFault(inner)
                }
                crate::error::ModifyDBClusterErrorKind::InvalidDbSubnetGroupStateFault(inner) => {
                    Error::InvalidDbSubnetGroupStateFault(inner)
                }
                crate::error::ModifyDBClusterErrorKind::InvalidSubnet(inner) => {
                    Error::InvalidSubnet(inner)
                }
                crate::error::ModifyDBClusterErrorKind::InvalidVpcNetworkStateFault(inner) => {
                    Error::InvalidVpcNetworkStateFault(inner)
                }
                crate::error::ModifyDBClusterErrorKind::StorageQuotaExceededFault(inner) => {
                    Error::StorageQuotaExceededFault(inner)
                }
                crate::error::ModifyDBClusterErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ModifyDBClusterEndpointError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ModifyDBClusterEndpointError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ModifyDBClusterEndpointErrorKind::DbClusterEndpointNotFoundFault(inner) => Error::DbClusterEndpointNotFoundFault(inner),
                crate::error::ModifyDBClusterEndpointErrorKind::DbInstanceNotFoundFault(inner) => Error::DbInstanceNotFoundFault(inner),
                crate::error::ModifyDBClusterEndpointErrorKind::InvalidDbClusterEndpointStateFault(inner) => Error::InvalidDbClusterEndpointStateFault(inner),
                crate::error::ModifyDBClusterEndpointErrorKind::InvalidDbClusterStateFault(inner) => Error::InvalidDbClusterStateFault(inner),
                crate::error::ModifyDBClusterEndpointErrorKind::InvalidDbInstanceStateFault(inner) => Error::InvalidDbInstanceStateFault(inner),
                crate::error::ModifyDBClusterEndpointErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ModifyDBClusterParameterGroupError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ModifyDBClusterParameterGroupError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ModifyDBClusterParameterGroupErrorKind::DbParameterGroupNotFoundFault(inner) => Error::DbParameterGroupNotFoundFault(inner),
                crate::error::ModifyDBClusterParameterGroupErrorKind::InvalidDbParameterGroupStateFault(inner) => Error::InvalidDbParameterGroupStateFault(inner),
                crate::error::ModifyDBClusterParameterGroupErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::ModifyDBClusterSnapshotAttributeError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::ModifyDBClusterSnapshotAttributeError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ModifyDBClusterSnapshotAttributeErrorKind::DbClusterSnapshotNotFoundFault(inner) => Error::DbClusterSnapshotNotFoundFault(inner),
                crate::error::ModifyDBClusterSnapshotAttributeErrorKind::InvalidDbClusterSnapshotStateFault(inner) => Error::InvalidDbClusterSnapshotStateFault(inner),
                crate::error::ModifyDBClusterSnapshotAttributeErrorKind::SharedSnapshotQuotaExceededFault(inner) => Error::SharedSnapshotQuotaExceededFault(inner),
                crate::error::ModifyDBClusterSnapshotAttributeErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ModifyDBInstanceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ModifyDBInstanceError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ModifyDBInstanceErrorKind::AuthorizationNotFoundFault(inner) => {
                    Error::AuthorizationNotFoundFault(inner)
                }
                crate::error::ModifyDBInstanceErrorKind::BackupPolicyNotFoundFault(inner) => {
                    Error::BackupPolicyNotFoundFault(inner)
                }
                crate::error::ModifyDBInstanceErrorKind::CertificateNotFoundFault(inner) => {
                    Error::CertificateNotFoundFault(inner)
                }
                crate::error::ModifyDBInstanceErrorKind::DbInstanceAlreadyExistsFault(inner) => {
                    Error::DbInstanceAlreadyExistsFault(inner)
                }
                crate::error::ModifyDBInstanceErrorKind::DbInstanceNotFoundFault(inner) => {
                    Error::DbInstanceNotFoundFault(inner)
                }
                crate::error::ModifyDBInstanceErrorKind::DbParameterGroupNotFoundFault(inner) => {
                    Error::DbParameterGroupNotFoundFault(inner)
                }
                crate::error::ModifyDBInstanceErrorKind::DbSecurityGroupNotFoundFault(inner) => {
                    Error::DbSecurityGroupNotFoundFault(inner)
                }
                crate::error::ModifyDBInstanceErrorKind::DbUpgradeDependencyFailureFault(inner) => {
                    Error::DbUpgradeDependencyFailureFault(inner)
                }
                crate::error::ModifyDBInstanceErrorKind::DomainNotFoundFault(inner) => {
                    Error::DomainNotFoundFault(inner)
                }
                crate::error::ModifyDBInstanceErrorKind::InsufficientDbInstanceCapacityFault(
                    inner,
                ) => Error::InsufficientDbInstanceCapacityFault(inner),
                crate::error::ModifyDBInstanceErrorKind::InvalidDbClusterStateFault(inner) => {
                    Error::InvalidDbClusterStateFault(inner)
                }
                crate::error::ModifyDBInstanceErrorKind::InvalidDbInstanceStateFault(inner) => {
                    Error::InvalidDbInstanceStateFault(inner)
                }
                crate::error::ModifyDBInstanceErrorKind::InvalidDbSecurityGroupStateFault(
                    inner,
                ) => Error::InvalidDbSecurityGroupStateFault(inner),
                crate::error::ModifyDBInstanceErrorKind::InvalidVpcNetworkStateFault(inner) => {
                    Error::InvalidVpcNetworkStateFault(inner)
                }
                crate::error::ModifyDBInstanceErrorKind::KmsKeyNotAccessibleFault(inner) => {
                    Error::KmsKeyNotAccessibleFault(inner)
                }
                crate::error::ModifyDBInstanceErrorKind::OptionGroupNotFoundFault(inner) => {
                    Error::OptionGroupNotFoundFault(inner)
                }
                crate::error::ModifyDBInstanceErrorKind::ProvisionedIopsNotAvailableInAzFault(
                    inner,
                ) => Error::ProvisionedIopsNotAvailableInAzFault(inner),
                crate::error::ModifyDBInstanceErrorKind::StorageQuotaExceededFault(inner) => {
                    Error::StorageQuotaExceededFault(inner)
                }
                crate::error::ModifyDBInstanceErrorKind::StorageTypeNotSupportedFault(inner) => {
                    Error::StorageTypeNotSupportedFault(inner)
                }
                crate::error::ModifyDBInstanceErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ModifyDBParameterGroupError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ModifyDBParameterGroupError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ModifyDBParameterGroupErrorKind::DbParameterGroupNotFoundFault(inner) => Error::DbParameterGroupNotFoundFault(inner),
                crate::error::ModifyDBParameterGroupErrorKind::InvalidDbParameterGroupStateFault(inner) => Error::InvalidDbParameterGroupStateFault(inner),
                crate::error::ModifyDBParameterGroupErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ModifyDBProxyError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::ModifyDBProxyError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ModifyDBProxyErrorKind::DbProxyAlreadyExistsFault(inner) => {
                    Error::DbProxyAlreadyExistsFault(inner)
                }
                crate::error::ModifyDBProxyErrorKind::DbProxyNotFoundFault(inner) => {
                    Error::DbProxyNotFoundFault(inner)
                }
                crate::error::ModifyDBProxyErrorKind::InvalidDbProxyStateFault(inner) => {
                    Error::InvalidDbProxyStateFault(inner)
                }
                crate::error::ModifyDBProxyErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ModifyDBProxyEndpointError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ModifyDBProxyEndpointError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ModifyDBProxyEndpointErrorKind::DbProxyEndpointAlreadyExistsFault(
                    inner,
                ) => Error::DbProxyEndpointAlreadyExistsFault(inner),
                crate::error::ModifyDBProxyEndpointErrorKind::DbProxyEndpointNotFoundFault(
                    inner,
                ) => Error::DbProxyEndpointNotFoundFault(inner),
                crate::error::ModifyDBProxyEndpointErrorKind::InvalidDbProxyEndpointStateFault(
                    inner,
                ) => Error::InvalidDbProxyEndpointStateFault(inner),
                crate::error::ModifyDBProxyEndpointErrorKind::InvalidDbProxyStateFault(inner) => {
                    Error::InvalidDbProxyStateFault(inner)
                }
                crate::error::ModifyDBProxyEndpointErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ModifyDBProxyTargetGroupError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ModifyDBProxyTargetGroupError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ModifyDBProxyTargetGroupErrorKind::DbProxyNotFoundFault(inner) => Error::DbProxyNotFoundFault(inner),
                crate::error::ModifyDBProxyTargetGroupErrorKind::DbProxyTargetGroupNotFoundFault(inner) => Error::DbProxyTargetGroupNotFoundFault(inner),
                crate::error::ModifyDBProxyTargetGroupErrorKind::InvalidDbProxyStateFault(inner) => Error::InvalidDbProxyStateFault(inner),
                crate::error::ModifyDBProxyTargetGroupErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ModifyDBSnapshotError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ModifyDBSnapshotError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ModifyDBSnapshotErrorKind::DbSnapshotNotFoundFault(inner) => {
                    Error::DbSnapshotNotFoundFault(inner)
                }
                crate::error::ModifyDBSnapshotErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ModifyDBSnapshotAttributeError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ModifyDBSnapshotAttributeError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ModifyDBSnapshotAttributeErrorKind::DbSnapshotNotFoundFault(inner) => Error::DbSnapshotNotFoundFault(inner),
                crate::error::ModifyDBSnapshotAttributeErrorKind::InvalidDbSnapshotStateFault(inner) => Error::InvalidDbSnapshotStateFault(inner),
                crate::error::ModifyDBSnapshotAttributeErrorKind::SharedSnapshotQuotaExceededFault(inner) => Error::SharedSnapshotQuotaExceededFault(inner),
                crate::error::ModifyDBSnapshotAttributeErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ModifyDBSubnetGroupError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ModifyDBSubnetGroupError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ModifyDBSubnetGroupErrorKind::DbSubnetGroupDoesNotCoverEnoughAZs(
                    inner,
                ) => Error::DbSubnetGroupDoesNotCoverEnoughAZs(inner),
                crate::error::ModifyDBSubnetGroupErrorKind::DbSubnetGroupNotFoundFault(inner) => {
                    Error::DbSubnetGroupNotFoundFault(inner)
                }
                crate::error::ModifyDBSubnetGroupErrorKind::DbSubnetQuotaExceededFault(inner) => {
                    Error::DbSubnetQuotaExceededFault(inner)
                }
                crate::error::ModifyDBSubnetGroupErrorKind::InvalidSubnet(inner) => {
                    Error::InvalidSubnet(inner)
                }
                crate::error::ModifyDBSubnetGroupErrorKind::SubnetAlreadyInUse(inner) => {
                    Error::SubnetAlreadyInUse(inner)
                }
                crate::error::ModifyDBSubnetGroupErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ModifyEventSubscriptionError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ModifyEventSubscriptionError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ModifyEventSubscriptionErrorKind::EventSubscriptionQuotaExceededFault(inner) => Error::EventSubscriptionQuotaExceededFault(inner),
                crate::error::ModifyEventSubscriptionErrorKind::SnsInvalidTopicFault(inner) => Error::SnsInvalidTopicFault(inner),
                crate::error::ModifyEventSubscriptionErrorKind::SnsNoAuthorizationFault(inner) => Error::SnsNoAuthorizationFault(inner),
                crate::error::ModifyEventSubscriptionErrorKind::SnsTopicArnNotFoundFault(inner) => Error::SnsTopicArnNotFoundFault(inner),
                crate::error::ModifyEventSubscriptionErrorKind::SubscriptionCategoryNotFoundFault(inner) => Error::SubscriptionCategoryNotFoundFault(inner),
                crate::error::ModifyEventSubscriptionErrorKind::SubscriptionNotFoundFault(inner) => Error::SubscriptionNotFoundFault(inner),
                crate::error::ModifyEventSubscriptionErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ModifyGlobalClusterError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ModifyGlobalClusterError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ModifyGlobalClusterErrorKind::GlobalClusterNotFoundFault(inner) => {
                    Error::GlobalClusterNotFoundFault(inner)
                }
                crate::error::ModifyGlobalClusterErrorKind::InvalidDbClusterStateFault(inner) => {
                    Error::InvalidDbClusterStateFault(inner)
                }
                crate::error::ModifyGlobalClusterErrorKind::InvalidDbInstanceStateFault(inner) => {
                    Error::InvalidDbInstanceStateFault(inner)
                }
                crate::error::ModifyGlobalClusterErrorKind::InvalidGlobalClusterStateFault(
                    inner,
                ) => Error::InvalidGlobalClusterStateFault(inner),
                crate::error::ModifyGlobalClusterErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ModifyOptionGroupError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ModifyOptionGroupError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ModifyOptionGroupErrorKind::InvalidOptionGroupStateFault(inner) => {
                    Error::InvalidOptionGroupStateFault(inner)
                }
                crate::error::ModifyOptionGroupErrorKind::OptionGroupNotFoundFault(inner) => {
                    Error::OptionGroupNotFoundFault(inner)
                }
                crate::error::ModifyOptionGroupErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::PromoteReadReplicaError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::PromoteReadReplicaError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::PromoteReadReplicaErrorKind::DbInstanceNotFoundFault(inner) => {
                    Error::DbInstanceNotFoundFault(inner)
                }
                crate::error::PromoteReadReplicaErrorKind::InvalidDbInstanceStateFault(inner) => {
                    Error::InvalidDbInstanceStateFault(inner)
                }
                crate::error::PromoteReadReplicaErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::PromoteReadReplicaDBClusterError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::PromoteReadReplicaDBClusterError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::PromoteReadReplicaDBClusterErrorKind::DbClusterNotFoundFault(
                    inner,
                ) => Error::DbClusterNotFoundFault(inner),
                crate::error::PromoteReadReplicaDBClusterErrorKind::InvalidDbClusterStateFault(
                    inner,
                ) => Error::InvalidDbClusterStateFault(inner),
                crate::error::PromoteReadReplicaDBClusterErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::PurchaseReservedDBInstancesOfferingError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::PurchaseReservedDBInstancesOfferingError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::PurchaseReservedDBInstancesOfferingErrorKind::ReservedDbInstanceAlreadyExistsFault(inner) => Error::ReservedDbInstanceAlreadyExistsFault(inner),
                crate::error::PurchaseReservedDBInstancesOfferingErrorKind::ReservedDbInstanceQuotaExceededFault(inner) => Error::ReservedDbInstanceQuotaExceededFault(inner),
                crate::error::PurchaseReservedDBInstancesOfferingErrorKind::ReservedDbInstancesOfferingNotFoundFault(inner) => Error::ReservedDbInstancesOfferingNotFoundFault(inner),
                crate::error::PurchaseReservedDBInstancesOfferingErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::RebootDBInstanceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::RebootDBInstanceError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::RebootDBInstanceErrorKind::DbInstanceNotFoundFault(inner) => {
                    Error::DbInstanceNotFoundFault(inner)
                }
                crate::error::RebootDBInstanceErrorKind::InvalidDbInstanceStateFault(inner) => {
                    Error::InvalidDbInstanceStateFault(inner)
                }
                crate::error::RebootDBInstanceErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::RegisterDBProxyTargetsError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::RegisterDBProxyTargetsError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::RegisterDBProxyTargetsErrorKind::DbClusterNotFoundFault(inner) => Error::DbClusterNotFoundFault(inner),
                crate::error::RegisterDBProxyTargetsErrorKind::DbInstanceNotFoundFault(inner) => Error::DbInstanceNotFoundFault(inner),
                crate::error::RegisterDBProxyTargetsErrorKind::DbProxyNotFoundFault(inner) => Error::DbProxyNotFoundFault(inner),
                crate::error::RegisterDBProxyTargetsErrorKind::DbProxyTargetAlreadyRegisteredFault(inner) => Error::DbProxyTargetAlreadyRegisteredFault(inner),
                crate::error::RegisterDBProxyTargetsErrorKind::DbProxyTargetGroupNotFoundFault(inner) => Error::DbProxyTargetGroupNotFoundFault(inner),
                crate::error::RegisterDBProxyTargetsErrorKind::InsufficientAvailableIPsInSubnetFault(inner) => Error::InsufficientAvailableIPsInSubnetFault(inner),
                crate::error::RegisterDBProxyTargetsErrorKind::InvalidDbClusterStateFault(inner) => Error::InvalidDbClusterStateFault(inner),
                crate::error::RegisterDBProxyTargetsErrorKind::InvalidDbInstanceStateFault(inner) => Error::InvalidDbInstanceStateFault(inner),
                crate::error::RegisterDBProxyTargetsErrorKind::InvalidDbProxyStateFault(inner) => Error::InvalidDbProxyStateFault(inner),
                crate::error::RegisterDBProxyTargetsErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::RemoveFromGlobalClusterError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::RemoveFromGlobalClusterError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::RemoveFromGlobalClusterErrorKind::DbClusterNotFoundFault(inner) => {
                    Error::DbClusterNotFoundFault(inner)
                }
                crate::error::RemoveFromGlobalClusterErrorKind::GlobalClusterNotFoundFault(
                    inner,
                ) => Error::GlobalClusterNotFoundFault(inner),
                crate::error::RemoveFromGlobalClusterErrorKind::InvalidGlobalClusterStateFault(
                    inner,
                ) => Error::InvalidGlobalClusterStateFault(inner),
                crate::error::RemoveFromGlobalClusterErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::RemoveRoleFromDBClusterError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::RemoveRoleFromDBClusterError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::RemoveRoleFromDBClusterErrorKind::DbClusterNotFoundFault(inner) => {
                    Error::DbClusterNotFoundFault(inner)
                }
                crate::error::RemoveRoleFromDBClusterErrorKind::DbClusterRoleNotFoundFault(
                    inner,
                ) => Error::DbClusterRoleNotFoundFault(inner),
                crate::error::RemoveRoleFromDBClusterErrorKind::InvalidDbClusterStateFault(
                    inner,
                ) => Error::InvalidDbClusterStateFault(inner),
                crate::error::RemoveRoleFromDBClusterErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::RemoveRoleFromDBInstanceError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::RemoveRoleFromDBInstanceError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::RemoveRoleFromDBInstanceErrorKind::DbInstanceNotFoundFault(inner) => {
                    Error::DbInstanceNotFoundFault(inner)
                }
                crate::error::RemoveRoleFromDBInstanceErrorKind::DbInstanceRoleNotFoundFault(
                    inner,
                ) => Error::DbInstanceRoleNotFoundFault(inner),
                crate::error::RemoveRoleFromDBInstanceErrorKind::InvalidDbInstanceStateFault(
                    inner,
                ) => Error::InvalidDbInstanceStateFault(inner),
                crate::error::RemoveRoleFromDBInstanceErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::RemoveSourceIdentifierFromSubscriptionError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::RemoveSourceIdentifierFromSubscriptionError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::RemoveSourceIdentifierFromSubscriptionErrorKind::SourceNotFoundFault(inner) => Error::SourceNotFoundFault(inner),
                crate::error::RemoveSourceIdentifierFromSubscriptionErrorKind::SubscriptionNotFoundFault(inner) => Error::SubscriptionNotFoundFault(inner),
                crate::error::RemoveSourceIdentifierFromSubscriptionErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::RemoveTagsFromResourceError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::RemoveTagsFromResourceError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::RemoveTagsFromResourceErrorKind::DbClusterNotFoundFault(inner) => {
                    Error::DbClusterNotFoundFault(inner)
                }
                crate::error::RemoveTagsFromResourceErrorKind::DbInstanceNotFoundFault(inner) => {
                    Error::DbInstanceNotFoundFault(inner)
                }
                crate::error::RemoveTagsFromResourceErrorKind::DbProxyNotFoundFault(inner) => {
                    Error::DbProxyNotFoundFault(inner)
                }
                crate::error::RemoveTagsFromResourceErrorKind::DbProxyTargetGroupNotFoundFault(
                    inner,
                ) => Error::DbProxyTargetGroupNotFoundFault(inner),
                crate::error::RemoveTagsFromResourceErrorKind::DbSnapshotNotFoundFault(inner) => {
                    Error::DbSnapshotNotFoundFault(inner)
                }
                crate::error::RemoveTagsFromResourceErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ResetDBClusterParameterGroupError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ResetDBClusterParameterGroupError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::ResetDBClusterParameterGroupErrorKind::DbParameterGroupNotFoundFault(inner) => Error::DbParameterGroupNotFoundFault(inner),
                crate::error::ResetDBClusterParameterGroupErrorKind::InvalidDbParameterGroupStateFault(inner) => Error::InvalidDbParameterGroupStateFault(inner),
                crate::error::ResetDBClusterParameterGroupErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::ResetDBParameterGroupError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::ResetDBParameterGroupError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::ResetDBParameterGroupErrorKind::DbParameterGroupNotFoundFault(
                    inner,
                ) => Error::DbParameterGroupNotFoundFault(inner),
                crate::error::ResetDBParameterGroupErrorKind::InvalidDbParameterGroupStateFault(
                    inner,
                ) => Error::InvalidDbParameterGroupStateFault(inner),
                crate::error::ResetDBParameterGroupErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::RestoreDBClusterFromS3Error, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::RestoreDBClusterFromS3Error, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::RestoreDBClusterFromS3ErrorKind::DbClusterAlreadyExistsFault(inner) => Error::DbClusterAlreadyExistsFault(inner),
                crate::error::RestoreDBClusterFromS3ErrorKind::DbClusterNotFoundFault(inner) => Error::DbClusterNotFoundFault(inner),
                crate::error::RestoreDBClusterFromS3ErrorKind::DbClusterParameterGroupNotFoundFault(inner) => Error::DbClusterParameterGroupNotFoundFault(inner),
                crate::error::RestoreDBClusterFromS3ErrorKind::DbClusterQuotaExceededFault(inner) => Error::DbClusterQuotaExceededFault(inner),
                crate::error::RestoreDBClusterFromS3ErrorKind::DbSubnetGroupNotFoundFault(inner) => Error::DbSubnetGroupNotFoundFault(inner),
                crate::error::RestoreDBClusterFromS3ErrorKind::DomainNotFoundFault(inner) => Error::DomainNotFoundFault(inner),
                crate::error::RestoreDBClusterFromS3ErrorKind::InsufficientStorageClusterCapacityFault(inner) => Error::InsufficientStorageClusterCapacityFault(inner),
                crate::error::RestoreDBClusterFromS3ErrorKind::InvalidDbClusterStateFault(inner) => Error::InvalidDbClusterStateFault(inner),
                crate::error::RestoreDBClusterFromS3ErrorKind::InvalidDbSubnetGroupStateFault(inner) => Error::InvalidDbSubnetGroupStateFault(inner),
                crate::error::RestoreDBClusterFromS3ErrorKind::InvalidS3BucketFault(inner) => Error::InvalidS3BucketFault(inner),
                crate::error::RestoreDBClusterFromS3ErrorKind::InvalidSubnet(inner) => Error::InvalidSubnet(inner),
                crate::error::RestoreDBClusterFromS3ErrorKind::InvalidVpcNetworkStateFault(inner) => Error::InvalidVpcNetworkStateFault(inner),
                crate::error::RestoreDBClusterFromS3ErrorKind::KmsKeyNotAccessibleFault(inner) => Error::KmsKeyNotAccessibleFault(inner),
                crate::error::RestoreDBClusterFromS3ErrorKind::StorageQuotaExceededFault(inner) => Error::StorageQuotaExceededFault(inner),
                crate::error::RestoreDBClusterFromS3ErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::RestoreDBClusterFromSnapshotError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::RestoreDBClusterFromSnapshotError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::RestoreDBClusterFromSnapshotErrorKind::DbClusterAlreadyExistsFault(inner) => Error::DbClusterAlreadyExistsFault(inner),
                crate::error::RestoreDBClusterFromSnapshotErrorKind::DbClusterParameterGroupNotFoundFault(inner) => Error::DbClusterParameterGroupNotFoundFault(inner),
                crate::error::RestoreDBClusterFromSnapshotErrorKind::DbClusterQuotaExceededFault(inner) => Error::DbClusterQuotaExceededFault(inner),
                crate::error::RestoreDBClusterFromSnapshotErrorKind::DbClusterSnapshotNotFoundFault(inner) => Error::DbClusterSnapshotNotFoundFault(inner),
                crate::error::RestoreDBClusterFromSnapshotErrorKind::DbSnapshotNotFoundFault(inner) => Error::DbSnapshotNotFoundFault(inner),
                crate::error::RestoreDBClusterFromSnapshotErrorKind::DbSubnetGroupNotFoundFault(inner) => Error::DbSubnetGroupNotFoundFault(inner),
                crate::error::RestoreDBClusterFromSnapshotErrorKind::DomainNotFoundFault(inner) => Error::DomainNotFoundFault(inner),
                crate::error::RestoreDBClusterFromSnapshotErrorKind::InsufficientDbClusterCapacityFault(inner) => Error::InsufficientDbClusterCapacityFault(inner),
                crate::error::RestoreDBClusterFromSnapshotErrorKind::InsufficientStorageClusterCapacityFault(inner) => Error::InsufficientStorageClusterCapacityFault(inner),
                crate::error::RestoreDBClusterFromSnapshotErrorKind::InvalidDbClusterSnapshotStateFault(inner) => Error::InvalidDbClusterSnapshotStateFault(inner),
                crate::error::RestoreDBClusterFromSnapshotErrorKind::InvalidDbSnapshotStateFault(inner) => Error::InvalidDbSnapshotStateFault(inner),
                crate::error::RestoreDBClusterFromSnapshotErrorKind::InvalidRestoreFault(inner) => Error::InvalidRestoreFault(inner),
                crate::error::RestoreDBClusterFromSnapshotErrorKind::InvalidSubnet(inner) => Error::InvalidSubnet(inner),
                crate::error::RestoreDBClusterFromSnapshotErrorKind::InvalidVpcNetworkStateFault(inner) => Error::InvalidVpcNetworkStateFault(inner),
                crate::error::RestoreDBClusterFromSnapshotErrorKind::KmsKeyNotAccessibleFault(inner) => Error::KmsKeyNotAccessibleFault(inner),
                crate::error::RestoreDBClusterFromSnapshotErrorKind::OptionGroupNotFoundFault(inner) => Error::OptionGroupNotFoundFault(inner),
                crate::error::RestoreDBClusterFromSnapshotErrorKind::StorageQuotaExceededFault(inner) => Error::StorageQuotaExceededFault(inner),
                crate::error::RestoreDBClusterFromSnapshotErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::RestoreDBClusterToPointInTimeError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::RestoreDBClusterToPointInTimeError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::RestoreDBClusterToPointInTimeErrorKind::DbClusterAlreadyExistsFault(inner) => Error::DbClusterAlreadyExistsFault(inner),
                crate::error::RestoreDBClusterToPointInTimeErrorKind::DbClusterNotFoundFault(inner) => Error::DbClusterNotFoundFault(inner),
                crate::error::RestoreDBClusterToPointInTimeErrorKind::DbClusterParameterGroupNotFoundFault(inner) => Error::DbClusterParameterGroupNotFoundFault(inner),
                crate::error::RestoreDBClusterToPointInTimeErrorKind::DbClusterQuotaExceededFault(inner) => Error::DbClusterQuotaExceededFault(inner),
                crate::error::RestoreDBClusterToPointInTimeErrorKind::DbClusterSnapshotNotFoundFault(inner) => Error::DbClusterSnapshotNotFoundFault(inner),
                crate::error::RestoreDBClusterToPointInTimeErrorKind::DbSubnetGroupNotFoundFault(inner) => Error::DbSubnetGroupNotFoundFault(inner),
                crate::error::RestoreDBClusterToPointInTimeErrorKind::DomainNotFoundFault(inner) => Error::DomainNotFoundFault(inner),
                crate::error::RestoreDBClusterToPointInTimeErrorKind::InsufficientDbClusterCapacityFault(inner) => Error::InsufficientDbClusterCapacityFault(inner),
                crate::error::RestoreDBClusterToPointInTimeErrorKind::InsufficientStorageClusterCapacityFault(inner) => Error::InsufficientStorageClusterCapacityFault(inner),
                crate::error::RestoreDBClusterToPointInTimeErrorKind::InvalidDbClusterSnapshotStateFault(inner) => Error::InvalidDbClusterSnapshotStateFault(inner),
                crate::error::RestoreDBClusterToPointInTimeErrorKind::InvalidDbClusterStateFault(inner) => Error::InvalidDbClusterStateFault(inner),
                crate::error::RestoreDBClusterToPointInTimeErrorKind::InvalidDbSnapshotStateFault(inner) => Error::InvalidDbSnapshotStateFault(inner),
                crate::error::RestoreDBClusterToPointInTimeErrorKind::InvalidRestoreFault(inner) => Error::InvalidRestoreFault(inner),
                crate::error::RestoreDBClusterToPointInTimeErrorKind::InvalidSubnet(inner) => Error::InvalidSubnet(inner),
                crate::error::RestoreDBClusterToPointInTimeErrorKind::InvalidVpcNetworkStateFault(inner) => Error::InvalidVpcNetworkStateFault(inner),
                crate::error::RestoreDBClusterToPointInTimeErrorKind::KmsKeyNotAccessibleFault(inner) => Error::KmsKeyNotAccessibleFault(inner),
                crate::error::RestoreDBClusterToPointInTimeErrorKind::OptionGroupNotFoundFault(inner) => Error::OptionGroupNotFoundFault(inner),
                crate::error::RestoreDBClusterToPointInTimeErrorKind::StorageQuotaExceededFault(inner) => Error::StorageQuotaExceededFault(inner),
                crate::error::RestoreDBClusterToPointInTimeErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::RestoreDBInstanceFromDBSnapshotError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::RestoreDBInstanceFromDBSnapshotError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::RestoreDBInstanceFromDBSnapshotErrorKind::AuthorizationNotFoundFault(inner) => Error::AuthorizationNotFoundFault(inner),
                crate::error::RestoreDBInstanceFromDBSnapshotErrorKind::BackupPolicyNotFoundFault(inner) => Error::BackupPolicyNotFoundFault(inner),
                crate::error::RestoreDBInstanceFromDBSnapshotErrorKind::DbInstanceAlreadyExistsFault(inner) => Error::DbInstanceAlreadyExistsFault(inner),
                crate::error::RestoreDBInstanceFromDBSnapshotErrorKind::DbParameterGroupNotFoundFault(inner) => Error::DbParameterGroupNotFoundFault(inner),
                crate::error::RestoreDBInstanceFromDBSnapshotErrorKind::DbSecurityGroupNotFoundFault(inner) => Error::DbSecurityGroupNotFoundFault(inner),
                crate::error::RestoreDBInstanceFromDBSnapshotErrorKind::DbSnapshotNotFoundFault(inner) => Error::DbSnapshotNotFoundFault(inner),
                crate::error::RestoreDBInstanceFromDBSnapshotErrorKind::DbSubnetGroupDoesNotCoverEnoughAZs(inner) => Error::DbSubnetGroupDoesNotCoverEnoughAZs(inner),
                crate::error::RestoreDBInstanceFromDBSnapshotErrorKind::DbSubnetGroupNotFoundFault(inner) => Error::DbSubnetGroupNotFoundFault(inner),
                crate::error::RestoreDBInstanceFromDBSnapshotErrorKind::DomainNotFoundFault(inner) => Error::DomainNotFoundFault(inner),
                crate::error::RestoreDBInstanceFromDBSnapshotErrorKind::InstanceQuotaExceededFault(inner) => Error::InstanceQuotaExceededFault(inner),
                crate::error::RestoreDBInstanceFromDBSnapshotErrorKind::InsufficientDbInstanceCapacityFault(inner) => Error::InsufficientDbInstanceCapacityFault(inner),
                crate::error::RestoreDBInstanceFromDBSnapshotErrorKind::InvalidDbSnapshotStateFault(inner) => Error::InvalidDbSnapshotStateFault(inner),
                crate::error::RestoreDBInstanceFromDBSnapshotErrorKind::InvalidRestoreFault(inner) => Error::InvalidRestoreFault(inner),
                crate::error::RestoreDBInstanceFromDBSnapshotErrorKind::InvalidSubnet(inner) => Error::InvalidSubnet(inner),
                crate::error::RestoreDBInstanceFromDBSnapshotErrorKind::InvalidVpcNetworkStateFault(inner) => Error::InvalidVpcNetworkStateFault(inner),
                crate::error::RestoreDBInstanceFromDBSnapshotErrorKind::KmsKeyNotAccessibleFault(inner) => Error::KmsKeyNotAccessibleFault(inner),
                crate::error::RestoreDBInstanceFromDBSnapshotErrorKind::OptionGroupNotFoundFault(inner) => Error::OptionGroupNotFoundFault(inner),
                crate::error::RestoreDBInstanceFromDBSnapshotErrorKind::ProvisionedIopsNotAvailableInAzFault(inner) => Error::ProvisionedIopsNotAvailableInAzFault(inner),
                crate::error::RestoreDBInstanceFromDBSnapshotErrorKind::StorageQuotaExceededFault(inner) => Error::StorageQuotaExceededFault(inner),
                crate::error::RestoreDBInstanceFromDBSnapshotErrorKind::StorageTypeNotSupportedFault(inner) => Error::StorageTypeNotSupportedFault(inner),
                crate::error::RestoreDBInstanceFromDBSnapshotErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::RestoreDBInstanceFromS3Error, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::RestoreDBInstanceFromS3Error, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::RestoreDBInstanceFromS3ErrorKind::AuthorizationNotFoundFault(inner) => Error::AuthorizationNotFoundFault(inner),
                crate::error::RestoreDBInstanceFromS3ErrorKind::BackupPolicyNotFoundFault(inner) => Error::BackupPolicyNotFoundFault(inner),
                crate::error::RestoreDBInstanceFromS3ErrorKind::DbInstanceAlreadyExistsFault(inner) => Error::DbInstanceAlreadyExistsFault(inner),
                crate::error::RestoreDBInstanceFromS3ErrorKind::DbParameterGroupNotFoundFault(inner) => Error::DbParameterGroupNotFoundFault(inner),
                crate::error::RestoreDBInstanceFromS3ErrorKind::DbSecurityGroupNotFoundFault(inner) => Error::DbSecurityGroupNotFoundFault(inner),
                crate::error::RestoreDBInstanceFromS3ErrorKind::DbSubnetGroupDoesNotCoverEnoughAZs(inner) => Error::DbSubnetGroupDoesNotCoverEnoughAZs(inner),
                crate::error::RestoreDBInstanceFromS3ErrorKind::DbSubnetGroupNotFoundFault(inner) => Error::DbSubnetGroupNotFoundFault(inner),
                crate::error::RestoreDBInstanceFromS3ErrorKind::InstanceQuotaExceededFault(inner) => Error::InstanceQuotaExceededFault(inner),
                crate::error::RestoreDBInstanceFromS3ErrorKind::InsufficientDbInstanceCapacityFault(inner) => Error::InsufficientDbInstanceCapacityFault(inner),
                crate::error::RestoreDBInstanceFromS3ErrorKind::InvalidS3BucketFault(inner) => Error::InvalidS3BucketFault(inner),
                crate::error::RestoreDBInstanceFromS3ErrorKind::InvalidSubnet(inner) => Error::InvalidSubnet(inner),
                crate::error::RestoreDBInstanceFromS3ErrorKind::InvalidVpcNetworkStateFault(inner) => Error::InvalidVpcNetworkStateFault(inner),
                crate::error::RestoreDBInstanceFromS3ErrorKind::KmsKeyNotAccessibleFault(inner) => Error::KmsKeyNotAccessibleFault(inner),
                crate::error::RestoreDBInstanceFromS3ErrorKind::OptionGroupNotFoundFault(inner) => Error::OptionGroupNotFoundFault(inner),
                crate::error::RestoreDBInstanceFromS3ErrorKind::ProvisionedIopsNotAvailableInAzFault(inner) => Error::ProvisionedIopsNotAvailableInAzFault(inner),
                crate::error::RestoreDBInstanceFromS3ErrorKind::StorageQuotaExceededFault(inner) => Error::StorageQuotaExceededFault(inner),
                crate::error::RestoreDBInstanceFromS3ErrorKind::StorageTypeNotSupportedFault(inner) => Error::StorageTypeNotSupportedFault(inner),
                crate::error::RestoreDBInstanceFromS3ErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<aws_smithy_http::result::SdkError<crate::error::RestoreDBInstanceToPointInTimeError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::RestoreDBInstanceToPointInTimeError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::RestoreDBInstanceToPointInTimeErrorKind::AuthorizationNotFoundFault(inner) => Error::AuthorizationNotFoundFault(inner),
                crate::error::RestoreDBInstanceToPointInTimeErrorKind::BackupPolicyNotFoundFault(inner) => Error::BackupPolicyNotFoundFault(inner),
                crate::error::RestoreDBInstanceToPointInTimeErrorKind::DbInstanceAlreadyExistsFault(inner) => Error::DbInstanceAlreadyExistsFault(inner),
                crate::error::RestoreDBInstanceToPointInTimeErrorKind::DbInstanceAutomatedBackupNotFoundFault(inner) => Error::DbInstanceAutomatedBackupNotFoundFault(inner),
                crate::error::RestoreDBInstanceToPointInTimeErrorKind::DbInstanceNotFoundFault(inner) => Error::DbInstanceNotFoundFault(inner),
                crate::error::RestoreDBInstanceToPointInTimeErrorKind::DbParameterGroupNotFoundFault(inner) => Error::DbParameterGroupNotFoundFault(inner),
                crate::error::RestoreDBInstanceToPointInTimeErrorKind::DbSecurityGroupNotFoundFault(inner) => Error::DbSecurityGroupNotFoundFault(inner),
                crate::error::RestoreDBInstanceToPointInTimeErrorKind::DbSubnetGroupDoesNotCoverEnoughAZs(inner) => Error::DbSubnetGroupDoesNotCoverEnoughAZs(inner),
                crate::error::RestoreDBInstanceToPointInTimeErrorKind::DbSubnetGroupNotFoundFault(inner) => Error::DbSubnetGroupNotFoundFault(inner),
                crate::error::RestoreDBInstanceToPointInTimeErrorKind::DomainNotFoundFault(inner) => Error::DomainNotFoundFault(inner),
                crate::error::RestoreDBInstanceToPointInTimeErrorKind::InstanceQuotaExceededFault(inner) => Error::InstanceQuotaExceededFault(inner),
                crate::error::RestoreDBInstanceToPointInTimeErrorKind::InsufficientDbInstanceCapacityFault(inner) => Error::InsufficientDbInstanceCapacityFault(inner),
                crate::error::RestoreDBInstanceToPointInTimeErrorKind::InvalidDbInstanceStateFault(inner) => Error::InvalidDbInstanceStateFault(inner),
                crate::error::RestoreDBInstanceToPointInTimeErrorKind::InvalidRestoreFault(inner) => Error::InvalidRestoreFault(inner),
                crate::error::RestoreDBInstanceToPointInTimeErrorKind::InvalidSubnet(inner) => Error::InvalidSubnet(inner),
                crate::error::RestoreDBInstanceToPointInTimeErrorKind::InvalidVpcNetworkStateFault(inner) => Error::InvalidVpcNetworkStateFault(inner),
                crate::error::RestoreDBInstanceToPointInTimeErrorKind::KmsKeyNotAccessibleFault(inner) => Error::KmsKeyNotAccessibleFault(inner),
                crate::error::RestoreDBInstanceToPointInTimeErrorKind::OptionGroupNotFoundFault(inner) => Error::OptionGroupNotFoundFault(inner),
                crate::error::RestoreDBInstanceToPointInTimeErrorKind::PointInTimeRestoreNotEnabledFault(inner) => Error::PointInTimeRestoreNotEnabledFault(inner),
                crate::error::RestoreDBInstanceToPointInTimeErrorKind::ProvisionedIopsNotAvailableInAzFault(inner) => Error::ProvisionedIopsNotAvailableInAzFault(inner),
                crate::error::RestoreDBInstanceToPointInTimeErrorKind::StorageQuotaExceededFault(inner) => Error::StorageQuotaExceededFault(inner),
                crate::error::RestoreDBInstanceToPointInTimeErrorKind::StorageTypeNotSupportedFault(inner) => Error::StorageTypeNotSupportedFault(inner),
                crate::error::RestoreDBInstanceToPointInTimeErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::RevokeDBSecurityGroupIngressError, R>>
    for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::RevokeDBSecurityGroupIngressError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::RevokeDBSecurityGroupIngressErrorKind::AuthorizationNotFoundFault(inner) => Error::AuthorizationNotFoundFault(inner),
                crate::error::RevokeDBSecurityGroupIngressErrorKind::DbSecurityGroupNotFoundFault(inner) => Error::DbSecurityGroupNotFoundFault(inner),
                crate::error::RevokeDBSecurityGroupIngressErrorKind::InvalidDbSecurityGroupStateFault(inner) => Error::InvalidDbSecurityGroupStateFault(inner),
                crate::error::RevokeDBSecurityGroupIngressErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::StartActivityStreamError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::StartActivityStreamError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::StartActivityStreamErrorKind::DbClusterNotFoundFault(inner) => {
                    Error::DbClusterNotFoundFault(inner)
                }
                crate::error::StartActivityStreamErrorKind::DbInstanceNotFoundFault(inner) => {
                    Error::DbInstanceNotFoundFault(inner)
                }
                crate::error::StartActivityStreamErrorKind::InvalidDbClusterStateFault(inner) => {
                    Error::InvalidDbClusterStateFault(inner)
                }
                crate::error::StartActivityStreamErrorKind::InvalidDbInstanceStateFault(inner) => {
                    Error::InvalidDbInstanceStateFault(inner)
                }
                crate::error::StartActivityStreamErrorKind::KmsKeyNotAccessibleFault(inner) => {
                    Error::KmsKeyNotAccessibleFault(inner)
                }
                crate::error::StartActivityStreamErrorKind::ResourceNotFoundFault(inner) => {
                    Error::ResourceNotFoundFault(inner)
                }
                crate::error::StartActivityStreamErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::StartDBClusterError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::StartDBClusterError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::StartDBClusterErrorKind::DbClusterNotFoundFault(inner) => {
                    Error::DbClusterNotFoundFault(inner)
                }
                crate::error::StartDBClusterErrorKind::InvalidDbClusterStateFault(inner) => {
                    Error::InvalidDbClusterStateFault(inner)
                }
                crate::error::StartDBClusterErrorKind::InvalidDbInstanceStateFault(inner) => {
                    Error::InvalidDbInstanceStateFault(inner)
                }
                crate::error::StartDBClusterErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::StartDBInstanceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::StartDBInstanceError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::StartDBInstanceErrorKind::AuthorizationNotFoundFault(inner) => {
                    Error::AuthorizationNotFoundFault(inner)
                }
                crate::error::StartDBInstanceErrorKind::DbClusterNotFoundFault(inner) => {
                    Error::DbClusterNotFoundFault(inner)
                }
                crate::error::StartDBInstanceErrorKind::DbInstanceNotFoundFault(inner) => {
                    Error::DbInstanceNotFoundFault(inner)
                }
                crate::error::StartDBInstanceErrorKind::DbSubnetGroupDoesNotCoverEnoughAZs(
                    inner,
                ) => Error::DbSubnetGroupDoesNotCoverEnoughAZs(inner),
                crate::error::StartDBInstanceErrorKind::DbSubnetGroupNotFoundFault(inner) => {
                    Error::DbSubnetGroupNotFoundFault(inner)
                }
                crate::error::StartDBInstanceErrorKind::InsufficientDbInstanceCapacityFault(
                    inner,
                ) => Error::InsufficientDbInstanceCapacityFault(inner),
                crate::error::StartDBInstanceErrorKind::InvalidDbClusterStateFault(inner) => {
                    Error::InvalidDbClusterStateFault(inner)
                }
                crate::error::StartDBInstanceErrorKind::InvalidDbInstanceStateFault(inner) => {
                    Error::InvalidDbInstanceStateFault(inner)
                }
                crate::error::StartDBInstanceErrorKind::InvalidSubnet(inner) => {
                    Error::InvalidSubnet(inner)
                }
                crate::error::StartDBInstanceErrorKind::InvalidVpcNetworkStateFault(inner) => {
                    Error::InvalidVpcNetworkStateFault(inner)
                }
                crate::error::StartDBInstanceErrorKind::KmsKeyNotAccessibleFault(inner) => {
                    Error::KmsKeyNotAccessibleFault(inner)
                }
                crate::error::StartDBInstanceErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::StartDBInstanceAutomatedBackupsReplicationError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::StartDBInstanceAutomatedBackupsReplicationError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::StartDBInstanceAutomatedBackupsReplicationErrorKind::DbInstanceAutomatedBackupQuotaExceededFault(inner) => Error::DbInstanceAutomatedBackupQuotaExceededFault(inner),
                crate::error::StartDBInstanceAutomatedBackupsReplicationErrorKind::DbInstanceNotFoundFault(inner) => Error::DbInstanceNotFoundFault(inner),
                crate::error::StartDBInstanceAutomatedBackupsReplicationErrorKind::InvalidDbInstanceStateFault(inner) => Error::InvalidDbInstanceStateFault(inner),
                crate::error::StartDBInstanceAutomatedBackupsReplicationErrorKind::KmsKeyNotAccessibleFault(inner) => Error::KmsKeyNotAccessibleFault(inner),
                crate::error::StartDBInstanceAutomatedBackupsReplicationErrorKind::StorageTypeNotSupportedFault(inner) => Error::StorageTypeNotSupportedFault(inner),
                crate::error::StartDBInstanceAutomatedBackupsReplicationErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::StartExportTaskError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::StartExportTaskError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::StartExportTaskErrorKind::DbClusterSnapshotNotFoundFault(inner) => {
                    Error::DbClusterSnapshotNotFoundFault(inner)
                }
                crate::error::StartExportTaskErrorKind::DbSnapshotNotFoundFault(inner) => {
                    Error::DbSnapshotNotFoundFault(inner)
                }
                crate::error::StartExportTaskErrorKind::ExportTaskAlreadyExistsFault(inner) => {
                    Error::ExportTaskAlreadyExistsFault(inner)
                }
                crate::error::StartExportTaskErrorKind::IamRoleMissingPermissionsFault(inner) => {
                    Error::IamRoleMissingPermissionsFault(inner)
                }
                crate::error::StartExportTaskErrorKind::IamRoleNotFoundFault(inner) => {
                    Error::IamRoleNotFoundFault(inner)
                }
                crate::error::StartExportTaskErrorKind::InvalidExportOnlyFault(inner) => {
                    Error::InvalidExportOnlyFault(inner)
                }
                crate::error::StartExportTaskErrorKind::InvalidExportSourceStateFault(inner) => {
                    Error::InvalidExportSourceStateFault(inner)
                }
                crate::error::StartExportTaskErrorKind::InvalidS3BucketFault(inner) => {
                    Error::InvalidS3BucketFault(inner)
                }
                crate::error::StartExportTaskErrorKind::KmsKeyNotAccessibleFault(inner) => {
                    Error::KmsKeyNotAccessibleFault(inner)
                }
                crate::error::StartExportTaskErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::StopActivityStreamError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<crate::error::StopActivityStreamError, R>,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::StopActivityStreamErrorKind::DbClusterNotFoundFault(inner) => {
                    Error::DbClusterNotFoundFault(inner)
                }
                crate::error::StopActivityStreamErrorKind::DbInstanceNotFoundFault(inner) => {
                    Error::DbInstanceNotFoundFault(inner)
                }
                crate::error::StopActivityStreamErrorKind::InvalidDbClusterStateFault(inner) => {
                    Error::InvalidDbClusterStateFault(inner)
                }
                crate::error::StopActivityStreamErrorKind::InvalidDbInstanceStateFault(inner) => {
                    Error::InvalidDbInstanceStateFault(inner)
                }
                crate::error::StopActivityStreamErrorKind::ResourceNotFoundFault(inner) => {
                    Error::ResourceNotFoundFault(inner)
                }
                crate::error::StopActivityStreamErrorKind::Unhandled(inner) => {
                    Error::Unhandled(inner)
                }
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::StopDBClusterError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::StopDBClusterError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::StopDBClusterErrorKind::DbClusterNotFoundFault(inner) => {
                    Error::DbClusterNotFoundFault(inner)
                }
                crate::error::StopDBClusterErrorKind::InvalidDbClusterStateFault(inner) => {
                    Error::InvalidDbClusterStateFault(inner)
                }
                crate::error::StopDBClusterErrorKind::InvalidDbInstanceStateFault(inner) => {
                    Error::InvalidDbInstanceStateFault(inner)
                }
                crate::error::StopDBClusterErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R> From<aws_smithy_http::result::SdkError<crate::error::StopDBInstanceError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: aws_smithy_http::result::SdkError<crate::error::StopDBInstanceError, R>) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, .. } => match err.kind {
                crate::error::StopDBInstanceErrorKind::DbInstanceNotFoundFault(inner) => {
                    Error::DbInstanceNotFoundFault(inner)
                }
                crate::error::StopDBInstanceErrorKind::DbSnapshotAlreadyExistsFault(inner) => {
                    Error::DbSnapshotAlreadyExistsFault(inner)
                }
                crate::error::StopDBInstanceErrorKind::InvalidDbClusterStateFault(inner) => {
                    Error::InvalidDbClusterStateFault(inner)
                }
                crate::error::StopDBInstanceErrorKind::InvalidDbInstanceStateFault(inner) => {
                    Error::InvalidDbInstanceStateFault(inner)
                }
                crate::error::StopDBInstanceErrorKind::SnapshotQuotaExceededFault(inner) => {
                    Error::SnapshotQuotaExceededFault(inner)
                }
                crate::error::StopDBInstanceErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            },
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl<R>
    From<
        aws_smithy_http::result::SdkError<
            crate::error::StopDBInstanceAutomatedBackupsReplicationError,
            R,
        >,
    > for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(
        err: aws_smithy_http::result::SdkError<
            crate::error::StopDBInstanceAutomatedBackupsReplicationError,
            R,
        >,
    ) -> Self {
        match err {
            aws_smithy_http::result::SdkError::ServiceError { err, ..} => match err.kind {
                crate::error::StopDBInstanceAutomatedBackupsReplicationErrorKind::DbInstanceNotFoundFault(inner) => Error::DbInstanceNotFoundFault(inner),
                crate::error::StopDBInstanceAutomatedBackupsReplicationErrorKind::InvalidDbInstanceStateFault(inner) => Error::InvalidDbInstanceStateFault(inner),
                crate::error::StopDBInstanceAutomatedBackupsReplicationErrorKind::Unhandled(inner) => Error::Unhandled(inner),
            }
            _ => Error::Unhandled(err.into()),
        }
    }
}
impl std::error::Error for Error {}
