// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`AddRoleToDbClusterInput`](crate::input::AddRoleToDbClusterInput)
pub mod add_role_to_db_cluster_input {
    /// A builder for [`AddRoleToDbClusterInput`](crate::input::AddRoleToDbClusterInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) feature_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the DB cluster to associate the IAM role with.</p>
        pub fn db_cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_cluster_identifier = Some(input.into());
            self
        }
        /// <p>The name of the DB cluster to associate the IAM role with.</p>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_identifier = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role to associate with the Aurora DB cluster, for example <code>arn:aws:iam::123456789012:role/AuroraAccessRole</code>.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role to associate with the Aurora DB cluster, for example <code>arn:aws:iam::123456789012:role/AuroraAccessRole</code>.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The name of the feature for the DB cluster that the IAM role is to be associated with. For information about supported feature names, see <code>DBEngineVersion</code>.</p>
        pub fn feature_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.feature_name = Some(input.into());
            self
        }
        /// <p>The name of the feature for the DB cluster that the IAM role is to be associated with. For information about supported feature names, see <code>DBEngineVersion</code>.</p>
        pub fn set_feature_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.feature_name = input;
            self
        }
        /// Consumes the builder and constructs a [`AddRoleToDbClusterInput`](crate::input::AddRoleToDbClusterInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AddRoleToDbClusterInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AddRoleToDbClusterInput {
                db_cluster_identifier: self.db_cluster_identifier,
                role_arn: self.role_arn,
                feature_name: self.feature_name,
            })
        }
    }
}
#[doc(hidden)]
pub type AddRoleToDbClusterInputOperationOutputAlias = crate::operation::AddRoleToDBCluster;
#[doc(hidden)]
pub type AddRoleToDbClusterInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AddRoleToDbClusterInput {
    /// Consumes the builder and constructs an Operation<[`AddRoleToDBCluster`](crate::operation::AddRoleToDBCluster)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AddRoleToDBCluster,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::AddRoleToDbClusterInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::AddRoleToDbClusterInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_add_role_to_db_cluster(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AddRoleToDBCluster::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AddRoleToDBCluster",
            "rds",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`AddRoleToDbClusterInput`](crate::input::AddRoleToDbClusterInput)
    pub fn builder() -> crate::input::add_role_to_db_cluster_input::Builder {
        crate::input::add_role_to_db_cluster_input::Builder::default()
    }
}

/// See [`AddRoleToDbInstanceInput`](crate::input::AddRoleToDbInstanceInput)
pub mod add_role_to_db_instance_input {
    /// A builder for [`AddRoleToDbInstanceInput`](crate::input::AddRoleToDbInstanceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_instance_identifier: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) feature_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the DB instance to associate the IAM role with.</p>
        pub fn db_instance_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_instance_identifier = Some(input.into());
            self
        }
        /// <p>The name of the DB instance to associate the IAM role with.</p>
        pub fn set_db_instance_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_instance_identifier = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role to associate with the DB instance, for example <code>arn:aws:iam::123456789012:role/AccessRole</code>.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role to associate with the DB instance, for example <code>arn:aws:iam::123456789012:role/AccessRole</code>.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The name of the feature for the DB instance that the IAM role is to be associated with. For information about supported feature names, see <code>DBEngineVersion</code>.</p>
        pub fn feature_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.feature_name = Some(input.into());
            self
        }
        /// <p>The name of the feature for the DB instance that the IAM role is to be associated with. For information about supported feature names, see <code>DBEngineVersion</code>.</p>
        pub fn set_feature_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.feature_name = input;
            self
        }
        /// Consumes the builder and constructs a [`AddRoleToDbInstanceInput`](crate::input::AddRoleToDbInstanceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AddRoleToDbInstanceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AddRoleToDbInstanceInput {
                db_instance_identifier: self.db_instance_identifier,
                role_arn: self.role_arn,
                feature_name: self.feature_name,
            })
        }
    }
}
#[doc(hidden)]
pub type AddRoleToDbInstanceInputOperationOutputAlias = crate::operation::AddRoleToDBInstance;
#[doc(hidden)]
pub type AddRoleToDbInstanceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AddRoleToDbInstanceInput {
    /// Consumes the builder and constructs an Operation<[`AddRoleToDBInstance`](crate::operation::AddRoleToDBInstance)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AddRoleToDBInstance,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::AddRoleToDbInstanceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::AddRoleToDbInstanceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_add_role_to_db_instance(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AddRoleToDBInstance::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AddRoleToDBInstance",
            "rds",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`AddRoleToDbInstanceInput`](crate::input::AddRoleToDbInstanceInput)
    pub fn builder() -> crate::input::add_role_to_db_instance_input::Builder {
        crate::input::add_role_to_db_instance_input::Builder::default()
    }
}

/// See [`AddSourceIdentifierToSubscriptionInput`](crate::input::AddSourceIdentifierToSubscriptionInput)
pub mod add_source_identifier_to_subscription_input {
    /// A builder for [`AddSourceIdentifierToSubscriptionInput`](crate::input::AddSourceIdentifierToSubscriptionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) subscription_name: std::option::Option<std::string::String>,
        pub(crate) source_identifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the RDS event notification subscription you want to add a source identifier to.</p>
        pub fn subscription_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.subscription_name = Some(input.into());
            self
        }
        /// <p>The name of the RDS event notification subscription you want to add a source identifier to.</p>
        pub fn set_subscription_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.subscription_name = input;
            self
        }
        /// <p>The identifier of the event source to be added.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>If the source type is a DB instance, a <code>DBInstanceIdentifier</code> value must be supplied.</p> </li>
        /// <li> <p>If the source type is a DB cluster, a <code>DBClusterIdentifier</code> value must be supplied.</p> </li>
        /// <li> <p>If the source type is a DB parameter group, a <code>DBParameterGroupName</code> value must be supplied.</p> </li>
        /// <li> <p>If the source type is a DB security group, a <code>DBSecurityGroupName</code> value must be supplied.</p> </li>
        /// <li> <p>If the source type is a DB snapshot, a <code>DBSnapshotIdentifier</code> value must be supplied.</p> </li>
        /// <li> <p>If the source type is a DB cluster snapshot, a <code>DBClusterSnapshotIdentifier</code> value must be supplied.</p> </li>
        /// <li> <p>If the source type is an RDS Proxy, a <code>DBProxyName</code> value must be supplied.</p> </li>
        /// </ul>
        pub fn source_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_identifier = Some(input.into());
            self
        }
        /// <p>The identifier of the event source to be added.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>If the source type is a DB instance, a <code>DBInstanceIdentifier</code> value must be supplied.</p> </li>
        /// <li> <p>If the source type is a DB cluster, a <code>DBClusterIdentifier</code> value must be supplied.</p> </li>
        /// <li> <p>If the source type is a DB parameter group, a <code>DBParameterGroupName</code> value must be supplied.</p> </li>
        /// <li> <p>If the source type is a DB security group, a <code>DBSecurityGroupName</code> value must be supplied.</p> </li>
        /// <li> <p>If the source type is a DB snapshot, a <code>DBSnapshotIdentifier</code> value must be supplied.</p> </li>
        /// <li> <p>If the source type is a DB cluster snapshot, a <code>DBClusterSnapshotIdentifier</code> value must be supplied.</p> </li>
        /// <li> <p>If the source type is an RDS Proxy, a <code>DBProxyName</code> value must be supplied.</p> </li>
        /// </ul>
        pub fn set_source_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`AddSourceIdentifierToSubscriptionInput`](crate::input::AddSourceIdentifierToSubscriptionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AddSourceIdentifierToSubscriptionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AddSourceIdentifierToSubscriptionInput {
                subscription_name: self.subscription_name,
                source_identifier: self.source_identifier,
            })
        }
    }
}
#[doc(hidden)]
pub type AddSourceIdentifierToSubscriptionInputOperationOutputAlias =
    crate::operation::AddSourceIdentifierToSubscription;
#[doc(hidden)]
pub type AddSourceIdentifierToSubscriptionInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl AddSourceIdentifierToSubscriptionInput {
    /// Consumes the builder and constructs an Operation<[`AddSourceIdentifierToSubscription`](crate::operation::AddSourceIdentifierToSubscription)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AddSourceIdentifierToSubscription,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::AddSourceIdentifierToSubscriptionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::AddSourceIdentifierToSubscriptionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_add_source_identifier_to_subscription(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AddSourceIdentifierToSubscription::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AddSourceIdentifierToSubscription",
            "rds",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`AddSourceIdentifierToSubscriptionInput`](crate::input::AddSourceIdentifierToSubscriptionInput)
    pub fn builder() -> crate::input::add_source_identifier_to_subscription_input::Builder {
        crate::input::add_source_identifier_to_subscription_input::Builder::default()
    }
}

/// See [`AddTagsToResourceInput`](crate::input::AddTagsToResourceInput)
pub mod add_tags_to_resource_input {
    /// A builder for [`AddTagsToResourceInput`](crate::input::AddTagsToResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_name: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The Amazon RDS resource that the tags are added to. This value is an Amazon Resource Name (ARN). For information about creating an ARN, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing"> Constructing an RDS Amazon Resource Name (ARN)</a>.</p>
        pub fn resource_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_name = Some(input.into());
            self
        }
        /// <p>The Amazon RDS resource that the tags are added to. This value is an Amazon Resource Name (ARN). For information about creating an ARN, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing"> Constructing an RDS Amazon Resource Name (ARN)</a>.</p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_name = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be assigned to the Amazon RDS resource.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The tags to be assigned to the Amazon RDS resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`AddTagsToResourceInput`](crate::input::AddTagsToResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AddTagsToResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AddTagsToResourceInput {
                resource_name: self.resource_name,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type AddTagsToResourceInputOperationOutputAlias = crate::operation::AddTagsToResource;
#[doc(hidden)]
pub type AddTagsToResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl AddTagsToResourceInput {
    /// Consumes the builder and constructs an Operation<[`AddTagsToResource`](crate::operation::AddTagsToResource)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AddTagsToResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::AddTagsToResourceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::AddTagsToResourceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_add_tags_to_resource(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AddTagsToResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AddTagsToResource",
            "rds",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`AddTagsToResourceInput`](crate::input::AddTagsToResourceInput)
    pub fn builder() -> crate::input::add_tags_to_resource_input::Builder {
        crate::input::add_tags_to_resource_input::Builder::default()
    }
}

/// See [`ApplyPendingMaintenanceActionInput`](crate::input::ApplyPendingMaintenanceActionInput)
pub mod apply_pending_maintenance_action_input {
    /// A builder for [`ApplyPendingMaintenanceActionInput`](crate::input::ApplyPendingMaintenanceActionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_identifier: std::option::Option<std::string::String>,
        pub(crate) apply_action: std::option::Option<std::string::String>,
        pub(crate) opt_in_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The RDS Amazon Resource Name (ARN) of the resource that the pending maintenance action applies to. For information about creating an ARN, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing"> Constructing an RDS Amazon Resource Name (ARN)</a>.</p>
        pub fn resource_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_identifier = Some(input.into());
            self
        }
        /// <p>The RDS Amazon Resource Name (ARN) of the resource that the pending maintenance action applies to. For information about creating an ARN, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing"> Constructing an RDS Amazon Resource Name (ARN)</a>.</p>
        pub fn set_resource_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_identifier = input;
            self
        }
        /// <p>The pending maintenance action to apply to this resource.</p>
        /// <p>Valid values: <code>system-update</code>, <code>db-upgrade</code>, <code>hardware-maintenance</code>, <code>ca-certificate-rotation</code> </p>
        pub fn apply_action(mut self, input: impl Into<std::string::String>) -> Self {
            self.apply_action = Some(input.into());
            self
        }
        /// <p>The pending maintenance action to apply to this resource.</p>
        /// <p>Valid values: <code>system-update</code>, <code>db-upgrade</code>, <code>hardware-maintenance</code>, <code>ca-certificate-rotation</code> </p>
        pub fn set_apply_action(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.apply_action = input;
            self
        }
        /// <p>A value that specifies the type of opt-in request, or undoes an opt-in request. An opt-in request of type <code>immediate</code> can't be undone.</p>
        /// <p>Valid values:</p>
        /// <ul>
        /// <li> <p> <code>immediate</code> - Apply the maintenance action immediately.</p> </li>
        /// <li> <p> <code>next-maintenance</code> - Apply the maintenance action during the next maintenance window for the resource.</p> </li>
        /// <li> <p> <code>undo-opt-in</code> - Cancel any existing <code>next-maintenance</code> opt-in requests.</p> </li>
        /// </ul>
        pub fn opt_in_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.opt_in_type = Some(input.into());
            self
        }
        /// <p>A value that specifies the type of opt-in request, or undoes an opt-in request. An opt-in request of type <code>immediate</code> can't be undone.</p>
        /// <p>Valid values:</p>
        /// <ul>
        /// <li> <p> <code>immediate</code> - Apply the maintenance action immediately.</p> </li>
        /// <li> <p> <code>next-maintenance</code> - Apply the maintenance action during the next maintenance window for the resource.</p> </li>
        /// <li> <p> <code>undo-opt-in</code> - Cancel any existing <code>next-maintenance</code> opt-in requests.</p> </li>
        /// </ul>
        pub fn set_opt_in_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.opt_in_type = input;
            self
        }
        /// Consumes the builder and constructs a [`ApplyPendingMaintenanceActionInput`](crate::input::ApplyPendingMaintenanceActionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ApplyPendingMaintenanceActionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ApplyPendingMaintenanceActionInput {
                resource_identifier: self.resource_identifier,
                apply_action: self.apply_action,
                opt_in_type: self.opt_in_type,
            })
        }
    }
}
#[doc(hidden)]
pub type ApplyPendingMaintenanceActionInputOperationOutputAlias =
    crate::operation::ApplyPendingMaintenanceAction;
#[doc(hidden)]
pub type ApplyPendingMaintenanceActionInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl ApplyPendingMaintenanceActionInput {
    /// Consumes the builder and constructs an Operation<[`ApplyPendingMaintenanceAction`](crate::operation::ApplyPendingMaintenanceAction)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ApplyPendingMaintenanceAction,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ApplyPendingMaintenanceActionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ApplyPendingMaintenanceActionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_apply_pending_maintenance_action(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ApplyPendingMaintenanceAction::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ApplyPendingMaintenanceAction",
            "rds",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ApplyPendingMaintenanceActionInput`](crate::input::ApplyPendingMaintenanceActionInput)
    pub fn builder() -> crate::input::apply_pending_maintenance_action_input::Builder {
        crate::input::apply_pending_maintenance_action_input::Builder::default()
    }
}

/// See [`AuthorizeDbSecurityGroupIngressInput`](crate::input::AuthorizeDbSecurityGroupIngressInput)
pub mod authorize_db_security_group_ingress_input {
    /// A builder for [`AuthorizeDbSecurityGroupIngressInput`](crate::input::AuthorizeDbSecurityGroupIngressInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_security_group_name: std::option::Option<std::string::String>,
        pub(crate) cidrip: std::option::Option<std::string::String>,
        pub(crate) ec2_security_group_name: std::option::Option<std::string::String>,
        pub(crate) ec2_security_group_id: std::option::Option<std::string::String>,
        pub(crate) ec2_security_group_owner_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the DB security group to add authorization to.</p>
        pub fn db_security_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_security_group_name = Some(input.into());
            self
        }
        /// <p>The name of the DB security group to add authorization to.</p>
        pub fn set_db_security_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_security_group_name = input;
            self
        }
        /// <p>The IP range to authorize.</p>
        pub fn cidrip(mut self, input: impl Into<std::string::String>) -> Self {
            self.cidrip = Some(input.into());
            self
        }
        /// <p>The IP range to authorize.</p>
        pub fn set_cidrip(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cidrip = input;
            self
        }
        /// <p>Name of the EC2 security group to authorize. For VPC DB security groups, <code>EC2SecurityGroupId</code> must be provided. Otherwise, <code>EC2SecurityGroupOwnerId</code> and either <code>EC2SecurityGroupName</code> or <code>EC2SecurityGroupId</code> must be provided.</p>
        pub fn ec2_security_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.ec2_security_group_name = Some(input.into());
            self
        }
        /// <p>Name of the EC2 security group to authorize. For VPC DB security groups, <code>EC2SecurityGroupId</code> must be provided. Otherwise, <code>EC2SecurityGroupOwnerId</code> and either <code>EC2SecurityGroupName</code> or <code>EC2SecurityGroupId</code> must be provided.</p>
        pub fn set_ec2_security_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ec2_security_group_name = input;
            self
        }
        /// <p>Id of the EC2 security group to authorize. For VPC DB security groups, <code>EC2SecurityGroupId</code> must be provided. Otherwise, <code>EC2SecurityGroupOwnerId</code> and either <code>EC2SecurityGroupName</code> or <code>EC2SecurityGroupId</code> must be provided.</p>
        pub fn ec2_security_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ec2_security_group_id = Some(input.into());
            self
        }
        /// <p>Id of the EC2 security group to authorize. For VPC DB security groups, <code>EC2SecurityGroupId</code> must be provided. Otherwise, <code>EC2SecurityGroupOwnerId</code> and either <code>EC2SecurityGroupName</code> or <code>EC2SecurityGroupId</code> must be provided.</p>
        pub fn set_ec2_security_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ec2_security_group_id = input;
            self
        }
        /// <p>Amazon Web Services account number of the owner of the EC2 security group specified in the <code>EC2SecurityGroupName</code> parameter. The Amazon Web Services access key ID isn't an acceptable value. For VPC DB security groups, <code>EC2SecurityGroupId</code> must be provided. Otherwise, <code>EC2SecurityGroupOwnerId</code> and either <code>EC2SecurityGroupName</code> or <code>EC2SecurityGroupId</code> must be provided.</p>
        pub fn ec2_security_group_owner_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.ec2_security_group_owner_id = Some(input.into());
            self
        }
        /// <p>Amazon Web Services account number of the owner of the EC2 security group specified in the <code>EC2SecurityGroupName</code> parameter. The Amazon Web Services access key ID isn't an acceptable value. For VPC DB security groups, <code>EC2SecurityGroupId</code> must be provided. Otherwise, <code>EC2SecurityGroupOwnerId</code> and either <code>EC2SecurityGroupName</code> or <code>EC2SecurityGroupId</code> must be provided.</p>
        pub fn set_ec2_security_group_owner_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ec2_security_group_owner_id = input;
            self
        }
        /// Consumes the builder and constructs a [`AuthorizeDbSecurityGroupIngressInput`](crate::input::AuthorizeDbSecurityGroupIngressInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AuthorizeDbSecurityGroupIngressInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AuthorizeDbSecurityGroupIngressInput {
                db_security_group_name: self.db_security_group_name,
                cidrip: self.cidrip,
                ec2_security_group_name: self.ec2_security_group_name,
                ec2_security_group_id: self.ec2_security_group_id,
                ec2_security_group_owner_id: self.ec2_security_group_owner_id,
            })
        }
    }
}
#[doc(hidden)]
pub type AuthorizeDbSecurityGroupIngressInputOperationOutputAlias =
    crate::operation::AuthorizeDBSecurityGroupIngress;
#[doc(hidden)]
pub type AuthorizeDbSecurityGroupIngressInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl AuthorizeDbSecurityGroupIngressInput {
    /// Consumes the builder and constructs an Operation<[`AuthorizeDBSecurityGroupIngress`](crate::operation::AuthorizeDBSecurityGroupIngress)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AuthorizeDBSecurityGroupIngress,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::AuthorizeDbSecurityGroupIngressInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::AuthorizeDbSecurityGroupIngressInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_authorize_db_security_group_ingress(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AuthorizeDBSecurityGroupIngress::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AuthorizeDBSecurityGroupIngress",
            "rds",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`AuthorizeDbSecurityGroupIngressInput`](crate::input::AuthorizeDbSecurityGroupIngressInput)
    pub fn builder() -> crate::input::authorize_db_security_group_ingress_input::Builder {
        crate::input::authorize_db_security_group_ingress_input::Builder::default()
    }
}

/// See [`BacktrackDbClusterInput`](crate::input::BacktrackDbClusterInput)
pub mod backtrack_db_cluster_input {
    /// A builder for [`BacktrackDbClusterInput`](crate::input::BacktrackDbClusterInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) backtrack_to: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) force: std::option::Option<bool>,
        pub(crate) use_earliest_time_on_point_in_time_unavailable: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The DB cluster identifier of the DB cluster to be backtracked. This parameter is stored as a lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must contain from 1 to 63 alphanumeric characters or hyphens.</p> </li>
        /// <li> <p>First character must be a letter.</p> </li>
        /// <li> <p>Can't end with a hyphen or contain two consecutive hyphens.</p> </li>
        /// </ul>
        /// <p>Example: <code>my-cluster1</code> </p>
        pub fn db_cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_cluster_identifier = Some(input.into());
            self
        }
        /// <p>The DB cluster identifier of the DB cluster to be backtracked. This parameter is stored as a lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must contain from 1 to 63 alphanumeric characters or hyphens.</p> </li>
        /// <li> <p>First character must be a letter.</p> </li>
        /// <li> <p>Can't end with a hyphen or contain two consecutive hyphens.</p> </li>
        /// </ul>
        /// <p>Example: <code>my-cluster1</code> </p>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_identifier = input;
            self
        }
        /// <p>The timestamp of the time to backtrack the DB cluster to, specified in ISO 8601 format. For more information about ISO 8601, see the <a href="http://en.wikipedia.org/wiki/ISO_8601">ISO8601 Wikipedia page.</a> </p> <note>
        /// <p>If the specified time isn't a consistent time for the DB cluster, Aurora automatically chooses the nearest possible consistent time for the DB cluster.</p>
        /// </note>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must contain a valid ISO 8601 timestamp.</p> </li>
        /// <li> <p>Can't contain a timestamp set in the future.</p> </li>
        /// </ul>
        /// <p>Example: <code>2017-07-08T18:00Z</code> </p>
        pub fn backtrack_to(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.backtrack_to = Some(input);
            self
        }
        /// <p>The timestamp of the time to backtrack the DB cluster to, specified in ISO 8601 format. For more information about ISO 8601, see the <a href="http://en.wikipedia.org/wiki/ISO_8601">ISO8601 Wikipedia page.</a> </p> <note>
        /// <p>If the specified time isn't a consistent time for the DB cluster, Aurora automatically chooses the nearest possible consistent time for the DB cluster.</p>
        /// </note>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must contain a valid ISO 8601 timestamp.</p> </li>
        /// <li> <p>Can't contain a timestamp set in the future.</p> </li>
        /// </ul>
        /// <p>Example: <code>2017-07-08T18:00Z</code> </p>
        pub fn set_backtrack_to(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.backtrack_to = input;
            self
        }
        /// <p>A value that indicates whether to force the DB cluster to backtrack when binary logging is enabled. Otherwise, an error occurs when binary logging is enabled.</p>
        pub fn force(mut self, input: bool) -> Self {
            self.force = Some(input);
            self
        }
        /// <p>A value that indicates whether to force the DB cluster to backtrack when binary logging is enabled. Otherwise, an error occurs when binary logging is enabled.</p>
        pub fn set_force(mut self, input: std::option::Option<bool>) -> Self {
            self.force = input;
            self
        }
        /// <p>A value that indicates whether to backtrack the DB cluster to the earliest possible backtrack time when <i>BacktrackTo</i> is set to a timestamp earlier than the earliest backtrack time. When this parameter is disabled and <i>BacktrackTo</i> is set to a timestamp earlier than the earliest backtrack time, an error occurs.</p>
        pub fn use_earliest_time_on_point_in_time_unavailable(mut self, input: bool) -> Self {
            self.use_earliest_time_on_point_in_time_unavailable = Some(input);
            self
        }
        /// <p>A value that indicates whether to backtrack the DB cluster to the earliest possible backtrack time when <i>BacktrackTo</i> is set to a timestamp earlier than the earliest backtrack time. When this parameter is disabled and <i>BacktrackTo</i> is set to a timestamp earlier than the earliest backtrack time, an error occurs.</p>
        pub fn set_use_earliest_time_on_point_in_time_unavailable(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.use_earliest_time_on_point_in_time_unavailable = input;
            self
        }
        /// Consumes the builder and constructs a [`BacktrackDbClusterInput`](crate::input::BacktrackDbClusterInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BacktrackDbClusterInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::BacktrackDbClusterInput {
                db_cluster_identifier: self.db_cluster_identifier,
                backtrack_to: self.backtrack_to,
                force: self.force,
                use_earliest_time_on_point_in_time_unavailable: self
                    .use_earliest_time_on_point_in_time_unavailable,
            })
        }
    }
}
#[doc(hidden)]
pub type BacktrackDbClusterInputOperationOutputAlias = crate::operation::BacktrackDBCluster;
#[doc(hidden)]
pub type BacktrackDbClusterInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl BacktrackDbClusterInput {
    /// Consumes the builder and constructs an Operation<[`BacktrackDBCluster`](crate::operation::BacktrackDBCluster)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BacktrackDBCluster,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::BacktrackDbClusterInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::BacktrackDbClusterInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_backtrack_db_cluster(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BacktrackDBCluster::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BacktrackDBCluster",
            "rds",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`BacktrackDbClusterInput`](crate::input::BacktrackDbClusterInput)
    pub fn builder() -> crate::input::backtrack_db_cluster_input::Builder {
        crate::input::backtrack_db_cluster_input::Builder::default()
    }
}

/// See [`CancelExportTaskInput`](crate::input::CancelExportTaskInput)
pub mod cancel_export_task_input {
    /// A builder for [`CancelExportTaskInput`](crate::input::CancelExportTaskInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) export_task_identifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the snapshot export task to cancel.</p>
        pub fn export_task_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.export_task_identifier = Some(input.into());
            self
        }
        /// <p>The identifier of the snapshot export task to cancel.</p>
        pub fn set_export_task_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.export_task_identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`CancelExportTaskInput`](crate::input::CancelExportTaskInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CancelExportTaskInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CancelExportTaskInput {
                export_task_identifier: self.export_task_identifier,
            })
        }
    }
}
#[doc(hidden)]
pub type CancelExportTaskInputOperationOutputAlias = crate::operation::CancelExportTask;
#[doc(hidden)]
pub type CancelExportTaskInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CancelExportTaskInput {
    /// Consumes the builder and constructs an Operation<[`CancelExportTask`](crate::operation::CancelExportTask)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CancelExportTask,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CancelExportTaskInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CancelExportTaskInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_cancel_export_task(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CancelExportTask::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CancelExportTask",
            "rds",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CancelExportTaskInput`](crate::input::CancelExportTaskInput)
    pub fn builder() -> crate::input::cancel_export_task_input::Builder {
        crate::input::cancel_export_task_input::Builder::default()
    }
}

/// See [`CopyDbClusterParameterGroupInput`](crate::input::CopyDbClusterParameterGroupInput)
pub mod copy_db_cluster_parameter_group_input {
    /// A builder for [`CopyDbClusterParameterGroupInput`](crate::input::CopyDbClusterParameterGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_db_cluster_parameter_group_identifier:
            std::option::Option<std::string::String>,
        pub(crate) target_db_cluster_parameter_group_identifier:
            std::option::Option<std::string::String>,
        pub(crate) target_db_cluster_parameter_group_description:
            std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The identifier or Amazon Resource Name (ARN) for the source DB cluster parameter group. For information about creating an ARN, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing"> Constructing an ARN for Amazon RDS</a> in the <i>Amazon Aurora User Guide</i>.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must specify a valid DB cluster parameter group.</p> </li>
        /// </ul>
        pub fn source_db_cluster_parameter_group_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.source_db_cluster_parameter_group_identifier = Some(input.into());
            self
        }
        /// <p>The identifier or Amazon Resource Name (ARN) for the source DB cluster parameter group. For information about creating an ARN, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing"> Constructing an ARN for Amazon RDS</a> in the <i>Amazon Aurora User Guide</i>.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must specify a valid DB cluster parameter group.</p> </li>
        /// </ul>
        pub fn set_source_db_cluster_parameter_group_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_db_cluster_parameter_group_identifier = input;
            self
        }
        /// <p>The identifier for the copied DB cluster parameter group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Can't be null, empty, or blank</p> </li>
        /// <li> <p>Must contain from 1 to 255 letters, numbers, or hyphens</p> </li>
        /// <li> <p>First character must be a letter</p> </li>
        /// <li> <p>Can't end with a hyphen or contain two consecutive hyphens</p> </li>
        /// </ul>
        /// <p>Example: <code>my-cluster-param-group1</code> </p>
        pub fn target_db_cluster_parameter_group_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.target_db_cluster_parameter_group_identifier = Some(input.into());
            self
        }
        /// <p>The identifier for the copied DB cluster parameter group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Can't be null, empty, or blank</p> </li>
        /// <li> <p>Must contain from 1 to 255 letters, numbers, or hyphens</p> </li>
        /// <li> <p>First character must be a letter</p> </li>
        /// <li> <p>Can't end with a hyphen or contain two consecutive hyphens</p> </li>
        /// </ul>
        /// <p>Example: <code>my-cluster-param-group1</code> </p>
        pub fn set_target_db_cluster_parameter_group_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_db_cluster_parameter_group_identifier = input;
            self
        }
        /// <p>A description for the copied DB cluster parameter group.</p>
        pub fn target_db_cluster_parameter_group_description(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.target_db_cluster_parameter_group_description = Some(input.into());
            self
        }
        /// <p>A description for the copied DB cluster parameter group.</p>
        pub fn set_target_db_cluster_parameter_group_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_db_cluster_parameter_group_description = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources</a> in the <i>Amazon RDS User Guide.</i> </p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>A list of tags. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources</a> in the <i>Amazon RDS User Guide.</i> </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CopyDbClusterParameterGroupInput`](crate::input::CopyDbClusterParameterGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CopyDbClusterParameterGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CopyDbClusterParameterGroupInput {
                source_db_cluster_parameter_group_identifier: self
                    .source_db_cluster_parameter_group_identifier,
                target_db_cluster_parameter_group_identifier: self
                    .target_db_cluster_parameter_group_identifier,
                target_db_cluster_parameter_group_description: self
                    .target_db_cluster_parameter_group_description,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CopyDbClusterParameterGroupInputOperationOutputAlias =
    crate::operation::CopyDBClusterParameterGroup;
#[doc(hidden)]
pub type CopyDbClusterParameterGroupInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CopyDbClusterParameterGroupInput {
    /// Consumes the builder and constructs an Operation<[`CopyDBClusterParameterGroup`](crate::operation::CopyDBClusterParameterGroup)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CopyDBClusterParameterGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CopyDbClusterParameterGroupInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CopyDbClusterParameterGroupInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_copy_db_cluster_parameter_group(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CopyDBClusterParameterGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CopyDBClusterParameterGroup",
            "rds",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CopyDbClusterParameterGroupInput`](crate::input::CopyDbClusterParameterGroupInput)
    pub fn builder() -> crate::input::copy_db_cluster_parameter_group_input::Builder {
        crate::input::copy_db_cluster_parameter_group_input::Builder::default()
    }
}

/// See [`CopyDbClusterSnapshotInput`](crate::input::CopyDbClusterSnapshotInput)
pub mod copy_db_cluster_snapshot_input {
    /// A builder for [`CopyDbClusterSnapshotInput`](crate::input::CopyDbClusterSnapshotInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_db_cluster_snapshot_identifier: std::option::Option<std::string::String>,
        pub(crate) target_db_cluster_snapshot_identifier: std::option::Option<std::string::String>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
        pub(crate) pre_signed_url: std::option::Option<std::string::String>,
        pub(crate) copy_tags: std::option::Option<bool>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The identifier of the DB cluster snapshot to copy. This parameter isn't case-sensitive.</p>
        /// <p>You can't copy an encrypted, shared DB cluster snapshot from one Amazon Web Services Region to another.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must specify a valid system snapshot in the "available" state.</p> </li>
        /// <li> <p>If the source snapshot is in the same Amazon Web Services Region as the copy, specify a valid DB snapshot identifier.</p> </li>
        /// <li> <p>If the source snapshot is in a different Amazon Web Services Region than the copy, specify a valid DB cluster snapshot ARN. For more information, go to <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_CopySnapshot.html#USER_CopySnapshot.AcrossRegions"> Copying Snapshots Across Amazon Web Services Regions</a> in the <i>Amazon Aurora User Guide</i>.</p> </li>
        /// </ul>
        /// <p>Example: <code>my-cluster-snapshot1</code> </p>
        pub fn source_db_cluster_snapshot_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.source_db_cluster_snapshot_identifier = Some(input.into());
            self
        }
        /// <p>The identifier of the DB cluster snapshot to copy. This parameter isn't case-sensitive.</p>
        /// <p>You can't copy an encrypted, shared DB cluster snapshot from one Amazon Web Services Region to another.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must specify a valid system snapshot in the "available" state.</p> </li>
        /// <li> <p>If the source snapshot is in the same Amazon Web Services Region as the copy, specify a valid DB snapshot identifier.</p> </li>
        /// <li> <p>If the source snapshot is in a different Amazon Web Services Region than the copy, specify a valid DB cluster snapshot ARN. For more information, go to <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_CopySnapshot.html#USER_CopySnapshot.AcrossRegions"> Copying Snapshots Across Amazon Web Services Regions</a> in the <i>Amazon Aurora User Guide</i>.</p> </li>
        /// </ul>
        /// <p>Example: <code>my-cluster-snapshot1</code> </p>
        pub fn set_source_db_cluster_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_db_cluster_snapshot_identifier = input;
            self
        }
        /// <p>The identifier of the new DB cluster snapshot to create from the source DB cluster snapshot. This parameter isn't case-sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p> </li>
        /// <li> <p>First character must be a letter.</p> </li>
        /// <li> <p>Can't end with a hyphen or contain two consecutive hyphens.</p> </li>
        /// </ul>
        /// <p>Example: <code>my-cluster-snapshot2</code> </p>
        pub fn target_db_cluster_snapshot_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.target_db_cluster_snapshot_identifier = Some(input.into());
            self
        }
        /// <p>The identifier of the new DB cluster snapshot to create from the source DB cluster snapshot. This parameter isn't case-sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p> </li>
        /// <li> <p>First character must be a letter.</p> </li>
        /// <li> <p>Can't end with a hyphen or contain two consecutive hyphens.</p> </li>
        /// </ul>
        /// <p>Example: <code>my-cluster-snapshot2</code> </p>
        pub fn set_target_db_cluster_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_db_cluster_snapshot_identifier = input;
            self
        }
        /// <p>The Amazon Web Services KMS key identifier for an encrypted DB cluster snapshot. The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the Amazon Web Services KMS key.</p>
        /// <p>If you copy an encrypted DB cluster snapshot from your Amazon Web Services account, you can specify a value for <code>KmsKeyId</code> to encrypt the copy with a new KMS key. If you don't specify a value for <code>KmsKeyId</code>, then the copy of the DB cluster snapshot is encrypted with the same KMS key as the source DB cluster snapshot.</p>
        /// <p>If you copy an encrypted DB cluster snapshot that is shared from another Amazon Web Services account, then you must specify a value for <code>KmsKeyId</code>.</p>
        /// <p>To copy an encrypted DB cluster snapshot to another Amazon Web Services Region, you must set <code>KmsKeyId</code> to the Amazon Web Services KMS key identifier you want to use to encrypt the copy of the DB cluster snapshot in the destination Amazon Web Services Region. KMS keys are specific to the Amazon Web Services Region that they are created in, and you can't use KMS keys from one Amazon Web Services Region in another Amazon Web Services Region.</p>
        /// <p>If you copy an unencrypted DB cluster snapshot and specify a value for the <code>KmsKeyId</code> parameter, an error is returned.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services KMS key identifier for an encrypted DB cluster snapshot. The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the Amazon Web Services KMS key.</p>
        /// <p>If you copy an encrypted DB cluster snapshot from your Amazon Web Services account, you can specify a value for <code>KmsKeyId</code> to encrypt the copy with a new KMS key. If you don't specify a value for <code>KmsKeyId</code>, then the copy of the DB cluster snapshot is encrypted with the same KMS key as the source DB cluster snapshot.</p>
        /// <p>If you copy an encrypted DB cluster snapshot that is shared from another Amazon Web Services account, then you must specify a value for <code>KmsKeyId</code>.</p>
        /// <p>To copy an encrypted DB cluster snapshot to another Amazon Web Services Region, you must set <code>KmsKeyId</code> to the Amazon Web Services KMS key identifier you want to use to encrypt the copy of the DB cluster snapshot in the destination Amazon Web Services Region. KMS keys are specific to the Amazon Web Services Region that they are created in, and you can't use KMS keys from one Amazon Web Services Region in another Amazon Web Services Region.</p>
        /// <p>If you copy an unencrypted DB cluster snapshot and specify a value for the <code>KmsKeyId</code> parameter, an error is returned.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// <p>The URL that contains a Signature Version 4 signed request for the <code>CopyDBClusterSnapshot</code> API action in the Amazon Web Services Region that contains the source DB cluster snapshot to copy. The <code>PreSignedUrl</code> parameter must be used when copying an encrypted DB cluster snapshot from another Amazon Web Services Region. Don't specify <code>PreSignedUrl</code> when you are copying an encrypted DB cluster snapshot in the same Amazon Web Services Region.</p>
        /// <p>The pre-signed URL must be a valid request for the <code>CopyDBClusterSnapshot</code> API action that can be executed in the source Amazon Web Services Region that contains the encrypted DB cluster snapshot to be copied. The pre-signed URL request must contain the following parameter values:</p>
        /// <ul>
        /// <li> <p> <code>KmsKeyId</code> - The Amazon Web Services KMS key identifier for the KMS key to use to encrypt the copy of the DB cluster snapshot in the destination Amazon Web Services Region. This is the same identifier for both the <code>CopyDBClusterSnapshot</code> action that is called in the destination Amazon Web Services Region, and the action contained in the pre-signed URL.</p> </li>
        /// <li> <p> <code>DestinationRegion</code> - The name of the Amazon Web Services Region that the DB cluster snapshot is to be created in.</p> </li>
        /// <li> <p> <code>SourceDBClusterSnapshotIdentifier</code> - The DB cluster snapshot identifier for the encrypted DB cluster snapshot to be copied. This identifier must be in the Amazon Resource Name (ARN) format for the source Amazon Web Services Region. For example, if you are copying an encrypted DB cluster snapshot from the us-west-2 Amazon Web Services Region, then your <code>SourceDBClusterSnapshotIdentifier</code> looks like the following example: <code>arn:aws:rds:us-west-2:123456789012:cluster-snapshot:aurora-cluster1-snapshot-20161115</code>.</p> </li>
        /// </ul>
        /// <p>To learn how to generate a Signature Version 4 signed request, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html"> Authenticating Requests: Using Query Parameters (Amazon Web Services Signature Version 4)</a> and <a href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html"> Signature Version 4 Signing Process</a>.</p> <note>
        /// <p>If you are using an Amazon Web Services SDK tool or the CLI, you can specify <code>SourceRegion</code> (or <code>--source-region</code> for the CLI) instead of specifying <code>PreSignedUrl</code> manually. Specifying <code>SourceRegion</code> autogenerates a pre-signed URL that is a valid request for the operation that can be executed in the source Amazon Web Services Region.</p>
        /// </note>
        pub fn pre_signed_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.pre_signed_url = Some(input.into());
            self
        }
        /// <p>The URL that contains a Signature Version 4 signed request for the <code>CopyDBClusterSnapshot</code> API action in the Amazon Web Services Region that contains the source DB cluster snapshot to copy. The <code>PreSignedUrl</code> parameter must be used when copying an encrypted DB cluster snapshot from another Amazon Web Services Region. Don't specify <code>PreSignedUrl</code> when you are copying an encrypted DB cluster snapshot in the same Amazon Web Services Region.</p>
        /// <p>The pre-signed URL must be a valid request for the <code>CopyDBClusterSnapshot</code> API action that can be executed in the source Amazon Web Services Region that contains the encrypted DB cluster snapshot to be copied. The pre-signed URL request must contain the following parameter values:</p>
        /// <ul>
        /// <li> <p> <code>KmsKeyId</code> - The Amazon Web Services KMS key identifier for the KMS key to use to encrypt the copy of the DB cluster snapshot in the destination Amazon Web Services Region. This is the same identifier for both the <code>CopyDBClusterSnapshot</code> action that is called in the destination Amazon Web Services Region, and the action contained in the pre-signed URL.</p> </li>
        /// <li> <p> <code>DestinationRegion</code> - The name of the Amazon Web Services Region that the DB cluster snapshot is to be created in.</p> </li>
        /// <li> <p> <code>SourceDBClusterSnapshotIdentifier</code> - The DB cluster snapshot identifier for the encrypted DB cluster snapshot to be copied. This identifier must be in the Amazon Resource Name (ARN) format for the source Amazon Web Services Region. For example, if you are copying an encrypted DB cluster snapshot from the us-west-2 Amazon Web Services Region, then your <code>SourceDBClusterSnapshotIdentifier</code> looks like the following example: <code>arn:aws:rds:us-west-2:123456789012:cluster-snapshot:aurora-cluster1-snapshot-20161115</code>.</p> </li>
        /// </ul>
        /// <p>To learn how to generate a Signature Version 4 signed request, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html"> Authenticating Requests: Using Query Parameters (Amazon Web Services Signature Version 4)</a> and <a href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html"> Signature Version 4 Signing Process</a>.</p> <note>
        /// <p>If you are using an Amazon Web Services SDK tool or the CLI, you can specify <code>SourceRegion</code> (or <code>--source-region</code> for the CLI) instead of specifying <code>PreSignedUrl</code> manually. Specifying <code>SourceRegion</code> autogenerates a pre-signed URL that is a valid request for the operation that can be executed in the source Amazon Web Services Region.</p>
        /// </note>
        pub fn set_pre_signed_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pre_signed_url = input;
            self
        }
        /// <p>A value that indicates whether to copy all tags from the source DB cluster snapshot to the target DB cluster snapshot. By default, tags are not copied.</p>
        pub fn copy_tags(mut self, input: bool) -> Self {
            self.copy_tags = Some(input);
            self
        }
        /// <p>A value that indicates whether to copy all tags from the source DB cluster snapshot to the target DB cluster snapshot. By default, tags are not copied.</p>
        pub fn set_copy_tags(mut self, input: std::option::Option<bool>) -> Self {
            self.copy_tags = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources</a> in the <i>Amazon RDS User Guide.</i> </p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>A list of tags. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources</a> in the <i>Amazon RDS User Guide.</i> </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CopyDbClusterSnapshotInput`](crate::input::CopyDbClusterSnapshotInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CopyDbClusterSnapshotInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CopyDbClusterSnapshotInput {
                source_db_cluster_snapshot_identifier: self.source_db_cluster_snapshot_identifier,
                target_db_cluster_snapshot_identifier: self.target_db_cluster_snapshot_identifier,
                kms_key_id: self.kms_key_id,
                pre_signed_url: self.pre_signed_url,
                copy_tags: self.copy_tags,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CopyDbClusterSnapshotInputOperationOutputAlias = crate::operation::CopyDBClusterSnapshot;
#[doc(hidden)]
pub type CopyDbClusterSnapshotInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CopyDbClusterSnapshotInput {
    /// Consumes the builder and constructs an Operation<[`CopyDBClusterSnapshot`](crate::operation::CopyDBClusterSnapshot)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CopyDBClusterSnapshot,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CopyDbClusterSnapshotInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CopyDbClusterSnapshotInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_copy_db_cluster_snapshot(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CopyDBClusterSnapshot::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CopyDBClusterSnapshot",
            "rds",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CopyDbClusterSnapshotInput`](crate::input::CopyDbClusterSnapshotInput)
    pub fn builder() -> crate::input::copy_db_cluster_snapshot_input::Builder {
        crate::input::copy_db_cluster_snapshot_input::Builder::default()
    }
}

/// See [`CopyDbParameterGroupInput`](crate::input::CopyDbParameterGroupInput)
pub mod copy_db_parameter_group_input {
    /// A builder for [`CopyDbParameterGroupInput`](crate::input::CopyDbParameterGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_db_parameter_group_identifier: std::option::Option<std::string::String>,
        pub(crate) target_db_parameter_group_identifier: std::option::Option<std::string::String>,
        pub(crate) target_db_parameter_group_description: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The identifier or ARN for the source DB parameter group. For information about creating an ARN, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing"> Constructing an ARN for Amazon RDS</a> in the <i>Amazon RDS User Guide</i>.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must specify a valid DB parameter group.</p> </li>
        /// </ul>
        pub fn source_db_parameter_group_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.source_db_parameter_group_identifier = Some(input.into());
            self
        }
        /// <p>The identifier or ARN for the source DB parameter group. For information about creating an ARN, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing"> Constructing an ARN for Amazon RDS</a> in the <i>Amazon RDS User Guide</i>.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must specify a valid DB parameter group.</p> </li>
        /// </ul>
        pub fn set_source_db_parameter_group_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_db_parameter_group_identifier = input;
            self
        }
        /// <p>The identifier for the copied DB parameter group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Can't be null, empty, or blank</p> </li>
        /// <li> <p>Must contain from 1 to 255 letters, numbers, or hyphens</p> </li>
        /// <li> <p>First character must be a letter</p> </li>
        /// <li> <p>Can't end with a hyphen or contain two consecutive hyphens</p> </li>
        /// </ul>
        /// <p>Example: <code>my-db-parameter-group</code> </p>
        pub fn target_db_parameter_group_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.target_db_parameter_group_identifier = Some(input.into());
            self
        }
        /// <p>The identifier for the copied DB parameter group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Can't be null, empty, or blank</p> </li>
        /// <li> <p>Must contain from 1 to 255 letters, numbers, or hyphens</p> </li>
        /// <li> <p>First character must be a letter</p> </li>
        /// <li> <p>Can't end with a hyphen or contain two consecutive hyphens</p> </li>
        /// </ul>
        /// <p>Example: <code>my-db-parameter-group</code> </p>
        pub fn set_target_db_parameter_group_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_db_parameter_group_identifier = input;
            self
        }
        /// <p>A description for the copied DB parameter group.</p>
        pub fn target_db_parameter_group_description(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.target_db_parameter_group_description = Some(input.into());
            self
        }
        /// <p>A description for the copied DB parameter group.</p>
        pub fn set_target_db_parameter_group_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_db_parameter_group_description = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources</a> in the <i>Amazon RDS User Guide.</i> </p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>A list of tags. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources</a> in the <i>Amazon RDS User Guide.</i> </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CopyDbParameterGroupInput`](crate::input::CopyDbParameterGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CopyDbParameterGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CopyDbParameterGroupInput {
                source_db_parameter_group_identifier: self.source_db_parameter_group_identifier,
                target_db_parameter_group_identifier: self.target_db_parameter_group_identifier,
                target_db_parameter_group_description: self.target_db_parameter_group_description,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CopyDbParameterGroupInputOperationOutputAlias = crate::operation::CopyDBParameterGroup;
#[doc(hidden)]
pub type CopyDbParameterGroupInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CopyDbParameterGroupInput {
    /// Consumes the builder and constructs an Operation<[`CopyDBParameterGroup`](crate::operation::CopyDBParameterGroup)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CopyDBParameterGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CopyDbParameterGroupInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CopyDbParameterGroupInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_copy_db_parameter_group(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CopyDBParameterGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CopyDBParameterGroup",
            "rds",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CopyDbParameterGroupInput`](crate::input::CopyDbParameterGroupInput)
    pub fn builder() -> crate::input::copy_db_parameter_group_input::Builder {
        crate::input::copy_db_parameter_group_input::Builder::default()
    }
}

/// See [`CopyDbSnapshotInput`](crate::input::CopyDbSnapshotInput)
pub mod copy_db_snapshot_input {
    /// A builder for [`CopyDbSnapshotInput`](crate::input::CopyDbSnapshotInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_db_snapshot_identifier: std::option::Option<std::string::String>,
        pub(crate) target_db_snapshot_identifier: std::option::Option<std::string::String>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) copy_tags: std::option::Option<bool>,
        pub(crate) pre_signed_url: std::option::Option<std::string::String>,
        pub(crate) option_group_name: std::option::Option<std::string::String>,
        pub(crate) target_custom_availability_zone: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier for the source DB snapshot.</p>
        /// <p>If the source snapshot is in the same Amazon Web Services Region as the copy, specify a valid DB snapshot identifier. For example, you might specify <code>rds:mysql-instance1-snapshot-20130805</code>.</p>
        /// <p>If the source snapshot is in a different Amazon Web Services Region than the copy, specify a valid DB snapshot ARN. For example, you might specify <code>arn:aws:rds:us-west-2:123456789012:snapshot:mysql-instance1-snapshot-20130805</code>.</p>
        /// <p>If you are copying from a shared manual DB snapshot, this parameter must be the Amazon Resource Name (ARN) of the shared DB snapshot.</p>
        /// <p>If you are copying an encrypted snapshot this parameter must be in the ARN format for the source Amazon Web Services Region, and must match the <code>SourceDBSnapshotIdentifier</code> in the <code>PreSignedUrl</code> parameter.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must specify a valid system snapshot in the "available" state.</p> </li>
        /// </ul>
        /// <p>Example: <code>rds:mydb-2012-04-02-00-01</code> </p>
        /// <p>Example: <code>arn:aws:rds:us-west-2:123456789012:snapshot:mysql-instance1-snapshot-20130805</code> </p>
        pub fn source_db_snapshot_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.source_db_snapshot_identifier = Some(input.into());
            self
        }
        /// <p>The identifier for the source DB snapshot.</p>
        /// <p>If the source snapshot is in the same Amazon Web Services Region as the copy, specify a valid DB snapshot identifier. For example, you might specify <code>rds:mysql-instance1-snapshot-20130805</code>.</p>
        /// <p>If the source snapshot is in a different Amazon Web Services Region than the copy, specify a valid DB snapshot ARN. For example, you might specify <code>arn:aws:rds:us-west-2:123456789012:snapshot:mysql-instance1-snapshot-20130805</code>.</p>
        /// <p>If you are copying from a shared manual DB snapshot, this parameter must be the Amazon Resource Name (ARN) of the shared DB snapshot.</p>
        /// <p>If you are copying an encrypted snapshot this parameter must be in the ARN format for the source Amazon Web Services Region, and must match the <code>SourceDBSnapshotIdentifier</code> in the <code>PreSignedUrl</code> parameter.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must specify a valid system snapshot in the "available" state.</p> </li>
        /// </ul>
        /// <p>Example: <code>rds:mydb-2012-04-02-00-01</code> </p>
        /// <p>Example: <code>arn:aws:rds:us-west-2:123456789012:snapshot:mysql-instance1-snapshot-20130805</code> </p>
        pub fn set_source_db_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_db_snapshot_identifier = input;
            self
        }
        /// <p>The identifier for the copy of the snapshot.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Can't be null, empty, or blank</p> </li>
        /// <li> <p>Must contain from 1 to 255 letters, numbers, or hyphens</p> </li>
        /// <li> <p>First character must be a letter</p> </li>
        /// <li> <p>Can't end with a hyphen or contain two consecutive hyphens</p> </li>
        /// </ul>
        /// <p>Example: <code>my-db-snapshot</code> </p>
        pub fn target_db_snapshot_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.target_db_snapshot_identifier = Some(input.into());
            self
        }
        /// <p>The identifier for the copy of the snapshot.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Can't be null, empty, or blank</p> </li>
        /// <li> <p>Must contain from 1 to 255 letters, numbers, or hyphens</p> </li>
        /// <li> <p>First character must be a letter</p> </li>
        /// <li> <p>Can't end with a hyphen or contain two consecutive hyphens</p> </li>
        /// </ul>
        /// <p>Example: <code>my-db-snapshot</code> </p>
        pub fn set_target_db_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_db_snapshot_identifier = input;
            self
        }
        /// <p>The Amazon Web Services KMS key identifier for an encrypted DB snapshot. The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.</p>
        /// <p>If you copy an encrypted DB snapshot from your Amazon Web Services account, you can specify a value for this parameter to encrypt the copy with a new KMS key. If you don't specify a value for this parameter, then the copy of the DB snapshot is encrypted with the same Amazon Web Services KMS key as the source DB snapshot.</p>
        /// <p>If you copy an encrypted DB snapshot that is shared from another Amazon Web Services account, then you must specify a value for this parameter.</p>
        /// <p>If you specify this parameter when you copy an unencrypted snapshot, the copy is encrypted.</p>
        /// <p>If you copy an encrypted snapshot to a different Amazon Web Services Region, then you must specify an Amazon Web Services KMS key identifier for the destination Amazon Web Services Region. KMS keys are specific to the Amazon Web Services Region that they are created in, and you can't use KMS keys from one Amazon Web Services Region in another Amazon Web Services Region.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services KMS key identifier for an encrypted DB snapshot. The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.</p>
        /// <p>If you copy an encrypted DB snapshot from your Amazon Web Services account, you can specify a value for this parameter to encrypt the copy with a new KMS key. If you don't specify a value for this parameter, then the copy of the DB snapshot is encrypted with the same Amazon Web Services KMS key as the source DB snapshot.</p>
        /// <p>If you copy an encrypted DB snapshot that is shared from another Amazon Web Services account, then you must specify a value for this parameter.</p>
        /// <p>If you specify this parameter when you copy an unencrypted snapshot, the copy is encrypted.</p>
        /// <p>If you copy an encrypted snapshot to a different Amazon Web Services Region, then you must specify an Amazon Web Services KMS key identifier for the destination Amazon Web Services Region. KMS keys are specific to the Amazon Web Services Region that they are created in, and you can't use KMS keys from one Amazon Web Services Region in another Amazon Web Services Region.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources</a> in the <i>Amazon RDS User Guide.</i> </p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>A list of tags. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources</a> in the <i>Amazon RDS User Guide.</i> </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>A value that indicates whether to copy all tags from the source DB snapshot to the target DB snapshot. By default, tags are not copied.</p>
        pub fn copy_tags(mut self, input: bool) -> Self {
            self.copy_tags = Some(input);
            self
        }
        /// <p>A value that indicates whether to copy all tags from the source DB snapshot to the target DB snapshot. By default, tags are not copied.</p>
        pub fn set_copy_tags(mut self, input: std::option::Option<bool>) -> Self {
            self.copy_tags = input;
            self
        }
        /// <p>The URL that contains a Signature Version 4 signed request for the <code>CopyDBSnapshot</code> API action in the source Amazon Web Services Region that contains the source DB snapshot to copy.</p>
        /// <p>You must specify this parameter when you copy an encrypted DB snapshot from another Amazon Web Services Region by using the Amazon RDS API. Don't specify <code>PreSignedUrl</code> when you are copying an encrypted DB snapshot in the same Amazon Web Services Region.</p>
        /// <p>The presigned URL must be a valid request for the <code>CopyDBSnapshot</code> API action that can be executed in the source Amazon Web Services Region that contains the encrypted DB snapshot to be copied. The presigned URL request must contain the following parameter values:</p>
        /// <ul>
        /// <li> <p> <code>DestinationRegion</code> - The Amazon Web Services Region that the encrypted DB snapshot is copied to. This Amazon Web Services Region is the same one where the <code>CopyDBSnapshot</code> action is called that contains this presigned URL.</p> <p>For example, if you copy an encrypted DB snapshot from the us-west-2 Amazon Web Services Region to the us-east-1 Amazon Web Services Region, then you call the <code>CopyDBSnapshot</code> action in the us-east-1 Amazon Web Services Region and provide a presigned URL that contains a call to the <code>CopyDBSnapshot</code> action in the us-west-2 Amazon Web Services Region. For this example, the <code>DestinationRegion</code> in the presigned URL must be set to the us-east-1 Amazon Web Services Region.</p> </li>
        /// <li> <p> <code>KmsKeyId</code> - The Amazon Web Services KMS key identifier for the KMS key to use to encrypt the copy of the DB snapshot in the destination Amazon Web Services Region. This is the same identifier for both the <code>CopyDBSnapshot</code> action that is called in the destination Amazon Web Services Region, and the action contained in the presigned URL.</p> </li>
        /// <li> <p> <code>SourceDBSnapshotIdentifier</code> - The DB snapshot identifier for the encrypted snapshot to be copied. This identifier must be in the Amazon Resource Name (ARN) format for the source Amazon Web Services Region. For example, if you are copying an encrypted DB snapshot from the us-west-2 Amazon Web Services Region, then your <code>SourceDBSnapshotIdentifier</code> looks like the following example: <code>arn:aws:rds:us-west-2:123456789012:snapshot:mysql-instance1-snapshot-20161115</code>.</p> </li>
        /// </ul>
        /// <p>To learn how to generate a Signature Version 4 signed request, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html">Authenticating Requests: Using Query Parameters (Amazon Web Services Signature Version 4)</a> and <a href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4 Signing Process</a>.</p> <note>
        /// <p>If you are using an Amazon Web Services SDK tool or the CLI, you can specify <code>SourceRegion</code> (or <code>--source-region</code> for the CLI) instead of specifying <code>PreSignedUrl</code> manually. Specifying <code>SourceRegion</code> autogenerates a pre-signed URL that is a valid request for the operation that can be executed in the source Amazon Web Services Region.</p>
        /// </note>
        pub fn pre_signed_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.pre_signed_url = Some(input.into());
            self
        }
        /// <p>The URL that contains a Signature Version 4 signed request for the <code>CopyDBSnapshot</code> API action in the source Amazon Web Services Region that contains the source DB snapshot to copy.</p>
        /// <p>You must specify this parameter when you copy an encrypted DB snapshot from another Amazon Web Services Region by using the Amazon RDS API. Don't specify <code>PreSignedUrl</code> when you are copying an encrypted DB snapshot in the same Amazon Web Services Region.</p>
        /// <p>The presigned URL must be a valid request for the <code>CopyDBSnapshot</code> API action that can be executed in the source Amazon Web Services Region that contains the encrypted DB snapshot to be copied. The presigned URL request must contain the following parameter values:</p>
        /// <ul>
        /// <li> <p> <code>DestinationRegion</code> - The Amazon Web Services Region that the encrypted DB snapshot is copied to. This Amazon Web Services Region is the same one where the <code>CopyDBSnapshot</code> action is called that contains this presigned URL.</p> <p>For example, if you copy an encrypted DB snapshot from the us-west-2 Amazon Web Services Region to the us-east-1 Amazon Web Services Region, then you call the <code>CopyDBSnapshot</code> action in the us-east-1 Amazon Web Services Region and provide a presigned URL that contains a call to the <code>CopyDBSnapshot</code> action in the us-west-2 Amazon Web Services Region. For this example, the <code>DestinationRegion</code> in the presigned URL must be set to the us-east-1 Amazon Web Services Region.</p> </li>
        /// <li> <p> <code>KmsKeyId</code> - The Amazon Web Services KMS key identifier for the KMS key to use to encrypt the copy of the DB snapshot in the destination Amazon Web Services Region. This is the same identifier for both the <code>CopyDBSnapshot</code> action that is called in the destination Amazon Web Services Region, and the action contained in the presigned URL.</p> </li>
        /// <li> <p> <code>SourceDBSnapshotIdentifier</code> - The DB snapshot identifier for the encrypted snapshot to be copied. This identifier must be in the Amazon Resource Name (ARN) format for the source Amazon Web Services Region. For example, if you are copying an encrypted DB snapshot from the us-west-2 Amazon Web Services Region, then your <code>SourceDBSnapshotIdentifier</code> looks like the following example: <code>arn:aws:rds:us-west-2:123456789012:snapshot:mysql-instance1-snapshot-20161115</code>.</p> </li>
        /// </ul>
        /// <p>To learn how to generate a Signature Version 4 signed request, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html">Authenticating Requests: Using Query Parameters (Amazon Web Services Signature Version 4)</a> and <a href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4 Signing Process</a>.</p> <note>
        /// <p>If you are using an Amazon Web Services SDK tool or the CLI, you can specify <code>SourceRegion</code> (or <code>--source-region</code> for the CLI) instead of specifying <code>PreSignedUrl</code> manually. Specifying <code>SourceRegion</code> autogenerates a pre-signed URL that is a valid request for the operation that can be executed in the source Amazon Web Services Region.</p>
        /// </note>
        pub fn set_pre_signed_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pre_signed_url = input;
            self
        }
        /// <p>The name of an option group to associate with the copy of the snapshot.</p>
        /// <p>Specify this option if you are copying a snapshot from one Amazon Web Services Region to another, and your DB instance uses a nondefault option group. If your source DB instance uses Transparent Data Encryption for Oracle or Microsoft SQL Server, you must specify this option when copying across Amazon Web Services Regions. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_CopySnapshot.html#USER_CopySnapshot.Options">Option group considerations</a> in the <i>Amazon RDS User Guide</i>.</p>
        pub fn option_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.option_group_name = Some(input.into());
            self
        }
        /// <p>The name of an option group to associate with the copy of the snapshot.</p>
        /// <p>Specify this option if you are copying a snapshot from one Amazon Web Services Region to another, and your DB instance uses a nondefault option group. If your source DB instance uses Transparent Data Encryption for Oracle or Microsoft SQL Server, you must specify this option when copying across Amazon Web Services Regions. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_CopySnapshot.html#USER_CopySnapshot.Options">Option group considerations</a> in the <i>Amazon RDS User Guide</i>.</p>
        pub fn set_option_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.option_group_name = input;
            self
        }
        /// <p>The external custom Availability Zone (CAZ) identifier for the target CAZ.</p>
        /// <p>Example: <code>rds-caz-aiqhTgQv</code>.</p>
        pub fn target_custom_availability_zone(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.target_custom_availability_zone = Some(input.into());
            self
        }
        /// <p>The external custom Availability Zone (CAZ) identifier for the target CAZ.</p>
        /// <p>Example: <code>rds-caz-aiqhTgQv</code>.</p>
        pub fn set_target_custom_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_custom_availability_zone = input;
            self
        }
        /// Consumes the builder and constructs a [`CopyDbSnapshotInput`](crate::input::CopyDbSnapshotInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CopyDbSnapshotInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CopyDbSnapshotInput {
                source_db_snapshot_identifier: self.source_db_snapshot_identifier,
                target_db_snapshot_identifier: self.target_db_snapshot_identifier,
                kms_key_id: self.kms_key_id,
                tags: self.tags,
                copy_tags: self.copy_tags,
                pre_signed_url: self.pre_signed_url,
                option_group_name: self.option_group_name,
                target_custom_availability_zone: self.target_custom_availability_zone,
            })
        }
    }
}
#[doc(hidden)]
pub type CopyDbSnapshotInputOperationOutputAlias = crate::operation::CopyDBSnapshot;
#[doc(hidden)]
pub type CopyDbSnapshotInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CopyDbSnapshotInput {
    /// Consumes the builder and constructs an Operation<[`CopyDBSnapshot`](crate::operation::CopyDBSnapshot)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CopyDBSnapshot,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CopyDbSnapshotInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CopyDbSnapshotInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_copy_db_snapshot(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CopyDBSnapshot::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CopyDBSnapshot",
            "rds",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CopyDbSnapshotInput`](crate::input::CopyDbSnapshotInput)
    pub fn builder() -> crate::input::copy_db_snapshot_input::Builder {
        crate::input::copy_db_snapshot_input::Builder::default()
    }
}

/// See [`CopyOptionGroupInput`](crate::input::CopyOptionGroupInput)
pub mod copy_option_group_input {
    /// A builder for [`CopyOptionGroupInput`](crate::input::CopyOptionGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_option_group_identifier: std::option::Option<std::string::String>,
        pub(crate) target_option_group_identifier: std::option::Option<std::string::String>,
        pub(crate) target_option_group_description: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The identifier for the source option group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must specify a valid option group.</p> </li>
        /// </ul>
        pub fn source_option_group_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.source_option_group_identifier = Some(input.into());
            self
        }
        /// <p>The identifier for the source option group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must specify a valid option group.</p> </li>
        /// </ul>
        pub fn set_source_option_group_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_option_group_identifier = input;
            self
        }
        /// <p>The identifier for the copied option group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Can't be null, empty, or blank</p> </li>
        /// <li> <p>Must contain from 1 to 255 letters, numbers, or hyphens</p> </li>
        /// <li> <p>First character must be a letter</p> </li>
        /// <li> <p>Can't end with a hyphen or contain two consecutive hyphens</p> </li>
        /// </ul>
        /// <p>Example: <code>my-option-group</code> </p>
        pub fn target_option_group_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.target_option_group_identifier = Some(input.into());
            self
        }
        /// <p>The identifier for the copied option group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Can't be null, empty, or blank</p> </li>
        /// <li> <p>Must contain from 1 to 255 letters, numbers, or hyphens</p> </li>
        /// <li> <p>First character must be a letter</p> </li>
        /// <li> <p>Can't end with a hyphen or contain two consecutive hyphens</p> </li>
        /// </ul>
        /// <p>Example: <code>my-option-group</code> </p>
        pub fn set_target_option_group_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_option_group_identifier = input;
            self
        }
        /// <p>The description for the copied option group.</p>
        pub fn target_option_group_description(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.target_option_group_description = Some(input.into());
            self
        }
        /// <p>The description for the copied option group.</p>
        pub fn set_target_option_group_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_option_group_description = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources</a> in the <i>Amazon RDS User Guide.</i> </p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>A list of tags. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources</a> in the <i>Amazon RDS User Guide.</i> </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CopyOptionGroupInput`](crate::input::CopyOptionGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CopyOptionGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CopyOptionGroupInput {
                source_option_group_identifier: self.source_option_group_identifier,
                target_option_group_identifier: self.target_option_group_identifier,
                target_option_group_description: self.target_option_group_description,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CopyOptionGroupInputOperationOutputAlias = crate::operation::CopyOptionGroup;
#[doc(hidden)]
pub type CopyOptionGroupInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CopyOptionGroupInput {
    /// Consumes the builder and constructs an Operation<[`CopyOptionGroup`](crate::operation::CopyOptionGroup)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CopyOptionGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CopyOptionGroupInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CopyOptionGroupInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_copy_option_group(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CopyOptionGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CopyOptionGroup",
            "rds",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CopyOptionGroupInput`](crate::input::CopyOptionGroupInput)
    pub fn builder() -> crate::input::copy_option_group_input::Builder {
        crate::input::copy_option_group_input::Builder::default()
    }
}

/// See [`CreateCustomDbEngineVersionInput`](crate::input::CreateCustomDbEngineVersionInput)
pub mod create_custom_db_engine_version_input {
    /// A builder for [`CreateCustomDbEngineVersionInput`](crate::input::CreateCustomDbEngineVersionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) engine: std::option::Option<std::string::String>,
        pub(crate) engine_version: std::option::Option<std::string::String>,
        pub(crate) database_installation_files_s3_bucket_name:
            std::option::Option<std::string::String>,
        pub(crate) database_installation_files_s3_prefix: std::option::Option<std::string::String>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) manifest: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The database engine to use for your custom engine version (CEV). The only supported value is <code>custom-oracle-ee</code>.</p>
        pub fn engine(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine = Some(input.into());
            self
        }
        /// <p>The database engine to use for your custom engine version (CEV). The only supported value is <code>custom-oracle-ee</code>.</p>
        pub fn set_engine(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.engine = input;
            self
        }
        /// <p>The name of your CEV. The name format is <code>19.<i>customized_string</i> </code>. For example, a valid name is <code>19.my_cev1</code>. This setting is required for RDS Custom for Oracle, but optional for Amazon RDS. The combination of <code>Engine</code> and <code>EngineVersion</code> is unique per customer per Region.</p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_version = Some(input.into());
            self
        }
        /// <p>The name of your CEV. The name format is <code>19.<i>customized_string</i> </code>. For example, a valid name is <code>19.my_cev1</code>. This setting is required for RDS Custom for Oracle, but optional for Amazon RDS. The combination of <code>Engine</code> and <code>EngineVersion</code> is unique per customer per Region.</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.engine_version = input;
            self
        }
        /// <p>The name of an Amazon S3 bucket that contains database installation files for your CEV. For example, a valid bucket name is <code>my-custom-installation-files</code>.</p>
        pub fn database_installation_files_s3_bucket_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.database_installation_files_s3_bucket_name = Some(input.into());
            self
        }
        /// <p>The name of an Amazon S3 bucket that contains database installation files for your CEV. For example, a valid bucket name is <code>my-custom-installation-files</code>.</p>
        pub fn set_database_installation_files_s3_bucket_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.database_installation_files_s3_bucket_name = input;
            self
        }
        /// <p>The Amazon S3 directory that contains the database installation files for your CEV. For example, a valid bucket name is <code>123456789012/cev1</code>. If this setting isn't specified, no prefix is assumed.</p>
        pub fn database_installation_files_s3_prefix(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.database_installation_files_s3_prefix = Some(input.into());
            self
        }
        /// <p>The Amazon S3 directory that contains the database installation files for your CEV. For example, a valid bucket name is <code>123456789012/cev1</code>. If this setting isn't specified, no prefix is assumed.</p>
        pub fn set_database_installation_files_s3_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.database_installation_files_s3_prefix = input;
            self
        }
        /// <p>The Amazon Web Services KMS key identifier for an encrypted CEV. A symmetric KMS key is required for RDS Custom, but optional for Amazon RDS.</p>
        /// <p>If you have an existing symmetric KMS key in your account, you can use it with RDS Custom. No further action is necessary. If you don't already have a symmetric KMS key in your account, follow the instructions in <a href="https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html#create-symmetric-cmk"> Creating symmetric KMS keys</a> in the <i>Amazon Web Services Key Management Service Developer Guide</i>.</p>
        /// <p>You can choose the same symmetric key when you create a CEV and a DB instance, or choose different keys.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services KMS key identifier for an encrypted CEV. A symmetric KMS key is required for RDS Custom, but optional for Amazon RDS.</p>
        /// <p>If you have an existing symmetric KMS key in your account, you can use it with RDS Custom. No further action is necessary. If you don't already have a symmetric KMS key in your account, follow the instructions in <a href="https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html#create-symmetric-cmk"> Creating symmetric KMS keys</a> in the <i>Amazon Web Services Key Management Service Developer Guide</i>.</p>
        /// <p>You can choose the same symmetric key when you create a CEV and a DB instance, or choose different keys.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// <p>An optional description of your CEV.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>An optional description of your CEV.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The CEV manifest, which is a JSON document that describes the installation .zip files stored in Amazon S3. Specify the name/value pairs in a file or a quoted string. RDS Custom applies the patches in the order in which they are listed.</p>
        /// <p>The following JSON fields are valid:</p>
        /// <dl>
        /// <dt>
        /// MediaImportTemplateVersion
        /// </dt>
        /// <dd>
        /// <p>Version of the CEV manifest. The date is in the format <code>YYYY-MM-DD</code>.</p>
        /// </dd>
        /// <dt>
        /// databaseInstallationFileNames
        /// </dt>
        /// <dd>
        /// <p>Ordered list of installation files for the CEV.</p>
        /// </dd>
        /// <dt>
        /// opatchFileNames
        /// </dt>
        /// <dd>
        /// <p>Ordered list of OPatch installers used for the Oracle DB engine.</p>
        /// </dd>
        /// <dt>
        /// psuRuPatchFileNames
        /// </dt>
        /// <dd>
        /// <p>The PSU and RU patches for this CEV.</p>
        /// </dd>
        /// <dt>
        /// OtherPatchFileNames
        /// </dt>
        /// <dd>
        /// <p>The patches that are not in the list of PSU and RU patches. Amazon RDS applies these patches after applying the PSU and RU patches.</p>
        /// </dd>
        /// </dl>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-cev.html#custom-cev.preparing.manifest"> Creating the CEV manifest</a> in the <i>Amazon RDS User Guide</i>.</p>
        pub fn manifest(mut self, input: impl Into<std::string::String>) -> Self {
            self.manifest = Some(input.into());
            self
        }
        /// <p>The CEV manifest, which is a JSON document that describes the installation .zip files stored in Amazon S3. Specify the name/value pairs in a file or a quoted string. RDS Custom applies the patches in the order in which they are listed.</p>
        /// <p>The following JSON fields are valid:</p>
        /// <dl>
        /// <dt>
        /// MediaImportTemplateVersion
        /// </dt>
        /// <dd>
        /// <p>Version of the CEV manifest. The date is in the format <code>YYYY-MM-DD</code>.</p>
        /// </dd>
        /// <dt>
        /// databaseInstallationFileNames
        /// </dt>
        /// <dd>
        /// <p>Ordered list of installation files for the CEV.</p>
        /// </dd>
        /// <dt>
        /// opatchFileNames
        /// </dt>
        /// <dd>
        /// <p>Ordered list of OPatch installers used for the Oracle DB engine.</p>
        /// </dd>
        /// <dt>
        /// psuRuPatchFileNames
        /// </dt>
        /// <dd>
        /// <p>The PSU and RU patches for this CEV.</p>
        /// </dd>
        /// <dt>
        /// OtherPatchFileNames
        /// </dt>
        /// <dd>
        /// <p>The patches that are not in the list of PSU and RU patches. Amazon RDS applies these patches after applying the PSU and RU patches.</p>
        /// </dd>
        /// </dl>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-cev.html#custom-cev.preparing.manifest"> Creating the CEV manifest</a> in the <i>Amazon RDS User Guide</i>.</p>
        pub fn set_manifest(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.manifest = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources</a> in the <i>Amazon RDS User Guide.</i> </p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>A list of tags. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources</a> in the <i>Amazon RDS User Guide.</i> </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateCustomDbEngineVersionInput`](crate::input::CreateCustomDbEngineVersionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateCustomDbEngineVersionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateCustomDbEngineVersionInput {
                engine: self.engine,
                engine_version: self.engine_version,
                database_installation_files_s3_bucket_name: self
                    .database_installation_files_s3_bucket_name,
                database_installation_files_s3_prefix: self.database_installation_files_s3_prefix,
                kms_key_id: self.kms_key_id,
                description: self.description,
                manifest: self.manifest,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateCustomDbEngineVersionInputOperationOutputAlias =
    crate::operation::CreateCustomDBEngineVersion;
#[doc(hidden)]
pub type CreateCustomDbEngineVersionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateCustomDbEngineVersionInput {
    /// Consumes the builder and constructs an Operation<[`CreateCustomDBEngineVersion`](crate::operation::CreateCustomDBEngineVersion)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateCustomDBEngineVersion,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateCustomDbEngineVersionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateCustomDbEngineVersionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_custom_db_engine_version(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateCustomDBEngineVersion::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateCustomDBEngineVersion",
            "rds",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateCustomDbEngineVersionInput`](crate::input::CreateCustomDbEngineVersionInput)
    pub fn builder() -> crate::input::create_custom_db_engine_version_input::Builder {
        crate::input::create_custom_db_engine_version_input::Builder::default()
    }
}

/// See [`CreateDbClusterInput`](crate::input::CreateDbClusterInput)
pub mod create_db_cluster_input {
    /// A builder for [`CreateDbClusterInput`](crate::input::CreateDbClusterInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) availability_zones: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) backup_retention_period: std::option::Option<i32>,
        pub(crate) character_set_name: std::option::Option<std::string::String>,
        pub(crate) database_name: std::option::Option<std::string::String>,
        pub(crate) db_cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) db_cluster_parameter_group_name: std::option::Option<std::string::String>,
        pub(crate) vpc_security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) db_subnet_group_name: std::option::Option<std::string::String>,
        pub(crate) engine: std::option::Option<std::string::String>,
        pub(crate) engine_version: std::option::Option<std::string::String>,
        pub(crate) port: std::option::Option<i32>,
        pub(crate) master_username: std::option::Option<std::string::String>,
        pub(crate) master_user_password: std::option::Option<std::string::String>,
        pub(crate) option_group_name: std::option::Option<std::string::String>,
        pub(crate) preferred_backup_window: std::option::Option<std::string::String>,
        pub(crate) preferred_maintenance_window: std::option::Option<std::string::String>,
        pub(crate) replication_source_identifier: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) storage_encrypted: std::option::Option<bool>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
        pub(crate) pre_signed_url: std::option::Option<std::string::String>,
        pub(crate) enable_iam_database_authentication: std::option::Option<bool>,
        pub(crate) backtrack_window: std::option::Option<i64>,
        pub(crate) enable_cloudwatch_logs_exports:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) engine_mode: std::option::Option<std::string::String>,
        pub(crate) scaling_configuration: std::option::Option<crate::model::ScalingConfiguration>,
        pub(crate) deletion_protection: std::option::Option<bool>,
        pub(crate) global_cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) enable_http_endpoint: std::option::Option<bool>,
        pub(crate) copy_tags_to_snapshot: std::option::Option<bool>,
        pub(crate) domain: std::option::Option<std::string::String>,
        pub(crate) domain_iam_role_name: std::option::Option<std::string::String>,
        pub(crate) enable_global_write_forwarding: std::option::Option<bool>,
        pub(crate) db_cluster_instance_class: std::option::Option<std::string::String>,
        pub(crate) allocated_storage: std::option::Option<i32>,
        pub(crate) storage_type: std::option::Option<std::string::String>,
        pub(crate) iops: std::option::Option<i32>,
        pub(crate) publicly_accessible: std::option::Option<bool>,
        pub(crate) auto_minor_version_upgrade: std::option::Option<bool>,
        pub(crate) monitoring_interval: std::option::Option<i32>,
        pub(crate) monitoring_role_arn: std::option::Option<std::string::String>,
        pub(crate) enable_performance_insights: std::option::Option<bool>,
        pub(crate) performance_insights_kms_key_id: std::option::Option<std::string::String>,
        pub(crate) performance_insights_retention_period: std::option::Option<i32>,
        pub(crate) serverless_v2_scaling_configuration:
            std::option::Option<crate::model::ServerlessV2ScalingConfiguration>,
    }
    impl Builder {
        /// Appends an item to `availability_zones`.
        ///
        /// To override the contents of this collection use [`set_availability_zones`](Self::set_availability_zones).
        ///
        /// <p>A list of Availability Zones (AZs) where DB instances in the DB cluster can be created.</p>
        /// <p>For information on Amazon Web Services Regions and Availability Zones, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Concepts.RegionsAndAvailabilityZones.html">Choosing the Regions and Availability Zones</a> in the <i>Amazon Aurora User Guide</i>.</p>
        /// <p>Valid for: Aurora DB clusters only</p>
        pub fn availability_zones(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.availability_zones.unwrap_or_default();
            v.push(input.into());
            self.availability_zones = Some(v);
            self
        }
        /// <p>A list of Availability Zones (AZs) where DB instances in the DB cluster can be created.</p>
        /// <p>For information on Amazon Web Services Regions and Availability Zones, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Concepts.RegionsAndAvailabilityZones.html">Choosing the Regions and Availability Zones</a> in the <i>Amazon Aurora User Guide</i>.</p>
        /// <p>Valid for: Aurora DB clusters only</p>
        pub fn set_availability_zones(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.availability_zones = input;
            self
        }
        /// <p>The number of days for which automated backups are retained.</p>
        /// <p>Default: 1</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be a value from 1 to 35</p> </li>
        /// </ul>
        /// <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
        pub fn backup_retention_period(mut self, input: i32) -> Self {
            self.backup_retention_period = Some(input);
            self
        }
        /// <p>The number of days for which automated backups are retained.</p>
        /// <p>Default: 1</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be a value from 1 to 35</p> </li>
        /// </ul>
        /// <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
        pub fn set_backup_retention_period(mut self, input: std::option::Option<i32>) -> Self {
            self.backup_retention_period = input;
            self
        }
        /// <p>A value that indicates that the DB cluster should be associated with the specified CharacterSet.</p>
        /// <p>Valid for: Aurora DB clusters only</p>
        pub fn character_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.character_set_name = Some(input.into());
            self
        }
        /// <p>A value that indicates that the DB cluster should be associated with the specified CharacterSet.</p>
        /// <p>Valid for: Aurora DB clusters only</p>
        pub fn set_character_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.character_set_name = input;
            self
        }
        /// <p>The name for your database of up to 64 alphanumeric characters. If you do not provide a name, Amazon RDS doesn't create a database in the DB cluster you are creating.</p>
        /// <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
        pub fn database_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.database_name = Some(input.into());
            self
        }
        /// <p>The name for your database of up to 64 alphanumeric characters. If you do not provide a name, Amazon RDS doesn't create a database in the DB cluster you are creating.</p>
        /// <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.database_name = input;
            self
        }
        /// <p>The DB cluster identifier. This parameter is stored as a lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p> </li>
        /// <li> <p>First character must be a letter.</p> </li>
        /// <li> <p>Can't end with a hyphen or contain two consecutive hyphens.</p> </li>
        /// </ul>
        /// <p>Example: <code>my-cluster1</code> </p>
        /// <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
        pub fn db_cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_cluster_identifier = Some(input.into());
            self
        }
        /// <p>The DB cluster identifier. This parameter is stored as a lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p> </li>
        /// <li> <p>First character must be a letter.</p> </li>
        /// <li> <p>Can't end with a hyphen or contain two consecutive hyphens.</p> </li>
        /// </ul>
        /// <p>Example: <code>my-cluster1</code> </p>
        /// <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_identifier = input;
            self
        }
        /// <p>The name of the DB cluster parameter group to associate with this DB cluster. If you do not specify a value, then the default DB cluster parameter group for the specified DB engine and version is used.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>If supplied, must match the name of an existing DB cluster parameter group.</p> </li>
        /// </ul>
        /// <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
        pub fn db_cluster_parameter_group_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.db_cluster_parameter_group_name = Some(input.into());
            self
        }
        /// <p>The name of the DB cluster parameter group to associate with this DB cluster. If you do not specify a value, then the default DB cluster parameter group for the specified DB engine and version is used.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>If supplied, must match the name of an existing DB cluster parameter group.</p> </li>
        /// </ul>
        /// <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
        pub fn set_db_cluster_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_parameter_group_name = input;
            self
        }
        /// Appends an item to `vpc_security_group_ids`.
        ///
        /// To override the contents of this collection use [`set_vpc_security_group_ids`](Self::set_vpc_security_group_ids).
        ///
        /// <p>A list of EC2 VPC security groups to associate with this DB cluster.</p>
        /// <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
        pub fn vpc_security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.vpc_security_group_ids.unwrap_or_default();
            v.push(input.into());
            self.vpc_security_group_ids = Some(v);
            self
        }
        /// <p>A list of EC2 VPC security groups to associate with this DB cluster.</p>
        /// <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
        pub fn set_vpc_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.vpc_security_group_ids = input;
            self
        }
        /// <p>A DB subnet group to associate with this DB cluster.</p>
        /// <p>This setting is required to create a Multi-AZ DB cluster.</p>
        /// <p>Constraints: Must match the name of an existing DBSubnetGroup. Must not be default.</p>
        /// <p>Example: <code>mydbsubnetgroup</code> </p>
        /// <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
        pub fn db_subnet_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_subnet_group_name = Some(input.into());
            self
        }
        /// <p>A DB subnet group to associate with this DB cluster.</p>
        /// <p>This setting is required to create a Multi-AZ DB cluster.</p>
        /// <p>Constraints: Must match the name of an existing DBSubnetGroup. Must not be default.</p>
        /// <p>Example: <code>mydbsubnetgroup</code> </p>
        /// <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
        pub fn set_db_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_subnet_group_name = input;
            self
        }
        /// <p>The name of the database engine to be used for this DB cluster.</p>
        /// <p>Valid Values:</p>
        /// <ul>
        /// <li> <p> <code>aurora</code> (for MySQL 5.6-compatible Aurora)</p> </li>
        /// <li> <p> <code>aurora-mysql</code> (for MySQL 5.7-compatible and MySQL 8.0-compatible Aurora)</p> </li>
        /// <li> <p> <code>aurora-postgresql</code> </p> </li>
        /// <li> <p> <code>mysql</code> </p> </li>
        /// <li> <p> <code>postgres</code> </p> </li>
        /// </ul>
        /// <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
        pub fn engine(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine = Some(input.into());
            self
        }
        /// <p>The name of the database engine to be used for this DB cluster.</p>
        /// <p>Valid Values:</p>
        /// <ul>
        /// <li> <p> <code>aurora</code> (for MySQL 5.6-compatible Aurora)</p> </li>
        /// <li> <p> <code>aurora-mysql</code> (for MySQL 5.7-compatible and MySQL 8.0-compatible Aurora)</p> </li>
        /// <li> <p> <code>aurora-postgresql</code> </p> </li>
        /// <li> <p> <code>mysql</code> </p> </li>
        /// <li> <p> <code>postgres</code> </p> </li>
        /// </ul>
        /// <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
        pub fn set_engine(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.engine = input;
            self
        }
        /// <p>The version number of the database engine to use.</p>
        /// <p>To list all of the available engine versions for MySQL 5.6-compatible Aurora, use the following command:</p>
        /// <p> <code>aws rds describe-db-engine-versions --engine aurora --query "DBEngineVersions[].EngineVersion"</code> </p>
        /// <p>To list all of the available engine versions for MySQL 5.7-compatible and MySQL 8.0-compatible Aurora, use the following command:</p>
        /// <p> <code>aws rds describe-db-engine-versions --engine aurora-mysql --query "DBEngineVersions[].EngineVersion"</code> </p>
        /// <p>To list all of the available engine versions for Aurora PostgreSQL, use the following command:</p>
        /// <p> <code>aws rds describe-db-engine-versions --engine aurora-postgresql --query "DBEngineVersions[].EngineVersion"</code> </p>
        /// <p>To list all of the available engine versions for RDS for MySQL, use the following command:</p>
        /// <p> <code>aws rds describe-db-engine-versions --engine mysql --query "DBEngineVersions[].EngineVersion"</code> </p>
        /// <p>To list all of the available engine versions for RDS for PostgreSQL, use the following command:</p>
        /// <p> <code>aws rds describe-db-engine-versions --engine postgres --query "DBEngineVersions[].EngineVersion"</code> </p>
        /// <p> <b>Aurora MySQL</b> </p>
        /// <p>For information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraMySQL.Updates.html">MySQL on Amazon RDS Versions</a> in the <i>Amazon Aurora User Guide</i>.</p>
        /// <p> <b>Aurora PostgreSQL</b> </p>
        /// <p>For information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraPostgreSQL.Updates.20180305.html">Amazon Aurora PostgreSQL releases and engine versions</a> in the <i>Amazon Aurora User Guide</i>.</p>
        /// <p> <b>MySQL</b> </p>
        /// <p>For information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_MySQL.html#MySQL.Concepts.VersionMgmt">MySQL on Amazon RDS Versions</a> in the <i>Amazon RDS User Guide</i>.</p>
        /// <p> <b>PostgreSQL</b> </p>
        /// <p>For information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_PostgreSQL.html#PostgreSQL.Concepts">Amazon RDS for PostgreSQL versions and extensions</a> in the <i>Amazon RDS User Guide</i>.</p>
        /// <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_version = Some(input.into());
            self
        }
        /// <p>The version number of the database engine to use.</p>
        /// <p>To list all of the available engine versions for MySQL 5.6-compatible Aurora, use the following command:</p>
        /// <p> <code>aws rds describe-db-engine-versions --engine aurora --query "DBEngineVersions[].EngineVersion"</code> </p>
        /// <p>To list all of the available engine versions for MySQL 5.7-compatible and MySQL 8.0-compatible Aurora, use the following command:</p>
        /// <p> <code>aws rds describe-db-engine-versions --engine aurora-mysql --query "DBEngineVersions[].EngineVersion"</code> </p>
        /// <p>To list all of the available engine versions for Aurora PostgreSQL, use the following command:</p>
        /// <p> <code>aws rds describe-db-engine-versions --engine aurora-postgresql --query "DBEngineVersions[].EngineVersion"</code> </p>
        /// <p>To list all of the available engine versions for RDS for MySQL, use the following command:</p>
        /// <p> <code>aws rds describe-db-engine-versions --engine mysql --query "DBEngineVersions[].EngineVersion"</code> </p>
        /// <p>To list all of the available engine versions for RDS for PostgreSQL, use the following command:</p>
        /// <p> <code>aws rds describe-db-engine-versions --engine postgres --query "DBEngineVersions[].EngineVersion"</code> </p>
        /// <p> <b>Aurora MySQL</b> </p>
        /// <p>For information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraMySQL.Updates.html">MySQL on Amazon RDS Versions</a> in the <i>Amazon Aurora User Guide</i>.</p>
        /// <p> <b>Aurora PostgreSQL</b> </p>
        /// <p>For information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraPostgreSQL.Updates.20180305.html">Amazon Aurora PostgreSQL releases and engine versions</a> in the <i>Amazon Aurora User Guide</i>.</p>
        /// <p> <b>MySQL</b> </p>
        /// <p>For information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_MySQL.html#MySQL.Concepts.VersionMgmt">MySQL on Amazon RDS Versions</a> in the <i>Amazon RDS User Guide</i>.</p>
        /// <p> <b>PostgreSQL</b> </p>
        /// <p>For information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_PostgreSQL.html#PostgreSQL.Concepts">Amazon RDS for PostgreSQL versions and extensions</a> in the <i>Amazon RDS User Guide</i>.</p>
        /// <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.engine_version = input;
            self
        }
        /// <p>The port number on which the instances in the DB cluster accept connections.</p>
        /// <p> <b>RDS for MySQL and Aurora MySQL</b> </p>
        /// <p>Default: <code>3306</code> </p>
        /// <p>Valid values: <code>1150-65535</code> </p>
        /// <p> <b>RDS for PostgreSQL and Aurora PostgreSQL</b> </p>
        /// <p>Default: <code>5432</code> </p>
        /// <p>Valid values: <code>1150-65535</code> </p>
        /// <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
        pub fn port(mut self, input: i32) -> Self {
            self.port = Some(input);
            self
        }
        /// <p>The port number on which the instances in the DB cluster accept connections.</p>
        /// <p> <b>RDS for MySQL and Aurora MySQL</b> </p>
        /// <p>Default: <code>3306</code> </p>
        /// <p>Valid values: <code>1150-65535</code> </p>
        /// <p> <b>RDS for PostgreSQL and Aurora PostgreSQL</b> </p>
        /// <p>Default: <code>5432</code> </p>
        /// <p>Valid values: <code>1150-65535</code> </p>
        /// <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.port = input;
            self
        }
        /// <p>The name of the master user for the DB cluster.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be 1 to 16 letters or numbers.</p> </li>
        /// <li> <p>First character must be a letter.</p> </li>
        /// <li> <p>Can't be a reserved word for the chosen database engine.</p> </li>
        /// </ul>
        /// <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
        pub fn master_username(mut self, input: impl Into<std::string::String>) -> Self {
            self.master_username = Some(input.into());
            self
        }
        /// <p>The name of the master user for the DB cluster.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be 1 to 16 letters or numbers.</p> </li>
        /// <li> <p>First character must be a letter.</p> </li>
        /// <li> <p>Can't be a reserved word for the chosen database engine.</p> </li>
        /// </ul>
        /// <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
        pub fn set_master_username(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.master_username = input;
            self
        }
        /// <p>The password for the master database user. This password can contain any printable ASCII character except "/", """, or "@".</p>
        /// <p>Constraints: Must contain from 8 to 41 characters.</p>
        /// <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
        pub fn master_user_password(mut self, input: impl Into<std::string::String>) -> Self {
            self.master_user_password = Some(input.into());
            self
        }
        /// <p>The password for the master database user. This password can contain any printable ASCII character except "/", """, or "@".</p>
        /// <p>Constraints: Must contain from 8 to 41 characters.</p>
        /// <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
        pub fn set_master_user_password(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.master_user_password = input;
            self
        }
        /// <p>A value that indicates that the DB cluster should be associated with the specified option group.</p>
        /// <p>DB clusters are associated with a default option group that can't be modified.</p>
        pub fn option_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.option_group_name = Some(input.into());
            self
        }
        /// <p>A value that indicates that the DB cluster should be associated with the specified option group.</p>
        /// <p>DB clusters are associated with a default option group that can't be modified.</p>
        pub fn set_option_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.option_group_name = input;
            self
        }
        /// <p>The daily time range during which automated backups are created if automated backups are enabled using the <code>BackupRetentionPeriod</code> parameter.</p>
        /// <p>The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Web Services Region. To view the time blocks available, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.Backups.BackupWindow"> Backup window</a> in the <i>Amazon Aurora User Guide</i>.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be in the format <code>hh24:mi-hh24:mi</code>.</p> </li>
        /// <li> <p>Must be in Universal Coordinated Time (UTC).</p> </li>
        /// <li> <p>Must not conflict with the preferred maintenance window.</p> </li>
        /// <li> <p>Must be at least 30 minutes.</p> </li>
        /// </ul>
        /// <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
        pub fn preferred_backup_window(mut self, input: impl Into<std::string::String>) -> Self {
            self.preferred_backup_window = Some(input.into());
            self
        }
        /// <p>The daily time range during which automated backups are created if automated backups are enabled using the <code>BackupRetentionPeriod</code> parameter.</p>
        /// <p>The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Web Services Region. To view the time blocks available, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.Backups.BackupWindow"> Backup window</a> in the <i>Amazon Aurora User Guide</i>.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be in the format <code>hh24:mi-hh24:mi</code>.</p> </li>
        /// <li> <p>Must be in Universal Coordinated Time (UTC).</p> </li>
        /// <li> <p>Must not conflict with the preferred maintenance window.</p> </li>
        /// <li> <p>Must be at least 30 minutes.</p> </li>
        /// </ul>
        /// <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
        pub fn set_preferred_backup_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.preferred_backup_window = input;
            self
        }
        /// <p>The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).</p>
        /// <p>Format: <code>ddd:hh24:mi-ddd:hh24:mi</code> </p>
        /// <p>The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Web Services Region, occurring on a random day of the week. To see the time blocks available, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow.Aurora"> Adjusting the Preferred DB Cluster Maintenance Window</a> in the <i>Amazon Aurora User Guide</i>.</p>
        /// <p>Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.</p>
        /// <p>Constraints: Minimum 30-minute window.</p>
        /// <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
        pub fn preferred_maintenance_window(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.preferred_maintenance_window = Some(input.into());
            self
        }
        /// <p>The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).</p>
        /// <p>Format: <code>ddd:hh24:mi-ddd:hh24:mi</code> </p>
        /// <p>The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Web Services Region, occurring on a random day of the week. To see the time blocks available, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow.Aurora"> Adjusting the Preferred DB Cluster Maintenance Window</a> in the <i>Amazon Aurora User Guide</i>.</p>
        /// <p>Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.</p>
        /// <p>Constraints: Minimum 30-minute window.</p>
        /// <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
        pub fn set_preferred_maintenance_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.preferred_maintenance_window = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the source DB instance or DB cluster if this DB cluster is created as a read replica.</p>
        /// <p>Valid for: Aurora DB clusters only</p>
        pub fn replication_source_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.replication_source_identifier = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the source DB instance or DB cluster if this DB cluster is created as a read replica.</p>
        /// <p>Valid for: Aurora DB clusters only</p>
        pub fn set_replication_source_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.replication_source_identifier = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags to assign to the DB cluster.</p>
        /// <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>Tags to assign to the DB cluster.</p>
        /// <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>A value that indicates whether the DB cluster is encrypted.</p>
        /// <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
        pub fn storage_encrypted(mut self, input: bool) -> Self {
            self.storage_encrypted = Some(input);
            self
        }
        /// <p>A value that indicates whether the DB cluster is encrypted.</p>
        /// <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
        pub fn set_storage_encrypted(mut self, input: std::option::Option<bool>) -> Self {
            self.storage_encrypted = input;
            self
        }
        /// <p>The Amazon Web Services KMS key identifier for an encrypted DB cluster.</p>
        /// <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key. To use a KMS key in a different Amazon Web Services account, specify the key ARN or alias ARN.</p>
        /// <p>When a KMS key isn't specified in <code>KmsKeyId</code>:</p>
        /// <ul>
        /// <li> <p>If <code>ReplicationSourceIdentifier</code> identifies an encrypted source, then Amazon RDS will use the KMS key used to encrypt the source. Otherwise, Amazon RDS will use your default KMS key.</p> </li>
        /// <li> <p>If the <code>StorageEncrypted</code> parameter is enabled and <code>ReplicationSourceIdentifier</code> isn't specified, then Amazon RDS will use your default KMS key.</p> </li>
        /// </ul>
        /// <p>There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account has a different default KMS key for each Amazon Web Services Region.</p>
        /// <p>If you create a read replica of an encrypted DB cluster in another Amazon Web Services Region, you must set <code>KmsKeyId</code> to a KMS key identifier that is valid in the destination Amazon Web Services Region. This KMS key is used to encrypt the read replica in that Amazon Web Services Region.</p>
        /// <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services KMS key identifier for an encrypted DB cluster.</p>
        /// <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key. To use a KMS key in a different Amazon Web Services account, specify the key ARN or alias ARN.</p>
        /// <p>When a KMS key isn't specified in <code>KmsKeyId</code>:</p>
        /// <ul>
        /// <li> <p>If <code>ReplicationSourceIdentifier</code> identifies an encrypted source, then Amazon RDS will use the KMS key used to encrypt the source. Otherwise, Amazon RDS will use your default KMS key.</p> </li>
        /// <li> <p>If the <code>StorageEncrypted</code> parameter is enabled and <code>ReplicationSourceIdentifier</code> isn't specified, then Amazon RDS will use your default KMS key.</p> </li>
        /// </ul>
        /// <p>There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account has a different default KMS key for each Amazon Web Services Region.</p>
        /// <p>If you create a read replica of an encrypted DB cluster in another Amazon Web Services Region, you must set <code>KmsKeyId</code> to a KMS key identifier that is valid in the destination Amazon Web Services Region. This KMS key is used to encrypt the read replica in that Amazon Web Services Region.</p>
        /// <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// <p>A URL that contains a Signature Version 4 signed request for the <code>CreateDBCluster</code> action to be called in the source Amazon Web Services Region where the DB cluster is replicated from. Specify <code>PreSignedUrl</code> only when you are performing cross-Region replication from an encrypted DB cluster.</p>
        /// <p>The pre-signed URL must be a valid request for the <code>CreateDBCluster</code> API action that can be executed in the source Amazon Web Services Region that contains the encrypted DB cluster to be copied.</p>
        /// <p>The pre-signed URL request must contain the following parameter values:</p>
        /// <ul>
        /// <li> <p> <code>KmsKeyId</code> - The Amazon Web Services KMS key identifier for the KMS key to use to encrypt the copy of the DB cluster in the destination Amazon Web Services Region. This should refer to the same KMS key for both the <code>CreateDBCluster</code> action that is called in the destination Amazon Web Services Region, and the action contained in the pre-signed URL.</p> </li>
        /// <li> <p> <code>DestinationRegion</code> - The name of the Amazon Web Services Region that Aurora read replica will be created in.</p> </li>
        /// <li> <p> <code>ReplicationSourceIdentifier</code> - The DB cluster identifier for the encrypted DB cluster to be copied. This identifier must be in the Amazon Resource Name (ARN) format for the source Amazon Web Services Region. For example, if you are copying an encrypted DB cluster from the us-west-2 Amazon Web Services Region, then your <code>ReplicationSourceIdentifier</code> would look like Example: <code>arn:aws:rds:us-west-2:123456789012:cluster:aurora-cluster1</code>.</p> </li>
        /// </ul>
        /// <p>To learn how to generate a Signature Version 4 signed request, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html"> Authenticating Requests: Using Query Parameters (Amazon Web Services Signature Version 4)</a> and <a href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html"> Signature Version 4 Signing Process</a>.</p> <note>
        /// <p>If you are using an Amazon Web Services SDK tool or the CLI, you can specify <code>SourceRegion</code> (or <code>--source-region</code> for the CLI) instead of specifying <code>PreSignedUrl</code> manually. Specifying <code>SourceRegion</code> autogenerates a pre-signed URL that is a valid request for the operation that can be executed in the source Amazon Web Services Region.</p>
        /// </note>
        /// <p>Valid for: Aurora DB clusters only</p>
        pub fn pre_signed_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.pre_signed_url = Some(input.into());
            self
        }
        /// <p>A URL that contains a Signature Version 4 signed request for the <code>CreateDBCluster</code> action to be called in the source Amazon Web Services Region where the DB cluster is replicated from. Specify <code>PreSignedUrl</code> only when you are performing cross-Region replication from an encrypted DB cluster.</p>
        /// <p>The pre-signed URL must be a valid request for the <code>CreateDBCluster</code> API action that can be executed in the source Amazon Web Services Region that contains the encrypted DB cluster to be copied.</p>
        /// <p>The pre-signed URL request must contain the following parameter values:</p>
        /// <ul>
        /// <li> <p> <code>KmsKeyId</code> - The Amazon Web Services KMS key identifier for the KMS key to use to encrypt the copy of the DB cluster in the destination Amazon Web Services Region. This should refer to the same KMS key for both the <code>CreateDBCluster</code> action that is called in the destination Amazon Web Services Region, and the action contained in the pre-signed URL.</p> </li>
        /// <li> <p> <code>DestinationRegion</code> - The name of the Amazon Web Services Region that Aurora read replica will be created in.</p> </li>
        /// <li> <p> <code>ReplicationSourceIdentifier</code> - The DB cluster identifier for the encrypted DB cluster to be copied. This identifier must be in the Amazon Resource Name (ARN) format for the source Amazon Web Services Region. For example, if you are copying an encrypted DB cluster from the us-west-2 Amazon Web Services Region, then your <code>ReplicationSourceIdentifier</code> would look like Example: <code>arn:aws:rds:us-west-2:123456789012:cluster:aurora-cluster1</code>.</p> </li>
        /// </ul>
        /// <p>To learn how to generate a Signature Version 4 signed request, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html"> Authenticating Requests: Using Query Parameters (Amazon Web Services Signature Version 4)</a> and <a href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html"> Signature Version 4 Signing Process</a>.</p> <note>
        /// <p>If you are using an Amazon Web Services SDK tool or the CLI, you can specify <code>SourceRegion</code> (or <code>--source-region</code> for the CLI) instead of specifying <code>PreSignedUrl</code> manually. Specifying <code>SourceRegion</code> autogenerates a pre-signed URL that is a valid request for the operation that can be executed in the source Amazon Web Services Region.</p>
        /// </note>
        /// <p>Valid for: Aurora DB clusters only</p>
        pub fn set_pre_signed_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pre_signed_url = input;
            self
        }
        /// <p>A value that indicates whether to enable mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts. By default, mapping isn't enabled.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.IAMDBAuth.html"> IAM Database Authentication</a> in the <i>Amazon Aurora User Guide.</i>.</p>
        /// <p>Valid for: Aurora DB clusters only</p>
        pub fn enable_iam_database_authentication(mut self, input: bool) -> Self {
            self.enable_iam_database_authentication = Some(input);
            self
        }
        /// <p>A value that indicates whether to enable mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts. By default, mapping isn't enabled.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.IAMDBAuth.html"> IAM Database Authentication</a> in the <i>Amazon Aurora User Guide.</i>.</p>
        /// <p>Valid for: Aurora DB clusters only</p>
        pub fn set_enable_iam_database_authentication(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.enable_iam_database_authentication = input;
            self
        }
        /// <p>The target backtrack window, in seconds. To disable backtracking, set this value to 0.</p>
        /// <p>Default: 0</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>If specified, this value must be set to a number from 0 to 259,200 (72 hours).</p> </li>
        /// </ul>
        /// <p>Valid for: Aurora MySQL DB clusters only</p>
        pub fn backtrack_window(mut self, input: i64) -> Self {
            self.backtrack_window = Some(input);
            self
        }
        /// <p>The target backtrack window, in seconds. To disable backtracking, set this value to 0.</p>
        /// <p>Default: 0</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>If specified, this value must be set to a number from 0 to 259,200 (72 hours).</p> </li>
        /// </ul>
        /// <p>Valid for: Aurora MySQL DB clusters only</p>
        pub fn set_backtrack_window(mut self, input: std::option::Option<i64>) -> Self {
            self.backtrack_window = input;
            self
        }
        /// Appends an item to `enable_cloudwatch_logs_exports`.
        ///
        /// To override the contents of this collection use [`set_enable_cloudwatch_logs_exports`](Self::set_enable_cloudwatch_logs_exports).
        ///
        /// <p>The list of log types that need to be enabled for exporting to CloudWatch Logs. The values in the list depend on the DB engine being used.</p>
        /// <p> <b>RDS for MySQL</b> </p>
        /// <p>Possible values are <code>error</code>, <code>general</code>, and <code>slowquery</code>.</p>
        /// <p> <b>RDS for PostgreSQL</b> </p>
        /// <p>Possible values are <code>postgresql</code> and <code>upgrade</code>.</p>
        /// <p> <b>Aurora MySQL</b> </p>
        /// <p>Possible values are <code>audit</code>, <code>error</code>, <code>general</code>, and <code>slowquery</code>.</p>
        /// <p> <b>Aurora PostgreSQL</b> </p>
        /// <p>Possible value is <code>postgresql</code>.</p>
        /// <p>For more information about exporting CloudWatch Logs for Amazon RDS, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch">Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon RDS User Guide</i>.</p>
        /// <p>For more information about exporting CloudWatch Logs for Amazon Aurora, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch">Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon Aurora User Guide</i>.</p>
        /// <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
        pub fn enable_cloudwatch_logs_exports(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.enable_cloudwatch_logs_exports.unwrap_or_default();
            v.push(input.into());
            self.enable_cloudwatch_logs_exports = Some(v);
            self
        }
        /// <p>The list of log types that need to be enabled for exporting to CloudWatch Logs. The values in the list depend on the DB engine being used.</p>
        /// <p> <b>RDS for MySQL</b> </p>
        /// <p>Possible values are <code>error</code>, <code>general</code>, and <code>slowquery</code>.</p>
        /// <p> <b>RDS for PostgreSQL</b> </p>
        /// <p>Possible values are <code>postgresql</code> and <code>upgrade</code>.</p>
        /// <p> <b>Aurora MySQL</b> </p>
        /// <p>Possible values are <code>audit</code>, <code>error</code>, <code>general</code>, and <code>slowquery</code>.</p>
        /// <p> <b>Aurora PostgreSQL</b> </p>
        /// <p>Possible value is <code>postgresql</code>.</p>
        /// <p>For more information about exporting CloudWatch Logs for Amazon RDS, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch">Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon RDS User Guide</i>.</p>
        /// <p>For more information about exporting CloudWatch Logs for Amazon Aurora, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch">Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon Aurora User Guide</i>.</p>
        /// <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
        pub fn set_enable_cloudwatch_logs_exports(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.enable_cloudwatch_logs_exports = input;
            self
        }
        /// <p>The DB engine mode of the DB cluster, either <code>provisioned</code>, <code>serverless</code>, <code>parallelquery</code>, <code>global</code>, or <code>multimaster</code>.</p>
        /// <p>The <code>parallelquery</code> engine mode isn't required for Aurora MySQL version 1.23 and higher 1.x versions, and version 2.09 and higher 2.x versions.</p>
        /// <p>The <code>global</code> engine mode isn't required for Aurora MySQL version 1.22 and higher 1.x versions, and <code>global</code> engine mode isn't required for any 2.x versions.</p>
        /// <p>The <code>multimaster</code> engine mode only applies for DB clusters created with Aurora MySQL version 5.6.10a.</p>
        /// <p>For Aurora PostgreSQL, the <code>global</code> engine mode isn't required, and both the <code>parallelquery</code> and the <code>multimaster</code> engine modes currently aren't supported.</p>
        /// <p>Limitations and requirements apply to some DB engine modes. For more information, see the following sections in the <i>Amazon Aurora User Guide</i>:</p>
        /// <ul>
        /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.html#aurora-serverless.limitations"> Limitations of Aurora Serverless v1</a> </p> </li>
        /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-mysql-parallel-query.html#aurora-mysql-parallel-query-limitations"> Limitations of Parallel Query</a> </p> </li>
        /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-global-database.html#aurora-global-database.limitations"> Limitations of Aurora Global Databases</a> </p> </li>
        /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-multi-master.html#aurora-multi-master-limitations"> Limitations of Multi-Master Clusters</a> </p> </li>
        /// </ul>
        /// <p>Valid for: Aurora DB clusters only</p>
        pub fn engine_mode(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_mode = Some(input.into());
            self
        }
        /// <p>The DB engine mode of the DB cluster, either <code>provisioned</code>, <code>serverless</code>, <code>parallelquery</code>, <code>global</code>, or <code>multimaster</code>.</p>
        /// <p>The <code>parallelquery</code> engine mode isn't required for Aurora MySQL version 1.23 and higher 1.x versions, and version 2.09 and higher 2.x versions.</p>
        /// <p>The <code>global</code> engine mode isn't required for Aurora MySQL version 1.22 and higher 1.x versions, and <code>global</code> engine mode isn't required for any 2.x versions.</p>
        /// <p>The <code>multimaster</code> engine mode only applies for DB clusters created with Aurora MySQL version 5.6.10a.</p>
        /// <p>For Aurora PostgreSQL, the <code>global</code> engine mode isn't required, and both the <code>parallelquery</code> and the <code>multimaster</code> engine modes currently aren't supported.</p>
        /// <p>Limitations and requirements apply to some DB engine modes. For more information, see the following sections in the <i>Amazon Aurora User Guide</i>:</p>
        /// <ul>
        /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.html#aurora-serverless.limitations"> Limitations of Aurora Serverless v1</a> </p> </li>
        /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-mysql-parallel-query.html#aurora-mysql-parallel-query-limitations"> Limitations of Parallel Query</a> </p> </li>
        /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-global-database.html#aurora-global-database.limitations"> Limitations of Aurora Global Databases</a> </p> </li>
        /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-multi-master.html#aurora-multi-master-limitations"> Limitations of Multi-Master Clusters</a> </p> </li>
        /// </ul>
        /// <p>Valid for: Aurora DB clusters only</p>
        pub fn set_engine_mode(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.engine_mode = input;
            self
        }
        /// <p>For DB clusters in <code>serverless</code> DB engine mode, the scaling properties of the DB cluster.</p>
        /// <p>Valid for: Aurora DB clusters only</p>
        pub fn scaling_configuration(mut self, input: crate::model::ScalingConfiguration) -> Self {
            self.scaling_configuration = Some(input);
            self
        }
        /// <p>For DB clusters in <code>serverless</code> DB engine mode, the scaling properties of the DB cluster.</p>
        /// <p>Valid for: Aurora DB clusters only</p>
        pub fn set_scaling_configuration(
            mut self,
            input: std::option::Option<crate::model::ScalingConfiguration>,
        ) -> Self {
            self.scaling_configuration = input;
            self
        }
        /// <p>A value that indicates whether the DB cluster has deletion protection enabled. The database can't be deleted when deletion protection is enabled. By default, deletion protection isn't enabled.</p>
        /// <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
        pub fn deletion_protection(mut self, input: bool) -> Self {
            self.deletion_protection = Some(input);
            self
        }
        /// <p>A value that indicates whether the DB cluster has deletion protection enabled. The database can't be deleted when deletion protection is enabled. By default, deletion protection isn't enabled.</p>
        /// <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
        pub fn set_deletion_protection(mut self, input: std::option::Option<bool>) -> Self {
            self.deletion_protection = input;
            self
        }
        /// <p>The global cluster ID of an Aurora cluster that becomes the primary cluster in the new global database cluster.</p>
        /// <p>Valid for: Aurora DB clusters only</p>
        pub fn global_cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.global_cluster_identifier = Some(input.into());
            self
        }
        /// <p>The global cluster ID of an Aurora cluster that becomes the primary cluster in the new global database cluster.</p>
        /// <p>Valid for: Aurora DB clusters only</p>
        pub fn set_global_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.global_cluster_identifier = input;
            self
        }
        /// <p>A value that indicates whether to enable the HTTP endpoint for an Aurora Serverless v1 DB cluster. By default, the HTTP endpoint is disabled.</p>
        /// <p>When enabled, the HTTP endpoint provides a connectionless web service API for running SQL queries on the Aurora Serverless v1 DB cluster. You can also query your database from inside the RDS console with the query editor.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/data-api.html">Using the Data API for Aurora Serverless v1</a> in the <i>Amazon Aurora User Guide</i>.</p>
        /// <p>Valid for: Aurora DB clusters only</p>
        pub fn enable_http_endpoint(mut self, input: bool) -> Self {
            self.enable_http_endpoint = Some(input);
            self
        }
        /// <p>A value that indicates whether to enable the HTTP endpoint for an Aurora Serverless v1 DB cluster. By default, the HTTP endpoint is disabled.</p>
        /// <p>When enabled, the HTTP endpoint provides a connectionless web service API for running SQL queries on the Aurora Serverless v1 DB cluster. You can also query your database from inside the RDS console with the query editor.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/data-api.html">Using the Data API for Aurora Serverless v1</a> in the <i>Amazon Aurora User Guide</i>.</p>
        /// <p>Valid for: Aurora DB clusters only</p>
        pub fn set_enable_http_endpoint(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_http_endpoint = input;
            self
        }
        /// <p>A value that indicates whether to copy all tags from the DB cluster to snapshots of the DB cluster. The default is not to copy them.</p>
        /// <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
        pub fn copy_tags_to_snapshot(mut self, input: bool) -> Self {
            self.copy_tags_to_snapshot = Some(input);
            self
        }
        /// <p>A value that indicates whether to copy all tags from the DB cluster to snapshots of the DB cluster. The default is not to copy them.</p>
        /// <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
        pub fn set_copy_tags_to_snapshot(mut self, input: std::option::Option<bool>) -> Self {
            self.copy_tags_to_snapshot = input;
            self
        }
        /// <p>The Active Directory directory ID to create the DB cluster in.</p>
        /// <p>For Amazon Aurora DB clusters, Amazon RDS can use Kerberos authentication to authenticate users that connect to the DB cluster.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/kerberos-authentication.html">Kerberos authentication</a> in the <i>Amazon Aurora User Guide</i>.</p>
        /// <p>Valid for: Aurora DB clusters only</p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain = Some(input.into());
            self
        }
        /// <p>The Active Directory directory ID to create the DB cluster in.</p>
        /// <p>For Amazon Aurora DB clusters, Amazon RDS can use Kerberos authentication to authenticate users that connect to the DB cluster.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/kerberos-authentication.html">Kerberos authentication</a> in the <i>Amazon Aurora User Guide</i>.</p>
        /// <p>Valid for: Aurora DB clusters only</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain = input;
            self
        }
        /// <p>Specify the name of the IAM role to be used when making API calls to the Directory Service.</p>
        /// <p>Valid for: Aurora DB clusters only</p>
        pub fn domain_iam_role_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_iam_role_name = Some(input.into());
            self
        }
        /// <p>Specify the name of the IAM role to be used when making API calls to the Directory Service.</p>
        /// <p>Valid for: Aurora DB clusters only</p>
        pub fn set_domain_iam_role_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.domain_iam_role_name = input;
            self
        }
        /// <p>A value that indicates whether to enable this DB cluster to forward write operations to the primary cluster of an Aurora global database (<code>GlobalCluster</code>). By default, write operations are not allowed on Aurora DB clusters that are secondary clusters in an Aurora global database.</p>
        /// <p>You can set this value only on Aurora DB clusters that are members of an Aurora global database. With this parameter enabled, a secondary cluster can forward writes to the current primary cluster and the resulting changes are replicated back to this cluster. For the primary DB cluster of an Aurora global database, this value is used immediately if the primary is demoted by the <code>FailoverGlobalCluster</code> API operation, but it does nothing until then.</p>
        /// <p>Valid for: Aurora DB clusters only</p>
        pub fn enable_global_write_forwarding(mut self, input: bool) -> Self {
            self.enable_global_write_forwarding = Some(input);
            self
        }
        /// <p>A value that indicates whether to enable this DB cluster to forward write operations to the primary cluster of an Aurora global database (<code>GlobalCluster</code>). By default, write operations are not allowed on Aurora DB clusters that are secondary clusters in an Aurora global database.</p>
        /// <p>You can set this value only on Aurora DB clusters that are members of an Aurora global database. With this parameter enabled, a secondary cluster can forward writes to the current primary cluster and the resulting changes are replicated back to this cluster. For the primary DB cluster of an Aurora global database, this value is used immediately if the primary is demoted by the <code>FailoverGlobalCluster</code> API operation, but it does nothing until then.</p>
        /// <p>Valid for: Aurora DB clusters only</p>
        pub fn set_enable_global_write_forwarding(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.enable_global_write_forwarding = input;
            self
        }
        /// <p>The compute and memory capacity of each DB instance in the Multi-AZ DB cluster, for example db.m6g.xlarge. Not all DB instance classes are available in all Amazon Web Services Regions, or for all database engines.</p>
        /// <p>For the full list of DB instance classes and availability for your engine, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html">DB instance class</a> in the <i>Amazon RDS User Guide</i>.</p>
        /// <p>This setting is required to create a Multi-AZ DB cluster.</p>
        /// <p>Valid for: Multi-AZ DB clusters only</p>
        pub fn db_cluster_instance_class(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_cluster_instance_class = Some(input.into());
            self
        }
        /// <p>The compute and memory capacity of each DB instance in the Multi-AZ DB cluster, for example db.m6g.xlarge. Not all DB instance classes are available in all Amazon Web Services Regions, or for all database engines.</p>
        /// <p>For the full list of DB instance classes and availability for your engine, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html">DB instance class</a> in the <i>Amazon RDS User Guide</i>.</p>
        /// <p>This setting is required to create a Multi-AZ DB cluster.</p>
        /// <p>Valid for: Multi-AZ DB clusters only</p>
        pub fn set_db_cluster_instance_class(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_instance_class = input;
            self
        }
        /// <p>The amount of storage in gibibytes (GiB) to allocate to each DB instance in the Multi-AZ DB cluster.</p>
        /// <p>This setting is required to create a Multi-AZ DB cluster.</p>
        /// <p>Valid for: Multi-AZ DB clusters only</p>
        pub fn allocated_storage(mut self, input: i32) -> Self {
            self.allocated_storage = Some(input);
            self
        }
        /// <p>The amount of storage in gibibytes (GiB) to allocate to each DB instance in the Multi-AZ DB cluster.</p>
        /// <p>This setting is required to create a Multi-AZ DB cluster.</p>
        /// <p>Valid for: Multi-AZ DB clusters only</p>
        pub fn set_allocated_storage(mut self, input: std::option::Option<i32>) -> Self {
            self.allocated_storage = input;
            self
        }
        /// <p>Specifies the storage type to be associated with the DB cluster.</p>
        /// <p>This setting is required to create a Multi-AZ DB cluster.</p>
        /// <p>Valid values: <code>io1</code> </p>
        /// <p>When specified, a value for the <code>Iops</code> parameter is required.</p>
        /// <p>Default: <code>io1</code> </p>
        /// <p>Valid for: Multi-AZ DB clusters only</p>
        pub fn storage_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.storage_type = Some(input.into());
            self
        }
        /// <p>Specifies the storage type to be associated with the DB cluster.</p>
        /// <p>This setting is required to create a Multi-AZ DB cluster.</p>
        /// <p>Valid values: <code>io1</code> </p>
        /// <p>When specified, a value for the <code>Iops</code> parameter is required.</p>
        /// <p>Default: <code>io1</code> </p>
        /// <p>Valid for: Multi-AZ DB clusters only</p>
        pub fn set_storage_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.storage_type = input;
            self
        }
        /// <p>The amount of Provisioned IOPS (input/output operations per second) to be initially allocated for each DB instance in the Multi-AZ DB cluster.</p>
        /// <p>For information about valid <code>Iops</code> values, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#USER_PIOPS">Amazon RDS Provisioned IOPS storage to improve performance</a> in the <i>Amazon RDS User Guide</i>.</p>
        /// <p>This setting is required to create a Multi-AZ DB cluster.</p>
        /// <p>Constraints: Must be a multiple between .5 and 50 of the storage amount for the DB cluster.</p>
        /// <p>Valid for: Multi-AZ DB clusters only</p>
        pub fn iops(mut self, input: i32) -> Self {
            self.iops = Some(input);
            self
        }
        /// <p>The amount of Provisioned IOPS (input/output operations per second) to be initially allocated for each DB instance in the Multi-AZ DB cluster.</p>
        /// <p>For information about valid <code>Iops</code> values, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#USER_PIOPS">Amazon RDS Provisioned IOPS storage to improve performance</a> in the <i>Amazon RDS User Guide</i>.</p>
        /// <p>This setting is required to create a Multi-AZ DB cluster.</p>
        /// <p>Constraints: Must be a multiple between .5 and 50 of the storage amount for the DB cluster.</p>
        /// <p>Valid for: Multi-AZ DB clusters only</p>
        pub fn set_iops(mut self, input: std::option::Option<i32>) -> Self {
            self.iops = input;
            self
        }
        /// <p>A value that indicates whether the DB cluster is publicly accessible.</p>
        /// <p>When the DB cluster is publicly accessible, its Domain Name System (DNS) endpoint resolves to the private IP address from within the DB cluster's virtual private cloud (VPC). It resolves to the public IP address from outside of the DB cluster's VPC. Access to the DB cluster is ultimately controlled by the security group it uses. That public access isn't permitted if the security group assigned to the DB cluster doesn't permit it.</p>
        /// <p>When the DB cluster isn't publicly accessible, it is an internal DB cluster with a DNS name that resolves to a private IP address.</p>
        /// <p>Default: The default behavior varies depending on whether <code>DBSubnetGroupName</code> is specified.</p>
        /// <p>If <code>DBSubnetGroupName</code> isn't specified, and <code>PubliclyAccessible</code> isn't specified, the following applies:</p>
        /// <ul>
        /// <li> <p>If the default VPC in the target Region doesn’t have an internet gateway attached to it, the DB cluster is private.</p> </li>
        /// <li> <p>If the default VPC in the target Region has an internet gateway attached to it, the DB cluster is public.</p> </li>
        /// </ul>
        /// <p>If <code>DBSubnetGroupName</code> is specified, and <code>PubliclyAccessible</code> isn't specified, the following applies:</p>
        /// <ul>
        /// <li> <p>If the subnets are part of a VPC that doesn’t have an internet gateway attached to it, the DB cluster is private.</p> </li>
        /// <li> <p>If the subnets are part of a VPC that has an internet gateway attached to it, the DB cluster is public.</p> </li>
        /// </ul>
        /// <p>Valid for: Multi-AZ DB clusters only</p>
        pub fn publicly_accessible(mut self, input: bool) -> Self {
            self.publicly_accessible = Some(input);
            self
        }
        /// <p>A value that indicates whether the DB cluster is publicly accessible.</p>
        /// <p>When the DB cluster is publicly accessible, its Domain Name System (DNS) endpoint resolves to the private IP address from within the DB cluster's virtual private cloud (VPC). It resolves to the public IP address from outside of the DB cluster's VPC. Access to the DB cluster is ultimately controlled by the security group it uses. That public access isn't permitted if the security group assigned to the DB cluster doesn't permit it.</p>
        /// <p>When the DB cluster isn't publicly accessible, it is an internal DB cluster with a DNS name that resolves to a private IP address.</p>
        /// <p>Default: The default behavior varies depending on whether <code>DBSubnetGroupName</code> is specified.</p>
        /// <p>If <code>DBSubnetGroupName</code> isn't specified, and <code>PubliclyAccessible</code> isn't specified, the following applies:</p>
        /// <ul>
        /// <li> <p>If the default VPC in the target Region doesn’t have an internet gateway attached to it, the DB cluster is private.</p> </li>
        /// <li> <p>If the default VPC in the target Region has an internet gateway attached to it, the DB cluster is public.</p> </li>
        /// </ul>
        /// <p>If <code>DBSubnetGroupName</code> is specified, and <code>PubliclyAccessible</code> isn't specified, the following applies:</p>
        /// <ul>
        /// <li> <p>If the subnets are part of a VPC that doesn’t have an internet gateway attached to it, the DB cluster is private.</p> </li>
        /// <li> <p>If the subnets are part of a VPC that has an internet gateway attached to it, the DB cluster is public.</p> </li>
        /// </ul>
        /// <p>Valid for: Multi-AZ DB clusters only</p>
        pub fn set_publicly_accessible(mut self, input: std::option::Option<bool>) -> Self {
            self.publicly_accessible = input;
            self
        }
        /// <p>A value that indicates whether minor engine upgrades are applied automatically to the DB cluster during the maintenance window. By default, minor engine upgrades are applied automatically.</p>
        /// <p>Valid for: Multi-AZ DB clusters only</p>
        pub fn auto_minor_version_upgrade(mut self, input: bool) -> Self {
            self.auto_minor_version_upgrade = Some(input);
            self
        }
        /// <p>A value that indicates whether minor engine upgrades are applied automatically to the DB cluster during the maintenance window. By default, minor engine upgrades are applied automatically.</p>
        /// <p>Valid for: Multi-AZ DB clusters only</p>
        pub fn set_auto_minor_version_upgrade(mut self, input: std::option::Option<bool>) -> Self {
            self.auto_minor_version_upgrade = input;
            self
        }
        /// <p>The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB cluster. To turn off collecting Enhanced Monitoring metrics, specify 0. The default is 0.</p>
        /// <p>If <code>MonitoringRoleArn</code> is specified, also set <code>MonitoringInterval</code> to a value other than 0.</p>
        /// <p>Valid Values: <code>0, 1, 5, 10, 15, 30, 60</code> </p>
        /// <p>Valid for: Multi-AZ DB clusters only</p>
        pub fn monitoring_interval(mut self, input: i32) -> Self {
            self.monitoring_interval = Some(input);
            self
        }
        /// <p>The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB cluster. To turn off collecting Enhanced Monitoring metrics, specify 0. The default is 0.</p>
        /// <p>If <code>MonitoringRoleArn</code> is specified, also set <code>MonitoringInterval</code> to a value other than 0.</p>
        /// <p>Valid Values: <code>0, 1, 5, 10, 15, 30, 60</code> </p>
        /// <p>Valid for: Multi-AZ DB clusters only</p>
        pub fn set_monitoring_interval(mut self, input: std::option::Option<i32>) -> Self {
            self.monitoring_interval = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the IAM role that permits RDS to send Enhanced Monitoring metrics to Amazon CloudWatch Logs. An example is <code>arn:aws:iam:123456789012:role/emaccess</code>. For information on creating a monitoring role, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.OS.html#USER_Monitoring.OS.Enabling">Setting up and enabling Enhanced Monitoring</a> in the <i>Amazon RDS User Guide</i>.</p>
        /// <p>If <code>MonitoringInterval</code> is set to a value other than 0, supply a <code>MonitoringRoleArn</code> value.</p>
        /// <p>Valid for: Multi-AZ DB clusters only</p>
        pub fn monitoring_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.monitoring_role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the IAM role that permits RDS to send Enhanced Monitoring metrics to Amazon CloudWatch Logs. An example is <code>arn:aws:iam:123456789012:role/emaccess</code>. For information on creating a monitoring role, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.OS.html#USER_Monitoring.OS.Enabling">Setting up and enabling Enhanced Monitoring</a> in the <i>Amazon RDS User Guide</i>.</p>
        /// <p>If <code>MonitoringInterval</code> is set to a value other than 0, supply a <code>MonitoringRoleArn</code> value.</p>
        /// <p>Valid for: Multi-AZ DB clusters only</p>
        pub fn set_monitoring_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.monitoring_role_arn = input;
            self
        }
        /// <p>A value that indicates whether to turn on Performance Insights for the DB cluster.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html"> Using Amazon Performance Insights</a> in the <i>Amazon RDS User Guide</i>.</p>
        /// <p>Valid for: Multi-AZ DB clusters only</p>
        pub fn enable_performance_insights(mut self, input: bool) -> Self {
            self.enable_performance_insights = Some(input);
            self
        }
        /// <p>A value that indicates whether to turn on Performance Insights for the DB cluster.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html"> Using Amazon Performance Insights</a> in the <i>Amazon RDS User Guide</i>.</p>
        /// <p>Valid for: Multi-AZ DB clusters only</p>
        pub fn set_enable_performance_insights(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_performance_insights = input;
            self
        }
        /// <p>The Amazon Web Services KMS key identifier for encryption of Performance Insights data.</p>
        /// <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.</p>
        /// <p>If you don't specify a value for <code>PerformanceInsightsKMSKeyId</code>, then Amazon RDS uses your default KMS key. There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account has a different default KMS key for each Amazon Web Services Region.</p>
        /// <p>Valid for: Multi-AZ DB clusters only</p>
        pub fn performance_insights_kms_key_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.performance_insights_kms_key_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services KMS key identifier for encryption of Performance Insights data.</p>
        /// <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.</p>
        /// <p>If you don't specify a value for <code>PerformanceInsightsKMSKeyId</code>, then Amazon RDS uses your default KMS key. There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account has a different default KMS key for each Amazon Web Services Region.</p>
        /// <p>Valid for: Multi-AZ DB clusters only</p>
        pub fn set_performance_insights_kms_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.performance_insights_kms_key_id = input;
            self
        }
        /// <p>The amount of time, in days, to retain Performance Insights data. Valid values are 7 or 731 (2 years).</p>
        /// <p>Valid for: Multi-AZ DB clusters only</p>
        pub fn performance_insights_retention_period(mut self, input: i32) -> Self {
            self.performance_insights_retention_period = Some(input);
            self
        }
        /// <p>The amount of time, in days, to retain Performance Insights data. Valid values are 7 or 731 (2 years).</p>
        /// <p>Valid for: Multi-AZ DB clusters only</p>
        pub fn set_performance_insights_retention_period(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.performance_insights_retention_period = input;
            self
        }
        /// <p>Contains the scaling configuration of an Aurora Serverless v2 DB cluster.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless-v2.html">Using Amazon Aurora Serverless v2</a> in the <i>Amazon Aurora User Guide</i>.</p>
        pub fn serverless_v2_scaling_configuration(
            mut self,
            input: crate::model::ServerlessV2ScalingConfiguration,
        ) -> Self {
            self.serverless_v2_scaling_configuration = Some(input);
            self
        }
        /// <p>Contains the scaling configuration of an Aurora Serverless v2 DB cluster.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless-v2.html">Using Amazon Aurora Serverless v2</a> in the <i>Amazon Aurora User Guide</i>.</p>
        pub fn set_serverless_v2_scaling_configuration(
            mut self,
            input: std::option::Option<crate::model::ServerlessV2ScalingConfiguration>,
        ) -> Self {
            self.serverless_v2_scaling_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDbClusterInput`](crate::input::CreateDbClusterInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateDbClusterInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateDbClusterInput {
                availability_zones: self.availability_zones,
                backup_retention_period: self.backup_retention_period,
                character_set_name: self.character_set_name,
                database_name: self.database_name,
                db_cluster_identifier: self.db_cluster_identifier,
                db_cluster_parameter_group_name: self.db_cluster_parameter_group_name,
                vpc_security_group_ids: self.vpc_security_group_ids,
                db_subnet_group_name: self.db_subnet_group_name,
                engine: self.engine,
                engine_version: self.engine_version,
                port: self.port,
                master_username: self.master_username,
                master_user_password: self.master_user_password,
                option_group_name: self.option_group_name,
                preferred_backup_window: self.preferred_backup_window,
                preferred_maintenance_window: self.preferred_maintenance_window,
                replication_source_identifier: self.replication_source_identifier,
                tags: self.tags,
                storage_encrypted: self.storage_encrypted,
                kms_key_id: self.kms_key_id,
                pre_signed_url: self.pre_signed_url,
                enable_iam_database_authentication: self.enable_iam_database_authentication,
                backtrack_window: self.backtrack_window,
                enable_cloudwatch_logs_exports: self.enable_cloudwatch_logs_exports,
                engine_mode: self.engine_mode,
                scaling_configuration: self.scaling_configuration,
                deletion_protection: self.deletion_protection,
                global_cluster_identifier: self.global_cluster_identifier,
                enable_http_endpoint: self.enable_http_endpoint,
                copy_tags_to_snapshot: self.copy_tags_to_snapshot,
                domain: self.domain,
                domain_iam_role_name: self.domain_iam_role_name,
                enable_global_write_forwarding: self.enable_global_write_forwarding,
                db_cluster_instance_class: self.db_cluster_instance_class,
                allocated_storage: self.allocated_storage,
                storage_type: self.storage_type,
                iops: self.iops,
                publicly_accessible: self.publicly_accessible,
                auto_minor_version_upgrade: self.auto_minor_version_upgrade,
                monitoring_interval: self.monitoring_interval,
                monitoring_role_arn: self.monitoring_role_arn,
                enable_performance_insights: self.enable_performance_insights,
                performance_insights_kms_key_id: self.performance_insights_kms_key_id,
                performance_insights_retention_period: self.performance_insights_retention_period,
                serverless_v2_scaling_configuration: self.serverless_v2_scaling_configuration,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateDbClusterInputOperationOutputAlias = crate::operation::CreateDBCluster;
#[doc(hidden)]
pub type CreateDbClusterInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateDbClusterInput {
    /// Consumes the builder and constructs an Operation<[`CreateDBCluster`](crate::operation::CreateDBCluster)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateDBCluster,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateDbClusterInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateDbClusterInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_db_cluster(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateDBCluster::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateDBCluster",
            "rds",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateDbClusterInput`](crate::input::CreateDbClusterInput)
    pub fn builder() -> crate::input::create_db_cluster_input::Builder {
        crate::input::create_db_cluster_input::Builder::default()
    }
}

/// See [`CreateDbClusterEndpointInput`](crate::input::CreateDbClusterEndpointInput)
pub mod create_db_cluster_endpoint_input {
    /// A builder for [`CreateDbClusterEndpointInput`](crate::input::CreateDbClusterEndpointInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) db_cluster_endpoint_identifier: std::option::Option<std::string::String>,
        pub(crate) endpoint_type: std::option::Option<std::string::String>,
        pub(crate) static_members: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) excluded_members: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The DB cluster identifier of the DB cluster associated with the endpoint. This parameter is stored as a lowercase string.</p>
        pub fn db_cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_cluster_identifier = Some(input.into());
            self
        }
        /// <p>The DB cluster identifier of the DB cluster associated with the endpoint. This parameter is stored as a lowercase string.</p>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_identifier = input;
            self
        }
        /// <p>The identifier to use for the new endpoint. This parameter is stored as a lowercase string.</p>
        pub fn db_cluster_endpoint_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.db_cluster_endpoint_identifier = Some(input.into());
            self
        }
        /// <p>The identifier to use for the new endpoint. This parameter is stored as a lowercase string.</p>
        pub fn set_db_cluster_endpoint_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_endpoint_identifier = input;
            self
        }
        /// <p>The type of the endpoint, one of: <code>READER</code>, <code>WRITER</code>, <code>ANY</code>.</p>
        pub fn endpoint_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_type = Some(input.into());
            self
        }
        /// <p>The type of the endpoint, one of: <code>READER</code>, <code>WRITER</code>, <code>ANY</code>.</p>
        pub fn set_endpoint_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.endpoint_type = input;
            self
        }
        /// Appends an item to `static_members`.
        ///
        /// To override the contents of this collection use [`set_static_members`](Self::set_static_members).
        ///
        /// <p>List of DB instance identifiers that are part of the custom endpoint group.</p>
        pub fn static_members(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.static_members.unwrap_or_default();
            v.push(input.into());
            self.static_members = Some(v);
            self
        }
        /// <p>List of DB instance identifiers that are part of the custom endpoint group.</p>
        pub fn set_static_members(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.static_members = input;
            self
        }
        /// Appends an item to `excluded_members`.
        ///
        /// To override the contents of this collection use [`set_excluded_members`](Self::set_excluded_members).
        ///
        /// <p>List of DB instance identifiers that aren't part of the custom endpoint group. All other eligible instances are reachable through the custom endpoint. This parameter is relevant only if the list of static members is empty.</p>
        pub fn excluded_members(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.excluded_members.unwrap_or_default();
            v.push(input.into());
            self.excluded_members = Some(v);
            self
        }
        /// <p>List of DB instance identifiers that aren't part of the custom endpoint group. All other eligible instances are reachable through the custom endpoint. This parameter is relevant only if the list of static members is empty.</p>
        pub fn set_excluded_members(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.excluded_members = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be assigned to the Amazon RDS resource.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The tags to be assigned to the Amazon RDS resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDbClusterEndpointInput`](crate::input::CreateDbClusterEndpointInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateDbClusterEndpointInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateDbClusterEndpointInput {
                db_cluster_identifier: self.db_cluster_identifier,
                db_cluster_endpoint_identifier: self.db_cluster_endpoint_identifier,
                endpoint_type: self.endpoint_type,
                static_members: self.static_members,
                excluded_members: self.excluded_members,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateDbClusterEndpointInputOperationOutputAlias =
    crate::operation::CreateDBClusterEndpoint;
#[doc(hidden)]
pub type CreateDbClusterEndpointInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateDbClusterEndpointInput {
    /// Consumes the builder and constructs an Operation<[`CreateDBClusterEndpoint`](crate::operation::CreateDBClusterEndpoint)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateDBClusterEndpoint,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateDbClusterEndpointInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateDbClusterEndpointInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_db_cluster_endpoint(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateDBClusterEndpoint::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateDBClusterEndpoint",
            "rds",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateDbClusterEndpointInput`](crate::input::CreateDbClusterEndpointInput)
    pub fn builder() -> crate::input::create_db_cluster_endpoint_input::Builder {
        crate::input::create_db_cluster_endpoint_input::Builder::default()
    }
}

/// See [`CreateDbClusterParameterGroupInput`](crate::input::CreateDbClusterParameterGroupInput)
pub mod create_db_cluster_parameter_group_input {
    /// A builder for [`CreateDbClusterParameterGroupInput`](crate::input::CreateDbClusterParameterGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster_parameter_group_name: std::option::Option<std::string::String>,
        pub(crate) db_parameter_group_family: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of the DB cluster parameter group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must not match the name of an existing DB cluster parameter group.</p> </li>
        /// </ul> <note>
        /// <p>This value is stored as a lowercase string.</p>
        /// </note>
        pub fn db_cluster_parameter_group_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.db_cluster_parameter_group_name = Some(input.into());
            self
        }
        /// <p>The name of the DB cluster parameter group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must not match the name of an existing DB cluster parameter group.</p> </li>
        /// </ul> <note>
        /// <p>This value is stored as a lowercase string.</p>
        /// </note>
        pub fn set_db_cluster_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_parameter_group_name = input;
            self
        }
        /// <p>The DB cluster parameter group family name. A DB cluster parameter group can be associated with one and only one DB cluster parameter group family, and can be applied only to a DB cluster running a database engine and engine version compatible with that DB cluster parameter group family.</p>
        /// <p> <b>Aurora MySQL</b> </p>
        /// <p>Example: <code>aurora5.6</code>, <code>aurora-mysql5.7</code>, <code>aurora-mysql8.0</code> </p>
        /// <p> <b>Aurora PostgreSQL</b> </p>
        /// <p>Example: <code>aurora-postgresql9.6</code> </p>
        /// <p> <b>RDS for MySQL</b> </p>
        /// <p>Example: <code>mysql8.0</code> </p>
        /// <p> <b>RDS for PostgreSQL</b> </p>
        /// <p>Example: <code>postgres12</code> </p>
        /// <p>To list all of the available parameter group families for a DB engine, use the following command:</p>
        /// <p> <code>aws rds describe-db-engine-versions --query "DBEngineVersions[].DBParameterGroupFamily" --engine
        /// <engine></engine></code> </p>
        /// <p>For example, to list all of the available parameter group families for the Aurora PostgreSQL DB engine, use the following command:</p>
        /// <p> <code>aws rds describe-db-engine-versions --query "DBEngineVersions[].DBParameterGroupFamily" --engine aurora-postgresql</code> </p> <note>
        /// <p>The output contains duplicates.</p>
        /// </note>
        /// <p>The following are the valid DB engine values:</p>
        /// <ul>
        /// <li> <p> <code>aurora</code> (for MySQL 5.6-compatible Aurora)</p> </li>
        /// <li> <p> <code>aurora-mysql</code> (for MySQL 5.7-compatible and MySQL 8.0-compatible Aurora)</p> </li>
        /// <li> <p> <code>aurora-postgresql</code> </p> </li>
        /// <li> <p> <code>mysql</code> </p> </li>
        /// <li> <p> <code>postgres</code> </p> </li>
        /// </ul>
        pub fn db_parameter_group_family(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_parameter_group_family = Some(input.into());
            self
        }
        /// <p>The DB cluster parameter group family name. A DB cluster parameter group can be associated with one and only one DB cluster parameter group family, and can be applied only to a DB cluster running a database engine and engine version compatible with that DB cluster parameter group family.</p>
        /// <p> <b>Aurora MySQL</b> </p>
        /// <p>Example: <code>aurora5.6</code>, <code>aurora-mysql5.7</code>, <code>aurora-mysql8.0</code> </p>
        /// <p> <b>Aurora PostgreSQL</b> </p>
        /// <p>Example: <code>aurora-postgresql9.6</code> </p>
        /// <p> <b>RDS for MySQL</b> </p>
        /// <p>Example: <code>mysql8.0</code> </p>
        /// <p> <b>RDS for PostgreSQL</b> </p>
        /// <p>Example: <code>postgres12</code> </p>
        /// <p>To list all of the available parameter group families for a DB engine, use the following command:</p>
        /// <p> <code>aws rds describe-db-engine-versions --query "DBEngineVersions[].DBParameterGroupFamily" --engine
        /// <engine></engine></code> </p>
        /// <p>For example, to list all of the available parameter group families for the Aurora PostgreSQL DB engine, use the following command:</p>
        /// <p> <code>aws rds describe-db-engine-versions --query "DBEngineVersions[].DBParameterGroupFamily" --engine aurora-postgresql</code> </p> <note>
        /// <p>The output contains duplicates.</p>
        /// </note>
        /// <p>The following are the valid DB engine values:</p>
        /// <ul>
        /// <li> <p> <code>aurora</code> (for MySQL 5.6-compatible Aurora)</p> </li>
        /// <li> <p> <code>aurora-mysql</code> (for MySQL 5.7-compatible and MySQL 8.0-compatible Aurora)</p> </li>
        /// <li> <p> <code>aurora-postgresql</code> </p> </li>
        /// <li> <p> <code>mysql</code> </p> </li>
        /// <li> <p> <code>postgres</code> </p> </li>
        /// </ul>
        pub fn set_db_parameter_group_family(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_parameter_group_family = input;
            self
        }
        /// <p>The description for the DB cluster parameter group.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description for the DB cluster parameter group.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags to assign to the DB cluster parameter group.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>Tags to assign to the DB cluster parameter group.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDbClusterParameterGroupInput`](crate::input::CreateDbClusterParameterGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateDbClusterParameterGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateDbClusterParameterGroupInput {
                db_cluster_parameter_group_name: self.db_cluster_parameter_group_name,
                db_parameter_group_family: self.db_parameter_group_family,
                description: self.description,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateDbClusterParameterGroupInputOperationOutputAlias =
    crate::operation::CreateDBClusterParameterGroup;
#[doc(hidden)]
pub type CreateDbClusterParameterGroupInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl CreateDbClusterParameterGroupInput {
    /// Consumes the builder and constructs an Operation<[`CreateDBClusterParameterGroup`](crate::operation::CreateDBClusterParameterGroup)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateDBClusterParameterGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateDbClusterParameterGroupInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateDbClusterParameterGroupInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_db_cluster_parameter_group(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateDBClusterParameterGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateDBClusterParameterGroup",
            "rds",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateDbClusterParameterGroupInput`](crate::input::CreateDbClusterParameterGroupInput)
    pub fn builder() -> crate::input::create_db_cluster_parameter_group_input::Builder {
        crate::input::create_db_cluster_parameter_group_input::Builder::default()
    }
}

/// See [`CreateDbClusterSnapshotInput`](crate::input::CreateDbClusterSnapshotInput)
pub mod create_db_cluster_snapshot_input {
    /// A builder for [`CreateDbClusterSnapshotInput`](crate::input::CreateDbClusterSnapshotInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster_snapshot_identifier: std::option::Option<std::string::String>,
        pub(crate) db_cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The identifier of the DB cluster snapshot. This parameter is stored as a lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p> </li>
        /// <li> <p>First character must be a letter.</p> </li>
        /// <li> <p>Can't end with a hyphen or contain two consecutive hyphens.</p> </li>
        /// </ul>
        /// <p>Example: <code>my-cluster1-snapshot1</code> </p>
        pub fn db_cluster_snapshot_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.db_cluster_snapshot_identifier = Some(input.into());
            self
        }
        /// <p>The identifier of the DB cluster snapshot. This parameter is stored as a lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p> </li>
        /// <li> <p>First character must be a letter.</p> </li>
        /// <li> <p>Can't end with a hyphen or contain two consecutive hyphens.</p> </li>
        /// </ul>
        /// <p>Example: <code>my-cluster1-snapshot1</code> </p>
        pub fn set_db_cluster_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_snapshot_identifier = input;
            self
        }
        /// <p>The identifier of the DB cluster to create a snapshot for. This parameter isn't case-sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must match the identifier of an existing DBCluster.</p> </li>
        /// </ul>
        /// <p>Example: <code>my-cluster1</code> </p>
        pub fn db_cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_cluster_identifier = Some(input.into());
            self
        }
        /// <p>The identifier of the DB cluster to create a snapshot for. This parameter isn't case-sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must match the identifier of an existing DBCluster.</p> </li>
        /// </ul>
        /// <p>Example: <code>my-cluster1</code> </p>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_identifier = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be assigned to the DB cluster snapshot.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The tags to be assigned to the DB cluster snapshot.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDbClusterSnapshotInput`](crate::input::CreateDbClusterSnapshotInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateDbClusterSnapshotInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateDbClusterSnapshotInput {
                db_cluster_snapshot_identifier: self.db_cluster_snapshot_identifier,
                db_cluster_identifier: self.db_cluster_identifier,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateDbClusterSnapshotInputOperationOutputAlias =
    crate::operation::CreateDBClusterSnapshot;
#[doc(hidden)]
pub type CreateDbClusterSnapshotInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateDbClusterSnapshotInput {
    /// Consumes the builder and constructs an Operation<[`CreateDBClusterSnapshot`](crate::operation::CreateDBClusterSnapshot)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateDBClusterSnapshot,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateDbClusterSnapshotInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateDbClusterSnapshotInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_db_cluster_snapshot(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateDBClusterSnapshot::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateDBClusterSnapshot",
            "rds",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateDbClusterSnapshotInput`](crate::input::CreateDbClusterSnapshotInput)
    pub fn builder() -> crate::input::create_db_cluster_snapshot_input::Builder {
        crate::input::create_db_cluster_snapshot_input::Builder::default()
    }
}

/// See [`CreateDbInstanceInput`](crate::input::CreateDbInstanceInput)
pub mod create_db_instance_input {
    /// A builder for [`CreateDbInstanceInput`](crate::input::CreateDbInstanceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_name: std::option::Option<std::string::String>,
        pub(crate) db_instance_identifier: std::option::Option<std::string::String>,
        pub(crate) allocated_storage: std::option::Option<i32>,
        pub(crate) db_instance_class: std::option::Option<std::string::String>,
        pub(crate) engine: std::option::Option<std::string::String>,
        pub(crate) master_username: std::option::Option<std::string::String>,
        pub(crate) master_user_password: std::option::Option<std::string::String>,
        pub(crate) db_security_groups: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) vpc_security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) availability_zone: std::option::Option<std::string::String>,
        pub(crate) db_subnet_group_name: std::option::Option<std::string::String>,
        pub(crate) preferred_maintenance_window: std::option::Option<std::string::String>,
        pub(crate) db_parameter_group_name: std::option::Option<std::string::String>,
        pub(crate) backup_retention_period: std::option::Option<i32>,
        pub(crate) preferred_backup_window: std::option::Option<std::string::String>,
        pub(crate) port: std::option::Option<i32>,
        pub(crate) multi_az: std::option::Option<bool>,
        pub(crate) engine_version: std::option::Option<std::string::String>,
        pub(crate) auto_minor_version_upgrade: std::option::Option<bool>,
        pub(crate) license_model: std::option::Option<std::string::String>,
        pub(crate) iops: std::option::Option<i32>,
        pub(crate) option_group_name: std::option::Option<std::string::String>,
        pub(crate) character_set_name: std::option::Option<std::string::String>,
        pub(crate) nchar_character_set_name: std::option::Option<std::string::String>,
        pub(crate) publicly_accessible: std::option::Option<bool>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) db_cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) storage_type: std::option::Option<std::string::String>,
        pub(crate) tde_credential_arn: std::option::Option<std::string::String>,
        pub(crate) tde_credential_password: std::option::Option<std::string::String>,
        pub(crate) storage_encrypted: std::option::Option<bool>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
        pub(crate) domain: std::option::Option<std::string::String>,
        pub(crate) copy_tags_to_snapshot: std::option::Option<bool>,
        pub(crate) monitoring_interval: std::option::Option<i32>,
        pub(crate) monitoring_role_arn: std::option::Option<std::string::String>,
        pub(crate) domain_iam_role_name: std::option::Option<std::string::String>,
        pub(crate) promotion_tier: std::option::Option<i32>,
        pub(crate) timezone: std::option::Option<std::string::String>,
        pub(crate) enable_iam_database_authentication: std::option::Option<bool>,
        pub(crate) enable_performance_insights: std::option::Option<bool>,
        pub(crate) performance_insights_kms_key_id: std::option::Option<std::string::String>,
        pub(crate) performance_insights_retention_period: std::option::Option<i32>,
        pub(crate) enable_cloudwatch_logs_exports:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) processor_features:
            std::option::Option<std::vec::Vec<crate::model::ProcessorFeature>>,
        pub(crate) deletion_protection: std::option::Option<bool>,
        pub(crate) max_allocated_storage: std::option::Option<i32>,
        pub(crate) enable_customer_owned_ip: std::option::Option<bool>,
        pub(crate) custom_iam_instance_profile: std::option::Option<std::string::String>,
        pub(crate) backup_target: std::option::Option<std::string::String>,
        pub(crate) network_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The meaning of this parameter differs according to the database engine you use.</p>
        /// <p> <b>MySQL</b> </p>
        /// <p>The name of the database to create when the DB instance is created. If this parameter isn't specified, no database is created in the DB instance.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must contain 1 to 64 letters or numbers.</p> </li>
        /// <li> <p>Must begin with a letter. Subsequent characters can be letters, underscores, or digits (0-9).</p> </li>
        /// <li> <p>Can't be a word reserved by the specified database engine</p> </li>
        /// </ul>
        /// <p> <b>MariaDB</b> </p>
        /// <p>The name of the database to create when the DB instance is created. If this parameter isn't specified, no database is created in the DB instance.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must contain 1 to 64 letters or numbers.</p> </li>
        /// <li> <p>Must begin with a letter. Subsequent characters can be letters, underscores, or digits (0-9).</p> </li>
        /// <li> <p>Can't be a word reserved by the specified database engine</p> </li>
        /// </ul>
        /// <p> <b>PostgreSQL</b> </p>
        /// <p>The name of the database to create when the DB instance is created. If this parameter isn't specified, a database named <code>postgres</code> is created in the DB instance.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must contain 1 to 63 letters, numbers, or underscores.</p> </li>
        /// <li> <p>Must begin with a letter. Subsequent characters can be letters, underscores, or digits (0-9).</p> </li>
        /// <li> <p>Can't be a word reserved by the specified database engine</p> </li>
        /// </ul>
        /// <p> <b>Oracle</b> </p>
        /// <p>The Oracle System ID (SID) of the created DB instance. If you specify <code>null</code>, the default value <code>ORCL</code> is used. You can't specify the string NULL, or any other reserved word, for <code>DBName</code>.</p>
        /// <p>Default: <code>ORCL</code> </p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Can't be longer than 8 characters</p> </li>
        /// </ul>
        /// <p> <b>Amazon RDS Custom for Oracle</b> </p>
        /// <p>The Oracle System ID (SID) of the created RDS Custom DB instance. If you don't specify a value, the default value is <code>ORCL</code>.</p>
        /// <p>Default: <code>ORCL</code> </p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>It must contain 1 to 8 alphanumeric characters.</p> </li>
        /// <li> <p>It must contain a letter.</p> </li>
        /// <li> <p>It can't be a word reserved by the database engine.</p> </li>
        /// </ul>
        /// <p> <b>Amazon RDS Custom for SQL Server</b> </p>
        /// <p>Not applicable. Must be null.</p>
        /// <p> <b>SQL Server</b> </p>
        /// <p>Not applicable. Must be null.</p>
        /// <p> <b>Amazon Aurora MySQL</b> </p>
        /// <p>The name of the database to create when the primary DB instance of the Aurora MySQL DB cluster is created. If this parameter isn't specified for an Aurora MySQL DB cluster, no database is created in the DB cluster.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>It must contain 1 to 64 alphanumeric characters.</p> </li>
        /// <li> <p>It can't be a word reserved by the database engine.</p> </li>
        /// </ul>
        /// <p> <b>Amazon Aurora PostgreSQL</b> </p>
        /// <p>The name of the database to create when the primary DB instance of the Aurora PostgreSQL DB cluster is created. If this parameter isn't specified for an Aurora PostgreSQL DB cluster, a database named <code>postgres</code> is created in the DB cluster.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>It must contain 1 to 63 alphanumeric characters.</p> </li>
        /// <li> <p>It must begin with a letter or an underscore. Subsequent characters can be letters, underscores, or digits (0 to 9).</p> </li>
        /// <li> <p>It can't be a word reserved by the database engine.</p> </li>
        /// </ul>
        pub fn db_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_name = Some(input.into());
            self
        }
        /// <p>The meaning of this parameter differs according to the database engine you use.</p>
        /// <p> <b>MySQL</b> </p>
        /// <p>The name of the database to create when the DB instance is created. If this parameter isn't specified, no database is created in the DB instance.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must contain 1 to 64 letters or numbers.</p> </li>
        /// <li> <p>Must begin with a letter. Subsequent characters can be letters, underscores, or digits (0-9).</p> </li>
        /// <li> <p>Can't be a word reserved by the specified database engine</p> </li>
        /// </ul>
        /// <p> <b>MariaDB</b> </p>
        /// <p>The name of the database to create when the DB instance is created. If this parameter isn't specified, no database is created in the DB instance.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must contain 1 to 64 letters or numbers.</p> </li>
        /// <li> <p>Must begin with a letter. Subsequent characters can be letters, underscores, or digits (0-9).</p> </li>
        /// <li> <p>Can't be a word reserved by the specified database engine</p> </li>
        /// </ul>
        /// <p> <b>PostgreSQL</b> </p>
        /// <p>The name of the database to create when the DB instance is created. If this parameter isn't specified, a database named <code>postgres</code> is created in the DB instance.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must contain 1 to 63 letters, numbers, or underscores.</p> </li>
        /// <li> <p>Must begin with a letter. Subsequent characters can be letters, underscores, or digits (0-9).</p> </li>
        /// <li> <p>Can't be a word reserved by the specified database engine</p> </li>
        /// </ul>
        /// <p> <b>Oracle</b> </p>
        /// <p>The Oracle System ID (SID) of the created DB instance. If you specify <code>null</code>, the default value <code>ORCL</code> is used. You can't specify the string NULL, or any other reserved word, for <code>DBName</code>.</p>
        /// <p>Default: <code>ORCL</code> </p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Can't be longer than 8 characters</p> </li>
        /// </ul>
        /// <p> <b>Amazon RDS Custom for Oracle</b> </p>
        /// <p>The Oracle System ID (SID) of the created RDS Custom DB instance. If you don't specify a value, the default value is <code>ORCL</code>.</p>
        /// <p>Default: <code>ORCL</code> </p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>It must contain 1 to 8 alphanumeric characters.</p> </li>
        /// <li> <p>It must contain a letter.</p> </li>
        /// <li> <p>It can't be a word reserved by the database engine.</p> </li>
        /// </ul>
        /// <p> <b>Amazon RDS Custom for SQL Server</b> </p>
        /// <p>Not applicable. Must be null.</p>
        /// <p> <b>SQL Server</b> </p>
        /// <p>Not applicable. Must be null.</p>
        /// <p> <b>Amazon Aurora MySQL</b> </p>
        /// <p>The name of the database to create when the primary DB instance of the Aurora MySQL DB cluster is created. If this parameter isn't specified for an Aurora MySQL DB cluster, no database is created in the DB cluster.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>It must contain 1 to 64 alphanumeric characters.</p> </li>
        /// <li> <p>It can't be a word reserved by the database engine.</p> </li>
        /// </ul>
        /// <p> <b>Amazon Aurora PostgreSQL</b> </p>
        /// <p>The name of the database to create when the primary DB instance of the Aurora PostgreSQL DB cluster is created. If this parameter isn't specified for an Aurora PostgreSQL DB cluster, a database named <code>postgres</code> is created in the DB cluster.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>It must contain 1 to 63 alphanumeric characters.</p> </li>
        /// <li> <p>It must begin with a letter or an underscore. Subsequent characters can be letters, underscores, or digits (0 to 9).</p> </li>
        /// <li> <p>It can't be a word reserved by the database engine.</p> </li>
        /// </ul>
        pub fn set_db_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.db_name = input;
            self
        }
        /// <p>The DB instance identifier. This parameter is stored as a lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p> </li>
        /// <li> <p>First character must be a letter.</p> </li>
        /// <li> <p>Can't end with a hyphen or contain two consecutive hyphens.</p> </li>
        /// </ul>
        /// <p>Example: <code>mydbinstance</code> </p>
        pub fn db_instance_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_instance_identifier = Some(input.into());
            self
        }
        /// <p>The DB instance identifier. This parameter is stored as a lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p> </li>
        /// <li> <p>First character must be a letter.</p> </li>
        /// <li> <p>Can't end with a hyphen or contain two consecutive hyphens.</p> </li>
        /// </ul>
        /// <p>Example: <code>mydbinstance</code> </p>
        pub fn set_db_instance_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_instance_identifier = input;
            self
        }
        /// <p>The amount of storage in gibibytes (GiB) to allocate for the DB instance.</p>
        /// <p>Type: Integer</p>
        /// <p> <b>Amazon Aurora</b> </p>
        /// <p>Not applicable. Aurora cluster volumes automatically grow as the amount of data in your database increases, though you are only charged for the space that you use in an Aurora cluster volume.</p>
        /// <p> <b>Amazon RDS Custom</b> </p>
        /// <p>Constraints to the amount of storage for each storage type are the following:</p>
        /// <ul>
        /// <li> <p>General Purpose (SSD) storage (gp2): Must be an integer from 40 to 65536 for RDS Custom for Oracle, 16384 for RDS Custom for SQL Server.</p> </li>
        /// <li> <p>Provisioned IOPS storage (io1): Must be an integer from 40 to 65536 for RDS Custom for Oracle, 16384 for RDS Custom for SQL Server.</p> </li>
        /// </ul>
        /// <p> <b>MySQL</b> </p>
        /// <p>Constraints to the amount of storage for each storage type are the following:</p>
        /// <ul>
        /// <li> <p>General Purpose (SSD) storage (gp2): Must be an integer from 20 to 65536.</p> </li>
        /// <li> <p>Provisioned IOPS storage (io1): Must be an integer from 100 to 65536.</p> </li>
        /// <li> <p>Magnetic storage (standard): Must be an integer from 5 to 3072.</p> </li>
        /// </ul>
        /// <p> <b>MariaDB</b> </p>
        /// <p>Constraints to the amount of storage for each storage type are the following:</p>
        /// <ul>
        /// <li> <p>General Purpose (SSD) storage (gp2): Must be an integer from 20 to 65536.</p> </li>
        /// <li> <p>Provisioned IOPS storage (io1): Must be an integer from 100 to 65536.</p> </li>
        /// <li> <p>Magnetic storage (standard): Must be an integer from 5 to 3072.</p> </li>
        /// </ul>
        /// <p> <b>PostgreSQL</b> </p>
        /// <p>Constraints to the amount of storage for each storage type are the following:</p>
        /// <ul>
        /// <li> <p>General Purpose (SSD) storage (gp2): Must be an integer from 20 to 65536.</p> </li>
        /// <li> <p>Provisioned IOPS storage (io1): Must be an integer from 100 to 65536.</p> </li>
        /// <li> <p>Magnetic storage (standard): Must be an integer from 5 to 3072.</p> </li>
        /// </ul>
        /// <p> <b>Oracle</b> </p>
        /// <p>Constraints to the amount of storage for each storage type are the following:</p>
        /// <ul>
        /// <li> <p>General Purpose (SSD) storage (gp2): Must be an integer from 20 to 65536.</p> </li>
        /// <li> <p>Provisioned IOPS storage (io1): Must be an integer from 100 to 65536.</p> </li>
        /// <li> <p>Magnetic storage (standard): Must be an integer from 10 to 3072.</p> </li>
        /// </ul>
        /// <p> <b>SQL Server</b> </p>
        /// <p>Constraints to the amount of storage for each storage type are the following:</p>
        /// <ul>
        /// <li> <p>General Purpose (SSD) storage (gp2):</p>
        /// <ul>
        /// <li> <p>Enterprise and Standard editions: Must be an integer from 20 to 16384.</p> </li>
        /// <li> <p>Web and Express editions: Must be an integer from 20 to 16384.</p> </li>
        /// </ul> </li>
        /// <li> <p>Provisioned IOPS storage (io1):</p>
        /// <ul>
        /// <li> <p>Enterprise and Standard editions: Must be an integer from 100 to 16384.</p> </li>
        /// <li> <p>Web and Express editions: Must be an integer from 100 to 16384.</p> </li>
        /// </ul> </li>
        /// <li> <p>Magnetic storage (standard):</p>
        /// <ul>
        /// <li> <p>Enterprise and Standard editions: Must be an integer from 20 to 1024.</p> </li>
        /// <li> <p>Web and Express editions: Must be an integer from 20 to 1024.</p> </li>
        /// </ul> </li>
        /// </ul>
        pub fn allocated_storage(mut self, input: i32) -> Self {
            self.allocated_storage = Some(input);
            self
        }
        /// <p>The amount of storage in gibibytes (GiB) to allocate for the DB instance.</p>
        /// <p>Type: Integer</p>
        /// <p> <b>Amazon Aurora</b> </p>
        /// <p>Not applicable. Aurora cluster volumes automatically grow as the amount of data in your database increases, though you are only charged for the space that you use in an Aurora cluster volume.</p>
        /// <p> <b>Amazon RDS Custom</b> </p>
        /// <p>Constraints to the amount of storage for each storage type are the following:</p>
        /// <ul>
        /// <li> <p>General Purpose (SSD) storage (gp2): Must be an integer from 40 to 65536 for RDS Custom for Oracle, 16384 for RDS Custom for SQL Server.</p> </li>
        /// <li> <p>Provisioned IOPS storage (io1): Must be an integer from 40 to 65536 for RDS Custom for Oracle, 16384 for RDS Custom for SQL Server.</p> </li>
        /// </ul>
        /// <p> <b>MySQL</b> </p>
        /// <p>Constraints to the amount of storage for each storage type are the following:</p>
        /// <ul>
        /// <li> <p>General Purpose (SSD) storage (gp2): Must be an integer from 20 to 65536.</p> </li>
        /// <li> <p>Provisioned IOPS storage (io1): Must be an integer from 100 to 65536.</p> </li>
        /// <li> <p>Magnetic storage (standard): Must be an integer from 5 to 3072.</p> </li>
        /// </ul>
        /// <p> <b>MariaDB</b> </p>
        /// <p>Constraints to the amount of storage for each storage type are the following:</p>
        /// <ul>
        /// <li> <p>General Purpose (SSD) storage (gp2): Must be an integer from 20 to 65536.</p> </li>
        /// <li> <p>Provisioned IOPS storage (io1): Must be an integer from 100 to 65536.</p> </li>
        /// <li> <p>Magnetic storage (standard): Must be an integer from 5 to 3072.</p> </li>
        /// </ul>
        /// <p> <b>PostgreSQL</b> </p>
        /// <p>Constraints to the amount of storage for each storage type are the following:</p>
        /// <ul>
        /// <li> <p>General Purpose (SSD) storage (gp2): Must be an integer from 20 to 65536.</p> </li>
        /// <li> <p>Provisioned IOPS storage (io1): Must be an integer from 100 to 65536.</p> </li>
        /// <li> <p>Magnetic storage (standard): Must be an integer from 5 to 3072.</p> </li>
        /// </ul>
        /// <p> <b>Oracle</b> </p>
        /// <p>Constraints to the amount of storage for each storage type are the following:</p>
        /// <ul>
        /// <li> <p>General Purpose (SSD) storage (gp2): Must be an integer from 20 to 65536.</p> </li>
        /// <li> <p>Provisioned IOPS storage (io1): Must be an integer from 100 to 65536.</p> </li>
        /// <li> <p>Magnetic storage (standard): Must be an integer from 10 to 3072.</p> </li>
        /// </ul>
        /// <p> <b>SQL Server</b> </p>
        /// <p>Constraints to the amount of storage for each storage type are the following:</p>
        /// <ul>
        /// <li> <p>General Purpose (SSD) storage (gp2):</p>
        /// <ul>
        /// <li> <p>Enterprise and Standard editions: Must be an integer from 20 to 16384.</p> </li>
        /// <li> <p>Web and Express editions: Must be an integer from 20 to 16384.</p> </li>
        /// </ul> </li>
        /// <li> <p>Provisioned IOPS storage (io1):</p>
        /// <ul>
        /// <li> <p>Enterprise and Standard editions: Must be an integer from 100 to 16384.</p> </li>
        /// <li> <p>Web and Express editions: Must be an integer from 100 to 16384.</p> </li>
        /// </ul> </li>
        /// <li> <p>Magnetic storage (standard):</p>
        /// <ul>
        /// <li> <p>Enterprise and Standard editions: Must be an integer from 20 to 1024.</p> </li>
        /// <li> <p>Web and Express editions: Must be an integer from 20 to 1024.</p> </li>
        /// </ul> </li>
        /// </ul>
        pub fn set_allocated_storage(mut self, input: std::option::Option<i32>) -> Self {
            self.allocated_storage = input;
            self
        }
        /// <p>The compute and memory capacity of the DB instance, for example db.m4.large. Not all DB instance classes are available in all Amazon Web Services Regions, or for all database engines. For the full list of DB instance classes, and availability for your engine, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html">DB Instance Class</a> in the <i>Amazon RDS User Guide</i>.</p>
        pub fn db_instance_class(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_instance_class = Some(input.into());
            self
        }
        /// <p>The compute and memory capacity of the DB instance, for example db.m4.large. Not all DB instance classes are available in all Amazon Web Services Regions, or for all database engines. For the full list of DB instance classes, and availability for your engine, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html">DB Instance Class</a> in the <i>Amazon RDS User Guide</i>.</p>
        pub fn set_db_instance_class(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_instance_class = input;
            self
        }
        /// <p>The name of the database engine to be used for this instance.</p>
        /// <p>Not every database engine is available for every Amazon Web Services Region.</p>
        /// <p>Valid Values:</p>
        /// <ul>
        /// <li> <p> <code>aurora</code> (for MySQL 5.6-compatible Aurora)</p> </li>
        /// <li> <p> <code>aurora-mysql</code> (for MySQL 5.7-compatible and MySQL 8.0-compatible Aurora)</p> </li>
        /// <li> <p> <code>aurora-postgresql</code> </p> </li>
        /// <li> <p> <code>custom-oracle-ee (for RDS Custom for Oracle instances)</code> </p> </li>
        /// <li> <p> <code>custom-sqlserver-ee (for RDS Custom for SQL Server instances)</code> </p> </li>
        /// <li> <p> <code>custom-sqlserver-se (for RDS Custom for SQL Server instances)</code> </p> </li>
        /// <li> <p> <code>custom-sqlserver-web (for RDS Custom for SQL Server instances)</code> </p> </li>
        /// <li> <p> <code>mariadb</code> </p> </li>
        /// <li> <p> <code>mysql</code> </p> </li>
        /// <li> <p> <code>oracle-ee</code> </p> </li>
        /// <li> <p> <code>oracle-ee-cdb</code> </p> </li>
        /// <li> <p> <code>oracle-se2</code> </p> </li>
        /// <li> <p> <code>oracle-se2-cdb</code> </p> </li>
        /// <li> <p> <code>postgres</code> </p> </li>
        /// <li> <p> <code>sqlserver-ee</code> </p> </li>
        /// <li> <p> <code>sqlserver-se</code> </p> </li>
        /// <li> <p> <code>sqlserver-ex</code> </p> </li>
        /// <li> <p> <code>sqlserver-web</code> </p> </li>
        /// </ul>
        pub fn engine(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine = Some(input.into());
            self
        }
        /// <p>The name of the database engine to be used for this instance.</p>
        /// <p>Not every database engine is available for every Amazon Web Services Region.</p>
        /// <p>Valid Values:</p>
        /// <ul>
        /// <li> <p> <code>aurora</code> (for MySQL 5.6-compatible Aurora)</p> </li>
        /// <li> <p> <code>aurora-mysql</code> (for MySQL 5.7-compatible and MySQL 8.0-compatible Aurora)</p> </li>
        /// <li> <p> <code>aurora-postgresql</code> </p> </li>
        /// <li> <p> <code>custom-oracle-ee (for RDS Custom for Oracle instances)</code> </p> </li>
        /// <li> <p> <code>custom-sqlserver-ee (for RDS Custom for SQL Server instances)</code> </p> </li>
        /// <li> <p> <code>custom-sqlserver-se (for RDS Custom for SQL Server instances)</code> </p> </li>
        /// <li> <p> <code>custom-sqlserver-web (for RDS Custom for SQL Server instances)</code> </p> </li>
        /// <li> <p> <code>mariadb</code> </p> </li>
        /// <li> <p> <code>mysql</code> </p> </li>
        /// <li> <p> <code>oracle-ee</code> </p> </li>
        /// <li> <p> <code>oracle-ee-cdb</code> </p> </li>
        /// <li> <p> <code>oracle-se2</code> </p> </li>
        /// <li> <p> <code>oracle-se2-cdb</code> </p> </li>
        /// <li> <p> <code>postgres</code> </p> </li>
        /// <li> <p> <code>sqlserver-ee</code> </p> </li>
        /// <li> <p> <code>sqlserver-se</code> </p> </li>
        /// <li> <p> <code>sqlserver-ex</code> </p> </li>
        /// <li> <p> <code>sqlserver-web</code> </p> </li>
        /// </ul>
        pub fn set_engine(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.engine = input;
            self
        }
        /// <p>The name for the master user.</p>
        /// <p> <b>Amazon Aurora</b> </p>
        /// <p>Not applicable. The name for the master user is managed by the DB cluster.</p>
        /// <p> <b>Amazon RDS</b> </p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Required.</p> </li>
        /// <li> <p>Must be 1 to 16 letters, numbers, or underscores.</p> </li>
        /// <li> <p>First character must be a letter.</p> </li>
        /// <li> <p>Can't be a reserved word for the chosen database engine.</p> </li>
        /// </ul>
        pub fn master_username(mut self, input: impl Into<std::string::String>) -> Self {
            self.master_username = Some(input.into());
            self
        }
        /// <p>The name for the master user.</p>
        /// <p> <b>Amazon Aurora</b> </p>
        /// <p>Not applicable. The name for the master user is managed by the DB cluster.</p>
        /// <p> <b>Amazon RDS</b> </p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Required.</p> </li>
        /// <li> <p>Must be 1 to 16 letters, numbers, or underscores.</p> </li>
        /// <li> <p>First character must be a letter.</p> </li>
        /// <li> <p>Can't be a reserved word for the chosen database engine.</p> </li>
        /// </ul>
        pub fn set_master_username(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.master_username = input;
            self
        }
        /// <p>The password for the master user. The password can include any printable ASCII character except "/", """, or "@".</p>
        /// <p> <b>Amazon Aurora</b> </p>
        /// <p>Not applicable. The password for the master user is managed by the DB cluster.</p>
        /// <p> <b>MariaDB</b> </p>
        /// <p>Constraints: Must contain from 8 to 41 characters.</p>
        /// <p> <b>Microsoft SQL Server</b> </p>
        /// <p>Constraints: Must contain from 8 to 128 characters.</p>
        /// <p> <b>MySQL</b> </p>
        /// <p>Constraints: Must contain from 8 to 41 characters.</p>
        /// <p> <b>Oracle</b> </p>
        /// <p>Constraints: Must contain from 8 to 30 characters.</p>
        /// <p> <b>PostgreSQL</b> </p>
        /// <p>Constraints: Must contain from 8 to 128 characters.</p>
        pub fn master_user_password(mut self, input: impl Into<std::string::String>) -> Self {
            self.master_user_password = Some(input.into());
            self
        }
        /// <p>The password for the master user. The password can include any printable ASCII character except "/", """, or "@".</p>
        /// <p> <b>Amazon Aurora</b> </p>
        /// <p>Not applicable. The password for the master user is managed by the DB cluster.</p>
        /// <p> <b>MariaDB</b> </p>
        /// <p>Constraints: Must contain from 8 to 41 characters.</p>
        /// <p> <b>Microsoft SQL Server</b> </p>
        /// <p>Constraints: Must contain from 8 to 128 characters.</p>
        /// <p> <b>MySQL</b> </p>
        /// <p>Constraints: Must contain from 8 to 41 characters.</p>
        /// <p> <b>Oracle</b> </p>
        /// <p>Constraints: Must contain from 8 to 30 characters.</p>
        /// <p> <b>PostgreSQL</b> </p>
        /// <p>Constraints: Must contain from 8 to 128 characters.</p>
        pub fn set_master_user_password(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.master_user_password = input;
            self
        }
        /// Appends an item to `db_security_groups`.
        ///
        /// To override the contents of this collection use [`set_db_security_groups`](Self::set_db_security_groups).
        ///
        /// <p>A list of DB security groups to associate with this DB instance.</p>
        /// <p>Default: The default DB security group for the database engine.</p>
        pub fn db_security_groups(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.db_security_groups.unwrap_or_default();
            v.push(input.into());
            self.db_security_groups = Some(v);
            self
        }
        /// <p>A list of DB security groups to associate with this DB instance.</p>
        /// <p>Default: The default DB security group for the database engine.</p>
        pub fn set_db_security_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.db_security_groups = input;
            self
        }
        /// Appends an item to `vpc_security_group_ids`.
        ///
        /// To override the contents of this collection use [`set_vpc_security_group_ids`](Self::set_vpc_security_group_ids).
        ///
        /// <p>A list of Amazon EC2 VPC security groups to associate with this DB instance.</p>
        /// <p> <b>Amazon Aurora</b> </p>
        /// <p>Not applicable. The associated list of EC2 VPC security groups is managed by the DB cluster.</p>
        /// <p>Default: The default EC2 VPC security group for the DB subnet group's VPC.</p>
        pub fn vpc_security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.vpc_security_group_ids.unwrap_or_default();
            v.push(input.into());
            self.vpc_security_group_ids = Some(v);
            self
        }
        /// <p>A list of Amazon EC2 VPC security groups to associate with this DB instance.</p>
        /// <p> <b>Amazon Aurora</b> </p>
        /// <p>Not applicable. The associated list of EC2 VPC security groups is managed by the DB cluster.</p>
        /// <p>Default: The default EC2 VPC security group for the DB subnet group's VPC.</p>
        pub fn set_vpc_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.vpc_security_group_ids = input;
            self
        }
        /// <p>The Availability Zone (AZ) where the database will be created. For information on Amazon Web Services Regions and Availability Zones, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.RegionsAndAvailabilityZones.html">Regions and Availability Zones</a>.</p>
        /// <p> <b>Amazon Aurora</b> </p>
        /// <p>Each Aurora DB cluster hosts copies of its storage in three separate Availability Zones. Specify one of these Availability Zones. Aurora automatically chooses an appropriate Availability Zone if you don't specify one.</p>
        /// <p>Default: A random, system-chosen Availability Zone in the endpoint's Amazon Web Services Region.</p>
        /// <p>Example: <code>us-east-1d</code> </p>
        /// <p>Constraint: The <code>AvailabilityZone</code> parameter can't be specified if the DB instance is a Multi-AZ deployment. The specified Availability Zone must be in the same Amazon Web Services Region as the current endpoint.</p>
        pub fn availability_zone(mut self, input: impl Into<std::string::String>) -> Self {
            self.availability_zone = Some(input.into());
            self
        }
        /// <p>The Availability Zone (AZ) where the database will be created. For information on Amazon Web Services Regions and Availability Zones, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.RegionsAndAvailabilityZones.html">Regions and Availability Zones</a>.</p>
        /// <p> <b>Amazon Aurora</b> </p>
        /// <p>Each Aurora DB cluster hosts copies of its storage in three separate Availability Zones. Specify one of these Availability Zones. Aurora automatically chooses an appropriate Availability Zone if you don't specify one.</p>
        /// <p>Default: A random, system-chosen Availability Zone in the endpoint's Amazon Web Services Region.</p>
        /// <p>Example: <code>us-east-1d</code> </p>
        /// <p>Constraint: The <code>AvailabilityZone</code> parameter can't be specified if the DB instance is a Multi-AZ deployment. The specified Availability Zone must be in the same Amazon Web Services Region as the current endpoint.</p>
        pub fn set_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.availability_zone = input;
            self
        }
        /// <p>A DB subnet group to associate with this DB instance.</p>
        /// <p>Constraints: Must match the name of an existing DBSubnetGroup. Must not be default.</p>
        /// <p>Example: <code>mydbsubnetgroup</code> </p>
        pub fn db_subnet_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_subnet_group_name = Some(input.into());
            self
        }
        /// <p>A DB subnet group to associate with this DB instance.</p>
        /// <p>Constraints: Must match the name of an existing DBSubnetGroup. Must not be default.</p>
        /// <p>Example: <code>mydbsubnetgroup</code> </p>
        pub fn set_db_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_subnet_group_name = input;
            self
        }
        /// <p>The time range each week during which system maintenance can occur, in Universal Coordinated Time (UTC). For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Maintenance.html#Concepts.DBMaintenance">Amazon RDS Maintenance Window</a>.</p>
        /// <p>Format: <code>ddd:hh24:mi-ddd:hh24:mi</code> </p>
        /// <p>The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Web Services Region, occurring on a random day of the week.</p>
        /// <p>Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.</p>
        /// <p>Constraints: Minimum 30-minute window.</p>
        pub fn preferred_maintenance_window(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.preferred_maintenance_window = Some(input.into());
            self
        }
        /// <p>The time range each week during which system maintenance can occur, in Universal Coordinated Time (UTC). For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Maintenance.html#Concepts.DBMaintenance">Amazon RDS Maintenance Window</a>.</p>
        /// <p>Format: <code>ddd:hh24:mi-ddd:hh24:mi</code> </p>
        /// <p>The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Web Services Region, occurring on a random day of the week.</p>
        /// <p>Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.</p>
        /// <p>Constraints: Minimum 30-minute window.</p>
        pub fn set_preferred_maintenance_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.preferred_maintenance_window = input;
            self
        }
        /// <p>The name of the DB parameter group to associate with this DB instance. If you do not specify a value, then the default DB parameter group for the specified DB engine and version is used.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be 1 to 255 letters, numbers, or hyphens.</p> </li>
        /// <li> <p>First character must be a letter</p> </li>
        /// <li> <p>Can't end with a hyphen or contain two consecutive hyphens</p> </li>
        /// </ul>
        pub fn db_parameter_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_parameter_group_name = Some(input.into());
            self
        }
        /// <p>The name of the DB parameter group to associate with this DB instance. If you do not specify a value, then the default DB parameter group for the specified DB engine and version is used.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be 1 to 255 letters, numbers, or hyphens.</p> </li>
        /// <li> <p>First character must be a letter</p> </li>
        /// <li> <p>Can't end with a hyphen or contain two consecutive hyphens</p> </li>
        /// </ul>
        pub fn set_db_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_parameter_group_name = input;
            self
        }
        /// <p>The number of days for which automated backups are retained. Setting this parameter to a positive number enables backups. Setting this parameter to 0 disables automated backups.</p>
        /// <p> <b>Amazon Aurora</b> </p>
        /// <p>Not applicable. The retention period for automated backups is managed by the DB cluster.</p>
        /// <p>Default: 1</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be a value from 0 to 35</p> </li>
        /// <li> <p>Can't be set to 0 if the DB instance is a source to read replicas</p> </li>
        /// <li> <p>Can't be set to 0 or 35 for an RDS Custom for Oracle DB instance</p> </li>
        /// </ul>
        pub fn backup_retention_period(mut self, input: i32) -> Self {
            self.backup_retention_period = Some(input);
            self
        }
        /// <p>The number of days for which automated backups are retained. Setting this parameter to a positive number enables backups. Setting this parameter to 0 disables automated backups.</p>
        /// <p> <b>Amazon Aurora</b> </p>
        /// <p>Not applicable. The retention period for automated backups is managed by the DB cluster.</p>
        /// <p>Default: 1</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be a value from 0 to 35</p> </li>
        /// <li> <p>Can't be set to 0 if the DB instance is a source to read replicas</p> </li>
        /// <li> <p>Can't be set to 0 or 35 for an RDS Custom for Oracle DB instance</p> </li>
        /// </ul>
        pub fn set_backup_retention_period(mut self, input: std::option::Option<i32>) -> Self {
            self.backup_retention_period = input;
            self
        }
        /// <p>The daily time range during which automated backups are created if automated backups are enabled, using the <code>BackupRetentionPeriod</code> parameter. The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Web Services Region. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithAutomatedBackups.html#USER_WorkingWithAutomatedBackups.BackupWindow">Backup window</a> in the <i>Amazon RDS User Guide</i>.</p>
        /// <p> <b>Amazon Aurora</b> </p>
        /// <p>Not applicable. The daily time range for creating automated backups is managed by the DB cluster.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be in the format <code>hh24:mi-hh24:mi</code>.</p> </li>
        /// <li> <p>Must be in Universal Coordinated Time (UTC).</p> </li>
        /// <li> <p>Must not conflict with the preferred maintenance window.</p> </li>
        /// <li> <p>Must be at least 30 minutes.</p> </li>
        /// </ul>
        pub fn preferred_backup_window(mut self, input: impl Into<std::string::String>) -> Self {
            self.preferred_backup_window = Some(input.into());
            self
        }
        /// <p>The daily time range during which automated backups are created if automated backups are enabled, using the <code>BackupRetentionPeriod</code> parameter. The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Web Services Region. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithAutomatedBackups.html#USER_WorkingWithAutomatedBackups.BackupWindow">Backup window</a> in the <i>Amazon RDS User Guide</i>.</p>
        /// <p> <b>Amazon Aurora</b> </p>
        /// <p>Not applicable. The daily time range for creating automated backups is managed by the DB cluster.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be in the format <code>hh24:mi-hh24:mi</code>.</p> </li>
        /// <li> <p>Must be in Universal Coordinated Time (UTC).</p> </li>
        /// <li> <p>Must not conflict with the preferred maintenance window.</p> </li>
        /// <li> <p>Must be at least 30 minutes.</p> </li>
        /// </ul>
        pub fn set_preferred_backup_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.preferred_backup_window = input;
            self
        }
        /// <p>The port number on which the database accepts connections.</p>
        /// <p> <b>MySQL</b> </p>
        /// <p>Default: <code>3306</code> </p>
        /// <p>Valid values: <code>1150-65535</code> </p>
        /// <p>Type: Integer</p>
        /// <p> <b>MariaDB</b> </p>
        /// <p>Default: <code>3306</code> </p>
        /// <p>Valid values: <code>1150-65535</code> </p>
        /// <p>Type: Integer</p>
        /// <p> <b>PostgreSQL</b> </p>
        /// <p>Default: <code>5432</code> </p>
        /// <p>Valid values: <code>1150-65535</code> </p>
        /// <p>Type: Integer</p>
        /// <p> <b>Oracle</b> </p>
        /// <p>Default: <code>1521</code> </p>
        /// <p>Valid values: <code>1150-65535</code> </p>
        /// <p> <b>SQL Server</b> </p>
        /// <p>Default: <code>1433</code> </p>
        /// <p>Valid values: <code>1150-65535</code> except <code>1234</code>, <code>1434</code>, <code>3260</code>, <code>3343</code>, <code>3389</code>, <code>47001</code>, and <code>49152-49156</code>.</p>
        /// <p> <b>Amazon Aurora</b> </p>
        /// <p>Default: <code>3306</code> </p>
        /// <p>Valid values: <code>1150-65535</code> </p>
        /// <p>Type: Integer</p>
        pub fn port(mut self, input: i32) -> Self {
            self.port = Some(input);
            self
        }
        /// <p>The port number on which the database accepts connections.</p>
        /// <p> <b>MySQL</b> </p>
        /// <p>Default: <code>3306</code> </p>
        /// <p>Valid values: <code>1150-65535</code> </p>
        /// <p>Type: Integer</p>
        /// <p> <b>MariaDB</b> </p>
        /// <p>Default: <code>3306</code> </p>
        /// <p>Valid values: <code>1150-65535</code> </p>
        /// <p>Type: Integer</p>
        /// <p> <b>PostgreSQL</b> </p>
        /// <p>Default: <code>5432</code> </p>
        /// <p>Valid values: <code>1150-65535</code> </p>
        /// <p>Type: Integer</p>
        /// <p> <b>Oracle</b> </p>
        /// <p>Default: <code>1521</code> </p>
        /// <p>Valid values: <code>1150-65535</code> </p>
        /// <p> <b>SQL Server</b> </p>
        /// <p>Default: <code>1433</code> </p>
        /// <p>Valid values: <code>1150-65535</code> except <code>1234</code>, <code>1434</code>, <code>3260</code>, <code>3343</code>, <code>3389</code>, <code>47001</code>, and <code>49152-49156</code>.</p>
        /// <p> <b>Amazon Aurora</b> </p>
        /// <p>Default: <code>3306</code> </p>
        /// <p>Valid values: <code>1150-65535</code> </p>
        /// <p>Type: Integer</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.port = input;
            self
        }
        /// <p>A value that indicates whether the DB instance is a Multi-AZ deployment. You can't set the <code>AvailabilityZone</code> parameter if the DB instance is a Multi-AZ deployment.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn multi_az(mut self, input: bool) -> Self {
            self.multi_az = Some(input);
            self
        }
        /// <p>A value that indicates whether the DB instance is a Multi-AZ deployment. You can't set the <code>AvailabilityZone</code> parameter if the DB instance is a Multi-AZ deployment.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn set_multi_az(mut self, input: std::option::Option<bool>) -> Self {
            self.multi_az = input;
            self
        }
        /// <p>The version number of the database engine to use.</p>
        /// <p>For a list of valid engine versions, use the <code>DescribeDBEngineVersions</code> action.</p>
        /// <p>The following are the database engines and links to information about the major and minor versions that are available with Amazon RDS. Not every database engine is available for every Amazon Web Services Region.</p>
        /// <p> <b>Amazon Aurora</b> </p>
        /// <p>Not applicable. The version number of the database engine to be used by the DB instance is managed by the DB cluster.</p>
        /// <p> <b>Amazon RDS Custom for Oracle</b> </p>
        /// <p>A custom engine version (CEV) that you have previously created. This setting is required for RDS Custom for Oracle. The CEV name has the following format: <code>19.<i>customized_string</i> </code>. An example identifier is <code>19.my_cev1</code>. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-creating.html#custom-creating.create"> Creating an RDS Custom for Oracle DB instance</a> in the <i>Amazon RDS User Guide</i>.</p>
        /// <p> <b>Amazon RDS Custom for SQL Server</b> </p>
        /// <p>See <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-reqs-limits-MS.html">RDS Custom for SQL Server general requirements</a> in the <i>Amazon RDS User Guide</i>.</p>
        /// <p> <b>MariaDB</b> </p>
        /// <p>For information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_MariaDB.html#MariaDB.Concepts.VersionMgmt">MariaDB on Amazon RDS Versions</a> in the <i>Amazon RDS User Guide</i>.</p>
        /// <p> <b>Microsoft SQL Server</b> </p>
        /// <p>For information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_SQLServer.html#SQLServer.Concepts.General.VersionSupport">Microsoft SQL Server Versions on Amazon RDS</a> in the <i>Amazon RDS User Guide</i>.</p>
        /// <p> <b>MySQL</b> </p>
        /// <p>For information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_MySQL.html#MySQL.Concepts.VersionMgmt">MySQL on Amazon RDS Versions</a> in the <i>Amazon RDS User Guide</i>.</p>
        /// <p> <b>Oracle</b> </p>
        /// <p>For information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Appendix.Oracle.PatchComposition.html">Oracle Database Engine Release Notes</a> in the <i>Amazon RDS User Guide</i>.</p>
        /// <p> <b>PostgreSQL</b> </p>
        /// <p>For information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_PostgreSQL.html#PostgreSQL.Concepts">Amazon RDS for PostgreSQL versions and extensions</a> in the <i>Amazon RDS User Guide</i>.</p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_version = Some(input.into());
            self
        }
        /// <p>The version number of the database engine to use.</p>
        /// <p>For a list of valid engine versions, use the <code>DescribeDBEngineVersions</code> action.</p>
        /// <p>The following are the database engines and links to information about the major and minor versions that are available with Amazon RDS. Not every database engine is available for every Amazon Web Services Region.</p>
        /// <p> <b>Amazon Aurora</b> </p>
        /// <p>Not applicable. The version number of the database engine to be used by the DB instance is managed by the DB cluster.</p>
        /// <p> <b>Amazon RDS Custom for Oracle</b> </p>
        /// <p>A custom engine version (CEV) that you have previously created. This setting is required for RDS Custom for Oracle. The CEV name has the following format: <code>19.<i>customized_string</i> </code>. An example identifier is <code>19.my_cev1</code>. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-creating.html#custom-creating.create"> Creating an RDS Custom for Oracle DB instance</a> in the <i>Amazon RDS User Guide</i>.</p>
        /// <p> <b>Amazon RDS Custom for SQL Server</b> </p>
        /// <p>See <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-reqs-limits-MS.html">RDS Custom for SQL Server general requirements</a> in the <i>Amazon RDS User Guide</i>.</p>
        /// <p> <b>MariaDB</b> </p>
        /// <p>For information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_MariaDB.html#MariaDB.Concepts.VersionMgmt">MariaDB on Amazon RDS Versions</a> in the <i>Amazon RDS User Guide</i>.</p>
        /// <p> <b>Microsoft SQL Server</b> </p>
        /// <p>For information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_SQLServer.html#SQLServer.Concepts.General.VersionSupport">Microsoft SQL Server Versions on Amazon RDS</a> in the <i>Amazon RDS User Guide</i>.</p>
        /// <p> <b>MySQL</b> </p>
        /// <p>For information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_MySQL.html#MySQL.Concepts.VersionMgmt">MySQL on Amazon RDS Versions</a> in the <i>Amazon RDS User Guide</i>.</p>
        /// <p> <b>Oracle</b> </p>
        /// <p>For information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Appendix.Oracle.PatchComposition.html">Oracle Database Engine Release Notes</a> in the <i>Amazon RDS User Guide</i>.</p>
        /// <p> <b>PostgreSQL</b> </p>
        /// <p>For information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_PostgreSQL.html#PostgreSQL.Concepts">Amazon RDS for PostgreSQL versions and extensions</a> in the <i>Amazon RDS User Guide</i>.</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.engine_version = input;
            self
        }
        /// <p>A value that indicates whether minor engine upgrades are applied automatically to the DB instance during the maintenance window. By default, minor engine upgrades are applied automatically.</p>
        /// <p>If you create an RDS Custom DB instance, you must set <code>AutoMinorVersionUpgrade</code> to <code>false</code>.</p>
        pub fn auto_minor_version_upgrade(mut self, input: bool) -> Self {
            self.auto_minor_version_upgrade = Some(input);
            self
        }
        /// <p>A value that indicates whether minor engine upgrades are applied automatically to the DB instance during the maintenance window. By default, minor engine upgrades are applied automatically.</p>
        /// <p>If you create an RDS Custom DB instance, you must set <code>AutoMinorVersionUpgrade</code> to <code>false</code>.</p>
        pub fn set_auto_minor_version_upgrade(mut self, input: std::option::Option<bool>) -> Self {
            self.auto_minor_version_upgrade = input;
            self
        }
        /// <p>License model information for this DB instance.</p>
        /// <p>Valid values: <code>license-included</code> | <code>bring-your-own-license</code> | <code>general-public-license</code> </p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn license_model(mut self, input: impl Into<std::string::String>) -> Self {
            self.license_model = Some(input.into());
            self
        }
        /// <p>License model information for this DB instance.</p>
        /// <p>Valid values: <code>license-included</code> | <code>bring-your-own-license</code> | <code>general-public-license</code> </p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn set_license_model(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.license_model = input;
            self
        }
        /// <p>The amount of Provisioned IOPS (input/output operations per second) to be initially allocated for the DB instance. For information about valid <code>Iops</code> values, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#USER_PIOPS">Amazon RDS Provisioned IOPS storage to improve performance</a> in the <i>Amazon RDS User Guide</i>.</p>
        /// <p>Constraints: For MariaDB, MySQL, Oracle, and PostgreSQL DB instances, must be a multiple between .5 and 50 of the storage amount for the DB instance. For SQL Server DB instances, must be a multiple between 1 and 50 of the storage amount for the DB instance.</p>
        pub fn iops(mut self, input: i32) -> Self {
            self.iops = Some(input);
            self
        }
        /// <p>The amount of Provisioned IOPS (input/output operations per second) to be initially allocated for the DB instance. For information about valid <code>Iops</code> values, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#USER_PIOPS">Amazon RDS Provisioned IOPS storage to improve performance</a> in the <i>Amazon RDS User Guide</i>.</p>
        /// <p>Constraints: For MariaDB, MySQL, Oracle, and PostgreSQL DB instances, must be a multiple between .5 and 50 of the storage amount for the DB instance. For SQL Server DB instances, must be a multiple between 1 and 50 of the storage amount for the DB instance.</p>
        pub fn set_iops(mut self, input: std::option::Option<i32>) -> Self {
            self.iops = input;
            self
        }
        /// <p>A value that indicates that the DB instance should be associated with the specified option group.</p>
        /// <p>Permanent options, such as the TDE option for Oracle Advanced Security TDE, can't be removed from an option group. Also, that option group can't be removed from a DB instance after it is associated with a DB instance.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn option_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.option_group_name = Some(input.into());
            self
        }
        /// <p>A value that indicates that the DB instance should be associated with the specified option group.</p>
        /// <p>Permanent options, such as the TDE option for Oracle Advanced Security TDE, can't be removed from an option group. Also, that option group can't be removed from a DB instance after it is associated with a DB instance.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn set_option_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.option_group_name = input;
            self
        }
        /// <p>For supported engines, this value indicates that the DB instance should be associated with the specified <code>CharacterSet</code>.</p>
        /// <p>This setting doesn't apply to RDS Custom. However, if you need to change the character set, you can change it on the database itself.</p>
        /// <p> <b>Amazon Aurora</b> </p>
        /// <p>Not applicable. The character set is managed by the DB cluster. For more information, see <code>CreateDBCluster</code>.</p>
        pub fn character_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.character_set_name = Some(input.into());
            self
        }
        /// <p>For supported engines, this value indicates that the DB instance should be associated with the specified <code>CharacterSet</code>.</p>
        /// <p>This setting doesn't apply to RDS Custom. However, if you need to change the character set, you can change it on the database itself.</p>
        /// <p> <b>Amazon Aurora</b> </p>
        /// <p>Not applicable. The character set is managed by the DB cluster. For more information, see <code>CreateDBCluster</code>.</p>
        pub fn set_character_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.character_set_name = input;
            self
        }
        /// <p>The name of the NCHAR character set for the Oracle DB instance.</p>
        /// <p>This parameter doesn't apply to RDS Custom.</p>
        pub fn nchar_character_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.nchar_character_set_name = Some(input.into());
            self
        }
        /// <p>The name of the NCHAR character set for the Oracle DB instance.</p>
        /// <p>This parameter doesn't apply to RDS Custom.</p>
        pub fn set_nchar_character_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.nchar_character_set_name = input;
            self
        }
        /// <p>A value that indicates whether the DB instance is publicly accessible.</p>
        /// <p>When the DB instance is publicly accessible, its Domain Name System (DNS) endpoint resolves to the private IP address from within the DB instance's virtual private cloud (VPC). It resolves to the public IP address from outside of the DB instance's VPC. Access to the DB instance is ultimately controlled by the security group it uses. That public access is not permitted if the security group assigned to the DB instance doesn't permit it.</p>
        /// <p>When the DB instance isn't publicly accessible, it is an internal DB instance with a DNS name that resolves to a private IP address.</p>
        /// <p>Default: The default behavior varies depending on whether <code>DBSubnetGroupName</code> is specified.</p>
        /// <p>If <code>DBSubnetGroupName</code> isn't specified, and <code>PubliclyAccessible</code> isn't specified, the following applies:</p>
        /// <ul>
        /// <li> <p>If the default VPC in the target Region doesn’t have an internet gateway attached to it, the DB instance is private.</p> </li>
        /// <li> <p>If the default VPC in the target Region has an internet gateway attached to it, the DB instance is public.</p> </li>
        /// </ul>
        /// <p>If <code>DBSubnetGroupName</code> is specified, and <code>PubliclyAccessible</code> isn't specified, the following applies:</p>
        /// <ul>
        /// <li> <p>If the subnets are part of a VPC that doesn’t have an internet gateway attached to it, the DB instance is private.</p> </li>
        /// <li> <p>If the subnets are part of a VPC that has an internet gateway attached to it, the DB instance is public.</p> </li>
        /// </ul>
        pub fn publicly_accessible(mut self, input: bool) -> Self {
            self.publicly_accessible = Some(input);
            self
        }
        /// <p>A value that indicates whether the DB instance is publicly accessible.</p>
        /// <p>When the DB instance is publicly accessible, its Domain Name System (DNS) endpoint resolves to the private IP address from within the DB instance's virtual private cloud (VPC). It resolves to the public IP address from outside of the DB instance's VPC. Access to the DB instance is ultimately controlled by the security group it uses. That public access is not permitted if the security group assigned to the DB instance doesn't permit it.</p>
        /// <p>When the DB instance isn't publicly accessible, it is an internal DB instance with a DNS name that resolves to a private IP address.</p>
        /// <p>Default: The default behavior varies depending on whether <code>DBSubnetGroupName</code> is specified.</p>
        /// <p>If <code>DBSubnetGroupName</code> isn't specified, and <code>PubliclyAccessible</code> isn't specified, the following applies:</p>
        /// <ul>
        /// <li> <p>If the default VPC in the target Region doesn’t have an internet gateway attached to it, the DB instance is private.</p> </li>
        /// <li> <p>If the default VPC in the target Region has an internet gateway attached to it, the DB instance is public.</p> </li>
        /// </ul>
        /// <p>If <code>DBSubnetGroupName</code> is specified, and <code>PubliclyAccessible</code> isn't specified, the following applies:</p>
        /// <ul>
        /// <li> <p>If the subnets are part of a VPC that doesn’t have an internet gateway attached to it, the DB instance is private.</p> </li>
        /// <li> <p>If the subnets are part of a VPC that has an internet gateway attached to it, the DB instance is public.</p> </li>
        /// </ul>
        pub fn set_publicly_accessible(mut self, input: std::option::Option<bool>) -> Self {
            self.publicly_accessible = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags to assign to the DB instance.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>Tags to assign to the DB instance.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The identifier of the DB cluster that the instance will belong to.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn db_cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_cluster_identifier = Some(input.into());
            self
        }
        /// <p>The identifier of the DB cluster that the instance will belong to.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_identifier = input;
            self
        }
        /// <p>Specifies the storage type to be associated with the DB instance.</p>
        /// <p>Valid values: <code>standard | gp2 | io1</code> </p>
        /// <p>If you specify <code>io1</code>, you must also include a value for the <code>Iops</code> parameter.</p>
        /// <p>Default: <code>io1</code> if the <code>Iops</code> parameter is specified, otherwise <code>gp2</code> </p>
        pub fn storage_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.storage_type = Some(input.into());
            self
        }
        /// <p>Specifies the storage type to be associated with the DB instance.</p>
        /// <p>Valid values: <code>standard | gp2 | io1</code> </p>
        /// <p>If you specify <code>io1</code>, you must also include a value for the <code>Iops</code> parameter.</p>
        /// <p>Default: <code>io1</code> if the <code>Iops</code> parameter is specified, otherwise <code>gp2</code> </p>
        pub fn set_storage_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.storage_type = input;
            self
        }
        /// <p>The ARN from the key store with which to associate the instance for TDE encryption.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn tde_credential_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.tde_credential_arn = Some(input.into());
            self
        }
        /// <p>The ARN from the key store with which to associate the instance for TDE encryption.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn set_tde_credential_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.tde_credential_arn = input;
            self
        }
        /// <p>The password for the given ARN from the key store in order to access the device.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn tde_credential_password(mut self, input: impl Into<std::string::String>) -> Self {
            self.tde_credential_password = Some(input.into());
            self
        }
        /// <p>The password for the given ARN from the key store in order to access the device.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn set_tde_credential_password(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.tde_credential_password = input;
            self
        }
        /// <p>A value that indicates whether the DB instance is encrypted. By default, it isn't encrypted.</p>
        /// <p>For RDS Custom instances, either set this parameter to <code>true</code> or leave it unset. If you set this parameter to <code>false</code>, RDS reports an error.</p>
        /// <p> <b>Amazon Aurora</b> </p>
        /// <p>Not applicable. The encryption for DB instances is managed by the DB cluster.</p>
        pub fn storage_encrypted(mut self, input: bool) -> Self {
            self.storage_encrypted = Some(input);
            self
        }
        /// <p>A value that indicates whether the DB instance is encrypted. By default, it isn't encrypted.</p>
        /// <p>For RDS Custom instances, either set this parameter to <code>true</code> or leave it unset. If you set this parameter to <code>false</code>, RDS reports an error.</p>
        /// <p> <b>Amazon Aurora</b> </p>
        /// <p>Not applicable. The encryption for DB instances is managed by the DB cluster.</p>
        pub fn set_storage_encrypted(mut self, input: std::option::Option<bool>) -> Self {
            self.storage_encrypted = input;
            self
        }
        /// <p>The Amazon Web Services KMS key identifier for an encrypted DB instance.</p>
        /// <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key. To use a KMS key in a different Amazon Web Services account, specify the key ARN or alias ARN.</p>
        /// <p> <b>Amazon Aurora</b> </p>
        /// <p>Not applicable. The Amazon Web Services KMS key identifier is managed by the DB cluster. For more information, see <code>CreateDBCluster</code>.</p>
        /// <p>If <code>StorageEncrypted</code> is enabled, and you do not specify a value for the <code>KmsKeyId</code> parameter, then Amazon RDS uses your default KMS key. There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account has a different default KMS key for each Amazon Web Services Region.</p>
        /// <p> <b>Amazon RDS Custom</b> </p>
        /// <p>A KMS key is required for RDS Custom instances. For most RDS engines, if you leave this parameter empty while enabling <code>StorageEncrypted</code>, the engine uses the default KMS key. However, RDS Custom doesn't use the default key when this parameter is empty. You must explicitly specify a key.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services KMS key identifier for an encrypted DB instance.</p>
        /// <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key. To use a KMS key in a different Amazon Web Services account, specify the key ARN or alias ARN.</p>
        /// <p> <b>Amazon Aurora</b> </p>
        /// <p>Not applicable. The Amazon Web Services KMS key identifier is managed by the DB cluster. For more information, see <code>CreateDBCluster</code>.</p>
        /// <p>If <code>StorageEncrypted</code> is enabled, and you do not specify a value for the <code>KmsKeyId</code> parameter, then Amazon RDS uses your default KMS key. There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account has a different default KMS key for each Amazon Web Services Region.</p>
        /// <p> <b>Amazon RDS Custom</b> </p>
        /// <p>A KMS key is required for RDS Custom instances. For most RDS engines, if you leave this parameter empty while enabling <code>StorageEncrypted</code>, the engine uses the default KMS key. However, RDS Custom doesn't use the default key when this parameter is empty. You must explicitly specify a key.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// <p>The Active Directory directory ID to create the DB instance in. Currently, only MySQL, Microsoft SQL Server, Oracle, and PostgreSQL DB instances can be created in an Active Directory Domain.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/kerberos-authentication.html"> Kerberos Authentication</a> in the <i>Amazon RDS User Guide</i>.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain = Some(input.into());
            self
        }
        /// <p>The Active Directory directory ID to create the DB instance in. Currently, only MySQL, Microsoft SQL Server, Oracle, and PostgreSQL DB instances can be created in an Active Directory Domain.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/kerberos-authentication.html"> Kerberos Authentication</a> in the <i>Amazon RDS User Guide</i>.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain = input;
            self
        }
        /// <p>A value that indicates whether to copy tags from the DB instance to snapshots of the DB instance. By default, tags are not copied.</p>
        /// <p> <b>Amazon Aurora</b> </p>
        /// <p>Not applicable. Copying tags to snapshots is managed by the DB cluster. Setting this value for an Aurora DB instance has no effect on the DB cluster setting.</p>
        pub fn copy_tags_to_snapshot(mut self, input: bool) -> Self {
            self.copy_tags_to_snapshot = Some(input);
            self
        }
        /// <p>A value that indicates whether to copy tags from the DB instance to snapshots of the DB instance. By default, tags are not copied.</p>
        /// <p> <b>Amazon Aurora</b> </p>
        /// <p>Not applicable. Copying tags to snapshots is managed by the DB cluster. Setting this value for an Aurora DB instance has no effect on the DB cluster setting.</p>
        pub fn set_copy_tags_to_snapshot(mut self, input: std::option::Option<bool>) -> Self {
            self.copy_tags_to_snapshot = input;
            self
        }
        /// <p>The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB instance. To disable collection of Enhanced Monitoring metrics, specify 0. The default is 0.</p>
        /// <p>If <code>MonitoringRoleArn</code> is specified, then you must set <code>MonitoringInterval</code> to a value other than 0.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        /// <p>Valid Values: <code>0, 1, 5, 10, 15, 30, 60</code> </p>
        pub fn monitoring_interval(mut self, input: i32) -> Self {
            self.monitoring_interval = Some(input);
            self
        }
        /// <p>The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB instance. To disable collection of Enhanced Monitoring metrics, specify 0. The default is 0.</p>
        /// <p>If <code>MonitoringRoleArn</code> is specified, then you must set <code>MonitoringInterval</code> to a value other than 0.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        /// <p>Valid Values: <code>0, 1, 5, 10, 15, 30, 60</code> </p>
        pub fn set_monitoring_interval(mut self, input: std::option::Option<i32>) -> Self {
            self.monitoring_interval = input;
            self
        }
        /// <p>The ARN for the IAM role that permits RDS to send enhanced monitoring metrics to Amazon CloudWatch Logs. For example, <code>arn:aws:iam:123456789012:role/emaccess</code>. For information on creating a monitoring role, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.OS.html#USER_Monitoring.OS.Enabling">Setting Up and Enabling Enhanced Monitoring</a> in the <i>Amazon RDS User Guide</i>.</p>
        /// <p>If <code>MonitoringInterval</code> is set to a value other than 0, then you must supply a <code>MonitoringRoleArn</code> value.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn monitoring_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.monitoring_role_arn = Some(input.into());
            self
        }
        /// <p>The ARN for the IAM role that permits RDS to send enhanced monitoring metrics to Amazon CloudWatch Logs. For example, <code>arn:aws:iam:123456789012:role/emaccess</code>. For information on creating a monitoring role, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.OS.html#USER_Monitoring.OS.Enabling">Setting Up and Enabling Enhanced Monitoring</a> in the <i>Amazon RDS User Guide</i>.</p>
        /// <p>If <code>MonitoringInterval</code> is set to a value other than 0, then you must supply a <code>MonitoringRoleArn</code> value.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn set_monitoring_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.monitoring_role_arn = input;
            self
        }
        /// <p>Specify the name of the IAM role to be used when making API calls to the Directory Service.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn domain_iam_role_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_iam_role_name = Some(input.into());
            self
        }
        /// <p>Specify the name of the IAM role to be used when making API calls to the Directory Service.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn set_domain_iam_role_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.domain_iam_role_name = input;
            self
        }
        /// <p>A value that specifies the order in which an Aurora Replica is promoted to the primary instance after a failure of the existing primary instance. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.FaultTolerance"> Fault Tolerance for an Aurora DB Cluster</a> in the <i>Amazon Aurora User Guide</i>.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        /// <p>Default: 1</p>
        /// <p>Valid Values: 0 - 15</p>
        pub fn promotion_tier(mut self, input: i32) -> Self {
            self.promotion_tier = Some(input);
            self
        }
        /// <p>A value that specifies the order in which an Aurora Replica is promoted to the primary instance after a failure of the existing primary instance. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.FaultTolerance"> Fault Tolerance for an Aurora DB Cluster</a> in the <i>Amazon Aurora User Guide</i>.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        /// <p>Default: 1</p>
        /// <p>Valid Values: 0 - 15</p>
        pub fn set_promotion_tier(mut self, input: std::option::Option<i32>) -> Self {
            self.promotion_tier = input;
            self
        }
        /// <p>The time zone of the DB instance. The time zone parameter is currently supported only by <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_SQLServer.html#SQLServer.Concepts.General.TimeZone">Microsoft SQL Server</a>.</p>
        pub fn timezone(mut self, input: impl Into<std::string::String>) -> Self {
            self.timezone = Some(input.into());
            self
        }
        /// <p>The time zone of the DB instance. The time zone parameter is currently supported only by <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_SQLServer.html#SQLServer.Concepts.General.TimeZone">Microsoft SQL Server</a>.</p>
        pub fn set_timezone(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.timezone = input;
            self
        }
        /// <p>A value that indicates whether to enable mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts. By default, mapping isn't enabled.</p>
        /// <p>This setting doesn't apply to RDS Custom or Amazon Aurora. In Aurora, mapping Amazon Web Services IAM accounts to database accounts is managed by the DB cluster.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.html"> IAM Database Authentication for MySQL and PostgreSQL</a> in the <i>Amazon RDS User Guide</i>.</p>
        pub fn enable_iam_database_authentication(mut self, input: bool) -> Self {
            self.enable_iam_database_authentication = Some(input);
            self
        }
        /// <p>A value that indicates whether to enable mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts. By default, mapping isn't enabled.</p>
        /// <p>This setting doesn't apply to RDS Custom or Amazon Aurora. In Aurora, mapping Amazon Web Services IAM accounts to database accounts is managed by the DB cluster.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.html"> IAM Database Authentication for MySQL and PostgreSQL</a> in the <i>Amazon RDS User Guide</i>.</p>
        pub fn set_enable_iam_database_authentication(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.enable_iam_database_authentication = input;
            self
        }
        /// <p>A value that indicates whether to enable Performance Insights for the DB instance. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html">Using Amazon Performance Insights</a> in the <i>Amazon RDS User Guide</i>.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn enable_performance_insights(mut self, input: bool) -> Self {
            self.enable_performance_insights = Some(input);
            self
        }
        /// <p>A value that indicates whether to enable Performance Insights for the DB instance. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html">Using Amazon Performance Insights</a> in the <i>Amazon RDS User Guide</i>.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn set_enable_performance_insights(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_performance_insights = input;
            self
        }
        /// <p>The Amazon Web Services KMS key identifier for encryption of Performance Insights data.</p>
        /// <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.</p>
        /// <p>If you do not specify a value for <code>PerformanceInsightsKMSKeyId</code>, then Amazon RDS uses your default KMS key. There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account has a different default KMS key for each Amazon Web Services Region.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn performance_insights_kms_key_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.performance_insights_kms_key_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services KMS key identifier for encryption of Performance Insights data.</p>
        /// <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.</p>
        /// <p>If you do not specify a value for <code>PerformanceInsightsKMSKeyId</code>, then Amazon RDS uses your default KMS key. There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account has a different default KMS key for each Amazon Web Services Region.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn set_performance_insights_kms_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.performance_insights_kms_key_id = input;
            self
        }
        /// <p>The amount of time, in days, to retain Performance Insights data. Valid values are 7 or 731 (2 years).</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn performance_insights_retention_period(mut self, input: i32) -> Self {
            self.performance_insights_retention_period = Some(input);
            self
        }
        /// <p>The amount of time, in days, to retain Performance Insights data. Valid values are 7 or 731 (2 years).</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn set_performance_insights_retention_period(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.performance_insights_retention_period = input;
            self
        }
        /// Appends an item to `enable_cloudwatch_logs_exports`.
        ///
        /// To override the contents of this collection use [`set_enable_cloudwatch_logs_exports`](Self::set_enable_cloudwatch_logs_exports).
        ///
        /// <p>The list of log types that need to be enabled for exporting to CloudWatch Logs. The values in the list depend on the DB engine. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch"> Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon RDS User Guide</i>.</p>
        /// <p> <b>Amazon Aurora</b> </p>
        /// <p>Not applicable. CloudWatch Logs exports are managed by the DB cluster.</p>
        /// <p> <b>RDS Custom</b> </p>
        /// <p>Not applicable.</p>
        /// <p> <b>MariaDB</b> </p>
        /// <p>Possible values are <code>audit</code>, <code>error</code>, <code>general</code>, and <code>slowquery</code>.</p>
        /// <p> <b>Microsoft SQL Server</b> </p>
        /// <p>Possible values are <code>agent</code> and <code>error</code>.</p>
        /// <p> <b>MySQL</b> </p>
        /// <p>Possible values are <code>audit</code>, <code>error</code>, <code>general</code>, and <code>slowquery</code>.</p>
        /// <p> <b>Oracle</b> </p>
        /// <p>Possible values are <code>alert</code>, <code>audit</code>, <code>listener</code>, <code>trace</code>, and <code>oemagent</code>.</p>
        /// <p> <b>PostgreSQL</b> </p>
        /// <p>Possible values are <code>postgresql</code> and <code>upgrade</code>.</p>
        pub fn enable_cloudwatch_logs_exports(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.enable_cloudwatch_logs_exports.unwrap_or_default();
            v.push(input.into());
            self.enable_cloudwatch_logs_exports = Some(v);
            self
        }
        /// <p>The list of log types that need to be enabled for exporting to CloudWatch Logs. The values in the list depend on the DB engine. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch"> Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon RDS User Guide</i>.</p>
        /// <p> <b>Amazon Aurora</b> </p>
        /// <p>Not applicable. CloudWatch Logs exports are managed by the DB cluster.</p>
        /// <p> <b>RDS Custom</b> </p>
        /// <p>Not applicable.</p>
        /// <p> <b>MariaDB</b> </p>
        /// <p>Possible values are <code>audit</code>, <code>error</code>, <code>general</code>, and <code>slowquery</code>.</p>
        /// <p> <b>Microsoft SQL Server</b> </p>
        /// <p>Possible values are <code>agent</code> and <code>error</code>.</p>
        /// <p> <b>MySQL</b> </p>
        /// <p>Possible values are <code>audit</code>, <code>error</code>, <code>general</code>, and <code>slowquery</code>.</p>
        /// <p> <b>Oracle</b> </p>
        /// <p>Possible values are <code>alert</code>, <code>audit</code>, <code>listener</code>, <code>trace</code>, and <code>oemagent</code>.</p>
        /// <p> <b>PostgreSQL</b> </p>
        /// <p>Possible values are <code>postgresql</code> and <code>upgrade</code>.</p>
        pub fn set_enable_cloudwatch_logs_exports(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.enable_cloudwatch_logs_exports = input;
            self
        }
        /// Appends an item to `processor_features`.
        ///
        /// To override the contents of this collection use [`set_processor_features`](Self::set_processor_features).
        ///
        /// <p>The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn processor_features(mut self, input: crate::model::ProcessorFeature) -> Self {
            let mut v = self.processor_features.unwrap_or_default();
            v.push(input);
            self.processor_features = Some(v);
            self
        }
        /// <p>The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn set_processor_features(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ProcessorFeature>>,
        ) -> Self {
            self.processor_features = input;
            self
        }
        /// <p>A value that indicates whether the DB instance has deletion protection enabled. The database can't be deleted when deletion protection is enabled. By default, deletion protection isn't enabled. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html"> Deleting a DB Instance</a>.</p>
        /// <p> <b>Amazon Aurora</b> </p>
        /// <p>Not applicable. You can enable or disable deletion protection for the DB cluster. For more information, see <code>CreateDBCluster</code>. DB instances in a DB cluster can be deleted even when deletion protection is enabled for the DB cluster.</p>
        pub fn deletion_protection(mut self, input: bool) -> Self {
            self.deletion_protection = Some(input);
            self
        }
        /// <p>A value that indicates whether the DB instance has deletion protection enabled. The database can't be deleted when deletion protection is enabled. By default, deletion protection isn't enabled. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html"> Deleting a DB Instance</a>.</p>
        /// <p> <b>Amazon Aurora</b> </p>
        /// <p>Not applicable. You can enable or disable deletion protection for the DB cluster. For more information, see <code>CreateDBCluster</code>. DB instances in a DB cluster can be deleted even when deletion protection is enabled for the DB cluster.</p>
        pub fn set_deletion_protection(mut self, input: std::option::Option<bool>) -> Self {
            self.deletion_protection = input;
            self
        }
        /// <p>The upper limit in gibibytes (GiB) to which Amazon RDS can automatically scale the storage of the DB instance.</p>
        /// <p>For more information about this setting, including limitations that apply to it, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIOPS.StorageTypes.html#USER_PIOPS.Autoscaling"> Managing capacity automatically with Amazon RDS storage autoscaling</a> in the <i>Amazon RDS User Guide</i>.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn max_allocated_storage(mut self, input: i32) -> Self {
            self.max_allocated_storage = Some(input);
            self
        }
        /// <p>The upper limit in gibibytes (GiB) to which Amazon RDS can automatically scale the storage of the DB instance.</p>
        /// <p>For more information about this setting, including limitations that apply to it, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIOPS.StorageTypes.html#USER_PIOPS.Autoscaling"> Managing capacity automatically with Amazon RDS storage autoscaling</a> in the <i>Amazon RDS User Guide</i>.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn set_max_allocated_storage(mut self, input: std::option::Option<i32>) -> Self {
            self.max_allocated_storage = input;
            self
        }
        /// <p>A value that indicates whether to enable a customer-owned IP address (CoIP) for an RDS on Outposts DB instance.</p>
        /// <p>A <i>CoIP</i> provides local or external connectivity to resources in your Outpost subnets through your on-premises network. For some use cases, a CoIP can provide lower latency for connections to the DB instance from outside of its virtual private cloud (VPC) on your local network.</p>
        /// <p>For more information about RDS on Outposts, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html">Working with Amazon RDS on Amazon Web Services Outposts</a> in the <i>Amazon RDS User Guide</i>.</p>
        /// <p>For more information about CoIPs, see <a href="https://docs.aws.amazon.com/outposts/latest/userguide/outposts-networking-components.html#ip-addressing">Customer-owned IP addresses</a> in the <i>Amazon Web Services Outposts User Guide</i>.</p>
        pub fn enable_customer_owned_ip(mut self, input: bool) -> Self {
            self.enable_customer_owned_ip = Some(input);
            self
        }
        /// <p>A value that indicates whether to enable a customer-owned IP address (CoIP) for an RDS on Outposts DB instance.</p>
        /// <p>A <i>CoIP</i> provides local or external connectivity to resources in your Outpost subnets through your on-premises network. For some use cases, a CoIP can provide lower latency for connections to the DB instance from outside of its virtual private cloud (VPC) on your local network.</p>
        /// <p>For more information about RDS on Outposts, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html">Working with Amazon RDS on Amazon Web Services Outposts</a> in the <i>Amazon RDS User Guide</i>.</p>
        /// <p>For more information about CoIPs, see <a href="https://docs.aws.amazon.com/outposts/latest/userguide/outposts-networking-components.html#ip-addressing">Customer-owned IP addresses</a> in the <i>Amazon Web Services Outposts User Guide</i>.</p>
        pub fn set_enable_customer_owned_ip(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_customer_owned_ip = input;
            self
        }
        /// <p>The instance profile associated with the underlying Amazon EC2 instance of an RDS Custom DB instance. The instance profile must meet the following requirements:</p>
        /// <ul>
        /// <li> <p>The profile must exist in your account.</p> </li>
        /// <li> <p>The profile must have an IAM role that Amazon EC2 has permissions to assume.</p> </li>
        /// <li> <p>The instance profile name and the associated IAM role name must start with the prefix <code>AWSRDSCustom</code>.</p> </li>
        /// </ul>
        /// <p>For the list of permissions required for the IAM role, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-setup-orcl.html#custom-setup-orcl.iam-vpc"> Configure IAM and your VPC</a> in the <i>Amazon RDS User Guide</i>.</p>
        /// <p>This setting is required for RDS Custom.</p>
        pub fn custom_iam_instance_profile(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.custom_iam_instance_profile = Some(input.into());
            self
        }
        /// <p>The instance profile associated with the underlying Amazon EC2 instance of an RDS Custom DB instance. The instance profile must meet the following requirements:</p>
        /// <ul>
        /// <li> <p>The profile must exist in your account.</p> </li>
        /// <li> <p>The profile must have an IAM role that Amazon EC2 has permissions to assume.</p> </li>
        /// <li> <p>The instance profile name and the associated IAM role name must start with the prefix <code>AWSRDSCustom</code>.</p> </li>
        /// </ul>
        /// <p>For the list of permissions required for the IAM role, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-setup-orcl.html#custom-setup-orcl.iam-vpc"> Configure IAM and your VPC</a> in the <i>Amazon RDS User Guide</i>.</p>
        /// <p>This setting is required for RDS Custom.</p>
        pub fn set_custom_iam_instance_profile(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.custom_iam_instance_profile = input;
            self
        }
        /// <p>Specifies where automated backups and manual snapshots are stored.</p>
        /// <p>Possible values are <code>outposts</code> (Amazon Web Services Outposts) and <code>region</code> (Amazon Web Services Region). The default is <code>region</code>.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html">Working with Amazon RDS on Amazon Web Services Outposts</a> in the <i>Amazon RDS User Guide</i>.</p>
        pub fn backup_target(mut self, input: impl Into<std::string::String>) -> Self {
            self.backup_target = Some(input.into());
            self
        }
        /// <p>Specifies where automated backups and manual snapshots are stored.</p>
        /// <p>Possible values are <code>outposts</code> (Amazon Web Services Outposts) and <code>region</code> (Amazon Web Services Region). The default is <code>region</code>.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html">Working with Amazon RDS on Amazon Web Services Outposts</a> in the <i>Amazon RDS User Guide</i>.</p>
        pub fn set_backup_target(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backup_target = input;
            self
        }
        /// <p>The network type of the DB instance.</p>
        /// <p>Valid values:</p>
        /// <ul>
        /// <li> <p> <code>IPV4</code> </p> </li>
        /// <li> <p> <code>DUAL</code> </p> </li>
        /// </ul>
        /// <p>The network type is determined by the <code>DBSubnetGroup</code> specified for the DB instance. A <code>DBSubnetGroup</code> can support only the IPv4 protocol or the IPv4 and the IPv6 protocols (<code>DUAL</code>).</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html"> Working with a DB instance in a VPC</a> in the <i>Amazon RDS User Guide.</i> </p>
        pub fn network_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.network_type = Some(input.into());
            self
        }
        /// <p>The network type of the DB instance.</p>
        /// <p>Valid values:</p>
        /// <ul>
        /// <li> <p> <code>IPV4</code> </p> </li>
        /// <li> <p> <code>DUAL</code> </p> </li>
        /// </ul>
        /// <p>The network type is determined by the <code>DBSubnetGroup</code> specified for the DB instance. A <code>DBSubnetGroup</code> can support only the IPv4 protocol or the IPv4 and the IPv6 protocols (<code>DUAL</code>).</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html"> Working with a DB instance in a VPC</a> in the <i>Amazon RDS User Guide.</i> </p>
        pub fn set_network_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.network_type = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDbInstanceInput`](crate::input::CreateDbInstanceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateDbInstanceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateDbInstanceInput {
                db_name: self.db_name,
                db_instance_identifier: self.db_instance_identifier,
                allocated_storage: self.allocated_storage,
                db_instance_class: self.db_instance_class,
                engine: self.engine,
                master_username: self.master_username,
                master_user_password: self.master_user_password,
                db_security_groups: self.db_security_groups,
                vpc_security_group_ids: self.vpc_security_group_ids,
                availability_zone: self.availability_zone,
                db_subnet_group_name: self.db_subnet_group_name,
                preferred_maintenance_window: self.preferred_maintenance_window,
                db_parameter_group_name: self.db_parameter_group_name,
                backup_retention_period: self.backup_retention_period,
                preferred_backup_window: self.preferred_backup_window,
                port: self.port,
                multi_az: self.multi_az,
                engine_version: self.engine_version,
                auto_minor_version_upgrade: self.auto_minor_version_upgrade,
                license_model: self.license_model,
                iops: self.iops,
                option_group_name: self.option_group_name,
                character_set_name: self.character_set_name,
                nchar_character_set_name: self.nchar_character_set_name,
                publicly_accessible: self.publicly_accessible,
                tags: self.tags,
                db_cluster_identifier: self.db_cluster_identifier,
                storage_type: self.storage_type,
                tde_credential_arn: self.tde_credential_arn,
                tde_credential_password: self.tde_credential_password,
                storage_encrypted: self.storage_encrypted,
                kms_key_id: self.kms_key_id,
                domain: self.domain,
                copy_tags_to_snapshot: self.copy_tags_to_snapshot,
                monitoring_interval: self.monitoring_interval,
                monitoring_role_arn: self.monitoring_role_arn,
                domain_iam_role_name: self.domain_iam_role_name,
                promotion_tier: self.promotion_tier,
                timezone: self.timezone,
                enable_iam_database_authentication: self.enable_iam_database_authentication,
                enable_performance_insights: self.enable_performance_insights,
                performance_insights_kms_key_id: self.performance_insights_kms_key_id,
                performance_insights_retention_period: self.performance_insights_retention_period,
                enable_cloudwatch_logs_exports: self.enable_cloudwatch_logs_exports,
                processor_features: self.processor_features,
                deletion_protection: self.deletion_protection,
                max_allocated_storage: self.max_allocated_storage,
                enable_customer_owned_ip: self.enable_customer_owned_ip,
                custom_iam_instance_profile: self.custom_iam_instance_profile,
                backup_target: self.backup_target,
                network_type: self.network_type,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateDbInstanceInputOperationOutputAlias = crate::operation::CreateDBInstance;
#[doc(hidden)]
pub type CreateDbInstanceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateDbInstanceInput {
    /// Consumes the builder and constructs an Operation<[`CreateDBInstance`](crate::operation::CreateDBInstance)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateDBInstance,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateDbInstanceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateDbInstanceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_db_instance(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateDBInstance::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateDBInstance",
            "rds",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateDbInstanceInput`](crate::input::CreateDbInstanceInput)
    pub fn builder() -> crate::input::create_db_instance_input::Builder {
        crate::input::create_db_instance_input::Builder::default()
    }
}

/// See [`CreateDbInstanceReadReplicaInput`](crate::input::CreateDbInstanceReadReplicaInput)
pub mod create_db_instance_read_replica_input {
    /// A builder for [`CreateDbInstanceReadReplicaInput`](crate::input::CreateDbInstanceReadReplicaInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_instance_identifier: std::option::Option<std::string::String>,
        pub(crate) source_db_instance_identifier: std::option::Option<std::string::String>,
        pub(crate) db_instance_class: std::option::Option<std::string::String>,
        pub(crate) availability_zone: std::option::Option<std::string::String>,
        pub(crate) port: std::option::Option<i32>,
        pub(crate) multi_az: std::option::Option<bool>,
        pub(crate) auto_minor_version_upgrade: std::option::Option<bool>,
        pub(crate) iops: std::option::Option<i32>,
        pub(crate) option_group_name: std::option::Option<std::string::String>,
        pub(crate) db_parameter_group_name: std::option::Option<std::string::String>,
        pub(crate) publicly_accessible: std::option::Option<bool>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) db_subnet_group_name: std::option::Option<std::string::String>,
        pub(crate) vpc_security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) storage_type: std::option::Option<std::string::String>,
        pub(crate) copy_tags_to_snapshot: std::option::Option<bool>,
        pub(crate) monitoring_interval: std::option::Option<i32>,
        pub(crate) monitoring_role_arn: std::option::Option<std::string::String>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
        pub(crate) pre_signed_url: std::option::Option<std::string::String>,
        pub(crate) enable_iam_database_authentication: std::option::Option<bool>,
        pub(crate) enable_performance_insights: std::option::Option<bool>,
        pub(crate) performance_insights_kms_key_id: std::option::Option<std::string::String>,
        pub(crate) performance_insights_retention_period: std::option::Option<i32>,
        pub(crate) enable_cloudwatch_logs_exports:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) processor_features:
            std::option::Option<std::vec::Vec<crate::model::ProcessorFeature>>,
        pub(crate) use_default_processor_features: std::option::Option<bool>,
        pub(crate) deletion_protection: std::option::Option<bool>,
        pub(crate) domain: std::option::Option<std::string::String>,
        pub(crate) domain_iam_role_name: std::option::Option<std::string::String>,
        pub(crate) replica_mode: std::option::Option<crate::model::ReplicaMode>,
        pub(crate) max_allocated_storage: std::option::Option<i32>,
        pub(crate) custom_iam_instance_profile: std::option::Option<std::string::String>,
        pub(crate) network_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The DB instance identifier of the read replica. This identifier is the unique key that identifies a DB instance. This parameter is stored as a lowercase string.</p>
        pub fn db_instance_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_instance_identifier = Some(input.into());
            self
        }
        /// <p>The DB instance identifier of the read replica. This identifier is the unique key that identifies a DB instance. This parameter is stored as a lowercase string.</p>
        pub fn set_db_instance_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_instance_identifier = input;
            self
        }
        /// <p>The identifier of the DB instance that will act as the source for the read replica. Each DB instance can have up to five read replicas.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be the identifier of an existing MySQL, MariaDB, Oracle, PostgreSQL, or SQL Server DB instance.</p> </li>
        /// <li> <p>Can specify a DB instance that is a MySQL read replica only if the source is running MySQL 5.6 or later.</p> </li>
        /// <li> <p>For the limitations of Oracle read replicas, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/oracle-read-replicas.html">Read Replica Limitations with Oracle</a> in the <i>Amazon RDS User Guide</i>.</p> </li>
        /// <li> <p>For the limitations of SQL Server read replicas, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/SQLServer.ReadReplicas.Limitations.html">Read Replica Limitations with Microsoft SQL Server</a> in the <i>Amazon RDS User Guide</i>.</p> </li>
        /// <li> <p>Can specify a PostgreSQL DB instance only if the source is running PostgreSQL 9.3.5 or later (9.4.7 and higher for cross-Region replication).</p> </li>
        /// <li> <p>The specified DB instance must have automatic backups enabled, that is, its backup retention period must be greater than 0.</p> </li>
        /// <li> <p>If the source DB instance is in the same Amazon Web Services Region as the read replica, specify a valid DB instance identifier.</p> </li>
        /// <li> <p>If the source DB instance is in a different Amazon Web Services Region from the read replica, specify a valid DB instance ARN. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing">Constructing an ARN for Amazon RDS</a> in the <i>Amazon RDS User Guide</i>. This doesn't apply to SQL Server or RDS Custom, which don't support cross-Region replicas.</p> </li>
        /// </ul>
        pub fn source_db_instance_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.source_db_instance_identifier = Some(input.into());
            self
        }
        /// <p>The identifier of the DB instance that will act as the source for the read replica. Each DB instance can have up to five read replicas.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be the identifier of an existing MySQL, MariaDB, Oracle, PostgreSQL, or SQL Server DB instance.</p> </li>
        /// <li> <p>Can specify a DB instance that is a MySQL read replica only if the source is running MySQL 5.6 or later.</p> </li>
        /// <li> <p>For the limitations of Oracle read replicas, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/oracle-read-replicas.html">Read Replica Limitations with Oracle</a> in the <i>Amazon RDS User Guide</i>.</p> </li>
        /// <li> <p>For the limitations of SQL Server read replicas, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/SQLServer.ReadReplicas.Limitations.html">Read Replica Limitations with Microsoft SQL Server</a> in the <i>Amazon RDS User Guide</i>.</p> </li>
        /// <li> <p>Can specify a PostgreSQL DB instance only if the source is running PostgreSQL 9.3.5 or later (9.4.7 and higher for cross-Region replication).</p> </li>
        /// <li> <p>The specified DB instance must have automatic backups enabled, that is, its backup retention period must be greater than 0.</p> </li>
        /// <li> <p>If the source DB instance is in the same Amazon Web Services Region as the read replica, specify a valid DB instance identifier.</p> </li>
        /// <li> <p>If the source DB instance is in a different Amazon Web Services Region from the read replica, specify a valid DB instance ARN. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing">Constructing an ARN for Amazon RDS</a> in the <i>Amazon RDS User Guide</i>. This doesn't apply to SQL Server or RDS Custom, which don't support cross-Region replicas.</p> </li>
        /// </ul>
        pub fn set_source_db_instance_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_db_instance_identifier = input;
            self
        }
        /// <p>The compute and memory capacity of the read replica, for example db.m4.large. Not all DB instance classes are available in all Amazon Web Services Regions, or for all database engines. For the full list of DB instance classes, and availability for your engine, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html">DB Instance Class</a> in the <i>Amazon RDS User Guide</i>.</p>
        /// <p>Default: Inherits from the source DB instance.</p>
        pub fn db_instance_class(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_instance_class = Some(input.into());
            self
        }
        /// <p>The compute and memory capacity of the read replica, for example db.m4.large. Not all DB instance classes are available in all Amazon Web Services Regions, or for all database engines. For the full list of DB instance classes, and availability for your engine, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html">DB Instance Class</a> in the <i>Amazon RDS User Guide</i>.</p>
        /// <p>Default: Inherits from the source DB instance.</p>
        pub fn set_db_instance_class(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_instance_class = input;
            self
        }
        /// <p>The Availability Zone (AZ) where the read replica will be created.</p>
        /// <p>Default: A random, system-chosen Availability Zone in the endpoint's Amazon Web Services Region.</p>
        /// <p>Example: <code>us-east-1d</code> </p>
        pub fn availability_zone(mut self, input: impl Into<std::string::String>) -> Self {
            self.availability_zone = Some(input.into());
            self
        }
        /// <p>The Availability Zone (AZ) where the read replica will be created.</p>
        /// <p>Default: A random, system-chosen Availability Zone in the endpoint's Amazon Web Services Region.</p>
        /// <p>Example: <code>us-east-1d</code> </p>
        pub fn set_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.availability_zone = input;
            self
        }
        /// <p>The port number that the DB instance uses for connections.</p>
        /// <p>Default: Inherits from the source DB instance</p>
        /// <p>Valid Values: <code>1150-65535</code> </p>
        pub fn port(mut self, input: i32) -> Self {
            self.port = Some(input);
            self
        }
        /// <p>The port number that the DB instance uses for connections.</p>
        /// <p>Default: Inherits from the source DB instance</p>
        /// <p>Valid Values: <code>1150-65535</code> </p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.port = input;
            self
        }
        /// <p>A value that indicates whether the read replica is in a Multi-AZ deployment.</p>
        /// <p>You can create a read replica as a Multi-AZ DB instance. RDS creates a standby of your replica in another Availability Zone for failover support for the replica. Creating your read replica as a Multi-AZ DB instance is independent of whether the source database is a Multi-AZ DB instance.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn multi_az(mut self, input: bool) -> Self {
            self.multi_az = Some(input);
            self
        }
        /// <p>A value that indicates whether the read replica is in a Multi-AZ deployment.</p>
        /// <p>You can create a read replica as a Multi-AZ DB instance. RDS creates a standby of your replica in another Availability Zone for failover support for the replica. Creating your read replica as a Multi-AZ DB instance is independent of whether the source database is a Multi-AZ DB instance.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn set_multi_az(mut self, input: std::option::Option<bool>) -> Self {
            self.multi_az = input;
            self
        }
        /// <p>A value that indicates whether minor engine upgrades are applied automatically to the read replica during the maintenance window.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        /// <p>Default: Inherits from the source DB instance</p>
        pub fn auto_minor_version_upgrade(mut self, input: bool) -> Self {
            self.auto_minor_version_upgrade = Some(input);
            self
        }
        /// <p>A value that indicates whether minor engine upgrades are applied automatically to the read replica during the maintenance window.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        /// <p>Default: Inherits from the source DB instance</p>
        pub fn set_auto_minor_version_upgrade(mut self, input: std::option::Option<bool>) -> Self {
            self.auto_minor_version_upgrade = input;
            self
        }
        /// <p>The amount of Provisioned IOPS (input/output operations per second) to be initially allocated for the DB instance.</p>
        pub fn iops(mut self, input: i32) -> Self {
            self.iops = Some(input);
            self
        }
        /// <p>The amount of Provisioned IOPS (input/output operations per second) to be initially allocated for the DB instance.</p>
        pub fn set_iops(mut self, input: std::option::Option<i32>) -> Self {
            self.iops = input;
            self
        }
        /// <p>The option group the DB instance is associated with. If omitted, the option group associated with the source instance is used.</p> <note>
        /// <p>For SQL Server, you must use the option group associated with the source instance.</p>
        /// </note>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn option_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.option_group_name = Some(input.into());
            self
        }
        /// <p>The option group the DB instance is associated with. If omitted, the option group associated with the source instance is used.</p> <note>
        /// <p>For SQL Server, you must use the option group associated with the source instance.</p>
        /// </note>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn set_option_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.option_group_name = input;
            self
        }
        /// <p>The name of the DB parameter group to associate with this DB instance.</p>
        /// <p>If you do not specify a value for <code>DBParameterGroupName</code>, then Amazon RDS uses the <code>DBParameterGroup</code> of source DB instance for a same Region read replica, or the default <code>DBParameterGroup</code> for the specified DB engine for a cross-Region read replica.</p>
        /// <p>Specifying a parameter group for this operation is only supported for Oracle DB instances. It isn't supported for RDS Custom.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be 1 to 255 letters, numbers, or hyphens.</p> </li>
        /// <li> <p>First character must be a letter</p> </li>
        /// <li> <p>Can't end with a hyphen or contain two consecutive hyphens</p> </li>
        /// </ul>
        pub fn db_parameter_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_parameter_group_name = Some(input.into());
            self
        }
        /// <p>The name of the DB parameter group to associate with this DB instance.</p>
        /// <p>If you do not specify a value for <code>DBParameterGroupName</code>, then Amazon RDS uses the <code>DBParameterGroup</code> of source DB instance for a same Region read replica, or the default <code>DBParameterGroup</code> for the specified DB engine for a cross-Region read replica.</p>
        /// <p>Specifying a parameter group for this operation is only supported for Oracle DB instances. It isn't supported for RDS Custom.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be 1 to 255 letters, numbers, or hyphens.</p> </li>
        /// <li> <p>First character must be a letter</p> </li>
        /// <li> <p>Can't end with a hyphen or contain two consecutive hyphens</p> </li>
        /// </ul>
        pub fn set_db_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_parameter_group_name = input;
            self
        }
        /// <p>A value that indicates whether the DB instance is publicly accessible.</p>
        /// <p>When the DB cluster is publicly accessible, its Domain Name System (DNS) endpoint resolves to the private IP address from within the DB cluster's virtual private cloud (VPC). It resolves to the public IP address from outside of the DB cluster's VPC. Access to the DB cluster is ultimately controlled by the security group it uses. That public access isn't permitted if the security group assigned to the DB cluster doesn't permit it.</p>
        /// <p>When the DB instance isn't publicly accessible, it is an internal DB instance with a DNS name that resolves to a private IP address.</p>
        /// <p>For more information, see <code>CreateDBInstance</code>.</p>
        pub fn publicly_accessible(mut self, input: bool) -> Self {
            self.publicly_accessible = Some(input);
            self
        }
        /// <p>A value that indicates whether the DB instance is publicly accessible.</p>
        /// <p>When the DB cluster is publicly accessible, its Domain Name System (DNS) endpoint resolves to the private IP address from within the DB cluster's virtual private cloud (VPC). It resolves to the public IP address from outside of the DB cluster's VPC. Access to the DB cluster is ultimately controlled by the security group it uses. That public access isn't permitted if the security group assigned to the DB cluster doesn't permit it.</p>
        /// <p>When the DB instance isn't publicly accessible, it is an internal DB instance with a DNS name that resolves to a private IP address.</p>
        /// <p>For more information, see <code>CreateDBInstance</code>.</p>
        pub fn set_publicly_accessible(mut self, input: std::option::Option<bool>) -> Self {
            self.publicly_accessible = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources</a> in the <i>Amazon RDS User Guide.</i> </p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>A list of tags. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources</a> in the <i>Amazon RDS User Guide.</i> </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>Specifies a DB subnet group for the DB instance. The new DB instance is created in the VPC associated with the DB subnet group. If no DB subnet group is specified, then the new DB instance isn't created in a VPC.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Can only be specified if the source DB instance identifier specifies a DB instance in another Amazon Web Services Region.</p> </li>
        /// <li> <p>If supplied, must match the name of an existing DBSubnetGroup.</p> </li>
        /// <li> <p>The specified DB subnet group must be in the same Amazon Web Services Region in which the operation is running.</p> </li>
        /// <li> <p>All read replicas in one Amazon Web Services Region that are created from the same source DB instance must either:&gt;</p>
        /// <ul>
        /// <li> <p>Specify DB subnet groups from the same VPC. All these read replicas are created in the same VPC.</p> </li>
        /// <li> <p>Not specify a DB subnet group. All these read replicas are created outside of any VPC.</p> </li>
        /// </ul> </li>
        /// </ul>
        /// <p>Example: <code>mydbsubnetgroup</code> </p>
        pub fn db_subnet_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_subnet_group_name = Some(input.into());
            self
        }
        /// <p>Specifies a DB subnet group for the DB instance. The new DB instance is created in the VPC associated with the DB subnet group. If no DB subnet group is specified, then the new DB instance isn't created in a VPC.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Can only be specified if the source DB instance identifier specifies a DB instance in another Amazon Web Services Region.</p> </li>
        /// <li> <p>If supplied, must match the name of an existing DBSubnetGroup.</p> </li>
        /// <li> <p>The specified DB subnet group must be in the same Amazon Web Services Region in which the operation is running.</p> </li>
        /// <li> <p>All read replicas in one Amazon Web Services Region that are created from the same source DB instance must either:&gt;</p>
        /// <ul>
        /// <li> <p>Specify DB subnet groups from the same VPC. All these read replicas are created in the same VPC.</p> </li>
        /// <li> <p>Not specify a DB subnet group. All these read replicas are created outside of any VPC.</p> </li>
        /// </ul> </li>
        /// </ul>
        /// <p>Example: <code>mydbsubnetgroup</code> </p>
        pub fn set_db_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_subnet_group_name = input;
            self
        }
        /// Appends an item to `vpc_security_group_ids`.
        ///
        /// To override the contents of this collection use [`set_vpc_security_group_ids`](Self::set_vpc_security_group_ids).
        ///
        /// <p>A list of Amazon EC2 VPC security groups to associate with the read replica.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        /// <p>Default: The default EC2 VPC security group for the DB subnet group's VPC.</p>
        pub fn vpc_security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.vpc_security_group_ids.unwrap_or_default();
            v.push(input.into());
            self.vpc_security_group_ids = Some(v);
            self
        }
        /// <p>A list of Amazon EC2 VPC security groups to associate with the read replica.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        /// <p>Default: The default EC2 VPC security group for the DB subnet group's VPC.</p>
        pub fn set_vpc_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.vpc_security_group_ids = input;
            self
        }
        /// <p>Specifies the storage type to be associated with the read replica.</p>
        /// <p>Valid values: <code>standard | gp2 | io1</code> </p>
        /// <p>If you specify <code>io1</code>, you must also include a value for the <code>Iops</code> parameter.</p>
        /// <p>Default: <code>io1</code> if the <code>Iops</code> parameter is specified, otherwise <code>gp2</code> </p>
        pub fn storage_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.storage_type = Some(input.into());
            self
        }
        /// <p>Specifies the storage type to be associated with the read replica.</p>
        /// <p>Valid values: <code>standard | gp2 | io1</code> </p>
        /// <p>If you specify <code>io1</code>, you must also include a value for the <code>Iops</code> parameter.</p>
        /// <p>Default: <code>io1</code> if the <code>Iops</code> parameter is specified, otherwise <code>gp2</code> </p>
        pub fn set_storage_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.storage_type = input;
            self
        }
        /// <p>A value that indicates whether to copy all tags from the read replica to snapshots of the read replica. By default, tags are not copied.</p>
        pub fn copy_tags_to_snapshot(mut self, input: bool) -> Self {
            self.copy_tags_to_snapshot = Some(input);
            self
        }
        /// <p>A value that indicates whether to copy all tags from the read replica to snapshots of the read replica. By default, tags are not copied.</p>
        pub fn set_copy_tags_to_snapshot(mut self, input: std::option::Option<bool>) -> Self {
            self.copy_tags_to_snapshot = input;
            self
        }
        /// <p>The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the read replica. To disable collecting Enhanced Monitoring metrics, specify 0. The default is 0.</p>
        /// <p>If <code>MonitoringRoleArn</code> is specified, then you must also set <code>MonitoringInterval</code> to a value other than 0.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        /// <p>Valid Values: <code>0, 1, 5, 10, 15, 30, 60</code> </p>
        pub fn monitoring_interval(mut self, input: i32) -> Self {
            self.monitoring_interval = Some(input);
            self
        }
        /// <p>The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the read replica. To disable collecting Enhanced Monitoring metrics, specify 0. The default is 0.</p>
        /// <p>If <code>MonitoringRoleArn</code> is specified, then you must also set <code>MonitoringInterval</code> to a value other than 0.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        /// <p>Valid Values: <code>0, 1, 5, 10, 15, 30, 60</code> </p>
        pub fn set_monitoring_interval(mut self, input: std::option::Option<i32>) -> Self {
            self.monitoring_interval = input;
            self
        }
        /// <p>The ARN for the IAM role that permits RDS to send enhanced monitoring metrics to Amazon CloudWatch Logs. For example, <code>arn:aws:iam:123456789012:role/emaccess</code>. For information on creating a monitoring role, go to <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.html#USER_Monitoring.OS.IAMRole">To create an IAM role for Amazon RDS Enhanced Monitoring</a> in the <i>Amazon RDS User Guide</i>.</p>
        /// <p>If <code>MonitoringInterval</code> is set to a value other than 0, then you must supply a <code>MonitoringRoleArn</code> value.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn monitoring_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.monitoring_role_arn = Some(input.into());
            self
        }
        /// <p>The ARN for the IAM role that permits RDS to send enhanced monitoring metrics to Amazon CloudWatch Logs. For example, <code>arn:aws:iam:123456789012:role/emaccess</code>. For information on creating a monitoring role, go to <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.html#USER_Monitoring.OS.IAMRole">To create an IAM role for Amazon RDS Enhanced Monitoring</a> in the <i>Amazon RDS User Guide</i>.</p>
        /// <p>If <code>MonitoringInterval</code> is set to a value other than 0, then you must supply a <code>MonitoringRoleArn</code> value.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn set_monitoring_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.monitoring_role_arn = input;
            self
        }
        /// <p>The Amazon Web Services KMS key identifier for an encrypted read replica.</p>
        /// <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.</p>
        /// <p>If you create an encrypted read replica in the same Amazon Web Services Region as the source DB instance, then do not specify a value for this parameter. A read replica in the same Amazon Web Services Region is always encrypted with the same KMS key as the source DB instance.</p>
        /// <p>If you create an encrypted read replica in a different Amazon Web Services Region, then you must specify a KMS key identifier for the destination Amazon Web Services Region. KMS keys are specific to the Amazon Web Services Region that they are created in, and you can't use KMS keys from one Amazon Web Services Region in another Amazon Web Services Region.</p>
        /// <p>You can't create an encrypted read replica from an unencrypted DB instance.</p>
        /// <p>This setting doesn't apply to RDS Custom, which uses the same KMS key as the primary replica.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services KMS key identifier for an encrypted read replica.</p>
        /// <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.</p>
        /// <p>If you create an encrypted read replica in the same Amazon Web Services Region as the source DB instance, then do not specify a value for this parameter. A read replica in the same Amazon Web Services Region is always encrypted with the same KMS key as the source DB instance.</p>
        /// <p>If you create an encrypted read replica in a different Amazon Web Services Region, then you must specify a KMS key identifier for the destination Amazon Web Services Region. KMS keys are specific to the Amazon Web Services Region that they are created in, and you can't use KMS keys from one Amazon Web Services Region in another Amazon Web Services Region.</p>
        /// <p>You can't create an encrypted read replica from an unencrypted DB instance.</p>
        /// <p>This setting doesn't apply to RDS Custom, which uses the same KMS key as the primary replica.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// <p>The URL that contains a Signature Version 4 signed request for the <code>CreateDBInstanceReadReplica</code> API action in the source Amazon Web Services Region that contains the source DB instance.</p>
        /// <p>You must specify this parameter when you create an encrypted read replica from another Amazon Web Services Region by using the Amazon RDS API. Don't specify <code>PreSignedUrl</code> when you are creating an encrypted read replica in the same Amazon Web Services Region.</p>
        /// <p>The presigned URL must be a valid request for the <code>CreateDBInstanceReadReplica</code> API action that can be executed in the source Amazon Web Services Region that contains the encrypted source DB instance. The presigned URL request must contain the following parameter values:</p>
        /// <ul>
        /// <li> <p> <code>DestinationRegion</code> - The Amazon Web Services Region that the encrypted read replica is created in. This Amazon Web Services Region is the same one where the <code>CreateDBInstanceReadReplica</code> action is called that contains this presigned URL.</p> <p>For example, if you create an encrypted DB instance in the us-west-1 Amazon Web Services Region, from a source DB instance in the us-east-2 Amazon Web Services Region, then you call the <code>CreateDBInstanceReadReplica</code> action in the us-east-1 Amazon Web Services Region and provide a presigned URL that contains a call to the <code>CreateDBInstanceReadReplica</code> action in the us-west-2 Amazon Web Services Region. For this example, the <code>DestinationRegion</code> in the presigned URL must be set to the us-east-1 Amazon Web Services Region.</p> </li>
        /// <li> <p> <code>KmsKeyId</code> - The Amazon Web Services KMS key identifier for the key to use to encrypt the read replica in the destination Amazon Web Services Region. This is the same identifier for both the <code>CreateDBInstanceReadReplica</code> action that is called in the destination Amazon Web Services Region, and the action contained in the presigned URL.</p> </li>
        /// <li> <p> <code>SourceDBInstanceIdentifier</code> - The DB instance identifier for the encrypted DB instance to be replicated. This identifier must be in the Amazon Resource Name (ARN) format for the source Amazon Web Services Region. For example, if you are creating an encrypted read replica from a DB instance in the us-west-2 Amazon Web Services Region, then your <code>SourceDBInstanceIdentifier</code> looks like the following example: <code>arn:aws:rds:us-west-2:123456789012:instance:mysql-instance1-20161115</code>.</p> </li>
        /// </ul>
        /// <p>To learn how to generate a Signature Version 4 signed request, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html">Authenticating Requests: Using Query Parameters (Amazon Web Services Signature Version 4)</a> and <a href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4 Signing Process</a>.</p> <note>
        /// <p>If you are using an Amazon Web Services SDK tool or the CLI, you can specify <code>SourceRegion</code> (or <code>--source-region</code> for the CLI) instead of specifying <code>PreSignedUrl</code> manually. Specifying <code>SourceRegion</code> autogenerates a presigned URL that is a valid request for the operation that can be executed in the source Amazon Web Services Region.</p>
        /// <p> <code>SourceRegion</code> isn't supported for SQL Server, because SQL Server on Amazon RDS doesn't support cross-Region read replicas.</p>
        /// </note>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn pre_signed_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.pre_signed_url = Some(input.into());
            self
        }
        /// <p>The URL that contains a Signature Version 4 signed request for the <code>CreateDBInstanceReadReplica</code> API action in the source Amazon Web Services Region that contains the source DB instance.</p>
        /// <p>You must specify this parameter when you create an encrypted read replica from another Amazon Web Services Region by using the Amazon RDS API. Don't specify <code>PreSignedUrl</code> when you are creating an encrypted read replica in the same Amazon Web Services Region.</p>
        /// <p>The presigned URL must be a valid request for the <code>CreateDBInstanceReadReplica</code> API action that can be executed in the source Amazon Web Services Region that contains the encrypted source DB instance. The presigned URL request must contain the following parameter values:</p>
        /// <ul>
        /// <li> <p> <code>DestinationRegion</code> - The Amazon Web Services Region that the encrypted read replica is created in. This Amazon Web Services Region is the same one where the <code>CreateDBInstanceReadReplica</code> action is called that contains this presigned URL.</p> <p>For example, if you create an encrypted DB instance in the us-west-1 Amazon Web Services Region, from a source DB instance in the us-east-2 Amazon Web Services Region, then you call the <code>CreateDBInstanceReadReplica</code> action in the us-east-1 Amazon Web Services Region and provide a presigned URL that contains a call to the <code>CreateDBInstanceReadReplica</code> action in the us-west-2 Amazon Web Services Region. For this example, the <code>DestinationRegion</code> in the presigned URL must be set to the us-east-1 Amazon Web Services Region.</p> </li>
        /// <li> <p> <code>KmsKeyId</code> - The Amazon Web Services KMS key identifier for the key to use to encrypt the read replica in the destination Amazon Web Services Region. This is the same identifier for both the <code>CreateDBInstanceReadReplica</code> action that is called in the destination Amazon Web Services Region, and the action contained in the presigned URL.</p> </li>
        /// <li> <p> <code>SourceDBInstanceIdentifier</code> - The DB instance identifier for the encrypted DB instance to be replicated. This identifier must be in the Amazon Resource Name (ARN) format for the source Amazon Web Services Region. For example, if you are creating an encrypted read replica from a DB instance in the us-west-2 Amazon Web Services Region, then your <code>SourceDBInstanceIdentifier</code> looks like the following example: <code>arn:aws:rds:us-west-2:123456789012:instance:mysql-instance1-20161115</code>.</p> </li>
        /// </ul>
        /// <p>To learn how to generate a Signature Version 4 signed request, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html">Authenticating Requests: Using Query Parameters (Amazon Web Services Signature Version 4)</a> and <a href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4 Signing Process</a>.</p> <note>
        /// <p>If you are using an Amazon Web Services SDK tool or the CLI, you can specify <code>SourceRegion</code> (or <code>--source-region</code> for the CLI) instead of specifying <code>PreSignedUrl</code> manually. Specifying <code>SourceRegion</code> autogenerates a presigned URL that is a valid request for the operation that can be executed in the source Amazon Web Services Region.</p>
        /// <p> <code>SourceRegion</code> isn't supported for SQL Server, because SQL Server on Amazon RDS doesn't support cross-Region read replicas.</p>
        /// </note>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn set_pre_signed_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.pre_signed_url = input;
            self
        }
        /// <p>A value that indicates whether to enable mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts. By default, mapping isn't enabled.</p>
        /// <p>For more information about IAM database authentication, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.html"> IAM Database Authentication for MySQL and PostgreSQL</a> in the <i>Amazon RDS User Guide</i>.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn enable_iam_database_authentication(mut self, input: bool) -> Self {
            self.enable_iam_database_authentication = Some(input);
            self
        }
        /// <p>A value that indicates whether to enable mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts. By default, mapping isn't enabled.</p>
        /// <p>For more information about IAM database authentication, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.html"> IAM Database Authentication for MySQL and PostgreSQL</a> in the <i>Amazon RDS User Guide</i>.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn set_enable_iam_database_authentication(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.enable_iam_database_authentication = input;
            self
        }
        /// <p>A value that indicates whether to enable Performance Insights for the read replica.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html">Using Amazon Performance Insights</a> in the <i>Amazon RDS User Guide</i>.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn enable_performance_insights(mut self, input: bool) -> Self {
            self.enable_performance_insights = Some(input);
            self
        }
        /// <p>A value that indicates whether to enable Performance Insights for the read replica.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html">Using Amazon Performance Insights</a> in the <i>Amazon RDS User Guide</i>.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn set_enable_performance_insights(mut self, input: std::option::Option<bool>) -> Self {
            self.enable_performance_insights = input;
            self
        }
        /// <p>The Amazon Web Services KMS key identifier for encryption of Performance Insights data.</p>
        /// <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.</p>
        /// <p>If you do not specify a value for <code>PerformanceInsightsKMSKeyId</code>, then Amazon RDS uses your default KMS key. There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account has a different default KMS key for each Amazon Web Services Region.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn performance_insights_kms_key_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.performance_insights_kms_key_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services KMS key identifier for encryption of Performance Insights data.</p>
        /// <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.</p>
        /// <p>If you do not specify a value for <code>PerformanceInsightsKMSKeyId</code>, then Amazon RDS uses your default KMS key. There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account has a different default KMS key for each Amazon Web Services Region.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn set_performance_insights_kms_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.performance_insights_kms_key_id = input;
            self
        }
        /// <p>The amount of time, in days, to retain Performance Insights data. Valid values are 7 or 731 (2 years).</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn performance_insights_retention_period(mut self, input: i32) -> Self {
            self.performance_insights_retention_period = Some(input);
            self
        }
        /// <p>The amount of time, in days, to retain Performance Insights data. Valid values are 7 or 731 (2 years).</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn set_performance_insights_retention_period(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.performance_insights_retention_period = input;
            self
        }
        /// Appends an item to `enable_cloudwatch_logs_exports`.
        ///
        /// To override the contents of this collection use [`set_enable_cloudwatch_logs_exports`](Self::set_enable_cloudwatch_logs_exports).
        ///
        /// <p>The list of logs that the new DB instance is to export to CloudWatch Logs. The values in the list depend on the DB engine being used. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch">Publishing Database Logs to Amazon CloudWatch Logs </a> in the <i>Amazon RDS User Guide</i>.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn enable_cloudwatch_logs_exports(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.enable_cloudwatch_logs_exports.unwrap_or_default();
            v.push(input.into());
            self.enable_cloudwatch_logs_exports = Some(v);
            self
        }
        /// <p>The list of logs that the new DB instance is to export to CloudWatch Logs. The values in the list depend on the DB engine being used. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch">Publishing Database Logs to Amazon CloudWatch Logs </a> in the <i>Amazon RDS User Guide</i>.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn set_enable_cloudwatch_logs_exports(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.enable_cloudwatch_logs_exports = input;
            self
        }
        /// Appends an item to `processor_features`.
        ///
        /// To override the contents of this collection use [`set_processor_features`](Self::set_processor_features).
        ///
        /// <p>The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn processor_features(mut self, input: crate::model::ProcessorFeature) -> Self {
            let mut v = self.processor_features.unwrap_or_default();
            v.push(input);
            self.processor_features = Some(v);
            self
        }
        /// <p>The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn set_processor_features(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ProcessorFeature>>,
        ) -> Self {
            self.processor_features = input;
            self
        }
        /// <p>A value that indicates whether the DB instance class of the DB instance uses its default processor features.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn use_default_processor_features(mut self, input: bool) -> Self {
            self.use_default_processor_features = Some(input);
            self
        }
        /// <p>A value that indicates whether the DB instance class of the DB instance uses its default processor features.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn set_use_default_processor_features(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.use_default_processor_features = input;
            self
        }
        /// <p>A value that indicates whether the DB instance has deletion protection enabled. The database can't be deleted when deletion protection is enabled. By default, deletion protection isn't enabled. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html"> Deleting a DB Instance</a>.</p>
        pub fn deletion_protection(mut self, input: bool) -> Self {
            self.deletion_protection = Some(input);
            self
        }
        /// <p>A value that indicates whether the DB instance has deletion protection enabled. The database can't be deleted when deletion protection is enabled. By default, deletion protection isn't enabled. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html"> Deleting a DB Instance</a>.</p>
        pub fn set_deletion_protection(mut self, input: std::option::Option<bool>) -> Self {
            self.deletion_protection = input;
            self
        }
        /// <p>The Active Directory directory ID to create the DB instance in. Currently, only MySQL, Microsoft SQL Server, Oracle, and PostgreSQL DB instances can be created in an Active Directory Domain.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/kerberos-authentication.html"> Kerberos Authentication</a> in the <i>Amazon RDS User Guide</i>.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain = Some(input.into());
            self
        }
        /// <p>The Active Directory directory ID to create the DB instance in. Currently, only MySQL, Microsoft SQL Server, Oracle, and PostgreSQL DB instances can be created in an Active Directory Domain.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/kerberos-authentication.html"> Kerberos Authentication</a> in the <i>Amazon RDS User Guide</i>.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain = input;
            self
        }
        /// <p>Specify the name of the IAM role to be used when making API calls to the Directory Service.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn domain_iam_role_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_iam_role_name = Some(input.into());
            self
        }
        /// <p>Specify the name of the IAM role to be used when making API calls to the Directory Service.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn set_domain_iam_role_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.domain_iam_role_name = input;
            self
        }
        /// <p>The open mode of the replica database: mounted or read-only.</p> <note>
        /// <p>This parameter is only supported for Oracle DB instances.</p>
        /// </note>
        /// <p>Mounted DB replicas are included in Oracle Database Enterprise Edition. The main use case for mounted replicas is cross-Region disaster recovery. The primary database doesn't use Active Data Guard to transmit information to the mounted replica. Because it doesn't accept user connections, a mounted replica can't serve a read-only workload.</p>
        /// <p>You can create a combination of mounted and read-only DB replicas for the same primary DB instance. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/oracle-read-replicas.html">Working with Oracle Read Replicas for Amazon RDS</a> in the <i>Amazon RDS User Guide</i>.</p>
        /// <p>For RDS Custom, you must specify this parameter and set it to <code>mounted</code>. The value won't be set by default. After replica creation, you can manage the open mode manually.</p>
        pub fn replica_mode(mut self, input: crate::model::ReplicaMode) -> Self {
            self.replica_mode = Some(input);
            self
        }
        /// <p>The open mode of the replica database: mounted or read-only.</p> <note>
        /// <p>This parameter is only supported for Oracle DB instances.</p>
        /// </note>
        /// <p>Mounted DB replicas are included in Oracle Database Enterprise Edition. The main use case for mounted replicas is cross-Region disaster recovery. The primary database doesn't use Active Data Guard to transmit information to the mounted replica. Because it doesn't accept user connections, a mounted replica can't serve a read-only workload.</p>
        /// <p>You can create a combination of mounted and read-only DB replicas for the same primary DB instance. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/oracle-read-replicas.html">Working with Oracle Read Replicas for Amazon RDS</a> in the <i>Amazon RDS User Guide</i>.</p>
        /// <p>For RDS Custom, you must specify this parameter and set it to <code>mounted</code>. The value won't be set by default. After replica creation, you can manage the open mode manually.</p>
        pub fn set_replica_mode(
            mut self,
            input: std::option::Option<crate::model::ReplicaMode>,
        ) -> Self {
            self.replica_mode = input;
            self
        }
        /// <p>The upper limit in gibibytes (GiB) to which Amazon RDS can automatically scale the storage of the DB instance.</p>
        /// <p>For more information about this setting, including limitations that apply to it, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIOPS.StorageTypes.html#USER_PIOPS.Autoscaling"> Managing capacity automatically with Amazon RDS storage autoscaling</a> in the <i>Amazon RDS User Guide</i>.</p>
        pub fn max_allocated_storage(mut self, input: i32) -> Self {
            self.max_allocated_storage = Some(input);
            self
        }
        /// <p>The upper limit in gibibytes (GiB) to which Amazon RDS can automatically scale the storage of the DB instance.</p>
        /// <p>For more information about this setting, including limitations that apply to it, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIOPS.StorageTypes.html#USER_PIOPS.Autoscaling"> Managing capacity automatically with Amazon RDS storage autoscaling</a> in the <i>Amazon RDS User Guide</i>.</p>
        pub fn set_max_allocated_storage(mut self, input: std::option::Option<i32>) -> Self {
            self.max_allocated_storage = input;
            self
        }
        /// <p>The instance profile associated with the underlying Amazon EC2 instance of an RDS Custom DB instance. The instance profile must meet the following requirements:</p>
        /// <ul>
        /// <li> <p>The profile must exist in your account.</p> </li>
        /// <li> <p>The profile must have an IAM role that Amazon EC2 has permissions to assume.</p> </li>
        /// <li> <p>The instance profile name and the associated IAM role name must start with the prefix <code>AWSRDSCustom</code>.</p> </li>
        /// </ul>
        /// <p>For the list of permissions required for the IAM role, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-setup-orcl.html#custom-setup-orcl.iam-vpc"> Configure IAM and your VPC</a> in the <i>Amazon RDS User Guide</i>.</p>
        /// <p>This setting is required for RDS Custom.</p>
        pub fn custom_iam_instance_profile(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.custom_iam_instance_profile = Some(input.into());
            self
        }
        /// <p>The instance profile associated with the underlying Amazon EC2 instance of an RDS Custom DB instance. The instance profile must meet the following requirements:</p>
        /// <ul>
        /// <li> <p>The profile must exist in your account.</p> </li>
        /// <li> <p>The profile must have an IAM role that Amazon EC2 has permissions to assume.</p> </li>
        /// <li> <p>The instance profile name and the associated IAM role name must start with the prefix <code>AWSRDSCustom</code>.</p> </li>
        /// </ul>
        /// <p>For the list of permissions required for the IAM role, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-setup-orcl.html#custom-setup-orcl.iam-vpc"> Configure IAM and your VPC</a> in the <i>Amazon RDS User Guide</i>.</p>
        /// <p>This setting is required for RDS Custom.</p>
        pub fn set_custom_iam_instance_profile(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.custom_iam_instance_profile = input;
            self
        }
        /// <p>The network type of the DB instance.</p>
        /// <p>Valid values:</p>
        /// <ul>
        /// <li> <p> <code>IPV4</code> </p> </li>
        /// <li> <p> <code>DUAL</code> </p> </li>
        /// </ul>
        /// <p>The network type is determined by the <code>DBSubnetGroup</code> specified for read replica. A <code>DBSubnetGroup</code> can support only the IPv4 protocol or the IPv4 and the IPv6 protocols (<code>DUAL</code>).</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html"> Working with a DB instance in a VPC</a> in the <i>Amazon RDS User Guide.</i> </p>
        pub fn network_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.network_type = Some(input.into());
            self
        }
        /// <p>The network type of the DB instance.</p>
        /// <p>Valid values:</p>
        /// <ul>
        /// <li> <p> <code>IPV4</code> </p> </li>
        /// <li> <p> <code>DUAL</code> </p> </li>
        /// </ul>
        /// <p>The network type is determined by the <code>DBSubnetGroup</code> specified for read replica. A <code>DBSubnetGroup</code> can support only the IPv4 protocol or the IPv4 and the IPv6 protocols (<code>DUAL</code>).</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html"> Working with a DB instance in a VPC</a> in the <i>Amazon RDS User Guide.</i> </p>
        pub fn set_network_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.network_type = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDbInstanceReadReplicaInput`](crate::input::CreateDbInstanceReadReplicaInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateDbInstanceReadReplicaInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateDbInstanceReadReplicaInput {
                db_instance_identifier: self.db_instance_identifier,
                source_db_instance_identifier: self.source_db_instance_identifier,
                db_instance_class: self.db_instance_class,
                availability_zone: self.availability_zone,
                port: self.port,
                multi_az: self.multi_az,
                auto_minor_version_upgrade: self.auto_minor_version_upgrade,
                iops: self.iops,
                option_group_name: self.option_group_name,
                db_parameter_group_name: self.db_parameter_group_name,
                publicly_accessible: self.publicly_accessible,
                tags: self.tags,
                db_subnet_group_name: self.db_subnet_group_name,
                vpc_security_group_ids: self.vpc_security_group_ids,
                storage_type: self.storage_type,
                copy_tags_to_snapshot: self.copy_tags_to_snapshot,
                monitoring_interval: self.monitoring_interval,
                monitoring_role_arn: self.monitoring_role_arn,
                kms_key_id: self.kms_key_id,
                pre_signed_url: self.pre_signed_url,
                enable_iam_database_authentication: self.enable_iam_database_authentication,
                enable_performance_insights: self.enable_performance_insights,
                performance_insights_kms_key_id: self.performance_insights_kms_key_id,
                performance_insights_retention_period: self.performance_insights_retention_period,
                enable_cloudwatch_logs_exports: self.enable_cloudwatch_logs_exports,
                processor_features: self.processor_features,
                use_default_processor_features: self.use_default_processor_features,
                deletion_protection: self.deletion_protection,
                domain: self.domain,
                domain_iam_role_name: self.domain_iam_role_name,
                replica_mode: self.replica_mode,
                max_allocated_storage: self.max_allocated_storage,
                custom_iam_instance_profile: self.custom_iam_instance_profile,
                network_type: self.network_type,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateDbInstanceReadReplicaInputOperationOutputAlias =
    crate::operation::CreateDBInstanceReadReplica;
#[doc(hidden)]
pub type CreateDbInstanceReadReplicaInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateDbInstanceReadReplicaInput {
    /// Consumes the builder and constructs an Operation<[`CreateDBInstanceReadReplica`](crate::operation::CreateDBInstanceReadReplica)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateDBInstanceReadReplica,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateDbInstanceReadReplicaInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateDbInstanceReadReplicaInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_db_instance_read_replica(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateDBInstanceReadReplica::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateDBInstanceReadReplica",
            "rds",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateDbInstanceReadReplicaInput`](crate::input::CreateDbInstanceReadReplicaInput)
    pub fn builder() -> crate::input::create_db_instance_read_replica_input::Builder {
        crate::input::create_db_instance_read_replica_input::Builder::default()
    }
}

/// See [`CreateDbParameterGroupInput`](crate::input::CreateDbParameterGroupInput)
pub mod create_db_parameter_group_input {
    /// A builder for [`CreateDbParameterGroupInput`](crate::input::CreateDbParameterGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_parameter_group_name: std::option::Option<std::string::String>,
        pub(crate) db_parameter_group_family: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of the DB parameter group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be 1 to 255 letters, numbers, or hyphens.</p> </li>
        /// <li> <p>First character must be a letter</p> </li>
        /// <li> <p>Can't end with a hyphen or contain two consecutive hyphens</p> </li>
        /// </ul> <note>
        /// <p>This value is stored as a lowercase string.</p>
        /// </note>
        pub fn db_parameter_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_parameter_group_name = Some(input.into());
            self
        }
        /// <p>The name of the DB parameter group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be 1 to 255 letters, numbers, or hyphens.</p> </li>
        /// <li> <p>First character must be a letter</p> </li>
        /// <li> <p>Can't end with a hyphen or contain two consecutive hyphens</p> </li>
        /// </ul> <note>
        /// <p>This value is stored as a lowercase string.</p>
        /// </note>
        pub fn set_db_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_parameter_group_name = input;
            self
        }
        /// <p>The DB parameter group family name. A DB parameter group can be associated with one and only one DB parameter group family, and can be applied only to a DB instance running a database engine and engine version compatible with that DB parameter group family.</p>
        /// <p>To list all of the available parameter group families for a DB engine, use the following command:</p>
        /// <p> <code>aws rds describe-db-engine-versions --query "DBEngineVersions[].DBParameterGroupFamily" --engine
        /// <engine></engine></code> </p>
        /// <p>For example, to list all of the available parameter group families for the MySQL DB engine, use the following command:</p>
        /// <p> <code>aws rds describe-db-engine-versions --query "DBEngineVersions[].DBParameterGroupFamily" --engine mysql</code> </p> <note>
        /// <p>The output contains duplicates.</p>
        /// </note>
        /// <p>The following are the valid DB engine values:</p>
        /// <ul>
        /// <li> <p> <code>aurora</code> (for MySQL 5.6-compatible Aurora)</p> </li>
        /// <li> <p> <code>aurora-mysql</code> (for MySQL 5.7-compatible and MySQL 8.0-compatible Aurora)</p> </li>
        /// <li> <p> <code>aurora-postgresql</code> </p> </li>
        /// <li> <p> <code>mariadb</code> </p> </li>
        /// <li> <p> <code>mysql</code> </p> </li>
        /// <li> <p> <code>oracle-ee</code> </p> </li>
        /// <li> <p> <code>oracle-ee-cdb</code> </p> </li>
        /// <li> <p> <code>oracle-se2</code> </p> </li>
        /// <li> <p> <code>oracle-se2-cdb</code> </p> </li>
        /// <li> <p> <code>postgres</code> </p> </li>
        /// <li> <p> <code>sqlserver-ee</code> </p> </li>
        /// <li> <p> <code>sqlserver-se</code> </p> </li>
        /// <li> <p> <code>sqlserver-ex</code> </p> </li>
        /// <li> <p> <code>sqlserver-web</code> </p> </li>
        /// </ul>
        pub fn db_parameter_group_family(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_parameter_group_family = Some(input.into());
            self
        }
        /// <p>The DB parameter group family name. A DB parameter group can be associated with one and only one DB parameter group family, and can be applied only to a DB instance running a database engine and engine version compatible with that DB parameter group family.</p>
        /// <p>To list all of the available parameter group families for a DB engine, use the following command:</p>
        /// <p> <code>aws rds describe-db-engine-versions --query "DBEngineVersions[].DBParameterGroupFamily" --engine
        /// <engine></engine></code> </p>
        /// <p>For example, to list all of the available parameter group families for the MySQL DB engine, use the following command:</p>
        /// <p> <code>aws rds describe-db-engine-versions --query "DBEngineVersions[].DBParameterGroupFamily" --engine mysql</code> </p> <note>
        /// <p>The output contains duplicates.</p>
        /// </note>
        /// <p>The following are the valid DB engine values:</p>
        /// <ul>
        /// <li> <p> <code>aurora</code> (for MySQL 5.6-compatible Aurora)</p> </li>
        /// <li> <p> <code>aurora-mysql</code> (for MySQL 5.7-compatible and MySQL 8.0-compatible Aurora)</p> </li>
        /// <li> <p> <code>aurora-postgresql</code> </p> </li>
        /// <li> <p> <code>mariadb</code> </p> </li>
        /// <li> <p> <code>mysql</code> </p> </li>
        /// <li> <p> <code>oracle-ee</code> </p> </li>
        /// <li> <p> <code>oracle-ee-cdb</code> </p> </li>
        /// <li> <p> <code>oracle-se2</code> </p> </li>
        /// <li> <p> <code>oracle-se2-cdb</code> </p> </li>
        /// <li> <p> <code>postgres</code> </p> </li>
        /// <li> <p> <code>sqlserver-ee</code> </p> </li>
        /// <li> <p> <code>sqlserver-se</code> </p> </li>
        /// <li> <p> <code>sqlserver-ex</code> </p> </li>
        /// <li> <p> <code>sqlserver-web</code> </p> </li>
        /// </ul>
        pub fn set_db_parameter_group_family(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_parameter_group_family = input;
            self
        }
        /// <p>The description for the DB parameter group.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description for the DB parameter group.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags to assign to the DB parameter group.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>Tags to assign to the DB parameter group.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDbParameterGroupInput`](crate::input::CreateDbParameterGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateDbParameterGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateDbParameterGroupInput {
                db_parameter_group_name: self.db_parameter_group_name,
                db_parameter_group_family: self.db_parameter_group_family,
                description: self.description,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateDbParameterGroupInputOperationOutputAlias = crate::operation::CreateDBParameterGroup;
#[doc(hidden)]
pub type CreateDbParameterGroupInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateDbParameterGroupInput {
    /// Consumes the builder and constructs an Operation<[`CreateDBParameterGroup`](crate::operation::CreateDBParameterGroup)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateDBParameterGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateDbParameterGroupInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateDbParameterGroupInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_db_parameter_group(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateDBParameterGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateDBParameterGroup",
            "rds",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateDbParameterGroupInput`](crate::input::CreateDbParameterGroupInput)
    pub fn builder() -> crate::input::create_db_parameter_group_input::Builder {
        crate::input::create_db_parameter_group_input::Builder::default()
    }
}

/// See [`CreateDbProxyInput`](crate::input::CreateDbProxyInput)
pub mod create_db_proxy_input {
    /// A builder for [`CreateDbProxyInput`](crate::input::CreateDbProxyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_proxy_name: std::option::Option<std::string::String>,
        pub(crate) engine_family: std::option::Option<crate::model::EngineFamily>,
        pub(crate) auth: std::option::Option<std::vec::Vec<crate::model::UserAuthConfig>>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) vpc_subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) vpc_security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) require_tls: std::option::Option<bool>,
        pub(crate) idle_client_timeout: std::option::Option<i32>,
        pub(crate) debug_logging: std::option::Option<bool>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The identifier for the proxy. This name must be unique for all proxies owned by your Amazon Web Services account in the specified Amazon Web Services Region. An identifier must begin with a letter and must contain only ASCII letters, digits, and hyphens; it can't end with a hyphen or contain two consecutive hyphens.</p>
        pub fn db_proxy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_proxy_name = Some(input.into());
            self
        }
        /// <p>The identifier for the proxy. This name must be unique for all proxies owned by your Amazon Web Services account in the specified Amazon Web Services Region. An identifier must begin with a letter and must contain only ASCII letters, digits, and hyphens; it can't end with a hyphen or contain two consecutive hyphens.</p>
        pub fn set_db_proxy_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_proxy_name = input;
            self
        }
        /// <p>The kinds of databases that the proxy can connect to. This value determines which database network protocol the proxy recognizes when it interprets network traffic to and from the database. The engine family applies to MySQL and PostgreSQL for both RDS and Aurora.</p>
        pub fn engine_family(mut self, input: crate::model::EngineFamily) -> Self {
            self.engine_family = Some(input);
            self
        }
        /// <p>The kinds of databases that the proxy can connect to. This value determines which database network protocol the proxy recognizes when it interprets network traffic to and from the database. The engine family applies to MySQL and PostgreSQL for both RDS and Aurora.</p>
        pub fn set_engine_family(
            mut self,
            input: std::option::Option<crate::model::EngineFamily>,
        ) -> Self {
            self.engine_family = input;
            self
        }
        /// Appends an item to `auth`.
        ///
        /// To override the contents of this collection use [`set_auth`](Self::set_auth).
        ///
        /// <p>The authorization mechanism that the proxy uses.</p>
        pub fn auth(mut self, input: crate::model::UserAuthConfig) -> Self {
            let mut v = self.auth.unwrap_or_default();
            v.push(input);
            self.auth = Some(v);
            self
        }
        /// <p>The authorization mechanism that the proxy uses.</p>
        pub fn set_auth(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UserAuthConfig>>,
        ) -> Self {
            self.auth = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role that the proxy uses to access secrets in Amazon Web Services Secrets Manager.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role that the proxy uses to access secrets in Amazon Web Services Secrets Manager.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Appends an item to `vpc_subnet_ids`.
        ///
        /// To override the contents of this collection use [`set_vpc_subnet_ids`](Self::set_vpc_subnet_ids).
        ///
        /// <p>One or more VPC subnet IDs to associate with the new proxy.</p>
        pub fn vpc_subnet_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.vpc_subnet_ids.unwrap_or_default();
            v.push(input.into());
            self.vpc_subnet_ids = Some(v);
            self
        }
        /// <p>One or more VPC subnet IDs to associate with the new proxy.</p>
        pub fn set_vpc_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.vpc_subnet_ids = input;
            self
        }
        /// Appends an item to `vpc_security_group_ids`.
        ///
        /// To override the contents of this collection use [`set_vpc_security_group_ids`](Self::set_vpc_security_group_ids).
        ///
        /// <p>One or more VPC security group IDs to associate with the new proxy.</p>
        pub fn vpc_security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.vpc_security_group_ids.unwrap_or_default();
            v.push(input.into());
            self.vpc_security_group_ids = Some(v);
            self
        }
        /// <p>One or more VPC security group IDs to associate with the new proxy.</p>
        pub fn set_vpc_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.vpc_security_group_ids = input;
            self
        }
        /// <p>A Boolean parameter that specifies whether Transport Layer Security (TLS) encryption is required for connections to the proxy. By enabling this setting, you can enforce encrypted TLS connections to the proxy.</p>
        pub fn require_tls(mut self, input: bool) -> Self {
            self.require_tls = Some(input);
            self
        }
        /// <p>A Boolean parameter that specifies whether Transport Layer Security (TLS) encryption is required for connections to the proxy. By enabling this setting, you can enforce encrypted TLS connections to the proxy.</p>
        pub fn set_require_tls(mut self, input: std::option::Option<bool>) -> Self {
            self.require_tls = input;
            self
        }
        /// <p>The number of seconds that a connection to the proxy can be inactive before the proxy disconnects it. You can set this value higher or lower than the connection timeout limit for the associated database.</p>
        pub fn idle_client_timeout(mut self, input: i32) -> Self {
            self.idle_client_timeout = Some(input);
            self
        }
        /// <p>The number of seconds that a connection to the proxy can be inactive before the proxy disconnects it. You can set this value higher or lower than the connection timeout limit for the associated database.</p>
        pub fn set_idle_client_timeout(mut self, input: std::option::Option<i32>) -> Self {
            self.idle_client_timeout = input;
            self
        }
        /// <p>Whether the proxy includes detailed information about SQL statements in its logs. This information helps you to debug issues involving SQL behavior or the performance and scalability of the proxy connections. The debug information includes the text of SQL statements that you submit through the proxy. Thus, only enable this setting when needed for debugging, and only when you have security measures in place to safeguard any sensitive information that appears in the logs.</p>
        pub fn debug_logging(mut self, input: bool) -> Self {
            self.debug_logging = Some(input);
            self
        }
        /// <p>Whether the proxy includes detailed information about SQL statements in its logs. This information helps you to debug issues involving SQL behavior or the performance and scalability of the proxy connections. The debug information includes the text of SQL statements that you submit through the proxy. Thus, only enable this setting when needed for debugging, and only when you have security measures in place to safeguard any sensitive information that appears in the logs.</p>
        pub fn set_debug_logging(mut self, input: std::option::Option<bool>) -> Self {
            self.debug_logging = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An optional set of key-value pairs to associate arbitrary data of your choosing with the proxy.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>An optional set of key-value pairs to associate arbitrary data of your choosing with the proxy.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDbProxyInput`](crate::input::CreateDbProxyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateDbProxyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateDbProxyInput {
                db_proxy_name: self.db_proxy_name,
                engine_family: self.engine_family,
                auth: self.auth,
                role_arn: self.role_arn,
                vpc_subnet_ids: self.vpc_subnet_ids,
                vpc_security_group_ids: self.vpc_security_group_ids,
                require_tls: self.require_tls.unwrap_or_default(),
                idle_client_timeout: self.idle_client_timeout,
                debug_logging: self.debug_logging.unwrap_or_default(),
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateDbProxyInputOperationOutputAlias = crate::operation::CreateDBProxy;
#[doc(hidden)]
pub type CreateDbProxyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateDbProxyInput {
    /// Consumes the builder and constructs an Operation<[`CreateDBProxy`](crate::operation::CreateDBProxy)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateDBProxy,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateDbProxyInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateDbProxyInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_db_proxy(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateDBProxy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateDBProxy",
            "rds",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateDbProxyInput`](crate::input::CreateDbProxyInput)
    pub fn builder() -> crate::input::create_db_proxy_input::Builder {
        crate::input::create_db_proxy_input::Builder::default()
    }
}

/// See [`CreateDbProxyEndpointInput`](crate::input::CreateDbProxyEndpointInput)
pub mod create_db_proxy_endpoint_input {
    /// A builder for [`CreateDbProxyEndpointInput`](crate::input::CreateDbProxyEndpointInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_proxy_name: std::option::Option<std::string::String>,
        pub(crate) db_proxy_endpoint_name: std::option::Option<std::string::String>,
        pub(crate) vpc_subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) vpc_security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) target_role: std::option::Option<crate::model::DbProxyEndpointTargetRole>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of the DB proxy associated with the DB proxy endpoint that you create.</p>
        pub fn db_proxy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_proxy_name = Some(input.into());
            self
        }
        /// <p>The name of the DB proxy associated with the DB proxy endpoint that you create.</p>
        pub fn set_db_proxy_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_proxy_name = input;
            self
        }
        /// <p>The name of the DB proxy endpoint to create.</p>
        pub fn db_proxy_endpoint_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_proxy_endpoint_name = Some(input.into());
            self
        }
        /// <p>The name of the DB proxy endpoint to create.</p>
        pub fn set_db_proxy_endpoint_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_proxy_endpoint_name = input;
            self
        }
        /// Appends an item to `vpc_subnet_ids`.
        ///
        /// To override the contents of this collection use [`set_vpc_subnet_ids`](Self::set_vpc_subnet_ids).
        ///
        /// <p>The VPC subnet IDs for the DB proxy endpoint that you create. You can specify a different set of subnet IDs than for the original DB proxy.</p>
        pub fn vpc_subnet_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.vpc_subnet_ids.unwrap_or_default();
            v.push(input.into());
            self.vpc_subnet_ids = Some(v);
            self
        }
        /// <p>The VPC subnet IDs for the DB proxy endpoint that you create. You can specify a different set of subnet IDs than for the original DB proxy.</p>
        pub fn set_vpc_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.vpc_subnet_ids = input;
            self
        }
        /// Appends an item to `vpc_security_group_ids`.
        ///
        /// To override the contents of this collection use [`set_vpc_security_group_ids`](Self::set_vpc_security_group_ids).
        ///
        /// <p>The VPC security group IDs for the DB proxy endpoint that you create. You can specify a different set of security group IDs than for the original DB proxy. The default is the default security group for the VPC.</p>
        pub fn vpc_security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.vpc_security_group_ids.unwrap_or_default();
            v.push(input.into());
            self.vpc_security_group_ids = Some(v);
            self
        }
        /// <p>The VPC security group IDs for the DB proxy endpoint that you create. You can specify a different set of security group IDs than for the original DB proxy. The default is the default security group for the VPC.</p>
        pub fn set_vpc_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.vpc_security_group_ids = input;
            self
        }
        /// <p>A value that indicates whether the DB proxy endpoint can be used for read/write or read-only operations. The default is <code>READ_WRITE</code>.</p>
        pub fn target_role(mut self, input: crate::model::DbProxyEndpointTargetRole) -> Self {
            self.target_role = Some(input);
            self
        }
        /// <p>A value that indicates whether the DB proxy endpoint can be used for read/write or read-only operations. The default is <code>READ_WRITE</code>.</p>
        pub fn set_target_role(
            mut self,
            input: std::option::Option<crate::model::DbProxyEndpointTargetRole>,
        ) -> Self {
            self.target_role = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources</a> in the <i>Amazon RDS User Guide.</i> </p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>A list of tags. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources</a> in the <i>Amazon RDS User Guide.</i> </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDbProxyEndpointInput`](crate::input::CreateDbProxyEndpointInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateDbProxyEndpointInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateDbProxyEndpointInput {
                db_proxy_name: self.db_proxy_name,
                db_proxy_endpoint_name: self.db_proxy_endpoint_name,
                vpc_subnet_ids: self.vpc_subnet_ids,
                vpc_security_group_ids: self.vpc_security_group_ids,
                target_role: self.target_role,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateDbProxyEndpointInputOperationOutputAlias = crate::operation::CreateDBProxyEndpoint;
#[doc(hidden)]
pub type CreateDbProxyEndpointInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateDbProxyEndpointInput {
    /// Consumes the builder and constructs an Operation<[`CreateDBProxyEndpoint`](crate::operation::CreateDBProxyEndpoint)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateDBProxyEndpoint,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateDbProxyEndpointInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateDbProxyEndpointInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_db_proxy_endpoint(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateDBProxyEndpoint::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateDBProxyEndpoint",
            "rds",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateDbProxyEndpointInput`](crate::input::CreateDbProxyEndpointInput)
    pub fn builder() -> crate::input::create_db_proxy_endpoint_input::Builder {
        crate::input::create_db_proxy_endpoint_input::Builder::default()
    }
}

/// See [`CreateDbSecurityGroupInput`](crate::input::CreateDbSecurityGroupInput)
pub mod create_db_security_group_input {
    /// A builder for [`CreateDbSecurityGroupInput`](crate::input::CreateDbSecurityGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_security_group_name: std::option::Option<std::string::String>,
        pub(crate) db_security_group_description: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name for the DB security group. This value is stored as a lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be 1 to 255 letters, numbers, or hyphens.</p> </li>
        /// <li> <p>First character must be a letter</p> </li>
        /// <li> <p>Can't end with a hyphen or contain two consecutive hyphens</p> </li>
        /// <li> <p>Must not be "Default"</p> </li>
        /// </ul>
        /// <p>Example: <code>mysecuritygroup</code> </p>
        pub fn db_security_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_security_group_name = Some(input.into());
            self
        }
        /// <p>The name for the DB security group. This value is stored as a lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be 1 to 255 letters, numbers, or hyphens.</p> </li>
        /// <li> <p>First character must be a letter</p> </li>
        /// <li> <p>Can't end with a hyphen or contain two consecutive hyphens</p> </li>
        /// <li> <p>Must not be "Default"</p> </li>
        /// </ul>
        /// <p>Example: <code>mysecuritygroup</code> </p>
        pub fn set_db_security_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_security_group_name = input;
            self
        }
        /// <p>The description for the DB security group.</p>
        pub fn db_security_group_description(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.db_security_group_description = Some(input.into());
            self
        }
        /// <p>The description for the DB security group.</p>
        pub fn set_db_security_group_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_security_group_description = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags to assign to the DB security group.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>Tags to assign to the DB security group.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDbSecurityGroupInput`](crate::input::CreateDbSecurityGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateDbSecurityGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateDbSecurityGroupInput {
                db_security_group_name: self.db_security_group_name,
                db_security_group_description: self.db_security_group_description,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateDbSecurityGroupInputOperationOutputAlias = crate::operation::CreateDBSecurityGroup;
#[doc(hidden)]
pub type CreateDbSecurityGroupInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateDbSecurityGroupInput {
    /// Consumes the builder and constructs an Operation<[`CreateDBSecurityGroup`](crate::operation::CreateDBSecurityGroup)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateDBSecurityGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateDbSecurityGroupInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateDbSecurityGroupInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_db_security_group(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateDBSecurityGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateDBSecurityGroup",
            "rds",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateDbSecurityGroupInput`](crate::input::CreateDbSecurityGroupInput)
    pub fn builder() -> crate::input::create_db_security_group_input::Builder {
        crate::input::create_db_security_group_input::Builder::default()
    }
}

/// See [`CreateDbSnapshotInput`](crate::input::CreateDbSnapshotInput)
pub mod create_db_snapshot_input {
    /// A builder for [`CreateDbSnapshotInput`](crate::input::CreateDbSnapshotInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_snapshot_identifier: std::option::Option<std::string::String>,
        pub(crate) db_instance_identifier: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The identifier for the DB snapshot.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Can't be null, empty, or blank</p> </li>
        /// <li> <p>Must contain from 1 to 255 letters, numbers, or hyphens</p> </li>
        /// <li> <p>First character must be a letter</p> </li>
        /// <li> <p>Can't end with a hyphen or contain two consecutive hyphens</p> </li>
        /// </ul>
        /// <p>Example: <code>my-snapshot-id</code> </p>
        pub fn db_snapshot_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_snapshot_identifier = Some(input.into());
            self
        }
        /// <p>The identifier for the DB snapshot.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Can't be null, empty, or blank</p> </li>
        /// <li> <p>Must contain from 1 to 255 letters, numbers, or hyphens</p> </li>
        /// <li> <p>First character must be a letter</p> </li>
        /// <li> <p>Can't end with a hyphen or contain two consecutive hyphens</p> </li>
        /// </ul>
        /// <p>Example: <code>my-snapshot-id</code> </p>
        pub fn set_db_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_snapshot_identifier = input;
            self
        }
        /// <p>The identifier of the DB instance that you want to create the snapshot of.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must match the identifier of an existing DBInstance.</p> </li>
        /// </ul>
        pub fn db_instance_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_instance_identifier = Some(input.into());
            self
        }
        /// <p>The identifier of the DB instance that you want to create the snapshot of.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must match the identifier of an existing DBInstance.</p> </li>
        /// </ul>
        pub fn set_db_instance_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_instance_identifier = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources</a> in the <i>Amazon RDS User Guide.</i> </p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>A list of tags. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources</a> in the <i>Amazon RDS User Guide.</i> </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDbSnapshotInput`](crate::input::CreateDbSnapshotInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateDbSnapshotInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateDbSnapshotInput {
                db_snapshot_identifier: self.db_snapshot_identifier,
                db_instance_identifier: self.db_instance_identifier,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateDbSnapshotInputOperationOutputAlias = crate::operation::CreateDBSnapshot;
#[doc(hidden)]
pub type CreateDbSnapshotInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateDbSnapshotInput {
    /// Consumes the builder and constructs an Operation<[`CreateDBSnapshot`](crate::operation::CreateDBSnapshot)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateDBSnapshot,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateDbSnapshotInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateDbSnapshotInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_db_snapshot(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateDBSnapshot::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateDBSnapshot",
            "rds",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateDbSnapshotInput`](crate::input::CreateDbSnapshotInput)
    pub fn builder() -> crate::input::create_db_snapshot_input::Builder {
        crate::input::create_db_snapshot_input::Builder::default()
    }
}

/// See [`CreateDbSubnetGroupInput`](crate::input::CreateDbSubnetGroupInput)
pub mod create_db_subnet_group_input {
    /// A builder for [`CreateDbSubnetGroupInput`](crate::input::CreateDbSubnetGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_subnet_group_name: std::option::Option<std::string::String>,
        pub(crate) db_subnet_group_description: std::option::Option<std::string::String>,
        pub(crate) subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name for the DB subnet group. This value is stored as a lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must contain no more than 255 letters, numbers, periods, underscores, spaces, or hyphens.</p> </li>
        /// <li> <p>Must not be default.</p> </li>
        /// <li> <p>First character must be a letter.</p> </li>
        /// </ul>
        /// <p>Example: <code>mydbsubnetgroup</code> </p>
        pub fn db_subnet_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_subnet_group_name = Some(input.into());
            self
        }
        /// <p>The name for the DB subnet group. This value is stored as a lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must contain no more than 255 letters, numbers, periods, underscores, spaces, or hyphens.</p> </li>
        /// <li> <p>Must not be default.</p> </li>
        /// <li> <p>First character must be a letter.</p> </li>
        /// </ul>
        /// <p>Example: <code>mydbsubnetgroup</code> </p>
        pub fn set_db_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_subnet_group_name = input;
            self
        }
        /// <p>The description for the DB subnet group.</p>
        pub fn db_subnet_group_description(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.db_subnet_group_description = Some(input.into());
            self
        }
        /// <p>The description for the DB subnet group.</p>
        pub fn set_db_subnet_group_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_subnet_group_description = input;
            self
        }
        /// Appends an item to `subnet_ids`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// <p>The EC2 Subnet IDs for the DB subnet group.</p>
        pub fn subnet_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.subnet_ids.unwrap_or_default();
            v.push(input.into());
            self.subnet_ids = Some(v);
            self
        }
        /// <p>The EC2 Subnet IDs for the DB subnet group.</p>
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.subnet_ids = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags to assign to the DB subnet group.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>Tags to assign to the DB subnet group.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDbSubnetGroupInput`](crate::input::CreateDbSubnetGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateDbSubnetGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateDbSubnetGroupInput {
                db_subnet_group_name: self.db_subnet_group_name,
                db_subnet_group_description: self.db_subnet_group_description,
                subnet_ids: self.subnet_ids,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateDbSubnetGroupInputOperationOutputAlias = crate::operation::CreateDBSubnetGroup;
#[doc(hidden)]
pub type CreateDbSubnetGroupInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateDbSubnetGroupInput {
    /// Consumes the builder and constructs an Operation<[`CreateDBSubnetGroup`](crate::operation::CreateDBSubnetGroup)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateDBSubnetGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateDbSubnetGroupInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateDbSubnetGroupInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_db_subnet_group(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateDBSubnetGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateDBSubnetGroup",
            "rds",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateDbSubnetGroupInput`](crate::input::CreateDbSubnetGroupInput)
    pub fn builder() -> crate::input::create_db_subnet_group_input::Builder {
        crate::input::create_db_subnet_group_input::Builder::default()
    }
}

/// See [`CreateEventSubscriptionInput`](crate::input::CreateEventSubscriptionInput)
pub mod create_event_subscription_input {
    /// A builder for [`CreateEventSubscriptionInput`](crate::input::CreateEventSubscriptionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) subscription_name: std::option::Option<std::string::String>,
        pub(crate) sns_topic_arn: std::option::Option<std::string::String>,
        pub(crate) source_type: std::option::Option<std::string::String>,
        pub(crate) event_categories: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) source_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) enabled: std::option::Option<bool>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of the subscription.</p>
        /// <p>Constraints: The name must be less than 255 characters.</p>
        pub fn subscription_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.subscription_name = Some(input.into());
            self
        }
        /// <p>The name of the subscription.</p>
        /// <p>Constraints: The name must be less than 255 characters.</p>
        pub fn set_subscription_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.subscription_name = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the SNS topic created for event notification. The ARN is created by Amazon SNS when you create a topic and subscribe to it.</p>
        pub fn sns_topic_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.sns_topic_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the SNS topic created for event notification. The ARN is created by Amazon SNS when you create a topic and subscribe to it.</p>
        pub fn set_sns_topic_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.sns_topic_arn = input;
            self
        }
        /// <p>The type of source that is generating the events. For example, if you want to be notified of events generated by a DB instance, you set this parameter to <code>db-instance</code>. For RDS Proxy events, specify <code>db-proxy</code>. If this value isn't specified, all events are returned.</p>
        /// <p>Valid values: <code>db-instance</code> | <code>db-cluster</code> | <code>db-parameter-group</code> | <code>db-security-group</code> | <code>db-snapshot</code> | <code>db-cluster-snapshot</code> | <code>db-proxy</code> </p>
        pub fn source_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_type = Some(input.into());
            self
        }
        /// <p>The type of source that is generating the events. For example, if you want to be notified of events generated by a DB instance, you set this parameter to <code>db-instance</code>. For RDS Proxy events, specify <code>db-proxy</code>. If this value isn't specified, all events are returned.</p>
        /// <p>Valid values: <code>db-instance</code> | <code>db-cluster</code> | <code>db-parameter-group</code> | <code>db-security-group</code> | <code>db-snapshot</code> | <code>db-cluster-snapshot</code> | <code>db-proxy</code> </p>
        pub fn set_source_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source_type = input;
            self
        }
        /// Appends an item to `event_categories`.
        ///
        /// To override the contents of this collection use [`set_event_categories`](Self::set_event_categories).
        ///
        /// <p>A list of event categories for a particular source type (<code>SourceType</code>) that you want to subscribe to. You can see a list of the categories for a given source type in the "Amazon RDS event categories and event messages" section of the <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Events.Messages.html"> <i>Amazon RDS User Guide</i> </a> or the <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_Events.Messages.html"> <i>Amazon Aurora User Guide</i> </a>. You can also see this list by using the <code>DescribeEventCategories</code> operation.</p>
        pub fn event_categories(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.event_categories.unwrap_or_default();
            v.push(input.into());
            self.event_categories = Some(v);
            self
        }
        /// <p>A list of event categories for a particular source type (<code>SourceType</code>) that you want to subscribe to. You can see a list of the categories for a given source type in the "Amazon RDS event categories and event messages" section of the <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Events.Messages.html"> <i>Amazon RDS User Guide</i> </a> or the <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_Events.Messages.html"> <i>Amazon Aurora User Guide</i> </a>. You can also see this list by using the <code>DescribeEventCategories</code> operation.</p>
        pub fn set_event_categories(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.event_categories = input;
            self
        }
        /// Appends an item to `source_ids`.
        ///
        /// To override the contents of this collection use [`set_source_ids`](Self::set_source_ids).
        ///
        /// <p>The list of identifiers of the event sources for which events are returned. If not specified, then all sources are included in the response. An identifier must begin with a letter and must contain only ASCII letters, digits, and hyphens. It can't end with a hyphen or contain two consecutive hyphens.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>If <code>SourceIds</code> are supplied, <code>SourceType</code> must also be provided.</p> </li>
        /// <li> <p>If the source type is a DB instance, a <code>DBInstanceIdentifier</code> value must be supplied.</p> </li>
        /// <li> <p>If the source type is a DB cluster, a <code>DBClusterIdentifier</code> value must be supplied.</p> </li>
        /// <li> <p>If the source type is a DB parameter group, a <code>DBParameterGroupName</code> value must be supplied.</p> </li>
        /// <li> <p>If the source type is a DB security group, a <code>DBSecurityGroupName</code> value must be supplied.</p> </li>
        /// <li> <p>If the source type is a DB snapshot, a <code>DBSnapshotIdentifier</code> value must be supplied.</p> </li>
        /// <li> <p>If the source type is a DB cluster snapshot, a <code>DBClusterSnapshotIdentifier</code> value must be supplied.</p> </li>
        /// <li> <p>If the source type is an RDS Proxy, a <code>DBProxyName</code> value must be supplied.</p> </li>
        /// </ul>
        pub fn source_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.source_ids.unwrap_or_default();
            v.push(input.into());
            self.source_ids = Some(v);
            self
        }
        /// <p>The list of identifiers of the event sources for which events are returned. If not specified, then all sources are included in the response. An identifier must begin with a letter and must contain only ASCII letters, digits, and hyphens. It can't end with a hyphen or contain two consecutive hyphens.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>If <code>SourceIds</code> are supplied, <code>SourceType</code> must also be provided.</p> </li>
        /// <li> <p>If the source type is a DB instance, a <code>DBInstanceIdentifier</code> value must be supplied.</p> </li>
        /// <li> <p>If the source type is a DB cluster, a <code>DBClusterIdentifier</code> value must be supplied.</p> </li>
        /// <li> <p>If the source type is a DB parameter group, a <code>DBParameterGroupName</code> value must be supplied.</p> </li>
        /// <li> <p>If the source type is a DB security group, a <code>DBSecurityGroupName</code> value must be supplied.</p> </li>
        /// <li> <p>If the source type is a DB snapshot, a <code>DBSnapshotIdentifier</code> value must be supplied.</p> </li>
        /// <li> <p>If the source type is a DB cluster snapshot, a <code>DBClusterSnapshotIdentifier</code> value must be supplied.</p> </li>
        /// <li> <p>If the source type is an RDS Proxy, a <code>DBProxyName</code> value must be supplied.</p> </li>
        /// </ul>
        pub fn set_source_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.source_ids = input;
            self
        }
        /// <p>A value that indicates whether to activate the subscription. If the event notification subscription isn't activated, the subscription is created but not active.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>A value that indicates whether to activate the subscription. If the event notification subscription isn't activated, the subscription is created but not active.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources</a> in the <i>Amazon RDS User Guide.</i> </p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>A list of tags. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources</a> in the <i>Amazon RDS User Guide.</i> </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateEventSubscriptionInput`](crate::input::CreateEventSubscriptionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateEventSubscriptionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateEventSubscriptionInput {
                subscription_name: self.subscription_name,
                sns_topic_arn: self.sns_topic_arn,
                source_type: self.source_type,
                event_categories: self.event_categories,
                source_ids: self.source_ids,
                enabled: self.enabled,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateEventSubscriptionInputOperationOutputAlias =
    crate::operation::CreateEventSubscription;
#[doc(hidden)]
pub type CreateEventSubscriptionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateEventSubscriptionInput {
    /// Consumes the builder and constructs an Operation<[`CreateEventSubscription`](crate::operation::CreateEventSubscription)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateEventSubscription,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateEventSubscriptionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateEventSubscriptionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_event_subscription(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateEventSubscription::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateEventSubscription",
            "rds",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateEventSubscriptionInput`](crate::input::CreateEventSubscriptionInput)
    pub fn builder() -> crate::input::create_event_subscription_input::Builder {
        crate::input::create_event_subscription_input::Builder::default()
    }
}

/// See [`CreateGlobalClusterInput`](crate::input::CreateGlobalClusterInput)
pub mod create_global_cluster_input {
    /// A builder for [`CreateGlobalClusterInput`](crate::input::CreateGlobalClusterInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) global_cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) source_db_cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) engine: std::option::Option<std::string::String>,
        pub(crate) engine_version: std::option::Option<std::string::String>,
        pub(crate) deletion_protection: std::option::Option<bool>,
        pub(crate) database_name: std::option::Option<std::string::String>,
        pub(crate) storage_encrypted: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The cluster identifier of the new global database cluster.</p>
        pub fn global_cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.global_cluster_identifier = Some(input.into());
            self
        }
        /// <p>The cluster identifier of the new global database cluster.</p>
        pub fn set_global_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.global_cluster_identifier = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) to use as the primary cluster of the global database. This parameter is optional.</p>
        pub fn source_db_cluster_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.source_db_cluster_identifier = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) to use as the primary cluster of the global database. This parameter is optional.</p>
        pub fn set_source_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_db_cluster_identifier = input;
            self
        }
        /// <p>The name of the database engine to be used for this DB cluster.</p>
        pub fn engine(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine = Some(input.into());
            self
        }
        /// <p>The name of the database engine to be used for this DB cluster.</p>
        pub fn set_engine(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.engine = input;
            self
        }
        /// <p>The engine version of the Aurora global database.</p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_version = Some(input.into());
            self
        }
        /// <p>The engine version of the Aurora global database.</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.engine_version = input;
            self
        }
        /// <p>The deletion protection setting for the new global database. The global database can't be deleted when deletion protection is enabled.</p>
        pub fn deletion_protection(mut self, input: bool) -> Self {
            self.deletion_protection = Some(input);
            self
        }
        /// <p>The deletion protection setting for the new global database. The global database can't be deleted when deletion protection is enabled.</p>
        pub fn set_deletion_protection(mut self, input: std::option::Option<bool>) -> Self {
            self.deletion_protection = input;
            self
        }
        /// <p>The name for your database of up to 64 alpha-numeric characters. If you do not provide a name, Amazon Aurora will not create a database in the global database cluster you are creating.</p>
        pub fn database_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.database_name = Some(input.into());
            self
        }
        /// <p>The name for your database of up to 64 alpha-numeric characters. If you do not provide a name, Amazon Aurora will not create a database in the global database cluster you are creating.</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.database_name = input;
            self
        }
        /// <p>The storage encryption setting for the new global database cluster.</p>
        pub fn storage_encrypted(mut self, input: bool) -> Self {
            self.storage_encrypted = Some(input);
            self
        }
        /// <p>The storage encryption setting for the new global database cluster.</p>
        pub fn set_storage_encrypted(mut self, input: std::option::Option<bool>) -> Self {
            self.storage_encrypted = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateGlobalClusterInput`](crate::input::CreateGlobalClusterInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateGlobalClusterInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateGlobalClusterInput {
                global_cluster_identifier: self.global_cluster_identifier,
                source_db_cluster_identifier: self.source_db_cluster_identifier,
                engine: self.engine,
                engine_version: self.engine_version,
                deletion_protection: self.deletion_protection,
                database_name: self.database_name,
                storage_encrypted: self.storage_encrypted,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateGlobalClusterInputOperationOutputAlias = crate::operation::CreateGlobalCluster;
#[doc(hidden)]
pub type CreateGlobalClusterInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateGlobalClusterInput {
    /// Consumes the builder and constructs an Operation<[`CreateGlobalCluster`](crate::operation::CreateGlobalCluster)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateGlobalCluster,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateGlobalClusterInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateGlobalClusterInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_global_cluster(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateGlobalCluster::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateGlobalCluster",
            "rds",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateGlobalClusterInput`](crate::input::CreateGlobalClusterInput)
    pub fn builder() -> crate::input::create_global_cluster_input::Builder {
        crate::input::create_global_cluster_input::Builder::default()
    }
}

/// See [`CreateOptionGroupInput`](crate::input::CreateOptionGroupInput)
pub mod create_option_group_input {
    /// A builder for [`CreateOptionGroupInput`](crate::input::CreateOptionGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) option_group_name: std::option::Option<std::string::String>,
        pub(crate) engine_name: std::option::Option<std::string::String>,
        pub(crate) major_engine_version: std::option::Option<std::string::String>,
        pub(crate) option_group_description: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>Specifies the name of the option group to be created.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be 1 to 255 letters, numbers, or hyphens</p> </li>
        /// <li> <p>First character must be a letter</p> </li>
        /// <li> <p>Can't end with a hyphen or contain two consecutive hyphens</p> </li>
        /// </ul>
        /// <p>Example: <code>myoptiongroup</code> </p>
        pub fn option_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.option_group_name = Some(input.into());
            self
        }
        /// <p>Specifies the name of the option group to be created.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be 1 to 255 letters, numbers, or hyphens</p> </li>
        /// <li> <p>First character must be a letter</p> </li>
        /// <li> <p>Can't end with a hyphen or contain two consecutive hyphens</p> </li>
        /// </ul>
        /// <p>Example: <code>myoptiongroup</code> </p>
        pub fn set_option_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.option_group_name = input;
            self
        }
        /// <p>Specifies the name of the engine that this option group should be associated with.</p>
        /// <p>Valid Values:</p>
        /// <ul>
        /// <li> <p> <code>mariadb</code> </p> </li>
        /// <li> <p> <code>mysql</code> </p> </li>
        /// <li> <p> <code>oracle-ee</code> </p> </li>
        /// <li> <p> <code>oracle-ee-cdb</code> </p> </li>
        /// <li> <p> <code>oracle-se2</code> </p> </li>
        /// <li> <p> <code>oracle-se2-cdb</code> </p> </li>
        /// <li> <p> <code>postgres</code> </p> </li>
        /// <li> <p> <code>sqlserver-ee</code> </p> </li>
        /// <li> <p> <code>sqlserver-se</code> </p> </li>
        /// <li> <p> <code>sqlserver-ex</code> </p> </li>
        /// <li> <p> <code>sqlserver-web</code> </p> </li>
        /// </ul>
        pub fn engine_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_name = Some(input.into());
            self
        }
        /// <p>Specifies the name of the engine that this option group should be associated with.</p>
        /// <p>Valid Values:</p>
        /// <ul>
        /// <li> <p> <code>mariadb</code> </p> </li>
        /// <li> <p> <code>mysql</code> </p> </li>
        /// <li> <p> <code>oracle-ee</code> </p> </li>
        /// <li> <p> <code>oracle-ee-cdb</code> </p> </li>
        /// <li> <p> <code>oracle-se2</code> </p> </li>
        /// <li> <p> <code>oracle-se2-cdb</code> </p> </li>
        /// <li> <p> <code>postgres</code> </p> </li>
        /// <li> <p> <code>sqlserver-ee</code> </p> </li>
        /// <li> <p> <code>sqlserver-se</code> </p> </li>
        /// <li> <p> <code>sqlserver-ex</code> </p> </li>
        /// <li> <p> <code>sqlserver-web</code> </p> </li>
        /// </ul>
        pub fn set_engine_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.engine_name = input;
            self
        }
        /// <p>Specifies the major version of the engine that this option group should be associated with.</p>
        pub fn major_engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.major_engine_version = Some(input.into());
            self
        }
        /// <p>Specifies the major version of the engine that this option group should be associated with.</p>
        pub fn set_major_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.major_engine_version = input;
            self
        }
        /// <p>The description of the option group.</p>
        pub fn option_group_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.option_group_description = Some(input.into());
            self
        }
        /// <p>The description of the option group.</p>
        pub fn set_option_group_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.option_group_description = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags to assign to the option group.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>Tags to assign to the option group.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateOptionGroupInput`](crate::input::CreateOptionGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateOptionGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateOptionGroupInput {
                option_group_name: self.option_group_name,
                engine_name: self.engine_name,
                major_engine_version: self.major_engine_version,
                option_group_description: self.option_group_description,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateOptionGroupInputOperationOutputAlias = crate::operation::CreateOptionGroup;
#[doc(hidden)]
pub type CreateOptionGroupInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateOptionGroupInput {
    /// Consumes the builder and constructs an Operation<[`CreateOptionGroup`](crate::operation::CreateOptionGroup)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateOptionGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateOptionGroupInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateOptionGroupInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_option_group(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateOptionGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateOptionGroup",
            "rds",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateOptionGroupInput`](crate::input::CreateOptionGroupInput)
    pub fn builder() -> crate::input::create_option_group_input::Builder {
        crate::input::create_option_group_input::Builder::default()
    }
}

/// See [`DeleteCustomDbEngineVersionInput`](crate::input::DeleteCustomDbEngineVersionInput)
pub mod delete_custom_db_engine_version_input {
    /// A builder for [`DeleteCustomDbEngineVersionInput`](crate::input::DeleteCustomDbEngineVersionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) engine: std::option::Option<std::string::String>,
        pub(crate) engine_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The database engine. The only supported engine is <code>custom-oracle-ee</code>.</p>
        pub fn engine(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine = Some(input.into());
            self
        }
        /// <p>The database engine. The only supported engine is <code>custom-oracle-ee</code>.</p>
        pub fn set_engine(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.engine = input;
            self
        }
        /// <p>The custom engine version (CEV) for your DB instance. This option is required for RDS Custom, but optional for Amazon RDS. The combination of <code>Engine</code> and <code>EngineVersion</code> is unique per customer per Amazon Web Services Region.</p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_version = Some(input.into());
            self
        }
        /// <p>The custom engine version (CEV) for your DB instance. This option is required for RDS Custom, but optional for Amazon RDS. The combination of <code>Engine</code> and <code>EngineVersion</code> is unique per customer per Amazon Web Services Region.</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.engine_version = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteCustomDbEngineVersionInput`](crate::input::DeleteCustomDbEngineVersionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteCustomDbEngineVersionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteCustomDbEngineVersionInput {
                engine: self.engine,
                engine_version: self.engine_version,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteCustomDbEngineVersionInputOperationOutputAlias =
    crate::operation::DeleteCustomDBEngineVersion;
#[doc(hidden)]
pub type DeleteCustomDbEngineVersionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteCustomDbEngineVersionInput {
    /// Consumes the builder and constructs an Operation<[`DeleteCustomDBEngineVersion`](crate::operation::DeleteCustomDBEngineVersion)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteCustomDBEngineVersion,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteCustomDbEngineVersionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteCustomDbEngineVersionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_custom_db_engine_version(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteCustomDBEngineVersion::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteCustomDBEngineVersion",
            "rds",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteCustomDbEngineVersionInput`](crate::input::DeleteCustomDbEngineVersionInput)
    pub fn builder() -> crate::input::delete_custom_db_engine_version_input::Builder {
        crate::input::delete_custom_db_engine_version_input::Builder::default()
    }
}

/// See [`DeleteDbClusterInput`](crate::input::DeleteDbClusterInput)
pub mod delete_db_cluster_input {
    /// A builder for [`DeleteDbClusterInput`](crate::input::DeleteDbClusterInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) skip_final_snapshot: std::option::Option<bool>,
        pub(crate) final_db_snapshot_identifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The DB cluster identifier for the DB cluster to be deleted. This parameter isn't case-sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must match an existing DBClusterIdentifier.</p> </li>
        /// </ul>
        pub fn db_cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_cluster_identifier = Some(input.into());
            self
        }
        /// <p>The DB cluster identifier for the DB cluster to be deleted. This parameter isn't case-sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must match an existing DBClusterIdentifier.</p> </li>
        /// </ul>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_identifier = input;
            self
        }
        /// <p>A value that indicates whether to skip the creation of a final DB cluster snapshot before the DB cluster is deleted. If skip is specified, no DB cluster snapshot is created. If skip isn't specified, a DB cluster snapshot is created before the DB cluster is deleted. By default, skip isn't specified, and the DB cluster snapshot is created. By default, this parameter is disabled.</p> <note>
        /// <p>You must specify a <code>FinalDBSnapshotIdentifier</code> parameter if <code>SkipFinalSnapshot</code> is disabled.</p>
        /// </note>
        pub fn skip_final_snapshot(mut self, input: bool) -> Self {
            self.skip_final_snapshot = Some(input);
            self
        }
        /// <p>A value that indicates whether to skip the creation of a final DB cluster snapshot before the DB cluster is deleted. If skip is specified, no DB cluster snapshot is created. If skip isn't specified, a DB cluster snapshot is created before the DB cluster is deleted. By default, skip isn't specified, and the DB cluster snapshot is created. By default, this parameter is disabled.</p> <note>
        /// <p>You must specify a <code>FinalDBSnapshotIdentifier</code> parameter if <code>SkipFinalSnapshot</code> is disabled.</p>
        /// </note>
        pub fn set_skip_final_snapshot(mut self, input: std::option::Option<bool>) -> Self {
            self.skip_final_snapshot = input;
            self
        }
        /// <p>The DB cluster snapshot identifier of the new DB cluster snapshot created when <code>SkipFinalSnapshot</code> is disabled.</p> <note>
        /// <p>Specifying this parameter and also skipping the creation of a final DB cluster snapshot with the <code>SkipFinalShapshot</code> parameter results in an error.</p>
        /// </note>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be 1 to 255 letters, numbers, or hyphens.</p> </li>
        /// <li> <p>First character must be a letter</p> </li>
        /// <li> <p>Can't end with a hyphen or contain two consecutive hyphens</p> </li>
        /// </ul>
        pub fn final_db_snapshot_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.final_db_snapshot_identifier = Some(input.into());
            self
        }
        /// <p>The DB cluster snapshot identifier of the new DB cluster snapshot created when <code>SkipFinalSnapshot</code> is disabled.</p> <note>
        /// <p>Specifying this parameter and also skipping the creation of a final DB cluster snapshot with the <code>SkipFinalShapshot</code> parameter results in an error.</p>
        /// </note>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be 1 to 255 letters, numbers, or hyphens.</p> </li>
        /// <li> <p>First character must be a letter</p> </li>
        /// <li> <p>Can't end with a hyphen or contain two consecutive hyphens</p> </li>
        /// </ul>
        pub fn set_final_db_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.final_db_snapshot_identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDbClusterInput`](crate::input::DeleteDbClusterInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteDbClusterInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteDbClusterInput {
                db_cluster_identifier: self.db_cluster_identifier,
                skip_final_snapshot: self.skip_final_snapshot.unwrap_or_default(),
                final_db_snapshot_identifier: self.final_db_snapshot_identifier,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteDbClusterInputOperationOutputAlias = crate::operation::DeleteDBCluster;
#[doc(hidden)]
pub type DeleteDbClusterInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteDbClusterInput {
    /// Consumes the builder and constructs an Operation<[`DeleteDBCluster`](crate::operation::DeleteDBCluster)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteDBCluster,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteDbClusterInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteDbClusterInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_db_cluster(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteDBCluster::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteDBCluster",
            "rds",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteDbClusterInput`](crate::input::DeleteDbClusterInput)
    pub fn builder() -> crate::input::delete_db_cluster_input::Builder {
        crate::input::delete_db_cluster_input::Builder::default()
    }
}

/// See [`DeleteDbClusterEndpointInput`](crate::input::DeleteDbClusterEndpointInput)
pub mod delete_db_cluster_endpoint_input {
    /// A builder for [`DeleteDbClusterEndpointInput`](crate::input::DeleteDbClusterEndpointInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster_endpoint_identifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier associated with the custom endpoint. This parameter is stored as a lowercase string.</p>
        pub fn db_cluster_endpoint_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.db_cluster_endpoint_identifier = Some(input.into());
            self
        }
        /// <p>The identifier associated with the custom endpoint. This parameter is stored as a lowercase string.</p>
        pub fn set_db_cluster_endpoint_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_endpoint_identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDbClusterEndpointInput`](crate::input::DeleteDbClusterEndpointInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteDbClusterEndpointInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteDbClusterEndpointInput {
                db_cluster_endpoint_identifier: self.db_cluster_endpoint_identifier,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteDbClusterEndpointInputOperationOutputAlias =
    crate::operation::DeleteDBClusterEndpoint;
#[doc(hidden)]
pub type DeleteDbClusterEndpointInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteDbClusterEndpointInput {
    /// Consumes the builder and constructs an Operation<[`DeleteDBClusterEndpoint`](crate::operation::DeleteDBClusterEndpoint)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteDBClusterEndpoint,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteDbClusterEndpointInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteDbClusterEndpointInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_db_cluster_endpoint(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteDBClusterEndpoint::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteDBClusterEndpoint",
            "rds",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteDbClusterEndpointInput`](crate::input::DeleteDbClusterEndpointInput)
    pub fn builder() -> crate::input::delete_db_cluster_endpoint_input::Builder {
        crate::input::delete_db_cluster_endpoint_input::Builder::default()
    }
}

/// See [`DeleteDbClusterParameterGroupInput`](crate::input::DeleteDbClusterParameterGroupInput)
pub mod delete_db_cluster_parameter_group_input {
    /// A builder for [`DeleteDbClusterParameterGroupInput`](crate::input::DeleteDbClusterParameterGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster_parameter_group_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the DB cluster parameter group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be the name of an existing DB cluster parameter group.</p> </li>
        /// <li> <p>You can't delete a default DB cluster parameter group.</p> </li>
        /// <li> <p>Can't be associated with any DB clusters.</p> </li>
        /// </ul>
        pub fn db_cluster_parameter_group_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.db_cluster_parameter_group_name = Some(input.into());
            self
        }
        /// <p>The name of the DB cluster parameter group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be the name of an existing DB cluster parameter group.</p> </li>
        /// <li> <p>You can't delete a default DB cluster parameter group.</p> </li>
        /// <li> <p>Can't be associated with any DB clusters.</p> </li>
        /// </ul>
        pub fn set_db_cluster_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_parameter_group_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDbClusterParameterGroupInput`](crate::input::DeleteDbClusterParameterGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteDbClusterParameterGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteDbClusterParameterGroupInput {
                db_cluster_parameter_group_name: self.db_cluster_parameter_group_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteDbClusterParameterGroupInputOperationOutputAlias =
    crate::operation::DeleteDBClusterParameterGroup;
#[doc(hidden)]
pub type DeleteDbClusterParameterGroupInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DeleteDbClusterParameterGroupInput {
    /// Consumes the builder and constructs an Operation<[`DeleteDBClusterParameterGroup`](crate::operation::DeleteDBClusterParameterGroup)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteDBClusterParameterGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteDbClusterParameterGroupInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteDbClusterParameterGroupInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_db_cluster_parameter_group(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteDBClusterParameterGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteDBClusterParameterGroup",
            "rds",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteDbClusterParameterGroupInput`](crate::input::DeleteDbClusterParameterGroupInput)
    pub fn builder() -> crate::input::delete_db_cluster_parameter_group_input::Builder {
        crate::input::delete_db_cluster_parameter_group_input::Builder::default()
    }
}

/// See [`DeleteDbClusterSnapshotInput`](crate::input::DeleteDbClusterSnapshotInput)
pub mod delete_db_cluster_snapshot_input {
    /// A builder for [`DeleteDbClusterSnapshotInput`](crate::input::DeleteDbClusterSnapshotInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster_snapshot_identifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the DB cluster snapshot to delete.</p>
        /// <p>Constraints: Must be the name of an existing DB cluster snapshot in the <code>available</code> state.</p>
        pub fn db_cluster_snapshot_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.db_cluster_snapshot_identifier = Some(input.into());
            self
        }
        /// <p>The identifier of the DB cluster snapshot to delete.</p>
        /// <p>Constraints: Must be the name of an existing DB cluster snapshot in the <code>available</code> state.</p>
        pub fn set_db_cluster_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_snapshot_identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDbClusterSnapshotInput`](crate::input::DeleteDbClusterSnapshotInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteDbClusterSnapshotInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteDbClusterSnapshotInput {
                db_cluster_snapshot_identifier: self.db_cluster_snapshot_identifier,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteDbClusterSnapshotInputOperationOutputAlias =
    crate::operation::DeleteDBClusterSnapshot;
#[doc(hidden)]
pub type DeleteDbClusterSnapshotInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteDbClusterSnapshotInput {
    /// Consumes the builder and constructs an Operation<[`DeleteDBClusterSnapshot`](crate::operation::DeleteDBClusterSnapshot)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteDBClusterSnapshot,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteDbClusterSnapshotInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteDbClusterSnapshotInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_db_cluster_snapshot(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteDBClusterSnapshot::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteDBClusterSnapshot",
            "rds",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteDbClusterSnapshotInput`](crate::input::DeleteDbClusterSnapshotInput)
    pub fn builder() -> crate::input::delete_db_cluster_snapshot_input::Builder {
        crate::input::delete_db_cluster_snapshot_input::Builder::default()
    }
}

/// See [`DeleteDbInstanceInput`](crate::input::DeleteDbInstanceInput)
pub mod delete_db_instance_input {
    /// A builder for [`DeleteDbInstanceInput`](crate::input::DeleteDbInstanceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_instance_identifier: std::option::Option<std::string::String>,
        pub(crate) skip_final_snapshot: std::option::Option<bool>,
        pub(crate) final_db_snapshot_identifier: std::option::Option<std::string::String>,
        pub(crate) delete_automated_backups: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The DB instance identifier for the DB instance to be deleted. This parameter isn't case-sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must match the name of an existing DB instance.</p> </li>
        /// </ul>
        pub fn db_instance_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_instance_identifier = Some(input.into());
            self
        }
        /// <p>The DB instance identifier for the DB instance to be deleted. This parameter isn't case-sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must match the name of an existing DB instance.</p> </li>
        /// </ul>
        pub fn set_db_instance_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_instance_identifier = input;
            self
        }
        /// <p>A value that indicates whether to skip the creation of a final DB snapshot before deleting the instance. If you enable this parameter, RDS doesn't create a DB snapshot. If you don't enable this parameter, RDS creates a DB snapshot before the DB instance is deleted. By default, skip isn't enabled, and the DB snapshot is created.</p> <note>
        /// <p>If you don't enable this parameter, you must specify the <code>FinalDBSnapshotIdentifier</code> parameter.</p>
        /// </note>
        /// <p>When a DB instance is in a failure state and has a status of <code>failed</code>, <code>incompatible-restore</code>, or <code>incompatible-network</code>, RDS can delete the instance only if you enable this parameter.</p>
        /// <p>If you delete a read replica or an RDS Custom instance, you must enable this setting.</p>
        /// <p>This setting is required for RDS Custom.</p>
        pub fn skip_final_snapshot(mut self, input: bool) -> Self {
            self.skip_final_snapshot = Some(input);
            self
        }
        /// <p>A value that indicates whether to skip the creation of a final DB snapshot before deleting the instance. If you enable this parameter, RDS doesn't create a DB snapshot. If you don't enable this parameter, RDS creates a DB snapshot before the DB instance is deleted. By default, skip isn't enabled, and the DB snapshot is created.</p> <note>
        /// <p>If you don't enable this parameter, you must specify the <code>FinalDBSnapshotIdentifier</code> parameter.</p>
        /// </note>
        /// <p>When a DB instance is in a failure state and has a status of <code>failed</code>, <code>incompatible-restore</code>, or <code>incompatible-network</code>, RDS can delete the instance only if you enable this parameter.</p>
        /// <p>If you delete a read replica or an RDS Custom instance, you must enable this setting.</p>
        /// <p>This setting is required for RDS Custom.</p>
        pub fn set_skip_final_snapshot(mut self, input: std::option::Option<bool>) -> Self {
            self.skip_final_snapshot = input;
            self
        }
        /// <p>The <code>DBSnapshotIdentifier</code> of the new <code>DBSnapshot</code> created when the <code>SkipFinalSnapshot</code> parameter is disabled.</p> <note>
        /// <p>If you enable this parameter and also enable SkipFinalShapshot, the command results in an error.</p>
        /// </note>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be 1 to 255 letters or numbers.</p> </li>
        /// <li> <p>First character must be a letter.</p> </li>
        /// <li> <p>Can't end with a hyphen or contain two consecutive hyphens.</p> </li>
        /// <li> <p>Can't be specified when deleting a read replica.</p> </li>
        /// </ul>
        pub fn final_db_snapshot_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.final_db_snapshot_identifier = Some(input.into());
            self
        }
        /// <p>The <code>DBSnapshotIdentifier</code> of the new <code>DBSnapshot</code> created when the <code>SkipFinalSnapshot</code> parameter is disabled.</p> <note>
        /// <p>If you enable this parameter and also enable SkipFinalShapshot, the command results in an error.</p>
        /// </note>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be 1 to 255 letters or numbers.</p> </li>
        /// <li> <p>First character must be a letter.</p> </li>
        /// <li> <p>Can't end with a hyphen or contain two consecutive hyphens.</p> </li>
        /// <li> <p>Can't be specified when deleting a read replica.</p> </li>
        /// </ul>
        pub fn set_final_db_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.final_db_snapshot_identifier = input;
            self
        }
        /// <p>A value that indicates whether to remove automated backups immediately after the DB instance is deleted. This parameter isn't case-sensitive. The default is to remove automated backups immediately after the DB instance is deleted.</p>
        pub fn delete_automated_backups(mut self, input: bool) -> Self {
            self.delete_automated_backups = Some(input);
            self
        }
        /// <p>A value that indicates whether to remove automated backups immediately after the DB instance is deleted. This parameter isn't case-sensitive. The default is to remove automated backups immediately after the DB instance is deleted.</p>
        pub fn set_delete_automated_backups(mut self, input: std::option::Option<bool>) -> Self {
            self.delete_automated_backups = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDbInstanceInput`](crate::input::DeleteDbInstanceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteDbInstanceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteDbInstanceInput {
                db_instance_identifier: self.db_instance_identifier,
                skip_final_snapshot: self.skip_final_snapshot.unwrap_or_default(),
                final_db_snapshot_identifier: self.final_db_snapshot_identifier,
                delete_automated_backups: self.delete_automated_backups,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteDbInstanceInputOperationOutputAlias = crate::operation::DeleteDBInstance;
#[doc(hidden)]
pub type DeleteDbInstanceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteDbInstanceInput {
    /// Consumes the builder and constructs an Operation<[`DeleteDBInstance`](crate::operation::DeleteDBInstance)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteDBInstance,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteDbInstanceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteDbInstanceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_db_instance(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteDBInstance::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteDBInstance",
            "rds",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteDbInstanceInput`](crate::input::DeleteDbInstanceInput)
    pub fn builder() -> crate::input::delete_db_instance_input::Builder {
        crate::input::delete_db_instance_input::Builder::default()
    }
}

/// See [`DeleteDbInstanceAutomatedBackupInput`](crate::input::DeleteDbInstanceAutomatedBackupInput)
pub mod delete_db_instance_automated_backup_input {
    /// A builder for [`DeleteDbInstanceAutomatedBackupInput`](crate::input::DeleteDbInstanceAutomatedBackupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dbi_resource_id: std::option::Option<std::string::String>,
        pub(crate) db_instance_automated_backups_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier for the source DB instance, which can't be changed and which is unique to an Amazon Web Services Region.</p>
        pub fn dbi_resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.dbi_resource_id = Some(input.into());
            self
        }
        /// <p>The identifier for the source DB instance, which can't be changed and which is unique to an Amazon Web Services Region.</p>
        pub fn set_dbi_resource_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dbi_resource_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the automated backups to delete, for example, <code>arn:aws:rds:us-east-1:123456789012:auto-backup:ab-L2IJCEXJP7XQ7HOJ4SIEXAMPLE</code>.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn db_instance_automated_backups_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.db_instance_automated_backups_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the automated backups to delete, for example, <code>arn:aws:rds:us-east-1:123456789012:auto-backup:ab-L2IJCEXJP7XQ7HOJ4SIEXAMPLE</code>.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn set_db_instance_automated_backups_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_instance_automated_backups_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDbInstanceAutomatedBackupInput`](crate::input::DeleteDbInstanceAutomatedBackupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteDbInstanceAutomatedBackupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteDbInstanceAutomatedBackupInput {
                dbi_resource_id: self.dbi_resource_id,
                db_instance_automated_backups_arn: self.db_instance_automated_backups_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteDbInstanceAutomatedBackupInputOperationOutputAlias =
    crate::operation::DeleteDBInstanceAutomatedBackup;
#[doc(hidden)]
pub type DeleteDbInstanceAutomatedBackupInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DeleteDbInstanceAutomatedBackupInput {
    /// Consumes the builder and constructs an Operation<[`DeleteDBInstanceAutomatedBackup`](crate::operation::DeleteDBInstanceAutomatedBackup)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteDBInstanceAutomatedBackup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteDbInstanceAutomatedBackupInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteDbInstanceAutomatedBackupInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_db_instance_automated_backup(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteDBInstanceAutomatedBackup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteDBInstanceAutomatedBackup",
            "rds",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteDbInstanceAutomatedBackupInput`](crate::input::DeleteDbInstanceAutomatedBackupInput)
    pub fn builder() -> crate::input::delete_db_instance_automated_backup_input::Builder {
        crate::input::delete_db_instance_automated_backup_input::Builder::default()
    }
}

/// See [`DeleteDbParameterGroupInput`](crate::input::DeleteDbParameterGroupInput)
pub mod delete_db_parameter_group_input {
    /// A builder for [`DeleteDbParameterGroupInput`](crate::input::DeleteDbParameterGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_parameter_group_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the DB parameter group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be the name of an existing DB parameter group</p> </li>
        /// <li> <p>You can't delete a default DB parameter group</p> </li>
        /// <li> <p>Can't be associated with any DB instances</p> </li>
        /// </ul>
        pub fn db_parameter_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_parameter_group_name = Some(input.into());
            self
        }
        /// <p>The name of the DB parameter group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be the name of an existing DB parameter group</p> </li>
        /// <li> <p>You can't delete a default DB parameter group</p> </li>
        /// <li> <p>Can't be associated with any DB instances</p> </li>
        /// </ul>
        pub fn set_db_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_parameter_group_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDbParameterGroupInput`](crate::input::DeleteDbParameterGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteDbParameterGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteDbParameterGroupInput {
                db_parameter_group_name: self.db_parameter_group_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteDbParameterGroupInputOperationOutputAlias = crate::operation::DeleteDBParameterGroup;
#[doc(hidden)]
pub type DeleteDbParameterGroupInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteDbParameterGroupInput {
    /// Consumes the builder and constructs an Operation<[`DeleteDBParameterGroup`](crate::operation::DeleteDBParameterGroup)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteDBParameterGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteDbParameterGroupInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteDbParameterGroupInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_db_parameter_group(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteDBParameterGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteDBParameterGroup",
            "rds",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteDbParameterGroupInput`](crate::input::DeleteDbParameterGroupInput)
    pub fn builder() -> crate::input::delete_db_parameter_group_input::Builder {
        crate::input::delete_db_parameter_group_input::Builder::default()
    }
}

/// See [`DeleteDbProxyInput`](crate::input::DeleteDbProxyInput)
pub mod delete_db_proxy_input {
    /// A builder for [`DeleteDbProxyInput`](crate::input::DeleteDbProxyInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_proxy_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the DB proxy to delete.</p>
        pub fn db_proxy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_proxy_name = Some(input.into());
            self
        }
        /// <p>The name of the DB proxy to delete.</p>
        pub fn set_db_proxy_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_proxy_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDbProxyInput`](crate::input::DeleteDbProxyInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteDbProxyInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteDbProxyInput {
                db_proxy_name: self.db_proxy_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteDbProxyInputOperationOutputAlias = crate::operation::DeleteDBProxy;
#[doc(hidden)]
pub type DeleteDbProxyInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteDbProxyInput {
    /// Consumes the builder and constructs an Operation<[`DeleteDBProxy`](crate::operation::DeleteDBProxy)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteDBProxy,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteDbProxyInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteDbProxyInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_db_proxy(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteDBProxy::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteDBProxy",
            "rds",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteDbProxyInput`](crate::input::DeleteDbProxyInput)
    pub fn builder() -> crate::input::delete_db_proxy_input::Builder {
        crate::input::delete_db_proxy_input::Builder::default()
    }
}

/// See [`DeleteDbProxyEndpointInput`](crate::input::DeleteDbProxyEndpointInput)
pub mod delete_db_proxy_endpoint_input {
    /// A builder for [`DeleteDbProxyEndpointInput`](crate::input::DeleteDbProxyEndpointInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_proxy_endpoint_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the DB proxy endpoint to delete.</p>
        pub fn db_proxy_endpoint_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_proxy_endpoint_name = Some(input.into());
            self
        }
        /// <p>The name of the DB proxy endpoint to delete.</p>
        pub fn set_db_proxy_endpoint_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_proxy_endpoint_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDbProxyEndpointInput`](crate::input::DeleteDbProxyEndpointInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteDbProxyEndpointInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteDbProxyEndpointInput {
                db_proxy_endpoint_name: self.db_proxy_endpoint_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteDbProxyEndpointInputOperationOutputAlias = crate::operation::DeleteDBProxyEndpoint;
#[doc(hidden)]
pub type DeleteDbProxyEndpointInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteDbProxyEndpointInput {
    /// Consumes the builder and constructs an Operation<[`DeleteDBProxyEndpoint`](crate::operation::DeleteDBProxyEndpoint)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteDBProxyEndpoint,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteDbProxyEndpointInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteDbProxyEndpointInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_db_proxy_endpoint(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteDBProxyEndpoint::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteDBProxyEndpoint",
            "rds",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteDbProxyEndpointInput`](crate::input::DeleteDbProxyEndpointInput)
    pub fn builder() -> crate::input::delete_db_proxy_endpoint_input::Builder {
        crate::input::delete_db_proxy_endpoint_input::Builder::default()
    }
}

/// See [`DeleteDbSecurityGroupInput`](crate::input::DeleteDbSecurityGroupInput)
pub mod delete_db_security_group_input {
    /// A builder for [`DeleteDbSecurityGroupInput`](crate::input::DeleteDbSecurityGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_security_group_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the DB security group to delete.</p> <note>
        /// <p>You can't delete the default DB security group.</p>
        /// </note>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be 1 to 255 letters, numbers, or hyphens.</p> </li>
        /// <li> <p>First character must be a letter</p> </li>
        /// <li> <p>Can't end with a hyphen or contain two consecutive hyphens</p> </li>
        /// <li> <p>Must not be "Default"</p> </li>
        /// </ul>
        pub fn db_security_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_security_group_name = Some(input.into());
            self
        }
        /// <p>The name of the DB security group to delete.</p> <note>
        /// <p>You can't delete the default DB security group.</p>
        /// </note>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be 1 to 255 letters, numbers, or hyphens.</p> </li>
        /// <li> <p>First character must be a letter</p> </li>
        /// <li> <p>Can't end with a hyphen or contain two consecutive hyphens</p> </li>
        /// <li> <p>Must not be "Default"</p> </li>
        /// </ul>
        pub fn set_db_security_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_security_group_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDbSecurityGroupInput`](crate::input::DeleteDbSecurityGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteDbSecurityGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteDbSecurityGroupInput {
                db_security_group_name: self.db_security_group_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteDbSecurityGroupInputOperationOutputAlias = crate::operation::DeleteDBSecurityGroup;
#[doc(hidden)]
pub type DeleteDbSecurityGroupInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteDbSecurityGroupInput {
    /// Consumes the builder and constructs an Operation<[`DeleteDBSecurityGroup`](crate::operation::DeleteDBSecurityGroup)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteDBSecurityGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteDbSecurityGroupInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteDbSecurityGroupInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_db_security_group(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteDBSecurityGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteDBSecurityGroup",
            "rds",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteDbSecurityGroupInput`](crate::input::DeleteDbSecurityGroupInput)
    pub fn builder() -> crate::input::delete_db_security_group_input::Builder {
        crate::input::delete_db_security_group_input::Builder::default()
    }
}

/// See [`DeleteDbSnapshotInput`](crate::input::DeleteDbSnapshotInput)
pub mod delete_db_snapshot_input {
    /// A builder for [`DeleteDbSnapshotInput`](crate::input::DeleteDbSnapshotInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_snapshot_identifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The DB snapshot identifier.</p>
        /// <p>Constraints: Must be the name of an existing DB snapshot in the <code>available</code> state.</p>
        pub fn db_snapshot_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_snapshot_identifier = Some(input.into());
            self
        }
        /// <p>The DB snapshot identifier.</p>
        /// <p>Constraints: Must be the name of an existing DB snapshot in the <code>available</code> state.</p>
        pub fn set_db_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_snapshot_identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDbSnapshotInput`](crate::input::DeleteDbSnapshotInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteDbSnapshotInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteDbSnapshotInput {
                db_snapshot_identifier: self.db_snapshot_identifier,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteDbSnapshotInputOperationOutputAlias = crate::operation::DeleteDBSnapshot;
#[doc(hidden)]
pub type DeleteDbSnapshotInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteDbSnapshotInput {
    /// Consumes the builder and constructs an Operation<[`DeleteDBSnapshot`](crate::operation::DeleteDBSnapshot)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteDBSnapshot,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteDbSnapshotInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteDbSnapshotInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_db_snapshot(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteDBSnapshot::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteDBSnapshot",
            "rds",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteDbSnapshotInput`](crate::input::DeleteDbSnapshotInput)
    pub fn builder() -> crate::input::delete_db_snapshot_input::Builder {
        crate::input::delete_db_snapshot_input::Builder::default()
    }
}

/// See [`DeleteDbSubnetGroupInput`](crate::input::DeleteDbSubnetGroupInput)
pub mod delete_db_subnet_group_input {
    /// A builder for [`DeleteDbSubnetGroupInput`](crate::input::DeleteDbSubnetGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_subnet_group_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the database subnet group to delete.</p> <note>
        /// <p>You can't delete the default subnet group.</p>
        /// </note>
        /// <p>Constraints: Must match the name of an existing DBSubnetGroup. Must not be default.</p>
        /// <p>Example: <code>mydbsubnetgroup</code> </p>
        pub fn db_subnet_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_subnet_group_name = Some(input.into());
            self
        }
        /// <p>The name of the database subnet group to delete.</p> <note>
        /// <p>You can't delete the default subnet group.</p>
        /// </note>
        /// <p>Constraints: Must match the name of an existing DBSubnetGroup. Must not be default.</p>
        /// <p>Example: <code>mydbsubnetgroup</code> </p>
        pub fn set_db_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_subnet_group_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDbSubnetGroupInput`](crate::input::DeleteDbSubnetGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteDbSubnetGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteDbSubnetGroupInput {
                db_subnet_group_name: self.db_subnet_group_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteDbSubnetGroupInputOperationOutputAlias = crate::operation::DeleteDBSubnetGroup;
#[doc(hidden)]
pub type DeleteDbSubnetGroupInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteDbSubnetGroupInput {
    /// Consumes the builder and constructs an Operation<[`DeleteDBSubnetGroup`](crate::operation::DeleteDBSubnetGroup)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteDBSubnetGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteDbSubnetGroupInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteDbSubnetGroupInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_db_subnet_group(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteDBSubnetGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteDBSubnetGroup",
            "rds",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteDbSubnetGroupInput`](crate::input::DeleteDbSubnetGroupInput)
    pub fn builder() -> crate::input::delete_db_subnet_group_input::Builder {
        crate::input::delete_db_subnet_group_input::Builder::default()
    }
}

/// See [`DeleteEventSubscriptionInput`](crate::input::DeleteEventSubscriptionInput)
pub mod delete_event_subscription_input {
    /// A builder for [`DeleteEventSubscriptionInput`](crate::input::DeleteEventSubscriptionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) subscription_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the RDS event notification subscription you want to delete.</p>
        pub fn subscription_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.subscription_name = Some(input.into());
            self
        }
        /// <p>The name of the RDS event notification subscription you want to delete.</p>
        pub fn set_subscription_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.subscription_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteEventSubscriptionInput`](crate::input::DeleteEventSubscriptionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteEventSubscriptionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteEventSubscriptionInput {
                subscription_name: self.subscription_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteEventSubscriptionInputOperationOutputAlias =
    crate::operation::DeleteEventSubscription;
#[doc(hidden)]
pub type DeleteEventSubscriptionInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteEventSubscriptionInput {
    /// Consumes the builder and constructs an Operation<[`DeleteEventSubscription`](crate::operation::DeleteEventSubscription)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteEventSubscription,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteEventSubscriptionInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteEventSubscriptionInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_event_subscription(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteEventSubscription::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteEventSubscription",
            "rds",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteEventSubscriptionInput`](crate::input::DeleteEventSubscriptionInput)
    pub fn builder() -> crate::input::delete_event_subscription_input::Builder {
        crate::input::delete_event_subscription_input::Builder::default()
    }
}

/// See [`DeleteGlobalClusterInput`](crate::input::DeleteGlobalClusterInput)
pub mod delete_global_cluster_input {
    /// A builder for [`DeleteGlobalClusterInput`](crate::input::DeleteGlobalClusterInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) global_cluster_identifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The cluster identifier of the global database cluster being deleted.</p>
        pub fn global_cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.global_cluster_identifier = Some(input.into());
            self
        }
        /// <p>The cluster identifier of the global database cluster being deleted.</p>
        pub fn set_global_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.global_cluster_identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteGlobalClusterInput`](crate::input::DeleteGlobalClusterInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteGlobalClusterInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteGlobalClusterInput {
                global_cluster_identifier: self.global_cluster_identifier,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteGlobalClusterInputOperationOutputAlias = crate::operation::DeleteGlobalCluster;
#[doc(hidden)]
pub type DeleteGlobalClusterInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteGlobalClusterInput {
    /// Consumes the builder and constructs an Operation<[`DeleteGlobalCluster`](crate::operation::DeleteGlobalCluster)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteGlobalCluster,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteGlobalClusterInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteGlobalClusterInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_global_cluster(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteGlobalCluster::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteGlobalCluster",
            "rds",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteGlobalClusterInput`](crate::input::DeleteGlobalClusterInput)
    pub fn builder() -> crate::input::delete_global_cluster_input::Builder {
        crate::input::delete_global_cluster_input::Builder::default()
    }
}

/// See [`DeleteOptionGroupInput`](crate::input::DeleteOptionGroupInput)
pub mod delete_option_group_input {
    /// A builder for [`DeleteOptionGroupInput`](crate::input::DeleteOptionGroupInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) option_group_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the option group to be deleted.</p> <note>
        /// <p>You can't delete default option groups.</p>
        /// </note>
        pub fn option_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.option_group_name = Some(input.into());
            self
        }
        /// <p>The name of the option group to be deleted.</p> <note>
        /// <p>You can't delete default option groups.</p>
        /// </note>
        pub fn set_option_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.option_group_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteOptionGroupInput`](crate::input::DeleteOptionGroupInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteOptionGroupInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteOptionGroupInput {
                option_group_name: self.option_group_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteOptionGroupInputOperationOutputAlias = crate::operation::DeleteOptionGroup;
#[doc(hidden)]
pub type DeleteOptionGroupInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteOptionGroupInput {
    /// Consumes the builder and constructs an Operation<[`DeleteOptionGroup`](crate::operation::DeleteOptionGroup)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteOptionGroup,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteOptionGroupInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteOptionGroupInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_delete_option_group(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteOptionGroup::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteOptionGroup",
            "rds",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteOptionGroupInput`](crate::input::DeleteOptionGroupInput)
    pub fn builder() -> crate::input::delete_option_group_input::Builder {
        crate::input::delete_option_group_input::Builder::default()
    }
}

/// See [`DeregisterDbProxyTargetsInput`](crate::input::DeregisterDbProxyTargetsInput)
pub mod deregister_db_proxy_targets_input {
    /// A builder for [`DeregisterDbProxyTargetsInput`](crate::input::DeregisterDbProxyTargetsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_proxy_name: std::option::Option<std::string::String>,
        pub(crate) target_group_name: std::option::Option<std::string::String>,
        pub(crate) db_instance_identifiers: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) db_cluster_identifiers: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The identifier of the <code>DBProxy</code> that is associated with the <code>DBProxyTargetGroup</code>.</p>
        pub fn db_proxy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_proxy_name = Some(input.into());
            self
        }
        /// <p>The identifier of the <code>DBProxy</code> that is associated with the <code>DBProxyTargetGroup</code>.</p>
        pub fn set_db_proxy_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_proxy_name = input;
            self
        }
        /// <p>The identifier of the <code>DBProxyTargetGroup</code>.</p>
        pub fn target_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_group_name = Some(input.into());
            self
        }
        /// <p>The identifier of the <code>DBProxyTargetGroup</code>.</p>
        pub fn set_target_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_group_name = input;
            self
        }
        /// Appends an item to `db_instance_identifiers`.
        ///
        /// To override the contents of this collection use [`set_db_instance_identifiers`](Self::set_db_instance_identifiers).
        ///
        /// <p>One or more DB instance identifiers.</p>
        pub fn db_instance_identifiers(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.db_instance_identifiers.unwrap_or_default();
            v.push(input.into());
            self.db_instance_identifiers = Some(v);
            self
        }
        /// <p>One or more DB instance identifiers.</p>
        pub fn set_db_instance_identifiers(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.db_instance_identifiers = input;
            self
        }
        /// Appends an item to `db_cluster_identifiers`.
        ///
        /// To override the contents of this collection use [`set_db_cluster_identifiers`](Self::set_db_cluster_identifiers).
        ///
        /// <p>One or more DB cluster identifiers.</p>
        pub fn db_cluster_identifiers(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.db_cluster_identifiers.unwrap_or_default();
            v.push(input.into());
            self.db_cluster_identifiers = Some(v);
            self
        }
        /// <p>One or more DB cluster identifiers.</p>
        pub fn set_db_cluster_identifiers(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.db_cluster_identifiers = input;
            self
        }
        /// Consumes the builder and constructs a [`DeregisterDbProxyTargetsInput`](crate::input::DeregisterDbProxyTargetsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeregisterDbProxyTargetsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeregisterDbProxyTargetsInput {
                db_proxy_name: self.db_proxy_name,
                target_group_name: self.target_group_name,
                db_instance_identifiers: self.db_instance_identifiers,
                db_cluster_identifiers: self.db_cluster_identifiers,
            })
        }
    }
}
#[doc(hidden)]
pub type DeregisterDbProxyTargetsInputOperationOutputAlias =
    crate::operation::DeregisterDBProxyTargets;
#[doc(hidden)]
pub type DeregisterDbProxyTargetsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeregisterDbProxyTargetsInput {
    /// Consumes the builder and constructs an Operation<[`DeregisterDBProxyTargets`](crate::operation::DeregisterDBProxyTargets)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeregisterDBProxyTargets,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeregisterDbProxyTargetsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeregisterDbProxyTargetsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_deregister_db_proxy_targets(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeregisterDBProxyTargets::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeregisterDBProxyTargets",
            "rds",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeregisterDbProxyTargetsInput`](crate::input::DeregisterDbProxyTargetsInput)
    pub fn builder() -> crate::input::deregister_db_proxy_targets_input::Builder {
        crate::input::deregister_db_proxy_targets_input::Builder::default()
    }
}

/// See [`DescribeAccountAttributesInput`](crate::input::DescribeAccountAttributesInput)
pub mod describe_account_attributes_input {
    /// A builder for [`DescribeAccountAttributesInput`](crate::input::DescribeAccountAttributesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DescribeAccountAttributesInput`](crate::input::DescribeAccountAttributesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeAccountAttributesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeAccountAttributesInput {})
        }
    }
}
#[doc(hidden)]
pub type DescribeAccountAttributesInputOperationOutputAlias =
    crate::operation::DescribeAccountAttributes;
#[doc(hidden)]
pub type DescribeAccountAttributesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeAccountAttributesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeAccountAttributes`](crate::operation::DescribeAccountAttributes)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeAccountAttributes,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeAccountAttributesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeAccountAttributesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_account_attributes(
                &self,
            )?,
        );
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeAccountAttributes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeAccountAttributes",
            "rds",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeAccountAttributesInput`](crate::input::DescribeAccountAttributesInput)
    pub fn builder() -> crate::input::describe_account_attributes_input::Builder {
        crate::input::describe_account_attributes_input::Builder::default()
    }
}

/// See [`DescribeCertificatesInput`](crate::input::DescribeCertificatesInput)
pub mod describe_certificates_input {
    /// A builder for [`DescribeCertificatesInput`](crate::input::DescribeCertificatesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) certificate_identifier: std::option::Option<std::string::String>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The user-supplied certificate identifier. If this parameter is specified, information for only the identified certificate is returned. This parameter isn't case-sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must match an existing CertificateIdentifier.</p> </li>
        /// </ul>
        pub fn certificate_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.certificate_identifier = Some(input.into());
            self
        }
        /// <p>The user-supplied certificate identifier. If this parameter is specified, information for only the identified certificate is returned. This parameter isn't case-sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must match an existing CertificateIdentifier.</p> </li>
        /// </ul>
        pub fn set_certificate_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.certificate_identifier = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>This parameter isn't currently supported.</p>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input);
            self.filters = Some(v);
            self
        }
        /// <p>This parameter isn't currently supported.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so you can retrieve the remaining results.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so you can retrieve the remaining results.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p>An optional pagination token provided by a previous <code>DescribeCertificates</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An optional pagination token provided by a previous <code>DescribeCertificates</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeCertificatesInput`](crate::input::DescribeCertificatesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeCertificatesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeCertificatesInput {
                certificate_identifier: self.certificate_identifier,
                filters: self.filters,
                max_records: self.max_records,
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeCertificatesInputOperationOutputAlias = crate::operation::DescribeCertificates;
#[doc(hidden)]
pub type DescribeCertificatesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeCertificatesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeCertificates`](crate::operation::DescribeCertificates)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeCertificates,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeCertificatesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeCertificatesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_certificates(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeCertificates::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeCertificates",
            "rds",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeCertificatesInput`](crate::input::DescribeCertificatesInput)
    pub fn builder() -> crate::input::describe_certificates_input::Builder {
        crate::input::describe_certificates_input::Builder::default()
    }
}

/// See [`DescribeDbClusterBacktracksInput`](crate::input::DescribeDbClusterBacktracksInput)
pub mod describe_db_cluster_backtracks_input {
    /// A builder for [`DescribeDbClusterBacktracksInput`](crate::input::DescribeDbClusterBacktracksInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) backtrack_identifier: std::option::Option<std::string::String>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The DB cluster identifier of the DB cluster to be described. This parameter is stored as a lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must contain from 1 to 63 alphanumeric characters or hyphens.</p> </li>
        /// <li> <p>First character must be a letter.</p> </li>
        /// <li> <p>Can't end with a hyphen or contain two consecutive hyphens.</p> </li>
        /// </ul>
        /// <p>Example: <code>my-cluster1</code> </p>
        pub fn db_cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_cluster_identifier = Some(input.into());
            self
        }
        /// <p>The DB cluster identifier of the DB cluster to be described. This parameter is stored as a lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must contain from 1 to 63 alphanumeric characters or hyphens.</p> </li>
        /// <li> <p>First character must be a letter.</p> </li>
        /// <li> <p>Can't end with a hyphen or contain two consecutive hyphens.</p> </li>
        /// </ul>
        /// <p>Example: <code>my-cluster1</code> </p>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_identifier = input;
            self
        }
        /// <p>If specified, this value is the backtrack identifier of the backtrack to be described.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must contain a valid universally unique identifier (UUID). For more information about UUIDs, see <a href="http://www.ietf.org/rfc/rfc4122.txt">A Universally Unique Identifier (UUID) URN Namespace</a>.</p> </li>
        /// </ul>
        /// <p>Example: <code>123e4567-e89b-12d3-a456-426655440000</code> </p>
        pub fn backtrack_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.backtrack_identifier = Some(input.into());
            self
        }
        /// <p>If specified, this value is the backtrack identifier of the backtrack to be described.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must contain a valid universally unique identifier (UUID). For more information about UUIDs, see <a href="http://www.ietf.org/rfc/rfc4122.txt">A Universally Unique Identifier (UUID) URN Namespace</a>.</p> </li>
        /// </ul>
        /// <p>Example: <code>123e4567-e89b-12d3-a456-426655440000</code> </p>
        pub fn set_backtrack_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backtrack_identifier = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>A filter that specifies one or more DB clusters to describe. Supported filters include the following:</p>
        /// <ul>
        /// <li> <p> <code>db-cluster-backtrack-id</code> - Accepts backtrack identifiers. The results list includes information about only the backtracks identified by these identifiers.</p> </li>
        /// <li> <p> <code>db-cluster-backtrack-status</code> - Accepts any of the following backtrack status values:</p>
        /// <ul>
        /// <li> <p> <code>applying</code> </p> </li>
        /// <li> <p> <code>completed</code> </p> </li>
        /// <li> <p> <code>failed</code> </p> </li>
        /// <li> <p> <code>pending</code> </p> </li>
        /// </ul> <p>The results list includes information about only the backtracks identified by these values.</p> </li>
        /// </ul>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input);
            self.filters = Some(v);
            self
        }
        /// <p>A filter that specifies one or more DB clusters to describe. Supported filters include the following:</p>
        /// <ul>
        /// <li> <p> <code>db-cluster-backtrack-id</code> - Accepts backtrack identifiers. The results list includes information about only the backtracks identified by these identifiers.</p> </li>
        /// <li> <p> <code>db-cluster-backtrack-status</code> - Accepts any of the following backtrack status values:</p>
        /// <ul>
        /// <li> <p> <code>applying</code> </p> </li>
        /// <li> <p> <code>completed</code> </p> </li>
        /// <li> <p> <code>failed</code> </p> </li>
        /// <li> <p> <code>pending</code> </p> </li>
        /// </ul> <p>The results list includes information about only the backtracks identified by these values.</p> </li>
        /// </ul>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so you can retrieve the remaining results.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so you can retrieve the remaining results.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p>An optional pagination token provided by a previous <code>DescribeDBClusterBacktracks</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An optional pagination token provided by a previous <code>DescribeDBClusterBacktracks</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDbClusterBacktracksInput`](crate::input::DescribeDbClusterBacktracksInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeDbClusterBacktracksInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeDbClusterBacktracksInput {
                db_cluster_identifier: self.db_cluster_identifier,
                backtrack_identifier: self.backtrack_identifier,
                filters: self.filters,
                max_records: self.max_records,
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeDbClusterBacktracksInputOperationOutputAlias =
    crate::operation::DescribeDBClusterBacktracks;
#[doc(hidden)]
pub type DescribeDbClusterBacktracksInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeDbClusterBacktracksInput {
    /// Consumes the builder and constructs an Operation<[`DescribeDBClusterBacktracks`](crate::operation::DescribeDBClusterBacktracks)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeDBClusterBacktracks,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeDbClusterBacktracksInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeDbClusterBacktracksInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_db_cluster_backtracks(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeDBClusterBacktracks::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeDBClusterBacktracks",
            "rds",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeDbClusterBacktracksInput`](crate::input::DescribeDbClusterBacktracksInput)
    pub fn builder() -> crate::input::describe_db_cluster_backtracks_input::Builder {
        crate::input::describe_db_cluster_backtracks_input::Builder::default()
    }
}

/// See [`DescribeDbClusterEndpointsInput`](crate::input::DescribeDbClusterEndpointsInput)
pub mod describe_db_cluster_endpoints_input {
    /// A builder for [`DescribeDbClusterEndpointsInput`](crate::input::DescribeDbClusterEndpointsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) db_cluster_endpoint_identifier: std::option::Option<std::string::String>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The DB cluster identifier of the DB cluster associated with the endpoint. This parameter is stored as a lowercase string.</p>
        pub fn db_cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_cluster_identifier = Some(input.into());
            self
        }
        /// <p>The DB cluster identifier of the DB cluster associated with the endpoint. This parameter is stored as a lowercase string.</p>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_identifier = input;
            self
        }
        /// <p>The identifier of the endpoint to describe. This parameter is stored as a lowercase string.</p>
        pub fn db_cluster_endpoint_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.db_cluster_endpoint_identifier = Some(input.into());
            self
        }
        /// <p>The identifier of the endpoint to describe. This parameter is stored as a lowercase string.</p>
        pub fn set_db_cluster_endpoint_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_endpoint_identifier = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>A set of name-value pairs that define which endpoints to include in the output. The filters are specified as name-value pairs, in the format <code>Name=<i>endpoint_type</i>,Values=<i>endpoint_type1</i>,<i>endpoint_type2</i>,...</code>. <code>Name</code> can be one of: <code>db-cluster-endpoint-type</code>, <code>db-cluster-endpoint-custom-type</code>, <code>db-cluster-endpoint-id</code>, <code>db-cluster-endpoint-status</code>. <code>Values</code> for the <code> db-cluster-endpoint-type</code> filter can be one or more of: <code>reader</code>, <code>writer</code>, <code>custom</code>. <code>Values</code> for the <code>db-cluster-endpoint-custom-type</code> filter can be one or more of: <code>reader</code>, <code>any</code>. <code>Values</code> for the <code>db-cluster-endpoint-status</code> filter can be one or more of: <code>available</code>, <code>creating</code>, <code>deleting</code>, <code>inactive</code>, <code>modifying</code>.</p>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input);
            self.filters = Some(v);
            self
        }
        /// <p>A set of name-value pairs that define which endpoints to include in the output. The filters are specified as name-value pairs, in the format <code>Name=<i>endpoint_type</i>,Values=<i>endpoint_type1</i>,<i>endpoint_type2</i>,...</code>. <code>Name</code> can be one of: <code>db-cluster-endpoint-type</code>, <code>db-cluster-endpoint-custom-type</code>, <code>db-cluster-endpoint-id</code>, <code>db-cluster-endpoint-status</code>. <code>Values</code> for the <code> db-cluster-endpoint-type</code> filter can be one or more of: <code>reader</code>, <code>writer</code>, <code>custom</code>. <code>Values</code> for the <code>db-cluster-endpoint-custom-type</code> filter can be one or more of: <code>reader</code>, <code>any</code>. <code>Values</code> for the <code>db-cluster-endpoint-status</code> filter can be one or more of: <code>available</code>, <code>creating</code>, <code>deleting</code>, <code>inactive</code>, <code>modifying</code>.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so you can retrieve the remaining results.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so you can retrieve the remaining results.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p>An optional pagination token provided by a previous <code>DescribeDBClusterEndpoints</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An optional pagination token provided by a previous <code>DescribeDBClusterEndpoints</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDbClusterEndpointsInput`](crate::input::DescribeDbClusterEndpointsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeDbClusterEndpointsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeDbClusterEndpointsInput {
                db_cluster_identifier: self.db_cluster_identifier,
                db_cluster_endpoint_identifier: self.db_cluster_endpoint_identifier,
                filters: self.filters,
                max_records: self.max_records,
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeDbClusterEndpointsInputOperationOutputAlias =
    crate::operation::DescribeDBClusterEndpoints;
#[doc(hidden)]
pub type DescribeDbClusterEndpointsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeDbClusterEndpointsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeDBClusterEndpoints`](crate::operation::DescribeDBClusterEndpoints)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeDBClusterEndpoints,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeDbClusterEndpointsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeDbClusterEndpointsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_db_cluster_endpoints(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeDBClusterEndpoints::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeDBClusterEndpoints",
            "rds",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeDbClusterEndpointsInput`](crate::input::DescribeDbClusterEndpointsInput)
    pub fn builder() -> crate::input::describe_db_cluster_endpoints_input::Builder {
        crate::input::describe_db_cluster_endpoints_input::Builder::default()
    }
}

/// See [`DescribeDbClusterParameterGroupsInput`](crate::input::DescribeDbClusterParameterGroupsInput)
pub mod describe_db_cluster_parameter_groups_input {
    /// A builder for [`DescribeDbClusterParameterGroupsInput`](crate::input::DescribeDbClusterParameterGroupsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster_parameter_group_name: std::option::Option<std::string::String>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of a specific DB cluster parameter group to return details for.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>If supplied, must match the name of an existing DBClusterParameterGroup.</p> </li>
        /// </ul>
        pub fn db_cluster_parameter_group_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.db_cluster_parameter_group_name = Some(input.into());
            self
        }
        /// <p>The name of a specific DB cluster parameter group to return details for.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>If supplied, must match the name of an existing DBClusterParameterGroup.</p> </li>
        /// </ul>
        pub fn set_db_cluster_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_parameter_group_name = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>This parameter isn't currently supported.</p>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input);
            self.filters = Some(v);
            self
        }
        /// <p>This parameter isn't currently supported.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so you can retrieve the remaining results.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so you can retrieve the remaining results.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p>An optional pagination token provided by a previous <code>DescribeDBClusterParameterGroups</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An optional pagination token provided by a previous <code>DescribeDBClusterParameterGroups</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDbClusterParameterGroupsInput`](crate::input::DescribeDbClusterParameterGroupsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeDbClusterParameterGroupsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeDbClusterParameterGroupsInput {
                db_cluster_parameter_group_name: self.db_cluster_parameter_group_name,
                filters: self.filters,
                max_records: self.max_records,
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeDbClusterParameterGroupsInputOperationOutputAlias =
    crate::operation::DescribeDBClusterParameterGroups;
#[doc(hidden)]
pub type DescribeDbClusterParameterGroupsInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeDbClusterParameterGroupsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeDBClusterParameterGroups`](crate::operation::DescribeDBClusterParameterGroups)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeDBClusterParameterGroups,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeDbClusterParameterGroupsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeDbClusterParameterGroupsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_db_cluster_parameter_groups(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeDBClusterParameterGroups::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeDBClusterParameterGroups",
            "rds",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeDbClusterParameterGroupsInput`](crate::input::DescribeDbClusterParameterGroupsInput)
    pub fn builder() -> crate::input::describe_db_cluster_parameter_groups_input::Builder {
        crate::input::describe_db_cluster_parameter_groups_input::Builder::default()
    }
}

/// See [`DescribeDbClusterParametersInput`](crate::input::DescribeDbClusterParametersInput)
pub mod describe_db_cluster_parameters_input {
    /// A builder for [`DescribeDbClusterParametersInput`](crate::input::DescribeDbClusterParametersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster_parameter_group_name: std::option::Option<std::string::String>,
        pub(crate) source: std::option::Option<std::string::String>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of a specific DB cluster parameter group to return parameter details for.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>If supplied, must match the name of an existing DBClusterParameterGroup.</p> </li>
        /// </ul>
        pub fn db_cluster_parameter_group_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.db_cluster_parameter_group_name = Some(input.into());
            self
        }
        /// <p>The name of a specific DB cluster parameter group to return parameter details for.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>If supplied, must match the name of an existing DBClusterParameterGroup.</p> </li>
        /// </ul>
        pub fn set_db_cluster_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_parameter_group_name = input;
            self
        }
        /// <p>A value that indicates to return only parameters for a specific source. Parameter sources can be <code>engine</code>, <code>service</code>, or <code>customer</code>.</p>
        pub fn source(mut self, input: impl Into<std::string::String>) -> Self {
            self.source = Some(input.into());
            self
        }
        /// <p>A value that indicates to return only parameters for a specific source. Parameter sources can be <code>engine</code>, <code>service</code>, or <code>customer</code>.</p>
        pub fn set_source(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>This parameter isn't currently supported.</p>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input);
            self.filters = Some(v);
            self
        }
        /// <p>This parameter isn't currently supported.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so you can retrieve the remaining results.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so you can retrieve the remaining results.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p>An optional pagination token provided by a previous <code>DescribeDBClusterParameters</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An optional pagination token provided by a previous <code>DescribeDBClusterParameters</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDbClusterParametersInput`](crate::input::DescribeDbClusterParametersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeDbClusterParametersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeDbClusterParametersInput {
                db_cluster_parameter_group_name: self.db_cluster_parameter_group_name,
                source: self.source,
                filters: self.filters,
                max_records: self.max_records,
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeDbClusterParametersInputOperationOutputAlias =
    crate::operation::DescribeDBClusterParameters;
#[doc(hidden)]
pub type DescribeDbClusterParametersInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeDbClusterParametersInput {
    /// Consumes the builder and constructs an Operation<[`DescribeDBClusterParameters`](crate::operation::DescribeDBClusterParameters)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeDBClusterParameters,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeDbClusterParametersInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeDbClusterParametersInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_db_cluster_parameters(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeDBClusterParameters::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeDBClusterParameters",
            "rds",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeDbClusterParametersInput`](crate::input::DescribeDbClusterParametersInput)
    pub fn builder() -> crate::input::describe_db_cluster_parameters_input::Builder {
        crate::input::describe_db_cluster_parameters_input::Builder::default()
    }
}

/// See [`DescribeDbClustersInput`](crate::input::DescribeDbClustersInput)
pub mod describe_db_clusters_input {
    /// A builder for [`DescribeDbClustersInput`](crate::input::DescribeDbClustersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) include_shared: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The user-supplied DB cluster identifier. If this parameter is specified, information from only the specific DB cluster is returned. This parameter isn't case-sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>If supplied, must match an existing DBClusterIdentifier.</p> </li>
        /// </ul>
        pub fn db_cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_cluster_identifier = Some(input.into());
            self
        }
        /// <p>The user-supplied DB cluster identifier. If this parameter is specified, information from only the specific DB cluster is returned. This parameter isn't case-sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>If supplied, must match an existing DBClusterIdentifier.</p> </li>
        /// </ul>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_identifier = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>A filter that specifies one or more DB clusters to describe.</p>
        /// <p>Supported filters:</p>
        /// <ul>
        /// <li> <p> <code>clone-group-id</code> - Accepts clone group identifiers. The results list only includes information about the DB clusters associated with these clone groups.</p> </li>
        /// <li> <p> <code>db-cluster-id</code> - Accepts DB cluster identifiers and DB cluster Amazon Resource Names (ARNs). The results list only includes information about the DB clusters identified by these ARNs.</p> </li>
        /// <li> <p> <code>domain</code> - Accepts Active Directory directory IDs. The results list only includes information about the DB clusters associated with these domains.</p> </li>
        /// <li> <p> <code>engine</code> - Accepts engine names. The results list only includes information about the DB clusters for these engines.</p> </li>
        /// </ul>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input);
            self.filters = Some(v);
            self
        }
        /// <p>A filter that specifies one or more DB clusters to describe.</p>
        /// <p>Supported filters:</p>
        /// <ul>
        /// <li> <p> <code>clone-group-id</code> - Accepts clone group identifiers. The results list only includes information about the DB clusters associated with these clone groups.</p> </li>
        /// <li> <p> <code>db-cluster-id</code> - Accepts DB cluster identifiers and DB cluster Amazon Resource Names (ARNs). The results list only includes information about the DB clusters identified by these ARNs.</p> </li>
        /// <li> <p> <code>domain</code> - Accepts Active Directory directory IDs. The results list only includes information about the DB clusters associated with these domains.</p> </li>
        /// <li> <p> <code>engine</code> - Accepts engine names. The results list only includes information about the DB clusters for these engines.</p> </li>
        /// </ul>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so you can retrieve the remaining results.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so you can retrieve the remaining results.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p>An optional pagination token provided by a previous <code>DescribeDBClusters</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An optional pagination token provided by a previous <code>DescribeDBClusters</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>Optional Boolean parameter that specifies whether the output includes information about clusters shared from other Amazon Web Services accounts.</p>
        pub fn include_shared(mut self, input: bool) -> Self {
            self.include_shared = Some(input);
            self
        }
        /// <p>Optional Boolean parameter that specifies whether the output includes information about clusters shared from other Amazon Web Services accounts.</p>
        pub fn set_include_shared(mut self, input: std::option::Option<bool>) -> Self {
            self.include_shared = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDbClustersInput`](crate::input::DescribeDbClustersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeDbClustersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeDbClustersInput {
                db_cluster_identifier: self.db_cluster_identifier,
                filters: self.filters,
                max_records: self.max_records,
                marker: self.marker,
                include_shared: self.include_shared.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeDbClustersInputOperationOutputAlias = crate::operation::DescribeDBClusters;
#[doc(hidden)]
pub type DescribeDbClustersInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeDbClustersInput {
    /// Consumes the builder and constructs an Operation<[`DescribeDBClusters`](crate::operation::DescribeDBClusters)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeDBClusters,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeDbClustersInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeDbClustersInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_db_clusters(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeDBClusters::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeDBClusters",
            "rds",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeDbClustersInput`](crate::input::DescribeDbClustersInput)
    pub fn builder() -> crate::input::describe_db_clusters_input::Builder {
        crate::input::describe_db_clusters_input::Builder::default()
    }
}

/// See [`DescribeDbClusterSnapshotAttributesInput`](crate::input::DescribeDbClusterSnapshotAttributesInput)
pub mod describe_db_cluster_snapshot_attributes_input {
    /// A builder for [`DescribeDbClusterSnapshotAttributesInput`](crate::input::DescribeDbClusterSnapshotAttributesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster_snapshot_identifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier for the DB cluster snapshot to describe the attributes for.</p>
        pub fn db_cluster_snapshot_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.db_cluster_snapshot_identifier = Some(input.into());
            self
        }
        /// <p>The identifier for the DB cluster snapshot to describe the attributes for.</p>
        pub fn set_db_cluster_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_snapshot_identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDbClusterSnapshotAttributesInput`](crate::input::DescribeDbClusterSnapshotAttributesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeDbClusterSnapshotAttributesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeDbClusterSnapshotAttributesInput {
                db_cluster_snapshot_identifier: self.db_cluster_snapshot_identifier,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeDbClusterSnapshotAttributesInputOperationOutputAlias =
    crate::operation::DescribeDBClusterSnapshotAttributes;
#[doc(hidden)]
pub type DescribeDbClusterSnapshotAttributesInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeDbClusterSnapshotAttributesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeDBClusterSnapshotAttributes`](crate::operation::DescribeDBClusterSnapshotAttributes)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeDBClusterSnapshotAttributes,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeDbClusterSnapshotAttributesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeDbClusterSnapshotAttributesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_db_cluster_snapshot_attributes(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeDBClusterSnapshotAttributes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeDBClusterSnapshotAttributes",
            "rds",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeDbClusterSnapshotAttributesInput`](crate::input::DescribeDbClusterSnapshotAttributesInput)
    pub fn builder() -> crate::input::describe_db_cluster_snapshot_attributes_input::Builder {
        crate::input::describe_db_cluster_snapshot_attributes_input::Builder::default()
    }
}

/// See [`DescribeDbClusterSnapshotsInput`](crate::input::DescribeDbClusterSnapshotsInput)
pub mod describe_db_cluster_snapshots_input {
    /// A builder for [`DescribeDbClusterSnapshotsInput`](crate::input::DescribeDbClusterSnapshotsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) db_cluster_snapshot_identifier: std::option::Option<std::string::String>,
        pub(crate) snapshot_type: std::option::Option<std::string::String>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) include_shared: std::option::Option<bool>,
        pub(crate) include_public: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The ID of the DB cluster to retrieve the list of DB cluster snapshots for. This parameter can't be used in conjunction with the <code>DBClusterSnapshotIdentifier</code> parameter. This parameter isn't case-sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>If supplied, must match the identifier of an existing DBCluster.</p> </li>
        /// </ul>
        pub fn db_cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_cluster_identifier = Some(input.into());
            self
        }
        /// <p>The ID of the DB cluster to retrieve the list of DB cluster snapshots for. This parameter can't be used in conjunction with the <code>DBClusterSnapshotIdentifier</code> parameter. This parameter isn't case-sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>If supplied, must match the identifier of an existing DBCluster.</p> </li>
        /// </ul>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_identifier = input;
            self
        }
        /// <p>A specific DB cluster snapshot identifier to describe. This parameter can't be used in conjunction with the <code>DBClusterIdentifier</code> parameter. This value is stored as a lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>If supplied, must match the identifier of an existing DBClusterSnapshot.</p> </li>
        /// <li> <p>If this identifier is for an automated snapshot, the <code>SnapshotType</code> parameter must also be specified.</p> </li>
        /// </ul>
        pub fn db_cluster_snapshot_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.db_cluster_snapshot_identifier = Some(input.into());
            self
        }
        /// <p>A specific DB cluster snapshot identifier to describe. This parameter can't be used in conjunction with the <code>DBClusterIdentifier</code> parameter. This value is stored as a lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>If supplied, must match the identifier of an existing DBClusterSnapshot.</p> </li>
        /// <li> <p>If this identifier is for an automated snapshot, the <code>SnapshotType</code> parameter must also be specified.</p> </li>
        /// </ul>
        pub fn set_db_cluster_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_snapshot_identifier = input;
            self
        }
        /// <p>The type of DB cluster snapshots to be returned. You can specify one of the following values:</p>
        /// <ul>
        /// <li> <p> <code>automated</code> - Return all DB cluster snapshots that have been automatically taken by Amazon RDS for my Amazon Web Services account.</p> </li>
        /// <li> <p> <code>manual</code> - Return all DB cluster snapshots that have been taken by my Amazon Web Services account.</p> </li>
        /// <li> <p> <code>shared</code> - Return all manual DB cluster snapshots that have been shared to my Amazon Web Services account.</p> </li>
        /// <li> <p> <code>public</code> - Return all DB cluster snapshots that have been marked as public.</p> </li>
        /// </ul>
        /// <p>If you don't specify a <code>SnapshotType</code> value, then both automated and manual DB cluster snapshots are returned. You can include shared DB cluster snapshots with these results by enabling the <code>IncludeShared</code> parameter. You can include public DB cluster snapshots with these results by enabling the <code>IncludePublic</code> parameter.</p>
        /// <p>The <code>IncludeShared</code> and <code>IncludePublic</code> parameters don't apply for <code>SnapshotType</code> values of <code>manual</code> or <code>automated</code>. The <code>IncludePublic</code> parameter doesn't apply when <code>SnapshotType</code> is set to <code>shared</code>. The <code>IncludeShared</code> parameter doesn't apply when <code>SnapshotType</code> is set to <code>public</code>.</p>
        pub fn snapshot_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.snapshot_type = Some(input.into());
            self
        }
        /// <p>The type of DB cluster snapshots to be returned. You can specify one of the following values:</p>
        /// <ul>
        /// <li> <p> <code>automated</code> - Return all DB cluster snapshots that have been automatically taken by Amazon RDS for my Amazon Web Services account.</p> </li>
        /// <li> <p> <code>manual</code> - Return all DB cluster snapshots that have been taken by my Amazon Web Services account.</p> </li>
        /// <li> <p> <code>shared</code> - Return all manual DB cluster snapshots that have been shared to my Amazon Web Services account.</p> </li>
        /// <li> <p> <code>public</code> - Return all DB cluster snapshots that have been marked as public.</p> </li>
        /// </ul>
        /// <p>If you don't specify a <code>SnapshotType</code> value, then both automated and manual DB cluster snapshots are returned. You can include shared DB cluster snapshots with these results by enabling the <code>IncludeShared</code> parameter. You can include public DB cluster snapshots with these results by enabling the <code>IncludePublic</code> parameter.</p>
        /// <p>The <code>IncludeShared</code> and <code>IncludePublic</code> parameters don't apply for <code>SnapshotType</code> values of <code>manual</code> or <code>automated</code>. The <code>IncludePublic</code> parameter doesn't apply when <code>SnapshotType</code> is set to <code>shared</code>. The <code>IncludeShared</code> parameter doesn't apply when <code>SnapshotType</code> is set to <code>public</code>.</p>
        pub fn set_snapshot_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.snapshot_type = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>A filter that specifies one or more DB cluster snapshots to describe.</p>
        /// <p>Supported filters:</p>
        /// <ul>
        /// <li> <p> <code>db-cluster-id</code> - Accepts DB cluster identifiers and DB cluster Amazon Resource Names (ARNs).</p> </li>
        /// <li> <p> <code>db-cluster-snapshot-id</code> - Accepts DB cluster snapshot identifiers.</p> </li>
        /// <li> <p> <code>snapshot-type</code> - Accepts types of DB cluster snapshots.</p> </li>
        /// <li> <p> <code>engine</code> - Accepts names of database engines.</p> </li>
        /// </ul>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input);
            self.filters = Some(v);
            self
        }
        /// <p>A filter that specifies one or more DB cluster snapshots to describe.</p>
        /// <p>Supported filters:</p>
        /// <ul>
        /// <li> <p> <code>db-cluster-id</code> - Accepts DB cluster identifiers and DB cluster Amazon Resource Names (ARNs).</p> </li>
        /// <li> <p> <code>db-cluster-snapshot-id</code> - Accepts DB cluster snapshot identifiers.</p> </li>
        /// <li> <p> <code>snapshot-type</code> - Accepts types of DB cluster snapshots.</p> </li>
        /// <li> <p> <code>engine</code> - Accepts names of database engines.</p> </li>
        /// </ul>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so you can retrieve the remaining results.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so you can retrieve the remaining results.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p>An optional pagination token provided by a previous <code>DescribeDBClusterSnapshots</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An optional pagination token provided by a previous <code>DescribeDBClusterSnapshots</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>A value that indicates whether to include shared manual DB cluster snapshots from other Amazon Web Services accounts that this Amazon Web Services account has been given permission to copy or restore. By default, these snapshots are not included.</p>
        /// <p>You can give an Amazon Web Services account permission to restore a manual DB cluster snapshot from another Amazon Web Services account by the <code>ModifyDBClusterSnapshotAttribute</code> API action.</p>
        pub fn include_shared(mut self, input: bool) -> Self {
            self.include_shared = Some(input);
            self
        }
        /// <p>A value that indicates whether to include shared manual DB cluster snapshots from other Amazon Web Services accounts that this Amazon Web Services account has been given permission to copy or restore. By default, these snapshots are not included.</p>
        /// <p>You can give an Amazon Web Services account permission to restore a manual DB cluster snapshot from another Amazon Web Services account by the <code>ModifyDBClusterSnapshotAttribute</code> API action.</p>
        pub fn set_include_shared(mut self, input: std::option::Option<bool>) -> Self {
            self.include_shared = input;
            self
        }
        /// <p>A value that indicates whether to include manual DB cluster snapshots that are public and can be copied or restored by any Amazon Web Services account. By default, the public snapshots are not included.</p>
        /// <p>You can share a manual DB cluster snapshot as public by using the <code>ModifyDBClusterSnapshotAttribute</code> API action.</p>
        pub fn include_public(mut self, input: bool) -> Self {
            self.include_public = Some(input);
            self
        }
        /// <p>A value that indicates whether to include manual DB cluster snapshots that are public and can be copied or restored by any Amazon Web Services account. By default, the public snapshots are not included.</p>
        /// <p>You can share a manual DB cluster snapshot as public by using the <code>ModifyDBClusterSnapshotAttribute</code> API action.</p>
        pub fn set_include_public(mut self, input: std::option::Option<bool>) -> Self {
            self.include_public = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDbClusterSnapshotsInput`](crate::input::DescribeDbClusterSnapshotsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeDbClusterSnapshotsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeDbClusterSnapshotsInput {
                db_cluster_identifier: self.db_cluster_identifier,
                db_cluster_snapshot_identifier: self.db_cluster_snapshot_identifier,
                snapshot_type: self.snapshot_type,
                filters: self.filters,
                max_records: self.max_records,
                marker: self.marker,
                include_shared: self.include_shared.unwrap_or_default(),
                include_public: self.include_public.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeDbClusterSnapshotsInputOperationOutputAlias =
    crate::operation::DescribeDBClusterSnapshots;
#[doc(hidden)]
pub type DescribeDbClusterSnapshotsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeDbClusterSnapshotsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeDBClusterSnapshots`](crate::operation::DescribeDBClusterSnapshots)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeDBClusterSnapshots,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeDbClusterSnapshotsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeDbClusterSnapshotsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_db_cluster_snapshots(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeDBClusterSnapshots::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeDBClusterSnapshots",
            "rds",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeDbClusterSnapshotsInput`](crate::input::DescribeDbClusterSnapshotsInput)
    pub fn builder() -> crate::input::describe_db_cluster_snapshots_input::Builder {
        crate::input::describe_db_cluster_snapshots_input::Builder::default()
    }
}

/// See [`DescribeDbEngineVersionsInput`](crate::input::DescribeDbEngineVersionsInput)
pub mod describe_db_engine_versions_input {
    /// A builder for [`DescribeDbEngineVersionsInput`](crate::input::DescribeDbEngineVersionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) engine: std::option::Option<std::string::String>,
        pub(crate) engine_version: std::option::Option<std::string::String>,
        pub(crate) db_parameter_group_family: std::option::Option<std::string::String>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) default_only: std::option::Option<bool>,
        pub(crate) list_supported_character_sets: std::option::Option<bool>,
        pub(crate) list_supported_timezones: std::option::Option<bool>,
        pub(crate) include_all: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The database engine to return.</p>
        /// <p>Valid Values:</p>
        /// <ul>
        /// <li> <p> <code>aurora</code> (for MySQL 5.6-compatible Aurora)</p> </li>
        /// <li> <p> <code>aurora-mysql</code> (for MySQL 5.7-compatible and MySQL 8.0-compatible Aurora)</p> </li>
        /// <li> <p> <code>aurora-postgresql</code> </p> </li>
        /// <li> <p> <code>mariadb</code> </p> </li>
        /// <li> <p> <code>mysql</code> </p> </li>
        /// <li> <p> <code>oracle-ee</code> </p> </li>
        /// <li> <p> <code>oracle-ee-cdb</code> </p> </li>
        /// <li> <p> <code>oracle-se2</code> </p> </li>
        /// <li> <p> <code>oracle-se2-cdb</code> </p> </li>
        /// <li> <p> <code>postgres</code> </p> </li>
        /// <li> <p> <code>sqlserver-ee</code> </p> </li>
        /// <li> <p> <code>sqlserver-se</code> </p> </li>
        /// <li> <p> <code>sqlserver-ex</code> </p> </li>
        /// <li> <p> <code>sqlserver-web</code> </p> </li>
        /// </ul>
        pub fn engine(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine = Some(input.into());
            self
        }
        /// <p>The database engine to return.</p>
        /// <p>Valid Values:</p>
        /// <ul>
        /// <li> <p> <code>aurora</code> (for MySQL 5.6-compatible Aurora)</p> </li>
        /// <li> <p> <code>aurora-mysql</code> (for MySQL 5.7-compatible and MySQL 8.0-compatible Aurora)</p> </li>
        /// <li> <p> <code>aurora-postgresql</code> </p> </li>
        /// <li> <p> <code>mariadb</code> </p> </li>
        /// <li> <p> <code>mysql</code> </p> </li>
        /// <li> <p> <code>oracle-ee</code> </p> </li>
        /// <li> <p> <code>oracle-ee-cdb</code> </p> </li>
        /// <li> <p> <code>oracle-se2</code> </p> </li>
        /// <li> <p> <code>oracle-se2-cdb</code> </p> </li>
        /// <li> <p> <code>postgres</code> </p> </li>
        /// <li> <p> <code>sqlserver-ee</code> </p> </li>
        /// <li> <p> <code>sqlserver-se</code> </p> </li>
        /// <li> <p> <code>sqlserver-ex</code> </p> </li>
        /// <li> <p> <code>sqlserver-web</code> </p> </li>
        /// </ul>
        pub fn set_engine(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.engine = input;
            self
        }
        /// <p>The database engine version to return.</p>
        /// <p>Example: <code>5.1.49</code> </p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_version = Some(input.into());
            self
        }
        /// <p>The database engine version to return.</p>
        /// <p>Example: <code>5.1.49</code> </p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.engine_version = input;
            self
        }
        /// <p>The name of a specific DB parameter group family to return details for.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>If supplied, must match an existing DBParameterGroupFamily.</p> </li>
        /// </ul>
        pub fn db_parameter_group_family(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_parameter_group_family = Some(input.into());
            self
        }
        /// <p>The name of a specific DB parameter group family to return details for.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>If supplied, must match an existing DBParameterGroupFamily.</p> </li>
        /// </ul>
        pub fn set_db_parameter_group_family(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_parameter_group_family = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>A filter that specifies one or more DB engine versions to describe.</p>
        /// <p>Supported filters:</p>
        /// <ul>
        /// <li> <p> <code>db-parameter-group-family</code> - Accepts parameter groups family names. The results list only includes information about the DB engine versions for these parameter group families.</p> </li>
        /// <li> <p> <code>engine</code> - Accepts engine names. The results list only includes information about the DB engine versions for these engines.</p> </li>
        /// <li> <p> <code>engine-mode</code> - Accepts DB engine modes. The results list only includes information about the DB engine versions for these engine modes. Valid DB engine modes are the following:</p>
        /// <ul>
        /// <li> <p> <code>global</code> </p> </li>
        /// <li> <p> <code>multimaster</code> </p> </li>
        /// <li> <p> <code>parallelquery</code> </p> </li>
        /// <li> <p> <code>provisioned</code> </p> </li>
        /// <li> <p> <code>serverless</code> </p> </li>
        /// </ul> </li>
        /// <li> <p> <code>engine-version</code> - Accepts engine versions. The results list only includes information about the DB engine versions for these engine versions.</p> </li>
        /// <li> <p> <code>status</code> - Accepts engine version statuses. The results list only includes information about the DB engine versions for these statuses. Valid statuses are the following:</p>
        /// <ul>
        /// <li> <p> <code>available</code> </p> </li>
        /// <li> <p> <code>deprecated</code> </p> </li>
        /// </ul> </li>
        /// </ul>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input);
            self.filters = Some(v);
            self
        }
        /// <p>A filter that specifies one or more DB engine versions to describe.</p>
        /// <p>Supported filters:</p>
        /// <ul>
        /// <li> <p> <code>db-parameter-group-family</code> - Accepts parameter groups family names. The results list only includes information about the DB engine versions for these parameter group families.</p> </li>
        /// <li> <p> <code>engine</code> - Accepts engine names. The results list only includes information about the DB engine versions for these engines.</p> </li>
        /// <li> <p> <code>engine-mode</code> - Accepts DB engine modes. The results list only includes information about the DB engine versions for these engine modes. Valid DB engine modes are the following:</p>
        /// <ul>
        /// <li> <p> <code>global</code> </p> </li>
        /// <li> <p> <code>multimaster</code> </p> </li>
        /// <li> <p> <code>parallelquery</code> </p> </li>
        /// <li> <p> <code>provisioned</code> </p> </li>
        /// <li> <p> <code>serverless</code> </p> </li>
        /// </ul> </li>
        /// <li> <p> <code>engine-version</code> - Accepts engine versions. The results list only includes information about the DB engine versions for these engine versions.</p> </li>
        /// <li> <p> <code>status</code> - Accepts engine version statuses. The results list only includes information about the DB engine versions for these statuses. Valid statuses are the following:</p>
        /// <ul>
        /// <li> <p> <code>available</code> </p> </li>
        /// <li> <p> <code>deprecated</code> </p> </li>
        /// </ul> </li>
        /// </ul>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The maximum number of records to include in the response. If more than the <code>MaxRecords</code> value is available, a pagination token called a marker is included in the response so you can retrieve the remaining results.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more than the <code>MaxRecords</code> value is available, a pagination token called a marker is included in the response so you can retrieve the remaining results.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>A value that indicates whether only the default version of the specified engine or engine and major version combination is returned.</p>
        pub fn default_only(mut self, input: bool) -> Self {
            self.default_only = Some(input);
            self
        }
        /// <p>A value that indicates whether only the default version of the specified engine or engine and major version combination is returned.</p>
        pub fn set_default_only(mut self, input: std::option::Option<bool>) -> Self {
            self.default_only = input;
            self
        }
        /// <p>A value that indicates whether to list the supported character sets for each engine version.</p>
        /// <p>If this parameter is enabled and the requested engine supports the <code>CharacterSetName</code> parameter for <code>CreateDBInstance</code>, the response includes a list of supported character sets for each engine version.</p>
        /// <p>For RDS Custom, the default is not to list supported character sets. If you set <code>ListSupportedCharacterSets</code> to <code>true</code>, RDS Custom returns no results.</p>
        pub fn list_supported_character_sets(mut self, input: bool) -> Self {
            self.list_supported_character_sets = Some(input);
            self
        }
        /// <p>A value that indicates whether to list the supported character sets for each engine version.</p>
        /// <p>If this parameter is enabled and the requested engine supports the <code>CharacterSetName</code> parameter for <code>CreateDBInstance</code>, the response includes a list of supported character sets for each engine version.</p>
        /// <p>For RDS Custom, the default is not to list supported character sets. If you set <code>ListSupportedCharacterSets</code> to <code>true</code>, RDS Custom returns no results.</p>
        pub fn set_list_supported_character_sets(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.list_supported_character_sets = input;
            self
        }
        /// <p>A value that indicates whether to list the supported time zones for each engine version.</p>
        /// <p>If this parameter is enabled and the requested engine supports the <code>TimeZone</code> parameter for <code>CreateDBInstance</code>, the response includes a list of supported time zones for each engine version.</p>
        /// <p>For RDS Custom, the default is not to list supported time zones. If you set <code>ListSupportedTimezones</code> to <code>true</code>, RDS Custom returns no results.</p>
        pub fn list_supported_timezones(mut self, input: bool) -> Self {
            self.list_supported_timezones = Some(input);
            self
        }
        /// <p>A value that indicates whether to list the supported time zones for each engine version.</p>
        /// <p>If this parameter is enabled and the requested engine supports the <code>TimeZone</code> parameter for <code>CreateDBInstance</code>, the response includes a list of supported time zones for each engine version.</p>
        /// <p>For RDS Custom, the default is not to list supported time zones. If you set <code>ListSupportedTimezones</code> to <code>true</code>, RDS Custom returns no results.</p>
        pub fn set_list_supported_timezones(mut self, input: std::option::Option<bool>) -> Self {
            self.list_supported_timezones = input;
            self
        }
        /// <p>A value that indicates whether to include engine versions that aren't available in the list. The default is to list only available engine versions.</p>
        pub fn include_all(mut self, input: bool) -> Self {
            self.include_all = Some(input);
            self
        }
        /// <p>A value that indicates whether to include engine versions that aren't available in the list. The default is to list only available engine versions.</p>
        pub fn set_include_all(mut self, input: std::option::Option<bool>) -> Self {
            self.include_all = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDbEngineVersionsInput`](crate::input::DescribeDbEngineVersionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeDbEngineVersionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeDbEngineVersionsInput {
                engine: self.engine,
                engine_version: self.engine_version,
                db_parameter_group_family: self.db_parameter_group_family,
                filters: self.filters,
                max_records: self.max_records,
                marker: self.marker,
                default_only: self.default_only.unwrap_or_default(),
                list_supported_character_sets: self.list_supported_character_sets,
                list_supported_timezones: self.list_supported_timezones,
                include_all: self.include_all,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeDbEngineVersionsInputOperationOutputAlias =
    crate::operation::DescribeDBEngineVersions;
#[doc(hidden)]
pub type DescribeDbEngineVersionsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeDbEngineVersionsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeDBEngineVersions`](crate::operation::DescribeDBEngineVersions)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeDBEngineVersions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeDbEngineVersionsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeDbEngineVersionsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_db_engine_versions(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeDBEngineVersions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeDBEngineVersions",
            "rds",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeDbEngineVersionsInput`](crate::input::DescribeDbEngineVersionsInput)
    pub fn builder() -> crate::input::describe_db_engine_versions_input::Builder {
        crate::input::describe_db_engine_versions_input::Builder::default()
    }
}

/// See [`DescribeDbInstanceAutomatedBackupsInput`](crate::input::DescribeDbInstanceAutomatedBackupsInput)
pub mod describe_db_instance_automated_backups_input {
    /// A builder for [`DescribeDbInstanceAutomatedBackupsInput`](crate::input::DescribeDbInstanceAutomatedBackupsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dbi_resource_id: std::option::Option<std::string::String>,
        pub(crate) db_instance_identifier: std::option::Option<std::string::String>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) db_instance_automated_backups_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The resource ID of the DB instance that is the source of the automated backup. This parameter isn't case-sensitive.</p>
        pub fn dbi_resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.dbi_resource_id = Some(input.into());
            self
        }
        /// <p>The resource ID of the DB instance that is the source of the automated backup. This parameter isn't case-sensitive.</p>
        pub fn set_dbi_resource_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dbi_resource_id = input;
            self
        }
        /// <p>(Optional) The user-supplied instance identifier. If this parameter is specified, it must match the identifier of an existing DB instance. It returns information from the specific DB instance' automated backup. This parameter isn't case-sensitive.</p>
        pub fn db_instance_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_instance_identifier = Some(input.into());
            self
        }
        /// <p>(Optional) The user-supplied instance identifier. If this parameter is specified, it must match the identifier of an existing DB instance. It returns information from the specific DB instance' automated backup. This parameter isn't case-sensitive.</p>
        pub fn set_db_instance_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_instance_identifier = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>A filter that specifies which resources to return based on status.</p>
        /// <p>Supported filters are the following:</p>
        /// <ul>
        /// <li> <p> <code>status</code> </p>
        /// <ul>
        /// <li> <p> <code>active</code> - automated backups for current instances</p> </li>
        /// <li> <p> <code>retained</code> - automated backups for deleted instances and after backup replication is stopped</p> </li>
        /// <li> <p> <code>creating</code> - automated backups that are waiting for the first automated snapshot to be available</p> </li>
        /// </ul> </li>
        /// <li> <p> <code>db-instance-id</code> - Accepts DB instance identifiers and Amazon Resource Names (ARNs). The results list includes only information about the DB instance automated backups identified by these ARNs.</p> </li>
        /// <li> <p> <code>dbi-resource-id</code> - Accepts DB resource identifiers and Amazon Resource Names (ARNs). The results list includes only information about the DB instance resources identified by these ARNs.</p> </li>
        /// </ul>
        /// <p>Returns all resources by default. The status for each resource is specified in the response.</p>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input);
            self.filters = Some(v);
            self
        }
        /// <p>A filter that specifies which resources to return based on status.</p>
        /// <p>Supported filters are the following:</p>
        /// <ul>
        /// <li> <p> <code>status</code> </p>
        /// <ul>
        /// <li> <p> <code>active</code> - automated backups for current instances</p> </li>
        /// <li> <p> <code>retained</code> - automated backups for deleted instances and after backup replication is stopped</p> </li>
        /// <li> <p> <code>creating</code> - automated backups that are waiting for the first automated snapshot to be available</p> </li>
        /// </ul> </li>
        /// <li> <p> <code>db-instance-id</code> - Accepts DB instance identifiers and Amazon Resource Names (ARNs). The results list includes only information about the DB instance automated backups identified by these ARNs.</p> </li>
        /// <li> <p> <code>dbi-resource-id</code> - Accepts DB resource identifiers and Amazon Resource Names (ARNs). The results list includes only information about the DB instance resources identified by these ARNs.</p> </li>
        /// </ul>
        /// <p>Returns all resources by default. The status for each resource is specified in the response.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that you can retrieve the remaining results.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that you can retrieve the remaining results.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p>The pagination token provided in the previous request. If this parameter is specified the response includes only records beyond the marker, up to <code>MaxRecords</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>The pagination token provided in the previous request. If this parameter is specified the response includes only records beyond the marker, up to <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the replicated automated backups, for example, <code>arn:aws:rds:us-east-1:123456789012:auto-backup:ab-L2IJCEXJP7XQ7HOJ4SIEXAMPLE</code>.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn db_instance_automated_backups_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.db_instance_automated_backups_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the replicated automated backups, for example, <code>arn:aws:rds:us-east-1:123456789012:auto-backup:ab-L2IJCEXJP7XQ7HOJ4SIEXAMPLE</code>.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn set_db_instance_automated_backups_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_instance_automated_backups_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDbInstanceAutomatedBackupsInput`](crate::input::DescribeDbInstanceAutomatedBackupsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeDbInstanceAutomatedBackupsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeDbInstanceAutomatedBackupsInput {
                dbi_resource_id: self.dbi_resource_id,
                db_instance_identifier: self.db_instance_identifier,
                filters: self.filters,
                max_records: self.max_records,
                marker: self.marker,
                db_instance_automated_backups_arn: self.db_instance_automated_backups_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeDbInstanceAutomatedBackupsInputOperationOutputAlias =
    crate::operation::DescribeDBInstanceAutomatedBackups;
#[doc(hidden)]
pub type DescribeDbInstanceAutomatedBackupsInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeDbInstanceAutomatedBackupsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeDBInstanceAutomatedBackups`](crate::operation::DescribeDBInstanceAutomatedBackups)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeDBInstanceAutomatedBackups,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeDbInstanceAutomatedBackupsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeDbInstanceAutomatedBackupsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_db_instance_automated_backups(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeDBInstanceAutomatedBackups::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeDBInstanceAutomatedBackups",
            "rds",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeDbInstanceAutomatedBackupsInput`](crate::input::DescribeDbInstanceAutomatedBackupsInput)
    pub fn builder() -> crate::input::describe_db_instance_automated_backups_input::Builder {
        crate::input::describe_db_instance_automated_backups_input::Builder::default()
    }
}

/// See [`DescribeDbInstancesInput`](crate::input::DescribeDbInstancesInput)
pub mod describe_db_instances_input {
    /// A builder for [`DescribeDbInstancesInput`](crate::input::DescribeDbInstancesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_instance_identifier: std::option::Option<std::string::String>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The user-supplied instance identifier. If this parameter is specified, information from only the specific DB instance is returned. This parameter isn't case-sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>If supplied, must match the identifier of an existing DBInstance.</p> </li>
        /// </ul>
        pub fn db_instance_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_instance_identifier = Some(input.into());
            self
        }
        /// <p>The user-supplied instance identifier. If this parameter is specified, information from only the specific DB instance is returned. This parameter isn't case-sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>If supplied, must match the identifier of an existing DBInstance.</p> </li>
        /// </ul>
        pub fn set_db_instance_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_instance_identifier = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>A filter that specifies one or more DB instances to describe.</p>
        /// <p>Supported filters:</p>
        /// <ul>
        /// <li> <p> <code>db-cluster-id</code> - Accepts DB cluster identifiers and DB cluster Amazon Resource Names (ARNs). The results list only includes information about the DB instances associated with the DB clusters identified by these ARNs.</p> </li>
        /// <li> <p> <code>db-instance-id</code> - Accepts DB instance identifiers and DB instance Amazon Resource Names (ARNs). The results list only includes information about the DB instances identified by these ARNs.</p> </li>
        /// <li> <p> <code>dbi-resource-id</code> - Accepts DB instance resource identifiers. The results list will only include information about the DB instances identified by these DB instance resource identifiers.</p> </li>
        /// <li> <p> <code>domain</code> - Accepts Active Directory directory IDs. The results list only includes information about the DB instances associated with these domains.</p> </li>
        /// <li> <p> <code>engine</code> - Accepts engine names. The results list only includes information about the DB instances for these engines.</p> </li>
        /// </ul>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input);
            self.filters = Some(v);
            self
        }
        /// <p>A filter that specifies one or more DB instances to describe.</p>
        /// <p>Supported filters:</p>
        /// <ul>
        /// <li> <p> <code>db-cluster-id</code> - Accepts DB cluster identifiers and DB cluster Amazon Resource Names (ARNs). The results list only includes information about the DB instances associated with the DB clusters identified by these ARNs.</p> </li>
        /// <li> <p> <code>db-instance-id</code> - Accepts DB instance identifiers and DB instance Amazon Resource Names (ARNs). The results list only includes information about the DB instances identified by these ARNs.</p> </li>
        /// <li> <p> <code>dbi-resource-id</code> - Accepts DB instance resource identifiers. The results list will only include information about the DB instances identified by these DB instance resource identifiers.</p> </li>
        /// <li> <p> <code>domain</code> - Accepts Active Directory directory IDs. The results list only includes information about the DB instances associated with these domains.</p> </li>
        /// <li> <p> <code>engine</code> - Accepts engine names. The results list only includes information about the DB instances for these engines.</p> </li>
        /// </ul>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that you can retrieve the remaining results.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that you can retrieve the remaining results.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p>An optional pagination token provided by a previous <code>DescribeDBInstances</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An optional pagination token provided by a previous <code>DescribeDBInstances</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDbInstancesInput`](crate::input::DescribeDbInstancesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeDbInstancesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeDbInstancesInput {
                db_instance_identifier: self.db_instance_identifier,
                filters: self.filters,
                max_records: self.max_records,
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeDbInstancesInputOperationOutputAlias = crate::operation::DescribeDBInstances;
#[doc(hidden)]
pub type DescribeDbInstancesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeDbInstancesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeDBInstances`](crate::operation::DescribeDBInstances)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeDBInstances,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeDbInstancesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeDbInstancesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_db_instances(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeDBInstances::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeDBInstances",
            "rds",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeDbInstancesInput`](crate::input::DescribeDbInstancesInput)
    pub fn builder() -> crate::input::describe_db_instances_input::Builder {
        crate::input::describe_db_instances_input::Builder::default()
    }
}

/// See [`DescribeDbLogFilesInput`](crate::input::DescribeDbLogFilesInput)
pub mod describe_db_log_files_input {
    /// A builder for [`DescribeDbLogFilesInput`](crate::input::DescribeDbLogFilesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_instance_identifier: std::option::Option<std::string::String>,
        pub(crate) filename_contains: std::option::Option<std::string::String>,
        pub(crate) file_last_written: std::option::Option<i64>,
        pub(crate) file_size: std::option::Option<i64>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The customer-assigned name of the DB instance that contains the log files you want to list.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must match the identifier of an existing DBInstance.</p> </li>
        /// </ul>
        pub fn db_instance_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_instance_identifier = Some(input.into());
            self
        }
        /// <p>The customer-assigned name of the DB instance that contains the log files you want to list.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must match the identifier of an existing DBInstance.</p> </li>
        /// </ul>
        pub fn set_db_instance_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_instance_identifier = input;
            self
        }
        /// <p>Filters the available log files for log file names that contain the specified string.</p>
        pub fn filename_contains(mut self, input: impl Into<std::string::String>) -> Self {
            self.filename_contains = Some(input.into());
            self
        }
        /// <p>Filters the available log files for log file names that contain the specified string.</p>
        pub fn set_filename_contains(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.filename_contains = input;
            self
        }
        /// <p>Filters the available log files for files written since the specified date, in POSIX timestamp format with milliseconds.</p>
        pub fn file_last_written(mut self, input: i64) -> Self {
            self.file_last_written = Some(input);
            self
        }
        /// <p>Filters the available log files for files written since the specified date, in POSIX timestamp format with milliseconds.</p>
        pub fn set_file_last_written(mut self, input: std::option::Option<i64>) -> Self {
            self.file_last_written = input;
            self
        }
        /// <p>Filters the available log files for files larger than the specified size.</p>
        pub fn file_size(mut self, input: i64) -> Self {
            self.file_size = Some(input);
            self
        }
        /// <p>Filters the available log files for files larger than the specified size.</p>
        pub fn set_file_size(mut self, input: std::option::Option<i64>) -> Self {
            self.file_size = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>This parameter isn't currently supported.</p>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input);
            self.filters = Some(v);
            self
        }
        /// <p>This parameter isn't currently supported.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified MaxRecords value, a pagination token called a marker is included in the response so you can retrieve the remaining results.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified MaxRecords value, a pagination token called a marker is included in the response so you can retrieve the remaining results.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p>The pagination token provided in the previous request. If this parameter is specified the response includes only records beyond the marker, up to MaxRecords.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>The pagination token provided in the previous request. If this parameter is specified the response includes only records beyond the marker, up to MaxRecords.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDbLogFilesInput`](crate::input::DescribeDbLogFilesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeDbLogFilesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeDbLogFilesInput {
                db_instance_identifier: self.db_instance_identifier,
                filename_contains: self.filename_contains,
                file_last_written: self.file_last_written.unwrap_or_default(),
                file_size: self.file_size.unwrap_or_default(),
                filters: self.filters,
                max_records: self.max_records,
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeDbLogFilesInputOperationOutputAlias = crate::operation::DescribeDBLogFiles;
#[doc(hidden)]
pub type DescribeDbLogFilesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeDbLogFilesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeDBLogFiles`](crate::operation::DescribeDBLogFiles)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeDBLogFiles,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeDbLogFilesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeDbLogFilesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_db_log_files(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeDBLogFiles::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeDBLogFiles",
            "rds",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeDbLogFilesInput`](crate::input::DescribeDbLogFilesInput)
    pub fn builder() -> crate::input::describe_db_log_files_input::Builder {
        crate::input::describe_db_log_files_input::Builder::default()
    }
}

/// See [`DescribeDbParameterGroupsInput`](crate::input::DescribeDbParameterGroupsInput)
pub mod describe_db_parameter_groups_input {
    /// A builder for [`DescribeDbParameterGroupsInput`](crate::input::DescribeDbParameterGroupsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_parameter_group_name: std::option::Option<std::string::String>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of a specific DB parameter group to return details for.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>If supplied, must match the name of an existing DBClusterParameterGroup.</p> </li>
        /// </ul>
        pub fn db_parameter_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_parameter_group_name = Some(input.into());
            self
        }
        /// <p>The name of a specific DB parameter group to return details for.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>If supplied, must match the name of an existing DBClusterParameterGroup.</p> </li>
        /// </ul>
        pub fn set_db_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_parameter_group_name = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>This parameter isn't currently supported.</p>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input);
            self.filters = Some(v);
            self
        }
        /// <p>This parameter isn't currently supported.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that you can retrieve the remaining results.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that you can retrieve the remaining results.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p>An optional pagination token provided by a previous <code>DescribeDBParameterGroups</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An optional pagination token provided by a previous <code>DescribeDBParameterGroups</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDbParameterGroupsInput`](crate::input::DescribeDbParameterGroupsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeDbParameterGroupsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeDbParameterGroupsInput {
                db_parameter_group_name: self.db_parameter_group_name,
                filters: self.filters,
                max_records: self.max_records,
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeDbParameterGroupsInputOperationOutputAlias =
    crate::operation::DescribeDBParameterGroups;
#[doc(hidden)]
pub type DescribeDbParameterGroupsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeDbParameterGroupsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeDBParameterGroups`](crate::operation::DescribeDBParameterGroups)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeDBParameterGroups,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeDbParameterGroupsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeDbParameterGroupsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_db_parameter_groups(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeDBParameterGroups::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeDBParameterGroups",
            "rds",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeDbParameterGroupsInput`](crate::input::DescribeDbParameterGroupsInput)
    pub fn builder() -> crate::input::describe_db_parameter_groups_input::Builder {
        crate::input::describe_db_parameter_groups_input::Builder::default()
    }
}

/// See [`DescribeDbParametersInput`](crate::input::DescribeDbParametersInput)
pub mod describe_db_parameters_input {
    /// A builder for [`DescribeDbParametersInput`](crate::input::DescribeDbParametersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_parameter_group_name: std::option::Option<std::string::String>,
        pub(crate) source: std::option::Option<std::string::String>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of a specific DB parameter group to return details for.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>If supplied, must match the name of an existing DBParameterGroup.</p> </li>
        /// </ul>
        pub fn db_parameter_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_parameter_group_name = Some(input.into());
            self
        }
        /// <p>The name of a specific DB parameter group to return details for.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>If supplied, must match the name of an existing DBParameterGroup.</p> </li>
        /// </ul>
        pub fn set_db_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_parameter_group_name = input;
            self
        }
        /// <p>The parameter types to return.</p>
        /// <p>Default: All parameter types returned</p>
        /// <p>Valid Values: <code>user | system | engine-default</code> </p>
        pub fn source(mut self, input: impl Into<std::string::String>) -> Self {
            self.source = Some(input.into());
            self
        }
        /// <p>The parameter types to return.</p>
        /// <p>Default: All parameter types returned</p>
        /// <p>Valid Values: <code>user | system | engine-default</code> </p>
        pub fn set_source(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>This parameter isn't currently supported.</p>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input);
            self.filters = Some(v);
            self
        }
        /// <p>This parameter isn't currently supported.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that you can retrieve the remaining results.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that you can retrieve the remaining results.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p>An optional pagination token provided by a previous <code>DescribeDBParameters</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An optional pagination token provided by a previous <code>DescribeDBParameters</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDbParametersInput`](crate::input::DescribeDbParametersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeDbParametersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeDbParametersInput {
                db_parameter_group_name: self.db_parameter_group_name,
                source: self.source,
                filters: self.filters,
                max_records: self.max_records,
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeDbParametersInputOperationOutputAlias = crate::operation::DescribeDBParameters;
#[doc(hidden)]
pub type DescribeDbParametersInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeDbParametersInput {
    /// Consumes the builder and constructs an Operation<[`DescribeDBParameters`](crate::operation::DescribeDBParameters)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeDBParameters,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeDbParametersInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeDbParametersInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_db_parameters(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeDBParameters::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeDBParameters",
            "rds",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeDbParametersInput`](crate::input::DescribeDbParametersInput)
    pub fn builder() -> crate::input::describe_db_parameters_input::Builder {
        crate::input::describe_db_parameters_input::Builder::default()
    }
}

/// See [`DescribeDbProxiesInput`](crate::input::DescribeDbProxiesInput)
pub mod describe_db_proxies_input {
    /// A builder for [`DescribeDbProxiesInput`](crate::input::DescribeDbProxiesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_proxy_name: std::option::Option<std::string::String>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) max_records: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the DB proxy. If you omit this parameter, the output includes information about all DB proxies owned by your Amazon Web Services account ID.</p>
        pub fn db_proxy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_proxy_name = Some(input.into());
            self
        }
        /// <p>The name of the DB proxy. If you omit this parameter, the output includes information about all DB proxies owned by your Amazon Web Services account ID.</p>
        pub fn set_db_proxy_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_proxy_name = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>This parameter is not currently supported.</p>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input);
            self.filters = Some(v);
            self
        }
        /// <p>This parameter is not currently supported.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDbProxiesInput`](crate::input::DescribeDbProxiesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeDbProxiesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeDbProxiesInput {
                db_proxy_name: self.db_proxy_name,
                filters: self.filters,
                marker: self.marker,
                max_records: self.max_records,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeDbProxiesInputOperationOutputAlias = crate::operation::DescribeDBProxies;
#[doc(hidden)]
pub type DescribeDbProxiesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeDbProxiesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeDBProxies`](crate::operation::DescribeDBProxies)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeDBProxies,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeDbProxiesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeDbProxiesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_db_proxies(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeDBProxies::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeDBProxies",
            "rds",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeDbProxiesInput`](crate::input::DescribeDbProxiesInput)
    pub fn builder() -> crate::input::describe_db_proxies_input::Builder {
        crate::input::describe_db_proxies_input::Builder::default()
    }
}

/// See [`DescribeDbProxyEndpointsInput`](crate::input::DescribeDbProxyEndpointsInput)
pub mod describe_db_proxy_endpoints_input {
    /// A builder for [`DescribeDbProxyEndpointsInput`](crate::input::DescribeDbProxyEndpointsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_proxy_name: std::option::Option<std::string::String>,
        pub(crate) db_proxy_endpoint_name: std::option::Option<std::string::String>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) max_records: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the DB proxy whose endpoints you want to describe. If you omit this parameter, the output includes information about all DB proxy endpoints associated with all your DB proxies.</p>
        pub fn db_proxy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_proxy_name = Some(input.into());
            self
        }
        /// <p>The name of the DB proxy whose endpoints you want to describe. If you omit this parameter, the output includes information about all DB proxy endpoints associated with all your DB proxies.</p>
        pub fn set_db_proxy_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_proxy_name = input;
            self
        }
        /// <p>The name of a DB proxy endpoint to describe. If you omit this parameter, the output includes information about all DB proxy endpoints associated with the specified proxy.</p>
        pub fn db_proxy_endpoint_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_proxy_endpoint_name = Some(input.into());
            self
        }
        /// <p>The name of a DB proxy endpoint to describe. If you omit this parameter, the output includes information about all DB proxy endpoints associated with the specified proxy.</p>
        pub fn set_db_proxy_endpoint_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_proxy_endpoint_name = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>This parameter is not currently supported.</p>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input);
            self.filters = Some(v);
            self
        }
        /// <p>This parameter is not currently supported.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDbProxyEndpointsInput`](crate::input::DescribeDbProxyEndpointsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeDbProxyEndpointsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeDbProxyEndpointsInput {
                db_proxy_name: self.db_proxy_name,
                db_proxy_endpoint_name: self.db_proxy_endpoint_name,
                filters: self.filters,
                marker: self.marker,
                max_records: self.max_records,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeDbProxyEndpointsInputOperationOutputAlias =
    crate::operation::DescribeDBProxyEndpoints;
#[doc(hidden)]
pub type DescribeDbProxyEndpointsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeDbProxyEndpointsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeDBProxyEndpoints`](crate::operation::DescribeDBProxyEndpoints)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeDBProxyEndpoints,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeDbProxyEndpointsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeDbProxyEndpointsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_db_proxy_endpoints(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeDBProxyEndpoints::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeDBProxyEndpoints",
            "rds",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeDbProxyEndpointsInput`](crate::input::DescribeDbProxyEndpointsInput)
    pub fn builder() -> crate::input::describe_db_proxy_endpoints_input::Builder {
        crate::input::describe_db_proxy_endpoints_input::Builder::default()
    }
}

/// See [`DescribeDbProxyTargetGroupsInput`](crate::input::DescribeDbProxyTargetGroupsInput)
pub mod describe_db_proxy_target_groups_input {
    /// A builder for [`DescribeDbProxyTargetGroupsInput`](crate::input::DescribeDbProxyTargetGroupsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_proxy_name: std::option::Option<std::string::String>,
        pub(crate) target_group_name: std::option::Option<std::string::String>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) max_records: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The identifier of the <code>DBProxy</code> associated with the target group.</p>
        pub fn db_proxy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_proxy_name = Some(input.into());
            self
        }
        /// <p>The identifier of the <code>DBProxy</code> associated with the target group.</p>
        pub fn set_db_proxy_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_proxy_name = input;
            self
        }
        /// <p>The identifier of the <code>DBProxyTargetGroup</code> to describe.</p>
        pub fn target_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_group_name = Some(input.into());
            self
        }
        /// <p>The identifier of the <code>DBProxyTargetGroup</code> to describe.</p>
        pub fn set_target_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_group_name = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>This parameter is not currently supported.</p>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input);
            self.filters = Some(v);
            self
        }
        /// <p>This parameter is not currently supported.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDbProxyTargetGroupsInput`](crate::input::DescribeDbProxyTargetGroupsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeDbProxyTargetGroupsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeDbProxyTargetGroupsInput {
                db_proxy_name: self.db_proxy_name,
                target_group_name: self.target_group_name,
                filters: self.filters,
                marker: self.marker,
                max_records: self.max_records,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeDbProxyTargetGroupsInputOperationOutputAlias =
    crate::operation::DescribeDBProxyTargetGroups;
#[doc(hidden)]
pub type DescribeDbProxyTargetGroupsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeDbProxyTargetGroupsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeDBProxyTargetGroups`](crate::operation::DescribeDBProxyTargetGroups)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeDBProxyTargetGroups,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeDbProxyTargetGroupsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeDbProxyTargetGroupsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_db_proxy_target_groups(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeDBProxyTargetGroups::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeDBProxyTargetGroups",
            "rds",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeDbProxyTargetGroupsInput`](crate::input::DescribeDbProxyTargetGroupsInput)
    pub fn builder() -> crate::input::describe_db_proxy_target_groups_input::Builder {
        crate::input::describe_db_proxy_target_groups_input::Builder::default()
    }
}

/// See [`DescribeDbProxyTargetsInput`](crate::input::DescribeDbProxyTargetsInput)
pub mod describe_db_proxy_targets_input {
    /// A builder for [`DescribeDbProxyTargetsInput`](crate::input::DescribeDbProxyTargetsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_proxy_name: std::option::Option<std::string::String>,
        pub(crate) target_group_name: std::option::Option<std::string::String>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) max_records: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The identifier of the <code>DBProxyTarget</code> to describe.</p>
        pub fn db_proxy_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_proxy_name = Some(input.into());
            self
        }
        /// <p>The identifier of the <code>DBProxyTarget</code> to describe.</p>
        pub fn set_db_proxy_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_proxy_name = input;
            self
        }
        /// <p>The identifier of the <code>DBProxyTargetGroup</code> to describe.</p>
        pub fn target_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.target_group_name = Some(input.into());
            self
        }
        /// <p>The identifier of the <code>DBProxyTargetGroup</code> to describe.</p>
        pub fn set_target_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.target_group_name = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>This parameter is not currently supported.</p>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input);
            self.filters = Some(v);
            self
        }
        /// <p>This parameter is not currently supported.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDbProxyTargetsInput`](crate::input::DescribeDbProxyTargetsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeDbProxyTargetsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeDbProxyTargetsInput {
                db_proxy_name: self.db_proxy_name,
                target_group_name: self.target_group_name,
                filters: self.filters,
                marker: self.marker,
                max_records: self.max_records,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeDbProxyTargetsInputOperationOutputAlias = crate::operation::DescribeDBProxyTargets;
#[doc(hidden)]
pub type DescribeDbProxyTargetsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeDbProxyTargetsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeDBProxyTargets`](crate::operation::DescribeDBProxyTargets)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeDBProxyTargets,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeDbProxyTargetsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeDbProxyTargetsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_db_proxy_targets(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeDBProxyTargets::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeDBProxyTargets",
            "rds",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeDbProxyTargetsInput`](crate::input::DescribeDbProxyTargetsInput)
    pub fn builder() -> crate::input::describe_db_proxy_targets_input::Builder {
        crate::input::describe_db_proxy_targets_input::Builder::default()
    }
}

/// See [`DescribeDbSecurityGroupsInput`](crate::input::DescribeDbSecurityGroupsInput)
pub mod describe_db_security_groups_input {
    /// A builder for [`DescribeDbSecurityGroupsInput`](crate::input::DescribeDbSecurityGroupsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_security_group_name: std::option::Option<std::string::String>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the DB security group to return details for.</p>
        pub fn db_security_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_security_group_name = Some(input.into());
            self
        }
        /// <p>The name of the DB security group to return details for.</p>
        pub fn set_db_security_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_security_group_name = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>This parameter isn't currently supported.</p>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input);
            self.filters = Some(v);
            self
        }
        /// <p>This parameter isn't currently supported.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that you can retrieve the remaining results.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that you can retrieve the remaining results.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p>An optional pagination token provided by a previous <code>DescribeDBSecurityGroups</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An optional pagination token provided by a previous <code>DescribeDBSecurityGroups</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDbSecurityGroupsInput`](crate::input::DescribeDbSecurityGroupsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeDbSecurityGroupsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeDbSecurityGroupsInput {
                db_security_group_name: self.db_security_group_name,
                filters: self.filters,
                max_records: self.max_records,
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeDbSecurityGroupsInputOperationOutputAlias =
    crate::operation::DescribeDBSecurityGroups;
#[doc(hidden)]
pub type DescribeDbSecurityGroupsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeDbSecurityGroupsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeDBSecurityGroups`](crate::operation::DescribeDBSecurityGroups)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeDBSecurityGroups,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeDbSecurityGroupsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeDbSecurityGroupsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_db_security_groups(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeDBSecurityGroups::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeDBSecurityGroups",
            "rds",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeDbSecurityGroupsInput`](crate::input::DescribeDbSecurityGroupsInput)
    pub fn builder() -> crate::input::describe_db_security_groups_input::Builder {
        crate::input::describe_db_security_groups_input::Builder::default()
    }
}

/// See [`DescribeDbSnapshotAttributesInput`](crate::input::DescribeDbSnapshotAttributesInput)
pub mod describe_db_snapshot_attributes_input {
    /// A builder for [`DescribeDbSnapshotAttributesInput`](crate::input::DescribeDbSnapshotAttributesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_snapshot_identifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier for the DB snapshot to describe the attributes for.</p>
        pub fn db_snapshot_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_snapshot_identifier = Some(input.into());
            self
        }
        /// <p>The identifier for the DB snapshot to describe the attributes for.</p>
        pub fn set_db_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_snapshot_identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDbSnapshotAttributesInput`](crate::input::DescribeDbSnapshotAttributesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeDbSnapshotAttributesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeDbSnapshotAttributesInput {
                db_snapshot_identifier: self.db_snapshot_identifier,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeDbSnapshotAttributesInputOperationOutputAlias =
    crate::operation::DescribeDBSnapshotAttributes;
#[doc(hidden)]
pub type DescribeDbSnapshotAttributesInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeDbSnapshotAttributesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeDBSnapshotAttributes`](crate::operation::DescribeDBSnapshotAttributes)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeDBSnapshotAttributes,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeDbSnapshotAttributesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeDbSnapshotAttributesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_db_snapshot_attributes(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeDBSnapshotAttributes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeDBSnapshotAttributes",
            "rds",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeDbSnapshotAttributesInput`](crate::input::DescribeDbSnapshotAttributesInput)
    pub fn builder() -> crate::input::describe_db_snapshot_attributes_input::Builder {
        crate::input::describe_db_snapshot_attributes_input::Builder::default()
    }
}

/// See [`DescribeDbSnapshotsInput`](crate::input::DescribeDbSnapshotsInput)
pub mod describe_db_snapshots_input {
    /// A builder for [`DescribeDbSnapshotsInput`](crate::input::DescribeDbSnapshotsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_instance_identifier: std::option::Option<std::string::String>,
        pub(crate) db_snapshot_identifier: std::option::Option<std::string::String>,
        pub(crate) snapshot_type: std::option::Option<std::string::String>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) include_shared: std::option::Option<bool>,
        pub(crate) include_public: std::option::Option<bool>,
        pub(crate) dbi_resource_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the DB instance to retrieve the list of DB snapshots for. This parameter can't be used in conjunction with <code>DBSnapshotIdentifier</code>. This parameter isn't case-sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>If supplied, must match the identifier of an existing DBInstance.</p> </li>
        /// </ul>
        pub fn db_instance_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_instance_identifier = Some(input.into());
            self
        }
        /// <p>The ID of the DB instance to retrieve the list of DB snapshots for. This parameter can't be used in conjunction with <code>DBSnapshotIdentifier</code>. This parameter isn't case-sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>If supplied, must match the identifier of an existing DBInstance.</p> </li>
        /// </ul>
        pub fn set_db_instance_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_instance_identifier = input;
            self
        }
        /// <p>A specific DB snapshot identifier to describe. This parameter can't be used in conjunction with <code>DBInstanceIdentifier</code>. This value is stored as a lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>If supplied, must match the identifier of an existing DBSnapshot.</p> </li>
        /// <li> <p>If this identifier is for an automated snapshot, the <code>SnapshotType</code> parameter must also be specified.</p> </li>
        /// </ul>
        pub fn db_snapshot_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_snapshot_identifier = Some(input.into());
            self
        }
        /// <p>A specific DB snapshot identifier to describe. This parameter can't be used in conjunction with <code>DBInstanceIdentifier</code>. This value is stored as a lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>If supplied, must match the identifier of an existing DBSnapshot.</p> </li>
        /// <li> <p>If this identifier is for an automated snapshot, the <code>SnapshotType</code> parameter must also be specified.</p> </li>
        /// </ul>
        pub fn set_db_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_snapshot_identifier = input;
            self
        }
        /// <p>The type of snapshots to be returned. You can specify one of the following values:</p>
        /// <ul>
        /// <li> <p> <code>automated</code> - Return all DB snapshots that have been automatically taken by Amazon RDS for my Amazon Web Services account.</p> </li>
        /// <li> <p> <code>manual</code> - Return all DB snapshots that have been taken by my Amazon Web Services account.</p> </li>
        /// <li> <p> <code>shared</code> - Return all manual DB snapshots that have been shared to my Amazon Web Services account.</p> </li>
        /// <li> <p> <code>public</code> - Return all DB snapshots that have been marked as public.</p> </li>
        /// <li> <p> <code>awsbackup</code> - Return the DB snapshots managed by the Amazon Web Services Backup service.</p> <p>For information about Amazon Web Services Backup, see the <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/whatisbackup.html"> <i>Amazon Web Services Backup Developer Guide.</i> </a> </p> <p>The <code>awsbackup</code> type does not apply to Aurora.</p> </li>
        /// </ul>
        /// <p>If you don't specify a <code>SnapshotType</code> value, then both automated and manual snapshots are returned. Shared and public DB snapshots are not included in the returned results by default. You can include shared snapshots with these results by enabling the <code>IncludeShared</code> parameter. You can include public snapshots with these results by enabling the <code>IncludePublic</code> parameter.</p>
        /// <p>The <code>IncludeShared</code> and <code>IncludePublic</code> parameters don't apply for <code>SnapshotType</code> values of <code>manual</code> or <code>automated</code>. The <code>IncludePublic</code> parameter doesn't apply when <code>SnapshotType</code> is set to <code>shared</code>. The <code>IncludeShared</code> parameter doesn't apply when <code>SnapshotType</code> is set to <code>public</code>.</p>
        pub fn snapshot_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.snapshot_type = Some(input.into());
            self
        }
        /// <p>The type of snapshots to be returned. You can specify one of the following values:</p>
        /// <ul>
        /// <li> <p> <code>automated</code> - Return all DB snapshots that have been automatically taken by Amazon RDS for my Amazon Web Services account.</p> </li>
        /// <li> <p> <code>manual</code> - Return all DB snapshots that have been taken by my Amazon Web Services account.</p> </li>
        /// <li> <p> <code>shared</code> - Return all manual DB snapshots that have been shared to my Amazon Web Services account.</p> </li>
        /// <li> <p> <code>public</code> - Return all DB snapshots that have been marked as public.</p> </li>
        /// <li> <p> <code>awsbackup</code> - Return the DB snapshots managed by the Amazon Web Services Backup service.</p> <p>For information about Amazon Web Services Backup, see the <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/whatisbackup.html"> <i>Amazon Web Services Backup Developer Guide.</i> </a> </p> <p>The <code>awsbackup</code> type does not apply to Aurora.</p> </li>
        /// </ul>
        /// <p>If you don't specify a <code>SnapshotType</code> value, then both automated and manual snapshots are returned. Shared and public DB snapshots are not included in the returned results by default. You can include shared snapshots with these results by enabling the <code>IncludeShared</code> parameter. You can include public snapshots with these results by enabling the <code>IncludePublic</code> parameter.</p>
        /// <p>The <code>IncludeShared</code> and <code>IncludePublic</code> parameters don't apply for <code>SnapshotType</code> values of <code>manual</code> or <code>automated</code>. The <code>IncludePublic</code> parameter doesn't apply when <code>SnapshotType</code> is set to <code>shared</code>. The <code>IncludeShared</code> parameter doesn't apply when <code>SnapshotType</code> is set to <code>public</code>.</p>
        pub fn set_snapshot_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.snapshot_type = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>A filter that specifies one or more DB snapshots to describe.</p>
        /// <p>Supported filters:</p>
        /// <ul>
        /// <li> <p> <code>db-instance-id</code> - Accepts DB instance identifiers and DB instance Amazon Resource Names (ARNs).</p> </li>
        /// <li> <p> <code>db-snapshot-id</code> - Accepts DB snapshot identifiers.</p> </li>
        /// <li> <p> <code>dbi-resource-id</code> - Accepts identifiers of source DB instances.</p> </li>
        /// <li> <p> <code>snapshot-type</code> - Accepts types of DB snapshots.</p> </li>
        /// <li> <p> <code>engine</code> - Accepts names of database engines.</p> </li>
        /// </ul>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input);
            self.filters = Some(v);
            self
        }
        /// <p>A filter that specifies one or more DB snapshots to describe.</p>
        /// <p>Supported filters:</p>
        /// <ul>
        /// <li> <p> <code>db-instance-id</code> - Accepts DB instance identifiers and DB instance Amazon Resource Names (ARNs).</p> </li>
        /// <li> <p> <code>db-snapshot-id</code> - Accepts DB snapshot identifiers.</p> </li>
        /// <li> <p> <code>dbi-resource-id</code> - Accepts identifiers of source DB instances.</p> </li>
        /// <li> <p> <code>snapshot-type</code> - Accepts types of DB snapshots.</p> </li>
        /// <li> <p> <code>engine</code> - Accepts names of database engines.</p> </li>
        /// </ul>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that you can retrieve the remaining results.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that you can retrieve the remaining results.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p>An optional pagination token provided by a previous <code>DescribeDBSnapshots</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An optional pagination token provided by a previous <code>DescribeDBSnapshots</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>A value that indicates whether to include shared manual DB cluster snapshots from other Amazon Web Services accounts that this Amazon Web Services account has been given permission to copy or restore. By default, these snapshots are not included.</p>
        /// <p>You can give an Amazon Web Services account permission to restore a manual DB snapshot from another Amazon Web Services account by using the <code>ModifyDBSnapshotAttribute</code> API action.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn include_shared(mut self, input: bool) -> Self {
            self.include_shared = Some(input);
            self
        }
        /// <p>A value that indicates whether to include shared manual DB cluster snapshots from other Amazon Web Services accounts that this Amazon Web Services account has been given permission to copy or restore. By default, these snapshots are not included.</p>
        /// <p>You can give an Amazon Web Services account permission to restore a manual DB snapshot from another Amazon Web Services account by using the <code>ModifyDBSnapshotAttribute</code> API action.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn set_include_shared(mut self, input: std::option::Option<bool>) -> Self {
            self.include_shared = input;
            self
        }
        /// <p>A value that indicates whether to include manual DB cluster snapshots that are public and can be copied or restored by any Amazon Web Services account. By default, the public snapshots are not included.</p>
        /// <p>You can share a manual DB snapshot as public by using the <code>ModifyDBSnapshotAttribute</code> API.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn include_public(mut self, input: bool) -> Self {
            self.include_public = Some(input);
            self
        }
        /// <p>A value that indicates whether to include manual DB cluster snapshots that are public and can be copied or restored by any Amazon Web Services account. By default, the public snapshots are not included.</p>
        /// <p>You can share a manual DB snapshot as public by using the <code>ModifyDBSnapshotAttribute</code> API.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn set_include_public(mut self, input: std::option::Option<bool>) -> Self {
            self.include_public = input;
            self
        }
        /// <p>A specific DB resource ID to describe.</p>
        pub fn dbi_resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.dbi_resource_id = Some(input.into());
            self
        }
        /// <p>A specific DB resource ID to describe.</p>
        pub fn set_dbi_resource_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dbi_resource_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDbSnapshotsInput`](crate::input::DescribeDbSnapshotsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeDbSnapshotsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeDbSnapshotsInput {
                db_instance_identifier: self.db_instance_identifier,
                db_snapshot_identifier: self.db_snapshot_identifier,
                snapshot_type: self.snapshot_type,
                filters: self.filters,
                max_records: self.max_records,
                marker: self.marker,
                include_shared: self.include_shared.unwrap_or_default(),
                include_public: self.include_public.unwrap_or_default(),
                dbi_resource_id: self.dbi_resource_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeDbSnapshotsInputOperationOutputAlias = crate::operation::DescribeDBSnapshots;
#[doc(hidden)]
pub type DescribeDbSnapshotsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeDbSnapshotsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeDBSnapshots`](crate::operation::DescribeDBSnapshots)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeDBSnapshots,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeDbSnapshotsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeDbSnapshotsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_db_snapshots(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeDBSnapshots::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeDBSnapshots",
            "rds",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeDbSnapshotsInput`](crate::input::DescribeDbSnapshotsInput)
    pub fn builder() -> crate::input::describe_db_snapshots_input::Builder {
        crate::input::describe_db_snapshots_input::Builder::default()
    }
}

/// See [`DescribeDbSubnetGroupsInput`](crate::input::DescribeDbSubnetGroupsInput)
pub mod describe_db_subnet_groups_input {
    /// A builder for [`DescribeDbSubnetGroupsInput`](crate::input::DescribeDbSubnetGroupsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_subnet_group_name: std::option::Option<std::string::String>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the DB subnet group to return details for.</p>
        pub fn db_subnet_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_subnet_group_name = Some(input.into());
            self
        }
        /// <p>The name of the DB subnet group to return details for.</p>
        pub fn set_db_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_subnet_group_name = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>This parameter isn't currently supported.</p>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input);
            self.filters = Some(v);
            self
        }
        /// <p>This parameter isn't currently supported.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that you can retrieve the remaining results.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that you can retrieve the remaining results.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p>An optional pagination token provided by a previous DescribeDBSubnetGroups request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An optional pagination token provided by a previous DescribeDBSubnetGroups request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDbSubnetGroupsInput`](crate::input::DescribeDbSubnetGroupsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeDbSubnetGroupsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeDbSubnetGroupsInput {
                db_subnet_group_name: self.db_subnet_group_name,
                filters: self.filters,
                max_records: self.max_records,
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeDbSubnetGroupsInputOperationOutputAlias = crate::operation::DescribeDBSubnetGroups;
#[doc(hidden)]
pub type DescribeDbSubnetGroupsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeDbSubnetGroupsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeDBSubnetGroups`](crate::operation::DescribeDBSubnetGroups)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeDBSubnetGroups,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeDbSubnetGroupsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeDbSubnetGroupsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_db_subnet_groups(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeDBSubnetGroups::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeDBSubnetGroups",
            "rds",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeDbSubnetGroupsInput`](crate::input::DescribeDbSubnetGroupsInput)
    pub fn builder() -> crate::input::describe_db_subnet_groups_input::Builder {
        crate::input::describe_db_subnet_groups_input::Builder::default()
    }
}

/// See [`DescribeEngineDefaultClusterParametersInput`](crate::input::DescribeEngineDefaultClusterParametersInput)
pub mod describe_engine_default_cluster_parameters_input {
    /// A builder for [`DescribeEngineDefaultClusterParametersInput`](crate::input::DescribeEngineDefaultClusterParametersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_parameter_group_family: std::option::Option<std::string::String>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the DB cluster parameter group family to return engine parameter information for.</p>
        pub fn db_parameter_group_family(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_parameter_group_family = Some(input.into());
            self
        }
        /// <p>The name of the DB cluster parameter group family to return engine parameter information for.</p>
        pub fn set_db_parameter_group_family(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_parameter_group_family = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>This parameter isn't currently supported.</p>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input);
            self.filters = Some(v);
            self
        }
        /// <p>This parameter isn't currently supported.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so you can retrieve the remaining results.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so you can retrieve the remaining results.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p>An optional pagination token provided by a previous <code>DescribeEngineDefaultClusterParameters</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An optional pagination token provided by a previous <code>DescribeEngineDefaultClusterParameters</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeEngineDefaultClusterParametersInput`](crate::input::DescribeEngineDefaultClusterParametersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeEngineDefaultClusterParametersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeEngineDefaultClusterParametersInput {
                db_parameter_group_family: self.db_parameter_group_family,
                filters: self.filters,
                max_records: self.max_records,
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeEngineDefaultClusterParametersInputOperationOutputAlias =
    crate::operation::DescribeEngineDefaultClusterParameters;
#[doc(hidden)]
pub type DescribeEngineDefaultClusterParametersInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeEngineDefaultClusterParametersInput {
    /// Consumes the builder and constructs an Operation<[`DescribeEngineDefaultClusterParameters`](crate::operation::DescribeEngineDefaultClusterParameters)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeEngineDefaultClusterParameters,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeEngineDefaultClusterParametersInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeEngineDefaultClusterParametersInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_engine_default_cluster_parameters(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeEngineDefaultClusterParameters::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeEngineDefaultClusterParameters",
            "rds",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeEngineDefaultClusterParametersInput`](crate::input::DescribeEngineDefaultClusterParametersInput)
    pub fn builder() -> crate::input::describe_engine_default_cluster_parameters_input::Builder {
        crate::input::describe_engine_default_cluster_parameters_input::Builder::default()
    }
}

/// See [`DescribeEngineDefaultParametersInput`](crate::input::DescribeEngineDefaultParametersInput)
pub mod describe_engine_default_parameters_input {
    /// A builder for [`DescribeEngineDefaultParametersInput`](crate::input::DescribeEngineDefaultParametersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_parameter_group_family: std::option::Option<std::string::String>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the DB parameter group family.</p>
        /// <p>Valid Values:</p>
        /// <ul>
        /// <li> <p> <code>aurora5.6</code> </p> </li>
        /// <li> <p> <code>aurora-mysql5.7</code> </p> </li>
        /// <li> <p> <code>aurora-mysql8.0</code> </p> </li>
        /// <li> <p> <code>aurora-postgresql10</code> </p> </li>
        /// <li> <p> <code>aurora-postgresql11</code> </p> </li>
        /// <li> <p> <code>aurora-postgresql12</code> </p> </li>
        /// <li> <p> <code>aurora-postgresql13</code> </p> </li>
        /// <li> <p> <code>mariadb10.2</code> </p> </li>
        /// <li> <p> <code>mariadb10.3</code> </p> </li>
        /// <li> <p> <code>mariadb10.4</code> </p> </li>
        /// <li> <p> <code>mariadb10.5</code> </p> </li>
        /// <li> <p> <code>mariadb10.6</code> </p> </li>
        /// <li> <p> <code>mysql5.7</code> </p> </li>
        /// <li> <p> <code>mysql8.0</code> </p> </li>
        /// <li> <p> <code>postgres10</code> </p> </li>
        /// <li> <p> <code>postgres11</code> </p> </li>
        /// <li> <p> <code>postgres12</code> </p> </li>
        /// <li> <p> <code>postgres13</code> </p> </li>
        /// <li> <p> <code>postgres14</code> </p> </li>
        /// <li> <p> <code>sqlserver-ee-11.0</code> </p> </li>
        /// <li> <p> <code>sqlserver-ee-12.0</code> </p> </li>
        /// <li> <p> <code>sqlserver-ee-13.0</code> </p> </li>
        /// <li> <p> <code>sqlserver-ee-14.0</code> </p> </li>
        /// <li> <p> <code>sqlserver-ee-15.0</code> </p> </li>
        /// <li> <p> <code>sqlserver-ex-11.0</code> </p> </li>
        /// <li> <p> <code>sqlserver-ex-12.0</code> </p> </li>
        /// <li> <p> <code>sqlserver-ex-13.0</code> </p> </li>
        /// <li> <p> <code>sqlserver-ex-14.0</code> </p> </li>
        /// <li> <p> <code>sqlserver-ex-15.0</code> </p> </li>
        /// <li> <p> <code>sqlserver-se-11.0</code> </p> </li>
        /// <li> <p> <code>sqlserver-se-12.0</code> </p> </li>
        /// <li> <p> <code>sqlserver-se-13.0</code> </p> </li>
        /// <li> <p> <code>sqlserver-se-14.0</code> </p> </li>
        /// <li> <p> <code>sqlserver-se-15.0</code> </p> </li>
        /// <li> <p> <code>sqlserver-web-11.0</code> </p> </li>
        /// <li> <p> <code>sqlserver-web-12.0</code> </p> </li>
        /// <li> <p> <code>sqlserver-web-13.0</code> </p> </li>
        /// <li> <p> <code>sqlserver-web-14.0</code> </p> </li>
        /// <li> <p> <code>sqlserver-web-15.0</code> </p> </li>
        /// </ul>
        pub fn db_parameter_group_family(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_parameter_group_family = Some(input.into());
            self
        }
        /// <p>The name of the DB parameter group family.</p>
        /// <p>Valid Values:</p>
        /// <ul>
        /// <li> <p> <code>aurora5.6</code> </p> </li>
        /// <li> <p> <code>aurora-mysql5.7</code> </p> </li>
        /// <li> <p> <code>aurora-mysql8.0</code> </p> </li>
        /// <li> <p> <code>aurora-postgresql10</code> </p> </li>
        /// <li> <p> <code>aurora-postgresql11</code> </p> </li>
        /// <li> <p> <code>aurora-postgresql12</code> </p> </li>
        /// <li> <p> <code>aurora-postgresql13</code> </p> </li>
        /// <li> <p> <code>mariadb10.2</code> </p> </li>
        /// <li> <p> <code>mariadb10.3</code> </p> </li>
        /// <li> <p> <code>mariadb10.4</code> </p> </li>
        /// <li> <p> <code>mariadb10.5</code> </p> </li>
        /// <li> <p> <code>mariadb10.6</code> </p> </li>
        /// <li> <p> <code>mysql5.7</code> </p> </li>
        /// <li> <p> <code>mysql8.0</code> </p> </li>
        /// <li> <p> <code>postgres10</code> </p> </li>
        /// <li> <p> <code>postgres11</code> </p> </li>
        /// <li> <p> <code>postgres12</code> </p> </li>
        /// <li> <p> <code>postgres13</code> </p> </li>
        /// <li> <p> <code>postgres14</code> </p> </li>
        /// <li> <p> <code>sqlserver-ee-11.0</code> </p> </li>
        /// <li> <p> <code>sqlserver-ee-12.0</code> </p> </li>
        /// <li> <p> <code>sqlserver-ee-13.0</code> </p> </li>
        /// <li> <p> <code>sqlserver-ee-14.0</code> </p> </li>
        /// <li> <p> <code>sqlserver-ee-15.0</code> </p> </li>
        /// <li> <p> <code>sqlserver-ex-11.0</code> </p> </li>
        /// <li> <p> <code>sqlserver-ex-12.0</code> </p> </li>
        /// <li> <p> <code>sqlserver-ex-13.0</code> </p> </li>
        /// <li> <p> <code>sqlserver-ex-14.0</code> </p> </li>
        /// <li> <p> <code>sqlserver-ex-15.0</code> </p> </li>
        /// <li> <p> <code>sqlserver-se-11.0</code> </p> </li>
        /// <li> <p> <code>sqlserver-se-12.0</code> </p> </li>
        /// <li> <p> <code>sqlserver-se-13.0</code> </p> </li>
        /// <li> <p> <code>sqlserver-se-14.0</code> </p> </li>
        /// <li> <p> <code>sqlserver-se-15.0</code> </p> </li>
        /// <li> <p> <code>sqlserver-web-11.0</code> </p> </li>
        /// <li> <p> <code>sqlserver-web-12.0</code> </p> </li>
        /// <li> <p> <code>sqlserver-web-13.0</code> </p> </li>
        /// <li> <p> <code>sqlserver-web-14.0</code> </p> </li>
        /// <li> <p> <code>sqlserver-web-15.0</code> </p> </li>
        /// </ul>
        pub fn set_db_parameter_group_family(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_parameter_group_family = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>This parameter isn't currently supported.</p>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input);
            self.filters = Some(v);
            self
        }
        /// <p>This parameter isn't currently supported.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so you can retrieve the remaining results.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so you can retrieve the remaining results.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p>An optional pagination token provided by a previous <code>DescribeEngineDefaultParameters</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An optional pagination token provided by a previous <code>DescribeEngineDefaultParameters</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeEngineDefaultParametersInput`](crate::input::DescribeEngineDefaultParametersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeEngineDefaultParametersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeEngineDefaultParametersInput {
                db_parameter_group_family: self.db_parameter_group_family,
                filters: self.filters,
                max_records: self.max_records,
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeEngineDefaultParametersInputOperationOutputAlias =
    crate::operation::DescribeEngineDefaultParameters;
#[doc(hidden)]
pub type DescribeEngineDefaultParametersInputOperationRetryAlias =
    aws_http::retry::AwsErrorRetryPolicy;
impl DescribeEngineDefaultParametersInput {
    /// Consumes the builder and constructs an Operation<[`DescribeEngineDefaultParameters`](crate::operation::DescribeEngineDefaultParameters)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeEngineDefaultParameters,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeEngineDefaultParametersInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeEngineDefaultParametersInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_engine_default_parameters(&self)?
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeEngineDefaultParameters::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeEngineDefaultParameters",
            "rds",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeEngineDefaultParametersInput`](crate::input::DescribeEngineDefaultParametersInput)
    pub fn builder() -> crate::input::describe_engine_default_parameters_input::Builder {
        crate::input::describe_engine_default_parameters_input::Builder::default()
    }
}

/// See [`DescribeEventCategoriesInput`](crate::input::DescribeEventCategoriesInput)
pub mod describe_event_categories_input {
    /// A builder for [`DescribeEventCategoriesInput`](crate::input::DescribeEventCategoriesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_type: std::option::Option<std::string::String>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    }
    impl Builder {
        /// <p>The type of source that is generating the events. For RDS Proxy events, specify <code>db-proxy</code>.</p>
        /// <p>Valid values: <code>db-instance</code> | <code>db-cluster</code> | <code>db-parameter-group</code> | <code>db-security-group</code> | <code>db-snapshot</code> | <code>db-cluster-snapshot</code> | <code>db-proxy</code> </p>
        pub fn source_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_type = Some(input.into());
            self
        }
        /// <p>The type of source that is generating the events. For RDS Proxy events, specify <code>db-proxy</code>.</p>
        /// <p>Valid values: <code>db-instance</code> | <code>db-cluster</code> | <code>db-parameter-group</code> | <code>db-security-group</code> | <code>db-snapshot</code> | <code>db-cluster-snapshot</code> | <code>db-proxy</code> </p>
        pub fn set_source_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source_type = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>This parameter isn't currently supported.</p>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input);
            self.filters = Some(v);
            self
        }
        /// <p>This parameter isn't currently supported.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeEventCategoriesInput`](crate::input::DescribeEventCategoriesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeEventCategoriesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeEventCategoriesInput {
                source_type: self.source_type,
                filters: self.filters,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeEventCategoriesInputOperationOutputAlias =
    crate::operation::DescribeEventCategories;
#[doc(hidden)]
pub type DescribeEventCategoriesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeEventCategoriesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeEventCategories`](crate::operation::DescribeEventCategories)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeEventCategories,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeEventCategoriesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeEventCategoriesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_event_categories(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeEventCategories::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeEventCategories",
            "rds",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeEventCategoriesInput`](crate::input::DescribeEventCategoriesInput)
    pub fn builder() -> crate::input::describe_event_categories_input::Builder {
        crate::input::describe_event_categories_input::Builder::default()
    }
}

/// See [`DescribeEventsInput`](crate::input::DescribeEventsInput)
pub mod describe_events_input {
    /// A builder for [`DescribeEventsInput`](crate::input::DescribeEventsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_identifier: std::option::Option<std::string::String>,
        pub(crate) source_type: std::option::Option<crate::model::SourceType>,
        pub(crate) start_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) end_time: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) duration: std::option::Option<i32>,
        pub(crate) event_categories: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier of the event source for which events are returned. If not specified, then all sources are included in the response.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>If <code>SourceIdentifier</code> is supplied, <code>SourceType</code> must also be provided.</p> </li>
        /// <li> <p>If the source type is a DB instance, a <code>DBInstanceIdentifier</code> value must be supplied.</p> </li>
        /// <li> <p>If the source type is a DB cluster, a <code>DBClusterIdentifier</code> value must be supplied.</p> </li>
        /// <li> <p>If the source type is a DB parameter group, a <code>DBParameterGroupName</code> value must be supplied.</p> </li>
        /// <li> <p>If the source type is a DB security group, a <code>DBSecurityGroupName</code> value must be supplied.</p> </li>
        /// <li> <p>If the source type is a DB snapshot, a <code>DBSnapshotIdentifier</code> value must be supplied.</p> </li>
        /// <li> <p>If the source type is a DB cluster snapshot, a <code>DBClusterSnapshotIdentifier</code> value must be supplied.</p> </li>
        /// <li> <p>If the source type is an RDS Proxy, a <code>DBProxyName</code> value must be supplied.</p> </li>
        /// <li> <p>Can't end with a hyphen or contain two consecutive hyphens.</p> </li>
        /// </ul>
        pub fn source_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_identifier = Some(input.into());
            self
        }
        /// <p>The identifier of the event source for which events are returned. If not specified, then all sources are included in the response.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>If <code>SourceIdentifier</code> is supplied, <code>SourceType</code> must also be provided.</p> </li>
        /// <li> <p>If the source type is a DB instance, a <code>DBInstanceIdentifier</code> value must be supplied.</p> </li>
        /// <li> <p>If the source type is a DB cluster, a <code>DBClusterIdentifier</code> value must be supplied.</p> </li>
        /// <li> <p>If the source type is a DB parameter group, a <code>DBParameterGroupName</code> value must be supplied.</p> </li>
        /// <li> <p>If the source type is a DB security group, a <code>DBSecurityGroupName</code> value must be supplied.</p> </li>
        /// <li> <p>If the source type is a DB snapshot, a <code>DBSnapshotIdentifier</code> value must be supplied.</p> </li>
        /// <li> <p>If the source type is a DB cluster snapshot, a <code>DBClusterSnapshotIdentifier</code> value must be supplied.</p> </li>
        /// <li> <p>If the source type is an RDS Proxy, a <code>DBProxyName</code> value must be supplied.</p> </li>
        /// <li> <p>Can't end with a hyphen or contain two consecutive hyphens.</p> </li>
        /// </ul>
        pub fn set_source_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_identifier = input;
            self
        }
        /// <p>The event source to retrieve events for. If no value is specified, all events are returned.</p>
        pub fn source_type(mut self, input: crate::model::SourceType) -> Self {
            self.source_type = Some(input);
            self
        }
        /// <p>The event source to retrieve events for. If no value is specified, all events are returned.</p>
        pub fn set_source_type(
            mut self,
            input: std::option::Option<crate::model::SourceType>,
        ) -> Self {
            self.source_type = input;
            self
        }
        /// <p>The beginning of the time interval to retrieve events for, specified in ISO 8601 format. For more information about ISO 8601, go to the <a href="http://en.wikipedia.org/wiki/ISO_8601">ISO8601 Wikipedia page.</a> </p>
        /// <p>Example: 2009-07-08T18:00Z</p>
        pub fn start_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.start_time = Some(input);
            self
        }
        /// <p>The beginning of the time interval to retrieve events for, specified in ISO 8601 format. For more information about ISO 8601, go to the <a href="http://en.wikipedia.org/wiki/ISO_8601">ISO8601 Wikipedia page.</a> </p>
        /// <p>Example: 2009-07-08T18:00Z</p>
        pub fn set_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The end of the time interval for which to retrieve events, specified in ISO 8601 format. For more information about ISO 8601, go to the <a href="http://en.wikipedia.org/wiki/ISO_8601">ISO8601 Wikipedia page.</a> </p>
        /// <p>Example: 2009-07-08T18:00Z</p>
        pub fn end_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.end_time = Some(input);
            self
        }
        /// <p>The end of the time interval for which to retrieve events, specified in ISO 8601 format. For more information about ISO 8601, go to the <a href="http://en.wikipedia.org/wiki/ISO_8601">ISO8601 Wikipedia page.</a> </p>
        /// <p>Example: 2009-07-08T18:00Z</p>
        pub fn set_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.end_time = input;
            self
        }
        /// <p>The number of minutes to retrieve events for.</p>
        /// <p>Default: 60</p>
        pub fn duration(mut self, input: i32) -> Self {
            self.duration = Some(input);
            self
        }
        /// <p>The number of minutes to retrieve events for.</p>
        /// <p>Default: 60</p>
        pub fn set_duration(mut self, input: std::option::Option<i32>) -> Self {
            self.duration = input;
            self
        }
        /// Appends an item to `event_categories`.
        ///
        /// To override the contents of this collection use [`set_event_categories`](Self::set_event_categories).
        ///
        /// <p>A list of event categories that trigger notifications for a event notification subscription.</p>
        pub fn event_categories(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.event_categories.unwrap_or_default();
            v.push(input.into());
            self.event_categories = Some(v);
            self
        }
        /// <p>A list of event categories that trigger notifications for a event notification subscription.</p>
        pub fn set_event_categories(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.event_categories = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>This parameter isn't currently supported.</p>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input);
            self.filters = Some(v);
            self
        }
        /// <p>This parameter isn't currently supported.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that you can retrieve the remaining results.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that you can retrieve the remaining results.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p>An optional pagination token provided by a previous DescribeEvents request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An optional pagination token provided by a previous DescribeEvents request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeEventsInput`](crate::input::DescribeEventsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeEventsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeEventsInput {
                source_identifier: self.source_identifier,
                source_type: self.source_type,
                start_time: self.start_time,
                end_time: self.end_time,
                duration: self.duration,
                event_categories: self.event_categories,
                filters: self.filters,
                max_records: self.max_records,
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeEventsInputOperationOutputAlias = crate::operation::DescribeEvents;
#[doc(hidden)]
pub type DescribeEventsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeEventsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeEvents`](crate::operation::DescribeEvents)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeEvents,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeEventsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeEventsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_events(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeEvents::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeEvents",
            "rds",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeEventsInput`](crate::input::DescribeEventsInput)
    pub fn builder() -> crate::input::describe_events_input::Builder {
        crate::input::describe_events_input::Builder::default()
    }
}

/// See [`DescribeEventSubscriptionsInput`](crate::input::DescribeEventSubscriptionsInput)
pub mod describe_event_subscriptions_input {
    /// A builder for [`DescribeEventSubscriptionsInput`](crate::input::DescribeEventSubscriptionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) subscription_name: std::option::Option<std::string::String>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) max_records: std::option::Option<i32>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the RDS event notification subscription you want to describe.</p>
        pub fn subscription_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.subscription_name = Some(input.into());
            self
        }
        /// <p>The name of the RDS event notification subscription you want to describe.</p>
        pub fn set_subscription_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.subscription_name = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>This parameter isn't currently supported.</p>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input);
            self.filters = Some(v);
            self
        }
        /// <p>This parameter isn't currently supported.</p>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that you can retrieve the remaining results.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that you can retrieve the remaining results.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// <p>An optional pagination token provided by a previous DescribeOrderableDBInstanceOptions request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code> .</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An optional pagination token provided by a previous DescribeOrderableDBInstanceOptions request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code> .</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeEventSubscriptionsInput`](crate::input::DescribeEventSubscriptionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeEventSubscriptionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeEventSubscriptionsInput {
                subscription_name: self.subscription_name,
                filters: self.filters,
                max_records: self.max_records,
                marker: self.marker,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeEventSubscriptionsInputOperationOutputAlias =
    crate::operation::DescribeEventSubscriptions;
#[doc(hidden)]
pub type DescribeEventSubscriptionsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeEventSubscriptionsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeEventSubscriptions`](crate::operation::DescribeEventSubscriptions)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeEventSubscriptions,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeEventSubscriptionsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeEventSubscriptionsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/x-www-form-urlencoded",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_describe_event_subscriptions(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeEventSubscriptions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeEventSubscriptions",
            "rds",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeEventSubscriptionsInput`](crate::input::DescribeEventSubscriptionsInput)
    pub fn builder() -> crate::input::describe_event_subscriptions_input::Builder {
        crate::input::describe_event_subscriptions_input::Builder::default()
    }
}

/// See [`DescribeExportTasksInput`](crate::input::DescribeExportTasksInput)
pub mod describe_export_tasks_input {
    /// A builder for [`DescribeExportTasksInput`](crate::input::DescribeExportTasksInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) export_task_identifier: std::option::Option<std::string::String>,
        pub(crate) source_arn: std::option::Option<std::string::String>,
        pub(crate) filters: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) max_records: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The identifier of the snapshot export task to be described.</p>
        pub fn export_task_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.export_task_identifier = Some(input.into());
            self
        }
        /// <p>The identifier of the snapshot export task to be described.</p>
        pub fn set_export_task_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.export_task_identifier = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the snapshot exported to Amazon S3.</p>
        pub fn source_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the snapshot exported to Amazon S3.</p>
        pub fn set_source_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source_arn = input;
            self
        }
        /// Appends an item to `filters`.
        ///
        /// To override the contents of this collection use [`set_filters`](Self::set_filters).
        ///
        /// <p>Filters specify one or more snapshot exports to describe. The filters are specified as name-value pairs that define what to include in the output. Filter names and values are case-sensitive.</p>
        /// <p>Supported filters include the following:</p>
        /// <ul>
        /// <li> <p> <code>export-task-identifier</code> - An identifier for the snapshot export task.</p> </li>
        /// <li> <p> <code>s3-bucket</code> - The Amazon S3 bucket the snapshot is exported to.</p> </li>
        /// <li> <p> <code>source-arn</code> - The Amazon Resource Name (ARN) of the snapshot exported to Amazon S3</p> </li>
        /// <li> <p> <code>status</code> - The status of the export task. Must be lowercase. Valid statuses are the following:</p>
        /// <ul>
        /// <li> <p> <code>canceled</code> </p> </li>
        /// <li> <p> <code>canceling</code> </p> </li>
        /// <li> <p> <code>complete</code> </p> </li>
        /// <li> <p> <code>failed</code> </p> </li>
        /// <li> <p> <code>in_progress</code> </p> </li>
        /// <li> <p> <code>starting</code> </p> </li>
        /// </ul> </li>
        /// </ul>
        pub fn filters(mut self, input: crate::model::Filter) -> Self {
            let mut v = self.filters.unwrap_or_default();
            v.push(input);
            self.filters = Some(v);
            self
        }
        /// <p>Filters specify one or more snapshot exports to describe. The filters are specified as name-value pairs that define what to include in the output. Filter names and values are case-sensitive.</p>
        /// <p>Supported filters include the following:</p>
        /// <ul>
        /// <li> <p> <code>export-task-identifier</code> - An identifier for the snapshot export task.</p> </li>
        /// <li> <p> <code>s3-bucket</code> - The Amazon S3 bucket the snapshot is exported to.</p> </li>
        /// <li> <p> <code>source-arn</code> - The Amazon Resource Name (ARN) of the snapshot exported to Amazon S3</p> </li>
        /// <li> <p> <code>status</code> - The status of the export task. Must be lowercase. Valid statuses are the following:</p>
        /// <ul>
        /// <li> <p> <code>canceled</code> </p> </li>
        /// <li> <p> <code>canceling</code> </p> </li>
        /// <li> <p> <code>complete</code> </p> </li>
        /// <li> <p> <code>failed</code> </p> </li>
        /// <li> <p> <code>in_progress</code> </p> </li>
        /// <li> <p> <code>starting</code> </p> </li>
        /// </ul> </li>
        /// </ul>
        pub fn set_filters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filters = input;
            self
        }
        /// <p>An optional pagination token provided by a previous <code>DescribeExportTasks</code> request. If you specify this parameter, the response includes only records beyond the marker, up to the value specified by the <code>MaxRecords</code> parameter.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An optional pagination token provided by a previous <code>DescribeExportTasks</code> request. If you specify this parameter, the response includes only records beyond the marker, up to the value specified by the <code>MaxRecords</code> parameter.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified value, a pagination token called a marker is included in the response. You can use the marker in a later <code>DescribeExportTasks</code> request to retrieve the remaining results.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn max_records(mut self, input: i32) -> Self {
            self.max_records = Some(input);
            self
        }
        /// <p>The maximum number of records to include in the response. If more records exist than the specified value, a pagination token called a marker is included in the response. You can use the marker in a later <code>DescribeExportTasks</code> request to retrieve the remaining results.</p>
        /// <p>Default: 100</p>
        /// <p>Constraints: Minimum 20, maximum 100.</p>
        pub fn set_max_records(mut self, input: std::option::Option<i32>) -> Self {
            self.max_records = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeExportTasksInput`](crate::input::DescribeExportTasksInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeExportTasksInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeExportTasksInput {
                export_task_identifier: self.export_task_identifier,
                source_arn: self.source_arn,
                filters: self.filters,
                marker: self.marker,
                max_records: self.max_records,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeExportTasksInputOperationOutputAlias = crate::operation::DescribeExportTasks;
#[doc(hidden)]
pub type DescribeExportTasksInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeExportTasksInput {
    /// Consumes the builder and constructs an Operation<[`DescribeExportTasks`](crate::operation::DescribeExportTasks)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeExportTasks,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeExportTasksInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
