// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(clippy::unnecessary_wraps)]
pub fn parse_add_role_to_db_cluster_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AddRoleToDbClusterOutput,
    crate::error::AddRoleToDBClusterError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::AddRoleToDBClusterError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::AddRoleToDBClusterError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DBClusterNotFoundFault" => crate::error::AddRoleToDBClusterError {
            meta: generic,
            kind: crate::error::AddRoleToDBClusterErrorKind::DbClusterNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::db_cluster_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_cluster_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::AddRoleToDBClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DBClusterRoleAlreadyExists" => crate::error::AddRoleToDBClusterError {
            meta: generic,
            kind: crate::error::AddRoleToDBClusterErrorKind::DbClusterRoleAlreadyExistsFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::db_cluster_role_already_exists_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_cluster_role_already_exists_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::AddRoleToDBClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DBClusterRoleQuotaExceeded" => crate::error::AddRoleToDBClusterError {
            meta: generic,
            kind: crate::error::AddRoleToDBClusterErrorKind::DbClusterRoleQuotaExceededFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::db_cluster_role_quota_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_cluster_role_quota_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::AddRoleToDBClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidDBClusterStateFault" => crate::error::AddRoleToDBClusterError {
            meta: generic,
            kind: crate::error::AddRoleToDBClusterErrorKind::InvalidDbClusterStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_db_cluster_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_db_cluster_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::AddRoleToDBClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::AddRoleToDBClusterError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_add_role_to_db_cluster_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AddRoleToDbClusterOutput,
    crate::error::AddRoleToDBClusterError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::add_role_to_db_cluster_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_add_role_to_db_instance_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AddRoleToDbInstanceOutput,
    crate::error::AddRoleToDBInstanceError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::AddRoleToDBInstanceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::AddRoleToDBInstanceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DBInstanceNotFound" => crate::error::AddRoleToDBInstanceError {
            meta: generic,
            kind: crate::error::AddRoleToDBInstanceErrorKind::DbInstanceNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::db_instance_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_instance_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::AddRoleToDBInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DBInstanceRoleAlreadyExists" => crate::error::AddRoleToDBInstanceError {
            meta: generic,
            kind: crate::error::AddRoleToDBInstanceErrorKind::DbInstanceRoleAlreadyExistsFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::db_instance_role_already_exists_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_instance_role_already_exists_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::AddRoleToDBInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DBInstanceRoleQuotaExceeded" => crate::error::AddRoleToDBInstanceError {
            meta: generic,
            kind: crate::error::AddRoleToDBInstanceErrorKind::DbInstanceRoleQuotaExceededFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::db_instance_role_quota_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_instance_role_quota_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::AddRoleToDBInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidDBInstanceState" => crate::error::AddRoleToDBInstanceError {
            meta: generic,
            kind: crate::error::AddRoleToDBInstanceErrorKind::InvalidDbInstanceStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_db_instance_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_db_instance_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::AddRoleToDBInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::AddRoleToDBInstanceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_add_role_to_db_instance_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AddRoleToDbInstanceOutput,
    crate::error::AddRoleToDBInstanceError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::add_role_to_db_instance_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_add_source_identifier_to_subscription_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AddSourceIdentifierToSubscriptionOutput,
    crate::error::AddSourceIdentifierToSubscriptionError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::AddSourceIdentifierToSubscriptionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::AddSourceIdentifierToSubscriptionError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "SourceNotFound" => crate::error::AddSourceIdentifierToSubscriptionError {
            meta: generic,
            kind: crate::error::AddSourceIdentifierToSubscriptionErrorKind::SourceNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::source_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_source_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::AddSourceIdentifierToSubscriptionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "SubscriptionNotFound" => crate::error::AddSourceIdentifierToSubscriptionError {
            meta: generic,
            kind:
                crate::error::AddSourceIdentifierToSubscriptionErrorKind::SubscriptionNotFoundFault(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::subscription_not_found_fault::Builder::default();
                            let _ = response;
                            output = crate::xml_deser::deser_structure_crate_error_subscription_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::AddSourceIdentifierToSubscriptionError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        _ => crate::error::AddSourceIdentifierToSubscriptionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_add_source_identifier_to_subscription_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AddSourceIdentifierToSubscriptionOutput,
    crate::error::AddSourceIdentifierToSubscriptionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::add_source_identifier_to_subscription_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_add_source_identifier_to_subscription(response.body().as_ref(), output).map_err(crate::error::AddSourceIdentifierToSubscriptionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_add_tags_to_resource_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::AddTagsToResourceOutput, crate::error::AddTagsToResourceError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::AddTagsToResourceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::AddTagsToResourceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DBClusterNotFoundFault" => crate::error::AddTagsToResourceError {
            meta: generic,
            kind: crate::error::AddTagsToResourceErrorKind::DbClusterNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::db_cluster_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_cluster_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::AddTagsToResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DBInstanceNotFound" => crate::error::AddTagsToResourceError {
            meta: generic,
            kind: crate::error::AddTagsToResourceErrorKind::DbInstanceNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::db_instance_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_instance_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::AddTagsToResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DBProxyNotFoundFault" => crate::error::AddTagsToResourceError {
            meta: generic,
            kind: crate::error::AddTagsToResourceErrorKind::DbProxyNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::db_proxy_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_proxy_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::AddTagsToResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DBProxyTargetGroupNotFoundFault" => crate::error::AddTagsToResourceError {
            meta: generic,
            kind: crate::error::AddTagsToResourceErrorKind::DbProxyTargetGroupNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::db_proxy_target_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_proxy_target_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::AddTagsToResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DBSnapshotNotFound" => crate::error::AddTagsToResourceError {
            meta: generic,
            kind: crate::error::AddTagsToResourceErrorKind::DbSnapshotNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::db_snapshot_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_snapshot_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::AddTagsToResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::AddTagsToResourceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_add_tags_to_resource_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::AddTagsToResourceOutput, crate::error::AddTagsToResourceError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::add_tags_to_resource_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_apply_pending_maintenance_action_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ApplyPendingMaintenanceActionOutput,
    crate::error::ApplyPendingMaintenanceActionError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ApplyPendingMaintenanceActionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ApplyPendingMaintenanceActionError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidDBClusterStateFault" => crate::error::ApplyPendingMaintenanceActionError {
            meta: generic,
            kind: crate::error::ApplyPendingMaintenanceActionErrorKind::InvalidDbClusterStateFault(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::invalid_db_cluster_state_fault::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_invalid_db_cluster_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ApplyPendingMaintenanceActionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "InvalidDBInstanceState" => crate::error::ApplyPendingMaintenanceActionError {
            meta: generic,
            kind: crate::error::ApplyPendingMaintenanceActionErrorKind::InvalidDbInstanceStateFault(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::invalid_db_instance_state_fault::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_invalid_db_instance_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ApplyPendingMaintenanceActionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "ResourceNotFoundFault" => crate::error::ApplyPendingMaintenanceActionError {
            meta: generic,
            kind: crate::error::ApplyPendingMaintenanceActionErrorKind::ResourceNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resource_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ApplyPendingMaintenanceActionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ApplyPendingMaintenanceActionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_apply_pending_maintenance_action_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ApplyPendingMaintenanceActionOutput,
    crate::error::ApplyPendingMaintenanceActionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::apply_pending_maintenance_action_output::Builder::default();
        let _ = response;
        output =
            crate::xml_deser::deser_operation_crate_operation_apply_pending_maintenance_action(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::ApplyPendingMaintenanceActionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_authorize_db_security_group_ingress_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AuthorizeDbSecurityGroupIngressOutput,
    crate::error::AuthorizeDBSecurityGroupIngressError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::AuthorizeDBSecurityGroupIngressError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::AuthorizeDBSecurityGroupIngressError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AuthorizationAlreadyExists" => crate::error::AuthorizeDBSecurityGroupIngressError { meta: generic, kind: crate::error::AuthorizeDBSecurityGroupIngressErrorKind::AuthorizationAlreadyExistsFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::authorization_already_exists_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_authorization_already_exists_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::AuthorizeDBSecurityGroupIngressError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "AuthorizationQuotaExceeded" => crate::error::AuthorizeDBSecurityGroupIngressError { meta: generic, kind: crate::error::AuthorizeDBSecurityGroupIngressErrorKind::AuthorizationQuotaExceededFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::authorization_quota_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_authorization_quota_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::AuthorizeDBSecurityGroupIngressError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "DBSecurityGroupNotFound" => crate::error::AuthorizeDBSecurityGroupIngressError { meta: generic, kind: crate::error::AuthorizeDBSecurityGroupIngressErrorKind::DbSecurityGroupNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::db_security_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_security_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::AuthorizeDBSecurityGroupIngressError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidDBSecurityGroupState" => crate::error::AuthorizeDBSecurityGroupIngressError { meta: generic, kind: crate::error::AuthorizeDBSecurityGroupIngressErrorKind::InvalidDbSecurityGroupStateFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_db_security_group_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_db_security_group_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::AuthorizeDBSecurityGroupIngressError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::AuthorizeDBSecurityGroupIngressError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_authorize_db_security_group_ingress_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::AuthorizeDbSecurityGroupIngressOutput,
    crate::error::AuthorizeDBSecurityGroupIngressError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::authorize_db_security_group_ingress_output::Builder::default();
        let _ = response;
        output =
            crate::xml_deser::deser_operation_crate_operation_authorize_db_security_group_ingress(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::AuthorizeDBSecurityGroupIngressError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_backtrack_db_cluster_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::BacktrackDbClusterOutput,
    crate::error::BacktrackDBClusterError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::BacktrackDBClusterError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::BacktrackDBClusterError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DBClusterNotFoundFault" => crate::error::BacktrackDBClusterError {
            meta: generic,
            kind: crate::error::BacktrackDBClusterErrorKind::DbClusterNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::db_cluster_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_cluster_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::BacktrackDBClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidDBClusterStateFault" => crate::error::BacktrackDBClusterError {
            meta: generic,
            kind: crate::error::BacktrackDBClusterErrorKind::InvalidDbClusterStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_db_cluster_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_db_cluster_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::BacktrackDBClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::BacktrackDBClusterError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_backtrack_db_cluster_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::BacktrackDbClusterOutput,
    crate::error::BacktrackDBClusterError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::backtrack_db_cluster_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_backtrack_db_cluster(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::BacktrackDBClusterError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_cancel_export_task_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CancelExportTaskOutput, crate::error::CancelExportTaskError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CancelExportTaskError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CancelExportTaskError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ExportTaskNotFound" => crate::error::CancelExportTaskError {
            meta: generic,
            kind: crate::error::CancelExportTaskErrorKind::ExportTaskNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::export_task_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_export_task_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CancelExportTaskError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidExportTaskStateFault" => crate::error::CancelExportTaskError {
            meta: generic,
            kind: crate::error::CancelExportTaskErrorKind::InvalidExportTaskStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_export_task_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_export_task_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CancelExportTaskError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CancelExportTaskError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_cancel_export_task_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CancelExportTaskOutput, crate::error::CancelExportTaskError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::cancel_export_task_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_cancel_export_task(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CancelExportTaskError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_copy_db_cluster_parameter_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CopyDbClusterParameterGroupOutput,
    crate::error::CopyDBClusterParameterGroupError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CopyDBClusterParameterGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CopyDBClusterParameterGroupError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DBParameterGroupAlreadyExists" => crate::error::CopyDBClusterParameterGroupError { meta: generic, kind: crate::error::CopyDBClusterParameterGroupErrorKind::DbParameterGroupAlreadyExistsFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::db_parameter_group_already_exists_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_parameter_group_already_exists_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CopyDBClusterParameterGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "DBParameterGroupNotFound" => crate::error::CopyDBClusterParameterGroupError { meta: generic, kind: crate::error::CopyDBClusterParameterGroupErrorKind::DbParameterGroupNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::db_parameter_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_parameter_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CopyDBClusterParameterGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "DBParameterGroupQuotaExceeded" => crate::error::CopyDBClusterParameterGroupError { meta: generic, kind: crate::error::CopyDBClusterParameterGroupErrorKind::DbParameterGroupQuotaExceededFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::db_parameter_group_quota_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_parameter_group_quota_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CopyDBClusterParameterGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::CopyDBClusterParameterGroupError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_copy_db_cluster_parameter_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CopyDbClusterParameterGroupOutput,
    crate::error::CopyDBClusterParameterGroupError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::copy_db_cluster_parameter_group_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_copy_db_cluster_parameter_group(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CopyDBClusterParameterGroupError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_copy_db_cluster_snapshot_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CopyDbClusterSnapshotOutput,
    crate::error::CopyDBClusterSnapshotError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CopyDBClusterSnapshotError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CopyDBClusterSnapshotError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DBClusterSnapshotAlreadyExistsFault" => crate::error::CopyDBClusterSnapshotError {
            meta: generic,
            kind: crate::error::CopyDBClusterSnapshotErrorKind::DbClusterSnapshotAlreadyExistsFault(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]let mut output = crate::error::db_cluster_snapshot_already_exists_fault::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_db_cluster_snapshot_already_exists_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CopyDBClusterSnapshotError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "DBClusterSnapshotNotFoundFault" => crate::error::CopyDBClusterSnapshotError {
            meta: generic,
            kind: crate::error::CopyDBClusterSnapshotErrorKind::DbClusterSnapshotNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::db_cluster_snapshot_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_cluster_snapshot_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CopyDBClusterSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidDBClusterSnapshotStateFault" => {
            crate::error::CopyDBClusterSnapshotError {
                meta: generic,
                kind:
                    crate::error::CopyDBClusterSnapshotErrorKind::InvalidDbClusterSnapshotStateFault(
                        {
                            #[allow(unused_mut)]
                            let mut tmp = {
                                #[allow(unused_mut)]let mut output = crate::error::invalid_db_cluster_snapshot_state_fault::Builder::default();
                                let _ = response;
                                output = crate::xml_deser::deser_structure_crate_error_invalid_db_cluster_snapshot_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CopyDBClusterSnapshotError::unhandled)?;
                                output.build()
                            };
                            if (&tmp.message).is_none() {
                                tmp.message = _error_message;
                            }
                            tmp
                        },
                    ),
            }
        }
        "InvalidDBClusterStateFault" => crate::error::CopyDBClusterSnapshotError {
            meta: generic,
            kind: crate::error::CopyDBClusterSnapshotErrorKind::InvalidDbClusterStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_db_cluster_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_db_cluster_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CopyDBClusterSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSKeyNotAccessibleFault" => crate::error::CopyDBClusterSnapshotError {
            meta: generic,
            kind: crate::error::CopyDBClusterSnapshotErrorKind::KmsKeyNotAccessibleFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_key_not_accessible_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_kms_key_not_accessible_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CopyDBClusterSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "SnapshotQuotaExceeded" => crate::error::CopyDBClusterSnapshotError {
            meta: generic,
            kind: crate::error::CopyDBClusterSnapshotErrorKind::SnapshotQuotaExceededFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::snapshot_quota_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_snapshot_quota_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CopyDBClusterSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CopyDBClusterSnapshotError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_copy_db_cluster_snapshot_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CopyDbClusterSnapshotOutput,
    crate::error::CopyDBClusterSnapshotError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::copy_db_cluster_snapshot_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_copy_db_cluster_snapshot(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CopyDBClusterSnapshotError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_copy_db_parameter_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CopyDbParameterGroupOutput,
    crate::error::CopyDBParameterGroupError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CopyDBParameterGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CopyDBParameterGroupError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DBParameterGroupAlreadyExists" => {
            crate::error::CopyDBParameterGroupError {
                meta: generic,
                kind:
                    crate::error::CopyDBParameterGroupErrorKind::DbParameterGroupAlreadyExistsFault(
                        {
                            #[allow(unused_mut)]
                            let mut tmp = {
                                #[allow(unused_mut)]let mut output = crate::error::db_parameter_group_already_exists_fault::Builder::default();
                                let _ = response;
                                output = crate::xml_deser::deser_structure_crate_error_db_parameter_group_already_exists_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CopyDBParameterGroupError::unhandled)?;
                                output.build()
                            };
                            if (&tmp.message).is_none() {
                                tmp.message = _error_message;
                            }
                            tmp
                        },
                    ),
            }
        }
        "DBParameterGroupNotFound" => crate::error::CopyDBParameterGroupError {
            meta: generic,
            kind: crate::error::CopyDBParameterGroupErrorKind::DbParameterGroupNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::db_parameter_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_parameter_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CopyDBParameterGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DBParameterGroupQuotaExceeded" => {
            crate::error::CopyDBParameterGroupError {
                meta: generic,
                kind:
                    crate::error::CopyDBParameterGroupErrorKind::DbParameterGroupQuotaExceededFault(
                        {
                            #[allow(unused_mut)]
                            let mut tmp = {
                                #[allow(unused_mut)]let mut output = crate::error::db_parameter_group_quota_exceeded_fault::Builder::default();
                                let _ = response;
                                output = crate::xml_deser::deser_structure_crate_error_db_parameter_group_quota_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CopyDBParameterGroupError::unhandled)?;
                                output.build()
                            };
                            if (&tmp.message).is_none() {
                                tmp.message = _error_message;
                            }
                            tmp
                        },
                    ),
            }
        }
        _ => crate::error::CopyDBParameterGroupError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_copy_db_parameter_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CopyDbParameterGroupOutput,
    crate::error::CopyDBParameterGroupError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::copy_db_parameter_group_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_copy_db_parameter_group(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CopyDBParameterGroupError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_copy_db_snapshot_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CopyDbSnapshotOutput, crate::error::CopyDBSnapshotError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CopyDBSnapshotError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CopyDBSnapshotError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "CustomAvailabilityZoneNotFound" => {
            crate::error::CopyDBSnapshotError {
                meta: generic,
                kind: crate::error::CopyDBSnapshotErrorKind::CustomAvailabilityZoneNotFoundFault({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]let mut output = crate::error::custom_availability_zone_not_found_fault::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_custom_availability_zone_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CopyDBSnapshotError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "DBSnapshotAlreadyExists" => crate::error::CopyDBSnapshotError {
            meta: generic,
            kind: crate::error::CopyDBSnapshotErrorKind::DbSnapshotAlreadyExistsFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::db_snapshot_already_exists_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_snapshot_already_exists_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CopyDBSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DBSnapshotNotFound" => crate::error::CopyDBSnapshotError {
            meta: generic,
            kind: crate::error::CopyDBSnapshotErrorKind::DbSnapshotNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::db_snapshot_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_snapshot_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CopyDBSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidDBSnapshotState" => crate::error::CopyDBSnapshotError {
            meta: generic,
            kind: crate::error::CopyDBSnapshotErrorKind::InvalidDbSnapshotStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_db_snapshot_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_db_snapshot_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CopyDBSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSKeyNotAccessibleFault" => crate::error::CopyDBSnapshotError {
            meta: generic,
            kind: crate::error::CopyDBSnapshotErrorKind::KmsKeyNotAccessibleFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_key_not_accessible_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_kms_key_not_accessible_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CopyDBSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "SnapshotQuotaExceeded" => crate::error::CopyDBSnapshotError {
            meta: generic,
            kind: crate::error::CopyDBSnapshotErrorKind::SnapshotQuotaExceededFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::snapshot_quota_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_snapshot_quota_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CopyDBSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CopyDBSnapshotError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_copy_db_snapshot_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CopyDbSnapshotOutput, crate::error::CopyDBSnapshotError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::copy_db_snapshot_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_copy_db_snapshot(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CopyDBSnapshotError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_copy_option_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CopyOptionGroupOutput, crate::error::CopyOptionGroupError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CopyOptionGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CopyOptionGroupError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "OptionGroupAlreadyExistsFault" => crate::error::CopyOptionGroupError {
            meta: generic,
            kind: crate::error::CopyOptionGroupErrorKind::OptionGroupAlreadyExistsFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::option_group_already_exists_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_option_group_already_exists_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CopyOptionGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OptionGroupNotFoundFault" => crate::error::CopyOptionGroupError {
            meta: generic,
            kind: crate::error::CopyOptionGroupErrorKind::OptionGroupNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::option_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_option_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CopyOptionGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OptionGroupQuotaExceededFault" => crate::error::CopyOptionGroupError {
            meta: generic,
            kind: crate::error::CopyOptionGroupErrorKind::OptionGroupQuotaExceededFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::option_group_quota_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_option_group_quota_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CopyOptionGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CopyOptionGroupError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_copy_option_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CopyOptionGroupOutput, crate::error::CopyOptionGroupError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::copy_option_group_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_copy_option_group(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CopyOptionGroupError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_custom_db_engine_version_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateCustomDbEngineVersionOutput,
    crate::error::CreateCustomDBEngineVersionError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateCustomDBEngineVersionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreateCustomDBEngineVersionError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "CustomDBEngineVersionAlreadyExistsFault" => crate::error::CreateCustomDBEngineVersionError { meta: generic, kind: crate::error::CreateCustomDBEngineVersionErrorKind::CustomDbEngineVersionAlreadyExistsFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::custom_db_engine_version_already_exists_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_custom_db_engine_version_already_exists_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateCustomDBEngineVersionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "CustomDBEngineVersionQuotaExceededFault" => crate::error::CreateCustomDBEngineVersionError { meta: generic, kind: crate::error::CreateCustomDBEngineVersionErrorKind::CustomDbEngineVersionQuotaExceededFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::custom_db_engine_version_quota_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_custom_db_engine_version_quota_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateCustomDBEngineVersionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "KMSKeyNotAccessibleFault" => crate::error::CreateCustomDBEngineVersionError { meta: generic, kind: crate::error::CreateCustomDBEngineVersionErrorKind::KmsKeyNotAccessibleFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::kms_key_not_accessible_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_kms_key_not_accessible_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateCustomDBEngineVersionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::CreateCustomDBEngineVersionError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_custom_db_engine_version_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateCustomDbEngineVersionOutput,
    crate::error::CreateCustomDBEngineVersionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_custom_db_engine_version_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_create_custom_db_engine_version(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateCustomDBEngineVersionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_db_cluster_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateDbClusterOutput, crate::error::CreateDBClusterError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateDBClusterError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateDBClusterError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DBClusterAlreadyExistsFault" => crate::error::CreateDBClusterError {
            meta: generic,
            kind: crate::error::CreateDBClusterErrorKind::DbClusterAlreadyExistsFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::db_cluster_already_exists_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_cluster_already_exists_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDBClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DBClusterNotFoundFault" => crate::error::CreateDBClusterError {
            meta: generic,
            kind: crate::error::CreateDBClusterErrorKind::DbClusterNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::db_cluster_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_cluster_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDBClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DBClusterParameterGroupNotFound" => crate::error::CreateDBClusterError {
            meta: generic,
            kind: crate::error::CreateDBClusterErrorKind::DbClusterParameterGroupNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::db_cluster_parameter_group_not_found_fault::Builder::default(
                        );
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_cluster_parameter_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDBClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DBClusterQuotaExceededFault" => crate::error::CreateDBClusterError {
            meta: generic,
            kind: crate::error::CreateDBClusterErrorKind::DbClusterQuotaExceededFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::db_cluster_quota_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_cluster_quota_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDBClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DBInstanceNotFound" => crate::error::CreateDBClusterError {
            meta: generic,
            kind: crate::error::CreateDBClusterErrorKind::DbInstanceNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::db_instance_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_instance_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDBClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DBSubnetGroupDoesNotCoverEnoughAZs" => {
            crate::error::CreateDBClusterError {
                meta: generic,
                kind: crate::error::CreateDBClusterErrorKind::DbSubnetGroupDoesNotCoverEnoughAZs({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]let mut output = crate::error::db_subnet_group_does_not_cover_enough_a_zs::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_db_subnet_group_does_not_cover_enough_a_zs_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDBClusterError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "DBSubnetGroupNotFoundFault" => crate::error::CreateDBClusterError {
            meta: generic,
            kind: crate::error::CreateDBClusterErrorKind::DbSubnetGroupNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::db_subnet_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_subnet_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDBClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DomainNotFoundFault" => crate::error::CreateDBClusterError {
            meta: generic,
            kind: crate::error::CreateDBClusterErrorKind::DomainNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::domain_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_domain_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDBClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "GlobalClusterNotFoundFault" => crate::error::CreateDBClusterError {
            meta: generic,
            kind: crate::error::CreateDBClusterErrorKind::GlobalClusterNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::global_cluster_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_global_cluster_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDBClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InsufficientStorageClusterCapacity" => crate::error::CreateDBClusterError {
            meta: generic,
            kind: crate::error::CreateDBClusterErrorKind::InsufficientStorageClusterCapacityFault(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]let mut output = crate::error::insufficient_storage_cluster_capacity_fault::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_insufficient_storage_cluster_capacity_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDBClusterError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "InvalidDBClusterStateFault" => crate::error::CreateDBClusterError {
            meta: generic,
            kind: crate::error::CreateDBClusterErrorKind::InvalidDbClusterStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_db_cluster_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_db_cluster_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDBClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidDBInstanceState" => crate::error::CreateDBClusterError {
            meta: generic,
            kind: crate::error::CreateDBClusterErrorKind::InvalidDbInstanceStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_db_instance_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_db_instance_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDBClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidDBSubnetGroupStateFault" => crate::error::CreateDBClusterError {
            meta: generic,
            kind: crate::error::CreateDBClusterErrorKind::InvalidDbSubnetGroupStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_db_subnet_group_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_db_subnet_group_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDBClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidGlobalClusterStateFault" => crate::error::CreateDBClusterError {
            meta: generic,
            kind: crate::error::CreateDBClusterErrorKind::InvalidGlobalClusterStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_global_cluster_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_global_cluster_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDBClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidSubnet" => crate::error::CreateDBClusterError {
            meta: generic,
            kind: crate::error::CreateDBClusterErrorKind::InvalidSubnet({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_subnet::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_subnet_xml_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::CreateDBClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidVPCNetworkStateFault" => crate::error::CreateDBClusterError {
            meta: generic,
            kind: crate::error::CreateDBClusterErrorKind::InvalidVpcNetworkStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_vpc_network_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_vpc_network_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDBClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSKeyNotAccessibleFault" => crate::error::CreateDBClusterError {
            meta: generic,
            kind: crate::error::CreateDBClusterErrorKind::KmsKeyNotAccessibleFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_key_not_accessible_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_kms_key_not_accessible_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDBClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "StorageQuotaExceeded" => crate::error::CreateDBClusterError {
            meta: generic,
            kind: crate::error::CreateDBClusterErrorKind::StorageQuotaExceededFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::storage_quota_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_storage_quota_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDBClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateDBClusterError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_db_cluster_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateDbClusterOutput, crate::error::CreateDBClusterError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_db_cluster_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_create_db_cluster(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateDBClusterError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_db_cluster_endpoint_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateDbClusterEndpointOutput,
    crate::error::CreateDBClusterEndpointError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateDBClusterEndpointError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreateDBClusterEndpointError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DBClusterEndpointAlreadyExistsFault" => crate::error::CreateDBClusterEndpointError {
            meta: generic,
            kind:
                crate::error::CreateDBClusterEndpointErrorKind::DbClusterEndpointAlreadyExistsFault(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]let mut output = crate::error::db_cluster_endpoint_already_exists_fault::Builder::default();
                            let _ = response;
                            output = crate::xml_deser::deser_structure_crate_error_db_cluster_endpoint_already_exists_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDBClusterEndpointError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "DBClusterEndpointQuotaExceededFault" => crate::error::CreateDBClusterEndpointError {
            meta: generic,
            kind:
                crate::error::CreateDBClusterEndpointErrorKind::DbClusterEndpointQuotaExceededFault(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]let mut output = crate::error::db_cluster_endpoint_quota_exceeded_fault::Builder::default();
                            let _ = response;
                            output = crate::xml_deser::deser_structure_crate_error_db_cluster_endpoint_quota_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDBClusterEndpointError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "DBClusterNotFoundFault" => crate::error::CreateDBClusterEndpointError {
            meta: generic,
            kind: crate::error::CreateDBClusterEndpointErrorKind::DbClusterNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::db_cluster_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_cluster_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDBClusterEndpointError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DBInstanceNotFound" => crate::error::CreateDBClusterEndpointError {
            meta: generic,
            kind: crate::error::CreateDBClusterEndpointErrorKind::DbInstanceNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::db_instance_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_instance_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDBClusterEndpointError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidDBClusterStateFault" => crate::error::CreateDBClusterEndpointError {
            meta: generic,
            kind: crate::error::CreateDBClusterEndpointErrorKind::InvalidDbClusterStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_db_cluster_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_db_cluster_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDBClusterEndpointError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidDBInstanceState" => crate::error::CreateDBClusterEndpointError {
            meta: generic,
            kind: crate::error::CreateDBClusterEndpointErrorKind::InvalidDbInstanceStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_db_instance_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_db_instance_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDBClusterEndpointError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateDBClusterEndpointError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_db_cluster_endpoint_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateDbClusterEndpointOutput,
    crate::error::CreateDBClusterEndpointError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_db_cluster_endpoint_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_create_db_cluster_endpoint(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateDBClusterEndpointError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_db_cluster_parameter_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateDbClusterParameterGroupOutput,
    crate::error::CreateDBClusterParameterGroupError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateDBClusterParameterGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreateDBClusterParameterGroupError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DBParameterGroupAlreadyExists" => crate::error::CreateDBClusterParameterGroupError { meta: generic, kind: crate::error::CreateDBClusterParameterGroupErrorKind::DbParameterGroupAlreadyExistsFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::db_parameter_group_already_exists_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_parameter_group_already_exists_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDBClusterParameterGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "DBParameterGroupQuotaExceeded" => crate::error::CreateDBClusterParameterGroupError { meta: generic, kind: crate::error::CreateDBClusterParameterGroupErrorKind::DbParameterGroupQuotaExceededFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::db_parameter_group_quota_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_parameter_group_quota_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDBClusterParameterGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::CreateDBClusterParameterGroupError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_db_cluster_parameter_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateDbClusterParameterGroupOutput,
    crate::error::CreateDBClusterParameterGroupError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::create_db_cluster_parameter_group_output::Builder::default();
        let _ = response;
        output =
            crate::xml_deser::deser_operation_crate_operation_create_db_cluster_parameter_group(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::CreateDBClusterParameterGroupError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_db_cluster_snapshot_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateDbClusterSnapshotOutput,
    crate::error::CreateDBClusterSnapshotError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateDBClusterSnapshotError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreateDBClusterSnapshotError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DBClusterNotFoundFault" => crate::error::CreateDBClusterSnapshotError {
            meta: generic,
            kind: crate::error::CreateDBClusterSnapshotErrorKind::DbClusterNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::db_cluster_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_cluster_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDBClusterSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DBClusterSnapshotAlreadyExistsFault" => crate::error::CreateDBClusterSnapshotError {
            meta: generic,
            kind:
                crate::error::CreateDBClusterSnapshotErrorKind::DbClusterSnapshotAlreadyExistsFault(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]let mut output = crate::error::db_cluster_snapshot_already_exists_fault::Builder::default();
                            let _ = response;
                            output = crate::xml_deser::deser_structure_crate_error_db_cluster_snapshot_already_exists_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDBClusterSnapshotError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "InvalidDBClusterSnapshotStateFault" => crate::error::CreateDBClusterSnapshotError {
            meta: generic,
            kind:
                crate::error::CreateDBClusterSnapshotErrorKind::InvalidDbClusterSnapshotStateFault(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]let mut output = crate::error::invalid_db_cluster_snapshot_state_fault::Builder::default();
                            let _ = response;
                            output = crate::xml_deser::deser_structure_crate_error_invalid_db_cluster_snapshot_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDBClusterSnapshotError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "InvalidDBClusterStateFault" => crate::error::CreateDBClusterSnapshotError {
            meta: generic,
            kind: crate::error::CreateDBClusterSnapshotErrorKind::InvalidDbClusterStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_db_cluster_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_db_cluster_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDBClusterSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "SnapshotQuotaExceeded" => crate::error::CreateDBClusterSnapshotError {
            meta: generic,
            kind: crate::error::CreateDBClusterSnapshotErrorKind::SnapshotQuotaExceededFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::snapshot_quota_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_snapshot_quota_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDBClusterSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateDBClusterSnapshotError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_db_cluster_snapshot_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateDbClusterSnapshotOutput,
    crate::error::CreateDBClusterSnapshotError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_db_cluster_snapshot_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_create_db_cluster_snapshot(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateDBClusterSnapshotError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_db_instance_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateDbInstanceOutput, crate::error::CreateDBInstanceError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateDBInstanceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateDBInstanceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AuthorizationNotFound" => crate::error::CreateDBInstanceError {
            meta: generic,
            kind: crate::error::CreateDBInstanceErrorKind::AuthorizationNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::authorization_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_authorization_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDBInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "BackupPolicyNotFoundFault" => crate::error::CreateDBInstanceError {
            meta: generic,
            kind: crate::error::CreateDBInstanceErrorKind::BackupPolicyNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::backup_policy_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_backup_policy_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDBInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DBClusterNotFoundFault" => crate::error::CreateDBInstanceError {
            meta: generic,
            kind: crate::error::CreateDBInstanceErrorKind::DbClusterNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::db_cluster_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_cluster_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDBInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DBInstanceAlreadyExists" => crate::error::CreateDBInstanceError {
            meta: generic,
            kind: crate::error::CreateDBInstanceErrorKind::DbInstanceAlreadyExistsFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::db_instance_already_exists_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_instance_already_exists_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDBInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DBParameterGroupNotFound" => crate::error::CreateDBInstanceError {
            meta: generic,
            kind: crate::error::CreateDBInstanceErrorKind::DbParameterGroupNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::db_parameter_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_parameter_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDBInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DBSecurityGroupNotFound" => crate::error::CreateDBInstanceError {
            meta: generic,
            kind: crate::error::CreateDBInstanceErrorKind::DbSecurityGroupNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::db_security_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_security_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDBInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DBSubnetGroupDoesNotCoverEnoughAZs" => crate::error::CreateDBInstanceError {
            meta: generic,
            kind: crate::error::CreateDBInstanceErrorKind::DbSubnetGroupDoesNotCoverEnoughAZs({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::db_subnet_group_does_not_cover_enough_a_zs::Builder::default(
                        );
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_subnet_group_does_not_cover_enough_a_zs_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDBInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DBSubnetGroupNotFoundFault" => crate::error::CreateDBInstanceError {
            meta: generic,
            kind: crate::error::CreateDBInstanceErrorKind::DbSubnetGroupNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::db_subnet_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_subnet_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDBInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DomainNotFoundFault" => crate::error::CreateDBInstanceError {
            meta: generic,
            kind: crate::error::CreateDBInstanceErrorKind::DomainNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::domain_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_domain_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDBInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InstanceQuotaExceeded" => crate::error::CreateDBInstanceError {
            meta: generic,
            kind: crate::error::CreateDBInstanceErrorKind::InstanceQuotaExceededFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::instance_quota_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_instance_quota_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDBInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InsufficientDBInstanceCapacity" => crate::error::CreateDBInstanceError {
            meta: generic,
            kind: crate::error::CreateDBInstanceErrorKind::InsufficientDbInstanceCapacityFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::insufficient_db_instance_capacity_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_insufficient_db_instance_capacity_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDBInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidDBClusterStateFault" => crate::error::CreateDBInstanceError {
            meta: generic,
            kind: crate::error::CreateDBInstanceErrorKind::InvalidDbClusterStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_db_cluster_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_db_cluster_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDBInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidSubnet" => crate::error::CreateDBInstanceError {
            meta: generic,
            kind: crate::error::CreateDBInstanceErrorKind::InvalidSubnet({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_subnet::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_subnet_xml_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::CreateDBInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidVPCNetworkStateFault" => crate::error::CreateDBInstanceError {
            meta: generic,
            kind: crate::error::CreateDBInstanceErrorKind::InvalidVpcNetworkStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_vpc_network_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_vpc_network_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDBInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSKeyNotAccessibleFault" => crate::error::CreateDBInstanceError {
            meta: generic,
            kind: crate::error::CreateDBInstanceErrorKind::KmsKeyNotAccessibleFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_key_not_accessible_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_kms_key_not_accessible_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDBInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OptionGroupNotFoundFault" => crate::error::CreateDBInstanceError {
            meta: generic,
            kind: crate::error::CreateDBInstanceErrorKind::OptionGroupNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::option_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_option_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDBInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ProvisionedIopsNotAvailableInAZFault" => crate::error::CreateDBInstanceError {
            meta: generic,
            kind: crate::error::CreateDBInstanceErrorKind::ProvisionedIopsNotAvailableInAzFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::provisioned_iops_not_available_in_az_fault::Builder::default(
                        );
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_provisioned_iops_not_available_in_az_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDBInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "StorageQuotaExceeded" => crate::error::CreateDBInstanceError {
            meta: generic,
            kind: crate::error::CreateDBInstanceErrorKind::StorageQuotaExceededFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::storage_quota_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_storage_quota_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDBInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "StorageTypeNotSupported" => crate::error::CreateDBInstanceError {
            meta: generic,
            kind: crate::error::CreateDBInstanceErrorKind::StorageTypeNotSupportedFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::storage_type_not_supported_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_storage_type_not_supported_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDBInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateDBInstanceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_db_instance_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateDbInstanceOutput, crate::error::CreateDBInstanceError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_db_instance_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_create_db_instance(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateDBInstanceError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_db_instance_read_replica_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateDbInstanceReadReplicaOutput,
    crate::error::CreateDBInstanceReadReplicaError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateDBInstanceReadReplicaError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreateDBInstanceReadReplicaError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DBInstanceAlreadyExists" => crate::error::CreateDBInstanceReadReplicaError { meta: generic, kind: crate::error::CreateDBInstanceReadReplicaErrorKind::DbInstanceAlreadyExistsFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::db_instance_already_exists_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_instance_already_exists_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDBInstanceReadReplicaError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "DBInstanceNotFound" => crate::error::CreateDBInstanceReadReplicaError { meta: generic, kind: crate::error::CreateDBInstanceReadReplicaErrorKind::DbInstanceNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::db_instance_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_instance_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDBInstanceReadReplicaError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "DBParameterGroupNotFound" => crate::error::CreateDBInstanceReadReplicaError { meta: generic, kind: crate::error::CreateDBInstanceReadReplicaErrorKind::DbParameterGroupNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::db_parameter_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_parameter_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDBInstanceReadReplicaError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "DBSecurityGroupNotFound" => crate::error::CreateDBInstanceReadReplicaError { meta: generic, kind: crate::error::CreateDBInstanceReadReplicaErrorKind::DbSecurityGroupNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::db_security_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_security_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDBInstanceReadReplicaError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "DBSubnetGroupDoesNotCoverEnoughAZs" => crate::error::CreateDBInstanceReadReplicaError { meta: generic, kind: crate::error::CreateDBInstanceReadReplicaErrorKind::DbSubnetGroupDoesNotCoverEnoughAZs({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::db_subnet_group_does_not_cover_enough_a_zs::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_subnet_group_does_not_cover_enough_a_zs_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDBInstanceReadReplicaError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "DBSubnetGroupNotAllowedFault" => crate::error::CreateDBInstanceReadReplicaError { meta: generic, kind: crate::error::CreateDBInstanceReadReplicaErrorKind::DbSubnetGroupNotAllowedFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::db_subnet_group_not_allowed_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_subnet_group_not_allowed_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDBInstanceReadReplicaError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "DBSubnetGroupNotFoundFault" => crate::error::CreateDBInstanceReadReplicaError { meta: generic, kind: crate::error::CreateDBInstanceReadReplicaErrorKind::DbSubnetGroupNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::db_subnet_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_subnet_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDBInstanceReadReplicaError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "DomainNotFoundFault" => crate::error::CreateDBInstanceReadReplicaError { meta: generic, kind: crate::error::CreateDBInstanceReadReplicaErrorKind::DomainNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::domain_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_domain_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDBInstanceReadReplicaError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InstanceQuotaExceeded" => crate::error::CreateDBInstanceReadReplicaError { meta: generic, kind: crate::error::CreateDBInstanceReadReplicaErrorKind::InstanceQuotaExceededFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::instance_quota_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_instance_quota_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDBInstanceReadReplicaError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InsufficientDBInstanceCapacity" => crate::error::CreateDBInstanceReadReplicaError { meta: generic, kind: crate::error::CreateDBInstanceReadReplicaErrorKind::InsufficientDbInstanceCapacityFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::insufficient_db_instance_capacity_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_insufficient_db_instance_capacity_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDBInstanceReadReplicaError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidDBInstanceState" => crate::error::CreateDBInstanceReadReplicaError { meta: generic, kind: crate::error::CreateDBInstanceReadReplicaErrorKind::InvalidDbInstanceStateFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_db_instance_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_db_instance_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDBInstanceReadReplicaError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidDBSubnetGroupFault" => crate::error::CreateDBInstanceReadReplicaError { meta: generic, kind: crate::error::CreateDBInstanceReadReplicaErrorKind::InvalidDbSubnetGroupFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_db_subnet_group_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_db_subnet_group_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDBInstanceReadReplicaError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidSubnet" => crate::error::CreateDBInstanceReadReplicaError { meta: generic, kind: crate::error::CreateDBInstanceReadReplicaErrorKind::InvalidSubnet({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_subnet::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_subnet_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDBInstanceReadReplicaError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidVPCNetworkStateFault" => crate::error::CreateDBInstanceReadReplicaError { meta: generic, kind: crate::error::CreateDBInstanceReadReplicaErrorKind::InvalidVpcNetworkStateFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_vpc_network_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_vpc_network_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDBInstanceReadReplicaError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "KMSKeyNotAccessibleFault" => crate::error::CreateDBInstanceReadReplicaError { meta: generic, kind: crate::error::CreateDBInstanceReadReplicaErrorKind::KmsKeyNotAccessibleFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::kms_key_not_accessible_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_kms_key_not_accessible_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDBInstanceReadReplicaError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "OptionGroupNotFoundFault" => crate::error::CreateDBInstanceReadReplicaError { meta: generic, kind: crate::error::CreateDBInstanceReadReplicaErrorKind::OptionGroupNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::option_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_option_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDBInstanceReadReplicaError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ProvisionedIopsNotAvailableInAZFault" => crate::error::CreateDBInstanceReadReplicaError { meta: generic, kind: crate::error::CreateDBInstanceReadReplicaErrorKind::ProvisionedIopsNotAvailableInAzFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::provisioned_iops_not_available_in_az_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_provisioned_iops_not_available_in_az_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDBInstanceReadReplicaError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "StorageQuotaExceeded" => crate::error::CreateDBInstanceReadReplicaError { meta: generic, kind: crate::error::CreateDBInstanceReadReplicaErrorKind::StorageQuotaExceededFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::storage_quota_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_storage_quota_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDBInstanceReadReplicaError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "StorageTypeNotSupported" => crate::error::CreateDBInstanceReadReplicaError { meta: generic, kind: crate::error::CreateDBInstanceReadReplicaErrorKind::StorageTypeNotSupportedFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::storage_type_not_supported_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_storage_type_not_supported_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDBInstanceReadReplicaError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::CreateDBInstanceReadReplicaError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_db_instance_read_replica_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateDbInstanceReadReplicaOutput,
    crate::error::CreateDBInstanceReadReplicaError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_db_instance_read_replica_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_create_db_instance_read_replica(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateDBInstanceReadReplicaError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_db_parameter_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateDbParameterGroupOutput,
    crate::error::CreateDBParameterGroupError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateDBParameterGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreateDBParameterGroupError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DBParameterGroupAlreadyExists" => crate::error::CreateDBParameterGroupError {
            meta: generic,
            kind: crate::error::CreateDBParameterGroupErrorKind::DbParameterGroupAlreadyExistsFault(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::db_parameter_group_already_exists_fault::Builder::default(
                            );
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_db_parameter_group_already_exists_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDBParameterGroupError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "DBParameterGroupQuotaExceeded" => crate::error::CreateDBParameterGroupError {
            meta: generic,
            kind: crate::error::CreateDBParameterGroupErrorKind::DbParameterGroupQuotaExceededFault(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::db_parameter_group_quota_exceeded_fault::Builder::default(
                            );
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_db_parameter_group_quota_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDBParameterGroupError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::CreateDBParameterGroupError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_db_parameter_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateDbParameterGroupOutput,
    crate::error::CreateDBParameterGroupError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_db_parameter_group_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_create_db_parameter_group(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateDBParameterGroupError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_db_proxy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateDbProxyOutput, crate::error::CreateDBProxyError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateDBProxyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateDBProxyError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DBProxyAlreadyExistsFault" => crate::error::CreateDBProxyError {
            meta: generic,
            kind: crate::error::CreateDBProxyErrorKind::DbProxyAlreadyExistsFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::db_proxy_already_exists_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_proxy_already_exists_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDBProxyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DBProxyQuotaExceededFault" => crate::error::CreateDBProxyError {
            meta: generic,
            kind: crate::error::CreateDBProxyErrorKind::DbProxyQuotaExceededFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::db_proxy_quota_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_proxy_quota_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDBProxyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidSubnet" => crate::error::CreateDBProxyError {
            meta: generic,
            kind: crate::error::CreateDBProxyErrorKind::InvalidSubnet({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_subnet::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_subnet_xml_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::CreateDBProxyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateDBProxyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_db_proxy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateDbProxyOutput, crate::error::CreateDBProxyError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_db_proxy_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_create_db_proxy(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateDBProxyError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_db_proxy_endpoint_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateDbProxyEndpointOutput,
    crate::error::CreateDBProxyEndpointError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateDBProxyEndpointError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateDBProxyEndpointError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DBProxyEndpointAlreadyExistsFault" => {
            crate::error::CreateDBProxyEndpointError {
                meta: generic,
                kind:
                    crate::error::CreateDBProxyEndpointErrorKind::DbProxyEndpointAlreadyExistsFault(
                        {
                            #[allow(unused_mut)]
                            let mut tmp = {
                                #[allow(unused_mut)]let mut output = crate::error::db_proxy_endpoint_already_exists_fault::Builder::default();
                                let _ = response;
                                output = crate::xml_deser::deser_structure_crate_error_db_proxy_endpoint_already_exists_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDBProxyEndpointError::unhandled)?;
                                output.build()
                            };
                            if (&tmp.message).is_none() {
                                tmp.message = _error_message;
                            }
                            tmp
                        },
                    ),
            }
        }
        "DBProxyEndpointQuotaExceededFault" => {
            crate::error::CreateDBProxyEndpointError {
                meta: generic,
                kind:
                    crate::error::CreateDBProxyEndpointErrorKind::DbProxyEndpointQuotaExceededFault(
                        {
                            #[allow(unused_mut)]
                            let mut tmp = {
                                #[allow(unused_mut)]let mut output = crate::error::db_proxy_endpoint_quota_exceeded_fault::Builder::default();
                                let _ = response;
                                output = crate::xml_deser::deser_structure_crate_error_db_proxy_endpoint_quota_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDBProxyEndpointError::unhandled)?;
                                output.build()
                            };
                            if (&tmp.message).is_none() {
                                tmp.message = _error_message;
                            }
                            tmp
                        },
                    ),
            }
        }
        "DBProxyNotFoundFault" => crate::error::CreateDBProxyEndpointError {
            meta: generic,
            kind: crate::error::CreateDBProxyEndpointErrorKind::DbProxyNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::db_proxy_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_proxy_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDBProxyEndpointError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidDBProxyStateFault" => crate::error::CreateDBProxyEndpointError {
            meta: generic,
            kind: crate::error::CreateDBProxyEndpointErrorKind::InvalidDbProxyStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_db_proxy_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_db_proxy_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDBProxyEndpointError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidSubnet" => crate::error::CreateDBProxyEndpointError {
            meta: generic,
            kind: crate::error::CreateDBProxyEndpointErrorKind::InvalidSubnet({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_subnet::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_subnet_xml_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::CreateDBProxyEndpointError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateDBProxyEndpointError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_db_proxy_endpoint_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateDbProxyEndpointOutput,
    crate::error::CreateDBProxyEndpointError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_db_proxy_endpoint_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_create_db_proxy_endpoint(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateDBProxyEndpointError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_db_security_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateDbSecurityGroupOutput,
    crate::error::CreateDBSecurityGroupError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateDBSecurityGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateDBSecurityGroupError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DBSecurityGroupAlreadyExists" => {
            crate::error::CreateDBSecurityGroupError {
                meta: generic,
                kind:
                    crate::error::CreateDBSecurityGroupErrorKind::DbSecurityGroupAlreadyExistsFault(
                        {
                            #[allow(unused_mut)]
                            let mut tmp = {
                                #[allow(unused_mut)]let mut output = crate::error::db_security_group_already_exists_fault::Builder::default();
                                let _ = response;
                                output = crate::xml_deser::deser_structure_crate_error_db_security_group_already_exists_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDBSecurityGroupError::unhandled)?;
                                output.build()
                            };
                            if (&tmp.message).is_none() {
                                tmp.message = _error_message;
                            }
                            tmp
                        },
                    ),
            }
        }
        "DBSecurityGroupNotSupported" => crate::error::CreateDBSecurityGroupError {
            meta: generic,
            kind: crate::error::CreateDBSecurityGroupErrorKind::DbSecurityGroupNotSupportedFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::db_security_group_not_supported_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_security_group_not_supported_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDBSecurityGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "QuotaExceeded.DBSecurityGroup" => {
            crate::error::CreateDBSecurityGroupError {
                meta: generic,
                kind:
                    crate::error::CreateDBSecurityGroupErrorKind::DbSecurityGroupQuotaExceededFault(
                        {
                            #[allow(unused_mut)]
                            let mut tmp = {
                                #[allow(unused_mut)]let mut output = crate::error::db_security_group_quota_exceeded_fault::Builder::default();
                                let _ = response;
                                output = crate::xml_deser::deser_structure_crate_error_db_security_group_quota_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDBSecurityGroupError::unhandled)?;
                                output.build()
                            };
                            if (&tmp.message).is_none() {
                                tmp.message = _error_message;
                            }
                            tmp
                        },
                    ),
            }
        }
        _ => crate::error::CreateDBSecurityGroupError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_db_security_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateDbSecurityGroupOutput,
    crate::error::CreateDBSecurityGroupError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_db_security_group_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_create_db_security_group(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateDBSecurityGroupError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_db_snapshot_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateDbSnapshotOutput, crate::error::CreateDBSnapshotError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateDBSnapshotError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateDBSnapshotError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DBInstanceNotFound" => crate::error::CreateDBSnapshotError {
            meta: generic,
            kind: crate::error::CreateDBSnapshotErrorKind::DbInstanceNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::db_instance_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_instance_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDBSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DBSnapshotAlreadyExists" => crate::error::CreateDBSnapshotError {
            meta: generic,
            kind: crate::error::CreateDBSnapshotErrorKind::DbSnapshotAlreadyExistsFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::db_snapshot_already_exists_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_snapshot_already_exists_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDBSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidDBInstanceState" => crate::error::CreateDBSnapshotError {
            meta: generic,
            kind: crate::error::CreateDBSnapshotErrorKind::InvalidDbInstanceStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_db_instance_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_db_instance_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDBSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "SnapshotQuotaExceeded" => crate::error::CreateDBSnapshotError {
            meta: generic,
            kind: crate::error::CreateDBSnapshotErrorKind::SnapshotQuotaExceededFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::snapshot_quota_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_snapshot_quota_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDBSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateDBSnapshotError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_db_snapshot_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateDbSnapshotOutput, crate::error::CreateDBSnapshotError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_db_snapshot_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_create_db_snapshot(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateDBSnapshotError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_db_subnet_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateDbSubnetGroupOutput,
    crate::error::CreateDBSubnetGroupError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateDBSubnetGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateDBSubnetGroupError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DBSubnetGroupAlreadyExists" => crate::error::CreateDBSubnetGroupError {
            meta: generic,
            kind: crate::error::CreateDBSubnetGroupErrorKind::DbSubnetGroupAlreadyExistsFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::db_subnet_group_already_exists_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_subnet_group_already_exists_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDBSubnetGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DBSubnetGroupDoesNotCoverEnoughAZs" => crate::error::CreateDBSubnetGroupError {
            meta: generic,
            kind: crate::error::CreateDBSubnetGroupErrorKind::DbSubnetGroupDoesNotCoverEnoughAZs({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::db_subnet_group_does_not_cover_enough_a_zs::Builder::default(
                        );
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_subnet_group_does_not_cover_enough_a_zs_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDBSubnetGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DBSubnetGroupQuotaExceeded" => crate::error::CreateDBSubnetGroupError {
            meta: generic,
            kind: crate::error::CreateDBSubnetGroupErrorKind::DbSubnetGroupQuotaExceededFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::db_subnet_group_quota_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_subnet_group_quota_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDBSubnetGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DBSubnetQuotaExceededFault" => crate::error::CreateDBSubnetGroupError {
            meta: generic,
            kind: crate::error::CreateDBSubnetGroupErrorKind::DbSubnetQuotaExceededFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::db_subnet_quota_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_subnet_quota_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateDBSubnetGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidSubnet" => crate::error::CreateDBSubnetGroupError {
            meta: generic,
            kind: crate::error::CreateDBSubnetGroupErrorKind::InvalidSubnet({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_subnet::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_subnet_xml_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::CreateDBSubnetGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateDBSubnetGroupError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_db_subnet_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateDbSubnetGroupOutput,
    crate::error::CreateDBSubnetGroupError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_db_subnet_group_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_create_db_subnet_group(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateDBSubnetGroupError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_event_subscription_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateEventSubscriptionOutput,
    crate::error::CreateEventSubscriptionError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateEventSubscriptionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreateEventSubscriptionError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "EventSubscriptionQuotaExceeded" => crate::error::CreateEventSubscriptionError {
            meta: generic,
            kind:
                crate::error::CreateEventSubscriptionErrorKind::EventSubscriptionQuotaExceededFault(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]let mut output = crate::error::event_subscription_quota_exceeded_fault::Builder::default();
                            let _ = response;
                            output = crate::xml_deser::deser_structure_crate_error_event_subscription_quota_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateEventSubscriptionError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "SNSInvalidTopic" => crate::error::CreateEventSubscriptionError {
            meta: generic,
            kind: crate::error::CreateEventSubscriptionErrorKind::SnsInvalidTopicFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::sns_invalid_topic_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_sns_invalid_topic_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateEventSubscriptionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "SNSNoAuthorization" => crate::error::CreateEventSubscriptionError {
            meta: generic,
            kind: crate::error::CreateEventSubscriptionErrorKind::SnsNoAuthorizationFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::sns_no_authorization_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_sns_no_authorization_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateEventSubscriptionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "SNSTopicArnNotFound" => crate::error::CreateEventSubscriptionError {
            meta: generic,
            kind: crate::error::CreateEventSubscriptionErrorKind::SnsTopicArnNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::sns_topic_arn_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_sns_topic_arn_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateEventSubscriptionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "SourceNotFound" => crate::error::CreateEventSubscriptionError {
            meta: generic,
            kind: crate::error::CreateEventSubscriptionErrorKind::SourceNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::source_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_source_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateEventSubscriptionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "SubscriptionAlreadyExist" => crate::error::CreateEventSubscriptionError {
            meta: generic,
            kind: crate::error::CreateEventSubscriptionErrorKind::SubscriptionAlreadyExistFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::subscription_already_exist_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_subscription_already_exist_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateEventSubscriptionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "SubscriptionCategoryNotFound" => crate::error::CreateEventSubscriptionError {
            meta: generic,
            kind: crate::error::CreateEventSubscriptionErrorKind::SubscriptionCategoryNotFoundFault(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::subscription_category_not_found_fault::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_subscription_category_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateEventSubscriptionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::CreateEventSubscriptionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_event_subscription_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateEventSubscriptionOutput,
    crate::error::CreateEventSubscriptionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_event_subscription_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_create_event_subscription(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateEventSubscriptionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_global_cluster_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateGlobalClusterOutput,
    crate::error::CreateGlobalClusterError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateGlobalClusterError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateGlobalClusterError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DBClusterNotFoundFault" => crate::error::CreateGlobalClusterError {
            meta: generic,
            kind: crate::error::CreateGlobalClusterErrorKind::DbClusterNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::db_cluster_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_cluster_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateGlobalClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "GlobalClusterAlreadyExistsFault" => crate::error::CreateGlobalClusterError {
            meta: generic,
            kind: crate::error::CreateGlobalClusterErrorKind::GlobalClusterAlreadyExistsFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::global_cluster_already_exists_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_global_cluster_already_exists_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateGlobalClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "GlobalClusterQuotaExceededFault" => crate::error::CreateGlobalClusterError {
            meta: generic,
            kind: crate::error::CreateGlobalClusterErrorKind::GlobalClusterQuotaExceededFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::global_cluster_quota_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_global_cluster_quota_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateGlobalClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidDBClusterStateFault" => crate::error::CreateGlobalClusterError {
            meta: generic,
            kind: crate::error::CreateGlobalClusterErrorKind::InvalidDbClusterStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_db_cluster_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_db_cluster_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateGlobalClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateGlobalClusterError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_global_cluster_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateGlobalClusterOutput,
    crate::error::CreateGlobalClusterError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_global_cluster_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_create_global_cluster(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateGlobalClusterError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_option_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateOptionGroupOutput, crate::error::CreateOptionGroupError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateOptionGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateOptionGroupError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "OptionGroupAlreadyExistsFault" => crate::error::CreateOptionGroupError {
            meta: generic,
            kind: crate::error::CreateOptionGroupErrorKind::OptionGroupAlreadyExistsFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::option_group_already_exists_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_option_group_already_exists_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateOptionGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OptionGroupQuotaExceededFault" => crate::error::CreateOptionGroupError {
            meta: generic,
            kind: crate::error::CreateOptionGroupErrorKind::OptionGroupQuotaExceededFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::option_group_quota_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_option_group_quota_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::CreateOptionGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateOptionGroupError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_option_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateOptionGroupOutput, crate::error::CreateOptionGroupError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_option_group_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_create_option_group(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateOptionGroupError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_custom_db_engine_version_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteCustomDbEngineVersionOutput,
    crate::error::DeleteCustomDBEngineVersionError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteCustomDBEngineVersionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeleteCustomDBEngineVersionError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "CustomDBEngineVersionNotFoundFault" => crate::error::DeleteCustomDBEngineVersionError { meta: generic, kind: crate::error::DeleteCustomDBEngineVersionErrorKind::CustomDbEngineVersionNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::custom_db_engine_version_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_custom_db_engine_version_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteCustomDBEngineVersionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidCustomDBEngineVersionStateFault" => crate::error::DeleteCustomDBEngineVersionError { meta: generic, kind: crate::error::DeleteCustomDBEngineVersionErrorKind::InvalidCustomDbEngineVersionStateFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_custom_db_engine_version_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_custom_db_engine_version_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteCustomDBEngineVersionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::DeleteCustomDBEngineVersionError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_custom_db_engine_version_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteCustomDbEngineVersionOutput,
    crate::error::DeleteCustomDBEngineVersionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_custom_db_engine_version_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_delete_custom_db_engine_version(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteCustomDBEngineVersionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_db_cluster_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteDbClusterOutput, crate::error::DeleteDBClusterError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteDBClusterError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteDBClusterError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DBClusterNotFoundFault" => crate::error::DeleteDBClusterError {
            meta: generic,
            kind: crate::error::DeleteDBClusterErrorKind::DbClusterNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::db_cluster_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_cluster_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteDBClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DBClusterSnapshotAlreadyExistsFault" => crate::error::DeleteDBClusterError {
            meta: generic,
            kind: crate::error::DeleteDBClusterErrorKind::DbClusterSnapshotAlreadyExistsFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::db_cluster_snapshot_already_exists_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_cluster_snapshot_already_exists_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteDBClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidDBClusterSnapshotStateFault" => crate::error::DeleteDBClusterError {
            meta: generic,
            kind: crate::error::DeleteDBClusterErrorKind::InvalidDbClusterSnapshotStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_db_cluster_snapshot_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_db_cluster_snapshot_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteDBClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidDBClusterStateFault" => crate::error::DeleteDBClusterError {
            meta: generic,
            kind: crate::error::DeleteDBClusterErrorKind::InvalidDbClusterStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_db_cluster_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_db_cluster_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteDBClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "SnapshotQuotaExceeded" => crate::error::DeleteDBClusterError {
            meta: generic,
            kind: crate::error::DeleteDBClusterErrorKind::SnapshotQuotaExceededFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::snapshot_quota_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_snapshot_quota_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteDBClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteDBClusterError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_db_cluster_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteDbClusterOutput, crate::error::DeleteDBClusterError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_db_cluster_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_delete_db_cluster(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteDBClusterError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_db_cluster_endpoint_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteDbClusterEndpointOutput,
    crate::error::DeleteDBClusterEndpointError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteDBClusterEndpointError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeleteDBClusterEndpointError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DBClusterEndpointNotFoundFault" => crate::error::DeleteDBClusterEndpointError {
            meta: generic,
            kind: crate::error::DeleteDBClusterEndpointErrorKind::DbClusterEndpointNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::db_cluster_endpoint_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_cluster_endpoint_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteDBClusterEndpointError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidDBClusterEndpointStateFault" => crate::error::DeleteDBClusterEndpointError {
            meta: generic,
            kind:
                crate::error::DeleteDBClusterEndpointErrorKind::InvalidDbClusterEndpointStateFault(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]let mut output = crate::error::invalid_db_cluster_endpoint_state_fault::Builder::default();
                            let _ = response;
                            output = crate::xml_deser::deser_structure_crate_error_invalid_db_cluster_endpoint_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteDBClusterEndpointError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "InvalidDBClusterStateFault" => crate::error::DeleteDBClusterEndpointError {
            meta: generic,
            kind: crate::error::DeleteDBClusterEndpointErrorKind::InvalidDbClusterStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_db_cluster_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_db_cluster_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteDBClusterEndpointError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteDBClusterEndpointError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_db_cluster_endpoint_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteDbClusterEndpointOutput,
    crate::error::DeleteDBClusterEndpointError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_db_cluster_endpoint_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_delete_db_cluster_endpoint(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteDBClusterEndpointError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_db_cluster_parameter_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteDbClusterParameterGroupOutput,
    crate::error::DeleteDBClusterParameterGroupError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteDBClusterParameterGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeleteDBClusterParameterGroupError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DBParameterGroupNotFound" => crate::error::DeleteDBClusterParameterGroupError { meta: generic, kind: crate::error::DeleteDBClusterParameterGroupErrorKind::DbParameterGroupNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::db_parameter_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_parameter_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteDBClusterParameterGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidDBParameterGroupState" => crate::error::DeleteDBClusterParameterGroupError { meta: generic, kind: crate::error::DeleteDBClusterParameterGroupErrorKind::InvalidDbParameterGroupStateFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_db_parameter_group_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_db_parameter_group_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteDBClusterParameterGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::DeleteDBClusterParameterGroupError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_db_cluster_parameter_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteDbClusterParameterGroupOutput,
    crate::error::DeleteDBClusterParameterGroupError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::delete_db_cluster_parameter_group_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_db_cluster_snapshot_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteDbClusterSnapshotOutput,
    crate::error::DeleteDBClusterSnapshotError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteDBClusterSnapshotError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeleteDBClusterSnapshotError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DBClusterSnapshotNotFoundFault" => crate::error::DeleteDBClusterSnapshotError {
            meta: generic,
            kind: crate::error::DeleteDBClusterSnapshotErrorKind::DbClusterSnapshotNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::db_cluster_snapshot_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_cluster_snapshot_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteDBClusterSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidDBClusterSnapshotStateFault" => crate::error::DeleteDBClusterSnapshotError {
            meta: generic,
            kind:
                crate::error::DeleteDBClusterSnapshotErrorKind::InvalidDbClusterSnapshotStateFault(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]let mut output = crate::error::invalid_db_cluster_snapshot_state_fault::Builder::default();
                            let _ = response;
                            output = crate::xml_deser::deser_structure_crate_error_invalid_db_cluster_snapshot_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteDBClusterSnapshotError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        _ => crate::error::DeleteDBClusterSnapshotError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_db_cluster_snapshot_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteDbClusterSnapshotOutput,
    crate::error::DeleteDBClusterSnapshotError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_db_cluster_snapshot_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_delete_db_cluster_snapshot(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteDBClusterSnapshotError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_db_instance_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteDbInstanceOutput, crate::error::DeleteDBInstanceError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteDBInstanceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteDBInstanceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DBInstanceAutomatedBackupQuotaExceeded" => crate::error::DeleteDBInstanceError {
            meta: generic,
            kind:
                crate::error::DeleteDBInstanceErrorKind::DbInstanceAutomatedBackupQuotaExceededFault(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]let mut output = crate::error::db_instance_automated_backup_quota_exceeded_fault::Builder::default();
                            let _ = response;
                            output = crate::xml_deser::deser_structure_crate_error_db_instance_automated_backup_quota_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteDBInstanceError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "DBInstanceNotFound" => crate::error::DeleteDBInstanceError {
            meta: generic,
            kind: crate::error::DeleteDBInstanceErrorKind::DbInstanceNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::db_instance_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_instance_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteDBInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DBSnapshotAlreadyExists" => crate::error::DeleteDBInstanceError {
            meta: generic,
            kind: crate::error::DeleteDBInstanceErrorKind::DbSnapshotAlreadyExistsFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::db_snapshot_already_exists_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_snapshot_already_exists_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteDBInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidDBClusterStateFault" => crate::error::DeleteDBInstanceError {
            meta: generic,
            kind: crate::error::DeleteDBInstanceErrorKind::InvalidDbClusterStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_db_cluster_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_db_cluster_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteDBInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidDBInstanceState" => crate::error::DeleteDBInstanceError {
            meta: generic,
            kind: crate::error::DeleteDBInstanceErrorKind::InvalidDbInstanceStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_db_instance_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_db_instance_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteDBInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "SnapshotQuotaExceeded" => crate::error::DeleteDBInstanceError {
            meta: generic,
            kind: crate::error::DeleteDBInstanceErrorKind::SnapshotQuotaExceededFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::snapshot_quota_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_snapshot_quota_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteDBInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteDBInstanceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_db_instance_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteDbInstanceOutput, crate::error::DeleteDBInstanceError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_db_instance_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_delete_db_instance(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteDBInstanceError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_db_instance_automated_backup_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteDbInstanceAutomatedBackupOutput,
    crate::error::DeleteDBInstanceAutomatedBackupError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteDBInstanceAutomatedBackupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteDBInstanceAutomatedBackupError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DBInstanceAutomatedBackupNotFound" => crate::error::DeleteDBInstanceAutomatedBackupError { meta: generic, kind: crate::error::DeleteDBInstanceAutomatedBackupErrorKind::DbInstanceAutomatedBackupNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::db_instance_automated_backup_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_instance_automated_backup_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteDBInstanceAutomatedBackupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidDBInstanceAutomatedBackupState" => crate::error::DeleteDBInstanceAutomatedBackupError { meta: generic, kind: crate::error::DeleteDBInstanceAutomatedBackupErrorKind::InvalidDbInstanceAutomatedBackupStateFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_db_instance_automated_backup_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_db_instance_automated_backup_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteDBInstanceAutomatedBackupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::DeleteDBInstanceAutomatedBackupError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_db_instance_automated_backup_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteDbInstanceAutomatedBackupOutput,
    crate::error::DeleteDBInstanceAutomatedBackupError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::delete_db_instance_automated_backup_output::Builder::default();
        let _ = response;
        output =
            crate::xml_deser::deser_operation_crate_operation_delete_db_instance_automated_backup(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::DeleteDBInstanceAutomatedBackupError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_db_parameter_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteDbParameterGroupOutput,
    crate::error::DeleteDBParameterGroupError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteDBParameterGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeleteDBParameterGroupError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DBParameterGroupNotFound" => crate::error::DeleteDBParameterGroupError {
            meta: generic,
            kind: crate::error::DeleteDBParameterGroupErrorKind::DbParameterGroupNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::db_parameter_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_parameter_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteDBParameterGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidDBParameterGroupState" => {
            crate::error::DeleteDBParameterGroupError {
                meta: generic,
                kind:
                    crate::error::DeleteDBParameterGroupErrorKind::InvalidDbParameterGroupStateFault(
                        {
                            #[allow(unused_mut)]
                            let mut tmp = {
                                #[allow(unused_mut)]let mut output = crate::error::invalid_db_parameter_group_state_fault::Builder::default();
                                let _ = response;
                                output = crate::xml_deser::deser_structure_crate_error_invalid_db_parameter_group_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteDBParameterGroupError::unhandled)?;
                                output.build()
                            };
                            if (&tmp.message).is_none() {
                                tmp.message = _error_message;
                            }
                            tmp
                        },
                    ),
            }
        }
        _ => crate::error::DeleteDBParameterGroupError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_db_parameter_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteDbParameterGroupOutput,
    crate::error::DeleteDBParameterGroupError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_db_parameter_group_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_db_proxy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteDbProxyOutput, crate::error::DeleteDBProxyError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteDBProxyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteDBProxyError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DBProxyNotFoundFault" => crate::error::DeleteDBProxyError {
            meta: generic,
            kind: crate::error::DeleteDBProxyErrorKind::DbProxyNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::db_proxy_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_proxy_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteDBProxyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidDBProxyStateFault" => crate::error::DeleteDBProxyError {
            meta: generic,
            kind: crate::error::DeleteDBProxyErrorKind::InvalidDbProxyStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_db_proxy_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_db_proxy_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteDBProxyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteDBProxyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_db_proxy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteDbProxyOutput, crate::error::DeleteDBProxyError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_db_proxy_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_delete_db_proxy(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteDBProxyError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_db_proxy_endpoint_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteDbProxyEndpointOutput,
    crate::error::DeleteDBProxyEndpointError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteDBProxyEndpointError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteDBProxyEndpointError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DBProxyEndpointNotFoundFault" => crate::error::DeleteDBProxyEndpointError {
            meta: generic,
            kind: crate::error::DeleteDBProxyEndpointErrorKind::DbProxyEndpointNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::db_proxy_endpoint_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_proxy_endpoint_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteDBProxyEndpointError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidDBProxyEndpointStateFault" => crate::error::DeleteDBProxyEndpointError {
            meta: generic,
            kind: crate::error::DeleteDBProxyEndpointErrorKind::InvalidDbProxyEndpointStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_db_proxy_endpoint_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_db_proxy_endpoint_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteDBProxyEndpointError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteDBProxyEndpointError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_db_proxy_endpoint_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteDbProxyEndpointOutput,
    crate::error::DeleteDBProxyEndpointError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_db_proxy_endpoint_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_delete_db_proxy_endpoint(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteDBProxyEndpointError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_db_security_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteDbSecurityGroupOutput,
    crate::error::DeleteDBSecurityGroupError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteDBSecurityGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteDBSecurityGroupError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DBSecurityGroupNotFound" => crate::error::DeleteDBSecurityGroupError {
            meta: generic,
            kind: crate::error::DeleteDBSecurityGroupErrorKind::DbSecurityGroupNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::db_security_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_security_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteDBSecurityGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidDBSecurityGroupState" => crate::error::DeleteDBSecurityGroupError {
            meta: generic,
            kind: crate::error::DeleteDBSecurityGroupErrorKind::InvalidDbSecurityGroupStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_db_security_group_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_db_security_group_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteDBSecurityGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteDBSecurityGroupError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_db_security_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteDbSecurityGroupOutput,
    crate::error::DeleteDBSecurityGroupError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_db_security_group_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_db_snapshot_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteDbSnapshotOutput, crate::error::DeleteDBSnapshotError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteDBSnapshotError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteDBSnapshotError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DBSnapshotNotFound" => crate::error::DeleteDBSnapshotError {
            meta: generic,
            kind: crate::error::DeleteDBSnapshotErrorKind::DbSnapshotNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::db_snapshot_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_snapshot_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteDBSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidDBSnapshotState" => crate::error::DeleteDBSnapshotError {
            meta: generic,
            kind: crate::error::DeleteDBSnapshotErrorKind::InvalidDbSnapshotStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_db_snapshot_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_db_snapshot_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteDBSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteDBSnapshotError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_db_snapshot_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteDbSnapshotOutput, crate::error::DeleteDBSnapshotError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_db_snapshot_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_delete_db_snapshot(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteDBSnapshotError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_db_subnet_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteDbSubnetGroupOutput,
    crate::error::DeleteDBSubnetGroupError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteDBSubnetGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteDBSubnetGroupError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DBSubnetGroupNotFoundFault" => crate::error::DeleteDBSubnetGroupError {
            meta: generic,
            kind: crate::error::DeleteDBSubnetGroupErrorKind::DbSubnetGroupNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::db_subnet_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_subnet_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteDBSubnetGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidDBSubnetGroupStateFault" => crate::error::DeleteDBSubnetGroupError {
            meta: generic,
            kind: crate::error::DeleteDBSubnetGroupErrorKind::InvalidDbSubnetGroupStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_db_subnet_group_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_db_subnet_group_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteDBSubnetGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidDBSubnetStateFault" => crate::error::DeleteDBSubnetGroupError {
            meta: generic,
            kind: crate::error::DeleteDBSubnetGroupErrorKind::InvalidDbSubnetStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_db_subnet_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_db_subnet_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteDBSubnetGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteDBSubnetGroupError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_db_subnet_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteDbSubnetGroupOutput,
    crate::error::DeleteDBSubnetGroupError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_db_subnet_group_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_event_subscription_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteEventSubscriptionOutput,
    crate::error::DeleteEventSubscriptionError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteEventSubscriptionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeleteEventSubscriptionError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidEventSubscriptionState" => crate::error::DeleteEventSubscriptionError {
            meta: generic,
            kind:
                crate::error::DeleteEventSubscriptionErrorKind::InvalidEventSubscriptionStateFault(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]let mut output = crate::error::invalid_event_subscription_state_fault::Builder::default();
                            let _ = response;
                            output = crate::xml_deser::deser_structure_crate_error_invalid_event_subscription_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteEventSubscriptionError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "SubscriptionNotFound" => crate::error::DeleteEventSubscriptionError {
            meta: generic,
            kind: crate::error::DeleteEventSubscriptionErrorKind::SubscriptionNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::subscription_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_subscription_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteEventSubscriptionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteEventSubscriptionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_event_subscription_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteEventSubscriptionOutput,
    crate::error::DeleteEventSubscriptionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_event_subscription_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_delete_event_subscription(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteEventSubscriptionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_global_cluster_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteGlobalClusterOutput,
    crate::error::DeleteGlobalClusterError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteGlobalClusterError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteGlobalClusterError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "GlobalClusterNotFoundFault" => crate::error::DeleteGlobalClusterError {
            meta: generic,
            kind: crate::error::DeleteGlobalClusterErrorKind::GlobalClusterNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::global_cluster_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_global_cluster_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteGlobalClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidGlobalClusterStateFault" => crate::error::DeleteGlobalClusterError {
            meta: generic,
            kind: crate::error::DeleteGlobalClusterErrorKind::InvalidGlobalClusterStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_global_cluster_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_global_cluster_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteGlobalClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteGlobalClusterError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_global_cluster_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteGlobalClusterOutput,
    crate::error::DeleteGlobalClusterError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_global_cluster_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_delete_global_cluster(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteGlobalClusterError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_option_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteOptionGroupOutput, crate::error::DeleteOptionGroupError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteOptionGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteOptionGroupError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidOptionGroupStateFault" => crate::error::DeleteOptionGroupError {
            meta: generic,
            kind: crate::error::DeleteOptionGroupErrorKind::InvalidOptionGroupStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_option_group_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_option_group_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteOptionGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OptionGroupNotFoundFault" => crate::error::DeleteOptionGroupError {
            meta: generic,
            kind: crate::error::DeleteOptionGroupErrorKind::OptionGroupNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::option_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_option_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeleteOptionGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteOptionGroupError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_option_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteOptionGroupOutput, crate::error::DeleteOptionGroupError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_option_group_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_deregister_db_proxy_targets_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeregisterDbProxyTargetsOutput,
    crate::error::DeregisterDBProxyTargetsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeregisterDBProxyTargetsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeregisterDBProxyTargetsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DBProxyNotFoundFault" => crate::error::DeregisterDBProxyTargetsError {
            meta: generic,
            kind: crate::error::DeregisterDBProxyTargetsErrorKind::DbProxyNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::db_proxy_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_proxy_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeregisterDBProxyTargetsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DBProxyTargetGroupNotFoundFault" => crate::error::DeregisterDBProxyTargetsError {
            meta: generic,
            kind: crate::error::DeregisterDBProxyTargetsErrorKind::DbProxyTargetGroupNotFoundFault(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::db_proxy_target_group_not_found_fault::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_db_proxy_target_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeregisterDBProxyTargetsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "DBProxyTargetNotFoundFault" => crate::error::DeregisterDBProxyTargetsError {
            meta: generic,
            kind: crate::error::DeregisterDBProxyTargetsErrorKind::DbProxyTargetNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::db_proxy_target_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_proxy_target_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeregisterDBProxyTargetsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidDBProxyStateFault" => crate::error::DeregisterDBProxyTargetsError {
            meta: generic,
            kind: crate::error::DeregisterDBProxyTargetsErrorKind::InvalidDbProxyStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_db_proxy_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_db_proxy_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DeregisterDBProxyTargetsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeregisterDBProxyTargetsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_deregister_db_proxy_targets_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeregisterDbProxyTargetsOutput,
    crate::error::DeregisterDBProxyTargetsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::deregister_db_proxy_targets_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_account_attributes_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeAccountAttributesOutput,
    crate::error::DescribeAccountAttributesError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeAccountAttributesError::unhandled)?;
    Err(crate::error::DescribeAccountAttributesError::generic(
        generic,
    ))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_account_attributes_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeAccountAttributesOutput,
    crate::error::DescribeAccountAttributesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_account_attributes_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_account_attributes(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeAccountAttributesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_certificates_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeCertificatesOutput,
    crate::error::DescribeCertificatesError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeCertificatesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeCertificatesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "CertificateNotFound" => crate::error::DescribeCertificatesError {
            meta: generic,
            kind: crate::error::DescribeCertificatesErrorKind::CertificateNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::certificate_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_certificate_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeCertificatesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeCertificatesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_certificates_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeCertificatesOutput,
    crate::error::DescribeCertificatesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_certificates_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_certificates(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeCertificatesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_db_cluster_backtracks_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeDbClusterBacktracksOutput,
    crate::error::DescribeDBClusterBacktracksError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeDBClusterBacktracksError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeDBClusterBacktracksError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DBClusterBacktrackNotFoundFault" => crate::error::DescribeDBClusterBacktracksError {
            meta: generic,
            kind:
                crate::error::DescribeDBClusterBacktracksErrorKind::DbClusterBacktrackNotFoundFault(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]let mut output = crate::error::db_cluster_backtrack_not_found_fault::Builder::default();
                            let _ = response;
                            output = crate::xml_deser::deser_structure_crate_error_db_cluster_backtrack_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeDBClusterBacktracksError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "DBClusterNotFoundFault" => crate::error::DescribeDBClusterBacktracksError {
            meta: generic,
            kind: crate::error::DescribeDBClusterBacktracksErrorKind::DbClusterNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::db_cluster_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_cluster_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeDBClusterBacktracksError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeDBClusterBacktracksError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_db_cluster_backtracks_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeDbClusterBacktracksOutput,
    crate::error::DescribeDBClusterBacktracksError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_db_cluster_backtracks_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_db_cluster_backtracks(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeDBClusterBacktracksError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_db_cluster_endpoints_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeDbClusterEndpointsOutput,
    crate::error::DescribeDBClusterEndpointsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeDBClusterEndpointsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeDBClusterEndpointsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DBClusterNotFoundFault" => crate::error::DescribeDBClusterEndpointsError {
            meta: generic,
            kind: crate::error::DescribeDBClusterEndpointsErrorKind::DbClusterNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::db_cluster_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_cluster_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeDBClusterEndpointsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeDBClusterEndpointsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_db_cluster_endpoints_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeDbClusterEndpointsOutput,
    crate::error::DescribeDBClusterEndpointsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_db_cluster_endpoints_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_db_cluster_endpoints(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeDBClusterEndpointsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_db_cluster_parameter_groups_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeDbClusterParameterGroupsOutput,
    crate::error::DescribeDBClusterParameterGroupsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeDBClusterParameterGroupsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeDBClusterParameterGroupsError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DBParameterGroupNotFound" => crate::error::DescribeDBClusterParameterGroupsError { meta: generic, kind: crate::error::DescribeDBClusterParameterGroupsErrorKind::DbParameterGroupNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::db_parameter_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_parameter_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeDBClusterParameterGroupsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::DescribeDBClusterParameterGroupsError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_db_cluster_parameter_groups_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeDbClusterParameterGroupsOutput,
    crate::error::DescribeDBClusterParameterGroupsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::describe_db_cluster_parameter_groups_output::Builder::default();
        let _ = response;
        output =
            crate::xml_deser::deser_operation_crate_operation_describe_db_cluster_parameter_groups(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::DescribeDBClusterParameterGroupsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_db_cluster_parameters_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeDbClusterParametersOutput,
    crate::error::DescribeDBClusterParametersError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeDBClusterParametersError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeDBClusterParametersError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DBParameterGroupNotFound" => crate::error::DescribeDBClusterParametersError {
            meta: generic,
            kind: crate::error::DescribeDBClusterParametersErrorKind::DbParameterGroupNotFoundFault(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::db_parameter_group_not_found_fault::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_db_parameter_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeDBClusterParametersError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::DescribeDBClusterParametersError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_db_cluster_parameters_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeDbClusterParametersOutput,
    crate::error::DescribeDBClusterParametersError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_db_cluster_parameters_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_db_cluster_parameters(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeDBClusterParametersError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_db_clusters_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeDbClustersOutput,
    crate::error::DescribeDBClustersError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeDBClustersError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeDBClustersError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DBClusterNotFoundFault" => crate::error::DescribeDBClustersError {
            meta: generic,
            kind: crate::error::DescribeDBClustersErrorKind::DbClusterNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::db_cluster_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_cluster_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeDBClustersError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeDBClustersError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_db_clusters_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeDbClustersOutput,
    crate::error::DescribeDBClustersError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_db_clusters_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_db_clusters(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeDBClustersError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_db_cluster_snapshot_attributes_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeDbClusterSnapshotAttributesOutput,
    crate::error::DescribeDBClusterSnapshotAttributesError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeDBClusterSnapshotAttributesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeDBClusterSnapshotAttributesError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DBClusterSnapshotNotFoundFault" => crate::error::DescribeDBClusterSnapshotAttributesError { meta: generic, kind: crate::error::DescribeDBClusterSnapshotAttributesErrorKind::DbClusterSnapshotNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::db_cluster_snapshot_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_cluster_snapshot_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeDBClusterSnapshotAttributesError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::DescribeDBClusterSnapshotAttributesError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_db_cluster_snapshot_attributes_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeDbClusterSnapshotAttributesOutput,
    crate::error::DescribeDBClusterSnapshotAttributesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::describe_db_cluster_snapshot_attributes_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_db_cluster_snapshot_attributes(response.body().as_ref(), output).map_err(crate::error::DescribeDBClusterSnapshotAttributesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_db_cluster_snapshots_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeDbClusterSnapshotsOutput,
    crate::error::DescribeDBClusterSnapshotsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeDBClusterSnapshotsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeDBClusterSnapshotsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DBClusterSnapshotNotFoundFault" => crate::error::DescribeDBClusterSnapshotsError {
            meta: generic,
            kind: crate::error::DescribeDBClusterSnapshotsErrorKind::DbClusterSnapshotNotFoundFault(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::db_cluster_snapshot_not_found_fault::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_db_cluster_snapshot_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeDBClusterSnapshotsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::DescribeDBClusterSnapshotsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_db_cluster_snapshots_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeDbClusterSnapshotsOutput,
    crate::error::DescribeDBClusterSnapshotsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_db_cluster_snapshots_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_db_cluster_snapshots(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeDBClusterSnapshotsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_db_engine_versions_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeDbEngineVersionsOutput,
    crate::error::DescribeDBEngineVersionsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeDBEngineVersionsError::unhandled)?;
    Err(crate::error::DescribeDBEngineVersionsError::generic(
        generic,
    ))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_db_engine_versions_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeDbEngineVersionsOutput,
    crate::error::DescribeDBEngineVersionsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_db_engine_versions_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_db_engine_versions(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeDBEngineVersionsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_db_instance_automated_backups_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeDbInstanceAutomatedBackupsOutput,
    crate::error::DescribeDBInstanceAutomatedBackupsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeDBInstanceAutomatedBackupsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeDBInstanceAutomatedBackupsError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DBInstanceAutomatedBackupNotFound" => crate::error::DescribeDBInstanceAutomatedBackupsError { meta: generic, kind: crate::error::DescribeDBInstanceAutomatedBackupsErrorKind::DbInstanceAutomatedBackupNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::db_instance_automated_backup_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_instance_automated_backup_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeDBInstanceAutomatedBackupsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::DescribeDBInstanceAutomatedBackupsError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_db_instance_automated_backups_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeDbInstanceAutomatedBackupsOutput,
    crate::error::DescribeDBInstanceAutomatedBackupsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::describe_db_instance_automated_backups_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_db_instance_automated_backups(response.body().as_ref(), output).map_err(crate::error::DescribeDBInstanceAutomatedBackupsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_db_instances_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeDbInstancesOutput,
    crate::error::DescribeDBInstancesError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeDBInstancesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeDBInstancesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DBInstanceNotFound" => crate::error::DescribeDBInstancesError {
            meta: generic,
            kind: crate::error::DescribeDBInstancesErrorKind::DbInstanceNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::db_instance_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_instance_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeDBInstancesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeDBInstancesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_db_instances_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeDbInstancesOutput,
    crate::error::DescribeDBInstancesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_db_instances_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_db_instances(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeDBInstancesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_db_log_files_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeDbLogFilesOutput,
    crate::error::DescribeDBLogFilesError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeDBLogFilesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeDBLogFilesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DBInstanceNotFound" => crate::error::DescribeDBLogFilesError {
            meta: generic,
            kind: crate::error::DescribeDBLogFilesErrorKind::DbInstanceNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::db_instance_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_instance_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeDBLogFilesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeDBLogFilesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_db_log_files_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeDbLogFilesOutput,
    crate::error::DescribeDBLogFilesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_db_log_files_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_db_log_files(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeDBLogFilesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_db_parameter_groups_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeDbParameterGroupsOutput,
    crate::error::DescribeDBParameterGroupsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeDBParameterGroupsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeDBParameterGroupsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DBParameterGroupNotFound" => crate::error::DescribeDBParameterGroupsError {
            meta: generic,
            kind: crate::error::DescribeDBParameterGroupsErrorKind::DbParameterGroupNotFoundFault(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::db_parameter_group_not_found_fault::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_db_parameter_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeDBParameterGroupsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::DescribeDBParameterGroupsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_db_parameter_groups_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeDbParameterGroupsOutput,
    crate::error::DescribeDBParameterGroupsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_db_parameter_groups_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_db_parameter_groups(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeDBParameterGroupsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_db_parameters_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeDbParametersOutput,
    crate::error::DescribeDBParametersError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeDBParametersError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeDBParametersError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DBParameterGroupNotFound" => crate::error::DescribeDBParametersError {
            meta: generic,
            kind: crate::error::DescribeDBParametersErrorKind::DbParameterGroupNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::db_parameter_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_parameter_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeDBParametersError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeDBParametersError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_db_parameters_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeDbParametersOutput,
    crate::error::DescribeDBParametersError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_db_parameters_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_db_parameters(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeDBParametersError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_db_proxies_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeDbProxiesOutput, crate::error::DescribeDBProxiesError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeDBProxiesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeDBProxiesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DBProxyNotFoundFault" => crate::error::DescribeDBProxiesError {
            meta: generic,
            kind: crate::error::DescribeDBProxiesErrorKind::DbProxyNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::db_proxy_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_proxy_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeDBProxiesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeDBProxiesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_db_proxies_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeDbProxiesOutput, crate::error::DescribeDBProxiesError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_db_proxies_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_db_proxies(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeDBProxiesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_db_proxy_endpoints_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeDbProxyEndpointsOutput,
    crate::error::DescribeDBProxyEndpointsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeDBProxyEndpointsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeDBProxyEndpointsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DBProxyEndpointNotFoundFault" => crate::error::DescribeDBProxyEndpointsError {
            meta: generic,
            kind: crate::error::DescribeDBProxyEndpointsErrorKind::DbProxyEndpointNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::db_proxy_endpoint_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_proxy_endpoint_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeDBProxyEndpointsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DBProxyNotFoundFault" => crate::error::DescribeDBProxyEndpointsError {
            meta: generic,
            kind: crate::error::DescribeDBProxyEndpointsErrorKind::DbProxyNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::db_proxy_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_proxy_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeDBProxyEndpointsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeDBProxyEndpointsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_db_proxy_endpoints_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeDbProxyEndpointsOutput,
    crate::error::DescribeDBProxyEndpointsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_db_proxy_endpoints_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_db_proxy_endpoints(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeDBProxyEndpointsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_db_proxy_target_groups_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeDbProxyTargetGroupsOutput,
    crate::error::DescribeDBProxyTargetGroupsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeDBProxyTargetGroupsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeDBProxyTargetGroupsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DBProxyNotFoundFault" => crate::error::DescribeDBProxyTargetGroupsError {
            meta: generic,
            kind: crate::error::DescribeDBProxyTargetGroupsErrorKind::DbProxyNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::db_proxy_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_proxy_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeDBProxyTargetGroupsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DBProxyTargetGroupNotFoundFault" => crate::error::DescribeDBProxyTargetGroupsError {
            meta: generic,
            kind:
                crate::error::DescribeDBProxyTargetGroupsErrorKind::DbProxyTargetGroupNotFoundFault(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]let mut output = crate::error::db_proxy_target_group_not_found_fault::Builder::default();
                            let _ = response;
                            output = crate::xml_deser::deser_structure_crate_error_db_proxy_target_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeDBProxyTargetGroupsError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "InvalidDBProxyStateFault" => crate::error::DescribeDBProxyTargetGroupsError {
            meta: generic,
            kind: crate::error::DescribeDBProxyTargetGroupsErrorKind::InvalidDbProxyStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_db_proxy_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_db_proxy_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeDBProxyTargetGroupsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeDBProxyTargetGroupsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_db_proxy_target_groups_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeDbProxyTargetGroupsOutput,
    crate::error::DescribeDBProxyTargetGroupsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_db_proxy_target_groups_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_db_proxy_target_groups(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeDBProxyTargetGroupsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_db_proxy_targets_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeDbProxyTargetsOutput,
    crate::error::DescribeDBProxyTargetsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeDBProxyTargetsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeDBProxyTargetsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DBProxyNotFoundFault" => crate::error::DescribeDBProxyTargetsError {
            meta: generic,
            kind: crate::error::DescribeDBProxyTargetsErrorKind::DbProxyNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::db_proxy_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_proxy_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeDBProxyTargetsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DBProxyTargetGroupNotFoundFault" => crate::error::DescribeDBProxyTargetsError {
            meta: generic,
            kind: crate::error::DescribeDBProxyTargetsErrorKind::DbProxyTargetGroupNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::db_proxy_target_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_proxy_target_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeDBProxyTargetsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DBProxyTargetNotFoundFault" => crate::error::DescribeDBProxyTargetsError {
            meta: generic,
            kind: crate::error::DescribeDBProxyTargetsErrorKind::DbProxyTargetNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::db_proxy_target_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_proxy_target_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeDBProxyTargetsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidDBProxyStateFault" => crate::error::DescribeDBProxyTargetsError {
            meta: generic,
            kind: crate::error::DescribeDBProxyTargetsErrorKind::InvalidDbProxyStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_db_proxy_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_db_proxy_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeDBProxyTargetsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeDBProxyTargetsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_db_proxy_targets_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeDbProxyTargetsOutput,
    crate::error::DescribeDBProxyTargetsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_db_proxy_targets_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_db_proxy_targets(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeDBProxyTargetsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_db_security_groups_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeDbSecurityGroupsOutput,
    crate::error::DescribeDBSecurityGroupsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeDBSecurityGroupsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeDBSecurityGroupsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DBSecurityGroupNotFound" => crate::error::DescribeDBSecurityGroupsError {
            meta: generic,
            kind: crate::error::DescribeDBSecurityGroupsErrorKind::DbSecurityGroupNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::db_security_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_security_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeDBSecurityGroupsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeDBSecurityGroupsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_db_security_groups_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeDbSecurityGroupsOutput,
    crate::error::DescribeDBSecurityGroupsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_db_security_groups_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_db_security_groups(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeDBSecurityGroupsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_db_snapshot_attributes_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeDbSnapshotAttributesOutput,
    crate::error::DescribeDBSnapshotAttributesError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeDBSnapshotAttributesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeDBSnapshotAttributesError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DBSnapshotNotFound" => crate::error::DescribeDBSnapshotAttributesError {
            meta: generic,
            kind: crate::error::DescribeDBSnapshotAttributesErrorKind::DbSnapshotNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::db_snapshot_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_snapshot_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeDBSnapshotAttributesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeDBSnapshotAttributesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_db_snapshot_attributes_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeDbSnapshotAttributesOutput,
    crate::error::DescribeDBSnapshotAttributesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_db_snapshot_attributes_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_db_snapshot_attributes(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeDBSnapshotAttributesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_db_snapshots_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeDbSnapshotsOutput,
    crate::error::DescribeDBSnapshotsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeDBSnapshotsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeDBSnapshotsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DBSnapshotNotFound" => crate::error::DescribeDBSnapshotsError {
            meta: generic,
            kind: crate::error::DescribeDBSnapshotsErrorKind::DbSnapshotNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::db_snapshot_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_snapshot_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeDBSnapshotsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeDBSnapshotsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_db_snapshots_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeDbSnapshotsOutput,
    crate::error::DescribeDBSnapshotsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_db_snapshots_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_db_snapshots(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeDBSnapshotsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_db_subnet_groups_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeDbSubnetGroupsOutput,
    crate::error::DescribeDBSubnetGroupsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeDBSubnetGroupsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeDBSubnetGroupsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DBSubnetGroupNotFoundFault" => crate::error::DescribeDBSubnetGroupsError {
            meta: generic,
            kind: crate::error::DescribeDBSubnetGroupsErrorKind::DbSubnetGroupNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::db_subnet_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_subnet_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeDBSubnetGroupsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeDBSubnetGroupsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_db_subnet_groups_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeDbSubnetGroupsOutput,
    crate::error::DescribeDBSubnetGroupsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_db_subnet_groups_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_db_subnet_groups(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeDBSubnetGroupsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_engine_default_cluster_parameters_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeEngineDefaultClusterParametersOutput,
    crate::error::DescribeEngineDefaultClusterParametersError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeEngineDefaultClusterParametersError::unhandled)?;
    Err(crate::error::DescribeEngineDefaultClusterParametersError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_engine_default_cluster_parameters_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeEngineDefaultClusterParametersOutput,
    crate::error::DescribeEngineDefaultClusterParametersError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::describe_engine_default_cluster_parameters_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_engine_default_cluster_parameters(response.body().as_ref(), output).map_err(crate::error::DescribeEngineDefaultClusterParametersError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_engine_default_parameters_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeEngineDefaultParametersOutput,
    crate::error::DescribeEngineDefaultParametersError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeEngineDefaultParametersError::unhandled)?;
    Err(crate::error::DescribeEngineDefaultParametersError::generic(
        generic,
    ))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_engine_default_parameters_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeEngineDefaultParametersOutput,
    crate::error::DescribeEngineDefaultParametersError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::describe_engine_default_parameters_output::Builder::default();
        let _ = response;
        output =
            crate::xml_deser::deser_operation_crate_operation_describe_engine_default_parameters(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::DescribeEngineDefaultParametersError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_event_categories_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeEventCategoriesOutput,
    crate::error::DescribeEventCategoriesError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeEventCategoriesError::unhandled)?;
    Err(crate::error::DescribeEventCategoriesError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_event_categories_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeEventCategoriesOutput,
    crate::error::DescribeEventCategoriesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_event_categories_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_event_categories(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeEventCategoriesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_events_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeEventsOutput, crate::error::DescribeEventsError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeEventsError::unhandled)?;
    Err(crate::error::DescribeEventsError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_events_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeEventsOutput, crate::error::DescribeEventsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_events_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_events(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeEventsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_event_subscriptions_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeEventSubscriptionsOutput,
    crate::error::DescribeEventSubscriptionsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeEventSubscriptionsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeEventSubscriptionsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "SubscriptionNotFound" => crate::error::DescribeEventSubscriptionsError {
            meta: generic,
            kind: crate::error::DescribeEventSubscriptionsErrorKind::SubscriptionNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::subscription_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_subscription_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeEventSubscriptionsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeEventSubscriptionsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_event_subscriptions_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeEventSubscriptionsOutput,
    crate::error::DescribeEventSubscriptionsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_event_subscriptions_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_event_subscriptions(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeEventSubscriptionsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_export_tasks_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeExportTasksOutput,
    crate::error::DescribeExportTasksError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeExportTasksError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeExportTasksError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ExportTaskNotFound" => crate::error::DescribeExportTasksError {
            meta: generic,
            kind: crate::error::DescribeExportTasksErrorKind::ExportTaskNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::export_task_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_export_task_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeExportTasksError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeExportTasksError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_export_tasks_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeExportTasksOutput,
    crate::error::DescribeExportTasksError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_export_tasks_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_export_tasks(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeExportTasksError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_global_clusters_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeGlobalClustersOutput,
    crate::error::DescribeGlobalClustersError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeGlobalClustersError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeGlobalClustersError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "GlobalClusterNotFoundFault" => crate::error::DescribeGlobalClustersError {
            meta: generic,
            kind: crate::error::DescribeGlobalClustersErrorKind::GlobalClusterNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::global_cluster_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_global_cluster_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeGlobalClustersError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeGlobalClustersError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_global_clusters_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeGlobalClustersOutput,
    crate::error::DescribeGlobalClustersError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_global_clusters_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_global_clusters(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeGlobalClustersError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_option_group_options_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeOptionGroupOptionsOutput,
    crate::error::DescribeOptionGroupOptionsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeOptionGroupOptionsError::unhandled)?;
    Err(crate::error::DescribeOptionGroupOptionsError::generic(
        generic,
    ))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_option_group_options_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeOptionGroupOptionsOutput,
    crate::error::DescribeOptionGroupOptionsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_option_group_options_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_option_group_options(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeOptionGroupOptionsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_option_groups_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeOptionGroupsOutput,
    crate::error::DescribeOptionGroupsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeOptionGroupsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeOptionGroupsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "OptionGroupNotFoundFault" => crate::error::DescribeOptionGroupsError {
            meta: generic,
            kind: crate::error::DescribeOptionGroupsErrorKind::OptionGroupNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::option_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_option_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeOptionGroupsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeOptionGroupsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_option_groups_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeOptionGroupsOutput,
    crate::error::DescribeOptionGroupsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_option_groups_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_option_groups(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeOptionGroupsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_orderable_db_instance_options_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeOrderableDbInstanceOptionsOutput,
    crate::error::DescribeOrderableDBInstanceOptionsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeOrderableDBInstanceOptionsError::unhandled)?;
    Err(crate::error::DescribeOrderableDBInstanceOptionsError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_orderable_db_instance_options_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeOrderableDbInstanceOptionsOutput,
    crate::error::DescribeOrderableDBInstanceOptionsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::describe_orderable_db_instance_options_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_orderable_db_instance_options(response.body().as_ref(), output).map_err(crate::error::DescribeOrderableDBInstanceOptionsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_pending_maintenance_actions_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribePendingMaintenanceActionsOutput,
    crate::error::DescribePendingMaintenanceActionsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribePendingMaintenanceActionsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribePendingMaintenanceActionsError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ResourceNotFoundFault" => crate::error::DescribePendingMaintenanceActionsError {
            meta: generic,
            kind: crate::error::DescribePendingMaintenanceActionsErrorKind::ResourceNotFoundFault(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output = crate::error::resource_not_found_fault::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_resource_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribePendingMaintenanceActionsError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::DescribePendingMaintenanceActionsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_pending_maintenance_actions_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribePendingMaintenanceActionsOutput,
    crate::error::DescribePendingMaintenanceActionsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::describe_pending_maintenance_actions_output::Builder::default();
        let _ = response;
        output =
            crate::xml_deser::deser_operation_crate_operation_describe_pending_maintenance_actions(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::DescribePendingMaintenanceActionsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_reserved_db_instances_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeReservedDbInstancesOutput,
    crate::error::DescribeReservedDBInstancesError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeReservedDBInstancesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeReservedDBInstancesError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ReservedDBInstanceNotFound" => crate::error::DescribeReservedDBInstancesError {
            meta: generic,
            kind:
                crate::error::DescribeReservedDBInstancesErrorKind::ReservedDbInstanceNotFoundFault(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]let mut output = crate::error::reserved_db_instance_not_found_fault::Builder::default();
                            let _ = response;
                            output = crate::xml_deser::deser_structure_crate_error_reserved_db_instance_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeReservedDBInstancesError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        _ => crate::error::DescribeReservedDBInstancesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_reserved_db_instances_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeReservedDbInstancesOutput,
    crate::error::DescribeReservedDBInstancesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_reserved_db_instances_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_reserved_db_instances(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeReservedDBInstancesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_reserved_db_instances_offerings_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeReservedDbInstancesOfferingsOutput,
    crate::error::DescribeReservedDBInstancesOfferingsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeReservedDBInstancesOfferingsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeReservedDBInstancesOfferingsError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ReservedDBInstancesOfferingNotFound" => crate::error::DescribeReservedDBInstancesOfferingsError { meta: generic, kind: crate::error::DescribeReservedDBInstancesOfferingsErrorKind::ReservedDbInstancesOfferingNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::reserved_db_instances_offering_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_reserved_db_instances_offering_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeReservedDBInstancesOfferingsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::DescribeReservedDBInstancesOfferingsError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_reserved_db_instances_offerings_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeReservedDbInstancesOfferingsOutput,
    crate::error::DescribeReservedDBInstancesOfferingsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::describe_reserved_db_instances_offerings_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_reserved_db_instances_offerings(response.body().as_ref(), output).map_err(crate::error::DescribeReservedDBInstancesOfferingsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_source_regions_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeSourceRegionsOutput,
    crate::error::DescribeSourceRegionsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeSourceRegionsError::unhandled)?;
    Err(crate::error::DescribeSourceRegionsError::generic(generic))
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_source_regions_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeSourceRegionsOutput,
    crate::error::DescribeSourceRegionsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_source_regions_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_source_regions(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeSourceRegionsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_valid_db_instance_modifications_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeValidDbInstanceModificationsOutput,
    crate::error::DescribeValidDBInstanceModificationsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeValidDBInstanceModificationsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeValidDBInstanceModificationsError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DBInstanceNotFound" => crate::error::DescribeValidDBInstanceModificationsError { meta: generic, kind: crate::error::DescribeValidDBInstanceModificationsErrorKind::DbInstanceNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::db_instance_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_instance_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeValidDBInstanceModificationsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidDBInstanceState" => crate::error::DescribeValidDBInstanceModificationsError { meta: generic, kind: crate::error::DescribeValidDBInstanceModificationsErrorKind::InvalidDbInstanceStateFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_db_instance_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_db_instance_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DescribeValidDBInstanceModificationsError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::DescribeValidDBInstanceModificationsError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_valid_db_instance_modifications_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeValidDbInstanceModificationsOutput,
    crate::error::DescribeValidDBInstanceModificationsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::describe_valid_db_instance_modifications_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_describe_valid_db_instance_modifications(response.body().as_ref(), output).map_err(crate::error::DescribeValidDBInstanceModificationsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_download_db_log_file_portion_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DownloadDbLogFilePortionOutput,
    crate::error::DownloadDBLogFilePortionError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::DownloadDBLogFilePortionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DownloadDBLogFilePortionError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DBInstanceNotFound" => crate::error::DownloadDBLogFilePortionError {
            meta: generic,
            kind: crate::error::DownloadDBLogFilePortionErrorKind::DbInstanceNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::db_instance_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_instance_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DownloadDBLogFilePortionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DBLogFileNotFoundFault" => crate::error::DownloadDBLogFilePortionError {
            meta: generic,
            kind: crate::error::DownloadDBLogFilePortionErrorKind::DbLogFileNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::db_log_file_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_log_file_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::DownloadDBLogFilePortionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DownloadDBLogFilePortionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_download_db_log_file_portion_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DownloadDbLogFilePortionOutput,
    crate::error::DownloadDBLogFilePortionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::download_db_log_file_portion_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_download_db_log_file_portion(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DownloadDBLogFilePortionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_failover_db_cluster_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::FailoverDbClusterOutput, crate::error::FailoverDBClusterError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::FailoverDBClusterError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::FailoverDBClusterError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DBClusterNotFoundFault" => crate::error::FailoverDBClusterError {
            meta: generic,
            kind: crate::error::FailoverDBClusterErrorKind::DbClusterNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::db_cluster_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_cluster_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::FailoverDBClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidDBClusterStateFault" => crate::error::FailoverDBClusterError {
            meta: generic,
            kind: crate::error::FailoverDBClusterErrorKind::InvalidDbClusterStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_db_cluster_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_db_cluster_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::FailoverDBClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidDBInstanceState" => crate::error::FailoverDBClusterError {
            meta: generic,
            kind: crate::error::FailoverDBClusterErrorKind::InvalidDbInstanceStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_db_instance_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_db_instance_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::FailoverDBClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::FailoverDBClusterError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_failover_db_cluster_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::FailoverDbClusterOutput, crate::error::FailoverDBClusterError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::failover_db_cluster_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_failover_db_cluster(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::FailoverDBClusterError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_failover_global_cluster_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::FailoverGlobalClusterOutput,
    crate::error::FailoverGlobalClusterError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::FailoverGlobalClusterError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::FailoverGlobalClusterError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DBClusterNotFoundFault" => crate::error::FailoverGlobalClusterError {
            meta: generic,
            kind: crate::error::FailoverGlobalClusterErrorKind::DbClusterNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::db_cluster_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_cluster_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::FailoverGlobalClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "GlobalClusterNotFoundFault" => crate::error::FailoverGlobalClusterError {
            meta: generic,
            kind: crate::error::FailoverGlobalClusterErrorKind::GlobalClusterNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::global_cluster_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_global_cluster_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::FailoverGlobalClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidDBClusterStateFault" => crate::error::FailoverGlobalClusterError {
            meta: generic,
            kind: crate::error::FailoverGlobalClusterErrorKind::InvalidDbClusterStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_db_cluster_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_db_cluster_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::FailoverGlobalClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidGlobalClusterStateFault" => crate::error::FailoverGlobalClusterError {
            meta: generic,
            kind: crate::error::FailoverGlobalClusterErrorKind::InvalidGlobalClusterStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_global_cluster_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_global_cluster_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::FailoverGlobalClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::FailoverGlobalClusterError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_failover_global_cluster_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::FailoverGlobalClusterOutput,
    crate::error::FailoverGlobalClusterError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::failover_global_cluster_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_failover_global_cluster(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::FailoverGlobalClusterError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_tags_for_resource_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListTagsForResourceOutput,
    crate::error::ListTagsForResourceError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ListTagsForResourceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ListTagsForResourceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DBClusterNotFoundFault" => crate::error::ListTagsForResourceError {
            meta: generic,
            kind: crate::error::ListTagsForResourceErrorKind::DbClusterNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::db_cluster_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_cluster_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DBInstanceNotFound" => crate::error::ListTagsForResourceError {
            meta: generic,
            kind: crate::error::ListTagsForResourceErrorKind::DbInstanceNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::db_instance_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_instance_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DBProxyNotFoundFault" => crate::error::ListTagsForResourceError {
            meta: generic,
            kind: crate::error::ListTagsForResourceErrorKind::DbProxyNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::db_proxy_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_proxy_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DBProxyTargetGroupNotFoundFault" => crate::error::ListTagsForResourceError {
            meta: generic,
            kind: crate::error::ListTagsForResourceErrorKind::DbProxyTargetGroupNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::db_proxy_target_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_proxy_target_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DBSnapshotNotFound" => crate::error::ListTagsForResourceError {
            meta: generic,
            kind: crate::error::ListTagsForResourceErrorKind::DbSnapshotNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::db_snapshot_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_snapshot_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ListTagsForResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ListTagsForResourceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_list_tags_for_resource_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ListTagsForResourceOutput,
    crate::error::ListTagsForResourceError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::list_tags_for_resource_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_list_tags_for_resource(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ListTagsForResourceError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_certificates_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ModifyCertificatesOutput,
    crate::error::ModifyCertificatesError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ModifyCertificatesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ModifyCertificatesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "CertificateNotFound" => crate::error::ModifyCertificatesError {
            meta: generic,
            kind: crate::error::ModifyCertificatesErrorKind::CertificateNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::certificate_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_certificate_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyCertificatesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ModifyCertificatesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_certificates_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ModifyCertificatesOutput,
    crate::error::ModifyCertificatesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::modify_certificates_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_modify_certificates(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ModifyCertificatesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_current_db_cluster_capacity_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ModifyCurrentDbClusterCapacityOutput,
    crate::error::ModifyCurrentDBClusterCapacityError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ModifyCurrentDBClusterCapacityError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ModifyCurrentDBClusterCapacityError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DBClusterNotFoundFault" => crate::error::ModifyCurrentDBClusterCapacityError {
            meta: generic,
            kind: crate::error::ModifyCurrentDBClusterCapacityErrorKind::DbClusterNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::db_cluster_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_cluster_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyCurrentDBClusterCapacityError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidDBClusterCapacityFault" => crate::error::ModifyCurrentDBClusterCapacityError {
            meta: generic,
            kind:
                crate::error::ModifyCurrentDBClusterCapacityErrorKind::InvalidDbClusterCapacityFault(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]
                            let mut output =
                                crate::error::invalid_db_cluster_capacity_fault::Builder::default();
                            let _ = response;
                            output = crate::xml_deser::deser_structure_crate_error_invalid_db_cluster_capacity_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyCurrentDBClusterCapacityError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "InvalidDBClusterStateFault" => crate::error::ModifyCurrentDBClusterCapacityError {
            meta: generic,
            kind: crate::error::ModifyCurrentDBClusterCapacityErrorKind::InvalidDbClusterStateFault(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::invalid_db_cluster_state_fault::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_invalid_db_cluster_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyCurrentDBClusterCapacityError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        _ => crate::error::ModifyCurrentDBClusterCapacityError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_current_db_cluster_capacity_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ModifyCurrentDbClusterCapacityOutput,
    crate::error::ModifyCurrentDBClusterCapacityError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::modify_current_db_cluster_capacity_output::Builder::default();
        let _ = response;
        output =
            crate::xml_deser::deser_operation_crate_operation_modify_current_db_cluster_capacity(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::ModifyCurrentDBClusterCapacityError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_custom_db_engine_version_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ModifyCustomDbEngineVersionOutput,
    crate::error::ModifyCustomDBEngineVersionError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ModifyCustomDBEngineVersionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ModifyCustomDBEngineVersionError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "CustomDBEngineVersionNotFoundFault" => crate::error::ModifyCustomDBEngineVersionError { meta: generic, kind: crate::error::ModifyCustomDBEngineVersionErrorKind::CustomDbEngineVersionNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::custom_db_engine_version_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_custom_db_engine_version_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyCustomDBEngineVersionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidCustomDBEngineVersionStateFault" => crate::error::ModifyCustomDBEngineVersionError { meta: generic, kind: crate::error::ModifyCustomDBEngineVersionErrorKind::InvalidCustomDbEngineVersionStateFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_custom_db_engine_version_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_custom_db_engine_version_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyCustomDBEngineVersionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::ModifyCustomDBEngineVersionError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_custom_db_engine_version_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ModifyCustomDbEngineVersionOutput,
    crate::error::ModifyCustomDBEngineVersionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::modify_custom_db_engine_version_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_modify_custom_db_engine_version(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ModifyCustomDBEngineVersionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_db_cluster_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ModifyDbClusterOutput, crate::error::ModifyDBClusterError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ModifyDBClusterError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ModifyDBClusterError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DBClusterAlreadyExistsFault" => crate::error::ModifyDBClusterError {
            meta: generic,
            kind: crate::error::ModifyDBClusterErrorKind::DbClusterAlreadyExistsFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::db_cluster_already_exists_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_cluster_already_exists_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyDBClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DBClusterNotFoundFault" => crate::error::ModifyDBClusterError {
            meta: generic,
            kind: crate::error::ModifyDBClusterErrorKind::DbClusterNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::db_cluster_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_cluster_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyDBClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DBClusterParameterGroupNotFound" => crate::error::ModifyDBClusterError {
            meta: generic,
            kind: crate::error::ModifyDBClusterErrorKind::DbClusterParameterGroupNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::db_cluster_parameter_group_not_found_fault::Builder::default(
                        );
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_cluster_parameter_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyDBClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DBSubnetGroupNotFoundFault" => crate::error::ModifyDBClusterError {
            meta: generic,
            kind: crate::error::ModifyDBClusterErrorKind::DbSubnetGroupNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::db_subnet_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_subnet_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyDBClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DomainNotFoundFault" => crate::error::ModifyDBClusterError {
            meta: generic,
            kind: crate::error::ModifyDBClusterErrorKind::DomainNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::domain_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_domain_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyDBClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidDBClusterStateFault" => crate::error::ModifyDBClusterError {
            meta: generic,
            kind: crate::error::ModifyDBClusterErrorKind::InvalidDbClusterStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_db_cluster_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_db_cluster_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyDBClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidDBInstanceState" => crate::error::ModifyDBClusterError {
            meta: generic,
            kind: crate::error::ModifyDBClusterErrorKind::InvalidDbInstanceStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_db_instance_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_db_instance_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyDBClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidDBSecurityGroupState" => crate::error::ModifyDBClusterError {
            meta: generic,
            kind: crate::error::ModifyDBClusterErrorKind::InvalidDbSecurityGroupStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_db_security_group_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_db_security_group_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyDBClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidDBSubnetGroupStateFault" => crate::error::ModifyDBClusterError {
            meta: generic,
            kind: crate::error::ModifyDBClusterErrorKind::InvalidDbSubnetGroupStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_db_subnet_group_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_db_subnet_group_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyDBClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidSubnet" => crate::error::ModifyDBClusterError {
            meta: generic,
            kind: crate::error::ModifyDBClusterErrorKind::InvalidSubnet({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_subnet::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_subnet_xml_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::ModifyDBClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidVPCNetworkStateFault" => crate::error::ModifyDBClusterError {
            meta: generic,
            kind: crate::error::ModifyDBClusterErrorKind::InvalidVpcNetworkStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_vpc_network_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_vpc_network_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyDBClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "StorageQuotaExceeded" => crate::error::ModifyDBClusterError {
            meta: generic,
            kind: crate::error::ModifyDBClusterErrorKind::StorageQuotaExceededFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::storage_quota_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_storage_quota_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyDBClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ModifyDBClusterError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_db_cluster_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ModifyDbClusterOutput, crate::error::ModifyDBClusterError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::modify_db_cluster_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_modify_db_cluster(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ModifyDBClusterError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_db_cluster_endpoint_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ModifyDbClusterEndpointOutput,
    crate::error::ModifyDBClusterEndpointError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ModifyDBClusterEndpointError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ModifyDBClusterEndpointError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DBClusterEndpointNotFoundFault" => crate::error::ModifyDBClusterEndpointError {
            meta: generic,
            kind: crate::error::ModifyDBClusterEndpointErrorKind::DbClusterEndpointNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::db_cluster_endpoint_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_cluster_endpoint_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyDBClusterEndpointError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DBInstanceNotFound" => crate::error::ModifyDBClusterEndpointError {
            meta: generic,
            kind: crate::error::ModifyDBClusterEndpointErrorKind::DbInstanceNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::db_instance_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_instance_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyDBClusterEndpointError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidDBClusterEndpointStateFault" => crate::error::ModifyDBClusterEndpointError {
            meta: generic,
            kind:
                crate::error::ModifyDBClusterEndpointErrorKind::InvalidDbClusterEndpointStateFault(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]let mut output = crate::error::invalid_db_cluster_endpoint_state_fault::Builder::default();
                            let _ = response;
                            output = crate::xml_deser::deser_structure_crate_error_invalid_db_cluster_endpoint_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyDBClusterEndpointError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "InvalidDBClusterStateFault" => crate::error::ModifyDBClusterEndpointError {
            meta: generic,
            kind: crate::error::ModifyDBClusterEndpointErrorKind::InvalidDbClusterStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_db_cluster_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_db_cluster_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyDBClusterEndpointError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidDBInstanceState" => crate::error::ModifyDBClusterEndpointError {
            meta: generic,
            kind: crate::error::ModifyDBClusterEndpointErrorKind::InvalidDbInstanceStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_db_instance_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_db_instance_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyDBClusterEndpointError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ModifyDBClusterEndpointError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_db_cluster_endpoint_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ModifyDbClusterEndpointOutput,
    crate::error::ModifyDBClusterEndpointError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::modify_db_cluster_endpoint_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_modify_db_cluster_endpoint(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ModifyDBClusterEndpointError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_db_cluster_parameter_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ModifyDbClusterParameterGroupOutput,
    crate::error::ModifyDBClusterParameterGroupError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ModifyDBClusterParameterGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ModifyDBClusterParameterGroupError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DBParameterGroupNotFound" => crate::error::ModifyDBClusterParameterGroupError { meta: generic, kind: crate::error::ModifyDBClusterParameterGroupErrorKind::DbParameterGroupNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::db_parameter_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_parameter_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyDBClusterParameterGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidDBParameterGroupState" => crate::error::ModifyDBClusterParameterGroupError { meta: generic, kind: crate::error::ModifyDBClusterParameterGroupErrorKind::InvalidDbParameterGroupStateFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_db_parameter_group_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_db_parameter_group_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyDBClusterParameterGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::ModifyDBClusterParameterGroupError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_db_cluster_parameter_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ModifyDbClusterParameterGroupOutput,
    crate::error::ModifyDBClusterParameterGroupError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::modify_db_cluster_parameter_group_output::Builder::default();
        let _ = response;
        output =
            crate::xml_deser::deser_operation_crate_operation_modify_db_cluster_parameter_group(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::ModifyDBClusterParameterGroupError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_db_cluster_snapshot_attribute_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ModifyDbClusterSnapshotAttributeOutput,
    crate::error::ModifyDBClusterSnapshotAttributeError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ModifyDBClusterSnapshotAttributeError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ModifyDBClusterSnapshotAttributeError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DBClusterSnapshotNotFoundFault" => crate::error::ModifyDBClusterSnapshotAttributeError { meta: generic, kind: crate::error::ModifyDBClusterSnapshotAttributeErrorKind::DbClusterSnapshotNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::db_cluster_snapshot_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_cluster_snapshot_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyDBClusterSnapshotAttributeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidDBClusterSnapshotStateFault" => crate::error::ModifyDBClusterSnapshotAttributeError { meta: generic, kind: crate::error::ModifyDBClusterSnapshotAttributeErrorKind::InvalidDbClusterSnapshotStateFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_db_cluster_snapshot_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_db_cluster_snapshot_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyDBClusterSnapshotAttributeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "SharedSnapshotQuotaExceeded" => crate::error::ModifyDBClusterSnapshotAttributeError { meta: generic, kind: crate::error::ModifyDBClusterSnapshotAttributeErrorKind::SharedSnapshotQuotaExceededFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::shared_snapshot_quota_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_shared_snapshot_quota_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyDBClusterSnapshotAttributeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::ModifyDBClusterSnapshotAttributeError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_db_cluster_snapshot_attribute_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ModifyDbClusterSnapshotAttributeOutput,
    crate::error::ModifyDBClusterSnapshotAttributeError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::modify_db_cluster_snapshot_attribute_output::Builder::default();
        let _ = response;
        output =
            crate::xml_deser::deser_operation_crate_operation_modify_db_cluster_snapshot_attribute(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::ModifyDBClusterSnapshotAttributeError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_db_instance_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ModifyDbInstanceOutput, crate::error::ModifyDBInstanceError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ModifyDBInstanceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ModifyDBInstanceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AuthorizationNotFound" => crate::error::ModifyDBInstanceError {
            meta: generic,
            kind: crate::error::ModifyDBInstanceErrorKind::AuthorizationNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::authorization_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_authorization_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyDBInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "BackupPolicyNotFoundFault" => crate::error::ModifyDBInstanceError {
            meta: generic,
            kind: crate::error::ModifyDBInstanceErrorKind::BackupPolicyNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::backup_policy_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_backup_policy_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyDBInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "CertificateNotFound" => crate::error::ModifyDBInstanceError {
            meta: generic,
            kind: crate::error::ModifyDBInstanceErrorKind::CertificateNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::certificate_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_certificate_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyDBInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DBInstanceAlreadyExists" => crate::error::ModifyDBInstanceError {
            meta: generic,
            kind: crate::error::ModifyDBInstanceErrorKind::DbInstanceAlreadyExistsFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::db_instance_already_exists_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_instance_already_exists_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyDBInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DBInstanceNotFound" => crate::error::ModifyDBInstanceError {
            meta: generic,
            kind: crate::error::ModifyDBInstanceErrorKind::DbInstanceNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::db_instance_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_instance_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyDBInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DBParameterGroupNotFound" => crate::error::ModifyDBInstanceError {
            meta: generic,
            kind: crate::error::ModifyDBInstanceErrorKind::DbParameterGroupNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::db_parameter_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_parameter_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyDBInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DBSecurityGroupNotFound" => crate::error::ModifyDBInstanceError {
            meta: generic,
            kind: crate::error::ModifyDBInstanceErrorKind::DbSecurityGroupNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::db_security_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_security_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyDBInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DBUpgradeDependencyFailure" => crate::error::ModifyDBInstanceError {
            meta: generic,
            kind: crate::error::ModifyDBInstanceErrorKind::DbUpgradeDependencyFailureFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::db_upgrade_dependency_failure_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_upgrade_dependency_failure_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyDBInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DomainNotFoundFault" => crate::error::ModifyDBInstanceError {
            meta: generic,
            kind: crate::error::ModifyDBInstanceErrorKind::DomainNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::domain_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_domain_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyDBInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InsufficientDBInstanceCapacity" => crate::error::ModifyDBInstanceError {
            meta: generic,
            kind: crate::error::ModifyDBInstanceErrorKind::InsufficientDbInstanceCapacityFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::insufficient_db_instance_capacity_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_insufficient_db_instance_capacity_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyDBInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidDBClusterStateFault" => crate::error::ModifyDBInstanceError {
            meta: generic,
            kind: crate::error::ModifyDBInstanceErrorKind::InvalidDbClusterStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_db_cluster_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_db_cluster_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyDBInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidDBInstanceState" => crate::error::ModifyDBInstanceError {
            meta: generic,
            kind: crate::error::ModifyDBInstanceErrorKind::InvalidDbInstanceStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_db_instance_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_db_instance_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyDBInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidDBSecurityGroupState" => crate::error::ModifyDBInstanceError {
            meta: generic,
            kind: crate::error::ModifyDBInstanceErrorKind::InvalidDbSecurityGroupStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_db_security_group_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_db_security_group_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyDBInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidVPCNetworkStateFault" => crate::error::ModifyDBInstanceError {
            meta: generic,
            kind: crate::error::ModifyDBInstanceErrorKind::InvalidVpcNetworkStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_vpc_network_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_vpc_network_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyDBInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSKeyNotAccessibleFault" => crate::error::ModifyDBInstanceError {
            meta: generic,
            kind: crate::error::ModifyDBInstanceErrorKind::KmsKeyNotAccessibleFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_key_not_accessible_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_kms_key_not_accessible_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyDBInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OptionGroupNotFoundFault" => crate::error::ModifyDBInstanceError {
            meta: generic,
            kind: crate::error::ModifyDBInstanceErrorKind::OptionGroupNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::option_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_option_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyDBInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ProvisionedIopsNotAvailableInAZFault" => crate::error::ModifyDBInstanceError {
            meta: generic,
            kind: crate::error::ModifyDBInstanceErrorKind::ProvisionedIopsNotAvailableInAzFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::provisioned_iops_not_available_in_az_fault::Builder::default(
                        );
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_provisioned_iops_not_available_in_az_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyDBInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "StorageQuotaExceeded" => crate::error::ModifyDBInstanceError {
            meta: generic,
            kind: crate::error::ModifyDBInstanceErrorKind::StorageQuotaExceededFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::storage_quota_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_storage_quota_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyDBInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "StorageTypeNotSupported" => crate::error::ModifyDBInstanceError {
            meta: generic,
            kind: crate::error::ModifyDBInstanceErrorKind::StorageTypeNotSupportedFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::storage_type_not_supported_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_storage_type_not_supported_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyDBInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ModifyDBInstanceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_db_instance_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ModifyDbInstanceOutput, crate::error::ModifyDBInstanceError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::modify_db_instance_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_modify_db_instance(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ModifyDBInstanceError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_db_parameter_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ModifyDbParameterGroupOutput,
    crate::error::ModifyDBParameterGroupError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ModifyDBParameterGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ModifyDBParameterGroupError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DBParameterGroupNotFound" => crate::error::ModifyDBParameterGroupError {
            meta: generic,
            kind: crate::error::ModifyDBParameterGroupErrorKind::DbParameterGroupNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::db_parameter_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_parameter_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyDBParameterGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidDBParameterGroupState" => {
            crate::error::ModifyDBParameterGroupError {
                meta: generic,
                kind:
                    crate::error::ModifyDBParameterGroupErrorKind::InvalidDbParameterGroupStateFault(
                        {
                            #[allow(unused_mut)]
                            let mut tmp = {
                                #[allow(unused_mut)]let mut output = crate::error::invalid_db_parameter_group_state_fault::Builder::default();
                                let _ = response;
                                output = crate::xml_deser::deser_structure_crate_error_invalid_db_parameter_group_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyDBParameterGroupError::unhandled)?;
                                output.build()
                            };
                            if (&tmp.message).is_none() {
                                tmp.message = _error_message;
                            }
                            tmp
                        },
                    ),
            }
        }
        _ => crate::error::ModifyDBParameterGroupError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_db_parameter_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ModifyDbParameterGroupOutput,
    crate::error::ModifyDBParameterGroupError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::modify_db_parameter_group_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_modify_db_parameter_group(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ModifyDBParameterGroupError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_db_proxy_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ModifyDbProxyOutput, crate::error::ModifyDBProxyError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ModifyDBProxyError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ModifyDBProxyError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DBProxyAlreadyExistsFault" => crate::error::ModifyDBProxyError {
            meta: generic,
            kind: crate::error::ModifyDBProxyErrorKind::DbProxyAlreadyExistsFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::db_proxy_already_exists_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_proxy_already_exists_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyDBProxyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DBProxyNotFoundFault" => crate::error::ModifyDBProxyError {
            meta: generic,
            kind: crate::error::ModifyDBProxyErrorKind::DbProxyNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::db_proxy_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_proxy_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyDBProxyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidDBProxyStateFault" => crate::error::ModifyDBProxyError {
            meta: generic,
            kind: crate::error::ModifyDBProxyErrorKind::InvalidDbProxyStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_db_proxy_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_db_proxy_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyDBProxyError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ModifyDBProxyError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_db_proxy_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ModifyDbProxyOutput, crate::error::ModifyDBProxyError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::modify_db_proxy_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_modify_db_proxy(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ModifyDBProxyError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_db_proxy_endpoint_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ModifyDbProxyEndpointOutput,
    crate::error::ModifyDBProxyEndpointError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ModifyDBProxyEndpointError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ModifyDBProxyEndpointError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DBProxyEndpointAlreadyExistsFault" => {
            crate::error::ModifyDBProxyEndpointError {
                meta: generic,
                kind:
                    crate::error::ModifyDBProxyEndpointErrorKind::DbProxyEndpointAlreadyExistsFault(
                        {
                            #[allow(unused_mut)]
                            let mut tmp = {
                                #[allow(unused_mut)]let mut output = crate::error::db_proxy_endpoint_already_exists_fault::Builder::default();
                                let _ = response;
                                output = crate::xml_deser::deser_structure_crate_error_db_proxy_endpoint_already_exists_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyDBProxyEndpointError::unhandled)?;
                                output.build()
                            };
                            if (&tmp.message).is_none() {
                                tmp.message = _error_message;
                            }
                            tmp
                        },
                    ),
            }
        }
        "DBProxyEndpointNotFoundFault" => crate::error::ModifyDBProxyEndpointError {
            meta: generic,
            kind: crate::error::ModifyDBProxyEndpointErrorKind::DbProxyEndpointNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::db_proxy_endpoint_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_proxy_endpoint_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyDBProxyEndpointError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidDBProxyEndpointStateFault" => crate::error::ModifyDBProxyEndpointError {
            meta: generic,
            kind: crate::error::ModifyDBProxyEndpointErrorKind::InvalidDbProxyEndpointStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_db_proxy_endpoint_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_db_proxy_endpoint_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyDBProxyEndpointError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidDBProxyStateFault" => crate::error::ModifyDBProxyEndpointError {
            meta: generic,
            kind: crate::error::ModifyDBProxyEndpointErrorKind::InvalidDbProxyStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_db_proxy_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_db_proxy_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyDBProxyEndpointError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ModifyDBProxyEndpointError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_db_proxy_endpoint_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ModifyDbProxyEndpointOutput,
    crate::error::ModifyDBProxyEndpointError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::modify_db_proxy_endpoint_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_modify_db_proxy_endpoint(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ModifyDBProxyEndpointError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_db_proxy_target_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ModifyDbProxyTargetGroupOutput,
    crate::error::ModifyDBProxyTargetGroupError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ModifyDBProxyTargetGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ModifyDBProxyTargetGroupError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DBProxyNotFoundFault" => crate::error::ModifyDBProxyTargetGroupError {
            meta: generic,
            kind: crate::error::ModifyDBProxyTargetGroupErrorKind::DbProxyNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::db_proxy_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_proxy_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyDBProxyTargetGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DBProxyTargetGroupNotFoundFault" => crate::error::ModifyDBProxyTargetGroupError {
            meta: generic,
            kind: crate::error::ModifyDBProxyTargetGroupErrorKind::DbProxyTargetGroupNotFoundFault(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::db_proxy_target_group_not_found_fault::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_db_proxy_target_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyDBProxyTargetGroupError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "InvalidDBProxyStateFault" => crate::error::ModifyDBProxyTargetGroupError {
            meta: generic,
            kind: crate::error::ModifyDBProxyTargetGroupErrorKind::InvalidDbProxyStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_db_proxy_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_db_proxy_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyDBProxyTargetGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ModifyDBProxyTargetGroupError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_db_proxy_target_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ModifyDbProxyTargetGroupOutput,
    crate::error::ModifyDBProxyTargetGroupError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::modify_db_proxy_target_group_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_modify_db_proxy_target_group(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ModifyDBProxyTargetGroupError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_db_snapshot_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ModifyDbSnapshotOutput, crate::error::ModifyDBSnapshotError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ModifyDBSnapshotError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ModifyDBSnapshotError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DBSnapshotNotFound" => crate::error::ModifyDBSnapshotError {
            meta: generic,
            kind: crate::error::ModifyDBSnapshotErrorKind::DbSnapshotNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::db_snapshot_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_snapshot_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyDBSnapshotError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ModifyDBSnapshotError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_db_snapshot_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ModifyDbSnapshotOutput, crate::error::ModifyDBSnapshotError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::modify_db_snapshot_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_modify_db_snapshot(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ModifyDBSnapshotError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_db_snapshot_attribute_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ModifyDbSnapshotAttributeOutput,
    crate::error::ModifyDBSnapshotAttributeError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ModifyDBSnapshotAttributeError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ModifyDBSnapshotAttributeError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DBSnapshotNotFound" => crate::error::ModifyDBSnapshotAttributeError {
            meta: generic,
            kind: crate::error::ModifyDBSnapshotAttributeErrorKind::DbSnapshotNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::db_snapshot_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_snapshot_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyDBSnapshotAttributeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidDBSnapshotState" => crate::error::ModifyDBSnapshotAttributeError {
            meta: generic,
            kind: crate::error::ModifyDBSnapshotAttributeErrorKind::InvalidDbSnapshotStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_db_snapshot_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_db_snapshot_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyDBSnapshotAttributeError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "SharedSnapshotQuotaExceeded" => crate::error::ModifyDBSnapshotAttributeError {
            meta: generic,
            kind:
                crate::error::ModifyDBSnapshotAttributeErrorKind::SharedSnapshotQuotaExceededFault(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]let mut output = crate::error::shared_snapshot_quota_exceeded_fault::Builder::default();
                            let _ = response;
                            output = crate::xml_deser::deser_structure_crate_error_shared_snapshot_quota_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyDBSnapshotAttributeError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        _ => crate::error::ModifyDBSnapshotAttributeError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_db_snapshot_attribute_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ModifyDbSnapshotAttributeOutput,
    crate::error::ModifyDBSnapshotAttributeError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::modify_db_snapshot_attribute_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_modify_db_snapshot_attribute(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ModifyDBSnapshotAttributeError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_db_subnet_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ModifyDbSubnetGroupOutput,
    crate::error::ModifyDBSubnetGroupError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ModifyDBSubnetGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ModifyDBSubnetGroupError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DBSubnetGroupDoesNotCoverEnoughAZs" => crate::error::ModifyDBSubnetGroupError {
            meta: generic,
            kind: crate::error::ModifyDBSubnetGroupErrorKind::DbSubnetGroupDoesNotCoverEnoughAZs({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::db_subnet_group_does_not_cover_enough_a_zs::Builder::default(
                        );
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_subnet_group_does_not_cover_enough_a_zs_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyDBSubnetGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DBSubnetGroupNotFoundFault" => crate::error::ModifyDBSubnetGroupError {
            meta: generic,
            kind: crate::error::ModifyDBSubnetGroupErrorKind::DbSubnetGroupNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::db_subnet_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_subnet_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyDBSubnetGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DBSubnetQuotaExceededFault" => crate::error::ModifyDBSubnetGroupError {
            meta: generic,
            kind: crate::error::ModifyDBSubnetGroupErrorKind::DbSubnetQuotaExceededFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::db_subnet_quota_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_subnet_quota_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyDBSubnetGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidSubnet" => crate::error::ModifyDBSubnetGroupError {
            meta: generic,
            kind: crate::error::ModifyDBSubnetGroupErrorKind::InvalidSubnet({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_subnet::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_subnet_xml_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::ModifyDBSubnetGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "SubnetAlreadyInUse" => crate::error::ModifyDBSubnetGroupError {
            meta: generic,
            kind: crate::error::ModifyDBSubnetGroupErrorKind::SubnetAlreadyInUse({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::subnet_already_in_use::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_subnet_already_in_use_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyDBSubnetGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ModifyDBSubnetGroupError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_db_subnet_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ModifyDbSubnetGroupOutput,
    crate::error::ModifyDBSubnetGroupError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::modify_db_subnet_group_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_modify_db_subnet_group(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ModifyDBSubnetGroupError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_event_subscription_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ModifyEventSubscriptionOutput,
    crate::error::ModifyEventSubscriptionError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ModifyEventSubscriptionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ModifyEventSubscriptionError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "EventSubscriptionQuotaExceeded" => crate::error::ModifyEventSubscriptionError {
            meta: generic,
            kind:
                crate::error::ModifyEventSubscriptionErrorKind::EventSubscriptionQuotaExceededFault(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]let mut output = crate::error::event_subscription_quota_exceeded_fault::Builder::default();
                            let _ = response;
                            output = crate::xml_deser::deser_structure_crate_error_event_subscription_quota_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyEventSubscriptionError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "SNSInvalidTopic" => crate::error::ModifyEventSubscriptionError {
            meta: generic,
            kind: crate::error::ModifyEventSubscriptionErrorKind::SnsInvalidTopicFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::sns_invalid_topic_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_sns_invalid_topic_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyEventSubscriptionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "SNSNoAuthorization" => crate::error::ModifyEventSubscriptionError {
            meta: generic,
            kind: crate::error::ModifyEventSubscriptionErrorKind::SnsNoAuthorizationFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::sns_no_authorization_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_sns_no_authorization_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyEventSubscriptionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "SNSTopicArnNotFound" => crate::error::ModifyEventSubscriptionError {
            meta: generic,
            kind: crate::error::ModifyEventSubscriptionErrorKind::SnsTopicArnNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::sns_topic_arn_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_sns_topic_arn_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyEventSubscriptionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "SubscriptionCategoryNotFound" => crate::error::ModifyEventSubscriptionError {
            meta: generic,
            kind: crate::error::ModifyEventSubscriptionErrorKind::SubscriptionCategoryNotFoundFault(
                {
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]
                        let mut output =
                            crate::error::subscription_category_not_found_fault::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_subscription_category_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyEventSubscriptionError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                },
            ),
        },
        "SubscriptionNotFound" => crate::error::ModifyEventSubscriptionError {
            meta: generic,
            kind: crate::error::ModifyEventSubscriptionErrorKind::SubscriptionNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::subscription_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_subscription_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyEventSubscriptionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ModifyEventSubscriptionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_event_subscription_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ModifyEventSubscriptionOutput,
    crate::error::ModifyEventSubscriptionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::modify_event_subscription_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_modify_event_subscription(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ModifyEventSubscriptionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_global_cluster_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ModifyGlobalClusterOutput,
    crate::error::ModifyGlobalClusterError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ModifyGlobalClusterError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ModifyGlobalClusterError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "GlobalClusterNotFoundFault" => crate::error::ModifyGlobalClusterError {
            meta: generic,
            kind: crate::error::ModifyGlobalClusterErrorKind::GlobalClusterNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::global_cluster_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_global_cluster_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyGlobalClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidDBClusterStateFault" => crate::error::ModifyGlobalClusterError {
            meta: generic,
            kind: crate::error::ModifyGlobalClusterErrorKind::InvalidDbClusterStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_db_cluster_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_db_cluster_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyGlobalClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidDBInstanceState" => crate::error::ModifyGlobalClusterError {
            meta: generic,
            kind: crate::error::ModifyGlobalClusterErrorKind::InvalidDbInstanceStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_db_instance_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_db_instance_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyGlobalClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidGlobalClusterStateFault" => crate::error::ModifyGlobalClusterError {
            meta: generic,
            kind: crate::error::ModifyGlobalClusterErrorKind::InvalidGlobalClusterStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_global_cluster_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_global_cluster_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyGlobalClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ModifyGlobalClusterError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_global_cluster_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ModifyGlobalClusterOutput,
    crate::error::ModifyGlobalClusterError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::modify_global_cluster_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_modify_global_cluster(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ModifyGlobalClusterError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_option_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ModifyOptionGroupOutput, crate::error::ModifyOptionGroupError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ModifyOptionGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ModifyOptionGroupError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InvalidOptionGroupStateFault" => crate::error::ModifyOptionGroupError {
            meta: generic,
            kind: crate::error::ModifyOptionGroupErrorKind::InvalidOptionGroupStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_option_group_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_option_group_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyOptionGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OptionGroupNotFoundFault" => crate::error::ModifyOptionGroupError {
            meta: generic,
            kind: crate::error::ModifyOptionGroupErrorKind::OptionGroupNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::option_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_option_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ModifyOptionGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::ModifyOptionGroupError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_modify_option_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::ModifyOptionGroupOutput, crate::error::ModifyOptionGroupError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::modify_option_group_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_modify_option_group(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ModifyOptionGroupError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_promote_read_replica_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PromoteReadReplicaOutput,
    crate::error::PromoteReadReplicaError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::PromoteReadReplicaError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::PromoteReadReplicaError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DBInstanceNotFound" => crate::error::PromoteReadReplicaError {
            meta: generic,
            kind: crate::error::PromoteReadReplicaErrorKind::DbInstanceNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::db_instance_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_instance_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::PromoteReadReplicaError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidDBInstanceState" => crate::error::PromoteReadReplicaError {
            meta: generic,
            kind: crate::error::PromoteReadReplicaErrorKind::InvalidDbInstanceStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_db_instance_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_db_instance_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::PromoteReadReplicaError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::PromoteReadReplicaError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_promote_read_replica_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PromoteReadReplicaOutput,
    crate::error::PromoteReadReplicaError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::promote_read_replica_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_promote_read_replica(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::PromoteReadReplicaError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_promote_read_replica_db_cluster_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PromoteReadReplicaDbClusterOutput,
    crate::error::PromoteReadReplicaDBClusterError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::PromoteReadReplicaDBClusterError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::PromoteReadReplicaDBClusterError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DBClusterNotFoundFault" => crate::error::PromoteReadReplicaDBClusterError {
            meta: generic,
            kind: crate::error::PromoteReadReplicaDBClusterErrorKind::DbClusterNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::db_cluster_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_cluster_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::PromoteReadReplicaDBClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidDBClusterStateFault" => crate::error::PromoteReadReplicaDBClusterError {
            meta: generic,
            kind: crate::error::PromoteReadReplicaDBClusterErrorKind::InvalidDbClusterStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_db_cluster_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_db_cluster_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::PromoteReadReplicaDBClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::PromoteReadReplicaDBClusterError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_promote_read_replica_db_cluster_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PromoteReadReplicaDbClusterOutput,
    crate::error::PromoteReadReplicaDBClusterError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::promote_read_replica_db_cluster_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_promote_read_replica_db_cluster(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::PromoteReadReplicaDBClusterError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_purchase_reserved_db_instances_offering_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PurchaseReservedDbInstancesOfferingOutput,
    crate::error::PurchaseReservedDBInstancesOfferingError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::PurchaseReservedDBInstancesOfferingError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::PurchaseReservedDBInstancesOfferingError::unhandled(generic))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "ReservedDBInstanceAlreadyExists" => crate::error::PurchaseReservedDBInstancesOfferingError { meta: generic, kind: crate::error::PurchaseReservedDBInstancesOfferingErrorKind::ReservedDbInstanceAlreadyExistsFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::reserved_db_instance_already_exists_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_reserved_db_instance_already_exists_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::PurchaseReservedDBInstancesOfferingError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ReservedDBInstanceQuotaExceeded" => crate::error::PurchaseReservedDBInstancesOfferingError { meta: generic, kind: crate::error::PurchaseReservedDBInstancesOfferingErrorKind::ReservedDbInstanceQuotaExceededFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::reserved_db_instance_quota_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_reserved_db_instance_quota_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::PurchaseReservedDBInstancesOfferingError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ReservedDBInstancesOfferingNotFound" => crate::error::PurchaseReservedDBInstancesOfferingError { meta: generic, kind: crate::error::PurchaseReservedDBInstancesOfferingErrorKind::ReservedDbInstancesOfferingNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::reserved_db_instances_offering_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_reserved_db_instances_offering_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::PurchaseReservedDBInstancesOfferingError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::PurchaseReservedDBInstancesOfferingError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_purchase_reserved_db_instances_offering_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::PurchaseReservedDbInstancesOfferingOutput,
    crate::error::PurchaseReservedDBInstancesOfferingError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::purchase_reserved_db_instances_offering_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_purchase_reserved_db_instances_offering(response.body().as_ref(), output).map_err(crate::error::PurchaseReservedDBInstancesOfferingError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_reboot_db_cluster_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::RebootDbClusterOutput, crate::error::RebootDBClusterError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::RebootDBClusterError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::RebootDBClusterError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DBClusterNotFoundFault" => crate::error::RebootDBClusterError {
            meta: generic,
            kind: crate::error::RebootDBClusterErrorKind::DbClusterNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::db_cluster_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_cluster_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RebootDBClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidDBClusterStateFault" => crate::error::RebootDBClusterError {
            meta: generic,
            kind: crate::error::RebootDBClusterErrorKind::InvalidDbClusterStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_db_cluster_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_db_cluster_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RebootDBClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidDBInstanceState" => crate::error::RebootDBClusterError {
            meta: generic,
            kind: crate::error::RebootDBClusterErrorKind::InvalidDbInstanceStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_db_instance_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_db_instance_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RebootDBClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::RebootDBClusterError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_reboot_db_cluster_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::RebootDbClusterOutput, crate::error::RebootDBClusterError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::reboot_db_cluster_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_reboot_db_cluster(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::RebootDBClusterError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_reboot_db_instance_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::RebootDbInstanceOutput, crate::error::RebootDBInstanceError>
{
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::RebootDBInstanceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::RebootDBInstanceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DBInstanceNotFound" => crate::error::RebootDBInstanceError {
            meta: generic,
            kind: crate::error::RebootDBInstanceErrorKind::DbInstanceNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::db_instance_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_instance_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RebootDBInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidDBInstanceState" => crate::error::RebootDBInstanceError {
            meta: generic,
            kind: crate::error::RebootDBInstanceErrorKind::InvalidDbInstanceStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_db_instance_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_db_instance_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RebootDBInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::RebootDBInstanceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_reboot_db_instance_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::RebootDbInstanceOutput, crate::error::RebootDBInstanceError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::reboot_db_instance_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_reboot_db_instance(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::RebootDBInstanceError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_register_db_proxy_targets_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RegisterDbProxyTargetsOutput,
    crate::error::RegisterDBProxyTargetsError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::RegisterDBProxyTargetsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::RegisterDBProxyTargetsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DBClusterNotFoundFault" => crate::error::RegisterDBProxyTargetsError {
            meta: generic,
            kind: crate::error::RegisterDBProxyTargetsErrorKind::DbClusterNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::db_cluster_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_cluster_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RegisterDBProxyTargetsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DBInstanceNotFound" => crate::error::RegisterDBProxyTargetsError {
            meta: generic,
            kind: crate::error::RegisterDBProxyTargetsErrorKind::DbInstanceNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::db_instance_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_instance_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RegisterDBProxyTargetsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DBProxyNotFoundFault" => crate::error::RegisterDBProxyTargetsError {
            meta: generic,
            kind: crate::error::RegisterDBProxyTargetsErrorKind::DbProxyNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::db_proxy_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_proxy_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RegisterDBProxyTargetsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DBProxyTargetAlreadyRegisteredFault" => crate::error::RegisterDBProxyTargetsError {
            meta: generic,
            kind:
                crate::error::RegisterDBProxyTargetsErrorKind::DbProxyTargetAlreadyRegisteredFault(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]let mut output = crate::error::db_proxy_target_already_registered_fault::Builder::default();
                            let _ = response;
                            output = crate::xml_deser::deser_structure_crate_error_db_proxy_target_already_registered_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RegisterDBProxyTargetsError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "DBProxyTargetGroupNotFoundFault" => crate::error::RegisterDBProxyTargetsError {
            meta: generic,
            kind: crate::error::RegisterDBProxyTargetsErrorKind::DbProxyTargetGroupNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::db_proxy_target_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_proxy_target_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RegisterDBProxyTargetsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InsufficientAvailableIPsInSubnetFault" => crate::error::RegisterDBProxyTargetsError {
            meta: generic,
            kind:
                crate::error::RegisterDBProxyTargetsErrorKind::InsufficientAvailableIPsInSubnetFault(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]let mut output = crate::error::insufficient_available_i_ps_in_subnet_fault::Builder::default();
                            let _ = response;
                            output = crate::xml_deser::deser_structure_crate_error_insufficient_available_i_ps_in_subnet_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RegisterDBProxyTargetsError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "InvalidDBClusterStateFault" => crate::error::RegisterDBProxyTargetsError {
            meta: generic,
            kind: crate::error::RegisterDBProxyTargetsErrorKind::InvalidDbClusterStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_db_cluster_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_db_cluster_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RegisterDBProxyTargetsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidDBInstanceState" => crate::error::RegisterDBProxyTargetsError {
            meta: generic,
            kind: crate::error::RegisterDBProxyTargetsErrorKind::InvalidDbInstanceStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_db_instance_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_db_instance_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RegisterDBProxyTargetsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidDBProxyStateFault" => crate::error::RegisterDBProxyTargetsError {
            meta: generic,
            kind: crate::error::RegisterDBProxyTargetsErrorKind::InvalidDbProxyStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_db_proxy_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_db_proxy_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RegisterDBProxyTargetsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::RegisterDBProxyTargetsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_register_db_proxy_targets_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RegisterDbProxyTargetsOutput,
    crate::error::RegisterDBProxyTargetsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::register_db_proxy_targets_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_register_db_proxy_targets(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::RegisterDBProxyTargetsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_remove_from_global_cluster_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RemoveFromGlobalClusterOutput,
    crate::error::RemoveFromGlobalClusterError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::RemoveFromGlobalClusterError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::RemoveFromGlobalClusterError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DBClusterNotFoundFault" => crate::error::RemoveFromGlobalClusterError {
            meta: generic,
            kind: crate::error::RemoveFromGlobalClusterErrorKind::DbClusterNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::db_cluster_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_cluster_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RemoveFromGlobalClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "GlobalClusterNotFoundFault" => crate::error::RemoveFromGlobalClusterError {
            meta: generic,
            kind: crate::error::RemoveFromGlobalClusterErrorKind::GlobalClusterNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::global_cluster_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_global_cluster_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RemoveFromGlobalClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidGlobalClusterStateFault" => crate::error::RemoveFromGlobalClusterError {
            meta: generic,
            kind: crate::error::RemoveFromGlobalClusterErrorKind::InvalidGlobalClusterStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_global_cluster_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_global_cluster_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RemoveFromGlobalClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::RemoveFromGlobalClusterError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_remove_from_global_cluster_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RemoveFromGlobalClusterOutput,
    crate::error::RemoveFromGlobalClusterError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::remove_from_global_cluster_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_remove_from_global_cluster(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::RemoveFromGlobalClusterError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_remove_role_from_db_cluster_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RemoveRoleFromDbClusterOutput,
    crate::error::RemoveRoleFromDBClusterError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::RemoveRoleFromDBClusterError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::RemoveRoleFromDBClusterError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DBClusterNotFoundFault" => crate::error::RemoveRoleFromDBClusterError {
            meta: generic,
            kind: crate::error::RemoveRoleFromDBClusterErrorKind::DbClusterNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::db_cluster_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_cluster_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RemoveRoleFromDBClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DBClusterRoleNotFound" => crate::error::RemoveRoleFromDBClusterError {
            meta: generic,
            kind: crate::error::RemoveRoleFromDBClusterErrorKind::DbClusterRoleNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::db_cluster_role_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_cluster_role_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RemoveRoleFromDBClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidDBClusterStateFault" => crate::error::RemoveRoleFromDBClusterError {
            meta: generic,
            kind: crate::error::RemoveRoleFromDBClusterErrorKind::InvalidDbClusterStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_db_cluster_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_db_cluster_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RemoveRoleFromDBClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::RemoveRoleFromDBClusterError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_remove_role_from_db_cluster_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RemoveRoleFromDbClusterOutput,
    crate::error::RemoveRoleFromDBClusterError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::remove_role_from_db_cluster_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_remove_role_from_db_instance_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RemoveRoleFromDbInstanceOutput,
    crate::error::RemoveRoleFromDBInstanceError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::RemoveRoleFromDBInstanceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::RemoveRoleFromDBInstanceError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DBInstanceNotFound" => crate::error::RemoveRoleFromDBInstanceError {
            meta: generic,
            kind: crate::error::RemoveRoleFromDBInstanceErrorKind::DbInstanceNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::db_instance_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_instance_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RemoveRoleFromDBInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DBInstanceRoleNotFound" => crate::error::RemoveRoleFromDBInstanceError {
            meta: generic,
            kind: crate::error::RemoveRoleFromDBInstanceErrorKind::DbInstanceRoleNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::db_instance_role_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_instance_role_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RemoveRoleFromDBInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidDBInstanceState" => crate::error::RemoveRoleFromDBInstanceError {
            meta: generic,
            kind: crate::error::RemoveRoleFromDBInstanceErrorKind::InvalidDbInstanceStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_db_instance_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_db_instance_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RemoveRoleFromDBInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::RemoveRoleFromDBInstanceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_remove_role_from_db_instance_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RemoveRoleFromDbInstanceOutput,
    crate::error::RemoveRoleFromDBInstanceError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::remove_role_from_db_instance_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_remove_source_identifier_from_subscription_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RemoveSourceIdentifierFromSubscriptionOutput,
    crate::error::RemoveSourceIdentifierFromSubscriptionError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::RemoveSourceIdentifierFromSubscriptionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(
                crate::error::RemoveSourceIdentifierFromSubscriptionError::unhandled(generic),
            )
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "SourceNotFound" => crate::error::RemoveSourceIdentifierFromSubscriptionError { meta: generic, kind: crate::error::RemoveSourceIdentifierFromSubscriptionErrorKind::SourceNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::source_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_source_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RemoveSourceIdentifierFromSubscriptionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "SubscriptionNotFound" => crate::error::RemoveSourceIdentifierFromSubscriptionError { meta: generic, kind: crate::error::RemoveSourceIdentifierFromSubscriptionErrorKind::SubscriptionNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::subscription_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_subscription_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RemoveSourceIdentifierFromSubscriptionError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::RemoveSourceIdentifierFromSubscriptionError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_remove_source_identifier_from_subscription_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RemoveSourceIdentifierFromSubscriptionOutput,
    crate::error::RemoveSourceIdentifierFromSubscriptionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::remove_source_identifier_from_subscription_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_remove_source_identifier_from_subscription(response.body().as_ref(), output).map_err(crate::error::RemoveSourceIdentifierFromSubscriptionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_remove_tags_from_resource_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RemoveTagsFromResourceOutput,
    crate::error::RemoveTagsFromResourceError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::RemoveTagsFromResourceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::RemoveTagsFromResourceError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DBClusterNotFoundFault" => crate::error::RemoveTagsFromResourceError {
            meta: generic,
            kind: crate::error::RemoveTagsFromResourceErrorKind::DbClusterNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::db_cluster_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_cluster_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RemoveTagsFromResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DBInstanceNotFound" => crate::error::RemoveTagsFromResourceError {
            meta: generic,
            kind: crate::error::RemoveTagsFromResourceErrorKind::DbInstanceNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::db_instance_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_instance_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RemoveTagsFromResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DBProxyNotFoundFault" => crate::error::RemoveTagsFromResourceError {
            meta: generic,
            kind: crate::error::RemoveTagsFromResourceErrorKind::DbProxyNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::db_proxy_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_proxy_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RemoveTagsFromResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DBProxyTargetGroupNotFoundFault" => crate::error::RemoveTagsFromResourceError {
            meta: generic,
            kind: crate::error::RemoveTagsFromResourceErrorKind::DbProxyTargetGroupNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::db_proxy_target_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_proxy_target_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RemoveTagsFromResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DBSnapshotNotFound" => crate::error::RemoveTagsFromResourceError {
            meta: generic,
            kind: crate::error::RemoveTagsFromResourceErrorKind::DbSnapshotNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::db_snapshot_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_snapshot_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RemoveTagsFromResourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::RemoveTagsFromResourceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_remove_tags_from_resource_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RemoveTagsFromResourceOutput,
    crate::error::RemoveTagsFromResourceError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::remove_tags_from_resource_output::Builder::default();
        let _ = response;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_reset_db_cluster_parameter_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ResetDbClusterParameterGroupOutput,
    crate::error::ResetDBClusterParameterGroupError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ResetDBClusterParameterGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::ResetDBClusterParameterGroupError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DBParameterGroupNotFound" => crate::error::ResetDBClusterParameterGroupError { meta: generic, kind: crate::error::ResetDBClusterParameterGroupErrorKind::DbParameterGroupNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::db_parameter_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_parameter_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ResetDBClusterParameterGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidDBParameterGroupState" => crate::error::ResetDBClusterParameterGroupError { meta: generic, kind: crate::error::ResetDBClusterParameterGroupErrorKind::InvalidDbParameterGroupStateFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_db_parameter_group_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_db_parameter_group_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ResetDBClusterParameterGroupError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::ResetDBClusterParameterGroupError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_reset_db_cluster_parameter_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ResetDbClusterParameterGroupOutput,
    crate::error::ResetDBClusterParameterGroupError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::reset_db_cluster_parameter_group_output::Builder::default();
        let _ = response;
        output =
            crate::xml_deser::deser_operation_crate_operation_reset_db_cluster_parameter_group(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::ResetDBClusterParameterGroupError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_reset_db_parameter_group_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ResetDbParameterGroupOutput,
    crate::error::ResetDBParameterGroupError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::ResetDBParameterGroupError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::ResetDBParameterGroupError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DBParameterGroupNotFound" => crate::error::ResetDBParameterGroupError {
            meta: generic,
            kind: crate::error::ResetDBParameterGroupErrorKind::DbParameterGroupNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::db_parameter_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_parameter_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ResetDBParameterGroupError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidDBParameterGroupState" => {
            crate::error::ResetDBParameterGroupError {
                meta: generic,
                kind:
                    crate::error::ResetDBParameterGroupErrorKind::InvalidDbParameterGroupStateFault(
                        {
                            #[allow(unused_mut)]
                            let mut tmp = {
                                #[allow(unused_mut)]let mut output = crate::error::invalid_db_parameter_group_state_fault::Builder::default();
                                let _ = response;
                                output = crate::xml_deser::deser_structure_crate_error_invalid_db_parameter_group_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::ResetDBParameterGroupError::unhandled)?;
                                output.build()
                            };
                            if (&tmp.message).is_none() {
                                tmp.message = _error_message;
                            }
                            tmp
                        },
                    ),
            }
        }
        _ => crate::error::ResetDBParameterGroupError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_reset_db_parameter_group_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::ResetDbParameterGroupOutput,
    crate::error::ResetDBParameterGroupError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::reset_db_parameter_group_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_reset_db_parameter_group(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::ResetDBParameterGroupError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_restore_db_cluster_from_s3_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RestoreDbClusterFromS3Output,
    crate::error::RestoreDBClusterFromS3Error,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::RestoreDBClusterFromS3Error::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::RestoreDBClusterFromS3Error::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DBClusterAlreadyExistsFault" => crate::error::RestoreDBClusterFromS3Error { meta: generic, kind: crate::error::RestoreDBClusterFromS3ErrorKind::DbClusterAlreadyExistsFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::db_cluster_already_exists_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_cluster_already_exists_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreDBClusterFromS3Error::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "DBClusterNotFoundFault" => crate::error::RestoreDBClusterFromS3Error { meta: generic, kind: crate::error::RestoreDBClusterFromS3ErrorKind::DbClusterNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::db_cluster_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_cluster_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreDBClusterFromS3Error::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "DBClusterParameterGroupNotFound" => crate::error::RestoreDBClusterFromS3Error { meta: generic, kind: crate::error::RestoreDBClusterFromS3ErrorKind::DbClusterParameterGroupNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::db_cluster_parameter_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_cluster_parameter_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreDBClusterFromS3Error::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "DBClusterQuotaExceededFault" => crate::error::RestoreDBClusterFromS3Error { meta: generic, kind: crate::error::RestoreDBClusterFromS3ErrorKind::DbClusterQuotaExceededFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::db_cluster_quota_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_cluster_quota_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreDBClusterFromS3Error::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "DBSubnetGroupNotFoundFault" => crate::error::RestoreDBClusterFromS3Error { meta: generic, kind: crate::error::RestoreDBClusterFromS3ErrorKind::DbSubnetGroupNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::db_subnet_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_subnet_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreDBClusterFromS3Error::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "DomainNotFoundFault" => crate::error::RestoreDBClusterFromS3Error { meta: generic, kind: crate::error::RestoreDBClusterFromS3ErrorKind::DomainNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::domain_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_domain_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreDBClusterFromS3Error::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InsufficientStorageClusterCapacity" => crate::error::RestoreDBClusterFromS3Error { meta: generic, kind: crate::error::RestoreDBClusterFromS3ErrorKind::InsufficientStorageClusterCapacityFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::insufficient_storage_cluster_capacity_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_insufficient_storage_cluster_capacity_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreDBClusterFromS3Error::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidDBClusterStateFault" => crate::error::RestoreDBClusterFromS3Error { meta: generic, kind: crate::error::RestoreDBClusterFromS3ErrorKind::InvalidDbClusterStateFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_db_cluster_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_db_cluster_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreDBClusterFromS3Error::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidDBSubnetGroupStateFault" => crate::error::RestoreDBClusterFromS3Error { meta: generic, kind: crate::error::RestoreDBClusterFromS3ErrorKind::InvalidDbSubnetGroupStateFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_db_subnet_group_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_db_subnet_group_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreDBClusterFromS3Error::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidS3BucketFault" => crate::error::RestoreDBClusterFromS3Error { meta: generic, kind: crate::error::RestoreDBClusterFromS3ErrorKind::InvalidS3BucketFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_s3_bucket_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_s3_bucket_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreDBClusterFromS3Error::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidSubnet" => crate::error::RestoreDBClusterFromS3Error { meta: generic, kind: crate::error::RestoreDBClusterFromS3ErrorKind::InvalidSubnet({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_subnet::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_subnet_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreDBClusterFromS3Error::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidVPCNetworkStateFault" => crate::error::RestoreDBClusterFromS3Error { meta: generic, kind: crate::error::RestoreDBClusterFromS3ErrorKind::InvalidVpcNetworkStateFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_vpc_network_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_vpc_network_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreDBClusterFromS3Error::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "KMSKeyNotAccessibleFault" => crate::error::RestoreDBClusterFromS3Error { meta: generic, kind: crate::error::RestoreDBClusterFromS3ErrorKind::KmsKeyNotAccessibleFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::kms_key_not_accessible_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_kms_key_not_accessible_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreDBClusterFromS3Error::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "StorageQuotaExceeded" => crate::error::RestoreDBClusterFromS3Error { meta: generic, kind: crate::error::RestoreDBClusterFromS3ErrorKind::StorageQuotaExceededFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::storage_quota_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_storage_quota_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreDBClusterFromS3Error::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::RestoreDBClusterFromS3Error::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_restore_db_cluster_from_s3_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RestoreDbClusterFromS3Output,
    crate::error::RestoreDBClusterFromS3Error,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::restore_db_cluster_from_s3_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_restore_db_cluster_from_s3(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::RestoreDBClusterFromS3Error::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_restore_db_cluster_from_snapshot_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RestoreDbClusterFromSnapshotOutput,
    crate::error::RestoreDBClusterFromSnapshotError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::RestoreDBClusterFromSnapshotError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::RestoreDBClusterFromSnapshotError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DBClusterAlreadyExistsFault" => crate::error::RestoreDBClusterFromSnapshotError { meta: generic, kind: crate::error::RestoreDBClusterFromSnapshotErrorKind::DbClusterAlreadyExistsFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::db_cluster_already_exists_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_cluster_already_exists_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreDBClusterFromSnapshotError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "DBClusterParameterGroupNotFound" => crate::error::RestoreDBClusterFromSnapshotError { meta: generic, kind: crate::error::RestoreDBClusterFromSnapshotErrorKind::DbClusterParameterGroupNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::db_cluster_parameter_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_cluster_parameter_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreDBClusterFromSnapshotError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "DBClusterQuotaExceededFault" => crate::error::RestoreDBClusterFromSnapshotError { meta: generic, kind: crate::error::RestoreDBClusterFromSnapshotErrorKind::DbClusterQuotaExceededFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::db_cluster_quota_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_cluster_quota_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreDBClusterFromSnapshotError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "DBClusterSnapshotNotFoundFault" => crate::error::RestoreDBClusterFromSnapshotError { meta: generic, kind: crate::error::RestoreDBClusterFromSnapshotErrorKind::DbClusterSnapshotNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::db_cluster_snapshot_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_cluster_snapshot_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreDBClusterFromSnapshotError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "DBSnapshotNotFound" => crate::error::RestoreDBClusterFromSnapshotError { meta: generic, kind: crate::error::RestoreDBClusterFromSnapshotErrorKind::DbSnapshotNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::db_snapshot_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_snapshot_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreDBClusterFromSnapshotError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "DBSubnetGroupNotFoundFault" => crate::error::RestoreDBClusterFromSnapshotError { meta: generic, kind: crate::error::RestoreDBClusterFromSnapshotErrorKind::DbSubnetGroupNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::db_subnet_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_subnet_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreDBClusterFromSnapshotError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "DomainNotFoundFault" => crate::error::RestoreDBClusterFromSnapshotError { meta: generic, kind: crate::error::RestoreDBClusterFromSnapshotErrorKind::DomainNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::domain_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_domain_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreDBClusterFromSnapshotError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InsufficientDBClusterCapacityFault" => crate::error::RestoreDBClusterFromSnapshotError { meta: generic, kind: crate::error::RestoreDBClusterFromSnapshotErrorKind::InsufficientDbClusterCapacityFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::insufficient_db_cluster_capacity_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_insufficient_db_cluster_capacity_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreDBClusterFromSnapshotError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InsufficientStorageClusterCapacity" => crate::error::RestoreDBClusterFromSnapshotError { meta: generic, kind: crate::error::RestoreDBClusterFromSnapshotErrorKind::InsufficientStorageClusterCapacityFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::insufficient_storage_cluster_capacity_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_insufficient_storage_cluster_capacity_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreDBClusterFromSnapshotError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidDBClusterSnapshotStateFault" => crate::error::RestoreDBClusterFromSnapshotError { meta: generic, kind: crate::error::RestoreDBClusterFromSnapshotErrorKind::InvalidDbClusterSnapshotStateFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_db_cluster_snapshot_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_db_cluster_snapshot_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreDBClusterFromSnapshotError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidDBSnapshotState" => crate::error::RestoreDBClusterFromSnapshotError { meta: generic, kind: crate::error::RestoreDBClusterFromSnapshotErrorKind::InvalidDbSnapshotStateFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_db_snapshot_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_db_snapshot_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreDBClusterFromSnapshotError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidRestoreFault" => crate::error::RestoreDBClusterFromSnapshotError { meta: generic, kind: crate::error::RestoreDBClusterFromSnapshotErrorKind::InvalidRestoreFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_restore_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_restore_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreDBClusterFromSnapshotError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidSubnet" => crate::error::RestoreDBClusterFromSnapshotError { meta: generic, kind: crate::error::RestoreDBClusterFromSnapshotErrorKind::InvalidSubnet({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_subnet::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_subnet_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreDBClusterFromSnapshotError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidVPCNetworkStateFault" => crate::error::RestoreDBClusterFromSnapshotError { meta: generic, kind: crate::error::RestoreDBClusterFromSnapshotErrorKind::InvalidVpcNetworkStateFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_vpc_network_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_vpc_network_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreDBClusterFromSnapshotError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "KMSKeyNotAccessibleFault" => crate::error::RestoreDBClusterFromSnapshotError { meta: generic, kind: crate::error::RestoreDBClusterFromSnapshotErrorKind::KmsKeyNotAccessibleFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::kms_key_not_accessible_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_kms_key_not_accessible_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreDBClusterFromSnapshotError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "OptionGroupNotFoundFault" => crate::error::RestoreDBClusterFromSnapshotError { meta: generic, kind: crate::error::RestoreDBClusterFromSnapshotErrorKind::OptionGroupNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::option_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_option_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreDBClusterFromSnapshotError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "StorageQuotaExceeded" => crate::error::RestoreDBClusterFromSnapshotError { meta: generic, kind: crate::error::RestoreDBClusterFromSnapshotErrorKind::StorageQuotaExceededFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::storage_quota_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_storage_quota_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreDBClusterFromSnapshotError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::RestoreDBClusterFromSnapshotError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_restore_db_cluster_from_snapshot_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RestoreDbClusterFromSnapshotOutput,
    crate::error::RestoreDBClusterFromSnapshotError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::restore_db_cluster_from_snapshot_output::Builder::default();
        let _ = response;
        output =
            crate::xml_deser::deser_operation_crate_operation_restore_db_cluster_from_snapshot(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::RestoreDBClusterFromSnapshotError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_restore_db_cluster_to_point_in_time_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RestoreDbClusterToPointInTimeOutput,
    crate::error::RestoreDBClusterToPointInTimeError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::RestoreDBClusterToPointInTimeError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::RestoreDBClusterToPointInTimeError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DBClusterAlreadyExistsFault" => crate::error::RestoreDBClusterToPointInTimeError { meta: generic, kind: crate::error::RestoreDBClusterToPointInTimeErrorKind::DbClusterAlreadyExistsFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::db_cluster_already_exists_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_cluster_already_exists_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreDBClusterToPointInTimeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "DBClusterNotFoundFault" => crate::error::RestoreDBClusterToPointInTimeError { meta: generic, kind: crate::error::RestoreDBClusterToPointInTimeErrorKind::DbClusterNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::db_cluster_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_cluster_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreDBClusterToPointInTimeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "DBClusterParameterGroupNotFound" => crate::error::RestoreDBClusterToPointInTimeError { meta: generic, kind: crate::error::RestoreDBClusterToPointInTimeErrorKind::DbClusterParameterGroupNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::db_cluster_parameter_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_cluster_parameter_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreDBClusterToPointInTimeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "DBClusterQuotaExceededFault" => crate::error::RestoreDBClusterToPointInTimeError { meta: generic, kind: crate::error::RestoreDBClusterToPointInTimeErrorKind::DbClusterQuotaExceededFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::db_cluster_quota_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_cluster_quota_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreDBClusterToPointInTimeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "DBClusterSnapshotNotFoundFault" => crate::error::RestoreDBClusterToPointInTimeError { meta: generic, kind: crate::error::RestoreDBClusterToPointInTimeErrorKind::DbClusterSnapshotNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::db_cluster_snapshot_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_cluster_snapshot_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreDBClusterToPointInTimeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "DBSubnetGroupNotFoundFault" => crate::error::RestoreDBClusterToPointInTimeError { meta: generic, kind: crate::error::RestoreDBClusterToPointInTimeErrorKind::DbSubnetGroupNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::db_subnet_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_subnet_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreDBClusterToPointInTimeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "DomainNotFoundFault" => crate::error::RestoreDBClusterToPointInTimeError { meta: generic, kind: crate::error::RestoreDBClusterToPointInTimeErrorKind::DomainNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::domain_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_domain_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreDBClusterToPointInTimeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InsufficientDBClusterCapacityFault" => crate::error::RestoreDBClusterToPointInTimeError { meta: generic, kind: crate::error::RestoreDBClusterToPointInTimeErrorKind::InsufficientDbClusterCapacityFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::insufficient_db_cluster_capacity_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_insufficient_db_cluster_capacity_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreDBClusterToPointInTimeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InsufficientStorageClusterCapacity" => crate::error::RestoreDBClusterToPointInTimeError { meta: generic, kind: crate::error::RestoreDBClusterToPointInTimeErrorKind::InsufficientStorageClusterCapacityFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::insufficient_storage_cluster_capacity_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_insufficient_storage_cluster_capacity_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreDBClusterToPointInTimeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidDBClusterSnapshotStateFault" => crate::error::RestoreDBClusterToPointInTimeError { meta: generic, kind: crate::error::RestoreDBClusterToPointInTimeErrorKind::InvalidDbClusterSnapshotStateFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_db_cluster_snapshot_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_db_cluster_snapshot_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreDBClusterToPointInTimeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidDBClusterStateFault" => crate::error::RestoreDBClusterToPointInTimeError { meta: generic, kind: crate::error::RestoreDBClusterToPointInTimeErrorKind::InvalidDbClusterStateFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_db_cluster_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_db_cluster_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreDBClusterToPointInTimeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidDBSnapshotState" => crate::error::RestoreDBClusterToPointInTimeError { meta: generic, kind: crate::error::RestoreDBClusterToPointInTimeErrorKind::InvalidDbSnapshotStateFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_db_snapshot_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_db_snapshot_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreDBClusterToPointInTimeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidRestoreFault" => crate::error::RestoreDBClusterToPointInTimeError { meta: generic, kind: crate::error::RestoreDBClusterToPointInTimeErrorKind::InvalidRestoreFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_restore_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_restore_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreDBClusterToPointInTimeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidSubnet" => crate::error::RestoreDBClusterToPointInTimeError { meta: generic, kind: crate::error::RestoreDBClusterToPointInTimeErrorKind::InvalidSubnet({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_subnet::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_subnet_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreDBClusterToPointInTimeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidVPCNetworkStateFault" => crate::error::RestoreDBClusterToPointInTimeError { meta: generic, kind: crate::error::RestoreDBClusterToPointInTimeErrorKind::InvalidVpcNetworkStateFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_vpc_network_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_vpc_network_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreDBClusterToPointInTimeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "KMSKeyNotAccessibleFault" => crate::error::RestoreDBClusterToPointInTimeError { meta: generic, kind: crate::error::RestoreDBClusterToPointInTimeErrorKind::KmsKeyNotAccessibleFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::kms_key_not_accessible_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_kms_key_not_accessible_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreDBClusterToPointInTimeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "OptionGroupNotFoundFault" => crate::error::RestoreDBClusterToPointInTimeError { meta: generic, kind: crate::error::RestoreDBClusterToPointInTimeErrorKind::OptionGroupNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::option_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_option_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreDBClusterToPointInTimeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "StorageQuotaExceeded" => crate::error::RestoreDBClusterToPointInTimeError { meta: generic, kind: crate::error::RestoreDBClusterToPointInTimeErrorKind::StorageQuotaExceededFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::storage_quota_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_storage_quota_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreDBClusterToPointInTimeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::RestoreDBClusterToPointInTimeError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_restore_db_cluster_to_point_in_time_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RestoreDbClusterToPointInTimeOutput,
    crate::error::RestoreDBClusterToPointInTimeError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::restore_db_cluster_to_point_in_time_output::Builder::default();
        let _ = response;
        output =
            crate::xml_deser::deser_operation_crate_operation_restore_db_cluster_to_point_in_time(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::RestoreDBClusterToPointInTimeError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_restore_db_instance_from_db_snapshot_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RestoreDbInstanceFromDbSnapshotOutput,
    crate::error::RestoreDBInstanceFromDBSnapshotError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::RestoreDBInstanceFromDBSnapshotError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::RestoreDBInstanceFromDBSnapshotError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AuthorizationNotFound" => crate::error::RestoreDBInstanceFromDBSnapshotError { meta: generic, kind: crate::error::RestoreDBInstanceFromDBSnapshotErrorKind::AuthorizationNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::authorization_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_authorization_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreDBInstanceFromDBSnapshotError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "BackupPolicyNotFoundFault" => crate::error::RestoreDBInstanceFromDBSnapshotError { meta: generic, kind: crate::error::RestoreDBInstanceFromDBSnapshotErrorKind::BackupPolicyNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::backup_policy_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_backup_policy_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreDBInstanceFromDBSnapshotError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "DBInstanceAlreadyExists" => crate::error::RestoreDBInstanceFromDBSnapshotError { meta: generic, kind: crate::error::RestoreDBInstanceFromDBSnapshotErrorKind::DbInstanceAlreadyExistsFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::db_instance_already_exists_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_instance_already_exists_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreDBInstanceFromDBSnapshotError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "DBParameterGroupNotFound" => crate::error::RestoreDBInstanceFromDBSnapshotError { meta: generic, kind: crate::error::RestoreDBInstanceFromDBSnapshotErrorKind::DbParameterGroupNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::db_parameter_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_parameter_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreDBInstanceFromDBSnapshotError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "DBSecurityGroupNotFound" => crate::error::RestoreDBInstanceFromDBSnapshotError { meta: generic, kind: crate::error::RestoreDBInstanceFromDBSnapshotErrorKind::DbSecurityGroupNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::db_security_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_security_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreDBInstanceFromDBSnapshotError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "DBSnapshotNotFound" => crate::error::RestoreDBInstanceFromDBSnapshotError { meta: generic, kind: crate::error::RestoreDBInstanceFromDBSnapshotErrorKind::DbSnapshotNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::db_snapshot_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_snapshot_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreDBInstanceFromDBSnapshotError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "DBSubnetGroupDoesNotCoverEnoughAZs" => crate::error::RestoreDBInstanceFromDBSnapshotError { meta: generic, kind: crate::error::RestoreDBInstanceFromDBSnapshotErrorKind::DbSubnetGroupDoesNotCoverEnoughAZs({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::db_subnet_group_does_not_cover_enough_a_zs::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_subnet_group_does_not_cover_enough_a_zs_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreDBInstanceFromDBSnapshotError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "DBSubnetGroupNotFoundFault" => crate::error::RestoreDBInstanceFromDBSnapshotError { meta: generic, kind: crate::error::RestoreDBInstanceFromDBSnapshotErrorKind::DbSubnetGroupNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::db_subnet_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_subnet_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreDBInstanceFromDBSnapshotError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "DomainNotFoundFault" => crate::error::RestoreDBInstanceFromDBSnapshotError { meta: generic, kind: crate::error::RestoreDBInstanceFromDBSnapshotErrorKind::DomainNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::domain_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_domain_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreDBInstanceFromDBSnapshotError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InstanceQuotaExceeded" => crate::error::RestoreDBInstanceFromDBSnapshotError { meta: generic, kind: crate::error::RestoreDBInstanceFromDBSnapshotErrorKind::InstanceQuotaExceededFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::instance_quota_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_instance_quota_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreDBInstanceFromDBSnapshotError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InsufficientDBInstanceCapacity" => crate::error::RestoreDBInstanceFromDBSnapshotError { meta: generic, kind: crate::error::RestoreDBInstanceFromDBSnapshotErrorKind::InsufficientDbInstanceCapacityFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::insufficient_db_instance_capacity_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_insufficient_db_instance_capacity_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreDBInstanceFromDBSnapshotError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidDBSnapshotState" => crate::error::RestoreDBInstanceFromDBSnapshotError { meta: generic, kind: crate::error::RestoreDBInstanceFromDBSnapshotErrorKind::InvalidDbSnapshotStateFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_db_snapshot_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_db_snapshot_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreDBInstanceFromDBSnapshotError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidRestoreFault" => crate::error::RestoreDBInstanceFromDBSnapshotError { meta: generic, kind: crate::error::RestoreDBInstanceFromDBSnapshotErrorKind::InvalidRestoreFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_restore_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_restore_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreDBInstanceFromDBSnapshotError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidSubnet" => crate::error::RestoreDBInstanceFromDBSnapshotError { meta: generic, kind: crate::error::RestoreDBInstanceFromDBSnapshotErrorKind::InvalidSubnet({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_subnet::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_subnet_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreDBInstanceFromDBSnapshotError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidVPCNetworkStateFault" => crate::error::RestoreDBInstanceFromDBSnapshotError { meta: generic, kind: crate::error::RestoreDBInstanceFromDBSnapshotErrorKind::InvalidVpcNetworkStateFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_vpc_network_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_vpc_network_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreDBInstanceFromDBSnapshotError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "KMSKeyNotAccessibleFault" => crate::error::RestoreDBInstanceFromDBSnapshotError { meta: generic, kind: crate::error::RestoreDBInstanceFromDBSnapshotErrorKind::KmsKeyNotAccessibleFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::kms_key_not_accessible_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_kms_key_not_accessible_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreDBInstanceFromDBSnapshotError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "OptionGroupNotFoundFault" => crate::error::RestoreDBInstanceFromDBSnapshotError { meta: generic, kind: crate::error::RestoreDBInstanceFromDBSnapshotErrorKind::OptionGroupNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::option_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_option_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreDBInstanceFromDBSnapshotError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ProvisionedIopsNotAvailableInAZFault" => crate::error::RestoreDBInstanceFromDBSnapshotError { meta: generic, kind: crate::error::RestoreDBInstanceFromDBSnapshotErrorKind::ProvisionedIopsNotAvailableInAzFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::provisioned_iops_not_available_in_az_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_provisioned_iops_not_available_in_az_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreDBInstanceFromDBSnapshotError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "StorageQuotaExceeded" => crate::error::RestoreDBInstanceFromDBSnapshotError { meta: generic, kind: crate::error::RestoreDBInstanceFromDBSnapshotErrorKind::StorageQuotaExceededFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::storage_quota_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_storage_quota_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreDBInstanceFromDBSnapshotError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "StorageTypeNotSupported" => crate::error::RestoreDBInstanceFromDBSnapshotError { meta: generic, kind: crate::error::RestoreDBInstanceFromDBSnapshotErrorKind::StorageTypeNotSupportedFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::storage_type_not_supported_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_storage_type_not_supported_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreDBInstanceFromDBSnapshotError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::RestoreDBInstanceFromDBSnapshotError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_restore_db_instance_from_db_snapshot_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RestoreDbInstanceFromDbSnapshotOutput,
    crate::error::RestoreDBInstanceFromDBSnapshotError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::restore_db_instance_from_db_snapshot_output::Builder::default();
        let _ = response;
        output =
            crate::xml_deser::deser_operation_crate_operation_restore_db_instance_from_db_snapshot(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::RestoreDBInstanceFromDBSnapshotError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_restore_db_instance_from_s3_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RestoreDbInstanceFromS3Output,
    crate::error::RestoreDBInstanceFromS3Error,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::RestoreDBInstanceFromS3Error::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::RestoreDBInstanceFromS3Error::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AuthorizationNotFound" => crate::error::RestoreDBInstanceFromS3Error {
            meta: generic,
            kind: crate::error::RestoreDBInstanceFromS3ErrorKind::AuthorizationNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::authorization_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_authorization_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreDBInstanceFromS3Error::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "BackupPolicyNotFoundFault" => crate::error::RestoreDBInstanceFromS3Error {
            meta: generic,
            kind: crate::error::RestoreDBInstanceFromS3ErrorKind::BackupPolicyNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::backup_policy_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_backup_policy_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreDBInstanceFromS3Error::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DBInstanceAlreadyExists" => crate::error::RestoreDBInstanceFromS3Error {
            meta: generic,
            kind: crate::error::RestoreDBInstanceFromS3ErrorKind::DbInstanceAlreadyExistsFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::db_instance_already_exists_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_instance_already_exists_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreDBInstanceFromS3Error::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DBParameterGroupNotFound" => crate::error::RestoreDBInstanceFromS3Error {
            meta: generic,
            kind: crate::error::RestoreDBInstanceFromS3ErrorKind::DbParameterGroupNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::db_parameter_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_parameter_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreDBInstanceFromS3Error::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DBSecurityGroupNotFound" => crate::error::RestoreDBInstanceFromS3Error {
            meta: generic,
            kind: crate::error::RestoreDBInstanceFromS3ErrorKind::DbSecurityGroupNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::db_security_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_security_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreDBInstanceFromS3Error::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DBSubnetGroupDoesNotCoverEnoughAZs" => crate::error::RestoreDBInstanceFromS3Error {
            meta: generic,
            kind:
                crate::error::RestoreDBInstanceFromS3ErrorKind::DbSubnetGroupDoesNotCoverEnoughAZs(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]let mut output = crate::error::db_subnet_group_does_not_cover_enough_a_zs::Builder::default();
                            let _ = response;
                            output = crate::xml_deser::deser_structure_crate_error_db_subnet_group_does_not_cover_enough_a_zs_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreDBInstanceFromS3Error::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "DBSubnetGroupNotFoundFault" => crate::error::RestoreDBInstanceFromS3Error {
            meta: generic,
            kind: crate::error::RestoreDBInstanceFromS3ErrorKind::DbSubnetGroupNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::db_subnet_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_subnet_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreDBInstanceFromS3Error::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InstanceQuotaExceeded" => crate::error::RestoreDBInstanceFromS3Error {
            meta: generic,
            kind: crate::error::RestoreDBInstanceFromS3ErrorKind::InstanceQuotaExceededFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::instance_quota_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_instance_quota_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreDBInstanceFromS3Error::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InsufficientDBInstanceCapacity" => crate::error::RestoreDBInstanceFromS3Error {
            meta: generic,
            kind:
                crate::error::RestoreDBInstanceFromS3ErrorKind::InsufficientDbInstanceCapacityFault(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]let mut output = crate::error::insufficient_db_instance_capacity_fault::Builder::default();
                            let _ = response;
                            output = crate::xml_deser::deser_structure_crate_error_insufficient_db_instance_capacity_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreDBInstanceFromS3Error::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "InvalidS3BucketFault" => crate::error::RestoreDBInstanceFromS3Error {
            meta: generic,
            kind: crate::error::RestoreDBInstanceFromS3ErrorKind::InvalidS3BucketFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_s3_bucket_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_s3_bucket_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreDBInstanceFromS3Error::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidSubnet" => crate::error::RestoreDBInstanceFromS3Error {
            meta: generic,
            kind: crate::error::RestoreDBInstanceFromS3ErrorKind::InvalidSubnet({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_subnet::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_subnet_xml_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::RestoreDBInstanceFromS3Error::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidVPCNetworkStateFault" => crate::error::RestoreDBInstanceFromS3Error {
            meta: generic,
            kind: crate::error::RestoreDBInstanceFromS3ErrorKind::InvalidVpcNetworkStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_vpc_network_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_vpc_network_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreDBInstanceFromS3Error::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSKeyNotAccessibleFault" => crate::error::RestoreDBInstanceFromS3Error {
            meta: generic,
            kind: crate::error::RestoreDBInstanceFromS3ErrorKind::KmsKeyNotAccessibleFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_key_not_accessible_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_kms_key_not_accessible_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreDBInstanceFromS3Error::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "OptionGroupNotFoundFault" => crate::error::RestoreDBInstanceFromS3Error {
            meta: generic,
            kind: crate::error::RestoreDBInstanceFromS3ErrorKind::OptionGroupNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::option_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_option_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreDBInstanceFromS3Error::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ProvisionedIopsNotAvailableInAZFault" => crate::error::RestoreDBInstanceFromS3Error {
            meta: generic,
            kind:
                crate::error::RestoreDBInstanceFromS3ErrorKind::ProvisionedIopsNotAvailableInAzFault(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]let mut output = crate::error::provisioned_iops_not_available_in_az_fault::Builder::default();
                            let _ = response;
                            output = crate::xml_deser::deser_structure_crate_error_provisioned_iops_not_available_in_az_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreDBInstanceFromS3Error::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "StorageQuotaExceeded" => crate::error::RestoreDBInstanceFromS3Error {
            meta: generic,
            kind: crate::error::RestoreDBInstanceFromS3ErrorKind::StorageQuotaExceededFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::storage_quota_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_storage_quota_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreDBInstanceFromS3Error::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "StorageTypeNotSupported" => crate::error::RestoreDBInstanceFromS3Error {
            meta: generic,
            kind: crate::error::RestoreDBInstanceFromS3ErrorKind::StorageTypeNotSupportedFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::storage_type_not_supported_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_storage_type_not_supported_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreDBInstanceFromS3Error::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::RestoreDBInstanceFromS3Error::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_restore_db_instance_from_s3_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RestoreDbInstanceFromS3Output,
    crate::error::RestoreDBInstanceFromS3Error,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::restore_db_instance_from_s3_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_restore_db_instance_from_s3(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::RestoreDBInstanceFromS3Error::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_restore_db_instance_to_point_in_time_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RestoreDbInstanceToPointInTimeOutput,
    crate::error::RestoreDBInstanceToPointInTimeError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::RestoreDBInstanceToPointInTimeError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::RestoreDBInstanceToPointInTimeError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AuthorizationNotFound" => crate::error::RestoreDBInstanceToPointInTimeError { meta: generic, kind: crate::error::RestoreDBInstanceToPointInTimeErrorKind::AuthorizationNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::authorization_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_authorization_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreDBInstanceToPointInTimeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "BackupPolicyNotFoundFault" => crate::error::RestoreDBInstanceToPointInTimeError { meta: generic, kind: crate::error::RestoreDBInstanceToPointInTimeErrorKind::BackupPolicyNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::backup_policy_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_backup_policy_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreDBInstanceToPointInTimeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "DBInstanceAlreadyExists" => crate::error::RestoreDBInstanceToPointInTimeError { meta: generic, kind: crate::error::RestoreDBInstanceToPointInTimeErrorKind::DbInstanceAlreadyExistsFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::db_instance_already_exists_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_instance_already_exists_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreDBInstanceToPointInTimeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "DBInstanceAutomatedBackupNotFound" => crate::error::RestoreDBInstanceToPointInTimeError { meta: generic, kind: crate::error::RestoreDBInstanceToPointInTimeErrorKind::DbInstanceAutomatedBackupNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::db_instance_automated_backup_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_instance_automated_backup_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreDBInstanceToPointInTimeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "DBInstanceNotFound" => crate::error::RestoreDBInstanceToPointInTimeError { meta: generic, kind: crate::error::RestoreDBInstanceToPointInTimeErrorKind::DbInstanceNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::db_instance_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_instance_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreDBInstanceToPointInTimeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "DBParameterGroupNotFound" => crate::error::RestoreDBInstanceToPointInTimeError { meta: generic, kind: crate::error::RestoreDBInstanceToPointInTimeErrorKind::DbParameterGroupNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::db_parameter_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_parameter_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreDBInstanceToPointInTimeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "DBSecurityGroupNotFound" => crate::error::RestoreDBInstanceToPointInTimeError { meta: generic, kind: crate::error::RestoreDBInstanceToPointInTimeErrorKind::DbSecurityGroupNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::db_security_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_security_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreDBInstanceToPointInTimeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "DBSubnetGroupDoesNotCoverEnoughAZs" => crate::error::RestoreDBInstanceToPointInTimeError { meta: generic, kind: crate::error::RestoreDBInstanceToPointInTimeErrorKind::DbSubnetGroupDoesNotCoverEnoughAZs({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::db_subnet_group_does_not_cover_enough_a_zs::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_subnet_group_does_not_cover_enough_a_zs_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreDBInstanceToPointInTimeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "DBSubnetGroupNotFoundFault" => crate::error::RestoreDBInstanceToPointInTimeError { meta: generic, kind: crate::error::RestoreDBInstanceToPointInTimeErrorKind::DbSubnetGroupNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::db_subnet_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_subnet_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreDBInstanceToPointInTimeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "DomainNotFoundFault" => crate::error::RestoreDBInstanceToPointInTimeError { meta: generic, kind: crate::error::RestoreDBInstanceToPointInTimeErrorKind::DomainNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::domain_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_domain_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreDBInstanceToPointInTimeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InstanceQuotaExceeded" => crate::error::RestoreDBInstanceToPointInTimeError { meta: generic, kind: crate::error::RestoreDBInstanceToPointInTimeErrorKind::InstanceQuotaExceededFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::instance_quota_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_instance_quota_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreDBInstanceToPointInTimeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InsufficientDBInstanceCapacity" => crate::error::RestoreDBInstanceToPointInTimeError { meta: generic, kind: crate::error::RestoreDBInstanceToPointInTimeErrorKind::InsufficientDbInstanceCapacityFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::insufficient_db_instance_capacity_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_insufficient_db_instance_capacity_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreDBInstanceToPointInTimeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidDBInstanceState" => crate::error::RestoreDBInstanceToPointInTimeError { meta: generic, kind: crate::error::RestoreDBInstanceToPointInTimeErrorKind::InvalidDbInstanceStateFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_db_instance_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_db_instance_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreDBInstanceToPointInTimeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidRestoreFault" => crate::error::RestoreDBInstanceToPointInTimeError { meta: generic, kind: crate::error::RestoreDBInstanceToPointInTimeErrorKind::InvalidRestoreFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_restore_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_restore_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreDBInstanceToPointInTimeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidSubnet" => crate::error::RestoreDBInstanceToPointInTimeError { meta: generic, kind: crate::error::RestoreDBInstanceToPointInTimeErrorKind::InvalidSubnet({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_subnet::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_subnet_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreDBInstanceToPointInTimeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidVPCNetworkStateFault" => crate::error::RestoreDBInstanceToPointInTimeError { meta: generic, kind: crate::error::RestoreDBInstanceToPointInTimeErrorKind::InvalidVpcNetworkStateFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_vpc_network_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_vpc_network_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreDBInstanceToPointInTimeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "KMSKeyNotAccessibleFault" => crate::error::RestoreDBInstanceToPointInTimeError { meta: generic, kind: crate::error::RestoreDBInstanceToPointInTimeErrorKind::KmsKeyNotAccessibleFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::kms_key_not_accessible_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_kms_key_not_accessible_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreDBInstanceToPointInTimeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "OptionGroupNotFoundFault" => crate::error::RestoreDBInstanceToPointInTimeError { meta: generic, kind: crate::error::RestoreDBInstanceToPointInTimeErrorKind::OptionGroupNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::option_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_option_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreDBInstanceToPointInTimeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "PointInTimeRestoreNotEnabled" => crate::error::RestoreDBInstanceToPointInTimeError { meta: generic, kind: crate::error::RestoreDBInstanceToPointInTimeErrorKind::PointInTimeRestoreNotEnabledFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::point_in_time_restore_not_enabled_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_point_in_time_restore_not_enabled_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreDBInstanceToPointInTimeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "ProvisionedIopsNotAvailableInAZFault" => crate::error::RestoreDBInstanceToPointInTimeError { meta: generic, kind: crate::error::RestoreDBInstanceToPointInTimeErrorKind::ProvisionedIopsNotAvailableInAzFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::provisioned_iops_not_available_in_az_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_provisioned_iops_not_available_in_az_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreDBInstanceToPointInTimeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "StorageQuotaExceeded" => crate::error::RestoreDBInstanceToPointInTimeError { meta: generic, kind: crate::error::RestoreDBInstanceToPointInTimeErrorKind::StorageQuotaExceededFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::storage_quota_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_storage_quota_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreDBInstanceToPointInTimeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "StorageTypeNotSupported" => crate::error::RestoreDBInstanceToPointInTimeError { meta: generic, kind: crate::error::RestoreDBInstanceToPointInTimeErrorKind::StorageTypeNotSupportedFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::storage_type_not_supported_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_storage_type_not_supported_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RestoreDBInstanceToPointInTimeError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::RestoreDBInstanceToPointInTimeError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_restore_db_instance_to_point_in_time_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RestoreDbInstanceToPointInTimeOutput,
    crate::error::RestoreDBInstanceToPointInTimeError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::restore_db_instance_to_point_in_time_output::Builder::default();
        let _ = response;
        output =
            crate::xml_deser::deser_operation_crate_operation_restore_db_instance_to_point_in_time(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::RestoreDBInstanceToPointInTimeError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_revoke_db_security_group_ingress_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RevokeDbSecurityGroupIngressOutput,
    crate::error::RevokeDBSecurityGroupIngressError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::RevokeDBSecurityGroupIngressError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::RevokeDBSecurityGroupIngressError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AuthorizationNotFound" => crate::error::RevokeDBSecurityGroupIngressError { meta: generic, kind: crate::error::RevokeDBSecurityGroupIngressErrorKind::AuthorizationNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::authorization_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_authorization_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RevokeDBSecurityGroupIngressError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "DBSecurityGroupNotFound" => crate::error::RevokeDBSecurityGroupIngressError { meta: generic, kind: crate::error::RevokeDBSecurityGroupIngressErrorKind::DbSecurityGroupNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::db_security_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_security_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RevokeDBSecurityGroupIngressError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidDBSecurityGroupState" => crate::error::RevokeDBSecurityGroupIngressError { meta: generic, kind: crate::error::RevokeDBSecurityGroupIngressErrorKind::InvalidDbSecurityGroupStateFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_db_security_group_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_db_security_group_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::RevokeDBSecurityGroupIngressError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::RevokeDBSecurityGroupIngressError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_revoke_db_security_group_ingress_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::RevokeDbSecurityGroupIngressOutput,
    crate::error::RevokeDBSecurityGroupIngressError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::revoke_db_security_group_ingress_output::Builder::default();
        let _ = response;
        output =
            crate::xml_deser::deser_operation_crate_operation_revoke_db_security_group_ingress(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::RevokeDBSecurityGroupIngressError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_start_activity_stream_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StartActivityStreamOutput,
    crate::error::StartActivityStreamError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::StartActivityStreamError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::StartActivityStreamError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DBClusterNotFoundFault" => crate::error::StartActivityStreamError {
            meta: generic,
            kind: crate::error::StartActivityStreamErrorKind::DbClusterNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::db_cluster_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_cluster_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::StartActivityStreamError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DBInstanceNotFound" => crate::error::StartActivityStreamError {
            meta: generic,
            kind: crate::error::StartActivityStreamErrorKind::DbInstanceNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::db_instance_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_instance_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::StartActivityStreamError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidDBClusterStateFault" => crate::error::StartActivityStreamError {
            meta: generic,
            kind: crate::error::StartActivityStreamErrorKind::InvalidDbClusterStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_db_cluster_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_db_cluster_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::StartActivityStreamError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidDBInstanceState" => crate::error::StartActivityStreamError {
            meta: generic,
            kind: crate::error::StartActivityStreamErrorKind::InvalidDbInstanceStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_db_instance_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_db_instance_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::StartActivityStreamError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSKeyNotAccessibleFault" => crate::error::StartActivityStreamError {
            meta: generic,
            kind: crate::error::StartActivityStreamErrorKind::KmsKeyNotAccessibleFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_key_not_accessible_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_kms_key_not_accessible_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::StartActivityStreamError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundFault" => crate::error::StartActivityStreamError {
            meta: generic,
            kind: crate::error::StartActivityStreamErrorKind::ResourceNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resource_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::StartActivityStreamError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::StartActivityStreamError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_start_activity_stream_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StartActivityStreamOutput,
    crate::error::StartActivityStreamError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::start_activity_stream_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_start_activity_stream(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::StartActivityStreamError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_start_db_cluster_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::StartDbClusterOutput, crate::error::StartDBClusterError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::StartDBClusterError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::StartDBClusterError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DBClusterNotFoundFault" => crate::error::StartDBClusterError {
            meta: generic,
            kind: crate::error::StartDBClusterErrorKind::DbClusterNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::db_cluster_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_cluster_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::StartDBClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidDBClusterStateFault" => crate::error::StartDBClusterError {
            meta: generic,
            kind: crate::error::StartDBClusterErrorKind::InvalidDbClusterStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_db_cluster_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_db_cluster_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::StartDBClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidDBInstanceState" => crate::error::StartDBClusterError {
            meta: generic,
            kind: crate::error::StartDBClusterErrorKind::InvalidDbInstanceStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_db_instance_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_db_instance_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::StartDBClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::StartDBClusterError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_start_db_cluster_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::StartDbClusterOutput, crate::error::StartDBClusterError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::start_db_cluster_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_start_db_cluster(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::StartDBClusterError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_start_db_instance_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::StartDbInstanceOutput, crate::error::StartDBInstanceError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::StartDBInstanceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::StartDBInstanceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "AuthorizationNotFound" => crate::error::StartDBInstanceError {
            meta: generic,
            kind: crate::error::StartDBInstanceErrorKind::AuthorizationNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::authorization_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_authorization_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::StartDBInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DBClusterNotFoundFault" => crate::error::StartDBInstanceError {
            meta: generic,
            kind: crate::error::StartDBInstanceErrorKind::DbClusterNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::db_cluster_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_cluster_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::StartDBInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DBInstanceNotFound" => crate::error::StartDBInstanceError {
            meta: generic,
            kind: crate::error::StartDBInstanceErrorKind::DbInstanceNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::db_instance_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_instance_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::StartDBInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DBSubnetGroupDoesNotCoverEnoughAZs" => {
            crate::error::StartDBInstanceError {
                meta: generic,
                kind: crate::error::StartDBInstanceErrorKind::DbSubnetGroupDoesNotCoverEnoughAZs({
                    #[allow(unused_mut)]
                    let mut tmp = {
                        #[allow(unused_mut)]let mut output = crate::error::db_subnet_group_does_not_cover_enough_a_zs::Builder::default();
                        let _ = response;
                        output = crate::xml_deser::deser_structure_crate_error_db_subnet_group_does_not_cover_enough_a_zs_xml_err(response.body().as_ref(), output).map_err(crate::error::StartDBInstanceError::unhandled)?;
                        output.build()
                    };
                    if (&tmp.message).is_none() {
                        tmp.message = _error_message;
                    }
                    tmp
                }),
            }
        }
        "DBSubnetGroupNotFoundFault" => crate::error::StartDBInstanceError {
            meta: generic,
            kind: crate::error::StartDBInstanceErrorKind::DbSubnetGroupNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::db_subnet_group_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_subnet_group_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::StartDBInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InsufficientDBInstanceCapacity" => crate::error::StartDBInstanceError {
            meta: generic,
            kind: crate::error::StartDBInstanceErrorKind::InsufficientDbInstanceCapacityFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::insufficient_db_instance_capacity_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_insufficient_db_instance_capacity_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::StartDBInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidDBClusterStateFault" => crate::error::StartDBInstanceError {
            meta: generic,
            kind: crate::error::StartDBInstanceErrorKind::InvalidDbClusterStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_db_cluster_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_db_cluster_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::StartDBInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidDBInstanceState" => crate::error::StartDBInstanceError {
            meta: generic,
            kind: crate::error::StartDBInstanceErrorKind::InvalidDbInstanceStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_db_instance_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_db_instance_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::StartDBInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidSubnet" => crate::error::StartDBInstanceError {
            meta: generic,
            kind: crate::error::StartDBInstanceErrorKind::InvalidSubnet({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_subnet::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_subnet_xml_err(
                        response.body().as_ref(),
                        output,
                    )
                    .map_err(crate::error::StartDBInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidVPCNetworkStateFault" => crate::error::StartDBInstanceError {
            meta: generic,
            kind: crate::error::StartDBInstanceErrorKind::InvalidVpcNetworkStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_vpc_network_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_vpc_network_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::StartDBInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSKeyNotAccessibleFault" => crate::error::StartDBInstanceError {
            meta: generic,
            kind: crate::error::StartDBInstanceErrorKind::KmsKeyNotAccessibleFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_key_not_accessible_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_kms_key_not_accessible_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::StartDBInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::StartDBInstanceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_start_db_instance_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::StartDbInstanceOutput, crate::error::StartDBInstanceError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::start_db_instance_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_start_db_instance(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::StartDBInstanceError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_start_db_instance_automated_backups_replication_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StartDbInstanceAutomatedBackupsReplicationOutput,
    crate::error::StartDBInstanceAutomatedBackupsReplicationError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::StartDBInstanceAutomatedBackupsReplicationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(
                crate::error::StartDBInstanceAutomatedBackupsReplicationError::unhandled(generic),
            )
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DBInstanceAutomatedBackupQuotaExceeded" => crate::error::StartDBInstanceAutomatedBackupsReplicationError { meta: generic, kind: crate::error::StartDBInstanceAutomatedBackupsReplicationErrorKind::DbInstanceAutomatedBackupQuotaExceededFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::db_instance_automated_backup_quota_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_instance_automated_backup_quota_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::StartDBInstanceAutomatedBackupsReplicationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "DBInstanceNotFound" => crate::error::StartDBInstanceAutomatedBackupsReplicationError { meta: generic, kind: crate::error::StartDBInstanceAutomatedBackupsReplicationErrorKind::DbInstanceNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::db_instance_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_instance_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::StartDBInstanceAutomatedBackupsReplicationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidDBInstanceState" => crate::error::StartDBInstanceAutomatedBackupsReplicationError { meta: generic, kind: crate::error::StartDBInstanceAutomatedBackupsReplicationErrorKind::InvalidDbInstanceStateFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_db_instance_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_db_instance_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::StartDBInstanceAutomatedBackupsReplicationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "KMSKeyNotAccessibleFault" => crate::error::StartDBInstanceAutomatedBackupsReplicationError { meta: generic, kind: crate::error::StartDBInstanceAutomatedBackupsReplicationErrorKind::KmsKeyNotAccessibleFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::kms_key_not_accessible_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_kms_key_not_accessible_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::StartDBInstanceAutomatedBackupsReplicationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "StorageTypeNotSupported" => crate::error::StartDBInstanceAutomatedBackupsReplicationError { meta: generic, kind: crate::error::StartDBInstanceAutomatedBackupsReplicationErrorKind::StorageTypeNotSupportedFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::storage_type_not_supported_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_storage_type_not_supported_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::StartDBInstanceAutomatedBackupsReplicationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::StartDBInstanceAutomatedBackupsReplicationError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_start_db_instance_automated_backups_replication_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StartDbInstanceAutomatedBackupsReplicationOutput,
    crate::error::StartDBInstanceAutomatedBackupsReplicationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::start_db_instance_automated_backups_replication_output::Builder::default(
            );
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_start_db_instance_automated_backups_replication(response.body().as_ref(), output).map_err(crate::error::StartDBInstanceAutomatedBackupsReplicationError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_start_export_task_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::StartExportTaskOutput, crate::error::StartExportTaskError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::StartExportTaskError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::StartExportTaskError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DBClusterSnapshotNotFoundFault" => crate::error::StartExportTaskError {
            meta: generic,
            kind: crate::error::StartExportTaskErrorKind::DbClusterSnapshotNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::db_cluster_snapshot_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_cluster_snapshot_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::StartExportTaskError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DBSnapshotNotFound" => crate::error::StartExportTaskError {
            meta: generic,
            kind: crate::error::StartExportTaskErrorKind::DbSnapshotNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::db_snapshot_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_snapshot_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::StartExportTaskError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ExportTaskAlreadyExists" => crate::error::StartExportTaskError {
            meta: generic,
            kind: crate::error::StartExportTaskErrorKind::ExportTaskAlreadyExistsFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::export_task_already_exists_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_export_task_already_exists_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::StartExportTaskError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "IamRoleMissingPermissions" => crate::error::StartExportTaskError {
            meta: generic,
            kind: crate::error::StartExportTaskErrorKind::IamRoleMissingPermissionsFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::iam_role_missing_permissions_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_iam_role_missing_permissions_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::StartExportTaskError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "IamRoleNotFound" => crate::error::StartExportTaskError {
            meta: generic,
            kind: crate::error::StartExportTaskErrorKind::IamRoleNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::iam_role_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_iam_role_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::StartExportTaskError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidExportOnly" => crate::error::StartExportTaskError {
            meta: generic,
            kind: crate::error::StartExportTaskErrorKind::InvalidExportOnlyFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_export_only_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_export_only_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::StartExportTaskError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidExportSourceState" => crate::error::StartExportTaskError {
            meta: generic,
            kind: crate::error::StartExportTaskErrorKind::InvalidExportSourceStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_export_source_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_export_source_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::StartExportTaskError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidS3BucketFault" => crate::error::StartExportTaskError {
            meta: generic,
            kind: crate::error::StartExportTaskErrorKind::InvalidS3BucketFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_s3_bucket_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_s3_bucket_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::StartExportTaskError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "KMSKeyNotAccessibleFault" => crate::error::StartExportTaskError {
            meta: generic,
            kind: crate::error::StartExportTaskErrorKind::KmsKeyNotAccessibleFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::kms_key_not_accessible_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_kms_key_not_accessible_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::StartExportTaskError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::StartExportTaskError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_start_export_task_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::StartExportTaskOutput, crate::error::StartExportTaskError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::start_export_task_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_start_export_task(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::StartExportTaskError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_stop_activity_stream_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StopActivityStreamOutput,
    crate::error::StopActivityStreamError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::StopActivityStreamError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::StopActivityStreamError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DBClusterNotFoundFault" => crate::error::StopActivityStreamError {
            meta: generic,
            kind: crate::error::StopActivityStreamErrorKind::DbClusterNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::db_cluster_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_cluster_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::StopActivityStreamError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DBInstanceNotFound" => crate::error::StopActivityStreamError {
            meta: generic,
            kind: crate::error::StopActivityStreamErrorKind::DbInstanceNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::db_instance_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_instance_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::StopActivityStreamError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidDBClusterStateFault" => crate::error::StopActivityStreamError {
            meta: generic,
            kind: crate::error::StopActivityStreamErrorKind::InvalidDbClusterStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_db_cluster_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_db_cluster_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::StopActivityStreamError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidDBInstanceState" => crate::error::StopActivityStreamError {
            meta: generic,
            kind: crate::error::StopActivityStreamErrorKind::InvalidDbInstanceStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_db_instance_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_db_instance_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::StopActivityStreamError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundFault" => crate::error::StopActivityStreamError {
            meta: generic,
            kind: crate::error::StopActivityStreamErrorKind::ResourceNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_resource_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::StopActivityStreamError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::StopActivityStreamError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_stop_activity_stream_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StopActivityStreamOutput,
    crate::error::StopActivityStreamError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::stop_activity_stream_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_stop_activity_stream(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::StopActivityStreamError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_stop_db_cluster_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::StopDbClusterOutput, crate::error::StopDBClusterError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::StopDBClusterError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::StopDBClusterError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DBClusterNotFoundFault" => crate::error::StopDBClusterError {
            meta: generic,
            kind: crate::error::StopDBClusterErrorKind::DbClusterNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::db_cluster_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_cluster_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::StopDBClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidDBClusterStateFault" => crate::error::StopDBClusterError {
            meta: generic,
            kind: crate::error::StopDBClusterErrorKind::InvalidDbClusterStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_db_cluster_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_db_cluster_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::StopDBClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidDBInstanceState" => crate::error::StopDBClusterError {
            meta: generic,
            kind: crate::error::StopDBClusterErrorKind::InvalidDbInstanceStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_db_instance_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_db_instance_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::StopDBClusterError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::StopDBClusterError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_stop_db_cluster_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::StopDbClusterOutput, crate::error::StopDBClusterError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::stop_db_cluster_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_stop_db_cluster(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::StopDBClusterError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_stop_db_instance_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::StopDbInstanceOutput, crate::error::StopDBInstanceError> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::StopDBInstanceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::StopDBInstanceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DBInstanceNotFound" => crate::error::StopDBInstanceError {
            meta: generic,
            kind: crate::error::StopDBInstanceErrorKind::DbInstanceNotFoundFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::db_instance_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_instance_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::StopDBInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "DBSnapshotAlreadyExists" => crate::error::StopDBInstanceError {
            meta: generic,
            kind: crate::error::StopDBInstanceErrorKind::DbSnapshotAlreadyExistsFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::db_snapshot_already_exists_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_snapshot_already_exists_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::StopDBInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidDBClusterStateFault" => crate::error::StopDBInstanceError {
            meta: generic,
            kind: crate::error::StopDBInstanceErrorKind::InvalidDbClusterStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_db_cluster_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_db_cluster_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::StopDBInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidDBInstanceState" => crate::error::StopDBInstanceError {
            meta: generic,
            kind: crate::error::StopDBInstanceErrorKind::InvalidDbInstanceStateFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::invalid_db_instance_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_db_instance_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::StopDBInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "SnapshotQuotaExceeded" => crate::error::StopDBInstanceError {
            meta: generic,
            kind: crate::error::StopDBInstanceErrorKind::SnapshotQuotaExceededFault({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::snapshot_quota_exceeded_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_snapshot_quota_exceeded_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::StopDBInstanceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::StopDBInstanceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_stop_db_instance_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::StopDbInstanceOutput, crate::error::StopDBInstanceError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::stop_db_instance_output::Builder::default();
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_stop_db_instance(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::StopDBInstanceError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_stop_db_instance_automated_backups_replication_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StopDbInstanceAutomatedBackupsReplicationOutput,
    crate::error::StopDBInstanceAutomatedBackupsReplicationError,
> {
    let generic = crate::xml_deser::parse_http_generic_error(response)
        .map_err(crate::error::StopDBInstanceAutomatedBackupsReplicationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(
                crate::error::StopDBInstanceAutomatedBackupsReplicationError::unhandled(generic),
            )
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "DBInstanceNotFound" => crate::error::StopDBInstanceAutomatedBackupsReplicationError { meta: generic, kind: crate::error::StopDBInstanceAutomatedBackupsReplicationErrorKind::DbInstanceNotFoundFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::db_instance_not_found_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_db_instance_not_found_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::StopDBInstanceAutomatedBackupsReplicationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidDBInstanceState" => crate::error::StopDBInstanceAutomatedBackupsReplicationError { meta: generic, kind: crate::error::StopDBInstanceAutomatedBackupsReplicationErrorKind::InvalidDbInstanceStateFault({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_db_instance_state_fault::Builder::default();
                    let _ = response;
                    output = crate::xml_deser::deser_structure_crate_error_invalid_db_instance_state_fault_xml_err(response.body().as_ref(), output).map_err(crate::error::StopDBInstanceAutomatedBackupsReplicationError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::StopDBInstanceAutomatedBackupsReplicationError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_stop_db_instance_automated_backups_replication_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::StopDbInstanceAutomatedBackupsReplicationOutput,
    crate::error::StopDBInstanceAutomatedBackupsReplicationError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output =
            crate::output::stop_db_instance_automated_backups_replication_output::Builder::default(
            );
        let _ = response;
        output = crate::xml_deser::deser_operation_crate_operation_stop_db_instance_automated_backups_replication(response.body().as_ref(), output).map_err(crate::error::StopDBInstanceAutomatedBackupsReplicationError::unhandled)?;
        output.build()
    })
}
