// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for Amazon Relational Database Service
///
/// Client for invoking operations on Amazon Relational Database Service. Each operation on Amazon Relational Database Service is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_rds::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
/// let shared_config = aws_config::load_from_env().await;
/// let config = aws_sdk_rds::config::Builder::from(&shared_config)
///   .retry_config(RetryConfig::disabled())
///   .build();
/// let client = aws_sdk_rds::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`AddRoleToDBCluster`](crate::client::fluent_builders::AddRoleToDBCluster) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_cluster_identifier(impl Into<String>)`](crate::client::fluent_builders::AddRoleToDBCluster::db_cluster_identifier) / [`set_db_cluster_identifier(Option<String>)`](crate::client::fluent_builders::AddRoleToDBCluster::set_db_cluster_identifier): <p>The name of the DB cluster to associate the IAM role with.</p>
    ///   - [`role_arn(impl Into<String>)`](crate::client::fluent_builders::AddRoleToDBCluster::role_arn) / [`set_role_arn(Option<String>)`](crate::client::fluent_builders::AddRoleToDBCluster::set_role_arn): <p>The Amazon Resource Name (ARN) of the IAM role to associate with the Aurora DB cluster, for example <code>arn:aws:iam::123456789012:role/AuroraAccessRole</code>.</p>
    ///   - [`feature_name(impl Into<String>)`](crate::client::fluent_builders::AddRoleToDBCluster::feature_name) / [`set_feature_name(Option<String>)`](crate::client::fluent_builders::AddRoleToDBCluster::set_feature_name): <p>The name of the feature for the DB cluster that the IAM role is to be associated with. For information about supported feature names, see <code>DBEngineVersion</code>.</p>
    /// - On success, responds with [`AddRoleToDbClusterOutput`](crate::output::AddRoleToDbClusterOutput)

    /// - On failure, responds with [`SdkError<AddRoleToDBClusterError>`](crate::error::AddRoleToDBClusterError)
    pub fn add_role_to_db_cluster(&self) -> fluent_builders::AddRoleToDBCluster {
        fluent_builders::AddRoleToDBCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AddRoleToDBInstance`](crate::client::fluent_builders::AddRoleToDBInstance) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_instance_identifier(impl Into<String>)`](crate::client::fluent_builders::AddRoleToDBInstance::db_instance_identifier) / [`set_db_instance_identifier(Option<String>)`](crate::client::fluent_builders::AddRoleToDBInstance::set_db_instance_identifier): <p>The name of the DB instance to associate the IAM role with.</p>
    ///   - [`role_arn(impl Into<String>)`](crate::client::fluent_builders::AddRoleToDBInstance::role_arn) / [`set_role_arn(Option<String>)`](crate::client::fluent_builders::AddRoleToDBInstance::set_role_arn): <p>The Amazon Resource Name (ARN) of the IAM role to associate with the DB instance, for example <code>arn:aws:iam::123456789012:role/AccessRole</code>.</p>
    ///   - [`feature_name(impl Into<String>)`](crate::client::fluent_builders::AddRoleToDBInstance::feature_name) / [`set_feature_name(Option<String>)`](crate::client::fluent_builders::AddRoleToDBInstance::set_feature_name): <p>The name of the feature for the DB instance that the IAM role is to be associated with. For information about supported feature names, see <code>DBEngineVersion</code>.</p>
    /// - On success, responds with [`AddRoleToDbInstanceOutput`](crate::output::AddRoleToDbInstanceOutput)

    /// - On failure, responds with [`SdkError<AddRoleToDBInstanceError>`](crate::error::AddRoleToDBInstanceError)
    pub fn add_role_to_db_instance(&self) -> fluent_builders::AddRoleToDBInstance {
        fluent_builders::AddRoleToDBInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AddSourceIdentifierToSubscription`](crate::client::fluent_builders::AddSourceIdentifierToSubscription) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`subscription_name(impl Into<String>)`](crate::client::fluent_builders::AddSourceIdentifierToSubscription::subscription_name) / [`set_subscription_name(Option<String>)`](crate::client::fluent_builders::AddSourceIdentifierToSubscription::set_subscription_name): <p>The name of the RDS event notification subscription you want to add a source identifier to.</p>
    ///   - [`source_identifier(impl Into<String>)`](crate::client::fluent_builders::AddSourceIdentifierToSubscription::source_identifier) / [`set_source_identifier(Option<String>)`](crate::client::fluent_builders::AddSourceIdentifierToSubscription::set_source_identifier): <p>The identifier of the event source to be added.</p>  <p>Constraints:</p>  <ul>   <li> <p>If the source type is a DB instance, a <code>DBInstanceIdentifier</code> value must be supplied.</p> </li>   <li> <p>If the source type is a DB cluster, a <code>DBClusterIdentifier</code> value must be supplied.</p> </li>   <li> <p>If the source type is a DB parameter group, a <code>DBParameterGroupName</code> value must be supplied.</p> </li>   <li> <p>If the source type is a DB security group, a <code>DBSecurityGroupName</code> value must be supplied.</p> </li>   <li> <p>If the source type is a DB snapshot, a <code>DBSnapshotIdentifier</code> value must be supplied.</p> </li>   <li> <p>If the source type is a DB cluster snapshot, a <code>DBClusterSnapshotIdentifier</code> value must be supplied.</p> </li>   <li> <p>If the source type is an RDS Proxy, a <code>DBProxyName</code> value must be supplied.</p> </li>  </ul>
    /// - On success, responds with [`AddSourceIdentifierToSubscriptionOutput`](crate::output::AddSourceIdentifierToSubscriptionOutput) with field(s):
    ///   - [`event_subscription(Option<EventSubscription>)`](crate::output::AddSourceIdentifierToSubscriptionOutput::event_subscription): <p>Contains the results of a successful invocation of the <code>DescribeEventSubscriptions</code> action.</p>
    /// - On failure, responds with [`SdkError<AddSourceIdentifierToSubscriptionError>`](crate::error::AddSourceIdentifierToSubscriptionError)
    pub fn add_source_identifier_to_subscription(
        &self,
    ) -> fluent_builders::AddSourceIdentifierToSubscription {
        fluent_builders::AddSourceIdentifierToSubscription::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AddTagsToResource`](crate::client::fluent_builders::AddTagsToResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_name(impl Into<String>)`](crate::client::fluent_builders::AddTagsToResource::resource_name) / [`set_resource_name(Option<String>)`](crate::client::fluent_builders::AddTagsToResource::set_resource_name): <p>The Amazon RDS resource that the tags are added to. This value is an Amazon Resource Name (ARN). For information about creating an ARN, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing"> Constructing an RDS Amazon Resource Name (ARN)</a>.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::AddTagsToResource::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::AddTagsToResource::set_tags): <p>The tags to be assigned to the Amazon RDS resource.</p>
    /// - On success, responds with [`AddTagsToResourceOutput`](crate::output::AddTagsToResourceOutput)

    /// - On failure, responds with [`SdkError<AddTagsToResourceError>`](crate::error::AddTagsToResourceError)
    pub fn add_tags_to_resource(&self) -> fluent_builders::AddTagsToResource {
        fluent_builders::AddTagsToResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ApplyPendingMaintenanceAction`](crate::client::fluent_builders::ApplyPendingMaintenanceAction) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_identifier(impl Into<String>)`](crate::client::fluent_builders::ApplyPendingMaintenanceAction::resource_identifier) / [`set_resource_identifier(Option<String>)`](crate::client::fluent_builders::ApplyPendingMaintenanceAction::set_resource_identifier): <p>The RDS Amazon Resource Name (ARN) of the resource that the pending maintenance action applies to. For information about creating an ARN, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing"> Constructing an RDS Amazon Resource Name (ARN)</a>.</p>
    ///   - [`apply_action(impl Into<String>)`](crate::client::fluent_builders::ApplyPendingMaintenanceAction::apply_action) / [`set_apply_action(Option<String>)`](crate::client::fluent_builders::ApplyPendingMaintenanceAction::set_apply_action): <p>The pending maintenance action to apply to this resource.</p>  <p>Valid values: <code>system-update</code>, <code>db-upgrade</code>, <code>hardware-maintenance</code>, <code>ca-certificate-rotation</code> </p>
    ///   - [`opt_in_type(impl Into<String>)`](crate::client::fluent_builders::ApplyPendingMaintenanceAction::opt_in_type) / [`set_opt_in_type(Option<String>)`](crate::client::fluent_builders::ApplyPendingMaintenanceAction::set_opt_in_type): <p>A value that specifies the type of opt-in request, or undoes an opt-in request. An opt-in request of type <code>immediate</code> can't be undone.</p>  <p>Valid values:</p>  <ul>   <li> <p> <code>immediate</code> - Apply the maintenance action immediately.</p> </li>   <li> <p> <code>next-maintenance</code> - Apply the maintenance action during the next maintenance window for the resource.</p> </li>   <li> <p> <code>undo-opt-in</code> - Cancel any existing <code>next-maintenance</code> opt-in requests.</p> </li>  </ul>
    /// - On success, responds with [`ApplyPendingMaintenanceActionOutput`](crate::output::ApplyPendingMaintenanceActionOutput) with field(s):
    ///   - [`resource_pending_maintenance_actions(Option<ResourcePendingMaintenanceActions>)`](crate::output::ApplyPendingMaintenanceActionOutput::resource_pending_maintenance_actions): <p>Describes the pending maintenance actions for a resource.</p>
    /// - On failure, responds with [`SdkError<ApplyPendingMaintenanceActionError>`](crate::error::ApplyPendingMaintenanceActionError)
    pub fn apply_pending_maintenance_action(
        &self,
    ) -> fluent_builders::ApplyPendingMaintenanceAction {
        fluent_builders::ApplyPendingMaintenanceAction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AuthorizeDBSecurityGroupIngress`](crate::client::fluent_builders::AuthorizeDBSecurityGroupIngress) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_security_group_name(impl Into<String>)`](crate::client::fluent_builders::AuthorizeDBSecurityGroupIngress::db_security_group_name) / [`set_db_security_group_name(Option<String>)`](crate::client::fluent_builders::AuthorizeDBSecurityGroupIngress::set_db_security_group_name): <p>The name of the DB security group to add authorization to.</p>
    ///   - [`cidrip(impl Into<String>)`](crate::client::fluent_builders::AuthorizeDBSecurityGroupIngress::cidrip) / [`set_cidrip(Option<String>)`](crate::client::fluent_builders::AuthorizeDBSecurityGroupIngress::set_cidrip): <p>The IP range to authorize.</p>
    ///   - [`ec2_security_group_name(impl Into<String>)`](crate::client::fluent_builders::AuthorizeDBSecurityGroupIngress::ec2_security_group_name) / [`set_ec2_security_group_name(Option<String>)`](crate::client::fluent_builders::AuthorizeDBSecurityGroupIngress::set_ec2_security_group_name): <p>Name of the EC2 security group to authorize. For VPC DB security groups, <code>EC2SecurityGroupId</code> must be provided. Otherwise, <code>EC2SecurityGroupOwnerId</code> and either <code>EC2SecurityGroupName</code> or <code>EC2SecurityGroupId</code> must be provided.</p>
    ///   - [`ec2_security_group_id(impl Into<String>)`](crate::client::fluent_builders::AuthorizeDBSecurityGroupIngress::ec2_security_group_id) / [`set_ec2_security_group_id(Option<String>)`](crate::client::fluent_builders::AuthorizeDBSecurityGroupIngress::set_ec2_security_group_id): <p>Id of the EC2 security group to authorize. For VPC DB security groups, <code>EC2SecurityGroupId</code> must be provided. Otherwise, <code>EC2SecurityGroupOwnerId</code> and either <code>EC2SecurityGroupName</code> or <code>EC2SecurityGroupId</code> must be provided.</p>
    ///   - [`ec2_security_group_owner_id(impl Into<String>)`](crate::client::fluent_builders::AuthorizeDBSecurityGroupIngress::ec2_security_group_owner_id) / [`set_ec2_security_group_owner_id(Option<String>)`](crate::client::fluent_builders::AuthorizeDBSecurityGroupIngress::set_ec2_security_group_owner_id): <p>Amazon Web Services account number of the owner of the EC2 security group specified in the <code>EC2SecurityGroupName</code> parameter. The Amazon Web Services access key ID isn't an acceptable value. For VPC DB security groups, <code>EC2SecurityGroupId</code> must be provided. Otherwise, <code>EC2SecurityGroupOwnerId</code> and either <code>EC2SecurityGroupName</code> or <code>EC2SecurityGroupId</code> must be provided.</p>
    /// - On success, responds with [`AuthorizeDbSecurityGroupIngressOutput`](crate::output::AuthorizeDbSecurityGroupIngressOutput) with field(s):
    ///   - [`db_security_group(Option<DbSecurityGroup>)`](crate::output::AuthorizeDbSecurityGroupIngressOutput::db_security_group): <p>Contains the details for an Amazon RDS DB security group.</p>  <p>This data type is used as a response element in the <code>DescribeDBSecurityGroups</code> action.</p>
    /// - On failure, responds with [`SdkError<AuthorizeDBSecurityGroupIngressError>`](crate::error::AuthorizeDBSecurityGroupIngressError)
    pub fn authorize_db_security_group_ingress(
        &self,
    ) -> fluent_builders::AuthorizeDBSecurityGroupIngress {
        fluent_builders::AuthorizeDBSecurityGroupIngress::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`BacktrackDBCluster`](crate::client::fluent_builders::BacktrackDBCluster) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_cluster_identifier(impl Into<String>)`](crate::client::fluent_builders::BacktrackDBCluster::db_cluster_identifier) / [`set_db_cluster_identifier(Option<String>)`](crate::client::fluent_builders::BacktrackDBCluster::set_db_cluster_identifier): <p>The DB cluster identifier of the DB cluster to be backtracked. This parameter is stored as a lowercase string.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must contain from 1 to 63 alphanumeric characters or hyphens.</p> </li>   <li> <p>First character must be a letter.</p> </li>   <li> <p>Can't end with a hyphen or contain two consecutive hyphens.</p> </li>  </ul>  <p>Example: <code>my-cluster1</code> </p>
    ///   - [`backtrack_to(DateTime)`](crate::client::fluent_builders::BacktrackDBCluster::backtrack_to) / [`set_backtrack_to(Option<DateTime>)`](crate::client::fluent_builders::BacktrackDBCluster::set_backtrack_to): <p>The timestamp of the time to backtrack the DB cluster to, specified in ISO 8601 format. For more information about ISO 8601, see the <a href="http://en.wikipedia.org/wiki/ISO_8601">ISO8601 Wikipedia page.</a> </p> <note>   <p>If the specified time isn't a consistent time for the DB cluster, Aurora automatically chooses the nearest possible consistent time for the DB cluster.</p>  </note>  <p>Constraints:</p>  <ul>   <li> <p>Must contain a valid ISO 8601 timestamp.</p> </li>   <li> <p>Can't contain a timestamp set in the future.</p> </li>  </ul>  <p>Example: <code>2017-07-08T18:00Z</code> </p>
    ///   - [`force(bool)`](crate::client::fluent_builders::BacktrackDBCluster::force) / [`set_force(Option<bool>)`](crate::client::fluent_builders::BacktrackDBCluster::set_force): <p>A value that indicates whether to force the DB cluster to backtrack when binary logging is enabled. Otherwise, an error occurs when binary logging is enabled.</p>
    ///   - [`use_earliest_time_on_point_in_time_unavailable(bool)`](crate::client::fluent_builders::BacktrackDBCluster::use_earliest_time_on_point_in_time_unavailable) / [`set_use_earliest_time_on_point_in_time_unavailable(Option<bool>)`](crate::client::fluent_builders::BacktrackDBCluster::set_use_earliest_time_on_point_in_time_unavailable): <p>A value that indicates whether to backtrack the DB cluster to the earliest possible backtrack time when <i>BacktrackTo</i> is set to a timestamp earlier than the earliest backtrack time. When this parameter is disabled and <i>BacktrackTo</i> is set to a timestamp earlier than the earliest backtrack time, an error occurs.</p>
    /// - On success, responds with [`BacktrackDbClusterOutput`](crate::output::BacktrackDbClusterOutput) with field(s):
    ///   - [`db_cluster_identifier(Option<String>)`](crate::output::BacktrackDbClusterOutput::db_cluster_identifier): <p>Contains a user-supplied DB cluster identifier. This identifier is the unique key that identifies a DB cluster.</p>
    ///   - [`backtrack_identifier(Option<String>)`](crate::output::BacktrackDbClusterOutput::backtrack_identifier): <p>Contains the backtrack identifier.</p>
    ///   - [`backtrack_to(Option<DateTime>)`](crate::output::BacktrackDbClusterOutput::backtrack_to): <p>The timestamp of the time to which the DB cluster was backtracked.</p>
    ///   - [`backtracked_from(Option<DateTime>)`](crate::output::BacktrackDbClusterOutput::backtracked_from): <p>The timestamp of the time from which the DB cluster was backtracked.</p>
    ///   - [`backtrack_request_creation_time(Option<DateTime>)`](crate::output::BacktrackDbClusterOutput::backtrack_request_creation_time): <p>The timestamp of the time at which the backtrack was requested.</p>
    ///   - [`status(Option<String>)`](crate::output::BacktrackDbClusterOutput::status): <p>The status of the backtrack. This property returns one of the following values:</p>  <ul>   <li> <p> <code>applying</code> - The backtrack is currently being applied to or rolled back from the DB cluster.</p> </li>   <li> <p> <code>completed</code> - The backtrack has successfully been applied to or rolled back from the DB cluster.</p> </li>   <li> <p> <code>failed</code> - An error occurred while the backtrack was applied to or rolled back from the DB cluster.</p> </li>   <li> <p> <code>pending</code> - The backtrack is currently pending application to or rollback from the DB cluster.</p> </li>  </ul>
    /// - On failure, responds with [`SdkError<BacktrackDBClusterError>`](crate::error::BacktrackDBClusterError)
    pub fn backtrack_db_cluster(&self) -> fluent_builders::BacktrackDBCluster {
        fluent_builders::BacktrackDBCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CancelExportTask`](crate::client::fluent_builders::CancelExportTask) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`export_task_identifier(impl Into<String>)`](crate::client::fluent_builders::CancelExportTask::export_task_identifier) / [`set_export_task_identifier(Option<String>)`](crate::client::fluent_builders::CancelExportTask::set_export_task_identifier): <p>The identifier of the snapshot export task to cancel.</p>
    /// - On success, responds with [`CancelExportTaskOutput`](crate::output::CancelExportTaskOutput) with field(s):
    ///   - [`export_task_identifier(Option<String>)`](crate::output::CancelExportTaskOutput::export_task_identifier): <p>A unique identifier for the snapshot export task. This ID isn't an identifier for the Amazon S3 bucket where the snapshot is exported to.</p>
    ///   - [`source_arn(Option<String>)`](crate::output::CancelExportTaskOutput::source_arn): <p>The Amazon Resource Name (ARN) of the snapshot exported to Amazon S3.</p>
    ///   - [`export_only(Option<Vec<String>>)`](crate::output::CancelExportTaskOutput::export_only): <p>The data exported from the snapshot. Valid values are the following:</p>  <ul>   <li> <p> <code>database</code> - Export all the data from a specified database.</p> </li>   <li> <p> <code>database.table</code> <i>table-name</i> - Export a table of the snapshot. This format is valid only for RDS for MySQL, RDS for MariaDB, and Aurora MySQL.</p> </li>   <li> <p> <code>database.schema</code> <i>schema-name</i> - Export a database schema of the snapshot. This format is valid only for RDS for PostgreSQL and Aurora PostgreSQL.</p> </li>   <li> <p> <code>database.schema.table</code> <i>table-name</i> - Export a table of the database schema. This format is valid only for RDS for PostgreSQL and Aurora PostgreSQL.</p> </li>  </ul>
    ///   - [`snapshot_time(Option<DateTime>)`](crate::output::CancelExportTaskOutput::snapshot_time): <p>The time that the snapshot was created.</p>
    ///   - [`task_start_time(Option<DateTime>)`](crate::output::CancelExportTaskOutput::task_start_time): <p>The time that the snapshot export task started.</p>
    ///   - [`task_end_time(Option<DateTime>)`](crate::output::CancelExportTaskOutput::task_end_time): <p>The time that the snapshot export task completed.</p>
    ///   - [`s3_bucket(Option<String>)`](crate::output::CancelExportTaskOutput::s3_bucket): <p>The Amazon S3 bucket that the snapshot is exported to.</p>
    ///   - [`s3_prefix(Option<String>)`](crate::output::CancelExportTaskOutput::s3_prefix): <p>The Amazon S3 bucket prefix that is the file name and path of the exported snapshot.</p>
    ///   - [`iam_role_arn(Option<String>)`](crate::output::CancelExportTaskOutput::iam_role_arn): <p>The name of the IAM role that is used to write to Amazon S3 when exporting a snapshot.</p>
    ///   - [`kms_key_id(Option<String>)`](crate::output::CancelExportTaskOutput::kms_key_id): <p>The key identifier of the Amazon Web Services KMS key that is used to encrypt the snapshot when it's exported to Amazon S3. The KMS key identifier is its key ARN, key ID, alias ARN, or alias name. The IAM role used for the snapshot export must have encryption and decryption permissions to use this KMS key.</p>
    ///   - [`status(Option<String>)`](crate::output::CancelExportTaskOutput::status): <p>The progress status of the export task.</p>
    ///   - [`percent_progress(i32)`](crate::output::CancelExportTaskOutput::percent_progress): <p>The progress of the snapshot export task as a percentage.</p>
    ///   - [`total_extracted_data_in_gb(i32)`](crate::output::CancelExportTaskOutput::total_extracted_data_in_gb): <p>The total amount of data exported, in gigabytes.</p>
    ///   - [`failure_cause(Option<String>)`](crate::output::CancelExportTaskOutput::failure_cause): <p>The reason the export failed, if it failed.</p>
    ///   - [`warning_message(Option<String>)`](crate::output::CancelExportTaskOutput::warning_message): <p>A warning about the snapshot export task.</p>
    /// - On failure, responds with [`SdkError<CancelExportTaskError>`](crate::error::CancelExportTaskError)
    pub fn cancel_export_task(&self) -> fluent_builders::CancelExportTask {
        fluent_builders::CancelExportTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CopyDBClusterParameterGroup`](crate::client::fluent_builders::CopyDBClusterParameterGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`source_db_cluster_parameter_group_identifier(impl Into<String>)`](crate::client::fluent_builders::CopyDBClusterParameterGroup::source_db_cluster_parameter_group_identifier) / [`set_source_db_cluster_parameter_group_identifier(Option<String>)`](crate::client::fluent_builders::CopyDBClusterParameterGroup::set_source_db_cluster_parameter_group_identifier): <p>The identifier or Amazon Resource Name (ARN) for the source DB cluster parameter group. For information about creating an ARN, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing"> Constructing an ARN for Amazon RDS</a> in the <i>Amazon Aurora User Guide</i>.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must specify a valid DB cluster parameter group.</p> </li>  </ul>
    ///   - [`target_db_cluster_parameter_group_identifier(impl Into<String>)`](crate::client::fluent_builders::CopyDBClusterParameterGroup::target_db_cluster_parameter_group_identifier) / [`set_target_db_cluster_parameter_group_identifier(Option<String>)`](crate::client::fluent_builders::CopyDBClusterParameterGroup::set_target_db_cluster_parameter_group_identifier): <p>The identifier for the copied DB cluster parameter group.</p>  <p>Constraints:</p>  <ul>   <li> <p>Can't be null, empty, or blank</p> </li>   <li> <p>Must contain from 1 to 255 letters, numbers, or hyphens</p> </li>   <li> <p>First character must be a letter</p> </li>   <li> <p>Can't end with a hyphen or contain two consecutive hyphens</p> </li>  </ul>  <p>Example: <code>my-cluster-param-group1</code> </p>
    ///   - [`target_db_cluster_parameter_group_description(impl Into<String>)`](crate::client::fluent_builders::CopyDBClusterParameterGroup::target_db_cluster_parameter_group_description) / [`set_target_db_cluster_parameter_group_description(Option<String>)`](crate::client::fluent_builders::CopyDBClusterParameterGroup::set_target_db_cluster_parameter_group_description): <p>A description for the copied DB cluster parameter group.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CopyDBClusterParameterGroup::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CopyDBClusterParameterGroup::set_tags): <p>A list of tags. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources</a> in the <i>Amazon RDS User Guide.</i> </p>
    /// - On success, responds with [`CopyDbClusterParameterGroupOutput`](crate::output::CopyDbClusterParameterGroupOutput) with field(s):
    ///   - [`db_cluster_parameter_group(Option<DbClusterParameterGroup>)`](crate::output::CopyDbClusterParameterGroupOutput::db_cluster_parameter_group): <p>Contains the details of an Amazon RDS DB cluster parameter group.</p>  <p>This data type is used as a response element in the <code>DescribeDBClusterParameterGroups</code> action.</p>
    /// - On failure, responds with [`SdkError<CopyDBClusterParameterGroupError>`](crate::error::CopyDBClusterParameterGroupError)
    pub fn copy_db_cluster_parameter_group(&self) -> fluent_builders::CopyDBClusterParameterGroup {
        fluent_builders::CopyDBClusterParameterGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CopyDBClusterSnapshot`](crate::client::fluent_builders::CopyDBClusterSnapshot) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`source_db_cluster_snapshot_identifier(impl Into<String>)`](crate::client::fluent_builders::CopyDBClusterSnapshot::source_db_cluster_snapshot_identifier) / [`set_source_db_cluster_snapshot_identifier(Option<String>)`](crate::client::fluent_builders::CopyDBClusterSnapshot::set_source_db_cluster_snapshot_identifier): <p>The identifier of the DB cluster snapshot to copy. This parameter isn't case-sensitive.</p>  <p>You can't copy an encrypted, shared DB cluster snapshot from one Amazon Web Services Region to another.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must specify a valid system snapshot in the "available" state.</p> </li>   <li> <p>If the source snapshot is in the same Amazon Web Services Region as the copy, specify a valid DB snapshot identifier.</p> </li>   <li> <p>If the source snapshot is in a different Amazon Web Services Region than the copy, specify a valid DB cluster snapshot ARN. For more information, go to <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_CopySnapshot.html#USER_CopySnapshot.AcrossRegions"> Copying Snapshots Across Amazon Web Services Regions</a> in the <i>Amazon Aurora User Guide</i>.</p> </li>  </ul>  <p>Example: <code>my-cluster-snapshot1</code> </p>
    ///   - [`target_db_cluster_snapshot_identifier(impl Into<String>)`](crate::client::fluent_builders::CopyDBClusterSnapshot::target_db_cluster_snapshot_identifier) / [`set_target_db_cluster_snapshot_identifier(Option<String>)`](crate::client::fluent_builders::CopyDBClusterSnapshot::set_target_db_cluster_snapshot_identifier): <p>The identifier of the new DB cluster snapshot to create from the source DB cluster snapshot. This parameter isn't case-sensitive.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p> </li>   <li> <p>First character must be a letter.</p> </li>   <li> <p>Can't end with a hyphen or contain two consecutive hyphens.</p> </li>  </ul>  <p>Example: <code>my-cluster-snapshot2</code> </p>
    ///   - [`kms_key_id(impl Into<String>)`](crate::client::fluent_builders::CopyDBClusterSnapshot::kms_key_id) / [`set_kms_key_id(Option<String>)`](crate::client::fluent_builders::CopyDBClusterSnapshot::set_kms_key_id): <p>The Amazon Web Services KMS key identifier for an encrypted DB cluster snapshot. The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the Amazon Web Services KMS key.</p>  <p>If you copy an encrypted DB cluster snapshot from your Amazon Web Services account, you can specify a value for <code>KmsKeyId</code> to encrypt the copy with a new KMS key. If you don't specify a value for <code>KmsKeyId</code>, then the copy of the DB cluster snapshot is encrypted with the same KMS key as the source DB cluster snapshot.</p>  <p>If you copy an encrypted DB cluster snapshot that is shared from another Amazon Web Services account, then you must specify a value for <code>KmsKeyId</code>.</p>  <p>To copy an encrypted DB cluster snapshot to another Amazon Web Services Region, you must set <code>KmsKeyId</code> to the Amazon Web Services KMS key identifier you want to use to encrypt the copy of the DB cluster snapshot in the destination Amazon Web Services Region. KMS keys are specific to the Amazon Web Services Region that they are created in, and you can't use KMS keys from one Amazon Web Services Region in another Amazon Web Services Region.</p>  <p>If you copy an unencrypted DB cluster snapshot and specify a value for the <code>KmsKeyId</code> parameter, an error is returned.</p>
    ///   - [`pre_signed_url(impl Into<String>)`](crate::client::fluent_builders::CopyDBClusterSnapshot::pre_signed_url) / [`set_pre_signed_url(Option<String>)`](crate::client::fluent_builders::CopyDBClusterSnapshot::set_pre_signed_url): <p>The URL that contains a Signature Version 4 signed request for the <code>CopyDBClusterSnapshot</code> API action in the Amazon Web Services Region that contains the source DB cluster snapshot to copy. The <code>PreSignedUrl</code> parameter must be used when copying an encrypted DB cluster snapshot from another Amazon Web Services Region. Don't specify <code>PreSignedUrl</code> when you are copying an encrypted DB cluster snapshot in the same Amazon Web Services Region.</p>  <p>The pre-signed URL must be a valid request for the <code>CopyDBClusterSnapshot</code> API action that can be executed in the source Amazon Web Services Region that contains the encrypted DB cluster snapshot to be copied. The pre-signed URL request must contain the following parameter values:</p>  <ul>   <li> <p> <code>KmsKeyId</code> - The Amazon Web Services KMS key identifier for the KMS key to use to encrypt the copy of the DB cluster snapshot in the destination Amazon Web Services Region. This is the same identifier for both the <code>CopyDBClusterSnapshot</code> action that is called in the destination Amazon Web Services Region, and the action contained in the pre-signed URL.</p> </li>   <li> <p> <code>DestinationRegion</code> - The name of the Amazon Web Services Region that the DB cluster snapshot is to be created in.</p> </li>   <li> <p> <code>SourceDBClusterSnapshotIdentifier</code> - The DB cluster snapshot identifier for the encrypted DB cluster snapshot to be copied. This identifier must be in the Amazon Resource Name (ARN) format for the source Amazon Web Services Region. For example, if you are copying an encrypted DB cluster snapshot from the us-west-2 Amazon Web Services Region, then your <code>SourceDBClusterSnapshotIdentifier</code> looks like the following example: <code>arn:aws:rds:us-west-2:123456789012:cluster-snapshot:aurora-cluster1-snapshot-20161115</code>.</p> </li>  </ul>  <p>To learn how to generate a Signature Version 4 signed request, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html"> Authenticating Requests: Using Query Parameters (Amazon Web Services Signature Version 4)</a> and <a href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html"> Signature Version 4 Signing Process</a>.</p> <note>   <p>If you are using an Amazon Web Services SDK tool or the CLI, you can specify <code>SourceRegion</code> (or <code>--source-region</code> for the CLI) instead of specifying <code>PreSignedUrl</code> manually. Specifying <code>SourceRegion</code> autogenerates a pre-signed URL that is a valid request for the operation that can be executed in the source Amazon Web Services Region.</p>  </note>
    ///   - [`copy_tags(bool)`](crate::client::fluent_builders::CopyDBClusterSnapshot::copy_tags) / [`set_copy_tags(Option<bool>)`](crate::client::fluent_builders::CopyDBClusterSnapshot::set_copy_tags): <p>A value that indicates whether to copy all tags from the source DB cluster snapshot to the target DB cluster snapshot. By default, tags are not copied.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CopyDBClusterSnapshot::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CopyDBClusterSnapshot::set_tags): <p>A list of tags. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources</a> in the <i>Amazon RDS User Guide.</i> </p>
    /// - On success, responds with [`CopyDbClusterSnapshotOutput`](crate::output::CopyDbClusterSnapshotOutput) with field(s):
    ///   - [`db_cluster_snapshot(Option<DbClusterSnapshot>)`](crate::output::CopyDbClusterSnapshotOutput::db_cluster_snapshot): <p>Contains the details for an Amazon RDS DB cluster snapshot</p>  <p>This data type is used as a response element in the <code>DescribeDBClusterSnapshots</code> action.</p>
    /// - On failure, responds with [`SdkError<CopyDBClusterSnapshotError>`](crate::error::CopyDBClusterSnapshotError)
    pub fn copy_db_cluster_snapshot(&self) -> fluent_builders::CopyDBClusterSnapshot {
        fluent_builders::CopyDBClusterSnapshot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CopyDBParameterGroup`](crate::client::fluent_builders::CopyDBParameterGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`source_db_parameter_group_identifier(impl Into<String>)`](crate::client::fluent_builders::CopyDBParameterGroup::source_db_parameter_group_identifier) / [`set_source_db_parameter_group_identifier(Option<String>)`](crate::client::fluent_builders::CopyDBParameterGroup::set_source_db_parameter_group_identifier): <p>The identifier or ARN for the source DB parameter group. For information about creating an ARN, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing"> Constructing an ARN for Amazon RDS</a> in the <i>Amazon RDS User Guide</i>.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must specify a valid DB parameter group.</p> </li>  </ul>
    ///   - [`target_db_parameter_group_identifier(impl Into<String>)`](crate::client::fluent_builders::CopyDBParameterGroup::target_db_parameter_group_identifier) / [`set_target_db_parameter_group_identifier(Option<String>)`](crate::client::fluent_builders::CopyDBParameterGroup::set_target_db_parameter_group_identifier): <p>The identifier for the copied DB parameter group.</p>  <p>Constraints:</p>  <ul>   <li> <p>Can't be null, empty, or blank</p> </li>   <li> <p>Must contain from 1 to 255 letters, numbers, or hyphens</p> </li>   <li> <p>First character must be a letter</p> </li>   <li> <p>Can't end with a hyphen or contain two consecutive hyphens</p> </li>  </ul>  <p>Example: <code>my-db-parameter-group</code> </p>
    ///   - [`target_db_parameter_group_description(impl Into<String>)`](crate::client::fluent_builders::CopyDBParameterGroup::target_db_parameter_group_description) / [`set_target_db_parameter_group_description(Option<String>)`](crate::client::fluent_builders::CopyDBParameterGroup::set_target_db_parameter_group_description): <p>A description for the copied DB parameter group.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CopyDBParameterGroup::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CopyDBParameterGroup::set_tags): <p>A list of tags. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources</a> in the <i>Amazon RDS User Guide.</i> </p>
    /// - On success, responds with [`CopyDbParameterGroupOutput`](crate::output::CopyDbParameterGroupOutput) with field(s):
    ///   - [`db_parameter_group(Option<DbParameterGroup>)`](crate::output::CopyDbParameterGroupOutput::db_parameter_group): <p>Contains the details of an Amazon RDS DB parameter group.</p>  <p>This data type is used as a response element in the <code>DescribeDBParameterGroups</code> action.</p>
    /// - On failure, responds with [`SdkError<CopyDBParameterGroupError>`](crate::error::CopyDBParameterGroupError)
    pub fn copy_db_parameter_group(&self) -> fluent_builders::CopyDBParameterGroup {
        fluent_builders::CopyDBParameterGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CopyDBSnapshot`](crate::client::fluent_builders::CopyDBSnapshot) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`source_db_snapshot_identifier(impl Into<String>)`](crate::client::fluent_builders::CopyDBSnapshot::source_db_snapshot_identifier) / [`set_source_db_snapshot_identifier(Option<String>)`](crate::client::fluent_builders::CopyDBSnapshot::set_source_db_snapshot_identifier): <p>The identifier for the source DB snapshot.</p>  <p>If the source snapshot is in the same Amazon Web Services Region as the copy, specify a valid DB snapshot identifier. For example, you might specify <code>rds:mysql-instance1-snapshot-20130805</code>.</p>  <p>If the source snapshot is in a different Amazon Web Services Region than the copy, specify a valid DB snapshot ARN. For example, you might specify <code>arn:aws:rds:us-west-2:123456789012:snapshot:mysql-instance1-snapshot-20130805</code>.</p>  <p>If you are copying from a shared manual DB snapshot, this parameter must be the Amazon Resource Name (ARN) of the shared DB snapshot.</p>  <p>If you are copying an encrypted snapshot this parameter must be in the ARN format for the source Amazon Web Services Region, and must match the <code>SourceDBSnapshotIdentifier</code> in the <code>PreSignedUrl</code> parameter.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must specify a valid system snapshot in the "available" state.</p> </li>  </ul>  <p>Example: <code>rds:mydb-2012-04-02-00-01</code> </p>  <p>Example: <code>arn:aws:rds:us-west-2:123456789012:snapshot:mysql-instance1-snapshot-20130805</code> </p>
    ///   - [`target_db_snapshot_identifier(impl Into<String>)`](crate::client::fluent_builders::CopyDBSnapshot::target_db_snapshot_identifier) / [`set_target_db_snapshot_identifier(Option<String>)`](crate::client::fluent_builders::CopyDBSnapshot::set_target_db_snapshot_identifier): <p>The identifier for the copy of the snapshot.</p>  <p>Constraints:</p>  <ul>   <li> <p>Can't be null, empty, or blank</p> </li>   <li> <p>Must contain from 1 to 255 letters, numbers, or hyphens</p> </li>   <li> <p>First character must be a letter</p> </li>   <li> <p>Can't end with a hyphen or contain two consecutive hyphens</p> </li>  </ul>  <p>Example: <code>my-db-snapshot</code> </p>
    ///   - [`kms_key_id(impl Into<String>)`](crate::client::fluent_builders::CopyDBSnapshot::kms_key_id) / [`set_kms_key_id(Option<String>)`](crate::client::fluent_builders::CopyDBSnapshot::set_kms_key_id): <p>The Amazon Web Services KMS key identifier for an encrypted DB snapshot. The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.</p>  <p>If you copy an encrypted DB snapshot from your Amazon Web Services account, you can specify a value for this parameter to encrypt the copy with a new KMS key. If you don't specify a value for this parameter, then the copy of the DB snapshot is encrypted with the same Amazon Web Services KMS key as the source DB snapshot.</p>  <p>If you copy an encrypted DB snapshot that is shared from another Amazon Web Services account, then you must specify a value for this parameter.</p>  <p>If you specify this parameter when you copy an unencrypted snapshot, the copy is encrypted.</p>  <p>If you copy an encrypted snapshot to a different Amazon Web Services Region, then you must specify an Amazon Web Services KMS key identifier for the destination Amazon Web Services Region. KMS keys are specific to the Amazon Web Services Region that they are created in, and you can't use KMS keys from one Amazon Web Services Region in another Amazon Web Services Region.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CopyDBSnapshot::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CopyDBSnapshot::set_tags): <p>A list of tags. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources</a> in the <i>Amazon RDS User Guide.</i> </p>
    ///   - [`copy_tags(bool)`](crate::client::fluent_builders::CopyDBSnapshot::copy_tags) / [`set_copy_tags(Option<bool>)`](crate::client::fluent_builders::CopyDBSnapshot::set_copy_tags): <p>A value that indicates whether to copy all tags from the source DB snapshot to the target DB snapshot. By default, tags are not copied.</p>
    ///   - [`pre_signed_url(impl Into<String>)`](crate::client::fluent_builders::CopyDBSnapshot::pre_signed_url) / [`set_pre_signed_url(Option<String>)`](crate::client::fluent_builders::CopyDBSnapshot::set_pre_signed_url): <p>The URL that contains a Signature Version 4 signed request for the <code>CopyDBSnapshot</code> API action in the source Amazon Web Services Region that contains the source DB snapshot to copy.</p>  <p>You must specify this parameter when you copy an encrypted DB snapshot from another Amazon Web Services Region by using the Amazon RDS API. Don't specify <code>PreSignedUrl</code> when you are copying an encrypted DB snapshot in the same Amazon Web Services Region.</p>  <p>The presigned URL must be a valid request for the <code>CopyDBSnapshot</code> API action that can be executed in the source Amazon Web Services Region that contains the encrypted DB snapshot to be copied. The presigned URL request must contain the following parameter values:</p>  <ul>   <li> <p> <code>DestinationRegion</code> - The Amazon Web Services Region that the encrypted DB snapshot is copied to. This Amazon Web Services Region is the same one where the <code>CopyDBSnapshot</code> action is called that contains this presigned URL.</p> <p>For example, if you copy an encrypted DB snapshot from the us-west-2 Amazon Web Services Region to the us-east-1 Amazon Web Services Region, then you call the <code>CopyDBSnapshot</code> action in the us-east-1 Amazon Web Services Region and provide a presigned URL that contains a call to the <code>CopyDBSnapshot</code> action in the us-west-2 Amazon Web Services Region. For this example, the <code>DestinationRegion</code> in the presigned URL must be set to the us-east-1 Amazon Web Services Region.</p> </li>   <li> <p> <code>KmsKeyId</code> - The Amazon Web Services KMS key identifier for the KMS key to use to encrypt the copy of the DB snapshot in the destination Amazon Web Services Region. This is the same identifier for both the <code>CopyDBSnapshot</code> action that is called in the destination Amazon Web Services Region, and the action contained in the presigned URL.</p> </li>   <li> <p> <code>SourceDBSnapshotIdentifier</code> - The DB snapshot identifier for the encrypted snapshot to be copied. This identifier must be in the Amazon Resource Name (ARN) format for the source Amazon Web Services Region. For example, if you are copying an encrypted DB snapshot from the us-west-2 Amazon Web Services Region, then your <code>SourceDBSnapshotIdentifier</code> looks like the following example: <code>arn:aws:rds:us-west-2:123456789012:snapshot:mysql-instance1-snapshot-20161115</code>.</p> </li>  </ul>  <p>To learn how to generate a Signature Version 4 signed request, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html">Authenticating Requests: Using Query Parameters (Amazon Web Services Signature Version 4)</a> and <a href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4 Signing Process</a>.</p> <note>   <p>If you are using an Amazon Web Services SDK tool or the CLI, you can specify <code>SourceRegion</code> (or <code>--source-region</code> for the CLI) instead of specifying <code>PreSignedUrl</code> manually. Specifying <code>SourceRegion</code> autogenerates a pre-signed URL that is a valid request for the operation that can be executed in the source Amazon Web Services Region.</p>  </note>
    ///   - [`option_group_name(impl Into<String>)`](crate::client::fluent_builders::CopyDBSnapshot::option_group_name) / [`set_option_group_name(Option<String>)`](crate::client::fluent_builders::CopyDBSnapshot::set_option_group_name): <p>The name of an option group to associate with the copy of the snapshot.</p>  <p>Specify this option if you are copying a snapshot from one Amazon Web Services Region to another, and your DB instance uses a nondefault option group. If your source DB instance uses Transparent Data Encryption for Oracle or Microsoft SQL Server, you must specify this option when copying across Amazon Web Services Regions. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_CopySnapshot.html#USER_CopySnapshot.Options">Option group considerations</a> in the <i>Amazon RDS User Guide</i>.</p>
    ///   - [`target_custom_availability_zone(impl Into<String>)`](crate::client::fluent_builders::CopyDBSnapshot::target_custom_availability_zone) / [`set_target_custom_availability_zone(Option<String>)`](crate::client::fluent_builders::CopyDBSnapshot::set_target_custom_availability_zone): <p>The external custom Availability Zone (CAZ) identifier for the target CAZ.</p>  <p>Example: <code>rds-caz-aiqhTgQv</code>.</p>
    /// - On success, responds with [`CopyDbSnapshotOutput`](crate::output::CopyDbSnapshotOutput) with field(s):
    ///   - [`db_snapshot(Option<DbSnapshot>)`](crate::output::CopyDbSnapshotOutput::db_snapshot): <p>Contains the details of an Amazon RDS DB snapshot.</p>  <p>This data type is used as a response element in the <code>DescribeDBSnapshots</code> action.</p>
    /// - On failure, responds with [`SdkError<CopyDBSnapshotError>`](crate::error::CopyDBSnapshotError)
    pub fn copy_db_snapshot(&self) -> fluent_builders::CopyDBSnapshot {
        fluent_builders::CopyDBSnapshot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CopyOptionGroup`](crate::client::fluent_builders::CopyOptionGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`source_option_group_identifier(impl Into<String>)`](crate::client::fluent_builders::CopyOptionGroup::source_option_group_identifier) / [`set_source_option_group_identifier(Option<String>)`](crate::client::fluent_builders::CopyOptionGroup::set_source_option_group_identifier): <p>The identifier for the source option group.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must specify a valid option group.</p> </li>  </ul>
    ///   - [`target_option_group_identifier(impl Into<String>)`](crate::client::fluent_builders::CopyOptionGroup::target_option_group_identifier) / [`set_target_option_group_identifier(Option<String>)`](crate::client::fluent_builders::CopyOptionGroup::set_target_option_group_identifier): <p>The identifier for the copied option group.</p>  <p>Constraints:</p>  <ul>   <li> <p>Can't be null, empty, or blank</p> </li>   <li> <p>Must contain from 1 to 255 letters, numbers, or hyphens</p> </li>   <li> <p>First character must be a letter</p> </li>   <li> <p>Can't end with a hyphen or contain two consecutive hyphens</p> </li>  </ul>  <p>Example: <code>my-option-group</code> </p>
    ///   - [`target_option_group_description(impl Into<String>)`](crate::client::fluent_builders::CopyOptionGroup::target_option_group_description) / [`set_target_option_group_description(Option<String>)`](crate::client::fluent_builders::CopyOptionGroup::set_target_option_group_description): <p>The description for the copied option group.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CopyOptionGroup::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CopyOptionGroup::set_tags): <p>A list of tags. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources</a> in the <i>Amazon RDS User Guide.</i> </p>
    /// - On success, responds with [`CopyOptionGroupOutput`](crate::output::CopyOptionGroupOutput) with field(s):
    ///   - [`option_group(Option<OptionGroup>)`](crate::output::CopyOptionGroupOutput::option_group): <p></p>
    /// - On failure, responds with [`SdkError<CopyOptionGroupError>`](crate::error::CopyOptionGroupError)
    pub fn copy_option_group(&self) -> fluent_builders::CopyOptionGroup {
        fluent_builders::CopyOptionGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateCustomDBEngineVersion`](crate::client::fluent_builders::CreateCustomDBEngineVersion) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`engine(impl Into<String>)`](crate::client::fluent_builders::CreateCustomDBEngineVersion::engine) / [`set_engine(Option<String>)`](crate::client::fluent_builders::CreateCustomDBEngineVersion::set_engine): <p>The database engine to use for your custom engine version (CEV). The only supported value is <code>custom-oracle-ee</code>.</p>
    ///   - [`engine_version(impl Into<String>)`](crate::client::fluent_builders::CreateCustomDBEngineVersion::engine_version) / [`set_engine_version(Option<String>)`](crate::client::fluent_builders::CreateCustomDBEngineVersion::set_engine_version): <p>The name of your CEV. The name format is <code>19.<i>customized_string</i> </code>. For example, a valid name is <code>19.my_cev1</code>. This setting is required for RDS Custom for Oracle, but optional for Amazon RDS. The combination of <code>Engine</code> and <code>EngineVersion</code> is unique per customer per Region.</p>
    ///   - [`database_installation_files_s3_bucket_name(impl Into<String>)`](crate::client::fluent_builders::CreateCustomDBEngineVersion::database_installation_files_s3_bucket_name) / [`set_database_installation_files_s3_bucket_name(Option<String>)`](crate::client::fluent_builders::CreateCustomDBEngineVersion::set_database_installation_files_s3_bucket_name): <p>The name of an Amazon S3 bucket that contains database installation files for your CEV. For example, a valid bucket name is <code>my-custom-installation-files</code>.</p>
    ///   - [`database_installation_files_s3_prefix(impl Into<String>)`](crate::client::fluent_builders::CreateCustomDBEngineVersion::database_installation_files_s3_prefix) / [`set_database_installation_files_s3_prefix(Option<String>)`](crate::client::fluent_builders::CreateCustomDBEngineVersion::set_database_installation_files_s3_prefix): <p>The Amazon S3 directory that contains the database installation files for your CEV. For example, a valid bucket name is <code>123456789012/cev1</code>. If this setting isn't specified, no prefix is assumed.</p>
    ///   - [`kms_key_id(impl Into<String>)`](crate::client::fluent_builders::CreateCustomDBEngineVersion::kms_key_id) / [`set_kms_key_id(Option<String>)`](crate::client::fluent_builders::CreateCustomDBEngineVersion::set_kms_key_id): <p>The Amazon Web Services KMS key identifier for an encrypted CEV. A symmetric KMS key is required for RDS Custom, but optional for Amazon RDS.</p>  <p>If you have an existing symmetric KMS key in your account, you can use it with RDS Custom. No further action is necessary. If you don't already have a symmetric KMS key in your account, follow the instructions in <a href="https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html#create-symmetric-cmk"> Creating symmetric KMS keys</a> in the <i>Amazon Web Services Key Management Service Developer Guide</i>.</p>  <p>You can choose the same symmetric key when you create a CEV and a DB instance, or choose different keys.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateCustomDBEngineVersion::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateCustomDBEngineVersion::set_description): <p>An optional description of your CEV.</p>
    ///   - [`manifest(impl Into<String>)`](crate::client::fluent_builders::CreateCustomDBEngineVersion::manifest) / [`set_manifest(Option<String>)`](crate::client::fluent_builders::CreateCustomDBEngineVersion::set_manifest): <p>The CEV manifest, which is a JSON document that describes the installation .zip files stored in Amazon S3. Specify the name/value pairs in a file or a quoted string. RDS Custom applies the patches in the order in which they are listed.</p>  <p>The following JSON fields are valid:</p>  <dl>   <dt>   MediaImportTemplateVersion  </dt>   <dd>    <p>Version of the CEV manifest. The date is in the format <code>YYYY-MM-DD</code>.</p>   </dd>   <dt>   databaseInstallationFileNames  </dt>   <dd>    <p>Ordered list of installation files for the CEV.</p>   </dd>   <dt>   opatchFileNames  </dt>   <dd>    <p>Ordered list of OPatch installers used for the Oracle DB engine.</p>   </dd>   <dt>   psuRuPatchFileNames  </dt>   <dd>    <p>The PSU and RU patches for this CEV.</p>   </dd>   <dt>   OtherPatchFileNames  </dt>   <dd>    <p>The patches that are not in the list of PSU and RU patches. Amazon RDS applies these patches after applying the PSU and RU patches.</p>   </dd>  </dl>  <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-cev.html#custom-cev.preparing.manifest"> Creating the CEV manifest</a> in the <i>Amazon RDS User Guide</i>.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateCustomDBEngineVersion::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateCustomDBEngineVersion::set_tags): <p>A list of tags. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources</a> in the <i>Amazon RDS User Guide.</i> </p>
    /// - On success, responds with [`CreateCustomDbEngineVersionOutput`](crate::output::CreateCustomDbEngineVersionOutput) with field(s):
    ///   - [`engine(Option<String>)`](crate::output::CreateCustomDbEngineVersionOutput::engine): <p>The name of the database engine.</p>
    ///   - [`engine_version(Option<String>)`](crate::output::CreateCustomDbEngineVersionOutput::engine_version): <p>The version number of the database engine.</p>
    ///   - [`db_parameter_group_family(Option<String>)`](crate::output::CreateCustomDbEngineVersionOutput::db_parameter_group_family): <p>The name of the DB parameter group family for the database engine.</p>
    ///   - [`db_engine_description(Option<String>)`](crate::output::CreateCustomDbEngineVersionOutput::db_engine_description): <p>The description of the database engine.</p>
    ///   - [`db_engine_version_description(Option<String>)`](crate::output::CreateCustomDbEngineVersionOutput::db_engine_version_description): <p>The description of the database engine version.</p>
    ///   - [`default_character_set(Option<CharacterSet>)`](crate::output::CreateCustomDbEngineVersionOutput::default_character_set): <p>The default character set for new instances of this engine version, if the <code>CharacterSetName</code> parameter of the CreateDBInstance API isn't specified.</p>
    ///   - [`supported_character_sets(Option<Vec<CharacterSet>>)`](crate::output::CreateCustomDbEngineVersionOutput::supported_character_sets): <p>A list of the character sets supported by this engine for the <code>CharacterSetName</code> parameter of the <code>CreateDBInstance</code> operation.</p>
    ///   - [`supported_nchar_character_sets(Option<Vec<CharacterSet>>)`](crate::output::CreateCustomDbEngineVersionOutput::supported_nchar_character_sets): <p>A list of the character sets supported by the Oracle DB engine for the <code>NcharCharacterSetName</code> parameter of the <code>CreateDBInstance</code> operation.</p>
    ///   - [`valid_upgrade_target(Option<Vec<UpgradeTarget>>)`](crate::output::CreateCustomDbEngineVersionOutput::valid_upgrade_target): <p>A list of engine versions that this database engine version can be upgraded to.</p>
    ///   - [`supported_timezones(Option<Vec<Timezone>>)`](crate::output::CreateCustomDbEngineVersionOutput::supported_timezones): <p>A list of the time zones supported by this engine for the <code>Timezone</code> parameter of the <code>CreateDBInstance</code> action.</p>
    ///   - [`exportable_log_types(Option<Vec<String>>)`](crate::output::CreateCustomDbEngineVersionOutput::exportable_log_types): <p>The types of logs that the database engine has available for export to CloudWatch Logs.</p>
    ///   - [`supports_log_exports_to_cloudwatch_logs(bool)`](crate::output::CreateCustomDbEngineVersionOutput::supports_log_exports_to_cloudwatch_logs): <p>A value that indicates whether the engine version supports exporting the log types specified by ExportableLogTypes to CloudWatch Logs.</p>
    ///   - [`supports_read_replica(bool)`](crate::output::CreateCustomDbEngineVersionOutput::supports_read_replica): <p>Indicates whether the database engine version supports read replicas.</p>
    ///   - [`supported_engine_modes(Option<Vec<String>>)`](crate::output::CreateCustomDbEngineVersionOutput::supported_engine_modes): <p>A list of the supported DB engine modes.</p>
    ///   - [`supported_feature_names(Option<Vec<String>>)`](crate::output::CreateCustomDbEngineVersionOutput::supported_feature_names): <p>A list of features supported by the DB engine.</p>  <p>The supported features vary by DB engine and DB engine version.</p>  <p>To determine the supported features for a specific DB engine and DB engine version using the CLI, use the following command:</p>  <p> <code>aws rds describe-db-engine-versions --engine    <engine_name>     --engine-version     <engine_version></engine_version>   </engine_name></code> </p>  <p>For example, to determine the supported features for RDS for PostgreSQL version 13.3 using the CLI, use the following command:</p>  <p> <code>aws rds describe-db-engine-versions --engine postgres --engine-version 13.3</code> </p>  <p>The supported features are listed under <code>SupportedFeatureNames</code> in the output.</p>
    ///   - [`status(Option<String>)`](crate::output::CreateCustomDbEngineVersionOutput::status): <p>The status of the DB engine version, either <code>available</code> or <code>deprecated</code>.</p>
    ///   - [`supports_parallel_query(bool)`](crate::output::CreateCustomDbEngineVersionOutput::supports_parallel_query): <p>A value that indicates whether you can use Aurora parallel query with a specific DB engine version.</p>
    ///   - [`supports_global_databases(bool)`](crate::output::CreateCustomDbEngineVersionOutput::supports_global_databases): <p>A value that indicates whether you can use Aurora global databases with a specific DB engine version.</p>
    ///   - [`major_engine_version(Option<String>)`](crate::output::CreateCustomDbEngineVersionOutput::major_engine_version): <p>The major engine version of the CEV.</p>
    ///   - [`database_installation_files_s3_bucket_name(Option<String>)`](crate::output::CreateCustomDbEngineVersionOutput::database_installation_files_s3_bucket_name): <p>The name of the Amazon S3 bucket that contains your database installation files.</p>
    ///   - [`database_installation_files_s3_prefix(Option<String>)`](crate::output::CreateCustomDbEngineVersionOutput::database_installation_files_s3_prefix): <p>The Amazon S3 directory that contains the database installation files. If not specified, then no prefix is assumed.</p>
    ///   - [`db_engine_version_arn(Option<String>)`](crate::output::CreateCustomDbEngineVersionOutput::db_engine_version_arn): <p>The ARN of the custom engine version.</p>
    ///   - [`kms_key_id(Option<String>)`](crate::output::CreateCustomDbEngineVersionOutput::kms_key_id): <p>The Amazon Web Services KMS key identifier for an encrypted CEV. This parameter is required for RDS Custom, but optional for Amazon RDS.</p>
    ///   - [`create_time(Option<DateTime>)`](crate::output::CreateCustomDbEngineVersionOutput::create_time): <p>The creation time of the DB engine version.</p>
    ///   - [`tag_list(Option<Vec<Tag>>)`](crate::output::CreateCustomDbEngineVersionOutput::tag_list): <p>A list of tags. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources</a> in the <i>Amazon RDS User Guide.</i> </p>
    ///   - [`supports_babelfish(bool)`](crate::output::CreateCustomDbEngineVersionOutput::supports_babelfish): <p>A value that indicates whether the engine version supports Babelfish for Aurora PostgreSQL.</p>
    /// - On failure, responds with [`SdkError<CreateCustomDBEngineVersionError>`](crate::error::CreateCustomDBEngineVersionError)
    pub fn create_custom_db_engine_version(&self) -> fluent_builders::CreateCustomDBEngineVersion {
        fluent_builders::CreateCustomDBEngineVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateDBCluster`](crate::client::fluent_builders::CreateDBCluster) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`availability_zones(Vec<String>)`](crate::client::fluent_builders::CreateDBCluster::availability_zones) / [`set_availability_zones(Option<Vec<String>>)`](crate::client::fluent_builders::CreateDBCluster::set_availability_zones): <p>A list of Availability Zones (AZs) where DB instances in the DB cluster can be created.</p>  <p>For information on Amazon Web Services Regions and Availability Zones, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Concepts.RegionsAndAvailabilityZones.html">Choosing the Regions and Availability Zones</a> in the <i>Amazon Aurora User Guide</i>.</p>  <p>Valid for: Aurora DB clusters only</p>
    ///   - [`backup_retention_period(i32)`](crate::client::fluent_builders::CreateDBCluster::backup_retention_period) / [`set_backup_retention_period(Option<i32>)`](crate::client::fluent_builders::CreateDBCluster::set_backup_retention_period): <p>The number of days for which automated backups are retained.</p>  <p>Default: 1</p>  <p>Constraints:</p>  <ul>   <li> <p>Must be a value from 1 to 35</p> </li>  </ul>  <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
    ///   - [`character_set_name(impl Into<String>)`](crate::client::fluent_builders::CreateDBCluster::character_set_name) / [`set_character_set_name(Option<String>)`](crate::client::fluent_builders::CreateDBCluster::set_character_set_name): <p>A value that indicates that the DB cluster should be associated with the specified CharacterSet.</p>  <p>Valid for: Aurora DB clusters only</p>
    ///   - [`database_name(impl Into<String>)`](crate::client::fluent_builders::CreateDBCluster::database_name) / [`set_database_name(Option<String>)`](crate::client::fluent_builders::CreateDBCluster::set_database_name): <p>The name for your database of up to 64 alphanumeric characters. If you do not provide a name, Amazon RDS doesn't create a database in the DB cluster you are creating.</p>  <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
    ///   - [`db_cluster_identifier(impl Into<String>)`](crate::client::fluent_builders::CreateDBCluster::db_cluster_identifier) / [`set_db_cluster_identifier(Option<String>)`](crate::client::fluent_builders::CreateDBCluster::set_db_cluster_identifier): <p>The DB cluster identifier. This parameter is stored as a lowercase string.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p> </li>   <li> <p>First character must be a letter.</p> </li>   <li> <p>Can't end with a hyphen or contain two consecutive hyphens.</p> </li>  </ul>  <p>Example: <code>my-cluster1</code> </p>  <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
    ///   - [`db_cluster_parameter_group_name(impl Into<String>)`](crate::client::fluent_builders::CreateDBCluster::db_cluster_parameter_group_name) / [`set_db_cluster_parameter_group_name(Option<String>)`](crate::client::fluent_builders::CreateDBCluster::set_db_cluster_parameter_group_name): <p>The name of the DB cluster parameter group to associate with this DB cluster. If you do not specify a value, then the default DB cluster parameter group for the specified DB engine and version is used.</p>  <p>Constraints:</p>  <ul>   <li> <p>If supplied, must match the name of an existing DB cluster parameter group.</p> </li>  </ul>  <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
    ///   - [`vpc_security_group_ids(Vec<String>)`](crate::client::fluent_builders::CreateDBCluster::vpc_security_group_ids) / [`set_vpc_security_group_ids(Option<Vec<String>>)`](crate::client::fluent_builders::CreateDBCluster::set_vpc_security_group_ids): <p>A list of EC2 VPC security groups to associate with this DB cluster.</p>  <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
    ///   - [`db_subnet_group_name(impl Into<String>)`](crate::client::fluent_builders::CreateDBCluster::db_subnet_group_name) / [`set_db_subnet_group_name(Option<String>)`](crate::client::fluent_builders::CreateDBCluster::set_db_subnet_group_name): <p>A DB subnet group to associate with this DB cluster.</p>  <p>This setting is required to create a Multi-AZ DB cluster.</p>  <p>Constraints: Must match the name of an existing DBSubnetGroup. Must not be default.</p>  <p>Example: <code>mydbsubnetgroup</code> </p>  <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
    ///   - [`engine(impl Into<String>)`](crate::client::fluent_builders::CreateDBCluster::engine) / [`set_engine(Option<String>)`](crate::client::fluent_builders::CreateDBCluster::set_engine): <p>The name of the database engine to be used for this DB cluster.</p>  <p>Valid Values:</p>  <ul>   <li> <p> <code>aurora</code> (for MySQL 5.6-compatible Aurora)</p> </li>   <li> <p> <code>aurora-mysql</code> (for MySQL 5.7-compatible and MySQL 8.0-compatible Aurora)</p> </li>   <li> <p> <code>aurora-postgresql</code> </p> </li>   <li> <p> <code>mysql</code> </p> </li>   <li> <p> <code>postgres</code> </p> </li>  </ul>  <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
    ///   - [`engine_version(impl Into<String>)`](crate::client::fluent_builders::CreateDBCluster::engine_version) / [`set_engine_version(Option<String>)`](crate::client::fluent_builders::CreateDBCluster::set_engine_version): <p>The version number of the database engine to use.</p>  <p>To list all of the available engine versions for MySQL 5.6-compatible Aurora, use the following command:</p>  <p> <code>aws rds describe-db-engine-versions --engine aurora --query "DBEngineVersions[].EngineVersion"</code> </p>  <p>To list all of the available engine versions for MySQL 5.7-compatible and MySQL 8.0-compatible Aurora, use the following command:</p>  <p> <code>aws rds describe-db-engine-versions --engine aurora-mysql --query "DBEngineVersions[].EngineVersion"</code> </p>  <p>To list all of the available engine versions for Aurora PostgreSQL, use the following command:</p>  <p> <code>aws rds describe-db-engine-versions --engine aurora-postgresql --query "DBEngineVersions[].EngineVersion"</code> </p>  <p>To list all of the available engine versions for RDS for MySQL, use the following command:</p>  <p> <code>aws rds describe-db-engine-versions --engine mysql --query "DBEngineVersions[].EngineVersion"</code> </p>  <p>To list all of the available engine versions for RDS for PostgreSQL, use the following command:</p>  <p> <code>aws rds describe-db-engine-versions --engine postgres --query "DBEngineVersions[].EngineVersion"</code> </p>  <p> <b>Aurora MySQL</b> </p>  <p>For information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraMySQL.Updates.html">MySQL on Amazon RDS Versions</a> in the <i>Amazon Aurora User Guide</i>.</p>  <p> <b>Aurora PostgreSQL</b> </p>  <p>For information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraPostgreSQL.Updates.20180305.html">Amazon Aurora PostgreSQL releases and engine versions</a> in the <i>Amazon Aurora User Guide</i>.</p>  <p> <b>MySQL</b> </p>  <p>For information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_MySQL.html#MySQL.Concepts.VersionMgmt">MySQL on Amazon RDS Versions</a> in the <i>Amazon RDS User Guide</i>.</p>  <p> <b>PostgreSQL</b> </p>  <p>For information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_PostgreSQL.html#PostgreSQL.Concepts">Amazon RDS for PostgreSQL versions and extensions</a> in the <i>Amazon RDS User Guide</i>.</p>  <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
    ///   - [`port(i32)`](crate::client::fluent_builders::CreateDBCluster::port) / [`set_port(Option<i32>)`](crate::client::fluent_builders::CreateDBCluster::set_port): <p>The port number on which the instances in the DB cluster accept connections.</p>  <p> <b>RDS for MySQL and Aurora MySQL</b> </p>  <p>Default: <code>3306</code> </p>  <p>Valid values: <code>1150-65535</code> </p>  <p> <b>RDS for PostgreSQL and Aurora PostgreSQL</b> </p>  <p>Default: <code>5432</code> </p>  <p>Valid values: <code>1150-65535</code> </p>  <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
    ///   - [`master_username(impl Into<String>)`](crate::client::fluent_builders::CreateDBCluster::master_username) / [`set_master_username(Option<String>)`](crate::client::fluent_builders::CreateDBCluster::set_master_username): <p>The name of the master user for the DB cluster.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must be 1 to 16 letters or numbers.</p> </li>   <li> <p>First character must be a letter.</p> </li>   <li> <p>Can't be a reserved word for the chosen database engine.</p> </li>  </ul>  <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
    ///   - [`master_user_password(impl Into<String>)`](crate::client::fluent_builders::CreateDBCluster::master_user_password) / [`set_master_user_password(Option<String>)`](crate::client::fluent_builders::CreateDBCluster::set_master_user_password): <p>The password for the master database user. This password can contain any printable ASCII character except "/", """, or "@".</p>  <p>Constraints: Must contain from 8 to 41 characters.</p>  <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
    ///   - [`option_group_name(impl Into<String>)`](crate::client::fluent_builders::CreateDBCluster::option_group_name) / [`set_option_group_name(Option<String>)`](crate::client::fluent_builders::CreateDBCluster::set_option_group_name): <p>A value that indicates that the DB cluster should be associated with the specified option group.</p>  <p>DB clusters are associated with a default option group that can't be modified.</p>
    ///   - [`preferred_backup_window(impl Into<String>)`](crate::client::fluent_builders::CreateDBCluster::preferred_backup_window) / [`set_preferred_backup_window(Option<String>)`](crate::client::fluent_builders::CreateDBCluster::set_preferred_backup_window): <p>The daily time range during which automated backups are created if automated backups are enabled using the <code>BackupRetentionPeriod</code> parameter.</p>  <p>The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Web Services Region. To view the time blocks available, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.Backups.BackupWindow"> Backup window</a> in the <i>Amazon Aurora User Guide</i>.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must be in the format <code>hh24:mi-hh24:mi</code>.</p> </li>   <li> <p>Must be in Universal Coordinated Time (UTC).</p> </li>   <li> <p>Must not conflict with the preferred maintenance window.</p> </li>   <li> <p>Must be at least 30 minutes.</p> </li>  </ul>  <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
    ///   - [`preferred_maintenance_window(impl Into<String>)`](crate::client::fluent_builders::CreateDBCluster::preferred_maintenance_window) / [`set_preferred_maintenance_window(Option<String>)`](crate::client::fluent_builders::CreateDBCluster::set_preferred_maintenance_window): <p>The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).</p>  <p>Format: <code>ddd:hh24:mi-ddd:hh24:mi</code> </p>  <p>The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Web Services Region, occurring on a random day of the week. To see the time blocks available, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow.Aurora"> Adjusting the Preferred DB Cluster Maintenance Window</a> in the <i>Amazon Aurora User Guide</i>.</p>  <p>Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.</p>  <p>Constraints: Minimum 30-minute window.</p>  <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
    ///   - [`replication_source_identifier(impl Into<String>)`](crate::client::fluent_builders::CreateDBCluster::replication_source_identifier) / [`set_replication_source_identifier(Option<String>)`](crate::client::fluent_builders::CreateDBCluster::set_replication_source_identifier): <p>The Amazon Resource Name (ARN) of the source DB instance or DB cluster if this DB cluster is created as a read replica.</p>  <p>Valid for: Aurora DB clusters only</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateDBCluster::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateDBCluster::set_tags): <p>Tags to assign to the DB cluster.</p>  <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
    ///   - [`storage_encrypted(bool)`](crate::client::fluent_builders::CreateDBCluster::storage_encrypted) / [`set_storage_encrypted(Option<bool>)`](crate::client::fluent_builders::CreateDBCluster::set_storage_encrypted): <p>A value that indicates whether the DB cluster is encrypted.</p>  <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
    ///   - [`kms_key_id(impl Into<String>)`](crate::client::fluent_builders::CreateDBCluster::kms_key_id) / [`set_kms_key_id(Option<String>)`](crate::client::fluent_builders::CreateDBCluster::set_kms_key_id): <p>The Amazon Web Services KMS key identifier for an encrypted DB cluster.</p>  <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key. To use a KMS key in a different Amazon Web Services account, specify the key ARN or alias ARN.</p>  <p>When a KMS key isn't specified in <code>KmsKeyId</code>:</p>  <ul>   <li> <p>If <code>ReplicationSourceIdentifier</code> identifies an encrypted source, then Amazon RDS will use the KMS key used to encrypt the source. Otherwise, Amazon RDS will use your default KMS key.</p> </li>   <li> <p>If the <code>StorageEncrypted</code> parameter is enabled and <code>ReplicationSourceIdentifier</code> isn't specified, then Amazon RDS will use your default KMS key.</p> </li>  </ul>  <p>There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account has a different default KMS key for each Amazon Web Services Region.</p>  <p>If you create a read replica of an encrypted DB cluster in another Amazon Web Services Region, you must set <code>KmsKeyId</code> to a KMS key identifier that is valid in the destination Amazon Web Services Region. This KMS key is used to encrypt the read replica in that Amazon Web Services Region.</p>  <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
    ///   - [`pre_signed_url(impl Into<String>)`](crate::client::fluent_builders::CreateDBCluster::pre_signed_url) / [`set_pre_signed_url(Option<String>)`](crate::client::fluent_builders::CreateDBCluster::set_pre_signed_url): <p>A URL that contains a Signature Version 4 signed request for the <code>CreateDBCluster</code> action to be called in the source Amazon Web Services Region where the DB cluster is replicated from. Specify <code>PreSignedUrl</code> only when you are performing cross-Region replication from an encrypted DB cluster.</p>  <p>The pre-signed URL must be a valid request for the <code>CreateDBCluster</code> API action that can be executed in the source Amazon Web Services Region that contains the encrypted DB cluster to be copied.</p>  <p>The pre-signed URL request must contain the following parameter values:</p>  <ul>   <li> <p> <code>KmsKeyId</code> - The Amazon Web Services KMS key identifier for the KMS key to use to encrypt the copy of the DB cluster in the destination Amazon Web Services Region. This should refer to the same KMS key for both the <code>CreateDBCluster</code> action that is called in the destination Amazon Web Services Region, and the action contained in the pre-signed URL.</p> </li>   <li> <p> <code>DestinationRegion</code> - The name of the Amazon Web Services Region that Aurora read replica will be created in.</p> </li>   <li> <p> <code>ReplicationSourceIdentifier</code> - The DB cluster identifier for the encrypted DB cluster to be copied. This identifier must be in the Amazon Resource Name (ARN) format for the source Amazon Web Services Region. For example, if you are copying an encrypted DB cluster from the us-west-2 Amazon Web Services Region, then your <code>ReplicationSourceIdentifier</code> would look like Example: <code>arn:aws:rds:us-west-2:123456789012:cluster:aurora-cluster1</code>.</p> </li>  </ul>  <p>To learn how to generate a Signature Version 4 signed request, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html"> Authenticating Requests: Using Query Parameters (Amazon Web Services Signature Version 4)</a> and <a href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html"> Signature Version 4 Signing Process</a>.</p> <note>   <p>If you are using an Amazon Web Services SDK tool or the CLI, you can specify <code>SourceRegion</code> (or <code>--source-region</code> for the CLI) instead of specifying <code>PreSignedUrl</code> manually. Specifying <code>SourceRegion</code> autogenerates a pre-signed URL that is a valid request for the operation that can be executed in the source Amazon Web Services Region.</p>  </note>  <p>Valid for: Aurora DB clusters only</p>
    ///   - [`enable_iam_database_authentication(bool)`](crate::client::fluent_builders::CreateDBCluster::enable_iam_database_authentication) / [`set_enable_iam_database_authentication(Option<bool>)`](crate::client::fluent_builders::CreateDBCluster::set_enable_iam_database_authentication): <p>A value that indicates whether to enable mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts. By default, mapping isn't enabled.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.IAMDBAuth.html"> IAM Database Authentication</a> in the <i>Amazon Aurora User Guide.</i>.</p>  <p>Valid for: Aurora DB clusters only</p>
    ///   - [`backtrack_window(i64)`](crate::client::fluent_builders::CreateDBCluster::backtrack_window) / [`set_backtrack_window(Option<i64>)`](crate::client::fluent_builders::CreateDBCluster::set_backtrack_window): <p>The target backtrack window, in seconds. To disable backtracking, set this value to 0.</p>  <p>Default: 0</p>  <p>Constraints:</p>  <ul>   <li> <p>If specified, this value must be set to a number from 0 to 259,200 (72 hours).</p> </li>  </ul>  <p>Valid for: Aurora MySQL DB clusters only</p>
    ///   - [`enable_cloudwatch_logs_exports(Vec<String>)`](crate::client::fluent_builders::CreateDBCluster::enable_cloudwatch_logs_exports) / [`set_enable_cloudwatch_logs_exports(Option<Vec<String>>)`](crate::client::fluent_builders::CreateDBCluster::set_enable_cloudwatch_logs_exports): <p>The list of log types that need to be enabled for exporting to CloudWatch Logs. The values in the list depend on the DB engine being used.</p>  <p> <b>RDS for MySQL</b> </p>  <p>Possible values are <code>error</code>, <code>general</code>, and <code>slowquery</code>.</p>  <p> <b>RDS for PostgreSQL</b> </p>  <p>Possible values are <code>postgresql</code> and <code>upgrade</code>.</p>  <p> <b>Aurora MySQL</b> </p>  <p>Possible values are <code>audit</code>, <code>error</code>, <code>general</code>, and <code>slowquery</code>.</p>  <p> <b>Aurora PostgreSQL</b> </p>  <p>Possible value is <code>postgresql</code>.</p>  <p>For more information about exporting CloudWatch Logs for Amazon RDS, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch">Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon RDS User Guide</i>.</p>  <p>For more information about exporting CloudWatch Logs for Amazon Aurora, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch">Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon Aurora User Guide</i>.</p>  <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
    ///   - [`engine_mode(impl Into<String>)`](crate::client::fluent_builders::CreateDBCluster::engine_mode) / [`set_engine_mode(Option<String>)`](crate::client::fluent_builders::CreateDBCluster::set_engine_mode): <p>The DB engine mode of the DB cluster, either <code>provisioned</code>, <code>serverless</code>, <code>parallelquery</code>, <code>global</code>, or <code>multimaster</code>.</p>  <p>The <code>parallelquery</code> engine mode isn't required for Aurora MySQL version 1.23 and higher 1.x versions, and version 2.09 and higher 2.x versions.</p>  <p>The <code>global</code> engine mode isn't required for Aurora MySQL version 1.22 and higher 1.x versions, and <code>global</code> engine mode isn't required for any 2.x versions.</p>  <p>The <code>multimaster</code> engine mode only applies for DB clusters created with Aurora MySQL version 5.6.10a.</p>  <p>For Aurora PostgreSQL, the <code>global</code> engine mode isn't required, and both the <code>parallelquery</code> and the <code>multimaster</code> engine modes currently aren't supported.</p>  <p>Limitations and requirements apply to some DB engine modes. For more information, see the following sections in the <i>Amazon Aurora User Guide</i>:</p>  <ul>   <li> <p> <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.html#aurora-serverless.limitations"> Limitations of Aurora Serverless v1</a> </p> </li>   <li> <p> <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-mysql-parallel-query.html#aurora-mysql-parallel-query-limitations"> Limitations of Parallel Query</a> </p> </li>   <li> <p> <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-global-database.html#aurora-global-database.limitations"> Limitations of Aurora Global Databases</a> </p> </li>   <li> <p> <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-multi-master.html#aurora-multi-master-limitations"> Limitations of Multi-Master Clusters</a> </p> </li>  </ul>  <p>Valid for: Aurora DB clusters only</p>
    ///   - [`scaling_configuration(ScalingConfiguration)`](crate::client::fluent_builders::CreateDBCluster::scaling_configuration) / [`set_scaling_configuration(Option<ScalingConfiguration>)`](crate::client::fluent_builders::CreateDBCluster::set_scaling_configuration): <p>For DB clusters in <code>serverless</code> DB engine mode, the scaling properties of the DB cluster.</p>  <p>Valid for: Aurora DB clusters only</p>
    ///   - [`deletion_protection(bool)`](crate::client::fluent_builders::CreateDBCluster::deletion_protection) / [`set_deletion_protection(Option<bool>)`](crate::client::fluent_builders::CreateDBCluster::set_deletion_protection): <p>A value that indicates whether the DB cluster has deletion protection enabled. The database can't be deleted when deletion protection is enabled. By default, deletion protection isn't enabled.</p>  <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
    ///   - [`global_cluster_identifier(impl Into<String>)`](crate::client::fluent_builders::CreateDBCluster::global_cluster_identifier) / [`set_global_cluster_identifier(Option<String>)`](crate::client::fluent_builders::CreateDBCluster::set_global_cluster_identifier): <p>The global cluster ID of an Aurora cluster that becomes the primary cluster in the new global database cluster.</p>  <p>Valid for: Aurora DB clusters only</p>
    ///   - [`enable_http_endpoint(bool)`](crate::client::fluent_builders::CreateDBCluster::enable_http_endpoint) / [`set_enable_http_endpoint(Option<bool>)`](crate::client::fluent_builders::CreateDBCluster::set_enable_http_endpoint): <p>A value that indicates whether to enable the HTTP endpoint for an Aurora Serverless v1 DB cluster. By default, the HTTP endpoint is disabled.</p>  <p>When enabled, the HTTP endpoint provides a connectionless web service API for running SQL queries on the Aurora Serverless v1 DB cluster. You can also query your database from inside the RDS console with the query editor.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/data-api.html">Using the Data API for Aurora Serverless v1</a> in the <i>Amazon Aurora User Guide</i>.</p>  <p>Valid for: Aurora DB clusters only</p>
    ///   - [`copy_tags_to_snapshot(bool)`](crate::client::fluent_builders::CreateDBCluster::copy_tags_to_snapshot) / [`set_copy_tags_to_snapshot(Option<bool>)`](crate::client::fluent_builders::CreateDBCluster::set_copy_tags_to_snapshot): <p>A value that indicates whether to copy all tags from the DB cluster to snapshots of the DB cluster. The default is not to copy them.</p>  <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
    ///   - [`domain(impl Into<String>)`](crate::client::fluent_builders::CreateDBCluster::domain) / [`set_domain(Option<String>)`](crate::client::fluent_builders::CreateDBCluster::set_domain): <p>The Active Directory directory ID to create the DB cluster in.</p>  <p>For Amazon Aurora DB clusters, Amazon RDS can use Kerberos authentication to authenticate users that connect to the DB cluster.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/kerberos-authentication.html">Kerberos authentication</a> in the <i>Amazon Aurora User Guide</i>.</p>  <p>Valid for: Aurora DB clusters only</p>
    ///   - [`domain_iam_role_name(impl Into<String>)`](crate::client::fluent_builders::CreateDBCluster::domain_iam_role_name) / [`set_domain_iam_role_name(Option<String>)`](crate::client::fluent_builders::CreateDBCluster::set_domain_iam_role_name): <p>Specify the name of the IAM role to be used when making API calls to the Directory Service.</p>  <p>Valid for: Aurora DB clusters only</p>
    ///   - [`enable_global_write_forwarding(bool)`](crate::client::fluent_builders::CreateDBCluster::enable_global_write_forwarding) / [`set_enable_global_write_forwarding(Option<bool>)`](crate::client::fluent_builders::CreateDBCluster::set_enable_global_write_forwarding): <p>A value that indicates whether to enable this DB cluster to forward write operations to the primary cluster of an Aurora global database (<code>GlobalCluster</code>). By default, write operations are not allowed on Aurora DB clusters that are secondary clusters in an Aurora global database.</p>  <p>You can set this value only on Aurora DB clusters that are members of an Aurora global database. With this parameter enabled, a secondary cluster can forward writes to the current primary cluster and the resulting changes are replicated back to this cluster. For the primary DB cluster of an Aurora global database, this value is used immediately if the primary is demoted by the <code>FailoverGlobalCluster</code> API operation, but it does nothing until then.</p>  <p>Valid for: Aurora DB clusters only</p>
    ///   - [`db_cluster_instance_class(impl Into<String>)`](crate::client::fluent_builders::CreateDBCluster::db_cluster_instance_class) / [`set_db_cluster_instance_class(Option<String>)`](crate::client::fluent_builders::CreateDBCluster::set_db_cluster_instance_class): <p>The compute and memory capacity of each DB instance in the Multi-AZ DB cluster, for example db.m6g.xlarge. Not all DB instance classes are available in all Amazon Web Services Regions, or for all database engines.</p>  <p>For the full list of DB instance classes and availability for your engine, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html">DB instance class</a> in the <i>Amazon RDS User Guide</i>.</p>  <p>This setting is required to create a Multi-AZ DB cluster.</p>  <p>Valid for: Multi-AZ DB clusters only</p>
    ///   - [`allocated_storage(i32)`](crate::client::fluent_builders::CreateDBCluster::allocated_storage) / [`set_allocated_storage(Option<i32>)`](crate::client::fluent_builders::CreateDBCluster::set_allocated_storage): <p>The amount of storage in gibibytes (GiB) to allocate to each DB instance in the Multi-AZ DB cluster.</p>  <p>This setting is required to create a Multi-AZ DB cluster.</p>  <p>Valid for: Multi-AZ DB clusters only</p>
    ///   - [`storage_type(impl Into<String>)`](crate::client::fluent_builders::CreateDBCluster::storage_type) / [`set_storage_type(Option<String>)`](crate::client::fluent_builders::CreateDBCluster::set_storage_type): <p>Specifies the storage type to be associated with the DB cluster.</p>  <p>This setting is required to create a Multi-AZ DB cluster.</p>  <p>Valid values: <code>io1</code> </p>  <p>When specified, a value for the <code>Iops</code> parameter is required.</p>  <p>Default: <code>io1</code> </p>  <p>Valid for: Multi-AZ DB clusters only</p>
    ///   - [`iops(i32)`](crate::client::fluent_builders::CreateDBCluster::iops) / [`set_iops(Option<i32>)`](crate::client::fluent_builders::CreateDBCluster::set_iops): <p>The amount of Provisioned IOPS (input/output operations per second) to be initially allocated for each DB instance in the Multi-AZ DB cluster.</p>  <p>For information about valid <code>Iops</code> values, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#USER_PIOPS">Amazon RDS Provisioned IOPS storage to improve performance</a> in the <i>Amazon RDS User Guide</i>.</p>  <p>This setting is required to create a Multi-AZ DB cluster.</p>  <p>Constraints: Must be a multiple between .5 and 50 of the storage amount for the DB cluster.</p>  <p>Valid for: Multi-AZ DB clusters only</p>
    ///   - [`publicly_accessible(bool)`](crate::client::fluent_builders::CreateDBCluster::publicly_accessible) / [`set_publicly_accessible(Option<bool>)`](crate::client::fluent_builders::CreateDBCluster::set_publicly_accessible): <p>A value that indicates whether the DB cluster is publicly accessible.</p>  <p>When the DB cluster is publicly accessible, its Domain Name System (DNS) endpoint resolves to the private IP address from within the DB cluster's virtual private cloud (VPC). It resolves to the public IP address from outside of the DB cluster's VPC. Access to the DB cluster is ultimately controlled by the security group it uses. That public access isn't permitted if the security group assigned to the DB cluster doesn't permit it.</p>  <p>When the DB cluster isn't publicly accessible, it is an internal DB cluster with a DNS name that resolves to a private IP address.</p>  <p>Default: The default behavior varies depending on whether <code>DBSubnetGroupName</code> is specified.</p>  <p>If <code>DBSubnetGroupName</code> isn't specified, and <code>PubliclyAccessible</code> isn't specified, the following applies:</p>  <ul>   <li> <p>If the default VPC in the target Region doesn’t have an internet gateway attached to it, the DB cluster is private.</p> </li>   <li> <p>If the default VPC in the target Region has an internet gateway attached to it, the DB cluster is public.</p> </li>  </ul>  <p>If <code>DBSubnetGroupName</code> is specified, and <code>PubliclyAccessible</code> isn't specified, the following applies:</p>  <ul>   <li> <p>If the subnets are part of a VPC that doesn’t have an internet gateway attached to it, the DB cluster is private.</p> </li>   <li> <p>If the subnets are part of a VPC that has an internet gateway attached to it, the DB cluster is public.</p> </li>  </ul>  <p>Valid for: Multi-AZ DB clusters only</p>
    ///   - [`auto_minor_version_upgrade(bool)`](crate::client::fluent_builders::CreateDBCluster::auto_minor_version_upgrade) / [`set_auto_minor_version_upgrade(Option<bool>)`](crate::client::fluent_builders::CreateDBCluster::set_auto_minor_version_upgrade): <p>A value that indicates whether minor engine upgrades are applied automatically to the DB cluster during the maintenance window. By default, minor engine upgrades are applied automatically.</p>  <p>Valid for: Multi-AZ DB clusters only</p>
    ///   - [`monitoring_interval(i32)`](crate::client::fluent_builders::CreateDBCluster::monitoring_interval) / [`set_monitoring_interval(Option<i32>)`](crate::client::fluent_builders::CreateDBCluster::set_monitoring_interval): <p>The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB cluster. To turn off collecting Enhanced Monitoring metrics, specify 0. The default is 0.</p>  <p>If <code>MonitoringRoleArn</code> is specified, also set <code>MonitoringInterval</code> to a value other than 0.</p>  <p>Valid Values: <code>0, 1, 5, 10, 15, 30, 60</code> </p>  <p>Valid for: Multi-AZ DB clusters only</p>
    ///   - [`monitoring_role_arn(impl Into<String>)`](crate::client::fluent_builders::CreateDBCluster::monitoring_role_arn) / [`set_monitoring_role_arn(Option<String>)`](crate::client::fluent_builders::CreateDBCluster::set_monitoring_role_arn): <p>The Amazon Resource Name (ARN) for the IAM role that permits RDS to send Enhanced Monitoring metrics to Amazon CloudWatch Logs. An example is <code>arn:aws:iam:123456789012:role/emaccess</code>. For information on creating a monitoring role, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.OS.html#USER_Monitoring.OS.Enabling">Setting up and enabling Enhanced Monitoring</a> in the <i>Amazon RDS User Guide</i>.</p>  <p>If <code>MonitoringInterval</code> is set to a value other than 0, supply a <code>MonitoringRoleArn</code> value.</p>  <p>Valid for: Multi-AZ DB clusters only</p>
    ///   - [`enable_performance_insights(bool)`](crate::client::fluent_builders::CreateDBCluster::enable_performance_insights) / [`set_enable_performance_insights(Option<bool>)`](crate::client::fluent_builders::CreateDBCluster::set_enable_performance_insights): <p>A value that indicates whether to turn on Performance Insights for the DB cluster.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html"> Using Amazon Performance Insights</a> in the <i>Amazon RDS User Guide</i>.</p>  <p>Valid for: Multi-AZ DB clusters only</p>
    ///   - [`performance_insights_kms_key_id(impl Into<String>)`](crate::client::fluent_builders::CreateDBCluster::performance_insights_kms_key_id) / [`set_performance_insights_kms_key_id(Option<String>)`](crate::client::fluent_builders::CreateDBCluster::set_performance_insights_kms_key_id): <p>The Amazon Web Services KMS key identifier for encryption of Performance Insights data.</p>  <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.</p>  <p>If you don't specify a value for <code>PerformanceInsightsKMSKeyId</code>, then Amazon RDS uses your default KMS key. There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account has a different default KMS key for each Amazon Web Services Region.</p>  <p>Valid for: Multi-AZ DB clusters only</p>
    ///   - [`performance_insights_retention_period(i32)`](crate::client::fluent_builders::CreateDBCluster::performance_insights_retention_period) / [`set_performance_insights_retention_period(Option<i32>)`](crate::client::fluent_builders::CreateDBCluster::set_performance_insights_retention_period): <p>The amount of time, in days, to retain Performance Insights data. Valid values are 7 or 731 (2 years).</p>  <p>Valid for: Multi-AZ DB clusters only</p>
    ///   - [`serverless_v2_scaling_configuration(ServerlessV2ScalingConfiguration)`](crate::client::fluent_builders::CreateDBCluster::serverless_v2_scaling_configuration) / [`set_serverless_v2_scaling_configuration(Option<ServerlessV2ScalingConfiguration>)`](crate::client::fluent_builders::CreateDBCluster::set_serverless_v2_scaling_configuration): <p>Contains the scaling configuration of an Aurora Serverless v2 DB cluster.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless-v2.html">Using Amazon Aurora Serverless v2</a> in the <i>Amazon Aurora User Guide</i>.</p>
    /// - On success, responds with [`CreateDbClusterOutput`](crate::output::CreateDbClusterOutput) with field(s):
    ///   - [`db_cluster(Option<DbCluster>)`](crate::output::CreateDbClusterOutput::db_cluster): <p>Contains the details of an Amazon Aurora DB cluster or Multi-AZ DB cluster.</p>  <p>For an Amazon Aurora DB cluster, this data type is used as a response element in the operations <code>CreateDBCluster</code>, <code>DeleteDBCluster</code>, <code>DescribeDBClusters</code>, <code>FailoverDBCluster</code>, <code>ModifyDBCluster</code>, <code>PromoteReadReplicaDBCluster</code>, <code>RestoreDBClusterFromS3</code>, <code>RestoreDBClusterFromSnapshot</code>, <code>RestoreDBClusterToPointInTime</code>, <code>StartDBCluster</code>, and <code>StopDBCluster</code>.</p>  <p>For a Multi-AZ DB cluster, this data type is used as a response element in the operations <code>CreateDBCluster</code>, <code>DeleteDBCluster</code>, <code>DescribeDBClusters</code>, <code>FailoverDBCluster</code>, <code>ModifyDBCluster</code>, <code>RebootDBCluster</code>, <code>RestoreDBClusterFromSnapshot</code>, and <code>RestoreDBClusterToPointInTime</code>.</p>  <p>For more information on Amazon Aurora DB clusters, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon Aurora?</a> in the <i>Amazon Aurora User Guide.</i> </p>  <p>For more information on Multi-AZ DB clusters, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ deployments with two readable standby DB instances</a> in the <i>Amazon RDS User Guide.</i> </p>
    /// - On failure, responds with [`SdkError<CreateDBClusterError>`](crate::error::CreateDBClusterError)
    pub fn create_db_cluster(&self) -> fluent_builders::CreateDBCluster {
        fluent_builders::CreateDBCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateDBClusterEndpoint`](crate::client::fluent_builders::CreateDBClusterEndpoint) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_cluster_identifier(impl Into<String>)`](crate::client::fluent_builders::CreateDBClusterEndpoint::db_cluster_identifier) / [`set_db_cluster_identifier(Option<String>)`](crate::client::fluent_builders::CreateDBClusterEndpoint::set_db_cluster_identifier): <p>The DB cluster identifier of the DB cluster associated with the endpoint. This parameter is stored as a lowercase string.</p>
    ///   - [`db_cluster_endpoint_identifier(impl Into<String>)`](crate::client::fluent_builders::CreateDBClusterEndpoint::db_cluster_endpoint_identifier) / [`set_db_cluster_endpoint_identifier(Option<String>)`](crate::client::fluent_builders::CreateDBClusterEndpoint::set_db_cluster_endpoint_identifier): <p>The identifier to use for the new endpoint. This parameter is stored as a lowercase string.</p>
    ///   - [`endpoint_type(impl Into<String>)`](crate::client::fluent_builders::CreateDBClusterEndpoint::endpoint_type) / [`set_endpoint_type(Option<String>)`](crate::client::fluent_builders::CreateDBClusterEndpoint::set_endpoint_type): <p>The type of the endpoint, one of: <code>READER</code>, <code>WRITER</code>, <code>ANY</code>.</p>
    ///   - [`static_members(Vec<String>)`](crate::client::fluent_builders::CreateDBClusterEndpoint::static_members) / [`set_static_members(Option<Vec<String>>)`](crate::client::fluent_builders::CreateDBClusterEndpoint::set_static_members): <p>List of DB instance identifiers that are part of the custom endpoint group.</p>
    ///   - [`excluded_members(Vec<String>)`](crate::client::fluent_builders::CreateDBClusterEndpoint::excluded_members) / [`set_excluded_members(Option<Vec<String>>)`](crate::client::fluent_builders::CreateDBClusterEndpoint::set_excluded_members): <p>List of DB instance identifiers that aren't part of the custom endpoint group. All other eligible instances are reachable through the custom endpoint. This parameter is relevant only if the list of static members is empty.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateDBClusterEndpoint::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateDBClusterEndpoint::set_tags): <p>The tags to be assigned to the Amazon RDS resource.</p>
    /// - On success, responds with [`CreateDbClusterEndpointOutput`](crate::output::CreateDbClusterEndpointOutput) with field(s):
    ///   - [`db_cluster_endpoint_identifier(Option<String>)`](crate::output::CreateDbClusterEndpointOutput::db_cluster_endpoint_identifier): <p>The identifier associated with the endpoint. This parameter is stored as a lowercase string.</p>
    ///   - [`db_cluster_identifier(Option<String>)`](crate::output::CreateDbClusterEndpointOutput::db_cluster_identifier): <p>The DB cluster identifier of the DB cluster associated with the endpoint. This parameter is stored as a lowercase string.</p>
    ///   - [`db_cluster_endpoint_resource_identifier(Option<String>)`](crate::output::CreateDbClusterEndpointOutput::db_cluster_endpoint_resource_identifier): <p>A unique system-generated identifier for an endpoint. It remains the same for the whole life of the endpoint.</p>
    ///   - [`endpoint(Option<String>)`](crate::output::CreateDbClusterEndpointOutput::endpoint): <p>The DNS address of the endpoint.</p>
    ///   - [`status(Option<String>)`](crate::output::CreateDbClusterEndpointOutput::status): <p>The current status of the endpoint. One of: <code>creating</code>, <code>available</code>, <code>deleting</code>, <code>inactive</code>, <code>modifying</code>. The <code>inactive</code> state applies to an endpoint that can't be used for a certain kind of cluster, such as a <code>writer</code> endpoint for a read-only secondary cluster in a global database.</p>
    ///   - [`endpoint_type(Option<String>)`](crate::output::CreateDbClusterEndpointOutput::endpoint_type): <p>The type of the endpoint. One of: <code>READER</code>, <code>WRITER</code>, <code>CUSTOM</code>.</p>
    ///   - [`custom_endpoint_type(Option<String>)`](crate::output::CreateDbClusterEndpointOutput::custom_endpoint_type): <p>The type associated with a custom endpoint. One of: <code>READER</code>, <code>WRITER</code>, <code>ANY</code>.</p>
    ///   - [`static_members(Option<Vec<String>>)`](crate::output::CreateDbClusterEndpointOutput::static_members): <p>List of DB instance identifiers that are part of the custom endpoint group.</p>
    ///   - [`excluded_members(Option<Vec<String>>)`](crate::output::CreateDbClusterEndpointOutput::excluded_members): <p>List of DB instance identifiers that aren't part of the custom endpoint group. All other eligible instances are reachable through the custom endpoint. Only relevant if the list of static members is empty.</p>
    ///   - [`db_cluster_endpoint_arn(Option<String>)`](crate::output::CreateDbClusterEndpointOutput::db_cluster_endpoint_arn): <p>The Amazon Resource Name (ARN) for the endpoint.</p>
    /// - On failure, responds with [`SdkError<CreateDBClusterEndpointError>`](crate::error::CreateDBClusterEndpointError)
    pub fn create_db_cluster_endpoint(&self) -> fluent_builders::CreateDBClusterEndpoint {
        fluent_builders::CreateDBClusterEndpoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateDBClusterParameterGroup`](crate::client::fluent_builders::CreateDBClusterParameterGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_cluster_parameter_group_name(impl Into<String>)`](crate::client::fluent_builders::CreateDBClusterParameterGroup::db_cluster_parameter_group_name) / [`set_db_cluster_parameter_group_name(Option<String>)`](crate::client::fluent_builders::CreateDBClusterParameterGroup::set_db_cluster_parameter_group_name): <p>The name of the DB cluster parameter group.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must not match the name of an existing DB cluster parameter group.</p> </li>  </ul> <note>   <p>This value is stored as a lowercase string.</p>  </note>
    ///   - [`db_parameter_group_family(impl Into<String>)`](crate::client::fluent_builders::CreateDBClusterParameterGroup::db_parameter_group_family) / [`set_db_parameter_group_family(Option<String>)`](crate::client::fluent_builders::CreateDBClusterParameterGroup::set_db_parameter_group_family): <p>The DB cluster parameter group family name. A DB cluster parameter group can be associated with one and only one DB cluster parameter group family, and can be applied only to a DB cluster running a database engine and engine version compatible with that DB cluster parameter group family.</p>  <p> <b>Aurora MySQL</b> </p>  <p>Example: <code>aurora5.6</code>, <code>aurora-mysql5.7</code>, <code>aurora-mysql8.0</code> </p>  <p> <b>Aurora PostgreSQL</b> </p>  <p>Example: <code>aurora-postgresql9.6</code> </p>  <p> <b>RDS for MySQL</b> </p>  <p>Example: <code>mysql8.0</code> </p>  <p> <b>RDS for PostgreSQL</b> </p>  <p>Example: <code>postgres12</code> </p>  <p>To list all of the available parameter group families for a DB engine, use the following command:</p>  <p> <code>aws rds describe-db-engine-versions --query "DBEngineVersions[].DBParameterGroupFamily" --engine    <engine></engine></code> </p>  <p>For example, to list all of the available parameter group families for the Aurora PostgreSQL DB engine, use the following command:</p>  <p> <code>aws rds describe-db-engine-versions --query "DBEngineVersions[].DBParameterGroupFamily" --engine aurora-postgresql</code> </p> <note>   <p>The output contains duplicates.</p>  </note>  <p>The following are the valid DB engine values:</p>  <ul>   <li> <p> <code>aurora</code> (for MySQL 5.6-compatible Aurora)</p> </li>   <li> <p> <code>aurora-mysql</code> (for MySQL 5.7-compatible and MySQL 8.0-compatible Aurora)</p> </li>   <li> <p> <code>aurora-postgresql</code> </p> </li>   <li> <p> <code>mysql</code> </p> </li>   <li> <p> <code>postgres</code> </p> </li>  </ul>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateDBClusterParameterGroup::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateDBClusterParameterGroup::set_description): <p>The description for the DB cluster parameter group.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateDBClusterParameterGroup::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateDBClusterParameterGroup::set_tags): <p>Tags to assign to the DB cluster parameter group.</p>
    /// - On success, responds with [`CreateDbClusterParameterGroupOutput`](crate::output::CreateDbClusterParameterGroupOutput) with field(s):
    ///   - [`db_cluster_parameter_group(Option<DbClusterParameterGroup>)`](crate::output::CreateDbClusterParameterGroupOutput::db_cluster_parameter_group): <p>Contains the details of an Amazon RDS DB cluster parameter group.</p>  <p>This data type is used as a response element in the <code>DescribeDBClusterParameterGroups</code> action.</p>
    /// - On failure, responds with [`SdkError<CreateDBClusterParameterGroupError>`](crate::error::CreateDBClusterParameterGroupError)
    pub fn create_db_cluster_parameter_group(
        &self,
    ) -> fluent_builders::CreateDBClusterParameterGroup {
        fluent_builders::CreateDBClusterParameterGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateDBClusterSnapshot`](crate::client::fluent_builders::CreateDBClusterSnapshot) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_cluster_snapshot_identifier(impl Into<String>)`](crate::client::fluent_builders::CreateDBClusterSnapshot::db_cluster_snapshot_identifier) / [`set_db_cluster_snapshot_identifier(Option<String>)`](crate::client::fluent_builders::CreateDBClusterSnapshot::set_db_cluster_snapshot_identifier): <p>The identifier of the DB cluster snapshot. This parameter is stored as a lowercase string.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p> </li>   <li> <p>First character must be a letter.</p> </li>   <li> <p>Can't end with a hyphen or contain two consecutive hyphens.</p> </li>  </ul>  <p>Example: <code>my-cluster1-snapshot1</code> </p>
    ///   - [`db_cluster_identifier(impl Into<String>)`](crate::client::fluent_builders::CreateDBClusterSnapshot::db_cluster_identifier) / [`set_db_cluster_identifier(Option<String>)`](crate::client::fluent_builders::CreateDBClusterSnapshot::set_db_cluster_identifier): <p>The identifier of the DB cluster to create a snapshot for. This parameter isn't case-sensitive.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must match the identifier of an existing DBCluster.</p> </li>  </ul>  <p>Example: <code>my-cluster1</code> </p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateDBClusterSnapshot::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateDBClusterSnapshot::set_tags): <p>The tags to be assigned to the DB cluster snapshot.</p>
    /// - On success, responds with [`CreateDbClusterSnapshotOutput`](crate::output::CreateDbClusterSnapshotOutput) with field(s):
    ///   - [`db_cluster_snapshot(Option<DbClusterSnapshot>)`](crate::output::CreateDbClusterSnapshotOutput::db_cluster_snapshot): <p>Contains the details for an Amazon RDS DB cluster snapshot</p>  <p>This data type is used as a response element in the <code>DescribeDBClusterSnapshots</code> action.</p>
    /// - On failure, responds with [`SdkError<CreateDBClusterSnapshotError>`](crate::error::CreateDBClusterSnapshotError)
    pub fn create_db_cluster_snapshot(&self) -> fluent_builders::CreateDBClusterSnapshot {
        fluent_builders::CreateDBClusterSnapshot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateDBInstance`](crate::client::fluent_builders::CreateDBInstance) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_name(impl Into<String>)`](crate::client::fluent_builders::CreateDBInstance::db_name) / [`set_db_name(Option<String>)`](crate::client::fluent_builders::CreateDBInstance::set_db_name): <p>The meaning of this parameter differs according to the database engine you use.</p>  <p> <b>MySQL</b> </p>  <p>The name of the database to create when the DB instance is created. If this parameter isn't specified, no database is created in the DB instance.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must contain 1 to 64 letters or numbers.</p> </li>   <li> <p>Must begin with a letter. Subsequent characters can be letters, underscores, or digits (0-9).</p> </li>   <li> <p>Can't be a word reserved by the specified database engine</p> </li>  </ul>  <p> <b>MariaDB</b> </p>  <p>The name of the database to create when the DB instance is created. If this parameter isn't specified, no database is created in the DB instance.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must contain 1 to 64 letters or numbers.</p> </li>   <li> <p>Must begin with a letter. Subsequent characters can be letters, underscores, or digits (0-9).</p> </li>   <li> <p>Can't be a word reserved by the specified database engine</p> </li>  </ul>  <p> <b>PostgreSQL</b> </p>  <p>The name of the database to create when the DB instance is created. If this parameter isn't specified, a database named <code>postgres</code> is created in the DB instance.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must contain 1 to 63 letters, numbers, or underscores.</p> </li>   <li> <p>Must begin with a letter. Subsequent characters can be letters, underscores, or digits (0-9).</p> </li>   <li> <p>Can't be a word reserved by the specified database engine</p> </li>  </ul>  <p> <b>Oracle</b> </p>  <p>The Oracle System ID (SID) of the created DB instance. If you specify <code>null</code>, the default value <code>ORCL</code> is used. You can't specify the string NULL, or any other reserved word, for <code>DBName</code>.</p>  <p>Default: <code>ORCL</code> </p>  <p>Constraints:</p>  <ul>   <li> <p>Can't be longer than 8 characters</p> </li>  </ul>  <p> <b>Amazon RDS Custom for Oracle</b> </p>  <p>The Oracle System ID (SID) of the created RDS Custom DB instance. If you don't specify a value, the default value is <code>ORCL</code>.</p>  <p>Default: <code>ORCL</code> </p>  <p>Constraints:</p>  <ul>   <li> <p>It must contain 1 to 8 alphanumeric characters.</p> </li>   <li> <p>It must contain a letter.</p> </li>   <li> <p>It can't be a word reserved by the database engine.</p> </li>  </ul>  <p> <b>Amazon RDS Custom for SQL Server</b> </p>  <p>Not applicable. Must be null.</p>  <p> <b>SQL Server</b> </p>  <p>Not applicable. Must be null.</p>  <p> <b>Amazon Aurora MySQL</b> </p>  <p>The name of the database to create when the primary DB instance of the Aurora MySQL DB cluster is created. If this parameter isn't specified for an Aurora MySQL DB cluster, no database is created in the DB cluster.</p>  <p>Constraints:</p>  <ul>   <li> <p>It must contain 1 to 64 alphanumeric characters.</p> </li>   <li> <p>It can't be a word reserved by the database engine.</p> </li>  </ul>  <p> <b>Amazon Aurora PostgreSQL</b> </p>  <p>The name of the database to create when the primary DB instance of the Aurora PostgreSQL DB cluster is created. If this parameter isn't specified for an Aurora PostgreSQL DB cluster, a database named <code>postgres</code> is created in the DB cluster.</p>  <p>Constraints:</p>  <ul>   <li> <p>It must contain 1 to 63 alphanumeric characters.</p> </li>   <li> <p>It must begin with a letter or an underscore. Subsequent characters can be letters, underscores, or digits (0 to 9).</p> </li>   <li> <p>It can't be a word reserved by the database engine.</p> </li>  </ul>
    ///   - [`db_instance_identifier(impl Into<String>)`](crate::client::fluent_builders::CreateDBInstance::db_instance_identifier) / [`set_db_instance_identifier(Option<String>)`](crate::client::fluent_builders::CreateDBInstance::set_db_instance_identifier): <p>The DB instance identifier. This parameter is stored as a lowercase string.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p> </li>   <li> <p>First character must be a letter.</p> </li>   <li> <p>Can't end with a hyphen or contain two consecutive hyphens.</p> </li>  </ul>  <p>Example: <code>mydbinstance</code> </p>
    ///   - [`allocated_storage(i32)`](crate::client::fluent_builders::CreateDBInstance::allocated_storage) / [`set_allocated_storage(Option<i32>)`](crate::client::fluent_builders::CreateDBInstance::set_allocated_storage): <p>The amount of storage in gibibytes (GiB) to allocate for the DB instance.</p>  <p>Type: Integer</p>  <p> <b>Amazon Aurora</b> </p>  <p>Not applicable. Aurora cluster volumes automatically grow as the amount of data in your database increases, though you are only charged for the space that you use in an Aurora cluster volume.</p>  <p> <b>Amazon RDS Custom</b> </p>  <p>Constraints to the amount of storage for each storage type are the following:</p>  <ul>   <li> <p>General Purpose (SSD) storage (gp2): Must be an integer from 40 to 65536 for RDS Custom for Oracle, 16384 for RDS Custom for SQL Server.</p> </li>   <li> <p>Provisioned IOPS storage (io1): Must be an integer from 40 to 65536 for RDS Custom for Oracle, 16384 for RDS Custom for SQL Server.</p> </li>  </ul>  <p> <b>MySQL</b> </p>  <p>Constraints to the amount of storage for each storage type are the following:</p>  <ul>   <li> <p>General Purpose (SSD) storage (gp2): Must be an integer from 20 to 65536.</p> </li>   <li> <p>Provisioned IOPS storage (io1): Must be an integer from 100 to 65536.</p> </li>   <li> <p>Magnetic storage (standard): Must be an integer from 5 to 3072.</p> </li>  </ul>  <p> <b>MariaDB</b> </p>  <p>Constraints to the amount of storage for each storage type are the following:</p>  <ul>   <li> <p>General Purpose (SSD) storage (gp2): Must be an integer from 20 to 65536.</p> </li>   <li> <p>Provisioned IOPS storage (io1): Must be an integer from 100 to 65536.</p> </li>   <li> <p>Magnetic storage (standard): Must be an integer from 5 to 3072.</p> </li>  </ul>  <p> <b>PostgreSQL</b> </p>  <p>Constraints to the amount of storage for each storage type are the following:</p>  <ul>   <li> <p>General Purpose (SSD) storage (gp2): Must be an integer from 20 to 65536.</p> </li>   <li> <p>Provisioned IOPS storage (io1): Must be an integer from 100 to 65536.</p> </li>   <li> <p>Magnetic storage (standard): Must be an integer from 5 to 3072.</p> </li>  </ul>  <p> <b>Oracle</b> </p>  <p>Constraints to the amount of storage for each storage type are the following:</p>  <ul>   <li> <p>General Purpose (SSD) storage (gp2): Must be an integer from 20 to 65536.</p> </li>   <li> <p>Provisioned IOPS storage (io1): Must be an integer from 100 to 65536.</p> </li>   <li> <p>Magnetic storage (standard): Must be an integer from 10 to 3072.</p> </li>  </ul>  <p> <b>SQL Server</b> </p>  <p>Constraints to the amount of storage for each storage type are the following:</p>  <ul>   <li> <p>General Purpose (SSD) storage (gp2):</p>    <ul>     <li> <p>Enterprise and Standard editions: Must be an integer from 20 to 16384.</p> </li>     <li> <p>Web and Express editions: Must be an integer from 20 to 16384.</p> </li>    </ul> </li>   <li> <p>Provisioned IOPS storage (io1):</p>    <ul>     <li> <p>Enterprise and Standard editions: Must be an integer from 100 to 16384.</p> </li>     <li> <p>Web and Express editions: Must be an integer from 100 to 16384.</p> </li>    </ul> </li>   <li> <p>Magnetic storage (standard):</p>    <ul>     <li> <p>Enterprise and Standard editions: Must be an integer from 20 to 1024.</p> </li>     <li> <p>Web and Express editions: Must be an integer from 20 to 1024.</p> </li>    </ul> </li>  </ul>
    ///   - [`db_instance_class(impl Into<String>)`](crate::client::fluent_builders::CreateDBInstance::db_instance_class) / [`set_db_instance_class(Option<String>)`](crate::client::fluent_builders::CreateDBInstance::set_db_instance_class): <p>The compute and memory capacity of the DB instance, for example db.m4.large. Not all DB instance classes are available in all Amazon Web Services Regions, or for all database engines. For the full list of DB instance classes, and availability for your engine, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html">DB Instance Class</a> in the <i>Amazon RDS User Guide</i>.</p>
    ///   - [`engine(impl Into<String>)`](crate::client::fluent_builders::CreateDBInstance::engine) / [`set_engine(Option<String>)`](crate::client::fluent_builders::CreateDBInstance::set_engine): <p>The name of the database engine to be used for this instance.</p>  <p>Not every database engine is available for every Amazon Web Services Region.</p>  <p>Valid Values:</p>  <ul>   <li> <p> <code>aurora</code> (for MySQL 5.6-compatible Aurora)</p> </li>   <li> <p> <code>aurora-mysql</code> (for MySQL 5.7-compatible and MySQL 8.0-compatible Aurora)</p> </li>   <li> <p> <code>aurora-postgresql</code> </p> </li>   <li> <p> <code>custom-oracle-ee (for RDS Custom for Oracle instances)</code> </p> </li>   <li> <p> <code>custom-sqlserver-ee (for RDS Custom for SQL Server instances)</code> </p> </li>   <li> <p> <code>custom-sqlserver-se (for RDS Custom for SQL Server instances)</code> </p> </li>   <li> <p> <code>custom-sqlserver-web (for RDS Custom for SQL Server instances)</code> </p> </li>   <li> <p> <code>mariadb</code> </p> </li>   <li> <p> <code>mysql</code> </p> </li>   <li> <p> <code>oracle-ee</code> </p> </li>   <li> <p> <code>oracle-ee-cdb</code> </p> </li>   <li> <p> <code>oracle-se2</code> </p> </li>   <li> <p> <code>oracle-se2-cdb</code> </p> </li>   <li> <p> <code>postgres</code> </p> </li>   <li> <p> <code>sqlserver-ee</code> </p> </li>   <li> <p> <code>sqlserver-se</code> </p> </li>   <li> <p> <code>sqlserver-ex</code> </p> </li>   <li> <p> <code>sqlserver-web</code> </p> </li>  </ul>
    ///   - [`master_username(impl Into<String>)`](crate::client::fluent_builders::CreateDBInstance::master_username) / [`set_master_username(Option<String>)`](crate::client::fluent_builders::CreateDBInstance::set_master_username): <p>The name for the master user.</p>  <p> <b>Amazon Aurora</b> </p>  <p>Not applicable. The name for the master user is managed by the DB cluster.</p>  <p> <b>Amazon RDS</b> </p>  <p>Constraints:</p>  <ul>   <li> <p>Required.</p> </li>   <li> <p>Must be 1 to 16 letters, numbers, or underscores.</p> </li>   <li> <p>First character must be a letter.</p> </li>   <li> <p>Can't be a reserved word for the chosen database engine.</p> </li>  </ul>
    ///   - [`master_user_password(impl Into<String>)`](crate::client::fluent_builders::CreateDBInstance::master_user_password) / [`set_master_user_password(Option<String>)`](crate::client::fluent_builders::CreateDBInstance::set_master_user_password): <p>The password for the master user. The password can include any printable ASCII character except "/", """, or "@".</p>  <p> <b>Amazon Aurora</b> </p>  <p>Not applicable. The password for the master user is managed by the DB cluster.</p>  <p> <b>MariaDB</b> </p>  <p>Constraints: Must contain from 8 to 41 characters.</p>  <p> <b>Microsoft SQL Server</b> </p>  <p>Constraints: Must contain from 8 to 128 characters.</p>  <p> <b>MySQL</b> </p>  <p>Constraints: Must contain from 8 to 41 characters.</p>  <p> <b>Oracle</b> </p>  <p>Constraints: Must contain from 8 to 30 characters.</p>  <p> <b>PostgreSQL</b> </p>  <p>Constraints: Must contain from 8 to 128 characters.</p>
    ///   - [`db_security_groups(Vec<String>)`](crate::client::fluent_builders::CreateDBInstance::db_security_groups) / [`set_db_security_groups(Option<Vec<String>>)`](crate::client::fluent_builders::CreateDBInstance::set_db_security_groups): <p>A list of DB security groups to associate with this DB instance.</p>  <p>Default: The default DB security group for the database engine.</p>
    ///   - [`vpc_security_group_ids(Vec<String>)`](crate::client::fluent_builders::CreateDBInstance::vpc_security_group_ids) / [`set_vpc_security_group_ids(Option<Vec<String>>)`](crate::client::fluent_builders::CreateDBInstance::set_vpc_security_group_ids): <p>A list of Amazon EC2 VPC security groups to associate with this DB instance.</p>  <p> <b>Amazon Aurora</b> </p>  <p>Not applicable. The associated list of EC2 VPC security groups is managed by the DB cluster.</p>  <p>Default: The default EC2 VPC security group for the DB subnet group's VPC.</p>
    ///   - [`availability_zone(impl Into<String>)`](crate::client::fluent_builders::CreateDBInstance::availability_zone) / [`set_availability_zone(Option<String>)`](crate::client::fluent_builders::CreateDBInstance::set_availability_zone): <p>The Availability Zone (AZ) where the database will be created. For information on Amazon Web Services Regions and Availability Zones, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.RegionsAndAvailabilityZones.html">Regions and Availability Zones</a>.</p>  <p> <b>Amazon Aurora</b> </p>  <p>Each Aurora DB cluster hosts copies of its storage in three separate Availability Zones. Specify one of these Availability Zones. Aurora automatically chooses an appropriate Availability Zone if you don't specify one.</p>  <p>Default: A random, system-chosen Availability Zone in the endpoint's Amazon Web Services Region.</p>  <p>Example: <code>us-east-1d</code> </p>  <p>Constraint: The <code>AvailabilityZone</code> parameter can't be specified if the DB instance is a Multi-AZ deployment. The specified Availability Zone must be in the same Amazon Web Services Region as the current endpoint.</p> <note>   <p>If you're creating a DB instance in an RDS on VMware environment, specify the identifier of the custom Availability Zone to create the DB instance in.</p>   <p>For more information about RDS on VMware, see the <a href="https://docs.aws.amazon.com/AmazonRDS/latest/RDSonVMwareUserGuide/rds-on-vmware.html"> RDS on VMware User Guide.</a> </p>  </note>
    ///   - [`db_subnet_group_name(impl Into<String>)`](crate::client::fluent_builders::CreateDBInstance::db_subnet_group_name) / [`set_db_subnet_group_name(Option<String>)`](crate::client::fluent_builders::CreateDBInstance::set_db_subnet_group_name): <p>A DB subnet group to associate with this DB instance.</p>  <p>Constraints: Must match the name of an existing DBSubnetGroup. Must not be default.</p>  <p>Example: <code>mydbsubnetgroup</code> </p>
    ///   - [`preferred_maintenance_window(impl Into<String>)`](crate::client::fluent_builders::CreateDBInstance::preferred_maintenance_window) / [`set_preferred_maintenance_window(Option<String>)`](crate::client::fluent_builders::CreateDBInstance::set_preferred_maintenance_window): <p>The time range each week during which system maintenance can occur, in Universal Coordinated Time (UTC). For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Maintenance.html#Concepts.DBMaintenance">Amazon RDS Maintenance Window</a>.</p>  <p>Format: <code>ddd:hh24:mi-ddd:hh24:mi</code> </p>  <p>The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Web Services Region, occurring on a random day of the week.</p>  <p>Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.</p>  <p>Constraints: Minimum 30-minute window.</p>
    ///   - [`db_parameter_group_name(impl Into<String>)`](crate::client::fluent_builders::CreateDBInstance::db_parameter_group_name) / [`set_db_parameter_group_name(Option<String>)`](crate::client::fluent_builders::CreateDBInstance::set_db_parameter_group_name): <p>The name of the DB parameter group to associate with this DB instance. If you do not specify a value, then the default DB parameter group for the specified DB engine and version is used.</p>  <p>This setting doesn't apply to RDS Custom.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must be 1 to 255 letters, numbers, or hyphens.</p> </li>   <li> <p>First character must be a letter</p> </li>   <li> <p>Can't end with a hyphen or contain two consecutive hyphens</p> </li>  </ul>
    ///   - [`backup_retention_period(i32)`](crate::client::fluent_builders::CreateDBInstance::backup_retention_period) / [`set_backup_retention_period(Option<i32>)`](crate::client::fluent_builders::CreateDBInstance::set_backup_retention_period): <p>The number of days for which automated backups are retained. Setting this parameter to a positive number enables backups. Setting this parameter to 0 disables automated backups.</p>  <p> <b>Amazon Aurora</b> </p>  <p>Not applicable. The retention period for automated backups is managed by the DB cluster.</p>  <p>Default: 1</p>  <p>Constraints:</p>  <ul>   <li> <p>Must be a value from 0 to 35</p> </li>   <li> <p>Can't be set to 0 if the DB instance is a source to read replicas</p> </li>   <li> <p>Can't be set to 0 or 35 for an RDS Custom for Oracle DB instance</p> </li>  </ul>
    ///   - [`preferred_backup_window(impl Into<String>)`](crate::client::fluent_builders::CreateDBInstance::preferred_backup_window) / [`set_preferred_backup_window(Option<String>)`](crate::client::fluent_builders::CreateDBInstance::set_preferred_backup_window): <p>The daily time range during which automated backups are created if automated backups are enabled, using the <code>BackupRetentionPeriod</code> parameter. The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Web Services Region. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithAutomatedBackups.html#USER_WorkingWithAutomatedBackups.BackupWindow">Backup window</a> in the <i>Amazon RDS User Guide</i>.</p>  <p> <b>Amazon Aurora</b> </p>  <p>Not applicable. The daily time range for creating automated backups is managed by the DB cluster.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must be in the format <code>hh24:mi-hh24:mi</code>.</p> </li>   <li> <p>Must be in Universal Coordinated Time (UTC).</p> </li>   <li> <p>Must not conflict with the preferred maintenance window.</p> </li>   <li> <p>Must be at least 30 minutes.</p> </li>  </ul>
    ///   - [`port(i32)`](crate::client::fluent_builders::CreateDBInstance::port) / [`set_port(Option<i32>)`](crate::client::fluent_builders::CreateDBInstance::set_port): <p>The port number on which the database accepts connections.</p>  <p> <b>MySQL</b> </p>  <p>Default: <code>3306</code> </p>  <p>Valid values: <code>1150-65535</code> </p>  <p>Type: Integer</p>  <p> <b>MariaDB</b> </p>  <p>Default: <code>3306</code> </p>  <p>Valid values: <code>1150-65535</code> </p>  <p>Type: Integer</p>  <p> <b>PostgreSQL</b> </p>  <p>Default: <code>5432</code> </p>  <p>Valid values: <code>1150-65535</code> </p>  <p>Type: Integer</p>  <p> <b>Oracle</b> </p>  <p>Default: <code>1521</code> </p>  <p>Valid values: <code>1150-65535</code> </p>  <p> <b>SQL Server</b> </p>  <p>Default: <code>1433</code> </p>  <p>Valid values: <code>1150-65535</code> except <code>1234</code>, <code>1434</code>, <code>3260</code>, <code>3343</code>, <code>3389</code>, <code>47001</code>, and <code>49152-49156</code>.</p>  <p> <b>Amazon Aurora</b> </p>  <p>Default: <code>3306</code> </p>  <p>Valid values: <code>1150-65535</code> </p>  <p>Type: Integer</p>
    ///   - [`multi_az(bool)`](crate::client::fluent_builders::CreateDBInstance::multi_az) / [`set_multi_az(Option<bool>)`](crate::client::fluent_builders::CreateDBInstance::set_multi_az): <p>A value that indicates whether the DB instance is a Multi-AZ deployment. You can't set the <code>AvailabilityZone</code> parameter if the DB instance is a Multi-AZ deployment.</p>  <p>This setting doesn't apply to RDS Custom.</p>
    ///   - [`engine_version(impl Into<String>)`](crate::client::fluent_builders::CreateDBInstance::engine_version) / [`set_engine_version(Option<String>)`](crate::client::fluent_builders::CreateDBInstance::set_engine_version): <p>The version number of the database engine to use.</p>  <p>For a list of valid engine versions, use the <code>DescribeDBEngineVersions</code> action.</p>  <p>The following are the database engines and links to information about the major and minor versions that are available with Amazon RDS. Not every database engine is available for every Amazon Web Services Region.</p>  <p> <b>Amazon Aurora</b> </p>  <p>Not applicable. The version number of the database engine to be used by the DB instance is managed by the DB cluster.</p>  <p> <b>Amazon RDS Custom for Oracle</b> </p>  <p>A custom engine version (CEV) that you have previously created. This setting is required for RDS Custom for Oracle. The CEV name has the following format: <code>19.<i>customized_string</i> </code>. An example identifier is <code>19.my_cev1</code>. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-creating.html#custom-creating.create"> Creating an RDS Custom for Oracle DB instance</a> in the <i>Amazon RDS User Guide</i>.</p>  <p> <b>Amazon RDS Custom for SQL Server</b> </p>  <p>See <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-reqs-limits.html#custom-reqs-limits.reqsMS">RDS Custom for SQL Server general requirements</a> in the <i>Amazon RDS User Guide</i>.</p>  <p> <b>MariaDB</b> </p>  <p>For information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_MariaDB.html#MariaDB.Concepts.VersionMgmt">MariaDB on Amazon RDS Versions</a> in the <i>Amazon RDS User Guide</i>.</p>  <p> <b>Microsoft SQL Server</b> </p>  <p>For information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_SQLServer.html#SQLServer.Concepts.General.VersionSupport">Microsoft SQL Server Versions on Amazon RDS</a> in the <i>Amazon RDS User Guide</i>.</p>  <p> <b>MySQL</b> </p>  <p>For information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_MySQL.html#MySQL.Concepts.VersionMgmt">MySQL on Amazon RDS Versions</a> in the <i>Amazon RDS User Guide</i>.</p>  <p> <b>Oracle</b> </p>  <p>For information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Appendix.Oracle.PatchComposition.html">Oracle Database Engine Release Notes</a> in the <i>Amazon RDS User Guide</i>.</p>  <p> <b>PostgreSQL</b> </p>  <p>For information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_PostgreSQL.html#PostgreSQL.Concepts">Amazon RDS for PostgreSQL versions and extensions</a> in the <i>Amazon RDS User Guide</i>.</p>
    ///   - [`auto_minor_version_upgrade(bool)`](crate::client::fluent_builders::CreateDBInstance::auto_minor_version_upgrade) / [`set_auto_minor_version_upgrade(Option<bool>)`](crate::client::fluent_builders::CreateDBInstance::set_auto_minor_version_upgrade): <p>A value that indicates whether minor engine upgrades are applied automatically to the DB instance during the maintenance window. By default, minor engine upgrades are applied automatically.</p>  <p>If you create an RDS Custom DB instance, you must set <code>AutoMinorVersionUpgrade</code> to <code>false</code>.</p>
    ///   - [`license_model(impl Into<String>)`](crate::client::fluent_builders::CreateDBInstance::license_model) / [`set_license_model(Option<String>)`](crate::client::fluent_builders::CreateDBInstance::set_license_model): <p>License model information for this DB instance.</p>  <p>Valid values: <code>license-included</code> | <code>bring-your-own-license</code> | <code>general-public-license</code> </p>  <p>This setting doesn't apply to RDS Custom.</p>
    ///   - [`iops(i32)`](crate::client::fluent_builders::CreateDBInstance::iops) / [`set_iops(Option<i32>)`](crate::client::fluent_builders::CreateDBInstance::set_iops): <p>The amount of Provisioned IOPS (input/output operations per second) to be initially allocated for the DB instance. For information about valid <code>Iops</code> values, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#USER_PIOPS">Amazon RDS Provisioned IOPS storage to improve performance</a> in the <i>Amazon RDS User Guide</i>.</p>  <p>Constraints: For MariaDB, MySQL, Oracle, and PostgreSQL DB instances, must be a multiple between .5 and 50 of the storage amount for the DB instance. For SQL Server DB instances, must be a multiple between 1 and 50 of the storage amount for the DB instance.</p>
    ///   - [`option_group_name(impl Into<String>)`](crate::client::fluent_builders::CreateDBInstance::option_group_name) / [`set_option_group_name(Option<String>)`](crate::client::fluent_builders::CreateDBInstance::set_option_group_name): <p>A value that indicates that the DB instance should be associated with the specified option group.</p>  <p>Permanent options, such as the TDE option for Oracle Advanced Security TDE, can't be removed from an option group. Also, that option group can't be removed from a DB instance after it is associated with a DB instance.</p>  <p>This setting doesn't apply to RDS Custom.</p>
    ///   - [`character_set_name(impl Into<String>)`](crate::client::fluent_builders::CreateDBInstance::character_set_name) / [`set_character_set_name(Option<String>)`](crate::client::fluent_builders::CreateDBInstance::set_character_set_name): <p>For supported engines, this value indicates that the DB instance should be associated with the specified <code>CharacterSet</code>.</p>  <p>This setting doesn't apply to RDS Custom. However, if you need to change the character set, you can change it on the database itself.</p>  <p> <b>Amazon Aurora</b> </p>  <p>Not applicable. The character set is managed by the DB cluster. For more information, see <code>CreateDBCluster</code>.</p>
    ///   - [`nchar_character_set_name(impl Into<String>)`](crate::client::fluent_builders::CreateDBInstance::nchar_character_set_name) / [`set_nchar_character_set_name(Option<String>)`](crate::client::fluent_builders::CreateDBInstance::set_nchar_character_set_name): <p>The name of the NCHAR character set for the Oracle DB instance.</p>  <p>This parameter doesn't apply to RDS Custom.</p>
    ///   - [`publicly_accessible(bool)`](crate::client::fluent_builders::CreateDBInstance::publicly_accessible) / [`set_publicly_accessible(Option<bool>)`](crate::client::fluent_builders::CreateDBInstance::set_publicly_accessible): <p>A value that indicates whether the DB instance is publicly accessible.</p>  <p>When the DB instance is publicly accessible, its Domain Name System (DNS) endpoint resolves to the private IP address from within the DB instance's virtual private cloud (VPC). It resolves to the public IP address from outside of the DB instance's VPC. Access to the DB instance is ultimately controlled by the security group it uses. That public access is not permitted if the security group assigned to the DB instance doesn't permit it.</p>  <p>When the DB instance isn't publicly accessible, it is an internal DB instance with a DNS name that resolves to a private IP address.</p>  <p>Default: The default behavior varies depending on whether <code>DBSubnetGroupName</code> is specified.</p>  <p>If <code>DBSubnetGroupName</code> isn't specified, and <code>PubliclyAccessible</code> isn't specified, the following applies:</p>  <ul>   <li> <p>If the default VPC in the target Region doesn’t have an internet gateway attached to it, the DB instance is private.</p> </li>   <li> <p>If the default VPC in the target Region has an internet gateway attached to it, the DB instance is public.</p> </li>  </ul>  <p>If <code>DBSubnetGroupName</code> is specified, and <code>PubliclyAccessible</code> isn't specified, the following applies:</p>  <ul>   <li> <p>If the subnets are part of a VPC that doesn’t have an internet gateway attached to it, the DB instance is private.</p> </li>   <li> <p>If the subnets are part of a VPC that has an internet gateway attached to it, the DB instance is public.</p> </li>  </ul>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateDBInstance::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateDBInstance::set_tags): <p>Tags to assign to the DB instance.</p>
    ///   - [`db_cluster_identifier(impl Into<String>)`](crate::client::fluent_builders::CreateDBInstance::db_cluster_identifier) / [`set_db_cluster_identifier(Option<String>)`](crate::client::fluent_builders::CreateDBInstance::set_db_cluster_identifier): <p>The identifier of the DB cluster that the instance will belong to.</p>  <p>This setting doesn't apply to RDS Custom.</p>
    ///   - [`storage_type(impl Into<String>)`](crate::client::fluent_builders::CreateDBInstance::storage_type) / [`set_storage_type(Option<String>)`](crate::client::fluent_builders::CreateDBInstance::set_storage_type): <p>Specifies the storage type to be associated with the DB instance.</p>  <p>Valid values: <code>standard | gp2 | io1</code> </p>  <p>If you specify <code>io1</code>, you must also include a value for the <code>Iops</code> parameter.</p>  <p>Default: <code>io1</code> if the <code>Iops</code> parameter is specified, otherwise <code>gp2</code> </p>
    ///   - [`tde_credential_arn(impl Into<String>)`](crate::client::fluent_builders::CreateDBInstance::tde_credential_arn) / [`set_tde_credential_arn(Option<String>)`](crate::client::fluent_builders::CreateDBInstance::set_tde_credential_arn): <p>The ARN from the key store with which to associate the instance for TDE encryption.</p>  <p>This setting doesn't apply to RDS Custom.</p>
    ///   - [`tde_credential_password(impl Into<String>)`](crate::client::fluent_builders::CreateDBInstance::tde_credential_password) / [`set_tde_credential_password(Option<String>)`](crate::client::fluent_builders::CreateDBInstance::set_tde_credential_password): <p>The password for the given ARN from the key store in order to access the device.</p>  <p>This setting doesn't apply to RDS Custom.</p>
    ///   - [`storage_encrypted(bool)`](crate::client::fluent_builders::CreateDBInstance::storage_encrypted) / [`set_storage_encrypted(Option<bool>)`](crate::client::fluent_builders::CreateDBInstance::set_storage_encrypted): <p>A value that indicates whether the DB instance is encrypted. By default, it isn't encrypted.</p>  <p>For RDS Custom instances, either set this parameter to <code>true</code> or leave it unset. If you set this parameter to <code>false</code>, RDS reports an error.</p>  <p> <b>Amazon Aurora</b> </p>  <p>Not applicable. The encryption for DB instances is managed by the DB cluster.</p>
    ///   - [`kms_key_id(impl Into<String>)`](crate::client::fluent_builders::CreateDBInstance::kms_key_id) / [`set_kms_key_id(Option<String>)`](crate::client::fluent_builders::CreateDBInstance::set_kms_key_id): <p>The Amazon Web Services KMS key identifier for an encrypted DB instance.</p>  <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key. To use a KMS key in a different Amazon Web Services account, specify the key ARN or alias ARN.</p>  <p> <b>Amazon Aurora</b> </p>  <p>Not applicable. The Amazon Web Services KMS key identifier is managed by the DB cluster. For more information, see <code>CreateDBCluster</code>.</p>  <p>If <code>StorageEncrypted</code> is enabled, and you do not specify a value for the <code>KmsKeyId</code> parameter, then Amazon RDS uses your default KMS key. There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account has a different default KMS key for each Amazon Web Services Region.</p>  <p> <b>Amazon RDS Custom</b> </p>  <p>A KMS key is required for RDS Custom instances. For most RDS engines, if you leave this parameter empty while enabling <code>StorageEncrypted</code>, the engine uses the default KMS key. However, RDS Custom doesn't use the default key when this parameter is empty. You must explicitly specify a key.</p>
    ///   - [`domain(impl Into<String>)`](crate::client::fluent_builders::CreateDBInstance::domain) / [`set_domain(Option<String>)`](crate::client::fluent_builders::CreateDBInstance::set_domain): <p>The Active Directory directory ID to create the DB instance in. Currently, only MySQL, Microsoft SQL Server, Oracle, and PostgreSQL DB instances can be created in an Active Directory Domain.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/kerberos-authentication.html"> Kerberos Authentication</a> in the <i>Amazon RDS User Guide</i>.</p>  <p>This setting doesn't apply to RDS Custom.</p>
    ///   - [`copy_tags_to_snapshot(bool)`](crate::client::fluent_builders::CreateDBInstance::copy_tags_to_snapshot) / [`set_copy_tags_to_snapshot(Option<bool>)`](crate::client::fluent_builders::CreateDBInstance::set_copy_tags_to_snapshot): <p>A value that indicates whether to copy tags from the DB instance to snapshots of the DB instance. By default, tags are not copied.</p>  <p> <b>Amazon Aurora</b> </p>  <p>Not applicable. Copying tags to snapshots is managed by the DB cluster. Setting this value for an Aurora DB instance has no effect on the DB cluster setting.</p>
    ///   - [`monitoring_interval(i32)`](crate::client::fluent_builders::CreateDBInstance::monitoring_interval) / [`set_monitoring_interval(Option<i32>)`](crate::client::fluent_builders::CreateDBInstance::set_monitoring_interval): <p>The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB instance. To disable collection of Enhanced Monitoring metrics, specify 0. The default is 0.</p>  <p>If <code>MonitoringRoleArn</code> is specified, then you must set <code>MonitoringInterval</code> to a value other than 0.</p>  <p>This setting doesn't apply to RDS Custom.</p>  <p>Valid Values: <code>0, 1, 5, 10, 15, 30, 60</code> </p>
    ///   - [`monitoring_role_arn(impl Into<String>)`](crate::client::fluent_builders::CreateDBInstance::monitoring_role_arn) / [`set_monitoring_role_arn(Option<String>)`](crate::client::fluent_builders::CreateDBInstance::set_monitoring_role_arn): <p>The ARN for the IAM role that permits RDS to send enhanced monitoring metrics to Amazon CloudWatch Logs. For example, <code>arn:aws:iam:123456789012:role/emaccess</code>. For information on creating a monitoring role, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.OS.html#USER_Monitoring.OS.Enabling">Setting Up and Enabling Enhanced Monitoring</a> in the <i>Amazon RDS User Guide</i>.</p>  <p>If <code>MonitoringInterval</code> is set to a value other than 0, then you must supply a <code>MonitoringRoleArn</code> value.</p>  <p>This setting doesn't apply to RDS Custom.</p>
    ///   - [`domain_iam_role_name(impl Into<String>)`](crate::client::fluent_builders::CreateDBInstance::domain_iam_role_name) / [`set_domain_iam_role_name(Option<String>)`](crate::client::fluent_builders::CreateDBInstance::set_domain_iam_role_name): <p>Specify the name of the IAM role to be used when making API calls to the Directory Service.</p>  <p>This setting doesn't apply to RDS Custom.</p>
    ///   - [`promotion_tier(i32)`](crate::client::fluent_builders::CreateDBInstance::promotion_tier) / [`set_promotion_tier(Option<i32>)`](crate::client::fluent_builders::CreateDBInstance::set_promotion_tier): <p>A value that specifies the order in which an Aurora Replica is promoted to the primary instance after a failure of the existing primary instance. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.FaultTolerance"> Fault Tolerance for an Aurora DB Cluster</a> in the <i>Amazon Aurora User Guide</i>.</p>  <p>This setting doesn't apply to RDS Custom.</p>  <p>Default: 1</p>  <p>Valid Values: 0 - 15</p>
    ///   - [`timezone(impl Into<String>)`](crate::client::fluent_builders::CreateDBInstance::timezone) / [`set_timezone(Option<String>)`](crate::client::fluent_builders::CreateDBInstance::set_timezone): <p>The time zone of the DB instance. The time zone parameter is currently supported only by <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_SQLServer.html#SQLServer.Concepts.General.TimeZone">Microsoft SQL Server</a>.</p>
    ///   - [`enable_iam_database_authentication(bool)`](crate::client::fluent_builders::CreateDBInstance::enable_iam_database_authentication) / [`set_enable_iam_database_authentication(Option<bool>)`](crate::client::fluent_builders::CreateDBInstance::set_enable_iam_database_authentication): <p>A value that indicates whether to enable mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts. By default, mapping isn't enabled.</p>  <p>This setting doesn't apply to RDS Custom or Amazon Aurora. In Aurora, mapping Amazon Web Services IAM accounts to database accounts is managed by the DB cluster.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.html"> IAM Database Authentication for MySQL and PostgreSQL</a> in the <i>Amazon RDS User Guide</i>.</p>
    ///   - [`enable_performance_insights(bool)`](crate::client::fluent_builders::CreateDBInstance::enable_performance_insights) / [`set_enable_performance_insights(Option<bool>)`](crate::client::fluent_builders::CreateDBInstance::set_enable_performance_insights): <p>A value that indicates whether to enable Performance Insights for the DB instance. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html">Using Amazon Performance Insights</a> in the <i>Amazon RDS User Guide</i>.</p>  <p>This setting doesn't apply to RDS Custom.</p>
    ///   - [`performance_insights_kms_key_id(impl Into<String>)`](crate::client::fluent_builders::CreateDBInstance::performance_insights_kms_key_id) / [`set_performance_insights_kms_key_id(Option<String>)`](crate::client::fluent_builders::CreateDBInstance::set_performance_insights_kms_key_id): <p>The Amazon Web Services KMS key identifier for encryption of Performance Insights data.</p>  <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.</p>  <p>If you do not specify a value for <code>PerformanceInsightsKMSKeyId</code>, then Amazon RDS uses your default KMS key. There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account has a different default KMS key for each Amazon Web Services Region.</p>  <p>This setting doesn't apply to RDS Custom.</p>
    ///   - [`performance_insights_retention_period(i32)`](crate::client::fluent_builders::CreateDBInstance::performance_insights_retention_period) / [`set_performance_insights_retention_period(Option<i32>)`](crate::client::fluent_builders::CreateDBInstance::set_performance_insights_retention_period): <p>The amount of time, in days, to retain Performance Insights data. Valid values are 7 or 731 (2 years).</p>  <p>This setting doesn't apply to RDS Custom.</p>
    ///   - [`enable_cloudwatch_logs_exports(Vec<String>)`](crate::client::fluent_builders::CreateDBInstance::enable_cloudwatch_logs_exports) / [`set_enable_cloudwatch_logs_exports(Option<Vec<String>>)`](crate::client::fluent_builders::CreateDBInstance::set_enable_cloudwatch_logs_exports): <p>The list of log types that need to be enabled for exporting to CloudWatch Logs. The values in the list depend on the DB engine. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch"> Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon RDS User Guide</i>.</p>  <p> <b>Amazon Aurora</b> </p>  <p>Not applicable. CloudWatch Logs exports are managed by the DB cluster.</p>  <p> <b>RDS Custom</b> </p>  <p>Not applicable.</p>  <p> <b>MariaDB</b> </p>  <p>Possible values are <code>audit</code>, <code>error</code>, <code>general</code>, and <code>slowquery</code>.</p>  <p> <b>Microsoft SQL Server</b> </p>  <p>Possible values are <code>agent</code> and <code>error</code>.</p>  <p> <b>MySQL</b> </p>  <p>Possible values are <code>audit</code>, <code>error</code>, <code>general</code>, and <code>slowquery</code>.</p>  <p> <b>Oracle</b> </p>  <p>Possible values are <code>alert</code>, <code>audit</code>, <code>listener</code>, <code>trace</code>, and <code>oemagent</code>.</p>  <p> <b>PostgreSQL</b> </p>  <p>Possible values are <code>postgresql</code> and <code>upgrade</code>.</p>
    ///   - [`processor_features(Vec<ProcessorFeature>)`](crate::client::fluent_builders::CreateDBInstance::processor_features) / [`set_processor_features(Option<Vec<ProcessorFeature>>)`](crate::client::fluent_builders::CreateDBInstance::set_processor_features): <p>The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.</p>  <p>This setting doesn't apply to RDS Custom.</p>
    ///   - [`deletion_protection(bool)`](crate::client::fluent_builders::CreateDBInstance::deletion_protection) / [`set_deletion_protection(Option<bool>)`](crate::client::fluent_builders::CreateDBInstance::set_deletion_protection): <p>A value that indicates whether the DB instance has deletion protection enabled. The database can't be deleted when deletion protection is enabled. By default, deletion protection isn't enabled. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html"> Deleting a DB Instance</a>.</p>  <p> <b>Amazon Aurora</b> </p>  <p>Not applicable. You can enable or disable deletion protection for the DB cluster. For more information, see <code>CreateDBCluster</code>. DB instances in a DB cluster can be deleted even when deletion protection is enabled for the DB cluster.</p>
    ///   - [`max_allocated_storage(i32)`](crate::client::fluent_builders::CreateDBInstance::max_allocated_storage) / [`set_max_allocated_storage(Option<i32>)`](crate::client::fluent_builders::CreateDBInstance::set_max_allocated_storage): <p>The upper limit in gibibytes (GiB) to which Amazon RDS can automatically scale the storage of the DB instance.</p>  <p>For more information about this setting, including limitations that apply to it, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIOPS.StorageTypes.html#USER_PIOPS.Autoscaling"> Managing capacity automatically with Amazon RDS storage autoscaling</a> in the <i>Amazon RDS User Guide</i>.</p>  <p>This setting doesn't apply to RDS Custom.</p>
    ///   - [`enable_customer_owned_ip(bool)`](crate::client::fluent_builders::CreateDBInstance::enable_customer_owned_ip) / [`set_enable_customer_owned_ip(Option<bool>)`](crate::client::fluent_builders::CreateDBInstance::set_enable_customer_owned_ip): <p>A value that indicates whether to enable a customer-owned IP address (CoIP) for an RDS on Outposts DB instance.</p>  <p>A <i>CoIP</i> provides local or external connectivity to resources in your Outpost subnets through your on-premises network. For some use cases, a CoIP can provide lower latency for connections to the DB instance from outside of its virtual private cloud (VPC) on your local network.</p>  <p>For more information about RDS on Outposts, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html">Working with Amazon RDS on Amazon Web Services Outposts</a> in the <i>Amazon RDS User Guide</i>.</p>  <p>For more information about CoIPs, see <a href="https://docs.aws.amazon.com/outposts/latest/userguide/outposts-networking-components.html#ip-addressing">Customer-owned IP addresses</a> in the <i>Amazon Web Services Outposts User Guide</i>.</p>
    ///   - [`custom_iam_instance_profile(impl Into<String>)`](crate::client::fluent_builders::CreateDBInstance::custom_iam_instance_profile) / [`set_custom_iam_instance_profile(Option<String>)`](crate::client::fluent_builders::CreateDBInstance::set_custom_iam_instance_profile): <p>The instance profile associated with the underlying Amazon EC2 instance of an RDS Custom DB instance. The instance profile must meet the following requirements:</p>  <ul>   <li> <p>The profile must exist in your account.</p> </li>   <li> <p>The profile must have an IAM role that Amazon EC2 has permissions to assume.</p> </li>   <li> <p>The instance profile name and the associated IAM role name must start with the prefix <code>AWSRDSCustom</code>.</p> </li>  </ul>  <p>For the list of permissions required for the IAM role, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-setup-orcl.html#custom-setup-orcl.iam-vpc"> Configure IAM and your VPC</a> in the <i>Amazon RDS User Guide</i>.</p>  <p>This setting is required for RDS Custom.</p>
    ///   - [`backup_target(impl Into<String>)`](crate::client::fluent_builders::CreateDBInstance::backup_target) / [`set_backup_target(Option<String>)`](crate::client::fluent_builders::CreateDBInstance::set_backup_target): <p>Specifies where automated backups and manual snapshots are stored.</p>  <p>Possible values are <code>outposts</code> (Amazon Web Services Outposts) and <code>region</code> (Amazon Web Services Region). The default is <code>region</code>.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html">Working with Amazon RDS on Amazon Web Services Outposts</a> in the <i>Amazon RDS User Guide</i>.</p>
    /// - On success, responds with [`CreateDbInstanceOutput`](crate::output::CreateDbInstanceOutput) with field(s):
    ///   - [`db_instance(Option<DbInstance>)`](crate::output::CreateDbInstanceOutput::db_instance): <p>Contains the details of an Amazon RDS DB instance.</p>  <p>This data type is used as a response element in the operations <code>CreateDBInstance</code>, <code>CreateDBInstanceReadReplica</code>, <code>DeleteDBInstance</code>, <code>DescribeDBInstances</code>, <code>ModifyDBInstance</code>, <code>PromoteReadReplica</code>, <code>RebootDBInstance</code>, <code>RestoreDBInstanceFromDBSnapshot</code>, <code>RestoreDBInstanceFromS3</code>, <code>RestoreDBInstanceToPointInTime</code>, <code>StartDBInstance</code>, and <code>StopDBInstance</code>.</p>
    /// - On failure, responds with [`SdkError<CreateDBInstanceError>`](crate::error::CreateDBInstanceError)
    pub fn create_db_instance(&self) -> fluent_builders::CreateDBInstance {
        fluent_builders::CreateDBInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateDBInstanceReadReplica`](crate::client::fluent_builders::CreateDBInstanceReadReplica) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_instance_identifier(impl Into<String>)`](crate::client::fluent_builders::CreateDBInstanceReadReplica::db_instance_identifier) / [`set_db_instance_identifier(Option<String>)`](crate::client::fluent_builders::CreateDBInstanceReadReplica::set_db_instance_identifier): <p>The DB instance identifier of the read replica. This identifier is the unique key that identifies a DB instance. This parameter is stored as a lowercase string.</p>
    ///   - [`source_db_instance_identifier(impl Into<String>)`](crate::client::fluent_builders::CreateDBInstanceReadReplica::source_db_instance_identifier) / [`set_source_db_instance_identifier(Option<String>)`](crate::client::fluent_builders::CreateDBInstanceReadReplica::set_source_db_instance_identifier): <p>The identifier of the DB instance that will act as the source for the read replica. Each DB instance can have up to five read replicas.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must be the identifier of an existing MySQL, MariaDB, Oracle, PostgreSQL, or SQL Server DB instance.</p> </li>   <li> <p>Can specify a DB instance that is a MySQL read replica only if the source is running MySQL 5.6 or later.</p> </li>   <li> <p>For the limitations of Oracle read replicas, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/oracle-read-replicas.html">Read Replica Limitations with Oracle</a> in the <i>Amazon RDS User Guide</i>.</p> </li>   <li> <p>For the limitations of SQL Server read replicas, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/SQLServer.ReadReplicas.Limitations.html">Read Replica Limitations with Microsoft SQL Server</a> in the <i>Amazon RDS User Guide</i>.</p> </li>   <li> <p>Can specify a PostgreSQL DB instance only if the source is running PostgreSQL 9.3.5 or later (9.4.7 and higher for cross-Region replication).</p> </li>   <li> <p>The specified DB instance must have automatic backups enabled, that is, its backup retention period must be greater than 0.</p> </li>   <li> <p>If the source DB instance is in the same Amazon Web Services Region as the read replica, specify a valid DB instance identifier.</p> </li>   <li> <p>If the source DB instance is in a different Amazon Web Services Region from the read replica, specify a valid DB instance ARN. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing">Constructing an ARN for Amazon RDS</a> in the <i>Amazon RDS User Guide</i>. This doesn't apply to SQL Server or RDS Custom, which don't support cross-Region replicas.</p> </li>  </ul>
    ///   - [`db_instance_class(impl Into<String>)`](crate::client::fluent_builders::CreateDBInstanceReadReplica::db_instance_class) / [`set_db_instance_class(Option<String>)`](crate::client::fluent_builders::CreateDBInstanceReadReplica::set_db_instance_class): <p>The compute and memory capacity of the read replica, for example db.m4.large. Not all DB instance classes are available in all Amazon Web Services Regions, or for all database engines. For the full list of DB instance classes, and availability for your engine, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html">DB Instance Class</a> in the <i>Amazon RDS User Guide</i>.</p>  <p>Default: Inherits from the source DB instance.</p>
    ///   - [`availability_zone(impl Into<String>)`](crate::client::fluent_builders::CreateDBInstanceReadReplica::availability_zone) / [`set_availability_zone(Option<String>)`](crate::client::fluent_builders::CreateDBInstanceReadReplica::set_availability_zone): <p>The Availability Zone (AZ) where the read replica will be created.</p>  <p>Default: A random, system-chosen Availability Zone in the endpoint's Amazon Web Services Region.</p>  <p>Example: <code>us-east-1d</code> </p>
    ///   - [`port(i32)`](crate::client::fluent_builders::CreateDBInstanceReadReplica::port) / [`set_port(Option<i32>)`](crate::client::fluent_builders::CreateDBInstanceReadReplica::set_port): <p>The port number that the DB instance uses for connections.</p>  <p>Default: Inherits from the source DB instance</p>  <p>Valid Values: <code>1150-65535</code> </p>
    ///   - [`multi_az(bool)`](crate::client::fluent_builders::CreateDBInstanceReadReplica::multi_az) / [`set_multi_az(Option<bool>)`](crate::client::fluent_builders::CreateDBInstanceReadReplica::set_multi_az): <p>A value that indicates whether the read replica is in a Multi-AZ deployment.</p>  <p>You can create a read replica as a Multi-AZ DB instance. RDS creates a standby of your replica in another Availability Zone for failover support for the replica. Creating your read replica as a Multi-AZ DB instance is independent of whether the source database is a Multi-AZ DB instance.</p>  <p>This setting doesn't apply to RDS Custom.</p>
    ///   - [`auto_minor_version_upgrade(bool)`](crate::client::fluent_builders::CreateDBInstanceReadReplica::auto_minor_version_upgrade) / [`set_auto_minor_version_upgrade(Option<bool>)`](crate::client::fluent_builders::CreateDBInstanceReadReplica::set_auto_minor_version_upgrade): <p>A value that indicates whether minor engine upgrades are applied automatically to the read replica during the maintenance window.</p>  <p>This setting doesn't apply to RDS Custom.</p>  <p>Default: Inherits from the source DB instance</p>
    ///   - [`iops(i32)`](crate::client::fluent_builders::CreateDBInstanceReadReplica::iops) / [`set_iops(Option<i32>)`](crate::client::fluent_builders::CreateDBInstanceReadReplica::set_iops): <p>The amount of Provisioned IOPS (input/output operations per second) to be initially allocated for the DB instance.</p>
    ///   - [`option_group_name(impl Into<String>)`](crate::client::fluent_builders::CreateDBInstanceReadReplica::option_group_name) / [`set_option_group_name(Option<String>)`](crate::client::fluent_builders::CreateDBInstanceReadReplica::set_option_group_name): <p>The option group the DB instance is associated with. If omitted, the option group associated with the source instance is used.</p> <note>   <p>For SQL Server, you must use the option group associated with the source instance.</p>  </note>  <p>This setting doesn't apply to RDS Custom.</p>
    ///   - [`db_parameter_group_name(impl Into<String>)`](crate::client::fluent_builders::CreateDBInstanceReadReplica::db_parameter_group_name) / [`set_db_parameter_group_name(Option<String>)`](crate::client::fluent_builders::CreateDBInstanceReadReplica::set_db_parameter_group_name): <p>The name of the DB parameter group to associate with this DB instance.</p>  <p>If you do not specify a value for <code>DBParameterGroupName</code>, then Amazon RDS uses the <code>DBParameterGroup</code> of source DB instance for a same Region read replica, or the default <code>DBParameterGroup</code> for the specified DB engine for a cross-Region read replica.</p>  <p>Specifying a parameter group for this operation is only supported for Oracle DB instances. It isn't supported for RDS Custom.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must be 1 to 255 letters, numbers, or hyphens.</p> </li>   <li> <p>First character must be a letter</p> </li>   <li> <p>Can't end with a hyphen or contain two consecutive hyphens</p> </li>  </ul>
    ///   - [`publicly_accessible(bool)`](crate::client::fluent_builders::CreateDBInstanceReadReplica::publicly_accessible) / [`set_publicly_accessible(Option<bool>)`](crate::client::fluent_builders::CreateDBInstanceReadReplica::set_publicly_accessible): <p>A value that indicates whether the DB instance is publicly accessible.</p>  <p>When the DB cluster is publicly accessible, its Domain Name System (DNS) endpoint resolves to the private IP address from within the DB cluster's virtual private cloud (VPC). It resolves to the public IP address from outside of the DB cluster's VPC. Access to the DB cluster is ultimately controlled by the security group it uses. That public access isn't permitted if the security group assigned to the DB cluster doesn't permit it.</p>  <p>When the DB instance isn't publicly accessible, it is an internal DB instance with a DNS name that resolves to a private IP address.</p>  <p>For more information, see <code>CreateDBInstance</code>.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateDBInstanceReadReplica::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateDBInstanceReadReplica::set_tags): <p>A list of tags. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources</a> in the <i>Amazon RDS User Guide.</i> </p>
    ///   - [`db_subnet_group_name(impl Into<String>)`](crate::client::fluent_builders::CreateDBInstanceReadReplica::db_subnet_group_name) / [`set_db_subnet_group_name(Option<String>)`](crate::client::fluent_builders::CreateDBInstanceReadReplica::set_db_subnet_group_name): <p>Specifies a DB subnet group for the DB instance. The new DB instance is created in the VPC associated with the DB subnet group. If no DB subnet group is specified, then the new DB instance isn't created in a VPC.</p>  <p>Constraints:</p>  <ul>   <li> <p>Can only be specified if the source DB instance identifier specifies a DB instance in another Amazon Web Services Region.</p> </li>   <li> <p>If supplied, must match the name of an existing DBSubnetGroup.</p> </li>   <li> <p>The specified DB subnet group must be in the same Amazon Web Services Region in which the operation is running.</p> </li>   <li> <p>All read replicas in one Amazon Web Services Region that are created from the same source DB instance must either:&gt;</p>    <ul>     <li> <p>Specify DB subnet groups from the same VPC. All these read replicas are created in the same VPC.</p> </li>     <li> <p>Not specify a DB subnet group. All these read replicas are created outside of any VPC.</p> </li>    </ul> </li>  </ul>  <p>Example: <code>mydbsubnetgroup</code> </p>
    ///   - [`vpc_security_group_ids(Vec<String>)`](crate::client::fluent_builders::CreateDBInstanceReadReplica::vpc_security_group_ids) / [`set_vpc_security_group_ids(Option<Vec<String>>)`](crate::client::fluent_builders::CreateDBInstanceReadReplica::set_vpc_security_group_ids): <p>A list of Amazon EC2 VPC security groups to associate with the read replica.</p>  <p>This setting doesn't apply to RDS Custom.</p>  <p>Default: The default EC2 VPC security group for the DB subnet group's VPC.</p>
    ///   - [`storage_type(impl Into<String>)`](crate::client::fluent_builders::CreateDBInstanceReadReplica::storage_type) / [`set_storage_type(Option<String>)`](crate::client::fluent_builders::CreateDBInstanceReadReplica::set_storage_type): <p>Specifies the storage type to be associated with the read replica.</p>  <p>Valid values: <code>standard | gp2 | io1</code> </p>  <p>If you specify <code>io1</code>, you must also include a value for the <code>Iops</code> parameter.</p>  <p>Default: <code>io1</code> if the <code>Iops</code> parameter is specified, otherwise <code>gp2</code> </p>
    ///   - [`copy_tags_to_snapshot(bool)`](crate::client::fluent_builders::CreateDBInstanceReadReplica::copy_tags_to_snapshot) / [`set_copy_tags_to_snapshot(Option<bool>)`](crate::client::fluent_builders::CreateDBInstanceReadReplica::set_copy_tags_to_snapshot): <p>A value that indicates whether to copy all tags from the read replica to snapshots of the read replica. By default, tags are not copied.</p>
    ///   - [`monitoring_interval(i32)`](crate::client::fluent_builders::CreateDBInstanceReadReplica::monitoring_interval) / [`set_monitoring_interval(Option<i32>)`](crate::client::fluent_builders::CreateDBInstanceReadReplica::set_monitoring_interval): <p>The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the read replica. To disable collecting Enhanced Monitoring metrics, specify 0. The default is 0.</p>  <p>If <code>MonitoringRoleArn</code> is specified, then you must also set <code>MonitoringInterval</code> to a value other than 0.</p>  <p>This setting doesn't apply to RDS Custom.</p>  <p>Valid Values: <code>0, 1, 5, 10, 15, 30, 60</code> </p>
    ///   - [`monitoring_role_arn(impl Into<String>)`](crate::client::fluent_builders::CreateDBInstanceReadReplica::monitoring_role_arn) / [`set_monitoring_role_arn(Option<String>)`](crate::client::fluent_builders::CreateDBInstanceReadReplica::set_monitoring_role_arn): <p>The ARN for the IAM role that permits RDS to send enhanced monitoring metrics to Amazon CloudWatch Logs. For example, <code>arn:aws:iam:123456789012:role/emaccess</code>. For information on creating a monitoring role, go to <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.html#USER_Monitoring.OS.IAMRole">To create an IAM role for Amazon RDS Enhanced Monitoring</a> in the <i>Amazon RDS User Guide</i>.</p>  <p>If <code>MonitoringInterval</code> is set to a value other than 0, then you must supply a <code>MonitoringRoleArn</code> value.</p>  <p>This setting doesn't apply to RDS Custom.</p>
    ///   - [`kms_key_id(impl Into<String>)`](crate::client::fluent_builders::CreateDBInstanceReadReplica::kms_key_id) / [`set_kms_key_id(Option<String>)`](crate::client::fluent_builders::CreateDBInstanceReadReplica::set_kms_key_id): <p>The Amazon Web Services KMS key identifier for an encrypted read replica.</p>  <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.</p>  <p>If you create an encrypted read replica in the same Amazon Web Services Region as the source DB instance, then do not specify a value for this parameter. A read replica in the same Amazon Web Services Region is always encrypted with the same KMS key as the source DB instance.</p>  <p>If you create an encrypted read replica in a different Amazon Web Services Region, then you must specify a KMS key identifier for the destination Amazon Web Services Region. KMS keys are specific to the Amazon Web Services Region that they are created in, and you can't use KMS keys from one Amazon Web Services Region in another Amazon Web Services Region.</p>  <p>You can't create an encrypted read replica from an unencrypted DB instance.</p>  <p>This setting doesn't apply to RDS Custom, which uses the same KMS key as the primary replica.</p>
    ///   - [`pre_signed_url(impl Into<String>)`](crate::client::fluent_builders::CreateDBInstanceReadReplica::pre_signed_url) / [`set_pre_signed_url(Option<String>)`](crate::client::fluent_builders::CreateDBInstanceReadReplica::set_pre_signed_url): <p>The URL that contains a Signature Version 4 signed request for the <code>CreateDBInstanceReadReplica</code> API action in the source Amazon Web Services Region that contains the source DB instance.</p>  <p>You must specify this parameter when you create an encrypted read replica from another Amazon Web Services Region by using the Amazon RDS API. Don't specify <code>PreSignedUrl</code> when you are creating an encrypted read replica in the same Amazon Web Services Region.</p>  <p>The presigned URL must be a valid request for the <code>CreateDBInstanceReadReplica</code> API action that can be executed in the source Amazon Web Services Region that contains the encrypted source DB instance. The presigned URL request must contain the following parameter values:</p>  <ul>   <li> <p> <code>DestinationRegion</code> - The Amazon Web Services Region that the encrypted read replica is created in. This Amazon Web Services Region is the same one where the <code>CreateDBInstanceReadReplica</code> action is called that contains this presigned URL.</p> <p>For example, if you create an encrypted DB instance in the us-west-1 Amazon Web Services Region, from a source DB instance in the us-east-2 Amazon Web Services Region, then you call the <code>CreateDBInstanceReadReplica</code> action in the us-east-1 Amazon Web Services Region and provide a presigned URL that contains a call to the <code>CreateDBInstanceReadReplica</code> action in the us-west-2 Amazon Web Services Region. For this example, the <code>DestinationRegion</code> in the presigned URL must be set to the us-east-1 Amazon Web Services Region.</p> </li>   <li> <p> <code>KmsKeyId</code> - The Amazon Web Services KMS key identifier for the key to use to encrypt the read replica in the destination Amazon Web Services Region. This is the same identifier for both the <code>CreateDBInstanceReadReplica</code> action that is called in the destination Amazon Web Services Region, and the action contained in the presigned URL.</p> </li>   <li> <p> <code>SourceDBInstanceIdentifier</code> - The DB instance identifier for the encrypted DB instance to be replicated. This identifier must be in the Amazon Resource Name (ARN) format for the source Amazon Web Services Region. For example, if you are creating an encrypted read replica from a DB instance in the us-west-2 Amazon Web Services Region, then your <code>SourceDBInstanceIdentifier</code> looks like the following example: <code>arn:aws:rds:us-west-2:123456789012:instance:mysql-instance1-20161115</code>.</p> </li>  </ul>  <p>To learn how to generate a Signature Version 4 signed request, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html">Authenticating Requests: Using Query Parameters (Amazon Web Services Signature Version 4)</a> and <a href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4 Signing Process</a>.</p> <note>   <p>If you are using an Amazon Web Services SDK tool or the CLI, you can specify <code>SourceRegion</code> (or <code>--source-region</code> for the CLI) instead of specifying <code>PreSignedUrl</code> manually. Specifying <code>SourceRegion</code> autogenerates a presigned URL that is a valid request for the operation that can be executed in the source Amazon Web Services Region.</p>   <p> <code>SourceRegion</code> isn't supported for SQL Server, because SQL Server on Amazon RDS doesn't support cross-Region read replicas.</p>  </note>  <p>This setting doesn't apply to RDS Custom.</p>
    ///   - [`enable_iam_database_authentication(bool)`](crate::client::fluent_builders::CreateDBInstanceReadReplica::enable_iam_database_authentication) / [`set_enable_iam_database_authentication(Option<bool>)`](crate::client::fluent_builders::CreateDBInstanceReadReplica::set_enable_iam_database_authentication): <p>A value that indicates whether to enable mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts. By default, mapping isn't enabled.</p>  <p>For more information about IAM database authentication, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.html"> IAM Database Authentication for MySQL and PostgreSQL</a> in the <i>Amazon RDS User Guide</i>.</p>  <p>This setting doesn't apply to RDS Custom.</p>
    ///   - [`enable_performance_insights(bool)`](crate::client::fluent_builders::CreateDBInstanceReadReplica::enable_performance_insights) / [`set_enable_performance_insights(Option<bool>)`](crate::client::fluent_builders::CreateDBInstanceReadReplica::set_enable_performance_insights): <p>A value that indicates whether to enable Performance Insights for the read replica.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html">Using Amazon Performance Insights</a> in the <i>Amazon RDS User Guide</i>.</p>  <p>This setting doesn't apply to RDS Custom.</p>
    ///   - [`performance_insights_kms_key_id(impl Into<String>)`](crate::client::fluent_builders::CreateDBInstanceReadReplica::performance_insights_kms_key_id) / [`set_performance_insights_kms_key_id(Option<String>)`](crate::client::fluent_builders::CreateDBInstanceReadReplica::set_performance_insights_kms_key_id): <p>The Amazon Web Services KMS key identifier for encryption of Performance Insights data.</p>  <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.</p>  <p>If you do not specify a value for <code>PerformanceInsightsKMSKeyId</code>, then Amazon RDS uses your default KMS key. There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account has a different default KMS key for each Amazon Web Services Region.</p>  <p>This setting doesn't apply to RDS Custom.</p>
    ///   - [`performance_insights_retention_period(i32)`](crate::client::fluent_builders::CreateDBInstanceReadReplica::performance_insights_retention_period) / [`set_performance_insights_retention_period(Option<i32>)`](crate::client::fluent_builders::CreateDBInstanceReadReplica::set_performance_insights_retention_period): <p>The amount of time, in days, to retain Performance Insights data. Valid values are 7 or 731 (2 years).</p>  <p>This setting doesn't apply to RDS Custom.</p>
    ///   - [`enable_cloudwatch_logs_exports(Vec<String>)`](crate::client::fluent_builders::CreateDBInstanceReadReplica::enable_cloudwatch_logs_exports) / [`set_enable_cloudwatch_logs_exports(Option<Vec<String>>)`](crate::client::fluent_builders::CreateDBInstanceReadReplica::set_enable_cloudwatch_logs_exports): <p>The list of logs that the new DB instance is to export to CloudWatch Logs. The values in the list depend on the DB engine being used. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch">Publishing Database Logs to Amazon CloudWatch Logs </a> in the <i>Amazon RDS User Guide</i>.</p>  <p>This setting doesn't apply to RDS Custom.</p>
    ///   - [`processor_features(Vec<ProcessorFeature>)`](crate::client::fluent_builders::CreateDBInstanceReadReplica::processor_features) / [`set_processor_features(Option<Vec<ProcessorFeature>>)`](crate::client::fluent_builders::CreateDBInstanceReadReplica::set_processor_features): <p>The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.</p>  <p>This setting doesn't apply to RDS Custom.</p>
    ///   - [`use_default_processor_features(bool)`](crate::client::fluent_builders::CreateDBInstanceReadReplica::use_default_processor_features) / [`set_use_default_processor_features(Option<bool>)`](crate::client::fluent_builders::CreateDBInstanceReadReplica::set_use_default_processor_features): <p>A value that indicates whether the DB instance class of the DB instance uses its default processor features.</p>  <p>This setting doesn't apply to RDS Custom.</p>
    ///   - [`deletion_protection(bool)`](crate::client::fluent_builders::CreateDBInstanceReadReplica::deletion_protection) / [`set_deletion_protection(Option<bool>)`](crate::client::fluent_builders::CreateDBInstanceReadReplica::set_deletion_protection): <p>A value that indicates whether the DB instance has deletion protection enabled. The database can't be deleted when deletion protection is enabled. By default, deletion protection isn't enabled. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html"> Deleting a DB Instance</a>.</p>
    ///   - [`domain(impl Into<String>)`](crate::client::fluent_builders::CreateDBInstanceReadReplica::domain) / [`set_domain(Option<String>)`](crate::client::fluent_builders::CreateDBInstanceReadReplica::set_domain): <p>The Active Directory directory ID to create the DB instance in. Currently, only MySQL, Microsoft SQL Server, Oracle, and PostgreSQL DB instances can be created in an Active Directory Domain.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/kerberos-authentication.html"> Kerberos Authentication</a> in the <i>Amazon RDS User Guide</i>.</p>  <p>This setting doesn't apply to RDS Custom.</p>
    ///   - [`domain_iam_role_name(impl Into<String>)`](crate::client::fluent_builders::CreateDBInstanceReadReplica::domain_iam_role_name) / [`set_domain_iam_role_name(Option<String>)`](crate::client::fluent_builders::CreateDBInstanceReadReplica::set_domain_iam_role_name): <p>Specify the name of the IAM role to be used when making API calls to the Directory Service.</p>  <p>This setting doesn't apply to RDS Custom.</p>
    ///   - [`replica_mode(ReplicaMode)`](crate::client::fluent_builders::CreateDBInstanceReadReplica::replica_mode) / [`set_replica_mode(Option<ReplicaMode>)`](crate::client::fluent_builders::CreateDBInstanceReadReplica::set_replica_mode): <p>The open mode of the replica database: mounted or read-only.</p> <note>   <p>This parameter is only supported for Oracle DB instances.</p>  </note>  <p>Mounted DB replicas are included in Oracle Database Enterprise Edition. The main use case for mounted replicas is cross-Region disaster recovery. The primary database doesn't use Active Data Guard to transmit information to the mounted replica. Because it doesn't accept user connections, a mounted replica can't serve a read-only workload.</p>  <p>You can create a combination of mounted and read-only DB replicas for the same primary DB instance. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/oracle-read-replicas.html">Working with Oracle Read Replicas for Amazon RDS</a> in the <i>Amazon RDS User Guide</i>.</p>  <p>For RDS Custom, you must specify this parameter and set it to <code>mounted</code>. The value won't be set by default. After replica creation, you can manage the open mode manually.</p>
    ///   - [`max_allocated_storage(i32)`](crate::client::fluent_builders::CreateDBInstanceReadReplica::max_allocated_storage) / [`set_max_allocated_storage(Option<i32>)`](crate::client::fluent_builders::CreateDBInstanceReadReplica::set_max_allocated_storage): <p>The upper limit in gibibytes (GiB) to which Amazon RDS can automatically scale the storage of the DB instance.</p>  <p>For more information about this setting, including limitations that apply to it, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIOPS.StorageTypes.html#USER_PIOPS.Autoscaling"> Managing capacity automatically with Amazon RDS storage autoscaling</a> in the <i>Amazon RDS User Guide</i>.</p>
    ///   - [`custom_iam_instance_profile(impl Into<String>)`](crate::client::fluent_builders::CreateDBInstanceReadReplica::custom_iam_instance_profile) / [`set_custom_iam_instance_profile(Option<String>)`](crate::client::fluent_builders::CreateDBInstanceReadReplica::set_custom_iam_instance_profile): <p>The instance profile associated with the underlying Amazon EC2 instance of an RDS Custom DB instance. The instance profile must meet the following requirements:</p>  <ul>   <li> <p>The profile must exist in your account.</p> </li>   <li> <p>The profile must have an IAM role that Amazon EC2 has permissions to assume.</p> </li>   <li> <p>The instance profile name and the associated IAM role name must start with the prefix <code>AWSRDSCustom</code>.</p> </li>  </ul>  <p>For the list of permissions required for the IAM role, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-setup-orcl.html#custom-setup-orcl.iam-vpc"> Configure IAM and your VPC</a> in the <i>Amazon RDS User Guide</i>.</p>  <p>This setting is required for RDS Custom.</p>
    /// - On success, responds with [`CreateDbInstanceReadReplicaOutput`](crate::output::CreateDbInstanceReadReplicaOutput) with field(s):
    ///   - [`db_instance(Option<DbInstance>)`](crate::output::CreateDbInstanceReadReplicaOutput::db_instance): <p>Contains the details of an Amazon RDS DB instance.</p>  <p>This data type is used as a response element in the operations <code>CreateDBInstance</code>, <code>CreateDBInstanceReadReplica</code>, <code>DeleteDBInstance</code>, <code>DescribeDBInstances</code>, <code>ModifyDBInstance</code>, <code>PromoteReadReplica</code>, <code>RebootDBInstance</code>, <code>RestoreDBInstanceFromDBSnapshot</code>, <code>RestoreDBInstanceFromS3</code>, <code>RestoreDBInstanceToPointInTime</code>, <code>StartDBInstance</code>, and <code>StopDBInstance</code>.</p>
    /// - On failure, responds with [`SdkError<CreateDBInstanceReadReplicaError>`](crate::error::CreateDBInstanceReadReplicaError)
    pub fn create_db_instance_read_replica(&self) -> fluent_builders::CreateDBInstanceReadReplica {
        fluent_builders::CreateDBInstanceReadReplica::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateDBParameterGroup`](crate::client::fluent_builders::CreateDBParameterGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_parameter_group_name(impl Into<String>)`](crate::client::fluent_builders::CreateDBParameterGroup::db_parameter_group_name) / [`set_db_parameter_group_name(Option<String>)`](crate::client::fluent_builders::CreateDBParameterGroup::set_db_parameter_group_name): <p>The name of the DB parameter group.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must be 1 to 255 letters, numbers, or hyphens.</p> </li>   <li> <p>First character must be a letter</p> </li>   <li> <p>Can't end with a hyphen or contain two consecutive hyphens</p> </li>  </ul> <note>   <p>This value is stored as a lowercase string.</p>  </note>
    ///   - [`db_parameter_group_family(impl Into<String>)`](crate::client::fluent_builders::CreateDBParameterGroup::db_parameter_group_family) / [`set_db_parameter_group_family(Option<String>)`](crate::client::fluent_builders::CreateDBParameterGroup::set_db_parameter_group_family): <p>The DB parameter group family name. A DB parameter group can be associated with one and only one DB parameter group family, and can be applied only to a DB instance running a database engine and engine version compatible with that DB parameter group family.</p>  <p>To list all of the available parameter group families for a DB engine, use the following command:</p>  <p> <code>aws rds describe-db-engine-versions --query "DBEngineVersions[].DBParameterGroupFamily" --engine    <engine></engine></code> </p>  <p>For example, to list all of the available parameter group families for the MySQL DB engine, use the following command:</p>  <p> <code>aws rds describe-db-engine-versions --query "DBEngineVersions[].DBParameterGroupFamily" --engine mysql</code> </p> <note>   <p>The output contains duplicates.</p>  </note>  <p>The following are the valid DB engine values:</p>  <ul>   <li> <p> <code>aurora</code> (for MySQL 5.6-compatible Aurora)</p> </li>   <li> <p> <code>aurora-mysql</code> (for MySQL 5.7-compatible and MySQL 8.0-compatible Aurora)</p> </li>   <li> <p> <code>aurora-postgresql</code> </p> </li>   <li> <p> <code>mariadb</code> </p> </li>   <li> <p> <code>mysql</code> </p> </li>   <li> <p> <code>oracle-ee</code> </p> </li>   <li> <p> <code>oracle-ee-cdb</code> </p> </li>   <li> <p> <code>oracle-se2</code> </p> </li>   <li> <p> <code>oracle-se2-cdb</code> </p> </li>   <li> <p> <code>postgres</code> </p> </li>   <li> <p> <code>sqlserver-ee</code> </p> </li>   <li> <p> <code>sqlserver-se</code> </p> </li>   <li> <p> <code>sqlserver-ex</code> </p> </li>   <li> <p> <code>sqlserver-web</code> </p> </li>  </ul>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateDBParameterGroup::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateDBParameterGroup::set_description): <p>The description for the DB parameter group.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateDBParameterGroup::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateDBParameterGroup::set_tags): <p>Tags to assign to the DB parameter group.</p>
    /// - On success, responds with [`CreateDbParameterGroupOutput`](crate::output::CreateDbParameterGroupOutput) with field(s):
    ///   - [`db_parameter_group(Option<DbParameterGroup>)`](crate::output::CreateDbParameterGroupOutput::db_parameter_group): <p>Contains the details of an Amazon RDS DB parameter group.</p>  <p>This data type is used as a response element in the <code>DescribeDBParameterGroups</code> action.</p>
    /// - On failure, responds with [`SdkError<CreateDBParameterGroupError>`](crate::error::CreateDBParameterGroupError)
    pub fn create_db_parameter_group(&self) -> fluent_builders::CreateDBParameterGroup {
        fluent_builders::CreateDBParameterGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateDBProxy`](crate::client::fluent_builders::CreateDBProxy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_proxy_name(impl Into<String>)`](crate::client::fluent_builders::CreateDBProxy::db_proxy_name) / [`set_db_proxy_name(Option<String>)`](crate::client::fluent_builders::CreateDBProxy::set_db_proxy_name): <p>The identifier for the proxy. This name must be unique for all proxies owned by your Amazon Web Services account in the specified Amazon Web Services Region. An identifier must begin with a letter and must contain only ASCII letters, digits, and hyphens; it can't end with a hyphen or contain two consecutive hyphens.</p>
    ///   - [`engine_family(EngineFamily)`](crate::client::fluent_builders::CreateDBProxy::engine_family) / [`set_engine_family(Option<EngineFamily>)`](crate::client::fluent_builders::CreateDBProxy::set_engine_family): <p>The kinds of databases that the proxy can connect to. This value determines which database network protocol the proxy recognizes when it interprets network traffic to and from the database. The engine family applies to MySQL and PostgreSQL for both RDS and Aurora.</p>
    ///   - [`auth(Vec<UserAuthConfig>)`](crate::client::fluent_builders::CreateDBProxy::auth) / [`set_auth(Option<Vec<UserAuthConfig>>)`](crate::client::fluent_builders::CreateDBProxy::set_auth): <p>The authorization mechanism that the proxy uses.</p>
    ///   - [`role_arn(impl Into<String>)`](crate::client::fluent_builders::CreateDBProxy::role_arn) / [`set_role_arn(Option<String>)`](crate::client::fluent_builders::CreateDBProxy::set_role_arn): <p>The Amazon Resource Name (ARN) of the IAM role that the proxy uses to access secrets in Amazon Web Services Secrets Manager.</p>
    ///   - [`vpc_subnet_ids(Vec<String>)`](crate::client::fluent_builders::CreateDBProxy::vpc_subnet_ids) / [`set_vpc_subnet_ids(Option<Vec<String>>)`](crate::client::fluent_builders::CreateDBProxy::set_vpc_subnet_ids): <p>One or more VPC subnet IDs to associate with the new proxy.</p>
    ///   - [`vpc_security_group_ids(Vec<String>)`](crate::client::fluent_builders::CreateDBProxy::vpc_security_group_ids) / [`set_vpc_security_group_ids(Option<Vec<String>>)`](crate::client::fluent_builders::CreateDBProxy::set_vpc_security_group_ids): <p>One or more VPC security group IDs to associate with the new proxy.</p>
    ///   - [`require_tls(bool)`](crate::client::fluent_builders::CreateDBProxy::require_tls) / [`set_require_tls(bool)`](crate::client::fluent_builders::CreateDBProxy::set_require_tls): <p>A Boolean parameter that specifies whether Transport Layer Security (TLS) encryption is required for connections to the proxy. By enabling this setting, you can enforce encrypted TLS connections to the proxy.</p>
    ///   - [`idle_client_timeout(i32)`](crate::client::fluent_builders::CreateDBProxy::idle_client_timeout) / [`set_idle_client_timeout(Option<i32>)`](crate::client::fluent_builders::CreateDBProxy::set_idle_client_timeout): <p>The number of seconds that a connection to the proxy can be inactive before the proxy disconnects it. You can set this value higher or lower than the connection timeout limit for the associated database.</p>
    ///   - [`debug_logging(bool)`](crate::client::fluent_builders::CreateDBProxy::debug_logging) / [`set_debug_logging(bool)`](crate::client::fluent_builders::CreateDBProxy::set_debug_logging): <p>Whether the proxy includes detailed information about SQL statements in its logs. This information helps you to debug issues involving SQL behavior or the performance and scalability of the proxy connections. The debug information includes the text of SQL statements that you submit through the proxy. Thus, only enable this setting when needed for debugging, and only when you have security measures in place to safeguard any sensitive information that appears in the logs.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateDBProxy::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateDBProxy::set_tags): <p>An optional set of key-value pairs to associate arbitrary data of your choosing with the proxy.</p>
    /// - On success, responds with [`CreateDbProxyOutput`](crate::output::CreateDbProxyOutput) with field(s):
    ///   - [`db_proxy(Option<DbProxy>)`](crate::output::CreateDbProxyOutput::db_proxy): <p>The <code>DBProxy</code> structure corresponding to the new proxy.</p>
    /// - On failure, responds with [`SdkError<CreateDBProxyError>`](crate::error::CreateDBProxyError)
    pub fn create_db_proxy(&self) -> fluent_builders::CreateDBProxy {
        fluent_builders::CreateDBProxy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateDBProxyEndpoint`](crate::client::fluent_builders::CreateDBProxyEndpoint) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_proxy_name(impl Into<String>)`](crate::client::fluent_builders::CreateDBProxyEndpoint::db_proxy_name) / [`set_db_proxy_name(Option<String>)`](crate::client::fluent_builders::CreateDBProxyEndpoint::set_db_proxy_name): <p>The name of the DB proxy associated with the DB proxy endpoint that you create.</p>
    ///   - [`db_proxy_endpoint_name(impl Into<String>)`](crate::client::fluent_builders::CreateDBProxyEndpoint::db_proxy_endpoint_name) / [`set_db_proxy_endpoint_name(Option<String>)`](crate::client::fluent_builders::CreateDBProxyEndpoint::set_db_proxy_endpoint_name): <p>The name of the DB proxy endpoint to create.</p>
    ///   - [`vpc_subnet_ids(Vec<String>)`](crate::client::fluent_builders::CreateDBProxyEndpoint::vpc_subnet_ids) / [`set_vpc_subnet_ids(Option<Vec<String>>)`](crate::client::fluent_builders::CreateDBProxyEndpoint::set_vpc_subnet_ids): <p>The VPC subnet IDs for the DB proxy endpoint that you create. You can specify a different set of subnet IDs than for the original DB proxy.</p>
    ///   - [`vpc_security_group_ids(Vec<String>)`](crate::client::fluent_builders::CreateDBProxyEndpoint::vpc_security_group_ids) / [`set_vpc_security_group_ids(Option<Vec<String>>)`](crate::client::fluent_builders::CreateDBProxyEndpoint::set_vpc_security_group_ids): <p>The VPC security group IDs for the DB proxy endpoint that you create. You can specify a different set of security group IDs than for the original DB proxy. The default is the default security group for the VPC.</p>
    ///   - [`target_role(DbProxyEndpointTargetRole)`](crate::client::fluent_builders::CreateDBProxyEndpoint::target_role) / [`set_target_role(Option<DbProxyEndpointTargetRole>)`](crate::client::fluent_builders::CreateDBProxyEndpoint::set_target_role): <p>A value that indicates whether the DB proxy endpoint can be used for read/write or read-only operations. The default is <code>READ_WRITE</code>.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateDBProxyEndpoint::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateDBProxyEndpoint::set_tags): <p>A list of tags. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources</a> in the <i>Amazon RDS User Guide.</i> </p>
    /// - On success, responds with [`CreateDbProxyEndpointOutput`](crate::output::CreateDbProxyEndpointOutput) with field(s):
    ///   - [`db_proxy_endpoint(Option<DbProxyEndpoint>)`](crate::output::CreateDbProxyEndpointOutput::db_proxy_endpoint): <p>The <code>DBProxyEndpoint</code> object that is created by the API operation. The DB proxy endpoint that you create might provide capabilities such as read/write or read-only operations, or using a different VPC than the proxy's default VPC.</p>
    /// - On failure, responds with [`SdkError<CreateDBProxyEndpointError>`](crate::error::CreateDBProxyEndpointError)
    pub fn create_db_proxy_endpoint(&self) -> fluent_builders::CreateDBProxyEndpoint {
        fluent_builders::CreateDBProxyEndpoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateDBSecurityGroup`](crate::client::fluent_builders::CreateDBSecurityGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_security_group_name(impl Into<String>)`](crate::client::fluent_builders::CreateDBSecurityGroup::db_security_group_name) / [`set_db_security_group_name(Option<String>)`](crate::client::fluent_builders::CreateDBSecurityGroup::set_db_security_group_name): <p>The name for the DB security group. This value is stored as a lowercase string.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must be 1 to 255 letters, numbers, or hyphens.</p> </li>   <li> <p>First character must be a letter</p> </li>   <li> <p>Can't end with a hyphen or contain two consecutive hyphens</p> </li>   <li> <p>Must not be "Default"</p> </li>  </ul>  <p>Example: <code>mysecuritygroup</code> </p>
    ///   - [`db_security_group_description(impl Into<String>)`](crate::client::fluent_builders::CreateDBSecurityGroup::db_security_group_description) / [`set_db_security_group_description(Option<String>)`](crate::client::fluent_builders::CreateDBSecurityGroup::set_db_security_group_description): <p>The description for the DB security group.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateDBSecurityGroup::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateDBSecurityGroup::set_tags): <p>Tags to assign to the DB security group.</p>
    /// - On success, responds with [`CreateDbSecurityGroupOutput`](crate::output::CreateDbSecurityGroupOutput) with field(s):
    ///   - [`db_security_group(Option<DbSecurityGroup>)`](crate::output::CreateDbSecurityGroupOutput::db_security_group): <p>Contains the details for an Amazon RDS DB security group.</p>  <p>This data type is used as a response element in the <code>DescribeDBSecurityGroups</code> action.</p>
    /// - On failure, responds with [`SdkError<CreateDBSecurityGroupError>`](crate::error::CreateDBSecurityGroupError)
    pub fn create_db_security_group(&self) -> fluent_builders::CreateDBSecurityGroup {
        fluent_builders::CreateDBSecurityGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateDBSnapshot`](crate::client::fluent_builders::CreateDBSnapshot) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_snapshot_identifier(impl Into<String>)`](crate::client::fluent_builders::CreateDBSnapshot::db_snapshot_identifier) / [`set_db_snapshot_identifier(Option<String>)`](crate::client::fluent_builders::CreateDBSnapshot::set_db_snapshot_identifier): <p>The identifier for the DB snapshot.</p>  <p>Constraints:</p>  <ul>   <li> <p>Can't be null, empty, or blank</p> </li>   <li> <p>Must contain from 1 to 255 letters, numbers, or hyphens</p> </li>   <li> <p>First character must be a letter</p> </li>   <li> <p>Can't end with a hyphen or contain two consecutive hyphens</p> </li>  </ul>  <p>Example: <code>my-snapshot-id</code> </p>
    ///   - [`db_instance_identifier(impl Into<String>)`](crate::client::fluent_builders::CreateDBSnapshot::db_instance_identifier) / [`set_db_instance_identifier(Option<String>)`](crate::client::fluent_builders::CreateDBSnapshot::set_db_instance_identifier): <p>The identifier of the DB instance that you want to create the snapshot of.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must match the identifier of an existing DBInstance.</p> </li>  </ul>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateDBSnapshot::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateDBSnapshot::set_tags): <p>A list of tags. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources</a> in the <i>Amazon RDS User Guide.</i> </p>
    /// - On success, responds with [`CreateDbSnapshotOutput`](crate::output::CreateDbSnapshotOutput) with field(s):
    ///   - [`db_snapshot(Option<DbSnapshot>)`](crate::output::CreateDbSnapshotOutput::db_snapshot): <p>Contains the details of an Amazon RDS DB snapshot.</p>  <p>This data type is used as a response element in the <code>DescribeDBSnapshots</code> action.</p>
    /// - On failure, responds with [`SdkError<CreateDBSnapshotError>`](crate::error::CreateDBSnapshotError)
    pub fn create_db_snapshot(&self) -> fluent_builders::CreateDBSnapshot {
        fluent_builders::CreateDBSnapshot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateDBSubnetGroup`](crate::client::fluent_builders::CreateDBSubnetGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_subnet_group_name(impl Into<String>)`](crate::client::fluent_builders::CreateDBSubnetGroup::db_subnet_group_name) / [`set_db_subnet_group_name(Option<String>)`](crate::client::fluent_builders::CreateDBSubnetGroup::set_db_subnet_group_name): <p>The name for the DB subnet group. This value is stored as a lowercase string.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must contain no more than 255 letters, numbers, periods, underscores, spaces, or hyphens.</p> </li>   <li> <p>Must not be default.</p> </li>   <li> <p>First character must be a letter.</p> </li>  </ul>  <p>Example: <code>mydbsubnetgroup</code> </p>
    ///   - [`db_subnet_group_description(impl Into<String>)`](crate::client::fluent_builders::CreateDBSubnetGroup::db_subnet_group_description) / [`set_db_subnet_group_description(Option<String>)`](crate::client::fluent_builders::CreateDBSubnetGroup::set_db_subnet_group_description): <p>The description for the DB subnet group.</p>
    ///   - [`subnet_ids(Vec<String>)`](crate::client::fluent_builders::CreateDBSubnetGroup::subnet_ids) / [`set_subnet_ids(Option<Vec<String>>)`](crate::client::fluent_builders::CreateDBSubnetGroup::set_subnet_ids): <p>The EC2 Subnet IDs for the DB subnet group.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateDBSubnetGroup::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateDBSubnetGroup::set_tags): <p>Tags to assign to the DB subnet group.</p>
    /// - On success, responds with [`CreateDbSubnetGroupOutput`](crate::output::CreateDbSubnetGroupOutput) with field(s):
    ///   - [`db_subnet_group(Option<DbSubnetGroup>)`](crate::output::CreateDbSubnetGroupOutput::db_subnet_group): <p>Contains the details of an Amazon RDS DB subnet group.</p>  <p>This data type is used as a response element in the <code>DescribeDBSubnetGroups</code> action.</p>
    /// - On failure, responds with [`SdkError<CreateDBSubnetGroupError>`](crate::error::CreateDBSubnetGroupError)
    pub fn create_db_subnet_group(&self) -> fluent_builders::CreateDBSubnetGroup {
        fluent_builders::CreateDBSubnetGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateEventSubscription`](crate::client::fluent_builders::CreateEventSubscription) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`subscription_name(impl Into<String>)`](crate::client::fluent_builders::CreateEventSubscription::subscription_name) / [`set_subscription_name(Option<String>)`](crate::client::fluent_builders::CreateEventSubscription::set_subscription_name): <p>The name of the subscription.</p>  <p>Constraints: The name must be less than 255 characters.</p>
    ///   - [`sns_topic_arn(impl Into<String>)`](crate::client::fluent_builders::CreateEventSubscription::sns_topic_arn) / [`set_sns_topic_arn(Option<String>)`](crate::client::fluent_builders::CreateEventSubscription::set_sns_topic_arn): <p>The Amazon Resource Name (ARN) of the SNS topic created for event notification. The ARN is created by Amazon SNS when you create a topic and subscribe to it.</p>
    ///   - [`source_type(impl Into<String>)`](crate::client::fluent_builders::CreateEventSubscription::source_type) / [`set_source_type(Option<String>)`](crate::client::fluent_builders::CreateEventSubscription::set_source_type): <p>The type of source that is generating the events. For example, if you want to be notified of events generated by a DB instance, you set this parameter to <code>db-instance</code>. For RDS Proxy events, specify <code>db-proxy</code>. If this value isn't specified, all events are returned.</p>  <p>Valid values: <code>db-instance</code> | <code>db-cluster</code> | <code>db-parameter-group</code> | <code>db-security-group</code> | <code>db-snapshot</code> | <code>db-cluster-snapshot</code> | <code>db-proxy</code> </p>
    ///   - [`event_categories(Vec<String>)`](crate::client::fluent_builders::CreateEventSubscription::event_categories) / [`set_event_categories(Option<Vec<String>>)`](crate::client::fluent_builders::CreateEventSubscription::set_event_categories): <p>A list of event categories for a particular source type (<code>SourceType</code>) that you want to subscribe to. You can see a list of the categories for a given source type in the "Amazon RDS event categories and event messages" section of the <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Events.Messages.html"> <i>Amazon RDS User Guide</i> </a> or the <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_Events.Messages.html"> <i>Amazon Aurora User Guide</i> </a>. You can also see this list by using the <code>DescribeEventCategories</code> operation.</p>
    ///   - [`source_ids(Vec<String>)`](crate::client::fluent_builders::CreateEventSubscription::source_ids) / [`set_source_ids(Option<Vec<String>>)`](crate::client::fluent_builders::CreateEventSubscription::set_source_ids): <p>The list of identifiers of the event sources for which events are returned. If not specified, then all sources are included in the response. An identifier must begin with a letter and must contain only ASCII letters, digits, and hyphens. It can't end with a hyphen or contain two consecutive hyphens.</p>  <p>Constraints:</p>  <ul>   <li> <p>If <code>SourceIds</code> are supplied, <code>SourceType</code> must also be provided.</p> </li>   <li> <p>If the source type is a DB instance, a <code>DBInstanceIdentifier</code> value must be supplied.</p> </li>   <li> <p>If the source type is a DB cluster, a <code>DBClusterIdentifier</code> value must be supplied.</p> </li>   <li> <p>If the source type is a DB parameter group, a <code>DBParameterGroupName</code> value must be supplied.</p> </li>   <li> <p>If the source type is a DB security group, a <code>DBSecurityGroupName</code> value must be supplied.</p> </li>   <li> <p>If the source type is a DB snapshot, a <code>DBSnapshotIdentifier</code> value must be supplied.</p> </li>   <li> <p>If the source type is a DB cluster snapshot, a <code>DBClusterSnapshotIdentifier</code> value must be supplied.</p> </li>   <li> <p>If the source type is an RDS Proxy, a <code>DBProxyName</code> value must be supplied.</p> </li>  </ul>
    ///   - [`enabled(bool)`](crate::client::fluent_builders::CreateEventSubscription::enabled) / [`set_enabled(Option<bool>)`](crate::client::fluent_builders::CreateEventSubscription::set_enabled): <p>A value that indicates whether to activate the subscription. If the event notification subscription isn't activated, the subscription is created but not active.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateEventSubscription::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateEventSubscription::set_tags): <p>A list of tags. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources</a> in the <i>Amazon RDS User Guide.</i> </p>
    /// - On success, responds with [`CreateEventSubscriptionOutput`](crate::output::CreateEventSubscriptionOutput) with field(s):
    ///   - [`event_subscription(Option<EventSubscription>)`](crate::output::CreateEventSubscriptionOutput::event_subscription): <p>Contains the results of a successful invocation of the <code>DescribeEventSubscriptions</code> action.</p>
    /// - On failure, responds with [`SdkError<CreateEventSubscriptionError>`](crate::error::CreateEventSubscriptionError)
    pub fn create_event_subscription(&self) -> fluent_builders::CreateEventSubscription {
        fluent_builders::CreateEventSubscription::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateGlobalCluster`](crate::client::fluent_builders::CreateGlobalCluster) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`global_cluster_identifier(impl Into<String>)`](crate::client::fluent_builders::CreateGlobalCluster::global_cluster_identifier) / [`set_global_cluster_identifier(Option<String>)`](crate::client::fluent_builders::CreateGlobalCluster::set_global_cluster_identifier): <p>The cluster identifier of the new global database cluster.</p>
    ///   - [`source_db_cluster_identifier(impl Into<String>)`](crate::client::fluent_builders::CreateGlobalCluster::source_db_cluster_identifier) / [`set_source_db_cluster_identifier(Option<String>)`](crate::client::fluent_builders::CreateGlobalCluster::set_source_db_cluster_identifier): <p>The Amazon Resource Name (ARN) to use as the primary cluster of the global database. This parameter is optional.</p>
    ///   - [`engine(impl Into<String>)`](crate::client::fluent_builders::CreateGlobalCluster::engine) / [`set_engine(Option<String>)`](crate::client::fluent_builders::CreateGlobalCluster::set_engine): <p>The name of the database engine to be used for this DB cluster.</p>
    ///   - [`engine_version(impl Into<String>)`](crate::client::fluent_builders::CreateGlobalCluster::engine_version) / [`set_engine_version(Option<String>)`](crate::client::fluent_builders::CreateGlobalCluster::set_engine_version): <p>The engine version of the Aurora global database.</p>
    ///   - [`deletion_protection(bool)`](crate::client::fluent_builders::CreateGlobalCluster::deletion_protection) / [`set_deletion_protection(Option<bool>)`](crate::client::fluent_builders::CreateGlobalCluster::set_deletion_protection): <p>The deletion protection setting for the new global database. The global database can't be deleted when deletion protection is enabled.</p>
    ///   - [`database_name(impl Into<String>)`](crate::client::fluent_builders::CreateGlobalCluster::database_name) / [`set_database_name(Option<String>)`](crate::client::fluent_builders::CreateGlobalCluster::set_database_name): <p>The name for your database of up to 64 alpha-numeric characters. If you do not provide a name, Amazon Aurora will not create a database in the global database cluster you are creating.</p>
    ///   - [`storage_encrypted(bool)`](crate::client::fluent_builders::CreateGlobalCluster::storage_encrypted) / [`set_storage_encrypted(Option<bool>)`](crate::client::fluent_builders::CreateGlobalCluster::set_storage_encrypted): <p>The storage encryption setting for the new global database cluster.</p>
    /// - On success, responds with [`CreateGlobalClusterOutput`](crate::output::CreateGlobalClusterOutput) with field(s):
    ///   - [`global_cluster(Option<GlobalCluster>)`](crate::output::CreateGlobalClusterOutput::global_cluster): <p>A data type representing an Aurora global database.</p>
    /// - On failure, responds with [`SdkError<CreateGlobalClusterError>`](crate::error::CreateGlobalClusterError)
    pub fn create_global_cluster(&self) -> fluent_builders::CreateGlobalCluster {
        fluent_builders::CreateGlobalCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateOptionGroup`](crate::client::fluent_builders::CreateOptionGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`option_group_name(impl Into<String>)`](crate::client::fluent_builders::CreateOptionGroup::option_group_name) / [`set_option_group_name(Option<String>)`](crate::client::fluent_builders::CreateOptionGroup::set_option_group_name): <p>Specifies the name of the option group to be created.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must be 1 to 255 letters, numbers, or hyphens</p> </li>   <li> <p>First character must be a letter</p> </li>   <li> <p>Can't end with a hyphen or contain two consecutive hyphens</p> </li>  </ul>  <p>Example: <code>myoptiongroup</code> </p>
    ///   - [`engine_name(impl Into<String>)`](crate::client::fluent_builders::CreateOptionGroup::engine_name) / [`set_engine_name(Option<String>)`](crate::client::fluent_builders::CreateOptionGroup::set_engine_name): <p>Specifies the name of the engine that this option group should be associated with.</p>  <p>Valid Values:</p>  <ul>   <li> <p> <code>mariadb</code> </p> </li>   <li> <p> <code>mysql</code> </p> </li>   <li> <p> <code>oracle-ee</code> </p> </li>   <li> <p> <code>oracle-ee-cdb</code> </p> </li>   <li> <p> <code>oracle-se2</code> </p> </li>   <li> <p> <code>oracle-se2-cdb</code> </p> </li>   <li> <p> <code>postgres</code> </p> </li>   <li> <p> <code>sqlserver-ee</code> </p> </li>   <li> <p> <code>sqlserver-se</code> </p> </li>   <li> <p> <code>sqlserver-ex</code> </p> </li>   <li> <p> <code>sqlserver-web</code> </p> </li>  </ul>
    ///   - [`major_engine_version(impl Into<String>)`](crate::client::fluent_builders::CreateOptionGroup::major_engine_version) / [`set_major_engine_version(Option<String>)`](crate::client::fluent_builders::CreateOptionGroup::set_major_engine_version): <p>Specifies the major version of the engine that this option group should be associated with.</p>
    ///   - [`option_group_description(impl Into<String>)`](crate::client::fluent_builders::CreateOptionGroup::option_group_description) / [`set_option_group_description(Option<String>)`](crate::client::fluent_builders::CreateOptionGroup::set_option_group_description): <p>The description of the option group.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateOptionGroup::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateOptionGroup::set_tags): <p>Tags to assign to the option group.</p>
    /// - On success, responds with [`CreateOptionGroupOutput`](crate::output::CreateOptionGroupOutput) with field(s):
    ///   - [`option_group(Option<OptionGroup>)`](crate::output::CreateOptionGroupOutput::option_group): <p></p>
    /// - On failure, responds with [`SdkError<CreateOptionGroupError>`](crate::error::CreateOptionGroupError)
    pub fn create_option_group(&self) -> fluent_builders::CreateOptionGroup {
        fluent_builders::CreateOptionGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteCustomDBEngineVersion`](crate::client::fluent_builders::DeleteCustomDBEngineVersion) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`engine(impl Into<String>)`](crate::client::fluent_builders::DeleteCustomDBEngineVersion::engine) / [`set_engine(Option<String>)`](crate::client::fluent_builders::DeleteCustomDBEngineVersion::set_engine): <p>The database engine. The only supported engine is <code>custom-oracle-ee</code>.</p>
    ///   - [`engine_version(impl Into<String>)`](crate::client::fluent_builders::DeleteCustomDBEngineVersion::engine_version) / [`set_engine_version(Option<String>)`](crate::client::fluent_builders::DeleteCustomDBEngineVersion::set_engine_version): <p>The custom engine version (CEV) for your DB instance. This option is required for RDS Custom, but optional for Amazon RDS. The combination of <code>Engine</code> and <code>EngineVersion</code> is unique per customer per Amazon Web Services Region.</p>
    /// - On success, responds with [`DeleteCustomDbEngineVersionOutput`](crate::output::DeleteCustomDbEngineVersionOutput) with field(s):
    ///   - [`engine(Option<String>)`](crate::output::DeleteCustomDbEngineVersionOutput::engine): <p>The name of the database engine.</p>
    ///   - [`engine_version(Option<String>)`](crate::output::DeleteCustomDbEngineVersionOutput::engine_version): <p>The version number of the database engine.</p>
    ///   - [`db_parameter_group_family(Option<String>)`](crate::output::DeleteCustomDbEngineVersionOutput::db_parameter_group_family): <p>The name of the DB parameter group family for the database engine.</p>
    ///   - [`db_engine_description(Option<String>)`](crate::output::DeleteCustomDbEngineVersionOutput::db_engine_description): <p>The description of the database engine.</p>
    ///   - [`db_engine_version_description(Option<String>)`](crate::output::DeleteCustomDbEngineVersionOutput::db_engine_version_description): <p>The description of the database engine version.</p>
    ///   - [`default_character_set(Option<CharacterSet>)`](crate::output::DeleteCustomDbEngineVersionOutput::default_character_set): <p>The default character set for new instances of this engine version, if the <code>CharacterSetName</code> parameter of the CreateDBInstance API isn't specified.</p>
    ///   - [`supported_character_sets(Option<Vec<CharacterSet>>)`](crate::output::DeleteCustomDbEngineVersionOutput::supported_character_sets): <p>A list of the character sets supported by this engine for the <code>CharacterSetName</code> parameter of the <code>CreateDBInstance</code> operation.</p>
    ///   - [`supported_nchar_character_sets(Option<Vec<CharacterSet>>)`](crate::output::DeleteCustomDbEngineVersionOutput::supported_nchar_character_sets): <p>A list of the character sets supported by the Oracle DB engine for the <code>NcharCharacterSetName</code> parameter of the <code>CreateDBInstance</code> operation.</p>
    ///   - [`valid_upgrade_target(Option<Vec<UpgradeTarget>>)`](crate::output::DeleteCustomDbEngineVersionOutput::valid_upgrade_target): <p>A list of engine versions that this database engine version can be upgraded to.</p>
    ///   - [`supported_timezones(Option<Vec<Timezone>>)`](crate::output::DeleteCustomDbEngineVersionOutput::supported_timezones): <p>A list of the time zones supported by this engine for the <code>Timezone</code> parameter of the <code>CreateDBInstance</code> action.</p>
    ///   - [`exportable_log_types(Option<Vec<String>>)`](crate::output::DeleteCustomDbEngineVersionOutput::exportable_log_types): <p>The types of logs that the database engine has available for export to CloudWatch Logs.</p>
    ///   - [`supports_log_exports_to_cloudwatch_logs(bool)`](crate::output::DeleteCustomDbEngineVersionOutput::supports_log_exports_to_cloudwatch_logs): <p>A value that indicates whether the engine version supports exporting the log types specified by ExportableLogTypes to CloudWatch Logs.</p>
    ///   - [`supports_read_replica(bool)`](crate::output::DeleteCustomDbEngineVersionOutput::supports_read_replica): <p>Indicates whether the database engine version supports read replicas.</p>
    ///   - [`supported_engine_modes(Option<Vec<String>>)`](crate::output::DeleteCustomDbEngineVersionOutput::supported_engine_modes): <p>A list of the supported DB engine modes.</p>
    ///   - [`supported_feature_names(Option<Vec<String>>)`](crate::output::DeleteCustomDbEngineVersionOutput::supported_feature_names): <p>A list of features supported by the DB engine.</p>  <p>The supported features vary by DB engine and DB engine version.</p>  <p>To determine the supported features for a specific DB engine and DB engine version using the CLI, use the following command:</p>  <p> <code>aws rds describe-db-engine-versions --engine    <engine_name>     --engine-version     <engine_version></engine_version>   </engine_name></code> </p>  <p>For example, to determine the supported features for RDS for PostgreSQL version 13.3 using the CLI, use the following command:</p>  <p> <code>aws rds describe-db-engine-versions --engine postgres --engine-version 13.3</code> </p>  <p>The supported features are listed under <code>SupportedFeatureNames</code> in the output.</p>
    ///   - [`status(Option<String>)`](crate::output::DeleteCustomDbEngineVersionOutput::status): <p>The status of the DB engine version, either <code>available</code> or <code>deprecated</code>.</p>
    ///   - [`supports_parallel_query(bool)`](crate::output::DeleteCustomDbEngineVersionOutput::supports_parallel_query): <p>A value that indicates whether you can use Aurora parallel query with a specific DB engine version.</p>
    ///   - [`supports_global_databases(bool)`](crate::output::DeleteCustomDbEngineVersionOutput::supports_global_databases): <p>A value that indicates whether you can use Aurora global databases with a specific DB engine version.</p>
    ///   - [`major_engine_version(Option<String>)`](crate::output::DeleteCustomDbEngineVersionOutput::major_engine_version): <p>The major engine version of the CEV.</p>
    ///   - [`database_installation_files_s3_bucket_name(Option<String>)`](crate::output::DeleteCustomDbEngineVersionOutput::database_installation_files_s3_bucket_name): <p>The name of the Amazon S3 bucket that contains your database installation files.</p>
    ///   - [`database_installation_files_s3_prefix(Option<String>)`](crate::output::DeleteCustomDbEngineVersionOutput::database_installation_files_s3_prefix): <p>The Amazon S3 directory that contains the database installation files. If not specified, then no prefix is assumed.</p>
    ///   - [`db_engine_version_arn(Option<String>)`](crate::output::DeleteCustomDbEngineVersionOutput::db_engine_version_arn): <p>The ARN of the custom engine version.</p>
    ///   - [`kms_key_id(Option<String>)`](crate::output::DeleteCustomDbEngineVersionOutput::kms_key_id): <p>The Amazon Web Services KMS key identifier for an encrypted CEV. This parameter is required for RDS Custom, but optional for Amazon RDS.</p>
    ///   - [`create_time(Option<DateTime>)`](crate::output::DeleteCustomDbEngineVersionOutput::create_time): <p>The creation time of the DB engine version.</p>
    ///   - [`tag_list(Option<Vec<Tag>>)`](crate::output::DeleteCustomDbEngineVersionOutput::tag_list): <p>A list of tags. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources</a> in the <i>Amazon RDS User Guide.</i> </p>
    ///   - [`supports_babelfish(bool)`](crate::output::DeleteCustomDbEngineVersionOutput::supports_babelfish): <p>A value that indicates whether the engine version supports Babelfish for Aurora PostgreSQL.</p>
    /// - On failure, responds with [`SdkError<DeleteCustomDBEngineVersionError>`](crate::error::DeleteCustomDBEngineVersionError)
    pub fn delete_custom_db_engine_version(&self) -> fluent_builders::DeleteCustomDBEngineVersion {
        fluent_builders::DeleteCustomDBEngineVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteDBCluster`](crate::client::fluent_builders::DeleteDBCluster) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_cluster_identifier(impl Into<String>)`](crate::client::fluent_builders::DeleteDBCluster::db_cluster_identifier) / [`set_db_cluster_identifier(Option<String>)`](crate::client::fluent_builders::DeleteDBCluster::set_db_cluster_identifier): <p>The DB cluster identifier for the DB cluster to be deleted. This parameter isn't case-sensitive.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must match an existing DBClusterIdentifier.</p> </li>  </ul>
    ///   - [`skip_final_snapshot(bool)`](crate::client::fluent_builders::DeleteDBCluster::skip_final_snapshot) / [`set_skip_final_snapshot(bool)`](crate::client::fluent_builders::DeleteDBCluster::set_skip_final_snapshot): <p>A value that indicates whether to skip the creation of a final DB cluster snapshot before the DB cluster is deleted. If skip is specified, no DB cluster snapshot is created. If skip isn't specified, a DB cluster snapshot is created before the DB cluster is deleted. By default, skip isn't specified, and the DB cluster snapshot is created. By default, this parameter is disabled.</p> <note>   <p>You must specify a <code>FinalDBSnapshotIdentifier</code> parameter if <code>SkipFinalSnapshot</code> is disabled.</p>  </note>
    ///   - [`final_db_snapshot_identifier(impl Into<String>)`](crate::client::fluent_builders::DeleteDBCluster::final_db_snapshot_identifier) / [`set_final_db_snapshot_identifier(Option<String>)`](crate::client::fluent_builders::DeleteDBCluster::set_final_db_snapshot_identifier): <p>The DB cluster snapshot identifier of the new DB cluster snapshot created when <code>SkipFinalSnapshot</code> is disabled.</p> <note>   <p>Specifying this parameter and also skipping the creation of a final DB cluster snapshot with the <code>SkipFinalShapshot</code> parameter results in an error.</p>  </note>  <p>Constraints:</p>  <ul>   <li> <p>Must be 1 to 255 letters, numbers, or hyphens.</p> </li>   <li> <p>First character must be a letter</p> </li>   <li> <p>Can't end with a hyphen or contain two consecutive hyphens</p> </li>  </ul>
    /// - On success, responds with [`DeleteDbClusterOutput`](crate::output::DeleteDbClusterOutput) with field(s):
    ///   - [`db_cluster(Option<DbCluster>)`](crate::output::DeleteDbClusterOutput::db_cluster): <p>Contains the details of an Amazon Aurora DB cluster or Multi-AZ DB cluster.</p>  <p>For an Amazon Aurora DB cluster, this data type is used as a response element in the operations <code>CreateDBCluster</code>, <code>DeleteDBCluster</code>, <code>DescribeDBClusters</code>, <code>FailoverDBCluster</code>, <code>ModifyDBCluster</code>, <code>PromoteReadReplicaDBCluster</code>, <code>RestoreDBClusterFromS3</code>, <code>RestoreDBClusterFromSnapshot</code>, <code>RestoreDBClusterToPointInTime</code>, <code>StartDBCluster</code>, and <code>StopDBCluster</code>.</p>  <p>For a Multi-AZ DB cluster, this data type is used as a response element in the operations <code>CreateDBCluster</code>, <code>DeleteDBCluster</code>, <code>DescribeDBClusters</code>, <code>FailoverDBCluster</code>, <code>ModifyDBCluster</code>, <code>RebootDBCluster</code>, <code>RestoreDBClusterFromSnapshot</code>, and <code>RestoreDBClusterToPointInTime</code>.</p>  <p>For more information on Amazon Aurora DB clusters, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon Aurora?</a> in the <i>Amazon Aurora User Guide.</i> </p>  <p>For more information on Multi-AZ DB clusters, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ deployments with two readable standby DB instances</a> in the <i>Amazon RDS User Guide.</i> </p>
    /// - On failure, responds with [`SdkError<DeleteDBClusterError>`](crate::error::DeleteDBClusterError)
    pub fn delete_db_cluster(&self) -> fluent_builders::DeleteDBCluster {
        fluent_builders::DeleteDBCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteDBClusterEndpoint`](crate::client::fluent_builders::DeleteDBClusterEndpoint) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_cluster_endpoint_identifier(impl Into<String>)`](crate::client::fluent_builders::DeleteDBClusterEndpoint::db_cluster_endpoint_identifier) / [`set_db_cluster_endpoint_identifier(Option<String>)`](crate::client::fluent_builders::DeleteDBClusterEndpoint::set_db_cluster_endpoint_identifier): <p>The identifier associated with the custom endpoint. This parameter is stored as a lowercase string.</p>
    /// - On success, responds with [`DeleteDbClusterEndpointOutput`](crate::output::DeleteDbClusterEndpointOutput) with field(s):
    ///   - [`db_cluster_endpoint_identifier(Option<String>)`](crate::output::DeleteDbClusterEndpointOutput::db_cluster_endpoint_identifier): <p>The identifier associated with the endpoint. This parameter is stored as a lowercase string.</p>
    ///   - [`db_cluster_identifier(Option<String>)`](crate::output::DeleteDbClusterEndpointOutput::db_cluster_identifier): <p>The DB cluster identifier of the DB cluster associated with the endpoint. This parameter is stored as a lowercase string.</p>
    ///   - [`db_cluster_endpoint_resource_identifier(Option<String>)`](crate::output::DeleteDbClusterEndpointOutput::db_cluster_endpoint_resource_identifier): <p>A unique system-generated identifier for an endpoint. It remains the same for the whole life of the endpoint.</p>
    ///   - [`endpoint(Option<String>)`](crate::output::DeleteDbClusterEndpointOutput::endpoint): <p>The DNS address of the endpoint.</p>
    ///   - [`status(Option<String>)`](crate::output::DeleteDbClusterEndpointOutput::status): <p>The current status of the endpoint. One of: <code>creating</code>, <code>available</code>, <code>deleting</code>, <code>inactive</code>, <code>modifying</code>. The <code>inactive</code> state applies to an endpoint that can't be used for a certain kind of cluster, such as a <code>writer</code> endpoint for a read-only secondary cluster in a global database.</p>
    ///   - [`endpoint_type(Option<String>)`](crate::output::DeleteDbClusterEndpointOutput::endpoint_type): <p>The type of the endpoint. One of: <code>READER</code>, <code>WRITER</code>, <code>CUSTOM</code>.</p>
    ///   - [`custom_endpoint_type(Option<String>)`](crate::output::DeleteDbClusterEndpointOutput::custom_endpoint_type): <p>The type associated with a custom endpoint. One of: <code>READER</code>, <code>WRITER</code>, <code>ANY</code>.</p>
    ///   - [`static_members(Option<Vec<String>>)`](crate::output::DeleteDbClusterEndpointOutput::static_members): <p>List of DB instance identifiers that are part of the custom endpoint group.</p>
    ///   - [`excluded_members(Option<Vec<String>>)`](crate::output::DeleteDbClusterEndpointOutput::excluded_members): <p>List of DB instance identifiers that aren't part of the custom endpoint group. All other eligible instances are reachable through the custom endpoint. Only relevant if the list of static members is empty.</p>
    ///   - [`db_cluster_endpoint_arn(Option<String>)`](crate::output::DeleteDbClusterEndpointOutput::db_cluster_endpoint_arn): <p>The Amazon Resource Name (ARN) for the endpoint.</p>
    /// - On failure, responds with [`SdkError<DeleteDBClusterEndpointError>`](crate::error::DeleteDBClusterEndpointError)
    pub fn delete_db_cluster_endpoint(&self) -> fluent_builders::DeleteDBClusterEndpoint {
        fluent_builders::DeleteDBClusterEndpoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteDBClusterParameterGroup`](crate::client::fluent_builders::DeleteDBClusterParameterGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_cluster_parameter_group_name(impl Into<String>)`](crate::client::fluent_builders::DeleteDBClusterParameterGroup::db_cluster_parameter_group_name) / [`set_db_cluster_parameter_group_name(Option<String>)`](crate::client::fluent_builders::DeleteDBClusterParameterGroup::set_db_cluster_parameter_group_name): <p>The name of the DB cluster parameter group.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must be the name of an existing DB cluster parameter group.</p> </li>   <li> <p>You can't delete a default DB cluster parameter group.</p> </li>   <li> <p>Can't be associated with any DB clusters.</p> </li>  </ul>
    /// - On success, responds with [`DeleteDbClusterParameterGroupOutput`](crate::output::DeleteDbClusterParameterGroupOutput)

    /// - On failure, responds with [`SdkError<DeleteDBClusterParameterGroupError>`](crate::error::DeleteDBClusterParameterGroupError)
    pub fn delete_db_cluster_parameter_group(
        &self,
    ) -> fluent_builders::DeleteDBClusterParameterGroup {
        fluent_builders::DeleteDBClusterParameterGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteDBClusterSnapshot`](crate::client::fluent_builders::DeleteDBClusterSnapshot) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_cluster_snapshot_identifier(impl Into<String>)`](crate::client::fluent_builders::DeleteDBClusterSnapshot::db_cluster_snapshot_identifier) / [`set_db_cluster_snapshot_identifier(Option<String>)`](crate::client::fluent_builders::DeleteDBClusterSnapshot::set_db_cluster_snapshot_identifier): <p>The identifier of the DB cluster snapshot to delete.</p>  <p>Constraints: Must be the name of an existing DB cluster snapshot in the <code>available</code> state.</p>
    /// - On success, responds with [`DeleteDbClusterSnapshotOutput`](crate::output::DeleteDbClusterSnapshotOutput) with field(s):
    ///   - [`db_cluster_snapshot(Option<DbClusterSnapshot>)`](crate::output::DeleteDbClusterSnapshotOutput::db_cluster_snapshot): <p>Contains the details for an Amazon RDS DB cluster snapshot</p>  <p>This data type is used as a response element in the <code>DescribeDBClusterSnapshots</code> action.</p>
    /// - On failure, responds with [`SdkError<DeleteDBClusterSnapshotError>`](crate::error::DeleteDBClusterSnapshotError)
    pub fn delete_db_cluster_snapshot(&self) -> fluent_builders::DeleteDBClusterSnapshot {
        fluent_builders::DeleteDBClusterSnapshot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteDBInstance`](crate::client::fluent_builders::DeleteDBInstance) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_instance_identifier(impl Into<String>)`](crate::client::fluent_builders::DeleteDBInstance::db_instance_identifier) / [`set_db_instance_identifier(Option<String>)`](crate::client::fluent_builders::DeleteDBInstance::set_db_instance_identifier): <p>The DB instance identifier for the DB instance to be deleted. This parameter isn't case-sensitive.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must match the name of an existing DB instance.</p> </li>  </ul>
    ///   - [`skip_final_snapshot(bool)`](crate::client::fluent_builders::DeleteDBInstance::skip_final_snapshot) / [`set_skip_final_snapshot(bool)`](crate::client::fluent_builders::DeleteDBInstance::set_skip_final_snapshot): <p>A value that indicates whether to skip the creation of a final DB snapshot before deleting the instance. If you enable this parameter, RDS doesn't create a DB snapshot. If you don't enable this parameter, RDS creates a DB snapshot before the DB instance is deleted. By default, skip isn't enabled, and the DB snapshot is created.</p> <note>   <p>If you don't enable this parameter, you must specify the <code>FinalDBSnapshotIdentifier</code> parameter.</p>  </note>  <p>When a DB instance is in a failure state and has a status of <code>failed</code>, <code>incompatible-restore</code>, or <code>incompatible-network</code>, RDS can delete the instance only if you enable this parameter.</p>  <p>If you delete a read replica or an RDS Custom instance, you must enable this setting.</p>  <p>This setting is required for RDS Custom.</p>
    ///   - [`final_db_snapshot_identifier(impl Into<String>)`](crate::client::fluent_builders::DeleteDBInstance::final_db_snapshot_identifier) / [`set_final_db_snapshot_identifier(Option<String>)`](crate::client::fluent_builders::DeleteDBInstance::set_final_db_snapshot_identifier): <p>The <code>DBSnapshotIdentifier</code> of the new <code>DBSnapshot</code> created when the <code>SkipFinalSnapshot</code> parameter is disabled.</p> <note>   <p>If you enable this parameter and also enable SkipFinalShapshot, the command results in an error.</p>  </note>  <p>This setting doesn't apply to RDS Custom.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must be 1 to 255 letters or numbers.</p> </li>   <li> <p>First character must be a letter.</p> </li>   <li> <p>Can't end with a hyphen or contain two consecutive hyphens.</p> </li>   <li> <p>Can't be specified when deleting a read replica.</p> </li>  </ul>
    ///   - [`delete_automated_backups(bool)`](crate::client::fluent_builders::DeleteDBInstance::delete_automated_backups) / [`set_delete_automated_backups(Option<bool>)`](crate::client::fluent_builders::DeleteDBInstance::set_delete_automated_backups): <p>A value that indicates whether to remove automated backups immediately after the DB instance is deleted. This parameter isn't case-sensitive. The default is to remove automated backups immediately after the DB instance is deleted.</p>
    /// - On success, responds with [`DeleteDbInstanceOutput`](crate::output::DeleteDbInstanceOutput) with field(s):
    ///   - [`db_instance(Option<DbInstance>)`](crate::output::DeleteDbInstanceOutput::db_instance): <p>Contains the details of an Amazon RDS DB instance.</p>  <p>This data type is used as a response element in the operations <code>CreateDBInstance</code>, <code>CreateDBInstanceReadReplica</code>, <code>DeleteDBInstance</code>, <code>DescribeDBInstances</code>, <code>ModifyDBInstance</code>, <code>PromoteReadReplica</code>, <code>RebootDBInstance</code>, <code>RestoreDBInstanceFromDBSnapshot</code>, <code>RestoreDBInstanceFromS3</code>, <code>RestoreDBInstanceToPointInTime</code>, <code>StartDBInstance</code>, and <code>StopDBInstance</code>.</p>
    /// - On failure, responds with [`SdkError<DeleteDBInstanceError>`](crate::error::DeleteDBInstanceError)
    pub fn delete_db_instance(&self) -> fluent_builders::DeleteDBInstance {
        fluent_builders::DeleteDBInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteDBInstanceAutomatedBackup`](crate::client::fluent_builders::DeleteDBInstanceAutomatedBackup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`dbi_resource_id(impl Into<String>)`](crate::client::fluent_builders::DeleteDBInstanceAutomatedBackup::dbi_resource_id) / [`set_dbi_resource_id(Option<String>)`](crate::client::fluent_builders::DeleteDBInstanceAutomatedBackup::set_dbi_resource_id): <p>The identifier for the source DB instance, which can't be changed and which is unique to an Amazon Web Services Region.</p>
    ///   - [`db_instance_automated_backups_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteDBInstanceAutomatedBackup::db_instance_automated_backups_arn) / [`set_db_instance_automated_backups_arn(Option<String>)`](crate::client::fluent_builders::DeleteDBInstanceAutomatedBackup::set_db_instance_automated_backups_arn): <p>The Amazon Resource Name (ARN) of the automated backups to delete, for example, <code>arn:aws:rds:us-east-1:123456789012:auto-backup:ab-L2IJCEXJP7XQ7HOJ4SIEXAMPLE</code>.</p>  <p>This setting doesn't apply to RDS Custom.</p>
    /// - On success, responds with [`DeleteDbInstanceAutomatedBackupOutput`](crate::output::DeleteDbInstanceAutomatedBackupOutput) with field(s):
    ///   - [`db_instance_automated_backup(Option<DbInstanceAutomatedBackup>)`](crate::output::DeleteDbInstanceAutomatedBackupOutput::db_instance_automated_backup): <p>An automated backup of a DB instance. It consists of system backups, transaction logs, and the database instance properties that existed at the time you deleted the source instance.</p>
    /// - On failure, responds with [`SdkError<DeleteDBInstanceAutomatedBackupError>`](crate::error::DeleteDBInstanceAutomatedBackupError)
    pub fn delete_db_instance_automated_backup(
        &self,
    ) -> fluent_builders::DeleteDBInstanceAutomatedBackup {
        fluent_builders::DeleteDBInstanceAutomatedBackup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteDBParameterGroup`](crate::client::fluent_builders::DeleteDBParameterGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_parameter_group_name(impl Into<String>)`](crate::client::fluent_builders::DeleteDBParameterGroup::db_parameter_group_name) / [`set_db_parameter_group_name(Option<String>)`](crate::client::fluent_builders::DeleteDBParameterGroup::set_db_parameter_group_name): <p>The name of the DB parameter group.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must be the name of an existing DB parameter group</p> </li>   <li> <p>You can't delete a default DB parameter group</p> </li>   <li> <p>Can't be associated with any DB instances</p> </li>  </ul>
    /// - On success, responds with [`DeleteDbParameterGroupOutput`](crate::output::DeleteDbParameterGroupOutput)

    /// - On failure, responds with [`SdkError<DeleteDBParameterGroupError>`](crate::error::DeleteDBParameterGroupError)
    pub fn delete_db_parameter_group(&self) -> fluent_builders::DeleteDBParameterGroup {
        fluent_builders::DeleteDBParameterGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteDBProxy`](crate::client::fluent_builders::DeleteDBProxy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_proxy_name(impl Into<String>)`](crate::client::fluent_builders::DeleteDBProxy::db_proxy_name) / [`set_db_proxy_name(Option<String>)`](crate::client::fluent_builders::DeleteDBProxy::set_db_proxy_name): <p>The name of the DB proxy to delete.</p>
    /// - On success, responds with [`DeleteDbProxyOutput`](crate::output::DeleteDbProxyOutput) with field(s):
    ///   - [`db_proxy(Option<DbProxy>)`](crate::output::DeleteDbProxyOutput::db_proxy): <p>The data structure representing the details of the DB proxy that you delete.</p>
    /// - On failure, responds with [`SdkError<DeleteDBProxyError>`](crate::error::DeleteDBProxyError)
    pub fn delete_db_proxy(&self) -> fluent_builders::DeleteDBProxy {
        fluent_builders::DeleteDBProxy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteDBProxyEndpoint`](crate::client::fluent_builders::DeleteDBProxyEndpoint) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_proxy_endpoint_name(impl Into<String>)`](crate::client::fluent_builders::DeleteDBProxyEndpoint::db_proxy_endpoint_name) / [`set_db_proxy_endpoint_name(Option<String>)`](crate::client::fluent_builders::DeleteDBProxyEndpoint::set_db_proxy_endpoint_name): <p>The name of the DB proxy endpoint to delete.</p>
    /// - On success, responds with [`DeleteDbProxyEndpointOutput`](crate::output::DeleteDbProxyEndpointOutput) with field(s):
    ///   - [`db_proxy_endpoint(Option<DbProxyEndpoint>)`](crate::output::DeleteDbProxyEndpointOutput::db_proxy_endpoint): <p>The data structure representing the details of the DB proxy endpoint that you delete.</p>
    /// - On failure, responds with [`SdkError<DeleteDBProxyEndpointError>`](crate::error::DeleteDBProxyEndpointError)
    pub fn delete_db_proxy_endpoint(&self) -> fluent_builders::DeleteDBProxyEndpoint {
        fluent_builders::DeleteDBProxyEndpoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteDBSecurityGroup`](crate::client::fluent_builders::DeleteDBSecurityGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_security_group_name(impl Into<String>)`](crate::client::fluent_builders::DeleteDBSecurityGroup::db_security_group_name) / [`set_db_security_group_name(Option<String>)`](crate::client::fluent_builders::DeleteDBSecurityGroup::set_db_security_group_name): <p>The name of the DB security group to delete.</p> <note>   <p>You can't delete the default DB security group.</p>  </note>  <p>Constraints:</p>  <ul>   <li> <p>Must be 1 to 255 letters, numbers, or hyphens.</p> </li>   <li> <p>First character must be a letter</p> </li>   <li> <p>Can't end with a hyphen or contain two consecutive hyphens</p> </li>   <li> <p>Must not be "Default"</p> </li>  </ul>
    /// - On success, responds with [`DeleteDbSecurityGroupOutput`](crate::output::DeleteDbSecurityGroupOutput)

    /// - On failure, responds with [`SdkError<DeleteDBSecurityGroupError>`](crate::error::DeleteDBSecurityGroupError)
    pub fn delete_db_security_group(&self) -> fluent_builders::DeleteDBSecurityGroup {
        fluent_builders::DeleteDBSecurityGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteDBSnapshot`](crate::client::fluent_builders::DeleteDBSnapshot) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_snapshot_identifier(impl Into<String>)`](crate::client::fluent_builders::DeleteDBSnapshot::db_snapshot_identifier) / [`set_db_snapshot_identifier(Option<String>)`](crate::client::fluent_builders::DeleteDBSnapshot::set_db_snapshot_identifier): <p>The DB snapshot identifier.</p>  <p>Constraints: Must be the name of an existing DB snapshot in the <code>available</code> state.</p>
    /// - On success, responds with [`DeleteDbSnapshotOutput`](crate::output::DeleteDbSnapshotOutput) with field(s):
    ///   - [`db_snapshot(Option<DbSnapshot>)`](crate::output::DeleteDbSnapshotOutput::db_snapshot): <p>Contains the details of an Amazon RDS DB snapshot.</p>  <p>This data type is used as a response element in the <code>DescribeDBSnapshots</code> action.</p>
    /// - On failure, responds with [`SdkError<DeleteDBSnapshotError>`](crate::error::DeleteDBSnapshotError)
    pub fn delete_db_snapshot(&self) -> fluent_builders::DeleteDBSnapshot {
        fluent_builders::DeleteDBSnapshot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteDBSubnetGroup`](crate::client::fluent_builders::DeleteDBSubnetGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_subnet_group_name(impl Into<String>)`](crate::client::fluent_builders::DeleteDBSubnetGroup::db_subnet_group_name) / [`set_db_subnet_group_name(Option<String>)`](crate::client::fluent_builders::DeleteDBSubnetGroup::set_db_subnet_group_name): <p>The name of the database subnet group to delete.</p> <note>   <p>You can't delete the default subnet group.</p>  </note>  <p>Constraints: Must match the name of an existing DBSubnetGroup. Must not be default.</p>  <p>Example: <code>mydbsubnetgroup</code> </p>
    /// - On success, responds with [`DeleteDbSubnetGroupOutput`](crate::output::DeleteDbSubnetGroupOutput)

    /// - On failure, responds with [`SdkError<DeleteDBSubnetGroupError>`](crate::error::DeleteDBSubnetGroupError)
    pub fn delete_db_subnet_group(&self) -> fluent_builders::DeleteDBSubnetGroup {
        fluent_builders::DeleteDBSubnetGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteEventSubscription`](crate::client::fluent_builders::DeleteEventSubscription) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`subscription_name(impl Into<String>)`](crate::client::fluent_builders::DeleteEventSubscription::subscription_name) / [`set_subscription_name(Option<String>)`](crate::client::fluent_builders::DeleteEventSubscription::set_subscription_name): <p>The name of the RDS event notification subscription you want to delete.</p>
    /// - On success, responds with [`DeleteEventSubscriptionOutput`](crate::output::DeleteEventSubscriptionOutput) with field(s):
    ///   - [`event_subscription(Option<EventSubscription>)`](crate::output::DeleteEventSubscriptionOutput::event_subscription): <p>Contains the results of a successful invocation of the <code>DescribeEventSubscriptions</code> action.</p>
    /// - On failure, responds with [`SdkError<DeleteEventSubscriptionError>`](crate::error::DeleteEventSubscriptionError)
    pub fn delete_event_subscription(&self) -> fluent_builders::DeleteEventSubscription {
        fluent_builders::DeleteEventSubscription::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteGlobalCluster`](crate::client::fluent_builders::DeleteGlobalCluster) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`global_cluster_identifier(impl Into<String>)`](crate::client::fluent_builders::DeleteGlobalCluster::global_cluster_identifier) / [`set_global_cluster_identifier(Option<String>)`](crate::client::fluent_builders::DeleteGlobalCluster::set_global_cluster_identifier): <p>The cluster identifier of the global database cluster being deleted.</p>
    /// - On success, responds with [`DeleteGlobalClusterOutput`](crate::output::DeleteGlobalClusterOutput) with field(s):
    ///   - [`global_cluster(Option<GlobalCluster>)`](crate::output::DeleteGlobalClusterOutput::global_cluster): <p>A data type representing an Aurora global database.</p>
    /// - On failure, responds with [`SdkError<DeleteGlobalClusterError>`](crate::error::DeleteGlobalClusterError)
    pub fn delete_global_cluster(&self) -> fluent_builders::DeleteGlobalCluster {
        fluent_builders::DeleteGlobalCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteOptionGroup`](crate::client::fluent_builders::DeleteOptionGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`option_group_name(impl Into<String>)`](crate::client::fluent_builders::DeleteOptionGroup::option_group_name) / [`set_option_group_name(Option<String>)`](crate::client::fluent_builders::DeleteOptionGroup::set_option_group_name): <p>The name of the option group to be deleted.</p> <note>   <p>You can't delete default option groups.</p>  </note>
    /// - On success, responds with [`DeleteOptionGroupOutput`](crate::output::DeleteOptionGroupOutput)

    /// - On failure, responds with [`SdkError<DeleteOptionGroupError>`](crate::error::DeleteOptionGroupError)
    pub fn delete_option_group(&self) -> fluent_builders::DeleteOptionGroup {
        fluent_builders::DeleteOptionGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeregisterDBProxyTargets`](crate::client::fluent_builders::DeregisterDBProxyTargets) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_proxy_name(impl Into<String>)`](crate::client::fluent_builders::DeregisterDBProxyTargets::db_proxy_name) / [`set_db_proxy_name(Option<String>)`](crate::client::fluent_builders::DeregisterDBProxyTargets::set_db_proxy_name): <p>The identifier of the <code>DBProxy</code> that is associated with the <code>DBProxyTargetGroup</code>.</p>
    ///   - [`target_group_name(impl Into<String>)`](crate::client::fluent_builders::DeregisterDBProxyTargets::target_group_name) / [`set_target_group_name(Option<String>)`](crate::client::fluent_builders::DeregisterDBProxyTargets::set_target_group_name): <p>The identifier of the <code>DBProxyTargetGroup</code>.</p>
    ///   - [`db_instance_identifiers(Vec<String>)`](crate::client::fluent_builders::DeregisterDBProxyTargets::db_instance_identifiers) / [`set_db_instance_identifiers(Option<Vec<String>>)`](crate::client::fluent_builders::DeregisterDBProxyTargets::set_db_instance_identifiers): <p>One or more DB instance identifiers.</p>
    ///   - [`db_cluster_identifiers(Vec<String>)`](crate::client::fluent_builders::DeregisterDBProxyTargets::db_cluster_identifiers) / [`set_db_cluster_identifiers(Option<Vec<String>>)`](crate::client::fluent_builders::DeregisterDBProxyTargets::set_db_cluster_identifiers): <p>One or more DB cluster identifiers.</p>
    /// - On success, responds with [`DeregisterDbProxyTargetsOutput`](crate::output::DeregisterDbProxyTargetsOutput)

    /// - On failure, responds with [`SdkError<DeregisterDBProxyTargetsError>`](crate::error::DeregisterDBProxyTargetsError)
    pub fn deregister_db_proxy_targets(&self) -> fluent_builders::DeregisterDBProxyTargets {
        fluent_builders::DeregisterDBProxyTargets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeAccountAttributes`](crate::client::fluent_builders::DescribeAccountAttributes) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::DescribeAccountAttributes::send) it.

    /// - On success, responds with [`DescribeAccountAttributesOutput`](crate::output::DescribeAccountAttributesOutput) with field(s):
    ///   - [`account_quotas(Option<Vec<AccountQuota>>)`](crate::output::DescribeAccountAttributesOutput::account_quotas): <p>A list of <code>AccountQuota</code> objects. Within this list, each quota has a name, a count of usage toward the quota maximum, and a maximum value for the quota.</p>
    /// - On failure, responds with [`SdkError<DescribeAccountAttributesError>`](crate::error::DescribeAccountAttributesError)
    pub fn describe_account_attributes(&self) -> fluent_builders::DescribeAccountAttributes {
        fluent_builders::DescribeAccountAttributes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeCertificates`](crate::client::fluent_builders::DescribeCertificates) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeCertificates::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`certificate_identifier(impl Into<String>)`](crate::client::fluent_builders::DescribeCertificates::certificate_identifier) / [`set_certificate_identifier(Option<String>)`](crate::client::fluent_builders::DescribeCertificates::set_certificate_identifier): <p>The user-supplied certificate identifier. If this parameter is specified, information for only the identified certificate is returned. This parameter isn't case-sensitive.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must match an existing CertificateIdentifier.</p> </li>  </ul>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeCertificates::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeCertificates::set_filters): <p>This parameter isn't currently supported.</p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeCertificates::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeCertificates::set_max_records): <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so you can retrieve the remaining results.</p>  <p>Default: 100</p>  <p>Constraints: Minimum 20, maximum 100.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeCertificates::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeCertificates::set_marker): <p>An optional pagination token provided by a previous <code>DescribeCertificates</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    /// - On success, responds with [`DescribeCertificatesOutput`](crate::output::DescribeCertificatesOutput) with field(s):
    ///   - [`certificates(Option<Vec<Certificate>>)`](crate::output::DescribeCertificatesOutput::certificates): <p>The list of <code>Certificate</code> objects for the Amazon Web Services account.</p>
    ///   - [`marker(Option<String>)`](crate::output::DescribeCertificatesOutput::marker): <p>An optional pagination token provided by a previous <code>DescribeCertificates</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code> .</p>
    /// - On failure, responds with [`SdkError<DescribeCertificatesError>`](crate::error::DescribeCertificatesError)
    pub fn describe_certificates(&self) -> fluent_builders::DescribeCertificates {
        fluent_builders::DescribeCertificates::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeDBClusterBacktracks`](crate::client::fluent_builders::DescribeDBClusterBacktracks) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeDBClusterBacktracks::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_cluster_identifier(impl Into<String>)`](crate::client::fluent_builders::DescribeDBClusterBacktracks::db_cluster_identifier) / [`set_db_cluster_identifier(Option<String>)`](crate::client::fluent_builders::DescribeDBClusterBacktracks::set_db_cluster_identifier): <p>The DB cluster identifier of the DB cluster to be described. This parameter is stored as a lowercase string.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must contain from 1 to 63 alphanumeric characters or hyphens.</p> </li>   <li> <p>First character must be a letter.</p> </li>   <li> <p>Can't end with a hyphen or contain two consecutive hyphens.</p> </li>  </ul>  <p>Example: <code>my-cluster1</code> </p>
    ///   - [`backtrack_identifier(impl Into<String>)`](crate::client::fluent_builders::DescribeDBClusterBacktracks::backtrack_identifier) / [`set_backtrack_identifier(Option<String>)`](crate::client::fluent_builders::DescribeDBClusterBacktracks::set_backtrack_identifier): <p>If specified, this value is the backtrack identifier of the backtrack to be described.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must contain a valid universally unique identifier (UUID). For more information about UUIDs, see <a href="http://www.ietf.org/rfc/rfc4122.txt">A Universally Unique Identifier (UUID) URN Namespace</a>.</p> </li>  </ul>  <p>Example: <code>123e4567-e89b-12d3-a456-426655440000</code> </p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeDBClusterBacktracks::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeDBClusterBacktracks::set_filters): <p>A filter that specifies one or more DB clusters to describe. Supported filters include the following:</p>  <ul>   <li> <p> <code>db-cluster-backtrack-id</code> - Accepts backtrack identifiers. The results list includes information about only the backtracks identified by these identifiers.</p> </li>   <li> <p> <code>db-cluster-backtrack-status</code> - Accepts any of the following backtrack status values:</p>    <ul>     <li> <p> <code>applying</code> </p> </li>     <li> <p> <code>completed</code> </p> </li>     <li> <p> <code>failed</code> </p> </li>     <li> <p> <code>pending</code> </p> </li>    </ul> <p>The results list includes information about only the backtracks identified by these values.</p> </li>  </ul>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeDBClusterBacktracks::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeDBClusterBacktracks::set_max_records): <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so you can retrieve the remaining results.</p>  <p>Default: 100</p>  <p>Constraints: Minimum 20, maximum 100.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeDBClusterBacktracks::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeDBClusterBacktracks::set_marker): <p>An optional pagination token provided by a previous <code>DescribeDBClusterBacktracks</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    /// - On success, responds with [`DescribeDbClusterBacktracksOutput`](crate::output::DescribeDbClusterBacktracksOutput) with field(s):
    ///   - [`marker(Option<String>)`](crate::output::DescribeDbClusterBacktracksOutput::marker): <p>A pagination token that can be used in a later <code>DescribeDBClusterBacktracks</code> request.</p>
    ///   - [`db_cluster_backtracks(Option<Vec<DbClusterBacktrack>>)`](crate::output::DescribeDbClusterBacktracksOutput::db_cluster_backtracks): <p>Contains a list of backtracks for the user.</p>
    /// - On failure, responds with [`SdkError<DescribeDBClusterBacktracksError>`](crate::error::DescribeDBClusterBacktracksError)
    pub fn describe_db_cluster_backtracks(&self) -> fluent_builders::DescribeDBClusterBacktracks {
        fluent_builders::DescribeDBClusterBacktracks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeDBClusterEndpoints`](crate::client::fluent_builders::DescribeDBClusterEndpoints) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeDBClusterEndpoints::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_cluster_identifier(impl Into<String>)`](crate::client::fluent_builders::DescribeDBClusterEndpoints::db_cluster_identifier) / [`set_db_cluster_identifier(Option<String>)`](crate::client::fluent_builders::DescribeDBClusterEndpoints::set_db_cluster_identifier): <p>The DB cluster identifier of the DB cluster associated with the endpoint. This parameter is stored as a lowercase string.</p>
    ///   - [`db_cluster_endpoint_identifier(impl Into<String>)`](crate::client::fluent_builders::DescribeDBClusterEndpoints::db_cluster_endpoint_identifier) / [`set_db_cluster_endpoint_identifier(Option<String>)`](crate::client::fluent_builders::DescribeDBClusterEndpoints::set_db_cluster_endpoint_identifier): <p>The identifier of the endpoint to describe. This parameter is stored as a lowercase string.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeDBClusterEndpoints::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeDBClusterEndpoints::set_filters): <p>A set of name-value pairs that define which endpoints to include in the output. The filters are specified as name-value pairs, in the format <code>Name=<i>endpoint_type</i>,Values=<i>endpoint_type1</i>,<i>endpoint_type2</i>,...</code>. <code>Name</code> can be one of: <code>db-cluster-endpoint-type</code>, <code>db-cluster-endpoint-custom-type</code>, <code>db-cluster-endpoint-id</code>, <code>db-cluster-endpoint-status</code>. <code>Values</code> for the <code> db-cluster-endpoint-type</code> filter can be one or more of: <code>reader</code>, <code>writer</code>, <code>custom</code>. <code>Values</code> for the <code>db-cluster-endpoint-custom-type</code> filter can be one or more of: <code>reader</code>, <code>any</code>. <code>Values</code> for the <code>db-cluster-endpoint-status</code> filter can be one or more of: <code>available</code>, <code>creating</code>, <code>deleting</code>, <code>inactive</code>, <code>modifying</code>.</p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeDBClusterEndpoints::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeDBClusterEndpoints::set_max_records): <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so you can retrieve the remaining results.</p>  <p>Default: 100</p>  <p>Constraints: Minimum 20, maximum 100.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeDBClusterEndpoints::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeDBClusterEndpoints::set_marker): <p>An optional pagination token provided by a previous <code>DescribeDBClusterEndpoints</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    /// - On success, responds with [`DescribeDbClusterEndpointsOutput`](crate::output::DescribeDbClusterEndpointsOutput) with field(s):
    ///   - [`marker(Option<String>)`](crate::output::DescribeDbClusterEndpointsOutput::marker): <p>An optional pagination token provided by a previous <code>DescribeDBClusterEndpoints</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    ///   - [`db_cluster_endpoints(Option<Vec<DbClusterEndpoint>>)`](crate::output::DescribeDbClusterEndpointsOutput::db_cluster_endpoints): <p>Contains the details of the endpoints associated with the cluster and matching any filter conditions.</p>
    /// - On failure, responds with [`SdkError<DescribeDBClusterEndpointsError>`](crate::error::DescribeDBClusterEndpointsError)
    pub fn describe_db_cluster_endpoints(&self) -> fluent_builders::DescribeDBClusterEndpoints {
        fluent_builders::DescribeDBClusterEndpoints::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeDBClusterParameterGroups`](crate::client::fluent_builders::DescribeDBClusterParameterGroups) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeDBClusterParameterGroups::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_cluster_parameter_group_name(impl Into<String>)`](crate::client::fluent_builders::DescribeDBClusterParameterGroups::db_cluster_parameter_group_name) / [`set_db_cluster_parameter_group_name(Option<String>)`](crate::client::fluent_builders::DescribeDBClusterParameterGroups::set_db_cluster_parameter_group_name): <p>The name of a specific DB cluster parameter group to return details for.</p>  <p>Constraints:</p>  <ul>   <li> <p>If supplied, must match the name of an existing DBClusterParameterGroup.</p> </li>  </ul>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeDBClusterParameterGroups::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeDBClusterParameterGroups::set_filters): <p>This parameter isn't currently supported.</p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeDBClusterParameterGroups::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeDBClusterParameterGroups::set_max_records): <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so you can retrieve the remaining results.</p>  <p>Default: 100</p>  <p>Constraints: Minimum 20, maximum 100.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeDBClusterParameterGroups::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeDBClusterParameterGroups::set_marker): <p>An optional pagination token provided by a previous <code>DescribeDBClusterParameterGroups</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    /// - On success, responds with [`DescribeDbClusterParameterGroupsOutput`](crate::output::DescribeDbClusterParameterGroupsOutput) with field(s):
    ///   - [`marker(Option<String>)`](crate::output::DescribeDbClusterParameterGroupsOutput::marker): <p>An optional pagination token provided by a previous <code>DescribeDBClusterParameterGroups</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    ///   - [`db_cluster_parameter_groups(Option<Vec<DbClusterParameterGroup>>)`](crate::output::DescribeDbClusterParameterGroupsOutput::db_cluster_parameter_groups): <p>A list of DB cluster parameter groups.</p>
    /// - On failure, responds with [`SdkError<DescribeDBClusterParameterGroupsError>`](crate::error::DescribeDBClusterParameterGroupsError)
    pub fn describe_db_cluster_parameter_groups(
        &self,
    ) -> fluent_builders::DescribeDBClusterParameterGroups {
        fluent_builders::DescribeDBClusterParameterGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeDBClusterParameters`](crate::client::fluent_builders::DescribeDBClusterParameters) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeDBClusterParameters::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_cluster_parameter_group_name(impl Into<String>)`](crate::client::fluent_builders::DescribeDBClusterParameters::db_cluster_parameter_group_name) / [`set_db_cluster_parameter_group_name(Option<String>)`](crate::client::fluent_builders::DescribeDBClusterParameters::set_db_cluster_parameter_group_name): <p>The name of a specific DB cluster parameter group to return parameter details for.</p>  <p>Constraints:</p>  <ul>   <li> <p>If supplied, must match the name of an existing DBClusterParameterGroup.</p> </li>  </ul>
    ///   - [`source(impl Into<String>)`](crate::client::fluent_builders::DescribeDBClusterParameters::source) / [`set_source(Option<String>)`](crate::client::fluent_builders::DescribeDBClusterParameters::set_source): <p>A value that indicates to return only parameters for a specific source. Parameter sources can be <code>engine</code>, <code>service</code>, or <code>customer</code>.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeDBClusterParameters::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeDBClusterParameters::set_filters): <p>This parameter isn't currently supported.</p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeDBClusterParameters::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeDBClusterParameters::set_max_records): <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so you can retrieve the remaining results.</p>  <p>Default: 100</p>  <p>Constraints: Minimum 20, maximum 100.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeDBClusterParameters::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeDBClusterParameters::set_marker): <p>An optional pagination token provided by a previous <code>DescribeDBClusterParameters</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    /// - On success, responds with [`DescribeDbClusterParametersOutput`](crate::output::DescribeDbClusterParametersOutput) with field(s):
    ///   - [`parameters(Option<Vec<Parameter>>)`](crate::output::DescribeDbClusterParametersOutput::parameters): <p>Provides a list of parameters for the DB cluster parameter group.</p>
    ///   - [`marker(Option<String>)`](crate::output::DescribeDbClusterParametersOutput::marker): <p>An optional pagination token provided by a previous <code>DescribeDBClusterParameters</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    /// - On failure, responds with [`SdkError<DescribeDBClusterParametersError>`](crate::error::DescribeDBClusterParametersError)
    pub fn describe_db_cluster_parameters(&self) -> fluent_builders::DescribeDBClusterParameters {
        fluent_builders::DescribeDBClusterParameters::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeDBClusters`](crate::client::fluent_builders::DescribeDBClusters) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeDBClusters::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_cluster_identifier(impl Into<String>)`](crate::client::fluent_builders::DescribeDBClusters::db_cluster_identifier) / [`set_db_cluster_identifier(Option<String>)`](crate::client::fluent_builders::DescribeDBClusters::set_db_cluster_identifier): <p>The user-supplied DB cluster identifier. If this parameter is specified, information from only the specific DB cluster is returned. This parameter isn't case-sensitive.</p>  <p>Constraints:</p>  <ul>   <li> <p>If supplied, must match an existing DBClusterIdentifier.</p> </li>  </ul>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeDBClusters::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeDBClusters::set_filters): <p>A filter that specifies one or more DB clusters to describe.</p>  <p>Supported filters:</p>  <ul>   <li> <p> <code>clone-group-id</code> - Accepts clone group identifiers. The results list only includes information about the DB clusters associated with these clone groups.</p> </li>   <li> <p> <code>db-cluster-id</code> - Accepts DB cluster identifiers and DB cluster Amazon Resource Names (ARNs). The results list only includes information about the DB clusters identified by these ARNs.</p> </li>   <li> <p> <code>domain</code> - Accepts Active Directory directory IDs. The results list only includes information about the DB clusters associated with these domains.</p> </li>   <li> <p> <code>engine</code> - Accepts engine names. The results list only includes information about the DB clusters for these engines.</p> </li>  </ul>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeDBClusters::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeDBClusters::set_max_records): <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so you can retrieve the remaining results.</p>  <p>Default: 100</p>  <p>Constraints: Minimum 20, maximum 100.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeDBClusters::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeDBClusters::set_marker): <p>An optional pagination token provided by a previous <code>DescribeDBClusters</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    ///   - [`include_shared(bool)`](crate::client::fluent_builders::DescribeDBClusters::include_shared) / [`set_include_shared(bool)`](crate::client::fluent_builders::DescribeDBClusters::set_include_shared): <p>Optional Boolean parameter that specifies whether the output includes information about clusters shared from other Amazon Web Services accounts.</p>
    /// - On success, responds with [`DescribeDbClustersOutput`](crate::output::DescribeDbClustersOutput) with field(s):
    ///   - [`marker(Option<String>)`](crate::output::DescribeDbClustersOutput::marker): <p>A pagination token that can be used in a later DescribeDBClusters request.</p>
    ///   - [`db_clusters(Option<Vec<DbCluster>>)`](crate::output::DescribeDbClustersOutput::db_clusters): <p>Contains a list of DB clusters for the user.</p>
    /// - On failure, responds with [`SdkError<DescribeDBClustersError>`](crate::error::DescribeDBClustersError)
    pub fn describe_db_clusters(&self) -> fluent_builders::DescribeDBClusters {
        fluent_builders::DescribeDBClusters::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeDBClusterSnapshotAttributes`](crate::client::fluent_builders::DescribeDBClusterSnapshotAttributes) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_cluster_snapshot_identifier(impl Into<String>)`](crate::client::fluent_builders::DescribeDBClusterSnapshotAttributes::db_cluster_snapshot_identifier) / [`set_db_cluster_snapshot_identifier(Option<String>)`](crate::client::fluent_builders::DescribeDBClusterSnapshotAttributes::set_db_cluster_snapshot_identifier): <p>The identifier for the DB cluster snapshot to describe the attributes for.</p>
    /// - On success, responds with [`DescribeDbClusterSnapshotAttributesOutput`](crate::output::DescribeDbClusterSnapshotAttributesOutput) with field(s):
    ///   - [`db_cluster_snapshot_attributes_result(Option<DbClusterSnapshotAttributesResult>)`](crate::output::DescribeDbClusterSnapshotAttributesOutput::db_cluster_snapshot_attributes_result): <p>Contains the results of a successful call to the <code>DescribeDBClusterSnapshotAttributes</code> API action.</p>  <p>Manual DB cluster snapshot attributes are used to authorize other Amazon Web Services accounts to copy or restore a manual DB cluster snapshot. For more information, see the <code>ModifyDBClusterSnapshotAttribute</code> API action.</p>
    /// - On failure, responds with [`SdkError<DescribeDBClusterSnapshotAttributesError>`](crate::error::DescribeDBClusterSnapshotAttributesError)
    pub fn describe_db_cluster_snapshot_attributes(
        &self,
    ) -> fluent_builders::DescribeDBClusterSnapshotAttributes {
        fluent_builders::DescribeDBClusterSnapshotAttributes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeDBClusterSnapshots`](crate::client::fluent_builders::DescribeDBClusterSnapshots) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeDBClusterSnapshots::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_cluster_identifier(impl Into<String>)`](crate::client::fluent_builders::DescribeDBClusterSnapshots::db_cluster_identifier) / [`set_db_cluster_identifier(Option<String>)`](crate::client::fluent_builders::DescribeDBClusterSnapshots::set_db_cluster_identifier): <p>The ID of the DB cluster to retrieve the list of DB cluster snapshots for. This parameter can't be used in conjunction with the <code>DBClusterSnapshotIdentifier</code> parameter. This parameter isn't case-sensitive.</p>  <p>Constraints:</p>  <ul>   <li> <p>If supplied, must match the identifier of an existing DBCluster.</p> </li>  </ul>
    ///   - [`db_cluster_snapshot_identifier(impl Into<String>)`](crate::client::fluent_builders::DescribeDBClusterSnapshots::db_cluster_snapshot_identifier) / [`set_db_cluster_snapshot_identifier(Option<String>)`](crate::client::fluent_builders::DescribeDBClusterSnapshots::set_db_cluster_snapshot_identifier): <p>A specific DB cluster snapshot identifier to describe. This parameter can't be used in conjunction with the <code>DBClusterIdentifier</code> parameter. This value is stored as a lowercase string.</p>  <p>Constraints:</p>  <ul>   <li> <p>If supplied, must match the identifier of an existing DBClusterSnapshot.</p> </li>   <li> <p>If this identifier is for an automated snapshot, the <code>SnapshotType</code> parameter must also be specified.</p> </li>  </ul>
    ///   - [`snapshot_type(impl Into<String>)`](crate::client::fluent_builders::DescribeDBClusterSnapshots::snapshot_type) / [`set_snapshot_type(Option<String>)`](crate::client::fluent_builders::DescribeDBClusterSnapshots::set_snapshot_type): <p>The type of DB cluster snapshots to be returned. You can specify one of the following values:</p>  <ul>   <li> <p> <code>automated</code> - Return all DB cluster snapshots that have been automatically taken by Amazon RDS for my Amazon Web Services account.</p> </li>   <li> <p> <code>manual</code> - Return all DB cluster snapshots that have been taken by my Amazon Web Services account.</p> </li>   <li> <p> <code>shared</code> - Return all manual DB cluster snapshots that have been shared to my Amazon Web Services account.</p> </li>   <li> <p> <code>public</code> - Return all DB cluster snapshots that have been marked as public.</p> </li>  </ul>  <p>If you don't specify a <code>SnapshotType</code> value, then both automated and manual DB cluster snapshots are returned. You can include shared DB cluster snapshots with these results by enabling the <code>IncludeShared</code> parameter. You can include public DB cluster snapshots with these results by enabling the <code>IncludePublic</code> parameter.</p>  <p>The <code>IncludeShared</code> and <code>IncludePublic</code> parameters don't apply for <code>SnapshotType</code> values of <code>manual</code> or <code>automated</code>. The <code>IncludePublic</code> parameter doesn't apply when <code>SnapshotType</code> is set to <code>shared</code>. The <code>IncludeShared</code> parameter doesn't apply when <code>SnapshotType</code> is set to <code>public</code>.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeDBClusterSnapshots::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeDBClusterSnapshots::set_filters): <p>A filter that specifies one or more DB cluster snapshots to describe.</p>  <p>Supported filters:</p>  <ul>   <li> <p> <code>db-cluster-id</code> - Accepts DB cluster identifiers and DB cluster Amazon Resource Names (ARNs).</p> </li>   <li> <p> <code>db-cluster-snapshot-id</code> - Accepts DB cluster snapshot identifiers.</p> </li>   <li> <p> <code>snapshot-type</code> - Accepts types of DB cluster snapshots.</p> </li>   <li> <p> <code>engine</code> - Accepts names of database engines.</p> </li>  </ul>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeDBClusterSnapshots::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeDBClusterSnapshots::set_max_records): <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so you can retrieve the remaining results.</p>  <p>Default: 100</p>  <p>Constraints: Minimum 20, maximum 100.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeDBClusterSnapshots::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeDBClusterSnapshots::set_marker): <p>An optional pagination token provided by a previous <code>DescribeDBClusterSnapshots</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    ///   - [`include_shared(bool)`](crate::client::fluent_builders::DescribeDBClusterSnapshots::include_shared) / [`set_include_shared(bool)`](crate::client::fluent_builders::DescribeDBClusterSnapshots::set_include_shared): <p>A value that indicates whether to include shared manual DB cluster snapshots from other Amazon Web Services accounts that this Amazon Web Services account has been given permission to copy or restore. By default, these snapshots are not included.</p>  <p>You can give an Amazon Web Services account permission to restore a manual DB cluster snapshot from another Amazon Web Services account by the <code>ModifyDBClusterSnapshotAttribute</code> API action.</p>
    ///   - [`include_public(bool)`](crate::client::fluent_builders::DescribeDBClusterSnapshots::include_public) / [`set_include_public(bool)`](crate::client::fluent_builders::DescribeDBClusterSnapshots::set_include_public): <p>A value that indicates whether to include manual DB cluster snapshots that are public and can be copied or restored by any Amazon Web Services account. By default, the public snapshots are not included.</p>  <p>You can share a manual DB cluster snapshot as public by using the <code>ModifyDBClusterSnapshotAttribute</code> API action.</p>
    /// - On success, responds with [`DescribeDbClusterSnapshotsOutput`](crate::output::DescribeDbClusterSnapshotsOutput) with field(s):
    ///   - [`marker(Option<String>)`](crate::output::DescribeDbClusterSnapshotsOutput::marker): <p>An optional pagination token provided by a previous <code>DescribeDBClusterSnapshots</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    ///   - [`db_cluster_snapshots(Option<Vec<DbClusterSnapshot>>)`](crate::output::DescribeDbClusterSnapshotsOutput::db_cluster_snapshots): <p>Provides a list of DB cluster snapshots for the user.</p>
    /// - On failure, responds with [`SdkError<DescribeDBClusterSnapshotsError>`](crate::error::DescribeDBClusterSnapshotsError)
    pub fn describe_db_cluster_snapshots(&self) -> fluent_builders::DescribeDBClusterSnapshots {
        fluent_builders::DescribeDBClusterSnapshots::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeDBEngineVersions`](crate::client::fluent_builders::DescribeDBEngineVersions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeDBEngineVersions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`engine(impl Into<String>)`](crate::client::fluent_builders::DescribeDBEngineVersions::engine) / [`set_engine(Option<String>)`](crate::client::fluent_builders::DescribeDBEngineVersions::set_engine): <p>The database engine to return.</p>  <p>Valid Values:</p>  <ul>   <li> <p> <code>aurora</code> (for MySQL 5.6-compatible Aurora)</p> </li>   <li> <p> <code>aurora-mysql</code> (for MySQL 5.7-compatible and MySQL 8.0-compatible Aurora)</p> </li>   <li> <p> <code>aurora-postgresql</code> </p> </li>   <li> <p> <code>mariadb</code> </p> </li>   <li> <p> <code>mysql</code> </p> </li>   <li> <p> <code>oracle-ee</code> </p> </li>   <li> <p> <code>oracle-ee-cdb</code> </p> </li>   <li> <p> <code>oracle-se2</code> </p> </li>   <li> <p> <code>oracle-se2-cdb</code> </p> </li>   <li> <p> <code>postgres</code> </p> </li>   <li> <p> <code>sqlserver-ee</code> </p> </li>   <li> <p> <code>sqlserver-se</code> </p> </li>   <li> <p> <code>sqlserver-ex</code> </p> </li>   <li> <p> <code>sqlserver-web</code> </p> </li>  </ul>
    ///   - [`engine_version(impl Into<String>)`](crate::client::fluent_builders::DescribeDBEngineVersions::engine_version) / [`set_engine_version(Option<String>)`](crate::client::fluent_builders::DescribeDBEngineVersions::set_engine_version): <p>The database engine version to return.</p>  <p>Example: <code>5.1.49</code> </p>
    ///   - [`db_parameter_group_family(impl Into<String>)`](crate::client::fluent_builders::DescribeDBEngineVersions::db_parameter_group_family) / [`set_db_parameter_group_family(Option<String>)`](crate::client::fluent_builders::DescribeDBEngineVersions::set_db_parameter_group_family): <p>The name of a specific DB parameter group family to return details for.</p>  <p>Constraints:</p>  <ul>   <li> <p>If supplied, must match an existing DBParameterGroupFamily.</p> </li>  </ul>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeDBEngineVersions::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeDBEngineVersions::set_filters): <p>A filter that specifies one or more DB engine versions to describe.</p>  <p>Supported filters:</p>  <ul>   <li> <p> <code>db-parameter-group-family</code> - Accepts parameter groups family names. The results list only includes information about the DB engine versions for these parameter group families.</p> </li>   <li> <p> <code>engine</code> - Accepts engine names. The results list only includes information about the DB engine versions for these engines.</p> </li>   <li> <p> <code>engine-mode</code> - Accepts DB engine modes. The results list only includes information about the DB engine versions for these engine modes. Valid DB engine modes are the following:</p>    <ul>     <li> <p> <code>global</code> </p> </li>     <li> <p> <code>multimaster</code> </p> </li>     <li> <p> <code>parallelquery</code> </p> </li>     <li> <p> <code>provisioned</code> </p> </li>     <li> <p> <code>serverless</code> </p> </li>    </ul> </li>   <li> <p> <code>engine-version</code> - Accepts engine versions. The results list only includes information about the DB engine versions for these engine versions.</p> </li>   <li> <p> <code>status</code> - Accepts engine version statuses. The results list only includes information about the DB engine versions for these statuses. Valid statuses are the following:</p>    <ul>     <li> <p> <code>available</code> </p> </li>     <li> <p> <code>deprecated</code> </p> </li>    </ul> </li>  </ul>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeDBEngineVersions::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeDBEngineVersions::set_max_records): <p>The maximum number of records to include in the response. If more than the <code>MaxRecords</code> value is available, a pagination token called a marker is included in the response so you can retrieve the remaining results.</p>  <p>Default: 100</p>  <p>Constraints: Minimum 20, maximum 100.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeDBEngineVersions::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeDBEngineVersions::set_marker): <p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    ///   - [`default_only(bool)`](crate::client::fluent_builders::DescribeDBEngineVersions::default_only) / [`set_default_only(bool)`](crate::client::fluent_builders::DescribeDBEngineVersions::set_default_only): <p>A value that indicates whether only the default version of the specified engine or engine and major version combination is returned.</p>
    ///   - [`list_supported_character_sets(bool)`](crate::client::fluent_builders::DescribeDBEngineVersions::list_supported_character_sets) / [`set_list_supported_character_sets(Option<bool>)`](crate::client::fluent_builders::DescribeDBEngineVersions::set_list_supported_character_sets): <p>A value that indicates whether to list the supported character sets for each engine version.</p>  <p>If this parameter is enabled and the requested engine supports the <code>CharacterSetName</code> parameter for <code>CreateDBInstance</code>, the response includes a list of supported character sets for each engine version.</p>  <p>For RDS Custom, the default is not to list supported character sets. If you set <code>ListSupportedCharacterSets</code> to <code>true</code>, RDS Custom returns no results.</p>
    ///   - [`list_supported_timezones(bool)`](crate::client::fluent_builders::DescribeDBEngineVersions::list_supported_timezones) / [`set_list_supported_timezones(Option<bool>)`](crate::client::fluent_builders::DescribeDBEngineVersions::set_list_supported_timezones): <p>A value that indicates whether to list the supported time zones for each engine version.</p>  <p>If this parameter is enabled and the requested engine supports the <code>TimeZone</code> parameter for <code>CreateDBInstance</code>, the response includes a list of supported time zones for each engine version.</p>  <p>For RDS Custom, the default is not to list supported time zones. If you set <code>ListSupportedTimezones</code> to <code>true</code>, RDS Custom returns no results.</p>
    ///   - [`include_all(bool)`](crate::client::fluent_builders::DescribeDBEngineVersions::include_all) / [`set_include_all(Option<bool>)`](crate::client::fluent_builders::DescribeDBEngineVersions::set_include_all): <p>A value that indicates whether to include engine versions that aren't available in the list. The default is to list only available engine versions.</p>
    /// - On success, responds with [`DescribeDbEngineVersionsOutput`](crate::output::DescribeDbEngineVersionsOutput) with field(s):
    ///   - [`marker(Option<String>)`](crate::output::DescribeDbEngineVersionsOutput::marker): <p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    ///   - [`db_engine_versions(Option<Vec<DbEngineVersion>>)`](crate::output::DescribeDbEngineVersionsOutput::db_engine_versions): <p>A list of <code>DBEngineVersion</code> elements.</p>
    /// - On failure, responds with [`SdkError<DescribeDBEngineVersionsError>`](crate::error::DescribeDBEngineVersionsError)
    pub fn describe_db_engine_versions(&self) -> fluent_builders::DescribeDBEngineVersions {
        fluent_builders::DescribeDBEngineVersions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeDBInstanceAutomatedBackups`](crate::client::fluent_builders::DescribeDBInstanceAutomatedBackups) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeDBInstanceAutomatedBackups::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`dbi_resource_id(impl Into<String>)`](crate::client::fluent_builders::DescribeDBInstanceAutomatedBackups::dbi_resource_id) / [`set_dbi_resource_id(Option<String>)`](crate::client::fluent_builders::DescribeDBInstanceAutomatedBackups::set_dbi_resource_id): <p>The resource ID of the DB instance that is the source of the automated backup. This parameter isn't case-sensitive.</p>
    ///   - [`db_instance_identifier(impl Into<String>)`](crate::client::fluent_builders::DescribeDBInstanceAutomatedBackups::db_instance_identifier) / [`set_db_instance_identifier(Option<String>)`](crate::client::fluent_builders::DescribeDBInstanceAutomatedBackups::set_db_instance_identifier): <p>(Optional) The user-supplied instance identifier. If this parameter is specified, it must match the identifier of an existing DB instance. It returns information from the specific DB instance' automated backup. This parameter isn't case-sensitive.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeDBInstanceAutomatedBackups::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeDBInstanceAutomatedBackups::set_filters): <p>A filter that specifies which resources to return based on status.</p>  <p>Supported filters are the following:</p>  <ul>   <li> <p> <code>status</code> </p>    <ul>     <li> <p> <code>active</code> - automated backups for current instances</p> </li>     <li> <p> <code>retained</code> - automated backups for deleted instances and after backup replication is stopped</p> </li>     <li> <p> <code>creating</code> - automated backups that are waiting for the first automated snapshot to be available</p> </li>    </ul> </li>   <li> <p> <code>db-instance-id</code> - Accepts DB instance identifiers and Amazon Resource Names (ARNs). The results list includes only information about the DB instance automated backups identified by these ARNs.</p> </li>   <li> <p> <code>dbi-resource-id</code> - Accepts DB resource identifiers and Amazon Resource Names (ARNs). The results list includes only information about the DB instance resources identified by these ARNs.</p> </li>  </ul>  <p>Returns all resources by default. The status for each resource is specified in the response.</p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeDBInstanceAutomatedBackups::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeDBInstanceAutomatedBackups::set_max_records): <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that you can retrieve the remaining results.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeDBInstanceAutomatedBackups::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeDBInstanceAutomatedBackups::set_marker): <p>The pagination token provided in the previous request. If this parameter is specified the response includes only records beyond the marker, up to <code>MaxRecords</code>.</p>
    ///   - [`db_instance_automated_backups_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeDBInstanceAutomatedBackups::db_instance_automated_backups_arn) / [`set_db_instance_automated_backups_arn(Option<String>)`](crate::client::fluent_builders::DescribeDBInstanceAutomatedBackups::set_db_instance_automated_backups_arn): <p>The Amazon Resource Name (ARN) of the replicated automated backups, for example, <code>arn:aws:rds:us-east-1:123456789012:auto-backup:ab-L2IJCEXJP7XQ7HOJ4SIEXAMPLE</code>.</p>  <p>This setting doesn't apply to RDS Custom.</p>
    /// - On success, responds with [`DescribeDbInstanceAutomatedBackupsOutput`](crate::output::DescribeDbInstanceAutomatedBackupsOutput) with field(s):
    ///   - [`marker(Option<String>)`](crate::output::DescribeDbInstanceAutomatedBackupsOutput::marker): <p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    ///   - [`db_instance_automated_backups(Option<Vec<DbInstanceAutomatedBackup>>)`](crate::output::DescribeDbInstanceAutomatedBackupsOutput::db_instance_automated_backups): <p>A list of <code>DBInstanceAutomatedBackup</code> instances.</p>
    /// - On failure, responds with [`SdkError<DescribeDBInstanceAutomatedBackupsError>`](crate::error::DescribeDBInstanceAutomatedBackupsError)
    pub fn describe_db_instance_automated_backups(
        &self,
    ) -> fluent_builders::DescribeDBInstanceAutomatedBackups {
        fluent_builders::DescribeDBInstanceAutomatedBackups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeDBInstances`](crate::client::fluent_builders::DescribeDBInstances) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeDBInstances::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_instance_identifier(impl Into<String>)`](crate::client::fluent_builders::DescribeDBInstances::db_instance_identifier) / [`set_db_instance_identifier(Option<String>)`](crate::client::fluent_builders::DescribeDBInstances::set_db_instance_identifier): <p>The user-supplied instance identifier. If this parameter is specified, information from only the specific DB instance is returned. This parameter isn't case-sensitive.</p>  <p>Constraints:</p>  <ul>   <li> <p>If supplied, must match the identifier of an existing DBInstance.</p> </li>  </ul>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeDBInstances::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeDBInstances::set_filters): <p>A filter that specifies one or more DB instances to describe.</p>  <p>Supported filters:</p>  <ul>   <li> <p> <code>db-cluster-id</code> - Accepts DB cluster identifiers and DB cluster Amazon Resource Names (ARNs). The results list only includes information about the DB instances associated with the DB clusters identified by these ARNs.</p> </li>   <li> <p> <code>db-instance-id</code> - Accepts DB instance identifiers and DB instance Amazon Resource Names (ARNs). The results list only includes information about the DB instances identified by these ARNs.</p> </li>   <li> <p> <code>dbi-resource-id</code> - Accepts DB instance resource identifiers. The results list will only include information about the DB instances identified by these DB instance resource identifiers.</p> </li>   <li> <p> <code>domain</code> - Accepts Active Directory directory IDs. The results list only includes information about the DB instances associated with these domains.</p> </li>   <li> <p> <code>engine</code> - Accepts engine names. The results list only includes information about the DB instances for these engines.</p> </li>  </ul>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeDBInstances::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeDBInstances::set_max_records): <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that you can retrieve the remaining results.</p>  <p>Default: 100</p>  <p>Constraints: Minimum 20, maximum 100.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeDBInstances::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeDBInstances::set_marker): <p>An optional pagination token provided by a previous <code>DescribeDBInstances</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    /// - On success, responds with [`DescribeDbInstancesOutput`](crate::output::DescribeDbInstancesOutput) with field(s):
    ///   - [`marker(Option<String>)`](crate::output::DescribeDbInstancesOutput::marker): <p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code> .</p>
    ///   - [`db_instances(Option<Vec<DbInstance>>)`](crate::output::DescribeDbInstancesOutput::db_instances): <p>A list of <code>DBInstance</code> instances.</p>
    /// - On failure, responds with [`SdkError<DescribeDBInstancesError>`](crate::error::DescribeDBInstancesError)
    pub fn describe_db_instances(&self) -> fluent_builders::DescribeDBInstances {
        fluent_builders::DescribeDBInstances::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeDBLogFiles`](crate::client::fluent_builders::DescribeDBLogFiles) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeDBLogFiles::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_instance_identifier(impl Into<String>)`](crate::client::fluent_builders::DescribeDBLogFiles::db_instance_identifier) / [`set_db_instance_identifier(Option<String>)`](crate::client::fluent_builders::DescribeDBLogFiles::set_db_instance_identifier): <p>The customer-assigned name of the DB instance that contains the log files you want to list.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must match the identifier of an existing DBInstance.</p> </li>  </ul>
    ///   - [`filename_contains(impl Into<String>)`](crate::client::fluent_builders::DescribeDBLogFiles::filename_contains) / [`set_filename_contains(Option<String>)`](crate::client::fluent_builders::DescribeDBLogFiles::set_filename_contains): <p>Filters the available log files for log file names that contain the specified string.</p>
    ///   - [`file_last_written(i64)`](crate::client::fluent_builders::DescribeDBLogFiles::file_last_written) / [`set_file_last_written(i64)`](crate::client::fluent_builders::DescribeDBLogFiles::set_file_last_written): <p>Filters the available log files for files written since the specified date, in POSIX timestamp format with milliseconds.</p>
    ///   - [`file_size(i64)`](crate::client::fluent_builders::DescribeDBLogFiles::file_size) / [`set_file_size(i64)`](crate::client::fluent_builders::DescribeDBLogFiles::set_file_size): <p>Filters the available log files for files larger than the specified size.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeDBLogFiles::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeDBLogFiles::set_filters): <p>This parameter isn't currently supported.</p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeDBLogFiles::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeDBLogFiles::set_max_records): <p>The maximum number of records to include in the response. If more records exist than the specified MaxRecords value, a pagination token called a marker is included in the response so you can retrieve the remaining results.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeDBLogFiles::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeDBLogFiles::set_marker): <p>The pagination token provided in the previous request. If this parameter is specified the response includes only records beyond the marker, up to MaxRecords.</p>
    /// - On success, responds with [`DescribeDbLogFilesOutput`](crate::output::DescribeDbLogFilesOutput) with field(s):
    ///   - [`describe_db_log_files(Option<Vec<DescribeDbLogFilesDetails>>)`](crate::output::DescribeDbLogFilesOutput::describe_db_log_files): <p>The DB log files returned.</p>
    ///   - [`marker(Option<String>)`](crate::output::DescribeDbLogFilesOutput::marker): <p>A pagination token that can be used in a later <code>DescribeDBLogFiles</code> request.</p>
    /// - On failure, responds with [`SdkError<DescribeDBLogFilesError>`](crate::error::DescribeDBLogFilesError)
    pub fn describe_db_log_files(&self) -> fluent_builders::DescribeDBLogFiles {
        fluent_builders::DescribeDBLogFiles::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeDBParameterGroups`](crate::client::fluent_builders::DescribeDBParameterGroups) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeDBParameterGroups::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_parameter_group_name(impl Into<String>)`](crate::client::fluent_builders::DescribeDBParameterGroups::db_parameter_group_name) / [`set_db_parameter_group_name(Option<String>)`](crate::client::fluent_builders::DescribeDBParameterGroups::set_db_parameter_group_name): <p>The name of a specific DB parameter group to return details for.</p>  <p>Constraints:</p>  <ul>   <li> <p>If supplied, must match the name of an existing DBClusterParameterGroup.</p> </li>  </ul>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeDBParameterGroups::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeDBParameterGroups::set_filters): <p>This parameter isn't currently supported.</p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeDBParameterGroups::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeDBParameterGroups::set_max_records): <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that you can retrieve the remaining results.</p>  <p>Default: 100</p>  <p>Constraints: Minimum 20, maximum 100.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeDBParameterGroups::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeDBParameterGroups::set_marker): <p>An optional pagination token provided by a previous <code>DescribeDBParameterGroups</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    /// - On success, responds with [`DescribeDbParameterGroupsOutput`](crate::output::DescribeDbParameterGroupsOutput) with field(s):
    ///   - [`marker(Option<String>)`](crate::output::DescribeDbParameterGroupsOutput::marker): <p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    ///   - [`db_parameter_groups(Option<Vec<DbParameterGroup>>)`](crate::output::DescribeDbParameterGroupsOutput::db_parameter_groups): <p>A list of <code>DBParameterGroup</code> instances.</p>
    /// - On failure, responds with [`SdkError<DescribeDBParameterGroupsError>`](crate::error::DescribeDBParameterGroupsError)
    pub fn describe_db_parameter_groups(&self) -> fluent_builders::DescribeDBParameterGroups {
        fluent_builders::DescribeDBParameterGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeDBParameters`](crate::client::fluent_builders::DescribeDBParameters) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeDBParameters::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_parameter_group_name(impl Into<String>)`](crate::client::fluent_builders::DescribeDBParameters::db_parameter_group_name) / [`set_db_parameter_group_name(Option<String>)`](crate::client::fluent_builders::DescribeDBParameters::set_db_parameter_group_name): <p>The name of a specific DB parameter group to return details for.</p>  <p>Constraints:</p>  <ul>   <li> <p>If supplied, must match the name of an existing DBParameterGroup.</p> </li>  </ul>
    ///   - [`source(impl Into<String>)`](crate::client::fluent_builders::DescribeDBParameters::source) / [`set_source(Option<String>)`](crate::client::fluent_builders::DescribeDBParameters::set_source): <p>The parameter types to return.</p>  <p>Default: All parameter types returned</p>  <p>Valid Values: <code>user | system | engine-default</code> </p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeDBParameters::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeDBParameters::set_filters): <p>This parameter isn't currently supported.</p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeDBParameters::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeDBParameters::set_max_records): <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that you can retrieve the remaining results.</p>  <p>Default: 100</p>  <p>Constraints: Minimum 20, maximum 100.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeDBParameters::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeDBParameters::set_marker): <p>An optional pagination token provided by a previous <code>DescribeDBParameters</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    /// - On success, responds with [`DescribeDbParametersOutput`](crate::output::DescribeDbParametersOutput) with field(s):
    ///   - [`parameters(Option<Vec<Parameter>>)`](crate::output::DescribeDbParametersOutput::parameters): <p>A list of <code>Parameter</code> values.</p>
    ///   - [`marker(Option<String>)`](crate::output::DescribeDbParametersOutput::marker): <p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    /// - On failure, responds with [`SdkError<DescribeDBParametersError>`](crate::error::DescribeDBParametersError)
    pub fn describe_db_parameters(&self) -> fluent_builders::DescribeDBParameters {
        fluent_builders::DescribeDBParameters::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeDBProxies`](crate::client::fluent_builders::DescribeDBProxies) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeDBProxies::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_proxy_name(impl Into<String>)`](crate::client::fluent_builders::DescribeDBProxies::db_proxy_name) / [`set_db_proxy_name(Option<String>)`](crate::client::fluent_builders::DescribeDBProxies::set_db_proxy_name): <p>The name of the DB proxy. If you omit this parameter, the output includes information about all DB proxies owned by your Amazon Web Services account ID.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeDBProxies::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeDBProxies::set_filters): <p>This parameter is not currently supported.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeDBProxies::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeDBProxies::set_marker): <p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeDBProxies::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeDBProxies::set_max_records): <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.</p>  <p>Default: 100</p>  <p>Constraints: Minimum 20, maximum 100.</p>
    /// - On success, responds with [`DescribeDbProxiesOutput`](crate::output::DescribeDbProxiesOutput) with field(s):
    ///   - [`db_proxies(Option<Vec<DbProxy>>)`](crate::output::DescribeDbProxiesOutput::db_proxies): <p>A return value representing an arbitrary number of <code>DBProxy</code> data structures.</p>
    ///   - [`marker(Option<String>)`](crate::output::DescribeDbProxiesOutput::marker): <p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    /// - On failure, responds with [`SdkError<DescribeDBProxiesError>`](crate::error::DescribeDBProxiesError)
    pub fn describe_db_proxies(&self) -> fluent_builders::DescribeDBProxies {
        fluent_builders::DescribeDBProxies::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeDBProxyEndpoints`](crate::client::fluent_builders::DescribeDBProxyEndpoints) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeDBProxyEndpoints::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_proxy_name(impl Into<String>)`](crate::client::fluent_builders::DescribeDBProxyEndpoints::db_proxy_name) / [`set_db_proxy_name(Option<String>)`](crate::client::fluent_builders::DescribeDBProxyEndpoints::set_db_proxy_name): <p>The name of the DB proxy whose endpoints you want to describe. If you omit this parameter, the output includes information about all DB proxy endpoints associated with all your DB proxies.</p>
    ///   - [`db_proxy_endpoint_name(impl Into<String>)`](crate::client::fluent_builders::DescribeDBProxyEndpoints::db_proxy_endpoint_name) / [`set_db_proxy_endpoint_name(Option<String>)`](crate::client::fluent_builders::DescribeDBProxyEndpoints::set_db_proxy_endpoint_name): <p>The name of a DB proxy endpoint to describe. If you omit this parameter, the output includes information about all DB proxy endpoints associated with the specified proxy.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeDBProxyEndpoints::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeDBProxyEndpoints::set_filters): <p>This parameter is not currently supported.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeDBProxyEndpoints::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeDBProxyEndpoints::set_marker): <p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeDBProxyEndpoints::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeDBProxyEndpoints::set_max_records): <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.</p>  <p>Default: 100</p>  <p>Constraints: Minimum 20, maximum 100.</p>
    /// - On success, responds with [`DescribeDbProxyEndpointsOutput`](crate::output::DescribeDbProxyEndpointsOutput) with field(s):
    ///   - [`db_proxy_endpoints(Option<Vec<DbProxyEndpoint>>)`](crate::output::DescribeDbProxyEndpointsOutput::db_proxy_endpoints): <p>The list of <code>ProxyEndpoint</code> objects returned by the API operation.</p>
    ///   - [`marker(Option<String>)`](crate::output::DescribeDbProxyEndpointsOutput::marker): <p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    /// - On failure, responds with [`SdkError<DescribeDBProxyEndpointsError>`](crate::error::DescribeDBProxyEndpointsError)
    pub fn describe_db_proxy_endpoints(&self) -> fluent_builders::DescribeDBProxyEndpoints {
        fluent_builders::DescribeDBProxyEndpoints::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeDBProxyTargetGroups`](crate::client::fluent_builders::DescribeDBProxyTargetGroups) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeDBProxyTargetGroups::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_proxy_name(impl Into<String>)`](crate::client::fluent_builders::DescribeDBProxyTargetGroups::db_proxy_name) / [`set_db_proxy_name(Option<String>)`](crate::client::fluent_builders::DescribeDBProxyTargetGroups::set_db_proxy_name): <p>The identifier of the <code>DBProxy</code> associated with the target group.</p>
    ///   - [`target_group_name(impl Into<String>)`](crate::client::fluent_builders::DescribeDBProxyTargetGroups::target_group_name) / [`set_target_group_name(Option<String>)`](crate::client::fluent_builders::DescribeDBProxyTargetGroups::set_target_group_name): <p>The identifier of the <code>DBProxyTargetGroup</code> to describe.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeDBProxyTargetGroups::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeDBProxyTargetGroups::set_filters): <p>This parameter is not currently supported.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeDBProxyTargetGroups::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeDBProxyTargetGroups::set_marker): <p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeDBProxyTargetGroups::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeDBProxyTargetGroups::set_max_records): <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.</p>  <p>Default: 100</p>  <p>Constraints: Minimum 20, maximum 100.</p>
    /// - On success, responds with [`DescribeDbProxyTargetGroupsOutput`](crate::output::DescribeDbProxyTargetGroupsOutput) with field(s):
    ///   - [`target_groups(Option<Vec<DbProxyTargetGroup>>)`](crate::output::DescribeDbProxyTargetGroupsOutput::target_groups): <p>An arbitrary number of <code>DBProxyTargetGroup</code> objects, containing details of the corresponding target groups.</p>
    ///   - [`marker(Option<String>)`](crate::output::DescribeDbProxyTargetGroupsOutput::marker): <p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    /// - On failure, responds with [`SdkError<DescribeDBProxyTargetGroupsError>`](crate::error::DescribeDBProxyTargetGroupsError)
    pub fn describe_db_proxy_target_groups(&self) -> fluent_builders::DescribeDBProxyTargetGroups {
        fluent_builders::DescribeDBProxyTargetGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeDBProxyTargets`](crate::client::fluent_builders::DescribeDBProxyTargets) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeDBProxyTargets::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_proxy_name(impl Into<String>)`](crate::client::fluent_builders::DescribeDBProxyTargets::db_proxy_name) / [`set_db_proxy_name(Option<String>)`](crate::client::fluent_builders::DescribeDBProxyTargets::set_db_proxy_name): <p>The identifier of the <code>DBProxyTarget</code> to describe.</p>
    ///   - [`target_group_name(impl Into<String>)`](crate::client::fluent_builders::DescribeDBProxyTargets::target_group_name) / [`set_target_group_name(Option<String>)`](crate::client::fluent_builders::DescribeDBProxyTargets::set_target_group_name): <p>The identifier of the <code>DBProxyTargetGroup</code> to describe.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeDBProxyTargets::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeDBProxyTargets::set_filters): <p>This parameter is not currently supported.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeDBProxyTargets::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeDBProxyTargets::set_marker): <p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeDBProxyTargets::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeDBProxyTargets::set_max_records): <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that the remaining results can be retrieved.</p>  <p>Default: 100</p>  <p>Constraints: Minimum 20, maximum 100.</p>
    /// - On success, responds with [`DescribeDbProxyTargetsOutput`](crate::output::DescribeDbProxyTargetsOutput) with field(s):
    ///   - [`targets(Option<Vec<DbProxyTarget>>)`](crate::output::DescribeDbProxyTargetsOutput::targets): <p>An arbitrary number of <code>DBProxyTarget</code> objects, containing details of the corresponding targets.</p>
    ///   - [`marker(Option<String>)`](crate::output::DescribeDbProxyTargetsOutput::marker): <p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    /// - On failure, responds with [`SdkError<DescribeDBProxyTargetsError>`](crate::error::DescribeDBProxyTargetsError)
    pub fn describe_db_proxy_targets(&self) -> fluent_builders::DescribeDBProxyTargets {
        fluent_builders::DescribeDBProxyTargets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeDBSecurityGroups`](crate::client::fluent_builders::DescribeDBSecurityGroups) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeDBSecurityGroups::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_security_group_name(impl Into<String>)`](crate::client::fluent_builders::DescribeDBSecurityGroups::db_security_group_name) / [`set_db_security_group_name(Option<String>)`](crate::client::fluent_builders::DescribeDBSecurityGroups::set_db_security_group_name): <p>The name of the DB security group to return details for.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeDBSecurityGroups::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeDBSecurityGroups::set_filters): <p>This parameter isn't currently supported.</p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeDBSecurityGroups::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeDBSecurityGroups::set_max_records): <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that you can retrieve the remaining results.</p>  <p>Default: 100</p>  <p>Constraints: Minimum 20, maximum 100.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeDBSecurityGroups::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeDBSecurityGroups::set_marker): <p>An optional pagination token provided by a previous <code>DescribeDBSecurityGroups</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    /// - On success, responds with [`DescribeDbSecurityGroupsOutput`](crate::output::DescribeDbSecurityGroupsOutput) with field(s):
    ///   - [`marker(Option<String>)`](crate::output::DescribeDbSecurityGroupsOutput::marker): <p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    ///   - [`db_security_groups(Option<Vec<DbSecurityGroup>>)`](crate::output::DescribeDbSecurityGroupsOutput::db_security_groups): <p>A list of <code>DBSecurityGroup</code> instances.</p>
    /// - On failure, responds with [`SdkError<DescribeDBSecurityGroupsError>`](crate::error::DescribeDBSecurityGroupsError)
    pub fn describe_db_security_groups(&self) -> fluent_builders::DescribeDBSecurityGroups {
        fluent_builders::DescribeDBSecurityGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeDBSnapshotAttributes`](crate::client::fluent_builders::DescribeDBSnapshotAttributes) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_snapshot_identifier(impl Into<String>)`](crate::client::fluent_builders::DescribeDBSnapshotAttributes::db_snapshot_identifier) / [`set_db_snapshot_identifier(Option<String>)`](crate::client::fluent_builders::DescribeDBSnapshotAttributes::set_db_snapshot_identifier): <p>The identifier for the DB snapshot to describe the attributes for.</p>
    /// - On success, responds with [`DescribeDbSnapshotAttributesOutput`](crate::output::DescribeDbSnapshotAttributesOutput) with field(s):
    ///   - [`db_snapshot_attributes_result(Option<DbSnapshotAttributesResult>)`](crate::output::DescribeDbSnapshotAttributesOutput::db_snapshot_attributes_result): <p>Contains the results of a successful call to the <code>DescribeDBSnapshotAttributes</code> API action.</p>  <p>Manual DB snapshot attributes are used to authorize other Amazon Web Services accounts to copy or restore a manual DB snapshot. For more information, see the <code>ModifyDBSnapshotAttribute</code> API action.</p>
    /// - On failure, responds with [`SdkError<DescribeDBSnapshotAttributesError>`](crate::error::DescribeDBSnapshotAttributesError)
    pub fn describe_db_snapshot_attributes(&self) -> fluent_builders::DescribeDBSnapshotAttributes {
        fluent_builders::DescribeDBSnapshotAttributes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeDBSnapshots`](crate::client::fluent_builders::DescribeDBSnapshots) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeDBSnapshots::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_instance_identifier(impl Into<String>)`](crate::client::fluent_builders::DescribeDBSnapshots::db_instance_identifier) / [`set_db_instance_identifier(Option<String>)`](crate::client::fluent_builders::DescribeDBSnapshots::set_db_instance_identifier): <p>The ID of the DB instance to retrieve the list of DB snapshots for. This parameter can't be used in conjunction with <code>DBSnapshotIdentifier</code>. This parameter isn't case-sensitive.</p>  <p>Constraints:</p>  <ul>   <li> <p>If supplied, must match the identifier of an existing DBInstance.</p> </li>  </ul>
    ///   - [`db_snapshot_identifier(impl Into<String>)`](crate::client::fluent_builders::DescribeDBSnapshots::db_snapshot_identifier) / [`set_db_snapshot_identifier(Option<String>)`](crate::client::fluent_builders::DescribeDBSnapshots::set_db_snapshot_identifier): <p>A specific DB snapshot identifier to describe. This parameter can't be used in conjunction with <code>DBInstanceIdentifier</code>. This value is stored as a lowercase string.</p>  <p>Constraints:</p>  <ul>   <li> <p>If supplied, must match the identifier of an existing DBSnapshot.</p> </li>   <li> <p>If this identifier is for an automated snapshot, the <code>SnapshotType</code> parameter must also be specified.</p> </li>  </ul>
    ///   - [`snapshot_type(impl Into<String>)`](crate::client::fluent_builders::DescribeDBSnapshots::snapshot_type) / [`set_snapshot_type(Option<String>)`](crate::client::fluent_builders::DescribeDBSnapshots::set_snapshot_type): <p>The type of snapshots to be returned. You can specify one of the following values:</p>  <ul>   <li> <p> <code>automated</code> - Return all DB snapshots that have been automatically taken by Amazon RDS for my Amazon Web Services account.</p> </li>   <li> <p> <code>manual</code> - Return all DB snapshots that have been taken by my Amazon Web Services account.</p> </li>   <li> <p> <code>shared</code> - Return all manual DB snapshots that have been shared to my Amazon Web Services account.</p> </li>   <li> <p> <code>public</code> - Return all DB snapshots that have been marked as public.</p> </li>   <li> <p> <code>awsbackup</code> - Return the DB snapshots managed by the Amazon Web Services Backup service.</p> <p>For information about Amazon Web Services Backup, see the <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/whatisbackup.html"> <i>Amazon Web Services Backup Developer Guide.</i> </a> </p> <p>The <code>awsbackup</code> type does not apply to Aurora.</p> </li>  </ul>  <p>If you don't specify a <code>SnapshotType</code> value, then both automated and manual snapshots are returned. Shared and public DB snapshots are not included in the returned results by default. You can include shared snapshots with these results by enabling the <code>IncludeShared</code> parameter. You can include public snapshots with these results by enabling the <code>IncludePublic</code> parameter.</p>  <p>The <code>IncludeShared</code> and <code>IncludePublic</code> parameters don't apply for <code>SnapshotType</code> values of <code>manual</code> or <code>automated</code>. The <code>IncludePublic</code> parameter doesn't apply when <code>SnapshotType</code> is set to <code>shared</code>. The <code>IncludeShared</code> parameter doesn't apply when <code>SnapshotType</code> is set to <code>public</code>.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeDBSnapshots::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeDBSnapshots::set_filters): <p>A filter that specifies one or more DB snapshots to describe.</p>  <p>Supported filters:</p>  <ul>   <li> <p> <code>db-instance-id</code> - Accepts DB instance identifiers and DB instance Amazon Resource Names (ARNs).</p> </li>   <li> <p> <code>db-snapshot-id</code> - Accepts DB snapshot identifiers.</p> </li>   <li> <p> <code>dbi-resource-id</code> - Accepts identifiers of source DB instances.</p> </li>   <li> <p> <code>snapshot-type</code> - Accepts types of DB snapshots.</p> </li>   <li> <p> <code>engine</code> - Accepts names of database engines.</p> </li>  </ul>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeDBSnapshots::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeDBSnapshots::set_max_records): <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that you can retrieve the remaining results.</p>  <p>Default: 100</p>  <p>Constraints: Minimum 20, maximum 100.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeDBSnapshots::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeDBSnapshots::set_marker): <p>An optional pagination token provided by a previous <code>DescribeDBSnapshots</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    ///   - [`include_shared(bool)`](crate::client::fluent_builders::DescribeDBSnapshots::include_shared) / [`set_include_shared(bool)`](crate::client::fluent_builders::DescribeDBSnapshots::set_include_shared): <p>A value that indicates whether to include shared manual DB cluster snapshots from other Amazon Web Services accounts that this Amazon Web Services account has been given permission to copy or restore. By default, these snapshots are not included.</p>  <p>You can give an Amazon Web Services account permission to restore a manual DB snapshot from another Amazon Web Services account by using the <code>ModifyDBSnapshotAttribute</code> API action.</p>  <p>This setting doesn't apply to RDS Custom.</p>
    ///   - [`include_public(bool)`](crate::client::fluent_builders::DescribeDBSnapshots::include_public) / [`set_include_public(bool)`](crate::client::fluent_builders::DescribeDBSnapshots::set_include_public): <p>A value that indicates whether to include manual DB cluster snapshots that are public and can be copied or restored by any Amazon Web Services account. By default, the public snapshots are not included.</p>  <p>You can share a manual DB snapshot as public by using the <code>ModifyDBSnapshotAttribute</code> API.</p>  <p>This setting doesn't apply to RDS Custom.</p>
    ///   - [`dbi_resource_id(impl Into<String>)`](crate::client::fluent_builders::DescribeDBSnapshots::dbi_resource_id) / [`set_dbi_resource_id(Option<String>)`](crate::client::fluent_builders::DescribeDBSnapshots::set_dbi_resource_id): <p>A specific DB resource ID to describe.</p>
    /// - On success, responds with [`DescribeDbSnapshotsOutput`](crate::output::DescribeDbSnapshotsOutput) with field(s):
    ///   - [`marker(Option<String>)`](crate::output::DescribeDbSnapshotsOutput::marker): <p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    ///   - [`db_snapshots(Option<Vec<DbSnapshot>>)`](crate::output::DescribeDbSnapshotsOutput::db_snapshots): <p>A list of <code>DBSnapshot</code> instances.</p>
    /// - On failure, responds with [`SdkError<DescribeDBSnapshotsError>`](crate::error::DescribeDBSnapshotsError)
    pub fn describe_db_snapshots(&self) -> fluent_builders::DescribeDBSnapshots {
        fluent_builders::DescribeDBSnapshots::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeDBSubnetGroups`](crate::client::fluent_builders::DescribeDBSubnetGroups) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeDBSubnetGroups::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_subnet_group_name(impl Into<String>)`](crate::client::fluent_builders::DescribeDBSubnetGroups::db_subnet_group_name) / [`set_db_subnet_group_name(Option<String>)`](crate::client::fluent_builders::DescribeDBSubnetGroups::set_db_subnet_group_name): <p>The name of the DB subnet group to return details for.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeDBSubnetGroups::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeDBSubnetGroups::set_filters): <p>This parameter isn't currently supported.</p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeDBSubnetGroups::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeDBSubnetGroups::set_max_records): <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that you can retrieve the remaining results.</p>  <p>Default: 100</p>  <p>Constraints: Minimum 20, maximum 100.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeDBSubnetGroups::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeDBSubnetGroups::set_marker): <p>An optional pagination token provided by a previous DescribeDBSubnetGroups request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    /// - On success, responds with [`DescribeDbSubnetGroupsOutput`](crate::output::DescribeDbSubnetGroupsOutput) with field(s):
    ///   - [`marker(Option<String>)`](crate::output::DescribeDbSubnetGroupsOutput::marker): <p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    ///   - [`db_subnet_groups(Option<Vec<DbSubnetGroup>>)`](crate::output::DescribeDbSubnetGroupsOutput::db_subnet_groups): <p>A list of <code>DBSubnetGroup</code> instances.</p>
    /// - On failure, responds with [`SdkError<DescribeDBSubnetGroupsError>`](crate::error::DescribeDBSubnetGroupsError)
    pub fn describe_db_subnet_groups(&self) -> fluent_builders::DescribeDBSubnetGroups {
        fluent_builders::DescribeDBSubnetGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeEngineDefaultClusterParameters`](crate::client::fluent_builders::DescribeEngineDefaultClusterParameters) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_parameter_group_family(impl Into<String>)`](crate::client::fluent_builders::DescribeEngineDefaultClusterParameters::db_parameter_group_family) / [`set_db_parameter_group_family(Option<String>)`](crate::client::fluent_builders::DescribeEngineDefaultClusterParameters::set_db_parameter_group_family): <p>The name of the DB cluster parameter group family to return engine parameter information for.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeEngineDefaultClusterParameters::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeEngineDefaultClusterParameters::set_filters): <p>This parameter isn't currently supported.</p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeEngineDefaultClusterParameters::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeEngineDefaultClusterParameters::set_max_records): <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so you can retrieve the remaining results.</p>  <p>Default: 100</p>  <p>Constraints: Minimum 20, maximum 100.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeEngineDefaultClusterParameters::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeEngineDefaultClusterParameters::set_marker): <p>An optional pagination token provided by a previous <code>DescribeEngineDefaultClusterParameters</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    /// - On success, responds with [`DescribeEngineDefaultClusterParametersOutput`](crate::output::DescribeEngineDefaultClusterParametersOutput) with field(s):
    ///   - [`engine_defaults(Option<EngineDefaults>)`](crate::output::DescribeEngineDefaultClusterParametersOutput::engine_defaults): <p>Contains the result of a successful invocation of the <code>DescribeEngineDefaultParameters</code> action.</p>
    /// - On failure, responds with [`SdkError<DescribeEngineDefaultClusterParametersError>`](crate::error::DescribeEngineDefaultClusterParametersError)
    pub fn describe_engine_default_cluster_parameters(
        &self,
    ) -> fluent_builders::DescribeEngineDefaultClusterParameters {
        fluent_builders::DescribeEngineDefaultClusterParameters::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeEngineDefaultParameters`](crate::client::fluent_builders::DescribeEngineDefaultParameters) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeEngineDefaultParameters::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_parameter_group_family(impl Into<String>)`](crate::client::fluent_builders::DescribeEngineDefaultParameters::db_parameter_group_family) / [`set_db_parameter_group_family(Option<String>)`](crate::client::fluent_builders::DescribeEngineDefaultParameters::set_db_parameter_group_family): <p>The name of the DB parameter group family.</p>  <p>Valid Values:</p>  <ul>   <li> <p> <code>aurora5.6</code> </p> </li>   <li> <p> <code>aurora-mysql5.7</code> </p> </li>   <li> <p> <code>aurora-mysql8.0</code> </p> </li>   <li> <p> <code>aurora-postgresql10</code> </p> </li>   <li> <p> <code>aurora-postgresql11</code> </p> </li>   <li> <p> <code>aurora-postgresql12</code> </p> </li>   <li> <p> <code>aurora-postgresql13</code> </p> </li>   <li> <p> <code>mariadb10.2</code> </p> </li>   <li> <p> <code>mariadb10.3</code> </p> </li>   <li> <p> <code>mariadb10.4</code> </p> </li>   <li> <p> <code>mariadb10.5</code> </p> </li>   <li> <p> <code>mariadb10.6</code> </p> </li>   <li> <p> <code>mysql5.7</code> </p> </li>   <li> <p> <code>mysql8.0</code> </p> </li>   <li> <p> <code>postgres10</code> </p> </li>   <li> <p> <code>postgres11</code> </p> </li>   <li> <p> <code>postgres12</code> </p> </li>   <li> <p> <code>postgres13</code> </p> </li>   <li> <p> <code>postgres14</code> </p> </li>   <li> <p> <code>sqlserver-ee-11.0</code> </p> </li>   <li> <p> <code>sqlserver-ee-12.0</code> </p> </li>   <li> <p> <code>sqlserver-ee-13.0</code> </p> </li>   <li> <p> <code>sqlserver-ee-14.0</code> </p> </li>   <li> <p> <code>sqlserver-ee-15.0</code> </p> </li>   <li> <p> <code>sqlserver-ex-11.0</code> </p> </li>   <li> <p> <code>sqlserver-ex-12.0</code> </p> </li>   <li> <p> <code>sqlserver-ex-13.0</code> </p> </li>   <li> <p> <code>sqlserver-ex-14.0</code> </p> </li>   <li> <p> <code>sqlserver-ex-15.0</code> </p> </li>   <li> <p> <code>sqlserver-se-11.0</code> </p> </li>   <li> <p> <code>sqlserver-se-12.0</code> </p> </li>   <li> <p> <code>sqlserver-se-13.0</code> </p> </li>   <li> <p> <code>sqlserver-se-14.0</code> </p> </li>   <li> <p> <code>sqlserver-se-15.0</code> </p> </li>   <li> <p> <code>sqlserver-web-11.0</code> </p> </li>   <li> <p> <code>sqlserver-web-12.0</code> </p> </li>   <li> <p> <code>sqlserver-web-13.0</code> </p> </li>   <li> <p> <code>sqlserver-web-14.0</code> </p> </li>   <li> <p> <code>sqlserver-web-15.0</code> </p> </li>  </ul>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeEngineDefaultParameters::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeEngineDefaultParameters::set_filters): <p>This parameter isn't currently supported.</p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeEngineDefaultParameters::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeEngineDefaultParameters::set_max_records): <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so you can retrieve the remaining results.</p>  <p>Default: 100</p>  <p>Constraints: Minimum 20, maximum 100.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeEngineDefaultParameters::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeEngineDefaultParameters::set_marker): <p>An optional pagination token provided by a previous <code>DescribeEngineDefaultParameters</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    /// - On success, responds with [`DescribeEngineDefaultParametersOutput`](crate::output::DescribeEngineDefaultParametersOutput) with field(s):
    ///   - [`engine_defaults(Option<EngineDefaults>)`](crate::output::DescribeEngineDefaultParametersOutput::engine_defaults): <p>Contains the result of a successful invocation of the <code>DescribeEngineDefaultParameters</code> action.</p>
    /// - On failure, responds with [`SdkError<DescribeEngineDefaultParametersError>`](crate::error::DescribeEngineDefaultParametersError)
    pub fn describe_engine_default_parameters(
        &self,
    ) -> fluent_builders::DescribeEngineDefaultParameters {
        fluent_builders::DescribeEngineDefaultParameters::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeEventCategories`](crate::client::fluent_builders::DescribeEventCategories) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`source_type(impl Into<String>)`](crate::client::fluent_builders::DescribeEventCategories::source_type) / [`set_source_type(Option<String>)`](crate::client::fluent_builders::DescribeEventCategories::set_source_type): <p>The type of source that is generating the events. For RDS Proxy events, specify <code>db-proxy</code>.</p>  <p>Valid values: <code>db-instance</code> | <code>db-cluster</code> | <code>db-parameter-group</code> | <code>db-security-group</code> | <code>db-snapshot</code> | <code>db-cluster-snapshot</code> | <code>db-proxy</code> </p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeEventCategories::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeEventCategories::set_filters): <p>This parameter isn't currently supported.</p>
    /// - On success, responds with [`DescribeEventCategoriesOutput`](crate::output::DescribeEventCategoriesOutput) with field(s):
    ///   - [`event_categories_map_list(Option<Vec<EventCategoriesMap>>)`](crate::output::DescribeEventCategoriesOutput::event_categories_map_list): <p>A list of <code>EventCategoriesMap</code> data types.</p>
    /// - On failure, responds with [`SdkError<DescribeEventCategoriesError>`](crate::error::DescribeEventCategoriesError)
    pub fn describe_event_categories(&self) -> fluent_builders::DescribeEventCategories {
        fluent_builders::DescribeEventCategories::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeEvents`](crate::client::fluent_builders::DescribeEvents) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeEvents::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`source_identifier(impl Into<String>)`](crate::client::fluent_builders::DescribeEvents::source_identifier) / [`set_source_identifier(Option<String>)`](crate::client::fluent_builders::DescribeEvents::set_source_identifier): <p>The identifier of the event source for which events are returned. If not specified, then all sources are included in the response.</p>  <p>Constraints:</p>  <ul>   <li> <p>If <code>SourceIdentifier</code> is supplied, <code>SourceType</code> must also be provided.</p> </li>   <li> <p>If the source type is a DB instance, a <code>DBInstanceIdentifier</code> value must be supplied.</p> </li>   <li> <p>If the source type is a DB cluster, a <code>DBClusterIdentifier</code> value must be supplied.</p> </li>   <li> <p>If the source type is a DB parameter group, a <code>DBParameterGroupName</code> value must be supplied.</p> </li>   <li> <p>If the source type is a DB security group, a <code>DBSecurityGroupName</code> value must be supplied.</p> </li>   <li> <p>If the source type is a DB snapshot, a <code>DBSnapshotIdentifier</code> value must be supplied.</p> </li>   <li> <p>If the source type is a DB cluster snapshot, a <code>DBClusterSnapshotIdentifier</code> value must be supplied.</p> </li>   <li> <p>If the source type is an RDS Proxy, a <code>DBProxyName</code> value must be supplied.</p> </li>   <li> <p>Can't end with a hyphen or contain two consecutive hyphens.</p> </li>  </ul>
    ///   - [`source_type(SourceType)`](crate::client::fluent_builders::DescribeEvents::source_type) / [`set_source_type(Option<SourceType>)`](crate::client::fluent_builders::DescribeEvents::set_source_type): <p>The event source to retrieve events for. If no value is specified, all events are returned.</p>
    ///   - [`start_time(DateTime)`](crate::client::fluent_builders::DescribeEvents::start_time) / [`set_start_time(Option<DateTime>)`](crate::client::fluent_builders::DescribeEvents::set_start_time): <p>The beginning of the time interval to retrieve events for, specified in ISO 8601 format. For more information about ISO 8601, go to the <a href="http://en.wikipedia.org/wiki/ISO_8601">ISO8601 Wikipedia page.</a> </p>  <p>Example: 2009-07-08T18:00Z</p>
    ///   - [`end_time(DateTime)`](crate::client::fluent_builders::DescribeEvents::end_time) / [`set_end_time(Option<DateTime>)`](crate::client::fluent_builders::DescribeEvents::set_end_time): <p>The end of the time interval for which to retrieve events, specified in ISO 8601 format. For more information about ISO 8601, go to the <a href="http://en.wikipedia.org/wiki/ISO_8601">ISO8601 Wikipedia page.</a> </p>  <p>Example: 2009-07-08T18:00Z</p>
    ///   - [`duration(i32)`](crate::client::fluent_builders::DescribeEvents::duration) / [`set_duration(Option<i32>)`](crate::client::fluent_builders::DescribeEvents::set_duration): <p>The number of minutes to retrieve events for.</p>  <p>Default: 60</p>
    ///   - [`event_categories(Vec<String>)`](crate::client::fluent_builders::DescribeEvents::event_categories) / [`set_event_categories(Option<Vec<String>>)`](crate::client::fluent_builders::DescribeEvents::set_event_categories): <p>A list of event categories that trigger notifications for a event notification subscription.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeEvents::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeEvents::set_filters): <p>This parameter isn't currently supported.</p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeEvents::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeEvents::set_max_records): <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that you can retrieve the remaining results.</p>  <p>Default: 100</p>  <p>Constraints: Minimum 20, maximum 100.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeEvents::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeEvents::set_marker): <p>An optional pagination token provided by a previous DescribeEvents request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    /// - On success, responds with [`DescribeEventsOutput`](crate::output::DescribeEventsOutput) with field(s):
    ///   - [`marker(Option<String>)`](crate::output::DescribeEventsOutput::marker): <p>An optional pagination token provided by a previous Events request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    ///   - [`events(Option<Vec<Event>>)`](crate::output::DescribeEventsOutput::events): <p>A list of <code>Event</code> instances.</p>
    /// - On failure, responds with [`SdkError<DescribeEventsError>`](crate::error::DescribeEventsError)
    pub fn describe_events(&self) -> fluent_builders::DescribeEvents {
        fluent_builders::DescribeEvents::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeEventSubscriptions`](crate::client::fluent_builders::DescribeEventSubscriptions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeEventSubscriptions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`subscription_name(impl Into<String>)`](crate::client::fluent_builders::DescribeEventSubscriptions::subscription_name) / [`set_subscription_name(Option<String>)`](crate::client::fluent_builders::DescribeEventSubscriptions::set_subscription_name): <p>The name of the RDS event notification subscription you want to describe.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeEventSubscriptions::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeEventSubscriptions::set_filters): <p>This parameter isn't currently supported.</p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeEventSubscriptions::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeEventSubscriptions::set_max_records): <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that you can retrieve the remaining results.</p>  <p>Default: 100</p>  <p>Constraints: Minimum 20, maximum 100.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeEventSubscriptions::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeEventSubscriptions::set_marker): <p>An optional pagination token provided by a previous DescribeOrderableDBInstanceOptions request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code> .</p>
    /// - On success, responds with [`DescribeEventSubscriptionsOutput`](crate::output::DescribeEventSubscriptionsOutput) with field(s):
    ///   - [`marker(Option<String>)`](crate::output::DescribeEventSubscriptionsOutput::marker): <p>An optional pagination token provided by a previous DescribeOrderableDBInstanceOptions request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    ///   - [`event_subscriptions_list(Option<Vec<EventSubscription>>)`](crate::output::DescribeEventSubscriptionsOutput::event_subscriptions_list): <p>A list of EventSubscriptions data types.</p>
    /// - On failure, responds with [`SdkError<DescribeEventSubscriptionsError>`](crate::error::DescribeEventSubscriptionsError)
    pub fn describe_event_subscriptions(&self) -> fluent_builders::DescribeEventSubscriptions {
        fluent_builders::DescribeEventSubscriptions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeExportTasks`](crate::client::fluent_builders::DescribeExportTasks) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeExportTasks::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`export_task_identifier(impl Into<String>)`](crate::client::fluent_builders::DescribeExportTasks::export_task_identifier) / [`set_export_task_identifier(Option<String>)`](crate::client::fluent_builders::DescribeExportTasks::set_export_task_identifier): <p>The identifier of the snapshot export task to be described.</p>
    ///   - [`source_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeExportTasks::source_arn) / [`set_source_arn(Option<String>)`](crate::client::fluent_builders::DescribeExportTasks::set_source_arn): <p>The Amazon Resource Name (ARN) of the snapshot exported to Amazon S3.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeExportTasks::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeExportTasks::set_filters): <p>Filters specify one or more snapshot exports to describe. The filters are specified as name-value pairs that define what to include in the output. Filter names and values are case-sensitive.</p>  <p>Supported filters include the following:</p>  <ul>   <li> <p> <code>export-task-identifier</code> - An identifier for the snapshot export task.</p> </li>   <li> <p> <code>s3-bucket</code> - The Amazon S3 bucket the snapshot is exported to.</p> </li>   <li> <p> <code>source-arn</code> - The Amazon Resource Name (ARN) of the snapshot exported to Amazon S3</p> </li>   <li> <p> <code>status</code> - The status of the export task. Must be lowercase. Valid statuses are the following:</p>    <ul>     <li> <p> <code>canceled</code> </p> </li>     <li> <p> <code>canceling</code> </p> </li>     <li> <p> <code>complete</code> </p> </li>     <li> <p> <code>failed</code> </p> </li>     <li> <p> <code>in_progress</code> </p> </li>     <li> <p> <code>starting</code> </p> </li>    </ul> </li>  </ul>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeExportTasks::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeExportTasks::set_marker): <p>An optional pagination token provided by a previous <code>DescribeExportTasks</code> request. If you specify this parameter, the response includes only records beyond the marker, up to the value specified by the <code>MaxRecords</code> parameter.</p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeExportTasks::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeExportTasks::set_max_records): <p>The maximum number of records to include in the response. If more records exist than the specified value, a pagination token called a marker is included in the response. You can use the marker in a later <code>DescribeExportTasks</code> request to retrieve the remaining results.</p>  <p>Default: 100</p>  <p>Constraints: Minimum 20, maximum 100.</p>
    /// - On success, responds with [`DescribeExportTasksOutput`](crate::output::DescribeExportTasksOutput) with field(s):
    ///   - [`marker(Option<String>)`](crate::output::DescribeExportTasksOutput::marker): <p>A pagination token that can be used in a later <code>DescribeExportTasks</code> request. A marker is used for pagination to identify the location to begin output for the next response of <code>DescribeExportTasks</code>.</p>
    ///   - [`export_tasks(Option<Vec<ExportTask>>)`](crate::output::DescribeExportTasksOutput::export_tasks): <p>Information about an export of a snapshot to Amazon S3.</p>
    /// - On failure, responds with [`SdkError<DescribeExportTasksError>`](crate::error::DescribeExportTasksError)
    pub fn describe_export_tasks(&self) -> fluent_builders::DescribeExportTasks {
        fluent_builders::DescribeExportTasks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeGlobalClusters`](crate::client::fluent_builders::DescribeGlobalClusters) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeGlobalClusters::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`global_cluster_identifier(impl Into<String>)`](crate::client::fluent_builders::DescribeGlobalClusters::global_cluster_identifier) / [`set_global_cluster_identifier(Option<String>)`](crate::client::fluent_builders::DescribeGlobalClusters::set_global_cluster_identifier): <p>The user-supplied DB cluster identifier. If this parameter is specified, information from only the specific DB cluster is returned. This parameter isn't case-sensitive.</p>  <p>Constraints:</p>  <ul>   <li> <p>If supplied, must match an existing DBClusterIdentifier.</p> </li>  </ul>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeGlobalClusters::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeGlobalClusters::set_filters): <p>This parameter isn't currently supported.</p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeGlobalClusters::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeGlobalClusters::set_max_records): <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that you can retrieve the remaining results.</p>  <p>Default: 100</p>  <p>Constraints: Minimum 20, maximum 100.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeGlobalClusters::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeGlobalClusters::set_marker): <p>An optional pagination token provided by a previous <code>DescribeGlobalClusters</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    /// - On success, responds with [`DescribeGlobalClustersOutput`](crate::output::DescribeGlobalClustersOutput) with field(s):
    ///   - [`marker(Option<String>)`](crate::output::DescribeGlobalClustersOutput::marker): <p>An optional pagination token provided by a previous <code>DescribeGlobalClusters</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    ///   - [`global_clusters(Option<Vec<GlobalCluster>>)`](crate::output::DescribeGlobalClustersOutput::global_clusters): <p>The list of global clusters returned by this request.</p>
    /// - On failure, responds with [`SdkError<DescribeGlobalClustersError>`](crate::error::DescribeGlobalClustersError)
    pub fn describe_global_clusters(&self) -> fluent_builders::DescribeGlobalClusters {
        fluent_builders::DescribeGlobalClusters::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeOptionGroupOptions`](crate::client::fluent_builders::DescribeOptionGroupOptions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeOptionGroupOptions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`engine_name(impl Into<String>)`](crate::client::fluent_builders::DescribeOptionGroupOptions::engine_name) / [`set_engine_name(Option<String>)`](crate::client::fluent_builders::DescribeOptionGroupOptions::set_engine_name): <p>A required parameter. Options available for the given engine name are described.</p>  <p>Valid Values:</p>  <ul>   <li> <p> <code>mariadb</code> </p> </li>   <li> <p> <code>mysql</code> </p> </li>   <li> <p> <code>oracle-ee</code> </p> </li>   <li> <p> <code>oracle-ee-cdb</code> </p> </li>   <li> <p> <code>oracle-se2</code> </p> </li>   <li> <p> <code>oracle-se2-cdb</code> </p> </li>   <li> <p> <code>postgres</code> </p> </li>   <li> <p> <code>sqlserver-ee</code> </p> </li>   <li> <p> <code>sqlserver-se</code> </p> </li>   <li> <p> <code>sqlserver-ex</code> </p> </li>   <li> <p> <code>sqlserver-web</code> </p> </li>  </ul>
    ///   - [`major_engine_version(impl Into<String>)`](crate::client::fluent_builders::DescribeOptionGroupOptions::major_engine_version) / [`set_major_engine_version(Option<String>)`](crate::client::fluent_builders::DescribeOptionGroupOptions::set_major_engine_version): <p>If specified, filters the results to include only options for the specified major engine version.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeOptionGroupOptions::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeOptionGroupOptions::set_filters): <p>This parameter isn't currently supported.</p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeOptionGroupOptions::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeOptionGroupOptions::set_max_records): <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that you can retrieve the remaining results.</p>  <p>Default: 100</p>  <p>Constraints: Minimum 20, maximum 100.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeOptionGroupOptions::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeOptionGroupOptions::set_marker): <p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    /// - On success, responds with [`DescribeOptionGroupOptionsOutput`](crate::output::DescribeOptionGroupOptionsOutput) with field(s):
    ///   - [`option_group_options(Option<Vec<OptionGroupOption>>)`](crate::output::DescribeOptionGroupOptionsOutput::option_group_options): <p>List of available option group options.</p>
    ///   - [`marker(Option<String>)`](crate::output::DescribeOptionGroupOptionsOutput::marker): <p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    /// - On failure, responds with [`SdkError<DescribeOptionGroupOptionsError>`](crate::error::DescribeOptionGroupOptionsError)
    pub fn describe_option_group_options(&self) -> fluent_builders::DescribeOptionGroupOptions {
        fluent_builders::DescribeOptionGroupOptions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeOptionGroups`](crate::client::fluent_builders::DescribeOptionGroups) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeOptionGroups::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`option_group_name(impl Into<String>)`](crate::client::fluent_builders::DescribeOptionGroups::option_group_name) / [`set_option_group_name(Option<String>)`](crate::client::fluent_builders::DescribeOptionGroups::set_option_group_name): <p>The name of the option group to describe. Can't be supplied together with EngineName or MajorEngineVersion.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeOptionGroups::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeOptionGroups::set_filters): <p>This parameter isn't currently supported.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeOptionGroups::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeOptionGroups::set_marker): <p>An optional pagination token provided by a previous DescribeOptionGroups request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeOptionGroups::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeOptionGroups::set_max_records): <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that you can retrieve the remaining results.</p>  <p>Default: 100</p>  <p>Constraints: Minimum 20, maximum 100.</p>
    ///   - [`engine_name(impl Into<String>)`](crate::client::fluent_builders::DescribeOptionGroups::engine_name) / [`set_engine_name(Option<String>)`](crate::client::fluent_builders::DescribeOptionGroups::set_engine_name): <p>Filters the list of option groups to only include groups associated with a specific database engine.</p>  <p>Valid Values:</p>  <ul>   <li> <p> <code>mariadb</code> </p> </li>   <li> <p> <code>mysql</code> </p> </li>   <li> <p> <code>oracle-ee</code> </p> </li>   <li> <p> <code>oracle-ee-cdb</code> </p> </li>   <li> <p> <code>oracle-se2</code> </p> </li>   <li> <p> <code>oracle-se2-cdb</code> </p> </li>   <li> <p> <code>postgres</code> </p> </li>   <li> <p> <code>sqlserver-ee</code> </p> </li>   <li> <p> <code>sqlserver-se</code> </p> </li>   <li> <p> <code>sqlserver-ex</code> </p> </li>   <li> <p> <code>sqlserver-web</code> </p> </li>  </ul>
    ///   - [`major_engine_version(impl Into<String>)`](crate::client::fluent_builders::DescribeOptionGroups::major_engine_version) / [`set_major_engine_version(Option<String>)`](crate::client::fluent_builders::DescribeOptionGroups::set_major_engine_version): <p>Filters the list of option groups to only include groups associated with a specific database engine version. If specified, then EngineName must also be specified.</p>
    /// - On success, responds with [`DescribeOptionGroupsOutput`](crate::output::DescribeOptionGroupsOutput) with field(s):
    ///   - [`option_groups_list(Option<Vec<OptionGroup>>)`](crate::output::DescribeOptionGroupsOutput::option_groups_list): <p>List of option groups.</p>
    ///   - [`marker(Option<String>)`](crate::output::DescribeOptionGroupsOutput::marker): <p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    /// - On failure, responds with [`SdkError<DescribeOptionGroupsError>`](crate::error::DescribeOptionGroupsError)
    pub fn describe_option_groups(&self) -> fluent_builders::DescribeOptionGroups {
        fluent_builders::DescribeOptionGroups::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeOrderableDBInstanceOptions`](crate::client::fluent_builders::DescribeOrderableDBInstanceOptions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeOrderableDBInstanceOptions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`engine(impl Into<String>)`](crate::client::fluent_builders::DescribeOrderableDBInstanceOptions::engine) / [`set_engine(Option<String>)`](crate::client::fluent_builders::DescribeOrderableDBInstanceOptions::set_engine): <p>The name of the engine to retrieve DB instance options for.</p>  <p>Valid Values:</p>  <ul>   <li> <p> <code>aurora</code> (for MySQL 5.6-compatible Aurora)</p> </li>   <li> <p> <code>aurora-mysql</code> (for MySQL 5.7-compatible and MySQL 8.0-compatible Aurora)</p> </li>   <li> <p> <code>aurora-postgresql</code> </p> </li>   <li> <p> <code>mariadb</code> </p> </li>   <li> <p> <code>mysql</code> </p> </li>   <li> <p> <code>oracle-ee</code> </p> </li>   <li> <p> <code>oracle-ee-cdb</code> </p> </li>   <li> <p> <code>oracle-se2</code> </p> </li>   <li> <p> <code>oracle-se2-cdb</code> </p> </li>   <li> <p> <code>postgres</code> </p> </li>   <li> <p> <code>sqlserver-ee</code> </p> </li>   <li> <p> <code>sqlserver-se</code> </p> </li>   <li> <p> <code>sqlserver-ex</code> </p> </li>   <li> <p> <code>sqlserver-web</code> </p> </li>  </ul>
    ///   - [`engine_version(impl Into<String>)`](crate::client::fluent_builders::DescribeOrderableDBInstanceOptions::engine_version) / [`set_engine_version(Option<String>)`](crate::client::fluent_builders::DescribeOrderableDBInstanceOptions::set_engine_version): <p>The engine version filter value. Specify this parameter to show only the available offerings matching the specified engine version.</p>
    ///   - [`db_instance_class(impl Into<String>)`](crate::client::fluent_builders::DescribeOrderableDBInstanceOptions::db_instance_class) / [`set_db_instance_class(Option<String>)`](crate::client::fluent_builders::DescribeOrderableDBInstanceOptions::set_db_instance_class): <p>The DB instance class filter value. Specify this parameter to show only the available offerings matching the specified DB instance class.</p>
    ///   - [`license_model(impl Into<String>)`](crate::client::fluent_builders::DescribeOrderableDBInstanceOptions::license_model) / [`set_license_model(Option<String>)`](crate::client::fluent_builders::DescribeOrderableDBInstanceOptions::set_license_model): <p>The license model filter value. Specify this parameter to show only the available offerings matching the specified license model.</p>  <p>RDS Custom supports only the BYOL licensing model.</p>
    ///   - [`availability_zone_group(impl Into<String>)`](crate::client::fluent_builders::DescribeOrderableDBInstanceOptions::availability_zone_group) / [`set_availability_zone_group(Option<String>)`](crate::client::fluent_builders::DescribeOrderableDBInstanceOptions::set_availability_zone_group): <p>The Availability Zone group associated with a Local Zone. Specify this parameter to retrieve available offerings for the Local Zones in the group.</p>  <p>Omit this parameter to show the available offerings in the specified Amazon Web Services Region.</p>  <p>This setting doesn't apply to RDS Custom.</p>
    ///   - [`vpc(bool)`](crate::client::fluent_builders::DescribeOrderableDBInstanceOptions::vpc) / [`set_vpc(Option<bool>)`](crate::client::fluent_builders::DescribeOrderableDBInstanceOptions::set_vpc): <p>A value that indicates whether to show only VPC or non-VPC offerings. RDS Custom supports only VPC offerings.</p>  <p>RDS Custom supports only VPC offerings. If you describe non-VPC offerings for RDS Custom, the output shows VPC offerings.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeOrderableDBInstanceOptions::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeOrderableDBInstanceOptions::set_filters): <p>This parameter isn't currently supported.</p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeOrderableDBInstanceOptions::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeOrderableDBInstanceOptions::set_max_records): <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that you can retrieve the remaining results.</p>  <p>Default: 100</p>  <p>Constraints: Minimum 20, maximum 100.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeOrderableDBInstanceOptions::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeOrderableDBInstanceOptions::set_marker): <p>An optional pagination token provided by a previous DescribeOrderableDBInstanceOptions request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    /// - On success, responds with [`DescribeOrderableDbInstanceOptionsOutput`](crate::output::DescribeOrderableDbInstanceOptionsOutput) with field(s):
    ///   - [`orderable_db_instance_options(Option<Vec<OrderableDbInstanceOption>>)`](crate::output::DescribeOrderableDbInstanceOptionsOutput::orderable_db_instance_options): <p>An <code>OrderableDBInstanceOption</code> structure containing information about orderable options for the DB instance.</p>
    ///   - [`marker(Option<String>)`](crate::output::DescribeOrderableDbInstanceOptionsOutput::marker): <p>An optional pagination token provided by a previous OrderableDBInstanceOptions request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    /// - On failure, responds with [`SdkError<DescribeOrderableDBInstanceOptionsError>`](crate::error::DescribeOrderableDBInstanceOptionsError)
    pub fn describe_orderable_db_instance_options(
        &self,
    ) -> fluent_builders::DescribeOrderableDBInstanceOptions {
        fluent_builders::DescribeOrderableDBInstanceOptions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribePendingMaintenanceActions`](crate::client::fluent_builders::DescribePendingMaintenanceActions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribePendingMaintenanceActions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_identifier(impl Into<String>)`](crate::client::fluent_builders::DescribePendingMaintenanceActions::resource_identifier) / [`set_resource_identifier(Option<String>)`](crate::client::fluent_builders::DescribePendingMaintenanceActions::set_resource_identifier): <p>The ARN of a resource to return pending maintenance actions for.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribePendingMaintenanceActions::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribePendingMaintenanceActions::set_filters): <p>A filter that specifies one or more resources to return pending maintenance actions for.</p>  <p>Supported filters:</p>  <ul>   <li> <p> <code>db-cluster-id</code> - Accepts DB cluster identifiers and DB cluster Amazon Resource Names (ARNs). The results list only includes pending maintenance actions for the DB clusters identified by these ARNs.</p> </li>   <li> <p> <code>db-instance-id</code> - Accepts DB instance identifiers and DB instance ARNs. The results list only includes pending maintenance actions for the DB instances identified by these ARNs.</p> </li>  </ul>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribePendingMaintenanceActions::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribePendingMaintenanceActions::set_marker): <p>An optional pagination token provided by a previous <code>DescribePendingMaintenanceActions</code> request. If this parameter is specified, the response includes only records beyond the marker, up to a number of records specified by <code>MaxRecords</code>.</p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribePendingMaintenanceActions::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribePendingMaintenanceActions::set_max_records): <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that you can retrieve the remaining results.</p>  <p>Default: 100</p>  <p>Constraints: Minimum 20, maximum 100.</p>
    /// - On success, responds with [`DescribePendingMaintenanceActionsOutput`](crate::output::DescribePendingMaintenanceActionsOutput) with field(s):
    ///   - [`pending_maintenance_actions(Option<Vec<ResourcePendingMaintenanceActions>>)`](crate::output::DescribePendingMaintenanceActionsOutput::pending_maintenance_actions): <p>A list of the pending maintenance actions for the resource.</p>
    ///   - [`marker(Option<String>)`](crate::output::DescribePendingMaintenanceActionsOutput::marker): <p>An optional pagination token provided by a previous <code>DescribePendingMaintenanceActions</code> request. If this parameter is specified, the response includes only records beyond the marker, up to a number of records specified by <code>MaxRecords</code>.</p>
    /// - On failure, responds with [`SdkError<DescribePendingMaintenanceActionsError>`](crate::error::DescribePendingMaintenanceActionsError)
    pub fn describe_pending_maintenance_actions(
        &self,
    ) -> fluent_builders::DescribePendingMaintenanceActions {
        fluent_builders::DescribePendingMaintenanceActions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeReservedDBInstances`](crate::client::fluent_builders::DescribeReservedDBInstances) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeReservedDBInstances::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`reserved_db_instance_id(impl Into<String>)`](crate::client::fluent_builders::DescribeReservedDBInstances::reserved_db_instance_id) / [`set_reserved_db_instance_id(Option<String>)`](crate::client::fluent_builders::DescribeReservedDBInstances::set_reserved_db_instance_id): <p>The reserved DB instance identifier filter value. Specify this parameter to show only the reservation that matches the specified reservation ID.</p>
    ///   - [`reserved_db_instances_offering_id(impl Into<String>)`](crate::client::fluent_builders::DescribeReservedDBInstances::reserved_db_instances_offering_id) / [`set_reserved_db_instances_offering_id(Option<String>)`](crate::client::fluent_builders::DescribeReservedDBInstances::set_reserved_db_instances_offering_id): <p>The offering identifier filter value. Specify this parameter to show only purchased reservations matching the specified offering identifier.</p>
    ///   - [`db_instance_class(impl Into<String>)`](crate::client::fluent_builders::DescribeReservedDBInstances::db_instance_class) / [`set_db_instance_class(Option<String>)`](crate::client::fluent_builders::DescribeReservedDBInstances::set_db_instance_class): <p>The DB instance class filter value. Specify this parameter to show only those reservations matching the specified DB instances class.</p>
    ///   - [`duration(impl Into<String>)`](crate::client::fluent_builders::DescribeReservedDBInstances::duration) / [`set_duration(Option<String>)`](crate::client::fluent_builders::DescribeReservedDBInstances::set_duration): <p>The duration filter value, specified in years or seconds. Specify this parameter to show only reservations for this duration.</p>  <p>Valid Values: <code>1 | 3 | 31536000 | 94608000</code> </p>
    ///   - [`product_description(impl Into<String>)`](crate::client::fluent_builders::DescribeReservedDBInstances::product_description) / [`set_product_description(Option<String>)`](crate::client::fluent_builders::DescribeReservedDBInstances::set_product_description): <p>The product description filter value. Specify this parameter to show only those reservations matching the specified product description.</p>
    ///   - [`offering_type(impl Into<String>)`](crate::client::fluent_builders::DescribeReservedDBInstances::offering_type) / [`set_offering_type(Option<String>)`](crate::client::fluent_builders::DescribeReservedDBInstances::set_offering_type): <p>The offering type filter value. Specify this parameter to show only the available offerings matching the specified offering type.</p>  <p>Valid Values: <code>"Partial Upfront" | "All Upfront" | "No Upfront" </code> </p>
    ///   - [`multi_az(bool)`](crate::client::fluent_builders::DescribeReservedDBInstances::multi_az) / [`set_multi_az(Option<bool>)`](crate::client::fluent_builders::DescribeReservedDBInstances::set_multi_az): <p>A value that indicates whether to show only those reservations that support Multi-AZ.</p>
    ///   - [`lease_id(impl Into<String>)`](crate::client::fluent_builders::DescribeReservedDBInstances::lease_id) / [`set_lease_id(Option<String>)`](crate::client::fluent_builders::DescribeReservedDBInstances::set_lease_id): <p>The lease identifier filter value. Specify this parameter to show only the reservation that matches the specified lease ID.</p> <note>   <p>Amazon Web Services Support might request the lease ID for an issue related to a reserved DB instance.</p>  </note>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeReservedDBInstances::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeReservedDBInstances::set_filters): <p>This parameter isn't currently supported.</p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeReservedDBInstances::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeReservedDBInstances::set_max_records): <p>The maximum number of records to include in the response. If more than the <code>MaxRecords</code> value is available, a pagination token called a marker is included in the response so you can retrieve the remaining results.</p>  <p>Default: 100</p>  <p>Constraints: Minimum 20, maximum 100.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeReservedDBInstances::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeReservedDBInstances::set_marker): <p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    /// - On success, responds with [`DescribeReservedDbInstancesOutput`](crate::output::DescribeReservedDbInstancesOutput) with field(s):
    ///   - [`marker(Option<String>)`](crate::output::DescribeReservedDbInstancesOutput::marker): <p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    ///   - [`reserved_db_instances(Option<Vec<ReservedDbInstance>>)`](crate::output::DescribeReservedDbInstancesOutput::reserved_db_instances): <p>A list of reserved DB instances.</p>
    /// - On failure, responds with [`SdkError<DescribeReservedDBInstancesError>`](crate::error::DescribeReservedDBInstancesError)
    pub fn describe_reserved_db_instances(&self) -> fluent_builders::DescribeReservedDBInstances {
        fluent_builders::DescribeReservedDBInstances::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeReservedDBInstancesOfferings`](crate::client::fluent_builders::DescribeReservedDBInstancesOfferings) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeReservedDBInstancesOfferings::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`reserved_db_instances_offering_id(impl Into<String>)`](crate::client::fluent_builders::DescribeReservedDBInstancesOfferings::reserved_db_instances_offering_id) / [`set_reserved_db_instances_offering_id(Option<String>)`](crate::client::fluent_builders::DescribeReservedDBInstancesOfferings::set_reserved_db_instances_offering_id): <p>The offering identifier filter value. Specify this parameter to show only the available offering that matches the specified reservation identifier.</p>  <p>Example: <code>438012d3-4052-4cc7-b2e3-8d3372e0e706</code> </p>
    ///   - [`db_instance_class(impl Into<String>)`](crate::client::fluent_builders::DescribeReservedDBInstancesOfferings::db_instance_class) / [`set_db_instance_class(Option<String>)`](crate::client::fluent_builders::DescribeReservedDBInstancesOfferings::set_db_instance_class): <p>The DB instance class filter value. Specify this parameter to show only the available offerings matching the specified DB instance class.</p>
    ///   - [`duration(impl Into<String>)`](crate::client::fluent_builders::DescribeReservedDBInstancesOfferings::duration) / [`set_duration(Option<String>)`](crate::client::fluent_builders::DescribeReservedDBInstancesOfferings::set_duration): <p>Duration filter value, specified in years or seconds. Specify this parameter to show only reservations for this duration.</p>  <p>Valid Values: <code>1 | 3 | 31536000 | 94608000</code> </p>
    ///   - [`product_description(impl Into<String>)`](crate::client::fluent_builders::DescribeReservedDBInstancesOfferings::product_description) / [`set_product_description(Option<String>)`](crate::client::fluent_builders::DescribeReservedDBInstancesOfferings::set_product_description): <p>Product description filter value. Specify this parameter to show only the available offerings that contain the specified product description.</p> <note>   <p>The results show offerings that partially match the filter value.</p>  </note>
    ///   - [`offering_type(impl Into<String>)`](crate::client::fluent_builders::DescribeReservedDBInstancesOfferings::offering_type) / [`set_offering_type(Option<String>)`](crate::client::fluent_builders::DescribeReservedDBInstancesOfferings::set_offering_type): <p>The offering type filter value. Specify this parameter to show only the available offerings matching the specified offering type.</p>  <p>Valid Values: <code>"Partial Upfront" | "All Upfront" | "No Upfront" </code> </p>
    ///   - [`multi_az(bool)`](crate::client::fluent_builders::DescribeReservedDBInstancesOfferings::multi_az) / [`set_multi_az(Option<bool>)`](crate::client::fluent_builders::DescribeReservedDBInstancesOfferings::set_multi_az): <p>A value that indicates whether to show only those reservations that support Multi-AZ.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeReservedDBInstancesOfferings::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeReservedDBInstancesOfferings::set_filters): <p>This parameter isn't currently supported.</p>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeReservedDBInstancesOfferings::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeReservedDBInstancesOfferings::set_max_records): <p>The maximum number of records to include in the response. If more than the <code>MaxRecords</code> value is available, a pagination token called a marker is included in the response so you can retrieve the remaining results.</p>  <p>Default: 100</p>  <p>Constraints: Minimum 20, maximum 100.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeReservedDBInstancesOfferings::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeReservedDBInstancesOfferings::set_marker): <p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    /// - On success, responds with [`DescribeReservedDbInstancesOfferingsOutput`](crate::output::DescribeReservedDbInstancesOfferingsOutput) with field(s):
    ///   - [`marker(Option<String>)`](crate::output::DescribeReservedDbInstancesOfferingsOutput::marker): <p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    ///   - [`reserved_db_instances_offerings(Option<Vec<ReservedDbInstancesOffering>>)`](crate::output::DescribeReservedDbInstancesOfferingsOutput::reserved_db_instances_offerings): <p>A list of reserved DB instance offerings.</p>
    /// - On failure, responds with [`SdkError<DescribeReservedDBInstancesOfferingsError>`](crate::error::DescribeReservedDBInstancesOfferingsError)
    pub fn describe_reserved_db_instances_offerings(
        &self,
    ) -> fluent_builders::DescribeReservedDBInstancesOfferings {
        fluent_builders::DescribeReservedDBInstancesOfferings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeSourceRegions`](crate::client::fluent_builders::DescribeSourceRegions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeSourceRegions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`region_name(impl Into<String>)`](crate::client::fluent_builders::DescribeSourceRegions::region_name) / [`set_region_name(Option<String>)`](crate::client::fluent_builders::DescribeSourceRegions::set_region_name): <p>The source Amazon Web Services Region name. For example, <code>us-east-1</code>.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must specify a valid Amazon Web Services Region name.</p> </li>  </ul>
    ///   - [`max_records(i32)`](crate::client::fluent_builders::DescribeSourceRegions::max_records) / [`set_max_records(Option<i32>)`](crate::client::fluent_builders::DescribeSourceRegions::set_max_records): <p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response so you can retrieve the remaining results.</p>  <p>Default: 100</p>  <p>Constraints: Minimum 20, maximum 100.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DescribeSourceRegions::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DescribeSourceRegions::set_marker): <p>An optional pagination token provided by a previous <code>DescribeSourceRegions</code> request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::DescribeSourceRegions::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::DescribeSourceRegions::set_filters): <p>This parameter isn't currently supported.</p>
    /// - On success, responds with [`DescribeSourceRegionsOutput`](crate::output::DescribeSourceRegionsOutput) with field(s):
    ///   - [`marker(Option<String>)`](crate::output::DescribeSourceRegionsOutput::marker): <p>An optional pagination token provided by a previous request. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>
    ///   - [`source_regions(Option<Vec<SourceRegion>>)`](crate::output::DescribeSourceRegionsOutput::source_regions): <p>A list of <code>SourceRegion</code> instances that contains each source Amazon Web Services Region that the current Amazon Web Services Region can get a read replica or a DB snapshot from.</p>
    /// - On failure, responds with [`SdkError<DescribeSourceRegionsError>`](crate::error::DescribeSourceRegionsError)
    pub fn describe_source_regions(&self) -> fluent_builders::DescribeSourceRegions {
        fluent_builders::DescribeSourceRegions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeValidDBInstanceModifications`](crate::client::fluent_builders::DescribeValidDBInstanceModifications) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_instance_identifier(impl Into<String>)`](crate::client::fluent_builders::DescribeValidDBInstanceModifications::db_instance_identifier) / [`set_db_instance_identifier(Option<String>)`](crate::client::fluent_builders::DescribeValidDBInstanceModifications::set_db_instance_identifier): <p>The customer identifier or the ARN of your DB instance.</p>
    /// - On success, responds with [`DescribeValidDbInstanceModificationsOutput`](crate::output::DescribeValidDbInstanceModificationsOutput) with field(s):
    ///   - [`valid_db_instance_modifications_message(Option<ValidDbInstanceModificationsMessage>)`](crate::output::DescribeValidDbInstanceModificationsOutput::valid_db_instance_modifications_message): <p>Information about valid modifications that you can make to your DB instance. Contains the result of a successful call to the <code>DescribeValidDBInstanceModifications</code> action. You can use this information when you call <code>ModifyDBInstance</code>.</p>
    /// - On failure, responds with [`SdkError<DescribeValidDBInstanceModificationsError>`](crate::error::DescribeValidDBInstanceModificationsError)
    pub fn describe_valid_db_instance_modifications(
        &self,
    ) -> fluent_builders::DescribeValidDBInstanceModifications {
        fluent_builders::DescribeValidDBInstanceModifications::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DownloadDBLogFilePortion`](crate::client::fluent_builders::DownloadDBLogFilePortion) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DownloadDBLogFilePortion::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_instance_identifier(impl Into<String>)`](crate::client::fluent_builders::DownloadDBLogFilePortion::db_instance_identifier) / [`set_db_instance_identifier(Option<String>)`](crate::client::fluent_builders::DownloadDBLogFilePortion::set_db_instance_identifier): <p>The customer-assigned name of the DB instance that contains the log files you want to list.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must match the identifier of an existing DBInstance.</p> </li>  </ul>
    ///   - [`log_file_name(impl Into<String>)`](crate::client::fluent_builders::DownloadDBLogFilePortion::log_file_name) / [`set_log_file_name(Option<String>)`](crate::client::fluent_builders::DownloadDBLogFilePortion::set_log_file_name): <p>The name of the log file to be downloaded.</p>
    ///   - [`marker(impl Into<String>)`](crate::client::fluent_builders::DownloadDBLogFilePortion::marker) / [`set_marker(Option<String>)`](crate::client::fluent_builders::DownloadDBLogFilePortion::set_marker): <p>The pagination token provided in the previous request or "0". If the Marker parameter is specified the response includes only records beyond the marker until the end of the file or up to NumberOfLines.</p>
    ///   - [`number_of_lines(i32)`](crate::client::fluent_builders::DownloadDBLogFilePortion::number_of_lines) / [`set_number_of_lines(i32)`](crate::client::fluent_builders::DownloadDBLogFilePortion::set_number_of_lines): <p>The number of lines to download. If the number of lines specified results in a file over 1 MB in size, the file is truncated at 1 MB in size.</p>  <p>If the NumberOfLines parameter is specified, then the block of lines returned can be from the beginning or the end of the log file, depending on the value of the Marker parameter.</p>  <ul>   <li> <p>If neither Marker or NumberOfLines are specified, the entire log file is returned up to a maximum of 10000 lines, starting with the most recent log entries first.</p> </li>   <li> <p>If NumberOfLines is specified and Marker isn't specified, then the most recent lines from the end of the log file are returned.</p> </li>   <li> <p>If Marker is specified as "0", then the specified number of lines from the beginning of the log file are returned.</p> </li>   <li> <p>You can download the log file in blocks of lines by specifying the size of the block using the NumberOfLines parameter, and by specifying a value of "0" for the Marker parameter in your first request. Include the Marker value returned in the response as the Marker value for the next request, continuing until the AdditionalDataPending response element returns false.</p> </li>  </ul>
    /// - On success, responds with [`DownloadDbLogFilePortionOutput`](crate::output::DownloadDbLogFilePortionOutput) with field(s):
    ///   - [`log_file_data(Option<String>)`](crate::output::DownloadDbLogFilePortionOutput::log_file_data): <p>Entries from the specified log file.</p>
    ///   - [`marker(Option<String>)`](crate::output::DownloadDbLogFilePortionOutput::marker): <p>A pagination token that can be used in a later <code>DownloadDBLogFilePortion</code> request.</p>
    ///   - [`additional_data_pending(bool)`](crate::output::DownloadDbLogFilePortionOutput::additional_data_pending): <p>Boolean value that if true, indicates there is more data to be downloaded.</p>
    /// - On failure, responds with [`SdkError<DownloadDBLogFilePortionError>`](crate::error::DownloadDBLogFilePortionError)
    pub fn download_db_log_file_portion(&self) -> fluent_builders::DownloadDBLogFilePortion {
        fluent_builders::DownloadDBLogFilePortion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`FailoverDBCluster`](crate::client::fluent_builders::FailoverDBCluster) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_cluster_identifier(impl Into<String>)`](crate::client::fluent_builders::FailoverDBCluster::db_cluster_identifier) / [`set_db_cluster_identifier(Option<String>)`](crate::client::fluent_builders::FailoverDBCluster::set_db_cluster_identifier): <p>A DB cluster identifier to force a failover for. This parameter isn't case-sensitive.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must match the identifier of an existing DBCluster.</p> </li>  </ul>
    ///   - [`target_db_instance_identifier(impl Into<String>)`](crate::client::fluent_builders::FailoverDBCluster::target_db_instance_identifier) / [`set_target_db_instance_identifier(Option<String>)`](crate::client::fluent_builders::FailoverDBCluster::set_target_db_instance_identifier): <p>The name of the DB instance to promote to the primary DB instance.</p>  <p>Specify the DB instance identifier for an Aurora Replica or a Multi-AZ readable standby in the DB cluster, for example <code>mydbcluster-replica1</code>.</p>  <p>This setting isn't supported for RDS for MySQL Multi-AZ DB clusters.</p>
    /// - On success, responds with [`FailoverDbClusterOutput`](crate::output::FailoverDbClusterOutput) with field(s):
    ///   - [`db_cluster(Option<DbCluster>)`](crate::output::FailoverDbClusterOutput::db_cluster): <p>Contains the details of an Amazon Aurora DB cluster or Multi-AZ DB cluster.</p>  <p>For an Amazon Aurora DB cluster, this data type is used as a response element in the operations <code>CreateDBCluster</code>, <code>DeleteDBCluster</code>, <code>DescribeDBClusters</code>, <code>FailoverDBCluster</code>, <code>ModifyDBCluster</code>, <code>PromoteReadReplicaDBCluster</code>, <code>RestoreDBClusterFromS3</code>, <code>RestoreDBClusterFromSnapshot</code>, <code>RestoreDBClusterToPointInTime</code>, <code>StartDBCluster</code>, and <code>StopDBCluster</code>.</p>  <p>For a Multi-AZ DB cluster, this data type is used as a response element in the operations <code>CreateDBCluster</code>, <code>DeleteDBCluster</code>, <code>DescribeDBClusters</code>, <code>FailoverDBCluster</code>, <code>ModifyDBCluster</code>, <code>RebootDBCluster</code>, <code>RestoreDBClusterFromSnapshot</code>, and <code>RestoreDBClusterToPointInTime</code>.</p>  <p>For more information on Amazon Aurora DB clusters, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon Aurora?</a> in the <i>Amazon Aurora User Guide.</i> </p>  <p>For more information on Multi-AZ DB clusters, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ deployments with two readable standby DB instances</a> in the <i>Amazon RDS User Guide.</i> </p>
    /// - On failure, responds with [`SdkError<FailoverDBClusterError>`](crate::error::FailoverDBClusterError)
    pub fn failover_db_cluster(&self) -> fluent_builders::FailoverDBCluster {
        fluent_builders::FailoverDBCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`FailoverGlobalCluster`](crate::client::fluent_builders::FailoverGlobalCluster) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`global_cluster_identifier(impl Into<String>)`](crate::client::fluent_builders::FailoverGlobalCluster::global_cluster_identifier) / [`set_global_cluster_identifier(Option<String>)`](crate::client::fluent_builders::FailoverGlobalCluster::set_global_cluster_identifier): <p>Identifier of the Aurora global database (<code>GlobalCluster</code>) that should be failed over. The identifier is the unique key assigned by the user when the Aurora global database was created. In other words, it's the name of the Aurora global database that you want to fail over.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must match the identifier of an existing <code>GlobalCluster</code> (Aurora global database).</p> </li>  </ul>
    ///   - [`target_db_cluster_identifier(impl Into<String>)`](crate::client::fluent_builders::FailoverGlobalCluster::target_db_cluster_identifier) / [`set_target_db_cluster_identifier(Option<String>)`](crate::client::fluent_builders::FailoverGlobalCluster::set_target_db_cluster_identifier): <p>Identifier of the secondary Aurora DB cluster that you want to promote to primary for the Aurora global database (<code>GlobalCluster</code>.) Use the Amazon Resource Name (ARN) for the identifier so that Aurora can locate the cluster in its Amazon Web Services Region.</p>
    /// - On success, responds with [`FailoverGlobalClusterOutput`](crate::output::FailoverGlobalClusterOutput) with field(s):
    ///   - [`global_cluster(Option<GlobalCluster>)`](crate::output::FailoverGlobalClusterOutput::global_cluster): <p>A data type representing an Aurora global database.</p>
    /// - On failure, responds with [`SdkError<FailoverGlobalClusterError>`](crate::error::FailoverGlobalClusterError)
    pub fn failover_global_cluster(&self) -> fluent_builders::FailoverGlobalCluster {
        fluent_builders::FailoverGlobalCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_name(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_name) / [`set_resource_name(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_name): <p>The Amazon RDS resource with tags to be listed. This value is an Amazon Resource Name (ARN). For information about creating an ARN, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing"> Constructing an ARN for Amazon RDS</a> in the <i>Amazon RDS User Guide</i>.</p>
    ///   - [`filters(Vec<Filter>)`](crate::client::fluent_builders::ListTagsForResource::filters) / [`set_filters(Option<Vec<Filter>>)`](crate::client::fluent_builders::ListTagsForResource::set_filters): <p>This parameter isn't currently supported.</p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tag_list(Option<Vec<Tag>>)`](crate::output::ListTagsForResourceOutput::tag_list): <p>List of tags returned by the <code>ListTagsForResource</code> operation.</p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ModifyCertificates`](crate::client::fluent_builders::ModifyCertificates) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`certificate_identifier(impl Into<String>)`](crate::client::fluent_builders::ModifyCertificates::certificate_identifier) / [`set_certificate_identifier(Option<String>)`](crate::client::fluent_builders::ModifyCertificates::set_certificate_identifier): <p>The new default certificate identifier to override the current one with.</p>  <p>To determine the valid values, use the <code>describe-certificates</code> CLI command or the <code>DescribeCertificates</code> API operation.</p>
    ///   - [`remove_customer_override(bool)`](crate::client::fluent_builders::ModifyCertificates::remove_customer_override) / [`set_remove_customer_override(Option<bool>)`](crate::client::fluent_builders::ModifyCertificates::set_remove_customer_override): <p>A value that indicates whether to remove the override for the default certificate. If the override is removed, the default certificate is the system default.</p>
    /// - On success, responds with [`ModifyCertificatesOutput`](crate::output::ModifyCertificatesOutput) with field(s):
    ///   - [`certificate(Option<Certificate>)`](crate::output::ModifyCertificatesOutput::certificate): <p>A CA certificate for an Amazon Web Services account.</p>
    /// - On failure, responds with [`SdkError<ModifyCertificatesError>`](crate::error::ModifyCertificatesError)
    pub fn modify_certificates(&self) -> fluent_builders::ModifyCertificates {
        fluent_builders::ModifyCertificates::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ModifyCurrentDBClusterCapacity`](crate::client::fluent_builders::ModifyCurrentDBClusterCapacity) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_cluster_identifier(impl Into<String>)`](crate::client::fluent_builders::ModifyCurrentDBClusterCapacity::db_cluster_identifier) / [`set_db_cluster_identifier(Option<String>)`](crate::client::fluent_builders::ModifyCurrentDBClusterCapacity::set_db_cluster_identifier): <p>The DB cluster identifier for the cluster being modified. This parameter isn't case-sensitive.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must match the identifier of an existing DB cluster.</p> </li>  </ul>
    ///   - [`capacity(i32)`](crate::client::fluent_builders::ModifyCurrentDBClusterCapacity::capacity) / [`set_capacity(Option<i32>)`](crate::client::fluent_builders::ModifyCurrentDBClusterCapacity::set_capacity): <p>The DB cluster capacity.</p>  <p>When you change the capacity of a paused Aurora Serverless v1 DB cluster, it automatically resumes.</p>  <p>Constraints:</p>  <ul>   <li> <p>For Aurora MySQL, valid capacity values are <code>1</code>, <code>2</code>, <code>4</code>, <code>8</code>, <code>16</code>, <code>32</code>, <code>64</code>, <code>128</code>, and <code>256</code>.</p> </li>   <li> <p>For Aurora PostgreSQL, valid capacity values are <code>2</code>, <code>4</code>, <code>8</code>, <code>16</code>, <code>32</code>, <code>64</code>, <code>192</code>, and <code>384</code>.</p> </li>  </ul>
    ///   - [`seconds_before_timeout(i32)`](crate::client::fluent_builders::ModifyCurrentDBClusterCapacity::seconds_before_timeout) / [`set_seconds_before_timeout(Option<i32>)`](crate::client::fluent_builders::ModifyCurrentDBClusterCapacity::set_seconds_before_timeout): <p>The amount of time, in seconds, that Aurora Serverless v1 tries to find a scaling point to perform seamless scaling before enforcing the timeout action. The default is 300.</p>  <p>Specify a value between 10 and 600 seconds.</p>
    ///   - [`timeout_action(impl Into<String>)`](crate::client::fluent_builders::ModifyCurrentDBClusterCapacity::timeout_action) / [`set_timeout_action(Option<String>)`](crate::client::fluent_builders::ModifyCurrentDBClusterCapacity::set_timeout_action): <p>The action to take when the timeout is reached, either <code>ForceApplyCapacityChange</code> or <code>RollbackCapacityChange</code>.</p>  <p> <code>ForceApplyCapacityChange</code>, the default, sets the capacity to the specified value as soon as possible.</p>  <p> <code>RollbackCapacityChange</code> ignores the capacity change if a scaling point isn't found in the timeout period.</p>
    /// - On success, responds with [`ModifyCurrentDbClusterCapacityOutput`](crate::output::ModifyCurrentDbClusterCapacityOutput) with field(s):
    ///   - [`db_cluster_identifier(Option<String>)`](crate::output::ModifyCurrentDbClusterCapacityOutput::db_cluster_identifier): <p>A user-supplied DB cluster identifier. This identifier is the unique key that identifies a DB cluster.</p>
    ///   - [`pending_capacity(Option<i32>)`](crate::output::ModifyCurrentDbClusterCapacityOutput::pending_capacity): <p>A value that specifies the capacity that the DB cluster scales to next.</p>
    ///   - [`current_capacity(Option<i32>)`](crate::output::ModifyCurrentDbClusterCapacityOutput::current_capacity): <p>The current capacity of the DB cluster.</p>
    ///   - [`seconds_before_timeout(Option<i32>)`](crate::output::ModifyCurrentDbClusterCapacityOutput::seconds_before_timeout): <p>The number of seconds before a call to <code>ModifyCurrentDBClusterCapacity</code> times out.</p>
    ///   - [`timeout_action(Option<String>)`](crate::output::ModifyCurrentDbClusterCapacityOutput::timeout_action): <p>The timeout action of a call to <code>ModifyCurrentDBClusterCapacity</code>, either <code>ForceApplyCapacityChange</code> or <code>RollbackCapacityChange</code>.</p>
    /// - On failure, responds with [`SdkError<ModifyCurrentDBClusterCapacityError>`](crate::error::ModifyCurrentDBClusterCapacityError)
    pub fn modify_current_db_cluster_capacity(
        &self,
    ) -> fluent_builders::ModifyCurrentDBClusterCapacity {
        fluent_builders::ModifyCurrentDBClusterCapacity::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ModifyCustomDBEngineVersion`](crate::client::fluent_builders::ModifyCustomDBEngineVersion) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`engine(impl Into<String>)`](crate::client::fluent_builders::ModifyCustomDBEngineVersion::engine) / [`set_engine(Option<String>)`](crate::client::fluent_builders::ModifyCustomDBEngineVersion::set_engine): <p>The DB engine. The only supported value is <code>custom-oracle-ee</code>.</p>
    ///   - [`engine_version(impl Into<String>)`](crate::client::fluent_builders::ModifyCustomDBEngineVersion::engine_version) / [`set_engine_version(Option<String>)`](crate::client::fluent_builders::ModifyCustomDBEngineVersion::set_engine_version): <p>The custom engine version (CEV) that you want to modify. This option is required for RDS Custom for Oracle, but optional for Amazon RDS. The combination of <code>Engine</code> and <code>EngineVersion</code> is unique per customer per Amazon Web Services Region.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::ModifyCustomDBEngineVersion::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::ModifyCustomDBEngineVersion::set_description): <p>An optional description of your CEV.</p>
    ///   - [`status(CustomEngineVersionStatus)`](crate::client::fluent_builders::ModifyCustomDBEngineVersion::status) / [`set_status(Option<CustomEngineVersionStatus>)`](crate::client::fluent_builders::ModifyCustomDBEngineVersion::set_status): <p>The availability status to be assigned to the CEV. Valid values are as follows:</p>  <dl>   <dt>   available  </dt>   <dd>    <p>You can use this CEV to create a new RDS Custom DB instance.</p>   </dd>   <dt>   inactive  </dt>   <dd>    <p>You can create a new RDS Custom instance by restoring a DB snapshot with this CEV. You can't patch or create new instances with this CEV.</p>   </dd>  </dl>  <p>You can change any status to any status. A typical reason to change status is to prevent the accidental use of a CEV, or to make a deprecated CEV eligible for use again. For example, you might change the status of your CEV from <code>available</code> to <code>inactive</code>, and from <code>inactive</code> back to <code>available</code>. To change the availability status of the CEV, it must not currently be in use by an RDS Custom instance, snapshot, or automated backup.</p>
    /// - On success, responds with [`ModifyCustomDbEngineVersionOutput`](crate::output::ModifyCustomDbEngineVersionOutput) with field(s):
    ///   - [`engine(Option<String>)`](crate::output::ModifyCustomDbEngineVersionOutput::engine): <p>The name of the database engine.</p>
    ///   - [`engine_version(Option<String>)`](crate::output::ModifyCustomDbEngineVersionOutput::engine_version): <p>The version number of the database engine.</p>
    ///   - [`db_parameter_group_family(Option<String>)`](crate::output::ModifyCustomDbEngineVersionOutput::db_parameter_group_family): <p>The name of the DB parameter group family for the database engine.</p>
    ///   - [`db_engine_description(Option<String>)`](crate::output::ModifyCustomDbEngineVersionOutput::db_engine_description): <p>The description of the database engine.</p>
    ///   - [`db_engine_version_description(Option<String>)`](crate::output::ModifyCustomDbEngineVersionOutput::db_engine_version_description): <p>The description of the database engine version.</p>
    ///   - [`default_character_set(Option<CharacterSet>)`](crate::output::ModifyCustomDbEngineVersionOutput::default_character_set): <p>The default character set for new instances of this engine version, if the <code>CharacterSetName</code> parameter of the CreateDBInstance API isn't specified.</p>
    ///   - [`supported_character_sets(Option<Vec<CharacterSet>>)`](crate::output::ModifyCustomDbEngineVersionOutput::supported_character_sets): <p>A list of the character sets supported by this engine for the <code>CharacterSetName</code> parameter of the <code>CreateDBInstance</code> operation.</p>
    ///   - [`supported_nchar_character_sets(Option<Vec<CharacterSet>>)`](crate::output::ModifyCustomDbEngineVersionOutput::supported_nchar_character_sets): <p>A list of the character sets supported by the Oracle DB engine for the <code>NcharCharacterSetName</code> parameter of the <code>CreateDBInstance</code> operation.</p>
    ///   - [`valid_upgrade_target(Option<Vec<UpgradeTarget>>)`](crate::output::ModifyCustomDbEngineVersionOutput::valid_upgrade_target): <p>A list of engine versions that this database engine version can be upgraded to.</p>
    ///   - [`supported_timezones(Option<Vec<Timezone>>)`](crate::output::ModifyCustomDbEngineVersionOutput::supported_timezones): <p>A list of the time zones supported by this engine for the <code>Timezone</code> parameter of the <code>CreateDBInstance</code> action.</p>
    ///   - [`exportable_log_types(Option<Vec<String>>)`](crate::output::ModifyCustomDbEngineVersionOutput::exportable_log_types): <p>The types of logs that the database engine has available for export to CloudWatch Logs.</p>
    ///   - [`supports_log_exports_to_cloudwatch_logs(bool)`](crate::output::ModifyCustomDbEngineVersionOutput::supports_log_exports_to_cloudwatch_logs): <p>A value that indicates whether the engine version supports exporting the log types specified by ExportableLogTypes to CloudWatch Logs.</p>
    ///   - [`supports_read_replica(bool)`](crate::output::ModifyCustomDbEngineVersionOutput::supports_read_replica): <p>Indicates whether the database engine version supports read replicas.</p>
    ///   - [`supported_engine_modes(Option<Vec<String>>)`](crate::output::ModifyCustomDbEngineVersionOutput::supported_engine_modes): <p>A list of the supported DB engine modes.</p>
    ///   - [`supported_feature_names(Option<Vec<String>>)`](crate::output::ModifyCustomDbEngineVersionOutput::supported_feature_names): <p>A list of features supported by the DB engine.</p>  <p>The supported features vary by DB engine and DB engine version.</p>  <p>To determine the supported features for a specific DB engine and DB engine version using the CLI, use the following command:</p>  <p> <code>aws rds describe-db-engine-versions --engine    <engine_name>     --engine-version     <engine_version></engine_version>   </engine_name></code> </p>  <p>For example, to determine the supported features for RDS for PostgreSQL version 13.3 using the CLI, use the following command:</p>  <p> <code>aws rds describe-db-engine-versions --engine postgres --engine-version 13.3</code> </p>  <p>The supported features are listed under <code>SupportedFeatureNames</code> in the output.</p>
    ///   - [`status(Option<String>)`](crate::output::ModifyCustomDbEngineVersionOutput::status): <p>The status of the DB engine version, either <code>available</code> or <code>deprecated</code>.</p>
    ///   - [`supports_parallel_query(bool)`](crate::output::ModifyCustomDbEngineVersionOutput::supports_parallel_query): <p>A value that indicates whether you can use Aurora parallel query with a specific DB engine version.</p>
    ///   - [`supports_global_databases(bool)`](crate::output::ModifyCustomDbEngineVersionOutput::supports_global_databases): <p>A value that indicates whether you can use Aurora global databases with a specific DB engine version.</p>
    ///   - [`major_engine_version(Option<String>)`](crate::output::ModifyCustomDbEngineVersionOutput::major_engine_version): <p>The major engine version of the CEV.</p>
    ///   - [`database_installation_files_s3_bucket_name(Option<String>)`](crate::output::ModifyCustomDbEngineVersionOutput::database_installation_files_s3_bucket_name): <p>The name of the Amazon S3 bucket that contains your database installation files.</p>
    ///   - [`database_installation_files_s3_prefix(Option<String>)`](crate::output::ModifyCustomDbEngineVersionOutput::database_installation_files_s3_prefix): <p>The Amazon S3 directory that contains the database installation files. If not specified, then no prefix is assumed.</p>
    ///   - [`db_engine_version_arn(Option<String>)`](crate::output::ModifyCustomDbEngineVersionOutput::db_engine_version_arn): <p>The ARN of the custom engine version.</p>
    ///   - [`kms_key_id(Option<String>)`](crate::output::ModifyCustomDbEngineVersionOutput::kms_key_id): <p>The Amazon Web Services KMS key identifier for an encrypted CEV. This parameter is required for RDS Custom, but optional for Amazon RDS.</p>
    ///   - [`create_time(Option<DateTime>)`](crate::output::ModifyCustomDbEngineVersionOutput::create_time): <p>The creation time of the DB engine version.</p>
    ///   - [`tag_list(Option<Vec<Tag>>)`](crate::output::ModifyCustomDbEngineVersionOutput::tag_list): <p>A list of tags. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources</a> in the <i>Amazon RDS User Guide.</i> </p>
    ///   - [`supports_babelfish(bool)`](crate::output::ModifyCustomDbEngineVersionOutput::supports_babelfish): <p>A value that indicates whether the engine version supports Babelfish for Aurora PostgreSQL.</p>
    /// - On failure, responds with [`SdkError<ModifyCustomDBEngineVersionError>`](crate::error::ModifyCustomDBEngineVersionError)
    pub fn modify_custom_db_engine_version(&self) -> fluent_builders::ModifyCustomDBEngineVersion {
        fluent_builders::ModifyCustomDBEngineVersion::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ModifyDBCluster`](crate::client::fluent_builders::ModifyDBCluster) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_cluster_identifier(impl Into<String>)`](crate::client::fluent_builders::ModifyDBCluster::db_cluster_identifier) / [`set_db_cluster_identifier(Option<String>)`](crate::client::fluent_builders::ModifyDBCluster::set_db_cluster_identifier): <p>The DB cluster identifier for the cluster being modified. This parameter isn't case-sensitive.</p>  <p>Constraints: This identifier must match the identifier of an existing DB cluster.</p>  <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
    ///   - [`new_db_cluster_identifier(impl Into<String>)`](crate::client::fluent_builders::ModifyDBCluster::new_db_cluster_identifier) / [`set_new_db_cluster_identifier(Option<String>)`](crate::client::fluent_builders::ModifyDBCluster::set_new_db_cluster_identifier): <p>The new DB cluster identifier for the DB cluster when renaming a DB cluster. This value is stored as a lowercase string.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must contain from 1 to 63 letters, numbers, or hyphens</p> </li>   <li> <p>The first character must be a letter</p> </li>   <li> <p>Can't end with a hyphen or contain two consecutive hyphens</p> </li>  </ul>  <p>Example: <code>my-cluster2</code> </p>  <p>Valid for: Aurora DB clusters only</p>
    ///   - [`apply_immediately(bool)`](crate::client::fluent_builders::ModifyDBCluster::apply_immediately) / [`set_apply_immediately(bool)`](crate::client::fluent_builders::ModifyDBCluster::set_apply_immediately): <p>A value that indicates whether the modifications in this request and any pending modifications are asynchronously applied as soon as possible, regardless of the <code>PreferredMaintenanceWindow</code> setting for the DB cluster. If this parameter is disabled, changes to the DB cluster are applied during the next maintenance window.</p>  <p>The <code>ApplyImmediately</code> parameter only affects the <code>EnableIAMDatabaseAuthentication</code>, <code>MasterUserPassword</code>, and <code>NewDBClusterIdentifier</code> values. If the <code>ApplyImmediately</code> parameter is disabled, then changes to the <code>EnableIAMDatabaseAuthentication</code>, <code>MasterUserPassword</code>, and <code>NewDBClusterIdentifier</code> values are applied during the next maintenance window. All other changes are applied immediately, regardless of the value of the <code>ApplyImmediately</code> parameter.</p>  <p>By default, this parameter is disabled.</p>  <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
    ///   - [`backup_retention_period(i32)`](crate::client::fluent_builders::ModifyDBCluster::backup_retention_period) / [`set_backup_retention_period(Option<i32>)`](crate::client::fluent_builders::ModifyDBCluster::set_backup_retention_period): <p>The number of days for which automated backups are retained. Specify a minimum value of 1.</p>  <p>Default: 1</p>  <p>Constraints:</p>  <ul>   <li> <p>Must be a value from 1 to 35</p> </li>  </ul>  <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
    ///   - [`db_cluster_parameter_group_name(impl Into<String>)`](crate::client::fluent_builders::ModifyDBCluster::db_cluster_parameter_group_name) / [`set_db_cluster_parameter_group_name(Option<String>)`](crate::client::fluent_builders::ModifyDBCluster::set_db_cluster_parameter_group_name): <p>The name of the DB cluster parameter group to use for the DB cluster.</p>  <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
    ///   - [`vpc_security_group_ids(Vec<String>)`](crate::client::fluent_builders::ModifyDBCluster::vpc_security_group_ids) / [`set_vpc_security_group_ids(Option<Vec<String>>)`](crate::client::fluent_builders::ModifyDBCluster::set_vpc_security_group_ids): <p>A list of VPC security groups that the DB cluster will belong to.</p>  <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
    ///   - [`port(i32)`](crate::client::fluent_builders::ModifyDBCluster::port) / [`set_port(Option<i32>)`](crate::client::fluent_builders::ModifyDBCluster::set_port): <p>The port number on which the DB cluster accepts connections.</p>  <p>Constraints: Value must be <code>1150-65535</code> </p>  <p>Default: The same port as the original DB cluster.</p>  <p>Valid for: Aurora DB clusters only</p>
    ///   - [`master_user_password(impl Into<String>)`](crate::client::fluent_builders::ModifyDBCluster::master_user_password) / [`set_master_user_password(Option<String>)`](crate::client::fluent_builders::ModifyDBCluster::set_master_user_password): <p>The new password for the master database user. This password can contain any printable ASCII character except "/", """, or "@".</p>  <p>Constraints: Must contain from 8 to 41 characters.</p>  <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
    ///   - [`option_group_name(impl Into<String>)`](crate::client::fluent_builders::ModifyDBCluster::option_group_name) / [`set_option_group_name(Option<String>)`](crate::client::fluent_builders::ModifyDBCluster::set_option_group_name): <p>A value that indicates that the DB cluster should be associated with the specified option group.</p>  <p>DB clusters are associated with a default option group that can't be modified.</p>
    ///   - [`preferred_backup_window(impl Into<String>)`](crate::client::fluent_builders::ModifyDBCluster::preferred_backup_window) / [`set_preferred_backup_window(Option<String>)`](crate::client::fluent_builders::ModifyDBCluster::set_preferred_backup_window): <p>The daily time range during which automated backups are created if automated backups are enabled, using the <code>BackupRetentionPeriod</code> parameter.</p>  <p>The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Web Services Region. To view the time blocks available, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.Backups.BackupWindow"> Backup window</a> in the <i>Amazon Aurora User Guide</i>.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must be in the format <code>hh24:mi-hh24:mi</code>.</p> </li>   <li> <p>Must be in Universal Coordinated Time (UTC).</p> </li>   <li> <p>Must not conflict with the preferred maintenance window.</p> </li>   <li> <p>Must be at least 30 minutes.</p> </li>  </ul>  <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
    ///   - [`preferred_maintenance_window(impl Into<String>)`](crate::client::fluent_builders::ModifyDBCluster::preferred_maintenance_window) / [`set_preferred_maintenance_window(Option<String>)`](crate::client::fluent_builders::ModifyDBCluster::set_preferred_maintenance_window): <p>The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).</p>  <p>Format: <code>ddd:hh24:mi-ddd:hh24:mi</code> </p>  <p>The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Web Services Region, occurring on a random day of the week. To see the time blocks available, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow.Aurora"> Adjusting the Preferred DB Cluster Maintenance Window</a> in the <i>Amazon Aurora User Guide</i>.</p>  <p>Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.</p>  <p>Constraints: Minimum 30-minute window.</p>  <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
    ///   - [`enable_iam_database_authentication(bool)`](crate::client::fluent_builders::ModifyDBCluster::enable_iam_database_authentication) / [`set_enable_iam_database_authentication(Option<bool>)`](crate::client::fluent_builders::ModifyDBCluster::set_enable_iam_database_authentication): <p>A value that indicates whether to enable mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts. By default, mapping isn't enabled.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.IAMDBAuth.html"> IAM Database Authentication</a> in the <i>Amazon Aurora User Guide</i>.</p>  <p>Valid for: Aurora DB clusters only</p>
    ///   - [`backtrack_window(i64)`](crate::client::fluent_builders::ModifyDBCluster::backtrack_window) / [`set_backtrack_window(Option<i64>)`](crate::client::fluent_builders::ModifyDBCluster::set_backtrack_window): <p>The target backtrack window, in seconds. To disable backtracking, set this value to 0.</p>  <p>Default: 0</p>  <p>Constraints:</p>  <ul>   <li> <p>If specified, this value must be set to a number from 0 to 259,200 (72 hours).</p> </li>  </ul>  <p>Valid for: Aurora MySQL DB clusters only</p>
    ///   - [`cloudwatch_logs_export_configuration(CloudwatchLogsExportConfiguration)`](crate::client::fluent_builders::ModifyDBCluster::cloudwatch_logs_export_configuration) / [`set_cloudwatch_logs_export_configuration(Option<CloudwatchLogsExportConfiguration>)`](crate::client::fluent_builders::ModifyDBCluster::set_cloudwatch_logs_export_configuration): <p>The configuration setting for the log types to be enabled for export to CloudWatch Logs for a specific DB cluster. The values in the list depend on the DB engine being used.</p>  <p> <b>RDS for MySQL</b> </p>  <p>Possible values are <code>error</code>, <code>general</code>, and <code>slowquery</code>.</p>  <p> <b>RDS for PostgreSQL</b> </p>  <p>Possible values are <code>postgresql</code> and <code>upgrade</code>.</p>  <p> <b>Aurora MySQL</b> </p>  <p>Possible values are <code>audit</code>, <code>error</code>, <code>general</code>, and <code>slowquery</code>.</p>  <p> <b>Aurora PostgreSQL</b> </p>  <p>Possible value is <code>postgresql</code>.</p>  <p>For more information about exporting CloudWatch Logs for Amazon RDS, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch"> Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon RDS User Guide</i>.</p>  <p>For more information about exporting CloudWatch Logs for Amazon Aurora, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch">Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon Aurora User Guide</i>.</p>  <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
    ///   - [`engine_version(impl Into<String>)`](crate::client::fluent_builders::ModifyDBCluster::engine_version) / [`set_engine_version(Option<String>)`](crate::client::fluent_builders::ModifyDBCluster::set_engine_version): <p>The version number of the database engine to which you want to upgrade. Changing this parameter results in an outage. The change is applied during the next maintenance window unless <code>ApplyImmediately</code> is enabled.</p>  <p>To list all of the available engine versions for MySQL 5.6-compatible Aurora, use the following command:</p>  <p> <code>aws rds describe-db-engine-versions --engine aurora --query "DBEngineVersions[].EngineVersion"</code> </p>  <p>To list all of the available engine versions for MySQL 5.7-compatible and MySQL 8.0-compatible Aurora, use the following command:</p>  <p> <code>aws rds describe-db-engine-versions --engine aurora-mysql --query "DBEngineVersions[].EngineVersion"</code> </p>  <p>To list all of the available engine versions for Aurora PostgreSQL, use the following command:</p>  <p> <code>aws rds describe-db-engine-versions --engine aurora-postgresql --query "DBEngineVersions[].EngineVersion"</code> </p>  <p>To list all of the available engine versions for RDS for MySQL, use the following command:</p>  <p> <code>aws rds describe-db-engine-versions --engine mysql --query "DBEngineVersions[].EngineVersion"</code> </p>  <p>To list all of the available engine versions for RDS for PostgreSQL, use the following command:</p>  <p> <code>aws rds describe-db-engine-versions --engine postgres --query "DBEngineVersions[].EngineVersion"</code> </p>  <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
    ///   - [`allow_major_version_upgrade(bool)`](crate::client::fluent_builders::ModifyDBCluster::allow_major_version_upgrade) / [`set_allow_major_version_upgrade(bool)`](crate::client::fluent_builders::ModifyDBCluster::set_allow_major_version_upgrade): <p>A value that indicates whether major version upgrades are allowed.</p>  <p>Constraints: You must allow major version upgrades when specifying a value for the <code>EngineVersion</code> parameter that is a different major version than the DB cluster's current version.</p>  <p>Valid for: Aurora DB clusters only</p>
    ///   - [`db_instance_parameter_group_name(impl Into<String>)`](crate::client::fluent_builders::ModifyDBCluster::db_instance_parameter_group_name) / [`set_db_instance_parameter_group_name(Option<String>)`](crate::client::fluent_builders::ModifyDBCluster::set_db_instance_parameter_group_name): <p>The name of the DB parameter group to apply to all instances of the DB cluster.</p> <note>   <p>When you apply a parameter group using the <code>DBInstanceParameterGroupName</code> parameter, the DB cluster isn't rebooted automatically. Also, parameter changes are applied immediately rather than during the next maintenance window.</p>  </note>  <p>Default: The existing name setting</p>  <p>Constraints:</p>  <ul>   <li> <p>The DB parameter group must be in the same DB parameter group family as this DB cluster.</p> </li>   <li> <p>The <code>DBInstanceParameterGroupName</code> parameter is valid in combination with the <code>AllowMajorVersionUpgrade</code> parameter for a major version upgrade only.</p> </li>  </ul>  <p>Valid for: Aurora DB clusters only</p>
    ///   - [`domain(impl Into<String>)`](crate::client::fluent_builders::ModifyDBCluster::domain) / [`set_domain(Option<String>)`](crate::client::fluent_builders::ModifyDBCluster::set_domain): <p>The Active Directory directory ID to move the DB cluster to. Specify <code>none</code> to remove the cluster from its current domain. The domain must be created prior to this operation.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/kerberos-authentication.html">Kerberos Authentication</a> in the <i>Amazon Aurora User Guide</i>.</p>  <p>Valid for: Aurora DB clusters only</p>
    ///   - [`domain_iam_role_name(impl Into<String>)`](crate::client::fluent_builders::ModifyDBCluster::domain_iam_role_name) / [`set_domain_iam_role_name(Option<String>)`](crate::client::fluent_builders::ModifyDBCluster::set_domain_iam_role_name): <p>Specify the name of the IAM role to be used when making API calls to the Directory Service.</p>  <p>Valid for: Aurora DB clusters only</p>
    ///   - [`scaling_configuration(ScalingConfiguration)`](crate::client::fluent_builders::ModifyDBCluster::scaling_configuration) / [`set_scaling_configuration(Option<ScalingConfiguration>)`](crate::client::fluent_builders::ModifyDBCluster::set_scaling_configuration): <p>The scaling properties of the DB cluster. You can only modify scaling properties for DB clusters in <code>serverless</code> DB engine mode.</p>  <p>Valid for: Aurora DB clusters only</p>
    ///   - [`deletion_protection(bool)`](crate::client::fluent_builders::ModifyDBCluster::deletion_protection) / [`set_deletion_protection(Option<bool>)`](crate::client::fluent_builders::ModifyDBCluster::set_deletion_protection): <p>A value that indicates whether the DB cluster has deletion protection enabled. The database can't be deleted when deletion protection is enabled. By default, deletion protection isn't enabled.</p>  <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
    ///   - [`enable_http_endpoint(bool)`](crate::client::fluent_builders::ModifyDBCluster::enable_http_endpoint) / [`set_enable_http_endpoint(Option<bool>)`](crate::client::fluent_builders::ModifyDBCluster::set_enable_http_endpoint): <p>A value that indicates whether to enable the HTTP endpoint for an Aurora Serverless v1 DB cluster. By default, the HTTP endpoint is disabled.</p>  <p>When enabled, the HTTP endpoint provides a connectionless web service API for running SQL queries on the Aurora Serverless v1 DB cluster. You can also query your database from inside the RDS console with the query editor.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/data-api.html">Using the Data API for Aurora Serverless v1</a> in the <i>Amazon Aurora User Guide</i>.</p>  <p>Valid for: Aurora DB clusters only</p>
    ///   - [`copy_tags_to_snapshot(bool)`](crate::client::fluent_builders::ModifyDBCluster::copy_tags_to_snapshot) / [`set_copy_tags_to_snapshot(Option<bool>)`](crate::client::fluent_builders::ModifyDBCluster::set_copy_tags_to_snapshot): <p>A value that indicates whether to copy all tags from the DB cluster to snapshots of the DB cluster. The default is not to copy them.</p>  <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
    ///   - [`enable_global_write_forwarding(bool)`](crate::client::fluent_builders::ModifyDBCluster::enable_global_write_forwarding) / [`set_enable_global_write_forwarding(Option<bool>)`](crate::client::fluent_builders::ModifyDBCluster::set_enable_global_write_forwarding): <p>A value that indicates whether to enable this DB cluster to forward write operations to the primary cluster of an Aurora global database (<code>GlobalCluster</code>). By default, write operations are not allowed on Aurora DB clusters that are secondary clusters in an Aurora global database.</p>  <p>You can set this value only on Aurora DB clusters that are members of an Aurora global database. With this parameter enabled, a secondary cluster can forward writes to the current primary cluster and the resulting changes are replicated back to this cluster. For the primary DB cluster of an Aurora global database, this value is used immediately if the primary is demoted by the <code>FailoverGlobalCluster</code> API operation, but it does nothing until then.</p>  <p>Valid for: Aurora DB clusters only</p>
    ///   - [`db_cluster_instance_class(impl Into<String>)`](crate::client::fluent_builders::ModifyDBCluster::db_cluster_instance_class) / [`set_db_cluster_instance_class(Option<String>)`](crate::client::fluent_builders::ModifyDBCluster::set_db_cluster_instance_class): <p>The compute and memory capacity of each DB instance in the Multi-AZ DB cluster, for example db.m6g.xlarge. Not all DB instance classes are available in all Amazon Web Services Regions, or for all database engines.</p>  <p>For the full list of DB instance classes and availability for your engine, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html"> DB Instance Class</a> in the <i>Amazon RDS User Guide</i>.</p>  <p>Valid for: Multi-AZ DB clusters only</p>
    ///   - [`allocated_storage(i32)`](crate::client::fluent_builders::ModifyDBCluster::allocated_storage) / [`set_allocated_storage(Option<i32>)`](crate::client::fluent_builders::ModifyDBCluster::set_allocated_storage): <p>The amount of storage in gibibytes (GiB) to allocate to each DB instance in the Multi-AZ DB cluster.</p>  <p>Type: Integer</p>  <p>Valid for: Multi-AZ DB clusters only</p>
    ///   - [`storage_type(impl Into<String>)`](crate::client::fluent_builders::ModifyDBCluster::storage_type) / [`set_storage_type(Option<String>)`](crate::client::fluent_builders::ModifyDBCluster::set_storage_type): <p>Specifies the storage type to be associated with the DB cluster.</p>  <p>Valid values: <code>io1</code> </p>  <p>When specified, a value for the <code>Iops</code> parameter is required.</p>  <p>Default: <code>io1</code> </p>  <p>Valid for: Multi-AZ DB clusters only</p>
    ///   - [`iops(i32)`](crate::client::fluent_builders::ModifyDBCluster::iops) / [`set_iops(Option<i32>)`](crate::client::fluent_builders::ModifyDBCluster::set_iops): <p>The amount of Provisioned IOPS (input/output operations per second) to be initially allocated for each DB instance in the Multi-AZ DB cluster.</p>  <p>For information about valid Iops values, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#USER_PIOPS">Amazon RDS Provisioned IOPS Storage to Improve Performance</a> in the <i>Amazon RDS User Guide</i>.</p>  <p>Constraints: Must be a multiple between .5 and 50 of the storage amount for the DB cluster.</p>  <p>Valid for: Multi-AZ DB clusters only</p>
    ///   - [`auto_minor_version_upgrade(bool)`](crate::client::fluent_builders::ModifyDBCluster::auto_minor_version_upgrade) / [`set_auto_minor_version_upgrade(Option<bool>)`](crate::client::fluent_builders::ModifyDBCluster::set_auto_minor_version_upgrade): <p>A value that indicates whether minor engine upgrades are applied automatically to the DB cluster during the maintenance window. By default, minor engine upgrades are applied automatically.</p>  <p>Valid for: Multi-AZ DB clusters only</p>
    ///   - [`monitoring_interval(i32)`](crate::client::fluent_builders::ModifyDBCluster::monitoring_interval) / [`set_monitoring_interval(Option<i32>)`](crate::client::fluent_builders::ModifyDBCluster::set_monitoring_interval): <p>The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB cluster. To turn off collecting Enhanced Monitoring metrics, specify 0. The default is 0.</p>  <p>If <code>MonitoringRoleArn</code> is specified, also set <code>MonitoringInterval</code> to a value other than 0.</p>  <p>Valid Values: <code>0, 1, 5, 10, 15, 30, 60</code> </p>  <p>Valid for: Multi-AZ DB clusters only</p>
    ///   - [`monitoring_role_arn(impl Into<String>)`](crate::client::fluent_builders::ModifyDBCluster::monitoring_role_arn) / [`set_monitoring_role_arn(Option<String>)`](crate::client::fluent_builders::ModifyDBCluster::set_monitoring_role_arn): <p>The Amazon Resource Name (ARN) for the IAM role that permits RDS to send Enhanced Monitoring metrics to Amazon CloudWatch Logs. An example is <code>arn:aws:iam:123456789012:role/emaccess</code>. For information on creating a monitoring role, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.html#USER_Monitoring.OS.IAMRole">To create an IAM role for Amazon RDS Enhanced Monitoring</a> in the <i>Amazon RDS User Guide.</i> </p>  <p>If <code>MonitoringInterval</code> is set to a value other than 0, supply a <code>MonitoringRoleArn</code> value.</p>  <p>Valid for: Multi-AZ DB clusters only</p>
    ///   - [`enable_performance_insights(bool)`](crate::client::fluent_builders::ModifyDBCluster::enable_performance_insights) / [`set_enable_performance_insights(Option<bool>)`](crate::client::fluent_builders::ModifyDBCluster::set_enable_performance_insights): <p>A value that indicates whether to turn on Performance Insights for the DB cluster.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html"> Using Amazon Performance Insights</a> in the <i>Amazon RDS User Guide</i>.</p>  <p>Valid for: Multi-AZ DB clusters only</p>
    ///   - [`performance_insights_kms_key_id(impl Into<String>)`](crate::client::fluent_builders::ModifyDBCluster::performance_insights_kms_key_id) / [`set_performance_insights_kms_key_id(Option<String>)`](crate::client::fluent_builders::ModifyDBCluster::set_performance_insights_kms_key_id): <p>The Amazon Web Services KMS key identifier for encryption of Performance Insights data.</p>  <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.</p>  <p>If you don't specify a value for <code>PerformanceInsightsKMSKeyId</code>, then Amazon RDS uses your default KMS key. There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account has a different default KMS key for each Amazon Web Services Region.</p>  <p>Valid for: Multi-AZ DB clusters only</p>
    ///   - [`performance_insights_retention_period(i32)`](crate::client::fluent_builders::ModifyDBCluster::performance_insights_retention_period) / [`set_performance_insights_retention_period(Option<i32>)`](crate::client::fluent_builders::ModifyDBCluster::set_performance_insights_retention_period): <p>The amount of time, in days, to retain Performance Insights data. Valid values are 7 or 731 (2 years).</p>  <p>Valid for: Multi-AZ DB clusters only</p>
    ///   - [`serverless_v2_scaling_configuration(ServerlessV2ScalingConfiguration)`](crate::client::fluent_builders::ModifyDBCluster::serverless_v2_scaling_configuration) / [`set_serverless_v2_scaling_configuration(Option<ServerlessV2ScalingConfiguration>)`](crate::client::fluent_builders::ModifyDBCluster::set_serverless_v2_scaling_configuration): <p>Contains the scaling configuration of an Aurora Serverless v2 DB cluster.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless-v2.html">Using Amazon Aurora Serverless v2</a> in the <i>Amazon Aurora User Guide</i>.</p>
    /// - On success, responds with [`ModifyDbClusterOutput`](crate::output::ModifyDbClusterOutput) with field(s):
    ///   - [`db_cluster(Option<DbCluster>)`](crate::output::ModifyDbClusterOutput::db_cluster): <p>Contains the details of an Amazon Aurora DB cluster or Multi-AZ DB cluster.</p>  <p>For an Amazon Aurora DB cluster, this data type is used as a response element in the operations <code>CreateDBCluster</code>, <code>DeleteDBCluster</code>, <code>DescribeDBClusters</code>, <code>FailoverDBCluster</code>, <code>ModifyDBCluster</code>, <code>PromoteReadReplicaDBCluster</code>, <code>RestoreDBClusterFromS3</code>, <code>RestoreDBClusterFromSnapshot</code>, <code>RestoreDBClusterToPointInTime</code>, <code>StartDBCluster</code>, and <code>StopDBCluster</code>.</p>  <p>For a Multi-AZ DB cluster, this data type is used as a response element in the operations <code>CreateDBCluster</code>, <code>DeleteDBCluster</code>, <code>DescribeDBClusters</code>, <code>FailoverDBCluster</code>, <code>ModifyDBCluster</code>, <code>RebootDBCluster</code>, <code>RestoreDBClusterFromSnapshot</code>, and <code>RestoreDBClusterToPointInTime</code>.</p>  <p>For more information on Amazon Aurora DB clusters, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon Aurora?</a> in the <i>Amazon Aurora User Guide.</i> </p>  <p>For more information on Multi-AZ DB clusters, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ deployments with two readable standby DB instances</a> in the <i>Amazon RDS User Guide.</i> </p>
    /// - On failure, responds with [`SdkError<ModifyDBClusterError>`](crate::error::ModifyDBClusterError)
    pub fn modify_db_cluster(&self) -> fluent_builders::ModifyDBCluster {
        fluent_builders::ModifyDBCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ModifyDBClusterEndpoint`](crate::client::fluent_builders::ModifyDBClusterEndpoint) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_cluster_endpoint_identifier(impl Into<String>)`](crate::client::fluent_builders::ModifyDBClusterEndpoint::db_cluster_endpoint_identifier) / [`set_db_cluster_endpoint_identifier(Option<String>)`](crate::client::fluent_builders::ModifyDBClusterEndpoint::set_db_cluster_endpoint_identifier): <p>The identifier of the endpoint to modify. This parameter is stored as a lowercase string.</p>
    ///   - [`endpoint_type(impl Into<String>)`](crate::client::fluent_builders::ModifyDBClusterEndpoint::endpoint_type) / [`set_endpoint_type(Option<String>)`](crate::client::fluent_builders::ModifyDBClusterEndpoint::set_endpoint_type): <p>The type of the endpoint. One of: <code>READER</code>, <code>WRITER</code>, <code>ANY</code>.</p>
    ///   - [`static_members(Vec<String>)`](crate::client::fluent_builders::ModifyDBClusterEndpoint::static_members) / [`set_static_members(Option<Vec<String>>)`](crate::client::fluent_builders::ModifyDBClusterEndpoint::set_static_members): <p>List of DB instance identifiers that are part of the custom endpoint group.</p>
    ///   - [`excluded_members(Vec<String>)`](crate::client::fluent_builders::ModifyDBClusterEndpoint::excluded_members) / [`set_excluded_members(Option<Vec<String>>)`](crate::client::fluent_builders::ModifyDBClusterEndpoint::set_excluded_members): <p>List of DB instance identifiers that aren't part of the custom endpoint group. All other eligible instances are reachable through the custom endpoint. Only relevant if the list of static members is empty.</p>
    /// - On success, responds with [`ModifyDbClusterEndpointOutput`](crate::output::ModifyDbClusterEndpointOutput) with field(s):
    ///   - [`db_cluster_endpoint_identifier(Option<String>)`](crate::output::ModifyDbClusterEndpointOutput::db_cluster_endpoint_identifier): <p>The identifier associated with the endpoint. This parameter is stored as a lowercase string.</p>
    ///   - [`db_cluster_identifier(Option<String>)`](crate::output::ModifyDbClusterEndpointOutput::db_cluster_identifier): <p>The DB cluster identifier of the DB cluster associated with the endpoint. This parameter is stored as a lowercase string.</p>
    ///   - [`db_cluster_endpoint_resource_identifier(Option<String>)`](crate::output::ModifyDbClusterEndpointOutput::db_cluster_endpoint_resource_identifier): <p>A unique system-generated identifier for an endpoint. It remains the same for the whole life of the endpoint.</p>
    ///   - [`endpoint(Option<String>)`](crate::output::ModifyDbClusterEndpointOutput::endpoint): <p>The DNS address of the endpoint.</p>
    ///   - [`status(Option<String>)`](crate::output::ModifyDbClusterEndpointOutput::status): <p>The current status of the endpoint. One of: <code>creating</code>, <code>available</code>, <code>deleting</code>, <code>inactive</code>, <code>modifying</code>. The <code>inactive</code> state applies to an endpoint that can't be used for a certain kind of cluster, such as a <code>writer</code> endpoint for a read-only secondary cluster in a global database.</p>
    ///   - [`endpoint_type(Option<String>)`](crate::output::ModifyDbClusterEndpointOutput::endpoint_type): <p>The type of the endpoint. One of: <code>READER</code>, <code>WRITER</code>, <code>CUSTOM</code>.</p>
    ///   - [`custom_endpoint_type(Option<String>)`](crate::output::ModifyDbClusterEndpointOutput::custom_endpoint_type): <p>The type associated with a custom endpoint. One of: <code>READER</code>, <code>WRITER</code>, <code>ANY</code>.</p>
    ///   - [`static_members(Option<Vec<String>>)`](crate::output::ModifyDbClusterEndpointOutput::static_members): <p>List of DB instance identifiers that are part of the custom endpoint group.</p>
    ///   - [`excluded_members(Option<Vec<String>>)`](crate::output::ModifyDbClusterEndpointOutput::excluded_members): <p>List of DB instance identifiers that aren't part of the custom endpoint group. All other eligible instances are reachable through the custom endpoint. Only relevant if the list of static members is empty.</p>
    ///   - [`db_cluster_endpoint_arn(Option<String>)`](crate::output::ModifyDbClusterEndpointOutput::db_cluster_endpoint_arn): <p>The Amazon Resource Name (ARN) for the endpoint.</p>
    /// - On failure, responds with [`SdkError<ModifyDBClusterEndpointError>`](crate::error::ModifyDBClusterEndpointError)
    pub fn modify_db_cluster_endpoint(&self) -> fluent_builders::ModifyDBClusterEndpoint {
        fluent_builders::ModifyDBClusterEndpoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ModifyDBClusterParameterGroup`](crate::client::fluent_builders::ModifyDBClusterParameterGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_cluster_parameter_group_name(impl Into<String>)`](crate::client::fluent_builders::ModifyDBClusterParameterGroup::db_cluster_parameter_group_name) / [`set_db_cluster_parameter_group_name(Option<String>)`](crate::client::fluent_builders::ModifyDBClusterParameterGroup::set_db_cluster_parameter_group_name): <p>The name of the DB cluster parameter group to modify.</p>
    ///   - [`parameters(Vec<Parameter>)`](crate::client::fluent_builders::ModifyDBClusterParameterGroup::parameters) / [`set_parameters(Option<Vec<Parameter>>)`](crate::client::fluent_builders::ModifyDBClusterParameterGroup::set_parameters): <p>A list of parameters in the DB cluster parameter group to modify.</p>  <p>Valid Values (for the application method): <code>immediate | pending-reboot</code> </p> <note>   <p>You can use the <code>immediate</code> value with dynamic parameters only. You can use the <code>pending-reboot</code> value for both dynamic and static parameters.</p>   <p>When the application method is <code>immediate</code>, changes to dynamic parameters are applied immediately to the DB clusters associated with the parameter group. When the application method is <code>pending-reboot</code>, changes to dynamic and static parameters are applied after a reboot without failover to the DB clusters associated with the parameter group.</p>  </note>
    /// - On success, responds with [`ModifyDbClusterParameterGroupOutput`](crate::output::ModifyDbClusterParameterGroupOutput) with field(s):
    ///   - [`db_cluster_parameter_group_name(Option<String>)`](crate::output::ModifyDbClusterParameterGroupOutput::db_cluster_parameter_group_name): <p>The name of the DB cluster parameter group.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must be 1 to 255 letters or numbers.</p> </li>   <li> <p>First character must be a letter</p> </li>   <li> <p>Can't end with a hyphen or contain two consecutive hyphens</p> </li>  </ul> <note>   <p>This value is stored as a lowercase string.</p>  </note>
    /// - On failure, responds with [`SdkError<ModifyDBClusterParameterGroupError>`](crate::error::ModifyDBClusterParameterGroupError)
    pub fn modify_db_cluster_parameter_group(
        &self,
    ) -> fluent_builders::ModifyDBClusterParameterGroup {
        fluent_builders::ModifyDBClusterParameterGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ModifyDBClusterSnapshotAttribute`](crate::client::fluent_builders::ModifyDBClusterSnapshotAttribute) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_cluster_snapshot_identifier(impl Into<String>)`](crate::client::fluent_builders::ModifyDBClusterSnapshotAttribute::db_cluster_snapshot_identifier) / [`set_db_cluster_snapshot_identifier(Option<String>)`](crate::client::fluent_builders::ModifyDBClusterSnapshotAttribute::set_db_cluster_snapshot_identifier): <p>The identifier for the DB cluster snapshot to modify the attributes for.</p>
    ///   - [`attribute_name(impl Into<String>)`](crate::client::fluent_builders::ModifyDBClusterSnapshotAttribute::attribute_name) / [`set_attribute_name(Option<String>)`](crate::client::fluent_builders::ModifyDBClusterSnapshotAttribute::set_attribute_name): <p>The name of the DB cluster snapshot attribute to modify.</p>  <p>To manage authorization for other Amazon Web Services accounts to copy or restore a manual DB cluster snapshot, set this value to <code>restore</code>.</p> <note>   <p>To view the list of attributes available to modify, use the <code>DescribeDBClusterSnapshotAttributes</code> API action.</p>  </note>
    ///   - [`values_to_add(Vec<String>)`](crate::client::fluent_builders::ModifyDBClusterSnapshotAttribute::values_to_add) / [`set_values_to_add(Option<Vec<String>>)`](crate::client::fluent_builders::ModifyDBClusterSnapshotAttribute::set_values_to_add): <p>A list of DB cluster snapshot attributes to add to the attribute specified by <code>AttributeName</code>.</p>  <p>To authorize other Amazon Web Services accounts to copy or restore a manual DB cluster snapshot, set this list to include one or more Amazon Web Services account IDs, or <code>all</code> to make the manual DB cluster snapshot restorable by any Amazon Web Services account. Do not add the <code>all</code> value for any manual DB cluster snapshots that contain private information that you don't want available to all Amazon Web Services accounts.</p>
    ///   - [`values_to_remove(Vec<String>)`](crate::client::fluent_builders::ModifyDBClusterSnapshotAttribute::values_to_remove) / [`set_values_to_remove(Option<Vec<String>>)`](crate::client::fluent_builders::ModifyDBClusterSnapshotAttribute::set_values_to_remove): <p>A list of DB cluster snapshot attributes to remove from the attribute specified by <code>AttributeName</code>.</p>  <p>To remove authorization for other Amazon Web Services accounts to copy or restore a manual DB cluster snapshot, set this list to include one or more Amazon Web Services account identifiers, or <code>all</code> to remove authorization for any Amazon Web Services account to copy or restore the DB cluster snapshot. If you specify <code>all</code>, an Amazon Web Services account whose account ID is explicitly added to the <code>restore</code> attribute can still copy or restore a manual DB cluster snapshot.</p>
    /// - On success, responds with [`ModifyDbClusterSnapshotAttributeOutput`](crate::output::ModifyDbClusterSnapshotAttributeOutput) with field(s):
    ///   - [`db_cluster_snapshot_attributes_result(Option<DbClusterSnapshotAttributesResult>)`](crate::output::ModifyDbClusterSnapshotAttributeOutput::db_cluster_snapshot_attributes_result): <p>Contains the results of a successful call to the <code>DescribeDBClusterSnapshotAttributes</code> API action.</p>  <p>Manual DB cluster snapshot attributes are used to authorize other Amazon Web Services accounts to copy or restore a manual DB cluster snapshot. For more information, see the <code>ModifyDBClusterSnapshotAttribute</code> API action.</p>
    /// - On failure, responds with [`SdkError<ModifyDBClusterSnapshotAttributeError>`](crate::error::ModifyDBClusterSnapshotAttributeError)
    pub fn modify_db_cluster_snapshot_attribute(
        &self,
    ) -> fluent_builders::ModifyDBClusterSnapshotAttribute {
        fluent_builders::ModifyDBClusterSnapshotAttribute::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ModifyDBInstance`](crate::client::fluent_builders::ModifyDBInstance) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_instance_identifier(impl Into<String>)`](crate::client::fluent_builders::ModifyDBInstance::db_instance_identifier) / [`set_db_instance_identifier(Option<String>)`](crate::client::fluent_builders::ModifyDBInstance::set_db_instance_identifier): <p>The DB instance identifier. This value is stored as a lowercase string.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must match the identifier of an existing DBInstance.</p> </li>  </ul>
    ///   - [`allocated_storage(i32)`](crate::client::fluent_builders::ModifyDBInstance::allocated_storage) / [`set_allocated_storage(Option<i32>)`](crate::client::fluent_builders::ModifyDBInstance::set_allocated_storage): <p>The new amount of storage in gibibytes (GiB) to allocate for the DB instance.</p>  <p>For MariaDB, MySQL, Oracle, and PostgreSQL, the value supplied must be at least 10% greater than the current value. Values that are not at least 10% greater than the existing value are rounded up so that they are 10% greater than the current value.</p>  <p>For the valid values for allocated storage for each engine, see <code>CreateDBInstance</code>.</p>
    ///   - [`db_instance_class(impl Into<String>)`](crate::client::fluent_builders::ModifyDBInstance::db_instance_class) / [`set_db_instance_class(Option<String>)`](crate::client::fluent_builders::ModifyDBInstance::set_db_instance_class): <p>The new compute and memory capacity of the DB instance, for example db.m4.large. Not all DB instance classes are available in all Amazon Web Services Regions, or for all database engines. For the full list of DB instance classes, and availability for your engine, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html">DB Instance Class</a> in the <i>Amazon RDS User Guide</i>.</p>  <p>If you modify the DB instance class, an outage occurs during the change. The change is applied during the next maintenance window, unless <code>ApplyImmediately</code> is enabled for this request.</p>  <p>This setting doesn't apply to RDS Custom for Oracle.</p>  <p>Default: Uses existing setting</p>
    ///   - [`db_subnet_group_name(impl Into<String>)`](crate::client::fluent_builders::ModifyDBInstance::db_subnet_group_name) / [`set_db_subnet_group_name(Option<String>)`](crate::client::fluent_builders::ModifyDBInstance::set_db_subnet_group_name): <p>The new DB subnet group for the DB instance. You can use this parameter to move your DB instance to a different VPC. If your DB instance isn't in a VPC, you can also use this parameter to move your DB instance into a VPC. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html#USER_VPC.Non-VPC2VPC">Working with a DB instance in a VPC</a> in the <i>Amazon RDS User Guide</i>.</p>  <p>Changing the subnet group causes an outage during the change. The change is applied during the next maintenance window, unless you enable <code>ApplyImmediately</code>.</p>  <p>This parameter doesn't apply to RDS Custom.</p>  <p>Constraints: If supplied, must match the name of an existing DBSubnetGroup.</p>  <p>Example: <code>mydbsubnetgroup</code> </p>
    ///   - [`db_security_groups(Vec<String>)`](crate::client::fluent_builders::ModifyDBInstance::db_security_groups) / [`set_db_security_groups(Option<Vec<String>>)`](crate::client::fluent_builders::ModifyDBInstance::set_db_security_groups): <p>A list of DB security groups to authorize on this DB instance. Changing this setting doesn't result in an outage and the change is asynchronously applied as soon as possible.</p>  <p>This setting doesn't apply to RDS Custom.</p>  <p>Constraints:</p>  <ul>   <li> <p>If supplied, must match existing DBSecurityGroups.</p> </li>  </ul>
    ///   - [`vpc_security_group_ids(Vec<String>)`](crate::client::fluent_builders::ModifyDBInstance::vpc_security_group_ids) / [`set_vpc_security_group_ids(Option<Vec<String>>)`](crate::client::fluent_builders::ModifyDBInstance::set_vpc_security_group_ids): <p>A list of Amazon EC2 VPC security groups to authorize on this DB instance. This change is asynchronously applied as soon as possible.</p>  <p>This setting doesn't apply to RDS Custom.</p>  <p> <b>Amazon Aurora</b> </p>  <p>Not applicable. The associated list of EC2 VPC security groups is managed by the DB cluster. For more information, see <code>ModifyDBCluster</code>.</p>  <p>Constraints:</p>  <ul>   <li> <p>If supplied, must match existing VpcSecurityGroupIds.</p> </li>  </ul>
    ///   - [`apply_immediately(bool)`](crate::client::fluent_builders::ModifyDBInstance::apply_immediately) / [`set_apply_immediately(bool)`](crate::client::fluent_builders::ModifyDBInstance::set_apply_immediately): <p>A value that indicates whether the modifications in this request and any pending modifications are asynchronously applied as soon as possible, regardless of the <code>PreferredMaintenanceWindow</code> setting for the DB instance. By default, this parameter is disabled.</p>  <p>If this parameter is disabled, changes to the DB instance are applied during the next maintenance window. Some parameter changes can cause an outage and are applied on the next call to <code>RebootDBInstance</code>, or the next failure reboot. Review the table of parameters in <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Overview.DBInstance.Modifying.html">Modifying a DB Instance</a> in the <i>Amazon RDS User Guide</i> to see the impact of enabling or disabling <code>ApplyImmediately</code> for each modified parameter and to determine when the changes are applied.</p>
    ///   - [`master_user_password(impl Into<String>)`](crate::client::fluent_builders::ModifyDBInstance::master_user_password) / [`set_master_user_password(Option<String>)`](crate::client::fluent_builders::ModifyDBInstance::set_master_user_password): <p>The new password for the master user. The password can include any printable ASCII character except "/", """, or "@".</p>  <p>Changing this parameter doesn't result in an outage and the change is asynchronously applied as soon as possible. Between the time of the request and the completion of the request, the <code>MasterUserPassword</code> element exists in the <code>PendingModifiedValues</code> element of the operation response.</p>  <p>This setting doesn't apply to RDS Custom.</p>  <p> <b>Amazon Aurora</b> </p>  <p>Not applicable. The password for the master user is managed by the DB cluster. For more information, see <code>ModifyDBCluster</code>.</p>  <p>Default: Uses existing setting</p>  <p> <b>MariaDB</b> </p>  <p>Constraints: Must contain from 8 to 41 characters.</p>  <p> <b>Microsoft SQL Server</b> </p>  <p>Constraints: Must contain from 8 to 128 characters.</p>  <p> <b>MySQL</b> </p>  <p>Constraints: Must contain from 8 to 41 characters.</p>  <p> <b>Oracle</b> </p>  <p>Constraints: Must contain from 8 to 30 characters.</p>  <p> <b>PostgreSQL</b> </p>  <p>Constraints: Must contain from 8 to 128 characters.</p> <note>   <p>Amazon RDS API actions never return the password, so this action provides a way to regain access to a primary instance user if the password is lost. This includes restoring privileges that might have been accidentally revoked.</p>  </note>
    ///   - [`db_parameter_group_name(impl Into<String>)`](crate::client::fluent_builders::ModifyDBInstance::db_parameter_group_name) / [`set_db_parameter_group_name(Option<String>)`](crate::client::fluent_builders::ModifyDBInstance::set_db_parameter_group_name): <p>The name of the DB parameter group to apply to the DB instance.</p>  <p>Changing this setting doesn't result in an outage. The parameter group name itself is changed immediately, but the actual parameter changes are not applied until you reboot the instance without failover. In this case, the DB instance isn't rebooted automatically, and the parameter changes aren't applied during the next maintenance window. However, if you modify dynamic parameters in the newly associated DB parameter group, these changes are applied immediately without a reboot.</p>  <p>This setting doesn't apply to RDS Custom.</p>  <p>Default: Uses existing setting</p>  <p>Constraints: The DB parameter group must be in the same DB parameter group family as the DB instance.</p>
    ///   - [`backup_retention_period(i32)`](crate::client::fluent_builders::ModifyDBInstance::backup_retention_period) / [`set_backup_retention_period(Option<i32>)`](crate::client::fluent_builders::ModifyDBInstance::set_backup_retention_period): <p>The number of days to retain automated backups. Setting this parameter to a positive number enables backups. Setting this parameter to 0 disables automated backups.</p> <note>   <p>Enabling and disabling backups can result in a brief I/O suspension that lasts from a few seconds to a few minutes, depending on the size and class of your DB instance.</p>  </note>  <p>These changes are applied during the next maintenance window unless the <code>ApplyImmediately</code> parameter is enabled for this request. If you change the parameter from one non-zero value to another non-zero value, the change is asynchronously applied as soon as possible.</p>  <p> <b>Amazon Aurora</b> </p>  <p>Not applicable. The retention period for automated backups is managed by the DB cluster. For more information, see <code>ModifyDBCluster</code>.</p>  <p>Default: Uses existing setting</p>  <p>Constraints:</p>  <ul>   <li> <p>It must be a value from 0 to 35. It can't be set to 0 if the DB instance is a source to read replicas. It can't be set to 0 or 35 for an RDS Custom for Oracle DB instance.</p> </li>   <li> <p>It can be specified for a MySQL read replica only if the source is running MySQL 5.6 or later.</p> </li>   <li> <p>It can be specified for a PostgreSQL read replica only if the source is running PostgreSQL 9.3.5.</p> </li>  </ul>
    ///   - [`preferred_backup_window(impl Into<String>)`](crate::client::fluent_builders::ModifyDBInstance::preferred_backup_window) / [`set_preferred_backup_window(Option<String>)`](crate::client::fluent_builders::ModifyDBInstance::set_preferred_backup_window): <p>The daily time range during which automated backups are created if automated backups are enabled, as determined by the <code>BackupRetentionPeriod</code> parameter. Changing this parameter doesn't result in an outage and the change is asynchronously applied as soon as possible. The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Web Services Region. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithAutomatedBackups.html#USER_WorkingWithAutomatedBackups.BackupWindow">Backup window</a> in the <i>Amazon RDS User Guide.</i> </p>  <p> <b>Amazon Aurora</b> </p>  <p>Not applicable. The daily time range for creating automated backups is managed by the DB cluster. For more information, see <code>ModifyDBCluster</code>.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must be in the format hh24:mi-hh24:mi</p> </li>   <li> <p>Must be in Universal Time Coordinated (UTC)</p> </li>   <li> <p>Must not conflict with the preferred maintenance window</p> </li>   <li> <p>Must be at least 30 minutes</p> </li>  </ul>
    ///   - [`preferred_maintenance_window(impl Into<String>)`](crate::client::fluent_builders::ModifyDBInstance::preferred_maintenance_window) / [`set_preferred_maintenance_window(Option<String>)`](crate::client::fluent_builders::ModifyDBInstance::set_preferred_maintenance_window): <p>The weekly time range (in UTC) during which system maintenance can occur, which might result in an outage. Changing this parameter doesn't result in an outage, except in the following situation, and the change is asynchronously applied as soon as possible. If there are pending actions that cause a reboot, and the maintenance window is changed to include the current time, then changing this parameter will cause a reboot of the DB instance. If moving this window to the current time, there must be at least 30 minutes between the current time and end of the window to ensure pending changes are applied.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Maintenance.html#Concepts.DBMaintenance">Amazon RDS Maintenance Window</a> in the <i>Amazon RDS User Guide.</i> </p>  <p>Default: Uses existing setting</p>  <p>Format: ddd:hh24:mi-ddd:hh24:mi</p>  <p>Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun</p>  <p>Constraints: Must be at least 30 minutes</p>
    ///   - [`multi_az(bool)`](crate::client::fluent_builders::ModifyDBInstance::multi_az) / [`set_multi_az(Option<bool>)`](crate::client::fluent_builders::ModifyDBInstance::set_multi_az): <p>A value that indicates whether the DB instance is a Multi-AZ deployment. Changing this parameter doesn't result in an outage. The change is applied during the next maintenance window unless the <code>ApplyImmediately</code> parameter is enabled for this request.</p>  <p>This setting doesn't apply to RDS Custom.</p>
    ///   - [`engine_version(impl Into<String>)`](crate::client::fluent_builders::ModifyDBInstance::engine_version) / [`set_engine_version(Option<String>)`](crate::client::fluent_builders::ModifyDBInstance::set_engine_version): <p>The version number of the database engine to upgrade to. Changing this parameter results in an outage and the change is applied during the next maintenance window unless the <code>ApplyImmediately</code> parameter is enabled for this request.</p>  <p>For major version upgrades, if a nondefault DB parameter group is currently in use, a new DB parameter group in the DB parameter group family for the new engine version must be specified. The new DB parameter group can be the default for that DB parameter group family.</p>  <p>If you specify only a major version, Amazon RDS will update the DB instance to the default minor version if the current minor version is lower. For information about valid engine versions, see <code>CreateDBInstance</code>, or call <code>DescribeDBEngineVersions</code>.</p>  <p>In RDS Custom for Oracle, this parameter is supported for read replicas only if they are in the <code>PATCH_DB_FAILURE</code> lifecycle.</p>
    ///   - [`allow_major_version_upgrade(bool)`](crate::client::fluent_builders::ModifyDBInstance::allow_major_version_upgrade) / [`set_allow_major_version_upgrade(bool)`](crate::client::fluent_builders::ModifyDBInstance::set_allow_major_version_upgrade): <p>A value that indicates whether major version upgrades are allowed. Changing this parameter doesn't result in an outage and the change is asynchronously applied as soon as possible.</p>  <p>This setting doesn't apply to RDS Custom.</p>  <p>Constraints: Major version upgrades must be allowed when specifying a value for the EngineVersion parameter that is a different major version than the DB instance's current version.</p>
    ///   - [`auto_minor_version_upgrade(bool)`](crate::client::fluent_builders::ModifyDBInstance::auto_minor_version_upgrade) / [`set_auto_minor_version_upgrade(Option<bool>)`](crate::client::fluent_builders::ModifyDBInstance::set_auto_minor_version_upgrade): <p>A value that indicates whether minor version upgrades are applied automatically to the DB instance during the maintenance window. An outage occurs when all the following conditions are met:</p>  <ul>   <li> <p>The automatic upgrade is enabled for the maintenance window.</p> </li>   <li> <p>A newer minor version is available.</p> </li>   <li> <p>RDS has enabled automatic patching for the engine version.</p> </li>  </ul>  <p>If any of the preceding conditions isn't met, RDS applies the change as soon as possible and doesn't cause an outage.</p>  <p>For an RDS Custom DB instance, set <code>AutoMinorVersionUpgrade</code> to <code>false</code>. Otherwise, the operation returns an error.</p>
    ///   - [`license_model(impl Into<String>)`](crate::client::fluent_builders::ModifyDBInstance::license_model) / [`set_license_model(Option<String>)`](crate::client::fluent_builders::ModifyDBInstance::set_license_model): <p>The license model for the DB instance.</p>  <p>This setting doesn't apply to RDS Custom.</p>  <p>Valid values: <code>license-included</code> | <code>bring-your-own-license</code> | <code>general-public-license</code> </p>
    ///   - [`iops(i32)`](crate::client::fluent_builders::ModifyDBInstance::iops) / [`set_iops(Option<i32>)`](crate::client::fluent_builders::ModifyDBInstance::set_iops): <p>The new Provisioned IOPS (I/O operations per second) value for the RDS instance.</p>  <p>Changing this setting doesn't result in an outage and the change is applied during the next maintenance window unless the <code>ApplyImmediately</code> parameter is enabled for this request. If you are migrating from Provisioned IOPS to standard storage, set this value to 0. The DB instance will require a reboot for the change in storage type to take effect.</p>  <p>If you choose to migrate your DB instance from using standard storage to using Provisioned IOPS, or from using Provisioned IOPS to using standard storage, the process can take time. The duration of the migration depends on several factors such as database load, storage size, storage type (standard or Provisioned IOPS), amount of IOPS provisioned (if any), and the number of prior scale storage operations. Typical migration times are under 24 hours, but the process can take up to several days in some cases. During the migration, the DB instance is available for use, but might experience performance degradation. While the migration takes place, nightly backups for the instance are suspended. No other Amazon RDS operations can take place for the instance, including modifying the instance, rebooting the instance, deleting the instance, creating a read replica for the instance, and creating a DB snapshot of the instance.</p>  <p>Constraints: For MariaDB, MySQL, Oracle, and PostgreSQL, the value supplied must be at least 10% greater than the current value. Values that are not at least 10% greater than the existing value are rounded up so that they are 10% greater than the current value.</p>  <p>Default: Uses existing setting</p>
    ///   - [`option_group_name(impl Into<String>)`](crate::client::fluent_builders::ModifyDBInstance::option_group_name) / [`set_option_group_name(Option<String>)`](crate::client::fluent_builders::ModifyDBInstance::set_option_group_name): <p>A value that indicates the DB instance should be associated with the specified option group.</p>  <p>Changing this parameter doesn't result in an outage, with one exception. If the parameter change results in an option group that enables OEM, it can cause a brief period, lasting less than a second, during which new connections are rejected but existing connections aren't interrupted.</p>  <p>The change is applied during the next maintenance window unless the <code>ApplyImmediately</code> parameter is enabled for this request.</p>  <p>Permanent options, such as the TDE option for Oracle Advanced Security TDE, can't be removed from an option group, and that option group can't be removed from a DB instance after it is associated with a DB instance.</p>  <p>This setting doesn't apply to RDS Custom.</p>
    ///   - [`new_db_instance_identifier(impl Into<String>)`](crate::client::fluent_builders::ModifyDBInstance::new_db_instance_identifier) / [`set_new_db_instance_identifier(Option<String>)`](crate::client::fluent_builders::ModifyDBInstance::set_new_db_instance_identifier): <p>The new DB instance identifier for the DB instance when renaming a DB instance. When you change the DB instance identifier, an instance reboot occurs immediately if you enable <code>ApplyImmediately</code>, or will occur during the next maintenance window if you disable Apply Immediately. This value is stored as a lowercase string.</p>  <p>This setting doesn't apply to RDS Custom.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p> </li>   <li> <p>The first character must be a letter.</p> </li>   <li> <p>Can't end with a hyphen or contain two consecutive hyphens.</p> </li>  </ul>  <p>Example: <code>mydbinstance</code> </p>
    ///   - [`storage_type(impl Into<String>)`](crate::client::fluent_builders::ModifyDBInstance::storage_type) / [`set_storage_type(Option<String>)`](crate::client::fluent_builders::ModifyDBInstance::set_storage_type): <p>Specifies the storage type to be associated with the DB instance.</p>  <p>If you specify Provisioned IOPS (<code>io1</code>), you must also include a value for the <code>Iops</code> parameter.</p>  <p>If you choose to migrate your DB instance from using standard storage to using Provisioned IOPS, or from using Provisioned IOPS to using standard storage, the process can take time. The duration of the migration depends on several factors such as database load, storage size, storage type (standard or Provisioned IOPS), amount of IOPS provisioned (if any), and the number of prior scale storage operations. Typical migration times are under 24 hours, but the process can take up to several days in some cases. During the migration, the DB instance is available for use, but might experience performance degradation. While the migration takes place, nightly backups for the instance are suspended. No other Amazon RDS operations can take place for the instance, including modifying the instance, rebooting the instance, deleting the instance, creating a read replica for the instance, and creating a DB snapshot of the instance.</p>  <p>Valid values: <code>standard | gp2 | io1</code> </p>  <p>Default: <code>io1</code> if the <code>Iops</code> parameter is specified, otherwise <code>gp2</code> </p>
    ///   - [`tde_credential_arn(impl Into<String>)`](crate::client::fluent_builders::ModifyDBInstance::tde_credential_arn) / [`set_tde_credential_arn(Option<String>)`](crate::client::fluent_builders::ModifyDBInstance::set_tde_credential_arn): <p>The ARN from the key store with which to associate the instance for TDE encryption.</p>  <p>This setting doesn't apply to RDS Custom.</p>
    ///   - [`tde_credential_password(impl Into<String>)`](crate::client::fluent_builders::ModifyDBInstance::tde_credential_password) / [`set_tde_credential_password(Option<String>)`](crate::client::fluent_builders::ModifyDBInstance::set_tde_credential_password): <p>The password for the given ARN from the key store in order to access the device.</p>  <p>This setting doesn't apply to RDS Custom.</p>
    ///   - [`ca_certificate_identifier(impl Into<String>)`](crate::client::fluent_builders::ModifyDBInstance::ca_certificate_identifier) / [`set_ca_certificate_identifier(Option<String>)`](crate::client::fluent_builders::ModifyDBInstance::set_ca_certificate_identifier): <p>Specifies the certificate to associate with the DB instance.</p>  <p>This setting doesn't apply to RDS Custom.</p>
    ///   - [`domain(impl Into<String>)`](crate::client::fluent_builders::ModifyDBInstance::domain) / [`set_domain(Option<String>)`](crate::client::fluent_builders::ModifyDBInstance::set_domain): <p>The Active Directory directory ID to move the DB instance to. Specify <code>none</code> to remove the instance from its current domain. You must create the domain before this operation. Currently, you can create only MySQL, Microsoft SQL Server, Oracle, and PostgreSQL DB instances in an Active Directory Domain.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/kerberos-authentication.html"> Kerberos Authentication</a> in the <i>Amazon RDS User Guide</i>.</p>  <p>This setting doesn't apply to RDS Custom.</p>
    ///   - [`copy_tags_to_snapshot(bool)`](crate::client::fluent_builders::ModifyDBInstance::copy_tags_to_snapshot) / [`set_copy_tags_to_snapshot(Option<bool>)`](crate::client::fluent_builders::ModifyDBInstance::set_copy_tags_to_snapshot): <p>A value that indicates whether to copy all tags from the DB instance to snapshots of the DB instance. By default, tags are not copied.</p>  <p> <b>Amazon Aurora</b> </p>  <p>Not applicable. Copying tags to snapshots is managed by the DB cluster. Setting this value for an Aurora DB instance has no effect on the DB cluster setting. For more information, see <code>ModifyDBCluster</code>.</p>
    ///   - [`monitoring_interval(i32)`](crate::client::fluent_builders::ModifyDBInstance::monitoring_interval) / [`set_monitoring_interval(Option<i32>)`](crate::client::fluent_builders::ModifyDBInstance::set_monitoring_interval): <p>The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB instance. To disable collecting Enhanced Monitoring metrics, specify 0, which is the default.</p>  <p>If <code>MonitoringRoleArn</code> is specified, set <code>MonitoringInterval</code> to a value other than 0.</p>  <p>This setting doesn't apply to RDS Custom.</p>  <p>Valid Values: <code>0, 1, 5, 10, 15, 30, 60</code> </p>
    ///   - [`db_port_number(i32)`](crate::client::fluent_builders::ModifyDBInstance::db_port_number) / [`set_db_port_number(Option<i32>)`](crate::client::fluent_builders::ModifyDBInstance::set_db_port_number): <p>The port number on which the database accepts connections.</p>  <p>The value of the <code>DBPortNumber</code> parameter must not match any of the port values specified for options in the option group for the DB instance.</p>  <p>If you change the <code>DBPortNumber</code> value, your database restarts regardless of the value of the <code>ApplyImmediately</code> parameter.</p>  <p>This setting doesn't apply to RDS Custom.</p>  <p> <b>MySQL</b> </p>  <p>Default: <code>3306</code> </p>  <p>Valid values: <code>1150-65535</code> </p>  <p> <b>MariaDB</b> </p>  <p>Default: <code>3306</code> </p>  <p>Valid values: <code>1150-65535</code> </p>  <p> <b>PostgreSQL</b> </p>  <p>Default: <code>5432</code> </p>  <p>Valid values: <code>1150-65535</code> </p>  <p>Type: Integer</p>  <p> <b>Oracle</b> </p>  <p>Default: <code>1521</code> </p>  <p>Valid values: <code>1150-65535</code> </p>  <p> <b>SQL Server</b> </p>  <p>Default: <code>1433</code> </p>  <p>Valid values: <code>1150-65535</code> except <code>1234</code>, <code>1434</code>, <code>3260</code>, <code>3343</code>, <code>3389</code>, <code>47001</code>, and <code>49152-49156</code>.</p>  <p> <b>Amazon Aurora</b> </p>  <p>Default: <code>3306</code> </p>  <p>Valid values: <code>1150-65535</code> </p>
    ///   - [`publicly_accessible(bool)`](crate::client::fluent_builders::ModifyDBInstance::publicly_accessible) / [`set_publicly_accessible(Option<bool>)`](crate::client::fluent_builders::ModifyDBInstance::set_publicly_accessible): <p>A value that indicates whether the DB instance is publicly accessible.</p>  <p>When the DB cluster is publicly accessible, its Domain Name System (DNS) endpoint resolves to the private IP address from within the DB cluster's virtual private cloud (VPC). It resolves to the public IP address from outside of the DB cluster's VPC. Access to the DB cluster is ultimately controlled by the security group it uses. That public access isn't permitted if the security group assigned to the DB cluster doesn't permit it.</p>  <p>When the DB instance isn't publicly accessible, it is an internal DB instance with a DNS name that resolves to a private IP address.</p>  <p> <code>PubliclyAccessible</code> only applies to DB instances in a VPC. The DB instance must be part of a public subnet and <code>PubliclyAccessible</code> must be enabled for it to be publicly accessible.</p>  <p>Changes to the <code>PubliclyAccessible</code> parameter are applied immediately regardless of the value of the <code>ApplyImmediately</code> parameter.</p>
    ///   - [`monitoring_role_arn(impl Into<String>)`](crate::client::fluent_builders::ModifyDBInstance::monitoring_role_arn) / [`set_monitoring_role_arn(Option<String>)`](crate::client::fluent_builders::ModifyDBInstance::set_monitoring_role_arn): <p>The ARN for the IAM role that permits RDS to send enhanced monitoring metrics to Amazon CloudWatch Logs. For example, <code>arn:aws:iam:123456789012:role/emaccess</code>. For information on creating a monitoring role, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.html#USER_Monitoring.OS.IAMRole">To create an IAM role for Amazon RDS Enhanced Monitoring</a> in the <i>Amazon RDS User Guide.</i> </p>  <p>If <code>MonitoringInterval</code> is set to a value other than 0, supply a <code>MonitoringRoleArn</code> value.</p>  <p>This setting doesn't apply to RDS Custom.</p>
    ///   - [`domain_iam_role_name(impl Into<String>)`](crate::client::fluent_builders::ModifyDBInstance::domain_iam_role_name) / [`set_domain_iam_role_name(Option<String>)`](crate::client::fluent_builders::ModifyDBInstance::set_domain_iam_role_name): <p>The name of the IAM role to use when making API calls to the Directory Service.</p>  <p>This setting doesn't apply to RDS Custom.</p>
    ///   - [`promotion_tier(i32)`](crate::client::fluent_builders::ModifyDBInstance::promotion_tier) / [`set_promotion_tier(Option<i32>)`](crate::client::fluent_builders::ModifyDBInstance::set_promotion_tier): <p>A value that specifies the order in which an Aurora Replica is promoted to the primary instance after a failure of the existing primary instance. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.FaultTolerance"> Fault Tolerance for an Aurora DB Cluster</a> in the <i>Amazon Aurora User Guide</i>.</p>  <p>This setting doesn't apply to RDS Custom.</p>  <p>Default: 1</p>  <p>Valid Values: 0 - 15</p>
    ///   - [`enable_iam_database_authentication(bool)`](crate::client::fluent_builders::ModifyDBInstance::enable_iam_database_authentication) / [`set_enable_iam_database_authentication(Option<bool>)`](crate::client::fluent_builders::ModifyDBInstance::set_enable_iam_database_authentication): <p>A value that indicates whether to enable mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts. By default, mapping isn't enabled.</p>  <p>This setting doesn't apply to Amazon Aurora. Mapping Amazon Web Services IAM accounts to database accounts is managed by the DB cluster.</p>  <p>For more information about IAM database authentication, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.html"> IAM Database Authentication for MySQL and PostgreSQL</a> in the <i>Amazon RDS User Guide.</i> </p>  <p>This setting doesn't apply to RDS Custom.</p>
    ///   - [`enable_performance_insights(bool)`](crate::client::fluent_builders::ModifyDBInstance::enable_performance_insights) / [`set_enable_performance_insights(Option<bool>)`](crate::client::fluent_builders::ModifyDBInstance::set_enable_performance_insights): <p>A value that indicates whether to enable Performance Insights for the DB instance.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html">Using Amazon Performance Insights</a> in the <i>Amazon RDS User Guide.</i>.</p>  <p>This setting doesn't apply to RDS Custom.</p>
    ///   - [`performance_insights_kms_key_id(impl Into<String>)`](crate::client::fluent_builders::ModifyDBInstance::performance_insights_kms_key_id) / [`set_performance_insights_kms_key_id(Option<String>)`](crate::client::fluent_builders::ModifyDBInstance::set_performance_insights_kms_key_id): <p>The Amazon Web Services KMS key identifier for encryption of Performance Insights data.</p>  <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.</p>  <p>If you do not specify a value for <code>PerformanceInsightsKMSKeyId</code>, then Amazon RDS uses your default KMS key. There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account has a different default KMS key for each Amazon Web Services Region.</p>  <p>This setting doesn't apply to RDS Custom.</p>
    ///   - [`performance_insights_retention_period(i32)`](crate::client::fluent_builders::ModifyDBInstance::performance_insights_retention_period) / [`set_performance_insights_retention_period(Option<i32>)`](crate::client::fluent_builders::ModifyDBInstance::set_performance_insights_retention_period): <p>The amount of time, in days, to retain Performance Insights data. Valid values are 7 or 731 (2 years).</p>  <p>This setting doesn't apply to RDS Custom.</p>
    ///   - [`cloudwatch_logs_export_configuration(CloudwatchLogsExportConfiguration)`](crate::client::fluent_builders::ModifyDBInstance::cloudwatch_logs_export_configuration) / [`set_cloudwatch_logs_export_configuration(Option<CloudwatchLogsExportConfiguration>)`](crate::client::fluent_builders::ModifyDBInstance::set_cloudwatch_logs_export_configuration): <p>The configuration setting for the log types to be enabled for export to CloudWatch Logs for a specific DB instance.</p>  <p>A change to the <code>CloudwatchLogsExportConfiguration</code> parameter is always applied to the DB instance immediately. Therefore, the <code>ApplyImmediately</code> parameter has no effect.</p>  <p>This setting doesn't apply to RDS Custom.</p>
    ///   - [`processor_features(Vec<ProcessorFeature>)`](crate::client::fluent_builders::ModifyDBInstance::processor_features) / [`set_processor_features(Option<Vec<ProcessorFeature>>)`](crate::client::fluent_builders::ModifyDBInstance::set_processor_features): <p>The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.</p>  <p>This setting doesn't apply to RDS Custom.</p>
    ///   - [`use_default_processor_features(bool)`](crate::client::fluent_builders::ModifyDBInstance::use_default_processor_features) / [`set_use_default_processor_features(Option<bool>)`](crate::client::fluent_builders::ModifyDBInstance::set_use_default_processor_features): <p>A value that indicates whether the DB instance class of the DB instance uses its default processor features.</p>  <p>This setting doesn't apply to RDS Custom.</p>
    ///   - [`deletion_protection(bool)`](crate::client::fluent_builders::ModifyDBInstance::deletion_protection) / [`set_deletion_protection(Option<bool>)`](crate::client::fluent_builders::ModifyDBInstance::set_deletion_protection): <p>A value that indicates whether the DB instance has deletion protection enabled. The database can't be deleted when deletion protection is enabled. By default, deletion protection isn't enabled. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html"> Deleting a DB Instance</a>.</p>
    ///   - [`max_allocated_storage(i32)`](crate::client::fluent_builders::ModifyDBInstance::max_allocated_storage) / [`set_max_allocated_storage(Option<i32>)`](crate::client::fluent_builders::ModifyDBInstance::set_max_allocated_storage): <p>The upper limit in gibibytes (GiB) to which Amazon RDS can automatically scale the storage of the DB instance.</p>  <p>For more information about this setting, including limitations that apply to it, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIOPS.StorageTypes.html#USER_PIOPS.Autoscaling"> Managing capacity automatically with Amazon RDS storage autoscaling</a> in the <i>Amazon RDS User Guide</i>.</p>  <p>This setting doesn't apply to RDS Custom.</p>
    ///   - [`certificate_rotation_restart(bool)`](crate::client::fluent_builders::ModifyDBInstance::certificate_rotation_restart) / [`set_certificate_rotation_restart(Option<bool>)`](crate::client::fluent_builders::ModifyDBInstance::set_certificate_rotation_restart): <p>A value that indicates whether the DB instance is restarted when you rotate your SSL/TLS certificate.</p>  <p>By default, the DB instance is restarted when you rotate your SSL/TLS certificate. The certificate is not updated until the DB instance is restarted.</p> <important>   <p>Set this parameter only if you are <i>not</i> using SSL/TLS to connect to the DB instance.</p>  </important>  <p>If you are using SSL/TLS to connect to the DB instance, follow the appropriate instructions for your DB engine to rotate your SSL/TLS certificate:</p>  <ul>   <li> <p>For more information about rotating your SSL/TLS certificate for RDS DB engines, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL-certificate-rotation.html"> Rotating Your SSL/TLS Certificate.</a> in the <i>Amazon RDS User Guide.</i> </p> </li>   <li> <p>For more information about rotating your SSL/TLS certificate for Aurora DB engines, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.SSL-certificate-rotation.html"> Rotating Your SSL/TLS Certificate</a> in the <i>Amazon Aurora User Guide</i>.</p> </li>  </ul>  <p>This setting doesn't apply to RDS Custom.</p>
    ///   - [`replica_mode(ReplicaMode)`](crate::client::fluent_builders::ModifyDBInstance::replica_mode) / [`set_replica_mode(Option<ReplicaMode>)`](crate::client::fluent_builders::ModifyDBInstance::set_replica_mode): <p>A value that sets the open mode of a replica database to either mounted or read-only.</p> <note>   <p>Currently, this parameter is only supported for Oracle DB instances.</p>  </note>  <p>Mounted DB replicas are included in Oracle Enterprise Edition. The main use case for mounted replicas is cross-Region disaster recovery. The primary database doesn't use Active Data Guard to transmit information to the mounted replica. Because it doesn't accept user connections, a mounted replica can't serve a read-only workload. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/oracle-read-replicas.html">Working with Oracle Read Replicas for Amazon RDS</a> in the <i>Amazon RDS User Guide</i>.</p>  <p>This setting doesn't apply to RDS Custom.</p>
    ///   - [`enable_customer_owned_ip(bool)`](crate::client::fluent_builders::ModifyDBInstance::enable_customer_owned_ip) / [`set_enable_customer_owned_ip(Option<bool>)`](crate::client::fluent_builders::ModifyDBInstance::set_enable_customer_owned_ip): <p>A value that indicates whether to enable a customer-owned IP address (CoIP) for an RDS on Outposts DB instance.</p>  <p>A <i>CoIP</i> provides local or external connectivity to resources in your Outpost subnets through your on-premises network. For some use cases, a CoIP can provide lower latency for connections to the DB instance from outside of its virtual private cloud (VPC) on your local network.</p>  <p>For more information about RDS on Outposts, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html">Working with Amazon RDS on Amazon Web Services Outposts</a> in the <i>Amazon RDS User Guide</i>.</p>  <p>For more information about CoIPs, see <a href="https://docs.aws.amazon.com/outposts/latest/userguide/outposts-networking-components.html#ip-addressing">Customer-owned IP addresses</a> in the <i>Amazon Web Services Outposts User Guide</i>.</p>
    ///   - [`aws_backup_recovery_point_arn(impl Into<String>)`](crate::client::fluent_builders::ModifyDBInstance::aws_backup_recovery_point_arn) / [`set_aws_backup_recovery_point_arn(Option<String>)`](crate::client::fluent_builders::ModifyDBInstance::set_aws_backup_recovery_point_arn): <p>The Amazon Resource Name (ARN) of the recovery point in Amazon Web Services Backup.</p>  <p>This setting doesn't apply to RDS Custom.</p>
    ///   - [`automation_mode(AutomationMode)`](crate::client::fluent_builders::ModifyDBInstance::automation_mode) / [`set_automation_mode(Option<AutomationMode>)`](crate::client::fluent_builders::ModifyDBInstance::set_automation_mode): <p>The automation mode of the RDS Custom DB instance: <code>full</code> or <code>all paused</code>. If <code>full</code>, the DB instance automates monitoring and instance recovery. If <code>all paused</code>, the instance pauses automation for the duration set by <code>ResumeFullAutomationModeMinutes</code>.</p>
    ///   - [`resume_full_automation_mode_minutes(i32)`](crate::client::fluent_builders::ModifyDBInstance::resume_full_automation_mode_minutes) / [`set_resume_full_automation_mode_minutes(Option<i32>)`](crate::client::fluent_builders::ModifyDBInstance::set_resume_full_automation_mode_minutes): <p>The number of minutes to pause the automation. When the time period ends, RDS Custom resumes full automation. The minimum value is <code>60</code> (default). The maximum value is <code>1,440</code>.</p>
    /// - On success, responds with [`ModifyDbInstanceOutput`](crate::output::ModifyDbInstanceOutput) with field(s):
    ///   - [`db_instance(Option<DbInstance>)`](crate::output::ModifyDbInstanceOutput::db_instance): <p>Contains the details of an Amazon RDS DB instance.</p>  <p>This data type is used as a response element in the operations <code>CreateDBInstance</code>, <code>CreateDBInstanceReadReplica</code>, <code>DeleteDBInstance</code>, <code>DescribeDBInstances</code>, <code>ModifyDBInstance</code>, <code>PromoteReadReplica</code>, <code>RebootDBInstance</code>, <code>RestoreDBInstanceFromDBSnapshot</code>, <code>RestoreDBInstanceFromS3</code>, <code>RestoreDBInstanceToPointInTime</code>, <code>StartDBInstance</code>, and <code>StopDBInstance</code>.</p>
    /// - On failure, responds with [`SdkError<ModifyDBInstanceError>`](crate::error::ModifyDBInstanceError)
    pub fn modify_db_instance(&self) -> fluent_builders::ModifyDBInstance {
        fluent_builders::ModifyDBInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ModifyDBParameterGroup`](crate::client::fluent_builders::ModifyDBParameterGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_parameter_group_name(impl Into<String>)`](crate::client::fluent_builders::ModifyDBParameterGroup::db_parameter_group_name) / [`set_db_parameter_group_name(Option<String>)`](crate::client::fluent_builders::ModifyDBParameterGroup::set_db_parameter_group_name): <p>The name of the DB parameter group.</p>  <p>Constraints:</p>  <ul>   <li> <p>If supplied, must match the name of an existing <code>DBParameterGroup</code>.</p> </li>  </ul>
    ///   - [`parameters(Vec<Parameter>)`](crate::client::fluent_builders::ModifyDBParameterGroup::parameters) / [`set_parameters(Option<Vec<Parameter>>)`](crate::client::fluent_builders::ModifyDBParameterGroup::set_parameters): <p>An array of parameter names, values, and the application methods for the parameter update. At least one parameter name, value, and application method must be supplied; later arguments are optional. A maximum of 20 parameters can be modified in a single request.</p>  <p>Valid Values (for the application method): <code>immediate | pending-reboot</code> </p>  <p>You can use the <code>immediate</code> value with dynamic parameters only. You can use the <code>pending-reboot</code> value for both dynamic and static parameters.</p>  <p>When the application method is <code>immediate</code>, changes to dynamic parameters are applied immediately to the DB instances associated with the parameter group.</p>  <p>When the application method is <code>pending-reboot</code>, changes to dynamic and static parameters are applied after a reboot without failover to the DB instances associated with the parameter group.</p> <note>   <p>You can't use <code>pending-reboot</code> with dynamic parameters on RDS for SQL Server DB instances. Use <code>immediate</code>.</p>  </note>  <p>For more information on modifying DB parameters, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithParamGroups.html">Working with DB parameter groups</a> in the <i>Amazon RDS User Guide</i>.</p>
    /// - On success, responds with [`ModifyDbParameterGroupOutput`](crate::output::ModifyDbParameterGroupOutput) with field(s):
    ///   - [`db_parameter_group_name(Option<String>)`](crate::output::ModifyDbParameterGroupOutput::db_parameter_group_name): <p>The name of the DB parameter group.</p>
    /// - On failure, responds with [`SdkError<ModifyDBParameterGroupError>`](crate::error::ModifyDBParameterGroupError)
    pub fn modify_db_parameter_group(&self) -> fluent_builders::ModifyDBParameterGroup {
        fluent_builders::ModifyDBParameterGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ModifyDBProxy`](crate::client::fluent_builders::ModifyDBProxy) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_proxy_name(impl Into<String>)`](crate::client::fluent_builders::ModifyDBProxy::db_proxy_name) / [`set_db_proxy_name(Option<String>)`](crate::client::fluent_builders::ModifyDBProxy::set_db_proxy_name): <p>The identifier for the <code>DBProxy</code> to modify.</p>
    ///   - [`new_db_proxy_name(impl Into<String>)`](crate::client::fluent_builders::ModifyDBProxy::new_db_proxy_name) / [`set_new_db_proxy_name(Option<String>)`](crate::client::fluent_builders::ModifyDBProxy::set_new_db_proxy_name): <p>The new identifier for the <code>DBProxy</code>. An identifier must begin with a letter and must contain only ASCII letters, digits, and hyphens; it can't end with a hyphen or contain two consecutive hyphens.</p>
    ///   - [`auth(Vec<UserAuthConfig>)`](crate::client::fluent_builders::ModifyDBProxy::auth) / [`set_auth(Option<Vec<UserAuthConfig>>)`](crate::client::fluent_builders::ModifyDBProxy::set_auth): <p>The new authentication settings for the <code>DBProxy</code>.</p>
    ///   - [`require_tls(bool)`](crate::client::fluent_builders::ModifyDBProxy::require_tls) / [`set_require_tls(Option<bool>)`](crate::client::fluent_builders::ModifyDBProxy::set_require_tls): <p>Whether Transport Layer Security (TLS) encryption is required for connections to the proxy. By enabling this setting, you can enforce encrypted TLS connections to the proxy, even if the associated database doesn't use TLS.</p>
    ///   - [`idle_client_timeout(i32)`](crate::client::fluent_builders::ModifyDBProxy::idle_client_timeout) / [`set_idle_client_timeout(Option<i32>)`](crate::client::fluent_builders::ModifyDBProxy::set_idle_client_timeout): <p>The number of seconds that a connection to the proxy can be inactive before the proxy disconnects it. You can set this value higher or lower than the connection timeout limit for the associated database.</p>
    ///   - [`debug_logging(bool)`](crate::client::fluent_builders::ModifyDBProxy::debug_logging) / [`set_debug_logging(Option<bool>)`](crate::client::fluent_builders::ModifyDBProxy::set_debug_logging): <p>Whether the proxy includes detailed information about SQL statements in its logs. This information helps you to debug issues involving SQL behavior or the performance and scalability of the proxy connections. The debug information includes the text of SQL statements that you submit through the proxy. Thus, only enable this setting when needed for debugging, and only when you have security measures in place to safeguard any sensitive information that appears in the logs.</p>
    ///   - [`role_arn(impl Into<String>)`](crate::client::fluent_builders::ModifyDBProxy::role_arn) / [`set_role_arn(Option<String>)`](crate::client::fluent_builders::ModifyDBProxy::set_role_arn): <p>The Amazon Resource Name (ARN) of the IAM role that the proxy uses to access secrets in Amazon Web Services Secrets Manager.</p>
    ///   - [`security_groups(Vec<String>)`](crate::client::fluent_builders::ModifyDBProxy::security_groups) / [`set_security_groups(Option<Vec<String>>)`](crate::client::fluent_builders::ModifyDBProxy::set_security_groups): <p>The new list of security groups for the <code>DBProxy</code>.</p>
    /// - On success, responds with [`ModifyDbProxyOutput`](crate::output::ModifyDbProxyOutput) with field(s):
    ///   - [`db_proxy(Option<DbProxy>)`](crate::output::ModifyDbProxyOutput::db_proxy): <p>The <code>DBProxy</code> object representing the new settings for the proxy.</p>
    /// - On failure, responds with [`SdkError<ModifyDBProxyError>`](crate::error::ModifyDBProxyError)
    pub fn modify_db_proxy(&self) -> fluent_builders::ModifyDBProxy {
        fluent_builders::ModifyDBProxy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ModifyDBProxyEndpoint`](crate::client::fluent_builders::ModifyDBProxyEndpoint) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_proxy_endpoint_name(impl Into<String>)`](crate::client::fluent_builders::ModifyDBProxyEndpoint::db_proxy_endpoint_name) / [`set_db_proxy_endpoint_name(Option<String>)`](crate::client::fluent_builders::ModifyDBProxyEndpoint::set_db_proxy_endpoint_name): <p>The name of the DB proxy sociated with the DB proxy endpoint that you want to modify.</p>
    ///   - [`new_db_proxy_endpoint_name(impl Into<String>)`](crate::client::fluent_builders::ModifyDBProxyEndpoint::new_db_proxy_endpoint_name) / [`set_new_db_proxy_endpoint_name(Option<String>)`](crate::client::fluent_builders::ModifyDBProxyEndpoint::set_new_db_proxy_endpoint_name): <p>The new identifier for the <code>DBProxyEndpoint</code>. An identifier must begin with a letter and must contain only ASCII letters, digits, and hyphens; it can't end with a hyphen or contain two consecutive hyphens.</p>
    ///   - [`vpc_security_group_ids(Vec<String>)`](crate::client::fluent_builders::ModifyDBProxyEndpoint::vpc_security_group_ids) / [`set_vpc_security_group_ids(Option<Vec<String>>)`](crate::client::fluent_builders::ModifyDBProxyEndpoint::set_vpc_security_group_ids): <p>The VPC security group IDs for the DB proxy endpoint. When the DB proxy endpoint uses a different VPC than the original proxy, you also specify a different set of security group IDs than for the original proxy.</p>
    /// - On success, responds with [`ModifyDbProxyEndpointOutput`](crate::output::ModifyDbProxyEndpointOutput) with field(s):
    ///   - [`db_proxy_endpoint(Option<DbProxyEndpoint>)`](crate::output::ModifyDbProxyEndpointOutput::db_proxy_endpoint): <p>The <code>DBProxyEndpoint</code> object representing the new settings for the DB proxy endpoint.</p>
    /// - On failure, responds with [`SdkError<ModifyDBProxyEndpointError>`](crate::error::ModifyDBProxyEndpointError)
    pub fn modify_db_proxy_endpoint(&self) -> fluent_builders::ModifyDBProxyEndpoint {
        fluent_builders::ModifyDBProxyEndpoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ModifyDBProxyTargetGroup`](crate::client::fluent_builders::ModifyDBProxyTargetGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`target_group_name(impl Into<String>)`](crate::client::fluent_builders::ModifyDBProxyTargetGroup::target_group_name) / [`set_target_group_name(Option<String>)`](crate::client::fluent_builders::ModifyDBProxyTargetGroup::set_target_group_name): <p>The name of the new target group to assign to the proxy.</p>
    ///   - [`db_proxy_name(impl Into<String>)`](crate::client::fluent_builders::ModifyDBProxyTargetGroup::db_proxy_name) / [`set_db_proxy_name(Option<String>)`](crate::client::fluent_builders::ModifyDBProxyTargetGroup::set_db_proxy_name): <p>The name of the new proxy to which to assign the target group.</p>
    ///   - [`connection_pool_config(ConnectionPoolConfiguration)`](crate::client::fluent_builders::ModifyDBProxyTargetGroup::connection_pool_config) / [`set_connection_pool_config(Option<ConnectionPoolConfiguration>)`](crate::client::fluent_builders::ModifyDBProxyTargetGroup::set_connection_pool_config): <p>The settings that determine the size and behavior of the connection pool for the target group.</p>
    ///   - [`new_name(impl Into<String>)`](crate::client::fluent_builders::ModifyDBProxyTargetGroup::new_name) / [`set_new_name(Option<String>)`](crate::client::fluent_builders::ModifyDBProxyTargetGroup::set_new_name): <p>The new name for the modified <code>DBProxyTarget</code>. An identifier must begin with a letter and must contain only ASCII letters, digits, and hyphens; it can't end with a hyphen or contain two consecutive hyphens.</p>
    /// - On success, responds with [`ModifyDbProxyTargetGroupOutput`](crate::output::ModifyDbProxyTargetGroupOutput) with field(s):
    ///   - [`db_proxy_target_group(Option<DbProxyTargetGroup>)`](crate::output::ModifyDbProxyTargetGroupOutput::db_proxy_target_group): <p>The settings of the modified <code>DBProxyTarget</code>.</p>
    /// - On failure, responds with [`SdkError<ModifyDBProxyTargetGroupError>`](crate::error::ModifyDBProxyTargetGroupError)
    pub fn modify_db_proxy_target_group(&self) -> fluent_builders::ModifyDBProxyTargetGroup {
        fluent_builders::ModifyDBProxyTargetGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ModifyDBSnapshot`](crate::client::fluent_builders::ModifyDBSnapshot) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_snapshot_identifier(impl Into<String>)`](crate::client::fluent_builders::ModifyDBSnapshot::db_snapshot_identifier) / [`set_db_snapshot_identifier(Option<String>)`](crate::client::fluent_builders::ModifyDBSnapshot::set_db_snapshot_identifier): <p>The identifier of the DB snapshot to modify.</p>
    ///   - [`engine_version(impl Into<String>)`](crate::client::fluent_builders::ModifyDBSnapshot::engine_version) / [`set_engine_version(Option<String>)`](crate::client::fluent_builders::ModifyDBSnapshot::set_engine_version): <p>The engine version to upgrade the DB snapshot to.</p>  <p>The following are the database engines and engine versions that are available when you upgrade a DB snapshot.</p>  <p> <b>MySQL</b> </p>  <ul>   <li> <p> <code>5.5.46</code> (supported for 5.1 DB snapshots)</p> </li>  </ul>  <p> <b>Oracle</b> </p>  <ul>   <li> <p> <code>12.1.0.2.v8</code> (supported for 12.1.0.1 DB snapshots)</p> </li>   <li> <p> <code>11.2.0.4.v12</code> (supported for 11.2.0.2 DB snapshots)</p> </li>   <li> <p> <code>11.2.0.4.v11</code> (supported for 11.2.0.3 DB snapshots)</p> </li>  </ul>  <p> <b>PostgreSQL</b> </p>  <p>For the list of engine versions that are available for upgrading a DB snapshot, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.PostgreSQL.html#USER_UpgradeDBInstance.PostgreSQL.MajorVersion"> Upgrading the PostgreSQL DB Engine for Amazon RDS</a>.</p>
    ///   - [`option_group_name(impl Into<String>)`](crate::client::fluent_builders::ModifyDBSnapshot::option_group_name) / [`set_option_group_name(Option<String>)`](crate::client::fluent_builders::ModifyDBSnapshot::set_option_group_name): <p>The option group to identify with the upgraded DB snapshot.</p>  <p>You can specify this parameter when you upgrade an Oracle DB snapshot. The same option group considerations apply when upgrading a DB snapshot as when upgrading a DB instance. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Oracle.html#USER_UpgradeDBInstance.Oracle.OGPG.OG">Option group considerations</a> in the <i>Amazon RDS User Guide.</i> </p>
    /// - On success, responds with [`ModifyDbSnapshotOutput`](crate::output::ModifyDbSnapshotOutput) with field(s):
    ///   - [`db_snapshot(Option<DbSnapshot>)`](crate::output::ModifyDbSnapshotOutput::db_snapshot): <p>Contains the details of an Amazon RDS DB snapshot.</p>  <p>This data type is used as a response element in the <code>DescribeDBSnapshots</code> action.</p>
    /// - On failure, responds with [`SdkError<ModifyDBSnapshotError>`](crate::error::ModifyDBSnapshotError)
    pub fn modify_db_snapshot(&self) -> fluent_builders::ModifyDBSnapshot {
        fluent_builders::ModifyDBSnapshot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ModifyDBSnapshotAttribute`](crate::client::fluent_builders::ModifyDBSnapshotAttribute) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_snapshot_identifier(impl Into<String>)`](crate::client::fluent_builders::ModifyDBSnapshotAttribute::db_snapshot_identifier) / [`set_db_snapshot_identifier(Option<String>)`](crate::client::fluent_builders::ModifyDBSnapshotAttribute::set_db_snapshot_identifier): <p>The identifier for the DB snapshot to modify the attributes for.</p>
    ///   - [`attribute_name(impl Into<String>)`](crate::client::fluent_builders::ModifyDBSnapshotAttribute::attribute_name) / [`set_attribute_name(Option<String>)`](crate::client::fluent_builders::ModifyDBSnapshotAttribute::set_attribute_name): <p>The name of the DB snapshot attribute to modify.</p>  <p>To manage authorization for other Amazon Web Services accounts to copy or restore a manual DB snapshot, set this value to <code>restore</code>.</p> <note>   <p>To view the list of attributes available to modify, use the <code>DescribeDBSnapshotAttributes</code> API action.</p>  </note>
    ///   - [`values_to_add(Vec<String>)`](crate::client::fluent_builders::ModifyDBSnapshotAttribute::values_to_add) / [`set_values_to_add(Option<Vec<String>>)`](crate::client::fluent_builders::ModifyDBSnapshotAttribute::set_values_to_add): <p>A list of DB snapshot attributes to add to the attribute specified by <code>AttributeName</code>.</p>  <p>To authorize other Amazon Web Services accounts to copy or restore a manual snapshot, set this list to include one or more Amazon Web Services account IDs, or <code>all</code> to make the manual DB snapshot restorable by any Amazon Web Services account. Do not add the <code>all</code> value for any manual DB snapshots that contain private information that you don't want available to all Amazon Web Services accounts.</p>
    ///   - [`values_to_remove(Vec<String>)`](crate::client::fluent_builders::ModifyDBSnapshotAttribute::values_to_remove) / [`set_values_to_remove(Option<Vec<String>>)`](crate::client::fluent_builders::ModifyDBSnapshotAttribute::set_values_to_remove): <p>A list of DB snapshot attributes to remove from the attribute specified by <code>AttributeName</code>.</p>  <p>To remove authorization for other Amazon Web Services accounts to copy or restore a manual snapshot, set this list to include one or more Amazon Web Services account identifiers, or <code>all</code> to remove authorization for any Amazon Web Services account to copy or restore the DB snapshot. If you specify <code>all</code>, an Amazon Web Services account whose account ID is explicitly added to the <code>restore</code> attribute can still copy or restore the manual DB snapshot.</p>
    /// - On success, responds with [`ModifyDbSnapshotAttributeOutput`](crate::output::ModifyDbSnapshotAttributeOutput) with field(s):
    ///   - [`db_snapshot_attributes_result(Option<DbSnapshotAttributesResult>)`](crate::output::ModifyDbSnapshotAttributeOutput::db_snapshot_attributes_result): <p>Contains the results of a successful call to the <code>DescribeDBSnapshotAttributes</code> API action.</p>  <p>Manual DB snapshot attributes are used to authorize other Amazon Web Services accounts to copy or restore a manual DB snapshot. For more information, see the <code>ModifyDBSnapshotAttribute</code> API action.</p>
    /// - On failure, responds with [`SdkError<ModifyDBSnapshotAttributeError>`](crate::error::ModifyDBSnapshotAttributeError)
    pub fn modify_db_snapshot_attribute(&self) -> fluent_builders::ModifyDBSnapshotAttribute {
        fluent_builders::ModifyDBSnapshotAttribute::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ModifyDBSubnetGroup`](crate::client::fluent_builders::ModifyDBSubnetGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_subnet_group_name(impl Into<String>)`](crate::client::fluent_builders::ModifyDBSubnetGroup::db_subnet_group_name) / [`set_db_subnet_group_name(Option<String>)`](crate::client::fluent_builders::ModifyDBSubnetGroup::set_db_subnet_group_name): <p>The name for the DB subnet group. This value is stored as a lowercase string. You can't modify the default subnet group.</p>  <p>Constraints: Must match the name of an existing DBSubnetGroup. Must not be default.</p>  <p>Example: <code>mydbsubnetgroup</code> </p>
    ///   - [`db_subnet_group_description(impl Into<String>)`](crate::client::fluent_builders::ModifyDBSubnetGroup::db_subnet_group_description) / [`set_db_subnet_group_description(Option<String>)`](crate::client::fluent_builders::ModifyDBSubnetGroup::set_db_subnet_group_description): <p>The description for the DB subnet group.</p>
    ///   - [`subnet_ids(Vec<String>)`](crate::client::fluent_builders::ModifyDBSubnetGroup::subnet_ids) / [`set_subnet_ids(Option<Vec<String>>)`](crate::client::fluent_builders::ModifyDBSubnetGroup::set_subnet_ids): <p>The EC2 subnet IDs for the DB subnet group.</p>
    /// - On success, responds with [`ModifyDbSubnetGroupOutput`](crate::output::ModifyDbSubnetGroupOutput) with field(s):
    ///   - [`db_subnet_group(Option<DbSubnetGroup>)`](crate::output::ModifyDbSubnetGroupOutput::db_subnet_group): <p>Contains the details of an Amazon RDS DB subnet group.</p>  <p>This data type is used as a response element in the <code>DescribeDBSubnetGroups</code> action.</p>
    /// - On failure, responds with [`SdkError<ModifyDBSubnetGroupError>`](crate::error::ModifyDBSubnetGroupError)
    pub fn modify_db_subnet_group(&self) -> fluent_builders::ModifyDBSubnetGroup {
        fluent_builders::ModifyDBSubnetGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ModifyEventSubscription`](crate::client::fluent_builders::ModifyEventSubscription) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`subscription_name(impl Into<String>)`](crate::client::fluent_builders::ModifyEventSubscription::subscription_name) / [`set_subscription_name(Option<String>)`](crate::client::fluent_builders::ModifyEventSubscription::set_subscription_name): <p>The name of the RDS event notification subscription.</p>
    ///   - [`sns_topic_arn(impl Into<String>)`](crate::client::fluent_builders::ModifyEventSubscription::sns_topic_arn) / [`set_sns_topic_arn(Option<String>)`](crate::client::fluent_builders::ModifyEventSubscription::set_sns_topic_arn): <p>The Amazon Resource Name (ARN) of the SNS topic created for event notification. The ARN is created by Amazon SNS when you create a topic and subscribe to it.</p>
    ///   - [`source_type(impl Into<String>)`](crate::client::fluent_builders::ModifyEventSubscription::source_type) / [`set_source_type(Option<String>)`](crate::client::fluent_builders::ModifyEventSubscription::set_source_type): <p>The type of source that is generating the events. For example, if you want to be notified of events generated by a DB instance, you would set this parameter to db-instance. For RDS Proxy events, specify <code>db-proxy</code>. If this value isn't specified, all events are returned.</p>  <p>Valid values: <code>db-instance</code> | <code>db-cluster</code> | <code>db-parameter-group</code> | <code>db-security-group</code> | <code>db-snapshot</code> | <code>db-cluster-snapshot</code> | <code>db-proxy</code> </p>
    ///   - [`event_categories(Vec<String>)`](crate::client::fluent_builders::ModifyEventSubscription::event_categories) / [`set_event_categories(Option<Vec<String>>)`](crate::client::fluent_builders::ModifyEventSubscription::set_event_categories): <p>A list of event categories for a source type (<code>SourceType</code>) that you want to subscribe to. You can see a list of the categories for a given source type in <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Events.html">Events</a> in the <i>Amazon RDS User Guide</i> or by using the <code>DescribeEventCategories</code> operation.</p>
    ///   - [`enabled(bool)`](crate::client::fluent_builders::ModifyEventSubscription::enabled) / [`set_enabled(Option<bool>)`](crate::client::fluent_builders::ModifyEventSubscription::set_enabled): <p>A value that indicates whether to activate the subscription.</p>
    /// - On success, responds with [`ModifyEventSubscriptionOutput`](crate::output::ModifyEventSubscriptionOutput) with field(s):
    ///   - [`event_subscription(Option<EventSubscription>)`](crate::output::ModifyEventSubscriptionOutput::event_subscription): <p>Contains the results of a successful invocation of the <code>DescribeEventSubscriptions</code> action.</p>
    /// - On failure, responds with [`SdkError<ModifyEventSubscriptionError>`](crate::error::ModifyEventSubscriptionError)
    pub fn modify_event_subscription(&self) -> fluent_builders::ModifyEventSubscription {
        fluent_builders::ModifyEventSubscription::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ModifyGlobalCluster`](crate::client::fluent_builders::ModifyGlobalCluster) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`global_cluster_identifier(impl Into<String>)`](crate::client::fluent_builders::ModifyGlobalCluster::global_cluster_identifier) / [`set_global_cluster_identifier(Option<String>)`](crate::client::fluent_builders::ModifyGlobalCluster::set_global_cluster_identifier): <p>The DB cluster identifier for the global cluster being modified. This parameter isn't case-sensitive.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must match the identifier of an existing global database cluster.</p> </li>  </ul>
    ///   - [`new_global_cluster_identifier(impl Into<String>)`](crate::client::fluent_builders::ModifyGlobalCluster::new_global_cluster_identifier) / [`set_new_global_cluster_identifier(Option<String>)`](crate::client::fluent_builders::ModifyGlobalCluster::set_new_global_cluster_identifier): <p>The new cluster identifier for the global database cluster when modifying a global database cluster. This value is stored as a lowercase string.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must contain from 1 to 63 letters, numbers, or hyphens</p> </li>   <li> <p>The first character must be a letter</p> </li>   <li> <p>Can't end with a hyphen or contain two consecutive hyphens</p> </li>  </ul>  <p>Example: <code>my-cluster2</code> </p>
    ///   - [`deletion_protection(bool)`](crate::client::fluent_builders::ModifyGlobalCluster::deletion_protection) / [`set_deletion_protection(Option<bool>)`](crate::client::fluent_builders::ModifyGlobalCluster::set_deletion_protection): <p>Indicates if the global database cluster has deletion protection enabled. The global database cluster can't be deleted when deletion protection is enabled.</p>
    ///   - [`engine_version(impl Into<String>)`](crate::client::fluent_builders::ModifyGlobalCluster::engine_version) / [`set_engine_version(Option<String>)`](crate::client::fluent_builders::ModifyGlobalCluster::set_engine_version): <p>The version number of the database engine to which you want to upgrade. Changing this parameter results in an outage. The change is applied during the next maintenance window unless <code>ApplyImmediately</code> is enabled.</p>  <p>To list all of the available engine versions for <code>aurora</code> (for MySQL 5.6-compatible Aurora), use the following command:</p>  <p> <code>aws rds describe-db-engine-versions --engine aurora --query '*[]|[?SupportsGlobalDatabases == `true`].[EngineVersion]'</code> </p>  <p>To list all of the available engine versions for <code>aurora-mysql</code> (for MySQL 5.7-compatible and MySQL 8.0-compatible Aurora), use the following command:</p>  <p> <code>aws rds describe-db-engine-versions --engine aurora-mysql --query '*[]|[?SupportsGlobalDatabases == `true`].[EngineVersion]'</code> </p>  <p>To list all of the available engine versions for <code>aurora-postgresql</code>, use the following command:</p>  <p> <code>aws rds describe-db-engine-versions --engine aurora-postgresql --query '*[]|[?SupportsGlobalDatabases == `true`].[EngineVersion]'</code> </p>
    ///   - [`allow_major_version_upgrade(bool)`](crate::client::fluent_builders::ModifyGlobalCluster::allow_major_version_upgrade) / [`set_allow_major_version_upgrade(Option<bool>)`](crate::client::fluent_builders::ModifyGlobalCluster::set_allow_major_version_upgrade): <p>A value that indicates whether major version upgrades are allowed.</p>  <p>Constraints: You must allow major version upgrades when specifying a value for the <code>EngineVersion</code> parameter that is a different major version than the DB cluster's current version.</p>  <p>If you upgrade the major version of a global database, the cluster and DB instance parameter groups are set to the default parameter groups for the new version. Apply any custom parameter groups after completing the upgrade.</p>
    /// - On success, responds with [`ModifyGlobalClusterOutput`](crate::output::ModifyGlobalClusterOutput) with field(s):
    ///   - [`global_cluster(Option<GlobalCluster>)`](crate::output::ModifyGlobalClusterOutput::global_cluster): <p>A data type representing an Aurora global database.</p>
    /// - On failure, responds with [`SdkError<ModifyGlobalClusterError>`](crate::error::ModifyGlobalClusterError)
    pub fn modify_global_cluster(&self) -> fluent_builders::ModifyGlobalCluster {
        fluent_builders::ModifyGlobalCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ModifyOptionGroup`](crate::client::fluent_builders::ModifyOptionGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`option_group_name(impl Into<String>)`](crate::client::fluent_builders::ModifyOptionGroup::option_group_name) / [`set_option_group_name(Option<String>)`](crate::client::fluent_builders::ModifyOptionGroup::set_option_group_name): <p>The name of the option group to be modified.</p>  <p>Permanent options, such as the TDE option for Oracle Advanced Security TDE, can't be removed from an option group, and that option group can't be removed from a DB instance once it is associated with a DB instance</p>
    ///   - [`options_to_include(Vec<OptionConfiguration>)`](crate::client::fluent_builders::ModifyOptionGroup::options_to_include) / [`set_options_to_include(Option<Vec<OptionConfiguration>>)`](crate::client::fluent_builders::ModifyOptionGroup::set_options_to_include): <p>Options in this list are added to the option group or, if already present, the specified configuration is used to update the existing configuration.</p>
    ///   - [`options_to_remove(Vec<String>)`](crate::client::fluent_builders::ModifyOptionGroup::options_to_remove) / [`set_options_to_remove(Option<Vec<String>>)`](crate::client::fluent_builders::ModifyOptionGroup::set_options_to_remove): <p>Options in this list are removed from the option group.</p>
    ///   - [`apply_immediately(bool)`](crate::client::fluent_builders::ModifyOptionGroup::apply_immediately) / [`set_apply_immediately(bool)`](crate::client::fluent_builders::ModifyOptionGroup::set_apply_immediately): <p>A value that indicates whether to apply the change immediately or during the next maintenance window for each instance associated with the option group.</p>
    /// - On success, responds with [`ModifyOptionGroupOutput`](crate::output::ModifyOptionGroupOutput) with field(s):
    ///   - [`option_group(Option<OptionGroup>)`](crate::output::ModifyOptionGroupOutput::option_group): <p></p>
    /// - On failure, responds with [`SdkError<ModifyOptionGroupError>`](crate::error::ModifyOptionGroupError)
    pub fn modify_option_group(&self) -> fluent_builders::ModifyOptionGroup {
        fluent_builders::ModifyOptionGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PromoteReadReplica`](crate::client::fluent_builders::PromoteReadReplica) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_instance_identifier(impl Into<String>)`](crate::client::fluent_builders::PromoteReadReplica::db_instance_identifier) / [`set_db_instance_identifier(Option<String>)`](crate::client::fluent_builders::PromoteReadReplica::set_db_instance_identifier): <p>The DB instance identifier. This value is stored as a lowercase string.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must match the identifier of an existing read replica DB instance.</p> </li>  </ul>  <p>Example: <code>mydbinstance</code> </p>
    ///   - [`backup_retention_period(i32)`](crate::client::fluent_builders::PromoteReadReplica::backup_retention_period) / [`set_backup_retention_period(Option<i32>)`](crate::client::fluent_builders::PromoteReadReplica::set_backup_retention_period): <p>The number of days for which automated backups are retained. Setting this parameter to a positive number enables backups. Setting this parameter to 0 disables automated backups.</p>  <p>Default: 1</p>  <p>Constraints:</p>  <ul>   <li> <p>Must be a value from 0 to 35.</p> </li>   <li> <p>Can't be set to 0 if the DB instance is a source to read replicas.</p> </li>  </ul>
    ///   - [`preferred_backup_window(impl Into<String>)`](crate::client::fluent_builders::PromoteReadReplica::preferred_backup_window) / [`set_preferred_backup_window(Option<String>)`](crate::client::fluent_builders::PromoteReadReplica::set_preferred_backup_window): <p>The daily time range during which automated backups are created if automated backups are enabled, using the <code>BackupRetentionPeriod</code> parameter.</p>  <p>The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Web Services Region. To see the time blocks available, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/AdjustingTheMaintenanceWindow.html"> Adjusting the Preferred Maintenance Window</a> in the <i>Amazon RDS User Guide.</i> </p>  <p>Constraints:</p>  <ul>   <li> <p>Must be in the format <code>hh24:mi-hh24:mi</code>.</p> </li>   <li> <p>Must be in Universal Coordinated Time (UTC).</p> </li>   <li> <p>Must not conflict with the preferred maintenance window.</p> </li>   <li> <p>Must be at least 30 minutes.</p> </li>  </ul>
    /// - On success, responds with [`PromoteReadReplicaOutput`](crate::output::PromoteReadReplicaOutput) with field(s):
    ///   - [`db_instance(Option<DbInstance>)`](crate::output::PromoteReadReplicaOutput::db_instance): <p>Contains the details of an Amazon RDS DB instance.</p>  <p>This data type is used as a response element in the operations <code>CreateDBInstance</code>, <code>CreateDBInstanceReadReplica</code>, <code>DeleteDBInstance</code>, <code>DescribeDBInstances</code>, <code>ModifyDBInstance</code>, <code>PromoteReadReplica</code>, <code>RebootDBInstance</code>, <code>RestoreDBInstanceFromDBSnapshot</code>, <code>RestoreDBInstanceFromS3</code>, <code>RestoreDBInstanceToPointInTime</code>, <code>StartDBInstance</code>, and <code>StopDBInstance</code>.</p>
    /// - On failure, responds with [`SdkError<PromoteReadReplicaError>`](crate::error::PromoteReadReplicaError)
    pub fn promote_read_replica(&self) -> fluent_builders::PromoteReadReplica {
        fluent_builders::PromoteReadReplica::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PromoteReadReplicaDBCluster`](crate::client::fluent_builders::PromoteReadReplicaDBCluster) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_cluster_identifier(impl Into<String>)`](crate::client::fluent_builders::PromoteReadReplicaDBCluster::db_cluster_identifier) / [`set_db_cluster_identifier(Option<String>)`](crate::client::fluent_builders::PromoteReadReplicaDBCluster::set_db_cluster_identifier): <p>The identifier of the DB cluster read replica to promote. This parameter isn't case-sensitive.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must match the identifier of an existing DB cluster read replica.</p> </li>  </ul>  <p>Example: <code>my-cluster-replica1</code> </p>
    /// - On success, responds with [`PromoteReadReplicaDbClusterOutput`](crate::output::PromoteReadReplicaDbClusterOutput) with field(s):
    ///   - [`db_cluster(Option<DbCluster>)`](crate::output::PromoteReadReplicaDbClusterOutput::db_cluster): <p>Contains the details of an Amazon Aurora DB cluster or Multi-AZ DB cluster.</p>  <p>For an Amazon Aurora DB cluster, this data type is used as a response element in the operations <code>CreateDBCluster</code>, <code>DeleteDBCluster</code>, <code>DescribeDBClusters</code>, <code>FailoverDBCluster</code>, <code>ModifyDBCluster</code>, <code>PromoteReadReplicaDBCluster</code>, <code>RestoreDBClusterFromS3</code>, <code>RestoreDBClusterFromSnapshot</code>, <code>RestoreDBClusterToPointInTime</code>, <code>StartDBCluster</code>, and <code>StopDBCluster</code>.</p>  <p>For a Multi-AZ DB cluster, this data type is used as a response element in the operations <code>CreateDBCluster</code>, <code>DeleteDBCluster</code>, <code>DescribeDBClusters</code>, <code>FailoverDBCluster</code>, <code>ModifyDBCluster</code>, <code>RebootDBCluster</code>, <code>RestoreDBClusterFromSnapshot</code>, and <code>RestoreDBClusterToPointInTime</code>.</p>  <p>For more information on Amazon Aurora DB clusters, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon Aurora?</a> in the <i>Amazon Aurora User Guide.</i> </p>  <p>For more information on Multi-AZ DB clusters, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ deployments with two readable standby DB instances</a> in the <i>Amazon RDS User Guide.</i> </p>
    /// - On failure, responds with [`SdkError<PromoteReadReplicaDBClusterError>`](crate::error::PromoteReadReplicaDBClusterError)
    pub fn promote_read_replica_db_cluster(&self) -> fluent_builders::PromoteReadReplicaDBCluster {
        fluent_builders::PromoteReadReplicaDBCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PurchaseReservedDBInstancesOffering`](crate::client::fluent_builders::PurchaseReservedDBInstancesOffering) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`reserved_db_instances_offering_id(impl Into<String>)`](crate::client::fluent_builders::PurchaseReservedDBInstancesOffering::reserved_db_instances_offering_id) / [`set_reserved_db_instances_offering_id(Option<String>)`](crate::client::fluent_builders::PurchaseReservedDBInstancesOffering::set_reserved_db_instances_offering_id): <p>The ID of the Reserved DB instance offering to purchase.</p>  <p>Example: 438012d3-4052-4cc7-b2e3-8d3372e0e706</p>
    ///   - [`reserved_db_instance_id(impl Into<String>)`](crate::client::fluent_builders::PurchaseReservedDBInstancesOffering::reserved_db_instance_id) / [`set_reserved_db_instance_id(Option<String>)`](crate::client::fluent_builders::PurchaseReservedDBInstancesOffering::set_reserved_db_instance_id): <p>Customer-specified identifier to track this reservation.</p>  <p>Example: myreservationID</p>
    ///   - [`db_instance_count(i32)`](crate::client::fluent_builders::PurchaseReservedDBInstancesOffering::db_instance_count) / [`set_db_instance_count(Option<i32>)`](crate::client::fluent_builders::PurchaseReservedDBInstancesOffering::set_db_instance_count): <p>The number of instances to reserve.</p>  <p>Default: <code>1</code> </p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::PurchaseReservedDBInstancesOffering::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::PurchaseReservedDBInstancesOffering::set_tags): <p>A list of tags. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources</a> in the <i>Amazon RDS User Guide.</i> </p>
    /// - On success, responds with [`PurchaseReservedDbInstancesOfferingOutput`](crate::output::PurchaseReservedDbInstancesOfferingOutput) with field(s):
    ///   - [`reserved_db_instance(Option<ReservedDbInstance>)`](crate::output::PurchaseReservedDbInstancesOfferingOutput::reserved_db_instance): <p>This data type is used as a response element in the <code>DescribeReservedDBInstances</code> and <code>PurchaseReservedDBInstancesOffering</code> actions.</p>
    /// - On failure, responds with [`SdkError<PurchaseReservedDBInstancesOfferingError>`](crate::error::PurchaseReservedDBInstancesOfferingError)
    pub fn purchase_reserved_db_instances_offering(
        &self,
    ) -> fluent_builders::PurchaseReservedDBInstancesOffering {
        fluent_builders::PurchaseReservedDBInstancesOffering::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RebootDBCluster`](crate::client::fluent_builders::RebootDBCluster) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_cluster_identifier(impl Into<String>)`](crate::client::fluent_builders::RebootDBCluster::db_cluster_identifier) / [`set_db_cluster_identifier(Option<String>)`](crate::client::fluent_builders::RebootDBCluster::set_db_cluster_identifier): <p>The DB cluster identifier. This parameter is stored as a lowercase string.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must match the identifier of an existing DBCluster.</p> </li>  </ul>
    /// - On success, responds with [`RebootDbClusterOutput`](crate::output::RebootDbClusterOutput) with field(s):
    ///   - [`db_cluster(Option<DbCluster>)`](crate::output::RebootDbClusterOutput::db_cluster): <p>Contains the details of an Amazon Aurora DB cluster or Multi-AZ DB cluster.</p>  <p>For an Amazon Aurora DB cluster, this data type is used as a response element in the operations <code>CreateDBCluster</code>, <code>DeleteDBCluster</code>, <code>DescribeDBClusters</code>, <code>FailoverDBCluster</code>, <code>ModifyDBCluster</code>, <code>PromoteReadReplicaDBCluster</code>, <code>RestoreDBClusterFromS3</code>, <code>RestoreDBClusterFromSnapshot</code>, <code>RestoreDBClusterToPointInTime</code>, <code>StartDBCluster</code>, and <code>StopDBCluster</code>.</p>  <p>For a Multi-AZ DB cluster, this data type is used as a response element in the operations <code>CreateDBCluster</code>, <code>DeleteDBCluster</code>, <code>DescribeDBClusters</code>, <code>FailoverDBCluster</code>, <code>ModifyDBCluster</code>, <code>RebootDBCluster</code>, <code>RestoreDBClusterFromSnapshot</code>, and <code>RestoreDBClusterToPointInTime</code>.</p>  <p>For more information on Amazon Aurora DB clusters, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon Aurora?</a> in the <i>Amazon Aurora User Guide.</i> </p>  <p>For more information on Multi-AZ DB clusters, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ deployments with two readable standby DB instances</a> in the <i>Amazon RDS User Guide.</i> </p>
    /// - On failure, responds with [`SdkError<RebootDBClusterError>`](crate::error::RebootDBClusterError)
    pub fn reboot_db_cluster(&self) -> fluent_builders::RebootDBCluster {
        fluent_builders::RebootDBCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RebootDBInstance`](crate::client::fluent_builders::RebootDBInstance) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_instance_identifier(impl Into<String>)`](crate::client::fluent_builders::RebootDBInstance::db_instance_identifier) / [`set_db_instance_identifier(Option<String>)`](crate::client::fluent_builders::RebootDBInstance::set_db_instance_identifier): <p>The DB instance identifier. This parameter is stored as a lowercase string.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must match the identifier of an existing DBInstance.</p> </li>  </ul>
    ///   - [`force_failover(bool)`](crate::client::fluent_builders::RebootDBInstance::force_failover) / [`set_force_failover(Option<bool>)`](crate::client::fluent_builders::RebootDBInstance::set_force_failover): <p>A value that indicates whether the reboot is conducted through a Multi-AZ failover.</p>  <p>Constraint: You can't enable force failover if the instance isn't configured for Multi-AZ.</p>
    /// - On success, responds with [`RebootDbInstanceOutput`](crate::output::RebootDbInstanceOutput) with field(s):
    ///   - [`db_instance(Option<DbInstance>)`](crate::output::RebootDbInstanceOutput::db_instance): <p>Contains the details of an Amazon RDS DB instance.</p>  <p>This data type is used as a response element in the operations <code>CreateDBInstance</code>, <code>CreateDBInstanceReadReplica</code>, <code>DeleteDBInstance</code>, <code>DescribeDBInstances</code>, <code>ModifyDBInstance</code>, <code>PromoteReadReplica</code>, <code>RebootDBInstance</code>, <code>RestoreDBInstanceFromDBSnapshot</code>, <code>RestoreDBInstanceFromS3</code>, <code>RestoreDBInstanceToPointInTime</code>, <code>StartDBInstance</code>, and <code>StopDBInstance</code>.</p>
    /// - On failure, responds with [`SdkError<RebootDBInstanceError>`](crate::error::RebootDBInstanceError)
    pub fn reboot_db_instance(&self) -> fluent_builders::RebootDBInstance {
        fluent_builders::RebootDBInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RegisterDBProxyTargets`](crate::client::fluent_builders::RegisterDBProxyTargets) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_proxy_name(impl Into<String>)`](crate::client::fluent_builders::RegisterDBProxyTargets::db_proxy_name) / [`set_db_proxy_name(Option<String>)`](crate::client::fluent_builders::RegisterDBProxyTargets::set_db_proxy_name): <p>The identifier of the <code>DBProxy</code> that is associated with the <code>DBProxyTargetGroup</code>.</p>
    ///   - [`target_group_name(impl Into<String>)`](crate::client::fluent_builders::RegisterDBProxyTargets::target_group_name) / [`set_target_group_name(Option<String>)`](crate::client::fluent_builders::RegisterDBProxyTargets::set_target_group_name): <p>The identifier of the <code>DBProxyTargetGroup</code>.</p>
    ///   - [`db_instance_identifiers(Vec<String>)`](crate::client::fluent_builders::RegisterDBProxyTargets::db_instance_identifiers) / [`set_db_instance_identifiers(Option<Vec<String>>)`](crate::client::fluent_builders::RegisterDBProxyTargets::set_db_instance_identifiers): <p>One or more DB instance identifiers.</p>
    ///   - [`db_cluster_identifiers(Vec<String>)`](crate::client::fluent_builders::RegisterDBProxyTargets::db_cluster_identifiers) / [`set_db_cluster_identifiers(Option<Vec<String>>)`](crate::client::fluent_builders::RegisterDBProxyTargets::set_db_cluster_identifiers): <p>One or more DB cluster identifiers.</p>
    /// - On success, responds with [`RegisterDbProxyTargetsOutput`](crate::output::RegisterDbProxyTargetsOutput) with field(s):
    ///   - [`db_proxy_targets(Option<Vec<DbProxyTarget>>)`](crate::output::RegisterDbProxyTargetsOutput::db_proxy_targets): <p>One or more <code>DBProxyTarget</code> objects that are created when you register targets with a target group.</p>
    /// - On failure, responds with [`SdkError<RegisterDBProxyTargetsError>`](crate::error::RegisterDBProxyTargetsError)
    pub fn register_db_proxy_targets(&self) -> fluent_builders::RegisterDBProxyTargets {
        fluent_builders::RegisterDBProxyTargets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RemoveFromGlobalCluster`](crate::client::fluent_builders::RemoveFromGlobalCluster) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`global_cluster_identifier(impl Into<String>)`](crate::client::fluent_builders::RemoveFromGlobalCluster::global_cluster_identifier) / [`set_global_cluster_identifier(Option<String>)`](crate::client::fluent_builders::RemoveFromGlobalCluster::set_global_cluster_identifier): <p>The cluster identifier to detach from the Aurora global database cluster.</p>
    ///   - [`db_cluster_identifier(impl Into<String>)`](crate::client::fluent_builders::RemoveFromGlobalCluster::db_cluster_identifier) / [`set_db_cluster_identifier(Option<String>)`](crate::client::fluent_builders::RemoveFromGlobalCluster::set_db_cluster_identifier): <p>The Amazon Resource Name (ARN) identifying the cluster that was detached from the Aurora global database cluster.</p>
    /// - On success, responds with [`RemoveFromGlobalClusterOutput`](crate::output::RemoveFromGlobalClusterOutput) with field(s):
    ///   - [`global_cluster(Option<GlobalCluster>)`](crate::output::RemoveFromGlobalClusterOutput::global_cluster): <p>A data type representing an Aurora global database.</p>
    /// - On failure, responds with [`SdkError<RemoveFromGlobalClusterError>`](crate::error::RemoveFromGlobalClusterError)
    pub fn remove_from_global_cluster(&self) -> fluent_builders::RemoveFromGlobalCluster {
        fluent_builders::RemoveFromGlobalCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RemoveRoleFromDBCluster`](crate::client::fluent_builders::RemoveRoleFromDBCluster) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_cluster_identifier(impl Into<String>)`](crate::client::fluent_builders::RemoveRoleFromDBCluster::db_cluster_identifier) / [`set_db_cluster_identifier(Option<String>)`](crate::client::fluent_builders::RemoveRoleFromDBCluster::set_db_cluster_identifier): <p>The name of the DB cluster to disassociate the IAM role from.</p>
    ///   - [`role_arn(impl Into<String>)`](crate::client::fluent_builders::RemoveRoleFromDBCluster::role_arn) / [`set_role_arn(Option<String>)`](crate::client::fluent_builders::RemoveRoleFromDBCluster::set_role_arn): <p>The Amazon Resource Name (ARN) of the IAM role to disassociate from the Aurora DB cluster, for example <code>arn:aws:iam::123456789012:role/AuroraAccessRole</code>.</p>
    ///   - [`feature_name(impl Into<String>)`](crate::client::fluent_builders::RemoveRoleFromDBCluster::feature_name) / [`set_feature_name(Option<String>)`](crate::client::fluent_builders::RemoveRoleFromDBCluster::set_feature_name): <p>The name of the feature for the DB cluster that the IAM role is to be disassociated from. For information about supported feature names, see <code>DBEngineVersion</code>.</p>
    /// - On success, responds with [`RemoveRoleFromDbClusterOutput`](crate::output::RemoveRoleFromDbClusterOutput)

    /// - On failure, responds with [`SdkError<RemoveRoleFromDBClusterError>`](crate::error::RemoveRoleFromDBClusterError)
    pub fn remove_role_from_db_cluster(&self) -> fluent_builders::RemoveRoleFromDBCluster {
        fluent_builders::RemoveRoleFromDBCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RemoveRoleFromDBInstance`](crate::client::fluent_builders::RemoveRoleFromDBInstance) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_instance_identifier(impl Into<String>)`](crate::client::fluent_builders::RemoveRoleFromDBInstance::db_instance_identifier) / [`set_db_instance_identifier(Option<String>)`](crate::client::fluent_builders::RemoveRoleFromDBInstance::set_db_instance_identifier): <p>The name of the DB instance to disassociate the IAM role from.</p>
    ///   - [`role_arn(impl Into<String>)`](crate::client::fluent_builders::RemoveRoleFromDBInstance::role_arn) / [`set_role_arn(Option<String>)`](crate::client::fluent_builders::RemoveRoleFromDBInstance::set_role_arn): <p>The Amazon Resource Name (ARN) of the IAM role to disassociate from the DB instance, for example, <code>arn:aws:iam::123456789012:role/AccessRole</code>.</p>
    ///   - [`feature_name(impl Into<String>)`](crate::client::fluent_builders::RemoveRoleFromDBInstance::feature_name) / [`set_feature_name(Option<String>)`](crate::client::fluent_builders::RemoveRoleFromDBInstance::set_feature_name): <p>The name of the feature for the DB instance that the IAM role is to be disassociated from. For information about supported feature names, see <code>DBEngineVersion</code>.</p>
    /// - On success, responds with [`RemoveRoleFromDbInstanceOutput`](crate::output::RemoveRoleFromDbInstanceOutput)

    /// - On failure, responds with [`SdkError<RemoveRoleFromDBInstanceError>`](crate::error::RemoveRoleFromDBInstanceError)
    pub fn remove_role_from_db_instance(&self) -> fluent_builders::RemoveRoleFromDBInstance {
        fluent_builders::RemoveRoleFromDBInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RemoveSourceIdentifierFromSubscription`](crate::client::fluent_builders::RemoveSourceIdentifierFromSubscription) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`subscription_name(impl Into<String>)`](crate::client::fluent_builders::RemoveSourceIdentifierFromSubscription::subscription_name) / [`set_subscription_name(Option<String>)`](crate::client::fluent_builders::RemoveSourceIdentifierFromSubscription::set_subscription_name): <p>The name of the RDS event notification subscription you want to remove a source identifier from.</p>
    ///   - [`source_identifier(impl Into<String>)`](crate::client::fluent_builders::RemoveSourceIdentifierFromSubscription::source_identifier) / [`set_source_identifier(Option<String>)`](crate::client::fluent_builders::RemoveSourceIdentifierFromSubscription::set_source_identifier): <p>The source identifier to be removed from the subscription, such as the <b>DB instance identifier</b> for a DB instance or the name of a security group.</p>
    /// - On success, responds with [`RemoveSourceIdentifierFromSubscriptionOutput`](crate::output::RemoveSourceIdentifierFromSubscriptionOutput) with field(s):
    ///   - [`event_subscription(Option<EventSubscription>)`](crate::output::RemoveSourceIdentifierFromSubscriptionOutput::event_subscription): <p>Contains the results of a successful invocation of the <code>DescribeEventSubscriptions</code> action.</p>
    /// - On failure, responds with [`SdkError<RemoveSourceIdentifierFromSubscriptionError>`](crate::error::RemoveSourceIdentifierFromSubscriptionError)
    pub fn remove_source_identifier_from_subscription(
        &self,
    ) -> fluent_builders::RemoveSourceIdentifierFromSubscription {
        fluent_builders::RemoveSourceIdentifierFromSubscription::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RemoveTagsFromResource`](crate::client::fluent_builders::RemoveTagsFromResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_name(impl Into<String>)`](crate::client::fluent_builders::RemoveTagsFromResource::resource_name) / [`set_resource_name(Option<String>)`](crate::client::fluent_builders::RemoveTagsFromResource::set_resource_name): <p>The Amazon RDS resource that the tags are removed from. This value is an Amazon Resource Name (ARN). For information about creating an ARN, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing"> Constructing an ARN for Amazon RDS</a> in the <i>Amazon RDS User Guide.</i> </p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::RemoveTagsFromResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::RemoveTagsFromResource::set_tag_keys): <p>The tag key (name) of the tag to be removed.</p>
    /// - On success, responds with [`RemoveTagsFromResourceOutput`](crate::output::RemoveTagsFromResourceOutput)

    /// - On failure, responds with [`SdkError<RemoveTagsFromResourceError>`](crate::error::RemoveTagsFromResourceError)
    pub fn remove_tags_from_resource(&self) -> fluent_builders::RemoveTagsFromResource {
        fluent_builders::RemoveTagsFromResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ResetDBClusterParameterGroup`](crate::client::fluent_builders::ResetDBClusterParameterGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_cluster_parameter_group_name(impl Into<String>)`](crate::client::fluent_builders::ResetDBClusterParameterGroup::db_cluster_parameter_group_name) / [`set_db_cluster_parameter_group_name(Option<String>)`](crate::client::fluent_builders::ResetDBClusterParameterGroup::set_db_cluster_parameter_group_name): <p>The name of the DB cluster parameter group to reset.</p>
    ///   - [`reset_all_parameters(bool)`](crate::client::fluent_builders::ResetDBClusterParameterGroup::reset_all_parameters) / [`set_reset_all_parameters(bool)`](crate::client::fluent_builders::ResetDBClusterParameterGroup::set_reset_all_parameters): <p>A value that indicates whether to reset all parameters in the DB cluster parameter group to their default values. You can't use this parameter if there is a list of parameter names specified for the <code>Parameters</code> parameter.</p>
    ///   - [`parameters(Vec<Parameter>)`](crate::client::fluent_builders::ResetDBClusterParameterGroup::parameters) / [`set_parameters(Option<Vec<Parameter>>)`](crate::client::fluent_builders::ResetDBClusterParameterGroup::set_parameters): <p>A list of parameter names in the DB cluster parameter group to reset to the default values. You can't use this parameter if the <code>ResetAllParameters</code> parameter is enabled.</p>
    /// - On success, responds with [`ResetDbClusterParameterGroupOutput`](crate::output::ResetDbClusterParameterGroupOutput) with field(s):
    ///   - [`db_cluster_parameter_group_name(Option<String>)`](crate::output::ResetDbClusterParameterGroupOutput::db_cluster_parameter_group_name): <p>The name of the DB cluster parameter group.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must be 1 to 255 letters or numbers.</p> </li>   <li> <p>First character must be a letter</p> </li>   <li> <p>Can't end with a hyphen or contain two consecutive hyphens</p> </li>  </ul> <note>   <p>This value is stored as a lowercase string.</p>  </note>
    /// - On failure, responds with [`SdkError<ResetDBClusterParameterGroupError>`](crate::error::ResetDBClusterParameterGroupError)
    pub fn reset_db_cluster_parameter_group(
        &self,
    ) -> fluent_builders::ResetDBClusterParameterGroup {
        fluent_builders::ResetDBClusterParameterGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ResetDBParameterGroup`](crate::client::fluent_builders::ResetDBParameterGroup) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_parameter_group_name(impl Into<String>)`](crate::client::fluent_builders::ResetDBParameterGroup::db_parameter_group_name) / [`set_db_parameter_group_name(Option<String>)`](crate::client::fluent_builders::ResetDBParameterGroup::set_db_parameter_group_name): <p>The name of the DB parameter group.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must match the name of an existing <code>DBParameterGroup</code>.</p> </li>  </ul>
    ///   - [`reset_all_parameters(bool)`](crate::client::fluent_builders::ResetDBParameterGroup::reset_all_parameters) / [`set_reset_all_parameters(bool)`](crate::client::fluent_builders::ResetDBParameterGroup::set_reset_all_parameters): <p>A value that indicates whether to reset all parameters in the DB parameter group to default values. By default, all parameters in the DB parameter group are reset to default values.</p>
    ///   - [`parameters(Vec<Parameter>)`](crate::client::fluent_builders::ResetDBParameterGroup::parameters) / [`set_parameters(Option<Vec<Parameter>>)`](crate::client::fluent_builders::ResetDBParameterGroup::set_parameters): <p>To reset the entire DB parameter group, specify the <code>DBParameterGroup</code> name and <code>ResetAllParameters</code> parameters. To reset specific parameters, provide a list of the following: <code>ParameterName</code> and <code>ApplyMethod</code>. A maximum of 20 parameters can be modified in a single request.</p>  <p> <b>MySQL</b> </p>  <p>Valid Values (for Apply method): <code>immediate</code> | <code>pending-reboot</code> </p>  <p>You can use the immediate value with dynamic parameters only. You can use the <code>pending-reboot</code> value for both dynamic and static parameters, and changes are applied when DB instance reboots.</p>  <p> <b>MariaDB</b> </p>  <p>Valid Values (for Apply method): <code>immediate</code> | <code>pending-reboot</code> </p>  <p>You can use the immediate value with dynamic parameters only. You can use the <code>pending-reboot</code> value for both dynamic and static parameters, and changes are applied when DB instance reboots.</p>  <p> <b>Oracle</b> </p>  <p>Valid Values (for Apply method): <code>pending-reboot</code> </p>
    /// - On success, responds with [`ResetDbParameterGroupOutput`](crate::output::ResetDbParameterGroupOutput) with field(s):
    ///   - [`db_parameter_group_name(Option<String>)`](crate::output::ResetDbParameterGroupOutput::db_parameter_group_name): <p>The name of the DB parameter group.</p>
    /// - On failure, responds with [`SdkError<ResetDBParameterGroupError>`](crate::error::ResetDBParameterGroupError)
    pub fn reset_db_parameter_group(&self) -> fluent_builders::ResetDBParameterGroup {
        fluent_builders::ResetDBParameterGroup::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RestoreDBClusterFromS3`](crate::client::fluent_builders::RestoreDBClusterFromS3) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`availability_zones(Vec<String>)`](crate::client::fluent_builders::RestoreDBClusterFromS3::availability_zones) / [`set_availability_zones(Option<Vec<String>>)`](crate::client::fluent_builders::RestoreDBClusterFromS3::set_availability_zones): <p>A list of Availability Zones (AZs) where instances in the restored DB cluster can be created.</p>
    ///   - [`backup_retention_period(i32)`](crate::client::fluent_builders::RestoreDBClusterFromS3::backup_retention_period) / [`set_backup_retention_period(Option<i32>)`](crate::client::fluent_builders::RestoreDBClusterFromS3::set_backup_retention_period): <p>The number of days for which automated backups of the restored DB cluster are retained. You must specify a minimum value of 1.</p>  <p>Default: 1</p>  <p>Constraints:</p>  <ul>   <li> <p>Must be a value from 1 to 35</p> </li>  </ul>
    ///   - [`character_set_name(impl Into<String>)`](crate::client::fluent_builders::RestoreDBClusterFromS3::character_set_name) / [`set_character_set_name(Option<String>)`](crate::client::fluent_builders::RestoreDBClusterFromS3::set_character_set_name): <p>A value that indicates that the restored DB cluster should be associated with the specified CharacterSet.</p>
    ///   - [`database_name(impl Into<String>)`](crate::client::fluent_builders::RestoreDBClusterFromS3::database_name) / [`set_database_name(Option<String>)`](crate::client::fluent_builders::RestoreDBClusterFromS3::set_database_name): <p>The database name for the restored DB cluster.</p>
    ///   - [`db_cluster_identifier(impl Into<String>)`](crate::client::fluent_builders::RestoreDBClusterFromS3::db_cluster_identifier) / [`set_db_cluster_identifier(Option<String>)`](crate::client::fluent_builders::RestoreDBClusterFromS3::set_db_cluster_identifier): <p>The name of the DB cluster to create from the source data in the Amazon S3 bucket. This parameter isn't case-sensitive.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p> </li>   <li> <p>First character must be a letter.</p> </li>   <li> <p>Can't end with a hyphen or contain two consecutive hyphens.</p> </li>  </ul>  <p>Example: <code>my-cluster1</code> </p>
    ///   - [`db_cluster_parameter_group_name(impl Into<String>)`](crate::client::fluent_builders::RestoreDBClusterFromS3::db_cluster_parameter_group_name) / [`set_db_cluster_parameter_group_name(Option<String>)`](crate::client::fluent_builders::RestoreDBClusterFromS3::set_db_cluster_parameter_group_name): <p>The name of the DB cluster parameter group to associate with the restored DB cluster. If this argument is omitted, <code>default.aurora5.6</code> is used.</p>  <p>Constraints:</p>  <ul>   <li> <p>If supplied, must match the name of an existing DBClusterParameterGroup.</p> </li>  </ul>
    ///   - [`vpc_security_group_ids(Vec<String>)`](crate::client::fluent_builders::RestoreDBClusterFromS3::vpc_security_group_ids) / [`set_vpc_security_group_ids(Option<Vec<String>>)`](crate::client::fluent_builders::RestoreDBClusterFromS3::set_vpc_security_group_ids): <p>A list of EC2 VPC security groups to associate with the restored DB cluster.</p>
    ///   - [`db_subnet_group_name(impl Into<String>)`](crate::client::fluent_builders::RestoreDBClusterFromS3::db_subnet_group_name) / [`set_db_subnet_group_name(Option<String>)`](crate::client::fluent_builders::RestoreDBClusterFromS3::set_db_subnet_group_name): <p>A DB subnet group to associate with the restored DB cluster.</p>  <p>Constraints: If supplied, must match the name of an existing DBSubnetGroup.</p>  <p>Example: <code>mydbsubnetgroup</code> </p>
    ///   - [`engine(impl Into<String>)`](crate::client::fluent_builders::RestoreDBClusterFromS3::engine) / [`set_engine(Option<String>)`](crate::client::fluent_builders::RestoreDBClusterFromS3::set_engine): <p>The name of the database engine to be used for this DB cluster.</p>  <p>Valid Values: <code>aurora</code> (for MySQL 5.6-compatible Aurora), <code>aurora-mysql</code> (for MySQL 5.7-compatible and MySQL 8.0-compatible Aurora), and <code>aurora-postgresql</code> </p>
    ///   - [`engine_version(impl Into<String>)`](crate::client::fluent_builders::RestoreDBClusterFromS3::engine_version) / [`set_engine_version(Option<String>)`](crate::client::fluent_builders::RestoreDBClusterFromS3::set_engine_version): <p>The version number of the database engine to use.</p>  <p>To list all of the available engine versions for <code>aurora</code> (for MySQL 5.6-compatible Aurora), use the following command:</p>  <p> <code>aws rds describe-db-engine-versions --engine aurora --query "DBEngineVersions[].EngineVersion"</code> </p>  <p>To list all of the available engine versions for <code>aurora-mysql</code> (for MySQL 5.7-compatible and MySQL 8.0-compatible Aurora), use the following command:</p>  <p> <code>aws rds describe-db-engine-versions --engine aurora-mysql --query "DBEngineVersions[].EngineVersion"</code> </p>  <p>To list all of the available engine versions for <code>aurora-postgresql</code>, use the following command:</p>  <p> <code>aws rds describe-db-engine-versions --engine aurora-postgresql --query "DBEngineVersions[].EngineVersion"</code> </p>  <p> <b>Aurora MySQL</b> </p>  <p>Example: <code>5.6.10a</code>, <code>5.6.mysql_aurora.1.19.2</code>, <code>5.7.12</code>, <code>5.7.mysql_aurora.2.04.5</code>, <code>8.0.mysql_aurora.3.01.0</code> </p>  <p> <b>Aurora PostgreSQL</b> </p>  <p>Example: <code>9.6.3</code>, <code>10.7</code> </p>
    ///   - [`port(i32)`](crate::client::fluent_builders::RestoreDBClusterFromS3::port) / [`set_port(Option<i32>)`](crate::client::fluent_builders::RestoreDBClusterFromS3::set_port): <p>The port number on which the instances in the restored DB cluster accept connections.</p>  <p>Default: <code>3306</code> </p>
    ///   - [`master_username(impl Into<String>)`](crate::client::fluent_builders::RestoreDBClusterFromS3::master_username) / [`set_master_username(Option<String>)`](crate::client::fluent_builders::RestoreDBClusterFromS3::set_master_username): <p>The name of the master user for the restored DB cluster.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must be 1 to 16 letters or numbers.</p> </li>   <li> <p>First character must be a letter.</p> </li>   <li> <p>Can't be a reserved word for the chosen database engine.</p> </li>  </ul>
    ///   - [`master_user_password(impl Into<String>)`](crate::client::fluent_builders::RestoreDBClusterFromS3::master_user_password) / [`set_master_user_password(Option<String>)`](crate::client::fluent_builders::RestoreDBClusterFromS3::set_master_user_password): <p>The password for the master database user. This password can contain any printable ASCII character except "/", """, or "@".</p>  <p>Constraints: Must contain from 8 to 41 characters.</p>
    ///   - [`option_group_name(impl Into<String>)`](crate::client::fluent_builders::RestoreDBClusterFromS3::option_group_name) / [`set_option_group_name(Option<String>)`](crate::client::fluent_builders::RestoreDBClusterFromS3::set_option_group_name): <p>A value that indicates that the restored DB cluster should be associated with the specified option group.</p>  <p>Permanent options can't be removed from an option group. An option group can't be removed from a DB cluster once it is associated with a DB cluster.</p>
    ///   - [`preferred_backup_window(impl Into<String>)`](crate::client::fluent_builders::RestoreDBClusterFromS3::preferred_backup_window) / [`set_preferred_backup_window(Option<String>)`](crate::client::fluent_builders::RestoreDBClusterFromS3::set_preferred_backup_window): <p>The daily time range during which automated backups are created if automated backups are enabled using the <code>BackupRetentionPeriod</code> parameter.</p>  <p>The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Web Services Region. To view the time blocks available, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.Backups.BackupWindow"> Backup window</a> in the <i>Amazon Aurora User Guide</i>.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must be in the format <code>hh24:mi-hh24:mi</code>.</p> </li>   <li> <p>Must be in Universal Coordinated Time (UTC).</p> </li>   <li> <p>Must not conflict with the preferred maintenance window.</p> </li>   <li> <p>Must be at least 30 minutes.</p> </li>  </ul>
    ///   - [`preferred_maintenance_window(impl Into<String>)`](crate::client::fluent_builders::RestoreDBClusterFromS3::preferred_maintenance_window) / [`set_preferred_maintenance_window(Option<String>)`](crate::client::fluent_builders::RestoreDBClusterFromS3::set_preferred_maintenance_window): <p>The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).</p>  <p>Format: <code>ddd:hh24:mi-ddd:hh24:mi</code> </p>  <p>The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Web Services Region, occurring on a random day of the week. To see the time blocks available, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow.Aurora"> Adjusting the Preferred Maintenance Window</a> in the <i>Amazon Aurora User Guide</i>.</p>  <p>Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.</p>  <p>Constraints: Minimum 30-minute window.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::RestoreDBClusterFromS3::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::RestoreDBClusterFromS3::set_tags): <p>A list of tags. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources</a> in the <i>Amazon RDS User Guide.</i> </p>
    ///   - [`storage_encrypted(bool)`](crate::client::fluent_builders::RestoreDBClusterFromS3::storage_encrypted) / [`set_storage_encrypted(Option<bool>)`](crate::client::fluent_builders::RestoreDBClusterFromS3::set_storage_encrypted): <p>A value that indicates whether the restored DB cluster is encrypted.</p>
    ///   - [`kms_key_id(impl Into<String>)`](crate::client::fluent_builders::RestoreDBClusterFromS3::kms_key_id) / [`set_kms_key_id(Option<String>)`](crate::client::fluent_builders::RestoreDBClusterFromS3::set_kms_key_id): <p>The Amazon Web Services KMS key identifier for an encrypted DB cluster.</p>  <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key. To use a KMS key in a different Amazon Web Services account, specify the key ARN or alias ARN.</p>  <p>If the StorageEncrypted parameter is enabled, and you do not specify a value for the <code>KmsKeyId</code> parameter, then Amazon RDS will use your default KMS key. There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account has a different default KMS key for each Amazon Web Services Region.</p>
    ///   - [`enable_iam_database_authentication(bool)`](crate::client::fluent_builders::RestoreDBClusterFromS3::enable_iam_database_authentication) / [`set_enable_iam_database_authentication(Option<bool>)`](crate::client::fluent_builders::RestoreDBClusterFromS3::set_enable_iam_database_authentication): <p>A value that indicates whether to enable mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts. By default, mapping isn't enabled.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.IAMDBAuth.html"> IAM Database Authentication</a> in the <i>Amazon Aurora User Guide</i>.</p>
    ///   - [`source_engine(impl Into<String>)`](crate::client::fluent_builders::RestoreDBClusterFromS3::source_engine) / [`set_source_engine(Option<String>)`](crate::client::fluent_builders::RestoreDBClusterFromS3::set_source_engine): <p>The identifier for the database engine that was backed up to create the files stored in the Amazon S3 bucket.</p>  <p>Valid values: <code>mysql</code> </p>
    ///   - [`source_engine_version(impl Into<String>)`](crate::client::fluent_builders::RestoreDBClusterFromS3::source_engine_version) / [`set_source_engine_version(Option<String>)`](crate::client::fluent_builders::RestoreDBClusterFromS3::set_source_engine_version): <p>The version of the database that the backup files were created from.</p>  <p>MySQL versions 5.5, 5.6, and 5.7 are supported.</p>  <p>Example: <code>5.6.40</code>, <code>5.7.28</code> </p>
    ///   - [`s3_bucket_name(impl Into<String>)`](crate::client::fluent_builders::RestoreDBClusterFromS3::s3_bucket_name) / [`set_s3_bucket_name(Option<String>)`](crate::client::fluent_builders::RestoreDBClusterFromS3::set_s3_bucket_name): <p>The name of the Amazon S3 bucket that contains the data used to create the Amazon Aurora DB cluster.</p>
    ///   - [`s3_prefix(impl Into<String>)`](crate::client::fluent_builders::RestoreDBClusterFromS3::s3_prefix) / [`set_s3_prefix(Option<String>)`](crate::client::fluent_builders::RestoreDBClusterFromS3::set_s3_prefix): <p>The prefix for all of the file names that contain the data used to create the Amazon Aurora DB cluster. If you do not specify a <b>SourceS3Prefix</b> value, then the Amazon Aurora DB cluster is created by using all of the files in the Amazon S3 bucket.</p>
    ///   - [`s3_ingestion_role_arn(impl Into<String>)`](crate::client::fluent_builders::RestoreDBClusterFromS3::s3_ingestion_role_arn) / [`set_s3_ingestion_role_arn(Option<String>)`](crate::client::fluent_builders::RestoreDBClusterFromS3::set_s3_ingestion_role_arn): <p>The Amazon Resource Name (ARN) of the Amazon Web Services Identity and Access Management (IAM) role that authorizes Amazon RDS to access the Amazon S3 bucket on your behalf.</p>
    ///   - [`backtrack_window(i64)`](crate::client::fluent_builders::RestoreDBClusterFromS3::backtrack_window) / [`set_backtrack_window(Option<i64>)`](crate::client::fluent_builders::RestoreDBClusterFromS3::set_backtrack_window): <p>The target backtrack window, in seconds. To disable backtracking, set this value to 0.</p> <note>   <p>Currently, Backtrack is only supported for Aurora MySQL DB clusters.</p>  </note>  <p>Default: 0</p>  <p>Constraints:</p>  <ul>   <li> <p>If specified, this value must be set to a number from 0 to 259,200 (72 hours).</p> </li>  </ul>
    ///   - [`enable_cloudwatch_logs_exports(Vec<String>)`](crate::client::fluent_builders::RestoreDBClusterFromS3::enable_cloudwatch_logs_exports) / [`set_enable_cloudwatch_logs_exports(Option<Vec<String>>)`](crate::client::fluent_builders::RestoreDBClusterFromS3::set_enable_cloudwatch_logs_exports): <p>The list of logs that the restored DB cluster is to export to CloudWatch Logs. The values in the list depend on the DB engine being used.</p>  <p> <b>Aurora MySQL</b> </p>  <p>Possible values are <code>audit</code>, <code>error</code>, <code>general</code>, and <code>slowquery</code>.</p>  <p> <b>Aurora PostgreSQL</b> </p>  <p>Possible value is <code>postgresql</code>.</p>  <p>For more information about exporting CloudWatch Logs for Amazon Aurora, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch">Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon Aurora User Guide</i>.</p>
    ///   - [`deletion_protection(bool)`](crate::client::fluent_builders::RestoreDBClusterFromS3::deletion_protection) / [`set_deletion_protection(Option<bool>)`](crate::client::fluent_builders::RestoreDBClusterFromS3::set_deletion_protection): <p>A value that indicates whether the DB cluster has deletion protection enabled. The database can't be deleted when deletion protection is enabled. By default, deletion protection isn't enabled.</p>
    ///   - [`copy_tags_to_snapshot(bool)`](crate::client::fluent_builders::RestoreDBClusterFromS3::copy_tags_to_snapshot) / [`set_copy_tags_to_snapshot(Option<bool>)`](crate::client::fluent_builders::RestoreDBClusterFromS3::set_copy_tags_to_snapshot): <p>A value that indicates whether to copy all tags from the restored DB cluster to snapshots of the restored DB cluster. The default is not to copy them.</p>
    ///   - [`domain(impl Into<String>)`](crate::client::fluent_builders::RestoreDBClusterFromS3::domain) / [`set_domain(Option<String>)`](crate::client::fluent_builders::RestoreDBClusterFromS3::set_domain): <p>Specify the Active Directory directory ID to restore the DB cluster in. The domain must be created prior to this operation.</p>  <p>For Amazon Aurora DB clusters, Amazon RDS can use Kerberos Authentication to authenticate users that connect to the DB cluster. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/kerberos-authentication.html">Kerberos Authentication</a> in the <i>Amazon Aurora User Guide</i>.</p>
    ///   - [`domain_iam_role_name(impl Into<String>)`](crate::client::fluent_builders::RestoreDBClusterFromS3::domain_iam_role_name) / [`set_domain_iam_role_name(Option<String>)`](crate::client::fluent_builders::RestoreDBClusterFromS3::set_domain_iam_role_name): <p>Specify the name of the IAM role to be used when making API calls to the Directory Service.</p>
    ///   - [`serverless_v2_scaling_configuration(ServerlessV2ScalingConfiguration)`](crate::client::fluent_builders::RestoreDBClusterFromS3::serverless_v2_scaling_configuration) / [`set_serverless_v2_scaling_configuration(Option<ServerlessV2ScalingConfiguration>)`](crate::client::fluent_builders::RestoreDBClusterFromS3::set_serverless_v2_scaling_configuration): <p>Contains the scaling configuration of an Aurora Serverless v2 DB cluster.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless-v2.html">Using Amazon Aurora Serverless v2</a> in the <i>Amazon Aurora User Guide</i>.</p>
    /// - On success, responds with [`RestoreDbClusterFromS3Output`](crate::output::RestoreDbClusterFromS3Output) with field(s):
    ///   - [`db_cluster(Option<DbCluster>)`](crate::output::RestoreDbClusterFromS3Output::db_cluster): <p>Contains the details of an Amazon Aurora DB cluster or Multi-AZ DB cluster.</p>  <p>For an Amazon Aurora DB cluster, this data type is used as a response element in the operations <code>CreateDBCluster</code>, <code>DeleteDBCluster</code>, <code>DescribeDBClusters</code>, <code>FailoverDBCluster</code>, <code>ModifyDBCluster</code>, <code>PromoteReadReplicaDBCluster</code>, <code>RestoreDBClusterFromS3</code>, <code>RestoreDBClusterFromSnapshot</code>, <code>RestoreDBClusterToPointInTime</code>, <code>StartDBCluster</code>, and <code>StopDBCluster</code>.</p>  <p>For a Multi-AZ DB cluster, this data type is used as a response element in the operations <code>CreateDBCluster</code>, <code>DeleteDBCluster</code>, <code>DescribeDBClusters</code>, <code>FailoverDBCluster</code>, <code>ModifyDBCluster</code>, <code>RebootDBCluster</code>, <code>RestoreDBClusterFromSnapshot</code>, and <code>RestoreDBClusterToPointInTime</code>.</p>  <p>For more information on Amazon Aurora DB clusters, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon Aurora?</a> in the <i>Amazon Aurora User Guide.</i> </p>  <p>For more information on Multi-AZ DB clusters, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ deployments with two readable standby DB instances</a> in the <i>Amazon RDS User Guide.</i> </p>
    /// - On failure, responds with [`SdkError<RestoreDBClusterFromS3Error>`](crate::error::RestoreDBClusterFromS3Error)
    pub fn restore_db_cluster_from_s3(&self) -> fluent_builders::RestoreDBClusterFromS3 {
        fluent_builders::RestoreDBClusterFromS3::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RestoreDBClusterFromSnapshot`](crate::client::fluent_builders::RestoreDBClusterFromSnapshot) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`availability_zones(Vec<String>)`](crate::client::fluent_builders::RestoreDBClusterFromSnapshot::availability_zones) / [`set_availability_zones(Option<Vec<String>>)`](crate::client::fluent_builders::RestoreDBClusterFromSnapshot::set_availability_zones): <p>Provides the list of Availability Zones (AZs) where instances in the restored DB cluster can be created.</p>  <p>Valid for: Aurora DB clusters only</p>
    ///   - [`db_cluster_identifier(impl Into<String>)`](crate::client::fluent_builders::RestoreDBClusterFromSnapshot::db_cluster_identifier) / [`set_db_cluster_identifier(Option<String>)`](crate::client::fluent_builders::RestoreDBClusterFromSnapshot::set_db_cluster_identifier): <p>The name of the DB cluster to create from the DB snapshot or DB cluster snapshot. This parameter isn't case-sensitive.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must contain from 1 to 63 letters, numbers, or hyphens</p> </li>   <li> <p>First character must be a letter</p> </li>   <li> <p>Can't end with a hyphen or contain two consecutive hyphens</p> </li>  </ul>  <p>Example: <code>my-snapshot-id</code> </p>  <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
    ///   - [`snapshot_identifier(impl Into<String>)`](crate::client::fluent_builders::RestoreDBClusterFromSnapshot::snapshot_identifier) / [`set_snapshot_identifier(Option<String>)`](crate::client::fluent_builders::RestoreDBClusterFromSnapshot::set_snapshot_identifier): <p>The identifier for the DB snapshot or DB cluster snapshot to restore from.</p>  <p>You can use either the name or the Amazon Resource Name (ARN) to specify a DB cluster snapshot. However, you can use only the ARN to specify a DB snapshot.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must match the identifier of an existing Snapshot.</p> </li>  </ul>  <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
    ///   - [`engine(impl Into<String>)`](crate::client::fluent_builders::RestoreDBClusterFromSnapshot::engine) / [`set_engine(Option<String>)`](crate::client::fluent_builders::RestoreDBClusterFromSnapshot::set_engine): <p>The database engine to use for the new DB cluster.</p>  <p>Default: The same as source</p>  <p>Constraint: Must be compatible with the engine of the source</p>  <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
    ///   - [`engine_version(impl Into<String>)`](crate::client::fluent_builders::RestoreDBClusterFromSnapshot::engine_version) / [`set_engine_version(Option<String>)`](crate::client::fluent_builders::RestoreDBClusterFromSnapshot::set_engine_version): <p>The version of the database engine to use for the new DB cluster.</p>  <p>To list all of the available engine versions for MySQL 5.6-compatible Aurora, use the following command:</p>  <p> <code>aws rds describe-db-engine-versions --engine aurora --query "DBEngineVersions[].EngineVersion"</code> </p>  <p>To list all of the available engine versions for MySQL 5.7-compatible and MySQL 8.0-compatible Aurora, use the following command:</p>  <p> <code>aws rds describe-db-engine-versions --engine aurora-mysql --query "DBEngineVersions[].EngineVersion"</code> </p>  <p>To list all of the available engine versions for Aurora PostgreSQL, use the following command:</p>  <p> <code>aws rds describe-db-engine-versions --engine aurora-postgresql --query "DBEngineVersions[].EngineVersion"</code> </p>  <p>To list all of the available engine versions for RDS for MySQL, use the following command:</p>  <p> <code>aws rds describe-db-engine-versions --engine mysql --query "DBEngineVersions[].EngineVersion"</code> </p>  <p>To list all of the available engine versions for RDS for PostgreSQL, use the following command:</p>  <p> <code>aws rds describe-db-engine-versions --engine postgres --query "DBEngineVersions[].EngineVersion"</code> </p>  <p> <b>Aurora MySQL</b> </p>  <p>See <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraMySQL.Updates.html">MySQL on Amazon RDS Versions</a> in the <i>Amazon Aurora User Guide</i>.</p>  <p> <b>Aurora PostgreSQL</b> </p>  <p>See <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraPostgreSQL.Updates.20180305.html">Amazon Aurora PostgreSQL releases and engine versions</a> in the <i>Amazon Aurora User Guide</i>.</p>  <p> <b>MySQL</b> </p>  <p>See <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_MySQL.html#MySQL.Concepts.VersionMgmt">MySQL on Amazon RDS Versions</a> in the <i>Amazon RDS User Guide.</i> </p>  <p> <b>PostgreSQL</b> </p>  <p>See <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_PostgreSQL.html#PostgreSQL.Concepts">Amazon RDS for PostgreSQL versions and extensions</a> in the <i>Amazon RDS User Guide.</i> </p>  <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
    ///   - [`port(i32)`](crate::client::fluent_builders::RestoreDBClusterFromSnapshot::port) / [`set_port(Option<i32>)`](crate::client::fluent_builders::RestoreDBClusterFromSnapshot::set_port): <p>The port number on which the new DB cluster accepts connections.</p>  <p>Constraints: This value must be <code>1150-65535</code> </p>  <p>Default: The same port as the original DB cluster.</p>  <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
    ///   - [`db_subnet_group_name(impl Into<String>)`](crate::client::fluent_builders::RestoreDBClusterFromSnapshot::db_subnet_group_name) / [`set_db_subnet_group_name(Option<String>)`](crate::client::fluent_builders::RestoreDBClusterFromSnapshot::set_db_subnet_group_name): <p>The name of the DB subnet group to use for the new DB cluster.</p>  <p>Constraints: If supplied, must match the name of an existing DB subnet group.</p>  <p>Example: <code>mydbsubnetgroup</code> </p>  <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
    ///   - [`database_name(impl Into<String>)`](crate::client::fluent_builders::RestoreDBClusterFromSnapshot::database_name) / [`set_database_name(Option<String>)`](crate::client::fluent_builders::RestoreDBClusterFromSnapshot::set_database_name): <p>The database name for the restored DB cluster.</p>  <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
    ///   - [`option_group_name(impl Into<String>)`](crate::client::fluent_builders::RestoreDBClusterFromSnapshot::option_group_name) / [`set_option_group_name(Option<String>)`](crate::client::fluent_builders::RestoreDBClusterFromSnapshot::set_option_group_name): <p>The name of the option group to use for the restored DB cluster.</p>  <p>DB clusters are associated with a default option group that can't be modified.</p>
    ///   - [`vpc_security_group_ids(Vec<String>)`](crate::client::fluent_builders::RestoreDBClusterFromSnapshot::vpc_security_group_ids) / [`set_vpc_security_group_ids(Option<Vec<String>>)`](crate::client::fluent_builders::RestoreDBClusterFromSnapshot::set_vpc_security_group_ids): <p>A list of VPC security groups that the new DB cluster will belong to.</p>  <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::RestoreDBClusterFromSnapshot::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::RestoreDBClusterFromSnapshot::set_tags): <p>The tags to be assigned to the restored DB cluster.</p>  <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
    ///   - [`kms_key_id(impl Into<String>)`](crate::client::fluent_builders::RestoreDBClusterFromSnapshot::kms_key_id) / [`set_kms_key_id(Option<String>)`](crate::client::fluent_builders::RestoreDBClusterFromSnapshot::set_kms_key_id): <p>The Amazon Web Services KMS key identifier to use when restoring an encrypted DB cluster from a DB snapshot or DB cluster snapshot.</p>  <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key. To use a KMS key in a different Amazon Web Services account, specify the key ARN or alias ARN.</p>  <p>When you don't specify a value for the <code>KmsKeyId</code> parameter, then the following occurs:</p>  <ul>   <li> <p>If the DB snapshot or DB cluster snapshot in <code>SnapshotIdentifier</code> is encrypted, then the restored DB cluster is encrypted using the KMS key that was used to encrypt the DB snapshot or DB cluster snapshot.</p> </li>   <li> <p>If the DB snapshot or DB cluster snapshot in <code>SnapshotIdentifier</code> isn't encrypted, then the restored DB cluster isn't encrypted.</p> </li>  </ul>  <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
    ///   - [`enable_iam_database_authentication(bool)`](crate::client::fluent_builders::RestoreDBClusterFromSnapshot::enable_iam_database_authentication) / [`set_enable_iam_database_authentication(Option<bool>)`](crate::client::fluent_builders::RestoreDBClusterFromSnapshot::set_enable_iam_database_authentication): <p>A value that indicates whether to enable mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts. By default, mapping isn't enabled.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.IAMDBAuth.html"> IAM Database Authentication</a> in the <i>Amazon Aurora User Guide</i>.</p>  <p>Valid for: Aurora DB clusters only</p>
    ///   - [`backtrack_window(i64)`](crate::client::fluent_builders::RestoreDBClusterFromSnapshot::backtrack_window) / [`set_backtrack_window(Option<i64>)`](crate::client::fluent_builders::RestoreDBClusterFromSnapshot::set_backtrack_window): <p>The target backtrack window, in seconds. To disable backtracking, set this value to 0.</p> <note>   <p>Currently, Backtrack is only supported for Aurora MySQL DB clusters.</p>  </note>  <p>Default: 0</p>  <p>Constraints:</p>  <ul>   <li> <p>If specified, this value must be set to a number from 0 to 259,200 (72 hours).</p> </li>  </ul>  <p>Valid for: Aurora DB clusters only</p>
    ///   - [`enable_cloudwatch_logs_exports(Vec<String>)`](crate::client::fluent_builders::RestoreDBClusterFromSnapshot::enable_cloudwatch_logs_exports) / [`set_enable_cloudwatch_logs_exports(Option<Vec<String>>)`](crate::client::fluent_builders::RestoreDBClusterFromSnapshot::set_enable_cloudwatch_logs_exports): <p>The list of logs that the restored DB cluster is to export to Amazon CloudWatch Logs. The values in the list depend on the DB engine being used.</p>  <p> <b>RDS for MySQL</b> </p>  <p>Possible values are <code>error</code>, <code>general</code>, and <code>slowquery</code>.</p>  <p> <b>RDS for PostgreSQL</b> </p>  <p>Possible values are <code>postgresql</code> and <code>upgrade</code>.</p>  <p> <b>Aurora MySQL</b> </p>  <p>Possible values are <code>audit</code>, <code>error</code>, <code>general</code>, and <code>slowquery</code>.</p>  <p> <b>Aurora PostgreSQL</b> </p>  <p>Possible value is <code>postgresql</code>.</p>  <p>For more information about exporting CloudWatch Logs for Amazon RDS, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch">Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon RDS User Guide.</i>.</p>  <p>For more information about exporting CloudWatch Logs for Amazon Aurora, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch">Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon Aurora User Guide</i>.</p>  <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
    ///   - [`engine_mode(impl Into<String>)`](crate::client::fluent_builders::RestoreDBClusterFromSnapshot::engine_mode) / [`set_engine_mode(Option<String>)`](crate::client::fluent_builders::RestoreDBClusterFromSnapshot::set_engine_mode): <p>The DB engine mode of the DB cluster, either <code>provisioned</code>, <code>serverless</code>, <code>parallelquery</code>, <code>global</code>, or <code>multimaster</code>.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBCluster.html"> CreateDBCluster</a>.</p>  <p>Valid for: Aurora DB clusters only</p>
    ///   - [`scaling_configuration(ScalingConfiguration)`](crate::client::fluent_builders::RestoreDBClusterFromSnapshot::scaling_configuration) / [`set_scaling_configuration(Option<ScalingConfiguration>)`](crate::client::fluent_builders::RestoreDBClusterFromSnapshot::set_scaling_configuration): <p>For DB clusters in <code>serverless</code> DB engine mode, the scaling properties of the DB cluster.</p>  <p>Valid for: Aurora DB clusters only</p>
    ///   - [`db_cluster_parameter_group_name(impl Into<String>)`](crate::client::fluent_builders::RestoreDBClusterFromSnapshot::db_cluster_parameter_group_name) / [`set_db_cluster_parameter_group_name(Option<String>)`](crate::client::fluent_builders::RestoreDBClusterFromSnapshot::set_db_cluster_parameter_group_name): <p>The name of the DB cluster parameter group to associate with this DB cluster. If this argument is omitted, the default DB cluster parameter group for the specified engine is used.</p>  <p>Constraints:</p>  <ul>   <li> <p>If supplied, must match the name of an existing default DB cluster parameter group.</p> </li>   <li> <p>Must be 1 to 255 letters, numbers, or hyphens.</p> </li>   <li> <p>First character must be a letter.</p> </li>   <li> <p>Can't end with a hyphen or contain two consecutive hyphens.</p> </li>  </ul>  <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
    ///   - [`deletion_protection(bool)`](crate::client::fluent_builders::RestoreDBClusterFromSnapshot::deletion_protection) / [`set_deletion_protection(Option<bool>)`](crate::client::fluent_builders::RestoreDBClusterFromSnapshot::set_deletion_protection): <p>A value that indicates whether the DB cluster has deletion protection enabled. The database can't be deleted when deletion protection is enabled. By default, deletion protection isn't enabled.</p>  <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
    ///   - [`copy_tags_to_snapshot(bool)`](crate::client::fluent_builders::RestoreDBClusterFromSnapshot::copy_tags_to_snapshot) / [`set_copy_tags_to_snapshot(Option<bool>)`](crate::client::fluent_builders::RestoreDBClusterFromSnapshot::set_copy_tags_to_snapshot): <p>A value that indicates whether to copy all tags from the restored DB cluster to snapshots of the restored DB cluster. The default is not to copy them.</p>  <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
    ///   - [`domain(impl Into<String>)`](crate::client::fluent_builders::RestoreDBClusterFromSnapshot::domain) / [`set_domain(Option<String>)`](crate::client::fluent_builders::RestoreDBClusterFromSnapshot::set_domain): <p>Specify the Active Directory directory ID to restore the DB cluster in. The domain must be created prior to this operation. Currently, only MySQL, Microsoft SQL Server, Oracle, and PostgreSQL DB instances can be created in an Active Directory Domain.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/kerberos-authentication.html"> Kerberos Authentication</a> in the <i>Amazon RDS User Guide</i>.</p>  <p>Valid for: Aurora DB clusters only</p>
    ///   - [`domain_iam_role_name(impl Into<String>)`](crate::client::fluent_builders::RestoreDBClusterFromSnapshot::domain_iam_role_name) / [`set_domain_iam_role_name(Option<String>)`](crate::client::fluent_builders::RestoreDBClusterFromSnapshot::set_domain_iam_role_name): <p>Specify the name of the IAM role to be used when making API calls to the Directory Service.</p>  <p>Valid for: Aurora DB clusters only</p>
    ///   - [`db_cluster_instance_class(impl Into<String>)`](crate::client::fluent_builders::RestoreDBClusterFromSnapshot::db_cluster_instance_class) / [`set_db_cluster_instance_class(Option<String>)`](crate::client::fluent_builders::RestoreDBClusterFromSnapshot::set_db_cluster_instance_class): <p>The compute and memory capacity of the each DB instance in the Multi-AZ DB cluster, for example db.m6g.xlarge. Not all DB instance classes are available in all Amazon Web Services Regions, or for all database engines.</p>  <p>For the full list of DB instance classes, and availability for your engine, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html">DB Instance Class</a> in the <i>Amazon RDS User Guide.</i> </p>  <p>Valid for: Multi-AZ DB clusters only</p>
    ///   - [`storage_type(impl Into<String>)`](crate::client::fluent_builders::RestoreDBClusterFromSnapshot::storage_type) / [`set_storage_type(Option<String>)`](crate::client::fluent_builders::RestoreDBClusterFromSnapshot::set_storage_type): <p>Specifies the storage type to be associated with the each DB instance in the Multi-AZ DB cluster.</p>  <p>Valid values: <code>io1</code> </p>  <p>When specified, a value for the <code>Iops</code> parameter is required.</p>  <p>Default: <code>io1</code> </p>  <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
    ///   - [`iops(i32)`](crate::client::fluent_builders::RestoreDBClusterFromSnapshot::iops) / [`set_iops(Option<i32>)`](crate::client::fluent_builders::RestoreDBClusterFromSnapshot::set_iops): <p>The amount of Provisioned IOPS (input/output operations per second) to be initially allocated for each DB instance in the Multi-AZ DB cluster.</p>  <p>For information about valid Iops values, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#USER_PIOPS">Amazon RDS Provisioned IOPS Storage to Improve Performance</a> in the <i>Amazon RDS User Guide</i>.</p>  <p>Constraints: Must be a multiple between .5 and 50 of the storage amount for the DB instance.</p>  <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
    ///   - [`publicly_accessible(bool)`](crate::client::fluent_builders::RestoreDBClusterFromSnapshot::publicly_accessible) / [`set_publicly_accessible(Option<bool>)`](crate::client::fluent_builders::RestoreDBClusterFromSnapshot::set_publicly_accessible): <p>A value that indicates whether the DB cluster is publicly accessible.</p>  <p>When the DB cluster is publicly accessible, its Domain Name System (DNS) endpoint resolves to the private IP address from within the DB cluster's virtual private cloud (VPC). It resolves to the public IP address from outside of the DB cluster's VPC. Access to the DB cluster is ultimately controlled by the security group it uses. That public access is not permitted if the security group assigned to the DB cluster doesn't permit it.</p>  <p>When the DB cluster isn't publicly accessible, it is an internal DB cluster with a DNS name that resolves to a private IP address.</p>  <p>Default: The default behavior varies depending on whether <code>DBSubnetGroupName</code> is specified.</p>  <p>If <code>DBSubnetGroupName</code> isn't specified, and <code>PubliclyAccessible</code> isn't specified, the following applies:</p>  <ul>   <li> <p>If the default VPC in the target Region doesn’t have an internet gateway attached to it, the DB cluster is private.</p> </li>   <li> <p>If the default VPC in the target Region has an internet gateway attached to it, the DB cluster is public.</p> </li>  </ul>  <p>If <code>DBSubnetGroupName</code> is specified, and <code>PubliclyAccessible</code> isn't specified, the following applies:</p>  <ul>   <li> <p>If the subnets are part of a VPC that doesn’t have an internet gateway attached to it, the DB cluster is private.</p> </li>   <li> <p>If the subnets are part of a VPC that has an internet gateway attached to it, the DB cluster is public.</p> </li>  </ul>  <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
    ///   - [`serverless_v2_scaling_configuration(ServerlessV2ScalingConfiguration)`](crate::client::fluent_builders::RestoreDBClusterFromSnapshot::serverless_v2_scaling_configuration) / [`set_serverless_v2_scaling_configuration(Option<ServerlessV2ScalingConfiguration>)`](crate::client::fluent_builders::RestoreDBClusterFromSnapshot::set_serverless_v2_scaling_configuration): <p>Contains the scaling configuration of an Aurora Serverless v2 DB cluster.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless-v2.html">Using Amazon Aurora Serverless v2</a> in the <i>Amazon Aurora User Guide</i>.</p>
    /// - On success, responds with [`RestoreDbClusterFromSnapshotOutput`](crate::output::RestoreDbClusterFromSnapshotOutput) with field(s):
    ///   - [`db_cluster(Option<DbCluster>)`](crate::output::RestoreDbClusterFromSnapshotOutput::db_cluster): <p>Contains the details of an Amazon Aurora DB cluster or Multi-AZ DB cluster.</p>  <p>For an Amazon Aurora DB cluster, this data type is used as a response element in the operations <code>CreateDBCluster</code>, <code>DeleteDBCluster</code>, <code>DescribeDBClusters</code>, <code>FailoverDBCluster</code>, <code>ModifyDBCluster</code>, <code>PromoteReadReplicaDBCluster</code>, <code>RestoreDBClusterFromS3</code>, <code>RestoreDBClusterFromSnapshot</code>, <code>RestoreDBClusterToPointInTime</code>, <code>StartDBCluster</code>, and <code>StopDBCluster</code>.</p>  <p>For a Multi-AZ DB cluster, this data type is used as a response element in the operations <code>CreateDBCluster</code>, <code>DeleteDBCluster</code>, <code>DescribeDBClusters</code>, <code>FailoverDBCluster</code>, <code>ModifyDBCluster</code>, <code>RebootDBCluster</code>, <code>RestoreDBClusterFromSnapshot</code>, and <code>RestoreDBClusterToPointInTime</code>.</p>  <p>For more information on Amazon Aurora DB clusters, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon Aurora?</a> in the <i>Amazon Aurora User Guide.</i> </p>  <p>For more information on Multi-AZ DB clusters, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ deployments with two readable standby DB instances</a> in the <i>Amazon RDS User Guide.</i> </p>
    /// - On failure, responds with [`SdkError<RestoreDBClusterFromSnapshotError>`](crate::error::RestoreDBClusterFromSnapshotError)
    pub fn restore_db_cluster_from_snapshot(
        &self,
    ) -> fluent_builders::RestoreDBClusterFromSnapshot {
        fluent_builders::RestoreDBClusterFromSnapshot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RestoreDBClusterToPointInTime`](crate::client::fluent_builders::RestoreDBClusterToPointInTime) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_cluster_identifier(impl Into<String>)`](crate::client::fluent_builders::RestoreDBClusterToPointInTime::db_cluster_identifier) / [`set_db_cluster_identifier(Option<String>)`](crate::client::fluent_builders::RestoreDBClusterToPointInTime::set_db_cluster_identifier): <p>The name of the new DB cluster to be created.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must contain from 1 to 63 letters, numbers, or hyphens</p> </li>   <li> <p>First character must be a letter</p> </li>   <li> <p>Can't end with a hyphen or contain two consecutive hyphens</p> </li>  </ul>  <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
    ///   - [`restore_type(impl Into<String>)`](crate::client::fluent_builders::RestoreDBClusterToPointInTime::restore_type) / [`set_restore_type(Option<String>)`](crate::client::fluent_builders::RestoreDBClusterToPointInTime::set_restore_type): <p>The type of restore to be performed. You can specify one of the following values:</p>  <ul>   <li> <p> <code>full-copy</code> - The new DB cluster is restored as a full copy of the source DB cluster.</p> </li>   <li> <p> <code>copy-on-write</code> - The new DB cluster is restored as a clone of the source DB cluster.</p> </li>  </ul>  <p>Constraints: You can't specify <code>copy-on-write</code> if the engine version of the source DB cluster is earlier than 1.11.</p>  <p>If you don't specify a <code>RestoreType</code> value, then the new DB cluster is restored as a full copy of the source DB cluster.</p>  <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
    ///   - [`source_db_cluster_identifier(impl Into<String>)`](crate::client::fluent_builders::RestoreDBClusterToPointInTime::source_db_cluster_identifier) / [`set_source_db_cluster_identifier(Option<String>)`](crate::client::fluent_builders::RestoreDBClusterToPointInTime::set_source_db_cluster_identifier): <p>The identifier of the source DB cluster from which to restore.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must match the identifier of an existing DBCluster.</p> </li>  </ul>  <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
    ///   - [`restore_to_time(DateTime)`](crate::client::fluent_builders::RestoreDBClusterToPointInTime::restore_to_time) / [`set_restore_to_time(Option<DateTime>)`](crate::client::fluent_builders::RestoreDBClusterToPointInTime::set_restore_to_time): <p>The date and time to restore the DB cluster to.</p>  <p>Valid Values: Value must be a time in Universal Coordinated Time (UTC) format</p>  <p>Constraints:</p>  <ul>   <li> <p>Must be before the latest restorable time for the DB instance</p> </li>   <li> <p>Must be specified if <code>UseLatestRestorableTime</code> parameter isn't provided</p> </li>   <li> <p>Can't be specified if the <code>UseLatestRestorableTime</code> parameter is enabled</p> </li>   <li> <p>Can't be specified if the <code>RestoreType</code> parameter is <code>copy-on-write</code> </p> </li>  </ul>  <p>Example: <code>2015-03-07T23:45:00Z</code> </p>  <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
    ///   - [`use_latest_restorable_time(bool)`](crate::client::fluent_builders::RestoreDBClusterToPointInTime::use_latest_restorable_time) / [`set_use_latest_restorable_time(bool)`](crate::client::fluent_builders::RestoreDBClusterToPointInTime::set_use_latest_restorable_time): <p>A value that indicates whether to restore the DB cluster to the latest restorable backup time. By default, the DB cluster isn't restored to the latest restorable backup time.</p>  <p>Constraints: Can't be specified if <code>RestoreToTime</code> parameter is provided.</p>  <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
    ///   - [`port(i32)`](crate::client::fluent_builders::RestoreDBClusterToPointInTime::port) / [`set_port(Option<i32>)`](crate::client::fluent_builders::RestoreDBClusterToPointInTime::set_port): <p>The port number on which the new DB cluster accepts connections.</p>  <p>Constraints: A value from <code>1150-65535</code>.</p>  <p>Default: The default port for the engine.</p>  <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
    ///   - [`db_subnet_group_name(impl Into<String>)`](crate::client::fluent_builders::RestoreDBClusterToPointInTime::db_subnet_group_name) / [`set_db_subnet_group_name(Option<String>)`](crate::client::fluent_builders::RestoreDBClusterToPointInTime::set_db_subnet_group_name): <p>The DB subnet group name to use for the new DB cluster.</p>  <p>Constraints: If supplied, must match the name of an existing DBSubnetGroup.</p>  <p>Example: <code>mydbsubnetgroup</code> </p>  <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
    ///   - [`option_group_name(impl Into<String>)`](crate::client::fluent_builders::RestoreDBClusterToPointInTime::option_group_name) / [`set_option_group_name(Option<String>)`](crate::client::fluent_builders::RestoreDBClusterToPointInTime::set_option_group_name): <p>The name of the option group for the new DB cluster.</p>  <p>DB clusters are associated with a default option group that can't be modified.</p>
    ///   - [`vpc_security_group_ids(Vec<String>)`](crate::client::fluent_builders::RestoreDBClusterToPointInTime::vpc_security_group_ids) / [`set_vpc_security_group_ids(Option<Vec<String>>)`](crate::client::fluent_builders::RestoreDBClusterToPointInTime::set_vpc_security_group_ids): <p>A list of VPC security groups that the new DB cluster belongs to.</p>  <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::RestoreDBClusterToPointInTime::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::RestoreDBClusterToPointInTime::set_tags): <p>A list of tags. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources</a> in the <i>Amazon RDS User Guide.</i> </p>
    ///   - [`kms_key_id(impl Into<String>)`](crate::client::fluent_builders::RestoreDBClusterToPointInTime::kms_key_id) / [`set_kms_key_id(Option<String>)`](crate::client::fluent_builders::RestoreDBClusterToPointInTime::set_kms_key_id): <p>The Amazon Web Services KMS key identifier to use when restoring an encrypted DB cluster from an encrypted DB cluster.</p>  <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key. To use a KMS key in a different Amazon Web Services account, specify the key ARN or alias ARN.</p>  <p>You can restore to a new DB cluster and encrypt the new DB cluster with a KMS key that is different from the KMS key used to encrypt the source DB cluster. The new DB cluster is encrypted with the KMS key identified by the <code>KmsKeyId</code> parameter.</p>  <p>If you don't specify a value for the <code>KmsKeyId</code> parameter, then the following occurs:</p>  <ul>   <li> <p>If the DB cluster is encrypted, then the restored DB cluster is encrypted using the KMS key that was used to encrypt the source DB cluster.</p> </li>   <li> <p>If the DB cluster isn't encrypted, then the restored DB cluster isn't encrypted.</p> </li>  </ul>  <p>If <code>DBClusterIdentifier</code> refers to a DB cluster that isn't encrypted, then the restore request is rejected.</p>  <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
    ///   - [`enable_iam_database_authentication(bool)`](crate::client::fluent_builders::RestoreDBClusterToPointInTime::enable_iam_database_authentication) / [`set_enable_iam_database_authentication(Option<bool>)`](crate::client::fluent_builders::RestoreDBClusterToPointInTime::set_enable_iam_database_authentication): <p>A value that indicates whether to enable mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts. By default, mapping isn't enabled.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.IAMDBAuth.html"> IAM Database Authentication</a> in the <i>Amazon Aurora User Guide</i>.</p>  <p>Valid for: Aurora DB clusters only</p>
    ///   - [`backtrack_window(i64)`](crate::client::fluent_builders::RestoreDBClusterToPointInTime::backtrack_window) / [`set_backtrack_window(Option<i64>)`](crate::client::fluent_builders::RestoreDBClusterToPointInTime::set_backtrack_window): <p>The target backtrack window, in seconds. To disable backtracking, set this value to 0.</p>  <p>Default: 0</p>  <p>Constraints:</p>  <ul>   <li> <p>If specified, this value must be set to a number from 0 to 259,200 (72 hours).</p> </li>  </ul>  <p>Valid for: Aurora MySQL DB clusters only</p>
    ///   - [`enable_cloudwatch_logs_exports(Vec<String>)`](crate::client::fluent_builders::RestoreDBClusterToPointInTime::enable_cloudwatch_logs_exports) / [`set_enable_cloudwatch_logs_exports(Option<Vec<String>>)`](crate::client::fluent_builders::RestoreDBClusterToPointInTime::set_enable_cloudwatch_logs_exports): <p>The list of logs that the restored DB cluster is to export to CloudWatch Logs. The values in the list depend on the DB engine being used.</p>  <p> <b>RDS for MySQL</b> </p>  <p>Possible values are <code>error</code>, <code>general</code>, and <code>slowquery</code>.</p>  <p> <b>RDS for PostgreSQL</b> </p>  <p>Possible values are <code>postgresql</code> and <code>upgrade</code>.</p>  <p> <b>Aurora MySQL</b> </p>  <p>Possible values are <code>audit</code>, <code>error</code>, <code>general</code>, and <code>slowquery</code>.</p>  <p> <b>Aurora PostgreSQL</b> </p>  <p>Possible value is <code>postgresql</code>.</p>  <p>For more information about exporting CloudWatch Logs for Amazon RDS, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch">Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon RDS User Guide.</i>.</p>  <p>For more information about exporting CloudWatch Logs for Amazon Aurora, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch">Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon Aurora User Guide</i>.</p>  <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
    ///   - [`db_cluster_parameter_group_name(impl Into<String>)`](crate::client::fluent_builders::RestoreDBClusterToPointInTime::db_cluster_parameter_group_name) / [`set_db_cluster_parameter_group_name(Option<String>)`](crate::client::fluent_builders::RestoreDBClusterToPointInTime::set_db_cluster_parameter_group_name): <p>The name of the DB cluster parameter group to associate with this DB cluster. If this argument is omitted, the default DB cluster parameter group for the specified engine is used.</p>  <p>Constraints:</p>  <ul>   <li> <p>If supplied, must match the name of an existing DB cluster parameter group.</p> </li>   <li> <p>Must be 1 to 255 letters, numbers, or hyphens.</p> </li>   <li> <p>First character must be a letter.</p> </li>   <li> <p>Can't end with a hyphen or contain two consecutive hyphens.</p> </li>  </ul>  <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
    ///   - [`deletion_protection(bool)`](crate::client::fluent_builders::RestoreDBClusterToPointInTime::deletion_protection) / [`set_deletion_protection(Option<bool>)`](crate::client::fluent_builders::RestoreDBClusterToPointInTime::set_deletion_protection): <p>A value that indicates whether the DB cluster has deletion protection enabled. The database can't be deleted when deletion protection is enabled. By default, deletion protection isn't enabled.</p>  <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
    ///   - [`copy_tags_to_snapshot(bool)`](crate::client::fluent_builders::RestoreDBClusterToPointInTime::copy_tags_to_snapshot) / [`set_copy_tags_to_snapshot(Option<bool>)`](crate::client::fluent_builders::RestoreDBClusterToPointInTime::set_copy_tags_to_snapshot): <p>A value that indicates whether to copy all tags from the restored DB cluster to snapshots of the restored DB cluster. The default is not to copy them.</p>  <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
    ///   - [`domain(impl Into<String>)`](crate::client::fluent_builders::RestoreDBClusterToPointInTime::domain) / [`set_domain(Option<String>)`](crate::client::fluent_builders::RestoreDBClusterToPointInTime::set_domain): <p>Specify the Active Directory directory ID to restore the DB cluster in. The domain must be created prior to this operation.</p>  <p>For Amazon Aurora DB clusters, Amazon RDS can use Kerberos Authentication to authenticate users that connect to the DB cluster. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/kerberos-authentication.html">Kerberos Authentication</a> in the <i>Amazon Aurora User Guide</i>.</p>  <p>Valid for: Aurora DB clusters only</p>
    ///   - [`domain_iam_role_name(impl Into<String>)`](crate::client::fluent_builders::RestoreDBClusterToPointInTime::domain_iam_role_name) / [`set_domain_iam_role_name(Option<String>)`](crate::client::fluent_builders::RestoreDBClusterToPointInTime::set_domain_iam_role_name): <p>Specify the name of the IAM role to be used when making API calls to the Directory Service.</p>  <p>Valid for: Aurora DB clusters only</p>
    ///   - [`scaling_configuration(ScalingConfiguration)`](crate::client::fluent_builders::RestoreDBClusterToPointInTime::scaling_configuration) / [`set_scaling_configuration(Option<ScalingConfiguration>)`](crate::client::fluent_builders::RestoreDBClusterToPointInTime::set_scaling_configuration): <p>For DB clusters in <code>serverless</code> DB engine mode, the scaling properties of the DB cluster.</p>  <p>Valid for: Aurora DB clusters only</p>
    ///   - [`engine_mode(impl Into<String>)`](crate::client::fluent_builders::RestoreDBClusterToPointInTime::engine_mode) / [`set_engine_mode(Option<String>)`](crate::client::fluent_builders::RestoreDBClusterToPointInTime::set_engine_mode): <p>The engine mode of the new cluster. Specify <code>provisioned</code> or <code>serverless</code>, depending on the type of the cluster you are creating. You can create an Aurora Serverless v1 clone from a provisioned cluster, or a provisioned clone from an Aurora Serverless v1 cluster. To create a clone that is an Aurora Serverless v1 cluster, the original cluster must be an Aurora Serverless v1 cluster or an encrypted provisioned cluster.</p>  <p>Valid for: Aurora DB clusters only</p>
    ///   - [`db_cluster_instance_class(impl Into<String>)`](crate::client::fluent_builders::RestoreDBClusterToPointInTime::db_cluster_instance_class) / [`set_db_cluster_instance_class(Option<String>)`](crate::client::fluent_builders::RestoreDBClusterToPointInTime::set_db_cluster_instance_class): <p>The compute and memory capacity of the each DB instance in the Multi-AZ DB cluster, for example db.m6g.xlarge. Not all DB instance classes are available in all Amazon Web Services Regions, or for all database engines.</p>  <p>For the full list of DB instance classes, and availability for your engine, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html">DB instance class</a> in the <i>Amazon RDS User Guide.</i> </p>  <p>Valid for: Multi-AZ DB clusters only</p>
    ///   - [`storage_type(impl Into<String>)`](crate::client::fluent_builders::RestoreDBClusterToPointInTime::storage_type) / [`set_storage_type(Option<String>)`](crate::client::fluent_builders::RestoreDBClusterToPointInTime::set_storage_type): <p>Specifies the storage type to be associated with the each DB instance in the Multi-AZ DB cluster.</p>  <p>Valid values: <code>io1</code> </p>  <p>When specified, a value for the <code>Iops</code> parameter is required.</p>  <p>Default: <code>io1</code> </p>  <p>Valid for: Multi-AZ DB clusters only</p>
    ///   - [`publicly_accessible(bool)`](crate::client::fluent_builders::RestoreDBClusterToPointInTime::publicly_accessible) / [`set_publicly_accessible(Option<bool>)`](crate::client::fluent_builders::RestoreDBClusterToPointInTime::set_publicly_accessible): <p>A value that indicates whether the DB cluster is publicly accessible.</p>  <p>When the DB cluster is publicly accessible, its Domain Name System (DNS) endpoint resolves to the private IP address from within the DB cluster's virtual private cloud (VPC). It resolves to the public IP address from outside of the DB cluster's VPC. Access to the DB cluster is ultimately controlled by the security group it uses. That public access is not permitted if the security group assigned to the DB cluster doesn't permit it.</p>  <p>When the DB cluster isn't publicly accessible, it is an internal DB cluster with a DNS name that resolves to a private IP address.</p>  <p>Default: The default behavior varies depending on whether <code>DBSubnetGroupName</code> is specified.</p>  <p>If <code>DBSubnetGroupName</code> isn't specified, and <code>PubliclyAccessible</code> isn't specified, the following applies:</p>  <ul>   <li> <p>If the default VPC in the target Region doesn’t have an internet gateway attached to it, the DB cluster is private.</p> </li>   <li> <p>If the default VPC in the target Region has an internet gateway attached to it, the DB cluster is public.</p> </li>  </ul>  <p>If <code>DBSubnetGroupName</code> is specified, and <code>PubliclyAccessible</code> isn't specified, the following applies:</p>  <ul>   <li> <p>If the subnets are part of a VPC that doesn’t have an internet gateway attached to it, the DB cluster is private.</p> </li>   <li> <p>If the subnets are part of a VPC that has an internet gateway attached to it, the DB cluster is public.</p> </li>  </ul>  <p>Valid for: Multi-AZ DB clusters only</p>
    ///   - [`iops(i32)`](crate::client::fluent_builders::RestoreDBClusterToPointInTime::iops) / [`set_iops(Option<i32>)`](crate::client::fluent_builders::RestoreDBClusterToPointInTime::set_iops): <p>The amount of Provisioned IOPS (input/output operations per second) to be initially allocated for each DB instance in the Multi-AZ DB cluster.</p>  <p>For information about valid <code>Iops</code> values, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#USER_PIOPS">Amazon RDS Provisioned IOPS storage to improve performance</a> in the <i>Amazon RDS User Guide</i>.</p>  <p>Constraints: Must be a multiple between .5 and 50 of the storage amount for the DB instance.</p>  <p>Valid for: Multi-AZ DB clusters only</p>
    ///   - [`serverless_v2_scaling_configuration(ServerlessV2ScalingConfiguration)`](crate::client::fluent_builders::RestoreDBClusterToPointInTime::serverless_v2_scaling_configuration) / [`set_serverless_v2_scaling_configuration(Option<ServerlessV2ScalingConfiguration>)`](crate::client::fluent_builders::RestoreDBClusterToPointInTime::set_serverless_v2_scaling_configuration): <p>Contains the scaling configuration of an Aurora Serverless v2 DB cluster.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless-v2.html">Using Amazon Aurora Serverless v2</a> in the <i>Amazon Aurora User Guide</i>.</p>
    /// - On success, responds with [`RestoreDbClusterToPointInTimeOutput`](crate::output::RestoreDbClusterToPointInTimeOutput) with field(s):
    ///   - [`db_cluster(Option<DbCluster>)`](crate::output::RestoreDbClusterToPointInTimeOutput::db_cluster): <p>Contains the details of an Amazon Aurora DB cluster or Multi-AZ DB cluster.</p>  <p>For an Amazon Aurora DB cluster, this data type is used as a response element in the operations <code>CreateDBCluster</code>, <code>DeleteDBCluster</code>, <code>DescribeDBClusters</code>, <code>FailoverDBCluster</code>, <code>ModifyDBCluster</code>, <code>PromoteReadReplicaDBCluster</code>, <code>RestoreDBClusterFromS3</code>, <code>RestoreDBClusterFromSnapshot</code>, <code>RestoreDBClusterToPointInTime</code>, <code>StartDBCluster</code>, and <code>StopDBCluster</code>.</p>  <p>For a Multi-AZ DB cluster, this data type is used as a response element in the operations <code>CreateDBCluster</code>, <code>DeleteDBCluster</code>, <code>DescribeDBClusters</code>, <code>FailoverDBCluster</code>, <code>ModifyDBCluster</code>, <code>RebootDBCluster</code>, <code>RestoreDBClusterFromSnapshot</code>, and <code>RestoreDBClusterToPointInTime</code>.</p>  <p>For more information on Amazon Aurora DB clusters, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon Aurora?</a> in the <i>Amazon Aurora User Guide.</i> </p>  <p>For more information on Multi-AZ DB clusters, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ deployments with two readable standby DB instances</a> in the <i>Amazon RDS User Guide.</i> </p>
    /// - On failure, responds with [`SdkError<RestoreDBClusterToPointInTimeError>`](crate::error::RestoreDBClusterToPointInTimeError)
    pub fn restore_db_cluster_to_point_in_time(
        &self,
    ) -> fluent_builders::RestoreDBClusterToPointInTime {
        fluent_builders::RestoreDBClusterToPointInTime::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RestoreDBInstanceFromDBSnapshot`](crate::client::fluent_builders::RestoreDBInstanceFromDBSnapshot) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_instance_identifier(impl Into<String>)`](crate::client::fluent_builders::RestoreDBInstanceFromDBSnapshot::db_instance_identifier) / [`set_db_instance_identifier(Option<String>)`](crate::client::fluent_builders::RestoreDBInstanceFromDBSnapshot::set_db_instance_identifier): <p>Name of the DB instance to create from the DB snapshot. This parameter isn't case-sensitive.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must contain from 1 to 63 numbers, letters, or hyphens</p> </li>   <li> <p>First character must be a letter</p> </li>   <li> <p>Can't end with a hyphen or contain two consecutive hyphens</p> </li>  </ul>  <p>Example: <code>my-snapshot-id</code> </p>
    ///   - [`db_snapshot_identifier(impl Into<String>)`](crate::client::fluent_builders::RestoreDBInstanceFromDBSnapshot::db_snapshot_identifier) / [`set_db_snapshot_identifier(Option<String>)`](crate::client::fluent_builders::RestoreDBInstanceFromDBSnapshot::set_db_snapshot_identifier): <p>The identifier for the DB snapshot to restore from.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must match the identifier of an existing DBSnapshot.</p> </li>   <li> <p>If you are restoring from a shared manual DB snapshot, the <code>DBSnapshotIdentifier</code> must be the ARN of the shared DB snapshot.</p> </li>  </ul>
    ///   - [`db_instance_class(impl Into<String>)`](crate::client::fluent_builders::RestoreDBInstanceFromDBSnapshot::db_instance_class) / [`set_db_instance_class(Option<String>)`](crate::client::fluent_builders::RestoreDBInstanceFromDBSnapshot::set_db_instance_class): <p>The compute and memory capacity of the Amazon RDS DB instance, for example db.m4.large. Not all DB instance classes are available in all Amazon Web Services Regions, or for all database engines. For the full list of DB instance classes, and availability for your engine, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html">DB Instance Class</a> in the <i>Amazon RDS User Guide.</i> </p>  <p>Default: The same DBInstanceClass as the original DB instance.</p>
    ///   - [`port(i32)`](crate::client::fluent_builders::RestoreDBInstanceFromDBSnapshot::port) / [`set_port(Option<i32>)`](crate::client::fluent_builders::RestoreDBInstanceFromDBSnapshot::set_port): <p>The port number on which the database accepts connections.</p>  <p>Default: The same port as the original DB instance</p>  <p>Constraints: Value must be <code>1150-65535</code> </p>
    ///   - [`availability_zone(impl Into<String>)`](crate::client::fluent_builders::RestoreDBInstanceFromDBSnapshot::availability_zone) / [`set_availability_zone(Option<String>)`](crate::client::fluent_builders::RestoreDBInstanceFromDBSnapshot::set_availability_zone): <p>The Availability Zone (AZ) where the DB instance will be created.</p>  <p>Default: A random, system-chosen Availability Zone.</p>  <p>Constraint: You can't specify the <code>AvailabilityZone</code> parameter if the DB instance is a Multi-AZ deployment.</p>  <p>Example: <code>us-east-1a</code> </p>
    ///   - [`db_subnet_group_name(impl Into<String>)`](crate::client::fluent_builders::RestoreDBInstanceFromDBSnapshot::db_subnet_group_name) / [`set_db_subnet_group_name(Option<String>)`](crate::client::fluent_builders::RestoreDBInstanceFromDBSnapshot::set_db_subnet_group_name): <p>The DB subnet group name to use for the new instance.</p>  <p>Constraints: If supplied, must match the name of an existing DBSubnetGroup.</p>  <p>Example: <code>mydbsubnetgroup</code> </p>
    ///   - [`multi_az(bool)`](crate::client::fluent_builders::RestoreDBInstanceFromDBSnapshot::multi_az) / [`set_multi_az(Option<bool>)`](crate::client::fluent_builders::RestoreDBInstanceFromDBSnapshot::set_multi_az): <p>A value that indicates whether the DB instance is a Multi-AZ deployment.</p>  <p>This setting doesn't apply to RDS Custom.</p>  <p>Constraint: You can't specify the <code>AvailabilityZone</code> parameter if the DB instance is a Multi-AZ deployment.</p>
    ///   - [`publicly_accessible(bool)`](crate::client::fluent_builders::RestoreDBInstanceFromDBSnapshot::publicly_accessible) / [`set_publicly_accessible(Option<bool>)`](crate::client::fluent_builders::RestoreDBInstanceFromDBSnapshot::set_publicly_accessible): <p>A value that indicates whether the DB instance is publicly accessible.</p>  <p>When the DB instance is publicly accessible, its Domain Name System (DNS) endpoint resolves to the private IP address from within the DB instance's virtual private cloud (VPC). It resolves to the public IP address from outside of the DB instance's VPC. Access to the DB instance is ultimately controlled by the security group it uses. That public access is not permitted if the security group assigned to the DB instance doesn't permit it.</p>  <p>When the DB instance isn't publicly accessible, it is an internal DB instance with a DNS name that resolves to a private IP address.</p>  <p>For more information, see <code>CreateDBInstance</code>.</p>
    ///   - [`auto_minor_version_upgrade(bool)`](crate::client::fluent_builders::RestoreDBInstanceFromDBSnapshot::auto_minor_version_upgrade) / [`set_auto_minor_version_upgrade(Option<bool>)`](crate::client::fluent_builders::RestoreDBInstanceFromDBSnapshot::set_auto_minor_version_upgrade): <p>A value that indicates whether minor version upgrades are applied automatically to the DB instance during the maintenance window.</p>  <p>If you restore an RDS Custom DB instance, you must disable this parameter.</p>
    ///   - [`license_model(impl Into<String>)`](crate::client::fluent_builders::RestoreDBInstanceFromDBSnapshot::license_model) / [`set_license_model(Option<String>)`](crate::client::fluent_builders::RestoreDBInstanceFromDBSnapshot::set_license_model): <p>License model information for the restored DB instance.</p>  <p>This setting doesn't apply to RDS Custom.</p>  <p>Default: Same as source.</p>  <p>Valid values: <code>license-included</code> | <code>bring-your-own-license</code> | <code>general-public-license</code> </p>
    ///   - [`db_name(impl Into<String>)`](crate::client::fluent_builders::RestoreDBInstanceFromDBSnapshot::db_name) / [`set_db_name(Option<String>)`](crate::client::fluent_builders::RestoreDBInstanceFromDBSnapshot::set_db_name): <p>The database name for the restored DB instance.</p>  <p>This parameter doesn't apply to the MySQL, PostgreSQL, or MariaDB engines. It also doesn't apply to RDS Custom DB instances.</p>
    ///   - [`engine(impl Into<String>)`](crate::client::fluent_builders::RestoreDBInstanceFromDBSnapshot::engine) / [`set_engine(Option<String>)`](crate::client::fluent_builders::RestoreDBInstanceFromDBSnapshot::set_engine): <p>The database engine to use for the new instance.</p>  <p>This setting doesn't apply to RDS Custom.</p>  <p>Default: The same as source</p>  <p>Constraint: Must be compatible with the engine of the source. For example, you can restore a MariaDB 10.1 DB instance from a MySQL 5.6 snapshot.</p>  <p>Valid Values:</p>  <ul>   <li> <p> <code>mariadb</code> </p> </li>   <li> <p> <code>mysql</code> </p> </li>   <li> <p> <code>oracle-ee</code> </p> </li>   <li> <p> <code>oracle-ee-cdb</code> </p> </li>   <li> <p> <code>oracle-se2</code> </p> </li>   <li> <p> <code>oracle-se2-cdb</code> </p> </li>   <li> <p> <code>postgres</code> </p> </li>   <li> <p> <code>sqlserver-ee</code> </p> </li>   <li> <p> <code>sqlserver-se</code> </p> </li>   <li> <p> <code>sqlserver-ex</code> </p> </li>   <li> <p> <code>sqlserver-web</code> </p> </li>  </ul>
    ///   - [`iops(i32)`](crate::client::fluent_builders::RestoreDBInstanceFromDBSnapshot::iops) / [`set_iops(Option<i32>)`](crate::client::fluent_builders::RestoreDBInstanceFromDBSnapshot::set_iops): <p>Specifies the amount of provisioned IOPS for the DB instance, expressed in I/O operations per second. If this parameter isn't specified, the IOPS value is taken from the backup. If this parameter is set to 0, the new instance is converted to a non-PIOPS instance. The conversion takes additional time, though your DB instance is available for connections before the conversion starts.</p>  <p>The provisioned IOPS value must follow the requirements for your database engine. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#USER_PIOPS">Amazon RDS Provisioned IOPS Storage to Improve Performance</a> in the <i>Amazon RDS User Guide.</i> </p>  <p>Constraints: Must be an integer greater than 1000.</p>
    ///   - [`option_group_name(impl Into<String>)`](crate::client::fluent_builders::RestoreDBInstanceFromDBSnapshot::option_group_name) / [`set_option_group_name(Option<String>)`](crate::client::fluent_builders::RestoreDBInstanceFromDBSnapshot::set_option_group_name): <p>The name of the option group to be used for the restored DB instance.</p>  <p>Permanent options, such as the TDE option for Oracle Advanced Security TDE, can't be removed from an option group, and that option group can't be removed from a DB instance after it is associated with a DB instance.</p>  <p>This setting doesn't apply to RDS Custom.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::RestoreDBInstanceFromDBSnapshot::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::RestoreDBInstanceFromDBSnapshot::set_tags): <p>A list of tags. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources</a> in the <i>Amazon RDS User Guide.</i> </p>
    ///   - [`storage_type(impl Into<String>)`](crate::client::fluent_builders::RestoreDBInstanceFromDBSnapshot::storage_type) / [`set_storage_type(Option<String>)`](crate::client::fluent_builders::RestoreDBInstanceFromDBSnapshot::set_storage_type): <p>Specifies the storage type to be associated with the DB instance.</p>  <p>Valid values: <code>standard | gp2 | io1</code> </p>  <p>If you specify <code>io1</code>, you must also include a value for the <code>Iops</code> parameter.</p>  <p>Default: <code>io1</code> if the <code>Iops</code> parameter is specified, otherwise <code>gp2</code> </p>
    ///   - [`tde_credential_arn(impl Into<String>)`](crate::client::fluent_builders::RestoreDBInstanceFromDBSnapshot::tde_credential_arn) / [`set_tde_credential_arn(Option<String>)`](crate::client::fluent_builders::RestoreDBInstanceFromDBSnapshot::set_tde_credential_arn): <p>The ARN from the key store with which to associate the instance for TDE encryption.</p>  <p>This setting doesn't apply to RDS Custom.</p>
    ///   - [`tde_credential_password(impl Into<String>)`](crate::client::fluent_builders::RestoreDBInstanceFromDBSnapshot::tde_credential_password) / [`set_tde_credential_password(Option<String>)`](crate::client::fluent_builders::RestoreDBInstanceFromDBSnapshot::set_tde_credential_password): <p>The password for the given ARN from the key store in order to access the device.</p>  <p>This setting doesn't apply to RDS Custom.</p>
    ///   - [`vpc_security_group_ids(Vec<String>)`](crate::client::fluent_builders::RestoreDBInstanceFromDBSnapshot::vpc_security_group_ids) / [`set_vpc_security_group_ids(Option<Vec<String>>)`](crate::client::fluent_builders::RestoreDBInstanceFromDBSnapshot::set_vpc_security_group_ids): <p>A list of EC2 VPC security groups to associate with this DB instance.</p>  <p>Default: The default EC2 VPC security group for the DB subnet group's VPC.</p>
    ///   - [`domain(impl Into<String>)`](crate::client::fluent_builders::RestoreDBInstanceFromDBSnapshot::domain) / [`set_domain(Option<String>)`](crate::client::fluent_builders::RestoreDBInstanceFromDBSnapshot::set_domain): <p>Specify the Active Directory directory ID to restore the DB instance in. The domain/ must be created prior to this operation. Currently, you can create only MySQL, Microsoft SQL Server, Oracle, and PostgreSQL DB instances in an Active Directory Domain.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/kerberos-authentication.html"> Kerberos Authentication</a> in the <i>Amazon RDS User Guide</i>.</p>  <p>This setting doesn't apply to RDS Custom.</p>
    ///   - [`copy_tags_to_snapshot(bool)`](crate::client::fluent_builders::RestoreDBInstanceFromDBSnapshot::copy_tags_to_snapshot) / [`set_copy_tags_to_snapshot(Option<bool>)`](crate::client::fluent_builders::RestoreDBInstanceFromDBSnapshot::set_copy_tags_to_snapshot): <p>A value that indicates whether to copy all tags from the restored DB instance to snapshots of the DB instance.</p>  <p>In most cases, tags aren't copied by default. However, when you restore a DB instance from a DB snapshot, RDS checks whether you specify new tags. If yes, the new tags are added to the restored DB instance. If there are no new tags, RDS looks for the tags from the source DB instance for the DB snapshot, and then adds those tags to the restored DB instance.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html#USER_Tagging.CopyTags"> Copying tags to DB instance snapshots</a> in the <i>Amazon RDS User Guide</i>.</p>
    ///   - [`domain_iam_role_name(impl Into<String>)`](crate::client::fluent_builders::RestoreDBInstanceFromDBSnapshot::domain_iam_role_name) / [`set_domain_iam_role_name(Option<String>)`](crate::client::fluent_builders::RestoreDBInstanceFromDBSnapshot::set_domain_iam_role_name): <p>Specify the name of the IAM role to be used when making API calls to the Directory Service.</p>  <p>This setting doesn't apply to RDS Custom.</p>
    ///   - [`enable_iam_database_authentication(bool)`](crate::client::fluent_builders::RestoreDBInstanceFromDBSnapshot::enable_iam_database_authentication) / [`set_enable_iam_database_authentication(Option<bool>)`](crate::client::fluent_builders::RestoreDBInstanceFromDBSnapshot::set_enable_iam_database_authentication): <p>A value that indicates whether to enable mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts. By default, mapping is disabled.</p>  <p>For more information about IAM database authentication, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.html"> IAM Database Authentication for MySQL and PostgreSQL</a> in the <i>Amazon RDS User Guide.</i> </p>  <p>This setting doesn't apply to RDS Custom.</p>
    ///   - [`enable_cloudwatch_logs_exports(Vec<String>)`](crate::client::fluent_builders::RestoreDBInstanceFromDBSnapshot::enable_cloudwatch_logs_exports) / [`set_enable_cloudwatch_logs_exports(Option<Vec<String>>)`](crate::client::fluent_builders::RestoreDBInstanceFromDBSnapshot::set_enable_cloudwatch_logs_exports): <p>The list of logs that the restored DB instance is to export to CloudWatch Logs. The values in the list depend on the DB engine being used. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch">Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon RDS User Guide</i>.</p>  <p>This setting doesn't apply to RDS Custom.</p>
    ///   - [`processor_features(Vec<ProcessorFeature>)`](crate::client::fluent_builders::RestoreDBInstanceFromDBSnapshot::processor_features) / [`set_processor_features(Option<Vec<ProcessorFeature>>)`](crate::client::fluent_builders::RestoreDBInstanceFromDBSnapshot::set_processor_features): <p>The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.</p>  <p>This setting doesn't apply to RDS Custom.</p>
    ///   - [`use_default_processor_features(bool)`](crate::client::fluent_builders::RestoreDBInstanceFromDBSnapshot::use_default_processor_features) / [`set_use_default_processor_features(Option<bool>)`](crate::client::fluent_builders::RestoreDBInstanceFromDBSnapshot::set_use_default_processor_features): <p>A value that indicates whether the DB instance class of the DB instance uses its default processor features.</p>  <p>This setting doesn't apply to RDS Custom.</p>
    ///   - [`db_parameter_group_name(impl Into<String>)`](crate::client::fluent_builders::RestoreDBInstanceFromDBSnapshot::db_parameter_group_name) / [`set_db_parameter_group_name(Option<String>)`](crate::client::fluent_builders::RestoreDBInstanceFromDBSnapshot::set_db_parameter_group_name): <p>The name of the DB parameter group to associate with this DB instance.</p>  <p>If you don't specify a value for <code>DBParameterGroupName</code>, then RDS uses the default <code>DBParameterGroup</code> for the specified DB engine.</p>  <p>This setting doesn't apply to RDS Custom.</p>  <p>Constraints:</p>  <ul>   <li> <p>If supplied, must match the name of an existing DBParameterGroup.</p> </li>   <li> <p>Must be 1 to 255 letters, numbers, or hyphens.</p> </li>   <li> <p>First character must be a letter.</p> </li>   <li> <p>Can't end with a hyphen or contain two consecutive hyphens.</p> </li>  </ul>
    ///   - [`deletion_protection(bool)`](crate::client::fluent_builders::RestoreDBInstanceFromDBSnapshot::deletion_protection) / [`set_deletion_protection(Option<bool>)`](crate::client::fluent_builders::RestoreDBInstanceFromDBSnapshot::set_deletion_protection): <p>A value that indicates whether the DB instance has deletion protection enabled. The database can't be deleted when deletion protection is enabled. By default, deletion protection isn't enabled. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html"> Deleting a DB Instance</a>.</p>
    ///   - [`enable_customer_owned_ip(bool)`](crate::client::fluent_builders::RestoreDBInstanceFromDBSnapshot::enable_customer_owned_ip) / [`set_enable_customer_owned_ip(Option<bool>)`](crate::client::fluent_builders::RestoreDBInstanceFromDBSnapshot::set_enable_customer_owned_ip): <p>A value that indicates whether to enable a customer-owned IP address (CoIP) for an RDS on Outposts DB instance.</p>  <p>A <i>CoIP</i> provides local or external connectivity to resources in your Outpost subnets through your on-premises network. For some use cases, a CoIP can provide lower latency for connections to the DB instance from outside of its virtual private cloud (VPC) on your local network.</p>  <p>This setting doesn't apply to RDS Custom.</p>  <p>For more information about RDS on Outposts, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html">Working with Amazon RDS on Amazon Web Services Outposts</a> in the <i>Amazon RDS User Guide</i>.</p>  <p>For more information about CoIPs, see <a href="https://docs.aws.amazon.com/outposts/latest/userguide/outposts-networking-components.html#ip-addressing">Customer-owned IP addresses</a> in the <i>Amazon Web Services Outposts User Guide</i>.</p>
    ///   - [`custom_iam_instance_profile(impl Into<String>)`](crate::client::fluent_builders::RestoreDBInstanceFromDBSnapshot::custom_iam_instance_profile) / [`set_custom_iam_instance_profile(Option<String>)`](crate::client::fluent_builders::RestoreDBInstanceFromDBSnapshot::set_custom_iam_instance_profile): <p>The instance profile associated with the underlying Amazon EC2 instance of an RDS Custom DB instance. The instance profile must meet the following requirements:</p>  <ul>   <li> <p>The profile must exist in your account.</p> </li>   <li> <p>The profile must have an IAM role that Amazon EC2 has permissions to assume.</p> </li>   <li> <p>The instance profile name and the associated IAM role name must start with the prefix <code>AWSRDSCustom</code>.</p> </li>  </ul>  <p>For the list of permissions required for the IAM role, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-setup-orcl.html#custom-setup-orcl.iam-vpc"> Configure IAM and your VPC</a> in the <i>Amazon RDS User Guide</i>.</p>  <p>This setting is required for RDS Custom.</p>
    ///   - [`backup_target(impl Into<String>)`](crate::client::fluent_builders::RestoreDBInstanceFromDBSnapshot::backup_target) / [`set_backup_target(Option<String>)`](crate::client::fluent_builders::RestoreDBInstanceFromDBSnapshot::set_backup_target): <p>Specifies where automated backups and manual snapshots are stored for the restored DB instance.</p>  <p>Possible values are <code>outposts</code> (Amazon Web Services Outposts) and <code>region</code> (Amazon Web Services Region). The default is <code>region</code>.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html">Working with Amazon RDS on Amazon Web Services Outposts</a> in the <i>Amazon RDS User Guide</i>.</p>
    /// - On success, responds with [`RestoreDbInstanceFromDbSnapshotOutput`](crate::output::RestoreDbInstanceFromDbSnapshotOutput) with field(s):
    ///   - [`db_instance(Option<DbInstance>)`](crate::output::RestoreDbInstanceFromDbSnapshotOutput::db_instance): <p>Contains the details of an Amazon RDS DB instance.</p>  <p>This data type is used as a response element in the operations <code>CreateDBInstance</code>, <code>CreateDBInstanceReadReplica</code>, <code>DeleteDBInstance</code>, <code>DescribeDBInstances</code>, <code>ModifyDBInstance</code>, <code>PromoteReadReplica</code>, <code>RebootDBInstance</code>, <code>RestoreDBInstanceFromDBSnapshot</code>, <code>RestoreDBInstanceFromS3</code>, <code>RestoreDBInstanceToPointInTime</code>, <code>StartDBInstance</code>, and <code>StopDBInstance</code>.</p>
    /// - On failure, responds with [`SdkError<RestoreDBInstanceFromDBSnapshotError>`](crate::error::RestoreDBInstanceFromDBSnapshotError)
    pub fn restore_db_instance_from_db_snapshot(
        &self,
    ) -> fluent_builders::RestoreDBInstanceFromDBSnapshot {
        fluent_builders::RestoreDBInstanceFromDBSnapshot::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RestoreDBInstanceFromS3`](crate::client::fluent_builders::RestoreDBInstanceFromS3) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_name(impl Into<String>)`](crate::client::fluent_builders::RestoreDBInstanceFromS3::db_name) / [`set_db_name(Option<String>)`](crate::client::fluent_builders::RestoreDBInstanceFromS3::set_db_name): <p>The name of the database to create when the DB instance is created. Follow the naming rules specified in <code>CreateDBInstance</code>.</p>
    ///   - [`db_instance_identifier(impl Into<String>)`](crate::client::fluent_builders::RestoreDBInstanceFromS3::db_instance_identifier) / [`set_db_instance_identifier(Option<String>)`](crate::client::fluent_builders::RestoreDBInstanceFromS3::set_db_instance_identifier): <p>The DB instance identifier. This parameter is stored as a lowercase string.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p> </li>   <li> <p>First character must be a letter.</p> </li>   <li> <p>Can't end with a hyphen or contain two consecutive hyphens.</p> </li>  </ul>  <p>Example: <code>mydbinstance</code> </p>
    ///   - [`allocated_storage(i32)`](crate::client::fluent_builders::RestoreDBInstanceFromS3::allocated_storage) / [`set_allocated_storage(Option<i32>)`](crate::client::fluent_builders::RestoreDBInstanceFromS3::set_allocated_storage): <p>The amount of storage (in gigabytes) to allocate initially for the DB instance. Follow the allocation rules specified in <code>CreateDBInstance</code>.</p> <note>   <p>Be sure to allocate enough memory for your new DB instance so that the restore operation can succeed. You can also allocate additional memory for future growth.</p>  </note>
    ///   - [`db_instance_class(impl Into<String>)`](crate::client::fluent_builders::RestoreDBInstanceFromS3::db_instance_class) / [`set_db_instance_class(Option<String>)`](crate::client::fluent_builders::RestoreDBInstanceFromS3::set_db_instance_class): <p>The compute and memory capacity of the DB instance, for example db.m4.large. Not all DB instance classes are available in all Amazon Web Services Regions, or for all database engines. For the full list of DB instance classes, and availability for your engine, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html">DB Instance Class</a> in the <i>Amazon RDS User Guide.</i> </p>  <p>Importing from Amazon S3 isn't supported on the db.t2.micro DB instance class.</p>
    ///   - [`engine(impl Into<String>)`](crate::client::fluent_builders::RestoreDBInstanceFromS3::engine) / [`set_engine(Option<String>)`](crate::client::fluent_builders::RestoreDBInstanceFromS3::set_engine): <p>The name of the database engine to be used for this instance.</p>  <p>Valid Values: <code>mysql</code> </p>
    ///   - [`master_username(impl Into<String>)`](crate::client::fluent_builders::RestoreDBInstanceFromS3::master_username) / [`set_master_username(Option<String>)`](crate::client::fluent_builders::RestoreDBInstanceFromS3::set_master_username): <p>The name for the master user.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must be 1 to 16 letters or numbers.</p> </li>   <li> <p>First character must be a letter.</p> </li>   <li> <p>Can't be a reserved word for the chosen database engine.</p> </li>  </ul>
    ///   - [`master_user_password(impl Into<String>)`](crate::client::fluent_builders::RestoreDBInstanceFromS3::master_user_password) / [`set_master_user_password(Option<String>)`](crate::client::fluent_builders::RestoreDBInstanceFromS3::set_master_user_password): <p>The password for the master user. The password can include any printable ASCII character except "/", """, or "@".</p>  <p>Constraints: Must contain from 8 to 41 characters.</p>
    ///   - [`db_security_groups(Vec<String>)`](crate::client::fluent_builders::RestoreDBInstanceFromS3::db_security_groups) / [`set_db_security_groups(Option<Vec<String>>)`](crate::client::fluent_builders::RestoreDBInstanceFromS3::set_db_security_groups): <p>A list of DB security groups to associate with this DB instance.</p>  <p>Default: The default DB security group for the database engine.</p>
    ///   - [`vpc_security_group_ids(Vec<String>)`](crate::client::fluent_builders::RestoreDBInstanceFromS3::vpc_security_group_ids) / [`set_vpc_security_group_ids(Option<Vec<String>>)`](crate::client::fluent_builders::RestoreDBInstanceFromS3::set_vpc_security_group_ids): <p>A list of VPC security groups to associate with this DB instance.</p>
    ///   - [`availability_zone(impl Into<String>)`](crate::client::fluent_builders::RestoreDBInstanceFromS3::availability_zone) / [`set_availability_zone(Option<String>)`](crate::client::fluent_builders::RestoreDBInstanceFromS3::set_availability_zone): <p>The Availability Zone that the DB instance is created in. For information about Amazon Web Services Regions and Availability Zones, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.RegionsAndAvailabilityZones.html">Regions and Availability Zones</a> in the <i>Amazon RDS User Guide.</i> </p>  <p>Default: A random, system-chosen Availability Zone in the endpoint's Amazon Web Services Region.</p>  <p>Example: <code>us-east-1d</code> </p>  <p>Constraint: The <code>AvailabilityZone</code> parameter can't be specified if the DB instance is a Multi-AZ deployment. The specified Availability Zone must be in the same Amazon Web Services Region as the current endpoint.</p>
    ///   - [`db_subnet_group_name(impl Into<String>)`](crate::client::fluent_builders::RestoreDBInstanceFromS3::db_subnet_group_name) / [`set_db_subnet_group_name(Option<String>)`](crate::client::fluent_builders::RestoreDBInstanceFromS3::set_db_subnet_group_name): <p>A DB subnet group to associate with this DB instance.</p>  <p>Constraints: If supplied, must match the name of an existing DBSubnetGroup.</p>  <p>Example: <code>mydbsubnetgroup</code> </p>
    ///   - [`preferred_maintenance_window(impl Into<String>)`](crate::client::fluent_builders::RestoreDBInstanceFromS3::preferred_maintenance_window) / [`set_preferred_maintenance_window(Option<String>)`](crate::client::fluent_builders::RestoreDBInstanceFromS3::set_preferred_maintenance_window): <p>The time range each week during which system maintenance can occur, in Universal Coordinated Time (UTC). For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Maintenance.html#Concepts.DBMaintenance">Amazon RDS Maintenance Window</a> in the <i>Amazon RDS User Guide.</i> </p>  <p>Constraints:</p>  <ul>   <li> <p>Must be in the format <code>ddd:hh24:mi-ddd:hh24:mi</code>.</p> </li>   <li> <p>Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.</p> </li>   <li> <p>Must be in Universal Coordinated Time (UTC).</p> </li>   <li> <p>Must not conflict with the preferred backup window.</p> </li>   <li> <p>Must be at least 30 minutes.</p> </li>  </ul>
    ///   - [`db_parameter_group_name(impl Into<String>)`](crate::client::fluent_builders::RestoreDBInstanceFromS3::db_parameter_group_name) / [`set_db_parameter_group_name(Option<String>)`](crate::client::fluent_builders::RestoreDBInstanceFromS3::set_db_parameter_group_name): <p>The name of the DB parameter group to associate with this DB instance.</p>  <p>If you do not specify a value for <code>DBParameterGroupName</code>, then the default <code>DBParameterGroup</code> for the specified DB engine is used.</p>
    ///   - [`backup_retention_period(i32)`](crate::client::fluent_builders::RestoreDBInstanceFromS3::backup_retention_period) / [`set_backup_retention_period(Option<i32>)`](crate::client::fluent_builders::RestoreDBInstanceFromS3::set_backup_retention_period): <p>The number of days for which automated backups are retained. Setting this parameter to a positive number enables backups. For more information, see <code>CreateDBInstance</code>.</p>
    ///   - [`preferred_backup_window(impl Into<String>)`](crate::client::fluent_builders::RestoreDBInstanceFromS3::preferred_backup_window) / [`set_preferred_backup_window(Option<String>)`](crate::client::fluent_builders::RestoreDBInstanceFromS3::set_preferred_backup_window): <p>The time range each day during which automated backups are created if automated backups are enabled. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithAutomatedBackups.html#USER_WorkingWithAutomatedBackups.BackupWindow">Backup window</a> in the <i>Amazon RDS User Guide.</i> </p>  <p>Constraints:</p>  <ul>   <li> <p>Must be in the format <code>hh24:mi-hh24:mi</code>.</p> </li>   <li> <p>Must be in Universal Coordinated Time (UTC).</p> </li>   <li> <p>Must not conflict with the preferred maintenance window.</p> </li>   <li> <p>Must be at least 30 minutes.</p> </li>  </ul>
    ///   - [`port(i32)`](crate::client::fluent_builders::RestoreDBInstanceFromS3::port) / [`set_port(Option<i32>)`](crate::client::fluent_builders::RestoreDBInstanceFromS3::set_port): <p>The port number on which the database accepts connections.</p>  <p>Type: Integer</p>  <p>Valid Values: <code>1150</code>-<code>65535</code> </p>  <p>Default: <code>3306</code> </p>
    ///   - [`multi_az(bool)`](crate::client::fluent_builders::RestoreDBInstanceFromS3::multi_az) / [`set_multi_az(Option<bool>)`](crate::client::fluent_builders::RestoreDBInstanceFromS3::set_multi_az): <p>A value that indicates whether the DB instance is a Multi-AZ deployment. If the DB instance is a Multi-AZ deployment, you can't set the <code>AvailabilityZone</code> parameter.</p>
    ///   - [`engine_version(impl Into<String>)`](crate::client::fluent_builders::RestoreDBInstanceFromS3::engine_version) / [`set_engine_version(Option<String>)`](crate::client::fluent_builders::RestoreDBInstanceFromS3::set_engine_version): <p>The version number of the database engine to use. Choose the latest minor version of your database engine. For information about engine versions, see <code>CreateDBInstance</code>, or call <code>DescribeDBEngineVersions</code>.</p>
    ///   - [`auto_minor_version_upgrade(bool)`](crate::client::fluent_builders::RestoreDBInstanceFromS3::auto_minor_version_upgrade) / [`set_auto_minor_version_upgrade(Option<bool>)`](crate::client::fluent_builders::RestoreDBInstanceFromS3::set_auto_minor_version_upgrade): <p>A value that indicates whether minor engine upgrades are applied automatically to the DB instance during the maintenance window. By default, minor engine upgrades are not applied automatically.</p>
    ///   - [`license_model(impl Into<String>)`](crate::client::fluent_builders::RestoreDBInstanceFromS3::license_model) / [`set_license_model(Option<String>)`](crate::client::fluent_builders::RestoreDBInstanceFromS3::set_license_model): <p>The license model for this DB instance. Use <code>general-public-license</code>.</p>
    ///   - [`iops(i32)`](crate::client::fluent_builders::RestoreDBInstanceFromS3::iops) / [`set_iops(Option<i32>)`](crate::client::fluent_builders::RestoreDBInstanceFromS3::set_iops): <p>The amount of Provisioned IOPS (input/output operations per second) to allocate initially for the DB instance. For information about valid Iops values, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#USER_PIOPS">Amazon RDS Provisioned IOPS Storage to Improve Performance</a> in the <i>Amazon RDS User Guide.</i> </p>
    ///   - [`option_group_name(impl Into<String>)`](crate::client::fluent_builders::RestoreDBInstanceFromS3::option_group_name) / [`set_option_group_name(Option<String>)`](crate::client::fluent_builders::RestoreDBInstanceFromS3::set_option_group_name): <p>The name of the option group to associate with this DB instance. If this argument is omitted, the default option group for the specified engine is used.</p>
    ///   - [`publicly_accessible(bool)`](crate::client::fluent_builders::RestoreDBInstanceFromS3::publicly_accessible) / [`set_publicly_accessible(Option<bool>)`](crate::client::fluent_builders::RestoreDBInstanceFromS3::set_publicly_accessible): <p>A value that indicates whether the DB instance is publicly accessible.</p>  <p>When the DB instance is publicly accessible, its Domain Name System (DNS) endpoint resolves to the private IP address from within the DB instance's virtual private cloud (VPC). It resolves to the public IP address from outside of the DB instance's VPC. Access to the DB instance is ultimately controlled by the security group it uses. That public access is not permitted if the security group assigned to the DB instance doesn't permit it.</p>  <p>When the DB instance isn't publicly accessible, it is an internal DB instance with a DNS name that resolves to a private IP address.</p>  <p>For more information, see <code>CreateDBInstance</code>.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::RestoreDBInstanceFromS3::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::RestoreDBInstanceFromS3::set_tags): <p>A list of tags to associate with this DB instance. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources</a> in the <i>Amazon RDS User Guide.</i> </p>
    ///   - [`storage_type(impl Into<String>)`](crate::client::fluent_builders::RestoreDBInstanceFromS3::storage_type) / [`set_storage_type(Option<String>)`](crate::client::fluent_builders::RestoreDBInstanceFromS3::set_storage_type): <p>Specifies the storage type to be associated with the DB instance.</p>  <p>Valid values: <code>standard</code> | <code>gp2</code> | <code>io1</code> </p>  <p>If you specify <code>io1</code>, you must also include a value for the <code>Iops</code> parameter.</p>  <p>Default: <code>io1</code> if the <code>Iops</code> parameter is specified; otherwise <code>gp2</code> </p>
    ///   - [`storage_encrypted(bool)`](crate::client::fluent_builders::RestoreDBInstanceFromS3::storage_encrypted) / [`set_storage_encrypted(Option<bool>)`](crate::client::fluent_builders::RestoreDBInstanceFromS3::set_storage_encrypted): <p>A value that indicates whether the new DB instance is encrypted or not.</p>
    ///   - [`kms_key_id(impl Into<String>)`](crate::client::fluent_builders::RestoreDBInstanceFromS3::kms_key_id) / [`set_kms_key_id(Option<String>)`](crate::client::fluent_builders::RestoreDBInstanceFromS3::set_kms_key_id): <p>The Amazon Web Services KMS key identifier for an encrypted DB instance.</p>  <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key. To use a KMS key in a different Amazon Web Services account, specify the key ARN or alias ARN.</p>  <p>If the <code>StorageEncrypted</code> parameter is enabled, and you do not specify a value for the <code>KmsKeyId</code> parameter, then Amazon RDS will use your default KMS key. There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account has a different default KMS key for each Amazon Web Services Region.</p>
    ///   - [`copy_tags_to_snapshot(bool)`](crate::client::fluent_builders::RestoreDBInstanceFromS3::copy_tags_to_snapshot) / [`set_copy_tags_to_snapshot(Option<bool>)`](crate::client::fluent_builders::RestoreDBInstanceFromS3::set_copy_tags_to_snapshot): <p>A value that indicates whether to copy all tags from the DB instance to snapshots of the DB instance. By default, tags are not copied.</p>
    ///   - [`monitoring_interval(i32)`](crate::client::fluent_builders::RestoreDBInstanceFromS3::monitoring_interval) / [`set_monitoring_interval(Option<i32>)`](crate::client::fluent_builders::RestoreDBInstanceFromS3::set_monitoring_interval): <p>The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB instance. To disable collecting Enhanced Monitoring metrics, specify 0.</p>  <p>If <code>MonitoringRoleArn</code> is specified, then you must also set <code>MonitoringInterval</code> to a value other than 0.</p>  <p>Valid Values: 0, 1, 5, 10, 15, 30, 60</p>  <p>Default: <code>0</code> </p>
    ///   - [`monitoring_role_arn(impl Into<String>)`](crate::client::fluent_builders::RestoreDBInstanceFromS3::monitoring_role_arn) / [`set_monitoring_role_arn(Option<String>)`](crate::client::fluent_builders::RestoreDBInstanceFromS3::set_monitoring_role_arn): <p>The ARN for the IAM role that permits RDS to send enhanced monitoring metrics to Amazon CloudWatch Logs. For example, <code>arn:aws:iam:123456789012:role/emaccess</code>. For information on creating a monitoring role, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.OS.html#USER_Monitoring.OS.Enabling">Setting Up and Enabling Enhanced Monitoring</a> in the <i>Amazon RDS User Guide.</i> </p>  <p>If <code>MonitoringInterval</code> is set to a value other than 0, then you must supply a <code>MonitoringRoleArn</code> value.</p>
    ///   - [`enable_iam_database_authentication(bool)`](crate::client::fluent_builders::RestoreDBInstanceFromS3::enable_iam_database_authentication) / [`set_enable_iam_database_authentication(Option<bool>)`](crate::client::fluent_builders::RestoreDBInstanceFromS3::set_enable_iam_database_authentication): <p>A value that indicates whether to enable mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts. By default, mapping isn't enabled.</p>  <p>For more information about IAM database authentication, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.html"> IAM Database Authentication for MySQL and PostgreSQL</a> in the <i>Amazon RDS User Guide.</i> </p>
    ///   - [`source_engine(impl Into<String>)`](crate::client::fluent_builders::RestoreDBInstanceFromS3::source_engine) / [`set_source_engine(Option<String>)`](crate::client::fluent_builders::RestoreDBInstanceFromS3::set_source_engine): <p>The name of the engine of your source database.</p>  <p>Valid Values: <code>mysql</code> </p>
    ///   - [`source_engine_version(impl Into<String>)`](crate::client::fluent_builders::RestoreDBInstanceFromS3::source_engine_version) / [`set_source_engine_version(Option<String>)`](crate::client::fluent_builders::RestoreDBInstanceFromS3::set_source_engine_version): <p>The version of the database that the backup files were created from.</p>  <p>MySQL versions 5.6 and 5.7 are supported.</p>  <p>Example: <code>5.6.40</code> </p>
    ///   - [`s3_bucket_name(impl Into<String>)`](crate::client::fluent_builders::RestoreDBInstanceFromS3::s3_bucket_name) / [`set_s3_bucket_name(Option<String>)`](crate::client::fluent_builders::RestoreDBInstanceFromS3::set_s3_bucket_name): <p>The name of your Amazon S3 bucket that contains your database backup file.</p>
    ///   - [`s3_prefix(impl Into<String>)`](crate::client::fluent_builders::RestoreDBInstanceFromS3::s3_prefix) / [`set_s3_prefix(Option<String>)`](crate::client::fluent_builders::RestoreDBInstanceFromS3::set_s3_prefix): <p>The prefix of your Amazon S3 bucket.</p>
    ///   - [`s3_ingestion_role_arn(impl Into<String>)`](crate::client::fluent_builders::RestoreDBInstanceFromS3::s3_ingestion_role_arn) / [`set_s3_ingestion_role_arn(Option<String>)`](crate::client::fluent_builders::RestoreDBInstanceFromS3::set_s3_ingestion_role_arn): <p>An Amazon Web Services Identity and Access Management (IAM) role to allow Amazon RDS to access your Amazon S3 bucket.</p>
    ///   - [`enable_performance_insights(bool)`](crate::client::fluent_builders::RestoreDBInstanceFromS3::enable_performance_insights) / [`set_enable_performance_insights(Option<bool>)`](crate::client::fluent_builders::RestoreDBInstanceFromS3::set_enable_performance_insights): <p>A value that indicates whether to enable Performance Insights for the DB instance.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html">Using Amazon Performance Insights</a> in the <i>Amazon RDS User Guide.</i>.</p>
    ///   - [`performance_insights_kms_key_id(impl Into<String>)`](crate::client::fluent_builders::RestoreDBInstanceFromS3::performance_insights_kms_key_id) / [`set_performance_insights_kms_key_id(Option<String>)`](crate::client::fluent_builders::RestoreDBInstanceFromS3::set_performance_insights_kms_key_id): <p>The Amazon Web Services KMS key identifier for encryption of Performance Insights data.</p>  <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.</p>  <p>If you do not specify a value for <code>PerformanceInsightsKMSKeyId</code>, then Amazon RDS uses your default KMS key. There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account has a different default KMS key for each Amazon Web Services Region.</p>
    ///   - [`performance_insights_retention_period(i32)`](crate::client::fluent_builders::RestoreDBInstanceFromS3::performance_insights_retention_period) / [`set_performance_insights_retention_period(Option<i32>)`](crate::client::fluent_builders::RestoreDBInstanceFromS3::set_performance_insights_retention_period): <p>The amount of time, in days, to retain Performance Insights data. Valid values are 7 or 731 (2 years).</p>
    ///   - [`enable_cloudwatch_logs_exports(Vec<String>)`](crate::client::fluent_builders::RestoreDBInstanceFromS3::enable_cloudwatch_logs_exports) / [`set_enable_cloudwatch_logs_exports(Option<Vec<String>>)`](crate::client::fluent_builders::RestoreDBInstanceFromS3::set_enable_cloudwatch_logs_exports): <p>The list of logs that the restored DB instance is to export to CloudWatch Logs. The values in the list depend on the DB engine being used. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch">Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon RDS User Guide</i>.</p>
    ///   - [`processor_features(Vec<ProcessorFeature>)`](crate::client::fluent_builders::RestoreDBInstanceFromS3::processor_features) / [`set_processor_features(Option<Vec<ProcessorFeature>>)`](crate::client::fluent_builders::RestoreDBInstanceFromS3::set_processor_features): <p>The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.</p>
    ///   - [`use_default_processor_features(bool)`](crate::client::fluent_builders::RestoreDBInstanceFromS3::use_default_processor_features) / [`set_use_default_processor_features(Option<bool>)`](crate::client::fluent_builders::RestoreDBInstanceFromS3::set_use_default_processor_features): <p>A value that indicates whether the DB instance class of the DB instance uses its default processor features.</p>
    ///   - [`deletion_protection(bool)`](crate::client::fluent_builders::RestoreDBInstanceFromS3::deletion_protection) / [`set_deletion_protection(Option<bool>)`](crate::client::fluent_builders::RestoreDBInstanceFromS3::set_deletion_protection): <p>A value that indicates whether the DB instance has deletion protection enabled. The database can't be deleted when deletion protection is enabled. By default, deletion protection isn't enabled. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html"> Deleting a DB Instance</a>.</p>
    ///   - [`max_allocated_storage(i32)`](crate::client::fluent_builders::RestoreDBInstanceFromS3::max_allocated_storage) / [`set_max_allocated_storage(Option<i32>)`](crate::client::fluent_builders::RestoreDBInstanceFromS3::set_max_allocated_storage): <p>The upper limit in gibibytes (GiB) to which Amazon RDS can automatically scale the storage of the DB instance.</p>  <p>For more information about this setting, including limitations that apply to it, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIOPS.StorageTypes.html#USER_PIOPS.Autoscaling"> Managing capacity automatically with Amazon RDS storage autoscaling</a> in the <i>Amazon RDS User Guide</i>.</p>
    /// - On success, responds with [`RestoreDbInstanceFromS3Output`](crate::output::RestoreDbInstanceFromS3Output) with field(s):
    ///   - [`db_instance(Option<DbInstance>)`](crate::output::RestoreDbInstanceFromS3Output::db_instance): <p>Contains the details of an Amazon RDS DB instance.</p>  <p>This data type is used as a response element in the operations <code>CreateDBInstance</code>, <code>CreateDBInstanceReadReplica</code>, <code>DeleteDBInstance</code>, <code>DescribeDBInstances</code>, <code>ModifyDBInstance</code>, <code>PromoteReadReplica</code>, <code>RebootDBInstance</code>, <code>RestoreDBInstanceFromDBSnapshot</code>, <code>RestoreDBInstanceFromS3</code>, <code>RestoreDBInstanceToPointInTime</code>, <code>StartDBInstance</code>, and <code>StopDBInstance</code>.</p>
    /// - On failure, responds with [`SdkError<RestoreDBInstanceFromS3Error>`](crate::error::RestoreDBInstanceFromS3Error)
    pub fn restore_db_instance_from_s3(&self) -> fluent_builders::RestoreDBInstanceFromS3 {
        fluent_builders::RestoreDBInstanceFromS3::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RestoreDBInstanceToPointInTime`](crate::client::fluent_builders::RestoreDBInstanceToPointInTime) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`source_db_instance_identifier(impl Into<String>)`](crate::client::fluent_builders::RestoreDBInstanceToPointInTime::source_db_instance_identifier) / [`set_source_db_instance_identifier(Option<String>)`](crate::client::fluent_builders::RestoreDBInstanceToPointInTime::set_source_db_instance_identifier): <p>The identifier of the source DB instance from which to restore.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must match the identifier of an existing DB instance.</p> </li>  </ul>
    ///   - [`target_db_instance_identifier(impl Into<String>)`](crate::client::fluent_builders::RestoreDBInstanceToPointInTime::target_db_instance_identifier) / [`set_target_db_instance_identifier(Option<String>)`](crate::client::fluent_builders::RestoreDBInstanceToPointInTime::set_target_db_instance_identifier): <p>The name of the new DB instance to be created.</p>  <p>Constraints:</p>  <ul>   <li> <p>Must contain from 1 to 63 letters, numbers, or hyphens</p> </li>   <li> <p>First character must be a letter</p> </li>   <li> <p>Can't end with a hyphen or contain two consecutive hyphens</p> </li>  </ul>
    ///   - [`restore_time(DateTime)`](crate::client::fluent_builders::RestoreDBInstanceToPointInTime::restore_time) / [`set_restore_time(Option<DateTime>)`](crate::client::fluent_builders::RestoreDBInstanceToPointInTime::set_restore_time): <p>The date and time to restore from.</p>  <p>Valid Values: Value must be a time in Universal Coordinated Time (UTC) format</p>  <p>Constraints:</p>  <ul>   <li> <p>Must be before the latest restorable time for the DB instance</p> </li>   <li> <p>Can't be specified if the <code>UseLatestRestorableTime</code> parameter is enabled</p> </li>  </ul>  <p>Example: <code>2009-09-07T23:45:00Z</code> </p>
    ///   - [`use_latest_restorable_time(bool)`](crate::client::fluent_builders::RestoreDBInstanceToPointInTime::use_latest_restorable_time) / [`set_use_latest_restorable_time(bool)`](crate::client::fluent_builders::RestoreDBInstanceToPointInTime::set_use_latest_restorable_time): <p>A value that indicates whether the DB instance is restored from the latest backup time. By default, the DB instance isn't restored from the latest backup time.</p>  <p>Constraints: Can't be specified if the <code>RestoreTime</code> parameter is provided.</p>
    ///   - [`db_instance_class(impl Into<String>)`](crate::client::fluent_builders::RestoreDBInstanceToPointInTime::db_instance_class) / [`set_db_instance_class(Option<String>)`](crate::client::fluent_builders::RestoreDBInstanceToPointInTime::set_db_instance_class): <p>The compute and memory capacity of the Amazon RDS DB instance, for example db.m4.large. Not all DB instance classes are available in all Amazon Web Services Regions, or for all database engines. For the full list of DB instance classes, and availability for your engine, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html">DB Instance Class</a> in the <i>Amazon RDS User Guide</i>.</p>  <p>Default: The same DBInstanceClass as the original DB instance.</p>
    ///   - [`port(i32)`](crate::client::fluent_builders::RestoreDBInstanceToPointInTime::port) / [`set_port(Option<i32>)`](crate::client::fluent_builders::RestoreDBInstanceToPointInTime::set_port): <p>The port number on which the database accepts connections.</p>  <p>Constraints: Value must be <code>1150-65535</code> </p>  <p>Default: The same port as the original DB instance.</p>
    ///   - [`availability_zone(impl Into<String>)`](crate::client::fluent_builders::RestoreDBInstanceToPointInTime::availability_zone) / [`set_availability_zone(Option<String>)`](crate::client::fluent_builders::RestoreDBInstanceToPointInTime::set_availability_zone): <p>The Availability Zone (AZ) where the DB instance will be created.</p>  <p>Default: A random, system-chosen Availability Zone.</p>  <p>Constraint: You can't specify the <code>AvailabilityZone</code> parameter if the DB instance is a Multi-AZ deployment.</p>  <p>Example: <code>us-east-1a</code> </p>
    ///   - [`db_subnet_group_name(impl Into<String>)`](crate::client::fluent_builders::RestoreDBInstanceToPointInTime::db_subnet_group_name) / [`set_db_subnet_group_name(Option<String>)`](crate::client::fluent_builders::RestoreDBInstanceToPointInTime::set_db_subnet_group_name): <p>The DB subnet group name to use for the new instance.</p>  <p>Constraints: If supplied, must match the name of an existing DBSubnetGroup.</p>  <p>Example: <code>mydbsubnetgroup</code> </p>
    ///   - [`multi_az(bool)`](crate::client::fluent_builders::RestoreDBInstanceToPointInTime::multi_az) / [`set_multi_az(Option<bool>)`](crate::client::fluent_builders::RestoreDBInstanceToPointInTime::set_multi_az): <p>A value that indicates whether the DB instance is a Multi-AZ deployment.</p>  <p>This setting doesn't apply to RDS Custom.</p>  <p>Constraint: You can't specify the <code>AvailabilityZone</code> parameter if the DB instance is a Multi-AZ deployment.</p>
    ///   - [`publicly_accessible(bool)`](crate::client::fluent_builders::RestoreDBInstanceToPointInTime::publicly_accessible) / [`set_publicly_accessible(Option<bool>)`](crate::client::fluent_builders::RestoreDBInstanceToPointInTime::set_publicly_accessible): <p>A value that indicates whether the DB instance is publicly accessible.</p>  <p>When the DB cluster is publicly accessible, its Domain Name System (DNS) endpoint resolves to the private IP address from within the DB cluster's virtual private cloud (VPC). It resolves to the public IP address from outside of the DB cluster's VPC. Access to the DB cluster is ultimately controlled by the security group it uses. That public access isn't permitted if the security group assigned to the DB cluster doesn't permit it.</p>  <p>When the DB instance isn't publicly accessible, it is an internal DB instance with a DNS name that resolves to a private IP address.</p>  <p>For more information, see <code>CreateDBInstance</code>.</p>
    ///   - [`auto_minor_version_upgrade(bool)`](crate::client::fluent_builders::RestoreDBInstanceToPointInTime::auto_minor_version_upgrade) / [`set_auto_minor_version_upgrade(Option<bool>)`](crate::client::fluent_builders::RestoreDBInstanceToPointInTime::set_auto_minor_version_upgrade): <p>A value that indicates whether minor version upgrades are applied automatically to the DB instance during the maintenance window.</p>  <p>This setting doesn't apply to RDS Custom.</p>
    ///   - [`license_model(impl Into<String>)`](crate::client::fluent_builders::RestoreDBInstanceToPointInTime::license_model) / [`set_license_model(Option<String>)`](crate::client::fluent_builders::RestoreDBInstanceToPointInTime::set_license_model): <p>License model information for the restored DB instance.</p>  <p>This setting doesn't apply to RDS Custom.</p>  <p>Default: Same as source.</p>  <p>Valid values: <code>license-included</code> | <code>bring-your-own-license</code> | <code>general-public-license</code> </p>
    ///   - [`db_name(impl Into<String>)`](crate::client::fluent_builders::RestoreDBInstanceToPointInTime::db_name) / [`set_db_name(Option<String>)`](crate::client::fluent_builders::RestoreDBInstanceToPointInTime::set_db_name): <p>The database name for the restored DB instance.</p> <note>   <p>This parameter isn't supported for the MySQL or MariaDB engines. It also doesn't apply to RDS Custom.</p>  </note>
    ///   - [`engine(impl Into<String>)`](crate::client::fluent_builders::RestoreDBInstanceToPointInTime::engine) / [`set_engine(Option<String>)`](crate::client::fluent_builders::RestoreDBInstanceToPointInTime::set_engine): <p>The database engine to use for the new instance.</p>  <p>This setting doesn't apply to RDS Custom.</p>  <p>Default: The same as source</p>  <p>Constraint: Must be compatible with the engine of the source</p>  <p>Valid Values:</p>  <ul>   <li> <p> <code>mariadb</code> </p> </li>   <li> <p> <code>mysql</code> </p> </li>   <li> <p> <code>oracle-ee</code> </p> </li>   <li> <p> <code>oracle-ee-cdb</code> </p> </li>   <li> <p> <code>oracle-se2</code> </p> </li>   <li> <p> <code>oracle-se2-cdb</code> </p> </li>   <li> <p> <code>postgres</code> </p> </li>   <li> <p> <code>sqlserver-ee</code> </p> </li>   <li> <p> <code>sqlserver-se</code> </p> </li>   <li> <p> <code>sqlserver-ex</code> </p> </li>   <li> <p> <code>sqlserver-web</code> </p> </li>  </ul>
    ///   - [`iops(i32)`](crate::client::fluent_builders::RestoreDBInstanceToPointInTime::iops) / [`set_iops(Option<i32>)`](crate::client::fluent_builders::RestoreDBInstanceToPointInTime::set_iops): <p>The amount of Provisioned IOPS (input/output operations per second) to be initially allocated for the DB instance.</p>  <p>Constraints: Must be an integer greater than 1000.</p>  <p> <b>SQL Server</b> </p>  <p>Setting the IOPS value for the SQL Server database engine isn't supported.</p>
    ///   - [`option_group_name(impl Into<String>)`](crate::client::fluent_builders::RestoreDBInstanceToPointInTime::option_group_name) / [`set_option_group_name(Option<String>)`](crate::client::fluent_builders::RestoreDBInstanceToPointInTime::set_option_group_name): <p>The name of the option group to be used for the restored DB instance.</p>  <p>Permanent options, such as the TDE option for Oracle Advanced Security TDE, can't be removed from an option group, and that option group can't be removed from a DB instance after it is associated with a DB instance</p>  <p>This setting doesn't apply to RDS Custom.</p>
    ///   - [`copy_tags_to_snapshot(bool)`](crate::client::fluent_builders::RestoreDBInstanceToPointInTime::copy_tags_to_snapshot) / [`set_copy_tags_to_snapshot(Option<bool>)`](crate::client::fluent_builders::RestoreDBInstanceToPointInTime::set_copy_tags_to_snapshot): <p>A value that indicates whether to copy all tags from the restored DB instance to snapshots of the DB instance. By default, tags are not copied.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::RestoreDBInstanceToPointInTime::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::RestoreDBInstanceToPointInTime::set_tags): <p>A list of tags. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources</a> in the <i>Amazon RDS User Guide.</i> </p>
    ///   - [`storage_type(impl Into<String>)`](crate::client::fluent_builders::RestoreDBInstanceToPointInTime::storage_type) / [`set_storage_type(Option<String>)`](crate::client::fluent_builders::RestoreDBInstanceToPointInTime::set_storage_type): <p>Specifies the storage type to be associated with the DB instance.</p>  <p>Valid values: <code>standard | gp2 | io1</code> </p>  <p>If you specify <code>io1</code>, you must also include a value for the <code>Iops</code> parameter.</p>  <p>Default: <code>io1</code> if the <code>Iops</code> parameter is specified, otherwise <code>gp2</code> </p>
    ///   - [`tde_credential_arn(impl Into<String>)`](crate::client::fluent_builders::RestoreDBInstanceToPointInTime::tde_credential_arn) / [`set_tde_credential_arn(Option<String>)`](crate::client::fluent_builders::RestoreDBInstanceToPointInTime::set_tde_credential_arn): <p>The ARN from the key store with which to associate the instance for TDE encryption.</p>  <p>This setting doesn't apply to RDS Custom.</p>
    ///   - [`tde_credential_password(impl Into<String>)`](crate::client::fluent_builders::RestoreDBInstanceToPointInTime::tde_credential_password) / [`set_tde_credential_password(Option<String>)`](crate::client::fluent_builders::RestoreDBInstanceToPointInTime::set_tde_credential_password): <p>The password for the given ARN from the key store in order to access the device.</p>  <p>This setting doesn't apply to RDS Custom.</p>
    ///   - [`vpc_security_group_ids(Vec<String>)`](crate::client::fluent_builders::RestoreDBInstanceToPointInTime::vpc_security_group_ids) / [`set_vpc_security_group_ids(Option<Vec<String>>)`](crate::client::fluent_builders::RestoreDBInstanceToPointInTime::set_vpc_security_group_ids): <p>A list of EC2 VPC security groups to associate with this DB instance.</p>  <p>Default: The default EC2 VPC security group for the DB subnet group's VPC.</p>
    ///   - [`domain(impl Into<String>)`](crate::client::fluent_builders::RestoreDBInstanceToPointInTime::domain) / [`set_domain(Option<String>)`](crate::client::fluent_builders::RestoreDBInstanceToPointInTime::set_domain): <p>Specify the Active Directory directory ID to restore the DB instance in. Create the domain before running this command. Currently, you can create only the MySQL, Microsoft SQL Server, Oracle, and PostgreSQL DB instances in an Active Directory Domain.</p>  <p>This setting doesn't apply to RDS Custom.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/kerberos-authentication.html"> Kerberos Authentication</a> in the <i>Amazon RDS User Guide</i>.</p>
    ///   - [`domain_iam_role_name(impl Into<String>)`](crate::client::fluent_builders::RestoreDBInstanceToPointInTime::domain_iam_role_name) / [`set_domain_iam_role_name(Option<String>)`](crate::client::fluent_builders::RestoreDBInstanceToPointInTime::set_domain_iam_role_name): <p>Specify the name of the IAM role to be used when making API calls to the Directory Service.</p>  <p>This setting doesn't apply to RDS Custom.</p>
    ///   - [`enable_iam_database_authentication(bool)`](crate::client::fluent_builders::RestoreDBInstanceToPointInTime::enable_iam_database_authentication) / [`set_enable_iam_database_authentication(Option<bool>)`](crate::client::fluent_builders::RestoreDBInstanceToPointInTime::set_enable_iam_database_authentication): <p>A value that indicates whether to enable mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts. By default, mapping isn't enabled.</p>  <p>This setting doesn't apply to RDS Custom.</p>  <p>For more information about IAM database authentication, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.html"> IAM Database Authentication for MySQL and PostgreSQL</a> in the <i>Amazon RDS User Guide.</i> </p>
    ///   - [`enable_cloudwatch_logs_exports(Vec<String>)`](crate::client::fluent_builders::RestoreDBInstanceToPointInTime::enable_cloudwatch_logs_exports) / [`set_enable_cloudwatch_logs_exports(Option<Vec<String>>)`](crate::client::fluent_builders::RestoreDBInstanceToPointInTime::set_enable_cloudwatch_logs_exports): <p>The list of logs that the restored DB instance is to export to CloudWatch Logs. The values in the list depend on the DB engine being used. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch">Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon RDS User Guide</i>.</p>  <p>This setting doesn't apply to RDS Custom.</p>
    ///   - [`processor_features(Vec<ProcessorFeature>)`](crate::client::fluent_builders::RestoreDBInstanceToPointInTime::processor_features) / [`set_processor_features(Option<Vec<ProcessorFeature>>)`](crate::client::fluent_builders::RestoreDBInstanceToPointInTime::set_processor_features): <p>The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.</p>  <p>This setting doesn't apply to RDS Custom.</p>
    ///   - [`use_default_processor_features(bool)`](crate::client::fluent_builders::RestoreDBInstanceToPointInTime::use_default_processor_features) / [`set_use_default_processor_features(Option<bool>)`](crate::client::fluent_builders::RestoreDBInstanceToPointInTime::set_use_default_processor_features): <p>A value that indicates whether the DB instance class of the DB instance uses its default processor features.</p>  <p>This setting doesn't apply to RDS Custom.</p>
    ///   - [`db_parameter_group_name(impl Into<String>)`](crate::client::fluent_builders::RestoreDBInstanceToPointInTime::db_parameter_group_name) / [`set_db_parameter_group_name(Option<String>)`](crate::client::fluent_builders::RestoreDBInstanceToPointInTime::set_db_parameter_group_name): <p>The name of the DB parameter group to associate with this DB instance.</p>  <p>If you do not specify a value for <code>DBParameterGroupName</code>, then the default <code>DBParameterGroup</code> for the specified DB engine is used.</p>  <p>This setting doesn't apply to RDS Custom.</p>  <p>Constraints:</p>  <ul>   <li> <p>If supplied, must match the name of an existing DBParameterGroup.</p> </li>   <li> <p>Must be 1 to 255 letters, numbers, or hyphens.</p> </li>   <li> <p>First character must be a letter.</p> </li>   <li> <p>Can't end with a hyphen or contain two consecutive hyphens.</p> </li>  </ul>
    ///   - [`deletion_protection(bool)`](crate::client::fluent_builders::RestoreDBInstanceToPointInTime::deletion_protection) / [`set_deletion_protection(Option<bool>)`](crate::client::fluent_builders::RestoreDBInstanceToPointInTime::set_deletion_protection): <p>A value that indicates whether the DB instance has deletion protection enabled. The database can't be deleted when deletion protection is enabled. By default, deletion protection isn't enabled. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html"> Deleting a DB Instance</a>.</p>
    ///   - [`source_dbi_resource_id(impl Into<String>)`](crate::client::fluent_builders::RestoreDBInstanceToPointInTime::source_dbi_resource_id) / [`set_source_dbi_resource_id(Option<String>)`](crate::client::fluent_builders::RestoreDBInstanceToPointInTime::set_source_dbi_resource_id): <p>The resource ID of the source DB instance from which to restore.</p>
    ///   - [`max_allocated_storage(i32)`](crate::client::fluent_builders::RestoreDBInstanceToPointInTime::max_allocated_storage) / [`set_max_allocated_storage(Option<i32>)`](crate::client::fluent_builders::RestoreDBInstanceToPointInTime::set_max_allocated_storage): <p>The upper limit in gibibytes (GiB) to which Amazon RDS can automatically scale the storage of the DB instance.</p>  <p>For more information about this setting, including limitations that apply to it, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIOPS.StorageTypes.html#USER_PIOPS.Autoscaling"> Managing capacity automatically with Amazon RDS storage autoscaling</a> in the <i>Amazon RDS User Guide</i>.</p>  <p>This setting doesn't apply to RDS Custom.</p>
    ///   - [`source_db_instance_automated_backups_arn(impl Into<String>)`](crate::client::fluent_builders::RestoreDBInstanceToPointInTime::source_db_instance_automated_backups_arn) / [`set_source_db_instance_automated_backups_arn(Option<String>)`](crate::client::fluent_builders::RestoreDBInstanceToPointInTime::set_source_db_instance_automated_backups_arn): <p>The Amazon Resource Name (ARN) of the replicated automated backups from which to restore, for example, <code>arn:aws:rds:useast-1:123456789012:auto-backup:ab-L2IJCEXJP7XQ7HOJ4SIEXAMPLE</code>.</p>  <p>This setting doesn't apply to RDS Custom.</p>
    ///   - [`enable_customer_owned_ip(bool)`](crate::client::fluent_builders::RestoreDBInstanceToPointInTime::enable_customer_owned_ip) / [`set_enable_customer_owned_ip(Option<bool>)`](crate::client::fluent_builders::RestoreDBInstanceToPointInTime::set_enable_customer_owned_ip): <p>A value that indicates whether to enable a customer-owned IP address (CoIP) for an RDS on Outposts DB instance.</p>  <p>A <i>CoIP</i> provides local or external connectivity to resources in your Outpost subnets through your on-premises network. For some use cases, a CoIP can provide lower latency for connections to the DB instance from outside of its virtual private cloud (VPC) on your local network.</p>  <p>This setting doesn't apply to RDS Custom.</p>  <p>For more information about RDS on Outposts, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html">Working with Amazon RDS on Amazon Web Services Outposts</a> in the <i>Amazon RDS User Guide</i>.</p>  <p>For more information about CoIPs, see <a href="https://docs.aws.amazon.com/outposts/latest/userguide/outposts-networking-components.html#ip-addressing">Customer-owned IP addresses</a> in the <i>Amazon Web Services Outposts User Guide</i>.</p>
    ///   - [`custom_iam_instance_profile(impl Into<String>)`](crate::client::fluent_builders::RestoreDBInstanceToPointInTime::custom_iam_instance_profile) / [`set_custom_iam_instance_profile(Option<String>)`](crate::client::fluent_builders::RestoreDBInstanceToPointInTime::set_custom_iam_instance_profile): <p>The instance profile associated with the underlying Amazon EC2 instance of an RDS Custom DB instance. The instance profile must meet the following requirements:</p>  <ul>   <li> <p>The profile must exist in your account.</p> </li>   <li> <p>The profile must have an IAM role that Amazon EC2 has permissions to assume.</p> </li>   <li> <p>The instance profile name and the associated IAM role name must start with the prefix <code>AWSRDSCustom</code>.</p> </li>  </ul>  <p>For the list of permissions required for the IAM role, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-setup-orcl.html#custom-setup-orcl.iam-vpc"> Configure IAM and your VPC</a> in the <i>Amazon RDS User Guide</i>.</p>  <p>This setting is required for RDS Custom.</p>
    ///   - [`backup_target(impl Into<String>)`](crate::client::fluent_builders::RestoreDBInstanceToPointInTime::backup_target) / [`set_backup_target(Option<String>)`](crate::client::fluent_builders::RestoreDBInstanceToPointInTime::set_backup_target): <p>Specifies where automated backups and manual snapshots are stored for the restored DB instance.</p>  <p>Possible values are <code>outposts</code> (Amazon Web Services Outposts) and <code>region</code> (Amazon Web Services Region). The default is <code>region</code>.</p>  <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html">Working with Amazon RDS on Amazon Web Services Outposts</a> in the <i>Amazon RDS User Guide</i>.</p>
    /// - On success, responds with [`RestoreDbInstanceToPointInTimeOutput`](crate::output::RestoreDbInstanceToPointInTimeOutput) with field(s):
    ///   - [`db_instance(Option<DbInstance>)`](crate::output::RestoreDbInstanceToPointInTimeOutput::db_instance): <p>Contains the details of an Amazon RDS DB instance.</p>  <p>This data type is used as a response element in the operations <code>CreateDBInstance</code>, <code>CreateDBInstanceReadReplica</code>, <code>DeleteDBInstance</code>, <code>DescribeDBInstances</code>, <code>ModifyDBInstance</code>, <code>PromoteReadReplica</code>, <code>RebootDBInstance</code>, <code>RestoreDBInstanceFromDBSnapshot</code>, <code>RestoreDBInstanceFromS3</code>, <code>RestoreDBInstanceToPointInTime</code>, <code>StartDBInstance</code>, and <code>StopDBInstance</code>.</p>
    /// - On failure, responds with [`SdkError<RestoreDBInstanceToPointInTimeError>`](crate::error::RestoreDBInstanceToPointInTimeError)
    pub fn restore_db_instance_to_point_in_time(
        &self,
    ) -> fluent_builders::RestoreDBInstanceToPointInTime {
        fluent_builders::RestoreDBInstanceToPointInTime::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RevokeDBSecurityGroupIngress`](crate::client::fluent_builders::RevokeDBSecurityGroupIngress) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_security_group_name(impl Into<String>)`](crate::client::fluent_builders::RevokeDBSecurityGroupIngress::db_security_group_name) / [`set_db_security_group_name(Option<String>)`](crate::client::fluent_builders::RevokeDBSecurityGroupIngress::set_db_security_group_name): <p>The name of the DB security group to revoke ingress from.</p>
    ///   - [`cidrip(impl Into<String>)`](crate::client::fluent_builders::RevokeDBSecurityGroupIngress::cidrip) / [`set_cidrip(Option<String>)`](crate::client::fluent_builders::RevokeDBSecurityGroupIngress::set_cidrip): <p>The IP range to revoke access from. Must be a valid CIDR range. If <code>CIDRIP</code> is specified, <code>EC2SecurityGroupName</code>, <code>EC2SecurityGroupId</code> and <code>EC2SecurityGroupOwnerId</code> can't be provided.</p>
    ///   - [`ec2_security_group_name(impl Into<String>)`](crate::client::fluent_builders::RevokeDBSecurityGroupIngress::ec2_security_group_name) / [`set_ec2_security_group_name(Option<String>)`](crate::client::fluent_builders::RevokeDBSecurityGroupIngress::set_ec2_security_group_name): <p>The name of the EC2 security group to revoke access from. For VPC DB security groups, <code>EC2SecurityGroupId</code> must be provided. Otherwise, EC2SecurityGroupOwnerId and either <code>EC2SecurityGroupName</code> or <code>EC2SecurityGroupId</code> must be provided.</p>
    ///   - [`ec2_security_group_id(impl Into<String>)`](crate::client::fluent_builders::RevokeDBSecurityGroupIngress::ec2_security_group_id) / [`set_ec2_security_group_id(Option<String>)`](crate::client::fluent_builders::RevokeDBSecurityGroupIngress::set_ec2_security_group_id): <p>The id of the EC2 security group to revoke access from. For VPC DB security groups, <code>EC2SecurityGroupId</code> must be provided. Otherwise, EC2SecurityGroupOwnerId and either <code>EC2SecurityGroupName</code> or <code>EC2SecurityGroupId</code> must be provided.</p>
    ///   - [`ec2_security_group_owner_id(impl Into<String>)`](crate::client::fluent_builders::RevokeDBSecurityGroupIngress::ec2_security_group_owner_id) / [`set_ec2_security_group_owner_id(Option<String>)`](crate::client::fluent_builders::RevokeDBSecurityGroupIngress::set_ec2_security_group_owner_id): <p>The Amazon Web Services account number of the owner of the EC2 security group specified in the <code>EC2SecurityGroupName</code> parameter. The Amazon Web Services access key ID isn't an acceptable value. For VPC DB security groups, <code>EC2SecurityGroupId</code> must be provided. Otherwise, EC2SecurityGroupOwnerId and either <code>EC2SecurityGroupName</code> or <code>EC2SecurityGroupId</code> must be provided.</p>
    /// - On success, responds with [`RevokeDbSecurityGroupIngressOutput`](crate::output::RevokeDbSecurityGroupIngressOutput) with field(s):
    ///   - [`db_security_group(Option<DbSecurityGroup>)`](crate::output::RevokeDbSecurityGroupIngressOutput::db_security_group): <p>Contains the details for an Amazon RDS DB security group.</p>  <p>This data type is used as a response element in the <code>DescribeDBSecurityGroups</code> action.</p>
    /// - On failure, responds with [`SdkError<RevokeDBSecurityGroupIngressError>`](crate::error::RevokeDBSecurityGroupIngressError)
    pub fn revoke_db_security_group_ingress(
        &self,
    ) -> fluent_builders::RevokeDBSecurityGroupIngress {
        fluent_builders::RevokeDBSecurityGroupIngress::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartActivityStream`](crate::client::fluent_builders::StartActivityStream) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::StartActivityStream::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::StartActivityStream::set_resource_arn): <p>The Amazon Resource Name (ARN) of the DB cluster, for example, <code>arn:aws:rds:us-east-1:12345667890:cluster:das-cluster</code>.</p>
    ///   - [`mode(ActivityStreamMode)`](crate::client::fluent_builders::StartActivityStream::mode) / [`set_mode(Option<ActivityStreamMode>)`](crate::client::fluent_builders::StartActivityStream::set_mode): <p>Specifies the mode of the database activity stream. Database events such as a change or access generate an activity stream event. The database session can handle these events either synchronously or asynchronously.</p>
    ///   - [`kms_key_id(impl Into<String>)`](crate::client::fluent_builders::StartActivityStream::kms_key_id) / [`set_kms_key_id(Option<String>)`](crate::client::fluent_builders::StartActivityStream::set_kms_key_id): <p>The Amazon Web Services KMS key identifier for encrypting messages in the database activity stream. The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.</p>
    ///   - [`apply_immediately(bool)`](crate::client::fluent_builders::StartActivityStream::apply_immediately) / [`set_apply_immediately(Option<bool>)`](crate::client::fluent_builders::StartActivityStream::set_apply_immediately): <p>Specifies whether or not the database activity stream is to start as soon as possible, regardless of the maintenance window for the database.</p>
    ///   - [`engine_native_audit_fields_included(bool)`](crate::client::fluent_builders::StartActivityStream::engine_native_audit_fields_included) / [`set_engine_native_audit_fields_included(Option<bool>)`](crate::client::fluent_builders::StartActivityStream::set_engine_native_audit_fields_included): <p>Specifies whether the database activity stream includes engine-native audit fields. This option only applies to an Oracle DB instance. By default, no engine-native audit fields are included.</p>
    /// - On success, responds with [`StartActivityStreamOutput`](crate::output::StartActivityStreamOutput) with field(s):
    ///   - [`kms_key_id(Option<String>)`](crate::output::StartActivityStreamOutput::kms_key_id): <p>The Amazon Web Services KMS key identifier for encryption of messages in the database activity stream.</p>
    ///   - [`kinesis_stream_name(Option<String>)`](crate::output::StartActivityStreamOutput::kinesis_stream_name): <p>The name of the Amazon Kinesis data stream to be used for the database activity stream.</p>
    ///   - [`status(Option<ActivityStreamStatus>)`](crate::output::StartActivityStreamOutput::status): <p>The status of the database activity stream.</p>
    ///   - [`mode(Option<ActivityStreamMode>)`](crate::output::StartActivityStreamOutput::mode): <p>The mode of the database activity stream.</p>
    ///   - [`apply_immediately(bool)`](crate::output::StartActivityStreamOutput::apply_immediately): <p>Indicates whether or not the database activity stream will start as soon as possible, regardless of the maintenance window for the database.</p>
    ///   - [`engine_native_audit_fields_included(Option<bool>)`](crate::output::StartActivityStreamOutput::engine_native_audit_fields_included): <p>Indicates whether engine-native audit fields are included in the database activity stream.</p>
    /// - On failure, responds with [`SdkError<StartActivityStreamError>`](crate::error::StartActivityStreamError)
    pub fn start_activity_stream(&self) -> fluent_builders::StartActivityStream {
        fluent_builders::StartActivityStream::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartDBCluster`](crate::client::fluent_builders::StartDBCluster) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_cluster_identifier(impl Into<String>)`](crate::client::fluent_builders::StartDBCluster::db_cluster_identifier) / [`set_db_cluster_identifier(Option<String>)`](crate::client::fluent_builders::StartDBCluster::set_db_cluster_identifier): <p>The DB cluster identifier of the Amazon Aurora DB cluster to be started. This parameter is stored as a lowercase string.</p>
    /// - On success, responds with [`StartDbClusterOutput`](crate::output::StartDbClusterOutput) with field(s):
    ///   - [`db_cluster(Option<DbCluster>)`](crate::output::StartDbClusterOutput::db_cluster): <p>Contains the details of an Amazon Aurora DB cluster or Multi-AZ DB cluster.</p>  <p>For an Amazon Aurora DB cluster, this data type is used as a response element in the operations <code>CreateDBCluster</code>, <code>DeleteDBCluster</code>, <code>DescribeDBClusters</code>, <code>FailoverDBCluster</code>, <code>ModifyDBCluster</code>, <code>PromoteReadReplicaDBCluster</code>, <code>RestoreDBClusterFromS3</code>, <code>RestoreDBClusterFromSnapshot</code>, <code>RestoreDBClusterToPointInTime</code>, <code>StartDBCluster</code>, and <code>StopDBCluster</code>.</p>  <p>For a Multi-AZ DB cluster, this data type is used as a response element in the operations <code>CreateDBCluster</code>, <code>DeleteDBCluster</code>, <code>DescribeDBClusters</code>, <code>FailoverDBCluster</code>, <code>ModifyDBCluster</code>, <code>RebootDBCluster</code>, <code>RestoreDBClusterFromSnapshot</code>, and <code>RestoreDBClusterToPointInTime</code>.</p>  <p>For more information on Amazon Aurora DB clusters, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon Aurora?</a> in the <i>Amazon Aurora User Guide.</i> </p>  <p>For more information on Multi-AZ DB clusters, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ deployments with two readable standby DB instances</a> in the <i>Amazon RDS User Guide.</i> </p>
    /// - On failure, responds with [`SdkError<StartDBClusterError>`](crate::error::StartDBClusterError)
    pub fn start_db_cluster(&self) -> fluent_builders::StartDBCluster {
        fluent_builders::StartDBCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartDBInstance`](crate::client::fluent_builders::StartDBInstance) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_instance_identifier(impl Into<String>)`](crate::client::fluent_builders::StartDBInstance::db_instance_identifier) / [`set_db_instance_identifier(Option<String>)`](crate::client::fluent_builders::StartDBInstance::set_db_instance_identifier): <p>The user-supplied instance identifier.</p>
    /// - On success, responds with [`StartDbInstanceOutput`](crate::output::StartDbInstanceOutput) with field(s):
    ///   - [`db_instance(Option<DbInstance>)`](crate::output::StartDbInstanceOutput::db_instance): <p>Contains the details of an Amazon RDS DB instance.</p>  <p>This data type is used as a response element in the operations <code>CreateDBInstance</code>, <code>CreateDBInstanceReadReplica</code>, <code>DeleteDBInstance</code>, <code>DescribeDBInstances</code>, <code>ModifyDBInstance</code>, <code>PromoteReadReplica</code>, <code>RebootDBInstance</code>, <code>RestoreDBInstanceFromDBSnapshot</code>, <code>RestoreDBInstanceFromS3</code>, <code>RestoreDBInstanceToPointInTime</code>, <code>StartDBInstance</code>, and <code>StopDBInstance</code>.</p>
    /// - On failure, responds with [`SdkError<StartDBInstanceError>`](crate::error::StartDBInstanceError)
    pub fn start_db_instance(&self) -> fluent_builders::StartDBInstance {
        fluent_builders::StartDBInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartDBInstanceAutomatedBackupsReplication`](crate::client::fluent_builders::StartDBInstanceAutomatedBackupsReplication) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`source_db_instance_arn(impl Into<String>)`](crate::client::fluent_builders::StartDBInstanceAutomatedBackupsReplication::source_db_instance_arn) / [`set_source_db_instance_arn(Option<String>)`](crate::client::fluent_builders::StartDBInstanceAutomatedBackupsReplication::set_source_db_instance_arn): <p>The Amazon Resource Name (ARN) of the source DB instance for the replicated automated backups, for example, <code>arn:aws:rds:us-west-2:123456789012:db:mydatabase</code>.</p>
    ///   - [`backup_retention_period(i32)`](crate::client::fluent_builders::StartDBInstanceAutomatedBackupsReplication::backup_retention_period) / [`set_backup_retention_period(Option<i32>)`](crate::client::fluent_builders::StartDBInstanceAutomatedBackupsReplication::set_backup_retention_period): <p>The retention period for the replicated automated backups.</p>
    ///   - [`kms_key_id(impl Into<String>)`](crate::client::fluent_builders::StartDBInstanceAutomatedBackupsReplication::kms_key_id) / [`set_kms_key_id(Option<String>)`](crate::client::fluent_builders::StartDBInstanceAutomatedBackupsReplication::set_kms_key_id): <p>The Amazon Web Services KMS key identifier for encryption of the replicated automated backups. The KMS key ID is the Amazon Resource Name (ARN) for the KMS encryption key in the destination Amazon Web Services Region, for example, <code>arn:aws:kms:us-east-1:123456789012:key/AKIAIOSFODNN7EXAMPLE</code>.</p>
    ///   - [`pre_signed_url(impl Into<String>)`](crate::client::fluent_builders::StartDBInstanceAutomatedBackupsReplication::pre_signed_url) / [`set_pre_signed_url(Option<String>)`](crate::client::fluent_builders::StartDBInstanceAutomatedBackupsReplication::set_pre_signed_url): <p>A URL that contains a Signature Version 4 signed request for the StartDBInstanceAutomatedBackupsReplication action to be called in the Amazon Web Services Region of the source DB instance. The presigned URL must be a valid request for the StartDBInstanceAutomatedBackupsReplication API action that can be executed in the Amazon Web Services Region that contains the source DB instance.</p>
    /// - On success, responds with [`StartDbInstanceAutomatedBackupsReplicationOutput`](crate::output::StartDbInstanceAutomatedBackupsReplicationOutput) with field(s):
    ///   - [`db_instance_automated_backup(Option<DbInstanceAutomatedBackup>)`](crate::output::StartDbInstanceAutomatedBackupsReplicationOutput::db_instance_automated_backup): <p>An automated backup of a DB instance. It consists of system backups, transaction logs, and the database instance properties that existed at the time you deleted the source instance.</p>
    /// - On failure, responds with [`SdkError<StartDBInstanceAutomatedBackupsReplicationError>`](crate::error::StartDBInstanceAutomatedBackupsReplicationError)
    pub fn start_db_instance_automated_backups_replication(
        &self,
    ) -> fluent_builders::StartDBInstanceAutomatedBackupsReplication {
        fluent_builders::StartDBInstanceAutomatedBackupsReplication::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartExportTask`](crate::client::fluent_builders::StartExportTask) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`export_task_identifier(impl Into<String>)`](crate::client::fluent_builders::StartExportTask::export_task_identifier) / [`set_export_task_identifier(Option<String>)`](crate::client::fluent_builders::StartExportTask::set_export_task_identifier): <p>A unique identifier for the snapshot export task. This ID isn't an identifier for the Amazon S3 bucket where the snapshot is to be exported to.</p>
    ///   - [`source_arn(impl Into<String>)`](crate::client::fluent_builders::StartExportTask::source_arn) / [`set_source_arn(Option<String>)`](crate::client::fluent_builders::StartExportTask::set_source_arn): <p>The Amazon Resource Name (ARN) of the snapshot to export to Amazon S3.</p>
    ///   - [`s3_bucket_name(impl Into<String>)`](crate::client::fluent_builders::StartExportTask::s3_bucket_name) / [`set_s3_bucket_name(Option<String>)`](crate::client::fluent_builders::StartExportTask::set_s3_bucket_name): <p>The name of the Amazon S3 bucket to export the snapshot to.</p>
    ///   - [`iam_role_arn(impl Into<String>)`](crate::client::fluent_builders::StartExportTask::iam_role_arn) / [`set_iam_role_arn(Option<String>)`](crate::client::fluent_builders::StartExportTask::set_iam_role_arn): <p>The name of the IAM role to use for writing to the Amazon S3 bucket when exporting a snapshot.</p>
    ///   - [`kms_key_id(impl Into<String>)`](crate::client::fluent_builders::StartExportTask::kms_key_id) / [`set_kms_key_id(Option<String>)`](crate::client::fluent_builders::StartExportTask::set_kms_key_id): <p>The ID of the Amazon Web Services KMS key to use to encrypt the snapshot exported to Amazon S3. The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key. The caller of this operation must be authorized to execute the following operations. These can be set in the Amazon Web Services KMS key policy:</p>  <ul>   <li> <p>GrantOperation.Encrypt</p> </li>   <li> <p>GrantOperation.Decrypt</p> </li>   <li> <p>GrantOperation.GenerateDataKey</p> </li>   <li> <p>GrantOperation.GenerateDataKeyWithoutPlaintext</p> </li>   <li> <p>GrantOperation.ReEncryptFrom</p> </li>   <li> <p>GrantOperation.ReEncryptTo</p> </li>   <li> <p>GrantOperation.CreateGrant</p> </li>   <li> <p>GrantOperation.DescribeKey</p> </li>   <li> <p>GrantOperation.RetireGrant</p> </li>  </ul>
    ///   - [`s3_prefix(impl Into<String>)`](crate::client::fluent_builders::StartExportTask::s3_prefix) / [`set_s3_prefix(Option<String>)`](crate::client::fluent_builders::StartExportTask::set_s3_prefix): <p>The Amazon S3 bucket prefix to use as the file name and path of the exported snapshot.</p>
    ///   - [`export_only(Vec<String>)`](crate::client::fluent_builders::StartExportTask::export_only) / [`set_export_only(Option<Vec<String>>)`](crate::client::fluent_builders::StartExportTask::set_export_only): <p>The data to be exported from the snapshot. If this parameter is not provided, all the snapshot data is exported. Valid values are the following:</p>  <ul>   <li> <p> <code>database</code> - Export all the data from a specified database.</p> </li>   <li> <p> <code>database.table</code> <i>table-name</i> - Export a table of the snapshot. This format is valid only for RDS for MySQL, RDS for MariaDB, and Aurora MySQL.</p> </li>   <li> <p> <code>database.schema</code> <i>schema-name</i> - Export a database schema of the snapshot. This format is valid only for RDS for PostgreSQL and Aurora PostgreSQL.</p> </li>   <li> <p> <code>database.schema.table</code> <i>table-name</i> - Export a table of the database schema. This format is valid only for RDS for PostgreSQL and Aurora PostgreSQL.</p> </li>  </ul>
    /// - On success, responds with [`StartExportTaskOutput`](crate::output::StartExportTaskOutput) with field(s):
    ///   - [`export_task_identifier(Option<String>)`](crate::output::StartExportTaskOutput::export_task_identifier): <p>A unique identifier for the snapshot export task. This ID isn't an identifier for the Amazon S3 bucket where the snapshot is exported to.</p>
    ///   - [`source_arn(Option<String>)`](crate::output::StartExportTaskOutput::source_arn): <p>The Amazon Resource Name (ARN) of the snapshot exported to Amazon S3.</p>
    ///   - [`export_only(Option<Vec<String>>)`](crate::output::StartExportTaskOutput::export_only): <p>The data exported from the snapshot. Valid values are the following:</p>  <ul>   <li> <p> <code>database</code> - Export all the data from a specified database.</p> </li>   <li> <p> <code>database.table</code> <i>table-name</i> - Export a table of the snapshot. This format is valid only for RDS for MySQL, RDS for MariaDB, and Aurora MySQL.</p> </li>   <li> <p> <code>database.schema</code> <i>schema-name</i> - Export a database schema of the snapshot. This format is valid only for RDS for PostgreSQL and Aurora PostgreSQL.</p> </li>   <li> <p> <code>database.schema.table</code> <i>table-name</i> - Export a table of the database schema. This format is valid only for RDS for PostgreSQL and Aurora PostgreSQL.</p> </li>  </ul>
    ///   - [`snapshot_time(Option<DateTime>)`](crate::output::StartExportTaskOutput::snapshot_time): <p>The time that the snapshot was created.</p>
    ///   - [`task_start_time(Option<DateTime>)`](crate::output::StartExportTaskOutput::task_start_time): <p>The time that the snapshot export task started.</p>
    ///   - [`task_end_time(Option<DateTime>)`](crate::output::StartExportTaskOutput::task_end_time): <p>The time that the snapshot export task completed.</p>
    ///   - [`s3_bucket(Option<String>)`](crate::output::StartExportTaskOutput::s3_bucket): <p>The Amazon S3 bucket that the snapshot is exported to.</p>
    ///   - [`s3_prefix(Option<String>)`](crate::output::StartExportTaskOutput::s3_prefix): <p>The Amazon S3 bucket prefix that is the file name and path of the exported snapshot.</p>
    ///   - [`iam_role_arn(Option<String>)`](crate::output::StartExportTaskOutput::iam_role_arn): <p>The name of the IAM role that is used to write to Amazon S3 when exporting a snapshot.</p>
    ///   - [`kms_key_id(Option<String>)`](crate::output::StartExportTaskOutput::kms_key_id): <p>The key identifier of the Amazon Web Services KMS key that is used to encrypt the snapshot when it's exported to Amazon S3. The KMS key identifier is its key ARN, key ID, alias ARN, or alias name. The IAM role used for the snapshot export must have encryption and decryption permissions to use this KMS key.</p>
    ///   - [`status(Option<String>)`](crate::output::StartExportTaskOutput::status): <p>The progress status of the export task.</p>
    ///   - [`percent_progress(i32)`](crate::output::StartExportTaskOutput::percent_progress): <p>The progress of the snapshot export task as a percentage.</p>
    ///   - [`total_extracted_data_in_gb(i32)`](crate::output::StartExportTaskOutput::total_extracted_data_in_gb): <p>The total amount of data exported, in gigabytes.</p>
    ///   - [`failure_cause(Option<String>)`](crate::output::StartExportTaskOutput::failure_cause): <p>The reason the export failed, if it failed.</p>
    ///   - [`warning_message(Option<String>)`](crate::output::StartExportTaskOutput::warning_message): <p>A warning about the snapshot export task.</p>
    /// - On failure, responds with [`SdkError<StartExportTaskError>`](crate::error::StartExportTaskError)
    pub fn start_export_task(&self) -> fluent_builders::StartExportTask {
        fluent_builders::StartExportTask::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StopActivityStream`](crate::client::fluent_builders::StopActivityStream) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::StopActivityStream::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::StopActivityStream::set_resource_arn): <p>The Amazon Resource Name (ARN) of the DB cluster for the database activity stream. For example, <code>arn:aws:rds:us-east-1:12345667890:cluster:das-cluster</code>.</p>
    ///   - [`apply_immediately(bool)`](crate::client::fluent_builders::StopActivityStream::apply_immediately) / [`set_apply_immediately(Option<bool>)`](crate::client::fluent_builders::StopActivityStream::set_apply_immediately): <p>Specifies whether or not the database activity stream is to stop as soon as possible, regardless of the maintenance window for the database.</p>
    /// - On success, responds with [`StopActivityStreamOutput`](crate::output::StopActivityStreamOutput) with field(s):
    ///   - [`kms_key_id(Option<String>)`](crate::output::StopActivityStreamOutput::kms_key_id): <p>The Amazon Web Services KMS key identifier used for encrypting messages in the database activity stream.</p>  <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.</p>
    ///   - [`kinesis_stream_name(Option<String>)`](crate::output::StopActivityStreamOutput::kinesis_stream_name): <p>The name of the Amazon Kinesis data stream used for the database activity stream.</p>
    ///   - [`status(Option<ActivityStreamStatus>)`](crate::output::StopActivityStreamOutput::status): <p>The status of the database activity stream.</p>
    /// - On failure, responds with [`SdkError<StopActivityStreamError>`](crate::error::StopActivityStreamError)
    pub fn stop_activity_stream(&self) -> fluent_builders::StopActivityStream {
        fluent_builders::StopActivityStream::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StopDBCluster`](crate::client::fluent_builders::StopDBCluster) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_cluster_identifier(impl Into<String>)`](crate::client::fluent_builders::StopDBCluster::db_cluster_identifier) / [`set_db_cluster_identifier(Option<String>)`](crate::client::fluent_builders::StopDBCluster::set_db_cluster_identifier): <p>The DB cluster identifier of the Amazon Aurora DB cluster to be stopped. This parameter is stored as a lowercase string.</p>
    /// - On success, responds with [`StopDbClusterOutput`](crate::output::StopDbClusterOutput) with field(s):
    ///   - [`db_cluster(Option<DbCluster>)`](crate::output::StopDbClusterOutput::db_cluster): <p>Contains the details of an Amazon Aurora DB cluster or Multi-AZ DB cluster.</p>  <p>For an Amazon Aurora DB cluster, this data type is used as a response element in the operations <code>CreateDBCluster</code>, <code>DeleteDBCluster</code>, <code>DescribeDBClusters</code>, <code>FailoverDBCluster</code>, <code>ModifyDBCluster</code>, <code>PromoteReadReplicaDBCluster</code>, <code>RestoreDBClusterFromS3</code>, <code>RestoreDBClusterFromSnapshot</code>, <code>RestoreDBClusterToPointInTime</code>, <code>StartDBCluster</code>, and <code>StopDBCluster</code>.</p>  <p>For a Multi-AZ DB cluster, this data type is used as a response element in the operations <code>CreateDBCluster</code>, <code>DeleteDBCluster</code>, <code>DescribeDBClusters</code>, <code>FailoverDBCluster</code>, <code>ModifyDBCluster</code>, <code>RebootDBCluster</code>, <code>RestoreDBClusterFromSnapshot</code>, and <code>RestoreDBClusterToPointInTime</code>.</p>  <p>For more information on Amazon Aurora DB clusters, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon Aurora?</a> in the <i>Amazon Aurora User Guide.</i> </p>  <p>For more information on Multi-AZ DB clusters, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ deployments with two readable standby DB instances</a> in the <i>Amazon RDS User Guide.</i> </p>
    /// - On failure, responds with [`SdkError<StopDBClusterError>`](crate::error::StopDBClusterError)
    pub fn stop_db_cluster(&self) -> fluent_builders::StopDBCluster {
        fluent_builders::StopDBCluster::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StopDBInstance`](crate::client::fluent_builders::StopDBInstance) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`db_instance_identifier(impl Into<String>)`](crate::client::fluent_builders::StopDBInstance::db_instance_identifier) / [`set_db_instance_identifier(Option<String>)`](crate::client::fluent_builders::StopDBInstance::set_db_instance_identifier): <p>The user-supplied instance identifier.</p>
    ///   - [`db_snapshot_identifier(impl Into<String>)`](crate::client::fluent_builders::StopDBInstance::db_snapshot_identifier) / [`set_db_snapshot_identifier(Option<String>)`](crate::client::fluent_builders::StopDBInstance::set_db_snapshot_identifier): <p>The user-supplied instance identifier of the DB Snapshot created immediately before the DB instance is stopped.</p>
    /// - On success, responds with [`StopDbInstanceOutput`](crate::output::StopDbInstanceOutput) with field(s):
    ///   - [`db_instance(Option<DbInstance>)`](crate::output::StopDbInstanceOutput::db_instance): <p>Contains the details of an Amazon RDS DB instance.</p>  <p>This data type is used as a response element in the operations <code>CreateDBInstance</code>, <code>CreateDBInstanceReadReplica</code>, <code>DeleteDBInstance</code>, <code>DescribeDBInstances</code>, <code>ModifyDBInstance</code>, <code>PromoteReadReplica</code>, <code>RebootDBInstance</code>, <code>RestoreDBInstanceFromDBSnapshot</code>, <code>RestoreDBInstanceFromS3</code>, <code>RestoreDBInstanceToPointInTime</code>, <code>StartDBInstance</code>, and <code>StopDBInstance</code>.</p>
    /// - On failure, responds with [`SdkError<StopDBInstanceError>`](crate::error::StopDBInstanceError)
    pub fn stop_db_instance(&self) -> fluent_builders::StopDBInstance {
        fluent_builders::StopDBInstance::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StopDBInstanceAutomatedBackupsReplication`](crate::client::fluent_builders::StopDBInstanceAutomatedBackupsReplication) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`source_db_instance_arn(impl Into<String>)`](crate::client::fluent_builders::StopDBInstanceAutomatedBackupsReplication::source_db_instance_arn) / [`set_source_db_instance_arn(Option<String>)`](crate::client::fluent_builders::StopDBInstanceAutomatedBackupsReplication::set_source_db_instance_arn): <p>The Amazon Resource Name (ARN) of the source DB instance for which to stop replicating automated backups, for example, <code>arn:aws:rds:us-west-2:123456789012:db:mydatabase</code>.</p>
    /// - On success, responds with [`StopDbInstanceAutomatedBackupsReplicationOutput`](crate::output::StopDbInstanceAutomatedBackupsReplicationOutput) with field(s):
    ///   - [`db_instance_automated_backup(Option<DbInstanceAutomatedBackup>)`](crate::output::StopDbInstanceAutomatedBackupsReplicationOutput::db_instance_automated_backup): <p>An automated backup of a DB instance. It consists of system backups, transaction logs, and the database instance properties that existed at the time you deleted the source instance.</p>
    /// - On failure, responds with [`SdkError<StopDBInstanceAutomatedBackupsReplicationError>`](crate::error::StopDBInstanceAutomatedBackupsReplicationError)
    pub fn stop_db_instance_automated_backups_replication(
        &self,
    ) -> fluent_builders::StopDBInstanceAutomatedBackupsReplication {
        fluent_builders::StopDBInstanceAutomatedBackupsReplication::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AddRoleToDBCluster`.
    ///
    /// <p>Associates an Identity and Access Management (IAM) role with a DB cluster.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AddRoleToDBCluster {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::add_role_to_db_cluster_input::Builder,
    }
    impl AddRoleToDBCluster {
        /// Creates a new `AddRoleToDBCluster`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AddRoleToDbClusterOutput,
            aws_smithy_http::result::SdkError<crate::error::AddRoleToDBClusterError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the DB cluster to associate the IAM role with.</p>
        pub fn db_cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_cluster_identifier(input.into());
            self
        }
        /// <p>The name of the DB cluster to associate the IAM role with.</p>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_identifier(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role to associate with the Aurora DB cluster, for example <code>arn:aws:iam::123456789012:role/AuroraAccessRole</code>.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role to associate with the Aurora DB cluster, for example <code>arn:aws:iam::123456789012:role/AuroraAccessRole</code>.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// <p>The name of the feature for the DB cluster that the IAM role is to be associated with. For information about supported feature names, see <code>DBEngineVersion</code>.</p>
        pub fn feature_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.feature_name(input.into());
            self
        }
        /// <p>The name of the feature for the DB cluster that the IAM role is to be associated with. For information about supported feature names, see <code>DBEngineVersion</code>.</p>
        pub fn set_feature_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_feature_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AddRoleToDBInstance`.
    ///
    /// <p>Associates an Amazon Web Services Identity and Access Management (IAM) role with a DB instance.</p> <note>
    /// <p>To add a role to a DB instance, the status of the DB instance must be <code>available</code>.</p>
    /// </note>
    /// <p>This command doesn't apply to RDS Custom.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AddRoleToDBInstance {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::add_role_to_db_instance_input::Builder,
    }
    impl AddRoleToDBInstance {
        /// Creates a new `AddRoleToDBInstance`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AddRoleToDbInstanceOutput,
            aws_smithy_http::result::SdkError<crate::error::AddRoleToDBInstanceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the DB instance to associate the IAM role with.</p>
        pub fn db_instance_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_instance_identifier(input.into());
            self
        }
        /// <p>The name of the DB instance to associate the IAM role with.</p>
        pub fn set_db_instance_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_instance_identifier(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role to associate with the DB instance, for example <code>arn:aws:iam::123456789012:role/AccessRole</code>.</p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the IAM role to associate with the DB instance, for example <code>arn:aws:iam::123456789012:role/AccessRole</code>.</p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// <p>The name of the feature for the DB instance that the IAM role is to be associated with. For information about supported feature names, see <code>DBEngineVersion</code>.</p>
        pub fn feature_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.feature_name(input.into());
            self
        }
        /// <p>The name of the feature for the DB instance that the IAM role is to be associated with. For information about supported feature names, see <code>DBEngineVersion</code>.</p>
        pub fn set_feature_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_feature_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AddSourceIdentifierToSubscription`.
    ///
    /// <p>Adds a source identifier to an existing RDS event notification subscription.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AddSourceIdentifierToSubscription {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::add_source_identifier_to_subscription_input::Builder,
    }
    impl AddSourceIdentifierToSubscription {
        /// Creates a new `AddSourceIdentifierToSubscription`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AddSourceIdentifierToSubscriptionOutput,
            aws_smithy_http::result::SdkError<crate::error::AddSourceIdentifierToSubscriptionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the RDS event notification subscription you want to add a source identifier to.</p>
        pub fn subscription_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subscription_name(input.into());
            self
        }
        /// <p>The name of the RDS event notification subscription you want to add a source identifier to.</p>
        pub fn set_subscription_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_subscription_name(input);
            self
        }
        /// <p>The identifier of the event source to be added.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>If the source type is a DB instance, a <code>DBInstanceIdentifier</code> value must be supplied.</p> </li>
        /// <li> <p>If the source type is a DB cluster, a <code>DBClusterIdentifier</code> value must be supplied.</p> </li>
        /// <li> <p>If the source type is a DB parameter group, a <code>DBParameterGroupName</code> value must be supplied.</p> </li>
        /// <li> <p>If the source type is a DB security group, a <code>DBSecurityGroupName</code> value must be supplied.</p> </li>
        /// <li> <p>If the source type is a DB snapshot, a <code>DBSnapshotIdentifier</code> value must be supplied.</p> </li>
        /// <li> <p>If the source type is a DB cluster snapshot, a <code>DBClusterSnapshotIdentifier</code> value must be supplied.</p> </li>
        /// <li> <p>If the source type is an RDS Proxy, a <code>DBProxyName</code> value must be supplied.</p> </li>
        /// </ul>
        pub fn source_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_identifier(input.into());
            self
        }
        /// <p>The identifier of the event source to be added.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>If the source type is a DB instance, a <code>DBInstanceIdentifier</code> value must be supplied.</p> </li>
        /// <li> <p>If the source type is a DB cluster, a <code>DBClusterIdentifier</code> value must be supplied.</p> </li>
        /// <li> <p>If the source type is a DB parameter group, a <code>DBParameterGroupName</code> value must be supplied.</p> </li>
        /// <li> <p>If the source type is a DB security group, a <code>DBSecurityGroupName</code> value must be supplied.</p> </li>
        /// <li> <p>If the source type is a DB snapshot, a <code>DBSnapshotIdentifier</code> value must be supplied.</p> </li>
        /// <li> <p>If the source type is a DB cluster snapshot, a <code>DBClusterSnapshotIdentifier</code> value must be supplied.</p> </li>
        /// <li> <p>If the source type is an RDS Proxy, a <code>DBProxyName</code> value must be supplied.</p> </li>
        /// </ul>
        pub fn set_source_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AddTagsToResource`.
    ///
    /// <p>Adds metadata tags to an Amazon RDS resource. These tags can also be used with cost allocation reporting to track cost associated with Amazon RDS resources, or used in a Condition statement in an IAM policy for Amazon RDS.</p>
    /// <p>For an overview on tagging Amazon RDS resources, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Overview.Tagging.html">Tagging Amazon RDS Resources</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AddTagsToResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::add_tags_to_resource_input::Builder,
    }
    impl AddTagsToResource {
        /// Creates a new `AddTagsToResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AddTagsToResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::AddTagsToResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon RDS resource that the tags are added to. This value is an Amazon Resource Name (ARN). For information about creating an ARN, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing"> Constructing an RDS Amazon Resource Name (ARN)</a>.</p>
        pub fn resource_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_name(input.into());
            self
        }
        /// <p>The Amazon RDS resource that the tags are added to. This value is an Amazon Resource Name (ARN). For information about creating an ARN, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing"> Constructing an RDS Amazon Resource Name (ARN)</a>.</p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_name(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be assigned to the Amazon RDS resource.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags to be assigned to the Amazon RDS resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ApplyPendingMaintenanceAction`.
    ///
    /// <p>Applies a pending maintenance action to a resource (for example, to a DB instance).</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ApplyPendingMaintenanceAction {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::apply_pending_maintenance_action_input::Builder,
    }
    impl ApplyPendingMaintenanceAction {
        /// Creates a new `ApplyPendingMaintenanceAction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ApplyPendingMaintenanceActionOutput,
            aws_smithy_http::result::SdkError<crate::error::ApplyPendingMaintenanceActionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The RDS Amazon Resource Name (ARN) of the resource that the pending maintenance action applies to. For information about creating an ARN, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing"> Constructing an RDS Amazon Resource Name (ARN)</a>.</p>
        pub fn resource_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_identifier(input.into());
            self
        }
        /// <p>The RDS Amazon Resource Name (ARN) of the resource that the pending maintenance action applies to. For information about creating an ARN, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing"> Constructing an RDS Amazon Resource Name (ARN)</a>.</p>
        pub fn set_resource_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_resource_identifier(input);
            self
        }
        /// <p>The pending maintenance action to apply to this resource.</p>
        /// <p>Valid values: <code>system-update</code>, <code>db-upgrade</code>, <code>hardware-maintenance</code>, <code>ca-certificate-rotation</code> </p>
        pub fn apply_action(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.apply_action(input.into());
            self
        }
        /// <p>The pending maintenance action to apply to this resource.</p>
        /// <p>Valid values: <code>system-update</code>, <code>db-upgrade</code>, <code>hardware-maintenance</code>, <code>ca-certificate-rotation</code> </p>
        pub fn set_apply_action(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_apply_action(input);
            self
        }
        /// <p>A value that specifies the type of opt-in request, or undoes an opt-in request. An opt-in request of type <code>immediate</code> can't be undone.</p>
        /// <p>Valid values:</p>
        /// <ul>
        /// <li> <p> <code>immediate</code> - Apply the maintenance action immediately.</p> </li>
        /// <li> <p> <code>next-maintenance</code> - Apply the maintenance action during the next maintenance window for the resource.</p> </li>
        /// <li> <p> <code>undo-opt-in</code> - Cancel any existing <code>next-maintenance</code> opt-in requests.</p> </li>
        /// </ul>
        pub fn opt_in_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.opt_in_type(input.into());
            self
        }
        /// <p>A value that specifies the type of opt-in request, or undoes an opt-in request. An opt-in request of type <code>immediate</code> can't be undone.</p>
        /// <p>Valid values:</p>
        /// <ul>
        /// <li> <p> <code>immediate</code> - Apply the maintenance action immediately.</p> </li>
        /// <li> <p> <code>next-maintenance</code> - Apply the maintenance action during the next maintenance window for the resource.</p> </li>
        /// <li> <p> <code>undo-opt-in</code> - Cancel any existing <code>next-maintenance</code> opt-in requests.</p> </li>
        /// </ul>
        pub fn set_opt_in_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_opt_in_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AuthorizeDBSecurityGroupIngress`.
    ///
    /// <p>Enables ingress to a DBSecurityGroup using one of two forms of authorization. First, EC2 or VPC security groups can be added to the DBSecurityGroup if the application using the database is running on EC2 or VPC instances. Second, IP ranges are available if the application accessing your database is running on the internet. Required parameters for this API are one of CIDR range, EC2SecurityGroupId for VPC, or (EC2SecurityGroupOwnerId and either EC2SecurityGroupName or EC2SecurityGroupId for non-VPC).</p> <note>
    /// <p>You can't authorize ingress from an EC2 security group in one Amazon Web Services Region to an Amazon RDS DB instance in another. You can't authorize ingress from a VPC security group in one VPC to an Amazon RDS DB instance in another.</p>
    /// </note>
    /// <p>For an overview of CIDR ranges, go to the <a href="http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Wikipedia Tutorial</a>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AuthorizeDBSecurityGroupIngress {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::authorize_db_security_group_ingress_input::Builder,
    }
    impl AuthorizeDBSecurityGroupIngress {
        /// Creates a new `AuthorizeDBSecurityGroupIngress`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AuthorizeDbSecurityGroupIngressOutput,
            aws_smithy_http::result::SdkError<crate::error::AuthorizeDBSecurityGroupIngressError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the DB security group to add authorization to.</p>
        pub fn db_security_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_security_group_name(input.into());
            self
        }
        /// <p>The name of the DB security group to add authorization to.</p>
        pub fn set_db_security_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_security_group_name(input);
            self
        }
        /// <p>The IP range to authorize.</p>
        pub fn cidrip(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cidrip(input.into());
            self
        }
        /// <p>The IP range to authorize.</p>
        pub fn set_cidrip(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_cidrip(input);
            self
        }
        /// <p>Name of the EC2 security group to authorize. For VPC DB security groups, <code>EC2SecurityGroupId</code> must be provided. Otherwise, <code>EC2SecurityGroupOwnerId</code> and either <code>EC2SecurityGroupName</code> or <code>EC2SecurityGroupId</code> must be provided.</p>
        pub fn ec2_security_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ec2_security_group_name(input.into());
            self
        }
        /// <p>Name of the EC2 security group to authorize. For VPC DB security groups, <code>EC2SecurityGroupId</code> must be provided. Otherwise, <code>EC2SecurityGroupOwnerId</code> and either <code>EC2SecurityGroupName</code> or <code>EC2SecurityGroupId</code> must be provided.</p>
        pub fn set_ec2_security_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_ec2_security_group_name(input);
            self
        }
        /// <p>Id of the EC2 security group to authorize. For VPC DB security groups, <code>EC2SecurityGroupId</code> must be provided. Otherwise, <code>EC2SecurityGroupOwnerId</code> and either <code>EC2SecurityGroupName</code> or <code>EC2SecurityGroupId</code> must be provided.</p>
        pub fn ec2_security_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ec2_security_group_id(input.into());
            self
        }
        /// <p>Id of the EC2 security group to authorize. For VPC DB security groups, <code>EC2SecurityGroupId</code> must be provided. Otherwise, <code>EC2SecurityGroupOwnerId</code> and either <code>EC2SecurityGroupName</code> or <code>EC2SecurityGroupId</code> must be provided.</p>
        pub fn set_ec2_security_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_ec2_security_group_id(input);
            self
        }
        /// <p>Amazon Web Services account number of the owner of the EC2 security group specified in the <code>EC2SecurityGroupName</code> parameter. The Amazon Web Services access key ID isn't an acceptable value. For VPC DB security groups, <code>EC2SecurityGroupId</code> must be provided. Otherwise, <code>EC2SecurityGroupOwnerId</code> and either <code>EC2SecurityGroupName</code> or <code>EC2SecurityGroupId</code> must be provided.</p>
        pub fn ec2_security_group_owner_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.ec2_security_group_owner_id(input.into());
            self
        }
        /// <p>Amazon Web Services account number of the owner of the EC2 security group specified in the <code>EC2SecurityGroupName</code> parameter. The Amazon Web Services access key ID isn't an acceptable value. For VPC DB security groups, <code>EC2SecurityGroupId</code> must be provided. Otherwise, <code>EC2SecurityGroupOwnerId</code> and either <code>EC2SecurityGroupName</code> or <code>EC2SecurityGroupId</code> must be provided.</p>
        pub fn set_ec2_security_group_owner_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_ec2_security_group_owner_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BacktrackDBCluster`.
    ///
    /// <p>Backtracks a DB cluster to a specific time, without creating a new DB cluster.</p>
    /// <p>For more information on backtracking, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraMySQL.Managing.Backtrack.html"> Backtracking an Aurora DB Cluster</a> in the <i>Amazon Aurora User Guide</i>.</p> <note>
    /// <p>This action only applies to Aurora MySQL DB clusters.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct BacktrackDBCluster {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::backtrack_db_cluster_input::Builder,
    }
    impl BacktrackDBCluster {
        /// Creates a new `BacktrackDBCluster`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BacktrackDbClusterOutput,
            aws_smithy_http::result::SdkError<crate::error::BacktrackDBClusterError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The DB cluster identifier of the DB cluster to be backtracked. This parameter is stored as a lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must contain from 1 to 63 alphanumeric characters or hyphens.</p> </li>
        /// <li> <p>First character must be a letter.</p> </li>
        /// <li> <p>Can't end with a hyphen or contain two consecutive hyphens.</p> </li>
        /// </ul>
        /// <p>Example: <code>my-cluster1</code> </p>
        pub fn db_cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_cluster_identifier(input.into());
            self
        }
        /// <p>The DB cluster identifier of the DB cluster to be backtracked. This parameter is stored as a lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must contain from 1 to 63 alphanumeric characters or hyphens.</p> </li>
        /// <li> <p>First character must be a letter.</p> </li>
        /// <li> <p>Can't end with a hyphen or contain two consecutive hyphens.</p> </li>
        /// </ul>
        /// <p>Example: <code>my-cluster1</code> </p>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_identifier(input);
            self
        }
        /// <p>The timestamp of the time to backtrack the DB cluster to, specified in ISO 8601 format. For more information about ISO 8601, see the <a href="http://en.wikipedia.org/wiki/ISO_8601">ISO8601 Wikipedia page.</a> </p> <note>
        /// <p>If the specified time isn't a consistent time for the DB cluster, Aurora automatically chooses the nearest possible consistent time for the DB cluster.</p>
        /// </note>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must contain a valid ISO 8601 timestamp.</p> </li>
        /// <li> <p>Can't contain a timestamp set in the future.</p> </li>
        /// </ul>
        /// <p>Example: <code>2017-07-08T18:00Z</code> </p>
        pub fn backtrack_to(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.backtrack_to(input);
            self
        }
        /// <p>The timestamp of the time to backtrack the DB cluster to, specified in ISO 8601 format. For more information about ISO 8601, see the <a href="http://en.wikipedia.org/wiki/ISO_8601">ISO8601 Wikipedia page.</a> </p> <note>
        /// <p>If the specified time isn't a consistent time for the DB cluster, Aurora automatically chooses the nearest possible consistent time for the DB cluster.</p>
        /// </note>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must contain a valid ISO 8601 timestamp.</p> </li>
        /// <li> <p>Can't contain a timestamp set in the future.</p> </li>
        /// </ul>
        /// <p>Example: <code>2017-07-08T18:00Z</code> </p>
        pub fn set_backtrack_to(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_backtrack_to(input);
            self
        }
        /// <p>A value that indicates whether to force the DB cluster to backtrack when binary logging is enabled. Otherwise, an error occurs when binary logging is enabled.</p>
        pub fn force(mut self, input: bool) -> Self {
            self.inner = self.inner.force(input);
            self
        }
        /// <p>A value that indicates whether to force the DB cluster to backtrack when binary logging is enabled. Otherwise, an error occurs when binary logging is enabled.</p>
        pub fn set_force(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_force(input);
            self
        }
        /// <p>A value that indicates whether to backtrack the DB cluster to the earliest possible backtrack time when <i>BacktrackTo</i> is set to a timestamp earlier than the earliest backtrack time. When this parameter is disabled and <i>BacktrackTo</i> is set to a timestamp earlier than the earliest backtrack time, an error occurs.</p>
        pub fn use_earliest_time_on_point_in_time_unavailable(mut self, input: bool) -> Self {
            self.inner = self
                .inner
                .use_earliest_time_on_point_in_time_unavailable(input);
            self
        }
        /// <p>A value that indicates whether to backtrack the DB cluster to the earliest possible backtrack time when <i>BacktrackTo</i> is set to a timestamp earlier than the earliest backtrack time. When this parameter is disabled and <i>BacktrackTo</i> is set to a timestamp earlier than the earliest backtrack time, an error occurs.</p>
        pub fn set_use_earliest_time_on_point_in_time_unavailable(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self
                .inner
                .set_use_earliest_time_on_point_in_time_unavailable(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CancelExportTask`.
    ///
    /// <p>Cancels an export task in progress that is exporting a snapshot to Amazon S3. Any data that has already been written to the S3 bucket isn't removed.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CancelExportTask {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::cancel_export_task_input::Builder,
    }
    impl CancelExportTask {
        /// Creates a new `CancelExportTask`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CancelExportTaskOutput,
            aws_smithy_http::result::SdkError<crate::error::CancelExportTaskError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the snapshot export task to cancel.</p>
        pub fn export_task_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.export_task_identifier(input.into());
            self
        }
        /// <p>The identifier of the snapshot export task to cancel.</p>
        pub fn set_export_task_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_export_task_identifier(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CopyDBClusterParameterGroup`.
    ///
    /// <p>Copies the specified DB cluster parameter group.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CopyDBClusterParameterGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::copy_db_cluster_parameter_group_input::Builder,
    }
    impl CopyDBClusterParameterGroup {
        /// Creates a new `CopyDBClusterParameterGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CopyDbClusterParameterGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CopyDBClusterParameterGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier or Amazon Resource Name (ARN) for the source DB cluster parameter group. For information about creating an ARN, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing"> Constructing an ARN for Amazon RDS</a> in the <i>Amazon Aurora User Guide</i>.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must specify a valid DB cluster parameter group.</p> </li>
        /// </ul>
        pub fn source_db_cluster_parameter_group_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .source_db_cluster_parameter_group_identifier(input.into());
            self
        }
        /// <p>The identifier or Amazon Resource Name (ARN) for the source DB cluster parameter group. For information about creating an ARN, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing"> Constructing an ARN for Amazon RDS</a> in the <i>Amazon Aurora User Guide</i>.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must specify a valid DB cluster parameter group.</p> </li>
        /// </ul>
        pub fn set_source_db_cluster_parameter_group_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .set_source_db_cluster_parameter_group_identifier(input);
            self
        }
        /// <p>The identifier for the copied DB cluster parameter group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Can't be null, empty, or blank</p> </li>
        /// <li> <p>Must contain from 1 to 255 letters, numbers, or hyphens</p> </li>
        /// <li> <p>First character must be a letter</p> </li>
        /// <li> <p>Can't end with a hyphen or contain two consecutive hyphens</p> </li>
        /// </ul>
        /// <p>Example: <code>my-cluster-param-group1</code> </p>
        pub fn target_db_cluster_parameter_group_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .target_db_cluster_parameter_group_identifier(input.into());
            self
        }
        /// <p>The identifier for the copied DB cluster parameter group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Can't be null, empty, or blank</p> </li>
        /// <li> <p>Must contain from 1 to 255 letters, numbers, or hyphens</p> </li>
        /// <li> <p>First character must be a letter</p> </li>
        /// <li> <p>Can't end with a hyphen or contain two consecutive hyphens</p> </li>
        /// </ul>
        /// <p>Example: <code>my-cluster-param-group1</code> </p>
        pub fn set_target_db_cluster_parameter_group_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .set_target_db_cluster_parameter_group_identifier(input);
            self
        }
        /// <p>A description for the copied DB cluster parameter group.</p>
        pub fn target_db_cluster_parameter_group_description(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .target_db_cluster_parameter_group_description(input.into());
            self
        }
        /// <p>A description for the copied DB cluster parameter group.</p>
        pub fn set_target_db_cluster_parameter_group_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .set_target_db_cluster_parameter_group_description(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources</a> in the <i>Amazon RDS User Guide.</i> </p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of tags. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources</a> in the <i>Amazon RDS User Guide.</i> </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CopyDBClusterSnapshot`.
    ///
    /// <p>Copies a snapshot of a DB cluster.</p>
    /// <p>To copy a DB cluster snapshot from a shared manual DB cluster snapshot, <code>SourceDBClusterSnapshotIdentifier</code> must be the Amazon Resource Name (ARN) of the shared DB cluster snapshot.</p>
    /// <p>You can copy an encrypted DB cluster snapshot from another Amazon Web Services Region. In that case, the Amazon Web Services Region where you call the <code>CopyDBClusterSnapshot</code> action is the destination Amazon Web Services Region for the encrypted DB cluster snapshot to be copied to. To copy an encrypted DB cluster snapshot from another Amazon Web Services Region, you must provide the following values:</p>
    /// <ul>
    /// <li> <p> <code>KmsKeyId</code> - The Amazon Web Services Key Management System (Amazon Web Services KMS) key identifier for the key to use to encrypt the copy of the DB cluster snapshot in the destination Amazon Web Services Region.</p> </li>
    /// <li> <p> <code>PreSignedUrl</code> - A URL that contains a Signature Version 4 signed request for the <code>CopyDBClusterSnapshot</code> action to be called in the source Amazon Web Services Region where the DB cluster snapshot is copied from. The pre-signed URL must be a valid request for the <code>CopyDBClusterSnapshot</code> API action that can be executed in the source Amazon Web Services Region that contains the encrypted DB cluster snapshot to be copied.</p> <p>The pre-signed URL request must contain the following parameter values:</p>
    /// <ul>
    /// <li> <p> <code>KmsKeyId</code> - The Amazon Web Services KMS key identifier for the KMS key to use to encrypt the copy of the DB cluster snapshot in the destination Amazon Web Services Region. This is the same identifier for both the <code>CopyDBClusterSnapshot</code> action that is called in the destination Amazon Web Services Region, and the action contained in the pre-signed URL.</p> </li>
    /// <li> <p> <code>DestinationRegion</code> - The name of the Amazon Web Services Region that the DB cluster snapshot is to be created in.</p> </li>
    /// <li> <p> <code>SourceDBClusterSnapshotIdentifier</code> - The DB cluster snapshot identifier for the encrypted DB cluster snapshot to be copied. This identifier must be in the Amazon Resource Name (ARN) format for the source Amazon Web Services Region. For example, if you are copying an encrypted DB cluster snapshot from the us-west-2 Amazon Web Services Region, then your <code>SourceDBClusterSnapshotIdentifier</code> looks like the following example: <code>arn:aws:rds:us-west-2:123456789012:cluster-snapshot:aurora-cluster1-snapshot-20161115</code>.</p> </li>
    /// </ul> <p>To learn how to generate a Signature Version 4 signed request, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html"> Authenticating Requests: Using Query Parameters (Amazon Web Services Signature Version 4)</a> and <a href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html"> Signature Version 4 Signing Process</a>.</p> <note>
    /// <p>If you are using an Amazon Web Services SDK tool or the CLI, you can specify <code>SourceRegion</code> (or <code>--source-region</code> for the CLI) instead of specifying <code>PreSignedUrl</code> manually. Specifying <code>SourceRegion</code> autogenerates a pre-signed URL that is a valid request for the operation that can be executed in the source Amazon Web Services Region.</p>
    /// </note> </li>
    /// <li> <p> <code>TargetDBClusterSnapshotIdentifier</code> - The identifier for the new copy of the DB cluster snapshot in the destination Amazon Web Services Region.</p> </li>
    /// <li> <p> <code>SourceDBClusterSnapshotIdentifier</code> - The DB cluster snapshot identifier for the encrypted DB cluster snapshot to be copied. This identifier must be in the ARN format for the source Amazon Web Services Region and is the same value as the <code>SourceDBClusterSnapshotIdentifier</code> in the pre-signed URL.</p> </li>
    /// </ul>
    /// <p>To cancel the copy operation once it is in progress, delete the target DB cluster snapshot identified by <code>TargetDBClusterSnapshotIdentifier</code> while that DB cluster snapshot is in "copying" status.</p>
    /// <p>For more information on copying encrypted Amazon Aurora DB cluster snapshots from one Amazon Web Services Region to another, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_CopySnapshot.html"> Copying a Snapshot</a> in the <i>Amazon Aurora User Guide</i>.</p>
    /// <p>For more information on Amazon Aurora DB clusters, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon Aurora?</a> in the <i>Amazon Aurora User Guide</i>.</p>
    /// <p>For more information on Multi-AZ DB clusters, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ deployments with two readable standby DB instances</a> in the <i>Amazon RDS User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CopyDBClusterSnapshot {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::copy_db_cluster_snapshot_input::Builder,
    }
    impl CopyDBClusterSnapshot {
        /// Creates a new `CopyDBClusterSnapshot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CopyDbClusterSnapshotOutput,
            aws_smithy_http::result::SdkError<crate::error::CopyDBClusterSnapshotError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the DB cluster snapshot to copy. This parameter isn't case-sensitive.</p>
        /// <p>You can't copy an encrypted, shared DB cluster snapshot from one Amazon Web Services Region to another.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must specify a valid system snapshot in the "available" state.</p> </li>
        /// <li> <p>If the source snapshot is in the same Amazon Web Services Region as the copy, specify a valid DB snapshot identifier.</p> </li>
        /// <li> <p>If the source snapshot is in a different Amazon Web Services Region than the copy, specify a valid DB cluster snapshot ARN. For more information, go to <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_CopySnapshot.html#USER_CopySnapshot.AcrossRegions"> Copying Snapshots Across Amazon Web Services Regions</a> in the <i>Amazon Aurora User Guide</i>.</p> </li>
        /// </ul>
        /// <p>Example: <code>my-cluster-snapshot1</code> </p>
        pub fn source_db_cluster_snapshot_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .source_db_cluster_snapshot_identifier(input.into());
            self
        }
        /// <p>The identifier of the DB cluster snapshot to copy. This parameter isn't case-sensitive.</p>
        /// <p>You can't copy an encrypted, shared DB cluster snapshot from one Amazon Web Services Region to another.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must specify a valid system snapshot in the "available" state.</p> </li>
        /// <li> <p>If the source snapshot is in the same Amazon Web Services Region as the copy, specify a valid DB snapshot identifier.</p> </li>
        /// <li> <p>If the source snapshot is in a different Amazon Web Services Region than the copy, specify a valid DB cluster snapshot ARN. For more information, go to <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_CopySnapshot.html#USER_CopySnapshot.AcrossRegions"> Copying Snapshots Across Amazon Web Services Regions</a> in the <i>Amazon Aurora User Guide</i>.</p> </li>
        /// </ul>
        /// <p>Example: <code>my-cluster-snapshot1</code> </p>
        pub fn set_source_db_cluster_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_db_cluster_snapshot_identifier(input);
            self
        }
        /// <p>The identifier of the new DB cluster snapshot to create from the source DB cluster snapshot. This parameter isn't case-sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p> </li>
        /// <li> <p>First character must be a letter.</p> </li>
        /// <li> <p>Can't end with a hyphen or contain two consecutive hyphens.</p> </li>
        /// </ul>
        /// <p>Example: <code>my-cluster-snapshot2</code> </p>
        pub fn target_db_cluster_snapshot_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .target_db_cluster_snapshot_identifier(input.into());
            self
        }
        /// <p>The identifier of the new DB cluster snapshot to create from the source DB cluster snapshot. This parameter isn't case-sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p> </li>
        /// <li> <p>First character must be a letter.</p> </li>
        /// <li> <p>Can't end with a hyphen or contain two consecutive hyphens.</p> </li>
        /// </ul>
        /// <p>Example: <code>my-cluster-snapshot2</code> </p>
        pub fn set_target_db_cluster_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_target_db_cluster_snapshot_identifier(input);
            self
        }
        /// <p>The Amazon Web Services KMS key identifier for an encrypted DB cluster snapshot. The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the Amazon Web Services KMS key.</p>
        /// <p>If you copy an encrypted DB cluster snapshot from your Amazon Web Services account, you can specify a value for <code>KmsKeyId</code> to encrypt the copy with a new KMS key. If you don't specify a value for <code>KmsKeyId</code>, then the copy of the DB cluster snapshot is encrypted with the same KMS key as the source DB cluster snapshot.</p>
        /// <p>If you copy an encrypted DB cluster snapshot that is shared from another Amazon Web Services account, then you must specify a value for <code>KmsKeyId</code>.</p>
        /// <p>To copy an encrypted DB cluster snapshot to another Amazon Web Services Region, you must set <code>KmsKeyId</code> to the Amazon Web Services KMS key identifier you want to use to encrypt the copy of the DB cluster snapshot in the destination Amazon Web Services Region. KMS keys are specific to the Amazon Web Services Region that they are created in, and you can't use KMS keys from one Amazon Web Services Region in another Amazon Web Services Region.</p>
        /// <p>If you copy an unencrypted DB cluster snapshot and specify a value for the <code>KmsKeyId</code> parameter, an error is returned.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key_id(input.into());
            self
        }
        /// <p>The Amazon Web Services KMS key identifier for an encrypted DB cluster snapshot. The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the Amazon Web Services KMS key.</p>
        /// <p>If you copy an encrypted DB cluster snapshot from your Amazon Web Services account, you can specify a value for <code>KmsKeyId</code> to encrypt the copy with a new KMS key. If you don't specify a value for <code>KmsKeyId</code>, then the copy of the DB cluster snapshot is encrypted with the same KMS key as the source DB cluster snapshot.</p>
        /// <p>If you copy an encrypted DB cluster snapshot that is shared from another Amazon Web Services account, then you must specify a value for <code>KmsKeyId</code>.</p>
        /// <p>To copy an encrypted DB cluster snapshot to another Amazon Web Services Region, you must set <code>KmsKeyId</code> to the Amazon Web Services KMS key identifier you want to use to encrypt the copy of the DB cluster snapshot in the destination Amazon Web Services Region. KMS keys are specific to the Amazon Web Services Region that they are created in, and you can't use KMS keys from one Amazon Web Services Region in another Amazon Web Services Region.</p>
        /// <p>If you copy an unencrypted DB cluster snapshot and specify a value for the <code>KmsKeyId</code> parameter, an error is returned.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key_id(input);
            self
        }
        /// <p>The URL that contains a Signature Version 4 signed request for the <code>CopyDBClusterSnapshot</code> API action in the Amazon Web Services Region that contains the source DB cluster snapshot to copy. The <code>PreSignedUrl</code> parameter must be used when copying an encrypted DB cluster snapshot from another Amazon Web Services Region. Don't specify <code>PreSignedUrl</code> when you are copying an encrypted DB cluster snapshot in the same Amazon Web Services Region.</p>
        /// <p>The pre-signed URL must be a valid request for the <code>CopyDBClusterSnapshot</code> API action that can be executed in the source Amazon Web Services Region that contains the encrypted DB cluster snapshot to be copied. The pre-signed URL request must contain the following parameter values:</p>
        /// <ul>
        /// <li> <p> <code>KmsKeyId</code> - The Amazon Web Services KMS key identifier for the KMS key to use to encrypt the copy of the DB cluster snapshot in the destination Amazon Web Services Region. This is the same identifier for both the <code>CopyDBClusterSnapshot</code> action that is called in the destination Amazon Web Services Region, and the action contained in the pre-signed URL.</p> </li>
        /// <li> <p> <code>DestinationRegion</code> - The name of the Amazon Web Services Region that the DB cluster snapshot is to be created in.</p> </li>
        /// <li> <p> <code>SourceDBClusterSnapshotIdentifier</code> - The DB cluster snapshot identifier for the encrypted DB cluster snapshot to be copied. This identifier must be in the Amazon Resource Name (ARN) format for the source Amazon Web Services Region. For example, if you are copying an encrypted DB cluster snapshot from the us-west-2 Amazon Web Services Region, then your <code>SourceDBClusterSnapshotIdentifier</code> looks like the following example: <code>arn:aws:rds:us-west-2:123456789012:cluster-snapshot:aurora-cluster1-snapshot-20161115</code>.</p> </li>
        /// </ul>
        /// <p>To learn how to generate a Signature Version 4 signed request, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html"> Authenticating Requests: Using Query Parameters (Amazon Web Services Signature Version 4)</a> and <a href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html"> Signature Version 4 Signing Process</a>.</p> <note>
        /// <p>If you are using an Amazon Web Services SDK tool or the CLI, you can specify <code>SourceRegion</code> (or <code>--source-region</code> for the CLI) instead of specifying <code>PreSignedUrl</code> manually. Specifying <code>SourceRegion</code> autogenerates a pre-signed URL that is a valid request for the operation that can be executed in the source Amazon Web Services Region.</p>
        /// </note>
        pub fn pre_signed_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pre_signed_url(input.into());
            self
        }
        /// <p>The URL that contains a Signature Version 4 signed request for the <code>CopyDBClusterSnapshot</code> API action in the Amazon Web Services Region that contains the source DB cluster snapshot to copy. The <code>PreSignedUrl</code> parameter must be used when copying an encrypted DB cluster snapshot from another Amazon Web Services Region. Don't specify <code>PreSignedUrl</code> when you are copying an encrypted DB cluster snapshot in the same Amazon Web Services Region.</p>
        /// <p>The pre-signed URL must be a valid request for the <code>CopyDBClusterSnapshot</code> API action that can be executed in the source Amazon Web Services Region that contains the encrypted DB cluster snapshot to be copied. The pre-signed URL request must contain the following parameter values:</p>
        /// <ul>
        /// <li> <p> <code>KmsKeyId</code> - The Amazon Web Services KMS key identifier for the KMS key to use to encrypt the copy of the DB cluster snapshot in the destination Amazon Web Services Region. This is the same identifier for both the <code>CopyDBClusterSnapshot</code> action that is called in the destination Amazon Web Services Region, and the action contained in the pre-signed URL.</p> </li>
        /// <li> <p> <code>DestinationRegion</code> - The name of the Amazon Web Services Region that the DB cluster snapshot is to be created in.</p> </li>
        /// <li> <p> <code>SourceDBClusterSnapshotIdentifier</code> - The DB cluster snapshot identifier for the encrypted DB cluster snapshot to be copied. This identifier must be in the Amazon Resource Name (ARN) format for the source Amazon Web Services Region. For example, if you are copying an encrypted DB cluster snapshot from the us-west-2 Amazon Web Services Region, then your <code>SourceDBClusterSnapshotIdentifier</code> looks like the following example: <code>arn:aws:rds:us-west-2:123456789012:cluster-snapshot:aurora-cluster1-snapshot-20161115</code>.</p> </li>
        /// </ul>
        /// <p>To learn how to generate a Signature Version 4 signed request, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html"> Authenticating Requests: Using Query Parameters (Amazon Web Services Signature Version 4)</a> and <a href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html"> Signature Version 4 Signing Process</a>.</p> <note>
        /// <p>If you are using an Amazon Web Services SDK tool or the CLI, you can specify <code>SourceRegion</code> (or <code>--source-region</code> for the CLI) instead of specifying <code>PreSignedUrl</code> manually. Specifying <code>SourceRegion</code> autogenerates a pre-signed URL that is a valid request for the operation that can be executed in the source Amazon Web Services Region.</p>
        /// </note>
        pub fn set_pre_signed_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pre_signed_url(input);
            self
        }
        /// <p>A value that indicates whether to copy all tags from the source DB cluster snapshot to the target DB cluster snapshot. By default, tags are not copied.</p>
        pub fn copy_tags(mut self, input: bool) -> Self {
            self.inner = self.inner.copy_tags(input);
            self
        }
        /// <p>A value that indicates whether to copy all tags from the source DB cluster snapshot to the target DB cluster snapshot. By default, tags are not copied.</p>
        pub fn set_copy_tags(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_copy_tags(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources</a> in the <i>Amazon RDS User Guide.</i> </p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of tags. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources</a> in the <i>Amazon RDS User Guide.</i> </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CopyDBParameterGroup`.
    ///
    /// <p>Copies the specified DB parameter group.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CopyDBParameterGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::copy_db_parameter_group_input::Builder,
    }
    impl CopyDBParameterGroup {
        /// Creates a new `CopyDBParameterGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CopyDbParameterGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CopyDBParameterGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier or ARN for the source DB parameter group. For information about creating an ARN, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing"> Constructing an ARN for Amazon RDS</a> in the <i>Amazon RDS User Guide</i>.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must specify a valid DB parameter group.</p> </li>
        /// </ul>
        pub fn source_db_parameter_group_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .source_db_parameter_group_identifier(input.into());
            self
        }
        /// <p>The identifier or ARN for the source DB parameter group. For information about creating an ARN, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing"> Constructing an ARN for Amazon RDS</a> in the <i>Amazon RDS User Guide</i>.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must specify a valid DB parameter group.</p> </li>
        /// </ul>
        pub fn set_source_db_parameter_group_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_db_parameter_group_identifier(input);
            self
        }
        /// <p>The identifier for the copied DB parameter group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Can't be null, empty, or blank</p> </li>
        /// <li> <p>Must contain from 1 to 255 letters, numbers, or hyphens</p> </li>
        /// <li> <p>First character must be a letter</p> </li>
        /// <li> <p>Can't end with a hyphen or contain two consecutive hyphens</p> </li>
        /// </ul>
        /// <p>Example: <code>my-db-parameter-group</code> </p>
        pub fn target_db_parameter_group_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .target_db_parameter_group_identifier(input.into());
            self
        }
        /// <p>The identifier for the copied DB parameter group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Can't be null, empty, or blank</p> </li>
        /// <li> <p>Must contain from 1 to 255 letters, numbers, or hyphens</p> </li>
        /// <li> <p>First character must be a letter</p> </li>
        /// <li> <p>Can't end with a hyphen or contain two consecutive hyphens</p> </li>
        /// </ul>
        /// <p>Example: <code>my-db-parameter-group</code> </p>
        pub fn set_target_db_parameter_group_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_target_db_parameter_group_identifier(input);
            self
        }
        /// <p>A description for the copied DB parameter group.</p>
        pub fn target_db_parameter_group_description(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .target_db_parameter_group_description(input.into());
            self
        }
        /// <p>A description for the copied DB parameter group.</p>
        pub fn set_target_db_parameter_group_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_target_db_parameter_group_description(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources</a> in the <i>Amazon RDS User Guide.</i> </p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of tags. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources</a> in the <i>Amazon RDS User Guide.</i> </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CopyDBSnapshot`.
    ///
    /// <p>Copies the specified DB snapshot. The source DB snapshot must be in the <code>available</code> state.</p>
    /// <p>You can copy a snapshot from one Amazon Web Services Region to another. In that case, the Amazon Web Services Region where you call the <code>CopyDBSnapshot</code> action is the destination Amazon Web Services Region for the DB snapshot copy.</p>
    /// <p>This command doesn't apply to RDS Custom.</p>
    /// <p>For more information about copying snapshots, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_CopySnapshot.html#USER_CopyDBSnapshot">Copying a DB Snapshot</a> in the <i>Amazon RDS User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CopyDBSnapshot {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::copy_db_snapshot_input::Builder,
    }
    impl CopyDBSnapshot {
        /// Creates a new `CopyDBSnapshot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CopyDbSnapshotOutput,
            aws_smithy_http::result::SdkError<crate::error::CopyDBSnapshotError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier for the source DB snapshot.</p>
        /// <p>If the source snapshot is in the same Amazon Web Services Region as the copy, specify a valid DB snapshot identifier. For example, you might specify <code>rds:mysql-instance1-snapshot-20130805</code>.</p>
        /// <p>If the source snapshot is in a different Amazon Web Services Region than the copy, specify a valid DB snapshot ARN. For example, you might specify <code>arn:aws:rds:us-west-2:123456789012:snapshot:mysql-instance1-snapshot-20130805</code>.</p>
        /// <p>If you are copying from a shared manual DB snapshot, this parameter must be the Amazon Resource Name (ARN) of the shared DB snapshot.</p>
        /// <p>If you are copying an encrypted snapshot this parameter must be in the ARN format for the source Amazon Web Services Region, and must match the <code>SourceDBSnapshotIdentifier</code> in the <code>PreSignedUrl</code> parameter.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must specify a valid system snapshot in the "available" state.</p> </li>
        /// </ul>
        /// <p>Example: <code>rds:mydb-2012-04-02-00-01</code> </p>
        /// <p>Example: <code>arn:aws:rds:us-west-2:123456789012:snapshot:mysql-instance1-snapshot-20130805</code> </p>
        pub fn source_db_snapshot_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.source_db_snapshot_identifier(input.into());
            self
        }
        /// <p>The identifier for the source DB snapshot.</p>
        /// <p>If the source snapshot is in the same Amazon Web Services Region as the copy, specify a valid DB snapshot identifier. For example, you might specify <code>rds:mysql-instance1-snapshot-20130805</code>.</p>
        /// <p>If the source snapshot is in a different Amazon Web Services Region than the copy, specify a valid DB snapshot ARN. For example, you might specify <code>arn:aws:rds:us-west-2:123456789012:snapshot:mysql-instance1-snapshot-20130805</code>.</p>
        /// <p>If you are copying from a shared manual DB snapshot, this parameter must be the Amazon Resource Name (ARN) of the shared DB snapshot.</p>
        /// <p>If you are copying an encrypted snapshot this parameter must be in the ARN format for the source Amazon Web Services Region, and must match the <code>SourceDBSnapshotIdentifier</code> in the <code>PreSignedUrl</code> parameter.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must specify a valid system snapshot in the "available" state.</p> </li>
        /// </ul>
        /// <p>Example: <code>rds:mydb-2012-04-02-00-01</code> </p>
        /// <p>Example: <code>arn:aws:rds:us-west-2:123456789012:snapshot:mysql-instance1-snapshot-20130805</code> </p>
        pub fn set_source_db_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_db_snapshot_identifier(input);
            self
        }
        /// <p>The identifier for the copy of the snapshot.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Can't be null, empty, or blank</p> </li>
        /// <li> <p>Must contain from 1 to 255 letters, numbers, or hyphens</p> </li>
        /// <li> <p>First character must be a letter</p> </li>
        /// <li> <p>Can't end with a hyphen or contain two consecutive hyphens</p> </li>
        /// </ul>
        /// <p>Example: <code>my-db-snapshot</code> </p>
        pub fn target_db_snapshot_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.target_db_snapshot_identifier(input.into());
            self
        }
        /// <p>The identifier for the copy of the snapshot.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Can't be null, empty, or blank</p> </li>
        /// <li> <p>Must contain from 1 to 255 letters, numbers, or hyphens</p> </li>
        /// <li> <p>First character must be a letter</p> </li>
        /// <li> <p>Can't end with a hyphen or contain two consecutive hyphens</p> </li>
        /// </ul>
        /// <p>Example: <code>my-db-snapshot</code> </p>
        pub fn set_target_db_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_target_db_snapshot_identifier(input);
            self
        }
        /// <p>The Amazon Web Services KMS key identifier for an encrypted DB snapshot. The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.</p>
        /// <p>If you copy an encrypted DB snapshot from your Amazon Web Services account, you can specify a value for this parameter to encrypt the copy with a new KMS key. If you don't specify a value for this parameter, then the copy of the DB snapshot is encrypted with the same Amazon Web Services KMS key as the source DB snapshot.</p>
        /// <p>If you copy an encrypted DB snapshot that is shared from another Amazon Web Services account, then you must specify a value for this parameter.</p>
        /// <p>If you specify this parameter when you copy an unencrypted snapshot, the copy is encrypted.</p>
        /// <p>If you copy an encrypted snapshot to a different Amazon Web Services Region, then you must specify an Amazon Web Services KMS key identifier for the destination Amazon Web Services Region. KMS keys are specific to the Amazon Web Services Region that they are created in, and you can't use KMS keys from one Amazon Web Services Region in another Amazon Web Services Region.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key_id(input.into());
            self
        }
        /// <p>The Amazon Web Services KMS key identifier for an encrypted DB snapshot. The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.</p>
        /// <p>If you copy an encrypted DB snapshot from your Amazon Web Services account, you can specify a value for this parameter to encrypt the copy with a new KMS key. If you don't specify a value for this parameter, then the copy of the DB snapshot is encrypted with the same Amazon Web Services KMS key as the source DB snapshot.</p>
        /// <p>If you copy an encrypted DB snapshot that is shared from another Amazon Web Services account, then you must specify a value for this parameter.</p>
        /// <p>If you specify this parameter when you copy an unencrypted snapshot, the copy is encrypted.</p>
        /// <p>If you copy an encrypted snapshot to a different Amazon Web Services Region, then you must specify an Amazon Web Services KMS key identifier for the destination Amazon Web Services Region. KMS keys are specific to the Amazon Web Services Region that they are created in, and you can't use KMS keys from one Amazon Web Services Region in another Amazon Web Services Region.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key_id(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources</a> in the <i>Amazon RDS User Guide.</i> </p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of tags. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources</a> in the <i>Amazon RDS User Guide.</i> </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>A value that indicates whether to copy all tags from the source DB snapshot to the target DB snapshot. By default, tags are not copied.</p>
        pub fn copy_tags(mut self, input: bool) -> Self {
            self.inner = self.inner.copy_tags(input);
            self
        }
        /// <p>A value that indicates whether to copy all tags from the source DB snapshot to the target DB snapshot. By default, tags are not copied.</p>
        pub fn set_copy_tags(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_copy_tags(input);
            self
        }
        /// <p>The URL that contains a Signature Version 4 signed request for the <code>CopyDBSnapshot</code> API action in the source Amazon Web Services Region that contains the source DB snapshot to copy.</p>
        /// <p>You must specify this parameter when you copy an encrypted DB snapshot from another Amazon Web Services Region by using the Amazon RDS API. Don't specify <code>PreSignedUrl</code> when you are copying an encrypted DB snapshot in the same Amazon Web Services Region.</p>
        /// <p>The presigned URL must be a valid request for the <code>CopyDBSnapshot</code> API action that can be executed in the source Amazon Web Services Region that contains the encrypted DB snapshot to be copied. The presigned URL request must contain the following parameter values:</p>
        /// <ul>
        /// <li> <p> <code>DestinationRegion</code> - The Amazon Web Services Region that the encrypted DB snapshot is copied to. This Amazon Web Services Region is the same one where the <code>CopyDBSnapshot</code> action is called that contains this presigned URL.</p> <p>For example, if you copy an encrypted DB snapshot from the us-west-2 Amazon Web Services Region to the us-east-1 Amazon Web Services Region, then you call the <code>CopyDBSnapshot</code> action in the us-east-1 Amazon Web Services Region and provide a presigned URL that contains a call to the <code>CopyDBSnapshot</code> action in the us-west-2 Amazon Web Services Region. For this example, the <code>DestinationRegion</code> in the presigned URL must be set to the us-east-1 Amazon Web Services Region.</p> </li>
        /// <li> <p> <code>KmsKeyId</code> - The Amazon Web Services KMS key identifier for the KMS key to use to encrypt the copy of the DB snapshot in the destination Amazon Web Services Region. This is the same identifier for both the <code>CopyDBSnapshot</code> action that is called in the destination Amazon Web Services Region, and the action contained in the presigned URL.</p> </li>
        /// <li> <p> <code>SourceDBSnapshotIdentifier</code> - The DB snapshot identifier for the encrypted snapshot to be copied. This identifier must be in the Amazon Resource Name (ARN) format for the source Amazon Web Services Region. For example, if you are copying an encrypted DB snapshot from the us-west-2 Amazon Web Services Region, then your <code>SourceDBSnapshotIdentifier</code> looks like the following example: <code>arn:aws:rds:us-west-2:123456789012:snapshot:mysql-instance1-snapshot-20161115</code>.</p> </li>
        /// </ul>
        /// <p>To learn how to generate a Signature Version 4 signed request, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html">Authenticating Requests: Using Query Parameters (Amazon Web Services Signature Version 4)</a> and <a href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4 Signing Process</a>.</p> <note>
        /// <p>If you are using an Amazon Web Services SDK tool or the CLI, you can specify <code>SourceRegion</code> (or <code>--source-region</code> for the CLI) instead of specifying <code>PreSignedUrl</code> manually. Specifying <code>SourceRegion</code> autogenerates a pre-signed URL that is a valid request for the operation that can be executed in the source Amazon Web Services Region.</p>
        /// </note>
        pub fn pre_signed_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pre_signed_url(input.into());
            self
        }
        /// <p>The URL that contains a Signature Version 4 signed request for the <code>CopyDBSnapshot</code> API action in the source Amazon Web Services Region that contains the source DB snapshot to copy.</p>
        /// <p>You must specify this parameter when you copy an encrypted DB snapshot from another Amazon Web Services Region by using the Amazon RDS API. Don't specify <code>PreSignedUrl</code> when you are copying an encrypted DB snapshot in the same Amazon Web Services Region.</p>
        /// <p>The presigned URL must be a valid request for the <code>CopyDBSnapshot</code> API action that can be executed in the source Amazon Web Services Region that contains the encrypted DB snapshot to be copied. The presigned URL request must contain the following parameter values:</p>
        /// <ul>
        /// <li> <p> <code>DestinationRegion</code> - The Amazon Web Services Region that the encrypted DB snapshot is copied to. This Amazon Web Services Region is the same one where the <code>CopyDBSnapshot</code> action is called that contains this presigned URL.</p> <p>For example, if you copy an encrypted DB snapshot from the us-west-2 Amazon Web Services Region to the us-east-1 Amazon Web Services Region, then you call the <code>CopyDBSnapshot</code> action in the us-east-1 Amazon Web Services Region and provide a presigned URL that contains a call to the <code>CopyDBSnapshot</code> action in the us-west-2 Amazon Web Services Region. For this example, the <code>DestinationRegion</code> in the presigned URL must be set to the us-east-1 Amazon Web Services Region.</p> </li>
        /// <li> <p> <code>KmsKeyId</code> - The Amazon Web Services KMS key identifier for the KMS key to use to encrypt the copy of the DB snapshot in the destination Amazon Web Services Region. This is the same identifier for both the <code>CopyDBSnapshot</code> action that is called in the destination Amazon Web Services Region, and the action contained in the presigned URL.</p> </li>
        /// <li> <p> <code>SourceDBSnapshotIdentifier</code> - The DB snapshot identifier for the encrypted snapshot to be copied. This identifier must be in the Amazon Resource Name (ARN) format for the source Amazon Web Services Region. For example, if you are copying an encrypted DB snapshot from the us-west-2 Amazon Web Services Region, then your <code>SourceDBSnapshotIdentifier</code> looks like the following example: <code>arn:aws:rds:us-west-2:123456789012:snapshot:mysql-instance1-snapshot-20161115</code>.</p> </li>
        /// </ul>
        /// <p>To learn how to generate a Signature Version 4 signed request, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html">Authenticating Requests: Using Query Parameters (Amazon Web Services Signature Version 4)</a> and <a href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4 Signing Process</a>.</p> <note>
        /// <p>If you are using an Amazon Web Services SDK tool or the CLI, you can specify <code>SourceRegion</code> (or <code>--source-region</code> for the CLI) instead of specifying <code>PreSignedUrl</code> manually. Specifying <code>SourceRegion</code> autogenerates a pre-signed URL that is a valid request for the operation that can be executed in the source Amazon Web Services Region.</p>
        /// </note>
        pub fn set_pre_signed_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pre_signed_url(input);
            self
        }
        /// <p>The name of an option group to associate with the copy of the snapshot.</p>
        /// <p>Specify this option if you are copying a snapshot from one Amazon Web Services Region to another, and your DB instance uses a nondefault option group. If your source DB instance uses Transparent Data Encryption for Oracle or Microsoft SQL Server, you must specify this option when copying across Amazon Web Services Regions. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_CopySnapshot.html#USER_CopySnapshot.Options">Option group considerations</a> in the <i>Amazon RDS User Guide</i>.</p>
        pub fn option_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.option_group_name(input.into());
            self
        }
        /// <p>The name of an option group to associate with the copy of the snapshot.</p>
        /// <p>Specify this option if you are copying a snapshot from one Amazon Web Services Region to another, and your DB instance uses a nondefault option group. If your source DB instance uses Transparent Data Encryption for Oracle or Microsoft SQL Server, you must specify this option when copying across Amazon Web Services Regions. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_CopySnapshot.html#USER_CopySnapshot.Options">Option group considerations</a> in the <i>Amazon RDS User Guide</i>.</p>
        pub fn set_option_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_option_group_name(input);
            self
        }
        /// <p>The external custom Availability Zone (CAZ) identifier for the target CAZ.</p>
        /// <p>Example: <code>rds-caz-aiqhTgQv</code>.</p>
        pub fn target_custom_availability_zone(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.target_custom_availability_zone(input.into());
            self
        }
        /// <p>The external custom Availability Zone (CAZ) identifier for the target CAZ.</p>
        /// <p>Example: <code>rds-caz-aiqhTgQv</code>.</p>
        pub fn set_target_custom_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_target_custom_availability_zone(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CopyOptionGroup`.
    ///
    /// <p>Copies the specified option group.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CopyOptionGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::copy_option_group_input::Builder,
    }
    impl CopyOptionGroup {
        /// Creates a new `CopyOptionGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CopyOptionGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CopyOptionGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier for the source option group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must specify a valid option group.</p> </li>
        /// </ul>
        pub fn source_option_group_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.source_option_group_identifier(input.into());
            self
        }
        /// <p>The identifier for the source option group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must specify a valid option group.</p> </li>
        /// </ul>
        pub fn set_source_option_group_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_option_group_identifier(input);
            self
        }
        /// <p>The identifier for the copied option group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Can't be null, empty, or blank</p> </li>
        /// <li> <p>Must contain from 1 to 255 letters, numbers, or hyphens</p> </li>
        /// <li> <p>First character must be a letter</p> </li>
        /// <li> <p>Can't end with a hyphen or contain two consecutive hyphens</p> </li>
        /// </ul>
        /// <p>Example: <code>my-option-group</code> </p>
        pub fn target_option_group_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.target_option_group_identifier(input.into());
            self
        }
        /// <p>The identifier for the copied option group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Can't be null, empty, or blank</p> </li>
        /// <li> <p>Must contain from 1 to 255 letters, numbers, or hyphens</p> </li>
        /// <li> <p>First character must be a letter</p> </li>
        /// <li> <p>Can't end with a hyphen or contain two consecutive hyphens</p> </li>
        /// </ul>
        /// <p>Example: <code>my-option-group</code> </p>
        pub fn set_target_option_group_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_target_option_group_identifier(input);
            self
        }
        /// <p>The description for the copied option group.</p>
        pub fn target_option_group_description(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.target_option_group_description(input.into());
            self
        }
        /// <p>The description for the copied option group.</p>
        pub fn set_target_option_group_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_target_option_group_description(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources</a> in the <i>Amazon RDS User Guide.</i> </p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of tags. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources</a> in the <i>Amazon RDS User Guide.</i> </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateCustomDBEngineVersion`.
    ///
    /// <p>Creates a custom DB engine version (CEV). A CEV is a binary volume snapshot of a database engine and specific AMI. The supported engines are the following:</p>
    /// <ul>
    /// <li> <p>Oracle Database 12.1 Enterprise Edition with the January 2021 or later RU/RUR</p> </li>
    /// <li> <p>Oracle Database 19c Enterprise Edition with the January 2021 or later RU/RUR</p> </li>
    /// </ul>
    /// <p>Amazon RDS, which is a fully managed service, supplies the Amazon Machine Image (AMI) and database software. The Amazon RDS database software is preinstalled, so you need only select a DB engine and version, and create your database. With Amazon RDS Custom for Oracle, you upload your database installation files in Amazon S3.</p>
    /// <p>When you create a custom engine version, you specify the files in a JSON document called a CEV manifest. This document describes installation .zip files stored in Amazon S3. RDS Custom creates your CEV from the installation files that you provided. This service model is called Bring Your Own Media (BYOM).</p>
    /// <p>Creation takes approximately two hours. If creation fails, RDS Custom issues <code>RDS-EVENT-0196</code> with the message <code>Creation failed for custom engine version</code>, and includes details about the failure. For example, the event prints missing files.</p>
    /// <p>After you create the CEV, it is available for use. You can create multiple CEVs, and create multiple RDS Custom instances from any CEV. You can also change the status of a CEV to make it available or inactive.</p> <note>
    /// <p>The MediaImport service that imports files from Amazon S3 to create CEVs isn't integrated with Amazon Web Services CloudTrail. If you turn on data logging for Amazon RDS in CloudTrail, calls to the <code>CreateCustomDbEngineVersion</code> event aren't logged. However, you might see calls from the API gateway that accesses your Amazon S3 bucket. These calls originate from the MediaImport service for the <code>CreateCustomDbEngineVersion</code> event.</p>
    /// </note>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-cev.html#custom-cev.create"> Creating a CEV</a> in the <i>Amazon RDS User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateCustomDBEngineVersion {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_custom_db_engine_version_input::Builder,
    }
    impl CreateCustomDBEngineVersion {
        /// Creates a new `CreateCustomDBEngineVersion`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateCustomDbEngineVersionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateCustomDBEngineVersionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The database engine to use for your custom engine version (CEV). The only supported value is <code>custom-oracle-ee</code>.</p>
        pub fn engine(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine(input.into());
            self
        }
        /// <p>The database engine to use for your custom engine version (CEV). The only supported value is <code>custom-oracle-ee</code>.</p>
        pub fn set_engine(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_engine(input);
            self
        }
        /// <p>The name of your CEV. The name format is <code>19.<i>customized_string</i> </code>. For example, a valid name is <code>19.my_cev1</code>. This setting is required for RDS Custom for Oracle, but optional for Amazon RDS. The combination of <code>Engine</code> and <code>EngineVersion</code> is unique per customer per Region.</p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine_version(input.into());
            self
        }
        /// <p>The name of your CEV. The name format is <code>19.<i>customized_string</i> </code>. For example, a valid name is <code>19.my_cev1</code>. This setting is required for RDS Custom for Oracle, but optional for Amazon RDS. The combination of <code>Engine</code> and <code>EngineVersion</code> is unique per customer per Region.</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_engine_version(input);
            self
        }
        /// <p>The name of an Amazon S3 bucket that contains database installation files for your CEV. For example, a valid bucket name is <code>my-custom-installation-files</code>.</p>
        pub fn database_installation_files_s3_bucket_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .database_installation_files_s3_bucket_name(input.into());
            self
        }
        /// <p>The name of an Amazon S3 bucket that contains database installation files for your CEV. For example, a valid bucket name is <code>my-custom-installation-files</code>.</p>
        pub fn set_database_installation_files_s3_bucket_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .set_database_installation_files_s3_bucket_name(input);
            self
        }
        /// <p>The Amazon S3 directory that contains the database installation files for your CEV. For example, a valid bucket name is <code>123456789012/cev1</code>. If this setting isn't specified, no prefix is assumed.</p>
        pub fn database_installation_files_s3_prefix(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self
                .inner
                .database_installation_files_s3_prefix(input.into());
            self
        }
        /// <p>The Amazon S3 directory that contains the database installation files for your CEV. For example, a valid bucket name is <code>123456789012/cev1</code>. If this setting isn't specified, no prefix is assumed.</p>
        pub fn set_database_installation_files_s3_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_database_installation_files_s3_prefix(input);
            self
        }
        /// <p>The Amazon Web Services KMS key identifier for an encrypted CEV. A symmetric KMS key is required for RDS Custom, but optional for Amazon RDS.</p>
        /// <p>If you have an existing symmetric KMS key in your account, you can use it with RDS Custom. No further action is necessary. If you don't already have a symmetric KMS key in your account, follow the instructions in <a href="https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html#create-symmetric-cmk"> Creating symmetric KMS keys</a> in the <i>Amazon Web Services Key Management Service Developer Guide</i>.</p>
        /// <p>You can choose the same symmetric key when you create a CEV and a DB instance, or choose different keys.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key_id(input.into());
            self
        }
        /// <p>The Amazon Web Services KMS key identifier for an encrypted CEV. A symmetric KMS key is required for RDS Custom, but optional for Amazon RDS.</p>
        /// <p>If you have an existing symmetric KMS key in your account, you can use it with RDS Custom. No further action is necessary. If you don't already have a symmetric KMS key in your account, follow the instructions in <a href="https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html#create-symmetric-cmk"> Creating symmetric KMS keys</a> in the <i>Amazon Web Services Key Management Service Developer Guide</i>.</p>
        /// <p>You can choose the same symmetric key when you create a CEV and a DB instance, or choose different keys.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key_id(input);
            self
        }
        /// <p>An optional description of your CEV.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>An optional description of your CEV.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The CEV manifest, which is a JSON document that describes the installation .zip files stored in Amazon S3. Specify the name/value pairs in a file or a quoted string. RDS Custom applies the patches in the order in which they are listed.</p>
        /// <p>The following JSON fields are valid:</p>
        /// <dl>
        /// <dt>
        /// MediaImportTemplateVersion
        /// </dt>
        /// <dd>
        /// <p>Version of the CEV manifest. The date is in the format <code>YYYY-MM-DD</code>.</p>
        /// </dd>
        /// <dt>
        /// databaseInstallationFileNames
        /// </dt>
        /// <dd>
        /// <p>Ordered list of installation files for the CEV.</p>
        /// </dd>
        /// <dt>
        /// opatchFileNames
        /// </dt>
        /// <dd>
        /// <p>Ordered list of OPatch installers used for the Oracle DB engine.</p>
        /// </dd>
        /// <dt>
        /// psuRuPatchFileNames
        /// </dt>
        /// <dd>
        /// <p>The PSU and RU patches for this CEV.</p>
        /// </dd>
        /// <dt>
        /// OtherPatchFileNames
        /// </dt>
        /// <dd>
        /// <p>The patches that are not in the list of PSU and RU patches. Amazon RDS applies these patches after applying the PSU and RU patches.</p>
        /// </dd>
        /// </dl>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-cev.html#custom-cev.preparing.manifest"> Creating the CEV manifest</a> in the <i>Amazon RDS User Guide</i>.</p>
        pub fn manifest(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.manifest(input.into());
            self
        }
        /// <p>The CEV manifest, which is a JSON document that describes the installation .zip files stored in Amazon S3. Specify the name/value pairs in a file or a quoted string. RDS Custom applies the patches in the order in which they are listed.</p>
        /// <p>The following JSON fields are valid:</p>
        /// <dl>
        /// <dt>
        /// MediaImportTemplateVersion
        /// </dt>
        /// <dd>
        /// <p>Version of the CEV manifest. The date is in the format <code>YYYY-MM-DD</code>.</p>
        /// </dd>
        /// <dt>
        /// databaseInstallationFileNames
        /// </dt>
        /// <dd>
        /// <p>Ordered list of installation files for the CEV.</p>
        /// </dd>
        /// <dt>
        /// opatchFileNames
        /// </dt>
        /// <dd>
        /// <p>Ordered list of OPatch installers used for the Oracle DB engine.</p>
        /// </dd>
        /// <dt>
        /// psuRuPatchFileNames
        /// </dt>
        /// <dd>
        /// <p>The PSU and RU patches for this CEV.</p>
        /// </dd>
        /// <dt>
        /// OtherPatchFileNames
        /// </dt>
        /// <dd>
        /// <p>The patches that are not in the list of PSU and RU patches. Amazon RDS applies these patches after applying the PSU and RU patches.</p>
        /// </dd>
        /// </dl>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-cev.html#custom-cev.preparing.manifest"> Creating the CEV manifest</a> in the <i>Amazon RDS User Guide</i>.</p>
        pub fn set_manifest(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_manifest(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources</a> in the <i>Amazon RDS User Guide.</i> </p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A list of tags. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources</a> in the <i>Amazon RDS User Guide.</i> </p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDBCluster`.
    ///
    /// <p>Creates a new Amazon Aurora DB cluster or Multi-AZ DB cluster.</p>
    /// <p>You can use the <code>ReplicationSourceIdentifier</code> parameter to create an Amazon Aurora DB cluster as a read replica of another DB cluster or Amazon RDS MySQL or PostgreSQL DB instance. For cross-Region replication where the DB cluster identified by <code>ReplicationSourceIdentifier</code> is encrypted, also specify the <code>PreSignedUrl</code> parameter.</p>
    /// <p>For more information on Amazon Aurora, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon Aurora?</a> in the <i>Amazon Aurora User Guide</i>.</p>
    /// <p>For more information on Multi-AZ DB clusters, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ deployments with two readable standby DB instances</a> in the <i>Amazon RDS User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateDBCluster {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_db_cluster_input::Builder,
    }
    impl CreateDBCluster {
        /// Creates a new `CreateDBCluster`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDbClusterOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDBClusterError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `AvailabilityZones`.
        ///
        /// To override the contents of this collection use [`set_availability_zones`](Self::set_availability_zones).
        ///
        /// <p>A list of Availability Zones (AZs) where DB instances in the DB cluster can be created.</p>
        /// <p>For information on Amazon Web Services Regions and Availability Zones, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Concepts.RegionsAndAvailabilityZones.html">Choosing the Regions and Availability Zones</a> in the <i>Amazon Aurora User Guide</i>.</p>
        /// <p>Valid for: Aurora DB clusters only</p>
        pub fn availability_zones(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.availability_zones(input.into());
            self
        }
        /// <p>A list of Availability Zones (AZs) where DB instances in the DB cluster can be created.</p>
        /// <p>For information on Amazon Web Services Regions and Availability Zones, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Concepts.RegionsAndAvailabilityZones.html">Choosing the Regions and Availability Zones</a> in the <i>Amazon Aurora User Guide</i>.</p>
        /// <p>Valid for: Aurora DB clusters only</p>
        pub fn set_availability_zones(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_availability_zones(input);
            self
        }
        /// <p>The number of days for which automated backups are retained.</p>
        /// <p>Default: 1</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be a value from 1 to 35</p> </li>
        /// </ul>
        /// <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
        pub fn backup_retention_period(mut self, input: i32) -> Self {
            self.inner = self.inner.backup_retention_period(input);
            self
        }
        /// <p>The number of days for which automated backups are retained.</p>
        /// <p>Default: 1</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be a value from 1 to 35</p> </li>
        /// </ul>
        /// <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
        pub fn set_backup_retention_period(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_backup_retention_period(input);
            self
        }
        /// <p>A value that indicates that the DB cluster should be associated with the specified CharacterSet.</p>
        /// <p>Valid for: Aurora DB clusters only</p>
        pub fn character_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.character_set_name(input.into());
            self
        }
        /// <p>A value that indicates that the DB cluster should be associated with the specified CharacterSet.</p>
        /// <p>Valid for: Aurora DB clusters only</p>
        pub fn set_character_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_character_set_name(input);
            self
        }
        /// <p>The name for your database of up to 64 alphanumeric characters. If you do not provide a name, Amazon RDS doesn't create a database in the DB cluster you are creating.</p>
        /// <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
        pub fn database_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.database_name(input.into());
            self
        }
        /// <p>The name for your database of up to 64 alphanumeric characters. If you do not provide a name, Amazon RDS doesn't create a database in the DB cluster you are creating.</p>
        /// <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
        pub fn set_database_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_database_name(input);
            self
        }
        /// <p>The DB cluster identifier. This parameter is stored as a lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p> </li>
        /// <li> <p>First character must be a letter.</p> </li>
        /// <li> <p>Can't end with a hyphen or contain two consecutive hyphens.</p> </li>
        /// </ul>
        /// <p>Example: <code>my-cluster1</code> </p>
        /// <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
        pub fn db_cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_cluster_identifier(input.into());
            self
        }
        /// <p>The DB cluster identifier. This parameter is stored as a lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p> </li>
        /// <li> <p>First character must be a letter.</p> </li>
        /// <li> <p>Can't end with a hyphen or contain two consecutive hyphens.</p> </li>
        /// </ul>
        /// <p>Example: <code>my-cluster1</code> </p>
        /// <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_identifier(input);
            self
        }
        /// <p>The name of the DB cluster parameter group to associate with this DB cluster. If you do not specify a value, then the default DB cluster parameter group for the specified DB engine and version is used.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>If supplied, must match the name of an existing DB cluster parameter group.</p> </li>
        /// </ul>
        /// <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
        pub fn db_cluster_parameter_group_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.db_cluster_parameter_group_name(input.into());
            self
        }
        /// <p>The name of the DB cluster parameter group to associate with this DB cluster. If you do not specify a value, then the default DB cluster parameter group for the specified DB engine and version is used.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>If supplied, must match the name of an existing DB cluster parameter group.</p> </li>
        /// </ul>
        /// <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
        pub fn set_db_cluster_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_parameter_group_name(input);
            self
        }
        /// Appends an item to `VpcSecurityGroupIds`.
        ///
        /// To override the contents of this collection use [`set_vpc_security_group_ids`](Self::set_vpc_security_group_ids).
        ///
        /// <p>A list of EC2 VPC security groups to associate with this DB cluster.</p>
        /// <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
        pub fn vpc_security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc_security_group_ids(input.into());
            self
        }
        /// <p>A list of EC2 VPC security groups to associate with this DB cluster.</p>
        /// <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
        pub fn set_vpc_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_vpc_security_group_ids(input);
            self
        }
        /// <p>A DB subnet group to associate with this DB cluster.</p>
        /// <p>This setting is required to create a Multi-AZ DB cluster.</p>
        /// <p>Constraints: Must match the name of an existing DBSubnetGroup. Must not be default.</p>
        /// <p>Example: <code>mydbsubnetgroup</code> </p>
        /// <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
        pub fn db_subnet_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_subnet_group_name(input.into());
            self
        }
        /// <p>A DB subnet group to associate with this DB cluster.</p>
        /// <p>This setting is required to create a Multi-AZ DB cluster.</p>
        /// <p>Constraints: Must match the name of an existing DBSubnetGroup. Must not be default.</p>
        /// <p>Example: <code>mydbsubnetgroup</code> </p>
        /// <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
        pub fn set_db_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_subnet_group_name(input);
            self
        }
        /// <p>The name of the database engine to be used for this DB cluster.</p>
        /// <p>Valid Values:</p>
        /// <ul>
        /// <li> <p> <code>aurora</code> (for MySQL 5.6-compatible Aurora)</p> </li>
        /// <li> <p> <code>aurora-mysql</code> (for MySQL 5.7-compatible and MySQL 8.0-compatible Aurora)</p> </li>
        /// <li> <p> <code>aurora-postgresql</code> </p> </li>
        /// <li> <p> <code>mysql</code> </p> </li>
        /// <li> <p> <code>postgres</code> </p> </li>
        /// </ul>
        /// <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
        pub fn engine(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine(input.into());
            self
        }
        /// <p>The name of the database engine to be used for this DB cluster.</p>
        /// <p>Valid Values:</p>
        /// <ul>
        /// <li> <p> <code>aurora</code> (for MySQL 5.6-compatible Aurora)</p> </li>
        /// <li> <p> <code>aurora-mysql</code> (for MySQL 5.7-compatible and MySQL 8.0-compatible Aurora)</p> </li>
        /// <li> <p> <code>aurora-postgresql</code> </p> </li>
        /// <li> <p> <code>mysql</code> </p> </li>
        /// <li> <p> <code>postgres</code> </p> </li>
        /// </ul>
        /// <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
        pub fn set_engine(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_engine(input);
            self
        }
        /// <p>The version number of the database engine to use.</p>
        /// <p>To list all of the available engine versions for MySQL 5.6-compatible Aurora, use the following command:</p>
        /// <p> <code>aws rds describe-db-engine-versions --engine aurora --query "DBEngineVersions[].EngineVersion"</code> </p>
        /// <p>To list all of the available engine versions for MySQL 5.7-compatible and MySQL 8.0-compatible Aurora, use the following command:</p>
        /// <p> <code>aws rds describe-db-engine-versions --engine aurora-mysql --query "DBEngineVersions[].EngineVersion"</code> </p>
        /// <p>To list all of the available engine versions for Aurora PostgreSQL, use the following command:</p>
        /// <p> <code>aws rds describe-db-engine-versions --engine aurora-postgresql --query "DBEngineVersions[].EngineVersion"</code> </p>
        /// <p>To list all of the available engine versions for RDS for MySQL, use the following command:</p>
        /// <p> <code>aws rds describe-db-engine-versions --engine mysql --query "DBEngineVersions[].EngineVersion"</code> </p>
        /// <p>To list all of the available engine versions for RDS for PostgreSQL, use the following command:</p>
        /// <p> <code>aws rds describe-db-engine-versions --engine postgres --query "DBEngineVersions[].EngineVersion"</code> </p>
        /// <p> <b>Aurora MySQL</b> </p>
        /// <p>For information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraMySQL.Updates.html">MySQL on Amazon RDS Versions</a> in the <i>Amazon Aurora User Guide</i>.</p>
        /// <p> <b>Aurora PostgreSQL</b> </p>
        /// <p>For information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraPostgreSQL.Updates.20180305.html">Amazon Aurora PostgreSQL releases and engine versions</a> in the <i>Amazon Aurora User Guide</i>.</p>
        /// <p> <b>MySQL</b> </p>
        /// <p>For information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_MySQL.html#MySQL.Concepts.VersionMgmt">MySQL on Amazon RDS Versions</a> in the <i>Amazon RDS User Guide</i>.</p>
        /// <p> <b>PostgreSQL</b> </p>
        /// <p>For information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_PostgreSQL.html#PostgreSQL.Concepts">Amazon RDS for PostgreSQL versions and extensions</a> in the <i>Amazon RDS User Guide</i>.</p>
        /// <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine_version(input.into());
            self
        }
        /// <p>The version number of the database engine to use.</p>
        /// <p>To list all of the available engine versions for MySQL 5.6-compatible Aurora, use the following command:</p>
        /// <p> <code>aws rds describe-db-engine-versions --engine aurora --query "DBEngineVersions[].EngineVersion"</code> </p>
        /// <p>To list all of the available engine versions for MySQL 5.7-compatible and MySQL 8.0-compatible Aurora, use the following command:</p>
        /// <p> <code>aws rds describe-db-engine-versions --engine aurora-mysql --query "DBEngineVersions[].EngineVersion"</code> </p>
        /// <p>To list all of the available engine versions for Aurora PostgreSQL, use the following command:</p>
        /// <p> <code>aws rds describe-db-engine-versions --engine aurora-postgresql --query "DBEngineVersions[].EngineVersion"</code> </p>
        /// <p>To list all of the available engine versions for RDS for MySQL, use the following command:</p>
        /// <p> <code>aws rds describe-db-engine-versions --engine mysql --query "DBEngineVersions[].EngineVersion"</code> </p>
        /// <p>To list all of the available engine versions for RDS for PostgreSQL, use the following command:</p>
        /// <p> <code>aws rds describe-db-engine-versions --engine postgres --query "DBEngineVersions[].EngineVersion"</code> </p>
        /// <p> <b>Aurora MySQL</b> </p>
        /// <p>For information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraMySQL.Updates.html">MySQL on Amazon RDS Versions</a> in the <i>Amazon Aurora User Guide</i>.</p>
        /// <p> <b>Aurora PostgreSQL</b> </p>
        /// <p>For information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraPostgreSQL.Updates.20180305.html">Amazon Aurora PostgreSQL releases and engine versions</a> in the <i>Amazon Aurora User Guide</i>.</p>
        /// <p> <b>MySQL</b> </p>
        /// <p>For information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_MySQL.html#MySQL.Concepts.VersionMgmt">MySQL on Amazon RDS Versions</a> in the <i>Amazon RDS User Guide</i>.</p>
        /// <p> <b>PostgreSQL</b> </p>
        /// <p>For information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_PostgreSQL.html#PostgreSQL.Concepts">Amazon RDS for PostgreSQL versions and extensions</a> in the <i>Amazon RDS User Guide</i>.</p>
        /// <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_engine_version(input);
            self
        }
        /// <p>The port number on which the instances in the DB cluster accept connections.</p>
        /// <p> <b>RDS for MySQL and Aurora MySQL</b> </p>
        /// <p>Default: <code>3306</code> </p>
        /// <p>Valid values: <code>1150-65535</code> </p>
        /// <p> <b>RDS for PostgreSQL and Aurora PostgreSQL</b> </p>
        /// <p>Default: <code>5432</code> </p>
        /// <p>Valid values: <code>1150-65535</code> </p>
        /// <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
        pub fn port(mut self, input: i32) -> Self {
            self.inner = self.inner.port(input);
            self
        }
        /// <p>The port number on which the instances in the DB cluster accept connections.</p>
        /// <p> <b>RDS for MySQL and Aurora MySQL</b> </p>
        /// <p>Default: <code>3306</code> </p>
        /// <p>Valid values: <code>1150-65535</code> </p>
        /// <p> <b>RDS for PostgreSQL and Aurora PostgreSQL</b> </p>
        /// <p>Default: <code>5432</code> </p>
        /// <p>Valid values: <code>1150-65535</code> </p>
        /// <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_port(input);
            self
        }
        /// <p>The name of the master user for the DB cluster.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be 1 to 16 letters or numbers.</p> </li>
        /// <li> <p>First character must be a letter.</p> </li>
        /// <li> <p>Can't be a reserved word for the chosen database engine.</p> </li>
        /// </ul>
        /// <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
        pub fn master_username(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.master_username(input.into());
            self
        }
        /// <p>The name of the master user for the DB cluster.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be 1 to 16 letters or numbers.</p> </li>
        /// <li> <p>First character must be a letter.</p> </li>
        /// <li> <p>Can't be a reserved word for the chosen database engine.</p> </li>
        /// </ul>
        /// <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
        pub fn set_master_username(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_master_username(input);
            self
        }
        /// <p>The password for the master database user. This password can contain any printable ASCII character except "/", """, or "@".</p>
        /// <p>Constraints: Must contain from 8 to 41 characters.</p>
        /// <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
        pub fn master_user_password(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.master_user_password(input.into());
            self
        }
        /// <p>The password for the master database user. This password can contain any printable ASCII character except "/", """, or "@".</p>
        /// <p>Constraints: Must contain from 8 to 41 characters.</p>
        /// <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
        pub fn set_master_user_password(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_master_user_password(input);
            self
        }
        /// <p>A value that indicates that the DB cluster should be associated with the specified option group.</p>
        /// <p>DB clusters are associated with a default option group that can't be modified.</p>
        pub fn option_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.option_group_name(input.into());
            self
        }
        /// <p>A value that indicates that the DB cluster should be associated with the specified option group.</p>
        /// <p>DB clusters are associated with a default option group that can't be modified.</p>
        pub fn set_option_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_option_group_name(input);
            self
        }
        /// <p>The daily time range during which automated backups are created if automated backups are enabled using the <code>BackupRetentionPeriod</code> parameter.</p>
        /// <p>The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Web Services Region. To view the time blocks available, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.Backups.BackupWindow"> Backup window</a> in the <i>Amazon Aurora User Guide</i>.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be in the format <code>hh24:mi-hh24:mi</code>.</p> </li>
        /// <li> <p>Must be in Universal Coordinated Time (UTC).</p> </li>
        /// <li> <p>Must not conflict with the preferred maintenance window.</p> </li>
        /// <li> <p>Must be at least 30 minutes.</p> </li>
        /// </ul>
        /// <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
        pub fn preferred_backup_window(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.preferred_backup_window(input.into());
            self
        }
        /// <p>The daily time range during which automated backups are created if automated backups are enabled using the <code>BackupRetentionPeriod</code> parameter.</p>
        /// <p>The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Web Services Region. To view the time blocks available, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.Backups.BackupWindow"> Backup window</a> in the <i>Amazon Aurora User Guide</i>.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be in the format <code>hh24:mi-hh24:mi</code>.</p> </li>
        /// <li> <p>Must be in Universal Coordinated Time (UTC).</p> </li>
        /// <li> <p>Must not conflict with the preferred maintenance window.</p> </li>
        /// <li> <p>Must be at least 30 minutes.</p> </li>
        /// </ul>
        /// <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
        pub fn set_preferred_backup_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_preferred_backup_window(input);
            self
        }
        /// <p>The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).</p>
        /// <p>Format: <code>ddd:hh24:mi-ddd:hh24:mi</code> </p>
        /// <p>The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Web Services Region, occurring on a random day of the week. To see the time blocks available, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow.Aurora"> Adjusting the Preferred DB Cluster Maintenance Window</a> in the <i>Amazon Aurora User Guide</i>.</p>
        /// <p>Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.</p>
        /// <p>Constraints: Minimum 30-minute window.</p>
        /// <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
        pub fn preferred_maintenance_window(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.preferred_maintenance_window(input.into());
            self
        }
        /// <p>The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).</p>
        /// <p>Format: <code>ddd:hh24:mi-ddd:hh24:mi</code> </p>
        /// <p>The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Web Services Region, occurring on a random day of the week. To see the time blocks available, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow.Aurora"> Adjusting the Preferred DB Cluster Maintenance Window</a> in the <i>Amazon Aurora User Guide</i>.</p>
        /// <p>Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.</p>
        /// <p>Constraints: Minimum 30-minute window.</p>
        /// <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
        pub fn set_preferred_maintenance_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_preferred_maintenance_window(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the source DB instance or DB cluster if this DB cluster is created as a read replica.</p>
        /// <p>Valid for: Aurora DB clusters only</p>
        pub fn replication_source_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.replication_source_identifier(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the source DB instance or DB cluster if this DB cluster is created as a read replica.</p>
        /// <p>Valid for: Aurora DB clusters only</p>
        pub fn set_replication_source_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_replication_source_identifier(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags to assign to the DB cluster.</p>
        /// <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Tags to assign to the DB cluster.</p>
        /// <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>A value that indicates whether the DB cluster is encrypted.</p>
        /// <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
        pub fn storage_encrypted(mut self, input: bool) -> Self {
            self.inner = self.inner.storage_encrypted(input);
            self
        }
        /// <p>A value that indicates whether the DB cluster is encrypted.</p>
        /// <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
        pub fn set_storage_encrypted(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_storage_encrypted(input);
            self
        }
        /// <p>The Amazon Web Services KMS key identifier for an encrypted DB cluster.</p>
        /// <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key. To use a KMS key in a different Amazon Web Services account, specify the key ARN or alias ARN.</p>
        /// <p>When a KMS key isn't specified in <code>KmsKeyId</code>:</p>
        /// <ul>
        /// <li> <p>If <code>ReplicationSourceIdentifier</code> identifies an encrypted source, then Amazon RDS will use the KMS key used to encrypt the source. Otherwise, Amazon RDS will use your default KMS key.</p> </li>
        /// <li> <p>If the <code>StorageEncrypted</code> parameter is enabled and <code>ReplicationSourceIdentifier</code> isn't specified, then Amazon RDS will use your default KMS key.</p> </li>
        /// </ul>
        /// <p>There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account has a different default KMS key for each Amazon Web Services Region.</p>
        /// <p>If you create a read replica of an encrypted DB cluster in another Amazon Web Services Region, you must set <code>KmsKeyId</code> to a KMS key identifier that is valid in the destination Amazon Web Services Region. This KMS key is used to encrypt the read replica in that Amazon Web Services Region.</p>
        /// <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key_id(input.into());
            self
        }
        /// <p>The Amazon Web Services KMS key identifier for an encrypted DB cluster.</p>
        /// <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key. To use a KMS key in a different Amazon Web Services account, specify the key ARN or alias ARN.</p>
        /// <p>When a KMS key isn't specified in <code>KmsKeyId</code>:</p>
        /// <ul>
        /// <li> <p>If <code>ReplicationSourceIdentifier</code> identifies an encrypted source, then Amazon RDS will use the KMS key used to encrypt the source. Otherwise, Amazon RDS will use your default KMS key.</p> </li>
        /// <li> <p>If the <code>StorageEncrypted</code> parameter is enabled and <code>ReplicationSourceIdentifier</code> isn't specified, then Amazon RDS will use your default KMS key.</p> </li>
        /// </ul>
        /// <p>There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account has a different default KMS key for each Amazon Web Services Region.</p>
        /// <p>If you create a read replica of an encrypted DB cluster in another Amazon Web Services Region, you must set <code>KmsKeyId</code> to a KMS key identifier that is valid in the destination Amazon Web Services Region. This KMS key is used to encrypt the read replica in that Amazon Web Services Region.</p>
        /// <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key_id(input);
            self
        }
        /// <p>A URL that contains a Signature Version 4 signed request for the <code>CreateDBCluster</code> action to be called in the source Amazon Web Services Region where the DB cluster is replicated from. Specify <code>PreSignedUrl</code> only when you are performing cross-Region replication from an encrypted DB cluster.</p>
        /// <p>The pre-signed URL must be a valid request for the <code>CreateDBCluster</code> API action that can be executed in the source Amazon Web Services Region that contains the encrypted DB cluster to be copied.</p>
        /// <p>The pre-signed URL request must contain the following parameter values:</p>
        /// <ul>
        /// <li> <p> <code>KmsKeyId</code> - The Amazon Web Services KMS key identifier for the KMS key to use to encrypt the copy of the DB cluster in the destination Amazon Web Services Region. This should refer to the same KMS key for both the <code>CreateDBCluster</code> action that is called in the destination Amazon Web Services Region, and the action contained in the pre-signed URL.</p> </li>
        /// <li> <p> <code>DestinationRegion</code> - The name of the Amazon Web Services Region that Aurora read replica will be created in.</p> </li>
        /// <li> <p> <code>ReplicationSourceIdentifier</code> - The DB cluster identifier for the encrypted DB cluster to be copied. This identifier must be in the Amazon Resource Name (ARN) format for the source Amazon Web Services Region. For example, if you are copying an encrypted DB cluster from the us-west-2 Amazon Web Services Region, then your <code>ReplicationSourceIdentifier</code> would look like Example: <code>arn:aws:rds:us-west-2:123456789012:cluster:aurora-cluster1</code>.</p> </li>
        /// </ul>
        /// <p>To learn how to generate a Signature Version 4 signed request, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html"> Authenticating Requests: Using Query Parameters (Amazon Web Services Signature Version 4)</a> and <a href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html"> Signature Version 4 Signing Process</a>.</p> <note>
        /// <p>If you are using an Amazon Web Services SDK tool or the CLI, you can specify <code>SourceRegion</code> (or <code>--source-region</code> for the CLI) instead of specifying <code>PreSignedUrl</code> manually. Specifying <code>SourceRegion</code> autogenerates a pre-signed URL that is a valid request for the operation that can be executed in the source Amazon Web Services Region.</p>
        /// </note>
        /// <p>Valid for: Aurora DB clusters only</p>
        pub fn pre_signed_url(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.pre_signed_url(input.into());
            self
        }
        /// <p>A URL that contains a Signature Version 4 signed request for the <code>CreateDBCluster</code> action to be called in the source Amazon Web Services Region where the DB cluster is replicated from. Specify <code>PreSignedUrl</code> only when you are performing cross-Region replication from an encrypted DB cluster.</p>
        /// <p>The pre-signed URL must be a valid request for the <code>CreateDBCluster</code> API action that can be executed in the source Amazon Web Services Region that contains the encrypted DB cluster to be copied.</p>
        /// <p>The pre-signed URL request must contain the following parameter values:</p>
        /// <ul>
        /// <li> <p> <code>KmsKeyId</code> - The Amazon Web Services KMS key identifier for the KMS key to use to encrypt the copy of the DB cluster in the destination Amazon Web Services Region. This should refer to the same KMS key for both the <code>CreateDBCluster</code> action that is called in the destination Amazon Web Services Region, and the action contained in the pre-signed URL.</p> </li>
        /// <li> <p> <code>DestinationRegion</code> - The name of the Amazon Web Services Region that Aurora read replica will be created in.</p> </li>
        /// <li> <p> <code>ReplicationSourceIdentifier</code> - The DB cluster identifier for the encrypted DB cluster to be copied. This identifier must be in the Amazon Resource Name (ARN) format for the source Amazon Web Services Region. For example, if you are copying an encrypted DB cluster from the us-west-2 Amazon Web Services Region, then your <code>ReplicationSourceIdentifier</code> would look like Example: <code>arn:aws:rds:us-west-2:123456789012:cluster:aurora-cluster1</code>.</p> </li>
        /// </ul>
        /// <p>To learn how to generate a Signature Version 4 signed request, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html"> Authenticating Requests: Using Query Parameters (Amazon Web Services Signature Version 4)</a> and <a href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html"> Signature Version 4 Signing Process</a>.</p> <note>
        /// <p>If you are using an Amazon Web Services SDK tool or the CLI, you can specify <code>SourceRegion</code> (or <code>--source-region</code> for the CLI) instead of specifying <code>PreSignedUrl</code> manually. Specifying <code>SourceRegion</code> autogenerates a pre-signed URL that is a valid request for the operation that can be executed in the source Amazon Web Services Region.</p>
        /// </note>
        /// <p>Valid for: Aurora DB clusters only</p>
        pub fn set_pre_signed_url(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_pre_signed_url(input);
            self
        }
        /// <p>A value that indicates whether to enable mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts. By default, mapping isn't enabled.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.IAMDBAuth.html"> IAM Database Authentication</a> in the <i>Amazon Aurora User Guide.</i>.</p>
        /// <p>Valid for: Aurora DB clusters only</p>
        pub fn enable_iam_database_authentication(mut self, input: bool) -> Self {
            self.inner = self.inner.enable_iam_database_authentication(input);
            self
        }
        /// <p>A value that indicates whether to enable mapping of Amazon Web Services Identity and Access Management (IAM) accounts to database accounts. By default, mapping isn't enabled.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.IAMDBAuth.html"> IAM Database Authentication</a> in the <i>Amazon Aurora User Guide.</i>.</p>
        /// <p>Valid for: Aurora DB clusters only</p>
        pub fn set_enable_iam_database_authentication(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_enable_iam_database_authentication(input);
            self
        }
        /// <p>The target backtrack window, in seconds. To disable backtracking, set this value to 0.</p>
        /// <p>Default: 0</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>If specified, this value must be set to a number from 0 to 259,200 (72 hours).</p> </li>
        /// </ul>
        /// <p>Valid for: Aurora MySQL DB clusters only</p>
        pub fn backtrack_window(mut self, input: i64) -> Self {
            self.inner = self.inner.backtrack_window(input);
            self
        }
        /// <p>The target backtrack window, in seconds. To disable backtracking, set this value to 0.</p>
        /// <p>Default: 0</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>If specified, this value must be set to a number from 0 to 259,200 (72 hours).</p> </li>
        /// </ul>
        /// <p>Valid for: Aurora MySQL DB clusters only</p>
        pub fn set_backtrack_window(mut self, input: std::option::Option<i64>) -> Self {
            self.inner = self.inner.set_backtrack_window(input);
            self
        }
        /// Appends an item to `EnableCloudwatchLogsExports`.
        ///
        /// To override the contents of this collection use [`set_enable_cloudwatch_logs_exports`](Self::set_enable_cloudwatch_logs_exports).
        ///
        /// <p>The list of log types that need to be enabled for exporting to CloudWatch Logs. The values in the list depend on the DB engine being used.</p>
        /// <p> <b>RDS for MySQL</b> </p>
        /// <p>Possible values are <code>error</code>, <code>general</code>, and <code>slowquery</code>.</p>
        /// <p> <b>RDS for PostgreSQL</b> </p>
        /// <p>Possible values are <code>postgresql</code> and <code>upgrade</code>.</p>
        /// <p> <b>Aurora MySQL</b> </p>
        /// <p>Possible values are <code>audit</code>, <code>error</code>, <code>general</code>, and <code>slowquery</code>.</p>
        /// <p> <b>Aurora PostgreSQL</b> </p>
        /// <p>Possible value is <code>postgresql</code>.</p>
        /// <p>For more information about exporting CloudWatch Logs for Amazon RDS, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch">Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon RDS User Guide</i>.</p>
        /// <p>For more information about exporting CloudWatch Logs for Amazon Aurora, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch">Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon Aurora User Guide</i>.</p>
        /// <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
        pub fn enable_cloudwatch_logs_exports(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.enable_cloudwatch_logs_exports(input.into());
            self
        }
        /// <p>The list of log types that need to be enabled for exporting to CloudWatch Logs. The values in the list depend on the DB engine being used.</p>
        /// <p> <b>RDS for MySQL</b> </p>
        /// <p>Possible values are <code>error</code>, <code>general</code>, and <code>slowquery</code>.</p>
        /// <p> <b>RDS for PostgreSQL</b> </p>
        /// <p>Possible values are <code>postgresql</code> and <code>upgrade</code>.</p>
        /// <p> <b>Aurora MySQL</b> </p>
        /// <p>Possible values are <code>audit</code>, <code>error</code>, <code>general</code>, and <code>slowquery</code>.</p>
        /// <p> <b>Aurora PostgreSQL</b> </p>
        /// <p>Possible value is <code>postgresql</code>.</p>
        /// <p>For more information about exporting CloudWatch Logs for Amazon RDS, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch">Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon RDS User Guide</i>.</p>
        /// <p>For more information about exporting CloudWatch Logs for Amazon Aurora, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch">Publishing Database Logs to Amazon CloudWatch Logs</a> in the <i>Amazon Aurora User Guide</i>.</p>
        /// <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
        pub fn set_enable_cloudwatch_logs_exports(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_enable_cloudwatch_logs_exports(input);
            self
        }
        /// <p>The DB engine mode of the DB cluster, either <code>provisioned</code>, <code>serverless</code>, <code>parallelquery</code>, <code>global</code>, or <code>multimaster</code>.</p>
        /// <p>The <code>parallelquery</code> engine mode isn't required for Aurora MySQL version 1.23 and higher 1.x versions, and version 2.09 and higher 2.x versions.</p>
        /// <p>The <code>global</code> engine mode isn't required for Aurora MySQL version 1.22 and higher 1.x versions, and <code>global</code> engine mode isn't required for any 2.x versions.</p>
        /// <p>The <code>multimaster</code> engine mode only applies for DB clusters created with Aurora MySQL version 5.6.10a.</p>
        /// <p>For Aurora PostgreSQL, the <code>global</code> engine mode isn't required, and both the <code>parallelquery</code> and the <code>multimaster</code> engine modes currently aren't supported.</p>
        /// <p>Limitations and requirements apply to some DB engine modes. For more information, see the following sections in the <i>Amazon Aurora User Guide</i>:</p>
        /// <ul>
        /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.html#aurora-serverless.limitations"> Limitations of Aurora Serverless v1</a> </p> </li>
        /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-mysql-parallel-query.html#aurora-mysql-parallel-query-limitations"> Limitations of Parallel Query</a> </p> </li>
        /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-global-database.html#aurora-global-database.limitations"> Limitations of Aurora Global Databases</a> </p> </li>
        /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-multi-master.html#aurora-multi-master-limitations"> Limitations of Multi-Master Clusters</a> </p> </li>
        /// </ul>
        /// <p>Valid for: Aurora DB clusters only</p>
        pub fn engine_mode(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine_mode(input.into());
            self
        }
        /// <p>The DB engine mode of the DB cluster, either <code>provisioned</code>, <code>serverless</code>, <code>parallelquery</code>, <code>global</code>, or <code>multimaster</code>.</p>
        /// <p>The <code>parallelquery</code> engine mode isn't required for Aurora MySQL version 1.23 and higher 1.x versions, and version 2.09 and higher 2.x versions.</p>
        /// <p>The <code>global</code> engine mode isn't required for Aurora MySQL version 1.22 and higher 1.x versions, and <code>global</code> engine mode isn't required for any 2.x versions.</p>
        /// <p>The <code>multimaster</code> engine mode only applies for DB clusters created with Aurora MySQL version 5.6.10a.</p>
        /// <p>For Aurora PostgreSQL, the <code>global</code> engine mode isn't required, and both the <code>parallelquery</code> and the <code>multimaster</code> engine modes currently aren't supported.</p>
        /// <p>Limitations and requirements apply to some DB engine modes. For more information, see the following sections in the <i>Amazon Aurora User Guide</i>:</p>
        /// <ul>
        /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.html#aurora-serverless.limitations"> Limitations of Aurora Serverless v1</a> </p> </li>
        /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-mysql-parallel-query.html#aurora-mysql-parallel-query-limitations"> Limitations of Parallel Query</a> </p> </li>
        /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-global-database.html#aurora-global-database.limitations"> Limitations of Aurora Global Databases</a> </p> </li>
        /// <li> <p> <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-multi-master.html#aurora-multi-master-limitations"> Limitations of Multi-Master Clusters</a> </p> </li>
        /// </ul>
        /// <p>Valid for: Aurora DB clusters only</p>
        pub fn set_engine_mode(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_engine_mode(input);
            self
        }
        /// <p>For DB clusters in <code>serverless</code> DB engine mode, the scaling properties of the DB cluster.</p>
        /// <p>Valid for: Aurora DB clusters only</p>
        pub fn scaling_configuration(mut self, input: crate::model::ScalingConfiguration) -> Self {
            self.inner = self.inner.scaling_configuration(input);
            self
        }
        /// <p>For DB clusters in <code>serverless</code> DB engine mode, the scaling properties of the DB cluster.</p>
        /// <p>Valid for: Aurora DB clusters only</p>
        pub fn set_scaling_configuration(
            mut self,
            input: std::option::Option<crate::model::ScalingConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_scaling_configuration(input);
            self
        }
        /// <p>A value that indicates whether the DB cluster has deletion protection enabled. The database can't be deleted when deletion protection is enabled. By default, deletion protection isn't enabled.</p>
        /// <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
        pub fn deletion_protection(mut self, input: bool) -> Self {
            self.inner = self.inner.deletion_protection(input);
            self
        }
        /// <p>A value that indicates whether the DB cluster has deletion protection enabled. The database can't be deleted when deletion protection is enabled. By default, deletion protection isn't enabled.</p>
        /// <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
        pub fn set_deletion_protection(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_deletion_protection(input);
            self
        }
        /// <p>The global cluster ID of an Aurora cluster that becomes the primary cluster in the new global database cluster.</p>
        /// <p>Valid for: Aurora DB clusters only</p>
        pub fn global_cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.global_cluster_identifier(input.into());
            self
        }
        /// <p>The global cluster ID of an Aurora cluster that becomes the primary cluster in the new global database cluster.</p>
        /// <p>Valid for: Aurora DB clusters only</p>
        pub fn set_global_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_global_cluster_identifier(input);
            self
        }
        /// <p>A value that indicates whether to enable the HTTP endpoint for an Aurora Serverless v1 DB cluster. By default, the HTTP endpoint is disabled.</p>
        /// <p>When enabled, the HTTP endpoint provides a connectionless web service API for running SQL queries on the Aurora Serverless v1 DB cluster. You can also query your database from inside the RDS console with the query editor.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/data-api.html">Using the Data API for Aurora Serverless v1</a> in the <i>Amazon Aurora User Guide</i>.</p>
        /// <p>Valid for: Aurora DB clusters only</p>
        pub fn enable_http_endpoint(mut self, input: bool) -> Self {
            self.inner = self.inner.enable_http_endpoint(input);
            self
        }
        /// <p>A value that indicates whether to enable the HTTP endpoint for an Aurora Serverless v1 DB cluster. By default, the HTTP endpoint is disabled.</p>
        /// <p>When enabled, the HTTP endpoint provides a connectionless web service API for running SQL queries on the Aurora Serverless v1 DB cluster. You can also query your database from inside the RDS console with the query editor.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/data-api.html">Using the Data API for Aurora Serverless v1</a> in the <i>Amazon Aurora User Guide</i>.</p>
        /// <p>Valid for: Aurora DB clusters only</p>
        pub fn set_enable_http_endpoint(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enable_http_endpoint(input);
            self
        }
        /// <p>A value that indicates whether to copy all tags from the DB cluster to snapshots of the DB cluster. The default is not to copy them.</p>
        /// <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
        pub fn copy_tags_to_snapshot(mut self, input: bool) -> Self {
            self.inner = self.inner.copy_tags_to_snapshot(input);
            self
        }
        /// <p>A value that indicates whether to copy all tags from the DB cluster to snapshots of the DB cluster. The default is not to copy them.</p>
        /// <p>Valid for: Aurora DB clusters and Multi-AZ DB clusters</p>
        pub fn set_copy_tags_to_snapshot(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_copy_tags_to_snapshot(input);
            self
        }
        /// <p>The Active Directory directory ID to create the DB cluster in.</p>
        /// <p>For Amazon Aurora DB clusters, Amazon RDS can use Kerberos authentication to authenticate users that connect to the DB cluster.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/kerberos-authentication.html">Kerberos authentication</a> in the <i>Amazon Aurora User Guide</i>.</p>
        /// <p>Valid for: Aurora DB clusters only</p>
        pub fn domain(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain(input.into());
            self
        }
        /// <p>The Active Directory directory ID to create the DB cluster in.</p>
        /// <p>For Amazon Aurora DB clusters, Amazon RDS can use Kerberos authentication to authenticate users that connect to the DB cluster.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/kerberos-authentication.html">Kerberos authentication</a> in the <i>Amazon Aurora User Guide</i>.</p>
        /// <p>Valid for: Aurora DB clusters only</p>
        pub fn set_domain(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_domain(input);
            self
        }
        /// <p>Specify the name of the IAM role to be used when making API calls to the Directory Service.</p>
        /// <p>Valid for: Aurora DB clusters only</p>
        pub fn domain_iam_role_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.domain_iam_role_name(input.into());
            self
        }
        /// <p>Specify the name of the IAM role to be used when making API calls to the Directory Service.</p>
        /// <p>Valid for: Aurora DB clusters only</p>
        pub fn set_domain_iam_role_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_domain_iam_role_name(input);
            self
        }
        /// <p>A value that indicates whether to enable this DB cluster to forward write operations to the primary cluster of an Aurora global database (<code>GlobalCluster</code>). By default, write operations are not allowed on Aurora DB clusters that are secondary clusters in an Aurora global database.</p>
        /// <p>You can set this value only on Aurora DB clusters that are members of an Aurora global database. With this parameter enabled, a secondary cluster can forward writes to the current primary cluster and the resulting changes are replicated back to this cluster. For the primary DB cluster of an Aurora global database, this value is used immediately if the primary is demoted by the <code>FailoverGlobalCluster</code> API operation, but it does nothing until then.</p>
        /// <p>Valid for: Aurora DB clusters only</p>
        pub fn enable_global_write_forwarding(mut self, input: bool) -> Self {
            self.inner = self.inner.enable_global_write_forwarding(input);
            self
        }
        /// <p>A value that indicates whether to enable this DB cluster to forward write operations to the primary cluster of an Aurora global database (<code>GlobalCluster</code>). By default, write operations are not allowed on Aurora DB clusters that are secondary clusters in an Aurora global database.</p>
        /// <p>You can set this value only on Aurora DB clusters that are members of an Aurora global database. With this parameter enabled, a secondary cluster can forward writes to the current primary cluster and the resulting changes are replicated back to this cluster. For the primary DB cluster of an Aurora global database, this value is used immediately if the primary is demoted by the <code>FailoverGlobalCluster</code> API operation, but it does nothing until then.</p>
        /// <p>Valid for: Aurora DB clusters only</p>
        pub fn set_enable_global_write_forwarding(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.inner = self.inner.set_enable_global_write_forwarding(input);
            self
        }
        /// <p>The compute and memory capacity of each DB instance in the Multi-AZ DB cluster, for example db.m6g.xlarge. Not all DB instance classes are available in all Amazon Web Services Regions, or for all database engines.</p>
        /// <p>For the full list of DB instance classes and availability for your engine, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html">DB instance class</a> in the <i>Amazon RDS User Guide</i>.</p>
        /// <p>This setting is required to create a Multi-AZ DB cluster.</p>
        /// <p>Valid for: Multi-AZ DB clusters only</p>
        pub fn db_cluster_instance_class(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_cluster_instance_class(input.into());
            self
        }
        /// <p>The compute and memory capacity of each DB instance in the Multi-AZ DB cluster, for example db.m6g.xlarge. Not all DB instance classes are available in all Amazon Web Services Regions, or for all database engines.</p>
        /// <p>For the full list of DB instance classes and availability for your engine, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html">DB instance class</a> in the <i>Amazon RDS User Guide</i>.</p>
        /// <p>This setting is required to create a Multi-AZ DB cluster.</p>
        /// <p>Valid for: Multi-AZ DB clusters only</p>
        pub fn set_db_cluster_instance_class(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_instance_class(input);
            self
        }
        /// <p>The amount of storage in gibibytes (GiB) to allocate to each DB instance in the Multi-AZ DB cluster.</p>
        /// <p>This setting is required to create a Multi-AZ DB cluster.</p>
        /// <p>Valid for: Multi-AZ DB clusters only</p>
        pub fn allocated_storage(mut self, input: i32) -> Self {
            self.inner = self.inner.allocated_storage(input);
            self
        }
        /// <p>The amount of storage in gibibytes (GiB) to allocate to each DB instance in the Multi-AZ DB cluster.</p>
        /// <p>This setting is required to create a Multi-AZ DB cluster.</p>
        /// <p>Valid for: Multi-AZ DB clusters only</p>
        pub fn set_allocated_storage(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_allocated_storage(input);
            self
        }
        /// <p>Specifies the storage type to be associated with the DB cluster.</p>
        /// <p>This setting is required to create a Multi-AZ DB cluster.</p>
        /// <p>Valid values: <code>io1</code> </p>
        /// <p>When specified, a value for the <code>Iops</code> parameter is required.</p>
        /// <p>Default: <code>io1</code> </p>
        /// <p>Valid for: Multi-AZ DB clusters only</p>
        pub fn storage_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.storage_type(input.into());
            self
        }
        /// <p>Specifies the storage type to be associated with the DB cluster.</p>
        /// <p>This setting is required to create a Multi-AZ DB cluster.</p>
        /// <p>Valid values: <code>io1</code> </p>
        /// <p>When specified, a value for the <code>Iops</code> parameter is required.</p>
        /// <p>Default: <code>io1</code> </p>
        /// <p>Valid for: Multi-AZ DB clusters only</p>
        pub fn set_storage_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_storage_type(input);
            self
        }
        /// <p>The amount of Provisioned IOPS (input/output operations per second) to be initially allocated for each DB instance in the Multi-AZ DB cluster.</p>
        /// <p>For information about valid <code>Iops</code> values, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#USER_PIOPS">Amazon RDS Provisioned IOPS storage to improve performance</a> in the <i>Amazon RDS User Guide</i>.</p>
        /// <p>This setting is required to create a Multi-AZ DB cluster.</p>
        /// <p>Constraints: Must be a multiple between .5 and 50 of the storage amount for the DB cluster.</p>
        /// <p>Valid for: Multi-AZ DB clusters only</p>
        pub fn iops(mut self, input: i32) -> Self {
            self.inner = self.inner.iops(input);
            self
        }
        /// <p>The amount of Provisioned IOPS (input/output operations per second) to be initially allocated for each DB instance in the Multi-AZ DB cluster.</p>
        /// <p>For information about valid <code>Iops</code> values, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#USER_PIOPS">Amazon RDS Provisioned IOPS storage to improve performance</a> in the <i>Amazon RDS User Guide</i>.</p>
        /// <p>This setting is required to create a Multi-AZ DB cluster.</p>
        /// <p>Constraints: Must be a multiple between .5 and 50 of the storage amount for the DB cluster.</p>
        /// <p>Valid for: Multi-AZ DB clusters only</p>
        pub fn set_iops(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_iops(input);
            self
        }
        /// <p>A value that indicates whether the DB cluster is publicly accessible.</p>
        /// <p>When the DB cluster is publicly accessible, its Domain Name System (DNS) endpoint resolves to the private IP address from within the DB cluster's virtual private cloud (VPC). It resolves to the public IP address from outside of the DB cluster's VPC. Access to the DB cluster is ultimately controlled by the security group it uses. That public access isn't permitted if the security group assigned to the DB cluster doesn't permit it.</p>
        /// <p>When the DB cluster isn't publicly accessible, it is an internal DB cluster with a DNS name that resolves to a private IP address.</p>
        /// <p>Default: The default behavior varies depending on whether <code>DBSubnetGroupName</code> is specified.</p>
        /// <p>If <code>DBSubnetGroupName</code> isn't specified, and <code>PubliclyAccessible</code> isn't specified, the following applies:</p>
        /// <ul>
        /// <li> <p>If the default VPC in the target Region doesn’t have an internet gateway attached to it, the DB cluster is private.</p> </li>
        /// <li> <p>If the default VPC in the target Region has an internet gateway attached to it, the DB cluster is public.</p> </li>
        /// </ul>
        /// <p>If <code>DBSubnetGroupName</code> is specified, and <code>PubliclyAccessible</code> isn't specified, the following applies:</p>
        /// <ul>
        /// <li> <p>If the subnets are part of a VPC that doesn’t have an internet gateway attached to it, the DB cluster is private.</p> </li>
        /// <li> <p>If the subnets are part of a VPC that has an internet gateway attached to it, the DB cluster is public.</p> </li>
        /// </ul>
        /// <p>Valid for: Multi-AZ DB clusters only</p>
        pub fn publicly_accessible(mut self, input: bool) -> Self {
            self.inner = self.inner.publicly_accessible(input);
            self
        }
        /// <p>A value that indicates whether the DB cluster is publicly accessible.</p>
        /// <p>When the DB cluster is publicly accessible, its Domain Name System (DNS) endpoint resolves to the private IP address from within the DB cluster's virtual private cloud (VPC). It resolves to the public IP address from outside of the DB cluster's VPC. Access to the DB cluster is ultimately controlled by the security group it uses. That public access isn't permitted if the security group assigned to the DB cluster doesn't permit it.</p>
        /// <p>When the DB cluster isn't publicly accessible, it is an internal DB cluster with a DNS name that resolves to a private IP address.</p>
        /// <p>Default: The default behavior varies depending on whether <code>DBSubnetGroupName</code> is specified.</p>
        /// <p>If <code>DBSubnetGroupName</code> isn't specified, and <code>PubliclyAccessible</code> isn't specified, the following applies:</p>
        /// <ul>
        /// <li> <p>If the default VPC in the target Region doesn’t have an internet gateway attached to it, the DB cluster is private.</p> </li>
        /// <li> <p>If the default VPC in the target Region has an internet gateway attached to it, the DB cluster is public.</p> </li>
        /// </ul>
        /// <p>If <code>DBSubnetGroupName</code> is specified, and <code>PubliclyAccessible</code> isn't specified, the following applies:</p>
        /// <ul>
        /// <li> <p>If the subnets are part of a VPC that doesn’t have an internet gateway attached to it, the DB cluster is private.</p> </li>
        /// <li> <p>If the subnets are part of a VPC that has an internet gateway attached to it, the DB cluster is public.</p> </li>
        /// </ul>
        /// <p>Valid for: Multi-AZ DB clusters only</p>
        pub fn set_publicly_accessible(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_publicly_accessible(input);
            self
        }
        /// <p>A value that indicates whether minor engine upgrades are applied automatically to the DB cluster during the maintenance window. By default, minor engine upgrades are applied automatically.</p>
        /// <p>Valid for: Multi-AZ DB clusters only</p>
        pub fn auto_minor_version_upgrade(mut self, input: bool) -> Self {
            self.inner = self.inner.auto_minor_version_upgrade(input);
            self
        }
        /// <p>A value that indicates whether minor engine upgrades are applied automatically to the DB cluster during the maintenance window. By default, minor engine upgrades are applied automatically.</p>
        /// <p>Valid for: Multi-AZ DB clusters only</p>
        pub fn set_auto_minor_version_upgrade(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_auto_minor_version_upgrade(input);
            self
        }
        /// <p>The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB cluster. To turn off collecting Enhanced Monitoring metrics, specify 0. The default is 0.</p>
        /// <p>If <code>MonitoringRoleArn</code> is specified, also set <code>MonitoringInterval</code> to a value other than 0.</p>
        /// <p>Valid Values: <code>0, 1, 5, 10, 15, 30, 60</code> </p>
        /// <p>Valid for: Multi-AZ DB clusters only</p>
        pub fn monitoring_interval(mut self, input: i32) -> Self {
            self.inner = self.inner.monitoring_interval(input);
            self
        }
        /// <p>The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB cluster. To turn off collecting Enhanced Monitoring metrics, specify 0. The default is 0.</p>
        /// <p>If <code>MonitoringRoleArn</code> is specified, also set <code>MonitoringInterval</code> to a value other than 0.</p>
        /// <p>Valid Values: <code>0, 1, 5, 10, 15, 30, 60</code> </p>
        /// <p>Valid for: Multi-AZ DB clusters only</p>
        pub fn set_monitoring_interval(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_monitoring_interval(input);
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the IAM role that permits RDS to send Enhanced Monitoring metrics to Amazon CloudWatch Logs. An example is <code>arn:aws:iam:123456789012:role/emaccess</code>. For information on creating a monitoring role, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.OS.html#USER_Monitoring.OS.Enabling">Setting up and enabling Enhanced Monitoring</a> in the <i>Amazon RDS User Guide</i>.</p>
        /// <p>If <code>MonitoringInterval</code> is set to a value other than 0, supply a <code>MonitoringRoleArn</code> value.</p>
        /// <p>Valid for: Multi-AZ DB clusters only</p>
        pub fn monitoring_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.monitoring_role_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the IAM role that permits RDS to send Enhanced Monitoring metrics to Amazon CloudWatch Logs. An example is <code>arn:aws:iam:123456789012:role/emaccess</code>. For information on creating a monitoring role, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.OS.html#USER_Monitoring.OS.Enabling">Setting up and enabling Enhanced Monitoring</a> in the <i>Amazon RDS User Guide</i>.</p>
        /// <p>If <code>MonitoringInterval</code> is set to a value other than 0, supply a <code>MonitoringRoleArn</code> value.</p>
        /// <p>Valid for: Multi-AZ DB clusters only</p>
        pub fn set_monitoring_role_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_monitoring_role_arn(input);
            self
        }
        /// <p>A value that indicates whether to turn on Performance Insights for the DB cluster.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html"> Using Amazon Performance Insights</a> in the <i>Amazon RDS User Guide</i>.</p>
        /// <p>Valid for: Multi-AZ DB clusters only</p>
        pub fn enable_performance_insights(mut self, input: bool) -> Self {
            self.inner = self.inner.enable_performance_insights(input);
            self
        }
        /// <p>A value that indicates whether to turn on Performance Insights for the DB cluster.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html"> Using Amazon Performance Insights</a> in the <i>Amazon RDS User Guide</i>.</p>
        /// <p>Valid for: Multi-AZ DB clusters only</p>
        pub fn set_enable_performance_insights(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_enable_performance_insights(input);
            self
        }
        /// <p>The Amazon Web Services KMS key identifier for encryption of Performance Insights data.</p>
        /// <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.</p>
        /// <p>If you don't specify a value for <code>PerformanceInsightsKMSKeyId</code>, then Amazon RDS uses your default KMS key. There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account has a different default KMS key for each Amazon Web Services Region.</p>
        /// <p>Valid for: Multi-AZ DB clusters only</p>
        pub fn performance_insights_kms_key_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.performance_insights_kms_key_id(input.into());
            self
        }
        /// <p>The Amazon Web Services KMS key identifier for encryption of Performance Insights data.</p>
        /// <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.</p>
        /// <p>If you don't specify a value for <code>PerformanceInsightsKMSKeyId</code>, then Amazon RDS uses your default KMS key. There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account has a different default KMS key for each Amazon Web Services Region.</p>
        /// <p>Valid for: Multi-AZ DB clusters only</p>
        pub fn set_performance_insights_kms_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_performance_insights_kms_key_id(input);
            self
        }
        /// <p>The amount of time, in days, to retain Performance Insights data. Valid values are 7 or 731 (2 years).</p>
        /// <p>Valid for: Multi-AZ DB clusters only</p>
        pub fn performance_insights_retention_period(mut self, input: i32) -> Self {
            self.inner = self.inner.performance_insights_retention_period(input);
            self
        }
        /// <p>The amount of time, in days, to retain Performance Insights data. Valid values are 7 or 731 (2 years).</p>
        /// <p>Valid for: Multi-AZ DB clusters only</p>
        pub fn set_performance_insights_retention_period(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.inner = self.inner.set_performance_insights_retention_period(input);
            self
        }
        /// <p>Contains the scaling configuration of an Aurora Serverless v2 DB cluster.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless-v2.html">Using Amazon Aurora Serverless v2</a> in the <i>Amazon Aurora User Guide</i>.</p>
        pub fn serverless_v2_scaling_configuration(
            mut self,
            input: crate::model::ServerlessV2ScalingConfiguration,
        ) -> Self {
            self.inner = self.inner.serverless_v2_scaling_configuration(input);
            self
        }
        /// <p>Contains the scaling configuration of an Aurora Serverless v2 DB cluster.</p>
        /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless-v2.html">Using Amazon Aurora Serverless v2</a> in the <i>Amazon Aurora User Guide</i>.</p>
        pub fn set_serverless_v2_scaling_configuration(
            mut self,
            input: std::option::Option<crate::model::ServerlessV2ScalingConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_serverless_v2_scaling_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDBClusterEndpoint`.
    ///
    /// <p>Creates a new custom endpoint and associates it with an Amazon Aurora DB cluster.</p> <note>
    /// <p>This action only applies to Aurora DB clusters.</p>
    /// </note>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateDBClusterEndpoint {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_db_cluster_endpoint_input::Builder,
    }
    impl CreateDBClusterEndpoint {
        /// Creates a new `CreateDBClusterEndpoint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDbClusterEndpointOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDBClusterEndpointError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The DB cluster identifier of the DB cluster associated with the endpoint. This parameter is stored as a lowercase string.</p>
        pub fn db_cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_cluster_identifier(input.into());
            self
        }
        /// <p>The DB cluster identifier of the DB cluster associated with the endpoint. This parameter is stored as a lowercase string.</p>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_identifier(input);
            self
        }
        /// <p>The identifier to use for the new endpoint. This parameter is stored as a lowercase string.</p>
        pub fn db_cluster_endpoint_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.db_cluster_endpoint_identifier(input.into());
            self
        }
        /// <p>The identifier to use for the new endpoint. This parameter is stored as a lowercase string.</p>
        pub fn set_db_cluster_endpoint_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_endpoint_identifier(input);
            self
        }
        /// <p>The type of the endpoint, one of: <code>READER</code>, <code>WRITER</code>, <code>ANY</code>.</p>
        pub fn endpoint_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.endpoint_type(input.into());
            self
        }
        /// <p>The type of the endpoint, one of: <code>READER</code>, <code>WRITER</code>, <code>ANY</code>.</p>
        pub fn set_endpoint_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_endpoint_type(input);
            self
        }
        /// Appends an item to `StaticMembers`.
        ///
        /// To override the contents of this collection use [`set_static_members`](Self::set_static_members).
        ///
        /// <p>List of DB instance identifiers that are part of the custom endpoint group.</p>
        pub fn static_members(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.static_members(input.into());
            self
        }
        /// <p>List of DB instance identifiers that are part of the custom endpoint group.</p>
        pub fn set_static_members(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_static_members(input);
            self
        }
        /// Appends an item to `ExcludedMembers`.
        ///
        /// To override the contents of this collection use [`set_excluded_members`](Self::set_excluded_members).
        ///
        /// <p>List of DB instance identifiers that aren't part of the custom endpoint group. All other eligible instances are reachable through the custom endpoint. This parameter is relevant only if the list of static members is empty.</p>
        pub fn excluded_members(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.excluded_members(input.into());
            self
        }
        /// <p>List of DB instance identifiers that aren't part of the custom endpoint group. All other eligible instances are reachable through the custom endpoint. This parameter is relevant only if the list of static members is empty.</p>
        pub fn set_excluded_members(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_excluded_members(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be assigned to the Amazon RDS resource.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags to be assigned to the Amazon RDS resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDBClusterParameterGroup`.
    ///
    /// <p>Creates a new DB cluster parameter group.</p>
    /// <p>Parameters in a DB cluster parameter group apply to all of the instances in a DB cluster.</p>
    /// <p>A DB cluster parameter group is initially created with the default parameters for the database engine used by instances in the DB cluster. To provide custom values for any of the parameters, you must modify the group after creating it using <code>ModifyDBClusterParameterGroup</code>. Once you've created a DB cluster parameter group, you need to associate it with your DB cluster using <code>ModifyDBCluster</code>.</p>
    /// <p>When you associate a new DB cluster parameter group with a running Aurora DB cluster, reboot the DB instances in the DB cluster without failover for the new DB cluster parameter group and associated settings to take effect.</p>
    /// <p>When you associate a new DB cluster parameter group with a running Multi-AZ DB cluster, reboot the DB cluster without failover for the new DB cluster parameter group and associated settings to take effect.</p> <important>
    /// <p>After you create a DB cluster parameter group, you should wait at least 5 minutes before creating your first DB cluster that uses that DB cluster parameter group as the default parameter group. This allows Amazon RDS to fully complete the create action before the DB cluster parameter group is used as the default for a new DB cluster. This is especially important for parameters that are critical when creating the default database for a DB cluster, such as the character set for the default database defined by the <code>character_set_database</code> parameter. You can use the <i>Parameter Groups</i> option of the <a href="https://console.aws.amazon.com/rds/">Amazon RDS console</a> or the <code>DescribeDBClusterParameters</code> action to verify that your DB cluster parameter group has been created or modified.</p>
    /// </important>
    /// <p>For more information on Amazon Aurora, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon Aurora?</a> in the <i>Amazon Aurora User Guide</i>.</p>
    /// <p>For more information on Multi-AZ DB clusters, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ deployments with two readable standby DB instances</a> in the <i>Amazon RDS User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateDBClusterParameterGroup {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_db_cluster_parameter_group_input::Builder,
    }
    impl CreateDBClusterParameterGroup {
        /// Creates a new `CreateDBClusterParameterGroup`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDbClusterParameterGroupOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDBClusterParameterGroupError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the DB cluster parameter group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must not match the name of an existing DB cluster parameter group.</p> </li>
        /// </ul> <note>
        /// <p>This value is stored as a lowercase string.</p>
        /// </note>
        pub fn db_cluster_parameter_group_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.db_cluster_parameter_group_name(input.into());
            self
        }
        /// <p>The name of the DB cluster parameter group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must not match the name of an existing DB cluster parameter group.</p> </li>
        /// </ul> <note>
        /// <p>This value is stored as a lowercase string.</p>
        /// </note>
        pub fn set_db_cluster_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_parameter_group_name(input);
            self
        }
        /// <p>The DB cluster parameter group family name. A DB cluster parameter group can be associated with one and only one DB cluster parameter group family, and can be applied only to a DB cluster running a database engine and engine version compatible with that DB cluster parameter group family.</p>
        /// <p> <b>Aurora MySQL</b> </p>
        /// <p>Example: <code>aurora5.6</code>, <code>aurora-mysql5.7</code>, <code>aurora-mysql8.0</code> </p>
        /// <p> <b>Aurora PostgreSQL</b> </p>
        /// <p>Example: <code>aurora-postgresql9.6</code> </p>
        /// <p> <b>RDS for MySQL</b> </p>
        /// <p>Example: <code>mysql8.0</code> </p>
        /// <p> <b>RDS for PostgreSQL</b> </p>
        /// <p>Example: <code>postgres12</code> </p>
        /// <p>To list all of the available parameter group families for a DB engine, use the following command:</p>
        /// <p> <code>aws rds describe-db-engine-versions --query "DBEngineVersions[].DBParameterGroupFamily" --engine
        /// <engine></engine></code> </p>
        /// <p>For example, to list all of the available parameter group families for the Aurora PostgreSQL DB engine, use the following command:</p>
        /// <p> <code>aws rds describe-db-engine-versions --query "DBEngineVersions[].DBParameterGroupFamily" --engine aurora-postgresql</code> </p> <note>
        /// <p>The output contains duplicates.</p>
        /// </note>
        /// <p>The following are the valid DB engine values:</p>
        /// <ul>
        /// <li> <p> <code>aurora</code> (for MySQL 5.6-compatible Aurora)</p> </li>
        /// <li> <p> <code>aurora-mysql</code> (for MySQL 5.7-compatible and MySQL 8.0-compatible Aurora)</p> </li>
        /// <li> <p> <code>aurora-postgresql</code> </p> </li>
        /// <li> <p> <code>mysql</code> </p> </li>
        /// <li> <p> <code>postgres</code> </p> </li>
        /// </ul>
        pub fn db_parameter_group_family(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_parameter_group_family(input.into());
            self
        }
        /// <p>The DB cluster parameter group family name. A DB cluster parameter group can be associated with one and only one DB cluster parameter group family, and can be applied only to a DB cluster running a database engine and engine version compatible with that DB cluster parameter group family.</p>
        /// <p> <b>Aurora MySQL</b> </p>
        /// <p>Example: <code>aurora5.6</code>, <code>aurora-mysql5.7</code>, <code>aurora-mysql8.0</code> </p>
        /// <p> <b>Aurora PostgreSQL</b> </p>
        /// <p>Example: <code>aurora-postgresql9.6</code> </p>
        /// <p> <b>RDS for MySQL</b> </p>
        /// <p>Example: <code>mysql8.0</code> </p>
        /// <p> <b>RDS for PostgreSQL</b> </p>
        /// <p>Example: <code>postgres12</code> </p>
        /// <p>To list all of the available parameter group families for a DB engine, use the following command:</p>
        /// <p> <code>aws rds describe-db-engine-versions --query "DBEngineVersions[].DBParameterGroupFamily" --engine
        /// <engine></engine></code> </p>
        /// <p>For example, to list all of the available parameter group families for the Aurora PostgreSQL DB engine, use the following command:</p>
        /// <p> <code>aws rds describe-db-engine-versions --query "DBEngineVersions[].DBParameterGroupFamily" --engine aurora-postgresql</code> </p> <note>
        /// <p>The output contains duplicates.</p>
        /// </note>
        /// <p>The following are the valid DB engine values:</p>
        /// <ul>
        /// <li> <p> <code>aurora</code> (for MySQL 5.6-compatible Aurora)</p> </li>
        /// <li> <p> <code>aurora-mysql</code> (for MySQL 5.7-compatible and MySQL 8.0-compatible Aurora)</p> </li>
        /// <li> <p> <code>aurora-postgresql</code> </p> </li>
        /// <li> <p> <code>mysql</code> </p> </li>
        /// <li> <p> <code>postgres</code> </p> </li>
        /// </ul>
        pub fn set_db_parameter_group_family(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_parameter_group_family(input);
            self
        }
        /// <p>The description for the DB cluster parameter group.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>The description for the DB cluster parameter group.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags to assign to the DB cluster parameter group.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>Tags to assign to the DB cluster parameter group.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDBClusterSnapshot`.
    ///
    /// <p>Creates a snapshot of a DB cluster.</p>
    /// <p>For more information on Amazon Aurora, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon Aurora?</a> in the <i>Amazon Aurora User Guide</i>.</p>
    /// <p>For more information on Multi-AZ DB clusters, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ deployments with two readable standby DB instances</a> in the <i>Amazon RDS User Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateDBClusterSnapshot {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_db_cluster_snapshot_input::Builder,
    }
    impl CreateDBClusterSnapshot {
        /// Creates a new `CreateDBClusterSnapshot`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDbClusterSnapshotOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDBClusterSnapshotError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The identifier of the DB cluster snapshot. This parameter is stored as a lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p> </li>
        /// <li> <p>First character must be a letter.</p> </li>
        /// <li> <p>Can't end with a hyphen or contain two consecutive hyphens.</p> </li>
        /// </ul>
        /// <p>Example: <code>my-cluster1-snapshot1</code> </p>
        pub fn db_cluster_snapshot_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.db_cluster_snapshot_identifier(input.into());
            self
        }
        /// <p>The identifier of the DB cluster snapshot. This parameter is stored as a lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p> </li>
        /// <li> <p>First character must be a letter.</p> </li>
        /// <li> <p>Can't end with a hyphen or contain two consecutive hyphens.</p> </li>
        /// </ul>
        /// <p>Example: <code>my-cluster1-snapshot1</code> </p>
        pub fn set_db_cluster_snapshot_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_snapshot_identifier(input);
            self
        }
        /// <p>The identifier of the DB cluster to create a snapshot for. This parameter isn't case-sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must match the identifier of an existing DBCluster.</p> </li>
        /// </ul>
        /// <p>Example: <code>my-cluster1</code> </p>
        pub fn db_cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_cluster_identifier(input.into());
            self
        }
        /// <p>The identifier of the DB cluster to create a snapshot for. This parameter isn't case-sensitive.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must match the identifier of an existing DBCluster.</p> </li>
        /// </ul>
        /// <p>Example: <code>my-cluster1</code> </p>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_cluster_identifier(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to be assigned to the DB cluster snapshot.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The tags to be assigned to the DB cluster snapshot.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDBInstance`.
    ///
    /// <p>Creates a new DB instance.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateDBInstance {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_db_instance_input::Builder,
    }
    impl CreateDBInstance {
        /// Creates a new `CreateDBInstance`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDbInstanceOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDBInstanceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The meaning of this parameter differs according to the database engine you use.</p>
        /// <p> <b>MySQL</b> </p>
        /// <p>The name of the database to create when the DB instance is created. If this parameter isn't specified, no database is created in the DB instance.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must contain 1 to 64 letters or numbers.</p> </li>
        /// <li> <p>Must begin with a letter. Subsequent characters can be letters, underscores, or digits (0-9).</p> </li>
        /// <li> <p>Can't be a word reserved by the specified database engine</p> </li>
        /// </ul>
        /// <p> <b>MariaDB</b> </p>
        /// <p>The name of the database to create when the DB instance is created. If this parameter isn't specified, no database is created in the DB instance.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must contain 1 to 64 letters or numbers.</p> </li>
        /// <li> <p>Must begin with a letter. Subsequent characters can be letters, underscores, or digits (0-9).</p> </li>
        /// <li> <p>Can't be a word reserved by the specified database engine</p> </li>
        /// </ul>
        /// <p> <b>PostgreSQL</b> </p>
        /// <p>The name of the database to create when the DB instance is created. If this parameter isn't specified, a database named <code>postgres</code> is created in the DB instance.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must contain 1 to 63 letters, numbers, or underscores.</p> </li>
        /// <li> <p>Must begin with a letter. Subsequent characters can be letters, underscores, or digits (0-9).</p> </li>
        /// <li> <p>Can't be a word reserved by the specified database engine</p> </li>
        /// </ul>
        /// <p> <b>Oracle</b> </p>
        /// <p>The Oracle System ID (SID) of the created DB instance. If you specify <code>null</code>, the default value <code>ORCL</code> is used. You can't specify the string NULL, or any other reserved word, for <code>DBName</code>.</p>
        /// <p>Default: <code>ORCL</code> </p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Can't be longer than 8 characters</p> </li>
        /// </ul>
        /// <p> <b>Amazon RDS Custom for Oracle</b> </p>
        /// <p>The Oracle System ID (SID) of the created RDS Custom DB instance. If you don't specify a value, the default value is <code>ORCL</code>.</p>
        /// <p>Default: <code>ORCL</code> </p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>It must contain 1 to 8 alphanumeric characters.</p> </li>
        /// <li> <p>It must contain a letter.</p> </li>
        /// <li> <p>It can't be a word reserved by the database engine.</p> </li>
        /// </ul>
        /// <p> <b>Amazon RDS Custom for SQL Server</b> </p>
        /// <p>Not applicable. Must be null.</p>
        /// <p> <b>SQL Server</b> </p>
        /// <p>Not applicable. Must be null.</p>
        /// <p> <b>Amazon Aurora MySQL</b> </p>
        /// <p>The name of the database to create when the primary DB instance of the Aurora MySQL DB cluster is created. If this parameter isn't specified for an Aurora MySQL DB cluster, no database is created in the DB cluster.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>It must contain 1 to 64 alphanumeric characters.</p> </li>
        /// <li> <p>It can't be a word reserved by the database engine.</p> </li>
        /// </ul>
        /// <p> <b>Amazon Aurora PostgreSQL</b> </p>
        /// <p>The name of the database to create when the primary DB instance of the Aurora PostgreSQL DB cluster is created. If this parameter isn't specified for an Aurora PostgreSQL DB cluster, a database named <code>postgres</code> is created in the DB cluster.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>It must contain 1 to 63 alphanumeric characters.</p> </li>
        /// <li> <p>It must begin with a letter or an underscore. Subsequent characters can be letters, underscores, or digits (0 to 9).</p> </li>
        /// <li> <p>It can't be a word reserved by the database engine.</p> </li>
        /// </ul>
        pub fn db_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_name(input.into());
            self
        }
        /// <p>The meaning of this parameter differs according to the database engine you use.</p>
        /// <p> <b>MySQL</b> </p>
        /// <p>The name of the database to create when the DB instance is created. If this parameter isn't specified, no database is created in the DB instance.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must contain 1 to 64 letters or numbers.</p> </li>
        /// <li> <p>Must begin with a letter. Subsequent characters can be letters, underscores, or digits (0-9).</p> </li>
        /// <li> <p>Can't be a word reserved by the specified database engine</p> </li>
        /// </ul>
        /// <p> <b>MariaDB</b> </p>
        /// <p>The name of the database to create when the DB instance is created. If this parameter isn't specified, no database is created in the DB instance.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must contain 1 to 64 letters or numbers.</p> </li>
        /// <li> <p>Must begin with a letter. Subsequent characters can be letters, underscores, or digits (0-9).</p> </li>
        /// <li> <p>Can't be a word reserved by the specified database engine</p> </li>
        /// </ul>
        /// <p> <b>PostgreSQL</b> </p>
        /// <p>The name of the database to create when the DB instance is created. If this parameter isn't specified, a database named <code>postgres</code> is created in the DB instance.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must contain 1 to 63 letters, numbers, or underscores.</p> </li>
        /// <li> <p>Must begin with a letter. Subsequent characters can be letters, underscores, or digits (0-9).</p> </li>
        /// <li> <p>Can't be a word reserved by the specified database engine</p> </li>
        /// </ul>
        /// <p> <b>Oracle</b> </p>
        /// <p>The Oracle System ID (SID) of the created DB instance. If you specify <code>null</code>, the default value <code>ORCL</code> is used. You can't specify the string NULL, or any other reserved word, for <code>DBName</code>.</p>
        /// <p>Default: <code>ORCL</code> </p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Can't be longer than 8 characters</p> </li>
        /// </ul>
        /// <p> <b>Amazon RDS Custom for Oracle</b> </p>
        /// <p>The Oracle System ID (SID) of the created RDS Custom DB instance. If you don't specify a value, the default value is <code>ORCL</code>.</p>
        /// <p>Default: <code>ORCL</code> </p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>It must contain 1 to 8 alphanumeric characters.</p> </li>
        /// <li> <p>It must contain a letter.</p> </li>
        /// <li> <p>It can't be a word reserved by the database engine.</p> </li>
        /// </ul>
        /// <p> <b>Amazon RDS Custom for SQL Server</b> </p>
        /// <p>Not applicable. Must be null.</p>
        /// <p> <b>SQL Server</b> </p>
        /// <p>Not applicable. Must be null.</p>
        /// <p> <b>Amazon Aurora MySQL</b> </p>
        /// <p>The name of the database to create when the primary DB instance of the Aurora MySQL DB cluster is created. If this parameter isn't specified for an Aurora MySQL DB cluster, no database is created in the DB cluster.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>It must contain 1 to 64 alphanumeric characters.</p> </li>
        /// <li> <p>It can't be a word reserved by the database engine.</p> </li>
        /// </ul>
        /// <p> <b>Amazon Aurora PostgreSQL</b> </p>
        /// <p>The name of the database to create when the primary DB instance of the Aurora PostgreSQL DB cluster is created. If this parameter isn't specified for an Aurora PostgreSQL DB cluster, a database named <code>postgres</code> is created in the DB cluster.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>It must contain 1 to 63 alphanumeric characters.</p> </li>
        /// <li> <p>It must begin with a letter or an underscore. Subsequent characters can be letters, underscores, or digits (0 to 9).</p> </li>
        /// <li> <p>It can't be a word reserved by the database engine.</p> </li>
        /// </ul>
        pub fn set_db_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_db_name(input);
            self
        }
        /// <p>The DB instance identifier. This parameter is stored as a lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p> </li>
        /// <li> <p>First character must be a letter.</p> </li>
        /// <li> <p>Can't end with a hyphen or contain two consecutive hyphens.</p> </li>
        /// </ul>
        /// <p>Example: <code>mydbinstance</code> </p>
        pub fn db_instance_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_instance_identifier(input.into());
            self
        }
        /// <p>The DB instance identifier. This parameter is stored as a lowercase string.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must contain from 1 to 63 letters, numbers, or hyphens.</p> </li>
        /// <li> <p>First character must be a letter.</p> </li>
        /// <li> <p>Can't end with a hyphen or contain two consecutive hyphens.</p> </li>
        /// </ul>
        /// <p>Example: <code>mydbinstance</code> </p>
        pub fn set_db_instance_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_instance_identifier(input);
            self
        }
        /// <p>The amount of storage in gibibytes (GiB) to allocate for the DB instance.</p>
        /// <p>Type: Integer</p>
        /// <p> <b>Amazon Aurora</b> </p>
        /// <p>Not applicable. Aurora cluster volumes automatically grow as the amount of data in your database increases, though you are only charged for the space that you use in an Aurora cluster volume.</p>
        /// <p> <b>Amazon RDS Custom</b> </p>
        /// <p>Constraints to the amount of storage for each storage type are the following:</p>
        /// <ul>
        /// <li> <p>General Purpose (SSD) storage (gp2): Must be an integer from 40 to 65536 for RDS Custom for Oracle, 16384 for RDS Custom for SQL Server.</p> </li>
        /// <li> <p>Provisioned IOPS storage (io1): Must be an integer from 40 to 65536 for RDS Custom for Oracle, 16384 for RDS Custom for SQL Server.</p> </li>
        /// </ul>
        /// <p> <b>MySQL</b> </p>
        /// <p>Constraints to the amount of storage for each storage type are the following:</p>
        /// <ul>
        /// <li> <p>General Purpose (SSD) storage (gp2): Must be an integer from 20 to 65536.</p> </li>
        /// <li> <p>Provisioned IOPS storage (io1): Must be an integer from 100 to 65536.</p> </li>
        /// <li> <p>Magnetic storage (standard): Must be an integer from 5 to 3072.</p> </li>
        /// </ul>
        /// <p> <b>MariaDB</b> </p>
        /// <p>Constraints to the amount of storage for each storage type are the following:</p>
        /// <ul>
        /// <li> <p>General Purpose (SSD) storage (gp2): Must be an integer from 20 to 65536.</p> </li>
        /// <li> <p>Provisioned IOPS storage (io1): Must be an integer from 100 to 65536.</p> </li>
        /// <li> <p>Magnetic storage (standard): Must be an integer from 5 to 3072.</p> </li>
        /// </ul>
        /// <p> <b>PostgreSQL</b> </p>
        /// <p>Constraints to the amount of storage for each storage type are the following:</p>
        /// <ul>
        /// <li> <p>General Purpose (SSD) storage (gp2): Must be an integer from 20 to 65536.</p> </li>
        /// <li> <p>Provisioned IOPS storage (io1): Must be an integer from 100 to 65536.</p> </li>
        /// <li> <p>Magnetic storage (standard): Must be an integer from 5 to 3072.</p> </li>
        /// </ul>
        /// <p> <b>Oracle</b> </p>
        /// <p>Constraints to the amount of storage for each storage type are the following:</p>
        /// <ul>
        /// <li> <p>General Purpose (SSD) storage (gp2): Must be an integer from 20 to 65536.</p> </li>
        /// <li> <p>Provisioned IOPS storage (io1): Must be an integer from 100 to 65536.</p> </li>
        /// <li> <p>Magnetic storage (standard): Must be an integer from 10 to 3072.</p> </li>
        /// </ul>
        /// <p> <b>SQL Server</b> </p>
        /// <p>Constraints to the amount of storage for each storage type are the following:</p>
        /// <ul>
        /// <li> <p>General Purpose (SSD) storage (gp2):</p>
        /// <ul>
        /// <li> <p>Enterprise and Standard editions: Must be an integer from 20 to 16384.</p> </li>
        /// <li> <p>Web and Express editions: Must be an integer from 20 to 16384.</p> </li>
        /// </ul> </li>
        /// <li> <p>Provisioned IOPS storage (io1):</p>
        /// <ul>
        /// <li> <p>Enterprise and Standard editions: Must be an integer from 100 to 16384.</p> </li>
        /// <li> <p>Web and Express editions: Must be an integer from 100 to 16384.</p> </li>
        /// </ul> </li>
        /// <li> <p>Magnetic storage (standard):</p>
        /// <ul>
        /// <li> <p>Enterprise and Standard editions: Must be an integer from 20 to 1024.</p> </li>
        /// <li> <p>Web and Express editions: Must be an integer from 20 to 1024.</p> </li>
        /// </ul> </li>
        /// </ul>
        pub fn allocated_storage(mut self, input: i32) -> Self {
            self.inner = self.inner.allocated_storage(input);
            self
        }
        /// <p>The amount of storage in gibibytes (GiB) to allocate for the DB instance.</p>
        /// <p>Type: Integer</p>
        /// <p> <b>Amazon Aurora</b> </p>
        /// <p>Not applicable. Aurora cluster volumes automatically grow as the amount of data in your database increases, though you are only charged for the space that you use in an Aurora cluster volume.</p>
        /// <p> <b>Amazon RDS Custom</b> </p>
        /// <p>Constraints to the amount of storage for each storage type are the following:</p>
        /// <ul>
        /// <li> <p>General Purpose (SSD) storage (gp2): Must be an integer from 40 to 65536 for RDS Custom for Oracle, 16384 for RDS Custom for SQL Server.</p> </li>
        /// <li> <p>Provisioned IOPS storage (io1): Must be an integer from 40 to 65536 for RDS Custom for Oracle, 16384 for RDS Custom for SQL Server.</p> </li>
        /// </ul>
        /// <p> <b>MySQL</b> </p>
        /// <p>Constraints to the amount of storage for each storage type are the following:</p>
        /// <ul>
        /// <li> <p>General Purpose (SSD) storage (gp2): Must be an integer from 20 to 65536.</p> </li>
        /// <li> <p>Provisioned IOPS storage (io1): Must be an integer from 100 to 65536.</p> </li>
        /// <li> <p>Magnetic storage (standard): Must be an integer from 5 to 3072.</p> </li>
        /// </ul>
        /// <p> <b>MariaDB</b> </p>
        /// <p>Constraints to the amount of storage for each storage type are the following:</p>
        /// <ul>
        /// <li> <p>General Purpose (SSD) storage (gp2): Must be an integer from 20 to 65536.</p> </li>
        /// <li> <p>Provisioned IOPS storage (io1): Must be an integer from 100 to 65536.</p> </li>
        /// <li> <p>Magnetic storage (standard): Must be an integer from 5 to 3072.</p> </li>
        /// </ul>
        /// <p> <b>PostgreSQL</b> </p>
        /// <p>Constraints to the amount of storage for each storage type are the following:</p>
        /// <ul>
        /// <li> <p>General Purpose (SSD) storage (gp2): Must be an integer from 20 to 65536.</p> </li>
        /// <li> <p>Provisioned IOPS storage (io1): Must be an integer from 100 to 65536.</p> </li>
        /// <li> <p>Magnetic storage (standard): Must be an integer from 5 to 3072.</p> </li>
        /// </ul>
        /// <p> <b>Oracle</b> </p>
        /// <p>Constraints to the amount of storage for each storage type are the following:</p>
        /// <ul>
        /// <li> <p>General Purpose (SSD) storage (gp2): Must be an integer from 20 to 65536.</p> </li>
        /// <li> <p>Provisioned IOPS storage (io1): Must be an integer from 100 to 65536.</p> </li>
        /// <li> <p>Magnetic storage (standard): Must be an integer from 10 to 3072.</p> </li>
        /// </ul>
        /// <p> <b>SQL Server</b> </p>
        /// <p>Constraints to the amount of storage for each storage type are the following:</p>
        /// <ul>
        /// <li> <p>General Purpose (SSD) storage (gp2):</p>
        /// <ul>
        /// <li> <p>Enterprise and Standard editions: Must be an integer from 20 to 16384.</p> </li>
        /// <li> <p>Web and Express editions: Must be an integer from 20 to 16384.</p> </li>
        /// </ul> </li>
        /// <li> <p>Provisioned IOPS storage (io1):</p>
        /// <ul>
        /// <li> <p>Enterprise and Standard editions: Must be an integer from 100 to 16384.</p> </li>
        /// <li> <p>Web and Express editions: Must be an integer from 100 to 16384.</p> </li>
        /// </ul> </li>
        /// <li> <p>Magnetic storage (standard):</p>
        /// <ul>
        /// <li> <p>Enterprise and Standard editions: Must be an integer from 20 to 1024.</p> </li>
        /// <li> <p>Web and Express editions: Must be an integer from 20 to 1024.</p> </li>
        /// </ul> </li>
        /// </ul>
        pub fn set_allocated_storage(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_allocated_storage(input);
            self
        }
        /// <p>The compute and memory capacity of the DB instance, for example db.m4.large. Not all DB instance classes are available in all Amazon Web Services Regions, or for all database engines. For the full list of DB instance classes, and availability for your engine, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html">DB Instance Class</a> in the <i>Amazon RDS User Guide</i>.</p>
        pub fn db_instance_class(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_instance_class(input.into());
            self
        }
        /// <p>The compute and memory capacity of the DB instance, for example db.m4.large. Not all DB instance classes are available in all Amazon Web Services Regions, or for all database engines. For the full list of DB instance classes, and availability for your engine, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html">DB Instance Class</a> in the <i>Amazon RDS User Guide</i>.</p>
        pub fn set_db_instance_class(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_instance_class(input);
            self
        }
        /// <p>The name of the database engine to be used for this instance.</p>
        /// <p>Not every database engine is available for every Amazon Web Services Region.</p>
        /// <p>Valid Values:</p>
        /// <ul>
        /// <li> <p> <code>aurora</code> (for MySQL 5.6-compatible Aurora)</p> </li>
        /// <li> <p> <code>aurora-mysql</code> (for MySQL 5.7-compatible and MySQL 8.0-compatible Aurora)</p> </li>
        /// <li> <p> <code>aurora-postgresql</code> </p> </li>
        /// <li> <p> <code>custom-oracle-ee (for RDS Custom for Oracle instances)</code> </p> </li>
        /// <li> <p> <code>custom-sqlserver-ee (for RDS Custom for SQL Server instances)</code> </p> </li>
        /// <li> <p> <code>custom-sqlserver-se (for RDS Custom for SQL Server instances)</code> </p> </li>
        /// <li> <p> <code>custom-sqlserver-web (for RDS Custom for SQL Server instances)</code> </p> </li>
        /// <li> <p> <code>mariadb</code> </p> </li>
        /// <li> <p> <code>mysql</code> </p> </li>
        /// <li> <p> <code>oracle-ee</code> </p> </li>
        /// <li> <p> <code>oracle-ee-cdb</code> </p> </li>
        /// <li> <p> <code>oracle-se2</code> </p> </li>
        /// <li> <p> <code>oracle-se2-cdb</code> </p> </li>
        /// <li> <p> <code>postgres</code> </p> </li>
        /// <li> <p> <code>sqlserver-ee</code> </p> </li>
        /// <li> <p> <code>sqlserver-se</code> </p> </li>
        /// <li> <p> <code>sqlserver-ex</code> </p> </li>
        /// <li> <p> <code>sqlserver-web</code> </p> </li>
        /// </ul>
        pub fn engine(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine(input.into());
            self
        }
        /// <p>The name of the database engine to be used for this instance.</p>
        /// <p>Not every database engine is available for every Amazon Web Services Region.</p>
        /// <p>Valid Values:</p>
        /// <ul>
        /// <li> <p> <code>aurora</code> (for MySQL 5.6-compatible Aurora)</p> </li>
        /// <li> <p> <code>aurora-mysql</code> (for MySQL 5.7-compatible and MySQL 8.0-compatible Aurora)</p> </li>
        /// <li> <p> <code>aurora-postgresql</code> </p> </li>
        /// <li> <p> <code>custom-oracle-ee (for RDS Custom for Oracle instances)</code> </p> </li>
        /// <li> <p> <code>custom-sqlserver-ee (for RDS Custom for SQL Server instances)</code> </p> </li>
        /// <li> <p> <code>custom-sqlserver-se (for RDS Custom for SQL Server instances)</code> </p> </li>
        /// <li> <p> <code>custom-sqlserver-web (for RDS Custom for SQL Server instances)</code> </p> </li>
        /// <li> <p> <code>mariadb</code> </p> </li>
        /// <li> <p> <code>mysql</code> </p> </li>
        /// <li> <p> <code>oracle-ee</code> </p> </li>
        /// <li> <p> <code>oracle-ee-cdb</code> </p> </li>
        /// <li> <p> <code>oracle-se2</code> </p> </li>
        /// <li> <p> <code>oracle-se2-cdb</code> </p> </li>
        /// <li> <p> <code>postgres</code> </p> </li>
        /// <li> <p> <code>sqlserver-ee</code> </p> </li>
        /// <li> <p> <code>sqlserver-se</code> </p> </li>
        /// <li> <p> <code>sqlserver-ex</code> </p> </li>
        /// <li> <p> <code>sqlserver-web</code> </p> </li>
        /// </ul>
        pub fn set_engine(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_engine(input);
            self
        }
        /// <p>The name for the master user.</p>
        /// <p> <b>Amazon Aurora</b> </p>
        /// <p>Not applicable. The name for the master user is managed by the DB cluster.</p>
        /// <p> <b>Amazon RDS</b> </p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Required.</p> </li>
        /// <li> <p>Must be 1 to 16 letters, numbers, or underscores.</p> </li>
        /// <li> <p>First character must be a letter.</p> </li>
        /// <li> <p>Can't be a reserved word for the chosen database engine.</p> </li>
        /// </ul>
        pub fn master_username(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.master_username(input.into());
            self
        }
        /// <p>The name for the master user.</p>
        /// <p> <b>Amazon Aurora</b> </p>
        /// <p>Not applicable. The name for the master user is managed by the DB cluster.</p>
        /// <p> <b>Amazon RDS</b> </p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Required.</p> </li>
        /// <li> <p>Must be 1 to 16 letters, numbers, or underscores.</p> </li>
        /// <li> <p>First character must be a letter.</p> </li>
        /// <li> <p>Can't be a reserved word for the chosen database engine.</p> </li>
        /// </ul>
        pub fn set_master_username(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_master_username(input);
            self
        }
        /// <p>The password for the master user. The password can include any printable ASCII character except "/", """, or "@".</p>
        /// <p> <b>Amazon Aurora</b> </p>
        /// <p>Not applicable. The password for the master user is managed by the DB cluster.</p>
        /// <p> <b>MariaDB</b> </p>
        /// <p>Constraints: Must contain from 8 to 41 characters.</p>
        /// <p> <b>Microsoft SQL Server</b> </p>
        /// <p>Constraints: Must contain from 8 to 128 characters.</p>
        /// <p> <b>MySQL</b> </p>
        /// <p>Constraints: Must contain from 8 to 41 characters.</p>
        /// <p> <b>Oracle</b> </p>
        /// <p>Constraints: Must contain from 8 to 30 characters.</p>
        /// <p> <b>PostgreSQL</b> </p>
        /// <p>Constraints: Must contain from 8 to 128 characters.</p>
        pub fn master_user_password(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.master_user_password(input.into());
            self
        }
        /// <p>The password for the master user. The password can include any printable ASCII character except "/", """, or "@".</p>
        /// <p> <b>Amazon Aurora</b> </p>
        /// <p>Not applicable. The password for the master user is managed by the DB cluster.</p>
        /// <p> <b>MariaDB</b> </p>
        /// <p>Constraints: Must contain from 8 to 41 characters.</p>
        /// <p> <b>Microsoft SQL Server</b> </p>
        /// <p>Constraints: Must contain from 8 to 128 characters.</p>
        /// <p> <b>MySQL</b> </p>
        /// <p>Constraints: Must contain from 8 to 41 characters.</p>
        /// <p> <b>Oracle</b> </p>
        /// <p>Constraints: Must contain from 8 to 30 characters.</p>
        /// <p> <b>PostgreSQL</b> </p>
        /// <p>Constraints: Must contain from 8 to 128 characters.</p>
        pub fn set_master_user_password(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_master_user_password(input);
            self
        }
        /// Appends an item to `DBSecurityGroups`.
        ///
        /// To override the contents of this collection use [`set_db_security_groups`](Self::set_db_security_groups).
        ///
        /// <p>A list of DB security groups to associate with this DB instance.</p>
        /// <p>Default: The default DB security group for the database engine.</p>
        pub fn db_security_groups(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_security_groups(input.into());
            self
        }
        /// <p>A list of DB security groups to associate with this DB instance.</p>
        /// <p>Default: The default DB security group for the database engine.</p>
        pub fn set_db_security_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_db_security_groups(input);
            self
        }
        /// Appends an item to `VpcSecurityGroupIds`.
        ///
        /// To override the contents of this collection use [`set_vpc_security_group_ids`](Self::set_vpc_security_group_ids).
        ///
        /// <p>A list of Amazon EC2 VPC security groups to associate with this DB instance.</p>
        /// <p> <b>Amazon Aurora</b> </p>
        /// <p>Not applicable. The associated list of EC2 VPC security groups is managed by the DB cluster.</p>
        /// <p>Default: The default EC2 VPC security group for the DB subnet group's VPC.</p>
        pub fn vpc_security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc_security_group_ids(input.into());
            self
        }
        /// <p>A list of Amazon EC2 VPC security groups to associate with this DB instance.</p>
        /// <p> <b>Amazon Aurora</b> </p>
        /// <p>Not applicable. The associated list of EC2 VPC security groups is managed by the DB cluster.</p>
        /// <p>Default: The default EC2 VPC security group for the DB subnet group's VPC.</p>
        pub fn set_vpc_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_vpc_security_group_ids(input);
            self
        }
        /// <p>The Availability Zone (AZ) where the database will be created. For information on Amazon Web Services Regions and Availability Zones, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.RegionsAndAvailabilityZones.html">Regions and Availability Zones</a>.</p>
        /// <p> <b>Amazon Aurora</b> </p>
        /// <p>Each Aurora DB cluster hosts copies of its storage in three separate Availability Zones. Specify one of these Availability Zones. Aurora automatically chooses an appropriate Availability Zone if you don't specify one.</p>
        /// <p>Default: A random, system-chosen Availability Zone in the endpoint's Amazon Web Services Region.</p>
        /// <p>Example: <code>us-east-1d</code> </p>
        /// <p>Constraint: The <code>AvailabilityZone</code> parameter can't be specified if the DB instance is a Multi-AZ deployment. The specified Availability Zone must be in the same Amazon Web Services Region as the current endpoint.</p> <note>
        /// <p>If you're creating a DB instance in an RDS on VMware environment, specify the identifier of the custom Availability Zone to create the DB instance in.</p>
        /// <p>For more information about RDS on VMware, see the <a href="https://docs.aws.amazon.com/AmazonRDS/latest/RDSonVMwareUserGuide/rds-on-vmware.html"> RDS on VMware User Guide.</a> </p>
        /// </note>
        pub fn availability_zone(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.availability_zone(input.into());
            self
        }
        /// <p>The Availability Zone (AZ) where the database will be created. For information on Amazon Web Services Regions and Availability Zones, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.RegionsAndAvailabilityZones.html">Regions and Availability Zones</a>.</p>
        /// <p> <b>Amazon Aurora</b> </p>
        /// <p>Each Aurora DB cluster hosts copies of its storage in three separate Availability Zones. Specify one of these Availability Zones. Aurora automatically chooses an appropriate Availability Zone if you don't specify one.</p>
        /// <p>Default: A random, system-chosen Availability Zone in the endpoint's Amazon Web Services Region.</p>
        /// <p>Example: <code>us-east-1d</code> </p>
        /// <p>Constraint: The <code>AvailabilityZone</code> parameter can't be specified if the DB instance is a Multi-AZ deployment. The specified Availability Zone must be in the same Amazon Web Services Region as the current endpoint.</p> <note>
        /// <p>If you're creating a DB instance in an RDS on VMware environment, specify the identifier of the custom Availability Zone to create the DB instance in.</p>
        /// <p>For more information about RDS on VMware, see the <a href="https://docs.aws.amazon.com/AmazonRDS/latest/RDSonVMwareUserGuide/rds-on-vmware.html"> RDS on VMware User Guide.</a> </p>
        /// </note>
        pub fn set_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_availability_zone(input);
            self
        }
        /// <p>A DB subnet group to associate with this DB instance.</p>
        /// <p>Constraints: Must match the name of an existing DBSubnetGroup. Must not be default.</p>
        /// <p>Example: <code>mydbsubnetgroup</code> </p>
        pub fn db_subnet_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_subnet_group_name(input.into());
            self
        }
        /// <p>A DB subnet group to associate with this DB instance.</p>
        /// <p>Constraints: Must match the name of an existing DBSubnetGroup. Must not be default.</p>
        /// <p>Example: <code>mydbsubnetgroup</code> </p>
        pub fn set_db_subnet_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_subnet_group_name(input);
            self
        }
        /// <p>The time range each week during which system maintenance can occur, in Universal Coordinated Time (UTC). For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Maintenance.html#Concepts.DBMaintenance">Amazon RDS Maintenance Window</a>.</p>
        /// <p>Format: <code>ddd:hh24:mi-ddd:hh24:mi</code> </p>
        /// <p>The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Web Services Region, occurring on a random day of the week.</p>
        /// <p>Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.</p>
        /// <p>Constraints: Minimum 30-minute window.</p>
        pub fn preferred_maintenance_window(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.preferred_maintenance_window(input.into());
            self
        }
        /// <p>The time range each week during which system maintenance can occur, in Universal Coordinated Time (UTC). For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Maintenance.html#Concepts.DBMaintenance">Amazon RDS Maintenance Window</a>.</p>
        /// <p>Format: <code>ddd:hh24:mi-ddd:hh24:mi</code> </p>
        /// <p>The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Web Services Region, occurring on a random day of the week.</p>
        /// <p>Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.</p>
        /// <p>Constraints: Minimum 30-minute window.</p>
        pub fn set_preferred_maintenance_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_preferred_maintenance_window(input);
            self
        }
        /// <p>The name of the DB parameter group to associate with this DB instance. If you do not specify a value, then the default DB parameter group for the specified DB engine and version is used.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be 1 to 255 letters, numbers, or hyphens.</p> </li>
        /// <li> <p>First character must be a letter</p> </li>
        /// <li> <p>Can't end with a hyphen or contain two consecutive hyphens</p> </li>
        /// </ul>
        pub fn db_parameter_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.db_parameter_group_name(input.into());
            self
        }
        /// <p>The name of the DB parameter group to associate with this DB instance. If you do not specify a value, then the default DB parameter group for the specified DB engine and version is used.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be 1 to 255 letters, numbers, or hyphens.</p> </li>
        /// <li> <p>First character must be a letter</p> </li>
        /// <li> <p>Can't end with a hyphen or contain two consecutive hyphens</p> </li>
        /// </ul>
        pub fn set_db_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_db_parameter_group_name(input);
            self
        }
        /// <p>The number of days for which automated backups are retained. Setting this parameter to a positive number enables backups. Setting this parameter to 0 disables automated backups.</p>
        /// <p> <b>Amazon Aurora</b> </p>
        /// <p>Not applicable. The retention period for automated backups is managed by the DB cluster.</p>
        /// <p>Default: 1</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be a value from 0 to 35</p> </li>
        /// <li> <p>Can't be set to 0 if the DB instance is a source to read replicas</p> </li>
        /// <li> <p>Can't be set to 0 or 35 for an RDS Custom for Oracle DB instance</p> </li>
        /// </ul>
        pub fn backup_retention_period(mut self, input: i32) -> Self {
            self.inner = self.inner.backup_retention_period(input);
            self
        }
        /// <p>The number of days for which automated backups are retained. Setting this parameter to a positive number enables backups. Setting this parameter to 0 disables automated backups.</p>
        /// <p> <b>Amazon Aurora</b> </p>
        /// <p>Not applicable. The retention period for automated backups is managed by the DB cluster.</p>
        /// <p>Default: 1</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be a value from 0 to 35</p> </li>
        /// <li> <p>Can't be set to 0 if the DB instance is a source to read replicas</p> </li>
        /// <li> <p>Can't be set to 0 or 35 for an RDS Custom for Oracle DB instance</p> </li>
        /// </ul>
        pub fn set_backup_retention_period(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_backup_retention_period(input);
            self
        }
        /// <p>The daily time range during which automated backups are created if automated backups are enabled, using the <code>BackupRetentionPeriod</code> parameter. The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Web Services Region. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithAutomatedBackups.html#USER_WorkingWithAutomatedBackups.BackupWindow">Backup window</a> in the <i>Amazon RDS User Guide</i>.</p>
        /// <p> <b>Amazon Aurora</b> </p>
        /// <p>Not applicable. The daily time range for creating automated backups is managed by the DB cluster.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be in the format <code>hh24:mi-hh24:mi</code>.</p> </li>
        /// <li> <p>Must be in Universal Coordinated Time (UTC).</p> </li>
        /// <li> <p>Must not conflict with the preferred maintenance window.</p> </li>
        /// <li> <p>Must be at least 30 minutes.</p> </li>
        /// </ul>
        pub fn preferred_backup_window(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.preferred_backup_window(input.into());
            self
        }
        /// <p>The daily time range during which automated backups are created if automated backups are enabled, using the <code>BackupRetentionPeriod</code> parameter. The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Web Services Region. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithAutomatedBackups.html#USER_WorkingWithAutomatedBackups.BackupWindow">Backup window</a> in the <i>Amazon RDS User Guide</i>.</p>
        /// <p> <b>Amazon Aurora</b> </p>
        /// <p>Not applicable. The daily time range for creating automated backups is managed by the DB cluster.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li> <p>Must be in the format <code>hh24:mi-hh24:mi</code>.</p> </li>
        /// <li> <p>Must be in Universal Coordinated Time (UTC).</p> </li>
        /// <li> <p>Must not conflict with the preferred maintenance window.</p> </li>
        /// <li> <p>Must be at least 30 minutes.</p> </li>
        /// </ul>
        pub fn set_preferred_backup_window(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_preferred_backup_window(input);
            self
        }
        /// <p>The port number on which the database accepts connections.</p>
        /// <p> <b>MySQL</b> </p>
        /// <p>Default: <code>3306</code> </p>
        /// <p>Valid values: <code>1150-65535</code> </p>
        /// <p>Type: Integer</p>
        /// <p> <b>MariaDB</b> </p>
        /// <p>Default: <code>3306</code> </p>
        /// <p>Valid values: <code>1150-65535</code> </p>
        /// <p>Type: Integer</p>
        /// <p> <b>PostgreSQL</b> </p>
        /// <p>Default: <code>5432</code> </p>
        /// <p>Valid values: <code>1150-65535</code> </p>
        /// <p>Type: Integer</p>
        /// <p> <b>Oracle</b> </p>
        /// <p>Default: <code>1521</code> </p>
        /// <p>Valid values: <code>1150-65535</code> </p>
        /// <p> <b>SQL Server</b> </p>
        /// <p>Default: <code>1433</code> </p>
        /// <p>Valid values: <code>1150-65535</code> except <code>1234</code>, <code>1434</code>, <code>3260</code>, <code>3343</code>, <code>3389</code>, <code>47001</code>, and <code>49152-49156</code>.</p>
        /// <p> <b>Amazon Aurora</b> </p>
        /// <p>Default: <code>3306</code> </p>
        /// <p>Valid values: <code>1150-65535</code> </p>
        /// <p>Type: Integer</p>
        pub fn port(mut self, input: i32) -> Self {
            self.inner = self.inner.port(input);
            self
        }
        /// <p>The port number on which the database accepts connections.</p>
        /// <p> <b>MySQL</b> </p>
        /// <p>Default: <code>3306</code> </p>
        /// <p>Valid values: <code>1150-65535</code> </p>
        /// <p>Type: Integer</p>
        /// <p> <b>MariaDB</b> </p>
        /// <p>Default: <code>3306</code> </p>
        /// <p>Valid values: <code>1150-65535</code> </p>
        /// <p>Type: Integer</p>
        /// <p> <b>PostgreSQL</b> </p>
        /// <p>Default: <code>5432</code> </p>
        /// <p>Valid values: <code>1150-65535</code> </p>
        /// <p>Type: Integer</p>
        /// <p> <b>Oracle</b> </p>
        /// <p>Default: <code>1521</code> </p>
        /// <p>Valid values: <code>1150-65535</code> </p>
        /// <p> <b>SQL Server</b> </p>
        /// <p>Default: <code>1433</code> </p>
        /// <p>Valid values: <code>1150-65535</code> except <code>1234</code>, <code>1434</code>, <code>3260</code>, <code>3343</code>, <code>3389</code>, <code>47001</code>, and <code>49152-49156</code>.</p>
        /// <p> <b>Amazon Aurora</b> </p>
        /// <p>Default: <code>3306</code> </p>
        /// <p>Valid values: <code>1150-65535</code> </p>
        /// <p>Type: Integer</p>
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_port(input);
            self
        }
        /// <p>A value that indicates whether the DB instance is a Multi-AZ deployment. You can't set the <code>AvailabilityZone</code> parameter if the DB instance is a Multi-AZ deployment.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn multi_az(mut self, input: bool) -> Self {
            self.inner = self.inner.multi_az(input);
            self
        }
        /// <p>A value that indicates whether the DB instance is a Multi-AZ deployment. You can't set the <code>AvailabilityZone</code> parameter if the DB instance is a Multi-AZ deployment.</p>
        /// <p>This setting doesn't apply to RDS Custom.</p>
        pub fn set_multi_az(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_multi_az(input);
            self
        }
        /// <p>The version number of the database engine to use.</p>
        /// <p>For a list of valid engine versions, use the <code>DescribeDBEngineVersions</code> action.</p>
        /// <p>The following are the database engines and links to information about the major and minor versions that are available with Amazon RDS. Not every database engine is available for every Amazon Web Services Region.</p>
        /// <p> <b>Amazon Aurora</b> </p>
        /// <p>Not applicable. The version number of the database engine to be used by the DB instance is managed by the DB cluster.</p>
        /// <p> <b>Amazon RDS Custom for Oracle</b> </p>
        /// <p>A custom engine version (CEV) that you have previously created. This setting is required for RDS Custom for Oracle. The CEV name has the following format: <code>19.<i>customized_string</i> </code>. An example identifier is <code>19.my_cev1</code>. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-creating.html#custom-creating.create"> Creating an RDS Custom for Oracle DB instance</a> in the <i>Amazon RDS User Guide</i>.</p>
        /// <p> <b>Amazon RDS Custom for SQL Server</b> </p>
        /// <p>See <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-reqs-limits.html#custom-reqs-limits.reqsMS">RDS Custom for SQL Server general requirements</a> in the <i>Amazon RDS User Guide</i>.</p>
        /// <p> <b>MariaDB</b> </p>
        /// <p>For information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_MariaDB.html#MariaDB.Concepts.VersionMgmt">MariaDB on Amazon RDS Versions</a> in the <i>Amazon RDS User Guide</i>.</p>
        /// <p> <b>Microsoft SQL Server</b> </p>
        /// <p>For information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_SQLServer.html#SQLServer.Concepts.General.VersionSupport">Microsoft SQL Server Versions on Amazon RDS</a> in the <i>Amazon RDS User Guide</i>.</p>
        /// <p> <b>MySQL</b> </p>
        /// <p>For information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_MySQL.html#MySQL.Concepts.VersionMgmt">MySQL on Amazon RDS Versions</a> in the <i>Amazon RDS User Guide</i>.</p>
        /// <p> <b>Oracle</b> </p>
        /// <p>For information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Appendix.Oracle.PatchComposition.html">Oracle Database Engine Release Notes</a> in the <i>Amazon RDS User Guide</i>.</p>
        /// <p> <b>PostgreSQL</b> </p>
        /// <p>For information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_PostgreSQL.html#PostgreSQL.Concepts">Amazon RDS for PostgreSQL versions and extensions</a> in the <i>Amazon RDS User Guide</i>.</p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.engine_version(input.into());
            self
        }
        /// <p>The version number of the database engine to use.</p>
        /// <p>For a list of valid engine versions, use the <code>DescribeDBEngineVersions</code> action.</p>
        /// <p>The following are the database engines and links to information about the major and minor versions that are available with Amazon RDS. Not every database engine is available for every Amazon Web Services Region.</p>
        /// <p> <b>Amazon Aurora</b> </p>
        /// <p>Not applicable. The version number of the database engine to be used by the DB instance is managed by the DB cluster.</p>
        /// <p> <b>Amazon RDS Custom for Oracle</b> </p>
        /// <p>A custom engine version (CEV) that you have previously created. This setting is required for RDS Custom for Oracle. The CEV name has the following format: <code>19.<i>customized_string</i> </code>. An example identifier is <code>19.my_cev1</code>. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-creating.html#custom-creating.create"> Creating an RDS Custom for Oracle DB instance</a> in the <i>Amazon RDS User Guide</i>.</p>
        /// <p> <b>Amazon RDS Custom for SQL Server</b> </p>
        /// <p>See <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-reqs-limits.html#custom-reqs-limits.reqsMS">RDS Custom for SQL Server general requirements</a> in the <i>Amazon RDS User Guide</i>.</p>
        /// <p> <b>MariaDB</b> </p>
        /// <p>For information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_MariaDB.html#MariaDB.Concepts.VersionMgmt">MariaDB on Amazon RDS Versions</a> in the <i>Amazon RDS User Guide</i>.</p>
        /// <p> <b>Microsoft SQL Server</b> </p>
        /// <p>For information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_SQLServer.html#SQLServer.Concepts.General.VersionSupport">Microsoft SQL Server Versions on Amazon RDS</a> in the <i>Amazon RDS User Guide</i>.</p>
        /// <p> <b>MySQL</b> </p>
        /// <p>For information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_MySQL.html#MySQL.Concepts.VersionMgmt">MySQL on Amazon RDS Versions</a> in the <i>Amazon RDS User Guide</i>.</p>
        /// <p> <b>Oracle</b> </p>
        /// <p>For information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Appendix.Oracle.PatchComposition.html">Oracle Database Engine Release Notes</a> in the <i>Amazon RDS User Guide</i>.</p>
        /// <p> <b>PostgreSQL</b> </p>
        /// <p>For information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_PostgreSQL.html#PostgreSQL.Concepts">Amazon RDS for PostgreSQL versions and extensions</a> in the <i>Amazon RDS User Guide</i>.</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_engine_version(input);
            self
        }
        /// <p>A value that indicates whether minor engine upgrades are applied automatically to the DB instance during the maintenance window. By default, minor engine upgrades are applied automatically.</p>
        /// <p>If you create an RDS Custom DB instance, you must set <code>AutoMinorVersionUpgrade</code> to <code>false</code>.</p>
        pub fn auto_minor_version_upgrade(mut self, input: bool) -> Self {
            self.inner = self.inner.auto_minor_version_upgrade(input);
            self
        }
        /// <p>A value that indicates whether minor engine upgrades are applied automatically to the DB instance during the maintenance window. By default, minor engine upgrades are applied automatically.</p>
        /// <p>If you create an RDS Custom DB instance, you must set <code>AutoMinorVersionUpgrade</code> to <code>false</code>.</p>
        pub fn set_auto_minor_version_upgrade(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_auto_minor_version_upgrade(input);
            self
        }
        /// <p>License model information for this DB instance.</p>
        /// <p>Valid values: <cod