// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopDbInstanceAutomatedBackupsReplicationOutput {
    /// <p>An automated backup of a DB instance. It consists of system backups, transaction logs, and the database instance properties that
    /// existed at the time you deleted the source instance.</p>
    pub db_instance_automated_backup: std::option::Option<crate::model::DbInstanceAutomatedBackup>,
}
impl StopDbInstanceAutomatedBackupsReplicationOutput {
    /// <p>An automated backup of a DB instance. It consists of system backups, transaction logs, and the database instance properties that
    /// existed at the time you deleted the source instance.</p>
    pub fn db_instance_automated_backup(
        &self,
    ) -> std::option::Option<&crate::model::DbInstanceAutomatedBackup> {
        self.db_instance_automated_backup.as_ref()
    }
}
impl std::fmt::Debug for StopDbInstanceAutomatedBackupsReplicationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopDbInstanceAutomatedBackupsReplicationOutput");
        formatter.field(
            "db_instance_automated_backup",
            &self.db_instance_automated_backup,
        );
        formatter.finish()
    }
}
/// See [`StopDbInstanceAutomatedBackupsReplicationOutput`](crate::output::StopDbInstanceAutomatedBackupsReplicationOutput)
pub mod stop_db_instance_automated_backups_replication_output {
    /// A builder for [`StopDbInstanceAutomatedBackupsReplicationOutput`](crate::output::StopDbInstanceAutomatedBackupsReplicationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_instance_automated_backup:
            std::option::Option<crate::model::DbInstanceAutomatedBackup>,
    }
    impl Builder {
        /// <p>An automated backup of a DB instance. It consists of system backups, transaction logs, and the database instance properties that
        /// existed at the time you deleted the source instance.</p>
        pub fn db_instance_automated_backup(
            mut self,
            input: crate::model::DbInstanceAutomatedBackup,
        ) -> Self {
            self.db_instance_automated_backup = Some(input);
            self
        }
        /// <p>An automated backup of a DB instance. It consists of system backups, transaction logs, and the database instance properties that
        /// existed at the time you deleted the source instance.</p>
        pub fn set_db_instance_automated_backup(
            mut self,
            input: std::option::Option<crate::model::DbInstanceAutomatedBackup>,
        ) -> Self {
            self.db_instance_automated_backup = input;
            self
        }
        /// Consumes the builder and constructs a [`StopDbInstanceAutomatedBackupsReplicationOutput`](crate::output::StopDbInstanceAutomatedBackupsReplicationOutput)
        pub fn build(self) -> crate::output::StopDbInstanceAutomatedBackupsReplicationOutput {
            crate::output::StopDbInstanceAutomatedBackupsReplicationOutput {
                db_instance_automated_backup: self.db_instance_automated_backup,
            }
        }
    }
}
impl StopDbInstanceAutomatedBackupsReplicationOutput {
    /// Creates a new builder-style object to manufacture [`StopDbInstanceAutomatedBackupsReplicationOutput`](crate::output::StopDbInstanceAutomatedBackupsReplicationOutput)
    pub fn builder() -> crate::output::stop_db_instance_automated_backups_replication_output::Builder
    {
        crate::output::stop_db_instance_automated_backups_replication_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopDbInstanceOutput {
    /// <p>Contains the details of an Amazon RDS DB instance.
    /// </p>
    /// <p>This data type is used as a response element in the <code>DescribeDBInstances</code> action.
    /// </p>
    pub db_instance: std::option::Option<crate::model::DbInstance>,
}
impl StopDbInstanceOutput {
    /// <p>Contains the details of an Amazon RDS DB instance.
    /// </p>
    /// <p>This data type is used as a response element in the <code>DescribeDBInstances</code> action.
    /// </p>
    pub fn db_instance(&self) -> std::option::Option<&crate::model::DbInstance> {
        self.db_instance.as_ref()
    }
}
impl std::fmt::Debug for StopDbInstanceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopDbInstanceOutput");
        formatter.field("db_instance", &self.db_instance);
        formatter.finish()
    }
}
/// See [`StopDbInstanceOutput`](crate::output::StopDbInstanceOutput)
pub mod stop_db_instance_output {
    /// A builder for [`StopDbInstanceOutput`](crate::output::StopDbInstanceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_instance: std::option::Option<crate::model::DbInstance>,
    }
    impl Builder {
        /// <p>Contains the details of an Amazon RDS DB instance.
        /// </p>
        /// <p>This data type is used as a response element in the <code>DescribeDBInstances</code> action.
        /// </p>
        pub fn db_instance(mut self, input: crate::model::DbInstance) -> Self {
            self.db_instance = Some(input);
            self
        }
        /// <p>Contains the details of an Amazon RDS DB instance.
        /// </p>
        /// <p>This data type is used as a response element in the <code>DescribeDBInstances</code> action.
        /// </p>
        pub fn set_db_instance(
            mut self,
            input: std::option::Option<crate::model::DbInstance>,
        ) -> Self {
            self.db_instance = input;
            self
        }
        /// Consumes the builder and constructs a [`StopDbInstanceOutput`](crate::output::StopDbInstanceOutput)
        pub fn build(self) -> crate::output::StopDbInstanceOutput {
            crate::output::StopDbInstanceOutput {
                db_instance: self.db_instance,
            }
        }
    }
}
impl StopDbInstanceOutput {
    /// Creates a new builder-style object to manufacture [`StopDbInstanceOutput`](crate::output::StopDbInstanceOutput)
    pub fn builder() -> crate::output::stop_db_instance_output::Builder {
        crate::output::stop_db_instance_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopDbClusterOutput {
    /// <p>Contains the details of an Amazon Aurora DB cluster.
    /// </p>
    /// <p>This data type is used as a response element in the <code>DescribeDBClusters</code>,
    /// <code>StopDBCluster</code>, and <code>StartDBCluster</code> actions.
    /// </p>
    pub db_cluster: std::option::Option<crate::model::DbCluster>,
}
impl StopDbClusterOutput {
    /// <p>Contains the details of an Amazon Aurora DB cluster.
    /// </p>
    /// <p>This data type is used as a response element in the <code>DescribeDBClusters</code>,
    /// <code>StopDBCluster</code>, and <code>StartDBCluster</code> actions.
    /// </p>
    pub fn db_cluster(&self) -> std::option::Option<&crate::model::DbCluster> {
        self.db_cluster.as_ref()
    }
}
impl std::fmt::Debug for StopDbClusterOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopDbClusterOutput");
        formatter.field("db_cluster", &self.db_cluster);
        formatter.finish()
    }
}
/// See [`StopDbClusterOutput`](crate::output::StopDbClusterOutput)
pub mod stop_db_cluster_output {
    /// A builder for [`StopDbClusterOutput`](crate::output::StopDbClusterOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster: std::option::Option<crate::model::DbCluster>,
    }
    impl Builder {
        /// <p>Contains the details of an Amazon Aurora DB cluster.
        /// </p>
        /// <p>This data type is used as a response element in the <code>DescribeDBClusters</code>,
        /// <code>StopDBCluster</code>, and <code>StartDBCluster</code> actions.
        /// </p>
        pub fn db_cluster(mut self, input: crate::model::DbCluster) -> Self {
            self.db_cluster = Some(input);
            self
        }
        /// <p>Contains the details of an Amazon Aurora DB cluster.
        /// </p>
        /// <p>This data type is used as a response element in the <code>DescribeDBClusters</code>,
        /// <code>StopDBCluster</code>, and <code>StartDBCluster</code> actions.
        /// </p>
        pub fn set_db_cluster(
            mut self,
            input: std::option::Option<crate::model::DbCluster>,
        ) -> Self {
            self.db_cluster = input;
            self
        }
        /// Consumes the builder and constructs a [`StopDbClusterOutput`](crate::output::StopDbClusterOutput)
        pub fn build(self) -> crate::output::StopDbClusterOutput {
            crate::output::StopDbClusterOutput {
                db_cluster: self.db_cluster,
            }
        }
    }
}
impl StopDbClusterOutput {
    /// Creates a new builder-style object to manufacture [`StopDbClusterOutput`](crate::output::StopDbClusterOutput)
    pub fn builder() -> crate::output::stop_db_cluster_output::Builder {
        crate::output::stop_db_cluster_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopActivityStreamOutput {
    /// <p>The Amazon Web Services KMS key identifier used for encrypting messages in the database activity stream.</p>
    /// <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.</p>
    pub kms_key_id: std::option::Option<std::string::String>,
    /// <p>The name of the Amazon Kinesis data stream used for the database activity stream.</p>
    pub kinesis_stream_name: std::option::Option<std::string::String>,
    /// <p>The status of the database activity stream.</p>
    pub status: std::option::Option<crate::model::ActivityStreamStatus>,
}
impl StopActivityStreamOutput {
    /// <p>The Amazon Web Services KMS key identifier used for encrypting messages in the database activity stream.</p>
    /// <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.</p>
    pub fn kms_key_id(&self) -> std::option::Option<&str> {
        self.kms_key_id.as_deref()
    }
    /// <p>The name of the Amazon Kinesis data stream used for the database activity stream.</p>
    pub fn kinesis_stream_name(&self) -> std::option::Option<&str> {
        self.kinesis_stream_name.as_deref()
    }
    /// <p>The status of the database activity stream.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::ActivityStreamStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for StopActivityStreamOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopActivityStreamOutput");
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.field("kinesis_stream_name", &self.kinesis_stream_name);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`StopActivityStreamOutput`](crate::output::StopActivityStreamOutput)
pub mod stop_activity_stream_output {
    /// A builder for [`StopActivityStreamOutput`](crate::output::StopActivityStreamOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
        pub(crate) kinesis_stream_name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::ActivityStreamStatus>,
    }
    impl Builder {
        /// <p>The Amazon Web Services KMS key identifier used for encrypting messages in the database activity stream.</p>
        /// <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services KMS key identifier used for encrypting messages in the database activity stream.</p>
        /// <p>The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// <p>The name of the Amazon Kinesis data stream used for the database activity stream.</p>
        pub fn kinesis_stream_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.kinesis_stream_name = Some(input.into());
            self
        }
        /// <p>The name of the Amazon Kinesis data stream used for the database activity stream.</p>
        pub fn set_kinesis_stream_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.kinesis_stream_name = input;
            self
        }
        /// <p>The status of the database activity stream.</p>
        pub fn status(mut self, input: crate::model::ActivityStreamStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the database activity stream.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ActivityStreamStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`StopActivityStreamOutput`](crate::output::StopActivityStreamOutput)
        pub fn build(self) -> crate::output::StopActivityStreamOutput {
            crate::output::StopActivityStreamOutput {
                kms_key_id: self.kms_key_id,
                kinesis_stream_name: self.kinesis_stream_name,
                status: self.status,
            }
        }
    }
}
impl StopActivityStreamOutput {
    /// Creates a new builder-style object to manufacture [`StopActivityStreamOutput`](crate::output::StopActivityStreamOutput)
    pub fn builder() -> crate::output::stop_activity_stream_output::Builder {
        crate::output::stop_activity_stream_output::Builder::default()
    }
}

/// <p>Contains the details of a snapshot export to Amazon S3.
/// </p>
/// <p>This data type is used as a response element in the <code>DescribeExportTasks</code> action.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartExportTaskOutput {
    /// <p>A unique identifier for the snapshot export task. This ID isn't an identifier for
    /// the Amazon S3 bucket where the snapshot is exported to. </p>
    pub export_task_identifier: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the snapshot exported to Amazon S3.</p>
    pub source_arn: std::option::Option<std::string::String>,
    /// <p>The data exported from the snapshot. Valid values are the following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>database</code> - Export all the data from a specified database.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>database.table</code>
    /// <i>table-name</i> -
    /// Export a table of the snapshot. This format is valid only for RDS for MySQL, RDS for MariaDB, and Aurora MySQL.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>database.schema</code>
    /// <i>schema-name</i> - Export a database schema of the snapshot.
    /// This format is valid only for RDS for PostgreSQL and Aurora PostgreSQL.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>database.schema.table</code>
    /// <i>table-name</i> - Export a table of the database schema.
    /// This format is valid only for RDS for PostgreSQL and Aurora PostgreSQL.</p>
    /// </li>
    /// </ul>
    pub export_only: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The time that the snapshot was created.</p>
    pub snapshot_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time that the snapshot export task started.</p>
    pub task_start_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time that the snapshot export task completed.</p>
    pub task_end_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The Amazon S3 bucket that the snapshot is exported to.</p>
    pub s3_bucket: std::option::Option<std::string::String>,
    /// <p>The Amazon S3 bucket prefix that is the file name and path of the exported snapshot.</p>
    pub s3_prefix: std::option::Option<std::string::String>,
    /// <p>The name of the IAM role that is used to write to Amazon S3 when exporting a snapshot. </p>
    pub iam_role_arn: std::option::Option<std::string::String>,
    /// <p>The key identifier of the Amazon Web Services KMS key that is used to encrypt the snapshot when it's exported to
    /// Amazon S3. The KMS key identifier is its key ARN, key ID, alias ARN, or alias name. The IAM role used for the snapshot export
    /// must have encryption and decryption permissions to use this KMS key. </p>
    pub kms_key_id: std::option::Option<std::string::String>,
    /// <p>The progress status of the export task.</p>
    pub status: std::option::Option<std::string::String>,
    /// <p>The progress of the snapshot export task as a percentage.</p>
    pub percent_progress: i32,
    /// <p>The total amount of data exported, in gigabytes.</p>
    pub total_extracted_data_in_gb: i32,
    /// <p>The reason the export failed, if it failed.</p>
    pub failure_cause: std::option::Option<std::string::String>,
    /// <p>A warning about the snapshot export task.</p>
    pub warning_message: std::option::Option<std::string::String>,
}
impl StartExportTaskOutput {
    /// <p>A unique identifier for the snapshot export task. This ID isn't an identifier for
    /// the Amazon S3 bucket where the snapshot is exported to. </p>
    pub fn export_task_identifier(&self) -> std::option::Option<&str> {
        self.export_task_identifier.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the snapshot exported to Amazon S3.</p>
    pub fn source_arn(&self) -> std::option::Option<&str> {
        self.source_arn.as_deref()
    }
    /// <p>The data exported from the snapshot. Valid values are the following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>database</code> - Export all the data from a specified database.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>database.table</code>
    /// <i>table-name</i> -
    /// Export a table of the snapshot. This format is valid only for RDS for MySQL, RDS for MariaDB, and Aurora MySQL.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>database.schema</code>
    /// <i>schema-name</i> - Export a database schema of the snapshot.
    /// This format is valid only for RDS for PostgreSQL and Aurora PostgreSQL.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>database.schema.table</code>
    /// <i>table-name</i> - Export a table of the database schema.
    /// This format is valid only for RDS for PostgreSQL and Aurora PostgreSQL.</p>
    /// </li>
    /// </ul>
    pub fn export_only(&self) -> std::option::Option<&[std::string::String]> {
        self.export_only.as_deref()
    }
    /// <p>The time that the snapshot was created.</p>
    pub fn snapshot_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.snapshot_time.as_ref()
    }
    /// <p>The time that the snapshot export task started.</p>
    pub fn task_start_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.task_start_time.as_ref()
    }
    /// <p>The time that the snapshot export task completed.</p>
    pub fn task_end_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.task_end_time.as_ref()
    }
    /// <p>The Amazon S3 bucket that the snapshot is exported to.</p>
    pub fn s3_bucket(&self) -> std::option::Option<&str> {
        self.s3_bucket.as_deref()
    }
    /// <p>The Amazon S3 bucket prefix that is the file name and path of the exported snapshot.</p>
    pub fn s3_prefix(&self) -> std::option::Option<&str> {
        self.s3_prefix.as_deref()
    }
    /// <p>The name of the IAM role that is used to write to Amazon S3 when exporting a snapshot. </p>
    pub fn iam_role_arn(&self) -> std::option::Option<&str> {
        self.iam_role_arn.as_deref()
    }
    /// <p>The key identifier of the Amazon Web Services KMS key that is used to encrypt the snapshot when it's exported to
    /// Amazon S3. The KMS key identifier is its key ARN, key ID, alias ARN, or alias name. The IAM role used for the snapshot export
    /// must have encryption and decryption permissions to use this KMS key. </p>
    pub fn kms_key_id(&self) -> std::option::Option<&str> {
        self.kms_key_id.as_deref()
    }
    /// <p>The progress status of the export task.</p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>The progress of the snapshot export task as a percentage.</p>
    pub fn percent_progress(&self) -> i32 {
        self.percent_progress
    }
    /// <p>The total amount of data exported, in gigabytes.</p>
    pub fn total_extracted_data_in_gb(&self) -> i32 {
        self.total_extracted_data_in_gb
    }
    /// <p>The reason the export failed, if it failed.</p>
    pub fn failure_cause(&self) -> std::option::Option<&str> {
        self.failure_cause.as_deref()
    }
    /// <p>A warning about the snapshot export task.</p>
    pub fn warning_message(&self) -> std::option::Option<&str> {
        self.warning_message.as_deref()
    }
}
impl std::fmt::Debug for StartExportTaskOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartExportTaskOutput");
        formatter.field("export_task_identifier", &self.export_task_identifier);
        formatter.field("source_arn", &self.source_arn);
        formatter.field("export_only", &self.export_only);
        formatter.field("snapshot_time", &self.snapshot_time);
        formatter.field("task_start_time", &self.task_start_time);
        formatter.field("task_end_time", &self.task_end_time);
        formatter.field("s3_bucket", &self.s3_bucket);
        formatter.field("s3_prefix", &self.s3_prefix);
        formatter.field("iam_role_arn", &self.iam_role_arn);
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.field("status", &self.status);
        formatter.field("percent_progress", &self.percent_progress);
        formatter.field(
            "total_extracted_data_in_gb",
            &self.total_extracted_data_in_gb,
        );
        formatter.field("failure_cause", &self.failure_cause);
        formatter.field("warning_message", &self.warning_message);
        formatter.finish()
    }
}
/// See [`StartExportTaskOutput`](crate::output::StartExportTaskOutput)
pub mod start_export_task_output {
    /// A builder for [`StartExportTaskOutput`](crate::output::StartExportTaskOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) export_task_identifier: std::option::Option<std::string::String>,
        pub(crate) source_arn: std::option::Option<std::string::String>,
        pub(crate) export_only: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) snapshot_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) task_start_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) task_end_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) s3_bucket: std::option::Option<std::string::String>,
        pub(crate) s3_prefix: std::option::Option<std::string::String>,
        pub(crate) iam_role_arn: std::option::Option<std::string::String>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) percent_progress: std::option::Option<i32>,
        pub(crate) total_extracted_data_in_gb: std::option::Option<i32>,
        pub(crate) failure_cause: std::option::Option<std::string::String>,
        pub(crate) warning_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier for the snapshot export task. This ID isn't an identifier for
        /// the Amazon S3 bucket where the snapshot is exported to. </p>
        pub fn export_task_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.export_task_identifier = Some(input.into());
            self
        }
        /// <p>A unique identifier for the snapshot export task. This ID isn't an identifier for
        /// the Amazon S3 bucket where the snapshot is exported to. </p>
        pub fn set_export_task_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.export_task_identifier = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the snapshot exported to Amazon S3.</p>
        pub fn source_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the snapshot exported to Amazon S3.</p>
        pub fn set_source_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source_arn = input;
            self
        }
        /// Appends an item to `export_only`.
        ///
        /// To override the contents of this collection use [`set_export_only`](Self::set_export_only).
        ///
        /// <p>The data exported from the snapshot. Valid values are the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>database</code> - Export all the data from a specified database.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>database.table</code>
        /// <i>table-name</i> -
        /// Export a table of the snapshot. This format is valid only for RDS for MySQL, RDS for MariaDB, and Aurora MySQL.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>database.schema</code>
        /// <i>schema-name</i> - Export a database schema of the snapshot.
        /// This format is valid only for RDS for PostgreSQL and Aurora PostgreSQL.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>database.schema.table</code>
        /// <i>table-name</i> - Export a table of the database schema.
        /// This format is valid only for RDS for PostgreSQL and Aurora PostgreSQL.</p>
        /// </li>
        /// </ul>
        pub fn export_only(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.export_only.unwrap_or_default();
            v.push(input.into());
            self.export_only = Some(v);
            self
        }
        /// <p>The data exported from the snapshot. Valid values are the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>database</code> - Export all the data from a specified database.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>database.table</code>
        /// <i>table-name</i> -
        /// Export a table of the snapshot. This format is valid only for RDS for MySQL, RDS for MariaDB, and Aurora MySQL.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>database.schema</code>
        /// <i>schema-name</i> - Export a database schema of the snapshot.
        /// This format is valid only for RDS for PostgreSQL and Aurora PostgreSQL.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>database.schema.table</code>
        /// <i>table-name</i> - Export a table of the database schema.
        /// This format is valid only for RDS for PostgreSQL and Aurora PostgreSQL.</p>
        /// </li>
        /// </ul>
        pub fn set_export_only(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.export_only = input;
            self
        }
        /// <p>The time that the snapshot was created.</p>
        pub fn snapshot_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.snapshot_time = Some(input);
            self
        }
        /// <p>The time that the snapshot was created.</p>
        pub fn set_snapshot_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.snapshot_time = input;
            self
        }
        /// <p>The time that the snapshot export task started.</p>
        pub fn task_start_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.task_start_time = Some(input);
            self
        }
        /// <p>The time that the snapshot export task started.</p>
        pub fn set_task_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.task_start_time = input;
            self
        }
        /// <p>The time that the snapshot export task completed.</p>
        pub fn task_end_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.task_end_time = Some(input);
            self
        }
        /// <p>The time that the snapshot export task completed.</p>
        pub fn set_task_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.task_end_time = input;
            self
        }
        /// <p>The Amazon S3 bucket that the snapshot is exported to.</p>
        pub fn s3_bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_bucket = Some(input.into());
            self
        }
        /// <p>The Amazon S3 bucket that the snapshot is exported to.</p>
        pub fn set_s3_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.s3_bucket = input;
            self
        }
        /// <p>The Amazon S3 bucket prefix that is the file name and path of the exported snapshot.</p>
        pub fn s3_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_prefix = Some(input.into());
            self
        }
        /// <p>The Amazon S3 bucket prefix that is the file name and path of the exported snapshot.</p>
        pub fn set_s3_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.s3_prefix = input;
            self
        }
        /// <p>The name of the IAM role that is used to write to Amazon S3 when exporting a snapshot. </p>
        pub fn iam_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.iam_role_arn = Some(input.into());
            self
        }
        /// <p>The name of the IAM role that is used to write to Amazon S3 when exporting a snapshot. </p>
        pub fn set_iam_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.iam_role_arn = input;
            self
        }
        /// <p>The key identifier of the Amazon Web Services KMS key that is used to encrypt the snapshot when it's exported to
        /// Amazon S3. The KMS key identifier is its key ARN, key ID, alias ARN, or alias name. The IAM role used for the snapshot export
        /// must have encryption and decryption permissions to use this KMS key. </p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>The key identifier of the Amazon Web Services KMS key that is used to encrypt the snapshot when it's exported to
        /// Amazon S3. The KMS key identifier is its key ARN, key ID, alias ARN, or alias name. The IAM role used for the snapshot export
        /// must have encryption and decryption permissions to use this KMS key. </p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// <p>The progress status of the export task.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The progress status of the export task.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>The progress of the snapshot export task as a percentage.</p>
        pub fn percent_progress(mut self, input: i32) -> Self {
            self.percent_progress = Some(input);
            self
        }
        /// <p>The progress of the snapshot export task as a percentage.</p>
        pub fn set_percent_progress(mut self, input: std::option::Option<i32>) -> Self {
            self.percent_progress = input;
            self
        }
        /// <p>The total amount of data exported, in gigabytes.</p>
        pub fn total_extracted_data_in_gb(mut self, input: i32) -> Self {
            self.total_extracted_data_in_gb = Some(input);
            self
        }
        /// <p>The total amount of data exported, in gigabytes.</p>
        pub fn set_total_extracted_data_in_gb(mut self, input: std::option::Option<i32>) -> Self {
            self.total_extracted_data_in_gb = input;
            self
        }
        /// <p>The reason the export failed, if it failed.</p>
        pub fn failure_cause(mut self, input: impl Into<std::string::String>) -> Self {
            self.failure_cause = Some(input.into());
            self
        }
        /// <p>The reason the export failed, if it failed.</p>
        pub fn set_failure_cause(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.failure_cause = input;
            self
        }
        /// <p>A warning about the snapshot export task.</p>
        pub fn warning_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.warning_message = Some(input.into());
            self
        }
        /// <p>A warning about the snapshot export task.</p>
        pub fn set_warning_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.warning_message = input;
            self
        }
        /// Consumes the builder and constructs a [`StartExportTaskOutput`](crate::output::StartExportTaskOutput)
        pub fn build(self) -> crate::output::StartExportTaskOutput {
            crate::output::StartExportTaskOutput {
                export_task_identifier: self.export_task_identifier,
                source_arn: self.source_arn,
                export_only: self.export_only,
                snapshot_time: self.snapshot_time,
                task_start_time: self.task_start_time,
                task_end_time: self.task_end_time,
                s3_bucket: self.s3_bucket,
                s3_prefix: self.s3_prefix,
                iam_role_arn: self.iam_role_arn,
                kms_key_id: self.kms_key_id,
                status: self.status,
                percent_progress: self.percent_progress.unwrap_or_default(),
                total_extracted_data_in_gb: self.total_extracted_data_in_gb.unwrap_or_default(),
                failure_cause: self.failure_cause,
                warning_message: self.warning_message,
            }
        }
    }
}
impl StartExportTaskOutput {
    /// Creates a new builder-style object to manufacture [`StartExportTaskOutput`](crate::output::StartExportTaskOutput)
    pub fn builder() -> crate::output::start_export_task_output::Builder {
        crate::output::start_export_task_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartDbInstanceAutomatedBackupsReplicationOutput {
    /// <p>An automated backup of a DB instance. It consists of system backups, transaction logs, and the database instance properties that
    /// existed at the time you deleted the source instance.</p>
    pub db_instance_automated_backup: std::option::Option<crate::model::DbInstanceAutomatedBackup>,
}
impl StartDbInstanceAutomatedBackupsReplicationOutput {
    /// <p>An automated backup of a DB instance. It consists of system backups, transaction logs, and the database instance properties that
    /// existed at the time you deleted the source instance.</p>
    pub fn db_instance_automated_backup(
        &self,
    ) -> std::option::Option<&crate::model::DbInstanceAutomatedBackup> {
        self.db_instance_automated_backup.as_ref()
    }
}
impl std::fmt::Debug for StartDbInstanceAutomatedBackupsReplicationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartDbInstanceAutomatedBackupsReplicationOutput");
        formatter.field(
            "db_instance_automated_backup",
            &self.db_instance_automated_backup,
        );
        formatter.finish()
    }
}
/// See [`StartDbInstanceAutomatedBackupsReplicationOutput`](crate::output::StartDbInstanceAutomatedBackupsReplicationOutput)
pub mod start_db_instance_automated_backups_replication_output {
    /// A builder for [`StartDbInstanceAutomatedBackupsReplicationOutput`](crate::output::StartDbInstanceAutomatedBackupsReplicationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_instance_automated_backup:
            std::option::Option<crate::model::DbInstanceAutomatedBackup>,
    }
    impl Builder {
        /// <p>An automated backup of a DB instance. It consists of system backups, transaction logs, and the database instance properties that
        /// existed at the time you deleted the source instance.</p>
        pub fn db_instance_automated_backup(
            mut self,
            input: crate::model::DbInstanceAutomatedBackup,
        ) -> Self {
            self.db_instance_automated_backup = Some(input);
            self
        }
        /// <p>An automated backup of a DB instance. It consists of system backups, transaction logs, and the database instance properties that
        /// existed at the time you deleted the source instance.</p>
        pub fn set_db_instance_automated_backup(
            mut self,
            input: std::option::Option<crate::model::DbInstanceAutomatedBackup>,
        ) -> Self {
            self.db_instance_automated_backup = input;
            self
        }
        /// Consumes the builder and constructs a [`StartDbInstanceAutomatedBackupsReplicationOutput`](crate::output::StartDbInstanceAutomatedBackupsReplicationOutput)
        pub fn build(self) -> crate::output::StartDbInstanceAutomatedBackupsReplicationOutput {
            crate::output::StartDbInstanceAutomatedBackupsReplicationOutput {
                db_instance_automated_backup: self.db_instance_automated_backup,
            }
        }
    }
}
impl StartDbInstanceAutomatedBackupsReplicationOutput {
    /// Creates a new builder-style object to manufacture [`StartDbInstanceAutomatedBackupsReplicationOutput`](crate::output::StartDbInstanceAutomatedBackupsReplicationOutput)
    pub fn builder(
    ) -> crate::output::start_db_instance_automated_backups_replication_output::Builder {
        crate::output::start_db_instance_automated_backups_replication_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartDbInstanceOutput {
    /// <p>Contains the details of an Amazon RDS DB instance.
    /// </p>
    /// <p>This data type is used as a response element in the <code>DescribeDBInstances</code> action.
    /// </p>
    pub db_instance: std::option::Option<crate::model::DbInstance>,
}
impl StartDbInstanceOutput {
    /// <p>Contains the details of an Amazon RDS DB instance.
    /// </p>
    /// <p>This data type is used as a response element in the <code>DescribeDBInstances</code> action.
    /// </p>
    pub fn db_instance(&self) -> std::option::Option<&crate::model::DbInstance> {
        self.db_instance.as_ref()
    }
}
impl std::fmt::Debug for StartDbInstanceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartDbInstanceOutput");
        formatter.field("db_instance", &self.db_instance);
        formatter.finish()
    }
}
/// See [`StartDbInstanceOutput`](crate::output::StartDbInstanceOutput)
pub mod start_db_instance_output {
    /// A builder for [`StartDbInstanceOutput`](crate::output::StartDbInstanceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_instance: std::option::Option<crate::model::DbInstance>,
    }
    impl Builder {
        /// <p>Contains the details of an Amazon RDS DB instance.
        /// </p>
        /// <p>This data type is used as a response element in the <code>DescribeDBInstances</code> action.
        /// </p>
        pub fn db_instance(mut self, input: crate::model::DbInstance) -> Self {
            self.db_instance = Some(input);
            self
        }
        /// <p>Contains the details of an Amazon RDS DB instance.
        /// </p>
        /// <p>This data type is used as a response element in the <code>DescribeDBInstances</code> action.
        /// </p>
        pub fn set_db_instance(
            mut self,
            input: std::option::Option<crate::model::DbInstance>,
        ) -> Self {
            self.db_instance = input;
            self
        }
        /// Consumes the builder and constructs a [`StartDbInstanceOutput`](crate::output::StartDbInstanceOutput)
        pub fn build(self) -> crate::output::StartDbInstanceOutput {
            crate::output::StartDbInstanceOutput {
                db_instance: self.db_instance,
            }
        }
    }
}
impl StartDbInstanceOutput {
    /// Creates a new builder-style object to manufacture [`StartDbInstanceOutput`](crate::output::StartDbInstanceOutput)
    pub fn builder() -> crate::output::start_db_instance_output::Builder {
        crate::output::start_db_instance_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartDbClusterOutput {
    /// <p>Contains the details of an Amazon Aurora DB cluster.
    /// </p>
    /// <p>This data type is used as a response element in the <code>DescribeDBClusters</code>,
    /// <code>StopDBCluster</code>, and <code>StartDBCluster</code> actions.
    /// </p>
    pub db_cluster: std::option::Option<crate::model::DbCluster>,
}
impl StartDbClusterOutput {
    /// <p>Contains the details of an Amazon Aurora DB cluster.
    /// </p>
    /// <p>This data type is used as a response element in the <code>DescribeDBClusters</code>,
    /// <code>StopDBCluster</code>, and <code>StartDBCluster</code> actions.
    /// </p>
    pub fn db_cluster(&self) -> std::option::Option<&crate::model::DbCluster> {
        self.db_cluster.as_ref()
    }
}
impl std::fmt::Debug for StartDbClusterOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartDbClusterOutput");
        formatter.field("db_cluster", &self.db_cluster);
        formatter.finish()
    }
}
/// See [`StartDbClusterOutput`](crate::output::StartDbClusterOutput)
pub mod start_db_cluster_output {
    /// A builder for [`StartDbClusterOutput`](crate::output::StartDbClusterOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster: std::option::Option<crate::model::DbCluster>,
    }
    impl Builder {
        /// <p>Contains the details of an Amazon Aurora DB cluster.
        /// </p>
        /// <p>This data type is used as a response element in the <code>DescribeDBClusters</code>,
        /// <code>StopDBCluster</code>, and <code>StartDBCluster</code> actions.
        /// </p>
        pub fn db_cluster(mut self, input: crate::model::DbCluster) -> Self {
            self.db_cluster = Some(input);
            self
        }
        /// <p>Contains the details of an Amazon Aurora DB cluster.
        /// </p>
        /// <p>This data type is used as a response element in the <code>DescribeDBClusters</code>,
        /// <code>StopDBCluster</code>, and <code>StartDBCluster</code> actions.
        /// </p>
        pub fn set_db_cluster(
            mut self,
            input: std::option::Option<crate::model::DbCluster>,
        ) -> Self {
            self.db_cluster = input;
            self
        }
        /// Consumes the builder and constructs a [`StartDbClusterOutput`](crate::output::StartDbClusterOutput)
        pub fn build(self) -> crate::output::StartDbClusterOutput {
            crate::output::StartDbClusterOutput {
                db_cluster: self.db_cluster,
            }
        }
    }
}
impl StartDbClusterOutput {
    /// Creates a new builder-style object to manufacture [`StartDbClusterOutput`](crate::output::StartDbClusterOutput)
    pub fn builder() -> crate::output::start_db_cluster_output::Builder {
        crate::output::start_db_cluster_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartActivityStreamOutput {
    /// <p>The Amazon Web Services KMS key identifier for encryption of messages in the database activity stream.</p>
    pub kms_key_id: std::option::Option<std::string::String>,
    /// <p>The name of the Amazon Kinesis data stream to be used for the database activity stream.</p>
    pub kinesis_stream_name: std::option::Option<std::string::String>,
    /// <p>The status of the database activity stream.</p>
    pub status: std::option::Option<crate::model::ActivityStreamStatus>,
    /// <p>The mode of the database activity stream.</p>
    pub mode: std::option::Option<crate::model::ActivityStreamMode>,
    /// <p>Indicates whether or not the database activity stream will start as soon as possible,
    /// regardless of the maintenance window for the database.</p>
    pub apply_immediately: bool,
    /// <p>Indicates whether engine-native audit fields are included in the database activity stream.</p>
    pub engine_native_audit_fields_included: std::option::Option<bool>,
}
impl StartActivityStreamOutput {
    /// <p>The Amazon Web Services KMS key identifier for encryption of messages in the database activity stream.</p>
    pub fn kms_key_id(&self) -> std::option::Option<&str> {
        self.kms_key_id.as_deref()
    }
    /// <p>The name of the Amazon Kinesis data stream to be used for the database activity stream.</p>
    pub fn kinesis_stream_name(&self) -> std::option::Option<&str> {
        self.kinesis_stream_name.as_deref()
    }
    /// <p>The status of the database activity stream.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::ActivityStreamStatus> {
        self.status.as_ref()
    }
    /// <p>The mode of the database activity stream.</p>
    pub fn mode(&self) -> std::option::Option<&crate::model::ActivityStreamMode> {
        self.mode.as_ref()
    }
    /// <p>Indicates whether or not the database activity stream will start as soon as possible,
    /// regardless of the maintenance window for the database.</p>
    pub fn apply_immediately(&self) -> bool {
        self.apply_immediately
    }
    /// <p>Indicates whether engine-native audit fields are included in the database activity stream.</p>
    pub fn engine_native_audit_fields_included(&self) -> std::option::Option<bool> {
        self.engine_native_audit_fields_included
    }
}
impl std::fmt::Debug for StartActivityStreamOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartActivityStreamOutput");
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.field("kinesis_stream_name", &self.kinesis_stream_name);
        formatter.field("status", &self.status);
        formatter.field("mode", &self.mode);
        formatter.field("apply_immediately", &self.apply_immediately);
        formatter.field(
            "engine_native_audit_fields_included",
            &self.engine_native_audit_fields_included,
        );
        formatter.finish()
    }
}
/// See [`StartActivityStreamOutput`](crate::output::StartActivityStreamOutput)
pub mod start_activity_stream_output {
    /// A builder for [`StartActivityStreamOutput`](crate::output::StartActivityStreamOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
        pub(crate) kinesis_stream_name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::ActivityStreamStatus>,
        pub(crate) mode: std::option::Option<crate::model::ActivityStreamMode>,
        pub(crate) apply_immediately: std::option::Option<bool>,
        pub(crate) engine_native_audit_fields_included: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The Amazon Web Services KMS key identifier for encryption of messages in the database activity stream.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services KMS key identifier for encryption of messages in the database activity stream.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// <p>The name of the Amazon Kinesis data stream to be used for the database activity stream.</p>
        pub fn kinesis_stream_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.kinesis_stream_name = Some(input.into());
            self
        }
        /// <p>The name of the Amazon Kinesis data stream to be used for the database activity stream.</p>
        pub fn set_kinesis_stream_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.kinesis_stream_name = input;
            self
        }
        /// <p>The status of the database activity stream.</p>
        pub fn status(mut self, input: crate::model::ActivityStreamStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the database activity stream.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ActivityStreamStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The mode of the database activity stream.</p>
        pub fn mode(mut self, input: crate::model::ActivityStreamMode) -> Self {
            self.mode = Some(input);
            self
        }
        /// <p>The mode of the database activity stream.</p>
        pub fn set_mode(
            mut self,
            input: std::option::Option<crate::model::ActivityStreamMode>,
        ) -> Self {
            self.mode = input;
            self
        }
        /// <p>Indicates whether or not the database activity stream will start as soon as possible,
        /// regardless of the maintenance window for the database.</p>
        pub fn apply_immediately(mut self, input: bool) -> Self {
            self.apply_immediately = Some(input);
            self
        }
        /// <p>Indicates whether or not the database activity stream will start as soon as possible,
        /// regardless of the maintenance window for the database.</p>
        pub fn set_apply_immediately(mut self, input: std::option::Option<bool>) -> Self {
            self.apply_immediately = input;
            self
        }
        /// <p>Indicates whether engine-native audit fields are included in the database activity stream.</p>
        pub fn engine_native_audit_fields_included(mut self, input: bool) -> Self {
            self.engine_native_audit_fields_included = Some(input);
            self
        }
        /// <p>Indicates whether engine-native audit fields are included in the database activity stream.</p>
        pub fn set_engine_native_audit_fields_included(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.engine_native_audit_fields_included = input;
            self
        }
        /// Consumes the builder and constructs a [`StartActivityStreamOutput`](crate::output::StartActivityStreamOutput)
        pub fn build(self) -> crate::output::StartActivityStreamOutput {
            crate::output::StartActivityStreamOutput {
                kms_key_id: self.kms_key_id,
                kinesis_stream_name: self.kinesis_stream_name,
                status: self.status,
                mode: self.mode,
                apply_immediately: self.apply_immediately.unwrap_or_default(),
                engine_native_audit_fields_included: self.engine_native_audit_fields_included,
            }
        }
    }
}
impl StartActivityStreamOutput {
    /// Creates a new builder-style object to manufacture [`StartActivityStreamOutput`](crate::output::StartActivityStreamOutput)
    pub fn builder() -> crate::output::start_activity_stream_output::Builder {
        crate::output::start_activity_stream_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RevokeDbSecurityGroupIngressOutput {
    /// <p>Contains the details for an Amazon RDS DB security group.
    /// </p>
    /// <p>This data type is used as a response element
    /// in the <code>DescribeDBSecurityGroups</code> action.
    /// </p>
    pub db_security_group: std::option::Option<crate::model::DbSecurityGroup>,
}
impl RevokeDbSecurityGroupIngressOutput {
    /// <p>Contains the details for an Amazon RDS DB security group.
    /// </p>
    /// <p>This data type is used as a response element
    /// in the <code>DescribeDBSecurityGroups</code> action.
    /// </p>
    pub fn db_security_group(&self) -> std::option::Option<&crate::model::DbSecurityGroup> {
        self.db_security_group.as_ref()
    }
}
impl std::fmt::Debug for RevokeDbSecurityGroupIngressOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RevokeDbSecurityGroupIngressOutput");
        formatter.field("db_security_group", &self.db_security_group);
        formatter.finish()
    }
}
/// See [`RevokeDbSecurityGroupIngressOutput`](crate::output::RevokeDbSecurityGroupIngressOutput)
pub mod revoke_db_security_group_ingress_output {
    /// A builder for [`RevokeDbSecurityGroupIngressOutput`](crate::output::RevokeDbSecurityGroupIngressOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_security_group: std::option::Option<crate::model::DbSecurityGroup>,
    }
    impl Builder {
        /// <p>Contains the details for an Amazon RDS DB security group.
        /// </p>
        /// <p>This data type is used as a response element
        /// in the <code>DescribeDBSecurityGroups</code> action.
        /// </p>
        pub fn db_security_group(mut self, input: crate::model::DbSecurityGroup) -> Self {
            self.db_security_group = Some(input);
            self
        }
        /// <p>Contains the details for an Amazon RDS DB security group.
        /// </p>
        /// <p>This data type is used as a response element
        /// in the <code>DescribeDBSecurityGroups</code> action.
        /// </p>
        pub fn set_db_security_group(
            mut self,
            input: std::option::Option<crate::model::DbSecurityGroup>,
        ) -> Self {
            self.db_security_group = input;
            self
        }
        /// Consumes the builder and constructs a [`RevokeDbSecurityGroupIngressOutput`](crate::output::RevokeDbSecurityGroupIngressOutput)
        pub fn build(self) -> crate::output::RevokeDbSecurityGroupIngressOutput {
            crate::output::RevokeDbSecurityGroupIngressOutput {
                db_security_group: self.db_security_group,
            }
        }
    }
}
impl RevokeDbSecurityGroupIngressOutput {
    /// Creates a new builder-style object to manufacture [`RevokeDbSecurityGroupIngressOutput`](crate::output::RevokeDbSecurityGroupIngressOutput)
    pub fn builder() -> crate::output::revoke_db_security_group_ingress_output::Builder {
        crate::output::revoke_db_security_group_ingress_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RestoreDbInstanceToPointInTimeOutput {
    /// <p>Contains the details of an Amazon RDS DB instance.
    /// </p>
    /// <p>This data type is used as a response element in the <code>DescribeDBInstances</code> action.
    /// </p>
    pub db_instance: std::option::Option<crate::model::DbInstance>,
}
impl RestoreDbInstanceToPointInTimeOutput {
    /// <p>Contains the details of an Amazon RDS DB instance.
    /// </p>
    /// <p>This data type is used as a response element in the <code>DescribeDBInstances</code> action.
    /// </p>
    pub fn db_instance(&self) -> std::option::Option<&crate::model::DbInstance> {
        self.db_instance.as_ref()
    }
}
impl std::fmt::Debug for RestoreDbInstanceToPointInTimeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RestoreDbInstanceToPointInTimeOutput");
        formatter.field("db_instance", &self.db_instance);
        formatter.finish()
    }
}
/// See [`RestoreDbInstanceToPointInTimeOutput`](crate::output::RestoreDbInstanceToPointInTimeOutput)
pub mod restore_db_instance_to_point_in_time_output {
    /// A builder for [`RestoreDbInstanceToPointInTimeOutput`](crate::output::RestoreDbInstanceToPointInTimeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_instance: std::option::Option<crate::model::DbInstance>,
    }
    impl Builder {
        /// <p>Contains the details of an Amazon RDS DB instance.
        /// </p>
        /// <p>This data type is used as a response element in the <code>DescribeDBInstances</code> action.
        /// </p>
        pub fn db_instance(mut self, input: crate::model::DbInstance) -> Self {
            self.db_instance = Some(input);
            self
        }
        /// <p>Contains the details of an Amazon RDS DB instance.
        /// </p>
        /// <p>This data type is used as a response element in the <code>DescribeDBInstances</code> action.
        /// </p>
        pub fn set_db_instance(
            mut self,
            input: std::option::Option<crate::model::DbInstance>,
        ) -> Self {
            self.db_instance = input;
            self
        }
        /// Consumes the builder and constructs a [`RestoreDbInstanceToPointInTimeOutput`](crate::output::RestoreDbInstanceToPointInTimeOutput)
        pub fn build(self) -> crate::output::RestoreDbInstanceToPointInTimeOutput {
            crate::output::RestoreDbInstanceToPointInTimeOutput {
                db_instance: self.db_instance,
            }
        }
    }
}
impl RestoreDbInstanceToPointInTimeOutput {
    /// Creates a new builder-style object to manufacture [`RestoreDbInstanceToPointInTimeOutput`](crate::output::RestoreDbInstanceToPointInTimeOutput)
    pub fn builder() -> crate::output::restore_db_instance_to_point_in_time_output::Builder {
        crate::output::restore_db_instance_to_point_in_time_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RestoreDbInstanceFromS3Output {
    /// <p>Contains the details of an Amazon RDS DB instance.
    /// </p>
    /// <p>This data type is used as a response element in the <code>DescribeDBInstances</code> action.
    /// </p>
    pub db_instance: std::option::Option<crate::model::DbInstance>,
}
impl RestoreDbInstanceFromS3Output {
    /// <p>Contains the details of an Amazon RDS DB instance.
    /// </p>
    /// <p>This data type is used as a response element in the <code>DescribeDBInstances</code> action.
    /// </p>
    pub fn db_instance(&self) -> std::option::Option<&crate::model::DbInstance> {
        self.db_instance.as_ref()
    }
}
impl std::fmt::Debug for RestoreDbInstanceFromS3Output {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RestoreDbInstanceFromS3Output");
        formatter.field("db_instance", &self.db_instance);
        formatter.finish()
    }
}
/// See [`RestoreDbInstanceFromS3Output`](crate::output::RestoreDbInstanceFromS3Output)
pub mod restore_db_instance_from_s3_output {
    /// A builder for [`RestoreDbInstanceFromS3Output`](crate::output::RestoreDbInstanceFromS3Output)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_instance: std::option::Option<crate::model::DbInstance>,
    }
    impl Builder {
        /// <p>Contains the details of an Amazon RDS DB instance.
        /// </p>
        /// <p>This data type is used as a response element in the <code>DescribeDBInstances</code> action.
        /// </p>
        pub fn db_instance(mut self, input: crate::model::DbInstance) -> Self {
            self.db_instance = Some(input);
            self
        }
        /// <p>Contains the details of an Amazon RDS DB instance.
        /// </p>
        /// <p>This data type is used as a response element in the <code>DescribeDBInstances</code> action.
        /// </p>
        pub fn set_db_instance(
            mut self,
            input: std::option::Option<crate::model::DbInstance>,
        ) -> Self {
            self.db_instance = input;
            self
        }
        /// Consumes the builder and constructs a [`RestoreDbInstanceFromS3Output`](crate::output::RestoreDbInstanceFromS3Output)
        pub fn build(self) -> crate::output::RestoreDbInstanceFromS3Output {
            crate::output::RestoreDbInstanceFromS3Output {
                db_instance: self.db_instance,
            }
        }
    }
}
impl RestoreDbInstanceFromS3Output {
    /// Creates a new builder-style object to manufacture [`RestoreDbInstanceFromS3Output`](crate::output::RestoreDbInstanceFromS3Output)
    pub fn builder() -> crate::output::restore_db_instance_from_s3_output::Builder {
        crate::output::restore_db_instance_from_s3_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RestoreDbInstanceFromDbSnapshotOutput {
    /// <p>Contains the details of an Amazon RDS DB instance.
    /// </p>
    /// <p>This data type is used as a response element in the <code>DescribeDBInstances</code> action.
    /// </p>
    pub db_instance: std::option::Option<crate::model::DbInstance>,
}
impl RestoreDbInstanceFromDbSnapshotOutput {
    /// <p>Contains the details of an Amazon RDS DB instance.
    /// </p>
    /// <p>This data type is used as a response element in the <code>DescribeDBInstances</code> action.
    /// </p>
    pub fn db_instance(&self) -> std::option::Option<&crate::model::DbInstance> {
        self.db_instance.as_ref()
    }
}
impl std::fmt::Debug for RestoreDbInstanceFromDbSnapshotOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RestoreDbInstanceFromDbSnapshotOutput");
        formatter.field("db_instance", &self.db_instance);
        formatter.finish()
    }
}
/// See [`RestoreDbInstanceFromDbSnapshotOutput`](crate::output::RestoreDbInstanceFromDbSnapshotOutput)
pub mod restore_db_instance_from_db_snapshot_output {
    /// A builder for [`RestoreDbInstanceFromDbSnapshotOutput`](crate::output::RestoreDbInstanceFromDbSnapshotOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_instance: std::option::Option<crate::model::DbInstance>,
    }
    impl Builder {
        /// <p>Contains the details of an Amazon RDS DB instance.
        /// </p>
        /// <p>This data type is used as a response element in the <code>DescribeDBInstances</code> action.
        /// </p>
        pub fn db_instance(mut self, input: crate::model::DbInstance) -> Self {
            self.db_instance = Some(input);
            self
        }
        /// <p>Contains the details of an Amazon RDS DB instance.
        /// </p>
        /// <p>This data type is used as a response element in the <code>DescribeDBInstances</code> action.
        /// </p>
        pub fn set_db_instance(
            mut self,
            input: std::option::Option<crate::model::DbInstance>,
        ) -> Self {
            self.db_instance = input;
            self
        }
        /// Consumes the builder and constructs a [`RestoreDbInstanceFromDbSnapshotOutput`](crate::output::RestoreDbInstanceFromDbSnapshotOutput)
        pub fn build(self) -> crate::output::RestoreDbInstanceFromDbSnapshotOutput {
            crate::output::RestoreDbInstanceFromDbSnapshotOutput {
                db_instance: self.db_instance,
            }
        }
    }
}
impl RestoreDbInstanceFromDbSnapshotOutput {
    /// Creates a new builder-style object to manufacture [`RestoreDbInstanceFromDbSnapshotOutput`](crate::output::RestoreDbInstanceFromDbSnapshotOutput)
    pub fn builder() -> crate::output::restore_db_instance_from_db_snapshot_output::Builder {
        crate::output::restore_db_instance_from_db_snapshot_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RestoreDbClusterToPointInTimeOutput {
    /// <p>Contains the details of an Amazon Aurora DB cluster.
    /// </p>
    /// <p>This data type is used as a response element in the <code>DescribeDBClusters</code>,
    /// <code>StopDBCluster</code>, and <code>StartDBCluster</code> actions.
    /// </p>
    pub db_cluster: std::option::Option<crate::model::DbCluster>,
}
impl RestoreDbClusterToPointInTimeOutput {
    /// <p>Contains the details of an Amazon Aurora DB cluster.
    /// </p>
    /// <p>This data type is used as a response element in the <code>DescribeDBClusters</code>,
    /// <code>StopDBCluster</code>, and <code>StartDBCluster</code> actions.
    /// </p>
    pub fn db_cluster(&self) -> std::option::Option<&crate::model::DbCluster> {
        self.db_cluster.as_ref()
    }
}
impl std::fmt::Debug for RestoreDbClusterToPointInTimeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RestoreDbClusterToPointInTimeOutput");
        formatter.field("db_cluster", &self.db_cluster);
        formatter.finish()
    }
}
/// See [`RestoreDbClusterToPointInTimeOutput`](crate::output::RestoreDbClusterToPointInTimeOutput)
pub mod restore_db_cluster_to_point_in_time_output {
    /// A builder for [`RestoreDbClusterToPointInTimeOutput`](crate::output::RestoreDbClusterToPointInTimeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster: std::option::Option<crate::model::DbCluster>,
    }
    impl Builder {
        /// <p>Contains the details of an Amazon Aurora DB cluster.
        /// </p>
        /// <p>This data type is used as a response element in the <code>DescribeDBClusters</code>,
        /// <code>StopDBCluster</code>, and <code>StartDBCluster</code> actions.
        /// </p>
        pub fn db_cluster(mut self, input: crate::model::DbCluster) -> Self {
            self.db_cluster = Some(input);
            self
        }
        /// <p>Contains the details of an Amazon Aurora DB cluster.
        /// </p>
        /// <p>This data type is used as a response element in the <code>DescribeDBClusters</code>,
        /// <code>StopDBCluster</code>, and <code>StartDBCluster</code> actions.
        /// </p>
        pub fn set_db_cluster(
            mut self,
            input: std::option::Option<crate::model::DbCluster>,
        ) -> Self {
            self.db_cluster = input;
            self
        }
        /// Consumes the builder and constructs a [`RestoreDbClusterToPointInTimeOutput`](crate::output::RestoreDbClusterToPointInTimeOutput)
        pub fn build(self) -> crate::output::RestoreDbClusterToPointInTimeOutput {
            crate::output::RestoreDbClusterToPointInTimeOutput {
                db_cluster: self.db_cluster,
            }
        }
    }
}
impl RestoreDbClusterToPointInTimeOutput {
    /// Creates a new builder-style object to manufacture [`RestoreDbClusterToPointInTimeOutput`](crate::output::RestoreDbClusterToPointInTimeOutput)
    pub fn builder() -> crate::output::restore_db_cluster_to_point_in_time_output::Builder {
        crate::output::restore_db_cluster_to_point_in_time_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RestoreDbClusterFromSnapshotOutput {
    /// <p>Contains the details of an Amazon Aurora DB cluster.
    /// </p>
    /// <p>This data type is used as a response element in the <code>DescribeDBClusters</code>,
    /// <code>StopDBCluster</code>, and <code>StartDBCluster</code> actions.
    /// </p>
    pub db_cluster: std::option::Option<crate::model::DbCluster>,
}
impl RestoreDbClusterFromSnapshotOutput {
    /// <p>Contains the details of an Amazon Aurora DB cluster.
    /// </p>
    /// <p>This data type is used as a response element in the <code>DescribeDBClusters</code>,
    /// <code>StopDBCluster</code>, and <code>StartDBCluster</code> actions.
    /// </p>
    pub fn db_cluster(&self) -> std::option::Option<&crate::model::DbCluster> {
        self.db_cluster.as_ref()
    }
}
impl std::fmt::Debug for RestoreDbClusterFromSnapshotOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RestoreDbClusterFromSnapshotOutput");
        formatter.field("db_cluster", &self.db_cluster);
        formatter.finish()
    }
}
/// See [`RestoreDbClusterFromSnapshotOutput`](crate::output::RestoreDbClusterFromSnapshotOutput)
pub mod restore_db_cluster_from_snapshot_output {
    /// A builder for [`RestoreDbClusterFromSnapshotOutput`](crate::output::RestoreDbClusterFromSnapshotOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster: std::option::Option<crate::model::DbCluster>,
    }
    impl Builder {
        /// <p>Contains the details of an Amazon Aurora DB cluster.
        /// </p>
        /// <p>This data type is used as a response element in the <code>DescribeDBClusters</code>,
        /// <code>StopDBCluster</code>, and <code>StartDBCluster</code> actions.
        /// </p>
        pub fn db_cluster(mut self, input: crate::model::DbCluster) -> Self {
            self.db_cluster = Some(input);
            self
        }
        /// <p>Contains the details of an Amazon Aurora DB cluster.
        /// </p>
        /// <p>This data type is used as a response element in the <code>DescribeDBClusters</code>,
        /// <code>StopDBCluster</code>, and <code>StartDBCluster</code> actions.
        /// </p>
        pub fn set_db_cluster(
            mut self,
            input: std::option::Option<crate::model::DbCluster>,
        ) -> Self {
            self.db_cluster = input;
            self
        }
        /// Consumes the builder and constructs a [`RestoreDbClusterFromSnapshotOutput`](crate::output::RestoreDbClusterFromSnapshotOutput)
        pub fn build(self) -> crate::output::RestoreDbClusterFromSnapshotOutput {
            crate::output::RestoreDbClusterFromSnapshotOutput {
                db_cluster: self.db_cluster,
            }
        }
    }
}
impl RestoreDbClusterFromSnapshotOutput {
    /// Creates a new builder-style object to manufacture [`RestoreDbClusterFromSnapshotOutput`](crate::output::RestoreDbClusterFromSnapshotOutput)
    pub fn builder() -> crate::output::restore_db_cluster_from_snapshot_output::Builder {
        crate::output::restore_db_cluster_from_snapshot_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RestoreDbClusterFromS3Output {
    /// <p>Contains the details of an Amazon Aurora DB cluster.
    /// </p>
    /// <p>This data type is used as a response element in the <code>DescribeDBClusters</code>,
    /// <code>StopDBCluster</code>, and <code>StartDBCluster</code> actions.
    /// </p>
    pub db_cluster: std::option::Option<crate::model::DbCluster>,
}
impl RestoreDbClusterFromS3Output {
    /// <p>Contains the details of an Amazon Aurora DB cluster.
    /// </p>
    /// <p>This data type is used as a response element in the <code>DescribeDBClusters</code>,
    /// <code>StopDBCluster</code>, and <code>StartDBCluster</code> actions.
    /// </p>
    pub fn db_cluster(&self) -> std::option::Option<&crate::model::DbCluster> {
        self.db_cluster.as_ref()
    }
}
impl std::fmt::Debug for RestoreDbClusterFromS3Output {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RestoreDbClusterFromS3Output");
        formatter.field("db_cluster", &self.db_cluster);
        formatter.finish()
    }
}
/// See [`RestoreDbClusterFromS3Output`](crate::output::RestoreDbClusterFromS3Output)
pub mod restore_db_cluster_from_s3_output {
    /// A builder for [`RestoreDbClusterFromS3Output`](crate::output::RestoreDbClusterFromS3Output)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster: std::option::Option<crate::model::DbCluster>,
    }
    impl Builder {
        /// <p>Contains the details of an Amazon Aurora DB cluster.
        /// </p>
        /// <p>This data type is used as a response element in the <code>DescribeDBClusters</code>,
        /// <code>StopDBCluster</code>, and <code>StartDBCluster</code> actions.
        /// </p>
        pub fn db_cluster(mut self, input: crate::model::DbCluster) -> Self {
            self.db_cluster = Some(input);
            self
        }
        /// <p>Contains the details of an Amazon Aurora DB cluster.
        /// </p>
        /// <p>This data type is used as a response element in the <code>DescribeDBClusters</code>,
        /// <code>StopDBCluster</code>, and <code>StartDBCluster</code> actions.
        /// </p>
        pub fn set_db_cluster(
            mut self,
            input: std::option::Option<crate::model::DbCluster>,
        ) -> Self {
            self.db_cluster = input;
            self
        }
        /// Consumes the builder and constructs a [`RestoreDbClusterFromS3Output`](crate::output::RestoreDbClusterFromS3Output)
        pub fn build(self) -> crate::output::RestoreDbClusterFromS3Output {
            crate::output::RestoreDbClusterFromS3Output {
                db_cluster: self.db_cluster,
            }
        }
    }
}
impl RestoreDbClusterFromS3Output {
    /// Creates a new builder-style object to manufacture [`RestoreDbClusterFromS3Output`](crate::output::RestoreDbClusterFromS3Output)
    pub fn builder() -> crate::output::restore_db_cluster_from_s3_output::Builder {
        crate::output::restore_db_cluster_from_s3_output::Builder::default()
    }
}

/// <p>
/// Contains the result of a successful invocation of the
/// <code>ModifyDBParameterGroup</code> or <code>ResetDBParameterGroup</code> action.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResetDbParameterGroupOutput {
    /// <p>The name of the DB parameter group.</p>
    pub db_parameter_group_name: std::option::Option<std::string::String>,
}
impl ResetDbParameterGroupOutput {
    /// <p>The name of the DB parameter group.</p>
    pub fn db_parameter_group_name(&self) -> std::option::Option<&str> {
        self.db_parameter_group_name.as_deref()
    }
}
impl std::fmt::Debug for ResetDbParameterGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResetDbParameterGroupOutput");
        formatter.field("db_parameter_group_name", &self.db_parameter_group_name);
        formatter.finish()
    }
}
/// See [`ResetDbParameterGroupOutput`](crate::output::ResetDbParameterGroupOutput)
pub mod reset_db_parameter_group_output {
    /// A builder for [`ResetDbParameterGroupOutput`](crate::output::ResetDbParameterGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_parameter_group_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the DB parameter group.</p>
        pub fn db_parameter_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_parameter_group_name = Some(input.into());
            self
        }
        /// <p>The name of the DB parameter group.</p>
        pub fn set_db_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_parameter_group_name = input;
            self
        }
        /// Consumes the builder and constructs a [`ResetDbParameterGroupOutput`](crate::output::ResetDbParameterGroupOutput)
        pub fn build(self) -> crate::output::ResetDbParameterGroupOutput {
            crate::output::ResetDbParameterGroupOutput {
                db_parameter_group_name: self.db_parameter_group_name,
            }
        }
    }
}
impl ResetDbParameterGroupOutput {
    /// Creates a new builder-style object to manufacture [`ResetDbParameterGroupOutput`](crate::output::ResetDbParameterGroupOutput)
    pub fn builder() -> crate::output::reset_db_parameter_group_output::Builder {
        crate::output::reset_db_parameter_group_output::Builder::default()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResetDbClusterParameterGroupOutput {
    /// <p>The name of the DB cluster parameter group.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>Must be 1 to 255 letters or numbers.</p>
    /// </li>
    /// <li>
    /// <p>First character must be a letter</p>
    /// </li>
    /// <li>
    /// <p>Can't end with a hyphen or contain two consecutive hyphens</p>
    /// </li>
    /// </ul>
    /// <note>
    /// <p>This value is stored as a lowercase string.</p>
    /// </note>
    pub db_cluster_parameter_group_name: std::option::Option<std::string::String>,
}
impl ResetDbClusterParameterGroupOutput {
    /// <p>The name of the DB cluster parameter group.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>Must be 1 to 255 letters or numbers.</p>
    /// </li>
    /// <li>
    /// <p>First character must be a letter</p>
    /// </li>
    /// <li>
    /// <p>Can't end with a hyphen or contain two consecutive hyphens</p>
    /// </li>
    /// </ul>
    /// <note>
    /// <p>This value is stored as a lowercase string.</p>
    /// </note>
    pub fn db_cluster_parameter_group_name(&self) -> std::option::Option<&str> {
        self.db_cluster_parameter_group_name.as_deref()
    }
}
impl std::fmt::Debug for ResetDbClusterParameterGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResetDbClusterParameterGroupOutput");
        formatter.field(
            "db_cluster_parameter_group_name",
            &self.db_cluster_parameter_group_name,
        );
        formatter.finish()
    }
}
/// See [`ResetDbClusterParameterGroupOutput`](crate::output::ResetDbClusterParameterGroupOutput)
pub mod reset_db_cluster_parameter_group_output {
    /// A builder for [`ResetDbClusterParameterGroupOutput`](crate::output::ResetDbClusterParameterGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster_parameter_group_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the DB cluster parameter group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be 1 to 255 letters or numbers.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter</p>
        /// </li>
        /// <li>
        /// <p>Can't end with a hyphen or contain two consecutive hyphens</p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>This value is stored as a lowercase string.</p>
        /// </note>
        pub fn db_cluster_parameter_group_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.db_cluster_parameter_group_name = Some(input.into());
            self
        }
        /// <p>The name of the DB cluster parameter group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be 1 to 255 letters or numbers.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter</p>
        /// </li>
        /// <li>
        /// <p>Can't end with a hyphen or contain two consecutive hyphens</p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>This value is stored as a lowercase string.</p>
        /// </note>
        pub fn set_db_cluster_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_parameter_group_name = input;
            self
        }
        /// Consumes the builder and constructs a [`ResetDbClusterParameterGroupOutput`](crate::output::ResetDbClusterParameterGroupOutput)
        pub fn build(self) -> crate::output::ResetDbClusterParameterGroupOutput {
            crate::output::ResetDbClusterParameterGroupOutput {
                db_cluster_parameter_group_name: self.db_cluster_parameter_group_name,
            }
        }
    }
}
impl ResetDbClusterParameterGroupOutput {
    /// Creates a new builder-style object to manufacture [`ResetDbClusterParameterGroupOutput`](crate::output::ResetDbClusterParameterGroupOutput)
    pub fn builder() -> crate::output::reset_db_cluster_parameter_group_output::Builder {
        crate::output::reset_db_cluster_parameter_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemoveTagsFromResourceOutput {}
impl std::fmt::Debug for RemoveTagsFromResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemoveTagsFromResourceOutput");
        formatter.finish()
    }
}
/// See [`RemoveTagsFromResourceOutput`](crate::output::RemoveTagsFromResourceOutput)
pub mod remove_tags_from_resource_output {
    /// A builder for [`RemoveTagsFromResourceOutput`](crate::output::RemoveTagsFromResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`RemoveTagsFromResourceOutput`](crate::output::RemoveTagsFromResourceOutput)
        pub fn build(self) -> crate::output::RemoveTagsFromResourceOutput {
            crate::output::RemoveTagsFromResourceOutput {}
        }
    }
}
impl RemoveTagsFromResourceOutput {
    /// Creates a new builder-style object to manufacture [`RemoveTagsFromResourceOutput`](crate::output::RemoveTagsFromResourceOutput)
    pub fn builder() -> crate::output::remove_tags_from_resource_output::Builder {
        crate::output::remove_tags_from_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemoveSourceIdentifierFromSubscriptionOutput {
    /// <p>Contains the results of a successful invocation of the <code>DescribeEventSubscriptions</code> action.</p>
    pub event_subscription: std::option::Option<crate::model::EventSubscription>,
}
impl RemoveSourceIdentifierFromSubscriptionOutput {
    /// <p>Contains the results of a successful invocation of the <code>DescribeEventSubscriptions</code> action.</p>
    pub fn event_subscription(&self) -> std::option::Option<&crate::model::EventSubscription> {
        self.event_subscription.as_ref()
    }
}
impl std::fmt::Debug for RemoveSourceIdentifierFromSubscriptionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemoveSourceIdentifierFromSubscriptionOutput");
        formatter.field("event_subscription", &self.event_subscription);
        formatter.finish()
    }
}
/// See [`RemoveSourceIdentifierFromSubscriptionOutput`](crate::output::RemoveSourceIdentifierFromSubscriptionOutput)
pub mod remove_source_identifier_from_subscription_output {
    /// A builder for [`RemoveSourceIdentifierFromSubscriptionOutput`](crate::output::RemoveSourceIdentifierFromSubscriptionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) event_subscription: std::option::Option<crate::model::EventSubscription>,
    }
    impl Builder {
        /// <p>Contains the results of a successful invocation of the <code>DescribeEventSubscriptions</code> action.</p>
        pub fn event_subscription(mut self, input: crate::model::EventSubscription) -> Self {
            self.event_subscription = Some(input);
            self
        }
        /// <p>Contains the results of a successful invocation of the <code>DescribeEventSubscriptions</code> action.</p>
        pub fn set_event_subscription(
            mut self,
            input: std::option::Option<crate::model::EventSubscription>,
        ) -> Self {
            self.event_subscription = input;
            self
        }
        /// Consumes the builder and constructs a [`RemoveSourceIdentifierFromSubscriptionOutput`](crate::output::RemoveSourceIdentifierFromSubscriptionOutput)
        pub fn build(self) -> crate::output::RemoveSourceIdentifierFromSubscriptionOutput {
            crate::output::RemoveSourceIdentifierFromSubscriptionOutput {
                event_subscription: self.event_subscription,
            }
        }
    }
}
impl RemoveSourceIdentifierFromSubscriptionOutput {
    /// Creates a new builder-style object to manufacture [`RemoveSourceIdentifierFromSubscriptionOutput`](crate::output::RemoveSourceIdentifierFromSubscriptionOutput)
    pub fn builder() -> crate::output::remove_source_identifier_from_subscription_output::Builder {
        crate::output::remove_source_identifier_from_subscription_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemoveRoleFromDbInstanceOutput {}
impl std::fmt::Debug for RemoveRoleFromDbInstanceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemoveRoleFromDbInstanceOutput");
        formatter.finish()
    }
}
/// See [`RemoveRoleFromDbInstanceOutput`](crate::output::RemoveRoleFromDbInstanceOutput)
pub mod remove_role_from_db_instance_output {
    /// A builder for [`RemoveRoleFromDbInstanceOutput`](crate::output::RemoveRoleFromDbInstanceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`RemoveRoleFromDbInstanceOutput`](crate::output::RemoveRoleFromDbInstanceOutput)
        pub fn build(self) -> crate::output::RemoveRoleFromDbInstanceOutput {
            crate::output::RemoveRoleFromDbInstanceOutput {}
        }
    }
}
impl RemoveRoleFromDbInstanceOutput {
    /// Creates a new builder-style object to manufacture [`RemoveRoleFromDbInstanceOutput`](crate::output::RemoveRoleFromDbInstanceOutput)
    pub fn builder() -> crate::output::remove_role_from_db_instance_output::Builder {
        crate::output::remove_role_from_db_instance_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemoveRoleFromDbClusterOutput {}
impl std::fmt::Debug for RemoveRoleFromDbClusterOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemoveRoleFromDbClusterOutput");
        formatter.finish()
    }
}
/// See [`RemoveRoleFromDbClusterOutput`](crate::output::RemoveRoleFromDbClusterOutput)
pub mod remove_role_from_db_cluster_output {
    /// A builder for [`RemoveRoleFromDbClusterOutput`](crate::output::RemoveRoleFromDbClusterOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`RemoveRoleFromDbClusterOutput`](crate::output::RemoveRoleFromDbClusterOutput)
        pub fn build(self) -> crate::output::RemoveRoleFromDbClusterOutput {
            crate::output::RemoveRoleFromDbClusterOutput {}
        }
    }
}
impl RemoveRoleFromDbClusterOutput {
    /// Creates a new builder-style object to manufacture [`RemoveRoleFromDbClusterOutput`](crate::output::RemoveRoleFromDbClusterOutput)
    pub fn builder() -> crate::output::remove_role_from_db_cluster_output::Builder {
        crate::output::remove_role_from_db_cluster_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemoveFromGlobalClusterOutput {
    /// <p>A data type representing an Aurora global database.</p>
    pub global_cluster: std::option::Option<crate::model::GlobalCluster>,
}
impl RemoveFromGlobalClusterOutput {
    /// <p>A data type representing an Aurora global database.</p>
    pub fn global_cluster(&self) -> std::option::Option<&crate::model::GlobalCluster> {
        self.global_cluster.as_ref()
    }
}
impl std::fmt::Debug for RemoveFromGlobalClusterOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemoveFromGlobalClusterOutput");
        formatter.field("global_cluster", &self.global_cluster);
        formatter.finish()
    }
}
/// See [`RemoveFromGlobalClusterOutput`](crate::output::RemoveFromGlobalClusterOutput)
pub mod remove_from_global_cluster_output {
    /// A builder for [`RemoveFromGlobalClusterOutput`](crate::output::RemoveFromGlobalClusterOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) global_cluster: std::option::Option<crate::model::GlobalCluster>,
    }
    impl Builder {
        /// <p>A data type representing an Aurora global database.</p>
        pub fn global_cluster(mut self, input: crate::model::GlobalCluster) -> Self {
            self.global_cluster = Some(input);
            self
        }
        /// <p>A data type representing an Aurora global database.</p>
        pub fn set_global_cluster(
            mut self,
            input: std::option::Option<crate::model::GlobalCluster>,
        ) -> Self {
            self.global_cluster = input;
            self
        }
        /// Consumes the builder and constructs a [`RemoveFromGlobalClusterOutput`](crate::output::RemoveFromGlobalClusterOutput)
        pub fn build(self) -> crate::output::RemoveFromGlobalClusterOutput {
            crate::output::RemoveFromGlobalClusterOutput {
                global_cluster: self.global_cluster,
            }
        }
    }
}
impl RemoveFromGlobalClusterOutput {
    /// Creates a new builder-style object to manufacture [`RemoveFromGlobalClusterOutput`](crate::output::RemoveFromGlobalClusterOutput)
    pub fn builder() -> crate::output::remove_from_global_cluster_output::Builder {
        crate::output::remove_from_global_cluster_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RegisterDbProxyTargetsOutput {
    /// <p>One or more <code>DBProxyTarget</code> objects that are created when you register targets with a target group.</p>
    pub db_proxy_targets: std::option::Option<std::vec::Vec<crate::model::DbProxyTarget>>,
}
impl RegisterDbProxyTargetsOutput {
    /// <p>One or more <code>DBProxyTarget</code> objects that are created when you register targets with a target group.</p>
    pub fn db_proxy_targets(&self) -> std::option::Option<&[crate::model::DbProxyTarget]> {
        self.db_proxy_targets.as_deref()
    }
}
impl std::fmt::Debug for RegisterDbProxyTargetsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RegisterDbProxyTargetsOutput");
        formatter.field("db_proxy_targets", &self.db_proxy_targets);
        formatter.finish()
    }
}
/// See [`RegisterDbProxyTargetsOutput`](crate::output::RegisterDbProxyTargetsOutput)
pub mod register_db_proxy_targets_output {
    /// A builder for [`RegisterDbProxyTargetsOutput`](crate::output::RegisterDbProxyTargetsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_proxy_targets:
            std::option::Option<std::vec::Vec<crate::model::DbProxyTarget>>,
    }
    impl Builder {
        /// Appends an item to `db_proxy_targets`.
        ///
        /// To override the contents of this collection use [`set_db_proxy_targets`](Self::set_db_proxy_targets).
        ///
        /// <p>One or more <code>DBProxyTarget</code> objects that are created when you register targets with a target group.</p>
        pub fn db_proxy_targets(mut self, input: impl Into<crate::model::DbProxyTarget>) -> Self {
            let mut v = self.db_proxy_targets.unwrap_or_default();
            v.push(input.into());
            self.db_proxy_targets = Some(v);
            self
        }
        /// <p>One or more <code>DBProxyTarget</code> objects that are created when you register targets with a target group.</p>
        pub fn set_db_proxy_targets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DbProxyTarget>>,
        ) -> Self {
            self.db_proxy_targets = input;
            self
        }
        /// Consumes the builder and constructs a [`RegisterDbProxyTargetsOutput`](crate::output::RegisterDbProxyTargetsOutput)
        pub fn build(self) -> crate::output::RegisterDbProxyTargetsOutput {
            crate::output::RegisterDbProxyTargetsOutput {
                db_proxy_targets: self.db_proxy_targets,
            }
        }
    }
}
impl RegisterDbProxyTargetsOutput {
    /// Creates a new builder-style object to manufacture [`RegisterDbProxyTargetsOutput`](crate::output::RegisterDbProxyTargetsOutput)
    pub fn builder() -> crate::output::register_db_proxy_targets_output::Builder {
        crate::output::register_db_proxy_targets_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RebootDbInstanceOutput {
    /// <p>Contains the details of an Amazon RDS DB instance.
    /// </p>
    /// <p>This data type is used as a response element in the <code>DescribeDBInstances</code> action.
    /// </p>
    pub db_instance: std::option::Option<crate::model::DbInstance>,
}
impl RebootDbInstanceOutput {
    /// <p>Contains the details of an Amazon RDS DB instance.
    /// </p>
    /// <p>This data type is used as a response element in the <code>DescribeDBInstances</code> action.
    /// </p>
    pub fn db_instance(&self) -> std::option::Option<&crate::model::DbInstance> {
        self.db_instance.as_ref()
    }
}
impl std::fmt::Debug for RebootDbInstanceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RebootDbInstanceOutput");
        formatter.field("db_instance", &self.db_instance);
        formatter.finish()
    }
}
/// See [`RebootDbInstanceOutput`](crate::output::RebootDbInstanceOutput)
pub mod reboot_db_instance_output {
    /// A builder for [`RebootDbInstanceOutput`](crate::output::RebootDbInstanceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_instance: std::option::Option<crate::model::DbInstance>,
    }
    impl Builder {
        /// <p>Contains the details of an Amazon RDS DB instance.
        /// </p>
        /// <p>This data type is used as a response element in the <code>DescribeDBInstances</code> action.
        /// </p>
        pub fn db_instance(mut self, input: crate::model::DbInstance) -> Self {
            self.db_instance = Some(input);
            self
        }
        /// <p>Contains the details of an Amazon RDS DB instance.
        /// </p>
        /// <p>This data type is used as a response element in the <code>DescribeDBInstances</code> action.
        /// </p>
        pub fn set_db_instance(
            mut self,
            input: std::option::Option<crate::model::DbInstance>,
        ) -> Self {
            self.db_instance = input;
            self
        }
        /// Consumes the builder and constructs a [`RebootDbInstanceOutput`](crate::output::RebootDbInstanceOutput)
        pub fn build(self) -> crate::output::RebootDbInstanceOutput {
            crate::output::RebootDbInstanceOutput {
                db_instance: self.db_instance,
            }
        }
    }
}
impl RebootDbInstanceOutput {
    /// Creates a new builder-style object to manufacture [`RebootDbInstanceOutput`](crate::output::RebootDbInstanceOutput)
    pub fn builder() -> crate::output::reboot_db_instance_output::Builder {
        crate::output::reboot_db_instance_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PurchaseReservedDbInstancesOfferingOutput {
    /// <p>
    /// This data type is used as a response element in the
    /// <code>DescribeReservedDBInstances</code> and
    /// <code>PurchaseReservedDBInstancesOffering</code> actions.
    /// </p>
    pub reserved_db_instance: std::option::Option<crate::model::ReservedDbInstance>,
}
impl PurchaseReservedDbInstancesOfferingOutput {
    /// <p>
    /// This data type is used as a response element in the
    /// <code>DescribeReservedDBInstances</code> and
    /// <code>PurchaseReservedDBInstancesOffering</code> actions.
    /// </p>
    pub fn reserved_db_instance(&self) -> std::option::Option<&crate::model::ReservedDbInstance> {
        self.reserved_db_instance.as_ref()
    }
}
impl std::fmt::Debug for PurchaseReservedDbInstancesOfferingOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PurchaseReservedDbInstancesOfferingOutput");
        formatter.field("reserved_db_instance", &self.reserved_db_instance);
        formatter.finish()
    }
}
/// See [`PurchaseReservedDbInstancesOfferingOutput`](crate::output::PurchaseReservedDbInstancesOfferingOutput)
pub mod purchase_reserved_db_instances_offering_output {
    /// A builder for [`PurchaseReservedDbInstancesOfferingOutput`](crate::output::PurchaseReservedDbInstancesOfferingOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) reserved_db_instance: std::option::Option<crate::model::ReservedDbInstance>,
    }
    impl Builder {
        /// <p>
        /// This data type is used as a response element in the
        /// <code>DescribeReservedDBInstances</code> and
        /// <code>PurchaseReservedDBInstancesOffering</code> actions.
        /// </p>
        pub fn reserved_db_instance(mut self, input: crate::model::ReservedDbInstance) -> Self {
            self.reserved_db_instance = Some(input);
            self
        }
        /// <p>
        /// This data type is used as a response element in the
        /// <code>DescribeReservedDBInstances</code> and
        /// <code>PurchaseReservedDBInstancesOffering</code> actions.
        /// </p>
        pub fn set_reserved_db_instance(
            mut self,
            input: std::option::Option<crate::model::ReservedDbInstance>,
        ) -> Self {
            self.reserved_db_instance = input;
            self
        }
        /// Consumes the builder and constructs a [`PurchaseReservedDbInstancesOfferingOutput`](crate::output::PurchaseReservedDbInstancesOfferingOutput)
        pub fn build(self) -> crate::output::PurchaseReservedDbInstancesOfferingOutput {
            crate::output::PurchaseReservedDbInstancesOfferingOutput {
                reserved_db_instance: self.reserved_db_instance,
            }
        }
    }
}
impl PurchaseReservedDbInstancesOfferingOutput {
    /// Creates a new builder-style object to manufacture [`PurchaseReservedDbInstancesOfferingOutput`](crate::output::PurchaseReservedDbInstancesOfferingOutput)
    pub fn builder() -> crate::output::purchase_reserved_db_instances_offering_output::Builder {
        crate::output::purchase_reserved_db_instances_offering_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PromoteReadReplicaDbClusterOutput {
    /// <p>Contains the details of an Amazon Aurora DB cluster.
    /// </p>
    /// <p>This data type is used as a response element in the <code>DescribeDBClusters</code>,
    /// <code>StopDBCluster</code>, and <code>StartDBCluster</code> actions.
    /// </p>
    pub db_cluster: std::option::Option<crate::model::DbCluster>,
}
impl PromoteReadReplicaDbClusterOutput {
    /// <p>Contains the details of an Amazon Aurora DB cluster.
    /// </p>
    /// <p>This data type is used as a response element in the <code>DescribeDBClusters</code>,
    /// <code>StopDBCluster</code>, and <code>StartDBCluster</code> actions.
    /// </p>
    pub fn db_cluster(&self) -> std::option::Option<&crate::model::DbCluster> {
        self.db_cluster.as_ref()
    }
}
impl std::fmt::Debug for PromoteReadReplicaDbClusterOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PromoteReadReplicaDbClusterOutput");
        formatter.field("db_cluster", &self.db_cluster);
        formatter.finish()
    }
}
/// See [`PromoteReadReplicaDbClusterOutput`](crate::output::PromoteReadReplicaDbClusterOutput)
pub mod promote_read_replica_db_cluster_output {
    /// A builder for [`PromoteReadReplicaDbClusterOutput`](crate::output::PromoteReadReplicaDbClusterOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster: std::option::Option<crate::model::DbCluster>,
    }
    impl Builder {
        /// <p>Contains the details of an Amazon Aurora DB cluster.
        /// </p>
        /// <p>This data type is used as a response element in the <code>DescribeDBClusters</code>,
        /// <code>StopDBCluster</code>, and <code>StartDBCluster</code> actions.
        /// </p>
        pub fn db_cluster(mut self, input: crate::model::DbCluster) -> Self {
            self.db_cluster = Some(input);
            self
        }
        /// <p>Contains the details of an Amazon Aurora DB cluster.
        /// </p>
        /// <p>This data type is used as a response element in the <code>DescribeDBClusters</code>,
        /// <code>StopDBCluster</code>, and <code>StartDBCluster</code> actions.
        /// </p>
        pub fn set_db_cluster(
            mut self,
            input: std::option::Option<crate::model::DbCluster>,
        ) -> Self {
            self.db_cluster = input;
            self
        }
        /// Consumes the builder and constructs a [`PromoteReadReplicaDbClusterOutput`](crate::output::PromoteReadReplicaDbClusterOutput)
        pub fn build(self) -> crate::output::PromoteReadReplicaDbClusterOutput {
            crate::output::PromoteReadReplicaDbClusterOutput {
                db_cluster: self.db_cluster,
            }
        }
    }
}
impl PromoteReadReplicaDbClusterOutput {
    /// Creates a new builder-style object to manufacture [`PromoteReadReplicaDbClusterOutput`](crate::output::PromoteReadReplicaDbClusterOutput)
    pub fn builder() -> crate::output::promote_read_replica_db_cluster_output::Builder {
        crate::output::promote_read_replica_db_cluster_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PromoteReadReplicaOutput {
    /// <p>Contains the details of an Amazon RDS DB instance.
    /// </p>
    /// <p>This data type is used as a response element in the <code>DescribeDBInstances</code> action.
    /// </p>
    pub db_instance: std::option::Option<crate::model::DbInstance>,
}
impl PromoteReadReplicaOutput {
    /// <p>Contains the details of an Amazon RDS DB instance.
    /// </p>
    /// <p>This data type is used as a response element in the <code>DescribeDBInstances</code> action.
    /// </p>
    pub fn db_instance(&self) -> std::option::Option<&crate::model::DbInstance> {
        self.db_instance.as_ref()
    }
}
impl std::fmt::Debug for PromoteReadReplicaOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PromoteReadReplicaOutput");
        formatter.field("db_instance", &self.db_instance);
        formatter.finish()
    }
}
/// See [`PromoteReadReplicaOutput`](crate::output::PromoteReadReplicaOutput)
pub mod promote_read_replica_output {
    /// A builder for [`PromoteReadReplicaOutput`](crate::output::PromoteReadReplicaOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_instance: std::option::Option<crate::model::DbInstance>,
    }
    impl Builder {
        /// <p>Contains the details of an Amazon RDS DB instance.
        /// </p>
        /// <p>This data type is used as a response element in the <code>DescribeDBInstances</code> action.
        /// </p>
        pub fn db_instance(mut self, input: crate::model::DbInstance) -> Self {
            self.db_instance = Some(input);
            self
        }
        /// <p>Contains the details of an Amazon RDS DB instance.
        /// </p>
        /// <p>This data type is used as a response element in the <code>DescribeDBInstances</code> action.
        /// </p>
        pub fn set_db_instance(
            mut self,
            input: std::option::Option<crate::model::DbInstance>,
        ) -> Self {
            self.db_instance = input;
            self
        }
        /// Consumes the builder and constructs a [`PromoteReadReplicaOutput`](crate::output::PromoteReadReplicaOutput)
        pub fn build(self) -> crate::output::PromoteReadReplicaOutput {
            crate::output::PromoteReadReplicaOutput {
                db_instance: self.db_instance,
            }
        }
    }
}
impl PromoteReadReplicaOutput {
    /// Creates a new builder-style object to manufacture [`PromoteReadReplicaOutput`](crate::output::PromoteReadReplicaOutput)
    pub fn builder() -> crate::output::promote_read_replica_output::Builder {
        crate::output::promote_read_replica_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModifyOptionGroupOutput {
    /// <p></p>
    pub option_group: std::option::Option<crate::model::OptionGroup>,
}
impl ModifyOptionGroupOutput {
    /// <p></p>
    pub fn option_group(&self) -> std::option::Option<&crate::model::OptionGroup> {
        self.option_group.as_ref()
    }
}
impl std::fmt::Debug for ModifyOptionGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModifyOptionGroupOutput");
        formatter.field("option_group", &self.option_group);
        formatter.finish()
    }
}
/// See [`ModifyOptionGroupOutput`](crate::output::ModifyOptionGroupOutput)
pub mod modify_option_group_output {
    /// A builder for [`ModifyOptionGroupOutput`](crate::output::ModifyOptionGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) option_group: std::option::Option<crate::model::OptionGroup>,
    }
    impl Builder {
        /// <p></p>
        pub fn option_group(mut self, input: crate::model::OptionGroup) -> Self {
            self.option_group = Some(input);
            self
        }
        /// <p></p>
        pub fn set_option_group(
            mut self,
            input: std::option::Option<crate::model::OptionGroup>,
        ) -> Self {
            self.option_group = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyOptionGroupOutput`](crate::output::ModifyOptionGroupOutput)
        pub fn build(self) -> crate::output::ModifyOptionGroupOutput {
            crate::output::ModifyOptionGroupOutput {
                option_group: self.option_group,
            }
        }
    }
}
impl ModifyOptionGroupOutput {
    /// Creates a new builder-style object to manufacture [`ModifyOptionGroupOutput`](crate::output::ModifyOptionGroupOutput)
    pub fn builder() -> crate::output::modify_option_group_output::Builder {
        crate::output::modify_option_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModifyGlobalClusterOutput {
    /// <p>A data type representing an Aurora global database.</p>
    pub global_cluster: std::option::Option<crate::model::GlobalCluster>,
}
impl ModifyGlobalClusterOutput {
    /// <p>A data type representing an Aurora global database.</p>
    pub fn global_cluster(&self) -> std::option::Option<&crate::model::GlobalCluster> {
        self.global_cluster.as_ref()
    }
}
impl std::fmt::Debug for ModifyGlobalClusterOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModifyGlobalClusterOutput");
        formatter.field("global_cluster", &self.global_cluster);
        formatter.finish()
    }
}
/// See [`ModifyGlobalClusterOutput`](crate::output::ModifyGlobalClusterOutput)
pub mod modify_global_cluster_output {
    /// A builder for [`ModifyGlobalClusterOutput`](crate::output::ModifyGlobalClusterOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) global_cluster: std::option::Option<crate::model::GlobalCluster>,
    }
    impl Builder {
        /// <p>A data type representing an Aurora global database.</p>
        pub fn global_cluster(mut self, input: crate::model::GlobalCluster) -> Self {
            self.global_cluster = Some(input);
            self
        }
        /// <p>A data type representing an Aurora global database.</p>
        pub fn set_global_cluster(
            mut self,
            input: std::option::Option<crate::model::GlobalCluster>,
        ) -> Self {
            self.global_cluster = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyGlobalClusterOutput`](crate::output::ModifyGlobalClusterOutput)
        pub fn build(self) -> crate::output::ModifyGlobalClusterOutput {
            crate::output::ModifyGlobalClusterOutput {
                global_cluster: self.global_cluster,
            }
        }
    }
}
impl ModifyGlobalClusterOutput {
    /// Creates a new builder-style object to manufacture [`ModifyGlobalClusterOutput`](crate::output::ModifyGlobalClusterOutput)
    pub fn builder() -> crate::output::modify_global_cluster_output::Builder {
        crate::output::modify_global_cluster_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModifyEventSubscriptionOutput {
    /// <p>Contains the results of a successful invocation of the <code>DescribeEventSubscriptions</code> action.</p>
    pub event_subscription: std::option::Option<crate::model::EventSubscription>,
}
impl ModifyEventSubscriptionOutput {
    /// <p>Contains the results of a successful invocation of the <code>DescribeEventSubscriptions</code> action.</p>
    pub fn event_subscription(&self) -> std::option::Option<&crate::model::EventSubscription> {
        self.event_subscription.as_ref()
    }
}
impl std::fmt::Debug for ModifyEventSubscriptionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModifyEventSubscriptionOutput");
        formatter.field("event_subscription", &self.event_subscription);
        formatter.finish()
    }
}
/// See [`ModifyEventSubscriptionOutput`](crate::output::ModifyEventSubscriptionOutput)
pub mod modify_event_subscription_output {
    /// A builder for [`ModifyEventSubscriptionOutput`](crate::output::ModifyEventSubscriptionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) event_subscription: std::option::Option<crate::model::EventSubscription>,
    }
    impl Builder {
        /// <p>Contains the results of a successful invocation of the <code>DescribeEventSubscriptions</code> action.</p>
        pub fn event_subscription(mut self, input: crate::model::EventSubscription) -> Self {
            self.event_subscription = Some(input);
            self
        }
        /// <p>Contains the results of a successful invocation of the <code>DescribeEventSubscriptions</code> action.</p>
        pub fn set_event_subscription(
            mut self,
            input: std::option::Option<crate::model::EventSubscription>,
        ) -> Self {
            self.event_subscription = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyEventSubscriptionOutput`](crate::output::ModifyEventSubscriptionOutput)
        pub fn build(self) -> crate::output::ModifyEventSubscriptionOutput {
            crate::output::ModifyEventSubscriptionOutput {
                event_subscription: self.event_subscription,
            }
        }
    }
}
impl ModifyEventSubscriptionOutput {
    /// Creates a new builder-style object to manufacture [`ModifyEventSubscriptionOutput`](crate::output::ModifyEventSubscriptionOutput)
    pub fn builder() -> crate::output::modify_event_subscription_output::Builder {
        crate::output::modify_event_subscription_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModifyDbSubnetGroupOutput {
    /// <p>Contains the details of an Amazon RDS DB subnet group.
    /// </p>
    /// <p>This data type is used as a response element
    /// in the <code>DescribeDBSubnetGroups</code> action.
    /// </p>
    pub db_subnet_group: std::option::Option<crate::model::DbSubnetGroup>,
}
impl ModifyDbSubnetGroupOutput {
    /// <p>Contains the details of an Amazon RDS DB subnet group.
    /// </p>
    /// <p>This data type is used as a response element
    /// in the <code>DescribeDBSubnetGroups</code> action.
    /// </p>
    pub fn db_subnet_group(&self) -> std::option::Option<&crate::model::DbSubnetGroup> {
        self.db_subnet_group.as_ref()
    }
}
impl std::fmt::Debug for ModifyDbSubnetGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModifyDbSubnetGroupOutput");
        formatter.field("db_subnet_group", &self.db_subnet_group);
        formatter.finish()
    }
}
/// See [`ModifyDbSubnetGroupOutput`](crate::output::ModifyDbSubnetGroupOutput)
pub mod modify_db_subnet_group_output {
    /// A builder for [`ModifyDbSubnetGroupOutput`](crate::output::ModifyDbSubnetGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_subnet_group: std::option::Option<crate::model::DbSubnetGroup>,
    }
    impl Builder {
        /// <p>Contains the details of an Amazon RDS DB subnet group.
        /// </p>
        /// <p>This data type is used as a response element
        /// in the <code>DescribeDBSubnetGroups</code> action.
        /// </p>
        pub fn db_subnet_group(mut self, input: crate::model::DbSubnetGroup) -> Self {
            self.db_subnet_group = Some(input);
            self
        }
        /// <p>Contains the details of an Amazon RDS DB subnet group.
        /// </p>
        /// <p>This data type is used as a response element
        /// in the <code>DescribeDBSubnetGroups</code> action.
        /// </p>
        pub fn set_db_subnet_group(
            mut self,
            input: std::option::Option<crate::model::DbSubnetGroup>,
        ) -> Self {
            self.db_subnet_group = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyDbSubnetGroupOutput`](crate::output::ModifyDbSubnetGroupOutput)
        pub fn build(self) -> crate::output::ModifyDbSubnetGroupOutput {
            crate::output::ModifyDbSubnetGroupOutput {
                db_subnet_group: self.db_subnet_group,
            }
        }
    }
}
impl ModifyDbSubnetGroupOutput {
    /// Creates a new builder-style object to manufacture [`ModifyDbSubnetGroupOutput`](crate::output::ModifyDbSubnetGroupOutput)
    pub fn builder() -> crate::output::modify_db_subnet_group_output::Builder {
        crate::output::modify_db_subnet_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModifyDbSnapshotAttributeOutput {
    /// <p>Contains the results of a successful call to the <code>DescribeDBSnapshotAttributes</code>
    /// API action.</p>
    /// <p>Manual DB snapshot attributes are used to authorize other Amazon Web Services accounts
    /// to copy or restore a manual DB snapshot. For more information, see the <code>ModifyDBSnapshotAttribute</code>
    /// API action.</p>
    pub db_snapshot_attributes_result:
        std::option::Option<crate::model::DbSnapshotAttributesResult>,
}
impl ModifyDbSnapshotAttributeOutput {
    /// <p>Contains the results of a successful call to the <code>DescribeDBSnapshotAttributes</code>
    /// API action.</p>
    /// <p>Manual DB snapshot attributes are used to authorize other Amazon Web Services accounts
    /// to copy or restore a manual DB snapshot. For more information, see the <code>ModifyDBSnapshotAttribute</code>
    /// API action.</p>
    pub fn db_snapshot_attributes_result(
        &self,
    ) -> std::option::Option<&crate::model::DbSnapshotAttributesResult> {
        self.db_snapshot_attributes_result.as_ref()
    }
}
impl std::fmt::Debug for ModifyDbSnapshotAttributeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModifyDbSnapshotAttributeOutput");
        formatter.field(
            "db_snapshot_attributes_result",
            &self.db_snapshot_attributes_result,
        );
        formatter.finish()
    }
}
/// See [`ModifyDbSnapshotAttributeOutput`](crate::output::ModifyDbSnapshotAttributeOutput)
pub mod modify_db_snapshot_attribute_output {
    /// A builder for [`ModifyDbSnapshotAttributeOutput`](crate::output::ModifyDbSnapshotAttributeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_snapshot_attributes_result:
            std::option::Option<crate::model::DbSnapshotAttributesResult>,
    }
    impl Builder {
        /// <p>Contains the results of a successful call to the <code>DescribeDBSnapshotAttributes</code>
        /// API action.</p>
        /// <p>Manual DB snapshot attributes are used to authorize other Amazon Web Services accounts
        /// to copy or restore a manual DB snapshot. For more information, see the <code>ModifyDBSnapshotAttribute</code>
        /// API action.</p>
        pub fn db_snapshot_attributes_result(
            mut self,
            input: crate::model::DbSnapshotAttributesResult,
        ) -> Self {
            self.db_snapshot_attributes_result = Some(input);
            self
        }
        /// <p>Contains the results of a successful call to the <code>DescribeDBSnapshotAttributes</code>
        /// API action.</p>
        /// <p>Manual DB snapshot attributes are used to authorize other Amazon Web Services accounts
        /// to copy or restore a manual DB snapshot. For more information, see the <code>ModifyDBSnapshotAttribute</code>
        /// API action.</p>
        pub fn set_db_snapshot_attributes_result(
            mut self,
            input: std::option::Option<crate::model::DbSnapshotAttributesResult>,
        ) -> Self {
            self.db_snapshot_attributes_result = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyDbSnapshotAttributeOutput`](crate::output::ModifyDbSnapshotAttributeOutput)
        pub fn build(self) -> crate::output::ModifyDbSnapshotAttributeOutput {
            crate::output::ModifyDbSnapshotAttributeOutput {
                db_snapshot_attributes_result: self.db_snapshot_attributes_result,
            }
        }
    }
}
impl ModifyDbSnapshotAttributeOutput {
    /// Creates a new builder-style object to manufacture [`ModifyDbSnapshotAttributeOutput`](crate::output::ModifyDbSnapshotAttributeOutput)
    pub fn builder() -> crate::output::modify_db_snapshot_attribute_output::Builder {
        crate::output::modify_db_snapshot_attribute_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModifyDbSnapshotOutput {
    /// <p>Contains the details of an Amazon RDS DB snapshot.
    /// </p>
    /// <p>This data type is used as a response element
    /// in the <code>DescribeDBSnapshots</code> action.
    /// </p>
    pub db_snapshot: std::option::Option<crate::model::DbSnapshot>,
}
impl ModifyDbSnapshotOutput {
    /// <p>Contains the details of an Amazon RDS DB snapshot.
    /// </p>
    /// <p>This data type is used as a response element
    /// in the <code>DescribeDBSnapshots</code> action.
    /// </p>
    pub fn db_snapshot(&self) -> std::option::Option<&crate::model::DbSnapshot> {
        self.db_snapshot.as_ref()
    }
}
impl std::fmt::Debug for ModifyDbSnapshotOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModifyDbSnapshotOutput");
        formatter.field("db_snapshot", &self.db_snapshot);
        formatter.finish()
    }
}
/// See [`ModifyDbSnapshotOutput`](crate::output::ModifyDbSnapshotOutput)
pub mod modify_db_snapshot_output {
    /// A builder for [`ModifyDbSnapshotOutput`](crate::output::ModifyDbSnapshotOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_snapshot: std::option::Option<crate::model::DbSnapshot>,
    }
    impl Builder {
        /// <p>Contains the details of an Amazon RDS DB snapshot.
        /// </p>
        /// <p>This data type is used as a response element
        /// in the <code>DescribeDBSnapshots</code> action.
        /// </p>
        pub fn db_snapshot(mut self, input: crate::model::DbSnapshot) -> Self {
            self.db_snapshot = Some(input);
            self
        }
        /// <p>Contains the details of an Amazon RDS DB snapshot.
        /// </p>
        /// <p>This data type is used as a response element
        /// in the <code>DescribeDBSnapshots</code> action.
        /// </p>
        pub fn set_db_snapshot(
            mut self,
            input: std::option::Option<crate::model::DbSnapshot>,
        ) -> Self {
            self.db_snapshot = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyDbSnapshotOutput`](crate::output::ModifyDbSnapshotOutput)
        pub fn build(self) -> crate::output::ModifyDbSnapshotOutput {
            crate::output::ModifyDbSnapshotOutput {
                db_snapshot: self.db_snapshot,
            }
        }
    }
}
impl ModifyDbSnapshotOutput {
    /// Creates a new builder-style object to manufacture [`ModifyDbSnapshotOutput`](crate::output::ModifyDbSnapshotOutput)
    pub fn builder() -> crate::output::modify_db_snapshot_output::Builder {
        crate::output::modify_db_snapshot_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModifyDbProxyTargetGroupOutput {
    /// <p>The settings of the modified <code>DBProxyTarget</code>.</p>
    pub db_proxy_target_group: std::option::Option<crate::model::DbProxyTargetGroup>,
}
impl ModifyDbProxyTargetGroupOutput {
    /// <p>The settings of the modified <code>DBProxyTarget</code>.</p>
    pub fn db_proxy_target_group(&self) -> std::option::Option<&crate::model::DbProxyTargetGroup> {
        self.db_proxy_target_group.as_ref()
    }
}
impl std::fmt::Debug for ModifyDbProxyTargetGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModifyDbProxyTargetGroupOutput");
        formatter.field("db_proxy_target_group", &self.db_proxy_target_group);
        formatter.finish()
    }
}
/// See [`ModifyDbProxyTargetGroupOutput`](crate::output::ModifyDbProxyTargetGroupOutput)
pub mod modify_db_proxy_target_group_output {
    /// A builder for [`ModifyDbProxyTargetGroupOutput`](crate::output::ModifyDbProxyTargetGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_proxy_target_group: std::option::Option<crate::model::DbProxyTargetGroup>,
    }
    impl Builder {
        /// <p>The settings of the modified <code>DBProxyTarget</code>.</p>
        pub fn db_proxy_target_group(mut self, input: crate::model::DbProxyTargetGroup) -> Self {
            self.db_proxy_target_group = Some(input);
            self
        }
        /// <p>The settings of the modified <code>DBProxyTarget</code>.</p>
        pub fn set_db_proxy_target_group(
            mut self,
            input: std::option::Option<crate::model::DbProxyTargetGroup>,
        ) -> Self {
            self.db_proxy_target_group = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyDbProxyTargetGroupOutput`](crate::output::ModifyDbProxyTargetGroupOutput)
        pub fn build(self) -> crate::output::ModifyDbProxyTargetGroupOutput {
            crate::output::ModifyDbProxyTargetGroupOutput {
                db_proxy_target_group: self.db_proxy_target_group,
            }
        }
    }
}
impl ModifyDbProxyTargetGroupOutput {
    /// Creates a new builder-style object to manufacture [`ModifyDbProxyTargetGroupOutput`](crate::output::ModifyDbProxyTargetGroupOutput)
    pub fn builder() -> crate::output::modify_db_proxy_target_group_output::Builder {
        crate::output::modify_db_proxy_target_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModifyDbProxyEndpointOutput {
    /// <p>The <code>DBProxyEndpoint</code> object representing the new settings for the DB proxy endpoint.</p>
    pub db_proxy_endpoint: std::option::Option<crate::model::DbProxyEndpoint>,
}
impl ModifyDbProxyEndpointOutput {
    /// <p>The <code>DBProxyEndpoint</code> object representing the new settings for the DB proxy endpoint.</p>
    pub fn db_proxy_endpoint(&self) -> std::option::Option<&crate::model::DbProxyEndpoint> {
        self.db_proxy_endpoint.as_ref()
    }
}
impl std::fmt::Debug for ModifyDbProxyEndpointOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModifyDbProxyEndpointOutput");
        formatter.field("db_proxy_endpoint", &self.db_proxy_endpoint);
        formatter.finish()
    }
}
/// See [`ModifyDbProxyEndpointOutput`](crate::output::ModifyDbProxyEndpointOutput)
pub mod modify_db_proxy_endpoint_output {
    /// A builder for [`ModifyDbProxyEndpointOutput`](crate::output::ModifyDbProxyEndpointOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_proxy_endpoint: std::option::Option<crate::model::DbProxyEndpoint>,
    }
    impl Builder {
        /// <p>The <code>DBProxyEndpoint</code> object representing the new settings for the DB proxy endpoint.</p>
        pub fn db_proxy_endpoint(mut self, input: crate::model::DbProxyEndpoint) -> Self {
            self.db_proxy_endpoint = Some(input);
            self
        }
        /// <p>The <code>DBProxyEndpoint</code> object representing the new settings for the DB proxy endpoint.</p>
        pub fn set_db_proxy_endpoint(
            mut self,
            input: std::option::Option<crate::model::DbProxyEndpoint>,
        ) -> Self {
            self.db_proxy_endpoint = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyDbProxyEndpointOutput`](crate::output::ModifyDbProxyEndpointOutput)
        pub fn build(self) -> crate::output::ModifyDbProxyEndpointOutput {
            crate::output::ModifyDbProxyEndpointOutput {
                db_proxy_endpoint: self.db_proxy_endpoint,
            }
        }
    }
}
impl ModifyDbProxyEndpointOutput {
    /// Creates a new builder-style object to manufacture [`ModifyDbProxyEndpointOutput`](crate::output::ModifyDbProxyEndpointOutput)
    pub fn builder() -> crate::output::modify_db_proxy_endpoint_output::Builder {
        crate::output::modify_db_proxy_endpoint_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModifyDbProxyOutput {
    /// <p>The <code>DBProxy</code> object representing the new settings for the proxy.</p>
    pub db_proxy: std::option::Option<crate::model::DbProxy>,
}
impl ModifyDbProxyOutput {
    /// <p>The <code>DBProxy</code> object representing the new settings for the proxy.</p>
    pub fn db_proxy(&self) -> std::option::Option<&crate::model::DbProxy> {
        self.db_proxy.as_ref()
    }
}
impl std::fmt::Debug for ModifyDbProxyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModifyDbProxyOutput");
        formatter.field("db_proxy", &self.db_proxy);
        formatter.finish()
    }
}
/// See [`ModifyDbProxyOutput`](crate::output::ModifyDbProxyOutput)
pub mod modify_db_proxy_output {
    /// A builder for [`ModifyDbProxyOutput`](crate::output::ModifyDbProxyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_proxy: std::option::Option<crate::model::DbProxy>,
    }
    impl Builder {
        /// <p>The <code>DBProxy</code> object representing the new settings for the proxy.</p>
        pub fn db_proxy(mut self, input: crate::model::DbProxy) -> Self {
            self.db_proxy = Some(input);
            self
        }
        /// <p>The <code>DBProxy</code> object representing the new settings for the proxy.</p>
        pub fn set_db_proxy(mut self, input: std::option::Option<crate::model::DbProxy>) -> Self {
            self.db_proxy = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyDbProxyOutput`](crate::output::ModifyDbProxyOutput)
        pub fn build(self) -> crate::output::ModifyDbProxyOutput {
            crate::output::ModifyDbProxyOutput {
                db_proxy: self.db_proxy,
            }
        }
    }
}
impl ModifyDbProxyOutput {
    /// Creates a new builder-style object to manufacture [`ModifyDbProxyOutput`](crate::output::ModifyDbProxyOutput)
    pub fn builder() -> crate::output::modify_db_proxy_output::Builder {
        crate::output::modify_db_proxy_output::Builder::default()
    }
}

/// <p>
/// Contains the result of a successful invocation of the
/// <code>ModifyDBParameterGroup</code> or <code>ResetDBParameterGroup</code> action.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModifyDbParameterGroupOutput {
    /// <p>The name of the DB parameter group.</p>
    pub db_parameter_group_name: std::option::Option<std::string::String>,
}
impl ModifyDbParameterGroupOutput {
    /// <p>The name of the DB parameter group.</p>
    pub fn db_parameter_group_name(&self) -> std::option::Option<&str> {
        self.db_parameter_group_name.as_deref()
    }
}
impl std::fmt::Debug for ModifyDbParameterGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModifyDbParameterGroupOutput");
        formatter.field("db_parameter_group_name", &self.db_parameter_group_name);
        formatter.finish()
    }
}
/// See [`ModifyDbParameterGroupOutput`](crate::output::ModifyDbParameterGroupOutput)
pub mod modify_db_parameter_group_output {
    /// A builder for [`ModifyDbParameterGroupOutput`](crate::output::ModifyDbParameterGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_parameter_group_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the DB parameter group.</p>
        pub fn db_parameter_group_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_parameter_group_name = Some(input.into());
            self
        }
        /// <p>The name of the DB parameter group.</p>
        pub fn set_db_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_parameter_group_name = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyDbParameterGroupOutput`](crate::output::ModifyDbParameterGroupOutput)
        pub fn build(self) -> crate::output::ModifyDbParameterGroupOutput {
            crate::output::ModifyDbParameterGroupOutput {
                db_parameter_group_name: self.db_parameter_group_name,
            }
        }
    }
}
impl ModifyDbParameterGroupOutput {
    /// Creates a new builder-style object to manufacture [`ModifyDbParameterGroupOutput`](crate::output::ModifyDbParameterGroupOutput)
    pub fn builder() -> crate::output::modify_db_parameter_group_output::Builder {
        crate::output::modify_db_parameter_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModifyDbInstanceOutput {
    /// <p>Contains the details of an Amazon RDS DB instance.
    /// </p>
    /// <p>This data type is used as a response element in the <code>DescribeDBInstances</code> action.
    /// </p>
    pub db_instance: std::option::Option<crate::model::DbInstance>,
}
impl ModifyDbInstanceOutput {
    /// <p>Contains the details of an Amazon RDS DB instance.
    /// </p>
    /// <p>This data type is used as a response element in the <code>DescribeDBInstances</code> action.
    /// </p>
    pub fn db_instance(&self) -> std::option::Option<&crate::model::DbInstance> {
        self.db_instance.as_ref()
    }
}
impl std::fmt::Debug for ModifyDbInstanceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModifyDbInstanceOutput");
        formatter.field("db_instance", &self.db_instance);
        formatter.finish()
    }
}
/// See [`ModifyDbInstanceOutput`](crate::output::ModifyDbInstanceOutput)
pub mod modify_db_instance_output {
    /// A builder for [`ModifyDbInstanceOutput`](crate::output::ModifyDbInstanceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_instance: std::option::Option<crate::model::DbInstance>,
    }
    impl Builder {
        /// <p>Contains the details of an Amazon RDS DB instance.
        /// </p>
        /// <p>This data type is used as a response element in the <code>DescribeDBInstances</code> action.
        /// </p>
        pub fn db_instance(mut self, input: crate::model::DbInstance) -> Self {
            self.db_instance = Some(input);
            self
        }
        /// <p>Contains the details of an Amazon RDS DB instance.
        /// </p>
        /// <p>This data type is used as a response element in the <code>DescribeDBInstances</code> action.
        /// </p>
        pub fn set_db_instance(
            mut self,
            input: std::option::Option<crate::model::DbInstance>,
        ) -> Self {
            self.db_instance = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyDbInstanceOutput`](crate::output::ModifyDbInstanceOutput)
        pub fn build(self) -> crate::output::ModifyDbInstanceOutput {
            crate::output::ModifyDbInstanceOutput {
                db_instance: self.db_instance,
            }
        }
    }
}
impl ModifyDbInstanceOutput {
    /// Creates a new builder-style object to manufacture [`ModifyDbInstanceOutput`](crate::output::ModifyDbInstanceOutput)
    pub fn builder() -> crate::output::modify_db_instance_output::Builder {
        crate::output::modify_db_instance_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModifyDbClusterSnapshotAttributeOutput {
    /// <p>Contains the results of a successful call to the <code>DescribeDBClusterSnapshotAttributes</code>
    /// API action.</p>
    /// <p>Manual DB cluster snapshot attributes are used to authorize other Amazon Web Services accounts
    /// to copy or restore a manual DB cluster snapshot. For more information, see the <code>ModifyDBClusterSnapshotAttribute</code>
    /// API action.</p>
    pub db_cluster_snapshot_attributes_result:
        std::option::Option<crate::model::DbClusterSnapshotAttributesResult>,
}
impl ModifyDbClusterSnapshotAttributeOutput {
    /// <p>Contains the results of a successful call to the <code>DescribeDBClusterSnapshotAttributes</code>
    /// API action.</p>
    /// <p>Manual DB cluster snapshot attributes are used to authorize other Amazon Web Services accounts
    /// to copy or restore a manual DB cluster snapshot. For more information, see the <code>ModifyDBClusterSnapshotAttribute</code>
    /// API action.</p>
    pub fn db_cluster_snapshot_attributes_result(
        &self,
    ) -> std::option::Option<&crate::model::DbClusterSnapshotAttributesResult> {
        self.db_cluster_snapshot_attributes_result.as_ref()
    }
}
impl std::fmt::Debug for ModifyDbClusterSnapshotAttributeOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModifyDbClusterSnapshotAttributeOutput");
        formatter.field(
            "db_cluster_snapshot_attributes_result",
            &self.db_cluster_snapshot_attributes_result,
        );
        formatter.finish()
    }
}
/// See [`ModifyDbClusterSnapshotAttributeOutput`](crate::output::ModifyDbClusterSnapshotAttributeOutput)
pub mod modify_db_cluster_snapshot_attribute_output {
    /// A builder for [`ModifyDbClusterSnapshotAttributeOutput`](crate::output::ModifyDbClusterSnapshotAttributeOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster_snapshot_attributes_result:
            std::option::Option<crate::model::DbClusterSnapshotAttributesResult>,
    }
    impl Builder {
        /// <p>Contains the results of a successful call to the <code>DescribeDBClusterSnapshotAttributes</code>
        /// API action.</p>
        /// <p>Manual DB cluster snapshot attributes are used to authorize other Amazon Web Services accounts
        /// to copy or restore a manual DB cluster snapshot. For more information, see the <code>ModifyDBClusterSnapshotAttribute</code>
        /// API action.</p>
        pub fn db_cluster_snapshot_attributes_result(
            mut self,
            input: crate::model::DbClusterSnapshotAttributesResult,
        ) -> Self {
            self.db_cluster_snapshot_attributes_result = Some(input);
            self
        }
        /// <p>Contains the results of a successful call to the <code>DescribeDBClusterSnapshotAttributes</code>
        /// API action.</p>
        /// <p>Manual DB cluster snapshot attributes are used to authorize other Amazon Web Services accounts
        /// to copy or restore a manual DB cluster snapshot. For more information, see the <code>ModifyDBClusterSnapshotAttribute</code>
        /// API action.</p>
        pub fn set_db_cluster_snapshot_attributes_result(
            mut self,
            input: std::option::Option<crate::model::DbClusterSnapshotAttributesResult>,
        ) -> Self {
            self.db_cluster_snapshot_attributes_result = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyDbClusterSnapshotAttributeOutput`](crate::output::ModifyDbClusterSnapshotAttributeOutput)
        pub fn build(self) -> crate::output::ModifyDbClusterSnapshotAttributeOutput {
            crate::output::ModifyDbClusterSnapshotAttributeOutput {
                db_cluster_snapshot_attributes_result: self.db_cluster_snapshot_attributes_result,
            }
        }
    }
}
impl ModifyDbClusterSnapshotAttributeOutput {
    /// Creates a new builder-style object to manufacture [`ModifyDbClusterSnapshotAttributeOutput`](crate::output::ModifyDbClusterSnapshotAttributeOutput)
    pub fn builder() -> crate::output::modify_db_cluster_snapshot_attribute_output::Builder {
        crate::output::modify_db_cluster_snapshot_attribute_output::Builder::default()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModifyDbClusterParameterGroupOutput {
    /// <p>The name of the DB cluster parameter group.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>Must be 1 to 255 letters or numbers.</p>
    /// </li>
    /// <li>
    /// <p>First character must be a letter</p>
    /// </li>
    /// <li>
    /// <p>Can't end with a hyphen or contain two consecutive hyphens</p>
    /// </li>
    /// </ul>
    /// <note>
    /// <p>This value is stored as a lowercase string.</p>
    /// </note>
    pub db_cluster_parameter_group_name: std::option::Option<std::string::String>,
}
impl ModifyDbClusterParameterGroupOutput {
    /// <p>The name of the DB cluster parameter group.</p>
    /// <p>Constraints:</p>
    /// <ul>
    /// <li>
    /// <p>Must be 1 to 255 letters or numbers.</p>
    /// </li>
    /// <li>
    /// <p>First character must be a letter</p>
    /// </li>
    /// <li>
    /// <p>Can't end with a hyphen or contain two consecutive hyphens</p>
    /// </li>
    /// </ul>
    /// <note>
    /// <p>This value is stored as a lowercase string.</p>
    /// </note>
    pub fn db_cluster_parameter_group_name(&self) -> std::option::Option<&str> {
        self.db_cluster_parameter_group_name.as_deref()
    }
}
impl std::fmt::Debug for ModifyDbClusterParameterGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModifyDbClusterParameterGroupOutput");
        formatter.field(
            "db_cluster_parameter_group_name",
            &self.db_cluster_parameter_group_name,
        );
        formatter.finish()
    }
}
/// See [`ModifyDbClusterParameterGroupOutput`](crate::output::ModifyDbClusterParameterGroupOutput)
pub mod modify_db_cluster_parameter_group_output {
    /// A builder for [`ModifyDbClusterParameterGroupOutput`](crate::output::ModifyDbClusterParameterGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster_parameter_group_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the DB cluster parameter group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be 1 to 255 letters or numbers.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter</p>
        /// </li>
        /// <li>
        /// <p>Can't end with a hyphen or contain two consecutive hyphens</p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>This value is stored as a lowercase string.</p>
        /// </note>
        pub fn db_cluster_parameter_group_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.db_cluster_parameter_group_name = Some(input.into());
            self
        }
        /// <p>The name of the DB cluster parameter group.</p>
        /// <p>Constraints:</p>
        /// <ul>
        /// <li>
        /// <p>Must be 1 to 255 letters or numbers.</p>
        /// </li>
        /// <li>
        /// <p>First character must be a letter</p>
        /// </li>
        /// <li>
        /// <p>Can't end with a hyphen or contain two consecutive hyphens</p>
        /// </li>
        /// </ul>
        /// <note>
        /// <p>This value is stored as a lowercase string.</p>
        /// </note>
        pub fn set_db_cluster_parameter_group_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_parameter_group_name = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyDbClusterParameterGroupOutput`](crate::output::ModifyDbClusterParameterGroupOutput)
        pub fn build(self) -> crate::output::ModifyDbClusterParameterGroupOutput {
            crate::output::ModifyDbClusterParameterGroupOutput {
                db_cluster_parameter_group_name: self.db_cluster_parameter_group_name,
            }
        }
    }
}
impl ModifyDbClusterParameterGroupOutput {
    /// Creates a new builder-style object to manufacture [`ModifyDbClusterParameterGroupOutput`](crate::output::ModifyDbClusterParameterGroupOutput)
    pub fn builder() -> crate::output::modify_db_cluster_parameter_group_output::Builder {
        crate::output::modify_db_cluster_parameter_group_output::Builder::default()
    }
}

/// <p>This data type represents the information you need to connect to an Amazon Aurora DB cluster.
/// This data type is used as a response element in the following actions:</p>
/// <ul>
/// <li>
/// <p>
/// <code>CreateDBClusterEndpoint</code>
/// </p>
/// </li>
/// <li>
/// <p>
/// <code>DescribeDBClusterEndpoints</code>
/// </p>
/// </li>
/// <li>
/// <p>
/// <code>ModifyDBClusterEndpoint</code>
/// </p>
/// </li>
/// <li>
/// <p>
/// <code>DeleteDBClusterEndpoint</code>
/// </p>
/// </li>
/// </ul>
/// <p>For the data structure that represents Amazon RDS DB instance endpoints,
/// see <code>Endpoint</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModifyDbClusterEndpointOutput {
    /// <p>The identifier associated with the endpoint. This parameter is stored as a lowercase string.</p>
    pub db_cluster_endpoint_identifier: std::option::Option<std::string::String>,
    /// <p>The DB cluster identifier of the DB cluster associated with the endpoint. This parameter is
    /// stored as a lowercase string.</p>
    pub db_cluster_identifier: std::option::Option<std::string::String>,
    /// <p>A unique system-generated identifier for an endpoint. It remains the same for the whole life of the endpoint.</p>
    pub db_cluster_endpoint_resource_identifier: std::option::Option<std::string::String>,
    /// <p>The DNS address of the endpoint.</p>
    pub endpoint: std::option::Option<std::string::String>,
    /// <p>The current status of the endpoint. One of: <code>creating</code>, <code>available</code>, <code>deleting</code>, <code>inactive</code>, <code>modifying</code>. The <code>inactive</code> state applies to an endpoint that can't be used for a certain kind of cluster,
    /// such as a <code>writer</code> endpoint for a read-only secondary cluster in a global database.</p>
    pub status: std::option::Option<std::string::String>,
    /// <p>The type of the endpoint. One of: <code>READER</code>, <code>WRITER</code>, <code>CUSTOM</code>.</p>
    pub endpoint_type: std::option::Option<std::string::String>,
    /// <p>The type associated with a custom endpoint. One of: <code>READER</code>,
    /// <code>WRITER</code>, <code>ANY</code>.</p>
    pub custom_endpoint_type: std::option::Option<std::string::String>,
    /// <p>List of DB instance identifiers that are part of the custom endpoint group.</p>
    pub static_members: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>List of DB instance identifiers that aren't part of the custom endpoint group.
    /// All other eligible instances are reachable through the custom endpoint.
    /// Only relevant if the list of static members is empty.</p>
    pub excluded_members: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The Amazon Resource Name (ARN) for the endpoint.</p>
    pub db_cluster_endpoint_arn: std::option::Option<std::string::String>,
}
impl ModifyDbClusterEndpointOutput {
    /// <p>The identifier associated with the endpoint. This parameter is stored as a lowercase string.</p>
    pub fn db_cluster_endpoint_identifier(&self) -> std::option::Option<&str> {
        self.db_cluster_endpoint_identifier.as_deref()
    }
    /// <p>The DB cluster identifier of the DB cluster associated with the endpoint. This parameter is
    /// stored as a lowercase string.</p>
    pub fn db_cluster_identifier(&self) -> std::option::Option<&str> {
        self.db_cluster_identifier.as_deref()
    }
    /// <p>A unique system-generated identifier for an endpoint. It remains the same for the whole life of the endpoint.</p>
    pub fn db_cluster_endpoint_resource_identifier(&self) -> std::option::Option<&str> {
        self.db_cluster_endpoint_resource_identifier.as_deref()
    }
    /// <p>The DNS address of the endpoint.</p>
    pub fn endpoint(&self) -> std::option::Option<&str> {
        self.endpoint.as_deref()
    }
    /// <p>The current status of the endpoint. One of: <code>creating</code>, <code>available</code>, <code>deleting</code>, <code>inactive</code>, <code>modifying</code>. The <code>inactive</code> state applies to an endpoint that can't be used for a certain kind of cluster,
    /// such as a <code>writer</code> endpoint for a read-only secondary cluster in a global database.</p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>The type of the endpoint. One of: <code>READER</code>, <code>WRITER</code>, <code>CUSTOM</code>.</p>
    pub fn endpoint_type(&self) -> std::option::Option<&str> {
        self.endpoint_type.as_deref()
    }
    /// <p>The type associated with a custom endpoint. One of: <code>READER</code>,
    /// <code>WRITER</code>, <code>ANY</code>.</p>
    pub fn custom_endpoint_type(&self) -> std::option::Option<&str> {
        self.custom_endpoint_type.as_deref()
    }
    /// <p>List of DB instance identifiers that are part of the custom endpoint group.</p>
    pub fn static_members(&self) -> std::option::Option<&[std::string::String]> {
        self.static_members.as_deref()
    }
    /// <p>List of DB instance identifiers that aren't part of the custom endpoint group.
    /// All other eligible instances are reachable through the custom endpoint.
    /// Only relevant if the list of static members is empty.</p>
    pub fn excluded_members(&self) -> std::option::Option<&[std::string::String]> {
        self.excluded_members.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) for the endpoint.</p>
    pub fn db_cluster_endpoint_arn(&self) -> std::option::Option<&str> {
        self.db_cluster_endpoint_arn.as_deref()
    }
}
impl std::fmt::Debug for ModifyDbClusterEndpointOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModifyDbClusterEndpointOutput");
        formatter.field(
            "db_cluster_endpoint_identifier",
            &self.db_cluster_endpoint_identifier,
        );
        formatter.field("db_cluster_identifier", &self.db_cluster_identifier);
        formatter.field(
            "db_cluster_endpoint_resource_identifier",
            &self.db_cluster_endpoint_resource_identifier,
        );
        formatter.field("endpoint", &self.endpoint);
        formatter.field("status", &self.status);
        formatter.field("endpoint_type", &self.endpoint_type);
        formatter.field("custom_endpoint_type", &self.custom_endpoint_type);
        formatter.field("static_members", &self.static_members);
        formatter.field("excluded_members", &self.excluded_members);
        formatter.field("db_cluster_endpoint_arn", &self.db_cluster_endpoint_arn);
        formatter.finish()
    }
}
/// See [`ModifyDbClusterEndpointOutput`](crate::output::ModifyDbClusterEndpointOutput)
pub mod modify_db_cluster_endpoint_output {
    /// A builder for [`ModifyDbClusterEndpointOutput`](crate::output::ModifyDbClusterEndpointOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster_endpoint_identifier: std::option::Option<std::string::String>,
        pub(crate) db_cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) db_cluster_endpoint_resource_identifier:
            std::option::Option<std::string::String>,
        pub(crate) endpoint: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) endpoint_type: std::option::Option<std::string::String>,
        pub(crate) custom_endpoint_type: std::option::Option<std::string::String>,
        pub(crate) static_members: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) excluded_members: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) db_cluster_endpoint_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier associated with the endpoint. This parameter is stored as a lowercase string.</p>
        pub fn db_cluster_endpoint_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.db_cluster_endpoint_identifier = Some(input.into());
            self
        }
        /// <p>The identifier associated with the endpoint. This parameter is stored as a lowercase string.</p>
        pub fn set_db_cluster_endpoint_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_endpoint_identifier = input;
            self
        }
        /// <p>The DB cluster identifier of the DB cluster associated with the endpoint. This parameter is
        /// stored as a lowercase string.</p>
        pub fn db_cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_cluster_identifier = Some(input.into());
            self
        }
        /// <p>The DB cluster identifier of the DB cluster associated with the endpoint. This parameter is
        /// stored as a lowercase string.</p>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_identifier = input;
            self
        }
        /// <p>A unique system-generated identifier for an endpoint. It remains the same for the whole life of the endpoint.</p>
        pub fn db_cluster_endpoint_resource_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.db_cluster_endpoint_resource_identifier = Some(input.into());
            self
        }
        /// <p>A unique system-generated identifier for an endpoint. It remains the same for the whole life of the endpoint.</p>
        pub fn set_db_cluster_endpoint_resource_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_endpoint_resource_identifier = input;
            self
        }
        /// <p>The DNS address of the endpoint.</p>
        pub fn endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint = Some(input.into());
            self
        }
        /// <p>The DNS address of the endpoint.</p>
        pub fn set_endpoint(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.endpoint = input;
            self
        }
        /// <p>The current status of the endpoint. One of: <code>creating</code>, <code>available</code>, <code>deleting</code>, <code>inactive</code>, <code>modifying</code>. The <code>inactive</code> state applies to an endpoint that can't be used for a certain kind of cluster,
        /// such as a <code>writer</code> endpoint for a read-only secondary cluster in a global database.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The current status of the endpoint. One of: <code>creating</code>, <code>available</code>, <code>deleting</code>, <code>inactive</code>, <code>modifying</code>. The <code>inactive</code> state applies to an endpoint that can't be used for a certain kind of cluster,
        /// such as a <code>writer</code> endpoint for a read-only secondary cluster in a global database.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>The type of the endpoint. One of: <code>READER</code>, <code>WRITER</code>, <code>CUSTOM</code>.</p>
        pub fn endpoint_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_type = Some(input.into());
            self
        }
        /// <p>The type of the endpoint. One of: <code>READER</code>, <code>WRITER</code>, <code>CUSTOM</code>.</p>
        pub fn set_endpoint_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.endpoint_type = input;
            self
        }
        /// <p>The type associated with a custom endpoint. One of: <code>READER</code>,
        /// <code>WRITER</code>, <code>ANY</code>.</p>
        pub fn custom_endpoint_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.custom_endpoint_type = Some(input.into());
            self
        }
        /// <p>The type associated with a custom endpoint. One of: <code>READER</code>,
        /// <code>WRITER</code>, <code>ANY</code>.</p>
        pub fn set_custom_endpoint_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.custom_endpoint_type = input;
            self
        }
        /// Appends an item to `static_members`.
        ///
        /// To override the contents of this collection use [`set_static_members`](Self::set_static_members).
        ///
        /// <p>List of DB instance identifiers that are part of the custom endpoint group.</p>
        pub fn static_members(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.static_members.unwrap_or_default();
            v.push(input.into());
            self.static_members = Some(v);
            self
        }
        /// <p>List of DB instance identifiers that are part of the custom endpoint group.</p>
        pub fn set_static_members(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.static_members = input;
            self
        }
        /// Appends an item to `excluded_members`.
        ///
        /// To override the contents of this collection use [`set_excluded_members`](Self::set_excluded_members).
        ///
        /// <p>List of DB instance identifiers that aren't part of the custom endpoint group.
        /// All other eligible instances are reachable through the custom endpoint.
        /// Only relevant if the list of static members is empty.</p>
        pub fn excluded_members(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.excluded_members.unwrap_or_default();
            v.push(input.into());
            self.excluded_members = Some(v);
            self
        }
        /// <p>List of DB instance identifiers that aren't part of the custom endpoint group.
        /// All other eligible instances are reachable through the custom endpoint.
        /// Only relevant if the list of static members is empty.</p>
        pub fn set_excluded_members(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.excluded_members = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the endpoint.</p>
        pub fn db_cluster_endpoint_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_cluster_endpoint_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the endpoint.</p>
        pub fn set_db_cluster_endpoint_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_endpoint_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyDbClusterEndpointOutput`](crate::output::ModifyDbClusterEndpointOutput)
        pub fn build(self) -> crate::output::ModifyDbClusterEndpointOutput {
            crate::output::ModifyDbClusterEndpointOutput {
                db_cluster_endpoint_identifier: self.db_cluster_endpoint_identifier,
                db_cluster_identifier: self.db_cluster_identifier,
                db_cluster_endpoint_resource_identifier: self
                    .db_cluster_endpoint_resource_identifier,
                endpoint: self.endpoint,
                status: self.status,
                endpoint_type: self.endpoint_type,
                custom_endpoint_type: self.custom_endpoint_type,
                static_members: self.static_members,
                excluded_members: self.excluded_members,
                db_cluster_endpoint_arn: self.db_cluster_endpoint_arn,
            }
        }
    }
}
impl ModifyDbClusterEndpointOutput {
    /// Creates a new builder-style object to manufacture [`ModifyDbClusterEndpointOutput`](crate::output::ModifyDbClusterEndpointOutput)
    pub fn builder() -> crate::output::modify_db_cluster_endpoint_output::Builder {
        crate::output::modify_db_cluster_endpoint_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModifyDbClusterOutput {
    /// <p>Contains the details of an Amazon Aurora DB cluster.
    /// </p>
    /// <p>This data type is used as a response element in the <code>DescribeDBClusters</code>,
    /// <code>StopDBCluster</code>, and <code>StartDBCluster</code> actions.
    /// </p>
    pub db_cluster: std::option::Option<crate::model::DbCluster>,
}
impl ModifyDbClusterOutput {
    /// <p>Contains the details of an Amazon Aurora DB cluster.
    /// </p>
    /// <p>This data type is used as a response element in the <code>DescribeDBClusters</code>,
    /// <code>StopDBCluster</code>, and <code>StartDBCluster</code> actions.
    /// </p>
    pub fn db_cluster(&self) -> std::option::Option<&crate::model::DbCluster> {
        self.db_cluster.as_ref()
    }
}
impl std::fmt::Debug for ModifyDbClusterOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModifyDbClusterOutput");
        formatter.field("db_cluster", &self.db_cluster);
        formatter.finish()
    }
}
/// See [`ModifyDbClusterOutput`](crate::output::ModifyDbClusterOutput)
pub mod modify_db_cluster_output {
    /// A builder for [`ModifyDbClusterOutput`](crate::output::ModifyDbClusterOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster: std::option::Option<crate::model::DbCluster>,
    }
    impl Builder {
        /// <p>Contains the details of an Amazon Aurora DB cluster.
        /// </p>
        /// <p>This data type is used as a response element in the <code>DescribeDBClusters</code>,
        /// <code>StopDBCluster</code>, and <code>StartDBCluster</code> actions.
        /// </p>
        pub fn db_cluster(mut self, input: crate::model::DbCluster) -> Self {
            self.db_cluster = Some(input);
            self
        }
        /// <p>Contains the details of an Amazon Aurora DB cluster.
        /// </p>
        /// <p>This data type is used as a response element in the <code>DescribeDBClusters</code>,
        /// <code>StopDBCluster</code>, and <code>StartDBCluster</code> actions.
        /// </p>
        pub fn set_db_cluster(
            mut self,
            input: std::option::Option<crate::model::DbCluster>,
        ) -> Self {
            self.db_cluster = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyDbClusterOutput`](crate::output::ModifyDbClusterOutput)
        pub fn build(self) -> crate::output::ModifyDbClusterOutput {
            crate::output::ModifyDbClusterOutput {
                db_cluster: self.db_cluster,
            }
        }
    }
}
impl ModifyDbClusterOutput {
    /// Creates a new builder-style object to manufacture [`ModifyDbClusterOutput`](crate::output::ModifyDbClusterOutput)
    pub fn builder() -> crate::output::modify_db_cluster_output::Builder {
        crate::output::modify_db_cluster_output::Builder::default()
    }
}

/// <p>
/// This data type is used as a response element in the action <code>DescribeDBEngineVersions</code>.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModifyCustomDbEngineVersionOutput {
    /// <p>The name of the database engine.</p>
    pub engine: std::option::Option<std::string::String>,
    /// <p>The version number of the database engine.</p>
    pub engine_version: std::option::Option<std::string::String>,
    /// <p>The name of the DB parameter group family for the database engine.</p>
    pub db_parameter_group_family: std::option::Option<std::string::String>,
    /// <p>The description of the database engine.</p>
    pub db_engine_description: std::option::Option<std::string::String>,
    /// <p>The description of the database engine version.</p>
    pub db_engine_version_description: std::option::Option<std::string::String>,
    /// <p>
    /// The default character set for new instances of this engine version,
    /// if the <code>CharacterSetName</code> parameter of the CreateDBInstance API
    /// isn't specified.
    /// </p>
    pub default_character_set: std::option::Option<crate::model::CharacterSet>,
    /// <p>A list of the character sets supported by this engine for the <code>CharacterSetName</code> parameter of the <code>CreateDBInstance</code> operation.  
    /// </p>
    pub supported_character_sets: std::option::Option<std::vec::Vec<crate::model::CharacterSet>>,
    /// <p>A list of the character sets supported by the Oracle DB engine for the <code>NcharCharacterSetName</code> parameter of the <code>CreateDBInstance</code> operation.  
    /// </p>
    pub supported_nchar_character_sets:
        std::option::Option<std::vec::Vec<crate::model::CharacterSet>>,
    /// <p>A list of engine versions that this database engine version can be upgraded to.</p>
    pub valid_upgrade_target: std::option::Option<std::vec::Vec<crate::model::UpgradeTarget>>,
    /// <p>A list of the time zones supported by this engine for the
    /// <code>Timezone</code> parameter of the <code>CreateDBInstance</code> action.  
    /// </p>
    pub supported_timezones: std::option::Option<std::vec::Vec<crate::model::Timezone>>,
    /// <p>The types of logs that the database engine has available for export to CloudWatch Logs.</p>
    pub exportable_log_types: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A value that indicates whether the engine version supports exporting the log types specified by ExportableLogTypes to CloudWatch Logs.</p>
    pub supports_log_exports_to_cloudwatch_logs: bool,
    /// <p>Indicates whether the database engine version supports read replicas.</p>
    pub supports_read_replica: bool,
    /// <p>A list of the supported DB engine modes.</p>
    pub supported_engine_modes: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>
    /// A list of features supported by the DB engine.
    /// </p>
    /// <p>The supported features vary by DB engine and DB engine version.</p>
    /// <p>To determine the supported features for a specific DB engine and DB engine version using the CLI,
    /// use the following command:</p>
    /// <p>
    /// <code>aws rds describe-db-engine-versions --engine <engine_name> --engine-version <engine_version></code>
    /// </p>
    /// <p>For example, to determine the supported features for RDS for PostgreSQL version 13.3 using the CLI,
    /// use the following command:</p>
    /// <p>
    /// <code>aws rds describe-db-engine-versions --engine postgres --engine-version 13.3</code>
    /// </p>
    /// <p>The supported features are listed under <code>SupportedFeatureNames</code> in the output.</p>
    pub supported_feature_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The status of the DB engine version, either <code>available</code> or <code>deprecated</code>.</p>
    pub status: std::option::Option<std::string::String>,
    /// <p>A value that indicates whether you can use Aurora parallel query with a specific DB engine version.</p>
    pub supports_parallel_query: bool,
    /// <p>A value that indicates whether you can use Aurora global databases with a specific DB engine version.</p>
    pub supports_global_databases: bool,
    /// <p>The major engine version of the CEV.</p>
    pub major_engine_version: std::option::Option<std::string::String>,
    /// <p>The name of the Amazon S3 bucket that contains your database installation files.</p>
    pub database_installation_files_s3_bucket_name: std::option::Option<std::string::String>,
    /// <p>The Amazon S3 directory that contains the database installation files.
    /// If not specified, then no prefix is assumed.</p>
    pub database_installation_files_s3_prefix: std::option::Option<std::string::String>,
    /// <p>The ARN of the custom engine version.</p>
    pub db_engine_version_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services KMS key identifier for an encrypted CEV. This parameter is required for
    /// RDS Custom, but optional for Amazon RDS.</p>
    pub kms_key_id: std::option::Option<std::string::String>,
    /// <p>The creation time of the DB engine version.</p>
    pub create_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>A list of tags.
    /// For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources</a> in the <i>Amazon RDS User Guide.</i>           
    /// </p>
    pub tag_list: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl ModifyCustomDbEngineVersionOutput {
    /// <p>The name of the database engine.</p>
    pub fn engine(&self) -> std::option::Option<&str> {
        self.engine.as_deref()
    }
    /// <p>The version number of the database engine.</p>
    pub fn engine_version(&self) -> std::option::Option<&str> {
        self.engine_version.as_deref()
    }
    /// <p>The name of the DB parameter group family for the database engine.</p>
    pub fn db_parameter_group_family(&self) -> std::option::Option<&str> {
        self.db_parameter_group_family.as_deref()
    }
    /// <p>The description of the database engine.</p>
    pub fn db_engine_description(&self) -> std::option::Option<&str> {
        self.db_engine_description.as_deref()
    }
    /// <p>The description of the database engine version.</p>
    pub fn db_engine_version_description(&self) -> std::option::Option<&str> {
        self.db_engine_version_description.as_deref()
    }
    /// <p>
    /// The default character set for new instances of this engine version,
    /// if the <code>CharacterSetName</code> parameter of the CreateDBInstance API
    /// isn't specified.
    /// </p>
    pub fn default_character_set(&self) -> std::option::Option<&crate::model::CharacterSet> {
        self.default_character_set.as_ref()
    }
    /// <p>A list of the character sets supported by this engine for the <code>CharacterSetName</code> parameter of the <code>CreateDBInstance</code> operation.  
    /// </p>
    pub fn supported_character_sets(&self) -> std::option::Option<&[crate::model::CharacterSet]> {
        self.supported_character_sets.as_deref()
    }
    /// <p>A list of the character sets supported by the Oracle DB engine for the <code>NcharCharacterSetName</code> parameter of the <code>CreateDBInstance</code> operation.  
    /// </p>
    pub fn supported_nchar_character_sets(
        &self,
    ) -> std::option::Option<&[crate::model::CharacterSet]> {
        self.supported_nchar_character_sets.as_deref()
    }
    /// <p>A list of engine versions that this database engine version can be upgraded to.</p>
    pub fn valid_upgrade_target(&self) -> std::option::Option<&[crate::model::UpgradeTarget]> {
        self.valid_upgrade_target.as_deref()
    }
    /// <p>A list of the time zones supported by this engine for the
    /// <code>Timezone</code> parameter of the <code>CreateDBInstance</code> action.  
    /// </p>
    pub fn supported_timezones(&self) -> std::option::Option<&[crate::model::Timezone]> {
        self.supported_timezones.as_deref()
    }
    /// <p>The types of logs that the database engine has available for export to CloudWatch Logs.</p>
    pub fn exportable_log_types(&self) -> std::option::Option<&[std::string::String]> {
        self.exportable_log_types.as_deref()
    }
    /// <p>A value that indicates whether the engine version supports exporting the log types specified by ExportableLogTypes to CloudWatch Logs.</p>
    pub fn supports_log_exports_to_cloudwatch_logs(&self) -> bool {
        self.supports_log_exports_to_cloudwatch_logs
    }
    /// <p>Indicates whether the database engine version supports read replicas.</p>
    pub fn supports_read_replica(&self) -> bool {
        self.supports_read_replica
    }
    /// <p>A list of the supported DB engine modes.</p>
    pub fn supported_engine_modes(&self) -> std::option::Option<&[std::string::String]> {
        self.supported_engine_modes.as_deref()
    }
    /// <p>
    /// A list of features supported by the DB engine.
    /// </p>
    /// <p>The supported features vary by DB engine and DB engine version.</p>
    /// <p>To determine the supported features for a specific DB engine and DB engine version using the CLI,
    /// use the following command:</p>
    /// <p>
    /// <code>aws rds describe-db-engine-versions --engine <engine_name> --engine-version <engine_version></code>
    /// </p>
    /// <p>For example, to determine the supported features for RDS for PostgreSQL version 13.3 using the CLI,
    /// use the following command:</p>
    /// <p>
    /// <code>aws rds describe-db-engine-versions --engine postgres --engine-version 13.3</code>
    /// </p>
    /// <p>The supported features are listed under <code>SupportedFeatureNames</code> in the output.</p>
    pub fn supported_feature_names(&self) -> std::option::Option<&[std::string::String]> {
        self.supported_feature_names.as_deref()
    }
    /// <p>The status of the DB engine version, either <code>available</code> or <code>deprecated</code>.</p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>A value that indicates whether you can use Aurora parallel query with a specific DB engine version.</p>
    pub fn supports_parallel_query(&self) -> bool {
        self.supports_parallel_query
    }
    /// <p>A value that indicates whether you can use Aurora global databases with a specific DB engine version.</p>
    pub fn supports_global_databases(&self) -> bool {
        self.supports_global_databases
    }
    /// <p>The major engine version of the CEV.</p>
    pub fn major_engine_version(&self) -> std::option::Option<&str> {
        self.major_engine_version.as_deref()
    }
    /// <p>The name of the Amazon S3 bucket that contains your database installation files.</p>
    pub fn database_installation_files_s3_bucket_name(&self) -> std::option::Option<&str> {
        self.database_installation_files_s3_bucket_name.as_deref()
    }
    /// <p>The Amazon S3 directory that contains the database installation files.
    /// If not specified, then no prefix is assumed.</p>
    pub fn database_installation_files_s3_prefix(&self) -> std::option::Option<&str> {
        self.database_installation_files_s3_prefix.as_deref()
    }
    /// <p>The ARN of the custom engine version.</p>
    pub fn db_engine_version_arn(&self) -> std::option::Option<&str> {
        self.db_engine_version_arn.as_deref()
    }
    /// <p>The Amazon Web Services KMS key identifier for an encrypted CEV. This parameter is required for
    /// RDS Custom, but optional for Amazon RDS.</p>
    pub fn kms_key_id(&self) -> std::option::Option<&str> {
        self.kms_key_id.as_deref()
    }
    /// <p>The creation time of the DB engine version.</p>
    pub fn create_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.create_time.as_ref()
    }
    /// <p>A list of tags.
    /// For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources</a> in the <i>Amazon RDS User Guide.</i>           
    /// </p>
    pub fn tag_list(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tag_list.as_deref()
    }
}
impl std::fmt::Debug for ModifyCustomDbEngineVersionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModifyCustomDbEngineVersionOutput");
        formatter.field("engine", &self.engine);
        formatter.field("engine_version", &self.engine_version);
        formatter.field("db_parameter_group_family", &self.db_parameter_group_family);
        formatter.field("db_engine_description", &self.db_engine_description);
        formatter.field(
            "db_engine_version_description",
            &self.db_engine_version_description,
        );
        formatter.field("default_character_set", &self.default_character_set);
        formatter.field("supported_character_sets", &self.supported_character_sets);
        formatter.field(
            "supported_nchar_character_sets",
            &self.supported_nchar_character_sets,
        );
        formatter.field("valid_upgrade_target", &self.valid_upgrade_target);
        formatter.field("supported_timezones", &self.supported_timezones);
        formatter.field("exportable_log_types", &self.exportable_log_types);
        formatter.field(
            "supports_log_exports_to_cloudwatch_logs",
            &self.supports_log_exports_to_cloudwatch_logs,
        );
        formatter.field("supports_read_replica", &self.supports_read_replica);
        formatter.field("supported_engine_modes", &self.supported_engine_modes);
        formatter.field("supported_feature_names", &self.supported_feature_names);
        formatter.field("status", &self.status);
        formatter.field("supports_parallel_query", &self.supports_parallel_query);
        formatter.field("supports_global_databases", &self.supports_global_databases);
        formatter.field("major_engine_version", &self.major_engine_version);
        formatter.field(
            "database_installation_files_s3_bucket_name",
            &self.database_installation_files_s3_bucket_name,
        );
        formatter.field(
            "database_installation_files_s3_prefix",
            &self.database_installation_files_s3_prefix,
        );
        formatter.field("db_engine_version_arn", &self.db_engine_version_arn);
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.field("create_time", &self.create_time);
        formatter.field("tag_list", &self.tag_list);
        formatter.finish()
    }
}
/// See [`ModifyCustomDbEngineVersionOutput`](crate::output::ModifyCustomDbEngineVersionOutput)
pub mod modify_custom_db_engine_version_output {
    /// A builder for [`ModifyCustomDbEngineVersionOutput`](crate::output::ModifyCustomDbEngineVersionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) engine: std::option::Option<std::string::String>,
        pub(crate) engine_version: std::option::Option<std::string::String>,
        pub(crate) db_parameter_group_family: std::option::Option<std::string::String>,
        pub(crate) db_engine_description: std::option::Option<std::string::String>,
        pub(crate) db_engine_version_description: std::option::Option<std::string::String>,
        pub(crate) default_character_set: std::option::Option<crate::model::CharacterSet>,
        pub(crate) supported_character_sets:
            std::option::Option<std::vec::Vec<crate::model::CharacterSet>>,
        pub(crate) supported_nchar_character_sets:
            std::option::Option<std::vec::Vec<crate::model::CharacterSet>>,
        pub(crate) valid_upgrade_target:
            std::option::Option<std::vec::Vec<crate::model::UpgradeTarget>>,
        pub(crate) supported_timezones: std::option::Option<std::vec::Vec<crate::model::Timezone>>,
        pub(crate) exportable_log_types: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) supports_log_exports_to_cloudwatch_logs: std::option::Option<bool>,
        pub(crate) supports_read_replica: std::option::Option<bool>,
        pub(crate) supported_engine_modes: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) supported_feature_names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) supports_parallel_query: std::option::Option<bool>,
        pub(crate) supports_global_databases: std::option::Option<bool>,
        pub(crate) major_engine_version: std::option::Option<std::string::String>,
        pub(crate) database_installation_files_s3_bucket_name:
            std::option::Option<std::string::String>,
        pub(crate) database_installation_files_s3_prefix: std::option::Option<std::string::String>,
        pub(crate) db_engine_version_arn: std::option::Option<std::string::String>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
        pub(crate) create_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) tag_list: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of the database engine.</p>
        pub fn engine(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine = Some(input.into());
            self
        }
        /// <p>The name of the database engine.</p>
        pub fn set_engine(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.engine = input;
            self
        }
        /// <p>The version number of the database engine.</p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_version = Some(input.into());
            self
        }
        /// <p>The version number of the database engine.</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.engine_version = input;
            self
        }
        /// <p>The name of the DB parameter group family for the database engine.</p>
        pub fn db_parameter_group_family(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_parameter_group_family = Some(input.into());
            self
        }
        /// <p>The name of the DB parameter group family for the database engine.</p>
        pub fn set_db_parameter_group_family(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_parameter_group_family = input;
            self
        }
        /// <p>The description of the database engine.</p>
        pub fn db_engine_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_engine_description = Some(input.into());
            self
        }
        /// <p>The description of the database engine.</p>
        pub fn set_db_engine_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_engine_description = input;
            self
        }
        /// <p>The description of the database engine version.</p>
        pub fn db_engine_version_description(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.db_engine_version_description = Some(input.into());
            self
        }
        /// <p>The description of the database engine version.</p>
        pub fn set_db_engine_version_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_engine_version_description = input;
            self
        }
        /// <p>
        /// The default character set for new instances of this engine version,
        /// if the <code>CharacterSetName</code> parameter of the CreateDBInstance API
        /// isn't specified.
        /// </p>
        pub fn default_character_set(mut self, input: crate::model::CharacterSet) -> Self {
            self.default_character_set = Some(input);
            self
        }
        /// <p>
        /// The default character set for new instances of this engine version,
        /// if the <code>CharacterSetName</code> parameter of the CreateDBInstance API
        /// isn't specified.
        /// </p>
        pub fn set_default_character_set(
            mut self,
            input: std::option::Option<crate::model::CharacterSet>,
        ) -> Self {
            self.default_character_set = input;
            self
        }
        /// Appends an item to `supported_character_sets`.
        ///
        /// To override the contents of this collection use [`set_supported_character_sets`](Self::set_supported_character_sets).
        ///
        /// <p>A list of the character sets supported by this engine for the <code>CharacterSetName</code> parameter of the <code>CreateDBInstance</code> operation.  
        /// </p>
        pub fn supported_character_sets(
            mut self,
            input: impl Into<crate::model::CharacterSet>,
        ) -> Self {
            let mut v = self.supported_character_sets.unwrap_or_default();
            v.push(input.into());
            self.supported_character_sets = Some(v);
            self
        }
        /// <p>A list of the character sets supported by this engine for the <code>CharacterSetName</code> parameter of the <code>CreateDBInstance</code> operation.  
        /// </p>
        pub fn set_supported_character_sets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CharacterSet>>,
        ) -> Self {
            self.supported_character_sets = input;
            self
        }
        /// Appends an item to `supported_nchar_character_sets`.
        ///
        /// To override the contents of this collection use [`set_supported_nchar_character_sets`](Self::set_supported_nchar_character_sets).
        ///
        /// <p>A list of the character sets supported by the Oracle DB engine for the <code>NcharCharacterSetName</code> parameter of the <code>CreateDBInstance</code> operation.  
        /// </p>
        pub fn supported_nchar_character_sets(
            mut self,
            input: impl Into<crate::model::CharacterSet>,
        ) -> Self {
            let mut v = self.supported_nchar_character_sets.unwrap_or_default();
            v.push(input.into());
            self.supported_nchar_character_sets = Some(v);
            self
        }
        /// <p>A list of the character sets supported by the Oracle DB engine for the <code>NcharCharacterSetName</code> parameter of the <code>CreateDBInstance</code> operation.  
        /// </p>
        pub fn set_supported_nchar_character_sets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CharacterSet>>,
        ) -> Self {
            self.supported_nchar_character_sets = input;
            self
        }
        /// Appends an item to `valid_upgrade_target`.
        ///
        /// To override the contents of this collection use [`set_valid_upgrade_target`](Self::set_valid_upgrade_target).
        ///
        /// <p>A list of engine versions that this database engine version can be upgraded to.</p>
        pub fn valid_upgrade_target(
            mut self,
            input: impl Into<crate::model::UpgradeTarget>,
        ) -> Self {
            let mut v = self.valid_upgrade_target.unwrap_or_default();
            v.push(input.into());
            self.valid_upgrade_target = Some(v);
            self
        }
        /// <p>A list of engine versions that this database engine version can be upgraded to.</p>
        pub fn set_valid_upgrade_target(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UpgradeTarget>>,
        ) -> Self {
            self.valid_upgrade_target = input;
            self
        }
        /// Appends an item to `supported_timezones`.
        ///
        /// To override the contents of this collection use [`set_supported_timezones`](Self::set_supported_timezones).
        ///
        /// <p>A list of the time zones supported by this engine for the
        /// <code>Timezone</code> parameter of the <code>CreateDBInstance</code> action.  
        /// </p>
        pub fn supported_timezones(mut self, input: impl Into<crate::model::Timezone>) -> Self {
            let mut v = self.supported_timezones.unwrap_or_default();
            v.push(input.into());
            self.supported_timezones = Some(v);
            self
        }
        /// <p>A list of the time zones supported by this engine for the
        /// <code>Timezone</code> parameter of the <code>CreateDBInstance</code> action.  
        /// </p>
        pub fn set_supported_timezones(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Timezone>>,
        ) -> Self {
            self.supported_timezones = input;
            self
        }
        /// Appends an item to `exportable_log_types`.
        ///
        /// To override the contents of this collection use [`set_exportable_log_types`](Self::set_exportable_log_types).
        ///
        /// <p>The types of logs that the database engine has available for export to CloudWatch Logs.</p>
        pub fn exportable_log_types(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.exportable_log_types.unwrap_or_default();
            v.push(input.into());
            self.exportable_log_types = Some(v);
            self
        }
        /// <p>The types of logs that the database engine has available for export to CloudWatch Logs.</p>
        pub fn set_exportable_log_types(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.exportable_log_types = input;
            self
        }
        /// <p>A value that indicates whether the engine version supports exporting the log types specified by ExportableLogTypes to CloudWatch Logs.</p>
        pub fn supports_log_exports_to_cloudwatch_logs(mut self, input: bool) -> Self {
            self.supports_log_exports_to_cloudwatch_logs = Some(input);
            self
        }
        /// <p>A value that indicates whether the engine version supports exporting the log types specified by ExportableLogTypes to CloudWatch Logs.</p>
        pub fn set_supports_log_exports_to_cloudwatch_logs(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.supports_log_exports_to_cloudwatch_logs = input;
            self
        }
        /// <p>Indicates whether the database engine version supports read replicas.</p>
        pub fn supports_read_replica(mut self, input: bool) -> Self {
            self.supports_read_replica = Some(input);
            self
        }
        /// <p>Indicates whether the database engine version supports read replicas.</p>
        pub fn set_supports_read_replica(mut self, input: std::option::Option<bool>) -> Self {
            self.supports_read_replica = input;
            self
        }
        /// Appends an item to `supported_engine_modes`.
        ///
        /// To override the contents of this collection use [`set_supported_engine_modes`](Self::set_supported_engine_modes).
        ///
        /// <p>A list of the supported DB engine modes.</p>
        pub fn supported_engine_modes(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.supported_engine_modes.unwrap_or_default();
            v.push(input.into());
            self.supported_engine_modes = Some(v);
            self
        }
        /// <p>A list of the supported DB engine modes.</p>
        pub fn set_supported_engine_modes(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.supported_engine_modes = input;
            self
        }
        /// Appends an item to `supported_feature_names`.
        ///
        /// To override the contents of this collection use [`set_supported_feature_names`](Self::set_supported_feature_names).
        ///
        /// <p>
        /// A list of features supported by the DB engine.
        /// </p>
        /// <p>The supported features vary by DB engine and DB engine version.</p>
        /// <p>To determine the supported features for a specific DB engine and DB engine version using the CLI,
        /// use the following command:</p>
        /// <p>
        /// <code>aws rds describe-db-engine-versions --engine <engine_name> --engine-version <engine_version></code>
        /// </p>
        /// <p>For example, to determine the supported features for RDS for PostgreSQL version 13.3 using the CLI,
        /// use the following command:</p>
        /// <p>
        /// <code>aws rds describe-db-engine-versions --engine postgres --engine-version 13.3</code>
        /// </p>
        /// <p>The supported features are listed under <code>SupportedFeatureNames</code> in the output.</p>
        pub fn supported_feature_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.supported_feature_names.unwrap_or_default();
            v.push(input.into());
            self.supported_feature_names = Some(v);
            self
        }
        /// <p>
        /// A list of features supported by the DB engine.
        /// </p>
        /// <p>The supported features vary by DB engine and DB engine version.</p>
        /// <p>To determine the supported features for a specific DB engine and DB engine version using the CLI,
        /// use the following command:</p>
        /// <p>
        /// <code>aws rds describe-db-engine-versions --engine <engine_name> --engine-version <engine_version></code>
        /// </p>
        /// <p>For example, to determine the supported features for RDS for PostgreSQL version 13.3 using the CLI,
        /// use the following command:</p>
        /// <p>
        /// <code>aws rds describe-db-engine-versions --engine postgres --engine-version 13.3</code>
        /// </p>
        /// <p>The supported features are listed under <code>SupportedFeatureNames</code> in the output.</p>
        pub fn set_supported_feature_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.supported_feature_names = input;
            self
        }
        /// <p>The status of the DB engine version, either <code>available</code> or <code>deprecated</code>.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the DB engine version, either <code>available</code> or <code>deprecated</code>.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>A value that indicates whether you can use Aurora parallel query with a specific DB engine version.</p>
        pub fn supports_parallel_query(mut self, input: bool) -> Self {
            self.supports_parallel_query = Some(input);
            self
        }
        /// <p>A value that indicates whether you can use Aurora parallel query with a specific DB engine version.</p>
        pub fn set_supports_parallel_query(mut self, input: std::option::Option<bool>) -> Self {
            self.supports_parallel_query = input;
            self
        }
        /// <p>A value that indicates whether you can use Aurora global databases with a specific DB engine version.</p>
        pub fn supports_global_databases(mut self, input: bool) -> Self {
            self.supports_global_databases = Some(input);
            self
        }
        /// <p>A value that indicates whether you can use Aurora global databases with a specific DB engine version.</p>
        pub fn set_supports_global_databases(mut self, input: std::option::Option<bool>) -> Self {
            self.supports_global_databases = input;
            self
        }
        /// <p>The major engine version of the CEV.</p>
        pub fn major_engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.major_engine_version = Some(input.into());
            self
        }
        /// <p>The major engine version of the CEV.</p>
        pub fn set_major_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.major_engine_version = input;
            self
        }
        /// <p>The name of the Amazon S3 bucket that contains your database installation files.</p>
        pub fn database_installation_files_s3_bucket_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.database_installation_files_s3_bucket_name = Some(input.into());
            self
        }
        /// <p>The name of the Amazon S3 bucket that contains your database installation files.</p>
        pub fn set_database_installation_files_s3_bucket_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.database_installation_files_s3_bucket_name = input;
            self
        }
        /// <p>The Amazon S3 directory that contains the database installation files.
        /// If not specified, then no prefix is assumed.</p>
        pub fn database_installation_files_s3_prefix(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.database_installation_files_s3_prefix = Some(input.into());
            self
        }
        /// <p>The Amazon S3 directory that contains the database installation files.
        /// If not specified, then no prefix is assumed.</p>
        pub fn set_database_installation_files_s3_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.database_installation_files_s3_prefix = input;
            self
        }
        /// <p>The ARN of the custom engine version.</p>
        pub fn db_engine_version_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_engine_version_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the custom engine version.</p>
        pub fn set_db_engine_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_engine_version_arn = input;
            self
        }
        /// <p>The Amazon Web Services KMS key identifier for an encrypted CEV. This parameter is required for
        /// RDS Custom, but optional for Amazon RDS.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services KMS key identifier for an encrypted CEV. This parameter is required for
        /// RDS Custom, but optional for Amazon RDS.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// <p>The creation time of the DB engine version.</p>
        pub fn create_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.create_time = Some(input);
            self
        }
        /// <p>The creation time of the DB engine version.</p>
        pub fn set_create_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.create_time = input;
            self
        }
        /// Appends an item to `tag_list`.
        ///
        /// To override the contents of this collection use [`set_tag_list`](Self::set_tag_list).
        ///
        /// <p>A list of tags.
        /// For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources</a> in the <i>Amazon RDS User Guide.</i>           
        /// </p>
        pub fn tag_list(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tag_list.unwrap_or_default();
            v.push(input.into());
            self.tag_list = Some(v);
            self
        }
        /// <p>A list of tags.
        /// For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources</a> in the <i>Amazon RDS User Guide.</i>           
        /// </p>
        pub fn set_tag_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tag_list = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyCustomDbEngineVersionOutput`](crate::output::ModifyCustomDbEngineVersionOutput)
        pub fn build(self) -> crate::output::ModifyCustomDbEngineVersionOutput {
            crate::output::ModifyCustomDbEngineVersionOutput {
                engine: self.engine,
                engine_version: self.engine_version,
                db_parameter_group_family: self.db_parameter_group_family,
                db_engine_description: self.db_engine_description,
                db_engine_version_description: self.db_engine_version_description,
                default_character_set: self.default_character_set,
                supported_character_sets: self.supported_character_sets,
                supported_nchar_character_sets: self.supported_nchar_character_sets,
                valid_upgrade_target: self.valid_upgrade_target,
                supported_timezones: self.supported_timezones,
                exportable_log_types: self.exportable_log_types,
                supports_log_exports_to_cloudwatch_logs: self
                    .supports_log_exports_to_cloudwatch_logs
                    .unwrap_or_default(),
                supports_read_replica: self.supports_read_replica.unwrap_or_default(),
                supported_engine_modes: self.supported_engine_modes,
                supported_feature_names: self.supported_feature_names,
                status: self.status,
                supports_parallel_query: self.supports_parallel_query.unwrap_or_default(),
                supports_global_databases: self.supports_global_databases.unwrap_or_default(),
                major_engine_version: self.major_engine_version,
                database_installation_files_s3_bucket_name: self
                    .database_installation_files_s3_bucket_name,
                database_installation_files_s3_prefix: self.database_installation_files_s3_prefix,
                db_engine_version_arn: self.db_engine_version_arn,
                kms_key_id: self.kms_key_id,
                create_time: self.create_time,
                tag_list: self.tag_list,
            }
        }
    }
}
impl ModifyCustomDbEngineVersionOutput {
    /// Creates a new builder-style object to manufacture [`ModifyCustomDbEngineVersionOutput`](crate::output::ModifyCustomDbEngineVersionOutput)
    pub fn builder() -> crate::output::modify_custom_db_engine_version_output::Builder {
        crate::output::modify_custom_db_engine_version_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModifyCurrentDbClusterCapacityOutput {
    /// <p>A user-supplied DB cluster identifier. This identifier is the unique key that
    /// identifies a DB cluster. </p>
    pub db_cluster_identifier: std::option::Option<std::string::String>,
    /// <p>A value that specifies the capacity that the DB cluster scales to next.</p>
    pub pending_capacity: std::option::Option<i32>,
    /// <p>The current capacity of the DB cluster.</p>
    pub current_capacity: std::option::Option<i32>,
    /// <p>The number of seconds before a call to <code>ModifyCurrentDBClusterCapacity</code> times out.</p>
    pub seconds_before_timeout: std::option::Option<i32>,
    /// <p>The timeout action of a call to <code>ModifyCurrentDBClusterCapacity</code>, either
    /// <code>ForceApplyCapacityChange</code> or <code>RollbackCapacityChange</code>.</p>
    pub timeout_action: std::option::Option<std::string::String>,
}
impl ModifyCurrentDbClusterCapacityOutput {
    /// <p>A user-supplied DB cluster identifier. This identifier is the unique key that
    /// identifies a DB cluster. </p>
    pub fn db_cluster_identifier(&self) -> std::option::Option<&str> {
        self.db_cluster_identifier.as_deref()
    }
    /// <p>A value that specifies the capacity that the DB cluster scales to next.</p>
    pub fn pending_capacity(&self) -> std::option::Option<i32> {
        self.pending_capacity
    }
    /// <p>The current capacity of the DB cluster.</p>
    pub fn current_capacity(&self) -> std::option::Option<i32> {
        self.current_capacity
    }
    /// <p>The number of seconds before a call to <code>ModifyCurrentDBClusterCapacity</code> times out.</p>
    pub fn seconds_before_timeout(&self) -> std::option::Option<i32> {
        self.seconds_before_timeout
    }
    /// <p>The timeout action of a call to <code>ModifyCurrentDBClusterCapacity</code>, either
    /// <code>ForceApplyCapacityChange</code> or <code>RollbackCapacityChange</code>.</p>
    pub fn timeout_action(&self) -> std::option::Option<&str> {
        self.timeout_action.as_deref()
    }
}
impl std::fmt::Debug for ModifyCurrentDbClusterCapacityOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModifyCurrentDbClusterCapacityOutput");
        formatter.field("db_cluster_identifier", &self.db_cluster_identifier);
        formatter.field("pending_capacity", &self.pending_capacity);
        formatter.field("current_capacity", &self.current_capacity);
        formatter.field("seconds_before_timeout", &self.seconds_before_timeout);
        formatter.field("timeout_action", &self.timeout_action);
        formatter.finish()
    }
}
/// See [`ModifyCurrentDbClusterCapacityOutput`](crate::output::ModifyCurrentDbClusterCapacityOutput)
pub mod modify_current_db_cluster_capacity_output {
    /// A builder for [`ModifyCurrentDbClusterCapacityOutput`](crate::output::ModifyCurrentDbClusterCapacityOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) pending_capacity: std::option::Option<i32>,
        pub(crate) current_capacity: std::option::Option<i32>,
        pub(crate) seconds_before_timeout: std::option::Option<i32>,
        pub(crate) timeout_action: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A user-supplied DB cluster identifier. This identifier is the unique key that
        /// identifies a DB cluster. </p>
        pub fn db_cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_cluster_identifier = Some(input.into());
            self
        }
        /// <p>A user-supplied DB cluster identifier. This identifier is the unique key that
        /// identifies a DB cluster. </p>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_identifier = input;
            self
        }
        /// <p>A value that specifies the capacity that the DB cluster scales to next.</p>
        pub fn pending_capacity(mut self, input: i32) -> Self {
            self.pending_capacity = Some(input);
            self
        }
        /// <p>A value that specifies the capacity that the DB cluster scales to next.</p>
        pub fn set_pending_capacity(mut self, input: std::option::Option<i32>) -> Self {
            self.pending_capacity = input;
            self
        }
        /// <p>The current capacity of the DB cluster.</p>
        pub fn current_capacity(mut self, input: i32) -> Self {
            self.current_capacity = Some(input);
            self
        }
        /// <p>The current capacity of the DB cluster.</p>
        pub fn set_current_capacity(mut self, input: std::option::Option<i32>) -> Self {
            self.current_capacity = input;
            self
        }
        /// <p>The number of seconds before a call to <code>ModifyCurrentDBClusterCapacity</code> times out.</p>
        pub fn seconds_before_timeout(mut self, input: i32) -> Self {
            self.seconds_before_timeout = Some(input);
            self
        }
        /// <p>The number of seconds before a call to <code>ModifyCurrentDBClusterCapacity</code> times out.</p>
        pub fn set_seconds_before_timeout(mut self, input: std::option::Option<i32>) -> Self {
            self.seconds_before_timeout = input;
            self
        }
        /// <p>The timeout action of a call to <code>ModifyCurrentDBClusterCapacity</code>, either
        /// <code>ForceApplyCapacityChange</code> or <code>RollbackCapacityChange</code>.</p>
        pub fn timeout_action(mut self, input: impl Into<std::string::String>) -> Self {
            self.timeout_action = Some(input.into());
            self
        }
        /// <p>The timeout action of a call to <code>ModifyCurrentDBClusterCapacity</code>, either
        /// <code>ForceApplyCapacityChange</code> or <code>RollbackCapacityChange</code>.</p>
        pub fn set_timeout_action(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.timeout_action = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyCurrentDbClusterCapacityOutput`](crate::output::ModifyCurrentDbClusterCapacityOutput)
        pub fn build(self) -> crate::output::ModifyCurrentDbClusterCapacityOutput {
            crate::output::ModifyCurrentDbClusterCapacityOutput {
                db_cluster_identifier: self.db_cluster_identifier,
                pending_capacity: self.pending_capacity,
                current_capacity: self.current_capacity,
                seconds_before_timeout: self.seconds_before_timeout,
                timeout_action: self.timeout_action,
            }
        }
    }
}
impl ModifyCurrentDbClusterCapacityOutput {
    /// Creates a new builder-style object to manufacture [`ModifyCurrentDbClusterCapacityOutput`](crate::output::ModifyCurrentDbClusterCapacityOutput)
    pub fn builder() -> crate::output::modify_current_db_cluster_capacity_output::Builder {
        crate::output::modify_current_db_cluster_capacity_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ModifyCertificatesOutput {
    /// <p>A CA certificate for an Amazon Web Services account.</p>
    pub certificate: std::option::Option<crate::model::Certificate>,
}
impl ModifyCertificatesOutput {
    /// <p>A CA certificate for an Amazon Web Services account.</p>
    pub fn certificate(&self) -> std::option::Option<&crate::model::Certificate> {
        self.certificate.as_ref()
    }
}
impl std::fmt::Debug for ModifyCertificatesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ModifyCertificatesOutput");
        formatter.field("certificate", &self.certificate);
        formatter.finish()
    }
}
/// See [`ModifyCertificatesOutput`](crate::output::ModifyCertificatesOutput)
pub mod modify_certificates_output {
    /// A builder for [`ModifyCertificatesOutput`](crate::output::ModifyCertificatesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) certificate: std::option::Option<crate::model::Certificate>,
    }
    impl Builder {
        /// <p>A CA certificate for an Amazon Web Services account.</p>
        pub fn certificate(mut self, input: crate::model::Certificate) -> Self {
            self.certificate = Some(input);
            self
        }
        /// <p>A CA certificate for an Amazon Web Services account.</p>
        pub fn set_certificate(
            mut self,
            input: std::option::Option<crate::model::Certificate>,
        ) -> Self {
            self.certificate = input;
            self
        }
        /// Consumes the builder and constructs a [`ModifyCertificatesOutput`](crate::output::ModifyCertificatesOutput)
        pub fn build(self) -> crate::output::ModifyCertificatesOutput {
            crate::output::ModifyCertificatesOutput {
                certificate: self.certificate,
            }
        }
    }
}
impl ModifyCertificatesOutput {
    /// Creates a new builder-style object to manufacture [`ModifyCertificatesOutput`](crate::output::ModifyCertificatesOutput)
    pub fn builder() -> crate::output::modify_certificates_output::Builder {
        crate::output::modify_certificates_output::Builder::default()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceOutput {
    /// <p>List of tags returned by the ListTagsForResource operation.</p>
    pub tag_list: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl ListTagsForResourceOutput {
    /// <p>List of tags returned by the ListTagsForResource operation.</p>
    pub fn tag_list(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tag_list.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceOutput");
        formatter.field("tag_list", &self.tag_list);
        formatter.finish()
    }
}
/// See [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
pub mod list_tags_for_resource_output {
    /// A builder for [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tag_list: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// Appends an item to `tag_list`.
        ///
        /// To override the contents of this collection use [`set_tag_list`](Self::set_tag_list).
        ///
        /// <p>List of tags returned by the ListTagsForResource operation.</p>
        pub fn tag_list(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tag_list.unwrap_or_default();
            v.push(input.into());
            self.tag_list = Some(v);
            self
        }
        /// <p>List of tags returned by the ListTagsForResource operation.</p>
        pub fn set_tag_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tag_list = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
        pub fn build(self) -> crate::output::ListTagsForResourceOutput {
            crate::output::ListTagsForResourceOutput {
                tag_list: self.tag_list,
            }
        }
    }
}
impl ListTagsForResourceOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    pub fn builder() -> crate::output::list_tags_for_resource_output::Builder {
        crate::output::list_tags_for_resource_output::Builder::default()
    }
}

/// <p>Contains the installation media for a DB engine that requires an on-premises
/// customer provided license, such as Microsoft SQL Server.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ImportInstallationMediaOutput {
    /// <p>The installation medium ID.</p>
    pub installation_media_id: std::option::Option<std::string::String>,
    /// <p>The custom Availability Zone (AZ) that contains the installation media.</p>
    pub custom_availability_zone_id: std::option::Option<std::string::String>,
    /// <p>The DB engine.</p>
    pub engine: std::option::Option<std::string::String>,
    /// <p>The engine version of the DB engine.</p>
    pub engine_version: std::option::Option<std::string::String>,
    /// <p>The path to the installation medium for the DB engine.</p>
    pub engine_installation_media_path: std::option::Option<std::string::String>,
    /// <p>The path to the installation medium for the operating system associated with the DB engine.</p>
    pub os_installation_media_path: std::option::Option<std::string::String>,
    /// <p>The status of the installation medium.</p>
    pub status: std::option::Option<std::string::String>,
    /// <p>If an installation media failure occurred, the cause of the failure.</p>
    pub failure_cause: std::option::Option<crate::model::InstallationMediaFailureCause>,
}
impl ImportInstallationMediaOutput {
    /// <p>The installation medium ID.</p>
    pub fn installation_media_id(&self) -> std::option::Option<&str> {
        self.installation_media_id.as_deref()
    }
    /// <p>The custom Availability Zone (AZ) that contains the installation media.</p>
    pub fn custom_availability_zone_id(&self) -> std::option::Option<&str> {
        self.custom_availability_zone_id.as_deref()
    }
    /// <p>The DB engine.</p>
    pub fn engine(&self) -> std::option::Option<&str> {
        self.engine.as_deref()
    }
    /// <p>The engine version of the DB engine.</p>
    pub fn engine_version(&self) -> std::option::Option<&str> {
        self.engine_version.as_deref()
    }
    /// <p>The path to the installation medium for the DB engine.</p>
    pub fn engine_installation_media_path(&self) -> std::option::Option<&str> {
        self.engine_installation_media_path.as_deref()
    }
    /// <p>The path to the installation medium for the operating system associated with the DB engine.</p>
    pub fn os_installation_media_path(&self) -> std::option::Option<&str> {
        self.os_installation_media_path.as_deref()
    }
    /// <p>The status of the installation medium.</p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>If an installation media failure occurred, the cause of the failure.</p>
    pub fn failure_cause(
        &self,
    ) -> std::option::Option<&crate::model::InstallationMediaFailureCause> {
        self.failure_cause.as_ref()
    }
}
impl std::fmt::Debug for ImportInstallationMediaOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ImportInstallationMediaOutput");
        formatter.field("installation_media_id", &self.installation_media_id);
        formatter.field(
            "custom_availability_zone_id",
            &self.custom_availability_zone_id,
        );
        formatter.field("engine", &self.engine);
        formatter.field("engine_version", &self.engine_version);
        formatter.field(
            "engine_installation_media_path",
            &self.engine_installation_media_path,
        );
        formatter.field(
            "os_installation_media_path",
            &self.os_installation_media_path,
        );
        formatter.field("status", &self.status);
        formatter.field("failure_cause", &self.failure_cause);
        formatter.finish()
    }
}
/// See [`ImportInstallationMediaOutput`](crate::output::ImportInstallationMediaOutput)
pub mod import_installation_media_output {
    /// A builder for [`ImportInstallationMediaOutput`](crate::output::ImportInstallationMediaOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) installation_media_id: std::option::Option<std::string::String>,
        pub(crate) custom_availability_zone_id: std::option::Option<std::string::String>,
        pub(crate) engine: std::option::Option<std::string::String>,
        pub(crate) engine_version: std::option::Option<std::string::String>,
        pub(crate) engine_installation_media_path: std::option::Option<std::string::String>,
        pub(crate) os_installation_media_path: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) failure_cause: std::option::Option<crate::model::InstallationMediaFailureCause>,
    }
    impl Builder {
        /// <p>The installation medium ID.</p>
        pub fn installation_media_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.installation_media_id = Some(input.into());
            self
        }
        /// <p>The installation medium ID.</p>
        pub fn set_installation_media_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.installation_media_id = input;
            self
        }
        /// <p>The custom Availability Zone (AZ) that contains the installation media.</p>
        pub fn custom_availability_zone_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.custom_availability_zone_id = Some(input.into());
            self
        }
        /// <p>The custom Availability Zone (AZ) that contains the installation media.</p>
        pub fn set_custom_availability_zone_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.custom_availability_zone_id = input;
            self
        }
        /// <p>The DB engine.</p>
        pub fn engine(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine = Some(input.into());
            self
        }
        /// <p>The DB engine.</p>
        pub fn set_engine(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.engine = input;
            self
        }
        /// <p>The engine version of the DB engine.</p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_version = Some(input.into());
            self
        }
        /// <p>The engine version of the DB engine.</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.engine_version = input;
            self
        }
        /// <p>The path to the installation medium for the DB engine.</p>
        pub fn engine_installation_media_path(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.engine_installation_media_path = Some(input.into());
            self
        }
        /// <p>The path to the installation medium for the DB engine.</p>
        pub fn set_engine_installation_media_path(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.engine_installation_media_path = input;
            self
        }
        /// <p>The path to the installation medium for the operating system associated with the DB engine.</p>
        pub fn os_installation_media_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.os_installation_media_path = Some(input.into());
            self
        }
        /// <p>The path to the installation medium for the operating system associated with the DB engine.</p>
        pub fn set_os_installation_media_path(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.os_installation_media_path = input;
            self
        }
        /// <p>The status of the installation medium.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the installation medium.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>If an installation media failure occurred, the cause of the failure.</p>
        pub fn failure_cause(mut self, input: crate::model::InstallationMediaFailureCause) -> Self {
            self.failure_cause = Some(input);
            self
        }
        /// <p>If an installation media failure occurred, the cause of the failure.</p>
        pub fn set_failure_cause(
            mut self,
            input: std::option::Option<crate::model::InstallationMediaFailureCause>,
        ) -> Self {
            self.failure_cause = input;
            self
        }
        /// Consumes the builder and constructs a [`ImportInstallationMediaOutput`](crate::output::ImportInstallationMediaOutput)
        pub fn build(self) -> crate::output::ImportInstallationMediaOutput {
            crate::output::ImportInstallationMediaOutput {
                installation_media_id: self.installation_media_id,
                custom_availability_zone_id: self.custom_availability_zone_id,
                engine: self.engine,
                engine_version: self.engine_version,
                engine_installation_media_path: self.engine_installation_media_path,
                os_installation_media_path: self.os_installation_media_path,
                status: self.status,
                failure_cause: self.failure_cause,
            }
        }
    }
}
impl ImportInstallationMediaOutput {
    /// Creates a new builder-style object to manufacture [`ImportInstallationMediaOutput`](crate::output::ImportInstallationMediaOutput)
    pub fn builder() -> crate::output::import_installation_media_output::Builder {
        crate::output::import_installation_media_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FailoverGlobalClusterOutput {
    /// <p>A data type representing an Aurora global database.</p>
    pub global_cluster: std::option::Option<crate::model::GlobalCluster>,
}
impl FailoverGlobalClusterOutput {
    /// <p>A data type representing an Aurora global database.</p>
    pub fn global_cluster(&self) -> std::option::Option<&crate::model::GlobalCluster> {
        self.global_cluster.as_ref()
    }
}
impl std::fmt::Debug for FailoverGlobalClusterOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FailoverGlobalClusterOutput");
        formatter.field("global_cluster", &self.global_cluster);
        formatter.finish()
    }
}
/// See [`FailoverGlobalClusterOutput`](crate::output::FailoverGlobalClusterOutput)
pub mod failover_global_cluster_output {
    /// A builder for [`FailoverGlobalClusterOutput`](crate::output::FailoverGlobalClusterOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) global_cluster: std::option::Option<crate::model::GlobalCluster>,
    }
    impl Builder {
        /// <p>A data type representing an Aurora global database.</p>
        pub fn global_cluster(mut self, input: crate::model::GlobalCluster) -> Self {
            self.global_cluster = Some(input);
            self
        }
        /// <p>A data type representing an Aurora global database.</p>
        pub fn set_global_cluster(
            mut self,
            input: std::option::Option<crate::model::GlobalCluster>,
        ) -> Self {
            self.global_cluster = input;
            self
        }
        /// Consumes the builder and constructs a [`FailoverGlobalClusterOutput`](crate::output::FailoverGlobalClusterOutput)
        pub fn build(self) -> crate::output::FailoverGlobalClusterOutput {
            crate::output::FailoverGlobalClusterOutput {
                global_cluster: self.global_cluster,
            }
        }
    }
}
impl FailoverGlobalClusterOutput {
    /// Creates a new builder-style object to manufacture [`FailoverGlobalClusterOutput`](crate::output::FailoverGlobalClusterOutput)
    pub fn builder() -> crate::output::failover_global_cluster_output::Builder {
        crate::output::failover_global_cluster_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FailoverDbClusterOutput {
    /// <p>Contains the details of an Amazon Aurora DB cluster.
    /// </p>
    /// <p>This data type is used as a response element in the <code>DescribeDBClusters</code>,
    /// <code>StopDBCluster</code>, and <code>StartDBCluster</code> actions.
    /// </p>
    pub db_cluster: std::option::Option<crate::model::DbCluster>,
}
impl FailoverDbClusterOutput {
    /// <p>Contains the details of an Amazon Aurora DB cluster.
    /// </p>
    /// <p>This data type is used as a response element in the <code>DescribeDBClusters</code>,
    /// <code>StopDBCluster</code>, and <code>StartDBCluster</code> actions.
    /// </p>
    pub fn db_cluster(&self) -> std::option::Option<&crate::model::DbCluster> {
        self.db_cluster.as_ref()
    }
}
impl std::fmt::Debug for FailoverDbClusterOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FailoverDbClusterOutput");
        formatter.field("db_cluster", &self.db_cluster);
        formatter.finish()
    }
}
/// See [`FailoverDbClusterOutput`](crate::output::FailoverDbClusterOutput)
pub mod failover_db_cluster_output {
    /// A builder for [`FailoverDbClusterOutput`](crate::output::FailoverDbClusterOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster: std::option::Option<crate::model::DbCluster>,
    }
    impl Builder {
        /// <p>Contains the details of an Amazon Aurora DB cluster.
        /// </p>
        /// <p>This data type is used as a response element in the <code>DescribeDBClusters</code>,
        /// <code>StopDBCluster</code>, and <code>StartDBCluster</code> actions.
        /// </p>
        pub fn db_cluster(mut self, input: crate::model::DbCluster) -> Self {
            self.db_cluster = Some(input);
            self
        }
        /// <p>Contains the details of an Amazon Aurora DB cluster.
        /// </p>
        /// <p>This data type is used as a response element in the <code>DescribeDBClusters</code>,
        /// <code>StopDBCluster</code>, and <code>StartDBCluster</code> actions.
        /// </p>
        pub fn set_db_cluster(
            mut self,
            input: std::option::Option<crate::model::DbCluster>,
        ) -> Self {
            self.db_cluster = input;
            self
        }
        /// Consumes the builder and constructs a [`FailoverDbClusterOutput`](crate::output::FailoverDbClusterOutput)
        pub fn build(self) -> crate::output::FailoverDbClusterOutput {
            crate::output::FailoverDbClusterOutput {
                db_cluster: self.db_cluster,
            }
        }
    }
}
impl FailoverDbClusterOutput {
    /// Creates a new builder-style object to manufacture [`FailoverDbClusterOutput`](crate::output::FailoverDbClusterOutput)
    pub fn builder() -> crate::output::failover_db_cluster_output::Builder {
        crate::output::failover_db_cluster_output::Builder::default()
    }
}

/// <p>This data type is used as a response element to <code>DownloadDBLogFilePortion</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DownloadDbLogFilePortionOutput {
    /// <p>Entries from the specified log file.</p>
    pub log_file_data: std::option::Option<std::string::String>,
    /// <p>A pagination token that can be used in a later DownloadDBLogFilePortion request.</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>Boolean value that if true, indicates there is more data to be downloaded.</p>
    pub additional_data_pending: bool,
}
impl DownloadDbLogFilePortionOutput {
    /// <p>Entries from the specified log file.</p>
    pub fn log_file_data(&self) -> std::option::Option<&str> {
        self.log_file_data.as_deref()
    }
    /// <p>A pagination token that can be used in a later DownloadDBLogFilePortion request.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>Boolean value that if true, indicates there is more data to be downloaded.</p>
    pub fn additional_data_pending(&self) -> bool {
        self.additional_data_pending
    }
}
impl std::fmt::Debug for DownloadDbLogFilePortionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DownloadDbLogFilePortionOutput");
        formatter.field("log_file_data", &self.log_file_data);
        formatter.field("marker", &self.marker);
        formatter.field("additional_data_pending", &self.additional_data_pending);
        formatter.finish()
    }
}
/// See [`DownloadDbLogFilePortionOutput`](crate::output::DownloadDbLogFilePortionOutput)
pub mod download_db_log_file_portion_output {
    /// A builder for [`DownloadDbLogFilePortionOutput`](crate::output::DownloadDbLogFilePortionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) log_file_data: std::option::Option<std::string::String>,
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) additional_data_pending: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Entries from the specified log file.</p>
        pub fn log_file_data(mut self, input: impl Into<std::string::String>) -> Self {
            self.log_file_data = Some(input.into());
            self
        }
        /// <p>Entries from the specified log file.</p>
        pub fn set_log_file_data(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.log_file_data = input;
            self
        }
        /// <p>A pagination token that can be used in a later DownloadDBLogFilePortion request.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>A pagination token that can be used in a later DownloadDBLogFilePortion request.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// <p>Boolean value that if true, indicates there is more data to be downloaded.</p>
        pub fn additional_data_pending(mut self, input: bool) -> Self {
            self.additional_data_pending = Some(input);
            self
        }
        /// <p>Boolean value that if true, indicates there is more data to be downloaded.</p>
        pub fn set_additional_data_pending(mut self, input: std::option::Option<bool>) -> Self {
            self.additional_data_pending = input;
            self
        }
        /// Consumes the builder and constructs a [`DownloadDbLogFilePortionOutput`](crate::output::DownloadDbLogFilePortionOutput)
        pub fn build(self) -> crate::output::DownloadDbLogFilePortionOutput {
            crate::output::DownloadDbLogFilePortionOutput {
                log_file_data: self.log_file_data,
                marker: self.marker,
                additional_data_pending: self.additional_data_pending.unwrap_or_default(),
            }
        }
    }
}
impl DownloadDbLogFilePortionOutput {
    /// Creates a new builder-style object to manufacture [`DownloadDbLogFilePortionOutput`](crate::output::DownloadDbLogFilePortionOutput)
    pub fn builder() -> crate::output::download_db_log_file_portion_output::Builder {
        crate::output::download_db_log_file_portion_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeValidDbInstanceModificationsOutput {
    /// <p>Information about valid modifications that you can make to your DB instance.
    /// Contains the result of a successful call to the
    /// <code>DescribeValidDBInstanceModifications</code> action.
    /// You can use this information when you call
    /// <code>ModifyDBInstance</code>.
    /// </p>
    pub valid_db_instance_modifications_message:
        std::option::Option<crate::model::ValidDbInstanceModificationsMessage>,
}
impl DescribeValidDbInstanceModificationsOutput {
    /// <p>Information about valid modifications that you can make to your DB instance.
    /// Contains the result of a successful call to the
    /// <code>DescribeValidDBInstanceModifications</code> action.
    /// You can use this information when you call
    /// <code>ModifyDBInstance</code>.
    /// </p>
    pub fn valid_db_instance_modifications_message(
        &self,
    ) -> std::option::Option<&crate::model::ValidDbInstanceModificationsMessage> {
        self.valid_db_instance_modifications_message.as_ref()
    }
}
impl std::fmt::Debug for DescribeValidDbInstanceModificationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeValidDbInstanceModificationsOutput");
        formatter.field(
            "valid_db_instance_modifications_message",
            &self.valid_db_instance_modifications_message,
        );
        formatter.finish()
    }
}
/// See [`DescribeValidDbInstanceModificationsOutput`](crate::output::DescribeValidDbInstanceModificationsOutput)
pub mod describe_valid_db_instance_modifications_output {
    /// A builder for [`DescribeValidDbInstanceModificationsOutput`](crate::output::DescribeValidDbInstanceModificationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) valid_db_instance_modifications_message:
            std::option::Option<crate::model::ValidDbInstanceModificationsMessage>,
    }
    impl Builder {
        /// <p>Information about valid modifications that you can make to your DB instance.
        /// Contains the result of a successful call to the
        /// <code>DescribeValidDBInstanceModifications</code> action.
        /// You can use this information when you call
        /// <code>ModifyDBInstance</code>.
        /// </p>
        pub fn valid_db_instance_modifications_message(
            mut self,
            input: crate::model::ValidDbInstanceModificationsMessage,
        ) -> Self {
            self.valid_db_instance_modifications_message = Some(input);
            self
        }
        /// <p>Information about valid modifications that you can make to your DB instance.
        /// Contains the result of a successful call to the
        /// <code>DescribeValidDBInstanceModifications</code> action.
        /// You can use this information when you call
        /// <code>ModifyDBInstance</code>.
        /// </p>
        pub fn set_valid_db_instance_modifications_message(
            mut self,
            input: std::option::Option<crate::model::ValidDbInstanceModificationsMessage>,
        ) -> Self {
            self.valid_db_instance_modifications_message = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeValidDbInstanceModificationsOutput`](crate::output::DescribeValidDbInstanceModificationsOutput)
        pub fn build(self) -> crate::output::DescribeValidDbInstanceModificationsOutput {
            crate::output::DescribeValidDbInstanceModificationsOutput {
                valid_db_instance_modifications_message: self
                    .valid_db_instance_modifications_message,
            }
        }
    }
}
impl DescribeValidDbInstanceModificationsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeValidDbInstanceModificationsOutput`](crate::output::DescribeValidDbInstanceModificationsOutput)
    pub fn builder() -> crate::output::describe_valid_db_instance_modifications_output::Builder {
        crate::output::describe_valid_db_instance_modifications_output::Builder::default()
    }
}

/// <p>Contains the result of a successful invocation of the <code>DescribeSourceRegions</code> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeSourceRegionsOutput {
    /// <p>
    /// An optional pagination token provided by a previous request.
    /// If this parameter is specified, the response includes
    /// only records beyond the marker,
    /// up to the value specified by <code>MaxRecords</code>.
    /// </p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>A list of SourceRegion instances that contains each source Amazon Web Services Region that the
    /// current Amazon Web Services Region can get a read replica or a DB snapshot from.</p>
    pub source_regions: std::option::Option<std::vec::Vec<crate::model::SourceRegion>>,
}
impl DescribeSourceRegionsOutput {
    /// <p>
    /// An optional pagination token provided by a previous request.
    /// If this parameter is specified, the response includes
    /// only records beyond the marker,
    /// up to the value specified by <code>MaxRecords</code>.
    /// </p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>A list of SourceRegion instances that contains each source Amazon Web Services Region that the
    /// current Amazon Web Services Region can get a read replica or a DB snapshot from.</p>
    pub fn source_regions(&self) -> std::option::Option<&[crate::model::SourceRegion]> {
        self.source_regions.as_deref()
    }
}
impl std::fmt::Debug for DescribeSourceRegionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeSourceRegionsOutput");
        formatter.field("marker", &self.marker);
        formatter.field("source_regions", &self.source_regions);
        formatter.finish()
    }
}
/// See [`DescribeSourceRegionsOutput`](crate::output::DescribeSourceRegionsOutput)
pub mod describe_source_regions_output {
    /// A builder for [`DescribeSourceRegionsOutput`](crate::output::DescribeSourceRegionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) source_regions: std::option::Option<std::vec::Vec<crate::model::SourceRegion>>,
    }
    impl Builder {
        /// <p>
        /// An optional pagination token provided by a previous request.
        /// If this parameter is specified, the response includes
        /// only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.
        /// </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>
        /// An optional pagination token provided by a previous request.
        /// If this parameter is specified, the response includes
        /// only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.
        /// </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Appends an item to `source_regions`.
        ///
        /// To override the contents of this collection use [`set_source_regions`](Self::set_source_regions).
        ///
        /// <p>A list of SourceRegion instances that contains each source Amazon Web Services Region that the
        /// current Amazon Web Services Region can get a read replica or a DB snapshot from.</p>
        pub fn source_regions(mut self, input: impl Into<crate::model::SourceRegion>) -> Self {
            let mut v = self.source_regions.unwrap_or_default();
            v.push(input.into());
            self.source_regions = Some(v);
            self
        }
        /// <p>A list of SourceRegion instances that contains each source Amazon Web Services Region that the
        /// current Amazon Web Services Region can get a read replica or a DB snapshot from.</p>
        pub fn set_source_regions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SourceRegion>>,
        ) -> Self {
            self.source_regions = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeSourceRegionsOutput`](crate::output::DescribeSourceRegionsOutput)
        pub fn build(self) -> crate::output::DescribeSourceRegionsOutput {
            crate::output::DescribeSourceRegionsOutput {
                marker: self.marker,
                source_regions: self.source_regions,
            }
        }
    }
}
impl DescribeSourceRegionsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeSourceRegionsOutput`](crate::output::DescribeSourceRegionsOutput)
    pub fn builder() -> crate::output::describe_source_regions_output::Builder {
        crate::output::describe_source_regions_output::Builder::default()
    }
}

/// <p>
/// Contains the result of a successful invocation of the <code>DescribeReservedDBInstancesOfferings</code> action.    
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeReservedDbInstancesOfferingsOutput {
    /// <p>
    /// An optional pagination token provided by a previous request.
    /// If this parameter is specified, the response includes
    /// only records beyond the marker,
    /// up to the value specified by <code>MaxRecords</code>.
    /// </p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>A list of reserved DB instance offerings.</p>
    pub reserved_db_instances_offerings:
        std::option::Option<std::vec::Vec<crate::model::ReservedDbInstancesOffering>>,
}
impl DescribeReservedDbInstancesOfferingsOutput {
    /// <p>
    /// An optional pagination token provided by a previous request.
    /// If this parameter is specified, the response includes
    /// only records beyond the marker,
    /// up to the value specified by <code>MaxRecords</code>.
    /// </p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>A list of reserved DB instance offerings.</p>
    pub fn reserved_db_instances_offerings(
        &self,
    ) -> std::option::Option<&[crate::model::ReservedDbInstancesOffering]> {
        self.reserved_db_instances_offerings.as_deref()
    }
}
impl std::fmt::Debug for DescribeReservedDbInstancesOfferingsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeReservedDbInstancesOfferingsOutput");
        formatter.field("marker", &self.marker);
        formatter.field(
            "reserved_db_instances_offerings",
            &self.reserved_db_instances_offerings,
        );
        formatter.finish()
    }
}
/// See [`DescribeReservedDbInstancesOfferingsOutput`](crate::output::DescribeReservedDbInstancesOfferingsOutput)
pub mod describe_reserved_db_instances_offerings_output {
    /// A builder for [`DescribeReservedDbInstancesOfferingsOutput`](crate::output::DescribeReservedDbInstancesOfferingsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) reserved_db_instances_offerings:
            std::option::Option<std::vec::Vec<crate::model::ReservedDbInstancesOffering>>,
    }
    impl Builder {
        /// <p>
        /// An optional pagination token provided by a previous request.
        /// If this parameter is specified, the response includes
        /// only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.
        /// </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>
        /// An optional pagination token provided by a previous request.
        /// If this parameter is specified, the response includes
        /// only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.
        /// </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Appends an item to `reserved_db_instances_offerings`.
        ///
        /// To override the contents of this collection use [`set_reserved_db_instances_offerings`](Self::set_reserved_db_instances_offerings).
        ///
        /// <p>A list of reserved DB instance offerings.</p>
        pub fn reserved_db_instances_offerings(
            mut self,
            input: impl Into<crate::model::ReservedDbInstancesOffering>,
        ) -> Self {
            let mut v = self.reserved_db_instances_offerings.unwrap_or_default();
            v.push(input.into());
            self.reserved_db_instances_offerings = Some(v);
            self
        }
        /// <p>A list of reserved DB instance offerings.</p>
        pub fn set_reserved_db_instances_offerings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ReservedDbInstancesOffering>>,
        ) -> Self {
            self.reserved_db_instances_offerings = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeReservedDbInstancesOfferingsOutput`](crate::output::DescribeReservedDbInstancesOfferingsOutput)
        pub fn build(self) -> crate::output::DescribeReservedDbInstancesOfferingsOutput {
            crate::output::DescribeReservedDbInstancesOfferingsOutput {
                marker: self.marker,
                reserved_db_instances_offerings: self.reserved_db_instances_offerings,
            }
        }
    }
}
impl DescribeReservedDbInstancesOfferingsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeReservedDbInstancesOfferingsOutput`](crate::output::DescribeReservedDbInstancesOfferingsOutput)
    pub fn builder() -> crate::output::describe_reserved_db_instances_offerings_output::Builder {
        crate::output::describe_reserved_db_instances_offerings_output::Builder::default()
    }
}

/// <p>
/// Contains the result of a successful invocation of the <code>DescribeReservedDBInstances</code> action.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeReservedDbInstancesOutput {
    /// <p>
    /// An optional pagination token provided by a previous request.
    /// If this parameter is specified, the response includes
    /// only records beyond the marker,
    /// up to the value specified by <code>MaxRecords</code>.
    /// </p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>A list of reserved DB instances.</p>
    pub reserved_db_instances: std::option::Option<std::vec::Vec<crate::model::ReservedDbInstance>>,
}
impl DescribeReservedDbInstancesOutput {
    /// <p>
    /// An optional pagination token provided by a previous request.
    /// If this parameter is specified, the response includes
    /// only records beyond the marker,
    /// up to the value specified by <code>MaxRecords</code>.
    /// </p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>A list of reserved DB instances.</p>
    pub fn reserved_db_instances(
        &self,
    ) -> std::option::Option<&[crate::model::ReservedDbInstance]> {
        self.reserved_db_instances.as_deref()
    }
}
impl std::fmt::Debug for DescribeReservedDbInstancesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeReservedDbInstancesOutput");
        formatter.field("marker", &self.marker);
        formatter.field("reserved_db_instances", &self.reserved_db_instances);
        formatter.finish()
    }
}
/// See [`DescribeReservedDbInstancesOutput`](crate::output::DescribeReservedDbInstancesOutput)
pub mod describe_reserved_db_instances_output {
    /// A builder for [`DescribeReservedDbInstancesOutput`](crate::output::DescribeReservedDbInstancesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) reserved_db_instances:
            std::option::Option<std::vec::Vec<crate::model::ReservedDbInstance>>,
    }
    impl Builder {
        /// <p>
        /// An optional pagination token provided by a previous request.
        /// If this parameter is specified, the response includes
        /// only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.
        /// </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>
        /// An optional pagination token provided by a previous request.
        /// If this parameter is specified, the response includes
        /// only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.
        /// </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Appends an item to `reserved_db_instances`.
        ///
        /// To override the contents of this collection use [`set_reserved_db_instances`](Self::set_reserved_db_instances).
        ///
        /// <p>A list of reserved DB instances.</p>
        pub fn reserved_db_instances(
            mut self,
            input: impl Into<crate::model::ReservedDbInstance>,
        ) -> Self {
            let mut v = self.reserved_db_instances.unwrap_or_default();
            v.push(input.into());
            self.reserved_db_instances = Some(v);
            self
        }
        /// <p>A list of reserved DB instances.</p>
        pub fn set_reserved_db_instances(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ReservedDbInstance>>,
        ) -> Self {
            self.reserved_db_instances = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeReservedDbInstancesOutput`](crate::output::DescribeReservedDbInstancesOutput)
        pub fn build(self) -> crate::output::DescribeReservedDbInstancesOutput {
            crate::output::DescribeReservedDbInstancesOutput {
                marker: self.marker,
                reserved_db_instances: self.reserved_db_instances,
            }
        }
    }
}
impl DescribeReservedDbInstancesOutput {
    /// Creates a new builder-style object to manufacture [`DescribeReservedDbInstancesOutput`](crate::output::DescribeReservedDbInstancesOutput)
    pub fn builder() -> crate::output::describe_reserved_db_instances_output::Builder {
        crate::output::describe_reserved_db_instances_output::Builder::default()
    }
}

/// <p>Data returned from the <b>DescribePendingMaintenanceActions</b> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribePendingMaintenanceActionsOutput {
    /// <p>A list of the pending maintenance actions for the resource.</p>
    pub pending_maintenance_actions:
        std::option::Option<std::vec::Vec<crate::model::ResourcePendingMaintenanceActions>>,
    /// <p>
    /// An optional pagination token provided by a previous
    /// <code>DescribePendingMaintenanceActions</code> request.
    /// If this parameter is specified, the response includes
    /// only records beyond the marker,
    /// up to a number of records specified by <code>MaxRecords</code>.
    /// </p>
    pub marker: std::option::Option<std::string::String>,
}
impl DescribePendingMaintenanceActionsOutput {
    /// <p>A list of the pending maintenance actions for the resource.</p>
    pub fn pending_maintenance_actions(
        &self,
    ) -> std::option::Option<&[crate::model::ResourcePendingMaintenanceActions]> {
        self.pending_maintenance_actions.as_deref()
    }
    /// <p>
    /// An optional pagination token provided by a previous
    /// <code>DescribePendingMaintenanceActions</code> request.
    /// If this parameter is specified, the response includes
    /// only records beyond the marker,
    /// up to a number of records specified by <code>MaxRecords</code>.
    /// </p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for DescribePendingMaintenanceActionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribePendingMaintenanceActionsOutput");
        formatter.field(
            "pending_maintenance_actions",
            &self.pending_maintenance_actions,
        );
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}
/// See [`DescribePendingMaintenanceActionsOutput`](crate::output::DescribePendingMaintenanceActionsOutput)
pub mod describe_pending_maintenance_actions_output {
    /// A builder for [`DescribePendingMaintenanceActionsOutput`](crate::output::DescribePendingMaintenanceActionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pending_maintenance_actions:
            std::option::Option<std::vec::Vec<crate::model::ResourcePendingMaintenanceActions>>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `pending_maintenance_actions`.
        ///
        /// To override the contents of this collection use [`set_pending_maintenance_actions`](Self::set_pending_maintenance_actions).
        ///
        /// <p>A list of the pending maintenance actions for the resource.</p>
        pub fn pending_maintenance_actions(
            mut self,
            input: impl Into<crate::model::ResourcePendingMaintenanceActions>,
        ) -> Self {
            let mut v = self.pending_maintenance_actions.unwrap_or_default();
            v.push(input.into());
            self.pending_maintenance_actions = Some(v);
            self
        }
        /// <p>A list of the pending maintenance actions for the resource.</p>
        pub fn set_pending_maintenance_actions(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::ResourcePendingMaintenanceActions>,
            >,
        ) -> Self {
            self.pending_maintenance_actions = input;
            self
        }
        /// <p>
        /// An optional pagination token provided by a previous
        /// <code>DescribePendingMaintenanceActions</code> request.
        /// If this parameter is specified, the response includes
        /// only records beyond the marker,
        /// up to a number of records specified by <code>MaxRecords</code>.
        /// </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>
        /// An optional pagination token provided by a previous
        /// <code>DescribePendingMaintenanceActions</code> request.
        /// If this parameter is specified, the response includes
        /// only records beyond the marker,
        /// up to a number of records specified by <code>MaxRecords</code>.
        /// </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribePendingMaintenanceActionsOutput`](crate::output::DescribePendingMaintenanceActionsOutput)
        pub fn build(self) -> crate::output::DescribePendingMaintenanceActionsOutput {
            crate::output::DescribePendingMaintenanceActionsOutput {
                pending_maintenance_actions: self.pending_maintenance_actions,
                marker: self.marker,
            }
        }
    }
}
impl DescribePendingMaintenanceActionsOutput {
    /// Creates a new builder-style object to manufacture [`DescribePendingMaintenanceActionsOutput`](crate::output::DescribePendingMaintenanceActionsOutput)
    pub fn builder() -> crate::output::describe_pending_maintenance_actions_output::Builder {
        crate::output::describe_pending_maintenance_actions_output::Builder::default()
    }
}

/// <p>
/// Contains the result of a successful invocation of the <code>DescribeOrderableDBInstanceOptions</code> action.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeOrderableDbInstanceOptionsOutput {
    /// <p>An <code>OrderableDBInstanceOption</code> structure containing information about orderable options for the DB instance.</p>
    pub orderable_db_instance_options:
        std::option::Option<std::vec::Vec<crate::model::OrderableDbInstanceOption>>,
    /// <p>
    /// An optional pagination token provided by a previous
    /// OrderableDBInstanceOptions request.
    /// If this parameter is specified, the response includes
    /// only records beyond the marker,
    /// up to the value specified by <code>MaxRecords</code> .
    /// </p>
    pub marker: std::option::Option<std::string::String>,
}
impl DescribeOrderableDbInstanceOptionsOutput {
    /// <p>An <code>OrderableDBInstanceOption</code> structure containing information about orderable options for the DB instance.</p>
    pub fn orderable_db_instance_options(
        &self,
    ) -> std::option::Option<&[crate::model::OrderableDbInstanceOption]> {
        self.orderable_db_instance_options.as_deref()
    }
    /// <p>
    /// An optional pagination token provided by a previous
    /// OrderableDBInstanceOptions request.
    /// If this parameter is specified, the response includes
    /// only records beyond the marker,
    /// up to the value specified by <code>MaxRecords</code> .
    /// </p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for DescribeOrderableDbInstanceOptionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeOrderableDbInstanceOptionsOutput");
        formatter.field(
            "orderable_db_instance_options",
            &self.orderable_db_instance_options,
        );
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}
/// See [`DescribeOrderableDbInstanceOptionsOutput`](crate::output::DescribeOrderableDbInstanceOptionsOutput)
pub mod describe_orderable_db_instance_options_output {
    /// A builder for [`DescribeOrderableDbInstanceOptionsOutput`](crate::output::DescribeOrderableDbInstanceOptionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) orderable_db_instance_options:
            std::option::Option<std::vec::Vec<crate::model::OrderableDbInstanceOption>>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `orderable_db_instance_options`.
        ///
        /// To override the contents of this collection use [`set_orderable_db_instance_options`](Self::set_orderable_db_instance_options).
        ///
        /// <p>An <code>OrderableDBInstanceOption</code> structure containing information about orderable options for the DB instance.</p>
        pub fn orderable_db_instance_options(
            mut self,
            input: impl Into<crate::model::OrderableDbInstanceOption>,
        ) -> Self {
            let mut v = self.orderable_db_instance_options.unwrap_or_default();
            v.push(input.into());
            self.orderable_db_instance_options = Some(v);
            self
        }
        /// <p>An <code>OrderableDBInstanceOption</code> structure containing information about orderable options for the DB instance.</p>
        pub fn set_orderable_db_instance_options(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OrderableDbInstanceOption>>,
        ) -> Self {
            self.orderable_db_instance_options = input;
            self
        }
        /// <p>
        /// An optional pagination token provided by a previous
        /// OrderableDBInstanceOptions request.
        /// If this parameter is specified, the response includes
        /// only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code> .
        /// </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>
        /// An optional pagination token provided by a previous
        /// OrderableDBInstanceOptions request.
        /// If this parameter is specified, the response includes
        /// only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code> .
        /// </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeOrderableDbInstanceOptionsOutput`](crate::output::DescribeOrderableDbInstanceOptionsOutput)
        pub fn build(self) -> crate::output::DescribeOrderableDbInstanceOptionsOutput {
            crate::output::DescribeOrderableDbInstanceOptionsOutput {
                orderable_db_instance_options: self.orderable_db_instance_options,
                marker: self.marker,
            }
        }
    }
}
impl DescribeOrderableDbInstanceOptionsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeOrderableDbInstanceOptionsOutput`](crate::output::DescribeOrderableDbInstanceOptionsOutput)
    pub fn builder() -> crate::output::describe_orderable_db_instance_options_output::Builder {
        crate::output::describe_orderable_db_instance_options_output::Builder::default()
    }
}

/// <p>List of option groups.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeOptionGroupsOutput {
    /// <p>List of option groups.</p>
    pub option_groups_list: std::option::Option<std::vec::Vec<crate::model::OptionGroup>>,
    /// <p>An optional pagination token provided by a previous request.
    /// If this parameter is specified, the response includes
    /// only records beyond the marker,
    /// up to the value specified by <code>MaxRecords</code>.
    /// </p>
    pub marker: std::option::Option<std::string::String>,
}
impl DescribeOptionGroupsOutput {
    /// <p>List of option groups.</p>
    pub fn option_groups_list(&self) -> std::option::Option<&[crate::model::OptionGroup]> {
        self.option_groups_list.as_deref()
    }
    /// <p>An optional pagination token provided by a previous request.
    /// If this parameter is specified, the response includes
    /// only records beyond the marker,
    /// up to the value specified by <code>MaxRecords</code>.
    /// </p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for DescribeOptionGroupsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeOptionGroupsOutput");
        formatter.field("option_groups_list", &self.option_groups_list);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}
/// See [`DescribeOptionGroupsOutput`](crate::output::DescribeOptionGroupsOutput)
pub mod describe_option_groups_output {
    /// A builder for [`DescribeOptionGroupsOutput`](crate::output::DescribeOptionGroupsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) option_groups_list:
            std::option::Option<std::vec::Vec<crate::model::OptionGroup>>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `option_groups_list`.
        ///
        /// To override the contents of this collection use [`set_option_groups_list`](Self::set_option_groups_list).
        ///
        /// <p>List of option groups.</p>
        pub fn option_groups_list(mut self, input: impl Into<crate::model::OptionGroup>) -> Self {
            let mut v = self.option_groups_list.unwrap_or_default();
            v.push(input.into());
            self.option_groups_list = Some(v);
            self
        }
        /// <p>List of option groups.</p>
        pub fn set_option_groups_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OptionGroup>>,
        ) -> Self {
            self.option_groups_list = input;
            self
        }
        /// <p>An optional pagination token provided by a previous request.
        /// If this parameter is specified, the response includes
        /// only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.
        /// </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An optional pagination token provided by a previous request.
        /// If this parameter is specified, the response includes
        /// only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.
        /// </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeOptionGroupsOutput`](crate::output::DescribeOptionGroupsOutput)
        pub fn build(self) -> crate::output::DescribeOptionGroupsOutput {
            crate::output::DescribeOptionGroupsOutput {
                option_groups_list: self.option_groups_list,
                marker: self.marker,
            }
        }
    }
}
impl DescribeOptionGroupsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeOptionGroupsOutput`](crate::output::DescribeOptionGroupsOutput)
    pub fn builder() -> crate::output::describe_option_groups_output::Builder {
        crate::output::describe_option_groups_output::Builder::default()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeOptionGroupOptionsOutput {
    /// <p>List of available option group options.</p>
    pub option_group_options: std::option::Option<std::vec::Vec<crate::model::OptionGroupOption>>,
    /// <p>An optional pagination token provided by a previous request.
    /// If this parameter is specified, the response includes
    /// only records beyond the marker,
    /// up to the value specified by <code>MaxRecords</code>.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl DescribeOptionGroupOptionsOutput {
    /// <p>List of available option group options.</p>
    pub fn option_group_options(&self) -> std::option::Option<&[crate::model::OptionGroupOption]> {
        self.option_group_options.as_deref()
    }
    /// <p>An optional pagination token provided by a previous request.
    /// If this parameter is specified, the response includes
    /// only records beyond the marker,
    /// up to the value specified by <code>MaxRecords</code>.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for DescribeOptionGroupOptionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeOptionGroupOptionsOutput");
        formatter.field("option_group_options", &self.option_group_options);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}
/// See [`DescribeOptionGroupOptionsOutput`](crate::output::DescribeOptionGroupOptionsOutput)
pub mod describe_option_group_options_output {
    /// A builder for [`DescribeOptionGroupOptionsOutput`](crate::output::DescribeOptionGroupOptionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) option_group_options:
            std::option::Option<std::vec::Vec<crate::model::OptionGroupOption>>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `option_group_options`.
        ///
        /// To override the contents of this collection use [`set_option_group_options`](Self::set_option_group_options).
        ///
        /// <p>List of available option group options.</p>
        pub fn option_group_options(
            mut self,
            input: impl Into<crate::model::OptionGroupOption>,
        ) -> Self {
            let mut v = self.option_group_options.unwrap_or_default();
            v.push(input.into());
            self.option_group_options = Some(v);
            self
        }
        /// <p>List of available option group options.</p>
        pub fn set_option_group_options(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OptionGroupOption>>,
        ) -> Self {
            self.option_group_options = input;
            self
        }
        /// <p>An optional pagination token provided by a previous request.
        /// If this parameter is specified, the response includes
        /// only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An optional pagination token provided by a previous request.
        /// If this parameter is specified, the response includes
        /// only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeOptionGroupOptionsOutput`](crate::output::DescribeOptionGroupOptionsOutput)
        pub fn build(self) -> crate::output::DescribeOptionGroupOptionsOutput {
            crate::output::DescribeOptionGroupOptionsOutput {
                option_group_options: self.option_group_options,
                marker: self.marker,
            }
        }
    }
}
impl DescribeOptionGroupOptionsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeOptionGroupOptionsOutput`](crate::output::DescribeOptionGroupOptionsOutput)
    pub fn builder() -> crate::output::describe_option_group_options_output::Builder {
        crate::output::describe_option_group_options_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeInstallationMediaOutput {
    /// <p>An optional pagination token provided by a previous
    /// <a>DescribeInstallationMedia</a> request.
    /// If this parameter is specified, the response includes
    /// only records beyond the marker,
    /// up to the value specified by <code>MaxRecords</code>.</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>The list of <a>InstallationMedia</a> objects for the Amazon Web Services account.</p>
    pub installation_media: std::option::Option<std::vec::Vec<crate::model::InstallationMedia>>,
}
impl DescribeInstallationMediaOutput {
    /// <p>An optional pagination token provided by a previous
    /// <a>DescribeInstallationMedia</a> request.
    /// If this parameter is specified, the response includes
    /// only records beyond the marker,
    /// up to the value specified by <code>MaxRecords</code>.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>The list of <a>InstallationMedia</a> objects for the Amazon Web Services account.</p>
    pub fn installation_media(&self) -> std::option::Option<&[crate::model::InstallationMedia]> {
        self.installation_media.as_deref()
    }
}
impl std::fmt::Debug for DescribeInstallationMediaOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeInstallationMediaOutput");
        formatter.field("marker", &self.marker);
        formatter.field("installation_media", &self.installation_media);
        formatter.finish()
    }
}
/// See [`DescribeInstallationMediaOutput`](crate::output::DescribeInstallationMediaOutput)
pub mod describe_installation_media_output {
    /// A builder for [`DescribeInstallationMediaOutput`](crate::output::DescribeInstallationMediaOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) installation_media:
            std::option::Option<std::vec::Vec<crate::model::InstallationMedia>>,
    }
    impl Builder {
        /// <p>An optional pagination token provided by a previous
        /// <a>DescribeInstallationMedia</a> request.
        /// If this parameter is specified, the response includes
        /// only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An optional pagination token provided by a previous
        /// <a>DescribeInstallationMedia</a> request.
        /// If this parameter is specified, the response includes
        /// only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Appends an item to `installation_media`.
        ///
        /// To override the contents of this collection use [`set_installation_media`](Self::set_installation_media).
        ///
        /// <p>The list of <a>InstallationMedia</a> objects for the Amazon Web Services account.</p>
        pub fn installation_media(
            mut self,
            input: impl Into<crate::model::InstallationMedia>,
        ) -> Self {
            let mut v = self.installation_media.unwrap_or_default();
            v.push(input.into());
            self.installation_media = Some(v);
            self
        }
        /// <p>The list of <a>InstallationMedia</a> objects for the Amazon Web Services account.</p>
        pub fn set_installation_media(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InstallationMedia>>,
        ) -> Self {
            self.installation_media = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeInstallationMediaOutput`](crate::output::DescribeInstallationMediaOutput)
        pub fn build(self) -> crate::output::DescribeInstallationMediaOutput {
            crate::output::DescribeInstallationMediaOutput {
                marker: self.marker,
                installation_media: self.installation_media,
            }
        }
    }
}
impl DescribeInstallationMediaOutput {
    /// Creates a new builder-style object to manufacture [`DescribeInstallationMediaOutput`](crate::output::DescribeInstallationMediaOutput)
    pub fn builder() -> crate::output::describe_installation_media_output::Builder {
        crate::output::describe_installation_media_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeGlobalClustersOutput {
    /// <p>
    /// An optional pagination token provided by a previous <code>DescribeGlobalClusters</code> request.
    /// If this parameter is specified, the response includes
    /// only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
    /// </p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>
    /// The list of global clusters returned by this request.
    /// </p>
    pub global_clusters: std::option::Option<std::vec::Vec<crate::model::GlobalCluster>>,
}
impl DescribeGlobalClustersOutput {
    /// <p>
    /// An optional pagination token provided by a previous <code>DescribeGlobalClusters</code> request.
    /// If this parameter is specified, the response includes
    /// only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
    /// </p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>
    /// The list of global clusters returned by this request.
    /// </p>
    pub fn global_clusters(&self) -> std::option::Option<&[crate::model::GlobalCluster]> {
        self.global_clusters.as_deref()
    }
}
impl std::fmt::Debug for DescribeGlobalClustersOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeGlobalClustersOutput");
        formatter.field("marker", &self.marker);
        formatter.field("global_clusters", &self.global_clusters);
        formatter.finish()
    }
}
/// See [`DescribeGlobalClustersOutput`](crate::output::DescribeGlobalClustersOutput)
pub mod describe_global_clusters_output {
    /// A builder for [`DescribeGlobalClustersOutput`](crate::output::DescribeGlobalClustersOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) global_clusters: std::option::Option<std::vec::Vec<crate::model::GlobalCluster>>,
    }
    impl Builder {
        /// <p>
        /// An optional pagination token provided by a previous <code>DescribeGlobalClusters</code> request.
        /// If this parameter is specified, the response includes
        /// only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
        /// </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>
        /// An optional pagination token provided by a previous <code>DescribeGlobalClusters</code> request.
        /// If this parameter is specified, the response includes
        /// only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
        /// </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Appends an item to `global_clusters`.
        ///
        /// To override the contents of this collection use [`set_global_clusters`](Self::set_global_clusters).
        ///
        /// <p>
        /// The list of global clusters returned by this request.
        /// </p>
        pub fn global_clusters(mut self, input: impl Into<crate::model::GlobalCluster>) -> Self {
            let mut v = self.global_clusters.unwrap_or_default();
            v.push(input.into());
            self.global_clusters = Some(v);
            self
        }
        /// <p>
        /// The list of global clusters returned by this request.
        /// </p>
        pub fn set_global_clusters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GlobalCluster>>,
        ) -> Self {
            self.global_clusters = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeGlobalClustersOutput`](crate::output::DescribeGlobalClustersOutput)
        pub fn build(self) -> crate::output::DescribeGlobalClustersOutput {
            crate::output::DescribeGlobalClustersOutput {
                marker: self.marker,
                global_clusters: self.global_clusters,
            }
        }
    }
}
impl DescribeGlobalClustersOutput {
    /// Creates a new builder-style object to manufacture [`DescribeGlobalClustersOutput`](crate::output::DescribeGlobalClustersOutput)
    pub fn builder() -> crate::output::describe_global_clusters_output::Builder {
        crate::output::describe_global_clusters_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeExportTasksOutput {
    /// <p>A pagination token that can be used in a later <code>DescribeExportTasks</code>
    /// request. A marker is used for pagination to identify the location to begin output for
    /// the next response of <code>DescribeExportTasks</code>.</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>Information about an export of a snapshot to Amazon S3.</p>
    pub export_tasks: std::option::Option<std::vec::Vec<crate::model::ExportTask>>,
}
impl DescribeExportTasksOutput {
    /// <p>A pagination token that can be used in a later <code>DescribeExportTasks</code>
    /// request. A marker is used for pagination to identify the location to begin output for
    /// the next response of <code>DescribeExportTasks</code>.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>Information about an export of a snapshot to Amazon S3.</p>
    pub fn export_tasks(&self) -> std::option::Option<&[crate::model::ExportTask]> {
        self.export_tasks.as_deref()
    }
}
impl std::fmt::Debug for DescribeExportTasksOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeExportTasksOutput");
        formatter.field("marker", &self.marker);
        formatter.field("export_tasks", &self.export_tasks);
        formatter.finish()
    }
}
/// See [`DescribeExportTasksOutput`](crate::output::DescribeExportTasksOutput)
pub mod describe_export_tasks_output {
    /// A builder for [`DescribeExportTasksOutput`](crate::output::DescribeExportTasksOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) export_tasks: std::option::Option<std::vec::Vec<crate::model::ExportTask>>,
    }
    impl Builder {
        /// <p>A pagination token that can be used in a later <code>DescribeExportTasks</code>
        /// request. A marker is used for pagination to identify the location to begin output for
        /// the next response of <code>DescribeExportTasks</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>A pagination token that can be used in a later <code>DescribeExportTasks</code>
        /// request. A marker is used for pagination to identify the location to begin output for
        /// the next response of <code>DescribeExportTasks</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Appends an item to `export_tasks`.
        ///
        /// To override the contents of this collection use [`set_export_tasks`](Self::set_export_tasks).
        ///
        /// <p>Information about an export of a snapshot to Amazon S3.</p>
        pub fn export_tasks(mut self, input: impl Into<crate::model::ExportTask>) -> Self {
            let mut v = self.export_tasks.unwrap_or_default();
            v.push(input.into());
            self.export_tasks = Some(v);
            self
        }
        /// <p>Information about an export of a snapshot to Amazon S3.</p>
        pub fn set_export_tasks(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ExportTask>>,
        ) -> Self {
            self.export_tasks = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeExportTasksOutput`](crate::output::DescribeExportTasksOutput)
        pub fn build(self) -> crate::output::DescribeExportTasksOutput {
            crate::output::DescribeExportTasksOutput {
                marker: self.marker,
                export_tasks: self.export_tasks,
            }
        }
    }
}
impl DescribeExportTasksOutput {
    /// Creates a new builder-style object to manufacture [`DescribeExportTasksOutput`](crate::output::DescribeExportTasksOutput)
    pub fn builder() -> crate::output::describe_export_tasks_output::Builder {
        crate::output::describe_export_tasks_output::Builder::default()
    }
}

/// <p>Data returned by the <b>DescribeEventSubscriptions</b> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeEventSubscriptionsOutput {
    /// <p>
    /// An optional pagination token provided by a previous
    /// DescribeOrderableDBInstanceOptions request.
    /// If this parameter is specified, the response includes
    /// only records beyond the marker,
    /// up to the value specified by <code>MaxRecords</code>.
    /// </p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>A list of EventSubscriptions data types.</p>
    pub event_subscriptions_list:
        std::option::Option<std::vec::Vec<crate::model::EventSubscription>>,
}
impl DescribeEventSubscriptionsOutput {
    /// <p>
    /// An optional pagination token provided by a previous
    /// DescribeOrderableDBInstanceOptions request.
    /// If this parameter is specified, the response includes
    /// only records beyond the marker,
    /// up to the value specified by <code>MaxRecords</code>.
    /// </p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>A list of EventSubscriptions data types.</p>
    pub fn event_subscriptions_list(
        &self,
    ) -> std::option::Option<&[crate::model::EventSubscription]> {
        self.event_subscriptions_list.as_deref()
    }
}
impl std::fmt::Debug for DescribeEventSubscriptionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeEventSubscriptionsOutput");
        formatter.field("marker", &self.marker);
        formatter.field("event_subscriptions_list", &self.event_subscriptions_list);
        formatter.finish()
    }
}
/// See [`DescribeEventSubscriptionsOutput`](crate::output::DescribeEventSubscriptionsOutput)
pub mod describe_event_subscriptions_output {
    /// A builder for [`DescribeEventSubscriptionsOutput`](crate::output::DescribeEventSubscriptionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) event_subscriptions_list:
            std::option::Option<std::vec::Vec<crate::model::EventSubscription>>,
    }
    impl Builder {
        /// <p>
        /// An optional pagination token provided by a previous
        /// DescribeOrderableDBInstanceOptions request.
        /// If this parameter is specified, the response includes
        /// only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.
        /// </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>
        /// An optional pagination token provided by a previous
        /// DescribeOrderableDBInstanceOptions request.
        /// If this parameter is specified, the response includes
        /// only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.
        /// </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Appends an item to `event_subscriptions_list`.
        ///
        /// To override the contents of this collection use [`set_event_subscriptions_list`](Self::set_event_subscriptions_list).
        ///
        /// <p>A list of EventSubscriptions data types.</p>
        pub fn event_subscriptions_list(
            mut self,
            input: impl Into<crate::model::EventSubscription>,
        ) -> Self {
            let mut v = self.event_subscriptions_list.unwrap_or_default();
            v.push(input.into());
            self.event_subscriptions_list = Some(v);
            self
        }
        /// <p>A list of EventSubscriptions data types.</p>
        pub fn set_event_subscriptions_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EventSubscription>>,
        ) -> Self {
            self.event_subscriptions_list = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeEventSubscriptionsOutput`](crate::output::DescribeEventSubscriptionsOutput)
        pub fn build(self) -> crate::output::DescribeEventSubscriptionsOutput {
            crate::output::DescribeEventSubscriptionsOutput {
                marker: self.marker,
                event_subscriptions_list: self.event_subscriptions_list,
            }
        }
    }
}
impl DescribeEventSubscriptionsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeEventSubscriptionsOutput`](crate::output::DescribeEventSubscriptionsOutput)
    pub fn builder() -> crate::output::describe_event_subscriptions_output::Builder {
        crate::output::describe_event_subscriptions_output::Builder::default()
    }
}

/// <p>
/// Contains the result of a successful invocation of the <code>DescribeEvents</code> action.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeEventsOutput {
    /// <p>
    /// An optional pagination token provided by a previous
    /// Events request.
    /// If this parameter is specified, the response includes
    /// only records beyond the marker,
    /// up to the value specified by <code>MaxRecords</code> .
    /// </p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>
    /// A list of <code>Event</code> instances.
    /// </p>
    pub events: std::option::Option<std::vec::Vec<crate::model::Event>>,
}
impl DescribeEventsOutput {
    /// <p>
    /// An optional pagination token provided by a previous
    /// Events request.
    /// If this parameter is specified, the response includes
    /// only records beyond the marker,
    /// up to the value specified by <code>MaxRecords</code> .
    /// </p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>
    /// A list of <code>Event</code> instances.
    /// </p>
    pub fn events(&self) -> std::option::Option<&[crate::model::Event]> {
        self.events.as_deref()
    }
}
impl std::fmt::Debug for DescribeEventsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeEventsOutput");
        formatter.field("marker", &self.marker);
        formatter.field("events", &self.events);
        formatter.finish()
    }
}
/// See [`DescribeEventsOutput`](crate::output::DescribeEventsOutput)
pub mod describe_events_output {
    /// A builder for [`DescribeEventsOutput`](crate::output::DescribeEventsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) events: std::option::Option<std::vec::Vec<crate::model::Event>>,
    }
    impl Builder {
        /// <p>
        /// An optional pagination token provided by a previous
        /// Events request.
        /// If this parameter is specified, the response includes
        /// only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code> .
        /// </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>
        /// An optional pagination token provided by a previous
        /// Events request.
        /// If this parameter is specified, the response includes
        /// only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code> .
        /// </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Appends an item to `events`.
        ///
        /// To override the contents of this collection use [`set_events`](Self::set_events).
        ///
        /// <p>
        /// A list of <code>Event</code> instances.
        /// </p>
        pub fn events(mut self, input: impl Into<crate::model::Event>) -> Self {
            let mut v = self.events.unwrap_or_default();
            v.push(input.into());
            self.events = Some(v);
            self
        }
        /// <p>
        /// A list of <code>Event</code> instances.
        /// </p>
        pub fn set_events(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Event>>,
        ) -> Self {
            self.events = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeEventsOutput`](crate::output::DescribeEventsOutput)
        pub fn build(self) -> crate::output::DescribeEventsOutput {
            crate::output::DescribeEventsOutput {
                marker: self.marker,
                events: self.events,
            }
        }
    }
}
impl DescribeEventsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeEventsOutput`](crate::output::DescribeEventsOutput)
    pub fn builder() -> crate::output::describe_events_output::Builder {
        crate::output::describe_events_output::Builder::default()
    }
}

/// <p>Data returned from the <code>DescribeEventCategories</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeEventCategoriesOutput {
    /// <p>A list of EventCategoriesMap data types.</p>
    pub event_categories_map_list:
        std::option::Option<std::vec::Vec<crate::model::EventCategoriesMap>>,
}
impl DescribeEventCategoriesOutput {
    /// <p>A list of EventCategoriesMap data types.</p>
    pub fn event_categories_map_list(
        &self,
    ) -> std::option::Option<&[crate::model::EventCategoriesMap]> {
        self.event_categories_map_list.as_deref()
    }
}
impl std::fmt::Debug for DescribeEventCategoriesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeEventCategoriesOutput");
        formatter.field("event_categories_map_list", &self.event_categories_map_list);
        formatter.finish()
    }
}
/// See [`DescribeEventCategoriesOutput`](crate::output::DescribeEventCategoriesOutput)
pub mod describe_event_categories_output {
    /// A builder for [`DescribeEventCategoriesOutput`](crate::output::DescribeEventCategoriesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) event_categories_map_list:
            std::option::Option<std::vec::Vec<crate::model::EventCategoriesMap>>,
    }
    impl Builder {
        /// Appends an item to `event_categories_map_list`.
        ///
        /// To override the contents of this collection use [`set_event_categories_map_list`](Self::set_event_categories_map_list).
        ///
        /// <p>A list of EventCategoriesMap data types.</p>
        pub fn event_categories_map_list(
            mut self,
            input: impl Into<crate::model::EventCategoriesMap>,
        ) -> Self {
            let mut v = self.event_categories_map_list.unwrap_or_default();
            v.push(input.into());
            self.event_categories_map_list = Some(v);
            self
        }
        /// <p>A list of EventCategoriesMap data types.</p>
        pub fn set_event_categories_map_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::EventCategoriesMap>>,
        ) -> Self {
            self.event_categories_map_list = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeEventCategoriesOutput`](crate::output::DescribeEventCategoriesOutput)
        pub fn build(self) -> crate::output::DescribeEventCategoriesOutput {
            crate::output::DescribeEventCategoriesOutput {
                event_categories_map_list: self.event_categories_map_list,
            }
        }
    }
}
impl DescribeEventCategoriesOutput {
    /// Creates a new builder-style object to manufacture [`DescribeEventCategoriesOutput`](crate::output::DescribeEventCategoriesOutput)
    pub fn builder() -> crate::output::describe_event_categories_output::Builder {
        crate::output::describe_event_categories_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeEngineDefaultParametersOutput {
    /// <p>
    /// Contains the result of a successful invocation of the <code>DescribeEngineDefaultParameters</code> action.
    /// </p>
    pub engine_defaults: std::option::Option<crate::model::EngineDefaults>,
}
impl DescribeEngineDefaultParametersOutput {
    /// <p>
    /// Contains the result of a successful invocation of the <code>DescribeEngineDefaultParameters</code> action.
    /// </p>
    pub fn engine_defaults(&self) -> std::option::Option<&crate::model::EngineDefaults> {
        self.engine_defaults.as_ref()
    }
}
impl std::fmt::Debug for DescribeEngineDefaultParametersOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeEngineDefaultParametersOutput");
        formatter.field("engine_defaults", &self.engine_defaults);
        formatter.finish()
    }
}
/// See [`DescribeEngineDefaultParametersOutput`](crate::output::DescribeEngineDefaultParametersOutput)
pub mod describe_engine_default_parameters_output {
    /// A builder for [`DescribeEngineDefaultParametersOutput`](crate::output::DescribeEngineDefaultParametersOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) engine_defaults: std::option::Option<crate::model::EngineDefaults>,
    }
    impl Builder {
        /// <p>
        /// Contains the result of a successful invocation of the <code>DescribeEngineDefaultParameters</code> action.
        /// </p>
        pub fn engine_defaults(mut self, input: crate::model::EngineDefaults) -> Self {
            self.engine_defaults = Some(input);
            self
        }
        /// <p>
        /// Contains the result of a successful invocation of the <code>DescribeEngineDefaultParameters</code> action.
        /// </p>
        pub fn set_engine_defaults(
            mut self,
            input: std::option::Option<crate::model::EngineDefaults>,
        ) -> Self {
            self.engine_defaults = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeEngineDefaultParametersOutput`](crate::output::DescribeEngineDefaultParametersOutput)
        pub fn build(self) -> crate::output::DescribeEngineDefaultParametersOutput {
            crate::output::DescribeEngineDefaultParametersOutput {
                engine_defaults: self.engine_defaults,
            }
        }
    }
}
impl DescribeEngineDefaultParametersOutput {
    /// Creates a new builder-style object to manufacture [`DescribeEngineDefaultParametersOutput`](crate::output::DescribeEngineDefaultParametersOutput)
    pub fn builder() -> crate::output::describe_engine_default_parameters_output::Builder {
        crate::output::describe_engine_default_parameters_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeEngineDefaultClusterParametersOutput {
    /// <p>
    /// Contains the result of a successful invocation of the <code>DescribeEngineDefaultParameters</code> action.
    /// </p>
    pub engine_defaults: std::option::Option<crate::model::EngineDefaults>,
}
impl DescribeEngineDefaultClusterParametersOutput {
    /// <p>
    /// Contains the result of a successful invocation of the <code>DescribeEngineDefaultParameters</code> action.
    /// </p>
    pub fn engine_defaults(&self) -> std::option::Option<&crate::model::EngineDefaults> {
        self.engine_defaults.as_ref()
    }
}
impl std::fmt::Debug for DescribeEngineDefaultClusterParametersOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeEngineDefaultClusterParametersOutput");
        formatter.field("engine_defaults", &self.engine_defaults);
        formatter.finish()
    }
}
/// See [`DescribeEngineDefaultClusterParametersOutput`](crate::output::DescribeEngineDefaultClusterParametersOutput)
pub mod describe_engine_default_cluster_parameters_output {
    /// A builder for [`DescribeEngineDefaultClusterParametersOutput`](crate::output::DescribeEngineDefaultClusterParametersOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) engine_defaults: std::option::Option<crate::model::EngineDefaults>,
    }
    impl Builder {
        /// <p>
        /// Contains the result of a successful invocation of the <code>DescribeEngineDefaultParameters</code> action.
        /// </p>
        pub fn engine_defaults(mut self, input: crate::model::EngineDefaults) -> Self {
            self.engine_defaults = Some(input);
            self
        }
        /// <p>
        /// Contains the result of a successful invocation of the <code>DescribeEngineDefaultParameters</code> action.
        /// </p>
        pub fn set_engine_defaults(
            mut self,
            input: std::option::Option<crate::model::EngineDefaults>,
        ) -> Self {
            self.engine_defaults = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeEngineDefaultClusterParametersOutput`](crate::output::DescribeEngineDefaultClusterParametersOutput)
        pub fn build(self) -> crate::output::DescribeEngineDefaultClusterParametersOutput {
            crate::output::DescribeEngineDefaultClusterParametersOutput {
                engine_defaults: self.engine_defaults,
            }
        }
    }
}
impl DescribeEngineDefaultClusterParametersOutput {
    /// Creates a new builder-style object to manufacture [`DescribeEngineDefaultClusterParametersOutput`](crate::output::DescribeEngineDefaultClusterParametersOutput)
    pub fn builder() -> crate::output::describe_engine_default_cluster_parameters_output::Builder {
        crate::output::describe_engine_default_cluster_parameters_output::Builder::default()
    }
}

/// <p>
/// Contains the result of a successful invocation of the <code>DescribeDBSubnetGroups</code> action.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDbSubnetGroupsOutput {
    /// <p>
    /// An optional pagination token provided by a previous request.
    /// If this parameter is specified, the response includes
    /// only records beyond the marker,
    /// up to the value specified by <code>MaxRecords</code>.
    /// </p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>
    /// A list of <code>DBSubnetGroup</code> instances.
    /// </p>
    pub db_subnet_groups: std::option::Option<std::vec::Vec<crate::model::DbSubnetGroup>>,
}
impl DescribeDbSubnetGroupsOutput {
    /// <p>
    /// An optional pagination token provided by a previous request.
    /// If this parameter is specified, the response includes
    /// only records beyond the marker,
    /// up to the value specified by <code>MaxRecords</code>.
    /// </p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>
    /// A list of <code>DBSubnetGroup</code> instances.
    /// </p>
    pub fn db_subnet_groups(&self) -> std::option::Option<&[crate::model::DbSubnetGroup]> {
        self.db_subnet_groups.as_deref()
    }
}
impl std::fmt::Debug for DescribeDbSubnetGroupsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDbSubnetGroupsOutput");
        formatter.field("marker", &self.marker);
        formatter.field("db_subnet_groups", &self.db_subnet_groups);
        formatter.finish()
    }
}
/// See [`DescribeDbSubnetGroupsOutput`](crate::output::DescribeDbSubnetGroupsOutput)
pub mod describe_db_subnet_groups_output {
    /// A builder for [`DescribeDbSubnetGroupsOutput`](crate::output::DescribeDbSubnetGroupsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) db_subnet_groups:
            std::option::Option<std::vec::Vec<crate::model::DbSubnetGroup>>,
    }
    impl Builder {
        /// <p>
        /// An optional pagination token provided by a previous request.
        /// If this parameter is specified, the response includes
        /// only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.
        /// </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>
        /// An optional pagination token provided by a previous request.
        /// If this parameter is specified, the response includes
        /// only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.
        /// </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Appends an item to `db_subnet_groups`.
        ///
        /// To override the contents of this collection use [`set_db_subnet_groups`](Self::set_db_subnet_groups).
        ///
        /// <p>
        /// A list of <code>DBSubnetGroup</code> instances.
        /// </p>
        pub fn db_subnet_groups(mut self, input: impl Into<crate::model::DbSubnetGroup>) -> Self {
            let mut v = self.db_subnet_groups.unwrap_or_default();
            v.push(input.into());
            self.db_subnet_groups = Some(v);
            self
        }
        /// <p>
        /// A list of <code>DBSubnetGroup</code> instances.
        /// </p>
        pub fn set_db_subnet_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DbSubnetGroup>>,
        ) -> Self {
            self.db_subnet_groups = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDbSubnetGroupsOutput`](crate::output::DescribeDbSubnetGroupsOutput)
        pub fn build(self) -> crate::output::DescribeDbSubnetGroupsOutput {
            crate::output::DescribeDbSubnetGroupsOutput {
                marker: self.marker,
                db_subnet_groups: self.db_subnet_groups,
            }
        }
    }
}
impl DescribeDbSubnetGroupsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeDbSubnetGroupsOutput`](crate::output::DescribeDbSubnetGroupsOutput)
    pub fn builder() -> crate::output::describe_db_subnet_groups_output::Builder {
        crate::output::describe_db_subnet_groups_output::Builder::default()
    }
}

/// <p>
/// Contains the result of a successful invocation of the <code>DescribeDBSnapshots</code> action.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDbSnapshotsOutput {
    /// <p>
    /// An optional pagination token provided by a previous request.
    /// If this parameter is specified, the response includes
    /// only records beyond the marker,
    /// up to the value specified by <code>MaxRecords</code>.
    /// </p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>
    /// A list of <code>DBSnapshot</code> instances.
    /// </p>
    pub db_snapshots: std::option::Option<std::vec::Vec<crate::model::DbSnapshot>>,
}
impl DescribeDbSnapshotsOutput {
    /// <p>
    /// An optional pagination token provided by a previous request.
    /// If this parameter is specified, the response includes
    /// only records beyond the marker,
    /// up to the value specified by <code>MaxRecords</code>.
    /// </p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>
    /// A list of <code>DBSnapshot</code> instances.
    /// </p>
    pub fn db_snapshots(&self) -> std::option::Option<&[crate::model::DbSnapshot]> {
        self.db_snapshots.as_deref()
    }
}
impl std::fmt::Debug for DescribeDbSnapshotsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDbSnapshotsOutput");
        formatter.field("marker", &self.marker);
        formatter.field("db_snapshots", &self.db_snapshots);
        formatter.finish()
    }
}
/// See [`DescribeDbSnapshotsOutput`](crate::output::DescribeDbSnapshotsOutput)
pub mod describe_db_snapshots_output {
    /// A builder for [`DescribeDbSnapshotsOutput`](crate::output::DescribeDbSnapshotsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) db_snapshots: std::option::Option<std::vec::Vec<crate::model::DbSnapshot>>,
    }
    impl Builder {
        /// <p>
        /// An optional pagination token provided by a previous request.
        /// If this parameter is specified, the response includes
        /// only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.
        /// </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>
        /// An optional pagination token provided by a previous request.
        /// If this parameter is specified, the response includes
        /// only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.
        /// </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Appends an item to `db_snapshots`.
        ///
        /// To override the contents of this collection use [`set_db_snapshots`](Self::set_db_snapshots).
        ///
        /// <p>
        /// A list of <code>DBSnapshot</code> instances.
        /// </p>
        pub fn db_snapshots(mut self, input: impl Into<crate::model::DbSnapshot>) -> Self {
            let mut v = self.db_snapshots.unwrap_or_default();
            v.push(input.into());
            self.db_snapshots = Some(v);
            self
        }
        /// <p>
        /// A list of <code>DBSnapshot</code> instances.
        /// </p>
        pub fn set_db_snapshots(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DbSnapshot>>,
        ) -> Self {
            self.db_snapshots = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDbSnapshotsOutput`](crate::output::DescribeDbSnapshotsOutput)
        pub fn build(self) -> crate::output::DescribeDbSnapshotsOutput {
            crate::output::DescribeDbSnapshotsOutput {
                marker: self.marker,
                db_snapshots: self.db_snapshots,
            }
        }
    }
}
impl DescribeDbSnapshotsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeDbSnapshotsOutput`](crate::output::DescribeDbSnapshotsOutput)
    pub fn builder() -> crate::output::describe_db_snapshots_output::Builder {
        crate::output::describe_db_snapshots_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDbSnapshotAttributesOutput {
    /// <p>Contains the results of a successful call to the <code>DescribeDBSnapshotAttributes</code>
    /// API action.</p>
    /// <p>Manual DB snapshot attributes are used to authorize other Amazon Web Services accounts
    /// to copy or restore a manual DB snapshot. For more information, see the <code>ModifyDBSnapshotAttribute</code>
    /// API action.</p>
    pub db_snapshot_attributes_result:
        std::option::Option<crate::model::DbSnapshotAttributesResult>,
}
impl DescribeDbSnapshotAttributesOutput {
    /// <p>Contains the results of a successful call to the <code>DescribeDBSnapshotAttributes</code>
    /// API action.</p>
    /// <p>Manual DB snapshot attributes are used to authorize other Amazon Web Services accounts
    /// to copy or restore a manual DB snapshot. For more information, see the <code>ModifyDBSnapshotAttribute</code>
    /// API action.</p>
    pub fn db_snapshot_attributes_result(
        &self,
    ) -> std::option::Option<&crate::model::DbSnapshotAttributesResult> {
        self.db_snapshot_attributes_result.as_ref()
    }
}
impl std::fmt::Debug for DescribeDbSnapshotAttributesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDbSnapshotAttributesOutput");
        formatter.field(
            "db_snapshot_attributes_result",
            &self.db_snapshot_attributes_result,
        );
        formatter.finish()
    }
}
/// See [`DescribeDbSnapshotAttributesOutput`](crate::output::DescribeDbSnapshotAttributesOutput)
pub mod describe_db_snapshot_attributes_output {
    /// A builder for [`DescribeDbSnapshotAttributesOutput`](crate::output::DescribeDbSnapshotAttributesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_snapshot_attributes_result:
            std::option::Option<crate::model::DbSnapshotAttributesResult>,
    }
    impl Builder {
        /// <p>Contains the results of a successful call to the <code>DescribeDBSnapshotAttributes</code>
        /// API action.</p>
        /// <p>Manual DB snapshot attributes are used to authorize other Amazon Web Services accounts
        /// to copy or restore a manual DB snapshot. For more information, see the <code>ModifyDBSnapshotAttribute</code>
        /// API action.</p>
        pub fn db_snapshot_attributes_result(
            mut self,
            input: crate::model::DbSnapshotAttributesResult,
        ) -> Self {
            self.db_snapshot_attributes_result = Some(input);
            self
        }
        /// <p>Contains the results of a successful call to the <code>DescribeDBSnapshotAttributes</code>
        /// API action.</p>
        /// <p>Manual DB snapshot attributes are used to authorize other Amazon Web Services accounts
        /// to copy or restore a manual DB snapshot. For more information, see the <code>ModifyDBSnapshotAttribute</code>
        /// API action.</p>
        pub fn set_db_snapshot_attributes_result(
            mut self,
            input: std::option::Option<crate::model::DbSnapshotAttributesResult>,
        ) -> Self {
            self.db_snapshot_attributes_result = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDbSnapshotAttributesOutput`](crate::output::DescribeDbSnapshotAttributesOutput)
        pub fn build(self) -> crate::output::DescribeDbSnapshotAttributesOutput {
            crate::output::DescribeDbSnapshotAttributesOutput {
                db_snapshot_attributes_result: self.db_snapshot_attributes_result,
            }
        }
    }
}
impl DescribeDbSnapshotAttributesOutput {
    /// Creates a new builder-style object to manufacture [`DescribeDbSnapshotAttributesOutput`](crate::output::DescribeDbSnapshotAttributesOutput)
    pub fn builder() -> crate::output::describe_db_snapshot_attributes_output::Builder {
        crate::output::describe_db_snapshot_attributes_output::Builder::default()
    }
}

/// <p>
/// Contains the result of a successful invocation of the <code>DescribeDBSecurityGroups</code> action.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDbSecurityGroupsOutput {
    /// <p>
    /// An optional pagination token provided by a previous request.
    /// If this parameter is specified, the response includes
    /// only records beyond the marker,
    /// up to the value specified by <code>MaxRecords</code>.
    /// </p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>
    /// A list of <code>DBSecurityGroup</code> instances.
    /// </p>
    pub db_security_groups: std::option::Option<std::vec::Vec<crate::model::DbSecurityGroup>>,
}
impl DescribeDbSecurityGroupsOutput {
    /// <p>
    /// An optional pagination token provided by a previous request.
    /// If this parameter is specified, the response includes
    /// only records beyond the marker,
    /// up to the value specified by <code>MaxRecords</code>.
    /// </p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>
    /// A list of <code>DBSecurityGroup</code> instances.
    /// </p>
    pub fn db_security_groups(&self) -> std::option::Option<&[crate::model::DbSecurityGroup]> {
        self.db_security_groups.as_deref()
    }
}
impl std::fmt::Debug for DescribeDbSecurityGroupsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDbSecurityGroupsOutput");
        formatter.field("marker", &self.marker);
        formatter.field("db_security_groups", &self.db_security_groups);
        formatter.finish()
    }
}
/// See [`DescribeDbSecurityGroupsOutput`](crate::output::DescribeDbSecurityGroupsOutput)
pub mod describe_db_security_groups_output {
    /// A builder for [`DescribeDbSecurityGroupsOutput`](crate::output::DescribeDbSecurityGroupsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) db_security_groups:
            std::option::Option<std::vec::Vec<crate::model::DbSecurityGroup>>,
    }
    impl Builder {
        /// <p>
        /// An optional pagination token provided by a previous request.
        /// If this parameter is specified, the response includes
        /// only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.
        /// </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>
        /// An optional pagination token provided by a previous request.
        /// If this parameter is specified, the response includes
        /// only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.
        /// </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Appends an item to `db_security_groups`.
        ///
        /// To override the contents of this collection use [`set_db_security_groups`](Self::set_db_security_groups).
        ///
        /// <p>
        /// A list of <code>DBSecurityGroup</code> instances.
        /// </p>
        pub fn db_security_groups(
            mut self,
            input: impl Into<crate::model::DbSecurityGroup>,
        ) -> Self {
            let mut v = self.db_security_groups.unwrap_or_default();
            v.push(input.into());
            self.db_security_groups = Some(v);
            self
        }
        /// <p>
        /// A list of <code>DBSecurityGroup</code> instances.
        /// </p>
        pub fn set_db_security_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DbSecurityGroup>>,
        ) -> Self {
            self.db_security_groups = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDbSecurityGroupsOutput`](crate::output::DescribeDbSecurityGroupsOutput)
        pub fn build(self) -> crate::output::DescribeDbSecurityGroupsOutput {
            crate::output::DescribeDbSecurityGroupsOutput {
                marker: self.marker,
                db_security_groups: self.db_security_groups,
            }
        }
    }
}
impl DescribeDbSecurityGroupsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeDbSecurityGroupsOutput`](crate::output::DescribeDbSecurityGroupsOutput)
    pub fn builder() -> crate::output::describe_db_security_groups_output::Builder {
        crate::output::describe_db_security_groups_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDbProxyTargetsOutput {
    /// <p>An arbitrary number of <code>DBProxyTarget</code> objects, containing details of the corresponding targets.</p>
    pub targets: std::option::Option<std::vec::Vec<crate::model::DbProxyTarget>>,
    /// <p>
    /// An optional pagination token provided by a previous request.
    /// If this parameter is specified, the response includes only records beyond the marker,
    /// up to the value specified by <code>MaxRecords</code>.
    /// </p>
    pub marker: std::option::Option<std::string::String>,
}
impl DescribeDbProxyTargetsOutput {
    /// <p>An arbitrary number of <code>DBProxyTarget</code> objects, containing details of the corresponding targets.</p>
    pub fn targets(&self) -> std::option::Option<&[crate::model::DbProxyTarget]> {
        self.targets.as_deref()
    }
    /// <p>
    /// An optional pagination token provided by a previous request.
    /// If this parameter is specified, the response includes only records beyond the marker,
    /// up to the value specified by <code>MaxRecords</code>.
    /// </p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for DescribeDbProxyTargetsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDbProxyTargetsOutput");
        formatter.field("targets", &self.targets);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}
/// See [`DescribeDbProxyTargetsOutput`](crate::output::DescribeDbProxyTargetsOutput)
pub mod describe_db_proxy_targets_output {
    /// A builder for [`DescribeDbProxyTargetsOutput`](crate::output::DescribeDbProxyTargetsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) targets: std::option::Option<std::vec::Vec<crate::model::DbProxyTarget>>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `targets`.
        ///
        /// To override the contents of this collection use [`set_targets`](Self::set_targets).
        ///
        /// <p>An arbitrary number of <code>DBProxyTarget</code> objects, containing details of the corresponding targets.</p>
        pub fn targets(mut self, input: impl Into<crate::model::DbProxyTarget>) -> Self {
            let mut v = self.targets.unwrap_or_default();
            v.push(input.into());
            self.targets = Some(v);
            self
        }
        /// <p>An arbitrary number of <code>DBProxyTarget</code> objects, containing details of the corresponding targets.</p>
        pub fn set_targets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DbProxyTarget>>,
        ) -> Self {
            self.targets = input;
            self
        }
        /// <p>
        /// An optional pagination token provided by a previous request.
        /// If this parameter is specified, the response includes only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.
        /// </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>
        /// An optional pagination token provided by a previous request.
        /// If this parameter is specified, the response includes only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.
        /// </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDbProxyTargetsOutput`](crate::output::DescribeDbProxyTargetsOutput)
        pub fn build(self) -> crate::output::DescribeDbProxyTargetsOutput {
            crate::output::DescribeDbProxyTargetsOutput {
                targets: self.targets,
                marker: self.marker,
            }
        }
    }
}
impl DescribeDbProxyTargetsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeDbProxyTargetsOutput`](crate::output::DescribeDbProxyTargetsOutput)
    pub fn builder() -> crate::output::describe_db_proxy_targets_output::Builder {
        crate::output::describe_db_proxy_targets_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDbProxyTargetGroupsOutput {
    /// <p>An arbitrary number of <code>DBProxyTargetGroup</code> objects, containing details of the corresponding target groups.</p>
    pub target_groups: std::option::Option<std::vec::Vec<crate::model::DbProxyTargetGroup>>,
    /// <p>
    /// An optional pagination token provided by a previous request.
    /// If this parameter is specified, the response includes only records beyond the marker,
    /// up to the value specified by <code>MaxRecords</code>.
    /// </p>
    pub marker: std::option::Option<std::string::String>,
}
impl DescribeDbProxyTargetGroupsOutput {
    /// <p>An arbitrary number of <code>DBProxyTargetGroup</code> objects, containing details of the corresponding target groups.</p>
    pub fn target_groups(&self) -> std::option::Option<&[crate::model::DbProxyTargetGroup]> {
        self.target_groups.as_deref()
    }
    /// <p>
    /// An optional pagination token provided by a previous request.
    /// If this parameter is specified, the response includes only records beyond the marker,
    /// up to the value specified by <code>MaxRecords</code>.
    /// </p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for DescribeDbProxyTargetGroupsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDbProxyTargetGroupsOutput");
        formatter.field("target_groups", &self.target_groups);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}
/// See [`DescribeDbProxyTargetGroupsOutput`](crate::output::DescribeDbProxyTargetGroupsOutput)
pub mod describe_db_proxy_target_groups_output {
    /// A builder for [`DescribeDbProxyTargetGroupsOutput`](crate::output::DescribeDbProxyTargetGroupsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) target_groups:
            std::option::Option<std::vec::Vec<crate::model::DbProxyTargetGroup>>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `target_groups`.
        ///
        /// To override the contents of this collection use [`set_target_groups`](Self::set_target_groups).
        ///
        /// <p>An arbitrary number of <code>DBProxyTargetGroup</code> objects, containing details of the corresponding target groups.</p>
        pub fn target_groups(mut self, input: impl Into<crate::model::DbProxyTargetGroup>) -> Self {
            let mut v = self.target_groups.unwrap_or_default();
            v.push(input.into());
            self.target_groups = Some(v);
            self
        }
        /// <p>An arbitrary number of <code>DBProxyTargetGroup</code> objects, containing details of the corresponding target groups.</p>
        pub fn set_target_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DbProxyTargetGroup>>,
        ) -> Self {
            self.target_groups = input;
            self
        }
        /// <p>
        /// An optional pagination token provided by a previous request.
        /// If this parameter is specified, the response includes only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.
        /// </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>
        /// An optional pagination token provided by a previous request.
        /// If this parameter is specified, the response includes only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.
        /// </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDbProxyTargetGroupsOutput`](crate::output::DescribeDbProxyTargetGroupsOutput)
        pub fn build(self) -> crate::output::DescribeDbProxyTargetGroupsOutput {
            crate::output::DescribeDbProxyTargetGroupsOutput {
                target_groups: self.target_groups,
                marker: self.marker,
            }
        }
    }
}
impl DescribeDbProxyTargetGroupsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeDbProxyTargetGroupsOutput`](crate::output::DescribeDbProxyTargetGroupsOutput)
    pub fn builder() -> crate::output::describe_db_proxy_target_groups_output::Builder {
        crate::output::describe_db_proxy_target_groups_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDbProxyEndpointsOutput {
    /// <p>The list of <code>ProxyEndpoint</code> objects returned by the API operation.</p>
    pub db_proxy_endpoints: std::option::Option<std::vec::Vec<crate::model::DbProxyEndpoint>>,
    /// <p>
    /// An optional pagination token provided by a previous request.
    /// If this parameter is specified, the response includes only records beyond the marker,
    /// up to the value specified by <code>MaxRecords</code>.
    /// </p>
    pub marker: std::option::Option<std::string::String>,
}
impl DescribeDbProxyEndpointsOutput {
    /// <p>The list of <code>ProxyEndpoint</code> objects returned by the API operation.</p>
    pub fn db_proxy_endpoints(&self) -> std::option::Option<&[crate::model::DbProxyEndpoint]> {
        self.db_proxy_endpoints.as_deref()
    }
    /// <p>
    /// An optional pagination token provided by a previous request.
    /// If this parameter is specified, the response includes only records beyond the marker,
    /// up to the value specified by <code>MaxRecords</code>.
    /// </p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for DescribeDbProxyEndpointsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDbProxyEndpointsOutput");
        formatter.field("db_proxy_endpoints", &self.db_proxy_endpoints);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}
/// See [`DescribeDbProxyEndpointsOutput`](crate::output::DescribeDbProxyEndpointsOutput)
pub mod describe_db_proxy_endpoints_output {
    /// A builder for [`DescribeDbProxyEndpointsOutput`](crate::output::DescribeDbProxyEndpointsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_proxy_endpoints:
            std::option::Option<std::vec::Vec<crate::model::DbProxyEndpoint>>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `db_proxy_endpoints`.
        ///
        /// To override the contents of this collection use [`set_db_proxy_endpoints`](Self::set_db_proxy_endpoints).
        ///
        /// <p>The list of <code>ProxyEndpoint</code> objects returned by the API operation.</p>
        pub fn db_proxy_endpoints(
            mut self,
            input: impl Into<crate::model::DbProxyEndpoint>,
        ) -> Self {
            let mut v = self.db_proxy_endpoints.unwrap_or_default();
            v.push(input.into());
            self.db_proxy_endpoints = Some(v);
            self
        }
        /// <p>The list of <code>ProxyEndpoint</code> objects returned by the API operation.</p>
        pub fn set_db_proxy_endpoints(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DbProxyEndpoint>>,
        ) -> Self {
            self.db_proxy_endpoints = input;
            self
        }
        /// <p>
        /// An optional pagination token provided by a previous request.
        /// If this parameter is specified, the response includes only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.
        /// </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>
        /// An optional pagination token provided by a previous request.
        /// If this parameter is specified, the response includes only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.
        /// </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDbProxyEndpointsOutput`](crate::output::DescribeDbProxyEndpointsOutput)
        pub fn build(self) -> crate::output::DescribeDbProxyEndpointsOutput {
            crate::output::DescribeDbProxyEndpointsOutput {
                db_proxy_endpoints: self.db_proxy_endpoints,
                marker: self.marker,
            }
        }
    }
}
impl DescribeDbProxyEndpointsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeDbProxyEndpointsOutput`](crate::output::DescribeDbProxyEndpointsOutput)
    pub fn builder() -> crate::output::describe_db_proxy_endpoints_output::Builder {
        crate::output::describe_db_proxy_endpoints_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDbProxiesOutput {
    /// <p>A return value representing an arbitrary number of <code>DBProxy</code> data structures.</p>
    pub db_proxies: std::option::Option<std::vec::Vec<crate::model::DbProxy>>,
    /// <p>
    /// An optional pagination token provided by a previous request.
    /// If this parameter is specified, the response includes only records beyond the marker,
    /// up to the value specified by <code>MaxRecords</code>.
    /// </p>
    pub marker: std::option::Option<std::string::String>,
}
impl DescribeDbProxiesOutput {
    /// <p>A return value representing an arbitrary number of <code>DBProxy</code> data structures.</p>
    pub fn db_proxies(&self) -> std::option::Option<&[crate::model::DbProxy]> {
        self.db_proxies.as_deref()
    }
    /// <p>
    /// An optional pagination token provided by a previous request.
    /// If this parameter is specified, the response includes only records beyond the marker,
    /// up to the value specified by <code>MaxRecords</code>.
    /// </p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for DescribeDbProxiesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDbProxiesOutput");
        formatter.field("db_proxies", &self.db_proxies);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}
/// See [`DescribeDbProxiesOutput`](crate::output::DescribeDbProxiesOutput)
pub mod describe_db_proxies_output {
    /// A builder for [`DescribeDbProxiesOutput`](crate::output::DescribeDbProxiesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_proxies: std::option::Option<std::vec::Vec<crate::model::DbProxy>>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `db_proxies`.
        ///
        /// To override the contents of this collection use [`set_db_proxies`](Self::set_db_proxies).
        ///
        /// <p>A return value representing an arbitrary number of <code>DBProxy</code> data structures.</p>
        pub fn db_proxies(mut self, input: impl Into<crate::model::DbProxy>) -> Self {
            let mut v = self.db_proxies.unwrap_or_default();
            v.push(input.into());
            self.db_proxies = Some(v);
            self
        }
        /// <p>A return value representing an arbitrary number of <code>DBProxy</code> data structures.</p>
        pub fn set_db_proxies(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DbProxy>>,
        ) -> Self {
            self.db_proxies = input;
            self
        }
        /// <p>
        /// An optional pagination token provided by a previous request.
        /// If this parameter is specified, the response includes only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.
        /// </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>
        /// An optional pagination token provided by a previous request.
        /// If this parameter is specified, the response includes only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.
        /// </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDbProxiesOutput`](crate::output::DescribeDbProxiesOutput)
        pub fn build(self) -> crate::output::DescribeDbProxiesOutput {
            crate::output::DescribeDbProxiesOutput {
                db_proxies: self.db_proxies,
                marker: self.marker,
            }
        }
    }
}
impl DescribeDbProxiesOutput {
    /// Creates a new builder-style object to manufacture [`DescribeDbProxiesOutput`](crate::output::DescribeDbProxiesOutput)
    pub fn builder() -> crate::output::describe_db_proxies_output::Builder {
        crate::output::describe_db_proxies_output::Builder::default()
    }
}

/// <p>
/// Contains the result of a successful invocation of the <code>DescribeDBParameters</code> action.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDbParametersOutput {
    /// <p>
    /// A list of <code>Parameter</code> values.
    /// </p>
    pub parameters: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
    /// <p>
    /// An optional pagination token provided by a previous request.
    /// If this parameter is specified, the response includes
    /// only records beyond the marker,
    /// up to the value specified by <code>MaxRecords</code>.
    /// </p>
    pub marker: std::option::Option<std::string::String>,
}
impl DescribeDbParametersOutput {
    /// <p>
    /// A list of <code>Parameter</code> values.
    /// </p>
    pub fn parameters(&self) -> std::option::Option<&[crate::model::Parameter]> {
        self.parameters.as_deref()
    }
    /// <p>
    /// An optional pagination token provided by a previous request.
    /// If this parameter is specified, the response includes
    /// only records beyond the marker,
    /// up to the value specified by <code>MaxRecords</code>.
    /// </p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for DescribeDbParametersOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDbParametersOutput");
        formatter.field("parameters", &self.parameters);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}
/// See [`DescribeDbParametersOutput`](crate::output::DescribeDbParametersOutput)
pub mod describe_db_parameters_output {
    /// A builder for [`DescribeDbParametersOutput`](crate::output::DescribeDbParametersOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) parameters: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>
        /// A list of <code>Parameter</code> values.
        /// </p>
        pub fn parameters(mut self, input: impl Into<crate::model::Parameter>) -> Self {
            let mut v = self.parameters.unwrap_or_default();
            v.push(input.into());
            self.parameters = Some(v);
            self
        }
        /// <p>
        /// A list of <code>Parameter</code> values.
        /// </p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
        ) -> Self {
            self.parameters = input;
            self
        }
        /// <p>
        /// An optional pagination token provided by a previous request.
        /// If this parameter is specified, the response includes
        /// only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.
        /// </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>
        /// An optional pagination token provided by a previous request.
        /// If this parameter is specified, the response includes
        /// only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.
        /// </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDbParametersOutput`](crate::output::DescribeDbParametersOutput)
        pub fn build(self) -> crate::output::DescribeDbParametersOutput {
            crate::output::DescribeDbParametersOutput {
                parameters: self.parameters,
                marker: self.marker,
            }
        }
    }
}
impl DescribeDbParametersOutput {
    /// Creates a new builder-style object to manufacture [`DescribeDbParametersOutput`](crate::output::DescribeDbParametersOutput)
    pub fn builder() -> crate::output::describe_db_parameters_output::Builder {
        crate::output::describe_db_parameters_output::Builder::default()
    }
}

/// <p>
/// Contains the result of a successful invocation of the <code>DescribeDBParameterGroups</code> action.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDbParameterGroupsOutput {
    /// <p>
    /// An optional pagination token provided by a previous request.
    /// If this parameter is specified, the response includes
    /// only records beyond the marker,
    /// up to the value specified by <code>MaxRecords</code>.
    /// </p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>
    /// A list of <code>DBParameterGroup</code> instances.
    /// </p>
    pub db_parameter_groups: std::option::Option<std::vec::Vec<crate::model::DbParameterGroup>>,
}
impl DescribeDbParameterGroupsOutput {
    /// <p>
    /// An optional pagination token provided by a previous request.
    /// If this parameter is specified, the response includes
    /// only records beyond the marker,
    /// up to the value specified by <code>MaxRecords</code>.
    /// </p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>
    /// A list of <code>DBParameterGroup</code> instances.
    /// </p>
    pub fn db_parameter_groups(&self) -> std::option::Option<&[crate::model::DbParameterGroup]> {
        self.db_parameter_groups.as_deref()
    }
}
impl std::fmt::Debug for DescribeDbParameterGroupsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDbParameterGroupsOutput");
        formatter.field("marker", &self.marker);
        formatter.field("db_parameter_groups", &self.db_parameter_groups);
        formatter.finish()
    }
}
/// See [`DescribeDbParameterGroupsOutput`](crate::output::DescribeDbParameterGroupsOutput)
pub mod describe_db_parameter_groups_output {
    /// A builder for [`DescribeDbParameterGroupsOutput`](crate::output::DescribeDbParameterGroupsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) db_parameter_groups:
            std::option::Option<std::vec::Vec<crate::model::DbParameterGroup>>,
    }
    impl Builder {
        /// <p>
        /// An optional pagination token provided by a previous request.
        /// If this parameter is specified, the response includes
        /// only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.
        /// </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>
        /// An optional pagination token provided by a previous request.
        /// If this parameter is specified, the response includes
        /// only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.
        /// </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Appends an item to `db_parameter_groups`.
        ///
        /// To override the contents of this collection use [`set_db_parameter_groups`](Self::set_db_parameter_groups).
        ///
        /// <p>
        /// A list of <code>DBParameterGroup</code> instances.
        /// </p>
        pub fn db_parameter_groups(
            mut self,
            input: impl Into<crate::model::DbParameterGroup>,
        ) -> Self {
            let mut v = self.db_parameter_groups.unwrap_or_default();
            v.push(input.into());
            self.db_parameter_groups = Some(v);
            self
        }
        /// <p>
        /// A list of <code>DBParameterGroup</code> instances.
        /// </p>
        pub fn set_db_parameter_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DbParameterGroup>>,
        ) -> Self {
            self.db_parameter_groups = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDbParameterGroupsOutput`](crate::output::DescribeDbParameterGroupsOutput)
        pub fn build(self) -> crate::output::DescribeDbParameterGroupsOutput {
            crate::output::DescribeDbParameterGroupsOutput {
                marker: self.marker,
                db_parameter_groups: self.db_parameter_groups,
            }
        }
    }
}
impl DescribeDbParameterGroupsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeDbParameterGroupsOutput`](crate::output::DescribeDbParameterGroupsOutput)
    pub fn builder() -> crate::output::describe_db_parameter_groups_output::Builder {
        crate::output::describe_db_parameter_groups_output::Builder::default()
    }
}

/// <p>
/// The response from a call to <code>DescribeDBLogFiles</code>.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDbLogFilesOutput {
    /// <p>The DB log files returned.</p>
    pub describe_db_log_files:
        std::option::Option<std::vec::Vec<crate::model::DescribeDbLogFilesDetails>>,
    /// <p>A pagination token that can be used in a later DescribeDBLogFiles request.</p>
    pub marker: std::option::Option<std::string::String>,
}
impl DescribeDbLogFilesOutput {
    /// <p>The DB log files returned.</p>
    pub fn describe_db_log_files(
        &self,
    ) -> std::option::Option<&[crate::model::DescribeDbLogFilesDetails]> {
        self.describe_db_log_files.as_deref()
    }
    /// <p>A pagination token that can be used in a later DescribeDBLogFiles request.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for DescribeDbLogFilesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDbLogFilesOutput");
        formatter.field("describe_db_log_files", &self.describe_db_log_files);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}
/// See [`DescribeDbLogFilesOutput`](crate::output::DescribeDbLogFilesOutput)
pub mod describe_db_log_files_output {
    /// A builder for [`DescribeDbLogFilesOutput`](crate::output::DescribeDbLogFilesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) describe_db_log_files:
            std::option::Option<std::vec::Vec<crate::model::DescribeDbLogFilesDetails>>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `describe_db_log_files`.
        ///
        /// To override the contents of this collection use [`set_describe_db_log_files`](Self::set_describe_db_log_files).
        ///
        /// <p>The DB log files returned.</p>
        pub fn describe_db_log_files(
            mut self,
            input: impl Into<crate::model::DescribeDbLogFilesDetails>,
        ) -> Self {
            let mut v = self.describe_db_log_files.unwrap_or_default();
            v.push(input.into());
            self.describe_db_log_files = Some(v);
            self
        }
        /// <p>The DB log files returned.</p>
        pub fn set_describe_db_log_files(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DescribeDbLogFilesDetails>>,
        ) -> Self {
            self.describe_db_log_files = input;
            self
        }
        /// <p>A pagination token that can be used in a later DescribeDBLogFiles request.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>A pagination token that can be used in a later DescribeDBLogFiles request.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDbLogFilesOutput`](crate::output::DescribeDbLogFilesOutput)
        pub fn build(self) -> crate::output::DescribeDbLogFilesOutput {
            crate::output::DescribeDbLogFilesOutput {
                describe_db_log_files: self.describe_db_log_files,
                marker: self.marker,
            }
        }
    }
}
impl DescribeDbLogFilesOutput {
    /// Creates a new builder-style object to manufacture [`DescribeDbLogFilesOutput`](crate::output::DescribeDbLogFilesOutput)
    pub fn builder() -> crate::output::describe_db_log_files_output::Builder {
        crate::output::describe_db_log_files_output::Builder::default()
    }
}

/// <p>
/// Contains the result of a successful invocation of the <code>DescribeDBInstances</code> action.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDbInstancesOutput {
    /// <p>
    /// An optional pagination token provided by a previous request.
    /// If this parameter is specified, the response includes
    /// only records beyond the marker,
    /// up to the value specified by <code>MaxRecords</code> .
    /// </p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>
    /// A list of <code>DBInstance</code> instances.
    /// </p>
    pub db_instances: std::option::Option<std::vec::Vec<crate::model::DbInstance>>,
}
impl DescribeDbInstancesOutput {
    /// <p>
    /// An optional pagination token provided by a previous request.
    /// If this parameter is specified, the response includes
    /// only records beyond the marker,
    /// up to the value specified by <code>MaxRecords</code> .
    /// </p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>
    /// A list of <code>DBInstance</code> instances.
    /// </p>
    pub fn db_instances(&self) -> std::option::Option<&[crate::model::DbInstance]> {
        self.db_instances.as_deref()
    }
}
impl std::fmt::Debug for DescribeDbInstancesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDbInstancesOutput");
        formatter.field("marker", &self.marker);
        formatter.field("db_instances", &self.db_instances);
        formatter.finish()
    }
}
/// See [`DescribeDbInstancesOutput`](crate::output::DescribeDbInstancesOutput)
pub mod describe_db_instances_output {
    /// A builder for [`DescribeDbInstancesOutput`](crate::output::DescribeDbInstancesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) db_instances: std::option::Option<std::vec::Vec<crate::model::DbInstance>>,
    }
    impl Builder {
        /// <p>
        /// An optional pagination token provided by a previous request.
        /// If this parameter is specified, the response includes
        /// only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code> .
        /// </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>
        /// An optional pagination token provided by a previous request.
        /// If this parameter is specified, the response includes
        /// only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code> .
        /// </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Appends an item to `db_instances`.
        ///
        /// To override the contents of this collection use [`set_db_instances`](Self::set_db_instances).
        ///
        /// <p>
        /// A list of <code>DBInstance</code> instances.
        /// </p>
        pub fn db_instances(mut self, input: impl Into<crate::model::DbInstance>) -> Self {
            let mut v = self.db_instances.unwrap_or_default();
            v.push(input.into());
            self.db_instances = Some(v);
            self
        }
        /// <p>
        /// A list of <code>DBInstance</code> instances.
        /// </p>
        pub fn set_db_instances(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DbInstance>>,
        ) -> Self {
            self.db_instances = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDbInstancesOutput`](crate::output::DescribeDbInstancesOutput)
        pub fn build(self) -> crate::output::DescribeDbInstancesOutput {
            crate::output::DescribeDbInstancesOutput {
                marker: self.marker,
                db_instances: self.db_instances,
            }
        }
    }
}
impl DescribeDbInstancesOutput {
    /// Creates a new builder-style object to manufacture [`DescribeDbInstancesOutput`](crate::output::DescribeDbInstancesOutput)
    pub fn builder() -> crate::output::describe_db_instances_output::Builder {
        crate::output::describe_db_instances_output::Builder::default()
    }
}

/// <p>
/// Contains the result of a successful invocation of the <code>DescribeDBInstanceAutomatedBackups</code> action.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDbInstanceAutomatedBackupsOutput {
    /// <p>
    /// An optional pagination token provided by a previous request.
    /// If this parameter is specified, the response includes
    /// only records beyond the marker,
    /// up to the value specified by <code>MaxRecords</code> .
    /// </p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>
    /// A list of <code>DBInstanceAutomatedBackup</code> instances.
    /// </p>
    pub db_instance_automated_backups:
        std::option::Option<std::vec::Vec<crate::model::DbInstanceAutomatedBackup>>,
}
impl DescribeDbInstanceAutomatedBackupsOutput {
    /// <p>
    /// An optional pagination token provided by a previous request.
    /// If this parameter is specified, the response includes
    /// only records beyond the marker,
    /// up to the value specified by <code>MaxRecords</code> .
    /// </p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>
    /// A list of <code>DBInstanceAutomatedBackup</code> instances.
    /// </p>
    pub fn db_instance_automated_backups(
        &self,
    ) -> std::option::Option<&[crate::model::DbInstanceAutomatedBackup]> {
        self.db_instance_automated_backups.as_deref()
    }
}
impl std::fmt::Debug for DescribeDbInstanceAutomatedBackupsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDbInstanceAutomatedBackupsOutput");
        formatter.field("marker", &self.marker);
        formatter.field(
            "db_instance_automated_backups",
            &self.db_instance_automated_backups,
        );
        formatter.finish()
    }
}
/// See [`DescribeDbInstanceAutomatedBackupsOutput`](crate::output::DescribeDbInstanceAutomatedBackupsOutput)
pub mod describe_db_instance_automated_backups_output {
    /// A builder for [`DescribeDbInstanceAutomatedBackupsOutput`](crate::output::DescribeDbInstanceAutomatedBackupsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) db_instance_automated_backups:
            std::option::Option<std::vec::Vec<crate::model::DbInstanceAutomatedBackup>>,
    }
    impl Builder {
        /// <p>
        /// An optional pagination token provided by a previous request.
        /// If this parameter is specified, the response includes
        /// only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code> .
        /// </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>
        /// An optional pagination token provided by a previous request.
        /// If this parameter is specified, the response includes
        /// only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code> .
        /// </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Appends an item to `db_instance_automated_backups`.
        ///
        /// To override the contents of this collection use [`set_db_instance_automated_backups`](Self::set_db_instance_automated_backups).
        ///
        /// <p>
        /// A list of <code>DBInstanceAutomatedBackup</code> instances.
        /// </p>
        pub fn db_instance_automated_backups(
            mut self,
            input: impl Into<crate::model::DbInstanceAutomatedBackup>,
        ) -> Self {
            let mut v = self.db_instance_automated_backups.unwrap_or_default();
            v.push(input.into());
            self.db_instance_automated_backups = Some(v);
            self
        }
        /// <p>
        /// A list of <code>DBInstanceAutomatedBackup</code> instances.
        /// </p>
        pub fn set_db_instance_automated_backups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DbInstanceAutomatedBackup>>,
        ) -> Self {
            self.db_instance_automated_backups = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDbInstanceAutomatedBackupsOutput`](crate::output::DescribeDbInstanceAutomatedBackupsOutput)
        pub fn build(self) -> crate::output::DescribeDbInstanceAutomatedBackupsOutput {
            crate::output::DescribeDbInstanceAutomatedBackupsOutput {
                marker: self.marker,
                db_instance_automated_backups: self.db_instance_automated_backups,
            }
        }
    }
}
impl DescribeDbInstanceAutomatedBackupsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeDbInstanceAutomatedBackupsOutput`](crate::output::DescribeDbInstanceAutomatedBackupsOutput)
    pub fn builder() -> crate::output::describe_db_instance_automated_backups_output::Builder {
        crate::output::describe_db_instance_automated_backups_output::Builder::default()
    }
}

/// <p>
/// Contains the result of a successful invocation of the <code>DescribeDBEngineVersions</code> action.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDbEngineVersionsOutput {
    /// <p>
    /// An optional pagination token provided by a previous request.
    /// If this parameter is specified, the response includes
    /// only records beyond the marker,
    /// up to the value specified by <code>MaxRecords</code>.
    /// </p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>
    /// A list of <code>DBEngineVersion</code> elements.
    /// </p>
    pub db_engine_versions: std::option::Option<std::vec::Vec<crate::model::DbEngineVersion>>,
}
impl DescribeDbEngineVersionsOutput {
    /// <p>
    /// An optional pagination token provided by a previous request.
    /// If this parameter is specified, the response includes
    /// only records beyond the marker,
    /// up to the value specified by <code>MaxRecords</code>.
    /// </p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>
    /// A list of <code>DBEngineVersion</code> elements.
    /// </p>
    pub fn db_engine_versions(&self) -> std::option::Option<&[crate::model::DbEngineVersion]> {
        self.db_engine_versions.as_deref()
    }
}
impl std::fmt::Debug for DescribeDbEngineVersionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDbEngineVersionsOutput");
        formatter.field("marker", &self.marker);
        formatter.field("db_engine_versions", &self.db_engine_versions);
        formatter.finish()
    }
}
/// See [`DescribeDbEngineVersionsOutput`](crate::output::DescribeDbEngineVersionsOutput)
pub mod describe_db_engine_versions_output {
    /// A builder for [`DescribeDbEngineVersionsOutput`](crate::output::DescribeDbEngineVersionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) db_engine_versions:
            std::option::Option<std::vec::Vec<crate::model::DbEngineVersion>>,
    }
    impl Builder {
        /// <p>
        /// An optional pagination token provided by a previous request.
        /// If this parameter is specified, the response includes
        /// only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.
        /// </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>
        /// An optional pagination token provided by a previous request.
        /// If this parameter is specified, the response includes
        /// only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.
        /// </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Appends an item to `db_engine_versions`.
        ///
        /// To override the contents of this collection use [`set_db_engine_versions`](Self::set_db_engine_versions).
        ///
        /// <p>
        /// A list of <code>DBEngineVersion</code> elements.
        /// </p>
        pub fn db_engine_versions(
            mut self,
            input: impl Into<crate::model::DbEngineVersion>,
        ) -> Self {
            let mut v = self.db_engine_versions.unwrap_or_default();
            v.push(input.into());
            self.db_engine_versions = Some(v);
            self
        }
        /// <p>
        /// A list of <code>DBEngineVersion</code> elements.
        /// </p>
        pub fn set_db_engine_versions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DbEngineVersion>>,
        ) -> Self {
            self.db_engine_versions = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDbEngineVersionsOutput`](crate::output::DescribeDbEngineVersionsOutput)
        pub fn build(self) -> crate::output::DescribeDbEngineVersionsOutput {
            crate::output::DescribeDbEngineVersionsOutput {
                marker: self.marker,
                db_engine_versions: self.db_engine_versions,
            }
        }
    }
}
impl DescribeDbEngineVersionsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeDbEngineVersionsOutput`](crate::output::DescribeDbEngineVersionsOutput)
    pub fn builder() -> crate::output::describe_db_engine_versions_output::Builder {
        crate::output::describe_db_engine_versions_output::Builder::default()
    }
}

/// <p>
/// Provides a list of DB cluster snapshots for the user as the result of a call to the <code>DescribeDBClusterSnapshots</code> action.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDbClusterSnapshotsOutput {
    /// <p>
    /// An optional pagination token provided by a previous
    /// <code>DescribeDBClusterSnapshots</code> request.
    /// If this parameter is specified, the response includes
    /// only records beyond the marker,
    /// up to the value specified by <code>MaxRecords</code>.
    /// </p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>Provides a list of DB cluster snapshots for the user.</p>
    pub db_cluster_snapshots: std::option::Option<std::vec::Vec<crate::model::DbClusterSnapshot>>,
}
impl DescribeDbClusterSnapshotsOutput {
    /// <p>
    /// An optional pagination token provided by a previous
    /// <code>DescribeDBClusterSnapshots</code> request.
    /// If this parameter is specified, the response includes
    /// only records beyond the marker,
    /// up to the value specified by <code>MaxRecords</code>.
    /// </p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>Provides a list of DB cluster snapshots for the user.</p>
    pub fn db_cluster_snapshots(&self) -> std::option::Option<&[crate::model::DbClusterSnapshot]> {
        self.db_cluster_snapshots.as_deref()
    }
}
impl std::fmt::Debug for DescribeDbClusterSnapshotsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDbClusterSnapshotsOutput");
        formatter.field("marker", &self.marker);
        formatter.field("db_cluster_snapshots", &self.db_cluster_snapshots);
        formatter.finish()
    }
}
/// See [`DescribeDbClusterSnapshotsOutput`](crate::output::DescribeDbClusterSnapshotsOutput)
pub mod describe_db_cluster_snapshots_output {
    /// A builder for [`DescribeDbClusterSnapshotsOutput`](crate::output::DescribeDbClusterSnapshotsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) db_cluster_snapshots:
            std::option::Option<std::vec::Vec<crate::model::DbClusterSnapshot>>,
    }
    impl Builder {
        /// <p>
        /// An optional pagination token provided by a previous
        /// <code>DescribeDBClusterSnapshots</code> request.
        /// If this parameter is specified, the response includes
        /// only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.
        /// </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>
        /// An optional pagination token provided by a previous
        /// <code>DescribeDBClusterSnapshots</code> request.
        /// If this parameter is specified, the response includes
        /// only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.
        /// </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Appends an item to `db_cluster_snapshots`.
        ///
        /// To override the contents of this collection use [`set_db_cluster_snapshots`](Self::set_db_cluster_snapshots).
        ///
        /// <p>Provides a list of DB cluster snapshots for the user.</p>
        pub fn db_cluster_snapshots(
            mut self,
            input: impl Into<crate::model::DbClusterSnapshot>,
        ) -> Self {
            let mut v = self.db_cluster_snapshots.unwrap_or_default();
            v.push(input.into());
            self.db_cluster_snapshots = Some(v);
            self
        }
        /// <p>Provides a list of DB cluster snapshots for the user.</p>
        pub fn set_db_cluster_snapshots(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DbClusterSnapshot>>,
        ) -> Self {
            self.db_cluster_snapshots = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDbClusterSnapshotsOutput`](crate::output::DescribeDbClusterSnapshotsOutput)
        pub fn build(self) -> crate::output::DescribeDbClusterSnapshotsOutput {
            crate::output::DescribeDbClusterSnapshotsOutput {
                marker: self.marker,
                db_cluster_snapshots: self.db_cluster_snapshots,
            }
        }
    }
}
impl DescribeDbClusterSnapshotsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeDbClusterSnapshotsOutput`](crate::output::DescribeDbClusterSnapshotsOutput)
    pub fn builder() -> crate::output::describe_db_cluster_snapshots_output::Builder {
        crate::output::describe_db_cluster_snapshots_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDbClusterSnapshotAttributesOutput {
    /// <p>Contains the results of a successful call to the <code>DescribeDBClusterSnapshotAttributes</code>
    /// API action.</p>
    /// <p>Manual DB cluster snapshot attributes are used to authorize other Amazon Web Services accounts
    /// to copy or restore a manual DB cluster snapshot. For more information, see the <code>ModifyDBClusterSnapshotAttribute</code>
    /// API action.</p>
    pub db_cluster_snapshot_attributes_result:
        std::option::Option<crate::model::DbClusterSnapshotAttributesResult>,
}
impl DescribeDbClusterSnapshotAttributesOutput {
    /// <p>Contains the results of a successful call to the <code>DescribeDBClusterSnapshotAttributes</code>
    /// API action.</p>
    /// <p>Manual DB cluster snapshot attributes are used to authorize other Amazon Web Services accounts
    /// to copy or restore a manual DB cluster snapshot. For more information, see the <code>ModifyDBClusterSnapshotAttribute</code>
    /// API action.</p>
    pub fn db_cluster_snapshot_attributes_result(
        &self,
    ) -> std::option::Option<&crate::model::DbClusterSnapshotAttributesResult> {
        self.db_cluster_snapshot_attributes_result.as_ref()
    }
}
impl std::fmt::Debug for DescribeDbClusterSnapshotAttributesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDbClusterSnapshotAttributesOutput");
        formatter.field(
            "db_cluster_snapshot_attributes_result",
            &self.db_cluster_snapshot_attributes_result,
        );
        formatter.finish()
    }
}
/// See [`DescribeDbClusterSnapshotAttributesOutput`](crate::output::DescribeDbClusterSnapshotAttributesOutput)
pub mod describe_db_cluster_snapshot_attributes_output {
    /// A builder for [`DescribeDbClusterSnapshotAttributesOutput`](crate::output::DescribeDbClusterSnapshotAttributesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster_snapshot_attributes_result:
            std::option::Option<crate::model::DbClusterSnapshotAttributesResult>,
    }
    impl Builder {
        /// <p>Contains the results of a successful call to the <code>DescribeDBClusterSnapshotAttributes</code>
        /// API action.</p>
        /// <p>Manual DB cluster snapshot attributes are used to authorize other Amazon Web Services accounts
        /// to copy or restore a manual DB cluster snapshot. For more information, see the <code>ModifyDBClusterSnapshotAttribute</code>
        /// API action.</p>
        pub fn db_cluster_snapshot_attributes_result(
            mut self,
            input: crate::model::DbClusterSnapshotAttributesResult,
        ) -> Self {
            self.db_cluster_snapshot_attributes_result = Some(input);
            self
        }
        /// <p>Contains the results of a successful call to the <code>DescribeDBClusterSnapshotAttributes</code>
        /// API action.</p>
        /// <p>Manual DB cluster snapshot attributes are used to authorize other Amazon Web Services accounts
        /// to copy or restore a manual DB cluster snapshot. For more information, see the <code>ModifyDBClusterSnapshotAttribute</code>
        /// API action.</p>
        pub fn set_db_cluster_snapshot_attributes_result(
            mut self,
            input: std::option::Option<crate::model::DbClusterSnapshotAttributesResult>,
        ) -> Self {
            self.db_cluster_snapshot_attributes_result = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDbClusterSnapshotAttributesOutput`](crate::output::DescribeDbClusterSnapshotAttributesOutput)
        pub fn build(self) -> crate::output::DescribeDbClusterSnapshotAttributesOutput {
            crate::output::DescribeDbClusterSnapshotAttributesOutput {
                db_cluster_snapshot_attributes_result: self.db_cluster_snapshot_attributes_result,
            }
        }
    }
}
impl DescribeDbClusterSnapshotAttributesOutput {
    /// Creates a new builder-style object to manufacture [`DescribeDbClusterSnapshotAttributesOutput`](crate::output::DescribeDbClusterSnapshotAttributesOutput)
    pub fn builder() -> crate::output::describe_db_cluster_snapshot_attributes_output::Builder {
        crate::output::describe_db_cluster_snapshot_attributes_output::Builder::default()
    }
}

/// <p>Contains the result of a successful invocation of the <code>DescribeDBClusters</code> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDbClustersOutput {
    /// <p>A pagination token that can be used in a later DescribeDBClusters request.</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>Contains a list of DB clusters for the user.</p>
    pub db_clusters: std::option::Option<std::vec::Vec<crate::model::DbCluster>>,
}
impl DescribeDbClustersOutput {
    /// <p>A pagination token that can be used in a later DescribeDBClusters request.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>Contains a list of DB clusters for the user.</p>
    pub fn db_clusters(&self) -> std::option::Option<&[crate::model::DbCluster]> {
        self.db_clusters.as_deref()
    }
}
impl std::fmt::Debug for DescribeDbClustersOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDbClustersOutput");
        formatter.field("marker", &self.marker);
        formatter.field("db_clusters", &self.db_clusters);
        formatter.finish()
    }
}
/// See [`DescribeDbClustersOutput`](crate::output::DescribeDbClustersOutput)
pub mod describe_db_clusters_output {
    /// A builder for [`DescribeDbClustersOutput`](crate::output::DescribeDbClustersOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) db_clusters: std::option::Option<std::vec::Vec<crate::model::DbCluster>>,
    }
    impl Builder {
        /// <p>A pagination token that can be used in a later DescribeDBClusters request.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>A pagination token that can be used in a later DescribeDBClusters request.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Appends an item to `db_clusters`.
        ///
        /// To override the contents of this collection use [`set_db_clusters`](Self::set_db_clusters).
        ///
        /// <p>Contains a list of DB clusters for the user.</p>
        pub fn db_clusters(mut self, input: impl Into<crate::model::DbCluster>) -> Self {
            let mut v = self.db_clusters.unwrap_or_default();
            v.push(input.into());
            self.db_clusters = Some(v);
            self
        }
        /// <p>Contains a list of DB clusters for the user.</p>
        pub fn set_db_clusters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DbCluster>>,
        ) -> Self {
            self.db_clusters = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDbClustersOutput`](crate::output::DescribeDbClustersOutput)
        pub fn build(self) -> crate::output::DescribeDbClustersOutput {
            crate::output::DescribeDbClustersOutput {
                marker: self.marker,
                db_clusters: self.db_clusters,
            }
        }
    }
}
impl DescribeDbClustersOutput {
    /// Creates a new builder-style object to manufacture [`DescribeDbClustersOutput`](crate::output::DescribeDbClustersOutput)
    pub fn builder() -> crate::output::describe_db_clusters_output::Builder {
        crate::output::describe_db_clusters_output::Builder::default()
    }
}

/// <p>Provides details about a DB cluster parameter group including the parameters in the DB cluster parameter group.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDbClusterParametersOutput {
    /// <p>Provides a list of parameters for the DB cluster parameter group.</p>
    pub parameters: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
    /// <p>
    /// An optional pagination token provided by a previous
    /// DescribeDBClusterParameters request.
    /// If this parameter is specified, the response includes
    /// only records beyond the marker,
    /// up to the value specified by <code>MaxRecords</code> .
    /// </p>
    pub marker: std::option::Option<std::string::String>,
}
impl DescribeDbClusterParametersOutput {
    /// <p>Provides a list of parameters for the DB cluster parameter group.</p>
    pub fn parameters(&self) -> std::option::Option<&[crate::model::Parameter]> {
        self.parameters.as_deref()
    }
    /// <p>
    /// An optional pagination token provided by a previous
    /// DescribeDBClusterParameters request.
    /// If this parameter is specified, the response includes
    /// only records beyond the marker,
    /// up to the value specified by <code>MaxRecords</code> .
    /// </p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for DescribeDbClusterParametersOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDbClusterParametersOutput");
        formatter.field("parameters", &self.parameters);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}
/// See [`DescribeDbClusterParametersOutput`](crate::output::DescribeDbClusterParametersOutput)
pub mod describe_db_cluster_parameters_output {
    /// A builder for [`DescribeDbClusterParametersOutput`](crate::output::DescribeDbClusterParametersOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) parameters: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>Provides a list of parameters for the DB cluster parameter group.</p>
        pub fn parameters(mut self, input: impl Into<crate::model::Parameter>) -> Self {
            let mut v = self.parameters.unwrap_or_default();
            v.push(input.into());
            self.parameters = Some(v);
            self
        }
        /// <p>Provides a list of parameters for the DB cluster parameter group.</p>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Parameter>>,
        ) -> Self {
            self.parameters = input;
            self
        }
        /// <p>
        /// An optional pagination token provided by a previous
        /// DescribeDBClusterParameters request.
        /// If this parameter is specified, the response includes
        /// only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code> .
        /// </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>
        /// An optional pagination token provided by a previous
        /// DescribeDBClusterParameters request.
        /// If this parameter is specified, the response includes
        /// only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code> .
        /// </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDbClusterParametersOutput`](crate::output::DescribeDbClusterParametersOutput)
        pub fn build(self) -> crate::output::DescribeDbClusterParametersOutput {
            crate::output::DescribeDbClusterParametersOutput {
                parameters: self.parameters,
                marker: self.marker,
            }
        }
    }
}
impl DescribeDbClusterParametersOutput {
    /// Creates a new builder-style object to manufacture [`DescribeDbClusterParametersOutput`](crate::output::DescribeDbClusterParametersOutput)
    pub fn builder() -> crate::output::describe_db_cluster_parameters_output::Builder {
        crate::output::describe_db_cluster_parameters_output::Builder::default()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDbClusterParameterGroupsOutput {
    /// <p>
    /// An optional pagination token provided by a previous
    /// <code>DescribeDBClusterParameterGroups</code> request.
    /// If this parameter is specified, the response includes
    /// only records beyond the marker,
    /// up to the value specified by <code>MaxRecords</code>.
    /// </p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>A list of DB cluster parameter groups.</p>
    pub db_cluster_parameter_groups:
        std::option::Option<std::vec::Vec<crate::model::DbClusterParameterGroup>>,
}
impl DescribeDbClusterParameterGroupsOutput {
    /// <p>
    /// An optional pagination token provided by a previous
    /// <code>DescribeDBClusterParameterGroups</code> request.
    /// If this parameter is specified, the response includes
    /// only records beyond the marker,
    /// up to the value specified by <code>MaxRecords</code>.
    /// </p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>A list of DB cluster parameter groups.</p>
    pub fn db_cluster_parameter_groups(
        &self,
    ) -> std::option::Option<&[crate::model::DbClusterParameterGroup]> {
        self.db_cluster_parameter_groups.as_deref()
    }
}
impl std::fmt::Debug for DescribeDbClusterParameterGroupsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDbClusterParameterGroupsOutput");
        formatter.field("marker", &self.marker);
        formatter.field(
            "db_cluster_parameter_groups",
            &self.db_cluster_parameter_groups,
        );
        formatter.finish()
    }
}
/// See [`DescribeDbClusterParameterGroupsOutput`](crate::output::DescribeDbClusterParameterGroupsOutput)
pub mod describe_db_cluster_parameter_groups_output {
    /// A builder for [`DescribeDbClusterParameterGroupsOutput`](crate::output::DescribeDbClusterParameterGroupsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) db_cluster_parameter_groups:
            std::option::Option<std::vec::Vec<crate::model::DbClusterParameterGroup>>,
    }
    impl Builder {
        /// <p>
        /// An optional pagination token provided by a previous
        /// <code>DescribeDBClusterParameterGroups</code> request.
        /// If this parameter is specified, the response includes
        /// only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.
        /// </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>
        /// An optional pagination token provided by a previous
        /// <code>DescribeDBClusterParameterGroups</code> request.
        /// If this parameter is specified, the response includes
        /// only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.
        /// </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Appends an item to `db_cluster_parameter_groups`.
        ///
        /// To override the contents of this collection use [`set_db_cluster_parameter_groups`](Self::set_db_cluster_parameter_groups).
        ///
        /// <p>A list of DB cluster parameter groups.</p>
        pub fn db_cluster_parameter_groups(
            mut self,
            input: impl Into<crate::model::DbClusterParameterGroup>,
        ) -> Self {
            let mut v = self.db_cluster_parameter_groups.unwrap_or_default();
            v.push(input.into());
            self.db_cluster_parameter_groups = Some(v);
            self
        }
        /// <p>A list of DB cluster parameter groups.</p>
        pub fn set_db_cluster_parameter_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DbClusterParameterGroup>>,
        ) -> Self {
            self.db_cluster_parameter_groups = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDbClusterParameterGroupsOutput`](crate::output::DescribeDbClusterParameterGroupsOutput)
        pub fn build(self) -> crate::output::DescribeDbClusterParameterGroupsOutput {
            crate::output::DescribeDbClusterParameterGroupsOutput {
                marker: self.marker,
                db_cluster_parameter_groups: self.db_cluster_parameter_groups,
            }
        }
    }
}
impl DescribeDbClusterParameterGroupsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeDbClusterParameterGroupsOutput`](crate::output::DescribeDbClusterParameterGroupsOutput)
    pub fn builder() -> crate::output::describe_db_cluster_parameter_groups_output::Builder {
        crate::output::describe_db_cluster_parameter_groups_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDbClusterEndpointsOutput {
    /// <p> An optional pagination token provided by a previous
    /// <code>DescribeDBClusterEndpoints</code> request.
    /// If this parameter is specified, the response includes
    /// only records beyond the marker,
    /// up to the value specified by <code>MaxRecords</code>.
    /// </p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>Contains the details of the endpoints associated with the cluster
    /// and matching any filter conditions.</p>
    pub db_cluster_endpoints: std::option::Option<std::vec::Vec<crate::model::DbClusterEndpoint>>,
}
impl DescribeDbClusterEndpointsOutput {
    /// <p> An optional pagination token provided by a previous
    /// <code>DescribeDBClusterEndpoints</code> request.
    /// If this parameter is specified, the response includes
    /// only records beyond the marker,
    /// up to the value specified by <code>MaxRecords</code>.
    /// </p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>Contains the details of the endpoints associated with the cluster
    /// and matching any filter conditions.</p>
    pub fn db_cluster_endpoints(&self) -> std::option::Option<&[crate::model::DbClusterEndpoint]> {
        self.db_cluster_endpoints.as_deref()
    }
}
impl std::fmt::Debug for DescribeDbClusterEndpointsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDbClusterEndpointsOutput");
        formatter.field("marker", &self.marker);
        formatter.field("db_cluster_endpoints", &self.db_cluster_endpoints);
        formatter.finish()
    }
}
/// See [`DescribeDbClusterEndpointsOutput`](crate::output::DescribeDbClusterEndpointsOutput)
pub mod describe_db_cluster_endpoints_output {
    /// A builder for [`DescribeDbClusterEndpointsOutput`](crate::output::DescribeDbClusterEndpointsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) db_cluster_endpoints:
            std::option::Option<std::vec::Vec<crate::model::DbClusterEndpoint>>,
    }
    impl Builder {
        /// <p> An optional pagination token provided by a previous
        /// <code>DescribeDBClusterEndpoints</code> request.
        /// If this parameter is specified, the response includes
        /// only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.
        /// </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p> An optional pagination token provided by a previous
        /// <code>DescribeDBClusterEndpoints</code> request.
        /// If this parameter is specified, the response includes
        /// only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.
        /// </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Appends an item to `db_cluster_endpoints`.
        ///
        /// To override the contents of this collection use [`set_db_cluster_endpoints`](Self::set_db_cluster_endpoints).
        ///
        /// <p>Contains the details of the endpoints associated with the cluster
        /// and matching any filter conditions.</p>
        pub fn db_cluster_endpoints(
            mut self,
            input: impl Into<crate::model::DbClusterEndpoint>,
        ) -> Self {
            let mut v = self.db_cluster_endpoints.unwrap_or_default();
            v.push(input.into());
            self.db_cluster_endpoints = Some(v);
            self
        }
        /// <p>Contains the details of the endpoints associated with the cluster
        /// and matching any filter conditions.</p>
        pub fn set_db_cluster_endpoints(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DbClusterEndpoint>>,
        ) -> Self {
            self.db_cluster_endpoints = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDbClusterEndpointsOutput`](crate::output::DescribeDbClusterEndpointsOutput)
        pub fn build(self) -> crate::output::DescribeDbClusterEndpointsOutput {
            crate::output::DescribeDbClusterEndpointsOutput {
                marker: self.marker,
                db_cluster_endpoints: self.db_cluster_endpoints,
            }
        }
    }
}
impl DescribeDbClusterEndpointsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeDbClusterEndpointsOutput`](crate::output::DescribeDbClusterEndpointsOutput)
    pub fn builder() -> crate::output::describe_db_cluster_endpoints_output::Builder {
        crate::output::describe_db_cluster_endpoints_output::Builder::default()
    }
}

/// <p>Contains the result of a successful invocation of the <code>DescribeDBClusterBacktracks</code> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDbClusterBacktracksOutput {
    /// <p>A pagination token that can be used in a later <code>DescribeDBClusterBacktracks</code> request.</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>Contains a list of backtracks for the user.</p>
    pub db_cluster_backtracks: std::option::Option<std::vec::Vec<crate::model::DbClusterBacktrack>>,
}
impl DescribeDbClusterBacktracksOutput {
    /// <p>A pagination token that can be used in a later <code>DescribeDBClusterBacktracks</code> request.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>Contains a list of backtracks for the user.</p>
    pub fn db_cluster_backtracks(
        &self,
    ) -> std::option::Option<&[crate::model::DbClusterBacktrack]> {
        self.db_cluster_backtracks.as_deref()
    }
}
impl std::fmt::Debug for DescribeDbClusterBacktracksOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDbClusterBacktracksOutput");
        formatter.field("marker", &self.marker);
        formatter.field("db_cluster_backtracks", &self.db_cluster_backtracks);
        formatter.finish()
    }
}
/// See [`DescribeDbClusterBacktracksOutput`](crate::output::DescribeDbClusterBacktracksOutput)
pub mod describe_db_cluster_backtracks_output {
    /// A builder for [`DescribeDbClusterBacktracksOutput`](crate::output::DescribeDbClusterBacktracksOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) db_cluster_backtracks:
            std::option::Option<std::vec::Vec<crate::model::DbClusterBacktrack>>,
    }
    impl Builder {
        /// <p>A pagination token that can be used in a later <code>DescribeDBClusterBacktracks</code> request.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>A pagination token that can be used in a later <code>DescribeDBClusterBacktracks</code> request.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Appends an item to `db_cluster_backtracks`.
        ///
        /// To override the contents of this collection use [`set_db_cluster_backtracks`](Self::set_db_cluster_backtracks).
        ///
        /// <p>Contains a list of backtracks for the user.</p>
        pub fn db_cluster_backtracks(
            mut self,
            input: impl Into<crate::model::DbClusterBacktrack>,
        ) -> Self {
            let mut v = self.db_cluster_backtracks.unwrap_or_default();
            v.push(input.into());
            self.db_cluster_backtracks = Some(v);
            self
        }
        /// <p>Contains a list of backtracks for the user.</p>
        pub fn set_db_cluster_backtracks(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DbClusterBacktrack>>,
        ) -> Self {
            self.db_cluster_backtracks = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDbClusterBacktracksOutput`](crate::output::DescribeDbClusterBacktracksOutput)
        pub fn build(self) -> crate::output::DescribeDbClusterBacktracksOutput {
            crate::output::DescribeDbClusterBacktracksOutput {
                marker: self.marker,
                db_cluster_backtracks: self.db_cluster_backtracks,
            }
        }
    }
}
impl DescribeDbClusterBacktracksOutput {
    /// Creates a new builder-style object to manufacture [`DescribeDbClusterBacktracksOutput`](crate::output::DescribeDbClusterBacktracksOutput)
    pub fn builder() -> crate::output::describe_db_cluster_backtracks_output::Builder {
        crate::output::describe_db_cluster_backtracks_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeCustomAvailabilityZonesOutput {
    /// <p>An optional pagination token provided by a previous
    /// <code>DescribeCustomAvailabilityZones</code> request.
    /// If this parameter is specified, the response includes
    /// only records beyond the marker,
    /// up to the value specified by <code>MaxRecords</code>.</p>
    pub marker: std::option::Option<std::string::String>,
    /// <p>The list of <a>CustomAvailabilityZone</a> objects for the Amazon Web Services account.</p>
    pub custom_availability_zones:
        std::option::Option<std::vec::Vec<crate::model::CustomAvailabilityZone>>,
}
impl DescribeCustomAvailabilityZonesOutput {
    /// <p>An optional pagination token provided by a previous
    /// <code>DescribeCustomAvailabilityZones</code> request.
    /// If this parameter is specified, the response includes
    /// only records beyond the marker,
    /// up to the value specified by <code>MaxRecords</code>.</p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
    /// <p>The list of <a>CustomAvailabilityZone</a> objects for the Amazon Web Services account.</p>
    pub fn custom_availability_zones(
        &self,
    ) -> std::option::Option<&[crate::model::CustomAvailabilityZone]> {
        self.custom_availability_zones.as_deref()
    }
}
impl std::fmt::Debug for DescribeCustomAvailabilityZonesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeCustomAvailabilityZonesOutput");
        formatter.field("marker", &self.marker);
        formatter.field("custom_availability_zones", &self.custom_availability_zones);
        formatter.finish()
    }
}
/// See [`DescribeCustomAvailabilityZonesOutput`](crate::output::DescribeCustomAvailabilityZonesOutput)
pub mod describe_custom_availability_zones_output {
    /// A builder for [`DescribeCustomAvailabilityZonesOutput`](crate::output::DescribeCustomAvailabilityZonesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) marker: std::option::Option<std::string::String>,
        pub(crate) custom_availability_zones:
            std::option::Option<std::vec::Vec<crate::model::CustomAvailabilityZone>>,
    }
    impl Builder {
        /// <p>An optional pagination token provided by a previous
        /// <code>DescribeCustomAvailabilityZones</code> request.
        /// If this parameter is specified, the response includes
        /// only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.</p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>An optional pagination token provided by a previous
        /// <code>DescribeCustomAvailabilityZones</code> request.
        /// If this parameter is specified, the response includes
        /// only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code>.</p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Appends an item to `custom_availability_zones`.
        ///
        /// To override the contents of this collection use [`set_custom_availability_zones`](Self::set_custom_availability_zones).
        ///
        /// <p>The list of <a>CustomAvailabilityZone</a> objects for the Amazon Web Services account.</p>
        pub fn custom_availability_zones(
            mut self,
            input: impl Into<crate::model::CustomAvailabilityZone>,
        ) -> Self {
            let mut v = self.custom_availability_zones.unwrap_or_default();
            v.push(input.into());
            self.custom_availability_zones = Some(v);
            self
        }
        /// <p>The list of <a>CustomAvailabilityZone</a> objects for the Amazon Web Services account.</p>
        pub fn set_custom_availability_zones(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CustomAvailabilityZone>>,
        ) -> Self {
            self.custom_availability_zones = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeCustomAvailabilityZonesOutput`](crate::output::DescribeCustomAvailabilityZonesOutput)
        pub fn build(self) -> crate::output::DescribeCustomAvailabilityZonesOutput {
            crate::output::DescribeCustomAvailabilityZonesOutput {
                marker: self.marker,
                custom_availability_zones: self.custom_availability_zones,
            }
        }
    }
}
impl DescribeCustomAvailabilityZonesOutput {
    /// Creates a new builder-style object to manufacture [`DescribeCustomAvailabilityZonesOutput`](crate::output::DescribeCustomAvailabilityZonesOutput)
    pub fn builder() -> crate::output::describe_custom_availability_zones_output::Builder {
        crate::output::describe_custom_availability_zones_output::Builder::default()
    }
}

/// <p>Data returned by the <b>DescribeCertificates</b> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeCertificatesOutput {
    /// <p>The list of <code>Certificate</code> objects for the Amazon Web Services account.</p>
    pub certificates: std::option::Option<std::vec::Vec<crate::model::Certificate>>,
    /// <p>
    /// An optional pagination token provided by a previous
    /// <code>DescribeCertificates</code> request.
    /// If this parameter is specified, the response includes
    /// only records beyond the marker,
    /// up to the value specified by <code>MaxRecords</code> .
    /// </p>
    pub marker: std::option::Option<std::string::String>,
}
impl DescribeCertificatesOutput {
    /// <p>The list of <code>Certificate</code> objects for the Amazon Web Services account.</p>
    pub fn certificates(&self) -> std::option::Option<&[crate::model::Certificate]> {
        self.certificates.as_deref()
    }
    /// <p>
    /// An optional pagination token provided by a previous
    /// <code>DescribeCertificates</code> request.
    /// If this parameter is specified, the response includes
    /// only records beyond the marker,
    /// up to the value specified by <code>MaxRecords</code> .
    /// </p>
    pub fn marker(&self) -> std::option::Option<&str> {
        self.marker.as_deref()
    }
}
impl std::fmt::Debug for DescribeCertificatesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeCertificatesOutput");
        formatter.field("certificates", &self.certificates);
        formatter.field("marker", &self.marker);
        formatter.finish()
    }
}
/// See [`DescribeCertificatesOutput`](crate::output::DescribeCertificatesOutput)
pub mod describe_certificates_output {
    /// A builder for [`DescribeCertificatesOutput`](crate::output::DescribeCertificatesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) certificates: std::option::Option<std::vec::Vec<crate::model::Certificate>>,
        pub(crate) marker: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `certificates`.
        ///
        /// To override the contents of this collection use [`set_certificates`](Self::set_certificates).
        ///
        /// <p>The list of <code>Certificate</code> objects for the Amazon Web Services account.</p>
        pub fn certificates(mut self, input: impl Into<crate::model::Certificate>) -> Self {
            let mut v = self.certificates.unwrap_or_default();
            v.push(input.into());
            self.certificates = Some(v);
            self
        }
        /// <p>The list of <code>Certificate</code> objects for the Amazon Web Services account.</p>
        pub fn set_certificates(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Certificate>>,
        ) -> Self {
            self.certificates = input;
            self
        }
        /// <p>
        /// An optional pagination token provided by a previous
        /// <code>DescribeCertificates</code> request.
        /// If this parameter is specified, the response includes
        /// only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code> .
        /// </p>
        pub fn marker(mut self, input: impl Into<std::string::String>) -> Self {
            self.marker = Some(input.into());
            self
        }
        /// <p>
        /// An optional pagination token provided by a previous
        /// <code>DescribeCertificates</code> request.
        /// If this parameter is specified, the response includes
        /// only records beyond the marker,
        /// up to the value specified by <code>MaxRecords</code> .
        /// </p>
        pub fn set_marker(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.marker = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeCertificatesOutput`](crate::output::DescribeCertificatesOutput)
        pub fn build(self) -> crate::output::DescribeCertificatesOutput {
            crate::output::DescribeCertificatesOutput {
                certificates: self.certificates,
                marker: self.marker,
            }
        }
    }
}
impl DescribeCertificatesOutput {
    /// Creates a new builder-style object to manufacture [`DescribeCertificatesOutput`](crate::output::DescribeCertificatesOutput)
    pub fn builder() -> crate::output::describe_certificates_output::Builder {
        crate::output::describe_certificates_output::Builder::default()
    }
}

/// <p>Data returned by the <b>DescribeAccountAttributes</b> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeAccountAttributesOutput {
    /// <p>A list of <code>AccountQuota</code> objects. Within this list, each quota has a name,
    /// a count of usage toward the quota maximum, and a maximum value for the quota.</p>
    pub account_quotas: std::option::Option<std::vec::Vec<crate::model::AccountQuota>>,
}
impl DescribeAccountAttributesOutput {
    /// <p>A list of <code>AccountQuota</code> objects. Within this list, each quota has a name,
    /// a count of usage toward the quota maximum, and a maximum value for the quota.</p>
    pub fn account_quotas(&self) -> std::option::Option<&[crate::model::AccountQuota]> {
        self.account_quotas.as_deref()
    }
}
impl std::fmt::Debug for DescribeAccountAttributesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeAccountAttributesOutput");
        formatter.field("account_quotas", &self.account_quotas);
        formatter.finish()
    }
}
/// See [`DescribeAccountAttributesOutput`](crate::output::DescribeAccountAttributesOutput)
pub mod describe_account_attributes_output {
    /// A builder for [`DescribeAccountAttributesOutput`](crate::output::DescribeAccountAttributesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_quotas: std::option::Option<std::vec::Vec<crate::model::AccountQuota>>,
    }
    impl Builder {
        /// Appends an item to `account_quotas`.
        ///
        /// To override the contents of this collection use [`set_account_quotas`](Self::set_account_quotas).
        ///
        /// <p>A list of <code>AccountQuota</code> objects. Within this list, each quota has a name,
        /// a count of usage toward the quota maximum, and a maximum value for the quota.</p>
        pub fn account_quotas(mut self, input: impl Into<crate::model::AccountQuota>) -> Self {
            let mut v = self.account_quotas.unwrap_or_default();
            v.push(input.into());
            self.account_quotas = Some(v);
            self
        }
        /// <p>A list of <code>AccountQuota</code> objects. Within this list, each quota has a name,
        /// a count of usage toward the quota maximum, and a maximum value for the quota.</p>
        pub fn set_account_quotas(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AccountQuota>>,
        ) -> Self {
            self.account_quotas = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeAccountAttributesOutput`](crate::output::DescribeAccountAttributesOutput)
        pub fn build(self) -> crate::output::DescribeAccountAttributesOutput {
            crate::output::DescribeAccountAttributesOutput {
                account_quotas: self.account_quotas,
            }
        }
    }
}
impl DescribeAccountAttributesOutput {
    /// Creates a new builder-style object to manufacture [`DescribeAccountAttributesOutput`](crate::output::DescribeAccountAttributesOutput)
    pub fn builder() -> crate::output::describe_account_attributes_output::Builder {
        crate::output::describe_account_attributes_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeregisterDbProxyTargetsOutput {}
impl std::fmt::Debug for DeregisterDbProxyTargetsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeregisterDbProxyTargetsOutput");
        formatter.finish()
    }
}
/// See [`DeregisterDbProxyTargetsOutput`](crate::output::DeregisterDbProxyTargetsOutput)
pub mod deregister_db_proxy_targets_output {
    /// A builder for [`DeregisterDbProxyTargetsOutput`](crate::output::DeregisterDbProxyTargetsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeregisterDbProxyTargetsOutput`](crate::output::DeregisterDbProxyTargetsOutput)
        pub fn build(self) -> crate::output::DeregisterDbProxyTargetsOutput {
            crate::output::DeregisterDbProxyTargetsOutput {}
        }
    }
}
impl DeregisterDbProxyTargetsOutput {
    /// Creates a new builder-style object to manufacture [`DeregisterDbProxyTargetsOutput`](crate::output::DeregisterDbProxyTargetsOutput)
    pub fn builder() -> crate::output::deregister_db_proxy_targets_output::Builder {
        crate::output::deregister_db_proxy_targets_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteOptionGroupOutput {}
impl std::fmt::Debug for DeleteOptionGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteOptionGroupOutput");
        formatter.finish()
    }
}
/// See [`DeleteOptionGroupOutput`](crate::output::DeleteOptionGroupOutput)
pub mod delete_option_group_output {
    /// A builder for [`DeleteOptionGroupOutput`](crate::output::DeleteOptionGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteOptionGroupOutput`](crate::output::DeleteOptionGroupOutput)
        pub fn build(self) -> crate::output::DeleteOptionGroupOutput {
            crate::output::DeleteOptionGroupOutput {}
        }
    }
}
impl DeleteOptionGroupOutput {
    /// Creates a new builder-style object to manufacture [`DeleteOptionGroupOutput`](crate::output::DeleteOptionGroupOutput)
    pub fn builder() -> crate::output::delete_option_group_output::Builder {
        crate::output::delete_option_group_output::Builder::default()
    }
}

/// <p>Contains the installation media for a DB engine that requires an on-premises
/// customer provided license, such as Microsoft SQL Server.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteInstallationMediaOutput {
    /// <p>The installation medium ID.</p>
    pub installation_media_id: std::option::Option<std::string::String>,
    /// <p>The custom Availability Zone (AZ) that contains the installation media.</p>
    pub custom_availability_zone_id: std::option::Option<std::string::String>,
    /// <p>The DB engine.</p>
    pub engine: std::option::Option<std::string::String>,
    /// <p>The engine version of the DB engine.</p>
    pub engine_version: std::option::Option<std::string::String>,
    /// <p>The path to the installation medium for the DB engine.</p>
    pub engine_installation_media_path: std::option::Option<std::string::String>,
    /// <p>The path to the installation medium for the operating system associated with the DB engine.</p>
    pub os_installation_media_path: std::option::Option<std::string::String>,
    /// <p>The status of the installation medium.</p>
    pub status: std::option::Option<std::string::String>,
    /// <p>If an installation media failure occurred, the cause of the failure.</p>
    pub failure_cause: std::option::Option<crate::model::InstallationMediaFailureCause>,
}
impl DeleteInstallationMediaOutput {
    /// <p>The installation medium ID.</p>
    pub fn installation_media_id(&self) -> std::option::Option<&str> {
        self.installation_media_id.as_deref()
    }
    /// <p>The custom Availability Zone (AZ) that contains the installation media.</p>
    pub fn custom_availability_zone_id(&self) -> std::option::Option<&str> {
        self.custom_availability_zone_id.as_deref()
    }
    /// <p>The DB engine.</p>
    pub fn engine(&self) -> std::option::Option<&str> {
        self.engine.as_deref()
    }
    /// <p>The engine version of the DB engine.</p>
    pub fn engine_version(&self) -> std::option::Option<&str> {
        self.engine_version.as_deref()
    }
    /// <p>The path to the installation medium for the DB engine.</p>
    pub fn engine_installation_media_path(&self) -> std::option::Option<&str> {
        self.engine_installation_media_path.as_deref()
    }
    /// <p>The path to the installation medium for the operating system associated with the DB engine.</p>
    pub fn os_installation_media_path(&self) -> std::option::Option<&str> {
        self.os_installation_media_path.as_deref()
    }
    /// <p>The status of the installation medium.</p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>If an installation media failure occurred, the cause of the failure.</p>
    pub fn failure_cause(
        &self,
    ) -> std::option::Option<&crate::model::InstallationMediaFailureCause> {
        self.failure_cause.as_ref()
    }
}
impl std::fmt::Debug for DeleteInstallationMediaOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteInstallationMediaOutput");
        formatter.field("installation_media_id", &self.installation_media_id);
        formatter.field(
            "custom_availability_zone_id",
            &self.custom_availability_zone_id,
        );
        formatter.field("engine", &self.engine);
        formatter.field("engine_version", &self.engine_version);
        formatter.field(
            "engine_installation_media_path",
            &self.engine_installation_media_path,
        );
        formatter.field(
            "os_installation_media_path",
            &self.os_installation_media_path,
        );
        formatter.field("status", &self.status);
        formatter.field("failure_cause", &self.failure_cause);
        formatter.finish()
    }
}
/// See [`DeleteInstallationMediaOutput`](crate::output::DeleteInstallationMediaOutput)
pub mod delete_installation_media_output {
    /// A builder for [`DeleteInstallationMediaOutput`](crate::output::DeleteInstallationMediaOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) installation_media_id: std::option::Option<std::string::String>,
        pub(crate) custom_availability_zone_id: std::option::Option<std::string::String>,
        pub(crate) engine: std::option::Option<std::string::String>,
        pub(crate) engine_version: std::option::Option<std::string::String>,
        pub(crate) engine_installation_media_path: std::option::Option<std::string::String>,
        pub(crate) os_installation_media_path: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) failure_cause: std::option::Option<crate::model::InstallationMediaFailureCause>,
    }
    impl Builder {
        /// <p>The installation medium ID.</p>
        pub fn installation_media_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.installation_media_id = Some(input.into());
            self
        }
        /// <p>The installation medium ID.</p>
        pub fn set_installation_media_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.installation_media_id = input;
            self
        }
        /// <p>The custom Availability Zone (AZ) that contains the installation media.</p>
        pub fn custom_availability_zone_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.custom_availability_zone_id = Some(input.into());
            self
        }
        /// <p>The custom Availability Zone (AZ) that contains the installation media.</p>
        pub fn set_custom_availability_zone_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.custom_availability_zone_id = input;
            self
        }
        /// <p>The DB engine.</p>
        pub fn engine(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine = Some(input.into());
            self
        }
        /// <p>The DB engine.</p>
        pub fn set_engine(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.engine = input;
            self
        }
        /// <p>The engine version of the DB engine.</p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_version = Some(input.into());
            self
        }
        /// <p>The engine version of the DB engine.</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.engine_version = input;
            self
        }
        /// <p>The path to the installation medium for the DB engine.</p>
        pub fn engine_installation_media_path(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.engine_installation_media_path = Some(input.into());
            self
        }
        /// <p>The path to the installation medium for the DB engine.</p>
        pub fn set_engine_installation_media_path(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.engine_installation_media_path = input;
            self
        }
        /// <p>The path to the installation medium for the operating system associated with the DB engine.</p>
        pub fn os_installation_media_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.os_installation_media_path = Some(input.into());
            self
        }
        /// <p>The path to the installation medium for the operating system associated with the DB engine.</p>
        pub fn set_os_installation_media_path(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.os_installation_media_path = input;
            self
        }
        /// <p>The status of the installation medium.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the installation medium.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>If an installation media failure occurred, the cause of the failure.</p>
        pub fn failure_cause(mut self, input: crate::model::InstallationMediaFailureCause) -> Self {
            self.failure_cause = Some(input);
            self
        }
        /// <p>If an installation media failure occurred, the cause of the failure.</p>
        pub fn set_failure_cause(
            mut self,
            input: std::option::Option<crate::model::InstallationMediaFailureCause>,
        ) -> Self {
            self.failure_cause = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteInstallationMediaOutput`](crate::output::DeleteInstallationMediaOutput)
        pub fn build(self) -> crate::output::DeleteInstallationMediaOutput {
            crate::output::DeleteInstallationMediaOutput {
                installation_media_id: self.installation_media_id,
                custom_availability_zone_id: self.custom_availability_zone_id,
                engine: self.engine,
                engine_version: self.engine_version,
                engine_installation_media_path: self.engine_installation_media_path,
                os_installation_media_path: self.os_installation_media_path,
                status: self.status,
                failure_cause: self.failure_cause,
            }
        }
    }
}
impl DeleteInstallationMediaOutput {
    /// Creates a new builder-style object to manufacture [`DeleteInstallationMediaOutput`](crate::output::DeleteInstallationMediaOutput)
    pub fn builder() -> crate::output::delete_installation_media_output::Builder {
        crate::output::delete_installation_media_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteGlobalClusterOutput {
    /// <p>A data type representing an Aurora global database.</p>
    pub global_cluster: std::option::Option<crate::model::GlobalCluster>,
}
impl DeleteGlobalClusterOutput {
    /// <p>A data type representing an Aurora global database.</p>
    pub fn global_cluster(&self) -> std::option::Option<&crate::model::GlobalCluster> {
        self.global_cluster.as_ref()
    }
}
impl std::fmt::Debug for DeleteGlobalClusterOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteGlobalClusterOutput");
        formatter.field("global_cluster", &self.global_cluster);
        formatter.finish()
    }
}
/// See [`DeleteGlobalClusterOutput`](crate::output::DeleteGlobalClusterOutput)
pub mod delete_global_cluster_output {
    /// A builder for [`DeleteGlobalClusterOutput`](crate::output::DeleteGlobalClusterOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) global_cluster: std::option::Option<crate::model::GlobalCluster>,
    }
    impl Builder {
        /// <p>A data type representing an Aurora global database.</p>
        pub fn global_cluster(mut self, input: crate::model::GlobalCluster) -> Self {
            self.global_cluster = Some(input);
            self
        }
        /// <p>A data type representing an Aurora global database.</p>
        pub fn set_global_cluster(
            mut self,
            input: std::option::Option<crate::model::GlobalCluster>,
        ) -> Self {
            self.global_cluster = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteGlobalClusterOutput`](crate::output::DeleteGlobalClusterOutput)
        pub fn build(self) -> crate::output::DeleteGlobalClusterOutput {
            crate::output::DeleteGlobalClusterOutput {
                global_cluster: self.global_cluster,
            }
        }
    }
}
impl DeleteGlobalClusterOutput {
    /// Creates a new builder-style object to manufacture [`DeleteGlobalClusterOutput`](crate::output::DeleteGlobalClusterOutput)
    pub fn builder() -> crate::output::delete_global_cluster_output::Builder {
        crate::output::delete_global_cluster_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteEventSubscriptionOutput {
    /// <p>Contains the results of a successful invocation of the <code>DescribeEventSubscriptions</code> action.</p>
    pub event_subscription: std::option::Option<crate::model::EventSubscription>,
}
impl DeleteEventSubscriptionOutput {
    /// <p>Contains the results of a successful invocation of the <code>DescribeEventSubscriptions</code> action.</p>
    pub fn event_subscription(&self) -> std::option::Option<&crate::model::EventSubscription> {
        self.event_subscription.as_ref()
    }
}
impl std::fmt::Debug for DeleteEventSubscriptionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteEventSubscriptionOutput");
        formatter.field("event_subscription", &self.event_subscription);
        formatter.finish()
    }
}
/// See [`DeleteEventSubscriptionOutput`](crate::output::DeleteEventSubscriptionOutput)
pub mod delete_event_subscription_output {
    /// A builder for [`DeleteEventSubscriptionOutput`](crate::output::DeleteEventSubscriptionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) event_subscription: std::option::Option<crate::model::EventSubscription>,
    }
    impl Builder {
        /// <p>Contains the results of a successful invocation of the <code>DescribeEventSubscriptions</code> action.</p>
        pub fn event_subscription(mut self, input: crate::model::EventSubscription) -> Self {
            self.event_subscription = Some(input);
            self
        }
        /// <p>Contains the results of a successful invocation of the <code>DescribeEventSubscriptions</code> action.</p>
        pub fn set_event_subscription(
            mut self,
            input: std::option::Option<crate::model::EventSubscription>,
        ) -> Self {
            self.event_subscription = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteEventSubscriptionOutput`](crate::output::DeleteEventSubscriptionOutput)
        pub fn build(self) -> crate::output::DeleteEventSubscriptionOutput {
            crate::output::DeleteEventSubscriptionOutput {
                event_subscription: self.event_subscription,
            }
        }
    }
}
impl DeleteEventSubscriptionOutput {
    /// Creates a new builder-style object to manufacture [`DeleteEventSubscriptionOutput`](crate::output::DeleteEventSubscriptionOutput)
    pub fn builder() -> crate::output::delete_event_subscription_output::Builder {
        crate::output::delete_event_subscription_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDbSubnetGroupOutput {}
impl std::fmt::Debug for DeleteDbSubnetGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDbSubnetGroupOutput");
        formatter.finish()
    }
}
/// See [`DeleteDbSubnetGroupOutput`](crate::output::DeleteDbSubnetGroupOutput)
pub mod delete_db_subnet_group_output {
    /// A builder for [`DeleteDbSubnetGroupOutput`](crate::output::DeleteDbSubnetGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteDbSubnetGroupOutput`](crate::output::DeleteDbSubnetGroupOutput)
        pub fn build(self) -> crate::output::DeleteDbSubnetGroupOutput {
            crate::output::DeleteDbSubnetGroupOutput {}
        }
    }
}
impl DeleteDbSubnetGroupOutput {
    /// Creates a new builder-style object to manufacture [`DeleteDbSubnetGroupOutput`](crate::output::DeleteDbSubnetGroupOutput)
    pub fn builder() -> crate::output::delete_db_subnet_group_output::Builder {
        crate::output::delete_db_subnet_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDbSnapshotOutput {
    /// <p>Contains the details of an Amazon RDS DB snapshot.
    /// </p>
    /// <p>This data type is used as a response element
    /// in the <code>DescribeDBSnapshots</code> action.
    /// </p>
    pub db_snapshot: std::option::Option<crate::model::DbSnapshot>,
}
impl DeleteDbSnapshotOutput {
    /// <p>Contains the details of an Amazon RDS DB snapshot.
    /// </p>
    /// <p>This data type is used as a response element
    /// in the <code>DescribeDBSnapshots</code> action.
    /// </p>
    pub fn db_snapshot(&self) -> std::option::Option<&crate::model::DbSnapshot> {
        self.db_snapshot.as_ref()
    }
}
impl std::fmt::Debug for DeleteDbSnapshotOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDbSnapshotOutput");
        formatter.field("db_snapshot", &self.db_snapshot);
        formatter.finish()
    }
}
/// See [`DeleteDbSnapshotOutput`](crate::output::DeleteDbSnapshotOutput)
pub mod delete_db_snapshot_output {
    /// A builder for [`DeleteDbSnapshotOutput`](crate::output::DeleteDbSnapshotOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_snapshot: std::option::Option<crate::model::DbSnapshot>,
    }
    impl Builder {
        /// <p>Contains the details of an Amazon RDS DB snapshot.
        /// </p>
        /// <p>This data type is used as a response element
        /// in the <code>DescribeDBSnapshots</code> action.
        /// </p>
        pub fn db_snapshot(mut self, input: crate::model::DbSnapshot) -> Self {
            self.db_snapshot = Some(input);
            self
        }
        /// <p>Contains the details of an Amazon RDS DB snapshot.
        /// </p>
        /// <p>This data type is used as a response element
        /// in the <code>DescribeDBSnapshots</code> action.
        /// </p>
        pub fn set_db_snapshot(
            mut self,
            input: std::option::Option<crate::model::DbSnapshot>,
        ) -> Self {
            self.db_snapshot = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDbSnapshotOutput`](crate::output::DeleteDbSnapshotOutput)
        pub fn build(self) -> crate::output::DeleteDbSnapshotOutput {
            crate::output::DeleteDbSnapshotOutput {
                db_snapshot: self.db_snapshot,
            }
        }
    }
}
impl DeleteDbSnapshotOutput {
    /// Creates a new builder-style object to manufacture [`DeleteDbSnapshotOutput`](crate::output::DeleteDbSnapshotOutput)
    pub fn builder() -> crate::output::delete_db_snapshot_output::Builder {
        crate::output::delete_db_snapshot_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDbSecurityGroupOutput {}
impl std::fmt::Debug for DeleteDbSecurityGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDbSecurityGroupOutput");
        formatter.finish()
    }
}
/// See [`DeleteDbSecurityGroupOutput`](crate::output::DeleteDbSecurityGroupOutput)
pub mod delete_db_security_group_output {
    /// A builder for [`DeleteDbSecurityGroupOutput`](crate::output::DeleteDbSecurityGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteDbSecurityGroupOutput`](crate::output::DeleteDbSecurityGroupOutput)
        pub fn build(self) -> crate::output::DeleteDbSecurityGroupOutput {
            crate::output::DeleteDbSecurityGroupOutput {}
        }
    }
}
impl DeleteDbSecurityGroupOutput {
    /// Creates a new builder-style object to manufacture [`DeleteDbSecurityGroupOutput`](crate::output::DeleteDbSecurityGroupOutput)
    pub fn builder() -> crate::output::delete_db_security_group_output::Builder {
        crate::output::delete_db_security_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDbProxyEndpointOutput {
    /// <p>The data structure representing the details of the DB proxy endpoint that you delete.</p>
    pub db_proxy_endpoint: std::option::Option<crate::model::DbProxyEndpoint>,
}
impl DeleteDbProxyEndpointOutput {
    /// <p>The data structure representing the details of the DB proxy endpoint that you delete.</p>
    pub fn db_proxy_endpoint(&self) -> std::option::Option<&crate::model::DbProxyEndpoint> {
        self.db_proxy_endpoint.as_ref()
    }
}
impl std::fmt::Debug for DeleteDbProxyEndpointOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDbProxyEndpointOutput");
        formatter.field("db_proxy_endpoint", &self.db_proxy_endpoint);
        formatter.finish()
    }
}
/// See [`DeleteDbProxyEndpointOutput`](crate::output::DeleteDbProxyEndpointOutput)
pub mod delete_db_proxy_endpoint_output {
    /// A builder for [`DeleteDbProxyEndpointOutput`](crate::output::DeleteDbProxyEndpointOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_proxy_endpoint: std::option::Option<crate::model::DbProxyEndpoint>,
    }
    impl Builder {
        /// <p>The data structure representing the details of the DB proxy endpoint that you delete.</p>
        pub fn db_proxy_endpoint(mut self, input: crate::model::DbProxyEndpoint) -> Self {
            self.db_proxy_endpoint = Some(input);
            self
        }
        /// <p>The data structure representing the details of the DB proxy endpoint that you delete.</p>
        pub fn set_db_proxy_endpoint(
            mut self,
            input: std::option::Option<crate::model::DbProxyEndpoint>,
        ) -> Self {
            self.db_proxy_endpoint = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDbProxyEndpointOutput`](crate::output::DeleteDbProxyEndpointOutput)
        pub fn build(self) -> crate::output::DeleteDbProxyEndpointOutput {
            crate::output::DeleteDbProxyEndpointOutput {
                db_proxy_endpoint: self.db_proxy_endpoint,
            }
        }
    }
}
impl DeleteDbProxyEndpointOutput {
    /// Creates a new builder-style object to manufacture [`DeleteDbProxyEndpointOutput`](crate::output::DeleteDbProxyEndpointOutput)
    pub fn builder() -> crate::output::delete_db_proxy_endpoint_output::Builder {
        crate::output::delete_db_proxy_endpoint_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDbProxyOutput {
    /// <p>The data structure representing the details of the DB proxy that you delete.</p>
    pub db_proxy: std::option::Option<crate::model::DbProxy>,
}
impl DeleteDbProxyOutput {
    /// <p>The data structure representing the details of the DB proxy that you delete.</p>
    pub fn db_proxy(&self) -> std::option::Option<&crate::model::DbProxy> {
        self.db_proxy.as_ref()
    }
}
impl std::fmt::Debug for DeleteDbProxyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDbProxyOutput");
        formatter.field("db_proxy", &self.db_proxy);
        formatter.finish()
    }
}
/// See [`DeleteDbProxyOutput`](crate::output::DeleteDbProxyOutput)
pub mod delete_db_proxy_output {
    /// A builder for [`DeleteDbProxyOutput`](crate::output::DeleteDbProxyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_proxy: std::option::Option<crate::model::DbProxy>,
    }
    impl Builder {
        /// <p>The data structure representing the details of the DB proxy that you delete.</p>
        pub fn db_proxy(mut self, input: crate::model::DbProxy) -> Self {
            self.db_proxy = Some(input);
            self
        }
        /// <p>The data structure representing the details of the DB proxy that you delete.</p>
        pub fn set_db_proxy(mut self, input: std::option::Option<crate::model::DbProxy>) -> Self {
            self.db_proxy = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDbProxyOutput`](crate::output::DeleteDbProxyOutput)
        pub fn build(self) -> crate::output::DeleteDbProxyOutput {
            crate::output::DeleteDbProxyOutput {
                db_proxy: self.db_proxy,
            }
        }
    }
}
impl DeleteDbProxyOutput {
    /// Creates a new builder-style object to manufacture [`DeleteDbProxyOutput`](crate::output::DeleteDbProxyOutput)
    pub fn builder() -> crate::output::delete_db_proxy_output::Builder {
        crate::output::delete_db_proxy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDbParameterGroupOutput {}
impl std::fmt::Debug for DeleteDbParameterGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDbParameterGroupOutput");
        formatter.finish()
    }
}
/// See [`DeleteDbParameterGroupOutput`](crate::output::DeleteDbParameterGroupOutput)
pub mod delete_db_parameter_group_output {
    /// A builder for [`DeleteDbParameterGroupOutput`](crate::output::DeleteDbParameterGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteDbParameterGroupOutput`](crate::output::DeleteDbParameterGroupOutput)
        pub fn build(self) -> crate::output::DeleteDbParameterGroupOutput {
            crate::output::DeleteDbParameterGroupOutput {}
        }
    }
}
impl DeleteDbParameterGroupOutput {
    /// Creates a new builder-style object to manufacture [`DeleteDbParameterGroupOutput`](crate::output::DeleteDbParameterGroupOutput)
    pub fn builder() -> crate::output::delete_db_parameter_group_output::Builder {
        crate::output::delete_db_parameter_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDbInstanceAutomatedBackupOutput {
    /// <p>An automated backup of a DB instance. It consists of system backups, transaction logs, and the database instance properties that
    /// existed at the time you deleted the source instance.</p>
    pub db_instance_automated_backup: std::option::Option<crate::model::DbInstanceAutomatedBackup>,
}
impl DeleteDbInstanceAutomatedBackupOutput {
    /// <p>An automated backup of a DB instance. It consists of system backups, transaction logs, and the database instance properties that
    /// existed at the time you deleted the source instance.</p>
    pub fn db_instance_automated_backup(
        &self,
    ) -> std::option::Option<&crate::model::DbInstanceAutomatedBackup> {
        self.db_instance_automated_backup.as_ref()
    }
}
impl std::fmt::Debug for DeleteDbInstanceAutomatedBackupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDbInstanceAutomatedBackupOutput");
        formatter.field(
            "db_instance_automated_backup",
            &self.db_instance_automated_backup,
        );
        formatter.finish()
    }
}
/// See [`DeleteDbInstanceAutomatedBackupOutput`](crate::output::DeleteDbInstanceAutomatedBackupOutput)
pub mod delete_db_instance_automated_backup_output {
    /// A builder for [`DeleteDbInstanceAutomatedBackupOutput`](crate::output::DeleteDbInstanceAutomatedBackupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_instance_automated_backup:
            std::option::Option<crate::model::DbInstanceAutomatedBackup>,
    }
    impl Builder {
        /// <p>An automated backup of a DB instance. It consists of system backups, transaction logs, and the database instance properties that
        /// existed at the time you deleted the source instance.</p>
        pub fn db_instance_automated_backup(
            mut self,
            input: crate::model::DbInstanceAutomatedBackup,
        ) -> Self {
            self.db_instance_automated_backup = Some(input);
            self
        }
        /// <p>An automated backup of a DB instance. It consists of system backups, transaction logs, and the database instance properties that
        /// existed at the time you deleted the source instance.</p>
        pub fn set_db_instance_automated_backup(
            mut self,
            input: std::option::Option<crate::model::DbInstanceAutomatedBackup>,
        ) -> Self {
            self.db_instance_automated_backup = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDbInstanceAutomatedBackupOutput`](crate::output::DeleteDbInstanceAutomatedBackupOutput)
        pub fn build(self) -> crate::output::DeleteDbInstanceAutomatedBackupOutput {
            crate::output::DeleteDbInstanceAutomatedBackupOutput {
                db_instance_automated_backup: self.db_instance_automated_backup,
            }
        }
    }
}
impl DeleteDbInstanceAutomatedBackupOutput {
    /// Creates a new builder-style object to manufacture [`DeleteDbInstanceAutomatedBackupOutput`](crate::output::DeleteDbInstanceAutomatedBackupOutput)
    pub fn builder() -> crate::output::delete_db_instance_automated_backup_output::Builder {
        crate::output::delete_db_instance_automated_backup_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDbInstanceOutput {
    /// <p>Contains the details of an Amazon RDS DB instance.
    /// </p>
    /// <p>This data type is used as a response element in the <code>DescribeDBInstances</code> action.
    /// </p>
    pub db_instance: std::option::Option<crate::model::DbInstance>,
}
impl DeleteDbInstanceOutput {
    /// <p>Contains the details of an Amazon RDS DB instance.
    /// </p>
    /// <p>This data type is used as a response element in the <code>DescribeDBInstances</code> action.
    /// </p>
    pub fn db_instance(&self) -> std::option::Option<&crate::model::DbInstance> {
        self.db_instance.as_ref()
    }
}
impl std::fmt::Debug for DeleteDbInstanceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDbInstanceOutput");
        formatter.field("db_instance", &self.db_instance);
        formatter.finish()
    }
}
/// See [`DeleteDbInstanceOutput`](crate::output::DeleteDbInstanceOutput)
pub mod delete_db_instance_output {
    /// A builder for [`DeleteDbInstanceOutput`](crate::output::DeleteDbInstanceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_instance: std::option::Option<crate::model::DbInstance>,
    }
    impl Builder {
        /// <p>Contains the details of an Amazon RDS DB instance.
        /// </p>
        /// <p>This data type is used as a response element in the <code>DescribeDBInstances</code> action.
        /// </p>
        pub fn db_instance(mut self, input: crate::model::DbInstance) -> Self {
            self.db_instance = Some(input);
            self
        }
        /// <p>Contains the details of an Amazon RDS DB instance.
        /// </p>
        /// <p>This data type is used as a response element in the <code>DescribeDBInstances</code> action.
        /// </p>
        pub fn set_db_instance(
            mut self,
            input: std::option::Option<crate::model::DbInstance>,
        ) -> Self {
            self.db_instance = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDbInstanceOutput`](crate::output::DeleteDbInstanceOutput)
        pub fn build(self) -> crate::output::DeleteDbInstanceOutput {
            crate::output::DeleteDbInstanceOutput {
                db_instance: self.db_instance,
            }
        }
    }
}
impl DeleteDbInstanceOutput {
    /// Creates a new builder-style object to manufacture [`DeleteDbInstanceOutput`](crate::output::DeleteDbInstanceOutput)
    pub fn builder() -> crate::output::delete_db_instance_output::Builder {
        crate::output::delete_db_instance_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDbClusterSnapshotOutput {
    /// <p>Contains the details for an Amazon RDS DB cluster snapshot
    /// </p>
    /// <p>This data type is used as a response element
    /// in the <code>DescribeDBClusterSnapshots</code> action.
    /// </p>
    pub db_cluster_snapshot: std::option::Option<crate::model::DbClusterSnapshot>,
}
impl DeleteDbClusterSnapshotOutput {
    /// <p>Contains the details for an Amazon RDS DB cluster snapshot
    /// </p>
    /// <p>This data type is used as a response element
    /// in the <code>DescribeDBClusterSnapshots</code> action.
    /// </p>
    pub fn db_cluster_snapshot(&self) -> std::option::Option<&crate::model::DbClusterSnapshot> {
        self.db_cluster_snapshot.as_ref()
    }
}
impl std::fmt::Debug for DeleteDbClusterSnapshotOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDbClusterSnapshotOutput");
        formatter.field("db_cluster_snapshot", &self.db_cluster_snapshot);
        formatter.finish()
    }
}
/// See [`DeleteDbClusterSnapshotOutput`](crate::output::DeleteDbClusterSnapshotOutput)
pub mod delete_db_cluster_snapshot_output {
    /// A builder for [`DeleteDbClusterSnapshotOutput`](crate::output::DeleteDbClusterSnapshotOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster_snapshot: std::option::Option<crate::model::DbClusterSnapshot>,
    }
    impl Builder {
        /// <p>Contains the details for an Amazon RDS DB cluster snapshot
        /// </p>
        /// <p>This data type is used as a response element
        /// in the <code>DescribeDBClusterSnapshots</code> action.
        /// </p>
        pub fn db_cluster_snapshot(mut self, input: crate::model::DbClusterSnapshot) -> Self {
            self.db_cluster_snapshot = Some(input);
            self
        }
        /// <p>Contains the details for an Amazon RDS DB cluster snapshot
        /// </p>
        /// <p>This data type is used as a response element
        /// in the <code>DescribeDBClusterSnapshots</code> action.
        /// </p>
        pub fn set_db_cluster_snapshot(
            mut self,
            input: std::option::Option<crate::model::DbClusterSnapshot>,
        ) -> Self {
            self.db_cluster_snapshot = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDbClusterSnapshotOutput`](crate::output::DeleteDbClusterSnapshotOutput)
        pub fn build(self) -> crate::output::DeleteDbClusterSnapshotOutput {
            crate::output::DeleteDbClusterSnapshotOutput {
                db_cluster_snapshot: self.db_cluster_snapshot,
            }
        }
    }
}
impl DeleteDbClusterSnapshotOutput {
    /// Creates a new builder-style object to manufacture [`DeleteDbClusterSnapshotOutput`](crate::output::DeleteDbClusterSnapshotOutput)
    pub fn builder() -> crate::output::delete_db_cluster_snapshot_output::Builder {
        crate::output::delete_db_cluster_snapshot_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDbClusterParameterGroupOutput {}
impl std::fmt::Debug for DeleteDbClusterParameterGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDbClusterParameterGroupOutput");
        formatter.finish()
    }
}
/// See [`DeleteDbClusterParameterGroupOutput`](crate::output::DeleteDbClusterParameterGroupOutput)
pub mod delete_db_cluster_parameter_group_output {
    /// A builder for [`DeleteDbClusterParameterGroupOutput`](crate::output::DeleteDbClusterParameterGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteDbClusterParameterGroupOutput`](crate::output::DeleteDbClusterParameterGroupOutput)
        pub fn build(self) -> crate::output::DeleteDbClusterParameterGroupOutput {
            crate::output::DeleteDbClusterParameterGroupOutput {}
        }
    }
}
impl DeleteDbClusterParameterGroupOutput {
    /// Creates a new builder-style object to manufacture [`DeleteDbClusterParameterGroupOutput`](crate::output::DeleteDbClusterParameterGroupOutput)
    pub fn builder() -> crate::output::delete_db_cluster_parameter_group_output::Builder {
        crate::output::delete_db_cluster_parameter_group_output::Builder::default()
    }
}

/// <p>This data type represents the information you need to connect to an Amazon Aurora DB cluster.
/// This data type is used as a response element in the following actions:</p>
/// <ul>
/// <li>
/// <p>
/// <code>CreateDBClusterEndpoint</code>
/// </p>
/// </li>
/// <li>
/// <p>
/// <code>DescribeDBClusterEndpoints</code>
/// </p>
/// </li>
/// <li>
/// <p>
/// <code>ModifyDBClusterEndpoint</code>
/// </p>
/// </li>
/// <li>
/// <p>
/// <code>DeleteDBClusterEndpoint</code>
/// </p>
/// </li>
/// </ul>
/// <p>For the data structure that represents Amazon RDS DB instance endpoints,
/// see <code>Endpoint</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDbClusterEndpointOutput {
    /// <p>The identifier associated with the endpoint. This parameter is stored as a lowercase string.</p>
    pub db_cluster_endpoint_identifier: std::option::Option<std::string::String>,
    /// <p>The DB cluster identifier of the DB cluster associated with the endpoint. This parameter is
    /// stored as a lowercase string.</p>
    pub db_cluster_identifier: std::option::Option<std::string::String>,
    /// <p>A unique system-generated identifier for an endpoint. It remains the same for the whole life of the endpoint.</p>
    pub db_cluster_endpoint_resource_identifier: std::option::Option<std::string::String>,
    /// <p>The DNS address of the endpoint.</p>
    pub endpoint: std::option::Option<std::string::String>,
    /// <p>The current status of the endpoint. One of: <code>creating</code>, <code>available</code>, <code>deleting</code>, <code>inactive</code>, <code>modifying</code>. The <code>inactive</code> state applies to an endpoint that can't be used for a certain kind of cluster,
    /// such as a <code>writer</code> endpoint for a read-only secondary cluster in a global database.</p>
    pub status: std::option::Option<std::string::String>,
    /// <p>The type of the endpoint. One of: <code>READER</code>, <code>WRITER</code>, <code>CUSTOM</code>.</p>
    pub endpoint_type: std::option::Option<std::string::String>,
    /// <p>The type associated with a custom endpoint. One of: <code>READER</code>,
    /// <code>WRITER</code>, <code>ANY</code>.</p>
    pub custom_endpoint_type: std::option::Option<std::string::String>,
    /// <p>List of DB instance identifiers that are part of the custom endpoint group.</p>
    pub static_members: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>List of DB instance identifiers that aren't part of the custom endpoint group.
    /// All other eligible instances are reachable through the custom endpoint.
    /// Only relevant if the list of static members is empty.</p>
    pub excluded_members: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The Amazon Resource Name (ARN) for the endpoint.</p>
    pub db_cluster_endpoint_arn: std::option::Option<std::string::String>,
}
impl DeleteDbClusterEndpointOutput {
    /// <p>The identifier associated with the endpoint. This parameter is stored as a lowercase string.</p>
    pub fn db_cluster_endpoint_identifier(&self) -> std::option::Option<&str> {
        self.db_cluster_endpoint_identifier.as_deref()
    }
    /// <p>The DB cluster identifier of the DB cluster associated with the endpoint. This parameter is
    /// stored as a lowercase string.</p>
    pub fn db_cluster_identifier(&self) -> std::option::Option<&str> {
        self.db_cluster_identifier.as_deref()
    }
    /// <p>A unique system-generated identifier for an endpoint. It remains the same for the whole life of the endpoint.</p>
    pub fn db_cluster_endpoint_resource_identifier(&self) -> std::option::Option<&str> {
        self.db_cluster_endpoint_resource_identifier.as_deref()
    }
    /// <p>The DNS address of the endpoint.</p>
    pub fn endpoint(&self) -> std::option::Option<&str> {
        self.endpoint.as_deref()
    }
    /// <p>The current status of the endpoint. One of: <code>creating</code>, <code>available</code>, <code>deleting</code>, <code>inactive</code>, <code>modifying</code>. The <code>inactive</code> state applies to an endpoint that can't be used for a certain kind of cluster,
    /// such as a <code>writer</code> endpoint for a read-only secondary cluster in a global database.</p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>The type of the endpoint. One of: <code>READER</code>, <code>WRITER</code>, <code>CUSTOM</code>.</p>
    pub fn endpoint_type(&self) -> std::option::Option<&str> {
        self.endpoint_type.as_deref()
    }
    /// <p>The type associated with a custom endpoint. One of: <code>READER</code>,
    /// <code>WRITER</code>, <code>ANY</code>.</p>
    pub fn custom_endpoint_type(&self) -> std::option::Option<&str> {
        self.custom_endpoint_type.as_deref()
    }
    /// <p>List of DB instance identifiers that are part of the custom endpoint group.</p>
    pub fn static_members(&self) -> std::option::Option<&[std::string::String]> {
        self.static_members.as_deref()
    }
    /// <p>List of DB instance identifiers that aren't part of the custom endpoint group.
    /// All other eligible instances are reachable through the custom endpoint.
    /// Only relevant if the list of static members is empty.</p>
    pub fn excluded_members(&self) -> std::option::Option<&[std::string::String]> {
        self.excluded_members.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) for the endpoint.</p>
    pub fn db_cluster_endpoint_arn(&self) -> std::option::Option<&str> {
        self.db_cluster_endpoint_arn.as_deref()
    }
}
impl std::fmt::Debug for DeleteDbClusterEndpointOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDbClusterEndpointOutput");
        formatter.field(
            "db_cluster_endpoint_identifier",
            &self.db_cluster_endpoint_identifier,
        );
        formatter.field("db_cluster_identifier", &self.db_cluster_identifier);
        formatter.field(
            "db_cluster_endpoint_resource_identifier",
            &self.db_cluster_endpoint_resource_identifier,
        );
        formatter.field("endpoint", &self.endpoint);
        formatter.field("status", &self.status);
        formatter.field("endpoint_type", &self.endpoint_type);
        formatter.field("custom_endpoint_type", &self.custom_endpoint_type);
        formatter.field("static_members", &self.static_members);
        formatter.field("excluded_members", &self.excluded_members);
        formatter.field("db_cluster_endpoint_arn", &self.db_cluster_endpoint_arn);
        formatter.finish()
    }
}
/// See [`DeleteDbClusterEndpointOutput`](crate::output::DeleteDbClusterEndpointOutput)
pub mod delete_db_cluster_endpoint_output {
    /// A builder for [`DeleteDbClusterEndpointOutput`](crate::output::DeleteDbClusterEndpointOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster_endpoint_identifier: std::option::Option<std::string::String>,
        pub(crate) db_cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) db_cluster_endpoint_resource_identifier:
            std::option::Option<std::string::String>,
        pub(crate) endpoint: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) endpoint_type: std::option::Option<std::string::String>,
        pub(crate) custom_endpoint_type: std::option::Option<std::string::String>,
        pub(crate) static_members: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) excluded_members: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) db_cluster_endpoint_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier associated with the endpoint. This parameter is stored as a lowercase string.</p>
        pub fn db_cluster_endpoint_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.db_cluster_endpoint_identifier = Some(input.into());
            self
        }
        /// <p>The identifier associated with the endpoint. This parameter is stored as a lowercase string.</p>
        pub fn set_db_cluster_endpoint_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_endpoint_identifier = input;
            self
        }
        /// <p>The DB cluster identifier of the DB cluster associated with the endpoint. This parameter is
        /// stored as a lowercase string.</p>
        pub fn db_cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_cluster_identifier = Some(input.into());
            self
        }
        /// <p>The DB cluster identifier of the DB cluster associated with the endpoint. This parameter is
        /// stored as a lowercase string.</p>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_identifier = input;
            self
        }
        /// <p>A unique system-generated identifier for an endpoint. It remains the same for the whole life of the endpoint.</p>
        pub fn db_cluster_endpoint_resource_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.db_cluster_endpoint_resource_identifier = Some(input.into());
            self
        }
        /// <p>A unique system-generated identifier for an endpoint. It remains the same for the whole life of the endpoint.</p>
        pub fn set_db_cluster_endpoint_resource_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_endpoint_resource_identifier = input;
            self
        }
        /// <p>The DNS address of the endpoint.</p>
        pub fn endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint = Some(input.into());
            self
        }
        /// <p>The DNS address of the endpoint.</p>
        pub fn set_endpoint(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.endpoint = input;
            self
        }
        /// <p>The current status of the endpoint. One of: <code>creating</code>, <code>available</code>, <code>deleting</code>, <code>inactive</code>, <code>modifying</code>. The <code>inactive</code> state applies to an endpoint that can't be used for a certain kind of cluster,
        /// such as a <code>writer</code> endpoint for a read-only secondary cluster in a global database.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The current status of the endpoint. One of: <code>creating</code>, <code>available</code>, <code>deleting</code>, <code>inactive</code>, <code>modifying</code>. The <code>inactive</code> state applies to an endpoint that can't be used for a certain kind of cluster,
        /// such as a <code>writer</code> endpoint for a read-only secondary cluster in a global database.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>The type of the endpoint. One of: <code>READER</code>, <code>WRITER</code>, <code>CUSTOM</code>.</p>
        pub fn endpoint_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_type = Some(input.into());
            self
        }
        /// <p>The type of the endpoint. One of: <code>READER</code>, <code>WRITER</code>, <code>CUSTOM</code>.</p>
        pub fn set_endpoint_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.endpoint_type = input;
            self
        }
        /// <p>The type associated with a custom endpoint. One of: <code>READER</code>,
        /// <code>WRITER</code>, <code>ANY</code>.</p>
        pub fn custom_endpoint_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.custom_endpoint_type = Some(input.into());
            self
        }
        /// <p>The type associated with a custom endpoint. One of: <code>READER</code>,
        /// <code>WRITER</code>, <code>ANY</code>.</p>
        pub fn set_custom_endpoint_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.custom_endpoint_type = input;
            self
        }
        /// Appends an item to `static_members`.
        ///
        /// To override the contents of this collection use [`set_static_members`](Self::set_static_members).
        ///
        /// <p>List of DB instance identifiers that are part of the custom endpoint group.</p>
        pub fn static_members(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.static_members.unwrap_or_default();
            v.push(input.into());
            self.static_members = Some(v);
            self
        }
        /// <p>List of DB instance identifiers that are part of the custom endpoint group.</p>
        pub fn set_static_members(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.static_members = input;
            self
        }
        /// Appends an item to `excluded_members`.
        ///
        /// To override the contents of this collection use [`set_excluded_members`](Self::set_excluded_members).
        ///
        /// <p>List of DB instance identifiers that aren't part of the custom endpoint group.
        /// All other eligible instances are reachable through the custom endpoint.
        /// Only relevant if the list of static members is empty.</p>
        pub fn excluded_members(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.excluded_members.unwrap_or_default();
            v.push(input.into());
            self.excluded_members = Some(v);
            self
        }
        /// <p>List of DB instance identifiers that aren't part of the custom endpoint group.
        /// All other eligible instances are reachable through the custom endpoint.
        /// Only relevant if the list of static members is empty.</p>
        pub fn set_excluded_members(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.excluded_members = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the endpoint.</p>
        pub fn db_cluster_endpoint_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_cluster_endpoint_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the endpoint.</p>
        pub fn set_db_cluster_endpoint_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_endpoint_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDbClusterEndpointOutput`](crate::output::DeleteDbClusterEndpointOutput)
        pub fn build(self) -> crate::output::DeleteDbClusterEndpointOutput {
            crate::output::DeleteDbClusterEndpointOutput {
                db_cluster_endpoint_identifier: self.db_cluster_endpoint_identifier,
                db_cluster_identifier: self.db_cluster_identifier,
                db_cluster_endpoint_resource_identifier: self
                    .db_cluster_endpoint_resource_identifier,
                endpoint: self.endpoint,
                status: self.status,
                endpoint_type: self.endpoint_type,
                custom_endpoint_type: self.custom_endpoint_type,
                static_members: self.static_members,
                excluded_members: self.excluded_members,
                db_cluster_endpoint_arn: self.db_cluster_endpoint_arn,
            }
        }
    }
}
impl DeleteDbClusterEndpointOutput {
    /// Creates a new builder-style object to manufacture [`DeleteDbClusterEndpointOutput`](crate::output::DeleteDbClusterEndpointOutput)
    pub fn builder() -> crate::output::delete_db_cluster_endpoint_output::Builder {
        crate::output::delete_db_cluster_endpoint_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDbClusterOutput {
    /// <p>Contains the details of an Amazon Aurora DB cluster.
    /// </p>
    /// <p>This data type is used as a response element in the <code>DescribeDBClusters</code>,
    /// <code>StopDBCluster</code>, and <code>StartDBCluster</code> actions.
    /// </p>
    pub db_cluster: std::option::Option<crate::model::DbCluster>,
}
impl DeleteDbClusterOutput {
    /// <p>Contains the details of an Amazon Aurora DB cluster.
    /// </p>
    /// <p>This data type is used as a response element in the <code>DescribeDBClusters</code>,
    /// <code>StopDBCluster</code>, and <code>StartDBCluster</code> actions.
    /// </p>
    pub fn db_cluster(&self) -> std::option::Option<&crate::model::DbCluster> {
        self.db_cluster.as_ref()
    }
}
impl std::fmt::Debug for DeleteDbClusterOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDbClusterOutput");
        formatter.field("db_cluster", &self.db_cluster);
        formatter.finish()
    }
}
/// See [`DeleteDbClusterOutput`](crate::output::DeleteDbClusterOutput)
pub mod delete_db_cluster_output {
    /// A builder for [`DeleteDbClusterOutput`](crate::output::DeleteDbClusterOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster: std::option::Option<crate::model::DbCluster>,
    }
    impl Builder {
        /// <p>Contains the details of an Amazon Aurora DB cluster.
        /// </p>
        /// <p>This data type is used as a response element in the <code>DescribeDBClusters</code>,
        /// <code>StopDBCluster</code>, and <code>StartDBCluster</code> actions.
        /// </p>
        pub fn db_cluster(mut self, input: crate::model::DbCluster) -> Self {
            self.db_cluster = Some(input);
            self
        }
        /// <p>Contains the details of an Amazon Aurora DB cluster.
        /// </p>
        /// <p>This data type is used as a response element in the <code>DescribeDBClusters</code>,
        /// <code>StopDBCluster</code>, and <code>StartDBCluster</code> actions.
        /// </p>
        pub fn set_db_cluster(
            mut self,
            input: std::option::Option<crate::model::DbCluster>,
        ) -> Self {
            self.db_cluster = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDbClusterOutput`](crate::output::DeleteDbClusterOutput)
        pub fn build(self) -> crate::output::DeleteDbClusterOutput {
            crate::output::DeleteDbClusterOutput {
                db_cluster: self.db_cluster,
            }
        }
    }
}
impl DeleteDbClusterOutput {
    /// Creates a new builder-style object to manufacture [`DeleteDbClusterOutput`](crate::output::DeleteDbClusterOutput)
    pub fn builder() -> crate::output::delete_db_cluster_output::Builder {
        crate::output::delete_db_cluster_output::Builder::default()
    }
}

/// <p>
/// This data type is used as a response element in the action <code>DescribeDBEngineVersions</code>.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteCustomDbEngineVersionOutput {
    /// <p>The name of the database engine.</p>
    pub engine: std::option::Option<std::string::String>,
    /// <p>The version number of the database engine.</p>
    pub engine_version: std::option::Option<std::string::String>,
    /// <p>The name of the DB parameter group family for the database engine.</p>
    pub db_parameter_group_family: std::option::Option<std::string::String>,
    /// <p>The description of the database engine.</p>
    pub db_engine_description: std::option::Option<std::string::String>,
    /// <p>The description of the database engine version.</p>
    pub db_engine_version_description: std::option::Option<std::string::String>,
    /// <p>
    /// The default character set for new instances of this engine version,
    /// if the <code>CharacterSetName</code> parameter of the CreateDBInstance API
    /// isn't specified.
    /// </p>
    pub default_character_set: std::option::Option<crate::model::CharacterSet>,
    /// <p>A list of the character sets supported by this engine for the <code>CharacterSetName</code> parameter of the <code>CreateDBInstance</code> operation.  
    /// </p>
    pub supported_character_sets: std::option::Option<std::vec::Vec<crate::model::CharacterSet>>,
    /// <p>A list of the character sets supported by the Oracle DB engine for the <code>NcharCharacterSetName</code> parameter of the <code>CreateDBInstance</code> operation.  
    /// </p>
    pub supported_nchar_character_sets:
        std::option::Option<std::vec::Vec<crate::model::CharacterSet>>,
    /// <p>A list of engine versions that this database engine version can be upgraded to.</p>
    pub valid_upgrade_target: std::option::Option<std::vec::Vec<crate::model::UpgradeTarget>>,
    /// <p>A list of the time zones supported by this engine for the
    /// <code>Timezone</code> parameter of the <code>CreateDBInstance</code> action.  
    /// </p>
    pub supported_timezones: std::option::Option<std::vec::Vec<crate::model::Timezone>>,
    /// <p>The types of logs that the database engine has available for export to CloudWatch Logs.</p>
    pub exportable_log_types: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A value that indicates whether the engine version supports exporting the log types specified by ExportableLogTypes to CloudWatch Logs.</p>
    pub supports_log_exports_to_cloudwatch_logs: bool,
    /// <p>Indicates whether the database engine version supports read replicas.</p>
    pub supports_read_replica: bool,
    /// <p>A list of the supported DB engine modes.</p>
    pub supported_engine_modes: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>
    /// A list of features supported by the DB engine.
    /// </p>
    /// <p>The supported features vary by DB engine and DB engine version.</p>
    /// <p>To determine the supported features for a specific DB engine and DB engine version using the CLI,
    /// use the following command:</p>
    /// <p>
    /// <code>aws rds describe-db-engine-versions --engine <engine_name> --engine-version <engine_version></code>
    /// </p>
    /// <p>For example, to determine the supported features for RDS for PostgreSQL version 13.3 using the CLI,
    /// use the following command:</p>
    /// <p>
    /// <code>aws rds describe-db-engine-versions --engine postgres --engine-version 13.3</code>
    /// </p>
    /// <p>The supported features are listed under <code>SupportedFeatureNames</code> in the output.</p>
    pub supported_feature_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The status of the DB engine version, either <code>available</code> or <code>deprecated</code>.</p>
    pub status: std::option::Option<std::string::String>,
    /// <p>A value that indicates whether you can use Aurora parallel query with a specific DB engine version.</p>
    pub supports_parallel_query: bool,
    /// <p>A value that indicates whether you can use Aurora global databases with a specific DB engine version.</p>
    pub supports_global_databases: bool,
    /// <p>The major engine version of the CEV.</p>
    pub major_engine_version: std::option::Option<std::string::String>,
    /// <p>The name of the Amazon S3 bucket that contains your database installation files.</p>
    pub database_installation_files_s3_bucket_name: std::option::Option<std::string::String>,
    /// <p>The Amazon S3 directory that contains the database installation files.
    /// If not specified, then no prefix is assumed.</p>
    pub database_installation_files_s3_prefix: std::option::Option<std::string::String>,
    /// <p>The ARN of the custom engine version.</p>
    pub db_engine_version_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services KMS key identifier for an encrypted CEV. This parameter is required for
    /// RDS Custom, but optional for Amazon RDS.</p>
    pub kms_key_id: std::option::Option<std::string::String>,
    /// <p>The creation time of the DB engine version.</p>
    pub create_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>A list of tags.
    /// For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources</a> in the <i>Amazon RDS User Guide.</i>           
    /// </p>
    pub tag_list: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl DeleteCustomDbEngineVersionOutput {
    /// <p>The name of the database engine.</p>
    pub fn engine(&self) -> std::option::Option<&str> {
        self.engine.as_deref()
    }
    /// <p>The version number of the database engine.</p>
    pub fn engine_version(&self) -> std::option::Option<&str> {
        self.engine_version.as_deref()
    }
    /// <p>The name of the DB parameter group family for the database engine.</p>
    pub fn db_parameter_group_family(&self) -> std::option::Option<&str> {
        self.db_parameter_group_family.as_deref()
    }
    /// <p>The description of the database engine.</p>
    pub fn db_engine_description(&self) -> std::option::Option<&str> {
        self.db_engine_description.as_deref()
    }
    /// <p>The description of the database engine version.</p>
    pub fn db_engine_version_description(&self) -> std::option::Option<&str> {
        self.db_engine_version_description.as_deref()
    }
    /// <p>
    /// The default character set for new instances of this engine version,
    /// if the <code>CharacterSetName</code> parameter of the CreateDBInstance API
    /// isn't specified.
    /// </p>
    pub fn default_character_set(&self) -> std::option::Option<&crate::model::CharacterSet> {
        self.default_character_set.as_ref()
    }
    /// <p>A list of the character sets supported by this engine for the <code>CharacterSetName</code> parameter of the <code>CreateDBInstance</code> operation.  
    /// </p>
    pub fn supported_character_sets(&self) -> std::option::Option<&[crate::model::CharacterSet]> {
        self.supported_character_sets.as_deref()
    }
    /// <p>A list of the character sets supported by the Oracle DB engine for the <code>NcharCharacterSetName</code> parameter of the <code>CreateDBInstance</code> operation.  
    /// </p>
    pub fn supported_nchar_character_sets(
        &self,
    ) -> std::option::Option<&[crate::model::CharacterSet]> {
        self.supported_nchar_character_sets.as_deref()
    }
    /// <p>A list of engine versions that this database engine version can be upgraded to.</p>
    pub fn valid_upgrade_target(&self) -> std::option::Option<&[crate::model::UpgradeTarget]> {
        self.valid_upgrade_target.as_deref()
    }
    /// <p>A list of the time zones supported by this engine for the
    /// <code>Timezone</code> parameter of the <code>CreateDBInstance</code> action.  
    /// </p>
    pub fn supported_timezones(&self) -> std::option::Option<&[crate::model::Timezone]> {
        self.supported_timezones.as_deref()
    }
    /// <p>The types of logs that the database engine has available for export to CloudWatch Logs.</p>
    pub fn exportable_log_types(&self) -> std::option::Option<&[std::string::String]> {
        self.exportable_log_types.as_deref()
    }
    /// <p>A value that indicates whether the engine version supports exporting the log types specified by ExportableLogTypes to CloudWatch Logs.</p>
    pub fn supports_log_exports_to_cloudwatch_logs(&self) -> bool {
        self.supports_log_exports_to_cloudwatch_logs
    }
    /// <p>Indicates whether the database engine version supports read replicas.</p>
    pub fn supports_read_replica(&self) -> bool {
        self.supports_read_replica
    }
    /// <p>A list of the supported DB engine modes.</p>
    pub fn supported_engine_modes(&self) -> std::option::Option<&[std::string::String]> {
        self.supported_engine_modes.as_deref()
    }
    /// <p>
    /// A list of features supported by the DB engine.
    /// </p>
    /// <p>The supported features vary by DB engine and DB engine version.</p>
    /// <p>To determine the supported features for a specific DB engine and DB engine version using the CLI,
    /// use the following command:</p>
    /// <p>
    /// <code>aws rds describe-db-engine-versions --engine <engine_name> --engine-version <engine_version></code>
    /// </p>
    /// <p>For example, to determine the supported features for RDS for PostgreSQL version 13.3 using the CLI,
    /// use the following command:</p>
    /// <p>
    /// <code>aws rds describe-db-engine-versions --engine postgres --engine-version 13.3</code>
    /// </p>
    /// <p>The supported features are listed under <code>SupportedFeatureNames</code> in the output.</p>
    pub fn supported_feature_names(&self) -> std::option::Option<&[std::string::String]> {
        self.supported_feature_names.as_deref()
    }
    /// <p>The status of the DB engine version, either <code>available</code> or <code>deprecated</code>.</p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>A value that indicates whether you can use Aurora parallel query with a specific DB engine version.</p>
    pub fn supports_parallel_query(&self) -> bool {
        self.supports_parallel_query
    }
    /// <p>A value that indicates whether you can use Aurora global databases with a specific DB engine version.</p>
    pub fn supports_global_databases(&self) -> bool {
        self.supports_global_databases
    }
    /// <p>The major engine version of the CEV.</p>
    pub fn major_engine_version(&self) -> std::option::Option<&str> {
        self.major_engine_version.as_deref()
    }
    /// <p>The name of the Amazon S3 bucket that contains your database installation files.</p>
    pub fn database_installation_files_s3_bucket_name(&self) -> std::option::Option<&str> {
        self.database_installation_files_s3_bucket_name.as_deref()
    }
    /// <p>The Amazon S3 directory that contains the database installation files.
    /// If not specified, then no prefix is assumed.</p>
    pub fn database_installation_files_s3_prefix(&self) -> std::option::Option<&str> {
        self.database_installation_files_s3_prefix.as_deref()
    }
    /// <p>The ARN of the custom engine version.</p>
    pub fn db_engine_version_arn(&self) -> std::option::Option<&str> {
        self.db_engine_version_arn.as_deref()
    }
    /// <p>The Amazon Web Services KMS key identifier for an encrypted CEV. This parameter is required for
    /// RDS Custom, but optional for Amazon RDS.</p>
    pub fn kms_key_id(&self) -> std::option::Option<&str> {
        self.kms_key_id.as_deref()
    }
    /// <p>The creation time of the DB engine version.</p>
    pub fn create_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.create_time.as_ref()
    }
    /// <p>A list of tags.
    /// For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources</a> in the <i>Amazon RDS User Guide.</i>           
    /// </p>
    pub fn tag_list(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tag_list.as_deref()
    }
}
impl std::fmt::Debug for DeleteCustomDbEngineVersionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteCustomDbEngineVersionOutput");
        formatter.field("engine", &self.engine);
        formatter.field("engine_version", &self.engine_version);
        formatter.field("db_parameter_group_family", &self.db_parameter_group_family);
        formatter.field("db_engine_description", &self.db_engine_description);
        formatter.field(
            "db_engine_version_description",
            &self.db_engine_version_description,
        );
        formatter.field("default_character_set", &self.default_character_set);
        formatter.field("supported_character_sets", &self.supported_character_sets);
        formatter.field(
            "supported_nchar_character_sets",
            &self.supported_nchar_character_sets,
        );
        formatter.field("valid_upgrade_target", &self.valid_upgrade_target);
        formatter.field("supported_timezones", &self.supported_timezones);
        formatter.field("exportable_log_types", &self.exportable_log_types);
        formatter.field(
            "supports_log_exports_to_cloudwatch_logs",
            &self.supports_log_exports_to_cloudwatch_logs,
        );
        formatter.field("supports_read_replica", &self.supports_read_replica);
        formatter.field("supported_engine_modes", &self.supported_engine_modes);
        formatter.field("supported_feature_names", &self.supported_feature_names);
        formatter.field("status", &self.status);
        formatter.field("supports_parallel_query", &self.supports_parallel_query);
        formatter.field("supports_global_databases", &self.supports_global_databases);
        formatter.field("major_engine_version", &self.major_engine_version);
        formatter.field(
            "database_installation_files_s3_bucket_name",
            &self.database_installation_files_s3_bucket_name,
        );
        formatter.field(
            "database_installation_files_s3_prefix",
            &self.database_installation_files_s3_prefix,
        );
        formatter.field("db_engine_version_arn", &self.db_engine_version_arn);
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.field("create_time", &self.create_time);
        formatter.field("tag_list", &self.tag_list);
        formatter.finish()
    }
}
/// See [`DeleteCustomDbEngineVersionOutput`](crate::output::DeleteCustomDbEngineVersionOutput)
pub mod delete_custom_db_engine_version_output {
    /// A builder for [`DeleteCustomDbEngineVersionOutput`](crate::output::DeleteCustomDbEngineVersionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) engine: std::option::Option<std::string::String>,
        pub(crate) engine_version: std::option::Option<std::string::String>,
        pub(crate) db_parameter_group_family: std::option::Option<std::string::String>,
        pub(crate) db_engine_description: std::option::Option<std::string::String>,
        pub(crate) db_engine_version_description: std::option::Option<std::string::String>,
        pub(crate) default_character_set: std::option::Option<crate::model::CharacterSet>,
        pub(crate) supported_character_sets:
            std::option::Option<std::vec::Vec<crate::model::CharacterSet>>,
        pub(crate) supported_nchar_character_sets:
            std::option::Option<std::vec::Vec<crate::model::CharacterSet>>,
        pub(crate) valid_upgrade_target:
            std::option::Option<std::vec::Vec<crate::model::UpgradeTarget>>,
        pub(crate) supported_timezones: std::option::Option<std::vec::Vec<crate::model::Timezone>>,
        pub(crate) exportable_log_types: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) supports_log_exports_to_cloudwatch_logs: std::option::Option<bool>,
        pub(crate) supports_read_replica: std::option::Option<bool>,
        pub(crate) supported_engine_modes: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) supported_feature_names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) supports_parallel_query: std::option::Option<bool>,
        pub(crate) supports_global_databases: std::option::Option<bool>,
        pub(crate) major_engine_version: std::option::Option<std::string::String>,
        pub(crate) database_installation_files_s3_bucket_name:
            std::option::Option<std::string::String>,
        pub(crate) database_installation_files_s3_prefix: std::option::Option<std::string::String>,
        pub(crate) db_engine_version_arn: std::option::Option<std::string::String>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
        pub(crate) create_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) tag_list: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of the database engine.</p>
        pub fn engine(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine = Some(input.into());
            self
        }
        /// <p>The name of the database engine.</p>
        pub fn set_engine(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.engine = input;
            self
        }
        /// <p>The version number of the database engine.</p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_version = Some(input.into());
            self
        }
        /// <p>The version number of the database engine.</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.engine_version = input;
            self
        }
        /// <p>The name of the DB parameter group family for the database engine.</p>
        pub fn db_parameter_group_family(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_parameter_group_family = Some(input.into());
            self
        }
        /// <p>The name of the DB parameter group family for the database engine.</p>
        pub fn set_db_parameter_group_family(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_parameter_group_family = input;
            self
        }
        /// <p>The description of the database engine.</p>
        pub fn db_engine_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_engine_description = Some(input.into());
            self
        }
        /// <p>The description of the database engine.</p>
        pub fn set_db_engine_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_engine_description = input;
            self
        }
        /// <p>The description of the database engine version.</p>
        pub fn db_engine_version_description(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.db_engine_version_description = Some(input.into());
            self
        }
        /// <p>The description of the database engine version.</p>
        pub fn set_db_engine_version_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_engine_version_description = input;
            self
        }
        /// <p>
        /// The default character set for new instances of this engine version,
        /// if the <code>CharacterSetName</code> parameter of the CreateDBInstance API
        /// isn't specified.
        /// </p>
        pub fn default_character_set(mut self, input: crate::model::CharacterSet) -> Self {
            self.default_character_set = Some(input);
            self
        }
        /// <p>
        /// The default character set for new instances of this engine version,
        /// if the <code>CharacterSetName</code> parameter of the CreateDBInstance API
        /// isn't specified.
        /// </p>
        pub fn set_default_character_set(
            mut self,
            input: std::option::Option<crate::model::CharacterSet>,
        ) -> Self {
            self.default_character_set = input;
            self
        }
        /// Appends an item to `supported_character_sets`.
        ///
        /// To override the contents of this collection use [`set_supported_character_sets`](Self::set_supported_character_sets).
        ///
        /// <p>A list of the character sets supported by this engine for the <code>CharacterSetName</code> parameter of the <code>CreateDBInstance</code> operation.  
        /// </p>
        pub fn supported_character_sets(
            mut self,
            input: impl Into<crate::model::CharacterSet>,
        ) -> Self {
            let mut v = self.supported_character_sets.unwrap_or_default();
            v.push(input.into());
            self.supported_character_sets = Some(v);
            self
        }
        /// <p>A list of the character sets supported by this engine for the <code>CharacterSetName</code> parameter of the <code>CreateDBInstance</code> operation.  
        /// </p>
        pub fn set_supported_character_sets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CharacterSet>>,
        ) -> Self {
            self.supported_character_sets = input;
            self
        }
        /// Appends an item to `supported_nchar_character_sets`.
        ///
        /// To override the contents of this collection use [`set_supported_nchar_character_sets`](Self::set_supported_nchar_character_sets).
        ///
        /// <p>A list of the character sets supported by the Oracle DB engine for the <code>NcharCharacterSetName</code> parameter of the <code>CreateDBInstance</code> operation.  
        /// </p>
        pub fn supported_nchar_character_sets(
            mut self,
            input: impl Into<crate::model::CharacterSet>,
        ) -> Self {
            let mut v = self.supported_nchar_character_sets.unwrap_or_default();
            v.push(input.into());
            self.supported_nchar_character_sets = Some(v);
            self
        }
        /// <p>A list of the character sets supported by the Oracle DB engine for the <code>NcharCharacterSetName</code> parameter of the <code>CreateDBInstance</code> operation.  
        /// </p>
        pub fn set_supported_nchar_character_sets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CharacterSet>>,
        ) -> Self {
            self.supported_nchar_character_sets = input;
            self
        }
        /// Appends an item to `valid_upgrade_target`.
        ///
        /// To override the contents of this collection use [`set_valid_upgrade_target`](Self::set_valid_upgrade_target).
        ///
        /// <p>A list of engine versions that this database engine version can be upgraded to.</p>
        pub fn valid_upgrade_target(
            mut self,
            input: impl Into<crate::model::UpgradeTarget>,
        ) -> Self {
            let mut v = self.valid_upgrade_target.unwrap_or_default();
            v.push(input.into());
            self.valid_upgrade_target = Some(v);
            self
        }
        /// <p>A list of engine versions that this database engine version can be upgraded to.</p>
        pub fn set_valid_upgrade_target(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UpgradeTarget>>,
        ) -> Self {
            self.valid_upgrade_target = input;
            self
        }
        /// Appends an item to `supported_timezones`.
        ///
        /// To override the contents of this collection use [`set_supported_timezones`](Self::set_supported_timezones).
        ///
        /// <p>A list of the time zones supported by this engine for the
        /// <code>Timezone</code> parameter of the <code>CreateDBInstance</code> action.  
        /// </p>
        pub fn supported_timezones(mut self, input: impl Into<crate::model::Timezone>) -> Self {
            let mut v = self.supported_timezones.unwrap_or_default();
            v.push(input.into());
            self.supported_timezones = Some(v);
            self
        }
        /// <p>A list of the time zones supported by this engine for the
        /// <code>Timezone</code> parameter of the <code>CreateDBInstance</code> action.  
        /// </p>
        pub fn set_supported_timezones(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Timezone>>,
        ) -> Self {
            self.supported_timezones = input;
            self
        }
        /// Appends an item to `exportable_log_types`.
        ///
        /// To override the contents of this collection use [`set_exportable_log_types`](Self::set_exportable_log_types).
        ///
        /// <p>The types of logs that the database engine has available for export to CloudWatch Logs.</p>
        pub fn exportable_log_types(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.exportable_log_types.unwrap_or_default();
            v.push(input.into());
            self.exportable_log_types = Some(v);
            self
        }
        /// <p>The types of logs that the database engine has available for export to CloudWatch Logs.</p>
        pub fn set_exportable_log_types(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.exportable_log_types = input;
            self
        }
        /// <p>A value that indicates whether the engine version supports exporting the log types specified by ExportableLogTypes to CloudWatch Logs.</p>
        pub fn supports_log_exports_to_cloudwatch_logs(mut self, input: bool) -> Self {
            self.supports_log_exports_to_cloudwatch_logs = Some(input);
            self
        }
        /// <p>A value that indicates whether the engine version supports exporting the log types specified by ExportableLogTypes to CloudWatch Logs.</p>
        pub fn set_supports_log_exports_to_cloudwatch_logs(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.supports_log_exports_to_cloudwatch_logs = input;
            self
        }
        /// <p>Indicates whether the database engine version supports read replicas.</p>
        pub fn supports_read_replica(mut self, input: bool) -> Self {
            self.supports_read_replica = Some(input);
            self
        }
        /// <p>Indicates whether the database engine version supports read replicas.</p>
        pub fn set_supports_read_replica(mut self, input: std::option::Option<bool>) -> Self {
            self.supports_read_replica = input;
            self
        }
        /// Appends an item to `supported_engine_modes`.
        ///
        /// To override the contents of this collection use [`set_supported_engine_modes`](Self::set_supported_engine_modes).
        ///
        /// <p>A list of the supported DB engine modes.</p>
        pub fn supported_engine_modes(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.supported_engine_modes.unwrap_or_default();
            v.push(input.into());
            self.supported_engine_modes = Some(v);
            self
        }
        /// <p>A list of the supported DB engine modes.</p>
        pub fn set_supported_engine_modes(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.supported_engine_modes = input;
            self
        }
        /// Appends an item to `supported_feature_names`.
        ///
        /// To override the contents of this collection use [`set_supported_feature_names`](Self::set_supported_feature_names).
        ///
        /// <p>
        /// A list of features supported by the DB engine.
        /// </p>
        /// <p>The supported features vary by DB engine and DB engine version.</p>
        /// <p>To determine the supported features for a specific DB engine and DB engine version using the CLI,
        /// use the following command:</p>
        /// <p>
        /// <code>aws rds describe-db-engine-versions --engine <engine_name> --engine-version <engine_version></code>
        /// </p>
        /// <p>For example, to determine the supported features for RDS for PostgreSQL version 13.3 using the CLI,
        /// use the following command:</p>
        /// <p>
        /// <code>aws rds describe-db-engine-versions --engine postgres --engine-version 13.3</code>
        /// </p>
        /// <p>The supported features are listed under <code>SupportedFeatureNames</code> in the output.</p>
        pub fn supported_feature_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.supported_feature_names.unwrap_or_default();
            v.push(input.into());
            self.supported_feature_names = Some(v);
            self
        }
        /// <p>
        /// A list of features supported by the DB engine.
        /// </p>
        /// <p>The supported features vary by DB engine and DB engine version.</p>
        /// <p>To determine the supported features for a specific DB engine and DB engine version using the CLI,
        /// use the following command:</p>
        /// <p>
        /// <code>aws rds describe-db-engine-versions --engine <engine_name> --engine-version <engine_version></code>
        /// </p>
        /// <p>For example, to determine the supported features for RDS for PostgreSQL version 13.3 using the CLI,
        /// use the following command:</p>
        /// <p>
        /// <code>aws rds describe-db-engine-versions --engine postgres --engine-version 13.3</code>
        /// </p>
        /// <p>The supported features are listed under <code>SupportedFeatureNames</code> in the output.</p>
        pub fn set_supported_feature_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.supported_feature_names = input;
            self
        }
        /// <p>The status of the DB engine version, either <code>available</code> or <code>deprecated</code>.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the DB engine version, either <code>available</code> or <code>deprecated</code>.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>A value that indicates whether you can use Aurora parallel query with a specific DB engine version.</p>
        pub fn supports_parallel_query(mut self, input: bool) -> Self {
            self.supports_parallel_query = Some(input);
            self
        }
        /// <p>A value that indicates whether you can use Aurora parallel query with a specific DB engine version.</p>
        pub fn set_supports_parallel_query(mut self, input: std::option::Option<bool>) -> Self {
            self.supports_parallel_query = input;
            self
        }
        /// <p>A value that indicates whether you can use Aurora global databases with a specific DB engine version.</p>
        pub fn supports_global_databases(mut self, input: bool) -> Self {
            self.supports_global_databases = Some(input);
            self
        }
        /// <p>A value that indicates whether you can use Aurora global databases with a specific DB engine version.</p>
        pub fn set_supports_global_databases(mut self, input: std::option::Option<bool>) -> Self {
            self.supports_global_databases = input;
            self
        }
        /// <p>The major engine version of the CEV.</p>
        pub fn major_engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.major_engine_version = Some(input.into());
            self
        }
        /// <p>The major engine version of the CEV.</p>
        pub fn set_major_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.major_engine_version = input;
            self
        }
        /// <p>The name of the Amazon S3 bucket that contains your database installation files.</p>
        pub fn database_installation_files_s3_bucket_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.database_installation_files_s3_bucket_name = Some(input.into());
            self
        }
        /// <p>The name of the Amazon S3 bucket that contains your database installation files.</p>
        pub fn set_database_installation_files_s3_bucket_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.database_installation_files_s3_bucket_name = input;
            self
        }
        /// <p>The Amazon S3 directory that contains the database installation files.
        /// If not specified, then no prefix is assumed.</p>
        pub fn database_installation_files_s3_prefix(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.database_installation_files_s3_prefix = Some(input.into());
            self
        }
        /// <p>The Amazon S3 directory that contains the database installation files.
        /// If not specified, then no prefix is assumed.</p>
        pub fn set_database_installation_files_s3_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.database_installation_files_s3_prefix = input;
            self
        }
        /// <p>The ARN of the custom engine version.</p>
        pub fn db_engine_version_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_engine_version_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the custom engine version.</p>
        pub fn set_db_engine_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_engine_version_arn = input;
            self
        }
        /// <p>The Amazon Web Services KMS key identifier for an encrypted CEV. This parameter is required for
        /// RDS Custom, but optional for Amazon RDS.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services KMS key identifier for an encrypted CEV. This parameter is required for
        /// RDS Custom, but optional for Amazon RDS.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// <p>The creation time of the DB engine version.</p>
        pub fn create_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.create_time = Some(input);
            self
        }
        /// <p>The creation time of the DB engine version.</p>
        pub fn set_create_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.create_time = input;
            self
        }
        /// Appends an item to `tag_list`.
        ///
        /// To override the contents of this collection use [`set_tag_list`](Self::set_tag_list).
        ///
        /// <p>A list of tags.
        /// For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources</a> in the <i>Amazon RDS User Guide.</i>           
        /// </p>
        pub fn tag_list(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tag_list.unwrap_or_default();
            v.push(input.into());
            self.tag_list = Some(v);
            self
        }
        /// <p>A list of tags.
        /// For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources</a> in the <i>Amazon RDS User Guide.</i>           
        /// </p>
        pub fn set_tag_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tag_list = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteCustomDbEngineVersionOutput`](crate::output::DeleteCustomDbEngineVersionOutput)
        pub fn build(self) -> crate::output::DeleteCustomDbEngineVersionOutput {
            crate::output::DeleteCustomDbEngineVersionOutput {
                engine: self.engine,
                engine_version: self.engine_version,
                db_parameter_group_family: self.db_parameter_group_family,
                db_engine_description: self.db_engine_description,
                db_engine_version_description: self.db_engine_version_description,
                default_character_set: self.default_character_set,
                supported_character_sets: self.supported_character_sets,
                supported_nchar_character_sets: self.supported_nchar_character_sets,
                valid_upgrade_target: self.valid_upgrade_target,
                supported_timezones: self.supported_timezones,
                exportable_log_types: self.exportable_log_types,
                supports_log_exports_to_cloudwatch_logs: self
                    .supports_log_exports_to_cloudwatch_logs
                    .unwrap_or_default(),
                supports_read_replica: self.supports_read_replica.unwrap_or_default(),
                supported_engine_modes: self.supported_engine_modes,
                supported_feature_names: self.supported_feature_names,
                status: self.status,
                supports_parallel_query: self.supports_parallel_query.unwrap_or_default(),
                supports_global_databases: self.supports_global_databases.unwrap_or_default(),
                major_engine_version: self.major_engine_version,
                database_installation_files_s3_bucket_name: self
                    .database_installation_files_s3_bucket_name,
                database_installation_files_s3_prefix: self.database_installation_files_s3_prefix,
                db_engine_version_arn: self.db_engine_version_arn,
                kms_key_id: self.kms_key_id,
                create_time: self.create_time,
                tag_list: self.tag_list,
            }
        }
    }
}
impl DeleteCustomDbEngineVersionOutput {
    /// Creates a new builder-style object to manufacture [`DeleteCustomDbEngineVersionOutput`](crate::output::DeleteCustomDbEngineVersionOutput)
    pub fn builder() -> crate::output::delete_custom_db_engine_version_output::Builder {
        crate::output::delete_custom_db_engine_version_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteCustomAvailabilityZoneOutput {
    /// <p>A custom Availability Zone (AZ) is an on-premises AZ that is integrated with a VMware vSphere cluster.</p>
    /// <p>For more information about RDS on VMware, see the
    /// <a href="https://docs.aws.amazon.com/AmazonRDS/latest/RDSonVMwareUserGuide/rds-on-vmware.html">
    /// RDS on VMware User Guide.</a>
    /// </p>
    pub custom_availability_zone: std::option::Option<crate::model::CustomAvailabilityZone>,
}
impl DeleteCustomAvailabilityZoneOutput {
    /// <p>A custom Availability Zone (AZ) is an on-premises AZ that is integrated with a VMware vSphere cluster.</p>
    /// <p>For more information about RDS on VMware, see the
    /// <a href="https://docs.aws.amazon.com/AmazonRDS/latest/RDSonVMwareUserGuide/rds-on-vmware.html">
    /// RDS on VMware User Guide.</a>
    /// </p>
    pub fn custom_availability_zone(
        &self,
    ) -> std::option::Option<&crate::model::CustomAvailabilityZone> {
        self.custom_availability_zone.as_ref()
    }
}
impl std::fmt::Debug for DeleteCustomAvailabilityZoneOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteCustomAvailabilityZoneOutput");
        formatter.field("custom_availability_zone", &self.custom_availability_zone);
        formatter.finish()
    }
}
/// See [`DeleteCustomAvailabilityZoneOutput`](crate::output::DeleteCustomAvailabilityZoneOutput)
pub mod delete_custom_availability_zone_output {
    /// A builder for [`DeleteCustomAvailabilityZoneOutput`](crate::output::DeleteCustomAvailabilityZoneOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) custom_availability_zone:
            std::option::Option<crate::model::CustomAvailabilityZone>,
    }
    impl Builder {
        /// <p>A custom Availability Zone (AZ) is an on-premises AZ that is integrated with a VMware vSphere cluster.</p>
        /// <p>For more information about RDS on VMware, see the
        /// <a href="https://docs.aws.amazon.com/AmazonRDS/latest/RDSonVMwareUserGuide/rds-on-vmware.html">
        /// RDS on VMware User Guide.</a>
        /// </p>
        pub fn custom_availability_zone(
            mut self,
            input: crate::model::CustomAvailabilityZone,
        ) -> Self {
            self.custom_availability_zone = Some(input);
            self
        }
        /// <p>A custom Availability Zone (AZ) is an on-premises AZ that is integrated with a VMware vSphere cluster.</p>
        /// <p>For more information about RDS on VMware, see the
        /// <a href="https://docs.aws.amazon.com/AmazonRDS/latest/RDSonVMwareUserGuide/rds-on-vmware.html">
        /// RDS on VMware User Guide.</a>
        /// </p>
        pub fn set_custom_availability_zone(
            mut self,
            input: std::option::Option<crate::model::CustomAvailabilityZone>,
        ) -> Self {
            self.custom_availability_zone = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteCustomAvailabilityZoneOutput`](crate::output::DeleteCustomAvailabilityZoneOutput)
        pub fn build(self) -> crate::output::DeleteCustomAvailabilityZoneOutput {
            crate::output::DeleteCustomAvailabilityZoneOutput {
                custom_availability_zone: self.custom_availability_zone,
            }
        }
    }
}
impl DeleteCustomAvailabilityZoneOutput {
    /// Creates a new builder-style object to manufacture [`DeleteCustomAvailabilityZoneOutput`](crate::output::DeleteCustomAvailabilityZoneOutput)
    pub fn builder() -> crate::output::delete_custom_availability_zone_output::Builder {
        crate::output::delete_custom_availability_zone_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateOptionGroupOutput {
    /// <p></p>
    pub option_group: std::option::Option<crate::model::OptionGroup>,
}
impl CreateOptionGroupOutput {
    /// <p></p>
    pub fn option_group(&self) -> std::option::Option<&crate::model::OptionGroup> {
        self.option_group.as_ref()
    }
}
impl std::fmt::Debug for CreateOptionGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateOptionGroupOutput");
        formatter.field("option_group", &self.option_group);
        formatter.finish()
    }
}
/// See [`CreateOptionGroupOutput`](crate::output::CreateOptionGroupOutput)
pub mod create_option_group_output {
    /// A builder for [`CreateOptionGroupOutput`](crate::output::CreateOptionGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) option_group: std::option::Option<crate::model::OptionGroup>,
    }
    impl Builder {
        /// <p></p>
        pub fn option_group(mut self, input: crate::model::OptionGroup) -> Self {
            self.option_group = Some(input);
            self
        }
        /// <p></p>
        pub fn set_option_group(
            mut self,
            input: std::option::Option<crate::model::OptionGroup>,
        ) -> Self {
            self.option_group = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateOptionGroupOutput`](crate::output::CreateOptionGroupOutput)
        pub fn build(self) -> crate::output::CreateOptionGroupOutput {
            crate::output::CreateOptionGroupOutput {
                option_group: self.option_group,
            }
        }
    }
}
impl CreateOptionGroupOutput {
    /// Creates a new builder-style object to manufacture [`CreateOptionGroupOutput`](crate::output::CreateOptionGroupOutput)
    pub fn builder() -> crate::output::create_option_group_output::Builder {
        crate::output::create_option_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateGlobalClusterOutput {
    /// <p>A data type representing an Aurora global database.</p>
    pub global_cluster: std::option::Option<crate::model::GlobalCluster>,
}
impl CreateGlobalClusterOutput {
    /// <p>A data type representing an Aurora global database.</p>
    pub fn global_cluster(&self) -> std::option::Option<&crate::model::GlobalCluster> {
        self.global_cluster.as_ref()
    }
}
impl std::fmt::Debug for CreateGlobalClusterOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateGlobalClusterOutput");
        formatter.field("global_cluster", &self.global_cluster);
        formatter.finish()
    }
}
/// See [`CreateGlobalClusterOutput`](crate::output::CreateGlobalClusterOutput)
pub mod create_global_cluster_output {
    /// A builder for [`CreateGlobalClusterOutput`](crate::output::CreateGlobalClusterOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) global_cluster: std::option::Option<crate::model::GlobalCluster>,
    }
    impl Builder {
        /// <p>A data type representing an Aurora global database.</p>
        pub fn global_cluster(mut self, input: crate::model::GlobalCluster) -> Self {
            self.global_cluster = Some(input);
            self
        }
        /// <p>A data type representing an Aurora global database.</p>
        pub fn set_global_cluster(
            mut self,
            input: std::option::Option<crate::model::GlobalCluster>,
        ) -> Self {
            self.global_cluster = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateGlobalClusterOutput`](crate::output::CreateGlobalClusterOutput)
        pub fn build(self) -> crate::output::CreateGlobalClusterOutput {
            crate::output::CreateGlobalClusterOutput {
                global_cluster: self.global_cluster,
            }
        }
    }
}
impl CreateGlobalClusterOutput {
    /// Creates a new builder-style object to manufacture [`CreateGlobalClusterOutput`](crate::output::CreateGlobalClusterOutput)
    pub fn builder() -> crate::output::create_global_cluster_output::Builder {
        crate::output::create_global_cluster_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateEventSubscriptionOutput {
    /// <p>Contains the results of a successful invocation of the <code>DescribeEventSubscriptions</code> action.</p>
    pub event_subscription: std::option::Option<crate::model::EventSubscription>,
}
impl CreateEventSubscriptionOutput {
    /// <p>Contains the results of a successful invocation of the <code>DescribeEventSubscriptions</code> action.</p>
    pub fn event_subscription(&self) -> std::option::Option<&crate::model::EventSubscription> {
        self.event_subscription.as_ref()
    }
}
impl std::fmt::Debug for CreateEventSubscriptionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateEventSubscriptionOutput");
        formatter.field("event_subscription", &self.event_subscription);
        formatter.finish()
    }
}
/// See [`CreateEventSubscriptionOutput`](crate::output::CreateEventSubscriptionOutput)
pub mod create_event_subscription_output {
    /// A builder for [`CreateEventSubscriptionOutput`](crate::output::CreateEventSubscriptionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) event_subscription: std::option::Option<crate::model::EventSubscription>,
    }
    impl Builder {
        /// <p>Contains the results of a successful invocation of the <code>DescribeEventSubscriptions</code> action.</p>
        pub fn event_subscription(mut self, input: crate::model::EventSubscription) -> Self {
            self.event_subscription = Some(input);
            self
        }
        /// <p>Contains the results of a successful invocation of the <code>DescribeEventSubscriptions</code> action.</p>
        pub fn set_event_subscription(
            mut self,
            input: std::option::Option<crate::model::EventSubscription>,
        ) -> Self {
            self.event_subscription = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateEventSubscriptionOutput`](crate::output::CreateEventSubscriptionOutput)
        pub fn build(self) -> crate::output::CreateEventSubscriptionOutput {
            crate::output::CreateEventSubscriptionOutput {
                event_subscription: self.event_subscription,
            }
        }
    }
}
impl CreateEventSubscriptionOutput {
    /// Creates a new builder-style object to manufacture [`CreateEventSubscriptionOutput`](crate::output::CreateEventSubscriptionOutput)
    pub fn builder() -> crate::output::create_event_subscription_output::Builder {
        crate::output::create_event_subscription_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDbSubnetGroupOutput {
    /// <p>Contains the details of an Amazon RDS DB subnet group.
    /// </p>
    /// <p>This data type is used as a response element
    /// in the <code>DescribeDBSubnetGroups</code> action.
    /// </p>
    pub db_subnet_group: std::option::Option<crate::model::DbSubnetGroup>,
}
impl CreateDbSubnetGroupOutput {
    /// <p>Contains the details of an Amazon RDS DB subnet group.
    /// </p>
    /// <p>This data type is used as a response element
    /// in the <code>DescribeDBSubnetGroups</code> action.
    /// </p>
    pub fn db_subnet_group(&self) -> std::option::Option<&crate::model::DbSubnetGroup> {
        self.db_subnet_group.as_ref()
    }
}
impl std::fmt::Debug for CreateDbSubnetGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDbSubnetGroupOutput");
        formatter.field("db_subnet_group", &self.db_subnet_group);
        formatter.finish()
    }
}
/// See [`CreateDbSubnetGroupOutput`](crate::output::CreateDbSubnetGroupOutput)
pub mod create_db_subnet_group_output {
    /// A builder for [`CreateDbSubnetGroupOutput`](crate::output::CreateDbSubnetGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_subnet_group: std::option::Option<crate::model::DbSubnetGroup>,
    }
    impl Builder {
        /// <p>Contains the details of an Amazon RDS DB subnet group.
        /// </p>
        /// <p>This data type is used as a response element
        /// in the <code>DescribeDBSubnetGroups</code> action.
        /// </p>
        pub fn db_subnet_group(mut self, input: crate::model::DbSubnetGroup) -> Self {
            self.db_subnet_group = Some(input);
            self
        }
        /// <p>Contains the details of an Amazon RDS DB subnet group.
        /// </p>
        /// <p>This data type is used as a response element
        /// in the <code>DescribeDBSubnetGroups</code> action.
        /// </p>
        pub fn set_db_subnet_group(
            mut self,
            input: std::option::Option<crate::model::DbSubnetGroup>,
        ) -> Self {
            self.db_subnet_group = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDbSubnetGroupOutput`](crate::output::CreateDbSubnetGroupOutput)
        pub fn build(self) -> crate::output::CreateDbSubnetGroupOutput {
            crate::output::CreateDbSubnetGroupOutput {
                db_subnet_group: self.db_subnet_group,
            }
        }
    }
}
impl CreateDbSubnetGroupOutput {
    /// Creates a new builder-style object to manufacture [`CreateDbSubnetGroupOutput`](crate::output::CreateDbSubnetGroupOutput)
    pub fn builder() -> crate::output::create_db_subnet_group_output::Builder {
        crate::output::create_db_subnet_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDbSnapshotOutput {
    /// <p>Contains the details of an Amazon RDS DB snapshot.
    /// </p>
    /// <p>This data type is used as a response element
    /// in the <code>DescribeDBSnapshots</code> action.
    /// </p>
    pub db_snapshot: std::option::Option<crate::model::DbSnapshot>,
}
impl CreateDbSnapshotOutput {
    /// <p>Contains the details of an Amazon RDS DB snapshot.
    /// </p>
    /// <p>This data type is used as a response element
    /// in the <code>DescribeDBSnapshots</code> action.
    /// </p>
    pub fn db_snapshot(&self) -> std::option::Option<&crate::model::DbSnapshot> {
        self.db_snapshot.as_ref()
    }
}
impl std::fmt::Debug for CreateDbSnapshotOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDbSnapshotOutput");
        formatter.field("db_snapshot", &self.db_snapshot);
        formatter.finish()
    }
}
/// See [`CreateDbSnapshotOutput`](crate::output::CreateDbSnapshotOutput)
pub mod create_db_snapshot_output {
    /// A builder for [`CreateDbSnapshotOutput`](crate::output::CreateDbSnapshotOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_snapshot: std::option::Option<crate::model::DbSnapshot>,
    }
    impl Builder {
        /// <p>Contains the details of an Amazon RDS DB snapshot.
        /// </p>
        /// <p>This data type is used as a response element
        /// in the <code>DescribeDBSnapshots</code> action.
        /// </p>
        pub fn db_snapshot(mut self, input: crate::model::DbSnapshot) -> Self {
            self.db_snapshot = Some(input);
            self
        }
        /// <p>Contains the details of an Amazon RDS DB snapshot.
        /// </p>
        /// <p>This data type is used as a response element
        /// in the <code>DescribeDBSnapshots</code> action.
        /// </p>
        pub fn set_db_snapshot(
            mut self,
            input: std::option::Option<crate::model::DbSnapshot>,
        ) -> Self {
            self.db_snapshot = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDbSnapshotOutput`](crate::output::CreateDbSnapshotOutput)
        pub fn build(self) -> crate::output::CreateDbSnapshotOutput {
            crate::output::CreateDbSnapshotOutput {
                db_snapshot: self.db_snapshot,
            }
        }
    }
}
impl CreateDbSnapshotOutput {
    /// Creates a new builder-style object to manufacture [`CreateDbSnapshotOutput`](crate::output::CreateDbSnapshotOutput)
    pub fn builder() -> crate::output::create_db_snapshot_output::Builder {
        crate::output::create_db_snapshot_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDbSecurityGroupOutput {
    /// <p>Contains the details for an Amazon RDS DB security group.
    /// </p>
    /// <p>This data type is used as a response element
    /// in the <code>DescribeDBSecurityGroups</code> action.
    /// </p>
    pub db_security_group: std::option::Option<crate::model::DbSecurityGroup>,
}
impl CreateDbSecurityGroupOutput {
    /// <p>Contains the details for an Amazon RDS DB security group.
    /// </p>
    /// <p>This data type is used as a response element
    /// in the <code>DescribeDBSecurityGroups</code> action.
    /// </p>
    pub fn db_security_group(&self) -> std::option::Option<&crate::model::DbSecurityGroup> {
        self.db_security_group.as_ref()
    }
}
impl std::fmt::Debug for CreateDbSecurityGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDbSecurityGroupOutput");
        formatter.field("db_security_group", &self.db_security_group);
        formatter.finish()
    }
}
/// See [`CreateDbSecurityGroupOutput`](crate::output::CreateDbSecurityGroupOutput)
pub mod create_db_security_group_output {
    /// A builder for [`CreateDbSecurityGroupOutput`](crate::output::CreateDbSecurityGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_security_group: std::option::Option<crate::model::DbSecurityGroup>,
    }
    impl Builder {
        /// <p>Contains the details for an Amazon RDS DB security group.
        /// </p>
        /// <p>This data type is used as a response element
        /// in the <code>DescribeDBSecurityGroups</code> action.
        /// </p>
        pub fn db_security_group(mut self, input: crate::model::DbSecurityGroup) -> Self {
            self.db_security_group = Some(input);
            self
        }
        /// <p>Contains the details for an Amazon RDS DB security group.
        /// </p>
        /// <p>This data type is used as a response element
        /// in the <code>DescribeDBSecurityGroups</code> action.
        /// </p>
        pub fn set_db_security_group(
            mut self,
            input: std::option::Option<crate::model::DbSecurityGroup>,
        ) -> Self {
            self.db_security_group = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDbSecurityGroupOutput`](crate::output::CreateDbSecurityGroupOutput)
        pub fn build(self) -> crate::output::CreateDbSecurityGroupOutput {
            crate::output::CreateDbSecurityGroupOutput {
                db_security_group: self.db_security_group,
            }
        }
    }
}
impl CreateDbSecurityGroupOutput {
    /// Creates a new builder-style object to manufacture [`CreateDbSecurityGroupOutput`](crate::output::CreateDbSecurityGroupOutput)
    pub fn builder() -> crate::output::create_db_security_group_output::Builder {
        crate::output::create_db_security_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDbProxyEndpointOutput {
    /// <p>The <code>DBProxyEndpoint</code> object that is created by the API operation.
    /// The DB proxy endpoint that you create might provide capabilities such as read/write
    /// or read-only operations, or using a different VPC than the proxy's default VPC.</p>
    pub db_proxy_endpoint: std::option::Option<crate::model::DbProxyEndpoint>,
}
impl CreateDbProxyEndpointOutput {
    /// <p>The <code>DBProxyEndpoint</code> object that is created by the API operation.
    /// The DB proxy endpoint that you create might provide capabilities such as read/write
    /// or read-only operations, or using a different VPC than the proxy's default VPC.</p>
    pub fn db_proxy_endpoint(&self) -> std::option::Option<&crate::model::DbProxyEndpoint> {
        self.db_proxy_endpoint.as_ref()
    }
}
impl std::fmt::Debug for CreateDbProxyEndpointOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDbProxyEndpointOutput");
        formatter.field("db_proxy_endpoint", &self.db_proxy_endpoint);
        formatter.finish()
    }
}
/// See [`CreateDbProxyEndpointOutput`](crate::output::CreateDbProxyEndpointOutput)
pub mod create_db_proxy_endpoint_output {
    /// A builder for [`CreateDbProxyEndpointOutput`](crate::output::CreateDbProxyEndpointOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_proxy_endpoint: std::option::Option<crate::model::DbProxyEndpoint>,
    }
    impl Builder {
        /// <p>The <code>DBProxyEndpoint</code> object that is created by the API operation.
        /// The DB proxy endpoint that you create might provide capabilities such as read/write
        /// or read-only operations, or using a different VPC than the proxy's default VPC.</p>
        pub fn db_proxy_endpoint(mut self, input: crate::model::DbProxyEndpoint) -> Self {
            self.db_proxy_endpoint = Some(input);
            self
        }
        /// <p>The <code>DBProxyEndpoint</code> object that is created by the API operation.
        /// The DB proxy endpoint that you create might provide capabilities such as read/write
        /// or read-only operations, or using a different VPC than the proxy's default VPC.</p>
        pub fn set_db_proxy_endpoint(
            mut self,
            input: std::option::Option<crate::model::DbProxyEndpoint>,
        ) -> Self {
            self.db_proxy_endpoint = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDbProxyEndpointOutput`](crate::output::CreateDbProxyEndpointOutput)
        pub fn build(self) -> crate::output::CreateDbProxyEndpointOutput {
            crate::output::CreateDbProxyEndpointOutput {
                db_proxy_endpoint: self.db_proxy_endpoint,
            }
        }
    }
}
impl CreateDbProxyEndpointOutput {
    /// Creates a new builder-style object to manufacture [`CreateDbProxyEndpointOutput`](crate::output::CreateDbProxyEndpointOutput)
    pub fn builder() -> crate::output::create_db_proxy_endpoint_output::Builder {
        crate::output::create_db_proxy_endpoint_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDbProxyOutput {
    /// <p>The <code>DBProxy</code> structure corresponding to the new proxy.</p>
    pub db_proxy: std::option::Option<crate::model::DbProxy>,
}
impl CreateDbProxyOutput {
    /// <p>The <code>DBProxy</code> structure corresponding to the new proxy.</p>
    pub fn db_proxy(&self) -> std::option::Option<&crate::model::DbProxy> {
        self.db_proxy.as_ref()
    }
}
impl std::fmt::Debug for CreateDbProxyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDbProxyOutput");
        formatter.field("db_proxy", &self.db_proxy);
        formatter.finish()
    }
}
/// See [`CreateDbProxyOutput`](crate::output::CreateDbProxyOutput)
pub mod create_db_proxy_output {
    /// A builder for [`CreateDbProxyOutput`](crate::output::CreateDbProxyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_proxy: std::option::Option<crate::model::DbProxy>,
    }
    impl Builder {
        /// <p>The <code>DBProxy</code> structure corresponding to the new proxy.</p>
        pub fn db_proxy(mut self, input: crate::model::DbProxy) -> Self {
            self.db_proxy = Some(input);
            self
        }
        /// <p>The <code>DBProxy</code> structure corresponding to the new proxy.</p>
        pub fn set_db_proxy(mut self, input: std::option::Option<crate::model::DbProxy>) -> Self {
            self.db_proxy = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDbProxyOutput`](crate::output::CreateDbProxyOutput)
        pub fn build(self) -> crate::output::CreateDbProxyOutput {
            crate::output::CreateDbProxyOutput {
                db_proxy: self.db_proxy,
            }
        }
    }
}
impl CreateDbProxyOutput {
    /// Creates a new builder-style object to manufacture [`CreateDbProxyOutput`](crate::output::CreateDbProxyOutput)
    pub fn builder() -> crate::output::create_db_proxy_output::Builder {
        crate::output::create_db_proxy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDbParameterGroupOutput {
    /// <p>Contains the details of an Amazon RDS DB parameter group.
    /// </p>
    /// <p>This data type is used as a response element in the <code>DescribeDBParameterGroups</code> action.
    /// </p>
    pub db_parameter_group: std::option::Option<crate::model::DbParameterGroup>,
}
impl CreateDbParameterGroupOutput {
    /// <p>Contains the details of an Amazon RDS DB parameter group.
    /// </p>
    /// <p>This data type is used as a response element in the <code>DescribeDBParameterGroups</code> action.
    /// </p>
    pub fn db_parameter_group(&self) -> std::option::Option<&crate::model::DbParameterGroup> {
        self.db_parameter_group.as_ref()
    }
}
impl std::fmt::Debug for CreateDbParameterGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDbParameterGroupOutput");
        formatter.field("db_parameter_group", &self.db_parameter_group);
        formatter.finish()
    }
}
/// See [`CreateDbParameterGroupOutput`](crate::output::CreateDbParameterGroupOutput)
pub mod create_db_parameter_group_output {
    /// A builder for [`CreateDbParameterGroupOutput`](crate::output::CreateDbParameterGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_parameter_group: std::option::Option<crate::model::DbParameterGroup>,
    }
    impl Builder {
        /// <p>Contains the details of an Amazon RDS DB parameter group.
        /// </p>
        /// <p>This data type is used as a response element in the <code>DescribeDBParameterGroups</code> action.
        /// </p>
        pub fn db_parameter_group(mut self, input: crate::model::DbParameterGroup) -> Self {
            self.db_parameter_group = Some(input);
            self
        }
        /// <p>Contains the details of an Amazon RDS DB parameter group.
        /// </p>
        /// <p>This data type is used as a response element in the <code>DescribeDBParameterGroups</code> action.
        /// </p>
        pub fn set_db_parameter_group(
            mut self,
            input: std::option::Option<crate::model::DbParameterGroup>,
        ) -> Self {
            self.db_parameter_group = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDbParameterGroupOutput`](crate::output::CreateDbParameterGroupOutput)
        pub fn build(self) -> crate::output::CreateDbParameterGroupOutput {
            crate::output::CreateDbParameterGroupOutput {
                db_parameter_group: self.db_parameter_group,
            }
        }
    }
}
impl CreateDbParameterGroupOutput {
    /// Creates a new builder-style object to manufacture [`CreateDbParameterGroupOutput`](crate::output::CreateDbParameterGroupOutput)
    pub fn builder() -> crate::output::create_db_parameter_group_output::Builder {
        crate::output::create_db_parameter_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDbInstanceReadReplicaOutput {
    /// <p>Contains the details of an Amazon RDS DB instance.
    /// </p>
    /// <p>This data type is used as a response element in the <code>DescribeDBInstances</code> action.
    /// </p>
    pub db_instance: std::option::Option<crate::model::DbInstance>,
}
impl CreateDbInstanceReadReplicaOutput {
    /// <p>Contains the details of an Amazon RDS DB instance.
    /// </p>
    /// <p>This data type is used as a response element in the <code>DescribeDBInstances</code> action.
    /// </p>
    pub fn db_instance(&self) -> std::option::Option<&crate::model::DbInstance> {
        self.db_instance.as_ref()
    }
}
impl std::fmt::Debug for CreateDbInstanceReadReplicaOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDbInstanceReadReplicaOutput");
        formatter.field("db_instance", &self.db_instance);
        formatter.finish()
    }
}
/// See [`CreateDbInstanceReadReplicaOutput`](crate::output::CreateDbInstanceReadReplicaOutput)
pub mod create_db_instance_read_replica_output {
    /// A builder for [`CreateDbInstanceReadReplicaOutput`](crate::output::CreateDbInstanceReadReplicaOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_instance: std::option::Option<crate::model::DbInstance>,
    }
    impl Builder {
        /// <p>Contains the details of an Amazon RDS DB instance.
        /// </p>
        /// <p>This data type is used as a response element in the <code>DescribeDBInstances</code> action.
        /// </p>
        pub fn db_instance(mut self, input: crate::model::DbInstance) -> Self {
            self.db_instance = Some(input);
            self
        }
        /// <p>Contains the details of an Amazon RDS DB instance.
        /// </p>
        /// <p>This data type is used as a response element in the <code>DescribeDBInstances</code> action.
        /// </p>
        pub fn set_db_instance(
            mut self,
            input: std::option::Option<crate::model::DbInstance>,
        ) -> Self {
            self.db_instance = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDbInstanceReadReplicaOutput`](crate::output::CreateDbInstanceReadReplicaOutput)
        pub fn build(self) -> crate::output::CreateDbInstanceReadReplicaOutput {
            crate::output::CreateDbInstanceReadReplicaOutput {
                db_instance: self.db_instance,
            }
        }
    }
}
impl CreateDbInstanceReadReplicaOutput {
    /// Creates a new builder-style object to manufacture [`CreateDbInstanceReadReplicaOutput`](crate::output::CreateDbInstanceReadReplicaOutput)
    pub fn builder() -> crate::output::create_db_instance_read_replica_output::Builder {
        crate::output::create_db_instance_read_replica_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDbInstanceOutput {
    /// <p>Contains the details of an Amazon RDS DB instance.
    /// </p>
    /// <p>This data type is used as a response element in the <code>DescribeDBInstances</code> action.
    /// </p>
    pub db_instance: std::option::Option<crate::model::DbInstance>,
}
impl CreateDbInstanceOutput {
    /// <p>Contains the details of an Amazon RDS DB instance.
    /// </p>
    /// <p>This data type is used as a response element in the <code>DescribeDBInstances</code> action.
    /// </p>
    pub fn db_instance(&self) -> std::option::Option<&crate::model::DbInstance> {
        self.db_instance.as_ref()
    }
}
impl std::fmt::Debug for CreateDbInstanceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDbInstanceOutput");
        formatter.field("db_instance", &self.db_instance);
        formatter.finish()
    }
}
/// See [`CreateDbInstanceOutput`](crate::output::CreateDbInstanceOutput)
pub mod create_db_instance_output {
    /// A builder for [`CreateDbInstanceOutput`](crate::output::CreateDbInstanceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_instance: std::option::Option<crate::model::DbInstance>,
    }
    impl Builder {
        /// <p>Contains the details of an Amazon RDS DB instance.
        /// </p>
        /// <p>This data type is used as a response element in the <code>DescribeDBInstances</code> action.
        /// </p>
        pub fn db_instance(mut self, input: crate::model::DbInstance) -> Self {
            self.db_instance = Some(input);
            self
        }
        /// <p>Contains the details of an Amazon RDS DB instance.
        /// </p>
        /// <p>This data type is used as a response element in the <code>DescribeDBInstances</code> action.
        /// </p>
        pub fn set_db_instance(
            mut self,
            input: std::option::Option<crate::model::DbInstance>,
        ) -> Self {
            self.db_instance = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDbInstanceOutput`](crate::output::CreateDbInstanceOutput)
        pub fn build(self) -> crate::output::CreateDbInstanceOutput {
            crate::output::CreateDbInstanceOutput {
                db_instance: self.db_instance,
            }
        }
    }
}
impl CreateDbInstanceOutput {
    /// Creates a new builder-style object to manufacture [`CreateDbInstanceOutput`](crate::output::CreateDbInstanceOutput)
    pub fn builder() -> crate::output::create_db_instance_output::Builder {
        crate::output::create_db_instance_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDbClusterSnapshotOutput {
    /// <p>Contains the details for an Amazon RDS DB cluster snapshot
    /// </p>
    /// <p>This data type is used as a response element
    /// in the <code>DescribeDBClusterSnapshots</code> action.
    /// </p>
    pub db_cluster_snapshot: std::option::Option<crate::model::DbClusterSnapshot>,
}
impl CreateDbClusterSnapshotOutput {
    /// <p>Contains the details for an Amazon RDS DB cluster snapshot
    /// </p>
    /// <p>This data type is used as a response element
    /// in the <code>DescribeDBClusterSnapshots</code> action.
    /// </p>
    pub fn db_cluster_snapshot(&self) -> std::option::Option<&crate::model::DbClusterSnapshot> {
        self.db_cluster_snapshot.as_ref()
    }
}
impl std::fmt::Debug for CreateDbClusterSnapshotOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDbClusterSnapshotOutput");
        formatter.field("db_cluster_snapshot", &self.db_cluster_snapshot);
        formatter.finish()
    }
}
/// See [`CreateDbClusterSnapshotOutput`](crate::output::CreateDbClusterSnapshotOutput)
pub mod create_db_cluster_snapshot_output {
    /// A builder for [`CreateDbClusterSnapshotOutput`](crate::output::CreateDbClusterSnapshotOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster_snapshot: std::option::Option<crate::model::DbClusterSnapshot>,
    }
    impl Builder {
        /// <p>Contains the details for an Amazon RDS DB cluster snapshot
        /// </p>
        /// <p>This data type is used as a response element
        /// in the <code>DescribeDBClusterSnapshots</code> action.
        /// </p>
        pub fn db_cluster_snapshot(mut self, input: crate::model::DbClusterSnapshot) -> Self {
            self.db_cluster_snapshot = Some(input);
            self
        }
        /// <p>Contains the details for an Amazon RDS DB cluster snapshot
        /// </p>
        /// <p>This data type is used as a response element
        /// in the <code>DescribeDBClusterSnapshots</code> action.
        /// </p>
        pub fn set_db_cluster_snapshot(
            mut self,
            input: std::option::Option<crate::model::DbClusterSnapshot>,
        ) -> Self {
            self.db_cluster_snapshot = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDbClusterSnapshotOutput`](crate::output::CreateDbClusterSnapshotOutput)
        pub fn build(self) -> crate::output::CreateDbClusterSnapshotOutput {
            crate::output::CreateDbClusterSnapshotOutput {
                db_cluster_snapshot: self.db_cluster_snapshot,
            }
        }
    }
}
impl CreateDbClusterSnapshotOutput {
    /// Creates a new builder-style object to manufacture [`CreateDbClusterSnapshotOutput`](crate::output::CreateDbClusterSnapshotOutput)
    pub fn builder() -> crate::output::create_db_cluster_snapshot_output::Builder {
        crate::output::create_db_cluster_snapshot_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDbClusterParameterGroupOutput {
    /// <p>Contains the details of an Amazon RDS DB cluster parameter group.
    /// </p>
    /// <p>This data type is used as a response element in the <code>DescribeDBClusterParameterGroups</code> action.
    /// </p>
    pub db_cluster_parameter_group: std::option::Option<crate::model::DbClusterParameterGroup>,
}
impl CreateDbClusterParameterGroupOutput {
    /// <p>Contains the details of an Amazon RDS DB cluster parameter group.
    /// </p>
    /// <p>This data type is used as a response element in the <code>DescribeDBClusterParameterGroups</code> action.
    /// </p>
    pub fn db_cluster_parameter_group(
        &self,
    ) -> std::option::Option<&crate::model::DbClusterParameterGroup> {
        self.db_cluster_parameter_group.as_ref()
    }
}
impl std::fmt::Debug for CreateDbClusterParameterGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDbClusterParameterGroupOutput");
        formatter.field(
            "db_cluster_parameter_group",
            &self.db_cluster_parameter_group,
        );
        formatter.finish()
    }
}
/// See [`CreateDbClusterParameterGroupOutput`](crate::output::CreateDbClusterParameterGroupOutput)
pub mod create_db_cluster_parameter_group_output {
    /// A builder for [`CreateDbClusterParameterGroupOutput`](crate::output::CreateDbClusterParameterGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster_parameter_group:
            std::option::Option<crate::model::DbClusterParameterGroup>,
    }
    impl Builder {
        /// <p>Contains the details of an Amazon RDS DB cluster parameter group.
        /// </p>
        /// <p>This data type is used as a response element in the <code>DescribeDBClusterParameterGroups</code> action.
        /// </p>
        pub fn db_cluster_parameter_group(
            mut self,
            input: crate::model::DbClusterParameterGroup,
        ) -> Self {
            self.db_cluster_parameter_group = Some(input);
            self
        }
        /// <p>Contains the details of an Amazon RDS DB cluster parameter group.
        /// </p>
        /// <p>This data type is used as a response element in the <code>DescribeDBClusterParameterGroups</code> action.
        /// </p>
        pub fn set_db_cluster_parameter_group(
            mut self,
            input: std::option::Option<crate::model::DbClusterParameterGroup>,
        ) -> Self {
            self.db_cluster_parameter_group = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDbClusterParameterGroupOutput`](crate::output::CreateDbClusterParameterGroupOutput)
        pub fn build(self) -> crate::output::CreateDbClusterParameterGroupOutput {
            crate::output::CreateDbClusterParameterGroupOutput {
                db_cluster_parameter_group: self.db_cluster_parameter_group,
            }
        }
    }
}
impl CreateDbClusterParameterGroupOutput {
    /// Creates a new builder-style object to manufacture [`CreateDbClusterParameterGroupOutput`](crate::output::CreateDbClusterParameterGroupOutput)
    pub fn builder() -> crate::output::create_db_cluster_parameter_group_output::Builder {
        crate::output::create_db_cluster_parameter_group_output::Builder::default()
    }
}

/// <p>This data type represents the information you need to connect to an Amazon Aurora DB cluster.
/// This data type is used as a response element in the following actions:</p>
/// <ul>
/// <li>
/// <p>
/// <code>CreateDBClusterEndpoint</code>
/// </p>
/// </li>
/// <li>
/// <p>
/// <code>DescribeDBClusterEndpoints</code>
/// </p>
/// </li>
/// <li>
/// <p>
/// <code>ModifyDBClusterEndpoint</code>
/// </p>
/// </li>
/// <li>
/// <p>
/// <code>DeleteDBClusterEndpoint</code>
/// </p>
/// </li>
/// </ul>
/// <p>For the data structure that represents Amazon RDS DB instance endpoints,
/// see <code>Endpoint</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDbClusterEndpointOutput {
    /// <p>The identifier associated with the endpoint. This parameter is stored as a lowercase string.</p>
    pub db_cluster_endpoint_identifier: std::option::Option<std::string::String>,
    /// <p>The DB cluster identifier of the DB cluster associated with the endpoint. This parameter is
    /// stored as a lowercase string.</p>
    pub db_cluster_identifier: std::option::Option<std::string::String>,
    /// <p>A unique system-generated identifier for an endpoint. It remains the same for the whole life of the endpoint.</p>
    pub db_cluster_endpoint_resource_identifier: std::option::Option<std::string::String>,
    /// <p>The DNS address of the endpoint.</p>
    pub endpoint: std::option::Option<std::string::String>,
    /// <p>The current status of the endpoint. One of: <code>creating</code>, <code>available</code>, <code>deleting</code>, <code>inactive</code>, <code>modifying</code>. The <code>inactive</code> state applies to an endpoint that can't be used for a certain kind of cluster,
    /// such as a <code>writer</code> endpoint for a read-only secondary cluster in a global database.</p>
    pub status: std::option::Option<std::string::String>,
    /// <p>The type of the endpoint. One of: <code>READER</code>, <code>WRITER</code>, <code>CUSTOM</code>.</p>
    pub endpoint_type: std::option::Option<std::string::String>,
    /// <p>The type associated with a custom endpoint. One of: <code>READER</code>,
    /// <code>WRITER</code>, <code>ANY</code>.</p>
    pub custom_endpoint_type: std::option::Option<std::string::String>,
    /// <p>List of DB instance identifiers that are part of the custom endpoint group.</p>
    pub static_members: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>List of DB instance identifiers that aren't part of the custom endpoint group.
    /// All other eligible instances are reachable through the custom endpoint.
    /// Only relevant if the list of static members is empty.</p>
    pub excluded_members: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The Amazon Resource Name (ARN) for the endpoint.</p>
    pub db_cluster_endpoint_arn: std::option::Option<std::string::String>,
}
impl CreateDbClusterEndpointOutput {
    /// <p>The identifier associated with the endpoint. This parameter is stored as a lowercase string.</p>
    pub fn db_cluster_endpoint_identifier(&self) -> std::option::Option<&str> {
        self.db_cluster_endpoint_identifier.as_deref()
    }
    /// <p>The DB cluster identifier of the DB cluster associated with the endpoint. This parameter is
    /// stored as a lowercase string.</p>
    pub fn db_cluster_identifier(&self) -> std::option::Option<&str> {
        self.db_cluster_identifier.as_deref()
    }
    /// <p>A unique system-generated identifier for an endpoint. It remains the same for the whole life of the endpoint.</p>
    pub fn db_cluster_endpoint_resource_identifier(&self) -> std::option::Option<&str> {
        self.db_cluster_endpoint_resource_identifier.as_deref()
    }
    /// <p>The DNS address of the endpoint.</p>
    pub fn endpoint(&self) -> std::option::Option<&str> {
        self.endpoint.as_deref()
    }
    /// <p>The current status of the endpoint. One of: <code>creating</code>, <code>available</code>, <code>deleting</code>, <code>inactive</code>, <code>modifying</code>. The <code>inactive</code> state applies to an endpoint that can't be used for a certain kind of cluster,
    /// such as a <code>writer</code> endpoint for a read-only secondary cluster in a global database.</p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>The type of the endpoint. One of: <code>READER</code>, <code>WRITER</code>, <code>CUSTOM</code>.</p>
    pub fn endpoint_type(&self) -> std::option::Option<&str> {
        self.endpoint_type.as_deref()
    }
    /// <p>The type associated with a custom endpoint. One of: <code>READER</code>,
    /// <code>WRITER</code>, <code>ANY</code>.</p>
    pub fn custom_endpoint_type(&self) -> std::option::Option<&str> {
        self.custom_endpoint_type.as_deref()
    }
    /// <p>List of DB instance identifiers that are part of the custom endpoint group.</p>
    pub fn static_members(&self) -> std::option::Option<&[std::string::String]> {
        self.static_members.as_deref()
    }
    /// <p>List of DB instance identifiers that aren't part of the custom endpoint group.
    /// All other eligible instances are reachable through the custom endpoint.
    /// Only relevant if the list of static members is empty.</p>
    pub fn excluded_members(&self) -> std::option::Option<&[std::string::String]> {
        self.excluded_members.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) for the endpoint.</p>
    pub fn db_cluster_endpoint_arn(&self) -> std::option::Option<&str> {
        self.db_cluster_endpoint_arn.as_deref()
    }
}
impl std::fmt::Debug for CreateDbClusterEndpointOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDbClusterEndpointOutput");
        formatter.field(
            "db_cluster_endpoint_identifier",
            &self.db_cluster_endpoint_identifier,
        );
        formatter.field("db_cluster_identifier", &self.db_cluster_identifier);
        formatter.field(
            "db_cluster_endpoint_resource_identifier",
            &self.db_cluster_endpoint_resource_identifier,
        );
        formatter.field("endpoint", &self.endpoint);
        formatter.field("status", &self.status);
        formatter.field("endpoint_type", &self.endpoint_type);
        formatter.field("custom_endpoint_type", &self.custom_endpoint_type);
        formatter.field("static_members", &self.static_members);
        formatter.field("excluded_members", &self.excluded_members);
        formatter.field("db_cluster_endpoint_arn", &self.db_cluster_endpoint_arn);
        formatter.finish()
    }
}
/// See [`CreateDbClusterEndpointOutput`](crate::output::CreateDbClusterEndpointOutput)
pub mod create_db_cluster_endpoint_output {
    /// A builder for [`CreateDbClusterEndpointOutput`](crate::output::CreateDbClusterEndpointOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster_endpoint_identifier: std::option::Option<std::string::String>,
        pub(crate) db_cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) db_cluster_endpoint_resource_identifier:
            std::option::Option<std::string::String>,
        pub(crate) endpoint: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) endpoint_type: std::option::Option<std::string::String>,
        pub(crate) custom_endpoint_type: std::option::Option<std::string::String>,
        pub(crate) static_members: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) excluded_members: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) db_cluster_endpoint_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The identifier associated with the endpoint. This parameter is stored as a lowercase string.</p>
        pub fn db_cluster_endpoint_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.db_cluster_endpoint_identifier = Some(input.into());
            self
        }
        /// <p>The identifier associated with the endpoint. This parameter is stored as a lowercase string.</p>
        pub fn set_db_cluster_endpoint_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_endpoint_identifier = input;
            self
        }
        /// <p>The DB cluster identifier of the DB cluster associated with the endpoint. This parameter is
        /// stored as a lowercase string.</p>
        pub fn db_cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_cluster_identifier = Some(input.into());
            self
        }
        /// <p>The DB cluster identifier of the DB cluster associated with the endpoint. This parameter is
        /// stored as a lowercase string.</p>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_identifier = input;
            self
        }
        /// <p>A unique system-generated identifier for an endpoint. It remains the same for the whole life of the endpoint.</p>
        pub fn db_cluster_endpoint_resource_identifier(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.db_cluster_endpoint_resource_identifier = Some(input.into());
            self
        }
        /// <p>A unique system-generated identifier for an endpoint. It remains the same for the whole life of the endpoint.</p>
        pub fn set_db_cluster_endpoint_resource_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_endpoint_resource_identifier = input;
            self
        }
        /// <p>The DNS address of the endpoint.</p>
        pub fn endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint = Some(input.into());
            self
        }
        /// <p>The DNS address of the endpoint.</p>
        pub fn set_endpoint(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.endpoint = input;
            self
        }
        /// <p>The current status of the endpoint. One of: <code>creating</code>, <code>available</code>, <code>deleting</code>, <code>inactive</code>, <code>modifying</code>. The <code>inactive</code> state applies to an endpoint that can't be used for a certain kind of cluster,
        /// such as a <code>writer</code> endpoint for a read-only secondary cluster in a global database.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The current status of the endpoint. One of: <code>creating</code>, <code>available</code>, <code>deleting</code>, <code>inactive</code>, <code>modifying</code>. The <code>inactive</code> state applies to an endpoint that can't be used for a certain kind of cluster,
        /// such as a <code>writer</code> endpoint for a read-only secondary cluster in a global database.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>The type of the endpoint. One of: <code>READER</code>, <code>WRITER</code>, <code>CUSTOM</code>.</p>
        pub fn endpoint_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.endpoint_type = Some(input.into());
            self
        }
        /// <p>The type of the endpoint. One of: <code>READER</code>, <code>WRITER</code>, <code>CUSTOM</code>.</p>
        pub fn set_endpoint_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.endpoint_type = input;
            self
        }
        /// <p>The type associated with a custom endpoint. One of: <code>READER</code>,
        /// <code>WRITER</code>, <code>ANY</code>.</p>
        pub fn custom_endpoint_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.custom_endpoint_type = Some(input.into());
            self
        }
        /// <p>The type associated with a custom endpoint. One of: <code>READER</code>,
        /// <code>WRITER</code>, <code>ANY</code>.</p>
        pub fn set_custom_endpoint_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.custom_endpoint_type = input;
            self
        }
        /// Appends an item to `static_members`.
        ///
        /// To override the contents of this collection use [`set_static_members`](Self::set_static_members).
        ///
        /// <p>List of DB instance identifiers that are part of the custom endpoint group.</p>
        pub fn static_members(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.static_members.unwrap_or_default();
            v.push(input.into());
            self.static_members = Some(v);
            self
        }
        /// <p>List of DB instance identifiers that are part of the custom endpoint group.</p>
        pub fn set_static_members(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.static_members = input;
            self
        }
        /// Appends an item to `excluded_members`.
        ///
        /// To override the contents of this collection use [`set_excluded_members`](Self::set_excluded_members).
        ///
        /// <p>List of DB instance identifiers that aren't part of the custom endpoint group.
        /// All other eligible instances are reachable through the custom endpoint.
        /// Only relevant if the list of static members is empty.</p>
        pub fn excluded_members(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.excluded_members.unwrap_or_default();
            v.push(input.into());
            self.excluded_members = Some(v);
            self
        }
        /// <p>List of DB instance identifiers that aren't part of the custom endpoint group.
        /// All other eligible instances are reachable through the custom endpoint.
        /// Only relevant if the list of static members is empty.</p>
        pub fn set_excluded_members(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.excluded_members = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the endpoint.</p>
        pub fn db_cluster_endpoint_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_cluster_endpoint_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) for the endpoint.</p>
        pub fn set_db_cluster_endpoint_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_endpoint_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDbClusterEndpointOutput`](crate::output::CreateDbClusterEndpointOutput)
        pub fn build(self) -> crate::output::CreateDbClusterEndpointOutput {
            crate::output::CreateDbClusterEndpointOutput {
                db_cluster_endpoint_identifier: self.db_cluster_endpoint_identifier,
                db_cluster_identifier: self.db_cluster_identifier,
                db_cluster_endpoint_resource_identifier: self
                    .db_cluster_endpoint_resource_identifier,
                endpoint: self.endpoint,
                status: self.status,
                endpoint_type: self.endpoint_type,
                custom_endpoint_type: self.custom_endpoint_type,
                static_members: self.static_members,
                excluded_members: self.excluded_members,
                db_cluster_endpoint_arn: self.db_cluster_endpoint_arn,
            }
        }
    }
}
impl CreateDbClusterEndpointOutput {
    /// Creates a new builder-style object to manufacture [`CreateDbClusterEndpointOutput`](crate::output::CreateDbClusterEndpointOutput)
    pub fn builder() -> crate::output::create_db_cluster_endpoint_output::Builder {
        crate::output::create_db_cluster_endpoint_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDbClusterOutput {
    /// <p>Contains the details of an Amazon Aurora DB cluster.
    /// </p>
    /// <p>This data type is used as a response element in the <code>DescribeDBClusters</code>,
    /// <code>StopDBCluster</code>, and <code>StartDBCluster</code> actions.
    /// </p>
    pub db_cluster: std::option::Option<crate::model::DbCluster>,
}
impl CreateDbClusterOutput {
    /// <p>Contains the details of an Amazon Aurora DB cluster.
    /// </p>
    /// <p>This data type is used as a response element in the <code>DescribeDBClusters</code>,
    /// <code>StopDBCluster</code>, and <code>StartDBCluster</code> actions.
    /// </p>
    pub fn db_cluster(&self) -> std::option::Option<&crate::model::DbCluster> {
        self.db_cluster.as_ref()
    }
}
impl std::fmt::Debug for CreateDbClusterOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDbClusterOutput");
        formatter.field("db_cluster", &self.db_cluster);
        formatter.finish()
    }
}
/// See [`CreateDbClusterOutput`](crate::output::CreateDbClusterOutput)
pub mod create_db_cluster_output {
    /// A builder for [`CreateDbClusterOutput`](crate::output::CreateDbClusterOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster: std::option::Option<crate::model::DbCluster>,
    }
    impl Builder {
        /// <p>Contains the details of an Amazon Aurora DB cluster.
        /// </p>
        /// <p>This data type is used as a response element in the <code>DescribeDBClusters</code>,
        /// <code>StopDBCluster</code>, and <code>StartDBCluster</code> actions.
        /// </p>
        pub fn db_cluster(mut self, input: crate::model::DbCluster) -> Self {
            self.db_cluster = Some(input);
            self
        }
        /// <p>Contains the details of an Amazon Aurora DB cluster.
        /// </p>
        /// <p>This data type is used as a response element in the <code>DescribeDBClusters</code>,
        /// <code>StopDBCluster</code>, and <code>StartDBCluster</code> actions.
        /// </p>
        pub fn set_db_cluster(
            mut self,
            input: std::option::Option<crate::model::DbCluster>,
        ) -> Self {
            self.db_cluster = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDbClusterOutput`](crate::output::CreateDbClusterOutput)
        pub fn build(self) -> crate::output::CreateDbClusterOutput {
            crate::output::CreateDbClusterOutput {
                db_cluster: self.db_cluster,
            }
        }
    }
}
impl CreateDbClusterOutput {
    /// Creates a new builder-style object to manufacture [`CreateDbClusterOutput`](crate::output::CreateDbClusterOutput)
    pub fn builder() -> crate::output::create_db_cluster_output::Builder {
        crate::output::create_db_cluster_output::Builder::default()
    }
}

/// <p>
/// This data type is used as a response element in the action <code>DescribeDBEngineVersions</code>.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateCustomDbEngineVersionOutput {
    /// <p>The name of the database engine.</p>
    pub engine: std::option::Option<std::string::String>,
    /// <p>The version number of the database engine.</p>
    pub engine_version: std::option::Option<std::string::String>,
    /// <p>The name of the DB parameter group family for the database engine.</p>
    pub db_parameter_group_family: std::option::Option<std::string::String>,
    /// <p>The description of the database engine.</p>
    pub db_engine_description: std::option::Option<std::string::String>,
    /// <p>The description of the database engine version.</p>
    pub db_engine_version_description: std::option::Option<std::string::String>,
    /// <p>
    /// The default character set for new instances of this engine version,
    /// if the <code>CharacterSetName</code> parameter of the CreateDBInstance API
    /// isn't specified.
    /// </p>
    pub default_character_set: std::option::Option<crate::model::CharacterSet>,
    /// <p>A list of the character sets supported by this engine for the <code>CharacterSetName</code> parameter of the <code>CreateDBInstance</code> operation.  
    /// </p>
    pub supported_character_sets: std::option::Option<std::vec::Vec<crate::model::CharacterSet>>,
    /// <p>A list of the character sets supported by the Oracle DB engine for the <code>NcharCharacterSetName</code> parameter of the <code>CreateDBInstance</code> operation.  
    /// </p>
    pub supported_nchar_character_sets:
        std::option::Option<std::vec::Vec<crate::model::CharacterSet>>,
    /// <p>A list of engine versions that this database engine version can be upgraded to.</p>
    pub valid_upgrade_target: std::option::Option<std::vec::Vec<crate::model::UpgradeTarget>>,
    /// <p>A list of the time zones supported by this engine for the
    /// <code>Timezone</code> parameter of the <code>CreateDBInstance</code> action.  
    /// </p>
    pub supported_timezones: std::option::Option<std::vec::Vec<crate::model::Timezone>>,
    /// <p>The types of logs that the database engine has available for export to CloudWatch Logs.</p>
    pub exportable_log_types: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A value that indicates whether the engine version supports exporting the log types specified by ExportableLogTypes to CloudWatch Logs.</p>
    pub supports_log_exports_to_cloudwatch_logs: bool,
    /// <p>Indicates whether the database engine version supports read replicas.</p>
    pub supports_read_replica: bool,
    /// <p>A list of the supported DB engine modes.</p>
    pub supported_engine_modes: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>
    /// A list of features supported by the DB engine.
    /// </p>
    /// <p>The supported features vary by DB engine and DB engine version.</p>
    /// <p>To determine the supported features for a specific DB engine and DB engine version using the CLI,
    /// use the following command:</p>
    /// <p>
    /// <code>aws rds describe-db-engine-versions --engine <engine_name> --engine-version <engine_version></code>
    /// </p>
    /// <p>For example, to determine the supported features for RDS for PostgreSQL version 13.3 using the CLI,
    /// use the following command:</p>
    /// <p>
    /// <code>aws rds describe-db-engine-versions --engine postgres --engine-version 13.3</code>
    /// </p>
    /// <p>The supported features are listed under <code>SupportedFeatureNames</code> in the output.</p>
    pub supported_feature_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The status of the DB engine version, either <code>available</code> or <code>deprecated</code>.</p>
    pub status: std::option::Option<std::string::String>,
    /// <p>A value that indicates whether you can use Aurora parallel query with a specific DB engine version.</p>
    pub supports_parallel_query: bool,
    /// <p>A value that indicates whether you can use Aurora global databases with a specific DB engine version.</p>
    pub supports_global_databases: bool,
    /// <p>The major engine version of the CEV.</p>
    pub major_engine_version: std::option::Option<std::string::String>,
    /// <p>The name of the Amazon S3 bucket that contains your database installation files.</p>
    pub database_installation_files_s3_bucket_name: std::option::Option<std::string::String>,
    /// <p>The Amazon S3 directory that contains the database installation files.
    /// If not specified, then no prefix is assumed.</p>
    pub database_installation_files_s3_prefix: std::option::Option<std::string::String>,
    /// <p>The ARN of the custom engine version.</p>
    pub db_engine_version_arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services KMS key identifier for an encrypted CEV. This parameter is required for
    /// RDS Custom, but optional for Amazon RDS.</p>
    pub kms_key_id: std::option::Option<std::string::String>,
    /// <p>The creation time of the DB engine version.</p>
    pub create_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>A list of tags.
    /// For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources</a> in the <i>Amazon RDS User Guide.</i>           
    /// </p>
    pub tag_list: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl CreateCustomDbEngineVersionOutput {
    /// <p>The name of the database engine.</p>
    pub fn engine(&self) -> std::option::Option<&str> {
        self.engine.as_deref()
    }
    /// <p>The version number of the database engine.</p>
    pub fn engine_version(&self) -> std::option::Option<&str> {
        self.engine_version.as_deref()
    }
    /// <p>The name of the DB parameter group family for the database engine.</p>
    pub fn db_parameter_group_family(&self) -> std::option::Option<&str> {
        self.db_parameter_group_family.as_deref()
    }
    /// <p>The description of the database engine.</p>
    pub fn db_engine_description(&self) -> std::option::Option<&str> {
        self.db_engine_description.as_deref()
    }
    /// <p>The description of the database engine version.</p>
    pub fn db_engine_version_description(&self) -> std::option::Option<&str> {
        self.db_engine_version_description.as_deref()
    }
    /// <p>
    /// The default character set for new instances of this engine version,
    /// if the <code>CharacterSetName</code> parameter of the CreateDBInstance API
    /// isn't specified.
    /// </p>
    pub fn default_character_set(&self) -> std::option::Option<&crate::model::CharacterSet> {
        self.default_character_set.as_ref()
    }
    /// <p>A list of the character sets supported by this engine for the <code>CharacterSetName</code> parameter of the <code>CreateDBInstance</code> operation.  
    /// </p>
    pub fn supported_character_sets(&self) -> std::option::Option<&[crate::model::CharacterSet]> {
        self.supported_character_sets.as_deref()
    }
    /// <p>A list of the character sets supported by the Oracle DB engine for the <code>NcharCharacterSetName</code> parameter of the <code>CreateDBInstance</code> operation.  
    /// </p>
    pub fn supported_nchar_character_sets(
        &self,
    ) -> std::option::Option<&[crate::model::CharacterSet]> {
        self.supported_nchar_character_sets.as_deref()
    }
    /// <p>A list of engine versions that this database engine version can be upgraded to.</p>
    pub fn valid_upgrade_target(&self) -> std::option::Option<&[crate::model::UpgradeTarget]> {
        self.valid_upgrade_target.as_deref()
    }
    /// <p>A list of the time zones supported by this engine for the
    /// <code>Timezone</code> parameter of the <code>CreateDBInstance</code> action.  
    /// </p>
    pub fn supported_timezones(&self) -> std::option::Option<&[crate::model::Timezone]> {
        self.supported_timezones.as_deref()
    }
    /// <p>The types of logs that the database engine has available for export to CloudWatch Logs.</p>
    pub fn exportable_log_types(&self) -> std::option::Option<&[std::string::String]> {
        self.exportable_log_types.as_deref()
    }
    /// <p>A value that indicates whether the engine version supports exporting the log types specified by ExportableLogTypes to CloudWatch Logs.</p>
    pub fn supports_log_exports_to_cloudwatch_logs(&self) -> bool {
        self.supports_log_exports_to_cloudwatch_logs
    }
    /// <p>Indicates whether the database engine version supports read replicas.</p>
    pub fn supports_read_replica(&self) -> bool {
        self.supports_read_replica
    }
    /// <p>A list of the supported DB engine modes.</p>
    pub fn supported_engine_modes(&self) -> std::option::Option<&[std::string::String]> {
        self.supported_engine_modes.as_deref()
    }
    /// <p>
    /// A list of features supported by the DB engine.
    /// </p>
    /// <p>The supported features vary by DB engine and DB engine version.</p>
    /// <p>To determine the supported features for a specific DB engine and DB engine version using the CLI,
    /// use the following command:</p>
    /// <p>
    /// <code>aws rds describe-db-engine-versions --engine <engine_name> --engine-version <engine_version></code>
    /// </p>
    /// <p>For example, to determine the supported features for RDS for PostgreSQL version 13.3 using the CLI,
    /// use the following command:</p>
    /// <p>
    /// <code>aws rds describe-db-engine-versions --engine postgres --engine-version 13.3</code>
    /// </p>
    /// <p>The supported features are listed under <code>SupportedFeatureNames</code> in the output.</p>
    pub fn supported_feature_names(&self) -> std::option::Option<&[std::string::String]> {
        self.supported_feature_names.as_deref()
    }
    /// <p>The status of the DB engine version, either <code>available</code> or <code>deprecated</code>.</p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>A value that indicates whether you can use Aurora parallel query with a specific DB engine version.</p>
    pub fn supports_parallel_query(&self) -> bool {
        self.supports_parallel_query
    }
    /// <p>A value that indicates whether you can use Aurora global databases with a specific DB engine version.</p>
    pub fn supports_global_databases(&self) -> bool {
        self.supports_global_databases
    }
    /// <p>The major engine version of the CEV.</p>
    pub fn major_engine_version(&self) -> std::option::Option<&str> {
        self.major_engine_version.as_deref()
    }
    /// <p>The name of the Amazon S3 bucket that contains your database installation files.</p>
    pub fn database_installation_files_s3_bucket_name(&self) -> std::option::Option<&str> {
        self.database_installation_files_s3_bucket_name.as_deref()
    }
    /// <p>The Amazon S3 directory that contains the database installation files.
    /// If not specified, then no prefix is assumed.</p>
    pub fn database_installation_files_s3_prefix(&self) -> std::option::Option<&str> {
        self.database_installation_files_s3_prefix.as_deref()
    }
    /// <p>The ARN of the custom engine version.</p>
    pub fn db_engine_version_arn(&self) -> std::option::Option<&str> {
        self.db_engine_version_arn.as_deref()
    }
    /// <p>The Amazon Web Services KMS key identifier for an encrypted CEV. This parameter is required for
    /// RDS Custom, but optional for Amazon RDS.</p>
    pub fn kms_key_id(&self) -> std::option::Option<&str> {
        self.kms_key_id.as_deref()
    }
    /// <p>The creation time of the DB engine version.</p>
    pub fn create_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.create_time.as_ref()
    }
    /// <p>A list of tags.
    /// For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources</a> in the <i>Amazon RDS User Guide.</i>           
    /// </p>
    pub fn tag_list(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tag_list.as_deref()
    }
}
impl std::fmt::Debug for CreateCustomDbEngineVersionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateCustomDbEngineVersionOutput");
        formatter.field("engine", &self.engine);
        formatter.field("engine_version", &self.engine_version);
        formatter.field("db_parameter_group_family", &self.db_parameter_group_family);
        formatter.field("db_engine_description", &self.db_engine_description);
        formatter.field(
            "db_engine_version_description",
            &self.db_engine_version_description,
        );
        formatter.field("default_character_set", &self.default_character_set);
        formatter.field("supported_character_sets", &self.supported_character_sets);
        formatter.field(
            "supported_nchar_character_sets",
            &self.supported_nchar_character_sets,
        );
        formatter.field("valid_upgrade_target", &self.valid_upgrade_target);
        formatter.field("supported_timezones", &self.supported_timezones);
        formatter.field("exportable_log_types", &self.exportable_log_types);
        formatter.field(
            "supports_log_exports_to_cloudwatch_logs",
            &self.supports_log_exports_to_cloudwatch_logs,
        );
        formatter.field("supports_read_replica", &self.supports_read_replica);
        formatter.field("supported_engine_modes", &self.supported_engine_modes);
        formatter.field("supported_feature_names", &self.supported_feature_names);
        formatter.field("status", &self.status);
        formatter.field("supports_parallel_query", &self.supports_parallel_query);
        formatter.field("supports_global_databases", &self.supports_global_databases);
        formatter.field("major_engine_version", &self.major_engine_version);
        formatter.field(
            "database_installation_files_s3_bucket_name",
            &self.database_installation_files_s3_bucket_name,
        );
        formatter.field(
            "database_installation_files_s3_prefix",
            &self.database_installation_files_s3_prefix,
        );
        formatter.field("db_engine_version_arn", &self.db_engine_version_arn);
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.field("create_time", &self.create_time);
        formatter.field("tag_list", &self.tag_list);
        formatter.finish()
    }
}
/// See [`CreateCustomDbEngineVersionOutput`](crate::output::CreateCustomDbEngineVersionOutput)
pub mod create_custom_db_engine_version_output {
    /// A builder for [`CreateCustomDbEngineVersionOutput`](crate::output::CreateCustomDbEngineVersionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) engine: std::option::Option<std::string::String>,
        pub(crate) engine_version: std::option::Option<std::string::String>,
        pub(crate) db_parameter_group_family: std::option::Option<std::string::String>,
        pub(crate) db_engine_description: std::option::Option<std::string::String>,
        pub(crate) db_engine_version_description: std::option::Option<std::string::String>,
        pub(crate) default_character_set: std::option::Option<crate::model::CharacterSet>,
        pub(crate) supported_character_sets:
            std::option::Option<std::vec::Vec<crate::model::CharacterSet>>,
        pub(crate) supported_nchar_character_sets:
            std::option::Option<std::vec::Vec<crate::model::CharacterSet>>,
        pub(crate) valid_upgrade_target:
            std::option::Option<std::vec::Vec<crate::model::UpgradeTarget>>,
        pub(crate) supported_timezones: std::option::Option<std::vec::Vec<crate::model::Timezone>>,
        pub(crate) exportable_log_types: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) supports_log_exports_to_cloudwatch_logs: std::option::Option<bool>,
        pub(crate) supports_read_replica: std::option::Option<bool>,
        pub(crate) supported_engine_modes: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) supported_feature_names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) supports_parallel_query: std::option::Option<bool>,
        pub(crate) supports_global_databases: std::option::Option<bool>,
        pub(crate) major_engine_version: std::option::Option<std::string::String>,
        pub(crate) database_installation_files_s3_bucket_name:
            std::option::Option<std::string::String>,
        pub(crate) database_installation_files_s3_prefix: std::option::Option<std::string::String>,
        pub(crate) db_engine_version_arn: std::option::Option<std::string::String>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
        pub(crate) create_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) tag_list: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of the database engine.</p>
        pub fn engine(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine = Some(input.into());
            self
        }
        /// <p>The name of the database engine.</p>
        pub fn set_engine(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.engine = input;
            self
        }
        /// <p>The version number of the database engine.</p>
        pub fn engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.engine_version = Some(input.into());
            self
        }
        /// <p>The version number of the database engine.</p>
        pub fn set_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.engine_version = input;
            self
        }
        /// <p>The name of the DB parameter group family for the database engine.</p>
        pub fn db_parameter_group_family(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_parameter_group_family = Some(input.into());
            self
        }
        /// <p>The name of the DB parameter group family for the database engine.</p>
        pub fn set_db_parameter_group_family(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_parameter_group_family = input;
            self
        }
        /// <p>The description of the database engine.</p>
        pub fn db_engine_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_engine_description = Some(input.into());
            self
        }
        /// <p>The description of the database engine.</p>
        pub fn set_db_engine_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_engine_description = input;
            self
        }
        /// <p>The description of the database engine version.</p>
        pub fn db_engine_version_description(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.db_engine_version_description = Some(input.into());
            self
        }
        /// <p>The description of the database engine version.</p>
        pub fn set_db_engine_version_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_engine_version_description = input;
            self
        }
        /// <p>
        /// The default character set for new instances of this engine version,
        /// if the <code>CharacterSetName</code> parameter of the CreateDBInstance API
        /// isn't specified.
        /// </p>
        pub fn default_character_set(mut self, input: crate::model::CharacterSet) -> Self {
            self.default_character_set = Some(input);
            self
        }
        /// <p>
        /// The default character set for new instances of this engine version,
        /// if the <code>CharacterSetName</code> parameter of the CreateDBInstance API
        /// isn't specified.
        /// </p>
        pub fn set_default_character_set(
            mut self,
            input: std::option::Option<crate::model::CharacterSet>,
        ) -> Self {
            self.default_character_set = input;
            self
        }
        /// Appends an item to `supported_character_sets`.
        ///
        /// To override the contents of this collection use [`set_supported_character_sets`](Self::set_supported_character_sets).
        ///
        /// <p>A list of the character sets supported by this engine for the <code>CharacterSetName</code> parameter of the <code>CreateDBInstance</code> operation.  
        /// </p>
        pub fn supported_character_sets(
            mut self,
            input: impl Into<crate::model::CharacterSet>,
        ) -> Self {
            let mut v = self.supported_character_sets.unwrap_or_default();
            v.push(input.into());
            self.supported_character_sets = Some(v);
            self
        }
        /// <p>A list of the character sets supported by this engine for the <code>CharacterSetName</code> parameter of the <code>CreateDBInstance</code> operation.  
        /// </p>
        pub fn set_supported_character_sets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CharacterSet>>,
        ) -> Self {
            self.supported_character_sets = input;
            self
        }
        /// Appends an item to `supported_nchar_character_sets`.
        ///
        /// To override the contents of this collection use [`set_supported_nchar_character_sets`](Self::set_supported_nchar_character_sets).
        ///
        /// <p>A list of the character sets supported by the Oracle DB engine for the <code>NcharCharacterSetName</code> parameter of the <code>CreateDBInstance</code> operation.  
        /// </p>
        pub fn supported_nchar_character_sets(
            mut self,
            input: impl Into<crate::model::CharacterSet>,
        ) -> Self {
            let mut v = self.supported_nchar_character_sets.unwrap_or_default();
            v.push(input.into());
            self.supported_nchar_character_sets = Some(v);
            self
        }
        /// <p>A list of the character sets supported by the Oracle DB engine for the <code>NcharCharacterSetName</code> parameter of the <code>CreateDBInstance</code> operation.  
        /// </p>
        pub fn set_supported_nchar_character_sets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CharacterSet>>,
        ) -> Self {
            self.supported_nchar_character_sets = input;
            self
        }
        /// Appends an item to `valid_upgrade_target`.
        ///
        /// To override the contents of this collection use [`set_valid_upgrade_target`](Self::set_valid_upgrade_target).
        ///
        /// <p>A list of engine versions that this database engine version can be upgraded to.</p>
        pub fn valid_upgrade_target(
            mut self,
            input: impl Into<crate::model::UpgradeTarget>,
        ) -> Self {
            let mut v = self.valid_upgrade_target.unwrap_or_default();
            v.push(input.into());
            self.valid_upgrade_target = Some(v);
            self
        }
        /// <p>A list of engine versions that this database engine version can be upgraded to.</p>
        pub fn set_valid_upgrade_target(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UpgradeTarget>>,
        ) -> Self {
            self.valid_upgrade_target = input;
            self
        }
        /// Appends an item to `supported_timezones`.
        ///
        /// To override the contents of this collection use [`set_supported_timezones`](Self::set_supported_timezones).
        ///
        /// <p>A list of the time zones supported by this engine for the
        /// <code>Timezone</code> parameter of the <code>CreateDBInstance</code> action.  
        /// </p>
        pub fn supported_timezones(mut self, input: impl Into<crate::model::Timezone>) -> Self {
            let mut v = self.supported_timezones.unwrap_or_default();
            v.push(input.into());
            self.supported_timezones = Some(v);
            self
        }
        /// <p>A list of the time zones supported by this engine for the
        /// <code>Timezone</code> parameter of the <code>CreateDBInstance</code> action.  
        /// </p>
        pub fn set_supported_timezones(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Timezone>>,
        ) -> Self {
            self.supported_timezones = input;
            self
        }
        /// Appends an item to `exportable_log_types`.
        ///
        /// To override the contents of this collection use [`set_exportable_log_types`](Self::set_exportable_log_types).
        ///
        /// <p>The types of logs that the database engine has available for export to CloudWatch Logs.</p>
        pub fn exportable_log_types(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.exportable_log_types.unwrap_or_default();
            v.push(input.into());
            self.exportable_log_types = Some(v);
            self
        }
        /// <p>The types of logs that the database engine has available for export to CloudWatch Logs.</p>
        pub fn set_exportable_log_types(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.exportable_log_types = input;
            self
        }
        /// <p>A value that indicates whether the engine version supports exporting the log types specified by ExportableLogTypes to CloudWatch Logs.</p>
        pub fn supports_log_exports_to_cloudwatch_logs(mut self, input: bool) -> Self {
            self.supports_log_exports_to_cloudwatch_logs = Some(input);
            self
        }
        /// <p>A value that indicates whether the engine version supports exporting the log types specified by ExportableLogTypes to CloudWatch Logs.</p>
        pub fn set_supports_log_exports_to_cloudwatch_logs(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.supports_log_exports_to_cloudwatch_logs = input;
            self
        }
        /// <p>Indicates whether the database engine version supports read replicas.</p>
        pub fn supports_read_replica(mut self, input: bool) -> Self {
            self.supports_read_replica = Some(input);
            self
        }
        /// <p>Indicates whether the database engine version supports read replicas.</p>
        pub fn set_supports_read_replica(mut self, input: std::option::Option<bool>) -> Self {
            self.supports_read_replica = input;
            self
        }
        /// Appends an item to `supported_engine_modes`.
        ///
        /// To override the contents of this collection use [`set_supported_engine_modes`](Self::set_supported_engine_modes).
        ///
        /// <p>A list of the supported DB engine modes.</p>
        pub fn supported_engine_modes(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.supported_engine_modes.unwrap_or_default();
            v.push(input.into());
            self.supported_engine_modes = Some(v);
            self
        }
        /// <p>A list of the supported DB engine modes.</p>
        pub fn set_supported_engine_modes(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.supported_engine_modes = input;
            self
        }
        /// Appends an item to `supported_feature_names`.
        ///
        /// To override the contents of this collection use [`set_supported_feature_names`](Self::set_supported_feature_names).
        ///
        /// <p>
        /// A list of features supported by the DB engine.
        /// </p>
        /// <p>The supported features vary by DB engine and DB engine version.</p>
        /// <p>To determine the supported features for a specific DB engine and DB engine version using the CLI,
        /// use the following command:</p>
        /// <p>
        /// <code>aws rds describe-db-engine-versions --engine <engine_name> --engine-version <engine_version></code>
        /// </p>
        /// <p>For example, to determine the supported features for RDS for PostgreSQL version 13.3 using the CLI,
        /// use the following command:</p>
        /// <p>
        /// <code>aws rds describe-db-engine-versions --engine postgres --engine-version 13.3</code>
        /// </p>
        /// <p>The supported features are listed under <code>SupportedFeatureNames</code> in the output.</p>
        pub fn supported_feature_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.supported_feature_names.unwrap_or_default();
            v.push(input.into());
            self.supported_feature_names = Some(v);
            self
        }
        /// <p>
        /// A list of features supported by the DB engine.
        /// </p>
        /// <p>The supported features vary by DB engine and DB engine version.</p>
        /// <p>To determine the supported features for a specific DB engine and DB engine version using the CLI,
        /// use the following command:</p>
        /// <p>
        /// <code>aws rds describe-db-engine-versions --engine <engine_name> --engine-version <engine_version></code>
        /// </p>
        /// <p>For example, to determine the supported features for RDS for PostgreSQL version 13.3 using the CLI,
        /// use the following command:</p>
        /// <p>
        /// <code>aws rds describe-db-engine-versions --engine postgres --engine-version 13.3</code>
        /// </p>
        /// <p>The supported features are listed under <code>SupportedFeatureNames</code> in the output.</p>
        pub fn set_supported_feature_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.supported_feature_names = input;
            self
        }
        /// <p>The status of the DB engine version, either <code>available</code> or <code>deprecated</code>.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the DB engine version, either <code>available</code> or <code>deprecated</code>.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>A value that indicates whether you can use Aurora parallel query with a specific DB engine version.</p>
        pub fn supports_parallel_query(mut self, input: bool) -> Self {
            self.supports_parallel_query = Some(input);
            self
        }
        /// <p>A value that indicates whether you can use Aurora parallel query with a specific DB engine version.</p>
        pub fn set_supports_parallel_query(mut self, input: std::option::Option<bool>) -> Self {
            self.supports_parallel_query = input;
            self
        }
        /// <p>A value that indicates whether you can use Aurora global databases with a specific DB engine version.</p>
        pub fn supports_global_databases(mut self, input: bool) -> Self {
            self.supports_global_databases = Some(input);
            self
        }
        /// <p>A value that indicates whether you can use Aurora global databases with a specific DB engine version.</p>
        pub fn set_supports_global_databases(mut self, input: std::option::Option<bool>) -> Self {
            self.supports_global_databases = input;
            self
        }
        /// <p>The major engine version of the CEV.</p>
        pub fn major_engine_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.major_engine_version = Some(input.into());
            self
        }
        /// <p>The major engine version of the CEV.</p>
        pub fn set_major_engine_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.major_engine_version = input;
            self
        }
        /// <p>The name of the Amazon S3 bucket that contains your database installation files.</p>
        pub fn database_installation_files_s3_bucket_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.database_installation_files_s3_bucket_name = Some(input.into());
            self
        }
        /// <p>The name of the Amazon S3 bucket that contains your database installation files.</p>
        pub fn set_database_installation_files_s3_bucket_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.database_installation_files_s3_bucket_name = input;
            self
        }
        /// <p>The Amazon S3 directory that contains the database installation files.
        /// If not specified, then no prefix is assumed.</p>
        pub fn database_installation_files_s3_prefix(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.database_installation_files_s3_prefix = Some(input.into());
            self
        }
        /// <p>The Amazon S3 directory that contains the database installation files.
        /// If not specified, then no prefix is assumed.</p>
        pub fn set_database_installation_files_s3_prefix(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.database_installation_files_s3_prefix = input;
            self
        }
        /// <p>The ARN of the custom engine version.</p>
        pub fn db_engine_version_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_engine_version_arn = Some(input.into());
            self
        }
        /// <p>The ARN of the custom engine version.</p>
        pub fn set_db_engine_version_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_engine_version_arn = input;
            self
        }
        /// <p>The Amazon Web Services KMS key identifier for an encrypted CEV. This parameter is required for
        /// RDS Custom, but optional for Amazon RDS.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services KMS key identifier for an encrypted CEV. This parameter is required for
        /// RDS Custom, but optional for Amazon RDS.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// <p>The creation time of the DB engine version.</p>
        pub fn create_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.create_time = Some(input);
            self
        }
        /// <p>The creation time of the DB engine version.</p>
        pub fn set_create_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.create_time = input;
            self
        }
        /// Appends an item to `tag_list`.
        ///
        /// To override the contents of this collection use [`set_tag_list`](Self::set_tag_list).
        ///
        /// <p>A list of tags.
        /// For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources</a> in the <i>Amazon RDS User Guide.</i>           
        /// </p>
        pub fn tag_list(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tag_list.unwrap_or_default();
            v.push(input.into());
            self.tag_list = Some(v);
            self
        }
        /// <p>A list of tags.
        /// For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources</a> in the <i>Amazon RDS User Guide.</i>           
        /// </p>
        pub fn set_tag_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tag_list = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateCustomDbEngineVersionOutput`](crate::output::CreateCustomDbEngineVersionOutput)
        pub fn build(self) -> crate::output::CreateCustomDbEngineVersionOutput {
            crate::output::CreateCustomDbEngineVersionOutput {
                engine: self.engine,
                engine_version: self.engine_version,
                db_parameter_group_family: self.db_parameter_group_family,
                db_engine_description: self.db_engine_description,
                db_engine_version_description: self.db_engine_version_description,
                default_character_set: self.default_character_set,
                supported_character_sets: self.supported_character_sets,
                supported_nchar_character_sets: self.supported_nchar_character_sets,
                valid_upgrade_target: self.valid_upgrade_target,
                supported_timezones: self.supported_timezones,
                exportable_log_types: self.exportable_log_types,
                supports_log_exports_to_cloudwatch_logs: self
                    .supports_log_exports_to_cloudwatch_logs
                    .unwrap_or_default(),
                supports_read_replica: self.supports_read_replica.unwrap_or_default(),
                supported_engine_modes: self.supported_engine_modes,
                supported_feature_names: self.supported_feature_names,
                status: self.status,
                supports_parallel_query: self.supports_parallel_query.unwrap_or_default(),
                supports_global_databases: self.supports_global_databases.unwrap_or_default(),
                major_engine_version: self.major_engine_version,
                database_installation_files_s3_bucket_name: self
                    .database_installation_files_s3_bucket_name,
                database_installation_files_s3_prefix: self.database_installation_files_s3_prefix,
                db_engine_version_arn: self.db_engine_version_arn,
                kms_key_id: self.kms_key_id,
                create_time: self.create_time,
                tag_list: self.tag_list,
            }
        }
    }
}
impl CreateCustomDbEngineVersionOutput {
    /// Creates a new builder-style object to manufacture [`CreateCustomDbEngineVersionOutput`](crate::output::CreateCustomDbEngineVersionOutput)
    pub fn builder() -> crate::output::create_custom_db_engine_version_output::Builder {
        crate::output::create_custom_db_engine_version_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateCustomAvailabilityZoneOutput {
    /// <p>A custom Availability Zone (AZ) is an on-premises AZ that is integrated with a VMware vSphere cluster.</p>
    /// <p>For more information about RDS on VMware, see the
    /// <a href="https://docs.aws.amazon.com/AmazonRDS/latest/RDSonVMwareUserGuide/rds-on-vmware.html">
    /// RDS on VMware User Guide.</a>
    /// </p>
    pub custom_availability_zone: std::option::Option<crate::model::CustomAvailabilityZone>,
}
impl CreateCustomAvailabilityZoneOutput {
    /// <p>A custom Availability Zone (AZ) is an on-premises AZ that is integrated with a VMware vSphere cluster.</p>
    /// <p>For more information about RDS on VMware, see the
    /// <a href="https://docs.aws.amazon.com/AmazonRDS/latest/RDSonVMwareUserGuide/rds-on-vmware.html">
    /// RDS on VMware User Guide.</a>
    /// </p>
    pub fn custom_availability_zone(
        &self,
    ) -> std::option::Option<&crate::model::CustomAvailabilityZone> {
        self.custom_availability_zone.as_ref()
    }
}
impl std::fmt::Debug for CreateCustomAvailabilityZoneOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateCustomAvailabilityZoneOutput");
        formatter.field("custom_availability_zone", &self.custom_availability_zone);
        formatter.finish()
    }
}
/// See [`CreateCustomAvailabilityZoneOutput`](crate::output::CreateCustomAvailabilityZoneOutput)
pub mod create_custom_availability_zone_output {
    /// A builder for [`CreateCustomAvailabilityZoneOutput`](crate::output::CreateCustomAvailabilityZoneOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) custom_availability_zone:
            std::option::Option<crate::model::CustomAvailabilityZone>,
    }
    impl Builder {
        /// <p>A custom Availability Zone (AZ) is an on-premises AZ that is integrated with a VMware vSphere cluster.</p>
        /// <p>For more information about RDS on VMware, see the
        /// <a href="https://docs.aws.amazon.com/AmazonRDS/latest/RDSonVMwareUserGuide/rds-on-vmware.html">
        /// RDS on VMware User Guide.</a>
        /// </p>
        pub fn custom_availability_zone(
            mut self,
            input: crate::model::CustomAvailabilityZone,
        ) -> Self {
            self.custom_availability_zone = Some(input);
            self
        }
        /// <p>A custom Availability Zone (AZ) is an on-premises AZ that is integrated with a VMware vSphere cluster.</p>
        /// <p>For more information about RDS on VMware, see the
        /// <a href="https://docs.aws.amazon.com/AmazonRDS/latest/RDSonVMwareUserGuide/rds-on-vmware.html">
        /// RDS on VMware User Guide.</a>
        /// </p>
        pub fn set_custom_availability_zone(
            mut self,
            input: std::option::Option<crate::model::CustomAvailabilityZone>,
        ) -> Self {
            self.custom_availability_zone = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateCustomAvailabilityZoneOutput`](crate::output::CreateCustomAvailabilityZoneOutput)
        pub fn build(self) -> crate::output::CreateCustomAvailabilityZoneOutput {
            crate::output::CreateCustomAvailabilityZoneOutput {
                custom_availability_zone: self.custom_availability_zone,
            }
        }
    }
}
impl CreateCustomAvailabilityZoneOutput {
    /// Creates a new builder-style object to manufacture [`CreateCustomAvailabilityZoneOutput`](crate::output::CreateCustomAvailabilityZoneOutput)
    pub fn builder() -> crate::output::create_custom_availability_zone_output::Builder {
        crate::output::create_custom_availability_zone_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CopyOptionGroupOutput {
    /// <p></p>
    pub option_group: std::option::Option<crate::model::OptionGroup>,
}
impl CopyOptionGroupOutput {
    /// <p></p>
    pub fn option_group(&self) -> std::option::Option<&crate::model::OptionGroup> {
        self.option_group.as_ref()
    }
}
impl std::fmt::Debug for CopyOptionGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CopyOptionGroupOutput");
        formatter.field("option_group", &self.option_group);
        formatter.finish()
    }
}
/// See [`CopyOptionGroupOutput`](crate::output::CopyOptionGroupOutput)
pub mod copy_option_group_output {
    /// A builder for [`CopyOptionGroupOutput`](crate::output::CopyOptionGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) option_group: std::option::Option<crate::model::OptionGroup>,
    }
    impl Builder {
        /// <p></p>
        pub fn option_group(mut self, input: crate::model::OptionGroup) -> Self {
            self.option_group = Some(input);
            self
        }
        /// <p></p>
        pub fn set_option_group(
            mut self,
            input: std::option::Option<crate::model::OptionGroup>,
        ) -> Self {
            self.option_group = input;
            self
        }
        /// Consumes the builder and constructs a [`CopyOptionGroupOutput`](crate::output::CopyOptionGroupOutput)
        pub fn build(self) -> crate::output::CopyOptionGroupOutput {
            crate::output::CopyOptionGroupOutput {
                option_group: self.option_group,
            }
        }
    }
}
impl CopyOptionGroupOutput {
    /// Creates a new builder-style object to manufacture [`CopyOptionGroupOutput`](crate::output::CopyOptionGroupOutput)
    pub fn builder() -> crate::output::copy_option_group_output::Builder {
        crate::output::copy_option_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CopyDbSnapshotOutput {
    /// <p>Contains the details of an Amazon RDS DB snapshot.
    /// </p>
    /// <p>This data type is used as a response element
    /// in the <code>DescribeDBSnapshots</code> action.
    /// </p>
    pub db_snapshot: std::option::Option<crate::model::DbSnapshot>,
}
impl CopyDbSnapshotOutput {
    /// <p>Contains the details of an Amazon RDS DB snapshot.
    /// </p>
    /// <p>This data type is used as a response element
    /// in the <code>DescribeDBSnapshots</code> action.
    /// </p>
    pub fn db_snapshot(&self) -> std::option::Option<&crate::model::DbSnapshot> {
        self.db_snapshot.as_ref()
    }
}
impl std::fmt::Debug for CopyDbSnapshotOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CopyDbSnapshotOutput");
        formatter.field("db_snapshot", &self.db_snapshot);
        formatter.finish()
    }
}
/// See [`CopyDbSnapshotOutput`](crate::output::CopyDbSnapshotOutput)
pub mod copy_db_snapshot_output {
    /// A builder for [`CopyDbSnapshotOutput`](crate::output::CopyDbSnapshotOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_snapshot: std::option::Option<crate::model::DbSnapshot>,
    }
    impl Builder {
        /// <p>Contains the details of an Amazon RDS DB snapshot.
        /// </p>
        /// <p>This data type is used as a response element
        /// in the <code>DescribeDBSnapshots</code> action.
        /// </p>
        pub fn db_snapshot(mut self, input: crate::model::DbSnapshot) -> Self {
            self.db_snapshot = Some(input);
            self
        }
        /// <p>Contains the details of an Amazon RDS DB snapshot.
        /// </p>
        /// <p>This data type is used as a response element
        /// in the <code>DescribeDBSnapshots</code> action.
        /// </p>
        pub fn set_db_snapshot(
            mut self,
            input: std::option::Option<crate::model::DbSnapshot>,
        ) -> Self {
            self.db_snapshot = input;
            self
        }
        /// Consumes the builder and constructs a [`CopyDbSnapshotOutput`](crate::output::CopyDbSnapshotOutput)
        pub fn build(self) -> crate::output::CopyDbSnapshotOutput {
            crate::output::CopyDbSnapshotOutput {
                db_snapshot: self.db_snapshot,
            }
        }
    }
}
impl CopyDbSnapshotOutput {
    /// Creates a new builder-style object to manufacture [`CopyDbSnapshotOutput`](crate::output::CopyDbSnapshotOutput)
    pub fn builder() -> crate::output::copy_db_snapshot_output::Builder {
        crate::output::copy_db_snapshot_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CopyDbParameterGroupOutput {
    /// <p>Contains the details of an Amazon RDS DB parameter group.
    /// </p>
    /// <p>This data type is used as a response element in the <code>DescribeDBParameterGroups</code> action.
    /// </p>
    pub db_parameter_group: std::option::Option<crate::model::DbParameterGroup>,
}
impl CopyDbParameterGroupOutput {
    /// <p>Contains the details of an Amazon RDS DB parameter group.
    /// </p>
    /// <p>This data type is used as a response element in the <code>DescribeDBParameterGroups</code> action.
    /// </p>
    pub fn db_parameter_group(&self) -> std::option::Option<&crate::model::DbParameterGroup> {
        self.db_parameter_group.as_ref()
    }
}
impl std::fmt::Debug for CopyDbParameterGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CopyDbParameterGroupOutput");
        formatter.field("db_parameter_group", &self.db_parameter_group);
        formatter.finish()
    }
}
/// See [`CopyDbParameterGroupOutput`](crate::output::CopyDbParameterGroupOutput)
pub mod copy_db_parameter_group_output {
    /// A builder for [`CopyDbParameterGroupOutput`](crate::output::CopyDbParameterGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_parameter_group: std::option::Option<crate::model::DbParameterGroup>,
    }
    impl Builder {
        /// <p>Contains the details of an Amazon RDS DB parameter group.
        /// </p>
        /// <p>This data type is used as a response element in the <code>DescribeDBParameterGroups</code> action.
        /// </p>
        pub fn db_parameter_group(mut self, input: crate::model::DbParameterGroup) -> Self {
            self.db_parameter_group = Some(input);
            self
        }
        /// <p>Contains the details of an Amazon RDS DB parameter group.
        /// </p>
        /// <p>This data type is used as a response element in the <code>DescribeDBParameterGroups</code> action.
        /// </p>
        pub fn set_db_parameter_group(
            mut self,
            input: std::option::Option<crate::model::DbParameterGroup>,
        ) -> Self {
            self.db_parameter_group = input;
            self
        }
        /// Consumes the builder and constructs a [`CopyDbParameterGroupOutput`](crate::output::CopyDbParameterGroupOutput)
        pub fn build(self) -> crate::output::CopyDbParameterGroupOutput {
            crate::output::CopyDbParameterGroupOutput {
                db_parameter_group: self.db_parameter_group,
            }
        }
    }
}
impl CopyDbParameterGroupOutput {
    /// Creates a new builder-style object to manufacture [`CopyDbParameterGroupOutput`](crate::output::CopyDbParameterGroupOutput)
    pub fn builder() -> crate::output::copy_db_parameter_group_output::Builder {
        crate::output::copy_db_parameter_group_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CopyDbClusterSnapshotOutput {
    /// <p>Contains the details for an Amazon RDS DB cluster snapshot
    /// </p>
    /// <p>This data type is used as a response element
    /// in the <code>DescribeDBClusterSnapshots</code> action.
    /// </p>
    pub db_cluster_snapshot: std::option::Option<crate::model::DbClusterSnapshot>,
}
impl CopyDbClusterSnapshotOutput {
    /// <p>Contains the details for an Amazon RDS DB cluster snapshot
    /// </p>
    /// <p>This data type is used as a response element
    /// in the <code>DescribeDBClusterSnapshots</code> action.
    /// </p>
    pub fn db_cluster_snapshot(&self) -> std::option::Option<&crate::model::DbClusterSnapshot> {
        self.db_cluster_snapshot.as_ref()
    }
}
impl std::fmt::Debug for CopyDbClusterSnapshotOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CopyDbClusterSnapshotOutput");
        formatter.field("db_cluster_snapshot", &self.db_cluster_snapshot);
        formatter.finish()
    }
}
/// See [`CopyDbClusterSnapshotOutput`](crate::output::CopyDbClusterSnapshotOutput)
pub mod copy_db_cluster_snapshot_output {
    /// A builder for [`CopyDbClusterSnapshotOutput`](crate::output::CopyDbClusterSnapshotOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster_snapshot: std::option::Option<crate::model::DbClusterSnapshot>,
    }
    impl Builder {
        /// <p>Contains the details for an Amazon RDS DB cluster snapshot
        /// </p>
        /// <p>This data type is used as a response element
        /// in the <code>DescribeDBClusterSnapshots</code> action.
        /// </p>
        pub fn db_cluster_snapshot(mut self, input: crate::model::DbClusterSnapshot) -> Self {
            self.db_cluster_snapshot = Some(input);
            self
        }
        /// <p>Contains the details for an Amazon RDS DB cluster snapshot
        /// </p>
        /// <p>This data type is used as a response element
        /// in the <code>DescribeDBClusterSnapshots</code> action.
        /// </p>
        pub fn set_db_cluster_snapshot(
            mut self,
            input: std::option::Option<crate::model::DbClusterSnapshot>,
        ) -> Self {
            self.db_cluster_snapshot = input;
            self
        }
        /// Consumes the builder and constructs a [`CopyDbClusterSnapshotOutput`](crate::output::CopyDbClusterSnapshotOutput)
        pub fn build(self) -> crate::output::CopyDbClusterSnapshotOutput {
            crate::output::CopyDbClusterSnapshotOutput {
                db_cluster_snapshot: self.db_cluster_snapshot,
            }
        }
    }
}
impl CopyDbClusterSnapshotOutput {
    /// Creates a new builder-style object to manufacture [`CopyDbClusterSnapshotOutput`](crate::output::CopyDbClusterSnapshotOutput)
    pub fn builder() -> crate::output::copy_db_cluster_snapshot_output::Builder {
        crate::output::copy_db_cluster_snapshot_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CopyDbClusterParameterGroupOutput {
    /// <p>Contains the details of an Amazon RDS DB cluster parameter group.
    /// </p>
    /// <p>This data type is used as a response element in the <code>DescribeDBClusterParameterGroups</code> action.
    /// </p>
    pub db_cluster_parameter_group: std::option::Option<crate::model::DbClusterParameterGroup>,
}
impl CopyDbClusterParameterGroupOutput {
    /// <p>Contains the details of an Amazon RDS DB cluster parameter group.
    /// </p>
    /// <p>This data type is used as a response element in the <code>DescribeDBClusterParameterGroups</code> action.
    /// </p>
    pub fn db_cluster_parameter_group(
        &self,
    ) -> std::option::Option<&crate::model::DbClusterParameterGroup> {
        self.db_cluster_parameter_group.as_ref()
    }
}
impl std::fmt::Debug for CopyDbClusterParameterGroupOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CopyDbClusterParameterGroupOutput");
        formatter.field(
            "db_cluster_parameter_group",
            &self.db_cluster_parameter_group,
        );
        formatter.finish()
    }
}
/// See [`CopyDbClusterParameterGroupOutput`](crate::output::CopyDbClusterParameterGroupOutput)
pub mod copy_db_cluster_parameter_group_output {
    /// A builder for [`CopyDbClusterParameterGroupOutput`](crate::output::CopyDbClusterParameterGroupOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster_parameter_group:
            std::option::Option<crate::model::DbClusterParameterGroup>,
    }
    impl Builder {
        /// <p>Contains the details of an Amazon RDS DB cluster parameter group.
        /// </p>
        /// <p>This data type is used as a response element in the <code>DescribeDBClusterParameterGroups</code> action.
        /// </p>
        pub fn db_cluster_parameter_group(
            mut self,
            input: crate::model::DbClusterParameterGroup,
        ) -> Self {
            self.db_cluster_parameter_group = Some(input);
            self
        }
        /// <p>Contains the details of an Amazon RDS DB cluster parameter group.
        /// </p>
        /// <p>This data type is used as a response element in the <code>DescribeDBClusterParameterGroups</code> action.
        /// </p>
        pub fn set_db_cluster_parameter_group(
            mut self,
            input: std::option::Option<crate::model::DbClusterParameterGroup>,
        ) -> Self {
            self.db_cluster_parameter_group = input;
            self
        }
        /// Consumes the builder and constructs a [`CopyDbClusterParameterGroupOutput`](crate::output::CopyDbClusterParameterGroupOutput)
        pub fn build(self) -> crate::output::CopyDbClusterParameterGroupOutput {
            crate::output::CopyDbClusterParameterGroupOutput {
                db_cluster_parameter_group: self.db_cluster_parameter_group,
            }
        }
    }
}
impl CopyDbClusterParameterGroupOutput {
    /// Creates a new builder-style object to manufacture [`CopyDbClusterParameterGroupOutput`](crate::output::CopyDbClusterParameterGroupOutput)
    pub fn builder() -> crate::output::copy_db_cluster_parameter_group_output::Builder {
        crate::output::copy_db_cluster_parameter_group_output::Builder::default()
    }
}

/// <p>Contains the details of a snapshot export to Amazon S3.
/// </p>
/// <p>This data type is used as a response element in the <code>DescribeExportTasks</code> action.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CancelExportTaskOutput {
    /// <p>A unique identifier for the snapshot export task. This ID isn't an identifier for
    /// the Amazon S3 bucket where the snapshot is exported to. </p>
    pub export_task_identifier: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the snapshot exported to Amazon S3.</p>
    pub source_arn: std::option::Option<std::string::String>,
    /// <p>The data exported from the snapshot. Valid values are the following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>database</code> - Export all the data from a specified database.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>database.table</code>
    /// <i>table-name</i> -
    /// Export a table of the snapshot. This format is valid only for RDS for MySQL, RDS for MariaDB, and Aurora MySQL.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>database.schema</code>
    /// <i>schema-name</i> - Export a database schema of the snapshot.
    /// This format is valid only for RDS for PostgreSQL and Aurora PostgreSQL.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>database.schema.table</code>
    /// <i>table-name</i> - Export a table of the database schema.
    /// This format is valid only for RDS for PostgreSQL and Aurora PostgreSQL.</p>
    /// </li>
    /// </ul>
    pub export_only: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The time that the snapshot was created.</p>
    pub snapshot_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time that the snapshot export task started.</p>
    pub task_start_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time that the snapshot export task completed.</p>
    pub task_end_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The Amazon S3 bucket that the snapshot is exported to.</p>
    pub s3_bucket: std::option::Option<std::string::String>,
    /// <p>The Amazon S3 bucket prefix that is the file name and path of the exported snapshot.</p>
    pub s3_prefix: std::option::Option<std::string::String>,
    /// <p>The name of the IAM role that is used to write to Amazon S3 when exporting a snapshot. </p>
    pub iam_role_arn: std::option::Option<std::string::String>,
    /// <p>The key identifier of the Amazon Web Services KMS key that is used to encrypt the snapshot when it's exported to
    /// Amazon S3. The KMS key identifier is its key ARN, key ID, alias ARN, or alias name. The IAM role used for the snapshot export
    /// must have encryption and decryption permissions to use this KMS key. </p>
    pub kms_key_id: std::option::Option<std::string::String>,
    /// <p>The progress status of the export task.</p>
    pub status: std::option::Option<std::string::String>,
    /// <p>The progress of the snapshot export task as a percentage.</p>
    pub percent_progress: i32,
    /// <p>The total amount of data exported, in gigabytes.</p>
    pub total_extracted_data_in_gb: i32,
    /// <p>The reason the export failed, if it failed.</p>
    pub failure_cause: std::option::Option<std::string::String>,
    /// <p>A warning about the snapshot export task.</p>
    pub warning_message: std::option::Option<std::string::String>,
}
impl CancelExportTaskOutput {
    /// <p>A unique identifier for the snapshot export task. This ID isn't an identifier for
    /// the Amazon S3 bucket where the snapshot is exported to. </p>
    pub fn export_task_identifier(&self) -> std::option::Option<&str> {
        self.export_task_identifier.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the snapshot exported to Amazon S3.</p>
    pub fn source_arn(&self) -> std::option::Option<&str> {
        self.source_arn.as_deref()
    }
    /// <p>The data exported from the snapshot. Valid values are the following:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>database</code> - Export all the data from a specified database.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>database.table</code>
    /// <i>table-name</i> -
    /// Export a table of the snapshot. This format is valid only for RDS for MySQL, RDS for MariaDB, and Aurora MySQL.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>database.schema</code>
    /// <i>schema-name</i> - Export a database schema of the snapshot.
    /// This format is valid only for RDS for PostgreSQL and Aurora PostgreSQL.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>database.schema.table</code>
    /// <i>table-name</i> - Export a table of the database schema.
    /// This format is valid only for RDS for PostgreSQL and Aurora PostgreSQL.</p>
    /// </li>
    /// </ul>
    pub fn export_only(&self) -> std::option::Option<&[std::string::String]> {
        self.export_only.as_deref()
    }
    /// <p>The time that the snapshot was created.</p>
    pub fn snapshot_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.snapshot_time.as_ref()
    }
    /// <p>The time that the snapshot export task started.</p>
    pub fn task_start_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.task_start_time.as_ref()
    }
    /// <p>The time that the snapshot export task completed.</p>
    pub fn task_end_time(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.task_end_time.as_ref()
    }
    /// <p>The Amazon S3 bucket that the snapshot is exported to.</p>
    pub fn s3_bucket(&self) -> std::option::Option<&str> {
        self.s3_bucket.as_deref()
    }
    /// <p>The Amazon S3 bucket prefix that is the file name and path of the exported snapshot.</p>
    pub fn s3_prefix(&self) -> std::option::Option<&str> {
        self.s3_prefix.as_deref()
    }
    /// <p>The name of the IAM role that is used to write to Amazon S3 when exporting a snapshot. </p>
    pub fn iam_role_arn(&self) -> std::option::Option<&str> {
        self.iam_role_arn.as_deref()
    }
    /// <p>The key identifier of the Amazon Web Services KMS key that is used to encrypt the snapshot when it's exported to
    /// Amazon S3. The KMS key identifier is its key ARN, key ID, alias ARN, or alias name. The IAM role used for the snapshot export
    /// must have encryption and decryption permissions to use this KMS key. </p>
    pub fn kms_key_id(&self) -> std::option::Option<&str> {
        self.kms_key_id.as_deref()
    }
    /// <p>The progress status of the export task.</p>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
    /// <p>The progress of the snapshot export task as a percentage.</p>
    pub fn percent_progress(&self) -> i32 {
        self.percent_progress
    }
    /// <p>The total amount of data exported, in gigabytes.</p>
    pub fn total_extracted_data_in_gb(&self) -> i32 {
        self.total_extracted_data_in_gb
    }
    /// <p>The reason the export failed, if it failed.</p>
    pub fn failure_cause(&self) -> std::option::Option<&str> {
        self.failure_cause.as_deref()
    }
    /// <p>A warning about the snapshot export task.</p>
    pub fn warning_message(&self) -> std::option::Option<&str> {
        self.warning_message.as_deref()
    }
}
impl std::fmt::Debug for CancelExportTaskOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CancelExportTaskOutput");
        formatter.field("export_task_identifier", &self.export_task_identifier);
        formatter.field("source_arn", &self.source_arn);
        formatter.field("export_only", &self.export_only);
        formatter.field("snapshot_time", &self.snapshot_time);
        formatter.field("task_start_time", &self.task_start_time);
        formatter.field("task_end_time", &self.task_end_time);
        formatter.field("s3_bucket", &self.s3_bucket);
        formatter.field("s3_prefix", &self.s3_prefix);
        formatter.field("iam_role_arn", &self.iam_role_arn);
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.field("status", &self.status);
        formatter.field("percent_progress", &self.percent_progress);
        formatter.field(
            "total_extracted_data_in_gb",
            &self.total_extracted_data_in_gb,
        );
        formatter.field("failure_cause", &self.failure_cause);
        formatter.field("warning_message", &self.warning_message);
        formatter.finish()
    }
}
/// See [`CancelExportTaskOutput`](crate::output::CancelExportTaskOutput)
pub mod cancel_export_task_output {
    /// A builder for [`CancelExportTaskOutput`](crate::output::CancelExportTaskOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) export_task_identifier: std::option::Option<std::string::String>,
        pub(crate) source_arn: std::option::Option<std::string::String>,
        pub(crate) export_only: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) snapshot_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) task_start_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) task_end_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) s3_bucket: std::option::Option<std::string::String>,
        pub(crate) s3_prefix: std::option::Option<std::string::String>,
        pub(crate) iam_role_arn: std::option::Option<std::string::String>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<std::string::String>,
        pub(crate) percent_progress: std::option::Option<i32>,
        pub(crate) total_extracted_data_in_gb: std::option::Option<i32>,
        pub(crate) failure_cause: std::option::Option<std::string::String>,
        pub(crate) warning_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier for the snapshot export task. This ID isn't an identifier for
        /// the Amazon S3 bucket where the snapshot is exported to. </p>
        pub fn export_task_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.export_task_identifier = Some(input.into());
            self
        }
        /// <p>A unique identifier for the snapshot export task. This ID isn't an identifier for
        /// the Amazon S3 bucket where the snapshot is exported to. </p>
        pub fn set_export_task_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.export_task_identifier = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the snapshot exported to Amazon S3.</p>
        pub fn source_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the snapshot exported to Amazon S3.</p>
        pub fn set_source_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source_arn = input;
            self
        }
        /// Appends an item to `export_only`.
        ///
        /// To override the contents of this collection use [`set_export_only`](Self::set_export_only).
        ///
        /// <p>The data exported from the snapshot. Valid values are the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>database</code> - Export all the data from a specified database.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>database.table</code>
        /// <i>table-name</i> -
        /// Export a table of the snapshot. This format is valid only for RDS for MySQL, RDS for MariaDB, and Aurora MySQL.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>database.schema</code>
        /// <i>schema-name</i> - Export a database schema of the snapshot.
        /// This format is valid only for RDS for PostgreSQL and Aurora PostgreSQL.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>database.schema.table</code>
        /// <i>table-name</i> - Export a table of the database schema.
        /// This format is valid only for RDS for PostgreSQL and Aurora PostgreSQL.</p>
        /// </li>
        /// </ul>
        pub fn export_only(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.export_only.unwrap_or_default();
            v.push(input.into());
            self.export_only = Some(v);
            self
        }
        /// <p>The data exported from the snapshot. Valid values are the following:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>database</code> - Export all the data from a specified database.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>database.table</code>
        /// <i>table-name</i> -
        /// Export a table of the snapshot. This format is valid only for RDS for MySQL, RDS for MariaDB, and Aurora MySQL.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>database.schema</code>
        /// <i>schema-name</i> - Export a database schema of the snapshot.
        /// This format is valid only for RDS for PostgreSQL and Aurora PostgreSQL.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>database.schema.table</code>
        /// <i>table-name</i> - Export a table of the database schema.
        /// This format is valid only for RDS for PostgreSQL and Aurora PostgreSQL.</p>
        /// </li>
        /// </ul>
        pub fn set_export_only(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.export_only = input;
            self
        }
        /// <p>The time that the snapshot was created.</p>
        pub fn snapshot_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.snapshot_time = Some(input);
            self
        }
        /// <p>The time that the snapshot was created.</p>
        pub fn set_snapshot_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.snapshot_time = input;
            self
        }
        /// <p>The time that the snapshot export task started.</p>
        pub fn task_start_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.task_start_time = Some(input);
            self
        }
        /// <p>The time that the snapshot export task started.</p>
        pub fn set_task_start_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.task_start_time = input;
            self
        }
        /// <p>The time that the snapshot export task completed.</p>
        pub fn task_end_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.task_end_time = Some(input);
            self
        }
        /// <p>The time that the snapshot export task completed.</p>
        pub fn set_task_end_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.task_end_time = input;
            self
        }
        /// <p>The Amazon S3 bucket that the snapshot is exported to.</p>
        pub fn s3_bucket(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_bucket = Some(input.into());
            self
        }
        /// <p>The Amazon S3 bucket that the snapshot is exported to.</p>
        pub fn set_s3_bucket(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.s3_bucket = input;
            self
        }
        /// <p>The Amazon S3 bucket prefix that is the file name and path of the exported snapshot.</p>
        pub fn s3_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.s3_prefix = Some(input.into());
            self
        }
        /// <p>The Amazon S3 bucket prefix that is the file name and path of the exported snapshot.</p>
        pub fn set_s3_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.s3_prefix = input;
            self
        }
        /// <p>The name of the IAM role that is used to write to Amazon S3 when exporting a snapshot. </p>
        pub fn iam_role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.iam_role_arn = Some(input.into());
            self
        }
        /// <p>The name of the IAM role that is used to write to Amazon S3 when exporting a snapshot. </p>
        pub fn set_iam_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.iam_role_arn = input;
            self
        }
        /// <p>The key identifier of the Amazon Web Services KMS key that is used to encrypt the snapshot when it's exported to
        /// Amazon S3. The KMS key identifier is its key ARN, key ID, alias ARN, or alias name. The IAM role used for the snapshot export
        /// must have encryption and decryption permissions to use this KMS key. </p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>The key identifier of the Amazon Web Services KMS key that is used to encrypt the snapshot when it's exported to
        /// Amazon S3. The KMS key identifier is its key ARN, key ID, alias ARN, or alias name. The IAM role used for the snapshot export
        /// must have encryption and decryption permissions to use this KMS key. </p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// <p>The progress status of the export task.</p>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The progress status of the export task.</p>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// <p>The progress of the snapshot export task as a percentage.</p>
        pub fn percent_progress(mut self, input: i32) -> Self {
            self.percent_progress = Some(input);
            self
        }
        /// <p>The progress of the snapshot export task as a percentage.</p>
        pub fn set_percent_progress(mut self, input: std::option::Option<i32>) -> Self {
            self.percent_progress = input;
            self
        }
        /// <p>The total amount of data exported, in gigabytes.</p>
        pub fn total_extracted_data_in_gb(mut self, input: i32) -> Self {
            self.total_extracted_data_in_gb = Some(input);
            self
        }
        /// <p>The total amount of data exported, in gigabytes.</p>
        pub fn set_total_extracted_data_in_gb(mut self, input: std::option::Option<i32>) -> Self {
            self.total_extracted_data_in_gb = input;
            self
        }
        /// <p>The reason the export failed, if it failed.</p>
        pub fn failure_cause(mut self, input: impl Into<std::string::String>) -> Self {
            self.failure_cause = Some(input.into());
            self
        }
        /// <p>The reason the export failed, if it failed.</p>
        pub fn set_failure_cause(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.failure_cause = input;
            self
        }
        /// <p>A warning about the snapshot export task.</p>
        pub fn warning_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.warning_message = Some(input.into());
            self
        }
        /// <p>A warning about the snapshot export task.</p>
        pub fn set_warning_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.warning_message = input;
            self
        }
        /// Consumes the builder and constructs a [`CancelExportTaskOutput`](crate::output::CancelExportTaskOutput)
        pub fn build(self) -> crate::output::CancelExportTaskOutput {
            crate::output::CancelExportTaskOutput {
                export_task_identifier: self.export_task_identifier,
                source_arn: self.source_arn,
                export_only: self.export_only,
                snapshot_time: self.snapshot_time,
                task_start_time: self.task_start_time,
                task_end_time: self.task_end_time,
                s3_bucket: self.s3_bucket,
                s3_prefix: self.s3_prefix,
                iam_role_arn: self.iam_role_arn,
                kms_key_id: self.kms_key_id,
                status: self.status,
                percent_progress: self.percent_progress.unwrap_or_default(),
                total_extracted_data_in_gb: self.total_extracted_data_in_gb.unwrap_or_default(),
                failure_cause: self.failure_cause,
                warning_message: self.warning_message,
            }
        }
    }
}
impl CancelExportTaskOutput {
    /// Creates a new builder-style object to manufacture [`CancelExportTaskOutput`](crate::output::CancelExportTaskOutput)
    pub fn builder() -> crate::output::cancel_export_task_output::Builder {
        crate::output::cancel_export_task_output::Builder::default()
    }
}

/// <p>This data type is used as a response element in the <code>DescribeDBClusterBacktracks</code> action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BacktrackDbClusterOutput {
    /// <p>Contains a user-supplied DB cluster identifier. This identifier is the unique key that identifies a DB cluster.</p>
    pub db_cluster_identifier: std::option::Option<std::string::String>,
    /// <p>Contains the backtrack identifier.</p>
    pub backtrack_identifier: std::option::Option<std::string::String>,
    /// <p>The timestamp of the time to which the DB cluster was backtracked.</p>
    pub backtrack_to: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The timestamp of the time from which the DB cluster was backtracked.</p>
    pub backtracked_from: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The timestamp of the time at which the backtrack was requested.</p>
    pub backtrack_request_creation_time: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The status of the backtrack. This property returns one of the following
    /// values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>applying</code> - The backtrack is currently being applied to or rolled back from the DB cluster.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>completed</code> - The backtrack has successfully been applied to or rolled back from the DB cluster.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>failed</code> - An error occurred while the backtrack was applied to or rolled back from the DB cluster.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>pending</code> - The backtrack is currently pending application to or rollback from the DB cluster.</p>
    /// </li>
    /// </ul>
    pub status: std::option::Option<std::string::String>,
}
impl BacktrackDbClusterOutput {
    /// <p>Contains a user-supplied DB cluster identifier. This identifier is the unique key that identifies a DB cluster.</p>
    pub fn db_cluster_identifier(&self) -> std::option::Option<&str> {
        self.db_cluster_identifier.as_deref()
    }
    /// <p>Contains the backtrack identifier.</p>
    pub fn backtrack_identifier(&self) -> std::option::Option<&str> {
        self.backtrack_identifier.as_deref()
    }
    /// <p>The timestamp of the time to which the DB cluster was backtracked.</p>
    pub fn backtrack_to(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.backtrack_to.as_ref()
    }
    /// <p>The timestamp of the time from which the DB cluster was backtracked.</p>
    pub fn backtracked_from(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.backtracked_from.as_ref()
    }
    /// <p>The timestamp of the time at which the backtrack was requested.</p>
    pub fn backtrack_request_creation_time(
        &self,
    ) -> std::option::Option<&aws_smithy_types::Instant> {
        self.backtrack_request_creation_time.as_ref()
    }
    /// <p>The status of the backtrack. This property returns one of the following
    /// values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>applying</code> - The backtrack is currently being applied to or rolled back from the DB cluster.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>completed</code> - The backtrack has successfully been applied to or rolled back from the DB cluster.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>failed</code> - An error occurred while the backtrack was applied to or rolled back from the DB cluster.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>pending</code> - The backtrack is currently pending application to or rollback from the DB cluster.</p>
    /// </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&str> {
        self.status.as_deref()
    }
}
impl std::fmt::Debug for BacktrackDbClusterOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BacktrackDbClusterOutput");
        formatter.field("db_cluster_identifier", &self.db_cluster_identifier);
        formatter.field("backtrack_identifier", &self.backtrack_identifier);
        formatter.field("backtrack_to", &self.backtrack_to);
        formatter.field("backtracked_from", &self.backtracked_from);
        formatter.field(
            "backtrack_request_creation_time",
            &self.backtrack_request_creation_time,
        );
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`BacktrackDbClusterOutput`](crate::output::BacktrackDbClusterOutput)
pub mod backtrack_db_cluster_output {
    /// A builder for [`BacktrackDbClusterOutput`](crate::output::BacktrackDbClusterOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_cluster_identifier: std::option::Option<std::string::String>,
        pub(crate) backtrack_identifier: std::option::Option<std::string::String>,
        pub(crate) backtrack_to: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) backtracked_from: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) backtrack_request_creation_time: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) status: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Contains a user-supplied DB cluster identifier. This identifier is the unique key that identifies a DB cluster.</p>
        pub fn db_cluster_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.db_cluster_identifier = Some(input.into());
            self
        }
        /// <p>Contains a user-supplied DB cluster identifier. This identifier is the unique key that identifies a DB cluster.</p>
        pub fn set_db_cluster_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.db_cluster_identifier = input;
            self
        }
        /// <p>Contains the backtrack identifier.</p>
        pub fn backtrack_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.backtrack_identifier = Some(input.into());
            self
        }
        /// <p>Contains the backtrack identifier.</p>
        pub fn set_backtrack_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.backtrack_identifier = input;
            self
        }
        /// <p>The timestamp of the time to which the DB cluster was backtracked.</p>
        pub fn backtrack_to(mut self, input: aws_smithy_types::Instant) -> Self {
            self.backtrack_to = Some(input);
            self
        }
        /// <p>The timestamp of the time to which the DB cluster was backtracked.</p>
        pub fn set_backtrack_to(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.backtrack_to = input;
            self
        }
        /// <p>The timestamp of the time from which the DB cluster was backtracked.</p>
        pub fn backtracked_from(mut self, input: aws_smithy_types::Instant) -> Self {
            self.backtracked_from = Some(input);
            self
        }
        /// <p>The timestamp of the time from which the DB cluster was backtracked.</p>
        pub fn set_backtracked_from(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.backtracked_from = input;
            self
        }
        /// <p>The timestamp of the time at which the backtrack was requested.</p>
        pub fn backtrack_request_creation_time(mut self, input: aws_smithy_types::Instant) -> Self {
            self.backtrack_request_creation_time = Some(input);
            self
        }
        /// <p>The timestamp of the time at which the backtrack was requested.</p>
        pub fn set_backtrack_request_creation_time(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.backtrack_request_creation_time = input;
            self
        }
        /// <p>The status of the backtrack. This property returns one of the following
        /// values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>applying</code> - The backtrack is currently being applied to or rolled back from the DB cluster.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>completed</code> - The backtrack has successfully been applied to or rolled back from the DB cluster.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>failed</code> - An error occurred while the backtrack was applied to or rolled back from the DB cluster.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pending</code> - The backtrack is currently pending application to or rollback from the DB cluster.</p>
        /// </li>
        /// </ul>
        pub fn status(mut self, input: impl Into<std::string::String>) -> Self {
            self.status = Some(input.into());
            self
        }
        /// <p>The status of the backtrack. This property returns one of the following
        /// values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>applying</code> - The backtrack is currently being applied to or rolled back from the DB cluster.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>completed</code> - The backtrack has successfully been applied to or rolled back from the DB cluster.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>failed</code> - An error occurred while the backtrack was applied to or rolled back from the DB cluster.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>pending</code> - The backtrack is currently pending application to or rollback from the DB cluster.</p>
        /// </li>
        /// </ul>
        pub fn set_status(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`BacktrackDbClusterOutput`](crate::output::BacktrackDbClusterOutput)
        pub fn build(self) -> crate::output::BacktrackDbClusterOutput {
            crate::output::BacktrackDbClusterOutput {
                db_cluster_identifier: self.db_cluster_identifier,
                backtrack_identifier: self.backtrack_identifier,
                backtrack_to: self.backtrack_to,
                backtracked_from: self.backtracked_from,
                backtrack_request_creation_time: self.backtrack_request_creation_time,
                status: self.status,
            }
        }
    }
}
impl BacktrackDbClusterOutput {
    /// Creates a new builder-style object to manufacture [`BacktrackDbClusterOutput`](crate::output::BacktrackDbClusterOutput)
    pub fn builder() -> crate::output::backtrack_db_cluster_output::Builder {
        crate::output::backtrack_db_cluster_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AuthorizeDbSecurityGroupIngressOutput {
    /// <p>Contains the details for an Amazon RDS DB security group.
    /// </p>
    /// <p>This data type is used as a response element
    /// in the <code>DescribeDBSecurityGroups</code> action.
    /// </p>
    pub db_security_group: std::option::Option<crate::model::DbSecurityGroup>,
}
impl AuthorizeDbSecurityGroupIngressOutput {
    /// <p>Contains the details for an Amazon RDS DB security group.
    /// </p>
    /// <p>This data type is used as a response element
    /// in the <code>DescribeDBSecurityGroups</code> action.
    /// </p>
    pub fn db_security_group(&self) -> std::option::Option<&crate::model::DbSecurityGroup> {
        self.db_security_group.as_ref()
    }
}
impl std::fmt::Debug for AuthorizeDbSecurityGroupIngressOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AuthorizeDbSecurityGroupIngressOutput");
        formatter.field("db_security_group", &self.db_security_group);
        formatter.finish()
    }
}
/// See [`AuthorizeDbSecurityGroupIngressOutput`](crate::output::AuthorizeDbSecurityGroupIngressOutput)
pub mod authorize_db_security_group_ingress_output {
    /// A builder for [`AuthorizeDbSecurityGroupIngressOutput`](crate::output::AuthorizeDbSecurityGroupIngressOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) db_security_group: std::option::Option<crate::model::DbSecurityGroup>,
    }
    impl Builder {
        /// <p>Contains the details for an Amazon RDS DB security group.
        /// </p>
        /// <p>This data type is used as a response element
        /// in the <code>DescribeDBSecurityGroups</code> action.
        /// </p>
        pub fn db_security_group(mut self, input: crate::model::DbSecurityGroup) -> Self {
            self.db_security_group = Some(input);
            self
        }
        /// <p>Contains the details for an Amazon RDS DB security group.
        /// </p>
        /// <p>This data type is used as a response element
        /// in the <code>DescribeDBSecurityGroups</code> action.
        /// </p>
        pub fn set_db_security_group(
            mut self,
            input: std::option::Option<crate::model::DbSecurityGroup>,
        ) -> Self {
            self.db_security_group = input;
            self
        }
        /// Consumes the builder and constructs a [`AuthorizeDbSecurityGroupIngressOutput`](crate::output::AuthorizeDbSecurityGroupIngressOutput)
        pub fn build(self) -> crate::output::AuthorizeDbSecurityGroupIngressOutput {
            crate::output::AuthorizeDbSecurityGroupIngressOutput {
                db_security_group: self.db_security_group,
            }
        }
    }
}
impl AuthorizeDbSecurityGroupIngressOutput {
    /// Creates a new builder-style object to manufacture [`AuthorizeDbSecurityGroupIngressOutput`](crate::output::AuthorizeDbSecurityGroupIngressOutput)
    pub fn builder() -> crate::output::authorize_db_security_group_ingress_output::Builder {
        crate::output::authorize_db_security_group_ingress_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ApplyPendingMaintenanceActionOutput {
    /// <p>Describes the pending maintenance actions for a resource.</p>
    pub resource_pending_maintenance_actions:
        std::option::Option<crate::model::ResourcePendingMaintenanceActions>,
}
impl ApplyPendingMaintenanceActionOutput {
    /// <p>Describes the pending maintenance actions for a resource.</p>
    pub fn resource_pending_maintenance_actions(
        &self,
    ) -> std::option::Option<&crate::model::ResourcePendingMaintenanceActions> {
        self.resource_pending_maintenance_actions.as_ref()
    }
}
impl std::fmt::Debug for ApplyPendingMaintenanceActionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ApplyPendingMaintenanceActionOutput");
        formatter.field(
            "resource_pending_maintenance_actions",
            &self.resource_pending_maintenance_actions,
        );
        formatter.finish()
    }
}
/// See [`ApplyPendingMaintenanceActionOutput`](crate::output::ApplyPendingMaintenanceActionOutput)
pub mod apply_pending_maintenance_action_output {
    /// A builder for [`ApplyPendingMaintenanceActionOutput`](crate::output::ApplyPendingMaintenanceActionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_pending_maintenance_actions:
            std::option::Option<crate::model::ResourcePendingMaintenanceActions>,
    }
    impl Builder {
        /// <p>Describes the pending maintenance actions for a resource.</p>
        pub fn resource_pending_maintenance_actions(
            mut self,
            input: crate::model::ResourcePendingMaintenanceActions,
        ) -> Self {
            self.resource_pending_maintenance_actions = Some(input);
            self
        }
        /// <p>Describes the pending maintenance actions for a resource.</p>
        pub fn set_resource_pending_maintenance_actions(
            mut self,
            input: std::option::Option<crate::model::ResourcePendingMaintenanceActions>,
        ) -> Self {
            self.resource_pending_maintenance_actions = input;
            self
        }
        /// Consumes the builder and constructs a [`ApplyPendingMaintenanceActionOutput`](crate::output::ApplyPendingMaintenanceActionOutput)
        pub fn build(self) -> crate::output::ApplyPendingMaintenanceActionOutput {
            crate::output::ApplyPendingMaintenanceActionOutput {
                resource_pending_maintenance_actions: self.resource_pending_maintenance_actions,
            }
        }
    }
}
impl ApplyPendingMaintenanceActionOutput {
    /// Creates a new builder-style object to manufacture [`ApplyPendingMaintenanceActionOutput`](crate::output::ApplyPendingMaintenanceActionOutput)
    pub fn builder() -> crate::output::apply_pending_maintenance_action_output::Builder {
        crate::output::apply_pending_maintenance_action_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddTagsToResourceOutput {}
impl std::fmt::Debug for AddTagsToResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddTagsToResourceOutput");
        formatter.finish()
    }
}
/// See [`AddTagsToResourceOutput`](crate::output::AddTagsToResourceOutput)
pub mod add_tags_to_resource_output {
    /// A builder for [`AddTagsToResourceOutput`](crate::output::AddTagsToResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`AddTagsToResourceOutput`](crate::output::AddTagsToResourceOutput)
        pub fn build(self) -> crate::output::AddTagsToResourceOutput {
            crate::output::AddTagsToResourceOutput {}
        }
    }
}
impl AddTagsToResourceOutput {
    /// Creates a new builder-style object to manufacture [`AddTagsToResourceOutput`](crate::output::AddTagsToResourceOutput)
    pub fn builder() -> crate::output::add_tags_to_resource_output::Builder {
        crate::output::add_tags_to_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddSourceIdentifierToSubscriptionOutput {
    /// <p>Contains the results of a successful invocation of the <code>DescribeEventSubscriptions</code> action.</p>
    pub event_subscription: std::option::Option<crate::model::EventSubscription>,
}
impl AddSourceIdentifierToSubscriptionOutput {
    /// <p>Contains the results of a successful invocation of the <code>DescribeEventSubscriptions</code> action.</p>
    pub fn event_subscription(&self) -> std::option::Option<&crate::model::EventSubscription> {
        self.event_subscription.as_ref()
    }
}
impl std::fmt::Debug for AddSourceIdentifierToSubscriptionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddSourceIdentifierToSubscriptionOutput");
        formatter.field("event_subscription", &self.event_subscription);
        formatter.finish()
    }
}
/// See [`AddSourceIdentifierToSubscriptionOutput`](crate::output::AddSourceIdentifierToSubscriptionOutput)
pub mod add_source_identifier_to_subscription_output {
    /// A builder for [`AddSourceIdentifierToSubscriptionOutput`](crate::output::AddSourceIdentifierToSubscriptionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) event_subscription: std::option::Option<crate::model::EventSubscription>,
    }
    impl Builder {
        /// <p>Contains the results of a successful invocation of the <code>DescribeEventSubscriptions</code> action.</p>
        pub fn event_subscription(mut self, input: crate::model::EventSubscription) -> Self {
            self.event_subscription = Some(input);
            self
        }
        /// <p>Contains the results of a successful invocation of the <code>DescribeEventSubscriptions</code> action.</p>
        pub fn set_event_subscription(
            mut self,
            input: std::option::Option<crate::model::EventSubscription>,
        ) -> Self {
            self.event_subscription = input;
            self
        }
        /// Consumes the builder and constructs a [`AddSourceIdentifierToSubscriptionOutput`](crate::output::AddSourceIdentifierToSubscriptionOutput)
        pub fn build(self) -> crate::output::AddSourceIdentifierToSubscriptionOutput {
            crate::output::AddSourceIdentifierToSubscriptionOutput {
                event_subscription: self.event_subscription,
            }
        }
    }
}
impl AddSourceIdentifierToSubscriptionOutput {
    /// Creates a new builder-style object to manufacture [`AddSourceIdentifierToSubscriptionOutput`](crate::output::AddSourceIdentifierToSubscriptionOutput)
    pub fn builder() -> crate::output::add_source_identifier_to_subscription_output::Builder {
        crate::output::add_source_identifier_to_subscription_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddRoleToDbInstanceOutput {}
impl std::fmt::Debug for AddRoleToDbInstanceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddRoleToDbInstanceOutput");
        formatter.finish()
    }
}
/// See [`AddRoleToDbInstanceOutput`](crate::output::AddRoleToDbInstanceOutput)
pub mod add_role_to_db_instance_output {
    /// A builder for [`AddRoleToDbInstanceOutput`](crate::output::AddRoleToDbInstanceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`AddRoleToDbInstanceOutput`](crate::output::AddRoleToDbInstanceOutput)
        pub fn build(self) -> crate::output::AddRoleToDbInstanceOutput {
            crate::output::AddRoleToDbInstanceOutput {}
        }
    }
}
impl AddRoleToDbInstanceOutput {
    /// Creates a new builder-style object to manufacture [`AddRoleToDbInstanceOutput`](crate::output::AddRoleToDbInstanceOutput)
    pub fn builder() -> crate::output::add_role_to_db_instance_output::Builder {
        crate::output::add_role_to_db_instance_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddRoleToDbClusterOutput {}
impl std::fmt::Debug for AddRoleToDbClusterOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddRoleToDbClusterOutput");
        formatter.finish()
    }
}
/// See [`AddRoleToDbClusterOutput`](crate::output::AddRoleToDbClusterOutput)
pub mod add_role_to_db_cluster_output {
    /// A builder for [`AddRoleToDbClusterOutput`](crate::output::AddRoleToDbClusterOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`AddRoleToDbClusterOutput`](crate::output::AddRoleToDbClusterOutput)
        pub fn build(self) -> crate::output::AddRoleToDbClusterOutput {
            crate::output::AddRoleToDbClusterOutput {}
        }
    }
}
impl AddRoleToDbClusterOutput {
    /// Creates a new builder-style object to manufacture [`AddRoleToDbClusterOutput`](crate::output::AddRoleToDbClusterOutput)
    pub fn builder() -> crate::output::add_role_to_db_cluster_output::Builder {
        crate::output::add_role_to_db_cluster_output::Builder::default()
    }
}
